/***************************************************************************
 *    (c)2005-2013 Broadcom Corporation
 *
 * This program is the proprietary software of Broadcom Corporation and/or its licensors,
 * and may only be used, duplicated, modified or distributed pursuant to the terms and
 * conditions of a separate, written license agreement executed between you and Broadcom
 * (an "Authorized License").  Except as set forth in an Authorized License, Broadcom grants
 * no license (express or implied), right to use, or waiver of any kind with respect to the
 * Software, and Broadcom expressly reserves all rights in and to the Software and all
 * intellectual property rights therein.  IF YOU HAVE NO AUTHORIZED LICENSE, THEN YOU
 * HAVE NO RIGHT TO USE THIS SOFTWARE IN ANY WAY, AND SHOULD IMMEDIATELY
 * NOTIFY BROADCOM AND DISCONTINUE ALL USE OF THE SOFTWARE.
 *
 * Except as expressly set forth in the Authorized License,
 *
 * 1.     This program, including its structure, sequence and organization, constitutes the valuable trade
 * secrets of Broadcom, and you shall use all reasonable efforts to protect the confidentiality thereof,
 * and to use this information only in connection with your use of Broadcom integrated circuit products.
 *
 * 2.     TO THE MAXIMUM EXTENT PERMITTED BY LAW, THE SOFTWARE IS PROVIDED "AS IS"
 * AND WITH ALL FAULTS AND BROADCOM MAKES NO PROMISES, REPRESENTATIONS OR
 * WARRANTIES, EITHER EXPRESS, IMPLIED, STATUTORY, OR OTHERWISE, WITH RESPECT TO
 * THE SOFTWARE.  BROADCOM SPECIFICALLY DISCLAIMS ANY AND ALL IMPLIED WARRANTIES
 * OF TITLE, MERCHANTABILITY, NONINFRINGEMENT, FITNESS FOR A PARTICULAR PURPOSE,
 * LACK OF VIRUSES, ACCURACY OR COMPLETENESS, QUIET ENJOYMENT, QUIET POSSESSION
 * OR CORRESPONDENCE TO DESCRIPTION. YOU ASSUME THE ENTIRE RISK ARISING OUT OF
 * USE OR PERFORMANCE OF THE SOFTWARE.
 *
 * 3.     TO THE MAXIMUM EXTENT PERMITTED BY LAW, IN NO EVENT SHALL BROADCOM OR ITS
 * LICENSORS BE LIABLE FOR (i) CONSEQUENTIAL, INCIDENTAL, SPECIAL, INDIRECT, OR
 * EXEMPLARY DAMAGES WHATSOEVER ARISING OUT OF OR IN ANY WAY RELATING TO YOUR
 * USE OF OR INABILITY TO USE THE SOFTWARE EVEN IF BROADCOM HAS BEEN ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGES; OR (ii) ANY AMOUNT IN EXCESS OF THE AMOUNT
 * ACTUALLY PAID FOR THE SOFTWARE ITSELF OR U.S. $1, WHICHEVER IS GREATER. THESE
 * LIMITATIONS SHALL APPLY NOTWITHSTANDING ANY FAILURE OF ESSENTIAL PURPOSE OF
 * ANY LIMITED REMEDY.
 *
 ***************************************************************************/

#include "nexus_memory.h"
#include "nexus_types.h"

#include "core/palette.h"
#include "gfx/convert.h"

#include "bcmnexus_utils.h"

NEXUS_PixelFormat
bcmnexus_getNexusPixelFormat(DFBSurfacePixelFormat format)
{
    NEXUS_PixelFormat eFormat;

    switch (format)
    {
    /* Constant Colour Formats */
    case DSPF_A1:
        eFormat = NEXUS_PixelFormat_eA1;
        break;
    case DSPF_A4:
        eFormat = NEXUS_PixelFormat_eA4;
        break;
    case DSPF_A8:
        eFormat = NEXUS_PixelFormat_eA8;
        break;

    /* Palette Formats */
    case DSPF_LUT1:
        eFormat = NEXUS_PixelFormat_ePalette1;
        break;
    case DSPF_LUT2:
        eFormat = NEXUS_PixelFormat_ePalette2;
        break;
    case DSPF_LUT4:
        eFormat = NEXUS_PixelFormat_ePalette4;
        break;
    case DSPF_LUT8:
        eFormat = NEXUS_PixelFormat_ePalette8;
        break;
    case DSPF_ALUT8:
        eFormat = NEXUS_PixelFormat_eA8_Palette8;
        break;

    /* 16-bit RGB formats */
    case DSPF_RGB444:
        eFormat = NEXUS_PixelFormat_eX4_R4_G4_B4;
        break;
    case DSPF_RGB555:
        eFormat = NEXUS_PixelFormat_eX1_R5_G5_B5;
        break;
    case DSPF_BGR555:
        eFormat = NEXUS_PixelFormat_eX1_B5_G5_R5;
        break;
    case DSPF_ARGB1555:
        eFormat = NEXUS_PixelFormat_eA1_R5_G5_B5;
        break;
    case DSPF_RGB16:
        eFormat = NEXUS_PixelFormat_eR5_G6_B5;
        break;
    case DSPF_ARGB4444:
        eFormat = NEXUS_PixelFormat_eA4_R4_G4_B4;
        break;
    case DSPF_RGBA4444:
        eFormat = NEXUS_PixelFormat_eR4_G4_B4_A4;
        break;

    /* 24-bit RGB formats */
    /* Nexus does not support 24-bit RGB see nexus_types.h*/
#if 0
    case DSPF_RGB24:
    /* Nexus does not support 24-bit RGB */
        eFormat = NEXUS_PixelFormat_eR8_G8_B8;
        break;
#endif
    /* 32-bit RGB formats */
    case DSPF_ARGB:
        eFormat = NEXUS_PixelFormat_eA8_R8_G8_B8;
        break;
    case DSPF_ABGR:
        eFormat = NEXUS_PixelFormat_eA8_B8_G8_R8;
        break;
    case DSPF_RGB32:
        eFormat = NEXUS_PixelFormat_eX8_R8_G8_B8;
        break;

    /* YUV formats */
    case DSPF_YUY2:
        eFormat = NEXUS_PixelFormat_eCr8_Y18_Cb8_Y08;
        break;
    case DSPF_UYVY:
        eFormat = NEXUS_PixelFormat_eY18_Cr8_Y08_Cb8;
      break;
    case DSPF_AYUV:
        eFormat = NEXUS_PixelFormat_eA8_Y8_Cb8_Cr8;
        break;
    default:
        eFormat = NEXUS_PixelFormat_eUnknown;
        break;
    }
    return eFormat;
}

DFBSurfacePixelFormat
bcmnexus_getDFBSurfacePixelFormat(NEXUS_PixelFormat format)
{
    DFBSurfacePixelFormat eFormat;

    switch (format)
    {
    /* Constant Colour Formats */
    case NEXUS_PixelFormat_eA1:
        eFormat = DSPF_A1;
        break;
    case NEXUS_PixelFormat_eA4:
        eFormat = DSPF_A4;
        break;
    case NEXUS_PixelFormat_eA8:
        eFormat = DSPF_A8;
        break;

    /* Palette Formats */
    case NEXUS_PixelFormat_ePalette1:
        eFormat = DSPF_LUT1;
        break;
    case NEXUS_PixelFormat_ePalette2:
        eFormat = DSPF_LUT2;
        break;
    case NEXUS_PixelFormat_ePalette4:
        eFormat = DSPF_LUT4;
        break;
    case NEXUS_PixelFormat_ePalette8:
        eFormat = DSPF_LUT8;
        break;
    case NEXUS_PixelFormat_eA8_Palette8:
        eFormat = DSPF_ALUT8;
        break;

    /* 16-bit RGB formats */
    case NEXUS_PixelFormat_eX4_R4_G4_B4:
        eFormat = DSPF_RGB444;
        break;
    case NEXUS_PixelFormat_eX1_R5_G5_B5:
        eFormat = DSPF_RGB555;
        break;
    case NEXUS_PixelFormat_eX1_B5_G5_R5:
        eFormat = DSPF_BGR555;
        break;
    case NEXUS_PixelFormat_eA1_R5_G5_B5:
        eFormat = DSPF_ARGB1555;
        break;
    case NEXUS_PixelFormat_eR5_G6_B5:
        eFormat = DSPF_RGB16;
        break;
    case NEXUS_PixelFormat_eA4_R4_G4_B4:
        eFormat = DSPF_ARGB4444;
        break;
    case NEXUS_PixelFormat_eR4_G4_B4_A4:
        eFormat = DSPF_RGBA4444;
        break;

    /* 24-bit RGB formats */
    case NEXUS_PixelFormat_eR8_G8_B8:
        eFormat = DSPF_RGB24;
        break;

    /* 32-bit RGB formats */
    case NEXUS_PixelFormat_eX8_R8_G8_B8:
        eFormat = DSPF_RGB32;
        break;
    case NEXUS_PixelFormat_eA8_B8_G8_R8:
        eFormat = DSPF_ABGR;
        break;

    /* YUV formats */
    case NEXUS_PixelFormat_eCr8_Y18_Cb8_Y08:
        eFormat = DSPF_YUY2;
        break;
    case NEXUS_PixelFormat_eY18_Cr8_Y08_Cb8:
        eFormat = DSPF_UYVY;
      break;
    case NEXUS_PixelFormat_eA8_Y8_Cb8_Cr8:
        eFormat = DSPF_AYUV;
        break;
    default:
        eFormat = DSPF_ARGB;
        break;
    }
    return eFormat;
}

DFB_PlatformPixelFormat
bcmnexus_getDFBPlatformPixelFormat(DFBSurfacePixelFormat format)
{
    DFB_PlatformPixelFormat eFormat;

    switch (format)
    {
        case DSPF_ARGB1555:
            eFormat = DFB_PLATFORM_PIXELFORMAT_ARGB1555;
            break;

        case DSPF_RGB16:
            eFormat = DFB_PLATFORM_PIXELFORMAT_RGB16;
            break;

        case DSPF_RGB24:
            eFormat = DFB_PLATFORM_PIXELFORMAT_RGB24;
            break;

        case DSPF_RGB32:
            eFormat = DFB_PLATFORM_PIXELFORMAT_RGB32;
            break;

        case DSPF_ARGB:
            eFormat = DFB_PLATFORM_PIXELFORMAT_ARGB;
            break;

        case DSPF_A8:
            eFormat = DFB_PLATFORM_PIXELFORMAT_A8;
            break;

        case DSPF_YUY2:
            eFormat = DFB_PLATFORM_PIXELFORMAT_YUY2;
            break;

        case DSPF_RGB332:
            eFormat = DFB_PLATFORM_PIXELFORMAT_RGB332;
            break;

        case DSPF_UYVY:
            eFormat = DFB_PLATFORM_PIXELFORMAT_UYVY;
            break;

        case DSPF_I420:
            eFormat = DFB_PLATFORM_PIXELFORMAT_I420;
            break;

        case DSPF_YV12:
            eFormat = DFB_PLATFORM_PIXELFORMAT_YV12;
            break;

        case DSPF_LUT8:
            eFormat = DFB_PLATFORM_PIXELFORMAT_LUT8;
            break;

        case DSPF_ALUT44:
            eFormat = DFB_PLATFORM_PIXELFORMAT_ALUT44;
            break;

        case DSPF_AiRGB:
            eFormat = DFB_PLATFORM_PIXELFORMAT_AiRGB;
            break;

        case DSPF_A1:
            eFormat = DFB_PLATFORM_PIXELFORMAT_A1;
            break;

        case DSPF_NV12:
            eFormat = DFB_PLATFORM_PIXELFORMAT_NV12;
            break;

        case DSPF_NV16:
            eFormat = DFB_PLATFORM_PIXELFORMAT_NV16;
            break;

        case DSPF_ARGB2554:
            eFormat = DFB_PLATFORM_PIXELFORMAT_ARGB2554;
            break;

        case DSPF_ARGB4444:
            eFormat = DFB_PLATFORM_PIXELFORMAT_ARGB4444;
            break;

        case DSPF_RGBA4444:
            eFormat = DFB_PLATFORM_PIXELFORMAT_RGBA4444;
            break;

        case DSPF_NV21:
            eFormat = DFB_PLATFORM_PIXELFORMAT_NV21;
            break;

        case DSPF_AYUV:
            eFormat = DFB_PLATFORM_PIXELFORMAT_AYUV;
            break;

        case DSPF_A4:
            eFormat = DFB_PLATFORM_PIXELFORMAT_A4;
            break;

        case DSPF_ARGB1666:
            eFormat = DFB_PLATFORM_PIXELFORMAT_ARGB1666;
            break;

        case DSPF_ARGB6666:
            eFormat = DFB_PLATFORM_PIXELFORMAT_ARGB6666;
            break;

        case DSPF_RGB18:
            eFormat = DFB_PLATFORM_PIXELFORMAT_RGB18;
            break;

        case DSPF_LUT1:
            eFormat = DFB_PLATFORM_PIXELFORMAT_LUT1;
            break;

        case DSPF_LUT2:
            eFormat = DFB_PLATFORM_PIXELFORMAT_LUT2;
            break;

        case DSPF_RGB444:
            eFormat = DFB_PLATFORM_PIXELFORMAT_RGB444;
            break;

        case DSPF_RGB555:
            eFormat = DFB_PLATFORM_PIXELFORMAT_RGB555;
            break;

        case DSPF_BGR555:
            eFormat = DFB_PLATFORM_PIXELFORMAT_BGR555;
            break;

        case DSPF_LUT4:
            eFormat = DFB_PLATFORM_PIXELFORMAT_LUT4;
            break;

        case DSPF_RGBA5551:
            eFormat = DFB_PLATFORM_PIXELFORMAT_RGBA5551;
            break;

        case DSPF_YUV444P:
            eFormat = DFB_PLATFORM_PIXELFORMAT_YUV444P;
            break;

        case DSPF_ARGB8565:
            eFormat = DFB_PLATFORM_PIXELFORMAT_ARGB8565;
            break;

        case DSPF_AVYU:
            eFormat = DFB_PLATFORM_PIXELFORMAT_AVYU;
            break;

        case DSPF_VYU:
            eFormat = DFB_PLATFORM_PIXELFORMAT_VYU;
            break;

        case DSPF_A1_LSB:
            eFormat = DFB_PLATFORM_PIXELFORMAT_A1_LSB;
            break;

        case DSPF_YV16:
            eFormat = DFB_PLATFORM_PIXELFORMAT_YV16;
            break;

        case DSPF_ABGR:
            eFormat = DFB_PLATFORM_PIXELFORMAT_ABGR;
            break;

        case DSPF_ALUT8:
            eFormat = DFB_PLATFORM_PIXELFORMAT_ALUT8;
            break;

        default:
            eFormat = DFB_PLATFORM_PIXELFORMAT_UNKNOWN;
            break;
    }
    return eFormat;
}

void
copy_palette( CoreSurface *surface, NEXUS_SurfaceHandle hSurface )
{
    CorePalette        *palette;
    NEXUS_SurfaceMemory memory;
    unsigned int        i;

    if (hSurface && ((surface->config.format==DSPF_LUT8) || (surface->config.format==DSPF_ALUT8) ||
                     (surface->config.format==DSPF_LUT4) || (surface->config.format==DSPF_LUT2)  ||
                     (surface->config.format==DSPF_LUT1)))
    {
        NEXUS_Surface_GetMemory(hSurface, &memory);
        palette = surface->palette;
        for (i=0; i<palette->num_entries; i++)
        {
            memory.palette[i] = PIXEL_ARGB(
                palette->entries[i].a,
                palette->entries[i].r,
                palette->entries[i].g,
                palette->entries[i].b);
        }
        memory.numPaletteEntries = palette->num_entries;
        NEXUS_Memory_FlushCache(memory.palette, sizeof(NEXUS_Pixel) * memory.numPaletteEntries);
    }
}

