#include <++dfb.h>

#include <direct/messages.h>

#include <dirent.h>
#include <dlfcn.h>

#include <Insignia.h>
#include <InsigniaException.h>
#include <InsigniaTestManager.h>

// reading a Log file
#include <iostream>
#include <fstream>
#include <string>
#include <stdlib.h>

#define PASS_THRESHOLD 4
#define INSIGNIA_LOGFILE "/tmp/insignia.txt"

using namespace std;

int
insignia_main( int argc, char *argv[] )
{
     Insignia::App  insignia;
     DIR           *dir;
     struct dirent *entry;
     char command[ sizeof(INSIGNIA_LOGFILE) + sizeof("rm -f ") + 1];

     //Delete old log file
     sprintf(command, "rm -f %s", INSIGNIA_LOGFILE);

     system(command);

     //Set Insignia log file
     DirectFBInit( &argc, &argv );
     DirectFBSetOption("log-file",INSIGNIA_LOGFILE);

     dir = opendir( MODULEDIR );
     if (!dir) {
          D_PERROR( "Could not open module directory '%s'!\n", MODULEDIR );
          return -1;
     }

     while ((entry = readdir( dir )) != NULL) {
          char buf[500];
          int  len = strlen(entry->d_name);

          if (len < 4 || entry->d_name[len-1] != 'o' || entry->d_name[len-2] != 'I' || entry->d_name[len-3] != '.')
               continue;

          snprintf( buf, sizeof(buf), "%s/%s", MODULEDIR, entry->d_name );

          if (!dlopen( buf, RTLD_NOW ))
               D_DLERROR( "Could not load module '%s'!\n", buf );
     }

     closedir( dir );

     try {
          insignia.Init( argc, argv );
          insignia.RunTests();
     }
     catch (DFBException *ex) {
          cerr << endl;
          cerr << "Caught DirectFB exception!" << endl;
          cerr << "  -- " << ex << endl;
     }
     catch (Insignia::Exception *ex) {
          cerr << endl;
          cerr << "Caught Insignia exception!" << endl;
          cerr << "  -- " << ex << endl;
     }

    //Parse the Insignia log file. There are four tests, Logfile indicates how many tests failed.
    //Expected log:
    //'DFBTestBlitting'  ... (0 failures)
    //'DFBTestFX'        ... (0 failures)
    //'DFBTestInterlocks'... (0 failures)
    //'DFBTestPrimary'   ... (0 failures)

    string line("");
    string needle("(0 failures)");
    size_t needleLength = needle.length();
    unsigned int passCount = 0;
    size_t found=0;

    ifstream logFile(INSIGNIA_LOGFILE);

    if(logFile.is_open()) {

        while (logFile.good()) {

            getline(logFile, line);

            if(line.length() > needleLength) {

                //Find the needle
                found = line.find(needle);

                if(found != string::npos)

                    ++passCount;
            }

        }
    }
    else {
        cout << "Error: Insignia tests: Could not open Log file!" << endl;
    }

    logFile.close();

     //Check that all four tests passed with 0 Faulures.
     if(passCount == PASS_THRESHOLD){

        return 0;

     }
     else {

         cout << "Insignia Tests Failed. Check " << INSIGNIA_LOGFILE << " for more defails" << endl;

        return -1;

     }
}

