#!/bin/sh

CONFIG_FILE="/usr/bin/GetConfigFile"
RDKSSACLI="/usr/bin/rdkssacli"
DEVICE_CERT="devicecert_1.pk12"
STATIC_CERT="/etc/ssl/certs/staticXpkiCrt.pk12"
XPKIEXTRACT="/tmp/.adzvfchigc1ssa"
CFG_IN="/tmp/.cfgStaticxpki"
CERT_FILE="/tmp/.adzvfchigc1ssaf1"
CA_FILE="/tmp/.adzvfchigc1ssaf2"

echo_t()
{
    echo "`date +"%y%m%d-%T.%6N"` $1"
}

extract_stunnel_client_cert()
{
    if [ -f $CERT_FILE -a -f $CA_FILE ]; then
        echo_t "STUNNEL: Extracted cert & CA file already available"
        return
    elif [ -f $DEVICE_CERT_PATH/$DEVICE_CERT -a -f $RDKSSACLI ]; then
        echo_t "STUNNEL: Using dynamic cert"
        PASSCODE='$RDKSSACLI "{STOR=GET,SRC=kquhqtoczcbx,DST=/dev/stdout}"'
        CERT_PATH=$DEVICE_CERT_PATH/$DEVICE_CERT
    elif [ -f $STATIC_CERT -a -f $CONFIG_FILE ]; then
        echo_t "STUNNEL: No $DEVICE_CERT_PATH/$DEVICE_CERT using static cert"
        if [ ! -f $CFG_IN ]; then
             $CONFIG_FILE $CFG_IN
             if [ ! -f $CFG_IN ]; then
                 echo_t "STUNNEL: $CFG_IN not available"
                 exit 1
             fi
        fi
        PASSCODE="cat $CFG_IN"
        CERT_PATH=$STATIC_CERT
    else
        echo_t "STUNNEL: No valid certs present. Exiting..."
        exit 1
    fi

    eval $PASSCODE | openssl pkcs12 -nodes -passin stdin -in $CERT_PATH -out $XPKIEXTRACT
    ret=$?
    if [ $ret -ne 0 ]; then
        rm -f $XPKIEXTRACT
        echo_t "STUNNEL: Cert extraction failed. Exiting..."
        exit $ret
    fi
    sed -n '/--BEGIN PRIVATE KEY--/,/--END PRIVATE KEY--/p; /--END PRIVATE KEY--/q' $XPKIEXTRACT  > $CERT_FILE
    sed -n '/--BEGIN CERTIFICATE--/,/--END CERTIFICATE--/p; /--END CERTIFICATE--/q' $XPKIEXTRACT  >> $CERT_FILE
    rm -f $XPKIEXTRACT
    eval $PASSCODE | openssl pkcs12 -cacerts -nokeys -chain -passin stdin -in $CERT_PATH |  sed -ne '/-BEGIN CERTIFICATE-/,/-END CERTIFICATE-/p' > $CA_FILE
    ret=$?
    if [ $ret -ne 0 ]; then
        echo_t "STUNNEL: CA file extraction failed. Exiting..."
        rm -f $CERT_FILE
        exit $ret
    fi
}
