;; R4600, R4650, and R4700 pipeline description.
;;   Copyright (C) 2004-2019 Free Software Foundation, Inc.
;;
;; This file is part of GCC.

;; GCC is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published
;; by the Free Software Foundation; either version 3, or (at your
;; option) any later version.

;; GCC is distributed in the hope that it will be useful, but WITHOUT
;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
;; or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
;; License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GCC; see the file COPYING3.  If not see
;; <http://www.gnu.org/licenses/>.


;; This file overrides parts of generic.md.  It is derived from the
;; old define_function_unit description.
;;
;; We handle the R4600, R4650, and R4700 in much the same way.  The only
;; differences between R4600 and R4650 are the integer multiplication and
;; division costs. The only differences between R4600 and R4700 are the
;; integer and floating-point multiplication costs.

(define_insn_reservation "r4600_imul_si" 10
  (and (eq_attr "cpu" "r4600")
       (eq_attr "type" "imul,imul3,imadd")
       (eq_attr "mode" "SI"))
  "imuldiv*10")

(define_insn_reservation "r4600_imul_di" 12
  (and (eq_attr "cpu" "r4600")
       (eq_attr "type" "imul,imul3,imadd")
       (eq_attr "mode" "DI"))
  "imuldiv*12")

(define_insn_reservation "r4600_idiv_si" 42
  (and (eq_attr "cpu" "r4600,r4700")
       (eq_attr "type" "idiv")
       (eq_attr "mode" "SI"))
  "imuldiv*42")

(define_insn_reservation "r4600_idiv_di" 74
  (and (eq_attr "cpu" "r4600,r4700")
       (eq_attr "type" "idiv")
       (eq_attr "mode" "DI"))
  "imuldiv*74")


(define_insn_reservation "r4650_imul" 4
  (and (eq_attr "cpu" "r4650")
       (eq_attr "type" "imul,imul3,imadd"))
  "imuldiv*4")

(define_insn_reservation "r4650_idiv" 36
  (and (eq_attr "cpu" "r4650")
       (eq_attr "type" "idiv"))
  "imuldiv*36")


(define_insn_reservation "r4700_imul_si" 8
  (and (eq_attr "cpu" "r4700")
       (eq_attr "type" "imul,imul3,imadd")
       (eq_attr "mode" "SI"))
  "imuldiv*8")

(define_insn_reservation "r4700_imul_di" 10
  (and (eq_attr "cpu" "r4700")
       (eq_attr "type" "imul,imul3,imadd")
       (eq_attr "mode" "DI"))
  "imuldiv*10")


(define_insn_reservation "r4600_load" 2
  (and (eq_attr "cpu" "r4600,r4650,r4700")
       (eq_attr "type" "load,fpload,fpidxload"))
  "alu")

(define_insn_reservation "r4600_fmove" 1
  (and (eq_attr "cpu" "r4600,r4650,r4700")
       (eq_attr "type" "fabs,fneg,fmove"))
  "alu")

(define_insn_reservation "r4600_fmul_single" 8
  (and (eq_attr "cpu" "r4600,r4650")
       (and (eq_attr "type" "fmul,fmadd")
	    (eq_attr "mode" "SF")))
  "alu")


(define_insn_reservation "r4700_fmul_single" 4
  (and (eq_attr "cpu" "r4700")
       (and (eq_attr "type" "fmul,fmadd")
	    (eq_attr "mode" "SF")))
  "alu")

(define_insn_reservation "r4700_fmul_double" 5
  (and (eq_attr "cpu" "r4700")
       (and (eq_attr "type" "fmul,fmadd")
	    (eq_attr "mode" "DF")))
  "alu")


(define_insn_reservation "r4600_fdiv_single" 32
  (and (eq_attr "cpu" "r4600,r4650,r4700")
       (and (eq_attr "type" "fdiv,frdiv")
	    (eq_attr "mode" "SF")))
  "alu")

(define_insn_reservation "r4600_fdiv_double" 61
  (and (eq_attr "cpu" "r4600,r4650,r4700")
       (and (eq_attr "type" "fdiv,frdiv")
	    (eq_attr "mode" "DF")))
  "alu")

(define_insn_reservation "r4600_fsqrt_single" 31
  (and (eq_attr "cpu" "r4600,r4650,r4700")
       (and (eq_attr "type" "fsqrt,frsqrt")
	    (eq_attr "mode" "SF")))
  "alu")

(define_insn_reservation "r4600_fsqrt_double" 60
  (and (eq_attr "cpu" "r4600,r4650,r4700")
       (and (eq_attr "type" "fsqrt,frsqrt")
	    (eq_attr "mode" "DF")))
  "alu")
