
.PHONY: insignia-all insignia-source insignia-check-config insignia-config insignia insignia-compile insignia-install insignia-uninstall
.PHONY: insignia-clean insignia-distclean insignia-mrproper


############################################################
#
# insignia-all: force Insignia to be configured and compiled.
#
insignia-all: insignia-config insignia-compile insignia-install

##
#
# insignia-source: unpack the Insignia source code.
#
insignia-source: check ${INSIGNIA_UNPACKED_FLAG}

##
#
# insignia-check-config: check to see whether the build environment or build options have changed
#                        since the last build.  If they have, then this will force a clean and
#                        then a rebuild of Insignia.
#
insignia-check-config: insignia-source ${INSIGNIA_CONFIGURATION_FLAG}

##
#
# insignia-autogen: force configure and autoconf .in files to be regenerated.
#
insignia-autogen: check-autogen-tools insignia-check-config
	@$(ECHO) "***********************************************"; \
	$(ECHO)  "* Autogenerating Insignia-${INSIGNIA_VERSION} Configuration *"; \
	$(ECHO)  "***********************************************"; \
	if [ -e "${INSIGNIA_CONFIGURED_FLAG}" ]; then \
		$(RM) ${INSIGNIA_CONFIGURED_FLAG}; \
	fi; \
	$(CD) ${INSIGNIA_SRC_DIR}; \
	$(EXPORT) CPPFLAGS="${BRCM_CPPFLAGS}"; \
	$(EXPORT) CXXFLAGS="${BRCM_CPPFLAGS}"; \
	$(EXPORT) AS=${AS}; \
	$(EXPORT) LD=${LD}; \
	$(EXPORT) LDFLAGS="${LDFLAGS} -L${DIRECTFB_INSTALL_LIB_DIR}"; \
	$(EXPORT) CC=${CC}; \
	$(EXPORT) CXX=${CXX}; \
	$(EXPORT) AR=${AR}; \
	$(EXPORT) NM=${NM}; \
	$(EXPORT) STRIP=${STRIP}; \
	$(EXPORT) OBJCOPY=${OBJCOPY}; \
	$(EXPORT) OBJDUMP=${OBJDUMP}; \
	$(EXPORT) RANLIB=${RANLIB}; \
	$(EXPORT) PKG_CONFIG_LIBDIR=${DIRECTFB_INSTALL_LIB_DIR}; \
	$(EXPORT) PKG_CONFIG_PATH=${DIRECTFB_INSTALL_PKG_CONFIG_DIR}; \
	autoreconf; \
	./configure $(INSIGNIA_CONFIG_FLAGS); \
	if [ $$? -ne 0 ]; then \
		$(ECHO) -e "\n******************************************************"; \
	    $(ECHO) "* ERROR: Failed to autogenerate Insignia - Aborting! *"; \
		$(ECHO) "******************************************************"; \
	    $(FALSE); \
	else \
		$(TOUCH) ${INSIGNIA_CONFIGURED_FLAG}; \
	fi

##
#
# insignia-config: force Insignia to be configured.
#
insignia-config: insignia-check-config
	@if [ -e "${INSIGNIA_CONFIGURED_FLAG}" ]; then \
		$(RM) ${INSIGNIA_CONFIGURED_FLAG}; \
	fi
	@$(call fn-insignia-configure)

##
#
# insignia-compile: force Insignia to be compiled (tracks changes to source code files)
#
insignia-compile: ${INSIGNIA_CONFIGURED_FLAG}
	@if [ -e "${INSIGNIA_COMPILED_FLAG}" ]; then \
		$(RM) ${INSIGNIA_COMPILED_FLAG}; \
	fi
	@$(call fn-insignia-compile)

##
#
# insignia-install: force Insignia to be installed (tracks changes to source code files)
#
insignia-install: ${INSIGNIA_COMPILED_FLAG}
	@if [ -e "${INSIGNIA_INSTALLED_FLAG}" ]; then \
		$(RM) ${INSIGNIA_INSTALLED_FLAG}; \
	fi
	@$(call fn-insignia-install)

##
#
# insignia: force Insignia to be compiled and installed in one pass (tracks changes to source code files)
#
insignia: insignia-install

##
#
# insignia-uninstall: force Insignia to be uninstalled
#
insignia-uninstall:
	@if [ -e "${INSIGNIA_INSTALLED_FLAG}" ]; then \
		$(RM) ${INSIGNIA_INSTALLED_FLAG}; \
	fi
	@if [ -e "${INSIGNIA_INSTALL_BIN_INS_VER_DIR}/runins.sh" ]; then \
		$(RM) ${INSIGNIA_INSTALL_BIN_INS_VER_DIR}/runins.sh; \
	fi
	@-if [ -e "${INSIGNIA_SRC_DIR}/Makefile" ]; then \
		${MAKE} -C ${INSIGNIA_SRC_DIR} uninstall DESTDIR=${INSIGNIA_INSTALL_DIR}; \
	fi

##
#
# insignia-clean: remove all intermediate object and dependency files.
#
insignia-clean: insignia-uninstall
	@if [ -e "${INSIGNIA_COMPILED_FLAG}" ]; then \
		$(RM) ${INSIGNIA_COMPILED_FLAG}; \
	fi
	@if [ -e "${INSIGNIA_FLAG}" ]; then \
		$(RM) ${INSIGNIA_FLAG}; \
	fi
	@-if [ -e "${INSIGNIA_SRC_DIR}/Makefile" ]; then \
		${MAKE} -C ${INSIGNIA_SRC_DIR} clean; \
	fi

##
#
# insignia-distclean: remove all Insignia files including the option of
#                     removing the complete source tree.
#
insignia-distclean: insignia-clean
	@-$(call fn-insignia-distclean)
	@if [ -d "${INSIGNIA_SRC_DIR}" ]; then \
		$(ECHO) "WARNING: This will remove ${INSIGNIA_SRC_DIR} completely."; \
		$(READ) -n1 -p "Do you want to continue to remove it [Y/N]?: "; \
		$(ECHO) "" ; \
		if [ "$$REPLY" == "y" -o "$$REPLY" == "Y" ]; then \
			$(ECHO) "Removing ${INSIGNIA_SRC_DIR}..."; \
			$(RM) -r ${INSIGNIA_SRC_DIR}; \
		fi; \
	fi

##
#
# insignia-mrproper: remove all Insignia files including the
#                  complete source tree.
#
insignia-mrproper: insignia-clean
	@-$(call fn-insignia-distclean)
	@if [ -d "${INSIGNIA_SRC_DIR}" ]; then \
		$(RM) -r ${INSIGNIA_SRC_DIR}; \
	fi

##
#
# fn-insignia-configure: function to configure Insignia.
#
define fn-insignia-configure
	$(ECHO) "******************************"; \
	$(ECHO) "* Configuring Insignia-${INSIGNIA_VERSION} *"; \
	$(ECHO) "******************************"; \
	$(CD) ${INSIGNIA_SRC_DIR}; \
	$(EXPORT) CPPFLAGS="${BRCM_CPPFLAGS}"; \
	$(EXPORT) CXXFLAGS="${BRCM_CPPFLAGS}"; \
	$(EXPORT) AS=${AS}; \
	$(EXPORT) LD=${LD}; \
	$(EXPORT) LDFLAGS="${LDFLAGS} -lz -lpng -L${DIRECTFB_INSTALL_LIB_DIR}"; \
	$(EXPORT) LIBS="$(DFB_LIBS)"; \
	$(EXPORT) CC=${CC}; \
	$(EXPORT) CXX=${CXX}; \
	$(EXPORT) AR=${AR}; \
	$(EXPORT) NM=${NM}; \
	$(EXPORT) STRIP=${STRIP}; \
	$(EXPORT) OBJCOPY=${OBJCOPY}; \
	$(EXPORT) OBJDUMP=${OBJDUMP}; \
	$(EXPORT) RANLIB=${RANLIB}; \
	$(EXPORT) PKG_CONFIG_LIBDIR=${DIRECTFB_INSTALL_LIB_DIR}; \
	$(EXPORT) PKG_CONFIG_PATH=${DIRECTFB_INSTALL_PKG_CONFIG_DIR}; \
	./configure $(INSIGNIA_CONFIG_FLAGS); \
	if [ $$? -ne 0 ]; then \
		$(ECHO) -e "\n***************************************************"; \
	    $(ECHO) "* ERROR: Failed to configure Insignia - Aborting! *"; \
		$(ECHO) "***************************************************"; \
	    $(FALSE); \
	else \
		$(TOUCH) ${INSIGNIA_CONFIGURED_FLAG}; \
	fi
endef

##
#
# fn-insignia-compile: function to compile Insignia.
#
define fn-insignia-compile
	$(ECHO) "***************************"; \
	$(ECHO) "* Building Insignia-${INSIGNIA_VERSION} *"; \
	$(ECHO) "***************************"; \
	$(CD) ${INSIGNIA_SRC_DIR}; \
	$(EXPORT) AS=${AS}; \
	$(EXPORT) LD=${LD}; \
	$(EXPORT) LDFLAGS="${LDFLAGS} -lz -lpng -L${DIRECTFB_INSTALL_LIB_DIR}"; \
	$(EXPORT) CC=${CC}; \
	$(EXPORT) CXX=${CXX}; \
	$(EXPORT) AR=${AR}; \
	$(EXPORT) NM=${NM}; \
	$(EXPORT) STRIP=${STRIP}; \
	$(EXPORT) OBJCOPY=${OBJCOPY}; \
	$(EXPORT) OBJDUMP=${OBJDUMP}; \
	$(EXPORT) RANLIB=${RANLIB}; \
	$(EXPORT) BUILD_DIR="${DIRECTFB_BUILD_VER_DIR}"; \
	${MAKE} ${MAKE_OPTIONS} DESTDIR=${INSIGNIA_INSTALL_DIR} LIBS=$(DFB_LIBS); \
	if [ $$? -ne 0 ]; then \
		$(ECHO) -e "\n***********************************************"; \
	    $(ECHO) "* ERROR: Failed to build Insignia - Aborting! *"; \
		$(ECHO) "***********************************************"; \
	    $(FALSE); \
	else \
		$(TOUCH) ${INSIGNIA_COMPILED_FLAG}; \
	fi
endef

##
#
# fn-insignia-install: function to install Insignia.
#
define fn-insignia-install
	$(ECHO) "*****************************"; \
	$(ECHO) "* Installing Insignia-${INSIGNIA_VERSION} *"; \
	$(ECHO) "*****************************"; \
	$(CD) ${INSIGNIA_SRC_DIR}; \
	$(EXPORT) AS=${AS}; \
	$(EXPORT) LD=${LD}; \
	$(EXPORT) LDFLAGS="${LDFLAGS} -L${DIRECTFB_INSTALL_LIB_DIR}"; \
	$(EXPORT) CC=${CC}; \
	$(EXPORT) CXX=${CXX}; \
	$(EXPORT) AR=${AR}; \
	$(EXPORT) NM=${NM}; \
	$(EXPORT) STRIP=${STRIP}; \
	$(EXPORT) OBJCOPY=${OBJCOPY}; \
	$(EXPORT) OBJDUMP=${OBJDUMP}; \
	$(EXPORT) RANLIB=${RANLIB}; \
	$(EXPORT) BUILD_DIR="${DIRECTFB_BUILD_VER_DIR}"; \
	${MAKE} ${MAKE_OPTIONS} install DESTDIR=${INSIGNIA_INSTALL_DIR}; \
	if [ $$? -ne 0 ]; then \
		$(ECHO) -e "\n*************************************************"; \
	    $(ECHO) "* ERROR: Failed to install Insignia - Aborting! *"; \
		$(ECHO) "*************************************************"; \
	    $(FALSE); \
	else \
	 if [ ! $(BDVD_BUILD) ]; then \
		$(INSTALL) -m 775 ${DIRECTFB_INSTALL_BIN_DFB_VER_DIR}/rundfb.sh ${INSIGNIA_INSTALL_BIN_INS_VER_DIR}/runins.sh; \
		$(SED) -i -e "s;'${DIRECTFB_PREFIX};'${INSIGNIA_INSTALL_ROOT_DIR};g" ${INSIGNIA_INSTALL_LIB_DIR}/libinsignia.la; \
		$(SED) -i -e "s; ${DIRECTFB_PREFIX}; ${INSIGNIA_INSTALL_ROOT_DIR};g" ${INSIGNIA_INSTALL_LIB_DIR}/libinsignia.la; \
		$(ECHO) "Ver: ${INSIGNIA_VERSION}"  > ${INSIGNIA_INSTALLED_FLAG}; \
		$(ECHO) "Src: ${INSIGNIA_SRC_DIR}" >> ${INSIGNIA_INSTALLED_FLAG}; \
	 else \
		$(ECHO) "Ver: ${INSIGNIA_VERSION}"  > ${INSIGNIA_INSTALLED_FLAG}; \
		$(ECHO) "Src: ${INSIGNIA_SRC_DIR}" >> ${INSIGNIA_INSTALLED_FLAG}; \
	 fi \
	fi
endef

##
#
# fn-insignia-distclean: function to clean out all files.
#
define fn-insignia-distclean
	if [ -e "${INSIGNIA_CONFIGURATION_FLAG}" ]; then \
		$(RM) ${INSIGNIA_CONFIGURATION_FLAG}; \
	fi; \
	if [ -e "${INSIGNIA_CONFIGURED_FLAG}" ]; then \
		$(RM) ${INSIGNIA_CONFIGURED_FLAG}; \
	fi; \
	if [ -e "${INSIGNIA_SRC_DIR}/Makefile" ]; then \
		${MAKE} -C ${INSIGNIA_SRC_DIR} distclean; \
	fi; \
	if [ -e "${INSIGNIA_INSTALL_INCLUDE_DIR}/insignia" ]; then \
		$(RM) -r ${INSIGNIA_INSTALL_INCLUDE_DIR}/insignia; \
	fi
endef

##
#
# Dependency target not to be called directly.
#
${INSIGNIA_UNPACKED_FLAG}:
	@if ! [ -e "${INSIGNIA_SRC_DIR}" ]; then \
		${MKDIR} "${INSIGNIA_SRC_DIR}";\
	fi
	@if ! [ -e "${DIRECTFB_SRC_DFB_TAR_DIR}/${INSIGNIA_SOURCE_TARBALL}" ]; then \
		$(ECHO) "ERROR: Cannot find '${DIRECTFB_SRC_DFB_TAR_DIR}/${INSIGNIA_SOURCE_TARBALL}'!";\
		$(FALSE);\
	else \
		if [ `$(STAT) -c "%s" ${DIRECTFB_SRC_DFB_TAR_DIR}/${INSIGNIA_SOURCE_TARBALL}` -eq 0 ]; then \
			$(ECHO) "ERROR: Size of '${DIRECTFB_SRC_DFB_TAR_DIR}/${INSIGNIA_SOURCE_TARBALL}' is 0!";\
			$(FALSE);\
		else \
			$(ECHO) "**********************************"; \
			$(ECHO) "* Creating Insignia-${INSIGNIA_VERSION} Source *"; \
			$(ECHO) "**********************************"; \
			$(TAR) xzkf ${DIRECTFB_SRC_DFB_TAR_DIR}/${INSIGNIA_SOURCE_TARBALL} -C $(DIRECTFB_SRC_DIR); \
			if [ -d "${INSIGNIA_PUB_INS_VER1_DIR}" ]; then \
				$(CP) -r ${INSIGNIA_PUB_INS_VER1_DIR}/* ${INSIGNIA_SRC_DIR}; \
			fi; \
			if [ -d "${INSIGNIA_PUB_INS_VER2_DIR}" ]; then \
				$(CP) -r ${INSIGNIA_PUB_INS_VER2_DIR}/* ${INSIGNIA_SRC_DIR}; \
			fi; \
			if [ -d "${INSIGNIA_PRI_INS_VER1_DIR}" ]; then \
				$(CP) -r ${INSIGNIA_PRI_INS_VER1_DIR}/* ${INSIGNIA_SRC_DIR}; \
			fi; \
			if [ -d "${INSIGNIA_PRI_INS_VER2_DIR}" ]; then \
				$(CP) -r ${INSIGNIA_PRI_INS_VER2_DIR}/* ${INSIGNIA_SRC_DIR}; \
			fi; \
			$(TOUCH) ${INSIGNIA_UNPACKED_FLAG}; \
		fi; \
	fi

##
#
# Dependency target not to be called directly.
#
${INSIGNIA_CONFIGURATION_FLAG}: ${INSIGNIA_UNPACKED_FLAG} ALWAYS
	@$(ECHO) -n "GCC_VERSION="                        > ${INSIGNIA_SRC_DIR}/.config.$$$$; \
	${B_REFSW_CROSS_COMPILE}gcc -dumpversion         >> ${INSIGNIA_SRC_DIR}/.config.$$$$; \
	$(ECHO) -n "GCC_MACHINE="                        >> ${INSIGNIA_SRC_DIR}/.config.$$$$; \
	${B_REFSW_CROSS_COMPILE}gcc -dumpmachine         >> ${INSIGNIA_SRC_DIR}/.config.$$$$; \
	$(ECHO) "KERNEL_VERSION=${KERNEL_VERSION}"       >> ${INSIGNIA_SRC_DIR}/.config.$$$$; \
	$(ECHO) "B_REFSW_DEBUG=${B_REFSW_DEBUG}"         >> ${INSIGNIA_SRC_DIR}/.config.$$$$; \
	$(ECHO) "B_REFSW_ARCH=${B_REFSW_ARCH}"           >> ${INSIGNIA_SRC_DIR}/.config.$$$$; \
	$(ECHO) "B_REFSW_SHAREABLE=${B_REFSW_SHAREABLE}" >> ${INSIGNIA_SRC_DIR}/.config.$$$$; \
	$(ECHO) "DIRECTFB_PREFIX=${DIRECTFB_PREFIX}"     >> ${INSIGNIA_SRC_DIR}/.config.$$$$; \
	$(ECHO) "DIRECTFB_SHARED=${DIRECTFB_SHARED}"     >> ${INSIGNIA_SRC_DIR}/.config.$$$$; \
	$(ECHO) "BUILD_VOODOO=${BUILD_VOODOO}"           >> ${INSIGNIA_SRC_DIR}/.config.$$$$; \
	$(ECHO) "BUILD_PPDFB=${BUILD_PPDFB}"             >> ${INSIGNIA_SRC_DIR}/.config.$$$$; \
	if [ -e "${INSIGNIA_CONFIGURATION_FLAG}" ]; then \
		$(DIFF) ${INSIGNIA_CONFIGURATION_FLAG} ${INSIGNIA_SRC_DIR}/.config.$$$$; \
		if [ $$? -eq 1 ] ; then \
			${MAKE} -C ${DIRECTFB_BUILD_VER_DIR} insignia-clean; \
			$(CP) ${INSIGNIA_SRC_DIR}/.config.$$$$ ${INSIGNIA_CONFIGURATION_FLAG}; \
		fi; \
	else \
		$(CP) ${INSIGNIA_SRC_DIR}/.config.$$$$ ${INSIGNIA_CONFIGURATION_FLAG}; \
	fi; \
	$(RM) ${INSIGNIA_SRC_DIR}/.config.$$$$

##
#
# Dependency target not to be called directly.
#
ifeq ($(shell test \( $(DIRECTFB_MAJOR) -eq 1 -a $(DIRECTFB_MINOR) -lt 7 \) && echo "y") ,y)
${INSIGNIA_CONFIGURED_FLAG}: ${PPDFB_FLAG} ${INSIGNIA_CONFIGURATION_FLAG}
else
${INSIGNIA_CONFIGURED_FLAG}: ${INSIGNIA_CONFIGURATION_FLAG}
endif
	@$(call fn-insignia-configure)

##
#
# Dependency target not to be called directly.
#
${INSIGNIA_COMPILED_FLAG}: ${INSIGNIA_CONFIGURED_FLAG}
	@$(call fn-insignia-compile)

##
#
# Dependency target not to be called directly.
#
${INSIGNIA_INSTALLED_FLAG}: ${INSIGNIA_COMPILED_FLAG}
	@$(call fn-insignia-install)

##
#
# Dependency target not to be called directly.
#
${INSIGNIA_FLAG}: ${INSIGNIA_INSTALLED_FLAG}
	@$(ECHO) -e "${INSIGNIA_VERSION}\n${BRCM_CPPFLAGS}" > ${INSIGNIA_SRC_DIR}/.install.$$$$; \
	if [ -e "${INSIGNIA_FLAG}" ]; then \
		$(DIFF) ${INSIGNIA_FLAG} ${INSIGNIA_SRC_DIR}/.install.$$$$; \
		if [ $$? -eq 1 ] ; then \
			$(CP) ${INSIGNIA_SRC_DIR}/.install.$$$$ ${INSIGNIA_FLAG}; \
		fi; \
	else \
		$(CP) ${INSIGNIA_SRC_DIR}/.install.$$$$ ${INSIGNIA_FLAG}; \
	fi; \
	$(RM) ${INSIGNIA_SRC_DIR}/.install.$$$$


