/******************************************************************************
 *    (c)2011-2013 Broadcom Corporation
 *
 * This program is the proprietary software of Broadcom Corporation and/or its licensors,
 * and may only be used, duplicated, modified or distributed pursuant to the terms and
 * conditions of a separate, written license agreement executed between you and Broadcom
 * (an "Authorized License").  Except as set forth in an Authorized License, Broadcom grants
 * no license (express or implied), right to use, or waiver of any kind with respect to the
 * Software, and Broadcom expressly reserves all rights in and to the Software and all
 * intellectual property rights therein.  IF YOU HAVE NO AUTHORIZED LICENSE, THEN YOU
 * HAVE NO RIGHT TO USE THIS SOFTWARE IN ANY WAY, AND SHOULD IMMEDIATELY
 * NOTIFY BROADCOM AND DISCONTINUE ALL USE OF THE SOFTWARE.
 *
 * Except as expressly set forth in the Authorized License,
 *
 * 1.     This program, including its structure, sequence and organization, constitutes the valuable trade
 * secrets of Broadcom, and you shall use all reasonable efforts to protect the confidentiality thereof,
 * and to use this information only in connection with your use of Broadcom integrated circuit products.
 *
 * 2.     TO THE MAXIMUM EXTENT PERMITTED BY LAW, THE SOFTWARE IS PROVIDED "AS IS"
 * AND WITH ALL FAULTS AND BROADCOM MAKES NO PROMISES, REPRESENTATIONS OR
 * WARRANTIES, EITHER EXPRESS, IMPLIED, STATUTORY, OR OTHERWISE, WITH RESPECT TO
 * THE SOFTWARE.  BROADCOM SPECIFICALLY DISCLAIMS ANY AND ALL IMPLIED WARRANTIES
 * OF TITLE, MERCHANTABILITY, NONINFRINGEMENT, FITNESS FOR A PARTICULAR PURPOSE,
 * LACK OF VIRUSES, ACCURACY OR COMPLETENESS, QUIET ENJOYMENT, QUIET POSSESSION
 * OR CORRESPONDENCE TO DESCRIPTION. YOU ASSUME THE ENTIRE RISK ARISING OUT OF
 * USE OR PERFORMANCE OF THE SOFTWARE.
 *
 * 3.     TO THE MAXIMUM EXTENT PERMITTED BY LAW, IN NO EVENT SHALL BROADCOM OR ITS
 * LICENSORS BE LIABLE FOR (i) CONSEQUENTIAL, INCIDENTAL, SPECIAL, INDIRECT, OR
 * EXEMPLARY DAMAGES WHATSOEVER ARISING OUT OF OR IN ANY WAY RELATING TO YOUR
 * USE OF OR INABILITY TO USE THE SOFTWARE EVEN IF BROADCOM HAS BEEN ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGES; OR (ii) ANY AMOUNT IN EXCESS OF THE AMOUNT
 * ACTUALLY PAID FOR THE SOFTWARE ITSELF OR U.S. $1, WHICHEVER IS GREATER. THESE
 * LIMITATIONS SHALL APPLY NOTWITHSTANDING ANY FAILURE OF ESSENTIAL PURPOSE OF
 * ANY LIMITED REMEDY.
 *
 * $brcm_Workfile: dfb_unittest_main.cpp $
 *
 * Module Description:Main file for envoking DirectFB Unit tests using Google Test Framework
 *
 *

*****************************************************************************/
#include "directfb_unittest.h"


//using namespace broadcom::broadband::diagnostic;

TEST(DfAndi, test_df_andi)
{
    //Invoke df_andi test
     EXPECT_EQ(0, df_andi_main(0, NULL));

}

TEST(DfDok, test_df_dok)
{

    //Invoke df_dok test
    EXPECT_EQ(0, df_dok_main(0, NULL));

}

TEST(DfbtestLayer, test_dfbtest_layer)
{

    //Invoke dfbtest_layer test
    EXPECT_EQ(0, dfbtest_layer_main(0, NULL));
}

TEST(DfbtestBlit, test_dfbtest_blit)
{
    //Invoke dfbtest_blit test 
    //Test with desktop.png.compare against golden reference files.
    //  Golden reference file names passed in as test parameters 
    const char *argv_tmp[] = {"dfbtest_blit",
                              DATADIR"/desktop.png",
                              "-p", "dfbtest_blit_0000.ppm.gz",
                              "-g", "dfbtest_blit_0000.pgm.gz"
                             };

    int argc = MAX_DFBTEST_BLIT_PARAMS;
    char *argv[MAX_DFBTEST_BLIT_PARAMS] = {NULL};

    //Need to copy string array to avoid cpp warnings
    for(int i = 0; i < argc; i++) {

        argv[i] = new char[MAX_DFBTEST_BLIT_PARAM_LENGTH];

        argv[i] = strdup(argv_tmp[i]);

    }

    //Invoke dfbtest_blit test
    EXPECT_EQ(0, dfbtest_blit_main(argc,argv));

    for(int i = 0; i < argc; i++) {

    delete argv[i];

    }

}

TEST(DfbrcmTest, test_df_brcmTest)
{

    //Invoke dfb_brcmTest test
    EXPECT_EQ(0, df_brcmTest_main(0, NULL));

}

#ifdef BUILD_INSIGNIA

TEST(Insignia, test_insignia)
{

    //Invoke Insignia tests 
    EXPECT_EQ(0, insignia_main(0, NULL));

}

#endif

int main(int argc, char *argv[])
{

    testing::InitGoogleTest(&argc, argv);

    return RUN_ALL_TESTS();
}

