/******************************************************************************
 *    (c)2011-2013 Broadcom Corporation
 *
 * This program is the proprietary software of Broadcom Corporation and/or its licensors,
 * and may only be used, duplicated, modified or distributed pursuant to the terms and
 * conditions of a separate, written license agreement executed between you and Broadcom
 * (an "Authorized License").  Except as set forth in an Authorized License, Broadcom grants
 * no license (express or implied), right to use, or waiver of any kind with respect to the
 * Software, and Broadcom expressly reserves all rights in and to the Software and all
 * intellectual property rights therein.  IF YOU HAVE NO AUTHORIZED LICENSE, THEN YOU
 * HAVE NO RIGHT TO USE THIS SOFTWARE IN ANY WAY, AND SHOULD IMMEDIATELY
 * NOTIFY BROADCOM AND DISCONTINUE ALL USE OF THE SOFTWARE.
 *
 * Except as expressly set forth in the Authorized License,
 *
 * 1.     This program, including its structure, sequence and organization, constitutes the valuable trade
 * secrets of Broadcom, and you shall use all reasonable efforts to protect the confidentiality thereof,
 * and to use this information only in connection with your use of Broadcom integrated circuit products.
 *
 * 2.     TO THE MAXIMUM EXTENT PERMITTED BY LAW, THE SOFTWARE IS PROVIDED "AS IS"
 * AND WITH ALL FAULTS AND BROADCOM MAKES NO PROMISES, REPRESENTATIONS OR
 * WARRANTIES, EITHER EXPRESS, IMPLIED, STATUTORY, OR OTHERWISE, WITH RESPECT TO
 * THE SOFTWARE.  BROADCOM SPECIFICALLY DISCLAIMS ANY AND ALL IMPLIED WARRANTIES
 * OF TITLE, MERCHANTABILITY, NONINFRINGEMENT, FITNESS FOR A PARTICULAR PURPOSE,
 * LACK OF VIRUSES, ACCURACY OR COMPLETENESS, QUIET ENJOYMENT, QUIET POSSESSION
 * OR CORRESPONDENCE TO DESCRIPTION. YOU ASSUME THE ENTIRE RISK ARISING OUT OF
 * USE OR PERFORMANCE OF THE SOFTWARE.
 *
 * 3.     TO THE MAXIMUM EXTENT PERMITTED BY LAW, IN NO EVENT SHALL BROADCOM OR ITS
 * LICENSORS BE LIABLE FOR (i) CONSEQUENTIAL, INCIDENTAL, SPECIAL, INDIRECT, OR
 * EXEMPLARY DAMAGES WHATSOEVER ARISING OUT OF OR IN ANY WAY RELATING TO YOUR
 * USE OF OR INABILITY TO USE THE SOFTWARE EVEN IF BROADCOM HAS BEEN ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGES; OR (ii) ANY AMOUNT IN EXCESS OF THE AMOUNT
 * ACTUALLY PAID FOR THE SOFTWARE ITSELF OR U.S. $1, WHICHEVER IS GREATER. THESE
 * LIMITATIONS SHALL APPLY NOTWITHSTANDING ANY FAILURE OF ESSENTIAL PURPOSE OF
 * ANY LIMITED REMEDY.
 *
 * $brcm_Workfile: directfb_unittest.h $
 *
 * Module Description:Header file for DirectFB Unittest.
 *
 *

*****************************************************************************/

#ifndef DIRECTFB_UNITTEST_H
#define DIRECTFB_UNITTEST_H
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <directfb.h>
#include <sys/types.h>
#include <fcntl.h>
#include <sys/select.h>

#include <gtest/gtest.h>
#include "dfb_platform.h"
#include "crc.h"
#include <signal.h>

#define MAX_DFBTEST_BLIT_PARAM_LENGTH 64 
#define MAX_DFBTEST_BLIT_PARAMS 6
//
// Functions from "C" files. These are the access functions to start individual directfb unittests.
// "C" files are built separately into libdfb_unittest.so library which is liked during build of df_unittest
// test program. df_unittest then invokes individual unittests using Google Test framework
//
extern "C" {

extern int df_dok_main( int argc, char *argv[] );
extern int df_andi_main( int argc, char *argv[] );
extern int dfbtest_reinit_main( int argc, char *argv[] );
extern int dfbtest_layer_main( int argc, char *argv[] );
extern int dfbtest_blit_main(int argc, char * argv [ ]);
extern int df_input_main(int argc, char * argv [ ]);
extern int df_input_keysender_main(int argc, char * argv [ ]);
extern int df_brcmTest_main(int argc, char * argv [ ]);

}

//
//c++ extern function
//
extern int insignia_main(int argc, char * argv [ ]);

//
//Define separate class for each test. Using separate class for each test does not cause seg-fault during
//  start-up of second test

//
// Class for df_andi test
//
class DfAndi:public ::testing::Test {
public:

public:
    virtual void SetUp()
    {
    }

    virtual void TearDown()
    {
    }

};

//
// Class for df_dok test
//
class DfDok:public ::testing::Test {
public:

public:
    virtual void SetUp()
    {
    }

    virtual void TearDown()
    {
    }

};

//
// Class for dfbtest_blit test
//
class DfbtestBlit:public ::testing::Test {
public:

public:
    virtual void SetUp()
    {
    }

    virtual void TearDown()
    {
    }

};

//
// Class for df_brcmTest test
//
class DfbrcmTest:public ::testing::Test {
public:

public:
    virtual void SetUp()
    {
    }

    virtual void TearDown()
    {
    }

};

//
// Class for dfbtest_layer test
//
class DfbtestLayer:public ::testing::Test {
public:

public:
    virtual void SetUp()
    {
    }

    virtual void TearDown()
    {
    }

};

//
// Class for Insignia test
//
class Insignia:public ::testing::Test {
public:

public:
    virtual void SetUp()
    {
    }

    virtual void TearDown()
    {
    }

};

#endif
