/* Replayable replacements for global functions */

/***************************************************************
 * BEGIN STABLE.JS
 **************************************************************/
//! stable.js 0.1.3, https://github.com/Two-Screen/stable
//! © 2012 Stéphan Kochen, Angry Bytes. MIT licensed.
(function() {

// A stable array sort, because `Array#sort()` is not guaranteed stable.
// This is an implementation of merge sort, without recursion.

var stable = function(arr, comp) {
    if (typeof(comp) !== 'function') {
        comp = function(a, b) {
            a = String(a);
            b = String(b);
            if (a < b) return -1;
            if (a > b) return 1;
            return 0;
        };
    }

    var len = arr.length;

    if (len <= 1) return arr;

    // Rather than dividing input, simply iterate chunks of 1, 2, 4, 8, etc.
    // Chunks are the size of the left or right hand in merge sort.
    // Stop when the left-hand covers all of the array.
    var oarr = arr;
    for (var chk = 1; chk < len; chk *= 2) {
        arr = pass(arr, comp, chk);
    }
    for (var i = 0; i < len; i++) {
        oarr[i] = arr[i];
    }
    return oarr;
};

// Run a single pass with the given chunk size. Returns a new array.
var pass = function(arr, comp, chk) {
    var len = arr.length;
    // Output, and position.
    var result = new Array(len);
    var i = 0;
    // Step size / double chunk size.
    var dbl = chk * 2;
    // Bounds of the left and right chunks.
    var l, r, e;
    // Iterators over the left and right chunk.
    var li, ri;

    // Iterate over pairs of chunks.
    for (l = 0; l < len; l += dbl) {
        r = l + chk;
        e = r + chk;
        if (r > len) r = len;
        if (e > len) e = len;

        // Iterate both chunks in parallel.
        li = l;
        ri = r;
        while (true) {
            // Compare the chunks.
            if (li < r && ri < e) {
                // This works for a regular `sort()` compatible comparator,
                // but also for a simple comparator like: `a > b`
                if (comp(arr[li], arr[ri]) <= 0) {
                    result[i++] = arr[li++];
                }
                else {
                    result[i++] = arr[ri++];
                }
            }
            // Nothing to compare, just flush what's left.
            else if (li < r) {
                result[i++] = arr[li++];
            }
            else if (ri < e) {
                result[i++] = arr[ri++];
            }
            // Both iterators are at the chunk ends.
            else {
                break;
            }
        }
    }

    return result;
};

var arrsort = function(comp) {
    return stable(this, comp);
};

if (Object.defineProperty) {
    Object.defineProperty(Array.prototype, "sort", {
        configurable: true, writable: true, enumerable: false,
        value: arrsort
    });
} else {
    Array.prototype.sort = arrsort;
}

})();
/***************************************************************
 * END STABLE.JS
 **************************************************************/

/*
 * In a generated replay, this file is partially common, boilerplate code
 * included in every replay, and partially generated replay code. The following
 * header applies to the boilerplate code. A comment indicating "Auto-generated
 * below this comment" marks the separation between these two parts.
 *
 * Copyright (C) 2011, 2012 Purdue University
 * Written by Gregor Richards
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

(function() {
    // global eval alias
    var geval = eval;

    // detect if we're in a browser or not
    var inbrowser = false;
    var inharness = false;
    var finished = false;
    if (typeof window !== "undefined" && "document" in window) {
        inbrowser = true;
        if (window.parent && "JSBNG_handleResult" in window.parent) {
            inharness = true;
        }
    } else if (typeof global !== "undefined") {
        window = global;
        window.top = window;
    } else {
        window = (function() { return this; })();
        window.top = window;
    }

    if ("console" in window) {
        window.JSBNG_Console = window.console;
    }

    var callpath = [];

    // global state
    var JSBNG_Replay = window.top.JSBNG_Replay = {
        push: function(arr, fun) {
            arr.push(fun);
            return fun;
        },

        path: function(str) {
            verifyPath(str);
        },

        forInKeys: function(of) {
            var keys = [];
            for (var k in of)
                keys.push(k);
            return keys.sort();
        }
    };

    var currentTimeInMS;
    if (inharness) {
        currentTimeInMS = window.parent.currentTimeInMS;
    } else {
        if (window.performance && window.performance.now)
            currentTimeInMS = function() { return window.performance.now() };
        else if (typeof preciseTime !== 'undefined')
            currentTimeInMS = function() { return preciseTime() * 1000; };
        else
            currentTimeInMS = function() { return Date.now(); };
    }

    // the actual replay runner
    function onload() {
        try {
            delete window.onload;
        } catch (ex) {}

        var jr = JSBNG_Replay$;
        var cb = function() {
            var end = currentTimeInMS();
            finished = true;

            var msg = "Time: " + (end - st) + "ms";
    
            if (inharness) {
                window.parent.JSBNG_handleResult({error:false, time:(end - st)});
            } else if (inbrowser) {
                var res = document.createElement("div");
    
                res.style.position = "fixed";
                res.style.left = "1em";
                res.style.top = "1em";
                res.style.width = "35em";
                res.style.height = "5em";
                res.style.padding = "1em";
                res.style.backgroundColor = "white";
                res.style.color = "black";
                res.appendChild(document.createTextNode(msg));
    
                document.body.appendChild(res);
            } else if (typeof console !== "undefined") {
                console.log(msg);
            } else if (typeof print !== "undefined") {
                // hopefully not the browser print() function :)
                print(msg);
            }
        };

        // force it to JIT
        jr(false);

        // then time it
        var st = currentTimeInMS();
        while (jr !== null) {
            jr = jr(true, cb);
        }
    }

    // add a frame at replay time
    function iframe(pageid) {
        var iw;
        if (inbrowser) {
            // represent the iframe as an iframe (of course)
            var iframe = document.createElement("iframe");
            iframe.style.display = "none";
            document.body.appendChild(iframe);
            iw = iframe.contentWindow;
            iw.document.write("<script type=\"text/javascript\">var JSBNG_Replay_geval = eval;</script>");
            iw.document.close();
        } else {
            // no general way, just lie and do horrible things
            var topwin = window;
            (function() {
                var window = {};
                window.window = window;
                window.top = topwin;
                window.JSBNG_Replay_geval = function(str) {
                    eval(str);
                }
                iw = window;
            })();
        }
        return iw;
    }

    // called at the end of the replay stuff
    function finalize() {
        if (inbrowser) {
            setTimeout(onload, 0);
        } else {
            onload();
        }
    }

    // verify this recorded value and this replayed value are close enough
    function verify(rep, rec) {
        if (rec !== rep &&
            (rep === rep || rec === rec) /* NaN test */) {
            // FIXME?
            if (typeof rec === "function" && typeof rep === "function") {
                return true;
            }
            if (typeof rec !== "object" || rec === null ||
                !(("__JSBNG_unknown_" + typeof(rep)) in rec)) {
                return false;
            }
        }
        return true;
    }

    // general message
    var firstMessage = true;
    function replayMessage(msg) {
        if (inbrowser) {
            if (firstMessage)
                document.open();
            firstMessage = false;
            document.write(msg);
        } else {
            console.log(msg);
        }
    }

    // complain when there's an error
    function verificationError(msg) {
        if (finished) return;
        if (inharness) {
            window.parent.JSBNG_handleResult({error:true, msg: msg});
        } else replayMessage(msg);
        throw new Error();
    }

    // to verify a set
    function verifySet(objstr, obj, prop, gvalstr, gval) {
        if (/^on/.test(prop)) {
            // these aren't instrumented compatibly
            return;
        }

        if (!verify(obj[prop], gval)) {
            var bval = obj[prop];
            var msg = "Verification failure! " + objstr + "." + prop + " is not " + gvalstr + ", it's " + bval + "!";
            verificationError(msg);
        }
    }

    // to verify a call or new
    function verifyCall(iscall, func, cthis, cargs) {
        var ok = true;
        var callArgs = func.callArgs[func.inst];
        iscall = iscall ? 1 : 0;
        if (cargs.length !== callArgs.length - 1) {
            ok = false;
        } else {
            if (iscall && !verify(cthis, callArgs[0])) ok = false;
            for (var i = 0; i < cargs.length; i++) {
                if (!verify(cargs[i], callArgs[i+1])) ok = false;
            }
        }
        if (!ok) {
            var msg = "Call verification failure!";
            verificationError(msg);
        }

        return func.returns[func.inst++];
    }

    // to verify the callpath
    function verifyPath(func) {
        var real = callpath.shift();
        if (real !== func) {
            var msg = "Call path verification failure! Expected " + real + ", found " + func;
            verificationError(msg);
        }
    }

    // figure out how to define getters
    var defineGetter;
    if (Object.defineProperty) {
        var odp = Object.defineProperty;
        defineGetter = function(obj, prop, getter, setter) {
            if (typeof setter === "undefined") setter = function(){};
            odp(obj, prop, {"enumerable": true, "configurable": true, "get": getter, "set": setter});
        };
    } else if (Object.prototype.__defineGetter__) {
        var opdg = Object.prototype.__defineGetter__;
        var opds = Object.prototype.__defineSetter__;
        defineGetter = function(obj, prop, getter, setter) {
            if (typeof setter === "undefined") setter = function(){};
            opdg.call(obj, prop, getter);
            opds.call(obj, prop, setter);
        };
    } else {
        defineGetter = function() {
            verificationError("This replay requires getters for correct behavior, and your JS engine appears to be incapable of defining getters. Sorry!");
        };
    }

    var defineRegetter = function(obj, prop, getter, setter) {
        defineGetter(obj, prop, function() {
            return getter.call(this, prop);
        }, function(val) {
            // once it's set by the client, it's claimed
            setter.call(this, prop, val);
            Object.defineProperty(obj, prop, {
                "enumerable": true, "configurable": true, "writable": true,
                "value": val
            });
        });
    }

    // for calling events
    var fpc = Function.prototype.call;

// resist the urge, don't put a })(); here!
/******************************************************************************
 * Auto-generated below this comment
 *****************************************************************************/
var ow81632121 = window;
var f81632121_0;
var o0;
var o1;
var o2;
var f81632121_4;
var f81632121_7;
var f81632121_11;
var f81632121_12;
var f81632121_13;
var f81632121_14;
var f81632121_15;
var o3;
var o4;
var o5;
var f81632121_49;
var o6;
var f81632121_51;
var o7;
var f81632121_53;
var f81632121_54;
var f81632121_57;
var f81632121_59;
var f81632121_60;
var f81632121_61;
var f81632121_62;
var f81632121_70;
var f81632121_71;
var f81632121_151;
var f81632121_156;
var f81632121_270;
var f81632121_417;
var f81632121_463;
var f81632121_466;
var f81632121_467;
var f81632121_468;
var f81632121_469;
var f81632121_471;
var o8;
var o9;
var f81632121_474;
var f81632121_476;
var o10;
var f81632121_478;
var f81632121_481;
var f81632121_482;
var o11;
var o12;
var o13;
var o14;
var o15;
var o16;
var o17;
var f81632121_502;
var f81632121_503;
var f81632121_504;
var f81632121_506;
var f81632121_507;
var f81632121_508;
var o18;
var o19;
var f81632121_513;
var o20;
var o21;
var o22;
var o23;
var o24;
var f81632121_521;
var o25;
var o26;
var o27;
var o28;
var o29;
var o30;
var o31;
var o32;
var o33;
var o34;
var fo81632121_553_firstChild;
var o35;
var o36;
var o37;
var o38;
var fo81632121_563_firstChild;
var f81632121_572;
var f81632121_575;
var f81632121_576;
var o39;
var o40;
var fo81632121_582_firstChild;
var f81632121_585;
var f81632121_598;
var o41;
var f81632121_602;
var o42;
var o43;
var f81632121_645;
var fo81632121_700_firstChild;
var o44;
var o45;
var o46;
var o47;
var fo81632121_795_firstChild;
var o48;
var o49;
var o50;
var o51;
var fo81632121_897_firstChild;
var o52;
var o53;
var o54;
var o55;
var o56;
var o57;
var o58;
var o59;
var f81632121_1000;
var fo81632121_1_cookie;
var o60;
var f81632121_1002;
var o61;
var f81632121_1005;
var o62;
var f81632121_1007;
var o63;
var o64;
var o65;
var o66;
var o67;
var o68;
var o69;
var o70;
var o71;
var o72;
var o73;
var o74;
var o75;
var o76;
var o77;
var o78;
var o79;
var o80;
var o81;
var o82;
var o83;
var o84;
var o85;
var f81632121_1110;
var f81632121_1111;
var f81632121_1112;
var f81632121_1114;
var f81632121_1117;
var f81632121_1118;
var f81632121_1122;
var f81632121_1123;
var f81632121_1124;
var f81632121_1126;
var f81632121_1127;
var f81632121_1156;
var f81632121_1157;
var fo81632121_1165_firstChild;
var o86;
var o87;
var fo81632121_1201_firstChild;
var o88;
var o89;
var o90;
var o91;
var o92;
var o93;
var o94;
var o95;
var fo81632121_1218_firstChild;
var o96;
var o97;
var f81632121_1294;
var f81632121_1295;
var f81632121_1296;
var f81632121_1298;
var o98;
var o99;
var o100;
var o101;
var o102;
var o103;
var o104;
var o105;
var o106;
var o107;
var o108;
var o109;
var o110;
var o111;
var o112;
var o113;
var o114;
var o115;
var o116;
var o117;
var f81632121_1332;
var f81632121_1333;
var f81632121_1334;
var o118;
var f81632121_1336;
var f81632121_1337;
var f81632121_1338;
var f81632121_1339;
var f81632121_1340;
var f81632121_1341;
var f81632121_1342;
var o119;
var f81632121_1344;
var o120;
var f81632121_1347;
var f81632121_1348;
var f81632121_1349;
var f81632121_1350;
var f81632121_1351;
var f81632121_1352;
var f81632121_1353;
var f81632121_1355;
var o121;
var o122;
var o123;
var o124;
var o125;
var o126;
var o127;
var o128;
var o129;
var o130;
var o131;
var o132;
var o133;
var f81632121_1398;
var f81632121_1413;
var f81632121_1417;
var f81632121_1418;
var o134;
var o135;
var o136;
var o137;
var o138;
var fo81632121_1423_firstChild;
var o139;
var f81632121_1442;
var o140;
var o141;
var o142;
var o143;
var o144;
var f81632121_1457;
var o145;
var o146;
var fo81632121_1467_style;
var fo81632121_1465_style;
var f81632121_1481;
var o147;
var o148;
var fo81632121_1527_firstChild;
var fo81632121_1562_firstChild;
var f81632121_1608;
var f81632121_1610;
var f81632121_1611;
var f81632121_1612;
var f81632121_1613;
var f81632121_1615;
var f81632121_1616;
var f81632121_1617;
var f81632121_1619;
var f81632121_1620;
var f81632121_1622;
var f81632121_1624;
var f81632121_1626;
var f81632121_1629;
var f81632121_1630;
var f81632121_1631;
var f81632121_1632;
var f81632121_1633;
var f81632121_1634;
var f81632121_1636;
var f81632121_1638;
var o149;
var f81632121_1640;
var f81632121_1642;
var f81632121_1644;
var o150;
var f81632121_1646;
var o151;
var f81632121_1648;
var f81632121_1659;
var f81632121_1662;
var o152;
var o153;
var o154;
var o155;
var f81632121_1669;
var o156;
var o157;
var o158;
var f81632121_1673;
var f81632121_1674;
var o159;
var o160;
var o161;
var o162;
var o163;
var o164;
var o165;
var o166;
var o167;
var o168;
var o169;
var o170;
var f81632121_1731;
var o171;
var o172;
var o173;
var o174;
var o175;
var o176;
var f81632121_1740;
var o177;
var o178;
var o179;
var o180;
var f81632121_1746;
var o181;
var f81632121_1756;
var o182;
var o183;
var o184;
var o185;
var o186;
var o187;
var o188;
var o189;
var fo81632121_1605_readyState;
var f81632121_1821;
var f81632121_1852;
var f81632121_1871;
var o190;
var f81632121_2117;
var f81632121_2118;
var f81632121_2129;
var f81632121_2135;
var f81632121_2141;
var f81632121_2143;
var o191;
var o192;
var o193;
var o194;
var o195;
var o196;
var f81632121_2152;
var f81632121_2153;
var f81632121_2154;
var f81632121_2155;
var f81632121_2156;
var f81632121_2160;
var o197;
var o198;
var o199;
var o200;
var f81632121_2241;
var fo81632121_2264_firstChild;
var f81632121_2270;
var fo81632121_2240_Shockwave_Flash;
var fo81632121_2273_application_x_shockwave_flash;
var f81632121_2281;
var f81632121_2446;
var f81632121_2447;
var f81632121_2709;
var f81632121_2710;
var f81632121_2711;
var f81632121_2758;
JSBNG_Replay.s823dd4ac9f5a8b88b4949da5f69e231f14b053b0_1 = [];
JSBNG_Replay.s823dd4ac9f5a8b88b4949da5f69e231f14b053b0_199 = [];
JSBNG_Replay.s823dd4ac9f5a8b88b4949da5f69e231f14b053b0_175 = [];
JSBNG_Replay.s1da4c91f736d950de61ac9962e5a050e9ae4a4ed_565 = [];
JSBNG_Replay.s823dd4ac9f5a8b88b4949da5f69e231f14b053b0_178 = [];
JSBNG_Replay.s1da4c91f736d950de61ac9962e5a050e9ae4a4ed_104 = [];
JSBNG_Replay.s823dd4ac9f5a8b88b4949da5f69e231f14b053b0_231 = [];
JSBNG_Replay.s823dd4ac9f5a8b88b4949da5f69e231f14b053b0_234 = [];
JSBNG_Replay.s0a1060a4e309eb327794aa50fb03bc4e8e002205_286 = [];
JSBNG_Replay.s823dd4ac9f5a8b88b4949da5f69e231f14b053b0_55 = [];
JSBNG_Replay.sb400e2fc5b4578cec05af7646f5430d8d67f9e1b_61 = [];
JSBNG_Replay.s823dd4ac9f5a8b88b4949da5f69e231f14b053b0_413 = [];
JSBNG_Replay.s5f7fb1571d9ddaabf0918a66ba121ad96869441c_256 = [];
JSBNG_Replay.s1406cdb8f82a4497c9e210b291001f76845e62bf_379 = [];
JSBNG_Replay.s1406cdb8f82a4497c9e210b291001f76845e62bf_361 = [];
JSBNG_Replay.s823dd4ac9f5a8b88b4949da5f69e231f14b053b0_404 = [];
JSBNG_Replay.s745724cb144ffb0314d39065d8a453b0cfbd0f73_148 = [];
JSBNG_Replay.s823dd4ac9f5a8b88b4949da5f69e231f14b053b0_235 = [];
// 1
// record generated by JSBench 59c4c1419900 at 2013-07-26T15:05:50.801Z
// 2
// 3
f81632121_0 = function() { return f81632121_0.returns[f81632121_0.inst++]; };
f81632121_0.returns = [];
f81632121_0.inst = 0;
// 4
ow81632121.JSBNG__Date = f81632121_0;
// 5
o0 = {};
// 6
ow81632121.JSBNG__document = o0;
// 7
o1 = {};
// 8
ow81632121.JSBNG__sessionStorage = o1;
// 9
o2 = {};
// 10
ow81632121.JSBNG__localStorage = o2;
// 11
f81632121_4 = function() { return f81632121_4.returns[f81632121_4.inst++]; };
f81632121_4.returns = [];
f81632121_4.inst = 0;
// 12
ow81632121.JSBNG__getComputedStyle = f81632121_4;
// 17
f81632121_7 = function() { return f81632121_7.returns[f81632121_7.inst++]; };
f81632121_7.returns = [];
f81632121_7.inst = 0;
// 18
ow81632121.JSBNG__addEventListener = f81632121_7;
// 19
ow81632121.JSBNG__top = ow81632121;
// 24
ow81632121.JSBNG__scrollX = 0;
// 25
ow81632121.JSBNG__scrollY = 0;
// 28
f81632121_11 = function() { return f81632121_11.returns[f81632121_11.inst++]; };
f81632121_11.returns = [];
f81632121_11.inst = 0;
// 29
ow81632121.JSBNG__scrollBy = f81632121_11;
// 30
f81632121_12 = function() { return f81632121_12.returns[f81632121_12.inst++]; };
f81632121_12.returns = [];
f81632121_12.inst = 0;
// 31
ow81632121.JSBNG__setTimeout = f81632121_12;
// 32
f81632121_13 = function() { return f81632121_13.returns[f81632121_13.inst++]; };
f81632121_13.returns = [];
f81632121_13.inst = 0;
// 33
ow81632121.JSBNG__setInterval = f81632121_13;
// 34
f81632121_14 = function() { return f81632121_14.returns[f81632121_14.inst++]; };
f81632121_14.returns = [];
f81632121_14.inst = 0;
// 35
ow81632121.JSBNG__clearTimeout = f81632121_14;
// 36
f81632121_15 = function() { return f81632121_15.returns[f81632121_15.inst++]; };
f81632121_15.returns = [];
f81632121_15.inst = 0;
// 37
ow81632121.JSBNG__clearInterval = f81632121_15;
// 42
ow81632121.JSBNG__frames = ow81632121;
// 45
ow81632121.JSBNG__self = ow81632121;
// 46
o3 = {};
// 47
ow81632121.JSBNG__navigator = o3;
// 50
o4 = {};
// 51
ow81632121.JSBNG__history = o4;
// 62
ow81632121.JSBNG__closed = false;
// 65
ow81632121.JSBNG__opener = null;
// 66
ow81632121.JSBNG__defaultStatus = "";
// 67
o5 = {};
// 68
ow81632121.JSBNG__location = o5;
// 69
ow81632121.JSBNG__innerWidth = 1034;
// 70
ow81632121.JSBNG__innerHeight = 727;
// 71
ow81632121.JSBNG__outerWidth = 1050;
// 72
ow81632121.JSBNG__outerHeight = 840;
// 73
ow81632121.JSBNG__screenX = 60;
// 74
ow81632121.JSBNG__screenY = 60;
// 75
ow81632121.JSBNG__pageXOffset = 0;
// 76
ow81632121.JSBNG__pageYOffset = 0;
// 101
ow81632121.JSBNG__frameElement = null;
// 118
f81632121_49 = function() { return f81632121_49.returns[f81632121_49.inst++]; };
f81632121_49.returns = [];
f81632121_49.inst = 0;
// 119
ow81632121.JSBNG__webkitIDBTransaction = f81632121_49;
// 120
o6 = {};
// 121
ow81632121.JSBNG__webkitNotifications = o6;
// 122
f81632121_51 = function() { return f81632121_51.returns[f81632121_51.inst++]; };
f81632121_51.returns = [];
f81632121_51.inst = 0;
// 123
ow81632121.JSBNG__webkitIDBIndex = f81632121_51;
// 124
o7 = {};
// 125
ow81632121.JSBNG__webkitIndexedDB = o7;
// 126
ow81632121.JSBNG__screenLeft = 60;
// 127
f81632121_53 = function() { return f81632121_53.returns[f81632121_53.inst++]; };
f81632121_53.returns = [];
f81632121_53.inst = 0;
// 128
ow81632121.JSBNG__webkitIDBFactory = f81632121_53;
// 129
ow81632121.JSBNG__clientInformation = o3;
// 130
f81632121_54 = function() { return f81632121_54.returns[f81632121_54.inst++]; };
f81632121_54.returns = [];
f81632121_54.inst = 0;
// 131
ow81632121.JSBNG__webkitIDBCursor = f81632121_54;
// 132
ow81632121.JSBNG__defaultstatus = "";
// 137
f81632121_57 = function() { return f81632121_57.returns[f81632121_57.inst++]; };
f81632121_57.returns = [];
f81632121_57.inst = 0;
// 138
ow81632121.JSBNG__webkitIDBDatabase = f81632121_57;
// 141
f81632121_59 = function() { return f81632121_59.returns[f81632121_59.inst++]; };
f81632121_59.returns = [];
f81632121_59.inst = 0;
// 142
ow81632121.JSBNG__webkitIDBRequest = f81632121_59;
// 143
f81632121_60 = function() { return f81632121_60.returns[f81632121_60.inst++]; };
f81632121_60.returns = [];
f81632121_60.inst = 0;
// 144
ow81632121.JSBNG__webkitIDBObjectStore = f81632121_60;
// 145
ow81632121.JSBNG__devicePixelRatio = 1;
// 146
f81632121_61 = function() { return f81632121_61.returns[f81632121_61.inst++]; };
f81632121_61.returns = [];
f81632121_61.inst = 0;
// 147
ow81632121.JSBNG__webkitURL = f81632121_61;
// 148
f81632121_62 = function() { return f81632121_62.returns[f81632121_62.inst++]; };
f81632121_62.returns = [];
f81632121_62.inst = 0;
// 149
ow81632121.JSBNG__webkitIDBKeyRange = f81632121_62;
// 150
ow81632121.JSBNG__offscreenBuffering = true;
// 151
ow81632121.JSBNG__screenTop = 60;
// 166
f81632121_70 = function() { return f81632121_70.returns[f81632121_70.inst++]; };
f81632121_70.returns = [];
f81632121_70.inst = 0;
// 167
ow81632121.JSBNG__XMLHttpRequest = f81632121_70;
// 168
f81632121_71 = function() { return f81632121_71.returns[f81632121_71.inst++]; };
f81632121_71.returns = [];
f81632121_71.inst = 0;
// 169
ow81632121.JSBNG__Image = f81632121_71;
// 170
ow81632121.JSBNG__URL = f81632121_61;
// 171
ow81632121.JSBNG__name = "";
// 178
ow81632121.JSBNG__status = "";
// 331
f81632121_151 = function() { return f81632121_151.returns[f81632121_151.inst++]; };
f81632121_151.returns = [];
f81632121_151.inst = 0;
// 332
ow81632121.JSBNG__WebKitTransitionEvent = f81632121_151;
// 341
f81632121_156 = function() { return f81632121_156.returns[f81632121_156.inst++]; };
f81632121_156.returns = [];
f81632121_156.inst = 0;
// 342
ow81632121.JSBNG__Document = f81632121_156;
// 569
f81632121_270 = function() { return f81632121_270.returns[f81632121_270.inst++]; };
f81632121_270.returns = [];
f81632121_270.inst = 0;
// 570
ow81632121.JSBNG__Event = f81632121_270;
// 615
ow81632121.JSBNG__XMLDocument = f81632121_156;
// 834
ow81632121.JSBNG__TEMPORARY = 0;
// 835
ow81632121.JSBNG__PERSISTENT = 1;
// 866
f81632121_417 = function() { return f81632121_417.returns[f81632121_417.inst++]; };
f81632121_417.returns = [];
f81632121_417.inst = 0;
// 867
ow81632121.JSBNG__WebKitMutationObserver = f81632121_417;
// 886
ow81632121.JSBNG__indexedDB = o7;
// undefined
o7 = null;
// 887
o7 = {};
// 888
ow81632121.JSBNG__Intl = o7;
// 889
ow81632121.JSBNG__v8Intl = o7;
// undefined
o7 = null;
// 940
ow81632121.JSBNG__IDBTransaction = f81632121_49;
// 941
ow81632121.JSBNG__IDBRequest = f81632121_59;
// 944
ow81632121.JSBNG__IDBObjectStore = f81632121_60;
// 945
ow81632121.JSBNG__IDBKeyRange = f81632121_62;
// 946
ow81632121.JSBNG__IDBIndex = f81632121_51;
// 947
ow81632121.JSBNG__IDBFactory = f81632121_53;
// 948
ow81632121.JSBNG__IDBDatabase = f81632121_57;
// 951
ow81632121.JSBNG__IDBCursor = f81632121_54;
// 952
ow81632121.JSBNG__MutationObserver = f81632121_417;
// 953
ow81632121.JSBNG__TransitionEvent = f81632121_151;
// 970
f81632121_463 = function() { return f81632121_463.returns[f81632121_463.inst++]; };
f81632121_463.returns = [];
f81632121_463.inst = 0;
// 971
ow81632121.JSBNG__requestAnimationFrame = f81632121_463;
// 974
ow81632121.JSBNG__onerror = null;
// 977
f81632121_466 = function() { return f81632121_466.returns[f81632121_466.inst++]; };
f81632121_466.returns = [];
f81632121_466.inst = 0;
// 978
ow81632121.Math.JSBNG__random = f81632121_466;
// 979
// 983
f81632121_467 = function() { return f81632121_467.returns[f81632121_467.inst++]; };
f81632121_467.returns = [];
f81632121_467.inst = 0;
// 984
f81632121_0.now = f81632121_467;
// 985
f81632121_467.returns.push(1374851210822);
// 986
o5.search = "";
// 1001
// 1002
// 1004
f81632121_468 = function() { return f81632121_468.returns[f81632121_468.inst++]; };
f81632121_468.returns = [];
f81632121_468.inst = 0;
// 1005
o0.JSBNG__addEventListener = f81632121_468;
// 1006
o3.userAgent = "Mozilla/5.0 (Windows NT 6.2; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/28.0.1500.72 Safari/537.36";
// 1008
f81632121_468.returns.push(undefined);
// 1009
f81632121_469 = function() { return f81632121_469.returns[f81632121_469.inst++]; };
f81632121_469.returns = [];
f81632121_469.inst = 0;
// 1010
ow81632121.JSBNG__onload = f81632121_469;
// 1018
o7 = {};
// 1025
o0.documentMode = void 0;
// 1027
f81632121_471 = function() { return f81632121_471.returns[f81632121_471.inst++]; };
f81632121_471.returns = [];
f81632121_471.inst = 0;
// 1028
o0.getElementsByTagName = f81632121_471;
// 1029
o8 = {};
// 1030
f81632121_471.returns.push(o8);
// 1031
o8.length = 1;
// 1032
o9 = {};
// 1033
o8["0"] = o9;
// undefined
o8 = null;
// 1034
f81632121_474 = function() { return f81632121_474.returns[f81632121_474.inst++]; };
f81632121_474.returns = [];
f81632121_474.inst = 0;
// 1035
o0.createDocumentFragment = f81632121_474;
// 1036
o8 = {};
// 1037
f81632121_474.returns.push(o8);
// 1039
f81632121_467.returns.push(1374851210834);
// 1040
f81632121_476 = function() { return f81632121_476.returns[f81632121_476.inst++]; };
f81632121_476.returns = [];
f81632121_476.inst = 0;
// 1041
o0.createElement = f81632121_476;
// 1042
o10 = {};
// 1043
f81632121_476.returns.push(o10);
// 1044
// 1045
// 1046
// 1047
// 1048
// 1049
// 1050
f81632121_478 = function() { return f81632121_478.returns[f81632121_478.inst++]; };
f81632121_478.returns = [];
f81632121_478.inst = 0;
// 1051
o8.appendChild = f81632121_478;
// 1052
f81632121_478.returns.push(o10);
// undefined
o10 = null;
// 1054
f81632121_467.returns.push(1374851210835);
// 1056
o10 = {};
// 1057
f81632121_476.returns.push(o10);
// 1058
// 1059
// 1060
// 1061
// 1062
// 1063
// 1065
f81632121_478.returns.push(o10);
// undefined
o10 = null;
// 1067
f81632121_467.returns.push(1374851210835);
// 1069
o10 = {};
// 1070
f81632121_476.returns.push(o10);
// 1071
// 1072
// 1073
// 1074
// 1075
// 1076
// 1078
f81632121_478.returns.push(o10);
// undefined
o10 = null;
// 1079
o9.appendChild = f81632121_478;
// 1080
f81632121_478.returns.push(o8);
// undefined
o8 = null;
// 1089
f81632121_466.returns.push(0.8583255198318511);
// 1090
f81632121_481 = function() { return f81632121_481.returns[f81632121_481.inst++]; };
f81632121_481.returns = [];
f81632121_481.inst = 0;
// 1091
ow81632121.JSBNG__onunload = f81632121_481;
// 1093
f81632121_467.returns.push(1374851212533);
// 1094
f81632121_482 = function() { return f81632121_482.returns[f81632121_482.inst++]; };
f81632121_482.returns = [];
f81632121_482.inst = 0;
// 1095
o1.getItem = f81632121_482;
// 1096
f81632121_482.returns.push(null);
// 1098
f81632121_467.returns.push(1374851212534);
// 1099
f81632121_14.returns.push(undefined);
// 1100
f81632121_12.returns.push(1);
// 1104
o8 = {};
// 1105
o0.documentElement = o8;
// 1106
o8.className = "highContrast no_js";
// 1107
// 1109
o0.domain = "jsbngssl.www.facebook.com";
// 1110
// 1112
o5.href = "https://www.facebook.com/LawlabeeTheWallaby";
// 1117
// 1118
o10 = {};
// 1119
f81632121_270.prototype = o10;
// 1121
// 1122
// 1123
// 1124
// 1125
// 1126
// 1128
// 1129
// 1130
// 1131
// 1132
// 1133
// undefined
o10 = null;
// 1134
// 1135
// 1136
// 1137
// 1138
// 1139
// 1140
// 1141
// 1142
// 1143
// 1144
// 1145
o3.msPointerEnabled = void 0;
// 1147
// 1148
// 1149
o10 = {};
// 1150
o11 = {};
// 1152
o10.nodeType = void 0;
// 1153
o10.length = 1;
// 1154
o10["0"] = "OH3xD";
// 1159
o12 = {};
// 1160
o13 = {};
// 1162
o12.nodeType = void 0;
// 1163
o12.length = 1;
// 1164
o12["0"] = "XH2Cu";
// 1169
o14 = {};
// 1170
o15 = {};
// 1172
o14.nodeType = void 0;
// 1173
o14.length = 1;
// 1174
o14["0"] = "ociRJ";
// 1205
o16 = {};
// 1206
f81632121_471.returns.push(o16);
// 1207
o16.length = 9;
// 1208
o17 = {};
// 1209
o16["0"] = o17;
// 1210
o17.rel = "alternate";
// undefined
o17 = null;
// 1212
o17 = {};
// 1213
o16["1"] = o17;
// 1214
o17.rel = "stylesheet";
// 1216
o17.href = "http://jsbngssl.static.xx.fbcdn.net/rsrc.php/v2/yM/r/IqonxdwHUtT.css";
// undefined
o17 = null;
// 1225
o17 = {};
// 1226
o16["2"] = o17;
// 1227
o17.rel = "stylesheet";
// 1229
o17.href = "http://jsbngssl.static.xx.fbcdn.net/rsrc.php/v2/yP/r/9mw4nQDxDC9.css";
// undefined
o17 = null;
// 1238
o17 = {};
// 1239
o16["3"] = o17;
// 1240
o17.rel = "stylesheet";
// 1242
o17.href = "http://jsbngssl.static.xx.fbcdn.net/rsrc.php/v2/y1/r/i2fjJiK4liE.css";
// undefined
o17 = null;
// 1245
o17 = {};
// 1246
o16["4"] = o17;
// 1247
o17.rel = "stylesheet";
// 1249
o17.href = "http://jsbngssl.static.xx.fbcdn.net/rsrc.php/v2/yL/r/OO7ppcHlCNm.css";
// undefined
o17 = null;
// 1254
o17 = {};
// 1255
o16["5"] = o17;
// 1256
o17.rel = "stylesheet";
// 1258
o17.href = "http://jsbngssl.static.xx.fbcdn.net/rsrc.php/v2/yi/r/4oH7eQzJjdc.css";
// undefined
o17 = null;
// 1263
o17 = {};
// 1264
o16["6"] = o17;
// 1265
o17.rel = "stylesheet";
// 1267
o17.href = "http://jsbngssl.static.xx.fbcdn.net/rsrc.php/v2/ys/r/1DOzCljCl3K.css";
// undefined
o17 = null;
// 1272
o17 = {};
// 1273
o16["7"] = o17;
// 1274
o17.rel = "shortcut icon";
// undefined
o17 = null;
// 1276
o17 = {};
// 1277
o16["8"] = o17;
// undefined
o16 = null;
// 1278
o17.rel = "stylesheet";
// 1280
o17.href = "http://jsbngssl.static.xx.fbcdn.net/rsrc.php/v2/yD/r/OWwnO_yMqhK.css";
// undefined
o17 = null;
// 1360
f81632121_467.returns.push(1374851214075);
// 1362
f81632121_467.returns.push(1374851214075);
// 1363
f81632121_14.returns.push(undefined);
// 1364
f81632121_12.returns.push(2);
// 1369
f81632121_467.returns.push(1374851214076);
// 1370
o16 = {};
// 1371
o0.body = o16;
// 1372
f81632121_502 = function() { return f81632121_502.returns[f81632121_502.inst++]; };
f81632121_502.returns = [];
f81632121_502.inst = 0;
// 1373
o16.getElementsByTagName = f81632121_502;
// 1374
f81632121_503 = function() { return f81632121_503.returns[f81632121_503.inst++]; };
f81632121_503.returns = [];
f81632121_503.inst = 0;
// 1375
o0.querySelectorAll = f81632121_503;
// 1376
f81632121_504 = function() { return f81632121_504.returns[f81632121_504.inst++]; };
f81632121_504.returns = [];
f81632121_504.inst = 0;
// 1377
o16.querySelectorAll = f81632121_504;
// 1378
o17 = {};
// 1379
f81632121_504.returns.push(o17);
// 1380
o17.length = 0;
// undefined
o17 = null;
// 1381
f81632121_14.returns.push(undefined);
// 1382
f81632121_12.returns.push(3);
// 1388
o8.clientWidth = 1017;
// 1404
o8.nodeName = "HTML";
// 1405
o8.__FB_TOKEN = void 0;
// 1406
// 1407
f81632121_506 = function() { return f81632121_506.returns[f81632121_506.inst++]; };
f81632121_506.returns = [];
f81632121_506.inst = 0;
// 1408
o8.getAttribute = f81632121_506;
// 1409
f81632121_507 = function() { return f81632121_507.returns[f81632121_507.inst++]; };
f81632121_507.returns = [];
f81632121_507.inst = 0;
// 1410
o8.hasAttribute = f81632121_507;
// 1412
f81632121_507.returns.push(false);
// 1413
o8.JSBNG__addEventListener = f81632121_468;
// 1415
f81632121_468.returns.push(undefined);
// 1416
o8.JSBNG__onmousewheel = null;
// 1421
f81632121_508 = function() { return f81632121_508.returns[f81632121_508.inst++]; };
f81632121_508.returns = [];
f81632121_508.inst = 0;
// 1422
o0.getElementById = f81632121_508;
// 1423
o17 = {};
// 1424
f81632121_508.returns.push(o17);
// 1425
o17.getElementsByTagName = f81632121_502;
// 1427
o17.querySelectorAll = f81632121_504;
// 1428
o18 = {};
// 1429
f81632121_504.returns.push(o18);
// 1430
o18.length = 1;
// 1431
o19 = {};
// 1432
o18["0"] = o19;
// undefined
o18 = null;
// 1433
o19.value = "Gregor Richards";
// 1434
o18 = {};
// 1435
o19.classList = o18;
// 1437
f81632121_513 = function() { return f81632121_513.returns[f81632121_513.inst++]; };
f81632121_513.returns = [];
f81632121_513.inst = 0;
// 1438
o18.contains = f81632121_513;
// 1439
f81632121_513.returns.push(false);
// 1445
o0.activeElement = o16;
// 1447
o16.getAttribute = f81632121_506;
// 1448
f81632121_506.returns.push(null);
// 1450
f81632121_506.returns.push(null);
// 1454
f81632121_468.returns.push(undefined);
// 1456
f81632121_468.returns.push(undefined);
// 1469
// 1470
// 1471
// 1474
f81632121_468.returns.push(undefined);
// 1484
f81632121_467.returns.push(1374851214103);
// 1490
f81632121_467.returns.push(1374851214104);
// 1492
f81632121_467.returns.push(1374851214104);
// 1496
f81632121_467.returns.push(1374851214105);
// 1499
f81632121_467.returns.push(1374851214105);
// 1502
f81632121_467.returns.push(1374851214105);
// 1504
f81632121_467.returns.push(1374851214105);
// 1508
o20 = {};
// 1509
f81632121_474.returns.push(o20);
// 1511
f81632121_467.returns.push(1374851214106);
// 1512
o0.createStyleSheet = void 0;
// 1514
o21 = {};
// 1515
f81632121_476.returns.push(o21);
// 1516
// 1517
// 1518
// 1520
o22 = {};
// 1521
f81632121_476.returns.push(o22);
// 1522
// 1523
o20.appendChild = f81632121_478;
// 1524
f81632121_478.returns.push(o22);
// 1526
f81632121_467.returns.push(1374851214112);
// 1527
f81632121_13.returns.push(4);
// 1529
o23 = {};
// 1530
f81632121_476.returns.push(o23);
// 1531
// 1532
// 1533
// 1535
f81632121_478.returns.push(o23);
// 1537
f81632121_478.returns.push(o21);
// undefined
o21 = null;
// 1539
f81632121_478.returns.push(o20);
// undefined
o20 = null;
// 1542
f81632121_467.returns.push(1374851214114);
// 1548
f81632121_467.returns.push(1374851214115);
// 1550
f81632121_467.returns.push(1374851214115);
// 1554
f81632121_467.returns.push(1374851214116);
// 1557
f81632121_467.returns.push(1374851214119);
// 1560
f81632121_467.returns.push(1374851214119);
// 1562
o20 = {};
// 1563
f81632121_508.returns.push(o20);
// 1565
o21 = {};
// 1566
f81632121_508.returns.push(o21);
// 1567
o24 = {};
// 1568
o21.firstChild = o24;
// 1570
o24.nodeType = 8;
// 1572
o24.nodeValue = " <div id=\"pagelet_main_column_personal\" data-referrer=\"pagelet_main_column_personal_timeline\"></div> ";
// undefined
o24 = null;
// 1573
o21.parentNode = o16;
// 1574
f81632121_521 = function() { return f81632121_521.returns[f81632121_521.inst++]; };
f81632121_521.returns = [];
f81632121_521.inst = 0;
// 1575
o16.removeChild = f81632121_521;
// 1576
f81632121_521.returns.push(o21);
// undefined
o21 = null;
// 1577
// 1578
o20.getAttribute = f81632121_506;
// 1579
f81632121_506.returns.push("pagelet_timeline_main_column");
// 1582
f81632121_467.returns.push(1374851214121);
// 1586
o21 = {};
// 1587
f81632121_474.returns.push(o21);
// 1589
f81632121_478.returns.push(o21);
// undefined
o21 = null;
// 1595
f81632121_467.returns.push(1374851214131);
// 1597
f81632121_467.returns.push(1374851214132);
// 1601
f81632121_467.returns.push(1374851214132);
// 1604
f81632121_467.returns.push(1374851214132);
// 1607
f81632121_467.returns.push(1374851214132);
// 1609
o21 = {};
// 1610
f81632121_508.returns.push(o21);
// 1612
o24 = {};
// 1613
f81632121_508.returns.push(o24);
// 1614
o25 = {};
// 1615
o24.firstChild = o25;
// 1617
o25.nodeType = 8;
// 1619
o25.nodeValue = " <div class=\"fbTimelineTopSectionBase -cx-PRIVATE-fbTimelineLightHeader__root -cx-PUBLIC-fbTimelineLightHeader__loading\"><div id=\"pagelet_above_header_timeline\" data-referrer=\"pagelet_above_header_timeline\"></div><div id=\"above_header_timeline_placeholder\"></div><div class=\"fbTimelineSection mtm fbTimelineTopSection\"><div id=\"fbProfileCover\"><div class=\"cover\" id=\"u_0_j\"><a class=\"coverWrap coverImage\" href=\"http://jsbngssl.www.facebook.com/photo.php?fbid=10200268472248551&amp;set=a.3353777797334.2140697.1055580469&amp;type=1\" rel=\"theater\" ajaxify=\"http://jsbngssl.www.facebook.com/photo.php?fbid=10200268472248551&amp;set=a.3353777797334.2140697.1055580469&amp;type=1&amp;src=https%3A%2F%2Fsphotos-a-iad.xx.fbcdn.net%2Fhphotos-ash3%2F1017486_10200268472248551_842609840_n.jpg&amp;size=851%2C315&amp;source=10\" id=\"fbCoverImageContainer\"><img class=\"coverPhotoImg photo img\" src=\"http://jsbngssl.sphotos-a-iad.xx.fbcdn.net/hphotos-ash3/1017486_10200268472248551_842609840_n.jpg\" alt=\"Cover Photo\" style=\"top:0px;width:100%\" data-fbid=\"10200268472248551\" /><div class=\"coverBorder\"></div><img class=\"coverChangeThrobber img\" src=\"http://jsbngssl.static.xx.fbcdn.net/rsrc.php/v2/yk/r/LOOn0JtHNzb.gif\" alt=\"\" width=\"16\" height=\"16\" /></a><div class=\"-cx-PRIVATE-fbTimelineLightHeader__headline\"><h2 class=\"-cx-PRIVATE-fbTimelineLightHeader__name\"><a class=\"-cx-PRIVATE-fbTimelineLightHeader__namelink\" href=\"http://jsbngssl.www.facebook.com/LawlabeeTheWallaby\">Gregor Richards</a></h2></div></div><div id=\"fbTimelineHeadline\" class=\"clearfix\"><div class=\"-cx-PRIVATE-fbTimelineLightHeader__actionbuttonswrap\"><div class=\"actions -cx-PRIVATE-fbTimelineLightHeader__actionbuttons\"><div class=\"actionsDropdown\" id=\"pagelet_timeline_profile_actions\" data-referrer=\"pagelet_timeline_profile_actions\"></div></div></div><div class=\"-cx-PRIVATE-fbTimelineLightHeader__navwrapper\"><div class=\"-cx-PRIVATE-fbTimelineNavLight__root clearfix\" data-referrer=\"timeline_light_nav_top\" id=\"u_0_k\"><a class=\"-cx-PRIVATE-fbTimelineNavLight__item -cx-PRIVATE-fbTimelineNavLight__activeitem\" href=\"http://jsbngssl.www.facebook.com/LawlabeeTheWallaby\">Timeline<span class=\"-cx-PRIVATE-fbTimelineNavLight__tabnub\"></span></a><a class=\"-cx-PRIVATE-fbTimelineNavLight__item\" href=\"http://jsbngssl.www.facebook.com/LawlabeeTheWallaby/about\" data-medley-id=\"pagelet_timeline_medley_about\">About<span class=\"-cx-PRIVATE-fbTimelineNavLight__tabnub\"></span></a><a class=\"-cx-PRIVATE-fbTimelineNavLight__item\" href=\"http://jsbngssl.www.facebook.com/LawlabeeTheWallaby/photos\" data-medley-id=\"pagelet_timeline_medley_photos\">Photos<span class=\"-cx-PRIVATE-fbTimelineNavLight__tabnub\"></span></a><a class=\"-cx-PRIVATE-fbTimelineNavLight__item\" href=\"http://jsbngssl.www.facebook.com/LawlabeeTheWallaby/friends\" data-medley-id=\"pagelet_timeline_medley_friends\">Friends<span class=\"-cx-PRIVATE-fbTimelineNavLight__tabnub\"></span></a><div class=\"-cx-PRIVATE-uiInlineBlock__root uiPopover -cx-PRIVATE-fbTimelineNavLight__item -cx-PRIVATE-fbTimelineNavLight__itemdropdown\" id=\"u_0_l\"><a class=\"-cx-PRIVATE-fbTimelineNavLight__dropdownitembutton -cx-PRIVATE-uiPopover__trigger\" href=\"#\" aria-haspopup=\"true\" aria-expanded=\"false\" rel=\"toggle\" role=\"button\" id=\"u_0_m\">More<i class=\"-cx-PRIVATE-fbTimelineNavLight__dropdownitemarrow img sp_4p6kmz sx_4f53fc\"></i></a></div></div></div><div class=\"name\"><div class=\"photoContainer\"><a class=\"profilePicThumb\" id=\"profile_pic_education\" href=\"http://jsbngssl.www.facebook.com/photo.php?fbid=10200268473688587&amp;set=a.1468918877039.2062262.1055580469&amp;type=1&amp;source=11\" rel=\"theater\"><img class=\"profilePic img\" src=\"http://jsbngssl.fbcdn-profile-a.akamaihd.net/hprofile-ak-frc3/c55.0.552.552/s160x160/993004_10200268473688587_517108607_n.jpg\" alt=\"Gregor Richards\" /></a><meta itemprop=\"image\" content=\"http://jsbngssl.fbcdn-profile-a.akamaihd.net/hprofile-ak-prn2/276274_1055580469_962040234_q.jpg\" /></div></div></div><div id=\"timeline_sticky_header\" data-referrer=\"timeline_sticky_header\"></div></div><div id=\"fbSuggestionsPlaceHolder\"></div></div><div id=\"pagelet_escape_hatch\" data-referrer=\"pagelet_escape_hatch\"></div></div><div id=\"timeline_tab_content\"><div id=\"pagelet_timeline_recent\" data-referrer=\"pagelet_timeline_recent\"></div><div id=\"timeline_tab_content_extra\"></div></div> ";
// undefined
o25 = null;
// 1620
o24.parentNode = o16;
// 1622
f81632121_521.returns.push(o24);
// undefined
o24 = null;
// 1623
// 1624
o21.getAttribute = f81632121_506;
// 1625
f81632121_506.returns.push("pagelet_main_column_personal_timeline");
// 1633
o24 = {};
// 1634
f81632121_476.returns.push(o24);
// 1635
// 1636
// 1637
o24.getElementsByTagName = f81632121_502;
// 1638
o25 = {};
// 1639
f81632121_502.returns.push(o25);
// 1640
o25.length = 0;
// undefined
o25 = null;
// 1642
o25 = {};
// 1643
o24.childNodes = o25;
// undefined
o24 = null;
// 1644
o25.nodeType = void 0;
// 1645
o25.getAttributeNode = void 0;
// 1646
o25.getElementsByTagName = void 0;
// 1647
o25.childNodes = void 0;
// 1659
o24 = {};
// 1660
f81632121_508.returns.push(o24);
// 1664
o16.scrollWidth = 1017;
// 1665
o16.scrollHeight = 727;
// 1667
f81632121_508.returns.push(o20);
// 1668
o26 = {};
// 1669
o20.style = o26;
// 1670
// undefined
o26 = null;
// 1671
f81632121_11.returns.push(undefined);
// 1683
f81632121_467.returns.push(1374851214231);
// 1687
o26 = {};
// 1688
f81632121_474.returns.push(o26);
// 1690
f81632121_478.returns.push(o26);
// undefined
o26 = null;
// 1696
f81632121_467.returns.push(1374851214232);
// 1698
f81632121_467.returns.push(1374851214232);
// 1702
f81632121_467.returns.push(1374851214232);
// 1705
f81632121_467.returns.push(1374851214233);
// 1708
f81632121_467.returns.push(1374851214233);
// 1710
o26 = {};
// 1711
f81632121_508.returns.push(o26);
// 1713
o27 = {};
// 1714
f81632121_508.returns.push(o27);
// 1715
o28 = {};
// 1716
o27.firstChild = o28;
// 1718
o28.nodeType = 8;
// 1720
o28.nodeValue = " <div class=\"escapeHatchMinimal -cx-PRIVATE-fbTimelineEscapeHatch__root\"><div class=\"-cx-PRIVATE-fbTimelineLightReportHeader__root -cx-PRIVATE-fbTimelineEscapeHatch__header\"><div class=\"-cx-PRIVATE-fbTimelineLightReportHeader__titlecontainer\" data-ft=\"&#123;&quot;tn&quot;:&quot;C&quot;&#125;\"><div class=\"fsm fwn fcg\"><span class=\"-cx-PRIVATE-fbTimelineLightReportHeader__text -cx-PRIVATE-fbTimelineLightReportHeader__title\"><span>Do you know Gregor?</span></span></div></div></div><div class=\"pam uiBoxWhite noborder\"><div><div class=\"-cx-PRIVATE-fbTimelineEscapeHatch__addfriendbutton\"><div class=\"FriendButton\" id=\"u_0_q\"><label class=\"FriendRequestAdd addButton selected uiButton uiButtonSpecial uiButtonLarge\" for=\"u_0_r\"><i class=\"mrs img sp_at8kd9 sx_aad3a2\"></i><input value=\"Add Friend\" type=\"button\" id=\"u_0_r\" /></label><a class=\"FriendRequestOutgoing enableFriendListFlyout outgoingButton enableFriendListFlyout hidden_elem selected uiButton uiButtonSpecial uiButtonLarge\" href=\"#\" role=\"button\" data-profileid=\"1055580469\" data-flloc=\"escape_hatch\" data-cansuggestfriends=\"false\"><i class=\"mrs img sp_at8kd9 sx_aad3a2\"></i><span class=\"uiButtonText\">Friend Request Sent</span></a></div></div><div class=\"phs pbs -cx-PRIVATE-fbTimelineEscapeHatch__noticetext\"><div class=\"pbs prm fsl\"></div><span class=\"fsl fcg\"><span id=\"u_0_s\"><span class=\"addFriendText\">To see what he shares with friends, <a class=\"addButton\" href=\"#\" role=\"button\">send him a friend request.</a></span><span class=\"hidden_elem enableFriendListFlyout outgoingButton\" data-profileid=\"1055580469\">Request Sent.</span></span></span></div></div></div><div id=\"fbSuggestionsHatchPlaceHolder\"></div></div> ";
// undefined
o28 = null;
// 1721
o27.parentNode = o16;
// 1723
f81632121_521.returns.push(o27);
// undefined
o27 = null;
// 1724
// 1725
o26.getAttribute = f81632121_506;
// 1726
f81632121_506.returns.push("pagelet_escape_hatch");
// 1737
f81632121_467.returns.push(1374851214252);
// 1741
o27 = {};
// 1742
f81632121_474.returns.push(o27);
// 1744
f81632121_478.returns.push(o27);
// undefined
o27 = null;
// 1750
f81632121_467.returns.push(1374851214263);
// 1752
f81632121_467.returns.push(1374851214263);
// 1756
f81632121_467.returns.push(1374851214264);
// 1759
f81632121_467.returns.push(1374851214264);
// 1762
f81632121_467.returns.push(1374851214264);
// 1764
o27 = {};
// 1765
f81632121_508.returns.push(o27);
// 1766
o27.getAttribute = f81632121_506;
// 1767
f81632121_506.returns.push("pagelet_above_header_timeline");
// 1783
f81632121_467.returns.push(1374851214270);
// 1787
o28 = {};
// 1788
f81632121_474.returns.push(o28);
// 1790
f81632121_478.returns.push(o28);
// undefined
o28 = null;
// 1796
f81632121_467.returns.push(1374851214276);
// 1798
f81632121_467.returns.push(1374851214277);
// 1802
f81632121_467.returns.push(1374851214277);
// 1805
f81632121_467.returns.push(1374851214277);
// 1808
f81632121_467.returns.push(1374851214277);
// 1810
o28 = {};
// 1811
f81632121_508.returns.push(o28);
// 1813
o29 = {};
// 1814
f81632121_508.returns.push(o29);
// 1815
o30 = {};
// 1816
o29.firstChild = o30;
// 1818
o30.nodeType = 8;
// 1820
o30.nodeValue = " <span class=\"uiButtonGroup uiButtonGroupOverlay\" id=\"u_0_u\"><span class=\"firstItem lastItem uiButtonGroupItem buttonItem\"><div class=\"profileHeaderButton FriendButton\" id=\"u_0_16\"><label class=\"FriendRequestAdd addButton uiButton uiButtonOverlay uiButtonLarge\" for=\"u_0_17\"><i class=\"mrs img sp_at8kd9 sx_aad3a2\"></i><input value=\"Add Friend\" type=\"button\" id=\"u_0_17\" /></label><a class=\"FriendRequestOutgoing enableFriendListFlyout outgoingButton enableFriendListFlyout hidden_elem uiButton uiButtonOverlay uiButtonLarge\" href=\"#\" role=\"button\" data-profileid=\"1055580469\" data-flloc=\"fbx_top_bar\" data-cansuggestfriends=\"false\"><i class=\"mrs img sp_at8kd9 sx_aad3a2\"></i><span class=\"uiButtonText\">Friend Request Sent</span></a></div></span></span><span class=\"uiButtonGroup uiButtonGroupOverlay\" id=\"u_0_v\"><span class=\"firstItem lastItem uiButtonGroupItem buttonItem\"><span class=\"-cx-PRIVATE-uiSwapButton__root -cx-PRIVATE-fbSubscribeButton__root profileHeaderButton\"><a class=\"uiButton uiButtonOverlay uiButtonLarge\" href=\"#\" role=\"button\" ajaxify=\"/ajax/follow/follow_profile.php?profile_id=1055580469&amp;location=1\" rel=\"async-post\" id=\"u_0_12\"><i class=\"mrs img sp_at8kd9 sx_dedf3e\"></i><span class=\"uiButtonText\">Follow</span></a><label class=\"profileFollowButton -cx-PUBLIC-uiHoverButton__root -cx-PRIVATE-uiSwapButton__secondbutton hidden_elem uiButton uiButtonOverlay uiButtonLarge\" id=\"u_0_13\" for=\"u_0_15\"><i class=\"mrs img sp_at8kd9 sx_d4ea38\"></i><input value=\"Following\" aria-haspopup=\"1\" data-profileid=\"1055580469\" type=\"submit\" id=\"u_0_15\" /></label></span></span></span><span class=\"uiButtonGroup actionsContents uiButtonGroupOverlay\" id=\"u_0_w\"><span class=\"firstItem uiButtonGroupItem buttonItem\"><a class=\"uiButton uiButtonOverlay uiButtonLarge\" href=\"/messages/LawlabeeTheWallaby\" role=\"button\" ajaxify=\"/ajax/messaging/composer.php?ids%5B0%5D=1055580469&amp;ref=timeline\" rel=\"dialog\"><span class=\"uiButtonText\">Message</span></a></span><span class=\"lastItem uiButtonGroupItem selectorItem\"><div class=\"uiSelector inlineBlock fbTimelineActionSelector uiSelectorRight\"><div class=\"uiToggle wrap\"><a class=\"fbTimelineActionSelectorButton uiSelectorButton uiButton uiButtonOverlay uiButtonLarge uiButtonNoText\" href=\"#\" role=\"button\" aria-label=\"Other actions\" aria-haspopup=\"1\" rel=\"toggle\"><i class=\"mrs img sp_at8kd9 sx_7e8063\"></i><span class=\"uiButtonText\"></span></a><div class=\"uiSelectorMenuWrapper uiToggleFlyout\"><div class=\"uiMenuContainer uiSelectorMenu\"><div role=\"menu\" class=\"uiMenu\" id=\"u_0_y\"><ul class=\"uiMenuInner\"><li class=\"uiMenuItem\" data-label=\"Add to Interest Lists...\" id=\"u_0_z\"><a class=\"itemAnchor\" role=\"menuitem\" tabindex=\"0\" href=\"#\"><span class=\"itemLabel fsm\">Add to Interest Lists...</span></a></li><li class=\"uiMenuSeparator\"></li><li class=\"uiMenuItem\" data-label=\"Report/Block...\"><a class=\"itemAnchor\" role=\"menuitem\" tabindex=\"-1\" href=\"/ajax/report/social.php?content_type=0&amp;cid=1055580469&amp;rid=1055580469&amp;from_gear=timeline\" rel=\"dialog\"><span class=\"itemLabel fsm\">Report/Block...</span></a></li></ul></div><div role=\"menu\" class=\"uiMenu hidden_elem\" id=\"u_0_x\"><ul class=\"uiMenuInner\"><li class=\"uiMenuItem\" data-label=\"Go Back\" id=\"u_0_10\"><a class=\"itemAnchor\" role=\"menuitem\" tabindex=\"0\" href=\"#\"><span class=\"itemLabel fsm\">Go Back</span></a></li><li class=\"uiMenuSeparator\"></li><img class=\"mal pal center img\" src=\"http://jsbngssl.static.xx.fbcdn.net/rsrc.php/v2/yk/r/LOOn0JtHNzb.gif\" alt=\"\" id=\"u_0_11\" width=\"16\" height=\"16\" /></ul></div></div></div></div></div></span></span> ";
// undefined
o30 = null;
// 1821
o29.parentNode = o16;
// 1823
f81632121_521.returns.push(o29);
// undefined
o29 = null;
// 1824
// 1825
o28.getAttribute = f81632121_506;
// 1826
f81632121_506.returns.push("pagelet_timeline_profile_actions");
// 1834
o29 = {};
// 1835
f81632121_476.returns.push(o29);
// 1836
// 1837
// 1838
o29.getElementsByTagName = f81632121_502;
// 1839
o30 = {};
// 1840
f81632121_502.returns.push(o30);
// 1841
o30.length = 0;
// undefined
o30 = null;
// 1843
o30 = {};
// 1844
o29.childNodes = o30;
// undefined
o29 = null;
// 1845
o30.nodeType = void 0;
// 1846
o30.getAttributeNode = void 0;
// 1847
o30.getElementsByTagName = void 0;
// 1848
o30.childNodes = void 0;
// 1876
f81632121_467.returns.push(1374851214307);
// 1880
o29 = {};
// 1881
f81632121_474.returns.push(o29);
// 1883
f81632121_478.returns.push(o29);
// undefined
o29 = null;
// 1886
f81632121_467.returns.push(1374851214307);
// 1892
f81632121_467.returns.push(1374851214308);
// 1894
f81632121_467.returns.push(1374851214308);
// 1898
f81632121_467.returns.push(1374851214309);
// 1901
f81632121_467.returns.push(1374851214309);
// 1904
f81632121_467.returns.push(1374851214309);
// 1906
o29 = {};
// 1907
f81632121_508.returns.push(o29);
// 1909
o31 = {};
// 1910
f81632121_508.returns.push(o31);
// 1911
o32 = {};
// 1912
o31.firstChild = o32;
// 1914
o32.nodeType = 8;
// 1916
o32.nodeValue = " <div class=\"fbTimelineSection fbTimelineCompactSection fbTimelineSectionTransparent\" id=\"u_0_1a\"><div class=\"fbTimelineCapsule clearfix\" data-referrer=\"pagelet_timeline_recent_ocm\" data-start=\"1359397174\" data-end=\"1375340399\" id=\"u_0_19\"><div class=\"-cx-PUBLIC-timelineOneColMin__leftcapsulecontainer\"><ol class=\"-cx-PUBLIC-timelineOneColMin__leftcapsule clearfix\" data-referrer=\"pagelet_timeline_recent_ocm\" id=\"u_0_19_left\"></ol><div id=\"pagelet_timeline_recent_more_pager\"></div></div><div class=\"-cx-PUBLIC-timelineOneColMin__rightcapsulecontainer\"><ol class=\"-cx-PUBLIC-timelineOneColMin__rightcapsule clearfix\" data-referrer=\"pagelet_timeline_recent_ocm\" id=\"u_0_19_right\"></ol></div></div><div class=\"fbTimelineSubSections\"></div></div><div class=\"hidden_elem fbTimelineSectionExpandPager fbTimelineShowOlderSections\" id=\"u_0_1a_scroll_trigger\"><div class=\"uiMorePager\"><a class=\"uiMorePagerPrimary\" href=\"#\" role=\"button\">Show Older Stories</a></div></div> ";
// undefined
o32 = null;
// 1917
o31.parentNode = o16;
// 1919
f81632121_521.returns.push(o31);
// undefined
o31 = null;
// 1920
// 1921
o29.getAttribute = f81632121_506;
// 1922
f81632121_506.returns.push("pagelet_timeline_recent");
// 1930
f81632121_467.returns.push(1374851214320);
// 1934
o31 = {};
// 1935
f81632121_474.returns.push(o31);
// 1937
f81632121_478.returns.push(o31);
// undefined
o31 = null;
// 1943
f81632121_467.returns.push(1374851214322);
// 1945
f81632121_467.returns.push(1374851214323);
// 1949
f81632121_467.returns.push(1374851214323);
// 1952
f81632121_467.returns.push(1374851214324);
// 1955
f81632121_467.returns.push(1374851214324);
// 1957
o31 = {};
// 1958
f81632121_508.returns.push(o31);
// 1959
o31.getAttribute = f81632121_506;
// 1960
f81632121_506.returns.push("pagelet_timeline_recent_ocm");
// 1962
f81632121_467.returns.push(1374851214325);
// 1966
o32 = {};
// 1967
f81632121_474.returns.push(o32);
// 1969
f81632121_478.returns.push(o32);
// undefined
o32 = null;
// 1975
f81632121_467.returns.push(1374851214353);
// 1977
f81632121_467.returns.push(1374851214353);
// 1981
f81632121_467.returns.push(1374851214354);
// 1984
f81632121_467.returns.push(1374851214354);
// 1987
f81632121_467.returns.push(1374851214354);
// 1989
f81632121_508.returns.push(o31);
// 1991
o32 = {};
// 1992
f81632121_508.returns.push(o32);
// 1993
o33 = {};
// 1994
o32.firstChild = o33;
// 1996
o33.nodeType = 8;
// 1998
o33.nodeValue = " <li class=\"fbTimelineUnit fbTimelineTwoColumn clearfix\" data-side=\"l\" data-fixed=\"1\" data-size=\"1\" id=\"tl_unit_1267290328123522761\"><div class=\"topBorder\"></div><div class=\"timelineUnitContainer\" id=\"u_0_1l\" data-gt=\"&#123;&quot;eventtime&quot;:&quot;1374851147&quot;,&quot;viewerid&quot;:&quot;100006118350059&quot;,&quot;profileownerid&quot;:&quot;1055580469&quot;,&quot;unitimpressionid&quot;:&quot;b1113c18&quot;,&quot;contentid&quot;:&quot;1267290328123522761&quot;,&quot;timeline_unit_type&quot;:&quot;AddSinglePhotoUnit&quot;,&quot;timewindowsize&quot;:&quot;3&quot;,&quot;query_type&quot;:&quot;39&quot;,&quot;contextwindowstart&quot;:&quot;0&quot;,&quot;contextwindowend&quot;:&quot;1375340399&quot;&#125;\" data-time=\"1374637162\"><div class=\"\"><div role=\"article\"><div class=\"clearfix mbs pbs -cx-PRIVATE-fbTimelineUnitActor__root\"><a class=\"-cx-PUBLIC-fbTimelineUnitActor__imagewrap -cx-PRIVATE-uiImageBlockDeprecated__image -cx-PRIVATE-uiImageBlockDeprecated__smallimage\" href=\"http://jsbngssl.www.facebook.com/LawlabeeTheWallaby?hc_location=timeline\" data-ft=\"&#123;&quot;tn&quot;:&quot;\\\\u003C&quot;&#125;\" tabindex=\"-1\" aria-hidden=\"true\" data-hovercard=\"/ajax/hovercard/user.php?id=1055580469&amp;extragetparams=%7B%22hc_location%22%3A%22timeline%22%7D\"><img class=\"-cx-PRIVATE-fbTimelineUnitActor__image img\" src=\"http://jsbngssl.fbcdn-profile-a.akamaihd.net/hprofile-ak-prn2/276274_1055580469_962040234_q.jpg\" alt=\"\" /></a><div class=\"-cx-PRIVATE-uiImageBlockDeprecated__smallcontent -cx-PRIVATE-uiImageBlockDeprecated__content\"><h5 class=\"-cx-PRIVATE-fbTimelineUnitActor__header\" data-ft=\"&#123;&quot;tn&quot;:&quot;C&quot;&#125;\"><span class=\"fcg\"><span class=\"fwb\" data-ft=\"&#123;&quot;tn&quot;:&quot;;&quot;&#125;\"><a href=\"http://jsbngssl.www.facebook.com/LawlabeeTheWallaby?hc_location=timeline\" data-hovercard=\"/ajax/hovercard/user.php?id=1055580469&amp;extragetparams=%7B%22hc_location%22%3A%22timeline%22%7D\">Gregor Richards</a></span></span> </h5><div class=\"-cx-PRIVATE-fbTimelineUnitActor__timestamp fsm fwn fcg\"><a class=\"uiLinkSubtle\" href=\"http://jsbngssl.www.facebook.com/photo.php?fbid=10200453104264236&amp;set=a.1138433375108.2021456.1055580469&amp;type=1\"><abbr title=\"Tuesday, July 23, 2013 at 11:39pm\" data-utime=\"1374647962\">Tuesday</abbr></a><a data-hover=\"tooltip\" aria-label=\"Public\" class=\"uiStreamPrivacy inlineBlock fbStreamPrivacy fbPrivacyAudienceIndicator -cx-PRIVATE-fbTimelineUnitActor__privacy\" href=\"#\" role=\"button\"><i class=\"lock img sp_at8kd9 sx_7236dd\"></i></a></div></div></div><div class=\"aboveUnitContent\"><div class=\"userContentWrapper\"><div class=\"-cx-PRIVATE-fbTimelineText__featured\"><span class=\"userContent\">Dammit Steam sale...</span> </div></div></div><div class=\"photoUnit clearfix\"><div class=\"-cx-PUBLIC-fbInlineActions__container uiScaledThumb photo photoWidth1\" data-gt=\"&#123;&quot;fbid&quot;:&quot;10200453104264236&quot;&#125;\" data-ft=\"&#123;&quot;tn&quot;:&quot;E&quot;&#125;\"><a class=\"-cx-PUBLIC-fbInlineActions__photolink\" href=\"http://jsbngssl.www.facebook.com/photo.php?fbid=10200453104264236&amp;set=a.1138433375108.2021456.1055580469&amp;type=1&amp;relevant_count=1\" rel=\"theater\" ajaxify=\"http://jsbngssl.www.facebook.com/photo.php?fbid=10200453104264236&amp;set=a.1138433375108.2021456.1055580469&amp;type=1&amp;relevant_count=1&amp;src=https%3A%2F%2Ffbcdn-sphotos-h-a.akamaihd.net%2Fhphotos-ak-prn2%2F1069167_10200453104264236_1772112196_n.jpg&amp;size=652%2C800&amp;theater&amp;source=9\"><div class=\"uiScaledImageContainer photoWrap\"><img class=\"scaledImageFitWidth img\" src=\"http://jsbngssl.fbcdn-sphotos-h-a.akamaihd.net/hphotos-ak-prn2/p480x480/1069167_10200453104264236_1772112196_n.jpg\" alt=\"Photo: Dammit Steam sale...\" width=\"504\" height=\"618\" /></div></a></div></div></div><div class=\"fbTimelineUFI uiCommentContainer\"><script type=\"text/javascript\">try {\n    ((JSBNG_Record.scriptLoad)((\"function ef0e1392a4bcb2d0e3238da53a0cec251408776ad(event) {\\u000a    return ((window.Event && Event.__inlineSubmit) && Event.__inlineSubmit(this, event));\\u000a};\"), (\"s772cabb23e047788ade71caa5fa2e1b1ffcf8e72\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    function ef0e1392a4bcb2d0e3238da53a0cec251408776ad(JSBNG__event) {\n        if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n            return ((JSBNG_Record.eventCall)((arguments.callee), (\"s772cabb23e047788ade71caa5fa2e1b1ffcf8e72_0\"), (s772cabb23e047788ade71caa5fa2e1b1ffcf8e72_0_instance), (this), (arguments)))\n        };\n        (null);\n        return (((((JSBNG_Record.get)(window, (\"JSBNG__Event\")))[(\"JSBNG__Event\")]) && (((JSBNG_Record.get)(JSBNG__Event, (\"__inlineSubmit\")))[(\"__inlineSubmit\")])) && (((JSBNG_Record.get)(JSBNG__Event, (\"__inlineSubmit\")))[(\"__inlineSubmit\")])(this, JSBNG__event));\n    };\n    var s772cabb23e047788ade71caa5fa2e1b1ffcf8e72_0_instance;\n    ((s772cabb23e047788ade71caa5fa2e1b1ffcf8e72_0_instance) = ((JSBNG_Record.eventInstance)((\"s772cabb23e047788ade71caa5fa2e1b1ffcf8e72_0\"))));\n    ((JSBNG_Record.markFunction)((ef0e1392a4bcb2d0e3238da53a0cec251408776ad)));\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};</script><form rel=\"async\" class=\"live_10200453104264236_316526391751760 commentable_item autoexpand_mode\" method=\"post\" action=\"/ajax/ufi/modify.php\" data-live=\"&#123;&quot;seq&quot;:&quot;10200453104264236_3198160&quot;&#125;\" id=\"u_0_1r\" onsubmit=\"return ef0e1392a4bcb2d0e3238da53a0cec251408776ad.call(this, event);\"><input type=\"hidden\" name=\"charset_test\" value=\"&euro;,&acute;,€,´,水,Д,Є\" /><input type=\"hidden\" name=\"fb_dtsg\" value=\"AQApxIm6\" autocomplete=\"off\" /><input type=\"hidden\" autocomplete=\"off\" name=\"feedback_params\" value=\"&#123;&quot;actor&quot;:&quot;1055580469&quot;,&quot;target_fbid&quot;:&quot;10200453104264236&quot;,&quot;target_profile_id&quot;:&quot;1055580469&quot;,&quot;type_id&quot;:&quot;7&quot;,&quot;assoc_obj_id&quot;:&quot;&quot;,&quot;source_app_id&quot;:&quot;0&quot;,&quot;extra_story_params&quot;:[],&quot;content_timestamp&quot;:&quot;1374637148&quot;,&quot;check_hash&quot;:&quot;AQCPr0Rvhc8ZTjjR&quot;,&quot;source&quot;:&quot;13&quot;&#125;\" /><input type=\"hidden\" autocomplete=\"off\" name=\"data_only_response\" value=\"1\" /><input type=\"hidden\" autocomplete=\"off\" name=\"timeline_ufi\" value=\"1\" /><input type=\"hidden\" name=\"timeline_log_data\" value=\"AQBNptZHHmcHSBHH338FbJIldzhdcVkA422y6Sejlj24O_ESfCpT1dhcH8BotHbB73c3HUp4765d0qfNUgarP7Vf2rTTbV5euFgCJSt9-8B4i86TjWur6gJ3K29twN6V9lo7fU3rQepgiuZt5KILXg7MqgN_w213GHwJL6FGgcWbUZlVBhXGuoklz4varOFzrDvH_-rITQWylbk82zJBzOEix9PGZ6QnysZWTe0NbHgtmvvEgOVVTF_JPYYKjGJasYG-JYrNmL-tbERXVcwbZ5iFNz9l0M26pG6TZqE6wNK0_l10ScDeVnFbXwhuV6wk73AHZ58nAtgqevhrI3rGzBuPUx02KACTcf1ScQRa2UwIeybAIzG6SY3-kSka4I-DhWD1-EPGDFc5Ff7eeuTE6lPB\" /><div class=\"fbTimelineFeedbackHeader\"><div class=\"fbTimelineFeedbackActions clearfix\"><span></span><span class=\"UIActionLinks UIActionLinks_bottom\" data-ft=\"&#123;&quot;tn&quot;:&quot;=&quot;,&quot;type&quot;:20&#125;\"><button title=\"Like this item\" type=\"submit\" name=\"like\" class=\"like_link stat_elem as_link\" data-ft=\"&#123;&quot;tn&quot;:&quot;&gt;&quot;,&quot;type&quot;:22&#125;\"><span class=\"default_message\">Like</span><span class=\"saving_message\">Unlike</span></button> &#183; <a class=\"share_action_link\" href=\"/ajax/sharer/?s=2&amp;appid=2305272732&amp;p%5B0%5D=1055580469&amp;p%5B1%5D=1073741829&amp;profile_id=1055580469&amp;share_source_type=unknown\" rel=\"dialog\" data-ft=\"&#123;&quot;tn&quot;:&quot;J&quot;,&quot;type&quot;:25&#125;\" title=\"Send this to friends or post it on your timeline.\" role=\"button\">Share</a></span></div></div><div><div class=\"uiUfi UFIContainer\" id=\"u_0_1t\"></div></div></form></div><div class=\"-cx-PRIVATE-fbTimelineLightCurationControl__root\"><div class=\"-cx-PRIVATE-fbTimelineLightStarButton__root lfloat\"><i class=\"-cx-PRIVATE-fbTimelineLightStarButton__icon\"></i></div><div class=\"-cx-PRIVATE-uiInlineBlock__root uiPopover -cx-PRIVATE-fbTimelineLightCurationControl__options\" id=\"u_0_1m\"><a class=\"-cx-PRIVATE-fbEntstreamFeedObjectOptions__button -cx-PRIVATE-uiPopover__trigger\" href=\"#\" aria-haspopup=\"true\" aria-expanded=\"false\" rel=\"toggle\" role=\"button\" id=\"u_0_1n\"></a></div></div></div></div><i class=\"spinePointer\"></i><div class=\"bottomBorder\"></div></li><li class=\"fbTimelineUnit fbTimelineTwoColumn clearfix\" data-side=\"l\" data-fixed=\"1\" data-size=\"1\" id=\"tl_unit_5791137008599102559\"><div class=\"topBorder\"></div><div class=\"timelineUnitContainer\" id=\"u_0_1i\" data-gt=\"&#123;&quot;eventtime&quot;:&quot;1374851147&quot;,&quot;viewerid&quot;:&quot;100006118350059&quot;,&quot;profileownerid&quot;:&quot;1055580469&quot;,&quot;unitimpressionid&quot;:&quot;b1113c18&quot;,&quot;contentid&quot;:&quot;5791137008599102559&quot;,&quot;timeline_unit_type&quot;:&quot;StatusMessageUnit&quot;,&quot;timewindowsize&quot;:&quot;3&quot;,&quot;query_type&quot;:&quot;39&quot;,&quot;contextwindowstart&quot;:&quot;0&quot;,&quot;contextwindowend&quot;:&quot;1375340399&quot;&#125;\" data-time=\"1373991800\"><div class=\"\"><div role=\"article\"><div class=\"clearfix mbs pbs -cx-PRIVATE-fbTimelineUnitActor__root\"><a class=\"-cx-PUBLIC-fbTimelineUnitActor__imagewrap -cx-PRIVATE-uiImageBlockDeprecated__image -cx-PRIVATE-uiImageBlockDeprecated__smallimage\" href=\"http://jsbngssl.www.facebook.com/LawlabeeTheWallaby?hc_location=timeline\" data-ft=\"&#123;&quot;tn&quot;:&quot;\\\\u003C&quot;&#125;\" tabindex=\"-1\" aria-hidden=\"true\" data-hovercard=\"/ajax/hovercard/user.php?id=1055580469&amp;extragetparams=%7B%22hc_location%22%3A%22timeline%22%7D\"><img class=\"-cx-PRIVATE-fbTimelineUnitActor__image img\" src=\"http://jsbngssl.fbcdn-profile-a.akamaihd.net/hprofile-ak-prn2/276274_1055580469_962040234_q.jpg\" alt=\"\" /></a><div class=\"-cx-PRIVATE-uiImageBlockDeprecated__smallcontent -cx-PRIVATE-uiImageBlockDeprecated__content\"><h5 class=\"-cx-PRIVATE-fbTimelineUnitActor__header\" data-ft=\"&#123;&quot;tn&quot;:&quot;C&quot;&#125;\"><span class=\"fcg\"><span class=\"fwb\" data-ft=\"&#123;&quot;tn&quot;:&quot;;&quot;&#125;\"><a href=\"http://jsbngssl.www.facebook.com/LawlabeeTheWallaby?hc_location=timeline\" data-hovercard=\"/ajax/hovercard/user.php?id=1055580469&amp;extragetparams=%7B%22hc_location%22%3A%22timeline%22%7D\">Gregor Richards</a></span></span> </h5><div class=\"-cx-PRIVATE-fbTimelineUnitActor__timestamp fsm fwn fcg\"><a class=\"uiLinkSubtle\" href=\"/LawlabeeTheWallaby/posts/10200407437602598\"><abbr title=\"Tuesday, July 16, 2013 at 12:23pm\" data-utime=\"1374002600\">July 16</abbr></a><a data-hover=\"tooltip\" aria-label=\"Public\" class=\"uiStreamPrivacy inlineBlock fbStreamPrivacy fbPrivacyAudienceIndicator -cx-PRIVATE-fbTimelineUnitActor__privacy\" href=\"#\" role=\"button\"><i class=\"lock img sp_at8kd9 sx_7236dd\"></i></a></div></div></div><div class=\"-cx-PRIVATE-fbTimelineStatusUnit__root\"><div class=\"userContentWrapper\"><div class=\"-cx-PRIVATE-fbTimelineText__featured\"><div id=\"id_51f2904bb941a6d40448274\" class=\"text_exposed_root\"><span data-ft=\"&#123;&quot;tn&quot;:&quot;K&quot;&#125;\" class=\"userContent\">(Guess what time it is!)<br /> <br /> Tomorrow marks the beginning of my 28th circumnavigation of the sun. Because we are a primitive, sun worshiping people, we feel the need to mark this event in various ways.<br /> <br /> As of the posting of this status and effective for forty-eight hours, all content-free birthday-related posts on my wall will be deleted. Comments on this status to that effect will also be deleted.<br /> <br /> <span class=\"text_exposed_hide\">...</span><span class=\"text_exposed_show\">You must consider what it is that you are doing. This is Facebook. It is a repository of information, it is a communication medium, it is many things. I prefer to keep my communication of a higher caliber. Plus the occasional misanthropic screed. Also ponies. Mostly communication of a higher caliber. But that&#039;s somewhat of an aside from the real crux of the issue.<br /> <br /> There is perhaps no gesture less sincere than the Facebook birthday well-wishing. You have been requested by a machine to post two words on my wall, likely followed by an obscene number of exclamation points. As a machine yourself, you have obeyed its request. This is not a polite salutation, it is a vacuous one. It is considerably worse than no gesture whatsoever. I neither require nor desire your mechanistic platitudes, and will, as such, react to eliminate them.<br /> <br /> I will keep note of who posts them before my deletion. If you&#039;re posting this without even bothering to read my own status, and hence see this rather unfriendly message, then that just emphasizes further the vapidity of the sentiment.<br /> <br /> Tomorrow marks the beginning of my 28th circumnavigation of the sun. I celebrate it by being a misanthrope.</span></span><span class=\"text_exposed_hide\"><span class=\"text_exposed_link\"><script type=\"text/javascript\">try {\n    ((JSBNG_Record.scriptLoad)((\"function ed42996c769cb06dfc355d1c314974c5d5c8b9bf6(event) {\\u000a    CSS.addClass($(\\\"id_51f2904bb941a6d40448274\\\"), \\\"text_exposed\\\");\\u000a    Arbiter.inform(\\\"reflow\\\");\\u000a};\"), (\"sf96098d0f7c18cedea4747f29c3aa1b5b9d89936\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    function ed42996c769cb06dfc355d1c314974c5d5c8b9bf6(JSBNG__event) {\n        if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n            return ((JSBNG_Record.eventCall)((arguments.callee), (\"sf96098d0f7c18cedea4747f29c3aa1b5b9d89936_0\"), (sf96098d0f7c18cedea4747f29c3aa1b5b9d89936_0_instance), (this), (arguments)))\n        };\n        (null);\n        (((JSBNG_Record.get)(JSBNG__CSS, (\"addClass\")))[(\"addClass\")])($(\"id_51f2904bb941a6d40448274\"), \"text_exposed\");\n        (((JSBNG_Record.get)(Arbiter, (\"inform\")))[(\"inform\")])(\"reflow\");\n    };\n    var sf96098d0f7c18cedea4747f29c3aa1b5b9d89936_0_instance;\n    ((sf96098d0f7c18cedea4747f29c3aa1b5b9d89936_0_instance) = ((JSBNG_Record.eventInstance)((\"sf96098d0f7c18cedea4747f29c3aa1b5b9d89936_0\"))));\n    ((JSBNG_Record.markFunction)((ed42996c769cb06dfc355d1c314974c5d5c8b9bf6)));\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};</script><a onclick=\"return ed42996c769cb06dfc355d1c314974c5d5c8b9bf6.call(this, event);\" data-ft=\"&#123;&quot;tn&quot;:&quot;e&quot;&#125;\">See More</a></span></span></div></div></div></div></div><div class=\"fbTimelineUFI uiCommentContainer\"><script type=\"text/javascript\">try {\n    ((JSBNG_Record.scriptLoad)((\"function ebba824ec8d66aa790e1b61baae7d64397386f739(event) {\\u000a    return ((window.Event && Event.__inlineSubmit) && Event.__inlineSubmit(this, event));\\u000a};\"), (\"s3b0629883c3e506a08ac0cf99f0ba4cba461dbfb\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    function ebba824ec8d66aa790e1b61baae7d64397386f739(JSBNG__event) {\n        if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n            return ((JSBNG_Record.eventCall)((arguments.callee), (\"s3b0629883c3e506a08ac0cf99f0ba4cba461dbfb_0\"), (s3b0629883c3e506a08ac0cf99f0ba4cba461dbfb_0_instance), (this), (arguments)))\n        };\n        (null);\n        return (((((JSBNG_Record.get)(window, (\"JSBNG__Event\")))[(\"JSBNG__Event\")]) && (((JSBNG_Record.get)(JSBNG__Event, (\"__inlineSubmit\")))[(\"__inlineSubmit\")])) && (((JSBNG_Record.get)(JSBNG__Event, (\"__inlineSubmit\")))[(\"__inlineSubmit\")])(this, JSBNG__event));\n    };\n    var s3b0629883c3e506a08ac0cf99f0ba4cba461dbfb_0_instance;\n    ((s3b0629883c3e506a08ac0cf99f0ba4cba461dbfb_0_instance) = ((JSBNG_Record.eventInstance)((\"s3b0629883c3e506a08ac0cf99f0ba4cba461dbfb_0\"))));\n    ((JSBNG_Record.markFunction)((ebba824ec8d66aa790e1b61baae7d64397386f739)));\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};</script><form rel=\"async\" class=\"live_10200407437602598_316526391751760 commentable_item autoexpand_mode\" method=\"post\" action=\"/ajax/ufi/modify.php\" data-live=\"&#123;&quot;seq&quot;:&quot;10200407437602598_4996311&quot;&#125;\" id=\"u_0_1q\" onsubmit=\"return ebba824ec8d66aa790e1b61baae7d64397386f739.call(this, event);\"><input type=\"hidden\" name=\"charset_test\" value=\"&euro;,&acute;,€,´,水,Д,Є\" /><input type=\"hidden\" name=\"fb_dtsg\" value=\"AQApxIm6\" autocomplete=\"off\" /><input type=\"hidden\" autocomplete=\"off\" name=\"feedback_params\" value=\"&#123;&quot;actor&quot;:&quot;1055580469&quot;,&quot;target_fbid&quot;:&quot;10200407437602598&quot;,&quot;target_profile_id&quot;:&quot;1055580469&quot;,&quot;type_id&quot;:&quot;22&quot;,&quot;assoc_obj_id&quot;:&quot;&quot;,&quot;source_app_id&quot;:&quot;0&quot;,&quot;extra_story_params&quot;:[],&quot;content_timestamp&quot;:&quot;1373991799&quot;,&quot;check_hash&quot;:&quot;AQA-jiNzd4pG_lck&quot;,&quot;source&quot;:&quot;13&quot;&#125;\" /><input type=\"hidden\" autocomplete=\"off\" name=\"data_only_response\" value=\"1\" /><input type=\"hidden\" autocomplete=\"off\" name=\"timeline_ufi\" value=\"1\" /><input type=\"hidden\" name=\"timeline_log_data\" value=\"AQDQFbb-noUffn08-wYWq3sqYkrBn6PemZTva6mbp5t66h4yjEavOAYdkUoacT9VWRl0uDEW7vDbks_tWcJUANE75miHVSFsRLzVp0z6QRS8A-6U-bxgPk4MluQZyAw547yznIXQx6K5k79h3Q5XWXZCoLRpUsMobuUIt5V7QrU3wrLvqhL5bMnzwHbz3QzSYT6d5SwYbBLB-UDRNhNwiVw-SMynyyl0eYXm5Sh70OjHuBFTR0b0dpGqqRbsfSmcbiDTCwszsk-U82fECniRaqHQxpG7Kl5ystDd2c73YJ7j85bFpA6-N8fT1jM32e0sJM7oSj21k3xAu4cp7omIf5ObzedtL5uoB9-D2VKTHaFWRhDg-CzF1cwJDRSRPvlhZ5sWyw1hjgpeB2bGwZymew_x\" /><div class=\"fbTimelineFeedbackHeader\"><div class=\"fbTimelineFeedbackActions clearfix\"><span></span><span class=\"UIActionLinks UIActionLinks_bottom\" data-ft=\"&#123;&quot;tn&quot;:&quot;=&quot;,&quot;type&quot;:20&#125;\"><button title=\"Like this item\" type=\"submit\" name=\"like\" class=\"like_link stat_elem as_link\" data-ft=\"&#123;&quot;tn&quot;:&quot;&gt;&quot;,&quot;type&quot;:22&#125;\"><span class=\"default_message\">Like</span><span class=\"saving_message\">Unlike</span></button> &#183; <a class=\"share_action_link\" href=\"/ajax/sharer/?s=22&amp;appid=25554907596&amp;p%5B0%5D=1055580469&amp;p%5B1%5D=10200407437602598&amp;profile_id=1055580469&amp;share_source_type=unknown\" rel=\"dialog\" data-ft=\"&#123;&quot;tn&quot;:&quot;J&quot;,&quot;type&quot;:25&#125;\" title=\"Send this to friends or post it on your timeline.\" role=\"button\">Share</a></span></div></div><div><div class=\"uiUfi UFIContainer\" id=\"u_0_1x\"></div></div></form></div><div class=\"-cx-PRIVATE-fbTimelineLightCurationControl__root\"><div class=\"-cx-PRIVATE-fbTimelineLightStarButton__root lfloat\"><i class=\"-cx-PRIVATE-fbTimelineLightStarButton__icon\"></i></div><div class=\"-cx-PRIVATE-uiInlineBlock__root uiPopover -cx-PRIVATE-fbTimelineLightCurationControl__options\" id=\"u_0_1j\"><a class=\"-cx-PRIVATE-fbEntstreamFeedObjectOptions__button -cx-PRIVATE-uiPopover__trigger\" href=\"#\" aria-haspopup=\"true\" aria-expanded=\"false\" rel=\"toggle\" role=\"button\" id=\"u_0_1k\"></a></div></div></div></div><i class=\"spinePointer\"></i><div class=\"bottomBorder\"></div></li><li class=\"fbTimelineUnit fbTimelineTwoColumn clearfix\" data-side=\"l\" data-fixed=\"1\" data-size=\"1\" id=\"tl_unit_2953496614934485437\"><div class=\"topBorder\"></div><div class=\"timelineUnitContainer\" id=\"u_0_1f\" data-gt=\"&#123;&quot;eventtime&quot;:&quot;1374851147&quot;,&quot;viewerid&quot;:&quot;100006118350059&quot;,&quot;profileownerid&quot;:&quot;1055580469&quot;,&quot;unitimpressionid&quot;:&quot;b1113c18&quot;,&quot;contentid&quot;:&quot;2953496614934485437&quot;,&quot;timeline_unit_type&quot;:&quot;StatusMessageUnit&quot;,&quot;timewindowsize&quot;:&quot;3&quot;,&quot;query_type&quot;:&quot;39&quot;,&quot;contextwindowstart&quot;:&quot;0&quot;,&quot;contextwindowend&quot;:&quot;1375340399&quot;&#125;\" data-time=\"1373055341\"><div class=\"\"><div role=\"article\"><div class=\"clearfix mbs pbs -cx-PRIVATE-fbTimelineUnitActor__root\"><a class=\"-cx-PUBLIC-fbTimelineUnitActor__imagewrap -cx-PRIVATE-uiImageBlockDeprecated__image -cx-PRIVATE-uiImageBlockDeprecated__smallimage\" href=\"http://jsbngssl.www.facebook.com/LawlabeeTheWallaby?hc_location=timeline\" data-ft=\"&#123;&quot;tn&quot;:&quot;\\\\u003C&quot;&#125;\" tabindex=\"-1\" aria-hidden=\"true\" data-hovercard=\"/ajax/hovercard/user.php?id=1055580469&amp;extragetparams=%7B%22hc_location%22%3A%22timeline%22%7D\"><img class=\"-cx-PRIVATE-fbTimelineUnitActor__image img\" src=\"http://jsbngssl.fbcdn-profile-a.akamaihd.net/hprofile-ak-prn2/276274_1055580469_962040234_q.jpg\" alt=\"\" /></a><div class=\"-cx-PRIVATE-uiImageBlockDeprecated__smallcontent -cx-PRIVATE-uiImageBlockDeprecated__content\"><h5 class=\"-cx-PRIVATE-fbTimelineUnitActor__header\" data-ft=\"&#123;&quot;tn&quot;:&quot;C&quot;&#125;\"><span class=\"fcg\"><span class=\"fwb\" data-ft=\"&#123;&quot;tn&quot;:&quot;;&quot;&#125;\"><a href=\"http://jsbngssl.www.facebook.com/LawlabeeTheWallaby?hc_location=timeline\" data-hovercard=\"/ajax/hovercard/user.php?id=1055580469&amp;extragetparams=%7B%22hc_location%22%3A%22timeline%22%7D\">Gregor Richards</a></span></span> </h5><div class=\"-cx-PRIVATE-fbTimelineUnitActor__timestamp fsm fwn fcg\"><a class=\"uiLinkSubtle\" href=\"/LawlabeeTheWallaby/posts/10200350995551582\"><abbr title=\"Friday, July 5, 2013 at 4:15pm\" data-utime=\"1373066141\">July 5</abbr></a><a data-hover=\"tooltip\" aria-label=\"Public\" class=\"uiStreamPrivacy inlineBlock fbStreamPrivacy fbPrivacyAudienceIndicator -cx-PRIVATE-fbTimelineUnitActor__privacy\" href=\"#\" role=\"button\"><i class=\"lock img sp_at8kd9 sx_7236dd\"></i></a></div></div></div><div class=\"-cx-PRIVATE-fbTimelineStatusUnit__root\"><div class=\"userContentWrapper\"><div class=\"-cx-PRIVATE-fbTimelineText__featured\"><span data-ft=\"&#123;&quot;tn&quot;:&quot;K&quot;&#125;\" class=\"userContent\">In the Place de la Comédie, there was an accordionist with a very nice, presumably authentic French, Musette accordion. A very French scene.<br /> <br /> This man could not play the Musette if his life depended on it. It made me sad. The twit didn&#039;t even TOUCH the bass manual. What an incompetent imbecile.</span></div></div></div></div><div class=\"fbTimelineUFI uiCommentContainer\"><script type=\"text/javascript\">try {\n    ((JSBNG_Record.scriptLoad)((\"function ea50c220f0c56f9626ed836465287113b604bb8c2(event) {\\u000a    return ((window.Event && Event.__inlineSubmit) && Event.__inlineSubmit(this, event));\\u000a};\"), (\"s5d477cde23cb1a7f57a088737efffe8a30cfd7d4\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    function ea50c220f0c56f9626ed836465287113b604bb8c2(JSBNG__event) {\n        if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n            return ((JSBNG_Record.eventCall)((arguments.callee), (\"s5d477cde23cb1a7f57a088737efffe8a30cfd7d4_0\"), (s5d477cde23cb1a7f57a088737efffe8a30cfd7d4_0_instance), (this), (arguments)))\n        };\n        (null);\n        return (((((JSBNG_Record.get)(window, (\"JSBNG__Event\")))[(\"JSBNG__Event\")]) && (((JSBNG_Record.get)(JSBNG__Event, (\"__inlineSubmit\")))[(\"__inlineSubmit\")])) && (((JSBNG_Record.get)(JSBNG__Event, (\"__inlineSubmit\")))[(\"__inlineSubmit\")])(this, JSBNG__event));\n    };\n    var s5d477cde23cb1a7f57a088737efffe8a30cfd7d4_0_instance;\n    ((s5d477cde23cb1a7f57a088737efffe8a30cfd7d4_0_instance) = ((JSBNG_Record.eventInstance)((\"s5d477cde23cb1a7f57a088737efffe8a30cfd7d4_0\"))));\n    ((JSBNG_Record.markFunction)((ea50c220f0c56f9626ed836465287113b604bb8c2)));\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};</script><form rel=\"async\" class=\"live_10200350995551582_316526391751760 commentable_item autoexpand_mode\" method=\"post\" action=\"/ajax/ufi/modify.php\" data-live=\"&#123;&quot;seq&quot;:&quot;10200350995551582_4955918&quot;&#125;\" id=\"u_0_1p\" onsubmit=\"return ea50c220f0c56f9626ed836465287113b604bb8c2.call(this, event);\"><input type=\"hidden\" name=\"charset_test\" value=\"&euro;,&acute;,€,´,水,Д,Є\" /><input type=\"hidden\" name=\"fb_dtsg\" value=\"AQApxIm6\" autocomplete=\"off\" /><input type=\"hidden\" autocomplete=\"off\" name=\"feedback_params\" value=\"&#123;&quot;actor&quot;:&quot;1055580469&quot;,&quot;target_fbid&quot;:&quot;10200350995551582&quot;,&quot;target_profile_id&quot;:&quot;1055580469&quot;,&quot;type_id&quot;:&quot;22&quot;,&quot;assoc_obj_id&quot;:&quot;&quot;,&quot;source_app_id&quot;:&quot;0&quot;,&quot;extra_story_params&quot;:[],&quot;content_timestamp&quot;:&quot;1373055341&quot;,&quot;check_hash&quot;:&quot;AQCBBladrqmNC16S&quot;,&quot;source&quot;:&quot;13&quot;&#125;\" /><input type=\"hidden\" autocomplete=\"off\" name=\"data_only_response\" value=\"1\" /><input type=\"hidden\" autocomplete=\"off\" name=\"timeline_ufi\" value=\"1\" /><input type=\"hidden\" name=\"timeline_log_data\" value=\"AQAlgopmGq0ZHy3R2kG5GCpd5xIfDZrje41Cn5hx-UlsHHRAwheTYxSzlwYwMpREMCS1JzMspOsjwHMvtkLT5mevdKJ5cVCAvAuX27rrKowEqOkMfTMLZUPN1rAxw6MGGS4mPIFncGunb2x4Zvciyb1ByglygI1yMRvuoa0v4NOWz9oh4WDi2m6Yy88oHchGKfGyFif0A5kPret2iWpsleSHzYdahUXoAaZMKVWrob8i3juFAvTKWa-tKVBuqqiY5_tJc35Sx0baaluOD2TWxJk6gE6A0q-OqdD3ula2NuhAZsxRB372jbu-OT-yYpSXLZvKCLeWcqezaITd_2k9ZLyRDI2-ZyHmhsluREWOeZsnozHStiTfaGOkH_uKR5zOCvqJMygffpWg7KXJ8QMncKZt\" /><div class=\"fbTimelineFeedbackHeader\"><div class=\"fbTimelineFeedbackActions clearfix\"><span></span><span class=\"UIActionLinks UIActionLinks_bottom\" data-ft=\"&#123;&quot;tn&quot;:&quot;=&quot;,&quot;type&quot;:20&#125;\"><button title=\"Like this item\" type=\"submit\" name=\"like\" class=\"like_link stat_elem as_link\" data-ft=\"&#123;&quot;tn&quot;:&quot;&gt;&quot;,&quot;type&quot;:22&#125;\"><span class=\"default_message\">Like</span><span class=\"saving_message\">Unlike</span></button> &#183; <a class=\"share_action_link\" href=\"/ajax/sharer/?s=22&amp;appid=25554907596&amp;p%5B0%5D=1055580469&amp;p%5B1%5D=10200350995551582&amp;profile_id=1055580469&amp;share_source_type=unknown\" rel=\"dialog\" data-ft=\"&#123;&quot;tn&quot;:&quot;J&quot;,&quot;type&quot;:25&#125;\" title=\"Send this to friends or post it on your timeline.\" role=\"button\">Share</a></span></div></div><div><div class=\"uiUfi UFIContainer\" id=\"u_0_1v\"></div></div></form></div><div class=\"-cx-PRIVATE-fbTimelineLightCurationControl__root\"><div class=\"-cx-PRIVATE-fbTimelineLightStarButton__root lfloat\"><i class=\"-cx-PRIVATE-fbTimelineLightStarButton__icon\"></i></div><div class=\"-cx-PRIVATE-uiInlineBlock__root uiPopover -cx-PRIVATE-fbTimelineLightCurationControl__options\" id=\"u_0_1g\"><a class=\"-cx-PRIVATE-fbEntstreamFeedObjectOptions__button -cx-PRIVATE-uiPopover__trigger\" href=\"#\" aria-haspopup=\"true\" aria-expanded=\"false\" rel=\"toggle\" role=\"button\" id=\"u_0_1h\"></a></div></div></div></div><i class=\"spinePointer\"></i><div class=\"bottomBorder\"></div></li><li class=\"fbTimelineUnit fbTimelineTwoColumn clearfix\" data-side=\"l\" data-fixed=\"1\" data-size=\"1\" id=\"tl_unit_4498726532280095426\"><div class=\"topBorder\"></div><div class=\"timelineUnitContainer\" id=\"u_0_1c\" data-gt=\"&#123;&quot;eventtime&quot;:&quot;1374851147&quot;,&quot;viewerid&quot;:&quot;100006118350059&quot;,&quot;profileownerid&quot;:&quot;1055580469&quot;,&quot;unitimpressionid&quot;:&quot;b1113c18&quot;,&quot;contentid&quot;:&quot;4498726532280095426&quot;,&quot;timeline_unit_type&quot;:&quot;StatusMessageUnit&quot;,&quot;timewindowsize&quot;:&quot;3&quot;,&quot;query_type&quot;:&quot;39&quot;,&quot;contextwindowstart&quot;:&quot;0&quot;,&quot;contextwindowend&quot;:&quot;1375340399&quot;&#125;\" data-time=\"1372923465\"><div class=\"\"><div role=\"article\"><div class=\"clearfix mbs pbs -cx-PRIVATE-fbTimelineUnitActor__root\"><a class=\"-cx-PUBLIC-fbTimelineUnitActor__imagewrap -cx-PRIVATE-uiImageBlockDeprecated__image -cx-PRIVATE-uiImageBlockDeprecated__smallimage\" href=\"http://jsbngssl.www.facebook.com/LawlabeeTheWallaby?hc_location=timeline\" data-ft=\"&#123;&quot;tn&quot;:&quot;\\\\u003C&quot;&#125;\" tabindex=\"-1\" aria-hidden=\"true\" data-hovercard=\"/ajax/hovercard/user.php?id=1055580469&amp;extragetparams=%7B%22hc_location%22%3A%22timeline%22%7D\"><img class=\"-cx-PRIVATE-fbTimelineUnitActor__image img\" src=\"http://jsbngssl.fbcdn-profile-a.akamaihd.net/hprofile-ak-prn2/276274_1055580469_962040234_q.jpg\" alt=\"\" /></a><div class=\"-cx-PRIVATE-uiImageBlockDeprecated__smallcontent -cx-PRIVATE-uiImageBlockDeprecated__content\"><h5 class=\"-cx-PRIVATE-fbTimelineUnitActor__header\" data-ft=\"&#123;&quot;tn&quot;:&quot;C&quot;&#125;\"><span class=\"fcg\"><span class=\"fwb\" data-ft=\"&#123;&quot;tn&quot;:&quot;;&quot;&#125;\"><a href=\"http://jsbngssl.www.facebook.com/LawlabeeTheWallaby?hc_location=timeline\" data-hovercard=\"/ajax/hovercard/user.php?id=1055580469&amp;extragetparams=%7B%22hc_location%22%3A%22timeline%22%7D\">Gregor Richards</a></span></span> </h5><div class=\"-cx-PRIVATE-fbTimelineUnitActor__timestamp fsm fwn fcg\"><a class=\"uiLinkSubtle\" href=\"/LawlabeeTheWallaby/posts/10200343222477260\"><abbr title=\"Thursday, July 4, 2013 at 3:37am\" data-utime=\"1372934265\">July 4</abbr></a><a data-hover=\"tooltip\" aria-label=\"Public\" class=\"uiStreamPrivacy inlineBlock fbStreamPrivacy fbPrivacyAudienceIndicator -cx-PRIVATE-fbTimelineUnitActor__privacy\" href=\"#\" role=\"button\"><i class=\"lock img sp_at8kd9 sx_7236dd\"></i></a></div></div></div><div class=\"-cx-PRIVATE-fbTimelineStatusUnit__root\"><div class=\"userContentWrapper\"><div class=\"-cx-PRIVATE-fbTimelineText__featured\"><span data-ft=\"&#123;&quot;tn&quot;:&quot;K&quot;&#125;\" class=\"userContent\">This is the second time I&#039;ve been in France on American Independence Day...</span></div></div></div></div><div class=\"fbTimelineUFI uiCommentContainer\"><script type=\"text/javascript\">try {\n    ((JSBNG_Record.scriptLoad)((\"function e2e5acfc36cc20d373a9d0d0e9e3546adb0bbe5af(event) {\\u000a    return ((window.Event && Event.__inlineSubmit) && Event.__inlineSubmit(this, event));\\u000a};\"), (\"sebf71c05c97e4e230be0ee4c1136c69e88ab589a\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    function e2e5acfc36cc20d373a9d0d0e9e3546adb0bbe5af(JSBNG__event) {\n        if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n            return ((JSBNG_Record.eventCall)((arguments.callee), (\"sebf71c05c97e4e230be0ee4c1136c69e88ab589a_0\"), (sebf71c05c97e4e230be0ee4c1136c69e88ab589a_0_instance), (this), (arguments)))\n        };\n        (null);\n        return (((((JSBNG_Record.get)(window, (\"JSBNG__Event\")))[(\"JSBNG__Event\")]) && (((JSBNG_Record.get)(JSBNG__Event, (\"__inlineSubmit\")))[(\"__inlineSubmit\")])) && (((JSBNG_Record.get)(JSBNG__Event, (\"__inlineSubmit\")))[(\"__inlineSubmit\")])(this, JSBNG__event));\n    };\n    var sebf71c05c97e4e230be0ee4c1136c69e88ab589a_0_instance;\n    ((sebf71c05c97e4e230be0ee4c1136c69e88ab589a_0_instance) = ((JSBNG_Record.eventInstance)((\"sebf71c05c97e4e230be0ee4c1136c69e88ab589a_0\"))));\n    ((JSBNG_Record.markFunction)((e2e5acfc36cc20d373a9d0d0e9e3546adb0bbe5af)));\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};</script><form rel=\"async\" class=\"live_10200343222477260_316526391751760 commentable_item autoexpand_mode\" method=\"post\" action=\"/ajax/ufi/modify.php\" data-live=\"&#123;&quot;seq&quot;:&quot;10200343222477260_4950571&quot;&#125;\" id=\"u_0_1o\" onsubmit=\"return e2e5acfc36cc20d373a9d0d0e9e3546adb0bbe5af.call(this, event);\"><input type=\"hidden\" name=\"charset_test\" value=\"&euro;,&acute;,€,´,水,Д,Є\" /><input type=\"hidden\" name=\"fb_dtsg\" value=\"AQApxIm6\" autocomplete=\"off\" /><input type=\"hidden\" autocomplete=\"off\" name=\"feedback_params\" value=\"&#123;&quot;actor&quot;:&quot;1055580469&quot;,&quot;target_fbid&quot;:&quot;10200343222477260&quot;,&quot;target_profile_id&quot;:&quot;1055580469&quot;,&quot;type_id&quot;:&quot;22&quot;,&quot;assoc_obj_id&quot;:&quot;&quot;,&quot;source_app_id&quot;:&quot;0&quot;,&quot;extra_story_params&quot;:[],&quot;content_timestamp&quot;:&quot;1372923465&quot;,&quot;check_hash&quot;:&quot;AQA0MfY19rbYGyj6&quot;,&quot;source&quot;:&quot;13&quot;&#125;\" /><input type=\"hidden\" autocomplete=\"off\" name=\"data_only_response\" value=\"1\" /><input type=\"hidden\" autocomplete=\"off\" name=\"timeline_ufi\" value=\"1\" /><input type=\"hidden\" name=\"timeline_log_data\" value=\"AQAr9lR2vZdldJ-VKsQo7OWaxXGctSzumkX_OWY9tMv34KoO2FztCqmqb8QBDYnKVWW99VqdbOskntjWhjy7W_MUFXYbmHi4oEJJ321uNu0XUYOzGWm_7u7pnY0zKn9thJ5ghe3h9Y4OukyraP07GphpWlsRiSVa_A-1EMIWIdeKmf-CJmEKmfCxEsM18xb2jjadO65ng8zpr6Dn3Z4o7hjV6OmtF3SCq3PgmXDdmdeFwvX8OgXFZncq4jrAd-dd1qH-0sddZKJuEM2b9WV5eyh_PipSNsi3uC6SpYHby30MLarSM5sgjVZxzOxLhdYkWGiF5kRqMgD0DZdRN5FoDtL6gTy-\\-\\Mt8pP_wYiB8kl7IExZc3NIFNruO-xiWNXHnSp7mFJ4K4onngXPGTiY4s_d4\" /><div class=\"fbTimelineFeedbackHeader\"><div class=\"fbTimelineFeedbackActions clearfix\"><span></span><span class=\"UIActionLinks UIActionLinks_bottom\" data-ft=\"&#123;&quot;tn&quot;:&quot;=&quot;,&quot;type&quot;:20&#125;\"><button title=\"Like this item\" type=\"submit\" name=\"like\" class=\"like_link stat_elem as_link\" data-ft=\"&#123;&quot;tn&quot;:&quot;&gt;&quot;,&quot;type&quot;:22&#125;\"><span class=\"default_message\">Like</span><span class=\"saving_message\">Unlike</span></button> &#183; <a class=\"share_action_link\" href=\"/ajax/sharer/?s=22&amp;appid=25554907596&amp;p%5B0%5D=1055580469&amp;p%5B1%5D=10200343222477260&amp;profile_id=1055580469&amp;share_source_type=unknown\" rel=\"dialog\" data-ft=\"&#123;&quot;tn&quot;:&quot;J&quot;,&quot;type&quot;:25&#125;\" title=\"Send this to friends or post it on your timeline.\" role=\"button\">Share</a></span></div></div><div><div class=\"uiUfi UFIContainer\" id=\"u_0_1z\"></div></div></form></div><div class=\"-cx-PRIVATE-fbTimelineLightCurationControl__root\"><div class=\"-cx-PRIVATE-fbTimelineLightStarButton__root lfloat\"><i class=\"-cx-PRIVATE-fbTimelineLightStarButton__icon\"></i></div><div class=\"-cx-PRIVATE-uiInlineBlock__root uiPopover -cx-PRIVATE-fbTimelineLightCurationControl__options\" id=\"u_0_1d\"><a class=\"-cx-PRIVATE-fbEntstreamFeedObjectOptions__button -cx-PRIVATE-uiPopover__trigger\" href=\"#\" aria-haspopup=\"true\" aria-expanded=\"false\" rel=\"toggle\" role=\"button\" id=\"u_0_1e\"></a></div></div></div></div><i class=\"spinePointer\"></i><div class=\"bottomBorder\"></div></li> ";
// undefined
o33 = null;
// 1999
o32.parentNode = o16;
// 2001
f81632121_521.returns.push(o32);
// undefined
o32 = null;
// 2003
o32 = {};
// 2004
f81632121_476.returns.push(o32);
// 2005
// 2007
o33 = {};
// 2008
f81632121_474.returns.push(o33);
// 2009
o34 = {};
// undefined
fo81632121_553_firstChild = function() { return fo81632121_553_firstChild.returns[fo81632121_553_firstChild.inst++]; };
fo81632121_553_firstChild.returns = [];
fo81632121_553_firstChild.inst = 0;
defineGetter(o32, "firstChild", fo81632121_553_firstChild, undefined);
// undefined
o32 = null;
// undefined
fo81632121_553_firstChild.returns.push(o34);
// 2011
o33.appendChild = f81632121_478;
// undefined
fo81632121_553_firstChild.returns.push(o34);
// 2013
f81632121_478.returns.push(o34);
// 2014
o32 = {};
// undefined
fo81632121_553_firstChild.returns.push(o32);
// undefined
fo81632121_553_firstChild.returns.push(o32);
// 2018
f81632121_478.returns.push(o32);
// undefined
o32 = null;
// 2019
o32 = {};
// undefined
fo81632121_553_firstChild.returns.push(o32);
// undefined
fo81632121_553_firstChild.returns.push(o32);
// 2023
f81632121_478.returns.push(o32);
// undefined
o32 = null;
// 2024
o32 = {};
// undefined
fo81632121_553_firstChild.returns.push(o32);
// undefined
fo81632121_553_firstChild.returns.push(o32);
// 2028
f81632121_478.returns.push(o32);
// undefined
o32 = null;
// undefined
fo81632121_553_firstChild.returns.push(null);
// 2030
o31.appendChild = f81632121_478;
// 2031
f81632121_478.returns.push(o33);
// undefined
o33 = null;
// 2033
f81632121_506.returns.push("pagelet_timeline_recent_ocm");
// 2098
o32 = {};
// 2099
f81632121_508.returns.push(o32);
// 2100
o32.id = "u_0_1o";
// 2104
o33 = {};
// 2105
f81632121_508.returns.push(o33);
// 2106
o33.id = "u_0_1p";
// 2110
o35 = {};
// 2111
f81632121_508.returns.push(o35);
// 2112
o35.id = "u_0_1q";
// 2116
o36 = {};
// 2117
f81632121_508.returns.push(o36);
// 2118
o36.id = "u_0_1r";
// 2121
o37 = {};
// 2122
f81632121_476.returns.push(o37);
// 2123
// 2124
o38 = {};
// undefined
fo81632121_563_firstChild = function() { return fo81632121_563_firstChild.returns[fo81632121_563_firstChild.inst++]; };
fo81632121_563_firstChild.returns = [];
fo81632121_563_firstChild.inst = 0;
defineGetter(o37, "firstChild", fo81632121_563_firstChild, undefined);
// undefined
fo81632121_563_firstChild.returns.push(o38);
// undefined
o38 = null;
// 2126
// undefined
fo81632121_563_firstChild.returns.push(null);
// 2128
// undefined
fo81632121_563_firstChild.returns.push(null);
// 2130
// undefined
fo81632121_563_firstChild.returns.push(null);
// 2132
// 2133
o38 = {};
// undefined
fo81632121_563_firstChild.returns.push(o38);
// undefined
o38 = null;
// 2135
// 2136
o38 = {};
// undefined
fo81632121_563_firstChild.returns.push(o38);
// undefined
o38 = null;
// 2138
// 2139
o38 = {};
// undefined
fo81632121_563_firstChild.returns.push(o38);
// undefined
o38 = null;
// 2141
// 2142
o38 = {};
// undefined
fo81632121_563_firstChild.returns.push(o38);
// undefined
o38 = null;
// 2144
// undefined
fo81632121_563_firstChild.returns.push(null);
// 2146
// undefined
fo81632121_563_firstChild.returns.push(null);
// 2148
// undefined
fo81632121_563_firstChild.returns.push(null);
// 2150
// undefined
fo81632121_563_firstChild.returns.push(null);
// 2152
// undefined
fo81632121_563_firstChild.returns.push(null);
// 2154
// undefined
fo81632121_563_firstChild.returns.push(null);
// 2156
// undefined
o37 = null;
// 2157
o37 = {};
// undefined
fo81632121_563_firstChild.returns.push(o37);
// undefined
o37 = null;
// 2160
o37 = {};
// 2161
f81632121_476.returns.push(o37);
// 2162
o38 = {};
// 2163
o0.implementation = o38;
// 2165
f81632121_572 = function() { return f81632121_572.returns[f81632121_572.inst++]; };
f81632121_572.returns = [];
f81632121_572.inst = 0;
// 2166
o38.hasFeature = f81632121_572;
// undefined
o38 = null;
// 2169
f81632121_572.returns.push(false);
// 2171
o38 = {};
// 2172
f81632121_476.returns.push(o38);
// undefined
o38 = null;
// 2174
o38 = {};
// 2175
f81632121_476.returns.push(o38);
// 2176
f81632121_575 = function() { return f81632121_575.returns[f81632121_575.inst++]; };
f81632121_575.returns = [];
f81632121_575.inst = 0;
// 2177
o38.setAttribute = f81632121_575;
// 2178
f81632121_575.returns.push(undefined);
// 2179
o38.JSBNG__onchange = null;
// 2181
// 2182
f81632121_576 = function() { return f81632121_576.returns[f81632121_576.inst++]; };
f81632121_576.returns = [];
f81632121_576.inst = 0;
// 2183
o38.removeAttribute = f81632121_576;
// undefined
o38 = null;
// 2184
f81632121_576.returns.push(undefined);
// 2186
o38 = {};
// 2187
f81632121_476.returns.push(o38);
// 2188
o38.setAttribute = f81632121_575;
// 2189
f81632121_575.returns.push(undefined);
// 2190
o38.JSBNG__oninput = null;
// 2192
// 2193
o38.removeAttribute = f81632121_576;
// undefined
o38 = null;
// 2194
f81632121_576.returns.push(undefined);
// 2195
o38 = {};
// 2196
f81632121_70.returns.push(o38);
// undefined
o38 = null;
// 2197
ow81632121.JSBNG__attachEvent = undefined;
// 2198
f81632121_466.returns.push(0.7659583722706884);
// 2200
o38 = {};
// 2201
f81632121_476.returns.push(o38);
// 2202
// 2203
// 2204
o38.getElementsByTagName = f81632121_502;
// 2205
o39 = {};
// 2206
f81632121_502.returns.push(o39);
// 2207
o39.length = 0;
// undefined
o39 = null;
// 2209
o39 = {};
// 2210
o38.childNodes = o39;
// undefined
o38 = null;
// 2211
o39.nodeType = void 0;
// undefined
o39 = null;
// 2213
o38 = {};
// 2214
f81632121_508.returns.push(o38);
// 2215
o38.id = "u_0_1t";
// 2216
o38.getElementsByTagName = f81632121_502;
// 2217
o39 = {};
// 2218
o38.parentNode = o39;
// 2236
f81632121_467.returns.push(1374851214506);
// 2241
o40 = {};
// 2242
f81632121_504.returns.push(o40);
// 2243
o40.length = 0;
// undefined
o40 = null;
// 2244
f81632121_14.returns.push(undefined);
// 2245
f81632121_12.returns.push(5);
// undefined
fo81632121_582_firstChild = function() { return fo81632121_582_firstChild.returns[fo81632121_582_firstChild.inst++]; };
fo81632121_582_firstChild.returns = [];
fo81632121_582_firstChild.inst = 0;
defineGetter(o38, "firstChild", fo81632121_582_firstChild, undefined);
// undefined
fo81632121_582_firstChild.returns.push(null);
// undefined
fo81632121_582_firstChild.returns.push(null);
// 2258
f81632121_7.returns.push(undefined);
// 2259
ow81632121.JSBNG__onJSBNG__scroll = undefined;
// 2260
f81632121_7.returns.push(undefined);
// 2261
f81632121_585 = function() { return f81632121_585.returns[f81632121_585.inst++]; };
f81632121_585.returns = [];
f81632121_585.inst = 0;
// 2262
ow81632121.JSBNG__onresize = f81632121_585;
// 2265
o0.nodeName = "#document";
// 2266
o0.__FB_TOKEN = void 0;
// 2267
// 2268
o0.getAttribute = void 0;
// 2271
f81632121_468.returns.push(undefined);
// 2272
o0.JSBNG__onmouseover = null;
// 2277
f81632121_468.returns.push(undefined);
// 2278
o0.JSBNG__onmousedown = null;
// 2283
f81632121_468.returns.push(undefined);
// 2284
o0.JSBNG__onmouseup = null;
// 2289
f81632121_468.returns.push(undefined);
// 2290
o0.JSBNG__onmousemove = null;
// 2295
f81632121_468.returns.push(undefined);
// 2296
o0.JSBNG__onmouseout = null;
// 2301
f81632121_468.returns.push(undefined);
// 2302
o0.JSBNG__onclick = null;
// 2307
f81632121_468.returns.push(undefined);
// 2308
o0.JSBNG__ondblclick = null;
// 2313
f81632121_468.returns.push(undefined);
// 2314
o0.JSBNG__onkeyup = null;
// 2319
f81632121_468.returns.push(undefined);
// 2320
o0.JSBNG__onkeypress = null;
// 2325
f81632121_468.returns.push(undefined);
// 2326
o0.JSBNG__onkeydown = null;
// 2331
f81632121_468.returns.push(undefined);
// 2332
o0.JSBNG__oninput = null;
// 2337
f81632121_468.returns.push(undefined);
// 2338
o0.JSBNG__onchange = null;
// 2343
f81632121_468.returns.push(undefined);
// 2344
o0.JSBNG__onselectionchange = null;
// 2349
f81632121_468.returns.push(undefined);
// 2350
o0.JSBNG__onDOMCharacterDataModified = void 0;
// 2353
o40 = {};
// 2354
f81632121_476.returns.push(o40);
// 2355
o40.setAttribute = f81632121_575;
// 2356
f81632121_575.returns.push(undefined);
// 2357
o40.JSBNG__ondrag = null;
// 2359
// 2360
o40.removeAttribute = f81632121_576;
// undefined
o40 = null;
// 2361
f81632121_576.returns.push(undefined);
// 2363
o40 = {};
// 2364
f81632121_476.returns.push(o40);
// 2365
o40.setAttribute = f81632121_575;
// 2366
f81632121_575.returns.push(undefined);
// 2367
o40.JSBNG__onwheel = void 0;
// 2369
o40.removeAttribute = f81632121_576;
// undefined
o40 = null;
// 2370
f81632121_576.returns.push(undefined);
// 2373
f81632121_572.returns.push(false);
// 2375
o40 = {};
// 2376
f81632121_476.returns.push(o40);
// 2377
o40.setAttribute = f81632121_575;
// 2378
f81632121_575.returns.push(undefined);
// 2379
o40.JSBNG__onmousewheel = null;
// 2381
// 2382
o40.removeAttribute = f81632121_576;
// undefined
o40 = null;
// 2383
f81632121_576.returns.push(undefined);
// 2387
f81632121_468.returns.push(undefined);
// 2388
o0.JSBNG__onDOMMouseScroll = void 0;
// 2390
o37.JSBNG__addEventListener = f81632121_468;
// undefined
o37 = null;
// 2392
o37 = {};
// 2393
f81632121_476.returns.push(o37);
// 2394
o37.setAttribute = f81632121_575;
// 2395
f81632121_575.returns.push(undefined);
// 2396
o37.JSBNG__onJSBNG__scroll = void 0;
// 2398
o37.removeAttribute = f81632121_576;
// undefined
o37 = null;
// 2399
f81632121_576.returns.push(undefined);
// 2405
o37 = {};
// 2406
f81632121_476.returns.push(o37);
// 2407
o37.setAttribute = f81632121_575;
// 2408
f81632121_575.returns.push(undefined);
// 2409
o37.JSBNG__onJSBNG__focus = void 0;
// 2411
o37.removeAttribute = f81632121_576;
// undefined
o37 = null;
// 2412
f81632121_576.returns.push(undefined);
// 2414
o37 = {};
// 2415
f81632121_476.returns.push(o37);
// 2416
o37.setAttribute = f81632121_575;
// 2417
f81632121_575.returns.push(undefined);
// 2418
o37.JSBNG__onfocusin = void 0;
// 2420
o37.removeAttribute = f81632121_576;
// undefined
o37 = null;
// 2421
f81632121_576.returns.push(undefined);
// undefined
fo81632121_582_firstChild.returns.push(null);
// 2423
f81632121_466.returns.push(0.982902241172269);
// 2425
f81632121_467.returns.push(1374851214525);
// 2427
f81632121_467.returns.push(1374851214526);
// 2429
o16.nodeName = "BODY";
// 2431
o16.contentEditable = "inherit";
// 2433
f81632121_467.returns.push(1374851214540);
// 2435
f81632121_467.returns.push(1374851214540);
// 2437
f81632121_467.returns.push(1374851214540);
// 2439
f81632121_467.returns.push(1374851214540);
// 2441
f81632121_467.returns.push(1374851214540);
// 2442
o38.nodeType = 1;
// 2446
o37 = {};
// 2447
f81632121_474.returns.push(o37);
// 2449
f81632121_467.returns.push(1374851214554);
// 2451
o40 = {};
// 2452
f81632121_476.returns.push(o40);
// 2453
// 2454
// 2455
// 2456
// 2457
// 2458
// 2459
o37.appendChild = f81632121_478;
// 2460
f81632121_478.returns.push(o40);
// undefined
o40 = null;
// 2462
f81632121_467.returns.push(1374851214554);
// 2464
o40 = {};
// 2465
f81632121_476.returns.push(o40);
// 2466
// 2467
// 2468
// 2469
// 2470
// 2471
// 2473
f81632121_478.returns.push(o40);
// undefined
o40 = null;
// 2475
f81632121_467.returns.push(1374851214555);
// 2477
o40 = {};
// 2478
f81632121_476.returns.push(o40);
// 2479
// 2480
// 2481
// 2482
// 2483
// 2484
// 2486
f81632121_478.returns.push(o40);
// undefined
o40 = null;
// 2488
f81632121_478.returns.push(o37);
// undefined
o37 = null;
// 2490
o37 = {};
// 2491
f81632121_476.returns.push(o37);
// 2492
o37.setAttribute = f81632121_575;
// 2494
f81632121_575.returns.push(undefined);
// 2495
// 2496
o37.firstChild = null;
// 2498
o40 = {};
// 2499
f81632121_474.returns.push(o40);
// 2500
f81632121_598 = function() { return f81632121_598.returns[f81632121_598.inst++]; };
f81632121_598.returns = [];
f81632121_598.inst = 0;
// 2501
o0.createTextNode = f81632121_598;
// 2502
o41 = {};
// 2503
f81632121_598.returns.push(o41);
// 2504
o40.appendChild = f81632121_478;
// 2505
f81632121_478.returns.push(o41);
// undefined
o41 = null;
// 2506
o37.appendChild = f81632121_478;
// 2507
f81632121_478.returns.push(o40);
// undefined
o40 = null;
// 2509
o40 = {};
// 2510
f81632121_476.returns.push(o40);
// 2511
// 2512
// 2513
o41 = {};
// 2514
o40.classList = o41;
// 2516
f81632121_602 = function() { return f81632121_602.returns[f81632121_602.inst++]; };
f81632121_602.returns = [];
f81632121_602.inst = 0;
// 2517
o41.add = f81632121_602;
// undefined
o41 = null;
// 2518
f81632121_602.returns.push(undefined);
// 2520
o41 = {};
// 2521
f81632121_476.returns.push(o41);
// 2522
o41.firstChild = null;
// 2524
o42 = {};
// 2525
f81632121_474.returns.push(o42);
// 2527
o43 = {};
// 2528
f81632121_598.returns.push(o43);
// 2529
o42.appendChild = f81632121_478;
// 2530
f81632121_478.returns.push(o43);
// undefined
o43 = null;
// 2531
o37.__html = void 0;
// undefined
o37 = null;
// 2532
o40.__html = void 0;
// undefined
o40 = null;
// 2533
o41.appendChild = f81632121_478;
// 2534
f81632121_478.returns.push(o42);
// undefined
o42 = null;
// 2535
o41.innerHTML = "When you add a hat it removes the long hair ";
// undefined
o41 = null;
// 2537
f81632121_467.returns.push(1374851214574);
// 2541
o37 = {};
// 2542
f81632121_474.returns.push(o37);
// 2544
f81632121_478.returns.push(o37);
// undefined
o37 = null;
// 2546
o37 = {};
// 2547
f81632121_476.returns.push(o37);
// 2548
o37.firstChild = null;
// 2550
o40 = {};
// 2551
f81632121_474.returns.push(o40);
// 2553
o41 = {};
// 2554
f81632121_598.returns.push(o41);
// 2555
o40.appendChild = f81632121_478;
// 2556
f81632121_478.returns.push(o41);
// undefined
o41 = null;
// 2557
o37.appendChild = f81632121_478;
// 2558
f81632121_478.returns.push(o40);
// undefined
o40 = null;
// 2559
o37.innerHTML = "so.. the hair is a hat?  steam's not down with hats on hats?";
// undefined
o37 = null;
// 2561
f81632121_467.returns.push(1374851214586);
// 2565
o37 = {};
// 2566
f81632121_474.returns.push(o37);
// 2568
f81632121_478.returns.push(o37);
// undefined
o37 = null;
// 2570
o37 = {};
// 2571
f81632121_476.returns.push(o37);
// 2572
o37.firstChild = null;
// 2574
o40 = {};
// 2575
f81632121_474.returns.push(o40);
// 2577
o41 = {};
// 2578
f81632121_598.returns.push(o41);
// 2579
o40.appendChild = f81632121_478;
// 2580
f81632121_478.returns.push(o41);
// undefined
o41 = null;
// 2581
o37.appendChild = f81632121_478;
// 2582
f81632121_478.returns.push(o40);
// undefined
o40 = null;
// 2583
o37.innerHTML = "(This is Saints Row the Third, so can't really blame Steam)";
// undefined
o37 = null;
// 2585
o37 = {};
// 2586
f81632121_476.returns.push(o37);
// 2587
o37.firstChild = null;
// 2589
o40 = {};
// 2590
f81632121_474.returns.push(o40);
// 2592
o41 = {};
// 2593
f81632121_598.returns.push(o41);
// 2594
o40.appendChild = f81632121_478;
// 2595
f81632121_478.returns.push(o41);
// undefined
o41 = null;
// 2596
o37.appendChild = f81632121_478;
// 2597
f81632121_478.returns.push(o40);
// undefined
o40 = null;
// 2598
o37.innerHTML = "No, hats are a separate customization option, but it wouldn't let you combine long hair with the hat. It's like he stuffed all the hair into his hat.";
// undefined
o37 = null;
// 2600
f81632121_467.returns.push(1374851214595);
// 2604
o37 = {};
// 2605
f81632121_474.returns.push(o37);
// 2607
f81632121_478.returns.push(o37);
// undefined
o37 = null;
// 2609
o37 = {};
// 2610
f81632121_476.returns.push(o37);
// 2611
o37.setAttribute = f81632121_575;
// 2613
f81632121_575.returns.push(undefined);
// 2614
// 2615
o37.firstChild = null;
// 2617
o40 = {};
// 2618
f81632121_474.returns.push(o40);
// 2620
o41 = {};
// 2621
f81632121_598.returns.push(o41);
// 2622
o40.appendChild = f81632121_478;
// 2623
f81632121_478.returns.push(o41);
// undefined
o41 = null;
// 2624
o37.appendChild = f81632121_478;
// 2625
f81632121_478.returns.push(o40);
// undefined
o40 = null;
// 2627
o40 = {};
// 2628
f81632121_476.returns.push(o40);
// 2629
// 2630
// 2631
o41 = {};
// 2632
o40.classList = o41;
// 2634
o41.add = f81632121_602;
// undefined
o41 = null;
// 2635
f81632121_602.returns.push(undefined);
// 2637
o41 = {};
// 2638
f81632121_476.returns.push(o41);
// 2639
o41.firstChild = null;
// 2641
o42 = {};
// 2642
f81632121_474.returns.push(o42);
// 2644
o43 = {};
// 2645
f81632121_598.returns.push(o43);
// 2646
o42.appendChild = f81632121_478;
// 2647
f81632121_478.returns.push(o43);
// undefined
o43 = null;
// 2648
o37.__html = void 0;
// undefined
o37 = null;
// 2649
o40.__html = void 0;
// undefined
o40 = null;
// 2650
o41.appendChild = f81632121_478;
// 2651
f81632121_478.returns.push(o42);
// undefined
o42 = null;
// 2652
o41.innerHTML = "You finally tried Saints Row the Third? ";
// undefined
o41 = null;
// 2654
f81632121_467.returns.push(1374851214609);
// 2656
o38.nextSibling = null;
// 2657
o39.removeChild = f81632121_521;
// 2658
f81632121_521.returns.push(o38);
// 2659
// 2660
o39.appendChild = f81632121_478;
// 2661
f81632121_478.returns.push(o38);
// 2663
f81632121_467.returns.push(1374851214619);
// 2665
f81632121_467.returns.push(1374851214619);
// 2668
f81632121_467.returns.push(1374851214619);
// 2670
f81632121_467.returns.push(1374851214620);
// 2672
f81632121_467.returns.push(1374851214620);
// 2674
f81632121_467.returns.push(1374851214620);
// 2675
o37 = {};
// undefined
fo81632121_582_firstChild.returns.push(o37);
// 2677
o37.getAttribute = f81632121_506;
// 2679
f81632121_506.returns.push(".r[5uo4e]");
// 2680
o40 = {};
// 2681
o37.firstChild = o40;
// 2682
o40.getAttribute = f81632121_506;
// 2684
f81632121_506.returns.push(".r[5uo4e].[1][4][0]");
// 2685
o41 = {};
// 2686
o40.firstChild = o41;
// undefined
o41 = null;
// 2687
o41 = {};
// 2688
o40.nextSibling = o41;
// undefined
o40 = null;
// 2689
o41.getAttribute = f81632121_506;
// 2691
f81632121_506.returns.push(".r[5uo4e].[1][4][1]{comment10200453104264236_3195897}");
// 2692
o40 = {};
// 2693
o41.firstChild = o40;
// 2694
o40.getAttribute = f81632121_506;
// 2696
f81632121_506.returns.push(".r[5uo4e].[1][4][1]{comment10200453104264236_3195897}.[0]");
// 2697
o42 = {};
// 2698
o40.firstChild = o42;
// undefined
o40 = null;
// 2699
o42.getAttribute = f81632121_506;
// 2701
f81632121_506.returns.push(".r[5uo4e].[1][4][1]{comment10200453104264236_3195897}.[0].[left]");
// 2702
o40 = {};
// 2703
o42.firstChild = o40;
// undefined
o40 = null;
// 2704
o40 = {};
// 2705
o42.nextSibling = o40;
// undefined
o42 = null;
// 2706
o40.getAttribute = f81632121_506;
// 2708
f81632121_506.returns.push(".r[5uo4e].[1][4][1]{comment10200453104264236_3195897}.[0].[right]");
// 2709
o42 = {};
// 2710
o40.firstChild = o42;
// undefined
o40 = null;
// 2711
o42.getAttribute = f81632121_506;
// 2713
f81632121_506.returns.push(".r[5uo4e].[1][4][1]{comment10200453104264236_3195897}.[0].[right].[0]");
// 2714
o40 = {};
// 2715
o42.firstChild = o40;
// undefined
o42 = null;
// 2716
o40.getAttribute = f81632121_506;
// 2718
f81632121_506.returns.push(".r[5uo4e].[1][4][1]{comment10200453104264236_3195897}.[0].[right].[0].[left]");
// 2719
o42 = {};
// 2720
o40.firstChild = o42;
// undefined
o40 = null;
// 2721
o42.getAttribute = f81632121_506;
// 2723
f81632121_506.returns.push(".r[5uo4e].[1][4][1]{comment10200453104264236_3195897}.[0].[right].[0].[left].[0]");
// 2724
o40 = {};
// 2725
o42.firstChild = o40;
// undefined
o42 = null;
// 2726
o40.getAttribute = f81632121_506;
// 2728
f81632121_506.returns.push(".r[5uo4e].[1][4][1]{comment10200453104264236_3195897}.[0].[right].[0].[left].[0].[0]");
// 2729
o42 = {};
// 2730
o40.firstChild = o42;
// undefined
o40 = null;
// 2731
o42.getAttribute = f81632121_506;
// 2733
f81632121_506.returns.push(".r[5uo4e].[1][4][1]{comment10200453104264236_3195897}.[0].[right].[0].[left].[0].[0].[0][0]");
// 2734
o40 = {};
// 2735
o42.firstChild = o40;
// undefined
o40 = null;
// 2736
o40 = {};
// 2737
o42.nextSibling = o40;
// undefined
o42 = null;
// 2738
o40.getAttribute = f81632121_506;
// 2740
f81632121_506.returns.push(".r[5uo4e].[1][4][1]{comment10200453104264236_3195897}.[0].[right].[0].[left].[0].[0].[0][1]");
// 2741
o42 = {};
// 2742
o40.firstChild = o42;
// undefined
o42 = null;
// 2743
o42 = {};
// 2744
o40.nextSibling = o42;
// undefined
o40 = null;
// 2745
o42.getAttribute = f81632121_506;
// 2747
f81632121_506.returns.push(".r[5uo4e].[1][4][1]{comment10200453104264236_3195897}.[0].[right].[0].[left].[0].[0].[0][2]");
// 2748
o40 = {};
// 2749
o42.firstChild = o40;
// undefined
o40 = null;
// 2750
o40 = {};
// 2751
o42.nextSibling = o40;
// undefined
o42 = null;
// 2752
o40.getAttribute = f81632121_506;
// undefined
o40 = null;
// 2754
f81632121_506.returns.push(".r[5uo4e].[1][4][1]{comment10200453104264236_3195897}.[0].[right].[0].[left].[0].[0].[3]");
// 2757
f81632121_506.returns.push(".r[5uo4e].[1][4][1]{comment10200453104264236_3195897}");
// 2758
f81632121_645 = function() { return f81632121_645.returns[f81632121_645.inst++]; };
f81632121_645.returns = [];
f81632121_645.inst = 0;
// 2759
o38.contains = f81632121_645;
// 2761
f81632121_645.returns.push(true);
// undefined
fo81632121_582_firstChild.returns.push(o37);
// 2765
f81632121_506.returns.push(".r[5uo4e]");
// 2769
f81632121_506.returns.push(".r[5uo4e].[1][4][0]");
// 2774
f81632121_506.returns.push(".r[5uo4e].[1][4][1]{comment10200453104264236_3195897}");
// 2776
o40 = {};
// 2777
o41.nextSibling = o40;
// undefined
o41 = null;
// 2778
o40.getAttribute = f81632121_506;
// 2780
f81632121_506.returns.push(".r[5uo4e].[1][4][1]{comment10200453104264236_3195898}");
// 2781
o41 = {};
// 2782
o40.firstChild = o41;
// 2783
o41.getAttribute = f81632121_506;
// 2785
f81632121_506.returns.push(".r[5uo4e].[1][4][1]{comment10200453104264236_3195898}.[0]");
// 2786
o42 = {};
// 2787
o41.firstChild = o42;
// undefined
o41 = null;
// 2788
o42.getAttribute = f81632121_506;
// 2790
f81632121_506.returns.push(".r[5uo4e].[1][4][1]{comment10200453104264236_3195898}.[0].[left]");
// 2791
o41 = {};
// 2792
o42.firstChild = o41;
// undefined
o41 = null;
// 2793
o41 = {};
// 2794
o42.nextSibling = o41;
// undefined
o42 = null;
// 2795
o41.getAttribute = f81632121_506;
// 2797
f81632121_506.returns.push(".r[5uo4e].[1][4][1]{comment10200453104264236_3195898}.[0].[right]");
// 2798
o42 = {};
// 2799
o41.firstChild = o42;
// undefined
o41 = null;
// 2800
o42.getAttribute = f81632121_506;
// 2802
f81632121_506.returns.push(".r[5uo4e].[1][4][1]{comment10200453104264236_3195898}.[0].[right].[0]");
// 2803
o41 = {};
// 2804
o42.firstChild = o41;
// undefined
o42 = null;
// 2805
o41.getAttribute = f81632121_506;
// 2807
f81632121_506.returns.push(".r[5uo4e].[1][4][1]{comment10200453104264236_3195898}.[0].[right].[0].[left]");
// 2808
o42 = {};
// 2809
o41.firstChild = o42;
// undefined
o41 = null;
// 2810
o42.getAttribute = f81632121_506;
// 2812
f81632121_506.returns.push(".r[5uo4e].[1][4][1]{comment10200453104264236_3195898}.[0].[right].[0].[left].[0]");
// 2813
o41 = {};
// 2814
o42.firstChild = o41;
// undefined
o42 = null;
// 2815
o41.getAttribute = f81632121_506;
// 2817
f81632121_506.returns.push(".r[5uo4e].[1][4][1]{comment10200453104264236_3195898}.[0].[right].[0].[left].[0].[0]");
// 2818
o42 = {};
// 2819
o41.firstChild = o42;
// undefined
o41 = null;
// 2820
o42.getAttribute = f81632121_506;
// 2822
f81632121_506.returns.push(".r[5uo4e].[1][4][1]{comment10200453104264236_3195898}.[0].[right].[0].[left].[0].[0].[0][0]");
// 2823
o41 = {};
// 2824
o42.firstChild = o41;
// undefined
o41 = null;
// 2825
o41 = {};
// 2826
o42.nextSibling = o41;
// undefined
o42 = null;
// 2827
o41.getAttribute = f81632121_506;
// 2829
f81632121_506.returns.push(".r[5uo4e].[1][4][1]{comment10200453104264236_3195898}.[0].[right].[0].[left].[0].[0].[0][1]");
// 2830
o42 = {};
// 2831
o41.firstChild = o42;
// undefined
o42 = null;
// 2832
o42 = {};
// 2833
o41.nextSibling = o42;
// undefined
o41 = null;
// 2834
o42.getAttribute = f81632121_506;
// 2836
f81632121_506.returns.push(".r[5uo4e].[1][4][1]{comment10200453104264236_3195898}.[0].[right].[0].[left].[0].[0].[0][2]");
// 2837
o41 = {};
// 2838
o42.firstChild = o41;
// undefined
o41 = null;
// 2839
o41 = {};
// 2840
o42.nextSibling = o41;
// undefined
o42 = null;
// 2841
o41.getAttribute = f81632121_506;
// undefined
o41 = null;
// 2843
f81632121_506.returns.push(".r[5uo4e].[1][4][1]{comment10200453104264236_3195898}.[0].[right].[0].[left].[0].[0].[3]");
// 2846
f81632121_506.returns.push(".r[5uo4e].[1][4][1]{comment10200453104264236_3195898}");
// 2849
f81632121_645.returns.push(true);
// undefined
fo81632121_582_firstChild.returns.push(o37);
// 2853
f81632121_506.returns.push(".r[5uo4e]");
// 2857
f81632121_506.returns.push(".r[5uo4e].[1][4][0]");
// 2862
f81632121_506.returns.push(".r[5uo4e].[1][4][1]{comment10200453104264236_3195897}");
// 2867
f81632121_506.returns.push(".r[5uo4e].[1][4][1]{comment10200453104264236_3195898}");
// 2869
o41 = {};
// 2870
o40.nextSibling = o41;
// undefined
o40 = null;
// 2871
o41.getAttribute = f81632121_506;
// 2873
f81632121_506.returns.push(".r[5uo4e].[1][4][1]{comment10200453104264236_3195907}");
// 2874
o40 = {};
// 2875
o41.firstChild = o40;
// 2876
o40.getAttribute = f81632121_506;
// 2878
f81632121_506.returns.push(".r[5uo4e].[1][4][1]{comment10200453104264236_3195907}.[0]");
// 2879
o42 = {};
// 2880
o40.firstChild = o42;
// undefined
o40 = null;
// 2881
o42.getAttribute = f81632121_506;
// 2883
f81632121_506.returns.push(".r[5uo4e].[1][4][1]{comment10200453104264236_3195907}.[0].[left]");
// 2884
o40 = {};
// 2885
o42.firstChild = o40;
// undefined
o40 = null;
// 2886
o40 = {};
// 2887
o42.nextSibling = o40;
// undefined
o42 = null;
// 2888
o40.getAttribute = f81632121_506;
// 2890
f81632121_506.returns.push(".r[5uo4e].[1][4][1]{comment10200453104264236_3195907}.[0].[right]");
// 2891
o42 = {};
// 2892
o40.firstChild = o42;
// undefined
o40 = null;
// 2893
o42.getAttribute = f81632121_506;
// 2895
f81632121_506.returns.push(".r[5uo4e].[1][4][1]{comment10200453104264236_3195907}.[0].[right].[0]");
// 2896
o40 = {};
// 2897
o42.firstChild = o40;
// undefined
o42 = null;
// 2898
o40.getAttribute = f81632121_506;
// 2900
f81632121_506.returns.push(".r[5uo4e].[1][4][1]{comment10200453104264236_3195907}.[0].[right].[0].[left]");
// 2901
o42 = {};
// 2902
o40.firstChild = o42;
// undefined
o40 = null;
// 2903
o42.getAttribute = f81632121_506;
// 2905
f81632121_506.returns.push(".r[5uo4e].[1][4][1]{comment10200453104264236_3195907}.[0].[right].[0].[left].[0]");
// 2906
o40 = {};
// 2907
o42.firstChild = o40;
// undefined
o42 = null;
// 2908
o40.getAttribute = f81632121_506;
// 2910
f81632121_506.returns.push(".r[5uo4e].[1][4][1]{comment10200453104264236_3195907}.[0].[right].[0].[left].[0].[0]");
// 2911
o42 = {};
// 2912
o40.firstChild = o42;
// undefined
o40 = null;
// 2913
o42.getAttribute = f81632121_506;
// 2915
f81632121_506.returns.push(".r[5uo4e].[1][4][1]{comment10200453104264236_3195907}.[0].[right].[0].[left].[0].[0].[0][0]");
// 2916
o40 = {};
// 2917
o42.firstChild = o40;
// undefined
o40 = null;
// 2918
o40 = {};
// 2919
o42.nextSibling = o40;
// undefined
o42 = null;
// 2920
o40.getAttribute = f81632121_506;
// 2922
f81632121_506.returns.push(".r[5uo4e].[1][4][1]{comment10200453104264236_3195907}.[0].[right].[0].[left].[0].[0].[0][1]");
// 2923
o42 = {};
// 2924
o40.firstChild = o42;
// undefined
o42 = null;
// 2925
o42 = {};
// 2926
o40.nextSibling = o42;
// undefined
o40 = null;
// 2927
o42.getAttribute = f81632121_506;
// 2929
f81632121_506.returns.push(".r[5uo4e].[1][4][1]{comment10200453104264236_3195907}.[0].[right].[0].[left].[0].[0].[0][2]");
// 2930
o40 = {};
// 2931
o42.firstChild = o40;
// undefined
o40 = null;
// 2932
o40 = {};
// 2933
o42.nextSibling = o40;
// undefined
o42 = null;
// 2934
o40.getAttribute = f81632121_506;
// undefined
o40 = null;
// 2936
f81632121_506.returns.push(".r[5uo4e].[1][4][1]{comment10200453104264236_3195907}.[0].[right].[0].[left].[0].[0].[3]");
// 2939
f81632121_506.returns.push(".r[5uo4e].[1][4][1]{comment10200453104264236_3195907}");
// 2942
f81632121_645.returns.push(true);
// undefined
fo81632121_582_firstChild.returns.push(o37);
// undefined
o37 = null;
// 2946
f81632121_506.returns.push(".r[5uo4e]");
// 2950
f81632121_506.returns.push(".r[5uo4e].[1][4][0]");
// 2955
f81632121_506.returns.push(".r[5uo4e].[1][4][1]{comment10200453104264236_3195897}");
// 2960
f81632121_506.returns.push(".r[5uo4e].[1][4][1]{comment10200453104264236_3195898}");
// 2965
f81632121_506.returns.push(".r[5uo4e].[1][4][1]{comment10200453104264236_3195907}");
// 2967
o37 = {};
// 2968
o41.nextSibling = o37;
// undefined
o41 = null;
// 2969
o37.getAttribute = f81632121_506;
// 2971
f81632121_506.returns.push(".r[5uo4e].[1][4][1]{comment10200453104264236_3198160}");
// 2972
o40 = {};
// 2973
o37.firstChild = o40;
// undefined
o37 = null;
// 2974
o40.getAttribute = f81632121_506;
// 2976
f81632121_506.returns.push(".r[5uo4e].[1][4][1]{comment10200453104264236_3198160}.[0]");
// 2977
o37 = {};
// 2978
o40.firstChild = o37;
// undefined
o40 = null;
// 2979
o37.getAttribute = f81632121_506;
// 2981
f81632121_506.returns.push(".r[5uo4e].[1][4][1]{comment10200453104264236_3198160}.[0].[left]");
// 2982
o40 = {};
// 2983
o37.firstChild = o40;
// undefined
o40 = null;
// 2984
o40 = {};
// 2985
o37.nextSibling = o40;
// undefined
o37 = null;
// 2986
o40.getAttribute = f81632121_506;
// 2988
f81632121_506.returns.push(".r[5uo4e].[1][4][1]{comment10200453104264236_3198160}.[0].[right]");
// 2989
o37 = {};
// 2990
o40.firstChild = o37;
// undefined
o40 = null;
// 2991
o37.getAttribute = f81632121_506;
// 2993
f81632121_506.returns.push(".r[5uo4e].[1][4][1]{comment10200453104264236_3198160}.[0].[right].[0]");
// 2994
o40 = {};
// 2995
o37.firstChild = o40;
// undefined
o37 = null;
// 2996
o40.getAttribute = f81632121_506;
// 2998
f81632121_506.returns.push(".r[5uo4e].[1][4][1]{comment10200453104264236_3198160}.[0].[right].[0].[left]");
// 2999
o37 = {};
// 3000
o40.firstChild = o37;
// undefined
o40 = null;
// 3001
o37.getAttribute = f81632121_506;
// 3003
f81632121_506.returns.push(".r[5uo4e].[1][4][1]{comment10200453104264236_3198160}.[0].[right].[0].[left].[0]");
// 3004
o40 = {};
// 3005
o37.firstChild = o40;
// undefined
o37 = null;
// 3006
o40.getAttribute = f81632121_506;
// 3008
f81632121_506.returns.push(".r[5uo4e].[1][4][1]{comment10200453104264236_3198160}.[0].[right].[0].[left].[0].[0]");
// 3009
o37 = {};
// 3010
o40.firstChild = o37;
// undefined
o40 = null;
// 3011
o37.getAttribute = f81632121_506;
// 3013
f81632121_506.returns.push(".r[5uo4e].[1][4][1]{comment10200453104264236_3198160}.[0].[right].[0].[left].[0].[0].[0][0]");
// 3014
o40 = {};
// 3015
o37.firstChild = o40;
// undefined
o40 = null;
// 3016
o40 = {};
// 3017
o37.nextSibling = o40;
// undefined
o37 = null;
// 3018
o40.getAttribute = f81632121_506;
// 3020
f81632121_506.returns.push(".r[5uo4e].[1][4][1]{comment10200453104264236_3198160}.[0].[right].[0].[left].[0].[0].[0][1]");
// 3021
o37 = {};
// 3022
o40.firstChild = o37;
// undefined
o37 = null;
// 3023
o37 = {};
// 3024
o40.nextSibling = o37;
// undefined
o40 = null;
// 3025
o37.getAttribute = f81632121_506;
// 3027
f81632121_506.returns.push(".r[5uo4e].[1][4][1]{comment10200453104264236_3198160}.[0].[right].[0].[left].[0].[0].[0][2]");
// 3028
o40 = {};
// 3029
o37.firstChild = o40;
// undefined
o40 = null;
// 3030
o40 = {};
// 3031
o37.nextSibling = o40;
// undefined
o37 = null;
// 3032
o40.getAttribute = f81632121_506;
// undefined
o40 = null;
// 3034
f81632121_506.returns.push(".r[5uo4e].[1][4][1]{comment10200453104264236_3198160}.[0].[right].[0].[left].[0].[0].[3]");
// 3037
f81632121_506.returns.push(".r[5uo4e].[1][4][1]{comment10200453104264236_3198160}");
// 3040
f81632121_645.returns.push(true);
// 3042
f81632121_467.returns.push(1374851214645);
// 3047
o37 = {};
// 3048
f81632121_504.returns.push(o37);
// 3049
o37.length = 4;
// 3050
o40 = {};
// 3051
o37["0"] = o40;
// 3052
o41 = {};
// 3053
o37["1"] = o41;
// 3054
o42 = {};
// 3055
o37["2"] = o42;
// 3056
o43 = {};
// 3057
o37["3"] = o43;
// undefined
o37 = null;
// 3058
f81632121_14.returns.push(undefined);
// 3059
f81632121_12.returns.push(6);
// 3060
o38.nodeName = "DIV";
// undefined
o38 = null;
// 3062
o39.nodeName = "DIV";
// 3063
o39.parentNode = o36;
// undefined
o39 = null;
// 3064
o36.nodeName = "FORM";
// 3068
o37 = {};
// 3069
f81632121_474.returns.push(o37);
// 3071
f81632121_478.returns.push(o37);
// undefined
o37 = null;
// 3084
o37 = {};
// 3085
f81632121_508.returns.push(o37);
// 3086
o37.id = "u_0_1v";
// 3087
o37.getElementsByTagName = f81632121_502;
// 3088
o38 = {};
// 3089
o37.parentNode = o38;
// 3106
f81632121_467.returns.push(1374851214684);
// 3111
o39 = {};
// 3112
f81632121_504.returns.push(o39);
// 3113
o39.length = 4;
// 3114
o39["0"] = o40;
// 3115
o39["1"] = o41;
// 3116
o39["2"] = o42;
// 3117
o39["3"] = o43;
// undefined
o39 = null;
// 3118
f81632121_14.returns.push(undefined);
// 3119
f81632121_12.returns.push(7);
// undefined
fo81632121_700_firstChild = function() { return fo81632121_700_firstChild.returns[fo81632121_700_firstChild.inst++]; };
fo81632121_700_firstChild.returns = [];
fo81632121_700_firstChild.inst = 0;
defineGetter(o37, "firstChild", fo81632121_700_firstChild, undefined);
// undefined
fo81632121_700_firstChild.returns.push(null);
// undefined
fo81632121_700_firstChild.returns.push(null);
// undefined
fo81632121_700_firstChild.returns.push(null);
// 3132
f81632121_466.returns.push(0.4838148937560618);
// 3134
f81632121_467.returns.push(1374851214688);
// 3136
f81632121_467.returns.push(1374851214688);
// 3142
f81632121_467.returns.push(1374851214688);
// 3144
f81632121_467.returns.push(1374851214689);
// 3146
f81632121_467.returns.push(1374851214689);
// 3148
f81632121_467.returns.push(1374851214689);
// 3150
f81632121_467.returns.push(1374851214689);
// 3151
o37.nodeType = 1;
// 3155
o39 = {};
// 3156
f81632121_474.returns.push(o39);
// 3158
f81632121_478.returns.push(o39);
// undefined
o39 = null;
// 3162
o39 = {};
// 3163
f81632121_474.returns.push(o39);
// 3165
f81632121_478.returns.push(o39);
// undefined
o39 = null;
// 3167
o39 = {};
// 3168
f81632121_476.returns.push(o39);
// 3169
o39.firstChild = null;
// 3171
o44 = {};
// 3172
f81632121_474.returns.push(o44);
// 3174
o45 = {};
// 3175
f81632121_598.returns.push(o45);
// 3176
o44.appendChild = f81632121_478;
// 3177
f81632121_478.returns.push(o45);
// undefined
o45 = null;
// 3178
o39.appendChild = f81632121_478;
// 3179
f81632121_478.returns.push(o44);
// undefined
o44 = null;
// 3180
o39.innerHTML = "You should have snatched it out of his hands, and played it/";
// undefined
o39 = null;
// 3182
f81632121_467.returns.push(1374851214713);
// 3186
o39 = {};
// 3187
f81632121_474.returns.push(o39);
// 3189
f81632121_478.returns.push(o39);
// undefined
o39 = null;
// 3191
o39 = {};
// 3192
f81632121_476.returns.push(o39);
// 3193
o39.firstChild = null;
// 3195
o44 = {};
// 3196
f81632121_474.returns.push(o44);
// 3198
o45 = {};
// 3199
f81632121_598.returns.push(o45);
// 3200
o44.appendChild = f81632121_478;
// 3201
f81632121_478.returns.push(o45);
// undefined
o45 = null;
// 3202
o39.appendChild = f81632121_478;
// 3203
f81632121_478.returns.push(o44);
// undefined
o44 = null;
// 3204
o39.innerHTML = "I've found that stealing musical instruments in non-English-speaking countries hasn't brought me great luck in the past.";
// undefined
o39 = null;
// 3206
f81632121_467.returns.push(1374851214723);
// 3210
o39 = {};
// 3211
f81632121_474.returns.push(o39);
// 3213
f81632121_478.returns.push(o39);
// undefined
o39 = null;
// 3215
o39 = {};
// 3216
f81632121_476.returns.push(o39);
// 3217
o39.firstChild = null;
// 3219
o44 = {};
// 3220
f81632121_474.returns.push(o44);
// 3222
o45 = {};
// 3223
f81632121_598.returns.push(o45);
// 3224
o44.appendChild = f81632121_478;
// 3225
f81632121_478.returns.push(o45);
// undefined
o45 = null;
// 3226
o39.appendChild = f81632121_478;
// 3227
f81632121_478.returns.push(o44);
// undefined
o44 = null;
// 3228
o39.innerHTML = "But in English-speaking countries it's just fine.";
// undefined
o39 = null;
// 3230
f81632121_467.returns.push(1374851214731);
// 3234
o39 = {};
// 3235
f81632121_474.returns.push(o39);
// 3237
f81632121_478.returns.push(o39);
// undefined
o39 = null;
// 3239
o39 = {};
// 3240
f81632121_476.returns.push(o39);
// 3241
o39.firstChild = null;
// 3243
o44 = {};
// 3244
f81632121_474.returns.push(o44);
// 3246
o45 = {};
// 3247
f81632121_598.returns.push(o45);
// 3248
o44.appendChild = f81632121_478;
// 3249
f81632121_478.returns.push(o45);
// undefined
o45 = null;
// 3250
o39.appendChild = f81632121_478;
// 3251
f81632121_478.returns.push(o44);
// undefined
o44 = null;
// 3252
o39.innerHTML = "Naturally.";
// undefined
o39 = null;
// 3254
f81632121_467.returns.push(1374851214741);
// 3256
o37.nextSibling = null;
// 3257
o38.removeChild = f81632121_521;
// 3258
f81632121_521.returns.push(o37);
// 3259
// 3260
o38.appendChild = f81632121_478;
// 3261
f81632121_478.returns.push(o37);
// 3263
f81632121_467.returns.push(1374851214759);
// 3265
f81632121_467.returns.push(1374851214759);
// 3268
f81632121_467.returns.push(1374851214759);
// 3270
f81632121_467.returns.push(1374851214759);
// 3272
f81632121_467.returns.push(1374851214759);
// 3274
f81632121_467.returns.push(1374851214759);
// 3275
o39 = {};
// undefined
fo81632121_700_firstChild.returns.push(o39);
// 3277
o39.getAttribute = f81632121_506;
// 3279
f81632121_506.returns.push(".r[2vp51]");
// 3280
o44 = {};
// 3281
o39.firstChild = o44;
// 3282
o44.getAttribute = f81632121_506;
// 3284
f81632121_506.returns.push(".r[2vp51].[1][0]");
// 3285
o45 = {};
// 3286
o44.firstChild = o45;
// undefined
o45 = null;
// 3287
o45 = {};
// 3288
o44.nextSibling = o45;
// undefined
o44 = null;
// 3289
o45.getAttribute = f81632121_506;
// 3291
f81632121_506.returns.push(".r[2vp51].[1][4][0]");
// 3292
o44 = {};
// 3293
o45.firstChild = o44;
// undefined
o44 = null;
// 3294
o44 = {};
// 3295
o45.nextSibling = o44;
// undefined
o45 = null;
// 3296
o44.getAttribute = f81632121_506;
// 3298
f81632121_506.returns.push(".r[2vp51].[1][4][1]{comment10200350995551582_4954379}");
// 3299
o45 = {};
// 3300
o44.firstChild = o45;
// 3301
o45.getAttribute = f81632121_506;
// 3303
f81632121_506.returns.push(".r[2vp51].[1][4][1]{comment10200350995551582_4954379}.[0]");
// 3304
o46 = {};
// 3305
o45.firstChild = o46;
// undefined
o45 = null;
// 3306
o46.getAttribute = f81632121_506;
// 3308
f81632121_506.returns.push(".r[2vp51].[1][4][1]{comment10200350995551582_4954379}.[0].[left]");
// 3309
o45 = {};
// 3310
o46.firstChild = o45;
// undefined
o45 = null;
// 3311
o45 = {};
// 3312
o46.nextSibling = o45;
// undefined
o46 = null;
// 3313
o45.getAttribute = f81632121_506;
// 3315
f81632121_506.returns.push(".r[2vp51].[1][4][1]{comment10200350995551582_4954379}.[0].[right]");
// 3316
o46 = {};
// 3317
o45.firstChild = o46;
// undefined
o45 = null;
// 3318
o46.getAttribute = f81632121_506;
// 3320
f81632121_506.returns.push(".r[2vp51].[1][4][1]{comment10200350995551582_4954379}.[0].[right].[0]");
// 3321
o45 = {};
// 3322
o46.firstChild = o45;
// undefined
o46 = null;
// 3323
o45.getAttribute = f81632121_506;
// 3325
f81632121_506.returns.push(".r[2vp51].[1][4][1]{comment10200350995551582_4954379}.[0].[right].[0].[left]");
// 3326
o46 = {};
// 3327
o45.firstChild = o46;
// undefined
o45 = null;
// 3328
o46.getAttribute = f81632121_506;
// 3330
f81632121_506.returns.push(".r[2vp51].[1][4][1]{comment10200350995551582_4954379}.[0].[right].[0].[left].[0]");
// 3331
o45 = {};
// 3332
o46.firstChild = o45;
// undefined
o46 = null;
// 3333
o45.getAttribute = f81632121_506;
// 3335
f81632121_506.returns.push(".r[2vp51].[1][4][1]{comment10200350995551582_4954379}.[0].[right].[0].[left].[0].[0]");
// 3336
o46 = {};
// 3337
o45.firstChild = o46;
// undefined
o45 = null;
// 3338
o46.getAttribute = f81632121_506;
// 3340
f81632121_506.returns.push(".r[2vp51].[1][4][1]{comment10200350995551582_4954379}.[0].[right].[0].[left].[0].[0].[0][0]");
// 3341
o45 = {};
// 3342
o46.firstChild = o45;
// undefined
o45 = null;
// 3343
o45 = {};
// 3344
o46.nextSibling = o45;
// undefined
o46 = null;
// 3345
o45.getAttribute = f81632121_506;
// 3347
f81632121_506.returns.push(".r[2vp51].[1][4][1]{comment10200350995551582_4954379}.[0].[right].[0].[left].[0].[0].[0][1]");
// 3348
o46 = {};
// 3349
o45.firstChild = o46;
// undefined
o46 = null;
// 3350
o46 = {};
// 3351
o45.nextSibling = o46;
// undefined
o45 = null;
// 3352
o46.getAttribute = f81632121_506;
// 3354
f81632121_506.returns.push(".r[2vp51].[1][4][1]{comment10200350995551582_4954379}.[0].[right].[0].[left].[0].[0].[0][2]");
// 3355
o45 = {};
// 3356
o46.firstChild = o45;
// undefined
o45 = null;
// 3357
o45 = {};
// 3358
o46.nextSibling = o45;
// undefined
o46 = null;
// 3359
o45.getAttribute = f81632121_506;
// undefined
o45 = null;
// 3361
f81632121_506.returns.push(".r[2vp51].[1][4][1]{comment10200350995551582_4954379}.[0].[right].[0].[left].[0].[0].[3]");
// 3364
f81632121_506.returns.push(".r[2vp51].[1][4][1]{comment10200350995551582_4954379}");
// 3365
o37.contains = f81632121_645;
// 3367
f81632121_645.returns.push(true);
// undefined
fo81632121_700_firstChild.returns.push(o39);
// 3371
f81632121_506.returns.push(".r[2vp51]");
// 3375
f81632121_506.returns.push(".r[2vp51].[1][0]");
// 3380
f81632121_506.returns.push(".r[2vp51].[1][4][0]");
// 3385
f81632121_506.returns.push(".r[2vp51].[1][4][1]{comment10200350995551582_4954379}");
// 3387
o45 = {};
// 3388
o44.nextSibling = o45;
// undefined
o44 = null;
// 3389
o45.getAttribute = f81632121_506;
// 3391
f81632121_506.returns.push(".r[2vp51].[1][4][1]{comment10200350995551582_4955913}");
// 3392
o44 = {};
// 3393
o45.firstChild = o44;
// 3394
o44.getAttribute = f81632121_506;
// 3396
f81632121_506.returns.push(".r[2vp51].[1][4][1]{comment10200350995551582_4955913}.[0]");
// 3397
o46 = {};
// 3398
o44.firstChild = o46;
// undefined
o44 = null;
// 3399
o46.getAttribute = f81632121_506;
// 3401
f81632121_506.returns.push(".r[2vp51].[1][4][1]{comment10200350995551582_4955913}.[0].[left]");
// 3402
o44 = {};
// 3403
o46.firstChild = o44;
// undefined
o44 = null;
// 3404
o44 = {};
// 3405
o46.nextSibling = o44;
// undefined
o46 = null;
// 3406
o44.getAttribute = f81632121_506;
// 3408
f81632121_506.returns.push(".r[2vp51].[1][4][1]{comment10200350995551582_4955913}.[0].[right]");
// 3409
o46 = {};
// 3410
o44.firstChild = o46;
// undefined
o44 = null;
// 3411
o46.getAttribute = f81632121_506;
// 3413
f81632121_506.returns.push(".r[2vp51].[1][4][1]{comment10200350995551582_4955913}.[0].[right].[0]");
// 3414
o44 = {};
// 3415
o46.firstChild = o44;
// undefined
o46 = null;
// 3416
o44.getAttribute = f81632121_506;
// 3418
f81632121_506.returns.push(".r[2vp51].[1][4][1]{comment10200350995551582_4955913}.[0].[right].[0].[left]");
// 3419
o46 = {};
// 3420
o44.firstChild = o46;
// undefined
o44 = null;
// 3421
o46.getAttribute = f81632121_506;
// 3423
f81632121_506.returns.push(".r[2vp51].[1][4][1]{comment10200350995551582_4955913}.[0].[right].[0].[left].[0]");
// 3424
o44 = {};
// 3425
o46.firstChild = o44;
// undefined
o46 = null;
// 3426
o44.getAttribute = f81632121_506;
// 3428
f81632121_506.returns.push(".r[2vp51].[1][4][1]{comment10200350995551582_4955913}.[0].[right].[0].[left].[0].[0]");
// 3429
o46 = {};
// 3430
o44.firstChild = o46;
// undefined
o44 = null;
// 3431
o46.getAttribute = f81632121_506;
// 3433
f81632121_506.returns.push(".r[2vp51].[1][4][1]{comment10200350995551582_4955913}.[0].[right].[0].[left].[0].[0].[0][0]");
// 3434
o44 = {};
// 3435
o46.firstChild = o44;
// undefined
o44 = null;
// 3436
o44 = {};
// 3437
o46.nextSibling = o44;
// undefined
o46 = null;
// 3438
o44.getAttribute = f81632121_506;
// 3440
f81632121_506.returns.push(".r[2vp51].[1][4][1]{comment10200350995551582_4955913}.[0].[right].[0].[left].[0].[0].[0][1]");
// 3441
o46 = {};
// 3442
o44.firstChild = o46;
// undefined
o46 = null;
// 3443
o46 = {};
// 3444
o44.nextSibling = o46;
// undefined
o44 = null;
// 3445
o46.getAttribute = f81632121_506;
// 3447
f81632121_506.returns.push(".r[2vp51].[1][4][1]{comment10200350995551582_4955913}.[0].[right].[0].[left].[0].[0].[0][2]");
// 3448
o44 = {};
// 3449
o46.firstChild = o44;
// undefined
o44 = null;
// 3450
o44 = {};
// 3451
o46.nextSibling = o44;
// undefined
o46 = null;
// 3452
o44.getAttribute = f81632121_506;
// undefined
o44 = null;
// 3454
f81632121_506.returns.push(".r[2vp51].[1][4][1]{comment10200350995551582_4955913}.[0].[right].[0].[left].[0].[0].[3]");
// 3457
f81632121_506.returns.push(".r[2vp51].[1][4][1]{comment10200350995551582_4955913}");
// 3460
f81632121_645.returns.push(true);
// undefined
fo81632121_700_firstChild.returns.push(o39);
// 3464
f81632121_506.returns.push(".r[2vp51]");
// 3468
f81632121_506.returns.push(".r[2vp51].[1][0]");
// 3473
f81632121_506.returns.push(".r[2vp51].[1][4][0]");
// 3478
f81632121_506.returns.push(".r[2vp51].[1][4][1]{comment10200350995551582_4954379}");
// 3483
f81632121_506.returns.push(".r[2vp51].[1][4][1]{comment10200350995551582_4955913}");
// 3485
o44 = {};
// 3486
o45.nextSibling = o44;
// undefined
o45 = null;
// 3487
o44.getAttribute = f81632121_506;
// 3489
f81632121_506.returns.push(".r[2vp51].[1][4][1]{comment10200350995551582_4955915}");
// 3490
o45 = {};
// 3491
o44.firstChild = o45;
// 3492
o45.getAttribute = f81632121_506;
// 3494
f81632121_506.returns.push(".r[2vp51].[1][4][1]{comment10200350995551582_4955915}.[0]");
// 3495
o46 = {};
// 3496
o45.firstChild = o46;
// undefined
o45 = null;
// 3497
o46.getAttribute = f81632121_506;
// 3499
f81632121_506.returns.push(".r[2vp51].[1][4][1]{comment10200350995551582_4955915}.[0].[left]");
// 3500
o45 = {};
// 3501
o46.firstChild = o45;
// undefined
o45 = null;
// 3502
o45 = {};
// 3503
o46.nextSibling = o45;
// undefined
o46 = null;
// 3504
o45.getAttribute = f81632121_506;
// 3506
f81632121_506.returns.push(".r[2vp51].[1][4][1]{comment10200350995551582_4955915}.[0].[right]");
// 3507
o46 = {};
// 3508
o45.firstChild = o46;
// undefined
o45 = null;
// 3509
o46.getAttribute = f81632121_506;
// 3511
f81632121_506.returns.push(".r[2vp51].[1][4][1]{comment10200350995551582_4955915}.[0].[right].[0]");
// 3512
o45 = {};
// 3513
o46.firstChild = o45;
// undefined
o46 = null;
// 3514
o45.getAttribute = f81632121_506;
// 3516
f81632121_506.returns.push(".r[2vp51].[1][4][1]{comment10200350995551582_4955915}.[0].[right].[0].[left]");
// 3517
o46 = {};
// 3518
o45.firstChild = o46;
// undefined
o45 = null;
// 3519
o46.getAttribute = f81632121_506;
// 3521
f81632121_506.returns.push(".r[2vp51].[1][4][1]{comment10200350995551582_4955915}.[0].[right].[0].[left].[0]");
// 3522
o45 = {};
// 3523
o46.firstChild = o45;
// undefined
o46 = null;
// 3524
o45.getAttribute = f81632121_506;
// 3526
f81632121_506.returns.push(".r[2vp51].[1][4][1]{comment10200350995551582_4955915}.[0].[right].[0].[left].[0].[0]");
// 3527
o46 = {};
// 3528
o45.firstChild = o46;
// undefined
o45 = null;
// 3529
o46.getAttribute = f81632121_506;
// 3531
f81632121_506.returns.push(".r[2vp51].[1][4][1]{comment10200350995551582_4955915}.[0].[right].[0].[left].[0].[0].[0][0]");
// 3532
o45 = {};
// 3533
o46.firstChild = o45;
// undefined
o45 = null;
// 3534
o45 = {};
// 3535
o46.nextSibling = o45;
// undefined
o46 = null;
// 3536
o45.getAttribute = f81632121_506;
// 3538
f81632121_506.returns.push(".r[2vp51].[1][4][1]{comment10200350995551582_4955915}.[0].[right].[0].[left].[0].[0].[0][1]");
// 3539
o46 = {};
// 3540
o45.firstChild = o46;
// undefined
o46 = null;
// 3541
o46 = {};
// 3542
o45.nextSibling = o46;
// undefined
o45 = null;
// 3543
o46.getAttribute = f81632121_506;
// 3545
f81632121_506.returns.push(".r[2vp51].[1][4][1]{comment10200350995551582_4955915}.[0].[right].[0].[left].[0].[0].[0][2]");
// 3546
o45 = {};
// 3547
o46.firstChild = o45;
// undefined
o45 = null;
// 3548
o45 = {};
// 3549
o46.nextSibling = o45;
// undefined
o46 = null;
// 3550
o45.getAttribute = f81632121_506;
// undefined
o45 = null;
// 3552
f81632121_506.returns.push(".r[2vp51].[1][4][1]{comment10200350995551582_4955915}.[0].[right].[0].[left].[0].[0].[3]");
// 3555
f81632121_506.returns.push(".r[2vp51].[1][4][1]{comment10200350995551582_4955915}");
// 3558
f81632121_645.returns.push(true);
// undefined
fo81632121_700_firstChild.returns.push(o39);
// undefined
o39 = null;
// 3562
f81632121_506.returns.push(".r[2vp51]");
// 3566
f81632121_506.returns.push(".r[2vp51].[1][0]");
// 3571
f81632121_506.returns.push(".r[2vp51].[1][4][0]");
// 3576
f81632121_506.returns.push(".r[2vp51].[1][4][1]{comment10200350995551582_4954379}");
// 3581
f81632121_506.returns.push(".r[2vp51].[1][4][1]{comment10200350995551582_4955913}");
// 3586
f81632121_506.returns.push(".r[2vp51].[1][4][1]{comment10200350995551582_4955915}");
// 3588
o39 = {};
// 3589
o44.nextSibling = o39;
// undefined
o44 = null;
// 3590
o39.getAttribute = f81632121_506;
// 3592
f81632121_506.returns.push(".r[2vp51].[1][4][1]{comment10200350995551582_4955918}");
// 3593
o44 = {};
// 3594
o39.firstChild = o44;
// undefined
o39 = null;
// 3595
o44.getAttribute = f81632121_506;
// 3597
f81632121_506.returns.push(".r[2vp51].[1][4][1]{comment10200350995551582_4955918}.[0]");
// 3598
o39 = {};
// 3599
o44.firstChild = o39;
// undefined
o44 = null;
// 3600
o39.getAttribute = f81632121_506;
// 3602
f81632121_506.returns.push(".r[2vp51].[1][4][1]{comment10200350995551582_4955918}.[0].[left]");
// 3603
o44 = {};
// 3604
o39.firstChild = o44;
// undefined
o44 = null;
// 3605
o44 = {};
// 3606
o39.nextSibling = o44;
// undefined
o39 = null;
// 3607
o44.getAttribute = f81632121_506;
// 3609
f81632121_506.returns.push(".r[2vp51].[1][4][1]{comment10200350995551582_4955918}.[0].[right]");
// 3610
o39 = {};
// 3611
o44.firstChild = o39;
// undefined
o44 = null;
// 3612
o39.getAttribute = f81632121_506;
// 3614
f81632121_506.returns.push(".r[2vp51].[1][4][1]{comment10200350995551582_4955918}.[0].[right].[0]");
// 3615
o44 = {};
// 3616
o39.firstChild = o44;
// undefined
o39 = null;
// 3617
o44.getAttribute = f81632121_506;
// 3619
f81632121_506.returns.push(".r[2vp51].[1][4][1]{comment10200350995551582_4955918}.[0].[right].[0].[left]");
// 3620
o39 = {};
// 3621
o44.firstChild = o39;
// undefined
o44 = null;
// 3622
o39.getAttribute = f81632121_506;
// 3624
f81632121_506.returns.push(".r[2vp51].[1][4][1]{comment10200350995551582_4955918}.[0].[right].[0].[left].[0]");
// 3625
o44 = {};
// 3626
o39.firstChild = o44;
// undefined
o39 = null;
// 3627
o44.getAttribute = f81632121_506;
// 3629
f81632121_506.returns.push(".r[2vp51].[1][4][1]{comment10200350995551582_4955918}.[0].[right].[0].[left].[0].[0]");
// 3630
o39 = {};
// 3631
o44.firstChild = o39;
// undefined
o44 = null;
// 3632
o39.getAttribute = f81632121_506;
// 3634
f81632121_506.returns.push(".r[2vp51].[1][4][1]{comment10200350995551582_4955918}.[0].[right].[0].[left].[0].[0].[0][0]");
// 3635
o44 = {};
// 3636
o39.firstChild = o44;
// undefined
o44 = null;
// 3637
o44 = {};
// 3638
o39.nextSibling = o44;
// undefined
o39 = null;
// 3639
o44.getAttribute = f81632121_506;
// 3641
f81632121_506.returns.push(".r[2vp51].[1][4][1]{comment10200350995551582_4955918}.[0].[right].[0].[left].[0].[0].[0][1]");
// 3642
o39 = {};
// 3643
o44.firstChild = o39;
// undefined
o39 = null;
// 3644
o39 = {};
// 3645
o44.nextSibling = o39;
// undefined
o44 = null;
// 3646
o39.getAttribute = f81632121_506;
// 3648
f81632121_506.returns.push(".r[2vp51].[1][4][1]{comment10200350995551582_4955918}.[0].[right].[0].[left].[0].[0].[0][2]");
// 3649
o44 = {};
// 3650
o39.firstChild = o44;
// undefined
o44 = null;
// 3651
o44 = {};
// 3652
o39.nextSibling = o44;
// undefined
o39 = null;
// 3653
o44.getAttribute = f81632121_506;
// undefined
o44 = null;
// 3655
f81632121_506.returns.push(".r[2vp51].[1][4][1]{comment10200350995551582_4955918}.[0].[right].[0].[left].[0].[0].[3]");
// 3658
f81632121_506.returns.push(".r[2vp51].[1][4][1]{comment10200350995551582_4955918}");
// 3661
f81632121_645.returns.push(true);
// 3663
f81632121_467.returns.push(1374851214792);
// 3668
o39 = {};
// 3669
f81632121_504.returns.push(o39);
// 3670
o39.length = 8;
// 3671
o39["0"] = o40;
// 3672
o39["1"] = o41;
// 3673
o39["2"] = o42;
// 3674
o39["3"] = o43;
// 3675
o44 = {};
// 3676
o39["4"] = o44;
// 3677
o45 = {};
// 3678
o39["5"] = o45;
// 3679
o46 = {};
// 3680
o39["6"] = o46;
// 3681
o47 = {};
// 3682
o39["7"] = o47;
// undefined
o39 = null;
// 3683
f81632121_14.returns.push(undefined);
// 3684
f81632121_12.returns.push(8);
// 3685
o37.nodeName = "DIV";
// undefined
o37 = null;
// 3687
o38.nodeName = "DIV";
// 3688
o38.parentNode = o33;
// undefined
o38 = null;
// 3689
o33.nodeName = "FORM";
// 3693
o37 = {};
// 3694
f81632121_474.returns.push(o37);
// 3696
f81632121_478.returns.push(o37);
// undefined
o37 = null;
// 3701
o37 = {};
// 3702
f81632121_508.returns.push(o37);
// 3703
o37.id = "u_0_1x";
// 3704
o37.getElementsByTagName = f81632121_502;
// 3705
o38 = {};
// 3706
o37.parentNode = o38;
// 3724
f81632121_467.returns.push(1374851214824);
// 3729
o39 = {};
// 3730
f81632121_504.returns.push(o39);
// 3731
o39.length = 8;
// 3732
o39["0"] = o40;
// 3733
o39["1"] = o41;
// 3734
o39["2"] = o42;
// 3735
o39["3"] = o43;
// 3736
o39["4"] = o44;
// 3737
o39["5"] = o45;
// 3738
o39["6"] = o46;
// 3739
o39["7"] = o47;
// undefined
o39 = null;
// 3740
f81632121_14.returns.push(undefined);
// 3741
f81632121_12.returns.push(9);
// undefined
fo81632121_795_firstChild = function() { return fo81632121_795_firstChild.returns[fo81632121_795_firstChild.inst++]; };
fo81632121_795_firstChild.returns = [];
fo81632121_795_firstChild.inst = 0;
defineGetter(o37, "firstChild", fo81632121_795_firstChild, undefined);
// undefined
fo81632121_795_firstChild.returns.push(null);
// undefined
fo81632121_795_firstChild.returns.push(null);
// undefined
fo81632121_795_firstChild.returns.push(null);
// 3756
f81632121_466.returns.push(0.9252282343804836);
// 3758
f81632121_467.returns.push(1374851214828);
// 3760
f81632121_467.returns.push(1374851214829);
// 3766
f81632121_467.returns.push(1374851214829);
// 3768
f81632121_467.returns.push(1374851214829);
// 3770
f81632121_467.returns.push(1374851214835);
// 3772
f81632121_467.returns.push(1374851214835);
// 3774
f81632121_467.returns.push(1374851214835);
// 3775
o37.nodeType = 1;
// 3779
o39 = {};
// 3780
f81632121_474.returns.push(o39);
// 3782
f81632121_478.returns.push(o39);
// undefined
o39 = null;
// 3784
o39 = {};
// 3785
f81632121_476.returns.push(o39);
// 3786
o39.firstChild = null;
// 3788
o48 = {};
// 3789
f81632121_474.returns.push(o48);
// 3791
o49 = {};
// 3792
f81632121_598.returns.push(o49);
// 3793
o48.appendChild = f81632121_478;
// 3794
f81632121_478.returns.push(o49);
// undefined
o49 = null;
// 3795
o39.appendChild = f81632121_478;
// 3796
f81632121_478.returns.push(o48);
// undefined
o48 = null;
// 3797
o39.innerHTML = "You are the antithesis of what my husband has been writing his dissertation about.";
// undefined
o39 = null;
// 3800
f81632121_467.returns.push(1374851214859);
// 3804
o39 = {};
// 3805
f81632121_474.returns.push(o39);
// 3807
f81632121_478.returns.push(o39);
// undefined
o39 = null;
// 3809
o39 = {};
// 3810
f81632121_476.returns.push(o39);
// 3811
o39.firstChild = null;
// 3813
o48 = {};
// 3814
f81632121_474.returns.push(o48);
// 3816
o49 = {};
// 3817
f81632121_598.returns.push(o49);
// 3818
o48.appendChild = f81632121_478;
// 3819
f81632121_478.returns.push(o49);
// undefined
o49 = null;
// 3820
o39.appendChild = f81632121_478;
// 3821
f81632121_478.returns.push(o48);
// undefined
o48 = null;
// 3822
o39.innerHTML = "Harry: I'm turning 27, not 4½...";
// undefined
o39 = null;
// 3824
o39 = {};
// 3825
f81632121_476.returns.push(o39);
// 3826
o39.firstChild = null;
// 3828
o48 = {};
// 3829
f81632121_474.returns.push(o48);
// 3831
o49 = {};
// 3832
f81632121_598.returns.push(o49);
// 3833
o48.appendChild = f81632121_478;
// 3834
f81632121_478.returns.push(o49);
// undefined
o49 = null;
// 3835
o39.appendChild = f81632121_478;
// 3836
f81632121_478.returns.push(o48);
// undefined
o48 = null;
// 3837
o39.innerHTML = "Chrissi: Oh?";
// undefined
o39 = null;
// 3839
f81632121_467.returns.push(1374851214869);
// 3843
o39 = {};
// 3844
f81632121_474.returns.push(o39);
// 3846
f81632121_478.returns.push(o39);
// undefined
o39 = null;
// 3848
o39 = {};
// 3849
f81632121_476.returns.push(o39);
// 3850
o39.firstChild = null;
// 3852
o48 = {};
// 3853
f81632121_474.returns.push(o48);
// 3855
o49 = {};
// 3856
f81632121_598.returns.push(o49);
// 3857
o48.appendChild = f81632121_478;
// 3858
f81632121_478.returns.push(o49);
// undefined
o49 = null;
// 3859
o39.appendChild = f81632121_478;
// 3860
f81632121_478.returns.push(o48);
// undefined
o48 = null;
// 3861
o39.innerHTML = "irony vs satire/sarcasm, pragmatism, william james type stuff";
// undefined
o39 = null;
// 3864
f81632121_467.returns.push(1374851214880);
// 3868
o39 = {};
// 3869
f81632121_474.returns.push(o39);
// 3871
f81632121_478.returns.push(o39);
// undefined
o39 = null;
// 3873
o39 = {};
// 3874
f81632121_476.returns.push(o39);
// 3875
o39.setAttribute = f81632121_575;
// 3877
f81632121_575.returns.push(undefined);
// 3878
// 3879
o39.firstChild = null;
// 3881
o48 = {};
// 3882
f81632121_474.returns.push(o48);
// 3884
o49 = {};
// 3885
f81632121_598.returns.push(o49);
// 3886
o48.appendChild = f81632121_478;
// 3887
f81632121_478.returns.push(o49);
// undefined
o49 = null;
// 3888
o39.appendChild = f81632121_478;
// 3889
f81632121_478.returns.push(o48);
// undefined
o48 = null;
// 3891
o48 = {};
// 3892
f81632121_476.returns.push(o48);
// 3893
// 3894
// 3895
o49 = {};
// 3896
o48.classList = o49;
// 3898
o49.add = f81632121_602;
// undefined
o49 = null;
// 3899
f81632121_602.returns.push(undefined);
// 3901
o49 = {};
// 3902
f81632121_476.returns.push(o49);
// 3903
o49.firstChild = null;
// 3905
o50 = {};
// 3906
f81632121_474.returns.push(o50);
// 3908
o51 = {};
// 3909
f81632121_598.returns.push(o51);
// 3910
o50.appendChild = f81632121_478;
// 3911
f81632121_478.returns.push(o51);
// undefined
o51 = null;
// 3912
o39.__html = void 0;
// undefined
o39 = null;
// 3913
o48.__html = void 0;
// undefined
o48 = null;
// 3914
o49.appendChild = f81632121_478;
// 3915
f81632121_478.returns.push(o50);
// undefined
o50 = null;
// 3916
o49.innerHTML = "";
// undefined
o49 = null;
// 3919
f81632121_467.returns.push(1374851214900);
// 3921
o37.nextSibling = null;
// 3922
o38.removeChild = f81632121_521;
// 3923
f81632121_521.returns.push(o37);
// 3924
// 3925
o38.appendChild = f81632121_478;
// 3926
f81632121_478.returns.push(o37);
// 3928
f81632121_467.returns.push(1374851214913);
// 3930
f81632121_467.returns.push(1374851214913);
// 3933
f81632121_467.returns.push(1374851214913);
// 3935
f81632121_467.returns.push(1374851214913);
// 3937
f81632121_467.returns.push(1374851214913);
// 3939
f81632121_467.returns.push(1374851214913);
// 3940
o39 = {};
// undefined
fo81632121_795_firstChild.returns.push(o39);
// 3942
o39.getAttribute = f81632121_506;
// 3944
f81632121_506.returns.push(".r[5ib3u]");
// 3945
o48 = {};
// 3946
o39.firstChild = o48;
// 3947
o48.getAttribute = f81632121_506;
// 3949
f81632121_506.returns.push(".r[5ib3u].[1][0]");
// 3950
o49 = {};
// 3951
o48.firstChild = o49;
// undefined
o49 = null;
// 3952
o49 = {};
// 3953
o48.nextSibling = o49;
// undefined
o48 = null;
// 3954
o49.getAttribute = f81632121_506;
// 3956
f81632121_506.returns.push(".r[5ib3u].[1][4][0]");
// 3957
o48 = {};
// 3958
o49.firstChild = o48;
// undefined
o48 = null;
// 3959
o48 = {};
// 3960
o49.nextSibling = o48;
// undefined
o49 = null;
// 3961
o48.getAttribute = f81632121_506;
// 3963
f81632121_506.returns.push(".r[5ib3u].[1][4][1]{comment10200407437602598_4992459}");
// 3964
o49 = {};
// 3965
o48.firstChild = o49;
// 3966
o49.getAttribute = f81632121_506;
// 3968
f81632121_506.returns.push(".r[5ib3u].[1][4][1]{comment10200407437602598_4992459}.[0]");
// 3969
o50 = {};
// 3970
o49.firstChild = o50;
// undefined
o49 = null;
// 3971
o50.getAttribute = f81632121_506;
// 3973
f81632121_506.returns.push(".r[5ib3u].[1][4][1]{comment10200407437602598_4992459}.[0].[left]");
// 3974
o49 = {};
// 3975
o50.firstChild = o49;
// undefined
o49 = null;
// 3976
o49 = {};
// 3977
o50.nextSibling = o49;
// undefined
o50 = null;
// 3978
o49.getAttribute = f81632121_506;
// 3980
f81632121_506.returns.push(".r[5ib3u].[1][4][1]{comment10200407437602598_4992459}.[0].[right]");
// 3981
o50 = {};
// 3982
o49.firstChild = o50;
// undefined
o49 = null;
// 3983
o50.getAttribute = f81632121_506;
// 3985
f81632121_506.returns.push(".r[5ib3u].[1][4][1]{comment10200407437602598_4992459}.[0].[right].[0]");
// 3986
o49 = {};
// 3987
o50.firstChild = o49;
// undefined
o50 = null;
// 3988
o49.getAttribute = f81632121_506;
// 3990
f81632121_506.returns.push(".r[5ib3u].[1][4][1]{comment10200407437602598_4992459}.[0].[right].[0].[left]");
// 3991
o50 = {};
// 3992
o49.firstChild = o50;
// undefined
o49 = null;
// 3993
o50.getAttribute = f81632121_506;
// 3995
f81632121_506.returns.push(".r[5ib3u].[1][4][1]{comment10200407437602598_4992459}.[0].[right].[0].[left].[0]");
// 3996
o49 = {};
// 3997
o50.firstChild = o49;
// undefined
o50 = null;
// 3998
o49.getAttribute = f81632121_506;
// 4000
f81632121_506.returns.push(".r[5ib3u].[1][4][1]{comment10200407437602598_4992459}.[0].[right].[0].[left].[0].[0]");
// 4001
o50 = {};
// 4002
o49.firstChild = o50;
// undefined
o49 = null;
// 4003
o50.getAttribute = f81632121_506;
// 4005
f81632121_506.returns.push(".r[5ib3u].[1][4][1]{comment10200407437602598_4992459}.[0].[right].[0].[left].[0].[0].[0][0]");
// 4006
o49 = {};
// 4007
o50.firstChild = o49;
// undefined
o49 = null;
// 4008
o49 = {};
// 4009
o50.nextSibling = o49;
// undefined
o50 = null;
// 4010
o49.getAttribute = f81632121_506;
// 4012
f81632121_506.returns.push(".r[5ib3u].[1][4][1]{comment10200407437602598_4992459}.[0].[right].[0].[left].[0].[0].[0][1]");
// 4013
o50 = {};
// 4014
o49.firstChild = o50;
// undefined
o50 = null;
// 4015
o50 = {};
// 4016
o49.nextSibling = o50;
// undefined
o49 = null;
// 4017
o50.getAttribute = f81632121_506;
// 4019
f81632121_506.returns.push(".r[5ib3u].[1][4][1]{comment10200407437602598_4992459}.[0].[right].[0].[left].[0].[0].[0][2]");
// 4020
o49 = {};
// 4021
o50.firstChild = o49;
// undefined
o49 = null;
// 4022
o49 = {};
// 4023
o50.nextSibling = o49;
// undefined
o50 = null;
// 4024
o49.getAttribute = f81632121_506;
// undefined
o49 = null;
// 4026
f81632121_506.returns.push(".r[5ib3u].[1][4][1]{comment10200407437602598_4992459}.[0].[right].[0].[left].[0].[0].[3]");
// 4029
f81632121_506.returns.push(".r[5ib3u].[1][4][1]{comment10200407437602598_4992459}");
// 4030
o37.contains = f81632121_645;
// 4032
f81632121_645.returns.push(true);
// undefined
fo81632121_795_firstChild.returns.push(o39);
// 4036
f81632121_506.returns.push(".r[5ib3u]");
// 4040
f81632121_506.returns.push(".r[5ib3u].[1][0]");
// 4045
f81632121_506.returns.push(".r[5ib3u].[1][4][0]");
// 4050
f81632121_506.returns.push(".r[5ib3u].[1][4][1]{comment10200407437602598_4992459}");
// 4052
o49 = {};
// 4053
o48.nextSibling = o49;
// undefined
o48 = null;
// 4054
o49.getAttribute = f81632121_506;
// 4056
f81632121_506.returns.push(".r[5ib3u].[1][4][1]{comment10200407437602598_4992465}");
// 4057
o48 = {};
// 4058
o49.firstChild = o48;
// 4059
o48.getAttribute = f81632121_506;
// 4061
f81632121_506.returns.push(".r[5ib3u].[1][4][1]{comment10200407437602598_4992465}.[0]");
// 4062
o50 = {};
// 4063
o48.firstChild = o50;
// undefined
o48 = null;
// 4064
o50.getAttribute = f81632121_506;
// 4066
f81632121_506.returns.push(".r[5ib3u].[1][4][1]{comment10200407437602598_4992465}.[0].[left]");
// 4067
o48 = {};
// 4068
o50.firstChild = o48;
// undefined
o48 = null;
// 4069
o48 = {};
// 4070
o50.nextSibling = o48;
// undefined
o50 = null;
// 4071
o48.getAttribute = f81632121_506;
// 4073
f81632121_506.returns.push(".r[5ib3u].[1][4][1]{comment10200407437602598_4992465}.[0].[right]");
// 4074
o50 = {};
// 4075
o48.firstChild = o50;
// undefined
o48 = null;
// 4076
o50.getAttribute = f81632121_506;
// 4078
f81632121_506.returns.push(".r[5ib3u].[1][4][1]{comment10200407437602598_4992465}.[0].[right].[0]");
// 4079
o48 = {};
// 4080
o50.firstChild = o48;
// undefined
o50 = null;
// 4081
o48.getAttribute = f81632121_506;
// 4083
f81632121_506.returns.push(".r[5ib3u].[1][4][1]{comment10200407437602598_4992465}.[0].[right].[0].[left]");
// 4084
o50 = {};
// 4085
o48.firstChild = o50;
// undefined
o48 = null;
// 4086
o50.getAttribute = f81632121_506;
// 4088
f81632121_506.returns.push(".r[5ib3u].[1][4][1]{comment10200407437602598_4992465}.[0].[right].[0].[left].[0]");
// 4089
o48 = {};
// 4090
o50.firstChild = o48;
// undefined
o50 = null;
// 4091
o48.getAttribute = f81632121_506;
// 4093
f81632121_506.returns.push(".r[5ib3u].[1][4][1]{comment10200407437602598_4992465}.[0].[right].[0].[left].[0].[0]");
// 4094
o50 = {};
// 4095
o48.firstChild = o50;
// undefined
o48 = null;
// 4096
o50.getAttribute = f81632121_506;
// 4098
f81632121_506.returns.push(".r[5ib3u].[1][4][1]{comment10200407437602598_4992465}.[0].[right].[0].[left].[0].[0].[0][0]");
// 4099
o48 = {};
// 4100
o50.firstChild = o48;
// undefined
o48 = null;
// 4101
o48 = {};
// 4102
o50.nextSibling = o48;
// undefined
o50 = null;
// 4103
o48.getAttribute = f81632121_506;
// 4105
f81632121_506.returns.push(".r[5ib3u].[1][4][1]{comment10200407437602598_4992465}.[0].[right].[0].[left].[0].[0].[0][1]");
// 4106
o50 = {};
// 4107
o48.firstChild = o50;
// undefined
o50 = null;
// 4108
o50 = {};
// 4109
o48.nextSibling = o50;
// undefined
o48 = null;
// 4110
o50.getAttribute = f81632121_506;
// 4112
f81632121_506.returns.push(".r[5ib3u].[1][4][1]{comment10200407437602598_4992465}.[0].[right].[0].[left].[0].[0].[0][2]");
// 4113
o48 = {};
// 4114
o50.firstChild = o48;
// undefined
o48 = null;
// 4115
o48 = {};
// 4116
o50.nextSibling = o48;
// undefined
o50 = null;
// 4117
o48.getAttribute = f81632121_506;
// undefined
o48 = null;
// 4119
f81632121_506.returns.push(".r[5ib3u].[1][4][1]{comment10200407437602598_4992465}.[0].[right].[0].[left].[0].[0].[3]");
// 4122
f81632121_506.returns.push(".r[5ib3u].[1][4][1]{comment10200407437602598_4992465}");
// 4125
f81632121_645.returns.push(true);
// undefined
fo81632121_795_firstChild.returns.push(o39);
// 4129
f81632121_506.returns.push(".r[5ib3u]");
// 4133
f81632121_506.returns.push(".r[5ib3u].[1][0]");
// 4138
f81632121_506.returns.push(".r[5ib3u].[1][4][0]");
// 4143
f81632121_506.returns.push(".r[5ib3u].[1][4][1]{comment10200407437602598_4992459}");
// 4148
f81632121_506.returns.push(".r[5ib3u].[1][4][1]{comment10200407437602598_4992465}");
// 4150
o48 = {};
// 4151
o49.nextSibling = o48;
// undefined
o49 = null;
// 4152
o48.getAttribute = f81632121_506;
// 4154
f81632121_506.returns.push(".r[5ib3u].[1][4][1]{comment10200407437602598_4992473}");
// 4155
o49 = {};
// 4156
o48.firstChild = o49;
// 4157
o49.getAttribute = f81632121_506;
// 4159
f81632121_506.returns.push(".r[5ib3u].[1][4][1]{comment10200407437602598_4992473}.[0]");
// 4160
o50 = {};
// 4161
o49.firstChild = o50;
// undefined
o49 = null;
// 4162
o50.getAttribute = f81632121_506;
// 4164
f81632121_506.returns.push(".r[5ib3u].[1][4][1]{comment10200407437602598_4992473}.[0].[left]");
// 4165
o49 = {};
// 4166
o50.firstChild = o49;
// undefined
o49 = null;
// 4167
o49 = {};
// 4168
o50.nextSibling = o49;
// undefined
o50 = null;
// 4169
o49.getAttribute = f81632121_506;
// 4171
f81632121_506.returns.push(".r[5ib3u].[1][4][1]{comment10200407437602598_4992473}.[0].[right]");
// 4172
o50 = {};
// 4173
o49.firstChild = o50;
// undefined
o49 = null;
// 4174
o50.getAttribute = f81632121_506;
// 4176
f81632121_506.returns.push(".r[5ib3u].[1][4][1]{comment10200407437602598_4992473}.[0].[right].[0]");
// 4177
o49 = {};
// 4178
o50.firstChild = o49;
// undefined
o50 = null;
// 4179
o49.getAttribute = f81632121_506;
// 4181
f81632121_506.returns.push(".r[5ib3u].[1][4][1]{comment10200407437602598_4992473}.[0].[right].[0].[left]");
// 4182
o50 = {};
// 4183
o49.firstChild = o50;
// undefined
o49 = null;
// 4184
o50.getAttribute = f81632121_506;
// 4186
f81632121_506.returns.push(".r[5ib3u].[1][4][1]{comment10200407437602598_4992473}.[0].[right].[0].[left].[0]");
// 4187
o49 = {};
// 4188
o50.firstChild = o49;
// undefined
o50 = null;
// 4189
o49.getAttribute = f81632121_506;
// 4191
f81632121_506.returns.push(".r[5ib3u].[1][4][1]{comment10200407437602598_4992473}.[0].[right].[0].[left].[0].[0]");
// 4192
o50 = {};
// 4193
o49.firstChild = o50;
// undefined
o49 = null;
// 4194
o50.getAttribute = f81632121_506;
// 4196
f81632121_506.returns.push(".r[5ib3u].[1][4][1]{comment10200407437602598_4992473}.[0].[right].[0].[left].[0].[0].[0][0]");
// 4197
o49 = {};
// 4198
o50.firstChild = o49;
// undefined
o49 = null;
// 4199
o49 = {};
// 4200
o50.nextSibling = o49;
// undefined
o50 = null;
// 4201
o49.getAttribute = f81632121_506;
// 4203
f81632121_506.returns.push(".r[5ib3u].[1][4][1]{comment10200407437602598_4992473}.[0].[right].[0].[left].[0].[0].[0][1]");
// 4204
o50 = {};
// 4205
o49.firstChild = o50;
// undefined
o50 = null;
// 4206
o50 = {};
// 4207
o49.nextSibling = o50;
// undefined
o49 = null;
// 4208
o50.getAttribute = f81632121_506;
// 4210
f81632121_506.returns.push(".r[5ib3u].[1][4][1]{comment10200407437602598_4992473}.[0].[right].[0].[left].[0].[0].[0][2]");
// 4211
o49 = {};
// 4212
o50.firstChild = o49;
// undefined
o49 = null;
// 4213
o49 = {};
// 4214
o50.nextSibling = o49;
// undefined
o50 = null;
// 4215
o49.getAttribute = f81632121_506;
// undefined
o49 = null;
// 4217
f81632121_506.returns.push(".r[5ib3u].[1][4][1]{comment10200407437602598_4992473}.[0].[right].[0].[left].[0].[0].[3]");
// 4220
f81632121_506.returns.push(".r[5ib3u].[1][4][1]{comment10200407437602598_4992473}");
// 4223
f81632121_645.returns.push(true);
// undefined
fo81632121_795_firstChild.returns.push(o39);
// undefined
o39 = null;
// 4227
f81632121_506.returns.push(".r[5ib3u]");
// 4231
f81632121_506.returns.push(".r[5ib3u].[1][0]");
// 4236
f81632121_506.returns.push(".r[5ib3u].[1][4][0]");
// 4241
f81632121_506.returns.push(".r[5ib3u].[1][4][1]{comment10200407437602598_4992459}");
// 4246
f81632121_506.returns.push(".r[5ib3u].[1][4][1]{comment10200407437602598_4992465}");
// 4251
f81632121_506.returns.push(".r[5ib3u].[1][4][1]{comment10200407437602598_4992473}");
// 4253
o39 = {};
// 4254
o48.nextSibling = o39;
// undefined
o48 = null;
// 4255
o39.getAttribute = f81632121_506;
// 4257
f81632121_506.returns.push(".r[5ib3u].[1][4][1]{comment10200407437602598_4996311}");
// 4258
o48 = {};
// 4259
o39.firstChild = o48;
// undefined
o39 = null;
// 4260
o48.getAttribute = f81632121_506;
// 4262
f81632121_506.returns.push(".r[5ib3u].[1][4][1]{comment10200407437602598_4996311}.[0]");
// 4263
o39 = {};
// 4264
o48.firstChild = o39;
// undefined
o48 = null;
// 4265
o39.getAttribute = f81632121_506;
// 4267
f81632121_506.returns.push(".r[5ib3u].[1][4][1]{comment10200407437602598_4996311}.[0].[left]");
// 4268
o48 = {};
// 4269
o39.firstChild = o48;
// undefined
o48 = null;
// 4270
o48 = {};
// 4271
o39.nextSibling = o48;
// undefined
o39 = null;
// 4272
o48.getAttribute = f81632121_506;
// 4274
f81632121_506.returns.push(".r[5ib3u].[1][4][1]{comment10200407437602598_4996311}.[0].[right]");
// 4275
o39 = {};
// 4276
o48.firstChild = o39;
// undefined
o48 = null;
// 4277
o39.getAttribute = f81632121_506;
// 4279
f81632121_506.returns.push(".r[5ib3u].[1][4][1]{comment10200407437602598_4996311}.[0].[right].[0]");
// 4280
o48 = {};
// 4281
o39.firstChild = o48;
// undefined
o39 = null;
// 4282
o48.getAttribute = f81632121_506;
// 4284
f81632121_506.returns.push(".r[5ib3u].[1][4][1]{comment10200407437602598_4996311}.[0].[right].[0].[left]");
// 4285
o39 = {};
// 4286
o48.firstChild = o39;
// undefined
o48 = null;
// 4287
o39.getAttribute = f81632121_506;
// 4289
f81632121_506.returns.push(".r[5ib3u].[1][4][1]{comment10200407437602598_4996311}.[0].[right].[0].[left].[0]");
// 4290
o48 = {};
// 4291
o39.firstChild = o48;
// undefined
o39 = null;
// 4292
o48.getAttribute = f81632121_506;
// 4294
f81632121_506.returns.push(".r[5ib3u].[1][4][1]{comment10200407437602598_4996311}.[0].[right].[0].[left].[0].[0]");
// 4295
o39 = {};
// 4296
o48.firstChild = o39;
// undefined
o48 = null;
// 4297
o39.getAttribute = f81632121_506;
// 4299
f81632121_506.returns.push(".r[5ib3u].[1][4][1]{comment10200407437602598_4996311}.[0].[right].[0].[left].[0].[0].[0][0]");
// 4300
o48 = {};
// 4301
o39.firstChild = o48;
// undefined
o48 = null;
// 4302
o48 = {};
// 4303
o39.nextSibling = o48;
// undefined
o39 = null;
// 4304
o48.getAttribute = f81632121_506;
// 4306
f81632121_506.returns.push(".r[5ib3u].[1][4][1]{comment10200407437602598_4996311}.[0].[right].[0].[left].[0].[0].[0][1]");
// 4307
o39 = {};
// 4308
o48.firstChild = o39;
// undefined
o39 = null;
// 4309
o39 = {};
// 4310
o48.nextSibling = o39;
// undefined
o48 = null;
// 4311
o39.getAttribute = f81632121_506;
// 4313
f81632121_506.returns.push(".r[5ib3u].[1][4][1]{comment10200407437602598_4996311}.[0].[right].[0].[left].[0].[0].[0][2]");
// 4314
o48 = {};
// 4315
o39.firstChild = o48;
// undefined
o48 = null;
// 4316
o48 = {};
// 4317
o39.nextSibling = o48;
// undefined
o39 = null;
// 4318
o48.getAttribute = f81632121_506;
// undefined
o48 = null;
// 4320
f81632121_506.returns.push(".r[5ib3u].[1][4][1]{comment10200407437602598_4996311}.[0].[right].[0].[left].[0].[0].[3]");
// 4323
f81632121_506.returns.push(".r[5ib3u].[1][4][1]{comment10200407437602598_4996311}");
// 4326
f81632121_645.returns.push(true);
// 4328
f81632121_467.returns.push(1374851214951);
// 4333
o39 = {};
// 4334
f81632121_504.returns.push(o39);
// 4335
o39.length = 12;
// 4336
o39["0"] = o40;
// 4337
o39["1"] = o41;
// 4338
o39["2"] = o42;
// 4339
o39["3"] = o43;
// 4340
o48 = {};
// 4341
o39["4"] = o48;
// 4342
o49 = {};
// 4343
o39["5"] = o49;
// 4344
o50 = {};
// 4345
o39["6"] = o50;
// 4346
o51 = {};
// 4347
o39["7"] = o51;
// 4348
o39["8"] = o44;
// 4349
o39["9"] = o45;
// 4350
o39["10"] = o46;
// 4351
o39["11"] = o47;
// undefined
o39 = null;
// 4352
f81632121_14.returns.push(undefined);
// 4353
f81632121_12.returns.push(10);
// 4354
o37.nodeName = "DIV";
// undefined
o37 = null;
// 4356
o38.nodeName = "DIV";
// 4357
o38.parentNode = o35;
// undefined
o38 = null;
// 4358
o35.nodeName = "FORM";
// 4362
o37 = {};
// 4363
f81632121_474.returns.push(o37);
// 4365
f81632121_478.returns.push(o37);
// undefined
o37 = null;
// 4370
o37 = {};
// 4371
f81632121_508.returns.push(o37);
// 4372
o37.id = "u_0_1z";
// 4373
o37.getElementsByTagName = f81632121_502;
// 4374
o38 = {};
// 4375
o37.parentNode = o38;
// 4394
f81632121_467.returns.push(1374851214979);
// 4399
o39 = {};
// 4400
f81632121_504.returns.push(o39);
// 4401
o39.length = 12;
// 4402
o39["0"] = o40;
// 4403
o39["1"] = o41;
// 4404
o39["2"] = o42;
// 4405
o39["3"] = o43;
// 4406
o39["4"] = o48;
// 4407
o39["5"] = o49;
// 4408
o39["6"] = o50;
// 4409
o39["7"] = o51;
// 4410
o39["8"] = o44;
// 4411
o39["9"] = o45;
// 4412
o39["10"] = o46;
// 4413
o39["11"] = o47;
// undefined
o39 = null;
// 4414
f81632121_14.returns.push(undefined);
// 4415
f81632121_12.returns.push(11);
// undefined
fo81632121_897_firstChild = function() { return fo81632121_897_firstChild.returns[fo81632121_897_firstChild.inst++]; };
fo81632121_897_firstChild.returns = [];
fo81632121_897_firstChild.inst = 0;
defineGetter(o37, "firstChild", fo81632121_897_firstChild, undefined);
// undefined
fo81632121_897_firstChild.returns.push(null);
// undefined
fo81632121_897_firstChild.returns.push(null);
// undefined
fo81632121_897_firstChild.returns.push(null);
// 4432
f81632121_466.returns.push(0.032721861032769084);
// 4434
f81632121_467.returns.push(1374851214985);
// 4436
f81632121_467.returns.push(1374851214997);
// 4442
f81632121_467.returns.push(1374851214998);
// 4444
f81632121_467.returns.push(1374851214998);
// 4446
f81632121_467.returns.push(1374851214998);
// 4448
f81632121_467.returns.push(1374851214998);
// 4450
f81632121_467.returns.push(1374851214998);
// 4451
o37.nodeType = 1;
// 4455
o39 = {};
// 4456
f81632121_474.returns.push(o39);
// 4458
f81632121_478.returns.push(o39);
// undefined
o39 = null;
// 4460
o39 = {};
// 4461
f81632121_476.returns.push(o39);
// 4462
o39.setAttribute = f81632121_575;
// 4464
f81632121_575.returns.push(undefined);
// 4465
// 4466
o39.firstChild = null;
// 4468
o52 = {};
// 4469
f81632121_474.returns.push(o52);
// 4471
o53 = {};
// 4472
f81632121_598.returns.push(o53);
// 4473
o52.appendChild = f81632121_478;
// 4474
f81632121_478.returns.push(o53);
// undefined
o53 = null;
// 4475
o39.appendChild = f81632121_478;
// 4476
f81632121_478.returns.push(o52);
// undefined
o52 = null;
// 4478
o52 = {};
// 4479
f81632121_476.returns.push(o52);
// 4480
// 4481
// 4482
o53 = {};
// 4483
o52.classList = o53;
// 4485
o53.add = f81632121_602;
// undefined
o53 = null;
// 4486
f81632121_602.returns.push(undefined);
// 4488
o53 = {};
// 4489
f81632121_476.returns.push(o53);
// 4490
o53.firstChild = null;
// 4492
o54 = {};
// 4493
f81632121_474.returns.push(o54);
// 4495
o55 = {};
// 4496
f81632121_598.returns.push(o55);
// 4497
o54.appendChild = f81632121_478;
// 4498
f81632121_478.returns.push(o55);
// undefined
o55 = null;
// 4499
o39.__html = void 0;
// undefined
o39 = null;
// 4500
o52.__html = void 0;
// undefined
o52 = null;
// 4501
o53.appendChild = f81632121_478;
// 4502
f81632121_478.returns.push(o54);
// undefined
o54 = null;
// 4503
o53.innerHTML = "Does it have a sense of the surreal or are you just sharing a data point? ";
// undefined
o53 = null;
// 4505
f81632121_467.returns.push(1374851215036);
// 4509
o39 = {};
// 4510
f81632121_474.returns.push(o39);
// 4512
f81632121_478.returns.push(o39);
// undefined
o39 = null;
// 4514
o39 = {};
// 4515
f81632121_476.returns.push(o39);
// 4516
o39.firstChild = null;
// 4518
o52 = {};
// 4519
f81632121_474.returns.push(o52);
// 4521
o53 = {};
// 4522
f81632121_598.returns.push(o53);
// 4523
o52.appendChild = f81632121_478;
// 4524
f81632121_478.returns.push(o53);
// undefined
o53 = null;
// 4525
o39.appendChild = f81632121_478;
// 4526
f81632121_478.returns.push(o52);
// undefined
o52 = null;
// 4527
o39.innerHTML = "Merely minor amusement.";
// undefined
o39 = null;
// 4529
f81632121_467.returns.push(1374851215042);
// 4533
o39 = {};
// 4534
f81632121_474.returns.push(o39);
// 4536
f81632121_478.returns.push(o39);
// undefined
o39 = null;
// 4538
o39 = {};
// 4539
f81632121_476.returns.push(o39);
// 4540
o39.firstChild = null;
// 4542
o52 = {};
// 4543
f81632121_474.returns.push(o52);
// 4545
o53 = {};
// 4546
f81632121_598.returns.push(o53);
// 4547
o52.appendChild = f81632121_478;
// 4548
f81632121_478.returns.push(o53);
// undefined
o53 = null;
// 4549
o39.appendChild = f81632121_478;
// 4550
f81632121_478.returns.push(o52);
// undefined
o52 = null;
// 4551
o39.innerHTML = "Did you wear ";
// undefined
o39 = null;
// 4553
f81632121_467.returns.push(1374851215052);
// 4557
o39 = {};
// 4558
f81632121_474.returns.push(o39);
// 4560
f81632121_478.returns.push(o39);
// undefined
o39 = null;
// 4562
o39 = {};
// 4563
f81632121_476.returns.push(o39);
// 4564
o39.firstChild = null;
// 4566
o52 = {};
// 4567
f81632121_474.returns.push(o52);
// 4569
o53 = {};
// 4570
f81632121_598.returns.push(o53);
// 4571
o52.appendChild = f81632121_478;
// 4572
f81632121_478.returns.push(o53);
// undefined
o53 = null;
// 4573
o39.appendChild = f81632121_478;
// 4574
f81632121_478.returns.push(o52);
// undefined
o52 = null;
// 4575
o39.innerHTML = "That's the most delightfully offensive piece of apparel I've seen in quite some time.";
// undefined
o39 = null;
// 4577
f81632121_467.returns.push(1374851215058);
// 4579
o37.nextSibling = null;
// 4580
o38.removeChild = f81632121_521;
// 4581
f81632121_521.returns.push(o37);
// 4582
// 4583
o38.appendChild = f81632121_478;
// 4584
f81632121_478.returns.push(o37);
// 4586
f81632121_467.returns.push(1374851215069);
// 4588
f81632121_467.returns.push(1374851215070);
// 4591
f81632121_467.returns.push(1374851215070);
// 4593
f81632121_467.returns.push(1374851215070);
// 4595
f81632121_467.returns.push(1374851215070);
// 4597
f81632121_467.returns.push(1374851215070);
// 4598
o39 = {};
// undefined
fo81632121_897_firstChild.returns.push(o39);
// 4600
o39.getAttribute = f81632121_506;
// 4602
f81632121_506.returns.push(".r[70hf]");
// 4603
o52 = {};
// 4604
o39.firstChild = o52;
// 4605
o52.getAttribute = f81632121_506;
// 4607
f81632121_506.returns.push(".r[70hf].[1][0]");
// 4608
o53 = {};
// 4609
o52.firstChild = o53;
// undefined
o53 = null;
// 4610
o53 = {};
// 4611
o52.nextSibling = o53;
// undefined
o52 = null;
// 4612
o53.getAttribute = f81632121_506;
// 4614
f81632121_506.returns.push(".r[70hf].[1][4][0]");
// 4615
o52 = {};
// 4616
o53.firstChild = o52;
// undefined
o52 = null;
// 4617
o52 = {};
// 4618
o53.nextSibling = o52;
// undefined
o53 = null;
// 4619
o52.getAttribute = f81632121_506;
// 4621
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4946958}");
// 4622
o53 = {};
// 4623
o52.firstChild = o53;
// 4624
o53.getAttribute = f81632121_506;
// 4626
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4946958}.[0]");
// 4627
o54 = {};
// 4628
o53.firstChild = o54;
// undefined
o53 = null;
// 4629
o54.getAttribute = f81632121_506;
// 4631
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4946958}.[0].[left]");
// 4632
o53 = {};
// 4633
o54.firstChild = o53;
// undefined
o53 = null;
// 4634
o53 = {};
// 4635
o54.nextSibling = o53;
// undefined
o54 = null;
// 4636
o53.getAttribute = f81632121_506;
// 4638
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4946958}.[0].[right]");
// 4639
o54 = {};
// 4640
o53.firstChild = o54;
// undefined
o53 = null;
// 4641
o54.getAttribute = f81632121_506;
// 4643
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4946958}.[0].[right].[0]");
// 4644
o53 = {};
// 4645
o54.firstChild = o53;
// undefined
o54 = null;
// 4646
o53.getAttribute = f81632121_506;
// 4648
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4946958}.[0].[right].[0].[left]");
// 4649
o54 = {};
// 4650
o53.firstChild = o54;
// undefined
o53 = null;
// 4651
o54.getAttribute = f81632121_506;
// 4653
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4946958}.[0].[right].[0].[left].[0]");
// 4654
o53 = {};
// 4655
o54.firstChild = o53;
// undefined
o54 = null;
// 4656
o53.getAttribute = f81632121_506;
// 4658
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4946958}.[0].[right].[0].[left].[0].[0]");
// 4659
o54 = {};
// 4660
o53.firstChild = o54;
// undefined
o53 = null;
// 4661
o54.getAttribute = f81632121_506;
// 4663
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4946958}.[0].[right].[0].[left].[0].[0].[0][0]");
// 4664
o53 = {};
// 4665
o54.firstChild = o53;
// undefined
o53 = null;
// 4666
o53 = {};
// 4667
o54.nextSibling = o53;
// undefined
o54 = null;
// 4668
o53.getAttribute = f81632121_506;
// 4670
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4946958}.[0].[right].[0].[left].[0].[0].[0][1]");
// 4671
o54 = {};
// 4672
o53.firstChild = o54;
// undefined
o54 = null;
// 4673
o54 = {};
// 4674
o53.nextSibling = o54;
// undefined
o53 = null;
// 4675
o54.getAttribute = f81632121_506;
// 4677
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4946958}.[0].[right].[0].[left].[0].[0].[0][2]");
// 4678
o53 = {};
// 4679
o54.firstChild = o53;
// undefined
o53 = null;
// 4680
o53 = {};
// 4681
o54.nextSibling = o53;
// undefined
o54 = null;
// 4682
o53.getAttribute = f81632121_506;
// undefined
o53 = null;
// 4684
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4946958}.[0].[right].[0].[left].[0].[0].[3]");
// 4687
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4946958}");
// 4688
o37.contains = f81632121_645;
// 4690
f81632121_645.returns.push(true);
// undefined
fo81632121_897_firstChild.returns.push(o39);
// 4694
f81632121_506.returns.push(".r[70hf]");
// 4698
f81632121_506.returns.push(".r[70hf].[1][0]");
// 4703
f81632121_506.returns.push(".r[70hf].[1][4][0]");
// 4708
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4946958}");
// 4710
o53 = {};
// 4711
o52.nextSibling = o53;
// undefined
o52 = null;
// 4712
o53.getAttribute = f81632121_506;
// 4714
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4947623}");
// 4715
o52 = {};
// 4716
o53.firstChild = o52;
// 4717
o52.getAttribute = f81632121_506;
// 4719
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4947623}.[0]");
// 4720
o54 = {};
// 4721
o52.firstChild = o54;
// undefined
o52 = null;
// 4722
o54.getAttribute = f81632121_506;
// 4724
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4947623}.[0].[left]");
// 4725
o52 = {};
// 4726
o54.firstChild = o52;
// undefined
o52 = null;
// 4727
o52 = {};
// 4728
o54.nextSibling = o52;
// undefined
o54 = null;
// 4729
o52.getAttribute = f81632121_506;
// 4731
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4947623}.[0].[right]");
// 4732
o54 = {};
// 4733
o52.firstChild = o54;
// undefined
o52 = null;
// 4734
o54.getAttribute = f81632121_506;
// 4736
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4947623}.[0].[right].[0]");
// 4737
o52 = {};
// 4738
o54.firstChild = o52;
// undefined
o54 = null;
// 4739
o52.getAttribute = f81632121_506;
// 4741
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4947623}.[0].[right].[0].[left]");
// 4742
o54 = {};
// 4743
o52.firstChild = o54;
// undefined
o52 = null;
// 4744
o54.getAttribute = f81632121_506;
// 4746
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4947623}.[0].[right].[0].[left].[0]");
// 4747
o52 = {};
// 4748
o54.firstChild = o52;
// 4749
o52.getAttribute = f81632121_506;
// 4751
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4947623}.[0].[right].[0].[left].[0].[0]");
// 4752
o55 = {};
// 4753
o52.firstChild = o55;
// 4754
o55.getAttribute = f81632121_506;
// 4756
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4947623}.[0].[right].[0].[left].[0].[0].[0][0]");
// 4757
o56 = {};
// 4758
o55.firstChild = o56;
// undefined
o56 = null;
// 4759
o56 = {};
// 4760
o55.nextSibling = o56;
// undefined
o55 = null;
// 4761
o56.getAttribute = f81632121_506;
// 4763
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4947623}.[0].[right].[0].[left].[0].[0].[0][1]");
// 4764
o55 = {};
// 4765
o56.firstChild = o55;
// undefined
o55 = null;
// 4766
o55 = {};
// 4767
o56.nextSibling = o55;
// undefined
o56 = null;
// 4768
o55.getAttribute = f81632121_506;
// 4770
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4947623}.[0].[right].[0].[left].[0].[0].[0][2]");
// 4771
o56 = {};
// 4772
o55.firstChild = o56;
// undefined
o56 = null;
// 4773
o56 = {};
// 4774
o55.nextSibling = o56;
// undefined
o55 = null;
// 4775
o56.getAttribute = f81632121_506;
// undefined
o56 = null;
// 4777
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4947623}.[0].[right].[0].[left].[0].[0].[3]");
// 4780
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4947623}");
// 4783
f81632121_645.returns.push(true);
// undefined
fo81632121_897_firstChild.returns.push(o39);
// 4787
f81632121_506.returns.push(".r[70hf]");
// 4791
f81632121_506.returns.push(".r[70hf].[1][0]");
// 4796
f81632121_506.returns.push(".r[70hf].[1][4][0]");
// 4801
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4946958}");
// 4806
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4947623}");
// 4808
o55 = {};
// 4809
o53.nextSibling = o55;
// 4810
o55.getAttribute = f81632121_506;
// 4812
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4950566}");
// 4813
o56 = {};
// 4814
o55.firstChild = o56;
// 4815
o56.getAttribute = f81632121_506;
// 4817
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4950566}.[0]");
// 4818
o57 = {};
// 4819
o56.firstChild = o57;
// undefined
o56 = null;
// 4820
o57.getAttribute = f81632121_506;
// 4822
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4950566}.[0].[left]");
// 4823
o56 = {};
// 4824
o57.firstChild = o56;
// undefined
o56 = null;
// 4825
o56 = {};
// 4826
o57.nextSibling = o56;
// undefined
o57 = null;
// 4827
o56.getAttribute = f81632121_506;
// 4829
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4950566}.[0].[right]");
// 4830
o57 = {};
// 4831
o56.firstChild = o57;
// undefined
o56 = null;
// 4832
o57.getAttribute = f81632121_506;
// 4834
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4950566}.[0].[right].[0]");
// 4835
o56 = {};
// 4836
o57.firstChild = o56;
// undefined
o57 = null;
// 4837
o56.getAttribute = f81632121_506;
// 4839
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4950566}.[0].[right].[0].[left]");
// 4840
o57 = {};
// 4841
o56.firstChild = o57;
// undefined
o56 = null;
// 4842
o57.getAttribute = f81632121_506;
// 4844
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4950566}.[0].[right].[0].[left].[0]");
// 4845
o56 = {};
// 4846
o57.firstChild = o56;
// undefined
o57 = null;
// 4847
o56.getAttribute = f81632121_506;
// 4849
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4950566}.[0].[right].[0].[left].[0].[0]");
// 4850
o57 = {};
// 4851
o56.firstChild = o57;
// undefined
o56 = null;
// 4852
o57.getAttribute = f81632121_506;
// 4854
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4950566}.[0].[right].[0].[left].[0].[0].[0][0]");
// 4855
o56 = {};
// 4856
o57.firstChild = o56;
// undefined
o56 = null;
// 4857
o56 = {};
// 4858
o57.nextSibling = o56;
// undefined
o57 = null;
// 4859
o56.getAttribute = f81632121_506;
// 4861
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4950566}.[0].[right].[0].[left].[0].[0].[0][1]");
// 4862
o57 = {};
// 4863
o56.firstChild = o57;
// undefined
o57 = null;
// 4864
o57 = {};
// 4865
o56.nextSibling = o57;
// undefined
o56 = null;
// 4866
o57.getAttribute = f81632121_506;
// 4868
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4950566}.[0].[right].[0].[left].[0].[0].[0][2]");
// 4869
o56 = {};
// 4870
o57.firstChild = o56;
// undefined
o56 = null;
// 4871
o56 = {};
// 4872
o57.nextSibling = o56;
// undefined
o57 = null;
// 4873
o56.getAttribute = f81632121_506;
// undefined
o56 = null;
// 4875
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4950566}.[0].[right].[0].[left].[0].[0].[3]");
// 4878
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4950566}");
// 4881
f81632121_645.returns.push(true);
// undefined
fo81632121_897_firstChild.returns.push(o39);
// 4885
f81632121_506.returns.push(".r[70hf]");
// 4889
f81632121_506.returns.push(".r[70hf].[1][0]");
// 4894
f81632121_506.returns.push(".r[70hf].[1][4][0]");
// 4899
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4946958}");
// 4904
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4947623}");
// 4909
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4950566}");
// 4911
o56 = {};
// 4912
o55.nextSibling = o56;
// undefined
o55 = null;
// 4913
o56.getAttribute = f81632121_506;
// 4915
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4950571}");
// 4916
o55 = {};
// 4917
o56.firstChild = o55;
// undefined
o56 = null;
// 4918
o55.getAttribute = f81632121_506;
// 4920
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4950571}.[0]");
// 4921
o56 = {};
// 4922
o55.firstChild = o56;
// undefined
o55 = null;
// 4923
o56.getAttribute = f81632121_506;
// 4925
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4950571}.[0].[left]");
// 4926
o55 = {};
// 4927
o56.firstChild = o55;
// undefined
o55 = null;
// 4928
o55 = {};
// 4929
o56.nextSibling = o55;
// undefined
o56 = null;
// 4930
o55.getAttribute = f81632121_506;
// 4932
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4950571}.[0].[right]");
// 4933
o56 = {};
// 4934
o55.firstChild = o56;
// undefined
o55 = null;
// 4935
o56.getAttribute = f81632121_506;
// 4937
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4950571}.[0].[right].[0]");
// 4938
o55 = {};
// 4939
o56.firstChild = o55;
// undefined
o56 = null;
// 4940
o55.getAttribute = f81632121_506;
// 4942
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4950571}.[0].[right].[0].[left]");
// 4943
o56 = {};
// 4944
o55.firstChild = o56;
// undefined
o55 = null;
// 4945
o56.getAttribute = f81632121_506;
// 4947
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4950571}.[0].[right].[0].[left].[0]");
// 4948
o55 = {};
// 4949
o56.firstChild = o55;
// undefined
o56 = null;
// 4950
o55.getAttribute = f81632121_506;
// 4952
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4950571}.[0].[right].[0].[left].[0].[0]");
// 4953
o56 = {};
// 4954
o55.firstChild = o56;
// undefined
o55 = null;
// 4955
o56.getAttribute = f81632121_506;
// 4957
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4950571}.[0].[right].[0].[left].[0].[0].[0][0]");
// 4958
o55 = {};
// 4959
o56.firstChild = o55;
// undefined
o55 = null;
// 4960
o55 = {};
// 4961
o56.nextSibling = o55;
// undefined
o56 = null;
// 4962
o55.getAttribute = f81632121_506;
// 4964
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4950571}.[0].[right].[0].[left].[0].[0].[0][1]");
// 4965
o56 = {};
// 4966
o55.firstChild = o56;
// undefined
o56 = null;
// 4967
o56 = {};
// 4968
o55.nextSibling = o56;
// undefined
o55 = null;
// 4969
o56.getAttribute = f81632121_506;
// 4971
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4950571}.[0].[right].[0].[left].[0].[0].[0][2]");
// 4972
o55 = {};
// 4973
o56.firstChild = o55;
// undefined
o55 = null;
// 4974
o55 = {};
// 4975
o56.nextSibling = o55;
// undefined
o56 = null;
// 4976
o55.getAttribute = f81632121_506;
// undefined
o55 = null;
// 4978
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4950571}.[0].[right].[0].[left].[0].[0].[3]");
// 4981
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4950571}");
// 4984
f81632121_645.returns.push(true);
// 4986
f81632121_467.returns.push(1374851215098);
// 4991
o55 = {};
// 4992
f81632121_504.returns.push(o55);
// 4993
o55.length = 16;
// 4994
o55["0"] = o40;
// 4995
o55["1"] = o41;
// 4996
o55["2"] = o42;
// 4997
o55["3"] = o43;
// 4998
o55["4"] = o48;
// 4999
o55["5"] = o49;
// 5000
o55["6"] = o50;
// 5001
o55["7"] = o51;
// 5002
o55["8"] = o44;
// 5003
o55["9"] = o45;
// 5004
o55["10"] = o46;
// 5005
o55["11"] = o47;
// 5006
o56 = {};
// 5007
o55["12"] = o56;
// 5008
o57 = {};
// 5009
o55["13"] = o57;
// 5010
o58 = {};
// 5011
o55["14"] = o58;
// 5012
o59 = {};
// 5013
o55["15"] = o59;
// undefined
o55 = null;
// 5014
f81632121_14.returns.push(undefined);
// 5015
f81632121_12.returns.push(12);
// 5016
o37.nodeName = "DIV";
// undefined
o37 = null;
// 5018
o38.nodeName = "DIV";
// 5019
o38.parentNode = o32;
// undefined
o38 = null;
// 5020
o32.nodeName = "FORM";
// 5024
o37 = {};
// 5025
f81632121_474.returns.push(o37);
// 5027
f81632121_478.returns.push(o37);
// undefined
o37 = null;
// 5029
f81632121_467.returns.push(1374851215100);
// 5033
o37 = {};
// 5034
f81632121_474.returns.push(o37);
// 5036
f81632121_478.returns.push(o37);
// undefined
o37 = null;
// 5039
f81632121_467.returns.push(1374851215101);
// 5041
f81632121_467.returns.push(1374851215101);
// 5042
o37 = {};
// 5044
o23.parentNode = o9;
// 5045
o9.removeChild = f81632121_521;
// 5046
f81632121_521.returns.push(o23);
// 5054
o38 = {};
// 5055
o55 = {};
// 5057
o38.nodeType = void 0;
// 5058
o38.length = 1;
// 5059
o38["0"] = "/MWWQ";
// 5070
f81632121_468.returns.push(undefined);
// 5071
o8.JSBNG__oninput = null;
// 5076
f81632121_468.returns.push(undefined);
// 5077
o8.JSBNG__onkeyup = null;
// 5084
f81632121_468.returns.push(undefined);
// 5085
f81632121_1000 = function() { return f81632121_1000.returns[f81632121_1000.inst++]; };
f81632121_1000.returns = [];
f81632121_1000.inst = 0;
// 5086
o8.JSBNG__onsubmit = f81632121_1000;
// 5089
// 5094
o5.protocol = "https:";
// undefined
fo81632121_1_cookie = function() { return fo81632121_1_cookie.returns[fo81632121_1_cookie.inst++]; };
fo81632121_1_cookie.returns = [];
fo81632121_1_cookie.inst = 0;
defineGetter(o0, "cookie", fo81632121_1_cookie, undefined);
// undefined
fo81632121_1_cookie.returns.push("c_user=100006118350059; csm=2; highContrastMode=1; wd=1034x727");
// 5097
f81632121_467.returns.push(1374851215241);
// 5098
o60 = {};
// 5099
f81632121_0.returns.push(o60);
// 5100
f81632121_1002 = function() { return f81632121_1002.returns[f81632121_1002.inst++]; };
f81632121_1002.returns = [];
f81632121_1002.inst = 0;
// 5101
o60.toGMTString = f81632121_1002;
// undefined
o60 = null;
// 5102
f81632121_1002.returns.push("Fri, 02 Aug 2013 15:06:55 GMT");
// 5103
o5.hostname = "jsbngssl.www.facebook.com";
// undefined
fo81632121_1_cookie.returns.push("c_user=100006118350059; csm=2; highContrastMode=1; wd=1034x727");
// 5106
f81632121_467.returns.push(1374851215242);
// 5108
f81632121_482.returns.push("1;1");
// 5113
// 5116
o60 = {};
// 5117
o61 = {};
// 5119
o60.nodeType = void 0;
// 5120
o60.length = 1;
// 5121
o60["0"] = "AVmr9";
// 5131
f81632121_468.returns.push(undefined);
// 5132
o8.JSBNG__onkeydown = null;
// 5142
f81632121_468.returns.push(undefined);
// 5143
f81632121_1005 = function() { return f81632121_1005.returns[f81632121_1005.inst++]; };
f81632121_1005.returns = [];
f81632121_1005.inst = 0;
// 5144
o8.JSBNG__onclick = f81632121_1005;
// 5147
// 5151
o62 = {};
// 5152
f81632121_476.returns.push(o62);
// 5157
f81632121_468.returns.push(undefined);
// 5158
o8.JSBNG__onmousedown = null;
// 5166
f81632121_468.returns.push(undefined);
// 5167
f81632121_1007 = function() { return f81632121_1007.returns[f81632121_1007.inst++]; };
f81632121_1007.returns = [];
f81632121_1007.inst = 0;
// 5168
o8.JSBNG__onmouseover = f81632121_1007;
// 5171
// 5183
o63 = {};
// 5184
f81632121_508.returns.push(o63);
// 5185
o63.getElementsByTagName = f81632121_502;
// 5187
o63.querySelectorAll = f81632121_504;
// 5188
o64 = {};
// 5189
f81632121_504.returns.push(o64);
// 5190
o64.length = 1;
// 5191
o65 = {};
// 5192
o64["0"] = o65;
// undefined
o64 = null;
// 5193
o65.getElementsByTagName = f81632121_502;
// 5195
o65.querySelectorAll = f81632121_504;
// 5196
o64 = {};
// 5197
f81632121_504.returns.push(o64);
// 5198
o64.length = 1;
// 5199
o66 = {};
// 5200
o64["0"] = o66;
// undefined
o64 = null;
// 5201
o66.getElementsByTagName = f81632121_502;
// 5203
o66.querySelectorAll = f81632121_504;
// undefined
o66 = null;
// 5204
o64 = {};
// 5205
f81632121_504.returns.push(o64);
// 5206
o64.length = 1;
// 5207
o66 = {};
// 5208
o64["0"] = o66;
// undefined
o64 = null;
// 5212
o64 = {};
// 5213
f81632121_504.returns.push(o64);
// 5214
o64.length = 1;
// 5215
o67 = {};
// 5216
o64["0"] = o67;
// undefined
o64 = null;
// 5217
o67.getElementsByTagName = f81632121_502;
// 5219
o67.querySelectorAll = f81632121_504;
// 5220
o64 = {};
// 5221
f81632121_504.returns.push(o64);
// 5222
o64.length = 1;
// 5223
o68 = {};
// 5224
o64["0"] = o68;
// undefined
o64 = null;
// 5225
f81632121_12.returns.push(13);
// 5226
o65.nodeName = "DIV";
// 5227
o65.__FB_TOKEN = void 0;
// 5228
// 5229
o65.getAttribute = f81632121_506;
// 5230
o65.hasAttribute = f81632121_507;
// 5232
f81632121_507.returns.push(false);
// 5233
o65.JSBNG__addEventListener = f81632121_468;
// 5235
f81632121_468.returns.push(undefined);
// 5236
o65.JSBNG__onJSBNG__scroll = void 0;
// 5238
o63.nodeName = "DIV";
// 5239
o63.__FB_TOKEN = void 0;
// 5240
// 5241
o63.getAttribute = f81632121_506;
// 5242
o63.hasAttribute = f81632121_507;
// 5244
f81632121_507.returns.push(false);
// 5245
o63.JSBNG__addEventListener = f81632121_468;
// 5247
f81632121_468.returns.push(undefined);
// 5248
o63.JSBNG__onmousemove = null;
// 5250
o67.nodeName = "DIV";
// 5251
o67.__FB_TOKEN = void 0;
// 5252
// 5253
o67.getAttribute = f81632121_506;
// 5254
o67.hasAttribute = f81632121_507;
// 5256
f81632121_507.returns.push(false);
// 5257
o67.JSBNG__addEventListener = f81632121_468;
// 5259
f81632121_468.returns.push(undefined);
// 5260
o67.JSBNG__onclick = null;
// 5262
o64 = {};
// 5263
o62.style = o64;
// 5265
// 5267
// undefined
o64 = null;
// 5269
o62.__html = void 0;
// 5271
o64 = {};
// 5272
f81632121_474.returns.push(o64);
// 5274
o8.appendChild = f81632121_478;
// 5275
f81632121_478.returns.push(o64);
// undefined
o64 = null;
// 5276
o64 = {};
// 5277
f81632121_4.returns.push(o64);
// 5278
o64.pointerEvents = "";
// undefined
o64 = null;
// 5279
o62.parentNode = null;
// 5283
f81632121_468.returns.push(undefined);
// 5284
o63.JSBNG__onmouseover = null;
// 5289
f81632121_468.returns.push(undefined);
// 5290
o63.JSBNG__onmouseout = null;
// 5295
f81632121_468.returns.push(undefined);
// 5296
o63.JSBNG__onfocusin = void 0;
// 5301
f81632121_468.returns.push(undefined);
// 5302
o63.JSBNG__onfocusout = void 0;
// 5307
f81632121_468.returns.push(undefined);
// 5308
o63.JSBNG__onmousedown = null;
// 5310
o68.nodeName = "DIV";
// 5311
o68.__FB_TOKEN = void 0;
// 5312
// 5313
o68.getAttribute = f81632121_506;
// 5314
o68.hasAttribute = f81632121_507;
// 5316
f81632121_507.returns.push(false);
// 5317
o68.JSBNG__addEventListener = f81632121_468;
// 5319
f81632121_468.returns.push(undefined);
// 5320
o68.JSBNG__onmousedown = null;
// 5322
o64 = {};
// 5323
o63.classList = o64;
// 5325
o64.add = f81632121_602;
// 5326
f81632121_602.returns.push(undefined);
// 5329
o69 = {};
// 5330
f81632121_508.returns.push(o69);
// 5331
o69.getElementsByTagName = f81632121_502;
// 5333
o69.querySelectorAll = f81632121_504;
// 5334
o70 = {};
// 5335
f81632121_504.returns.push(o70);
// 5336
o70.length = 1;
// 5337
o71 = {};
// 5338
o70["0"] = o71;
// undefined
o70 = null;
// 5339
o71.getElementsByTagName = f81632121_502;
// 5341
o71.querySelectorAll = f81632121_504;
// 5342
o70 = {};
// 5343
f81632121_504.returns.push(o70);
// 5344
o70.length = 1;
// 5345
o72 = {};
// 5346
o70["0"] = o72;
// undefined
o70 = null;
// 5347
o72.getElementsByTagName = f81632121_502;
// 5349
o72.querySelectorAll = f81632121_504;
// undefined
o72 = null;
// 5350
o70 = {};
// 5351
f81632121_504.returns.push(o70);
// 5352
o70.length = 1;
// 5353
o72 = {};
// 5354
o70["0"] = o72;
// undefined
o70 = null;
// 5358
o70 = {};
// 5359
f81632121_504.returns.push(o70);
// 5360
o70.length = 1;
// 5361
o73 = {};
// 5362
o70["0"] = o73;
// undefined
o70 = null;
// 5363
o73.getElementsByTagName = f81632121_502;
// 5365
o73.querySelectorAll = f81632121_504;
// 5366
o70 = {};
// 5367
f81632121_504.returns.push(o70);
// 5368
o70.length = 1;
// 5369
o74 = {};
// 5370
o70["0"] = o74;
// undefined
o70 = null;
// 5371
f81632121_12.returns.push(14);
// 5372
o71.nodeName = "DIV";
// 5373
o71.__FB_TOKEN = void 0;
// 5374
// 5375
o71.getAttribute = f81632121_506;
// 5376
o71.hasAttribute = f81632121_507;
// 5378
f81632121_507.returns.push(false);
// 5379
o71.JSBNG__addEventListener = f81632121_468;
// 5381
f81632121_468.returns.push(undefined);
// 5382
o71.JSBNG__onJSBNG__scroll = void 0;
// 5384
o69.nodeName = "DIV";
// 5385
o69.__FB_TOKEN = void 0;
// 5386
// 5387
o69.getAttribute = f81632121_506;
// 5388
o69.hasAttribute = f81632121_507;
// 5390
f81632121_507.returns.push(false);
// 5391
o69.JSBNG__addEventListener = f81632121_468;
// 5393
f81632121_468.returns.push(undefined);
// 5394
o69.JSBNG__onmousemove = null;
// 5396
o73.nodeName = "DIV";
// 5397
o73.__FB_TOKEN = void 0;
// 5398
// 5399
o73.getAttribute = f81632121_506;
// 5400
o73.hasAttribute = f81632121_507;
// 5402
f81632121_507.returns.push(false);
// 5403
o73.JSBNG__addEventListener = f81632121_468;
// 5405
f81632121_468.returns.push(undefined);
// 5406
o73.JSBNG__onclick = null;
// 5411
f81632121_468.returns.push(undefined);
// 5412
o69.JSBNG__onmouseover = null;
// 5417
f81632121_468.returns.push(undefined);
// 5418
o69.JSBNG__onmouseout = null;
// 5423
f81632121_468.returns.push(undefined);
// 5424
o69.JSBNG__onfocusin = void 0;
// 5429
f81632121_468.returns.push(undefined);
// 5430
o69.JSBNG__onfocusout = void 0;
// 5435
f81632121_468.returns.push(undefined);
// 5436
o69.JSBNG__onmousedown = null;
// 5438
o74.nodeName = "DIV";
// 5439
o74.__FB_TOKEN = void 0;
// 5440
// 5441
o74.getAttribute = f81632121_506;
// 5442
o74.hasAttribute = f81632121_507;
// 5444
f81632121_507.returns.push(false);
// 5445
o74.JSBNG__addEventListener = f81632121_468;
// 5447
f81632121_468.returns.push(undefined);
// 5448
o74.JSBNG__onmousedown = null;
// 5452
o70 = {};
// 5453
f81632121_508.returns.push(o70);
// 5454
o70.getElementsByTagName = f81632121_502;
// 5456
o70.querySelectorAll = f81632121_504;
// 5457
o75 = {};
// 5458
f81632121_504.returns.push(o75);
// 5459
o75.length = 1;
// 5460
o76 = {};
// 5461
o75["0"] = o76;
// undefined
o75 = null;
// 5462
o76.getElementsByTagName = f81632121_502;
// 5464
o76.querySelectorAll = f81632121_504;
// 5465
o75 = {};
// 5466
f81632121_504.returns.push(o75);
// 5467
o75.length = 1;
// 5468
o77 = {};
// 5469
o75["0"] = o77;
// undefined
o75 = null;
// 5470
o77.getElementsByTagName = f81632121_502;
// 5472
o77.querySelectorAll = f81632121_504;
// undefined
o77 = null;
// 5473
o75 = {};
// 5474
f81632121_504.returns.push(o75);
// 5475
o75.length = 1;
// 5476
o77 = {};
// 5477
o75["0"] = o77;
// undefined
o75 = null;
// 5481
o75 = {};
// 5482
f81632121_504.returns.push(o75);
// 5483
o75.length = 1;
// 5484
o78 = {};
// 5485
o75["0"] = o78;
// undefined
o75 = null;
// 5486
o78.getElementsByTagName = f81632121_502;
// 5488
o78.querySelectorAll = f81632121_504;
// 5489
o75 = {};
// 5490
f81632121_504.returns.push(o75);
// 5491
o75.length = 1;
// 5492
o79 = {};
// 5493
o75["0"] = o79;
// undefined
o75 = null;
// 5494
f81632121_12.returns.push(15);
// 5495
o76.nodeName = "DIV";
// 5496
o76.__FB_TOKEN = void 0;
// 5497
// 5498
o76.getAttribute = f81632121_506;
// 5499
o76.hasAttribute = f81632121_507;
// 5501
f81632121_507.returns.push(false);
// 5502
o76.JSBNG__addEventListener = f81632121_468;
// 5504
f81632121_468.returns.push(undefined);
// 5505
o76.JSBNG__onJSBNG__scroll = void 0;
// 5507
o70.nodeName = "DIV";
// 5508
o70.__FB_TOKEN = void 0;
// 5509
// 5510
o70.getAttribute = f81632121_506;
// 5511
o70.hasAttribute = f81632121_507;
// 5513
f81632121_507.returns.push(false);
// 5514
o70.JSBNG__addEventListener = f81632121_468;
// 5516
f81632121_468.returns.push(undefined);
// 5517
o70.JSBNG__onmousemove = null;
// 5519
o78.nodeName = "DIV";
// 5520
o78.__FB_TOKEN = void 0;
// 5521
// 5522
o78.getAttribute = f81632121_506;
// 5523
o78.hasAttribute = f81632121_507;
// 5525
f81632121_507.returns.push(false);
// 5526
o78.JSBNG__addEventListener = f81632121_468;
// 5528
f81632121_468.returns.push(undefined);
// 5529
o78.JSBNG__onclick = null;
// 5534
f81632121_468.returns.push(undefined);
// 5535
o70.JSBNG__onmouseover = null;
// 5540
f81632121_468.returns.push(undefined);
// 5541
o70.JSBNG__onmouseout = null;
// 5546
f81632121_468.returns.push(undefined);
// 5547
o70.JSBNG__onfocusin = void 0;
// 5552
f81632121_468.returns.push(undefined);
// 5553
o70.JSBNG__onfocusout = void 0;
// 5558
f81632121_468.returns.push(undefined);
// 5559
o70.JSBNG__onmousedown = null;
// 5561
o79.nodeName = "DIV";
// 5562
o79.__FB_TOKEN = void 0;
// 5563
// 5564
o79.getAttribute = f81632121_506;
// 5565
o79.hasAttribute = f81632121_507;
// 5567
f81632121_507.returns.push(false);
// 5568
o79.JSBNG__addEventListener = f81632121_468;
// 5570
f81632121_468.returns.push(undefined);
// 5571
o79.JSBNG__onmousedown = null;
// 5573
o75 = {};
// 5574
o70.classList = o75;
// 5576
o75.add = f81632121_602;
// 5577
f81632121_602.returns.push(undefined);
// 5580
o80 = {};
// 5581
f81632121_476.returns.push(o80);
// 5582
// 5583
// 5584
o80.getElementsByTagName = f81632121_502;
// 5585
o81 = {};
// 5586
f81632121_502.returns.push(o81);
// 5587
o81.length = 0;
// undefined
o81 = null;
// 5589
o81 = {};
// 5590
o80.childNodes = o81;
// undefined
o80 = null;
// 5591
o81.nodeType = void 0;
// 5592
o81.getElementsByTagName = void 0;
// 5593
o81.__html = void 0;
// 5594
o81.mountComponentIntoNode = void 0;
// 5595
o81.classList = void 0;
// 5597
o81.className = void 0;
// 5599
// undefined
o81 = null;
// 5601
o80 = {};
// 5602
f81632121_476.returns.push(o80);
// 5603
o80.firstChild = null;
// 5605
o81 = {};
// 5606
f81632121_474.returns.push(o81);
// 5608
o80.appendChild = f81632121_478;
// 5609
f81632121_478.returns.push(o81);
// undefined
o81 = null;
// 5611
o81 = {};
// 5612
f81632121_476.returns.push(o81);
// 5613
// 5614
o81.firstChild = null;
// 5615
o80.__html = void 0;
// 5617
o82 = {};
// 5618
f81632121_474.returns.push(o82);
// 5620
o81.appendChild = f81632121_478;
// 5621
f81632121_478.returns.push(o82);
// undefined
o82 = null;
// 5623
o82 = {};
// 5624
f81632121_476.returns.push(o82);
// 5625
// 5626
o82.firstChild = null;
// 5627
o81.__html = void 0;
// undefined
o81 = null;
// 5629
o81 = {};
// 5630
f81632121_474.returns.push(o81);
// 5632
o82.appendChild = f81632121_478;
// 5633
f81632121_478.returns.push(o81);
// undefined
o81 = null;
// 5634
o81 = {};
// 5635
o82.classList = o81;
// 5637
o81.add = f81632121_602;
// undefined
o81 = null;
// 5638
f81632121_602.returns.push(undefined);
// 5639
o81 = {};
// 5640
o80.style = o81;
// undefined
o80 = null;
// 5641
// undefined
o81 = null;
// 5645
f81632121_602.returns.push(undefined);
// 5646
o82.__FB_TOKEN = void 0;
// 5647
// 5648
o82.nodeName = "DIV";
// 5649
o82.getAttribute = f81632121_506;
// 5650
o82.hasAttribute = f81632121_507;
// 5652
f81632121_507.returns.push(false);
// 5653
o82.JSBNG__addEventListener = f81632121_468;
// 5655
f81632121_468.returns.push(undefined);
// 5656
o82.JSBNG__onclick = null;
// 5661
f81632121_468.returns.push(undefined);
// 5662
o82.JSBNG__onsubmit = null;
// 5667
f81632121_468.returns.push(undefined);
// 5668
o82.JSBNG__onsuccess = void 0;
// 5673
f81632121_468.returns.push(undefined);
// 5674
o82.JSBNG__onerror = null;
// undefined
o82 = null;
// 5676
f81632121_12.returns.push(16);
// 5679
o80 = {};
// 5680
f81632121_476.returns.push(o80);
// 5681
// 5682
// 5683
o80.getElementsByTagName = f81632121_502;
// 5684
o81 = {};
// 5685
f81632121_502.returns.push(o81);
// 5686
o81.length = 0;
// undefined
o81 = null;
// 5688
o81 = {};
// 5689
o80.childNodes = o81;
// undefined
o80 = null;
// 5690
o81.nodeType = void 0;
// 5691
o81.getElementsByTagName = void 0;
// 5692
o81.__html = void 0;
// 5693
o81.mountComponentIntoNode = void 0;
// 5694
o81.classList = void 0;
// 5696
o81.className = void 0;
// 5698
// undefined
o81 = null;
// 5700
o80 = {};
// 5701
f81632121_476.returns.push(o80);
// 5702
o80.firstChild = null;
// 5704
o81 = {};
// 5705
f81632121_474.returns.push(o81);
// 5707
o80.appendChild = f81632121_478;
// 5708
f81632121_478.returns.push(o81);
// undefined
o81 = null;
// 5710
o81 = {};
// 5711
f81632121_476.returns.push(o81);
// 5712
// 5713
o81.firstChild = null;
// 5714
o80.__html = void 0;
// 5716
o82 = {};
// 5717
f81632121_474.returns.push(o82);
// 5719
o81.appendChild = f81632121_478;
// 5720
f81632121_478.returns.push(o82);
// undefined
o82 = null;
// 5722
o82 = {};
// 5723
f81632121_476.returns.push(o82);
// 5724
// 5725
o82.firstChild = null;
// 5726
o81.__html = void 0;
// undefined
o81 = null;
// 5728
o81 = {};
// 5729
f81632121_474.returns.push(o81);
// 5731
o82.appendChild = f81632121_478;
// 5732
f81632121_478.returns.push(o81);
// undefined
o81 = null;
// 5733
o81 = {};
// 5734
o82.classList = o81;
// 5736
o81.add = f81632121_602;
// undefined
o81 = null;
// 5737
f81632121_602.returns.push(undefined);
// 5738
o81 = {};
// 5739
o80.style = o81;
// undefined
o80 = null;
// 5740
// undefined
o81 = null;
// 5744
f81632121_602.returns.push(undefined);
// 5745
o82.__FB_TOKEN = void 0;
// 5746
// undefined
o82 = null;
// 5749
o80 = {};
// 5750
f81632121_476.returns.push(o80);
// 5751
// 5752
// 5753
o80.getElementsByTagName = f81632121_502;
// 5754
o81 = {};
// 5755
f81632121_502.returns.push(o81);
// 5756
o81.length = 0;
// undefined
o81 = null;
// 5758
o81 = {};
// 5759
o80.childNodes = o81;
// undefined
o80 = null;
// 5760
o81.nodeType = void 0;
// 5761
o81.getElementsByTagName = void 0;
// 5762
o81.__html = void 0;
// 5763
o81.mountComponentIntoNode = void 0;
// 5764
o81.classList = void 0;
// 5766
o81.className = void 0;
// 5768
// undefined
o81 = null;
// 5770
o80 = {};
// 5771
f81632121_476.returns.push(o80);
// 5772
o80.firstChild = null;
// 5774
o81 = {};
// 5775
f81632121_474.returns.push(o81);
// 5777
o80.appendChild = f81632121_478;
// 5778
f81632121_478.returns.push(o81);
// undefined
o81 = null;
// 5780
o81 = {};
// 5781
f81632121_476.returns.push(o81);
// 5782
// 5783
o81.firstChild = null;
// 5784
o80.__html = void 0;
// 5786
o82 = {};
// 5787
f81632121_474.returns.push(o82);
// 5789
o81.appendChild = f81632121_478;
// 5790
f81632121_478.returns.push(o82);
// undefined
o82 = null;
// 5792
o82 = {};
// 5793
f81632121_476.returns.push(o82);
// 5794
// 5795
o82.firstChild = null;
// 5796
o81.__html = void 0;
// undefined
o81 = null;
// 5798
o81 = {};
// 5799
f81632121_474.returns.push(o81);
// 5801
o82.appendChild = f81632121_478;
// 5802
f81632121_478.returns.push(o81);
// undefined
o81 = null;
// 5803
o81 = {};
// 5804
o82.classList = o81;
// 5806
o81.add = f81632121_602;
// undefined
o81 = null;
// 5807
f81632121_602.returns.push(undefined);
// 5808
o81 = {};
// 5809
o80.style = o81;
// undefined
o80 = null;
// 5810
// undefined
o81 = null;
// 5814
f81632121_602.returns.push(undefined);
// 5815
o82.__FB_TOKEN = void 0;
// 5816
// undefined
o82 = null;
// 5819
o80 = {};
// 5820
f81632121_476.returns.push(o80);
// 5821
// 5822
// 5823
o80.getElementsByTagName = f81632121_502;
// 5824
o81 = {};
// 5825
f81632121_502.returns.push(o81);
// 5826
o81.length = 0;
// undefined
o81 = null;
// 5828
o81 = {};
// 5829
o80.childNodes = o81;
// undefined
o80 = null;
// 5830
o81.nodeType = void 0;
// 5831
o81.getElementsByTagName = void 0;
// 5832
o81.__html = void 0;
// 5833
o81.mountComponentIntoNode = void 0;
// 5834
o81.classList = void 0;
// 5836
o81.className = void 0;
// 5838
// undefined
o81 = null;
// 5840
o80 = {};
// 5841
f81632121_476.returns.push(o80);
// 5842
o80.firstChild = null;
// 5844
o81 = {};
// 5845
f81632121_474.returns.push(o81);
// 5847
o80.appendChild = f81632121_478;
// 5848
f81632121_478.returns.push(o81);
// undefined
o81 = null;
// 5850
o81 = {};
// 5851
f81632121_476.returns.push(o81);
// 5852
// 5853
o81.firstChild = null;
// 5854
o80.__html = void 0;
// 5856
o82 = {};
// 5857
f81632121_474.returns.push(o82);
// 5859
o81.appendChild = f81632121_478;
// 5860
f81632121_478.returns.push(o82);
// undefined
o82 = null;
// 5862
o82 = {};
// 5863
f81632121_476.returns.push(o82);
// 5864
// 5865
o82.firstChild = null;
// 5866
o81.__html = void 0;
// undefined
o81 = null;
// 5868
o81 = {};
// 5869
f81632121_474.returns.push(o81);
// 5871
o82.appendChild = f81632121_478;
// 5872
f81632121_478.returns.push(o81);
// undefined
o81 = null;
// 5873
o81 = {};
// 5874
o82.classList = o81;
// 5876
o81.add = f81632121_602;
// undefined
o81 = null;
// 5877
f81632121_602.returns.push(undefined);
// 5878
o81 = {};
// 5879
o80.style = o81;
// undefined
o80 = null;
// 5880
// undefined
o81 = null;
// 5884
f81632121_602.returns.push(undefined);
// 5885
o82.__FB_TOKEN = void 0;
// 5886
// undefined
o82 = null;
// 5890
o30.__html = void 0;
// 5891
o30.mountComponentIntoNode = void 0;
// 5892
o30.classList = void 0;
// 5894
o30.className = void 0;
// 5896
// undefined
o30 = null;
// 5898
o30 = {};
// 5899
f81632121_476.returns.push(o30);
// 5900
o30.firstChild = null;
// 5902
o80 = {};
// 5903
f81632121_474.returns.push(o80);
// 5905
o30.appendChild = f81632121_478;
// 5906
f81632121_478.returns.push(o80);
// undefined
o80 = null;
// 5908
o80 = {};
// 5909
f81632121_476.returns.push(o80);
// 5910
// 5911
o80.firstChild = null;
// 5912
o30.__html = void 0;
// 5914
o81 = {};
// 5915
f81632121_474.returns.push(o81);
// 5917
o80.appendChild = f81632121_478;
// 5918
f81632121_478.returns.push(o81);
// undefined
o81 = null;
// 5920
o81 = {};
// 5921
f81632121_476.returns.push(o81);
// 5922
// 5923
o81.firstChild = null;
// 5924
o80.__html = void 0;
// undefined
o80 = null;
// 5926
o80 = {};
// 5927
f81632121_474.returns.push(o80);
// 5929
o81.appendChild = f81632121_478;
// 5930
f81632121_478.returns.push(o80);
// undefined
o80 = null;
// 5931
o80 = {};
// 5932
o81.classList = o80;
// 5934
o80.add = f81632121_602;
// undefined
o80 = null;
// 5935
f81632121_602.returns.push(undefined);
// 5936
o80 = {};
// 5937
o30.style = o80;
// undefined
o30 = null;
// 5938
// undefined
o80 = null;
// 5942
f81632121_602.returns.push(undefined);
// 5943
o81.__FB_TOKEN = void 0;
// 5944
// undefined
o81 = null;
// 5949
o30 = {};
// 5950
f81632121_476.returns.push(o30);
// undefined
o30 = null;
// 5952
o30 = {};
// 5953
f81632121_476.returns.push(o30);
// undefined
o30 = null;
// 5954
o30 = {};
// 5955
o80 = {};
// 5957
o30.nodeType = void 0;
// 5958
o30.length = 1;
// 5959
o30["0"] = "f7Tpb";
// 5982
o81 = {};
// 5985
o82 = {};
// 5986
o81.srcElement = o82;
// 5988
o81.target = o82;
// 5990
o82.nodeType = 1;
// 5991
o82.parentNode = o16;
// 5993
o82.getAttribute = f81632121_506;
// 5995
f81632121_506.returns.push(null);
// 5997
o16.parentNode = o8;
// 5998
o16.nodeType = 1;
// 6001
f81632121_506.returns.push(null);
// 6003
o8.parentNode = o0;
// 6004
o8.nodeType = 1;
// 6007
f81632121_506.returns.push(null);
// 6009
o0.parentNode = null;
// 6010
o0.nodeType = 9;
// 6012
o81.JSBNG__screenX = 1070;
// 6013
o81.JSBNG__screenY = 414;
// 6014
o81.altKey = false;
// 6015
o81.bubbles = true;
// 6016
o81.button = 0;
// 6017
o81.buttons = void 0;
// 6018
o81.cancelable = false;
// 6019
o81.clientX = 1002;
// 6020
o81.clientY = 249;
// 6021
o81.ctrlKey = false;
// 6022
o81.currentTarget = o0;
// 6023
o81.defaultPrevented = false;
// 6024
o81.detail = 0;
// 6025
o81.eventPhase = 3;
// 6026
o81.isTrusted = void 0;
// 6027
o81.metaKey = false;
// 6028
o81.pageX = 1002;
// 6029
o81.pageY = 408;
// 6030
o81.relatedTarget = null;
// 6031
o81.fromElement = null;
// 6034
o81.shiftKey = false;
// 6037
o81.timeStamp = 1374851215437;
// 6038
o81.type = "mousemove";
// 6039
o81.view = ow81632121;
// 6041
o81.returnValue = true;
// 6042
o81.cancelBubble = false;
// undefined
o81 = null;
// 6049
f81632121_467.returns.push(1374851215451);
// 6051
f81632121_467.returns.push(1374851215452);
// 6055
f81632121_467.returns.push(1374851215452);
// 6059
o81 = {};
// 6060
f81632121_474.returns.push(o81);
// 6062
f81632121_467.returns.push(1374851215452);
// 6065
o83 = {};
// 6066
f81632121_476.returns.push(o83);
// 6067
// 6068
// 6069
// 6070
// 6071
// 6072
o81.appendChild = f81632121_478;
// 6073
f81632121_478.returns.push(o83);
// 6075
f81632121_478.returns.push(o81);
// undefined
o81 = null;
// 6081
f81632121_467.returns.push(1374851215461);
// 6083
f81632121_467.returns.push(1374851215461);
// 6087
f81632121_467.returns.push(1374851215462);
// 6091
o81 = {};
// 6092
f81632121_474.returns.push(o81);
// 6094
f81632121_467.returns.push(1374851215462);
// 6097
o84 = {};
// 6098
f81632121_476.returns.push(o84);
// 6099
// 6100
// 6101
// 6102
// 6103
// 6104
o81.appendChild = f81632121_478;
// 6105
f81632121_478.returns.push(o84);
// 6107
f81632121_467.returns.push(1374851215463);
// 6110
o85 = {};
// 6111
f81632121_476.returns.push(o85);
// 6112
// 6113
// 6114
// 6115
// 6116
// 6118
f81632121_478.returns.push(o85);
// 6120
f81632121_478.returns.push(o81);
// undefined
o81 = null;
// 6121
o81 = {};
// 6123
f81632121_1110 = function() { return f81632121_1110.returns[f81632121_1110.inst++]; };
f81632121_1110.returns = [];
f81632121_1110.inst = 0;
// 6124
o81._needsGripper = f81632121_1110;
// 6125
f81632121_1111 = function() { return f81632121_1111.returns[f81632121_1111.inst++]; };
f81632121_1111.returns = [];
f81632121_1111.inst = 0;
// 6126
o81._throttledComputeHeights = f81632121_1111;
// 6128
f81632121_467.returns.push(1374851215477);
// 6129
o70.clientHeight = 0;
// undefined
o70 = null;
// 6130
o77.offsetHeight = 0;
// undefined
o77 = null;
// 6131
o78.offsetHeight = 0;
// undefined
o78 = null;
// 6132
f81632121_12.returns.push(17);
// 6133
f81632121_1111.returns.push(undefined);
// 6134
o81._gripperHeight = NaN;
// 6135
o81._trackHeight = 0;
// 6136
f81632121_1110.returns.push(false);
// 6137
f81632121_1112 = function() { return f81632121_1112.returns[f81632121_1112.inst++]; };
f81632121_1112.returns = [];
f81632121_1112.inst = 0;
// 6138
o81._throttledShowGripperAndShadows = f81632121_1112;
// 6140
f81632121_467.returns.push(1374851215487);
// 6142
f81632121_467.returns.push(1374851215487);
// 6143
o70 = {};
// 6144
o79.classList = o70;
// undefined
o79 = null;
// 6146
o70.add = f81632121_602;
// undefined
o70 = null;
// 6147
f81632121_602.returns.push(undefined);
// 6148
o76.scrollTop = 0;
// 6151
f81632121_1114 = function() { return f81632121_1114.returns[f81632121_1114.inst++]; };
f81632121_1114.returns = [];
f81632121_1114.inst = 0;
// 6152
o75.remove = f81632121_1114;
// undefined
o75 = null;
// 6153
f81632121_1114.returns.push(undefined);
// 6158
f81632121_1114.returns.push(undefined);
// 6159
f81632121_12.returns.push(18);
// 6160
f81632121_1112.returns.push(undefined);
// 6161
o70 = {};
// 6164
o70.srcElement = o82;
// 6166
o70.target = o82;
// 6173
f81632121_506.returns.push(null);
// 6179
f81632121_506.returns.push(null);
// 6185
f81632121_506.returns.push(null);
// 6190
o70.JSBNG__screenX = 1072;
// 6191
o70.JSBNG__screenY = 414;
// 6192
o70.altKey = false;
// 6193
o70.bubbles = true;
// 6194
o70.button = 0;
// 6195
o70.buttons = void 0;
// 6196
o70.cancelable = false;
// 6197
o70.clientX = 1004;
// 6198
o70.clientY = 249;
// 6199
o70.ctrlKey = false;
// 6200
o70.currentTarget = o0;
// 6201
o70.defaultPrevented = false;
// 6202
o70.detail = 0;
// 6203
o70.eventPhase = 3;
// 6204
o70.isTrusted = void 0;
// 6205
o70.metaKey = false;
// 6206
o70.pageX = 1004;
// 6207
o70.pageY = 408;
// 6208
o70.relatedTarget = null;
// 6209
o70.fromElement = null;
// 6212
o70.shiftKey = false;
// 6215
o70.timeStamp = 1374851215542;
// 6216
o70.type = "mousemove";
// 6217
o70.view = ow81632121;
// 6219
o70.returnValue = true;
// 6220
o70.cancelBubble = false;
// undefined
o70 = null;
// 6222
o70 = {};
// 6224
o70._needsGripper = f81632121_1110;
// 6225
f81632121_1117 = function() { return f81632121_1117.returns[f81632121_1117.inst++]; };
f81632121_1117.returns = [];
f81632121_1117.inst = 0;
// 6226
o70._throttledComputeHeights = f81632121_1117;
// 6228
f81632121_467.returns.push(1374851215544);
// 6229
o63.clientHeight = 0;
// 6230
o66.offsetHeight = 0;
// undefined
o66 = null;
// 6231
o67.offsetHeight = 0;
// undefined
o67 = null;
// 6232
f81632121_12.returns.push(19);
// 6233
f81632121_1117.returns.push(undefined);
// 6234
o70._gripperHeight = NaN;
// 6235
o70._trackHeight = 0;
// 6236
f81632121_1110.returns.push(false);
// 6237
f81632121_1118 = function() { return f81632121_1118.returns[f81632121_1118.inst++]; };
f81632121_1118.returns = [];
f81632121_1118.inst = 0;
// 6238
o70._throttledShowGripperAndShadows = f81632121_1118;
// 6240
f81632121_467.returns.push(1374851215548);
// 6242
f81632121_467.returns.push(1374851215548);
// 6243
o66 = {};
// 6244
o68.classList = o66;
// undefined
o68 = null;
// 6246
o66.add = f81632121_602;
// undefined
o66 = null;
// 6247
f81632121_602.returns.push(undefined);
// 6248
o65.scrollTop = 0;
// undefined
o65 = null;
// 6251
o64.remove = f81632121_1114;
// undefined
o64 = null;
// 6252
f81632121_1114.returns.push(undefined);
// 6257
f81632121_1114.returns.push(undefined);
// 6258
f81632121_12.returns.push(20);
// 6259
f81632121_1118.returns.push(undefined);
// 6262
f81632121_467.returns.push(1374851215549);
// 6263
o64 = {};
// 6264
f81632121_4.returns.push(o64);
// 6265
o64.height = "42px";
// undefined
o64 = null;
// 6266
o22.parentNode = o9;
// undefined
o9 = null;
// 6268
f81632121_521.returns.push(o22);
// undefined
o22 = null;
// 6270
f81632121_467.returns.push(1374851215549);
// 6271
f81632121_15.returns.push(undefined);
// 6272
o9 = {};
// 6278
f81632121_467.returns.push(1374851215550);
// 6279
f81632121_1122 = function() { return f81632121_1122.returns[f81632121_1122.inst++]; };
f81632121_1122.returns = [];
f81632121_1122.inst = 0;
// 6280
o4.pushState = f81632121_1122;
// 6281
o0.JSBNG__URL = "http://jsbngssl.www.facebook.com/LawlabeeTheWallaby";
// 6282
f81632121_1123 = function() { return f81632121_1123.returns[f81632121_1123.inst++]; };
f81632121_1123.returns = [];
f81632121_1123.inst = 0;
// 6283
o4.replaceState = f81632121_1123;
// undefined
o4 = null;
// 6284
f81632121_1123.returns.push(undefined);
// 6285
f81632121_7.returns.push(undefined);
// 6286
f81632121_1124 = function() { return f81632121_1124.returns[f81632121_1124.inst++]; };
f81632121_1124.returns = [];
f81632121_1124.inst = 0;
// 6287
ow81632121.JSBNG__onpopstate = f81632121_1124;
// 6294
f81632121_468.returns.push(undefined);
// 6295
o0.JSBNG__onsubmit = null;
// 6300
o4 = {};
// 6302
o4._needsGripper = f81632121_1110;
// 6303
f81632121_1126 = function() { return f81632121_1126.returns[f81632121_1126.inst++]; };
f81632121_1126.returns = [];
f81632121_1126.inst = 0;
// 6304
o4._throttledComputeHeights = f81632121_1126;
// 6306
f81632121_467.returns.push(1374851215552);
// 6307
o69.clientHeight = 0;
// 6308
o72.offsetHeight = 0;
// undefined
o72 = null;
// 6309
o73.offsetHeight = 0;
// undefined
o73 = null;
// 6310
f81632121_12.returns.push(21);
// 6311
f81632121_1126.returns.push(undefined);
// 6312
o4._gripperHeight = NaN;
// 6313
o4._trackHeight = 0;
// 6314
f81632121_1110.returns.push(false);
// 6315
f81632121_1127 = function() { return f81632121_1127.returns[f81632121_1127.inst++]; };
f81632121_1127.returns = [];
f81632121_1127.inst = 0;
// 6316
o4._throttledShowGripperAndShadows = f81632121_1127;
// 6318
f81632121_467.returns.push(1374851215552);
// 6320
f81632121_467.returns.push(1374851215552);
// 6321
o22 = {};
// 6322
o74.classList = o22;
// undefined
o74 = null;
// 6324
o22.add = f81632121_602;
// undefined
o22 = null;
// 6325
f81632121_602.returns.push(undefined);
// 6326
o71.scrollTop = 0;
// undefined
o71 = null;
// 6327
o22 = {};
// 6328
o69.classList = o22;
// 6330
o22.remove = f81632121_1114;
// 6331
f81632121_1114.returns.push(undefined);
// 6336
f81632121_1114.returns.push(undefined);
// 6337
f81632121_12.returns.push(22);
// 6338
f81632121_1127.returns.push(undefined);
// 6339
o64 = {};
// undefined
o64 = null;
// 6340
// 6341
// undefined
o83 = null;
// 6344
f81632121_467.returns.push(1374851215557);
// 6347
f81632121_467.returns.push(1374851215558);
// 6349
o64 = {};
// 6350
f81632121_508.returns.push(o64);
// 6352
o65 = {};
// 6353
f81632121_508.returns.push(o65);
// 6354
o66 = {};
// 6355
o65.firstChild = o66;
// 6357
o66.nodeType = 8;
// 6359
o66.nodeValue = " <div class=\"fbChatSidebar fixed_always hidden_elem\" id=\"u_0_22\"><div class=\"fbChatSidebarBody\"><div class=\"uiScrollableArea scrollableOrderedList fade\" style=\"width:205px;\" id=\"u_0_23\"><div class=\"uiScrollableAreaWrap scrollable\" aria-label=\"Scrollable region\" tabindex=\"0\"><div class=\"uiScrollableAreaBody\" style=\"width:205px;\"><div class=\"uiScrollableAreaContent\"><div id=\"u_0_29\"><ul class=\"fbChatOrderedList clearfix\"><li><div class=\"phs fcg\"><span data-jsid=\"message\">Loading...</span></div></li></ul></div></div></div></div><div class=\"uiScrollableAreaTrack invisible_elem\"><div class=\"uiScrollableAreaGripper\"></div></div></div><div class=\"fbChatTypeaheadView hidden_elem\" id=\"u_0_21\"></div></div><div class=\"fbChatSidebarMessage clearfix\"><img class=\"img\" src=\"http://jsbngssl.static.xx.fbcdn.net/rsrc.php/v2/y4/r/-PAXP-deijE.gif\" alt=\"\" width=\"1\" height=\"1\" /><div class=\"message fcg\"></div></div><table class=\"uiGrid -cx-PRIVATE-fbChatSidebarFooter__root\" cellspacing=\"0\" cellpadding=\"0\"><tbody><tr><td><div class=\"uiTypeahead uiClearableTypeahead fbChatTypeahead\" id=\"u_0_24\"><div class=\"wrap\"><script type=\"text/javascript\">try {\n    ((JSBNG_Record.scriptLoad)((\"function e31920a0c3d7535092c23ec61a3987f2d3bc254ed(event) {\\u000a\\u000a};\"), (\"s86d711f4a82117e4ddc059f9b64fc2aa5687ef8d\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    function e31920a0c3d7535092c23ec61a3987f2d3bc254ed(JSBNG__event) {\n        if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n            return ((JSBNG_Record.eventCall)((arguments.callee), (\"s86d711f4a82117e4ddc059f9b64fc2aa5687ef8d_0\"), (s86d711f4a82117e4ddc059f9b64fc2aa5687ef8d_0_instance), (this), (arguments)))\n        };\n        (null);\n    ;\n    };\n    var s86d711f4a82117e4ddc059f9b64fc2aa5687ef8d_0_instance;\n    ((s86d711f4a82117e4ddc059f9b64fc2aa5687ef8d_0_instance) = ((JSBNG_Record.eventInstance)((\"s86d711f4a82117e4ddc059f9b64fc2aa5687ef8d_0\"))));\n    ((JSBNG_Record.markFunction)((e31920a0c3d7535092c23ec61a3987f2d3bc254ed)));\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};</script><button class=\"-cx-PRIVATE-abstractButton__root -cx-PRIVATE-xuiCloseButton__root clear uiTypeaheadCloseButton -cx-PRIVATE-xuiCloseButton__medium -cx-PRIVATE-xuiCloseButton__dark\" title=\"Remove\" onclick=\"return e31920a0c3d7535092c23ec61a3987f2d3bc254ed.call(this, event);\" type=\"button\" id=\"u_0_25\">Remove</button><input type=\"hidden\" autocomplete=\"off\" class=\"hiddenInput\" /><div class=\"innerWrap\"><input type=\"text\" class=\"inputtext inputsearch textInput DOMControl_placeholder\" autocomplete=\"off\" placeholder=\"Search\" aria-autocomplete=\"list\" aria-expanded=\"false\" aria-owns=\"typeahead_list_u_0_24\" role=\"combobox\" spellcheck=\"false\" value=\"Search\" aria-label=\"Search\" id=\"u_0_26\" /></div><img class=\"throbber uiLoadingIndicatorAsync img\" src=\"http://jsbngssl.static.xx.fbcdn.net/rsrc.php/v2/yb/r/GsNJNwuI-UM.gif\" alt=\"\" width=\"16\" height=\"11\" /></div></div></td><td><div><div class=\"uiSelector inlineBlock fbChatSidebarDropdown button uiSelectorBottomUp uiSelectorRight\" id=\"u_0_27\" data-multiple=\"1\"><div class=\"uiToggle wrap\"><a data-hover=\"tooltip\" aria-label=\"Options\" class=\"uiSelectorButton uiCloseButton\" href=\"#\" role=\"button\" aria-haspopup=\"1\" rel=\"toggle\"></a><div class=\"uiSelectorMenuWrapper uiToggleFlyout\"><div role=\"menu\" class=\"uiMenu uiSelectorMenu\"><ul class=\"uiMenuInner\"><li class=\"uiMenuItem hidden_elem\" data-label=\"Chat from Desktop...\" id=\"sidebar-messenger-install-link\"><script type=\"text/javascript\">try {\n    ((JSBNG_Record.scriptLoad)((\"function ec0ed8ac6a7048f67ceaa2e8950b774f895367494(event) {\\u000a    FbdConversionTracking.logClick(\\\"chat_sidebar_gear_promo\\\");\\u000a};\"), (\"sa9759c52f0d107df16c372092cc1619071e70a16\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    function ec0ed8ac6a7048f67ceaa2e8950b774f895367494(JSBNG__event) {\n        if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n            return ((JSBNG_Record.eventCall)((arguments.callee), (\"sa9759c52f0d107df16c372092cc1619071e70a16_0\"), (sa9759c52f0d107df16c372092cc1619071e70a16_0_instance), (this), (arguments)))\n        };\n        (null);\n        (((JSBNG_Record.get)(FbdConversionTracking, (\"logClick\")))[(\"logClick\")])(\"chat_sidebar_gear_promo\");\n    };\n    var sa9759c52f0d107df16c372092cc1619071e70a16_0_instance;\n    ((sa9759c52f0d107df16c372092cc1619071e70a16_0_instance) = ((JSBNG_Record.eventInstance)((\"sa9759c52f0d107df16c372092cc1619071e70a16_0\"))));\n    ((JSBNG_Record.markFunction)((ec0ed8ac6a7048f67ceaa2e8950b774f895367494)));\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};</script><a class=\"itemAnchor\" role=\"menuitem\" tabindex=\"0\" href=\"/about/messenger?src=chat_sidebar_gear_promo\" onclick=\"return ec0ed8ac6a7048f67ceaa2e8950b774f895367494.call(this, event);\"><span class=\"itemLabel fsm\">Chat from Desktop...</span></a></li><li class=\"uiMenuSeparator hidden_elem\" id=\"sidebar-messenger-install-separator\"></li><li class=\"uiMenuItem uiMenuItemCheckbox uiSelectorOption checked\" data-label=\"Chat Sounds\"><a class=\"itemAnchor\" role=\"menuitemcheckbox\" tabindex=\"-1\" href=\"#\" aria-checked=\"true\"><span class=\"itemLabel fsm\">Chat Sounds</span></a></li><li class=\"uiMenuItem uiMenuItemCheckbox uiSelectorOption\" data-label=\"Advanced Settings...\"><a class=\"itemAnchor\" role=\"menuitemcheckbox\" tabindex=\"-1\" href=\"/ajax/chat/privacy/settings_dialog.php\" aria-checked=\"false\" rel=\"dialog\"><span class=\"itemLabel fsm\">Advanced Settings...</span></a></li><li class=\"uiMenuSeparator\"></li><li class=\"uiMenuItem uiMenuItemCheckbox uiSelectorOption fbChatGoOnlineItem\" data-label=\"Turn On Chat\"><a class=\"itemAnchor\" role=\"menuitemcheckbox\" tabindex=\"-1\" href=\"#\" aria-checked=\"false\"><span class=\"itemLabel fsm\">Turn On Chat</span></a></li><li class=\"uiMenuItem uiMenuItemCheckbox uiSelectorOption fbChatGoOfflineItem\" data-label=\"Turn Off Chat\"><a class=\"itemAnchor\" role=\"menuitemcheckbox\" tabindex=\"-1\" href=\"#\" aria-checked=\"false\"><span class=\"itemLabel fsm\">Turn Off Chat</span></a></li></ul></div></div></div><select multiple=\"1\"><option value=\"\" disabled=\"1\"></option><option value=\"sound\" selected=\"1\">Chat Sounds</option><option value=\"advanced_settings\">Advanced Settings...</option><option value=\"online\">Turn On Chat</option><option value=\"offline\">Turn Off Chat</option></select></div></div></td><td><div></div></td><td><script type=\"text/javascript\">try {\n    ((JSBNG_Record.scriptLoad)((\"function e896d84f5f56a7323d155a78f7f59a073aabbee70(event) {\\u000a    Chat.toggleSidebar();\\u000a};\"), (\"s40cde328520d54a3af91e3baeccea43d236a716c\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    function e896d84f5f56a7323d155a78f7f59a073aabbee70(JSBNG__event) {\n        if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n            return ((JSBNG_Record.eventCall)((arguments.callee), (\"s40cde328520d54a3af91e3baeccea43d236a716c_0\"), (s40cde328520d54a3af91e3baeccea43d236a716c_0_instance), (this), (arguments)))\n        };\n        (null);\n        (((JSBNG_Record.get)(Chat, (\"toggleSidebar\")))[(\"toggleSidebar\")])();\n    };\n    var s40cde328520d54a3af91e3baeccea43d236a716c_0_instance;\n    ((s40cde328520d54a3af91e3baeccea43d236a716c_0_instance) = ((JSBNG_Record.eventInstance)((\"s40cde328520d54a3af91e3baeccea43d236a716c_0\"))));\n    ((JSBNG_Record.markFunction)((e896d84f5f56a7323d155a78f7f59a073aabbee70)));\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};</script><a data-hover=\"tooltip\" aria-label=\"Hide sidebar\" data-tooltip-alignh=\"right\" class=\"toggle button\" href=\"#\" onclick=\"return e896d84f5f56a7323d155a78f7f59a073aabbee70.call(this, event);\" role=\"button\"></a></td></tr></tbody></table></div> ";
// undefined
o66 = null;
// 6360
o65.parentNode = o16;
// 6362
f81632121_521.returns.push(o65);
// undefined
o65 = null;
// 6363
// 6364
o64.getAttribute = f81632121_506;
// 6365
f81632121_506.returns.push("pagelet_sidebar");
// 6394
o65 = {};
// 6395
f81632121_476.returns.push(o65);
// 6396
// 6397
// 6398
o65.getElementsByTagName = f81632121_502;
// 6399
o66 = {};
// 6400
f81632121_502.returns.push(o66);
// 6401
o66.length = 0;
// undefined
o66 = null;
// 6403
o66 = {};
// 6404
o65.childNodes = o66;
// undefined
o65 = null;
// 6405
o66.nodeType = void 0;
// 6406
o66.getAttributeNode = void 0;
// 6407
o66.getElementsByTagName = void 0;
// 6408
o66.childNodes = void 0;
// undefined
o66 = null;
// 6412
o65 = {};
// 6413
f81632121_476.returns.push(o65);
// 6414
// 6415
// 6416
o65.getElementsByTagName = f81632121_502;
// 6417
o66 = {};
// 6418
f81632121_502.returns.push(o66);
// 6419
o66.length = 0;
// undefined
o66 = null;
// 6421
o66 = {};
// 6422
o65.childNodes = o66;
// undefined
o65 = null;
// 6423
o66.nodeType = void 0;
// 6424
o66.getAttributeNode = void 0;
// 6425
o66.getElementsByTagName = void 0;
// 6426
o66.childNodes = void 0;
// undefined
o66 = null;
// 6430
o65 = {};
// 6431
f81632121_476.returns.push(o65);
// 6432
// 6433
// 6434
o65.getElementsByTagName = f81632121_502;
// 6435
o66 = {};
// 6436
f81632121_502.returns.push(o66);
// 6437
o66.length = 0;
// undefined
o66 = null;
// 6439
o66 = {};
// 6440
o65.childNodes = o66;
// undefined
o65 = null;
// 6441
o66.nodeType = void 0;
// 6442
o66.getAttributeNode = void 0;
// 6443
o66.getElementsByTagName = void 0;
// 6444
o66.childNodes = void 0;
// undefined
o66 = null;
// 6463
o65 = {};
// 6464
f81632121_508.returns.push(o65);
// 6465
o65.getElementsByTagName = f81632121_502;
// 6467
o65.querySelectorAll = f81632121_504;
// 6468
o66 = {};
// 6469
f81632121_504.returns.push(o66);
// 6470
o66.length = 1;
// 6471
o67 = {};
// 6472
o66["0"] = o67;
// undefined
o66 = null;
// 6473
o67.getElementsByTagName = f81632121_502;
// 6475
o67.querySelectorAll = f81632121_504;
// 6476
o66 = {};
// 6477
f81632121_504.returns.push(o66);
// 6478
o66.length = 1;
// 6479
o68 = {};
// 6480
o66["0"] = o68;
// undefined
o66 = null;
// 6481
o68.getElementsByTagName = f81632121_502;
// 6483
o68.querySelectorAll = f81632121_504;
// 6484
o66 = {};
// 6485
f81632121_504.returns.push(o66);
// 6486
o66.length = 1;
// 6487
o71 = {};
// 6488
o66["0"] = o71;
// undefined
o66 = null;
// 6492
o66 = {};
// 6493
f81632121_504.returns.push(o66);
// 6494
o66.length = 1;
// 6495
o72 = {};
// 6496
o66["0"] = o72;
// undefined
o66 = null;
// 6497
o72.getElementsByTagName = f81632121_502;
// 6499
o72.querySelectorAll = f81632121_504;
// 6500
o66 = {};
// 6501
f81632121_504.returns.push(o66);
// 6502
o66.length = 1;
// 6503
o73 = {};
// 6504
o66["0"] = o73;
// undefined
o66 = null;
// 6505
f81632121_12.returns.push(23);
// 6506
o67.nodeName = "DIV";
// 6507
o67.__FB_TOKEN = void 0;
// 6508
// 6509
o67.getAttribute = f81632121_506;
// 6510
o67.hasAttribute = f81632121_507;
// 6512
f81632121_507.returns.push(false);
// 6513
o67.JSBNG__addEventListener = f81632121_468;
// 6515
f81632121_468.returns.push(undefined);
// 6516
o67.JSBNG__onJSBNG__scroll = void 0;
// 6518
o65.nodeName = "DIV";
// 6519
o65.__FB_TOKEN = void 0;
// 6520
// 6521
o65.getAttribute = f81632121_506;
// 6522
o65.hasAttribute = f81632121_507;
// 6524
f81632121_507.returns.push(false);
// 6525
o65.JSBNG__addEventListener = f81632121_468;
// 6527
f81632121_468.returns.push(undefined);
// 6528
o65.JSBNG__onmousemove = null;
// 6530
o72.nodeName = "DIV";
// 6531
o72.__FB_TOKEN = void 0;
// 6532
// 6533
o72.getAttribute = f81632121_506;
// 6534
o72.hasAttribute = f81632121_507;
// 6536
f81632121_507.returns.push(false);
// 6537
o72.JSBNG__addEventListener = f81632121_468;
// 6539
f81632121_468.returns.push(undefined);
// 6540
o72.JSBNG__onclick = null;
// 6545
f81632121_468.returns.push(undefined);
// 6546
o65.JSBNG__onmouseover = null;
// 6551
f81632121_468.returns.push(undefined);
// 6552
o65.JSBNG__onmouseout = null;
// 6557
f81632121_468.returns.push(undefined);
// 6558
o65.JSBNG__onfocusin = void 0;
// 6563
f81632121_468.returns.push(undefined);
// 6564
o65.JSBNG__onfocusout = void 0;
// 6569
f81632121_468.returns.push(undefined);
// 6570
o65.JSBNG__onmousedown = null;
// 6572
o73.nodeName = "DIV";
// 6573
o73.__FB_TOKEN = void 0;
// 6574
// 6575
o73.getAttribute = f81632121_506;
// 6576
o73.hasAttribute = f81632121_507;
// 6578
f81632121_507.returns.push(false);
// 6579
o73.JSBNG__addEventListener = f81632121_468;
// 6581
f81632121_468.returns.push(undefined);
// 6582
o73.JSBNG__onmousedown = null;
// 6584
o66 = {};
// 6585
o65.classList = o66;
// 6587
o66.add = f81632121_602;
// 6588
f81632121_602.returns.push(undefined);
// 6598
f81632121_467.returns.push(1374851215631);
// 6599
o74 = {};
// 6601
o74._needsGripper = f81632121_1110;
// 6602
f81632121_1156 = function() { return f81632121_1156.returns[f81632121_1156.inst++]; };
f81632121_1156.returns = [];
f81632121_1156.inst = 0;
// 6603
o74._throttledComputeHeights = f81632121_1156;
// 6605
f81632121_467.returns.push(1374851215632);
// 6606
o65.clientHeight = 0;
// 6607
o71.offsetHeight = 0;
// 6608
o72.offsetHeight = 0;
// undefined
o72 = null;
// 6609
f81632121_12.returns.push(24);
// 6610
f81632121_1156.returns.push(undefined);
// 6611
o74._gripperHeight = NaN;
// 6612
o74._trackHeight = 0;
// 6613
f81632121_1110.returns.push(false);
// 6614
f81632121_1157 = function() { return f81632121_1157.returns[f81632121_1157.inst++]; };
f81632121_1157.returns = [];
f81632121_1157.inst = 0;
// 6615
o74._throttledShowGripperAndShadows = f81632121_1157;
// 6617
f81632121_467.returns.push(1374851215639);
// 6619
f81632121_467.returns.push(1374851215640);
// 6620
o72 = {};
// 6621
o73.classList = o72;
// undefined
o73 = null;
// 6623
o72.add = f81632121_602;
// undefined
o72 = null;
// 6624
f81632121_602.returns.push(undefined);
// 6625
o67.scrollTop = 0;
// 6628
o66.remove = f81632121_1114;
// 6629
f81632121_1114.returns.push(undefined);
// 6634
f81632121_1114.returns.push(undefined);
// 6635
f81632121_12.returns.push(25);
// 6636
f81632121_1157.returns.push(undefined);
// 6637
o72 = {};
// undefined
o72 = null;
// 6638
// 6639
// undefined
o85 = null;
// 6645
f81632121_467.returns.push(1374851215713);
// 6647
f81632121_467.returns.push(1374851215713);
// 6654
f81632121_467.returns.push(1374851215736);
// 6656
f81632121_467.returns.push(1374851215737);
// 6663
f81632121_467.returns.push(1374851215739);
// 6665
f81632121_467.returns.push(1374851215739);
// 6672
f81632121_467.returns.push(1374851215744);
// 6674
f81632121_467.returns.push(1374851215744);
// 6681
f81632121_467.returns.push(1374851215749);
// 6683
f81632121_467.returns.push(1374851215749);
// 6690
f81632121_467.returns.push(1374851215750);
// 6692
f81632121_467.returns.push(1374851215750);
// 6699
f81632121_467.returns.push(1374851215751);
// 6701
f81632121_467.returns.push(1374851215751);
// 6708
f81632121_467.returns.push(1374851215760);
// 6710
f81632121_467.returns.push(1374851215761);
// 6716
f81632121_467.returns.push(1374851215761);
// 6718
f81632121_467.returns.push(1374851215761);
// 6720
o72 = {};
// 6722
o73 = {};
// undefined
o73 = null;
// 6723
// 6724
// undefined
o84 = null;
// 6727
f81632121_467.returns.push(1374851215773);
// 6730
f81632121_467.returns.push(1374851215774);
// 6732
o73 = {};
// 6733
f81632121_508.returns.push(o73);
// 6735
o75 = {};
// 6736
f81632121_508.returns.push(o75);
// 6737
o77 = {};
// 6738
o75.firstChild = o77;
// 6740
o77.nodeType = 8;
// 6742
o77.nodeValue = " <li class=\"fbTimelineUnit fbTimelineTwoColumn clearfix\" data-side=\"r\" data-fixed=\"1\" data-size=\"1\" id=\"tl_unit_380562705353186_recent\"><div class=\"topBorder\"></div><div class=\"timelineReportContainer\" id=\"u_0_2i\" data-gt=\"&#123;&quot;eventtime&quot;:&quot;1374851148&quot;,&quot;viewerid&quot;:&quot;100006118350059&quot;,&quot;profileownerid&quot;:&quot;1055580469&quot;,&quot;unitimpressionid&quot;:&quot;b1113c18&quot;,&quot;contentid&quot;:&quot;&quot;,&quot;timeline_unit_type&quot;:&quot;TimelineAboutReportUnit&quot;,&quot;timewindowsize&quot;:&quot;3&quot;,&quot;query_type&quot;:&quot;39&quot;,&quot;contextwindowstart&quot;:&quot;0&quot;,&quot;contextwindowend&quot;:&quot;1375340399&quot;&#125;\" role=\"complementary\"><div class=\"\"><div role=\"article\"><div class=\"-cx-PRIVATE-fbTimelineLightReportHeader__root\"><div class=\"-cx-PRIVATE-fbTimelineLightReportHeader__titlecontainer\" data-ft=\"&#123;&quot;tn&quot;:&quot;C&quot;&#125;\"><a class=\"-cx-PRIVATE-fbTimelineLightReportHeader__backgroundanchor\" href=\"http://jsbngssl.www.facebook.com/LawlabeeTheWallaby/info\"></a><div class=\"fsm fwn fcg\"><a class=\"-cx-PRIVATE-fbTimelineLightReportHeader__text -cx-PRIVATE-fbTimelineLightReportHeader__title\" href=\"http://jsbngssl.www.facebook.com/LawlabeeTheWallaby/info\">About</a></div></div></div><div class=\"timelineReportContent timelineNoSubheaderReport\"><div class=\"timelineUnitContainer -cx-PRIVATE-fbTimelineAboutUnit__root ogProfileLastUnit\" id=\"timeline_about_unit\" data-gt=\"&#123;&quot;eventtime&quot;:&quot;1374851148&quot;,&quot;viewerid&quot;:&quot;100006118350059&quot;,&quot;profileownerid&quot;:&quot;1055580469&quot;,&quot;unitimpressionid&quot;:&quot;b1113c18&quot;,&quot;contentid&quot;:&quot;&quot;,&quot;timeline_unit_type&quot;:&quot;TimelineAboutUnit&quot;,&quot;timewindowsize&quot;:&quot;3&quot;,&quot;query_type&quot;:&quot;39&quot;,&quot;contextwindowstart&quot;:&quot;0&quot;,&quot;contextwindowend&quot;:&quot;1375340399&quot;&#125;\" data-time=\"0\"><div class=\"\"><div role=\"article\"><div><ul><li data-token=\"1\" class=\"-cx-PRIVATE-fbTimelineAboutUnit__rowcontainer\" id=\"u_0_2m\"><div class=\"-cx-PRIVATE-fbTimelineAboutUnit__row\"><div class=\"clearfix\"><img class=\"-cx-PRIVATE-uiSquareImage__root -cx-PUBLIC-fbTimelineAboutUnit__rowicon -cx-PRIVATE-uiImageBlock__image -cx-PRIVATE-uiImageBlock__smallimage lfloat -cx-PRIVATE-uiSquareImage__size16 img\" src=\"http://jsbngssl.static.xx.fbcdn.net/rsrc.php/v2/yw/r/3LFVMmKZeUX.png\" alt=\"\" width=\"16\" height=\"16\" /><div class=\"-cx-PRIVATE-uiImageBlock__smallcontent -cx-PRIVATE-uiFlexibleBlock__flexiblecontent\"><ul class=\"uiList -cx-PRIVATE-fbTimelineAboutUnit__summary -cx-PRIVATE-uiList__vert\"><li class=\"-cx-PRIVATE-fbTimelineAboutUnit__title\">Works at <a class=\"profileLink\" href=\"http://jsbngssl.www.facebook.com/PurdueUniversity?ref=br_rs\" data-hovercard=\"/ajax/hovercard/page.php?id=100526673914\">Purdue University</a></li><li class=\"-cx-PRIVATE-fbTimelineAboutUnit__subtitle\">September 2008 to present</li></ul></div></div></div></li><li data-token=\"2\" class=\"-cx-PRIVATE-fbTimelineAboutUnit__rowcontainer\" id=\"u_0_2n\"><div class=\"-cx-PRIVATE-fbTimelineAboutUnit__row\"><div class=\"clearfix\"><img class=\"-cx-PRIVATE-uiSquareImage__root -cx-PUBLIC-fbTimelineAboutUnit__rowicon -cx-PRIVATE-uiImageBlock__image -cx-PRIVATE-uiImageBlock__smallimage lfloat -cx-PRIVATE-uiSquareImage__size16 img\" src=\"http://jsbngssl.static.xx.fbcdn.net/rsrc.php/v2/yb/r/wKvDSXpnqkB.png\" alt=\"\" width=\"16\" height=\"16\" /><div class=\"-cx-PRIVATE-uiImageBlock__smallcontent -cx-PRIVATE-uiFlexibleBlock__flexiblecontent\"><ul class=\"uiList -cx-PRIVATE-fbTimelineAboutUnit__summary -cx-PRIVATE-uiList__vert\"><li class=\"-cx-PRIVATE-fbTimelineAboutUnit__title\">Studies Computer Science at <a class=\"profileLink\" href=\"http://jsbngssl.www.facebook.com/PurdueUniversity?ref=br_rs\" data-hovercard=\"/ajax/hovercard/page.php?id=100526673914\">Purdue University</a></li><li class=\"-cx-PRIVATE-fbTimelineAboutUnit__subtitle\">Past: <a class=\"profileLink\" href=\"http://jsbngssl.www.facebook.com/pages/Portland-State-University/113512491992878\" data-hovercard=\"/ajax/hovercard/page.php?id=113512491992878\">Portland State University</a> and <a class=\"profileLink\" href=\"http://jsbngssl.www.facebook.com/pages/Milwaukie-High-School/109486142404101\" data-hovercard=\"/ajax/hovercard/page.php?id=109486142404101\">Milwaukie High School</a></li></ul></div></div></div></li><li data-token=\"3\" class=\"-cx-PRIVATE-fbTimelineAboutUnit__rowcontainer\" id=\"u_0_2o\"><div class=\"-cx-PRIVATE-fbTimelineAboutUnit__row\"><div class=\"clearfix\"><img class=\"-cx-PRIVATE-uiSquareImage__root -cx-PUBLIC-fbTimelineAboutUnit__rowicon -cx-PRIVATE-uiImageBlock__image -cx-PRIVATE-uiImageBlock__smallimage lfloat -cx-PRIVATE-uiSquareImage__size16 img\" src=\"http://jsbngssl.static.xx.fbcdn.net/rsrc.php/v2/yI/r/jg7lQrpjdKk.png\" alt=\"\" width=\"16\" height=\"16\" /><div class=\"-cx-PRIVATE-uiImageBlock__smallcontent -cx-PRIVATE-uiFlexibleBlock__flexiblecontent\"><ul class=\"uiList -cx-PRIVATE-fbTimelineAboutUnit__summary -cx-PRIVATE-fbTimelineAboutUnit__nosubtitle -cx-PRIVATE-uiList__vert\"><li class=\"-cx-PRIVATE-fbTimelineAboutUnit__title\">Lives in <a class=\"profileLink\" href=\"http://jsbngssl.www.facebook.com/pages/West-Lafayette-Indiana/112305682116972?ref=br_rs\" data-hovercard=\"/ajax/hovercard/page.php?id=112305682116972\">West Lafayette, Indiana</a></li></ul></div></div></div></li><li data-token=\"4\" class=\"-cx-PRIVATE-fbTimelineAboutUnit__rowcontainer\" id=\"u_0_2p\"><div class=\"-cx-PRIVATE-fbTimelineAboutUnit__row\"><div class=\"clearfix\"><img class=\"-cx-PRIVATE-uiSquareImage__root -cx-PUBLIC-fbTimelineAboutUnit__rowicon -cx-PRIVATE-uiImageBlock__image -cx-PRIVATE-uiImageBlock__smallimage lfloat -cx-PRIVATE-uiSquareImage__size16 img\" src=\"http://jsbngssl.static.xx.fbcdn.net/rsrc.php/v2/yZ/r/kBTlO7fdcY0.png\" alt=\"\" width=\"16\" height=\"16\" /><div class=\"-cx-PRIVATE-uiImageBlock__smallcontent -cx-PRIVATE-uiFlexibleBlock__flexiblecontent\"><ul class=\"uiList -cx-PRIVATE-fbTimelineAboutUnit__summary -cx-PRIVATE-fbTimelineAboutUnit__nosubtitle -cx-PRIVATE-uiList__vert\"><li class=\"-cx-PRIVATE-fbTimelineAboutUnit__title\">From <a class=\"profileLink\" href=\"http://jsbngssl.www.facebook.com/pages/Portland-Oregon/112548152092705?ref=br_rs\" data-hovercard=\"/ajax/hovercard/page.php?id=112548152092705\">Portland, Oregon</a></li></ul></div></div></div></li><li data-token=\"6\" class=\"-cx-PRIVATE-fbTimelineAboutUnit__rowcontainer\" id=\"u_0_2q\"><div class=\"-cx-PRIVATE-fbTimelineAboutUnit__row\"><div class=\"clearfix\"><img class=\"-cx-PRIVATE-uiSquareImage__root -cx-PUBLIC-fbTimelineAboutUnit__rowicon -cx-PRIVATE-uiImageBlock__image -cx-PRIVATE-uiImageBlock__smallimage lfloat -cx-PRIVATE-uiSquareImage__size16 img\" src=\"http://jsbngssl.static.xx.fbcdn.net/rsrc.php/v2/yd/r/kz0_p5XcuSq.png\" alt=\"\" width=\"16\" height=\"16\" /><div class=\"-cx-PRIVATE-uiImageBlock__smallcontent -cx-PRIVATE-uiFlexibleBlock__flexiblecontent\"><ul class=\"uiList -cx-PRIVATE-fbTimelineAboutUnit__summary -cx-PRIVATE-fbTimelineAboutUnit__nosubtitle -cx-PRIVATE-uiList__vert\"><li class=\"-cx-PRIVATE-fbTimelineAboutUnit__title\">Followed by <a href=\"http://jsbngssl.www.facebook.com/LawlabeeTheWallaby/followers\">10 people</a></li></ul></div></div></div></li></ul></div></div></div></div></div></div></div></div><i class=\"spinePointer\"></i><div class=\"bottomBorder\"></div></li><li class=\"fbTimelineUnit fbTimelineTwoColumn clearfix\" data-side=\"r\" data-fixed=\"1\" data-size=\"1\" id=\"u_0_2f\"><div class=\"topBorder\"></div><div class=\"timelineReportContainer -cx-PRIVATE-fbTimelineAppSectionEgo__photos\" id=\"u_0_2j\" data-gt=\"&#123;&quot;eventtime&quot;:&quot;1374851148&quot;,&quot;viewerid&quot;:&quot;100006118350059&quot;,&quot;profileownerid&quot;:&quot;1055580469&quot;,&quot;unitimpressionid&quot;:&quot;b1113c18&quot;,&quot;contentid&quot;:&quot;&quot;,&quot;timeline_unit_type&quot;:&quot;AppSectionEgoUnit&quot;,&quot;timewindowsize&quot;:&quot;3&quot;,&quot;query_type&quot;:&quot;39&quot;,&quot;contextwindowstart&quot;:&quot;0&quot;,&quot;contextwindowend&quot;:&quot;1375340399&quot;,&quot;timeline_og_unit_click&quot;:&quot;1&quot;,&quot;unit_id&quot;:&quot;288381481237582&quot;,&quot;event_source&quot;:&quot;38&quot;,&quot;app_id&quot;:&quot;2305272732&quot;,&quot;action_type_id&quot;:&quot;&quot;&#125;\" data-time=\"0\"><div class=\"\"><div role=\"article\"><div class=\"-cx-PRIVATE-fbTimelineLightReportHeader__root\"><div class=\"-cx-PRIVATE-fbTimelineLightReportHeader__titlecontainer\" data-ft=\"&#123;&quot;tn&quot;:&quot;C&quot;&#125;\"><a class=\"-cx-PRIVATE-fbTimelineLightReportHeader__backgroundanchor\" href=\"http://jsbngssl.www.facebook.com/LawlabeeTheWallaby/photos\"></a><div class=\"fsm fwn fcg\"><a class=\"-cx-PRIVATE-fbTimelineLightReportHeader__text -cx-PRIVATE-fbTimelineLightReportHeader__title\" href=\"http://jsbngssl.www.facebook.com/LawlabeeTheWallaby/photos\">Photos</a> · <span class=\"-cx-PRIVATE-fbTimelineLightReportHeader__text\"><a href=\"http://jsbngssl.www.facebook.com/LawlabeeTheWallaby/photos\"><span class=\"fwn fcg\">242</span></a></span></div></div></div><div id=\"pagelet_timeline_app_collection_report_5\" class=\"-cx-PRIVATE-fbTimelineAppSectionEgo__collectioncontent\"><div data-referrer=\"photos_ego\"><table class=\"uiGrid -cx-PRIVATE-fbTimelinePhotosEgo__root -cx-PRIVATE-fbTimelineAppSectionEgo__photogrid\" cellspacing=\"0\" cellpadding=\"0\"><tbody><tr><td><a href=\"http://jsbngssl.www.facebook.com/photo.php?fbid=10200453104264236&amp;set=a.1138433375108.2021456.1055580469&amp;type=1\" rel=\"theater\" ajaxify=\"http://jsbngssl.www.facebook.com/photo.php?fbid=10200453104264236&amp;set=a.1138433375108.2021456.1055580469&amp;type=1&amp;src=https%3A%2F%2Ffbcdn-sphotos-h-a.akamaihd.net%2Fhphotos-ak-prn2%2F1069167_10200453104264236_1772112196_n.jpg&amp;size=652%2C800&amp;source=8\" data-ft=\"&#123;&quot;tn&quot;:&quot;E&quot;&#125;\"><div class=\"-cx-PRIVATE-fbCroppedImage__container\" style=\"width:103px;height:103px;\"><img class=\"-cx-PRIVATE-fbCroppedImage__image img\" src=\"http://jsbngssl.fbcdn-photos-h-a.akamaihd.net/hphotos-ak-prn2/s168x128/1069167_10200453104264236_1772112196_a.jpg\" style=\"left:0px; top:0px;\" alt=\"Dammit Steam sale...\" width=\"104\" height=\"128\" /></div></a></td><td><a href=\"http://jsbngssl.www.facebook.com/photo.php?fbid=10200268473688587&amp;set=a.1468918877039.2062262.1055580469&amp;type=1\" rel=\"theater\" ajaxify=\"http://jsbngssl.www.facebook.com/photo.php?fbid=10200268473688587&amp;set=a.1468918877039.2062262.1055580469&amp;type=1&amp;src=https%3A%2F%2Ffbcdn-sphotos-b-a.akamaihd.net%2Fhphotos-ak-frc3%2F993004_10200268473688587_517108607_n.jpg&amp;size=640%2C640&amp;source=8\" data-ft=\"&#123;&quot;tn&quot;:&quot;E&quot;&#125;\"><div class=\"uiScaledImageContainer\" style=\"width:103px;height:103px;\"><img class=\"scaledImageFitWidth img\" src=\"http://jsbngssl.fbcdn-photos-b-a.akamaihd.net/hphotos-ak-frc3/p110x80/993004_10200268473688587_517108607_a.jpg\" alt=\"Gregor Richards&#039;s photo.\" width=\"103\" height=\"103\" /></div></a></td><td><a href=\"http://jsbngssl.www.facebook.com/photo.php?fbid=10200268472248551&amp;set=a.3353777797334.2140697.1055580469&amp;type=1\" rel=\"theater\" ajaxify=\"http://jsbngssl.www.facebook.com/photo.php?fbid=10200268472248551&amp;set=a.3353777797334.2140697.1055580469&amp;type=1&amp;src=https%3A%2F%2Fsphotos-a-iad.xx.fbcdn.net%2Fhphotos-ash3%2F1017486_10200268472248551_842609840_n.jpg&amp;size=851%2C315&amp;source=8\" data-ft=\"&#123;&quot;tn&quot;:&quot;E&quot;&#125;\"><div class=\"uiScaledImageContainer\" style=\"width:103px;height:103px;\"><img class=\"img\" src=\"http://jsbngssl.sphotos-a-iad.xx.fbcdn.net/hphotos-ash3/s280x280/1017486_10200268472248551_842609840_n.jpg\" style=\"left:-88px;\" alt=\"Gregor Richards&#039;s photo.\" width=\"280\" height=\"103\" /></div></a></td></tr><tr><td><a href=\"http://jsbngssl.www.facebook.com/photo.php?fbid=4986916864790&amp;set=a.1138433375108.2021456.1055580469&amp;type=1\" rel=\"theater\" ajaxify=\"http://jsbngssl.www.facebook.com/photo.php?fbid=4986916864790&amp;set=a.1138433375108.2021456.1055580469&amp;type=1&amp;src=https%3A%2F%2Ffbcdn-sphotos-h-a.akamaihd.net%2Fhphotos-ak-frc1%2F913679_4986916864790_91703778_o.jpg&amp;smallsrc=https%3A%2F%2Fsphotos-b-iad.xx.fbcdn.net%2Fhphotos-prn2%2F178992_4986916864790_91703778_n.jpg&amp;size=2048%2C1536&amp;source=8\" data-ft=\"&#123;&quot;tn&quot;:&quot;E&quot;&#125;\"><div class=\"uiScaledImageContainer\" style=\"width:103px;height:103px;\"><img class=\"img\" src=\"http://jsbngssl.sphotos-b-iad.xx.fbcdn.net/hphotos-prn2/p118x118/178992_4986916864790_91703778_n.jpg\" alt=\"Today I learned that Dr. Gorman is actually another alternate identity for Clark Kent.\" width=\"138\" height=\"103\" /></div></a></td><td><a href=\"http://jsbngssl.www.facebook.com/photo.php?fbid=4897864518537&amp;set=a.1138433375108.2021456.1055580469&amp;type=1\" rel=\"theater\" ajaxify=\"http://jsbngssl.www.facebook.com/photo.php?fbid=4897864518537&amp;set=a.1138433375108.2021456.1055580469&amp;type=1&amp;src=https%3A%2F%2Ffbcdn-sphotos-c-a.akamaihd.net%2Fhphotos-ak-frc1%2F422167_4897864518537_1503459754_n.jpg&amp;size=538%2C404&amp;source=8\" data-ft=\"&#123;&quot;tn&quot;:&quot;E&quot;&#125;\"><div class=\"uiScaledImageContainer\" style=\"width:103px;height:103px;\"><img class=\"img\" src=\"http://jsbngssl.fbcdn-sphotos-c-a.akamaihd.net/hphotos-ak-frc1/p118x118/422167_4897864518537_1503459754_n.jpg\" style=\"left:-17px;\" alt=\"No parking gais. For realsies. They&#039;ll tow your boat.\" width=\"138\" height=\"103\" /></div></a></td><td><a href=\"http://jsbngssl.www.facebook.com/photo.php?fbid=4897839437910&amp;set=a.1138433375108.2021456.1055580469&amp;type=1\" rel=\"theater\" ajaxify=\"http://jsbngssl.www.facebook.com/photo.php?fbid=4897839437910&amp;set=a.1138433375108.2021456.1055580469&amp;type=1&amp;src=https%3A%2F%2Ffbcdn-sphotos-h-a.akamaihd.net%2Fhphotos-ak-frc1%2F920971_4897839437910_1063615079_o.jpg&amp;smallsrc=https%3A%2F%2Ffbcdn-sphotos-h-a.akamaihd.net%2Fhphotos-ak-frc1%2F644616_4897839437910_1063615079_n.jpg&amp;size=2048%2C473&amp;source=8\" data-ft=\"&#123;&quot;tn&quot;:&quot;E&quot;&#125;\"><div class=\"uiScaledImageContainer\" style=\"width:103px;height:103px;\"><img class=\"img\" src=\"http://jsbngssl.fbcdn-sphotos-h-a.akamaihd.net/hphotos-ak-frc1/s480x480/644616_4897839437910_1063615079_n.jpg\" style=\"left:-173px;\" alt=\"So yeah, there&#039;s a LITTLE bit of flooding &#039;round these parts.\" width=\"450\" height=\"103\" /></div></a></td></tr><tr><td><a href=\"http://jsbngssl.www.facebook.com/photo.php?fbid=4875948970662&amp;set=a.1138433375108.2021456.1055580469&amp;type=1\" rel=\"theater\" ajaxify=\"http://jsbngssl.www.facebook.com/photo.php?fbid=4875948970662&amp;set=a.1138433375108.2021456.1055580469&amp;type=1&amp;src=https%3A%2F%2Fsphotos-b-iad.xx.fbcdn.net%2Fhphotos-ash3%2F150431_4875948970662_1470457029_n.jpg&amp;size=944%2C834&amp;source=8\" data-ft=\"&#123;&quot;tn&quot;:&quot;E&quot;&#125;\"><div class=\"-cx-PRIVATE-fbCroppedImage__container\" style=\"width:103px;height:103px;\"><img class=\"-cx-PRIVATE-fbCroppedImage__image img\" src=\"http://jsbngssl.photos-b-iad.xx.fbcdn.net/hphotos-ash3/p118x90/150431_4875948970662_1470457029_a.jpg\" style=\"left:-7px; top:0px;\" alt=\"Anyone who can spot the delightful (and delicious!) irony in this photo gets ten Internet points.\" width=\"118\" height=\"104\" /></div></a></td><td><a href=\"http://jsbngssl.www.facebook.com/photo.php?fbid=4691723285135&amp;set=a.1138433375108.2021456.1055580469&amp;type=1\" rel=\"theater\" ajaxify=\"http://jsbngssl.www.facebook.com/photo.php?fbid=4691723285135&amp;set=a.1138433375108.2021456.1055580469&amp;type=1&amp;src=https%3A%2F%2Ffbcdn-sphotos-f-a.akamaihd.net%2Fhphotos-ak-ash3%2F577358_4691723285135_528345851_n.jpg&amp;size=600%2C600&amp;source=8\" data-ft=\"&#123;&quot;tn&quot;:&quot;E&quot;&#125;\"><div class=\"uiScaledImageContainer\" style=\"width:103px;height:103px;\"><img class=\"scaledImageFitWidth img\" src=\"http://jsbngssl.fbcdn-photos-f-a.akamaihd.net/hphotos-ak-ash3/p110x80/577358_4691723285135_528345851_a.jpg\" alt=\"I, for one, blame my parents.\" width=\"103\" height=\"103\" /></div></a></td><td><a href=\"http://jsbngssl.www.facebook.com/photo.php?fbid=4441724315317&amp;set=a.1138433375108.2021456.1055580469&amp;type=1\" rel=\"theater\" ajaxify=\"http://jsbngssl.www.facebook.com/photo.php?fbid=4441724315317&amp;set=a.1138433375108.2021456.1055580469&amp;type=1&amp;src=https%3A%2F%2Ffbcdn-sphotos-g-a.akamaihd.net%2Fhphotos-ak-prn1%2F793914_4441724315317_424104454_o.jpg&amp;smallsrc=https%3A%2F%2Fsphotos-a-iad.xx.fbcdn.net%2Fhphotos-prn1%2F74137_4441724315317_424104454_n.jpg&amp;size=1024%2C1024&amp;source=8\" data-ft=\"&#123;&quot;tn&quot;:&quot;E&quot;&#125;\"><div class=\"uiScaledImageContainer\" style=\"width:103px;height:103px;\"><img class=\"scaledImageFitWidth img\" src=\"http://jsbngssl.photos-a-iad.xx.fbcdn.net/hphotos-prn1/p110x80/74137_4441724315317_424104454_a.jpg\" alt=\"Bought myself some nostalgia in the form of a watch.\" width=\"103\" height=\"103\" /></div></a></td></tr></tbody></table></div></div></div></div></div><i class=\"spinePointer\"></i><div class=\"bottomBorder\"></div></li><li class=\"fbTimelineUnit fbTimelineTwoColumn clearfix\" data-side=\"r\" data-fixed=\"1\" data-size=\"1\" id=\"u_0_2g\"><div class=\"topBorder\"></div><div class=\"timelineReportContainer -cx-PRIVATE-fbTimelineAppSectionEgo__places\" id=\"u_0_2k\" data-gt=\"&#123;&quot;eventtime&quot;:&quot;1374851148&quot;,&quot;viewerid&quot;:&quot;100006118350059&quot;,&quot;profileownerid&quot;:&quot;1055580469&quot;,&quot;unitimpressionid&quot;:&quot;b1113c18&quot;,&quot;contentid&quot;:&quot;&quot;,&quot;timeline_unit_type&quot;:&quot;AppSectionEgoUnit&quot;,&quot;timewindowsize&quot;:&quot;3&quot;,&quot;query_type&quot;:&quot;39&quot;,&quot;contextwindowstart&quot;:&quot;0&quot;,&quot;contextwindowend&quot;:&quot;1375340399&quot;,&quot;timeline_og_unit_click&quot;:&quot;1&quot;,&quot;unit_id&quot;:&quot;288381481237582&quot;,&quot;event_source&quot;:&quot;38&quot;,&quot;app_id&quot;:&quot;302324425790&quot;,&quot;action_type_id&quot;:&quot;&quot;&#125;\" data-time=\"0\"><div class=\"\"><div role=\"article\"><div class=\"-cx-PRIVATE-fbTimelineLightReportHeader__root\"><div class=\"-cx-PRIVATE-fbTimelineLightReportHeader__titlecontainer\" data-ft=\"&#123;&quot;tn&quot;:&quot;C&quot;&#125;\"><a class=\"-cx-PRIVATE-fbTimelineLightReportHeader__backgroundanchor\" href=\"http://jsbngssl.www.facebook.com/LawlabeeTheWallaby/map\"></a><div class=\"fsm fwn fcg\"><a class=\"-cx-PRIVATE-fbTimelineLightReportHeader__text -cx-PRIVATE-fbTimelineLightReportHeader__title\" href=\"http://jsbngssl.www.facebook.com/LawlabeeTheWallaby/map\">Places</a></div></div></div><div id=\"pagelet_timeline_app_collection_report_17\" class=\"-cx-PRIVATE-fbTimelineAppSectionEgo__collectioncontent\"><div class=\"-cx-PRIVATE-ogAppReport__listview\"><ul class=\"uiList -cx-PRIVATE-uiList__vert -cx-PRIVATE-uiList__mediumborder\"><li><div class=\"clearfix\"><a class=\"-cx-PRIVATE-uiImageBlock__image -cx-PRIVATE-uiImageBlock__largeimage lfloat\" href=\"http://jsbngssl.www.facebook.com/pages/Genova-Italy/106073859432101?ref=stream\" data-ft=\"&#123;&quot;tn&quot;:&quot;k&quot;&#125;\" tabindex=\"-1\" aria-hidden=\"true\" data-hovercard=\"/ajax/hovercard/page.php?id=106073859432101\"><div class=\"uiScaledImageContainer -cx-PUBLIC-fbTimelineCollectionGrid__mapimage\"><img class=\"img\" src=\"http://jsbngssl.fbexternal-a.akamaihd.net/safe_image.php?d=AQAkJs97ODg-aCVh&amp;w=180&amp;h=540&amp;url=http%3A%2F%2Fupload.wikimedia.org%2Fwikipedia%2Fcommons%2Fthumb%2Fa%2Fa7%2FCollage_Genova.jpg%2F720px-Collage_Genova.jpg&amp;fallback=hub_city&amp;prefix=d\" alt=\"\" width=\"86\" height=\"64\" itemprop=\"photo\" /></div></a><div class=\"-cx-PRIVATE-uiFlexibleBlock__flexiblecontent\"><div class=\"-cx-PRIVATE-uiInlineBlock__root -cx-PRIVATE-ogAppReport__caption\"><div class=\"-cx-PRIVATE-uiInlineBlock__root -cx-PRIVATE-uiInlineBlock__middle\" style=\"height:64px\"></div><div class=\"-cx-PRIVATE-uiInlineBlock__root -cx-PRIVATE-uiInlineBlock__middle\"><div><a href=\"http://jsbngssl.www.facebook.com/pages/Genova-Italy/106073859432101?ref=stream\" data-ft=\"&#123;&quot;tn&quot;:&quot;k&quot;&#125;\" data-hovercard=\"/ajax/hovercard/page.php?id=106073859432101\">Genova, Italy</a><span class=\"fcg\" data-ft=\"&#123;&quot;tn&quot;:&quot;l&quot;&#125;\"> — with <a href=\"http://jsbngssl.www.facebook.com/johan.ostlund.777?viewer_id=100006118350059\" data-ft=\"&#123;&quot;tn&quot;:&quot;;&quot;&#125;\" data-hovercard=\"/ajax/hovercard/user.php?id=735417817&amp;extragetparams=%7B%22directed_target_id%22%3Anull%2C%22viewer_id%22%3A100006118350059%7D\">Johan Östlund</a> and <a href=\"http://jsbngssl.www.facebook.com/supercooldave?viewer_id=100006118350059\" data-ft=\"&#123;&quot;tn&quot;:&quot;\\\\u0040&quot;&#125;\" data-hovercard=\"/ajax/hovercard/user.php?id=702266706&amp;extragetparams=%7B%22directed_target_id%22%3Anull%2C%22viewer_id%22%3A100006118350059%7D\">Dave Clarke</a>.</span></div><a class=\"uiLinkSubtle\" href=\"http://jsbngssl.www.facebook.com/photo.php?fbid=1158894366620&amp;set=a.1158828204966.2024661.1055580469&amp;type=1\"><abbr title=\"Sunday, July 12, 2009 at 12:45pm\" data-utime=\"1247427913\" class=\"timestamp\">over a year ago</abbr></a></div></div></div></div></li><li><div class=\"clearfix\"><a class=\"-cx-PRIVATE-uiImageBlock__image -cx-PRIVATE-uiImageBlock__largeimage lfloat\" href=\"http://jsbngssl.www.facebook.com/pages/Portland-Oregon/112548152092705?ref=stream\" data-ft=\"&#123;&quot;tn&quot;:&quot;k&quot;&#125;\" tabindex=\"-1\" aria-hidden=\"true\" data-hovercard=\"/ajax/hovercard/page.php?id=112548152092705\"><div class=\"uiScaledImageContainer -cx-PUBLIC-fbTimelineCollectionGrid__mapimage\"><img class=\"img\" src=\"http://jsbngssl.fbexternal-a.akamaihd.net/safe_image.php?d=AQBTwYBBb6Mi-jh0&amp;w=180&amp;h=540&amp;url=http%3A%2F%2Fupload.wikimedia.org%2Fwikipedia%2Fcommons%2Fthumb%2F2%2F29%2FPortland_Skyline-02.jpg%2F720px-Portland_Skyline-02.jpg&amp;fallback=hub_city&amp;prefix=d\" alt=\"\" width=\"96\" height=\"64\" itemprop=\"photo\" /></div></a><div class=\"-cx-PRIVATE-uiFlexibleBlock__flexiblecontent\"><div class=\"-cx-PRIVATE-uiInlineBlock__root -cx-PRIVATE-ogAppReport__caption\"><div class=\"-cx-PRIVATE-uiInlineBlock__root -cx-PRIVATE-uiInlineBlock__middle\" style=\"height:64px\"></div><div class=\"-cx-PRIVATE-uiInlineBlock__root -cx-PRIVATE-uiInlineBlock__middle\"><div><a href=\"http://jsbngssl.www.facebook.com/pages/Portland-Oregon/112548152092705?ref=stream\" data-ft=\"&#123;&quot;tn&quot;:&quot;k&quot;&#125;\" data-hovercard=\"/ajax/hovercard/page.php?id=112548152092705\">Portland, Oregon</a><span class=\"fcg\" data-ft=\"&#123;&quot;tn&quot;:&quot;l&quot;&#125;\"> — with <a href=\"http://jsbngssl.www.facebook.com/michael.a.goss?viewer_id=100006118350059\" data-ft=\"&#123;&quot;tn&quot;:&quot;;&quot;&#125;\" data-hovercard=\"/ajax/hovercard/user.php?id=10715287&amp;extragetparams=%7B%22directed_target_id%22%3Anull%2C%22viewer_id%22%3A100006118350059%7D\">Michael A Goss</a>.</span></div><a class=\"uiLinkSubtle\" href=\"http://jsbngssl.www.facebook.com/photo.php?fbid=544659356228&amp;set=a.544659151638.2212647.10715287&amp;type=1\"><abbr title=\"Monday, November 26, 2007 at 9:38pm\" data-utime=\"1196141914\" class=\"timestamp\">over a year ago</abbr></a></div></div></div></div></li></ul></div></div></div></div></div><i class=\"spinePointer\"></i><div class=\"bottomBorder\"></div></li><li class=\"fbTimelineUnit fbTimelineTwoColumn clearfix\" data-side=\"r\" data-fixed=\"1\" data-size=\"1\" id=\"u_0_2h\"><div class=\"topBorder\"></div><div class=\"timelineReportContainer\" id=\"u_0_2l\" data-gt=\"&#123;&quot;eventtime&quot;:&quot;1374851148&quot;,&quot;viewerid&quot;:&quot;100006118350059&quot;,&quot;profileownerid&quot;:&quot;1055580469&quot;,&quot;unitimpressionid&quot;:&quot;b1113c18&quot;,&quot;contentid&quot;:&quot;&quot;,&quot;timeline_unit_type&quot;:&quot;AppSectionEgoUnit&quot;,&quot;timewindowsize&quot;:&quot;3&quot;,&quot;query_type&quot;:&quot;39&quot;,&quot;contextwindowstart&quot;:&quot;0&quot;,&quot;contextwindowend&quot;:&quot;1375340399&quot;,&quot;timeline_og_unit_click&quot;:&quot;1&quot;,&quot;unit_id&quot;:&quot;288381481237582&quot;,&quot;event_source&quot;:&quot;38&quot;,&quot;app_id&quot;:&quot;2361831622&quot;,&quot;action_type_id&quot;:&quot;&quot;&#125;\" data-time=\"0\"><div class=\"\"><div role=\"article\"><div class=\"-cx-PRIVATE-fbTimelineLightReportHeader__root\"><div class=\"-cx-PRIVATE-fbTimelineLightReportHeader__titlecontainer\" data-ft=\"&#123;&quot;tn&quot;:&quot;C&quot;&#125;\"><a class=\"-cx-PRIVATE-fbTimelineLightReportHeader__backgroundanchor\" href=\"http://jsbngssl.www.facebook.com/LawlabeeTheWallaby/groups\"></a><div class=\"fsm fwn fcg\"><a class=\"-cx-PRIVATE-fbTimelineLightReportHeader__text -cx-PRIVATE-fbTimelineLightReportHeader__title\" href=\"http://jsbngssl.www.facebook.com/LawlabeeTheWallaby/groups\">Groups</a> · <span class=\"-cx-PRIVATE-fbTimelineLightReportHeader__text\"><a href=\"http://jsbngssl.www.facebook.com/LawlabeeTheWallaby/groups\"><span class=\"fwn fcg\">1</span></a></span></div></div></div><div id=\"pagelet_timeline_app_collection_report_66\" class=\"-cx-PRIVATE-fbTimelineAppSectionEgo__collectioncontent\"><div class=\"-cx-PRIVATE-ogAppReport__listview\"><ul class=\"uiList -cx-PRIVATE-uiList__vert -cx-PRIVATE-uiList__mediumborder\"><li><div class=\"clearfix\" data-ft=\"&#123;&quot;tn&quot;:&quot;l&quot;&#125;\"><div class=\"listMemberFacepileLargeCollection listMemberFacepile -cx-PRIVATE-uiImageBlock__image -cx-PRIVATE-uiImageBlock__largeimage lfloat\"><img class=\"firstImg img\" src=\"http://jsbngssl.fbcdn-profile-a.akamaihd.net/hprofile-ak-prn2/276274_1055580469_962040234_q.jpg\" alt=\"\" /><img class=\"img\" src=\"http://jsbngssl.fbcdn-profile-a.akamaihd.net/static-ak/rsrc.php/v2/yo/r/UlIqmHJn-SK.gif\" alt=\"\" /><img class=\"img\" src=\"http://jsbngssl.fbcdn-profile-a.akamaihd.net/static-ak/rsrc.php/v2/yo/r/UlIqmHJn-SK.gif\" alt=\"\" /><img class=\"lastImg img\" src=\"http://jsbngssl.fbcdn-profile-a.akamaihd.net/static-ak/rsrc.php/v2/yo/r/UlIqmHJn-SK.gif\" alt=\"\" /></div><div class=\"-cx-PRIVATE-uiFlexibleBlock__flexiblecontent\"><div class=\"-cx-PRIVATE-uiInlineBlock__root -cx-PRIVATE-ogAppReport__caption\"><div class=\"-cx-PRIVATE-uiInlineBlock__root -cx-PRIVATE-uiInlineBlock__middle\" style=\"height:64px\"></div><div class=\"-cx-PRIVATE-uiInlineBlock__root -cx-PRIVATE-uiInlineBlock__middle\"><a href=\"/groups/26418081870/\" data-hovercard=\"/ajax/hovercard/group.php?id=26418081870\">Purdue Extreme Croquet</a><div><div class=\"fcg\">1 member</div></div><span class=\"-cx-PRIVATE-fbTimelineGroupsCollection__desc\">Enjoy the civilized and gentlemanly...</span></div></div></div></div></li></ul></div></div></div></div></div><i class=\"spinePointer\"></i><div class=\"bottomBorder\"></div></li><li class=\"-cx-PUBLIC-timelineOneColMin__endmarker hidden_elem\" data-endmarker=\"recent\" data-pageindex=\"0\"></li> ";
// undefined
o77 = null;
// 6743
o75.parentNode = o16;
// 6745
f81632121_521.returns.push(o75);
// undefined
o75 = null;
// 6747
o75 = {};
// 6748
f81632121_476.returns.push(o75);
// 6749
// 6751
o77 = {};
// 6752
f81632121_474.returns.push(o77);
// 6753
o78 = {};
// undefined
fo81632121_1165_firstChild = function() { return fo81632121_1165_firstChild.returns[fo81632121_1165_firstChild.inst++]; };
fo81632121_1165_firstChild.returns = [];
fo81632121_1165_firstChild.inst = 0;
defineGetter(o75, "firstChild", fo81632121_1165_firstChild, undefined);
// undefined
o75 = null;
// undefined
fo81632121_1165_firstChild.returns.push(o78);
// 6755
o77.appendChild = f81632121_478;
// undefined
fo81632121_1165_firstChild.returns.push(o78);
// 6757
f81632121_478.returns.push(o78);
// 6758
o75 = {};
// undefined
fo81632121_1165_firstChild.returns.push(o75);
// undefined
fo81632121_1165_firstChild.returns.push(o75);
// 6762
f81632121_478.returns.push(o75);
// undefined
o75 = null;
// 6763
o75 = {};
// undefined
fo81632121_1165_firstChild.returns.push(o75);
// undefined
fo81632121_1165_firstChild.returns.push(o75);
// 6767
f81632121_478.returns.push(o75);
// undefined
o75 = null;
// 6768
o75 = {};
// undefined
fo81632121_1165_firstChild.returns.push(o75);
// undefined
fo81632121_1165_firstChild.returns.push(o75);
// 6772
f81632121_478.returns.push(o75);
// undefined
o75 = null;
// 6773
o75 = {};
// undefined
fo81632121_1165_firstChild.returns.push(o75);
// undefined
fo81632121_1165_firstChild.returns.push(o75);
// 6777
f81632121_478.returns.push(o75);
// undefined
fo81632121_1165_firstChild.returns.push(null);
// 6779
o73.appendChild = f81632121_478;
// 6780
f81632121_478.returns.push(o77);
// undefined
o77 = null;
// 6781
o73.getAttribute = f81632121_506;
// 6782
f81632121_506.returns.push("pagelet_timeline_recent_ocm");
// 6787
f81632121_467.returns.push(1374851215850);
// 6790
f81632121_467.returns.push(1374851215850);
// 6793
f81632121_467.returns.push(1374851215851);
// 6796
f81632121_467.returns.push(1374851215851);
// 6799
f81632121_467.returns.push(1374851215851);
// 6801
o77 = {};
// 6802
f81632121_508.returns.push(o77);
// 6804
o79 = {};
// 6805
f81632121_508.returns.push(o79);
// 6806
o83 = {};
// 6807
o79.firstChild = o83;
// 6809
o83.nodeType = 8;
// 6811
o83.nodeValue = " <div class=\"-cx-PRIVATE-fbTimelineStyleAds__root -cx-PRIVATE-fbTimelineStyleAds__vertical -cx-PRIVATE-fbTimelineStyleAds__offscreen\" id=\"u_0_2s\" data-referrer=\"u_0_2s\"></div> ";
// undefined
o83 = null;
// 6812
o79.parentNode = o16;
// 6814
f81632121_521.returns.push(o79);
// undefined
o79 = null;
// 6815
// 6816
o77.getAttribute = f81632121_506;
// 6817
f81632121_506.returns.push("pagelet_side_ads");
// 6821
f81632121_467.returns.push(1374851215859);
// 6826
o79 = {};
// 6827
f81632121_474.returns.push(o79);
// 6829
f81632121_478.returns.push(o79);
// undefined
o79 = null;
// 6832
f81632121_467.returns.push(1374851215860);
// 6836
o79 = {};
// 6837
f81632121_474.returns.push(o79);
// 6839
f81632121_467.returns.push(1374851215861);
// 6842
o83 = {};
// 6843
f81632121_476.returns.push(o83);
// 6844
// 6845
// 6846
// 6847
// 6848
// 6849
o79.appendChild = f81632121_478;
// 6850
f81632121_478.returns.push(o83);
// 6852
f81632121_467.returns.push(1374851215865);
// 6855
o84 = {};
// 6856
f81632121_476.returns.push(o84);
// 6857
// 6858
// 6859
// 6860
// 6861
// 6863
f81632121_478.returns.push(o84);
// 6865
f81632121_478.returns.push(o79);
// undefined
o79 = null;
// 6868
f81632121_467.returns.push(1374851215869);
// 6871
f81632121_467.returns.push(1374851215869);
// 6874
f81632121_467.returns.push(1374851215869);
// 6876
o79 = {};
// 6877
f81632121_508.returns.push(o79);
// 6879
o85 = {};
// 6880
f81632121_508.returns.push(o85);
// 6881
o86 = {};
// 6882
o85.firstChild = o86;
// 6884
o86.nodeType = 8;
// 6886
o86.nodeValue = " <div id=\"fbRequestsJewelLoading\"><div id=\"fbRequestsJewelLoadingContent\"><div class=\"uiHeader uiHeaderBottomBorder jewelHeader\"><div class=\"clearfix uiHeaderTop\"><div class=\"rfloat\"><h3 class=\"accessible_elem\">Friend Requests</h3><div class=\"uiHeaderActions fsm fwn fcg\"><a href=\"http://jsbngssl.www.facebook.com/?sk=ff\" accesskey=\"3\">Find Friends</a> · <a ajaxify=\"/ajax/settings/granular_privacy/can_friend.php\" rel=\"dialog\" href=\"#\" role=\"button\">Settings</a></div></div><div><h3 class=\"uiHeaderTitle\" aria-hidden=\"true\">Friend Requests</h3></div></div></div><img class=\"jewelLoading img\" src=\"http://jsbngssl.static.xx.fbcdn.net/rsrc.php/v2/yb/r/GsNJNwuI-UM.gif\" alt=\"\" width=\"16\" height=\"11\" /></div><div class=\"jewelFooter\"><a class=\"seeMore\" href=\"/friends/requests/\"><span>See All</span></a></div></div> ";
// undefined
o86 = null;
// 6887
o85.parentNode = o16;
// 6889
f81632121_521.returns.push(o85);
// undefined
o85 = null;
// 6890
// 6891
o79.getAttribute = f81632121_506;
// 6892
f81632121_506.returns.push(null);
// 6893
o79.setAttribute = f81632121_575;
// undefined
o79 = null;
// 6894
f81632121_575.returns.push(undefined);
// 6896
f81632121_467.returns.push(1374851215870);
// 6900
o79 = {};
// 6901
f81632121_474.returns.push(o79);
// 6903
f81632121_478.returns.push(o79);
// undefined
o79 = null;
// 6906
f81632121_467.returns.push(1374851215871);
// 6909
f81632121_467.returns.push(1374851215871);
// 6912
f81632121_467.returns.push(1374851215871);
// 6914
o79 = {};
// 6915
f81632121_508.returns.push(o79);
// 6917
o85 = {};
// 6918
f81632121_508.returns.push(o85);
// 6919
o86 = {};
// 6920
o85.firstChild = o86;
// 6922
o86.nodeType = 8;
// 6924
o86.nodeValue = " <div class=\"fbTimelineStickyHeader fixed_elem fbTimelineStickyHeaderHidden\" aria-hidden=\"true\" id=\"u_0_3s\"><div class=\"stickyHeaderWrap clearfix\"><div class=\"back\"></div><div class=\"name\"><a class=\"profileThumb\" href=\"http://jsbngssl.www.facebook.com/LawlabeeTheWallaby\"><img class=\"-cx-PRIVATE-uiSquareImage__root -cx-PRIVATE-uiSquareImage__large img\" src=\"http://jsbngssl.fbcdn-profile-a.akamaihd.net/hprofile-ak-prn2/276274_1055580469_962040234_q.jpg\" alt=\"\" /></a><span class=\"uiButtonGroup fbStickyHeaderBreadcrumb uiButtonGroupOverlay\" id=\"u_0_3r\"><span class=\"firstItem uiButtonGroupItem buttonItem\"><a class=\"nameButton uiButton uiButtonOverlay\" href=\"http://jsbngssl.www.facebook.com/LawlabeeTheWallaby\" role=\"button\"><span class=\"uiButtonText\">Gregor Richards</span></a></span><span class=\"uiButtonGroupItem selectorItem\"><div class=\"uiSelector inlineBlock pageMenu uiSelectorNormal uiSelectorDynamicLabel\"><div class=\"uiToggle wrap\"><a class=\"pageMenuButton uiSelectorButton uiButton uiButtonOverlay\" href=\"#\" role=\"button\" aria-haspopup=\"1\" data-label=\"Timeline\" data-length=\"30\" rel=\"toggle\"><span class=\"uiButtonText\">Timeline</span></a><div class=\"uiSelectorMenuWrapper uiToggleFlyout\"><div role=\"menu\" class=\"uiMenu uiSelectorMenu\"><ul class=\"uiMenuInner\"><li class=\"uiMenuItem uiMenuItemCheckbox checked\" data-label=\"Timeline\"><a class=\"itemAnchor itemWithIcon\" role=\"menuitemcheckbox\" tabindex=\"0\" href=\"http://jsbngssl.www.facebook.com/LawlabeeTheWallaby\" aria-checked=\"true\"><i class=\"mrs itemIcon img sp_at8kd9 sx_c113b7\"></i><span class=\"itemLabel fsm\">Timeline</span></a></li><li class=\"uiMenuItem uiMenuItemCheckbox\" data-label=\"About\"><a class=\"itemAnchor itemWithIcon\" role=\"menuitemcheckbox\" tabindex=\"-1\" href=\"http://jsbngssl.www.facebook.com/LawlabeeTheWallaby/about\" aria-checked=\"false\"><i class=\"mrs itemIcon img sp_4p6kmz sx_fb2987\"></i><span class=\"itemLabel fsm\">About</span></a></li><li class=\"uiMenuSeparator separator hidden_elem\"></li></ul></div></div></div></div></span><span class=\"lastItem uiButtonGroupItem selectorItem\"><div class=\"uiSelector inlineBlock sectionMenu uiSelectorNormal uiSelectorDynamicLabel\"><div class=\"uiToggle wrap\"><a class=\"uiSelectorButton uiButton uiButtonOverlay\" href=\"#\" role=\"button\" aria-haspopup=\"1\" data-length=\"30\" rel=\"toggle\"><span class=\"uiButtonText\">Recent</span></a><div class=\"uiSelectorMenuWrapper uiToggleFlyout\"><div role=\"menu\" class=\"uiMenu uiSelectorMenu\"><ul class=\"uiMenuInner\"><li class=\"uiMenuItem uiMenuItemRadio uiSelectorOption checked\" data-label=\"Recent\"><a class=\"itemAnchor\" role=\"menuitemradio\" tabindex=\"0\" href=\"#\" aria-checked=\"true\" data-key=\"recent\"><span class=\"itemLabel fsm\">Recent</span></a></li><li class=\"uiMenuItem uiMenuItemRadio uiSelectorOption\" data-label=\"2013\"><a class=\"itemAnchor\" role=\"menuitemradio\" tabindex=\"-1\" href=\"#\" aria-checked=\"false\" data-key=\"year_2013\"><span class=\"itemLabel fsm\">2013</span></a></li><li class=\"uiMenuItem uiMenuItemRadio uiSelectorOption\" data-label=\"2012\"><a class=\"itemAnchor\" role=\"menuitemradio\" tabindex=\"-1\" href=\"#\" aria-checked=\"false\" data-key=\"year_2012\"><span class=\"itemLabel fsm\">2012</span></a></li><li class=\"uiMenuItem uiMenuItemRadio uiSelectorOption\" data-label=\"2011\"><a class=\"itemAnchor\" role=\"menuitemradio\" tabindex=\"-1\" href=\"#\" aria-checked=\"false\" data-key=\"year_2011\"><span class=\"itemLabel fsm\">2011</span></a></li><li class=\"uiMenuItem uiMenuItemRadio uiSelectorOption\" data-label=\"2010\"><a class=\"itemAnchor\" role=\"menuitemradio\" tabindex=\"-1\" href=\"#\" aria-checked=\"false\" data-key=\"year_2010\"><span class=\"itemLabel fsm\">2010</span></a></li><li class=\"uiMenuItem uiMenuItemRadio uiSelectorOption\" data-label=\"2009\"><a class=\"itemAnchor\" role=\"menuitemradio\" tabindex=\"-1\" href=\"#\" aria-checked=\"false\" data-key=\"year_2009\"><span class=\"itemLabel fsm\">2009</span></a></li><li class=\"uiMenuItem uiMenuItemRadio uiSelectorOption\" data-label=\"2008\"><a class=\"itemAnchor\" role=\"menuitemradio\" tabindex=\"-1\" href=\"#\" aria-checked=\"false\" data-key=\"year_2008\"><span class=\"itemLabel fsm\">2008</span></a></li><li class=\"uiMenuItem uiMenuItemRadio uiSelectorOption\" data-label=\"Born\"><a class=\"itemAnchor\" role=\"menuitemradio\" tabindex=\"-1\" href=\"#\" aria-checked=\"false\" data-key=\"way_back\"><span class=\"itemLabel fsm\">Born</span></a></li></ul></div></div></div><select><option value=\"\"></option><option value=\"recent\" selected=\"1\">Recent</option><option value=\"year_2013\">2013</option><option value=\"year_2012\">2012</option><option value=\"year_2011\">2011</option><option value=\"year_2010\">2010</option><option value=\"year_2009\">2009</option><option value=\"year_2008\">2008</option><option value=\"way_back\">Born</option></select></div></span><span class=\"uiButtonGroupItem selectorItem hidden_elem\"><div class=\"uiSelector inlineBlock subsectionMenu uiSelectorNormal uiSelectorDynamicLabel\"><div class=\"uiToggle wrap\"><a class=\"uiSelectorButton uiButton uiButtonOverlay\" href=\"#\" role=\"button\" aria-haspopup=\"1\" data-length=\"30\" rel=\"toggle\"><span class=\"uiButtonText\">Highlights</span></a><div class=\"uiSelectorMenuWrapper uiToggleFlyout\"><div role=\"menu\" class=\"uiMenu uiSelectorMenu\"><ul class=\"uiMenuInner\"><li class=\"uiMenuItem uiMenuItemRadio uiSelectorOption highlights checked\" data-label=\"Highlights\"><a class=\"itemAnchor\" role=\"menuitemradio\" tabindex=\"0\" href=\"#\" aria-checked=\"true\"><span class=\"itemLabel fsm\">Highlights</span></a></li><li class=\"uiMenuItem uiMenuItemRadio uiSelectorOption allStories\" data-label=\"All Stories\"><a class=\"itemAnchor\" role=\"menuitemradio\" tabindex=\"-1\" href=\"#\" aria-checked=\"false\"><span class=\"itemLabel fsm\">All Stories</span></a></li><li class=\"uiMenuSeparator separator hidden_elem\"></li></ul></div></div></div><select><option value=\"\"></option><option value=\"highlights\" selected=\"1\">Highlights</option><option value=\"allStories\">All Stories</option></select></div></span></span></div><div class=\"actions\"><span class=\"uiButtonGroup fbTimelineConnectButtonGroup uiButtonGroupOverlay\" id=\"u_0_3k\"><span class=\"firstItem uiButtonGroupItem buttonItem\"><div class=\"FriendButton\" id=\"u_0_3p\"><label class=\"FriendRequestAdd addButton uiButton uiButtonOverlay uiButtonLarge\" for=\"u_0_3q\"><i class=\"mrs img sp_at8kd9 sx_aad3a2\"></i><input value=\"Add Friend\" type=\"button\" id=\"u_0_3q\" /></label><a class=\"FriendRequestOutgoing enableFriendListFlyout outgoingButton enableFriendListFlyout hidden_elem uiButton uiButtonOverlay uiButtonLarge\" href=\"#\" role=\"button\" data-profileid=\"1055580469\" data-flloc=\"sticky_header\" data-cansuggestfriends=\"false\"><i class=\"mrs img sp_at8kd9 sx_aad3a2\"></i><span class=\"uiButtonText\">Friend Request Sent</span></a></div></span><span class=\"lastItem uiButtonGroupItem buttonItem\"><span class=\"-cx-PRIVATE-uiSwapButton__root -cx-PRIVATE-fbSubscribeButton__root\"><a class=\"uiButton uiButtonOverlay uiButtonLarge\" href=\"#\" role=\"button\" ajaxify=\"/ajax/follow/follow_profile.php?profile_id=1055580469&amp;location=1\" rel=\"async-post\" id=\"u_0_3l\"><i class=\"mrs img sp_at8kd9 sx_dedf3e\"></i><span class=\"uiButtonText\">Follow</span></a><label class=\"profileFollowButton -cx-PUBLIC-uiHoverButton__root -cx-PRIVATE-uiSwapButton__secondbutton hidden_elem uiButton uiButtonOverlay uiButtonLarge\" id=\"u_0_3m\" for=\"u_0_3o\"><i class=\"mrs img sp_at8kd9 sx_d4ea38\"></i><input value=\"Following\" aria-haspopup=\"1\" data-profileid=\"1055580469\" type=\"submit\" id=\"u_0_3o\" /></label></span></span></span></div></div></div> ";
// undefined
o86 = null;
// 6925
o85.parentNode = o16;
// 6927
f81632121_521.returns.push(o85);
// undefined
o85 = null;
// 6928
// 6929
o79.getAttribute = f81632121_506;
// undefined
o79 = null;
// 6930
f81632121_506.returns.push("timeline_sticky_header");
// 6934
o79 = {};
// 6935
f81632121_476.returns.push(o79);
// 6936
// 6937
// 6938
o79.getElementsByTagName = f81632121_502;
// 6939
o85 = {};
// 6940
f81632121_502.returns.push(o85);
// 6941
o85.length = 0;
// undefined
o85 = null;
// 6943
o85 = {};
// 6944
o79.childNodes = o85;
// undefined
o79 = null;
// 6945
o85.nodeType = void 0;
// 6946
o85.getAttributeNode = void 0;
// 6947
o85.getElementsByTagName = void 0;
// 6948
o85.childNodes = void 0;
// 6967
o85.__html = void 0;
// 6968
o85.mountComponentIntoNode = void 0;
// 6969
o85.classList = void 0;
// 6971
o85.className = void 0;
// 6973
// undefined
o85 = null;
// 6975
o79 = {};
// 6976
f81632121_476.returns.push(o79);
// 6977
o79.firstChild = null;
// 6979
o85 = {};
// 6980
f81632121_474.returns.push(o85);
// 6982
o79.appendChild = f81632121_478;
// 6983
f81632121_478.returns.push(o85);
// undefined
o85 = null;
// 6985
o85 = {};
// 6986
f81632121_476.returns.push(o85);
// 6987
// 6988
o85.firstChild = null;
// 6989
o79.__html = void 0;
// 6991
o86 = {};
// 6992
f81632121_474.returns.push(o86);
// 6994
o85.appendChild = f81632121_478;
// 6995
f81632121_478.returns.push(o86);
// undefined
o86 = null;
// 6997
o86 = {};
// 6998
f81632121_476.returns.push(o86);
// 6999
// 7000
o86.firstChild = null;
// 7001
o85.__html = void 0;
// undefined
o85 = null;
// 7003
o85 = {};
// 7004
f81632121_474.returns.push(o85);
// 7006
o86.appendChild = f81632121_478;
// 7007
f81632121_478.returns.push(o85);
// undefined
o85 = null;
// 7008
o85 = {};
// 7009
o86.classList = o85;
// 7011
o85.add = f81632121_602;
// undefined
o85 = null;
// 7012
f81632121_602.returns.push(undefined);
// 7013
o85 = {};
// 7014
o79.style = o85;
// undefined
o79 = null;
// 7015
// undefined
o85 = null;
// 7019
f81632121_602.returns.push(undefined);
// 7020
o86.__FB_TOKEN = void 0;
// 7021
// undefined
o86 = null;
// 7027
f81632121_467.returns.push(1374851215902);
// 7031
o79 = {};
// 7032
f81632121_474.returns.push(o79);
// 7034
f81632121_478.returns.push(o79);
// undefined
o79 = null;
// 7037
f81632121_467.returns.push(1374851215903);
// 7040
f81632121_467.returns.push(1374851215903);
// 7043
f81632121_467.returns.push(1374851215903);
// 7045
o79 = {};
// 7046
f81632121_508.returns.push(o79);
// 7048
o85 = {};
// 7049
f81632121_508.returns.push(o85);
// 7050
o86 = {};
// 7051
o85.firstChild = o86;
// 7053
o86.nodeType = 8;
// 7055
o86.nodeValue = " <div class=\"fbTimelineTimePeriod fbTimelineTimePeriodUnexpanded\" id=\"pagelet_timeline_year_current\"><div class=\"fbTimelineSection fbTimelineCompactSection fbTimelineSectionTransparent\"><div class=\"fbTimelinePeriodPlaceholder\"><div class=\"mbm -cx-PRIVATE-fbTimelineOneColumnHeader__header sectionHeader\"><div class=\"uiHeader\"><div class=\"clearfix uiHeaderTop\"><div><h3 class=\"uiHeaderTitle\">Earlier in 2013</h3></div></div></div><div class=\"-cx-PRIVATE-fbTimelineOneColumnHeader__line\"></div></div><div class=\"loadingContainer\"><a class=\"mbm phm forceLoad\" href=\"#\" role=\"button\" id=\"u_0_3u\"><span class=\"sectionLabel fwb\" data-year=\"2013\">Show 2013</span></a></div></div></div><img class=\"ptl loadingIndicator img\" src=\"http://jsbngssl.static.xx.fbcdn.net/rsrc.php/v2/yb/r/GsNJNwuI-UM.gif\" alt=\"\" width=\"16\" height=\"11\" /></div><div class=\"fbTimelineTimePeriod fbTimelineTimePeriodUnexpanded\" id=\"pagelet_timeline_year_last\"><div class=\"fbTimelineSection fbTimelineCompactSection fbTimelineSectionTransparent\"><div class=\"fbTimelinePeriodPlaceholder\"><div class=\"mbm -cx-PRIVATE-fbTimelineOneColumnHeader__header sectionHeader\"><div class=\"uiHeader\"><div class=\"clearfix uiHeaderTop\"><div><h3 class=\"uiHeaderTitle\">2012</h3></div></div></div><div class=\"-cx-PRIVATE-fbTimelineOneColumnHeader__line\"></div></div><div class=\"loadingContainer\"><a class=\"mbm phm forceLoad\" href=\"#\" role=\"button\" id=\"u_0_3v\"><span class=\"sectionLabel fwb\" data-year=\"2012\">Show 2012</span></a></div></div></div><img class=\"ptl loadingIndicator img\" src=\"http://jsbngssl.static.xx.fbcdn.net/rsrc.php/v2/yb/r/GsNJNwuI-UM.gif\" alt=\"\" width=\"16\" height=\"11\" /></div><div class=\"fbTimelineTimePeriod fbTimelineTimePeriodUnexpanded\" id=\"pagelet_timeline_year_2011\"><div class=\"fbTimelineSection fbTimelineCompactSection fbTimelineSectionTransparent\"><div class=\"fbTimelinePeriodPlaceholder\"><div class=\"mbm -cx-PRIVATE-fbTimelineOneColumnHeader__header sectionHeader\"><div class=\"uiHeader\"><div class=\"clearfix uiHeaderTop\"><div><h3 class=\"uiHeaderTitle\">2011</h3></div></div></div><div class=\"-cx-PRIVATE-fbTimelineOneColumnHeader__line\"></div></div><div class=\"loadingContainer\"><a class=\"mbm phm forceLoad\" href=\"#\" role=\"button\" id=\"u_0_3w\"><span class=\"sectionLabel fwb\" data-year=\"2011\">Show 2011</span></a></div></div></div><img class=\"ptl loadingIndicator img\" src=\"http://jsbngssl.static.xx.fbcdn.net/rsrc.php/v2/yb/r/GsNJNwuI-UM.gif\" alt=\"\" width=\"16\" height=\"11\" /></div><div class=\"fbTimelineTimePeriod fbTimelineTimePeriodUnexpanded\" id=\"pagelet_timeline_year_2010\"><div class=\"fbTimelineSection fbTimelineCompactSection fbTimelineSectionTransparent\"><div class=\"fbTimelinePeriodPlaceholder\"><div class=\"mbm -cx-PRIVATE-fbTimelineOneColumnHeader__header sectionHeader\"><div class=\"uiHeader\"><div class=\"clearfix uiHeaderTop\"><div><h3 class=\"uiHeaderTitle\">2010</h3></div></div></div><div class=\"-cx-PRIVATE-fbTimelineOneColumnHeader__line\"></div></div><div class=\"loadingContainer\"><a class=\"mbm phm forceLoad\" href=\"#\" role=\"button\" id=\"u_0_40\"><span class=\"sectionLabel fwb\" data-year=\"2010\">Show 2010</span></a></div></div></div><img class=\"ptl loadingIndicator img\" src=\"http://jsbngssl.static.xx.fbcdn.net/rsrc.php/v2/yb/r/GsNJNwuI-UM.gif\" alt=\"\" width=\"16\" height=\"11\" /></div><div class=\"fbTimelineTimePeriod fbTimelineTimePeriodUnexpanded\" id=\"pagelet_timeline_year_2009\"><div class=\"fbTimelineSection fbTimelineCompactSection fbTimelineSectionTransparent\"><div class=\"fbTimelinePeriodPlaceholder\"><div class=\"mbm -cx-PRIVATE-fbTimelineOneColumnHeader__header sectionHeader\"><div class=\"uiHeader\"><div class=\"clearfix uiHeaderTop\"><div><h3 class=\"uiHeaderTitle\">2009</h3></div></div></div><div class=\"-cx-PRIVATE-fbTimelineOneColumnHeader__line\"></div></div><div class=\"loadingContainer\"><a class=\"mbm phm forceLoad\" href=\"#\" role=\"button\" id=\"u_0_3z\"><span class=\"sectionLabel fwb\" data-year=\"2009\">Show 2009</span></a></div></div></div><img class=\"ptl loadingIndicator img\" src=\"http://jsbngssl.static.xx.fbcdn.net/rsrc.php/v2/yb/r/GsNJNwuI-UM.gif\" alt=\"\" width=\"16\" height=\"11\" /></div><div class=\"fbTimelineTimePeriod fbTimelineTimePeriodUnexpanded\" id=\"pagelet_timeline_year_2008\"><div class=\"fbTimelineSection fbTimelineCompactSection fbTimelineSectionTransparent\"><div class=\"fbTimelinePeriodPlaceholder\"><div class=\"mbm -cx-PRIVATE-fbTimelineOneColumnHeader__header sectionHeader\"><div class=\"uiHeader\"><div class=\"clearfix uiHeaderTop\"><div><h3 class=\"uiHeaderTitle\">2008</h3></div></div></div><div class=\"-cx-PRIVATE-fbTimelineOneColumnHeader__line\"></div></div><div class=\"loadingContainer\"><a class=\"mbm phm forceLoad\" href=\"#\" role=\"button\" id=\"u_0_3x\"><span class=\"sectionLabel fwb\" data-year=\"2008\">Show 2008</span></a></div></div></div><img class=\"ptl loadingIndicator img\" src=\"http://jsbngssl.static.xx.fbcdn.net/rsrc.php/v2/yb/r/GsNJNwuI-UM.gif\" alt=\"\" width=\"16\" height=\"11\" /></div><div class=\"fbTimelineTimePeriod fbTimelineTimePeriodUnexpanded\" id=\"pagelet_timeline_wayback\"><div class=\"fbTimelineSection fbTimelineCompactSection fbTimelineSectionTransparent\"><div class=\"fbTimelinePeriodPlaceholder\"><div class=\"mbm -cx-PRIVATE-fbTimelineOneColumnHeader__header sectionHeader\"><div class=\"uiHeader\"><div class=\"clearfix uiHeaderTop\"><div><h3 class=\"uiHeaderTitle\">Born</h3></div></div></div><div class=\"-cx-PRIVATE-fbTimelineOneColumnHeader__line\"></div></div><div class=\"loadingContainer\"><a class=\"mbm phm forceLoad\" href=\"#\" role=\"button\" id=\"u_0_3y\"><span class=\"sectionLabel fwb\" data-year=\"2007\">Show 2007</span></a></div></div></div><img class=\"ptl loadingIndicator img\" src=\"http://jsbngssl.static.xx.fbcdn.net/rsrc.php/v2/yb/r/GsNJNwuI-UM.gif\" alt=\"\" width=\"16\" height=\"11\" /></div> ";
// undefined
o86 = null;
// 7056
o85.parentNode = o16;
// 7058
f81632121_521.returns.push(o85);
// undefined
o85 = null;
// 7060
o85 = {};
// 7061
f81632121_476.returns.push(o85);
// 7062
// 7064
o86 = {};
// 7065
f81632121_474.returns.push(o86);
// 7066
o87 = {};
// undefined
fo81632121_1201_firstChild = function() { return fo81632121_1201_firstChild.returns[fo81632121_1201_firstChild.inst++]; };
fo81632121_1201_firstChild.returns = [];
fo81632121_1201_firstChild.inst = 0;
defineGetter(o85, "firstChild", fo81632121_1201_firstChild, undefined);
// undefined
o85 = null;
// undefined
fo81632121_1201_firstChild.returns.push(o87);
// 7068
o86.appendChild = f81632121_478;
// undefined
fo81632121_1201_firstChild.returns.push(o87);
// 7070
f81632121_478.returns.push(o87);
// 7071
o85 = {};
// undefined
fo81632121_1201_firstChild.returns.push(o85);
// undefined
fo81632121_1201_firstChild.returns.push(o85);
// 7075
f81632121_478.returns.push(o85);
// 7076
o88 = {};
// undefined
fo81632121_1201_firstChild.returns.push(o88);
// undefined
fo81632121_1201_firstChild.returns.push(o88);
// 7080
f81632121_478.returns.push(o88);
// 7081
o89 = {};
// undefined
fo81632121_1201_firstChild.returns.push(o89);
// undefined
fo81632121_1201_firstChild.returns.push(o89);
// 7085
f81632121_478.returns.push(o89);
// 7086
o90 = {};
// undefined
fo81632121_1201_firstChild.returns.push(o90);
// undefined
fo81632121_1201_firstChild.returns.push(o90);
// 7090
f81632121_478.returns.push(o90);
// 7091
o91 = {};
// undefined
fo81632121_1201_firstChild.returns.push(o91);
// undefined
fo81632121_1201_firstChild.returns.push(o91);
// 7095
f81632121_478.returns.push(o91);
// 7096
o92 = {};
// undefined
fo81632121_1201_firstChild.returns.push(o92);
// undefined
fo81632121_1201_firstChild.returns.push(o92);
// 7100
f81632121_478.returns.push(o92);
// undefined
fo81632121_1201_firstChild.returns.push(null);
// 7102
o79.appendChild = f81632121_478;
// 7103
f81632121_478.returns.push(o86);
// undefined
o86 = null;
// 7104
o79.getAttribute = f81632121_506;
// 7105
f81632121_506.returns.push(null);
// 7106
o79.setAttribute = f81632121_575;
// undefined
o79 = null;
// 7107
f81632121_575.returns.push(undefined);
// 7143
f81632121_467.returns.push(1374851215925);
// 7147
o79 = {};
// 7148
f81632121_474.returns.push(o79);
// 7150
f81632121_478.returns.push(o79);
// undefined
o79 = null;
// 7153
f81632121_467.returns.push(1374851215926);
// 7156
f81632121_467.returns.push(1374851215926);
// 7159
f81632121_467.returns.push(1374851215926);
// 7161
o79 = {};
// 7162
f81632121_508.returns.push(o79);
// 7164
o86 = {};
// 7165
f81632121_508.returns.push(o86);
// 7166
o93 = {};
// 7167
o86.firstChild = o93;
// 7169
o93.nodeType = 8;
// 7171
o93.nodeValue = " <div class=\"fbTimelineSectionExpander fbTimelineHiddenPager stat_elem\" id=\"pagelet_timeline_recent_pager_1\"><div class=\"fbTimelineSectionExpandPager fbTimelineShowOlder\" data-gt=\"&#123;&quot;timeline_pager&quot;:&quot;1&quot;,&quot;profile_id&quot;:&quot;1055580469&quot;,&quot;page_index&quot;:&quot;1&quot;,&quot;query_type&quot;:&quot;39&quot;&#125;\" id=\"u_0_42\"><div class=\"clearfix uiMorePager stat_elem\"><a class=\"-cx-PUBLIC-timelineOneColMin__caret uiMorePagerSecondary rfloat\" href=\"#\" role=\"button\"></a><div><script type=\"text/javascript\">try {\n    ((JSBNG_Record.scriptLoad)((\"function e54abfe526a2ad0769e7f20c510b65512590a089f(event) {\\u000a    ((JSCC.get(\\\"jp1njVsiFS9h1xdp9Yi0\\\") && JSCC.get(\\\"jp1njVsiFS9h1xdp9Yi0\\\").getHandler()))();\\u000a    return false;\\u000a};\"), (\"sfa3079759067df9a19fd325724f561bebeabc7e5\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    function e54abfe526a2ad0769e7f20c510b65512590a089f(JSBNG__event) {\n        if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n            return ((JSBNG_Record.eventCall)((arguments.callee), (\"sfa3079759067df9a19fd325724f561bebeabc7e5_0\"), (sfa3079759067df9a19fd325724f561bebeabc7e5_0_instance), (this), (arguments)))\n        };\n        (null);\n        (((((JSBNG_Record.get)(JSCC, (\"get\")))[(\"get\")])(\"jp1njVsiFS9h1xdp9Yi0\") && (((JSBNG_Record.get)((((JSBNG_Record.get)(JSCC, (\"get\")))[(\"get\")])(\"jp1njVsiFS9h1xdp9Yi0\"), (\"getHandler\")))[(\"getHandler\")])()))();\n        return false;\n    };\n    var sfa3079759067df9a19fd325724f561bebeabc7e5_0_instance;\n    ((sfa3079759067df9a19fd325724f561bebeabc7e5_0_instance) = ((JSBNG_Record.eventInstance)((\"sfa3079759067df9a19fd325724f561bebeabc7e5_0\"))));\n    ((JSBNG_Record.markFunction)((e54abfe526a2ad0769e7f20c510b65512590a089f)));\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};</script><a class=\"pam uiBoxLightblue uiMorePagerPrimary\" onclick=\"return e54abfe526a2ad0769e7f20c510b65512590a089f.call(this, event);\" href=\"#\" role=\"button\">See More Recent Stories</a><span class=\"uiMorePagerLoader pam uiBoxLightblue\"><img class=\"img\" src=\"http://jsbngssl.static.xx.fbcdn.net/rsrc.php/v2/yb/r/GsNJNwuI-UM.gif\" alt=\"\" width=\"16\" height=\"11\" /></span></div></div></div></div> ";
// undefined
o93 = null;
// 7172
o86.parentNode = o16;
// 7174
f81632121_521.returns.push(o86);
// undefined
o86 = null;
// 7175
// 7176
o79.getAttribute = f81632121_506;
// 7177
f81632121_506.returns.push(null);
// 7178
o79.setAttribute = f81632121_575;
// 7179
f81632121_575.returns.push(undefined);
// 7183
f81632121_467.returns.push(1374851215936);
// 7187
o86 = {};
// 7188
f81632121_474.returns.push(o86);
// 7190
f81632121_478.returns.push(o86);
// undefined
o86 = null;
// 7193
f81632121_467.returns.push(1374851215936);
// 7196
f81632121_467.returns.push(1374851215936);
// 7199
f81632121_467.returns.push(1374851215936);
// 7201
o86 = {};
// 7202
f81632121_508.returns.push(o86);
// 7204
o93 = {};
// 7205
f81632121_508.returns.push(o93);
// 7206
o94 = {};
// 7207
o93.firstChild = o94;
// 7209
o94.nodeType = 8;
// 7211
o94.nodeValue = " <ul class=\"fbTimelineScrubber hidden_elem\" role=\"navigation\" data-gt=\"&#123;&quot;timeline_scrubber&quot;:&quot;1&quot;,&quot;profile_id&quot;:&quot;1055580469&quot;&#125;\" id=\"u_0_44\"><li data-key=\"recent\" class=\"selected\"><a href=\"/LawlabeeTheWallaby/timeline\" rel=\"ignore\">Recent</a></li><li data-key=\"year_2013\" class=\"clearfix\" data-rollup=\"2010s\" data-year=\"2013\"><a href=\"/LawlabeeTheWallaby/timeline/2013\" rel=\"ignore\" tabindex=\"-1\">2013</a><ul class=\"clearfix\"><li data-key=\"month_2013_1\"><a href=\"/LawlabeeTheWallaby/timeline/2013/1\" rel=\"ignore\">January</a></li></ul></li><li data-key=\"year_2012\" class=\"clearfix\" data-rollup=\"2010s\" data-year=\"2012\"><a href=\"/LawlabeeTheWallaby/timeline/2012\" rel=\"ignore\" tabindex=\"-1\">2012</a><ul class=\"clearfix\"><li data-key=\"month_2012_12\"><a href=\"/LawlabeeTheWallaby/timeline/2012/12\" rel=\"ignore\">December</a></li><li data-key=\"month_2012_11\"><a href=\"/LawlabeeTheWallaby/timeline/2012/11\" rel=\"ignore\">November</a></li><li data-key=\"month_2012_10\"><a href=\"/LawlabeeTheWallaby/timeline/2012/10\" rel=\"ignore\">October</a></li><li data-key=\"month_2012_9\"><a href=\"/LawlabeeTheWallaby/timeline/2012/9\" rel=\"ignore\">September</a></li><li data-key=\"month_2012_8\"><a href=\"/LawlabeeTheWallaby/timeline/2012/8\" rel=\"ignore\">August</a></li><li data-key=\"month_2012_7\"><a href=\"/LawlabeeTheWallaby/timeline/2012/7\" rel=\"ignore\">July</a></li><li data-key=\"month_2012_6\"><a href=\"/LawlabeeTheWallaby/timeline/2012/6\" rel=\"ignore\">June</a></li><li data-key=\"month_2012_5\"><a href=\"/LawlabeeTheWallaby/timeline/2012/5\" rel=\"ignore\">May</a></li><li data-key=\"month_2012_4\"><a href=\"/LawlabeeTheWallaby/timeline/2012/4\" rel=\"ignore\">April</a></li><li data-key=\"month_2012_3\"><a href=\"/LawlabeeTheWallaby/timeline/2012/3\" rel=\"ignore\">March</a></li><li data-key=\"month_2012_2\"><a href=\"/LawlabeeTheWallaby/timeline/2012/2\" rel=\"ignore\">February</a></li><li data-key=\"month_2012_1\"><a href=\"/LawlabeeTheWallaby/timeline/2012/1\" rel=\"ignore\">January</a></li></ul></li><li data-key=\"year_2011\" class=\"clearfix\" data-rollup=\"2010s\" data-year=\"2011\"><a href=\"/LawlabeeTheWallaby/timeline/2011\" rel=\"ignore\" tabindex=\"-1\">2011</a><ul class=\"clearfix\"><li data-key=\"month_2011_12\"><a href=\"/LawlabeeTheWallaby/timeline/2011/12\" rel=\"ignore\">December</a></li><li data-key=\"month_2011_11\"><a href=\"/LawlabeeTheWallaby/timeline/2011/11\" rel=\"ignore\">November</a></li><li data-key=\"month_2011_10\"><a href=\"/LawlabeeTheWallaby/timeline/2011/10\" rel=\"ignore\">October</a></li><li data-key=\"month_2011_9\"><a href=\"/LawlabeeTheWallaby/timeline/2011/9\" rel=\"ignore\">September</a></li><li data-key=\"month_2011_8\"><a href=\"/LawlabeeTheWallaby/timeline/2011/8\" rel=\"ignore\">August</a></li><li data-key=\"month_2011_7\"><a href=\"/LawlabeeTheWallaby/timeline/2011/7\" rel=\"ignore\">July</a></li><li data-key=\"month_2011_6\"><a href=\"/LawlabeeTheWallaby/timeline/2011/6\" rel=\"ignore\">June</a></li><li data-key=\"month_2011_5\"><a href=\"/LawlabeeTheWallaby/timeline/2011/5\" rel=\"ignore\">May</a></li><li data-key=\"month_2011_4\"><a href=\"/LawlabeeTheWallaby/timeline/2011/4\" rel=\"ignore\">April</a></li><li data-key=\"month_2011_3\"><a href=\"/LawlabeeTheWallaby/timeline/2011/3\" rel=\"ignore\">March</a></li><li data-key=\"month_2011_2\"><a href=\"/LawlabeeTheWallaby/timeline/2011/2\" rel=\"ignore\">February</a></li><li data-key=\"month_2011_1\"><a href=\"/LawlabeeTheWallaby/timeline/2011/1\" rel=\"ignore\">January</a></li></ul></li><li data-key=\"year_2010\" class=\"clearfix\" data-rollup=\"2010s\" data-year=\"2010\"><a href=\"/LawlabeeTheWallaby/timeline/2010\" rel=\"ignore\" tabindex=\"-1\">2010</a><ul class=\"clearfix\"><li data-key=\"month_2010_12\"><a href=\"/LawlabeeTheWallaby/timeline/2010/12\" rel=\"ignore\">December</a></li><li data-key=\"month_2010_11\"><a href=\"/LawlabeeTheWallaby/timeline/2010/11\" rel=\"ignore\">November</a></li><li data-key=\"month_2010_10\"><a href=\"/LawlabeeTheWallaby/timeline/2010/10\" rel=\"ignore\">October</a></li><li data-key=\"month_2010_9\"><a href=\"/LawlabeeTheWallaby/timeline/2010/9\" rel=\"ignore\">September</a></li><li data-key=\"month_2010_8\"><a href=\"/LawlabeeTheWallaby/timeline/2010/8\" rel=\"ignore\">August</a></li><li data-key=\"month_2010_7\"><a href=\"/LawlabeeTheWallaby/timeline/2010/7\" rel=\"ignore\">July</a></li><li data-key=\"month_2010_6\"><a href=\"/LawlabeeTheWallaby/timeline/2010/6\" rel=\"ignore\">June</a></li><li data-key=\"month_2010_5\"><a href=\"/LawlabeeTheWallaby/timeline/2010/5\" rel=\"ignore\">May</a></li><li data-key=\"month_2010_4\"><a href=\"/LawlabeeTheWallaby/timeline/2010/4\" rel=\"ignore\">April</a></li><li data-key=\"month_2010_3\"><a href=\"/LawlabeeTheWallaby/timeline/2010/3\" rel=\"ignore\">March</a></li><li data-key=\"month_2010_2\"><a href=\"/LawlabeeTheWallaby/timeline/2010/2\" rel=\"ignore\">February</a></li><li data-key=\"month_2010_1\"><a href=\"/LawlabeeTheWallaby/timeline/2010/1\" rel=\"ignore\">January</a></li></ul></li><li data-key=\"year_2009\" class=\"clearfix\" data-rollup=\"2000s\" data-year=\"2009\"><a href=\"/LawlabeeTheWallaby/timeline/2009\" rel=\"ignore\" tabindex=\"-1\">2009</a><ul class=\"clearfix\"><li data-key=\"month_2009_12\"><a href=\"/LawlabeeTheWallaby/timeline/2009/12\" rel=\"ignore\">December</a></li><li data-key=\"month_2009_11\"><a href=\"/LawlabeeTheWallaby/timeline/2009/11\" rel=\"ignore\">November</a></li><li data-key=\"month_2009_10\"><a href=\"/LawlabeeTheWallaby/timeline/2009/10\" rel=\"ignore\">October</a></li><li data-key=\"month_2009_9\"><a href=\"/LawlabeeTheWallaby/timeline/2009/9\" rel=\"ignore\">September</a></li><li data-key=\"month_2009_8\"><a href=\"/LawlabeeTheWallaby/timeline/2009/8\" rel=\"ignore\">August</a></li><li data-key=\"month_2009_7\"><a href=\"/LawlabeeTheWallaby/timeline/2009/7\" rel=\"ignore\">July</a></li><li data-key=\"month_2009_6\"><a href=\"/LawlabeeTheWallaby/timeline/2009/6\" rel=\"ignore\">June</a></li><li data-key=\"month_2009_5\"><a href=\"/LawlabeeTheWallaby/timeline/2009/5\" rel=\"ignore\">May</a></li><li data-key=\"month_2009_4\"><a href=\"/LawlabeeTheWallaby/timeline/2009/4\" rel=\"ignore\">April</a></li><li data-key=\"month_2009_3\"><a href=\"/LawlabeeTheWallaby/timeline/2009/3\" rel=\"ignore\">March</a></li><li data-key=\"month_2009_2\"><a href=\"/LawlabeeTheWallaby/timeline/2009/2\" rel=\"ignore\">February</a></li><li data-key=\"month_2009_1\"><a href=\"/LawlabeeTheWallaby/timeline/2009/1\" rel=\"ignore\">January</a></li></ul></li><li data-key=\"year_2008\" class=\"clearfix\" data-rollup=\"2000s\" data-year=\"2008\"><a href=\"/LawlabeeTheWallaby/timeline/2008\" rel=\"ignore\" tabindex=\"-1\">2008</a><ul class=\"clearfix\"><li data-key=\"month_2008_12\"><a href=\"/LawlabeeTheWallaby/timeline/2008/12\" rel=\"ignore\">December</a></li><li data-key=\"month_2008_11\"><a href=\"/LawlabeeTheWallaby/timeline/2008/11\" rel=\"ignore\">November</a></li><li data-key=\"month_2008_10\"><a href=\"/LawlabeeTheWallaby/timeline/2008/10\" rel=\"ignore\">October</a></li><li data-key=\"month_2008_9\"><a href=\"/LawlabeeTheWallaby/timeline/2008/9\" rel=\"ignore\">September</a></li><li data-key=\"month_2008_8\"><a href=\"/LawlabeeTheWallaby/timeline/2008/8\" rel=\"ignore\">August</a></li><li data-key=\"month_2008_7\"><a href=\"/LawlabeeTheWallaby/timeline/2008/7\" rel=\"ignore\">July</a></li><li data-key=\"month_2008_6\"><a href=\"/LawlabeeTheWallaby/timeline/2008/6\" rel=\"ignore\">June</a></li><li data-key=\"month_2008_5\"><a href=\"/LawlabeeTheWallaby/timeline/2008/5\" rel=\"ignore\">May</a></li><li data-key=\"month_2008_4\"><a href=\"/LawlabeeTheWallaby/timeline/2008/4\" rel=\"ignore\">April</a></li><li data-key=\"month_2008_3\"><a href=\"/LawlabeeTheWallaby/timeline/2008/3\" rel=\"ignore\">March</a></li><li data-key=\"month_2008_2\"><a href=\"/LawlabeeTheWallaby/timeline/2008/2\" rel=\"ignore\">February</a></li><li data-key=\"month_2008_1\"><a href=\"/LawlabeeTheWallaby/timeline/2008/1\" rel=\"ignore\">January</a></li></ul></li><li data-key=\"way_back\"><a href=\"/LawlabeeTheWallaby/timeline#way_back\" rel=\"ignore\" tabindex=\"-1\">Born</a></li></ul> ";
// undefined
o94 = null;
// 7212
o93.parentNode = o16;
// 7214
f81632121_521.returns.push(o93);
// undefined
o93 = null;
// 7216
o93 = {};
// 7217
f81632121_476.returns.push(o93);
// 7218
// 7220
o94 = {};
// 7221
f81632121_474.returns.push(o94);
// 7222
o95 = {};
// undefined
fo81632121_1218_firstChild = function() { return fo81632121_1218_firstChild.returns[fo81632121_1218_firstChild.inst++]; };
fo81632121_1218_firstChild.returns = [];
fo81632121_1218_firstChild.inst = 0;
defineGetter(o93, "firstChild", fo81632121_1218_firstChild, undefined);
// undefined
o93 = null;
// undefined
fo81632121_1218_firstChild.returns.push(o95);
// 7224
o94.appendChild = f81632121_478;
// undefined
fo81632121_1218_firstChild.returns.push(o95);
// 7226
f81632121_478.returns.push(o95);
// undefined
fo81632121_1218_firstChild.returns.push(null);
// 7228
o86.appendChild = f81632121_478;
// 7229
f81632121_478.returns.push(o94);
// undefined
o94 = null;
// 7230
o86.getAttribute = f81632121_506;
// 7231
f81632121_506.returns.push(null);
// 7232
o86.setAttribute = f81632121_575;
// 7233
f81632121_575.returns.push(undefined);
// 7235
f81632121_467.returns.push(1374851215953);
// 7239
o93 = {};
// 7240
f81632121_474.returns.push(o93);
// 7242
f81632121_478.returns.push(o93);
// undefined
o93 = null;
// 7245
f81632121_467.returns.push(1374851215954);
// 7248
f81632121_467.returns.push(1374851215954);
// 7251
f81632121_467.returns.push(1374851215954);
// 7253
o93 = {};
// 7254
f81632121_508.returns.push(o93);
// 7256
o94 = {};
// 7257
f81632121_508.returns.push(o94);
// 7258
o96 = {};
// 7259
o94.firstChild = o96;
// 7261
o96.nodeType = 8;
// 7263
o96.nodeValue = " <div class=\"ego_column\"><div class=\"ego_section\" id=\"u_0_46\"><div class=\"uiHeader uiHeaderTopBorder mbs uiSideHeader\"><div class=\"clearfix uiHeaderTop\"><div class=\"rfloat\"><h6 class=\"accessible_elem\"><a href=\"/campaign/landing.php?placement=egot&amp;campaign_id=366925476690229&amp;extra_1=auto\"><span class=\"adsCategoryTitleLink\">Sponsored</span></a></h6><a class=\"uiHeaderActions\" href=\"/ads/adboard/?type=normal\">See All</a></div><div><h6 class=\"uiHeaderTitle\" aria-hidden=\"true\"><a href=\"/campaign/landing.php?placement=egot&amp;campaign_id=366925476690229&amp;extra_1=auto\"><span class=\"adsCategoryTitleLink\">Sponsored</span></a><a href=\"/campaign/landing.php?placement=egot&amp;campaign_id=366925476690229&amp;extra_1=auto\"><i class=\"mls adsCategoryIcon img sp_3yt8ar sx_06ab6d\"></i></a></h6></div></div></div><div class=\"ego_unit_container\"><div class=\"ego_unit\" data-ego-fbid=\"6011858202131\"><div class=\"-cx-PUBLIC-fbAdUnit__root\" data-ad=\"&#123;&quot;adid&quot;:6011858202131,&quot;segment&quot;:&quot;market&quot;&#125;\" id=\"6011858202131-id_51f2904c3d16d9b66803454\"><div class=\"-cx-PRIVATE-fbEmu__root -cx-PRIVATE-fbEmuEgo__unit\"><div class=\"uiSelector inlineBlock emu_x emuEventfad_hide -cx-PUBLIC-fbEmu__link uiSelectorRight\"><div class=\"uiToggle wrap\"><a class=\"uiSelectorButton uiCloseButton uiCloseButtonSmall\" href=\"#\" role=\"button\" title=\"About Facebook Ads\" rel=\"toggle\" ajaxify=\"/ajax/emu/end.php?eid=AQKeJQRxXzUhxhbYGaYgYDYhc3hQ30O_gQTSLytMewtlgvobJQH5MuaQJp4_fbqlG5W0Tung-9ZDLu-ztha3uNKKYrj85XEwPZJe-GO5gSUpcbVv7zETufLCcsIh674v1O83EtmtVxQup-\\-\\XRKCr8pDY6xXlObOVvP0yoR1v_0IsC_JNt4xvJexprbqQTr6TjUMjQqtWJuu_sR7XhSWsgEH77as7rCQK0ip1DLeFa5567J46KjYuY2hQDqbzl6Mn7OvS3aEBGU4eBGAY58-SYeJ3W9bKPJYqCx9Bkwjmr9B41iWSaz5Ki6YhderlMBA9Dfg8s-1uj70k8nthPqKnwV1w5lP8Y0wOJzgBx5REj425joGQHMG-M_8PpRRjctnVo0LFsHvpUwBFLO7MVy5Og1KQZjJbE40w4N-x7jjVGgZq3mmVr1m7FmevdJl8nrJTDv_61sG9Uw4skERHbsU3NMtwgzADe1akrFYllUuYsbHMLFGwEqD3-TfoHOV94O58Hq_kOSziDKTYYmlFw6eNCJjlthWbCrTLAH9HcCNJdJxdyWr9uUWB8uubJXGdnSjD7HJ3aApft4dhnW_AcVsiT0FvlWqla1mQYmmFc0CWULTtH-H1ePnhErOS6wUI-7bUXTGD8Npu2iUdkxK8l13OeUzhoqIw0cZweNRNFpjsV-wt043C0sr5JcldR5ptLS3Ka5X8VOnkoeczYv17rPjOgAzVJvV-RTTZA72Ll0zSKYma-N3NUhZ9x5EZzTYtbw8f9maqVWx7S1WU1AD8h7NcQq0Cl7orO5GHXP_1n1jVkp-KV9rALdyuek_JD5B8TTULG_AZrDe4S1HIPG1FE8wnH8-Q9Iy6s5zKVH2X-xlJNRqaIxNyaGLj0WH9PYYFaQU8YnakM4_r-3nFy6ki7-cEoDZK3qcw7PJCp9w-iSgN9hVe2WFESd0t8pfpI0WTc6lf5ErS0yfqFsj4LPsnQJjr8Ugn3-pX4_51v7LvRfVqnrwBcEJv_da-58RdvJw-hKx6uClKEfzl6Zm4phRloZSqpxb-Zq4UeR34E6ATI9aQYs46sfH5-CilrxxE-gHzA4WxTNGFXv0Nabb01JJVZx0qbuEfSuE-\\-\\_IiNWgOoF1vr9SiJfYXVQ9ofCEvj6viyzWx1jxp_a1PpUBVzpBMC9ZvXfPuxnrBqF7iQJeJGHETu7XrTrkW7RhAZSTWpJKN2ufGQjeAlCyZeKOaJkwtp7y4dC8M4KjVLz7L-1FenhrLC0_ERM1QoTmgAYBKV2sPS6tCjdkCK4PYQo76-U4OdzM_kG2s&amp;f=0&amp;ui=6011858202131-id_51f2904c3d16d9b66803454&amp;en=fad_hide&amp;ed=true&amp;a=1&amp;__tn__=v\" aria-haspopup=\"1\"></a></div></div><div class=\"title\"><script type=\"text/javascript\">try {\n    ((JSBNG_Record.scriptLoad)((\"function e14338d925f9bf9db3a9f83cbec4d7eb15257906b(event) {\\u000a    var meta = document.getElementById(\\\"meta_referrer\\\");\\u000a    meta.content = \\\"origin\\\";\\u000a    setTimeout(function() {\\u000a        meta.content = \\\"default\\\";\\u000a    }, 100);\\u000a    var attribute = \\\"href\\\";\\u000a    var ms = this.getAttribute(attribute).match(/([\\\\\\\\?|&]f=)([^&]*)/);\\u000a    if (ms) {\\u000a        this.setAttribute(attribute, this.getAttribute(attribute).replace(/[\\\\\\\\?|&]f=[^&]*/, (ms[1] + 0)));\\u000a    }\\u000a;\\u000a;\\u000a    var attribute = \\\"href\\\";\\u000a    var sig = this.getAttribute(attribute).match(/([\\\\\\\\?|&]sig=)([^&]*)/);\\u000a    if (sig) {\\u000a        this.setAttribute(attribute, this.getAttribute(attribute).replace(/[\\\\\\\\?|&]sig=[^&]*/, (sig[1] + ((Math.floor((Math.random() * 65535)) + 65536)))));\\u000a    }\\u000a;\\u000a;\\u000a};\"), (\"s97dfd0dd969505e65a9d012deafb18c1c93fe214\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    function e14338d925f9bf9db3a9f83cbec4d7eb15257906b(JSBNG__event) {\n        if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n            return ((JSBNG_Record.eventCall)((arguments.callee), (\"s97dfd0dd969505e65a9d012deafb18c1c93fe214_0\"), (s97dfd0dd969505e65a9d012deafb18c1c93fe214_0_instance), (this), (arguments)))\n        };\n        (null);\n        var meta = (((JSBNG_Record.get)(JSBNG__document, (\"getElementById\")))[(\"getElementById\")])(\"meta_referrer\");\n        ((JSBNG_Record.set)(meta, (\"JSBNG__content\"), \"origin\"));\n        JSBNG__setTimeout(((function() {\n            var s97dfd0dd969505e65a9d012deafb18c1c93fe214_1_instance;\n            ((s97dfd0dd969505e65a9d012deafb18c1c93fe214_1_instance) = ((JSBNG_Record.eventInstance)((\"s97dfd0dd969505e65a9d012deafb18c1c93fe214_1\"))));\n            return ((JSBNG_Record.markFunction)((function() {\n                if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                    return ((JSBNG_Record.eventCall)((arguments.callee), (\"s97dfd0dd969505e65a9d012deafb18c1c93fe214_1\"), (s97dfd0dd969505e65a9d012deafb18c1c93fe214_1_instance), (this), (arguments)))\n                };\n                (null);\n                ((JSBNG_Record.set)(meta, (\"JSBNG__content\"), \"default\"));\n            })));\n        })()), 100);\n        var attribute = \"href\";\n        var ms = (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"match\")))[(\"match\")])(/([\\\\?|&]f=)([^&]*)/);\n        if (ms) {\n            (((JSBNG_Record.get)(this, (\"setAttribute\")))[(\"setAttribute\")])(attribute, (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"replace\")))[(\"replace\")])(/[\\\\?|&]f=[^&]*/, ((((JSBNG_Record.get)(ms, 1))[1]) + 0)));\n        }\n        ;\n        ;\n        var attribute = \"href\";\n        var sig = (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"match\")))[(\"match\")])(/([\\\\?|&]sig=)([^&]*)/);\n        if (sig) {\n            (((JSBNG_Record.get)(this, (\"setAttribute\")))[(\"setAttribute\")])(attribute, (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"replace\")))[(\"replace\")])(/[\\\\?|&]sig=[^&]*/, ((((JSBNG_Record.get)(sig, 1))[1]) + (((((JSBNG_Record.get)(Math, (\"floor\")))[(\"floor\")])(((((JSBNG_Record.get)(Math, (\"JSBNG__random\")))[(\"JSBNG__random\")])() * 65535)) + 65536)))));\n        }\n        ;\n        ;\n    };\n    var s97dfd0dd969505e65a9d012deafb18c1c93fe214_0_instance;\n    ((s97dfd0dd969505e65a9d012deafb18c1c93fe214_0_instance) = ((JSBNG_Record.eventInstance)((\"s97dfd0dd969505e65a9d012deafb18c1c93fe214_0\"))));\n    ((JSBNG_Record.markFunction)((e14338d925f9bf9db3a9f83cbec4d7eb15257906b)));\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};</script><a class=\"forceLTR emuEvent1 -cx-PUBLIC-fbEmu__link\" href=\"/ajax/emu/end.php?eid=AQKeJQRxXzUhxhbYGaYgYDYhc3hQ30O_gQTSLytMewtlgvobJQH5MuaQJp4_fbqlG5W0Tung-9ZDLu-ztha3uNKKYrj85XEwPZJe-GO5gSUpcbVv7zETufLCcsIh674v1O83EtmtVxQup-\\-\\XRKCr8pDY6xXlObOVvP0yoR1v_0IsC_JNt4xvJexprbqQTr6TjUMjQqtWJuu_sR7XhSWsgEH77as7rCQK0ip1DLeFa5567J46KjYuY2hQDqbzl6Mn7OvS3aEBGU4eBGAY58-SYeJ3W9bKPJYqCx9Bkwjmr9B41iWSaz5Ki6YhderlMBA9Dfg8s-1uj70k8nthPqKnwV1w5lP8Y0wOJzgBx5REj425joGQHMG-M_8PpRRjctnVo0LFsHvpUwBFLO7MVy5Og1KQZjJbE40w4N-x7jjVGgZq3mmVr1m7FmevdJl8nrJTDv_61sG9Uw4skERHbsU3NMtwgzADe1akrFYllUuYsbHMLFGwEqD3-TfoHOV94O58Hq_kOSziDKTYYmlFw6eNCJjlthWbCrTLAH9HcCNJdJxdyWr9uUWB8uubJXGdnSjD7HJ3aApft4dhnW_AcVsiT0FvlWqla1mQYmmFc0CWULTtH-H1ePnhErOS6wUI-7bUXTGD8Npu2iUdkxK8l13OeUzhoqIw0cZweNRNFpjsV-wt043C0sr5JcldR5ptLS3Ka5X8VOnkoeczYv17rPjOgAzVJvV-RTTZA72Ll0zSKYma-N3NUhZ9x5EZzTYtbw8f9maqVWx7S1WU1AD8h7NcQq0Cl7orO5GHXP_1n1jVkp-KV9rALdyuek_JD5B8TTULG_AZrDe4S1HIPG1FE8wnH8-Q9Iy6s5zKVH2X-xlJNRqaIxNyaGLj0WH9PYYFaQU8YnakM4_r-3nFy6ki7-cEoDZK3qcw7PJCp9w-iSgN9hVe2WFESd0t8pfpI0WTc6lf5ErS0yfqFsj4LPsnQJjr8Ugn3-pX4_51v7LvRfVqnrwBcEJv_da-58RdvJw-hKx6uClKEfzl6Zm4phRloZSqpxb-Zq4UeR34E6ATI9aQYs46sfH5-CilrxxE-gHzA4WxTNGFXv0Nabb01JJVZx0qbuEfSuE-\\-\\_IiNWgOoF1vr9SiJfYXVQ9ofCEvj6viyzWx1jxp_a1PpUBVzpBMC9ZvXfPuxnrBqF7iQJeJGHETu7XrTrkW7RhAZSTWpJKN2ufGQjeAlCyZeKOaJkwtp7y4dC8M4KjVLz7L-1FenhrLC0_ERM1QoTmgAYBKV2sPS6tCjdkCK4PYQo76-U4OdzM_kG2s&amp;f=1&amp;ui=6011858202131-id_51f2904c3d16d9b66803454&amp;en=1&amp;a=0&amp;sig=71261&amp;__tn__=wv\" onmousedown=\"return e14338d925f9bf9db3a9f83cbec4d7eb15257906b.call(this, event);\">S.V.S. Fine Jewelry</a></div><div class=\"clearfix image_body_block\"><script type=\"text/javascript\">try {\n    ((JSBNG_Record.scriptLoad)((\"function e99ef0c69a11cb199218318ed6a88927763ad1717(event) {\\u000a    var meta = document.getElementById(\\\"meta_referrer\\\");\\u000a    meta.content = \\\"origin\\\";\\u000a    setTimeout(function() {\\u000a        meta.content = \\\"default\\\";\\u000a    }, 100);\\u000a    var attribute = \\\"href\\\";\\u000a    var ms = this.getAttribute(attribute).match(/([\\\\\\\\?|&]f=)([^&]*)/);\\u000a    if (ms) {\\u000a        this.setAttribute(attribute, this.getAttribute(attribute).replace(/[\\\\\\\\?|&]f=[^&]*/, (ms[1] + 0)));\\u000a    }\\u000a;\\u000a;\\u000a    var attribute = \\\"href\\\";\\u000a    var sig = this.getAttribute(attribute).match(/([\\\\\\\\?|&]sig=)([^&]*)/);\\u000a    if (sig) {\\u000a        this.setAttribute(attribute, this.getAttribute(attribute).replace(/[\\\\\\\\?|&]sig=[^&]*/, (sig[1] + ((Math.floor((Math.random() * 65535)) + 65536)))));\\u000a    }\\u000a;\\u000a;\\u000a};\"), (\"sd68fd4a2dfa62f16eb4f1ee948762cde8f89efd2\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    function e99ef0c69a11cb199218318ed6a88927763ad1717(JSBNG__event) {\n        if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n            return ((JSBNG_Record.eventCall)((arguments.callee), (\"sd68fd4a2dfa62f16eb4f1ee948762cde8f89efd2_0\"), (sd68fd4a2dfa62f16eb4f1ee948762cde8f89efd2_0_instance), (this), (arguments)))\n        };\n        (null);\n        var meta = (((JSBNG_Record.get)(JSBNG__document, (\"getElementById\")))[(\"getElementById\")])(\"meta_referrer\");\n        ((JSBNG_Record.set)(meta, (\"JSBNG__content\"), \"origin\"));\n        JSBNG__setTimeout(((function() {\n            var sd68fd4a2dfa62f16eb4f1ee948762cde8f89efd2_1_instance;\n            ((sd68fd4a2dfa62f16eb4f1ee948762cde8f89efd2_1_instance) = ((JSBNG_Record.eventInstance)((\"sd68fd4a2dfa62f16eb4f1ee948762cde8f89efd2_1\"))));\n            return ((JSBNG_Record.markFunction)((function() {\n                if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                    return ((JSBNG_Record.eventCall)((arguments.callee), (\"sd68fd4a2dfa62f16eb4f1ee948762cde8f89efd2_1\"), (sd68fd4a2dfa62f16eb4f1ee948762cde8f89efd2_1_instance), (this), (arguments)))\n                };\n                (null);\n                ((JSBNG_Record.set)(meta, (\"JSBNG__content\"), \"default\"));\n            })));\n        })()), 100);\n        var attribute = \"href\";\n        var ms = (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"match\")))[(\"match\")])(/([\\\\?|&]f=)([^&]*)/);\n        if (ms) {\n            (((JSBNG_Record.get)(this, (\"setAttribute\")))[(\"setAttribute\")])(attribute, (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"replace\")))[(\"replace\")])(/[\\\\?|&]f=[^&]*/, ((((JSBNG_Record.get)(ms, 1))[1]) + 0)));\n        }\n        ;\n        ;\n        var attribute = \"href\";\n        var sig = (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"match\")))[(\"match\")])(/([\\\\?|&]sig=)([^&]*)/);\n        if (sig) {\n            (((JSBNG_Record.get)(this, (\"setAttribute\")))[(\"setAttribute\")])(attribute, (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"replace\")))[(\"replace\")])(/[\\\\?|&]sig=[^&]*/, ((((JSBNG_Record.get)(sig, 1))[1]) + (((((JSBNG_Record.get)(Math, (\"floor\")))[(\"floor\")])(((((JSBNG_Record.get)(Math, (\"JSBNG__random\")))[(\"JSBNG__random\")])() * 65535)) + 65536)))));\n        }\n        ;\n        ;\n    };\n    var sd68fd4a2dfa62f16eb4f1ee948762cde8f89efd2_0_instance;\n    ((sd68fd4a2dfa62f16eb4f1ee948762cde8f89efd2_0_instance) = ((JSBNG_Record.eventInstance)((\"sd68fd4a2dfa62f16eb4f1ee948762cde8f89efd2_0\"))));\n    ((JSBNG_Record.markFunction)((e99ef0c69a11cb199218318ed6a88927763ad1717)));\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};</script><a class=\"forceLTR emuEvent1 -cx-PUBLIC-fbEmu__link image fbEmuImage -cx-PRIVATE-uiImageBlock__image -cx-PRIVATE-uiImageBlock__mediumimage lfloat\" tabindex=\"-1\" href=\"/ajax/emu/end.php?eid=AQKeJQRxXzUhxhbYGaYgYDYhc3hQ30O_gQTSLytMewtlgvobJQH5MuaQJp4_fbqlG5W0Tung-9ZDLu-ztha3uNKKYrj85XEwPZJe-GO5gSUpcbVv7zETufLCcsIh674v1O83EtmtVxQup-\\-\\XRKCr8pDY6xXlObOVvP0yoR1v_0IsC_JNt4xvJexprbqQTr6TjUMjQqtWJuu_sR7XhSWsgEH77as7rCQK0ip1DLeFa5567J46KjYuY2hQDqbzl6Mn7OvS3aEBGU4eBGAY58-SYeJ3W9bKPJYqCx9Bkwjmr9B41iWSaz5Ki6YhderlMBA9Dfg8s-1uj70k8nthPqKnwV1w5lP8Y0wOJzgBx5REj425joGQHMG-M_8PpRRjctnVo0LFsHvpUwBFLO7MVy5Og1KQZjJbE40w4N-x7jjVGgZq3mmVr1m7FmevdJl8nrJTDv_61sG9Uw4skERHbsU3NMtwgzADe1akrFYllUuYsbHMLFGwEqD3-TfoHOV94O58Hq_kOSziDKTYYmlFw6eNCJjlthWbCrTLAH9HcCNJdJxdyWr9uUWB8uubJXGdnSjD7HJ3aApft4dhnW_AcVsiT0FvlWqla1mQYmmFc0CWULTtH-H1ePnhErOS6wUI-7bUXTGD8Npu2iUdkxK8l13OeUzhoqIw0cZweNRNFpjsV-wt043C0sr5JcldR5ptLS3Ka5X8VOnkoeczYv17rPjOgAzVJvV-RTTZA72Ll0zSKYma-N3NUhZ9x5EZzTYtbw8f9maqVWx7S1WU1AD8h7NcQq0Cl7orO5GHXP_1n1jVkp-KV9rALdyuek_JD5B8TTULG_AZrDe4S1HIPG1FE8wnH8-Q9Iy6s5zKVH2X-xlJNRqaIxNyaGLj0WH9PYYFaQU8YnakM4_r-3nFy6ki7-cEoDZK3qcw7PJCp9w-iSgN9hVe2WFESd0t8pfpI0WTc6lf5ErS0yfqFsj4LPsnQJjr8Ugn3-pX4_51v7LvRfVqnrwBcEJv_da-58RdvJw-hKx6uClKEfzl6Zm4phRloZSqpxb-Zq4UeR34E6ATI9aQYs46sfH5-CilrxxE-gHzA4WxTNGFXv0Nabb01JJVZx0qbuEfSuE-\\-\\_IiNWgOoF1vr9SiJfYXVQ9ofCEvj6viyzWx1jxp_a1PpUBVzpBMC9ZvXfPuxnrBqF7iQJeJGHETu7XrTrkW7RhAZSTWpJKN2ufGQjeAlCyZeKOaJkwtp7y4dC8M4KjVLz7L-1FenhrLC0_ERM1QoTmgAYBKV2sPS6tCjdkCK4PYQo76-U4OdzM_kG2s&amp;f=1&amp;ui=6011858202131-id_51f2904c3d16d9b66803454&amp;en=1&amp;a=0&amp;sig=125679&amp;__tn__=ywv\" onmousedown=\"return e99ef0c69a11cb199218318ed6a88927763ad1717.call(this, event);\" aria-hidden=\"true\"><img class=\"img\" src=\"http://jsbngssl.creative-iad.xx.fbcdn.net/hads-prn1/s110x80/735357_6011669043531_889011985_n.png\" alt=\"\" /></a><div class=\"-cx-PRIVATE-uiFlexibleBlock__flexiblecontent\"><div class=\"body\"><script type=\"text/javascript\">try {\n    ((JSBNG_Record.scriptLoad)((\"function eb9d86d457b698354ef73e187d68041c13a6747e5(event) {\\u000a    var meta = document.getElementById(\\\"meta_referrer\\\");\\u000a    meta.content = \\\"origin\\\";\\u000a    setTimeout(function() {\\u000a        meta.content = \\\"default\\\";\\u000a    }, 100);\\u000a    var attribute = \\\"href\\\";\\u000a    var ms = this.getAttribute(attribute).match(/([\\\\\\\\?|&]f=)([^&]*)/);\\u000a    if (ms) {\\u000a        this.setAttribute(attribute, this.getAttribute(attribute).replace(/[\\\\\\\\?|&]f=[^&]*/, (ms[1] + 0)));\\u000a    }\\u000a;\\u000a;\\u000a    var attribute = \\\"href\\\";\\u000a    var sig = this.getAttribute(attribute).match(/([\\\\\\\\?|&]sig=)([^&]*)/);\\u000a    if (sig) {\\u000a        this.setAttribute(attribute, this.getAttribute(attribute).replace(/[\\\\\\\\?|&]sig=[^&]*/, (sig[1] + ((Math.floor((Math.random() * 65535)) + 65536)))));\\u000a    }\\u000a;\\u000a;\\u000a};\"), (\"sc5e6c333b267f15e0561ff6cf990d3adc7940e7f\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    function eb9d86d457b698354ef73e187d68041c13a6747e5(JSBNG__event) {\n        if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n            return ((JSBNG_Record.eventCall)((arguments.callee), (\"sc5e6c333b267f15e0561ff6cf990d3adc7940e7f_0\"), (sc5e6c333b267f15e0561ff6cf990d3adc7940e7f_0_instance), (this), (arguments)))\n        };\n        (null);\n        var meta = (((JSBNG_Record.get)(JSBNG__document, (\"getElementById\")))[(\"getElementById\")])(\"meta_referrer\");\n        ((JSBNG_Record.set)(meta, (\"JSBNG__content\"), \"origin\"));\n        JSBNG__setTimeout(((function() {\n            var sc5e6c333b267f15e0561ff6cf990d3adc7940e7f_1_instance;\n            ((sc5e6c333b267f15e0561ff6cf990d3adc7940e7f_1_instance) = ((JSBNG_Record.eventInstance)((\"sc5e6c333b267f15e0561ff6cf990d3adc7940e7f_1\"))));\n            return ((JSBNG_Record.markFunction)((function() {\n                if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                    return ((JSBNG_Record.eventCall)((arguments.callee), (\"sc5e6c333b267f15e0561ff6cf990d3adc7940e7f_1\"), (sc5e6c333b267f15e0561ff6cf990d3adc7940e7f_1_instance), (this), (arguments)))\n                };\n                (null);\n                ((JSBNG_Record.set)(meta, (\"JSBNG__content\"), \"default\"));\n            })));\n        })()), 100);\n        var attribute = \"href\";\n        var ms = (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"match\")))[(\"match\")])(/([\\\\?|&]f=)([^&]*)/);\n        if (ms) {\n            (((JSBNG_Record.get)(this, (\"setAttribute\")))[(\"setAttribute\")])(attribute, (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"replace\")))[(\"replace\")])(/[\\\\?|&]f=[^&]*/, ((((JSBNG_Record.get)(ms, 1))[1]) + 0)));\n        }\n        ;\n        ;\n        var attribute = \"href\";\n        var sig = (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"match\")))[(\"match\")])(/([\\\\?|&]sig=)([^&]*)/);\n        if (sig) {\n            (((JSBNG_Record.get)(this, (\"setAttribute\")))[(\"setAttribute\")])(attribute, (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"replace\")))[(\"replace\")])(/[\\\\?|&]sig=[^&]*/, ((((JSBNG_Record.get)(sig, 1))[1]) + (((((JSBNG_Record.get)(Math, (\"floor\")))[(\"floor\")])(((((JSBNG_Record.get)(Math, (\"JSBNG__random\")))[(\"JSBNG__random\")])() * 65535)) + 65536)))));\n        }\n        ;\n        ;\n    };\n    var sc5e6c333b267f15e0561ff6cf990d3adc7940e7f_0_instance;\n    ((sc5e6c333b267f15e0561ff6cf990d3adc7940e7f_0_instance) = ((JSBNG_Record.eventInstance)((\"sc5e6c333b267f15e0561ff6cf990d3adc7940e7f_0\"))));\n    ((JSBNG_Record.markFunction)((eb9d86d457b698354ef73e187d68041c13a6747e5)));\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};</script><a class=\"forceLTR emuEvent1 -cx-PUBLIC-fbEmu__link\" href=\"/ajax/emu/end.php?eid=AQKeJQRxXzUhxhbYGaYgYDYhc3hQ30O_gQTSLytMewtlgvobJQH5MuaQJp4_fbqlG5W0Tung-9ZDLu-ztha3uNKKYrj85XEwPZJe-GO5gSUpcbVv7zETufLCcsIh674v1O83EtmtVxQup-\\-\\XRKCr8pDY6xXlObOVvP0yoR1v_0IsC_JNt4xvJexprbqQTr6TjUMjQqtWJuu_sR7XhSWsgEH77as7rCQK0ip1DLeFa5567J46KjYuY2hQDqbzl6Mn7OvS3aEBGU4eBGAY58-SYeJ3W9bKPJYqCx9Bkwjmr9B41iWSaz5Ki6YhderlMBA9Dfg8s-1uj70k8nthPqKnwV1w5lP8Y0wOJzgBx5REj425joGQHMG-M_8PpRRjctnVo0LFsHvpUwBFLO7MVy5Og1KQZjJbE40w4N-x7jjVGgZq3mmVr1m7FmevdJl8nrJTDv_61sG9Uw4skERHbsU3NMtwgzADe1akrFYllUuYsbHMLFGwEqD3-TfoHOV94O58Hq_kOSziDKTYYmlFw6eNCJjlthWbCrTLAH9HcCNJdJxdyWr9uUWB8uubJXGdnSjD7HJ3aApft4dhnW_AcVsiT0FvlWqla1mQYmmFc0CWULTtH-H1ePnhErOS6wUI-7bUXTGD8Npu2iUdkxK8l13OeUzhoqIw0cZweNRNFpjsV-wt043C0sr5JcldR5ptLS3Ka5X8VOnkoeczYv17rPjOgAzVJvV-RTTZA72Ll0zSKYma-N3NUhZ9x5EZzTYtbw8f9maqVWx7S1WU1AD8h7NcQq0Cl7orO5GHXP_1n1jVkp-KV9rALdyuek_JD5B8TTULG_AZrDe4S1HIPG1FE8wnH8-Q9Iy6s5zKVH2X-xlJNRqaIxNyaGLj0WH9PYYFaQU8YnakM4_r-3nFy6ki7-cEoDZK3qcw7PJCp9w-iSgN9hVe2WFESd0t8pfpI0WTc6lf5ErS0yfqFsj4LPsnQJjr8Ugn3-pX4_51v7LvRfVqnrwBcEJv_da-58RdvJw-hKx6uClKEfzl6Zm4phRloZSqpxb-Zq4UeR34E6ATI9aQYs46sfH5-CilrxxE-gHzA4WxTNGFXv0Nabb01JJVZx0qbuEfSuE-\\-\\_IiNWgOoF1vr9SiJfYXVQ9ofCEvj6viyzWx1jxp_a1PpUBVzpBMC9ZvXfPuxnrBqF7iQJeJGHETu7XrTrkW7RhAZSTWpJKN2ufGQjeAlCyZeKOaJkwtp7y4dC8M4KjVLz7L-1FenhrLC0_ERM1QoTmgAYBKV2sPS6tCjdkCK4PYQo76-U4OdzM_kG2s&amp;f=1&amp;ui=6011858202131-id_51f2904c3d16d9b66803454&amp;en=1&amp;a=0&amp;sig=65690&amp;__tn__=xywv\" onmousedown=\"return eb9d86d457b698354ef73e187d68041c13a6747e5.call(this, event);\">At SVS Fine Jewelry we have been honored to be selected as an IJO Master Jeweler. As a...</a></div></div></div><div class=\"inline\"><div class=\"action\"><a class=\"uiIconText emuEventfad_fan -cx-PUBLIC-fbEmu__link\" href=\"#\" style=\"padding-left: 17px;\" rel=\"async-post\" ajaxify=\"/ajax/emu/end.php?eid=AQKeJQRxXzUhxhbYGaYgYDYhc3hQ30O_gQTSLytMewtlgvobJQH5MuaQJp4_fbqlG5W0Tung-9ZDLu-ztha3uNKKYrj85XEwPZJe-GO5gSUpcbVv7zETufLCcsIh674v1O83EtmtVxQup-\\-\\XRKCr8pDY6xXlObOVvP0yoR1v_0IsC_JNt4xvJexprbqQTr6TjUMjQqtWJuu_sR7XhSWsgEH77as7rCQK0ip1DLeFa5567J46KjYuY2hQDqbzl6Mn7OvS3aEBGU4eBGAY58-SYeJ3W9bKPJYqCx9Bkwjmr9B41iWSaz5Ki6YhderlMBA9Dfg8s-1uj70k8nthPqKnwV1w5lP8Y0wOJzgBx5REj425joGQHMG-M_8PpRRjctnVo0LFsHvpUwBFLO7MVy5Og1KQZjJbE40w4N-x7jjVGgZq3mmVr1m7FmevdJl8nrJTDv_61sG9Uw4skERHbsU3NMtwgzADe1akrFYllUuYsbHMLFGwEqD3-TfoHOV94O58Hq_kOSziDKTYYmlFw6eNCJjlthWbCrTLAH9HcCNJdJxdyWr9uUWB8uubJXGdnSjD7HJ3aApft4dhnW_AcVsiT0FvlWqla1mQYmmFc0CWULTtH-H1ePnhErOS6wUI-7bUXTGD8Npu2iUdkxK8l13OeUzhoqIw0cZweNRNFpjsV-wt043C0sr5JcldR5ptLS3Ka5X8VOnkoeczYv17rPjOgAzVJvV-RTTZA72Ll0zSKYma-N3NUhZ9x5EZzTYtbw8f9maqVWx7S1WU1AD8h7NcQq0Cl7orO5GHXP_1n1jVkp-KV9rALdyuek_JD5B8TTULG_AZrDe4S1HIPG1FE8wnH8-Q9Iy6s5zKVH2X-xlJNRqaIxNyaGLj0WH9PYYFaQU8YnakM4_r-3nFy6ki7-cEoDZK3qcw7PJCp9w-iSgN9hVe2WFESd0t8pfpI0WTc6lf5ErS0yfqFsj4LPsnQJjr8Ugn3-pX4_51v7LvRfVqnrwBcEJv_da-58RdvJw-hKx6uClKEfzl6Zm4phRloZSqpxb-Zq4UeR34E6ATI9aQYs46sfH5-CilrxxE-gHzA4WxTNGFXv0Nabb01JJVZx0qbuEfSuE-\\-\\_IiNWgOoF1vr9SiJfYXVQ9ofCEvj6viyzWx1jxp_a1PpUBVzpBMC9ZvXfPuxnrBqF7iQJeJGHETu7XrTrkW7RhAZSTWpJKN2ufGQjeAlCyZeKOaJkwtp7y4dC8M4KjVLz7L-1FenhrLC0_ERM1QoTmgAYBKV2sPS6tCjdkCK4PYQo76-U4OdzM_kG2s&amp;f=0&amp;ui=6011858202131-id_51f2904c3d16d9b66803454&amp;en=fad_fan&amp;ed=406124561390&amp;a=1&amp;__tn__=wv\" role=\"button\"><i class=\"img sp_4p6kmz sx_bc56c4\" style=\"top: 1px;\"></i>Like</a> · <span class=\"fbEmuContext\">2,197 people like <script type=\"text/javascript\">try {\n    ((JSBNG_Record.scriptLoad)((\"function e61f9797e9a470a89724555bc0d8ffb0093c5ba67(event) {\\u000a    var meta = document.getElementById(\\\"meta_referrer\\\");\\u000a    meta.content = \\\"origin\\\";\\u000a    setTimeout(function() {\\u000a        meta.content = \\\"default\\\";\\u000a    }, 100);\\u000a    var attribute = \\\"href\\\";\\u000a    var ms = this.getAttribute(attribute).match(/([\\\\\\\\?|&]f=)([^&]*)/);\\u000a    if (ms) {\\u000a        this.setAttribute(attribute, this.getAttribute(attribute).replace(/[\\\\\\\\?|&]f=[^&]*/, (ms[1] + 0)));\\u000a    }\\u000a;\\u000a;\\u000a    var attribute = \\\"href\\\";\\u000a    var sig = this.getAttribute(attribute).match(/([\\\\\\\\?|&]sig=)([^&]*)/);\\u000a    if (sig) {\\u000a        this.setAttribute(attribute, this.getAttribute(attribute).replace(/[\\\\\\\\?|&]sig=[^&]*/, (sig[1] + ((Math.floor((Math.random() * 65535)) + 65536)))));\\u000a    }\\u000a;\\u000a;\\u000a};\"), (\"s3d260c2ec16dce7a2154b6ef4b44776dd6330abb\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    function e61f9797e9a470a89724555bc0d8ffb0093c5ba67(JSBNG__event) {\n        if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n            return ((JSBNG_Record.eventCall)((arguments.callee), (\"s3d260c2ec16dce7a2154b6ef4b44776dd6330abb_0\"), (s3d260c2ec16dce7a2154b6ef4b44776dd6330abb_0_instance), (this), (arguments)))\n        };\n        (null);\n        var meta = (((JSBNG_Record.get)(JSBNG__document, (\"getElementById\")))[(\"getElementById\")])(\"meta_referrer\");\n        ((JSBNG_Record.set)(meta, (\"JSBNG__content\"), \"origin\"));\n        JSBNG__setTimeout(((function() {\n            var s3d260c2ec16dce7a2154b6ef4b44776dd6330abb_1_instance;\n            ((s3d260c2ec16dce7a2154b6ef4b44776dd6330abb_1_instance) = ((JSBNG_Record.eventInstance)((\"s3d260c2ec16dce7a2154b6ef4b44776dd6330abb_1\"))));\n            return ((JSBNG_Record.markFunction)((function() {\n                if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                    return ((JSBNG_Record.eventCall)((arguments.callee), (\"s3d260c2ec16dce7a2154b6ef4b44776dd6330abb_1\"), (s3d260c2ec16dce7a2154b6ef4b44776dd6330abb_1_instance), (this), (arguments)))\n                };\n                (null);\n                ((JSBNG_Record.set)(meta, (\"JSBNG__content\"), \"default\"));\n            })));\n        })()), 100);\n        var attribute = \"href\";\n        var ms = (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"match\")))[(\"match\")])(/([\\\\?|&]f=)([^&]*)/);\n        if (ms) {\n            (((JSBNG_Record.get)(this, (\"setAttribute\")))[(\"setAttribute\")])(attribute, (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"replace\")))[(\"replace\")])(/[\\\\?|&]f=[^&]*/, ((((JSBNG_Record.get)(ms, 1))[1]) + 0)));\n        }\n        ;\n        ;\n        var attribute = \"href\";\n        var sig = (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"match\")))[(\"match\")])(/([\\\\?|&]sig=)([^&]*)/);\n        if (sig) {\n            (((JSBNG_Record.get)(this, (\"setAttribute\")))[(\"setAttribute\")])(attribute, (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"replace\")))[(\"replace\")])(/[\\\\?|&]sig=[^&]*/, ((((JSBNG_Record.get)(sig, 1))[1]) + (((((JSBNG_Record.get)(Math, (\"floor\")))[(\"floor\")])(((((JSBNG_Record.get)(Math, (\"JSBNG__random\")))[(\"JSBNG__random\")])() * 65535)) + 65536)))));\n        }\n        ;\n        ;\n    };\n    var s3d260c2ec16dce7a2154b6ef4b44776dd6330abb_0_instance;\n    ((s3d260c2ec16dce7a2154b6ef4b44776dd6330abb_0_instance) = ((JSBNG_Record.eventInstance)((\"s3d260c2ec16dce7a2154b6ef4b44776dd6330abb_0\"))));\n    ((JSBNG_Record.markFunction)((e61f9797e9a470a89724555bc0d8ffb0093c5ba67)));\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};</script><a class=\"emuEventfad_pageclick -cx-PUBLIC-fbEmu__link\" href=\"/ajax/emu/end.php?eid=AQKeJQRxXzUhxhbYGaYgYDYhc3hQ30O_gQTSLytMewtlgvobJQH5MuaQJp4_fbqlG5W0Tung-9ZDLu-ztha3uNKKYrj85XEwPZJe-GO5gSUpcbVv7zETufLCcsIh674v1O83EtmtVxQup-\\-\\XRKCr8pDY6xXlObOVvP0yoR1v_0IsC_JNt4xvJexprbqQTr6TjUMjQqtWJuu_sR7XhSWsgEH77as7rCQK0ip1DLeFa5567J46KjYuY2hQDqbzl6Mn7OvS3aEBGU4eBGAY58-SYeJ3W9bKPJYqCx9Bkwjmr9B41iWSaz5Ki6YhderlMBA9Dfg8s-1uj70k8nthPqKnwV1w5lP8Y0wOJzgBx5REj425joGQHMG-M_8PpRRjctnVo0LFsHvpUwBFLO7MVy5Og1KQZjJbE40w4N-x7jjVGgZq3mmVr1m7FmevdJl8nrJTDv_61sG9Uw4skERHbsU3NMtwgzADe1akrFYllUuYsbHMLFGwEqD3-TfoHOV94O58Hq_kOSziDKTYYmlFw6eNCJjlthWbCrTLAH9HcCNJdJxdyWr9uUWB8uubJXGdnSjD7HJ3aApft4dhnW_AcVsiT0FvlWqla1mQYmmFc0CWULTtH-H1ePnhErOS6wUI-7bUXTGD8Npu2iUdkxK8l13OeUzhoqIw0cZweNRNFpjsV-wt043C0sr5JcldR5ptLS3Ka5X8VOnkoeczYv17rPjOgAzVJvV-RTTZA72Ll0zSKYma-N3NUhZ9x5EZzTYtbw8f9maqVWx7S1WU1AD8h7NcQq0Cl7orO5GHXP_1n1jVkp-KV9rALdyuek_JD5B8TTULG_AZrDe4S1HIPG1FE8wnH8-Q9Iy6s5zKVH2X-xlJNRqaIxNyaGLj0WH9PYYFaQU8YnakM4_r-3nFy6ki7-cEoDZK3qcw7PJCp9w-iSgN9hVe2WFESd0t8pfpI0WTc6lf5ErS0yfqFsj4LPsnQJjr8Ugn3-pX4_51v7LvRfVqnrwBcEJv_da-58RdvJw-hKx6uClKEfzl6Zm4phRloZSqpxb-Zq4UeR34E6ATI9aQYs46sfH5-CilrxxE-gHzA4WxTNGFXv0Nabb01JJVZx0qbuEfSuE-\\-\\_IiNWgOoF1vr9SiJfYXVQ9ofCEvj6viyzWx1jxp_a1PpUBVzpBMC9ZvXfPuxnrBqF7iQJeJGHETu7XrTrkW7RhAZSTWpJKN2ufGQjeAlCyZeKOaJkwtp7y4dC8M4KjVLz7L-1FenhrLC0_ERM1QoTmgAYBKV2sPS6tCjdkCK4PYQo76-U4OdzM_kG2s&amp;f=1&amp;ui=6011858202131-id_51f2904c3d16d9b66803454&amp;en=fad_pageclick&amp;ed=406124561390&amp;a=0&amp;mac=AQKoHjJls9-pk6xe&amp;sig=112192&amp;__tn__=zwv\" onmousedown=\"return e61f9797e9a470a89724555bc0d8ffb0093c5ba67.call(this, event);\">S.V.S. Fine Jewelry</a>.</span></div></div></div></div></div><div class=\"ego_unit\" data-ego-fbid=\"6007957621675\"><div class=\"-cx-PUBLIC-fbAdUnit__root\" data-ad=\"&#123;&quot;adid&quot;:6007957621675,&quot;segment&quot;:&quot;market&quot;&#125;\" id=\"6007957621675-id_51f2904c3d2240385237667\"><div class=\"-cx-PRIVATE-fbEmu__root -cx-PRIVATE-fbEmuEgo__unit\"><div class=\"uiSelector inlineBlock emu_x emuEventfad_hide -cx-PUBLIC-fbEmu__link uiSelectorRight\"><div class=\"uiToggle wrap\"><a class=\"uiSelectorButton uiCloseButton uiCloseButtonSmall\" href=\"#\" role=\"button\" title=\"About Facebook Ads\" rel=\"toggle\" ajaxify=\"/ajax/emu/end.php?eid=AQLVAEr0JNIXHSlB-t1lt9Eixl6c4gkbuzVzVjL2frflXuYtFtrkvniUnm1Ku41tGCz7o3_vAgaHc_cm0KSk80Qn5KeG7SBu4gMjRWo6WTgHRYBuM5oy8HMWqE2Pc679lHqnSR_shRQD-voE8av-VW6uhejuFIKsYxQla8mJLMIcQjP3YwlX6FBEpi3IVDI7GysDpA3w55At5HB5Z4onn49-VAvhzAroPkfTP4ed7wRi6oKUIM0AwqhWvC3FrpzbYJQIbYePYuwGg0CAbWsYVqmHHIDp2LDaZf1MyEHBSB4edMf2GSbcR0dckr9I7r5wjuhr0MNu6x1Sc-gKyyTNy7OlvCvkzo0KCx0W1IEMqrzTB5bUX8tpAHpI2ai-deBrz8z6wERn75PMsjuCU9Y0J1OON89nEwJfV7EEAXRKUUuTa_hVHUV7ivmvG6mIgiU0MnkXdt5V_Yq68vbPMu305u-1HqvHNJG0NAcM2fCCIDcFeYVMgDQEr2FmsPA4pEM_4wzNUrZ0zXILjZEsaEiCfsHAdLK4-vtwErPb4oMyBgM-mw7Q-7Vwz7HcDAQZPCdQwsJuwcxzsevzSdBGTLem4jFqySTOWOqAaNV-Zpe_H-GNPxgrMO6TBdKDo3LC2_XdWwWmZ0_qF8qpZMvxwLLn_iJkUdQiW8CFuM3V18oROQpnqij5FULDzEPAXXPDZgW76SG2ZKac8r_z-40vmvcVwJ5vYBw692SkNfAFr2xZy4r9Q4q0bm64Ynng_cGt3oJE8ACtqbIsrMDpasTUpbDt7YNTJBLwaYHUiyNTeRtZTuLbZuKfsS43LNJyRGrlCRdnG4Hg5wZyWBEbb8RAUQ9LTS75RCdUIv4-QvEGjZQOBQYnK-xUKXm9ee6pYyx5mvDsgVg4u9QuBEvz5rnUUV8Do8JGAkD3POmEw_1OeNp0oRY-N5zuvt8cg6p_ToCKlOlbHkDyzz0xRt1Zuv4t7_6SLlzBFt5ctsFLL_GuXd0l6VrKKb2E9XB3s_uWtGgzMMMth1RxVfm5RhCK-T35_udWEzRHQiE1ZZ7BAtx-Bck8Bvz_rqbXRRIP6OSKdpnu7DK5CnJKNu23VXkM6CwoeAh28lMZzPSyYdJovN7ZUVbWFbSEiHfJtT8pMwvpTsDQDM9DdYJz7eERqAu_C_XDIstBY9camapiI983pIS3A3UEoTMLjb3DmgF8M5WdkJvMv_ca0oMSZg0ZBE-xMNPypKnvrxkzFgiLKBCNk6Gy0ub2919oLCHe0yhL3C533CfOBq7fAQom3JAK21VmnzsndPjbsj24&amp;f=0&amp;ui=6007957621675-id_51f2904c3d2240385237667&amp;en=fad_hide&amp;ed=true&amp;a=1&amp;__tn__=v\" aria-haspopup=\"1\"></a></div></div><div class=\"title\"><script type=\"text/javascript\">try {\n    ((JSBNG_Record.scriptLoad)((\"function ec6746832181e4465e84a15407c6358878a9524bf(event) {\\u000a    var meta = document.getElementById(\\\"meta_referrer\\\");\\u000a    meta.content = \\\"origin\\\";\\u000a    setTimeout(function() {\\u000a        meta.content = \\\"default\\\";\\u000a    }, 100);\\u000a    var attribute = \\\"href\\\";\\u000a    var ms = this.getAttribute(attribute).match(/([\\\\\\\\?|&]f=)([^&]*)/);\\u000a    if (ms) {\\u000a        this.setAttribute(attribute, this.getAttribute(attribute).replace(/[\\\\\\\\?|&]f=[^&]*/, (ms[1] + 0)));\\u000a    }\\u000a;\\u000a;\\u000a    var attribute = \\\"href\\\";\\u000a    var sig = this.getAttribute(attribute).match(/([\\\\\\\\?|&]sig=)([^&]*)/);\\u000a    if (sig) {\\u000a        this.setAttribute(attribute, this.getAttribute(attribute).replace(/[\\\\\\\\?|&]sig=[^&]*/, (sig[1] + ((Math.floor((Math.random() * 65535)) + 65536)))));\\u000a    }\\u000a;\\u000a;\\u000a};\"), (\"sde041b355e2c79a548ccd93451be6ac81481aa7f\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    function ec6746832181e4465e84a15407c6358878a9524bf(JSBNG__event) {\n        if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n            return ((JSBNG_Record.eventCall)((arguments.callee), (\"sde041b355e2c79a548ccd93451be6ac81481aa7f_0\"), (sde041b355e2c79a548ccd93451be6ac81481aa7f_0_instance), (this), (arguments)))\n        };\n        (null);\n        var meta = (((JSBNG_Record.get)(JSBNG__document, (\"getElementById\")))[(\"getElementById\")])(\"meta_referrer\");\n        ((JSBNG_Record.set)(meta, (\"JSBNG__content\"), \"origin\"));\n        JSBNG__setTimeout(((function() {\n            var sde041b355e2c79a548ccd93451be6ac81481aa7f_1_instance;\n            ((sde041b355e2c79a548ccd93451be6ac81481aa7f_1_instance) = ((JSBNG_Record.eventInstance)((\"sde041b355e2c79a548ccd93451be6ac81481aa7f_1\"))));\n            return ((JSBNG_Record.markFunction)((function() {\n                if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                    return ((JSBNG_Record.eventCall)((arguments.callee), (\"sde041b355e2c79a548ccd93451be6ac81481aa7f_1\"), (sde041b355e2c79a548ccd93451be6ac81481aa7f_1_instance), (this), (arguments)))\n                };\n                (null);\n                ((JSBNG_Record.set)(meta, (\"JSBNG__content\"), \"default\"));\n            })));\n        })()), 100);\n        var attribute = \"href\";\n        var ms = (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"match\")))[(\"match\")])(/([\\\\?|&]f=)([^&]*)/);\n        if (ms) {\n            (((JSBNG_Record.get)(this, (\"setAttribute\")))[(\"setAttribute\")])(attribute, (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"replace\")))[(\"replace\")])(/[\\\\?|&]f=[^&]*/, ((((JSBNG_Record.get)(ms, 1))[1]) + 0)));\n        }\n        ;\n        ;\n        var attribute = \"href\";\n        var sig = (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"match\")))[(\"match\")])(/([\\\\?|&]sig=)([^&]*)/);\n        if (sig) {\n            (((JSBNG_Record.get)(this, (\"setAttribute\")))[(\"setAttribute\")])(attribute, (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"replace\")))[(\"replace\")])(/[\\\\?|&]sig=[^&]*/, ((((JSBNG_Record.get)(sig, 1))[1]) + (((((JSBNG_Record.get)(Math, (\"floor\")))[(\"floor\")])(((((JSBNG_Record.get)(Math, (\"JSBNG__random\")))[(\"JSBNG__random\")])() * 65535)) + 65536)))));\n        }\n        ;\n        ;\n    };\n    var sde041b355e2c79a548ccd93451be6ac81481aa7f_0_instance;\n    ((sde041b355e2c79a548ccd93451be6ac81481aa7f_0_instance) = ((JSBNG_Record.eventInstance)((\"sde041b355e2c79a548ccd93451be6ac81481aa7f_0\"))));\n    ((JSBNG_Record.markFunction)((ec6746832181e4465e84a15407c6358878a9524bf)));\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};</script><a class=\"forceLTR emuEvent1 -cx-PUBLIC-fbEmu__link\" href=\"/ajax/emu/end.php?eid=AQLVAEr0JNIXHSlB-t1lt9Eixl6c4gkbuzVzVjL2frflXuYtFtrkvniUnm1Ku41tGCz7o3_vAgaHc_cm0KSk80Qn5KeG7SBu4gMjRWo6WTgHRYBuM5oy8HMWqE2Pc679lHqnSR_shRQD-voE8av-VW6uhejuFIKsYxQla8mJLMIcQjP3YwlX6FBEpi3IVDI7GysDpA3w55At5HB5Z4onn49-VAvhzAroPkfTP4ed7wRi6oKUIM0AwqhWvC3FrpzbYJQIbYePYuwGg0CAbWsYVqmHHIDp2LDaZf1MyEHBSB4edMf2GSbcR0dckr9I7r5wjuhr0MNu6x1Sc-gKyyTNy7OlvCvkzo0KCx0W1IEMqrzTB5bUX8tpAHpI2ai-deBrz8z6wERn75PMsjuCU9Y0J1OON89nEwJfV7EEAXRKUUuTa_hVHUV7ivmvG6mIgiU0MnkXdt5V_Yq68vbPMu305u-1HqvHNJG0NAcM2fCCIDcFeYVMgDQEr2FmsPA4pEM_4wzNUrZ0zXILjZEsaEiCfsHAdLK4-vtwErPb4oMyBgM-mw7Q-7Vwz7HcDAQZPCdQwsJuwcxzsevzSdBGTLem4jFqySTOWOqAaNV-Zpe_H-GNPxgrMO6TBdKDo3LC2_XdWwWmZ0_qF8qpZMvxwLLn_iJkUdQiW8CFuM3V18oROQpnqij5FULDzEPAXXPDZgW76SG2ZKac8r_z-40vmvcVwJ5vYBw692SkNfAFr2xZy4r9Q4q0bm64Ynng_cGt3oJE8ACtqbIsrMDpasTUpbDt7YNTJBLwaYHUiyNTeRtZTuLbZuKfsS43LNJyRGrlCRdnG4Hg5wZyWBEbb8RAUQ9LTS75RCdUIv4-QvEGjZQOBQYnK-xUKXm9ee6pYyx5mvDsgVg4u9QuBEvz5rnUUV8Do8JGAkD3POmEw_1OeNp0oRY-N5zuvt8cg6p_ToCKlOlbHkDyzz0xRt1Zuv4t7_6SLlzBFt5ctsFLL_GuXd0l6VrKKb2E9XB3s_uWtGgzMMMth1RxVfm5RhCK-T35_udWEzRHQiE1ZZ7BAtx-Bck8Bvz_rqbXRRIP6OSKdpnu7DK5CnJKNu23VXkM6CwoeAh28lMZzPSyYdJovN7ZUVbWFbSEiHfJtT8pMwvpTsDQDM9DdYJz7eERqAu_C_XDIstBY9camapiI983pIS3A3UEoTMLjb3DmgF8M5WdkJvMv_ca0oMSZg0ZBE-xMNPypKnvrxkzFgiLKBCNk6Gy0ub2919oLCHe0yhL3C533CfOBq7fAQom3JAK21VmnzsndPjbsj24&amp;f=1&amp;ui=6007957621675-id_51f2904c3d2240385237667&amp;en=1&amp;a=0&amp;sig=127360&amp;__tn__=wv\" onmousedown=\"return ec6746832181e4465e84a15407c6358878a9524bf.call(this, event);\">WOMEN on Facebook</a></div><div class=\"clearfix image_body_block\"><script type=\"text/javascript\">try {\n    ((JSBNG_Record.scriptLoad)((\"function e2c113a9a386ab849c906a9d56b8165fc46d98f19(event) {\\u000a    var meta = document.getElementById(\\\"meta_referrer\\\");\\u000a    meta.content = \\\"origin\\\";\\u000a    setTimeout(function() {\\u000a        meta.content = \\\"default\\\";\\u000a    }, 100);\\u000a    var attribute = \\\"href\\\";\\u000a    var ms = this.getAttribute(attribute).match(/([\\\\\\\\?|&]f=)([^&]*)/);\\u000a    if (ms) {\\u000a        this.setAttribute(attribute, this.getAttribute(attribute).replace(/[\\\\\\\\?|&]f=[^&]*/, (ms[1] + 0)));\\u000a    }\\u000a;\\u000a;\\u000a    var attribute = \\\"href\\\";\\u000a    var sig = this.getAttribute(attribute).match(/([\\\\\\\\?|&]sig=)([^&]*)/);\\u000a    if (sig) {\\u000a        this.setAttribute(attribute, this.getAttribute(attribute).replace(/[\\\\\\\\?|&]sig=[^&]*/, (sig[1] + ((Math.floor((Math.random() * 65535)) + 65536)))));\\u000a    }\\u000a;\\u000a;\\u000a};\"), (\"s28879714450be6a27c1abfe326e44e49840aca82\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    function e2c113a9a386ab849c906a9d56b8165fc46d98f19(JSBNG__event) {\n        if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n            return ((JSBNG_Record.eventCall)((arguments.callee), (\"s28879714450be6a27c1abfe326e44e49840aca82_0\"), (s28879714450be6a27c1abfe326e44e49840aca82_0_instance), (this), (arguments)))\n        };\n        (null);\n        var meta = (((JSBNG_Record.get)(JSBNG__document, (\"getElementById\")))[(\"getElementById\")])(\"meta_referrer\");\n        ((JSBNG_Record.set)(meta, (\"JSBNG__content\"), \"origin\"));\n        JSBNG__setTimeout(((function() {\n            var s28879714450be6a27c1abfe326e44e49840aca82_1_instance;\n            ((s28879714450be6a27c1abfe326e44e49840aca82_1_instance) = ((JSBNG_Record.eventInstance)((\"s28879714450be6a27c1abfe326e44e49840aca82_1\"))));\n            return ((JSBNG_Record.markFunction)((function() {\n                if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                    return ((JSBNG_Record.eventCall)((arguments.callee), (\"s28879714450be6a27c1abfe326e44e49840aca82_1\"), (s28879714450be6a27c1abfe326e44e49840aca82_1_instance), (this), (arguments)))\n                };\n                (null);\n                ((JSBNG_Record.set)(meta, (\"JSBNG__content\"), \"default\"));\n            })));\n        })()), 100);\n        var attribute = \"href\";\n        var ms = (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"match\")))[(\"match\")])(/([\\\\?|&]f=)([^&]*)/);\n        if (ms) {\n            (((JSBNG_Record.get)(this, (\"setAttribute\")))[(\"setAttribute\")])(attribute, (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"replace\")))[(\"replace\")])(/[\\\\?|&]f=[^&]*/, ((((JSBNG_Record.get)(ms, 1))[1]) + 0)));\n        }\n        ;\n        ;\n        var attribute = \"href\";\n        var sig = (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"match\")))[(\"match\")])(/([\\\\?|&]sig=)([^&]*)/);\n        if (sig) {\n            (((JSBNG_Record.get)(this, (\"setAttribute\")))[(\"setAttribute\")])(attribute, (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"replace\")))[(\"replace\")])(/[\\\\?|&]sig=[^&]*/, ((((JSBNG_Record.get)(sig, 1))[1]) + (((((JSBNG_Record.get)(Math, (\"floor\")))[(\"floor\")])(((((JSBNG_Record.get)(Math, (\"JSBNG__random\")))[(\"JSBNG__random\")])() * 65535)) + 65536)))));\n        }\n        ;\n        ;\n    };\n    var s28879714450be6a27c1abfe326e44e49840aca82_0_instance;\n    ((s28879714450be6a27c1abfe326e44e49840aca82_0_instance) = ((JSBNG_Record.eventInstance)((\"s28879714450be6a27c1abfe326e44e49840aca82_0\"))));\n    ((JSBNG_Record.markFunction)((e2c113a9a386ab849c906a9d56b8165fc46d98f19)));\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};</script><a class=\"forceLTR emuEvent1 -cx-PUBLIC-fbEmu__link image fbEmuImage -cx-PRIVATE-uiImageBlock__image -cx-PRIVATE-uiImageBlock__mediumimage lfloat\" tabindex=\"-1\" href=\"/ajax/emu/end.php?eid=AQLVAEr0JNIXHSlB-t1lt9Eixl6c4gkbuzVzVjL2frflXuYtFtrkvniUnm1Ku41tGCz7o3_vAgaHc_cm0KSk80Qn5KeG7SBu4gMjRWo6WTgHRYBuM5oy8HMWqE2Pc679lHqnSR_shRQD-voE8av-VW6uhejuFIKsYxQla8mJLMIcQjP3YwlX6FBEpi3IVDI7GysDpA3w55At5HB5Z4onn49-VAvhzAroPkfTP4ed7wRi6oKUIM0AwqhWvC3FrpzbYJQIbYePYuwGg0CAbWsYVqmHHIDp2LDaZf1MyEHBSB4edMf2GSbcR0dckr9I7r5wjuhr0MNu6x1Sc-gKyyTNy7OlvCvkzo0KCx0W1IEMqrzTB5bUX8tpAHpI2ai-deBrz8z6wERn75PMsjuCU9Y0J1OON89nEwJfV7EEAXRKUUuTa_hVHUV7ivmvG6mIgiU0MnkXdt5V_Yq68vbPMu305u-1HqvHNJG0NAcM2fCCIDcFeYVMgDQEr2FmsPA4pEM_4wzNUrZ0zXILjZEsaEiCfsHAdLK4-vtwErPb4oMyBgM-mw7Q-7Vwz7HcDAQZPCdQwsJuwcxzsevzSdBGTLem4jFqySTOWOqAaNV-Zpe_H-GNPxgrMO6TBdKDo3LC2_XdWwWmZ0_qF8qpZMvxwLLn_iJkUdQiW8CFuM3V18oROQpnqij5FULDzEPAXXPDZgW76SG2ZKac8r_z-40vmvcVwJ5vYBw692SkNfAFr2xZy4r9Q4q0bm64Ynng_cGt3oJE8ACtqbIsrMDpasTUpbDt7YNTJBLwaYHUiyNTeRtZTuLbZuKfsS43LNJyRGrlCRdnG4Hg5wZyWBEbb8RAUQ9LTS75RCdUIv4-QvEGjZQOBQYnK-xUKXm9ee6pYyx5mvDsgVg4u9QuBEvz5rnUUV8Do8JGAkD3POmEw_1OeNp0oRY-N5zuvt8cg6p_ToCKlOlbHkDyzz0xRt1Zuv4t7_6SLlzBFt5ctsFLL_GuXd0l6VrKKb2E9XB3s_uWtGgzMMMth1RxVfm5RhCK-T35_udWEzRHQiE1ZZ7BAtx-Bck8Bvz_rqbXRRIP6OSKdpnu7DK5CnJKNu23VXkM6CwoeAh28lMZzPSyYdJovN7ZUVbWFbSEiHfJtT8pMwvpTsDQDM9DdYJz7eERqAu_C_XDIstBY9camapiI983pIS3A3UEoTMLjb3DmgF8M5WdkJvMv_ca0oMSZg0ZBE-xMNPypKnvrxkzFgiLKBCNk6Gy0ub2919oLCHe0yhL3C533CfOBq7fAQom3JAK21VmnzsndPjbsj24&amp;f=1&amp;ui=6007957621675-id_51f2904c3d2240385237667&amp;en=1&amp;a=0&amp;sig=98096&amp;__tn__=ywv\" onmousedown=\"return e2c113a9a386ab849c906a9d56b8165fc46d98f19.call(this, event);\" aria-hidden=\"true\"><img class=\"img\" src=\"http://jsbngssl.fbcdn-creative-a.akamaihd.net/hads-ak-ash3/s110x80/708194_6005058265675_41800_n.png\" alt=\"\" /></a><div class=\"-cx-PRIVATE-uiFlexibleBlock__flexiblecontent\"><div class=\"body\"><script type=\"text/javascript\">try {\n    ((JSBNG_Record.scriptLoad)((\"function e7578d897dcc8420ac71be4b933b99feca73e313c(event) {\\u000a    var meta = document.getElementById(\\\"meta_referrer\\\");\\u000a    meta.content = \\\"origin\\\";\\u000a    setTimeout(function() {\\u000a        meta.content = \\\"default\\\";\\u000a    }, 100);\\u000a    var attribute = \\\"href\\\";\\u000a    var ms = this.getAttribute(attribute).match(/([\\\\\\\\?|&]f=)([^&]*)/);\\u000a    if (ms) {\\u000a        this.setAttribute(attribute, this.getAttribute(attribute).replace(/[\\\\\\\\?|&]f=[^&]*/, (ms[1] + 0)));\\u000a    }\\u000a;\\u000a;\\u000a    var attribute = \\\"href\\\";\\u000a    var sig = this.getAttribute(attribute).match(/([\\\\\\\\?|&]sig=)([^&]*)/);\\u000a    if (sig) {\\u000a        this.setAttribute(attribute, this.getAttribute(attribute).replace(/[\\\\\\\\?|&]sig=[^&]*/, (sig[1] + ((Math.floor((Math.random() * 65535)) + 65536)))));\\u000a    }\\u000a;\\u000a;\\u000a};\"), (\"s03d5bc389712dc8fc1b5e4a7645b421017cf8073\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    function e7578d897dcc8420ac71be4b933b99feca73e313c(JSBNG__event) {\n        if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n            return ((JSBNG_Record.eventCall)((arguments.callee), (\"s03d5bc389712dc8fc1b5e4a7645b421017cf8073_0\"), (s03d5bc389712dc8fc1b5e4a7645b421017cf8073_0_instance), (this), (arguments)))\n        };\n        (null);\n        var meta = (((JSBNG_Record.get)(JSBNG__document, (\"getElementById\")))[(\"getElementById\")])(\"meta_referrer\");\n        ((JSBNG_Record.set)(meta, (\"JSBNG__content\"), \"origin\"));\n        JSBNG__setTimeout(((function() {\n            var s03d5bc389712dc8fc1b5e4a7645b421017cf8073_1_instance;\n            ((s03d5bc389712dc8fc1b5e4a7645b421017cf8073_1_instance) = ((JSBNG_Record.eventInstance)((\"s03d5bc389712dc8fc1b5e4a7645b421017cf8073_1\"))));\n            return ((JSBNG_Record.markFunction)((function() {\n                if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                    return ((JSBNG_Record.eventCall)((arguments.callee), (\"s03d5bc389712dc8fc1b5e4a7645b421017cf8073_1\"), (s03d5bc389712dc8fc1b5e4a7645b421017cf8073_1_instance), (this), (arguments)))\n                };\n                (null);\n                ((JSBNG_Record.set)(meta, (\"JSBNG__content\"), \"default\"));\n            })));\n        })()), 100);\n        var attribute = \"href\";\n        var ms = (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"match\")))[(\"match\")])(/([\\\\?|&]f=)([^&]*)/);\n        if (ms) {\n            (((JSBNG_Record.get)(this, (\"setAttribute\")))[(\"setAttribute\")])(attribute, (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"replace\")))[(\"replace\")])(/[\\\\?|&]f=[^&]*/, ((((JSBNG_Record.get)(ms, 1))[1]) + 0)));\n        }\n        ;\n        ;\n        var attribute = \"href\";\n        var sig = (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"match\")))[(\"match\")])(/([\\\\?|&]sig=)([^&]*)/);\n        if (sig) {\n            (((JSBNG_Record.get)(this, (\"setAttribute\")))[(\"setAttribute\")])(attribute, (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"replace\")))[(\"replace\")])(/[\\\\?|&]sig=[^&]*/, ((((JSBNG_Record.get)(sig, 1))[1]) + (((((JSBNG_Record.get)(Math, (\"floor\")))[(\"floor\")])(((((JSBNG_Record.get)(Math, (\"JSBNG__random\")))[(\"JSBNG__random\")])() * 65535)) + 65536)))));\n        }\n        ;\n        ;\n    };\n    var s03d5bc389712dc8fc1b5e4a7645b421017cf8073_0_instance;\n    ((s03d5bc389712dc8fc1b5e4a7645b421017cf8073_0_instance) = ((JSBNG_Record.eventInstance)((\"s03d5bc389712dc8fc1b5e4a7645b421017cf8073_0\"))));\n    ((JSBNG_Record.markFunction)((e7578d897dcc8420ac71be4b933b99feca73e313c)));\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};</script><a class=\"forceLTR emuEvent1 -cx-PUBLIC-fbEmu__link\" href=\"/ajax/emu/end.php?eid=AQLVAEr0JNIXHSlB-t1lt9Eixl6c4gkbuzVzVjL2frflXuYtFtrkvniUnm1Ku41tGCz7o3_vAgaHc_cm0KSk80Qn5KeG7SBu4gMjRWo6WTgHRYBuM5oy8HMWqE2Pc679lHqnSR_shRQD-voE8av-VW6uhejuFIKsYxQla8mJLMIcQjP3YwlX6FBEpi3IVDI7GysDpA3w55At5HB5Z4onn49-VAvhzAroPkfTP4ed7wRi6oKUIM0AwqhWvC3FrpzbYJQIbYePYuwGg0CAbWsYVqmHHIDp2LDaZf1MyEHBSB4edMf2GSbcR0dckr9I7r5wjuhr0MNu6x1Sc-gKyyTNy7OlvCvkzo0KCx0W1IEMqrzTB5bUX8tpAHpI2ai-deBrz8z6wERn75PMsjuCU9Y0J1OON89nEwJfV7EEAXRKUUuTa_hVHUV7ivmvG6mIgiU0MnkXdt5V_Yq68vbPMu305u-1HqvHNJG0NAcM2fCCIDcFeYVMgDQEr2FmsPA4pEM_4wzNUrZ0zXILjZEsaEiCfsHAdLK4-vtwErPb4oMyBgM-mw7Q-7Vwz7HcDAQZPCdQwsJuwcxzsevzSdBGTLem4jFqySTOWOqAaNV-Zpe_H-GNPxgrMO6TBdKDo3LC2_XdWwWmZ0_qF8qpZMvxwLLn_iJkUdQiW8CFuM3V18oROQpnqij5FULDzEPAXXPDZgW76SG2ZKac8r_z-40vmvcVwJ5vYBw692SkNfAFr2xZy4r9Q4q0bm64Ynng_cGt3oJE8ACtqbIsrMDpasTUpbDt7YNTJBLwaYHUiyNTeRtZTuLbZuKfsS43LNJyRGrlCRdnG4Hg5wZyWBEbb8RAUQ9LTS75RCdUIv4-QvEGjZQOBQYnK-xUKXm9ee6pYyx5mvDsgVg4u9QuBEvz5rnUUV8Do8JGAkD3POmEw_1OeNp0oRY-N5zuvt8cg6p_ToCKlOlbHkDyzz0xRt1Zuv4t7_6SLlzBFt5ctsFLL_GuXd0l6VrKKb2E9XB3s_uWtGgzMMMth1RxVfm5RhCK-T35_udWEzRHQiE1ZZ7BAtx-Bck8Bvz_rqbXRRIP6OSKdpnu7DK5CnJKNu23VXkM6CwoeAh28lMZzPSyYdJovN7ZUVbWFbSEiHfJtT8pMwvpTsDQDM9DdYJz7eERqAu_C_XDIstBY9camapiI983pIS3A3UEoTMLjb3DmgF8M5WdkJvMv_ca0oMSZg0ZBE-xMNPypKnvrxkzFgiLKBCNk6Gy0ub2919oLCHe0yhL3C533CfOBq7fAQom3JAK21VmnzsndPjbsj24&amp;f=1&amp;ui=6007957621675-id_51f2904c3d2240385237667&amp;en=1&amp;a=0&amp;sig=95219&amp;__tn__=xywv\" onmousedown=\"return e7578d897dcc8420ac71be4b933b99feca73e313c.call(this, event);\">Thousands of local singles just one click away. Start now and find the date that fits you.</a></div></div></div><div class=\"inline\"><div class=\"action\"><script type=\"text/javascript\">try {\n    ((JSBNG_Record.scriptLoad)((\"function e4c076a8f5a071f71549aed1a9c22793adf19833a(event) {\\u000a    var meta = document.getElementById(\\\"meta_referrer\\\");\\u000a    meta.content = \\\"origin\\\";\\u000a    setTimeout(function() {\\u000a        meta.content = \\\"default\\\";\\u000a    }, 100);\\u000a    var attribute = \\\"href\\\";\\u000a    var ms = this.getAttribute(attribute).match(/([\\\\\\\\?|&]f=)([^&]*)/);\\u000a    if (ms) {\\u000a        this.setAttribute(attribute, this.getAttribute(attribute).replace(/[\\\\\\\\?|&]f=[^&]*/, (ms[1] + 0)));\\u000a    }\\u000a;\\u000a;\\u000a    var attribute = \\\"href\\\";\\u000a    var sig = this.getAttribute(attribute).match(/([\\\\\\\\?|&]sig=)([^&]*)/);\\u000a    if (sig) {\\u000a        this.setAttribute(attribute, this.getAttribute(attribute).replace(/[\\\\\\\\?|&]sig=[^&]*/, (sig[1] + ((Math.floor((Math.random() * 65535)) + 65536)))));\\u000a    }\\u000a;\\u000a;\\u000a};\"), (\"s07c77755fb0c3aa604c7a1ed60f8b0077299f67d\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    function e4c076a8f5a071f71549aed1a9c22793adf19833a(JSBNG__event) {\n        if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n            return ((JSBNG_Record.eventCall)((arguments.callee), (\"s07c77755fb0c3aa604c7a1ed60f8b0077299f67d_0\"), (s07c77755fb0c3aa604c7a1ed60f8b0077299f67d_0_instance), (this), (arguments)))\n        };\n        (null);\n        var meta = (((JSBNG_Record.get)(JSBNG__document, (\"getElementById\")))[(\"getElementById\")])(\"meta_referrer\");\n        ((JSBNG_Record.set)(meta, (\"JSBNG__content\"), \"origin\"));\n        JSBNG__setTimeout(((function() {\n            var s07c77755fb0c3aa604c7a1ed60f8b0077299f67d_1_instance;\n            ((s07c77755fb0c3aa604c7a1ed60f8b0077299f67d_1_instance) = ((JSBNG_Record.eventInstance)((\"s07c77755fb0c3aa604c7a1ed60f8b0077299f67d_1\"))));\n            return ((JSBNG_Record.markFunction)((function() {\n                if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                    return ((JSBNG_Record.eventCall)((arguments.callee), (\"s07c77755fb0c3aa604c7a1ed60f8b0077299f67d_1\"), (s07c77755fb0c3aa604c7a1ed60f8b0077299f67d_1_instance), (this), (arguments)))\n                };\n                (null);\n                ((JSBNG_Record.set)(meta, (\"JSBNG__content\"), \"default\"));\n            })));\n        })()), 100);\n        var attribute = \"href\";\n        var ms = (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"match\")))[(\"match\")])(/([\\\\?|&]f=)([^&]*)/);\n        if (ms) {\n            (((JSBNG_Record.get)(this, (\"setAttribute\")))[(\"setAttribute\")])(attribute, (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"replace\")))[(\"replace\")])(/[\\\\?|&]f=[^&]*/, ((((JSBNG_Record.get)(ms, 1))[1]) + 0)));\n        }\n        ;\n        ;\n        var attribute = \"href\";\n        var sig = (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"match\")))[(\"match\")])(/([\\\\?|&]sig=)([^&]*)/);\n        if (sig) {\n            (((JSBNG_Record.get)(this, (\"setAttribute\")))[(\"setAttribute\")])(attribute, (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"replace\")))[(\"replace\")])(/[\\\\?|&]sig=[^&]*/, ((((JSBNG_Record.get)(sig, 1))[1]) + (((((JSBNG_Record.get)(Math, (\"floor\")))[(\"floor\")])(((((JSBNG_Record.get)(Math, (\"JSBNG__random\")))[(\"JSBNG__random\")])() * 65535)) + 65536)))));\n        }\n        ;\n        ;\n    };\n    var s07c77755fb0c3aa604c7a1ed60f8b0077299f67d_0_instance;\n    ((s07c77755fb0c3aa604c7a1ed60f8b0077299f67d_0_instance) = ((JSBNG_Record.eventInstance)((\"s07c77755fb0c3aa604c7a1ed60f8b0077299f67d_0\"))));\n    ((JSBNG_Record.markFunction)((e4c076a8f5a071f71549aed1a9c22793adf19833a)));\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};</script><a class=\"uiIconText emuEvent1 -cx-PUBLIC-fbEmu__link\" href=\"/ajax/emu/end.php?eid=AQLVAEr0JNIXHSlB-t1lt9Eixl6c4gkbuzVzVjL2frflXuYtFtrkvniUnm1Ku41tGCz7o3_vAgaHc_cm0KSk80Qn5KeG7SBu4gMjRWo6WTgHRYBuM5oy8HMWqE2Pc679lHqnSR_shRQD-voE8av-VW6uhejuFIKsYxQla8mJLMIcQjP3YwlX6FBEpi3IVDI7GysDpA3w55At5HB5Z4onn49-VAvhzAroPkfTP4ed7wRi6oKUIM0AwqhWvC3FrpzbYJQIbYePYuwGg0CAbWsYVqmHHIDp2LDaZf1MyEHBSB4edMf2GSbcR0dckr9I7r5wjuhr0MNu6x1Sc-gKyyTNy7OlvCvkzo0KCx0W1IEMqrzTB5bUX8tpAHpI2ai-deBrz8z6wERn75PMsjuCU9Y0J1OON89nEwJfV7EEAXRKUUuTa_hVHUV7ivmvG6mIgiU0MnkXdt5V_Yq68vbPMu305u-1HqvHNJG0NAcM2fCCIDcFeYVMgDQEr2FmsPA4pEM_4wzNUrZ0zXILjZEsaEiCfsHAdLK4-vtwErPb4oMyBgM-mw7Q-7Vwz7HcDAQZPCdQwsJuwcxzsevzSdBGTLem4jFqySTOWOqAaNV-Zpe_H-GNPxgrMO6TBdKDo3LC2_XdWwWmZ0_qF8qpZMvxwLLn_iJkUdQiW8CFuM3V18oROQpnqij5FULDzEPAXXPDZgW76SG2ZKac8r_z-40vmvcVwJ5vYBw692SkNfAFr2xZy4r9Q4q0bm64Ynng_cGt3oJE8ACtqbIsrMDpasTUpbDt7YNTJBLwaYHUiyNTeRtZTuLbZuKfsS43LNJyRGrlCRdnG4Hg5wZyWBEbb8RAUQ9LTS75RCdUIv4-QvEGjZQOBQYnK-xUKXm9ee6pYyx5mvDsgVg4u9QuBEvz5rnUUV8Do8JGAkD3POmEw_1OeNp0oRY-N5zuvt8cg6p_ToCKlOlbHkDyzz0xRt1Zuv4t7_6SLlzBFt5ctsFLL_GuXd0l6VrKKb2E9XB3s_uWtGgzMMMth1RxVfm5RhCK-T35_udWEzRHQiE1ZZ7BAtx-Bck8Bvz_rqbXRRIP6OSKdpnu7DK5CnJKNu23VXkM6CwoeAh28lMZzPSyYdJovN7ZUVbWFbSEiHfJtT8pMwvpTsDQDM9DdYJz7eERqAu_C_XDIstBY9camapiI983pIS3A3UEoTMLjb3DmgF8M5WdkJvMv_ca0oMSZg0ZBE-xMNPypKnvrxkzFgiLKBCNk6Gy0ub2919oLCHe0yhL3C533CfOBq7fAQom3JAK21VmnzsndPjbsj24&amp;f=1&amp;ui=6007957621675-id_51f2904c3d2240385237667&amp;en=1&amp;a=0&amp;sig=127391&amp;__tn__=wv\" onmousedown=\"return e4c076a8f5a071f71549aed1a9c22793adf19833a.call(this, event);\"><i class=\"img sp_3yt8ar sx_b302f8\"></i>Use Now</a> · <span class=\"fbEmuContext\">5,000,000 people used <script type=\"text/javascript\">try {\n    ((JSBNG_Record.scriptLoad)((\"function e97629af3e63a9ce7d51401e7006d11e445ebd382(event) {\\u000a    var meta = document.getElementById(\\\"meta_referrer\\\");\\u000a    meta.content = \\\"origin\\\";\\u000a    setTimeout(function() {\\u000a        meta.content = \\\"default\\\";\\u000a    }, 100);\\u000a    var attribute = \\\"href\\\";\\u000a    var ms = this.getAttribute(attribute).match(/([\\\\\\\\?|&]f=)([^&]*)/);\\u000a    if (ms) {\\u000a        this.setAttribute(attribute, this.getAttribute(attribute).replace(/[\\\\\\\\?|&]f=[^&]*/, (ms[1] + 0)));\\u000a    }\\u000a;\\u000a;\\u000a    var attribute = \\\"href\\\";\\u000a    var sig = this.getAttribute(attribute).match(/([\\\\\\\\?|&]sig=)([^&]*)/);\\u000a    if (sig) {\\u000a        this.setAttribute(attribute, this.getAttribute(attribute).replace(/[\\\\\\\\?|&]sig=[^&]*/, (sig[1] + ((Math.floor((Math.random() * 65535)) + 65536)))));\\u000a    }\\u000a;\\u000a;\\u000a};\"), (\"s28aaa87b44fa4424aad06df9289dc62a041116fd\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    function e97629af3e63a9ce7d51401e7006d11e445ebd382(JSBNG__event) {\n        if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n            return ((JSBNG_Record.eventCall)((arguments.callee), (\"s28aaa87b44fa4424aad06df9289dc62a041116fd_0\"), (s28aaa87b44fa4424aad06df9289dc62a041116fd_0_instance), (this), (arguments)))\n        };\n        (null);\n        var meta = (((JSBNG_Record.get)(JSBNG__document, (\"getElementById\")))[(\"getElementById\")])(\"meta_referrer\");\n        ((JSBNG_Record.set)(meta, (\"JSBNG__content\"), \"origin\"));\n        JSBNG__setTimeout(((function() {\n            var s28aaa87b44fa4424aad06df9289dc62a041116fd_1_instance;\n            ((s28aaa87b44fa4424aad06df9289dc62a041116fd_1_instance) = ((JSBNG_Record.eventInstance)((\"s28aaa87b44fa4424aad06df9289dc62a041116fd_1\"))));\n            return ((JSBNG_Record.markFunction)((function() {\n                if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                    return ((JSBNG_Record.eventCall)((arguments.callee), (\"s28aaa87b44fa4424aad06df9289dc62a041116fd_1\"), (s28aaa87b44fa4424aad06df9289dc62a041116fd_1_instance), (this), (arguments)))\n                };\n                (null);\n                ((JSBNG_Record.set)(meta, (\"JSBNG__content\"), \"default\"));\n            })));\n        })()), 100);\n        var attribute = \"href\";\n        var ms = (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"match\")))[(\"match\")])(/([\\\\?|&]f=)([^&]*)/);\n        if (ms) {\n            (((JSBNG_Record.get)(this, (\"setAttribute\")))[(\"setAttribute\")])(attribute, (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"replace\")))[(\"replace\")])(/[\\\\?|&]f=[^&]*/, ((((JSBNG_Record.get)(ms, 1))[1]) + 0)));\n        }\n        ;\n        ;\n        var attribute = \"href\";\n        var sig = (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"match\")))[(\"match\")])(/([\\\\?|&]sig=)([^&]*)/);\n        if (sig) {\n            (((JSBNG_Record.get)(this, (\"setAttribute\")))[(\"setAttribute\")])(attribute, (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"replace\")))[(\"replace\")])(/[\\\\?|&]sig=[^&]*/, ((((JSBNG_Record.get)(sig, 1))[1]) + (((((JSBNG_Record.get)(Math, (\"floor\")))[(\"floor\")])(((((JSBNG_Record.get)(Math, (\"JSBNG__random\")))[(\"JSBNG__random\")])() * 65535)) + 65536)))));\n        }\n        ;\n        ;\n    };\n    var s28aaa87b44fa4424aad06df9289dc62a041116fd_0_instance;\n    ((s28aaa87b44fa4424aad06df9289dc62a041116fd_0_instance) = ((JSBNG_Record.eventInstance)((\"s28aaa87b44fa4424aad06df9289dc62a041116fd_0\"))));\n    ((JSBNG_Record.markFunction)((e97629af3e63a9ce7d51401e7006d11e445ebd382)));\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};</script><a class=\"emuEvent1 -cx-PUBLIC-fbEmu__link\" href=\"/ajax/emu/end.php?eid=AQLVAEr0JNIXHSlB-t1lt9Eixl6c4gkbuzVzVjL2frflXuYtFtrkvniUnm1Ku41tGCz7o3_vAgaHc_cm0KSk80Qn5KeG7SBu4gMjRWo6WTgHRYBuM5oy8HMWqE2Pc679lHqnSR_shRQD-voE8av-VW6uhejuFIKsYxQla8mJLMIcQjP3YwlX6FBEpi3IVDI7GysDpA3w55At5HB5Z4onn49-VAvhzAroPkfTP4ed7wRi6oKUIM0AwqhWvC3FrpzbYJQIbYePYuwGg0CAbWsYVqmHHIDp2LDaZf1MyEHBSB4edMf2GSbcR0dckr9I7r5wjuhr0MNu6x1Sc-gKyyTNy7OlvCvkzo0KCx0W1IEMqrzTB5bUX8tpAHpI2ai-deBrz8z6wERn75PMsjuCU9Y0J1OON89nEwJfV7EEAXRKUUuTa_hVHUV7ivmvG6mIgiU0MnkXdt5V_Yq68vbPMu305u-1HqvHNJG0NAcM2fCCIDcFeYVMgDQEr2FmsPA4pEM_4wzNUrZ0zXILjZEsaEiCfsHAdLK4-vtwErPb4oMyBgM-mw7Q-7Vwz7HcDAQZPCdQwsJuwcxzsevzSdBGTLem4jFqySTOWOqAaNV-Zpe_H-GNPxgrMO6TBdKDo3LC2_XdWwWmZ0_qF8qpZMvxwLLn_iJkUdQiW8CFuM3V18oROQpnqij5FULDzEPAXXPDZgW76SG2ZKac8r_z-40vmvcVwJ5vYBw692SkNfAFr2xZy4r9Q4q0bm64Ynng_cGt3oJE8ACtqbIsrMDpasTUpbDt7YNTJBLwaYHUiyNTeRtZTuLbZuKfsS43LNJyRGrlCRdnG4Hg5wZyWBEbb8RAUQ9LTS75RCdUIv4-QvEGjZQOBQYnK-xUKXm9ee6pYyx5mvDsgVg4u9QuBEvz5rnUUV8Do8JGAkD3POmEw_1OeNp0oRY-N5zuvt8cg6p_ToCKlOlbHkDyzz0xRt1Zuv4t7_6SLlzBFt5ctsFLL_GuXd0l6VrKKb2E9XB3s_uWtGgzMMMth1RxVfm5RhCK-T35_udWEzRHQiE1ZZ7BAtx-Bck8Bvz_rqbXRRIP6OSKdpnu7DK5CnJKNu23VXkM6CwoeAh28lMZzPSyYdJovN7ZUVbWFbSEiHfJtT8pMwvpTsDQDM9DdYJz7eERqAu_C_XDIstBY9camapiI983pIS3A3UEoTMLjb3DmgF8M5WdkJvMv_ca0oMSZg0ZBE-xMNPypKnvrxkzFgiLKBCNk6Gy0ub2919oLCHe0yhL3C533CfOBq7fAQom3JAK21VmnzsndPjbsj24&amp;f=1&amp;ui=6007957621675-id_51f2904c3d2240385237667&amp;en=1&amp;a=0&amp;sig=70865&amp;__tn__=%7Bzwv\" onmousedown=\"return e97629af3e63a9ce7d51401e7006d11e445ebd382.call(this, event);\">Zoosk</a>.</span></div></div></div></div></div><div class=\"ego_unit\" data-ego-fbid=\"6007651357550\"><div class=\"-cx-PUBLIC-fbAdUnit__root\" data-ad=\"&#123;&quot;adid&quot;:6007651357550,&quot;segment&quot;:&quot;market&quot;&#125;\" id=\"6007651357550-id_51f2904c3d26e5462905510\"><div class=\"-cx-PRIVATE-fbEmu__root -cx-PRIVATE-fbEmuEgo__unit\"><div class=\"uiSelector inlineBlock emu_x emuEventfad_hide -cx-PUBLIC-fbEmu__link uiSelectorRight\"><div class=\"uiToggle wrap\"><a class=\"uiSelectorButton uiCloseButton uiCloseButtonSmall\" href=\"#\" role=\"button\" title=\"About Facebook Ads\" rel=\"toggle\" ajaxify=\"/ajax/emu/end.php?eid=AQL1hMzGDmRq_jGTMlTKJmQ1tWzYqTX1hYaAqONxRw3GgGVHJ_gEb1mb_22W5RpjgPEvYQ6iUHKM7Zuyyyv0Cx5BMJPL788LwavUCp3eJO8EIfVcxsQxPEH65GZjzV8kd4cWTTBMtGV-ANChcFXZuY8pHwWEiGUZ037op7NgKVbOrBiq05kvjf9hNdk3-hEsflaGS1qDa89TjbLLOnKvBAXLgKaND10JtJptCNAq_FX7KuYV-WaG8ad1w2eDAqNch7LzuY7MzJT97imgiE0sE-hCSyZ7L7NQaeYtI6MrSEbqfKUe6SRgrrM66reyGiG6ixLR8kY1MdYRUfVJhoTf5lC_vekk8XdUHnTZfwze7pntL0e4WiAIeYIJwwvDxNZHwdWA0M6gXt6fUoyTEIYwqBdeaI2HtSujVcAqzPUNF9hp-m6Yf0xSf-orKOPv1-cxlFkE8qy3BIEzYNyB99gNIfdtaS3YuDT6x4gQIBGW4dnW0gWm88TzKhSkRfIJ8sW8L2PDPQ31mjN9_drR6NUQ0-L7-HrJpT3pTzqjJvdw8HVUwpDalb_MQ76ZhQ4A16iLvdV82D_530cZVYMA_T4Dh8eG4qlJzhU-qV10H6Iho0o47_ZeTJ8QLN_qvlSH9RHC6nsBwS7AAcbOHcAsp8wytPlE6nOrnR33s0ux81AAMhHPs1BKPbiC92mL6F9OAD6GfKPQxmS9g8G0V_8XikoObEJ1QzBF4jXejZ3-QZlUC8erxDfVLI2bOciLhwSefJl62CSFoQSLqzbF9Y5UgWRui190UNVDmRhONFD7ivW6YEX5iuYcY52eWyvQr32D_vA0uQOFRlklRgzNzyRLDmHVThIZYNwK_5JJvpRNLLEk8ILjYNU3inUUT4-SknA3VOUsEm8XNbSvhDuHqaIZKcV0ISy2dNO73ZPV1W1RosDZ_pcjYimQlQNjD-jOkXr-oVAqdwLLzowm2L0naT4FOzFosY28eKIWEkVkg_G0Na62L44u5PngWfy8SAgrfY7ZLEGVvbU4-3Ssh8aquPUTO6M8dNxJzdN0DXyoWJTNwW8GUD8gpqailll2w70R20ZWeSka1HaYxnlv9p_n_dCO64QjzEdPwg0l_3MtQDtx3LGquGoVBlR_neZYW5dKUYXDqEzMd8dMdqM6YcOYkLpE9RR3wAhqJVt-MCp7ZkitmQJ5adNq5_gB6TuQrNQVtY2qaoxckZsbrXlUFN2uEOGw31F0BEKD8FKbuWEyh5vUo5AG0G1Oo6QO1_kc8GJxPEkPXuzF1EwykkwuNPJZTWNJX5f-K_7W&amp;f=0&amp;ui=6007651357550-id_51f2904c3d26e5462905510&amp;en=fad_hide&amp;ed=true&amp;a=1&amp;__tn__=v\" aria-haspopup=\"1\"></a></div></div><div class=\"title\"><script type=\"text/javascript\">try {\n    ((JSBNG_Record.scriptLoad)((\"function e8b07f25afabdb3609d715b9f07ba140eb225b64e(event) {\\u000a    var meta = document.getElementById(\\\"meta_referrer\\\");\\u000a    meta.content = \\\"origin\\\";\\u000a    setTimeout(function() {\\u000a        meta.content = \\\"default\\\";\\u000a    }, 100);\\u000a    var attribute = \\\"href\\\";\\u000a    var ms = this.getAttribute(attribute).match(/([\\\\\\\\?|&]f=)([^&]*)/);\\u000a    if (ms) {\\u000a        this.setAttribute(attribute, this.getAttribute(attribute).replace(/[\\\\\\\\?|&]f=[^&]*/, (ms[1] + 0)));\\u000a    }\\u000a;\\u000a;\\u000a    var attribute = \\\"href\\\";\\u000a    var sig = this.getAttribute(attribute).match(/([\\\\\\\\?|&]sig=)([^&]*)/);\\u000a    if (sig) {\\u000a        this.setAttribute(attribute, this.getAttribute(attribute).replace(/[\\\\\\\\?|&]sig=[^&]*/, (sig[1] + ((Math.floor((Math.random() * 65535)) + 65536)))));\\u000a    }\\u000a;\\u000a;\\u000a};\"), (\"s08def55b89d61e64d4e002341f5538931eae4578\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    function e8b07f25afabdb3609d715b9f07ba140eb225b64e(JSBNG__event) {\n        if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n            return ((JSBNG_Record.eventCall)((arguments.callee), (\"s08def55b89d61e64d4e002341f5538931eae4578_0\"), (s08def55b89d61e64d4e002341f5538931eae4578_0_instance), (this), (arguments)))\n        };\n        (null);\n        var meta = (((JSBNG_Record.get)(JSBNG__document, (\"getElementById\")))[(\"getElementById\")])(\"meta_referrer\");\n        ((JSBNG_Record.set)(meta, (\"JSBNG__content\"), \"origin\"));\n        JSBNG__setTimeout(((function() {\n            var s08def55b89d61e64d4e002341f5538931eae4578_1_instance;\n            ((s08def55b89d61e64d4e002341f5538931eae4578_1_instance) = ((JSBNG_Record.eventInstance)((\"s08def55b89d61e64d4e002341f5538931eae4578_1\"))));\n            return ((JSBNG_Record.markFunction)((function() {\n                if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                    return ((JSBNG_Record.eventCall)((arguments.callee), (\"s08def55b89d61e64d4e002341f5538931eae4578_1\"), (s08def55b89d61e64d4e002341f5538931eae4578_1_instance), (this), (arguments)))\n                };\n                (null);\n                ((JSBNG_Record.set)(meta, (\"JSBNG__content\"), \"default\"));\n            })));\n        })()), 100);\n        var attribute = \"href\";\n        var ms = (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"match\")))[(\"match\")])(/([\\\\?|&]f=)([^&]*)/);\n        if (ms) {\n            (((JSBNG_Record.get)(this, (\"setAttribute\")))[(\"setAttribute\")])(attribute, (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"replace\")))[(\"replace\")])(/[\\\\?|&]f=[^&]*/, ((((JSBNG_Record.get)(ms, 1))[1]) + 0)));\n        }\n        ;\n        ;\n        var attribute = \"href\";\n        var sig = (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"match\")))[(\"match\")])(/([\\\\?|&]sig=)([^&]*)/);\n        if (sig) {\n            (((JSBNG_Record.get)(this, (\"setAttribute\")))[(\"setAttribute\")])(attribute, (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"replace\")))[(\"replace\")])(/[\\\\?|&]sig=[^&]*/, ((((JSBNG_Record.get)(sig, 1))[1]) + (((((JSBNG_Record.get)(Math, (\"floor\")))[(\"floor\")])(((((JSBNG_Record.get)(Math, (\"JSBNG__random\")))[(\"JSBNG__random\")])() * 65535)) + 65536)))));\n        }\n        ;\n        ;\n    };\n    var s08def55b89d61e64d4e002341f5538931eae4578_0_instance;\n    ((s08def55b89d61e64d4e002341f5538931eae4578_0_instance) = ((JSBNG_Record.eventInstance)((\"s08def55b89d61e64d4e002341f5538931eae4578_0\"))));\n    ((JSBNG_Record.markFunction)((e8b07f25afabdb3609d715b9f07ba140eb225b64e)));\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};</script><a class=\"forceLTR emuEvent1 -cx-PUBLIC-fbEmu__link\" href=\"/ajax/emu/end.php?eid=AQL1hMzGDmRq_jGTMlTKJmQ1tWzYqTX1hYaAqONxRw3GgGVHJ_gEb1mb_22W5RpjgPEvYQ6iUHKM7Zuyyyv0Cx5BMJPL788LwavUCp3eJO8EIfVcxsQxPEH65GZjzV8kd4cWTTBMtGV-ANChcFXZuY8pHwWEiGUZ037op7NgKVbOrBiq05kvjf9hNdk3-hEsflaGS1qDa89TjbLLOnKvBAXLgKaND10JtJptCNAq_FX7KuYV-WaG8ad1w2eDAqNch7LzuY7MzJT97imgiE0sE-hCSyZ7L7NQaeYtI6MrSEbqfKUe6SRgrrM66reyGiG6ixLR8kY1MdYRUfVJhoTf5lC_vekk8XdUHnTZfwze7pntL0e4WiAIeYIJwwvDxNZHwdWA0M6gXt6fUoyTEIYwqBdeaI2HtSujVcAqzPUNF9hp-m6Yf0xSf-orKOPv1-cxlFkE8qy3BIEzYNyB99gNIfdtaS3YuDT6x4gQIBGW4dnW0gWm88TzKhSkRfIJ8sW8L2PDPQ31mjN9_drR6NUQ0-L7-HrJpT3pTzqjJvdw8HVUwpDalb_MQ76ZhQ4A16iLvdV82D_530cZVYMA_T4Dh8eG4qlJzhU-qV10H6Iho0o47_ZeTJ8QLN_qvlSH9RHC6nsBwS7AAcbOHcAsp8wytPlE6nOrnR33s0ux81AAMhHPs1BKPbiC92mL6F9OAD6GfKPQxmS9g8G0V_8XikoObEJ1QzBF4jXejZ3-QZlUC8erxDfVLI2bOciLhwSefJl62CSFoQSLqzbF9Y5UgWRui190UNVDmRhONFD7ivW6YEX5iuYcY52eWyvQr32D_vA0uQOFRlklRgzNzyRLDmHVThIZYNwK_5JJvpRNLLEk8ILjYNU3inUUT4-SknA3VOUsEm8XNbSvhDuHqaIZKcV0ISy2dNO73ZPV1W1RosDZ_pcjYimQlQNjD-jOkXr-oVAqdwLLzowm2L0naT4FOzFosY28eKIWEkVkg_G0Na62L44u5PngWfy8SAgrfY7ZLEGVvbU4-3Ssh8aquPUTO6M8dNxJzdN0DXyoWJTNwW8GUD8gpqailll2w70R20ZWeSka1HaYxnlv9p_n_dCO64QjzEdPwg0l_3MtQDtx3LGquGoVBlR_neZYW5dKUYXDqEzMd8dMdqM6YcOYkLpE9RR3wAhqJVt-MCp7ZkitmQJ5adNq5_gB6TuQrNQVtY2qaoxckZsbrXlUFN2uEOGw31F0BEKD8FKbuWEyh5vUo5AG0G1Oo6QO1_kc8GJxPEkPXuzF1EwykkwuNPJZTWNJX5f-K_7W&amp;f=1&amp;ui=6007651357550-id_51f2904c3d26e5462905510&amp;en=1&amp;a=0&amp;sig=71707&amp;__tn__=wv\" onmousedown=\"return e8b07f25afabdb3609d715b9f07ba140eb225b64e.call(this, event);\">Is this sweet or sour?</a></div><div class=\"clearfix image_body_block\"><script type=\"text/javascript\">try {\n    ((JSBNG_Record.scriptLoad)((\"function ef0164f2bf1fd8d8e01d41d9655c31d18bdbdaea7(event) {\\u000a    var meta = document.getElementById(\\\"meta_referrer\\\");\\u000a    meta.content = \\\"origin\\\";\\u000a    setTimeout(function() {\\u000a        meta.content = \\\"default\\\";\\u000a    }, 100);\\u000a    var attribute = \\\"href\\\";\\u000a    var ms = this.getAttribute(attribute).match(/([\\\\\\\\?|&]f=)([^&]*)/);\\u000a    if (ms) {\\u000a        this.setAttribute(attribute, this.getAttribute(attribute).replace(/[\\\\\\\\?|&]f=[^&]*/, (ms[1] + 0)));\\u000a    }\\u000a;\\u000a;\\u000a    var attribute = \\\"href\\\";\\u000a    var sig = this.getAttribute(attribute).match(/([\\\\\\\\?|&]sig=)([^&]*)/);\\u000a    if (sig) {\\u000a        this.setAttribute(attribute, this.getAttribute(attribute).replace(/[\\\\\\\\?|&]sig=[^&]*/, (sig[1] + ((Math.floor((Math.random() * 65535)) + 65536)))));\\u000a    }\\u000a;\\u000a;\\u000a};\"), (\"s290a2264d7a9097dc1470b1f1f9747457327661c\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    function ef0164f2bf1fd8d8e01d41d9655c31d18bdbdaea7(JSBNG__event) {\n        if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n            return ((JSBNG_Record.eventCall)((arguments.callee), (\"s290a2264d7a9097dc1470b1f1f9747457327661c_0\"), (s290a2264d7a9097dc1470b1f1f9747457327661c_0_instance), (this), (arguments)))\n        };\n        (null);\n        var meta = (((JSBNG_Record.get)(JSBNG__document, (\"getElementById\")))[(\"getElementById\")])(\"meta_referrer\");\n        ((JSBNG_Record.set)(meta, (\"JSBNG__content\"), \"origin\"));\n        JSBNG__setTimeout(((function() {\n            var s290a2264d7a9097dc1470b1f1f9747457327661c_1_instance;\n            ((s290a2264d7a9097dc1470b1f1f9747457327661c_1_instance) = ((JSBNG_Record.eventInstance)((\"s290a2264d7a9097dc1470b1f1f9747457327661c_1\"))));\n            return ((JSBNG_Record.markFunction)((function() {\n                if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                    return ((JSBNG_Record.eventCall)((arguments.callee), (\"s290a2264d7a9097dc1470b1f1f9747457327661c_1\"), (s290a2264d7a9097dc1470b1f1f9747457327661c_1_instance), (this), (arguments)))\n                };\n                (null);\n                ((JSBNG_Record.set)(meta, (\"JSBNG__content\"), \"default\"));\n            })));\n        })()), 100);\n        var attribute = \"href\";\n        var ms = (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"match\")))[(\"match\")])(/([\\\\?|&]f=)([^&]*)/);\n        if (ms) {\n            (((JSBNG_Record.get)(this, (\"setAttribute\")))[(\"setAttribute\")])(attribute, (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"replace\")))[(\"replace\")])(/[\\\\?|&]f=[^&]*/, ((((JSBNG_Record.get)(ms, 1))[1]) + 0)));\n        }\n        ;\n        ;\n        var attribute = \"href\";\n        var sig = (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"match\")))[(\"match\")])(/([\\\\?|&]sig=)([^&]*)/);\n        if (sig) {\n            (((JSBNG_Record.get)(this, (\"setAttribute\")))[(\"setAttribute\")])(attribute, (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"replace\")))[(\"replace\")])(/[\\\\?|&]sig=[^&]*/, ((((JSBNG_Record.get)(sig, 1))[1]) + (((((JSBNG_Record.get)(Math, (\"floor\")))[(\"floor\")])(((((JSBNG_Record.get)(Math, (\"JSBNG__random\")))[(\"JSBNG__random\")])() * 65535)) + 65536)))));\n        }\n        ;\n        ;\n    };\n    var s290a2264d7a9097dc1470b1f1f9747457327661c_0_instance;\n    ((s290a2264d7a9097dc1470b1f1f9747457327661c_0_instance) = ((JSBNG_Record.eventInstance)((\"s290a2264d7a9097dc1470b1f1f9747457327661c_0\"))));\n    ((JSBNG_Record.markFunction)((ef0164f2bf1fd8d8e01d41d9655c31d18bdbdaea7)));\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};</script><a class=\"forceLTR emuEvent1 -cx-PUBLIC-fbEmu__link image fbEmuImage -cx-PRIVATE-uiImageBlock__image -cx-PRIVATE-uiImageBlock__mediumimage lfloat\" tabindex=\"-1\" href=\"/ajax/emu/end.php?eid=AQL1hMzGDmRq_jGTMlTKJmQ1tWzYqTX1hYaAqONxRw3GgGVHJ_gEb1mb_22W5RpjgPEvYQ6iUHKM7Zuyyyv0Cx5BMJPL788LwavUCp3eJO8EIfVcxsQxPEH65GZjzV8kd4cWTTBMtGV-ANChcFXZuY8pHwWEiGUZ037op7NgKVbOrBiq05kvjf9hNdk3-hEsflaGS1qDa89TjbLLOnKvBAXLgKaND10JtJptCNAq_FX7KuYV-WaG8ad1w2eDAqNch7LzuY7MzJT97imgiE0sE-hCSyZ7L7NQaeYtI6MrSEbqfKUe6SRgrrM66reyGiG6ixLR8kY1MdYRUfVJhoTf5lC_vekk8XdUHnTZfwze7pntL0e4WiAIeYIJwwvDxNZHwdWA0M6gXt6fUoyTEIYwqBdeaI2HtSujVcAqzPUNF9hp-m6Yf0xSf-orKOPv1-cxlFkE8qy3BIEzYNyB99gNIfdtaS3YuDT6x4gQIBGW4dnW0gWm88TzKhSkRfIJ8sW8L2PDPQ31mjN9_drR6NUQ0-L7-HrJpT3pTzqjJvdw8HVUwpDalb_MQ76ZhQ4A16iLvdV82D_530cZVYMA_T4Dh8eG4qlJzhU-qV10H6Iho0o47_ZeTJ8QLN_qvlSH9RHC6nsBwS7AAcbOHcAsp8wytPlE6nOrnR33s0ux81AAMhHPs1BKPbiC92mL6F9OAD6GfKPQxmS9g8G0V_8XikoObEJ1QzBF4jXejZ3-QZlUC8erxDfVLI2bOciLhwSefJl62CSFoQSLqzbF9Y5UgWRui190UNVDmRhONFD7ivW6YEX5iuYcY52eWyvQr32D_vA0uQOFRlklRgzNzyRLDmHVThIZYNwK_5JJvpRNLLEk8ILjYNU3inUUT4-SknA3VOUsEm8XNbSvhDuHqaIZKcV0ISy2dNO73ZPV1W1RosDZ_pcjYimQlQNjD-jOkXr-oVAqdwLLzowm2L0naT4FOzFosY28eKIWEkVkg_G0Na62L44u5PngWfy8SAgrfY7ZLEGVvbU4-3Ssh8aquPUTO6M8dNxJzdN0DXyoWJTNwW8GUD8gpqailll2w70R20ZWeSka1HaYxnlv9p_n_dCO64QjzEdPwg0l_3MtQDtx3LGquGoVBlR_neZYW5dKUYXDqEzMd8dMdqM6YcOYkLpE9RR3wAhqJVt-MCp7ZkitmQJ5adNq5_gB6TuQrNQVtY2qaoxckZsbrXlUFN2uEOGw31F0BEKD8FKbuWEyh5vUo5AG0G1Oo6QO1_kc8GJxPEkPXuzF1EwykkwuNPJZTWNJX5f-K_7W&amp;f=1&amp;ui=6007651357550-id_51f2904c3d26e5462905510&amp;en=1&amp;a=0&amp;sig=121486&amp;__tn__=ywv\" onmousedown=\"return ef0164f2bf1fd8d8e01d41d9655c31d18bdbdaea7.call(this, event);\" aria-hidden=\"true\"><img class=\"img\" src=\"http://jsbngssl.fbcdn-creative-a.akamaihd.net/hads-ak-ash3/s110x80/735347_6007651190750_477676589_n.png\" alt=\"\" /></a><div class=\"-cx-PRIVATE-uiFlexibleBlock__flexiblecontent\"><div class=\"body\"><script type=\"text/javascript\">try {\n    ((JSBNG_Record.scriptLoad)((\"function ee7661523863a3beb371063b97f421fc12f5d5b5e(event) {\\u000a    var meta = document.getElementById(\\\"meta_referrer\\\");\\u000a    meta.content = \\\"origin\\\";\\u000a    setTimeout(function() {\\u000a        meta.content = \\\"default\\\";\\u000a    }, 100);\\u000a    var attribute = \\\"href\\\";\\u000a    var ms = this.getAttribute(attribute).match(/([\\\\\\\\?|&]f=)([^&]*)/);\\u000a    if (ms) {\\u000a        this.setAttribute(attribute, this.getAttribute(attribute).replace(/[\\\\\\\\?|&]f=[^&]*/, (ms[1] + 0)));\\u000a    }\\u000a;\\u000a;\\u000a    var attribute = \\\"href\\\";\\u000a    var sig = this.getAttribute(attribute).match(/([\\\\\\\\?|&]sig=)([^&]*)/);\\u000a    if (sig) {\\u000a        this.setAttribute(attribute, this.getAttribute(attribute).replace(/[\\\\\\\\?|&]sig=[^&]*/, (sig[1] + ((Math.floor((Math.random() * 65535)) + 65536)))));\\u000a    }\\u000a;\\u000a;\\u000a};\"), (\"sb9cb25ccb0016e0dea02908bd1237349e2197d82\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    function ee7661523863a3beb371063b97f421fc12f5d5b5e(JSBNG__event) {\n        if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n            return ((JSBNG_Record.eventCall)((arguments.callee), (\"sb9cb25ccb0016e0dea02908bd1237349e2197d82_0\"), (sb9cb25ccb0016e0dea02908bd1237349e2197d82_0_instance), (this), (arguments)))\n        };\n        (null);\n        var meta = (((JSBNG_Record.get)(JSBNG__document, (\"getElementById\")))[(\"getElementById\")])(\"meta_referrer\");\n        ((JSBNG_Record.set)(meta, (\"JSBNG__content\"), \"origin\"));\n        JSBNG__setTimeout(((function() {\n            var sb9cb25ccb0016e0dea02908bd1237349e2197d82_1_instance;\n            ((sb9cb25ccb0016e0dea02908bd1237349e2197d82_1_instance) = ((JSBNG_Record.eventInstance)((\"sb9cb25ccb0016e0dea02908bd1237349e2197d82_1\"))));\n            return ((JSBNG_Record.markFunction)((function() {\n                if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                    return ((JSBNG_Record.eventCall)((arguments.callee), (\"sb9cb25ccb0016e0dea02908bd1237349e2197d82_1\"), (sb9cb25ccb0016e0dea02908bd1237349e2197d82_1_instance), (this), (arguments)))\n                };\n                (null);\n                ((JSBNG_Record.set)(meta, (\"JSBNG__content\"), \"default\"));\n            })));\n        })()), 100);\n        var attribute = \"href\";\n        var ms = (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"match\")))[(\"match\")])(/([\\\\?|&]f=)([^&]*)/);\n        if (ms) {\n            (((JSBNG_Record.get)(this, (\"setAttribute\")))[(\"setAttribute\")])(attribute, (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"replace\")))[(\"replace\")])(/[\\\\?|&]f=[^&]*/, ((((JSBNG_Record.get)(ms, 1))[1]) + 0)));\n        }\n        ;\n        ;\n        var attribute = \"href\";\n        var sig = (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"match\")))[(\"match\")])(/([\\\\?|&]sig=)([^&]*)/);\n        if (sig) {\n            (((JSBNG_Record.get)(this, (\"setAttribute\")))[(\"setAttribute\")])(attribute, (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"replace\")))[(\"replace\")])(/[\\\\?|&]sig=[^&]*/, ((((JSBNG_Record.get)(sig, 1))[1]) + (((((JSBNG_Record.get)(Math, (\"floor\")))[(\"floor\")])(((((JSBNG_Record.get)(Math, (\"JSBNG__random\")))[(\"JSBNG__random\")])() * 65535)) + 65536)))));\n        }\n        ;\n        ;\n    };\n    var sb9cb25ccb0016e0dea02908bd1237349e2197d82_0_instance;\n    ((sb9cb25ccb0016e0dea02908bd1237349e2197d82_0_instance) = ((JSBNG_Record.eventInstance)((\"sb9cb25ccb0016e0dea02908bd1237349e2197d82_0\"))));\n    ((JSBNG_Record.markFunction)((ee7661523863a3beb371063b97f421fc12f5d5b5e)));\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};</script><a class=\"forceLTR emuEvent1 -cx-PUBLIC-fbEmu__link\" href=\"/ajax/emu/end.php?eid=AQL1hMzGDmRq_jGTMlTKJmQ1tWzYqTX1hYaAqONxRw3GgGVHJ_gEb1mb_22W5RpjgPEvYQ6iUHKM7Zuyyyv0Cx5BMJPL788LwavUCp3eJO8EIfVcxsQxPEH65GZjzV8kd4cWTTBMtGV-ANChcFXZuY8pHwWEiGUZ037op7NgKVbOrBiq05kvjf9hNdk3-hEsflaGS1qDa89TjbLLOnKvBAXLgKaND10JtJptCNAq_FX7KuYV-WaG8ad1w2eDAqNch7LzuY7MzJT97imgiE0sE-hCSyZ7L7NQaeYtI6MrSEbqfKUe6SRgrrM66reyGiG6ixLR8kY1MdYRUfVJhoTf5lC_vekk8XdUHnTZfwze7pntL0e4WiAIeYIJwwvDxNZHwdWA0M6gXt6fUoyTEIYwqBdeaI2HtSujVcAqzPUNF9hp-m6Yf0xSf-orKOPv1-cxlFkE8qy3BIEzYNyB99gNIfdtaS3YuDT6x4gQIBGW4dnW0gWm88TzKhSkRfIJ8sW8L2PDPQ31mjN9_drR6NUQ0-L7-HrJpT3pTzqjJvdw8HVUwpDalb_MQ76ZhQ4A16iLvdV82D_530cZVYMA_T4Dh8eG4qlJzhU-qV10H6Iho0o47_ZeTJ8QLN_qvlSH9RHC6nsBwS7AAcbOHcAsp8wytPlE6nOrnR33s0ux81AAMhHPs1BKPbiC92mL6F9OAD6GfKPQxmS9g8G0V_8XikoObEJ1QzBF4jXejZ3-QZlUC8erxDfVLI2bOciLhwSefJl62CSFoQSLqzbF9Y5UgWRui190UNVDmRhONFD7ivW6YEX5iuYcY52eWyvQr32D_vA0uQOFRlklRgzNzyRLDmHVThIZYNwK_5JJvpRNLLEk8ILjYNU3inUUT4-SknA3VOUsEm8XNbSvhDuHqaIZKcV0ISy2dNO73ZPV1W1RosDZ_pcjYimQlQNjD-jOkXr-oVAqdwLLzowm2L0naT4FOzFosY28eKIWEkVkg_G0Na62L44u5PngWfy8SAgrfY7ZLEGVvbU4-3Ssh8aquPUTO6M8dNxJzdN0DXyoWJTNwW8GUD8gpqailll2w70R20ZWeSka1HaYxnlv9p_n_dCO64QjzEdPwg0l_3MtQDtx3LGquGoVBlR_neZYW5dKUYXDqEzMd8dMdqM6YcOYkLpE9RR3wAhqJVt-MCp7ZkitmQJ5adNq5_gB6TuQrNQVtY2qaoxckZsbrXlUFN2uEOGw31F0BEKD8FKbuWEyh5vUo5AG0G1Oo6QO1_kc8GJxPEkPXuzF1EwykkwuNPJZTWNJX5f-K_7W&amp;f=1&amp;ui=6007651357550-id_51f2904c3d26e5462905510&amp;en=1&amp;a=0&amp;sig=119784&amp;__tn__=xywv\" onmousedown=\"return ee7661523863a3beb371063b97f421fc12f5d5b5e.call(this, event);\">Discover a world of intense flavors with Bon Bon Boom gum pops. Like us on Facebook now!</a></div></div></div><div class=\"inline\"><div class=\"action\"><a class=\"uiIconText emuEventfad_fan -cx-PUBLIC-fbEmu__link\" href=\"#\" style=\"padding-left: 17px;\" rel=\"async-post\" ajaxify=\"/ajax/emu/end.php?eid=AQL1hMzGDmRq_jGTMlTKJmQ1tWzYqTX1hYaAqONxRw3GgGVHJ_gEb1mb_22W5RpjgPEvYQ6iUHKM7Zuyyyv0Cx5BMJPL788LwavUCp3eJO8EIfVcxsQxPEH65GZjzV8kd4cWTTBMtGV-ANChcFXZuY8pHwWEiGUZ037op7NgKVbOrBiq05kvjf9hNdk3-hEsflaGS1qDa89TjbLLOnKvBAXLgKaND10JtJptCNAq_FX7KuYV-WaG8ad1w2eDAqNch7LzuY7MzJT97imgiE0sE-hCSyZ7L7NQaeYtI6MrSEbqfKUe6SRgrrM66reyGiG6ixLR8kY1MdYRUfVJhoTf5lC_vekk8XdUHnTZfwze7pntL0e4WiAIeYIJwwvDxNZHwdWA0M6gXt6fUoyTEIYwqBdeaI2HtSujVcAqzPUNF9hp-m6Yf0xSf-orKOPv1-cxlFkE8qy3BIEzYNyB99gNIfdtaS3YuDT6x4gQIBGW4dnW0gWm88TzKhSkRfIJ8sW8L2PDPQ31mjN9_drR6NUQ0-L7-HrJpT3pTzqjJvdw8HVUwpDalb_MQ76ZhQ4A16iLvdV82D_530cZVYMA_T4Dh8eG4qlJzhU-qV10H6Iho0o47_ZeTJ8QLN_qvlSH9RHC6nsBwS7AAcbOHcAsp8wytPlE6nOrnR33s0ux81AAMhHPs1BKPbiC92mL6F9OAD6GfKPQxmS9g8G0V_8XikoObEJ1QzBF4jXejZ3-QZlUC8erxDfVLI2bOciLhwSefJl62CSFoQSLqzbF9Y5UgWRui190UNVDmRhONFD7ivW6YEX5iuYcY52eWyvQr32D_vA0uQOFRlklRgzNzyRLDmHVThIZYNwK_5JJvpRNLLEk8ILjYNU3inUUT4-SknA3VOUsEm8XNbSvhDuHqaIZKcV0ISy2dNO73ZPV1W1RosDZ_pcjYimQlQNjD-jOkXr-oVAqdwLLzowm2L0naT4FOzFosY28eKIWEkVkg_G0Na62L44u5PngWfy8SAgrfY7ZLEGVvbU4-3Ssh8aquPUTO6M8dNxJzdN0DXyoWJTNwW8GUD8gpqailll2w70R20ZWeSka1HaYxnlv9p_n_dCO64QjzEdPwg0l_3MtQDtx3LGquGoVBlR_neZYW5dKUYXDqEzMd8dMdqM6YcOYkLpE9RR3wAhqJVt-MCp7ZkitmQJ5adNq5_gB6TuQrNQVtY2qaoxckZsbrXlUFN2uEOGw31F0BEKD8FKbuWEyh5vUo5AG0G1Oo6QO1_kc8GJxPEkPXuzF1EwykkwuNPJZTWNJX5f-K_7W&amp;f=0&amp;ui=6007651357550-id_51f2904c3d26e5462905510&amp;en=fad_fan&amp;ed=551477364890640&amp;a=1&amp;__tn__=wv\" role=\"button\"><i class=\"img sp_4p6kmz sx_bc56c4\" style=\"top: 1px;\"></i>Like</a> · <span class=\"fbEmuContext\">5,642 people like <script type=\"text/javascript\">try {\n    ((JSBNG_Record.scriptLoad)((\"function e8e1a7aeebfe56c090d2cdde0e878c5d23b720f29(event) {\\u000a    var meta = document.getElementById(\\\"meta_referrer\\\");\\u000a    meta.content = \\\"origin\\\";\\u000a    setTimeout(function() {\\u000a        meta.content = \\\"default\\\";\\u000a    }, 100);\\u000a    var attribute = \\\"href\\\";\\u000a    var ms = this.getAttribute(attribute).match(/([\\\\\\\\?|&]f=)([^&]*)/);\\u000a    if (ms) {\\u000a        this.setAttribute(attribute, this.getAttribute(attribute).replace(/[\\\\\\\\?|&]f=[^&]*/, (ms[1] + 0)));\\u000a    }\\u000a;\\u000a;\\u000a    var attribute = \\\"href\\\";\\u000a    var sig = this.getAttribute(attribute).match(/([\\\\\\\\?|&]sig=)([^&]*)/);\\u000a    if (sig) {\\u000a        this.setAttribute(attribute, this.getAttribute(attribute).replace(/[\\\\\\\\?|&]sig=[^&]*/, (sig[1] + ((Math.floor((Math.random() * 65535)) + 65536)))));\\u000a    }\\u000a;\\u000a;\\u000a};\"), (\"s314539d5f689824fc8c87b8a2a08fed2c0031085\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    function e8e1a7aeebfe56c090d2cdde0e878c5d23b720f29(JSBNG__event) {\n        if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n            return ((JSBNG_Record.eventCall)((arguments.callee), (\"s314539d5f689824fc8c87b8a2a08fed2c0031085_0\"), (s314539d5f689824fc8c87b8a2a08fed2c0031085_0_instance), (this), (arguments)))\n        };\n        (null);\n        var meta = (((JSBNG_Record.get)(JSBNG__document, (\"getElementById\")))[(\"getElementById\")])(\"meta_referrer\");\n        ((JSBNG_Record.set)(meta, (\"JSBNG__content\"), \"origin\"));\n        JSBNG__setTimeout(((function() {\n            var s314539d5f689824fc8c87b8a2a08fed2c0031085_1_instance;\n            ((s314539d5f689824fc8c87b8a2a08fed2c0031085_1_instance) = ((JSBNG_Record.eventInstance)((\"s314539d5f689824fc8c87b8a2a08fed2c0031085_1\"))));\n            return ((JSBNG_Record.markFunction)((function() {\n                if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                    return ((JSBNG_Record.eventCall)((arguments.callee), (\"s314539d5f689824fc8c87b8a2a08fed2c0031085_1\"), (s314539d5f689824fc8c87b8a2a08fed2c0031085_1_instance), (this), (arguments)))\n                };\n                (null);\n                ((JSBNG_Record.set)(meta, (\"JSBNG__content\"), \"default\"));\n            })));\n        })()), 100);\n        var attribute = \"href\";\n        var ms = (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"match\")))[(\"match\")])(/([\\\\?|&]f=)([^&]*)/);\n        if (ms) {\n            (((JSBNG_Record.get)(this, (\"setAttribute\")))[(\"setAttribute\")])(attribute, (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"replace\")))[(\"replace\")])(/[\\\\?|&]f=[^&]*/, ((((JSBNG_Record.get)(ms, 1))[1]) + 0)));\n        }\n        ;\n        ;\n        var attribute = \"href\";\n        var sig = (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"match\")))[(\"match\")])(/([\\\\?|&]sig=)([^&]*)/);\n        if (sig) {\n            (((JSBNG_Record.get)(this, (\"setAttribute\")))[(\"setAttribute\")])(attribute, (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"replace\")))[(\"replace\")])(/[\\\\?|&]sig=[^&]*/, ((((JSBNG_Record.get)(sig, 1))[1]) + (((((JSBNG_Record.get)(Math, (\"floor\")))[(\"floor\")])(((((JSBNG_Record.get)(Math, (\"JSBNG__random\")))[(\"JSBNG__random\")])() * 65535)) + 65536)))));\n        }\n        ;\n        ;\n    };\n    var s314539d5f689824fc8c87b8a2a08fed2c0031085_0_instance;\n    ((s314539d5f689824fc8c87b8a2a08fed2c0031085_0_instance) = ((JSBNG_Record.eventInstance)((\"s314539d5f689824fc8c87b8a2a08fed2c0031085_0\"))));\n    ((JSBNG_Record.markFunction)((e8e1a7aeebfe56c090d2cdde0e878c5d23b720f29)));\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};</script><a class=\"emuEventfad_pageclick -cx-PUBLIC-fbEmu__link\" href=\"/ajax/emu/end.php?eid=AQL1hMzGDmRq_jGTMlTKJmQ1tWzYqTX1hYaAqONxRw3GgGVHJ_gEb1mb_22W5RpjgPEvYQ6iUHKM7Zuyyyv0Cx5BMJPL788LwavUCp3eJO8EIfVcxsQxPEH65GZjzV8kd4cWTTBMtGV-ANChcFXZuY8pHwWEiGUZ037op7NgKVbOrBiq05kvjf9hNdk3-hEsflaGS1qDa89TjbLLOnKvBAXLgKaND10JtJptCNAq_FX7KuYV-WaG8ad1w2eDAqNch7LzuY7MzJT97imgiE0sE-hCSyZ7L7NQaeYtI6MrSEbqfKUe6SRgrrM66reyGiG6ixLR8kY1MdYRUfVJhoTf5lC_vekk8XdUHnTZfwze7pntL0e4WiAIeYIJwwvDxNZHwdWA0M6gXt6fUoyTEIYwqBdeaI2HtSujVcAqzPUNF9hp-m6Yf0xSf-orKOPv1-cxlFkE8qy3BIEzYNyB99gNIfdtaS3YuDT6x4gQIBGW4dnW0gWm88TzKhSkRfIJ8sW8L2PDPQ31mjN9_drR6NUQ0-L7-HrJpT3pTzqjJvdw8HVUwpDalb_MQ76ZhQ4A16iLvdV82D_530cZVYMA_T4Dh8eG4qlJzhU-qV10H6Iho0o47_ZeTJ8QLN_qvlSH9RHC6nsBwS7AAcbOHcAsp8wytPlE6nOrnR33s0ux81AAMhHPs1BKPbiC92mL6F9OAD6GfKPQxmS9g8G0V_8XikoObEJ1QzBF4jXejZ3-QZlUC8erxDfVLI2bOciLhwSefJl62CSFoQSLqzbF9Y5UgWRui190UNVDmRhONFD7ivW6YEX5iuYcY52eWyvQr32D_vA0uQOFRlklRgzNzyRLDmHVThIZYNwK_5JJvpRNLLEk8ILjYNU3inUUT4-SknA3VOUsEm8XNbSvhDuHqaIZKcV0ISy2dNO73ZPV1W1RosDZ_pcjYimQlQNjD-jOkXr-oVAqdwLLzowm2L0naT4FOzFosY28eKIWEkVkg_G0Na62L44u5PngWfy8SAgrfY7ZLEGVvbU4-3Ssh8aquPUTO6M8dNxJzdN0DXyoWJTNwW8GUD8gpqailll2w70R20ZWeSka1HaYxnlv9p_n_dCO64QjzEdPwg0l_3MtQDtx3LGquGoVBlR_neZYW5dKUYXDqEzMd8dMdqM6YcOYkLpE9RR3wAhqJVt-MCp7ZkitmQJ5adNq5_gB6TuQrNQVtY2qaoxckZsbrXlUFN2uEOGw31F0BEKD8FKbuWEyh5vUo5AG0G1Oo6QO1_kc8GJxPEkPXuzF1EwykkwuNPJZTWNJX5f-K_7W&amp;f=1&amp;ui=6007651357550-id_51f2904c3d26e5462905510&amp;en=fad_pageclick&amp;ed=551477364890640&amp;a=0&amp;mac=AQKQ4s-yGdeSklgE&amp;sig=84935&amp;__tn__=zwv\" onmousedown=\"return e8e1a7aeebfe56c090d2cdde0e878c5d23b720f29.call(this, event);\">Bon Bon Boom</a>.</span></div></div></div></div></div><div class=\"ego_unit\" data-ego-fbid=\"6010680301716\"><div class=\"-cx-PUBLIC-fbAdUnit__root\" data-ad=\"&#123;&quot;adid&quot;:6010680301716,&quot;segment&quot;:&quot;market&quot;&#125;\" id=\"6010680301716-id_51f2904c3d2af8e11302550\"><div class=\"-cx-PRIVATE-fbEmu__root -cx-PRIVATE-fbEmuEgo__unit\"><div class=\"uiSelector inlineBlock emu_x emuEventfad_hide -cx-PUBLIC-fbEmu__link uiSelectorRight\"><div class=\"uiToggle wrap\"><a class=\"uiSelectorButton uiCloseButton uiCloseButtonSmall\" href=\"#\" role=\"button\" title=\"About Facebook Ads\" rel=\"toggle\" ajaxify=\"/ajax/emu/end.php?eid=AQJo2STH8Z0ZkcKUkpL2hG0UgOJaWQ_5aI4nWcbBbXwIiats8_aOWw7t38eQeUOzjUm131gL2k7B8ZEGOSUev1PnIQ29Cf-nBdHF3y70ivkN1B2vddCIDXIoN_FVZmH3Gyk4b7kEPu3CW39RpTOpADPjnm2LfNsR1NH8mKyrjjnlumXaJlyFbbOY-6vl4bm3XNmWDqWpbTYoYkJympNP4omv2CjnrDHRIXTrlZ91aQJl_oOVqIwapteoL_f0Wun0y8bxRvCZmYuhv87WdsOPxU3qUQzJcz5_hpkUTe0kXMYLqdHwL_1ekLvalEXygQARqQruPs_duth8n2zGqHnDomE6Cljswm4jMbqyyyKqPBeMJ10alWZlu3OyeC4fSZsvmi61BVxLs9JqBrcVbNV3O0MLEOkpDpFfeKMNwCjE-ExA7a_KedWBXgy5UgJWY5IN5KPthKxqV85hIJVQ4HEWTzGIdvtOmWaGGLNawRtfMWzWYoYa2CLGz5urEOfIwVa_s80O-ge0-hNlD0_sIrKmCLx7GtJ5cDjCgq0-KtyH9jVGXuXSyTpa3QwFtP8-iIgtKQ_vix6rOC82Zm1dn0cYHirhDdNRFLweDv-lYIWuUiXj614SxOZbZ_X1yZ6Y7-7DdvCSRTygqg5IArqVfv_g9n6GV-pdpOsOYjzzvnGrOaoBd-OFBY_YosMPZdBf0v34tBecySFUI5MmhFHwYpWWymiNwO-brhC1B0D8H7uUcZ1QR-dJ_z_R7PiMc15qESH87TGB41EP_HSefotdTxSow1t1XbKHcbofloRyKib_44cYTva0Unf0bXDh3nyhotODl9lRz_7X15XlMEuE7333f_8FE4rf7qr253yzjOecOC30o9GXo-Vcth091OhfqhXFLuRcv9tK-KQRqYOFSGPMyBdMC70TMzf2MxkLQVcfBNr2qheCwCENg_4AkXZFd6EGJIeofLNsVd-HkgGWelPJ2r_kq_n7phs27az3W4BEm36v5Rf43IJrZxpONnlWE9SrXCyi_pypjqsBNdzImyIRfRRBK6QN9ziiElkxUJNo9SZS4mnJ0wEKXuhT68l-graHuJf2OJHxRWFucPP5J6BgLrVvRSxFAzwHS04BuLdZwDW6M0ZGauto2kkgAhpD_-fWyseltQc_LKuVb9x9OX6SlDhGv4o-D65T9Yh62x_9GYMwsqXj8wpt02CtXStX8aBevpXR_aZ0zCJxC2Gllqne98B5AJFycvK4aPALPJxk5pwyyFyOoO0Sj-JGxb26r3dJIBE&amp;f=0&amp;ui=6010680301716-id_51f2904c3d2af8e11302550&amp;en=fad_hide&amp;ed=true&amp;a=1&amp;__tn__=v\" aria-haspopup=\"1\"></a></div></div><div class=\"title\"><script type=\"text/javascript\">try {\n    ((JSBNG_Record.scriptLoad)((\"function e732bc6df7140aff102b8742f56356d4d7b96f2c1(event) {\\u000a    var meta = document.getElementById(\\\"meta_referrer\\\");\\u000a    meta.content = \\\"origin\\\";\\u000a    setTimeout(function() {\\u000a        meta.content = \\\"default\\\";\\u000a    }, 100);\\u000a    var attribute = \\\"href\\\";\\u000a    var ms = this.getAttribute(attribute).match(/([\\\\\\\\?|&]f=)([^&]*)/);\\u000a    if (ms) {\\u000a        this.setAttribute(attribute, this.getAttribute(attribute).replace(/[\\\\\\\\?|&]f=[^&]*/, (ms[1] + 0)));\\u000a    }\\u000a;\\u000a;\\u000a    var attribute = \\\"href\\\";\\u000a    var sig = this.getAttribute(attribute).match(/([\\\\\\\\?|&]sig=)([^&]*)/);\\u000a    if (sig) {\\u000a        this.setAttribute(attribute, this.getAttribute(attribute).replace(/[\\\\\\\\?|&]sig=[^&]*/, (sig[1] + ((Math.floor((Math.random() * 65535)) + 65536)))));\\u000a    }\\u000a;\\u000a;\\u000a};\"), (\"sba53f6365b5fb9a70fb8011c430ca20670c5060c\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    function e732bc6df7140aff102b8742f56356d4d7b96f2c1(JSBNG__event) {\n        if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n            return ((JSBNG_Record.eventCall)((arguments.callee), (\"sba53f6365b5fb9a70fb8011c430ca20670c5060c_0\"), (sba53f6365b5fb9a70fb8011c430ca20670c5060c_0_instance), (this), (arguments)))\n        };\n        (null);\n        var meta = (((JSBNG_Record.get)(JSBNG__document, (\"getElementById\")))[(\"getElementById\")])(\"meta_referrer\");\n        ((JSBNG_Record.set)(meta, (\"JSBNG__content\"), \"origin\"));\n        JSBNG__setTimeout(((function() {\n            var sba53f6365b5fb9a70fb8011c430ca20670c5060c_1_instance;\n            ((sba53f6365b5fb9a70fb8011c430ca20670c5060c_1_instance) = ((JSBNG_Record.eventInstance)((\"sba53f6365b5fb9a70fb8011c430ca20670c5060c_1\"))));\n            return ((JSBNG_Record.markFunction)((function() {\n                if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                    return ((JSBNG_Record.eventCall)((arguments.callee), (\"sba53f6365b5fb9a70fb8011c430ca20670c5060c_1\"), (sba53f6365b5fb9a70fb8011c430ca20670c5060c_1_instance), (this), (arguments)))\n                };\n                (null);\n                ((JSBNG_Record.set)(meta, (\"JSBNG__content\"), \"default\"));\n            })));\n        })()), 100);\n        var attribute = \"href\";\n        var ms = (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"match\")))[(\"match\")])(/([\\\\?|&]f=)([^&]*)/);\n        if (ms) {\n            (((JSBNG_Record.get)(this, (\"setAttribute\")))[(\"setAttribute\")])(attribute, (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"replace\")))[(\"replace\")])(/[\\\\?|&]f=[^&]*/, ((((JSBNG_Record.get)(ms, 1))[1]) + 0)));\n        }\n        ;\n        ;\n        var attribute = \"href\";\n        var sig = (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"match\")))[(\"match\")])(/([\\\\?|&]sig=)([^&]*)/);\n        if (sig) {\n            (((JSBNG_Record.get)(this, (\"setAttribute\")))[(\"setAttribute\")])(attribute, (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"replace\")))[(\"replace\")])(/[\\\\?|&]sig=[^&]*/, ((((JSBNG_Record.get)(sig, 1))[1]) + (((((JSBNG_Record.get)(Math, (\"floor\")))[(\"floor\")])(((((JSBNG_Record.get)(Math, (\"JSBNG__random\")))[(\"JSBNG__random\")])() * 65535)) + 65536)))));\n        }\n        ;\n        ;\n    };\n    var sba53f6365b5fb9a70fb8011c430ca20670c5060c_0_instance;\n    ((sba53f6365b5fb9a70fb8011c430ca20670c5060c_0_instance) = ((JSBNG_Record.eventInstance)((\"sba53f6365b5fb9a70fb8011c430ca20670c5060c_0\"))));\n    ((JSBNG_Record.markFunction)((e732bc6df7140aff102b8742f56356d4d7b96f2c1)));\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};</script><a class=\"forceLTR emuEvent1 -cx-PUBLIC-fbEmu__link\" href=\"/ajax/emu/end.php?eid=AQJo2STH8Z0ZkcKUkpL2hG0UgOJaWQ_5aI4nWcbBbXwIiats8_aOWw7t38eQeUOzjUm131gL2k7B8ZEGOSUev1PnIQ29Cf-nBdHF3y70ivkN1B2vddCIDXIoN_FVZmH3Gyk4b7kEPu3CW39RpTOpADPjnm2LfNsR1NH8mKyrjjnlumXaJlyFbbOY-6vl4bm3XNmWDqWpbTYoYkJympNP4omv2CjnrDHRIXTrlZ91aQJl_oOVqIwapteoL_f0Wun0y8bxRvCZmYuhv87WdsOPxU3qUQzJcz5_hpkUTe0kXMYLqdHwL_1ekLvalEXygQARqQruPs_duth8n2zGqHnDomE6Cljswm4jMbqyyyKqPBeMJ10alWZlu3OyeC4fSZsvmi61BVxLs9JqBrcVbNV3O0MLEOkpDpFfeKMNwCjE-ExA7a_KedWBXgy5UgJWY5IN5KPthKxqV85hIJVQ4HEWTzGIdvtOmWaGGLNawRtfMWzWYoYa2CLGz5urEOfIwVa_s80O-ge0-hNlD0_sIrKmCLx7GtJ5cDjCgq0-KtyH9jVGXuXSyTpa3QwFtP8-iIgtKQ_vix6rOC82Zm1dn0cYHirhDdNRFLweDv-lYIWuUiXj614SxOZbZ_X1yZ6Y7-7DdvCSRTygqg5IArqVfv_g9n6GV-pdpOsOYjzzvnGrOaoBd-OFBY_YosMPZdBf0v34tBecySFUI5MmhFHwYpWWymiNwO-brhC1B0D8H7uUcZ1QR-dJ_z_R7PiMc15qESH87TGB41EP_HSefotdTxSow1t1XbKHcbofloRyKib_44cYTva0Unf0bXDh3nyhotODl9lRz_7X15XlMEuE7333f_8FE4rf7qr253yzjOecOC30o9GXo-Vcth091OhfqhXFLuRcv9tK-KQRqYOFSGPMyBdMC70TMzf2MxkLQVcfBNr2qheCwCENg_4AkXZFd6EGJIeofLNsVd-HkgGWelPJ2r_kq_n7phs27az3W4BEm36v5Rf43IJrZxpONnlWE9SrXCyi_pypjqsBNdzImyIRfRRBK6QN9ziiElkxUJNo9SZS4mnJ0wEKXuhT68l-graHuJf2OJHxRWFucPP5J6BgLrVvRSxFAzwHS04BuLdZwDW6M0ZGauto2kkgAhpD_-fWyseltQc_LKuVb9x9OX6SlDhGv4o-D65T9Yh62x_9GYMwsqXj8wpt02CtXStX8aBevpXR_aZ0zCJxC2Gllqne98B5AJFycvK4aPALPJxk5pwyyFyOoO0Sj-JGxb26r3dJIBE&amp;f=1&amp;ui=6010680301716-id_51f2904c3d2af8e11302550&amp;en=1&amp;a=0&amp;sig=114877&amp;__tn__=wv\" onmousedown=\"return e732bc6df7140aff102b8742f56356d4d7b96f2c1.call(this, event);\">Marlene&#039;s Meal Makeovers</a></div><div class=\"clearfix image_body_block\"><script type=\"text/javascript\">try {\n    ((JSBNG_Record.scriptLoad)((\"function ec6a6e5a6fbb2e5ee136fec2e14ab76e2ba4dac95(event) {\\u000a    var meta = document.getElementById(\\\"meta_referrer\\\");\\u000a    meta.content = \\\"origin\\\";\\u000a    setTimeout(function() {\\u000a        meta.content = \\\"default\\\";\\u000a    }, 100);\\u000a    var attribute = \\\"href\\\";\\u000a    var ms = this.getAttribute(attribute).match(/([\\\\\\\\?|&]f=)([^&]*)/);\\u000a    if (ms) {\\u000a        this.setAttribute(attribute, this.getAttribute(attribute).replace(/[\\\\\\\\?|&]f=[^&]*/, (ms[1] + 0)));\\u000a    }\\u000a;\\u000a;\\u000a    var attribute = \\\"href\\\";\\u000a    var sig = this.getAttribute(attribute).match(/([\\\\\\\\?|&]sig=)([^&]*)/);\\u000a    if (sig) {\\u000a        this.setAttribute(attribute, this.getAttribute(attribute).replace(/[\\\\\\\\?|&]sig=[^&]*/, (sig[1] + ((Math.floor((Math.random() * 65535)) + 65536)))));\\u000a    }\\u000a;\\u000a;\\u000a};\"), (\"s92a2752a2b343ca2be7e7e9ecd19420beff0674e\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    function ec6a6e5a6fbb2e5ee136fec2e14ab76e2ba4dac95(JSBNG__event) {\n        if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n            return ((JSBNG_Record.eventCall)((arguments.callee), (\"s92a2752a2b343ca2be7e7e9ecd19420beff0674e_0\"), (s92a2752a2b343ca2be7e7e9ecd19420beff0674e_0_instance), (this), (arguments)))\n        };\n        (null);\n        var meta = (((JSBNG_Record.get)(JSBNG__document, (\"getElementById\")))[(\"getElementById\")])(\"meta_referrer\");\n        ((JSBNG_Record.set)(meta, (\"JSBNG__content\"), \"origin\"));\n        JSBNG__setTimeout(((function() {\n            var s92a2752a2b343ca2be7e7e9ecd19420beff0674e_1_instance;\n            ((s92a2752a2b343ca2be7e7e9ecd19420beff0674e_1_instance) = ((JSBNG_Record.eventInstance)((\"s92a2752a2b343ca2be7e7e9ecd19420beff0674e_1\"))));\n            return ((JSBNG_Record.markFunction)((function() {\n                if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                    return ((JSBNG_Record.eventCall)((arguments.callee), (\"s92a2752a2b343ca2be7e7e9ecd19420beff0674e_1\"), (s92a2752a2b343ca2be7e7e9ecd19420beff0674e_1_instance), (this), (arguments)))\n                };\n                (null);\n                ((JSBNG_Record.set)(meta, (\"JSBNG__content\"), \"default\"));\n            })));\n        })()), 100);\n        var attribute = \"href\";\n        var ms = (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"match\")))[(\"match\")])(/([\\\\?|&]f=)([^&]*)/);\n        if (ms) {\n            (((JSBNG_Record.get)(this, (\"setAttribute\")))[(\"setAttribute\")])(attribute, (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"replace\")))[(\"replace\")])(/[\\\\?|&]f=[^&]*/, ((((JSBNG_Record.get)(ms, 1))[1]) + 0)));\n        }\n        ;\n        ;\n        var attribute = \"href\";\n        var sig = (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"match\")))[(\"match\")])(/([\\\\?|&]sig=)([^&]*)/);\n        if (sig) {\n            (((JSBNG_Record.get)(this, (\"setAttribute\")))[(\"setAttribute\")])(attribute, (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"replace\")))[(\"replace\")])(/[\\\\?|&]sig=[^&]*/, ((((JSBNG_Record.get)(sig, 1))[1]) + (((((JSBNG_Record.get)(Math, (\"floor\")))[(\"floor\")])(((((JSBNG_Record.get)(Math, (\"JSBNG__random\")))[(\"JSBNG__random\")])() * 65535)) + 65536)))));\n        }\n        ;\n        ;\n    };\n    var s92a2752a2b343ca2be7e7e9ecd19420beff0674e_0_instance;\n    ((s92a2752a2b343ca2be7e7e9ecd19420beff0674e_0_instance) = ((JSBNG_Record.eventInstance)((\"s92a2752a2b343ca2be7e7e9ecd19420beff0674e_0\"))));\n    ((JSBNG_Record.markFunction)((ec6a6e5a6fbb2e5ee136fec2e14ab76e2ba4dac95)));\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};</script><a class=\"forceLTR emuEvent1 -cx-PUBLIC-fbEmu__link image fbEmuImage -cx-PRIVATE-uiImageBlock__image -cx-PRIVATE-uiImageBlock__mediumimage lfloat\" tabindex=\"-1\" href=\"/ajax/emu/end.php?eid=AQJo2STH8Z0ZkcKUkpL2hG0UgOJaWQ_5aI4nWcbBbXwIiats8_aOWw7t38eQeUOzjUm131gL2k7B8ZEGOSUev1PnIQ29Cf-nBdHF3y70ivkN1B2vddCIDXIoN_FVZmH3Gyk4b7kEPu3CW39RpTOpADPjnm2LfNsR1NH8mKyrjjnlumXaJlyFbbOY-6vl4bm3XNmWDqWpbTYoYkJympNP4omv2CjnrDHRIXTrlZ91aQJl_oOVqIwapteoL_f0Wun0y8bxRvCZmYuhv87WdsOPxU3qUQzJcz5_hpkUTe0kXMYLqdHwL_1ekLvalEXygQARqQruPs_duth8n2zGqHnDomE6Cljswm4jMbqyyyKqPBeMJ10alWZlu3OyeC4fSZsvmi61BVxLs9JqBrcVbNV3O0MLEOkpDpFfeKMNwCjE-ExA7a_KedWBXgy5UgJWY5IN5KPthKxqV85hIJVQ4HEWTzGIdvtOmWaGGLNawRtfMWzWYoYa2CLGz5urEOfIwVa_s80O-ge0-hNlD0_sIrKmCLx7GtJ5cDjCgq0-KtyH9jVGXuXSyTpa3QwFtP8-iIgtKQ_vix6rOC82Zm1dn0cYHirhDdNRFLweDv-lYIWuUiXj614SxOZbZ_X1yZ6Y7-7DdvCSRTygqg5IArqVfv_g9n6GV-pdpOsOYjzzvnGrOaoBd-OFBY_YosMPZdBf0v34tBecySFUI5MmhFHwYpWWymiNwO-brhC1B0D8H7uUcZ1QR-dJ_z_R7PiMc15qESH87TGB41EP_HSefotdTxSow1t1XbKHcbofloRyKib_44cYTva0Unf0bXDh3nyhotODl9lRz_7X15XlMEuE7333f_8FE4rf7qr253yzjOecOC30o9GXo-Vcth091OhfqhXFLuRcv9tK-KQRqYOFSGPMyBdMC70TMzf2MxkLQVcfBNr2qheCwCENg_4AkXZFd6EGJIeofLNsVd-HkgGWelPJ2r_kq_n7phs27az3W4BEm36v5Rf43IJrZxpONnlWE9SrXCyi_pypjqsBNdzImyIRfRRBK6QN9ziiElkxUJNo9SZS4mnJ0wEKXuhT68l-graHuJf2OJHxRWFucPP5J6BgLrVvRSxFAzwHS04BuLdZwDW6M0ZGauto2kkgAhpD_-fWyseltQc_LKuVb9x9OX6SlDhGv4o-D65T9Yh62x_9GYMwsqXj8wpt02CtXStX8aBevpXR_aZ0zCJxC2Gllqne98B5AJFycvK4aPALPJxk5pwyyFyOoO0Sj-JGxb26r3dJIBE&amp;f=1&amp;ui=6010680301716-id_51f2904c3d2af8e11302550&amp;en=1&amp;a=0&amp;sig=78807&amp;__tn__=ywv\" onmousedown=\"return ec6a6e5a6fbb2e5ee136fec2e14ab76e2ba4dac95.call(this, event);\" aria-hidden=\"true\"><img class=\"img\" src=\"http://jsbngssl.creative-iad.xx.fbcdn.net/hads-ash3/s110x80/735358_6010487616516_1483820094_n.png\" alt=\"\" /></a><div class=\"-cx-PRIVATE-uiFlexibleBlock__flexiblecontent\"><div class=\"body\"><script type=\"text/javascript\">try {\n    ((JSBNG_Record.scriptLoad)((\"function e51fc0459fd8ba1ed9ef4aea9396e75c6209247e8(event) {\\u000a    var meta = document.getElementById(\\\"meta_referrer\\\");\\u000a    meta.content = \\\"origin\\\";\\u000a    setTimeout(function() {\\u000a        meta.content = \\\"default\\\";\\u000a    }, 100);\\u000a    var attribute = \\\"href\\\";\\u000a    var ms = this.getAttribute(attribute).match(/([\\\\\\\\?|&]f=)([^&]*)/);\\u000a    if (ms) {\\u000a        this.setAttribute(attribute, this.getAttribute(attribute).replace(/[\\\\\\\\?|&]f=[^&]*/, (ms[1] + 0)));\\u000a    }\\u000a;\\u000a;\\u000a    var attribute = \\\"href\\\";\\u000a    var sig = this.getAttribute(attribute).match(/([\\\\\\\\?|&]sig=)([^&]*)/);\\u000a    if (sig) {\\u000a        this.setAttribute(attribute, this.getAttribute(attribute).replace(/[\\\\\\\\?|&]sig=[^&]*/, (sig[1] + ((Math.floor((Math.random() * 65535)) + 65536)))));\\u000a    }\\u000a;\\u000a;\\u000a};\"), (\"sea2fefb043d9f9ace09f2e6fc4e78b841ec7dc22\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    function e51fc0459fd8ba1ed9ef4aea9396e75c6209247e8(JSBNG__event) {\n        if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n            return ((JSBNG_Record.eventCall)((arguments.callee), (\"sea2fefb043d9f9ace09f2e6fc4e78b841ec7dc22_0\"), (sea2fefb043d9f9ace09f2e6fc4e78b841ec7dc22_0_instance), (this), (arguments)))\n        };\n        (null);\n        var meta = (((JSBNG_Record.get)(JSBNG__document, (\"getElementById\")))[(\"getElementById\")])(\"meta_referrer\");\n        ((JSBNG_Record.set)(meta, (\"JSBNG__content\"), \"origin\"));\n        JSBNG__setTimeout(((function() {\n            var sea2fefb043d9f9ace09f2e6fc4e78b841ec7dc22_1_instance;\n            ((sea2fefb043d9f9ace09f2e6fc4e78b841ec7dc22_1_instance) = ((JSBNG_Record.eventInstance)((\"sea2fefb043d9f9ace09f2e6fc4e78b841ec7dc22_1\"))));\n            return ((JSBNG_Record.markFunction)((function() {\n                if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                    return ((JSBNG_Record.eventCall)((arguments.callee), (\"sea2fefb043d9f9ace09f2e6fc4e78b841ec7dc22_1\"), (sea2fefb043d9f9ace09f2e6fc4e78b841ec7dc22_1_instance), (this), (arguments)))\n                };\n                (null);\n                ((JSBNG_Record.set)(meta, (\"JSBNG__content\"), \"default\"));\n            })));\n        })()), 100);\n        var attribute = \"href\";\n        var ms = (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"match\")))[(\"match\")])(/([\\\\?|&]f=)([^&]*)/);\n        if (ms) {\n            (((JSBNG_Record.get)(this, (\"setAttribute\")))[(\"setAttribute\")])(attribute, (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"replace\")))[(\"replace\")])(/[\\\\?|&]f=[^&]*/, ((((JSBNG_Record.get)(ms, 1))[1]) + 0)));\n        }\n        ;\n        ;\n        var attribute = \"href\";\n        var sig = (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"match\")))[(\"match\")])(/([\\\\?|&]sig=)([^&]*)/);\n        if (sig) {\n            (((JSBNG_Record.get)(this, (\"setAttribute\")))[(\"setAttribute\")])(attribute, (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"replace\")))[(\"replace\")])(/[\\\\?|&]sig=[^&]*/, ((((JSBNG_Record.get)(sig, 1))[1]) + (((((JSBNG_Record.get)(Math, (\"floor\")))[(\"floor\")])(((((JSBNG_Record.get)(Math, (\"JSBNG__random\")))[(\"JSBNG__random\")])() * 65535)) + 65536)))));\n        }\n        ;\n        ;\n    };\n    var sea2fefb043d9f9ace09f2e6fc4e78b841ec7dc22_0_instance;\n    ((sea2fefb043d9f9ace09f2e6fc4e78b841ec7dc22_0_instance) = ((JSBNG_Record.eventInstance)((\"sea2fefb043d9f9ace09f2e6fc4e78b841ec7dc22_0\"))));\n    ((JSBNG_Record.markFunction)((e51fc0459fd8ba1ed9ef4aea9396e75c6209247e8)));\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};</script><a class=\"forceLTR emuEvent1 -cx-PUBLIC-fbEmu__link\" href=\"/ajax/emu/end.php?eid=AQJo2STH8Z0ZkcKUkpL2hG0UgOJaWQ_5aI4nWcbBbXwIiats8_aOWw7t38eQeUOzjUm131gL2k7B8ZEGOSUev1PnIQ29Cf-nBdHF3y70ivkN1B2vddCIDXIoN_FVZmH3Gyk4b7kEPu3CW39RpTOpADPjnm2LfNsR1NH8mKyrjjnlumXaJlyFbbOY-6vl4bm3XNmWDqWpbTYoYkJympNP4omv2CjnrDHRIXTrlZ91aQJl_oOVqIwapteoL_f0Wun0y8bxRvCZmYuhv87WdsOPxU3qUQzJcz5_hpkUTe0kXMYLqdHwL_1ekLvalEXygQARqQruPs_duth8n2zGqHnDomE6Cljswm4jMbqyyyKqPBeMJ10alWZlu3OyeC4fSZsvmi61BVxLs9JqBrcVbNV3O0MLEOkpDpFfeKMNwCjE-ExA7a_KedWBXgy5UgJWY5IN5KPthKxqV85hIJVQ4HEWTzGIdvtOmWaGGLNawRtfMWzWYoYa2CLGz5urEOfIwVa_s80O-ge0-hNlD0_sIrKmCLx7GtJ5cDjCgq0-KtyH9jVGXuXSyTpa3QwFtP8-iIgtKQ_vix6rOC82Zm1dn0cYHirhDdNRFLweDv-lYIWuUiXj614SxOZbZ_X1yZ6Y7-7DdvCSRTygqg5IArqVfv_g9n6GV-pdpOsOYjzzvnGrOaoBd-OFBY_YosMPZdBf0v34tBecySFUI5MmhFHwYpWWymiNwO-brhC1B0D8H7uUcZ1QR-dJ_z_R7PiMc15qESH87TGB41EP_HSefotdTxSow1t1XbKHcbofloRyKib_44cYTva0Unf0bXDh3nyhotODl9lRz_7X15XlMEuE7333f_8FE4rf7qr253yzjOecOC30o9GXo-Vcth091OhfqhXFLuRcv9tK-KQRqYOFSGPMyBdMC70TMzf2MxkLQVcfBNr2qheCwCENg_4AkXZFd6EGJIeofLNsVd-HkgGWelPJ2r_kq_n7phs27az3W4BEm36v5Rf43IJrZxpONnlWE9SrXCyi_pypjqsBNdzImyIRfRRBK6QN9ziiElkxUJNo9SZS4mnJ0wEKXuhT68l-graHuJf2OJHxRWFucPP5J6BgLrVvRSxFAzwHS04BuLdZwDW6M0ZGauto2kkgAhpD_-fWyseltQc_LKuVb9x9OX6SlDhGv4o-D65T9Yh62x_9GYMwsqXj8wpt02CtXStX8aBevpXR_aZ0zCJxC2Gllqne98B5AJFycvK4aPALPJxk5pwyyFyOoO0Sj-JGxb26r3dJIBE&amp;f=1&amp;ui=6010680301716-id_51f2904c3d2af8e11302550&amp;en=1&amp;a=0&amp;sig=66146&amp;__tn__=xywv\" onmousedown=\"return e51fc0459fd8ba1ed9ef4aea9396e75c6209247e8.call(this, event);\">Like Us for healthy recipes, Cheaper, Better, and Faster with Cook Once, Produce Twice...</a></div></div></div><div class=\"inline\"><div class=\"action\"><a class=\"uiIconText emuEventfad_fan -cx-PUBLIC-fbEmu__link\" href=\"#\" style=\"padding-left: 17px;\" rel=\"async-post\" ajaxify=\"/ajax/emu/end.php?eid=AQJo2STH8Z0ZkcKUkpL2hG0UgOJaWQ_5aI4nWcbBbXwIiats8_aOWw7t38eQeUOzjUm131gL2k7B8ZEGOSUev1PnIQ29Cf-nBdHF3y70ivkN1B2vddCIDXIoN_FVZmH3Gyk4b7kEPu3CW39RpTOpADPjnm2LfNsR1NH8mKyrjjnlumXaJlyFbbOY-6vl4bm3XNmWDqWpbTYoYkJympNP4omv2CjnrDHRIXTrlZ91aQJl_oOVqIwapteoL_f0Wun0y8bxRvCZmYuhv87WdsOPxU3qUQzJcz5_hpkUTe0kXMYLqdHwL_1ekLvalEXygQARqQruPs_duth8n2zGqHnDomE6Cljswm4jMbqyyyKqPBeMJ10alWZlu3OyeC4fSZsvmi61BVxLs9JqBrcVbNV3O0MLEOkpDpFfeKMNwCjE-ExA7a_KedWBXgy5UgJWY5IN5KPthKxqV85hIJVQ4HEWTzGIdvtOmWaGGLNawRtfMWzWYoYa2CLGz5urEOfIwVa_s80O-ge0-hNlD0_sIrKmCLx7GtJ5cDjCgq0-KtyH9jVGXuXSyTpa3QwFtP8-iIgtKQ_vix6rOC82Zm1dn0cYHirhDdNRFLweDv-lYIWuUiXj614SxOZbZ_X1yZ6Y7-7DdvCSRTygqg5IArqVfv_g9n6GV-pdpOsOYjzzvnGrOaoBd-OFBY_YosMPZdBf0v34tBecySFUI5MmhFHwYpWWymiNwO-brhC1B0D8H7uUcZ1QR-dJ_z_R7PiMc15qESH87TGB41EP_HSefotdTxSow1t1XbKHcbofloRyKib_44cYTva0Unf0bXDh3nyhotODl9lRz_7X15XlMEuE7333f_8FE4rf7qr253yzjOecOC30o9GXo-Vcth091OhfqhXFLuRcv9tK-KQRqYOFSGPMyBdMC70TMzf2MxkLQVcfBNr2qheCwCENg_4AkXZFd6EGJIeofLNsVd-HkgGWelPJ2r_kq_n7phs27az3W4BEm36v5Rf43IJrZxpONnlWE9SrXCyi_pypjqsBNdzImyIRfRRBK6QN9ziiElkxUJNo9SZS4mnJ0wEKXuhT68l-graHuJf2OJHxRWFucPP5J6BgLrVvRSxFAzwHS04BuLdZwDW6M0ZGauto2kkgAhpD_-fWyseltQc_LKuVb9x9OX6SlDhGv4o-D65T9Yh62x_9GYMwsqXj8wpt02CtXStX8aBevpXR_aZ0zCJxC2Gllqne98B5AJFycvK4aPALPJxk5pwyyFyOoO0Sj-JGxb26r3dJIBE&amp;f=0&amp;ui=6010680301716-id_51f2904c3d2af8e11302550&amp;en=fad_fan&amp;ed=352352391912&amp;a=1&amp;__tn__=wv\" role=\"button\"><i class=\"img sp_4p6kmz sx_bc56c4\" style=\"top: 1px;\"></i>Like</a> · <span class=\"fbEmuContext\">3,263 people like <script type=\"text/javascript\">try {\n    ((JSBNG_Record.scriptLoad)((\"function ebe75e181291e1f217f9de74db62fe89366bc0718(event) {\\u000a    var meta = document.getElementById(\\\"meta_referrer\\\");\\u000a    meta.content = \\\"origin\\\";\\u000a    setTimeout(function() {\\u000a        meta.content = \\\"default\\\";\\u000a    }, 100);\\u000a    var attribute = \\\"href\\\";\\u000a    var ms = this.getAttribute(attribute).match(/([\\\\\\\\?|&]f=)([^&]*)/);\\u000a    if (ms) {\\u000a        this.setAttribute(attribute, this.getAttribute(attribute).replace(/[\\\\\\\\?|&]f=[^&]*/, (ms[1] + 0)));\\u000a    }\\u000a;\\u000a;\\u000a    var attribute = \\\"href\\\";\\u000a    var sig = this.getAttribute(attribute).match(/([\\\\\\\\?|&]sig=)([^&]*)/);\\u000a    if (sig) {\\u000a        this.setAttribute(attribute, this.getAttribute(attribute).replace(/[\\\\\\\\?|&]sig=[^&]*/, (sig[1] + ((Math.floor((Math.random() * 65535)) + 65536)))));\\u000a    }\\u000a;\\u000a;\\u000a};\"), (\"s399b54ad4f6c978693a6b0a963aeb42c71a41866\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    function ebe75e181291e1f217f9de74db62fe89366bc0718(JSBNG__event) {\n        if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n            return ((JSBNG_Record.eventCall)((arguments.callee), (\"s399b54ad4f6c978693a6b0a963aeb42c71a41866_0\"), (s399b54ad4f6c978693a6b0a963aeb42c71a41866_0_instance), (this), (arguments)))\n        };\n        (null);\n        var meta = (((JSBNG_Record.get)(JSBNG__document, (\"getElementById\")))[(\"getElementById\")])(\"meta_referrer\");\n        ((JSBNG_Record.set)(meta, (\"JSBNG__content\"), \"origin\"));\n        JSBNG__setTimeout(((function() {\n            var s399b54ad4f6c978693a6b0a963aeb42c71a41866_1_instance;\n            ((s399b54ad4f6c978693a6b0a963aeb42c71a41866_1_instance) = ((JSBNG_Record.eventInstance)((\"s399b54ad4f6c978693a6b0a963aeb42c71a41866_1\"))));\n            return ((JSBNG_Record.markFunction)((function() {\n                if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                    return ((JSBNG_Record.eventCall)((arguments.callee), (\"s399b54ad4f6c978693a6b0a963aeb42c71a41866_1\"), (s399b54ad4f6c978693a6b0a963aeb42c71a41866_1_instance), (this), (arguments)))\n                };\n                (null);\n                ((JSBNG_Record.set)(meta, (\"JSBNG__content\"), \"default\"));\n            })));\n        })()), 100);\n        var attribute = \"href\";\n        var ms = (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"match\")))[(\"match\")])(/([\\\\?|&]f=)([^&]*)/);\n        if (ms) {\n            (((JSBNG_Record.get)(this, (\"setAttribute\")))[(\"setAttribute\")])(attribute, (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"replace\")))[(\"replace\")])(/[\\\\?|&]f=[^&]*/, ((((JSBNG_Record.get)(ms, 1))[1]) + 0)));\n        }\n        ;\n        ;\n        var attribute = \"href\";\n        var sig = (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"match\")))[(\"match\")])(/([\\\\?|&]sig=)([^&]*)/);\n        if (sig) {\n            (((JSBNG_Record.get)(this, (\"setAttribute\")))[(\"setAttribute\")])(attribute, (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"replace\")))[(\"replace\")])(/[\\\\?|&]sig=[^&]*/, ((((JSBNG_Record.get)(sig, 1))[1]) + (((((JSBNG_Record.get)(Math, (\"floor\")))[(\"floor\")])(((((JSBNG_Record.get)(Math, (\"JSBNG__random\")))[(\"JSBNG__random\")])() * 65535)) + 65536)))));\n        }\n        ;\n        ;\n    };\n    var s399b54ad4f6c978693a6b0a963aeb42c71a41866_0_instance;\n    ((s399b54ad4f6c978693a6b0a963aeb42c71a41866_0_instance) = ((JSBNG_Record.eventInstance)((\"s399b54ad4f6c978693a6b0a963aeb42c71a41866_0\"))));\n    ((JSBNG_Record.markFunction)((ebe75e181291e1f217f9de74db62fe89366bc0718)));\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};</script><a class=\"emuEventfad_pageclick -cx-PUBLIC-fbEmu__link\" href=\"/ajax/emu/end.php?eid=AQJo2STH8Z0ZkcKUkpL2hG0UgOJaWQ_5aI4nWcbBbXwIiats8_aOWw7t38eQeUOzjUm131gL2k7B8ZEGOSUev1PnIQ29Cf-nBdHF3y70ivkN1B2vddCIDXIoN_FVZmH3Gyk4b7kEPu3CW39RpTOpADPjnm2LfNsR1NH8mKyrjjnlumXaJlyFbbOY-6vl4bm3XNmWDqWpbTYoYkJympNP4omv2CjnrDHRIXTrlZ91aQJl_oOVqIwapteoL_f0Wun0y8bxRvCZmYuhv87WdsOPxU3qUQzJcz5_hpkUTe0kXMYLqdHwL_1ekLvalEXygQARqQruPs_duth8n2zGqHnDomE6Cljswm4jMbqyyyKqPBeMJ10alWZlu3OyeC4fSZsvmi61BVxLs9JqBrcVbNV3O0MLEOkpDpFfeKMNwCjE-ExA7a_KedWBXgy5UgJWY5IN5KPthKxqV85hIJVQ4HEWTzGIdvtOmWaGGLNawRtfMWzWYoYa2CLGz5urEOfIwVa_s80O-ge0-hNlD0_sIrKmCLx7GtJ5cDjCgq0-KtyH9jVGXuXSyTpa3QwFtP8-iIgtKQ_vix6rOC82Zm1dn0cYHirhDdNRFLweDv-lYIWuUiXj614SxOZbZ_X1yZ6Y7-7DdvCSRTygqg5IArqVfv_g9n6GV-pdpOsOYjzzvnGrOaoBd-OFBY_YosMPZdBf0v34tBecySFUI5MmhFHwYpWWymiNwO-brhC1B0D8H7uUcZ1QR-dJ_z_R7PiMc15qESH87TGB41EP_HSefotdTxSow1t1XbKHcbofloRyKib_44cYTva0Unf0bXDh3nyhotODl9lRz_7X15XlMEuE7333f_8FE4rf7qr253yzjOecOC30o9GXo-Vcth091OhfqhXFLuRcv9tK-KQRqYOFSGPMyBdMC70TMzf2MxkLQVcfBNr2qheCwCENg_4AkXZFd6EGJIeofLNsVd-HkgGWelPJ2r_kq_n7phs27az3W4BEm36v5Rf43IJrZxpONnlWE9SrXCyi_pypjqsBNdzImyIRfRRBK6QN9ziiElkxUJNo9SZS4mnJ0wEKXuhT68l-graHuJf2OJHxRWFucPP5J6BgLrVvRSxFAzwHS04BuLdZwDW6M0ZGauto2kkgAhpD_-fWyseltQc_LKuVb9x9OX6SlDhGv4o-D65T9Yh62x_9GYMwsqXj8wpt02CtXStX8aBevpXR_aZ0zCJxC2Gllqne98B5AJFycvK4aPALPJxk5pwyyFyOoO0Sj-JGxb26r3dJIBE&amp;f=1&amp;ui=6010680301716-id_51f2904c3d2af8e11302550&amp;en=fad_pageclick&amp;ed=352352391912&amp;a=0&amp;mac=AQKfXPSPqhiaF4n7&amp;sig=97556&amp;__tn__=zwv\" onmousedown=\"return ebe75e181291e1f217f9de74db62fe89366bc0718.call(this, event);\">marlene&#039;s meal makeovers</a>.</span></div></div></div></div></div><div class=\"ego_unit\" data-ego-fbid=\"6007882470930\"><div class=\"-cx-PUBLIC-fbAdUnit__root\" data-ad=\"&#123;&quot;adid&quot;:6007882470930,&quot;segment&quot;:&quot;market&quot;&#125;\" id=\"6007882470930-id_51f2904c3d2ef2f25249809\"><div class=\"-cx-PRIVATE-fbEmu__root -cx-PRIVATE-fbEmuEgo__unit\"><div class=\"uiSelector inlineBlock emu_x emuEventfad_hide -cx-PUBLIC-fbEmu__link uiSelectorRight\"><div class=\"uiToggle wrap\"><a class=\"uiSelectorButton uiCloseButton uiCloseButtonSmall\" href=\"#\" role=\"button\" title=\"About Facebook Ads\" rel=\"toggle\" ajaxify=\"/ajax/emu/end.php?eid=AQKxDHTm3nyv_XoZgRGgtFyuIx1Dl-9n9KW0L1jI-n5_opSFWrvem0PGojZ7-0RQzO_Tu3Iopn9rwuueiyZ5RFrEsiTTZTDtW5iMmkly6EQLyYfHQodVCV7m8Wvq-wfpSOIQPIHd_g2dXRMVBRH6wAp9bF0Ocv3Vf9hewGLIcMIZMXjU9zH4vh8hPOQxLRh1KfX_eF0__zzpS_2FYUERtJoaHTL3yukbYbhqVMylaq79mmWtMKz2oevMrBL6C9XfDJL8ZQatILXq8rH0GE1wjp6stwakFdPMcymodiW_gBgSIkgqgDoOBg0gTuptQbZQL-vOtG_4tSaE6u0zZ55AkBeWEIxoYaL8gdQxT6QF2gHsXsPY7iMfNhX_kDUz0yiwwoNVsHVNt0d5iGn2pI-nqWFXwXReMNpxMT3Dih2hszZ46hykc4-4efJk0x2y53rLD0aB72b3VNlSvxc2XYux0MeKqhaVZmkZ7IUBo5M3W1OET70-5X_hID2-ZL5vkKVowUbD8PRMRx6794x6_n5bs9DnagwWJv8Z5B6w3YfZK1iRnablKyFNGaiAaVkOi4mdLoFBe-rhRt2ZGi6lRpgh3YphAHVeVeX18YPqSIDfZZpoDkAcmhyd98QHnz4jKpYd09hEsnITc3GhbUKeLLvbevEcgDfVUEp2XdJUpujBFAtEVYuzlJQ6h81g69e7P9Ar2oB2sMbNSLEdXf8BqyRwajlmyL1hmAGXH0ctzJ5ObeQP9cRU-PTUeIB1XyXGwWyzvg5UMHpY5hu0yuyUXmwepvCxgpQoswwF5GrDdhIDifHAH7qdtPm0Ww5OWAuzJrXUrGnS-\\-\\HM3V5vU7XJu2pw4iXtN3EvWeyo8MOQFrP-xr2JNI5DyLeJteh1Lb0Ax29Ze8XO5OmARtSq3MYMZSfa8AytYsBXQHGrpq7XrdFOV4yw2GV9_PBCux9l-D4yCGDHHNhnS7vVVrv6s5C1Ea4sVx86PN8IbKLoXOeI3Xcob8L9FAlT6-blUkqPMVMxHGREiFQSSh-HzSpiWdME_lqa_DuMhzuuEiDqwaZhuL0dEoJ6dX3bxAnEq7EFiaUwtmPFDAEGBAfgmxjM8OrvQLJTDdGxr_jZWEM7RFz9ATw2CPwMB7Jfxp7RpejOpLo6S4JFKNn3VemDxNDPI2mR83ybvgkApOGautfNG-a1DdbNjTCP5i36NpXyomF5OFRsKmVjRtmIX1xXmidb2pMvlx-XMj8Js1ZWq0Z6HODjep7RHMvMe47C7eD3uzY5m4lVXN9rC34WgXa9387CnFxIBuEj9wHQ&amp;f=0&amp;ui=6007882470930-id_51f2904c3d2ef2f25249809&amp;en=fad_hide&amp;ed=true&amp;a=1&amp;__tn__=v\" aria-haspopup=\"1\"></a></div></div><div class=\"title\"><script type=\"text/javascript\">try {\n    ((JSBNG_Record.scriptLoad)((\"function e4ca693ff3b871bfffd92997ec2c6db05cf16bb6a(event) {\\u000a    var meta = document.getElementById(\\\"meta_referrer\\\");\\u000a    meta.content = \\\"origin\\\";\\u000a    setTimeout(function() {\\u000a        meta.content = \\\"default\\\";\\u000a    }, 100);\\u000a    var attribute = \\\"href\\\";\\u000a    var ms = this.getAttribute(attribute).match(/([\\\\\\\\?|&]f=)([^&]*)/);\\u000a    if (ms) {\\u000a        this.setAttribute(attribute, this.getAttribute(attribute).replace(/[\\\\\\\\?|&]f=[^&]*/, (ms[1] + 0)));\\u000a    }\\u000a;\\u000a;\\u000a    var attribute = \\\"href\\\";\\u000a    var sig = this.getAttribute(attribute).match(/([\\\\\\\\?|&]sig=)([^&]*)/);\\u000a    if (sig) {\\u000a        this.setAttribute(attribute, this.getAttribute(attribute).replace(/[\\\\\\\\?|&]sig=[^&]*/, (sig[1] + ((Math.floor((Math.random() * 65535)) + 65536)))));\\u000a    }\\u000a;\\u000a;\\u000a};\"), (\"s625458d2e43b662571072377a04c208a8c560d62\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    function e4ca693ff3b871bfffd92997ec2c6db05cf16bb6a(JSBNG__event) {\n        if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n            return ((JSBNG_Record.eventCall)((arguments.callee), (\"s625458d2e43b662571072377a04c208a8c560d62_0\"), (s625458d2e43b662571072377a04c208a8c560d62_0_instance), (this), (arguments)))\n        };\n        (null);\n        var meta = (((JSBNG_Record.get)(JSBNG__document, (\"getElementById\")))[(\"getElementById\")])(\"meta_referrer\");\n        ((JSBNG_Record.set)(meta, (\"JSBNG__content\"), \"origin\"));\n        JSBNG__setTimeout(((function() {\n            var s625458d2e43b662571072377a04c208a8c560d62_1_instance;\n            ((s625458d2e43b662571072377a04c208a8c560d62_1_instance) = ((JSBNG_Record.eventInstance)((\"s625458d2e43b662571072377a04c208a8c560d62_1\"))));\n            return ((JSBNG_Record.markFunction)((function() {\n                if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                    return ((JSBNG_Record.eventCall)((arguments.callee), (\"s625458d2e43b662571072377a04c208a8c560d62_1\"), (s625458d2e43b662571072377a04c208a8c560d62_1_instance), (this), (arguments)))\n                };\n                (null);\n                ((JSBNG_Record.set)(meta, (\"JSBNG__content\"), \"default\"));\n            })));\n        })()), 100);\n        var attribute = \"href\";\n        var ms = (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"match\")))[(\"match\")])(/([\\\\?|&]f=)([^&]*)/);\n        if (ms) {\n            (((JSBNG_Record.get)(this, (\"setAttribute\")))[(\"setAttribute\")])(attribute, (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"replace\")))[(\"replace\")])(/[\\\\?|&]f=[^&]*/, ((((JSBNG_Record.get)(ms, 1))[1]) + 0)));\n        }\n        ;\n        ;\n        var attribute = \"href\";\n        var sig = (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"match\")))[(\"match\")])(/([\\\\?|&]sig=)([^&]*)/);\n        if (sig) {\n            (((JSBNG_Record.get)(this, (\"setAttribute\")))[(\"setAttribute\")])(attribute, (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"replace\")))[(\"replace\")])(/[\\\\?|&]sig=[^&]*/, ((((JSBNG_Record.get)(sig, 1))[1]) + (((((JSBNG_Record.get)(Math, (\"floor\")))[(\"floor\")])(((((JSBNG_Record.get)(Math, (\"JSBNG__random\")))[(\"JSBNG__random\")])() * 65535)) + 65536)))));\n        }\n        ;\n        ;\n    };\n    var s625458d2e43b662571072377a04c208a8c560d62_0_instance;\n    ((s625458d2e43b662571072377a04c208a8c560d62_0_instance) = ((JSBNG_Record.eventInstance)((\"s625458d2e43b662571072377a04c208a8c560d62_0\"))));\n    ((JSBNG_Record.markFunction)((e4ca693ff3b871bfffd92997ec2c6db05cf16bb6a)));\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};</script><a class=\"forceLTR emuEvent1 -cx-PUBLIC-fbEmu__link\" href=\"/ajax/emu/end.php?eid=AQKxDHTm3nyv_XoZgRGgtFyuIx1Dl-9n9KW0L1jI-n5_opSFWrvem0PGojZ7-0RQzO_Tu3Iopn9rwuueiyZ5RFrEsiTTZTDtW5iMmkly6EQLyYfHQodVCV7m8Wvq-wfpSOIQPIHd_g2dXRMVBRH6wAp9bF0Ocv3Vf9hewGLIcMIZMXjU9zH4vh8hPOQxLRh1KfX_eF0__zzpS_2FYUERtJoaHTL3yukbYbhqVMylaq79mmWtMKz2oevMrBL6C9XfDJL8ZQatILXq8rH0GE1wjp6stwakFdPMcymodiW_gBgSIkgqgDoOBg0gTuptQbZQL-vOtG_4tSaE6u0zZ55AkBeWEIxoYaL8gdQxT6QF2gHsXsPY7iMfNhX_kDUz0yiwwoNVsHVNt0d5iGn2pI-nqWFXwXReMNpxMT3Dih2hszZ46hykc4-4efJk0x2y53rLD0aB72b3VNlSvxc2XYux0MeKqhaVZmkZ7IUBo5M3W1OET70-5X_hID2-ZL5vkKVowUbD8PRMRx6794x6_n5bs9DnagwWJv8Z5B6w3YfZK1iRnablKyFNGaiAaVkOi4mdLoFBe-rhRt2ZGi6lRpgh3YphAHVeVeX18YPqSIDfZZpoDkAcmhyd98QHnz4jKpYd09hEsnITc3GhbUKeLLvbevEcgDfVUEp2XdJUpujBFAtEVYuzlJQ6h81g69e7P9Ar2oB2sMbNSLEdXf8BqyRwajlmyL1hmAGXH0ctzJ5ObeQP9cRU-PTUeIB1XyXGwWyzvg5UMHpY5hu0yuyUXmwepvCxgpQoswwF5GrDdhIDifHAH7qdtPm0Ww5OWAuzJrXUrGnS-\\-\\HM3V5vU7XJu2pw4iXtN3EvWeyo8MOQFrP-xr2JNI5DyLeJteh1Lb0Ax29Ze8XO5OmARtSq3MYMZSfa8AytYsBXQHGrpq7XrdFOV4yw2GV9_PBCux9l-D4yCGDHHNhnS7vVVrv6s5C1Ea4sVx86PN8IbKLoXOeI3Xcob8L9FAlT6-blUkqPMVMxHGREiFQSSh-HzSpiWdME_lqa_DuMhzuuEiDqwaZhuL0dEoJ6dX3bxAnEq7EFiaUwtmPFDAEGBAfgmxjM8OrvQLJTDdGxr_jZWEM7RFz9ATw2CPwMB7Jfxp7RpejOpLo6S4JFKNn3VemDxNDPI2mR83ybvgkApOGautfNG-a1DdbNjTCP5i36NpXyomF5OFRsKmVjRtmIX1xXmidb2pMvlx-XMj8Js1ZWq0Z6HODjep7RHMvMe47C7eD3uzY5m4lVXN9rC34WgXa9387CnFxIBuEj9wHQ&amp;f=1&amp;ui=6007882470930-id_51f2904c3d2ef2f25249809&amp;en=1&amp;a=0&amp;sig=102367&amp;__tn__=wv\" onmousedown=\"return e4ca693ff3b871bfffd92997ec2c6db05cf16bb6a.call(this, event);\">Like Cool Cars?</a></div><div class=\"clearfix image_body_block\"><script type=\"text/javascript\">try {\n    ((JSBNG_Record.scriptLoad)((\"function e53938e7627bca752056396fb818b0364b033db37(event) {\\u000a    var meta = document.getElementById(\\\"meta_referrer\\\");\\u000a    meta.content = \\\"origin\\\";\\u000a    setTimeout(function() {\\u000a        meta.content = \\\"default\\\";\\u000a    }, 100);\\u000a    var attribute = \\\"href\\\";\\u000a    var ms = this.getAttribute(attribute).match(/([\\\\\\\\?|&]f=)([^&]*)/);\\u000a    if (ms) {\\u000a        this.setAttribute(attribute, this.getAttribute(attribute).replace(/[\\\\\\\\?|&]f=[^&]*/, (ms[1] + 0)));\\u000a    }\\u000a;\\u000a;\\u000a    var attribute = \\\"href\\\";\\u000a    var sig = this.getAttribute(attribute).match(/([\\\\\\\\?|&]sig=)([^&]*)/);\\u000a    if (sig) {\\u000a        this.setAttribute(attribute, this.getAttribute(attribute).replace(/[\\\\\\\\?|&]sig=[^&]*/, (sig[1] + ((Math.floor((Math.random() * 65535)) + 65536)))));\\u000a    }\\u000a;\\u000a;\\u000a};\"), (\"s315c86651673789cd574fcdb8e1e6ff60f8c76c0\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    function e53938e7627bca752056396fb818b0364b033db37(JSBNG__event) {\n        if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n            return ((JSBNG_Record.eventCall)((arguments.callee), (\"s315c86651673789cd574fcdb8e1e6ff60f8c76c0_0\"), (s315c86651673789cd574fcdb8e1e6ff60f8c76c0_0_instance), (this), (arguments)))\n        };\n        (null);\n        var meta = (((JSBNG_Record.get)(JSBNG__document, (\"getElementById\")))[(\"getElementById\")])(\"meta_referrer\");\n        ((JSBNG_Record.set)(meta, (\"JSBNG__content\"), \"origin\"));\n        JSBNG__setTimeout(((function() {\n            var s315c86651673789cd574fcdb8e1e6ff60f8c76c0_1_instance;\n            ((s315c86651673789cd574fcdb8e1e6ff60f8c76c0_1_instance) = ((JSBNG_Record.eventInstance)((\"s315c86651673789cd574fcdb8e1e6ff60f8c76c0_1\"))));\n            return ((JSBNG_Record.markFunction)((function() {\n                if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                    return ((JSBNG_Record.eventCall)((arguments.callee), (\"s315c86651673789cd574fcdb8e1e6ff60f8c76c0_1\"), (s315c86651673789cd574fcdb8e1e6ff60f8c76c0_1_instance), (this), (arguments)))\n                };\n                (null);\n                ((JSBNG_Record.set)(meta, (\"JSBNG__content\"), \"default\"));\n            })));\n        })()), 100);\n        var attribute = \"href\";\n        var ms = (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"match\")))[(\"match\")])(/([\\\\?|&]f=)([^&]*)/);\n        if (ms) {\n            (((JSBNG_Record.get)(this, (\"setAttribute\")))[(\"setAttribute\")])(attribute, (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"replace\")))[(\"replace\")])(/[\\\\?|&]f=[^&]*/, ((((JSBNG_Record.get)(ms, 1))[1]) + 0)));\n        }\n        ;\n        ;\n        var attribute = \"href\";\n        var sig = (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"match\")))[(\"match\")])(/([\\\\?|&]sig=)([^&]*)/);\n        if (sig) {\n            (((JSBNG_Record.get)(this, (\"setAttribute\")))[(\"setAttribute\")])(attribute, (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"replace\")))[(\"replace\")])(/[\\\\?|&]sig=[^&]*/, ((((JSBNG_Record.get)(sig, 1))[1]) + (((((JSBNG_Record.get)(Math, (\"floor\")))[(\"floor\")])(((((JSBNG_Record.get)(Math, (\"JSBNG__random\")))[(\"JSBNG__random\")])() * 65535)) + 65536)))));\n        }\n        ;\n        ;\n    };\n    var s315c86651673789cd574fcdb8e1e6ff60f8c76c0_0_instance;\n    ((s315c86651673789cd574fcdb8e1e6ff60f8c76c0_0_instance) = ((JSBNG_Record.eventInstance)((\"s315c86651673789cd574fcdb8e1e6ff60f8c76c0_0\"))));\n    ((JSBNG_Record.markFunction)((e53938e7627bca752056396fb818b0364b033db37)));\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};</script><a class=\"forceLTR emuEvent1 -cx-PUBLIC-fbEmu__link image fbEmuImage -cx-PRIVATE-uiImageBlock__image -cx-PRIVATE-uiImageBlock__mediumimage lfloat\" tabindex=\"-1\" href=\"/ajax/emu/end.php?eid=AQKxDHTm3nyv_XoZgRGgtFyuIx1Dl-9n9KW0L1jI-n5_opSFWrvem0PGojZ7-0RQzO_Tu3Iopn9rwuueiyZ5RFrEsiTTZTDtW5iMmkly6EQLyYfHQodVCV7m8Wvq-wfpSOIQPIHd_g2dXRMVBRH6wAp9bF0Ocv3Vf9hewGLIcMIZMXjU9zH4vh8hPOQxLRh1KfX_eF0__zzpS_2FYUERtJoaHTL3yukbYbhqVMylaq79mmWtMKz2oevMrBL6C9XfDJL8ZQatILXq8rH0GE1wjp6stwakFdPMcymodiW_gBgSIkgqgDoOBg0gTuptQbZQL-vOtG_4tSaE6u0zZ55AkBeWEIxoYaL8gdQxT6QF2gHsXsPY7iMfNhX_kDUz0yiwwoNVsHVNt0d5iGn2pI-nqWFXwXReMNpxMT3Dih2hszZ46hykc4-4efJk0x2y53rLD0aB72b3VNlSvxc2XYux0MeKqhaVZmkZ7IUBo5M3W1OET70-5X_hID2-ZL5vkKVowUbD8PRMRx6794x6_n5bs9DnagwWJv8Z5B6w3YfZK1iRnablKyFNGaiAaVkOi4mdLoFBe-rhRt2ZGi6lRpgh3YphAHVeVeX18YPqSIDfZZpoDkAcmhyd98QHnz4jKpYd09hEsnITc3GhbUKeLLvbevEcgDfVUEp2XdJUpujBFAtEVYuzlJQ6h81g69e7P9Ar2oB2sMbNSLEdXf8BqyRwajlmyL1hmAGXH0ctzJ5ObeQP9cRU-PTUeIB1XyXGwWyzvg5UMHpY5hu0yuyUXmwepvCxgpQoswwF5GrDdhIDifHAH7qdtPm0Ww5OWAuzJrXUrGnS-\\-\\HM3V5vU7XJu2pw4iXtN3EvWeyo8MOQFrP-xr2JNI5DyLeJteh1Lb0Ax29Ze8XO5OmARtSq3MYMZSfa8AytYsBXQHGrpq7XrdFOV4yw2GV9_PBCux9l-D4yCGDHHNhnS7vVVrv6s5C1Ea4sVx86PN8IbKLoXOeI3Xcob8L9FAlT6-blUkqPMVMxHGREiFQSSh-HzSpiWdME_lqa_DuMhzuuEiDqwaZhuL0dEoJ6dX3bxAnEq7EFiaUwtmPFDAEGBAfgmxjM8OrvQLJTDdGxr_jZWEM7RFz9ATw2CPwMB7Jfxp7RpejOpLo6S4JFKNn3VemDxNDPI2mR83ybvgkApOGautfNG-a1DdbNjTCP5i36NpXyomF5OFRsKmVjRtmIX1xXmidb2pMvlx-XMj8Js1ZWq0Z6HODjep7RHMvMe47C7eD3uzY5m4lVXN9rC34WgXa9387CnFxIBuEj9wHQ&amp;f=1&amp;ui=6007882470930-id_51f2904c3d2ef2f25249809&amp;en=1&amp;a=0&amp;sig=99575&amp;__tn__=ywv\" onmousedown=\"return e53938e7627bca752056396fb818b0364b033db37.call(this, event);\" aria-hidden=\"true\"><img class=\"img\" src=\"http://jsbngssl.fbcdn-creative-a.akamaihd.net/hads-ak-prn1/s110x80/735300_6007844247530_1677760925_n.png\" alt=\"\" /></a><div class=\"-cx-PRIVATE-uiFlexibleBlock__flexiblecontent\"><div class=\"body\"><script type=\"text/javascript\">try {\n    ((JSBNG_Record.scriptLoad)((\"function efc72b1b3b01bbec2e62ddd82a8f5af9f0cbe1b78(event) {\\u000a    var meta = document.getElementById(\\\"meta_referrer\\\");\\u000a    meta.content = \\\"origin\\\";\\u000a    setTimeout(function() {\\u000a        meta.content = \\\"default\\\";\\u000a    }, 100);\\u000a    var attribute = \\\"href\\\";\\u000a    var ms = this.getAttribute(attribute).match(/([\\\\\\\\?|&]f=)([^&]*)/);\\u000a    if (ms) {\\u000a        this.setAttribute(attribute, this.getAttribute(attribute).replace(/[\\\\\\\\?|&]f=[^&]*/, (ms[1] + 0)));\\u000a    }\\u000a;\\u000a;\\u000a    var attribute = \\\"href\\\";\\u000a    var sig = this.getAttribute(attribute).match(/([\\\\\\\\?|&]sig=)([^&]*)/);\\u000a    if (sig) {\\u000a        this.setAttribute(attribute, this.getAttribute(attribute).replace(/[\\\\\\\\?|&]sig=[^&]*/, (sig[1] + ((Math.floor((Math.random() * 65535)) + 65536)))));\\u000a    }\\u000a;\\u000a;\\u000a};\"), (\"s400cb16d7b581757ddfcb762b81e5e5ec727070e\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    function efc72b1b3b01bbec2e62ddd82a8f5af9f0cbe1b78(JSBNG__event) {\n        if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n            return ((JSBNG_Record.eventCall)((arguments.callee), (\"s400cb16d7b581757ddfcb762b81e5e5ec727070e_0\"), (s400cb16d7b581757ddfcb762b81e5e5ec727070e_0_instance), (this), (arguments)))\n        };\n        (null);\n        var meta = (((JSBNG_Record.get)(JSBNG__document, (\"getElementById\")))[(\"getElementById\")])(\"meta_referrer\");\n        ((JSBNG_Record.set)(meta, (\"JSBNG__content\"), \"origin\"));\n        JSBNG__setTimeout(((function() {\n            var s400cb16d7b581757ddfcb762b81e5e5ec727070e_1_instance;\n            ((s400cb16d7b581757ddfcb762b81e5e5ec727070e_1_instance) = ((JSBNG_Record.eventInstance)((\"s400cb16d7b581757ddfcb762b81e5e5ec727070e_1\"))));\n            return ((JSBNG_Record.markFunction)((function() {\n                if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                    return ((JSBNG_Record.eventCall)((arguments.callee), (\"s400cb16d7b581757ddfcb762b81e5e5ec727070e_1\"), (s400cb16d7b581757ddfcb762b81e5e5ec727070e_1_instance), (this), (arguments)))\n                };\n                (null);\n                ((JSBNG_Record.set)(meta, (\"JSBNG__content\"), \"default\"));\n            })));\n        })()), 100);\n        var attribute = \"href\";\n        var ms = (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"match\")))[(\"match\")])(/([\\\\?|&]f=)([^&]*)/);\n        if (ms) {\n            (((JSBNG_Record.get)(this, (\"setAttribute\")))[(\"setAttribute\")])(attribute, (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"replace\")))[(\"replace\")])(/[\\\\?|&]f=[^&]*/, ((((JSBNG_Record.get)(ms, 1))[1]) + 0)));\n        }\n        ;\n        ;\n        var attribute = \"href\";\n        var sig = (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"match\")))[(\"match\")])(/([\\\\?|&]sig=)([^&]*)/);\n        if (sig) {\n            (((JSBNG_Record.get)(this, (\"setAttribute\")))[(\"setAttribute\")])(attribute, (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"replace\")))[(\"replace\")])(/[\\\\?|&]sig=[^&]*/, ((((JSBNG_Record.get)(sig, 1))[1]) + (((((JSBNG_Record.get)(Math, (\"floor\")))[(\"floor\")])(((((JSBNG_Record.get)(Math, (\"JSBNG__random\")))[(\"JSBNG__random\")])() * 65535)) + 65536)))));\n        }\n        ;\n        ;\n    };\n    var s400cb16d7b581757ddfcb762b81e5e5ec727070e_0_instance;\n    ((s400cb16d7b581757ddfcb762b81e5e5ec727070e_0_instance) = ((JSBNG_Record.eventInstance)((\"s400cb16d7b581757ddfcb762b81e5e5ec727070e_0\"))));\n    ((JSBNG_Record.markFunction)((efc72b1b3b01bbec2e62ddd82a8f5af9f0cbe1b78)));\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};</script><a class=\"forceLTR emuEvent1 -cx-PUBLIC-fbEmu__link\" href=\"/ajax/emu/end.php?eid=AQKxDHTm3nyv_XoZgRGgtFyuIx1Dl-9n9KW0L1jI-n5_opSFWrvem0PGojZ7-0RQzO_Tu3Iopn9rwuueiyZ5RFrEsiTTZTDtW5iMmkly6EQLyYfHQodVCV7m8Wvq-wfpSOIQPIHd_g2dXRMVBRH6wAp9bF0Ocv3Vf9hewGLIcMIZMXjU9zH4vh8hPOQxLRh1KfX_eF0__zzpS_2FYUERtJoaHTL3yukbYbhqVMylaq79mmWtMKz2oevMrBL6C9XfDJL8ZQatILXq8rH0GE1wjp6stwakFdPMcymodiW_gBgSIkgqgDoOBg0gTuptQbZQL-vOtG_4tSaE6u0zZ55AkBeWEIxoYaL8gdQxT6QF2gHsXsPY7iMfNhX_kDUz0yiwwoNVsHVNt0d5iGn2pI-nqWFXwXReMNpxMT3Dih2hszZ46hykc4-4efJk0x2y53rLD0aB72b3VNlSvxc2XYux0MeKqhaVZmkZ7IUBo5M3W1OET70-5X_hID2-ZL5vkKVowUbD8PRMRx6794x6_n5bs9DnagwWJv8Z5B6w3YfZK1iRnablKyFNGaiAaVkOi4mdLoFBe-rhRt2ZGi6lRpgh3YphAHVeVeX18YPqSIDfZZpoDkAcmhyd98QHnz4jKpYd09hEsnITc3GhbUKeLLvbevEcgDfVUEp2XdJUpujBFAtEVYuzlJQ6h81g69e7P9Ar2oB2sMbNSLEdXf8BqyRwajlmyL1hmAGXH0ctzJ5ObeQP9cRU-PTUeIB1XyXGwWyzvg5UMHpY5hu0yuyUXmwepvCxgpQoswwF5GrDdhIDifHAH7qdtPm0Ww5OWAuzJrXUrGnS-\\-\\HM3V5vU7XJu2pw4iXtN3EvWeyo8MOQFrP-xr2JNI5DyLeJteh1Lb0Ax29Ze8XO5OmARtSq3MYMZSfa8AytYsBXQHGrpq7XrdFOV4yw2GV9_PBCux9l-D4yCGDHHNhnS7vVVrv6s5C1Ea4sVx86PN8IbKLoXOeI3Xcob8L9FAlT6-blUkqPMVMxHGREiFQSSh-HzSpiWdME_lqa_DuMhzuuEiDqwaZhuL0dEoJ6dX3bxAnEq7EFiaUwtmPFDAEGBAfgmxjM8OrvQLJTDdGxr_jZWEM7RFz9ATw2CPwMB7Jfxp7RpejOpLo6S4JFKNn3VemDxNDPI2mR83ybvgkApOGautfNG-a1DdbNjTCP5i36NpXyomF5OFRsKmVjRtmIX1xXmidb2pMvlx-XMj8Js1ZWq0Z6HODjep7RHMvMe47C7eD3uzY5m4lVXN9rC34WgXa9387CnFxIBuEj9wHQ&amp;f=1&amp;ui=6007882470930-id_51f2904c3d2ef2f25249809&amp;en=1&amp;a=0&amp;sig=75951&amp;__tn__=xywv\" onmousedown=\"return efc72b1b3b01bbec2e62ddd82a8f5af9f0cbe1b78.call(this, event);\">We do.</a></div></div></div><div class=\"inline\"><div class=\"action\"><a class=\"uiIconText emuEventfad_fan -cx-PUBLIC-fbEmu__link\" href=\"#\" style=\"padding-left: 17px;\" rel=\"async-post\" ajaxify=\"/ajax/emu/end.php?eid=AQKxDHTm3nyv_XoZgRGgtFyuIx1Dl-9n9KW0L1jI-n5_opSFWrvem0PGojZ7-0RQzO_Tu3Iopn9rwuueiyZ5RFrEsiTTZTDtW5iMmkly6EQLyYfHQodVCV7m8Wvq-wfpSOIQPIHd_g2dXRMVBRH6wAp9bF0Ocv3Vf9hewGLIcMIZMXjU9zH4vh8hPOQxLRh1KfX_eF0__zzpS_2FYUERtJoaHTL3yukbYbhqVMylaq79mmWtMKz2oevMrBL6C9XfDJL8ZQatILXq8rH0GE1wjp6stwakFdPMcymodiW_gBgSIkgqgDoOBg0gTuptQbZQL-vOtG_4tSaE6u0zZ55AkBeWEIxoYaL8gdQxT6QF2gHsXsPY7iMfNhX_kDUz0yiwwoNVsHVNt0d5iGn2pI-nqWFXwXReMNpxMT3Dih2hszZ46hykc4-4efJk0x2y53rLD0aB72b3VNlSvxc2XYux0MeKqhaVZmkZ7IUBo5M3W1OET70-5X_hID2-ZL5vkKVowUbD8PRMRx6794x6_n5bs9DnagwWJv8Z5B6w3YfZK1iRnablKyFNGaiAaVkOi4mdLoFBe-rhRt2ZGi6lRpgh3YphAHVeVeX18YPqSIDfZZpoDkAcmhyd98QHnz4jKpYd09hEsnITc3GhbUKeLLvbevEcgDfVUEp2XdJUpujBFAtEVYuzlJQ6h81g69e7P9Ar2oB2sMbNSLEdXf8BqyRwajlmyL1hmAGXH0ctzJ5ObeQP9cRU-PTUeIB1XyXGwWyzvg5UMHpY5hu0yuyUXmwepvCxgpQoswwF5GrDdhIDifHAH7qdtPm0Ww5OWAuzJrXUrGnS-\\-\\HM3V5vU7XJu2pw4iXtN3EvWeyo8MOQFrP-xr2JNI5DyLeJteh1Lb0Ax29Ze8XO5OmARtSq3MYMZSfa8AytYsBXQHGrpq7XrdFOV4yw2GV9_PBCux9l-D4yCGDHHNhnS7vVVrv6s5C1Ea4sVx86PN8IbKLoXOeI3Xcob8L9FAlT6-blUkqPMVMxHGREiFQSSh-HzSpiWdME_lqa_DuMhzuuEiDqwaZhuL0dEoJ6dX3bxAnEq7EFiaUwtmPFDAEGBAfgmxjM8OrvQLJTDdGxr_jZWEM7RFz9ATw2CPwMB7Jfxp7RpejOpLo6S4JFKNn3VemDxNDPI2mR83ybvgkApOGautfNG-a1DdbNjTCP5i36NpXyomF5OFRsKmVjRtmIX1xXmidb2pMvlx-XMj8Js1ZWq0Z6HODjep7RHMvMe47C7eD3uzY5m4lVXN9rC34WgXa9387CnFxIBuEj9wHQ&amp;f=0&amp;ui=6007882470930-id_51f2904c3d2ef2f25249809&amp;en=fad_fan&amp;ed=457438810959776&amp;a=1&amp;__tn__=wv\" role=\"button\"><i class=\"img sp_4p6kmz sx_bc56c4\" style=\"top: 1px;\"></i>Like</a> · <span class=\"fbEmuContext\">2,957 people like <script type=\"text/javascript\">try {\n    ((JSBNG_Record.scriptLoad)((\"function ed363dd5b4457ddc178baa0792dfbc150ae3c2958(event) {\\u000a    var meta = document.getElementById(\\\"meta_referrer\\\");\\u000a    meta.content = \\\"origin\\\";\\u000a    setTimeout(function() {\\u000a        meta.content = \\\"default\\\";\\u000a    }, 100);\\u000a    var attribute = \\\"href\\\";\\u000a    var ms = this.getAttribute(attribute).match(/([\\\\\\\\?|&]f=)([^&]*)/);\\u000a    if (ms) {\\u000a        this.setAttribute(attribute, this.getAttribute(attribute).replace(/[\\\\\\\\?|&]f=[^&]*/, (ms[1] + 0)));\\u000a    }\\u000a;\\u000a;\\u000a    var attribute = \\\"href\\\";\\u000a    var sig = this.getAttribute(attribute).match(/([\\\\\\\\?|&]sig=)([^&]*)/);\\u000a    if (sig) {\\u000a        this.setAttribute(attribute, this.getAttribute(attribute).replace(/[\\\\\\\\?|&]sig=[^&]*/, (sig[1] + ((Math.floor((Math.random() * 65535)) + 65536)))));\\u000a    }\\u000a;\\u000a;\\u000a};\"), (\"s9a2220cdebe3ad13d68296225760bff7aab5543b\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    function ed363dd5b4457ddc178baa0792dfbc150ae3c2958(JSBNG__event) {\n        if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n            return ((JSBNG_Record.eventCall)((arguments.callee), (\"s9a2220cdebe3ad13d68296225760bff7aab5543b_0\"), (s9a2220cdebe3ad13d68296225760bff7aab5543b_0_instance), (this), (arguments)))\n        };\n        (null);\n        var meta = (((JSBNG_Record.get)(JSBNG__document, (\"getElementById\")))[(\"getElementById\")])(\"meta_referrer\");\n        ((JSBNG_Record.set)(meta, (\"JSBNG__content\"), \"origin\"));\n        JSBNG__setTimeout(((function() {\n            var s9a2220cdebe3ad13d68296225760bff7aab5543b_1_instance;\n            ((s9a2220cdebe3ad13d68296225760bff7aab5543b_1_instance) = ((JSBNG_Record.eventInstance)((\"s9a2220cdebe3ad13d68296225760bff7aab5543b_1\"))));\n            return ((JSBNG_Record.markFunction)((function() {\n                if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                    return ((JSBNG_Record.eventCall)((arguments.callee), (\"s9a2220cdebe3ad13d68296225760bff7aab5543b_1\"), (s9a2220cdebe3ad13d68296225760bff7aab5543b_1_instance), (this), (arguments)))\n                };\n                (null);\n                ((JSBNG_Record.set)(meta, (\"JSBNG__content\"), \"default\"));\n            })));\n        })()), 100);\n        var attribute = \"href\";\n        var ms = (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"match\")))[(\"match\")])(/([\\\\?|&]f=)([^&]*)/);\n        if (ms) {\n            (((JSBNG_Record.get)(this, (\"setAttribute\")))[(\"setAttribute\")])(attribute, (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"replace\")))[(\"replace\")])(/[\\\\?|&]f=[^&]*/, ((((JSBNG_Record.get)(ms, 1))[1]) + 0)));\n        }\n        ;\n        ;\n        var attribute = \"href\";\n        var sig = (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"match\")))[(\"match\")])(/([\\\\?|&]sig=)([^&]*)/);\n        if (sig) {\n            (((JSBNG_Record.get)(this, (\"setAttribute\")))[(\"setAttribute\")])(attribute, (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"getAttribute\")))[(\"getAttribute\")])(attribute), (\"replace\")))[(\"replace\")])(/[\\\\?|&]sig=[^&]*/, ((((JSBNG_Record.get)(sig, 1))[1]) + (((((JSBNG_Record.get)(Math, (\"floor\")))[(\"floor\")])(((((JSBNG_Record.get)(Math, (\"JSBNG__random\")))[(\"JSBNG__random\")])() * 65535)) + 65536)))));\n        }\n        ;\n        ;\n    };\n    var s9a2220cdebe3ad13d68296225760bff7aab5543b_0_instance;\n    ((s9a2220cdebe3ad13d68296225760bff7aab5543b_0_instance) = ((JSBNG_Record.eventInstance)((\"s9a2220cdebe3ad13d68296225760bff7aab5543b_0\"))));\n    ((JSBNG_Record.markFunction)((ed363dd5b4457ddc178baa0792dfbc150ae3c2958)));\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};</script><a class=\"emuEventfad_pageclick -cx-PUBLIC-fbEmu__link\" href=\"/ajax/emu/end.php?eid=AQKxDHTm3nyv_XoZgRGgtFyuIx1Dl-9n9KW0L1jI-n5_opSFWrvem0PGojZ7-0RQzO_Tu3Iopn9rwuueiyZ5RFrEsiTTZTDtW5iMmkly6EQLyYfHQodVCV7m8Wvq-wfpSOIQPIHd_g2dXRMVBRH6wAp9bF0Ocv3Vf9hewGLIcMIZMXjU9zH4vh8hPOQxLRh1KfX_eF0__zzpS_2FYUERtJoaHTL3yukbYbhqVMylaq79mmWtMKz2oevMrBL6C9XfDJL8ZQatILXq8rH0GE1wjp6stwakFdPMcymodiW_gBgSIkgqgDoOBg0gTuptQbZQL-vOtG_4tSaE6u0zZ55AkBeWEIxoYaL8gdQxT6QF2gHsXsPY7iMfNhX_kDUz0yiwwoNVsHVNt0d5iGn2pI-nqWFXwXReMNpxMT3Dih2hszZ46hykc4-4efJk0x2y53rLD0aB72b3VNlSvxc2XYux0MeKqhaVZmkZ7IUBo5M3W1OET70-5X_hID2-ZL5vkKVowUbD8PRMRx6794x6_n5bs9DnagwWJv8Z5B6w3YfZK1iRnablKyFNGaiAaVkOi4mdLoFBe-rhRt2ZGi6lRpgh3YphAHVeVeX18YPqSIDfZZpoDkAcmhyd98QHnz4jKpYd09hEsnITc3GhbUKeLLvbevEcgDfVUEp2XdJUpujBFAtEVYuzlJQ6h81g69e7P9Ar2oB2sMbNSLEdXf8BqyRwajlmyL1hmAGXH0ctzJ5ObeQP9cRU-PTUeIB1XyXGwWyzvg5UMHpY5hu0yuyUXmwepvCxgpQoswwF5GrDdhIDifHAH7qdtPm0Ww5OWAuzJrXUrGnS-\\-\\HM3V5vU7XJu2pw4iXtN3EvWeyo8MOQFrP-xr2JNI5DyLeJteh1Lb0Ax29Ze8XO5OmARtSq3MYMZSfa8AytYsBXQHGrpq7XrdFOV4yw2GV9_PBCux9l-D4yCGDHHNhnS7vVVrv6s5C1Ea4sVx86PN8IbKLoXOeI3Xcob8L9FAlT6-blUkqPMVMxHGREiFQSSh-HzSpiWdME_lqa_DuMhzuuEiDqwaZhuL0dEoJ6dX3bxAnEq7EFiaUwtmPFDAEGBAfgmxjM8OrvQLJTDdGxr_jZWEM7RFz9ATw2CPwMB7Jfxp7RpejOpLo6S4JFKNn3VemDxNDPI2mR83ybvgkApOGautfNG-a1DdbNjTCP5i36NpXyomF5OFRsKmVjRtmIX1xXmidb2pMvlx-XMj8Js1ZWq0Z6HODjep7RHMvMe47C7eD3uzY5m4lVXN9rC34WgXa9387CnFxIBuEj9wHQ&amp;f=1&amp;ui=6007882470930-id_51f2904c3d2ef2f25249809&amp;en=fad_pageclick&amp;ed=457438810959776&amp;a=0&amp;mac=AQJo4bLN86ypaeU2&amp;sig=67548&amp;__tn__=zwv\" onmousedown=\"return ed363dd5b4457ddc178baa0792dfbc150ae3c2958.call(this, event);\">Autoswaprz.com</a>.</span></div></div></div></div></div></div></div></div> ";
// undefined
o96 = null;
// 7264
o94.parentNode = o16;
// 7266
f81632121_521.returns.push(o94);
// undefined
o94 = null;
// 7267
// 7268
o93.getAttribute = f81632121_506;
// 7269
f81632121_506.returns.push("u_0_2s");
// 7280
f81632121_467.returns.push(1374851216009);
// 7284
o94 = {};
// 7285
f81632121_474.returns.push(o94);
// 7287
f81632121_478.returns.push(o94);
// undefined
o94 = null;
// 7290
f81632121_467.returns.push(1374851216009);
// 7293
f81632121_467.returns.push(1374851216009);
// 7296
f81632121_467.returns.push(1374851216010);
// 7299
f81632121_467.returns.push(1374851216011);
// 7303
o94 = {};
// 7304
f81632121_474.returns.push(o94);
// 7306
f81632121_478.returns.push(o94);
// undefined
o94 = null;
// 7307
o94 = {};
// 7309
f81632121_469.returns.push(undefined);
// 7310
o96 = {};
// 7313
f81632121_1124.returns.push(undefined);
// 7314
o96.cancelBubble = false;
// 7316
o96.state = null;
// 7318
o96.returnValue = true;
// undefined
o96 = null;
// 7319
o96 = {};
// undefined
o96 = null;
// 7320
// 7321
// undefined
o83 = null;
// 7324
f81632121_467.returns.push(1374851216013);
// 7327
f81632121_467.returns.push(1374851216013);
// 7329
o83 = {};
// 7330
f81632121_508.returns.push(o83);
// 7332
o96 = {};
// 7333
f81632121_508.returns.push(o96);
// 7334
o97 = {};
// 7335
o96.firstChild = o97;
// 7337
o97.nodeType = 8;
// 7339
o97.nodeValue = " <div class=\"-cx-PRIVATE-fbDock__root fbDockWrapper fbDockWrapperRight\" id=\"u_0_2u\"><div class=\"fbDock clearfix\"><div class=\"clearfix nubContainer rNubContainer\"><div id=\"ChatTabsPagelet\" data-referrer=\"ChatTabsPagelet\"><div class=\"fbNubGroup clearfix -cx-PUBLIC-fbMercuryChatTab__container\" id=\"u_0_2v\"><div class=\"fbNubGroup clearfix\" id=\"u_0_2w\"></div></div></div><div id=\"BuddylistPagelet\" data-referrer=\"BuddylistPagelet\"><div class=\"-cx-PUBLIC-fbDockChatBuddyListNub__container\"><div class=\"uiToggle -cx-PRIVATE-fbNub__root fbNub -cx-PUBLIC-fbDockChatBuddyListNub__root hide_on_presence_error\" id=\"fbDockChatBuddylistNub\"><a class=\"fbNubButton\" tabindex=\"0\" href=\"#\" rel=\"toggle\" role=\"button\"><span class=\"-cx-PRIVATE-fbDockChatBuddyListNub__unreadcount rfloat\"></span><img class=\"icon lfloat img\" src=\"http://jsbngssl.static.xx.fbcdn.net/rsrc.php/v2/y4/r/-PAXP-deijE.gif\" alt=\"\" width=\"1\" height=\"1\" /><span class=\"label\">Chat<span class=\"count\"> (<strong>0</strong>)</span></span></a><div class=\"fbNubFlyout uiToggleFlyout\"><div class=\"fbNubFlyoutOuter\"><div class=\"fbNubFlyoutInner\"><div class=\"clearfix fbNubFlyoutTitlebar\" data-jsid=\"nubFlyoutTitlebar\"><div class=\"uiSelector inlineBlock fbChatSidebarDropdown button rfloat uiSelectorRight\" id=\"u_0_31\" data-multiple=\"1\"><div class=\"uiToggle wrap\"><a data-hover=\"tooltip\" aria-label=\"Options\" class=\"uiSelectorButton uiCloseButton\" href=\"#\" role=\"button\" aria-haspopup=\"1\" rel=\"toggle\"></a><div class=\"uiSelectorMenuWrapper uiToggleFlyout\"><div role=\"menu\" class=\"uiMenu uiSelectorMenu\"><ul class=\"uiMenuInner\"><li class=\"uiMenuItem uiMenuItemCheckbox uiSelectorOption checked\" data-label=\"Chat Sounds\"><a class=\"itemAnchor\" role=\"menuitemcheckbox\" tabindex=\"0\" href=\"#\" aria-checked=\"true\"><span class=\"itemLabel fsm\">Chat Sounds</span></a></li><li class=\"uiMenuItem uiMenuItemCheckbox uiSelectorOption\" data-label=\"Advanced Settings...\"><a class=\"itemAnchor\" role=\"menuitemcheckbox\" tabindex=\"-1\" href=\"/ajax/chat/privacy/settings_dialog.php\" aria-checked=\"false\" rel=\"dialog\"><span class=\"itemLabel fsm\">Advanced Settings...</span></a></li><li class=\"uiMenuSeparator\"></li><li class=\"uiMenuItem uiMenuItemCheckbox uiSelectorOption fbChatGoOnlineItem\" data-label=\"Turn On Chat\"><a class=\"itemAnchor\" role=\"menuitemcheckbox\" tabindex=\"-1\" href=\"#\" aria-checked=\"false\"><span class=\"itemLabel fsm\">Turn On Chat</span></a></li><li class=\"uiMenuItem uiMenuItemCheckbox uiSelectorOption fbChatGoOfflineItem\" data-label=\"Turn Off Chat\"><a class=\"itemAnchor\" role=\"menuitemcheckbox\" tabindex=\"-1\" href=\"/ajax/chat/privacy/turn_off_dialog.php\" aria-checked=\"false\" rel=\"dialog\"><span class=\"itemLabel fsm\">Turn Off Chat</span></a></li></ul></div></div></div><select multiple=\"1\"><option value=\"\" disabled=\"1\"></option><option value=\"sound\" selected=\"1\">Chat Sounds</option><option value=\"advanced_settings\">Advanced Settings...</option><option value=\"online\">Turn On Chat</option><option value=\"turn_off_dialog\">Turn Off Chat</option></select></div><div class=\"titlebarLabel clearfix\"><div class=\"titlebarTextWrapper\">Chat</div></div></div><div class=\"fbNubFlyoutBody scrollable\"><div class=\"fbNubFlyoutBodyContent\"><div id=\"u_0_33\"><ul class=\"fbChatOrderedList clearfix\"><li><div class=\"phs fcg\"><span data-jsid=\"message\">Loading...</span></div></li></ul></div><div class=\"fbChatTypeaheadView hidden_elem\" id=\"u_0_2x\"></div></div></div><div class=\"fbNubFlyoutFooter\"><div class=\"-cx-PRIVATE-fbDockChatBuddyListNub__messageouter clearfix\"><img class=\"img\" src=\"http://jsbngssl.static.xx.fbcdn.net/rsrc.php/v2/y4/r/-PAXP-deijE.gif\" alt=\"\" width=\"1\" height=\"1\" /><div class=\"-cx-PRIVATE-fbDockChatBuddyListNub__message fcg\"></div></div><div class=\"uiTypeahead uiClearableTypeahead fbChatTypeahead\" id=\"u_0_2y\"><div class=\"wrap\"><script type=\"text/javascript\">try {\n    ((JSBNG_Record.scriptLoad)((\"function ea7e383ecd3b5f6b16e83b00b802333ed8e45c8c9(event) {\\u000a\\u000a};\"), (\"s0b82d3ea0afb5d2199e454492c80deca405e1fc9\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    function ea7e383ecd3b5f6b16e83b00b802333ed8e45c8c9(JSBNG__event) {\n        if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n            return ((JSBNG_Record.eventCall)((arguments.callee), (\"s0b82d3ea0afb5d2199e454492c80deca405e1fc9_0\"), (s0b82d3ea0afb5d2199e454492c80deca405e1fc9_0_instance), (this), (arguments)))\n        };\n        (null);\n    ;\n    };\n    var s0b82d3ea0afb5d2199e454492c80deca405e1fc9_0_instance;\n    ((s0b82d3ea0afb5d2199e454492c80deca405e1fc9_0_instance) = ((JSBNG_Record.eventInstance)((\"s0b82d3ea0afb5d2199e454492c80deca405e1fc9_0\"))));\n    ((JSBNG_Record.markFunction)((ea7e383ecd3b5f6b16e83b00b802333ed8e45c8c9)));\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};</script><button class=\"-cx-PRIVATE-abstractButton__root -cx-PRIVATE-xuiCloseButton__root clear uiTypeaheadCloseButton -cx-PRIVATE-xuiCloseButton__medium -cx-PRIVATE-xuiCloseButton__dark\" title=\"Remove\" onclick=\"return ea7e383ecd3b5f6b16e83b00b802333ed8e45c8c9.call(this, event);\" type=\"button\" id=\"u_0_2z\">Remove</button><input type=\"hidden\" autocomplete=\"off\" class=\"hiddenInput\" /><div class=\"innerWrap\"><input type=\"text\" class=\"inputtext inputsearch textInput DOMControl_placeholder\" autocomplete=\"off\" placeholder=\"Search\" aria-autocomplete=\"list\" aria-expanded=\"false\" aria-owns=\"typeahead_list_u_0_2y\" role=\"combobox\" spellcheck=\"false\" value=\"Search\" aria-label=\"Search\" id=\"u_0_30\" /></div><img class=\"throbber uiLoadingIndicatorAsync img\" src=\"http://jsbngssl.static.xx.fbcdn.net/rsrc.php/v2/yb/r/GsNJNwuI-UM.gif\" alt=\"\" width=\"16\" height=\"11\" /></div></div></div></div></div></div></div></div></div></div></div></div><div id=\"u_0_34\"></div> ";
// undefined
o97 = null;
// 7340
o96.parentNode = o16;
// 7342
f81632121_521.returns.push(o96);
// undefined
o96 = null;
// 7343
// 7344
o83.getAttribute = f81632121_506;
// 7345
f81632121_506.returns.push("pagelet_dock");
// 7400
o96 = {};
// 7401
f81632121_476.returns.push(o96);
// 7402
// 7403
// 7404
o96.getElementsByTagName = f81632121_502;
// 7405
o97 = {};
// 7406
f81632121_502.returns.push(o97);
// 7407
o97.length = 0;
// undefined
o97 = null;
// 7409
o97 = {};
// 7410
o96.childNodes = o97;
// undefined
o96 = null;
// 7411
o97.nodeType = void 0;
// 7412
o97.getAttributeNode = void 0;
// 7413
o97.getElementsByTagName = void 0;
// 7414
o97.childNodes = void 0;
// undefined
o97 = null;
// 7417
o96 = {};
// 7418
f81632121_476.returns.push(o96);
// 7419
// 7420
// 7421
o96.getElementsByTagName = f81632121_502;
// 7422
o97 = {};
// 7423
f81632121_502.returns.push(o97);
// 7424
o97.length = 0;
// undefined
o97 = null;
// 7426
o97 = {};
// 7427
o96.childNodes = o97;
// undefined
o96 = null;
// 7428
o97.nodeType = void 0;
// 7429
o97.getAttributeNode = void 0;
// 7430
o97.getElementsByTagName = void 0;
// 7431
o97.childNodes = void 0;
// undefined
o97 = null;
// 7441
o96 = {};
// 7442
f81632121_476.returns.push(o96);
// 7443
// 7444
// 7445
o96.getElementsByTagName = f81632121_502;
// 7446
o97 = {};
// 7447
f81632121_502.returns.push(o97);
// 7448
o97.length = 0;
// undefined
o97 = null;
// 7450
o97 = {};
// 7451
o96.childNodes = o97;
// undefined
o96 = null;
// 7452
o97.nodeType = void 0;
// 7453
o97.getAttributeNode = void 0;
// 7454
o97.getElementsByTagName = void 0;
// 7455
o97.childNodes = void 0;
// undefined
o97 = null;
// 7539
f81632121_467.returns.push(1374851216135);
// 7543
f81632121_467.returns.push(1374851216136);
// 7548
o96 = {};
// 7549
f81632121_474.returns.push(o96);
// 7551
f81632121_467.returns.push(1374851216137);
// 7553
o97 = {};
// 7554
f81632121_476.returns.push(o97);
// 7555
// 7556
// 7557
// 7558
// 7559
// 7560
// 7561
o96.appendChild = f81632121_478;
// 7562
f81632121_478.returns.push(o97);
// undefined
o97 = null;
// 7564
f81632121_467.returns.push(1374851216137);
// 7566
o97 = {};
// 7567
f81632121_476.returns.push(o97);
// 7568
// 7569
// 7570
// 7571
// 7572
// 7573
// 7575
f81632121_478.returns.push(o97);
// undefined
o97 = null;
// 7577
f81632121_467.returns.push(1374851216138);
// 7579
o97 = {};
// 7580
f81632121_476.returns.push(o97);
// 7581
// 7582
// 7583
// 7584
// 7585
// 7586
// 7588
f81632121_478.returns.push(o97);
// undefined
o97 = null;
// 7590
f81632121_467.returns.push(1374851216138);
// 7592
o97 = {};
// 7593
f81632121_476.returns.push(o97);
// 7594
// 7595
// 7596
// 7597
// 7598
// 7599
// 7601
f81632121_478.returns.push(o97);
// undefined
o97 = null;
// 7603
f81632121_467.returns.push(1374851216139);
// 7605
o97 = {};
// 7606
f81632121_476.returns.push(o97);
// 7607
// 7608
// 7609
// 7610
// 7611
// 7612
// 7614
f81632121_478.returns.push(o97);
// undefined
o97 = null;
// 7616
f81632121_467.returns.push(1374851216140);
// 7618
o97 = {};
// 7619
f81632121_476.returns.push(o97);
// 7620
// 7621
// 7622
// 7623
// 7624
// 7625
// 7627
f81632121_478.returns.push(o97);
// undefined
o97 = null;
// 7629
f81632121_467.returns.push(1374851216144);
// 7631
o97 = {};
// 7632
f81632121_476.returns.push(o97);
// 7633
// 7634
// 7635
// 7636
// 7637
// 7638
// 7640
f81632121_478.returns.push(o97);
// undefined
o97 = null;
// 7642
f81632121_467.returns.push(1374851216145);
// 7644
o97 = {};
// 7645
f81632121_476.returns.push(o97);
// 7646
// 7647
// 7648
// 7649
// 7650
// 7651
// 7653
f81632121_478.returns.push(o97);
// undefined
o97 = null;
// 7655
f81632121_467.returns.push(1374851216145);
// 7657
o97 = {};
// 7658
f81632121_476.returns.push(o97);
// 7659
// 7660
// 7661
// 7662
// 7663
// 7664
// 7666
f81632121_478.returns.push(o97);
// undefined
o97 = null;
// 7668
f81632121_467.returns.push(1374851216145);
// 7670
o97 = {};
// 7671
f81632121_476.returns.push(o97);
// 7672
// 7673
// 7674
// 7675
// 7676
// 7677
// 7679
f81632121_478.returns.push(o97);
// undefined
o97 = null;
// 7681
f81632121_467.returns.push(1374851216146);
// 7683
o97 = {};
// 7684
f81632121_476.returns.push(o97);
// 7685
// 7686
// 7687
// 7688
// 7689
// 7690
// 7692
f81632121_478.returns.push(o97);
// undefined
o97 = null;
// 7694
f81632121_478.returns.push(o96);
// undefined
o96 = null;
// 7697
f81632121_467.returns.push(1374851216149);
// 7701
o96 = {};
// 7702
f81632121_474.returns.push(o96);
// 7704
f81632121_467.returns.push(1374851216150);
// 7706
o97 = {};
// 7707
f81632121_476.returns.push(o97);
// 7708
// 7709
// 7710
// 7711
// 7712
// 7713
// 7714
o96.appendChild = f81632121_478;
// 7715
f81632121_478.returns.push(o97);
// undefined
o97 = null;
// 7717
f81632121_478.returns.push(o96);
// undefined
o96 = null;
// 7720
f81632121_467.returns.push(1374851216152);
// 7724
o96 = {};
// 7725
f81632121_474.returns.push(o96);
// 7727
f81632121_467.returns.push(1374851216159);
// 7729
o97 = {};
// 7730
f81632121_476.returns.push(o97);
// 7731
// 7732
// 7733
// 7734
// 7735
// 7736
// 7737
o96.appendChild = f81632121_478;
// 7738
f81632121_478.returns.push(o97);
// undefined
o97 = null;
// 7740
f81632121_467.returns.push(1374851216159);
// 7742
o97 = {};
// 7743
f81632121_476.returns.push(o97);
// 7744
// 7745
// 7746
// 7747
// 7748
// 7749
// 7751
f81632121_478.returns.push(o97);
// undefined
o97 = null;
// 7753
f81632121_467.returns.push(1374851216160);
// 7755
o97 = {};
// 7756
f81632121_476.returns.push(o97);
// 7757
// 7758
// 7759
// 7760
// 7761
// 7762
// 7764
f81632121_478.returns.push(o97);
// undefined
o97 = null;
// 7766
f81632121_467.returns.push(1374851216160);
// 7768
o97 = {};
// 7769
f81632121_476.returns.push(o97);
// 7770
// 7771
// 7772
// 7773
// 7774
// 7775
// 7777
f81632121_478.returns.push(o97);
// undefined
o97 = null;
// 7779
f81632121_467.returns.push(1374851216160);
// 7781
o97 = {};
// 7782
f81632121_476.returns.push(o97);
// 7783
// 7784
// 7785
// 7786
// 7787
// 7788
// 7790
f81632121_478.returns.push(o97);
// undefined
o97 = null;
// 7792
f81632121_478.returns.push(o96);
// undefined
o96 = null;
// 7795
f81632121_467.returns.push(1374851216161);
// 7799
o96 = {};
// 7800
f81632121_474.returns.push(o96);
// 7802
f81632121_467.returns.push(1374851216162);
// 7804
o97 = {};
// 7805
f81632121_476.returns.push(o97);
// 7806
// 7807
// 7808
// 7809
// 7810
// 7811
// 7812
o96.appendChild = f81632121_478;
// 7813
f81632121_478.returns.push(o97);
// undefined
o97 = null;
// 7815
f81632121_478.returns.push(o96);
// undefined
o96 = null;
// 7818
f81632121_467.returns.push(1374851216162);
// 7822
o96 = {};
// 7823
f81632121_474.returns.push(o96);
// 7825
f81632121_478.returns.push(o96);
// undefined
o96 = null;
// 7828
f81632121_467.returns.push(1374851216172);
// 7832
o96 = {};
// 7833
f81632121_474.returns.push(o96);
// 7835
f81632121_467.returns.push(1374851216172);
// 7837
o97 = {};
// 7838
f81632121_476.returns.push(o97);
// 7839
// 7840
// 7841
// 7842
// 7843
// 7844
// 7845
o96.appendChild = f81632121_478;
// 7846
f81632121_478.returns.push(o97);
// undefined
o97 = null;
// 7848
f81632121_478.returns.push(o96);
// undefined
o96 = null;
// 7851
f81632121_467.returns.push(1374851216173);
// 7855
o96 = {};
// 7856
f81632121_474.returns.push(o96);
// 7858
f81632121_478.returns.push(o96);
// undefined
o96 = null;
// 7861
f81632121_467.returns.push(1374851216173);
// 7864
f81632121_467.returns.push(1374851216174);
// 7868
o96 = {};
// 7869
f81632121_474.returns.push(o96);
// 7871
f81632121_478.returns.push(o96);
// undefined
o96 = null;
// 7874
f81632121_467.returns.push(1374851216174);
// 7878
o96 = {};
// 7879
f81632121_474.returns.push(o96);
// 7881
f81632121_467.returns.push(1374851216175);
// 7883
o97 = {};
// 7884
f81632121_476.returns.push(o97);
// 7885
// 7886
// 7887
// 7888
// 7889
// 7890
// 7891
o96.appendChild = f81632121_478;
// 7892
f81632121_478.returns.push(o97);
// undefined
o97 = null;
// 7894
f81632121_478.returns.push(o96);
// undefined
o96 = null;
// 7897
f81632121_467.returns.push(1374851216176);
// 7901
o96 = {};
// 7902
f81632121_474.returns.push(o96);
// 7904
f81632121_467.returns.push(1374851216177);
// 7906
o97 = {};
// 7907
f81632121_476.returns.push(o97);
// 7908
// 7909
// 7910
// 7911
// 7912
// 7913
// 7914
o96.appendChild = f81632121_478;
// 7915
f81632121_478.returns.push(o97);
// undefined
o97 = null;
// 7917
f81632121_467.returns.push(1374851216178);
// 7919
o97 = {};
// 7920
f81632121_476.returns.push(o97);
// 7921
// 7922
// 7923
// 7924
// 7925
// 7926
// 7928
f81632121_478.returns.push(o97);
// undefined
o97 = null;
// 7930
f81632121_467.returns.push(1374851216183);
// 7932
o97 = {};
// 7933
f81632121_476.returns.push(o97);
// 7934
// 7935
// 7936
// 7937
// 7938
// 7939
// 7941
f81632121_478.returns.push(o97);
// undefined
o97 = null;
// 7943
f81632121_467.returns.push(1374851216183);
// 7945
o97 = {};
// 7946
f81632121_476.returns.push(o97);
// 7947
// 7948
// 7949
// 7950
// 7951
// 7952
// 7954
f81632121_478.returns.push(o97);
// undefined
o97 = null;
// 7956
f81632121_478.returns.push(o96);
// undefined
o96 = null;
// 7959
f81632121_467.returns.push(1374851216184);
// 7963
o96 = {};
// 7964
f81632121_474.returns.push(o96);
// 7966
f81632121_478.returns.push(o96);
// undefined
o96 = null;
// 7969
f81632121_467.returns.push(1374851216185);
// 7973
o96 = {};
// 7974
f81632121_474.returns.push(o96);
// 7976
f81632121_467.returns.push(1374851216185);
// 7978
o97 = {};
// 7979
f81632121_476.returns.push(o97);
// 7980
// 7981
// 7982
// 7983
// 7984
// 7985
// 7986
o96.appendChild = f81632121_478;
// 7987
f81632121_478.returns.push(o97);
// undefined
o97 = null;
// 7989
f81632121_478.returns.push(o96);
// undefined
o96 = null;
// 7992
f81632121_467.returns.push(1374851216186);
// 7995
f81632121_467.returns.push(1374851216186);
// 7999
o96 = {};
// 8000
f81632121_474.returns.push(o96);
// 8002
f81632121_478.returns.push(o96);
// undefined
o96 = null;
// 8005
f81632121_467.returns.push(1374851216186);
// 8009
o96 = {};
// 8010
f81632121_474.returns.push(o96);
// 8012
f81632121_478.returns.push(o96);
// undefined
o96 = null;
// 8015
f81632121_467.returns.push(1374851216187);
// 8019
o96 = {};
// 8020
f81632121_474.returns.push(o96);
// 8022
f81632121_478.returns.push(o96);
// undefined
o96 = null;
// 8025
f81632121_467.returns.push(1374851216191);
// 8029
o96 = {};
// 8030
f81632121_474.returns.push(o96);
// 8032
f81632121_478.returns.push(o96);
// undefined
o96 = null;
// 8035
f81632121_467.returns.push(1374851216192);
// 8039
o96 = {};
// 8040
f81632121_474.returns.push(o96);
// 8042
f81632121_478.returns.push(o96);
// undefined
o96 = null;
// 8045
f81632121_467.returns.push(1374851216192);
// 8049
o96 = {};
// 8050
f81632121_474.returns.push(o96);
// 8052
f81632121_467.returns.push(1374851216193);
// 8054
o97 = {};
// 8055
f81632121_476.returns.push(o97);
// 8056
// 8057
// 8058
// 8059
// 8060
// 8061
// 8062
o96.appendChild = f81632121_478;
// 8063
f81632121_478.returns.push(o97);
// undefined
o97 = null;
// 8065
f81632121_478.returns.push(o96);
// undefined
o96 = null;
// 8068
f81632121_467.returns.push(1374851216193);
// 8072
o96 = {};
// 8073
f81632121_474.returns.push(o96);
// 8075
f81632121_478.returns.push(o96);
// undefined
o96 = null;
// 8078
f81632121_467.returns.push(1374851216194);
// 8082
o96 = {};
// 8083
f81632121_474.returns.push(o96);
// 8085
f81632121_478.returns.push(o96);
// undefined
o96 = null;
// 8087
f81632121_467.returns.push(1374851216195);
// 8090
f81632121_467.returns.push(1374851216198);
// 8094
o96 = {};
// 8095
f81632121_474.returns.push(o96);
// 8097
f81632121_467.returns.push(1374851216199);
// 8099
o97 = {};
// 8100
f81632121_476.returns.push(o97);
// 8101
// 8102
// 8103
// 8104
// 8105
// 8106
// 8107
o96.appendChild = f81632121_478;
// 8108
f81632121_478.returns.push(o97);
// undefined
o97 = null;
// 8110
f81632121_467.returns.push(1374851216200);
// 8112
o97 = {};
// 8113
f81632121_476.returns.push(o97);
// 8114
// 8115
// 8116
// 8117
// 8118
// 8119
// 8121
f81632121_478.returns.push(o97);
// undefined
o97 = null;
// 8123
f81632121_478.returns.push(o96);
// undefined
o96 = null;
// 8124
o96 = {};
// undefined
o96 = null;
// 8125
// 8126
// undefined
o84 = null;
// 8128
f81632121_467.returns.push(1374851216211);
// 8130
f81632121_467.returns.push(1374851216211);
// 8134
f81632121_12.returns.push(26);
// 8136
f81632121_467.returns.push(1374851216212);
// 8140
f81632121_12.returns.push(27);
// 8142
f81632121_467.returns.push(1374851216212);
// 8144
f81632121_467.returns.push(1374851216212);
// 8146
f81632121_467.returns.push(1374851216212);
// 8150
f81632121_12.returns.push(28);
// 8152
f81632121_467.returns.push(1374851216212);
// 8156
f81632121_12.returns.push(29);
// 8158
f81632121_467.returns.push(1374851216212);
// 8165
o0.title = "Gregor Richards";
// 8167
o1._ua_log = "{\"log\":[{\"ts\":1374851176765,\"path\":\"-\",\"index\":0,\"type\":\"init\",\"iref\":\"-\"},{\"path\":\"/index.php\",\"type\":\"click\",\"ts\":1374851178117,\"iref\":\"bluebar\",\"index\":1},{\"path\":\"/index.php\",\"type\":\"click\",\"ts\":1374851184878,\"iref\":\"bluebar\",\"index\":2},{\"path\":\"/index.php\",\"type\":\"submit\",\"ts\":1374851184905,\"iref\":\"bluebar\",\"index\":3}],\"len\":4}";
// 8170
f81632121_467.returns.push(1374851216237);
// 8172
f81632121_463.returns.push(1);
// 8174
f81632121_463.returns.push(2);
// 8177
f81632121_467.returns.push(1374851216239);
// 8181
f81632121_7.returns.push(undefined);
// 8182
ow81632121.JSBNG__onJSBNG__focus = undefined;
// 8187
f81632121_468.returns.push(undefined);
// 8188
o8.JSBNG__onDOMMouseScroll = void 0;
// 8195
f81632121_468.returns.push(undefined);
// 8196
o8.JSBNG__onmousemove = null;
// 8200
o84 = {};
// 8201
f81632121_0.returns.push(o84);
// undefined
o84 = null;
// 8203
f81632121_467.returns.push(1374851216242);
// 8205
f81632121_482.returns.push("1;1");
// 8207
f81632121_482.returns.push("{\"log\":[{\"ts\":1374851176765,\"path\":\"-\",\"index\":0,\"type\":\"init\",\"iref\":\"-\"},{\"path\":\"/index.php\",\"type\":\"click\",\"ts\":1374851178117,\"iref\":\"bluebar\",\"index\":1},{\"path\":\"/index.php\",\"type\":\"click\",\"ts\":1374851184878,\"iref\":\"bluebar\",\"index\":2},{\"path\":\"/index.php\",\"type\":\"submit\",\"ts\":1374851184905,\"iref\":\"bluebar\",\"index\":3}],\"len\":4}");
// 8209
f81632121_467.returns.push(1374851216243);
// 8211
o84 = {};
// 8212
f81632121_70.returns.push(o84);
// 8213
// 8214
f81632121_1294 = function() { return f81632121_1294.returns[f81632121_1294.inst++]; };
f81632121_1294.returns = [];
f81632121_1294.inst = 0;
// 8215
o84.open = f81632121_1294;
// 8216
f81632121_1294.returns.push(undefined);
// 8217
f81632121_1295 = function() { return f81632121_1295.returns[f81632121_1295.inst++]; };
f81632121_1295.returns = [];
f81632121_1295.inst = 0;
// 8218
o84.setRequestHeader = f81632121_1295;
// 8219
f81632121_1295.returns.push(undefined);
// 8222
f81632121_1295.returns.push(undefined);
// 8223
f81632121_1296 = function() { return f81632121_1296.returns[f81632121_1296.inst++]; };
f81632121_1296.returns = [];
f81632121_1296.inst = 0;
// 8224
o84.send = f81632121_1296;
// 8225
f81632121_1296.returns.push(undefined);
// 8228
o96 = {};
// 8229
f81632121_508.returns.push(o96);
// 8230
o96.nodeName = "FORM";
// 8231
o96.__FB_TOKEN = void 0;
// 8232
// 8233
o96.getAttribute = f81632121_506;
// 8234
o96.hasAttribute = f81632121_507;
// 8236
f81632121_507.returns.push(false);
// 8237
o96.JSBNG__addEventListener = f81632121_468;
// 8239
f81632121_468.returns.push(undefined);
// 8240
f81632121_1298 = function() { return f81632121_1298.returns[f81632121_1298.inst++]; };
f81632121_1298.returns = [];
f81632121_1298.inst = 0;
// 8241
o96.JSBNG__onsubmit = f81632121_1298;
// 8244
// undefined
o96 = null;
// 8248
o96 = {};
// 8249
o97 = {};
// 8251
o96.transport = o84;
// 8252
o84.readyState = 1;
// 8253
o98 = {};
// 8254
o99 = {};
// 8256
o98.nodeType = void 0;
// 8257
o98.length = 1;
// 8258
o98["0"] = "I+n09";
// 8265
f81632121_467.returns.push(1374851216301);
// 8266
f81632121_12.returns.push(30);
// 8267
o100 = {};
// 8268
o101 = {};
// 8270
o100.nodeType = void 0;
// 8271
o100.length = 1;
// 8272
o100["0"] = "4vv8/";
// 8276
o8.clientHeight = 727;
// 8279
o102 = {};
// 8280
o8.classList = o102;
// 8282
o102.remove = f81632121_1114;
// 8283
f81632121_1114.returns.push(undefined);
// 8286
o102.add = f81632121_602;
// 8287
f81632121_602.returns.push(undefined);
// 8291
o103 = {};
// 8292
o104 = {};
// 8294
o103.nodeType = void 0;
// 8295
o103.length = 1;
// 8296
o103["0"] = "BjpNB";
// 8303
o105 = {};
// 8304
f81632121_508.returns.push(o105);
// 8305
o105.getElementsByTagName = f81632121_502;
// 8307
o105.querySelectorAll = f81632121_504;
// 8308
o106 = {};
// 8309
f81632121_504.returns.push(o106);
// 8310
o106.length = 1;
// 8311
o107 = {};
// 8312
o106["0"] = o107;
// undefined
o106 = null;
// 8313
o106 = {};
// 8314
o107.parentNode = o106;
// undefined
o107 = null;
// undefined
o106 = null;
// 8315
f81632121_12.returns.push(31);
// 8320
o16.__FB_TOKEN = void 0;
// 8321
// 8323
o16.hasAttribute = f81632121_507;
// 8325
f81632121_507.returns.push(false);
// 8326
o16.JSBNG__addEventListener = f81632121_468;
// 8328
f81632121_468.returns.push(undefined);
// 8329
o16.JSBNG__onclick = null;
// 8331
o106 = {};
// 8332
o107 = {};
// 8334
o106.nodeType = void 0;
// 8335
o106.length = 1;
// 8336
o106["0"] = "js0se";
// 8338
o108 = {};
// 8341
o108.cancelBubble = false;
// 8344
f81632121_467.returns.push(1374851216392);
// 8347
f81632121_1007.returns.push(undefined);
// 8349
o108.returnValue = true;
// 8352
o109 = {};
// 8353
o108.srcElement = o109;
// 8355
o108.target = o109;
// 8357
o109.nodeType = 1;
// 8358
o110 = {};
// 8359
o109.parentNode = o110;
// 8361
o109.getAttribute = f81632121_506;
// 8363
f81632121_506.returns.push(null);
// 8365
o111 = {};
// 8366
o110.parentNode = o111;
// 8367
o110.nodeType = 1;
// 8368
o110.getAttribute = f81632121_506;
// 8370
f81632121_506.returns.push(null);
// 8372
o112 = {};
// 8373
o111.parentNode = o112;
// 8374
o111.nodeType = 1;
// 8375
o111.getAttribute = f81632121_506;
// 8377
f81632121_506.returns.push(null);
// 8379
o113 = {};
// 8380
o112.parentNode = o113;
// 8381
o112.nodeType = 1;
// 8382
o112.getAttribute = f81632121_506;
// 8384
f81632121_506.returns.push(null);
// 8386
o113.parentNode = o82;
// 8387
o113.nodeType = 1;
// 8388
o113.getAttribute = f81632121_506;
// 8390
f81632121_506.returns.push(null);
// 8396
f81632121_506.returns.push(null);
// 8402
f81632121_506.returns.push(null);
// 8408
f81632121_506.returns.push(null);
// 8413
o108.relatedTarget = null;
// 8414
o108.fromElement = null;
// undefined
o108 = null;
// 8417
o108 = {};
// 8421
f81632121_467.returns.push(1374851216402);
// 8422
o108.cancelBubble = false;
// 8423
o108.returnValue = true;
// 8426
o108.srcElement = o109;
// 8428
o108.target = o109;
// 8435
f81632121_506.returns.push(null);
// 8441
f81632121_506.returns.push(null);
// 8447
f81632121_506.returns.push(null);
// 8453
f81632121_506.returns.push(null);
// 8459
f81632121_506.returns.push(null);
// 8465
f81632121_506.returns.push(null);
// 8471
f81632121_506.returns.push(null);
// 8477
f81632121_506.returns.push(null);
// 8482
o108.JSBNG__screenX = 1047;
// 8483
o108.JSBNG__screenY = 478;
// 8484
o108.altKey = false;
// 8485
o108.bubbles = true;
// 8486
o108.button = 0;
// 8487
o108.buttons = void 0;
// 8488
o108.cancelable = false;
// 8489
o108.clientX = 979;
// 8490
o108.clientY = 313;
// 8491
o108.ctrlKey = false;
// 8492
o108.currentTarget = o0;
// 8493
o108.defaultPrevented = false;
// 8494
o108.detail = 0;
// 8495
o108.eventPhase = 3;
// 8496
o108.isTrusted = void 0;
// 8497
o108.metaKey = false;
// 8498
o108.pageX = 979;
// 8499
o108.pageY = 472;
// 8500
o108.relatedTarget = null;
// 8501
o108.fromElement = null;
// 8504
o108.shiftKey = false;
// 8507
o108.timeStamp = 1374851216401;
// 8508
o108.type = "mousemove";
// 8509
o108.view = ow81632121;
// undefined
o108 = null;
// 8515
f81632121_467.returns.push(1374851216462);
// 8517
f81632121_467.returns.push(1374851216462);
// 8519
f81632121_467.returns.push(1374851216462);
// 8521
f81632121_467.returns.push(1374851216462);
// 8522
o108 = {};
// 8526
f81632121_467.returns.push(1374851216547);
// 8527
o108.cancelBubble = false;
// 8528
o108.returnValue = true;
// 8531
o108.srcElement = o109;
// 8533
o108.target = o109;
// 8540
f81632121_506.returns.push(null);
// 8546
f81632121_506.returns.push(null);
// 8552
f81632121_506.returns.push(null);
// 8558
f81632121_506.returns.push(null);
// 8564
f81632121_506.returns.push(null);
// 8570
f81632121_506.returns.push(null);
// 8576
f81632121_506.returns.push(null);
// 8582
f81632121_506.returns.push(null);
// 8587
o108.JSBNG__screenX = 1048;
// 8588
o108.JSBNG__screenY = 478;
// 8589
o108.altKey = false;
// 8590
o108.bubbles = true;
// 8591
o108.button = 0;
// 8592
o108.buttons = void 0;
// 8593
o108.cancelable = false;
// 8594
o108.clientX = 980;
// 8595
o108.clientY = 313;
// 8596
o108.ctrlKey = false;
// 8597
o108.currentTarget = o0;
// 8598
o108.defaultPrevented = false;
// 8599
o108.detail = 0;
// 8600
o108.eventPhase = 3;
// 8601
o108.isTrusted = void 0;
// 8602
o108.metaKey = false;
// 8603
o108.pageX = 980;
// 8604
o108.pageY = 472;
// 8605
o108.relatedTarget = null;
// 8606
o108.fromElement = null;
// 8609
o108.shiftKey = false;
// 8612
o108.timeStamp = 1374851216547;
// 8613
o108.type = "mousemove";
// 8614
o108.view = ow81632121;
// undefined
o108 = null;
// 8619
o108 = {};
// 8623
f81632121_467.returns.push(1374851217846);
// 8625
o108.cancelBubble = false;
// 8626
o108.returnValue = true;
// 8629
o108.srcElement = o109;
// 8631
o108.target = o109;
// 8638
f81632121_506.returns.push(null);
// 8644
f81632121_506.returns.push(null);
// 8650
f81632121_506.returns.push(null);
// 8656
f81632121_506.returns.push(null);
// 8662
f81632121_506.returns.push(null);
// 8668
f81632121_506.returns.push(null);
// 8674
f81632121_506.returns.push(null);
// 8680
f81632121_506.returns.push(null);
// 8685
o108.JSBNG__screenX = 941;
// 8686
o108.JSBNG__screenY = 502;
// 8687
o108.altKey = false;
// 8688
o108.bubbles = true;
// 8689
o108.button = 0;
// 8690
o108.buttons = void 0;
// 8691
o108.cancelable = false;
// 8692
o108.clientX = 873;
// 8693
o108.clientY = 337;
// 8694
o108.ctrlKey = false;
// 8695
o108.currentTarget = o0;
// 8696
o108.defaultPrevented = false;
// 8697
o108.detail = 0;
// 8698
o108.eventPhase = 3;
// 8699
o108.isTrusted = void 0;
// 8700
o108.metaKey = false;
// 8701
o108.pageX = 873;
// 8702
o108.pageY = 496;
// 8703
o108.relatedTarget = null;
// 8704
o108.fromElement = null;
// 8707
o108.shiftKey = false;
// 8710
o108.timeStamp = 1374851217846;
// 8711
o108.type = "mousemove";
// 8712
o108.view = ow81632121;
// undefined
o108 = null;
// 8717
o108 = {};
// 8721
f81632121_467.returns.push(1374851221800);
// 8723
o108.cancelBubble = false;
// 8724
o108.returnValue = true;
// 8727
o108.srcElement = o109;
// 8729
o108.target = o109;
// 8736
f81632121_506.returns.push(null);
// 8742
f81632121_506.returns.push(null);
// 8748
f81632121_506.returns.push(null);
// 8754
f81632121_506.returns.push(null);
// 8760
f81632121_506.returns.push(null);
// 8766
f81632121_506.returns.push(null);
// 8772
f81632121_506.returns.push(null);
// 8778
f81632121_506.returns.push(null);
// 8783
o108.JSBNG__screenX = 942;
// 8784
o108.JSBNG__screenY = 502;
// 8785
o108.altKey = false;
// 8786
o108.bubbles = true;
// 8787
o108.button = 0;
// 8788
o108.buttons = void 0;
// 8789
o108.cancelable = false;
// 8790
o108.clientX = 874;
// 8791
o108.clientY = 337;
// 8792
o108.ctrlKey = false;
// 8793
o108.currentTarget = o0;
// 8794
o108.defaultPrevented = false;
// 8795
o108.detail = 0;
// 8796
o108.eventPhase = 3;
// 8797
o108.isTrusted = void 0;
// 8798
o108.metaKey = false;
// 8799
o108.pageX = 874;
// 8800
o108.pageY = 496;
// 8801
o108.relatedTarget = null;
// 8802
o108.fromElement = null;
// 8805
o108.shiftKey = false;
// 8808
o108.timeStamp = 1374851217855;
// 8809
o108.type = "mousemove";
// 8810
o108.view = ow81632121;
// undefined
o108 = null;
// 8815
o108 = {};
// 8818
o108.cancelBubble = false;
// 8821
f81632121_467.returns.push(1374851221808);
// 8823
o108.returnValue = true;
// undefined
o108 = null;
// 8824
o108 = {};
// 8827
o108.cancelBubble = false;
// 8830
f81632121_467.returns.push(1374851221823);
// 8832
o108.returnValue = true;
// undefined
o108 = null;
// 8833
o108 = {};
// 8837
f81632121_467.returns.push(1374851221825);
// 8838
o108.cancelBubble = false;
// 8839
o108.returnValue = true;
// 8842
o108.srcElement = o109;
// 8844
o108.target = o109;
// 8851
f81632121_506.returns.push(null);
// 8857
f81632121_506.returns.push(null);
// 8863
f81632121_506.returns.push(null);
// 8869
f81632121_506.returns.push(null);
// 8875
f81632121_506.returns.push(null);
// 8881
f81632121_506.returns.push(null);
// 8887
f81632121_506.returns.push(null);
// 8893
f81632121_506.returns.push(null);
// 8898
o108.JSBNG__screenX = 970;
// 8899
o108.JSBNG__screenY = 511;
// 8900
o108.altKey = false;
// 8901
o108.bubbles = true;
// 8902
o108.button = 0;
// 8903
o108.buttons = void 0;
// 8904
o108.cancelable = false;
// 8905
o108.clientX = 902;
// 8906
o108.clientY = 346;
// 8907
o108.ctrlKey = false;
// 8908
o108.currentTarget = o0;
// 8909
o108.defaultPrevented = false;
// 8910
o108.detail = 0;
// 8911
o108.eventPhase = 3;
// 8912
o108.isTrusted = void 0;
// 8913
o108.metaKey = false;
// 8914
o108.pageX = 902;
// 8915
o108.pageY = 346;
// 8916
o108.relatedTarget = null;
// 8917
o108.fromElement = null;
// 8920
o108.shiftKey = false;
// 8923
o108.timeStamp = 1374851221824;
// 8924
o108.type = "mousemove";
// 8925
o108.view = ow81632121;
// undefined
o108 = null;
// 8934
ow81632121.JSBNG__random = undefined;
// 8935
f81632121_466.returns.push(0.8472101090010256);
// 8936
o5.pathname = "/LawlabeeTheWallaby";
// 8938
f81632121_467.returns.push(1374851225480);
// 8942
f81632121_12.returns.push(32);
// 8943
o108 = {};
// 8944
o114 = {};
// 8946
o108.nodeType = void 0;
// 8947
o108.length = 1;
// 8948
o108["0"] = "zBhY6";
// 8950
o115 = {};
// 8954
o116 = {};
// 8958
o117 = {};
// 8963
f81632121_1332 = function() { return f81632121_1332.returns[f81632121_1332.inst++]; };
f81632121_1332.returns = [];
f81632121_1332.inst = 0;
// 8964
o84.getResponseHeader = f81632121_1332;
// 8967
f81632121_1332.returns.push("3xmoz3iESIuknM/7/9Ym+VHcCy1tul8y/Lv/ebbexTQ=");
// 8970
f81632121_1332.returns.push("3xmoz3iESIuknM/7/9Ym+VHcCy1tul8y/Lv/ebbexTQ=");
// 8971
// 8973
o84.JSBNG__status = 200;
// 8977
f81632121_467.returns.push(1374851225491);
// 8978
f81632121_1333 = function() { return f81632121_1333.returns[f81632121_1333.inst++]; };
f81632121_1333.returns = [];
f81632121_1333.inst = 0;
// 8979
o96._handleXHRResponse = f81632121_1333;
// 8981
f81632121_1334 = function() { return f81632121_1334.returns[f81632121_1334.inst++]; };
f81632121_1334.returns = [];
f81632121_1334.inst = 0;
// 8982
o96.getOption = f81632121_1334;
// 8983
o118 = {};
// 8984
o96.option = o118;
// 8985
o118.suppressEvaluation = false;
// 8988
f81632121_1334.returns.push(false);
// 8989
o84.responseText = "for (;;);{\"__ar\":1,\"payload\":{\"keys\":[]},\"bootloadable\":{},\"ixData\":[]}";
// 8990
f81632121_1336 = function() { return f81632121_1336.returns[f81632121_1336.inst++]; };
f81632121_1336.returns = [];
f81632121_1336.inst = 0;
// 8991
o96._unshieldResponseText = f81632121_1336;
// 8992
f81632121_1336.returns.push("{\"__ar\":1,\"payload\":{\"keys\":[]},\"bootloadable\":{},\"ixData\":[]}");
// 8993
f81632121_1337 = function() { return f81632121_1337.returns[f81632121_1337.inst++]; };
f81632121_1337.returns = [];
f81632121_1337.inst = 0;
// 8994
o96._interpretResponse = f81632121_1337;
// 8995
f81632121_1337.returns.push({__JSBNG_unknown_object:true});
// 8996
f81632121_1338 = function() { return f81632121_1338.returns[f81632121_1338.inst++]; };
f81632121_1338.returns = [];
f81632121_1338.inst = 0;
// 8997
o96.invokeResponseHandler = f81632121_1338;
// 8998
f81632121_1339 = function() { return f81632121_1339.returns[f81632121_1339.inst++]; };
f81632121_1339.returns = [];
f81632121_1339.inst = 0;
// 8999
o96.handler = f81632121_1339;
// 9000
f81632121_1340 = function() { return f81632121_1340.returns[f81632121_1340.inst++]; };
f81632121_1340.returns = [];
f81632121_1340.inst = 0;
// 9001
o96._isRelevant = f81632121_1340;
// 9002
o96._allowCrossPageTransition = void 0;
// 9003
o96.id = 3;
// 9005
f81632121_1340.returns.push(true);
// 9006
f81632121_1341 = function() { return f81632121_1341.returns[f81632121_1341.inst++]; };
f81632121_1341.returns = [];
f81632121_1341.inst = 0;
// 9007
o96._dispatchResponse = f81632121_1341;
// 9008
f81632121_1342 = function() { return f81632121_1342.returns[f81632121_1342.inst++]; };
f81632121_1342.returns = [];
f81632121_1342.inst = 0;
// 9009
o96.getURI = f81632121_1342;
// 9010
o119 = {};
// 9011
o96.uri = o119;
// 9012
f81632121_1344 = function() { return f81632121_1344.returns[f81632121_1344.inst++]; };
f81632121_1344.returns = [];
f81632121_1344.inst = 0;
// 9014
o119.$URIBase0 = "";
// 9015
o119.$URIBase1 = "";
// 9016
o119.$URIBase2 = "";
// 9017
o119.$URIBase3 = "/ajax/webstorage/process_keys.php";
// 9019
o120 = {};
// 9020
o119.$URIBase5 = o120;
// undefined
o120 = null;
// 9021
o119.$URIBase4 = "";
// 9022
f81632121_1344.returns.push("/ajax/webstorage/process_keys.php");
// 9023
f81632121_1342.returns.push("/ajax/webstorage/process_keys.php");
// 9024
o96.preBootloadHandler = void 0;
// 9035
f81632121_1344.returns.push("/ajax/webstorage/process_keys.php");
// 9036
f81632121_1342.returns.push("/ajax/webstorage/process_keys.php");
// 9038
f81632121_12.returns.push(33);
// 9042
o120 = {};
// 9043
f81632121_474.returns.push(o120);
// 9045
f81632121_478.returns.push(o120);
// undefined
o120 = null;
// 9046
f81632121_1338.returns.push(undefined);
// 9047
f81632121_1333.returns.push(undefined);
// 9050
o118.asynchronous = true;
// undefined
o118 = null;
// 9053
f81632121_1334.returns.push(true);
// 9054
// 9056
f81632121_1347 = function() { return f81632121_1347.returns[f81632121_1347.inst++]; };
f81632121_1347.returns = [];
f81632121_1347.inst = 0;
// 9057
o96.clearStatusIndicator = f81632121_1347;
// 9058
f81632121_1348 = function() { return f81632121_1348.returns[f81632121_1348.inst++]; };
f81632121_1348.returns = [];
f81632121_1348.inst = 0;
// 9059
o96.getStatusElement = f81632121_1348;
// 9060
o96.statusElement = null;
// 9061
f81632121_1348.returns.push(null);
// 9062
f81632121_1347.returns.push(undefined);
// 9067
f81632121_1340.returns.push(true);
// 9068
f81632121_1349 = function() { return f81632121_1349.returns[f81632121_1349.inst++]; };
f81632121_1349.returns = [];
f81632121_1349.inst = 0;
// 9069
o96.initialHandler = f81632121_1349;
// 9070
f81632121_1349.returns.push(undefined);
// 9071
o96.timer = null;
// 9072
f81632121_14.returns.push(undefined);
// 9074
f81632121_1350 = function() { return f81632121_1350.returns[f81632121_1350.inst++]; };
f81632121_1350.returns = [];
f81632121_1350.inst = 0;
// 9075
o96._shouldSuppressJS = f81632121_1350;
// 9077
f81632121_1339.returns.push(undefined);
// 9078
f81632121_1350.returns.push(false);
// 9079
f81632121_1351 = function() { return f81632121_1351.returns[f81632121_1351.inst++]; };
f81632121_1351.returns = [];
f81632121_1351.inst = 0;
// 9080
o96._handleJSResponse = f81632121_1351;
// 9081
f81632121_1352 = function() { return f81632121_1352.returns[f81632121_1352.inst++]; };
f81632121_1352.returns = [];
f81632121_1352.inst = 0;
// 9082
o96.getRelativeTo = f81632121_1352;
// 9083
o96.relativeTo = null;
// 9084
f81632121_1352.returns.push(null);
// 9085
f81632121_1353 = function() { return f81632121_1353.returns[f81632121_1353.inst++]; };
f81632121_1353.returns = [];
f81632121_1353.inst = 0;
// 9086
o96._handleJSRegisters = f81632121_1353;
// 9087
f81632121_1353.returns.push(undefined);
// 9088
o96.lid = void 0;
// 9090
f81632121_1353.returns.push(undefined);
// 9091
f81632121_1351.returns.push(undefined);
// 9092
o96.finallyHandler = f81632121_1349;
// 9093
f81632121_1349.returns.push(undefined);
// 9094
f81632121_1341.returns.push(undefined);
// 9101
o118 = {};
// 9102
f81632121_508.returns.push(o118);
// 9103
o118.nodeName = "A";
// 9104
o118.__FB_TOKEN = void 0;
// 9105
// 9106
o118.getAttribute = f81632121_506;
// 9107
o118.hasAttribute = f81632121_507;
// 9109
f81632121_507.returns.push(false);
// 9110
o118.JSBNG__addEventListener = f81632121_468;
// 9112
f81632121_468.returns.push(undefined);
// 9113
f81632121_1355 = function() { return f81632121_1355.returns[f81632121_1355.inst++]; };
f81632121_1355.returns = [];
f81632121_1355.inst = 0;
// 9114
o118.JSBNG__onclick = f81632121_1355;
// 9117
// 9120
o120 = {};
// 9121
o121 = {};
// 9123
o120.nodeType = void 0;
// 9124
o120.length = 1;
// 9125
o120["0"] = "OSd/n";
// 9133
o122 = {};
// 9134
f81632121_508.returns.push(o122);
// 9135
o122.getElementsByTagName = f81632121_502;
// 9137
o122.querySelectorAll = f81632121_504;
// 9138
o123 = {};
// 9139
f81632121_504.returns.push(o123);
// 9140
o123.length = 1;
// 9141
o124 = {};
// 9142
o123["0"] = o124;
// undefined
o123 = null;
// 9145
o124.__FB_TOKEN = void 0;
// 9146
// 9149
o123 = {};
// 9150
f81632121_508.returns.push(o123);
// 9151
o123.getElementsByTagName = f81632121_502;
// 9153
o123.querySelectorAll = f81632121_504;
// undefined
o123 = null;
// 9154
o123 = {};
// 9155
f81632121_504.returns.push(o123);
// 9156
o123.length = 1;
// 9157
o125 = {};
// 9158
o123["0"] = o125;
// undefined
o123 = null;
// 9159
o125.__FB_TOKEN = void 0;
// 9160
// 9163
o123 = {};
// 9164
f81632121_508.returns.push(o123);
// 9165
o123.getElementsByTagName = f81632121_502;
// 9167
o123.querySelectorAll = f81632121_504;
// 9168
o126 = {};
// 9169
f81632121_504.returns.push(o126);
// 9170
o126.length = 1;
// 9171
o127 = {};
// 9172
o126["0"] = o127;
// undefined
o126 = null;
// 9173
o127.__FB_TOKEN = void 0;
// 9174
// 9177
o126 = {};
// 9178
f81632121_476.returns.push(o126);
// 9179
// 9180
// 9181
o126.getElementsByTagName = f81632121_502;
// 9182
o128 = {};
// 9183
f81632121_502.returns.push(o128);
// 9184
o128.length = 0;
// undefined
o128 = null;
// 9186
o128 = {};
// 9187
o126.childNodes = o128;
// undefined
o126 = null;
// 9188
o128.nodeType = void 0;
// undefined
o128 = null;
// 9190
o126 = {};
// 9191
f81632121_476.returns.push(o126);
// 9192
// 9193
// 9194
o126.getElementsByTagName = f81632121_502;
// 9195
o128 = {};
// 9196
f81632121_502.returns.push(o128);
// 9197
o128.length = 0;
// undefined
o128 = null;
// 9199
o128 = {};
// 9200
o126.childNodes = o128;
// undefined
o126 = null;
// 9201
o128.nodeType = void 0;
// undefined
o128 = null;
// 9203
o126 = {};
// 9204
f81632121_476.returns.push(o126);
// 9205
// 9206
// 9207
o126.getElementsByTagName = f81632121_502;
// 9208
o128 = {};
// 9209
f81632121_502.returns.push(o128);
// 9210
o128.length = 0;
// undefined
o128 = null;
// 9212
o128 = {};
// 9213
o126.childNodes = o128;
// undefined
o126 = null;
// 9214
o128.nodeType = void 0;
// undefined
o128 = null;
// 9216
o126 = {};
// 9217
f81632121_476.returns.push(o126);
// 9218
// 9219
// 9220
o126.getElementsByTagName = f81632121_502;
// 9221
o128 = {};
// 9222
f81632121_502.returns.push(o128);
// 9223
o128.length = 0;
// undefined
o128 = null;
// 9225
o128 = {};
// 9226
o126.childNodes = o128;
// undefined
o126 = null;
// 9227
o128.nodeType = void 0;
// undefined
o128 = null;
// 9229
o126 = {};
// 9230
f81632121_476.returns.push(o126);
// 9231
// 9232
// 9233
o126.getElementsByTagName = f81632121_502;
// 9234
o128 = {};
// 9235
f81632121_502.returns.push(o128);
// 9236
o128.length = 0;
// undefined
o128 = null;
// 9238
o128 = {};
// 9239
o126.childNodes = o128;
// undefined
o126 = null;
// 9240
o128.nodeType = void 0;
// undefined
o128 = null;
// 9242
o126 = {};
// 9243
f81632121_476.returns.push(o126);
// 9244
// 9245
// 9246
o126.getElementsByTagName = f81632121_502;
// 9247
o128 = {};
// 9248
f81632121_502.returns.push(o128);
// 9249
o128.length = 0;
// undefined
o128 = null;
// 9251
o128 = {};
// 9252
o126.childNodes = o128;
// undefined
o126 = null;
// 9253
o128.nodeType = void 0;
// undefined
o128 = null;
// 9258
o126 = {};
// 9259
f81632121_508.returns.push(o126);
// undefined
o126 = null;
// 9262
o126 = {};
// 9263
f81632121_508.returns.push(o126);
// undefined
o126 = null;
// 9265
o126 = {};
// 9266
o16.classList = o126;
// 9268
o126.contains = f81632121_513;
// undefined
o126 = null;
// 9269
f81632121_513.returns.push(false);
// 9272
o126 = {};
// 9273
f81632121_508.returns.push(o126);
// 9275
o128 = {};
// 9276
f81632121_508.returns.push(o128);
// 9277
o126.__FB_TOKEN = void 0;
// 9278
// 9281
o129 = {};
// 9282
f81632121_508.returns.push(o129);
// undefined
o129 = null;
// 9284
o129 = {};
// 9285
f81632121_508.returns.push(o129);
// 9287
o130 = {};
// 9288
f81632121_508.returns.push(o130);
// undefined
o130 = null;
// 9290
o130 = {};
// 9291
f81632121_508.returns.push(o130);
// 9293
o131 = {};
// 9294
f81632121_508.returns.push(o131);
// 9295
o129.getElementsByTagName = f81632121_502;
// 9297
o129.querySelectorAll = f81632121_504;
// 9298
o132 = {};
// 9299
f81632121_504.returns.push(o132);
// 9300
o132.length = 1;
// 9301
o133 = {};
// 9302
o132["0"] = o133;
// undefined
o132 = null;
// 9304
o132 = {};
// 9305
f81632121_476.returns.push(o132);
// undefined
o132 = null;
// 9306
o133.nodeName = "INPUT";
// 9307
o133.__FB_TOKEN = void 0;
// 9308
// 9309
o133.getAttribute = f81632121_506;
// 9310
o133.hasAttribute = f81632121_507;
// 9312
f81632121_507.returns.push(false);
// 9313
o133.JSBNG__addEventListener = f81632121_468;
// 9315
f81632121_468.returns.push(undefined);
// 9316
o133.JSBNG__onkeyup = null;
// 9318
o130.nodeName = "A";
// 9319
o130.__FB_TOKEN = void 0;
// 9320
// 9321
o130.getAttribute = f81632121_506;
// 9322
o130.hasAttribute = f81632121_507;
// 9324
f81632121_507.returns.push(false);
// 9325
o130.JSBNG__addEventListener = f81632121_468;
// 9327
f81632121_468.returns.push(undefined);
// 9328
o130.JSBNG__onclick = null;
// undefined
o130 = null;
// 9330
o133.tabIndex = 0;
// 9331
// 9332
f81632121_1398 = function() { return f81632121_1398.returns[f81632121_1398.inst++]; };
f81632121_1398.returns = [];
f81632121_1398.inst = 0;
// 9333
o133.JSBNG__focus = f81632121_1398;
// undefined
o133 = null;
// 9334
f81632121_1398.returns.push(undefined);
// 9335
o130 = {};
// 9336
o129.classList = o130;
// 9338
o130.contains = f81632121_513;
// undefined
o130 = null;
// 9339
f81632121_513.returns.push(false);
// 9340
o130 = {};
// 9341
o129.parentNode = o130;
// undefined
o129 = null;
// 9342
o129 = {};
// 9343
o130.classList = o129;
// 9345
o129.contains = f81632121_513;
// undefined
o129 = null;
// 9346
f81632121_513.returns.push(false);
// 9347
o129 = {};
// 9348
o130.parentNode = o129;
// undefined
o130 = null;
// 9349
o130 = {};
// 9350
o129.classList = o130;
// 9352
o130.contains = f81632121_513;
// undefined
o130 = null;
// 9353
f81632121_513.returns.push(false);
// 9354
o129.parentNode = o126;
// undefined
o129 = null;
// 9355
o129 = {};
// 9356
o126.classList = o129;
// 9358
o129.contains = f81632121_513;
// undefined
o129 = null;
// 9359
f81632121_513.returns.push(false);
// 9360
o126.parentNode = o128;
// undefined
o126 = null;
// 9361
o126 = {};
// 9362
o128.classList = o126;
// 9364
o126.contains = f81632121_513;
// undefined
o126 = null;
// 9365
f81632121_513.returns.push(true);
// 9366
o131.nodeName = "A";
// 9367
o131.__FB_TOKEN = void 0;
// 9368
// 9369
o131.getAttribute = f81632121_506;
// 9370
o131.hasAttribute = f81632121_507;
// 9372
f81632121_507.returns.push(false);
// 9373
o131.JSBNG__addEventListener = f81632121_468;
// 9375
f81632121_468.returns.push(undefined);
// 9376
o131.JSBNG__onclick = null;
// undefined
o131 = null;
// 9378
o128.getElementsByTagName = f81632121_502;
// 9380
o128.querySelectorAll = f81632121_504;
// undefined
o128 = null;
// 9381
o126 = {};
// 9382
f81632121_504.returns.push(o126);
// 9383
o126.length = 1;
// 9384
o128 = {};
// 9385
o126["0"] = o128;
// undefined
o126 = null;
// 9386
o128.nodeName = "A";
// 9387
o128.__FB_TOKEN = void 0;
// 9388
// 9389
o128.getAttribute = f81632121_506;
// 9390
o128.hasAttribute = f81632121_507;
// 9392
f81632121_507.returns.push(false);
// 9393
o128.JSBNG__addEventListener = f81632121_468;
// 9395
f81632121_468.returns.push(undefined);
// 9396
o128.JSBNG__onclick = null;
// undefined
o128 = null;
// 9400
o126 = {};
// 9401
f81632121_508.returns.push(o126);
// undefined
o126 = null;
// 9402
o126 = {};
// 9403
o128 = {};
// 9405
o126.nodeType = void 0;
// 9406
o126.length = 1;
// 9407
o126["0"] = "+P3v8";
// 9411
f81632121_467.returns.push(1374851226185);
// 9413
f81632121_467.returns.push(1374851226187);
// 9415
f81632121_467.returns.push(1374851226187);
// 9416
f81632121_14.returns.push(undefined);
// 9417
f81632121_12.returns.push(34);
// 9418
f81632121_14.returns.push(undefined);
// 9422
o129 = {};
// 9423
o130 = {};
// 9425
o129.nodeType = void 0;
// 9426
o129.length = 1;
// 9427
o129["0"] = "mBpeN";
// 9433
f81632121_13.returns.push(35);
// 9434
o3.onLine = true;
// 9436
f81632121_467.returns.push(1374851226278);
// 9437
f81632121_1413 = function() { return f81632121_1413.returns[f81632121_1413.inst++]; };
f81632121_1413.returns = [];
f81632121_1413.inst = 0;
// 9438
f81632121_1349.thatReturnsThis = f81632121_1413;
// 9442
o131 = {};
// 9443
o132 = {};
// 9445
o131.nodeType = void 0;
// 9446
o131.length = 1;
// 9447
o131["0"] = "C6rJk";
// 9449
o133 = {};
// 9453
f81632121_467.returns.push(1374851226295);
// 9455
f81632121_12.returns.push(36);
// 9456
o133.cancelBubble = false;
// 9457
o133.returnValue = true;
// 9460
o133.srcElement = o109;
// 9462
o133.target = o109;
// 9469
f81632121_506.returns.push(null);
// 9475
f81632121_506.returns.push(null);
// 9481
f81632121_506.returns.push(null);
// 9487
f81632121_506.returns.push(null);
// 9493
f81632121_506.returns.push(null);
// 9499
f81632121_506.returns.push(null);
// 9505
f81632121_506.returns.push(null);
// 9511
f81632121_506.returns.push(null);
// 9516
o133.JSBNG__screenX = 970;
// 9517
o133.JSBNG__screenY = 511;
// 9518
o133.altKey = false;
// 9519
o133.bubbles = true;
// 9520
o133.button = 0;
// 9521
o133.buttons = void 0;
// 9522
o133.cancelable = false;
// 9523
o133.clientX = 902;
// 9524
o133.clientY = 346;
// 9525
o133.ctrlKey = false;
// 9526
o133.currentTarget = o0;
// 9527
o133.defaultPrevented = false;
// 9528
o133.detail = 0;
// 9529
o133.eventPhase = 3;
// 9530
o133.isTrusted = void 0;
// 9531
o133.metaKey = false;
// 9532
o133.pageX = 902;
// 9533
o133.pageY = 346;
// 9534
o133.relatedTarget = null;
// 9535
o133.fromElement = null;
// 9538
o133.shiftKey = false;
// 9541
o133.timeStamp = 1374851226294;
// 9542
o133.type = "mousemove";
// 9543
o133.view = ow81632121;
// undefined
o133 = null;
// 9546
f81632121_1417 = function() { return f81632121_1417.returns[f81632121_1417.inst++]; };
f81632121_1417.returns = [];
f81632121_1417.inst = 0;
// 9547
f81632121_1349.thatReturnsFalse = f81632121_1417;
// 9555
f81632121_1418 = function() { return f81632121_1418.returns[f81632121_1418.inst++]; };
f81632121_1418.returns = [];
f81632121_1418.inst = 0;
// 9556
f81632121_1349.thatReturns = f81632121_1418;
// 9557
f81632121_1418.returns.push({__JSBNG_unknown_function:true});
// 9558
o133 = {};
// 9559
o134 = {};
// 9561
o133.nodeType = void 0;
// 9562
o133.length = 1;
// 9563
o133["0"] = "97Zhe";
// 9569
o0.selection = void 0;
// 9571
o135 = {};
// 9572
f81632121_476.returns.push(o135);
// undefined
o135 = null;
// 9573
o17.__FB_TOKEN = void 0;
// 9574
// 9578
o135 = {};
// 9579
f81632121_504.returns.push(o135);
// 9580
o135.length = 1;
// 9581
o136 = {};
// 9582
o135["0"] = o136;
// undefined
o135 = null;
// 9586
o135 = {};
// 9587
f81632121_504.returns.push(o135);
// 9588
o135.length = 1;
// 9589
o135["0"] = o19;
// undefined
o135 = null;
// 9593
o135 = {};
// 9594
f81632121_504.returns.push(o135);
// 9595
o135.length = 1;
// 9596
o137 = {};
// 9597
o135["0"] = o137;
// undefined
o135 = null;
// 9601
o135 = {};
// 9602
f81632121_504.returns.push(o135);
// 9603
o135.length = 1;
// 9604
o138 = {};
// 9605
o135["0"] = o138;
// undefined
o135 = null;
// undefined
o138 = null;
// 9606
o136.ownerDocument = o0;
// 9607
o0.defaultView = ow81632121;
// 9609
// 9610
// 9611
// 9612
// 9613
o19.nodeName = "INPUT";
// 9614
o135 = {};
// 9615
o136.classList = o135;
// 9617
o135.contains = f81632121_513;
// 9618
f81632121_513.returns.push(true);
// 9620
o19.selectionStart = 0;
// 9621
o19.selectionEnd = 0;
// undefined
o19 = null;
// 9626
f81632121_513.returns.push(false);
// 9628
o19 = {};
// undefined
fo81632121_1423_firstChild = function() { return fo81632121_1423_firstChild.returns[fo81632121_1423_firstChild.inst++]; };
fo81632121_1423_firstChild.returns = [];
fo81632121_1423_firstChild.inst = 0;
defineGetter(o136, "firstChild", fo81632121_1423_firstChild, undefined);
// undefined
fo81632121_1423_firstChild.returns.push(o19);
// undefined
fo81632121_1423_firstChild.returns.push(o19);
// 9631
o19.parentNode = o136;
// 9633
o136.removeChild = f81632121_521;
// 9634
f81632121_521.returns.push(o19);
// undefined
o19 = null;
// undefined
fo81632121_1423_firstChild.returns.push(null);
// 9637
o19 = {};
// 9638
f81632121_474.returns.push(o19);
// 9640
o138 = {};
// 9641
f81632121_598.returns.push(o138);
// 9642
o19.appendChild = f81632121_478;
// 9643
f81632121_478.returns.push(o138);
// 9644
o136.appendChild = f81632121_478;
// 9645
f81632121_478.returns.push(o19);
// undefined
o19 = null;
// 9648
o18.add = f81632121_602;
// undefined
o18 = null;
// 9649
f81632121_602.returns.push(undefined);
// 9652
o135.remove = f81632121_1114;
// undefined
o135 = null;
// 9653
f81632121_1114.returns.push(undefined);
// 9654
// 9655
// 9657
o17.contains = f81632121_645;
// 9659
f81632121_645.returns.push(false);
// 9660
o18 = {};
// 9661
o137.classList = o18;
// undefined
o137 = null;
// 9663
o18.remove = f81632121_1114;
// undefined
o18 = null;
// 9664
f81632121_1114.returns.push(undefined);
// 9668
f81632121_645.returns.push(false);
// 9669
o136.nodeName = "DIV";
// 9670
o136.__FB_TOKEN = void 0;
// 9671
// 9672
o136.getAttribute = f81632121_506;
// 9673
o136.hasAttribute = f81632121_507;
// 9675
f81632121_507.returns.push(false);
// 9676
o136.JSBNG__addEventListener = f81632121_468;
// 9678
f81632121_468.returns.push(undefined);
// 9679
o136.JSBNG__onkeydown = null;
// 9684
f81632121_468.returns.push(undefined);
// 9685
o136.JSBNG__onkeyup = null;
// 9690
f81632121_468.returns.push(undefined);
// 9691
o136.JSBNG__onkeypress = null;
// 9697
f81632121_468.returns.push(undefined);
// 9698
o136.JSBNG__onmousedown = null;
// 9703
f81632121_468.returns.push(undefined);
// 9704
o136.JSBNG__onmouseup = null;
// 9709
f81632121_468.returns.push(undefined);
// 9710
o136.JSBNG__oncut = null;
// 9715
f81632121_468.returns.push(undefined);
// 9716
o136.JSBNG__onpaste = null;
// 9721
f81632121_468.returns.push(undefined);
// 9722
o136.JSBNG__ondrop = null;
// 9727
f81632121_468.returns.push(undefined);
// 9728
o136.JSBNG__ondragover = null;
// 9733
f81632121_468.returns.push(undefined);
// 9734
o136.JSBNG__onJSBNG__focus = void 0;
// 9739
f81632121_468.returns.push(undefined);
// 9740
o136.JSBNG__onJSBNG__blur = void 0;
// 9742
// 9743
// 9746
o18 = {};
// 9747
f81632121_508.returns.push(o18);
// undefined
o18 = null;
// 9749
o18 = {};
// 9750
f81632121_508.returns.push(o18);
// 9752
o19 = {};
// 9753
f81632121_508.returns.push(o19);
// 9754
o18.nodeName = "BUTTON";
// 9755
o18.__FB_TOKEN = void 0;
// 9756
// 9757
o18.getAttribute = f81632121_506;
// 9758
o18.hasAttribute = f81632121_507;
// 9760
f81632121_507.returns.push(false);
// 9761
o18.JSBNG__addEventListener = f81632121_468;
// 9763
f81632121_468.returns.push(undefined);
// 9764
o18.JSBNG__onclick = null;
// undefined
o18 = null;
// 9766
o19.nodeName = "A";
// 9767
o19.__FB_TOKEN = void 0;
// 9768
// 9769
o19.getAttribute = f81632121_506;
// 9770
o19.hasAttribute = f81632121_507;
// 9772
f81632121_507.returns.push(false);
// 9773
o19.JSBNG__addEventListener = f81632121_468;
// 9775
f81632121_468.returns.push(undefined);
// 9776
o19.JSBNG__onclick = null;
// undefined
o19 = null;
// 9781
o18 = {};
// 9782
f81632121_70.returns.push(o18);
// 9783
// 9784
o18.open = f81632121_1294;
// 9785
f81632121_1294.returns.push(undefined);
// 9786
o18.setRequestHeader = f81632121_1295;
// 9787
f81632121_1295.returns.push(undefined);
// 9789
o18.send = f81632121_1296;
// 9790
f81632121_1296.returns.push(undefined);
// 9792
o19 = {};
// 9793
f81632121_70.returns.push(o19);
// 9794
// 9795
o19.open = f81632121_1294;
// 9796
f81632121_1294.returns.push(undefined);
// 9797
o19.setRequestHeader = f81632121_1295;
// 9798
f81632121_1295.returns.push(undefined);
// 9800
o19.send = f81632121_1296;
// 9801
f81632121_1296.returns.push(undefined);
// 9803
o135 = {};
// 9804
f81632121_508.returns.push(o135);
// 9807
o135.__FB_TOKEN = void 0;
// 9808
// 9812
o137 = {};
// 9813
f81632121_508.returns.push(o137);
// 9815
o16.contains = f81632121_645;
// 9817
f81632121_645.returns.push(true);
// 9818
o139 = {};
// 9819
f81632121_4.returns.push(o139);
// 9820
f81632121_1442 = function() { return f81632121_1442.returns[f81632121_1442.inst++]; };
f81632121_1442.returns = [];
f81632121_1442.inst = 0;
// 9821
o139.getPropertyValue = f81632121_1442;
// undefined
o139 = null;
// 9822
f81632121_1442.returns.push("fixed");
// 9824
o139 = {};
// 9825
f81632121_508.returns.push(o139);
// 9826
o139.offsetHeight = 42;
// 9828
o140 = {};
// 9829
f81632121_508.returns.push(o140);
// 9830
o140.getElementsByTagName = f81632121_502;
// 9832
o140.querySelectorAll = f81632121_504;
// 9833
o141 = {};
// 9834
f81632121_504.returns.push(o141);
// 9835
o141.length = 1;
// 9836
o142 = {};
// 9837
o141["0"] = o142;
// undefined
o141 = null;
// 9841
o141 = {};
// 9842
f81632121_504.returns.push(o141);
// 9843
o141.length = 1;
// 9844
o143 = {};
// 9845
o141["0"] = o143;
// undefined
o141 = null;
// 9849
o141 = {};
// 9850
f81632121_504.returns.push(o141);
// 9851
o141.length = 1;
// 9852
o144 = {};
// 9853
o141["0"] = o144;
// undefined
o141 = null;
// undefined
o144 = null;
// 9857
o141 = {};
// 9858
f81632121_504.returns.push(o141);
// 9859
o141.length = 1;
// 9860
o141["0"] = o69;
// undefined
o141 = null;
// undefined
o69 = null;
// 9863
o22.contains = f81632121_513;
// undefined
o22 = null;
// 9864
f81632121_513.returns.push(true);
// 9866
o22 = {};
// 9867
f81632121_476.returns.push(o22);
// 9868
// 9869
o22.firstChild = null;
// 9870
o143.__html = void 0;
// 9872
o69 = {};
// 9873
f81632121_474.returns.push(o69);
// 9875
o22.appendChild = f81632121_478;
// 9876
f81632121_478.returns.push(o69);
// undefined
o69 = null;
// 9877
o142.nodeName = "DIV";
// 9878
o142.__FB_TOKEN = void 0;
// 9879
// 9880
o142.getAttribute = f81632121_506;
// 9881
o142.hasAttribute = f81632121_507;
// 9883
f81632121_507.returns.push(false);
// 9884
o142.JSBNG__addEventListener = f81632121_468;
// 9886
f81632121_468.returns.push(undefined);
// 9887
o142.JSBNG__onclick = null;
// 9892
f81632121_468.returns.push(undefined);
// 9893
o142.JSBNG__onmouseover = null;
// 9895
// 9896
o135.getElementsByTagName = f81632121_502;
// 9898
o135.querySelectorAll = f81632121_504;
// 9899
o69 = {};
// 9900
f81632121_504.returns.push(o69);
// 9901
o69.length = 1;
// 9902
o69["0"] = o17;
// undefined
o69 = null;
// 9903
o69 = {};
// 9904
o17.classList = o69;
// 9906
o69.contains = f81632121_513;
// undefined
o69 = null;
// 9907
f81632121_513.returns.push(true);
// 9911
o69 = {};
// 9912
f81632121_504.returns.push(o69);
// 9913
o69.length = 1;
// 9914
o69["0"] = o136;
// undefined
o69 = null;
// 9917
f81632121_1457 = function() { return f81632121_1457.returns[f81632121_1457.inst++]; };
f81632121_1457.returns = [];
f81632121_1457.inst = 0;
// 9918
o16.getAttributeNode = f81632121_1457;
// 9920
f81632121_1457.returns.push(null);
// 9923
o69 = {};
// 9924
f81632121_502.returns.push(o69);
// 9925
o69.length = 1952;
// 9926
o69["0"] = o82;
// 9927
o82.getAttributeNode = f81632121_1457;
// 9929
f81632121_1457.returns.push(null);
// 9931
o141 = {};
// 9932
o69["1"] = o141;
// 9933
o141.getAttributeNode = f81632121_1457;
// 9935
o144 = {};
// 9936
f81632121_1457.returns.push(o144);
// 9937
o144.value = "pagelet_bluebar";
// undefined
o144 = null;
// 9939
o69["2"] = o139;
// 9940
o139.getAttributeNode = f81632121_1457;
// 9942
o144 = {};
// 9943
f81632121_1457.returns.push(o144);
// 9944
o144.value = "blueBarHolder";
// undefined
o144 = null;
// 9946
o69["3"] = o137;
// undefined
o69 = null;
// 9947
o137.getAttributeNode = f81632121_1457;
// 9949
o69 = {};
// 9950
f81632121_1457.returns.push(o69);
// 9951
o69.value = "blueBar";
// undefined
o69 = null;
// 9955
f81632121_645.returns.push(true);
// 9956
o137.contains = f81632121_645;
// 9958
f81632121_645.returns.push(true);
// 9960
o69 = {};
// 9961
f81632121_476.returns.push(o69);
// 9962
o140.__html = void 0;
// 9964
o144 = {};
// 9965
f81632121_474.returns.push(o144);
// 9967
o69.appendChild = f81632121_478;
// 9968
f81632121_478.returns.push(o144);
// undefined
o144 = null;
// 9969
o69.__html = void 0;
// 9970
o69.mountComponentIntoNode = void 0;
// undefined
o69 = null;
// 9972
o69 = {};
// 9973
f81632121_476.returns.push(o69);
// 9974
// 9975
o69.firstChild = null;
// 9978
o144 = {};
// 9979
f81632121_474.returns.push(o144);
// 9981
o69.appendChild = f81632121_478;
// 9982
f81632121_478.returns.push(o144);
// undefined
o144 = null;
// 9984
o144 = {};
// 9985
f81632121_476.returns.push(o144);
// 9986
// 9987
o144.firstChild = null;
// 9988
o69.__html = void 0;
// 9990
o145 = {};
// 9991
f81632121_474.returns.push(o145);
// 9993
o144.appendChild = f81632121_478;
// 9994
f81632121_478.returns.push(o145);
// undefined
o145 = null;
// 9995
o145 = {};
// 9996
o144.classList = o145;
// 9998
o145.add = f81632121_602;
// 9999
f81632121_602.returns.push(undefined);
// 10000
o144.__FB_TOKEN = void 0;
// 10001
// 10002
o137.__FB_TOKEN = void 0;
// 10003
// 10004
o137.getAttribute = f81632121_506;
// 10005
o137.hasAttribute = f81632121_507;
// 10007
f81632121_507.returns.push(false);
// 10008
o137.parentNode = o139;
// 10009
o139.__FB_TOKEN = void 0;
// 10010
// 10011
o139.getAttribute = f81632121_506;
// 10012
o139.hasAttribute = f81632121_507;
// 10014
f81632121_507.returns.push(false);
// 10015
o139.parentNode = o141;
// 10016
o141.__FB_TOKEN = void 0;
// 10017
// 10018
o141.getAttribute = f81632121_506;
// 10019
o141.hasAttribute = f81632121_507;
// 10021
f81632121_507.returns.push(false);
// 10022
o141.parentNode = o82;
// 10023
o82.__FB_TOKEN = void 0;
// 10024
// 10026
o82.hasAttribute = f81632121_507;
// 10028
f81632121_507.returns.push(false);
// 10033
f81632121_507.returns.push(false);
// 10038
f81632121_507.returns.push(false);
// 10042
o144.id = "";
// 10043
// 10044
o136.setAttribute = f81632121_575;
// 10045
f81632121_575.returns.push(undefined);
// 10047
f81632121_575.returns.push(undefined);
// 10048
f81632121_12.returns.push(37);
// 10049
o146 = {};
// undefined
fo81632121_1467_style = function() { return fo81632121_1467_style.returns[fo81632121_1467_style.inst++]; };
fo81632121_1467_style.returns = [];
fo81632121_1467_style.inst = 0;
defineGetter(o144, "style", fo81632121_1467_style, undefined);
// undefined
fo81632121_1467_style.returns.push(o146);
// 10051
// undefined
fo81632121_1467_style.returns.push(o146);
// 10053
// 10056
o145.remove = f81632121_1114;
// undefined
o145 = null;
// 10057
f81632121_1114.returns.push(undefined);
// 10058
o145 = {};
// 10059
o137.classList = o145;
// 10061
o145.contains = f81632121_513;
// undefined
o145 = null;
// 10062
f81632121_513.returns.push(false);
// 10064
o145 = {};
// 10065
o139.classList = o145;
// 10067
o145.contains = f81632121_513;
// undefined
o145 = null;
// 10068
f81632121_513.returns.push(false);
// 10070
o145 = {};
// 10071
o141.classList = o145;
// undefined
o141 = null;
// 10073
o145.contains = f81632121_513;
// undefined
o145 = null;
// 10074
f81632121_513.returns.push(false);
// 10076
o141 = {};
// 10077
o82.classList = o141;
// 10079
o141.contains = f81632121_513;
// undefined
o141 = null;
// 10080
f81632121_513.returns.push(false);
// 10085
f81632121_513.returns.push(false);
// 10089
o102.contains = f81632121_513;
// undefined
o102 = null;
// 10090
f81632121_513.returns.push(false);
// 10092
o0.classList = void 0;
// 10093
o0.className = void 0;
// 10096
o144.__html = void 0;
// 10098
o102 = {};
// 10099
f81632121_474.returns.push(o102);
// 10101
o16.appendChild = f81632121_478;
// 10102
f81632121_478.returns.push(o102);
// undefined
o102 = null;
// 10106
f81632121_645.returns.push(true);
// 10107
o102 = {};
// 10108
f81632121_4.returns.push(o102);
// 10109
o102.getPropertyValue = f81632121_1442;
// undefined
o102 = null;
// 10110
f81632121_1442.returns.push("fixed");
// 10114
f81632121_513.returns.push(false);
// 10119
f81632121_513.returns.push(false);
// 10124
f81632121_513.returns.push(false);
// 10129
f81632121_513.returns.push(false);
// 10134
f81632121_513.returns.push(false);
// 10139
f81632121_513.returns.push(false);
// 10146
o102 = {};
// 10147
f81632121_4.returns.push(o102);
// 10148
o102.getPropertyValue = f81632121_1442;
// undefined
o102 = null;
// 10149
f81632121_1442.returns.push("static");
// 10154
f81632121_645.returns.push(false);
// undefined
fo81632121_1467_style.returns.push(o146);
// 10158
// 10159
o102 = {};
// undefined
fo81632121_1465_style = function() { return fo81632121_1465_style.returns[fo81632121_1465_style.inst++]; };
fo81632121_1465_style.returns = [];
fo81632121_1465_style.inst = 0;
defineGetter(o69, "style", fo81632121_1465_style, undefined);
// undefined
fo81632121_1465_style.returns.push(o102);
// 10161
// 10163
o141 = {};
// 10164
f81632121_4.returns.push(o141);
// 10165
o141.getPropertyValue = f81632121_1442;
// undefined
o141 = null;
// 10166
f81632121_1442.returns.push("ltr");
// undefined
fo81632121_1465_style.returns.push(o102);
// 10168
// undefined
o102 = null;
// 10169
o102 = {};
// 10170
o69.classList = o102;
// 10172
o102.add = f81632121_602;
// undefined
o102 = null;
// 10173
f81632121_602.returns.push(undefined);
// 10177
f81632121_602.returns.push(undefined);
// 10183
o8.contains = f81632121_645;
// 10185
f81632121_645.returns.push(true);
// 10186
f81632121_1481 = function() { return f81632121_1481.returns[f81632121_1481.inst++]; };
f81632121_1481.returns = [];
f81632121_1481.inst = 0;
// 10187
o137.getBoundingClientRect = f81632121_1481;
// 10188
o102 = {};
// 10189
f81632121_1481.returns.push(o102);
// 10190
o102.left = 0;
// 10191
o8.clientLeft = 0;
// 10192
o102.JSBNG__top = 0;
// undefined
o102 = null;
// 10193
o8.clientTop = 0;
// 10194
o137.offsetWidth = 1017;
// 10195
o137.offsetHeight = 42;
// undefined
fo81632121_1467_style.returns.push(o146);
// 10197
// undefined
fo81632121_1467_style.returns.push(o146);
// 10199
// undefined
o146 = null;
// 10203
f81632121_513.returns.push(false);
// 10208
f81632121_513.returns.push(false);
// 10213
f81632121_513.returns.push(false);
// 10218
f81632121_513.returns.push(false);
// 10223
f81632121_513.returns.push(false);
// 10228
f81632121_513.returns.push(false);
// 10240
f81632121_645.returns.push(false);
// 10242
o16.scrollLeft = 0;
// 10243
o16.scrollTop = 0;
// 10244
o102 = {};
// undefined
fo81632121_1467_style.returns.push(o102);
// 10246
// undefined
fo81632121_1467_style.returns.push(o102);
// 10248
// 10252
f81632121_513.returns.push(false);
// 10257
f81632121_513.returns.push(false);
// 10262
f81632121_513.returns.push(false);
// 10267
f81632121_513.returns.push(false);
// 10272
f81632121_513.returns.push(false);
// 10277
f81632121_513.returns.push(false);
// 10287
o141 = {};
// 10288
f81632121_4.returns.push(o141);
// 10289
o141.getPropertyValue = f81632121_1442;
// undefined
o141 = null;
// 10290
f81632121_1442.returns.push("static");
// 10291
o141 = {};
// 10292
f81632121_4.returns.push(o141);
// 10293
o141.getPropertyValue = f81632121_1442;
// undefined
o141 = null;
// 10294
f81632121_1442.returns.push("static");
// 10295
o141 = {};
// 10296
f81632121_4.returns.push(o141);
// 10297
o141.getPropertyValue = f81632121_1442;
// undefined
o141 = null;
// 10298
f81632121_1442.returns.push("static");
// 10299
o141 = {};
// 10300
f81632121_4.returns.push(o141);
// 10301
o141.getPropertyValue = f81632121_1442;
// undefined
o141 = null;
// 10302
f81632121_1442.returns.push("fixed");
// 10303
o141 = {};
// 10304
f81632121_4.returns.push(o141);
// 10305
o141.getPropertyValue = f81632121_1442;
// undefined
o141 = null;
// 10306
f81632121_1442.returns.push("300");
// undefined
fo81632121_1467_style.returns.push(o102);
// 10308
// 10310
o69.nodeName = "DIV";
// 10311
o69.__FB_TOKEN = void 0;
// 10312
// 10313
o69.getAttribute = f81632121_506;
// 10314
o69.hasAttribute = f81632121_507;
// 10316
f81632121_507.returns.push(false);
// 10317
o69.JSBNG__addEventListener = f81632121_468;
// 10319
f81632121_468.returns.push(undefined);
// 10320
o69.JSBNG__onmouseover = null;
// 10325
f81632121_468.returns.push(undefined);
// 10326
o69.JSBNG__onmouseout = null;
// undefined
o69 = null;
// 10328
f81632121_12.returns.push(38);
// undefined
fo81632121_1467_style.returns.push(o102);
// 10330
// undefined
fo81632121_1467_style.returns.push(o102);
// 10332
// undefined
o102 = null;
// 10333
o144.setAttribute = f81632121_575;
// undefined
o144 = null;
// 10334
o137.id = "blueBar";
// 10335
f81632121_575.returns.push(undefined);
// 10339
f81632121_602.returns.push(undefined);
// 10344
f81632121_602.returns.push(undefined);
// 10345
o69 = {};
// undefined
fo81632121_1465_style.returns.push(o69);
// 10347
// undefined
o69 = null;
// 10348
o135.nodeName = "DIV";
// 10349
o135.getAttribute = f81632121_506;
// 10350
o135.hasAttribute = f81632121_507;
// 10352
f81632121_507.returns.push(false);
// 10353
o135.JSBNG__addEventListener = f81632121_468;
// 10355
f81632121_468.returns.push(undefined);
// 10356
o135.JSBNG__onkeydown = null;
// 10358
o69 = {};
// 10359
o135.parentNode = o69;
// undefined
o135 = null;
// 10360
o69.nodeName = "DIV";
// 10361
o69.__FB_TOKEN = void 0;
// 10362
// 10363
o69.getAttribute = f81632121_506;
// 10364
o69.hasAttribute = f81632121_507;
// 10366
f81632121_507.returns.push(false);
// 10367
o69.JSBNG__addEventListener = f81632121_468;
// 10369
f81632121_468.returns.push(undefined);
// 10370
o69.JSBNG__onmousedown = null;
// undefined
o69 = null;
// 10372
o140.nodeName = "DIV";
// 10373
o140.__FB_TOKEN = void 0;
// 10374
// 10375
o140.getAttribute = f81632121_506;
// 10376
o140.hasAttribute = f81632121_507;
// 10378
f81632121_507.returns.push(false);
// 10379
o140.JSBNG__addEventListener = f81632121_468;
// 10381
f81632121_468.returns.push(undefined);
// 10382
o140.JSBNG__onmousedown = null;
// undefined
o140 = null;
// 10388
f81632121_468.returns.push(undefined);
// 10389
o16.JSBNG__onmouseup = null;
// 10391
f81632121_7.returns.push(undefined);
// 10392
ow81632121.JSBNG__onJSBNG__blur = undefined;
// 10394
o69 = {};
// 10395
o143.classList = o69;
// undefined
o143 = null;
// 10397
o69.remove = f81632121_1114;
// undefined
o69 = null;
// 10398
f81632121_1114.returns.push(undefined);
// 10399
o69 = {};
// 10400
o22.classList = o69;
// undefined
o22 = null;
// 10402
o69.remove = f81632121_1114;
// undefined
o69 = null;
// 10403
f81632121_1114.returns.push(undefined);
// 10404
f81632121_12.returns.push(39);
// 10406
f81632121_12.returns.push(40);
// 10407
o22 = {};
// 10408
o136.childNodes = o22;
// 10409
o22.nodeType = void 0;
// 10411
o69 = {};
// 10412
f81632121_476.returns.push(o69);
// 10413
o69.firstChild = null;
// 10415
o102 = {};
// 10416
f81632121_474.returns.push(o102);
// 10418
o135 = {};
// 10419
f81632121_598.returns.push(o135);
// 10420
o102.appendChild = f81632121_478;
// 10421
f81632121_478.returns.push(o135);
// undefined
o135 = null;
// 10422
o69.appendChild = f81632121_478;
// 10423
f81632121_478.returns.push(o102);
// undefined
o102 = null;
// 10424
o102 = {};
// 10425
o69.classList = o102;
// 10427
o102.add = f81632121_602;
// undefined
o102 = null;
// 10428
f81632121_602.returns.push(undefined);
// 10432
f81632121_602.returns.push(undefined);
// 10433
o69.setAttribute = f81632121_575;
// 10434
f81632121_575.returns.push(undefined);
// 10436
f81632121_575.returns.push(undefined);
// 10438
f81632121_575.returns.push(undefined);
// 10440
f81632121_575.returns.push(undefined);
// 10442
f81632121_575.returns.push(undefined);
// 10444
f81632121_575.returns.push(undefined);
// 10446
f81632121_575.returns.push(undefined);
// 10448
f81632121_575.returns.push(undefined);
// 10450
o102 = {};
// 10451
f81632121_476.returns.push(o102);
// 10452
o102.setAttribute = f81632121_575;
// 10454
f81632121_575.returns.push(undefined);
// 10455
o102.firstChild = null;
// 10457
o135 = {};
// 10458
f81632121_474.returns.push(o135);
// 10460
o140 = {};
// 10461
f81632121_598.returns.push(o140);
// 10462
o135.appendChild = f81632121_478;
// 10463
f81632121_478.returns.push(o140);
// undefined
o140 = null;
// 10464
o102.appendChild = f81632121_478;
// 10465
f81632121_478.returns.push(o135);
// undefined
o135 = null;
// undefined
fo81632121_1423_firstChild.returns.push(o138);
// undefined
fo81632121_1423_firstChild.returns.push(o138);
// 10468
o138.parentNode = o136;
// 10471
f81632121_521.returns.push(o138);
// undefined
o138 = null;
// undefined
fo81632121_1423_firstChild.returns.push(null);
// 10474
o135 = {};
// 10475
f81632121_474.returns.push(o135);
// 10476
o69.__html = void 0;
// undefined
o69 = null;
// 10477
o102.__html = void 0;
// undefined
o102 = null;
// 10479
f81632121_478.returns.push(o135);
// undefined
o135 = null;
// undefined
fo81632121_1423_firstChild.returns.push(null);
// 10481
o136.lastChild = null;
// 10482
o136.getElementsByTagName = f81632121_502;
// 10483
o69 = {};
// 10484
f81632121_502.returns.push(o69);
// 10485
o69.nodeType = void 0;
// 10487
o102 = {};
// 10488
f81632121_502.returns.push(o102);
// 10489
o102.nodeType = void 0;
// 10490
o69.parentNode = void 0;
// undefined
o69 = null;
// 10491
o102.parentNode = void 0;
// undefined
o102 = null;
// undefined
fo81632121_1423_firstChild.returns.push(null);
// 10495
o22.nodeName = void 0;
// 10497
o22.nextSibling = void 0;
// 10498
o22.parentNode = void 0;
// undefined
fo81632121_1423_firstChild.returns.push(null);
// 10503
f81632121_1114.returns.push(undefined);
// 10507
f81632121_645.returns.push(false);
// 10514
f81632121_645.returns.push(false);
// 10515
o69 = {};
// 10516
f81632121_4.returns.push(o69);
// 10517
o69.getPropertyValue = f81632121_1442;
// undefined
o69 = null;
// 10518
f81632121_1442.returns.push("14px");
// 10519
o17.offsetWidth = 550;
// 10520
o17.offsetHeight = 23;
// 10524
o69 = {};
// 10525
f81632121_504.returns.push(o69);
// 10526
o69.length = 1;
// 10527
o69["0"] = o136;
// undefined
o69 = null;
// undefined
o136 = null;
// 10530
o22.offsetWidth = void 0;
// 10531
o22.offsetHeight = void 0;
// undefined
o22 = null;
// 10532
o22 = {};
// 10533
o17.style = o22;
// 10534
// undefined
o22 = null;
// 10535
o22 = {};
// 10536
o142.style = o22;
// undefined
o142 = null;
// 10537
// undefined
o22 = null;
// 10538
// 10539
// 10540
// 10542
f81632121_508.returns.push(o137);
// 10543
o137.getElementsByTagName = f81632121_502;
// 10545
o137.querySelectorAll = f81632121_504;
// 10546
o22 = {};
// 10547
f81632121_504.returns.push(o22);
// 10548
o22.length = 1;
// 10549
o69 = {};
// 10550
o22["0"] = o69;
// undefined
o22 = null;
// 10551
o69.nodeName = "I";
// 10552
o69.__FB_TOKEN = void 0;
// 10553
// 10554
o69.getAttribute = f81632121_506;
// 10555
o69.hasAttribute = f81632121_507;
// 10557
f81632121_507.returns.push(false);
// 10558
o69.JSBNG__addEventListener = f81632121_468;
// 10560
f81632121_468.returns.push(undefined);
// 10561
o69.JSBNG__onclick = null;
// undefined
o69 = null;
// 10564
f81632121_467.returns.push(1374851232234);
// 10566
o22 = {};
// 10567
f81632121_70.returns.push(o22);
// 10568
// 10569
o22.open = f81632121_1294;
// 10570
f81632121_1294.returns.push(undefined);
// 10571
o22.setRequestHeader = f81632121_1295;
// 10572
f81632121_1295.returns.push(undefined);
// 10574
o22.send = f81632121_1296;
// 10575
f81632121_1296.returns.push(undefined);
// 10577
f81632121_467.returns.push(1374851232237);
// 10579
o69 = {};
// 10580
f81632121_70.returns.push(o69);
// 10581
// 10582
o69.open = f81632121_1294;
// 10583
f81632121_1294.returns.push(undefined);
// 10584
o69.setRequestHeader = f81632121_1295;
// 10585
f81632121_1295.returns.push(undefined);
// 10587
o69.send = f81632121_1296;
// 10588
f81632121_1296.returns.push(undefined);
// 10591
f81632121_467.returns.push(1374851232242);
// 10593
f81632121_508.returns.push(null);
// 10598
o102 = {};
// 10599
o135 = {};
// 10601
o102.transport = o18;
// 10602
o18.readyState = 1;
// 10603
o136 = {};
// 10604
o138 = {};
// 10606
o136.transport = o19;
// 10607
o19.readyState = 1;
// 10608
o140 = {};
// 10609
o141 = {};
// 10611
o140.transport = o22;
// 10612
o22.readyState = 1;
// 10613
o142 = {};
// 10614
o143 = {};
// 10616
o142.transport = o69;
// 10617
o69.readyState = 1;
// 10618
o144 = {};
// 10619
o145 = {};
// 10621
o144.nodeType = void 0;
// 10622
o144.length = 1;
// 10623
o144["0"] = "G3fzU";
// 10628
f81632121_508.returns.push(o124);
// 10630
f81632121_508.returns.push(o122);
// 10633
f81632121_467.returns.push(1374851232942);
// 10644
o122.getAttributeNode = f81632121_1457;
// 10646
o146 = {};
// 10647
f81632121_1457.returns.push(o146);
// 10648
o146.value = "fbMessagesJewel";
// undefined
o146 = null;
// 10651
o146 = {};
// 10652
f81632121_502.returns.push(o146);
// 10653
o146.length = 41;
// 10654
o147 = {};
// 10655
o146["0"] = o147;
// 10656
o147.getAttributeNode = f81632121_1457;
// undefined
o147 = null;
// 10658
f81632121_1457.returns.push(null);
// 10660
o147 = {};
// 10661
o146["1"] = o147;
// 10662
o147.getAttributeNode = f81632121_1457;
// 10664
o148 = {};
// 10665
f81632121_1457.returns.push(o148);
// 10666
o148.value = "mercurymessagesCountWrapper";
// undefined
o148 = null;
// 10668
o148 = {};
// 10669
o146["2"] = o148;
// undefined
o146 = null;
// 10670
o148.getAttributeNode = f81632121_1457;
// 10672
o146 = {};
// 10673
f81632121_1457.returns.push(o146);
// 10674
o146.value = "mercurymessagesCountValue";
// undefined
o146 = null;
// 10676
o122.contains = f81632121_645;
// 10678
f81632121_645.returns.push(true);
// 10683
o146 = {};
// 10684
f81632121_504.returns.push(o146);
// 10685
o146.length = 1;
// 10686
o146["0"] = o147;
// undefined
o146 = null;
// 10688
o147.querySelectorAll = f81632121_504;
// undefined
o147 = null;
// 10689
o146 = {};
// 10690
f81632121_504.returns.push(o146);
// 10691
o146.length = 1;
// 10692
o146["0"] = o148;
// undefined
o146 = null;
// 10693
o146 = {};
// undefined
fo81632121_1527_firstChild = function() { return fo81632121_1527_firstChild.returns[fo81632121_1527_firstChild.inst++]; };
fo81632121_1527_firstChild.returns = [];
fo81632121_1527_firstChild.inst = 0;
defineGetter(o148, "firstChild", fo81632121_1527_firstChild, undefined);
// undefined
fo81632121_1527_firstChild.returns.push(o146);
// undefined
fo81632121_1527_firstChild.returns.push(o146);
// 10696
o146.parentNode = o148;
// 10698
o148.removeChild = f81632121_521;
// 10699
f81632121_521.returns.push(o146);
// undefined
o146 = null;
// undefined
fo81632121_1527_firstChild.returns.push(null);
// 10702
o146 = {};
// 10703
f81632121_474.returns.push(o146);
// 10705
o147 = {};
// 10706
f81632121_598.returns.push(o147);
// 10707
o146.appendChild = f81632121_478;
// 10708
f81632121_478.returns.push(o147);
// undefined
o147 = null;
// 10709
o148.appendChild = f81632121_478;
// undefined
o148 = null;
// 10710
f81632121_478.returns.push(o146);
// undefined
o146 = null;
// 10711
o146 = {};
// 10712
o122.classList = o146;
// undefined
o122 = null;
// 10714
o146.remove = f81632121_1114;
// 10715
f81632121_1114.returns.push(undefined);
// 10718
o124.getElementsByTagName = f81632121_502;
// 10719
o124.getAttributeNode = f81632121_1457;
// 10721
o122 = {};
// 10722
f81632121_1457.returns.push(o122);
// 10723
o122.value = "fbMessagesFlyout";
// undefined
o122 = null;
// 10726
o122 = {};
// 10727
f81632121_502.returns.push(o122);
// 10728
o122.length = 36;
// 10729
o147 = {};
// 10730
o122["0"] = o147;
// 10731
o147.getAttributeNode = f81632121_1457;
// undefined
o147 = null;
// 10733
f81632121_1457.returns.push(null);
// 10735
o147 = {};
// 10736
o122["1"] = o147;
// 10737
o147.getAttributeNode = f81632121_1457;
// undefined
o147 = null;
// 10739
f81632121_1457.returns.push(null);
// 10741
o147 = {};
// 10742
o122["2"] = o147;
// 10743
o147.getAttributeNode = f81632121_1457;
// undefined
o147 = null;
// 10745
f81632121_1457.returns.push(null);
// 10747
o147 = {};
// 10748
o122["3"] = o147;
// 10749
o147.getAttributeNode = f81632121_1457;
// undefined
o147 = null;
// 10751
f81632121_1457.returns.push(null);
// 10753
o147 = {};
// 10754
o122["4"] = o147;
// 10755
o147.getAttributeNode = f81632121_1457;
// undefined
o147 = null;
// 10757
f81632121_1457.returns.push(null);
// 10759
o147 = {};
// 10760
o122["5"] = o147;
// 10761
o147.getAttributeNode = f81632121_1457;
// undefined
o147 = null;
// 10763
f81632121_1457.returns.push(null);
// 10765
o147 = {};
// 10766
o122["6"] = o147;
// 10767
o147.getAttributeNode = f81632121_1457;
// undefined
o147 = null;
// 10769
f81632121_1457.returns.push(null);
// 10771
o147 = {};
// 10772
o122["7"] = o147;
// 10773
o147.getAttributeNode = f81632121_1457;
// undefined
o147 = null;
// 10775
f81632121_1457.returns.push(null);
// 10777
o122["8"] = o118;
// 10778
o118.getAttributeNode = f81632121_1457;
// undefined
o118 = null;
// 10780
o118 = {};
// 10781
f81632121_1457.returns.push(o118);
// 10782
o118.value = "u_0_0";
// undefined
o118 = null;
// 10784
o118 = {};
// 10785
o122["9"] = o118;
// 10786
o118.getAttributeNode = f81632121_1457;
// undefined
o118 = null;
// 10788
f81632121_1457.returns.push(null);
// 10790
o118 = {};
// 10791
o122["10"] = o118;
// 10792
o118.getAttributeNode = f81632121_1457;
// undefined
o118 = null;
// 10794
f81632121_1457.returns.push(null);
// 10796
o118 = {};
// 10797
o122["11"] = o118;
// 10798
o118.getAttributeNode = f81632121_1457;
// undefined
o118 = null;
// 10800
f81632121_1457.returns.push(null);
// 10802
o118 = {};
// 10803
o122["12"] = o118;
// 10804
o118.getAttributeNode = f81632121_1457;
// undefined
o118 = null;
// 10806
f81632121_1457.returns.push(null);
// 10808
o118 = {};
// 10809
o122["13"] = o118;
// 10810
o118.getAttributeNode = f81632121_1457;
// undefined
o118 = null;
// 10812
f81632121_1457.returns.push(null);
// 10814
o118 = {};
// 10815
o122["14"] = o118;
// 10816
o118.getAttributeNode = f81632121_1457;
// undefined
o118 = null;
// 10818
f81632121_1457.returns.push(null);
// 10820
o118 = {};
// 10821
o122["15"] = o118;
// 10822
o118.getAttributeNode = f81632121_1457;
// undefined
o118 = null;
// 10824
f81632121_1457.returns.push(null);
// 10826
o122["16"] = o63;
// undefined
o122 = null;
// 10827
o63.getAttributeNode = f81632121_1457;
// undefined
o63 = null;
// 10829
o63 = {};
// 10830
f81632121_1457.returns.push(o63);
// 10831
o63.value = "MercuryJewelThreadList";
// undefined
o63 = null;
// 10833
o124.contains = f81632121_645;
// undefined
o124 = null;
// 10835
f81632121_645.returns.push(true);
// 10838
o146.contains = f81632121_513;
// undefined
o146 = null;
// 10839
f81632121_513.returns.push(false);
// 10842
f81632121_508.returns.push(o125);
// 10844
f81632121_508.returns.push(null);
// 10846
f81632121_508.returns.push(null);
// 10847
o125.nodeName = "DIV";
// 10848
o125.getAttribute = f81632121_506;
// 10849
o125.hasAttribute = f81632121_507;
// 10851
f81632121_507.returns.push(false);
// 10852
o125.JSBNG__addEventListener = f81632121_468;
// 10854
f81632121_468.returns.push(undefined);
// 10855
o125.JSBNG__onsubmit = null;
// 10857
o125.getElementsByTagName = f81632121_502;
// 10859
o125.querySelectorAll = f81632121_504;
// undefined
o125 = null;
// 10860
o63 = {};
// 10861
f81632121_504.returns.push(o63);
// 10862
o63.length = 0;
// undefined
o63 = null;
// 10865
f81632121_508.returns.push(o123);
// 10867
o63 = {};
// 10868
f81632121_508.returns.push(o63);
// 10870
f81632121_508.returns.push(o127);
// 10871
o127.getElementsByTagName = f81632121_502;
// 10873
o127.querySelectorAll = f81632121_504;
// undefined
o127 = null;
// 10874
o118 = {};
// 10875
f81632121_504.returns.push(o118);
// 10876
o118.length = 1;
// 10877
o122 = {};
// 10878
o118["0"] = o122;
// undefined
o118 = null;
// undefined
o122 = null;
// 10880
o118 = {};
// 10881
f81632121_508.returns.push(o118);
// undefined
o118 = null;
// 10883
// 10890
o118 = {};
// 10891
f81632121_504.returns.push(o118);
// 10892
o118.length = 1;
// 10893
o122 = {};
// 10894
o118["0"] = o122;
// undefined
o118 = null;
// 10896
o122.querySelectorAll = f81632121_504;
// 10897
o118 = {};
// 10898
f81632121_504.returns.push(o118);
// 10899
o118.length = 1;
// 10900
o124 = {};
// 10901
o118["0"] = o124;
// undefined
o118 = null;
// 10902
o118 = {};
// undefined
fo81632121_1562_firstChild = function() { return fo81632121_1562_firstChild.returns[fo81632121_1562_firstChild.inst++]; };
fo81632121_1562_firstChild.returns = [];
fo81632121_1562_firstChild.inst = 0;
defineGetter(o124, "firstChild", fo81632121_1562_firstChild, undefined);
// undefined
fo81632121_1562_firstChild.returns.push(o118);
// undefined
fo81632121_1562_firstChild.returns.push(o118);
// 10905
o118.parentNode = o124;
// 10907
o124.removeChild = f81632121_521;
// 10908
f81632121_521.returns.push(o118);
// undefined
o118 = null;
// undefined
fo81632121_1562_firstChild.returns.push(null);
// 10911
o118 = {};
// 10912
f81632121_474.returns.push(o118);
// 10914
o125 = {};
// 10915
f81632121_598.returns.push(o125);
// 10916
o118.appendChild = f81632121_478;
// 10917
f81632121_478.returns.push(o125);
// undefined
o125 = null;
// 10918
o124.appendChild = f81632121_478;
// 10919
f81632121_478.returns.push(o118);
// undefined
o118 = null;
// 10920
o118 = {};
// 10921
o123.classList = o118;
// 10923
o118.remove = f81632121_1114;
// 10924
f81632121_1114.returns.push(undefined);
// 10926
// 10927
o123.__FB_TOKEN = void 0;
// 10928
// 10929
o123.getAttribute = f81632121_506;
// 10930
o123.hasAttribute = f81632121_507;
// 10932
f81632121_507.returns.push(false);
// 10935
o118.contains = f81632121_513;
// undefined
o118 = null;
// 10936
f81632121_513.returns.push(false);
// 10939
f81632121_506.returns.push(null);
// 10940
o118 = {};
// 10941
o123.parentNode = o118;
// 10942
o118.__FB_TOKEN = void 0;
// 10943
// 10944
o118.getAttribute = f81632121_506;
// 10945
o118.hasAttribute = f81632121_507;
// 10947
f81632121_507.returns.push(false);
// 10948
o125 = {};
// 10949
o118.classList = o125;
// 10951
o125.contains = f81632121_513;
// undefined
o125 = null;
// 10952
f81632121_513.returns.push(false);
// 10955
f81632121_506.returns.push(null);
// 10956
o125 = {};
// 10957
o118.parentNode = o125;
// undefined
o118 = null;
// 10958
o125.__FB_TOKEN = void 0;
// 10959
// 10960
o125.getAttribute = f81632121_506;
// 10961
o125.hasAttribute = f81632121_507;
// 10963
f81632121_507.returns.push(false);
// 10964
o118 = {};
// 10965
o125.classList = o118;
// 10967
o118.contains = f81632121_513;
// undefined
o118 = null;
// 10968
f81632121_513.returns.push(false);
// 10971
f81632121_506.returns.push(null);
// 10972
o118 = {};
// 10973
o125.parentNode = o118;
// undefined
o125 = null;
// 10974
o118.__FB_TOKEN = void 0;
// 10975
// 10976
o118.getAttribute = f81632121_506;
// 10977
o118.hasAttribute = f81632121_507;
// 10979
f81632121_507.returns.push(false);
// 10980
o125 = {};
// 10981
o118.classList = o125;
// 10983
o125.contains = f81632121_513;
// undefined
o125 = null;
// 10984
f81632121_513.returns.push(false);
// 10987
f81632121_506.returns.push(null);
// 10988
o125 = {};
// 10989
o118.parentNode = o125;
// undefined
o118 = null;
// 10990
o125.__FB_TOKEN = void 0;
// 10991
// 10992
o125.getAttribute = f81632121_506;
// 10993
o125.hasAttribute = f81632121_507;
// 10995
f81632121_507.returns.push(false);
// 10996
o118 = {};
// 10997
o125.classList = o118;
// 10999
o118.contains = f81632121_513;
// undefined
o118 = null;
// 11000
f81632121_513.returns.push(false);
// 11003
f81632121_506.returns.push(null);
// 11004
o118 = {};
// 11005
o125.parentNode = o118;
// undefined
o125 = null;
// 11006
o118.__FB_TOKEN = void 0;
// 11007
// 11008
o118.getAttribute = f81632121_506;
// 11009
o118.hasAttribute = f81632121_507;
// 11011
f81632121_507.returns.push(false);
// 11012
o125 = {};
// 11013
o118.classList = o125;
// 11015
o125.contains = f81632121_513;
// undefined
o125 = null;
// 11016
f81632121_513.returns.push(false);
// 11019
f81632121_506.returns.push(null);
// 11020
o118.parentNode = o105;
// undefined
o118 = null;
// 11021
o105.__FB_TOKEN = void 0;
// 11022
// 11023
o105.getAttribute = f81632121_506;
// 11024
o105.hasAttribute = f81632121_507;
// 11026
f81632121_507.returns.push(false);
// 11027
o118 = {};
// 11028
o105.classList = o118;
// 11030
o118.contains = f81632121_513;
// undefined
o118 = null;
// 11031
f81632121_513.returns.push(false);
// 11034
f81632121_506.returns.push(null);
// 11035
o105.parentNode = o137;
// undefined
o105 = null;
// 11039
f81632121_507.returns.push(false);
// 11043
f81632121_513.returns.push(false);
// 11046
f81632121_506.returns.push(null);
// 11051
f81632121_507.returns.push(false);
// 11055
f81632121_513.returns.push(false);
// 11058
f81632121_506.returns.push(null);
// 11063
f81632121_507.returns.push(false);
// 11067
f81632121_513.returns.push(false);
// 11070
f81632121_506.returns.push(null);
// 11075
f81632121_507.returns.push(false);
// 11079
f81632121_513.returns.push(false);
// 11082
f81632121_506.returns.push(null);
// 11087
f81632121_507.returns.push(false);
// 11091
f81632121_513.returns.push(false);
// 11094
f81632121_506.returns.push(null);
// 11099
f81632121_507.returns.push(false);
// 11103
f81632121_513.returns.push(false);
// 11106
f81632121_506.returns.push(null);
// 11113
f81632121_12.returns.push(41);
// 11117
o105 = {};
// 11118
f81632121_504.returns.push(o105);
// 11119
o105.length = 1;
// 11120
o105["0"] = o122;
// undefined
o105 = null;
// undefined
o122 = null;
// 11123
o105 = {};
// 11124
f81632121_504.returns.push(o105);
// 11125
o105.length = 1;
// 11126
o105["0"] = o124;
// undefined
o105 = null;
// undefined
o124 = null;
// 11127
o63.nodeName = "UL";
// 11128
o63.__FB_TOKEN = void 0;
// 11129
// 11130
o63.getAttribute = f81632121_506;
// 11131
o63.hasAttribute = f81632121_507;
// 11133
f81632121_507.returns.push(false);
// 11134
o63.JSBNG__addEventListener = f81632121_468;
// 11136
f81632121_468.returns.push(undefined);
// 11137
o63.JSBNG__onmousedown = null;
// 11142
f81632121_468.returns.push(undefined);
// 11143
o63.JSBNG__onmouseout = null;
// 11148
f81632121_468.returns.push(undefined);
// 11149
o63.JSBNG__onmouseover = null;
// 11151
o123.nodeName = "DIV";
// 11155
f81632121_507.returns.push(false);
// 11156
o123.JSBNG__addEventListener = f81632121_468;
// 11158
f81632121_468.returns.push(undefined);
// 11159
o123.JSBNG__onmouseover = null;
// 11162
f81632121_508.returns.push(o123);
// undefined
o123 = null;
// 11166
o105 = {};
// 11167
f81632121_504.returns.push(o105);
// 11168
o105.length = 1;
// 11169
o105["0"] = o76;
// undefined
o105 = null;
// undefined
o76 = null;
// 11173
o76 = {};
// 11174
f81632121_504.returns.push(o76);
// 11175
o76.length = 1;
// 11176
o105 = {};
// 11177
o76["0"] = o105;
// undefined
o76 = null;
// 11179
o105.querySelectorAll = f81632121_504;
// 11180
o76 = {};
// 11181
f81632121_504.returns.push(o76);
// 11182
o76.length = 1;
// 11183
o118 = {};
// 11184
o76["0"] = o118;
// undefined
o76 = null;
// 11185
o76 = {};
// 11186
o118.classList = o76;
// 11188
o76.contains = f81632121_513;
// undefined
o76 = null;
// 11189
f81632121_513.returns.push(false);
// 11190
o76 = {};
// 11191
o118.parentNode = o76;
// 11192
o122 = {};
// 11193
o76.classList = o122;
// 11195
o122.contains = f81632121_513;
// undefined
o122 = null;
// 11196
f81632121_513.returns.push(false);
// 11197
o76.parentNode = o105;
// undefined
o76 = null;
// 11198
o76 = {};
// 11199
o105.classList = o76;
// undefined
o105 = null;
// 11201
o76.contains = f81632121_513;
// undefined
o76 = null;
// 11202
f81632121_513.returns.push(true);
// 11204
o118.nodeName = "A";
// 11205
o118.__FB_TOKEN = void 0;
// 11206
// 11207
o118.getAttribute = f81632121_506;
// 11208
o118.hasAttribute = f81632121_507;
// 11210
f81632121_507.returns.push(false);
// 11211
o118.JSBNG__addEventListener = f81632121_468;
// 11213
f81632121_468.returns.push(undefined);
// 11214
o118.JSBNG__onsuccess = void 0;
// 11216
f81632121_12.returns.push(42);
// 11220
f81632121_507.returns.push(false);
// 11224
f81632121_513.returns.push(false);
// 11227
f81632121_506.returns.push(null);
// 11232
f81632121_507.returns.push(false);
// 11236
f81632121_513.returns.push(false);
// 11239
f81632121_506.returns.push(null);
// 11244
f81632121_507.returns.push(false);
// 11248
f81632121_513.returns.push(false);
// 11251
f81632121_506.returns.push(null);
// 11256
f81632121_507.returns.push(false);
// 11260
f81632121_513.returns.push(false);
// 11263
f81632121_506.returns.push(null);
// 11268
f81632121_507.returns.push(false);
// 11272
f81632121_513.returns.push(false);
// 11275
f81632121_506.returns.push(null);
// 11280
f81632121_507.returns.push(false);
// 11284
f81632121_513.returns.push(false);
// 11287
f81632121_506.returns.push(null);
// 11292
f81632121_507.returns.push(false);
// 11296
f81632121_513.returns.push(false);
// 11299
f81632121_506.returns.push(null);
// 11304
f81632121_507.returns.push(false);
// 11308
f81632121_513.returns.push(false);
// 11311
f81632121_506.returns.push(null);
// 11316
f81632121_507.returns.push(false);
// 11320
f81632121_513.returns.push(false);
// 11323
f81632121_506.returns.push(null);
// 11328
f81632121_507.returns.push(false);
// 11332
f81632121_513.returns.push(false);
// 11335
f81632121_506.returns.push(null);
// 11340
f81632121_507.returns.push(false);
// 11344
f81632121_513.returns.push(false);
// 11347
f81632121_506.returns.push(null);
// 11352
f81632121_507.returns.push(false);
// 11356
f81632121_513.returns.push(false);
// 11359
f81632121_506.returns.push(null);
// 11364
f81632121_507.returns.push(false);
// 11368
f81632121_513.returns.push(false);
// 11371
f81632121_506.returns.push(null);
// 11378
o63.getElementsByTagName = f81632121_502;
// 11380
o63.querySelectorAll = f81632121_504;
// undefined
o63 = null;
// 11381
o63 = {};
// 11382
f81632121_504.returns.push(o63);
// 11383
o63.length = 0;
// undefined
o63 = null;
// 11390
o63 = {};
// 11391
f81632121_70.returns.push(o63);
// 11392
// 11393
o63.open = f81632121_1294;
// 11394
f81632121_1294.returns.push(undefined);
// 11395
o63.setRequestHeader = f81632121_1295;
// 11396
f81632121_1295.returns.push(undefined);
// 11399
f81632121_1295.returns.push(undefined);
// 11400
o63.send = f81632121_1296;
// 11401
f81632121_1296.returns.push(undefined);
// 11404
f81632121_467.returns.push(1374851233092);
// 11406
f81632121_467.returns.push(1374851233092);
// 11409
f81632121_467.returns.push(1374851233093);
// 11411
f81632121_467.returns.push(1374851233093);
// 11414
f81632121_467.returns.push(1374851233093);
// 11417
f81632121_467.returns.push(1374851233093);
// 11419
f81632121_467.returns.push(1374851233094);
// 11421
o76 = {};
// 11422
o105 = {};
// 11424
o76.transport = o63;
// 11425
o63.readyState = 1;
// 11436
o122 = {};
// 11437
f81632121_508.returns.push(o122);
// 11438
o123 = {};
// 11439
o122.style = o123;
// 11440
// undefined
o123 = null;
// 11442
f81632121_508.returns.push(o27);
// 11443
o27.firstChild = null;
// undefined
o27 = null;
// 11447
o8.scrollWidth = 1017;
// 11458
o27 = {};
// 11459
f81632121_508.returns.push(o27);
// 11460
o123 = {};
// 11461
o27.classList = o123;
// 11463
o123.contains = f81632121_513;
// undefined
o123 = null;
// 11464
f81632121_513.returns.push(true);
// 11465
o27.__FB_TOKEN = void 0;
// 11466
// 11467
o123 = {};
// 11468
o27.childNodes = o123;
// undefined
o27 = null;
// 11469
o123.nodeType = void 0;
// 11470
o123.classList = void 0;
// 11471
o123.className = void 0;
// 11472
o123.childNodes = void 0;
// undefined
o123 = null;
// 11476
f81632121_467.returns.push(1374851233127);
// 11485
f81632121_467.returns.push(1374851233136);
// 11490
o27 = {};
// 11491
f81632121_508.returns.push(o27);
// 11492
o123 = {};
// 11493
o27.classList = o123;
// 11495
o123.contains = f81632121_513;
// undefined
o123 = null;
// 11496
f81632121_513.returns.push(true);
// 11497
o27.__FB_TOKEN = void 0;
// 11498
// 11499
o123 = {};
// 11500
o27.childNodes = o123;
// undefined
o27 = null;
// 11501
o123.nodeType = void 0;
// 11502
o123.classList = void 0;
// 11503
o123.className = void 0;
// 11504
o123.childNodes = void 0;
// undefined
o123 = null;
// 11509
f81632121_467.returns.push(1374851233140);
// 11511
o27 = {};
// 11512
o123 = {};
// 11514
o27.nodeType = void 0;
// 11515
o27.length = 1;
// 11516
o27["0"] = "nxD7O";
// 11519
f81632121_467.returns.push(1374851233142);
// 11522
f81632121_467.returns.push(1374851233143);
// 11524
f81632121_467.returns.push(1374851233143);
// 11526
o124 = {};
// 11527
o125 = {};
// 11528
o124.input = o125;
// undefined
o124 = null;
// 11529
o125.root = o17;
// undefined
o125 = null;
// undefined
o17 = null;
// 11533
f81632121_645.returns.push(false);
// 11536
f81632121_467.returns.push(1374851233144);
// 11537
f81632121_14.returns.push(undefined);
// 11538
f81632121_12.returns.push(43);
// 11542
f81632121_467.returns.push(1374851233147);
// 11544
f81632121_467.returns.push(1374851233147);
// 11545
f81632121_14.returns.push(undefined);
// 11546
f81632121_12.returns.push(44);
// 11548
f81632121_467.returns.push(1374851233148);
// 11549
o17 = {};
// 11550
f81632121_70.returns.push(o17);
// 11551
o17.open = f81632121_1294;
// 11552
f81632121_1294.returns.push(undefined);
// 11553
o17.setRequestHeader = f81632121_1295;
// 11554
f81632121_1295.returns.push(undefined);
// 11555
// 11556
f81632121_12.returns.push(45);
// 11558
f81632121_467.returns.push(1374851233149);
// 11560
f81632121_467.returns.push(1374851233149);
// 11561
o17.send = f81632121_1296;
// 11562
f81632121_1296.returns.push(undefined);
// 11563
o124 = {};
// 11565
o125 = {};
// 11566
o124.alertList = o125;
// 11567
f81632121_1608 = function() { return f81632121_1608.returns[f81632121_1608.inst++]; };
f81632121_1608.returns = [];
f81632121_1608.inst = 0;
// 11568
o125.getIds = f81632121_1608;
// 11569
o127 = {};
// 11570
o125._list = o127;
// 11571
f81632121_1610 = function() { return f81632121_1610.returns[f81632121_1610.inst++]; };
f81632121_1610.returns = [];
f81632121_1610.inst = 0;
// 11572
o127.reduce = f81632121_1610;
// 11573
o127._head = null;
// 11574
f81632121_1610.returns.push({__JSBNG_unknown_object:true});
// 11575
f81632121_1608.returns.push({__JSBNG_unknown_object:true});
// 11576
o124._autoLoadNotifIndex = 1;
// 11578
f81632121_1611 = function() { return f81632121_1611.returns[f81632121_1611.inst++]; };
f81632121_1611.returns = [];
f81632121_1611.inst = 0;
// 11579
o125.getDomObj = f81632121_1611;
// 11580
f81632121_1612 = function() { return f81632121_1612.returns[f81632121_1612.inst++]; };
f81632121_1612.returns = [];
f81632121_1612.inst = 0;
// 11581
o125._getField = f81632121_1612;
// 11583
f81632121_1613 = function() { return f81632121_1613.returns[f81632121_1613.inst++]; };
f81632121_1613.returns = [];
f81632121_1613.inst = 0;
// 11584
o127.get = f81632121_1613;
// 11585
o146 = {};
// 11586
o127._nodes = o146;
// 11587
o146["null"] = void 0;
// undefined
o146 = null;
// 11588
f81632121_1613.returns.push(null);
// 11589
f81632121_1612.returns.push(null);
// 11590
f81632121_1611.returns.push(null);
// 11591
// 11592
f81632121_1615 = function() { return f81632121_1615.returns[f81632121_1615.inst++]; };
f81632121_1615.returns = [];
f81632121_1615.inst = 0;
// 11593
o124._annotateMorePagerURI = f81632121_1615;
// 11594
o124._morePagerLink = o118;
// 11595
o118.setAttribute = f81632121_575;
// undefined
o118 = null;
// 11598
f81632121_506.returns.push("/ajax/notifications/get.php?user=100006118350059");
// 11600
f81632121_1616 = function() { return f81632121_1616.returns[f81632121_1616.inst++]; };
f81632121_1616.returns = [];
f81632121_1616.inst = 0;
// 11601
o125.getEarliestNotifTime = f81632121_1616;
// undefined
o125 = null;
// 11603
f81632121_1617 = function() { return f81632121_1617.returns[f81632121_1617.inst++]; };
f81632121_1617.returns = [];
f81632121_1617.inst = 0;
// 11604
o127.isEmpty = f81632121_1617;
// undefined
o127 = null;
// 11606
f81632121_1617.returns.push(true);
// 11607
f81632121_1616.returns.push(0);
// 11608
f81632121_575.returns.push(undefined);
// 11609
f81632121_1615.returns.push(undefined);
// 11610
o118 = {};
// 11611
f81632121_1619 = function() { return f81632121_1619.returns[f81632121_1619.inst++]; };
f81632121_1619.returns = [];
f81632121_1619.inst = 0;
// 11612
o118.inform = f81632121_1619;
// 11613
f81632121_1620 = function() { return f81632121_1620.returns[f81632121_1620.inst++]; };
f81632121_1620.returns = [];
f81632121_1620.inst = 0;
// 11614
o118._getArbiterInstance = f81632121_1620;
// 11615
o125 = {};
// 11616
o118._arbiter = o125;
// undefined
o118 = null;
// 11617
f81632121_1620.returns.push(o125);
// 11618
f81632121_1622 = function() { return f81632121_1622.returns[f81632121_1622.inst++]; };
f81632121_1622.returns = [];
f81632121_1622.inst = 0;
// 11619
o125.inform = f81632121_1622;
// 11620
o118 = {};
// 11621
o125.$Arbiter3 = o118;
// 11622
f81632121_1624 = function() { return f81632121_1624.returns[f81632121_1624.inst++]; };
f81632121_1624.returns = [];
f81632121_1624.inst = 0;
// 11623
o118.push = f81632121_1624;
// 11624
f81632121_1624.returns.push(1);
// 11625
o127 = {};
// 11626
o125.$Arbiter0 = o127;
// 11627
f81632121_1626 = function() { return f81632121_1626.returns[f81632121_1626.inst++]; };
f81632121_1626.returns = [];
f81632121_1626.inst = 0;
// 11628
o127.setHoldingBehavior = f81632121_1626;
// 11629
o146 = {};
// 11630
o127.$ArbiterEventHolder0 = o146;
// 11631
// 11632
f81632121_1626.returns.push(undefined);
// 11633
o147 = {};
// 11634
o125.$Arbiter1 = o147;
// 11635
f81632121_1629 = function() { return f81632121_1629.returns[f81632121_1629.inst++]; };
f81632121_1629.returns = [];
f81632121_1629.inst = 0;
// 11636
o147.emitAndHold = f81632121_1629;
// 11637
o147.$EventEmitterWithHolding1 = o127;
// 11638
f81632121_1630 = function() { return f81632121_1630.returns[f81632121_1630.inst++]; };
f81632121_1630.returns = [];
f81632121_1630.inst = 0;
// 11639
o127.holdEvent = f81632121_1630;
// 11641
f81632121_1631 = function() { return f81632121_1631.returns[f81632121_1631.inst++]; };
f81632121_1631.returns = [];
f81632121_1631.inst = 0;
// 11642
o127.$ArbiterEventHolder2 = f81632121_1631;
// 11643
f81632121_1632 = function() { return f81632121_1632.returns[f81632121_1632.inst++]; };
f81632121_1632.returns = [];
f81632121_1632.inst = 0;
// 11644
o127.emitToListener = f81632121_1632;
// 11645
f81632121_1633 = function() { return f81632121_1633.returns[f81632121_1633.inst++]; };
f81632121_1633.returns = [];
f81632121_1633.inst = 0;
// 11646
o127.releaseCurrentEvent = f81632121_1633;
// 11647
f81632121_1634 = function() { return f81632121_1634.returns[f81632121_1634.inst++]; };
f81632121_1634.returns = [];
f81632121_1634.inst = 0;
// 11648
o127.forEachHeldEvent = f81632121_1634;
// 11649
o148 = {};
// 11650
o127.$EventHolder0 = o148;
// 11651
f81632121_1636 = function() { return f81632121_1636.returns[f81632121_1636.inst++]; };
f81632121_1636.returns = [];
f81632121_1636.inst = 0;
// 11652
o148.forEach = f81632121_1636;
// undefined
o148 = null;
// 11653
f81632121_1636.returns.push(undefined);
// 11654
// 11655
f81632121_1634.returns.push(undefined);
// 11656
f81632121_1632.returns.push(undefined);
// 11657
f81632121_1631.returns.push(undefined);
// 11658
f81632121_1630.returns.push(undefined);
// 11659
// 11660
o148 = {};
// 11661
o147.$EventEmitterWithHolding0 = o148;
// 11662
f81632121_1638 = function() { return f81632121_1638.returns[f81632121_1638.inst++]; };
f81632121_1638.returns = [];
f81632121_1638.inst = 0;
// 11663
o148.emit = f81632121_1638;
// 11664
o149 = {};
// 11665
o148.$EventEmitter0 = o149;
// undefined
o148 = null;
// 11666
f81632121_1640 = function() { return f81632121_1640.returns[f81632121_1640.inst++]; };
f81632121_1640.returns = [];
f81632121_1640.inst = 0;
// 11667
o149.getSubscriptionsForType = f81632121_1640;
// 11668
o148 = {};
// 11669
o149.$EventSubscriptionVendor0 = o148;
// undefined
o149 = null;
// 11670
o148.activity = void 0;
// 11671
f81632121_1640.returns.push(undefined);
// 11672
f81632121_1638.returns.push(undefined);
// 11673
// 11674
f81632121_1629.returns.push(undefined);
// 11675
f81632121_1642 = function() { return f81632121_1642.returns[f81632121_1642.inst++]; };
f81632121_1642.returns = [];
f81632121_1642.inst = 0;
// 11676
o125.$Arbiter5 = f81632121_1642;
// 11677
o149 = {};
// 11678
o125.$Arbiter2 = o149;
// 11679
f81632121_1644 = function() { return f81632121_1644.returns[f81632121_1644.inst++]; };
f81632121_1644.returns = [];
f81632121_1644.inst = 0;
// 11680
o149.satisfyNonPersistentDependency = f81632121_1644;
// 11681
o150 = {};
// 11682
o149.$CallbackDependencyManager3 = o150;
// 11683
o150.activity = void 0;
// 11685
// 11686
f81632121_1646 = function() { return f81632121_1646.returns[f81632121_1646.inst++]; };
f81632121_1646.returns = [];
f81632121_1646.inst = 0;
// 11687
o149.$CallbackDependencyManager5 = f81632121_1646;
// 11688
o151 = {};
// 11689
o149.$CallbackDependencyManager0 = o151;
// undefined
o149 = null;
// 11690
o151.activity = void 0;
// 11691
f81632121_1646.returns.push(undefined);
// 11693
// 11694
f81632121_1644.returns.push(undefined);
// 11695
f81632121_1642.returns.push(undefined);
// 11697
f81632121_1648 = function() { return f81632121_1648.returns[f81632121_1648.inst++]; };
f81632121_1648.returns = [];
f81632121_1648.inst = 0;
// 11698
o118.pop = f81632121_1648;
// undefined
o118 = null;
// 11699
o118 = {};
// 11700
f81632121_1648.returns.push(o118);
// 11701
o118.activity = void 0;
// undefined
o118 = null;
// 11702
f81632121_1622.returns.push(undefined);
// 11703
f81632121_1619.returns.push(undefined);
// 11707
f81632121_1620.returns.push(o125);
// undefined
o125 = null;
// 11711
f81632121_1624.returns.push(1);
// 11715
// undefined
o146 = null;
// 11716
f81632121_1626.returns.push(undefined);
// 11728
f81632121_1636.returns.push(undefined);
// 11729
// undefined
o127 = null;
// 11730
f81632121_1634.returns.push(undefined);
// 11731
f81632121_1632.returns.push(undefined);
// 11732
f81632121_1631.returns.push(undefined);
// 11733
f81632121_1630.returns.push(undefined);
// 11734
// 11740
o148.change = void 0;
// undefined
o148 = null;
// 11741
f81632121_1640.returns.push(undefined);
// 11742
f81632121_1638.returns.push(undefined);
// 11743
// undefined
o147 = null;
// 11744
f81632121_1629.returns.push(undefined);
// 11749
o150.change = void 0;
// 11751
// 11754
o151.change = void 0;
// undefined
o151 = null;
// 11755
f81632121_1646.returns.push(undefined);
// 11757
// undefined
o150 = null;
// 11758
f81632121_1644.returns.push(undefined);
// 11759
f81632121_1642.returns.push(undefined);
// 11762
o118 = {};
// 11763
f81632121_1648.returns.push(o118);
// 11764
o118.change = void 0;
// undefined
o118 = null;
// 11765
f81632121_1622.returns.push(undefined);
// 11766
f81632121_1619.returns.push(undefined);
// 11767
o118 = {};
// 11768
o118._shown = false;
// undefined
o118 = null;
// 11769
o118 = {};
// undefined
fo81632121_1_cookie.returns.push("c_user=100006118350059; csm=2");
// 11774
f81632121_467.returns.push(1374851233175);
// 11775
o125 = {};
// 11779
o127 = {};
// 11783
o146 = {};
// 11787
o147 = {};
// 11791
o148 = {};
// 11796
o19.getResponseHeader = f81632121_1332;
// 11799
f81632121_1332.returns.push("OEaB02R0RTf78rAJ1DuTDFgTjOvmrkR5ELLovIg3pzM=");
// 11802
f81632121_1332.returns.push("OEaB02R0RTf78rAJ1DuTDFgTjOvmrkR5ELLovIg3pzM=");
// 11803
// 11805
o19.JSBNG__status = 200;
// 11809
f81632121_467.returns.push(1374851233177);
// 11810
o136._handleXHRResponse = f81632121_1333;
// 11812
o136.getOption = f81632121_1334;
// 11813
o149 = {};
// 11814
o136.option = o149;
// 11815
o149.suppressEvaluation = false;
// 11818
f81632121_1334.returns.push(false);
// 11819
o19.responseText = "for (;;);{\"__ar\":1,\"payload\":{\"entities\":[],\"queries\":[{\"iconClass\":\"-cx-PRIVATE-fbFacebarTypeaheadItem__usericon\",\"original_cost\":2,\"null_state_position\":null,\"parse\":{\"display\":[\"People I may know\"],\"suffix\":\"\",\"remTokens\":[0,1,2,3],\"unmatch\":[0,1,2,3]},\"semantic\":\"intersect(friends(friends(me)),non-friends(me))\",\"tuid\":\"intersect(friends(friends(me)),non-friends(me))\",\"type\":\"browse_type_user\",\"isNullState\":\"true\",\"cost\":3,\"path\":null,\"isRedirect\":false},{\"iconClass\":\"-cx-PRIVATE-fbFacebarTypeaheadItem__usericon\",\"original_cost\":2.5,\"null_state_position\":null,\"parse\":{\"display\":[\"My friends\"],\"suffix\":\"\",\"remTokens\":[0,1],\"unmatch\":[0,1]},\"semantic\":\"friends(me)\",\"tuid\":\"friends(me)\",\"type\":\"browse_type_user\",\"isNullState\":\"true\",\"cost\":2,\"path\":null,\"isRedirect\":false},{\"iconClass\":\"-cx-PRIVATE-fbFacebarTypeaheadItem__photoicon\",\"original_cost\":3,\"null_state_position\":null,\"parse\":{\"display\":[\"Photos of my friends\"],\"suffix\":\"\",\"remTokens\":[0,1,2,3],\"unmatch\":[0,1,2,3]},\"semantic\":\"photos-of(friends(me))\",\"tuid\":\"photos-of(friends(me))\",\"type\":\"browse_type_photo\",\"isNullState\":\"true\",\"cost\":3,\"path\":null,\"isRedirect\":false},{\"iconClass\":\"-cx-PRIVATE-fbFacebarTypeaheadItem__musicicon\",\"original_cost\":3.5,\"null_state_position\":null,\"parse\":{\"display\":[\"Music my friends like\"],\"suffix\":\"\",\"remTokens\":[0,1,2,3],\"unmatch\":[0,1,2,3]},\"semantic\":\"intersect(pages(musician),pages-liked(friends(me)))\",\"tuid\":\"intersect(pages(musician),pages-liked(friends(me)))\",\"type\":\"browse_type_music\",\"isNullState\":\"true\",\"cost\":3,\"path\":null,\"isRedirect\":false},{\"iconClass\":\"-cx-PRIVATE-fbFacebarTypeaheadItem__movieicon\",\"original_cost\":4,\"null_state_position\":null,\"parse\":{\"display\":[\"Movies my friends like\"],\"suffix\":\"\",\"remTokens\":[0,1,2,3],\"unmatch\":[0,1,2,3]},\"semantic\":\"intersect(pages(movie),pages-liked(friends(me)))\",\"tuid\":\"intersect(pages(movie),pages-liked(friends(me)))\",\"type\":\"browse_type_movie\",\"isNullState\":\"true\",\"cost\":3,\"path\":null,\"isRedirect\":false},{\"iconClass\":\"-cx-PRIVATE-fbFacebarTypeaheadItem__placeicon\",\"original_cost\":4.5,\"null_state_position\":null,\"parse\":{\"display\":[\"Restaurants nearby\"],\"suffix\":\"\",\"remTokens\":[0,1],\"unmatch\":[0,1]},\"semantic\":\"intersect(places(273819889375819),places-near(me))\",\"tuid\":\"intersect(places(273819889375819),places-near(me))\",\"type\":\"browse_type_place\",\"isNullState\":\"true\",\"cost\":2,\"path\":null,\"isRedirect\":false},{\"iconClass\":\"-cx-PRIVATE-fbFacebarTypeaheadItem__gameicon\",\"original_cost\":5,\"null_state_position\":null,\"parse\":{\"display\":[\"Games my friends play\"],\"suffix\":\"\",\"remTokens\":[0,1,2,3],\"unmatch\":[0,1,2,3]},\"semantic\":\"intersect(apps(game),apps-used(friends(me)))\",\"tuid\":\"intersect(apps(game),apps-used(friends(me)))\",\"type\":\"browse_type_game\",\"isNullState\":\"true\",\"cost\":3,\"path\":null,\"isRedirect\":false},{\"iconClass\":\"-cx-PRIVATE-fbFacebarTypeaheadItem__photoicon\",\"original_cost\":5.5,\"null_state_position\":null,\"parse\":{\"display\":[\"Photos I have liked\"],\"suffix\":\"\",\"remTokens\":[0,1,2,3],\"unmatch\":[0,1,2,3]},\"semantic\":\"photos-liked(me)\",\"tuid\":\"photos-liked(me)\",\"type\":\"browse_type_photo\",\"isNullState\":\"true\",\"cost\":3,\"path\":null,\"isRedirect\":false},{\"iconClass\":\"-cx-PRIVATE-fbFacebarTypeaheadItem__groupicon\",\"original_cost\":6,\"null_state_position\":null,\"parse\":{\"display\":[\"Groups my friends are in\"],\"suffix\":\"\",\"remTokens\":[0,1,2,3,4],\"unmatch\":[0,1,2,3,4]},\"semantic\":\"groups(friends(me))\",\"tuid\":\"groups(friends(me))\",\"type\":\"browse_type_group\",\"isNullState\":\"true\",\"cost\":3.5,\"path\":null,\"isRedirect\":false},{\"iconClass\":\"-cx-PRIVATE-fbFacebarTypeaheadItem__placeicon\",\"original_cost\":6.5,\"null_state_position\":null,\"parse\":{\"display\":[\"Places my friends have been to\"],\"suffix\":\"\",\"remTokens\":[0,1,2,3,4,5],\"unmatch\":[0,1,2,3,4,5]},\"semantic\":\"places-visited(friends(me))\",\"tuid\":\"places-visited(friends(me))\",\"type\":\"browse_type_place\",\"isNullState\":\"true\",\"cost\":4,\"path\":null,\"isRedirect\":false},{\"iconClass\":\"-cx-PRIVATE-fbFacebarTypeaheadItem__appicon\",\"original_cost\":7,\"null_state_position\":null,\"parse\":{\"display\":[\"Apps my friends use\"],\"suffix\":\"\",\"remTokens\":[0,1,2,3],\"unmatch\":[0,1,2,3]},\"semantic\":\"apps-used(friends(me))\",\"tuid\":\"apps-used(friends(me))\",\"type\":\"browse_type_application\",\"isNullState\":\"true\",\"cost\":3,\"path\":null,\"isRedirect\":false},{\"iconClass\":\"-cx-PRIVATE-fbFacebarTypeaheadItem__placeicon\",\"original_cost\":7.5,\"null_state_position\":null,\"parse\":{\"display\":[\"Current cities of my friends\"],\"suffix\":\"\",\"remTokens\":[0,1,2,3,4],\"unmatch\":[0,1,2,3,4]},\"semantic\":\"intersect(current-cities(friends(me)),pages(city))\",\"tuid\":\"intersect(current-cities(friends(me)),pages(city))\",\"type\":\"browse_type_city\",\"isNullState\":\"true\",\"cost\":3.5,\"path\":null,\"isRedirect\":false}]},\"css\":[\"c6lUE\"],\"bootloadable\":{},\"resource_map\":{\"c6lUE\":{\"type\":\"css\",\"permanent\":1,\"crossOrigin\":1,\"src\":\"https:\\/\\/static.xx.fbcdn.net\\/rsrc.php\\/v2\\/y1\\/r\\/i2fjJiK4liE.css\"}},\"ixData\":[]}";
// 11820
o136._unshieldResponseText = f81632121_1336;
// 11821
f81632121_1336.returns.push("{\"__ar\":1,\"payload\":{\"entities\":[],\"queries\":[{\"iconClass\":\"-cx-PRIVATE-fbFacebarTypeaheadItem__usericon\",\"original_cost\":2,\"null_state_position\":null,\"parse\":{\"display\":[\"People I may know\"],\"suffix\":\"\",\"remTokens\":[0,1,2,3],\"unmatch\":[0,1,2,3]},\"semantic\":\"intersect(friends(friends(me)),non-friends(me))\",\"tuid\":\"intersect(friends(friends(me)),non-friends(me))\",\"type\":\"browse_type_user\",\"isNullState\":\"true\",\"cost\":3,\"path\":null,\"isRedirect\":false},{\"iconClass\":\"-cx-PRIVATE-fbFacebarTypeaheadItem__usericon\",\"original_cost\":2.5,\"null_state_position\":null,\"parse\":{\"display\":[\"My friends\"],\"suffix\":\"\",\"remTokens\":[0,1],\"unmatch\":[0,1]},\"semantic\":\"friends(me)\",\"tuid\":\"friends(me)\",\"type\":\"browse_type_user\",\"isNullState\":\"true\",\"cost\":2,\"path\":null,\"isRedirect\":false},{\"iconClass\":\"-cx-PRIVATE-fbFacebarTypeaheadItem__photoicon\",\"original_cost\":3,\"null_state_position\":null,\"parse\":{\"display\":[\"Photos of my friends\"],\"suffix\":\"\",\"remTokens\":[0,1,2,3],\"unmatch\":[0,1,2,3]},\"semantic\":\"photos-of(friends(me))\",\"tuid\":\"photos-of(friends(me))\",\"type\":\"browse_type_photo\",\"isNullState\":\"true\",\"cost\":3,\"path\":null,\"isRedirect\":false},{\"iconClass\":\"-cx-PRIVATE-fbFacebarTypeaheadItem__musicicon\",\"original_cost\":3.5,\"null_state_position\":null,\"parse\":{\"display\":[\"Music my friends like\"],\"suffix\":\"\",\"remTokens\":[0,1,2,3],\"unmatch\":[0,1,2,3]},\"semantic\":\"intersect(pages(musician),pages-liked(friends(me)))\",\"tuid\":\"intersect(pages(musician),pages-liked(friends(me)))\",\"type\":\"browse_type_music\",\"isNullState\":\"true\",\"cost\":3,\"path\":null,\"isRedirect\":false},{\"iconClass\":\"-cx-PRIVATE-fbFacebarTypeaheadItem__movieicon\",\"original_cost\":4,\"null_state_position\":null,\"parse\":{\"display\":[\"Movies my friends like\"],\"suffix\":\"\",\"remTokens\":[0,1,2,3],\"unmatch\":[0,1,2,3]},\"semantic\":\"intersect(pages(movie),pages-liked(friends(me)))\",\"tuid\":\"intersect(pages(movie),pages-liked(friends(me)))\",\"type\":\"browse_type_movie\",\"isNullState\":\"true\",\"cost\":3,\"path\":null,\"isRedirect\":false},{\"iconClass\":\"-cx-PRIVATE-fbFacebarTypeaheadItem__placeicon\",\"original_cost\":4.5,\"null_state_position\":null,\"parse\":{\"display\":[\"Restaurants nearby\"],\"suffix\":\"\",\"remTokens\":[0,1],\"unmatch\":[0,1]},\"semantic\":\"intersect(places(273819889375819),places-near(me))\",\"tuid\":\"intersect(places(273819889375819),places-near(me))\",\"type\":\"browse_type_place\",\"isNullState\":\"true\",\"cost\":2,\"path\":null,\"isRedirect\":false},{\"iconClass\":\"-cx-PRIVATE-fbFacebarTypeaheadItem__gameicon\",\"original_cost\":5,\"null_state_position\":null,\"parse\":{\"display\":[\"Games my friends play\"],\"suffix\":\"\",\"remTokens\":[0,1,2,3],\"unmatch\":[0,1,2,3]},\"semantic\":\"intersect(apps(game),apps-used(friends(me)))\",\"tuid\":\"intersect(apps(game),apps-used(friends(me)))\",\"type\":\"browse_type_game\",\"isNullState\":\"true\",\"cost\":3,\"path\":null,\"isRedirect\":false},{\"iconClass\":\"-cx-PRIVATE-fbFacebarTypeaheadItem__photoicon\",\"original_cost\":5.5,\"null_state_position\":null,\"parse\":{\"display\":[\"Photos I have liked\"],\"suffix\":\"\",\"remTokens\":[0,1,2,3],\"unmatch\":[0,1,2,3]},\"semantic\":\"photos-liked(me)\",\"tuid\":\"photos-liked(me)\",\"type\":\"browse_type_photo\",\"isNullState\":\"true\",\"cost\":3,\"path\":null,\"isRedirect\":false},{\"iconClass\":\"-cx-PRIVATE-fbFacebarTypeaheadItem__groupicon\",\"original_cost\":6,\"null_state_position\":null,\"parse\":{\"display\":[\"Groups my friends are in\"],\"suffix\":\"\",\"remTokens\":[0,1,2,3,4],\"unmatch\":[0,1,2,3,4]},\"semantic\":\"groups(friends(me))\",\"tuid\":\"groups(friends(me))\",\"type\":\"browse_type_group\",\"isNullState\":\"true\",\"cost\":3.5,\"path\":null,\"isRedirect\":false},{\"iconClass\":\"-cx-PRIVATE-fbFacebarTypeaheadItem__placeicon\",\"original_cost\":6.5,\"null_state_position\":null,\"parse\":{\"display\":[\"Places my friends have been to\"],\"suffix\":\"\",\"remTokens\":[0,1,2,3,4,5],\"unmatch\":[0,1,2,3,4,5]},\"semantic\":\"places-visited(friends(me))\",\"tuid\":\"places-visited(friends(me))\",\"type\":\"browse_type_place\",\"isNullState\":\"true\",\"cost\":4,\"path\":null,\"isRedirect\":false},{\"iconClass\":\"-cx-PRIVATE-fbFacebarTypeaheadItem__appicon\",\"original_cost\":7,\"null_state_position\":null,\"parse\":{\"display\":[\"Apps my friends use\"],\"suffix\":\"\",\"remTokens\":[0,1,2,3],\"unmatch\":[0,1,2,3]},\"semantic\":\"apps-used(friends(me))\",\"tuid\":\"apps-used(friends(me))\",\"type\":\"browse_type_application\",\"isNullState\":\"true\",\"cost\":3,\"path\":null,\"isRedirect\":false},{\"iconClass\":\"-cx-PRIVATE-fbFacebarTypeaheadItem__placeicon\",\"original_cost\":7.5,\"null_state_position\":null,\"parse\":{\"display\":[\"Current cities of my friends\"],\"suffix\":\"\",\"remTokens\":[0,1,2,3,4],\"unmatch\":[0,1,2,3,4]},\"semantic\":\"intersect(current-cities(friends(me)),pages(city))\",\"tuid\":\"intersect(current-cities(friends(me)),pages(city))\",\"type\":\"browse_type_city\",\"isNullState\":\"true\",\"cost\":3.5,\"path\":null,\"isRedirect\":false}]},\"css\":[\"c6lUE\"],\"bootloadable\":{},\"resource_map\":{\"c6lUE\":{\"type\":\"css\",\"permanent\":1,\"crossOrigin\":1,\"src\":\"https:\\/\\/static.xx.fbcdn.net\\/rsrc.php\\/v2\\/y1\\/r\\/i2fjJiK4liE.css\"}},\"ixData\":[]}");
// 11822
o136._interpretResponse = f81632121_1337;
// 11823
f81632121_1337.returns.push({__JSBNG_unknown_object:true});
// 11824
o136.invokeResponseHandler = f81632121_1338;
// 11825
f81632121_1659 = function() { return f81632121_1659.returns[f81632121_1659.inst++]; };
f81632121_1659.returns = [];
f81632121_1659.inst = 0;
// 11826
o136.handler = f81632121_1659;
// 11827
o136._isRelevant = f81632121_1340;
// 11828
o136._allowCrossPageTransition = true;
// 11829
f81632121_1340.returns.push(true);
// 11830
o136._dispatchResponse = f81632121_1341;
// 11831
o136.getURI = f81632121_1342;
// 11832
o150 = {};
// 11833
o136.uri = o150;
// 11835
o150.$URIBase0 = "";
// 11836
o150.$URIBase1 = "";
// 11837
o150.$URIBase2 = "";
// 11838
o150.$URIBase3 = "/ajax/browse/null_state.php";
// 11840
o151 = {};
// 11841
o150.$URIBase5 = o151;
// 11842
f81632121_1662 = function() { return f81632121_1662.returns[f81632121_1662.inst++]; };
f81632121_1662.returns = [];
f81632121_1662.inst = 0;
// 11844
f81632121_1662.returns.push(true);
// 11845
o151.__a = 1;
// 11848
f81632121_1662.returns.push(true);
// 11849
o151.__dyn = "7n8ahyj2qmvudDgDxqjEHznBw";
// 11852
f81632121_1662.returns.push(true);
// 11853
o151.__req = "3";
// 11856
f81632121_1662.returns.push(true);
// 11857
o151.__user = "100006118350059";
// 11860
f81632121_1662.returns.push(true);
// 11861
o151.grammar_version = "9ab0d482a92fc9cfa37e6c174e4543ea4a022340";
// 11863
o150.$URIBase4 = "";
// 11864
f81632121_1344.returns.push("/ajax/browse/null_state.php?__a=1&__dyn=7n8ahyj2qmvudDgDxqjEHznBw&__req=3&__user=100006118350059&grammar_version=9ab0d482a92fc9cfa37e6c174e4543ea4a022340");
// 11865
f81632121_1342.returns.push("/ajax/browse/null_state.php?__a=1&__dyn=7n8ahyj2qmvudDgDxqjEHznBw&__req=3&__user=100006118350059&grammar_version=9ab0d482a92fc9cfa37e6c174e4543ea4a022340");
// 11866
o136.preBootloadHandler = void 0;
// 11877
f81632121_1662.returns.push(true);
// 11881
f81632121_1662.returns.push(true);
// 11885
f81632121_1662.returns.push(true);
// 11889
f81632121_1662.returns.push(true);
// 11893
f81632121_1662.returns.push(true);
// 11897
f81632121_1344.returns.push("/ajax/browse/null_state.php?__a=1&__dyn=7n8ahyj2qmvudDgDxqjEHznBw&__req=3&__user=100006118350059&grammar_version=9ab0d482a92fc9cfa37e6c174e4543ea4a022340");
// 11898
f81632121_1342.returns.push("/ajax/browse/null_state.php?__a=1&__dyn=7n8ahyj2qmvudDgDxqjEHznBw&__req=3&__user=100006118350059&grammar_version=9ab0d482a92fc9cfa37e6c174e4543ea4a022340");
// 11900
f81632121_12.returns.push(46);
// 11904
o152 = {};
// 11905
f81632121_474.returns.push(o152);
// 11907
f81632121_478.returns.push(o152);
// undefined
o152 = null;
// 11908
f81632121_1338.returns.push(undefined);
// 11909
f81632121_1333.returns.push(undefined);
// 11912
o149.asynchronous = true;
// undefined
o149 = null;
// 11915
f81632121_1334.returns.push(true);
// 11916
// 11917
o149 = {};
// 11921
o152 = {};
// 11925
o153 = {};
// 11929
o154 = {};
// 11934
o18.getResponseHeader = f81632121_1332;
// 11937
f81632121_1332.returns.push("WRM6aRBwBULw3+63TOvbKooYnQNT3s5FTkEaJBNbB6E=");
// 11940
f81632121_1332.returns.push("WRM6aRBwBULw3+63TOvbKooYnQNT3s5FTkEaJBNbB6E=");
// 11941
// 11943
o18.JSBNG__status = 200;
// 11947
f81632121_467.returns.push(1374851233192);
// 11948
o102._handleXHRResponse = f81632121_1333;
// 11950
o102.getOption = f81632121_1334;
// 11951
o155 = {};
// 11952
o102.option = o155;
// 11953
o155.suppressEvaluation = false;
// 11956
f81632121_1334.returns.push(false);
// 11957
o18.responseText = "for (;;);{\"__ar\":1,\"payload\":{\"entity_cost\":0.5,\"blank_cost\":0.5,\"typeahead_types\":[\"user\",\"user-dynamic\",\"place\",\"place-category\",\"page\",\"page-category\",\"app\",\"group\",\"event\",\"friendlist\",\"list\",\"music\",\"shortcut\",\"websuggestion\",\"facebar_query\",\"product\",\"og-book\",\"og-movie\",\"og-tv_show\",\"hashtag_exact\",\"activity\",\"activity-actors\",\"activity-verb\",\"activity-verb-present-singular\",\"job-title\",\"job-title-activity\",\"job-title-workers\",\"political-view-adjective\",\"political-view-members\",\"political-view-party\",\"religion\",\"religion-adjective\",\"religion-alt\",\"religion-members\"],\"mapped_types\":{\"gameapp\":\"app\"},\"mapped_types_subquery\":{\"place\":\"page\"},\"bootstrap_types\":[\"user\",\"page\",\"group\",\"app\",\"event\",\"friendlist\",\"shortcut\"],\"browse_functions\":{\"intersect\":{\"numParamsUnbounded\":true,\"minNumParams\":1,\"maxNumParams\":100,\"allowsFreeText\":false},\"union\":{\"numParamsUnbounded\":true,\"minNumParams\":1,\"maxNumParams\":100,\"allowsFreeText\":false},\"fbids\":{\"numParamsUnbounded\":true,\"minNumParams\":1,\"maxNumParams\":100,\"allowsFreeText\":false},\"all\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"pages\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"users\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"present\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"past\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"future\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"ever\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"ever-past\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"class\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"date\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":2,\"allowsFreeText\":false},\"after\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":2,\"allowsFreeText\":false},\"before\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":2,\"allowsFreeText\":false},\"duration-past\":{\"numParamsUnbounded\":false,\"minNumParams\":2,\"maxNumParams\":2,\"allowsFreeText\":false},\"duration-future\":{\"numParamsUnbounded\":false,\"minNumParams\":2,\"maxNumParams\":2,\"allowsFreeText\":false},\"users-age\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":2,\"allowsFreeText\":false},\"users-younger\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":2,\"allowsFreeText\":false},\"users-older\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":2,\"allowsFreeText\":false},\"users-born\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":2,\"allowsFreeText\":false},\"users-interested\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"users-named\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":true},\"users-birth-place\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":2,\"allowsFreeText\":false},\"females\":{\"numParamsUnbounded\":false,\"minNumParams\":0,\"maxNumParams\":0,\"allowsFreeText\":false},\"males\":{\"numParamsUnbounded\":false,\"minNumParams\":0,\"maxNumParams\":0,\"allowsFreeText\":false},\"members\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"friends\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"online-friends\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"non-friends\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"acquaintances\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"close-friends\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"restricted-friends\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"followers\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"users-followed\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"creators\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"admins\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"groups\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"non-groups\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"groups-privacy\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"groups-named\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":true},\"groups-about\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"communities\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"communities-named\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":true},\"relatives\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"siblings\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"brothers\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"sisters\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"parents\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"fathers\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"mothers\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"children\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"sons\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"daughters\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"aunts\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"uncles\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"nieces\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"nephews\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"cousins\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"grandchildren\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"grandsons\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"granddaughters\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"grandparents\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"grandmothers\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"grandfathers\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"stepsiblings\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"stepsisters\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"stepbrothers\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"stepparents\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"stepfathers\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"stepmothers\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"stepchildren\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"stepdaughters\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"stepsons\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"sisters-in-law\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"brothers-in-law\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"fathers-in-law\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"mothers-in-law\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"sons-in-law\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"daughters-in-law\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"partners\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"boyfriends\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"girlfriends\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"users-any-relationship\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"users-dating\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"users-relationship\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"users-open-relationship\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"spouses\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"fiances\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"users-its-complicated\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"users-civil-union\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"domestic-partners\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"wives\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"husbands\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"students\":{\"numParamsUnbounded\":false,\"minNumParams\":0,\"maxNumParams\":7,\"allowsFreeText\":false},\"employees\":{\"numParamsUnbounded\":false,\"minNumParams\":0,\"maxNumParams\":5,\"allowsFreeText\":false},\"major\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"degree\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"job\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"schools-attended\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":4,\"allowsFreeText\":false},\"school-location\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"high-schools-attended\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":4,\"allowsFreeText\":false},\"colleges-attended\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":4,\"allowsFreeText\":false},\"grad-schools-attended\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":4,\"allowsFreeText\":false},\"employer-location\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"employers\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":3,\"allowsFreeText\":false},\"residents-near\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":4,\"allowsFreeText\":false},\"home-residents\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":2,\"allowsFreeText\":false},\"hometowns\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"residents\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":2,\"allowsFreeText\":false},\"current-cities\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"current-regions\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"current-countries\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"users-of-nationalities\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"nationalities\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"speakers\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"languages\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"likers\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"exact-page-likers\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"job-liker-union\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"listeners\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"readers\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"watchers\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"page_raters\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"commenters\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"users-religious-view\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"users-political-view\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"admirers\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"religious-views\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"political-views\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"visitors\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"users-checked-in\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"places-checked-in\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"places-visited\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"pages-in\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"places\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"places-in\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"places-near\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":4,\"allowsFreeText\":false},\"places-liked\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"places-named\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":true},\"pages-named\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":true},\"pages-about\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"pages-recommended-by\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"pages-liked\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"pages-recommended-for\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"pages-similar-to\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"photos-recommended-for\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"photos-of\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"photos-in\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"photos-by\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"photos-tagged\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"photos-liked\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"photos-uploaded\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"photos\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":2,\"allowsFreeText\":false},\"photos-commented\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"photos-interested\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"photos-interacted\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"photos-about\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"photos-reshared\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"timeline\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"photos-tagged-or-uploaded\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"users-tagged\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"users-interacted\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"videos-of\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"videos-in\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"videos-by\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"videos-tagged\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"videos-liked\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"videos-uploaded\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"videos\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":2,\"allowsFreeText\":false},\"videos-commented\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"video-links-shared\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"videos-interested\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"videos-interacted\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"videos-about\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"videos-reshared\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"app-users\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"apps\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"apps-used\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"apps-liked\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"apps-named\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":true},\"games\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"platform\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"stories\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":2,\"allowsFreeText\":false},\"stories-by\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"reshare-stories-by\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"stories-commented\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"stories-liked\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"stories-keyword\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":true},\"stories-topic\":{\"numParamsUnbounded\":false,\"minNumParams\":0,\"maxNumParams\":1,\"allowsFreeText\":false},\"stories-at\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"stories-in\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"stories-tagged\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"stories-media-tagged\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"stories-share-link\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":true},\"message\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"keywords\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":true},\"facebook-employees\":{\"numParamsUnbounded\":false,\"minNumParams\":0,\"maxNumParams\":0,\"allowsFreeText\":false}},\"semantic_map\":[],\"grammar_stop_words\":{\"and\":\"and\",\"at\":\"at\",\"by\":\"by\",\"for\":\"for\",\"friends\":\"friends\",\"from\":\"from\",\"i\":\"i\",\"in\":\"in\",\"me\":\"me\",\"of\":\"of\",\"on\":\"on\",\"people\":\"people\",\"photos\":\"photos\",\"the\":\"the\",\"to\":\"to\"},\"grammar_stop_words_penalty\":2,\"name_functions\":[\"apps-named\",\"communities-named\",\"groups-named\",\"pages-named\",\"places-named\",\"users-named\"],\"search_path\":\"\\/search\\/\",\"non_title_term_match_penalty\":0.5,\"\\u0040generated\":true},\"bootloadable\":{},\"ixData\":[]}";
// 11958
o102._unshieldResponseText = f81632121_1336;
// 11959
f81632121_1336.returns.push("{\"__ar\":1,\"payload\":{\"entity_cost\":0.5,\"blank_cost\":0.5,\"typeahead_types\":[\"user\",\"user-dynamic\",\"place\",\"place-category\",\"page\",\"page-category\",\"app\",\"group\",\"event\",\"friendlist\",\"list\",\"music\",\"shortcut\",\"websuggestion\",\"facebar_query\",\"product\",\"og-book\",\"og-movie\",\"og-tv_show\",\"hashtag_exact\",\"activity\",\"activity-actors\",\"activity-verb\",\"activity-verb-present-singular\",\"job-title\",\"job-title-activity\",\"job-title-workers\",\"political-view-adjective\",\"political-view-members\",\"political-view-party\",\"religion\",\"religion-adjective\",\"religion-alt\",\"religion-members\"],\"mapped_types\":{\"gameapp\":\"app\"},\"mapped_types_subquery\":{\"place\":\"page\"},\"bootstrap_types\":[\"user\",\"page\",\"group\",\"app\",\"event\",\"friendlist\",\"shortcut\"],\"browse_functions\":{\"intersect\":{\"numParamsUnbounded\":true,\"minNumParams\":1,\"maxNumParams\":100,\"allowsFreeText\":false},\"union\":{\"numParamsUnbounded\":true,\"minNumParams\":1,\"maxNumParams\":100,\"allowsFreeText\":false},\"fbids\":{\"numParamsUnbounded\":true,\"minNumParams\":1,\"maxNumParams\":100,\"allowsFreeText\":false},\"all\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"pages\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"users\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"present\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"past\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"future\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"ever\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"ever-past\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"class\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"date\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":2,\"allowsFreeText\":false},\"after\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":2,\"allowsFreeText\":false},\"before\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":2,\"allowsFreeText\":false},\"duration-past\":{\"numParamsUnbounded\":false,\"minNumParams\":2,\"maxNumParams\":2,\"allowsFreeText\":false},\"duration-future\":{\"numParamsUnbounded\":false,\"minNumParams\":2,\"maxNumParams\":2,\"allowsFreeText\":false},\"users-age\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":2,\"allowsFreeText\":false},\"users-younger\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":2,\"allowsFreeText\":false},\"users-older\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":2,\"allowsFreeText\":false},\"users-born\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":2,\"allowsFreeText\":false},\"users-interested\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"users-named\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":true},\"users-birth-place\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":2,\"allowsFreeText\":false},\"females\":{\"numParamsUnbounded\":false,\"minNumParams\":0,\"maxNumParams\":0,\"allowsFreeText\":false},\"males\":{\"numParamsUnbounded\":false,\"minNumParams\":0,\"maxNumParams\":0,\"allowsFreeText\":false},\"members\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"friends\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"online-friends\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"non-friends\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"acquaintances\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"close-friends\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"restricted-friends\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"followers\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"users-followed\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"creators\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"admins\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"groups\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"non-groups\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"groups-privacy\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"groups-named\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":true},\"groups-about\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"communities\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"communities-named\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":true},\"relatives\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"siblings\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"brothers\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"sisters\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"parents\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"fathers\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"mothers\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"children\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"sons\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"daughters\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"aunts\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"uncles\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"nieces\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"nephews\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"cousins\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"grandchildren\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"grandsons\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"granddaughters\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"grandparents\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"grandmothers\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"grandfathers\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"stepsiblings\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"stepsisters\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"stepbrothers\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"stepparents\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"stepfathers\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"stepmothers\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"stepchildren\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"stepdaughters\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"stepsons\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"sisters-in-law\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"brothers-in-law\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"fathers-in-law\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"mothers-in-law\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"sons-in-law\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"daughters-in-law\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"partners\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"boyfriends\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"girlfriends\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"users-any-relationship\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"users-dating\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"users-relationship\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"users-open-relationship\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"spouses\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"fiances\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"users-its-complicated\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"users-civil-union\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"domestic-partners\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"wives\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"husbands\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"students\":{\"numParamsUnbounded\":false,\"minNumParams\":0,\"maxNumParams\":7,\"allowsFreeText\":false},\"employees\":{\"numParamsUnbounded\":false,\"minNumParams\":0,\"maxNumParams\":5,\"allowsFreeText\":false},\"major\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"degree\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"job\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"schools-attended\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":4,\"allowsFreeText\":false},\"school-location\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"high-schools-attended\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":4,\"allowsFreeText\":false},\"colleges-attended\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":4,\"allowsFreeText\":false},\"grad-schools-attended\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":4,\"allowsFreeText\":false},\"employer-location\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"employers\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":3,\"allowsFreeText\":false},\"residents-near\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":4,\"allowsFreeText\":false},\"home-residents\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":2,\"allowsFreeText\":false},\"hometowns\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"residents\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":2,\"allowsFreeText\":false},\"current-cities\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"current-regions\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"current-countries\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"users-of-nationalities\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"nationalities\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"speakers\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"languages\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"likers\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"exact-page-likers\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"job-liker-union\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"listeners\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"readers\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"watchers\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"page_raters\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"commenters\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"users-religious-view\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"users-political-view\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"admirers\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"religious-views\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"political-views\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"visitors\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"users-checked-in\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"places-checked-in\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"places-visited\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"pages-in\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"places\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"places-in\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"places-near\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":4,\"allowsFreeText\":false},\"places-liked\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"places-named\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":true},\"pages-named\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":true},\"pages-about\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"pages-recommended-by\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"pages-liked\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"pages-recommended-for\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"pages-similar-to\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"photos-recommended-for\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"photos-of\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"photos-in\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"photos-by\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"photos-tagged\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"photos-liked\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"photos-uploaded\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"photos\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":2,\"allowsFreeText\":false},\"photos-commented\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"photos-interested\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"photos-interacted\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"photos-about\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"photos-reshared\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"timeline\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"photos-tagged-or-uploaded\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"users-tagged\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"users-interacted\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"videos-of\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"videos-in\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"videos-by\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"videos-tagged\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"videos-liked\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"videos-uploaded\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"videos\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":2,\"allowsFreeText\":false},\"videos-commented\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"video-links-shared\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"videos-interested\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"videos-interacted\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"videos-about\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"videos-reshared\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"app-users\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"apps\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"apps-used\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"apps-liked\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"apps-named\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":true},\"games\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"platform\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"stories\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":2,\"allowsFreeText\":false},\"stories-by\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"reshare-stories-by\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"stories-commented\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"stories-liked\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"stories-keyword\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":true},\"stories-topic\":{\"numParamsUnbounded\":false,\"minNumParams\":0,\"maxNumParams\":1,\"allowsFreeText\":false},\"stories-at\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"stories-in\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"stories-tagged\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"stories-media-tagged\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"stories-share-link\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":true},\"message\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":false},\"keywords\":{\"numParamsUnbounded\":false,\"minNumParams\":1,\"maxNumParams\":1,\"allowsFreeText\":true},\"facebook-employees\":{\"numParamsUnbounded\":false,\"minNumParams\":0,\"maxNumParams\":0,\"allowsFreeText\":false}},\"semantic_map\":[],\"grammar_stop_words\":{\"and\":\"and\",\"at\":\"at\",\"by\":\"by\",\"for\":\"for\",\"friends\":\"friends\",\"from\":\"from\",\"i\":\"i\",\"in\":\"in\",\"me\":\"me\",\"of\":\"of\",\"on\":\"on\",\"people\":\"people\",\"photos\":\"photos\",\"the\":\"the\",\"to\":\"to\"},\"grammar_stop_words_penalty\":2,\"name_functions\":[\"apps-named\",\"communities-named\",\"groups-named\",\"pages-named\",\"places-named\",\"users-named\"],\"search_path\":\"\\/search\\/\",\"non_title_term_match_penalty\":0.5,\"\\u0040generated\":true},\"bootloadable\":{},\"ixData\":[]}");
// 11960
o102._interpretResponse = f81632121_1337;
// 11961
f81632121_1337.returns.push({__JSBNG_unknown_object:true});
// 11962
o102.invokeResponseHandler = f81632121_1338;
// 11963
f81632121_1669 = function() { return f81632121_1669.returns[f81632121_1669.inst++]; };
f81632121_1669.returns = [];
f81632121_1669.inst = 0;
// 11964
o102.handler = f81632121_1669;
// 11965
o102._isRelevant = f81632121_1340;
// 11966
o102._allowCrossPageTransition = true;
// 11967
f81632121_1340.returns.push(true);
// 11968
o102._dispatchResponse = f81632121_1341;
// 11969
o102.getURI = f81632121_1342;
// 11970
o156 = {};
// 11971
o102.uri = o156;
// 11973
o156.$URIBase0 = "";
// 11974
o156.$URIBase1 = "";
// 11975
o156.$URIBase2 = "";
// 11976
o156.$URIBase3 = "/ajax/typeahead/search/facebar/config.php";
// 11978
o157 = {};
// 11979
o156.$URIBase5 = o157;
// 11981
f81632121_1662.returns.push(true);
// 11982
o157.__a = 1;
// 11985
f81632121_1662.returns.push(true);
// 11986
o157.__dyn = "7n8ahyj2qmvudDgDxqjEHznBw";
// 11989
f81632121_1662.returns.push(true);
// 11990
o157.__req = "2";
// 11993
f81632121_1662.returns.push(true);
// 11994
o157.__user = "100006118350059";
// 11997
f81632121_1662.returns.push(true);
// 11998
o157.version = "9ab0d482a92fc9cfa37e6c174e4543ea4a022340";
// 12000
o156.$URIBase4 = "";
// 12001
f81632121_1344.returns.push("/ajax/typeahead/search/facebar/config.php?__a=1&__dyn=7n8ahyj2qmvudDgDxqjEHznBw&__req=2&__user=100006118350059&version=9ab0d482a92fc9cfa37e6c174e4543ea4a022340");
// 12002
f81632121_1342.returns.push("/ajax/typeahead/search/facebar/config.php?__a=1&__dyn=7n8ahyj2qmvudDgDxqjEHznBw&__req=2&__user=100006118350059&version=9ab0d482a92fc9cfa37e6c174e4543ea4a022340");
// 12003
o102.preBootloadHandler = void 0;
// 12014
f81632121_1662.returns.push(true);
// 12018
f81632121_1662.returns.push(true);
// 12022
f81632121_1662.returns.push(true);
// 12026
f81632121_1662.returns.push(true);
// 12030
f81632121_1662.returns.push(true);
// 12034
f81632121_1344.returns.push("/ajax/typeahead/search/facebar/config.php?__a=1&__dyn=7n8ahyj2qmvudDgDxqjEHznBw&__req=2&__user=100006118350059&version=9ab0d482a92fc9cfa37e6c174e4543ea4a022340");
// 12035
f81632121_1342.returns.push("/ajax/typeahead/search/facebar/config.php?__a=1&__dyn=7n8ahyj2qmvudDgDxqjEHznBw&__req=2&__user=100006118350059&version=9ab0d482a92fc9cfa37e6c174e4543ea4a022340");
// 12037
f81632121_12.returns.push(47);
// 12041
o158 = {};
// 12042
f81632121_474.returns.push(o158);
// 12044
f81632121_478.returns.push(o158);
// undefined
o158 = null;
// 12045
f81632121_1338.returns.push(undefined);
// 12046
f81632121_1333.returns.push(undefined);
// 12049
o155.asynchronous = true;
// undefined
o155 = null;
// 12052
f81632121_1334.returns.push(true);
// 12053
// 12055
o136.clearStatusIndicator = f81632121_1347;
// 12056
o136.getStatusElement = f81632121_1348;
// 12057
o136.statusElement = null;
// 12058
f81632121_1348.returns.push(null);
// 12059
f81632121_1347.returns.push(undefined);
// 12062
f81632121_1340.returns.push(true);
// 12063
o136.initialHandler = f81632121_1349;
// 12064
f81632121_1349.returns.push(undefined);
// 12065
o136.timer = null;
// 12066
f81632121_14.returns.push(undefined);
// 12068
o136._shouldSuppressJS = f81632121_1350;
// 12070
f81632121_1659.returns.push(undefined);
// 12071
f81632121_1350.returns.push(false);
// 12072
o136._handleJSResponse = f81632121_1351;
// 12073
o136.getRelativeTo = f81632121_1352;
// 12074
o136.relativeTo = null;
// 12075
f81632121_1352.returns.push(null);
// 12076
o136._handleJSRegisters = f81632121_1353;
// 12077
f81632121_1353.returns.push(undefined);
// 12078
o136.lid = void 0;
// 12080
f81632121_1353.returns.push(undefined);
// 12081
f81632121_1351.returns.push(undefined);
// 12082
f81632121_1673 = function() { return f81632121_1673.returns[f81632121_1673.inst++]; };
f81632121_1673.returns = [];
f81632121_1673.inst = 0;
// 12083
o136.finallyHandler = f81632121_1673;
// 12084
f81632121_1673.returns.push(undefined);
// 12085
f81632121_1341.returns.push(undefined);
// 12087
o102.clearStatusIndicator = f81632121_1347;
// 12088
o102.getStatusElement = f81632121_1348;
// 12089
o102.statusElement = null;
// 12090
f81632121_1348.returns.push(null);
// 12091
f81632121_1347.returns.push(undefined);
// 12094
f81632121_1340.returns.push(true);
// 12095
o102.initialHandler = f81632121_1349;
// 12096
f81632121_1349.returns.push(undefined);
// 12097
o102.timer = null;
// 12098
f81632121_14.returns.push(undefined);
// 12100
o102._shouldSuppressJS = f81632121_1350;
// 12102
f81632121_1669.returns.push(undefined);
// 12103
f81632121_1350.returns.push(false);
// 12104
o102._handleJSResponse = f81632121_1351;
// 12105
o102.getRelativeTo = f81632121_1352;
// 12106
o102.relativeTo = null;
// 12107
f81632121_1352.returns.push(null);
// 12108
o102._handleJSRegisters = f81632121_1353;
// 12109
f81632121_1353.returns.push(undefined);
// 12110
o102.lid = void 0;
// 12112
f81632121_1353.returns.push(undefined);
// 12113
f81632121_1351.returns.push(undefined);
// 12114
f81632121_1674 = function() { return f81632121_1674.returns[f81632121_1674.inst++]; };
f81632121_1674.returns = [];
f81632121_1674.inst = 0;
// 12115
o102.finallyHandler = f81632121_1674;
// 12116
f81632121_1674.returns.push(undefined);
// 12117
f81632121_1341.returns.push(undefined);
// 12125
o155 = {};
// 12126
o158 = {};
// 12128
o155.nodeType = void 0;
// 12129
o155.length = 1;
// 12130
o155["0"] = "ywV7J";
// 12135
o159 = {};
// 12136
o160 = {};
// 12138
o159.nodeType = void 0;
// 12139
o159.length = 1;
// 12140
o159["0"] = "gyG67";
// 12152
o161 = {};
// 12153
f81632121_508.returns.push(o161);
// 12154
o161.id = "u_0_3p";
// 12155
o161.getElementsByTagName = f81632121_502;
// 12157
o161.querySelectorAll = f81632121_504;
// undefined
o161 = null;
// 12158
o161 = {};
// 12159
f81632121_504.returns.push(o161);
// 12160
o161.length = 1;
// 12161
o162 = {};
// 12162
o161["0"] = o162;
// undefined
o161 = null;
// 12166
o161 = {};
// 12167
f81632121_504.returns.push(o161);
// 12168
o161.length = 0;
// undefined
o161 = null;
// 12172
o161 = {};
// 12173
f81632121_504.returns.push(o161);
// 12174
o161.length = 1;
// 12175
o163 = {};
// 12176
o161["0"] = o163;
// undefined
o161 = null;
// undefined
o163 = null;
// 12180
o161 = {};
// 12181
f81632121_504.returns.push(o161);
// 12182
o161.length = 0;
// undefined
o161 = null;
// 12186
o161 = {};
// 12187
f81632121_504.returns.push(o161);
// 12188
o161.length = 0;
// undefined
o161 = null;
// 12189
o162.nodeName = "LABEL";
// 12190
o162.getElementsByTagName = f81632121_502;
// undefined
o162 = null;
// 12191
o161 = {};
// 12192
f81632121_502.returns.push(o161);
// 12193
o161.length = 1;
// 12194
o162 = {};
// 12195
o161["0"] = o162;
// undefined
o161 = null;
// 12196
o162.__FB_TOKEN = void 0;
// 12197
// 12198
o162.getAttribute = f81632121_506;
// 12199
o162.hasAttribute = f81632121_507;
// 12201
f81632121_507.returns.push(false);
// 12202
o162.JSBNG__addEventListener = f81632121_468;
// 12204
f81632121_468.returns.push(undefined);
// 12205
o162.JSBNG__onclick = null;
// 12206
o162.nodeName = "INPUT";
// undefined
o162 = null;
// 12209
o161 = {};
// 12210
f81632121_508.returns.push(o161);
// 12211
o161.id = "u_0_s";
// 12212
o161.getElementsByTagName = f81632121_502;
// 12214
o161.querySelectorAll = f81632121_504;
// undefined
o161 = null;
// 12215
o161 = {};
// 12216
f81632121_504.returns.push(o161);
// 12217
o161.length = 1;
// 12218
o162 = {};
// 12219
o161["0"] = o162;
// undefined
o161 = null;
// 12223
o161 = {};
// 12224
f81632121_504.returns.push(o161);
// 12225
o161.length = 1;
// 12226
o163 = {};
// 12227
o161["0"] = o163;
// undefined
o161 = null;
// undefined
o163 = null;
// 12231
o161 = {};
// 12232
f81632121_504.returns.push(o161);
// 12233
o161.length = 1;
// 12234
o163 = {};
// 12235
o161["0"] = o163;
// undefined
o161 = null;
// undefined
o163 = null;
// 12239
o161 = {};
// 12240
f81632121_504.returns.push(o161);
// 12241
o161.length = 0;
// undefined
o161 = null;
// 12245
o161 = {};
// 12246
f81632121_504.returns.push(o161);
// 12247
o161.length = 0;
// undefined
o161 = null;
// 12248
o162.nodeName = "A";
// 12249
o162.__FB_TOKEN = void 0;
// 12250
// 12251
o162.getAttribute = f81632121_506;
// 12252
o162.hasAttribute = f81632121_507;
// 12254
f81632121_507.returns.push(false);
// 12255
o162.JSBNG__addEventListener = f81632121_468;
// 12257
f81632121_468.returns.push(undefined);
// 12258
o162.JSBNG__onclick = null;
// undefined
o162 = null;
// 12262
o161 = {};
// 12263
f81632121_508.returns.push(o161);
// 12264
o161.id = "u_0_q";
// 12265
o161.getElementsByTagName = f81632121_502;
// 12267
o161.querySelectorAll = f81632121_504;
// undefined
o161 = null;
// 12268
o161 = {};
// 12269
f81632121_504.returns.push(o161);
// 12270
o161.length = 1;
// 12271
o162 = {};
// 12272
o161["0"] = o162;
// undefined
o161 = null;
// 12276
o161 = {};
// 12277
f81632121_504.returns.push(o161);
// 12278
o161.length = 0;
// undefined
o161 = null;
// 12282
o161 = {};
// 12283
f81632121_504.returns.push(o161);
// 12284
o161.length = 1;
// 12285
o163 = {};
// 12286
o161["0"] = o163;
// undefined
o161 = null;
// undefined
o163 = null;
// 12290
o161 = {};
// 12291
f81632121_504.returns.push(o161);
// 12292
o161.length = 0;
// undefined
o161 = null;
// 12296
o161 = {};
// 12297
f81632121_504.returns.push(o161);
// 12298
o161.length = 0;
// undefined
o161 = null;
// 12299
o162.nodeName = "LABEL";
// 12300
o162.getElementsByTagName = f81632121_502;
// undefined
o162 = null;
// 12301
o161 = {};
// 12302
f81632121_502.returns.push(o161);
// 12303
o161.length = 1;
// 12304
o162 = {};
// 12305
o161["0"] = o162;
// undefined
o161 = null;
// 12306
o162.__FB_TOKEN = void 0;
// 12307
// 12308
o162.getAttribute = f81632121_506;
// 12309
o162.hasAttribute = f81632121_507;
// 12311
f81632121_507.returns.push(false);
// 12312
o162.JSBNG__addEventListener = f81632121_468;
// 12314
f81632121_468.returns.push(undefined);
// 12315
o162.JSBNG__onclick = null;
// 12316
o162.nodeName = "INPUT";
// undefined
o162 = null;
// 12319
o161 = {};
// 12320
f81632121_508.returns.push(o161);
// 12321
o161.id = "u_0_16";
// 12322
o161.getElementsByTagName = f81632121_502;
// 12324
o161.querySelectorAll = f81632121_504;
// undefined
o161 = null;
// 12325
o161 = {};
// 12326
f81632121_504.returns.push(o161);
// 12327
o161.length = 1;
// 12328
o162 = {};
// 12329
o161["0"] = o162;
// undefined
o161 = null;
// 12333
o161 = {};
// 12334
f81632121_504.returns.push(o161);
// 12335
o161.length = 0;
// undefined
o161 = null;
// 12339
o161 = {};
// 12340
f81632121_504.returns.push(o161);
// 12341
o161.length = 1;
// 12342
o163 = {};
// 12343
o161["0"] = o163;
// undefined
o161 = null;
// undefined
o163 = null;
// 12347
o161 = {};
// 12348
f81632121_504.returns.push(o161);
// 12349
o161.length = 0;
// undefined
o161 = null;
// 12353
o161 = {};
// 12354
f81632121_504.returns.push(o161);
// 12355
o161.length = 0;
// undefined
o161 = null;
// 12356
o162.nodeName = "LABEL";
// 12357
o162.getElementsByTagName = f81632121_502;
// undefined
o162 = null;
// 12358
o161 = {};
// 12359
f81632121_502.returns.push(o161);
// 12360
o161.length = 1;
// 12361
o162 = {};
// 12362
o161["0"] = o162;
// undefined
o161 = null;
// 12363
o162.__FB_TOKEN = void 0;
// 12364
// 12365
o162.getAttribute = f81632121_506;
// 12366
o162.hasAttribute = f81632121_507;
// 12368
f81632121_507.returns.push(false);
// 12369
o162.JSBNG__addEventListener = f81632121_468;
// 12371
f81632121_468.returns.push(undefined);
// 12372
o162.JSBNG__onclick = null;
// 12373
o162.nodeName = "INPUT";
// undefined
o162 = null;
// 12376
o161 = {};
// 12377
o162 = {};
// 12379
o161.nodeType = void 0;
// 12380
o161.length = 1;
// 12381
o161["0"] = "cstCX";
// 12384
f81632121_467.returns.push(1374851233369);
// 12387
f81632121_467.returns.push(1374851233369);
// 12389
f81632121_467.returns.push(1374851233369);
// 12396
o163 = {};
// 12397
f81632121_508.returns.push(o163);
// 12399
o164 = {};
// 12400
f81632121_508.returns.push(o164);
// 12401
o163.nodeName = "A";
// 12402
o163.__FB_TOKEN = void 0;
// 12403
// 12404
o163.getAttribute = f81632121_506;
// 12405
o163.hasAttribute = f81632121_507;
// 12407
f81632121_507.returns.push(false);
// 12408
o163.JSBNG__addEventListener = f81632121_468;
// 12410
f81632121_468.returns.push(undefined);
// 12411
o163.JSBNG__onclick = null;
// undefined
o163 = null;
// 12415
o163 = {};
// 12416
f81632121_508.returns.push(o163);
// 12418
o165 = {};
// 12419
f81632121_508.returns.push(o165);
// 12420
o163.nodeName = "A";
// 12421
o163.__FB_TOKEN = void 0;
// 12422
// 12423
o163.getAttribute = f81632121_506;
// 12424
o163.hasAttribute = f81632121_507;
// 12426
f81632121_507.returns.push(false);
// 12427
o163.JSBNG__addEventListener = f81632121_468;
// 12429
f81632121_468.returns.push(undefined);
// 12430
o163.JSBNG__onclick = null;
// undefined
o163 = null;
// 12434
o163 = {};
// 12435
o166 = {};
// 12437
o163.nodeType = void 0;
// 12438
o163.length = 1;
// 12439
o163["0"] = "dShSX";
// 12441
o167 = {};
// 12445
f81632121_467.returns.push(1374851233411);
// 12446
o167.cancelBubble = false;
// 12447
o167.returnValue = true;
// 12450
o167.srcElement = o109;
// 12452
o167.target = o109;
// 12459
f81632121_506.returns.push(null);
// 12465
f81632121_506.returns.push(null);
// 12471
f81632121_506.returns.push(null);
// 12477
f81632121_506.returns.push(null);
// 12483
f81632121_506.returns.push(null);
// 12489
f81632121_506.returns.push(null);
// 12495
f81632121_506.returns.push(null);
// 12501
f81632121_506.returns.push(null);
// 12506
o167.JSBNG__screenX = 970;
// 12507
o167.JSBNG__screenY = 511;
// 12508
o167.altKey = false;
// 12509
o167.bubbles = true;
// 12510
o167.button = 0;
// 12511
o167.buttons = void 0;
// 12512
o167.cancelable = false;
// 12513
o167.clientX = 902;
// 12514
o167.clientY = 346;
// 12515
o167.ctrlKey = false;
// 12516
o167.currentTarget = o0;
// 12517
o167.defaultPrevented = false;
// 12518
o167.detail = 0;
// 12519
o167.eventPhase = 3;
// 12520
o167.isTrusted = void 0;
// 12521
o167.metaKey = false;
// 12522
o167.pageX = 902;
// 12523
o167.pageY = 1246;
// 12524
o167.relatedTarget = null;
// 12525
o167.fromElement = null;
// 12528
o167.shiftKey = false;
// 12531
o167.timeStamp = 1374851233411;
// 12532
o167.type = "mousemove";
// 12533
o167.view = ow81632121;
// undefined
o167 = null;
// 12540
o167 = {};
// 12544
o168 = {};
// 12548
o169 = {};
// 12553
o69.getResponseHeader = f81632121_1332;
// 12556
f81632121_1332.returns.push("MWO0jcc/KbRy36gYE1NrzU/t7jbO9DT0nr3es5+tsT8=");
// 12559
f81632121_1332.returns.push("MWO0jcc/KbRy36gYE1NrzU/t7jbO9DT0nr3es5+tsT8=");
// 12560
// 12562
o69.JSBNG__status = 200;
// 12566
f81632121_467.returns.push(1374851233426);
// 12567
o142._handleXHRResponse = f81632121_1333;
// 12569
o142.getOption = f81632121_1334;
// 12570
o170 = {};
// 12571
o142.option = o170;
// 12572
o170.suppressEvaluation = false;
// 12575
f81632121_1334.returns.push(false);
// 12576
o69.responseText = "for (;;);{\"__ar\":1,\"payload\":{\"entries\":[],\"token\":\"1374777501-7\",\"stale\":1},\"bootloadable\":{},\"ixData\":[]}";
// 12577
o142._unshieldResponseText = f81632121_1336;
// 12578
f81632121_1336.returns.push("{\"__ar\":1,\"payload\":{\"entries\":[],\"token\":\"1374777501-7\",\"stale\":1},\"bootloadable\":{},\"ixData\":[]}");
// 12579
o142._interpretResponse = f81632121_1337;
// 12580
f81632121_1337.returns.push({__JSBNG_unknown_object:true});
// 12581
o142.invokeResponseHandler = f81632121_1338;
// 12582
f81632121_1731 = function() { return f81632121_1731.returns[f81632121_1731.inst++]; };
f81632121_1731.returns = [];
f81632121_1731.inst = 0;
// 12583
o142.handler = f81632121_1731;
// 12584
o142._isRelevant = f81632121_1340;
// 12585
o142._allowCrossPageTransition = false;
// 12586
o142.id = 7;
// 12588
f81632121_1340.returns.push(true);
// 12589
o142._dispatchResponse = f81632121_1341;
// 12590
o142.getURI = f81632121_1342;
// 12591
o171 = {};
// 12592
o142.uri = o171;
// 12594
o171.$URIBase0 = "";
// 12595
o171.$URIBase1 = "";
// 12596
o171.$URIBase2 = "";
// 12597
o171.$URIBase3 = "/ajax/typeahead/search/facebar/bootstrap/";
// 12599
o172 = {};
// 12600
o171.$URIBase5 = o172;
// 12602
f81632121_1662.returns.push(true);
// 12603
o172.__a = 1;
// 12606
f81632121_1662.returns.push(true);
// 12607
o172.__dyn = "7n8ahyj2qmvudDgDxqjEHznBw";
// 12610
f81632121_1662.returns.push(true);
// 12611
o172.__req = "5";
// 12614
f81632121_1662.returns.push(true);
// 12615
o172.__user = "100006118350059";
// 12618
f81632121_1662.returns.push(true);
// 12619
o172.context = "facebar";
// 12622
f81632121_1662.returns.push(true);
// 12623
o173 = {};
// 12624
o172.filter = o173;
// 12627
f81632121_1662.returns.push(true);
// 12628
o173["0"] = "user";
// 12631
f81632121_1662.returns.push(true);
// 12632
o172.lazy = 1;
// 12635
f81632121_1662.returns.push(true);
// 12636
o172.token = "v7";
// 12639
f81632121_1662.returns.push(true);
// 12640
o172.viewer = 100006118350059;
// 12642
o171.$URIBase4 = "";
// 12643
f81632121_1344.returns.push("/ajax/typeahead/search/facebar/bootstrap/?__a=1&__dyn=7n8ahyj2qmvudDgDxqjEHznBw&__req=5&__user=100006118350059&context=facebar&filter[0]=user&lazy=1&token=v7&viewer=100006118350059");
// 12644
f81632121_1342.returns.push("/ajax/typeahead/search/facebar/bootstrap/?__a=1&__dyn=7n8ahyj2qmvudDgDxqjEHznBw&__req=5&__user=100006118350059&context=facebar&filter[0]=user&lazy=1&token=v7&viewer=100006118350059");
// 12645
o142.preBootloadHandler = void 0;
// 12656
f81632121_1662.returns.push(true);
// 12660
f81632121_1662.returns.push(true);
// 12664
f81632121_1662.returns.push(true);
// 12668
f81632121_1662.returns.push(true);
// 12672
f81632121_1662.returns.push(true);
// 12676
f81632121_1662.returns.push(true);
// 12680
f81632121_1662.returns.push(true);
// 12684
f81632121_1662.returns.push(true);
// 12688
f81632121_1662.returns.push(true);
// 12692
f81632121_1662.returns.push(true);
// 12696
f81632121_1344.returns.push("/ajax/typeahead/search/facebar/bootstrap/?__a=1&__dyn=7n8ahyj2qmvudDgDxqjEHznBw&__req=5&__user=100006118350059&context=facebar&filter[0]=user&lazy=1&token=v7&viewer=100006118350059");
// 12697
f81632121_1342.returns.push("/ajax/typeahead/search/facebar/bootstrap/?__a=1&__dyn=7n8ahyj2qmvudDgDxqjEHznBw&__req=5&__user=100006118350059&context=facebar&filter[0]=user&lazy=1&token=v7&viewer=100006118350059");
// 12699
f81632121_12.returns.push(48);
// 12703
o174 = {};
// 12704
f81632121_474.returns.push(o174);
// 12706
f81632121_478.returns.push(o174);
// undefined
o174 = null;
// 12707
f81632121_1338.returns.push(undefined);
// 12708
f81632121_1333.returns.push(undefined);
// 12711
o170.asynchronous = true;
// undefined
o170 = null;
// 12714
f81632121_1334.returns.push(true);
// 12715
// 12716
o170 = {};
// 12720
o174 = {};
// 12724
o175 = {};
// 12729
o22.getResponseHeader = f81632121_1332;
// 12732
f81632121_1332.returns.push("KND7vYBCvkWnoN9yheVsXzudEn3zwTmvcSkMHsDLj1w=");
// 12735
f81632121_1332.returns.push("KND7vYBCvkWnoN9yheVsXzudEn3zwTmvcSkMHsDLj1w=");
// 12736
// 12738
o22.JSBNG__status = 200;
// 12742
f81632121_467.returns.push(1374851233444);
// 12743
o140._handleXHRResponse = f81632121_1333;
// 12745
o140.getOption = f81632121_1334;
// 12746
o176 = {};
// 12747
o140.option = o176;
// 12748
o176.suppressEvaluation = false;
// 12751
f81632121_1334.returns.push(false);
// 12752
o22.responseText = "for (;;);{\"__ar\":1,\"payload\":{\"entries\":[],\"token\":\"1374777501-7\",\"stale\":1},\"bootloadable\":{},\"ixData\":[]}";
// 12753
o140._unshieldResponseText = f81632121_1336;
// 12754
f81632121_1336.returns.push("{\"__ar\":1,\"payload\":{\"entries\":[],\"token\":\"1374777501-7\",\"stale\":1},\"bootloadable\":{},\"ixData\":[]}");
// 12755
o140._interpretResponse = f81632121_1337;
// 12756
f81632121_1337.returns.push({__JSBNG_unknown_object:true});
// 12757
o140.invokeResponseHandler = f81632121_1338;
// 12758
f81632121_1740 = function() { return f81632121_1740.returns[f81632121_1740.inst++]; };
f81632121_1740.returns = [];
f81632121_1740.inst = 0;
// 12759
o140.handler = f81632121_1740;
// 12760
o140._isRelevant = f81632121_1340;
// 12761
o140._allowCrossPageTransition = false;
// 12762
o140.id = 6;
// 12764
f81632121_1340.returns.push(true);
// 12765
o140._dispatchResponse = f81632121_1341;
// 12766
o140.getURI = f81632121_1342;
// 12767
o177 = {};
// 12768
o140.uri = o177;
// 12770
o177.$URIBase0 = "";
// 12771
o177.$URIBase1 = "";
// 12772
o177.$URIBase2 = "";
// 12773
o177.$URIBase3 = "/ajax/typeahead/search/facebar/bootstrap/";
// 12775
o178 = {};
// 12776
o177.$URIBase5 = o178;
// 12778
f81632121_1662.returns.push(true);
// 12779
o178.__a = 1;
// 12782
f81632121_1662.returns.push(true);
// 12783
o178.__dyn = "7n8ahyj2qmvudDgDxqjEHznBw";
// 12786
f81632121_1662.returns.push(true);
// 12787
o178.__req = "4";
// 12790
f81632121_1662.returns.push(true);
// 12791
o178.__user = "100006118350059";
// 12794
f81632121_1662.returns.push(true);
// 12795
o178.context = "facebar";
// 12798
f81632121_1662.returns.push(true);
// 12799
o179 = {};
// 12800
o178.filter = o179;
// 12803
f81632121_1662.returns.push(true);
// 12804
o179["0"] = "app";
// 12807
f81632121_1662.returns.push(true);
// 12808
o179["1"] = "page";
// 12811
f81632121_1662.returns.push(true);
// 12812
o179["2"] = "group";
// 12815
f81632121_1662.returns.push(true);
// 12816
o179["3"] = "friendlist";
// 12819
f81632121_1662.returns.push(true);
// 12820
o178.lazy = 1;
// 12823
f81632121_1662.returns.push(true);
// 12824
o178.token = "v7";
// 12827
f81632121_1662.returns.push(true);
// 12828
o178.viewer = 100006118350059;
// 12830
o177.$URIBase4 = "";
// 12831
f81632121_1344.returns.push("/ajax/typeahead/search/facebar/bootstrap/?__a=1&__dyn=7n8ahyj2qmvudDgDxqjEHznBw&__req=4&__user=100006118350059&context=facebar&filter[0]=app&filter[1]=page&filter[2]=group&filter[3]=friendlist&lazy=1&token=v7&viewer=100006118350059");
// 12832
f81632121_1342.returns.push("/ajax/typeahead/search/facebar/bootstrap/?__a=1&__dyn=7n8ahyj2qmvudDgDxqjEHznBw&__req=4&__user=100006118350059&context=facebar&filter[0]=app&filter[1]=page&filter[2]=group&filter[3]=friendlist&lazy=1&token=v7&viewer=100006118350059");
// 12833
o140.preBootloadHandler = void 0;
// 12844
f81632121_1662.returns.push(true);
// 12848
f81632121_1662.returns.push(true);
// 12852
f81632121_1662.returns.push(true);
// 12856
f81632121_1662.returns.push(true);
// 12860
f81632121_1662.returns.push(true);
// 12864
f81632121_1662.returns.push(true);
// 12868
f81632121_1662.returns.push(true);
// 12872
f81632121_1662.returns.push(true);
// 12876
f81632121_1662.returns.push(true);
// 12880
f81632121_1662.returns.push(true);
// 12884
f81632121_1662.returns.push(true);
// 12888
f81632121_1662.returns.push(true);
// 12892
f81632121_1662.returns.push(true);
// 12896
f81632121_1344.returns.push("/ajax/typeahead/search/facebar/bootstrap/?__a=1&__dyn=7n8ahyj2qmvudDgDxqjEHznBw&__req=4&__user=100006118350059&context=facebar&filter[0]=app&filter[1]=page&filter[2]=group&filter[3]=friendlist&lazy=1&token=v7&viewer=100006118350059");
// 12897
f81632121_1342.returns.push("/ajax/typeahead/search/facebar/bootstrap/?__a=1&__dyn=7n8ahyj2qmvudDgDxqjEHznBw&__req=4&__user=100006118350059&context=facebar&filter[0]=app&filter[1]=page&filter[2]=group&filter[3]=friendlist&lazy=1&token=v7&viewer=100006118350059");
// 12899
f81632121_12.returns.push(49);
// 12903
o180 = {};
// 12904
f81632121_474.returns.push(o180);
// 12906
f81632121_478.returns.push(o180);
// undefined
o180 = null;
// 12907
f81632121_1338.returns.push(undefined);
// 12908
f81632121_1333.returns.push(undefined);
// 12911
o176.asynchronous = true;
// undefined
o176 = null;
// 12914
f81632121_1334.returns.push(true);
// 12915
// 12917
o142.clearStatusIndicator = f81632121_1347;
// 12918
o142.getStatusElement = f81632121_1348;
// 12919
o142.statusElement = null;
// 12920
f81632121_1348.returns.push(null);
// 12921
f81632121_1347.returns.push(undefined);
// 12926
f81632121_1340.returns.push(true);
// 12927
o142.initialHandler = f81632121_1349;
// 12928
f81632121_1349.returns.push(undefined);
// 12929
o142.timer = null;
// 12930
f81632121_14.returns.push(undefined);
// 12932
o142._shouldSuppressJS = f81632121_1350;
// 12934
f81632121_1731.returns.push(undefined);
// 12935
f81632121_1350.returns.push(false);
// 12936
o142._handleJSResponse = f81632121_1351;
// 12937
o142.getRelativeTo = f81632121_1352;
// 12938
o142.relativeTo = null;
// 12939
f81632121_1352.returns.push(null);
// 12940
o142._handleJSRegisters = f81632121_1353;
// 12941
f81632121_1353.returns.push(undefined);
// 12942
o142.lid = void 0;
// 12944
f81632121_1353.returns.push(undefined);
// 12945
f81632121_1351.returns.push(undefined);
// 12946
o142.finallyHandler = f81632121_1349;
// 12947
f81632121_1349.returns.push(undefined);
// 12948
f81632121_1341.returns.push(undefined);
// undefined
fo81632121_1_cookie.returns.push("c_user=100006118350059; csm=2");
// 12952
f81632121_467.returns.push(1374851234448);
// 12954
o140.clearStatusIndicator = f81632121_1347;
// 12955
o140.getStatusElement = f81632121_1348;
// 12956
o140.statusElement = null;
// 12957
f81632121_1348.returns.push(null);
// 12958
f81632121_1347.returns.push(undefined);
// 12963
f81632121_1340.returns.push(true);
// 12964
o140.initialHandler = f81632121_1349;
// 12965
f81632121_1349.returns.push(undefined);
// 12966
o140.timer = null;
// 12967
f81632121_14.returns.push(undefined);
// 12969
o140._shouldSuppressJS = f81632121_1350;
// 12971
f81632121_1740.returns.push(undefined);
// 12972
f81632121_1350.returns.push(false);
// 12973
o140._handleJSResponse = f81632121_1351;
// 12974
o140.getRelativeTo = f81632121_1352;
// 12975
o140.relativeTo = null;
// 12976
f81632121_1352.returns.push(null);
// 12977
o140._handleJSRegisters = f81632121_1353;
// 12978
f81632121_1353.returns.push(undefined);
// 12979
o140.lid = void 0;
// 12981
f81632121_1353.returns.push(undefined);
// 12982
f81632121_1351.returns.push(undefined);
// 12983
o140.finallyHandler = f81632121_1349;
// 12984
f81632121_1349.returns.push(undefined);
// 12985
f81632121_1341.returns.push(undefined);
// 12990
o176 = {};
// 12996
f81632121_468.returns.push(undefined);
// 12997
o0.JSBNG__onfullscreenchange = void 0;
// 13002
f81632121_468.returns.push(undefined);
// 13003
o0.JSBNG__onmozfullscreenchange = void 0;
// 13008
f81632121_468.returns.push(undefined);
// 13009
o0.JSBNG__onwebkitfullscreenchange = null;
// 13012
f81632121_1746 = function() { return f81632121_1746.returns[f81632121_1746.inst++]; };
f81632121_1746.returns = [];
f81632121_1746.inst = 0;
// 13013
f81632121_1349.thatReturnsNull = f81632121_1746;
// 13019
o180 = {};
// 13020
f81632121_476.returns.push(o180);
// 13021
// 13022
// 13023
o180.getElementsByTagName = f81632121_502;
// 13024
o181 = {};
// 13025
f81632121_502.returns.push(o181);
// 13026
o181.length = 0;
// undefined
o181 = null;
// 13028
o181 = {};
// 13029
o180.childNodes = o181;
// undefined
o180 = null;
// 13030
o181.nodeType = void 0;
// undefined
o181 = null;
// 13032
f81632121_1620.__prototyped = void 0;
// 13033
f81632121_1619.__prototyped = void 0;
// 13034
o25.__html = void 0;
// 13035
o25.mountComponentIntoNode = void 0;
// undefined
o25 = null;
// 13037
o25 = {};
// 13038
f81632121_476.returns.push(o25);
// 13039
// 13040
o25.firstChild = null;
// 13042
o180 = {};
// 13043
f81632121_474.returns.push(o180);
// 13045
o25.appendChild = f81632121_478;
// 13046
f81632121_478.returns.push(o180);
// undefined
o180 = null;
// 13048
o180 = {};
// 13049
f81632121_476.returns.push(o180);
// 13050
// 13051
o180.firstChild = null;
// 13053
o181 = {};
// 13054
f81632121_474.returns.push(o181);
// 13055
o25.__html = void 0;
// undefined
o25 = null;
// 13056
o180.appendChild = f81632121_478;
// 13057
f81632121_478.returns.push(o181);
// undefined
o181 = null;
// 13058
o180.setAttribute = f81632121_575;
// 13060
f81632121_575.returns.push(undefined);
// 13063
f81632121_575.returns.push(undefined);
// 13064
// 13067
f81632121_575.returns.push(undefined);
// 13070
f81632121_575.returns.push(undefined);
// 13071
o25 = {};
// 13072
o180.classList = o25;
// 13074
o25.add = f81632121_602;
// undefined
o25 = null;
// 13075
f81632121_602.returns.push(undefined);
// 13079
f81632121_602.returns.push(undefined);
// 13083
f81632121_602.returns.push(undefined);
// 13084
o180.__FB_TOKEN = void 0;
// 13085
// 13090
o25 = {};
// 13091
f81632121_504.returns.push(o25);
// 13092
o25.length = 1;
// 13093
o25["0"] = o82;
// undefined
o25 = null;
// 13094
f81632121_1746.__prototyped = void 0;
// 13099
f81632121_1756 = function() { return f81632121_1756.returns[f81632121_1756.inst++]; };
f81632121_1756.returns = [];
f81632121_1756.inst = 0;
// 13100
o0.webkitCancelFullScreen = f81632121_1756;
// 13101
o180.getElementsByTagName = f81632121_502;
// 13103
o180.querySelectorAll = f81632121_504;
// undefined
o180 = null;
// 13104
o25 = {};
// 13105
f81632121_504.returns.push(o25);
// 13106
o25.length = 0;
// undefined
o25 = null;
// 13110
o25 = {};
// 13111
f81632121_504.returns.push(o25);
// 13112
o25.length = 0;
// undefined
o25 = null;
// 13116
o25 = {};
// 13117
f81632121_504.returns.push(o25);
// 13118
o25.length = 0;
// undefined
o25 = null;
// 13122
f81632121_602.returns.push(undefined);
// 13124
f81632121_467.returns.push(1374851236898);
// 13126
f81632121_467.returns.push(1374851236898);
// 13128
o25 = {};
// 13129
o180 = {};
// 13131
o25.nodeType = void 0;
// 13132
o25.length = 1;
// 13133
o25["0"] = "e0RyX";
// 13140
o181 = {};
// 13141
f81632121_508.returns.push(o181);
// 13143
o182 = {};
// 13144
f81632121_508.returns.push(o182);
// 13145
o182.nodeName = "A";
// 13146
o182.rel = "toggle";
// 13148
o182.__FB_TOKEN = void 0;
// 13149
// 13150
o182.getAttribute = f81632121_506;
// 13151
o182.hasAttribute = f81632121_507;
// 13153
f81632121_507.returns.push(false);
// 13154
o182.JSBNG__addEventListener = f81632121_468;
// 13156
f81632121_468.returns.push(undefined);
// 13157
o182.JSBNG__onkeydown = null;
// 13159
o182.setAttribute = f81632121_575;
// 13160
f81632121_575.returns.push(undefined);
// 13161
o181.__FB_TOKEN = void 0;
// 13162
// 13166
f81632121_1349.__prototyped = void 0;
// 13168
f81632121_1417.__prototyped = void 0;
// 13180
o183 = {};
// 13181
f81632121_508.returns.push(o183);
// 13183
o184 = {};
// 13184
f81632121_508.returns.push(o184);
// 13185
o184.nodeName = "A";
// 13186
o184.rel = "toggle";
// 13188
o184.__FB_TOKEN = void 0;
// 13189
// 13190
o184.getAttribute = f81632121_506;
// 13191
o184.hasAttribute = f81632121_507;
// 13193
f81632121_507.returns.push(false);
// 13194
o184.JSBNG__addEventListener = f81632121_468;
// 13196
f81632121_468.returns.push(undefined);
// 13197
o184.JSBNG__onkeydown = null;
// 13199
o184.setAttribute = f81632121_575;
// 13200
f81632121_575.returns.push(undefined);
// 13201
o183.__FB_TOKEN = void 0;
// 13202
// undefined
o183 = null;
// 13206
f81632121_468.returns.push(undefined);
// 13207
o184.JSBNG__onmouseover = null;
// undefined
o184 = null;
// 13215
o183 = {};
// 13216
f81632121_508.returns.push(o183);
// 13218
o184 = {};
// 13219
f81632121_508.returns.push(o184);
// 13220
o184.nodeName = "A";
// 13221
o184.rel = "toggle";
// 13223
o184.__FB_TOKEN = void 0;
// 13224
// 13225
o184.getAttribute = f81632121_506;
// 13226
o184.hasAttribute = f81632121_507;
// 13228
f81632121_507.returns.push(false);
// 13229
o184.JSBNG__addEventListener = f81632121_468;
// 13231
f81632121_468.returns.push(undefined);
// 13232
o184.JSBNG__onkeydown = null;
// 13234
o184.setAttribute = f81632121_575;
// 13235
f81632121_575.returns.push(undefined);
// 13236
o183.__FB_TOKEN = void 0;
// 13237
// undefined
o183 = null;
// 13241
f81632121_468.returns.push(undefined);
// 13242
o184.JSBNG__onmouseover = null;
// undefined
o184 = null;
// 13248
o183 = {};
// 13249
f81632121_508.returns.push(o183);
// 13251
o184 = {};
// 13252
f81632121_508.returns.push(o184);
// 13253
o184.nodeName = "A";
// 13254
o184.rel = "toggle";
// 13256
o184.__FB_TOKEN = void 0;
// 13257
// 13258
o184.getAttribute = f81632121_506;
// 13259
o184.hasAttribute = f81632121_507;
// 13261
f81632121_507.returns.push(false);
// 13262
o184.JSBNG__addEventListener = f81632121_468;
// 13264
f81632121_468.returns.push(undefined);
// 13265
o184.JSBNG__onkeydown = null;
// 13267
o184.setAttribute = f81632121_575;
// 13268
f81632121_575.returns.push(undefined);
// 13269
o183.__FB_TOKEN = void 0;
// 13270
// undefined
o183 = null;
// 13274
f81632121_468.returns.push(undefined);
// 13275
o184.JSBNG__onmouseover = null;
// undefined
o184 = null;
// 13281
o183 = {};
// 13282
f81632121_508.returns.push(o183);
// 13284
o184 = {};
// 13285
f81632121_508.returns.push(o184);
// 13286
o184.nodeName = "A";
// 13287
o184.rel = "toggle";
// 13289
o184.__FB_TOKEN = void 0;
// 13290
// 13291
o184.getAttribute = f81632121_506;
// 13292
o184.hasAttribute = f81632121_507;
// 13294
f81632121_507.returns.push(false);
// 13295
o184.JSBNG__addEventListener = f81632121_468;
// 13297
f81632121_468.returns.push(undefined);
// 13298
o184.JSBNG__onkeydown = null;
// 13300
o184.setAttribute = f81632121_575;
// 13301
f81632121_575.returns.push(undefined);
// 13302
o183.__FB_TOKEN = void 0;
// 13303
// undefined
o183 = null;
// 13307
f81632121_468.returns.push(undefined);
// 13308
o184.JSBNG__onmouseover = null;
// undefined
o184 = null;
// 13314
f81632121_508.returns.push(o164);
// undefined
o164 = null;
// 13318
f81632121_467.returns.push(1374851236966);
// 13327
f81632121_508.returns.push(o165);
// undefined
o165 = null;
// 13331
f81632121_467.returns.push(1374851236970);
// 13340
o164 = {};
// 13341
o165 = {};
// 13343
o164.nodeType = void 0;
// 13344
o164.length = 1;
// 13345
o164["0"] = "OYzUx";
// 13352
o183 = {};
// 13353
f81632121_508.returns.push(o183);
// 13354
f81632121_463.returns.push(3);
// 13357
f81632121_508.returns.push(o183);
// 13361
o184 = {};
// 13362
f81632121_508.returns.push(o184);
// 13363
o184.nodeName = "A";
// 13364
o184.__FB_TOKEN = void 0;
// 13365
// 13366
o184.getAttribute = f81632121_506;
// 13367
o184.hasAttribute = f81632121_507;
// 13369
f81632121_507.returns.push(false);
// 13370
o184.JSBNG__addEventListener = f81632121_468;
// 13372
f81632121_468.returns.push(undefined);
// 13373
o184.JSBNG__onclick = null;
// undefined
o184 = null;
// 13377
f81632121_508.returns.push(o87);
// undefined
o87 = null;
// 13379
o87 = {};
// 13380
f81632121_508.returns.push(o87);
// 13382
f81632121_467.returns.push(1374851237022);
// 13387
o184 = {};
// 13388
f81632121_508.returns.push(o184);
// 13389
o184.nodeName = "A";
// 13390
o184.__FB_TOKEN = void 0;
// 13391
// 13392
o184.getAttribute = f81632121_506;
// 13393
o184.hasAttribute = f81632121_507;
// 13395
f81632121_507.returns.push(false);
// 13396
o184.JSBNG__addEventListener = f81632121_468;
// 13398
f81632121_468.returns.push(undefined);
// 13399
o184.JSBNG__onclick = null;
// undefined
o184 = null;
// 13403
f81632121_508.returns.push(o85);
// undefined
o85 = null;
// 13407
o85 = {};
// 13408
f81632121_508.returns.push(o85);
// 13409
o85.nodeName = "A";
// 13410
o85.__FB_TOKEN = void 0;
// 13411
// 13412
o85.getAttribute = f81632121_506;
// 13413
o85.hasAttribute = f81632121_507;
// 13415
f81632121_507.returns.push(false);
// 13416
o85.JSBNG__addEventListener = f81632121_468;
// 13418
f81632121_468.returns.push(undefined);
// 13419
o85.JSBNG__onclick = null;
// undefined
o85 = null;
// 13423
f81632121_508.returns.push(o88);
// undefined
o88 = null;
// 13427
o85 = {};
// 13428
f81632121_508.returns.push(o85);
// 13429
o85.nodeName = "A";
// 13430
o85.__FB_TOKEN = void 0;
// 13431
// 13432
o85.getAttribute = f81632121_506;
// 13433
o85.hasAttribute = f81632121_507;
// 13435
f81632121_507.returns.push(false);
// 13436
o85.JSBNG__addEventListener = f81632121_468;
// 13438
f81632121_468.returns.push(undefined);
// 13439
o85.JSBNG__onclick = null;
// undefined
o85 = null;
// 13443
f81632121_508.returns.push(o91);
// undefined
o91 = null;
// 13447
o85 = {};
// 13448
f81632121_508.returns.push(o85);
// 13449
o85.nodeName = "A";
// 13450
o85.__FB_TOKEN = void 0;
// 13451
// 13452
o85.getAttribute = f81632121_506;
// 13453
o85.hasAttribute = f81632121_507;
// 13455
f81632121_507.returns.push(false);
// 13456
o85.JSBNG__addEventListener = f81632121_468;
// 13458
f81632121_468.returns.push(undefined);
// 13459
o85.JSBNG__onclick = null;
// undefined
o85 = null;
// 13463
f81632121_508.returns.push(o92);
// undefined
o92 = null;
// 13466
o85 = {};
// 13467
f81632121_508.returns.push(o85);
// 13468
o85.nodeName = "A";
// 13469
o85.__FB_TOKEN = void 0;
// 13470
// 13471
o85.getAttribute = f81632121_506;
// 13472
o85.hasAttribute = f81632121_507;
// 13474
f81632121_507.returns.push(false);
// 13475
o85.JSBNG__addEventListener = f81632121_468;
// 13477
f81632121_468.returns.push(undefined);
// 13478
o85.JSBNG__onclick = null;
// undefined
o85 = null;
// 13482
f81632121_508.returns.push(o90);
// undefined
o90 = null;
// 13486
o85 = {};
// 13487
f81632121_508.returns.push(o85);
// 13488
o85.nodeName = "A";
// 13489
o85.__FB_TOKEN = void 0;
// 13490
// 13491
o85.getAttribute = f81632121_506;
// 13492
o85.hasAttribute = f81632121_507;
// 13494
f81632121_507.returns.push(false);
// 13495
o85.JSBNG__addEventListener = f81632121_468;
// 13497
f81632121_468.returns.push(undefined);
// 13498
o85.JSBNG__onclick = null;
// undefined
o85 = null;
// 13502
f81632121_508.returns.push(o89);
// undefined
o89 = null;
// 13506
o85 = {};
// 13507
f81632121_508.returns.push(o85);
// 13508
o88 = {};
// 13509
o85.firstChild = o88;
// 13510
o88.id = "u_0_42";
// 13516
f81632121_508.returns.push(o29);
// 13520
o89 = {};
// 13521
f81632121_508.returns.push(o89);
// 13522
o89.nodeName = "DIV";
// 13523
o89.__FB_TOKEN = void 0;
// 13524
// 13525
o89.getAttribute = f81632121_506;
// 13526
o89.hasAttribute = f81632121_507;
// 13528
f81632121_507.returns.push(false);
// 13529
o89.JSBNG__addEventListener = f81632121_468;
// 13531
f81632121_468.returns.push(undefined);
// 13532
o89.JSBNG__onclick = null;
// undefined
o89 = null;
// 13541
o89 = {};
// 13542
o90 = {};
// 13544
o89.nodeType = void 0;
// 13545
o89.length = 1;
// 13546
o89["0"] = "xfhln";
// 13549
f81632121_467.returns.push(1374851237057);
// 13552
f81632121_467.returns.push(1374851237057);
// 13554
f81632121_467.returns.push(1374851237057);
// 13557
f81632121_467.returns.push(1374851237061);
// 13560
f81632121_467.returns.push(1374851237062);
// 13562
f81632121_467.returns.push(1374851237062);
// 13565
f81632121_467.returns.push(1374851237062);
// 13568
f81632121_467.returns.push(1374851237063);
// 13570
f81632121_467.returns.push(1374851237063);
// 13573
f81632121_467.returns.push(1374851237064);
// 13576
f81632121_467.returns.push(1374851237064);
// 13578
f81632121_467.returns.push(1374851237064);
// 13581
f81632121_467.returns.push(1374851237065);
// 13584
f81632121_467.returns.push(1374851237065);
// 13587
f81632121_508.returns.push(o88);
// 13603
f81632121_467.returns.push(1374851237068);
// 13606
f81632121_467.returns.push(1374851237069);
// 13609
f81632121_467.returns.push(1374851237069);
// 13611
f81632121_467.returns.push(1374851237069);
// 13620
f81632121_468.returns.push(undefined);
// 13621
o182.JSBNG__onmouseover = null;
// 13628
f81632121_468.returns.push(undefined);
// 13629
o182.JSBNG__onmouseout = null;
// undefined
o182 = null;
// 13633
o91 = {};
// 13634
f81632121_508.returns.push(o91);
// 13635
o92 = {};
// 13636
o91.classList = o92;
// 13638
o92.contains = f81632121_513;
// undefined
o92 = null;
// 13639
f81632121_513.returns.push(false);
// 13640
o92 = {};
// 13641
o91.parentNode = o92;
// 13642
o182 = {};
// 13643
o92.classList = o182;
// 13645
o182.contains = f81632121_513;
// undefined
o182 = null;
// 13646
f81632121_513.returns.push(true);
// 13647
o91.getElementsByTagName = f81632121_502;
// 13649
o91.querySelectorAll = f81632121_504;
// 13650
o182 = {};
// 13651
f81632121_504.returns.push(o182);
// 13652
o182.length = 1;
// 13653
o182["0"] = o24;
// undefined
o182 = null;
// 13657
o182 = {};
// 13658
f81632121_508.returns.push(o182);
// 13659
o182.getElementsByTagName = f81632121_502;
// 13661
o182.querySelectorAll = f81632121_504;
// 13662
o184 = {};
// 13663
f81632121_504.returns.push(o184);
// 13664
o184.length = 1;
// 13665
o185 = {};
// 13666
o184["0"] = o185;
// undefined
o184 = null;
// 13670
o184 = {};
// 13671
f81632121_504.returns.push(o184);
// 13672
o184.length = 5;
// 13673
o184["0"] = o185;
// undefined
o185 = null;
// 13674
o185 = {};
// 13675
o184["1"] = o185;
// undefined
o185 = null;
// 13676
o185 = {};
// 13677
o184["2"] = o185;
// undefined
o185 = null;
// 13678
o185 = {};
// 13679
o184["3"] = o185;
// undefined
o185 = null;
// 13680
o184["4"] = o181;
// undefined
o184 = null;
// 13681
o184 = {};
// 13682
o182.classList = o184;
// 13684
o184.contains = f81632121_513;
// undefined
o184 = null;
// 13685
f81632121_513.returns.push(false);
// 13686
o184 = {};
// 13687
o182.parentNode = o184;
// 13688
o185 = {};
// 13689
o184.classList = o185;
// 13691
o185.contains = f81632121_513;
// undefined
o185 = null;
// 13692
f81632121_513.returns.push(true);
// 13693
o184.offsetWidth = 850;
// 13694
o181.offsetLeft = 524;
// 13695
o181.offsetWidth = 84;
// undefined
o181 = null;
// 13701
f81632121_513.returns.push(false);
// 13706
f81632121_513.returns.push(false);
// 13707
o181 = {};
// 13708
o184.parentNode = o181;
// 13709
o185 = {};
// 13710
o181.classList = o185;
// 13712
o185.contains = f81632121_513;
// undefined
o185 = null;
// 13713
f81632121_513.returns.push(false);
// 13714
o181.parentNode = o91;
// 13718
f81632121_513.returns.push(false);
// 13723
f81632121_513.returns.push(false);
// 13724
o185 = {};
// 13725
o92.parentNode = o185;
// 13726
o186 = {};
// 13727
o185.classList = o186;
// 13729
o186.contains = f81632121_513;
// 13730
f81632121_513.returns.push(true);
// 13733
o186.remove = f81632121_1114;
// undefined
o186 = null;
// 13734
f81632121_1114.returns.push(undefined);
// 13740
o186 = {};
// 13741
f81632121_508.returns.push(o186);
// undefined
o186 = null;
// 13742
o186 = {};
// 13743
o187 = {};
// 13745
o186.nodeType = void 0;
// 13746
o186.length = 1;
// 13747
o186["0"] = "4kgAq";
// 13750
f81632121_467.returns.push(1374851237153);
// 13753
f81632121_467.returns.push(1374851237153);
// 13755
f81632121_467.returns.push(1374851237153);
// 13758
f81632121_467.returns.push(1374851237153);
// 13761
f81632121_467.returns.push(1374851237153);
// 13763
f81632121_467.returns.push(1374851237153);
// 13766
f81632121_467.returns.push(1374851237154);
// 13769
f81632121_467.returns.push(1374851237154);
// 13772
o188 = {};
// 13773
f81632121_508.returns.push(o188);
// undefined
o188 = null;
// 13775
o188 = {};
// 13776
f81632121_508.returns.push(o188);
// undefined
o188 = null;
// 13778
o188 = {};
// 13779
f81632121_508.returns.push(o188);
// 13781
o189 = {};
// 13782
f81632121_508.returns.push(o189);
// 13783
o188.nodeName = "LI";
// 13784
o188.__FB_TOKEN = void 0;
// 13785
// 13786
o188.getAttribute = f81632121_506;
// 13787
o188.hasAttribute = f81632121_507;
// 13789
f81632121_507.returns.push(false);
// 13790
o188.JSBNG__addEventListener = f81632121_468;
// 13792
f81632121_468.returns.push(undefined);
// 13793
o188.JSBNG__onclick = null;
// undefined
o188 = null;
// 13795
o189.nodeName = "LI";
// 13796
o189.__FB_TOKEN = void 0;
// 13797
// 13798
o189.getAttribute = f81632121_506;
// 13799
o189.hasAttribute = f81632121_507;
// 13801
f81632121_507.returns.push(false);
// 13802
o189.JSBNG__addEventListener = f81632121_468;
// 13804
f81632121_468.returns.push(undefined);
// 13805
o189.JSBNG__onclick = null;
// undefined
o189 = null;
// 13810
f81632121_467.returns.push(1374851237156);
// 13813
f81632121_467.returns.push(1374851237158);
// 13814
o40.getAttribute = f81632121_506;
// undefined
o40 = null;
// 13815
f81632121_506.returns.push("1374637972");
// 13817
f81632121_506.returns.push(null);
// 13818
o41.getAttribute = f81632121_506;
// undefined
o41 = null;
// 13819
f81632121_506.returns.push("1374638034");
// 13821
f81632121_506.returns.push(null);
// 13822
o42.getAttribute = f81632121_506;
// undefined
o42 = null;
// 13823
f81632121_506.returns.push("1374638180");
// 13825
f81632121_506.returns.push(null);
// 13826
o43.getAttribute = f81632121_506;
// undefined
o43 = null;
// 13827
f81632121_506.returns.push("1374733044");
// 13829
f81632121_506.returns.push(null);
// 13830
o48.getAttribute = f81632121_506;
// undefined
o48 = null;
// 13831
f81632121_506.returns.push("1374039953");
// 13833
f81632121_506.returns.push(null);
// 13834
o49.getAttribute = f81632121_506;
// undefined
o49 = null;
// 13835
f81632121_506.returns.push("1374040107");
// 13837
f81632121_506.returns.push(null);
// 13838
o50.getAttribute = f81632121_506;
// undefined
o50 = null;
// 13839
f81632121_506.returns.push("1374040490");
// 13841
f81632121_506.returns.push(null);
// 13842
o51.getAttribute = f81632121_506;
// undefined
o51 = null;
// 13843
f81632121_506.returns.push("1374119198");
// 13845
f81632121_506.returns.push(null);
// 13846
o44.getAttribute = f81632121_506;
// undefined
o44 = null;
// 13847
f81632121_506.returns.push("1373168110");
// 13849
f81632121_506.returns.push(null);
// 13850
o45.getAttribute = f81632121_506;
// undefined
o45 = null;
// 13851
f81632121_506.returns.push("1373214256");
// 13853
f81632121_506.returns.push(null);
// 13854
o46.getAttribute = f81632121_506;
// undefined
o46 = null;
// 13855
f81632121_506.returns.push("1373214355");
// 13857
f81632121_506.returns.push(null);
// 13858
o47.getAttribute = f81632121_506;
// undefined
o47 = null;
// 13859
f81632121_506.returns.push("1373214375");
// 13861
f81632121_506.returns.push(null);
// 13862
o56.getAttribute = f81632121_506;
// undefined
o56 = null;
// 13863
f81632121_506.returns.push("1372985540");
// 13865
f81632121_506.returns.push(null);
// 13866
o57.getAttribute = f81632121_506;
// undefined
o57 = null;
// 13867
f81632121_506.returns.push("1373002430");
// 13869
f81632121_506.returns.push(null);
// 13870
o58.getAttribute = f81632121_506;
// undefined
o58 = null;
// 13871
f81632121_506.returns.push("1373066508");
// 13873
f81632121_506.returns.push(null);
// 13874
o59.getAttribute = f81632121_506;
// undefined
o59 = null;
// 13875
f81632121_506.returns.push("1373066594");
// 13877
f81632121_506.returns.push(null);
// undefined
fo81632121_1_cookie.returns.push("c_user=100006118350059; csm=2");
// 13881
f81632121_467.returns.push(1374851237166);
// 13882
o40 = {};
// undefined
o40 = null;
// undefined
fo81632121_1605_readyState = function() { return fo81632121_1605_readyState.returns[fo81632121_1605_readyState.inst++]; };
fo81632121_1605_readyState.returns = [];
fo81632121_1605_readyState.inst = 0;
defineGetter(o17, "readyState", fo81632121_1605_readyState, undefined);
// undefined
fo81632121_1605_readyState.returns.push(2);
// 13884
o40 = {};
// undefined
o40 = null;
// undefined
fo81632121_1605_readyState.returns.push(3);
// 13886
o40 = {};
// undefined
o40 = null;
// undefined
fo81632121_1605_readyState.returns.push(4);
// 13888
o17.JSBNG__status = 200;
// undefined
fo81632121_1605_readyState.returns.push(4);
// 13890
// undefined
o17 = null;
// 13891
o17 = {};
// 13895
o40 = {};
// 13899
o41 = {};
// 13904
o63.getResponseHeader = f81632121_1332;
// 13907
f81632121_1332.returns.push("/s2QkaS/fr7GuHXgkwmyYd5wa/sWiLHB+XHj7IK5/gk=");
// 13910
f81632121_1332.returns.push("/s2QkaS/fr7GuHXgkwmyYd5wa/sWiLHB+XHj7IK5/gk=");
// 13911
// 13913
o63.JSBNG__status = 200;
// 13917
f81632121_467.returns.push(1374851237173);
// 13918
o76._handleXHRResponse = f81632121_1333;
// 13920
o76.getOption = f81632121_1334;
// 13921
o42 = {};
// 13922
o76.option = o42;
// 13923
o42.suppressEvaluation = false;
// 13926
f81632121_1334.returns.push(false);
// 13927
o63.responseText = "for (;;);{\"__ar\":1,\"payload\":null,\"css\":[\"c6lUE\"],\"bootloadable\":{},\"resource_map\":{\"c6lUE\":{\"type\":\"css\",\"permanent\":1,\"crossOrigin\":1,\"src\":\"https:\\/\\/static.xx.fbcdn.net\\/rsrc.php\\/v2\\/y1\\/r\\/i2fjJiK4liE.css\"}},\"ixData\":[]}";
// 13928
o76._unshieldResponseText = f81632121_1336;
// 13929
f81632121_1336.returns.push("{\"__ar\":1,\"payload\":null,\"css\":[\"c6lUE\"],\"bootloadable\":{},\"resource_map\":{\"c6lUE\":{\"type\":\"css\",\"permanent\":1,\"crossOrigin\":1,\"src\":\"https:\\/\\/static.xx.fbcdn.net\\/rsrc.php\\/v2\\/y1\\/r\\/i2fjJiK4liE.css\"}},\"ixData\":[]}");
// 13930
o76._interpretResponse = f81632121_1337;
// 13931
f81632121_1337.returns.push({__JSBNG_unknown_object:true});
// 13932
o76.invokeResponseHandler = f81632121_1338;
// 13933
o76.handler = null;
// 13934
f81632121_1821 = function() { return f81632121_1821.returns[f81632121_1821.inst++]; };
f81632121_1821.returns = [];
f81632121_1821.inst = 0;
// 13935
o76.errorHandler = f81632121_1821;
// 13936
o76._isRelevant = f81632121_1340;
// 13937
o76._allowCrossPageTransition = true;
// 13938
f81632121_1340.returns.push(true);
// 13939
o76._dispatchResponse = f81632121_1341;
// 13940
o76.getURI = f81632121_1342;
// 13941
o43 = {};
// 13942
o76.uri = o43;
// 13944
o43.$URIBase0 = "";
// 13945
o43.$URIBase1 = "";
// 13946
o43.$URIBase2 = "";
// 13947
o43.$URIBase3 = "/ajax/browse/nux.php";
// 13949
o44 = {};
// 13950
o43.$URIBase5 = o44;
// undefined
o44 = null;
// 13951
o43.$URIBase4 = "";
// 13952
f81632121_1344.returns.push("/ajax/browse/nux.php");
// 13953
f81632121_1342.returns.push("/ajax/browse/nux.php");
// 13954
o76.preBootloadHandler = void 0;
// 13965
f81632121_1344.returns.push("/ajax/browse/nux.php");
// 13966
f81632121_1342.returns.push("/ajax/browse/nux.php");
// 13968
f81632121_12.returns.push(50);
// 13972
o44 = {};
// 13973
f81632121_474.returns.push(o44);
// 13975
f81632121_478.returns.push(o44);
// undefined
o44 = null;
// 13976
f81632121_1338.returns.push(undefined);
// 13977
f81632121_1333.returns.push(undefined);
// 13980
o42.asynchronous = true;
// undefined
o42 = null;
// 13983
f81632121_1334.returns.push(true);
// 13984
// 13985
o42 = {};
// 13986
o183.classList = o42;
// 13988
o42.contains = f81632121_513;
// undefined
o42 = null;
// 13989
f81632121_513.returns.push(false);
// 13990
o42 = {};
// 13991
o183.parentNode = o42;
// 13992
o44 = {};
// 13993
o42.classList = o44;
// 13995
o44.contains = f81632121_513;
// undefined
o44 = null;
// 13996
f81632121_513.returns.push(true);
// 13997
o183.getElementsByTagName = f81632121_502;
// 13999
o183.querySelectorAll = f81632121_504;
// 14000
o44 = {};
// 14001
f81632121_504.returns.push(o44);
// 14002
o44.length = 1;
// 14003
o44["0"] = o31;
// undefined
o44 = null;
// 14007
o44 = {};
// 14008
f81632121_504.returns.push(o44);
// 14009
o44.length = 1;
// 14010
o44["0"] = o73;
// undefined
o44 = null;
// 14011
o73.offsetHeight = 966;
// 14012
o31.offsetHeight = 2496;
// 14013
o42.id = "u_0_1a";
// 14017
f81632121_513.returns.push(false);
// 14022
f81632121_513.returns.push(true);
// 14026
o44 = {};
// 14027
f81632121_504.returns.push(o44);
// 14028
o44.length = 1;
// 14029
o44["0"] = o31;
// undefined
o44 = null;
// 14033
o44 = {};
// 14034
f81632121_504.returns.push(o44);
// 14035
o44.length = 1;
// 14036
o44["0"] = o73;
// undefined
o44 = null;
// 14046
f81632121_508.returns.push(o137);
// 14050
f81632121_645.returns.push(true);
// 14051
o44 = {};
// 14052
f81632121_4.returns.push(o44);
// 14053
o44.getPropertyValue = f81632121_1442;
// undefined
o44 = null;
// 14054
f81632121_1442.returns.push("fixed");
// 14056
f81632121_508.returns.push(o139);
// undefined
o139 = null;
// 14058
o88.offsetWidth = 148;
// 14059
o88.offsetHeight = 62;
// 14063
f81632121_645.returns.push(true);
// 14064
o88.getBoundingClientRect = f81632121_1481;
// 14065
o44 = {};
// 14066
f81632121_1481.returns.push(o44);
// 14067
o44.left = 357;
// 14069
o44.JSBNG__top = 10665;
// undefined
o44 = null;
// 14074
o44 = {};
// 14075
o88.classList = o44;
// 14077
o44.contains = f81632121_513;
// undefined
o44 = null;
// 14078
f81632121_513.returns.push(false);
// 14079
o88.parentNode = o85;
// undefined
o88 = null;
// 14080
o44 = {};
// 14081
o85.classList = o44;
// 14083
o44.contains = f81632121_513;
// undefined
o44 = null;
// 14084
f81632121_513.returns.push(false);
// 14085
o85.parentNode = o79;
// undefined
o85 = null;
// 14086
o44 = {};
// 14087
o79.classList = o44;
// 14089
o44.contains = f81632121_513;
// undefined
o44 = null;
// 14090
f81632121_513.returns.push(false);
// 14091
o44 = {};
// 14092
o79.parentNode = o44;
// undefined
o79 = null;
// 14093
o45 = {};
// 14094
o44.classList = o45;
// 14096
o45.contains = f81632121_513;
// undefined
o45 = null;
// 14097
f81632121_513.returns.push(false);
// 14098
o44.parentNode = o183;
// 14102
f81632121_513.returns.push(false);
// 14107
f81632121_513.returns.push(false);
// 14108
o42.parentNode = o29;
// 14109
o45 = {};
// 14110
o29.classList = o45;
// 14112
o45.contains = f81632121_513;
// undefined
o45 = null;
// 14113
f81632121_513.returns.push(false);
// 14114
o29.parentNode = o87;
// 14115
o45 = {};
// 14116
o87.classList = o45;
// 14118
o45.contains = f81632121_513;
// undefined
o45 = null;
// 14119
f81632121_513.returns.push(false);
// 14120
o87.parentNode = o21;
// 14121
o45 = {};
// 14122
o21.classList = o45;
// 14124
o45.contains = f81632121_513;
// undefined
o45 = null;
// 14125
f81632121_513.returns.push(false);
// 14126
o21.parentNode = o20;
// 14127
o45 = {};
// 14128
o20.classList = o45;
// 14130
o45.contains = f81632121_513;
// undefined
o45 = null;
// 14131
f81632121_513.returns.push(false);
// 14132
o45 = {};
// 14133
o20.parentNode = o45;
// 14134
o46 = {};
// 14135
o45.classList = o46;
// 14137
o46.contains = f81632121_513;
// undefined
o46 = null;
// 14138
f81632121_513.returns.push(false);
// 14139
o45.parentNode = o109;
// 14140
o46 = {};
// 14141
o109.classList = o46;
// 14143
o46.contains = f81632121_513;
// undefined
o46 = null;
// 14144
f81632121_513.returns.push(false);
// 14146
o46 = {};
// 14147
o110.classList = o46;
// 14149
o46.contains = f81632121_513;
// undefined
o46 = null;
// 14150
f81632121_513.returns.push(false);
// 14152
o46 = {};
// 14153
o111.classList = o46;
// 14155
o46.contains = f81632121_513;
// undefined
o46 = null;
// 14156
f81632121_513.returns.push(false);
// 14158
o46 = {};
// 14159
o112.classList = o46;
// 14161
o46.contains = f81632121_513;
// undefined
o46 = null;
// 14162
f81632121_513.returns.push(false);
// 14164
o46 = {};
// 14165
o113.classList = o46;
// 14167
o46.contains = f81632121_513;
// undefined
o46 = null;
// 14168
f81632121_513.returns.push(false);
// 14173
f81632121_513.returns.push(false);
// 14178
f81632121_513.returns.push(false);
// 14183
f81632121_513.returns.push(false);
// 14191
o46 = {};
// 14192
f81632121_504.returns.push(o46);
// 14193
o46.length = 1;
// 14194
o46["0"] = o75;
// undefined
o46 = null;
// 14195
o75.getAttribute = f81632121_506;
// 14196
f81632121_506.returns.push("recent");
// 14198
f81632121_506.returns.push("0");
// 14202
o46 = {};
// 14203
f81632121_504.returns.push(o46);
// 14204
o46.length = 1;
// 14205
o46["0"] = o75;
// undefined
o46 = null;
// undefined
o75 = null;
// 14207
f81632121_506.returns.push("recent");
// 14209
f81632121_506.returns.push("0");
// 14215
f81632121_508.returns.push(o93);
// 14216
f81632121_7.returns.push(undefined);
// 14217
f81632121_1852 = function() { return f81632121_1852.returns[f81632121_1852.inst++]; };
f81632121_1852.returns = [];
f81632121_1852.inst = 0;
// 14218
ow81632121.JSBNG__onmousemove = f81632121_1852;
// 14224
o93.getElementsByTagName = f81632121_502;
// 14226
o93.querySelectorAll = f81632121_504;
// 14227
o46 = {};
// 14228
f81632121_504.returns.push(o46);
// 14229
o46.length = 5;
// 14230
o47 = {};
// 14231
o46["0"] = o47;
// 14232
o48 = {};
// 14233
o46["1"] = o48;
// 14234
o49 = {};
// 14235
o46["2"] = o49;
// 14236
o50 = {};
// 14237
o46["3"] = o50;
// 14238
o51 = {};
// 14239
o46["4"] = o51;
// undefined
o46 = null;
// 14240
o47.getElementsByTagName = f81632121_502;
// 14242
o47.querySelectorAll = f81632121_504;
// 14243
o46 = {};
// 14244
f81632121_504.returns.push(o46);
// 14245
o46.length = 1;
// 14246
o56 = {};
// 14247
o46["0"] = o56;
// undefined
o46 = null;
// 14248
o56.getAttribute = f81632121_506;
// 14249
f81632121_506.returns.push("{\"adid\":6011858202131,\"segment\":\"market\"}");
// 14250
o48.getElementsByTagName = f81632121_502;
// 14252
o48.querySelectorAll = f81632121_504;
// 14253
o46 = {};
// 14254
f81632121_504.returns.push(o46);
// 14255
o46.length = 1;
// 14256
o57 = {};
// 14257
o46["0"] = o57;
// undefined
o46 = null;
// 14258
o57.getAttribute = f81632121_506;
// 14259
f81632121_506.returns.push("{\"adid\":6007957621675,\"segment\":\"market\"}");
// 14260
o49.getElementsByTagName = f81632121_502;
// 14262
o49.querySelectorAll = f81632121_504;
// 14263
o46 = {};
// 14264
f81632121_504.returns.push(o46);
// 14265
o46.length = 1;
// 14266
o58 = {};
// 14267
o46["0"] = o58;
// undefined
o46 = null;
// 14268
o58.getAttribute = f81632121_506;
// 14269
f81632121_506.returns.push("{\"adid\":6007651357550,\"segment\":\"market\"}");
// 14270
o50.getElementsByTagName = f81632121_502;
// 14272
o50.querySelectorAll = f81632121_504;
// 14273
o46 = {};
// 14274
f81632121_504.returns.push(o46);
// 14275
o46.length = 1;
// 14276
o59 = {};
// 14277
o46["0"] = o59;
// undefined
o46 = null;
// 14278
o59.getAttribute = f81632121_506;
// 14279
f81632121_506.returns.push("{\"adid\":6010680301716,\"segment\":\"market\"}");
// 14280
o51.getElementsByTagName = f81632121_502;
// 14282
o51.querySelectorAll = f81632121_504;
// 14283
o46 = {};
// 14284
f81632121_504.returns.push(o46);
// 14285
o46.length = 1;
// 14286
o75 = {};
// 14287
o46["0"] = o75;
// undefined
o46 = null;
// 14288
o75.getAttribute = f81632121_506;
// 14289
f81632121_506.returns.push("{\"adid\":6007882470930,\"segment\":\"market\"}");
// 14290
o46 = {};
// 14291
o47.classList = o46;
// 14293
o46.add = f81632121_602;
// 14294
f81632121_602.returns.push(undefined);
// 14295
o79 = {};
// 14296
o93.classList = o79;
// 14298
o79.remove = f81632121_1114;
// undefined
o79 = null;
// 14299
f81632121_1114.returns.push(undefined);
// 14300
o93.setAttribute = f81632121_575;
// 14301
f81632121_575.returns.push(undefined);
// 14302
f81632121_1871 = function() { return f81632121_1871.returns[f81632121_1871.inst++]; };
f81632121_1871.returns = [];
f81632121_1871.inst = 0;
// 14303
o93.cloneNode = f81632121_1871;
// 14304
o79 = {};
// 14305
f81632121_1871.returns.push(o79);
// 14306
// 14307
o79.getElementsByTagName = f81632121_502;
// 14309
o79.querySelectorAll = f81632121_504;
// 14310
o85 = {};
// 14311
f81632121_504.returns.push(o85);
// 14312
o85.length = 5;
// 14313
o88 = {};
// 14314
o85["0"] = o88;
// 14315
o139 = {};
// 14316
o85["1"] = o139;
// 14317
o188 = {};
// 14318
o85["2"] = o188;
// 14319
o189 = {};
// 14320
o85["3"] = o189;
// 14321
o190 = {};
// 14322
o85["4"] = o190;
// undefined
o85 = null;
// 14323
o88.getElementsByTagName = f81632121_502;
// 14325
o88.querySelectorAll = f81632121_504;
// undefined
o88 = null;
// 14326
o85 = {};
// 14327
f81632121_504.returns.push(o85);
// 14328
o85.length = 1;
// 14329
o88 = {};
// 14330
o85["0"] = o88;
// undefined
o85 = null;
// 14331
o88.getAttribute = f81632121_506;
// undefined
o88 = null;
// 14332
f81632121_506.returns.push("{\"adid\":6011858202131,\"segment\":\"market\"}");
// 14333
o139.getElementsByTagName = f81632121_502;
// 14335
o139.querySelectorAll = f81632121_504;
// 14336
o85 = {};
// 14337
f81632121_504.returns.push(o85);
// 14338
o85.length = 1;
// 14339
o88 = {};
// 14340
o85["0"] = o88;
// undefined
o85 = null;
// 14341
o88.getAttribute = f81632121_506;
// undefined
o88 = null;
// 14342
f81632121_506.returns.push("{\"adid\":6007957621675,\"segment\":\"market\"}");
// 14343
o188.getElementsByTagName = f81632121_502;
// 14345
o188.querySelectorAll = f81632121_504;
// 14346
o85 = {};
// 14347
f81632121_504.returns.push(o85);
// 14348
o85.length = 1;
// 14349
o88 = {};
// 14350
o85["0"] = o88;
// undefined
o85 = null;
// 14351
o88.getAttribute = f81632121_506;
// undefined
o88 = null;
// 14352
f81632121_506.returns.push("{\"adid\":6007651357550,\"segment\":\"market\"}");
// 14353
o189.getElementsByTagName = f81632121_502;
// 14355
o189.querySelectorAll = f81632121_504;
// 14356
o85 = {};
// 14357
f81632121_504.returns.push(o85);
// 14358
o85.length = 1;
// 14359
o88 = {};
// 14360
o85["0"] = o88;
// undefined
o85 = null;
// 14361
o88.getAttribute = f81632121_506;
// undefined
o88 = null;
// 14362
f81632121_506.returns.push("{\"adid\":6010680301716,\"segment\":\"market\"}");
// 14363
o190.getElementsByTagName = f81632121_502;
// 14365
o190.querySelectorAll = f81632121_504;
// 14366
o85 = {};
// 14367
f81632121_504.returns.push(o85);
// 14368
o85.length = 1;
// 14369
o88 = {};
// 14370
o85["0"] = o88;
// undefined
o85 = null;
// 14371
o88.getAttribute = f81632121_506;
// undefined
o88 = null;
// 14372
f81632121_506.returns.push("{\"adid\":6007882470930,\"segment\":\"market\"}");
// 14373
o85 = {};
// 14374
o139.parentNode = o85;
// 14376
o85.removeChild = f81632121_521;
// 14377
f81632121_521.returns.push(o139);
// undefined
o139 = null;
// 14378
o188.parentNode = o85;
// 14381
f81632121_521.returns.push(o188);
// undefined
o188 = null;
// 14382
o189.parentNode = o85;
// 14385
f81632121_521.returns.push(o189);
// undefined
o189 = null;
// 14386
o190.parentNode = o85;
// undefined
o85 = null;
// 14389
f81632121_521.returns.push(o190);
// undefined
o190 = null;
// 14390
o85 = {};
// 14391
o79.classList = o85;
// 14393
o85.add = f81632121_602;
// undefined
o85 = null;
// 14394
f81632121_602.returns.push(undefined);
// 14397
o46.remove = f81632121_1114;
// undefined
o46 = null;
// 14398
f81632121_1114.returns.push(undefined);
// 14399
o47.setAttribute = f81632121_575;
// 14400
f81632121_575.returns.push(undefined);
// 14401
o46 = {};
// 14402
o48.classList = o46;
// 14404
o46.remove = f81632121_1114;
// undefined
o46 = null;
// 14405
f81632121_1114.returns.push(undefined);
// 14406
o48.setAttribute = f81632121_575;
// 14407
f81632121_575.returns.push(undefined);
// 14408
o46 = {};
// 14409
o49.classList = o46;
// 14411
o46.remove = f81632121_1114;
// undefined
o46 = null;
// 14412
f81632121_1114.returns.push(undefined);
// 14413
o49.setAttribute = f81632121_575;
// 14414
f81632121_575.returns.push(undefined);
// 14415
o46 = {};
// 14416
o50.classList = o46;
// 14418
o46.add = f81632121_602;
// undefined
o46 = null;
// 14419
f81632121_602.returns.push(undefined);
// 14420
o50.setAttribute = f81632121_575;
// 14421
f81632121_575.returns.push(undefined);
// 14422
o46 = {};
// 14423
o51.classList = o46;
// 14425
o46.add = f81632121_602;
// undefined
o46 = null;
// 14426
f81632121_602.returns.push(undefined);
// 14427
o51.setAttribute = f81632121_575;
// 14428
f81632121_575.returns.push(undefined);
// 14432
f81632121_1114.returns.push(undefined);
// 14434
f81632121_575.returns.push(undefined);
// 14438
o46 = {};
// 14439
f81632121_504.returns.push(o46);
// 14440
o46.length = 1;
// 14441
o46["0"] = o58;
// undefined
o46 = null;
// 14443
f81632121_506.returns.push("{\"adid\":6007651357550,\"segment\":\"market\"}");
// 14445
o46 = {};
// 14446
f81632121_476.returns.push(o46);
// 14447
// 14448
o46.setAttribute = f81632121_575;
// 14450
f81632121_575.returns.push(undefined);
// 14453
f81632121_575.returns.push(undefined);
// 14456
f81632121_575.returns.push(undefined);
// 14459
f81632121_575.returns.push(undefined);
// 14462
f81632121_575.returns.push(undefined);
// 14464
f81632121_575.returns.push(undefined);
// 14465
o46.__html = void 0;
// undefined
o46 = null;
// 14467
o46 = {};
// 14468
f81632121_474.returns.push(o46);
// 14470
o93.appendChild = f81632121_478;
// 14471
f81632121_478.returns.push(o46);
// undefined
o46 = null;
// 14475
o46 = {};
// 14476
f81632121_504.returns.push(o46);
// 14477
o46.length = 1;
// 14478
o46["0"] = o57;
// undefined
o46 = null;
// 14480
f81632121_506.returns.push("{\"adid\":6007957621675,\"segment\":\"market\"}");
// 14482
o46 = {};
// 14483
f81632121_476.returns.push(o46);
// 14484
// 14485
o46.setAttribute = f81632121_575;
// 14487
f81632121_575.returns.push(undefined);
// 14490
f81632121_575.returns.push(undefined);
// 14493
f81632121_575.returns.push(undefined);
// 14496
f81632121_575.returns.push(undefined);
// 14499
f81632121_575.returns.push(undefined);
// 14501
f81632121_575.returns.push(undefined);
// 14502
o46.__html = void 0;
// undefined
o46 = null;
// 14504
o46 = {};
// 14505
f81632121_474.returns.push(o46);
// 14508
f81632121_478.returns.push(o46);
// undefined
o46 = null;
// 14512
o46 = {};
// 14513
f81632121_504.returns.push(o46);
// 14514
o46.length = 1;
// 14515
o46["0"] = o56;
// undefined
o46 = null;
// 14517
f81632121_506.returns.push("{\"adid\":6011858202131,\"segment\":\"market\"}");
// 14519
o46 = {};
// 14520
f81632121_476.returns.push(o46);
// 14521
// 14522
o46.setAttribute = f81632121_575;
// 14524
f81632121_575.returns.push(undefined);
// 14527
f81632121_575.returns.push(undefined);
// 14530
f81632121_575.returns.push(undefined);
// 14533
f81632121_575.returns.push(undefined);
// 14536
f81632121_575.returns.push(undefined);
// 14538
f81632121_575.returns.push(undefined);
// 14539
o46.__html = void 0;
// undefined
o46 = null;
// 14541
o46 = {};
// 14542
f81632121_474.returns.push(o46);
// 14545
f81632121_478.returns.push(o46);
// undefined
o46 = null;
// 14549
o46 = {};
// 14550
f81632121_504.returns.push(o46);
// 14551
o46.length = 1;
// 14552
o46["0"] = o56;
// undefined
o46 = null;
// 14554
f81632121_506.returns.push("{\"adid\":6011858202131,\"segment\":\"market\"}");
// 14558
o46 = {};
// 14559
f81632121_504.returns.push(o46);
// 14560
o46.length = 1;
// 14561
o46["0"] = o57;
// undefined
o46 = null;
// 14563
f81632121_506.returns.push("{\"adid\":6007957621675,\"segment\":\"market\"}");
// 14567
o46 = {};
// 14568
f81632121_504.returns.push(o46);
// 14569
o46.length = 1;
// 14570
o46["0"] = o58;
// undefined
o46 = null;
// 14572
f81632121_506.returns.push("{\"adid\":6007651357550,\"segment\":\"market\"}");
// 14576
o46 = {};
// 14577
f81632121_504.returns.push(o46);
// 14578
o46.length = 1;
// 14579
o85 = {};
// 14580
o46["0"] = o85;
// undefined
o46 = null;
// 14581
o85.complete = true;
// 14582
f81632121_12.returns.push(51);
// 14586
o46 = {};
// 14587
f81632121_504.returns.push(o46);
// 14588
o46.length = 1;
// 14589
o88 = {};
// 14590
o46["0"] = o88;
// undefined
o46 = null;
// 14591
o88.complete = true;
// undefined
o88 = null;
// 14592
f81632121_12.returns.push(52);
// 14596
o46 = {};
// 14597
f81632121_504.returns.push(o46);
// 14598
o46.length = 1;
// 14599
o88 = {};
// 14600
o46["0"] = o88;
// undefined
o46 = null;
// 14601
o88.complete = true;
// undefined
o88 = null;
// 14602
f81632121_12.returns.push(53);
// 14606
o46 = {};
// 14607
f81632121_504.returns.push(o46);
// 14608
o46.length = 1;
// 14609
o88 = {};
// 14610
o46["0"] = o88;
// undefined
o46 = null;
// 14611
o88.complete = true;
// undefined
o88 = null;
// 14612
f81632121_12.returns.push(54);
// 14616
o46 = {};
// 14617
f81632121_504.returns.push(o46);
// 14618
o46.length = 1;
// 14619
o88 = {};
// 14620
o46["0"] = o88;
// undefined
o46 = null;
// 14621
o88.complete = true;
// undefined
o88 = null;
// 14622
f81632121_12.returns.push(55);
// 14623
o79.parentNode = null;
// undefined
o79 = null;
// 14627
f81632121_1114.returns.push(undefined);
// 14630
o46 = {};
// 14631
f81632121_508.returns.push(o46);
// 14632
o46.getElementsByTagName = f81632121_502;
// 14634
o46.querySelectorAll = f81632121_504;
// 14635
o79 = {};
// 14636
f81632121_504.returns.push(o79);
// 14637
o79.length = 0;
// undefined
o79 = null;
// 14641
o79 = {};
// 14642
f81632121_504.returns.push(o79);
// 14643
o79.length = 1;
// 14644
o88 = {};
// 14645
o79["0"] = o88;
// undefined
o79 = null;
// undefined
o88 = null;
// 14646
o79 = {};
// 14647
o46.classList = o79;
// 14649
o79.contains = f81632121_513;
// 14650
f81632121_513.returns.push(false);
// 14652
f81632121_508.returns.push(o137);
// 14653
f81632121_463.returns.push(4);
// 14656
o88 = {};
// 14657
f81632121_508.returns.push(o88);
// 14658
o88.getElementsByTagName = f81632121_502;
// 14660
o88.querySelectorAll = f81632121_504;
// 14661
o139 = {};
// 14662
f81632121_504.returns.push(o139);
// 14663
o139.length = 1;
// 14664
o188 = {};
// 14665
o139["0"] = o188;
// undefined
o139 = null;
// 14669
o139 = {};
// 14670
f81632121_504.returns.push(o139);
// 14671
o139.length = 1;
// 14672
o189 = {};
// 14673
o139["0"] = o189;
// undefined
o139 = null;
// undefined
o189 = null;
// 14677
o139 = {};
// 14678
f81632121_504.returns.push(o139);
// 14679
o139.length = 1;
// 14680
o189 = {};
// 14681
o139["0"] = o189;
// undefined
o139 = null;
// undefined
o189 = null;
// 14682
o188.getElementsByTagName = f81632121_502;
// 14684
o188.querySelectorAll = f81632121_504;
// 14685
o139 = {};
// 14686
f81632121_504.returns.push(o139);
// 14687
o139.length = 1;
// 14688
o189 = {};
// 14689
o139["0"] = o189;
// undefined
o139 = null;
// undefined
o189 = null;
// 14690
o139 = {};
// 14691
o188.classList = o139;
// 14693
o139.contains = f81632121_513;
// undefined
o139 = null;
// 14694
f81632121_513.returns.push(false);
// 14695
o139 = {};
// 14696
o188.parentNode = o139;
// undefined
o188 = null;
// 14697
o188 = {};
// 14698
o139.classList = o188;
// 14700
o188.contains = f81632121_513;
// undefined
o188 = null;
// 14701
f81632121_513.returns.push(false);
// 14702
o139.parentNode = o88;
// undefined
o139 = null;
// 14703
o139 = {};
// 14704
o88.classList = o139;
// 14706
o139.contains = f81632121_513;
// undefined
o139 = null;
// 14707
f81632121_513.returns.push(true);
// 14708
o88.__FB_TOKEN = void 0;
// 14709
// 14710
o88.getAttribute = f81632121_506;
// 14711
o88.hasAttribute = f81632121_507;
// 14713
f81632121_507.returns.push(false);
// 14717
f81632121_513.returns.push(true);
// 14718
o139 = {};
// 14719
o88.childNodes = o139;
// undefined
o88 = null;
// 14720
o139.nodeType = void 0;
// 14721
o139.classList = void 0;
// 14722
o139.className = void 0;
// 14723
o139.childNodes = void 0;
// undefined
o139 = null;
// 14728
f81632121_467.returns.push(1374851241263);
// 14732
o88 = {};
// 14733
o139 = {};
// 14735
o88.nodeType = void 0;
// 14736
o88.length = 1;
// 14737
o88["0"] = "R940f";
// 14740
f81632121_467.returns.push(1374851241281);
// 14743
f81632121_467.returns.push(1374851241281);
// 14745
f81632121_467.returns.push(1374851241282);
// 14748
f81632121_467.returns.push(1374851241282);
// 14751
f81632121_467.returns.push(1374851241283);
// 14753
f81632121_467.returns.push(1374851241283);
// 14756
f81632121_467.returns.push(1374851241284);
// 14759
f81632121_467.returns.push(1374851241284);
// 14762
f81632121_508.returns.push(o95);
// 14763
o188 = {};
// 14764
o95.childNodes = o188;
// 14765
o189 = {};
// 14766
o188["0"] = o189;
// 14767
o188.length = 8;
// 14769
o189.getAttribute = f81632121_506;
// 14770
f81632121_506.returns.push("recent");
// 14773
o189.getElementsByTagName = f81632121_502;
// 14775
o189.querySelectorAll = f81632121_504;
// undefined
o189 = null;
// 14776
o189 = {};
// 14777
f81632121_504.returns.push(o189);
// 14778
o189.length = 0;
// undefined
o189 = null;
// 14781
f81632121_506.returns.push(null);
// 14783
o189 = {};
// 14784
o188["1"] = o189;
// 14785
o189.getAttribute = f81632121_506;
// 14786
f81632121_506.returns.push("year_2013");
// 14789
o189.getElementsByTagName = f81632121_502;
// 14791
o189.querySelectorAll = f81632121_504;
// undefined
o189 = null;
// 14792
o189 = {};
// 14793
f81632121_504.returns.push(o189);
// 14794
o189.length = 1;
// 14795
o190 = {};
// 14796
o189["0"] = o190;
// undefined
o189 = null;
// 14797
o189 = {};
// 14798
o190.childNodes = o189;
// undefined
o190 = null;
// 14799
o189.length = 1;
// 14800
o190 = {};
// 14801
o189["0"] = o190;
// undefined
o189 = null;
// 14802
o190.getAttribute = f81632121_506;
// undefined
o190 = null;
// 14803
f81632121_506.returns.push("month_2013_1");
// 14808
f81632121_506.returns.push("2010s");
// 14811
o189 = {};
// 14812
o188["2"] = o189;
// 14813
o189.getAttribute = f81632121_506;
// 14814
f81632121_506.returns.push("year_2012");
// 14817
o189.getElementsByTagName = f81632121_502;
// 14819
o189.querySelectorAll = f81632121_504;
// undefined
o189 = null;
// 14820
o189 = {};
// 14821
f81632121_504.returns.push(o189);
// 14822
o189.length = 1;
// 14823
o190 = {};
// 14824
o189["0"] = o190;
// undefined
o189 = null;
// 14825
o189 = {};
// 14826
o190.childNodes = o189;
// undefined
o190 = null;
// 14827
o189.length = 12;
// 14828
o190 = {};
// 14829
o189["0"] = o190;
// 14830
o190.getAttribute = f81632121_506;
// undefined
o190 = null;
// 14831
f81632121_506.returns.push("month_2012_12");
// 14834
o190 = {};
// 14835
o189["1"] = o190;
// 14836
o190.getAttribute = f81632121_506;
// undefined
o190 = null;
// 14837
f81632121_506.returns.push("month_2012_11");
// 14840
o190 = {};
// 14841
o189["2"] = o190;
// 14842
o190.getAttribute = f81632121_506;
// undefined
o190 = null;
// 14843
f81632121_506.returns.push("month_2012_10");
// 14846
o190 = {};
// 14847
o189["3"] = o190;
// 14848
o190.getAttribute = f81632121_506;
// undefined
o190 = null;
// 14849
f81632121_506.returns.push("month_2012_9");
// 14852
o190 = {};
// 14853
o189["4"] = o190;
// 14854
o190.getAttribute = f81632121_506;
// undefined
o190 = null;
// 14855
f81632121_506.returns.push("month_2012_8");
// 14858
o190 = {};
// 14859
o189["5"] = o190;
// 14860
o190.getAttribute = f81632121_506;
// undefined
o190 = null;
// 14861
f81632121_506.returns.push("month_2012_7");
// 14864
o190 = {};
// 14865
o189["6"] = o190;
// 14866
o190.getAttribute = f81632121_506;
// undefined
o190 = null;
// 14867
f81632121_506.returns.push("month_2012_6");
// 14870
o190 = {};
// 14871
o189["7"] = o190;
// 14872
o190.getAttribute = f81632121_506;
// undefined
o190 = null;
// 14873
f81632121_506.returns.push("month_2012_5");
// 14876
o190 = {};
// 14877
o189["8"] = o190;
// 14878
o190.getAttribute = f81632121_506;
// undefined
o190 = null;
// 14879
f81632121_506.returns.push("month_2012_4");
// 14882
o190 = {};
// 14883
o189["9"] = o190;
// 14884
o190.getAttribute = f81632121_506;
// undefined
o190 = null;
// 14885
f81632121_506.returns.push("month_2012_3");
// 14888
o190 = {};
// 14889
o189["10"] = o190;
// 14890
o190.getAttribute = f81632121_506;
// undefined
o190 = null;
// 14891
f81632121_506.returns.push("month_2012_2");
// 14894
o190 = {};
// 14895
o189["11"] = o190;
// undefined
o189 = null;
// 14896
o190.getAttribute = f81632121_506;
// undefined
o190 = null;
// 14897
f81632121_506.returns.push("month_2012_1");
// 14902
f81632121_506.returns.push("2010s");
// 14905
o189 = {};
// 14906
o188["3"] = o189;
// 14907
o189.getAttribute = f81632121_506;
// 14908
f81632121_506.returns.push("year_2011");
// 14911
o189.getElementsByTagName = f81632121_502;
// 14913
o189.querySelectorAll = f81632121_504;
// undefined
o189 = null;
// 14914
o189 = {};
// 14915
f81632121_504.returns.push(o189);
// 14916
o189.length = 1;
// 14917
o190 = {};
// 14918
o189["0"] = o190;
// undefined
o189 = null;
// 14919
o189 = {};
// 14920
o190.childNodes = o189;
// undefined
o190 = null;
// 14921
o189.length = 12;
// 14922
o190 = {};
// 14923
o189["0"] = o190;
// 14924
o190.getAttribute = f81632121_506;
// undefined
o190 = null;
// 14925
f81632121_506.returns.push("month_2011_12");
// 14928
o190 = {};
// 14929
o189["1"] = o190;
// 14930
o190.getAttribute = f81632121_506;
// undefined
o190 = null;
// 14931
f81632121_506.returns.push("month_2011_11");
// 14934
o190 = {};
// 14935
o189["2"] = o190;
// 14936
o190.getAttribute = f81632121_506;
// undefined
o190 = null;
// 14937
f81632121_506.returns.push("month_2011_10");
// 14940
o190 = {};
// 14941
o189["3"] = o190;
// 14942
o190.getAttribute = f81632121_506;
// undefined
o190 = null;
// 14943
f81632121_506.returns.push("month_2011_9");
// 14946
o190 = {};
// 14947
o189["4"] = o190;
// 14948
o190.getAttribute = f81632121_506;
// undefined
o190 = null;
// 14949
f81632121_506.returns.push("month_2011_8");
// 14952
o190 = {};
// 14953
o189["5"] = o190;
// 14954
o190.getAttribute = f81632121_506;
// undefined
o190 = null;
// 14955
f81632121_506.returns.push("month_2011_7");
// 14958
o190 = {};
// 14959
o189["6"] = o190;
// 14960
o190.getAttribute = f81632121_506;
// undefined
o190 = null;
// 14961
f81632121_506.returns.push("month_2011_6");
// 14964
o190 = {};
// 14965
o189["7"] = o190;
// 14966
o190.getAttribute = f81632121_506;
// undefined
o190 = null;
// 14967
f81632121_506.returns.push("month_2011_5");
// 14970
o190 = {};
// 14971
o189["8"] = o190;
// 14972
o190.getAttribute = f81632121_506;
// undefined
o190 = null;
// 14973
f81632121_506.returns.push("month_2011_4");
// 14976
o190 = {};
// 14977
o189["9"] = o190;
// 14978
o190.getAttribute = f81632121_506;
// undefined
o190 = null;
// 14979
f81632121_506.returns.push("month_2011_3");
// 14982
o190 = {};
// 14983
o189["10"] = o190;
// 14984
o190.getAttribute = f81632121_506;
// undefined
o190 = null;
// 14985
f81632121_506.returns.push("month_2011_2");
// 14988
o190 = {};
// 14989
o189["11"] = o190;
// undefined
o189 = null;
// 14990
o190.getAttribute = f81632121_506;
// undefined
o190 = null;
// 14991
f81632121_506.returns.push("month_2011_1");
// 14996
f81632121_506.returns.push("2010s");
// 14999
o189 = {};
// 15000
o188["4"] = o189;
// 15001
o189.getAttribute = f81632121_506;
// 15002
f81632121_506.returns.push("year_2010");
// 15005
o189.getElementsByTagName = f81632121_502;
// 15007
o189.querySelectorAll = f81632121_504;
// undefined
o189 = null;
// 15008
o189 = {};
// 15009
f81632121_504.returns.push(o189);
// 15010
o189.length = 1;
// 15011
o190 = {};
// 15012
o189["0"] = o190;
// undefined
o189 = null;
// 15013
o189 = {};
// 15014
o190.childNodes = o189;
// undefined
o190 = null;
// 15015
o189.length = 12;
// 15016
o190 = {};
// 15017
o189["0"] = o190;
// 15018
o190.getAttribute = f81632121_506;
// undefined
o190 = null;
// 15019
f81632121_506.returns.push("month_2010_12");
// 15022
o190 = {};
// 15023
o189["1"] = o190;
// 15024
o190.getAttribute = f81632121_506;
// undefined
o190 = null;
// 15025
f81632121_506.returns.push("month_2010_11");
// 15028
o190 = {};
// 15029
o189["2"] = o190;
// 15030
o190.getAttribute = f81632121_506;
// undefined
o190 = null;
// 15031
f81632121_506.returns.push("month_2010_10");
// 15034
o190 = {};
// 15035
o189["3"] = o190;
// 15036
o190.getAttribute = f81632121_506;
// undefined
o190 = null;
// 15037
f81632121_506.returns.push("month_2010_9");
// 15040
o190 = {};
// 15041
o189["4"] = o190;
// 15042
o190.getAttribute = f81632121_506;
// undefined
o190 = null;
// 15043
f81632121_506.returns.push("month_2010_8");
// 15046
o190 = {};
// 15047
o189["5"] = o190;
// 15048
o190.getAttribute = f81632121_506;
// undefined
o190 = null;
// 15049
f81632121_506.returns.push("month_2010_7");
// 15052
o190 = {};
// 15053
o189["6"] = o190;
// 15054
o190.getAttribute = f81632121_506;
// undefined
o190 = null;
// 15055
f81632121_506.returns.push("month_2010_6");
// 15058
o190 = {};
// 15059
o189["7"] = o190;
// 15060
o190.getAttribute = f81632121_506;
// undefined
o190 = null;
// 15061
f81632121_506.returns.push("month_2010_5");
// 15064
o190 = {};
// 15065
o189["8"] = o190;
// 15066
o190.getAttribute = f81632121_506;
// undefined
o190 = null;
// 15067
f81632121_506.returns.push("month_2010_4");
// 15070
o190 = {};
// 15071
o189["9"] = o190;
// 15072
o190.getAttribute = f81632121_506;
// undefined
o190 = null;
// 15073
f81632121_506.returns.push("month_2010_3");
// 15076
o190 = {};
// 15077
o189["10"] = o190;
// 15078
o190.getAttribute = f81632121_506;
// undefined
o190 = null;
// 15079
f81632121_506.returns.push("month_2010_2");
// 15082
o190 = {};
// 15083
o189["11"] = o190;
// undefined
o189 = null;
// 15084
o190.getAttribute = f81632121_506;
// undefined
o190 = null;
// 15085
f81632121_506.returns.push("month_2010_1");
// 15090
f81632121_506.returns.push("2010s");
// 15093
o189 = {};
// 15094
o188["5"] = o189;
// 15095
o189.getAttribute = f81632121_506;
// 15096
f81632121_506.returns.push("year_2009");
// 15099
o189.getElementsByTagName = f81632121_502;
// 15101
o189.querySelectorAll = f81632121_504;
// undefined
o189 = null;
// 15102
o189 = {};
// 15103
f81632121_504.returns.push(o189);
// 15104
o189.length = 1;
// 15105
o190 = {};
// 15106
o189["0"] = o190;
// undefined
o189 = null;
// 15107
o189 = {};
// 15108
o190.childNodes = o189;
// undefined
o190 = null;
// 15109
o189.length = 12;
// 15110
o190 = {};
// 15111
o189["0"] = o190;
// 15112
o190.getAttribute = f81632121_506;
// undefined
o190 = null;
// 15113
f81632121_506.returns.push("month_2009_12");
// 15116
o190 = {};
// 15117
o189["1"] = o190;
// 15118
o190.getAttribute = f81632121_506;
// undefined
o190 = null;
// 15119
f81632121_506.returns.push("month_2009_11");
// 15122
o190 = {};
// 15123
o189["2"] = o190;
// 15124
o190.getAttribute = f81632121_506;
// undefined
o190 = null;
// 15125
f81632121_506.returns.push("month_2009_10");
// 15128
o190 = {};
// 15129
o189["3"] = o190;
// 15130
o190.getAttribute = f81632121_506;
// undefined
o190 = null;
// 15131
f81632121_506.returns.push("month_2009_9");
// 15134
o190 = {};
// 15135
o189["4"] = o190;
// 15136
o190.getAttribute = f81632121_506;
// undefined
o190 = null;
// 15137
f81632121_506.returns.push("month_2009_8");
// 15140
o190 = {};
// 15141
o189["5"] = o190;
// 15142
o190.getAttribute = f81632121_506;
// undefined
o190 = null;
// 15143
f81632121_506.returns.push("month_2009_7");
// 15146
o190 = {};
// 15147
o189["6"] = o190;
// 15148
o190.getAttribute = f81632121_506;
// undefined
o190 = null;
// 15149
f81632121_506.returns.push("month_2009_6");
// 15152
o190 = {};
// 15153
o189["7"] = o190;
// 15154
o190.getAttribute = f81632121_506;
// undefined
o190 = null;
// 15155
f81632121_506.returns.push("month_2009_5");
// 15158
o190 = {};
// 15159
o189["8"] = o190;
// 15160
o190.getAttribute = f81632121_506;
// undefined
o190 = null;
// 15161
f81632121_506.returns.push("month_2009_4");
// 15164
o190 = {};
// 15165
o189["9"] = o190;
// 15166
o190.getAttribute = f81632121_506;
// undefined
o190 = null;
// 15167
f81632121_506.returns.push("month_2009_3");
// 15170
o190 = {};
// 15171
o189["10"] = o190;
// 15172
o190.getAttribute = f81632121_506;
// undefined
o190 = null;
// 15173
f81632121_506.returns.push("month_2009_2");
// 15176
o190 = {};
// 15177
o189["11"] = o190;
// undefined
o189 = null;
// 15178
o190.getAttribute = f81632121_506;
// undefined
o190 = null;
// 15179
f81632121_506.returns.push("month_2009_1");
// 15184
f81632121_506.returns.push("2000s");
// 15187
o189 = {};
// 15188
o188["6"] = o189;
// 15189
o189.getAttribute = f81632121_506;
// 15190
f81632121_506.returns.push("year_2008");
// 15193
o189.getElementsByTagName = f81632121_502;
// 15195
o189.querySelectorAll = f81632121_504;
// undefined
o189 = null;
// 15196
o189 = {};
// 15197
f81632121_504.returns.push(o189);
// 15198
o189.length = 1;
// 15199
o190 = {};
// 15200
o189["0"] = o190;
// undefined
o189 = null;
// 15201
o189 = {};
// 15202
o190.childNodes = o189;
// undefined
o190 = null;
// 15203
o189.length = 12;
// 15204
o190 = {};
// 15205
o189["0"] = o190;
// 15206
o190.getAttribute = f81632121_506;
// undefined
o190 = null;
// 15207
f81632121_506.returns.push("month_2008_12");
// 15210
o190 = {};
// 15211
o189["1"] = o190;
// 15212
o190.getAttribute = f81632121_506;
// undefined
o190 = null;
// 15213
f81632121_506.returns.push("month_2008_11");
// 15216
o190 = {};
// 15217
o189["2"] = o190;
// 15218
o190.getAttribute = f81632121_506;
// undefined
o190 = null;
// 15219
f81632121_506.returns.push("month_2008_10");
// 15222
o190 = {};
// 15223
o189["3"] = o190;
// 15224
o190.getAttribute = f81632121_506;
// undefined
o190 = null;
// 15225
f81632121_506.returns.push("month_2008_9");
// 15228
o190 = {};
// 15229
o189["4"] = o190;
// 15230
o190.getAttribute = f81632121_506;
// undefined
o190 = null;
// 15231
f81632121_506.returns.push("month_2008_8");
// 15234
o190 = {};
// 15235
o189["5"] = o190;
// 15236
o190.getAttribute = f81632121_506;
// undefined
o190 = null;
// 15237
f81632121_506.returns.push("month_2008_7");
// 15240
o190 = {};
// 15241
o189["6"] = o190;
// 15242
o190.getAttribute = f81632121_506;
// undefined
o190 = null;
// 15243
f81632121_506.returns.push("month_2008_6");
// 15246
o190 = {};
// 15247
o189["7"] = o190;
// 15248
o190.getAttribute = f81632121_506;
// undefined
o190 = null;
// 15249
f81632121_506.returns.push("month_2008_5");
// 15252
o190 = {};
// 15253
o189["8"] = o190;
// 15254
o190.getAttribute = f81632121_506;
// undefined
o190 = null;
// 15255
f81632121_506.returns.push("month_2008_4");
// 15258
o190 = {};
// 15259
o189["9"] = o190;
// 15260
o190.getAttribute = f81632121_506;
// undefined
o190 = null;
// 15261
f81632121_506.returns.push("month_2008_3");
// 15264
o190 = {};
// 15265
o189["10"] = o190;
// 15266
o190.getAttribute = f81632121_506;
// undefined
o190 = null;
// 15267
f81632121_506.returns.push("month_2008_2");
// 15270
o190 = {};
// 15271
o189["11"] = o190;
// undefined
o189 = null;
// 15272
o190.getAttribute = f81632121_506;
// undefined
o190 = null;
// 15273
f81632121_506.returns.push("month_2008_1");
// 15278
f81632121_506.returns.push("2000s");
// 15281
o189 = {};
// 15282
o188["7"] = o189;
// undefined
o188 = null;
// 15283
o189.getAttribute = f81632121_506;
// 15284
f81632121_506.returns.push("way_back");
// 15287
o189.getElementsByTagName = f81632121_502;
// 15289
o189.querySelectorAll = f81632121_504;
// undefined
o189 = null;
// 15290
o188 = {};
// 15291
f81632121_504.returns.push(o188);
// 15292
o188.length = 0;
// undefined
o188 = null;
// 15295
f81632121_506.returns.push(null);
// 15297
o95.nodeName = "UL";
// 15298
o95.__FB_TOKEN = void 0;
// 15299
// 15300
o95.getAttribute = f81632121_506;
// 15301
o95.hasAttribute = f81632121_507;
// 15303
f81632121_507.returns.push(false);
// 15304
o95.JSBNG__addEventListener = f81632121_468;
// 15306
f81632121_468.returns.push(undefined);
// 15307
o95.JSBNG__onclick = null;
// 15312
f81632121_468.returns.push(undefined);
// 15313
o95.JSBNG__onkeydown = null;
// 15315
o95.getElementsByTagName = f81632121_502;
// 15317
o95.querySelectorAll = f81632121_504;
// 15318
o188 = {};
// 15319
f81632121_504.returns.push(o188);
// 15320
o188.length = 69;
// 15321
o189 = {};
// 15322
o188["0"] = o189;
// undefined
o189 = null;
// 15323
o189 = {};
// 15324
o188["1"] = o189;
// undefined
o189 = null;
// 15325
o189 = {};
// 15326
o188["2"] = o189;
// undefined
o189 = null;
// 15327
o189 = {};
// 15328
o188["3"] = o189;
// undefined
o189 = null;
// 15329
o189 = {};
// 15330
o188["4"] = o189;
// undefined
o189 = null;
// 15331
o189 = {};
// 15332
o188["5"] = o189;
// undefined
o189 = null;
// 15333
o189 = {};
// 15334
o188["6"] = o189;
// undefined
o189 = null;
// 15335
o189 = {};
// 15336
o188["7"] = o189;
// undefined
o189 = null;
// 15337
o189 = {};
// 15338
o188["8"] = o189;
// undefined
o189 = null;
// 15339
o189 = {};
// 15340
o188["9"] = o189;
// undefined
o189 = null;
// 15341
o189 = {};
// 15342
o188["10"] = o189;
// undefined
o189 = null;
// 15343
o189 = {};
// 15344
o188["11"] = o189;
// undefined
o189 = null;
// 15345
o189 = {};
// 15346
o188["12"] = o189;
// undefined
o189 = null;
// 15347
o189 = {};
// 15348
o188["13"] = o189;
// undefined
o189 = null;
// 15349
o189 = {};
// 15350
o188["14"] = o189;
// undefined
o189 = null;
// 15351
o189 = {};
// 15352
o188["15"] = o189;
// undefined
o189 = null;
// 15353
o189 = {};
// 15354
o188["16"] = o189;
// undefined
o189 = null;
// 15355
o189 = {};
// 15356
o188["17"] = o189;
// undefined
o189 = null;
// 15357
o189 = {};
// 15358
o188["18"] = o189;
// undefined
o189 = null;
// 15359
o189 = {};
// 15360
o188["19"] = o189;
// undefined
o189 = null;
// 15361
o189 = {};
// 15362
o188["20"] = o189;
// undefined
o189 = null;
// 15363
o189 = {};
// 15364
o188["21"] = o189;
// undefined
o189 = null;
// 15365
o189 = {};
// 15366
o188["22"] = o189;
// undefined
o189 = null;
// 15367
o189 = {};
// 15368
o188["23"] = o189;
// undefined
o189 = null;
// 15369
o189 = {};
// 15370
o188["24"] = o189;
// undefined
o189 = null;
// 15371
o189 = {};
// 15372
o188["25"] = o189;
// undefined
o189 = null;
// 15373
o189 = {};
// 15374
o188["26"] = o189;
// undefined
o189 = null;
// 15375
o189 = {};
// 15376
o188["27"] = o189;
// undefined
o189 = null;
// 15377
o189 = {};
// 15378
o188["28"] = o189;
// undefined
o189 = null;
// 15379
o189 = {};
// 15380
o188["29"] = o189;
// undefined
o189 = null;
// 15381
o189 = {};
// 15382
o188["30"] = o189;
// undefined
o189 = null;
// 15383
o189 = {};
// 15384
o188["31"] = o189;
// undefined
o189 = null;
// 15385
o189 = {};
// 15386
o188["32"] = o189;
// undefined
o189 = null;
// 15387
o189 = {};
// 15388
o188["33"] = o189;
// undefined
o189 = null;
// 15389
o189 = {};
// 15390
o188["34"] = o189;
// undefined
o189 = null;
// 15391
o189 = {};
// 15392
o188["35"] = o189;
// undefined
o189 = null;
// 15393
o189 = {};
// 15394
o188["36"] = o189;
// undefined
o189 = null;
// 15395
o189 = {};
// 15396
o188["37"] = o189;
// undefined
o189 = null;
// 15397
o189 = {};
// 15398
o188["38"] = o189;
// undefined
o189 = null;
// 15399
o189 = {};
// 15400
o188["39"] = o189;
// undefined
o189 = null;
// 15401
o189 = {};
// 15402
o188["40"] = o189;
// undefined
o189 = null;
// 15403
o189 = {};
// 15404
o188["41"] = o189;
// undefined
o189 = null;
// 15405
o189 = {};
// 15406
o188["42"] = o189;
// undefined
o189 = null;
// 15407
o189 = {};
// 15408
o188["43"] = o189;
// undefined
o189 = null;
// 15409
o189 = {};
// 15410
o188["44"] = o189;
// undefined
o189 = null;
// 15411
o189 = {};
// 15412
o188["45"] = o189;
// undefined
o189 = null;
// 15413
o189 = {};
// 15414
o188["46"] = o189;
// undefined
o189 = null;
// 15415
o189 = {};
// 15416
o188["47"] = o189;
// undefined
o189 = null;
// 15417
o189 = {};
// 15418
o188["48"] = o189;
// undefined
o189 = null;
// 15419
o189 = {};
// 15420
o188["49"] = o189;
// undefined
o189 = null;
// 15421
o189 = {};
// 15422
o188["50"] = o189;
// undefined
o189 = null;
// 15423
o189 = {};
// 15424
o188["51"] = o189;
// undefined
o189 = null;
// 15425
o189 = {};
// 15426
o188["52"] = o189;
// undefined
o189 = null;
// 15427
o189 = {};
// 15428
o188["53"] = o189;
// undefined
o189 = null;
// 15429
o189 = {};
// 15430
o188["54"] = o189;
// undefined
o189 = null;
// 15431
o189 = {};
// 15432
o188["55"] = o189;
// undefined
o189 = null;
// 15433
o189 = {};
// 15434
o188["56"] = o189;
// undefined
o189 = null;
// 15435
o189 = {};
// 15436
o188["57"] = o189;
// undefined
o189 = null;
// 15437
o189 = {};
// 15438
o188["58"] = o189;
// undefined
o189 = null;
// 15439
o189 = {};
// 15440
o188["59"] = o189;
// undefined
o189 = null;
// 15441
o189 = {};
// 15442
o188["60"] = o189;
// undefined
o189 = null;
// 15443
o189 = {};
// 15444
o188["61"] = o189;
// undefined
o189 = null;
// 15445
o189 = {};
// 15446
o188["62"] = o189;
// undefined
o189 = null;
// 15447
o189 = {};
// 15448
o188["63"] = o189;
// undefined
o189 = null;
// 15449
o189 = {};
// 15450
o188["64"] = o189;
// undefined
o189 = null;
// 15451
o189 = {};
// 15452
o188["65"] = o189;
// undefined
o189 = null;
// 15453
o189 = {};
// 15454
o188["66"] = o189;
// undefined
o189 = null;
// 15455
o189 = {};
// 15456
o188["67"] = o189;
// undefined
o189 = null;
// 15457
o189 = {};
// 15458
o188["68"] = o189;
// undefined
o188 = null;
// undefined
o189 = null;
// 15459
o188 = {};
// 15460
o95.classList = o188;
// 15462
o188.remove = f81632121_1114;
// undefined
o188 = null;
// 15463
f81632121_1114.returns.push(undefined);
// 15466
o95.offsetHeight = 200;
// 15470
f81632121_1114.returns.push(undefined);
// 15475
f81632121_513.returns.push(false);
// 15477
f81632121_508.returns.push(o86);
// 15478
o188 = {};
// 15479
o86.classList = o188;
// 15481
o188.contains = f81632121_513;
// undefined
o188 = null;
// 15482
f81632121_513.returns.push(false);
// 15483
o95.parentNode = o86;
// undefined
o95 = null;
// undefined
o86 = null;
// 15485
f81632121_467.returns.push(1374851241334);
// 15493
o86 = {};
// 15494
f81632121_476.returns.push(o86);
// 15495
// 15496
// 15497
o86.getElementsByTagName = f81632121_502;
// 15498
o95 = {};
// 15499
f81632121_502.returns.push(o95);
// 15500
o95.length = 0;
// undefined
o95 = null;
// 15502
o95 = {};
// 15503
o86.childNodes = o95;
// undefined
o86 = null;
// 15504
o95.nodeType = void 0;
// 15505
o95.__html = void 0;
// 15506
o95.mountComponentIntoNode = void 0;
// 15507
o95.classList = void 0;
// 15509
o95.className = void 0;
// 15511
// 15512
o95.__FB_TOKEN = void 0;
// 15513
// 15514
o95.getElementsByTagName = void 0;
// 15517
// 15521
o86 = {};
// 15522
f81632121_474.returns.push(o86);
// 15526
f81632121_478.returns.push(o86);
// undefined
o86 = null;
// 15527
o95.getAttribute = void 0;
// 15544
// 15557
// 15565
o86 = {};
// 15566
f81632121_476.returns.push(o86);
// 15567
// 15568
o86.__html = void 0;
// undefined
o86 = null;
// 15570
o86 = {};
// 15571
f81632121_474.returns.push(o86);
// undefined
o86 = null;
// 15573
o95.appendChild = void 0;
// undefined
o95 = null;
// 15578
f81632121_467.returns.push(1374851241385);
// 15581
o86 = {};
// 15582
f81632121_476.returns.push(o86);
// 15583
// 15584
// 15585
o86.getElementsByTagName = f81632121_502;
// 15586
o95 = {};
// 15587
f81632121_502.returns.push(o95);
// 15588
o95.length = 0;
// undefined
o95 = null;
// 15590
o95 = {};
// 15591
o86.childNodes = o95;
// undefined
o86 = null;
// 15592
o95.nodeType = void 0;
// 15593
o95.__html = void 0;
// 15594
o95.mountComponentIntoNode = void 0;
// 15595
o95.classList = void 0;
// 15597
o95.className = void 0;
// 15599
// 15600
o95.__FB_TOKEN = void 0;
// 15601
// 15602
o95.getElementsByTagName = void 0;
// 15605
// 15609
o86 = {};
// 15610
f81632121_474.returns.push(o86);
// 15614
f81632121_478.returns.push(o86);
// undefined
o86 = null;
// 15615
o95.getAttribute = void 0;
// 15632
// 15645
// 15653
o86 = {};
// 15654
f81632121_476.returns.push(o86);
// 15655
// 15656
o86.__html = void 0;
// undefined
o86 = null;
// 15658
o86 = {};
// 15659
f81632121_474.returns.push(o86);
// undefined
o86 = null;
// 15661
o95.appendChild = void 0;
// undefined
o95 = null;
// 15664
o86 = {};
// 15665
o95 = {};
// 15667
o86.nodeType = void 0;
// 15668
o86.length = 1;
// 15669
o86["0"] = "bmJBG";
// 15676
o188 = {};
// 15677
f81632121_508.returns.push(o188);
// 15678
o188.getAttribute = f81632121_506;
// 15679
f81632121_506.returns.push(null);
// 15680
o188.setAttribute = f81632121_575;
// 15681
f81632121_575.returns.push(undefined);
// 15682
f81632121_12.returns.push(56);
// 15691
o189 = {};
// 15692
o190 = {};
// 15694
o189.nodeType = void 0;
// 15695
o189.length = 1;
// 15696
o189["0"] = "dm/WP";
// 15699
f81632121_467.returns.push(1374851241441);
// 15702
f81632121_467.returns.push(1374851241442);
// 15705
f81632121_508.returns.push(o56);
// 15706
o56.__FB_TOKEN = void 0;
// 15707
// 15710
f81632121_508.returns.push(o57);
// 15711
o57.__FB_TOKEN = void 0;
// 15712
// undefined
o57 = null;
// 15715
f81632121_508.returns.push(o58);
// 15716
o58.__FB_TOKEN = void 0;
// 15717
// undefined
o58 = null;
// 15720
f81632121_508.returns.push(o59);
// 15721
o59.__FB_TOKEN = void 0;
// 15722
// undefined
o59 = null;
// 15725
f81632121_508.returns.push(o75);
// 15726
o75.__FB_TOKEN = void 0;
// 15727
// undefined
o75 = null;
// 15729
f81632121_467.returns.push(1374851241443);
// 15732
o51.offsetHeight = 136;
// undefined
o51 = null;
// 15733
f81632121_575.returns.push(undefined);
// 15735
o47.offsetHeight = 174;
// 15736
f81632121_575.returns.push(undefined);
// 15738
o76.clearStatusIndicator = f81632121_1347;
// 15739
o76.getStatusElement = f81632121_1348;
// 15740
o76.statusElement = null;
// 15741
f81632121_1348.returns.push(null);
// 15742
f81632121_1347.returns.push(undefined);
// 15745
f81632121_1340.returns.push(true);
// 15746
o76.initialHandler = f81632121_1349;
// 15747
f81632121_1349.returns.push(undefined);
// 15748
o76.timer = null;
// 15749
f81632121_14.returns.push(undefined);
// 15751
o76._handleJSResponse = f81632121_1351;
// 15752
o76.getRelativeTo = f81632121_1352;
// 15753
o76.relativeTo = null;
// 15754
f81632121_1352.returns.push(null);
// 15755
o76._handleJSRegisters = f81632121_1353;
// 15756
f81632121_1353.returns.push(undefined);
// 15757
o76.lid = void 0;
// 15759
f81632121_1353.returns.push(undefined);
// 15760
f81632121_1351.returns.push(undefined);
// 15761
o76.finallyHandler = f81632121_1349;
// 15762
f81632121_1349.returns.push(undefined);
// 15763
f81632121_1341.returns.push(undefined);
// 15765
o49.offsetHeight = 201;
// undefined
o49 = null;
// 15766
f81632121_575.returns.push(undefined);
// 15768
o48.offsetHeight = 214;
// undefined
o48 = null;
// 15769
f81632121_575.returns.push(undefined);
// 15771
o50.offsetHeight = 240;
// undefined
o50 = null;
// 15772
f81632121_575.returns.push(undefined);
// 15774
f81632121_467.returns.push(1374851241448);
// undefined
fo81632121_1_cookie.returns.push("c_user=100006118350059; csm=2");
// 15778
f81632121_467.returns.push(1374851241449);
// 15779
o137.offsetTop = 0;
// 15782
o79.add = f81632121_602;
// undefined
o79 = null;
// 15783
f81632121_602.returns.push(undefined);
// 15784
f81632121_463.returns.push(5);
// undefined
fo81632121_1_cookie.returns.push("c_user=100006118350059; csm=2");
// 15792
f81632121_467.returns.push(1374851243809);
// 15793
f81632121_13.returns.push(57);
// 15795
f81632121_467.returns.push(1374851243810);
// 15796
f81632121_466.returns.push(0.8382938504219055);
// 15798
f81632121_467.returns.push(1374851243810);
// 15801
f81632121_467.returns.push(1374851243810);
// 15803
f81632121_466.returns.push(0.39578074193559587);
// undefined
fo81632121_1_cookie.returns.push("c_user=100006118350059; csm=2");
// 15806
// 15807
f81632121_2117 = function() { return f81632121_2117.returns[f81632121_2117.inst++]; };
f81632121_2117.returns = [];
f81632121_2117.inst = 0;
// 15808
ow81632121.JSBNG__onpageshow = f81632121_2117;
// 15809
f81632121_7.returns.push(undefined);
// 15810
f81632121_2118 = function() { return f81632121_2118.returns[f81632121_2118.inst++]; };
f81632121_2118.returns = [];
f81632121_2118.inst = 0;
// 15811
ow81632121.JSBNG__onpagehide = f81632121_2118;
// 15814
o48 = {};
// 15815
f81632121_0.returns.push(o48);
// undefined
o48 = null;
// undefined
fo81632121_1_cookie.returns.push("c_user=100006118350059; csm=2; sub=4096");
// 15817
f81632121_14.returns.push(undefined);
// 15818
o48 = {};
// 15819
f81632121_0.returns.push(o48);
// undefined
o48 = null;
// 15820
o48 = {};
// 15821
f81632121_0.returns.push(o48);
// undefined
o48 = null;
// 15822
o48 = {};
// 15823
f81632121_0.returns.push(o48);
// undefined
o48 = null;
// undefined
fo81632121_1_cookie.returns.push("c_user=100006118350059; csm=2; sub=4096");
// 15825
o48 = {};
// 15826
f81632121_70.returns.push(o48);
// 15827
o48.open = f81632121_1294;
// 15828
f81632121_1294.returns.push(undefined);
// 15829
// 15830
f81632121_12.returns.push(58);
// 15832
f81632121_467.returns.push(1374851243816);
// 15833
o48.send = f81632121_1296;
// 15834
f81632121_1296.returns.push(undefined);
// 15837
f81632121_467.returns.push(1374851243816);
// 15839
f81632121_467.returns.push(1374851243818);
// 15841
f81632121_467.returns.push(1374851243818);
// 15842
f81632121_13.returns.push(59);
// 15843
f81632121_13.returns.push(60);
// 15845
f81632121_467.returns.push(1374851243819);
// 15846
f81632121_12.returns.push(61);
// 15848
f81632121_12.returns.push(62);
// 15849
f81632121_12.returns.push(63);
// 15850
f81632121_12.returns.push(64);
// 15851
f81632121_12.returns.push(65);
// 15852
f81632121_12.returns.push(66);
// 15854
f81632121_467.returns.push(1374851243824);
// 15855
f81632121_466.returns.push(0.9318111049942672);
// 15857
f81632121_467.returns.push(1374851243825);
// 15859
f81632121_467.returns.push(1374851243825);
// 15861
f81632121_467.returns.push(1374851243825);
// 15862
f81632121_14.returns.push(undefined);
// 15863
f81632121_12.returns.push(67);
// 15864
f81632121_12.returns.push(68);
// 15868
o49 = {};
// 15869
f81632121_508.returns.push(o49);
// 15872
f81632121_467.returns.push(1374851243830);
// 15874
o50 = {};
// 15875
f81632121_508.returns.push(o50);
// 15876
o50.__FB_TOKEN = void 0;
// 15877
// 15878
o49.getElementsByTagName = f81632121_502;
// 15880
o49.querySelectorAll = f81632121_504;
// 15881
o51 = {};
// 15882
f81632121_504.returns.push(o51);
// 15883
o51.length = 0;
// undefined
o51 = null;
// 15887
o51 = {};
// 15888
f81632121_504.returns.push(o51);
// 15889
o51.length = 0;
// undefined
o51 = null;
// 15894
f81632121_467.returns.push(1374851243841);
// 15899
f81632121_467.returns.push(1374851243841);
// 15907
f81632121_1852.returns.push(undefined);
// 15909
f81632121_14.returns.push(undefined);
// 15910
f81632121_12.returns.push(69);
// 15913
o51 = {};
// 15914
f81632121_508.returns.push(o51);
// 15915
o51.nodeName = "BUTTON";
// 15916
o51.__FB_TOKEN = void 0;
// 15917
// 15918
o51.getAttribute = f81632121_506;
// 15919
o51.hasAttribute = f81632121_507;
// 15921
f81632121_507.returns.push(false);
// 15922
o51.JSBNG__addEventListener = f81632121_468;
// 15924
f81632121_468.returns.push(undefined);
// 15925
f81632121_2129 = function() { return f81632121_2129.returns[f81632121_2129.inst++]; };
f81632121_2129.returns = [];
f81632121_2129.inst = 0;
// 15926
o51.JSBNG__onclick = f81632121_2129;
// 15929
// undefined
o51 = null;
// 15934
o51 = {};
// 15935
f81632121_508.returns.push(o51);
// 15938
f81632121_467.returns.push(1374851243845);
// 15940
o57 = {};
// 15941
f81632121_508.returns.push(o57);
// 15942
o57.__FB_TOKEN = void 0;
// 15943
// undefined
o57 = null;
// 15944
o51.getElementsByTagName = f81632121_502;
// 15946
o51.querySelectorAll = f81632121_504;
// undefined
o51 = null;
// 15947
o51 = {};
// 15948
f81632121_504.returns.push(o51);
// 15949
o51.length = 0;
// undefined
o51 = null;
// 15953
o51 = {};
// 15954
f81632121_504.returns.push(o51);
// 15955
o51.length = 0;
// undefined
o51 = null;
// 15960
f81632121_467.returns.push(1374851243846);
// 15967
f81632121_1852.returns.push(undefined);
// 15969
f81632121_14.returns.push(undefined);
// 15970
f81632121_12.returns.push(70);
// 15973
o51 = {};
// 15974
f81632121_508.returns.push(o51);
// 15975
o51.nodeName = "BUTTON";
// 15976
o51.__FB_TOKEN = void 0;
// 15977
// 15978
o51.getAttribute = f81632121_506;
// 15979
o51.hasAttribute = f81632121_507;
// 15981
f81632121_507.returns.push(false);
// 15982
o51.JSBNG__addEventListener = f81632121_468;
// 15984
f81632121_468.returns.push(undefined);
// 15985
f81632121_2135 = function() { return f81632121_2135.returns[f81632121_2135.inst++]; };
f81632121_2135.returns = [];
f81632121_2135.inst = 0;
// 15986
o51.JSBNG__onclick = f81632121_2135;
// 15989
// undefined
o51 = null;
// 15994
o51 = {};
// 15995
o57 = {};
// 15997
o51.nodeType = void 0;
// 15998
o51.length = 1;
// 15999
o51["0"] = "TXKLp";
// 16005
f81632121_466.returns.push(0.1571649736724794);
// 16007
f81632121_12.returns.push(71);
// 16008
f81632121_12.returns.push(72);
// 16009
f81632121_12.returns.push(73);
// 16010
f81632121_12.returns.push(74);
// 16011
f81632121_12.returns.push(75);
// 16015
o58 = {};
// 16016
o59 = {};
// 16018
o58.nodeType = void 0;
// 16019
o58.length = 1;
// 16020
o58["0"] = "1YKDj";
// 16022
o75 = {};
// 16024
o75._polling = false;
// 16025
// 16026
f81632121_2141 = function() { return f81632121_2141.returns[f81632121_2141.inst++]; };
f81632121_2141.returns = [];
f81632121_2141.inst = 0;
// 16027
o75.request = f81632121_2141;
// 16028
o75._cancelRequest = f81632121_1349;
// 16029
f81632121_1349.returns.push(undefined);
// 16030
// undefined
fo81632121_1_cookie.returns.push("c_user=100006118350059; csm=2; sub=4096");
// 16032
o75._muted = false;
// 16033
o79 = {};
// 16034
o75._config = o79;
// 16035
o79.maxRequests = Infinity;
// 16036
// 16038
f81632121_2143 = function() { return f81632121_2143.returns[f81632121_2143.inst++]; };
f81632121_2143.returns = [];
f81632121_2143.inst = 0;
// 16039
o79.setupRequest = f81632121_2143;
// undefined
o79 = null;
// 16040
f81632121_2143.returns.push(undefined);
// 16041
o75._skip = false;
// 16042
f81632121_2141.returns.push(o75);
// undefined
fo81632121_1_cookie.returns.push("c_user=100006118350059; csm=2; sub=4096");
// 16046
f81632121_467.returns.push(1374851243914);
// 16048
o46.offsetTop = 43;
// 16049
o46.scrollHeight = 48;
// undefined
o46 = null;
// 16051
f81632121_1418.returns.push({__JSBNG_unknown_function:true});
// 16057
o46 = {};
// 16058
f81632121_508.returns.push(o46);
// 16060
o79 = {};
// 16061
f81632121_508.returns.push(o79);
// 16062
o191 = {};
// 16063
o192 = {};
// 16065
o191.nodeType = void 0;
// 16066
o191.length = 1;
// 16067
o191["0"] = "cmK7/";
// 16072
o193 = {};
// 16073
o194 = {};
// 16075
o193.nodeType = void 0;
// 16076
o193.length = 1;
// 16077
o193["0"] = "4/uwC";
// 16079
o195 = {};
// 16080
o196 = {};
// undefined
o196 = null;
// 16081
f81632121_2152 = function() { return f81632121_2152.returns[f81632121_2152.inst++]; };
f81632121_2152.returns = [];
f81632121_2152.inst = 0;
// 16082
o195._onReadyState = f81632121_2152;
// 16084
o195.xhr = o48;
// 16086
o48.readyState = 2;
// 16087
o195.JSBNG__status = null;
// 16088
f81632121_2153 = function() { return f81632121_2153.returns[f81632121_2153.inst++]; };
f81632121_2153.returns = [];
f81632121_2153.inst = 0;
// 16089
o195._parseStatus = f81632121_2153;
// 16091
o48.JSBNG__status = 404;
// 16092
// 16094
o48.statusText = "Not Found";
// 16104
// 16105
o195.errorText = void 0;
// 16106
// 16107
f81632121_2153.returns.push(undefined);
// 16109
f81632121_467.returns.push(1374851244103);
// 16110
o195._sentAt = 1374851243816;
// 16111
// 16112
f81632121_2154 = function() { return f81632121_2154.returns[f81632121_2154.inst++]; };
f81632121_2154.returns = [];
f81632121_2154.inst = 0;
// 16113
o195._call = f81632121_2154;
// 16114
f81632121_2155 = function() { return f81632121_2155.returns[f81632121_2155.inst++]; };
f81632121_2155.returns = [];
f81632121_2155.inst = 0;
// 16115
o195.onError = f81632121_2155;
// 16117
f81632121_2155.returns.push(undefined);
// 16118
f81632121_2154.returns.push(undefined);
// 16119
// 16120
// 16121
// 16122
o195._timer = 58;
// 16123
f81632121_14.returns.push(undefined);
// 16128
f81632121_2156 = function() { return f81632121_2156.returns[f81632121_2156.inst++]; };
f81632121_2156.returns = [];
f81632121_2156.inst = 0;
// 16129
o48.abort = f81632121_2156;
// undefined
o48 = null;
// 16130
f81632121_2156.returns.push(undefined);
// 16131
// 16132
f81632121_2152.returns.push(undefined);
// 16133
o48 = {};
// undefined
o48 = null;
// 16138
f81632121_467.returns.push(1374851244104);
// 16140
// 16142
f81632121_2154.returns.push(undefined);
// 16143
// 16144
// 16145
// 16147
f81632121_14.returns.push(undefined);
// 16148
f81632121_2152.returns.push(undefined);
// 16154
o48 = {};
// 16155
f81632121_508.returns.push(o48);
// undefined
o48 = null;
// 16159
o48 = {};
// 16160
f81632121_503.returns.push(o48);
// 16161
o48.length = 0;
// undefined
o48 = null;
// 16162
f81632121_2160 = function() { return f81632121_2160.returns[f81632121_2160.inst++]; };
f81632121_2160.returns = [];
f81632121_2160.inst = 0;
// 16163
o6.checkPermission = f81632121_2160;
// undefined
o6 = null;
// 16164
f81632121_2160.returns.push(1);
// 16168
o6 = {};
// 16169
f81632121_503.returns.push(o6);
// 16170
o6.length = 0;
// undefined
o6 = null;
// 16174
o6 = {};
// 16175
f81632121_508.returns.push(o6);
// undefined
o6 = null;
// 16179
o6 = {};
// 16180
f81632121_503.returns.push(o6);
// 16181
o6.length = 0;
// undefined
o6 = null;
// 16183
f81632121_2160.returns.push(1);
// 16187
o6 = {};
// 16188
f81632121_503.returns.push(o6);
// 16189
o6.length = 0;
// undefined
o6 = null;
// 16192
o6 = {};
// 16193
f81632121_508.returns.push(o6);
// 16196
o6.offsetWidth = 220;
// 16197
o6.offsetHeight = 25;
// 16199
f81632121_508.returns.push(o137);
// undefined
o137 = null;
// 16203
f81632121_645.returns.push(true);
// 16204
o48 = {};
// 16205
f81632121_4.returns.push(o48);
// 16206
o48.getPropertyValue = f81632121_1442;
// undefined
o48 = null;
// 16207
f81632121_1442.returns.push("fixed");
// 16211
f81632121_645.returns.push(true);
// 16213
o48 = {};
// 16214
f81632121_1481.returns.push(o48);
// 16215
o48.left = 0;
// 16217
o48.JSBNG__top = 0;
// undefined
o48 = null;
// 16221
o6.getElementsByTagName = f81632121_502;
// 16223
o6.querySelectorAll = f81632121_504;
// 16224
o48 = {};
// 16225
f81632121_504.returns.push(o48);
// 16226
o48.length = 6;
// 16227
o137 = {};
// 16228
o48["0"] = o137;
// 16229
o196 = {};
// 16230
o48["1"] = o196;
// 16231
o197 = {};
// 16232
o48["2"] = o197;
// 16233
o198 = {};
// 16234
o48["3"] = o198;
// 16235
o199 = {};
// 16236
o48["4"] = o199;
// 16237
o200 = {};
// 16238
o48["5"] = o200;
// undefined
o48 = null;
// 16239
o137.getAttribute = f81632121_506;
// 16240
f81632121_506.returns.push("#");
// 16241
o196.getAttribute = f81632121_506;
// 16242
f81632121_506.returns.push("#");
// 16243
o197.getAttribute = f81632121_506;
// 16244
f81632121_506.returns.push("#");
// 16245
o198.getAttribute = f81632121_506;
// undefined
o198 = null;
// 16246
f81632121_506.returns.push("/ajax/chat/privacy/settings_dialog.php");
// 16247
o199.getAttribute = f81632121_506;
// 16248
f81632121_506.returns.push("#");
// 16249
o200.getAttribute = f81632121_506;
// undefined
o200 = null;
// 16250
f81632121_506.returns.push("/ajax/chat/privacy/turn_off_dialog.php");
// 16251
o137.removeAttribute = f81632121_576;
// 16252
f81632121_576.returns.push(undefined);
// 16253
o137.setAttribute = f81632121_575;
// 16254
f81632121_575.returns.push(undefined);
// 16255
o196.removeAttribute = f81632121_576;
// 16256
f81632121_576.returns.push(undefined);
// 16257
o196.setAttribute = f81632121_575;
// undefined
o196 = null;
// 16258
f81632121_575.returns.push(undefined);
// 16259
o197.removeAttribute = f81632121_576;
// 16260
f81632121_576.returns.push(undefined);
// 16261
o197.setAttribute = f81632121_575;
// undefined
o197 = null;
// 16262
f81632121_575.returns.push(undefined);
// 16263
o199.removeAttribute = f81632121_576;
// 16264
f81632121_576.returns.push(undefined);
// 16265
o199.setAttribute = f81632121_575;
// undefined
o199 = null;
// 16266
f81632121_575.returns.push(undefined);
// 16267
o6.nodeName = "DIV";
// 16268
o6.__FB_TOKEN = void 0;
// 16269
// 16270
o6.getAttribute = f81632121_506;
// 16271
o6.hasAttribute = f81632121_507;
// 16273
f81632121_507.returns.push(false);
// 16274
o6.JSBNG__addEventListener = f81632121_468;
// 16276
f81632121_468.returns.push(undefined);
// 16277
o6.JSBNG__onclick = null;
// 16281
f81632121_467.returns.push(1374851244222);
// 16286
o48 = {};
// 16287
f81632121_508.returns.push(o48);
// 16289
o196 = {};
// 16290
f81632121_476.returns.push(o196);
// 16291
// 16292
// 16293
o196.getElementsByTagName = f81632121_502;
// 16294
o197 = {};
// 16295
f81632121_502.returns.push(o197);
// 16296
o197.length = 0;
// undefined
o197 = null;
// 16298
o197 = {};
// 16299
o196.childNodes = o197;
// undefined
o196 = null;
// 16300
o197.nodeType = void 0;
// undefined
o197 = null;
// 16302
o196 = {};
// 16303
f81632121_476.returns.push(o196);
// 16304
// 16305
// 16306
o196.getElementsByTagName = f81632121_502;
// 16307
o197 = {};
// 16308
f81632121_502.returns.push(o197);
// 16309
o197.length = 0;
// undefined
o197 = null;
// 16311
o197 = {};
// 16312
o196.childNodes = o197;
// undefined
o196 = null;
// 16313
o197.nodeType = void 0;
// undefined
o197 = null;
// 16314
o196 = {};
// 16315
o48.classList = o196;
// 16317
o196.contains = f81632121_513;
// undefined
o196 = null;
// 16318
f81632121_513.returns.push(false);
// 16319
o48.parentNode = o71;
// 16320
o196 = {};
// 16321
o71.classList = o196;
// 16323
o196.contains = f81632121_513;
// undefined
o196 = null;
// 16324
f81632121_513.returns.push(false);
// 16325
o71.parentNode = o68;
// undefined
o71 = null;
// 16326
o71 = {};
// 16327
o68.classList = o71;
// 16329
o71.contains = f81632121_513;
// undefined
o71 = null;
// 16330
f81632121_513.returns.push(false);
// 16331
o68.parentNode = o67;
// undefined
o68 = null;
// 16332
o68 = {};
// 16333
o67.classList = o68;
// 16335
o68.contains = f81632121_513;
// undefined
o68 = null;
// 16336
f81632121_513.returns.push(false);
// 16337
o67.parentNode = o65;
// 16340
o66.contains = f81632121_513;
// undefined
o66 = null;
// 16341
f81632121_513.returns.push(false);
// 16342
o66 = {};
// 16343
o65.parentNode = o66;
// undefined
o65 = null;
// 16344
o65 = {};
// 16345
o66.classList = o65;
// 16347
o65.contains = f81632121_513;
// undefined
o65 = null;
// 16348
f81632121_513.returns.push(false);
// 16349
o65 = {};
// 16350
o66.parentNode = o65;
// 16351
o68 = {};
// 16352
o65.classList = o68;
// 16354
o68.contains = f81632121_513;
// 16355
f81632121_513.returns.push(false);
// 16356
o65.parentNode = o64;
// 16357
o71 = {};
// 16358
o64.classList = o71;
// 16360
o71.contains = f81632121_513;
// undefined
o71 = null;
// 16361
f81632121_513.returns.push(false);
// 16362
o64.parentNode = o82;
// undefined
o64 = null;
// 16366
f81632121_513.returns.push(false);
// 16371
f81632121_513.returns.push(false);
// 16376
f81632121_513.returns.push(false);
// 16381
o48.getElementsByTagName = f81632121_502;
// 16383
o48.querySelectorAll = f81632121_504;
// 16384
o64 = {};
// 16385
f81632121_504.returns.push(o64);
// 16386
o64.length = 1;
// 16387
o71 = {};
// 16388
o64["0"] = o71;
// undefined
o64 = null;
// undefined
o71 = null;
// 16392
f81632121_513.returns.push(false);
// 16397
f81632121_513.returns.push(false);
// 16402
f81632121_513.returns.push(false);
// 16407
f81632121_513.returns.push(false);
// 16412
f81632121_513.returns.push(true);
// 16416
f81632121_513.returns.push(false);
// 16421
f81632121_513.returns.push(false);
// 16426
f81632121_513.returns.push(false);
// 16431
f81632121_513.returns.push(false);
// 16436
f81632121_513.returns.push(false);
// 16441
f81632121_513.returns.push(false);
// 16446
f81632121_513.returns.push(true);
// 16450
f81632121_513.returns.push(false);
// 16455
f81632121_513.returns.push(false);
// 16460
f81632121_513.returns.push(false);
// 16465
f81632121_513.returns.push(true);
// 16466
o48.nodeName = "DIV";
// 16467
o48.__FB_TOKEN = void 0;
// 16468
// 16469
o48.getAttribute = f81632121_506;
// 16470
o48.hasAttribute = f81632121_507;
// 16472
f81632121_507.returns.push(false);
// 16473
o48.JSBNG__addEventListener = f81632121_468;
// 16475
f81632121_468.returns.push(undefined);
// 16476
o48.JSBNG__onclick = null;
// 16481
f81632121_468.returns.push(undefined);
// 16482
o48.JSBNG__onmouseover = null;
// 16487
f81632121_468.returns.push(undefined);
// 16488
o48.JSBNG__onmouseout = null;
// undefined
o48 = null;
// 16490
f81632121_14.returns.push(undefined);
// 16491
f81632121_12.returns.push(76);
// 16502
o48 = {};
// 16503
f81632121_508.returns.push(o48);
// 16505
o64 = {};
// 16506
f81632121_476.returns.push(o64);
// 16507
// 16508
// 16509
o64.getElementsByTagName = f81632121_502;
// 16510
o71 = {};
// 16511
f81632121_502.returns.push(o71);
// 16512
o71.length = 0;
// undefined
o71 = null;
// 16514
o71 = {};
// 16515
o64.childNodes = o71;
// undefined
o64 = null;
// 16516
o71.nodeType = void 0;
// undefined
o71 = null;
// 16518
o64 = {};
// 16519
f81632121_476.returns.push(o64);
// 16520
// 16521
// 16522
o64.getElementsByTagName = f81632121_502;
// 16523
o71 = {};
// 16524
f81632121_502.returns.push(o71);
// 16525
o71.length = 0;
// undefined
o71 = null;
// 16527
o71 = {};
// 16528
o64.childNodes = o71;
// undefined
o64 = null;
// 16529
o71.nodeType = void 0;
// undefined
o71 = null;
// 16530
o64 = {};
// 16531
o48.classList = o64;
// 16533
o64.contains = f81632121_513;
// undefined
o64 = null;
// 16534
f81632121_513.returns.push(false);
// 16535
o64 = {};
// 16536
o48.parentNode = o64;
// 16537
o71 = {};
// 16538
o64.classList = o71;
// 16540
o71.contains = f81632121_513;
// undefined
o71 = null;
// 16541
f81632121_513.returns.push(false);
// 16542
o71 = {};
// 16543
o64.parentNode = o71;
// undefined
o64 = null;
// 16544
o64 = {};
// 16545
o71.classList = o64;
// 16547
o64.contains = f81632121_513;
// undefined
o64 = null;
// 16548
f81632121_513.returns.push(false);
// 16549
o64 = {};
// 16550
o71.parentNode = o64;
// 16551
o196 = {};
// 16552
o64.classList = o196;
// 16554
o196.contains = f81632121_513;
// undefined
o196 = null;
// 16555
f81632121_513.returns.push(false);
// 16556
o196 = {};
// 16557
o64.parentNode = o196;
// undefined
o64 = null;
// 16558
o64 = {};
// 16559
o196.classList = o64;
// 16561
o64.contains = f81632121_513;
// undefined
o64 = null;
// 16562
f81632121_513.returns.push(false);
// 16563
o64 = {};
// 16564
o196.parentNode = o64;
// undefined
o196 = null;
// 16565
o196 = {};
// 16566
o64.classList = o196;
// 16568
o196.contains = f81632121_513;
// undefined
o196 = null;
// 16569
f81632121_513.returns.push(false);
// 16570
o196 = {};
// 16571
o64.parentNode = o196;
// undefined
o64 = null;
// 16572
o64 = {};
// 16573
o196.classList = o64;
// 16575
o64.contains = f81632121_513;
// undefined
o64 = null;
// 16576
f81632121_513.returns.push(false);
// 16577
o64 = {};
// 16578
o196.parentNode = o64;
// 16579
o197 = {};
// 16580
o64.classList = o197;
// 16582
o197.contains = f81632121_513;
// 16583
f81632121_513.returns.push(false);
// 16584
o198 = {};
// 16585
o64.parentNode = o198;
// 16586
o199 = {};
// 16587
o198.classList = o199;
// 16589
o199.contains = f81632121_513;
// undefined
o199 = null;
// 16590
f81632121_513.returns.push(false);
// 16591
o199 = {};
// 16592
o198.parentNode = o199;
// undefined
o198 = null;
// 16593
o198 = {};
// 16594
o199.classList = o198;
// 16596
o198.contains = f81632121_513;
// undefined
o198 = null;
// 16597
f81632121_513.returns.push(false);
// 16598
o198 = {};
// 16599
o199.parentNode = o198;
// 16600
o200 = {};
// 16601
o198.classList = o200;
// 16603
o200.contains = f81632121_513;
// undefined
o200 = null;
// 16604
f81632121_513.returns.push(false);
// 16605
o198.parentNode = o6;
// 16606
o200 = {};
// 16607
o6.classList = o200;
// 16609
o200.contains = f81632121_513;
// undefined
o200 = null;
// 16610
f81632121_513.returns.push(false);
// 16611
o6.parentNode = o83;
// undefined
o6 = null;
// 16612
o6 = {};
// 16613
o83.classList = o6;
// 16615
o6.contains = f81632121_513;
// undefined
o6 = null;
// 16616
f81632121_513.returns.push(false);
// 16617
o83.parentNode = o82;
// 16621
f81632121_513.returns.push(false);
// 16626
f81632121_513.returns.push(false);
// 16631
f81632121_513.returns.push(false);
// 16636
o48.getElementsByTagName = f81632121_502;
// 16638
o48.querySelectorAll = f81632121_504;
// 16639
o6 = {};
// 16640
f81632121_504.returns.push(o6);
// 16641
o6.length = 1;
// 16642
o200 = {};
// 16643
o6["0"] = o200;
// undefined
o6 = null;
// undefined
o200 = null;
// 16647
f81632121_513.returns.push(false);
// 16652
f81632121_513.returns.push(false);
// 16657
f81632121_513.returns.push(false);
// 16662
f81632121_513.returns.push(false);
// 16667
f81632121_513.returns.push(false);
// 16672
f81632121_513.returns.push(false);
// 16677
f81632121_513.returns.push(false);
// 16682
f81632121_513.returns.push(false);
// 16687
f81632121_513.returns.push(false);
// 16692
f81632121_513.returns.push(false);
// 16697
f81632121_513.returns.push(false);
// 16702
f81632121_513.returns.push(false);
// 16707
f81632121_513.returns.push(false);
// 16712
f81632121_513.returns.push(false);
// 16717
f81632121_513.returns.push(false);
// 16722
f81632121_513.returns.push(false);
// 16730
f81632121_513.returns.push(false);
// 16735
f81632121_513.returns.push(false);
// 16740
f81632121_513.returns.push(false);
// 16745
f81632121_513.returns.push(false);
// 16750
f81632121_513.returns.push(false);
// 16755
f81632121_513.returns.push(false);
// 16760
f81632121_513.returns.push(false);
// 16765
f81632121_513.returns.push(false);
// 16770
f81632121_513.returns.push(false);
// 16775
f81632121_513.returns.push(false);
// 16780
f81632121_513.returns.push(false);
// 16785
f81632121_513.returns.push(false);
// 16790
f81632121_513.returns.push(false);
// 16795
f81632121_513.returns.push(false);
// 16800
f81632121_513.returns.push(false);
// 16805
f81632121_513.returns.push(false);
// 16813
f81632121_513.returns.push(false);
// 16818
f81632121_513.returns.push(false);
// 16823
f81632121_513.returns.push(true);
// 16824
o48.nodeName = "DIV";
// 16825
o48.__FB_TOKEN = void 0;
// 16826
// 16827
o48.getAttribute = f81632121_506;
// 16828
o48.hasAttribute = f81632121_507;
// 16830
f81632121_507.returns.push(false);
// 16831
o48.JSBNG__addEventListener = f81632121_468;
// 16833
f81632121_468.returns.push(undefined);
// 16834
o48.JSBNG__onclick = null;
// 16839
f81632121_468.returns.push(undefined);
// 16840
o48.JSBNG__onmouseover = null;
// 16845
f81632121_468.returns.push(undefined);
// 16846
o48.JSBNG__onmouseout = null;
// undefined
o48 = null;
// 16848
f81632121_14.returns.push(undefined);
// 16849
f81632121_12.returns.push(77);
// 16853
o6 = {};
// 16854
f81632121_476.returns.push(o6);
// 16855
// 16856
// 16857
o6.getElementsByTagName = f81632121_502;
// 16858
o48 = {};
// 16859
f81632121_502.returns.push(o48);
// 16860
o48.length = 0;
// undefined
o48 = null;
// 16862
o48 = {};
// 16863
o6.childNodes = o48;
// undefined
o6 = null;
// 16864
o48.nodeType = void 0;
// undefined
o48 = null;
// 16866
f81632121_508.returns.push(o65);
// 16867
o65.getElementsByTagName = f81632121_502;
// 16869
o65.querySelectorAll = f81632121_504;
// undefined
o65 = null;
// 16870
o6 = {};
// 16871
f81632121_504.returns.push(o6);
// 16872
o6.length = 1;
// 16873
o6["0"] = o66;
// undefined
o6 = null;
// undefined
o66 = null;
// 16877
o6 = {};
// 16878
f81632121_504.returns.push(o6);
// 16879
o6.length = 0;
// undefined
o6 = null;
// 16883
o6 = {};
// 16884
f81632121_504.returns.push(o6);
// 16885
o6.length = 1;
// 16886
o48 = {};
// 16887
o6["0"] = o48;
// undefined
o6 = null;
// 16889
o48.querySelectorAll = f81632121_504;
// undefined
o48 = null;
// 16890
o6 = {};
// 16891
f81632121_504.returns.push(o6);
// 16892
o6.length = 1;
// 16893
o48 = {};
// 16894
o6["0"] = o48;
// undefined
o6 = null;
// 16897
o68.remove = f81632121_1114;
// undefined
o68 = null;
// 16898
f81632121_1114.returns.push(undefined);
// 16902
f81632121_1114.returns.push(undefined);
// 16906
f81632121_1114.returns.push(undefined);
// 16910
f81632121_1114.returns.push(undefined);
// 16914
f81632121_1114.returns.push(undefined);
// 16915
o48.firstChild = null;
// undefined
o48 = null;
// 16919
f81632121_513.returns.push(false);
// 16924
f81632121_513.returns.push(false);
// 16929
f81632121_513.returns.push(false);
// 16934
f81632121_513.returns.push(true);
// 16935
o67.contains = f81632121_645;
// undefined
o67 = null;
// 16937
f81632121_645.returns.push(true);
// 16943
f81632121_467.returns.push(1374851244303);
// 16946
o50.getElementsByTagName = f81632121_502;
// 16948
o50.querySelectorAll = f81632121_504;
// undefined
o50 = null;
// 16949
o6 = {};
// 16950
f81632121_504.returns.push(o6);
// 16951
o6.length = 1;
// 16952
o6["0"] = o49;
// undefined
o6 = null;
// 16956
o6 = {};
// 16957
f81632121_504.returns.push(o6);
// 16958
o6.length = 0;
// undefined
o6 = null;
// 16962
o6 = {};
// 16963
f81632121_504.returns.push(o6);
// 16964
o6.length = 1;
// 16965
o48 = {};
// 16966
o6["0"] = o48;
// undefined
o6 = null;
// undefined
o48 = null;
// 16970
o6 = {};
// 16971
f81632121_504.returns.push(o6);
// 16972
o6.length = 1;
// 16973
o48 = {};
// 16974
o6["0"] = o48;
// undefined
o6 = null;
// undefined
o48 = null;
// 16975
o49.nodeName = "INPUT";
// 16976
o49.__FB_TOKEN = void 0;
// 16977
// 16978
o49.getAttribute = f81632121_506;
// 16979
o49.hasAttribute = f81632121_507;
// 16981
f81632121_507.returns.push(false);
// 16982
o49.JSBNG__addEventListener = f81632121_468;
// 16984
f81632121_468.returns.push(undefined);
// 16985
o49.JSBNG__onJSBNG__blur = void 0;
// 16990
f81632121_468.returns.push(undefined);
// 16991
o49.JSBNG__onJSBNG__focus = void 0;
// 16996
f81632121_468.returns.push(undefined);
// 16997
o49.JSBNG__onclick = null;
// 17002
f81632121_468.returns.push(undefined);
// 17003
o49.JSBNG__onkeydown = null;
// 17008
f81632121_468.returns.push(undefined);
// 17009
o49.JSBNG__onkeyup = null;
// 17014
f81632121_468.returns.push(undefined);
// 17015
o49.JSBNG__onkeypress = null;
// undefined
o49 = null;
// 17027
f81632121_1114.returns.push(undefined);
// 17032
f81632121_1114.returns.push(undefined);
// 17042
f81632121_467.returns.push(1374851244322);
// 17043
o6 = {};
// 17044
o3.plugins = o6;
// 17046
f81632121_2241 = function() { return f81632121_2241.returns[f81632121_2241.inst++]; };
f81632121_2241.returns = [];
f81632121_2241.inst = 0;
// 17047
o6.refresh = f81632121_2241;
// 17048
f81632121_2241.returns.push(undefined);
// 17050
o6.length = 5;
// 17052
o48 = {};
// 17053
o6["0"] = o48;
// 17054
o48.length = 2;
// 17055
o49 = {};
// 17056
o48["0"] = o49;
// undefined
o48 = null;
// 17057
o49.type = "application/x-shockwave-flash";
// undefined
o49 = null;
// 17059
o48 = {};
// 17060
o6["1"] = o48;
// 17061
o48.length = 1;
// 17062
o49 = {};
// 17063
o48["0"] = o49;
// undefined
o48 = null;
// 17064
o49.type = "application/vnd.chromium.remoting-viewer";
// undefined
o49 = null;
// 17066
o48 = {};
// 17067
o6["2"] = o48;
// 17068
o48.length = 1;
// 17069
o49 = {};
// 17070
o48["0"] = o49;
// undefined
o48 = null;
// 17071
o49.type = "application/x-nacl";
// undefined
o49 = null;
// 17073
o48 = {};
// 17074
o6["3"] = o48;
// 17075
o48.length = 2;
// 17076
o49 = {};
// 17077
o48["0"] = o49;
// undefined
o48 = null;
// 17078
o49.type = "application/pdf";
// undefined
o49 = null;
// 17080
o48 = {};
// 17081
o6["4"] = o48;
// 17082
o48.length = 2;
// 17083
o49 = {};
// 17084
o48["0"] = o49;
// undefined
o48 = null;
// 17085
o49.type = "application/x-vnd.google.update3webcontrol.3";
// undefined
o49 = null;
// 17086
o2.getItem = f81632121_482;
// undefined
o2 = null;
// 17087
f81632121_482.returns.push(null);
// 17090
f81632121_467.returns.push(1374851244329);
// undefined
fo81632121_1_cookie.returns.push("c_user=100006118350059; csm=2; sub=4096");
// 17093
o2 = {};
// 17094
f81632121_70.returns.push(o2);
// 17095
// 17096
o2.open = f81632121_1294;
// 17097
f81632121_1294.returns.push(undefined);
// 17098
o2.setRequestHeader = f81632121_1295;
// 17099
f81632121_1295.returns.push(undefined);
// 17102
f81632121_1295.returns.push(undefined);
// 17103
o2.send = f81632121_1296;
// 17104
f81632121_1296.returns.push(undefined);
// 17106
f81632121_1418.returns.push({__JSBNG_unknown_function:true});
// 17113
f81632121_508.returns.push(o196);
// 17116
o196.__FB_TOKEN = void 0;
// 17117
// 17118
o196.getElementsByTagName = f81632121_502;
// 17120
o196.querySelectorAll = f81632121_504;
// 17121
o48 = {};
// 17122
f81632121_504.returns.push(o48);
// 17123
o48.length = 1;
// 17124
o48["0"] = o137;
// undefined
o48 = null;
// 17128
o48 = {};
// 17129
f81632121_504.returns.push(o48);
// 17130
o48.length = 1;
// 17131
o49 = {};
// 17132
o48["0"] = o49;
// undefined
o48 = null;
// 17136
o48 = {};
// 17137
f81632121_504.returns.push(o48);
// 17138
o48.length = 1;
// 17139
o50 = {};
// 17140
o48["0"] = o50;
// undefined
o48 = null;
// 17144
o48 = {};
// 17145
f81632121_504.returns.push(o48);
// 17146
o48.length = 1;
// 17147
o48["0"] = o71;
// undefined
o48 = null;
// 17151
f81632121_513.returns.push(false);
// 17156
f81632121_513.returns.push(true);
// 17160
o48 = {};
// 17161
f81632121_504.returns.push(o48);
// 17162
o48.length = 1;
// 17163
o65 = {};
// 17164
o48["0"] = o65;
// undefined
o48 = null;
// 17165
o65.__FB_TOKEN = void 0;
// 17166
// undefined
o65 = null;
// 17167
o71.contains = f81632121_645;
// undefined
o71 = null;
// 17169
f81632121_645.returns.push(true);
// 17173
o48 = {};
// 17174
f81632121_504.returns.push(o48);
// 17175
o48.length = 1;
// 17176
o65 = {};
// 17177
o48["0"] = o65;
// undefined
o48 = null;
// undefined
o65 = null;
// 17178
o196.nodeName = "DIV";
// 17179
o196.getAttribute = f81632121_506;
// 17180
o196.hasAttribute = f81632121_507;
// 17182
f81632121_507.returns.push(false);
// 17183
o196.JSBNG__addEventListener = f81632121_468;
// 17185
f81632121_468.returns.push(undefined);
// 17186
o196.JSBNG__onkeydown = null;
// undefined
o196 = null;
// 17188
o137.nodeName = "A";
// 17189
o137.__FB_TOKEN = void 0;
// 17190
// 17192
o137.hasAttribute = f81632121_507;
// 17194
f81632121_507.returns.push(false);
// 17195
o137.JSBNG__addEventListener = f81632121_468;
// 17197
f81632121_468.returns.push(undefined);
// 17198
o137.JSBNG__onclick = null;
// 17204
o197.remove = f81632121_1114;
// undefined
o197 = null;
// 17205
f81632121_1114.returns.push(undefined);
// 17209
f81632121_1114.returns.push(undefined);
// 17210
o48 = {};
// 17211
o49.classList = o48;
// undefined
o49 = null;
// 17213
o48.add = f81632121_602;
// undefined
o48 = null;
// 17214
f81632121_602.returns.push(undefined);
// 17215
o50.cloneNode = f81632121_1871;
// 17216
o48 = {};
// 17217
f81632121_1871.returns.push(o48);
// 17218
o49 = {};
// undefined
fo81632121_2264_firstChild = function() { return fo81632121_2264_firstChild.returns[fo81632121_2264_firstChild.inst++]; };
fo81632121_2264_firstChild.returns = [];
fo81632121_2264_firstChild.inst = 0;
defineGetter(o48, "firstChild", fo81632121_2264_firstChild, undefined);
// undefined
fo81632121_2264_firstChild.returns.push(o49);
// undefined
fo81632121_2264_firstChild.returns.push(o49);
// 17221
o49.parentNode = o48;
// 17223
o48.removeChild = f81632121_521;
// 17224
f81632121_521.returns.push(o49);
// undefined
o49 = null;
// 17225
o49 = {};
// undefined
fo81632121_2264_firstChild.returns.push(o49);
// undefined
fo81632121_2264_firstChild.returns.push(o49);
// 17228
o49.parentNode = o48;
// 17231
f81632121_521.returns.push(o49);
// undefined
o49 = null;
// undefined
fo81632121_2264_firstChild.returns.push(null);
// 17234
o49 = {};
// 17235
f81632121_474.returns.push(o49);
// 17237
o65 = {};
// 17238
f81632121_598.returns.push(o65);
// 17239
o49.appendChild = f81632121_478;
// 17240
f81632121_478.returns.push(o65);
// undefined
o65 = null;
// 17241
o48.appendChild = f81632121_478;
// 17242
f81632121_478.returns.push(o49);
// undefined
o49 = null;
// 17243
o50.parentNode = o137;
// 17244
o48.__html = void 0;
// undefined
o48 = null;
// 17246
o48 = {};
// 17247
f81632121_474.returns.push(o48);
// undefined
o48 = null;
// 17249
f81632121_2270 = function() { return f81632121_2270.returns[f81632121_2270.inst++]; };
f81632121_2270.returns = [];
f81632121_2270.inst = 0;
// 17250
o137.replaceChild = f81632121_2270;
// undefined
o137 = null;
// 17251
f81632121_2270.returns.push(o50);
// undefined
o50 = null;
// 17259
o3.platform = "Win32";
// 17262
o48 = {};
// undefined
fo81632121_2240_Shockwave_Flash = function() { return fo81632121_2240_Shockwave_Flash.returns[fo81632121_2240_Shockwave_Flash.inst++]; };
fo81632121_2240_Shockwave_Flash.returns = [];
fo81632121_2240_Shockwave_Flash.inst = 0;
defineGetter(o6, "Shockwave Flash", fo81632121_2240_Shockwave_Flash, undefined);
// undefined
fo81632121_2240_Shockwave_Flash.returns.push(o48);
// undefined
o48 = null;
// 17265
o48 = {};
// undefined
fo81632121_2240_Shockwave_Flash.returns.push(o48);
// 17267
o48.description = "Shockwave Flash 11.8 r800";
// undefined
o48 = null;
// 17268
o48 = {};
// 17269
o3.mimeTypes = o48;
// undefined
o3 = null;
// 17271
o3 = {};
// undefined
fo81632121_2273_application_x_shockwave_flash = function() { return fo81632121_2273_application_x_shockwave_flash.returns[fo81632121_2273_application_x_shockwave_flash.inst++]; };
fo81632121_2273_application_x_shockwave_flash.returns = [];
fo81632121_2273_application_x_shockwave_flash.inst = 0;
defineGetter(o48, "application/x-shockwave-flash", fo81632121_2273_application_x_shockwave_flash, undefined);
// undefined
o48 = null;
// undefined
fo81632121_2273_application_x_shockwave_flash.returns.push(o3);
// undefined
o3 = null;
// 17274
o3 = {};
// undefined
fo81632121_2273_application_x_shockwave_flash.returns.push(o3);
// 17276
o48 = {};
// 17277
o3.enabledPlugin = o48;
// undefined
o3 = null;
// undefined
o48 = null;
// 17278
o0.readyState = "complete";
// 17281
o3 = {};
// 17282
f81632121_471.returns.push(o3);
// 17283
o3["0"] = o16;
// undefined
o3 = null;
// 17286
o3 = {};
// 17287
f81632121_476.returns.push(o3);
// 17288
f81632121_478.returns.push(o3);
// 17289
o3.parentNode = o16;
// 17291
f81632121_521.returns.push(o3);
// undefined
o3 = null;
// 17293
o3 = {};
// 17294
f81632121_471.returns.push(o3);
// 17295
o3["0"] = o16;
// undefined
o3 = null;
// 17297
o3 = {};
// 17298
f81632121_476.returns.push(o3);
// 17299
o3.setAttribute = f81632121_575;
// 17300
f81632121_575.returns.push(undefined);
// 17302
f81632121_575.returns.push(undefined);
// 17304
f81632121_478.returns.push(o3);
// 17305
f81632121_2281 = function() { return f81632121_2281.returns[f81632121_2281.inst++]; };
f81632121_2281.returns = [];
f81632121_2281.inst = 0;
// 17306
o3.GetVariable = f81632121_2281;
// undefined
o3 = null;
// 17308
f81632121_2281.returns.push("WIN 11,8,800,97");
// 17310
o5.host = "jsbngssl.www.facebook.com";
// undefined
o5 = null;
// 17312
o3 = {};
// 17313
f81632121_476.returns.push(o3);
// 17314
o3.setAttribute = f81632121_575;
// 17315
f81632121_575.returns.push(undefined);
// 17316
o5 = {};
// 17317
o3.style = o5;
// 17318
// undefined
o5 = null;
// 17321
f81632121_478.returns.push(o3);
// undefined
o3 = null;
// 17323
o3 = {};
// 17324
f81632121_508.returns.push(o3);
// 17325
o3.firstChild = null;
// 17328
f81632121_466.returns.push(0.23936162423342466);
// 17330
f81632121_467.returns.push(1374851244436);
// 17332
f81632121_467.returns.push(1374851244436);
// 17338
f81632121_467.returns.push(1374851244437);
// 17340
f81632121_467.returns.push(1374851244437);
// 17342
f81632121_467.returns.push(1374851244437);
// 17344
f81632121_467.returns.push(1374851244437);
// 17346
f81632121_467.returns.push(1374851244437);
// 17347
o3.nodeType = 1;
// 17348
o3.parentNode = o83;
// 17349
o3.nextSibling = null;
// 17350
o83.removeChild = f81632121_521;
// 17351
f81632121_521.returns.push(o3);
// 17352
// 17353
o83.appendChild = f81632121_478;
// undefined
o83 = null;
// 17354
f81632121_478.returns.push(o3);
// undefined
o3 = null;
// 17356
f81632121_467.returns.push(1374851244439);
// 17358
f81632121_467.returns.push(1374851244439);
// 17361
f81632121_467.returns.push(1374851244440);
// 17363
f81632121_467.returns.push(1374851244440);
// 17365
f81632121_467.returns.push(1374851244440);
// 17367
f81632121_467.returns.push(1374851244440);
// 17369
f81632121_467.returns.push(1374851244440);
// 17373
f81632121_467.returns.push(1374851244447);
// 17375
f81632121_467.returns.push(1374851244447);
// 17376
f81632121_13.returns.push(78);
// 17378
o3 = {};
// 17379
f81632121_476.returns.push(o3);
// 17380
// 17381
// 17382
o3.getElementsByTagName = f81632121_502;
// 17383
o5 = {};
// 17384
f81632121_502.returns.push(o5);
// 17385
o5.length = 0;
// undefined
o5 = null;
// 17387
o5 = {};
// 17388
o3.childNodes = o5;
// undefined
o3 = null;
// 17389
o5.nodeType = void 0;
// undefined
o5 = null;
// 17391
o3 = {};
// 17392
f81632121_476.returns.push(o3);
// 17393
// 17394
// 17395
o3.getElementsByTagName = f81632121_502;
// 17396
o5 = {};
// 17397
f81632121_502.returns.push(o5);
// 17398
o5.length = 0;
// undefined
o5 = null;
// 17400
o5 = {};
// 17401
o3.childNodes = o5;
// undefined
o3 = null;
// 17402
o5.nodeType = void 0;
// undefined
o5 = null;
// 17404
o3 = {};
// 17405
f81632121_476.returns.push(o3);
// 17406
// 17407
// 17408
o3.getElementsByTagName = f81632121_502;
// 17409
o5 = {};
// 17410
f81632121_502.returns.push(o5);
// 17411
o5.length = 0;
// undefined
o5 = null;
// 17413
o5 = {};
// 17414
o3.childNodes = o5;
// undefined
o3 = null;
// 17415
o5.nodeType = void 0;
// undefined
o5 = null;
// 17417
o3 = {};
// 17418
f81632121_476.returns.push(o3);
// 17419
// 17420
// 17421
o3.getElementsByTagName = f81632121_502;
// 17422
o5 = {};
// 17423
f81632121_502.returns.push(o5);
// 17424
o5.length = 0;
// undefined
o5 = null;
// 17426
o5 = {};
// 17427
o3.childNodes = o5;
// undefined
o3 = null;
// 17428
o5.nodeType = void 0;
// undefined
o5 = null;
// 17430
o3 = {};
// 17431
f81632121_476.returns.push(o3);
// 17432
// 17433
// 17434
o3.getElementsByTagName = f81632121_502;
// 17435
o5 = {};
// 17436
f81632121_502.returns.push(o5);
// 17437
o5.length = 0;
// undefined
o5 = null;
// 17439
o5 = {};
// 17440
o3.childNodes = o5;
// undefined
o3 = null;
// 17441
o5.nodeType = void 0;
// undefined
o5 = null;
// 17443
o3 = {};
// 17444
f81632121_476.returns.push(o3);
// 17445
// 17446
// 17447
o3.getElementsByTagName = f81632121_502;
// 17448
o5 = {};
// 17449
f81632121_502.returns.push(o5);
// 17450
o5.length = 0;
// undefined
o5 = null;
// 17452
o5 = {};
// 17453
o3.childNodes = o5;
// undefined
o3 = null;
// 17454
o5.nodeType = void 0;
// 17456
o3 = {};
// 17457
f81632121_476.returns.push(o3);
// 17458
// 17459
// 17460
o3.getElementsByTagName = f81632121_502;
// 17461
o48 = {};
// 17462
f81632121_502.returns.push(o48);
// 17463
o48.length = 0;
// undefined
o48 = null;
// 17465
o48 = {};
// 17466
o3.childNodes = o48;
// undefined
o3 = null;
// 17467
o48.nodeType = void 0;
// undefined
o48 = null;
// 17469
o3 = {};
// 17470
f81632121_476.returns.push(o3);
// 17471
// 17472
// 17473
o3.getElementsByTagName = f81632121_502;
// 17474
o48 = {};
// 17475
f81632121_502.returns.push(o48);
// 17476
o48.length = 0;
// undefined
o48 = null;
// 17478
o48 = {};
// 17479
o3.childNodes = o48;
// undefined
o3 = null;
// 17480
o48.nodeType = void 0;
// undefined
o48 = null;
// 17482
o3 = {};
// 17483
f81632121_476.returns.push(o3);
// 17484
// 17485
// 17486
o3.getElementsByTagName = f81632121_502;
// 17487
o48 = {};
// 17488
f81632121_502.returns.push(o48);
// 17489
o48.length = 0;
// undefined
o48 = null;
// 17491
o48 = {};
// 17492
o3.childNodes = o48;
// undefined
o3 = null;
// 17493
o48.nodeType = void 0;
// undefined
o48 = null;
// 17495
o3 = {};
// 17496
f81632121_476.returns.push(o3);
// 17497
// 17498
// 17499
o3.getElementsByTagName = f81632121_502;
// 17500
o48 = {};
// 17501
f81632121_502.returns.push(o48);
// 17502
o48.length = 0;
// undefined
o48 = null;
// 17504
o48 = {};
// 17505
o3.childNodes = o48;
// undefined
o3 = null;
// 17506
o48.nodeType = void 0;
// undefined
o48 = null;
// 17508
o3 = {};
// 17509
f81632121_476.returns.push(o3);
// 17510
// 17511
// 17512
o3.getElementsByTagName = f81632121_502;
// 17513
o48 = {};
// 17514
f81632121_502.returns.push(o48);
// 17515
o48.length = 0;
// undefined
o48 = null;
// 17517
o48 = {};
// 17518
o3.childNodes = o48;
// undefined
o3 = null;
// 17519
o48.nodeType = void 0;
// undefined
o48 = null;
// 17521
o3 = {};
// 17522
f81632121_476.returns.push(o3);
// 17523
// 17524
// 17525
o3.getElementsByTagName = f81632121_502;
// 17526
o48 = {};
// 17527
f81632121_502.returns.push(o48);
// 17528
o48.length = 0;
// undefined
o48 = null;
// 17530
o48 = {};
// 17531
o3.childNodes = o48;
// undefined
o3 = null;
// 17532
o48.nodeType = void 0;
// undefined
o48 = null;
// 17534
o3 = {};
// 17535
f81632121_476.returns.push(o3);
// 17536
// 17537
// 17538
o3.getElementsByTagName = f81632121_502;
// 17539
o48 = {};
// 17540
f81632121_502.returns.push(o48);
// 17541
o48.length = 0;
// undefined
o48 = null;
// 17543
o48 = {};
// 17544
o3.childNodes = o48;
// undefined
o3 = null;
// 17545
o48.nodeType = void 0;
// undefined
o48 = null;
// 17547
o3 = {};
// 17548
f81632121_476.returns.push(o3);
// 17549
// 17550
// 17551
o3.getElementsByTagName = f81632121_502;
// 17552
o48 = {};
// 17553
f81632121_502.returns.push(o48);
// 17554
o48.length = 0;
// undefined
o48 = null;
// 17556
o48 = {};
// 17557
o3.childNodes = o48;
// undefined
o3 = null;
// 17558
o48.nodeType = void 0;
// undefined
o48 = null;
// 17560
o3 = {};
// 17561
f81632121_476.returns.push(o3);
// 17562
// 17563
// 17564
o3.getElementsByTagName = f81632121_502;
// 17565
o48 = {};
// 17566
f81632121_502.returns.push(o48);
// 17567
o48.length = 0;
// undefined
o48 = null;
// 17569
o48 = {};
// 17570
o3.childNodes = o48;
// undefined
o3 = null;
// 17571
o48.nodeType = void 0;
// undefined
o48 = null;
// 17573
o3 = {};
// 17574
f81632121_476.returns.push(o3);
// 17575
// 17576
// 17577
o3.getElementsByTagName = f81632121_502;
// 17578
o48 = {};
// 17579
f81632121_502.returns.push(o48);
// 17580
o48.length = 0;
// undefined
o48 = null;
// 17582
o48 = {};
// 17583
o3.childNodes = o48;
// undefined
o3 = null;
// 17584
o48.nodeType = void 0;
// undefined
o48 = null;
// 17586
o3 = {};
// 17587
f81632121_476.returns.push(o3);
// 17588
// 17589
// 17590
o3.getElementsByTagName = f81632121_502;
// 17591
o48 = {};
// 17592
f81632121_502.returns.push(o48);
// 17593
o48.length = 0;
// undefined
o48 = null;
// 17595
o48 = {};
// 17596
o3.childNodes = o48;
// undefined
o3 = null;
// 17597
o48.nodeType = void 0;
// undefined
o48 = null;
// 17599
o3 = {};
// 17600
f81632121_476.returns.push(o3);
// 17601
// 17602
// 17603
o3.getElementsByTagName = f81632121_502;
// 17604
o48 = {};
// 17605
f81632121_502.returns.push(o48);
// 17606
o48.length = 0;
// undefined
o48 = null;
// 17608
o48 = {};
// 17609
o3.childNodes = o48;
// undefined
o3 = null;
// 17610
o48.nodeType = void 0;
// undefined
o48 = null;
// 17612
o3 = {};
// 17613
f81632121_476.returns.push(o3);
// 17614
// 17615
// 17616
o3.getElementsByTagName = f81632121_502;
// 17617
o48 = {};
// 17618
f81632121_502.returns.push(o48);
// 17619
o48.length = 0;
// undefined
o48 = null;
// 17621
o48 = {};
// 17622
o3.childNodes = o48;
// undefined
o3 = null;
// 17623
o48.nodeType = void 0;
// undefined
o48 = null;
// 17625
o3 = {};
// 17626
f81632121_476.returns.push(o3);
// 17627
// 17628
// 17629
o3.getElementsByTagName = f81632121_502;
// 17630
o48 = {};
// 17631
f81632121_502.returns.push(o48);
// 17632
o48.length = 0;
// undefined
o48 = null;
// 17634
o48 = {};
// 17635
o3.childNodes = o48;
// undefined
o3 = null;
// 17636
o48.nodeType = void 0;
// undefined
o48 = null;
// 17638
o3 = {};
// 17639
f81632121_476.returns.push(o3);
// 17640
// 17641
// 17642
o3.getElementsByTagName = f81632121_502;
// 17643
o48 = {};
// 17644
f81632121_502.returns.push(o48);
// 17645
o48.length = 0;
// undefined
o48 = null;
// 17647
o48 = {};
// 17648
o3.childNodes = o48;
// undefined
o3 = null;
// 17649
o48.nodeType = void 0;
// undefined
o48 = null;
// 17651
o3 = {};
// 17652
f81632121_476.returns.push(o3);
// 17653
// 17654
// 17655
o3.getElementsByTagName = f81632121_502;
// 17656
o48 = {};
// 17657
f81632121_502.returns.push(o48);
// 17658
o48.length = 0;
// undefined
o48 = null;
// 17660
o48 = {};
// 17661
o3.childNodes = o48;
// undefined
o3 = null;
// 17662
o48.nodeType = void 0;
// undefined
o48 = null;
// undefined
fo81632121_1_cookie.returns.push("c_user=100006118350059; csm=2; sub=4096");
// 17665
o3 = {};
// 17666
f81632121_476.returns.push(o3);
// 17667
// 17668
// 17669
o3.getElementsByTagName = f81632121_502;
// 17670
o48 = {};
// 17671
f81632121_502.returns.push(o48);
// 17672
o48.length = 0;
// undefined
o48 = null;
// 17674
o48 = {};
// 17675
o3.childNodes = o48;
// undefined
o3 = null;
// 17676
o48.nodeType = void 0;
// undefined
o48 = null;
// 17678
o3 = {};
// 17679
f81632121_476.returns.push(o3);
// 17680
// 17681
// 17682
o3.getElementsByTagName = f81632121_502;
// 17683
o48 = {};
// 17684
f81632121_502.returns.push(o48);
// 17685
o48.length = 0;
// undefined
o48 = null;
// 17687
o48 = {};
// 17688
o3.childNodes = o48;
// undefined
o3 = null;
// 17689
o48.nodeType = void 0;
// undefined
o48 = null;
// 17691
o3 = {};
// 17692
f81632121_476.returns.push(o3);
// 17693
// 17694
// 17695
o3.getElementsByTagName = f81632121_502;
// 17696
o48 = {};
// 17697
f81632121_502.returns.push(o48);
// 17698
o48.length = 0;
// undefined
o48 = null;
// 17700
o48 = {};
// 17701
o3.childNodes = o48;
// undefined
o3 = null;
// 17702
o48.nodeType = void 0;
// undefined
o48 = null;
// 17704
o3 = {};
// 17705
f81632121_476.returns.push(o3);
// 17706
// 17707
// 17708
o3.getElementsByTagName = f81632121_502;
// 17709
o48 = {};
// 17710
f81632121_502.returns.push(o48);
// 17711
o48.length = 0;
// undefined
o48 = null;
// 17713
o48 = {};
// 17714
o3.childNodes = o48;
// undefined
o3 = null;
// 17715
o48.nodeType = void 0;
// undefined
o48 = null;
// 17717
o3 = {};
// 17718
f81632121_476.returns.push(o3);
// 17719
// 17720
// 17721
o3.getElementsByTagName = f81632121_502;
// 17722
o48 = {};
// 17723
f81632121_502.returns.push(o48);
// 17724
o48.length = 0;
// undefined
o48 = null;
// 17726
o48 = {};
// 17727
o3.childNodes = o48;
// undefined
o3 = null;
// 17728
o48.nodeType = void 0;
// undefined
o48 = null;
// 17730
o3 = {};
// 17731
f81632121_476.returns.push(o3);
// 17732
// 17733
// 17734
o3.getElementsByTagName = f81632121_502;
// 17735
o48 = {};
// 17736
f81632121_502.returns.push(o48);
// 17737
o48.length = 0;
// undefined
o48 = null;
// 17739
o48 = {};
// 17740
o3.childNodes = o48;
// undefined
o3 = null;
// 17741
o48.nodeType = void 0;
// undefined
o48 = null;
// 17743
o3 = {};
// 17744
f81632121_476.returns.push(o3);
// 17745
// 17746
// 17747
o3.getElementsByTagName = f81632121_502;
// 17748
o48 = {};
// 17749
f81632121_502.returns.push(o48);
// 17750
o48.length = 0;
// undefined
o48 = null;
// 17752
o48 = {};
// 17753
o3.childNodes = o48;
// undefined
o3 = null;
// 17754
o48.nodeType = void 0;
// undefined
o48 = null;
// 17756
o3 = {};
// 17757
f81632121_476.returns.push(o3);
// 17758
// 17759
// 17760
o3.getElementsByTagName = f81632121_502;
// 17761
o48 = {};
// 17762
f81632121_502.returns.push(o48);
// 17763
o48.length = 0;
// undefined
o48 = null;
// 17765
o48 = {};
// 17766
o3.childNodes = o48;
// undefined
o3 = null;
// 17767
o48.nodeType = void 0;
// undefined
o48 = null;
// 17769
o3 = {};
// 17770
f81632121_476.returns.push(o3);
// 17771
// 17772
// 17773
o3.getElementsByTagName = f81632121_502;
// 17774
o48 = {};
// 17775
f81632121_502.returns.push(o48);
// 17776
o48.length = 0;
// undefined
o48 = null;
// 17778
o48 = {};
// 17779
o3.childNodes = o48;
// undefined
o3 = null;
// 17780
o48.nodeType = void 0;
// undefined
o48 = null;
// 17782
o3 = {};
// 17783
f81632121_476.returns.push(o3);
// 17784
// 17785
// 17786
o3.getElementsByTagName = f81632121_502;
// 17787
o48 = {};
// 17788
f81632121_502.returns.push(o48);
// 17789
o48.length = 0;
// undefined
o48 = null;
// 17791
o48 = {};
// 17792
o3.childNodes = o48;
// undefined
o3 = null;
// 17793
o48.nodeType = void 0;
// undefined
o48 = null;
// 17794
f81632121_1620.__reactDontBind = void 0;
// 17795
f81632121_1619.__reactDontBind = void 0;
// 17797
o3 = {};
// 17798
f81632121_476.returns.push(o3);
// 17799
// 17800
// 17801
o3.getElementsByTagName = f81632121_502;
// 17802
o48 = {};
// 17803
f81632121_502.returns.push(o48);
// 17804
o48.length = 0;
// undefined
o48 = null;
// 17806
o48 = {};
// 17807
o3.childNodes = o48;
// undefined
o3 = null;
// 17808
o48.nodeType = void 0;
// undefined
o48 = null;
// 17810
o3 = {};
// 17811
f81632121_476.returns.push(o3);
// 17812
// 17813
// 17814
o3.getElementsByTagName = f81632121_502;
// 17815
o48 = {};
// 17816
f81632121_502.returns.push(o48);
// 17817
o48.length = 0;
// undefined
o48 = null;
// 17819
o48 = {};
// 17820
o3.childNodes = o48;
// undefined
o3 = null;
// 17821
o48.nodeType = void 0;
// undefined
o48 = null;
// 17823
o3 = {};
// 17824
f81632121_476.returns.push(o3);
// 17825
// 17826
// 17827
o3.getElementsByTagName = f81632121_502;
// 17828
o48 = {};
// 17829
f81632121_502.returns.push(o48);
// 17830
o48.length = 0;
// undefined
o48 = null;
// 17832
o48 = {};
// 17833
o3.childNodes = o48;
// undefined
o3 = null;
// 17834
o48.nodeType = void 0;
// undefined
o48 = null;
// 17836
o3 = {};
// 17837
f81632121_476.returns.push(o3);
// 17838
// 17839
// 17840
o3.getElementsByTagName = f81632121_502;
// 17841
o48 = {};
// 17842
f81632121_502.returns.push(o48);
// 17843
o48.length = 0;
// undefined
o48 = null;
// 17845
o48 = {};
// 17846
o3.childNodes = o48;
// undefined
o3 = null;
// 17847
o48.nodeType = void 0;
// undefined
o48 = null;
// 17849
o3 = {};
// 17850
f81632121_476.returns.push(o3);
// 17851
// 17852
// 17853
o3.getElementsByTagName = f81632121_502;
// 17854
o48 = {};
// 17855
f81632121_502.returns.push(o48);
// 17856
o48.length = 0;
// undefined
o48 = null;
// 17858
o48 = {};
// 17859
o3.childNodes = o48;
// undefined
o3 = null;
// 17860
o48.nodeType = void 0;
// undefined
o48 = null;
// 17863
f81632121_467.returns.push(1374851244544);
// 17879
f81632121_513.returns.push(false);
// 17886
o3 = {};
// 17887
o79.classList = o3;
// 17889
o3.contains = f81632121_513;
// undefined
o3 = null;
// 17890
f81632121_513.returns.push(false);
// 17891
o79.parentNode = o46;
// undefined
o79 = null;
// 17892
o3 = {};
// 17893
o46.classList = o3;
// 17895
o3.contains = f81632121_513;
// undefined
o3 = null;
// 17896
f81632121_513.returns.push(false);
// 17897
o3 = {};
// 17898
o46.parentNode = o3;
// 17899
o48 = {};
// 17900
o3.classList = o48;
// 17902
o48.contains = f81632121_513;
// undefined
o48 = null;
// 17903
f81632121_513.returns.push(false);
// 17904
o3.parentNode = o199;
// undefined
o3 = null;
// undefined
o199 = null;
// 17908
f81632121_513.returns.push(false);
// 17913
f81632121_513.returns.push(true);
// 17914
o198.getElementsByTagName = f81632121_502;
// 17916
o198.querySelectorAll = f81632121_504;
// 17917
o3 = {};
// 17918
f81632121_504.returns.push(o3);
// 17919
o3.length = 1;
// 17920
o3["0"] = o64;
// undefined
o3 = null;
// 17921
o64.offsetWidth = 205;
// 17922
o64.offsetHeight = 0;
// undefined
o64 = null;
// 17926
o3 = {};
// 17927
f81632121_504.returns.push(o3);
// 17928
o3.length = 1;
// 17929
o3["0"] = o46;
// undefined
o3 = null;
// 17930
o46.offsetWidth = 0;
// 17931
o46.offsetHeight = 0;
// undefined
o46 = null;
// 17932
o198.offsetWidth = 205;
// 17933
o198.offsetHeight = 25;
// undefined
o198 = null;
// 17934
o5.__html = void 0;
// 17935
o5.cloneNode = void 0;
// undefined
o5 = null;
// 17936
o3 = {};
// 17937
o5 = {};
// 17939
o3.transport = o2;
// 17940
o2.readyState = 1;
// 17941
o46 = {};
// 17942
o48 = {};
// 17944
o46.nodeType = void 0;
// 17945
o46.length = 1;
// 17946
o46["0"] = "WD1Wm";
// 17949
f81632121_467.returns.push(1374851244566);
// 17952
f81632121_467.returns.push(1374851244567);
// 17957
f81632121_2241.returns.push(undefined);
// 17961
o49 = {};
// 17963
o49.length = 2;
// 17964
o50 = {};
// 17965
o49["0"] = o50;
// 17966
o50.type = "application/x-shockwave-flash";
// undefined
o50 = null;
// 17968
o50 = {};
// 17970
o50.length = 1;
// 17971
o64 = {};
// 17972
o50["0"] = o64;
// 17973
o64.type = "application/vnd.chromium.remoting-viewer";
// undefined
o64 = null;
// 17975
o64 = {};
// 17977
o64.length = 1;
// 17978
o65 = {};
// 17979
o64["0"] = o65;
// 17980
o65.type = "application/x-nacl";
// undefined
o65 = null;
// 17982
o65 = {};
// 17984
o65.length = 2;
// 17985
o66 = {};
// 17986
o65["0"] = o66;
// 17987
o66.type = "application/pdf";
// undefined
o66 = null;
// 17989
o66 = {};
// 17991
o66.length = 2;
// 17992
o67 = {};
// 17993
o66["0"] = o67;
// 17994
o67.type = "application/x-vnd.google.update3webcontrol.3";
// undefined
o67 = null;
// 17996
o67 = {};
// 17997
f81632121_508.returns.push(o67);
// 17998
o68 = {};
// 17999
o67.classList = o68;
// undefined
o67 = null;
// 18001
o68.remove = f81632121_1114;
// undefined
o68 = null;
// 18002
f81632121_1114.returns.push(undefined);
// 18004
o67 = {};
// 18005
f81632121_508.returns.push(o67);
// 18006
o68 = {};
// 18007
o67.classList = o68;
// undefined
o67 = null;
// 18009
o68.remove = f81632121_1114;
// undefined
o68 = null;
// 18010
f81632121_1114.returns.push(undefined);
// 18012
f81632121_467.returns.push(1374851244573);
// 18015
f81632121_467.returns.push(1374851244574);
// 18018
f81632121_467.returns.push(1374851244574);
// 18020
f81632121_467.returns.push(1374851244574);
// 18031
f81632121_467.returns.push(1374851244579);
// 18036
f81632121_467.returns.push(1374851244581);
// 18040
f81632121_467.returns.push(1374851244581);
// 18048
f81632121_1852.returns.push(undefined);
// 18050
f81632121_14.returns.push(undefined);
// 18051
f81632121_12.returns.push(79);
// 18058
o67 = {};
// 18059
f81632121_474.returns.push(o67);
// 18061
f81632121_467.returns.push(1374851244585);
// 18063
o68 = {};
// 18064
f81632121_476.returns.push(o68);
// 18065
// 18066
// 18067
// 18068
// 18069
// 18070
// 18071
o67.appendChild = f81632121_478;
// 18072
f81632121_478.returns.push(o68);
// undefined
o68 = null;
// 18074
f81632121_478.returns.push(o67);
// undefined
o67 = null;
// 18079
o67 = {};
// 18080
f81632121_474.returns.push(o67);
// 18082
f81632121_478.returns.push(o67);
// undefined
o67 = null;
// 18087
o67 = {};
// 18088
f81632121_474.returns.push(o67);
// 18090
f81632121_478.returns.push(o67);
// undefined
o67 = null;
// 18103
o67 = {};
// 18104
f81632121_474.returns.push(o67);
// 18106
f81632121_467.returns.push(1374851244591);
// 18108
o68 = {};
// 18109
f81632121_476.returns.push(o68);
// 18110
// 18111
// 18112
// 18113
// 18114
// 18115
// 18116
o67.appendChild = f81632121_478;
// 18117
f81632121_478.returns.push(o68);
// undefined
o68 = null;
// 18119
f81632121_478.returns.push(o67);
// undefined
o67 = null;
// 18124
o67 = {};
// 18125
f81632121_474.returns.push(o67);
// 18127
f81632121_478.returns.push(o67);
// undefined
o67 = null;
// 18132
o67 = {};
// 18133
f81632121_474.returns.push(o67);
// 18135
f81632121_478.returns.push(o67);
// undefined
o67 = null;
// 18140
o67 = {};
// 18141
f81632121_474.returns.push(o67);
// 18143
f81632121_478.returns.push(o67);
// undefined
o67 = null;
// 18148
o67 = {};
// 18149
f81632121_474.returns.push(o67);
// 18151
f81632121_478.returns.push(o67);
// undefined
o67 = null;
// 18161
o188.offsetHeight = 626;
// undefined
fo81632121_1_cookie.returns.push("c_user=100006118350059; csm=2; sub=4096");
// 18172
o67 = {};
// 18173
o68 = {};
// 18175
o67.nodeType = void 0;
// 18176
o67.length = 1;
// 18177
o67["0"] = "NMNM4";
// undefined
fo81632121_1_cookie.returns.push("c_user=100006118350059; csm=2; sub=4096");
// 18181
f81632121_12.returns.push(80);
// 18184
o71 = {};
// 18185
f81632121_476.returns.push(o71);
// 18187
o71.__html = void 0;
// 18189
o79 = {};
// 18190
f81632121_474.returns.push(o79);
// 18193
f81632121_478.returns.push(o79);
// undefined
o79 = null;
// 18194
o79 = {};
// 18195
o71.style = o79;
// 18196
// undefined
o79 = null;
// 18197
o79 = {};
// 18198
f81632121_4.returns.push(o79);
// 18199
o79.getPropertyValue = f81632121_1442;
// undefined
o79 = null;
// 18200
f81632121_1442.returns.push("");
// 18201
o79 = {};
// 18202
f81632121_4.returns.push(o79);
// 18203
o79.getPropertyValue = f81632121_1442;
// undefined
o79 = null;
// 18204
f81632121_1442.returns.push("");
// 18205
o79 = {};
// 18206
f81632121_4.returns.push(o79);
// 18207
o79.getPropertyValue = f81632121_1442;
// undefined
o79 = null;
// 18208
f81632121_1442.returns.push("");
// 18213
f81632121_602.returns.push(undefined);
// 18215
// 18216
o79 = {};
// 18217
f81632121_71.returns.push(o79);
// 18218
f81632121_466.returns.push(0.9777125425171107);
// 18219
// undefined
o79 = null;
// 18220
o71.parentNode = null;
// undefined
o71 = null;
// 18222
o71 = {};
// 18226
o79 = {};
// 18230
o83 = {};
// 18235
o2.getResponseHeader = f81632121_1332;
// 18238
f81632121_1332.returns.push("uLzHV1m5Dy2v/IO2QcgM3lldqL5hwPL/oCh+dU+gNaE=");
// 18241
f81632121_1332.returns.push("uLzHV1m5Dy2v/IO2QcgM3lldqL5hwPL/oCh+dU+gNaE=");
// 18242
// 18244
o2.JSBNG__status = 200;
// 18248
f81632121_467.returns.push(1374851244625);
// 18249
o3._handleXHRResponse = f81632121_1333;
// 18251
o3.getOption = f81632121_1334;
// 18252
o137 = {};
// 18253
o3.option = o137;
// 18254
o137.suppressEvaluation = false;
// 18257
f81632121_1334.returns.push(false);
// 18258
o2.responseText = "for (;;);{\"__ar\":1,\"payload\":[],\"bootloadable\":{},\"ixData\":[]}";
// 18259
o3._unshieldResponseText = f81632121_1336;
// 18260
f81632121_1336.returns.push("{\"__ar\":1,\"payload\":[],\"bootloadable\":{},\"ixData\":[]}");
// 18261
o3._interpretResponse = f81632121_1337;
// 18262
f81632121_1337.returns.push({__JSBNG_unknown_object:true});
// 18263
o3.invokeResponseHandler = f81632121_1338;
// 18264
o3.handler = null;
// 18265
o3.errorHandler = f81632121_1821;
// 18266
o3._isRelevant = f81632121_1340;
// 18267
o3._allowCrossPageTransition = void 0;
// 18268
o3.id = 9;
// 18270
f81632121_1340.returns.push(true);
// 18271
o3._dispatchResponse = f81632121_1341;
// 18272
o3.getURI = f81632121_1342;
// 18273
o196 = {};
// 18274
o3.uri = o196;
// 18276
o196.$URIBase0 = "";
// 18277
o196.$URIBase1 = "";
// 18278
o196.$URIBase2 = "";
// 18279
o196.$URIBase3 = "/ajax/chat/imps_logging.php";
// 18281
o197 = {};
// 18282
o196.$URIBase5 = o197;
// undefined
o197 = null;
// 18283
o196.$URIBase4 = "";
// 18284
f81632121_1344.returns.push("/ajax/chat/imps_logging.php");
// 18285
f81632121_1342.returns.push("/ajax/chat/imps_logging.php");
// 18286
o3.preBootloadHandler = void 0;
// 18297
f81632121_1344.returns.push("/ajax/chat/imps_logging.php");
// 18298
f81632121_1342.returns.push("/ajax/chat/imps_logging.php");
// 18300
f81632121_12.returns.push(81);
// 18304
o197 = {};
// 18305
f81632121_474.returns.push(o197);
// 18307
f81632121_478.returns.push(o197);
// undefined
o197 = null;
// 18308
f81632121_1338.returns.push(undefined);
// 18309
f81632121_1333.returns.push(undefined);
// 18312
o137.asynchronous = true;
// undefined
o137 = null;
// 18315
f81632121_1334.returns.push(true);
// 18316
// 18319
o3.clearStatusIndicator = f81632121_1347;
// 18320
o3.getStatusElement = f81632121_1348;
// 18321
o3.statusElement = null;
// 18322
f81632121_1348.returns.push(null);
// 18323
f81632121_1347.returns.push(undefined);
// 18328
f81632121_1340.returns.push(true);
// 18329
f81632121_2446 = function() { return f81632121_2446.returns[f81632121_2446.inst++]; };
f81632121_2446.returns = [];
f81632121_2446.inst = 0;
// 18330
o3.initialHandler = f81632121_2446;
// 18331
f81632121_2446.returns.push(true);
// 18332
o3.timer = null;
// 18333
f81632121_14.returns.push(undefined);
// 18335
o3._handleJSResponse = f81632121_1351;
// 18336
o3.getRelativeTo = f81632121_1352;
// 18337
o3.relativeTo = null;
// 18338
f81632121_1352.returns.push(null);
// 18339
o3._handleJSRegisters = f81632121_1353;
// 18340
f81632121_1353.returns.push(undefined);
// 18341
o3.lid = void 0;
// 18343
f81632121_1353.returns.push(undefined);
// 18344
f81632121_1351.returns.push(undefined);
// 18345
f81632121_2447 = function() { return f81632121_2447.returns[f81632121_2447.inst++]; };
f81632121_2447.returns = [];
f81632121_2447.inst = 0;
// 18346
o3.finallyHandler = f81632121_2447;
// 18347
f81632121_2447.returns.push(undefined);
// 18348
f81632121_1341.returns.push(undefined);
// 18353
// 18354
f81632121_12.returns.push(82);
// undefined
fo81632121_1_cookie.returns.push("c_user=100006118350059; csm=2; sub=4096; highContrastMode=1; wd=1034x727");
// 18360
f81632121_467.returns.push(1374851244924);
// 18366
o137 = {};
// 18367
o197 = {};
// 18369
o137.nodeType = void 0;
// 18370
o137.length = 1;
// 18371
o137["0"] = "WLpRY";
// 18382
o198 = {};
// 18383
f81632121_504.returns.push(o198);
// 18384
o198.length = 4;
// 18385
o198["0"] = o36;
// undefined
o36 = null;
// 18386
o198["1"] = o35;
// undefined
o35 = null;
// 18387
o198["2"] = o33;
// undefined
o33 = null;
// 18388
o198["3"] = o32;
// undefined
o198 = null;
// undefined
o32 = null;
// 18392
o32 = {};
// 18393
f81632121_474.returns.push(o32);
// 18395
f81632121_478.returns.push(o32);
// undefined
o32 = null;
// undefined
fo81632121_1_cookie.returns.push("c_user=100006118350059; csm=2; sub=4096; wd=1034x727");
// undefined
fo81632121_1_cookie.returns.push("c_user=100006118350059; csm=2; sub=4096; wd=1034x727");
// 18400
f81632121_12.returns.push(83);
// undefined
fo81632121_1_cookie.returns.push("c_user=100006118350059; csm=2; sub=4096; wd=1034x727");
// 18405
f81632121_467.returns.push(1374851245927);
// undefined
fo81632121_1_cookie.returns.push("c_user=100006118350059; csm=2; sub=4096; wd=1034x727");
// undefined
fo81632121_1_cookie.returns.push("c_user=100006118350059; csm=2; sub=4096; wd=1034x727");
// 18409
f81632121_12.returns.push(84);
// 18411
o32 = {};
// 18414
o32.cancelBubble = false;
// 18417
f81632121_467.returns.push(1374851246902);
// 18422
f81632121_467.returns.push(1374851246904);
// 18426
f81632121_467.returns.push(1374851246904);
// 18429
o32.returnValue = true;
// undefined
o32 = null;
// 18430
o32 = {};
// 18433
o32.cancelBubble = false;
// 18436
f81632121_467.returns.push(1374851246920);
// 18438
o32.returnValue = true;
// undefined
o32 = null;
// undefined
fo81632121_1_cookie.returns.push("c_user=100006118350059; csm=2; sub=4096; wd=1034x727");
// 18442
f81632121_467.returns.push(1374851246929);
// 18443
o32 = {};
// 18446
o32.cancelBubble = false;
// 18449
f81632121_467.returns.push(1374851246942);
// 18451
o32.returnValue = true;
// undefined
o32 = null;
// 18452
o32 = {};
// 18455
o32.cancelBubble = false;
// 18458
f81632121_467.returns.push(1374851246962);
// 18460
o32.returnValue = true;
// undefined
o32 = null;
// 18461
o32 = {};
// 18464
o32.cancelBubble = false;
// 18467
f81632121_467.returns.push(1374851246964);
// 18469
o32.returnValue = true;
// undefined
o32 = null;
// 18470
o32 = {};
// 18473
o32.cancelBubble = false;
// 18476
f81632121_467.returns.push(1374851247013);
// 18478
o32.returnValue = true;
// undefined
o32 = null;
// 18479
o32 = {};
// 18482
o32.cancelBubble = false;
// 18485
f81632121_467.returns.push(1374851247020);
// 18487
o32.returnValue = true;
// undefined
o32 = null;
// 18488
o32 = {};
// 18491
o32.cancelBubble = false;
// 18494
f81632121_467.returns.push(1374851247035);
// 18496
o32.returnValue = true;
// undefined
o32 = null;
// 18497
o32 = {};
// 18500
o32.cancelBubble = false;
// 18503
f81632121_467.returns.push(1374851247053);
// 18505
o32.returnValue = true;
// undefined
o32 = null;
// 18506
o32 = {};
// 18509
o32.cancelBubble = false;
// 18512
f81632121_467.returns.push(1374851247068);
// 18514
o32.returnValue = true;
// undefined
o32 = null;
// 18515
o32 = {};
// 18518
o32.cancelBubble = false;
// 18521
f81632121_467.returns.push(1374851247086);
// 18523
o32.returnValue = true;
// undefined
o32 = null;
// 18524
o32 = {};
// 18527
o32.cancelBubble = false;
// 18530
f81632121_467.returns.push(1374851247101);
// 18532
o32.returnValue = true;
// undefined
o32 = null;
// undefined
fo81632121_1_cookie.returns.push("c_user=100006118350059; csm=2; sub=4096; wd=1034x727");
// 18534
o32 = {};
// 18537
o32.cancelBubble = false;
// 18540
f81632121_467.returns.push(1374851247117);
// 18542
o32.returnValue = true;
// undefined
o32 = null;
// 18543
o32 = {};
// 18546
o32.cancelBubble = false;
// 18549
f81632121_467.returns.push(1374851247134);
// 18551
o32.returnValue = true;
// undefined
o32 = null;
// 18552
o32 = {};
// 18555
o32.cancelBubble = false;
// 18558
f81632121_467.returns.push(1374851247150);
// 18560
o32.returnValue = true;
// undefined
o32 = null;
// 18561
o32 = {};
// 18564
o32.cancelBubble = false;
// 18567
f81632121_467.returns.push(1374851247165);
// 18569
o32.returnValue = true;
// undefined
o32 = null;
// 18570
o32 = {};
// 18573
o32.cancelBubble = false;
// 18576
f81632121_467.returns.push(1374851247181);
// 18578
o32.returnValue = true;
// undefined
o32 = null;
// 18579
o32 = {};
// 18583
f81632121_467.returns.push(1374851247195);
// 18584
o32.cancelBubble = false;
// 18585
o32.returnValue = true;
// 18588
o32.srcElement = o109;
// 18590
o32.target = o109;
// 18597
f81632121_506.returns.push(null);
// 18603
f81632121_506.returns.push(null);
// 18609
f81632121_506.returns.push(null);
// 18615
f81632121_506.returns.push(null);
// 18621
f81632121_506.returns.push(null);
// 18627
f81632121_506.returns.push(null);
// 18633
f81632121_506.returns.push(null);
// 18639
f81632121_506.returns.push(null);
// 18644
o32.JSBNG__screenX = 970;
// 18645
o32.JSBNG__screenY = 511;
// 18646
o32.altKey = false;
// 18647
o32.bubbles = true;
// 18648
o32.button = 0;
// 18649
o32.buttons = void 0;
// 18650
o32.cancelable = false;
// 18651
o32.clientX = 902;
// 18652
o32.clientY = 346;
// 18653
o32.ctrlKey = false;
// 18654
o32.currentTarget = o0;
// 18655
o32.defaultPrevented = false;
// 18656
o32.detail = 0;
// 18657
o32.eventPhase = 3;
// 18658
o32.isTrusted = void 0;
// 18659
o32.metaKey = false;
// 18660
o32.pageX = 902;
// 18661
o32.pageY = 2732;
// 18662
o32.relatedTarget = null;
// 18663
o32.fromElement = null;
// 18666
o32.shiftKey = false;
// 18669
o32.timeStamp = 1374851247195;
// 18670
o32.type = "mousemove";
// 18671
o32.view = ow81632121;
// undefined
o32 = null;
// 18680
f81632121_1852.returns.push(undefined);
// 18683
f81632121_14.returns.push(undefined);
// 18688
f81632121_467.returns.push(1374851247221);
// 18689
f81632121_12.returns.push(85);
// 18692
o32 = {};
// 18695
o32.cancelBubble = false;
// 18698
f81632121_467.returns.push(1374851247230);
// 18700
o32.returnValue = true;
// undefined
o32 = null;
// undefined
fo81632121_1_cookie.returns.push("c_user=100006118350059; csm=2; sub=4096; wd=1034x727");
// 18703
f81632121_12.returns.push(86);
// undefined
fo81632121_1_cookie.returns.push("c_user=100006118350059; csm=2; sub=4096; wd=1034x727");
// 18708
f81632121_467.returns.push(1374851247934);
// undefined
fo81632121_1_cookie.returns.push("c_user=100006118350059; csm=2; sub=4096; wd=1034x727");
// undefined
fo81632121_1_cookie.returns.push("c_user=100006118350059; csm=2; sub=4096; wd=1034x727");
// 18713
f81632121_12.returns.push(87);
// 18716
f81632121_467.returns.push(1374851248994);
// 18717
o32 = {};
// 18720
o32.cancelBubble = false;
// 18723
f81632121_467.returns.push(1374851248996);
// 18728
f81632121_467.returns.push(1374851248999);
// 18732
f81632121_467.returns.push(1374851248999);
// 18735
o32.returnValue = true;
// undefined
o32 = null;
// undefined
fo81632121_1_cookie.returns.push("c_user=100006118350059; csm=2; sub=4096; wd=1034x727");
// 18739
f81632121_467.returns.push(1374851249001);
// 18740
o32 = {};
// 18743
o32.cancelBubble = false;
// 18746
f81632121_467.returns.push(1374851249007);
// 18748
o32.returnValue = true;
// undefined
o32 = null;
// 18749
o32 = {};
// 18752
o32.cancelBubble = false;
// 18755
f81632121_467.returns.push(1374851249029);
// 18757
o32.returnValue = true;
// undefined
o32 = null;
// 18758
o32 = {};
// 18761
o32.cancelBubble = false;
// 18764
f81632121_467.returns.push(1374851249050);
// 18766
o32.returnValue = true;
// undefined
o32 = null;
// undefined
fo81632121_1_cookie.returns.push("c_user=100006118350059; csm=2; sub=4096; wd=1034x727");
// 18768
o32 = {};
// 18771
o32.cancelBubble = false;
// 18774
f81632121_467.returns.push(1374851249117);
// 18776
o32.returnValue = true;
// undefined
o32 = null;
// 18777
o32 = {};
// 18780
o32.cancelBubble = false;
// 18783
f81632121_467.returns.push(1374851249147);
// 18785
o32.returnValue = true;
// undefined
o32 = null;
// 18786
o32 = {};
// 18789
o32.cancelBubble = false;
// 18792
f81632121_467.returns.push(1374851249181);
// 18794
o32.returnValue = true;
// undefined
o32 = null;
// 18795
o32 = {};
// 18798
o32.cancelBubble = false;
// 18801
f81632121_467.returns.push(1374851249216);
// 18803
o32.returnValue = true;
// undefined
o32 = null;
// 18804
o32 = {};
// 18807
o32.cancelBubble = false;
// 18810
f81632121_467.returns.push(1374851249250);
// 18812
o32.returnValue = true;
// undefined
o32 = null;
// 18813
o32 = {};
// 18816
o32.cancelBubble = false;
// 18819
f81632121_467.returns.push(1374851249278);
// 18821
o32.returnValue = true;
// undefined
o32 = null;
// 18822
o32 = {};
// 18825
o32.cancelBubble = false;
// 18828
f81632121_467.returns.push(1374851249309);
// 18830
o32.returnValue = true;
// undefined
o32 = null;
// 18831
o32 = {};
// 18834
o32.cancelBubble = false;
// 18837
f81632121_467.returns.push(1374851249314);
// 18839
o32.returnValue = true;
// undefined
o32 = null;
// 18840
o32 = {};
// 18843
o32.cancelBubble = false;
// 18846
f81632121_467.returns.push(1374851249330);
// 18848
o32.returnValue = true;
// undefined
o32 = null;
// 18849
o32 = {};
// 18852
o32.cancelBubble = false;
// 18855
f81632121_467.returns.push(1374851249347);
// 18857
o32.returnValue = true;
// undefined
o32 = null;
// 18858
o32 = {};
// 18861
o32.srcElement = o109;
// 18863
o32.target = o109;
// 18870
f81632121_506.returns.push(null);
// 18876
f81632121_506.returns.push(null);
// 18882
f81632121_506.returns.push(null);
// 18888
f81632121_506.returns.push(null);
// 18894
f81632121_506.returns.push(null);
// 18900
f81632121_506.returns.push(null);
// 18906
f81632121_506.returns.push(null);
// 18912
f81632121_506.returns.push(null);
// 18917
o33 = {};
// 18918
o32.relatedTarget = o33;
// 18919
o35 = {};
// 18920
o33.parentNode = o35;
// 18921
o33.nodeType = 1;
// 18922
o33.getAttribute = f81632121_506;
// 18924
f81632121_506.returns.push(null);
// 18926
o36 = {};
// 18927
o35.parentNode = o36;
// 18928
o35.nodeType = 1;
// 18929
o35.getAttribute = f81632121_506;
// undefined
o35 = null;
// 18931
f81632121_506.returns.push(null);
// 18933
o35 = {};
// 18934
o36.parentNode = o35;
// 18935
o36.nodeType = 1;
// 18936
o36.getAttribute = f81632121_506;
// undefined
o36 = null;
// 18938
f81632121_506.returns.push(null);
// 18940
o36 = {};
// 18941
o35.parentNode = o36;
// 18942
o35.nodeType = 1;
// 18943
o35.getAttribute = f81632121_506;
// 18945
f81632121_506.returns.push(null);
// 18947
o36.parentNode = o56;
// 18948
o36.nodeType = 1;
// 18949
o36.getAttribute = f81632121_506;
// undefined
o36 = null;
// 18951
f81632121_506.returns.push(null);
// 18953
o56.parentNode = o47;
// 18954
o56.nodeType = 1;
// undefined
o56 = null;
// 18957
f81632121_506.returns.push(null);
// 18959
o36 = {};
// 18960
o47.parentNode = o36;
// 18961
o47.nodeType = 1;
// 18962
o47.getAttribute = f81632121_506;
// undefined
o47 = null;
// 18964
f81632121_506.returns.push(null);
// 18966
o36.parentNode = o188;
// 18967
o36.nodeType = 1;
// 18968
o36.getAttribute = f81632121_506;
// undefined
o36 = null;
// 18970
f81632121_506.returns.push(null);
// 18972
o36 = {};
// 18973
o188.parentNode = o36;
// 18974
o188.nodeType = 1;
// undefined
o188 = null;
// 18977
f81632121_506.returns.push(null);
// 18979
o36.parentNode = o93;
// 18980
o36.nodeType = 1;
// 18981
o36.getAttribute = f81632121_506;
// undefined
o36 = null;
// 18983
f81632121_506.returns.push(null);
// 18985
o93.parentNode = o77;
// 18986
o93.nodeType = 1;
// undefined
o93 = null;
// 18989
f81632121_506.returns.push(null);
// 18991
o36 = {};
// 18992
o77.parentNode = o36;
// 18993
o77.nodeType = 1;
// undefined
o77 = null;
// 18996
f81632121_506.returns.push(null);
// 18998
o36.parentNode = o122;
// 18999
o36.nodeType = 1;
// 19000
o36.getAttribute = f81632121_506;
// undefined
o36 = null;
// 19002
f81632121_506.returns.push(null);
// 19004
o122.parentNode = o109;
// 19005
o122.nodeType = 1;
// 19006
o122.getAttribute = f81632121_506;
// undefined
o122 = null;
// 19008
f81632121_506.returns.push(null);
// 19014
f81632121_506.returns.push(null);
// 19020
f81632121_506.returns.push(null);
// 19026
f81632121_506.returns.push(null);
// 19032
f81632121_506.returns.push(null);
// 19038
f81632121_506.returns.push(null);
// 19044
f81632121_506.returns.push(null);
// 19050
f81632121_506.returns.push(null);
// 19056
f81632121_506.returns.push(null);
// 19061
o32.cancelBubble = false;
// 19062
o32.returnValue = true;
// undefined
o32 = null;
// 19063
o32 = {};
// 19066
o32.cancelBubble = false;
// 19069
f81632121_467.returns.push(1374851249570);
// 19074
f81632121_467.returns.push(1374851249572);
// 19078
f81632121_467.returns.push(1374851249578);
// 19082
f81632121_1007.returns.push(undefined);
// 19084
o32.returnValue = true;
// 19087
o32.srcElement = o33;
// 19089
o32.target = o33;
// 19096
f81632121_506.returns.push(null);
// 19102
f81632121_506.returns.push(null);
// 19108
f81632121_506.returns.push(null);
// 19114
f81632121_506.returns.push(null);
// 19120
f81632121_506.returns.push(null);
// 19126
f81632121_506.returns.push(null);
// 19132
f81632121_506.returns.push(null);
// 19138
f81632121_506.returns.push(null);
// 19144
f81632121_506.returns.push(null);
// 19150
f81632121_506.returns.push(null);
// 19156
f81632121_506.returns.push(null);
// 19162
f81632121_506.returns.push(null);
// 19168
f81632121_506.returns.push(null);
// 19174
f81632121_506.returns.push(null);
// 19180
f81632121_506.returns.push(null);
// 19186
f81632121_506.returns.push(null);
// 19192
f81632121_506.returns.push(null);
// 19198
f81632121_506.returns.push(null);
// 19204
f81632121_506.returns.push(null);
// 19210
f81632121_506.returns.push(null);
// 19216
f81632121_506.returns.push(null);
// 19222
f81632121_506.returns.push(null);
// 19227
o32.relatedTarget = o109;
// undefined
o32 = null;
// 19230
o32 = {};
// 19234
f81632121_467.returns.push(1374851249593);
// 19235
o32.cancelBubble = false;
// 19236
o32.returnValue = true;
// 19239
o32.srcElement = o33;
// 19241
o32.target = o33;
// 19248
f81632121_506.returns.push(null);
// 19254
f81632121_506.returns.push(null);
// 19260
f81632121_506.returns.push(null);
// 19266
f81632121_506.returns.push(null);
// 19272
f81632121_506.returns.push(null);
// 19278
f81632121_506.returns.push(null);
// 19284
f81632121_506.returns.push(null);
// 19290
f81632121_506.returns.push(null);
// 19296
f81632121_506.returns.push(null);
// 19302
f81632121_506.returns.push(null);
// 19308
f81632121_506.returns.push(null);
// 19314
f81632121_506.returns.push(null);
// 19320
f81632121_506.returns.push(null);
// 19326
f81632121_506.returns.push(null);
// 19332
f81632121_506.returns.push(null);
// 19338
f81632121_506.returns.push(null);
// 19344
f81632121_506.returns.push(null);
// 19350
f81632121_506.returns.push(null);
// 19356
f81632121_506.returns.push(null);
// 19362
f81632121_506.returns.push(null);
// 19368
f81632121_506.returns.push(null);
// 19374
f81632121_506.returns.push(null);
// 19379
o32.JSBNG__screenX = 970;
// 19380
o32.JSBNG__screenY = 511;
// 19381
o32.altKey = false;
// 19382
o32.bubbles = true;
// 19383
o32.button = 0;
// 19384
o32.buttons = void 0;
// 19385
o32.cancelable = false;
// 19386
o32.clientX = 902;
// 19387
o32.clientY = 346;
// 19388
o32.ctrlKey = false;
// 19389
o32.currentTarget = o0;
// 19390
o32.defaultPrevented = false;
// 19391
o32.detail = 0;
// 19392
o32.eventPhase = 3;
// 19393
o32.isTrusted = void 0;
// 19394
o32.metaKey = false;
// 19395
o32.pageX = 902;
// 19396
o32.pageY = 346;
// 19397
o32.relatedTarget = null;
// 19398
o32.fromElement = null;
// 19401
o32.shiftKey = false;
// 19404
o32.timeStamp = 1374851249592;
// 19405
o32.type = "mousemove";
// 19406
o32.view = ow81632121;
// undefined
o32 = null;
// 19415
f81632121_1852.returns.push(undefined);
// 19418
f81632121_14.returns.push(undefined);
// 19419
f81632121_12.returns.push(88);
// undefined
fo81632121_1_cookie.returns.push("c_user=100006118350059; csm=2; sub=4096; wd=1034x727");
// 19423
o32 = {};
// 19427
f81632121_467.returns.push(1374851249632);
// 19428
o32.cancelBubble = false;
// 19429
o32.returnValue = true;
// 19432
o32.srcElement = o33;
// 19434
o32.target = o33;
// 19441
f81632121_506.returns.push(null);
// 19447
f81632121_506.returns.push(null);
// 19453
f81632121_506.returns.push(null);
// 19459
f81632121_506.returns.push(null);
// 19465
f81632121_506.returns.push(null);
// 19471
f81632121_506.returns.push(null);
// 19477
f81632121_506.returns.push(null);
// 19483
f81632121_506.returns.push(null);
// 19489
f81632121_506.returns.push(null);
// 19495
f81632121_506.returns.push(null);
// 19501
f81632121_506.returns.push(null);
// 19507
f81632121_506.returns.push(null);
// 19513
f81632121_506.returns.push(null);
// 19519
f81632121_506.returns.push(null);
// 19525
f81632121_506.returns.push(null);
// 19531
f81632121_506.returns.push(null);
// 19537
f81632121_506.returns.push(null);
// 19543
f81632121_506.returns.push(null);
// 19549
f81632121_506.returns.push(null);
// 19555
f81632121_506.returns.push(null);
// 19561
f81632121_506.returns.push(null);
// 19567
f81632121_506.returns.push(null);
// 19572
o32.JSBNG__screenX = 970;
// 19573
o32.JSBNG__screenY = 511;
// 19574
o32.altKey = false;
// 19575
o32.bubbles = true;
// 19576
o32.button = 0;
// 19577
o32.buttons = void 0;
// 19578
o32.cancelable = false;
// 19579
o32.clientX = 902;
// 19580
o32.clientY = 346;
// 19581
o32.ctrlKey = false;
// 19582
o32.currentTarget = o0;
// 19583
o32.defaultPrevented = false;
// 19584
o32.detail = 0;
// 19585
o32.eventPhase = 3;
// 19586
o32.isTrusted = void 0;
// 19587
o32.metaKey = false;
// 19588
o32.pageX = 902;
// 19589
o32.pageY = 346;
// 19590
o32.relatedTarget = null;
// 19591
o32.fromElement = null;
// 19594
o32.shiftKey = false;
// 19597
o32.timeStamp = 1374851249632;
// 19598
o32.type = "mousemove";
// 19599
o32.view = ow81632121;
// undefined
o32 = null;
// 19608
f81632121_1852.returns.push(undefined);
// 19611
f81632121_14.returns.push(undefined);
// 19612
f81632121_12.returns.push(89);
// 19615
o32 = {};
// 19618
o32.cancelBubble = false;
// 19621
f81632121_467.returns.push(1374851249851);
// 19623
o32.returnValue = true;
// undefined
o32 = null;
// 19625
f81632121_12.returns.push(90);
// 19627
o32 = {};
// 19630
o32.cancelBubble = false;
// 19633
f81632121_467.returns.push(1374851249869);
// 19635
o32.returnValue = true;
// undefined
o32 = null;
// 19636
o32 = {};
// 19639
o32.cancelBubble = false;
// 19642
f81632121_467.returns.push(1374851249883);
// 19644
o32.returnValue = true;
// undefined
o32 = null;
// 19645
o32 = {};
// 19648
o32.cancelBubble = false;
// 19651
f81632121_467.returns.push(1374851249901);
// 19653
o32.returnValue = true;
// undefined
o32 = null;
// 19654
o32 = {};
// 19657
o32.cancelBubble = false;
// 19660
f81632121_467.returns.push(1374851249908);
// 19662
o32.returnValue = true;
// undefined
o32 = null;
// 19663
o32 = {};
// 19666
o32.cancelBubble = false;
// 19669
f81632121_467.returns.push(1374851249924);
// 19671
o32.returnValue = true;
// undefined
o32 = null;
// 19672
o32 = {};
// 19675
o32.cancelBubble = false;
// 19678
f81632121_467.returns.push(1374851249931);
// 19680
o32.returnValue = true;
// undefined
o32 = null;
// 19681
o32 = {};
// 19684
o32.cancelBubble = false;
// 19687
f81632121_467.returns.push(1374851249948);
// 19689
o32.returnValue = true;
// undefined
o32 = null;
// 19690
o32 = {};
// 19693
o32.cancelBubble = false;
// 19696
f81632121_467.returns.push(1374851249962);
// 19698
o32.returnValue = true;
// undefined
o32 = null;
// 19699
o32 = {};
// 19702
o32.cancelBubble = false;
// 19705
f81632121_467.returns.push(1374851249973);
// 19707
o32.returnValue = true;
// undefined
o32 = null;
// 19708
o32 = {};
// 19711
o32.cancelBubble = false;
// 19714
f81632121_467.returns.push(1374851249979);
// 19716
o32.returnValue = true;
// undefined
o32 = null;
// 19717
o32 = {};
// 19720
o32.cancelBubble = false;
// 19723
f81632121_467.returns.push(1374851249996);
// 19725
o32.returnValue = true;
// undefined
o32 = null;
// undefined
fo81632121_1_cookie.returns.push("c_user=100006118350059; csm=2; sub=4096; wd=1034x727");
// 19729
f81632121_467.returns.push(1374851250009);
// 19730
o32 = {};
// 19733
o32.cancelBubble = false;
// 19736
f81632121_467.returns.push(1374851250011);
// 19738
o32.returnValue = true;
// undefined
o32 = null;
// 19739
o32 = {};
// 19742
o32.cancelBubble = false;
// 19745
f81632121_467.returns.push(1374851250027);
// 19747
o32.returnValue = true;
// undefined
o32 = null;
// 19748
o32 = {};
// 19751
o32.cancelBubble = false;
// 19754
f81632121_467.returns.push(1374851250050);
// 19756
o32.returnValue = true;
// undefined
o32 = null;
// 19757
o32 = {};
// 19760
o32.cancelBubble = false;
// 19763
f81632121_467.returns.push(1374851250076);
// 19768
f81632121_467.returns.push(1374851250079);
// 19772
f81632121_467.returns.push(1374851250079);
// 19775
o32.returnValue = true;
// undefined
o32 = null;
// undefined
fo81632121_1_cookie.returns.push("c_user=100006118350059; csm=2; sub=4096; wd=1034x727");
// 19777
o32 = {};
// 19780
o32.cancelBubble = false;
// 19783
f81632121_467.returns.push(1374851250243);
// 19785
o32.returnValue = true;
// undefined
o32 = null;
// 19786
o32 = {};
// 19789
o32.cancelBubble = false;
// 19792
f81632121_467.returns.push(1374851250275);
// 19794
o32.returnValue = true;
// undefined
o32 = null;
// 19795
o32 = {};
// 19799
f81632121_467.returns.push(1374851250309);
// 19800
o32.cancelBubble = false;
// 19801
o32.returnValue = true;
// 19804
o32.srcElement = o33;
// 19806
o32.target = o33;
// 19813
f81632121_506.returns.push(null);
// 19819
f81632121_506.returns.push(null);
// 19825
f81632121_506.returns.push(null);
// 19831
f81632121_506.returns.push(null);
// 19837
f81632121_506.returns.push(null);
// 19843
f81632121_506.returns.push(null);
// 19849
f81632121_506.returns.push(null);
// 19855
f81632121_506.returns.push(null);
// 19861
f81632121_506.returns.push(null);
// 19867
f81632121_506.returns.push(null);
// 19873
f81632121_506.returns.push(null);
// 19879
f81632121_506.returns.push(null);
// 19885
f81632121_506.returns.push(null);
// 19891
f81632121_506.returns.push(null);
// 19897
f81632121_506.returns.push(null);
// 19903
f81632121_506.returns.push(null);
// 19909
f81632121_506.returns.push(null);
// 19915
f81632121_506.returns.push(null);
// 19921
f81632121_506.returns.push(null);
// 19927
f81632121_506.returns.push(null);
// 19933
f81632121_506.returns.push(null);
// 19939
f81632121_506.returns.push(null);
// 19944
o32.JSBNG__screenX = 969;
// 19945
o32.JSBNG__screenY = 511;
// 19946
o32.altKey = false;
// 19947
o32.bubbles = true;
// 19948
o32.button = 0;
// 19949
o32.buttons = void 0;
// 19950
o32.cancelable = false;
// 19951
o32.clientX = 901;
// 19952
o32.clientY = 346;
// 19953
o32.ctrlKey = false;
// 19954
o32.currentTarget = o0;
// 19955
o32.defaultPrevented = false;
// 19956
o32.detail = 0;
// 19957
o32.eventPhase = 3;
// 19958
o32.isTrusted = void 0;
// 19959
o32.metaKey = false;
// 19960
o32.pageX = 901;
// 19961
o32.pageY = 346;
// 19962
o32.relatedTarget = null;
// 19963
o32.fromElement = null;
// 19966
o32.shiftKey = false;
// 19969
o32.timeStamp = 1374851250306;
// 19970
o32.type = "mousemove";
// 19971
o32.view = ow81632121;
// undefined
o32 = null;
// 19980
f81632121_1852.returns.push(undefined);
// 19983
f81632121_14.returns.push(undefined);
// 19984
f81632121_12.returns.push(91);
// 19987
o32 = {};
// 19990
o32.srcElement = o33;
// 19992
o32.target = o33;
// 19999
f81632121_506.returns.push(null);
// 20005
f81632121_506.returns.push(null);
// 20011
f81632121_506.returns.push(null);
// 20017
f81632121_506.returns.push(null);
// 20023
f81632121_506.returns.push(null);
// 20029
f81632121_506.returns.push(null);
// 20035
f81632121_506.returns.push(null);
// 20041
f81632121_506.returns.push(null);
// 20047
f81632121_506.returns.push(null);
// 20053
f81632121_506.returns.push(null);
// 20059
f81632121_506.returns.push(null);
// 20065
f81632121_506.returns.push(null);
// 20071
f81632121_506.returns.push(null);
// 20077
f81632121_506.returns.push(null);
// 20083
f81632121_506.returns.push(null);
// 20089
f81632121_506.returns.push(null);
// 20095
f81632121_506.returns.push(null);
// 20101
f81632121_506.returns.push(null);
// 20107
f81632121_506.returns.push(null);
// 20113
f81632121_506.returns.push(null);
// 20119
f81632121_506.returns.push(null);
// 20125
f81632121_506.returns.push(null);
// 20130
o32.relatedTarget = o85;
// 20131
o36 = {};
// 20132
o85.parentNode = o36;
// 20133
o85.nodeType = 1;
// 20134
o85.getAttribute = f81632121_506;
// 20136
f81632121_506.returns.push(null);
// 20138
o36.parentNode = o35;
// undefined
o35 = null;
// 20139
o36.nodeType = 1;
// 20140
o36.getAttribute = f81632121_506;
// undefined
o36 = null;
// 20142
f81632121_506.returns.push(null);
// 20148
f81632121_506.returns.push(null);
// 20154
f81632121_506.returns.push(null);
// 20160
f81632121_506.returns.push(null);
// 20166
f81632121_506.returns.push(null);
// 20172
f81632121_506.returns.push(null);
// 20178
f81632121_506.returns.push(null);
// 20184
f81632121_506.returns.push(null);
// 20190
f81632121_506.returns.push(null);
// 20196
f81632121_506.returns.push(null);
// 20202
f81632121_506.returns.push(null);
// 20208
f81632121_506.returns.push(null);
// 20214
f81632121_506.returns.push(null);
// 20220
f81632121_506.returns.push(null);
// 20226
f81632121_506.returns.push(null);
// 20232
f81632121_506.returns.push(null);
// 20238
f81632121_506.returns.push(null);
// 20244
f81632121_506.returns.push(null);
// 20250
f81632121_506.returns.push(null);
// 20256
f81632121_506.returns.push(null);
// 20261
o32.cancelBubble = false;
// 20262
o32.returnValue = true;
// undefined
o32 = null;
// 20263
o32 = {};
// 20266
o32.cancelBubble = false;
// 20269
f81632121_467.returns.push(1374851250391);
// 20272
f81632121_1007.returns.push(undefined);
// 20274
o32.returnValue = true;
// 20277
o32.srcElement = o85;
// 20279
o32.target = o85;
// 20286
f81632121_506.returns.push(null);
// 20292
f81632121_506.returns.push(null);
// 20298
f81632121_506.returns.push(null);
// 20304
f81632121_506.returns.push(null);
// 20310
f81632121_506.returns.push(null);
// 20316
f81632121_506.returns.push(null);
// 20322
f81632121_506.returns.push(null);
// 20328
f81632121_506.returns.push(null);
// 20334
f81632121_506.returns.push(null);
// 20340
f81632121_506.returns.push(null);
// 20346
f81632121_506.returns.push(null);
// 20352
f81632121_506.returns.push(null);
// 20358
f81632121_506.returns.push(null);
// 20364
f81632121_506.returns.push(null);
// 20370
f81632121_506.returns.push(null);
// 20376
f81632121_506.returns.push(null);
// 20382
f81632121_506.returns.push(null);
// 20388
f81632121_506.returns.push(null);
// 20394
f81632121_506.returns.push(null);
// 20400
f81632121_506.returns.push(null);
// 20406
f81632121_506.returns.push(null);
// 20411
o32.relatedTarget = o33;
// undefined
o32 = null;
// undefined
o33 = null;
// 20414
o32 = {};
// 20418
f81632121_467.returns.push(1374851250398);
// 20419
o32.cancelBubble = false;
// 20420
o32.returnValue = true;
// 20423
o32.srcElement = o85;
// 20425
o32.target = o85;
// 20432
f81632121_506.returns.push(null);
// 20438
f81632121_506.returns.push(null);
// 20444
f81632121_506.returns.push(null);
// 20450
f81632121_506.returns.push(null);
// 20456
f81632121_506.returns.push(null);
// 20462
f81632121_506.returns.push(null);
// 20468
f81632121_506.returns.push(null);
// 20474
f81632121_506.returns.push(null);
// 20480
f81632121_506.returns.push(null);
// 20486
f81632121_506.returns.push(null);
// 20492
f81632121_506.returns.push(null);
// 20498
f81632121_506.returns.push(null);
// 20504
f81632121_506.returns.push(null);
// 20510
f81632121_506.returns.push(null);
// 20516
f81632121_506.returns.push(null);
// 20522
f81632121_506.returns.push(null);
// 20528
f81632121_506.returns.push(null);
// 20534
f81632121_506.returns.push(null);
// 20540
f81632121_506.returns.push(null);
// 20546
f81632121_506.returns.push(null);
// 20552
f81632121_506.returns.push(null);
// 20557
o32.JSBNG__screenX = 964;
// 20558
o32.JSBNG__screenY = 483;
// 20559
o32.altKey = false;
// 20560
o32.bubbles = true;
// 20561
o32.button = 0;
// 20562
o32.buttons = void 0;
// 20563
o32.cancelable = false;
// 20564
o32.clientX = 896;
// 20565
o32.clientY = 318;
// 20566
o32.ctrlKey = false;
// 20567
o32.currentTarget = o0;
// 20568
o32.defaultPrevented = false;
// 20569
o32.detail = 0;
// 20570
o32.eventPhase = 3;
// 20571
o32.isTrusted = void 0;
// 20572
o32.metaKey = false;
// 20573
o32.pageX = 896;
// 20574
o32.pageY = 318;
// 20575
o32.relatedTarget = null;
// 20576
o32.fromElement = null;
// 20579
o32.shiftKey = false;
// 20582
o32.timeStamp = 1374851250398;
// 20583
o32.type = "mousemove";
// 20584
o32.view = ow81632121;
// undefined
o32 = null;
// 20593
f81632121_1852.returns.push(undefined);
// 20596
f81632121_14.returns.push(undefined);
// 20597
f81632121_12.returns.push(92);
// 20600
o32 = {};
// 20604
f81632121_467.returns.push(1374851250423);
// 20605
o32.cancelBubble = false;
// 20606
o32.returnValue = true;
// 20609
o32.srcElement = o85;
// 20611
o32.target = o85;
// 20618
f81632121_506.returns.push(null);
// 20624
f81632121_506.returns.push(null);
// 20630
f81632121_506.returns.push(null);
// 20636
f81632121_506.returns.push(null);
// 20642
f81632121_506.returns.push(null);
// 20648
f81632121_506.returns.push(null);
// 20654
f81632121_506.returns.push(null);
// 20660
f81632121_506.returns.push(null);
// 20666
f81632121_506.returns.push(null);
// 20672
f81632121_506.returns.push(null);
// 20678
f81632121_506.returns.push(null);
// 20684
f81632121_506.returns.push(null);
// 20690
f81632121_506.returns.push(null);
// 20696
f81632121_506.returns.push(null);
// 20702
f81632121_506.returns.push(null);
// 20708
f81632121_506.returns.push(null);
// 20714
f81632121_506.returns.push(null);
// 20720
f81632121_506.returns.push(null);
// 20726
f81632121_506.returns.push(null);
// 20732
f81632121_506.returns.push(null);
// 20738
f81632121_506.returns.push(null);
// 20743
o32.JSBNG__screenX = 956;
// 20744
o32.JSBNG__screenY = 468;
// 20745
o32.altKey = false;
// 20746
o32.bubbles = true;
// 20747
o32.button = 0;
// 20748
o32.buttons = void 0;
// 20749
o32.cancelable = false;
// 20750
o32.clientX = 888;
// 20751
o32.clientY = 303;
// 20752
o32.ctrlKey = false;
// 20753
o32.currentTarget = o0;
// 20754
o32.defaultPrevented = false;
// 20755
o32.detail = 0;
// 20756
o32.eventPhase = 3;
// 20757
o32.isTrusted = void 0;
// 20758
o32.metaKey = false;
// 20759
o32.pageX = 888;
// 20760
o32.pageY = 303;
// 20761
o32.relatedTarget = null;
// 20762
o32.fromElement = null;
// 20765
o32.shiftKey = false;
// 20768
o32.timeStamp = 1374851250423;
// 20769
o32.type = "mousemove";
// 20770
o32.view = ow81632121;
// undefined
o32 = null;
// 20779
f81632121_1852.returns.push(undefined);
// 20782
f81632121_14.returns.push(undefined);
// 20783
f81632121_12.returns.push(93);
// 20786
o32 = {};
// 20790
f81632121_467.returns.push(1374851250436);
// 20791
o32.cancelBubble = false;
// 20792
o32.returnValue = true;
// 20795
o32.srcElement = o85;
// 20797
o32.target = o85;
// 20804
f81632121_506.returns.push(null);
// 20810
f81632121_506.returns.push(null);
// 20816
f81632121_506.returns.push(null);
// 20822
f81632121_506.returns.push(null);
// 20828
f81632121_506.returns.push(null);
// 20834
f81632121_506.returns.push(null);
// 20840
f81632121_506.returns.push(null);
// 20846
f81632121_506.returns.push(null);
// 20852
f81632121_506.returns.push(null);
// 20858
f81632121_506.returns.push(null);
// 20864
f81632121_506.returns.push(null);
// 20870
f81632121_506.returns.push(null);
// 20876
f81632121_506.returns.push(null);
// 20882
f81632121_506.returns.push(null);
// 20888
f81632121_506.returns.push(null);
// 20894
f81632121_506.returns.push(null);
// 20900
f81632121_506.returns.push(null);
// 20906
f81632121_506.returns.push(null);
// 20912
f81632121_506.returns.push(null);
// 20918
f81632121_506.returns.push(null);
// 20924
f81632121_506.returns.push(null);
// 20929
o32.JSBNG__screenX = 951;
// 20930
o32.JSBNG__screenY = 466;
// 20931
o32.altKey = false;
// 20932
o32.bubbles = true;
// 20933
o32.button = 0;
// 20934
o32.buttons = void 0;
// 20935
o32.cancelable = false;
// 20936
o32.clientX = 883;
// 20937
o32.clientY = 301;
// 20938
o32.ctrlKey = false;
// 20939
o32.currentTarget = o0;
// 20940
o32.defaultPrevented = false;
// 20941
o32.detail = 0;
// 20942
o32.eventPhase = 3;
// 20943
o32.isTrusted = void 0;
// 20944
o32.metaKey = false;
// 20945
o32.pageX = 883;
// 20946
o32.pageY = 301;
// 20947
o32.relatedTarget = null;
// 20948
o32.fromElement = null;
// 20951
o32.shiftKey = false;
// 20954
o32.timeStamp = 1374851250436;
// 20955
o32.type = "mousemove";
// 20956
o32.view = ow81632121;
// undefined
o32 = null;
// 20965
f81632121_1852.returns.push(undefined);
// 20968
f81632121_14.returns.push(undefined);
// 20969
f81632121_12.returns.push(94);
// 20972
o32 = {};
// 20975
o32.srcElement = o85;
// 20977
o32.target = o85;
// 20984
f81632121_506.returns.push(null);
// 20990
f81632121_506.returns.push(null);
// 20996
f81632121_506.returns.push(null);
// 21002
f81632121_506.returns.push(null);
// 21008
f81632121_506.returns.push(null);
// 21014
f81632121_506.returns.push(null);
// 21020
f81632121_506.returns.push(null);
// 21026
f81632121_506.returns.push(null);
// 21032
f81632121_506.returns.push(null);
// 21038
f81632121_506.returns.push(null);
// 21044
f81632121_506.returns.push(null);
// 21050
f81632121_506.returns.push(null);
// 21056
f81632121_506.returns.push(null);
// 21062
f81632121_506.returns.push(null);
// 21068
f81632121_506.returns.push(null);
// 21074
f81632121_506.returns.push(null);
// 21080
f81632121_506.returns.push(null);
// 21086
f81632121_506.returns.push(null);
// 21092
f81632121_506.returns.push(null);
// 21098
f81632121_506.returns.push(null);
// 21104
f81632121_506.returns.push(null);
// 21109
o32.relatedTarget = o109;
// 21114
f81632121_506.returns.push(null);
// 21120
f81632121_506.returns.push(null);
// 21126
f81632121_506.returns.push(null);
// 21132
f81632121_506.returns.push(null);
// 21138
f81632121_506.returns.push(null);
// 21144
f81632121_506.returns.push(null);
// 21150
f81632121_506.returns.push(null);
// 21156
f81632121_506.returns.push(null);
// 21161
o32.cancelBubble = false;
// 21162
o32.returnValue = true;
// undefined
o32 = null;
// 21163
o32 = {};
// 21166
o32.cancelBubble = false;
// 21169
f81632121_467.returns.push(1374851250457);
// 21172
f81632121_1007.returns.push(undefined);
// 21174
o32.returnValue = true;
// 21177
o32.srcElement = o109;
// 21179
o32.target = o109;
// 21186
f81632121_506.returns.push(null);
// 21192
f81632121_506.returns.push(null);
// 21198
f81632121_506.returns.push(null);
// 21204
f81632121_506.returns.push(null);
// 21210
f81632121_506.returns.push(null);
// 21216
f81632121_506.returns.push(null);
// 21222
f81632121_506.returns.push(null);
// 21228
f81632121_506.returns.push(null);
// 21233
o32.relatedTarget = o85;
// undefined
o32 = null;
// undefined
o85 = null;
// 21236
o32 = {};
// 21240
f81632121_467.returns.push(1374851250458);
// 21241
o32.cancelBubble = false;
// 21242
o32.returnValue = true;
// 21245
o32.srcElement = o109;
// 21247
o32.target = o109;
// 21254
f81632121_506.returns.push(null);
// 21260
f81632121_506.returns.push(null);
// 21266
f81632121_506.returns.push(null);
// 21272
f81632121_506.returns.push(null);
// 21278
f81632121_506.returns.push(null);
// 21284
f81632121_506.returns.push(null);
// 21290
f81632121_506.returns.push(null);
// 21296
f81632121_506.returns.push(null);
// 21301
o32.JSBNG__screenX = 945;
// 21302
o32.JSBNG__screenY = 465;
// 21303
o32.altKey = false;
// 21304
o32.bubbles = true;
// 21305
o32.button = 0;
// 21306
o32.buttons = void 0;
// 21307
o32.cancelable = false;
// 21308
o32.clientX = 877;
// 21309
o32.clientY = 300;
// 21310
o32.ctrlKey = false;
// 21311
o32.currentTarget = o0;
// 21312
o32.defaultPrevented = false;
// 21313
o32.detail = 0;
// 21314
o32.eventPhase = 3;
// 21315
o32.isTrusted = void 0;
// 21316
o32.metaKey = false;
// 21317
o32.pageX = 877;
// 21318
o32.pageY = 300;
// 21319
o32.relatedTarget = null;
// 21320
o32.fromElement = null;
// 21323
o32.shiftKey = false;
// 21326
o32.timeStamp = 1374851250458;
// 21327
o32.type = "mousemove";
// 21328
o32.view = ow81632121;
// undefined
o32 = null;
// 21337
f81632121_1852.returns.push(undefined);
// 21340
f81632121_14.returns.push(undefined);
// 21341
f81632121_12.returns.push(95);
// 21344
o32 = {};
// 21347
o32.srcElement = o109;
// 21349
o32.target = o109;
// 21356
f81632121_506.returns.push(null);
// 21362
f81632121_506.returns.push(null);
// 21368
f81632121_506.returns.push(null);
// 21374
f81632121_506.returns.push(null);
// 21380
f81632121_506.returns.push(null);
// 21386
f81632121_506.returns.push(null);
// 21392
f81632121_506.returns.push(null);
// 21398
f81632121_506.returns.push(null);
// 21403
o33 = {};
// 21404
o32.relatedTarget = o33;
// 21405
o35 = {};
// 21406
o33.parentNode = o35;
// 21407
o33.nodeType = 1;
// 21408
o33.getAttribute = f81632121_506;
// 21410
f81632121_506.returns.push(null);
// 21412
o35.parentNode = o24;
// 21413
o35.nodeType = 1;
// 21414
o35.getAttribute = f81632121_506;
// undefined
o35 = null;
// 21416
f81632121_506.returns.push(null);
// 21418
o24.parentNode = o91;
// 21419
o24.nodeType = 1;
// 21420
o24.getAttribute = f81632121_506;
// undefined
o24 = null;
// 21422
f81632121_506.returns.push(null);
// 21425
o91.nodeType = 1;
// 21426
o91.getAttribute = f81632121_506;
// undefined
o91 = null;
// 21428
f81632121_506.returns.push(null);
// 21431
o92.nodeType = 1;
// 21432
o92.getAttribute = f81632121_506;
// undefined
o92 = null;
// 21434
f81632121_506.returns.push(null);
// 21436
o185.parentNode = o21;
// 21437
o185.nodeType = 1;
// 21438
o185.getAttribute = f81632121_506;
// 21440
f81632121_506.returns.push(null);
// 21443
o21.nodeType = 1;
// 21446
f81632121_506.returns.push(null);
// 21449
o20.nodeType = 1;
// 21452
f81632121_506.returns.push(null);
// 21455
o45.nodeType = 1;
// 21456
o45.getAttribute = f81632121_506;
// 21458
f81632121_506.returns.push(null);
// 21464
f81632121_506.returns.push(null);
// 21470
f81632121_506.returns.push(null);
// 21476
f81632121_506.returns.push(null);
// 21482
f81632121_506.returns.push(null);
// 21488
f81632121_506.returns.push(null);
// 21494
f81632121_506.returns.push(null);
// 21500
f81632121_506.returns.push(null);
// 21506
f81632121_506.returns.push(null);
// 21511
o32.cancelBubble = false;
// 21512
o32.returnValue = true;
// undefined
o32 = null;
// 21513
o24 = {};
// 21516
o24.cancelBubble = false;
// 21519
f81632121_467.returns.push(1374851250484);
// 21522
f81632121_1007.returns.push(undefined);
// 21524
o24.returnValue = true;
// 21527
o24.srcElement = o33;
// 21529
o24.target = o33;
// 21536
f81632121_506.returns.push(null);
// 21542
f81632121_506.returns.push(null);
// 21548
f81632121_506.returns.push(null);
// 21554
f81632121_506.returns.push(null);
// 21560
f81632121_506.returns.push(null);
// 21566
f81632121_506.returns.push(null);
// 21572
f81632121_506.returns.push(null);
// 21578
f81632121_506.returns.push(null);
// 21584
f81632121_506.returns.push(null);
// 21590
f81632121_506.returns.push(null);
// 21596
f81632121_506.returns.push(null);
// 21602
f81632121_506.returns.push(null);
// 21608
f81632121_506.returns.push(null);
// 21614
f81632121_506.returns.push(null);
// 21620
f81632121_506.returns.push(null);
// 21626
f81632121_506.returns.push(null);
// 21632
f81632121_506.returns.push(null);
// 21637
o24.relatedTarget = o109;
// undefined
o24 = null;
// 21640
o24 = {};
// 21644
f81632121_467.returns.push(1374851250489);
// 21645
o24.cancelBubble = false;
// 21646
o24.returnValue = true;
// 21649
o24.srcElement = o33;
// 21651
o24.target = o33;
// 21658
f81632121_506.returns.push(null);
// 21664
f81632121_506.returns.push(null);
// 21670
f81632121_506.returns.push(null);
// 21676
f81632121_506.returns.push(null);
// 21682
f81632121_506.returns.push(null);
// 21688
f81632121_506.returns.push(null);
// 21694
f81632121_506.returns.push(null);
// 21700
f81632121_506.returns.push(null);
// 21706
f81632121_506.returns.push(null);
// 21712
f81632121_506.returns.push(null);
// 21718
f81632121_506.returns.push(null);
// 21724
f81632121_506.returns.push(null);
// 21730
f81632121_506.returns.push(null);
// 21736
f81632121_506.returns.push(null);
// 21742
f81632121_506.returns.push(null);
// 21748
f81632121_506.returns.push(null);
// 21754
f81632121_506.returns.push(null);
// 21759
o24.JSBNG__screenX = 933;
// 21760
o24.JSBNG__screenY = 465;
// 21761
o24.altKey = false;
// 21762
o24.bubbles = true;
// 21763
o24.button = 0;
// 21764
o24.buttons = void 0;
// 21765
o24.cancelable = false;
// 21766
o24.clientX = 865;
// 21767
o24.clientY = 300;
// 21768
o24.ctrlKey = false;
// 21769
o24.currentTarget = o0;
// 21770
o24.defaultPrevented = false;
// 21771
o24.detail = 0;
// 21772
o24.eventPhase = 3;
// 21773
o24.isTrusted = void 0;
// 21774
o24.metaKey = false;
// 21775
o24.pageX = 865;
// 21776
o24.pageY = 300;
// 21777
o24.relatedTarget = null;
// 21778
o24.fromElement = null;
// 21781
o24.shiftKey = false;
// 21784
o24.timeStamp = 1374851250489;
// 21785
o24.type = "mousemove";
// 21786
o24.view = ow81632121;
// undefined
o24 = null;
// 21795
f81632121_1852.returns.push(undefined);
// 21798
f81632121_14.returns.push(undefined);
// 21799
f81632121_12.returns.push(96);
// 21802
o24 = {};
// 21805
o24.srcElement = o33;
// 21807
o24.target = o33;
// 21814
f81632121_506.returns.push(null);
// 21820
f81632121_506.returns.push(null);
// 21826
f81632121_506.returns.push(null);
// 21832
f81632121_506.returns.push(null);
// 21838
f81632121_506.returns.push(null);
// 21844
f81632121_506.returns.push(null);
// 21850
f81632121_506.returns.push(null);
// 21856
f81632121_506.returns.push(null);
// 21862
f81632121_506.returns.push(null);
// 21868
f81632121_506.returns.push(null);
// 21874
f81632121_506.returns.push(null);
// 21880
f81632121_506.returns.push(null);
// 21886
f81632121_506.returns.push(null);
// 21892
f81632121_506.returns.push(null);
// 21898
f81632121_506.returns.push(null);
// 21904
f81632121_506.returns.push(null);
// 21910
f81632121_506.returns.push(null);
// 21915
o24.relatedTarget = o28;
// 21916
o32 = {};
// 21917
o28.parentNode = o32;
// 21918
o28.nodeType = 1;
// 21921
f81632121_506.returns.push(null);
// 21923
o35 = {};
// 21924
o32.parentNode = o35;
// 21925
o32.nodeType = 1;
// 21926
o32.getAttribute = f81632121_506;
// undefined
o32 = null;
// 21928
f81632121_506.returns.push(null);
// 21930
o35.parentNode = o181;
// 21931
o35.nodeType = 1;
// 21932
o35.getAttribute = f81632121_506;
// undefined
o35 = null;
// 21934
f81632121_506.returns.push(null);
// 21937
o181.nodeType = 1;
// 21938
o181.getAttribute = f81632121_506;
// undefined
o181 = null;
// 21940
f81632121_506.returns.push(null);
// 21946
f81632121_506.returns.push(null);
// 21952
f81632121_506.returns.push(null);
// 21958
f81632121_506.returns.push(null);
// 21964
f81632121_506.returns.push(null);
// 21970
f81632121_506.returns.push(null);
// 21976
f81632121_506.returns.push(null);
// 21982
f81632121_506.returns.push(null);
// 21988
f81632121_506.returns.push(null);
// 21994
f81632121_506.returns.push(null);
// 22000
f81632121_506.returns.push(null);
// 22006
f81632121_506.returns.push(null);
// 22012
f81632121_506.returns.push(null);
// 22018
f81632121_506.returns.push(null);
// 22024
f81632121_506.returns.push(null);
// 22029
o24.cancelBubble = false;
// 22030
o24.returnValue = true;
// undefined
o24 = null;
// 22031
o24 = {};
// 22034
o24.cancelBubble = false;
// 22037
f81632121_467.returns.push(1374851250516);
// 22040
f81632121_1007.returns.push(undefined);
// 22042
o24.returnValue = true;
// 22045
o24.srcElement = o28;
// 22047
o24.target = o28;
// 22054
f81632121_506.returns.push(null);
// 22060
f81632121_506.returns.push(null);
// 22066
f81632121_506.returns.push(null);
// 22072
f81632121_506.returns.push(null);
// 22078
f81632121_506.returns.push(null);
// 22084
f81632121_506.returns.push(null);
// 22090
f81632121_506.returns.push(null);
// 22096
f81632121_506.returns.push(null);
// 22102
f81632121_506.returns.push(null);
// 22108
f81632121_506.returns.push(null);
// 22114
f81632121_506.returns.push(null);
// 22120
f81632121_506.returns.push(null);
// 22126
f81632121_506.returns.push(null);
// 22132
f81632121_506.returns.push(null);
// 22138
f81632121_506.returns.push(null);
// 22144
f81632121_506.returns.push(null);
// 22150
f81632121_506.returns.push(null);
// 22156
f81632121_506.returns.push(null);
// 22161
o24.relatedTarget = o33;
// undefined
o24 = null;
// 22164
o24 = {};
// 22168
f81632121_467.returns.push(1374851250528);
// 22169
o24.cancelBubble = false;
// 22170
o24.returnValue = true;
// 22173
o24.srcElement = o28;
// 22175
o24.target = o28;
// 22182
f81632121_506.returns.push(null);
// 22188
f81632121_506.returns.push(null);
// 22194
f81632121_506.returns.push(null);
// 22200
f81632121_506.returns.push(null);
// 22206
f81632121_506.returns.push(null);
// 22212
f81632121_506.returns.push(null);
// 22218
f81632121_506.returns.push(null);
// 22224
f81632121_506.returns.push(null);
// 22230
f81632121_506.returns.push(null);
// 22236
f81632121_506.returns.push(null);
// 22242
f81632121_506.returns.push(null);
// 22248
f81632121_506.returns.push(null);
// 22254
f81632121_506.returns.push(null);
// 22260
f81632121_506.returns.push(null);
// 22266
f81632121_506.returns.push(null);
// 22272
f81632121_506.returns.push(null);
// 22278
f81632121_506.returns.push(null);
// 22284
f81632121_506.returns.push(null);
// 22289
o24.JSBNG__screenX = 913;
// 22290
o24.JSBNG__screenY = 468;
// 22291
o24.altKey = false;
// 22292
o24.bubbles = true;
// 22293
o24.button = 0;
// 22294
o24.buttons = void 0;
// 22295
o24.cancelable = false;
// 22296
o24.clientX = 845;
// 22297
o24.clientY = 303;
// 22298
o24.ctrlKey = false;
// 22299
o24.currentTarget = o0;
// 22300
o24.defaultPrevented = false;
// 22301
o24.detail = 0;
// 22302
o24.eventPhase = 3;
// 22303
o24.isTrusted = void 0;
// 22304
o24.metaKey = false;
// 22305
o24.pageX = 845;
// 22306
o24.pageY = 303;
// 22307
o24.relatedTarget = null;
// 22308
o24.fromElement = null;
// 22311
o24.shiftKey = false;
// 22314
o24.timeStamp = 1374851250528;
// 22315
o24.type = "mousemove";
// 22316
o24.view = ow81632121;
// undefined
o24 = null;
// 22325
f81632121_1852.returns.push(undefined);
// 22328
f81632121_14.returns.push(undefined);
// 22329
f81632121_12.returns.push(97);
// 22332
o24 = {};
// 22336
f81632121_467.returns.push(1374851250539);
// 22337
o24.cancelBubble = false;
// 22338
o24.returnValue = true;
// 22341
o24.srcElement = o28;
// 22343
o24.target = o28;
// 22350
f81632121_506.returns.push(null);
// 22356
f81632121_506.returns.push(null);
// 22362
f81632121_506.returns.push(null);
// 22368
f81632121_506.returns.push(null);
// 22374
f81632121_506.returns.push(null);
// 22380
f81632121_506.returns.push(null);
// 22386
f81632121_506.returns.push(null);
// 22392
f81632121_506.returns.push(null);
// 22398
f81632121_506.returns.push(null);
// 22404
f81632121_506.returns.push(null);
// 22410
f81632121_506.returns.push(null);
// 22416
f81632121_506.returns.push(null);
// 22422
f81632121_506.returns.push(null);
// 22428
f81632121_506.returns.push(null);
// 22434
f81632121_506.returns.push(null);
// 22440
f81632121_506.returns.push(null);
// 22446
f81632121_506.returns.push(null);
// 22452
f81632121_506.returns.push(null);
// 22457
o24.JSBNG__screenX = 890;
// 22458
o24.JSBNG__screenY = 476;
// 22459
o24.altKey = false;
// 22460
o24.bubbles = true;
// 22461
o24.button = 0;
// 22462
o24.buttons = void 0;
// 22463
o24.cancelable = false;
// 22464
o24.clientX = 822;
// 22465
o24.clientY = 311;
// 22466
o24.ctrlKey = false;
// 22467
o24.currentTarget = o0;
// 22468
o24.defaultPrevented = false;
// 22469
o24.detail = 0;
// 22470
o24.eventPhase = 3;
// 22471
o24.isTrusted = void 0;
// 22472
o24.metaKey = false;
// 22473
o24.pageX = 822;
// 22474
o24.pageY = 311;
// 22475
o24.relatedTarget = null;
// 22476
o24.fromElement = null;
// 22479
o24.shiftKey = false;
// 22482
o24.timeStamp = 1374851250539;
// 22483
o24.type = "mousemove";
// 22484
o24.view = ow81632121;
// undefined
o24 = null;
// 22493
f81632121_1852.returns.push(undefined);
// 22496
f81632121_14.returns.push(undefined);
// 22497
f81632121_12.returns.push(98);
// 22500
o24 = {};
// 22504
f81632121_467.returns.push(1374851250545);
// 22505
o24.cancelBubble = false;
// 22506
o24.returnValue = true;
// 22509
o24.srcElement = o28;
// 22511
o24.target = o28;
// 22518
f81632121_506.returns.push(null);
// 22524
f81632121_506.returns.push(null);
// 22530
f81632121_506.returns.push(null);
// 22536
f81632121_506.returns.push(null);
// 22542
f81632121_506.returns.push(null);
// 22548
f81632121_506.returns.push(null);
// 22554
f81632121_506.returns.push(null);
// 22560
f81632121_506.returns.push(null);
// 22566
f81632121_506.returns.push(null);
// 22572
f81632121_506.returns.push(null);
// 22578
f81632121_506.returns.push(null);
// 22584
f81632121_506.returns.push(null);
// 22590
f81632121_506.returns.push(null);
// 22596
f81632121_506.returns.push(null);
// 22602
f81632121_506.returns.push(null);
// 22608
f81632121_506.returns.push(null);
// 22614
f81632121_506.returns.push(null);
// 22620
f81632121_506.returns.push(null);
// 22625
o24.JSBNG__screenX = 884;
// 22626
o24.JSBNG__screenY = 479;
// 22627
o24.altKey = false;
// 22628
o24.bubbles = true;
// 22629
o24.button = 0;
// 22630
o24.buttons = void 0;
// 22631
o24.cancelable = false;
// 22632
o24.clientX = 816;
// 22633
o24.clientY = 314;
// 22634
o24.ctrlKey = false;
// 22635
o24.currentTarget = o0;
// 22636
o24.defaultPrevented = false;
// 22637
o24.detail = 0;
// 22638
o24.eventPhase = 3;
// 22639
o24.isTrusted = void 0;
// 22640
o24.metaKey = false;
// 22641
o24.pageX = 816;
// 22642
o24.pageY = 314;
// 22643
o24.relatedTarget = null;
// 22644
o24.fromElement = null;
// 22647
o24.shiftKey = false;
// 22650
o24.timeStamp = 1374851250545;
// 22651
o24.type = "mousemove";
// 22652
o24.view = ow81632121;
// undefined
o24 = null;
// 22661
f81632121_1852.returns.push(undefined);
// 22664
f81632121_14.returns.push(undefined);
// 22665
f81632121_12.returns.push(99);
// 22668
o24 = {};
// 22671
o24.srcElement = o28;
// 22673
o24.target = o28;
// 22680
f81632121_506.returns.push(null);
// 22686
f81632121_506.returns.push(null);
// 22692
f81632121_506.returns.push(null);
// 22698
f81632121_506.returns.push(null);
// 22704
f81632121_506.returns.push(null);
// 22710
f81632121_506.returns.push(null);
// 22716
f81632121_506.returns.push(null);
// 22722
f81632121_506.returns.push(null);
// 22728
f81632121_506.returns.push(null);
// 22734
f81632121_506.returns.push(null);
// 22740
f81632121_506.returns.push(null);
// 22746
f81632121_506.returns.push(null);
// 22752
f81632121_506.returns.push(null);
// 22758
f81632121_506.returns.push(null);
// 22764
f81632121_506.returns.push(null);
// 22770
f81632121_506.returns.push(null);
// 22776
f81632121_506.returns.push(null);
// 22782
f81632121_506.returns.push(null);
// 22787
o32 = {};
// 22788
o24.relatedTarget = o32;
// 22789
o35 = {};
// 22790
o32.parentNode = o35;
// 22791
o32.nodeType = 1;
// 22792
o32.getAttribute = f81632121_506;
// 22794
f81632121_506.returns.push(null);
// 22796
o36 = {};
// 22797
o35.parentNode = o36;
// 22798
o35.nodeType = 1;
// 22799
o35.getAttribute = f81632121_506;
// undefined
o35 = null;
// 22801
f81632121_506.returns.push(null);
// 22803
o35 = {};
// 22804
o36.parentNode = o35;
// 22805
o36.nodeType = 1;
// 22806
o36.getAttribute = f81632121_506;
// undefined
o36 = null;
// 22808
f81632121_506.returns.push(null);
// 22810
o36 = {};
// 22811
o35.parentNode = o36;
// 22812
o35.nodeType = 1;
// 22813
o35.getAttribute = f81632121_506;
// undefined
o35 = null;
// 22815
f81632121_506.returns.push(null);
// 22817
o36.parentNode = o28;
// 22818
o36.nodeType = 1;
// 22819
o36.getAttribute = f81632121_506;
// undefined
o36 = null;
// 22821
f81632121_506.returns.push(null);
// 22827
f81632121_506.returns.push(null);
// 22833
f81632121_506.returns.push(null);
// 22839
f81632121_506.returns.push(null);
// 22845
f81632121_506.returns.push(null);
// 22851
f81632121_506.returns.push(null);
// 22857
f81632121_506.returns.push(null);
// 22863
f81632121_506.returns.push(null);
// 22869
f81632121_506.returns.push(null);
// 22875
f81632121_506.returns.push(null);
// 22881
f81632121_506.returns.push(null);
// 22887
f81632121_506.returns.push(null);
// 22893
f81632121_506.returns.push(null);
// 22899
f81632121_506.returns.push(null);
// 22905
f81632121_506.returns.push(null);
// 22911
f81632121_506.returns.push(null);
// 22917
f81632121_506.returns.push(null);
// 22923
f81632121_506.returns.push(null);
// 22929
f81632121_506.returns.push(null);
// 22934
o24.cancelBubble = false;
// 22935
o24.returnValue = true;
// undefined
o24 = null;
// 22936
o24 = {};
// 22939
o24.cancelBubble = false;
// 22942
f81632121_467.returns.push(1374851250574);
// 22945
f81632121_1007.returns.push(undefined);
// 22947
o24.returnValue = true;
// 22950
o24.srcElement = o32;
// 22952
o24.target = o32;
// 22959
f81632121_506.returns.push(null);
// 22965
f81632121_506.returns.push(null);
// 22971
f81632121_506.returns.push(null);
// 22977
f81632121_506.returns.push(null);
// 22983
f81632121_506.returns.push(null);
// 22989
f81632121_506.returns.push(null);
// 22995
f81632121_506.returns.push(null);
// 23001
f81632121_506.returns.push(null);
// 23007
f81632121_506.returns.push(null);
// 23013
f81632121_506.returns.push(null);
// 23019
f81632121_506.returns.push(null);
// 23025
f81632121_506.returns.push(null);
// 23031
f81632121_506.returns.push(null);
// 23037
f81632121_506.returns.push(null);
// 23043
f81632121_506.returns.push(null);
// 23049
f81632121_506.returns.push(null);
// 23055
f81632121_506.returns.push(null);
// 23061
f81632121_506.returns.push(null);
// 23067
f81632121_506.returns.push(null);
// 23073
f81632121_506.returns.push(null);
// 23079
f81632121_506.returns.push(null);
// 23085
f81632121_506.returns.push(null);
// 23091
f81632121_506.returns.push(null);
// 23096
o24.relatedTarget = o28;
// undefined
o24 = null;
// undefined
o28 = null;
// 23099
o24 = {};
// 23103
f81632121_467.returns.push(1374851250582);
// 23108
f81632121_467.returns.push(1374851250583);
// 23112
f81632121_467.returns.push(1374851250583);
// 23114
o24.cancelBubble = false;
// 23115
o24.returnValue = true;
// 23118
o24.srcElement = o32;
// 23120
o24.target = o32;
// 23127
f81632121_506.returns.push(null);
// 23133
f81632121_506.returns.push(null);
// 23139
f81632121_506.returns.push(null);
// 23145
f81632121_506.returns.push(null);
// 23151
f81632121_506.returns.push(null);
// 23157
f81632121_506.returns.push(null);
// 23163
f81632121_506.returns.push(null);
// 23169
f81632121_506.returns.push(null);
// 23175
f81632121_506.returns.push(null);
// 23181
f81632121_506.returns.push(null);
// 23187
f81632121_506.returns.push(null);
// 23193
f81632121_506.returns.push(null);
// 23199
f81632121_506.returns.push(null);
// 23205
f81632121_506.returns.push(null);
// 23211
f81632121_506.returns.push(null);
// 23217
f81632121_506.returns.push(null);
// 23223
f81632121_506.returns.push(null);
// 23229
f81632121_506.returns.push(null);
// 23235
f81632121_506.returns.push(null);
// 23241
f81632121_506.returns.push(null);
// 23247
f81632121_506.returns.push(null);
// 23253
f81632121_506.returns.push(null);
// 23259
f81632121_506.returns.push(null);
// 23264
o24.JSBNG__screenX = 873;
// 23265
o24.JSBNG__screenY = 486;
// 23266
o24.altKey = false;
// 23267
o24.bubbles = true;
// 23268
o24.button = 0;
// 23269
o24.buttons = void 0;
// 23270
o24.cancelable = false;
// 23271
o24.clientX = 805;
// 23272
o24.clientY = 321;
// 23273
o24.ctrlKey = false;
// 23274
o24.currentTarget = o0;
// 23275
o24.defaultPrevented = false;
// 23276
o24.detail = 0;
// 23277
o24.eventPhase = 3;
// 23278
o24.isTrusted = void 0;
// 23279
o24.metaKey = false;
// 23280
o24.pageX = 805;
// 23281
o24.pageY = 321;
// 23282
o24.relatedTarget = null;
// 23283
o24.fromElement = null;
// 23286
o24.shiftKey = false;
// 23289
o24.timeStamp = 1374851250582;
// 23290
o24.type = "mousemove";
// 23291
o24.view = ow81632121;
// undefined
o24 = null;
// 23300
f81632121_1852.returns.push(undefined);
// 23303
f81632121_14.returns.push(undefined);
// 23304
f81632121_12.returns.push(100);
// 23307
o24 = {};
// 23311
f81632121_467.returns.push(1374851250598);
// 23312
o24.cancelBubble = false;
// 23313
o24.returnValue = true;
// 23316
o24.srcElement = o32;
// 23318
o24.target = o32;
// 23325
f81632121_506.returns.push(null);
// 23331
f81632121_506.returns.push(null);
// 23337
f81632121_506.returns.push(null);
// 23343
f81632121_506.returns.push(null);
// 23349
f81632121_506.returns.push(null);
// 23355
f81632121_506.returns.push(null);
// 23361
f81632121_506.returns.push(null);
// 23367
f81632121_506.returns.push(null);
// 23373
f81632121_506.returns.push(null);
// 23379
f81632121_506.returns.push(null);
// 23385
f81632121_506.returns.push(null);
// 23391
f81632121_506.returns.push(null);
// 23397
f81632121_506.returns.push(null);
// 23403
f81632121_506.returns.push(null);
// 23409
f81632121_506.returns.push(null);
// 23415
f81632121_506.returns.push(null);
// 23421
f81632121_506.returns.push(null);
// 23427
f81632121_506.returns.push(null);
// 23433
f81632121_506.returns.push(null);
// 23439
f81632121_506.returns.push(null);
// 23445
f81632121_506.returns.push(null);
// 23451
f81632121_506.returns.push(null);
// 23457
f81632121_506.returns.push(null);
// 23462
o24.JSBNG__screenX = 854;
// 23463
o24.JSBNG__screenY = 505;
// 23464
o24.altKey = false;
// 23465
o24.bubbles = true;
// 23466
o24.button = 0;
// 23467
o24.buttons = void 0;
// 23468
o24.cancelable = false;
// 23469
o24.clientX = 786;
// 23470
o24.clientY = 340;
// 23471
o24.ctrlKey = false;
// 23472
o24.currentTarget = o0;
// 23473
o24.defaultPrevented = false;
// 23474
o24.detail = 0;
// 23475
o24.eventPhase = 3;
// 23476
o24.isTrusted = void 0;
// 23477
o24.metaKey = false;
// 23478
o24.pageX = 786;
// 23479
o24.pageY = 340;
// 23480
o24.relatedTarget = null;
// 23481
o24.fromElement = null;
// 23484
o24.shiftKey = false;
// 23487
o24.timeStamp = 1374851250598;
// 23488
o24.type = "mousemove";
// 23489
o24.view = ow81632121;
// undefined
o24 = null;
// 23498
f81632121_1852.returns.push(undefined);
// 23501
f81632121_14.returns.push(undefined);
// 23502
f81632121_12.returns.push(101);
// 23505
o24 = {};
// 23508
o24.srcElement = o32;
// 23510
o24.target = o32;
// 23517
f81632121_506.returns.push(null);
// 23523
f81632121_506.returns.push(null);
// 23529
f81632121_506.returns.push(null);
// 23535
f81632121_506.returns.push(null);
// 23541
f81632121_506.returns.push(null);
// 23547
f81632121_506.returns.push(null);
// 23553
f81632121_506.returns.push(null);
// 23559
f81632121_506.returns.push(null);
// 23565
f81632121_506.returns.push(null);
// 23571
f81632121_506.returns.push(null);
// 23577
f81632121_506.returns.push(null);
// 23583
f81632121_506.returns.push(null);
// 23589
f81632121_506.returns.push(null);
// 23595
f81632121_506.returns.push(null);
// 23601
f81632121_506.returns.push(null);
// 23607
f81632121_506.returns.push(null);
// 23613
f81632121_506.returns.push(null);
// 23619
f81632121_506.returns.push(null);
// 23625
f81632121_506.returns.push(null);
// 23631
f81632121_506.returns.push(null);
// 23637
f81632121_506.returns.push(null);
// 23643
f81632121_506.returns.push(null);
// 23649
f81632121_506.returns.push(null);
// 23654
o24.relatedTarget = o33;
// 23659
f81632121_506.returns.push(null);
// 23665
f81632121_506.returns.push(null);
// 23671
f81632121_506.returns.push(null);
// 23677
f81632121_506.returns.push(null);
// 23683
f81632121_506.returns.push(null);
// 23689
f81632121_506.returns.push(null);
// 23695
f81632121_506.returns.push(null);
// 23701
f81632121_506.returns.push(null);
// 23707
f81632121_506.returns.push(null);
// 23713
f81632121_506.returns.push(null);
// 23719
f81632121_506.returns.push(null);
// 23725
f81632121_506.returns.push(null);
// 23731
f81632121_506.returns.push(null);
// 23737
f81632121_506.returns.push(null);
// 23743
f81632121_506.returns.push(null);
// 23749
f81632121_506.returns.push(null);
// 23755
f81632121_506.returns.push(null);
// 23760
o24.cancelBubble = false;
// 23761
o24.returnValue = true;
// undefined
o24 = null;
// 23762
o24 = {};
// 23765
o24.cancelBubble = false;
// 23768
f81632121_467.returns.push(1374851250628);
// 23771
f81632121_1007.returns.push(undefined);
// 23773
o24.returnValue = true;
// 23776
o24.srcElement = o33;
// 23778
o24.target = o33;
// 23785
f81632121_506.returns.push(null);
// 23791
f81632121_506.returns.push(null);
// 23797
f81632121_506.returns.push(null);
// 23803
f81632121_506.returns.push(null);
// 23809
f81632121_506.returns.push(null);
// 23815
f81632121_506.returns.push(null);
// 23821
f81632121_506.returns.push(null);
// 23827
f81632121_506.returns.push(null);
// 23833
f81632121_506.returns.push(null);
// 23839
f81632121_506.returns.push(null);
// 23845
f81632121_506.returns.push(null);
// 23851
f81632121_506.returns.push(null);
// 23857
f81632121_506.returns.push(null);
// 23863
f81632121_506.returns.push(null);
// 23869
f81632121_506.returns.push(null);
// 23875
f81632121_506.returns.push(null);
// 23881
f81632121_506.returns.push(null);
// 23886
o24.relatedTarget = o32;
// undefined
o24 = null;
// undefined
o32 = null;
// 23889
o24 = {};
// 23893
f81632121_467.returns.push(1374851250634);
// 23894
o24.cancelBubble = false;
// 23895
o24.returnValue = true;
// 23898
o24.srcElement = o33;
// 23900
o24.target = o33;
// 23907
f81632121_506.returns.push(null);
// 23913
f81632121_506.returns.push(null);
// 23919
f81632121_506.returns.push(null);
// 23925
f81632121_506.returns.push(null);
// 23931
f81632121_506.returns.push(null);
// 23937
f81632121_506.returns.push(null);
// 23943
f81632121_506.returns.push(null);
// 23949
f81632121_506.returns.push(null);
// 23955
f81632121_506.returns.push(null);
// 23961
f81632121_506.returns.push(null);
// 23967
f81632121_506.returns.push(null);
// 23973
f81632121_506.returns.push(null);
// 23979
f81632121_506.returns.push(null);
// 23985
f81632121_506.returns.push(null);
// 23991
f81632121_506.returns.push(null);
// 23997
f81632121_506.returns.push(null);
// 24003
f81632121_506.returns.push(null);
// 24008
o24.JSBNG__screenX = 849;
// 24009
o24.JSBNG__screenY = 512;
// 24010
o24.altKey = false;
// 24011
o24.bubbles = true;
// 24012
o24.button = 0;
// 24013
o24.buttons = void 0;
// 24014
o24.cancelable = false;
// 24015
o24.clientX = 781;
// 24016
o24.clientY = 347;
// 24017
o24.ctrlKey = false;
// 24018
o24.currentTarget = o0;
// 24019
o24.defaultPrevented = false;
// 24020
o24.detail = 0;
// 24021
o24.eventPhase = 3;
// 24022
o24.isTrusted = void 0;
// 24023
o24.metaKey = false;
// 24024
o24.pageX = 781;
// 24025
o24.pageY = 347;
// 24026
o24.relatedTarget = null;
// 24027
o24.fromElement = null;
// 24030
o24.shiftKey = false;
// 24033
o24.timeStamp = 1374851250634;
// 24034
o24.type = "mousemove";
// 24035
o24.view = ow81632121;
// undefined
o24 = null;
// 24044
f81632121_1852.returns.push(undefined);
// 24047
f81632121_14.returns.push(undefined);
// 24048
f81632121_12.returns.push(102);
// undefined
fo81632121_1_cookie.returns.push("c_user=100006118350059; csm=2; sub=4096; wd=1034x727");
// 24052
o24 = {};
// 24055
o24.srcElement = o33;
// 24057
o24.target = o33;
// 24064
f81632121_506.returns.push(null);
// 24070
f81632121_506.returns.push(null);
// 24076
f81632121_506.returns.push(null);
// 24082
f81632121_506.returns.push(null);
// 24088
f81632121_506.returns.push(null);
// 24094
f81632121_506.returns.push(null);
// 24100
f81632121_506.returns.push(null);
// 24106
f81632121_506.returns.push(null);
// 24112
f81632121_506.returns.push(null);
// 24118
f81632121_506.returns.push(null);
// 24124
f81632121_506.returns.push(null);
// 24130
f81632121_506.returns.push(null);
// 24136
f81632121_506.returns.push(null);
// 24142
f81632121_506.returns.push(null);
// 24148
f81632121_506.returns.push(null);
// 24154
f81632121_506.returns.push(null);
// 24160
f81632121_506.returns.push(null);
// 24165
o24.relatedTarget = o182;
// 24167
o182.nodeType = 1;
// 24168
o182.getAttribute = f81632121_506;
// 24170
f81632121_506.returns.push(null);
// 24173
o184.nodeType = 1;
// 24174
o184.getAttribute = f81632121_506;
// undefined
o184 = null;
// 24176
f81632121_506.returns.push(null);
// 24182
f81632121_506.returns.push(null);
// 24188
f81632121_506.returns.push(null);
// 24194
f81632121_506.returns.push(null);
// 24200
f81632121_506.returns.push(null);
// 24206
f81632121_506.returns.push(null);
// 24212
f81632121_506.returns.push(null);
// 24218
f81632121_506.returns.push(null);
// 24224
f81632121_506.returns.push(null);
// 24230
f81632121_506.returns.push(null);
// 24236
f81632121_506.returns.push(null);
// 24242
f81632121_506.returns.push(null);
// 24248
f81632121_506.returns.push(null);
// 24254
f81632121_506.returns.push(null);
// 24260
f81632121_506.returns.push(null);
// 24266
f81632121_506.returns.push(null);
// 24271
o24.cancelBubble = false;
// 24272
o24.returnValue = true;
// undefined
o24 = null;
// 24273
o24 = {};
// 24276
o24.cancelBubble = false;
// 24279
f81632121_467.returns.push(1374851250660);
// 24282
f81632121_1007.returns.push(undefined);
// 24284
o24.returnValue = true;
// 24287
o24.srcElement = o182;
// 24289
o24.target = o182;
// 24296
f81632121_506.returns.push(null);
// 24302
f81632121_506.returns.push(null);
// 24308
f81632121_506.returns.push(null);
// 24314
f81632121_506.returns.push(null);
// 24320
f81632121_506.returns.push(null);
// 24326
f81632121_506.returns.push(null);
// 24332
f81632121_506.returns.push(null);
// 24338
f81632121_506.returns.push(null);
// 24344
f81632121_506.returns.push(null);
// 24350
f81632121_506.returns.push(null);
// 24356
f81632121_506.returns.push(null);
// 24362
f81632121_506.returns.push(null);
// 24368
f81632121_506.returns.push(null);
// 24374
f81632121_506.returns.push(null);
// 24380
f81632121_506.returns.push(null);
// 24386
f81632121_506.returns.push(null);
// 24392
f81632121_506.returns.push(null);
// 24397
o24.relatedTarget = o33;
// undefined
o24 = null;
// undefined
o33 = null;
// 24400
o24 = {};
// 24404
f81632121_467.returns.push(1374851250670);
// 24405
o24.cancelBubble = false;
// 24406
o24.returnValue = true;
// 24409
o24.srcElement = o182;
// 24411
o24.target = o182;
// 24418
f81632121_506.returns.push(null);
// 24424
f81632121_506.returns.push(null);
// 24430
f81632121_506.returns.push(null);
// 24436
f81632121_506.returns.push(null);
// 24442
f81632121_506.returns.push(null);
// 24448
f81632121_506.returns.push(null);
// 24454
f81632121_506.returns.push(null);
// 24460
f81632121_506.returns.push(null);
// 24466
f81632121_506.returns.push(null);
// 24472
f81632121_506.returns.push(null);
// 24478
f81632121_506.returns.push(null);
// 24484
f81632121_506.returns.push(null);
// 24490
f81632121_506.returns.push(null);
// 24496
f81632121_506.returns.push(null);
// 24502
f81632121_506.returns.push(null);
// 24508
f81632121_506.returns.push(null);
// 24514
f81632121_506.returns.push(null);
// 24519
o24.JSBNG__screenX = 838;
// 24520
o24.JSBNG__screenY = 524;
// 24521
o24.altKey = false;
// 24522
o24.bubbles = true;
// 24523
o24.button = 0;
// 24524
o24.buttons = void 0;
// 24525
o24.cancelable = false;
// 24526
o24.clientX = 770;
// 24527
o24.clientY = 359;
// 24528
o24.ctrlKey = false;
// 24529
o24.currentTarget = o0;
// 24530
o24.defaultPrevented = false;
// 24531
o24.detail = 0;
// 24532
o24.eventPhase = 3;
// 24533
o24.isTrusted = void 0;
// 24534
o24.metaKey = false;
// 24535
o24.pageX = 770;
// 24536
o24.pageY = 359;
// 24537
o24.relatedTarget = null;
// 24538
o24.fromElement = null;
// 24541
o24.shiftKey = false;
// 24544
o24.timeStamp = 1374851250669;
// 24545
o24.type = "mousemove";
// 24546
o24.view = ow81632121;
// undefined
o24 = null;
// 24555
f81632121_1852.returns.push(undefined);
// 24558
f81632121_14.returns.push(undefined);
// 24559
f81632121_12.returns.push(103);
// 24562
o24 = {};
// 24566
f81632121_467.returns.push(1374851250682);
// 24567
o24.cancelBubble = false;
// 24568
o24.returnValue = true;
// 24571
o24.srcElement = o182;
// 24573
o24.target = o182;
// 24580
f81632121_506.returns.push(null);
// 24586
f81632121_506.returns.push(null);
// 24592
f81632121_506.returns.push(null);
// 24598
f81632121_506.returns.push(null);
// 24604
f81632121_506.returns.push(null);
// 24610
f81632121_506.returns.push(null);
// 24616
f81632121_506.returns.push(null);
// 24622
f81632121_506.returns.push(null);
// 24628
f81632121_506.returns.push(null);
// 24634
f81632121_506.returns.push(null);
// 24640
f81632121_506.returns.push(null);
// 24646
f81632121_506.returns.push(null);
// 24652
f81632121_506.returns.push(null);
// 24658
f81632121_506.returns.push(null);
// 24664
f81632121_506.returns.push(null);
// 24670
f81632121_506.returns.push(null);
// 24676
f81632121_506.returns.push(null);
// 24681
o24.JSBNG__screenX = 833;
// 24682
o24.JSBNG__screenY = 532;
// 24683
o24.altKey = false;
// 24684
o24.bubbles = true;
// 24685
o24.button = 0;
// 24686
o24.buttons = void 0;
// 24687
o24.cancelable = false;
// 24688
o24.clientX = 765;
// 24689
o24.clientY = 367;
// 24690
o24.ctrlKey = false;
// 24691
o24.currentTarget = o0;
// 24692
o24.defaultPrevented = false;
// 24693
o24.detail = 0;
// 24694
o24.eventPhase = 3;
// 24695
o24.isTrusted = void 0;
// 24696
o24.metaKey = false;
// 24697
o24.pageX = 765;
// 24698
o24.pageY = 367;
// 24699
o24.relatedTarget = null;
// 24700
o24.fromElement = null;
// 24703
o24.shiftKey = false;
// 24706
o24.timeStamp = 1374851250682;
// 24707
o24.type = "mousemove";
// 24708
o24.view = ow81632121;
// undefined
o24 = null;
// 24717
f81632121_1852.returns.push(undefined);
// 24720
f81632121_14.returns.push(undefined);
// 24721
f81632121_12.returns.push(104);
// 24724
o24 = {};
// 24728
f81632121_467.returns.push(1374851250694);
// 24729
o24.cancelBubble = false;
// 24730
o24.returnValue = true;
// 24733
o24.srcElement = o182;
// 24735
o24.target = o182;
// 24742
f81632121_506.returns.push(null);
// 24748
f81632121_506.returns.push(null);
// 24754
f81632121_506.returns.push(null);
// 24760
f81632121_506.returns.push(null);
// 24766
f81632121_506.returns.push(null);
// 24772
f81632121_506.returns.push(null);
// 24778
f81632121_506.returns.push(null);
// 24784
f81632121_506.returns.push(null);
// 24790
f81632121_506.returns.push(null);
// 24796
f81632121_506.returns.push(null);
// 24802
f81632121_506.returns.push(null);
// 24808
f81632121_506.returns.push(null);
// 24814
f81632121_506.returns.push(null);
// 24820
f81632121_506.returns.push(null);
// 24826
f81632121_506.returns.push(null);
// 24832
f81632121_506.returns.push(null);
// 24838
f81632121_506.returns.push(null);
// 24843
o24.JSBNG__screenX = 832;
// 24844
o24.JSBNG__screenY = 533;
// 24845
o24.altKey = false;
// 24846
o24.bubbles = true;
// 24847
o24.button = 0;
// 24848
o24.buttons = void 0;
// 24849
o24.cancelable = false;
// 24850
o24.clientX = 764;
// 24851
o24.clientY = 368;
// 24852
o24.ctrlKey = false;
// 24853
o24.currentTarget = o0;
// 24854
o24.defaultPrevented = false;
// 24855
o24.detail = 0;
// 24856
o24.eventPhase = 3;
// 24857
o24.isTrusted = void 0;
// 24858
o24.metaKey = false;
// 24859
o24.pageX = 764;
// 24860
o24.pageY = 368;
// 24861
o24.relatedTarget = null;
// 24862
o24.fromElement = null;
// 24865
o24.shiftKey = false;
// 24868
o24.timeStamp = 1374851250694;
// 24869
o24.type = "mousemove";
// 24870
o24.view = ow81632121;
// undefined
o24 = null;
// 24879
f81632121_1852.returns.push(undefined);
// 24882
f81632121_14.returns.push(undefined);
// 24883
f81632121_12.returns.push(105);
// 24886
o24 = {};
// 24890
f81632121_467.returns.push(1374851250700);
// 24891
o24.cancelBubble = false;
// 24892
o24.returnValue = true;
// 24895
o24.srcElement = o182;
// 24897
o24.target = o182;
// 24904
f81632121_506.returns.push(null);
// 24910
f81632121_506.returns.push(null);
// 24916
f81632121_506.returns.push(null);
// 24922
f81632121_506.returns.push(null);
// 24928
f81632121_506.returns.push(null);
// 24934
f81632121_506.returns.push(null);
// 24940
f81632121_506.returns.push(null);
// 24946
f81632121_506.returns.push(null);
// 24952
f81632121_506.returns.push(null);
// 24958
f81632121_506.returns.push(null);
// 24964
f81632121_506.returns.push(null);
// 24970
f81632121_506.returns.push(null);
// 24976
f81632121_506.returns.push(null);
// 24982
f81632121_506.returns.push(null);
// 24988
f81632121_506.returns.push(null);
// 24994
f81632121_506.returns.push(null);
// 25000
f81632121_506.returns.push(null);
// 25005
o24.JSBNG__screenX = 832;
// 25006
o24.JSBNG__screenY = 534;
// 25007
o24.altKey = false;
// 25008
o24.bubbles = true;
// 25009
o24.button = 0;
// 25010
o24.buttons = void 0;
// 25011
o24.cancelable = false;
// 25012
o24.clientX = 764;
// 25013
o24.clientY = 369;
// 25014
o24.ctrlKey = false;
// 25015
o24.currentTarget = o0;
// 25016
o24.defaultPrevented = false;
// 25017
o24.detail = 0;
// 25018
o24.eventPhase = 3;
// 25019
o24.isTrusted = void 0;
// 25020
o24.metaKey = false;
// 25021
o24.pageX = 764;
// 25022
o24.pageY = 369;
// 25023
o24.relatedTarget = null;
// 25024
o24.fromElement = null;
// 25027
o24.shiftKey = false;
// 25030
o24.timeStamp = 1374851250700;
// 25031
o24.type = "mousemove";
// 25032
o24.view = ow81632121;
// undefined
o24 = null;
// 25041
f81632121_1852.returns.push(undefined);
// 25044
f81632121_14.returns.push(undefined);
// 25045
f81632121_12.returns.push(106);
// 25048
o24 = {};
// 25052
f81632121_467.returns.push(1374851250714);
// 25053
o24.cancelBubble = false;
// 25054
o24.returnValue = true;
// 25057
o24.srcElement = o182;
// 25059
o24.target = o182;
// 25066
f81632121_506.returns.push(null);
// 25072
f81632121_506.returns.push(null);
// 25078
f81632121_506.returns.push(null);
// 25084
f81632121_506.returns.push(null);
// 25090
f81632121_506.returns.push(null);
// 25096
f81632121_506.returns.push(null);
// 25102
f81632121_506.returns.push(null);
// 25108
f81632121_506.returns.push(null);
// 25114
f81632121_506.returns.push(null);
// 25120
f81632121_506.returns.push(null);
// 25126
f81632121_506.returns.push(null);
// 25132
f81632121_506.returns.push(null);
// 25138
f81632121_506.returns.push(null);
// 25144
f81632121_506.returns.push(null);
// 25150
f81632121_506.returns.push(null);
// 25156
f81632121_506.returns.push(null);
// 25162
f81632121_506.returns.push(null);
// 25167
o24.JSBNG__screenX = 830;
// 25168
o24.JSBNG__screenY = 538;
// 25169
o24.altKey = false;
// 25170
o24.bubbles = true;
// 25171
o24.button = 0;
// 25172
o24.buttons = void 0;
// 25173
o24.cancelable = false;
// 25174
o24.clientX = 762;
// 25175
o24.clientY = 373;
// 25176
o24.ctrlKey = false;
// 25177
o24.currentTarget = o0;
// 25178
o24.defaultPrevented = false;
// 25179
o24.detail = 0;
// 25180
o24.eventPhase = 3;
// 25181
o24.isTrusted = void 0;
// 25182
o24.metaKey = false;
// 25183
o24.pageX = 762;
// 25184
o24.pageY = 373;
// 25185
o24.relatedTarget = null;
// 25186
o24.fromElement = null;
// 25189
o24.shiftKey = false;
// 25192
o24.timeStamp = 1374851250714;
// 25193
o24.type = "mousemove";
// 25194
o24.view = ow81632121;
// undefined
o24 = null;
// 25203
f81632121_1852.returns.push(undefined);
// 25206
f81632121_14.returns.push(undefined);
// 25207
f81632121_12.returns.push(107);
// 25210
o24 = {};
// 25214
f81632121_467.returns.push(1374851250720);
// 25215
o24.cancelBubble = false;
// 25216
o24.returnValue = true;
// 25219
o24.srcElement = o182;
// 25221
o24.target = o182;
// 25228
f81632121_506.returns.push(null);
// 25234
f81632121_506.returns.push(null);
// 25240
f81632121_506.returns.push(null);
// 25246
f81632121_506.returns.push(null);
// 25252
f81632121_506.returns.push(null);
// 25258
f81632121_506.returns.push(null);
// 25264
f81632121_506.returns.push(null);
// 25270
f81632121_506.returns.push(null);
// 25276
f81632121_506.returns.push(null);
// 25282
f81632121_506.returns.push(null);
// 25288
f81632121_506.returns.push(null);
// 25294
f81632121_506.returns.push(null);
// 25300
f81632121_506.returns.push(null);
// 25306
f81632121_506.returns.push(null);
// 25312
f81632121_506.returns.push(null);
// 25318
f81632121_506.returns.push(null);
// 25324
f81632121_506.returns.push(null);
// 25329
o24.JSBNG__screenX = 830;
// 25330
o24.JSBNG__screenY = 539;
// 25331
o24.altKey = false;
// 25332
o24.bubbles = true;
// 25333
o24.button = 0;
// 25334
o24.buttons = void 0;
// 25335
o24.cancelable = false;
// 25336
o24.clientX = 762;
// 25337
o24.clientY = 374;
// 25338
o24.ctrlKey = false;
// 25339
o24.currentTarget = o0;
// 25340
o24.defaultPrevented = false;
// 25341
o24.detail = 0;
// 25342
o24.eventPhase = 3;
// 25343
o24.isTrusted = void 0;
// 25344
o24.metaKey = false;
// 25345
o24.pageX = 762;
// 25346
o24.pageY = 374;
// 25347
o24.relatedTarget = null;
// 25348
o24.fromElement = null;
// 25351
o24.shiftKey = false;
// 25354
o24.timeStamp = 1374851250720;
// 25355
o24.type = "mousemove";
// 25356
o24.view = ow81632121;
// undefined
o24 = null;
// 25365
f81632121_1852.returns.push(undefined);
// 25368
f81632121_14.returns.push(undefined);
// 25369
f81632121_12.returns.push(108);
// 25372
o24 = {};
// 25376
f81632121_467.returns.push(1374851250731);
// 25377
o24.cancelBubble = false;
// 25378
o24.returnValue = true;
// 25381
o24.srcElement = o182;
// 25383
o24.target = o182;
// 25390
f81632121_506.returns.push(null);
// 25396
f81632121_506.returns.push(null);
// 25402
f81632121_506.returns.push(null);
// 25408
f81632121_506.returns.push(null);
// 25414
f81632121_506.returns.push(null);
// 25420
f81632121_506.returns.push(null);
// 25426
f81632121_506.returns.push(null);
// 25432
f81632121_506.returns.push(null);
// 25438
f81632121_506.returns.push(null);
// 25444
f81632121_506.returns.push(null);
// 25450
f81632121_506.returns.push(null);
// 25456
f81632121_506.returns.push(null);
// 25462
f81632121_506.returns.push(null);
// 25468
f81632121_506.returns.push(null);
// 25474
f81632121_506.returns.push(null);
// 25480
f81632121_506.returns.push(null);
// 25486
f81632121_506.returns.push(null);
// 25491
o24.JSBNG__screenX = 829;
// 25492
o24.JSBNG__screenY = 540;
// 25493
o24.altKey = false;
// 25494
o24.bubbles = true;
// 25495
o24.button = 0;
// 25496
o24.buttons = void 0;
// 25497
o24.cancelable = false;
// 25498
o24.clientX = 761;
// 25499
o24.clientY = 375;
// 25500
o24.ctrlKey = false;
// 25501
o24.currentTarget = o0;
// 25502
o24.defaultPrevented = false;
// 25503
o24.detail = 0;
// 25504
o24.eventPhase = 3;
// 25505
o24.isTrusted = void 0;
// 25506
o24.metaKey = false;
// 25507
o24.pageX = 761;
// 25508
o24.pageY = 375;
// 25509
o24.relatedTarget = null;
// 25510
o24.fromElement = null;
// 25513
o24.shiftKey = false;
// 25516
o24.timeStamp = 1374851250731;
// 25517
o24.type = "mousemove";
// 25518
o24.view = ow81632121;
// undefined
o24 = null;
// 25527
f81632121_1852.returns.push(undefined);
// 25530
f81632121_14.returns.push(undefined);
// 25531
f81632121_12.returns.push(109);
// 25534
o24 = {};
// 25538
f81632121_467.returns.push(1374851250744);
// 25539
o24.cancelBubble = false;
// 25540
o24.returnValue = true;
// 25543
o24.srcElement = o182;
// 25545
o24.target = o182;
// 25552
f81632121_506.returns.push(null);
// 25558
f81632121_506.returns.push(null);
// 25564
f81632121_506.returns.push(null);
// 25570
f81632121_506.returns.push(null);
// 25576
f81632121_506.returns.push(null);
// 25582
f81632121_506.returns.push(null);
// 25588
f81632121_506.returns.push(null);
// 25594
f81632121_506.returns.push(null);
// 25600
f81632121_506.returns.push(null);
// 25606
f81632121_506.returns.push(null);
// 25612
f81632121_506.returns.push(null);
// 25618
f81632121_506.returns.push(null);
// 25624
f81632121_506.returns.push(null);
// 25630
f81632121_506.returns.push(null);
// 25636
f81632121_506.returns.push(null);
// 25642
f81632121_506.returns.push(null);
// 25648
f81632121_506.returns.push(null);
// 25653
o24.JSBNG__screenX = 829;
// 25654
o24.JSBNG__screenY = 541;
// 25655
o24.altKey = false;
// 25656
o24.bubbles = true;
// 25657
o24.button = 0;
// 25658
o24.buttons = void 0;
// 25659
o24.cancelable = false;
// 25660
o24.clientX = 761;
// 25661
o24.clientY = 376;
// 25662
o24.ctrlKey = false;
// 25663
o24.currentTarget = o0;
// 25664
o24.defaultPrevented = false;
// 25665
o24.detail = 0;
// 25666
o24.eventPhase = 3;
// 25667
o24.isTrusted = void 0;
// 25668
o24.metaKey = false;
// 25669
o24.pageX = 761;
// 25670
o24.pageY = 376;
// 25671
o24.relatedTarget = null;
// 25672
o24.fromElement = null;
// 25675
o24.shiftKey = false;
// 25678
o24.timeStamp = 1374851250740;
// 25679
o24.type = "mousemove";
// 25680
o24.view = ow81632121;
// undefined
o24 = null;
// 25689
f81632121_1852.returns.push(undefined);
// 25692
f81632121_14.returns.push(undefined);
// 25693
f81632121_12.returns.push(110);
// 25696
o24 = {};
// 25700
f81632121_467.returns.push(1374851250752);
// 25701
o24.cancelBubble = false;
// 25702
o24.returnValue = true;
// 25705
o24.srcElement = o182;
// 25707
o24.target = o182;
// 25714
f81632121_506.returns.push(null);
// 25720
f81632121_506.returns.push(null);
// 25726
f81632121_506.returns.push(null);
// 25732
f81632121_506.returns.push(null);
// 25738
f81632121_506.returns.push(null);
// 25744
f81632121_506.returns.push(null);
// 25750
f81632121_506.returns.push(null);
// 25756
f81632121_506.returns.push(null);
// 25762
f81632121_506.returns.push(null);
// 25768
f81632121_506.returns.push(null);
// 25774
f81632121_506.returns.push(null);
// 25780
f81632121_506.returns.push(null);
// 25786
f81632121_506.returns.push(null);
// 25792
f81632121_506.returns.push(null);
// 25798
f81632121_506.returns.push(null);
// 25804
f81632121_506.returns.push(null);
// 25810
f81632121_506.returns.push(null);
// 25815
o24.JSBNG__screenX = 829;
// 25816
o24.JSBNG__screenY = 543;
// 25817
o24.altKey = false;
// 25818
o24.bubbles = true;
// 25819
o24.button = 0;
// 25820
o24.buttons = void 0;
// 25821
o24.cancelable = false;
// 25822
o24.clientX = 761;
// 25823
o24.clientY = 378;
// 25824
o24.ctrlKey = false;
// 25825
o24.currentTarget = o0;
// 25826
o24.defaultPrevented = false;
// 25827
o24.detail = 0;
// 25828
o24.eventPhase = 3;
// 25829
o24.isTrusted = void 0;
// 25830
o24.metaKey = false;
// 25831
o24.pageX = 761;
// 25832
o24.pageY = 378;
// 25833
o24.relatedTarget = null;
// 25834
o24.fromElement = null;
// 25837
o24.shiftKey = false;
// 25840
o24.timeStamp = 1374851250752;
// 25841
o24.type = "mousemove";
// 25842
o24.view = ow81632121;
// undefined
o24 = null;
// 25851
f81632121_1852.returns.push(undefined);
// 25854
f81632121_14.returns.push(undefined);
// 25855
f81632121_12.returns.push(111);
// 25858
o24 = {};
// 25862
f81632121_467.returns.push(1374851250761);
// 25863
o24.cancelBubble = false;
// 25864
o24.returnValue = true;
// 25867
o24.srcElement = o182;
// 25869
o24.target = o182;
// 25876
f81632121_506.returns.push(null);
// 25882
f81632121_506.returns.push(null);
// 25888
f81632121_506.returns.push(null);
// 25894
f81632121_506.returns.push(null);
// 25900
f81632121_506.returns.push(null);
// 25906
f81632121_506.returns.push(null);
// 25912
f81632121_506.returns.push(null);
// 25918
f81632121_506.returns.push(null);
// 25924
f81632121_506.returns.push(null);
// 25930
f81632121_506.returns.push(null);
// 25936
f81632121_506.returns.push(null);
// 25942
f81632121_506.returns.push(null);
// 25948
f81632121_506.returns.push(null);
// 25954
f81632121_506.returns.push(null);
// 25960
f81632121_506.returns.push(null);
// 25966
f81632121_506.returns.push(null);
// 25972
f81632121_506.returns.push(null);
// 25977
o24.JSBNG__screenX = 828;
// 25978
o24.JSBNG__screenY = 544;
// 25979
o24.altKey = false;
// 25980
o24.bubbles = true;
// 25981
o24.button = 0;
// 25982
o24.buttons = void 0;
// 25983
o24.cancelable = false;
// 25984
o24.clientX = 760;
// 25985
o24.clientY = 379;
// 25986
o24.ctrlKey = false;
// 25987
o24.currentTarget = o0;
// 25988
o24.defaultPrevented = false;
// 25989
o24.detail = 0;
// 25990
o24.eventPhase = 3;
// 25991
o24.isTrusted = void 0;
// 25992
o24.metaKey = false;
// 25993
o24.pageX = 760;
// 25994
o24.pageY = 379;
// 25995
o24.relatedTarget = null;
// 25996
o24.fromElement = null;
// 25999
o24.shiftKey = false;
// 26002
o24.timeStamp = 1374851250761;
// 26003
o24.type = "mousemove";
// 26004
o24.view = ow81632121;
// undefined
o24 = null;
// 26013
f81632121_1852.returns.push(undefined);
// 26016
f81632121_14.returns.push(undefined);
// 26017
f81632121_12.returns.push(112);
// 26020
o24 = {};
// 26024
f81632121_467.returns.push(1374851250771);
// 26025
o24.cancelBubble = false;
// 26026
o24.returnValue = true;
// 26029
o24.srcElement = o182;
// 26031
o24.target = o182;
// 26038
f81632121_506.returns.push(null);
// 26044
f81632121_506.returns.push(null);
// 26050
f81632121_506.returns.push(null);
// 26056
f81632121_506.returns.push(null);
// 26062
f81632121_506.returns.push(null);
// 26068
f81632121_506.returns.push(null);
// 26074
f81632121_506.returns.push(null);
// 26080
f81632121_506.returns.push(null);
// 26086
f81632121_506.returns.push(null);
// 26092
f81632121_506.returns.push(null);
// 26098
f81632121_506.returns.push(null);
// 26104
f81632121_506.returns.push(null);
// 26110
f81632121_506.returns.push(null);
// 26116
f81632121_506.returns.push(null);
// 26122
f81632121_506.returns.push(null);
// 26128
f81632121_506.returns.push(null);
// 26134
f81632121_506.returns.push(null);
// 26139
o24.JSBNG__screenX = 828;
// 26140
o24.JSBNG__screenY = 545;
// 26141
o24.altKey = false;
// 26142
o24.bubbles = true;
// 26143
o24.button = 0;
// 26144
o24.buttons = void 0;
// 26145
o24.cancelable = false;
// 26146
o24.clientX = 760;
// 26147
o24.clientY = 380;
// 26148
o24.ctrlKey = false;
// 26149
o24.currentTarget = o0;
// 26150
o24.defaultPrevented = false;
// 26151
o24.detail = 0;
// 26152
o24.eventPhase = 3;
// 26153
o24.isTrusted = void 0;
// 26154
o24.metaKey = false;
// 26155
o24.pageX = 760;
// 26156
o24.pageY = 380;
// 26157
o24.relatedTarget = null;
// 26158
o24.fromElement = null;
// 26161
o24.shiftKey = false;
// 26164
o24.timeStamp = 1374851250771;
// 26165
o24.type = "mousemove";
// 26166
o24.view = ow81632121;
// undefined
o24 = null;
// 26175
f81632121_1852.returns.push(undefined);
// 26178
f81632121_14.returns.push(undefined);
// 26179
f81632121_12.returns.push(113);
// 26182
o24 = {};
// 26186
f81632121_467.returns.push(1374851250780);
// 26187
o24.cancelBubble = false;
// 26188
o24.returnValue = true;
// 26191
o24.srcElement = o182;
// 26193
o24.target = o182;
// 26200
f81632121_506.returns.push(null);
// 26206
f81632121_506.returns.push(null);
// 26212
f81632121_506.returns.push(null);
// 26218
f81632121_506.returns.push(null);
// 26224
f81632121_506.returns.push(null);
// 26230
f81632121_506.returns.push(null);
// 26236
f81632121_506.returns.push(null);
// 26242
f81632121_506.returns.push(null);
// 26248
f81632121_506.returns.push(null);
// 26254
f81632121_506.returns.push(null);
// 26260
f81632121_506.returns.push(null);
// 26266
f81632121_506.returns.push(null);
// 26272
f81632121_506.returns.push(null);
// 26278
f81632121_506.returns.push(null);
// 26284
f81632121_506.returns.push(null);
// 26290
f81632121_506.returns.push(null);
// 26296
f81632121_506.returns.push(null);
// 26301
o24.JSBNG__screenX = 827;
// 26302
o24.JSBNG__screenY = 547;
// 26303
o24.altKey = false;
// 26304
o24.bubbles = true;
// 26305
o24.button = 0;
// 26306
o24.buttons = void 0;
// 26307
o24.cancelable = false;
// 26308
o24.clientX = 759;
// 26309
o24.clientY = 382;
// 26310
o24.ctrlKey = false;
// 26311
o24.currentTarget = o0;
// 26312
o24.defaultPrevented = false;
// 26313
o24.detail = 0;
// 26314
o24.eventPhase = 3;
// 26315
o24.isTrusted = void 0;
// 26316
o24.metaKey = false;
// 26317
o24.pageX = 759;
// 26318
o24.pageY = 382;
// 26319
o24.relatedTarget = null;
// 26320
o24.fromElement = null;
// 26323
o24.shiftKey = false;
// 26326
o24.timeStamp = 1374851250780;
// 26327
o24.type = "mousemove";
// 26328
o24.view = ow81632121;
// undefined
o24 = null;
// 26337
f81632121_1852.returns.push(undefined);
// 26340
f81632121_14.returns.push(undefined);
// 26341
f81632121_12.returns.push(114);
// 26344
o24 = {};
// 26348
f81632121_467.returns.push(1374851250787);
// 26349
o24.cancelBubble = false;
// 26350
o24.returnValue = true;
// 26353
o24.srcElement = o182;
// 26355
o24.target = o182;
// 26362
f81632121_506.returns.push(null);
// 26368
f81632121_506.returns.push(null);
// 26374
f81632121_506.returns.push(null);
// 26380
f81632121_506.returns.push(null);
// 26386
f81632121_506.returns.push(null);
// 26392
f81632121_506.returns.push(null);
// 26398
f81632121_506.returns.push(null);
// 26404
f81632121_506.returns.push(null);
// 26410
f81632121_506.returns.push(null);
// 26416
f81632121_506.returns.push(null);
// 26422
f81632121_506.returns.push(null);
// 26428
f81632121_506.returns.push(null);
// 26434
f81632121_506.returns.push(null);
// 26440
f81632121_506.returns.push(null);
// 26446
f81632121_506.returns.push(null);
// 26452
f81632121_506.returns.push(null);
// 26458
f81632121_506.returns.push(null);
// 26463
o24.JSBNG__screenX = 827;
// 26464
o24.JSBNG__screenY = 550;
// 26465
o24.altKey = false;
// 26466
o24.bubbles = true;
// 26467
o24.button = 0;
// 26468
o24.buttons = void 0;
// 26469
o24.cancelable = false;
// 26470
o24.clientX = 759;
// 26471
o24.clientY = 385;
// 26472
o24.ctrlKey = false;
// 26473
o24.currentTarget = o0;
// 26474
o24.defaultPrevented = false;
// 26475
o24.detail = 0;
// 26476
o24.eventPhase = 3;
// 26477
o24.isTrusted = void 0;
// 26478
o24.metaKey = false;
// 26479
o24.pageX = 759;
// 26480
o24.pageY = 385;
// 26481
o24.relatedTarget = null;
// 26482
o24.fromElement = null;
// 26485
o24.shiftKey = false;
// 26488
o24.timeStamp = 1374851250787;
// 26489
o24.type = "mousemove";
// 26490
o24.view = ow81632121;
// undefined
o24 = null;
// 26499
f81632121_1852.returns.push(undefined);
// 26502
f81632121_14.returns.push(undefined);
// 26503
f81632121_12.returns.push(115);
// 26506
o24 = {};
// 26510
f81632121_467.returns.push(1374851250804);
// 26511
o24.cancelBubble = false;
// 26512
o24.returnValue = true;
// 26515
o24.srcElement = o182;
// 26517
o24.target = o182;
// 26524
f81632121_506.returns.push(null);
// 26530
f81632121_506.returns.push(null);
// 26536
f81632121_506.returns.push(null);
// 26542
f81632121_506.returns.push(null);
// 26548
f81632121_506.returns.push(null);
// 26554
f81632121_506.returns.push(null);
// 26560
f81632121_506.returns.push(null);
// 26566
f81632121_506.returns.push(null);
// 26572
f81632121_506.returns.push(null);
// 26578
f81632121_506.returns.push(null);
// 26584
f81632121_506.returns.push(null);
// 26590
f81632121_506.returns.push(null);
// 26596
f81632121_506.returns.push(null);
// 26602
f81632121_506.returns.push(null);
// 26608
f81632121_506.returns.push(null);
// 26614
f81632121_506.returns.push(null);
// 26620
f81632121_506.returns.push(null);
// 26625
o24.JSBNG__screenX = 825;
// 26626
o24.JSBNG__screenY = 557;
// 26627
o24.altKey = false;
// 26628
o24.bubbles = true;
// 26629
o24.button = 0;
// 26630
o24.buttons = void 0;
// 26631
o24.cancelable = false;
// 26632
o24.clientX = 757;
// 26633
o24.clientY = 392;
// 26634
o24.ctrlKey = false;
// 26635
o24.currentTarget = o0;
// 26636
o24.defaultPrevented = false;
// 26637
o24.detail = 0;
// 26638
o24.eventPhase = 3;
// 26639
o24.isTrusted = void 0;
// 26640
o24.metaKey = false;
// 26641
o24.pageX = 757;
// 26642
o24.pageY = 392;
// 26643
o24.relatedTarget = null;
// 26644
o24.fromElement = null;
// 26647
o24.shiftKey = false;
// 26650
o24.timeStamp = 1374851250804;
// 26651
o24.type = "mousemove";
// 26652
o24.view = ow81632121;
// undefined
o24 = null;
// 26661
f81632121_1852.returns.push(undefined);
// 26664
f81632121_14.returns.push(undefined);
// 26665
f81632121_12.returns.push(116);
// 26668
o24 = {};
// 26672
f81632121_467.returns.push(1374851250810);
// 26673
o24.cancelBubble = false;
// 26674
o24.returnValue = true;
// 26677
o24.srcElement = o182;
// 26679
o24.target = o182;
// 26686
f81632121_506.returns.push(null);
// 26692
f81632121_506.returns.push(null);
// 26698
f81632121_506.returns.push(null);
// 26704
f81632121_506.returns.push(null);
// 26710
f81632121_506.returns.push(null);
// 26716
f81632121_506.returns.push(null);
// 26722
f81632121_506.returns.push(null);
// 26728
f81632121_506.returns.push(null);
// 26734
f81632121_506.returns.push(null);
// 26740
f81632121_506.returns.push(null);
// 26746
f81632121_506.returns.push(null);
// 26752
f81632121_506.returns.push(null);
// 26758
f81632121_506.returns.push(null);
// 26764
f81632121_506.returns.push(null);
// 26770
f81632121_506.returns.push(null);
// 26776
f81632121_506.returns.push(null);
// 26782
f81632121_506.returns.push(null);
// 26787
o24.JSBNG__screenX = 824;
// 26788
o24.JSBNG__screenY = 563;
// 26789
o24.altKey = false;
// 26790
o24.bubbles = true;
// 26791
o24.button = 0;
// 26792
o24.buttons = void 0;
// 26793
o24.cancelable = false;
// 26794
o24.clientX = 756;
// 26795
o24.clientY = 398;
// 26796
o24.ctrlKey = false;
// 26797
o24.currentTarget = o0;
// 26798
o24.defaultPrevented = false;
// 26799
o24.detail = 0;
// 26800
o24.eventPhase = 3;
// 26801
o24.isTrusted = void 0;
// 26802
o24.metaKey = false;
// 26803
o24.pageX = 756;
// 26804
o24.pageY = 398;
// 26805
o24.relatedTarget = null;
// 26806
o24.fromElement = null;
// 26809
o24.shiftKey = false;
// 26812
o24.timeStamp = 1374851250810;
// 26813
o24.type = "mousemove";
// 26814
o24.view = ow81632121;
// undefined
o24 = null;
// 26823
f81632121_1852.returns.push(undefined);
// 26826
f81632121_14.returns.push(undefined);
// 26827
f81632121_12.returns.push(117);
// 26830
o24 = {};
// 26833
o24.srcElement = o182;
// 26835
o24.target = o182;
// 26842
f81632121_506.returns.push(null);
// 26848
f81632121_506.returns.push(null);
// 26854
f81632121_506.returns.push(null);
// 26860
f81632121_506.returns.push(null);
// 26866
f81632121_506.returns.push(null);
// 26872
f81632121_506.returns.push(null);
// 26878
f81632121_506.returns.push(null);
// 26884
f81632121_506.returns.push(null);
// 26890
f81632121_506.returns.push(null);
// 26896
f81632121_506.returns.push(null);
// 26902
f81632121_506.returns.push(null);
// 26908
f81632121_506.returns.push(null);
// 26914
f81632121_506.returns.push(null);
// 26920
f81632121_506.returns.push(null);
// 26926
f81632121_506.returns.push(null);
// 26932
f81632121_506.returns.push(null);
// 26938
f81632121_506.returns.push(null);
// 26943
o24.relatedTarget = o185;
// 26948
f81632121_506.returns.push(null);
// 26954
f81632121_506.returns.push(null);
// 26960
f81632121_506.returns.push(null);
// 26966
f81632121_506.returns.push(null);
// 26972
f81632121_506.returns.push(null);
// 26978
f81632121_506.returns.push(null);
// 26984
f81632121_506.returns.push(null);
// 26990
f81632121_506.returns.push(null);
// 26996
f81632121_506.returns.push(null);
// 27002
f81632121_506.returns.push(null);
// 27008
f81632121_506.returns.push(null);
// 27014
f81632121_506.returns.push(null);
// 27019
o24.cancelBubble = false;
// 27020
o24.returnValue = true;
// undefined
o24 = null;
// 27021
o24 = {};
// 27024
o24.cancelBubble = false;
// 27027
f81632121_467.returns.push(1374851250831);
// 27030
f81632121_1007.returns.push(undefined);
// 27032
o24.returnValue = true;
// 27035
o24.srcElement = o185;
// 27037
o24.target = o185;
// 27044
f81632121_506.returns.push(null);
// 27050
f81632121_506.returns.push(null);
// 27056
f81632121_506.returns.push(null);
// 27062
f81632121_506.returns.push(null);
// 27068
f81632121_506.returns.push(null);
// 27074
f81632121_506.returns.push(null);
// 27080
f81632121_506.returns.push(null);
// 27086
f81632121_506.returns.push(null);
// 27092
f81632121_506.returns.push(null);
// 27098
f81632121_506.returns.push(null);
// 27104
f81632121_506.returns.push(null);
// 27110
f81632121_506.returns.push(null);
// 27115
o24.relatedTarget = o182;
// undefined
o24 = null;
// undefined
o182 = null;
// 27118
o24 = {};
// 27122
f81632121_467.returns.push(1374851250836);
// 27123
o24.cancelBubble = false;
// 27124
o24.returnValue = true;
// 27127
o24.srcElement = o185;
// 27129
o24.target = o185;
// 27136
f81632121_506.returns.push(null);
// 27142
f81632121_506.returns.push(null);
// 27148
f81632121_506.returns.push(null);
// 27154
f81632121_506.returns.push(null);
// 27160
f81632121_506.returns.push(null);
// 27166
f81632121_506.returns.push(null);
// 27172
f81632121_506.returns.push(null);
// 27178
f81632121_506.returns.push(null);
// 27184
f81632121_506.returns.push(null);
// 27190
f81632121_506.returns.push(null);
// 27196
f81632121_506.returns.push(null);
// 27202
f81632121_506.returns.push(null);
// 27207
o24.JSBNG__screenX = 824;
// 27208
o24.JSBNG__screenY = 566;
// 27209
o24.altKey = false;
// 27210
o24.bubbles = true;
// 27211
o24.button = 0;
// 27212
o24.buttons = void 0;
// 27213
o24.cancelable = false;
// 27214
o24.clientX = 756;
// 27215
o24.clientY = 401;
// 27216
o24.ctrlKey = false;
// 27217
o24.currentTarget = o0;
// 27218
o24.defaultPrevented = false;
// 27219
o24.detail = 0;
// 27220
o24.eventPhase = 3;
// 27221
o24.isTrusted = void 0;
// 27222
o24.metaKey = false;
// 27223
o24.pageX = 756;
// 27224
o24.pageY = 401;
// 27225
o24.relatedTarget = null;
// 27226
o24.fromElement = null;
// 27229
o24.shiftKey = false;
// 27232
o24.timeStamp = 1374851250836;
// 27233
o24.type = "mousemove";
// 27234
o24.view = ow81632121;
// undefined
o24 = null;
// 27243
f81632121_1852.returns.push(undefined);
// 27246
f81632121_14.returns.push(undefined);
// 27247
f81632121_12.returns.push(118);
// 27250
o24 = {};
// 27253
o24.srcElement = o185;
// 27255
o24.target = o185;
// 27262
f81632121_506.returns.push(null);
// 27268
f81632121_506.returns.push(null);
// 27274
f81632121_506.returns.push(null);
// 27280
f81632121_506.returns.push(null);
// 27286
f81632121_506.returns.push(null);
// 27292
f81632121_506.returns.push(null);
// 27298
f81632121_506.returns.push(null);
// 27304
f81632121_506.returns.push(null);
// 27310
f81632121_506.returns.push(null);
// 27316
f81632121_506.returns.push(null);
// 27322
f81632121_506.returns.push(null);
// 27328
f81632121_506.returns.push(null);
// 27333
o28 = {};
// 27334
o24.relatedTarget = o28;
// 27335
o28.parentNode = o26;
// 27336
o28.nodeType = 1;
// 27337
o28.getAttribute = f81632121_506;
// 27339
f81632121_506.returns.push(null);
// 27341
o26.parentNode = o185;
// 27342
o26.nodeType = 1;
// undefined
o26 = null;
// 27345
f81632121_506.returns.push(null);
// 27351
f81632121_506.returns.push(null);
// 27357
f81632121_506.returns.push(null);
// 27363
f81632121_506.returns.push(null);
// 27369
f81632121_506.returns.push(null);
// 27375
f81632121_506.returns.push(null);
// 27381
f81632121_506.returns.push(null);
// 27387
f81632121_506.returns.push(null);
// 27393
f81632121_506.returns.push(null);
// 27399
f81632121_506.returns.push(null);
// 27405
f81632121_506.returns.push(null);
// 27411
f81632121_506.returns.push(null);
// 27417
f81632121_506.returns.push(null);
// 27422
o24.cancelBubble = false;
// 27423
o24.returnValue = true;
// undefined
o24 = null;
// 27424
o24 = {};
// 27427
o24.cancelBubble = false;
// 27430
f81632121_467.returns.push(1374851250854);
// 27433
f81632121_1007.returns.push(undefined);
// 27435
o24.returnValue = true;
// 27438
o24.srcElement = o28;
// 27440
o24.target = o28;
// 27447
f81632121_506.returns.push(null);
// 27453
f81632121_506.returns.push(null);
// 27459
f81632121_506.returns.push(null);
// 27465
f81632121_506.returns.push(null);
// 27471
f81632121_506.returns.push(null);
// 27477
f81632121_506.returns.push(null);
// 27483
f81632121_506.returns.push(null);
// 27489
f81632121_506.returns.push(null);
// 27495
f81632121_506.returns.push(null);
// 27501
f81632121_506.returns.push(null);
// 27507
f81632121_506.returns.push(null);
// 27513
f81632121_506.returns.push(null);
// 27519
f81632121_506.returns.push(null);
// 27525
f81632121_506.returns.push(null);
// 27530
o24.relatedTarget = o185;
// undefined
o24 = null;
// undefined
o185 = null;
// 27533
o24 = {};
// 27537
f81632121_467.returns.push(1374851250863);
// 27538
o24.cancelBubble = false;
// 27539
o24.returnValue = true;
// 27542
o24.srcElement = o28;
// 27544
o24.target = o28;
// 27551
f81632121_506.returns.push(null);
// 27557
f81632121_506.returns.push(null);
// 27563
f81632121_506.returns.push(null);
// 27569
f81632121_506.returns.push(null);
// 27575
f81632121_506.returns.push(null);
// 27581
f81632121_506.returns.push(null);
// 27587
f81632121_506.returns.push(null);
// 27593
f81632121_506.returns.push(null);
// 27599
f81632121_506.returns.push(null);
// 27605
f81632121_506.returns.push(null);
// 27611
f81632121_506.returns.push(null);
// 27617
f81632121_506.returns.push(null);
// 27623
f81632121_506.returns.push(null);
// 27629
f81632121_506.returns.push(null);
// 27634
o24.JSBNG__screenX = 822;
// 27635
o24.JSBNG__screenY = 580;
// 27636
o24.altKey = false;
// 27637
o24.bubbles = true;
// 27638
o24.button = 0;
// 27639
o24.buttons = void 0;
// 27640
o24.cancelable = false;
// 27641
o24.clientX = 754;
// 27642
o24.clientY = 415;
// 27643
o24.ctrlKey = false;
// 27644
o24.currentTarget = o0;
// 27645
o24.defaultPrevented = false;
// 27646
o24.detail = 0;
// 27647
o24.eventPhase = 3;
// 27648
o24.isTrusted = void 0;
// 27649
o24.metaKey = false;
// 27650
o24.pageX = 754;
// 27651
o24.pageY = 415;
// 27652
o24.relatedTarget = null;
// 27653
o24.fromElement = null;
// 27656
o24.shiftKey = false;
// 27659
o24.timeStamp = 1374851250863;
// 27660
o24.type = "mousemove";
// 27661
o24.view = ow81632121;
// undefined
o24 = null;
// 27670
f81632121_1852.returns.push(undefined);
// 27673
f81632121_14.returns.push(undefined);
// 27674
f81632121_12.returns.push(119);
// 27684
f81632121_467.returns.push(1374851250872);
// 27686
f81632121_1007.returns.push(undefined);
// 27692
f81632121_467.returns.push(1374851250872);
// 27699
f81632121_1852.returns.push(undefined);
// 27701
f81632121_14.returns.push(undefined);
// 27702
f81632121_12.returns.push(120);
// 27703
f81632121_12.returns.push(121);
// 27705
o24 = {};
// 27709
f81632121_467.returns.push(1374851250882);
// 27710
o24.cancelBubble = false;
// 27711
o24.returnValue = true;
// 27714
o26 = {};
// 27715
o24.srcElement = o26;
// 27717
o24.target = o26;
// 27719
o26.nodeType = 1;
// 27720
o32 = {};
// 27721
o26.parentNode = o32;
// 27723
o26.getAttribute = f81632121_506;
// 27725
f81632121_506.returns.push(null);
// 27727
o33 = {};
// 27728
o32.parentNode = o33;
// 27729
o32.nodeType = 1;
// 27730
o32.getAttribute = f81632121_506;
// undefined
o32 = null;
// 27732
f81632121_506.returns.push(null);
// 27734
o33.parentNode = o28;
// 27735
o33.nodeType = 1;
// 27736
o33.getAttribute = f81632121_506;
// undefined
o33 = null;
// 27738
f81632121_506.returns.push(null);
// 27744
f81632121_506.returns.push(null);
// 27750
f81632121_506.returns.push(null);
// 27756
f81632121_506.returns.push(null);
// 27762
f81632121_506.returns.push(null);
// 27768
f81632121_506.returns.push(null);
// 27774
f81632121_506.returns.push(null);
// 27780
f81632121_506.returns.push(null);
// 27786
f81632121_506.returns.push(null);
// 27792
f81632121_506.returns.push(null);
// 27798
f81632121_506.returns.push(null);
// 27804
f81632121_506.returns.push(null);
// 27810
f81632121_506.returns.push(null);
// 27816
f81632121_506.returns.push(null);
// 27822
f81632121_506.returns.push(null);
// 27827
o24.JSBNG__screenX = 822;
// 27828
o24.JSBNG__screenY = 593;
// 27829
o24.altKey = false;
// 27830
o24.bubbles = true;
// 27831
o24.button = 0;
// 27832
o24.buttons = void 0;
// 27833
o24.cancelable = false;
// 27834
o24.clientX = 754;
// 27835
o24.clientY = 428;
// 27836
o24.ctrlKey = false;
// 27837
o24.currentTarget = o0;
// 27838
o24.defaultPrevented = false;
// 27839
o24.detail = 0;
// 27840
o24.eventPhase = 3;
// 27841
o24.isTrusted = void 0;
// 27842
o24.metaKey = false;
// 27843
o24.pageX = 754;
// 27844
o24.pageY = 428;
// 27845
o24.relatedTarget = null;
// 27846
o24.fromElement = null;
// 27849
o24.shiftKey = false;
// 27852
o24.timeStamp = 1374851250882;
// 27853
o24.type = "mousemove";
// 27854
o24.view = ow81632121;
// undefined
o24 = null;
// 27863
f81632121_1852.returns.push(undefined);
// 27866
f81632121_14.returns.push(undefined);
// 27867
f81632121_12.returns.push(122);
// 27870
o24 = {};
// 27874
f81632121_467.returns.push(1374851250893);
// 27875
o24.cancelBubble = false;
// 27876
o24.returnValue = true;
// 27879
o24.srcElement = o26;
// 27881
o24.target = o26;
// 27888
f81632121_506.returns.push(null);
// 27894
f81632121_506.returns.push(null);
// 27900
f81632121_506.returns.push(null);
// 27906
f81632121_506.returns.push(null);
// 27912
f81632121_506.returns.push(null);
// 27918
f81632121_506.returns.push(null);
// 27924
f81632121_506.returns.push(null);
// 27930
f81632121_506.returns.push(null);
// 27936
f81632121_506.returns.push(null);
// 27942
f81632121_506.returns.push(null);
// 27948
f81632121_506.returns.push(null);
// 27954
f81632121_506.returns.push(null);
// 27960
f81632121_506.returns.push(null);
// 27966
f81632121_506.returns.push(null);
// 27972
f81632121_506.returns.push(null);
// 27978
f81632121_506.returns.push(null);
// 27984
f81632121_506.returns.push(null);
// 27989
o24.JSBNG__screenX = 823;
// 27990
o24.JSBNG__screenY = 596;
// 27991
o24.altKey = false;
// 27992
o24.bubbles = true;
// 27993
o24.button = 0;
// 27994
o24.buttons = void 0;
// 27995
o24.cancelable = false;
// 27996
o24.clientX = 755;
// 27997
o24.clientY = 431;
// 27998
o24.ctrlKey = false;
// 27999
o24.currentTarget = o0;
// 28000
o24.defaultPrevented = false;
// 28001
o24.detail = 0;
// 28002
o24.eventPhase = 3;
// 28003
o24.isTrusted = void 0;
// 28004
o24.metaKey = false;
// 28005
o24.pageX = 755;
// 28006
o24.pageY = 431;
// 28007
o24.relatedTarget = null;
// 28008
o24.fromElement = null;
// 28011
o24.shiftKey = false;
// 28014
o24.timeStamp = 1374851250893;
// 28015
o24.type = "mousemove";
// 28016
o24.view = ow81632121;
// undefined
o24 = null;
// 28025
f81632121_1852.returns.push(undefined);
// 28028
f81632121_14.returns.push(undefined);
// 28029
f81632121_12.returns.push(123);
// 28032
o24 = {};
// 28036
f81632121_467.returns.push(1374851250903);
// 28037
o24.cancelBubble = false;
// 28038
o24.returnValue = true;
// 28041
o24.srcElement = o26;
// 28043
o24.target = o26;
// 28050
f81632121_506.returns.push(null);
// 28056
f81632121_506.returns.push(null);
// 28062
f81632121_506.returns.push(null);
// 28068
f81632121_506.returns.push(null);
// 28074
f81632121_506.returns.push(null);
// 28080
f81632121_506.returns.push(null);
// 28086
f81632121_506.returns.push(null);
// 28092
f81632121_506.returns.push(null);
// 28098
f81632121_506.returns.push(null);
// 28104
f81632121_506.returns.push(null);
// 28110
f81632121_506.returns.push(null);
// 28116
f81632121_506.returns.push(null);
// 28122
f81632121_506.returns.push(null);
// 28128
f81632121_506.returns.push(null);
// 28134
f81632121_506.returns.push(null);
// 28140
f81632121_506.returns.push(null);
// 28146
f81632121_506.returns.push(null);
// 28151
o24.JSBNG__screenX = 825;
// 28152
o24.JSBNG__screenY = 597;
// 28153
o24.altKey = false;
// 28154
o24.bubbles = true;
// 28155
o24.button = 0;
// 28156
o24.buttons = void 0;
// 28157
o24.cancelable = false;
// 28158
o24.clientX = 757;
// 28159
o24.clientY = 432;
// 28160
o24.ctrlKey = false;
// 28161
o24.currentTarget = o0;
// 28162
o24.defaultPrevented = false;
// 28163
o24.detail = 0;
// 28164
o24.eventPhase = 3;
// 28165
o24.isTrusted = void 0;
// 28166
o24.metaKey = false;
// 28167
o24.pageX = 757;
// 28168
o24.pageY = 432;
// 28169
o24.relatedTarget = null;
// 28170
o24.fromElement = null;
// 28173
o24.shiftKey = false;
// 28176
o24.timeStamp = 1374851250902;
// 28177
o24.type = "mousemove";
// 28178
o24.view = ow81632121;
// undefined
o24 = null;
// 28187
f81632121_1852.returns.push(undefined);
// 28190
f81632121_14.returns.push(undefined);
// 28191
f81632121_12.returns.push(124);
// 28194
o24 = {};
// 28198
f81632121_467.returns.push(1374851250912);
// 28199
o24.cancelBubble = false;
// 28200
o24.returnValue = true;
// 28203
o24.srcElement = o26;
// 28205
o24.target = o26;
// 28212
f81632121_506.returns.push(null);
// 28218
f81632121_506.returns.push(null);
// 28224
f81632121_506.returns.push(null);
// 28230
f81632121_506.returns.push(null);
// 28236
f81632121_506.returns.push(null);
// 28242
f81632121_506.returns.push(null);
// 28248
f81632121_506.returns.push(null);
// 28254
f81632121_506.returns.push(null);
// 28260
f81632121_506.returns.push(null);
// 28266
f81632121_506.returns.push(null);
// 28272
f81632121_506.returns.push(null);
// 28278
f81632121_506.returns.push(null);
// 28284
f81632121_506.returns.push(null);
// 28290
f81632121_506.returns.push(null);
// 28296
f81632121_506.returns.push(null);
// 28302
f81632121_506.returns.push(null);
// 28308
f81632121_506.returns.push(null);
// 28313
o24.JSBNG__screenX = 827;
// 28314
o24.JSBNG__screenY = 600;
// 28315
o24.altKey = false;
// 28316
o24.bubbles = true;
// 28317
o24.button = 0;
// 28318
o24.buttons = void 0;
// 28319
o24.cancelable = false;
// 28320
o24.clientX = 759;
// 28321
o24.clientY = 435;
// 28322
o24.ctrlKey = false;
// 28323
o24.currentTarget = o0;
// 28324
o24.defaultPrevented = false;
// 28325
o24.detail = 0;
// 28326
o24.eventPhase = 3;
// 28327
o24.isTrusted = void 0;
// 28328
o24.metaKey = false;
// 28329
o24.pageX = 759;
// 28330
o24.pageY = 435;
// 28331
o24.relatedTarget = null;
// 28332
o24.fromElement = null;
// 28335
o24.shiftKey = false;
// 28338
o24.timeStamp = 1374851250912;
// 28339
o24.type = "mousemove";
// 28340
o24.view = ow81632121;
// undefined
o24 = null;
// 28349
f81632121_1852.returns.push(undefined);
// 28352
f81632121_14.returns.push(undefined);
// 28353
f81632121_12.returns.push(125);
// 28356
o24 = {};
// 28360
f81632121_467.returns.push(1374851250921);
// 28361
o24.cancelBubble = false;
// 28362
o24.returnValue = true;
// 28365
o24.srcElement = o26;
// 28367
o24.target = o26;
// 28374
f81632121_506.returns.push(null);
// 28380
f81632121_506.returns.push(null);
// 28386
f81632121_506.returns.push(null);
// 28392
f81632121_506.returns.push(null);
// 28398
f81632121_506.returns.push(null);
// 28404
f81632121_506.returns.push(null);
// 28410
f81632121_506.returns.push(null);
// 28416
f81632121_506.returns.push(null);
// 28422
f81632121_506.returns.push(null);
// 28428
f81632121_506.returns.push(null);
// 28434
f81632121_506.returns.push(null);
// 28440
f81632121_506.returns.push(null);
// 28446
f81632121_506.returns.push(null);
// 28452
f81632121_506.returns.push(null);
// 28458
f81632121_506.returns.push(null);
// 28464
f81632121_506.returns.push(null);
// 28470
f81632121_506.returns.push(null);
// 28475
o24.JSBNG__screenX = 829;
// 28476
o24.JSBNG__screenY = 601;
// 28477
o24.altKey = false;
// 28478
o24.bubbles = true;
// 28479
o24.button = 0;
// 28480
o24.buttons = void 0;
// 28481
o24.cancelable = false;
// 28482
o24.clientX = 761;
// 28483
o24.clientY = 436;
// 28484
o24.ctrlKey = false;
// 28485
o24.currentTarget = o0;
// 28486
o24.defaultPrevented = false;
// 28487
o24.detail = 0;
// 28488
o24.eventPhase = 3;
// 28489
o24.isTrusted = void 0;
// 28490
o24.metaKey = false;
// 28491
o24.pageX = 761;
// 28492
o24.pageY = 436;
// 28493
o24.relatedTarget = null;
// 28494
o24.fromElement = null;
// 28497
o24.shiftKey = false;
// 28500
o24.timeStamp = 1374851250920;
// 28501
o24.type = "mousemove";
// 28502
o24.view = ow81632121;
// undefined
o24 = null;
// 28511
f81632121_1852.returns.push(undefined);
// 28514
f81632121_14.returns.push(undefined);
// 28515
f81632121_12.returns.push(126);
// 28518
o24 = {};
// 28522
f81632121_467.returns.push(1374851250932);
// 28523
o24.cancelBubble = false;
// 28524
o24.returnValue = true;
// 28527
o24.srcElement = o26;
// 28529
o24.target = o26;
// 28536
f81632121_506.returns.push(null);
// 28542
f81632121_506.returns.push(null);
// 28548
f81632121_506.returns.push(null);
// 28554
f81632121_506.returns.push(null);
// 28560
f81632121_506.returns.push(null);
// 28566
f81632121_506.returns.push(null);
// 28572
f81632121_506.returns.push(null);
// 28578
f81632121_506.returns.push(null);
// 28584
f81632121_506.returns.push(null);
// 28590
f81632121_506.returns.push(null);
// 28596
f81632121_506.returns.push(null);
// 28602
f81632121_506.returns.push(null);
// 28608
f81632121_506.returns.push(null);
// 28614
f81632121_506.returns.push(null);
// 28620
f81632121_506.returns.push(null);
// 28626
f81632121_506.returns.push(null);
// 28632
f81632121_506.returns.push(null);
// 28637
o24.JSBNG__screenX = 831;
// 28638
o24.JSBNG__screenY = 602;
// 28639
o24.altKey = false;
// 28640
o24.bubbles = true;
// 28641
o24.button = 0;
// 28642
o24.buttons = void 0;
// 28643
o24.cancelable = false;
// 28644
o24.clientX = 763;
// 28645
o24.clientY = 437;
// 28646
o24.ctrlKey = false;
// 28647
o24.currentTarget = o0;
// 28648
o24.defaultPrevented = false;
// 28649
o24.detail = 0;
// 28650
o24.eventPhase = 3;
// 28651
o24.isTrusted = void 0;
// 28652
o24.metaKey = false;
// 28653
o24.pageX = 763;
// 28654
o24.pageY = 437;
// 28655
o24.relatedTarget = null;
// 28656
o24.fromElement = null;
// 28659
o24.shiftKey = false;
// 28662
o24.timeStamp = 1374851250932;
// 28663
o24.type = "mousemove";
// 28664
o24.view = ow81632121;
// undefined
o24 = null;
// 28673
f81632121_1852.returns.push(undefined);
// 28676
f81632121_14.returns.push(undefined);
// 28677
f81632121_12.returns.push(127);
// 28680
o24 = {};
// 28684
f81632121_467.returns.push(1374851250944);
// 28685
o24.cancelBubble = false;
// 28686
o24.returnValue = true;
// 28689
o24.srcElement = o26;
// 28691
o24.target = o26;
// 28698
f81632121_506.returns.push(null);
// 28704
f81632121_506.returns.push(null);
// 28710
f81632121_506.returns.push(null);
// 28716
f81632121_506.returns.push(null);
// 28722
f81632121_506.returns.push(null);
// 28728
f81632121_506.returns.push(null);
// 28734
f81632121_506.returns.push(null);
// 28740
f81632121_506.returns.push(null);
// 28746
f81632121_506.returns.push(null);
// 28752
f81632121_506.returns.push(null);
// 28758
f81632121_506.returns.push(null);
// 28764
f81632121_506.returns.push(null);
// 28770
f81632121_506.returns.push(null);
// 28776
f81632121_506.returns.push(null);
// 28782
f81632121_506.returns.push(null);
// 28788
f81632121_506.returns.push(null);
// 28794
f81632121_506.returns.push(null);
// 28799
o24.JSBNG__screenX = 834;
// 28800
o24.JSBNG__screenY = 603;
// 28801
o24.altKey = false;
// 28802
o24.bubbles = true;
// 28803
o24.button = 0;
// 28804
o24.buttons = void 0;
// 28805
o24.cancelable = false;
// 28806
o24.clientX = 766;
// 28807
o24.clientY = 438;
// 28808
o24.ctrlKey = false;
// 28809
o24.currentTarget = o0;
// 28810
o24.defaultPrevented = false;
// 28811
o24.detail = 0;
// 28812
o24.eventPhase = 3;
// 28813
o24.isTrusted = void 0;
// 28814
o24.metaKey = false;
// 28815
o24.pageX = 766;
// 28816
o24.pageY = 438;
// 28817
o24.relatedTarget = null;
// 28818
o24.fromElement = null;
// 28821
o24.shiftKey = false;
// 28824
o24.timeStamp = 1374851250944;
// 28825
o24.type = "mousemove";
// 28826
o24.view = ow81632121;
// undefined
o24 = null;
// 28835
f81632121_1852.returns.push(undefined);
// 28838
f81632121_14.returns.push(undefined);
// 28839
f81632121_12.returns.push(128);
// 28842
o24 = {};
// 28846
f81632121_467.returns.push(1374851250951);
// 28847
o24.cancelBubble = false;
// 28848
o24.returnValue = true;
// 28851
o24.srcElement = o26;
// 28853
o24.target = o26;
// 28860
f81632121_506.returns.push(null);
// 28866
f81632121_506.returns.push(null);
// 28872
f81632121_506.returns.push(null);
// 28878
f81632121_506.returns.push(null);
// 28884
f81632121_506.returns.push(null);
// 28890
f81632121_506.returns.push(null);
// 28896
f81632121_506.returns.push(null);
// 28902
f81632121_506.returns.push(null);
// 28908
f81632121_506.returns.push(null);
// 28914
f81632121_506.returns.push(null);
// 28920
f81632121_506.returns.push(null);
// 28926
f81632121_506.returns.push(null);
// 28932
f81632121_506.returns.push(null);
// 28938
f81632121_506.returns.push(null);
// 28944
f81632121_506.returns.push(null);
// 28950
f81632121_506.returns.push(null);
// 28956
f81632121_506.returns.push(null);
// 28961
o24.JSBNG__screenX = 836;
// 28962
o24.JSBNG__screenY = 604;
// 28963
o24.altKey = false;
// 28964
o24.bubbles = true;
// 28965
o24.button = 0;
// 28966
o24.buttons = void 0;
// 28967
o24.cancelable = false;
// 28968
o24.clientX = 768;
// 28969
o24.clientY = 439;
// 28970
o24.ctrlKey = false;
// 28971
o24.currentTarget = o0;
// 28972
o24.defaultPrevented = false;
// 28973
o24.detail = 0;
// 28974
o24.eventPhase = 3;
// 28975
o24.isTrusted = void 0;
// 28976
o24.metaKey = false;
// 28977
o24.pageX = 768;
// 28978
o24.pageY = 439;
// 28979
o24.relatedTarget = null;
// 28980
o24.fromElement = null;
// 28983
o24.shiftKey = false;
// 28986
o24.timeStamp = 1374851250951;
// 28987
o24.type = "mousemove";
// 28988
o24.view = ow81632121;
// undefined
o24 = null;
// 28997
f81632121_1852.returns.push(undefined);
// 29000
f81632121_14.returns.push(undefined);
// 29001
f81632121_12.returns.push(129);
// 29004
o24 = {};
// 29008
f81632121_467.returns.push(1374851250962);
// 29009
o24.cancelBubble = false;
// 29010
o24.returnValue = true;
// 29013
o24.srcElement = o26;
// 29015
o24.target = o26;
// 29022
f81632121_506.returns.push(null);
// 29028
f81632121_506.returns.push(null);
// 29034
f81632121_506.returns.push(null);
// 29040
f81632121_506.returns.push(null);
// 29046
f81632121_506.returns.push(null);
// 29052
f81632121_506.returns.push(null);
// 29058
f81632121_506.returns.push(null);
// 29064
f81632121_506.returns.push(null);
// 29070
f81632121_506.returns.push(null);
// 29076
f81632121_506.returns.push(null);
// 29082
f81632121_506.returns.push(null);
// 29088
f81632121_506.returns.push(null);
// 29094
f81632121_506.returns.push(null);
// 29100
f81632121_506.returns.push(null);
// 29106
f81632121_506.returns.push(null);
// 29112
f81632121_506.returns.push(null);
// 29118
f81632121_506.returns.push(null);
// 29123
o24.JSBNG__screenX = 837;
// 29124
o24.JSBNG__screenY = 605;
// 29125
o24.altKey = false;
// 29126
o24.bubbles = true;
// 29127
o24.button = 0;
// 29128
o24.buttons = void 0;
// 29129
o24.cancelable = false;
// 29130
o24.clientX = 769;
// 29131
o24.clientY = 440;
// 29132
o24.ctrlKey = false;
// 29133
o24.currentTarget = o0;
// 29134
o24.defaultPrevented = false;
// 29135
o24.detail = 0;
// 29136
o24.eventPhase = 3;
// 29137
o24.isTrusted = void 0;
// 29138
o24.metaKey = false;
// 29139
o24.pageX = 769;
// 29140
o24.pageY = 440;
// 29141
o24.relatedTarget = null;
// 29142
o24.fromElement = null;
// 29145
o24.shiftKey = false;
// 29148
o24.timeStamp = 1374851250962;
// 29149
o24.type = "mousemove";
// 29150
o24.view = ow81632121;
// undefined
o24 = null;
// 29159
f81632121_1852.returns.push(undefined);
// 29162
f81632121_14.returns.push(undefined);
// 29163
f81632121_12.returns.push(130);
// 29166
o24 = {};
// 29170
f81632121_467.returns.push(1374851250969);
// 29171
o24.cancelBubble = false;
// 29172
o24.returnValue = true;
// 29175
o24.srcElement = o26;
// 29177
o24.target = o26;
// 29184
f81632121_506.returns.push(null);
// 29190
f81632121_506.returns.push(null);
// 29196
f81632121_506.returns.push(null);
// 29202
f81632121_506.returns.push(null);
// 29208
f81632121_506.returns.push(null);
// 29214
f81632121_506.returns.push(null);
// 29220
f81632121_506.returns.push(null);
// 29226
f81632121_506.returns.push(null);
// 29232
f81632121_506.returns.push(null);
// 29238
f81632121_506.returns.push(null);
// 29244
f81632121_506.returns.push(null);
// 29250
f81632121_506.returns.push(null);
// 29256
f81632121_506.returns.push(null);
// 29262
f81632121_506.returns.push(null);
// 29268
f81632121_506.returns.push(null);
// 29274
f81632121_506.returns.push(null);
// 29280
f81632121_506.returns.push(null);
// 29285
o24.JSBNG__screenX = 840;
// 29286
o24.JSBNG__screenY = 606;
// 29287
o24.altKey = false;
// 29288
o24.bubbles = true;
// 29289
o24.button = 0;
// 29290
o24.buttons = void 0;
// 29291
o24.cancelable = false;
// 29292
o24.clientX = 772;
// 29293
o24.clientY = 441;
// 29294
o24.ctrlKey = false;
// 29295
o24.currentTarget = o0;
// 29296
o24.defaultPrevented = false;
// 29297
o24.detail = 0;
// 29298
o24.eventPhase = 3;
// 29299
o24.isTrusted = void 0;
// 29300
o24.metaKey = false;
// 29301
o24.pageX = 772;
// 29302
o24.pageY = 441;
// 29303
o24.relatedTarget = null;
// 29304
o24.fromElement = null;
// 29307
o24.shiftKey = false;
// 29310
o24.timeStamp = 1374851250968;
// 29311
o24.type = "mousemove";
// 29312
o24.view = ow81632121;
// undefined
o24 = null;
// 29321
f81632121_1852.returns.push(undefined);
// 29324
f81632121_14.returns.push(undefined);
// 29325
f81632121_12.returns.push(131);
// 29328
o24 = {};
// 29332
f81632121_467.returns.push(1374851250980);
// 29333
o24.cancelBubble = false;
// 29334
o24.returnValue = true;
// 29337
o24.srcElement = o26;
// 29339
o24.target = o26;
// 29346
f81632121_506.returns.push(null);
// 29352
f81632121_506.returns.push(null);
// 29358
f81632121_506.returns.push(null);
// 29364
f81632121_506.returns.push(null);
// 29370
f81632121_506.returns.push(null);
// 29376
f81632121_506.returns.push(null);
// 29382
f81632121_506.returns.push(null);
// 29388
f81632121_506.returns.push(null);
// 29394
f81632121_506.returns.push(null);
// 29400
f81632121_506.returns.push(null);
// 29406
f81632121_506.returns.push(null);
// 29412
f81632121_506.returns.push(null);
// 29418
f81632121_506.returns.push(null);
// 29424
f81632121_506.returns.push(null);
// 29430
f81632121_506.returns.push(null);
// 29436
f81632121_506.returns.push(null);
// 29442
f81632121_506.returns.push(null);
// 29447
o24.JSBNG__screenX = 841;
// 29448
o24.JSBNG__screenY = 606;
// 29449
o24.altKey = false;
// 29450
o24.bubbles = true;
// 29451
o24.button = 0;
// 29452
o24.buttons = void 0;
// 29453
o24.cancelable = false;
// 29454
o24.clientX = 773;
// 29455
o24.clientY = 441;
// 29456
o24.ctrlKey = false;
// 29457
o24.currentTarget = o0;
// 29458
o24.defaultPrevented = false;
// 29459
o24.detail = 0;
// 29460
o24.eventPhase = 3;
// 29461
o24.isTrusted = void 0;
// 29462
o24.metaKey = false;
// 29463
o24.pageX = 773;
// 29464
o24.pageY = 441;
// 29465
o24.relatedTarget = null;
// 29466
o24.fromElement = null;
// 29469
o24.shiftKey = false;
// 29472
o24.timeStamp = 1374851250979;
// 29473
o24.type = "mousemove";
// 29474
o24.view = ow81632121;
// undefined
o24 = null;
// 29483
f81632121_1852.returns.push(undefined);
// 29486
f81632121_14.returns.push(undefined);
// 29487
f81632121_12.returns.push(132);
// 29490
o24 = {};
// 29494
f81632121_467.returns.push(1374851250992);
// 29495
o24.cancelBubble = false;
// 29496
o24.returnValue = true;
// 29499
o24.srcElement = o26;
// 29501
o24.target = o26;
// 29508
f81632121_506.returns.push(null);
// 29514
f81632121_506.returns.push(null);
// 29520
f81632121_506.returns.push(null);
// 29526
f81632121_506.returns.push(null);
// 29532
f81632121_506.returns.push(null);
// 29538
f81632121_506.returns.push(null);
// 29544
f81632121_506.returns.push(null);
// 29550
f81632121_506.returns.push(null);
// 29556
f81632121_506.returns.push(null);
// 29562
f81632121_506.returns.push(null);
// 29568
f81632121_506.returns.push(null);
// 29574
f81632121_506.returns.push(null);
// 29580
f81632121_506.returns.push(null);
// 29586
f81632121_506.returns.push(null);
// 29592
f81632121_506.returns.push(null);
// 29598
f81632121_506.returns.push(null);
// 29604
f81632121_506.returns.push(null);
// 29609
o24.JSBNG__screenX = 843;
// 29610
o24.JSBNG__screenY = 606;
// 29611
o24.altKey = false;
// 29612
o24.bubbles = true;
// 29613
o24.button = 0;
// 29614
o24.buttons = void 0;
// 29615
o24.cancelable = false;
// 29616
o24.clientX = 775;
// 29617
o24.clientY = 441;
// 29618
o24.ctrlKey = false;
// 29619
o24.currentTarget = o0;
// 29620
o24.defaultPrevented = false;
// 29621
o24.detail = 0;
// 29622
o24.eventPhase = 3;
// 29623
o24.isTrusted = void 0;
// 29624
o24.metaKey = false;
// 29625
o24.pageX = 775;
// 29626
o24.pageY = 441;
// 29627
o24.relatedTarget = null;
// 29628
o24.fromElement = null;
// 29631
o24.shiftKey = false;
// 29634
o24.timeStamp = 1374851250992;
// 29635
o24.type = "mousemove";
// 29636
o24.view = ow81632121;
// undefined
o24 = null;
// 29645
f81632121_1852.returns.push(undefined);
// 29648
f81632121_14.returns.push(undefined);
// 29649
f81632121_12.returns.push(133);
// 29652
o24 = {};
// 29656
f81632121_467.returns.push(1374851251003);
// 29657
o24.cancelBubble = false;
// 29658
o24.returnValue = true;
// 29661
o24.srcElement = o26;
// 29663
o24.target = o26;
// 29670
f81632121_506.returns.push(null);
// 29676
f81632121_506.returns.push(null);
// 29682
f81632121_506.returns.push(null);
// 29688
f81632121_506.returns.push(null);
// 29694
f81632121_506.returns.push(null);
// 29700
f81632121_506.returns.push(null);
// 29706
f81632121_506.returns.push(null);
// 29712
f81632121_506.returns.push(null);
// 29718
f81632121_506.returns.push(null);
// 29724
f81632121_506.returns.push(null);
// 29730
f81632121_506.returns.push(null);
// 29736
f81632121_506.returns.push(null);
// 29742
f81632121_506.returns.push(null);
// 29748
f81632121_506.returns.push(null);
// 29754
f81632121_506.returns.push(null);
// 29760
f81632121_506.returns.push(null);
// 29766
f81632121_506.returns.push(null);
// 29771
o24.JSBNG__screenX = 844;
// 29772
o24.JSBNG__screenY = 606;
// 29773
o24.altKey = false;
// 29774
o24.bubbles = true;
// 29775
o24.button = 0;
// 29776
o24.buttons = void 0;
// 29777
o24.cancelable = false;
// 29778
o24.clientX = 776;
// 29779
o24.clientY = 441;
// 29780
o24.ctrlKey = false;
// 29781
o24.currentTarget = o0;
// 29782
o24.defaultPrevented = false;
// 29783
o24.detail = 0;
// 29784
o24.eventPhase = 3;
// 29785
o24.isTrusted = void 0;
// 29786
o24.metaKey = false;
// 29787
o24.pageX = 776;
// 29788
o24.pageY = 441;
// 29789
o24.relatedTarget = null;
// 29790
o24.fromElement = null;
// 29793
o24.shiftKey = false;
// 29796
o24.timeStamp = 1374851251002;
// 29797
o24.type = "mousemove";
// 29798
o24.view = ow81632121;
// undefined
o24 = null;
// 29807
f81632121_1852.returns.push(undefined);
// 29810
f81632121_14.returns.push(undefined);
// 29811
f81632121_12.returns.push(134);
// 29814
o24 = {};
// 29818
f81632121_467.returns.push(1374851251015);
// 29819
o24.cancelBubble = false;
// 29820
o24.returnValue = true;
// 29823
o24.srcElement = o26;
// 29825
o24.target = o26;
// 29832
f81632121_506.returns.push(null);
// 29838
f81632121_506.returns.push(null);
// 29844
f81632121_506.returns.push(null);
// 29850
f81632121_506.returns.push(null);
// 29856
f81632121_506.returns.push(null);
// 29862
f81632121_506.returns.push(null);
// 29868
f81632121_506.returns.push(null);
// 29874
f81632121_506.returns.push(null);
// 29880
f81632121_506.returns.push(null);
// 29886
f81632121_506.returns.push(null);
// 29892
f81632121_506.returns.push(null);
// 29898
f81632121_506.returns.push(null);
// 29904
f81632121_506.returns.push(null);
// 29910
f81632121_506.returns.push(null);
// 29916
f81632121_506.returns.push(null);
// 29922
f81632121_506.returns.push(null);
// 29928
f81632121_506.returns.push(null);
// 29933
o24.JSBNG__screenX = 845;
// 29934
o24.JSBNG__screenY = 606;
// 29935
o24.altKey = false;
// 29936
o24.bubbles = true;
// 29937
o24.button = 0;
// 29938
o24.buttons = void 0;
// 29939
o24.cancelable = false;
// 29940
o24.clientX = 777;
// 29941
o24.clientY = 441;
// 29942
o24.ctrlKey = false;
// 29943
o24.currentTarget = o0;
// 29944
o24.defaultPrevented = false;
// 29945
o24.detail = 0;
// 29946
o24.eventPhase = 3;
// 29947
o24.isTrusted = void 0;
// 29948
o24.metaKey = false;
// 29949
o24.pageX = 777;
// 29950
o24.pageY = 441;
// 29951
o24.relatedTarget = null;
// 29952
o24.fromElement = null;
// 29955
o24.shiftKey = false;
// 29958
o24.timeStamp = 1374851251015;
// 29959
o24.type = "mousemove";
// 29960
o24.view = ow81632121;
// undefined
o24 = null;
// 29969
f81632121_1852.returns.push(undefined);
// 29972
f81632121_14.returns.push(undefined);
// 29973
f81632121_12.returns.push(135);
// 29976
o24 = {};
// 29980
f81632121_467.returns.push(1374851251029);
// 29981
o24.cancelBubble = false;
// 29982
o24.returnValue = true;
// 29985
o24.srcElement = o26;
// 29987
o24.target = o26;
// 29994
f81632121_506.returns.push(null);
// 30000
f81632121_506.returns.push(null);
// 30006
f81632121_506.returns.push(null);
// 30012
f81632121_506.returns.push(null);
// 30018
f81632121_506.returns.push(null);
// 30024
f81632121_506.returns.push(null);
// 30030
f81632121_506.returns.push(null);
// 30036
f81632121_506.returns.push(null);
// 30042
f81632121_506.returns.push(null);
// 30048
f81632121_506.returns.push(null);
// 30054
f81632121_506.returns.push(null);
// 30060
f81632121_506.returns.push(null);
// 30066
f81632121_506.returns.push(null);
// 30072
f81632121_506.returns.push(null);
// 30078
f81632121_506.returns.push(null);
// 30084
f81632121_506.returns.push(null);
// 30090
f81632121_506.returns.push(null);
// 30095
o24.JSBNG__screenX = 846;
// 30096
o24.JSBNG__screenY = 606;
// 30097
o24.altKey = false;
// 30098
o24.bubbles = true;
// 30099
o24.button = 0;
// 30100
o24.buttons = void 0;
// 30101
o24.cancelable = false;
// 30102
o24.clientX = 778;
// 30103
o24.clientY = 441;
// 30104
o24.ctrlKey = false;
// 30105
o24.currentTarget = o0;
// 30106
o24.defaultPrevented = false;
// 30107
o24.detail = 0;
// 30108
o24.eventPhase = 3;
// 30109
o24.isTrusted = void 0;
// 30110
o24.metaKey = false;
// 30111
o24.pageX = 778;
// 30112
o24.pageY = 441;
// 30113
o24.relatedTarget = null;
// 30114
o24.fromElement = null;
// 30117
o24.shiftKey = false;
// 30120
o24.timeStamp = 1374851251029;
// 30121
o24.type = "mousemove";
// 30122
o24.view = ow81632121;
// undefined
o24 = null;
// 30131
f81632121_1852.returns.push(undefined);
// 30134
f81632121_14.returns.push(undefined);
// 30135
f81632121_12.returns.push(136);
// undefined
fo81632121_1_cookie.returns.push("c_user=100006118350059; csm=2; sub=4096; wd=1034x727");
// 30141
f81632121_467.returns.push(1374851251040);
// 30142
o24 = {};
// 30146
f81632121_467.returns.push(1374851251047);
// 30147
o24.cancelBubble = false;
// 30148
o24.returnValue = true;
// 30151
o24.srcElement = o26;
// 30153
o24.target = o26;
// 30160
f81632121_506.returns.push(null);
// 30166
f81632121_506.returns.push(null);
// 30172
f81632121_506.returns.push(null);
// 30178
f81632121_506.returns.push(null);
// 30184
f81632121_506.returns.push(null);
// 30190
f81632121_506.returns.push(null);
// 30196
f81632121_506.returns.push(null);
// 30202
f81632121_506.returns.push(null);
// 30208
f81632121_506.returns.push(null);
// 30214
f81632121_506.returns.push(null);
// 30220
f81632121_506.returns.push(null);
// 30226
f81632121_506.returns.push(null);
// 30232
f81632121_506.returns.push(null);
// 30238
f81632121_506.returns.push(null);
// 30244
f81632121_506.returns.push(null);
// 30250
f81632121_506.returns.push(null);
// 30256
f81632121_506.returns.push(null);
// 30261
o24.JSBNG__screenX = 847;
// 30262
o24.JSBNG__screenY = 606;
// 30263
o24.altKey = false;
// 30264
o24.bubbles = true;
// 30265
o24.button = 0;
// 30266
o24.buttons = void 0;
// 30267
o24.cancelable = false;
// 30268
o24.clientX = 779;
// 30269
o24.clientY = 441;
// 30270
o24.ctrlKey = false;
// 30271
o24.currentTarget = o0;
// 30272
o24.defaultPrevented = false;
// 30273
o24.detail = 0;
// 30274
o24.eventPhase = 3;
// 30275
o24.isTrusted = void 0;
// 30276
o24.metaKey = false;
// 30277
o24.pageX = 779;
// 30278
o24.pageY = 441;
// 30279
o24.relatedTarget = null;
// 30280
o24.fromElement = null;
// 30283
o24.shiftKey = false;
// 30286
o24.timeStamp = 1374851251046;
// 30287
o24.type = "mousemove";
// 30288
o24.view = ow81632121;
// undefined
o24 = null;
// 30297
f81632121_1852.returns.push(undefined);
// 30300
f81632121_14.returns.push(undefined);
// 30301
f81632121_12.returns.push(137);
// 30304
o24 = {};
// 30308
f81632121_467.returns.push(1374851251062);
// 30309
o24.cancelBubble = false;
// 30310
o24.returnValue = true;
// 30313
o24.srcElement = o26;
// 30315
o24.target = o26;
// 30322
f81632121_506.returns.push(null);
// 30328
f81632121_506.returns.push(null);
// 30334
f81632121_506.returns.push(null);
// 30340
f81632121_506.returns.push(null);
// 30346
f81632121_506.returns.push(null);
// 30352
f81632121_506.returns.push(null);
// 30358
f81632121_506.returns.push(null);
// 30364
f81632121_506.returns.push(null);
// 30370
f81632121_506.returns.push(null);
// 30376
f81632121_506.returns.push(null);
// 30382
f81632121_506.returns.push(null);
// 30388
f81632121_506.returns.push(null);
// 30394
f81632121_506.returns.push(null);
// 30400
f81632121_506.returns.push(null);
// 30406
f81632121_506.returns.push(null);
// 30412
f81632121_506.returns.push(null);
// 30418
f81632121_506.returns.push(null);
// 30423
o24.JSBNG__screenX = 848;
// 30424
o24.JSBNG__screenY = 606;
// 30425
o24.altKey = false;
// 30426
o24.bubbles = true;
// 30427
o24.button = 0;
// 30428
o24.buttons = void 0;
// 30429
o24.cancelable = false;
// 30430
o24.clientX = 780;
// 30431
o24.clientY = 441;
// 30432
o24.ctrlKey = false;
// 30433
o24.currentTarget = o0;
// 30434
o24.defaultPrevented = false;
// 30435
o24.detail = 0;
// 30436
o24.eventPhase = 3;
// 30437
o24.isTrusted = void 0;
// 30438
o24.metaKey = false;
// 30439
o24.pageX = 780;
// 30440
o24.pageY = 441;
// 30441
o24.relatedTarget = null;
// 30442
o24.fromElement = null;
// 30445
o24.shiftKey = false;
// 30448
o24.timeStamp = 1374851251062;
// 30449
o24.type = "mousemove";
// 30450
o24.view = ow81632121;
// undefined
o24 = null;
// 30459
f81632121_1852.returns.push(undefined);
// 30462
f81632121_14.returns.push(undefined);
// 30463
f81632121_12.returns.push(138);
// 30466
o24 = {};
// 30470
f81632121_467.returns.push(1374851251079);
// 30471
o24.cancelBubble = false;
// 30472
o24.returnValue = true;
// 30475
o24.srcElement = o26;
// 30477
o24.target = o26;
// 30484
f81632121_506.returns.push(null);
// 30490
f81632121_506.returns.push(null);
// 30496
f81632121_506.returns.push(null);
// 30502
f81632121_506.returns.push(null);
// 30508
f81632121_506.returns.push(null);
// 30514
f81632121_506.returns.push(null);
// 30520
f81632121_506.returns.push(null);
// 30526
f81632121_506.returns.push(null);
// 30532
f81632121_506.returns.push(null);
// 30538
f81632121_506.returns.push(null);
// 30544
f81632121_506.returns.push(null);
// 30550
f81632121_506.returns.push(null);
// 30556
f81632121_506.returns.push(null);
// 30562
f81632121_506.returns.push(null);
// 30568
f81632121_506.returns.push(null);
// 30574
f81632121_506.returns.push(null);
// 30580
f81632121_506.returns.push(null);
// 30585
o24.JSBNG__screenX = 849;
// 30586
o24.JSBNG__screenY = 606;
// 30587
o24.altKey = false;
// 30588
o24.bubbles = true;
// 30589
o24.button = 0;
// 30590
o24.buttons = void 0;
// 30591
o24.cancelable = false;
// 30592
o24.clientX = 781;
// 30593
o24.clientY = 441;
// 30594
o24.ctrlKey = false;
// 30595
o24.currentTarget = o0;
// 30596
o24.defaultPrevented = false;
// 30597
o24.detail = 0;
// 30598
o24.eventPhase = 3;
// 30599
o24.isTrusted = void 0;
// 30600
o24.metaKey = false;
// 30601
o24.pageX = 781;
// 30602
o24.pageY = 441;
// 30603
o24.relatedTarget = null;
// 30604
o24.fromElement = null;
// 30607
o24.shiftKey = false;
// 30610
o24.timeStamp = 1374851251079;
// 30611
o24.type = "mousemove";
// 30612
o24.view = ow81632121;
// undefined
o24 = null;
// 30621
f81632121_1852.returns.push(undefined);
// 30624
f81632121_14.returns.push(undefined);
// 30625
f81632121_12.returns.push(139);
// 30628
o24 = {};
// 30632
f81632121_467.returns.push(1374851251088);
// 30637
f81632121_467.returns.push(1374851251089);
// 30641
f81632121_467.returns.push(1374851251089);
// 30643
o24.cancelBubble = false;
// 30644
o24.returnValue = true;
// 30647
o24.srcElement = o26;
// 30649
o24.target = o26;
// 30656
f81632121_506.returns.push(null);
// 30662
f81632121_506.returns.push(null);
// 30668
f81632121_506.returns.push(null);
// 30674
f81632121_506.returns.push(null);
// 30680
f81632121_506.returns.push(null);
// 30686
f81632121_506.returns.push(null);
// 30692
f81632121_506.returns.push(null);
// 30698
f81632121_506.returns.push(null);
// 30704
f81632121_506.returns.push(null);
// 30710
f81632121_506.returns.push(null);
// 30716
f81632121_506.returns.push(null);
// 30722
f81632121_506.returns.push(null);
// 30728
f81632121_506.returns.push(null);
// 30734
f81632121_506.returns.push(null);
// 30740
f81632121_506.returns.push(null);
// 30746
f81632121_506.returns.push(null);
// 30752
f81632121_506.returns.push(null);
// 30757
o24.JSBNG__screenX = 850;
// 30758
o24.JSBNG__screenY = 606;
// 30759
o24.altKey = false;
// 30760
o24.bubbles = true;
// 30761
o24.button = 0;
// 30762
o24.buttons = void 0;
// 30763
o24.cancelable = false;
// 30764
o24.clientX = 782;
// 30765
o24.clientY = 441;
// 30766
o24.ctrlKey = false;
// 30767
o24.currentTarget = o0;
// 30768
o24.defaultPrevented = false;
// 30769
o24.detail = 0;
// 30770
o24.eventPhase = 3;
// 30771
o24.isTrusted = void 0;
// 30772
o24.metaKey = false;
// 30773
o24.pageX = 782;
// 30774
o24.pageY = 441;
// 30775
o24.relatedTarget = null;
// 30776
o24.fromElement = null;
// 30779
o24.shiftKey = false;
// 30782
o24.timeStamp = 1374851251088;
// 30783
o24.type = "mousemove";
// 30784
o24.view = ow81632121;
// undefined
o24 = null;
// 30793
f81632121_1852.returns.push(undefined);
// 30796
f81632121_14.returns.push(undefined);
// 30797
f81632121_12.returns.push(140);
// 30800
o24 = {};
// 30804
f81632121_467.returns.push(1374851251135);
// 30805
o24.cancelBubble = false;
// 30806
o24.returnValue = true;
// 30809
o24.srcElement = o26;
// 30811
o24.target = o26;
// 30818
f81632121_506.returns.push(null);
// 30824
f81632121_506.returns.push(null);
// 30830
f81632121_506.returns.push(null);
// 30836
f81632121_506.returns.push(null);
// 30842
f81632121_506.returns.push(null);
// 30848
f81632121_506.returns.push(null);
// 30854
f81632121_506.returns.push(null);
// 30860
f81632121_506.returns.push(null);
// 30866
f81632121_506.returns.push(null);
// 30872
f81632121_506.returns.push(null);
// 30878
f81632121_506.returns.push(null);
// 30884
f81632121_506.returns.push(null);
// 30890
f81632121_506.returns.push(null);
// 30896
f81632121_506.returns.push(null);
// 30902
f81632121_506.returns.push(null);
// 30908
f81632121_506.returns.push(null);
// 30914
f81632121_506.returns.push(null);
// 30919
o24.JSBNG__screenX = 850;
// 30920
o24.JSBNG__screenY = 606;
// 30921
o24.altKey = false;
// 30922
o24.bubbles = true;
// 30923
o24.button = 0;
// 30924
o24.buttons = void 0;
// 30925
o24.cancelable = false;
// 30926
o24.clientX = 782;
// 30927
o24.clientY = 441;
// 30928
o24.ctrlKey = false;
// 30929
o24.currentTarget = o0;
// 30930
o24.defaultPrevented = false;
// 30931
o24.detail = 0;
// 30932
o24.eventPhase = 3;
// 30933
o24.isTrusted = void 0;
// 30934
o24.metaKey = false;
// 30935
o24.pageX = 782;
// 30936
o24.pageY = 441;
// 30937
o24.relatedTarget = null;
// 30938
o24.fromElement = null;
// 30941
o24.shiftKey = false;
// 30944
o24.timeStamp = 1374851251134;
// 30945
o24.type = "mousemove";
// 30946
o24.view = ow81632121;
// undefined
o24 = null;
// 30955
f81632121_1852.returns.push(undefined);
// 30958
f81632121_14.returns.push(undefined);
// 30959
f81632121_12.returns.push(141);
// undefined
fo81632121_1_cookie.returns.push("c_user=100006118350059; csm=2; sub=4096; wd=1034x727");
// undefined
fo81632121_1_cookie.returns.push("c_user=100006118350059; csm=2; sub=4096; wd=1034x727");
// 30964
o24 = {};
// 30967
o24.cancelBubble = false;
// 30970
f81632121_467.returns.push(1374851251713);
// 30975
f81632121_467.returns.push(1374851251725);
// 30979
f81632121_467.returns.push(1374851251725);
// 30982
o24.returnValue = true;
// undefined
o24 = null;
// 30983
o24 = {};
// 30986
o24.cancelBubble = false;
// 30989
f81632121_467.returns.push(1374851251755);
// 30991
o24.returnValue = true;
// undefined
o24 = null;
// 30992
o24 = {};
// 30995
o24.cancelBubble = false;
// 30998
f81632121_467.returns.push(1374851251787);
// 31000
o24.returnValue = true;
// undefined
o24 = null;
// 31001
o24 = {};
// 31004
o24.cancelBubble = false;
// 31007
f81632121_467.returns.push(1374851251809);
// 31009
o24.returnValue = true;
// undefined
o24 = null;
// 31010
o24 = {};
// 31013
o24.cancelBubble = false;
// 31016
f81632121_467.returns.push(1374851251825);
// 31018
o24.returnValue = true;
// undefined
o24 = null;
// 31019
o24 = {};
// 31022
o24.cancelBubble = false;
// 31025
f81632121_467.returns.push(1374851251843);
// 31027
o24.returnValue = true;
// undefined
o24 = null;
// 31028
o24 = {};
// 31031
o24.cancelBubble = false;
// 31034
f81632121_467.returns.push(1374851251859);
// 31036
o24.returnValue = true;
// undefined
o24 = null;
// 31037
o24 = {};
// 31040
o24.cancelBubble = false;
// 31043
f81632121_467.returns.push(1374851251875);
// 31045
o24.returnValue = true;
// undefined
o24 = null;
// 31047
f81632121_12.returns.push(142);
// 31049
o24 = {};
// 31052
o24.cancelBubble = false;
// 31055
f81632121_467.returns.push(1374851251892);
// 31057
o24.returnValue = true;
// undefined
o24 = null;
// 31058
o24 = {};
// 31061
o24.cancelBubble = false;
// 31064
f81632121_467.returns.push(1374851251910);
// 31066
o24.returnValue = true;
// undefined
o24 = null;
// 31067
o24 = {};
// 31070
o24.cancelBubble = false;
// 31073
f81632121_467.returns.push(1374851251927);
// 31075
o24.returnValue = true;
// undefined
o24 = null;
// 31076
o24 = {};
// 31079
o24.cancelBubble = false;
// 31082
f81632121_467.returns.push(1374851251942);
// 31084
o24.returnValue = true;
// undefined
o24 = null;
// 31085
o24 = {};
// 31088
o24.cancelBubble = false;
// 31091
f81632121_467.returns.push(1374851251961);
// 31093
o24.returnValue = true;
// undefined
o24 = null;
// 31094
o24 = {};
// 31097
o24.cancelBubble = false;
// 31100
f81632121_467.returns.push(1374851251975);
// 31102
o24.returnValue = true;
// undefined
o24 = null;
// 31103
o24 = {};
// 31106
o24.cancelBubble = false;
// 31109
f81632121_467.returns.push(1374851251993);
// 31111
o24.returnValue = true;
// undefined
o24 = null;
// 31112
o24 = {};
// 31115
o24.cancelBubble = false;
// 31118
f81632121_467.returns.push(1374851252008);
// 31120
o24.returnValue = true;
// undefined
o24 = null;
// 31121
o24 = {};
// 31124
o24.cancelBubble = false;
// 31127
f81632121_467.returns.push(1374851252024);
// 31129
o24.returnValue = true;
// undefined
o24 = null;
// 31130
o24 = {};
// 31133
o24.cancelBubble = false;
// 31136
f81632121_467.returns.push(1374851252040);
// 31138
o24.returnValue = true;
// undefined
o24 = null;
// undefined
fo81632121_1_cookie.returns.push("c_user=100006118350059; csm=2; sub=4096; wd=1034x727");
// 31142
f81632121_467.returns.push(1374851252041);
// 31143
o24 = {};
// 31146
o24.cancelBubble = false;
// 31149
f81632121_467.returns.push(1374851252048);
// 31151
o24.returnValue = true;
// undefined
o24 = null;
// 31152
o24 = {};
// 31155
o24.cancelBubble = false;
// 31158
f81632121_467.returns.push(1374851252063);
// 31160
o24.returnValue = true;
// undefined
o24 = null;
// 31161
o24 = {};
// 31164
o24.cancelBubble = false;
// 31167
f81632121_467.returns.push(1374851252071);
// 31169
o24.returnValue = true;
// undefined
o24 = null;
// 31170
o24 = {};
// 31173
o24.cancelBubble = false;
// 31176
f81632121_467.returns.push(1374851252090);
// 31178
o24.returnValue = true;
// undefined
o24 = null;
// 31179
o24 = {};
// 31182
o24.cancelBubble = false;
// 31185
f81632121_467.returns.push(1374851252104);
// 31187
o24.returnValue = true;
// undefined
o24 = null;
// 31188
o24 = {};
// 31191
o24.cancelBubble = false;
// 31194
f81632121_467.returns.push(1374851252112);
// 31196
o24.returnValue = true;
// undefined
o24 = null;
// undefined
fo81632121_1_cookie.returns.push("c_user=100006118350059; csm=2; sub=4096; wd=1034x727");
// 31198
o24 = {};
// 31201
o24.srcElement = o26;
// 31203
o24.target = o26;
// 31210
f81632121_506.returns.push(null);
// 31216
f81632121_506.returns.push(null);
// 31222
f81632121_506.returns.push(null);
// 31228
f81632121_506.returns.push(null);
// 31234
f81632121_506.returns.push(null);
// 31240
f81632121_506.returns.push(null);
// 31246
f81632121_506.returns.push(null);
// 31252
f81632121_506.returns.push(null);
// 31258
f81632121_506.returns.push(null);
// 31264
f81632121_506.returns.push(null);
// 31270
f81632121_506.returns.push(null);
// 31276
f81632121_506.returns.push(null);
// 31282
f81632121_506.returns.push(null);
// 31288
f81632121_506.returns.push(null);
// 31294
f81632121_506.returns.push(null);
// 31300
f81632121_506.returns.push(null);
// 31306
f81632121_506.returns.push(null);
// 31311
o24.relatedTarget = o52;
// 31312
o52.parentNode = o54;
// undefined
o54 = null;
// 31313
o52.nodeType = 1;
// 31316
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4947623}.[0].[right].[0].[left].[0].[0]");
// 31319
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4947623}.[0].[right].[0].[left].[0].[0]");
// 31320
o24.JSBNG__screenX = 850;
// 31321
o24.JSBNG__screenY = 606;
// 31322
o24.altKey = false;
// 31323
o24.bubbles = true;
// 31324
o24.button = 0;
// 31325
o24.buttons = void 0;
// 31326
o24.cancelable = true;
// 31327
o24.clientX = 782;
// 31328
o24.clientY = 441;
// 31329
o24.ctrlKey = false;
// 31330
o24.currentTarget = o0;
// 31331
o24.defaultPrevented = false;
// 31332
o24.detail = 0;
// 31333
o24.eventPhase = 3;
// 31334
o24.isTrusted = void 0;
// 31335
o24.metaKey = false;
// 31336
o24.pageX = 782;
// 31337
o24.pageY = 2827;
// 31339
o24.shiftKey = false;
// 31342
o24.timeStamp = 1374851252265;
// 31343
o24.type = "mouseout";
// 31344
o24.view = ow81632121;
// 31346
o24.returnValue = true;
// 31378
o24.cancelBubble = false;
// undefined
o24 = null;
// 31380
o24 = {};
// 31383
o24.cancelBubble = false;
// 31386
f81632121_467.returns.push(1374851252298);
// 31391
f81632121_467.returns.push(1374851252299);
// 31395
f81632121_467.returns.push(1374851252299);
// 31399
f81632121_1007.returns.push(undefined);
// 31401
o24.returnValue = true;
// 31404
o24.srcElement = o52;
// 31406
o24.target = o52;
// 31413
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4947623}.[0].[right].[0].[left].[0].[0]");
// 31416
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4947623}.[0].[right].[0].[left].[0].[0]");
// 31417
o24.relatedTarget = o26;
// undefined
o24 = null;
// undefined
o26 = null;
// 31418
o52.nodeName = "DIV";
// 31425
o24 = {};
// 31429
f81632121_467.returns.push(1374851252302);
// 31430
o24.cancelBubble = false;
// 31431
o24.returnValue = true;
// 31434
o24.srcElement = o52;
// 31436
o24.target = o52;
// 31443
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4947623}.[0].[right].[0].[left].[0].[0]");
// 31446
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4947623}.[0].[right].[0].[left].[0].[0]");
// 31447
o24.JSBNG__screenX = 850;
// 31448
o24.JSBNG__screenY = 606;
// 31449
o24.altKey = false;
// 31450
o24.bubbles = true;
// 31451
o24.button = 0;
// 31452
o24.buttons = void 0;
// 31453
o24.cancelable = false;
// 31454
o24.clientX = 782;
// 31455
o24.clientY = 441;
// 31456
o24.ctrlKey = false;
// 31457
o24.currentTarget = o0;
// 31458
o24.defaultPrevented = false;
// 31459
o24.detail = 0;
// 31460
o24.eventPhase = 3;
// 31461
o24.isTrusted = void 0;
// 31462
o24.metaKey = false;
// 31463
o24.pageX = 782;
// 31464
o24.pageY = 2827;
// 31465
o24.relatedTarget = null;
// 31466
o24.fromElement = null;
// 31469
o24.shiftKey = false;
// 31472
o24.timeStamp = 1374851252301;
// 31473
o24.type = "mousemove";
// 31474
o24.view = ow81632121;
// undefined
o24 = null;
// 31488
f81632121_1852.returns.push(undefined);
// 31491
f81632121_14.returns.push(undefined);
// 31492
f81632121_12.returns.push(143);
// 31495
o24 = {};
// 31498
o24.cancelBubble = false;
// 31501
f81632121_467.returns.push(1374851252457);
// 31503
o24.returnValue = true;
// undefined
o24 = null;
// 31504
o24 = {};
// 31507
o24.cancelBubble = false;
// 31510
f81632121_467.returns.push(1374851252473);
// 31512
o24.returnValue = true;
// undefined
o24 = null;
// 31513
o24 = {};
// 31516
o24.cancelBubble = false;
// 31519
f81632121_467.returns.push(1374851252489);
// 31521
o24.returnValue = true;
// undefined
o24 = null;
// 31522
o24 = {};
// 31525
o24.cancelBubble = false;
// 31528
f81632121_467.returns.push(1374851252505);
// 31530
o24.returnValue = true;
// undefined
o24 = null;
// 31531
o24 = {};
// 31534
o24.cancelBubble = false;
// 31537
f81632121_467.returns.push(1374851252521);
// 31539
o24.returnValue = true;
// undefined
o24 = null;
// 31540
o24 = {};
// 31543
o24.cancelBubble = false;
// 31546
f81632121_467.returns.push(1374851252529);
// 31548
o24.returnValue = true;
// undefined
o24 = null;
// 31549
o24 = {};
// 31552
o24.cancelBubble = false;
// 31555
f81632121_467.returns.push(1374851252545);
// 31557
o24.returnValue = true;
// undefined
o24 = null;
// 31558
o24 = {};
// 31561
o24.cancelBubble = false;
// 31564
f81632121_467.returns.push(1374851252552);
// 31566
o24.returnValue = true;
// undefined
o24 = null;
// 31567
o24 = {};
// 31570
o24.cancelBubble = false;
// 31573
f81632121_467.returns.push(1374851252569);
// 31575
o24.returnValue = true;
// undefined
o24 = null;
// 31576
o24 = {};
// 31579
o24.cancelBubble = false;
// 31582
f81632121_467.returns.push(1374851252577);
// 31584
o24.returnValue = true;
// undefined
o24 = null;
// 31585
o24 = {};
// 31588
o24.cancelBubble = false;
// 31591
f81632121_467.returns.push(1374851252603);
// 31593
o24.returnValue = true;
// undefined
o24 = null;
// 31594
o24 = {};
// 31597
o24.cancelBubble = false;
// 31600
f81632121_467.returns.push(1374851252605);
// 31602
o24.returnValue = true;
// undefined
o24 = null;
// 31603
o24 = {};
// 31606
o24.cancelBubble = false;
// 31609
f81632121_467.returns.push(1374851252616);
// 31611
o24.returnValue = true;
// undefined
o24 = null;
// 31612
o24 = {};
// 31615
o24.cancelBubble = false;
// 31618
f81632121_467.returns.push(1374851252625);
// 31620
o24.returnValue = true;
// undefined
o24 = null;
// 31621
o24 = {};
// 31624
o24.cancelBubble = false;
// 31627
f81632121_467.returns.push(1374851252641);
// 31629
o24.returnValue = true;
// undefined
o24 = null;
// 31630
o24 = {};
// 31633
o24.cancelBubble = false;
// 31636
f81632121_467.returns.push(1374851252657);
// 31638
o24.returnValue = true;
// undefined
o24 = null;
// 31639
o24 = {};
// 31642
o24.cancelBubble = false;
// 31645
f81632121_467.returns.push(1374851252664);
// 31647
o24.returnValue = true;
// undefined
o24 = null;
// undefined
fo81632121_1_cookie.returns.push("c_user=100006118350059; csm=2; sub=4096; wd=1034x727");
// 31649
o24 = {};
// 31652
o24.cancelBubble = false;
// 31655
f81632121_467.returns.push(1374851252681);
// 31657
o24.returnValue = true;
// undefined
o24 = null;
// 31658
o24 = {};
// 31661
o24.cancelBubble = false;
// 31664
f81632121_467.returns.push(1374851252696);
// 31666
o24.returnValue = true;
// undefined
o24 = null;
// 31667
o24 = {};
// 31670
o24.cancelBubble = false;
// 31673
f81632121_467.returns.push(1374851252712);
// 31675
o24.returnValue = true;
// undefined
o24 = null;
// 31676
o24 = {};
// 31679
o24.cancelBubble = false;
// 31682
f81632121_467.returns.push(1374851252720);
// 31684
o24.returnValue = true;
// undefined
o24 = null;
// 31685
o24 = {};
// 31688
o24.cancelBubble = false;
// 31691
f81632121_467.returns.push(1374851252743);
// 31693
o24.returnValue = true;
// undefined
o24 = null;
// 31694
o24 = {};
// 31697
o24.cancelBubble = false;
// 31700
f81632121_467.returns.push(1374851252746);
// 31702
o24.returnValue = true;
// undefined
o24 = null;
// 31704
f81632121_12.returns.push(144);
// undefined
fo81632121_1_cookie.returns.push("c_user=100006118350059; csm=2; sub=4096; wd=1034x727");
// 31709
f81632121_467.returns.push(1374851253061);
// undefined
fo81632121_1_cookie.returns.push("c_user=100006118350059; csm=2; sub=4096; wd=1034x727");
// undefined
fo81632121_1_cookie.returns.push("c_user=100006118350059; csm=2; sub=4096; wd=1034x727");
// undefined
fo81632121_1_cookie.returns.push("c_user=100006118350059; csm=2; sub=4096; wd=1034x727");
// 31714
f81632121_467.returns.push(1374851253895);
// 31716
f81632121_467.returns.push(1374851253895);
// 31718
f81632121_467.returns.push(1374851253895);
// 31720
f81632121_12.returns.push(145);
// 31723
f81632121_467.returns.push(1374851254022);
// undefined
fo81632121_1_cookie.returns.push("c_user=100006118350059; csm=2; sub=4096; wd=1034x727");
// 31727
f81632121_467.returns.push(1374851254062);
// 31728
o24 = {};
// 31732
f81632121_467.returns.push(1374851254134);
// 31737
f81632121_467.returns.push(1374851254136);
// 31741
f81632121_467.returns.push(1374851254136);
// 31743
o24.cancelBubble = false;
// 31744
o24.returnValue = true;
// 31747
o24.srcElement = o52;
// 31749
o24.target = o52;
// 31756
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4947623}.[0].[right].[0].[left].[0].[0]");
// 31759
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4947623}.[0].[right].[0].[left].[0].[0]");
// 31760
o24.JSBNG__screenX = 851;
// 31761
o24.JSBNG__screenY = 606;
// 31762
o24.altKey = false;
// 31763
o24.bubbles = true;
// 31764
o24.button = 0;
// 31765
o24.buttons = void 0;
// 31766
o24.cancelable = false;
// 31767
o24.clientX = 783;
// 31768
o24.clientY = 441;
// 31769
o24.ctrlKey = false;
// 31770
o24.currentTarget = o0;
// 31771
o24.defaultPrevented = false;
// 31772
o24.detail = 0;
// 31773
o24.eventPhase = 3;
// 31774
o24.isTrusted = void 0;
// 31775
o24.metaKey = false;
// 31776
o24.pageX = 783;
// 31777
o24.pageY = 2827;
// 31778
o24.relatedTarget = null;
// 31779
o24.fromElement = null;
// 31782
o24.shiftKey = false;
// 31785
o24.timeStamp = 1374851254134;
// 31786
o24.type = "mousemove";
// 31787
o24.view = ow81632121;
// undefined
o24 = null;
// 31801
f81632121_1852.returns.push(undefined);
// 31804
f81632121_14.returns.push(undefined);
// 31805
f81632121_12.returns.push(146);
// 31808
o24 = {};
// 31812
f81632121_467.returns.push(1374851254153);
// 31813
o24.cancelBubble = false;
// 31814
o24.returnValue = true;
// 31817
o24.srcElement = o52;
// 31819
o24.target = o52;
// 31826
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4947623}.[0].[right].[0].[left].[0].[0]");
// 31829
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4947623}.[0].[right].[0].[left].[0].[0]");
// 31830
o24.JSBNG__screenX = 874;
// 31831
o24.JSBNG__screenY = 599;
// 31832
o24.altKey = false;
// 31833
o24.bubbles = true;
// 31834
o24.button = 0;
// 31835
o24.buttons = void 0;
// 31836
o24.cancelable = false;
// 31837
o24.clientX = 806;
// 31838
o24.clientY = 434;
// 31839
o24.ctrlKey = false;
// 31840
o24.currentTarget = o0;
// 31841
o24.defaultPrevented = false;
// 31842
o24.detail = 0;
// 31843
o24.eventPhase = 3;
// 31844
o24.isTrusted = void 0;
// 31845
o24.metaKey = false;
// 31846
o24.pageX = 806;
// 31847
o24.pageY = 2820;
// 31848
o24.relatedTarget = null;
// 31849
o24.fromElement = null;
// 31852
o24.shiftKey = false;
// 31855
o24.timeStamp = 1374851254152;
// 31856
o24.type = "mousemove";
// 31857
o24.view = ow81632121;
// undefined
o24 = null;
// 31871
f81632121_1852.returns.push(undefined);
// 31874
f81632121_14.returns.push(undefined);
// 31875
f81632121_12.returns.push(147);
// 31878
o24 = {};
// 31881
o24.srcElement = o52;
// 31883
o24.target = o52;
// 31890
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4947623}.[0].[right].[0].[left].[0].[0]");
// 31893
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4947623}.[0].[right].[0].[left].[0].[0]");
// 31894
o24.relatedTarget = o53;
// 31895
o53.parentNode = o39;
// undefined
o39 = null;
// 31896
o53.nodeType = 1;
// 31899
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4947623}");
// 31902
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4947623}.[0].[right].[0].[left].[0].[0]");
// 31905
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4947623}");
// 31906
o24.JSBNG__screenX = 893;
// 31907
o24.JSBNG__screenY = 593;
// 31908
o24.altKey = false;
// 31909
o24.bubbles = true;
// 31910
o24.button = 0;
// 31911
o24.buttons = void 0;
// 31912
o24.cancelable = true;
// 31913
o24.clientX = 825;
// 31914
o24.clientY = 428;
// 31915
o24.ctrlKey = false;
// 31916
o24.currentTarget = o0;
// 31917
o24.defaultPrevented = false;
// 31918
o24.detail = 0;
// 31919
o24.eventPhase = 3;
// 31920
o24.isTrusted = void 0;
// 31921
o24.metaKey = false;
// 31922
o24.pageX = 825;
// 31923
o24.pageY = 2814;
// 31925
o24.shiftKey = false;
// 31928
o24.timeStamp = 1374851254159;
// 31929
o24.type = "mouseout";
// 31930
o24.view = ow81632121;
// 31932
o24.returnValue = true;
// 31969
o24.cancelBubble = false;
// undefined
o24 = null;
// 31971
o24 = {};
// 31974
o24.cancelBubble = false;
// 31977
f81632121_467.returns.push(1374851254184);
// 31980
f81632121_1007.returns.push(undefined);
// 31982
o24.returnValue = true;
// 31985
o24.srcElement = o53;
// 31987
o24.target = o53;
// 31994
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4947623}");
// 31997
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4947623}");
// 31998
o24.relatedTarget = o52;
// undefined
o24 = null;
// undefined
o52 = null;
// 31999
o53.nodeName = "LI";
// 32006
o24 = {};
// 32010
f81632121_467.returns.push(1374851254194);
// 32011
o24.cancelBubble = false;
// 32012
o24.returnValue = true;
// 32015
o24.srcElement = o53;
// 32017
o24.target = o53;
// 32024
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4947623}");
// 32027
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4947623}");
// 32028
o24.JSBNG__screenX = 893;
// 32029
o24.JSBNG__screenY = 593;
// 32030
o24.altKey = false;
// 32031
o24.bubbles = true;
// 32032
o24.button = 0;
// 32033
o24.buttons = void 0;
// 32034
o24.cancelable = false;
// 32035
o24.clientX = 825;
// 32036
o24.clientY = 428;
// 32037
o24.ctrlKey = false;
// 32038
o24.currentTarget = o0;
// 32039
o24.defaultPrevented = false;
// 32040
o24.detail = 0;
// 32041
o24.eventPhase = 3;
// 32042
o24.isTrusted = void 0;
// 32043
o24.metaKey = false;
// 32044
o24.pageX = 825;
// 32045
o24.pageY = 2814;
// 32046
o24.relatedTarget = null;
// 32047
o24.fromElement = null;
// 32050
o24.shiftKey = false;
// 32053
o24.timeStamp = 1374851254194;
// 32054
o24.type = "mousemove";
// 32055
o24.view = ow81632121;
// undefined
o24 = null;
// 32069
f81632121_1852.returns.push(undefined);
// 32072
f81632121_14.returns.push(undefined);
// 32073
f81632121_12.returns.push(148);
// undefined
fo81632121_1_cookie.returns.push("c_user=100006118350059; csm=2; sub=4096; wd=1034x727");
// 32077
o24 = {};
// 32080
o24.srcElement = o53;
// 32082
o24.target = o53;
// 32089
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4947623}");
// 32092
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4947623}");
// 32093
o24.relatedTarget = o109;
// 32098
f81632121_506.returns.push(null);
// 32104
f81632121_506.returns.push(null);
// 32110
f81632121_506.returns.push(null);
// 32116
f81632121_506.returns.push(null);
// 32122
f81632121_506.returns.push(null);
// 32128
f81632121_506.returns.push(null);
// 32134
f81632121_506.returns.push(null);
// 32140
f81632121_506.returns.push(null);
// 32147
f81632121_506.returns.push(".r[70hf].[1][4][1]{comment10200343222477260_4947623}");
// 32148
o24.JSBNG__screenX = 1058;
// 32149
o24.JSBNG__screenY = 583;
// 32150
o24.altKey = false;
// 32151
o24.bubbles = true;
// 32152
o24.button = 0;
// 32153
o24.buttons = void 0;
// 32154
o24.cancelable = true;
// 32155
o24.clientX = 990;
// 32156
o24.clientY = 418;
// 32157
o24.ctrlKey = false;
// 32158
o24.currentTarget = o0;
// 32159
o24.defaultPrevented = false;
// 32160
o24.detail = 0;
// 32161
o24.eventPhase = 3;
// 32162
o24.isTrusted = void 0;
// 32163
o24.metaKey = false;
// 32164
o24.pageX = 990;
// 32165
o24.pageY = 2804;
// 32167
o24.shiftKey = false;
// 32170
o24.timeStamp = 1374851254205;
// 32171
o24.type = "mouseout";
// 32172
o24.view = ow81632121;
// 32174
o24.returnValue = true;
// 32211
o24.cancelBubble = false;
// undefined
o24 = null;
// 32213
o24 = {};
// 32216
o24.cancelBubble = false;
// 32219
f81632121_467.returns.push(1374851254246);
// 32222
f81632121_1007.returns.push(undefined);
// 32224
o24.returnValue = true;
// 32227
o24.srcElement = o109;
// 32229
o24.target = o109;
// 32236
f81632121_506.returns.push(null);
// 32242
f81632121_506.returns.push(null);
// 32248
f81632121_506.returns.push(null);
// 32254
f81632121_506.returns.push(null);
// 32260
f81632121_506.returns.push(null);
// 32266
f81632121_506.returns.push(null);
// 32272
f81632121_506.returns.push(null);
// 32278
f81632121_506.returns.push(null);
// 32283
o24.relatedTarget = o53;
// undefined
o24 = null;
// undefined
o53 = null;
// 32286
o24 = {};
// 32290
f81632121_467.returns.push(1374851254248);
// 32291
o24.cancelBubble = false;
// 32292
o24.returnValue = true;
// 32295
o24.srcElement = o109;
// 32297
o24.target = o109;
// 32304
f81632121_506.returns.push(null);
// 32310
f81632121_506.returns.push(null);
// 32316
f81632121_506.returns.push(null);
// 32322
f81632121_506.returns.push(null);
// 32328
f81632121_506.returns.push(null);
// 32334
f81632121_506.returns.push(null);
// 32340
f81632121_506.returns.push(null);
// 32346
f81632121_506.returns.push(null);
// 32351
o24.JSBNG__screenX = 1058;
// 32352
o24.JSBNG__screenY = 583;
// 32353
o24.altKey = false;
// 32354
o24.bubbles = true;
// 32355
o24.button = 0;
// 32356
o24.buttons = void 0;
// 32357
o24.cancelable = false;
// 32358
o24.clientX = 990;
// 32359
o24.clientY = 418;
// 32360
o24.ctrlKey = false;
// 32361
o24.currentTarget = o0;
// 32362
o24.defaultPrevented = false;
// 32363
o24.detail = 0;
// 32364
o24.eventPhase = 3;
// 32365
o24.isTrusted = void 0;
// 32366
o24.metaKey = false;
// 32367
o24.pageX = 990;
// 32368
o24.pageY = 2804;
// 32369
o24.relatedTarget = null;
// 32370
o24.fromElement = null;
// 32373
o24.shiftKey = false;
// 32376
o24.timeStamp = 1374851254248;
// 32377
o24.type = "mousemove";
// 32378
o24.view = ow81632121;
// undefined
o24 = null;
// 32387
f81632121_1852.returns.push(undefined);
// 32390
f81632121_14.returns.push(undefined);
// 32393
f81632121_12.returns.push(149);
// undefined
fo81632121_1_cookie.returns.push("c_user=100006118350059; csm=2; sub=4096; wd=1034x727");
// 32398
f81632121_12.returns.push(150);
// undefined
fo81632121_1_cookie.returns.push("c_user=100006118350059; csm=2; sub=4096; wd=1034x727");
// 32403
f81632121_467.returns.push(1374851255093);
// undefined
fo81632121_1_cookie.returns.push("c_user=100006118350059; csm=2; sub=4096; wd=1034x727");
// undefined
fo81632121_1_cookie.returns.push("c_user=100006118350059; csm=2; sub=4096; wd=1034x727");
// 32407
f81632121_12.returns.push(151);
// undefined
fo81632121_1_cookie.returns.push("c_user=100006118350059; csm=2; sub=4096; wd=1034x727");
// 32412
f81632121_467.returns.push(1374851256085);
// undefined
fo81632121_1_cookie.returns.push("c_user=100006118350059; csm=2; sub=4096; wd=1034x727");
// undefined
fo81632121_1_cookie.returns.push("c_user=100006118350059; csm=2; sub=4096; wd=1034x727");
// 32420
f81632121_467.returns.push(1374851256937);
// 32425
f81632121_467.returns.push(1374851256939);
// 32429
f81632121_467.returns.push(1374851256939);
// 32432
f81632121_1007.returns.push(undefined);
// 32438
f81632121_467.returns.push(1374851256941);
// 32445
f81632121_1852.returns.push(undefined);
// 32447
f81632121_14.returns.push(undefined);
// 32448
f81632121_12.returns.push(152);
// 32449
f81632121_12.returns.push(153);
// 32451
o24 = {};
// 32455
f81632121_467.returns.push(1374851256947);
// 32456
o24.cancelBubble = false;
// 32457
o24.returnValue = true;
// 32460
o24.srcElement = o183;
// 32462
o24.target = o183;
// 32464
o183.nodeType = 1;
// 32467
o183.getAttribute = f81632121_506;
// 32469
f81632121_506.returns.push(null);
// 32472
o42.nodeType = 1;
// 32473
o42.getAttribute = f81632121_506;
// 32475
f81632121_506.returns.push(null);
// 32478
o29.nodeType = 1;
// 32481
f81632121_506.returns.push(null);
// 32484
o87.nodeType = 1;
// 32485
o87.getAttribute = f81632121_506;
// 32487
f81632121_506.returns.push(null);
// 32493
f81632121_506.returns.push(null);
// 32499
f81632121_506.returns.push(null);
// 32505
f81632121_506.returns.push(null);
// 32511
f81632121_506.returns.push(null);
// 32517
f81632121_506.returns.push(null);
// 32523
f81632121_506.returns.push(null);
// 32529
f81632121_506.returns.push(null);
// 32535
f81632121_506.returns.push(null);
// 32541
f81632121_506.returns.push(null);
// 32547
f81632121_506.returns.push(null);
// 32553
f81632121_506.returns.push(null);
// 32558
o24.JSBNG__screenX = 287;
// 32559
o24.JSBNG__screenY = 572;
// 32560
o24.altKey = false;
// 32561
o24.bubbles = true;
// 32562
o24.button = 0;
// 32563
o24.buttons = void 0;
// 32564
o24.cancelable = false;
// 32565
o24.clientX = 219;
// 32566
o24.clientY = 407;
// 32567
o24.ctrlKey = false;
// 32568
o24.currentTarget = o0;
// 32569
o24.defaultPrevented = false;
// 32570
o24.detail = 0;
// 32571
o24.eventPhase = 3;
// 32572
o24.isTrusted = void 0;
// 32573
o24.metaKey = false;
// 32574
o24.pageX = 219;
// 32575
o24.pageY = 2793;
// 32576
o24.relatedTarget = null;
// 32577
o24.fromElement = null;
// 32580
o24.shiftKey = false;
// 32583
o24.timeStamp = 1374851256946;
// 32584
o24.type = "mousemove";
// 32585
o24.view = ow81632121;
// undefined
o24 = null;
// 32594
f81632121_1852.returns.push(undefined);
// 32597
f81632121_14.returns.push(undefined);
// 32598
f81632121_12.returns.push(154);
// 32601
o24 = {};
// 32605
f81632121_467.returns.push(1374851257018);
// 32606
o24.cancelBubble = false;
// 32607
o24.returnValue = true;
// 32610
o24.srcElement = o183;
// 32612
o24.target = o183;
// 32619
f81632121_506.returns.push(null);
// 32625
f81632121_506.returns.push(null);
// 32631
f81632121_506.returns.push(null);
// 32637
f81632121_506.returns.push(null);
// 32643
f81632121_506.returns.push(null);
// 32649
f81632121_506.returns.push(null);
// 32655
f81632121_506.returns.push(null);
// 32661
f81632121_506.returns.push(null);
// 32667
f81632121_506.returns.push(null);
// 32673
f81632121_506.returns.push(null);
// 32679
f81632121_506.returns.push(null);
// 32685
f81632121_506.returns.push(null);
// 32691
f81632121_506.returns.push(null);
// 32697
f81632121_506.returns.push(null);
// 32703
f81632121_506.returns.push(null);
// 32708
o24.JSBNG__screenX = 240;
// 32709
o24.JSBNG__screenY = 572;
// 32710
o24.altKey = false;
// 32711
o24.bubbles = true;
// 32712
o24.button = 0;
// 32713
o24.buttons = void 0;
// 32714
o24.cancelable = false;
// 32715
o24.clientX = 172;
// 32716
o24.clientY = 407;
// 32717
o24.ctrlKey = false;
// 32718
o24.currentTarget = o0;
// 32719
o24.defaultPrevented = false;
// 32720
o24.detail = 0;
// 32721
o24.eventPhase = 3;
// 32722
o24.isTrusted = void 0;
// 32723
o24.metaKey = false;
// 32724
o24.pageX = 172;
// 32725
o24.pageY = 2793;
// 32726
o24.relatedTarget = null;
// 32727
o24.fromElement = null;
// 32730
o24.shiftKey = false;
// 32733
o24.timeStamp = 1374851257007;
// 32734
o24.type = "mousemove";
// 32735
o24.view = ow81632121;
// undefined
o24 = null;
// 32744
f81632121_1852.returns.push(undefined);
// 32747
f81632121_14.returns.push(undefined);
// 32748
f81632121_12.returns.push(155);
// 32751
o24 = {};
// 32755
f81632121_467.returns.push(1374851257041);
// 32756
o24.cancelBubble = false;
// 32757
o24.returnValue = true;
// 32760
o24.srcElement = o183;
// 32762
o24.target = o183;
// 32769
f81632121_506.returns.push(null);
// 32775
f81632121_506.returns.push(null);
// 32781
f81632121_506.returns.push(null);
// 32787
f81632121_506.returns.push(null);
// 32793
f81632121_506.returns.push(null);
// 32799
f81632121_506.returns.push(null);
// 32805
f81632121_506.returns.push(null);
// 32811
f81632121_506.returns.push(null);
// 32817
f81632121_506.returns.push(null);
// 32823
f81632121_506.returns.push(null);
// 32829
f81632121_506.returns.push(null);
// 32835
f81632121_506.returns.push(null);
// 32841
f81632121_506.returns.push(null);
// 32847
f81632121_506.returns.push(null);
// 32853
f81632121_506.returns.push(null);
// 32858
o24.JSBNG__screenX = 229;
// 32859
o24.JSBNG__screenY = 572;
// 32860
o24.altKey = false;
// 32861
o24.bubbles = true;
// 32862
o24.button = 0;
// 32863
o24.buttons = void 0;
// 32864
o24.cancelable = false;
// 32865
o24.clientX = 161;
// 32866
o24.clientY = 407;
// 32867
o24.ctrlKey = false;
// 32868
o24.currentTarget = o0;
// 32869
o24.defaultPrevented = false;
// 32870
o24.detail = 0;
// 32871
o24.eventPhase = 3;
// 32872
o24.isTrusted = void 0;
// 32873
o24.metaKey = false;
// 32874
o24.pageX = 161;
// 32875
o24.pageY = 2793;
// 32876
o24.relatedTarget = null;
// 32877
o24.fromElement = null;
// 32880
o24.shiftKey = false;
// 32883
o24.timeStamp = 1374851257041;
// 32884
o24.type = "mousemove";
// 32885
o24.view = ow81632121;
// undefined
o24 = null;
// 32894
f81632121_1852.returns.push(undefined);
// 32897
f81632121_14.returns.push(undefined);
// 32898
f81632121_12.returns.push(156);
// 32901
o24 = {};
// 32905
f81632121_467.returns.push(1374851257056);
// 32906
o24.cancelBubble = false;
// 32907
o24.returnValue = true;
// 32910
o24.srcElement = o183;
// 32912
o24.target = o183;
// 32919
f81632121_506.returns.push(null);
// 32925
f81632121_506.returns.push(null);
// 32931
f81632121_506.returns.push(null);
// 32937
f81632121_506.returns.push(null);
// 32943
f81632121_506.returns.push(null);
// 32949
f81632121_506.returns.push(null);
// 32955
f81632121_506.returns.push(null);
// 32961
f81632121_506.returns.push(null);
// 32967
f81632121_506.returns.push(null);
// 32973
f81632121_506.returns.push(null);
// 32979
f81632121_506.returns.push(null);
// 32985
f81632121_506.returns.push(null);
// 32991
f81632121_506.returns.push(null);
// 32997
f81632121_506.returns.push(null);
// 33003
f81632121_506.returns.push(null);
// 33008
o24.JSBNG__screenX = 226;
// 33009
o24.JSBNG__screenY = 573;
// 33010
o24.altKey = false;
// 33011
o24.bubbles = true;
// 33012
o24.button = 0;
// 33013
o24.buttons = void 0;
// 33014
o24.cancelable = false;
// 33015
o24.clientX = 158;
// 33016
o24.clientY = 408;
// 33017
o24.ctrlKey = false;
// 33018
o24.currentTarget = o0;
// 33019
o24.defaultPrevented = false;
// 33020
o24.detail = 0;
// 33021
o24.eventPhase = 3;
// 33022
o24.isTrusted = void 0;
// 33023
o24.metaKey = false;
// 33024
o24.pageX = 158;
// 33025
o24.pageY = 2794;
// 33026
o24.relatedTarget = null;
// 33027
o24.fromElement = null;
// 33030
o24.shiftKey = false;
// 33033
o24.timeStamp = 1374851257055;
// 33034
o24.type = "mousemove";
// 33035
o24.view = ow81632121;
// undefined
o24 = null;
// 33044
f81632121_1852.returns.push(undefined);
// 33047
f81632121_14.returns.push(undefined);
// 33048
f81632121_12.returns.push(157);
// 33051
o24 = {};
// 33055
f81632121_467.returns.push(1374851257078);
// 33056
o24.cancelBubble = false;
// 33057
o24.returnValue = true;
// 33060
o24.srcElement = o183;
// 33062
o24.target = o183;
// 33069
f81632121_506.returns.push(null);
// 33075
f81632121_506.returns.push(null);
// 33081
f81632121_506.returns.push(null);
// 33087
f81632121_506.returns.push(null);
// 33093
f81632121_506.returns.push(null);
// 33099
f81632121_506.returns.push(null);
// 33105
f81632121_506.returns.push(null);
// 33111
f81632121_506.returns.push(null);
// 33117
f81632121_506.returns.push(null);
// 33123
f81632121_506.returns.push(null);
// 33129
f81632121_506.returns.push(null);
// 33135
f81632121_506.returns.push(null);
// 33141
f81632121_506.returns.push(null);
// 33147
f81632121_506.returns.push(null);
// 33153
f81632121_506.returns.push(null);
// 33158
o24.JSBNG__screenX = 224;
// 33159
o24.JSBNG__screenY = 573;
// 33160
o24.altKey = false;
// 33161
o24.bubbles = true;
// 33162
o24.button = 0;
// 33163
o24.buttons = void 0;
// 33164
o24.cancelable = false;
// 33165
o24.clientX = 156;
// 33166
o24.clientY = 408;
// 33167
o24.ctrlKey = false;
// 33168
o24.currentTarget = o0;
// 33169
o24.defaultPrevented = false;
// 33170
o24.detail = 0;
// 33171
o24.eventPhase = 3;
// 33172
o24.isTrusted = void 0;
// 33173
o24.metaKey = false;
// 33174
o24.pageX = 156;
// 33175
o24.pageY = 2794;
// 33176
o24.relatedTarget = null;
// 33177
o24.fromElement = null;
// 33180
o24.shiftKey = false;
// 33183
o24.timeStamp = 1374851257078;
// 33184
o24.type = "mousemove";
// 33185
o24.view = ow81632121;
// undefined
o24 = null;
// 33194
f81632121_1852.returns.push(undefined);
// 33197
f81632121_14.returns.push(undefined);
// 33198
f81632121_12.returns.push(158);
// 33201
o24 = {};
// 33205
f81632121_467.returns.push(1374851257091);
// 33206
o24.cancelBubble = false;
// 33207
o24.returnValue = true;
// 33210
o24.srcElement = o183;
// 33212
o24.target = o183;
// 33219
f81632121_506.returns.push(null);
// 33225
f81632121_506.returns.push(null);
// 33231
f81632121_506.returns.push(null);
// 33237
f81632121_506.returns.push(null);
// 33243
f81632121_506.returns.push(null);
// 33249
f81632121_506.returns.push(null);
// 33255
f81632121_506.returns.push(null);
// 33261
f81632121_506.returns.push(null);
// 33267
f81632121_506.returns.push(null);
// 33273
f81632121_506.returns.push(null);
// 33279
f81632121_506.returns.push(null);
// 33285
f81632121_506.returns.push(null);
// 33291
f81632121_506.returns.push(null);
// 33297
f81632121_506.returns.push(null);
// 33303
f81632121_506.returns.push(null);
// 33308
o24.JSBNG__screenX = 222;
// 33309
o24.JSBNG__screenY = 574;
// 33310
o24.altKey = false;
// 33311
o24.bubbles = true;
// 33312
o24.button = 0;
// 33313
o24.buttons = void 0;
// 33314
o24.cancelable = false;
// 33315
o24.clientX = 154;
// 33316
o24.clientY = 409;
// 33317
o24.ctrlKey = false;
// 33318
o24.currentTarget = o0;
// 33319
o24.defaultPrevented = false;
// 33320
o24.detail = 0;
// 33321
o24.eventPhase = 3;
// 33322
o24.isTrusted = void 0;
// 33323
o24.metaKey = false;
// 33324
o24.pageX = 154;
// 33325
o24.pageY = 2795;
// 33326
o24.relatedTarget = null;
// 33327
o24.fromElement = null;
// 33330
o24.shiftKey = false;
// 33333
o24.timeStamp = 1374851257090;
// 33334
o24.type = "mousemove";
// 33335
o24.view = ow81632121;
// undefined
o24 = null;
// 33344
f81632121_1852.returns.push(undefined);
// 33347
f81632121_14.returns.push(undefined);
// 33348
f81632121_12.returns.push(159);
// undefined
fo81632121_1_cookie.returns.push("c_user=100006118350059; csm=2; sub=4096; wd=1034x727");
// 33354
f81632121_467.returns.push(1374851257106);
// undefined
fo81632121_1_cookie.returns.push("c_user=100006118350059; csm=2; sub=4096; wd=1034x727");
// 33356
o24 = {};
// 33359
o24.cancelBubble = false;
// 33360
o24.returnValue = true;
// 33363
o24.srcElement = o183;
// 33365
o24.target = o183;
// 33372
f81632121_506.returns.push(null);
// 33378
f81632121_506.returns.push(null);
// 33384
f81632121_506.returns.push(null);
// 33390
f81632121_506.returns.push(null);
// 33396
f81632121_506.returns.push(null);
// 33402
f81632121_506.returns.push(null);
// 33408
f81632121_506.returns.push(null);
// 33414
f81632121_506.returns.push(null);
// 33420
f81632121_506.returns.push(null);
// 33426
f81632121_506.returns.push(null);
// 33432
f81632121_506.returns.push(null);
// 33438
f81632121_506.returns.push(null);
// 33444
f81632121_506.returns.push(null);
// 33450
f81632121_506.returns.push(null);
// 33456
f81632121_506.returns.push(null);
// 33461
o24.JSBNG__screenX = 222;
// 33462
o24.JSBNG__screenY = 574;
// 33463
o24.altKey = false;
// 33464
o24.bubbles = true;
// 33465
o24.button = 0;
// 33466
o24.buttons = void 0;
// 33467
o24.cancelable = true;
// 33468
o24.clientX = 154;
// 33469
o24.clientY = 409;
// 33470
o24.ctrlKey = false;
// 33471
o24.currentTarget = o0;
// 33472
o24.defaultPrevented = false;
// 33473
o24.detail = 1;
// 33474
o24.eventPhase = 3;
// 33475
o24.isTrusted = void 0;
// 33476
o24.metaKey = false;
// 33477
o24.pageX = 154;
// 33478
o24.pageY = 2795;
// 33479
o24.relatedTarget = null;
// 33480
o24.fromElement = null;
// 33483
o24.shiftKey = false;
// 33486
o24.timeStamp = 1374851257660;
// 33487
o24.type = "mousedown";
// 33488
o24.view = ow81632121;
// undefined
o24 = null;
// 33495
o24 = {};
// 33498
o24.cancelBubble = false;
// 33499
o24.returnValue = true;
// 33502
o24.srcElement = o183;
// 33504
o24.target = o183;
// 33511
f81632121_506.returns.push(null);
// 33517
f81632121_506.returns.push(null);
// 33523
f81632121_506.returns.push(null);
// 33529
f81632121_506.returns.push(null);
// 33535
f81632121_506.returns.push(null);
// 33541
f81632121_506.returns.push(null);
// 33547
f81632121_506.returns.push(null);
// 33553
f81632121_506.returns.push(null);
// 33559
f81632121_506.returns.push(null);
// 33565
f81632121_506.returns.push(null);
// 33571
f81632121_506.returns.push(null);
// 33577
f81632121_506.returns.push(null);
// 33583
f81632121_506.returns.push(null);
// 33589
f81632121_506.returns.push(null);
// 33595
f81632121_506.returns.push(null);
// 33600
o24.JSBNG__screenX = 222;
// 33601
o24.JSBNG__screenY = 574;
// 33602
o24.altKey = false;
// 33603
o24.bubbles = true;
// 33604
o24.button = 0;
// 33605
o24.buttons = void 0;
// 33606
o24.cancelable = true;
// 33607
o24.clientX = 154;
// 33608
o24.clientY = 409;
// 33609
o24.ctrlKey = false;
// 33610
o24.currentTarget = o0;
// 33611
o24.defaultPrevented = false;
// 33612
o24.detail = 1;
// 33613
o24.eventPhase = 3;
// 33614
o24.isTrusted = void 0;
// 33615
o24.metaKey = false;
// 33616
o24.pageX = 154;
// 33617
o24.pageY = 2795;
// 33618
o24.relatedTarget = null;
// 33619
o24.fromElement = null;
// 33622
o24.shiftKey = false;
// 33625
o24.timeStamp = 1374851257671;
// 33626
o24.type = "mouseup";
// 33627
o24.view = ow81632121;
// undefined
o24 = null;
// 33634
o24 = {};
// 33637
f81632121_467.returns.push(1374851257676);
// 33638
o24.type = "click";
// 33648
f81632121_467.returns.push(1374851257677);
// 33653
f81632121_467.returns.push(1374851257681);
// 33657
f81632121_467.returns.push(1374851257682);
// 33665
f81632121_1852.returns.push(undefined);
// 33667
f81632121_14.returns.push(undefined);
// 33668
f81632121_12.returns.push(160);
// 33669
f81632121_12.returns.push(161);
// 33670
f81632121_12.returns.push(162);
// 33672
f81632121_467.returns.push(1374851257684);
// 33676
o24.cancelBubble = false;
// 33677
o24.returnValue = true;
// 33680
f81632121_467.returns.push(1374851257686);
// 33681
f81632121_14.returns.push(undefined);
// 33682
f81632121_12.returns.push(163);
// 33684
f81632121_467.returns.push(1374851257687);
// 33692
f81632121_467.returns.push(1374851257687);
// 33696
o24.target = o183;
// 33699
f81632121_506.returns.push(null);
// 33703
f81632121_506.returns.push(null);
// 33707
f81632121_506.returns.push(null);
// 33711
f81632121_506.returns.push(null);
// 33715
f81632121_506.returns.push(null);
// 33719
f81632121_506.returns.push(null);
// 33723
f81632121_506.returns.push(null);
// 33727
f81632121_506.returns.push(null);
// 33731
f81632121_506.returns.push(null);
// 33735
f81632121_506.returns.push(null);
// 33739
f81632121_506.returns.push(null);
// 33743
f81632121_506.returns.push(null);
// 33747
f81632121_506.returns.push(null);
// 33751
f81632121_506.returns.push(null);
// 33755
f81632121_506.returns.push(null);
// 33759
o183.nodeName = "DIV";
// 33761
o42.nodeName = "DIV";
// undefined
o42 = null;
// 33763
o29.nodeName = "DIV";
// undefined
o29 = null;
// 33765
o87.nodeName = "DIV";
// undefined
o87 = null;
// 33767
o21.nodeName = "DIV";
// undefined
o21 = null;
// 33769
o20.nodeName = "DIV";
// undefined
o20 = null;
// 33771
o45.nodeName = "DIV";
// undefined
o45 = null;
// 33773
o109.nodeName = "DIV";
// undefined
o109 = null;
// 33775
o110.nodeName = "DIV";
// undefined
o110 = null;
// 33777
o111.nodeName = "DIV";
// undefined
o111 = null;
// 33779
o112.nodeName = "DIV";
// undefined
o112 = null;
// 33781
o113.nodeName = "DIV";
// undefined
o113 = null;
// 33783
o82.nodeName = "DIV";
// undefined
o82 = null;
// 33791
f81632121_1005.returns.push(undefined);
// 33796
f81632121_467.returns.push(1374851257692);
// 33797
f81632121_14.returns.push(undefined);
// 33798
f81632121_12.returns.push(164);
// 33800
f81632121_467.returns.push(1374851257692);
// 33803
o24.srcElement = o183;
// 33812
f81632121_506.returns.push(null);
// 33818
f81632121_506.returns.push(null);
// 33824
f81632121_506.returns.push(null);
// 33830
f81632121_506.returns.push(null);
// 33836
f81632121_506.returns.push(null);
// 33842
f81632121_506.returns.push(null);
// 33848
f81632121_506.returns.push(null);
// 33854
f81632121_506.returns.push(null);
// 33860
f81632121_506.returns.push(null);
// 33866
f81632121_506.returns.push(null);
// 33872
f81632121_506.returns.push(null);
// 33878
f81632121_506.returns.push(null);
// 33884
f81632121_506.returns.push(null);
// 33890
f81632121_506.returns.push(null);
// 33896
f81632121_506.returns.push(null);
// 33901
o24.JSBNG__screenX = 222;
// 33902
o24.JSBNG__screenY = 574;
// 33903
o24.altKey = false;
// 33904
o24.bubbles = true;
// 33905
o24.button = 0;
// 33906
o24.buttons = void 0;
// 33907
o24.cancelable = true;
// 33908
o24.clientX = 154;
// 33909
o24.clientY = 409;
// 33910
o24.ctrlKey = false;
// 33911
o24.currentTarget = o0;
// 33912
o24.defaultPrevented = false;
// 33913
o24.detail = 1;
// 33914
o24.eventPhase = 3;
// 33915
o24.isTrusted = void 0;
// 33916
o24.metaKey = false;
// 33917
o24.pageX = 154;
// 33918
o24.pageY = 2795;
// 33919
o24.relatedTarget = null;
// 33920
o24.fromElement = null;
// 33923
o24.shiftKey = false;
// 33926
o24.timeStamp = 1374851257676;
// 33928
o24.view = ow81632121;
// undefined
o24 = null;
// 33935
f81632121_12.returns.push(165);
// 33938
o20 = {};
// 33941
o20.srcElement = o0;
// 33943
o20.target = o0;
// 33949
o20.cancelBubble = false;
// 33952
o20.returnValue = true;
// undefined
o20 = null;
// 33955
f81632121_467.returns.push(1374851257703);
// 33956
// undefined
o1 = null;
// 33957
f81632121_12.returns.push(166);
// undefined
fo81632121_1_cookie.returns.push("c_user=100006118350059; csm=2; sub=4096; wd=1034x727");
// 33962
f81632121_12.returns.push(167);
// undefined
fo81632121_1_cookie.returns.push("c_user=100006118350059; csm=2; sub=4096; wd=1034x727");
// 33967
f81632121_467.returns.push(1374851258116);
// 33968
o1 = {};
// 33971
o1.cancelBubble = false;
// 33974
f81632121_467.returns.push(1374851258127);
// 33976
o1.returnValue = true;
// undefined
o1 = null;
// 33977
o1 = {};
// 33980
o1.cancelBubble = false;
// 33983
f81632121_467.returns.push(1374851258146);
// 33985
o1.returnValue = true;
// undefined
o1 = null;
// 33986
o1 = {};
// 33989
o1.cancelBubble = false;
// 33992
f81632121_467.returns.push(1374851258174);
// 33994
o1.returnValue = true;
// undefined
o1 = null;
// 33995
o1 = {};
// 33998
o1.cancelBubble = false;
// 34001
f81632121_467.returns.push(1374851258200);
// 34006
f81632121_467.returns.push(1374851258202);
// 34010
f81632121_467.returns.push(1374851258202);
// 34013
o1.returnValue = true;
// undefined
o1 = null;
// 34014
o1 = {};
// 34017
o1.cancelBubble = false;
// 34020
f81632121_467.returns.push(1374851258220);
// 34022
o1.returnValue = true;
// undefined
o1 = null;
// 34023
o1 = {};
// 34026
o1.cancelBubble = false;
// 34029
f81632121_467.returns.push(1374851258246);
// 34031
o1.returnValue = true;
// undefined
o1 = null;
// undefined
fo81632121_1_cookie.returns.push("c_user=100006118350059; csm=2; sub=4096; wd=1034x727");
// 34033
o1 = {};
// 34036
o1.cancelBubble = false;
// 34039
f81632121_467.returns.push(1374851258268);
// 34041
o1.returnValue = true;
// undefined
o1 = null;
// 34042
o1 = {};
// 34045
o1.cancelBubble = false;
// 34048
f81632121_467.returns.push(1374851258288);
// 34050
o1.returnValue = true;
// undefined
o1 = null;
// 34051
o1 = {};
// 34054
o1.cancelBubble = false;
// 34057
f81632121_467.returns.push(1374851258317);
// 34059
o1.returnValue = true;
// undefined
o1 = null;
// 34060
o1 = {};
// 34063
o1.cancelBubble = false;
// 34066
f81632121_467.returns.push(1374851258332);
// 34068
o1.returnValue = true;
// undefined
o1 = null;
// 34069
o1 = {};
// 34072
o1.cancelBubble = false;
// 34075
f81632121_467.returns.push(1374851258351);
// 34077
o1.returnValue = true;
// undefined
o1 = null;
// 34078
o1 = {};
// 34081
o1.cancelBubble = false;
// 34084
f81632121_467.returns.push(1374851258386);
// 34086
o1.returnValue = true;
// undefined
o1 = null;
// 34087
o1 = {};
// 34090
o1.srcElement = o183;
// 34092
o1.target = o183;
// 34099
f81632121_506.returns.push(null);
// 34105
f81632121_506.returns.push(null);
// 34111
f81632121_506.returns.push(null);
// 34117
f81632121_506.returns.push(null);
// 34123
f81632121_506.returns.push(null);
// 34129
f81632121_506.returns.push(null);
// 34135
f81632121_506.returns.push(null);
// 34141
f81632121_506.returns.push(null);
// 34147
f81632121_506.returns.push(null);
// 34153
f81632121_506.returns.push(null);
// 34159
f81632121_506.returns.push(null);
// 34165
f81632121_506.returns.push(null);
// 34171
f81632121_506.returns.push(null);
// 34177
f81632121_506.returns.push(null);
// 34183
f81632121_506.returns.push(null);
// 34188
o1.relatedTarget = o73;
// 34189
o20 = {};
// 34190
o73.parentNode = o20;
// 34191
o73.nodeType = 1;
// 34194
f81632121_506.returns.push(null);
// 34196
o20.parentNode = o183;
// 34197
o20.nodeType = 1;
// 34198
o20.getAttribute = f81632121_506;
// undefined
o20 = null;
// 34200
f81632121_506.returns.push(null);
// 34206
f81632121_506.returns.push(null);
// 34212
f81632121_506.returns.push(null);
// 34218
f81632121_506.returns.push(null);
// 34224
f81632121_506.returns.push(null);
// 34230
f81632121_506.returns.push(null);
// 34236
f81632121_506.returns.push(null);
// 34242
f81632121_506.returns.push(null);
// 34248
f81632121_506.returns.push(null);
// 34254
f81632121_506.returns.push(null);
// 34260
f81632121_506.returns.push(null);
// 34266
f81632121_506.returns.push(null);
// 34272
f81632121_506.returns.push(null);
// 34278
f81632121_506.returns.push(null);
// 34284
f81632121_506.returns.push(null);
// 34290
f81632121_506.returns.push(null);
// 34295
o1.cancelBubble = false;
// 34296
o1.returnValue = true;
// undefined
o1 = null;
// 34297
o1 = {};
// 34300
o1.cancelBubble = false;
// 34303
f81632121_467.returns.push(1374851258398);
// 34306
f81632121_1007.returns.push(undefined);
// 34308
o1.returnValue = true;
// 34311
o1.srcElement = o73;
// 34313
o1.target = o73;
// 34320
f81632121_506.returns.push(null);
// 34326
f81632121_506.returns.push(null);
// 34332
f81632121_506.returns.push(null);
// 34338
f81632121_506.returns.push(null);
// 34344
f81632121_506.returns.push(null);
// 34350
f81632121_506.returns.push(null);
// 34356
f81632121_506.returns.push(null);
// 34362
f81632121_506.returns.push(null);
// 34368
f81632121_506.returns.push(null);
// 34374
f81632121_506.returns.push(null);
// 34380
f81632121_506.returns.push(null);
// 34386
f81632121_506.returns.push(null);
// 34392
f81632121_506.returns.push(null);
// 34398
f81632121_506.returns.push(null);
// 34404
f81632121_506.returns.push(null);
// 34410
f81632121_506.returns.push(null);
// 34416
f81632121_506.returns.push(null);
// 34421
o1.relatedTarget = o183;
// undefined
o1 = null;
// 34424
o1 = {};
// 34428
f81632121_467.returns.push(1374851258404);
// 34429
o1.cancelBubble = false;
// 34430
o1.returnValue = true;
// 34433
o1.srcElement = o73;
// 34435
o1.target = o73;
// 34442
f81632121_506.returns.push(null);
// 34448
f81632121_506.returns.push(null);
// 34454
f81632121_506.returns.push(null);
// 34460
f81632121_506.returns.push(null);
// 34466
f81632121_506.returns.push(null);
// 34472
f81632121_506.returns.push(null);
// 34478
f81632121_506.returns.push(null);
// 34484
f81632121_506.returns.push(null);
// 34490
f81632121_506.returns.push(null);
// 34496
f81632121_506.returns.push(null);
// 34502
f81632121_506.returns.push(null);
// 34508
f81632121_506.returns.push(null);
// 34514
f81632121_506.returns.push(null);
// 34520
f81632121_506.returns.push(null);
// 34526
f81632121_506.returns.push(null);
// 34532
f81632121_506.returns.push(null);
// 34538
f81632121_506.returns.push(null);
// 34543
o1.JSBNG__screenX = 226;
// 34544
o1.JSBNG__screenY = 566;
// 34545
o1.altKey = false;
// 34546
o1.bubbles = true;
// 34547
o1.button = 0;
// 34548
o1.buttons = void 0;
// 34549
o1.cancelable = false;
// 34550
o1.clientX = 158;
// 34551
o1.clientY = 401;
// 34552
o1.ctrlKey = false;
// 34553
o1.currentTarget = o0;
// 34554
o1.defaultPrevented = false;
// 34555
o1.detail = 0;
// 34556
o1.eventPhase = 3;
// 34557
o1.isTrusted = void 0;
// 34558
o1.metaKey = false;
// 34559
o1.pageX = 158;
// 34560
o1.pageY = 787;
// 34561
o1.relatedTarget = null;
// 34562
o1.fromElement = null;
// 34565
o1.shiftKey = false;
// 34568
o1.timeStamp = 1374851258404;
// 34569
o1.type = "mousemove";
// 34570
o1.view = ow81632121;
// undefined
o1 = null;
// 34579
f81632121_1852.returns.push(undefined);
// 34582
f81632121_14.returns.push(undefined);
// 34583
f81632121_12.returns.push(168);
// 34588
f81632121_467.returns.push(1374851258716);
// undefined
fo81632121_1_cookie.returns.push("c_user=100006118350059; csm=2; sub=4096; wd=1034x727");
// 34590
o1 = {};
// 34593
o1.srcElement = o73;
// 34595
o1.target = o73;
// 34602
f81632121_506.returns.push(null);
// 34608
f81632121_506.returns.push(null);
// 34614
f81632121_506.returns.push(null);
// 34620
f81632121_506.returns.push(null);
// 34626
f81632121_506.returns.push(null);
// 34632
f81632121_506.returns.push(null);
// 34638
f81632121_506.returns.push(null);
// 34644
f81632121_506.returns.push(null);
// 34650
f81632121_506.returns.push(null);
// 34656
f81632121_506.returns.push(null);
// 34662
f81632121_506.returns.push(null);
// 34668
f81632121_506.returns.push(null);
// 34674
f81632121_506.returns.push(null);
// 34680
f81632121_506.returns.push(null);
// 34686
f81632121_506.returns.push(null);
// 34692
f81632121_506.returns.push(null);
// 34698
f81632121_506.returns.push(null);
// 34703
o20 = {};
// 34704
o1.relatedTarget = o20;
// 34705
o20.parentNode = o78;
// 34706
o20.nodeType = 1;
// 34707
o20.getAttribute = f81632121_506;
// 34709
f81632121_506.returns.push(null);
// 34711
o78.parentNode = o73;
// 34712
o78.nodeType = 1;
// 34713
o78.getAttribute = f81632121_506;
// 34715
f81632121_506.returns.push(null);
// 34721
f81632121_506.returns.push(null);
// 34727
f81632121_506.returns.push(null);
// 34733
f81632121_506.returns.push(null);
// 34739
f81632121_506.returns.push(null);
// 34745
f81632121_506.returns.push(null);
// 34751
f81632121_506.returns.push(null);
// 34757
f81632121_506.returns.push(null);
// 34763
f81632121_506.returns.push(null);
// 34769
f81632121_506.returns.push(null);
// 34775
f81632121_506.returns.push(null);
// 34781
f81632121_506.returns.push(null);
// 34787
f81632121_506.returns.push(null);
// 34793
f81632121_506.returns.push(null);
// 34799
f81632121_506.returns.push(null);
// 34805
f81632121_506.returns.push(null);
// 34811
f81632121_506.returns.push(null);
// 34817
f81632121_506.returns.push(null);
// 34822
o1.cancelBubble = false;
// 34823
o1.returnValue = true;
// undefined
o1 = null;
// 34824
o1 = {};
// 34827
o1.cancelBubble = false;
// 34830
f81632121_467.returns.push(1374851258936);
// 34835
f81632121_467.returns.push(1374851258937);
// 34839
f81632121_467.returns.push(1374851258937);
// 34843
f81632121_1007.returns.push(undefined);
// 34845
o1.returnValue = true;
// 34848
o1.srcElement = o20;
// 34850
o1.target = o20;
// 34857
f81632121_506.returns.push(null);
// 34863
f81632121_506.returns.push(null);
// 34869
f81632121_506.returns.push(null);
// 34875
f81632121_506.returns.push(null);
// 34881
f81632121_506.returns.push(null);
// 34887
f81632121_506.returns.push(null);
// 34893
f81632121_506.returns.push(null);
// 34899
f81632121_506.returns.push(null);
// 34905
f81632121_506.returns.push(null);
// 34911
f81632121_506.returns.push(null);
// 34917
f81632121_506.returns.push(null);
// 34923
f81632121_506.returns.push(null);
// 34929
f81632121_506.returns.push(null);
// 34935
f81632121_506.returns.push(null);
// 34941
f81632121_506.returns.push(null);
// 34947
f81632121_506.returns.push(null);
// 34953
f81632121_506.returns.push(null);
// 34959
f81632121_506.returns.push(null);
// 34965
f81632121_506.returns.push(null);
// 34970
o1.relatedTarget = o73;
// undefined
o1 = null;
// undefined
o73 = null;
// 34973
o1 = {};
// 34977
f81632121_467.returns.push(1374851258956);
// 34978
o1.cancelBubble = false;
// 34979
o1.returnValue = true;
// 34982
o1.srcElement = o20;
// 34984
o1.target = o20;
// undefined
o20 = null;
// 34991
f81632121_506.returns.push(null);
// 34997
f81632121_506.returns.push(null);
// 35003
f81632121_506.returns.push(null);
// 35009
f81632121_506.returns.push(null);
// 35015
f81632121_506.returns.push(null);
// 35021
f81632121_506.returns.push(null);
// 35027
f81632121_506.returns.push(null);
// 35033
f81632121_506.returns.push(null);
// 35039
f81632121_506.returns.push(null);
// 35045
f81632121_506.returns.push(null);
// 35051
f81632121_506.returns.push(null);
// 35057
f81632121_506.returns.push(null);
// 35063
f81632121_506.returns.push(null);
// 35069
f81632121_506.returns.push(null);
// 35075
f81632121_506.returns.push(null);
// 35081
f81632121_506.returns.push(null);
// 35087
f81632121_506.returns.push(null);
// 35093
f81632121_506.returns.push(null);
// 35099
f81632121_506.returns.push(null);
// 35104
o1.JSBNG__screenX = 228;
// 35105
o1.JSBNG__screenY = 561;
// 35106
o1.altKey = false;
// 35107
o1.bubbles = true;
// 35108
o1.button = 0;
// 35109
o1.buttons = void 0;
// 35110
o1.cancelable = false;
// 35111
o1.clientX = 160;
// 35112
o1.clientY = 396;
// 35113
o1.ctrlKey = false;
// 35114
o1.currentTarget = o0;
// 35115
o1.defaultPrevented = false;
// 35116
o1.detail = 0;
// 35117
o1.eventPhase = 3;
// 35118
o1.isTrusted = void 0;
// 35119
o1.metaKey = false;
// 35120
o1.pageX = 160;
// 35121
o1.pageY = 782;
// 35122
o1.relatedTarget = null;
// 35123
o1.fromElement = null;
// 35126
o1.shiftKey = false;
// 35129
o1.timeStamp = 1374851258956;
// 35130
o1.type = "mousemove";
// 35131
o1.view = ow81632121;
// undefined
o1 = null;
// 35140
f81632121_1852.returns.push(undefined);
// 35143
f81632121_14.returns.push(undefined);
// 35144
f81632121_12.returns.push(169);
// 35156
f81632121_14.returns.push(undefined);
// 35157
f81632121_14.returns.push(undefined);
// 35158
f81632121_14.returns.push(undefined);
// 35159
f81632121_12.returns.push(170);
// 35160
f81632121_12.returns.push(171);
// 35161
o8.JSBNG__name = void 0;
// 35162
o8.id = "facebook";
// undefined
o8 = null;
// 35165
f81632121_467.returns.push(1374851258975);
// 35167
f81632121_1007.returns.push(undefined);
// 35173
f81632121_467.returns.push(1374851258976);
// 35180
f81632121_1852.returns.push(undefined);
// 35182
f81632121_14.returns.push(undefined);
// 35183
f81632121_12.returns.push(172);
// 35184
f81632121_12.returns.push(173);
// 35186
o1 = {};
// 35189
o8 = {};
// 35190
o1.srcElement = o8;
// 35192
o1.target = o8;
// 35194
o8.nodeType = 1;
// 35195
o20 = {};
// 35196
o8.parentNode = o20;
// 35198
o8.getAttribute = f81632121_506;
// undefined
o8 = null;
// 35200
f81632121_506.returns.push(null);
// 35202
o8 = {};
// 35203
o20.parentNode = o8;
// 35204
o20.nodeType = 1;
// 35205
o20.getAttribute = f81632121_506;
// undefined
o20 = null;
// 35207
f81632121_506.returns.push(null);
// 35209
o20 = {};
// 35210
o8.parentNode = o20;
// 35211
o8.nodeType = 1;
// 35212
o8.getAttribute = f81632121_506;
// undefined
o8 = null;
// 35214
f81632121_506.returns.push(null);
// 35216
o8 = {};
// 35217
o20.parentNode = o8;
// 35218
o20.nodeType = 1;
// 35219
o20.getAttribute = f81632121_506;
// undefined
o20 = null;
// 35221
f81632121_506.returns.push(null);
// 35223
o20 = {};
// 35224
o8.parentNode = o20;
// 35225
o8.nodeType = 1;
// 35226
o8.getAttribute = f81632121_506;
// undefined
o8 = null;
// 35228
f81632121_506.returns.push(null);
// 35230
o8 = {};
// 35231
o20.parentNode = o8;
// 35232
o20.nodeType = 1;
// 35233
o20.getAttribute = f81632121_506;
// undefined
o20 = null;
// 35235
f81632121_506.returns.push(null);
// 35237
o20 = {};
// 35238
o8.parentNode = o20;
// 35239
o8.nodeType = 1;
// 35240
o8.getAttribute = f81632121_506;
// undefined
o8 = null;
// 35242
f81632121_506.returns.push(null);
// 35244
o8 = {};
// 35245
o20.parentNode = o8;
// 35246
o20.nodeType = 1;
// 35247
o20.getAttribute = f81632121_506;
// 35249
f81632121_506.returns.push(null);
// 35251
o21 = {};
// 35252
o8.parentNode = o21;
// 35253
o8.nodeType = 1;
// 35254
o8.getAttribute = f81632121_506;
// undefined
o8 = null;
// 35256
f81632121_506.returns.push(null);
// 35258
o8 = {};
// 35259
o21.parentNode = o8;
// 35260
o21.nodeType = 1;
// 35261
o21.getAttribute = f81632121_506;
// undefined
o21 = null;
// 35263
f81632121_506.returns.push(null);
// 35265
o21 = {};
// 35266
o8.parentNode = o21;
// 35267
o8.nodeType = 1;
// 35268
o8.getAttribute = f81632121_506;
// undefined
o8 = null;
// 35270
f81632121_506.returns.push(null);
// 35272
o8 = {};
// 35273
o21.parentNode = o8;
// 35274
o21.nodeType = 1;
// 35275
o21.getAttribute = f81632121_506;
// undefined
o21 = null;
// 35277
f81632121_506.returns.push(null);
// 35279
o21 = {};
// 35280
o8.parentNode = o21;
// 35281
o8.nodeType = 1;
// 35282
o8.getAttribute = f81632121_506;
// undefined
o8 = null;
// 35284
f81632121_506.returns.push(null);
// 35286
o8 = {};
// 35287
o21.parentNode = o8;
// 35288
o21.nodeType = 1;
// 35289
o21.getAttribute = f81632121_506;
// undefined
o21 = null;
// 35291
f81632121_506.returns.push(null);
// 35293
o21 = {};
// 35294
o8.parentNode = o21;
// 35295
o8.nodeType = 1;
// 35296
o8.getAttribute = f81632121_506;
// undefined
o8 = null;
// 35298
f81632121_506.returns.push(null);
// 35300
o21.parentNode = o78;
// undefined
o78 = null;
// 35301
o21.nodeType = 1;
// 35302
o21.getAttribute = f81632121_506;
// undefined
o21 = null;
// 35304
f81632121_506.returns.push(null);
// 35310
f81632121_506.returns.push(null);
// 35316
f81632121_506.returns.push(null);
// 35322
f81632121_506.returns.push(null);
// 35328
f81632121_506.returns.push(null);
// 35334
f81632121_506.returns.push(null);
// 35340
f81632121_506.returns.push(null);
// 35346
f81632121_506.returns.push(null);
// 35352
f81632121_506.returns.push(null);
// 35358
f81632121_506.returns.push(null);
// 35364
f81632121_506.returns.push(null);
// 35370
f81632121_506.returns.push(null);
// 35376
f81632121_506.returns.push(null);
// 35382
f81632121_506.returns.push(null);
// 35388
f81632121_506.returns.push(null);
// 35394
f81632121_506.returns.push(null);
// 35400
f81632121_506.returns.push(null);
// 35406
f81632121_506.returns.push(null);
// 35412
f81632121_506.returns.push(null);
// 35417
o8 = {};
// 35418
o1.relatedTarget = o8;
// 35419
o21 = {};
// 35420
o8.parentNode = o21;
// 35421
o8.nodeType = 1;
// 35422
o8.getAttribute = f81632121_506;
// 35424
f81632121_506.returns.push(null);
// 35426
o24 = {};
// 35427
o21.parentNode = o24;
// 35428
o21.nodeType = 1;
// 35429
o21.getAttribute = f81632121_506;
// undefined
o21 = null;
// 35431
f81632121_506.returns.push(null);
// 35433
o21 = {};
// 35434
o24.parentNode = o21;
// 35435
o24.nodeType = 1;
// 35436
o24.getAttribute = f81632121_506;
// undefined
o24 = null;
// 35438
f81632121_506.returns.push(null);
// 35440
o24 = {};
// 35441
o21.parentNode = o24;
// 35442
o21.nodeType = 1;
// 35443
o21.getAttribute = f81632121_506;
// undefined
o21 = null;
// 35445
f81632121_506.returns.push(null);
// 35447
o21 = {};
// 35448
o24.parentNode = o21;
// 35449
o24.nodeType = 1;
// 35450
o24.getAttribute = f81632121_506;
// undefined
o24 = null;
// 35452
f81632121_506.returns.push(null);
// 35454
o24 = {};
// 35455
o21.parentNode = o24;
// 35456
o21.nodeType = 1;
// 35457
o21.getAttribute = f81632121_506;
// undefined
o21 = null;
// 35459
f81632121_506.returns.push(null);
// 35461
o24.parentNode = o20;
// undefined
o20 = null;
// 35462
o24.nodeType = 1;
// 35463
o24.getAttribute = f81632121_506;
// undefined
o24 = null;
// 35465
f81632121_506.returns.push(null);
// 35471
f81632121_506.returns.push(null);
// 35477
f81632121_506.returns.push(null);
// 35483
f81632121_506.returns.push(null);
// 35489
f81632121_506.returns.push(null);
// 35495
f81632121_506.returns.push(null);
// 35501
f81632121_506.returns.push(null);
// 35507
f81632121_506.returns.push(null);
// 35513
f81632121_506.returns.push(null);
// 35519
f81632121_506.returns.push(null);
// 35525
f81632121_506.returns.push(null);
// 35531
f81632121_506.returns.push(null);
// 35537
f81632121_506.returns.push(null);
// 35543
f81632121_506.returns.push(null);
// 35549
f81632121_506.returns.push(null);
// 35555
f81632121_506.returns.push(null);
// 35561
f81632121_506.returns.push(null);
// 35567
f81632121_506.returns.push(null);
// 35573
f81632121_506.returns.push(null);
// 35579
f81632121_506.returns.push(null);
// 35585
f81632121_506.returns.push(null);
// 35591
f81632121_506.returns.push(null);
// 35597
f81632121_506.returns.push(null);
// 35603
f81632121_506.returns.push(null);
// 35609
f81632121_506.returns.push(null);
// 35615
f81632121_506.returns.push(null);
// 35621
f81632121_506.returns.push(null);
// 35627
f81632121_506.returns.push(null);
// 35632
o1.cancelBubble = false;
// 35633
o1.returnValue = true;
// undefined
o1 = null;
// 35634
o1 = {};
// 35637
f81632121_14.returns.push(undefined);
// 35638
f81632121_14.returns.push(undefined);
// 35639
f81632121_14.returns.push(undefined);
// 35640
f81632121_12.returns.push(174);
// 35641
f81632121_12.returns.push(175);
// 35642
f81632121_2709 = function() { return f81632121_2709.returns[f81632121_2709.inst++]; };
f81632121_2709.returns = [];
f81632121_2709.inst = 0;
// 35643
o1.JSBNG__stop = f81632121_2709;
// 35644
f81632121_2710 = function() { return f81632121_2710.returns[f81632121_2710.inst++]; };
f81632121_2710.returns = [];
f81632121_2710.inst = 0;
// 35645
f81632121_270.JSBNG__stop = f81632121_2710;
// 35646
o1.srcElement = o8;
// 35647
o1.target = o8;
// 35648
f81632121_2711 = function() { return f81632121_2711.returns[f81632121_2711.inst++]; };
f81632121_2711.returns = [];
f81632121_2711.inst = 0;
// 35649
o1.stopPropagation = f81632121_2711;
// 35651
f81632121_2711.returns.push(undefined);
// 35652
o1.type = "mouseover";
// 35656
f81632121_467.returns.push(1374851259018);
// 35657
f81632121_2710.returns.push(o1);
// 35658
f81632121_2709.returns.push(o1);
// 35659
o1.cancelBubble = false;
// 35662
f81632121_467.returns.push(1374851259019);
// 35665
f81632121_1007.returns.push(undefined);
// 35667
o1.returnValue = true;
// undefined
o1 = null;
// 35668
o1 = {};
// 35672
f81632121_467.returns.push(1374851259019);
// 35673
o1.cancelBubble = false;
// 35674
o1.returnValue = true;
// 35677
o1.srcElement = o8;
// 35679
o1.target = o8;
// 35686
f81632121_506.returns.push(null);
// 35692
f81632121_506.returns.push(null);
// 35698
f81632121_506.returns.push(null);
// 35704
f81632121_506.returns.push(null);
// 35710
f81632121_506.returns.push(null);
// 35716
f81632121_506.returns.push(null);
// 35722
f81632121_506.returns.push(null);
// 35728
f81632121_506.returns.push(null);
// 35734
f81632121_506.returns.push(null);
// 35740
f81632121_506.returns.push(null);
// 35746
f81632121_506.returns.push(null);
// 35752
f81632121_506.returns.push(null);
// 35758
f81632121_506.returns.push(null);
// 35764
f81632121_506.returns.push(null);
// 35770
f81632121_506.returns.push(null);
// 35776
f81632121_506.returns.push(null);
// 35782
f81632121_506.returns.push(null);
// 35788
f81632121_506.returns.push(null);
// 35794
f81632121_506.returns.push(null);
// 35800
f81632121_506.returns.push(null);
// 35806
f81632121_506.returns.push(null);
// 35812
f81632121_506.returns.push(null);
// 35818
f81632121_506.returns.push(null);
// 35824
f81632121_506.returns.push(null);
// 35830
f81632121_506.returns.push(null);
// 35836
f81632121_506.returns.push(null);
// 35842
f81632121_506.returns.push(null);
// 35848
f81632121_506.returns.push(null);
// 35854
f81632121_506.returns.push(null);
// 35860
f81632121_506.returns.push(null);
// 35866
f81632121_506.returns.push(null);
// 35872
f81632121_506.returns.push(null);
// 35878
f81632121_506.returns.push(null);
// 35884
f81632121_506.returns.push(null);
// 35889
o1.JSBNG__screenX = 307;
// 35890
o1.JSBNG__screenY = 432;
// 35891
o1.altKey = false;
// 35892
o1.bubbles = true;
// 35893
o1.button = 0;
// 35894
o1.buttons = void 0;
// 35895
o1.cancelable = false;
// 35896
o1.clientX = 239;
// 35897
o1.clientY = 267;
// 35898
o1.ctrlKey = false;
// 35899
o1.currentTarget = o0;
// 35900
o1.defaultPrevented = false;
// 35901
o1.detail = 0;
// 35902
o1.eventPhase = 3;
// 35903
o1.isTrusted = void 0;
// 35904
o1.metaKey = false;
// 35905
o1.pageX = 239;
// 35906
o1.pageY = 653;
// 35907
o1.relatedTarget = null;
// 35908
o1.fromElement = null;
// 35911
o1.shiftKey = false;
// 35914
o1.timeStamp = 1374851259019;
// 35915
o1.type = "mousemove";
// 35916
o1.view = ow81632121;
// undefined
o1 = null;
// 35925
f81632121_1852.returns.push(undefined);
// 35928
f81632121_14.returns.push(undefined);
// 35929
f81632121_12.returns.push(176);
// 35932
o1 = {};
// 35935
o1.srcElement = o8;
// 35937
o1.target = o8;
// 35944
f81632121_506.returns.push(null);
// 35950
f81632121_506.returns.push(null);
// 35956
f81632121_506.returns.push(null);
// 35962
f81632121_506.returns.push(null);
// 35968
f81632121_506.returns.push(null);
// 35974
f81632121_506.returns.push(null);
// 35980
f81632121_506.returns.push(null);
// 35986
f81632121_506.returns.push(null);
// 35992
f81632121_506.returns.push(null);
// 35998
f81632121_506.returns.push(null);
// 36004
f81632121_506.returns.push(null);
// 36010
f81632121_506.returns.push(null);
// 36016
f81632121_506.returns.push(null);
// 36022
f81632121_506.returns.push(null);
// 36028
f81632121_506.returns.push(null);
// 36034
f81632121_506.returns.push(null);
// 36040
f81632121_506.returns.push(null);
// 36046
f81632121_506.returns.push(null);
// 36052
f81632121_506.returns.push(null);
// 36058
f81632121_506.returns.push(null);
// 36064
f81632121_506.returns.push(null);
// 36070
f81632121_506.returns.push(null);
// 36076
f81632121_506.returns.push(null);
// 36082
f81632121_506.returns.push(null);
// 36088
f81632121_506.returns.push(null);
// 36094
f81632121_506.returns.push(null);
// 36100
f81632121_506.returns.push(null);
// 36106
f81632121_506.returns.push(null);
// 36112
f81632121_506.returns.push(null);
// 36118
f81632121_506.returns.push(null);
// 36124
f81632121_506.returns.push(null);
// 36130
f81632121_506.returns.push(null);
// 36136
f81632121_506.returns.push(null);
// 36142
f81632121_506.returns.push(null);
// 36147
o20 = {};
// 36148
o1.relatedTarget = o20;
// 36149
o20.parentNode = o34;
// 36150
o20.nodeType = 1;
// 36151
o20.getAttribute = f81632121_506;
// 36153
f81632121_506.returns.push(null);
// 36155
o34.parentNode = o31;
// 36156
o34.nodeType = 1;
// 36157
o34.getAttribute = f81632121_506;
// undefined
o34 = null;
// 36159
f81632121_506.returns.push(null);
// 36161
o31.parentNode = o44;
// 36162
o31.nodeType = 1;
// undefined
o31 = null;
// 36165
f81632121_506.returns.push(null);
// 36168
o44.nodeType = 1;
// 36169
o44.getAttribute = f81632121_506;
// undefined
o44 = null;
// 36171
f81632121_506.returns.push(null);
// 36177
f81632121_506.returns.push(null);
// 36183
f81632121_506.returns.push(null);
// 36189
f81632121_506.returns.push(null);
// 36195
f81632121_506.returns.push(null);
// 36201
f81632121_506.returns.push(null);
// 36207
f81632121_506.returns.push(null);
// 36213
f81632121_506.returns.push(null);
// 36219
f81632121_506.returns.push(null);
// 36225
f81632121_506.returns.push(null);
// 36231
f81632121_506.returns.push(null);
// 36237
f81632121_506.returns.push(null);
// 36243
f81632121_506.returns.push(null);
// 36249
f81632121_506.returns.push(null);
// 36255
f81632121_506.returns.push(null);
// 36261
f81632121_506.returns.push(null);
// 36266
o1.cancelBubble = false;
// 36267
o1.returnValue = true;
// undefined
o1 = null;
// 36268
o1 = {};
// 36271
o1.cancelBubble = false;
// 36274
f81632121_467.returns.push(1374851259063);
// 36277
f81632121_1007.returns.push(undefined);
// 36279
o1.returnValue = true;
// 36282
o1.srcElement = o20;
// 36284
o1.target = o20;
// 36291
f81632121_506.returns.push(null);
// 36297
f81632121_506.returns.push(null);
// 36303
f81632121_506.returns.push(null);
// 36309
f81632121_506.returns.push(null);
// 36315
f81632121_506.returns.push(null);
// 36321
f81632121_506.returns.push(null);
// 36327
f81632121_506.returns.push(null);
// 36333
f81632121_506.returns.push(null);
// 36339
f81632121_506.returns.push(null);
// 36345
f81632121_506.returns.push(null);
// 36351
f81632121_506.returns.push(null);
// 36357
f81632121_506.returns.push(null);
// 36363
f81632121_506.returns.push(null);
// 36369
f81632121_506.returns.push(null);
// 36375
f81632121_506.returns.push(null);
// 36381
f81632121_506.returns.push(null);
// 36387
f81632121_506.returns.push(null);
// 36393
f81632121_506.returns.push(null);
// 36399
f81632121_506.returns.push(null);
// 36404
o1.relatedTarget = o8;
// undefined
o1 = null;
// undefined
o8 = null;
// 36407
o1 = {};
// 36411
f81632121_467.returns.push(1374851259069);
// 36412
o1.cancelBubble = false;
// 36413
o1.returnValue = true;
// 36416
o1.srcElement = o20;
// 36418
o1.target = o20;
// 36425
f81632121_506.returns.push(null);
// 36431
f81632121_506.returns.push(null);
// 36437
f81632121_506.returns.push(null);
// 36443
f81632121_506.returns.push(null);
// 36449
f81632121_506.returns.push(null);
// 36455
f81632121_506.returns.push(null);
// 36461
f81632121_506.returns.push(null);
// 36467
f81632121_506.returns.push(null);
// 36473
f81632121_506.returns.push(null);
// 36479
f81632121_506.returns.push(null);
// 36485
f81632121_506.returns.push(null);
// 36491
f81632121_506.returns.push(null);
// 36497
f81632121_506.returns.push(null);
// 36503
f81632121_506.returns.push(null);
// 36509
f81632121_506.returns.push(null);
// 36515
f81632121_506.returns.push(null);
// 36521
f81632121_506.returns.push(null);
// 36527
f81632121_506.returns.push(null);
// 36533
f81632121_506.returns.push(null);
// 36538
o1.JSBNG__screenX = 429;
// 36539
o1.JSBNG__screenY = 353;
// 36540
o1.altKey = false;
// 36541
o1.bubbles = true;
// 36542
o1.button = 0;
// 36543
o1.buttons = void 0;
// 36544
o1.cancelable = false;
// 36545
o1.clientX = 361;
// 36546
o1.clientY = 188;
// 36547
o1.ctrlKey = false;
// 36548
o1.currentTarget = o0;
// 36549
o1.defaultPrevented = false;
// 36550
o1.detail = 0;
// 36551
o1.eventPhase = 3;
// 36552
o1.isTrusted = void 0;
// 36553
o1.metaKey = false;
// 36554
o1.pageX = 361;
// 36555
o1.pageY = 574;
// 36556
o1.relatedTarget = null;
// 36557
o1.fromElement = null;
// 36560
o1.shiftKey = false;
// 36563
o1.timeStamp = 1374851259069;
// 36564
o1.type = "mousemove";
// 36565
o1.view = ow81632121;
// undefined
o1 = null;
// 36574
f81632121_1852.returns.push(undefined);
// 36577
f81632121_14.returns.push(undefined);
// 36578
f81632121_12.returns.push(177);
// 36582
f81632121_467.returns.push(1374851259106);
// 36583
o1 = {};
// 36586
o1.srcElement = o20;
// 36588
o1.target = o20;
// 36595
f81632121_506.returns.push(null);
// 36601
f81632121_506.returns.push(null);
// 36607
f81632121_506.returns.push(null);
// 36613
f81632121_506.returns.push(null);
// 36619
f81632121_506.returns.push(null);
// 36625
f81632121_506.returns.push(null);
// 36631
f81632121_506.returns.push(null);
// 36637
f81632121_506.returns.push(null);
// 36643
f81632121_506.returns.push(null);
// 36649
f81632121_506.returns.push(null);
// 36655
f81632121_506.returns.push(null);
// 36661
f81632121_506.returns.push(null);
// 36667
f81632121_506.returns.push(null);
// 36673
f81632121_506.returns.push(null);
// 36679
f81632121_506.returns.push(null);
// 36685
f81632121_506.returns.push(null);
// 36691
f81632121_506.returns.push(null);
// 36697
f81632121_506.returns.push(null);
// 36703
f81632121_506.returns.push(null);
// 36708
o8 = {};
// 36709
o1.relatedTarget = o8;
// 36710
o21 = {};
// 36711
o8.parentNode = o21;
// 36712
o8.nodeType = 1;
// 36713
o8.getAttribute = f81632121_506;
// 36715
f81632121_506.returns.push(null);
// 36717
o24 = {};
// 36718
o21.parentNode = o24;
// 36719
o21.nodeType = 1;
// 36720
o21.getAttribute = f81632121_506;
// undefined
o21 = null;
// 36722
f81632121_506.returns.push(null);
// 36724
o21 = {};
// 36725
o24.parentNode = o21;
// 36726
o24.nodeType = 1;
// 36727
o24.getAttribute = f81632121_506;
// undefined
o24 = null;
// 36729
f81632121_506.returns.push(null);
// 36731
o24 = {};
// 36732
o21.parentNode = o24;
// 36733
o21.nodeType = 1;
// 36734
o21.getAttribute = f81632121_506;
// 36736
f81632121_506.returns.push(null);
// 36738
o24.parentNode = o20;
// 36739
o24.nodeType = 1;
// 36740
o24.getAttribute = f81632121_506;
// undefined
o24 = null;
// 36742
f81632121_506.returns.push(null);
// 36748
f81632121_506.returns.push(null);
// 36754
f81632121_506.returns.push(null);
// 36760
f81632121_506.returns.push(null);
// 36766
f81632121_506.returns.push(null);
// 36772
f81632121_506.returns.push(null);
// 36778
f81632121_506.returns.push(null);
// 36784
f81632121_506.returns.push(null);
// 36790
f81632121_506.returns.push(null);
// 36796
f81632121_506.returns.push(null);
// 36802
f81632121_506.returns.push(null);
// 36808
f81632121_506.returns.push(null);
// 36814
f81632121_506.returns.push(null);
// 36820
f81632121_506.returns.push(null);
// 36826
f81632121_506.returns.push(null);
// 36832
f81632121_506.returns.push(null);
// 36838
f81632121_506.returns.push(null);
// 36844
f81632121_506.returns.push(null);
// 36850
f81632121_506.returns.push(null);
// 36856
f81632121_506.returns.push(null);
// 36861
o1.cancelBubble = false;
// 36862
o1.returnValue = true;
// undefined
o1 = null;
// 36863
o1 = {};
// 36866
o1.cancelBubble = false;
// 36869
f81632121_467.returns.push(1374851259120);
// 36872
f81632121_1007.returns.push(undefined);
// 36874
o1.returnValue = true;
// 36877
o1.srcElement = o8;
// 36879
o1.target = o8;
// 36886
f81632121_506.returns.push(null);
// 36892
f81632121_506.returns.push(null);
// 36898
f81632121_506.returns.push(null);
// 36904
f81632121_506.returns.push(null);
// 36910
f81632121_506.returns.push(null);
// 36916
f81632121_506.returns.push(null);
// 36922
f81632121_506.returns.push(null);
// 36928
f81632121_506.returns.push(null);
// 36934
f81632121_506.returns.push(null);
// 36940
f81632121_506.returns.push(null);
// 36946
f81632121_506.returns.push(null);
// 36952
f81632121_506.returns.push(null);
// 36958
f81632121_506.returns.push(null);
// 36964
f81632121_506.returns.push(null);
// 36970
f81632121_506.returns.push(null);
// 36976
f81632121_506.returns.push(null);
// 36982
f81632121_506.returns.push(null);
// 36988
f81632121_506.returns.push(null);
// 36994
f81632121_506.returns.push(null);
// 37000
f81632121_506.returns.push(null);
// 37006
f81632121_506.returns.push(null);
// 37012
f81632121_506.returns.push(null);
// 37018
f81632121_506.returns.push(null);
// 37024
f81632121_506.returns.push(null);
// 37029
o1.relatedTarget = o20;
// undefined
o1 = null;
// 37032
o1 = {};
// 37036
f81632121_467.returns.push(1374851259129);
// 37037
o1.cancelBubble = false;
// 37038
o1.returnValue = true;
// 37041
o1.srcElement = o8;
// 37043
o1.target = o8;
// 37050
f81632121_506.returns.push(null);
// 37056
f81632121_506.returns.push(null);
// 37062
f81632121_506.returns.push(null);
// 37068
f81632121_506.returns.push(null);
// 37074
f81632121_506.returns.push(null);
// 37080
f81632121_506.returns.push(null);
// 37086
f81632121_506.returns.push(null);
// 37092
f81632121_506.returns.push(null);
// 37098
f81632121_506.returns.push(null);
// 37104
f81632121_506.returns.push(null);
// 37110
f81632121_506.returns.push(null);
// 37116
f81632121_506.returns.push(null);
// 37122
f81632121_506.returns.push(null);
// 37128
f81632121_506.returns.push(null);
// 37134
f81632121_506.returns.push(null);
// 37140
f81632121_506.returns.push(null);
// 37146
f81632121_506.returns.push(null);
// 37152
f81632121_506.returns.push(null);
// 37158
f81632121_506.returns.push(null);
// 37164
f81632121_506.returns.push(null);
// 37170
f81632121_506.returns.push(null);
// 37176
f81632121_506.returns.push(null);
// 37182
f81632121_506.returns.push(null);
// 37188
f81632121_506.returns.push(null);
// 37193
o1.JSBNG__screenX = 528;
// 37194
o1.JSBNG__screenY = 345;
// 37195
o1.altKey = false;
// 37196
o1.bubbles = true;
// 37197
o1.button = 0;
// 37198
o1.buttons = void 0;
// 37199
o1.cancelable = false;
// 37200
o1.clientX = 460;
// 37201
o1.clientY = 180;
// 37202
o1.ctrlKey = false;
// 37203
o1.currentTarget = o0;
// 37204
o1.defaultPrevented = false;
// 37205
o1.detail = 0;
// 37206
o1.eventPhase = 3;
// 37207
o1.isTrusted = void 0;
// 37208
o1.metaKey = false;
// 37209
o1.pageX = 460;
// 37210
o1.pageY = 566;
// 37211
o1.relatedTarget = null;
// 37212
o1.fromElement = null;
// 37215
o1.shiftKey = false;
// 37218
o1.timeStamp = 1374851259128;
// 37219
o1.type = "mousemove";
// 37220
o1.view = ow81632121;
// undefined
o1 = null;
// 37229
f81632121_1852.returns.push(undefined);
// 37232
f81632121_14.returns.push(undefined);
// 37233
f81632121_12.returns.push(178);
// 37236
o1 = {};
// 37239
o1.srcElement = o8;
// 37241
o1.target = o8;
// 37248
f81632121_506.returns.push(null);
// 37254
f81632121_506.returns.push(null);
// 37260
f81632121_506.returns.push(null);
// 37266
f81632121_506.returns.push(null);
// 37272
f81632121_506.returns.push(null);
// 37278
f81632121_506.returns.push(null);
// 37284
f81632121_506.returns.push(null);
// 37290
f81632121_506.returns.push(null);
// 37296
f81632121_506.returns.push(null);
// 37302
f81632121_506.returns.push(null);
// 37308
f81632121_506.returns.push(null);
// 37314
f81632121_506.returns.push(null);
// 37320
f81632121_506.returns.push(null);
// 37326
f81632121_506.returns.push(null);
// 37332
f81632121_506.returns.push(null);
// 37338
f81632121_506.returns.push(null);
// 37344
f81632121_506.returns.push(null);
// 37350
f81632121_506.returns.push(null);
// 37356
f81632121_506.returns.push(null);
// 37362
f81632121_506.returns.push(null);
// 37368
f81632121_506.returns.push(null);
// 37374
f81632121_506.returns.push(null);
// 37380
f81632121_506.returns.push(null);
// 37386
f81632121_506.returns.push(null);
// 37391
o1.relatedTarget = o21;
// 37396
f81632121_506.returns.push(null);
// 37402
f81632121_506.returns.push(null);
// 37408
f81632121_506.returns.push(null);
// 37414
f81632121_506.returns.push(null);
// 37420
f81632121_506.returns.push(null);
// 37426
f81632121_506.returns.push(null);
// 37432
f81632121_506.returns.push(null);
// 37438
f81632121_506.returns.push(null);
// 37444
f81632121_506.returns.push(null);
// 37450
f81632121_506.returns.push(null);
// 37456
f81632121_506.returns.push(null);
// 37462
f81632121_506.returns.push(null);
// 37468
f81632121_506.returns.push(null);
// 37474
f81632121_506.returns.push(null);
// 37480
f81632121_506.returns.push(null);
// 37486
f81632121_506.returns.push(null);
// 37492
f81632121_506.returns.push(null);
// 37498
f81632121_506.returns.push(null);
// 37504
f81632121_506.returns.push(null);
// 37510
f81632121_506.returns.push(null);
// 37516
f81632121_506.returns.push(null);
// 37521
o1.cancelBubble = false;
// 37522
o1.returnValue = true;
// undefined
o1 = null;
// 37523
o1 = {};
// 37526
o1.cancelBubble = false;
// 37529
f81632121_467.returns.push(1374851259162);
// 37532
f81632121_1007.returns.push(undefined);
// 37534
o1.returnValue = true;
// 37537
o1.srcElement = o21;
// 37539
o1.target = o21;
// 37546
f81632121_506.returns.push(null);
// 37552
f81632121_506.returns.push(null);
// 37558
f81632121_506.returns.push(null);
// 37564
f81632121_506.returns.push(null);
// 37570
f81632121_506.returns.push(null);
// 37576
f81632121_506.returns.push(null);
// 37582
f81632121_506.returns.push(null);
// 37588
f81632121_506.returns.push(null);
// 37594
f81632121_506.returns.push(null);
// 37600
f81632121_506.returns.push(null);
// 37606
f81632121_506.returns.push(null);
// 37612
f81632121_506.returns.push(null);
// 37618
f81632121_506.returns.push(null);
// 37624
f81632121_506.returns.push(null);
// 37630
f81632121_506.returns.push(null);
// 37636
f81632121_506.returns.push(null);
// 37642
f81632121_506.returns.push(null);
// 37648
f81632121_506.returns.push(null);
// 37654
f81632121_506.returns.push(null);
// 37660
f81632121_506.returns.push(null);
// 37666
f81632121_506.returns.push(null);
// 37671
o1.relatedTarget = o8;
// undefined
o1 = null;
// undefined
o8 = null;
// 37674
o1 = {};
// 37678
f81632121_467.returns.push(1374851259167);
// 37679
o1.cancelBubble = false;
// 37680
o1.returnValue = true;
// 37683
o1.srcElement = o21;
// 37685
o1.target = o21;
// 37692
f81632121_506.returns.push(null);
// 37698
f81632121_506.returns.push(null);
// 37704
f81632121_506.returns.push(null);
// 37710
f81632121_506.returns.push(null);
// 37716
f81632121_506.returns.push(null);
// 37722
f81632121_506.returns.push(null);
// 37728
f81632121_506.returns.push(null);
// 37734
f81632121_506.returns.push(null);
// 37740
f81632121_506.returns.push(null);
// 37746
f81632121_506.returns.push(null);
// 37752
f81632121_506.returns.push(null);
// 37758
f81632121_506.returns.push(null);
// 37764
f81632121_506.returns.push(null);
// 37770
f81632121_506.returns.push(null);
// 37776
f81632121_506.returns.push(null);
// 37782
f81632121_506.returns.push(null);
// 37788
f81632121_506.returns.push(null);
// 37794
f81632121_506.returns.push(null);
// 37800
f81632121_506.returns.push(null);
// 37806
f81632121_506.returns.push(null);
// 37812
f81632121_506.returns.push(null);
// 37817
o1.JSBNG__screenX = 637;
// 37818
o1.JSBNG__screenY = 371;
// 37819
o1.altKey = false;
// 37820
o1.bubbles = true;
// 37821
o1.button = 0;
// 37822
o1.buttons = void 0;
// 37823
o1.cancelable = false;
// 37824
o1.clientX = 569;
// 37825
o1.clientY = 206;
// 37826
o1.ctrlKey = false;
// 37827
o1.currentTarget = o0;
// 37828
o1.defaultPrevented = false;
// 37829
o1.detail = 0;
// 37830
o1.eventPhase = 3;
// 37831
o1.isTrusted = void 0;
// 37832
o1.metaKey = false;
// 37833
o1.pageX = 569;
// 37834
o1.pageY = 592;
// 37835
o1.relatedTarget = null;
// 37836
o1.fromElement = null;
// 37839
o1.shiftKey = false;
// 37842
o1.timeStamp = 1374851259167;
// 37843
o1.type = "mousemove";
// 37844
o1.view = ow81632121;
// undefined
o1 = null;
// 37853
f81632121_1852.returns.push(undefined);
// 37856
f81632121_14.returns.push(undefined);
// 37857
f81632121_12.returns.push(179);
// 37862
o1 = {};
// 37863
f81632121_70.returns.push(o1);
// 37864
// 37865
o1.open = f81632121_1294;
// 37866
f81632121_1294.returns.push(undefined);
// 37867
o1.setRequestHeader = f81632121_1295;
// 37868
f81632121_1295.returns.push(undefined);
// 37870
o1.send = f81632121_1296;
// 37871
f81632121_1296.returns.push(undefined);
// 37872
o8 = {};
// 37873
o24 = {};
// 37875
o8.transport = o1;
// 37876
o1.readyState = 1;
// undefined
fo81632121_1_cookie.returns.push("c_user=100006118350059; csm=2; sub=4096; wd=1034x727");
// 37880
f81632121_467.returns.push(1374851259183);
// 37881
o26 = {};
// 37884
o26.srcElement = o21;
// 37886
o26.target = o21;
// 37893
f81632121_506.returns.push(null);
// 37899
f81632121_506.returns.push(null);
// 37905
f81632121_506.returns.push(null);
// 37911
f81632121_506.returns.push(null);
// 37917
f81632121_506.returns.push(null);
// 37923
f81632121_506.returns.push(null);
// 37929
f81632121_506.returns.push(null);
// 37935
f81632121_506.returns.push(null);
// 37941
f81632121_506.returns.push(null);
// 37947
f81632121_506.returns.push(null);
// 37953
f81632121_506.returns.push(null);
// 37959
f81632121_506.returns.push(null);
// 37965
f81632121_506.returns.push(null);
// 37971
f81632121_506.returns.push(null);
// 37977
f81632121_506.returns.push(null);
// 37983
f81632121_506.returns.push(null);
// 37989
f81632121_506.returns.push(null);
// 37995
f81632121_506.returns.push(null);
// 38001
f81632121_506.returns.push(null);
// 38007
f81632121_506.returns.push(null);
// 38013
f81632121_506.returns.push(null);
// 38018
o29 = {};
// 38019
o26.relatedTarget = o29;
// 38020
o31 = {};
// 38021
o29.parentNode = o31;
// 38022
o29.nodeType = 1;
// 38023
o29.getAttribute = f81632121_506;
// 38025
f81632121_506.returns.push(null);
// 38027
o32 = {};
// 38028
o31.parentNode = o32;
// 38029
o31.nodeType = 1;
// 38030
o31.getAttribute = f81632121_506;
// undefined
o31 = null;
// 38032
f81632121_506.returns.push(null);
// 38034
o32.parentNode = o21;
// 38035
o32.nodeType = 1;
// 38036
o32.getAttribute = f81632121_506;
// undefined
o32 = null;
// 38038
f81632121_506.returns.push(null);
// 38044
f81632121_506.returns.push(null);
// 38050
f81632121_506.returns.push(null);
// 38056
f81632121_506.returns.push(null);
// 38062
f81632121_506.returns.push(null);
// 38068
f81632121_506.returns.push(null);
// 38074
f81632121_506.returns.push(null);
// 38080
f81632121_506.returns.push(null);
// 38086
f81632121_506.returns.push(null);
// 38092
f81632121_506.returns.push(null);
// 38098
f81632121_506.returns.push(null);
// 38104
f81632121_506.returns.push(null);
// 38110
f81632121_506.returns.push(null);
// 38116
f81632121_506.returns.push(null);
// 38122
f81632121_506.returns.push(null);
// 38128
f81632121_506.returns.push(null);
// 38134
f81632121_506.returns.push(null);
// 38140
f81632121_506.returns.push(null);
// 38146
f81632121_506.returns.push(null);
// 38152
f81632121_506.returns.push(null);
// 38158
f81632121_506.returns.push(null);
// 38164
f81632121_506.returns.push(null);
// 38169
o26.cancelBubble = false;
// 38170
o26.returnValue = true;
// undefined
o26 = null;
// 38171
o26 = {};
// 38174
o26.cancelBubble = false;
// 38177
f81632121_467.returns.push(1374851259202);
// 38180
f81632121_1007.returns.push(undefined);
// 38182
o26.returnValue = true;
// 38185
o26.srcElement = o29;
// 38187
o26.target = o29;
// 38194
f81632121_506.returns.push(null);
// 38200
f81632121_506.returns.push(null);
// 38206
f81632121_506.returns.push(null);
// 38212
f81632121_506.returns.push(null);
// 38218
f81632121_506.returns.push(null);
// 38224
f81632121_506.returns.push(null);
// 38230
f81632121_506.returns.push(null);
// 38236
f81632121_506.returns.push(null);
// 38242
f81632121_506.returns.push(null);
// 38248
f81632121_506.returns.push(null);
// 38254
f81632121_506.returns.push(null);
// 38260
f81632121_506.returns.push(null);
// 38266
f81632121_506.returns.push(null);
// 38272
f81632121_506.returns.push(null);
// 38278
f81632121_506.returns.push(null);
// 38284
f81632121_506.returns.push(null);
// 38290
f81632121_506.returns.push(null);
// 38296
f81632121_506.returns.push(null);
// 38302
f81632121_506.returns.push(null);
// 38308
f81632121_506.returns.push(null);
// 38314
f81632121_506.returns.push(null);
// 38320
f81632121_506.returns.push(null);
// 38326
f81632121_506.returns.push(null);
// 38332
f81632121_506.returns.push(null);
// 38337
o26.relatedTarget = o21;
// undefined
o26 = null;
// 38340
o26 = {};
// 38344
f81632121_467.returns.push(1374851259216);
// 38345
o26.cancelBubble = false;
// 38346
o26.returnValue = true;
// 38349
o26.srcElement = o29;
// 38351
o26.target = o29;
// 38358
f81632121_506.returns.push(null);
// 38364
f81632121_506.returns.push(null);
// 38370
f81632121_506.returns.push(null);
// 38376
f81632121_506.returns.push(null);
// 38382
f81632121_506.returns.push(null);
// 38388
f81632121_506.returns.push(null);
// 38394
f81632121_506.returns.push(null);
// 38400
f81632121_506.returns.push(null);
// 38406
f81632121_506.returns.push(null);
// 38412
f81632121_506.returns.push(null);
// 38418
f81632121_506.returns.push(null);
// 38424
f81632121_506.returns.push(null);
// 38430
f81632121_506.returns.push(null);
// 38436
f81632121_506.returns.push(null);
// 38442
f81632121_506.returns.push(null);
// 38448
f81632121_506.returns.push(null);
// 38454
f81632121_506.returns.push(null);
// 38460
f81632121_506.returns.push(null);
// 38466
f81632121_506.returns.push(null);
// 38472
f81632121_506.returns.push(null);
// 38478
f81632121_506.returns.push(null);
// 38484
f81632121_506.returns.push(null);
// 38490
f81632121_506.returns.push(null);
// 38496
f81632121_506.returns.push(null);
// 38501
o26.JSBNG__screenX = 686;
// 38502
o26.JSBNG__screenY = 391;
// 38503
o26.altKey = false;
// 38504
o26.bubbles = true;
// 38505
o26.button = 0;
// 38506
o26.buttons = void 0;
// 38507
o26.cancelable = false;
// 38508
o26.clientX = 618;
// 38509
o26.clientY = 226;
// 38510
o26.ctrlKey = false;
// 38511
o26.currentTarget = o0;
// 38512
o26.defaultPrevented = false;
// 38513
o26.detail = 0;
// 38514
o26.eventPhase = 3;
// 38515
o26.isTrusted = void 0;
// 38516
o26.metaKey = false;
// 38517
o26.pageX = 618;
// 38518
o26.pageY = 612;
// 38519
o26.relatedTarget = null;
// 38520
o26.fromElement = null;
// 38523
o26.shiftKey = false;
// 38526
o26.timeStamp = 1374851259216;
// 38527
o26.type = "mousemove";
// 38528
o26.view = ow81632121;
// undefined
o26 = null;
// 38537
f81632121_1852.returns.push(undefined);
// 38540
f81632121_14.returns.push(undefined);
// 38541
f81632121_12.returns.push(180);
// 38544
o26 = {};
// 38547
o26.srcElement = o29;
// 38549
o26.target = o29;
// 38556
f81632121_506.returns.push(null);
// 38562
f81632121