/******************************************************************************
 *  Copyright (c) 2011 SeaChange International (SeaChange) and its Licensors.
 *  Copyright (C) 2017 Broadcom. The term "Broadcom" refers to Broadcom Limited and/or its subsidiaries.
 *
 *  This program is the proprietary software of Broadcom and/or its licensors,
 *  and may only be used, duplicated, modified or distributed pursuant to the terms and
 *  conditions of a separate, written license agreement executed between you and Broadcom
 *  (an "Authorized License").  Except as set forth in an Authorized License, Broadcom grants
 *  no license (express or implied), right to use, or waiver of any kind with respect to the
 *  Software, and Broadcom expressly reserves all rights in and to the Software and all
 *  intellectual property rights therein.  IF YOU HAVE NO AUTHORIZED LICENSE, THEN YOU
 *  HAVE NO RIGHT TO USE THIS SOFTWARE IN ANY WAY, AND SHOULD IMMEDIATELY
 *  NOTIFY BROADCOM AND DISCONTINUE ALL USE OF THE SOFTWARE.
 *
 *  Except as expressly set forth in the Authorized License,
 *
 *  1.     This program, including its structure, sequence and organization, constitutes the valuable trade
 *  secrets of Broadcom, and you shall use all reasonable efforts to protect the confidentiality thereof,
 *  and to use this information only in connection with your use of Broadcom integrated circuit products.
 *
 *  2.     TO THE MAXIMUM EXTENT PERMITTED BY LAW, THE SOFTWARE IS PROVIDED "AS IS"
 *  AND WITH ALL FAULTS AND BROADCOM MAKES NO PROMISES, REPRESENTATIONS OR
 *  WARRANTIES, EITHER EXPRESS, IMPLIED, STATUTORY, OR OTHERWISE, WITH RESPECT TO
 *  THE SOFTWARE.  BROADCOM SPECIFICALLY DISCLAIMS ANY AND ALL IMPLIED WARRANTIES
 *  OF TITLE, MERCHANTABILITY, NONINFRINGEMENT, FITNESS FOR A PARTICULAR PURPOSE,
 *  LACK OF VIRUSES, ACCURACY OR COMPLETENESS, QUIET ENJOYMENT, QUIET POSSESSION
 *  OR CORRESPONDENCE TO DESCRIPTION. YOU ASSUME THE ENTIRE RISK ARISING OUT OF
 *  USE OR PERFORMANCE OF THE SOFTWARE.
 *
 *  3.     TO THE MAXIMUM EXTENT PERMITTED BY LAW, IN NO EVENT SHALL BROADCOM OR ITS
 *  LICENSORS BE LIABLE FOR (i) CONSEQUENTIAL, INCIDENTAL, SPECIAL, INDIRECT, OR
 *  EXEMPLARY DAMAGES WHATSOEVER ARISING OUT OF OR IN ANY WAY RELATING TO YOUR
 *  USE OF OR INABILITY TO USE THE SOFTWARE EVEN IF BROADCOM HAS BEEN ADVISED OF
 *  THE POSSIBILITY OF SUCH DAMAGES; OR (ii) ANY AMOUNT IN EXCESS OF THE AMOUNT
 *  ACTUALLY PAID FOR THE SOFTWARE ITSELF OR U.S. $1, WHICHEVER IS GREATER. THESE
 *  LIMITATIONS SHALL APPLY NOTWITHSTANDING ANY FAILURE OF ESSENTIAL PURPOSE OF
 *  ANY LIMITED REMEDY.
 ******************************************************************************/

#include <string.h>

#include "vlHalSnmpAvOutInterface.h"
#include "vlHalSnmpHdmiInterface.h"
//#include "vlMpeosDispImpl.h"
//#include "vlSmdLoggerDefs.h"

#include "vlHalSnmpUtils.h"
#include "sys_init.h"
#include <rdk_debug.h>
#include "vlEnv.h"

#include "nexus_platform.h"
#include "nexus_display.h"
#include "nexus_video_window.h"
#include "nexus_video_input.h"
#include "nexus_video_decoder_extra.h"

#include "nexus_video_types.h"
#include "nexus_hdmi_output_hdcp.h"


#ifdef RDK_USE_NXCLIENT
#include <nxclient.h>
#endif

// gtena: define module tag with HAL Media
#define __MTAG__ VL_HALMEDIA

#define vlMemSet(p,v,s,t) memset(p,v,s)
unsigned int HAL_SNMP_Get_DviHdmi_info(SNMP_INTF_DVIHDMI_Info* ptDviHdmiInfo)
{
	int	retStatus = 1;

	if(ptDviHdmiInfo != NULL)
        vl_Get_DviHdmi_info(ptDviHdmiInfo);

	return retStatus;
}

unsigned int HAL_SNMP_ocStbHostDVIHDMIVideoFormatTableData(SNMPocStbHostDVIHDMIVideoFormatTable_t* vl_DVIHDMIVideoFormatTable, int *pnCount)
{
	int	retStatus = 1;
	if((vl_DVIHDMIVideoFormatTable != NULL) && (NULL != pnCount))
    {
        //TODO
        *pnCount = 0;
    }
	return retStatus;
}

#if 0 //not required for BroadCom
rmf_Error vlDisp_HdmiReadEdidBlock(int * pnBytes, unsigned char * pBytes, int nCapacity)
{
    gdl_ret_t rc = GDL_SUCCESS;
    gdl_hdmi_edid_block_t eb = { 0};
    unsigned int j, n;
    int iByte = 0;
    
    if((NULL == pnBytes) || (NULL == pBytes)) return RMF_OSAL_EINVAL;
    if(nCapacity > 0) *pnBytes = iByte;

    // Read first block
    if (gdl_port_recv(GDL_PD_ID_HDMI,
                      GDL_PD_RECV_HDMI_EDID_BLOCK,
                      (void *) &eb,
                       sizeof(gdl_hdmi_edid_block_t)) != GDL_SUCCESS)
    {
        RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.DISP","%s : EDID can not be read\n", __FUNCTION__);
    }
    else
    {
        // Determine total number of blocks
        n = eb.data[126] + 1;

        // Read and print all EDID blocks
        for (eb.index = 0; eb.index < n; eb.index++)
        {
            rc = gdl_port_recv(GDL_PD_ID_HDMI,
                               GDL_PD_RECV_HDMI_EDID_BLOCK,
                               (void *) &eb,
                               sizeof(gdl_hdmi_edid_block_t));

            if (rc == GDL_SUCCESS)
            {
                for (j = 0; j < sizeof(eb.data); j++)
                {
                    if(iByte < nCapacity)
                    {
                        pBytes[iByte] = eb.data[j];
                        iByte++;
                    }
                    else
                    {
                        break;
                    }
                }
            }
            else
            {
                break;
            }
        }
    }
    
    RDK_LOG(RDK_LOG_INFO, "LOG.RDK.DISP","%s : returning %d bytes of EDID data\n", __FUNCTION__, iByte);
    *pnBytes = iByte;
    if(iByte > 0) return RMF_SUCCESS;
    
    return RMF_OSAL_ENODATA;
}
#endif

unsigned int HAL_SNMP_Get_Display_Handle_Count(unsigned int* ptDispHandleCount)
{
	unsigned int retStatus;

	unsigned int maxDispHandles = 0;
	/*   todo  Abdu starts:  hardcoded based on this function implementation*/
#define MAX_DISPLAY_HANDLE 1
       maxDispHandles = MAX_DISPLAY_HANDLE;
       retStatus = 0;
//	retStatus = vl__Get_Display_Handle_Count(&maxDispHandles); 
	/*   todo  Abdu ends:  hardcoded based on this function implementation*/
	*ptDispHandleCount = maxDispHandles;

	return retStatus;

}

unsigned int HAL_SNMP_Get_Display_Handles(unsigned long* ptDispHandles, unsigned int maxNumOfDiplays)
{
	unsigned int retStatus;
	unsigned long dispHandles[maxNumOfDiplays];
       /* todo Abdu: commented as its outputs are not used, to avoid dependencies  */
//	retStatus = vl__Get_Display_Handles(dispHandles, maxNumOfDiplays);
	//TODO copy it to ptDispHandles
	return 0;
}

unsigned int HAL_SNMP_Get_AvOut_Info(void* ptAVOutInterfaceInfo, unsigned int maxNumOfDiplays)
{

	unsigned int retStatus;
	unsigned int dispIter;
	unsigned int portIter;
	const char *isAnaPortSupport = "NULL";
	char szFeature[] = {"AV.ANALOG.PORTS.SUPPORT"};
	
	HAL_SNMP_AVOutInterfaceInfo objAVOutInterfaceInfo[maxNumOfDiplays];
	memset(objAVOutInterfaceInfo, 0, sizeof(HAL_SNMP_AVOutInterfaceInfo)*maxNumOfDiplays);

	//isAnaPortSupport = mpeos_envGet("AV.ANALOG.PORTS.SUPPORT");

	// if isAnaPortSupport is FALSE only digital ports are supported, other wise both analog and digital ports are supported.

	//if(strcmp(isAnaPortSupport,"FALSE") == 0)
	if(!vl_env_get_bool(false, szFeature))
	{
	 	for(dispIter=0; dispIter<maxNumOfDiplays; dispIter++)
		{
			objAVOutInterfaceInfo[dispIter].numAvOutPorts = HAL_AV_PORT_MAX - HAL_AV_PORT_COMPONENT;
	
			for(portIter=0 ; portIter<(HAL_AV_PORT_MAX - HAL_AV_PORT_COMPONENT); portIter++)
			{
				objAVOutInterfaceInfo[dispIter].avOutPortInfo[portIter].portStatus = HAL_AV_PORT_STATUS_ENABLED;
	
				objAVOutInterfaceInfo[dispIter].avOutPortInfo[portIter].avOutPortType = (HAL_SNMP_AV_PORT_TYPE) (HAL_AV_PORT_COMPONENT+portIter);
	
				objAVOutInterfaceInfo[dispIter].avOutPortInfo[portIter].deviceIndex = portIter;
			}
		}
	}
	else
	{
		for(dispIter=0; dispIter<maxNumOfDiplays; dispIter++)
		{
			objAVOutInterfaceInfo[dispIter].numAvOutPorts = HAL_AV_PORT_MAX;
	
			for(portIter=0 ; portIter<HAL_AV_PORT_MAX; portIter++)
			{
				objAVOutInterfaceInfo[dispIter].avOutPortInfo[portIter].portStatus = HAL_AV_PORT_STATUS_ENABLED;
	
				objAVOutInterfaceInfo[dispIter].avOutPortInfo[portIter].avOutPortType = (HAL_SNMP_AV_PORT_TYPE)(HAL_AV_PORT_COMPOSITE+portIter);
	
				objAVOutInterfaceInfo[dispIter].avOutPortInfo[portIter].deviceIndex = portIter;
			}
		}
	
	}

	if(ptAVOutInterfaceInfo != NULL)
		memcpy((void*)ptAVOutInterfaceInfo, objAVOutInterfaceInfo, sizeof(HAL_SNMP_AVOutInterfaceInfo)*maxNumOfDiplays);

	return 1;

	
}

typedef enum _mpe_MediaAspectRatio
{
    MPE_ASPECT_RATIO_UNKNOWN = -1,
    MPE_ASPECT_RATIO_4_3 = 2,
    MPE_ASPECT_RATIO_16_9,
    MPE_ASPECT_RATIO_2_21_1
} mpe_MediaAspectRatio;

unsigned int HAL_SNMP_Get_ComponentVideo_info(void* pComponentInfo)
{
	unsigned int retStatus = 1;
    HAL_SNMP_ComponentVideoTable_t* ptComponentInfo;
	NEXUS_Error	 rc;
	
	ptComponentInfo = (HAL_SNMP_ComponentVideoTable_t*)pComponentInfo;
    NxClient_DisplaySettings displaysettings;
	NxClient_ComponentStatus componentSettings;

 	if(pComponentInfo == NULL)
	   return 0;
	componentSettings.format = NEXUS_VideoFormat_eUnknown;
	componentSettings.aspectRatio = NEXUS_DisplayAspectRatio_eMax;
    NxClient_GetComponentStatus(&componentSettings);
	RDK_LOG(RDK_LOG_INFO,"LOG.RDK.SNMP","componentSettings.format %d componentSettings.aspectRatio %d componentSettings.muted %d\n",componentSettings.format,componentSettings.aspectRatio,componentSettings.mute);
 

	NxClient_GetDisplaySettings(&displaysettings);
	RDK_LOG(RDK_LOG_INFO,"LOG.RDK.SNMP","displaysettings.aspectration %d displaysettings.format %d \n",displaysettings.aspectRatio ,displaysettings.format);
	
	switch(displaysettings.format)
 	{
	case NEXUS_VideoFormat_eNtsc:      
 		ptComponentInfo->ComponentOutputFormat = COMPONENTOPFORMAT_480I;
		if (displaysettings.aspectRatio == NEXUS_DisplayAspectRatio_eAuto)
			ptComponentInfo->ComponentAspectRatio = COMPONENTASPECTRATIO_FOURBYTHREE;
		break;
	case NEXUS_VideoFormat_e480p:      
 		ptComponentInfo->ComponentOutputFormat = COMPONENTOPFORMAT_480P;		
		if (displaysettings.aspectRatio == NEXUS_DisplayAspectRatio_eAuto)
			ptComponentInfo->ComponentAspectRatio = COMPONENTASPECTRATIO_FOURBYTHREE;
		break;
	case NEXUS_VideoFormat_e720p:          
	case NEXUS_VideoFormat_e720p50hz:
	case NEXUS_VideoFormat_e720p24hz:
	case NEXUS_VideoFormat_e720p25hz:
	case NEXUS_VideoFormat_e720p30hz:
 		ptComponentInfo->ComponentOutputFormat = COMPONENTOPFORMAT_720P;		
		if (displaysettings.aspectRatio == NEXUS_DisplayAspectRatio_eAuto)
			ptComponentInfo->ComponentAspectRatio = COMPONENTASPECTRATIO_SIXTEENBYNINE;
		break;
	case NEXUS_VideoFormat_e1080i:                                         
	case NEXUS_VideoFormat_e1080i50hz:
 		ptComponentInfo->ComponentOutputFormat = COMPONENTOPFORMAT_1080I;		
		if (displaysettings.aspectRatio == NEXUS_DisplayAspectRatio_eAuto)
			ptComponentInfo->ComponentAspectRatio = COMPONENTASPECTRATIO_SIXTEENBYNINE;
		break;
	case NEXUS_VideoFormat_e1080p24hz:      
	case NEXUS_VideoFormat_e1080p25hz:                  
	case NEXUS_VideoFormat_e1080p30hz:                  
	case NEXUS_VideoFormat_e1080p50hz:                
	case NEXUS_VideoFormat_e1080p60hz:
 		ptComponentInfo->ComponentOutputFormat = COMPONENTOPFORMAT_1080P;		
		if (displaysettings.aspectRatio == NEXUS_DisplayAspectRatio_eAuto)
			ptComponentInfo->ComponentAspectRatio = COMPONENTASPECTRATIO_SIXTEENBYNINE;
		break;                
    case NEXUS_VideoFormat_e3840x2160p24hz: /* fallthrough */
    case NEXUS_VideoFormat_e3840x2160p25hz: /* fallthrough */
    case NEXUS_VideoFormat_e3840x2160p30hz: /* fallthrough */
    case NEXUS_VideoFormat_e3840x2160p50hz: /* fallthrough */
    case NEXUS_VideoFormat_e3840x2160p60hz: 
        ptComponentInfo->ComponentOutputFormat = COMPONENTOPFORMAT_2160P;		
        if (displaysettings.aspectRatio == NEXUS_DisplayAspectRatio_eAuto)
            ptComponentInfo->ComponentAspectRatio = COMPONENTASPECTRATIO_SIXTEENBYNINE;
        break;                
	default:
 		ptComponentInfo->ComponentOutputFormat = COMPONENTOPFORMAT_INVALID;
		break;
	}
	switch(displaysettings.aspectRatio)
	{
	case  NEXUS_DisplayAspectRatio_e4x3:
		ptComponentInfo->ComponentAspectRatio = COMPONENTASPECTRATIO_FOURBYTHREE;
		break;
	case  NEXUS_DisplayAspectRatio_e16x9:
		ptComponentInfo->ComponentAspectRatio = COMPONENTASPECTRATIO_SIXTEENBYNINE;                    
		break;
	case  NEXUS_DisplayAspectRatio_eAuto:		
		break;
	default:
		ptComponentInfo->ComponentAspectRatio = COMPONENTASPECTRATIO_OTHER;                            
		break;
	}             
	ptComponentInfo->ComponentVideoMuteStatus = componentSettings.mute;
	ptComponentInfo->ComponentVideoConstrainedStatus = componentSettings.mpaaDecimationEnabled;

	return retStatus;

}

unsigned int HAL_SNMP_Get_Mpeg2Content_info(void* pMpeg2ContentInfo)
{
	unsigned int retStatus = 1;
	HAL_SNMP_Mpeg2ContentTable_t* ptMpeg2ContentInfo;
	ptMpeg2ContentInfo = (HAL_SNMP_Mpeg2ContentTable_t*)pMpeg2ContentInfo;

	if(pMpeg2ContentInfo == NULL)
		return 0;

	long long currStreamPosition = 0;
	long long linearTime = 0; 
	long long nextLinearTime = 0;
	unsigned int listSize = 0;
	unsigned int listIter = 0;
	ConnDetails connDetails;

	memset(&connDetails, 0, sizeof(ConnDetails));
	GetConnListSize(&listSize);
	
	for(listIter=0;	listIter<listSize; listIter++)
	{
		GetConnListElement(&connDetails, listIter);
		if(connDetails.isDecode)
			break;
	}
    
    ptMpeg2ContentInfo->transportStreamID = 0;
    if(connDetails.isDecode)
    {
//        MPE_DIAG_TRANSPORT_STREAM_ID transportStreamId;
        unsigned long m_nTsId = 0;		
//        vlMemSet(&transportStreamId, 0, sizeof(transportStreamId), sizeof(transportStreamId));
        /*  todo Abdu: The podimpl call is returning success  without updating the arg, so commenting */ 
//        if(MPE_SUCCESS == mpe_diagGetGenericInfo(MPE_DIAG_INFO_TYPE_TRANSPORT_STREAM_ID, &transportStreamId))
        {
            ptMpeg2ContentInfo->transportStreamID	= m_nTsId;
        }
    }
     /*  todo abdu: commented out for testing   */
    //vlMpeosUpdatePcrStats(&connDetails);

	ptMpeg2ContentInfo->index		= connDetails.devIndex;
	ptMpeg2ContentInfo->programNumber	= connDetails.programNum;
	ptMpeg2ContentInfo->totalStreams	= 1;
	ptMpeg2ContentInfo->selectedVideoPID	= connDetails.videoPid;
	ptMpeg2ContentInfo->selectedAudioPID	= connDetails.audioPid;
	ptMpeg2ContentInfo->otherAudioPIDs	= 1;
	ptMpeg2ContentInfo->cciValue		= CCI_COPYFREELY;
	ptMpeg2ContentInfo->apsValue		= APSVALUE_TYPE1;
	ptMpeg2ContentInfo->citStatus		= 1;
	ptMpeg2ContentInfo->broadcastFlagStatus	= 1;
	ptMpeg2ContentInfo->epnStatus		= 1;
	ptMpeg2ContentInfo->pcrPID		= connDetails.pcrPid;
	ptMpeg2ContentInfo->PCRLockStatus	= (HAL_SNMP_Mpeg2ContentPCRLockStatus_t)connDetails.pcrlockStatus;
       /*  todo Abdu: may not applicable now  */
	//vlDisp_GetStreamPosition(&currStreamPosition, &linearTime, &nextLinearTime);
	ptMpeg2ContentInfo->decoderPTS		= currStreamPosition;
	ptMpeg2ContentInfo->discontinuities	= connDetails.dcontinuities;
	ptMpeg2ContentInfo->pktErrors		= connDetails.ContentPktErrors;
	ptMpeg2ContentInfo->pipelineErrors	= connDetails.ContentPipelineErrors;
	ptMpeg2ContentInfo->decoderRestarts     = 0;
	ptMpeg2ContentInfo->LTSID               = connDetails.tunerLTSID;

	return retStatus;
	
}

unsigned int HAL_SNMP_Get_RFChan_info()
{
	unsigned int retStatus = 1;

	return retStatus;
}

unsigned int HAL_SNMP_Get_AnalogVideo_info()
{
	unsigned int retStatus = 1;

	return retStatus;
}

unsigned int HAL_SNMP_Get_Spdif_info(void *pSpdifInfo)
{
    unsigned int retStatus = 1;

#ifdef RDK_USE_NXCLIENT
    NEXUS_Error rc;
    NxClient_AudioSettings audioSettings;
    NxClient_AudioStatus audioStatus;
    NxClient_DisplayStatus dispStatus;
    AUDIO_FMT_t getConvertedAudioFormat(NEXUS_AudioCodec audioformat);

    rc = NxClient_GetAudioStatus(&audioStatus);
    if(rc == NEXUS_SUCCESS) 
    {
        RDK_LOG(RDK_LOG_INFO,"LOG.RDK.SNMP","NEXUS.audioStatus.hdmi.outputCodec %d\n",audioStatus.hdmi.outputCodec);
        RDK_LOG(RDK_LOG_INFO,"LOG.RDK.SNMP","NEXUS.audioStatus.dac.outputCodec %d\n",audioStatus.dac.outputCodec);
        RDK_LOG(RDK_LOG_INFO,"LOG.RDK.SNMP","NEXUS.audioStatus.spdif.outputCodec %d\n",audioStatus.spdif.outputCodec);
    }
    else
    {
        RDK_LOG(RDK_LOG_INFO,"LOG.RDK.SNMP","NEXUS.audioStatus err %d\n",rc);
        audioStatus.hdmi.outputCodec = NEXUS_AudioCodec_eUnknown;
        audioStatus.dac.outputCodec = NEXUS_AudioCodec_eUnknown;
        audioStatus.spdif.outputCodec = NEXUS_AudioCodec_eUnknown;
    }
    
    ((HAL_SNMP_SpdifTable_t *)pSpdifInfo)->audioMuteStatus = 1;
    if (audioStatus.spdif.outputCodec == NEXUS_AudioCodec_ePcm)
    {
        NxClient_GetAudioSettings(&audioSettings);
      #if (NEXUS_PLATFORM_VERSION_MAJOR >= 17)
      {
        NxClient_DisplaySettings displaySettings;
        NxClient_GetDisplaySettings(&displaySettings);
        RDK_LOG(RDK_LOG_INFO,"LOG.RDK.SNMP","HDMI active:%d audioSettings.muted:%d \n",displaySettings.hdmiPreferences.enabled,audioSettings.muted);
        ((HAL_SNMP_SpdifTable_t *)pSpdifInfo)->audioMuteStatus = (unsigned long)((!displaySettings.hdmiPreferences.enabled) | audioSettings.muted);
      }
      #else
      {
        NxClient_GetDisplayStatus(&dispStatus);
        RDK_LOG(RDK_LOG_INFO,"LOG.RDK.SNMP","bVideoOutputConnected:%d audioSettings.muted:%d \n",dispStatus.bVideoOutputConnected,audioSettings.muted);
        ((HAL_SNMP_SpdifTable_t *)pSpdifInfo)->audioMuteStatus = (unsigned long)((!dispStatus.bVideoOutputConnected) | audioSettings.muted);
      }
      #endif
    }
    ((HAL_SNMP_SpdifTable_t *)pSpdifInfo)->audioFormat = getConvertedAudioFormat(audioStatus.spdif.outputCodec);
    RDK_LOG(RDK_LOG_INFO,"LOG.RDK.SNMP","spdif.audioFormat %d\n",((HAL_SNMP_SpdifTable_t *)pSpdifInfo)->audioFormat);
    RDK_LOG(RDK_LOG_INFO,"LOG.RDK.SNMP","spdif.audioMuteStatus %d\n",((HAL_SNMP_SpdifTable_t *)pSpdifInfo)->audioMuteStatus);
#else
    RDK_LOG(RDK_LOG_INFO,"LOG.RDK.SNMP","RDK_USE_NXCLIENT is not defined");
#endif

    return retStatus;
}

DISPLAY_ASPECT_RATIO_t getConvertedAspectRatio(NEXUS_AspectRatio aspectRatio)
{
        DISPLAY_ASPECT_RATIO_t dispAspectRatio = ASPECT_RATIO_UNKNOWN;
        switch(aspectRatio)
        {
                case NEXUS_AspectRatio_eUnknown:
                {
                        dispAspectRatio = ASPECT_RATIO_UNKNOWN;
                }
                break;
                case NEXUS_AspectRatio_eSquarePixel: //This is equivalent to NEXUS_AspectRatio_eSar 1:1
                {
                        dispAspectRatio = ASPECT_RATIO_UNKNOWN;
                }
                break;
                case NEXUS_AspectRatio_e4x3:
                {
                        dispAspectRatio = ASPECT_RATIO_4_3;
                }
                break;
                case NEXUS_AspectRatio_e16x9:
                {
                        dispAspectRatio = ASPECT_RATIO_16_9;
                }
                break;
                case NEXUS_AspectRatio_e221x1: //2.21:1
                {
                        dispAspectRatio = ASPECT_RATIO_2_21_1;
                }
                break;
                case NEXUS_AspectRatio_e15x9:
                {
                        dispAspectRatio = ASPECT_RATIO_UNKNOWN;
                }
                break;
                case NEXUS_AspectRatio_eSar:
                {
                        dispAspectRatio = ASPECT_RATIO_UNKNOWN;
                }
                break;
                case NEXUS_AspectRatio_eMax:
                default:
                {
                        dispAspectRatio = MAX_ASPECT_RATIO;
                }
                break;
        }

        return dispAspectRatio;
}

DISPLAY_FORMAT_t getConvertedVideoFormat(NEXUS_VideoFormat videoFormat)
{
        DISPLAY_FORMAT_t dispVideoFormat = DISP_INVALID_FORMAT;
        switch(videoFormat)
        {
            case NEXUS_VideoFormat_eUnknown:
                dispVideoFormat = DISP_INVALID_FORMAT;
			    break;
            case NEXUS_VideoFormat_eNtsc:
	            dispVideoFormat = DISP_FORMAT_480I;
	            break;
            case NEXUS_VideoFormat_e480p:
                dispVideoFormat = DISP_FORMAT_480P;
                break;
            case NEXUS_VideoFormat_e720p:
            case NEXUS_VideoFormat_e720p24hz:
            case NEXUS_VideoFormat_e720p25hz:
            case NEXUS_VideoFormat_e720p30hz:
            case NEXUS_VideoFormat_e720p50hz:
                dispVideoFormat = DISP_FORMAT_720P;
                break;
            case NEXUS_VideoFormat_e1080i:
            case NEXUS_VideoFormat_e1080i50hz:
                dispVideoFormat = DISP_FORMAT_1080I;
                break;
            case NEXUS_VideoFormat_e1080p24hz:
            case NEXUS_VideoFormat_e1080p25hz:
            case NEXUS_VideoFormat_e1080p30hz:
            case NEXUS_VideoFormat_e1080p50hz:
            case NEXUS_VideoFormat_e1080p60hz:
                dispVideoFormat = DISP_FORMAT_1080P;
                break;
            case NEXUS_VideoFormat_e3840x2160p24hz: /* fallthrough */
            case NEXUS_VideoFormat_e3840x2160p25hz: /* fallthrough */
            case NEXUS_VideoFormat_e3840x2160p30hz: /* fallthrough */
            case NEXUS_VideoFormat_e3840x2160p50hz: /* fallthrough */
            case NEXUS_VideoFormat_e3840x2160p60hz: 
                dispVideoFormat = DISP_FORMAT_2160P;
                break;
            default:
                dispVideoFormat = DISP_MAX_DISPLAY_FORMAT;
                break;
        }

        return dispVideoFormat;
}

HDMI_AVIFRAME_COLOR_SPACE getConvertedColorSpace(NEXUS_ColorSpace colorspace)
{
        HDMI_AVIFRAME_COLOR_SPACE aviColorSpace = HDMI_AVIFRAME_COLOR_SPACE_RSVD;

        switch(colorspace)
        {
                case NEXUS_ColorSpace_eRgb:
                {
                        aviColorSpace = HDMI_AVIFRAME_COLOR_SPACE_RGB;
                }
                break;
                case NEXUS_ColorSpace_eYCbCr422:
                {
                        aviColorSpace = HDMI_AVIFRAME_COLOR_SPACE_YCbCr422;
                }
                break;
                case NEXUS_ColorSpace_eYCbCr444:
                {
                        aviColorSpace = HDMI_AVIFRAME_COLOR_SPACE_YCbCr444;
                }
                break;
                case NEXUS_ColorSpace_eMax:
                {
                        aviColorSpace = HDMI_AVIFRAME_COLOR_SPACE_RSVD;
                }
                break;
                default:
                {
                        aviColorSpace = HDMI_AVIFRAME_COLOR_SPACE_RSVD;
                }
                break;
        }

        return aviColorSpace;
}

AUDIO_FMT_t getConvertedAudioFormat(NEXUS_AudioCodec audioformat)
{
        AUDIO_FMT_t audioFormat = AUDIO_FMT_OTHER;

        switch(audioformat)
        {
                case NEXUS_AudioCodec_eUnknown:
                {
                        audioFormat = AUDIO_FMT_OTHER;
                }
                break;
                case NEXUS_AudioCodec_eMpeg:
                {
                        audioFormat = AUDIO_FMT_MPEG12;
                }
                break;
                case NEXUS_AudioCodec_eMp3:
                {
                        audioFormat = AUDIO_FMT_MP3;
                }
                break;
                case NEXUS_AudioCodec_eAac:
                {
                        audioFormat = AUDIO_FMT_AAC;
                }
                break;
                case NEXUS_AudioCodec_eAacPlus:
                {
                        audioFormat = AUDIO_FMT_AAC_PLUS;
                }
                break;
                case NEXUS_AudioCodec_eAc3:
                {
                        audioFormat = AUDIO_FMT_AC3;
                }
                break;
                case NEXUS_AudioCodec_eAc3Plus:
                {
                        audioFormat = AUDIO_FMT_AC3_PLUS;
                }
                break;
                case NEXUS_AudioCodec_eDts:
                {
                        audioFormat = AUDIO_FMT_DTS;
                }
                break;
                case NEXUS_AudioCodec_ePcm:
                {
                        audioFormat = AUDIO_FMT_LPCM;
                }
                break;
                default:
                {
                        audioFormat = AUDIO_FMT_OTHER;
                }
                break;
        }

        return audioFormat;
}

AUDIO_Sample_Rate_t getConvertedAudioSamplingRate(unsigned samplingRate)
{
        AUDIO_Sample_Rate_t audioSamplingRate = AUDIO_Sample_Rate_Other;

        switch(samplingRate)
        {
                case 32000:
                {
                        audioSamplingRate = AUDIO_Sample_Rate_32kHz;
                }
                break;
                case 44100:
                {
                        audioSamplingRate = AUDIO_Sample_Rate_44kHz;
                }
                break;
                case 48000:
                {
                        audioSamplingRate = AUDIO_Sample_Rate_48kHz;
                }
                break;
                case 88200:
                {
                        audioSamplingRate = AUDIO_Sample_Rate_88kHz;
                }
                break;
                case 96000:
                {
                        audioSamplingRate = AUDIO_Sample_Rate_96kHz;
                }
                break;
                case 176400:
                {
                        audioSamplingRate = AUDIO_Sample_Rate_176kHz;
                }
                break;
                case 192000:
                {
                        audioSamplingRate = AUDIO_Sample_Rate_192kHz;
                }
                break;
                default:
                {
                        audioSamplingRate = AUDIO_Sample_Rate_Other;
                }
                break;
        }

        return audioSamplingRate;
}

AUDIO_Sample_Size getConvertedAudioSamplingSize(unsigned samplingSize)
{
        AUDIO_Sample_Size audioSamplingSize = AUDIO_Sample_Size_Unknown;

        switch(samplingSize)
        {
                case 16:
                {
                        audioSamplingSize = AUDIO_Sample_Size_16;
                }
                break;
                case 20:
                {
                        audioSamplingSize = AUDIO_Sample_Size_20;
                }
                break;
                case 24:
                {
                        audioSamplingSize = AUDIO_Sample_Size_24;
                }
                break;
                default:
                {
                        audioSamplingSize = AUDIO_Sample_Size_Unknown;
                }
                break;
        }

        return audioSamplingSize;
}

VIDEO_Frame_Rate getConvertedVideoFrameRate(NEXUS_VideoFrameRate frameRate)
{
        VIDEO_Frame_Rate videoFrameRate = VIDEO_Frame_Rate_unknown;

        switch(frameRate)
        {
                case NEXUS_VideoFrameRate_eUnknown:
                {
                        videoFrameRate = VIDEO_Frame_Rate_unknown;
                }
                break;
                case NEXUS_VideoFrameRate_e23_976:
                {
                        videoFrameRate = VIDEO_Frame_Rate_23_976;
                }
                break;
                case NEXUS_VideoFrameRate_e24:
                {
                        videoFrameRate = VIDEO_Frame_Rate_24;
                }
                break;
                case NEXUS_VideoFrameRate_e25:
                {
                        videoFrameRate = VIDEO_Frame_Rate_25;
                }
                break;
                case NEXUS_VideoFrameRate_e29_97:
                {
                        videoFrameRate = VIDEO_Frame_Rate_29_97;
                }
                break;
                case NEXUS_VideoFrameRate_e30:
                {
                        videoFrameRate = VIDEO_Frame_Rate_30;
                }
                break;
                case NEXUS_VideoFrameRate_e50:
                {
                        videoFrameRate = VIDEO_Frame_Rate_50;
                }
                break;
                case NEXUS_VideoFrameRate_e59_94:
                {
                        videoFrameRate = VIDEO_Frame_Rate_59_94;
                }
                break;
                case NEXUS_VideoFrameRate_e60:
                {
                        videoFrameRate = VIDEO_Frame_Rate_60;
                }
                break;
                case NEXUS_VideoFrameRate_e14_985:
                {
                        videoFrameRate = VIDEO_Frame_Rate_14_985;
                }
                break;
#ifdef LEGACY_NEXUS
                case NEXUS_VideoFrameRate_e7_493:
                {
                        videoFrameRate = VIDEO_Frame_Rate_7_943;
#else
                case NEXUS_VideoFrameRate_e7_493:
                {
                        videoFrameRate = VIDEO_Frame_Rate_7_493;
#endif //LEGACY_NEXUS     
                }
                break;
                case NEXUS_VideoFrameRate_eMax:
                {
                        videoFrameRate = VIDEO_Frame_Rate_Max;
                }
                break;
                default:
                {
                        videoFrameRate = VIDEO_Frame_Rate_unknown;
                }
                break;
        }

        return videoFrameRate;
}

void vl_Get_DviHdmi_info(SNMP_INTF_DVIHDMI_Info* ptDviHdmiInfo)
{
        NEXUS_PlatformConfiguration platformConfig;
        NEXUS_Error result = NEXUS_SUCCESS;
        NEXUS_HdmiOutputHandle hdmiOpHandle = NULL;
        NEXUS_HdmiOutputStatus opStatus;
        /*mpe_MediaAspectRatio  aspectRatio = MPE_ASPECT_RATIO_UNKNOWN;*/
        NEXUS_VideoFrameRate videoFrameRate = NEXUS_VideoFrameRate_eUnknown;
        NEXUS_HdmiOutputEdidBlock edidBlock;
        FILE *fp = NULL;
        char proc_str[200];
        bool video_decoder_started = false;
        bool video_mute = false;
        bool audio_mute = false;

#ifndef RDK_USE_NXCLIENT 
        NEXUS_HdmiOutputHdcpStatus opHdcpStatus;
#else      
        NxClient_HdmiOutputStatus hdmiOutputStatus;
        NxClient_HdmiOutputHdcpStatus hdcpStatus = {.status={.isHdcpRepeater=false}};
        NxClient_HdmiBasicEdidData edidData ={0};
        NxClient_HdmiEdidBlock block;
        NxClient_AudioSettings audioSettings;
        NxClient_DisplayStatus dispStatus;
#endif
        
        RDK_LOG(RDK_LOG_INFO, "LOG.RDK.SNMP", "%s : Entering... \n",__FUNCTION__  );
        vlMemSet(ptDviHdmiInfo, 0, sizeof(SNMP_INTF_DVIHDMI_Info), sizeof(SNMP_INTF_DVIHDMI_Info));
    
#ifndef RDK_USE_NXCLIENT
    
        NEXUS_Platform_GetConfiguration(&platformConfig);
        hdmiOpHandle = platformConfig.outputs.hdmi[0];
        if(hdmiOpHandle != NULL)
                result = NEXUS_HdmiOutput_GetStatus(hdmiOpHandle , &opStatus);
#else
		NxClient_GetHdmiStatus(&hdmiOutputStatus);
		opStatus = hdmiOutputStatus.status;
#endif
        ptDviHdmiInfo->videoFormat = getConvertedVideoFormat(opStatus.videoFormat);
        //ptDviHdmiInfo->preferredVideoFormat = getConvertedVideoFormat(opStatus.preferredVideoFormat);

        ptDviHdmiInfo->aspectRatio = getConvertedAspectRatio(opStatus.aspectRatio);
        ptDviHdmiInfo->colorSpace  = getConvertedColorSpace(opStatus.colorSpace);
        ptDviHdmiInfo->connStatus = opStatus.connected; /*True if device is connected & powered on*/
        ptDviHdmiInfo->isHdmi = opStatus.hdmiDevice;    /* True if HDMI, false if DVI */

		ptDviHdmiInfo->hdcpStatus = true;
		ptDviHdmiInfo->bHDCPEnabled = true;
		ptDviHdmiInfo->connectedDeviceHDCPStatus = HDCP_DEVICE_STATUS_COMPLIANT;
 
#ifndef RDK_USE_NXCLIENT
        if (NEXUS_HdmiOutput_GetHdcpStatus(hdmiOpHandle, &opHdcpStatus) == NEXUS_SUCCESS)
        {   

            switch (opHdcpStatus.hdcpState)
#else
        if ((opStatus.connected) && (NxClient_GetHdcpStatus(&hdcpStatus) == NEXUS_SUCCESS))
        {

            switch (hdcpStatus.status.hdcpState)
#endif            
            {
                case NEXUS_HdmiOutputHdcpState_eLinkAuthenticated:
                case NEXUS_HdmiOutputHdcpState_eEncryptionEnabled:
                    ptDviHdmiInfo->hdcpStatus = true;
                    ptDviHdmiInfo->connectedDeviceHDCPStatus = HDCP_DEVICE_STATUS_COMPLIANT;
                    break;

                case NEXUS_HdmiOutputHdcpState_eUnpowered:
                    if (opStatus.rxPowered){
	                    ptDviHdmiInfo->hdcpStatus = false;
	                    ptDviHdmiInfo->connectedDeviceHDCPStatus = HDCP_DEVICE_STATUS_NON_COMPLIANT;
	                }
                    break;

                case NEXUS_HdmiOutputHdcpState_eR0LinkFailure:
                case NEXUS_HdmiOutputHdcpState_ePjLinkIntegrityFailure:
                case NEXUS_HdmiOutputHdcpState_eRiLinkIntegrityFailure:
                case NEXUS_HdmiOutputHdcpState_eRepeaterAuthenticationFailure:
                case NEXUS_HdmiOutputHdcpState_eUnauthenticated:
                case NEXUS_HdmiOutputHdcpState_eInitializedAuthentication:
                case NEXUS_HdmiOutputHdcpState_eReceiverR0Ready:
                    if (opStatus.rxPowered){
	                    ptDviHdmiInfo->hdcpStatus = false;
	                    ptDviHdmiInfo->connectedDeviceHDCPStatus = HDCP_DEVICE_STATUS_NON_COMPLIANT;
	                }
                    break;  
                default:                        
                    break;
            }
                       
        }
        else
        {    
            RDK_LOG(RDK_LOG_INFO, "LOG.RDK.SNMP", "%s : NEXUS_HdmiOutput_GetHdcpStatus failed \n",__FUNCTION__  );
  
            ptDviHdmiInfo->hdcpStatus = false;
            ptDviHdmiInfo->connectedDeviceHDCPStatus = HDCP_DEVICE_STATUS_NON_COMPLIANT;
        }
        NxClient_IsHdcpEnabled((bool *)&ptDviHdmiInfo->bHDCPEnabled);

        ptDviHdmiInfo->videoXmisStatus = false;
        ptDviHdmiInfo->videoMuteStatus = true;
        ptDviHdmiInfo->audioMuteStatus  = true;
        ptDviHdmiInfo->maxDevCount = 0;
        ptDviHdmiInfo->audioFormat = AUDIO_FMT_OTHER;
        ptDviHdmiInfo->audioSampleRate = AUDIO_Sample_Rate_Other;
        ptDviHdmiInfo->audioSampleSize = AUDIO_Sample_Size_Unknown;
        ptDviHdmiInfo->audioChanCount = 0;

        if((ptDviHdmiInfo->hdcpStatus) && (opStatus.rxPowered))
        {
            ptDviHdmiInfo->maxDevCount = 1;
            ptDviHdmiInfo->audioFormat = getConvertedAudioFormat(opStatus.audioFormat);
            ptDviHdmiInfo->audioSampleRate = getConvertedAudioSamplingRate(opStatus.audioSamplingRate);
            ptDviHdmiInfo->audioSampleSize = getConvertedAudioSamplingSize(opStatus.audioSamplingSize);
            ptDviHdmiInfo->audioChanCount = opStatus.audioChannelCount;

            /* videoXmisStatus  and  videoMuteStatus */
#if (NEXUS_PLATFORM_VERSION_MAJOR>=14)
            system("cat /proc/brcm/video_decoder > /tmp/halsnmp_proc.txt");
#else
            system("cat /proc/brcm/video_status > /tmp/halsnmp_proc.txt");
#endif
            fp = fopen("/tmp/halsnmp_proc.txt", "r");
            if (fp == NULL)
            {
                 RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.SNMP", "%s : /tmp/halsnmp_proc.txt open failed \n",__FUNCTION__ );
            }
            else
            {
                while (fgets(proc_str, sizeof(proc_str)-1, fp) != NULL)
                {
                     if(strstr(proc_str,"started=y") != NULL)
					 {
                         video_decoder_started = true;
                         break;
                     }
                }
                system("cat /dev/null > /tmp/halsnmp_proc.txt");
                fclose(fp);
                fp = NULL;
            }

             /* If video decoder is running check for video window is disabled */
            if(video_decoder_started)
            {
                system("cat /proc/brcm/display > /tmp/halsnmp_proc.txt");
                fp = fopen("/tmp/halsnmp_proc.txt", "r");
                if (fp == NULL)
                {
                     RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.SNMP", "%s : /tmp/halsnmp_proc.txt open failed \n",__FUNCTION__ );
                }
                else
                {
                    while (fgets(proc_str, sizeof(proc_str)-1, fp) != NULL)
                    {
                         if((strstr(proc_str,"visible=0") != NULL) || (strstr(proc_str,"visible=n") != NULL))
                         {
                             video_mute = true;
                         break;
                     }
                }
                    if(!video_mute)
                    {
                         ptDviHdmiInfo->videoXmisStatus = true;
                         ptDviHdmiInfo->videoMuteStatus = false;
                    }
                system("cat /dev/null > /tmp/halsnmp_proc.txt");
                fclose(fp);
                fp = NULL;
            }
            }


            /* audio mute status */
#if (NEXUS_PLATFORM_VERSION_MAJOR>=14)
            system("cat /proc/brcm/audio > /tmp/halsnmp_proc.txt");
#else
            system("cat /proc/brcm/playback > /tmp/halsnmp_proc.txt");
#endif
            fp = fopen("/tmp/halsnmp_proc.txt", "r");
            if (fp == NULL)
            {
                 RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.SNMP", "%s : /tmp/halsnmp_proc.txt open failed \n",__FUNCTION__ );
            }
            else
            {
                 while (fgets(proc_str, sizeof(proc_str)-1, fp) != NULL)
#if (NEXUS_PLATFORM_VERSION_MAJOR>=14)
                     if(strstr(proc_str,"primary decoder muted=n") != NULL)
#else
                     if(strstr(proc_str,"Audio Muted=0") != NULL)
#endif
					 {
                          ptDviHdmiInfo->audioMuteStatus = false;
                          break;
                     }
                system("cat /dev/null > /tmp/halsnmp_proc.txt");
                fclose(fp);
                fp = NULL;
            }
#if (NEXUS_PLATFORM_VERSION_MAJOR>=14)
            NxClient_GetAudioSettings(&audioSettings);

            #if (NEXUS_PLATFORM_VERSION_MAJOR >= 17)
            {
               NxClient_DisplaySettings displaySettings;
               NxClient_GetDisplaySettings(&displaySettings);
               RDK_LOG(RDK_LOG_INFO,"LOG.RDK.SNMP","HDMI active:%d audioSettings.muted:%d \n",displaySettings.hdmiPreferences.enabled,audioSettings.muted);
               if((!displaySettings.hdmiPreferences.enabled) | audioSettings.muted)
                 audio_mute = true;
            }
            #else
            {
               NxClient_GetDisplayStatus(&dispStatus);
               RDK_LOG(RDK_LOG_INFO,"LOG.RDK.SNMP","bVideoOutputConnected:%d audioSettings.muted:%d \n",dispStatus.bVideoOutputConnected,audioSettings.muted);
               if((!dispStatus.bVideoOutputConnected) | audioSettings.muted)
                 audio_mute = true;
            }
            #endif
            if(!audio_mute)
            {
               ptDviHdmiInfo->audioMuteStatus = false;
            }
            else
            {
               ptDviHdmiInfo->audioMuteStatus = true;
            }
#endif
        }

        #ifndef RDK_USE_NXCLIENT
          ptDviHdmiInfo->repStatus =  opHdcpStatus.isHdcpRepeater;
        #else
          ptDviHdmiInfo->repStatus = hdcpStatus.status.isHdcpRepeater;
        #endif            

        //videoFrameRate = getVideoFrameRate(); // TODO: SS-POD Find the proper video framerate
        ptDviHdmiInfo->videoFrameRate = getConvertedVideoFrameRate(videoFrameRate);

        // Get 1st half of EDID info
 #ifndef RDK_USE_NXCLIENT       
        result = NEXUS_HdmiOutput_GetEdidBlock(hdmiOpHandle, 0, &edidBlock);
        memcpy(&ptDviHdmiInfo->edid[0], &edidBlock, sizeof(edidBlock));
        ptDviHdmiInfo->edid_len = sizeof(edidBlock);

        // Get 2nd half of EDID info
        result = NEXUS_HdmiOutput_GetEdidBlock(hdmiOpHandle, 1, &edidBlock);
        memcpy(&ptDviHdmiInfo->edid[sizeof(edidBlock)], &edidBlock, sizeof(edidBlock));
        ptDviHdmiInfo->edid_len += sizeof(edidBlock);
#else
       //TODO
       /*
        * temporary while waiting for SW7425-1460.
        */
     NxClient_GetHdmiEdidBlock(0, &block);
     memcpy(ptDviHdmiInfo->edid, &(block.data), sizeof(block.data));
     ptDviHdmiInfo->edid_len = sizeof(block.data);

     NxClient_GetHdmiEdidBlock(1, &block);
     memcpy((ptDviHdmiInfo->edid+ptDviHdmiInfo->edid_len), &(block.data), sizeof(block.data));
     ptDviHdmiInfo->edid_len += sizeof(block.data);

     snprintf((char*)ptDviHdmiInfo->features,MAXCHARLEN,"%d",edidData.data.features);
     ptDviHdmiInfo->features_len = strlen((const char*)ptDviHdmiInfo->features);

#endif
        
        RDK_LOG(RDK_LOG_INFO, "LOG.RDK.SNMP", "%s : hdcp_status = %d, hdcp_enable = %d, deviceHdcpStatus =%d\n",
                             __FUNCTION__,ptDviHdmiInfo->hdcpStatus,ptDviHdmiInfo->bHDCPEnabled,ptDviHdmiInfo->connectedDeviceHDCPStatus  );


}

unsigned int HAL_SNMP_Get_ProgramStatus_info(void* pConnDetails, unsigned int listIter)
{
	//RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.SNMP", "\n ==> HAL_SNMP_Get_ProgramStatus_info begin \n");
	unsigned int listSize = 0;
	ConnDetails connDetails;

	memset(&connDetails, 0, sizeof(ConnDetails));
	GetConnListSize(&listSize);
	
	if(listSize > 0)
		GetConnListElement(&connDetails, listIter);
	
	if(pConnDetails != NULL)
		memcpy(pConnDetails, &connDetails, sizeof(ConnDetails));
	
	//RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.SNMP", "\n ==> HAL_SNMP_Get_ProgramStatus_info end \n");
	return 0;
}

void HAL_SNMP_Get_DevListSize(unsigned int* devListSize)
{
	unsigned int listSize = 0;
	GetConnListSize(&listSize);
	*devListSize = listSize;
}

