/******************************************************************************
* Copyright (c) 2011 SeaChange International (SeaChange) and its Licensors. 
* All rights reserved.
*
* This software is the confidential and proprietary information of SeaChange
* ("Confidential Information"). You shall not disclose this source code or 
* such Confidential Information and shall use it only in accordance with the 
* terms of the license agreement you entered into.
*  
* SEACHANGE INERNATIONAL  MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE 
* SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT 
* LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A 
* PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SEACHANGE SHALL NOT BE LIABLE FOR 
* ANY DAMAGES SUFFERED BY LICENSEE NOR SHALL THEY BE RESPONSIBLE AS A RESULT 
* OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
*******************************************************************************/


#ifndef _HAL_THREAD_H_
#define _HAL_THREAD_H_
/*===================================================================

FILE:  hal_thread.h

TARGET:  

DESCRIPTION:  HAL Module header file

CREATED:  GB  12/30/2004
===================================================================*/

/*===================================================================
//   INCLUDES AND PUBLIC DATA DECLARATIONS
//===================================================================*/

/*-------------------------------------------------------------------
// Defines
//------------------------------------------------------------------- */
#define HAL_THREAD_RT_PRIORITY_MAX      (99)
#define HAL_THREAD_RT_PRIORITY_MIN      (1)

#define HAL_THREAD_POLICY_INHERITED     (-1)
#define HAL_THREAD_PRIORITY_INHERITED   (-1)

#define HAL_THREAD_MAX_NAME             (24)

#define HAL_THREAD_DEFAULT_DETACHSTATE  (PTHREAD_CREATE_JOINABLE)
#define HAL_THREAD_DEFAULT_STACKSIZE    (-1)
#define HAL_THREAD_DEFAULT_PRIORITY     (0)
#define HAL_THREAD_DEFAULT_POLICY       (SCHED_OTHER)


/*-------------------------------------------------------------------
// Include Files
//------------------------------------------------------------------- */
#include <pthread.h>
#include <stdio.h>
/*-------------------------------------------------------------------
// Type Declarations
//-------------------------------------------------------------------*/

/*-------------------------------------------------------------------
// Global Constant Declarations 
//-------------------------------------------------------------------*/

/*-------------------------------------------------------------------
// Global Data Declarations
//-------------------------------------------------------------------*/

/*===================================================================
//  FUNCTION DECLARATIONS
//===================================================================*/
#ifdef __cplusplus
extern "C" {
#endif

/*===================================================================
FUNCTION:       HAL_ThreadCreate

DESCRIPTION:    create a thread whose policy, priority and 
    detachstate are specified

RETURN VALUE: 
    pthread_t of pthread_craete on proper thread creation, -1 otherwise
   
SIDE EFFECTS:
   Thread will be running on successful return
===================================================================*/
pthread_t HAL_ThreadCreate(pthread_t *pt, int policy, int priority,
                           int detachstate, int stackSize, void *fn(void *), 
                           void *arg, const char *pszThreadName);

/*===================================================================
FUNCTION:       HAL_SetSchedParams

DESCRIPTION:    Set the scheduling parameters for the current thread.
    This is used at the start of all daemons to make them FIFO or
    Round Robin and to set their priority. 
    
RETURN VALUE: 
    0 on proper execution, -1 otherwise
   
SIDE EFFECTS:
    None
===================================================================*/
int HAL_SetSchedParams(int policy, int priority);

/*===================================================================
FUNCTION:       HAL_ThreadReport

DESCRIPTION:   Dumps thread stats out to FILE stream.
    
RETURN VALUE: 
    0 on proper execution, -1 otherwise
   
SIDE EFFECTS:
    None
===================================================================*/
void HAL_ThreadReport(FILE* f);  

#ifdef __cplusplus
}
#endif


#endif /* _HAL_THREAD_H_ */

