/******************************************************************************
* Copyright (c) 2011 SeaChange International (SeaChange) and its Licensors. 
* All rights reserved.
*
* This software is the confidential and proprietary information of SeaChange
* ("Confidential Information"). You shall not disclose this source code or 
* such Confidential Information and shall use it only in accordance with the 
* terms of the license agreement you entered into.
*  
* SEACHANGE INERNATIONAL  MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE 
* SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT 
* LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A 
* PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SEACHANGE SHALL NOT BE LIABLE FOR 
* ANY DAMAGES SUFFERED BY LICENSEE NOR SHALL THEY BE RESPONSIBLE AS A RESULT 
* OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
*******************************************************************************/


#ifndef _HAL_TIME_H_
#define _HAL_TIME_H_
/*===================================================================

FILE:  hal_thread.h

TARGET:

DESCRIPTION:  HAL Module header file

CREATED:  GB  2/24/2005
===================================================================*/

/*=================================================================== */
/*   INCLUDES AND PUBLIC DATA DECLARATIONS */
/*=================================================================== */

/*------------------------------------------------------------------- */
/* Include Files */
/*------------------------------------------------------------------- */
#include <sys/time.h>

/*------------------------------------------------------------------- */
/* Defines */
/*------------------------------------------------------------------- */
#define MSECS_PER_SEC  (1000)
#define USECS_PER_SEC  (1000000)
#define USECS_PER_MSEC (1000)
#define NSECS_PER_MSEC (1000000)
#define NSECS_PER_USEC (1000)


/*------------------------------------------------------------------- */
/* Type Declarations */
/*------------------------------------------------------------------- */

/*------------------------------------------------------------------- */
/* Global Constant Declarations  */
/*------------------------------------------------------------------- */

/*------------------------------------------------------------------- */
/* Global Data Declarations */
/*------------------------------------------------------------------- */

/*=================================================================== */
/*  FUNCTION DECLARATIONS */
/*=================================================================== */
#ifdef __cplusplus
extern "C" {
#endif

/*===================================================================
FUNCTION:      HAL_AbsoluteTimeoutFromUsecs

DESCRIPTION:   Loads the timespec struct passed in with an absolute
               timeout value calculated by adding 'usecs' passed in
               to the current time.

RETURN VALUE:

SIDE EFFECTS:
===================================================================*/
void HAL_AbsoluteTimeoutFromUsecs(struct timespec* ts, long usecs);

/*===================================================================
FUNCTION:      HAL_AbsoluteTimeoutFromMsecs

DESCRIPTION:   Loads the timespec struct passed in with an absolute
               timeout value calculated by adding 'msecs' passed in
               to the current time.

RETURN VALUE:

SIDE EFFECTS:
===================================================================*/
void HAL_AbsoluteTimeoutFromMsecs(struct timespec* ts, long msecs);

/*===================================================================
FUNCTION:      HAL_AbsoluteTimeoutFromSecs

DESCRIPTION:   Loads the timespec struct passed in with an absolute
               timeout value calculated by adding 'secs' passed in
               to the current time.

RETURN VALUE:

SIDE EFFECTS:
===================================================================*/
void HAL_AbsoluteTimeoutFromSecs(struct timespec* ts, long secs);


/*===================================================================
FUNCTION:      HAL_RelativeTimeoutFromUsecs

DESCRIPTION:   Loads the timespec struct passed in with 'usecs'
               passed in.

RETURN VALUE:

SIDE EFFECTS:
===================================================================*/
void HAL_RelativeTimeoutFromUsecs(struct timespec* ts, long usecs);


/*===================================================================
FUNCTION:      HAL_RelativeTimeoutFromMsecs

DESCRIPTION:   Loads the timespec struct passed in with 'msecs'
               passed in.

RETURN VALUE:

SIDE EFFECTS:
===================================================================*/
void HAL_RelativeTimeoutFromMsecs(struct timespec* ts, long msecs);


int HAL_GetCurTimeInSecs(unsigned long *pCurTimeInSecs);

#ifdef __cplusplus
}
#endif


#endif /* _HAL_TIME_H_ */

