/******************************************************************************
* Copyright (c) 2011 SeaChange International (SeaChange) and its Licensors. 
* All rights reserved.
*
* This software is the confidential and proprietary information of SeaChange
* ("Confidential Information"). You shall not disclose this source code or 
* such Confidential Information and shall use it only in accordance with the 
* terms of the license agreement you entered into.
*  
* SEACHANGE INERNATIONAL  MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE 
* SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT 
* LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A 
* PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SEACHANGE SHALL NOT BE LIABLE FOR 
* ANY DAMAGES SUFFERED BY LICENSEE NOR SHALL THEY BE RESPONSIBLE AS A RESULT 
* OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
*******************************************************************************/




#ifdef USE_DSG

/*-------------------------------------------------------------------
   Include Files
-------------------------------------------------------------------*/
#include <string.h>
#include <stdio.h>
#include "vl_dsg_priv.h"
#include "utilityMacros.h"
#include "hutils_sys.h"
#include "rdk_debug.h"
#include "vl_dsg_api.h"
#include "hal_module.h"
#include "hal_error.h"
#include <pdt_hal.h>
#include "rmf_error.h"
#include "vlEnv.h"


DSG_t *DSG_GetDSGFromHandle (UINT32 hDSGHandle);

/*===================================================================
FUNCTION: HAL_DSG_GetCapabilities

DESCRIPTION:
    Returns the tuner capabilities in the DSG_CAPABILITIES_t structure.
RETURN VALUE:
   0 - Success;  Negative values - Failure
SIDE EFFECTS:
   None.
===================================================================*/
INT32 HAL_DSG_GetCapabilities (VL_DSG_CAPABILITIES_t *pstCapabilities)
{
    RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_DSG,"%s(): Entry\n", __FUNCTION__);

    // Check whether tuner is initialized
    if (!stHalDSGBase.bIsInitialized)
    {
        RDK_LOG(RDK_LOG_ERROR,HAL_MODULE_DSG,"%s(): %s: HAL DSG not initialized \n",
                 __FUNCTION__,SYS_Error_String(ERROR_HAL_NOT_INITIALIZED));
        return(ERROR_HAL_NOT_INITIALIZED);
    }

    // Check for null parameters
    if (pstCapabilities == NULL)
    {
        RDK_LOG(RDK_LOG_ERROR,HAL_MODULE_DSG,"%s(): %s: Null Parameter \n",
                 __FUNCTION__,SYS_Error_String(ERROR_HAL_NULL_PARAMETER));
        return(ERROR_HAL_NULL_PARAMETER);
    }

    memcpy((void *)pstCapabilities, &(stHalDSGBase.stCapabilities), sizeof(VL_DSG_CAPABILITIES_t));

    RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_DSG,"%s(): Exit\n", __FUNCTION__);
    return(HAL_SUCCESS);
}



/*===================================================================
FUNCTION: HAL_DSG_Request

DESCRIPTION:

RETURN VALUE:
   0 - Success;  Negative values - Failure
SIDE EFFECTS:
   None.
===================================================================*/
INT32 HAL_DSG_Request( DEVICE_HANDLE_t hDSGHandle)
{
    DSG_t *pstDSG;

    RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_DSG,"%s(): Entry\n", __FUNCTION__);

    RDK_LOG(RDK_LOG_INFO, HAL_MODULE_DSG,"%s(): Requested DSG handle %lX\n", __FUNCTION__, hDSGHandle);

    // Check for invalid handle and Get the tuner from the handle
    if ((pstDSG = DSG_GetDSGFromHandle(hDSGHandle)) == NULL)
    {
        RDK_LOG(RDK_LOG_ERROR,HAL_MODULE_DSG,"%s(): %s: Invalid DSG Handle \n",
                 __FUNCTION__,SYS_Error_String(ERROR_HAL_INVALID_HANDLE));
        return(ERROR_HAL_INVALID_HANDLE);
    }

    // Check the state of DSG
    if (!pstDSG->bFree)
    {
        RDK_LOG(RDK_LOG_ERROR,HAL_MODULE_DSG,"%s(): %s: DSG device not available \n",
                 __FUNCTION__,SYS_Error_String(ERROR_HAL_DEVICE_NOT_AVAILABLE));
        return(ERROR_HAL_DEVICE_NOT_AVAILABLE );
    }

    // Mark this DSG as not free
    pstDSG->bFree = false;

    RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_DSG,"%s(): Exit\n", __FUNCTION__);
    return(HAL_SUCCESS);
}




/*===================================================================
FUNCTION: HAL_MODULE_DSG_Release

DESCRIPTION:
    Releases the DSG specified by DSG handle parameter.
RETURN VALUE:
   0 - Success;  Negative values - Failure
SIDE EFFECTS:
   None.
===================================================================*/
INT32 HAL_DSG_Release (DEVICE_HANDLE_t hDSGHandle)
{
    DSG_t *pstDSG;

    RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_DSG,"%s(): Entry\n", __FUNCTION__);

    RDK_LOG(RDK_LOG_INFO, HAL_MODULE_DSG,"%s(): DSG handle to be released %lX\n", __FUNCTION__, hDSGHandle);

    // Check for invalid handle and Get the tuner from the handle
    if ((pstDSG = DSG_GetDSGFromHandle(hDSGHandle)) == NULL)
    {
        RDK_LOG(RDK_LOG_ERROR,HAL_MODULE_DSG,"%s(): %s: Invalid Tuner Handle \n",
                 __FUNCTION__,SYS_Error_String(ERROR_HAL_INVALID_HANDLE));
        return(ERROR_HAL_INVALID_HANDLE);
    }

    // Check for DSG not requested
    if (pstDSG->bFree)
    {
        RDK_LOG(RDK_LOG_ERROR,HAL_MODULE_DSG,"%s(): %s: DSG is not requested \n",
                 __FUNCTION__,SYS_Error_String(ERROR_HAL_NOT_REQUESTED));
        return(ERROR_HAL_NOT_REQUESTED);
    }

    // Mark this DSG as free
    pstDSG->bFree = true;

    RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_DSG,"%s(): Exit\n", __FUNCTION__);
    return(HAL_SUCCESS);
}

int HAL_DSG_ProcessControlMessage(DSG_t *pstDSG, unsigned char *pCtrlMsgData, unsigned short dataLength);

int HAL_DSG_Send_ControlMessage(DEVICE_HANDLE_t hDSGHandle, unsigned char *pCtrlMsgData, unsigned short dataLength)
{
    DSG_RESULT  dsgResult = DSG_ERROR;

    DSG_t   *pstDSG = DSG_GetDSGFromHandle(hDSGHandle);
    RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_DSG,"%s(): Entry \n", __FUNCTION__);

    RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_DSG,"%s(): Processing Tags, dataLength = %d\n", __FUNCTION__,dataLength);

    dsgResult = (DSG_RESULT)HAL_DSG_ProcessControlMessage(pstDSG, pCtrlMsgData, dataLength);

    if(dsgResult != DSG_OK)
    {
    	RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_DSG,"%s():DSG_SendDsgControlMessage returned 0x%x\n", __FUNCTION__,dsgResult);
        return ERROR_HAL_GENERAL;
    }

    RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_DSG,"%s():SUCCESS\n", __FUNCTION__);

    return HAL_SUCCESS;
}

DSG_t * DSG_GetDSGFromHandle (DEVICE_HANDLE_t hDSGHandle)
{
    return &(stHalDSGBase.astDSG[0]);
}
#if 0
int vlg_util_get_platform_name_val(void)
{
    static VL_PLATFORM_NAME_VAL pfn = (VL_PLATFORM_NAME_VAL)0;
    #ifdef USE_PACE_MFR // FEB-28-2012 : Determine platform based on manufacturer
        pfn = VL_OS_PACE_PARKER_DSA; // FEB-28-2012 : Determine platform based on manufacturer
    #else
        static char * envPtr = NULL;
        if(NULL == envPtr)
        {
            strcpy(vlg_platform_name, "");
	    envPtr = vl_env_get_str(NULL, "VL_PLATFORM_NAME");    
            if(NULL != envPtr)
            {
                strcpy(vlg_platform_name,envPtr);//assume Pace Parker
            }
        }
        if(0 == pfn)
        {
            if(0 == strncmp(vlg_platform_name,PACE_PARKER,VL_PLATFORM_NAME_MAX_SIZE))
              pfn = VL_OS_PACE_PARKER;
            else if(0 == strncmp(vlg_platform_name,INTEL_SR,VL_PLATFORM_NAME_MAX_SIZE))
              pfn = VL_OS_INTEL_SHARKRIVER;
            else
              pfn = VL_OS_PACE_PARKER_DSA;
        }
    #endif
    return (int)pfn;
}
char * vlg_util_get_docsis_dhcp_if_name(void)
{    
    const char *envPtr = vl_env_get_str("eth1", "VL_DOCSIS_DHCP_IF_NAME");    
    return (char *)envPtr;
}

char * vlg_util_get_docsis_wan_if_name(void)
{
   const char *envPtr = vl_env_get_str("eth1", "VL_DOCSIS_WAN_IF_NAME");
    return (char *)envPtr;
}

char * vlg_util_get_ecm_rpc_if_name(void)
{
    const char *envPtr = vl_env_get_str("eth1:1", "VL_ECM_RPC_IF_NAME");
    return (char *)envPtr;
}
#endif


#endif // USE_DSG
