/******************************************************************************
* Copyright (c) 2011 SeaChange International (SeaChange) and its Licensors. 
* All rights reserved.
*
* This software is the confidential and proprietary information of SeaChange
* ("Confidential Information"). You shall not disclose this source code or 
* such Confidential Information and shall use it only in accordance with the 
* terms of the license agreement you entered into.
*  
* SEACHANGE INERNATIONAL  MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE 
* SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT 
* LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A 
* PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SEACHANGE SHALL NOT BE LIABLE FOR 
* ANY DAMAGES SUFFERED BY LICENSEE NOR SHALL THEY BE RESPONSIBLE AS A RESULT 
* OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
*******************************************************************************/




#ifndef VL_DSG_SERVICE_H
#define VL_DSG_SERVICE_H
#include "dsg_types.h"
typedef void * DSGHAL_HANDLE;
typedef void * DSG_HANDLE;

#ifdef __cplusplus
extern "C" {
#endif
void vlCdlEnableSSDL();

/*-------------------------------------------------------------------
    Defines/Macros
-------------------------------------------------------------------*/

typedef enum _DSG_RESULT
{
    DSG_OK,
    DSG_ERROR
}DSG_RESULT;

/*-------------------------------------------------------------------
   Types/Structs
-------------------------------------------------------------------*/

typedef struct
{
    unsigned char                   usIndex;
    int                             bFree;            // Whether the POD Module is free/already requested
    VL_DSG_TUNNEL_CBFUNC_t          tunnel_data_available_cb;
    VL_DSG_CTRL_CBFUNC_t            control_data_available_cb;
    VL_DSG_IMAGE_CBFUNC_t           image_data_available_cb;
    VL_DSG_DOWNLOAD_STATUS_CBFUNC_t download_status_cb;
    VL_DSG_ECMSTATUS_CBFUNC_t       ecm_status_cb;
    VL_DSG_ASYNC_CBFUNC_t           async_data_cb;
    VL_DSG_MODE                     dsgMode;
    VL_DSG_DIRECTORY                dsgDirectory;
    VL_DSG_ADV_CONFIG               dsgAdvConfig;
    VL_DSG_DCD                      dsgDCD;
    int                             bDsgTwoWayMode;
    DSGHAL_HANDLE                   hHal;
    DSG_HANDLE                      hDsgDriver;

}DSG_t;

typedef struct
{
    int                 bIsInitialized;         // Whether HAL DSG is initialized
    VL_DSG_CAPABILITIES_t  stCapabilities;
    DSG_t               astDSG[VL_MAX_DSG_DEVICES]; // Array of DSG modules
} DSG_BASE_t;

/*-------------------------------------------------------------------
   Global Data Declarations
-------------------------------------------------------------------*/
extern DSG_BASE_t stHalDSGBase;

#ifdef __cplusplus
}
#endif

#endif //VL_DSG_SERVICE_H
