/******************************************************************************
* Copyright (c) 2011 SeaChange International (SeaChange) and its Licensors. 
* All rights reserved.
*
* This software is the confidential and proprietary information of SeaChange
* ("Confidential Information"). You shall not disclose this source code or 
* such Confidential Information and shall use it only in accordance with the 
* terms of the license agreement you entered into.
*  
* SEACHANGE INERNATIONAL  MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE 
* SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT 
* LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A 
* PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SEACHANGE SHALL NOT BE LIABLE FOR 
* ANY DAMAGES SUFFERED BY LICENSEE NOR SHALL THEY BE RESPONSIBLE AS A RESULT 
* OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
*******************************************************************************/




#ifdef USE_MFR

/*-------------------------------------------------------------------
   Include Files
-------------------------------------------------------------------*/
#include <string.h>
#include "rmf_osal_sync.h"
#include "vl_mfr_priv.h"
#include "utilityMacros.h"
#include "vlpluginapp_halmfrapi.h"
//#include "../halhid/hid_api.h"
#include "hutils_sys.h"
#include "rdk_debug.h"
#include "rmf_osal_util.h"
#include "hal_error.h"
#if defined(USE_MOT_MFR)
#ifdef __cplusplus
extern "C" {
#endif
    VL_MFR_API_RESULT motorola_mfr_init(void);
    VL_MFR_API_RESULT motorola_mfr_set_notify(VL_MFR_NOTIFY_TYPE_t notifyType, VL_MFR_VOID_CBFUNC_t pfnNotifyFunc);

    VL_MFR_API_RESULT motorola_mfr_get_version_name(VL_PLATFORM_VERSION_TYPE eVersionType, char ** ppString);
    VL_MFR_API_RESULT motorola_mfr_get_version     (VL_PLATFORM_VERSION_TYPE eVersionType, char ** ppString);

    VL_MFR_API_RESULT motorola_mfr_read_normal_nvram (VL_NORMAL_NVRAM_DATA_TYPE eType, VL_NVRAM_DATA * pNvRamData);
    VL_MFR_API_RESULT motorola_mfr_write_normal_nvram(VL_NORMAL_NVRAM_DATA_TYPE eType, const VL_NVRAM_DATA * pNvRamData);

    VL_MFR_API_RESULT motorola_mfr_read_secure_nvram (VL_SECURE_NVRAM_DATA_TYPE eType, VL_NVRAM_DATA * pNvRamData);
    VL_MFR_API_RESULT motorola_mfr_write_secure_nvram(VL_SECURE_NVRAM_DATA_TYPE eType, const VL_NVRAM_DATA * pNvRamData);

    VL_MFR_API_RESULT motorola_mfr_set_mfr_data(VL_STACK_2_MFR_EVENT_TYPE eEvent, void * _pvData);
    VL_MFR_API_RESULT motorola_mfr_get_mfr_data(VL_STACK_2_MFR_EVENT_TYPE eEvent, void * _pvData);
#ifdef __cplusplus
}
#endif
#elif defined(USE_BRCM_MFR)
#include "broadcom_sample_mfr_api.h"
#ifdef LEGACY_NEXUS
#include "broadcom_mfr_nvram_api.c"
#endif
#include "broadcom_DFAST2_prod_gfe_ext_v3.2.h"
#include "broadcom_DFAST2_prod_header_v3.2.h"

#elif defined(USE_PACE_MFR)
#include "pace_mfr_api.h"
#include "pace_mfr_nvram_api.h"
#include "pace_DFAST2_prod_gfe_ext_v3.2.h"
#include "pace_DFAST2_prod_header_v3.2.h"

#elif defined(USE_VIVID_MFR)
#include "vivid_sample_mfr_api.h"
#include "vivid_DFAST2_prod_gfe_ext_v3.2.h"
#include "vivid_DFAST2_prod_header_v3.2.h"

#elif defined(USE_INTEL_MFR)
#include "intel_sample_mfr_api.h"
#include "intel_DFAST2_prod_gfe_ext_v3.2.h"
#include "intel_DFAST2_prod_header_v3.2.h"

#elif defined(USE_THOMSON_MFR)
#include "thomson_sample_mfr_api.h"
#include "thomson_DFAST2_prod_gfe_ext_v3.2.h"
#include "thomson_DFAST2_prod_header_v3.2.h"

#elif defined(USE_SAM_MFR)
#include "sam_mfr_api.h"
#else
#include "vl_sample_mfr_api.h"
#include "vl_DFAST2_eval_gfe_ext_v3_2.h"
#include "vl_DFAST2_eval_header_v3_2.h"
#endif
#if defined(USE_MOT_MFR)
#warning "=>>>>>>>>>> USE_MOT_MFR is defined!"
#else
#warning "=>>>>>>>>>> USE_MOT_MFR is NOT defined!"
#endif
#undef LOGDEBUG
#undef LOGINFO
#undef LOGERROR

//#define RDK_LOG(RDK_LOG_DEBUG,x,...)
#define LOGINFO(y,...)
#define LOGERROR(z,...)
//DECLARE_LOG_APPTYPE (LOG_APPTYPE_OCAP_HAL_DRIVERS_TRANSPORT)

typedef enum
{
   HID_FPKEY,
   HID_IRKEYBOARD,
   HID_IRREMOTE,
   HID_JOYSTICK,
   HID_DIRECTIONALPAD,
   HID_HDMI_CEC,
   HID_UNKNOWN,
   HID_NUM_OF_DEVICES
} HID_DEVICES_t;

void * vl_mfr_fp_run(void * arg)
{
	RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.POD", "%s: arg %p.  \n", __FUNCTION__, arg);
	return NULL;
    // nothing to do here for the time being
}

MFR_t *MFR_GetMFRFromHandle (unsigned int hMFRHandle);

/*-------------------------------------------------------------------
   Global Variable Definitions
-------------------------------------------------------------------*/
static MFR_BASE_t stHalMFRBase;
static int vlg_nNotifyClients = 0;
static VL_MFR_NOTIFY_VOID_CLIENT_t  vlg_aNotifyClients[VL_MAX_MFR_CLIENTS];

static rmf_osal_Mutex HAL_MFR_get_nvram_access_lock()
{
   
   static  rmf_osal_Mutex lock;
   static unsigned char val;   
    if(0 == val)
    {
			rmf_osal_mutexNew(&lock);		
			val = 1;
    }
    return lock;
}

VL_MFR_API_RESULT HAL_MFR_post_key_to_hid(VL_MFR_NOTIFY_TYPE_t eType,
                                          HID_DEVICES_t eDevice_type,
                                          VL_REMOTE_KEY* pRemoteKey)
{
 /*   int i = 0;
    for(i = 0; i < vlg_nNotifyClients; i++)
    {
        if((eType == vlg_aNotifyClients[i].eCBType) && (NULL != vlg_aNotifyClients[i].pCallback))
        {
            HID_KEY_ACTION_FUNC_t pCallback =
                (HID_KEY_ACTION_FUNC_t)(vlg_aNotifyClients[i].pCallback);
            HID_DEVICE_HANDLE_t handle = {eDevice_type, 0};
            unsigned long extData = 0;
            pCallback(handle, (UINT32)pRemoteKey->eMode, 0x000000FE, &extData, vlg_aNotifyClients[i].pCBData);
            pCallback(handle, (UINT32)pRemoteKey->eMode, pRemoteKey->nKeyCode, &extData, vlg_aNotifyClients[i].pCBData);
            return VL_MFR_API_RESULT_SUCCESS;
        }
    }*/
	return VL_MFR_API_RESULT_FAILED;
}

VL_MFR_API_RESULT HAL_MFR_notify_mfr_event(void * pAppData, VL_MFR_2_STACK_EVENT_TYPE eEvent, void * _pvData)
{
RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.POD", "%s: pAppData %p.  \n", __FUNCTION__, pAppData);

    int i = 0;

    switch(eEvent)
    {
    case VL_MFR_2_STACK_EVENT_REMOTE_KEY        :
    {
        VL_REMOTE_KEY* pEventData = (VL_REMOTE_KEY*)_pvData;
        RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.SYS", "HAL_MFR_notify_front_panel_event: Received VL_MFR_2_STACK_EVENT_REMOTE_KEY device = %d, keycode = %d\n", pEventData->eDevice, (int)pEventData->nKeyCode);
        switch(pEventData->eDevice)
        {
            case VL_KEY_DEVICE_TYPE_PANEL:
            {
                return HAL_MFR_post_key_to_hid(VL_MFR_NOTIFY_KEY_FP, HID_FPKEY, pEventData);
            }
            break;

            case VL_KEY_DEVICE_TYPE_REMOTE:
            {
                return HAL_MFR_post_key_to_hid(VL_MFR_NOTIFY_KEY_REMOTE, HID_IRREMOTE, pEventData);
            }
            break;

            case VL_KEY_DEVICE_TYPE_KEYBOARD:
            {
                return HAL_MFR_post_key_to_hid(VL_MFR_NOTIFY_KEY_IR_KB, HID_IRKEYBOARD, pEventData);
            }
            break;

            case VL_KEY_DEVICE_TYPE_MOUSE:
            {
            }
            break;

            case VL_KEY_DEVICE_TYPE_JOYSTICK:
            {
                return HAL_MFR_post_key_to_hid(VL_MFR_NOTIFY_KEY_JOYSTICK, HID_JOYSTICK, pEventData);
            }
            break;

            case VL_KEY_DEVICE_TYPE_DIRECTIONAL_PAD:
            {
                return HAL_MFR_post_key_to_hid(VL_MFR_NOTIFY_KEY_DIRECTIONAL_PAD, HID_DIRECTIONALPAD, pEventData);
            }
            break;

            case VL_KEY_DEVICE_TYPE_GAME_CONTROLLER:
            {
            }
            break;
        }
    }
    break;

    case VL_MFR_2_STACK_EVENT_DATE_TIME         :
    {
        VL_DATE_TIME* pEventData = (VL_DATE_TIME*)_pvData;
        RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.SYS", "HAL_MFR_notify_front_panel_event: Received VL_MFR_2_STACK_EVENT_DATE_TIME pEventData %p \n", (void *)pEventData);
    }
    break;

    case VL_MFR_2_STACK_EVENT_POWER_MODE        :
    {
        VL_POWER_MODE_TIMER* pEventData = (VL_POWER_MODE_TIMER*)_pvData;
        RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.SYS", "HAL_MFR_notify_front_panel_event: Received VL_MFR_2_STACK_EVENT_POWER_MODE %d\n", pEventData->ePowerMode);
    }
    break;

    case VL_MFR_2_STACK_EVENT_SHOW_APP          :
    {
        RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.SYS", "HAL_MFR_notify_front_panel_event: Received VL_MFR_2_STACK_EVENT_SHOW_APP 0x%p\n", _pvData);
    }
    break;

    case VL_MFR_2_STACK_EVENT_RESET_TO_FACTORY_SETTINGS:
    {
        RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.SYS", "HAL_MFR_notify_front_panel_event: Received VL_MFR_2_STACK_EVENT_RESET_TO_FACTORY_SETTINGS\n");
    }
    break;

    default:
    {
        RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.SYS", "HAL_MFR_notify_front_panel_event: Received event %d\n", eEvent);
    }
    break;
    }

    for(i = 0; i < vlg_nNotifyClients; i++)
    {
        if((VL_MFR_NOTIFY_MFR_EVENT == vlg_aNotifyClients[i].eCBType) && (NULL != vlg_aNotifyClients[i].pCallback))
        {
            VL_MFR_NOTIFY_MFR_EVENT_CBFUNC_t pCallback =
                (VL_MFR_NOTIFY_MFR_EVENT_CBFUNC_t)(vlg_aNotifyClients[i].pCallback);
            return pCallback(vlg_aNotifyClients[i].pCBData, eEvent, _pvData);
        }
    }

    return VL_MFR_API_RESULT_FAILED;
}

VL_MFR_API_RESULT HAL_MFR_notify_get_mfr_data    (void * pAppData, VL_MFR_2_STACK_EVENT_TYPE eEvent, void * _pvData)
{
	RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.POD", "%s: pAppData %p.  \n", __FUNCTION__, pAppData);

    int i = 0;

    switch(eEvent)
    {
    case VL_MFR_2_STACK_EVENT_DATE_TIME         :
    {
        VL_DATE_TIME* pEventData = (VL_DATE_TIME*)_pvData;
        pEventData->date.nYear   = 2008;
        pEventData->date.nMonth  = 1;
        pEventData->date.nDay    = 29;
        pEventData->time.bPM     = 1;
        pEventData->time.nHour   = 5;
        pEventData->time.nMin    = 30;
        pEventData->time.nSec    = 45;
        RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.SYS", "HAL_MFR_notify_get_stack_data: Received VL_MFR_2_STACK_EVENT_DATE_TIME\n");
    }
    break;

    case VL_MFR_2_STACK_EVENT_POWER_MODE        :
    {
        VL_POWER_MODE_TIMER* pEventData = (VL_POWER_MODE_TIMER*)_pvData;
        pEventData->ePowerMode = VL_POWER_MODE_FULL_POWER;
        pEventData->eReason    = VL_POWER_ON_REASON_NONE;
        pEventData->nSeconds   = 30000;
        RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.SYS", "HAL_MFR_notify_get_stack_data: Received VL_MFR_2_STACK_EVENT_POWER_MODE\n");
    }
    break;

    case VL_MFR_2_STACK_EVENT_POWER_ON_TIME        :
    {
        VL_POWER_ON_TIME* pEventData = (VL_POWER_ON_TIME*)_pvData;
        pEventData->eReason    = VL_POWER_ON_REASON_NONE;
        RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.SYS", "HAL_MFR_notify_get_stack_data: Received VL_MFR_2_STACK_EVENT_POWER_ON_TIME\n");
    }
    break;


    default:
    {
        RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.SYS", "HAL_MFR_notify_get_stack_data: Received event %d\n", eEvent);
    }
    break;
    }

    for(i = 0; i < VL_MAX_MFR_CLIENTS; i++)
    {
        if((VL_MFR_NOTIFY_GET_MFR_DATA == vlg_aNotifyClients[i].eCBType) && (NULL != vlg_aNotifyClients[i].pCallback))
        {
            VL_MFR_NOTIFY_MFR_GET_DATA_CBFUNC_t pCallback =
                (VL_MFR_NOTIFY_MFR_GET_DATA_CBFUNC_t)(vlg_aNotifyClients[i].pCallback);
            return pCallback(vlg_aNotifyClients[i].pCBData, eEvent, _pvData);
        }
    }
    return VL_MFR_API_RESULT_FAILED;
}

VL_MFR_API_RESULT HAL_MFR_get_stack_version_name( VL_MFR_DEVICE_HANDLE_t hMFRHandle, VL_STACK_VERSION_TYPE eVersionType, char ** ppString)
{
    RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.POD", "%s: hMFRHandle %d.  \n", __FUNCTION__, (int)hMFRHandle);

    if(NULL == ppString)
    {
        return VL_MFR_API_RESULT_NULL_PARAM;
    }

    switch(eVersionType)
    {
    case VL_STACK_VERSION_TYPE_VL_STACK         : *ppString  = "VL Stack"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_STACK_VERSION_TYPE_OCAP             : *ppString  = "OCAP"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_STACK_VERSION_TYPE_OCHD             : *ppString  = "OCHD"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_STACK_VERSION_TYPE_JVM              : *ppString  = "JVM"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_STACK_VERSION_TYPE_E2FS             : *ppString  = "E2FS"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_STACK_VERSION_TYPE_FREETYPE         : *ppString  = "Freetype"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_STACK_VERSION_TYPE_JPEG             : *ppString  = "JPEG"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_STACK_VERSION_TYPE_GIF              : *ppString  = "GIF"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_STACK_VERSION_TYPE_PNG              : *ppString  = "PNG"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_STACK_VERSION_TYPE_TIFF             : *ppString  = "TIFF"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_STACK_VERSION_TYPE_UNGIF            : *ppString  = "UNGIF"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_STACK_VERSION_TYPE_ELECTRIC_FENCE   : *ppString  = "ElectricFence"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_STACK_VERSION_TYPE_MPEG             : *ppString  = "MPEG"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_STACK_VERSION_TYPE_EXIF             : *ppString  = "EXIF"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_STACK_VERSION_TYPE_MAD              : *ppString  = "MAD"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_STACK_VERSION_TYPE_SNDFILE          : *ppString  = "Sound File"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_STACK_VERSION_TYPE_USB              : *ppString  = "USB"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_STACK_VERSION_TYPE_MPATROL          : *ppString  = "M Patrol"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_STACK_VERSION_TYPE_MPEG4IP          : *ppString  = "MPEG4IP"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_STACK_VERSION_TYPE_MPLAYER          : *ppString  = "MPlayer"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_STACK_VERSION_TYPE_SQLLITE          : *ppString  = "SQL Lite"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_STACK_VERSION_TYPE_TAGLIB           : *ppString  = "TAG lib"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_STACK_VERSION_TYPE_ZLIB             : *ppString  = "Z lib"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_STACK_VERSION_TYPE_OPENSSL          : *ppString  = "OpenSSL"; return VL_MFR_API_RESULT_SUCCESS;
    }

    *ppString  = "Not-Existing";
    return VL_MFR_API_RESULT_NOT_EXISTING;
}

VL_MFR_API_RESULT HAL_MFR_get_stack_version     ( VL_MFR_DEVICE_HANDLE_t hMFRHandle, VL_STACK_VERSION_TYPE eVersionType, char ** ppString)
{
    RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.POD", "%s: hMFRHandle %d.  \n", __FUNCTION__, (int)hMFRHandle);

    if(NULL == ppString)
    {
        return VL_MFR_API_RESULT_NULL_PARAM;
    }

    switch(eVersionType)
    {
    case VL_STACK_VERSION_TYPE_VL_STACK         : *ppString  = "1.08.005"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_STACK_VERSION_TYPE_OCAP             : return HAL_MFR_get_version(hMFRHandle, VL_PLATFORM_VERSION_TYPE_OCAP_VERSION, ppString);
    case VL_STACK_VERSION_TYPE_OCHD             : return HAL_MFR_get_version(hMFRHandle, VL_PLATFORM_VERSION_TYPE_OCHD_VERSION, ppString);
    case VL_STACK_VERSION_TYPE_JVM              : *ppString  = "pbp1.0"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_STACK_VERSION_TYPE_E2FS             : *ppString  = "e2fsprogs-1.38"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_STACK_VERSION_TYPE_FREETYPE         : *ppString  = "freetype-2.3.5"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_STACK_VERSION_TYPE_JPEG             : *ppString  = "jpeg-6b"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_STACK_VERSION_TYPE_GIF              : *ppString  = "libungif-4.1.3"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_STACK_VERSION_TYPE_PNG              : *ppString  = "libpng-1.2.8"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_STACK_VERSION_TYPE_TIFF             : *ppString  = "tiff-3.7.4"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_STACK_VERSION_TYPE_UNGIF            : *ppString  = "libungif-4.1.3"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_STACK_VERSION_TYPE_ELECTRIC_FENCE   : *ppString  = "ElectricFence-2.2.2"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_STACK_VERSION_TYPE_MPEG             : *ppString  = "mpeg4ip-1.3"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_STACK_VERSION_TYPE_EXIF             : *ppString  = "libexif-0.6.12"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_STACK_VERSION_TYPE_MAD              : *ppString  = "libmad-0.15.1b"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_STACK_VERSION_TYPE_SNDFILE          : *ppString  = "libsndfile-1.0.11"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_STACK_VERSION_TYPE_USB              : *ppString  = "libusb-0.1.10a"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_STACK_VERSION_TYPE_MPATROL          : *ppString  = "mpatrol"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_STACK_VERSION_TYPE_MPEG4IP          : *ppString  = "mpeg4ip-1.3"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_STACK_VERSION_TYPE_MPLAYER          : *ppString  = "MPlayer-1.0pre7try2"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_STACK_VERSION_TYPE_SQLLITE          : *ppString  = "sqlite-2.8.16"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_STACK_VERSION_TYPE_TAGLIB           : *ppString  = "taglib-1.4"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_STACK_VERSION_TYPE_ZLIB             : *ppString  = "zlib-1.1.4"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_STACK_VERSION_TYPE_OPENSSL          : *ppString  = "openssl-0.9.7e"; return VL_MFR_API_RESULT_SUCCESS;
    }

    *ppString  = "Not-Specified";
    return VL_MFR_API_RESULT_NOT_EXISTING;
}

/*===================================================================
FUNCTION: MFR_Init

DESCRIPTION:
    Initialize HAL MFR
RETURN VALUE:
   0 - Success;  Negative values - Failure
SIDE EFFECTS:
   None.
===================================================================*/
int MFR_Init (void)
{
    int indx = 0;

    MFRHAL_HANDLE        hHal = 0;
    MFR_HANDLE           hMfrDriver = 0;
    int nRet = VL_MFR_API_RESULT_SUCCESS;

    //RDK_LOG(RDK_LOG_DEBUG,"LOG.RDK.SYS","%s(): Entry\n", __FUNCTION__);
    RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.SYS", "....................MFR_Init() called....................\n");

    memset(&stHalMFRBase,0,sizeof(stHalMFRBase));
    memset(vlg_aNotifyClients, 0, sizeof(vlg_aNotifyClients));

    for(indx = 0; indx < VL_MAX_MFR_DEVICES; indx++)
    {
        // Initialize instance capabilities
        stHalMFRBase.stCapabilities.astInstanceCapabilities[indx].hMFRHandle = 0;

        /* Registering Callbacks */
        stHalMFRBase.astMFR[indx].hHal         = hHal;
        stHalMFRBase.astMFR[indx].hMfrDriver   = hMfrDriver;
        stHalMFRBase.astMFR[indx].bFree        = 1;
        stHalMFRBase.stCapabilities.usNumMFRs += 1;
    }

    rmf_osal_mutexAcquire(HAL_MFR_get_nvram_access_lock());
    {
    #if defined(USE_MOT_MFR)
        RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.SYS", "%s(): calling motorola_mfr_init()\n", __func__);
        nRet = motorola_mfr_init();
        RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.SYS", "%s(): nRet: %d\n", __func__, nRet);
        motorola_mfr_set_notify(VL_MFR_NOTIFY_MFR_EVENT, (VL_MFR_VOID_CBFUNC_t)HAL_MFR_notify_mfr_event);
        motorola_mfr_set_notify(VL_MFR_NOTIFY_GET_MFR_DATA, (VL_MFR_VOID_CBFUNC_t)HAL_MFR_notify_get_mfr_data);
    #elif defined(USE_BRCM_MFR)
        nRet = broadcom_mfr_init();
        /* HACK: fake return success until broadcom_mfr_init debug */
        RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.SYS", "\nForcing return of success from broadcom_mfr_init in %s\n", __FUNCTION__);
        nRet = VL_MFR_API_RESULT_SUCCESS;
        //broadcom_mfr_nvram_init();
        broadcom_mfr_set_notify(VL_MFR_NOTIFY_MFR_EVENT, (VL_MFR_VOID_CBFUNC_t)HAL_MFR_notify_mfr_event);
        broadcom_mfr_set_notify(VL_MFR_NOTIFY_GET_MFR_DATA, (VL_MFR_VOID_CBFUNC_t)HAL_MFR_notify_get_mfr_data);

    #elif defined(USE_PACE_MFR)
        nRet = pace_mfr_init();
	if (VL_MFR_API_RESULT_SUCCESS == nRet)
	{
        	nRet = pace_mfr_nvram_init();
		printf("%s: pace_mfr_nvram_init returned:%d\n", __FUNCTION__, nRet);
        	pace_mfr_set_notify(VL_MFR_NOTIFY_MFR_EVENT, (VL_MFR_VOID_CBFUNC_t)HAL_MFR_notify_mfr_event);
        	pace_mfr_set_notify(VL_MFR_NOTIFY_GET_MFR_DATA, (VL_MFR_VOID_CBFUNC_t)HAL_MFR_notify_get_mfr_data);
	}
	else
	{
		printf("%s: pace_mfr_init returned:%d\n", __FUNCTION__, nRet);
	}
    #elif defined(USE_INTEL_MFR)
        intel_mfr_init();
        intel_mfr_set_notify(VL_MFR_NOTIFY_MFR_EVENT, (VL_MFR_VOID_CBFUNC_t)HAL_MFR_notify_mfr_event);
        intel_mfr_set_notify(VL_MFR_NOTIFY_GET_MFR_DATA, (VL_MFR_VOID_CBFUNC_t)HAL_MFR_notify_get_mfr_data);
    #elif defined(USE_THOMSON_MFR)
		thomson_mfr_init();
        thomson_mfr_set_notify(VL_MFR_NOTIFY_MFR_EVENT, (VL_MFR_VOID_CBFUNC_t)HAL_MFR_notify_mfr_event);
        thomson_mfr_set_notify(VL_MFR_NOTIFY_GET_MFR_DATA, (VL_MFR_VOID_CBFUNC_t)HAL_MFR_notify_get_mfr_data);
    #elif defined(USE_VIVID_MFR)
        vivid_mfr_init();
        vivid_mfr_set_notify(VL_MFR_NOTIFY_MFR_EVENT, (VL_MFR_VOID_CBFUNC_t)HAL_MFR_notify_mfr_event);
        vivid_mfr_set_notify(VL_MFR_NOTIFY_GET_MFR_DATA, (VL_MFR_VOID_CBFUNC_t)HAL_MFR_notify_get_mfr_data);
    #elif defined(USE_SAM_MFR)
        sam_mfr_init();
        sam_mfr_set_notify(VL_MFR_NOTIFY_MFR_EVENT, (VL_MFR_VOID_CBFUNC_t)HAL_MFR_notify_mfr_event);
        sam_mfr_set_notify(VL_MFR_NOTIFY_GET_MFR_DATA, (VL_MFR_VOID_CBFUNC_t)HAL_MFR_notify_get_mfr_data);
    #else
        vl_mfr_init();
        vl_mfr_set_notify(VL_MFR_NOTIFY_MFR_EVENT, (VL_MFR_VOID_CBFUNC_t)HAL_MFR_notify_mfr_event);
        vl_mfr_set_notify(VL_MFR_NOTIFY_GET_MFR_DATA, (VL_MFR_VOID_CBFUNC_t)HAL_MFR_notify_get_mfr_data);
    #endif
	if (VL_MFR_API_RESULT_SUCCESS == nRet)
	{
        	stHalMFRBase.bIsInitialized            = 1;
	}
    }
    rmf_osal_mutexRelease(HAL_MFR_get_nvram_access_lock());

//  RDK_LOG(RDK_LOG_DEBUG,"LOG.RDK.SYS","%s(): Exit\n", __FUNCTION__);
    return (nRet);
}

VL_MFR_API_RESULT CHALMfr_init()
{
    return (VL_MFR_API_RESULT)MFR_Init();
}

/*===================================================================
FUNCTION: MFR_Shutdown

DESCRIPTION:
    Shuts down HAL MFR
RETURN VALUE:
   0 - Success;  Negative values - Failure
SIDE EFFECTS:
   None.
===================================================================*/
int MFR_Shutdown (void)
{
    //RDK_LOG(RDK_LOG_DEBUG,"LOG.RDK.SYS","%s(): Entry\n", __FUNCTION__);
    RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.SYS", "....................MFR_Shutdown() called....................\n");

    VL_MFR_API_RESULT result = VL_MFR_API_RESULT_FAILED;
    
    rmf_osal_mutexAcquire(HAL_MFR_get_nvram_access_lock());
    {
        memset(vlg_aNotifyClients, 0, sizeof(vlg_aNotifyClients));

    #if defined(USE_BRCM_MFR)
        //
    #elif defined(USE_PACE_MFR)
        //pace_mfr_shutdown();
    #elif defined(USE_MOT_MFR)
        //mot_mfr_shutdown();
    #elif defined(USE_INTEL_MFR)
        //intel_mfr_shutdown();
    #elif defined(USE_VIVID_MFR)
        //vivid_mfr_shutdown();
	#elif defined(USE_THOMSON_MFR)
        //thomson_mfr_shutdown();
	#elif defined(USE_SAM_MFR)
        //sam_mfr_shutdown();
    #else
        vl_mfr_shutdown();
    #endif

        stHalMFRBase.bIsInitialized            = 0;
    }
    rmf_osal_mutexRelease(HAL_MFR_get_nvram_access_lock());

//  RDK_LOG(RDK_LOG_DEBUG,"LOG.RDK.SYS","%s(): Exit\n", __FUNCTION__);
    return (HAL_SUCCESS);
}

/*===================================================================
FUNCTION: HAL_MFR_GetCapabilities

DESCRIPTION:
    Returns the tuner capabilities in the MFR_CAPABILITIES_t structure.
RETURN VALUE:
   0 - Success;  Negative values - Failure
SIDE EFFECTS:
   None.
===================================================================*/
int HAL_MFR_GetCapabilities (VL_MFR_CAPABILITIES_t *pstCapabilities)
{
    RDK_LOG(RDK_LOG_DEBUG,"LOG.RDK.POD","%s(): Entry\n", __FUNCTION__);
    RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.SYS", "....................HAL_MFR_GetCapabilities() called....................\n");

    // Check whether tuner is initialized
    if (!stHalMFRBase.bIsInitialized)
    {
        LOGERROR("LOG.RDK.SYS","%s(): %s: HAL MFR not initialized \n",
                 __FUNCTION__,SYS_Error_String(ERROR_HAL_NOT_INITIALIZED));
        return(ERROR_HAL_NOT_INITIALIZED);
    }

    // Check for null parameters
    if (pstCapabilities == NULL)
    {
        LOGERROR("LOG.RDK.SYS","%s(): %s: Null Parameter \n",
                 __FUNCTION__,SYS_Error_String(ERROR_HAL_NULL_PARAMETER));
        return(ERROR_HAL_NULL_PARAMETER);
    }

    memcpy((void *)pstCapabilities, &(stHalMFRBase.stCapabilities), sizeof(VL_MFR_CAPABILITIES_t));

    RDK_LOG(RDK_LOG_DEBUG,"LOG.RDK.SYS","%s(): Exit\n", __FUNCTION__);
    return(HAL_SUCCESS);
}



/*===================================================================
FUNCTION: HAL_MFR_Request

DESCRIPTION:

RETURN VALUE:
   0 - Success;  Negative values - Failure
SIDE EFFECTS:
   None.
===================================================================*/
int HAL_MFR_Request( DEVICE_HANDLE_t hMFRHandle)
{
    MFR_t *pstMFR;

    RDK_LOG(RDK_LOG_DEBUG,"LOG.RDK.SYS","%s(): Entry\n", __FUNCTION__);

    LOGINFO("LOG.RDK.SYS","%s(): Requested MFR handle %lX\n", __FUNCTION__, hMFRHandle);

    // Check for invalid handle and Get the tuner from the handle
    if ((pstMFR = MFR_GetMFRFromHandle(hMFRHandle)) == NULL)
    {
        LOGERROR("LOG.RDK.SYS","%s(): %s: Invalid MFR Handle \n",
                 __FUNCTION__,SYS_Error_String(ERROR_HAL_INVALID_HANDLE));
        return(ERROR_HAL_INVALID_HANDLE);
    }

    // Check the state of MFR
    if (!pstMFR->bFree)
    {
        LOGERROR("LOG.RDK.SYS","%s(): %s: MFR device not available \n",
                 __FUNCTION__,SYS_Error_String(ERROR_HAL_DEVICE_NOT_AVAILABLE));
        return(ERROR_HAL_DEVICE_NOT_AVAILABLE );
    }

    // Mark this MFR as not free
    pstMFR->bFree = false;

    RDK_LOG(RDK_LOG_DEBUG,"LOG.RDK.SYS","%s(): Exit\n", __FUNCTION__);
    return(HAL_SUCCESS);
}




/*===================================================================
FUNCTION: "LOG.RDK.SYS_Release"

DESCRIPTION:
    Releases the MFR specified by MFR handle parameter.
RETURN VALUE:
   0 - Success;  Negative values - Failure
SIDE EFFECTS:
   None.
===================================================================*/
int HAL_MFR_Release (DEVICE_HANDLE_t hMFRHandle)
{
    MFR_t *pstMFR;

    RDK_LOG(RDK_LOG_DEBUG,"LOG.RDK.SYS","%s(): Entry\n", __FUNCTION__);

    LOGINFO("LOG.RDK.SYS","%s(): MFR handle to be released %lX\n", __FUNCTION__, hMFRHandle);

    // Check for invalid handle and Get the tuner from the handle
    if ((pstMFR = MFR_GetMFRFromHandle(hMFRHandle)) == NULL)
    {
        LOGERROR("LOG.RDK.SYS","%s(): %s: Invalid Tuner Handle \n",
                 __FUNCTION__,SYS_Error_String(ERROR_HAL_INVALID_HANDLE));
        return(ERROR_HAL_INVALID_HANDLE);
    }

    // Check for MFR not requested
    if (pstMFR->bFree)
    {
        LOGERROR("LOG.RDK.SYS","%s(): %s: MFR is not requested \n",
                 __FUNCTION__,SYS_Error_String(ERROR_HAL_NOT_REQUESTED));
        return(ERROR_HAL_NOT_REQUESTED);
    }

    // Mark this MFR as free
    pstMFR->bFree = true;

    RDK_LOG(RDK_LOG_DEBUG,"LOG.RDK.SYS","%s(): Exit\n", __FUNCTION__);
    return(HAL_SUCCESS);
}

/*===================================================================
FUNCTION: MFR_GetMFRFromHandle

DESCRIPTION:
    Get the Mfr pointer from the device handle.
RETURN VALUE:
//    Pionter to Mfr
SIDE EFFECTS:
   None.
===================================================================*/
MFR_t * MFR_GetMFRFromHandle (unsigned int hMFRHandle)
{
   return &stHalMFRBase.astMFR[0];
}

VL_MFR_API_RESULT HAL_MFR_set_notify( VL_MFR_DEVICE_HANDLE_t hMFRHandle, VL_MFR_NOTIFY_TYPE_t notifyType, VL_MFR_VOID_CBFUNC_t pfnNotifyFunc, void* pulData)
{
	RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.POD", "%s: hMFRHandle %lu.  \n", __FUNCTION__, (unsigned long int)hMFRHandle);
//    int i = 0;

    if(NULL != pfnNotifyFunc)
    {
        if(vlg_nNotifyClients >= VL_MAX_MFR_CLIENTS)
        {
            LOGERROR("LOG.RDK.SYS","%s(): %s: Too many notify / callback registrations\n",
                     __FUNCTION__,SYS_Error_String(ERROR_HAL_OUT_OF_RANGE));
            return VL_MFR_API_RESULT_OUT_OF_RANGE;
        }
        else
        {
            vlg_aNotifyClients[vlg_nNotifyClients].eCBType   = notifyType;
            vlg_aNotifyClients[vlg_nNotifyClients].pCBData   = pulData;
            vlg_aNotifyClients[vlg_nNotifyClients].pCallback = pfnNotifyFunc;

            vlg_nNotifyClients++;
        }
    }
    else
    {
        LOGERROR("LOG.RDK.SYS","%s(): %s: NULL Callback Specified \n",
                 __FUNCTION__,SYS_Error_String(ERROR_HAL_NULL_PARAMETER));
        return VL_MFR_API_RESULT_NULL_PARAM;
    }

    return VL_MFR_API_RESULT_SUCCESS;
}

VL_MFR_API_RESULT HAL_MFR_get_version_name( VL_MFR_DEVICE_HANDLE_t hMFRHandle, VL_PLATFORM_VERSION_TYPE eVersionType, char ** ppString)
{
	RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.POD", "%s: hMFRHandle %lu.  \n", __FUNCTION__, (unsigned long int)hMFRHandle);

    VL_MFR_API_RESULT result = VL_MFR_API_RESULT_FAILED;
    
    rmf_osal_mutexAcquire(HAL_MFR_get_nvram_access_lock());
    {
#if defined(USE_MOT_MFR)
        result = motorola_mfr_get_version_name(eVersionType, ppString);
#elif defined(USE_BRCM_MFR)
        result = broadcom_mfr_get_version_name(eVersionType, ppString);
#elif defined(USE_PACE_MFR)
        result = pace_mfr_get_version_name(eVersionType, ppString);
#elif defined(USE_INTEL_MFR)
        result = intel_mfr_get_version_name(eVersionType, ppString);
#elif defined(USE_THOMSON_MFR)
        result = thomson_mfr_get_version_name(eVersionType, ppString);
#elif defined(USE_VIVID_MFR)
        result = vivid_mfr_get_version_name(eVersionType, ppString);
#elif defined(USE_SAM_MFR)
        result = sam_mfr_get_version_name(eVersionType, ppString);
#else
        result = vl_mfr_get_version_name(eVersionType, ppString);
#endif
    }
    rmf_osal_mutexRelease(HAL_MFR_get_nvram_access_lock());
    
    return result;
}

VL_MFR_API_RESULT HAL_MFR_get_version     ( VL_MFR_DEVICE_HANDLE_t hMFRHandle, VL_PLATFORM_VERSION_TYPE eVersionType, char ** ppString)
{
	RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.POD", "%s: hMFRHandle %lu.  \n", __FUNCTION__, (unsigned long int)hMFRHandle);

    VL_MFR_API_RESULT result = VL_MFR_API_RESULT_FAILED;
    
    rmf_osal_mutexAcquire(HAL_MFR_get_nvram_access_lock());
    {
#if defined(USE_MOT_MFR)
        result = motorola_mfr_get_version(eVersionType, ppString);
#elif defined(USE_BRCM_MFR)
        result = broadcom_mfr_get_version(eVersionType, ppString);
#elif defined(USE_PACE_MFR)
        result = pace_mfr_get_version(eVersionType, ppString);
#elif defined(USE_INTEL_MFR)
        result = intel_mfr_get_version(eVersionType, ppString);
#elif defined(USE_THOMSON_MFR)
        result = thomson_mfr_get_version(eVersionType, ppString);
#elif defined(USE_VIVID_MFR)
        result = vivid_mfr_get_version(eVersionType, ppString);
#elif defined(USE_SAM_MFR)
        result = sam_mfr_get_version(eVersionType, ppString);
#else
        result = vl_mfr_get_version(eVersionType, ppString);
#endif
    }
    rmf_osal_mutexRelease(HAL_MFR_get_nvram_access_lock());
    
    return result;
}

VL_MFR_API_RESULT HAL_MFR_read_normal_nvram ( VL_MFR_DEVICE_HANDLE_t hMFRHandle, VL_NORMAL_NVRAM_DATA_TYPE eType, VL_NVRAM_DATA * pNvRamData)
{
    RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.POD", "%s: hMFRHandle %lu.  \n", __FUNCTION__, (unsigned long int)hMFRHandle);

    VL_MFR_API_RESULT result = VL_MFR_API_RESULT_FAILED;
    
    rmf_osal_mutexAcquire(HAL_MFR_get_nvram_access_lock());
    {
#if defined(USE_MOT_MFR)
        RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.POD", "%s(): calling motorola_mfr_read_normal_nvram(): eType: 0x%x\n", __func__, eType);
        result = motorola_mfr_read_normal_nvram(eType, pNvRamData);
#elif defined(USE_BRCM_MFR)
        result = broadcom_mfr_read_normal_nvram(eType, pNvRamData);
#elif defined(USE_PACE_MFR)
        result = pace_mfr_read_normal_nvram(eType, pNvRamData);
#elif defined(USE_INTEL_MFR)
        result = intel_mfr_read_normal_nvram(eType, pNvRamData);
#elif defined(USE_THOMSON_MFR)
        result = thomson_mfr_read_normal_nvram(eType, pNvRamData);
#elif defined(USE_VIVID_MFR)
        result = vivid_mfr_read_normal_nvram(eType, pNvRamData);
#elif defined(USE_SAM_MFR)
        result = sam_mfr_read_normal_nvram(eType, pNvRamData);
#else
        result = vl_mfr_read_normal_nvram(eType, pNvRamData);
#endif
    }
    rmf_osal_mutexRelease(HAL_MFR_get_nvram_access_lock());
    
    return result;
}

VL_MFR_API_RESULT HAL_MFR_write_normal_nvram( VL_MFR_DEVICE_HANDLE_t hMFRHandle, VL_NORMAL_NVRAM_DATA_TYPE eType, const VL_NVRAM_DATA * pNvRamData)
{
    RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.POD", "%s: hMFRHandle %lu.  \n", __FUNCTION__, (unsigned long int)hMFRHandle);

    VL_MFR_API_RESULT result = VL_MFR_API_RESULT_FAILED;
    
    rmf_osal_mutexAcquire(HAL_MFR_get_nvram_access_lock());
    {
#if defined(USE_MOT_MFR)
        RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.POD", "%s(): calling motorola_mfr_write_normal_nvram(): eType: 0x%x\n", __func__, eType);
        result = motorola_mfr_write_normal_nvram(eType, pNvRamData);
        RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.POD", "%s(): result: %d\n", __func__, result);
#elif defined(USE_BRCM_MFR)
        result = broadcom_mfr_write_normal_nvram(eType, pNvRamData);
#elif defined(USE_PACE_MFR)
        result = pace_mfr_write_normal_nvram(eType, pNvRamData);
#elif defined(USE_INTEL_MFR)
        result = intel_mfr_write_normal_nvram(eType, pNvRamData);
#elif defined(USE_THOMSON_MFR)
        result = thomson_mfr_write_normal_nvram(eType, pNvRamData);
#elif defined(USE_VIVID_MFR)
        result = vivid_mfr_write_normal_nvram(eType, pNvRamData);
#elif defined(USE_SAM_MFR)
        result = sam_mfr_write_normal_nvram(eType, pNvRamData);
#else
        result = vl_mfr_write_normal_nvram(eType, pNvRamData);
#endif
    }
    rmf_osal_mutexRelease(HAL_MFR_get_nvram_access_lock());
    
    return result;
}

VL_MFR_API_RESULT HAL_MFR_read_secure_nvram ( VL_MFR_DEVICE_HANDLE_t hMFRHandle, VL_SECURE_NVRAM_DATA_TYPE eType, VL_NVRAM_DATA * pNvRamData)
{
	RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.POD", "%s: hMFRHandle %lu.  \n", __FUNCTION__, (unsigned long int)hMFRHandle);

    VL_MFR_API_RESULT result = VL_MFR_API_RESULT_FAILED;
    
    rmf_osal_mutexAcquire(HAL_MFR_get_nvram_access_lock());
    {
#if defined(USE_MOT_MFR)
        RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.POD", "%s(): calling motorola_mfr_read_secure_nvram(): eType: 0x%x\n", __func__, eType);
        result = motorola_mfr_read_secure_nvram(eType, pNvRamData);
        RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.POD", "%s(): result: %d, eType: 0x%x\n", __func__, result, eType);
        if(VL_MFR_API_RESULT_SUCCESS != result)
        {
            RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.POD", "%s(): NOT forcing success, eType: 0x%x\n", __func__, eType);
        }
#elif defined(USE_BRCM_MFR)
        result = broadcom_mfr_read_secure_nvram(eType, pNvRamData);
#elif defined(USE_PACE_MFR)
        result = pace_mfr_read_secure_nvram(eType, pNvRamData);
#elif defined(USE_INTEL_MFR)
        result = intel_mfr_read_secure_nvram(eType, pNvRamData);
#elif defined(USE_THOMSON_MFR)
        result = thomson_mfr_read_secure_nvram(eType, pNvRamData);
#elif defined(USE_VIVID_MFR)
        result = vivid_mfr_read_secure_nvram(eType, pNvRamData);
#elif defined(USE_SAM_MFR)
        result = sam_mfr_read_secure_nvram(eType, pNvRamData);
#else
        result = vl_mfr_read_secure_nvram(eType, pNvRamData);
#endif
    }
    rmf_osal_mutexRelease(HAL_MFR_get_nvram_access_lock());
    
    return result;
}

VL_MFR_API_RESULT HAL_MFR_write_secure_nvram( VL_MFR_DEVICE_HANDLE_t hMFRHandle, VL_SECURE_NVRAM_DATA_TYPE eType, const VL_NVRAM_DATA * pNvRamData)
{
	RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.POD", "%s: hMFRHandle %lu.  \n", __FUNCTION__, (unsigned long int)hMFRHandle);

    VL_MFR_API_RESULT result = VL_MFR_API_RESULT_FAILED;
    
    rmf_osal_mutexAcquire(HAL_MFR_get_nvram_access_lock());
    {
#if defined(USE_MOT_MFR)
        RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.POD", "%s(): calling motorola_mfr_write_secure_nvram(): eType: 0x%x\n", __func__, eType);
        result = motorola_mfr_write_secure_nvram(eType, pNvRamData);
        RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.POD", "%s(): result: %d\n", __func__, result);
#elif defined(USE_BRCM_MFR)
        result = broadcom_mfr_write_secure_nvram(eType, pNvRamData);
#elif defined(USE_PACE_MFR)
        result = pace_mfr_write_secure_nvram(eType, pNvRamData);
#elif defined(USE_INTEL_MFR)
        result = intel_mfr_write_secure_nvram(eType, pNvRamData);
#elif defined(USE_THOMSON_MFR)
        result = thomson_mfr_write_secure_nvram(eType, pNvRamData);
#elif defined(USE_VIVID_MFR)
        result = vivid_mfr_write_secure_nvram(eType, pNvRamData);
#elif defined(USE_SAM_MFR)
        result = sam_mfr_write_secure_nvram(eType, pNvRamData);
#else
        result = vl_mfr_write_secure_nvram(eType, pNvRamData);
#endif
    }
    rmf_osal_mutexRelease(HAL_MFR_get_nvram_access_lock());
    
    return result;
}


VL_MFR_API_RESULT HAL_MFR_set_mfr_data( VL_MFR_DEVICE_HANDLE_t hMFRHandle, VL_STACK_2_MFR_EVENT_TYPE eEvent, void * _pvData)
{
    RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.POD", "%s: hMFRHandle %lu.  \n", __FUNCTION__, (unsigned long int)hMFRHandle);

    VL_MFR_API_RESULT result = VL_MFR_API_RESULT_FAILED;
    
    //May-23-2012: fix for XONE-1829: some calls here may block for a significant period of time // rmf_osal_mutexAcquire(HAL_MFR_get_nvram_access_lock());
    {
#if defined(USE_MOT_MFR)
        RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.POD", "%s(): using motorola_mfr_set_mfr_data() \n", __func__);
        result = motorola_mfr_set_mfr_data(eEvent, _pvData);
#elif defined(USE_BRCM_MFR)
        result = broadcom_mfr_set_mfr_data(eEvent, _pvData);
#elif defined(USE_PACE_MFR)
        result = pace_mfr_set_mfr_data(eEvent, _pvData);
#elif defined(USE_INTEL_MFR)
        result = intel_mfr_set_mfr_data(eEvent, _pvData);
#elif defined(USE_THOMSON_MFR)
        result = thomson_mfr_set_mfr_data(eEvent, _pvData);
#elif defined(USE_VIVID_MFR)
        result = vivid_mfr_set_mfr_data(eEvent, _pvData);
#elif defined(USE_SAM_MFR)
        result = sam_mfr_set_mfr_data(eEvent, _pvData);
#else
        result = vl_mfr_set_mfr_data(eEvent, _pvData);
#endif
    }
    //May-23-2012: fix for XONE-1829: some calls here may block for a significant period of time // rmf_osal_mutexRelease(HAL_MFR_get_nvram_access_lock());
    
    return result;
}

VL_MFR_API_RESULT HAL_MFR_get_mfr_data( VL_MFR_DEVICE_HANDLE_t hMFRHandle, VL_STACK_2_MFR_EVENT_TYPE eEvent, void * _pvData)
{
    RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.POD", "%s: hMFRHandle %lu.  \n", __FUNCTION__, (unsigned long int)hMFRHandle);

    VL_MFR_API_RESULT result = VL_MFR_API_RESULT_FAILED;
    
    //May-23-2012: fix for XONE-1829: some calls here may block for a significant period of time // rmf_osal_mutexAcquire(HAL_MFR_get_nvram_access_lock());
    {
#if defined(USE_MOT_MFR)
        RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.POD", "%s(): calling motorola_mfr_get_mfr_data(eEvent: 0x%x)\n", __func__, eEvent);
        result = motorola_mfr_get_mfr_data(eEvent, _pvData);
        RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.POD", "%s(): result: %d, _pvData: %p\n", __func__, result, _pvData);
#elif defined(USE_BRCM_MFR)
        result = broadcom_mfr_get_mfr_data(eEvent, _pvData);
#elif defined(USE_PACE_MFR)
        result = pace_mfr_get_mfr_data(eEvent, _pvData);
#elif defined(USE_INTEL_MFR)
        result = intel_mfr_get_mfr_data(eEvent, _pvData);
#elif defined(USE_THOMSON_MFR)
        result = thomson_mfr_get_mfr_data(eEvent, _pvData);
#elif defined(USE_VIVID_MFR)
        result = vivid_mfr_get_mfr_data(eEvent, _pvData);
#elif defined(USE_SAM_MFR)
        result = sam_mfr_get_mfr_data(eEvent, _pvData);
#else
        result = vl_mfr_get_mfr_data(eEvent, _pvData);
#endif
    }
    //May-23-2012: fix for XONE-1829: some calls here may block for a significant period of time // rmf_osal_mutexRelease(HAL_MFR_get_nvram_access_lock());

    if(VL_STACK_2_MFR_EVENT_get_CONFIG_PATH == eEvent)
    {
        VL_MFR_CONFIG_PATH * pStruct = (VL_MFR_CONFIG_PATH*)_pvData;
	    const char *value = rmf_osal_envGet("CONFIG.PERSISTENT.ROOT");
	    if (value != NULL)
	    {
	        strncpy(pStruct->szConfigPath, value, sizeof(pStruct->szConfigPath));
	    }
		else
		{
			strncpy(pStruct->szConfigPath, "/opt/", sizeof(pStruct->szConfigPath));
		}
		pStruct->szConfigPath[VL_MAX_MFR_STR_SIZE-1]= 0;
    }
    
    return result;
}

// Begin: Compilation Safeguard
#if defined(USE_MOT_MFR)
    //static int vlg_mfr_compile_conflict = 0; // cannot have more than one MFR defined
#endif
#if defined(USE_BRCM_MFR)
        static int vlg_mfr_compile_conflict = 0; // cannot have more than one MFR defined
#endif

// Begin: Compilation Safeguard
#if defined(USE_PACE_MFR)
    static int vlg_mfr_compile_conflict = 0; // cannot have more than one MFR defined
#endif

#if defined(USE_INTEL_MFR)
    static int vlg_mfr_compile_conflict = 0; // cannot have more than one MFR defined
#endif

#if defined(USE_THOMSON_MFR)
    static int vlg_mfr_compile_conflict = 0; // cannot have more than one MFR defined
#endif
#if defined(USE_VIVID_MFR)
    static int vlg_mfr_compile_conflict = 0; // cannot have more than one MFR defined
#endif
#if defined(USE_SAM_MFR)
    static int vlg_mfr_compile_conflict = 0; // cannot have more than one MFR defined
#endif
// End:   Compilation Safeguard

#endif // USE_MFR
