/*-----------------------------------------------------------------*/
/******************************************************************************
* Copyright (c) 2011 SeaChange International (SeaChange) and its Licensors. 
* All rights reserved.
*
* This software is the confidential and proprietary information of SeaChange
* ("Confidential Information"). You shall not disclose this source code or 
* such Confidential Information and shall use it only in accordance with the 
* terms of the license agreement you entered into.
*  
* SEACHANGE INERNATIONAL  MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE 
* SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT 
* LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A 
* PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SEACHANGE SHALL NOT BE LIABLE FOR 
* ANY DAMAGES SUFFERED BY LICENSEE NOR SHALL THEY BE RESPONSIBLE AS A RESULT 
* OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
*******************************************************************************/


/*-----------------------------------------------------------------*/
#ifndef __VL_MFR_PRIV_H__
#define __VL_MFR_PRIV_H__
/*-----------------------------------------------------------------*/
#ifdef __cplusplus
extern "C" {
#endif
/*-------------------------------------------------------------------
    Include Files
-------------------------------------------------------------------*/

#include "hal_api.h"
#include "vl_mfr_api.h"

typedef void * MFRHAL_HANDLE;
typedef void * MFR_HANDLE;

/*-------------------------------------------------------------------
    Defines/Macros
-------------------------------------------------------------------*/

typedef enum _MFR_RESULT
{
    MFR_OK,
    MFR_ERROR
}MFR_RESULT;

/*-------------------------------------------------------------------
   Types/Structs
-------------------------------------------------------------------*/

#define VL_MAX_MFR_CLIENTS  32

typedef struct
{
    unsigned char                       usIndex;
    int                                 bFree;            // Whether the POD Module is free/already requested
    MFRHAL_HANDLE                       hHal;
    MFR_HANDLE                          hMfrDriver;

}MFR_t;

typedef struct
{
    int                     bIsInitialized;         // Whether HAL MFR is initialized
    VL_MFR_CAPABILITIES_t   stCapabilities;
    MFR_t                   astMFR[VL_MAX_MFR_DEVICES]; // Array of MFR modules
} MFR_BASE_t;

typedef struct
{
    VL_MFR_NOTIFY_TYPE_t    eCBType;
    VL_MFR_VOID_CBFUNC_t    pCallback;
    void                *   pCBData;
} VL_MFR_NOTIFY_VOID_CLIENT_t;

/*-------------------------------------------------------------------
   Global Data Declarations
-------------------------------------------------------------------*/
//extern MFR_BASE_t stHalMFRBase;

/*-----------------------------------------------------------------*/
#ifdef __cplusplus
}
#endif
/*-----------------------------------------------------------------*/
#endif //__VL_MFR_PRIV_H__
/*-----------------------------------------------------------------*/
