/******************************************************************************
* Copyright (c) 2011 SeaChange International (SeaChange) and its Licensors. 
* All rights reserved.
*
* This software is the confidential and proprietary information of SeaChange
* ("Confidential Information"). You shall not disclose this source code or 
* such Confidential Information and shall use it only in accordance with the 
* terms of the license agreement you entered into.
*  
* SEACHANGE INERNATIONAL  MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE 
* SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT 
* LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A 
* PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SEACHANGE SHALL NOT BE LIABLE FOR 
* ANY DAMAGES SUFFERED BY LICENSEE NOR SHALL THEY BE RESPONSIBLE AS A RESULT 
* OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
*******************************************************************************/







#ifndef __CI_H
#define __CI_H

//#if (defined MR05_P0 | defined MR05_P1)

#ifdef __cplusplus
extern "C" {
#endif

#define CI_MAXSIZE_LENGTH_FIELD 5 /* 1 byte for size indicator and length field size
                                   * 4 byte (long) for the length value */
#ifdef DO_IT_LATER

UCHAR   ci_SetLength (UCHAR *pData, ULONG lSize);
UCHAR   ci_GetLength (UCHAR *pData, USHORT *plSize);

void    ByteStreamPutWord24(UCHAR *stream, ULONG data);
ULONG   ByteStreamGetWord24(const UCHAR *stream);
USHORT  ByteStreamGetWord(const UCHAR *stream);
void    ByteStreamPutWord(UCHAR *stream, USHORT data);
ULONG   ByteStreamGetLongWord(const UCHAR *stream);
void    ByteStreamPutLongWord(UCHAR *stream, ULONG data);

/* Change the POD stack state */
void POD_ChangeState ( UCHAR bState );

UCHAR POD_GetPODState (void );

/* Let homing control some operations */
//void CIResetPCMCIA (void);
void CIResetPod ();
void CITransTimeoutCtrl (BOOL bDisableTimeout);
void CIHomingStateChange (BOOL bHomingInProgress); // == TRUE if started, == FALSE if ended

/* Means homing currently in progress if TRUE */
extern BOOL bHomingInProgress;

#endif
/************************************************************/

typedef enum
{
    UNKNOWN_POD  = 0,
    DK_HPNX_POD  = 1,
    SA_POD       = 2,
    MOT_POD      = 3,
    NDS_POD      = 4,
    FLASH_CARD   = 10
} POD_MANUFACTURER_t;


extern POD_MANUFACTURER_t bPodManufacturer;


#ifdef __cplusplus
}
#endif

//#endif // MR05_P0 | MR05_P1

#endif // __CI_H

