/*
* ============================================================================
* RDK MANAGEMENT, LLC CONFIDENTIAL AND PROPRIETARY
* ============================================================================
* This file (and its contents) are the intellectual property of RDK Management, LLC.
* It may not be used, copied, distributed or otherwise  disclosed in whole or in
* part without the express written permission of RDK Management, LLC.
* ============================================================================
* Copyright (C) 2017 Broadcom. The term "Broadcom" refers to Broadcom Limited and/or its subsidiaries.
* Copyright (c) 2017 RDK Management, LLC. All rights reserved.
* ============================================================================
*/

///////////////////////////////////////////////////////////
//  rmf_SectionFilter_DSG_APPID.h
//  Implementation of the Class rmf_SectionFilter_DSG_APPID
//  Created on:      20-Jul-2012 12:35:04 PM
//  Original author: Sunil S
///////////////////////////////////////////////////////////

#if !defined __RMF_SECTIONFILTER_DSG_APPID__
#define __RMF_SECTIONFILTER_DSG_APPID__

#include "dsg_types.h"
#include "dsgClientController.h"

#include "rmf_sectionfilter.h"

#define DSG_MAX_SECITON_FILTER          32
#define DSG_MAX_PID_FILTER              100
#define MAX_SECTION_SIZE                4*1024
#define MAX_OOB_SESSION                         5
//#define SECTFLT_MAX_MESSAGE_SIZE      (4*1024)

#define SECITON_FILTER_AVAILABLE                0x100 
#define SECITON_FILTER_INUSE                    0x200

typedef struct tagSectionFilterParams
{
        uint8_t* pos_mask;
        uint8_t* pos_value;
        uint16_t pos_length;
        uint8_t* neg_mask;
        uint8_t* neg_value;
        uint16_t neg_length;
}SectionFilterParams;

typedef struct tagSectionFilterInfo
{
        int                             SectionFilterHandle;
        SectionFilterParams             filterParams;
        int                             filterStatus;
//        vl_SectionFilter_t              *pSectionFilterInstance;
}SectionFilterInfo;

typedef struct DSG_SectionFilter_Info_s
{
        uint32_t                    m_ulPid;
        unsigned long                           m_nRegistrationId;
        unsigned long                           m_SectionFilterHandle;

}Dsg_SectionFilter_Info_t;

typedef struct tagPidList
{
        int                     PidListStatus;
        uint8_t                 pid;
}PidList;

typedef struct tagDsgTunnelSession
{
	int 				m_dsgAppId;
	unsigned long			m_nRegistrationId;
	PidList				m_pidList[DSG_MAX_PID_FILTER];
//	unsigned short 			m_dsmccPid;
//	int 					m_numFilters;		// if it become zero, kill the thread.
	SectionFilterInfo		m_sectionFilterList[DSG_MAX_SECITON_FILTER];
	rmf_osal_Mutex 		m_sfListMutex;
//	int						m_stFilterCnt;
	rmf_osal_Mutex		m_pidListMutex;
       void*                            m_pData;

}DsgTunnelSession;


class rmf_SectionFilter_DSG_APPID : public rmf_SectionFilter
{

public:
	rmf_SectionFilter_DSG_APPID(void* pFilterParm);
	virtual ~rmf_SectionFilter_DSG_APPID();

private:
	RMF_SECTFLT_RESULT Create(uint16_t pid, uint8_t* pos_mask, uint8_t* pos_value, uint16_t pos_length, uint8_t* neg_mask, uint8_t* neg_value, uint16_t neg_length, void **pSectionFilterInfo, uint32_t* pFilterID);
	RMF_SECTFLT_RESULT Start(uint32_t filterID, const rmf_FilterSpec *filterSpec);
	RMF_SECTFLT_RESULT Release(uint32_t filterID);
	RMF_SECTFLT_RESULT Stop(uint32_t filterID);
	RMF_SECTFLT_RESULT Read(uint32_t filterID, rmf_Section_Data** ppSectionData);

       static void DsgClientThread(void *data);
	void DsgClientThreadFn(void);

        static int stDsgAppTunnelCallback(unsigned long RegistrationId,
                                unsigned long AppData,
                                VL_DSG_CLIENT_ID_ENC_TYPE eClientType,
                                unsigned long long        nClientId,
                                unsigned long             nBytes,
                                unsigned char*            pData);
        
        int stDsgAppTunnelCallbackfn(unsigned long RegistrationId,
				unsigned long AppData,
				VL_DSG_CLIENT_ID_ENC_TYPE eClientType,
				unsigned long long        nClientId,
				unsigned long             nBytes,
				unsigned char*            pData);

	void AddTunnelSessionTotheList(DsgTunnelSession* pSession);
	DsgTunnelSession* getTunnelSessionForAppId(int appId);
	DsgTunnelSession* getTunnelSessionForClientId(int appId);
	void LockPidList(DsgTunnelSession* pDsgTunnelSession);
	void UnLockPidList(DsgTunnelSession* pDsgTunnelSession);
	void LocksfList(DsgTunnelSession* pDsgTunnelSession);
	void UnLocksfList(DsgTunnelSession* pDsgTunnelSession);

	void AddPidTotheList(uint8_t pid, unsigned long RegistrationId);
	void RemovePidFromTheList(uint8_t pid, unsigned long RegistrationId);
	bool IsARegisteredPid(uint8_t pid, unsigned long RegistrationId);

	void DispatchSectionData(unsigned char *pData, int dataLen, unsigned long RegistrationId);
	int sw_filter(unsigned char *pData, int dataLen, SectionFilterParams	*pFilterParams);

	RMF_SECTFLT_RESULT DSG_OpenTunnelFlow(Dsg_SectionFilter_Info_t *pDsgFilterInfo);
	RMF_SECTFLT_RESULT DSG_StartPidFilter(Dsg_SectionFilter_Info_t *pDsgFilterInfo, uint8_t pid);
	RMF_SECTFLT_RESULT DSG_AddFilter( Dsg_SectionFilter_Info_t *pDsgFilterInfo, uint8_t* pos_mask, uint8_t* pos_value, uint16_t pos_length,
					  uint8_t* neg_mask, uint8_t* neg_value,	uint16_t neg_length);
	RMF_SECTFLT_RESULT DSG_RemoveFilter(Dsg_SectionFilter_Info_t *pDsgFilterInfo);
	RMF_SECTFLT_RESULT DSG_StopPidFilter(Dsg_SectionFilter_Info_t *pDsgFilterInfo);
	RMF_SECTFLT_RESULT DSG_CloseTunnelFlow(Dsg_SectionFilter_Info_t *pDsgFilterInfo);

	
	unsigned long DsgRegisterClientSim(VL_DSG_CLIENT_CBFUNC_t    pfClientCB,
	                                  unsigned long             nAppData,
	                                  VL_DSG_CLIENT_ID_ENC_TYPE eClientType,
	                                  unsigned long long        nClientId);
	
	
	DsgTunnelSession* InitializeTunnel(void);
	
private:
	uint32_t appId;
	
	/* static */ DsgTunnelSession*  st_pDsgTunnelSessionList[MAX_OOB_SESSION];
	static VL_DSG_CLIENT_CBFUNC_t dsgCallback;
	static unsigned long dsgclientAppData;
	static unsigned long long       dsgClientId;
	static VL_DSG_CLIENT_ID_ENC_TYPE dsgeClientType;
        bool bOOBCopied;
        FILE *pOOBFile;
        static int nSect_Count;

};
#endif // !defined __RMF_SECTIONFILTER_DSG_APPID__
