/*
* ============================================================================
* RDK MANAGEMENT, LLC CONFIDENTIAL AND PROPRIETARY
* ============================================================================
* This file (and its contents) are the intellectual property of RDK Management, LLC.
* It may not be used, copied, distributed or otherwise  disclosed in whole or in
* part without the express written permission of RDK Management, LLC.
* ============================================================================
* Copyright (C) 2017 Broadcom. The term "Broadcom" refers to Broadcom Limited and/or its subsidiaries.
* Copyright (c) 2017 RDK Management, LLC. All rights reserved.
* ============================================================================
*/

///////////////////////////////////////////////////////////
//  rmf_SectionFilter_INB.h
//  Implementation of the Class rmf_SectionFilter_INB
//  Created on:      20-Jul-2012 12:35:12 PM
//  Original author: Sunil S
///////////////////////////////////////////////////////////

#if !defined __RMF_SECTIONFILTER_INB__
#define __RMF_SECTIONFILTER_INB__

#include <semaphore.h>

#include "nexus_memory.h"
#include "nexus_parser_band.h"
#include "nexus_message.h"
#include "nexus_pid_channel.h"
#include "nexus_platform.h"
#include "nexus_core_utils.h"

#include "rmf_osal_sync.h"
#include "rmf_sectionfilter.h"

#define MAX_FILTER_COUNT                4 /*ericz, reduce from 32 to 4 for each instance*/
#define MAX_COUNT                       16
#define NEXUS_PSI_PKT_LENGTH (32 * 1024)
#define SECTFLT_MAX_MESSAGE_SIZE (4*1024)
#define    CRC_TABLE_SIZE    256

#ifdef RMF_SF_SINGLE_THREAD_ENABLE
#define RMF_INB_SF_EVENT_UNKNOWN                        (0x00001100)
#define RMF_INB_SF_EVENT_NEWSECTION			(RMF_INB_SF_EVENT_UNKNOWN + 1)
#define RMF_INB_SF_EVENT_SHUTDOWN			(RMF_INB_SF_EVENT_UNKNOWN + 2)
#endif

typedef void (*TRNSPT_CALLBACK_t) (void *context, int param);

typedef enum PDT_PidChannelType
{
    PDT_PidChannelType_AudioVideo = 0x10,
    PDT_PidChannelType_ePsi
}PDT_PidChannelType;

typedef enum FilterQuitStatus
{
        SF_THREAD_ACTIVE = 0x200,
        SF_THREAD_INACTIVE,
        SF_THREAD_QUIT
}FilterQuitStatus;

typedef enum FilterState
{
        INVALID_FILTER = 0x100,
        VALID_FILTER,
        FILTER_STARTED
}FilterState;

/**
 * In-band-specific section source parameters
 */
typedef struct rmf_FilterSource_INB
{
    uint32_t tunerId; /**< Tuner identifier (1..n for in-band ) */
    unsigned long dmxHdl; /* Demux Handle to be used for Section Filtering */
    uint32_t freq; /**< Tuner frequency, in Hz (used to validate tuner state) */
    uint32_t tsId; /**< Transport stream ID (should always be 1 currently) */
    uint8_t  ltsid; /**< When non-0, identifies the Local Transport Stream ID carrying the sections */
} rmf_FilterSource_INB;

typedef struct rmf_FilterSession_s
{
        uint32_t                                RefCnt;
	unsigned long				parserHandle;
	NEXUS_PidChannelHandle  		pidFilterHandle;
	NEXUS_MessageHandle     		sectionFilterHandle;
        uint16_t                                pid;
        PDT_PidChannelType                      pidType;
        FilterState                             filterState;
        bool                                    isThreadAttached;
        FilterQuitStatus                        threadStatus;
        int                                     threadId;
        unsigned long           		ulMsgBufAddr;
        unsigned long           		ulMsgBufSize;
        int                         		tableId;
	uint32_t 				filterID;
        rmf_FilterSpec				filterSpec;
#ifdef RMF_SF_SINGLE_THREAD_ENABLE
        rmf_osal_eventqueue_handle_t            sectionMonitorQueue;
        sem_t* 					pMonitorThreadStopSem;
#endif
}
rmf_FilterSession_t;

typedef struct available_data_s
{
    uint32_t filterID;
    rmf_Section_Data* pSectionData;
}available_data_t;

typedef struct context_struct_s
{
    uint32_t filterID;
    NEXUS_MessageHandle sectionFilterHandle;
    unsigned long parserHandle;
    NEXUS_PidChannelHandle pidFilterHandle;
    void *pFilter;
}context_struct_t;

class rmf_SectionFilter_INB : public rmf_SectionFilter
{

public:
	rmf_SectionFilter_INB(void* pFilterSource);
	virtual ~rmf_SectionFilter_INB();

private:
	RMF_SECTFLT_RESULT Create(uint16_t pid, uint8_t* pos_mask, uint8_t* pos_value, uint16_t pos_length, uint8_t* neg_mask, uint8_t* neg_value, uint16_t neg_length, void **pSectionFilterInfo, uint32_t* pFilterID);
	RMF_SECTFLT_RESULT Start(uint32_t filterID);
	RMF_SECTFLT_RESULT Release(uint32_t filterID);
	RMF_SECTFLT_RESULT Stop(uint32_t filterID);
	RMF_SECTFLT_RESULT Read(uint32_t filterID, rmf_Section_Data** ppSectionData);

	RMF_SECTFLT_RESULT TSMGR_FilterCreate(uint16_t pid, PDT_PidChannelType pidType, 
					      unsigned long parserHandle, uint32_t filterID, 
					      rmf_FilterSession_t** pFilterSession);
	RMF_SECTFLT_RESULT TSMGR_SectionFilterCreate(rmf_FilterSession_t* nexusMessageInfo);

	RMF_SECTFLT_RESULT TSMGR_SectionFilterStart(rmf_FilterSession_t *pFilterSession, const rmf_FilterSpec* filterSpec);
	RMF_SECTFLT_RESULT TSMGR_SectionFilterStop(unsigned long parserHandle, NEXUS_MessageHandle sectionFilterHandle);
	RMF_SECTFLT_RESULT TSMGR_EnableDemuxFilter();
	RMF_SECTFLT_RESULT TSMGR_SectionFilterRelease(NEXUS_MessageHandle sectionFilterHandle);
	RMF_SECTFLT_RESULT TSMGR_FilterRelease(rmf_FilterSession_t* pInbandFilterInfo, int *pRefCnt);

	void FilterSessionListInit();  // This will be used in the VL_mpeos_Init to initialize the list
	void FilterSessionListClose();
	RMF_SECTFLT_RESULT get_Filter_SessionObj_WithPid(unsigned long parserHandle,
                                                 uint32_t pid,
                                                 PDT_PidChannelType ePidChanType,
                                                 rmf_FilterSession_t **ppFilterSession);
	void printSessionList();
	
	static void SectionFilterThreadFn(void *arg);

	void SectionMonitor(void *pData);

	unsigned long AllocateFilterMemory();
	void InitializeNexusMessage(TRNSPT_CALLBACK_t SECTFLT_MessageCallback, int index);
	void CloseNexusMessage(int index);
	rmf_FilterSession_t* GetAvailableNexusMessage();
	static void NexusMessageCallback( void *context, int param);
	void GenerateCrcTable();
	unsigned long Crc32(unsigned crcAccum, unsigned char *pData, int len);

private:
	uint32_t tunerId;
	uint32_t freq;
	uint32_t tsid;
	uint8_t ltsid;
	unsigned long                           parserHandle;  // Source Handle.
	rmf_osal_Mutex m_stFilterSessionMutex;
	rmf_FilterSession_t m_stFilterSessionList[MAX_FILTER_COUNT];
	int m_stFilterSessionCnt;
	//rmf_SymbolMapTable* m_sectionHandleMap;
	//rmf_osal_Mutex m_sectionHandleMapMutex;
	rmf_osal_Mutex m_stPmtDataMutex;
	int m_PmtCaptureTunerId;
	//int vlg_PmtCaptuteFilterId            = 0;
	int m_PmtCapturePidId;
	int m_DVR_SMD_BUF_SIZE;
	int g_stThreadId;
};
#endif // !defined __RMF_SECTIONFILTER_INB__
