/* version.c -- distribution and version numbers. */

/* Copyright (C) 1989-2005 Free Software Foundation, Inc.

   This file is part of GNU Bash, the Bourne Again SHell.

   Bash is free software; you can redistribute it and/or modify it under
   the terms of the GNU General Public License as published by the Free
   Software Foundation; either version 2, or (at your option) any later
   version.

   Bash is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
   for more details.

   You should have received a copy of the GNU General Public License along
   with Bash; see the file COPYING.  If not, write to the Free Software
   Foundation, 59 Temple Place, Suite 330, Boston, MA 02111 USA. */

#include <config.h>

#include <stdio.h>

#include "stdc.h"

#include "version.h"
#include "patchlevel.h"
#include "conftypes.h"

#include "bashintl.h"

extern char *shell_name;

/* Defines from version.h */
const char *dist_version = DISTVERSION;
int patch_level = PATCHLEVEL;
int build_version = BUILDVERSION;
#ifdef RELSTATUS
const char *release_status = RELSTATUS;
#else
const char *release_status = (char *)0;
#endif
const char *sccs_version = SCCSVERSION;

/* If == 31, shell compatible with bash-3.1, == 32 with bash-3.2, and so on */
int shell_compatibility_level = 32;

/* Functions for getting, setting, and displaying the shell version. */

/* Forward declarations so we don't have to include externs.h */
extern char *shell_version_string __P((void));
extern void show_shell_version __P((int));

/* Give version information about this shell. */
char *
shell_version_string ()
{
  static char tt[32] = { '\0' };

  if (tt[0] == '\0')
    {
      if (release_status)
#if defined (HAVE_SNPRINTF)
	snprintf (tt, sizeof (tt), "%s.%d(%d)-%s", dist_version, patch_level, build_version, release_status);
#else
	sprintf (tt, "%s.%d(%d)-%s", dist_version, patch_level, build_version, release_status);
#endif
      else
#if defined (HAVE_SNPRINTF)
	snprintf (tt, sizeof (tt), "%s.%d(%d)", dist_version, patch_level, build_version);
#else
	sprintf (tt, "%s.%d(%d)", dist_version, patch_level, build_version);
#endif
    }
  return tt;
}

void
show_shell_version (extended)
     int extended;
{
  printf ("GNU bash, version %s (%s)\n", shell_version_string (), MACHTYPE);
  if (extended)
    printf (_("Copyright (C) 2007 Free Software Foundation, Inc.\n"));
}
