SUMMARY = "Broadcom DirectFB Software"
DESCRIPTION = "Open source DirectFB software ported for Broadcom SoC."
SECTION = "libs"
LICENSE = "LGPLv2.1 & Broadcom-SLA"

inherit pkgconfig

LIC_FILES_CHKSUM = "file://AppLibs/opensource/directfb/src/DirectFB-Broadcom/COPYING;md5=d41d8cd98f00b204e9800998ecf8427e"

INC_PR = "r1"

DEPENDS += "virtual/kernel jpeg libpng freetype zlib tslib"
DEPENDS += "broadcom-refsw"

do_configure[depends] += "virtual/kernel:do_shared_workdir"

S = "${WORKDIR}"

# Workaround for linking issues seen with armv7a + gold
LDFLAGS_append_arm = "${@bb.utils.contains('DISTRO_FEATURES', 'ld-is-gold', ' -fuse-ld=bfd ', '', d)}"
#
# Broadcom SDK directories
#
export BRCM_SDK_INCDIR = "${STAGING_DIR_TARGET}/usr/include"
export BRCM_SDK_LIBDIR = "${STAGING_DIR_TARGET}/usr/lib"
export BRCM_DFB_ROOT = "${WORKDIR}/AppLibs/opensource/directfb"
export NEXUS_TOP = "${WORKDIR}/nexus"
export DIRECTFB_TARGET_IMAGE = "${PN}-${PV}.tgz"
export NEXUS_PLATFORM_APP_INC = "${BRCM_SDK_INCDIR}/platform_app.inc"
export LINUX = "${STAGING_KERNEL_DIR}"

#
# Default Broadcom DirectFB settings
#
export DIRECTFB_NSC_SUPPORT ?= "y"
export DIRECTFB_MASTER_SUPPORT ?= "y"
export DIRECTFB_IR_PROTOCOL ?= "CirXmp"
export DIRECTFB_IR_KEYCODES ?= "generic"
export DIRECTFB_GLES_SUPPORT ?= "n"
export DIRECTFB_MULTI ?= "n"

#
# Default prefix used in Broadcom DirectFB build
#
export DIRECTFB_PREFIX ?= "/usr"

INSANE_SKIP_${PN} += "dev-so compile-host-path"

FILES_${PN} += " \
	${DIRECTFB_PREFIX}${base_bindir}/* \
	${DIRECTFB_PREFIX}${base_libdir}/*.so* \
	${DIRECTFB_PREFIX}${base_libdir}/directfb-${RV}/systems/*.so* \
	${DIRECTFB_PREFIX}${base_libdir}/directfb-${RV}/gfxdrivers/*.so* \
	${DIRECTFB_PREFIX}${base_libdir}/directfb-${RV}/inputdrivers/*.so* \
	${DIRECTFB_PREFIX}${base_libdir}/directfb-${RV}/inputdrivers/*/*.so* \
	${DIRECTFB_PREFIX}${base_libdir}/directfb-${RV}/interfaces/*/*.so* \
	${DIRECTFB_PREFIX}${base_libdir}/directfb-${RV}/wm/*.so* \
	${DIRECTFB_PREFIX}/share/directfb-${PV}/* \
        ${sysconfdir}/directfbrc \
        ${sysconfdir}/hotplug.d/dfb_input_hotplug \
        ${sysconfdir}/hotplug.d/dfbhotplug \
	"

FILES_${PN}-dbg += " \
	${DIRECTFB_PREFIX}${base_libdir}/directfb-${RV}/*/*/.debug/*.so* \
	${DIRECTFB_PREFIX}${base_libdir}/directfb-${RV}/*/.debug/*.so* \
	${sysconfdir}/hotplug.d/.debug/* \
	"

FILES_${PN}-dev += " \
	${DIRECTFB_PREFIX}${base_libdir}/pkgconfig/* \
	${DIRECTFB_PREFIX}/share/directfb-examples/* \
	${DIRECTFB_PREFIX}/include/* \
        ${DIRECTFB_PREFIX}/.direct* \
        ${DIRECTFB_PREFIX}/share/* \
	"


#
# Pareparing directfb source from AppLibs source tarball
#
do_unpack_additional() {
	if [ -d ${WORKDIR}/${D_SDK_PATCH}/patches/patches/src/ ] ; then
		cp -af ${WORKDIR}/${D_SDK_PATCH}/patches/patches/src/* ${WORKDIR}
	fi
}
addtask unpack_additional after do_unpack before do_patch


#
# Make proper confoguration based on Broadcom reference software
#
do_configure() {
	/bin/echo "Create DirectFB source tree..."
	oe_runmake -C AppLibs/opensource/directfb/build directfb-source
	oe_runmake -C AppLibs/opensource/directfb/build directfb-defines
	oe_runmake -C AppLibs/opensource/directfb/build directfb-examples-source
	return 0
}


do_qa_configure() {
        return 0
}


do_compile() {
	oe_runmake -C AppLibs/opensource/directfb/build directfb-config
	oe_runmake -C AppLibs/opensource/directfb/build directfb-compile
	oe_runmake -C AppLibs/opensource/directfb/build directfb-install
	oe_runmake -C AppLibs/opensource/directfb/build directfb-post-install STAGING_SYSROOT=${STAGING_DIR_TARGET}
	oe_runmake -C AppLibs/opensource/directfb/build directfb-brcm-config
	oe_runmake -C AppLibs/opensource/directfb/build directfb-brcm-compile STAGING_SYSROOT=${STAGING_DIR_TARGET}
	oe_runmake -C AppLibs/opensource/directfb/build directfb-brcm-install
	oe_runmake -C AppLibs/opensource/directfb/build directfb-brcm-post-install STAGING_SYSROOT=${STAGING_DIR_TARGET}
	oe_runmake -C AppLibs/opensource/directfb/build directfb-examples-config
	oe_runmake -C AppLibs/opensource/directfb/build directfb-examples-compile STAGING_SYSROOT=${STAGING_DIR_TARGET}
	oe_runmake -C AppLibs/opensource/directfb/build directfb-examples-install
	oe_runmake -C AppLibs/opensource/directfb/build tarball
}


do_install () {

	if [ ! -e ${BRCM_DFB_ROOT}/bin/${DIRECTFB_TARGET_IMAGE} ]; then
		/bin/echo "Failed to locate ${DIRECTFB_TARGET_IMAGE}"
		return -1
	else
		rm -rf ${D}/*
		tar zxf ${BRCM_DFB_ROOT}/bin/${DIRECTFB_TARGET_IMAGE} -C ${D}
                mv ${D}/usr/bin/directfb/1.7/* ${D}/usr/bin
                rm -rf ${D}/usr/bin/directfb
                install -d ${D}/etc
                mv ${D}/usr/etc/* ${D}/etc
                rm -rf ${D}/usr/etc
                install -m 755 nexus_dfb ${D}/usr/bin
                install -m 755 rundfb.sh ${D}/usr/bin
		# Remove IR input library to disable it in directfb
		rm -rf ${D}/usr/lib/directfb-1.7-0/inputdrivers/libdirectfb_bcmnexus_ir.so
                # Remove .la files to address qa sanity check in yocto 2.1
                rm -rf ${D}/usr/lib/lib++dfb.la
                rm -rf ${D}/usr/lib/directfb-${RV}/wm/libdirectfbwm_default.la
                rm -rf ${D}/usr/lib/directfb-${RV}/interfaces/ICoreResourceManager/libicoreresourcemanager_test.la
                rm -rf ${D}/usr/lib/directfb-${RV}/interfaces/IDirectFBFont/*.la
                rm -rf ${D}/usr/lib/directfb-${RV}/interfaces/IWater
                rm -rf ${D}/usr/lib/directfb-${RV}/interfaces/IDirectFBWindows/libidirectfbwindows_default.la
                rm -rf ${D}/usr/lib/directfb-${RV}/interfaces/IDirectFBImageProvider/*.la
                rm -rf ${D}/usr/lib/directfb-${RV}/interfaces/IDirectFBVideoProvider/*.la
                rm -rf ${D}/usr/lib/directfb-${RV}/gfxdrivers/libdirectfb_bcmnexus_gfx.la
                rm -rf ${D}/usr/lib/directfb-${RV}/inputdrivers/libdirectfb_linux_input.la
                rm -rf ${D}/usr/lib/directfb-${RV}/systems/libdirectfb_bcmnexus_sys.la
                rm -rf ${D}/usr/lib/directfb-${RV}/systems/libdirectfb_dummy.la
                sed -i "s|^dependency_libs.*$|dependency_libs=\' -lnexus -lnxclient -lpthread -lz -lstdc++\'|" ${D}/usr/lib/libbcomdfbinit.la
                sed -i "s|^dependency_libs.*$|dependency_libs=\' -ldirect -lnxclient -lz -ldl -lrt -lpthread -lstdc++\'|" ${D}/usr/lib/libbcomdfbinit.la
                sed -i "s|^dependency_libs.*$|dependency_libs=\' -ldirect -lnxclient -lz -ldl -lrt -lpthread -lstdc++\'|" ${D}/usr/lib/libdirectfb.la
                sed -i "s|^dependency_libs.*$|dependency_libs=\' -lnxclient -lz -ldl -lrt -lpthread -lstdc++\'|" ${D}/usr/lib/libdirect.la
                sed -i "s|^dependency_libs.*$|dependency_libs=\' -ldirect -lnxclient -lz -ldl -lrt -lpthread -lstdc++\'|" ${D}/usr/lib/libfusion.la
	fi
}

PACKAGES =+ "${PN}-examples"

FILES_${PN}-examples += "${bindir}/df_*"
