// COMCAST MODIFICATION BEGIN [GSTREAMER_HARDWARE_VIDEO_DECODING]

// Copyright 2012 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include <gst/gst.h>
#include "base/logging.h"

#include "media/base/media.h"

#include "base/files/file_path.h"

namespace media {
namespace internal {

bool initializeGStreamer() {
#if GST_CHECK_VERSION(0, 10, 31)
  if (gst_is_initialized())
    return true;
#endif

  GError* error = 0;
  bool gst_initialized = gst_init_check(0, 0, &error);
  if (!gst_initialized) {
    LOG(ERROR) << "GStreamer initialization failed: "
               << (error ? error->message : "unknown error occured");
    g_error_free(error);
  }

  return gst_initialized;
}

bool InitializeMediaLibraryInternal(const base::FilePath& module_dir) {
// TODO(mzuber): This is called before the renderer is sandboxed.
// I have an issue currently where I can't load the gstreamer
// plugins in here because dlopen doesn't respect LD_LIBRARY_PATH
// for some reason.  In the future we could preload all the plugins
// in code here and possibly not violate the sandbox
    return initializeGStreamer();
}

}  // namespace internal
}  // namespace media

// COMCAST MODIFICATION END [GSTREAMER_HARDWARE_VIDEO_DECODING]
