// Copyright (c) 2006-2009 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

//  Accepts all other UTF-8 codes 0000..10FFFF
//  Space optimized
// ** ASSUMES INPUT IS STRUCTURALLY VALID UTF-8 **
//  Table entries are absolute statetable subscripts

#ifndef EXPERIMENTAL_USERS_DSITES_LANGDET_UTF8PROPLETTERSCRIPTNUM_H__
#define EXPERIMENTAL_USERS_DSITES_LANGDET_UTF8PROPLETTERSCRIPTNUM_H__

#include "encodings/compact_lang_det/win/cld_utf8statetable.h"

#define X__ (kExitIllegalStructure)
#define RJ_ (kExitReject)
#define S1_ (kExitReplace1)
#define S2_ (kExitReplace2)
#define S3_ (kExitReplace3)
#define S21 (kExitReplace21)
#define S31 (kExitReplace31)
#define S32 (kExitReplace32)
#define T1_ (kExitReplaceOffset1)
#define T2_ (kExitReplaceOffset2)
#define S11 (kExitReplace1S0)
#define SP_ (kExitSpecial)
#define D__ (kExitDoAgain)
#define RJA (kExitRejectAlt)

//  Entire table has 190 state blocks of 64 entries each

static const unsigned int utf8propletterscriptnum_STATE0 = 0;		// state[0]
static const unsigned int utf8propletterscriptnum_STATE0_SIZE = 64;	// =[1]
static const unsigned int utf8propletterscriptnum_TOTAL_SIZE = 12160;
static const unsigned int utf8propletterscriptnum_MAX_EXPAND_X4 = 0;
static const unsigned int utf8propletterscriptnum_SHIFT = 6;
static const unsigned int utf8propletterscriptnum_BYTES = 1;
static const unsigned int utf8propletterscriptnum_LOSUB = 0x80808080;
static const unsigned int utf8propletterscriptnum_HIADD = 0x00000000;

static const uint8 utf8propletterscriptnum[] = {
// state[0] 0x000000 Byte 1
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,

  0,  1,  1,  1,  1,  1,  1,  1,   1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,   1,  1,  1,  0,  0,  0,  0,  0,
  0,  1,  1,  1,  1,  1,  1,  1,   1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,   1,  1,  1,  0,  0,  0,  0,  0,

X__,X__,X__,X__,X__,X__,X__,X__, X__,X__,X__,X__,X__,X__,X__,X__,
X__,X__,X__,X__,X__,X__,X__,X__, X__,X__,X__,X__,X__,X__,X__,X__,
X__,X__,X__,X__,X__,X__,X__,X__, X__,X__,X__,X__,X__,X__,X__,X__,
X__,X__,X__,X__,X__,X__,X__,X__, X__,X__,X__,X__,X__,X__,X__,X__,

X__,X__,  6, 24, 25, 25, 25, 25,  25, 25,  7,  8,151, 37, 38, 39,
 45, 45, 46, 45, 47, 48, 49, 50,  52,  9, 53, 54, 64, 55, 65,187,
 66, 26, 10, 14,133,106,106,106, 106,135, 17,106,106,107,  2, 18,
 21,  4,  4,156,  5,X__,X__,X__, X__,X__,X__,X__,X__,X__,X__,X__,

// state[4 - 2] 0x00e000 Byte 2 of 3
  3,  3,  3,  3,  3,  3,  3,  3,   3,  3,  3,  3,  3,  3,  3,  3,
  3,  3,  3,  3,  3,  3,  3,  3,   3,  3,  3,  3,  3,  3,  3,  3,
  3,  3,  3,  3,  3,  3,  3,  3,   3,  3,  3,  3,  3,  3,  3,  3,
  3,  3,  3,  3,  3,  3,  3,  3,   3,  3,  3,  3,  3,  3,  3,  3,

// state[5 - 2] 0x000800 Byte 3 of 3
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,

// state[6 - 2] 0x040000 Byte 2 of 4
  2,  2,  2,  2,  2,  2,  2,  2,   2,  2,  2,  2,  2,  2,  2,  2,
  2,  2,  2,  2,  2,  2,  2,  2,   2,  2,  2,  2,  2,  2,  2,  2,
  2,  2,  2,  2,  2,  2,  2,  2,   2,  2,  2,  2,  2,  2,  2,  2,
  2,  2,  2,  2,  2,  2,  2,  2,   2,  2,  2,  2,  2,  2,  2,  2,

// state[7 - 2] 0x100000 Byte 2 of 4
  2,  2,  2,  2,  2,  2,  2,  2,   2,  2,  2,  2,  2,  2,  2,  2,
X__,X__,X__,X__,X__,X__,X__,X__, X__,X__,X__,X__,X__,X__,X__,X__,
X__,X__,X__,X__,X__,X__,X__,X__, X__,X__,X__,X__,X__,X__,X__,X__,
X__,X__,X__,X__,X__,X__,X__,X__, X__,X__,X__,X__,X__,X__,X__,X__,

// state[8 - 2] 0x000080 Byte 2 of 2
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  1,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  1,  0,  0,  0,  0,  0,

// state[9 - 2] 0x000280 Byte 2 of 2
  1,  1,  1,  1,  1,  1,  1,  1,   1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,   1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,   1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,   1,  0,  0,  0,  0,  0,  0,  0,

// state[10 - 2] 0x0002c0 Byte 2 of 2
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  1,  1,  1,  1,  1,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,

// state[11 - 2] 0x000640 Byte 2 of 2
  0,  6,  6,  6,  6,  6,  6,  6,   6,  6,  6, 36, 36, 36, 36, 36,
 36, 36, 36, 36, 36, 36,  6,  6,   6,  6,  6,  6,  6,  6,  6,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  6,  6,
 36,  6,  6,  6,  6,  6,  6,  6,   6,  6,  6,  6,  6,  6,  6,  6,

// state[12 - 2] 0x002000 Byte 2 of 3
  3, 32, 33,153, 11, 12, 13,  3,   3,  3,  3,  3,  3,  3,  3,  3,
  3,  3,  3,  3,  3,  3,  3,  3,   3,  3,  3,  3,  3,  3,  3,  3,
  3,  3,  3,  3,  3,  3,  3,  3,   3,  3,  3,  3,  3,  3,  3,  3,
175, 34,171,172, 99,176,117,118,   3,  3,  3,  3,  3,  3,  3,  3,

// state[13 - 2] 0x002100 Byte 3 of 3
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  2,  0,   0,  0,  1,  1,  0,  0,  0,  0,
  0,  0,  1,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,

// state[14 - 2] 0x002140 Byte 3 of 3
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  1,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,

// state[15 - 2] 0x002180 Byte 3 of 3
  0,  0,  0,  0,  1,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,

// state[16 - 2] 0x003000 Byte 2 of 3
 15,130,131, 16,104,100,105,132,   3,  3,  3,  3,  3,  3,  3,  3,
100,100,100,100,100,100,100,100, 100,100,100,100,100,100,100,100,
100,100,100,100,100,100,100,100, 100,100,100,100,100,100,100,100,
100,100,100,100,100,100,100,100, 100,100,100,100,100,100,100,100,

// state[17 - 2] 0x003000 Byte 3 of 3
  0,  0,  0,  0,  0, 24,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0, 36, 36, 36, 36, 36, 36,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0, 24,  0,  0,  0,  0,

// state[18 - 2] 0x0030c0 Byte 3 of 3
 24, 24, 24, 24, 24, 24, 24, 24,  24, 24, 24, 24, 24, 24, 24, 24,
 24, 24, 24, 24, 24, 24, 24, 24,  24, 24, 24, 24, 24, 24, 24, 24,
 24, 24, 24, 24, 24, 24, 24, 24,  24, 24, 24, 24, 24, 24, 24, 24,
 24, 24, 24, 24, 24, 24, 24, 24,  24, 24, 24,  0,  0, 24, 24, 24,

// state[19 - 2] 0x00a000 Byte 2 of 3
144,144,144,144,144,144,144,144, 144,144,144,144,144,144,144,144,
144,144,145,  3,  3,  3,  3,  3,   3,  3,  3,  3,  3,  3,  3,  3,
177,186,  3,  3,  3,  3,  3,  3,   3,  3,  3,  3,  3,  3,  3,  3,
100,100,100,100,100,100,100,100, 100,100,100,100,100,100,100,100,

// state[20 - 2] 0x00f000 Byte 2 of 3
  3,  3,  3,  3,  3,  3,  3,  3,   3,  3,  3,  3,  3,  3,  3,  3,
  3,  3,  3,  3,  3,  3,  3,  3,   3,  3,  3,  3,  3,  3,  3,  3,
  3,  3,  3,  3,100,100,100,100, 137,138,100,139, 35, 51, 56, 57,
 53, 53, 53, 53, 58, 59, 60, 61, 154, 62, 53, 63, 36, 19, 20,109,

// state[21 - 2] 0x00ff40 Byte 3 of 3
  0,  1,  1,  1,  1,  1,  1,  1,   1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,   1,  1,  1,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0, 24, 24,  24, 24, 24, 24, 24, 24, 24, 24,
  0, 24, 24, 24, 24, 24, 24, 24,  24, 24, 24, 24, 24, 24, 24, 24,

// state[22 - 2] 0x00ff80 Byte 3 of 3
 24, 24, 24, 24, 24, 24, 24, 24,  24, 24, 24, 24, 24, 24, 24, 24,
 24, 24, 24, 24, 24, 24, 24, 24,  24, 24, 24, 24, 24, 24,  0,  0,
 24, 24, 24, 24, 24, 24, 24, 24,  24, 24, 24, 24, 24, 24, 24, 24,
 24, 24, 24, 24, 24, 24, 24, 24,  24, 24, 24, 24, 24, 24, 24,  0,

// state[23 - 2] 0x000000 Byte 2 of 4
X__,X__,X__,X__,X__,X__,X__,X__, X__,X__,X__,X__,X__,X__,X__,X__,
146,  2,182,  2,  2,  2,  2,  2,   2,  2,  2,  2,  2, 22,  2,  2,
106,106,106,106,106,106,106,106, 106,106,140,  2,  2,  2,  2,142,
  2,  2,  2,  2,  2,  2,  2,  2,   2,  2,  2,  2,  2,  2,  2,  2,

// state[24 - 2] 0x01d000 Byte 3 of 4
  3,  3,  3,  3,  3, 23,155,  3,   3, 44,  3,  3,  3,  3,  3,  3,
  3,  3,  3,  3,  3,  3,  3,  3,   3,  3,  3,  3,  3,  3,  3,  3,
  3,  3,  3,  3,  3,  3,  3,  3,   3,  3,  3,  3,  3,  3,  3,  3,
  3,  3,  3,  3,  3,  3,  3,  3,   3,  3,  3,  3,  3,  3,  3,  3,

// state[25 - 2] 0x01d140 Byte 4 of 4
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0, 36,  36, 36,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0, 36, 36, 36, 36, 36,

// state[26 - 2] 0x0000c0 Byte 2 of 2
  1,  1,  1,  1,  1,  1,  1,  1,   1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  0,   1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,   1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  0,   1,  1,  1,  1,  1,  1,  1,  1,

// state[27 - 2] 0x000100 Byte 2 of 2
  1,  1,  1,  1,  1,  1,  1,  1,   1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,   1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,   1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,   1,  1,  1,  1,  1,  1,  1,  1,

// state[28 - 2] 0x001000 Byte 2 of 3
 95, 96, 97, 98,100,101,102,103, 110,111,112,113,114,115,116,119,
120,121,121,121,121,121,121,121, 121,122,123,124,159,160,125,126,
127,128,129,  3,161,162,173,174, 170,  3,  3,  3,180,181,  3,  3,
  3,  3,  3,  3, 27, 28, 29,152,  25, 25, 30, 31, 40, 41, 42, 43,

// state[29 - 2] 0x001d00 Byte 3 of 3
  1,  1,  1,  1,  1,  1,  1,  1,   1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,   1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  2,  2,   2,  2,  2,  3,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,   1,  1,  1,  1,  1,  1,  1,  1,

// state[30 - 2] 0x001d40 Byte 3 of 3
  1,  1,  1,  1,  1,  1,  1,  1,   1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,   1,  1,  1,  1,  1,  2,  2,  2,
  2,  2,  1,  1,  1,  1,  2,  2,   2,  2,  2,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,   3,  1,  1,  1,  1,  1,  1,  1,

// state[31 - 2] 0x001d80 Byte 3 of 3
  1,  1,  1,  1,  1,  1,  1,  1,   1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,   1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,   1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,   1,  1,  1,  1,  1,  1,  1,  2,

// state[32 - 2] 0x001e80 Byte 3 of 3
  1,  1,  1,  1,  1,  1,  1,  1,   1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,   1,  1,  1,  1,  0,  0,  0,  0,
  1,  1,  1,  1,  1,  1,  1,  1,   1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,   1,  1,  1,  1,  1,  1,  1,  1,

// state[33 - 2] 0x001ec0 Byte 3 of 3
  1,  1,  1,  1,  1,  1,  1,  1,   1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,   1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,   1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,   1,  1,  0,  0,  0,  0,  0,  0,

// state[34 - 2] 0x002040 Byte 3 of 3
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  1,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  1,

// state[35 - 2] 0x002080 Byte 3 of 3
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  1,  1,  1,  1,  1,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,

// state[36 - 2] 0x002c40 Byte 3 of 3
 51, 51, 51, 51, 51, 51, 51, 51,  51, 51, 51, 51, 51, 51, 51, 51,
 51, 51, 51, 51, 51, 51, 51, 51,  51, 51, 51, 51, 51, 51, 51,  0,
  1,  1,  1,  1,  1,  1,  1,  1,   1,  1,  1,  1,  1,  0,  0,  0,
  0,  0,  0,  0,  1,  1,  1,  1,   0,  0,  0,  0,  0,  0,  0,  0,

// state[37 - 2] 0x00fb00 Byte 3 of 3
  1,  1,  1,  1,  1,  1,  1,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  4,  4,  4,  4,  4,   0,  0,  0,  0,  0,  5,  5,  5,
  5,  5,  5,  5,  5,  5,  5,  5,   5,  0,  5,  5,  5,  5,  5,  5,
  5,  5,  5,  5,  5,  5,  5,  0,   5,  5,  5,  5,  5,  0,  5,  0,

// state[38 - 2] 0x00ff00 Byte 3 of 3
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  1,  1,  1,  1,  1,  1,  1,   1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,   1,  1,  1,  0,  0,  0,  0,  0,

// state[39 - 2] 0x000340 Byte 2 of 2
 36, 36, 36, 36, 36, 36, 36, 36,  36, 36, 36, 36, 36, 36, 36, 36,
 36, 36, 36, 36, 36, 36, 36, 36,  36, 36, 36, 36, 36, 36, 36, 36,
 36, 36, 36, 36, 36, 36, 36, 36,  36, 36, 36, 36, 36, 36, 36, 36,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  2,  2,  2,  2,  0,  0,

// state[40 - 2] 0x000380 Byte 2 of 2
  0,  0,  0,  0,  0,  0,  2,  0,   2,  2,  2,  0,  2,  0,  2,  2,
  2,  2,  2,  2,  2,  2,  2,  2,   2,  2,  2,  2,  2,  2,  2,  2,
  2,  2,  0,  2,  2,  2,  2,  2,   2,  2,  2,  2,  2,  2,  2,  2,
  2,  2,  2,  2,  2,  2,  2,  2,   2,  2,  2,  2,  2,  2,  2,  2,

// state[41 - 2] 0x0003c0 Byte 2 of 2
  2,  2,  2,  2,  2,  2,  2,  2,   2,  2,  2,  2,  2,  2,  2,  0,
  2,  2,  2,  2,  2,  2,  2,  2,   2,  2,  2,  2,  2,  2,  2,  2,
  2,  2, 49, 49, 49, 49, 49, 49,  49, 49, 49, 49, 49, 49, 49, 49,
  2,  2,  2,  2,  2,  2,  0,  2,   2,  2,  2,  2,  2,  2,  2,  2,

// state[42 - 2] 0x001f00 Byte 3 of 3
  2,  2,  2,  2,  2,  2,  2,  2,   2,  2,  2,  2,  2,  2,  2,  2,
  2,  2,  2,  2,  2,  2,  0,  0,   2,  2,  2,  2,  2,  2,  0,  0,
  2,  2,  2,  2,  2,  2,  2,  2,   2,  2,  2,  2,  2,  2,  2,  2,
  2,  2,  2,  2,  2,  2,  2,  2,   2,  2,  2,  2,  2,  2,  2,  2,

// state[43 - 2] 0x001f40 Byte 3 of 3
  2,  2,  2,  2,  2,  2,  0,  0,   2,  2,  2,  2,  2,  2,  0,  0,
  2,  2,  2,  2,  2,  2,  2,  2,   0,  2,  0,  2,  0,  2,  0,  2,
  2,  2,  2,  2,  2,  2,  2,  2,   2,  2,  2,  2,  2,  2,  2,  2,
  2,  2,  2,  2,  2,  2,  2,  2,   2,  2,  2,  2,  2,  2,  0,  0,

// state[44 - 2] 0x001f80 Byte 3 of 3
  2,  2,  2,  2,  2,  2,  2,  2,   2,  2,  2,  2,  2,  2,  2,  2,
  2,  2,  2,  2,  2,  2,  2,  2,   2,  2,  2,  2,  2,  2,  2,  2,
  2,  2,  2,  2,  2,  2,  2,  2,   2,  2,  2,  2,  2,  2,  2,  2,
  2,  2,  2,  2,  2,  0,  2,  2,   2,  2,  2,  2,  2,  0,  2,  0,

// state[45 - 2] 0x001fc0 Byte 3 of 3
  0,  0,  2,  2,  2,  0,  2,  2,   2,  2,  2,  2,  2,  0,  0,  0,
  2,  2,  2,  2,  0,  0,  2,  2,   2,  2,  2,  2,  0,  0,  0,  0,
  2,  2,  2,  2,  2,  2,  2,  2,   2,  2,  2,  2,  2,  0,  0,  0,
  0,  0,  2,  2,  2,  0,  2,  2,   2,  2,  2,  2,  2,  0,  0,  0,

// state[46 - 2] 0x01d240 Byte 4 of 4
  0,  0,  2,  2,  2,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,

// state[47 - 2] 0x000400 Byte 2 of 2
  3,  3,  3,  3,  3,  3,  3,  3,   3,  3,  3,  3,  3,  3,  3,  3,
  3,  3,  3,  3,  3,  3,  3,  3,   3,  3,  3,  3,  3,  3,  3,  3,
  3,  3,  3,  3,  3,  3,  3,  3,   3,  3,  3,  3,  3,  3,  3,  3,
  3,  3,  3,  3,  3,  3,  3,  3,   3,  3,  3,  3,  3,  3,  3,  3,

// state[48 - 2] 0x000480 Byte 2 of 2
  3,  3,  0,  3,  3,  3,  3,  0,   3,  3,  3,  3,  3,  3,  3,  3,
  3,  3,  3,  3,  3,  3,  3,  3,   3,  3,  3,  3,  3,  3,  3,  3,
  3,  3,  3,  3,  3,  3,  3,  3,   3,  3,  3,  3,  3,  3,  3,  3,
  3,  3,  3,  3,  3,  3,  3,  3,   3,  3,  3,  3,  3,  3,  3,  3,

// state[49 - 2] 0x000500 Byte 2 of 2
  3,  3,  3,  3,  3,  3,  3,  3,   3,  3,  3,  3,  3,  3,  3,  3,
  3,  3,  3,  3,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  4,  4,  4,  4,  4,  4,  4,   4,  4,  4,  4,  4,  4,  4,  4,

// state[50 - 2] 0x000540 Byte 2 of 2
  4,  4,  4,  4,  4,  4,  4,  4,   4,  4,  4,  4,  4,  4,  4,  4,
  4,  4,  4,  4,  4,  4,  4,  0,   0,  4,  0,  0,  0,  0,  0,  0,
  0,  4,  4,  4,  4,  4,  4,  4,   4,  4,  4,  4,  4,  4,  4,  4,
  4,  4,  4,  4,  4,  4,  4,  4,   4,  4,  4,  4,  4,  4,  4,  4,

// state[51 - 2] 0x000580 Byte 2 of 2
  4,  4,  4,  4,  4,  4,  4,  4,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  5,  5,  5,  5,  5,  5,  5,   5,  5,  5,  5,  5,  5,  5,  5,
  5,  5,  5,  5,  5,  5,  5,  5,   5,  5,  5,  5,  5,  5,  5,  5,
  5,  5,  5,  5,  5,  5,  5,  5,   5,  5,  5,  5,  5,  5,  0,  5,

// state[52 - 2] 0x0005c0 Byte 2 of 2
  0,  5,  5,  0,  5,  5,  0,  5,   0,  0,  0,  0,  0,  0,  0,  0,
  5,  5,  5,  5,  5,  5,  5,  5,   5,  5,  5,  5,  5,  5,  5,  5,
  5,  5,  5,  5,  5,  5,  5,  5,   5,  5,  5,  0,  0,  0,  0,  0,
  5,  5,  5,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,

// state[53 - 2] 0x00fb40 Byte 3 of 3
  5,  5,  0,  5,  5,  0,  5,  5,   5,  5,  5,  5,  5,  5,  5,  5,
  6,  6,  6,  6,  6,  6,  6,  6,   6,  6,  6,  6,  6,  6,  6,  6,
  6,  6,  6,  6,  6,  6,  6,  6,   6,  6,  6,  6,  6,  6,  6,  6,
  6,  6,  6,  6,  6,  6,  6,  6,   6,  6,  6,  6,  6,  6,  6,  6,

// state[54 - 2] 0x000600 Byte 2 of 2
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  6,  6,  6,  6,  6,  6,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  6,  6,  6,  6,  6,  6,  6,   6,  6,  6,  6,  6,  6,  6,  6,
  6,  6,  6,  6,  6,  6,  6,  6,   6,  6,  6,  0,  0,  0,  0,  0,

// state[55 - 2] 0x000680 Byte 2 of 2
  6,  6,  6,  6,  6,  6,  6,  6,   6,  6,  6,  6,  6,  6,  6,  6,
  6,  6,  6,  6,  6,  6,  6,  6,   6,  6,  6,  6,  6,  6,  6,  6,
  6,  6,  6,  6,  6,  6,  6,  6,   6,  6,  6,  6,  6,  6,  6,  6,
  6,  6,  6,  6,  6,  6,  6,  6,   6,  6,  6,  6,  6,  6,  6,  6,

// state[56 - 2] 0x0006c0 Byte 2 of 2
  6,  6,  6,  6,  6,  6,  6,  6,   6,  6,  6,  6,  6,  6,  6,  6,
  6,  6,  6,  6,  0,  6,  6,  6,   6,  6,  6,  6,  6,  0,  6,  6,
  6,  6,  6,  6,  6,  6,  6,  6,   6,  0,  6,  6,  6,  6,  6,  6,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  6,  6,  6,  0,  0,  6,

// state[57 - 2] 0x000740 Byte 2 of 2
  7,  7,  7,  7,  7,  7,  7,  7,   7,  7,  7,  0,  0,  7,  7,  7,
  6,  6,  6,  6,  6,  6,  6,  6,   6,  6,  6,  6,  6,  6,  6,  6,
  6,  6,  6,  6,  6,  6,  6,  6,   6,  6,  6,  6,  6,  6,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,

// state[58 - 2] 0x00fb80 Byte 3 of 3
  6,  6,  6,  6,  6,  6,  6,  6,   6,  6,  6,  6,  6,  6,  6,  6,
  6,  6,  6,  6,  6,  6,  6,  6,   6,  6,  6,  6,  6,  6,  6,  6,
  6,  6,  6,  6,  6,  6,  6,  6,   6,  6,  6,  6,  6,  6,  6,  6,
  6,  6,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,

// state[59 - 2] 0x00fbc0 Byte 3 of 3
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  6,  6,  6,  6,  6,   6,  6,  6,  6,  6,  6,  6,  6,
  6,  6,  6,  6,  6,  6,  6,  6,   6,  6,  6,  6,  6,  6,  6,  6,
  6,  6,  6,  6,  6,  6,  6,  6,   6,  6,  6,  6,  6,  6,  6,  6,

// state[60 - 2] 0x00fd00 Byte 3 of 3
  6,  6,  6,  6,  6,  6,  6,  6,   6,  6,  6,  6,  6,  6,  6,  6,
  6,  6,  6,  6,  6,  6,  6,  6,   6,  6,  6,  6,  6,  6,  6,  6,
  6,  6,  6,  6,  6,  6,  6,  6,   6,  6,  6,  6,  6,  6,  6,  6,
  6,  6,  6,  6,  6,  6,  6,  6,   6,  6,  6,  6,  6,  6,  0,  0,

// state[61 - 2] 0x00fd40 Byte 3 of 3
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  6,  6,  6,  6,  6,  6,  6,  6,   6,  6,  6,  6,  6,  6,  6,  6,
  6,  6,  6,  6,  6,  6,  6,  6,   6,  6,  6,  6,  6,  6,  6,  6,
  6,  6,  6,  6,  6,  6,  6,  6,   6,  6,  6,  6,  6,  6,  6,  6,

// state[62 - 2] 0x00fd80 Byte 3 of 3
  6,  6,  6,  6,  6,  6,  6,  6,   6,  6,  6,  6,  6,  6,  6,  6,
  0,  0,  6,  6,  6,  6,  6,  6,   6,  6,  6,  6,  6,  6,  6,  6,
  6,  6,  6,  6,  6,  6,  6,  6,   6,  6,  6,  6,  6,  6,  6,  6,
  6,  6,  6,  6,  6,  6,  6,  6,   6,  6,  6,  6,  6,  6,  6,  6,

// state[63 - 2] 0x00fdc0 Byte 3 of 3
  6,  6,  6,  6,  6,  6,  6,  6,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  6,  6,  6,  6,  6,  6,  6,  6,   6,  6,  6,  6,  0,  0,  0,  0,

// state[64 - 2] 0x00fe40 Byte 3 of 3
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  6,  6,  6,  6,  6,  0,  6,  6,   6,  6,  6,  6,  6,  6,  6,  6,

// state[65 - 2] 0x00fec0 Byte 3 of 3
  6,  6,  6,  6,  6,  6,  6,  6,   6,  6,  6,  6,  6,  6,  6,  6,
  6,  6,  6,  6,  6,  6,  6,  6,   6,  6,  6,  6,  6,  6,  6,  6,
  6,  6,  6,  6,  6,  6,  6,  6,   6,  6,  6,  6,  6,  6,  6,  6,
  6,  6,  6,  6,  6,  6,  6,  6,   6,  6,  6,  6,  6,  0,  0,  0,

// state[66 - 2] 0x000700 Byte 2 of 2
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  7,  7,  7,  7,  7,  7,  7,  7,   7,  7,  7,  7,  7,  7,  7,  7,
  7,  7,  7,  7,  7,  7,  7,  7,   7,  7,  7,  7,  7,  7,  7,  7,
  7,  7,  7,  7,  7,  7,  7,  7,   7,  7,  7,  7,  7,  7,  7,  7,

// state[67 - 2] 0x000780 Byte 2 of 2
  8,  8,  8,  8,  8,  8,  8,  8,   8,  8,  8,  8,  8,  8,  8,  8,
  8,  8,  8,  8,  8,  8,  8,  8,   8,  8,  8,  8,  8,  8,  8,  8,
  8,  8,  8,  8,  8,  8,  8,  8,   8,  8,  8,  8,  8,  8,  8,  8,
  8,  8,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,

// state[68 - 2] 0x000000 Byte 2 of 3
X__,X__,X__,X__,X__,X__,X__,X__, X__,X__,X__,X__,X__,X__,X__,X__,
X__,X__,X__,X__,X__,X__,X__,X__, X__,X__,X__,X__,X__,X__,X__,X__,
  3,  3,  3,  3, 67, 68, 69, 70,  71, 72, 73, 74, 75, 76, 77, 78,
 79, 80, 81, 82, 83, 84, 85, 86,  87, 88, 89, 90, 91, 92, 93, 94,

// state[69 - 2] 0x000900 Byte 3 of 3
  0,  9,  9,  9,  9,  9,  9,  9,   9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,   9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,   9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,   9,  9,  0,  0,  9,  9,  9,  9,

// state[70 - 2] 0x000940 Byte 3 of 3
  9,  9,  9,  9,  9,  9,  9,  9,   9,  9,  9,  9,  9,  9,  0,  0,
  9,  9,  9,  9,  9,  0,  0,  0,   9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  9,  9,  9,  9,  9,

// state[71 - 2] 0x000980 Byte 3 of 3
  0, 10, 10, 10,  0, 10, 10, 10,  10, 10, 10, 10, 10,  0,  0, 10,
 10,  0,  0, 10, 10, 10, 10, 10,  10, 10, 10, 10, 10, 10, 10, 10,
 10, 10, 10, 10, 10, 10, 10, 10,  10,  0, 10, 10, 10, 10, 10, 10,
 10,  0, 10,  0,  0,  0, 10, 10,  10, 10,  0,  0, 10, 10, 10, 10,

// state[72 - 2] 0x0009c0 Byte 3 of 3
 10, 10, 10, 10, 10,  0,  0, 10,  10,  0,  0, 10, 10, 10, 10,  0,
  0,  0,  0,  0,  0,  0,  0, 10,   0,  0,  0,  0, 10, 10,  0, 10,
 10, 10, 10, 10,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
 10, 10,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,

// state[73 - 2] 0x000a00 Byte 3 of 3
  0, 11, 11, 11,  0, 11, 11, 11,  11, 11, 11,  0,  0,  0,  0, 11,
 11,  0,  0, 11, 11, 11, 11, 11,  11, 11, 11, 11, 11, 11, 11, 11,
 11, 11, 11, 11, 11, 11, 11, 11,  11,  0, 11, 11, 11, 11, 11, 11,
 11,  0, 11, 11,  0, 11, 11,  0,  11, 11,  0,  0, 11,  0, 11, 11,

// state[74 - 2] 0x000a40 Byte 3 of 3
 11, 11, 11,  0,  0,  0,  0, 11,  11,  0,  0, 11, 11, 11,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0, 11, 11, 11, 11,  0, 11,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
 11, 11, 11, 11, 11,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,

// state[75 - 2] 0x000a80 Byte 3 of 3
  0, 12, 12, 12,  0, 12, 12, 12,  12, 12, 12, 12, 12, 12,  0, 12,
 12, 12,  0, 12, 12, 12, 12, 12,  12, 12, 12, 12, 12, 12, 12, 12,
 12, 12, 12, 12, 12, 12, 12, 12,  12,  0, 12, 12, 12, 12, 12, 12,
 12,  0, 12, 12,  0, 12, 12, 12,  12, 12,  0,  0, 12, 12, 12, 12,

// state[76 - 2] 0x000ac0 Byte 3 of 3
 12, 12, 12, 12, 12, 12,  0, 12,  12, 12,  0, 12, 12, 12,  0,  0,
 12,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
 12, 12, 12, 12,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,

// state[77 - 2] 0x000b00 Byte 3 of 3
  0, 13, 13, 13,  0, 13, 13, 13,  13, 13, 13, 13, 13,  0,  0, 13,
 13,  0,  0, 13, 13, 13, 13, 13,  13, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 13,  13,  0, 13, 13, 13, 13, 13, 13,
 13,  0, 13, 13,  0, 13, 13, 13,  13, 13,  0,  0, 13, 13, 13, 13,

// state[78 - 2] 0x000b40 Byte 3 of 3
 13, 13, 13, 13,  0,  0,  0, 13,  13,  0,  0, 13, 13, 13,  0,  0,
  0,  0,  0,  0,  0,  0, 13, 13,   0,  0,  0,  0, 13, 13,  0, 13,
 13, 13,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0, 13,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,

// state[79 - 2] 0x000b80 Byte 3 of 3
  0,  0, 14, 14,  0, 14, 14, 14,  14, 14, 14,  0,  0,  0, 14, 14,
 14,  0, 14, 14, 14, 14,  0,  0,   0, 14, 14,  0, 14,  0, 14, 14,
  0,  0,  0, 14, 14,  0,  0,  0,  14, 14, 14,  0,  0,  0, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14,  14, 14,  0,  0,  0,  0, 14, 14,

// state[80 - 2] 0x000bc0 Byte 3 of 3
 14, 14, 14,  0,  0,  0, 14, 14,  14,  0, 14, 14, 14, 14,  0,  0,
  0,  0,  0,  0,  0,  0,  0, 14,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,

// state[81 - 2] 0x000c00 Byte 3 of 3
  0, 15, 15, 15,  0, 15, 15, 15,  15, 15, 15, 15, 15,  0, 15, 15,
 15,  0, 15, 15, 15, 15, 15, 15,  15, 15, 15, 15, 15, 15, 15, 15,
 15, 15, 15, 15, 15, 15, 15, 15,  15,  0, 15, 15, 15, 15, 15, 15,
 15, 15, 15, 15,  0, 15, 15, 15,  15, 15,  0,  0,  0,  0, 15, 15,

// state[82 - 2] 0x000c40 Byte 3 of 3
 15, 15, 15, 15, 15,  0, 15, 15,  15,  0, 15, 15, 15, 15,  0,  0,
  0,  0,  0,  0,  0, 15, 15,  0,   0,  0,  0,  0,  0,  0,  0,  0,
 15, 15,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,

// state[83 - 2] 0x000c80 Byte 3 of 3
  0,  0, 16, 16,  0, 16, 16, 16,  16, 16, 16, 16, 16,  0, 16, 16,
 16,  0, 16, 16, 16, 16, 16, 16,  16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16,  16,  0, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16,  0, 16, 16, 16,  16, 16,  0,  0, 16, 16, 16, 16,

// state[84 - 2] 0x000cc0 Byte 3 of 3
 16, 16, 16, 16, 16,  0, 16, 16,  16,  0, 16, 16, 16, 16,  0,  0,
  0,  0,  0,  0,  0, 16, 16,  0,   0,  0,  0,  0,  0,  0, 16,  0,
 16, 16, 16, 16,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,

// state[85 - 2] 0x000d00 Byte 3 of 3
  0,  0, 17, 17,  0, 17, 17, 17,  17, 17, 17, 17, 17,  0, 17, 17,
 17,  0, 17, 17, 17, 17, 17, 17,  17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17,  17,  0, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17,  17, 17,  0,  0,  0,  0, 17, 17,

// state[86 - 2] 0x000d40 Byte 3 of 3
 17, 17, 17, 17,  0,  0, 17, 17,  17,  0, 17, 17, 17, 17,  0,  0,
  0,  0,  0,  0,  0,  0,  0, 17,   0,  0,  0,  0,  0,  0,  0,  0,
 17, 17,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,

// state[87 - 2] 0x000d80 Byte 3 of 3
  0,  0, 18, 18,  0, 18, 18, 18,  18, 18, 18, 18, 18, 18, 18, 18,
 18, 18, 18, 18, 18, 18, 18,  0,   0,  0, 18, 18, 18, 18, 18, 18,
 18, 18, 18, 18, 18, 18, 18, 18,  18, 18, 18, 18, 18, 18, 18, 18,
 18, 18,  0, 18, 18, 18, 18, 18,  18, 18, 18, 18,  0, 18,  0,  0,

// state[88 - 2] 0x000dc0 Byte 3 of 3
 18, 18, 18, 18, 18, 18, 18,  0,   0,  0, 18,  0,  0,  0,  0, 18,
 18, 18, 18, 18, 18,  0, 18,  0,  18, 18, 18, 18, 18, 18, 18, 18,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0, 18, 18,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,

// state[89 - 2] 0x000e00 Byte 3 of 3
  0, 19, 19, 19, 19, 19, 19, 19,  19, 19, 19, 19, 19, 19, 19, 19,
 19, 19, 19, 19, 19, 19, 19, 19,  19, 19, 19, 19, 19, 19, 19, 19,
 19, 19, 19, 19, 19, 19, 19, 19,  19, 19, 19, 19, 19, 19, 19, 19,
 19, 19, 19, 19, 19, 19, 19, 19,  19, 19, 19,  0,  0,  0,  0,  0,

// state[90 - 2] 0x000e40 Byte 3 of 3
 19, 19, 19, 19, 19, 19, 19, 19,  19, 19, 19, 19, 19, 19, 19,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,

// state[91 - 2] 0x000e80 Byte 3 of 3
  0, 20, 20,  0, 20,  0,  0, 20,  20,  0, 20,  0,  0, 20,  0,  0,
  0,  0,  0,  0, 20, 20, 20, 20,   0, 20, 20, 20, 20, 20, 20, 20,
  0, 20, 20, 20,  0, 20,  0, 20,   0,  0, 20, 20,  0, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20,  20, 20,  0, 20, 20, 20,  0,  0,

// state[92 - 2] 0x000ec0 Byte 3 of 3
 20, 20, 20, 20, 20,  0, 20,  0,  20, 20, 20, 20, 20, 20,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0, 20, 20,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,

// state[93 - 2] 0x000f00 Byte 3 of 3
 21,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  21, 21,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0, 21,  0, 21,   0, 21,  0,  0,  0,  0, 21, 21,

// state[94 - 2] 0x000f40 Byte 3 of 3
 21, 21, 21, 21, 21, 21, 21, 21,   0, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21,  21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21,  21, 21, 21,  0,  0,  0,  0,  0,
  0, 21, 21, 21, 21, 21, 21, 21,  21, 21, 21, 21, 21, 21, 21, 21,

// state[95 - 2] 0x000f80 Byte 3 of 3
 21, 21, 21, 21, 21,  0, 21, 21,  21, 21, 21, 21,  0,  0,  0,  0,
 21, 21, 21, 21, 21, 21, 21, 21,   0, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21,  21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21,  21, 21, 21, 21, 21,  0,  0,  0,

// state[96 - 2] 0x000fc0 Byte 3 of 3
  0,  0,  0,  0,  0,  0, 21,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,

// state[97 - 2] 0x001000 Byte 3 of 3
 22, 22, 22, 22, 22, 22, 22, 22,  22, 22, 22, 22, 22, 22, 22, 22,
 22, 22, 22, 22, 22, 22, 22, 22,  22, 22, 22, 22, 22, 22, 22, 22,
 22, 22,  0, 22, 22, 22, 22, 22,   0, 22, 22,  0, 22, 22, 22, 22,
 22, 22, 22,  0,  0,  0, 22, 22,  22, 22,  0,  0,  0,  0,  0,  0,

// state[98 - 2] 0x001040 Byte 3 of 3
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
 22, 22, 22, 22, 22, 22, 22, 22,  22, 22,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,

// state[99 - 2] 0x001080 Byte 3 of 3
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
 23, 23, 23, 23, 23, 23, 23, 23,  23, 23, 23, 23, 23, 23, 23, 23,
 23, 23, 23, 23, 23, 23, 23, 23,  23, 23, 23, 23, 23, 23, 23, 23,

// state[100 - 2] 0x0010c0 Byte 3 of 3
 23, 23, 23, 23, 23, 23,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
 23, 23, 23, 23, 23, 23, 23, 23,  23, 23, 23, 23, 23, 23, 23, 23,
 23, 23, 23, 23, 23, 23, 23, 23,  23, 23, 23, 23, 23, 23, 23, 23,
 23, 23, 23, 23, 23, 23, 23, 23,  23, 23, 23,  0, 23,  0,  0,  0,

// state[101 - 2] 0x002d00 Byte 3 of 3
 23, 23, 23, 23, 23, 23, 23, 23,  23, 23, 23, 23, 23, 23, 23, 23,
 23, 23, 23, 23, 23, 23, 23, 23,  23, 23, 23, 23, 23, 23, 23, 23,
 23, 23, 23, 23, 23, 23,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
 52, 52, 52, 52, 52, 52, 52, 52,  52, 52, 52, 52, 52, 52, 52, 52,

// state[102 - 2] 0x001100 Byte 3 of 3
 24, 24, 24, 24, 24, 24, 24, 24,  24, 24, 24, 24, 24, 24, 24, 24,
 24, 24, 24, 24, 24, 24, 24, 24,  24, 24, 24, 24, 24, 24, 24, 24,
 24, 24, 24, 24, 24, 24, 24, 24,  24, 24, 24, 24, 24, 24, 24, 24,
 24, 24, 24, 24, 24, 24, 24, 24,  24, 24, 24, 24, 24, 24, 24, 24,

// state[103 - 2] 0x001140 Byte 3 of 3
 24, 24, 24, 24, 24, 24, 24, 24,  24, 24, 24, 24, 24, 24, 24, 24,
 24, 24, 24, 24, 24, 24, 24, 24,  24, 24,  0,  0,  0,  0,  0, 24,
 24, 24, 24, 24, 24, 24, 24, 24,  24, 24, 24, 24, 24, 24, 24, 24,
 24, 24, 24, 24, 24, 24, 24, 24,  24, 24, 24, 24, 24, 24, 24, 24,

// state[104 - 2] 0x001180 Byte 3 of 3
 24, 24, 24, 24, 24, 24, 24, 24,  24, 24, 24, 24, 24, 24, 24, 24,
 24, 24, 24, 24, 24, 24, 24, 24,  24, 24, 24, 24, 24, 24, 24, 24,
 24, 24, 24,  0,  0,  0,  0,  0,  24, 24, 24, 24, 24, 24, 24, 24,
 24, 24, 24, 24, 24, 24, 24, 24,  24, 24, 24, 24, 24, 24, 24, 24,

// state[105 - 2] 0x0011c0 Byte 3 of 3
 24, 24, 24, 24, 24, 24, 24, 24,  24, 24, 24, 24, 24, 24, 24, 24,
 24, 24, 24, 24, 24, 24, 24, 24,  24, 24, 24, 24, 24, 24, 24, 24,
 24, 24, 24, 24, 24, 24, 24, 24,  24, 24, 24, 24, 24, 24, 24, 24,
 24, 24, 24, 24, 24, 24, 24, 24,  24, 24,  0,  0,  0,  0,  0,  0,

// state[106 - 2] 0x003100 Byte 3 of 3
  0,  0,  0,  0,  0, 24, 24, 24,  24, 24, 24, 24, 24, 24, 24, 24,
 24, 24, 24, 24, 24, 24, 24, 24,  24, 24, 24, 24, 24, 24, 24, 24,
 24, 24, 24, 24, 24, 24, 24, 24,  24, 24, 24, 24, 24,  0,  0,  0,
  0, 24, 24, 24, 24, 24, 24, 24,  24, 24, 24, 24, 24, 24, 24, 24,

// state[107 - 2] 0x003180 Byte 3 of 3
 24, 24, 24, 24, 24, 24, 24, 24,  24, 24, 24, 24, 24, 24, 24,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
 24, 24, 24, 24, 24, 24, 24, 24,  24, 24, 24, 24, 24, 24, 24, 24,
 24, 24, 24, 24, 24, 24, 24, 24,   0,  0,  0,  0,  0,  0,  0,  0,

// state[108 - 2] 0x005000 Byte 2 of 3
100,100,100,100,100,100,100,100, 100,100,100,100,100,100,100,100,
100,100,100,100,100,100,100,100, 100,100,100,100,100,100,100,100,
100,100,100,100,100,100,100,100, 100,100,100,100,100,100,100,100,
100,100,100,100,100,100,100,100, 100,100,100,100,100,100,100,100,

// state[109 - 2] 0x00d000 Byte 2 of 3
100,100,100,100,100,100,100,100, 100,100,100,100,100,100,100,100,
100,100,100,100,100,100,100,100, 100,100,100,100,100,100,108,  3,
  3,  3,  3,  3,  3,  3,  3,  3,   3,  3,  3,  3,  3,  3,  3,  3,
  3,  3,  3,  3,  3,  3,  3,  3,   3,  3,  3,  3,  3,  3,  3,  3,

// state[110 - 2] 0x00d780 Byte 3 of 3
 24, 24, 24, 24, 24, 24, 24, 24,  24, 24, 24, 24, 24, 24, 24, 24,
 24, 24, 24, 24, 24, 24, 24, 24,  24, 24, 24, 24, 24, 24, 24, 24,
 24, 24, 24, 24,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,

// state[111 - 2] 0x00ffc0 Byte 3 of 3
  0,  0, 24, 24, 24, 24, 24, 24,   0,  0, 24, 24, 24, 24, 24, 24,
  0,  0, 24, 24, 24, 24, 24, 24,   0,  0, 24, 24, 24,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,

// state[112 - 2] 0x001200 Byte 3 of 3
 25, 25, 25, 25, 25, 25, 25, 25,  25, 25, 25, 25, 25, 25, 25, 25,
 25, 25, 25, 25, 25, 25, 25, 25,  25, 25, 25, 25, 25, 25, 25, 25,
 25, 25, 25, 25, 25, 25, 25, 25,  25, 25, 25, 25, 25, 25, 25, 25,
 25, 25, 25, 25, 25, 25, 25, 25,  25, 25, 25, 25, 25, 25, 25, 25,

// state[113 - 2] 0x001240 Byte 3 of 3
 25, 25, 25, 25, 25, 25, 25, 25,  25,  0, 25, 25, 25, 25,  0,  0,
 25, 25, 25, 25, 25, 25, 25,  0,  25,  0, 25, 25, 25, 25,  0,  0,
 25, 25, 25, 25, 25, 25, 25, 25,  25, 25, 25, 25, 25, 25, 25, 25,
 25, 25, 25, 25, 25, 25, 25, 25,  25, 25, 25, 25, 25, 25, 25, 25,

// state[114 - 2] 0x001280 Byte 3 of 3
 25, 25, 25, 25, 25, 25, 25, 25,  25,  0, 25, 25, 25, 25,  0,  0,
 25, 25, 25, 25, 25, 25, 25, 25,  25, 25, 25, 25, 25, 25, 25, 25,
 25, 25, 25, 25, 25, 25, 25, 25,  25, 25, 25, 25, 25, 25, 25, 25,
 25,  0, 25, 25, 25, 25,  0,  0,  25, 25, 25, 25, 25, 25, 25,  0,

// state[115 - 2] 0x0012c0 Byte 3 of 3
 25,  0, 25, 25, 25, 25,  0,  0,  25, 25, 25, 25, 25, 25, 25, 25,
 25, 25, 25, 25, 25, 25, 25,  0,  25, 25, 25, 25, 25, 25, 25, 25,
 25, 25, 25, 25, 25, 25, 25, 25,  25, 25, 25, 25, 25, 25, 25, 25,
 25, 25, 25, 25, 25, 25, 25, 25,  25, 25, 25, 25, 25, 25, 25, 25,

// state[116 - 2] 0x001300 Byte 3 of 3
 25, 25, 25, 25, 25, 25, 25, 25,  25, 25, 25, 25, 25, 25, 25, 25,
 25,  0, 25, 25, 25, 25,  0,  0,  25, 25, 25, 25, 25, 25, 25, 25,
 25, 25, 25, 25, 25, 25, 25, 25,  25, 25, 25, 25, 25, 25, 25, 25,
 25, 25, 25, 25, 25, 25, 25, 25,  25, 25, 25, 25, 25, 25, 25, 25,

// state[117 - 2] 0x001340 Byte 3 of 3
 25, 25, 25, 25, 25, 25, 25, 25,  25, 25, 25, 25, 25, 25, 25, 25,
 25, 25, 25, 25, 25, 25, 25, 25,  25, 25, 25,  0,  0,  0,  0, 25,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,

// state[118 - 2] 0x001380 Byte 3 of 3
 25, 25, 25, 25, 25, 25, 25, 25,  25, 25, 25, 25, 25, 25, 25, 25,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
 26, 26, 26, 26, 26, 26, 26, 26,  26, 26, 26, 26, 26, 26, 26, 26,
 26, 26, 26, 26, 26, 26, 26, 26,  26, 26, 26, 26, 26, 26, 26, 26,

// state[119 - 2] 0x002d80 Byte 3 of 3
 25, 25, 25, 25, 25, 25, 25, 25,  25, 25, 25, 25, 25, 25, 25, 25,
 25, 25, 25, 25, 25, 25, 25,  0,   0,  0,  0,  0,  0,  0,  0,  0,
 25, 25, 25, 25, 25, 25, 25,  0,  25, 25, 25, 25, 25, 25, 25,  0,
 25, 25, 25, 25, 25, 25, 25,  0,  25, 25, 25, 25, 25, 25, 25,  0,

// state[120 - 2] 0x002dc0 Byte 3 of 3
 25, 25, 25, 25, 25, 25, 25,  0,  25, 25, 25, 25, 25, 25, 25,  0,
 25, 25, 25, 25, 25, 25, 25,  0,  25, 25, 25, 25, 25, 25, 25,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,

// state[121 - 2] 0x0013c0 Byte 3 of 3
 26, 26, 26, 26, 26, 26, 26, 26,  26, 26, 26, 26, 26, 26, 26, 26,
 26, 26, 26, 26, 26, 26, 26, 26,  26, 26, 26, 26, 26, 26, 26, 26,
 26, 26, 26, 26, 26, 26, 26, 26,  26, 26, 26, 26, 26, 26, 26, 26,
 26, 26, 26, 26, 26,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,

// state[122 - 2] 0x001400 Byte 3 of 3
  0, 27, 27, 27, 27, 27, 27, 27,  27, 27, 27, 27, 27, 27, 27, 27,
 27, 27, 27, 27, 27, 27, 27, 27,  27, 27, 27, 27, 27, 27, 27, 27,
 27, 27, 27, 27, 27, 27, 27, 27,  27, 27, 27, 27, 27, 27, 27, 27,
 27, 27, 27, 27, 27, 27, 27, 27,  27, 27, 27, 27, 27, 27, 27, 27,

// state[123 - 2] 0x001440 Byte 3 of 3
 27, 27, 27, 27, 27, 27, 27, 27,  27, 27, 27, 27, 27, 27, 27, 27,
 27, 27, 27, 27, 27, 27, 27, 27,  27, 27, 27, 27, 27, 27, 27, 27,
 27, 27, 27, 27, 27, 27, 27, 27,  27, 27, 27, 27, 27, 27, 27, 27,
 27, 27, 27, 27, 27, 27, 27, 27,  27, 27, 27, 27, 27, 27, 27, 27,

// state[124 - 2] 0x001640 Byte 3 of 3
 27, 27, 27, 27, 27, 27, 27, 27,  27, 27, 27, 27, 27, 27, 27, 27,
 27, 27, 27, 27, 27, 27, 27, 27,  27, 27, 27, 27, 27, 27, 27, 27,
 27, 27, 27, 27, 27, 27, 27, 27,  27, 27, 27, 27, 27,  0,  0, 27,
 27, 27, 27, 27, 27, 27, 27,  0,   0,  0,  0,  0,  0,  0,  0,  0,

// state[125 - 2] 0x001680 Byte 3 of 3
  0, 28, 28, 28, 28, 28, 28, 28,  28, 28, 28, 28, 28, 28, 28, 28,
 28, 28, 28, 28, 28, 28, 28, 28,  28, 28, 28,  0,  0,  0,  0,  0,
 29, 29, 29, 29, 29, 29, 29, 29,  29, 29, 29, 29, 29, 29, 29, 29,
 29, 29, 29, 29, 29, 29, 29, 29,  29, 29, 29, 29, 29, 29, 29, 29,

// state[126 - 2] 0x0016c0 Byte 3 of 3
 29, 29, 29, 29, 29, 29, 29, 29,  29, 29, 29, 29, 29, 29, 29, 29,
 29, 29, 29, 29, 29, 29, 29, 29,  29, 29, 29, 29, 29, 29, 29, 29,
 29, 29, 29, 29, 29, 29, 29, 29,  29, 29, 29,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,

// state[127 - 2] 0x001780 Byte 3 of 3
 30, 30, 30, 30, 30, 30, 30, 30,  30, 30, 30, 30, 30, 30, 30, 30,
 30, 30, 30, 30, 30, 30, 30, 30,  30, 30, 30, 30, 30, 30, 30, 30,
 30, 30, 30, 30, 30, 30, 30, 30,  30, 30, 30, 30, 30, 30, 30, 30,
 30, 30, 30, 30,  0,  0, 30, 30,  30, 30, 30, 30, 30, 30, 30, 30,

// state[128 - 2] 0x0017c0 Byte 3 of 3
 30, 30, 30, 30, 30, 30, 30, 30,  30, 30, 30, 30, 30, 30, 30, 30,
 30, 30, 30, 30,  0,  0,  0, 30,   0,  0,  0,  0, 30, 30,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,

// state[129 - 2] 0x001800 Byte 3 of 3
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0, 31, 31, 31,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
 31, 31, 31, 31, 31, 31, 31, 31,  31, 31, 31, 31, 31, 31, 31, 31,
 31, 31, 31, 31, 31, 31, 31, 31,  31, 31, 31, 31, 31, 31, 31, 31,

// state[130 - 2] 0x001840 Byte 3 of 3
 31, 31, 31, 31, 31, 31, 31, 31,  31, 31, 31, 31, 31, 31, 31, 31,
 31, 31, 31, 31, 31, 31, 31, 31,  31, 31, 31, 31, 31, 31, 31, 31,
 31, 31, 31, 31, 31, 31, 31, 31,  31, 31, 31, 31, 31, 31, 31, 31,
 31, 31, 31, 31, 31, 31, 31, 31,   0,  0,  0,  0,  0,  0,  0,  0,

// state[131 - 2] 0x001880 Byte 3 of 3
 31, 31, 31, 31, 31, 31, 31, 31,  31, 31, 31, 31, 31, 31, 31, 31,
 31, 31, 31, 31, 31, 31, 31, 31,  31, 31, 31, 31, 31, 31, 31, 31,
 31, 31, 31, 31, 31, 31, 31, 31,  31, 31,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,

// state[132 - 2] 0x003040 Byte 3 of 3
  0, 24, 24, 24, 24, 24, 24, 24,  24, 24, 24, 24, 24, 24, 24, 24,
 24, 24, 24, 24, 24, 24, 24, 24,  24, 24, 24, 24, 24, 24, 24, 24,
 24, 24, 24, 24, 24, 24, 24, 24,  24, 24, 24, 24, 24, 24, 24, 24,
 24, 24, 24, 24, 24, 24, 24, 24,  24, 24, 24, 24, 24, 24, 24, 24,

// state[133 - 2] 0x003080 Byte 3 of 3
 24, 24, 24, 24, 24, 24, 24, 24,  24, 24, 24, 24, 24, 24, 24, 24,
 24, 24, 24, 24, 24, 24, 24,  0,   0, 36, 36,  0,  0, 24, 24, 24,
  0, 24, 24, 24, 24, 24, 24, 24,  24, 24, 24, 24, 24, 24, 24, 24,
 24, 24, 24, 24, 24, 24, 24, 24,  24, 24, 24, 24, 24, 24, 24, 24,

// state[134 - 2] 0x0031c0 Byte 3 of 3
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
 24, 24, 24, 24, 24, 24, 24, 24,  24, 24, 24, 24, 24, 24, 24, 24,

// state[135 - 2] 0x004000 Byte 2 of 3
100,100,100,100,100,100,100,100, 100,100,100,100,100,100,100,100,
100,100,100,100,100,100,100,100, 100,100,100,100,100,100,100,100,
100,100,100,100,100,100,100,100, 100,100,100,100,100,100,100,100,
100,100,100,100,100,100,134,  3, 100,100,100,100,100,100,100,100,

// state[136 - 2] 0x004d80 Byte 3 of 3
 24, 24, 24, 24, 24, 24, 24, 24,  24, 24, 24, 24, 24, 24, 24, 24,
 24, 24, 24, 24, 24, 24, 24, 24,  24, 24, 24, 24, 24, 24, 24, 24,
 24, 24, 24, 24, 24, 24, 24, 24,  24, 24, 24, 24, 24, 24, 24, 24,
 24, 24, 24, 24, 24, 24,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,

// state[137 - 2] 0x009000 Byte 2 of 3
100,100,100,100,100,100,100,100, 100,100,100,100,100,100,100,100,
100,100,100,100,100,100,100,100, 100,100,100,100,100,100,100,100,
100,100,100,100,100,100,100,100, 100,100,100,100,100,100,100,100,
100,100,100,100,100,100,100,100, 100,100,100,100,100,100,136,  3,

// state[138 - 2] 0x009f80 Byte 3 of 3
 24, 24, 24, 24, 24, 24, 24, 24,  24, 24, 24, 24, 24, 24, 24, 24,
 24, 24, 24, 24, 24, 24, 24, 24,  24, 24, 24, 24, 24, 24, 24, 24,
 24, 24, 24, 24, 24, 24, 24, 24,  24, 24, 24, 24, 24, 24, 24, 24,
 24, 24, 24, 24, 24, 24, 24, 24,  24, 24, 24, 24,  0,  0,  0,  0,

// state[139 - 2] 0x00fa00 Byte 3 of 3
 24, 24, 24, 24, 24, 24, 24, 24,  24, 24, 24, 24, 24, 24, 24, 24,
 24, 24, 24, 24, 24, 24, 24, 24,  24, 24, 24, 24, 24, 24, 24, 24,
 24, 24, 24, 24, 24, 24, 24, 24,  24, 24, 24, 24, 24, 24,  0,  0,
 24, 24, 24, 24, 24, 24, 24, 24,  24, 24, 24, 24, 24, 24, 24, 24,

// state[140 - 2] 0x00fa40 Byte 3 of 3
 24, 24, 24, 24, 24, 24, 24, 24,  24, 24, 24, 24, 24, 24, 24, 24,
 24, 24, 24, 24, 24, 24, 24, 24,  24, 24, 24, 24, 24, 24, 24, 24,
 24, 24, 24, 24, 24, 24, 24, 24,  24, 24, 24,  0,  0,  0,  0,  0,
 24, 24, 24, 24, 24, 24, 24, 24,  24, 24, 24, 24, 24, 24, 24, 24,

// state[141 - 2] 0x00fac0 Byte 3 of 3
 24, 24, 24, 24, 24, 24, 24, 24,  24, 24, 24, 24, 24, 24, 24, 24,
 24, 24, 24, 24, 24, 24, 24, 24,  24, 24,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,

// state[142 - 2] 0x02a000 Byte 3 of 4
100,100,100,100,100,100,100,100, 100,100,100,100,100,100,100,100,
100,100,100,100,100,100,100,100, 100,100,100,141,  3,  3,  3,  3,
  3,  3,  3,  3,  3,  3,  3,  3,   3,  3,  3,  3,  3,  3,  3,  3,
  3,  3,  3,  3,  3,  3,  3,  3,   3,  3,  3,  3,  3,  3,  3,  3,

// state[143 - 2] 0x02a6c0 Byte 4 of 4
 24, 24, 24, 24, 24, 24, 24, 24,  24, 24, 24, 24, 24, 24, 24, 24,
 24, 24, 24, 24, 24, 24, 24,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,

// state[144 - 2] 0x02f000 Byte 3 of 4
  3,  3,  3,  3,  3,  3,  3,  3,   3,  3,  3,  3,  3,  3,  3,  3,
  3,  3,  3,  3,  3,  3,  3,  3,   3,  3,  3,  3,  3,  3,  3,  3,
100,100,100,100,100,100,100,100, 143,  3,  3,  3,  3,  3,  3,  3,
  3,  3,  3,  3,  3,  3,  3,  3,   3,  3,  3,  3,  3,  3,  3,  3,

// state[145 - 2] 0x02fa00 Byte 4 of 4
 24, 24, 24, 24, 24, 24, 24, 24,  24, 24, 24, 24, 24, 24, 24, 24,
 24, 24, 24, 24, 24, 24, 24, 24,  24, 24, 24, 24, 24, 24,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,

// state[146 - 2] 0x00a000 Byte 3 of 3
 32, 32, 32, 32, 32, 32, 32, 32,  32, 32, 32, 32, 32, 32, 32, 32,
 32, 32, 32, 32, 32, 32, 32, 32,  32, 32, 32, 32, 32, 32, 32, 32,
 32, 32, 32, 32, 32, 32, 32, 32,  32, 32, 32, 32, 32, 32, 32, 32,
 32, 32, 32, 32, 32, 32, 32, 32,  32, 32, 32, 32, 32, 32, 32, 32,

// state[147 - 2] 0x00a480 Byte 3 of 3
 32, 32, 32, 32, 32, 32, 32, 32,  32, 32, 32, 32, 32,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,

// state[148 - 2] 0x010000 Byte 3 of 4
163,164,165,166,  3,  3,  3,  3,   3,  3,  3,  3,147,148,167,178,
149,150,168,  3,  3,  3,  3,  3,   3,  3,  3,  3,  3,  3,  3,  3,
169,  3,  3,  3,185,  3,  3,  3, 179,  3,  3,  3,  3,  3,  3,  3,
  3,  3,  3,  3,  3,  3,  3,  3,   3,  3,  3,  3,  3,  3,  3,  3,

// state[149 - 2] 0x010300 Byte 4 of 4
 33, 33, 33, 33, 33, 33, 33, 33,  33, 33, 33, 33, 33, 33, 33, 33,
 33, 33, 33, 33, 33, 33, 33, 33,  33, 33, 33, 33, 33, 33, 33,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
 34, 34, 34, 34, 34, 34, 34, 34,  34, 34, 34, 34, 34, 34, 34, 34,

// state[150 - 2] 0x010340 Byte 4 of 4
 34,  0, 34, 34, 34, 34, 34, 34,  34, 34,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,

// state[151 - 2] 0x010400 Byte 4 of 4
 35, 35, 35, 35, 35, 35, 35, 35,  35, 35, 35, 35, 35, 35, 35, 35,
 35, 35, 35, 35, 35, 35, 35, 35,  35, 35, 35, 35, 35, 35, 35, 35,
 35, 35, 35, 35, 35, 35, 35, 35,  35, 35, 35, 35, 35, 35, 35, 35,
 35, 35, 35, 35, 35, 35, 35, 35,  35, 35, 35, 35, 35, 35, 35, 35,

// state[152 - 2] 0x010440 Byte 4 of 4
 35, 35, 35, 35, 35, 35, 35, 35,  35, 35, 35, 35, 35, 35, 35, 35,
 45, 45, 45, 45, 45, 45, 45, 45,  45, 45, 45, 45, 45, 45, 45, 45,
 45, 45, 45, 45, 45, 45, 45, 45,  45, 45, 45, 45, 45, 45, 45, 45,
 45, 45, 45, 45, 45, 45, 45, 45,  45, 45, 45, 45, 45, 45, 45, 45,

// state[153 - 2] 0x000300 Byte 2 of 2
 36, 36, 36, 36, 36, 36, 36, 36,  36, 36, 36, 36, 36, 36, 36, 36,
 36, 36, 36, 36, 36, 36, 36, 36,  36, 36, 36, 36, 36, 36, 36, 36,
 36, 36, 36, 36, 36, 36, 36, 36,  36, 36, 36, 36, 36, 36, 36, 36,
 36, 36, 36, 36, 36, 36, 36, 36,  36, 36, 36, 36, 36, 36, 36, 36,

// state[154 - 2] 0x001dc0 Byte 3 of 3
 36, 36, 36, 36, 36, 36, 36, 36,  36, 36, 36,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0, 36, 36,

// state[155 - 2] 0x0020c0 Byte 3 of 3
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
 36, 36, 36, 36, 36, 36, 36, 36,  36, 36, 36, 36, 36, 36, 36, 36,
 36, 36, 36, 36, 36, 36, 36, 36,  36, 36, 36, 36, 36, 36, 36, 36,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,

// state[156 - 2] 0x00fe00 Byte 3 of 3
 36, 36, 36, 36, 36, 36, 36, 36,  36, 36, 36, 36, 36, 36, 36, 36,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
 36, 36, 36, 36,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,

// state[157 - 2] 0x01d180 Byte 4 of 4
 36, 36, 36,  0,  0, 36, 36, 36,  36, 36, 36, 36,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0, 36, 36, 36, 36,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,

// state[158 - 2] 0x0c0000 Byte 2 of 4
  2,  2,  2,  2,  2,  2,  2,  2,   2,  2,  2,  2,  2,  2,  2,  2,
  2,  2,  2,  2,  2,  2,  2,  2,   2,  2,  2,  2,  2,  2,  2,  2,
157,  2,  2,  2,  2,  2,  2,  2,   2,  2,  2,  2,  2,  2,  2,  2,
  2,  2,  2,  2,  2,  2,  2,  2,   2,  2,  2,  2,  2,  2,  2,  2,

// state[159 - 2] 0x0e0000 Byte 3 of 4
  3,  3,  3,  3,151,151,151,158,   3,  3,  3,  3,  3,  3,  3,  3,
  3,  3,  3,  3,  3,  3,  3,  3,   3,  3,  3,  3,  3,  3,  3,  3,
  3,  3,  3,  3,  3,  3,  3,  3,   3,  3,  3,  3,  3,  3,  3,  3,
  3,  3,  3,  3,  3,  3,  3,  3,   3,  3,  3,  3,  3,  3,  3,  3,

// state[160 - 2] 0x0e01c0 Byte 4 of 4
 36, 36, 36, 36, 36, 36, 36, 36,  36, 36, 36, 36, 36, 36, 36, 36,
 36, 36, 36, 36, 36, 36, 36, 36,  36, 36, 36, 36, 36, 36, 36, 36,
 36, 36, 36, 36, 36, 36, 36, 36,  36, 36, 36, 36, 36, 36, 36, 36,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,

// state[161 - 2] 0x001700 Byte 3 of 3
 37, 37, 37, 37, 37, 37, 37, 37,  37, 37, 37, 37, 37,  0, 37, 37,
 37, 37, 37, 37, 37,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
 38, 38, 38, 38, 38, 38, 38, 38,  38, 38, 38, 38, 38, 38, 38, 38,
 38, 38, 38, 38, 38,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,

// state[162 - 2] 0x001740 Byte 3 of 3
 39, 39, 39, 39, 39, 39, 39, 39,  39, 39, 39, 39, 39, 39, 39, 39,
 39, 39, 39, 39,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
 40, 40, 40, 40, 40, 40, 40, 40,  40, 40, 40, 40, 40,  0, 40, 40,
 40,  0, 40, 40,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,

// state[163 - 2] 0x001900 Byte 3 of 3
 41, 41, 41, 41, 41, 41, 41, 41,  41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41,  41, 41, 41, 41, 41,  0,  0,  0,
 41, 41, 41, 41, 41, 41, 41, 41,  41, 41, 41, 41,  0,  0,  0,  0,
 41, 41, 41, 41, 41, 41, 41, 41,  41, 41, 41, 41,  0,  0,  0,  0,

// state[164 - 2] 0x001940 Byte 3 of 3
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
 42, 42, 42, 42, 42, 42, 42, 42,  42, 42, 42, 42, 42, 42, 42, 42,
 42, 42, 42, 42, 42, 42, 42, 42,  42, 42, 42, 42, 42, 42,  0,  0,
 42, 42, 42, 42, 42,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,

// state[165 - 2] 0x010000 Byte 4 of 4
 43, 43, 43, 43, 43, 43, 43, 43,  43, 43, 43, 43,  0, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43,  43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43,  0,  43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43,  43, 43, 43,  0, 43, 43,  0, 43,

// state[166 - 2] 0x010040 Byte 4 of 4
 43, 43, 43, 43, 43, 43, 43, 43,  43, 43, 43, 43, 43, 43,  0,  0,
 43, 43, 43, 43, 43, 43, 43, 43,  43, 43, 43, 43, 43, 43,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,

// state[167 - 2] 0x010080 Byte 4 of 4
 43, 43, 43, 43, 43, 43, 43, 43,  43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43,  43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43,  43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43,  43, 43, 43, 43, 43, 43, 43, 43,

// state[168 - 2] 0x0100c0 Byte 4 of 4
 43, 43, 43, 43, 43, 43, 43, 43,  43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43,  43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43,  43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43,  43, 43, 43,  0,  0,  0,  0,  0,

// state[169 - 2] 0x010380 Byte 4 of 4
 44, 44, 44, 44, 44, 44, 44, 44,  44, 44, 44, 44, 44, 44, 44, 44,
 44, 44, 44, 44, 44, 44, 44, 44,  44, 44, 44, 44, 44, 44,  0,  0,
 54, 54, 54, 54, 54, 54, 54, 54,  54, 54, 54, 54, 54, 54, 54, 54,
 54, 54, 54, 54, 54, 54, 54, 54,  54, 54, 54, 54, 54, 54, 54, 54,

// state[170 - 2] 0x010480 Byte 4 of 4
 46, 46, 46, 46, 46, 46, 46, 46,  46, 46, 46, 46, 46, 46, 46, 46,
 46, 46, 46, 46, 46, 46, 46, 46,  46, 46, 46, 46, 46, 46,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,

// state[171 - 2] 0x010800 Byte 4 of 4
 47, 47, 47, 47, 47, 47,  0,  0,  47,  0, 47, 47, 47, 47, 47, 47,
 47, 47, 47, 47, 47, 47, 47, 47,  47, 47, 47, 47, 47, 47, 47, 47,
 47, 47, 47, 47, 47, 47, 47, 47,  47, 47, 47, 47, 47, 47, 47, 47,
 47, 47, 47, 47, 47, 47,  0, 47,  47,  0,  0,  0, 47,  0,  0, 47,

// state[172 - 2] 0x001a00 Byte 3 of 3
 48, 48, 48, 48, 48, 48, 48, 48,  48, 48, 48, 48, 48, 48, 48, 48,
 48, 48, 48, 48, 48, 48, 48, 48,  48, 48, 48, 48,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,

// state[173 - 2] 0x002c80 Byte 3 of 3
 49, 49, 49, 49, 49, 49, 49, 49,  49, 49, 49, 49, 49, 49, 49, 49,
 49, 49, 49, 49, 49, 49, 49, 49,  49, 49, 49, 49, 49, 49, 49, 49,
 49, 49, 49, 49, 49, 49, 49, 49,  49, 49, 49, 49, 49, 49, 49, 49,
 49, 49, 49, 49, 49, 49, 49, 49,  49, 49, 49, 49, 49, 49, 49, 49,

// state[174 - 2] 0x002cc0 Byte 3 of 3
 49, 49, 49, 49, 49, 49, 49, 49,  49, 49, 49, 49, 49, 49, 49, 49,
 49, 49, 49, 49, 49, 49, 49, 49,  49, 49, 49, 49, 49, 49, 49, 49,
 49, 49, 49, 49, 49,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,

// state[175 - 2] 0x001980 Byte 3 of 3
 50, 50, 50, 50, 50, 50, 50, 50,  50, 50, 50, 50, 50, 50, 50, 50,
 50, 50, 50, 50, 50, 50, 50, 50,  50, 50, 50, 50, 50, 50, 50, 50,
 50, 50, 50, 50, 50, 50, 50, 50,  50, 50,  0,  0,  0,  0,  0,  0,
 50, 50, 50, 50, 50, 50, 50, 50,  50, 50, 50, 50, 50, 50, 50, 50,

// state[176 - 2] 0x0019c0 Byte 3 of 3
 50, 50, 50, 50, 50, 50, 50, 50,  50, 50,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,

// state[177 - 2] 0x002c00 Byte 3 of 3
 51, 51, 51, 51, 51, 51, 51, 51,  51, 51, 51, 51, 51, 51, 51, 51,
 51, 51, 51, 51, 51, 51, 51, 51,  51, 51, 51, 51, 51, 51, 51, 51,
 51, 51, 51, 51, 51, 51, 51, 51,  51, 51, 51, 51, 51, 51, 51,  0,
 51, 51, 51, 51, 51, 51, 51, 51,  51, 51, 51, 51, 51, 51, 51, 51,

// state[178 - 2] 0x002d40 Byte 3 of 3
 52, 52, 52, 52, 52, 52, 52, 52,  52, 52, 52, 52, 52, 52, 52, 52,
 52, 52, 52, 52, 52, 52, 52, 52,  52, 52, 52, 52, 52, 52, 52, 52,
 52, 52, 52, 52, 52, 52,  0,  0,   0,  0,  0,  0,  0,  0,  0, 52,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,

// state[179 - 2] 0x00a800 Byte 3 of 3
 53, 53, 53, 53, 53, 53, 53, 53,  53, 53, 53, 53, 53, 53, 53, 53,
 53, 53, 53, 53, 53, 53, 53, 53,  53, 53, 53, 53, 53, 53, 53, 53,
 53, 53, 53, 53, 53, 53, 53, 53,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,

// state[180 - 2] 0x0103c0 Byte 4 of 4
 54, 54, 54, 54,  0,  0,  0,  0,  54, 54, 54, 54, 54, 54, 54, 54,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,

// state[181 - 2] 0x010a00 Byte 4 of 4
 55, 55, 55, 55,  0, 55, 55,  0,   0,  0,  0,  0, 55, 55, 55, 55,
 55, 55, 55, 55,  0, 55, 55, 55,   0, 55, 55, 55, 55, 55, 55, 55,
 55, 55, 55, 55, 55, 55, 55, 55,  55, 55, 55, 55, 55, 55, 55, 55,
 55, 55, 55, 55,  0,  0,  0,  0,  55, 55, 55,  0,  0,  0,  0, 55,

// state[182 - 2] 0x001b00 Byte 3 of 3
 56, 56, 56, 56, 56, 56, 56, 56,  56, 56, 56, 56, 56, 56, 56, 56,
 56, 56, 56, 56, 56, 56, 56, 56,  56, 56, 56, 56, 56, 56, 56, 56,
 56, 56, 56, 56, 56, 56, 56, 56,  56, 56, 56, 56, 56, 56, 56, 56,
 56, 56, 56, 56, 56, 56, 56, 56,  56, 56, 56, 56, 56, 56, 56, 56,

// state[183 - 2] 0x001b40 Byte 3 of 3
 56, 56, 56, 56, 56, 56, 56, 56,  56, 56, 56, 56,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0, 56, 56, 56, 56, 56,
 56, 56, 56, 56,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,

// state[184 - 2] 0x012000 Byte 3 of 4
183,183,183,183,183,183,183,183, 183,183,183,183,183,184,  3,  3,
  3,  3,  3,  3,  3,  3,  3,  3,   3,  3,  3,  3,  3,  3,  3,  3,
  3,  3,  3,  3,  3,  3,  3,  3,   3,  3,  3,  3,  3,  3,  3,  3,
  3,  3,  3,  3,  3,  3,  3,  3,   3,  3,  3,  3,  3,  3,  3,  3,

// state[185 - 2] 0x012000 Byte 4 of 4
 57, 57, 57, 57, 57, 57, 57, 57,  57, 57, 57, 57, 57, 57, 57, 57,
 57, 57, 57, 57, 57, 57, 57, 57,  57, 57, 57, 57, 57, 57, 57, 57,
 57, 57, 57, 57, 57, 57, 57, 57,  57, 57, 57, 57, 57, 57, 57, 57,
 57, 57, 57, 57, 57, 57, 57, 57,  57, 57, 57, 57, 57, 57, 57, 57,

// state[186 - 2] 0x012340 Byte 4 of 4
 57, 57, 57, 57, 57, 57, 57, 57,  57, 57, 57, 57, 57, 57, 57, 57,
 57, 57, 57, 57, 57, 57, 57, 57,  57, 57, 57, 57, 57, 57, 57, 57,
 57, 57, 57, 57, 57, 57, 57, 57,  57, 57, 57, 57, 57, 57, 57,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,

// state[187 - 2] 0x010900 Byte 4 of 4
 58, 58, 58, 58, 58, 58, 58, 58,  58, 58, 58, 58, 58, 58, 58, 58,
 58, 58, 58, 58, 58, 58,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,

// state[188 - 2] 0x00a840 Byte 3 of 3
 59, 59, 59, 59, 59, 59, 59, 59,  59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59,  59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59,  59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,

// state[189 - 2] 0x0007c0 Byte 2 of 2
  0,  0,  0,  0,  0,  0,  0,  0,   0,  0, 60, 60, 60, 60, 60, 60,
 60, 60, 60, 60, 60, 60, 60, 60,  60, 60, 60, 60, 60, 60, 60, 60,
 60, 60, 60, 60, 60, 60, 60, 60,  60, 60, 60, 60, 60, 60, 60, 60,
 60, 60, 60, 60, 60, 60,  0,  0,   0,  0, 60,  0,  0,  0,  0,  0,

};

// Remap base[0] = (del, add, string_offset)
static const RemapEntry utf8propletterscriptnum_remap_base[] = {
{0,0,0} };

// Remap string[0]
static const unsigned char utf8propletterscriptnum_remap_string[] = {
0 };

static const UTF8PropObj utf8propletterscriptnum_obj = {
  utf8propletterscriptnum_STATE0,
  utf8propletterscriptnum_STATE0_SIZE,
  utf8propletterscriptnum_TOTAL_SIZE,
  utf8propletterscriptnum_MAX_EXPAND_X4,
  utf8propletterscriptnum_SHIFT,
  utf8propletterscriptnum_BYTES,
  utf8propletterscriptnum_LOSUB,
  utf8propletterscriptnum_HIADD,
  utf8propletterscriptnum,
  utf8propletterscriptnum_remap_base,
  utf8propletterscriptnum_remap_string,
  NULL
};


#undef X__
#undef RJ_
#undef S1_
#undef S2_
#undef S3_
#undef S21
#undef S31
#undef S32
#undef T1_
#undef T2_
#undef S11
#undef SP_
#undef D__
#undef RJA

// Table has 12160 bytes, Hash = 838E-A7E3

#endif  // EXPERIMENTAL_USERS_DSITES_LANGDET_UTF8PROPLETTERSCRIPTNUM_H__
