/****************************************************************************
**
** Copyright (C) 2013 Digia Plc and/or its subsidiary(-ies).
** Contact: http://www.qt-project.org/legal
**
** This file is part of the QtWebEngine module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and Digia.  For licensing terms and
** conditions see http://qt.digia.com/licensing.  For further information
** use the contact form at http://qt.digia.com/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Digia gives you certain additional
** rights.  These rights are described in the Digia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3.0 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU General Public License version 3.0 requirements will be
** met: http://www.gnu.org/copyleft/gpl.html.
**
**
** $QT_END_LICENSE$
**
****************************************************************************/

#include "render_widget_host_view_qt_delegate_widget.h"

#include "qwebenginepage_p.h"
#include "qwebengineview.h"
#include <QtGlobal>
#include <QLayout>
#include <QResizeEvent>
#include <QPainter>
#include <QPaintEvent>
#include <QWindow>
#include <QtWidgets/QApplication>
//COMCAST MODIFICATION BEGIN [CHROMIUM POPUPS]
#include <QGraphicsProxyWidget>
#include <QGraphicsScene>
#include <QGraphicsView>
//COMCAST MODIFICATION END [CHROMIUM POPUPS]

static const int MaxTooltipLength = 1024;

RenderWidgetHostViewQtDelegateWidget::RenderWidgetHostViewQtDelegateWidget(RenderWidgetHostViewQtDelegateClient *client, QWidget *parent)
    : QWidget(parent)
    , m_client(client)
    , m_isPopup(false)
{
    setFocusPolicy(Qt::ClickFocus);
    setMouseTracking(true);
    setAttribute(Qt::WA_AcceptTouchEvents);
    setAttribute(Qt::WA_OpaquePaintEvent);
}

//COMCAST MODIFICATION BEGIN [FIX CRASH]
RenderWidgetHostViewQtDelegateWidget::~RenderWidgetHostViewQtDelegateWidget()
{
    clearFocus();
}
//COMCAST MODIFICATION END [FIX CRASH]

void RenderWidgetHostViewQtDelegateWidget::initAsChild(WebContentsAdapterClient* container)
{
    QWebEnginePagePrivate *pagePrivate = static_cast<QWebEnginePagePrivate *>(container);
    if (pagePrivate->view) {
        pagePrivate->view->layout()->addWidget(this);
    } else
        setParent(0);
}

//COMCAST MODIFICATION BEGIN [CHROMIUM POPUPS]
void RenderWidgetHostViewQtDelegateWidget::addPopupToGraphicsScene(WebContentsAdapterClient* container)
{
    QWebEnginePagePrivate *pagePrivate = static_cast<QWebEnginePagePrivate *>(container);
    QWebEngineView* view = pagePrivate->view;
    QGraphicsProxyWidget* viewProxyWidget = NULL;
    QGraphicsScene* graphicsScene = NULL;
    if(!view)
        return;

    viewProxyWidget = view->graphicsProxyWidget();
    if(!viewProxyWidget)
        return;

    graphicsScene = viewProxyWidget->scene();
    if(!graphicsScene)
        return;

    QGraphicsProxyWidget* popupProxy = graphicsScene->addWidget(this);
    popupProxy->setParentItem(viewProxyWidget);

    //chromium popups can't have focus
    popupProxy->setFlag(QGraphicsItem::ItemIsFocusable,false);
    popupProxy->grabMouse();
}
//COMCAST MODIFICATION END [CHROMIUM POPUPS]

void RenderWidgetHostViewQtDelegateWidget::initAsPopup(const QRect& screenRect, WebContentsAdapterClient* container)
{
    m_isPopup = true;
//COMCAST MODIFICATION BEGIN [CHROMIUM POPUPS]
    //this is a work-around to add the popup to the graphics scene
    //normally popups are their own top-level windows, but that doesn't
    //work in our current eglfs enviroment, if we add it to the graphics
    //scene it will render in the gl viewport
    addPopupToGraphicsScene(container);
//COMCAST MODIFICATION END [CHROMIUM POPUPS]

    // The keyboard events are supposed to go to the parent RenderHostView
    // so the WebUI popups should never have focus. Besides, if the parent view
    // loses focus, WebKit will cause its associated popups (including this one)
    // to be destroyed.
    setAttribute(Qt::WA_ShowWithoutActivating);
    setFocusPolicy(Qt::NoFocus);
    setWindowFlags(Qt::ToolTip | Qt::FramelessWindowHint | Qt::WindowDoesNotAcceptFocus);

    setGeometry(screenRect);
    show();
}

QRectF RenderWidgetHostViewQtDelegateWidget::screenRect() const
{
//COMCAST MODIFICATION BEGIN [COMPOSITE TO MAILBOX]
    QPoint pos = parentWidget()
        ? QWidget::mapToGlobal(parentWidget()->pos())
        : QWidget::pos();
    return QRectF(pos.x(), pos.y(), width(), height());
//COMCAST MODIFICATION END [COMPOSITE TO MAILBOX]
}

void RenderWidgetHostViewQtDelegateWidget::setKeyboardFocus()
{
    setFocus();
}

bool RenderWidgetHostViewQtDelegateWidget::hasKeyboardFocus()
{
    return hasFocus();
}

void RenderWidgetHostViewQtDelegateWidget::show()
{
    // Check if we're attached to a QWebEngineView, we don't
    // want to show anything else than popups as top-level.
    if (parent() || m_isPopup)
    	QWidget::show();
}

void RenderWidgetHostViewQtDelegateWidget::hide()
{
    QWidget::hide();
}

bool RenderWidgetHostViewQtDelegateWidget::isVisible() const
{
    return QWidget::isVisible();
}

QWindow* RenderWidgetHostViewQtDelegateWidget::window() const
{
    const QWidget* root = QWidget::window();
    return root ? root->windowHandle() : 0;
}

void RenderWidgetHostViewQtDelegateWidget::update()
{
//COMCAST MODIFICATION BEGIN [COMPOSITE TO MAILBOX]
    QWidget::update(QWidget::rect());
//COMCAST MODIFICATION END [COMPOSITE TO MAILBOX]
}

void RenderWidgetHostViewQtDelegateWidget::updateCursor(const QCursor &cursor)
{
    QWidget::setCursor(cursor);
}

void RenderWidgetHostViewQtDelegateWidget::resize(int width, int height)
{
    QWidget::resize(width, height);
}

void RenderWidgetHostViewQtDelegateWidget::move(const QPoint &screenPos)
{
    Q_ASSERT(m_isPopup);
    QWidget::move(screenPos);
}

void RenderWidgetHostViewQtDelegateWidget::inputMethodStateChanged(bool editorVisible)
{
    if (qApp->inputMethod()->isVisible() == editorVisible)
        return;

    QWidget::setAttribute(Qt::WA_InputMethodEnabled, editorVisible);
    qApp->inputMethod()->update(Qt::ImQueryInput | Qt::ImEnabled | Qt::ImHints);
    qApp->inputMethod()->setVisible(editorVisible);
}

void RenderWidgetHostViewQtDelegateWidget::setTooltip(const QString &tooltip)
{
    QString wrappedTip;
    if (!tooltip.isEmpty())
         wrappedTip = QStringLiteral("<p>") % tooltip.toHtmlEscaped().left(MaxTooltipLength) % QStringLiteral("</p>");
    setToolTip(wrappedTip);
}

QVariant RenderWidgetHostViewQtDelegateWidget::inputMethodQuery(Qt::InputMethodQuery query) const
{
    return m_client->inputMethodQuery(query);
}

void RenderWidgetHostViewQtDelegateWidget::resizeEvent(QResizeEvent *resizeEvent)
{
    Q_UNUSED(resizeEvent);
    m_client->notifyResize();
}

bool RenderWidgetHostViewQtDelegateWidget::event(QEvent *event)
{
    if (!m_client->forwardEvent(event))
        return QWidget::event(event);
    return true;
}

void RenderWidgetHostViewQtDelegateWidget::paintEvent(QPaintEvent * event)
{
    QPainter painter(this);
    m_client->paint(&painter, event->rect());
}


