/***************************************************************************
 *     (c)2007-2013 Broadcom Corporation
 *
 *  This program is the proprietary software of Broadcom Corporation and/or its licensors,
 *  and may only be used, duplicated, modified or distributed pursuant to the terms and
 *  conditions of a separate, written license agreement executed between you and Broadcom
 *  (an "Authorized License").  Except as set forth in an Authorized License, Broadcom grants
 *  no license (express or implied), right to use, or waiver of any kind with respect to the
 *  Software, and Broadcom expressly reserves all rights in and to the Software and all
 *  intellectual property rights therein.  IF YOU HAVE NO AUTHORIZED LICENSE, THEN YOU
 *  HAVE NO RIGHT TO USE THIS SOFTWARE IN ANY WAY, AND SHOULD IMMEDIATELY
 *  NOTIFY BROADCOM AND DISCONTINUE ALL USE OF THE SOFTWARE.
 *
 *  Except as expressly set forth in the Authorized License,
 *
 *  1.     This program, including its structure, sequence and organization, constitutes the valuable trade
 *  secrets of Broadcom, and you shall use all reasonable efforts to protect the confidentiality thereof,
 *  and to use this information only in connection with your use of Broadcom integrated circuit products.
 *
 *  2.     TO THE MAXIMUM EXTENT PERMITTED BY LAW, THE SOFTWARE IS PROVIDED "AS IS"
 *  AND WITH ALL FAULTS AND BROADCOM MAKES NO PROMISES, REPRESENTATIONS OR
 *  WARRANTIES, EITHER EXPRESS, IMPLIED, STATUTORY, OR OTHERWISE, WITH RESPECT TO
 *  THE SOFTWARE.  BROADCOM SPECIFICALLY DISCLAIMS ANY AND ALL IMPLIED WARRANTIES
 *  OF TITLE, MERCHANTABILITY, NONINFRINGEMENT, FITNESS FOR A PARTICULAR PURPOSE,
 *  LACK OF VIRUSES, ACCURACY OR COMPLETENESS, QUIET ENJOYMENT, QUIET POSSESSION
 *  OR CORRESPONDENCE TO DESCRIPTION. YOU ASSUME THE ENTIRE RISK ARISING OUT OF
 *  USE OR PERFORMANCE OF THE SOFTWARE.
 *
 *  3.     TO THE MAXIMUM EXTENT PERMITTED BY LAW, IN NO EVENT SHALL BROADCOM OR ITS
 *  LICENSORS BE LIABLE FOR (i) CONSEQUENTIAL, INCIDENTAL, SPECIAL, INDIRECT, OR
 *  EXEMPLARY DAMAGES WHATSOEVER ARISING OUT OF OR IN ANY WAY RELATING TO YOUR
 *  USE OF OR INABILITY TO USE THE SOFTWARE EVEN IF BROADCOM HAS BEEN ADVISED OF
 *  THE POSSIBILITY OF SUCH DAMAGES; OR (ii) ANY AMOUNT IN EXCESS OF THE AMOUNT
 *  ACTUALLY PAID FOR THE SOFTWARE ITSELF OR U.S. $1, WHICHEVER IS GREATER. THESE
 *  LIMITATIONS SHALL APPLY NOTWITHSTANDING ANY FAILURE OF ESSENTIAL PURPOSE OF
 *  ANY LIMITED REMEDY.
 *
 ***************************************************************************/
#ifndef __bcmnexus_ir_keycodes_generic_H__
#define __bcmnexus_ir_keycodes_generic_H__

#include "bcmnexus_ir_keycodes.h"

/*
** IR receiver key code maps.
**
** The "hwEventCode"s  in the following table are the values generated by the "Broadcom" remote
** that is bundled with the BCM935230 reference platform.
**
** The  "DIKS_xxx" constants are for the basic keyboard mapping (defined in "Directfb_keyboard.h").
** The  "DIKI_xxx" constants are for the advanced keyboard mapping.
*/

static const KeyMapElement IrBasicCodeMap [] =
{
    { DIKI_0,       0x52ad00ff },   /* should these be the DIKI_KP_xxx constants? */
    { DIKI_1,       0x1fe000ff },
    { DIKI_2,       0x5ea100ff },
    { DIKI_3,       0x5fa000ff },
    { DIKI_4,       0x1be400ff },
    { DIKI_5,       0x5aa500ff },
    { DIKI_6,       0x5ba400ff },
    { DIKI_7,       0x17e800ff },
    { DIKI_8,       0x56a900ff },
    { DIKI_9,       0x57a800ff },
    { DIKI_LEFT,    0x0bf400ff },
    { DIKI_RIGHT,   0x49b600ff },
    { DIKI_DOWN,    0x0cf300ff },
    { DIKI_UP,      0x4eb100ff },
    { DIKI_ENTER,   0x08f700ff },   /* the select key on the remote */
    { DIKI_ESCAPE,  0x4db200ff }    /* the clear key on the remote */
};

static const KeyMapElement IrAdvanCodeMap [] =
{
    { DIKS_0,               0x52ad00ff },
    { DIKS_1,               0x1fe000ff },
    { DIKS_2,               0x5ea100ff },
    { DIKS_3,               0x5fa000ff },
    { DIKS_4,               0x1be400ff },
    { DIKS_5,               0x5aa500ff },
    { DIKS_6,               0x5ba400ff },
    { DIKS_7,               0x17e800ff },
    { DIKS_8,               0x56a900ff },
    { DIKS_9,               0x57a800ff },
    { DIKS_CURSOR_LEFT,     0x0bf400ff },
    { DIKS_CURSOR_RIGHT,    0x49b600ff },
    { DIKS_CURSOR_DOWN,     0x0cf300ff },
    { DIKS_CURSOR_UP,       0x4eb100ff },
    { DIKS_CHANNEL_UP,      0x09f600ff },
    { DIKS_CHANNEL_DOWN,    0x0df200ff },
    { DIKS_SELECT,          0x08f700ff },
    { DIKS_EXIT,            0x4db200ff },
    { DIKS_ENTER,           0x13ec00ff },
    { DIKS_PERIOD,          0x53ac00ff },
        { DIKS_MENU,            0x4fb000ff },
        { DIKS_EPG,             0x0ef100ff },
        { DIKS_POWER,           0x0af500ff },
        { DIKS_INFO,            0x0ff000ff },
        { DIKS_MUTE,            0x01fe00ff },
        { DIKS_LAST,            0x06f900ff },
        { DIKS_REWIND,          0x19e600ff },
        { DIKS_FASTFORWARD,     0x59a600ff },
        { DIKS_PLAY,            0x1de200ff },
        { DIKS_RECORD,          0x54ab00ff },
        { DIKS_PAUSE,           0x1ce300ff },
        { DIKS_STOP,            0x5ca300ff },
        { DIKS_PREVIOUS,        0x58a700ff },
        { DIKS_NEXT,            0x18e700ff },
        { DIKS_FAVORITES,               0x02fd00ff }, /* FAV1 */
    { DIKS_CUSTOM3,         0x03fc00ff }, /* FAV2 */
    { DIKS_CUSTOM4,         0x42bd00ff }, /* FAV3 */
    { DIKS_CUSTOM5,         0x43bc00ff }, /* FAV4 */
    { DIKS_VOLUME_UP,       0x48b700ff },
    { DIKS_VOLUME_DOWN,     0x4cb300ff },
    { DIKS_AUX,             0x4ab500ff }, /* Source */
    { DIKS_TV,              0x4bb400ff }, /* WatchTV */
    { DIKS_SCREEN,          0x1ee100ff }, /* Picture */
    { DIKS_ZOOM,            0x1ae500ff }, /* Aspect */
    { DIKS_TEXT,            0x47b800ff },
    { DIKS_INTERNET,        0x07f800ff }, /* Apps */
    { DIKS_AUDIO,           0x41be00ff },
    { DIKS_VIDEO,           0x45ba00ff },
    { DIKS_SUBTITLE,        0x40bf00ff },
    { DIKS_RADIO,           0x05fa00ff },
    { DIKS_RED,             0x50af00ff },
    { DIKS_GREEN,           0x10ef00ff },
    { DIKS_YELLOW,          0x11ee00ff },
    { DIKS_BLUE,            0x51ae00ff },
};

#endif
