/******************************************************************************
 *    (c)2010-2013 Broadcom Corporation
 *
 * This program is the proprietary software of Broadcom Corporation and/or its licensors,
 * and may only be used, duplicated, modified or distributed pursuant to the terms and
 * conditions of a separate, written license agreement executed between you and Broadcom
 * (an "Authorized License").  Except as set forth in an Authorized License, Broadcom grants
 * no license (express or implied), right to use, or waiver of any kind with respect to the
 * Software, and Broadcom expressly reserves all rights in and to the Software and all
 * intellectual property rights therein.  IF YOU HAVE NO AUTHORIZED LICENSE, THEN YOU
 * HAVE NO RIGHT TO USE THIS SOFTWARE IN ANY WAY, AND SHOULD IMMEDIATELY
 * NOTIFY BROADCOM AND DISCONTINUE ALL USE OF THE SOFTWARE.
 *
 * Except as expressly set forth in the Authorized License,
 *
 * 1.     This program, including its structure, sequence and organization, constitutes the valuable trade
 * secrets of Broadcom, and you shall use all reasonable efforts to protect the confidentiality thereof,
 * and to use this information only in connection with your use of Broadcom integrated circuit products.
 *
 * 2.     TO THE MAXIMUM EXTENT PERMITTED BY LAW, THE SOFTWARE IS PROVIDED "AS IS"
 * AND WITH ALL FAULTS AND BROADCOM MAKES NO PROMISES, REPRESENTATIONS OR
 * WARRANTIES, EITHER EXPRESS, IMPLIED, STATUTORY, OR OTHERWISE, WITH RESPECT TO
 * THE SOFTWARE.  BROADCOM SPECIFICALLY DISCLAIMS ANY AND ALL IMPLIED WARRANTIES
 * OF TITLE, MERCHANTABILITY, NONINFRINGEMENT, FITNESS FOR A PARTICULAR PURPOSE,
 * LACK OF VIRUSES, ACCURACY OR COMPLETENESS, QUIET ENJOYMENT, QUIET POSSESSION
 * OR CORRESPONDENCE TO DESCRIPTION. YOU ASSUME THE ENTIRE RISK ARISING OUT OF
 * USE OR PERFORMANCE OF THE SOFTWARE.
 *
 * 3.     TO THE MAXIMUM EXTENT PERMITTED BY LAW, IN NO EVENT SHALL BROADCOM OR ITS
 * LICENSORS BE LIABLE FOR (i) CONSEQUENTIAL, INCIDENTAL, SPECIAL, INDIRECT, OR
 * EXEMPLARY DAMAGES WHATSOEVER ARISING OUT OF OR IN ANY WAY RELATING TO YOUR
 * USE OF OR INABILITY TO USE THE SOFTWARE EVEN IF BROADCOM HAS BEEN ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGES; OR (ii) ANY AMOUNT IN EXCESS OF THE AMOUNT
 * ACTUALLY PAID FOR THE SOFTWARE ITSELF OR U.S. $1, WHICHEVER IS GREATER. THESE
 * LIMITATIONS SHALL APPLY NOTWITHSTANDING ANY FAILURE OF ESSENTIAL PURPOSE OF
 * ANY LIMITED REMEDY.
 *
 *****************************************************************************/

#ifndef __PLATFORM_NEXUS_SURFACE_COMPOSITOR_DISPLAY_H__
#define __PLATFORM_NEXUS_SURFACE_COMPOSITOR_DISPLAY_H__

#include "platform_nexus_init.h"
#include "platform_display.h"

#if NEXUS_HAS_SURFACE_COMPOSITOR
#include "nexus_surface_compositor.h"
#endif

#ifdef __cplusplus
extern "C"
{
#endif

/*multi-app XS mode. Assuming five triple buffered applications*/
#define NUM_NSC_SURFACES 15
#define MAX_NSC_RECYCLE 2
#define MAX_NSC_DEPTH 3

struct {
    struct {
        DFB_PlatformNexusHandle handle;
        bool submitted;
    } surface[NUM_NSC_SURFACES];
    unsigned submitPtr, depth;
} surfaceQueue;

void
DFB_Platform_SurfaceClient_GetSettings(DFB_PlatformNexusHandle display, NEXUS_SurfaceClientSettings *nexusSettings);

DFB_PlatformResult
DFB_Platform_SurfaceClient_SetSettings(DFB_PlatformNexusHandle display, NEXUS_SurfaceClientSettings *nexusSettings);

DFB_PlatformResult
DFB_Platform_SurfaceClient_RecycleSurface(
    DFB_PlatformNexusHandle display,
    NEXUS_SurfaceHandle *surface,
    int maxRecycle,
    size_t *num);

DFB_PlatformResult
DFB_Platform_SurfaceClient_PushSurface(
    DFB_PlatformNexusHandle display,
    NEXUS_SurfaceHandle surface,
    const DFB_PlatformRect *pUpdateRect);

DFB_PlatformResult
DFB_Platform_SurfaceClient_SetSurface(DFB_PlatformNexusHandle display, NEXUS_SurfaceHandle surface);

DFB_PlatformResult
DFB_Platform_SurfaceClient_UpdateSurface(
    DFB_PlatformNexusHandle display,
    const DFB_PlatformRect *pUpdateRect);

DFB_PlatformResult
DFB_Platform_SurfaceClient_PublishSurface(DFB_PlatformNexusHandle display);

void
DFB_Platform_SurfaceClient_Clear(DFB_PlatformNexusHandle display);

DFB_PlatformNexusHandle
DFB_Platform_SurfaceClient_Acquire(int clientId, DFB_Platform_SlaveType slaveType);

void
DFB_Platform_SurfaceClient_Release(DFB_PlatformNexusHandle handle);

#ifdef __cplusplus
} // extern "C"
#endif

#endif // __PLATFORM_NEXUS_SURFACE_COMPOSITOR_DISPLAY_H__
