/******************************************************************************
 *    (c)2009-2013 Broadcom Corporation
 *
 * This program is the proprietary software of Broadcom Corporation and/or its licensors,
 * and may only be used, duplicated, modified or distributed pursuant to the terms and
 * conditions of a separate, written license agreement executed between you and Broadcom
 * (an "Authorized License").  Except as set forth in an Authorized License, Broadcom grants
 * no license (express or implied), right to use, or waiver of any kind with respect to the
 * Software, and Broadcom expressly reserves all rights in and to the Software and all
 * intellectual property rights therein.  IF YOU HAVE NO AUTHORIZED LICENSE, THEN YOU
 * HAVE NO RIGHT TO USE THIS SOFTWARE IN ANY WAY, AND SHOULD IMMEDIATELY
 * NOTIFY BROADCOM AND DISCONTINUE ALL USE OF THE SOFTWARE.
 *
 * Except as expressly set forth in the Authorized License,
 *
 * 1.     This program, including its structure, sequence and organization, constitutes the valuable trade
 * secrets of Broadcom, and you shall use all reasonable efforts to protect the confidentiality thereof,
 * and to use this information only in connection with your use of Broadcom integrated circuit products.
 *
 * 2.     TO THE MAXIMUM EXTENT PERMITTED BY LAW, THE SOFTWARE IS PROVIDED "AS IS"
 * AND WITH ALL FAULTS AND BROADCOM MAKES NO PROMISES, REPRESENTATIONS OR
 * WARRANTIES, EITHER EXPRESS, IMPLIED, STATUTORY, OR OTHERWISE, WITH RESPECT TO
 * THE SOFTWARE.  BROADCOM SPECIFICALLY DISCLAIMS ANY AND ALL IMPLIED WARRANTIES
 * OF TITLE, MERCHANTABILITY, NONINFRINGEMENT, FITNESS FOR A PARTICULAR PURPOSE,
 * LACK OF VIRUSES, ACCURACY OR COMPLETENESS, QUIET ENJOYMENT, QUIET POSSESSION
 * OR CORRESPONDENCE TO DESCRIPTION. YOU ASSUME THE ENTIRE RISK ARISING OUT OF
 * USE OR PERFORMANCE OF THE SOFTWARE.
 *
 * 3.     TO THE MAXIMUM EXTENT PERMITTED BY LAW, IN NO EVENT SHALL BROADCOM OR ITS
 * LICENSORS BE LIABLE FOR (i) CONSEQUENTIAL, INCIDENTAL, SPECIAL, INDIRECT, OR
 * EXEMPLARY DAMAGES WHATSOEVER ARISING OUT OF OR IN ANY WAY RELATING TO YOUR
 * USE OF OR INABILITY TO USE THE SOFTWARE EVEN IF BROADCOM HAS BEEN ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGES; OR (ii) ANY AMOUNT IN EXCESS OF THE AMOUNT
 * ACTUALLY PAID FOR THE SOFTWARE ITSELF OR U.S. $1, WHICHEVER IS GREATER. THESE
 * LIMITATIONS SHALL APPLY NOTWITHSTANDING ANY FAILURE OF ESSENTIAL PURPOSE OF
 * ANY LIMITED REMEDY.
 *
 *****************************************************************************/
#ifndef BCMNEXUS_POOL_H_
#define BCMNEXUS_POOL_H_

#include "core/surface_pool.h"

#include "nexus_memory.h"
#include "nexus_types.h"

typedef struct bcmAllocationData {
     CoreSurfaceAllocation         *allocation;         /* Pointer to allocation */
     void                          *address;            /* Virtual (cached) address of this allocation */
     uint32_t                       hwaddress;
     NEXUS_HeapHandle               heap;
     int                            offsetInHeap;
     int                            size;
     int                            pitch;
#ifdef BCMNEXUS_GFX_PACKET_BUFFER
    BM2MC_PACKET_Plane              surfacePlane;
#endif
     NEXUS_PixelFormat              pixelformat;
     bool                           syncIssued;         /* set to true to indicate that a Checkpoint/Sync was issued */
     NEXUS_SurfaceHandle            bcmSurfaceHandle;   /* If not NULL, then holds Nexus surface handle*/
     NEXUS_Pixel                   *palette;            /* If not NULL, then points to palette */
     uint32_t                       hwpalette;
     void                          *hm_ctx;
     DFB_Platform_P_PoolHandle      gfx3DPoolHandle;    /* Handle for the 3D graphics pool */
} bcmAllocationData;

typedef struct {
    size_t                          numBytes;
    NEXUS_MemoryAllocationSettings  settings;
    void                           *pMemory;
} bcmPoolCallMemoryAllocate;

typedef struct {
    NEXUS_SurfaceHandle             surface;
    NEXUS_SurfaceCreateSettings     createSettings;
} bcmPoolCallSurfaceCreate;

extern const SurfacePoolFuncs bcmnexusPoolFunctions;
extern const SurfacePoolFuncs bcmnexusGraphics3DPoolFunctions;

#endif

