###############################################################################
#  Copyright (c) 2016 RDK Management, LLC. All rights reserved.
#  Copyright (C) 2017 Broadcom. The term "Broadcom" refers to Broadcom Limited and/or its subsidiaries.
#
#  This program is the proprietary software of Broadcom and/or its licensors,
#  and may only be used, duplicated, modified or distributed pursuant to the terms and
#  conditions of a separate, written license agreement executed between you and Broadcom
#  (an "Authorized License").  Except as set forth in an Authorized License, Broadcom grants
#  no license (express or implied), right to use, or waiver of any kind with respect to the
#  Software, and Broadcom expressly reserves all rights in and to the Software and all
#  intellectual property rights therein.  IF YOU HAVE NO AUTHORIZED LICENSE, THEN YOU
#  HAVE NO RIGHT TO USE THIS SOFTWARE IN ANY WAY, AND SHOULD IMMEDIATELY
#  NOTIFY BROADCOM AND DISCONTINUE ALL USE OF THE SOFTWARE.
#
#  Except as expressly set forth in the Authorized License,
#
#  1.     This program, including its structure, sequence and organization, constitutes the valuable trade
#  secrets of Broadcom, and you shall use all reasonable efforts to protect the confidentiality thereof,
#  and to use this information only in connection with your use of Broadcom integrated circuit products.
#
#  2.     TO THE MAXIMUM EXTENT PERMITTED BY LAW, THE SOFTWARE IS PROVIDED "AS IS"
#  AND WITH ALL FAULTS AND BROADCOM MAKES NO PROMISES, REPRESENTATIONS OR
#  WARRANTIES, EITHER EXPRESS, IMPLIED, STATUTORY, OR OTHERWISE, WITH RESPECT TO
#  THE SOFTWARE.  BROADCOM SPECIFICALLY DISCLAIMS ANY AND ALL IMPLIED WARRANTIES
#  OF TITLE, MERCHANTABILITY, NONINFRINGEMENT, FITNESS FOR A PARTICULAR PURPOSE,
#  LACK OF VIRUSES, ACCURACY OR COMPLETENESS, QUIET ENJOYMENT, QUIET POSSESSION
#  OR CORRESPONDENCE TO DESCRIPTION. YOU ASSUME THE ENTIRE RISK ARISING OUT OF
#  USE OR PERFORMANCE OF THE SOFTWARE.
#
#  3.     TO THE MAXIMUM EXTENT PERMITTED BY LAW, IN NO EVENT SHALL BROADCOM OR ITS
#  LICENSORS BE LIABLE FOR (i) CONSEQUENTIAL, INCIDENTAL, SPECIAL, INDIRECT, OR
#  EXEMPLARY DAMAGES WHATSOEVER ARISING OUT OF OR IN ANY WAY RELATING TO YOUR
#  USE OF OR INABILITY TO USE THE SOFTWARE EVEN IF BROADCOM HAS BEEN ADVISED OF
#  THE POSSIBILITY OF SUCH DAMAGES; OR (ii) ANY AMOUNT IN EXCESS OF THE AMOUNT
#  ACTUALLY PAID FOR THE SOFTWARE ITSELF OR U.S. $1, WHICHEVER IS GREATER. THESE
#  LIMITATIONS SHALL APPLY NOTWITHSTANDING ANY FAILURE OF ESSENTIAL PURPOSE OF
#  ANY LIMITED REMEDY.
###############################################################################

. /etc/device.properties

IS_7125=0
cat /proc/cpuinfo | grep 7125
if [ $? -eq 0 ]; then IS_7125=1; fi

IS_7425=0
cat /proc/cpuinfo | grep 7425
if [ $? -eq 0 ]; then IS_7425=1; fi

IS_7449=0
cat /proc/cpuinfo | grep 7449
if [ $? -eq 0 ]; then
    IS_7449=1;
else
    if [ "$HOST_NAME" = "ArrisXG1v4" ]; then
        IS_7449=1;
    fi
fi

#cd /mnt/nfs/env
export PFC_ROOT=/
#source ../bin/target-snmp/sbin/restart_snmpd.sh
if [ $IS_7125 -eq 1 ]; then

  #exporting path for dtcp keys
   if [ ! -f /etc/os-release ]; then
    export DtcpSrmFilePath=/mnt/nvram1/dtcp.srm
   else
    export DtcpSrmFilePath=/opt/persistent/dtcp.srm
   fi

  if [ ! -e $DtcpSrmFilePath ]; then
     touch $DtcpSrmFilePath
  fi
  if [ "$MANUFACTURE" == "pace" ]; then
      echo "VL_ECM_RPC_IF_NAME=wan:1"
      export VL_ECM_RPC_IF_NAME="wan:1"
      export VL_DOCSIS_DHCP_IF_NAME="wan"
      export VL_DOCSIS_WAN_IF_NAME="wan"
  else
      echo "VL_ECM_RPC_IF_NAME=bcm0:1"
      export VL_ECM_RPC_IF_NAME="bcm0:1"
      export VL_DOCSIS_DHCP_IF_NAME="bcm0"
      export VL_DOCSIS_WAN_IF_NAME="bcm0"
  fi
elif [ $IS_7425 -eq 1 ]; then
  export VL_ECM_RPC_IF_NAME="bcm0:0"
  export VL_DOCSIS_DHCP_IF_NAME="bcm0"
  export VL_DOCSIS_WAN_IF_NAME="bcm0"
elif [ $IS_7449 -eq 1 ]; then
   if [ ! -f /etc/os-release ]; then
     echo "TBD"
   else
     export DtcpSrmFilePath=/opt/persistent/dtcp.srm
     if [ ! -e $DtcpSrmFilePath ]; then
       touch $DtcpSrmFilePath
     fi
      if [ "$MANUFACTURE" = "arris"  ] || [ "$MFG_NAME" = "Arris" ]; then
       echo "VL_ECM_RPC_IF_NAME=eth2:0"
       export VL_ECM_RPC_IF_NAME="eth2:0"
       export VL_DOCSIS_DHCP_IF_NAME="eth2"
       export VL_DOCSIS_WAN_IF_NAME="eth2"
      else
       echo "TBD"
      fi
   fi
else
  export VL_ECM_RPC_IF_NAME="eth0:1"
  export VL_DOCSIS_DHCP_IF_NAME="eth0"
  export VL_DOCSIS_WAN_IF_NAME="eth0"
fi

export VL_PLATFORM_NAME="BCM_NEXUS_LINUX_74XX"

export PERM_NVRAM_DIR=/opt/persistent
export DYN_NVRAM_DIR=/opt/persistent

export MIBS=ALL
if [ -e /etc/os-release ]; then
   export SNMPCONFPATH=/tmp
else
   export SNMPCONFPATH=/mnt/nfs/bin/target-snmp/sbin
   export SNMP_BIN_DIR=/mnt/nfs/bin/target-snmp/bin
   export MIBDIRS=$SNMP_BIN_DIR/../share/snmp/mibs
fi


LD_LIBRARY_PATH=/lib:/usr/local/Qt/lib:/usr/local/lib:/mnt/nfs/bin:/mnt/nfs/lib:/mnt/nfs/bin/target-snmp/lib:$LD_LIBRARY_PATH
GST_PLUGIN_PATH=/lib/gstreamer-0.10:/usr/local/lib/gstreamer-0.10:/mnt/nfs/gstreamer-plugins

if [ "$BUILD_TYPE" != "prod" ] ; then
    LD_LIBRARY_PATH=/opt/hold:$LD_LIBRARY_PATH
fi

export GST_PLUGIN_PATH GST_PLUGIN_SCANNER GST_REGISTRY
export PATH HOME LD_LIBRARY_PATH
export GST_REGISTRY_FORK="no"

#NEXUS Multi-App
export brcm_directfb_mode=n
export brcm_multiprocess_server=refsw_server
export brcm_multiprocess_mode=y
export dtcp_create_session_wait=y

mkdir -p /tmp/mnt/diska3/persistent/si/
#fix for limiting the pthread stack size
ulimit -s 128
#fix for limit VM size -PACXG1V3-2138
ulimit -v 1024000
#ulimit -c unlimited
exec $@ 2>&1
