//COMCAST MODIFICATION BEGIN [COMPOSITE TO MAILBOX]
#ifndef _MAILBOX_RENDERER_QT_H_
#define _MAILBOX_RENDERER_QT_H_

#include "base/memory/scoped_ptr.h"
#include "base/memory/weak_ptr.h"
#include "cc/output/gl_frame_data.h"

#include <QMutex>
#include <QPainter>
#include <QRectF>
#include <QWaitCondition>
#include <QtGui/QOpenGLShaderProgram>

// Local
#include "chromium_gpu_helper.h"

class MailboxRendererQt : public base::SupportsWeakPtr<MailboxRendererQt>
{
public:
    MailboxRendererQt();
    virtual ~MailboxRendererQt();
    void setFrameData(cc::GLFrameData* gl_frame_data);
    cc::GLFrameData* takeFrameData();
    void draw(const QRectF& viewport);

protected:
    void fetchTextureAndUnlockQt();
    void syncPointRetired();
    bool prepareMailboxTexture();

private:
    QOpenGLShaderProgram        *m_program;
    int                          m_vertexCoordEntry;
    int                          m_textureCoordEntry;
    QWaitCondition               m_fetchWaitCond;
    QMutex                       m_fetchMutex;
    unsigned int                 m_textureId;
    scoped_ptr<cc::GLFrameData>  m_frontFrameData;
    scoped_ptr<cc::GLFrameData>  m_backFrameData;
    FenceSync                    m_GLFence;
};

#endif /* _MAILBOX_RENDERER_QT_H_ */
//COMCAST MODIFICATION END [COMPOSITE TO MAILBOX]
