/* Replayable replacements for global functions */

/***************************************************************
 * BEGIN STABLE.JS
 **************************************************************/
//! stable.js 0.1.3, https://github.com/Two-Screen/stable
//! © 2012 Stéphan Kochen, Angry Bytes. MIT licensed.
(function() {

// A stable array sort, because `Array#sort()` is not guaranteed stable.
// This is an implementation of merge sort, without recursion.

var stable = function(arr, comp) {
    if (typeof(comp) !== 'function') {
        comp = function(a, b) {
            a = String(a);
            b = String(b);
            if (a < b) return -1;
            if (a > b) return 1;
            return 0;
        };
    }

    var len = arr.length;

    if (len <= 1) return arr;

    // Rather than dividing input, simply iterate chunks of 1, 2, 4, 8, etc.
    // Chunks are the size of the left or right hand in merge sort.
    // Stop when the left-hand covers all of the array.
    var oarr = arr;
    for (var chk = 1; chk < len; chk *= 2) {
        arr = pass(arr, comp, chk);
    }
    for (var i = 0; i < len; i++) {
        oarr[i] = arr[i];
    }
    return oarr;
};

// Run a single pass with the given chunk size. Returns a new array.
var pass = function(arr, comp, chk) {
    var len = arr.length;
    // Output, and position.
    var result = new Array(len);
    var i = 0;
    // Step size / double chunk size.
    var dbl = chk * 2;
    // Bounds of the left and right chunks.
    var l, r, e;
    // Iterators over the left and right chunk.
    var li, ri;

    // Iterate over pairs of chunks.
    for (l = 0; l < len; l += dbl) {
        r = l + chk;
        e = r + chk;
        if (r > len) r = len;
        if (e > len) e = len;

        // Iterate both chunks in parallel.
        li = l;
        ri = r;
        while (true) {
            // Compare the chunks.
            if (li < r && ri < e) {
                // This works for a regular `sort()` compatible comparator,
                // but also for a simple comparator like: `a > b`
                if (comp(arr[li], arr[ri]) <= 0) {
                    result[i++] = arr[li++];
                }
                else {
                    result[i++] = arr[ri++];
                }
            }
            // Nothing to compare, just flush what's left.
            else if (li < r) {
                result[i++] = arr[li++];
            }
            else if (ri < e) {
                result[i++] = arr[ri++];
            }
            // Both iterators are at the chunk ends.
            else {
                break;
            }
        }
    }

    return result;
};

var arrsort = function(comp) {
    return stable(this, comp);
};

if (Object.defineProperty) {
    Object.defineProperty(Array.prototype, "sort", {
        configurable: true, writable: true, enumerable: false,
        value: arrsort
    });
} else {
    Array.prototype.sort = arrsort;
}

})();
/***************************************************************
 * END STABLE.JS
 **************************************************************/

/*
 * In a generated replay, this file is partially common, boilerplate code
 * included in every replay, and partially generated replay code. The following
 * header applies to the boilerplate code. A comment indicating "Auto-generated
 * below this comment" marks the separation between these two parts.
 *
 * Copyright (C) 2011, 2012 Purdue University
 * Written by Gregor Richards
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

(function() {
    // global eval alias
    var geval = eval;

    // detect if we're in a browser or not
    var inbrowser = false;
    var inharness = false;
    var finished = false;
    if (typeof window !== "undefined" && "document" in window) {
        inbrowser = true;
        if (window.parent && "JSBNG_handleResult" in window.parent) {
            inharness = true;
        }
    } else if (typeof global !== "undefined") {
        window = global;
        window.top = window;
    } else {
        window = (function() { return this; })();
        window.top = window;
    }

    if ("console" in window) {
        window.JSBNG_Console = window.console;
    }

    var callpath = [];

    // Workaround for bound functions as events
    delete Function.prototype.bind;

    // global state
    var JSBNG_Replay = window.top.JSBNG_Replay = {
        push: function(arr, fun) {
            arr.push(fun);
            return fun;
        },

        path: function(str) {
            verifyPath(str);
        },

        forInKeys: function(of) {
            var keys = [];
            for (var k in of)
                keys.push(k);
            return keys.sort();
        }
    };

    var currentTimeInMS;
    if (inharness) {
        currentTimeInMS = window.parent.currentTimeInMS;
    } else {
        if (window.performance && window.performance.now)
            currentTimeInMS = function() { return window.performance.now() };
        else if (typeof preciseTime !== 'undefined')
            currentTimeInMS = function() { return preciseTime() * 1000; };
        else
            currentTimeInMS = function() { return Date.now(); };
    }

    // the actual replay runner
    function onload() {
        try {
            delete window.onload;
        } catch (ex) {}

        var jr = JSBNG_Replay$;
        var cb = function() {
            var end = currentTimeInMS();
            finished = true;

            var msg = "Time: " + (end - st) + "ms";
    
            if (inharness) {
                window.parent.JSBNG_handleResult({error:false, time:(end - st)});
            } else if (inbrowser) {
                var res = document.createElement("div");
    
                res.style.position = "fixed";
                res.style.left = "1em";
                res.style.top = "1em";
                res.style.width = "35em";
                res.style.height = "5em";
                res.style.padding = "1em";
                res.style.backgroundColor = "white";
                res.style.color = "black";
                res.appendChild(document.createTextNode(msg));
    
                document.body.appendChild(res);
            } else if (typeof console !== "undefined") {
                console.log(msg);
            } else if (typeof print !== "undefined") {
                // hopefully not the browser print() function :)
                print(msg);
            }
        };

        // force it to JIT
        jr(false);

        // then time it
        var st = currentTimeInMS();
        while (jr !== null) {
            jr = jr(true, cb);
        }
    }

    // add a frame at replay time
    function iframe(pageid) {
        var iw;
        if (inbrowser) {
            // represent the iframe as an iframe (of course)
            var iframe = document.createElement("iframe");
            iframe.style.display = "none";
            document.body.appendChild(iframe);
            iw = iframe.contentWindow;
            iw.document.write("<script type=\"text/javascript\">var JSBNG_Replay_geval = eval;</script>");
            iw.document.close();
        } else {
            // no general way, just lie and do horrible things
            var topwin = window;
            (function() {
                var window = {};
                window.window = window;
                window.top = topwin;
                window.JSBNG_Replay_geval = function(str) {
                    eval(str);
                }
                iw = window;
            })();
        }
        return iw;
    }

    // called at the end of the replay stuff
    function finalize() {
        if (inbrowser) {
            setTimeout(onload, 0);
        } else {
            onload();
        }
    }

    // verify this recorded value and this replayed value are close enough
    function verify(rep, rec) {
        if (rec !== rep &&
            (rep === rep || rec === rec) /* NaN test */) {
            // FIXME?
            if (typeof rec === "function" && typeof rep === "function") {
                return true;
            }
            if (typeof rec !== "object" || rec === null ||
                !(("__JSBNG_unknown_" + typeof(rep)) in rec)) {
                return false;
            }
        }
        return true;
    }

    // general message
    var firstMessage = true;
    function replayMessage(msg) {
        if (inbrowser) {
            if (firstMessage)
                document.open();
            firstMessage = false;
            document.write(msg);
        } else {
            console.log(msg);
        }
    }

    // complain when there's an error
    function verificationError(msg) {
        if (finished) return;
        if (inharness) {
            window.parent.JSBNG_handleResult({error:true, msg: msg});
        } else replayMessage(msg);
        throw new Error();
    }

    // to verify a set
    function verifySet(objstr, obj, prop, gvalstr, gval) {
        if (/^on/.test(prop)) {
            // these aren't instrumented compatibly
            return;
        }

        if (!verify(obj[prop], gval)) {
            var bval = obj[prop];
            var msg = "Verification failure! " + objstr + "." + prop + " is not " + gvalstr + ", it's " + bval + "!";
            verificationError(msg);
        }
    }

    // to verify a call or new
    function verifyCall(iscall, func, cthis, cargs) {
        var ok = true;
        var callArgs = func.callArgs[func.inst];
        iscall = iscall ? 1 : 0;
        if (cargs.length !== callArgs.length - 1) {
            ok = false;
        } else {
            if (iscall && !verify(cthis, callArgs[0])) ok = false;
            for (var i = 0; i < cargs.length; i++) {
                if (!verify(cargs[i], callArgs[i+1])) ok = false;
            }
        }
        if (!ok) {
            var msg = "Call verification failure!";
            verificationError(msg);
        }

        return func.returns[func.inst++];
    }

    // to verify the callpath
    function verifyPath(func) {
        var real = callpath.shift();
        if (real !== func) {
            var msg = "Call path verification failure! Expected " + real + ", found " + func;
            verificationError(msg);
        }
    }

    // figure out how to define getters
    var defineGetter;
    if (Object.defineProperty) {
        var odp = Object.defineProperty;
        defineGetter = function(obj, prop, getter, setter) {
            if (typeof setter === "undefined") setter = function(){};
            odp(obj, prop, {"enumerable": true, "configurable": true, "get": getter, "set": setter});
        };
    } else if (Object.prototype.__defineGetter__) {
        var opdg = Object.prototype.__defineGetter__;
        var opds = Object.prototype.__defineSetter__;
        defineGetter = function(obj, prop, getter, setter) {
            if (typeof setter === "undefined") setter = function(){};
            opdg.call(obj, prop, getter);
            opds.call(obj, prop, setter);
        };
    } else {
        defineGetter = function() {
            verificationError("This replay requires getters for correct behavior, and your JS engine appears to be incapable of defining getters. Sorry!");
        };
    }

    var defineRegetter = function(obj, prop, getter, setter) {
        defineGetter(obj, prop, function() {
            return getter.call(this, prop);
        }, function(val) {
            // once it's set by the client, it's claimed
            setter.call(this, prop, val);
            Object.defineProperty(obj, prop, {
                "enumerable": true, "configurable": true, "writable": true,
                "value": val
            });
        });
    }

    // for calling events
    var fpc = Function.prototype.call;

// resist the urge, don't put a })(); here!
/******************************************************************************
 * Auto-generated below this comment
 *****************************************************************************/
var ow895948954 = window;
var f895948954_0;
var o0;
var o1;
var o2;
var f895948954_4;
var f895948954_6;
var f895948954_7;
var f895948954_16;
var f895948954_17;
var f895948954_18;
var o3;
var o4;
var o5;
var o6;
var o7;
var o8;
var f895948954_64;
var f895948954_65;
var f895948954_386;
var f895948954_388;
var f895948954_389;
var f895948954_391;
var o9;
var f895948954_393;
var o10;
var o11;
var o12;
var o13;
var o14;
var o15;
var f895948954_406;
var f895948954_407;
var o16;
var o17;
var o18;
var f895948954_417;
var o19;
var o20;
var f895948954_424;
var o21;
var f895948954_428;
var o22;
var f895948954_431;
var f895948954_435;
var o23;
var o24;
var o25;
var o26;
var o27;
var o28;
var o29;
var o30;
var o31;
var o32;
var o33;
var o34;
var o35;
var f895948954_449;
var f895948954_450;
var o36;
var o37;
var o38;
var o39;
var o40;
var o41;
var o42;
var o43;
var o44;
var o45;
var o46;
var o47;
var o48;
var o49;
var o50;
var o51;
var o52;
var o53;
var o54;
var o55;
var o56;
var o57;
var o58;
var o59;
var o60;
var o61;
var o62;
var o63;
var o64;
var o65;
var o66;
var o67;
var o68;
var f895948954_487;
var f895948954_488;
var o69;
var o70;
var o71;
var f895948954_496;
var o72;
var o73;
var o74;
var o75;
var o76;
var o77;
var o78;
var o79;
var o80;
var o81;
var o82;
var o83;
var o84;
var o85;
var o86;
var o87;
var o88;
var o89;
var f895948954_516;
var o90;
var o91;
var o92;
var o93;
var o94;
var o95;
var f895948954_525;
var f895948954_527;
var o96;
var o97;
var f895948954_532;
var fo895948954_534_dataset;
var f895948954_539;
var f895948954_544;
var f895948954_545;
var f895948954_556;
var f895948954_557;
var o98;
var o99;
var o100;
var o101;
var o102;
var o103;
var o104;
var f895948954_580;
var o105;
var f895948954_583;
var o106;
var o107;
var o108;
var o109;
var o110;
var o111;
var o112;
var o113;
var o114;
var o115;
var o116;
var o117;
var o118;
var o119;
var o120;
var o121;
var o122;
var o123;
var o124;
var o125;
var o126;
var o127;
var o128;
var o129;
var o130;
var o131;
var o132;
var o133;
var o134;
var o135;
var o136;
var o137;
var o138;
var o139;
var o140;
var o141;
var o142;
var o143;
var o144;
var o145;
var o146;
var o147;
var o148;
var o149;
var o150;
var o151;
var o152;
var o153;
var o154;
var o155;
var o156;
var o157;
var o158;
var o159;
var o160;
var o161;
var o162;
var o163;
var o164;
var o165;
var o166;
var o167;
var o168;
var o169;
var o170;
var o171;
var o172;
var o173;
var o174;
var o175;
var o176;
var o177;
var o178;
var o179;
var o180;
var o181;
var o182;
var o183;
var o184;
var o185;
var o186;
var o187;
var o188;
var o189;
var o190;
var o191;
var o192;
var o193;
var o194;
var o195;
var o196;
var o197;
var o198;
var o199;
var o200;
var o201;
var o202;
var o203;
var o204;
var o205;
var o206;
var o207;
var o208;
var o209;
var o210;
var o211;
var o212;
var o213;
var o214;
var o215;
var o216;
var o217;
JSBNG_Replay.sbcd2c599c3a3e31210e95c8713224c80f8baadbe_0 = [];
JSBNG_Replay.s2afb35f1712c138a3da2176b6be804eeb2d614f5_3 = [];
JSBNG_Replay.sffd704e1601e1b9a8fa55951b1471268b42138a2_127 = [];
JSBNG_Replay.scee579e12329888b8b29697b3debcf1653f58642_22 = [];
JSBNG_Replay.sce6f2b5aebe4993acb0d77ef2a0d42de42949a2e_2409 = [];
JSBNG_Replay.sce6f2b5aebe4993acb0d77ef2a0d42de42949a2e_2192 = [];
// 1
// record generated by JSBench  at 2013-07-10T17:15:45.070Z
// 2
// 3
f895948954_0 = function() { return f895948954_0.returns[f895948954_0.inst++]; };
f895948954_0.returns = [];
f895948954_0.inst = 0;
// 4
ow895948954.JSBNG__Date = f895948954_0;
// 5
o0 = {};
// 6
ow895948954.JSBNG__document = o0;
// 7
o1 = {};
// 8
ow895948954.JSBNG__sessionStorage = o1;
// 9
o2 = {};
// 10
ow895948954.JSBNG__localStorage = o2;
// 11
f895948954_4 = function() { return f895948954_4.returns[f895948954_4.inst++]; };
f895948954_4.returns = [];
f895948954_4.inst = 0;
// 12
ow895948954.JSBNG__getComputedStyle = f895948954_4;
// 15
f895948954_6 = function() { return f895948954_6.returns[f895948954_6.inst++]; };
f895948954_6.returns = [];
f895948954_6.inst = 0;
// 16
ow895948954.JSBNG__removeEventListener = f895948954_6;
// 17
f895948954_7 = function() { return f895948954_7.returns[f895948954_7.inst++]; };
f895948954_7.returns = [];
f895948954_7.inst = 0;
// 18
ow895948954.JSBNG__addEventListener = f895948954_7;
// 19
ow895948954.JSBNG__top = ow895948954;
// 28
ow895948954.JSBNG__scrollX = 0;
// 29
ow895948954.JSBNG__scrollY = 0;
// 38
f895948954_16 = function() { return f895948954_16.returns[f895948954_16.inst++]; };
f895948954_16.returns = [];
f895948954_16.inst = 0;
// 39
ow895948954.JSBNG__setTimeout = f895948954_16;
// 40
f895948954_17 = function() { return f895948954_17.returns[f895948954_17.inst++]; };
f895948954_17.returns = [];
f895948954_17.inst = 0;
// 41
ow895948954.JSBNG__setInterval = f895948954_17;
// 42
f895948954_18 = function() { return f895948954_18.returns[f895948954_18.inst++]; };
f895948954_18.returns = [];
f895948954_18.inst = 0;
// 43
ow895948954.JSBNG__clearTimeout = f895948954_18;
// 60
ow895948954.JSBNG__frames = ow895948954;
// 63
ow895948954.JSBNG__self = ow895948954;
// 64
o3 = {};
// 65
ow895948954.JSBNG__navigator = o3;
// 68
o4 = {};
// 69
ow895948954.JSBNG__history = o4;
// 70
ow895948954.JSBNG__content = ow895948954;
// 81
ow895948954.JSBNG__closed = false;
// 84
ow895948954.JSBNG__pkcs11 = null;
// 87
ow895948954.JSBNG__opener = null;
// 88
ow895948954.JSBNG__defaultStatus = "";
// 89
o5 = {};
// 90
ow895948954.JSBNG__location = o5;
// 91
ow895948954.JSBNG__innerWidth = 994;
// 92
ow895948954.JSBNG__innerHeight = 603;
// 93
ow895948954.JSBNG__outerWidth = 994;
// 94
ow895948954.JSBNG__outerHeight = 690;
// 95
ow895948954.JSBNG__screenX = 123;
// 96
ow895948954.JSBNG__screenY = 46;
// 97
ow895948954.JSBNG__mozInnerScreenX = 0;
// 98
ow895948954.JSBNG__mozInnerScreenY = 0;
// 99
ow895948954.JSBNG__pageXOffset = 0;
// 100
ow895948954.JSBNG__pageYOffset = 0;
// 101
ow895948954.JSBNG__scrollMaxX = 0;
// 102
ow895948954.JSBNG__scrollMaxY = 0;
// 103
ow895948954.JSBNG__fullScreen = false;
// 136
ow895948954.JSBNG__frameElement = null;
// 141
ow895948954.JSBNG__mozPaintCount = 0;
// 144
ow895948954.JSBNG__mozAnimationStartTime = 1373476538942;
// 145
o6 = {};
// 146
ow895948954.JSBNG__mozIndexedDB = o6;
// 149
o7 = {};
// 150
ow895948954.JSBNG__external = o7;
// 151
o8 = {};
// 152
ow895948954.JSBNG__performance = o8;
// 155
ow895948954.JSBNG__devicePixelRatio = 1;
// 158
f895948954_64 = function() { return f895948954_64.returns[f895948954_64.inst++]; };
f895948954_64.returns = [];
f895948954_64.inst = 0;
// 159
ow895948954.JSBNG__XMLHttpRequest = f895948954_64;
// 160
f895948954_65 = function() { return f895948954_65.returns[f895948954_65.inst++]; };
f895948954_65.returns = [];
f895948954_65.inst = 0;
// 161
ow895948954.JSBNG__Image = f895948954_65;
// 166
ow895948954.JSBNG__name = "";
// 173
ow895948954.JSBNG__status = "";
// 176
ow895948954.JSBNG__Components = undefined;
// 771
ow895948954.JSBNG__indexedDB = o6;
// undefined
o6 = null;
// 804
ow895948954.JSBNG__onerror = null;
// 807
f895948954_386 = function() { return f895948954_386.returns[f895948954_386.inst++]; };
f895948954_386.returns = [];
f895948954_386.inst = 0;
// 808
ow895948954.Math.JSBNG__random = f895948954_386;
// 809
// 811
o5.hash = "";
// 812
o6 = {};
// 813
f895948954_0.returns.push(o6);
// 814
f895948954_388 = function() { return f895948954_388.returns[f895948954_388.inst++]; };
f895948954_388.returns = [];
f895948954_388.inst = 0;
// 815
o6.getTime = f895948954_388;
// undefined
o6 = null;
// 816
f895948954_388.returns.push(1373476539020);
// 817
f895948954_389 = function() { return f895948954_389.returns[f895948954_389.inst++]; };
f895948954_389.returns = [];
f895948954_389.inst = 0;
// 818
f895948954_0.now = f895948954_389;
// 819
o3.userAgent = "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.8; rv:21.0) Gecko/20100101 Firefox/21.0";
// 823
o3.product = "Gecko";
// 825
o6 = {};
// 826
o0.documentElement = o6;
// 827
f895948954_391 = function() { return f895948954_391.returns[f895948954_391.inst++]; };
f895948954_391.returns = [];
f895948954_391.inst = 0;
// 828
o6.JSBNG__addEventListener = f895948954_391;
// 830
f895948954_391.returns.push(undefined);
// 833
f895948954_391.returns.push(undefined);
// 836
f895948954_391.returns.push(undefined);
// 839
f895948954_391.returns.push(undefined);
// 842
f895948954_391.returns.push(undefined);
// 845
f895948954_391.returns.push(undefined);
// 848
f895948954_391.returns.push(undefined);
// 851
f895948954_391.returns.push(undefined);
// 854
f895948954_391.returns.push(undefined);
// 857
f895948954_391.returns.push(undefined);
// 860
f895948954_391.returns.push(undefined);
// 863
f895948954_391.returns.push(undefined);
// 866
f895948954_391.returns.push(undefined);
// 869
f895948954_391.returns.push(undefined);
// 872
f895948954_391.returns.push(undefined);
// 874
f895948954_386.returns.push(0.41893095659943025);
// 875
o9 = {};
// 876
f895948954_0.returns.push(o9);
// 877
o9.getTime = f895948954_388;
// undefined
o9 = null;
// 878
f895948954_388.returns.push(1373476539063);
// 879
f895948954_386.returns.push(0.8995961889016815);
// 884
f895948954_393 = function() { return f895948954_393.returns[f895948954_393.inst++]; };
f895948954_393.returns = [];
f895948954_393.inst = 0;
// 885
o0.getElementById = f895948954_393;
// 886
f895948954_393.returns.push(null);
// 888
f895948954_393.returns.push(null);
// 894
f895948954_393.returns.push(null);
// 896
f895948954_393.returns.push(null);
// 898
f895948954_393.returns.push(null);
// 900
f895948954_393.returns.push(null);
// 902
f895948954_393.returns.push(null);
// 904
f895948954_393.returns.push(null);
// 906
f895948954_393.returns.push(null);
// 908
f895948954_393.returns.push(null);
// 910
f895948954_393.returns.push(null);
// 912
f895948954_393.returns.push(null);
// 914
f895948954_393.returns.push(null);
// 916
f895948954_393.returns.push(null);
// 918
f895948954_393.returns.push(null);
// 920
f895948954_393.returns.push(null);
// 922
f895948954_393.returns.push(null);
// 924
f895948954_393.returns.push(null);
// 926
f895948954_393.returns.push(null);
// 928
f895948954_393.returns.push(null);
// 930
f895948954_393.returns.push(null);
// 932
f895948954_393.returns.push(null);
// 934
f895948954_393.returns.push(null);
// 936
f895948954_393.returns.push(null);
// 938
f895948954_393.returns.push(null);
// 940
f895948954_393.returns.push(null);
// 942
f895948954_393.returns.push(null);
// 944
f895948954_393.returns.push(null);
// 946
f895948954_393.returns.push(null);
// 947
ow895948954.JSBNG__opera = undefined;
// 949
f895948954_393.returns.push(null);
// 951
f895948954_393.returns.push(null);
// 952
f895948954_7.returns.push(undefined);
// 961
o9 = {};
// 962
f895948954_393.returns.push(o9);
// 963
o9.className = "";
// 966
// 968
f895948954_393.returns.push(null);
// 997
o10 = {};
// 998
f895948954_393.returns.push(o10);
// 1000
f895948954_393.returns.push(o9);
// 1001
o0.defaultView = ow895948954;
// 1002
o11 = {};
// 1003
f895948954_4.returns.push(o11);
// 1004
o11.direction = void 0;
// undefined
o11 = null;
// 1005
o10.clientWidth = 994;
// undefined
o10 = null;
// 1007
o10 = {};
// 1008
f895948954_393.returns.push(o10);
// 1010
f895948954_393.returns.push(null);
// 1012
f895948954_393.returns.push(null);
// 1013
o10.clientWidth = 73;
// 1015
f895948954_393.returns.push(null);
// 1017
f895948954_393.returns.push(null);
// 1019
f895948954_393.returns.push(null);
// 1021
f895948954_393.returns.push(null);
// 1023
f895948954_393.returns.push(null);
// 1025
f895948954_393.returns.push(null);
// 1027
o11 = {};
// 1028
f895948954_393.returns.push(o11);
// 1030
f895948954_393.returns.push(null);
// 1031
o12 = {};
// 1032
o11.style = o12;
// 1033
// undefined
o12 = null;
// 1034
o11.clientWidth = 0;
// undefined
o11 = null;
// 1036
o11 = {};
// 1037
f895948954_393.returns.push(o11);
// undefined
o11 = null;
// 1039
o11 = {};
// 1040
f895948954_393.returns.push(o11);
// 1042
o12 = {};
// 1043
f895948954_393.returns.push(o12);
// 1044
o12.className = "gbt gbqfh";
// 1046
f895948954_393.returns.push(null);
// 1048
f895948954_393.returns.push(null);
// 1051
o13 = {};
// 1052
f895948954_393.returns.push(o13);
// 1053
o14 = {};
// 1054
o13.style = o14;
// 1055
o14.left = "";
// 1057
// 1059
// 1064
o15 = {};
// 1065
f895948954_393.returns.push(o15);
// 1069
f895948954_7.returns.push(undefined);
// 1070
o0.cookie = "PREF=ID=1027cc612e36f2f9:FF=0:TM=1373476536:LM=1373476536:S=0SCCQkPlw7pcnOlV";
// 1071
f895948954_406 = function() { return f895948954_406.returns[f895948954_406.inst++]; };
f895948954_406.returns = [];
f895948954_406.inst = 0;
// 1072
o2.getItem = f895948954_406;
// 1073
f895948954_406.returns.push(null);
// 1076
f895948954_406.returns.push(null);
// 1077
o15.currentStyle = void 0;
// 1079
f895948954_407 = function() { return f895948954_407.returns[f895948954_407.inst++]; };
f895948954_407.returns = [];
f895948954_407.inst = 0;
// 1080
o2.setItem = f895948954_407;
// 1081
f895948954_407.returns.push(undefined);
// 1082
o16 = {};
// 1083
o0.body = o16;
// 1085
o17 = {};
// 1086
f895948954_4.returns.push(o17);
// 1087
o17.direction = void 0;
// 1088
o18 = {};
// 1089
o15.style = o18;
// 1090
// 1092
// 1095
o11 = {};
// 1096
f895948954_393.returns.push(o11);
// 1098
o12 = {};
// 1099
f895948954_393.returns.push(o12);
// 1100
o12.className = "gbt gbqfh";
// undefined
o12 = null;
// 1102
f895948954_393.returns.push(null);
// 1104
f895948954_393.returns.push(null);
// 1107
o13 = {};
// 1108
f895948954_393.returns.push(o13);
// 1109
o14 = {};
// 1110
o13.style = o14;
// 1111
o14.left = "";
// 1113
// 1115
// 1120
o15 = {};
// 1121
f895948954_393.returns.push(o15);
// 1125
f895948954_7.returns.push(undefined);
// 1127
f895948954_406 = function() { return f895948954_406.returns[f895948954_406.inst++]; };
f895948954_406.returns = [];
f895948954_406.inst = 0;
// 1129
f895948954_406.returns.push(null);
// 1132
f895948954_406.returns.push(null);
// 1133
o15.currentStyle = void 0;
// 1135
f895948954_407 = function() { return f895948954_407.returns[f895948954_407.inst++]; };
f895948954_407.returns = [];
f895948954_407.inst = 0;
// 1137
f895948954_407.returns.push(undefined);
// 1138
o16 = {};
// 1141
o17 = {};
// 1142
f895948954_4.returns.push(o17);
// 1143
o17.direction = void 0;
// undefined
o17 = null;
// 1144
o18 = {};
// 1145
o15.style = o18;
// 1146
// 1148
// 1151
// 1152
o12 = {};
// 1153
o15.parentNode = o12;
// 1155
o17 = {};
// 1156
o12.style = o17;
// 1157
// undefined
o17 = null;
// 1160
o17 = {};
// 1161
f895948954_393.returns.push(o17);
// 1162
o17.innerHTML = "body{margin:0;}.hp{height:100%;min-height:500px;overflow-y:auto;position:absolute;width:100%}#gog{padding:3px 8px 0}.gac_m td{line-height:17px}body,td,a,p,.h{font-family:arial,sans-serif}.h{color:#12c;font-size:20px}.q{color:#00c}.ts td{padding:0}.ts{border-collapse:collapse}em{font-weight:bold;font-style:normal}.lst{height:20px;width:496px}.ds{display:inline-block}span.ds{margin:3px 0 4px;margin-left:4px}.ctr-p{margin:0 auto;min-width:980px}.jhp input[type=\"submit\"]{background-image:-moz-linear-gradient(top,#f5f5f5,#f1f1f1);-moz-border-radius:2px;-moz-user-select:none;background-color:#f5f5f5;background-image:linear-gradient(top,#f5f5f5,#f1f1f1);background-image:-o-linear-gradient(top,#f5f5f5,#f1f1f1);border:1px solid #dcdcdc;border:1px solid rgba(0, 0, 0, 0.1);border-radius:2px;color:#666;cursor:default;font-family:arial,sans-serif;font-size:11px;font-weight:bold;height:29px;line-height:27px;margin:11px 6px;min-width:54px;padding:0 8px;text-align:center}.jhp input[type=\"submit\"]:hover{background-image:-moz-linear-gradient(top,#f8f8f8,#f1f1f1);-moz-box-shadow:0 1px 1px rgba(0,0,0,0.1);background-color:#f8f8f8;background-image:linear-gradient(top,#f8f8f8,#f1f1f1);background-image:-o-linear-gradient(top,#f8f8f8,#f1f1f1);border:1px solid #c6c6c6;box-shadow:0 1px 1px rgba(0,0,0,0.1);color:#333}.jhp input[type=\"submit\"]:focus{border:1px solid #4d90fe;outline:none}a.gb1,a.gb2,a.gb3,a.gb4{color:#11c !important}body{background:#fff;color:#222}a{color:#12c;text-decoration:none}a:hover,a:active{text-decoration:underline}.fl a{color:#12c}a:visited{color:#609}a.gb1,a.gb4{text-decoration:underline}a.gb3:hover{text-decoration:none}#ghead a.gb2:hover{color:#fff!important}.sblc{padding-top:5px}.sblc a{display:block;margin:2px 0;margin-left:13px;font-size:11px;}.lsbb{height:30px;display:block}.ftl,#footer a{color:#666;margin:2px 10px 0}#footer a:active{color:#dd4b39}.lsb{border:none;color:#000;cursor:pointer;height:30px;margin:0;outline:0;font:15px arial,sans-serif;vertical-align:top}.lst:focus{outline:none}#addlang a{padding:0 3px}body,html{font-size:small}h1,ol,ul,li{margin:0;padding:0}.nojsb{display:none}.nojsv{visibility:hidden}#body,#footer{display:block}#footer{font-size:10pt;min-height:49px;position:absolute;bottom:0;width:100%}#footer>div{border-top:1px solid #ebebeb;bottom:0;padding:3px 0 10px;position:absolute;width:100%}#flci{float:left;margin-left:-260px;text-align:left;width:260px}#fll{float:right;text-align:right;width:100%}#ftby{padding-left:260px}#ftby>div,#fll>div,#footer a{display:inline-block}@media only screen and (min-width:1222px){#ftby{margin: 0 44px}}.nojsb{display:none}.nojsv{visibility:hidden}.nbcl{background:url(/images/nav_logo129.png) no-repeat -140px -230px;height:11px;width:11px}";
// undefined
o17 = null;
// 1164
o17 = {};
// 1165
f895948954_393.returns.push(o17);
// 1166
o17.innerHTML = "<div style=\"display:none\">&nbsp;</div>";
// undefined
o17 = null;
// 1169
o17 = {};
// 1170
f895948954_0.returns.push(o17);
// 1171
o17.getTime = f895948954_388;
// undefined
o17 = null;
// 1172
f895948954_388.returns.push(1373476539179);
// 1173
f895948954_16.returns.push(2);
// 1175
f895948954_417 = function() { return f895948954_417.returns[f895948954_417.inst++]; };
f895948954_417.returns = [];
f895948954_417.inst = 0;
// 1176
o0.getElementsByTagName = f895948954_417;
// 1177
o17 = {};
// 1178
f895948954_417.returns.push(o17);
// 1179
o17.length = 2;
// 1180
o19 = {};
// 1181
o17["0"] = o19;
// 1182
o19.complete = true;
// undefined
o19 = null;
// 1183
o19 = {};
// 1184
o17["1"] = o19;
// undefined
o17 = null;
// 1185
o19.complete = true;
// undefined
o19 = null;
// 1186
f895948954_7.returns.push(undefined);
// 1187
o17 = {};
// 1188
f895948954_0.returns.push(o17);
// 1189
o17.getTime = f895948954_388;
// undefined
o17 = null;
// 1190
f895948954_388.returns.push(1373476539183);
// 1191
o17 = {};
// 1193
o0.f = void 0;
// 1194
o19 = {};
// 1195
o0.gbqf = o19;
// 1197
o20 = {};
// 1198
o19.q = o20;
// 1199
f895948954_424 = function() { return f895948954_424.returns[f895948954_424.inst++]; };
f895948954_424.returns = [];
f895948954_424.inst = 0;
// 1200
o20.JSBNG__focus = f895948954_424;
// 1201
f895948954_424.returns.push(undefined);
// 1202
o21 = {};
// 1203
o0.images = o21;
// undefined
o21 = null;
// 1204
o21 = {};
// 1205
f895948954_65.returns.push(o21);
// 1206
// undefined
o21 = null;
// 1207
f895948954_16.returns.push(3);
// 1209
o21 = {};
// 1210
f895948954_0.returns.push(o21);
// 1211
o21.getTime = f895948954_388;
// undefined
o21 = null;
// 1212
f895948954_388.returns.push(1373476539190);
// 1213
f895948954_428 = function() { return f895948954_428.returns[f895948954_428.inst++]; };
f895948954_428.returns = [];
f895948954_428.inst = 0;
// 1214
o0.createElement = f895948954_428;
// 1215
o21 = {};
// 1216
f895948954_428.returns.push(o21);
// 1217
// 1219
o22 = {};
// 1220
f895948954_393.returns.push(o22);
// 1221
f895948954_431 = function() { return f895948954_431.returns[f895948954_431.inst++]; };
f895948954_431.returns = [];
f895948954_431.inst = 0;
// 1222
o22.appendChild = f895948954_431;
// undefined
o22 = null;
// 1223
f895948954_431.returns.push(o21);
// undefined
o21 = null;
// 1224
f895948954_16.returns.push(4);
// 1225
f895948954_16.returns.push(5);
// 1227
o21 = {};
// 1228
f895948954_428.returns.push(o21);
// 1229
// 1230
// 1231
f895948954_386.returns.push(0.8713209232627044);
// 1233
f895948954_393.returns.push(null);
// 1235
o16.appendChild = f895948954_431;
// 1236
f895948954_431.returns.push(o21);
// undefined
o21 = null;
// 1237
f895948954_16.returns.push(6);
// 1239
o21 = {};
// 1241
o21.which = 1;
// 1242
o21.type = "mouseover";
// 1243
o21.srcElement = void 0;
// 1244
o22 = {};
// 1245
o21.target = o22;
// 1246
o22.__jsaction = void 0;
// 1247
// 1248
f895948954_435 = function() { return f895948954_435.returns[f895948954_435.inst++]; };
f895948954_435.returns = [];
f895948954_435.inst = 0;
// 1249
o22.getAttribute = f895948954_435;
// 1250
f895948954_435.returns.push(null);
// 1251
o23 = {};
// 1252
o22.parentNode = o23;
// 1253
o23.__jsaction = void 0;
// 1254
// 1255
o23.getAttribute = f895948954_435;
// 1256
f895948954_435.returns.push(null);
// 1257
o24 = {};
// 1258
o23.parentNode = o24;
// 1259
o24.__jsaction = void 0;
// 1260
// 1261
o24.getAttribute = f895948954_435;
// 1262
f895948954_435.returns.push(null);
// 1263
o25 = {};
// 1264
o24.parentNode = o25;
// 1265
o25.__jsaction = void 0;
// 1266
// 1267
o25.getAttribute = f895948954_435;
// 1268
f895948954_435.returns.push(null);
// 1269
o26 = {};
// 1270
o25.parentNode = o26;
// 1271
o26.__jsaction = void 0;
// 1272
// 1273
o26.getAttribute = f895948954_435;
// 1274
f895948954_435.returns.push(null);
// 1275
o27 = {};
// 1276
o26.parentNode = o27;
// 1277
o27.__jsaction = void 0;
// 1278
// 1279
o27.getAttribute = f895948954_435;
// 1280
f895948954_435.returns.push(null);
// 1281
o28 = {};
// 1282
o27.parentNode = o28;
// 1283
o28.__jsaction = void 0;
// 1284
// 1285
o28.getAttribute = f895948954_435;
// 1286
f895948954_435.returns.push(null);
// 1287
o28.parentNode = o9;
// 1288
o9.__jsaction = void 0;
// 1289
// 1290
o9.getAttribute = f895948954_435;
// 1291
f895948954_435.returns.push(null);
// 1292
o29 = {};
// 1293
o9.parentNode = o29;
// 1294
o29.__jsaction = void 0;
// 1295
// 1296
o29.getAttribute = f895948954_435;
// 1297
f895948954_435.returns.push(null);
// 1298
o29.parentNode = o16;
// 1299
o16.__jsaction = void 0;
// 1300
// 1301
o16.getAttribute = f895948954_435;
// 1302
f895948954_435.returns.push(null);
// 1303
o16.parentNode = o6;
// 1304
o30 = {};
// 1306
o30.which = 1;
// 1307
o30.type = "mouseout";
// 1308
o30.srcElement = void 0;
// 1309
o30.target = o22;
// 1320
o31 = {};
// 1322
o31.which = 1;
// 1323
o31.type = "mouseover";
// 1324
o31.srcElement = void 0;
// 1325
o32 = {};
// 1326
o31.target = o32;
// 1327
o32.__jsaction = void 0;
// 1328
// 1329
o32.getAttribute = f895948954_435;
// 1330
f895948954_435.returns.push(null);
// 1331
o33 = {};
// 1332
o32.parentNode = o33;
// 1333
o33.__jsaction = void 0;
// 1334
// 1335
o33.getAttribute = f895948954_435;
// 1336
f895948954_435.returns.push(null);
// 1337
o34 = {};
// 1338
o33.parentNode = o34;
// 1339
o34.__jsaction = void 0;
// 1340
// 1341
o34.getAttribute = f895948954_435;
// 1342
f895948954_435.returns.push(null);
// 1343
o35 = {};
// 1344
o34.parentNode = o35;
// 1345
o35.__jsaction = void 0;
// 1346
// 1347
o35.getAttribute = f895948954_435;
// 1348
f895948954_435.returns.push(null);
// 1349
o35.parentNode = o16;
// 1356
f895948954_449 = function() { return f895948954_449.returns[f895948954_449.inst++]; };
f895948954_449.returns = [];
f895948954_449.inst = 0;
// 1357
o0.JSBNG__addEventListener = f895948954_449;
// 1359
f895948954_393.returns.push(o9);
// 1360
f895948954_450 = function() { return f895948954_450.returns[f895948954_450.inst++]; };
f895948954_450.returns = [];
f895948954_450.inst = 0;
// 1361
o9.getElementsByTagName = f895948954_450;
// 1362
o36 = {};
// 1363
f895948954_450.returns.push(o36);
// 1365
o37 = {};
// 1366
f895948954_393.returns.push(o37);
// 1367
o38 = {};
// 1368
o36["0"] = o38;
// 1369
o39 = {};
// 1370
o36["1"] = o39;
// 1371
o40 = {};
// 1372
o36["2"] = o40;
// 1373
o41 = {};
// 1374
o36["3"] = o41;
// 1375
o42 = {};
// 1376
o36["4"] = o42;
// 1377
o36["5"] = o23;
// 1378
o43 = {};
// 1379
o36["6"] = o43;
// 1380
o44 = {};
// 1381
o36["7"] = o44;
// 1382
o45 = {};
// 1383
o36["8"] = o45;
// 1384
o46 = {};
// 1385
o36["9"] = o46;
// 1386
o47 = {};
// 1387
o36["10"] = o47;
// 1388
o48 = {};
// 1389
o36["11"] = o48;
// 1390
o49 = {};
// 1391
o36["12"] = o49;
// 1392
o50 = {};
// 1393
o36["13"] = o50;
// 1394
o51 = {};
// 1395
o36["14"] = o51;
// 1396
o52 = {};
// 1397
o36["15"] = o52;
// 1398
o53 = {};
// 1399
o36["16"] = o53;
// 1400
o54 = {};
// 1401
o36["17"] = o54;
// 1402
o55 = {};
// 1403
o36["18"] = o55;
// 1404
o56 = {};
// 1405
o36["19"] = o56;
// 1406
o57 = {};
// 1407
o36["20"] = o57;
// 1408
o58 = {};
// 1409
o36["21"] = o58;
// 1410
o59 = {};
// 1411
o36["22"] = o59;
// 1412
o36["23"] = o10;
// 1413
o60 = {};
// 1414
o36["24"] = o60;
// 1415
o61 = {};
// 1416
o36["25"] = o61;
// 1417
o62 = {};
// 1418
o36["26"] = o62;
// 1419
o63 = {};
// 1420
o36["27"] = o63;
// 1421
o36["28"] = void 0;
// undefined
o36 = null;
// 1423
o36 = {};
// 1424
f895948954_393.returns.push(o36);
// 1426
f895948954_393.returns.push(null);
// 1428
f895948954_393.returns.push(null);
// 1429
o37.getElementsByTagName = f895948954_450;
// 1430
o64 = {};
// 1431
f895948954_450.returns.push(o64);
// 1432
o64.length = 3;
// 1433
o65 = {};
// 1434
o64["0"] = o65;
// 1435
o66 = {};
// 1436
o64["1"] = o66;
// 1437
o67 = {};
// 1438
o64["2"] = o67;
// 1439
o64["3"] = void 0;
// undefined
o64 = null;
// 1440
o38.className = "gbzt";
// 1448
o39.className = "gbzt gbz0l gbp1";
// 1456
o40.className = "gbzt";
// 1464
o41.className = "gbzt";
// 1472
o42.className = "gbzt";
// 1480
o23.className = "gbzt";
// 1488
o43.className = "gbzt";
// 1496
o44.className = "gbzt";
// 1504
o45.className = "gbzt";
// 1512
o46.className = "gbzt";
// 1520
o47.className = "gbgt";
// 1521
o47.JSBNG__addEventListener = f895948954_391;
// 1522
f895948954_391.returns.push(undefined);
// 1524
f895948954_391.returns.push(undefined);
// 1525
o48.className = "gbmt";
// 1533
o49.className = "gbmt";
// 1541
o50.className = "gbmt";
// 1549
o51.className = "gbmt";
// 1557
o52.className = "gbmt";
// 1565
o53.className = "gbmt";
// 1573
o54.className = "gbmt";
// 1581
o55.className = "gbmt";
// 1589
o56.className = "gbmt";
// 1597
o57.className = "gbmt";
// 1605
o58.className = "gbmt";
// 1613
o59.className = "gbqla";
// 1621
o10.className = "gbgt";
// 1622
o10.JSBNG__addEventListener = f895948954_391;
// 1623
f895948954_391.returns.push(undefined);
// 1625
f895948954_391.returns.push(undefined);
// 1626
o60.className = "gbmt";
// 1634
o61.className = "gbmt";
// 1642
o62.className = "gbmt";
// 1650
o63.className = "gbmt";
// 1658
o65.className = "gbqfb";
// 1663
o65.JSBNG__addEventListener = f895948954_391;
// 1664
f895948954_391.returns.push(undefined);
// 1666
f895948954_391.returns.push(undefined);
// 1667
o66.className = "gbqfba";
// 1673
o66.JSBNG__addEventListener = f895948954_391;
// 1674
f895948954_391.returns.push(undefined);
// 1676
f895948954_391.returns.push(undefined);
// 1677
o67.className = "gbqfba";
// 1683
o67.JSBNG__addEventListener = f895948954_391;
// 1684
f895948954_391.returns.push(undefined);
// 1686
f895948954_391.returns.push(undefined);
// 1688
f895948954_393.returns.push(null);
// 1690
f895948954_393.returns.push(null);
// 1691
f895948954_7.returns.push(undefined);
// 1693
o64 = {};
// 1694
f895948954_393.returns.push(o64);
// undefined
o64 = null;
// 1696
o64 = {};
// 1697
f895948954_393.returns.push(o64);
// 1699
o68 = {};
// 1700
f895948954_393.returns.push(o68);
// 1701
f895948954_487 = function() { return f895948954_487.returns[f895948954_487.inst++]; };
f895948954_487.returns = [];
f895948954_487.inst = 0;
// 1702
o64.querySelectorAll = f895948954_487;
// 1703
f895948954_488 = function() { return f895948954_488.returns[f895948954_488.inst++]; };
f895948954_488.returns = [];
f895948954_488.inst = 0;
// 1704
o64.querySelector = f895948954_488;
// 1706
o69 = {};
// 1707
f895948954_488.returns.push(o69);
// 1711
o70 = {};
// 1712
f895948954_488.returns.push(o70);
// 1713
o68.scrollTop = 0;
// 1714
o68.scrollHeight = 318;
// 1715
o68.clientHeight = 318;
// 1716
o71 = {};
// 1717
o69.style = o71;
// undefined
o69 = null;
// 1718
// undefined
o71 = null;
// 1719
o69 = {};
// 1720
o70.style = o69;
// undefined
o70 = null;
// 1721
// undefined
o69 = null;
// 1722
o68.JSBNG__addEventListener = f895948954_391;
// undefined
o68 = null;
// 1723
f895948954_391.returns.push(undefined);
// 1724
o5.href = "http://www.google.com/";
// 1725
f895948954_18.returns.push(undefined);
// 1726
f895948954_386.returns.push(0.6669860659232372);
// 1727
o68 = {};
// 1729
o68.which = 1;
// 1730
o68.type = "mouseout";
// 1731
o68.srcElement = void 0;
// 1732
o68.target = o32;
// 1738
o69 = {};
// 1740
o69.which = 1;
// 1741
o69.type = "mouseover";
// 1742
o69.srcElement = void 0;
// 1743
o69.target = o36;
// 1744
o36.__jsaction = void 0;
// 1745
// 1746
o36.getAttribute = f895948954_435;
// 1747
f895948954_435.returns.push(null);
// 1748
o70 = {};
// 1749
o36.parentNode = o70;
// 1750
o70.__jsaction = void 0;
// 1751
// 1752
o70.getAttribute = f895948954_435;
// 1753
f895948954_435.returns.push(null);
// 1754
o70.parentNode = o11;
// 1755
o11.__jsaction = void 0;
// 1756
// 1757
o11.getAttribute = f895948954_435;
// 1758
f895948954_435.returns.push(null);
// 1759
o11.parentNode = o19;
// 1760
o19.__jsaction = void 0;
// 1761
// 1762
f895948954_496 = function() { return f895948954_496.returns[f895948954_496.inst++]; };
f895948954_496.returns = [];
f895948954_496.inst = 0;
// 1763
o19.getAttribute = f895948954_496;
// 1764
f895948954_496.returns.push(null);
// 1765
o19.parentNode = o37;
// 1766
o37.__jsaction = void 0;
// 1767
// 1768
o37.getAttribute = f895948954_435;
// 1769
f895948954_435.returns.push(null);
// 1770
o71 = {};
// 1771
o37.parentNode = o71;
// 1772
o71.__jsaction = void 0;
// 1773
// 1774
o71.getAttribute = f895948954_435;
// 1775
f895948954_435.returns.push(null);
// 1776
o72 = {};
// 1777
o71.parentNode = o72;
// 1778
o72.__jsaction = void 0;
// 1779
// 1780
o72.getAttribute = f895948954_435;
// 1781
f895948954_435.returns.push(null);
// 1782
o72.parentNode = o28;
// 1787
o73 = {};
// 1789
o73.which = 1;
// 1790
o73.type = "mouseout";
// 1791
o73.srcElement = void 0;
// 1792
o73.target = o36;
// 1804
o74 = {};
// 1806
o74.which = 1;
// 1807
o74.type = "mouseover";
// 1808
o74.srcElement = void 0;
// 1809
o75 = {};
// 1810
o74.target = o75;
// 1811
o75.__jsaction = void 0;
// 1812
// 1813
o75.getAttribute = f895948954_435;
// 1814
f895948954_435.returns.push(null);
// 1815
o75.parentNode = o33;
// 1820
o76 = {};
// 1822
o76.which = 1;
// 1823
o76.type = "mouseout";
// 1824
o76.srcElement = void 0;
// 1825
o76.target = o75;
// 1831
o77 = {};
// 1833
o77.which = 1;
// 1834
o77.type = "mouseover";
// 1835
o77.srcElement = void 0;
// 1836
o78 = {};
// 1837
o77.target = o78;
// 1838
o78.__jsaction = void 0;
// 1839
// 1840
o78.getAttribute = f895948954_435;
// 1841
f895948954_435.returns.push(null);
// 1842
o78.parentNode = o33;
// 1847
o79 = {};
// 1849
o79.which = 1;
// 1850
o79.type = "mouseout";
// 1851
o79.srcElement = void 0;
// 1852
o79.target = o78;
// 1858
o80 = {};
// 1860
o80.which = 1;
// 1861
o80.type = "mouseover";
// 1862
o80.srcElement = void 0;
// 1863
o80.target = o16;
// 1865
o81 = {};
// 1867
o81.which = 1;
// 1868
o81.type = "mouseout";
// 1869
o81.srcElement = void 0;
// 1870
o81.target = o16;
// 1872
o82 = {};
// 1874
o82.which = 1;
// 1875
o82.type = "mouseover";
// 1876
o82.srcElement = void 0;
// 1877
o82.target = o78;
// 1883
o83 = {};
// 1885
o83.which = 1;
// 1886
o83.type = "mouseout";
// 1887
o83.srcElement = void 0;
// 1888
o83.target = o78;
// 1894
o84 = {};
// 1896
o84.which = 1;
// 1897
o84.type = "mouseover";
// 1898
o84.srcElement = void 0;
// 1899
o84.target = o75;
// 1905
o85 = {};
// 1907
o85.which = 1;
// 1908
o85.type = "mouseout";
// 1909
o85.srcElement = void 0;
// 1910
o85.target = o75;
// 1916
o86 = {};
// 1918
o86.which = 1;
// 1919
o86.type = "mouseover";
// 1920
o86.srcElement = void 0;
// 1921
o87 = {};
// 1922
o86.target = o87;
// 1923
o87.__jsaction = void 0;
// 1924
// 1925
o87.getAttribute = f895948954_435;
// 1926
f895948954_435.returns.push(null);
// 1927
o87.parentNode = o36;
// 1939
o88 = {};
// 1941
o88.which = 1;
// 1942
o88.type = "mouseout";
// 1943
o88.srcElement = void 0;
// 1944
o88.target = o87;
// 1957
o89 = {};
// 1959
o89.which = 1;
// 1960
o89.type = "mouseover";
// 1961
o89.srcElement = void 0;
// 1962
o89.target = o20;
// 1963
o20.__jsaction = void 0;
// 1964
// 1965
f895948954_516 = function() { return f895948954_516.returns[f895948954_516.inst++]; };
f895948954_516.returns = [];
f895948954_516.inst = 0;
// 1966
o20.getAttribute = f895948954_516;
// 1967
f895948954_516.returns.push(null);
// 1968
o20.parentNode = o87;
// 1981
o90 = {};
// 1983
o90.which = 1;
// 1984
o90.type = "mouseout";
// 1985
o90.srcElement = void 0;
// 1986
o90.target = o20;
// 2000
o91 = {};
// 2002
o91.which = 1;
// 2003
o91.type = "mouseover";
// 2004
o91.srcElement = void 0;
// 2005
o91.target = o87;
// 2018
o92 = {};
// 2020
o92.which = 1;
// 2021
o92.type = "mouseout";
// 2022
o92.srcElement = void 0;
// 2023
o92.target = o87;
// 2036
o93 = {};
// 2038
o93.which = 1;
// 2039
o93.type = "mouseover";
// 2040
o93.srcElement = void 0;
// 2041
o93.target = o75;
// 2048
f895948954_386.returns.push(0.2676769923608018);
// 2050
f895948954_386.returns.push(0.7605350764662566);
// 2055
o3.platform = "MacIntel";
// 2056
o3.appVersion = "5.0 (Macintosh)";
// 2059
o5.protocol = "http:";
// 2060
o5.host = "www.google.com";
// 2061
f895948954_386.returns.push(0.4998516345041988);
// 2062
f895948954_386.returns.push(0.12536944653545645);
// 2064
o94 = {};
// 2065
f895948954_0.returns.push(o94);
// 2066
o94.getTime = f895948954_388;
// undefined
o94 = null;
// 2067
f895948954_388.returns.push(1373476565325);
// 2068
f895948954_17.returns.push(7);
// 2070
o94 = {};
// 2071
f895948954_417.returns.push(o94);
// 2072
o95 = {};
// 2073
o94["0"] = o95;
// undefined
o94 = null;
// 2075
o94 = {};
// 2076
o6.style = o94;
// 2077
o94.opacity = "";
// undefined
o94 = null;
// 2079
f895948954_525 = function() { return f895948954_525.returns[f895948954_525.inst++]; };
f895948954_525.returns = [];
f895948954_525.inst = 0;
// 2080
o8.now = f895948954_525;
// 2083
f895948954_449.returns.push(undefined);
// 2087
o3.msPointerEnabled = void 0;
// 2089
o94 = {};
// 2090
f895948954_428.returns.push(o94);
// undefined
o94 = null;
// 2091
o1.setItem = f895948954_407;
// 2092
f895948954_407.returns.push(undefined);
// 2093
f895948954_527 = function() { return f895948954_527.returns[f895948954_527.inst++]; };
f895948954_527.returns = [];
f895948954_527.inst = 0;
// 2094
o1.removeItem = f895948954_527;
// 2095
f895948954_527.returns.push(undefined);
// 2096
o5.pathname = "/";
// 2097
f895948954_389.returns.push(1373476565406);
// 2098
o94 = {};
// 2099
f895948954_64.returns.push(o94);
// undefined
o94 = null;
// 2102
f895948954_393.returns.push(o34);
// 2104
o94 = {};
// 2105
f895948954_393.returns.push(o94);
// 2107
o96 = {};
// 2108
f895948954_393.returns.push(o96);
// 2112
f895948954_389.returns.push(1373476565410);
// 2116
o5.hostname = "www.google.com";
// 2118
o97 = {};
// 2119
f895948954_417.returns.push(o97);
// 2120
o97["0"] = o19;
// 2121
o19.action = "http://www.google.com/search";
// 2122
o19.className = "";
// 2123
f895948954_532 = function() { return f895948954_532.returns[f895948954_532.inst++]; };
f895948954_532.returns = [];
f895948954_532.inst = 0;
// 2124
o19.JSBNG__onsubmit = f895948954_532;
// 2125
o19.__handler = void 0;
// 2127
// 2128
// 2129
o97["1"] = void 0;
// undefined
o97 = null;
// 2132
f895948954_449.returns.push(undefined);
// 2135
o1.getItem = f895948954_406;
// 2136
f895948954_406.returns.push(null);
// 2138
f895948954_406.returns.push(null);
// 2140
f895948954_407.returns.push(undefined);
// 2142
f895948954_406.returns.push(null);
// 2144
f895948954_407.returns.push(undefined);
// 2146
f895948954_406.returns.push(null);
// 2148
f895948954_407.returns.push(undefined);
// 2150
f895948954_407.returns.push(undefined);
// 2152
f895948954_406.returns.push(null);
// 2154
f895948954_406.returns.push("[]");
// 2156
f895948954_407.returns.push(undefined);
// 2158
f895948954_406.returns.push("[]");
// 2160
f895948954_407.returns.push(undefined);
// 2162
f895948954_406.returns.push("[]");
// 2164
f895948954_407.returns.push(undefined);
// 2166
f895948954_407.returns.push(undefined);
// 2168
f895948954_407.returns.push(undefined);
// 2170
f895948954_406.returns.push("\"uJbdUZ3TOOKQyAHtz4D4Cg\"");
// 2172
f895948954_406.returns.push("[]");
// 2174
f895948954_406.returns.push("[]");
// 2176
f895948954_406.returns.push("[]");
// 2177
o0.title = "Google";
// 2179
o16.className = "hp";
// 2181
f895948954_393.returns.push(o34);
// 2182
o34.innerHTML = "<center><span id=\"prt\" style=\"display:block\"><div style=\"position: relative;\"><style>.pmoabs{background-color:#fff;border:1px solid #E5E5E5;color:#666;font-size:13px;padding-bottom:20px;position:absolute;right:2px;top:3px;z-index:986}.kd-button-submit{border:1px solid #3079ed;background-color:#4d90fe;background-image:-webkit-gradient(linear,left top,left bottom,from(#4d90fe),to(#4787ed));background-image: -webkit-linear-gradient(top,#4d90fe,#4787ed);background-image: -moz-linear-gradient(top,#4d90fe,#4787ed);background-image: -ms-linear-gradient(top,#4d90fe,#4787ed);background-image: -o-linear-gradient(top,#4d90fe,#4787ed);background-image: linear-gradient(top,#4d90fe,#4787ed);filter:progid:DXImageTransform.Microsoft.gradient(startColorStr='#4d90fe',EndColorStr='#4787ed')}.kd-button-submit:hover{border:1px solid #2f5bb7;background-color:#357ae8;background-image:-webkit-gradient(linear,left top,left bottom,from(#4d90fe),to(#357ae8));background-image: -webkit-linear-gradient(top,#4d90fe,#357ae8);background-image: -moz-linear-gradient(top,#4d90fe,#357ae8);background-image: -ms-linear-gradient(top,#4d90fe,#357ae8);background-image: -o-linear-gradient(top,#4d90fe,#357ae8);background-image: linear-gradient(top,#4d90fe,#357ae8);filter:progid:DXImageTransform.Microsoft.gradient(startColorStr='#4d90fe',EndColorStr='#357ae8')}.kd-button-submit:active{-webkit-box-shadow:inset 0 1px 2px rgba(0,0,0,0.3);-moz-box-shadow:inset 0 1px 2px rgba(0,0,0,0.3);box-shadow:inset 0 1px 2px rgba(0,0,0,0.3)}.xbtn{color:#999;cursor:pointer;font-size:23px;line-height:5px;padding-top:5px}.padi{padding:0 8px 0 10px}.padt{padding:5px 20px 0 0;color:#444}.pads{text-align:left}#pmolnk{border-radius:2px;-moz-border-radius:2px;-webkit-border-radius:2px}#pmolnk a{color:#fff;display:inline-block;font-weight:bold;padding:5px 20px;text-decoration:none;white-space:nowrap}</style> <div class=\"pmoabs\" id=\"pmocntr2\" style=\"right: 2px; top: 20px;\"> <table border=\"0\"> <tbody><tr> <td colspan=\"2\"> <script type=\"text/javascript\">try {\n    ((JSBNG_Record.scriptLoad)((\"function eb9de603517591e48f057c7e6086bbd305cb1ab63(event) {\\u000a    ((google.promos && google.promos.toast) && google.promos.toast.cpc());\\u000a};\"), (\"s8a306005c8afd0845b57355205e4d809c13bbef8\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    function eb9de603517591e48f057c7e6086bbd305cb1ab63(JSBNG__event) {\n        if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n            return ((JSBNG_Record.eventCall)((arguments.callee), (\"s8a306005c8afd0845b57355205e4d809c13bbef8_0\"), (s8a306005c8afd0845b57355205e4d809c13bbef8_0_instance), (this), (arguments)))\n        };\n        (null);\n        (((((JSBNG_Record.get)(google, (\"promos\")))[(\"promos\")]) && (((JSBNG_Record.get)((((JSBNG_Record.get)(google, (\"promos\")))[(\"promos\")]), (\"toast\")))[(\"toast\")])) && (((JSBNG_Record.get)((((JSBNG_Record.get)((((JSBNG_Record.get)(google, (\"promos\")))[(\"promos\")]), (\"toast\")))[(\"toast\")]), (\"cpc\")))[(\"cpc\")])());\n    };\n    var s8a306005c8afd0845b57355205e4d809c13bbef8_0_instance;\n    ((s8a306005c8afd0845b57355205e4d809c13bbef8_0_instance) = ((JSBNG_Record.eventInstance)((\"s8a306005c8afd0845b57355205e4d809c13bbef8_0\"))));\n    ((JSBNG_Record.markFunction)((eb9de603517591e48f057c7e6086bbd305cb1ab63)));\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};</script><div class=\"xbtn\" onclick=\"return eb9de603517591e48f057c7e6086bbd305cb1ab63.call(this, event);\" style=\"float:right\">×</div> </td> </tr> <tr> <td class=\"padi\" rowspan=\"2\"> <img src=\"/images/icons/product/chrome-48.png\"> </td> <td class=\"pads\">A faster way to browse the web</td> </tr> <tr> <td class=\"padt\"> <div class=\"kd-button-submit\" id=\"pmolnk\"> <script type=\"text/javascript\">try {\n    ((JSBNG_Record.scriptLoad)((\"function ecb5dd2f554ffdaa5dbca76b6834768842fd1de9a(event) {\\u000a    ((google.promos && google.promos.toast) && google.promos.toast.cl());\\u000a};\"), (\"s79d6c8ae337e260bda4e0343b5581cbae53a6f79\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    function ecb5dd2f554ffdaa5dbca76b6834768842fd1de9a(JSBNG__event) {\n        if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n            return ((JSBNG_Record.eventCall)((arguments.callee), (\"s79d6c8ae337e260bda4e0343b5581cbae53a6f79_0\"), (s79d6c8ae337e260bda4e0343b5581cbae53a6f79_0_instance), (this), (arguments)))\n        };\n        (null);\n        (((((JSBNG_Record.get)(google, (\"promos\")))[(\"promos\")]) && (((JSBNG_Record.get)((((JSBNG_Record.get)(google, (\"promos\")))[(\"promos\")]), (\"toast\")))[(\"toast\")])) && (((JSBNG_Record.get)((((JSBNG_Record.get)((((JSBNG_Record.get)(google, (\"promos\")))[(\"promos\")]), (\"toast\")))[(\"toast\")]), (\"cl\")))[(\"cl\")])());\n    };\n    var s79d6c8ae337e260bda4e0343b5581cbae53a6f79_0_instance;\n    ((s79d6c8ae337e260bda4e0343b5581cbae53a6f79_0_instance) = ((JSBNG_Record.eventInstance)((\"s79d6c8ae337e260bda4e0343b5581cbae53a6f79_0\"))));\n    ((JSBNG_Record.markFunction)((ecb5dd2f554ffdaa5dbca76b6834768842fd1de9a)));\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};</script><a href=\"/chrome/index.html?hl=en&amp;brand=CHNG&amp;utm_source=en-hpp&amp;utm_medium=hpp&amp;utm_campaign=en\" onclick=\"return ecb5dd2f554ffdaa5dbca76b6834768842fd1de9a.call(this, event);\">Install Google Chrome</a> </div> </td> </tr> </tbody></table> </div> <script type=\"text/javascript\">try {\n    ((JSBNG_Record.scriptLoad)((\"(function() {\\u000a    var a = {\\u000a        v: \\\"a\\\",\\u000a        w: \\\"c\\\",\\u000a        i: \\\"d\\\",\\u000a        k: \\\"h\\\",\\u000a        g: \\\"i\\\",\\u000a        K: \\\"n\\\",\\u000a        Q: \\\"x\\\",\\u000a        H: \\\"ma\\\",\\u000a        I: \\\"mc\\\",\\u000a        J: \\\"mi\\\",\\u000a        A: \\\"pa\\\",\\u000a        B: \\\"pc\\\",\\u000a        D: \\\"pi\\\",\\u000a        G: \\\"pn\\\",\\u000a        F: \\\"px\\\",\\u000a        C: \\\"pd\\\",\\u000a        L: \\\"gpa\\\",\\u000a        N: \\\"gpi\\\",\\u000a        O: \\\"gpn\\\",\\u000a        P: \\\"gpx\\\",\\u000a        M: \\\"gpd\\\"\\u000a    };\\u000a    var c = {\\u000a        o: \\\"hplogo\\\",\\u000a        s: \\\"pmocntr2\\\"\\u000a    }, e, g, k = document.getElementById(c.s);\\u000a    google.promos = (google.promos || {\\u000a    });\\u000a    google.promos.toast = (google.promos.toast || {\\u000a    });\\u000a    function l(b) {\\u000a        (k && (k.style.display = (b ? \\\"\\\" : \\\"none\\\"), (k.parentNode && (k.parentNode.style.position = (b ? \\\"relative\\\" : \\\"\\\")))));\\u000a    };\\u000a    function m(b) {\\u000a        try {\\u000a            if ((((k && b) && b.es) && b.es.m)) {\\u000a                var d = (window.gbar.rtl(document.body) ? \\\"left\\\" : \\\"right\\\");\\u000a                k.style[d] = (((b.es.m - 16) + 2) + \\\"px\\\");\\u000a                k.style.top = \\\"20px\\\";\\u000a            }\\u000a        ;\\u000a        } catch (f) {\\u000a            google.ml(f, !1, {\\u000a                cause: (e + \\\"_PT\\\")\\u000a            });\\u000a        };\\u000a    };\\u000a    google.promos.toast.cl = function() {\\u000a        try {\\u000a            window.gbar.up.sl(g, e, a.k, void 0, 1);\\u000a        } catch (b) {\\u000a            google.ml(b, !1, {\\u000a                cause: (e + \\\"_CL\\\")\\u000a            });\\u000a        };\\u000a    };\\u000a    google.promos.toast.cpc = function() {\\u000a        try {\\u000a            (k && (l(!1), window.gbar.up.spd(k, c.a, 1, !0), window.gbar.up.sl(g, e, a.i, void 0, 1)));\\u000a        } catch (b) {\\u000a            google.ml(b, !1, {\\u000a                cause: (e + \\\"_CPC\\\")\\u000a            });\\u000a        };\\u000a    };\\u000a    google.promos.toast.hideOnSmallWindow_ = function() {\\u000a        try {\\u000a            if (k) {\\u000a                var b = 276, d = document.getElementById(c.o);\\u000a                (d && (b = Math.max(b, d.offsetWidth)));\\u000a                var f = (parseInt(k.style.right, 10) || 0);\\u000a                k.style.visibility = ((((2 * ((k.offsetWidth + f))) + b) \\u003E document.body.clientWidth) ? \\\"hidden\\\" : \\\"\\\");\\u000a            }\\u000a        ;\\u000a        } catch (h) {\\u000a            google.ml(h, !1, {\\u000a                cause: (e + \\\"_HOSW\\\")\\u000a            });\\u000a        };\\u000a    };\\u000a    function q() {\\u000a        var b = [\\\"gpd\\\",\\\"spd\\\",\\\"aeh\\\",\\\"sl\\\",];\\u000a        if ((!window.gbar || !window.gbar.up)) {\\u000a            return !1\\u000a        };\\u000a        for (var d = 0, f; f = b[d]; d++) {\\u000a            if (!((f in window.gbar.up))) {\\u000a                return !1\\u000a            };\\u000a        };\\u000a        return !0;\\u000a    };\\u000a    google.promos.toast.init = function(b, d, f, h, n) {\\u000a        try {\\u000a            if (!q()) {\\u000a                google.ml(Error(\\\"apa\\\"), !1, {\\u000a                    cause: (e + \\\"_INIT\\\")\\u000a                });\\u000a            } else {\\u000a                if (k) {\\u000a                    window.gbar.up.aeh(window, \\\"resize\\\", google.promos.toast.hideOnSmallWindow_);\\u000a                    window.lol = google.promos.toast.hideOnSmallWindow_;\\u000a                    c.d = ((\\\"toast_count_\\\" + d) + ((h ? (\\\"_\\\" + h) : \\\"\\\")));\\u000a                    c.a = ((\\\"toast_dp_\\\" + d) + ((n ? (\\\"_\\\" + n) : \\\"\\\")));\\u000a                    e = f;\\u000a                    g = b;\\u000a                    var p = (window.gbar.up.gpd(k, c.d, !0) || 0);\\u000a                    (((window.gbar.up.gpd(k, c.a, !0) || (25 \\u003C p)) || (k.currentStyle && (\\\"absolute\\\" != k.currentStyle.position))) ? l(!1) : (window.gbar.up.spd(k, c.d, ++p, !0), (window.gbar.elr && m(window.gbar.elr())), (window.gbar.elc && window.gbar.elc(m)), l(!0), window.gbar.up.sl(g, e, a.g)));\\u000a                }\\u000a            \\u000a            };\\u000a        } catch (r) {\\u000a            google.ml(r, !1, {\\u000a                cause: (e + \\\"_INIT\\\")\\u000a            });\\u000a        };\\u000a    };\\u000a})();\"), (\"s92b498f8a609c7ed181fae42a6a1eaa8de9f2f02\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    ((function() {\n        var s92b498f8a609c7ed181fae42a6a1eaa8de9f2f02_0_instance;\n        ((s92b498f8a609c7ed181fae42a6a1eaa8de9f2f02_0_instance) = ((JSBNG_Record.eventInstance)((\"s92b498f8a609c7ed181fae42a6a1eaa8de9f2f02_0\"))));\n        return ((JSBNG_Record.markFunction)((function() {\n            if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                return ((JSBNG_Record.eventCall)((arguments.callee), (\"s92b498f8a609c7ed181fae42a6a1eaa8de9f2f02_0\"), (s92b498f8a609c7ed181fae42a6a1eaa8de9f2f02_0_instance), (this), (arguments)))\n            };\n            (null);\n            var a = {\n                v: \"a\",\n                w: \"c\",\n                i: \"d\",\n                k: \"h\",\n                g: \"i\",\n                K: \"n\",\n                Q: \"x\",\n                H: \"ma\",\n                I: \"mc\",\n                J: \"mi\",\n                A: \"pa\",\n                B: \"pc\",\n                D: \"pi\",\n                G: \"pn\",\n                F: \"px\",\n                C: \"pd\",\n                L: \"gpa\",\n                N: \"gpi\",\n                O: \"gpn\",\n                P: \"gpx\",\n                M: \"gpd\"\n            };\n            var c = {\n                o: \"hplogo\",\n                s: \"pmocntr2\"\n            }, e, g, k = (((JSBNG_Record.get)(JSBNG__document, (\"getElementById\")))[(\"getElementById\")])((((JSBNG_Record.get)(c, (\"s\")))[(\"s\")]));\n            ((JSBNG_Record.set)(google, (\"promos\"), ((((JSBNG_Record.get)(google, (\"promos\")))[(\"promos\")]) || {\n            })));\n            ((JSBNG_Record.set)((((JSBNG_Record.get)(google, (\"promos\")))[(\"promos\")]), (\"toast\"), ((((JSBNG_Record.get)((((JSBNG_Record.get)(google, (\"promos\")))[(\"promos\")]), (\"toast\")))[(\"toast\")]) || {\n            })));\n            function l(b) {\n                if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                    return ((JSBNG_Record.eventCall)((arguments.callee), (\"s92b498f8a609c7ed181fae42a6a1eaa8de9f2f02_1\"), (s92b498f8a609c7ed181fae42a6a1eaa8de9f2f02_1_instance), (this), (arguments)))\n                };\n                (null);\n                (k && (((JSBNG_Record.set)((((JSBNG_Record.get)(k, (\"style\")))[(\"style\")]), (\"display\"), (b ? \"\" : \"none\"))), ((((JSBNG_Record.get)(k, (\"parentNode\")))[(\"parentNode\")]) && ((JSBNG_Record.set)((((JSBNG_Record.get)((((JSBNG_Record.get)(k, (\"parentNode\")))[(\"parentNode\")]), (\"style\")))[(\"style\")]), (\"position\"), (b ? \"relative\" : \"\"))))));\n            };\n            var s92b498f8a609c7ed181fae42a6a1eaa8de9f2f02_1_instance;\n            ((s92b498f8a609c7ed181fae42a6a1eaa8de9f2f02_1_instance) = ((JSBNG_Record.eventInstance)((\"s92b498f8a609c7ed181fae42a6a1eaa8de9f2f02_1\"))));\n            ((JSBNG_Record.markFunction)((l)));\n            function m(b) {\n                if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                    return ((JSBNG_Record.eventCall)((arguments.callee), (\"s92b498f8a609c7ed181fae42a6a1eaa8de9f2f02_2\"), (s92b498f8a609c7ed181fae42a6a1eaa8de9f2f02_2_instance), (this), (arguments)))\n                };\n                (null);\n                try {\n                    if ((((k && b) && (((JSBNG_Record.get)(b, (\"es\")))[(\"es\")])) && (((JSBNG_Record.get)((((JSBNG_Record.get)(b, (\"es\")))[(\"es\")]), (\"m\")))[(\"m\")]))) {\n                        var d = ((((JSBNG_Record.get)((((JSBNG_Record.get)(window, (\"gbar\")))[(\"gbar\")]), (\"rtl\")))[(\"rtl\")])((((JSBNG_Record.get)(JSBNG__document, (\"body\")))[(\"body\")])) ? \"left\" : \"right\");\n                        ((JSBNG_Record.set)((((JSBNG_Record.get)(k, (\"style\")))[(\"style\")]), d, ((((((JSBNG_Record.get)((((JSBNG_Record.get)(b, (\"es\")))[(\"es\")]), (\"m\")))[(\"m\")]) - 16) + 2) + \"px\")));\n                        ((JSBNG_Record.set)((((JSBNG_Record.get)(k, (\"style\")))[(\"style\")]), (\"JSBNG__top\"), \"20px\"));\n                    }\n                ;\n                } catch (f) {\n                    (((JSBNG_Record.get)(google, (\"ml\")))[(\"ml\")])(f, !1, {\n                        cause: (e + \"_PT\")\n                    });\n                };\n            };\n            var s92b498f8a609c7ed181fae42a6a1eaa8de9f2f02_2_instance;\n            ((s92b498f8a609c7ed181fae42a6a1eaa8de9f2f02_2_instance) = ((JSBNG_Record.eventInstance)((\"s92b498f8a609c7ed181fae42a6a1eaa8de9f2f02_2\"))));\n            ((JSBNG_Record.markFunction)((m)));\n            ((JSBNG_Record.set)((((JSBNG_Record.get)((((JSBNG_Record.get)(google, (\"promos\")))[(\"promos\")]), (\"toast\")))[(\"toast\")]), (\"cl\"), ((function() {\n                var s92b498f8a609c7ed181fae42a6a1eaa8de9f2f02_3_instance;\n                ((s92b498f8a609c7ed181fae42a6a1eaa8de9f2f02_3_instance) = ((JSBNG_Record.eventInstance)((\"s92b498f8a609c7ed181fae42a6a1eaa8de9f2f02_3\"))));\n                return ((JSBNG_Record.markFunction)((function() {\n                    if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                        return ((JSBNG_Record.eventCall)((arguments.callee), (\"s92b498f8a609c7ed181fae42a6a1eaa8de9f2f02_3\"), (s92b498f8a609c7ed181fae42a6a1eaa8de9f2f02_3_instance), (this), (arguments)))\n                    };\n                    (null);\n                    try {\n                        (((JSBNG_Record.get)((((JSBNG_Record.get)((((JSBNG_Record.get)(window, (\"gbar\")))[(\"gbar\")]), (\"up\")))[(\"up\")]), (\"sl\")))[(\"sl\")])(g, e, (((JSBNG_Record.get)(a, (\"k\")))[(\"k\")]), void 0, 1);\n                    } catch (b) {\n                        (((JSBNG_Record.get)(google, (\"ml\")))[(\"ml\")])(b, !1, {\n                            cause: (e + \"_CL\")\n                        });\n                    };\n                })));\n            })())));\n            ((JSBNG_Record.set)((((JSBNG_Record.get)((((JSBNG_Record.get)(google, (\"promos\")))[(\"promos\")]), (\"toast\")))[(\"toast\")]), (\"cpc\"), ((function() {\n                var s92b498f8a609c7ed181fae42a6a1eaa8de9f2f02_4_instance;\n                ((s92b498f8a609c7ed181fae42a6a1eaa8de9f2f02_4_instance) = ((JSBNG_Record.eventInstance)((\"s92b498f8a609c7ed181fae42a6a1eaa8de9f2f02_4\"))));\n                return ((JSBNG_Record.markFunction)((function() {\n                    if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                        return ((JSBNG_Record.eventCall)((arguments.callee), (\"s92b498f8a609c7ed181fae42a6a1eaa8de9f2f02_4\"), (s92b498f8a609c7ed181fae42a6a1eaa8de9f2f02_4_instance), (this), (arguments)))\n                    };\n                    (null);\n                    try {\n                        (k && (l(!1), (((JSBNG_Record.get)((((JSBNG_Record.get)((((JSBNG_Record.get)(window, (\"gbar\")))[(\"gbar\")]), (\"up\")))[(\"up\")]), (\"spd\")))[(\"spd\")])(k, (((JSBNG_Record.get)(c, (\"a\")))[(\"a\")]), 1, !0), (((JSBNG_Record.get)((((JSBNG_Record.get)((((JSBNG_Record.get)(window, (\"gbar\")))[(\"gbar\")]), (\"up\")))[(\"up\")]), (\"sl\")))[(\"sl\")])(g, e, (((JSBNG_Record.get)(a, (\"i\")))[(\"i\")]), void 0, 1)));\n                    } catch (b) {\n                        (((JSBNG_Record.get)(google, (\"ml\")))[(\"ml\")])(b, !1, {\n                            cause: (e + \"_CPC\")\n                        });\n                    };\n                })));\n            })())));\n            ((JSBNG_Record.set)((((JSBNG_Record.get)((((JSBNG_Record.get)(google, (\"promos\")))[(\"promos\")]), (\"toast\")))[(\"toast\")]), (\"hideOnSmallWindow_\"), ((function() {\n                var s92b498f8a609c7ed181fae42a6a1eaa8de9f2f02_5_instance;\n                ((s92b498f8a609c7ed181fae42a6a1eaa8de9f2f02_5_instance) = ((JSBNG_Record.eventInstance)((\"s92b498f8a609c7ed181fae42a6a1eaa8de9f2f02_5\"))));\n                return ((JSBNG_Record.markFunction)((function() {\n                    if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                        return ((JSBNG_Record.eventCall)((arguments.callee), (\"s92b498f8a609c7ed181fae42a6a1eaa8de9f2f02_5\"), (s92b498f8a609c7ed181fae42a6a1eaa8de9f2f02_5_instance), (this), (arguments)))\n                    };\n                    (null);\n                    try {\n                        if (k) {\n                            var b = 276, d = (((JSBNG_Record.get)(JSBNG__document, (\"getElementById\")))[(\"getElementById\")])((((JSBNG_Record.get)(c, (\"o\")))[(\"o\")]));\n                            (d && (b = (((JSBNG_Record.get)(Math, (\"max\")))[(\"max\")])(b, (((JSBNG_Record.get)(d, (\"offsetWidth\")))[(\"offsetWidth\")]))));\n                            var f = (parseInt((((JSBNG_Record.get)((((JSBNG_Record.get)(k, (\"style\")))[(\"style\")]), (\"right\")))[(\"right\")]), 10) || 0);\n                            ((JSBNG_Record.set)((((JSBNG_Record.get)(k, (\"style\")))[(\"style\")]), (\"visibility\"), ((((2 * (((((JSBNG_Record.get)(k, (\"offsetWidth\")))[(\"offsetWidth\")]) + f))) + b) > (((JSBNG_Record.get)((((JSBNG_Record.get)(JSBNG__document, (\"body\")))[(\"body\")]), (\"clientWidth\")))[(\"clientWidth\")])) ? \"hidden\" : \"\")));\n                        }\n                    ;\n                    } catch (h) {\n                        (((JSBNG_Record.get)(google, (\"ml\")))[(\"ml\")])(h, !1, {\n                            cause: (e + \"_HOSW\")\n                        });\n                    };\n                })));\n            })())));\n            function q() {\n                if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                    return ((JSBNG_Record.eventCall)((arguments.callee), (\"s92b498f8a609c7ed181fae42a6a1eaa8de9f2f02_6\"), (s92b498f8a609c7ed181fae42a6a1eaa8de9f2f02_6_instance), (this), (arguments)))\n                };\n                (null);\n                var b = [\"gpd\",\"spd\",\"aeh\",\"sl\",];\n                if ((!(((JSBNG_Record.get)(window, (\"gbar\")))[(\"gbar\")]) || !(((JSBNG_Record.get)((((JSBNG_Record.get)(window, (\"gbar\")))[(\"gbar\")]), (\"up\")))[(\"up\")]))) {\n                    return !1\n                };\n                for (var d = 0, f; f = (((JSBNG_Record.get)(b, d))[d]); d++) {\n                    if (!((f in ((JSBNG_Record.getUnwrapped)(((((JSBNG_Record.get)((((JSBNG_Record.get)(window, (\"gbar\")))[(\"gbar\")]), (\"up\")))[(\"up\")]))))))) {\n                        return !1\n                    };\n                };\n                return !0;\n            };\n            var s92b498f8a609c7ed181fae42a6a1eaa8de9f2f02_6_instance;\n            ((s92b498f8a609c7ed181fae42a6a1eaa8de9f2f02_6_instance) = ((JSBNG_Record.eventInstance)((\"s92b498f8a609c7ed181fae42a6a1eaa8de9f2f02_6\"))));\n            ((JSBNG_Record.markFunction)((q)));\n            ((JSBNG_Record.set)((((JSBNG_Record.get)((((JSBNG_Record.get)(google, (\"promos\")))[(\"promos\")]), (\"toast\")))[(\"toast\")]), (\"init\"), ((function() {\n                var s92b498f8a609c7ed181fae42a6a1eaa8de9f2f02_7_instance;\n                ((s92b498f8a609c7ed181fae42a6a1eaa8de9f2f02_7_instance) = ((JSBNG_Record.eventInstance)((\"s92b498f8a609c7ed181fae42a6a1eaa8de9f2f02_7\"))));\n                return ((JSBNG_Record.markFunction)((function(b, d, f, h, n) {\n                    if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                        return ((JSBNG_Record.eventCall)((arguments.callee), (\"s92b498f8a609c7ed181fae42a6a1eaa8de9f2f02_7\"), (s92b498f8a609c7ed181fae42a6a1eaa8de9f2f02_7_instance), (this), (arguments)))\n                    };\n                    (null);\n                    try {\n                        if (!q()) {\n                            (((JSBNG_Record.get)(google, (\"ml\")))[(\"ml\")])(Error(\"apa\"), !1, {\n                                cause: (e + \"_INIT\")\n                            });\n                        } else {\n                            if (k) {\n                                (((JSBNG_Record.get)((((JSBNG_Record.get)((((JSBNG_Record.get)(window, (\"gbar\")))[(\"gbar\")]), (\"up\")))[(\"up\")]), (\"aeh\")))[(\"aeh\")])(window, \"resize\", (((JSBNG_Record.get)((((JSBNG_Record.get)((((JSBNG_Record.get)(google, (\"promos\")))[(\"promos\")]), (\"toast\")))[(\"toast\")]), (\"hideOnSmallWindow_\")))[(\"hideOnSmallWindow_\")]));\n                                ((JSBNG_Record.set)(window, (\"lol\"), (((JSBNG_Record.get)((((JSBNG_Record.get)((((JSBNG_Record.get)(google, (\"promos\")))[(\"promos\")]), (\"toast\")))[(\"toast\")]), (\"hideOnSmallWindow_\")))[(\"hideOnSmallWindow_\")])));\n                                ((JSBNG_Record.set)(c, (\"d\"), ((\"toast_count_\" + d) + ((h ? (\"_\" + h) : \"\")))));\n                                ((JSBNG_Record.set)(c, (\"a\"), ((\"toast_dp_\" + d) + ((n ? (\"_\" + n) : \"\")))));\n                                e = f;\n                                g = b;\n                                var p = ((((JSBNG_Record.get)((((JSBNG_Record.get)((((JSBNG_Record.get)(window, (\"gbar\")))[(\"gbar\")]), (\"up\")))[(\"up\")]), (\"gpd\")))[(\"gpd\")])(k, (((JSBNG_Record.get)(c, (\"d\")))[(\"d\")]), !0) || 0);\n                                ((((((JSBNG_Record.get)((((JSBNG_Record.get)((((JSBNG_Record.get)(window, (\"gbar\")))[(\"gbar\")]), (\"up\")))[(\"up\")]), (\"gpd\")))[(\"gpd\")])(k, (((JSBNG_Record.get)(c, (\"a\")))[(\"a\")]), !0) || (25 < p)) || ((((JSBNG_Record.get)(k, (\"currentStyle\")))[(\"currentStyle\")]) && (\"absolute\" != (((JSBNG_Record.get)((((JSBNG_Record.get)(k, (\"currentStyle\")))[(\"currentStyle\")]), (\"position\")))[(\"position\")])))) ? l(!1) : ((((JSBNG_Record.get)((((JSBNG_Record.get)((((JSBNG_Record.get)(window, (\"gbar\")))[(\"gbar\")]), (\"up\")))[(\"up\")]), (\"spd\")))[(\"spd\")])(k, (((JSBNG_Record.get)(c, (\"d\")))[(\"d\")]), ++p, !0), ((((JSBNG_Record.get)((((JSBNG_Record.get)(window, (\"gbar\")))[(\"gbar\")]), (\"elr\")))[(\"elr\")]) && m((((JSBNG_Record.get)((((JSBNG_Record.get)(window, (\"gbar\")))[(\"gbar\")]), (\"elr\")))[(\"elr\")])())), ((((JSBNG_Record.get)((((JSBNG_Record.get)(window, (\"gbar\")))[(\"gbar\")]), (\"elc\")))[(\"elc\")]) && (((JSBNG_Record.get)((((JSBNG_Record.get)(window, (\"gbar\")))[(\"gbar\")]), (\"elc\")))[(\"elc\")])(m)), l(!0), (((JSBNG_Record.get)((((JSBNG_Record.get)((((JSBNG_Record.get)(window, (\"gbar\")))[(\"gbar\")]), (\"up\")))[(\"up\")]), (\"sl\")))[(\"sl\")])(g, e, (((JSBNG_Record.get)(a, (\"g\")))[(\"g\")]))));\n                            }\n                        \n                        };\n                    } catch (r) {\n                        (((JSBNG_Record.get)(google, (\"ml\")))[(\"ml\")])(r, !1, {\n                            cause: (e + \"_INIT\")\n                        });\n                    };\n                })));\n            })())));\n        })));\n    })())();\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};</script> <script type=\"text/javascript\">try {\n    ((JSBNG_Record.scriptLoad)((\"(function() {\\u000a    var sourceWebappPromoID = 144002;\\u000a    var sourceWebappGroupID = 5;\\u000a    var payloadType = 5;\\u000a    (((window.gbar && gbar.up) && gbar.up.r) && gbar.up.r(payloadType, function(show) {\\u000a        if (show) {\\u000a            google.promos.toast.init(sourceWebappPromoID, sourceWebappGroupID, payloadType, \\\"0612\\\");\\u000a        }\\u000a    ;\\u000a    }));\\u000a})();\"), (\"s0790de9086ee4514eb01e2ecc0cc84a03180aae0\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    ((function() {\n        var s0790de9086ee4514eb01e2ecc0cc84a03180aae0_0_instance;\n        ((s0790de9086ee4514eb01e2ecc0cc84a03180aae0_0_instance) = ((JSBNG_Record.eventInstance)((\"s0790de9086ee4514eb01e2ecc0cc84a03180aae0_0\"))));\n        return ((JSBNG_Record.markFunction)((function() {\n            if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                return ((JSBNG_Record.eventCall)((arguments.callee), (\"s0790de9086ee4514eb01e2ecc0cc84a03180aae0_0\"), (s0790de9086ee4514eb01e2ecc0cc84a03180aae0_0_instance), (this), (arguments)))\n            };\n            (null);\n            var sourceWebappPromoID = 144002;\n            var sourceWebappGroupID = 5;\n            var payloadType = 5;\n            ((((((JSBNG_Record.get)(window, (\"gbar\")))[(\"gbar\")]) && (((JSBNG_Record.get)(gbar, (\"up\")))[(\"up\")])) && (((JSBNG_Record.get)((((JSBNG_Record.get)(gbar, (\"up\")))[(\"up\")]), (\"r\")))[(\"r\")])) && (((JSBNG_Record.get)((((JSBNG_Record.get)(gbar, (\"up\")))[(\"up\")]), (\"r\")))[(\"r\")])(payloadType, ((function() {\n                var s0790de9086ee4514eb01e2ecc0cc84a03180aae0_1_instance;\n                ((s0790de9086ee4514eb01e2ecc0cc84a03180aae0_1_instance) = ((JSBNG_Record.eventInstance)((\"s0790de9086ee4514eb01e2ecc0cc84a03180aae0_1\"))));\n                return ((JSBNG_Record.markFunction)((function(show) {\n                    if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                        return ((JSBNG_Record.eventCall)((arguments.callee), (\"s0790de9086ee4514eb01e2ecc0cc84a03180aae0_1\"), (s0790de9086ee4514eb01e2ecc0cc84a03180aae0_1_instance), (this), (arguments)))\n                    };\n                    (null);\n                    if (show) {\n                        (((JSBNG_Record.get)((((JSBNG_Record.get)((((JSBNG_Record.get)(google, (\"promos\")))[(\"promos\")]), (\"toast\")))[(\"toast\")]), (\"init\")))[(\"init\")])(sourceWebappPromoID, sourceWebappGroupID, payloadType, \"0612\");\n                    }\n                    ;\n                })));\n            })())));\n        })));\n    })())();\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};</script> </div></span><div id=\"lga\" style=\"height:231px;margin-top:-22px\"><script type=\"text/javascript\">try {\n    ((JSBNG_Record.scriptLoad)((\"function eef50192d0e0654bc148db359edb6aaecd1ea3ba9(event) {\\u000a    (window.lol && lol());\\u000a};\"), (\"s05f10c3c91831d535c6322def5159ad3793811b2\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    function eef50192d0e0654bc148db359edb6aaecd1ea3ba9(JSBNG__event) {\n        if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n            return ((JSBNG_Record.eventCall)((arguments.callee), (\"s05f10c3c91831d535c6322def5159ad3793811b2_0\"), (s05f10c3c91831d535c6322def5159ad3793811b2_0_instance), (this), (arguments)))\n        };\n        (null);\n        ((((JSBNG_Record.get)(window, (\"lol\")))[(\"lol\")]) && lol());\n    };\n    var s05f10c3c91831d535c6322def5159ad3793811b2_0_instance;\n    ((s05f10c3c91831d535c6322def5159ad3793811b2_0_instance) = ((JSBNG_Record.eventInstance)((\"s05f10c3c91831d535c6322def5159ad3793811b2_0\"))));\n    ((JSBNG_Record.markFunction)((eef50192d0e0654bc148db359edb6aaecd1ea3ba9)));\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};</script><img alt=\"Google\" src=\"/images/srpr/logo4w.png\" id=\"hplogo\" onload=\"return eef50192d0e0654bc148db359edb6aaecd1ea3ba9.call(this, event);\" style=\"padding-top:112px\" height=\"95\" width=\"275\"></div><div style=\"height:102px\"></div><div id=\"prm-pt\" style=\"font-size:83%;min-height:3.5em\"><br><script>try {\n    ((JSBNG_Record.scriptLoad)((\"(((window.gbar && gbar.up) && gbar.up.tp) && gbar.up.tp());\"), (\"s36fb77466464abfc801f386ef29c518bdb3e4b10\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    ((((((JSBNG_Record.get)(window, (\"gbar\")))[(\"gbar\")]) && (((JSBNG_Record.get)(gbar, (\"up\")))[(\"up\")])) && (((JSBNG_Record.get)((((JSBNG_Record.get)(gbar, (\"up\")))[(\"up\")]), (\"tp\")))[(\"tp\")])) && (((JSBNG_Record.get)((((JSBNG_Record.get)(gbar, (\"up\")))[(\"up\")]), (\"tp\")))[(\"tp\")])());\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};</script></div></center>";
// 2184
f895948954_393.returns.push(o94);
// 2185
o94.innerHTML = "<div><div id=\"ftby\"><div id=\"fll\"><div id=\"flls\"><a href=\"/intl/en/ads/\">Advertising&nbsp;Programs</a>‎<a href=\"/services/\">Business Solutions</a>‎<a href=\"/intl/en/policies/\">Privacy &amp; Terms</a>‎</div><div id=\"flrs\"><a href=\"http://jsbngssl.plus.google.com/116899029375914044550\" rel=\"publisher\">+Google</a>‎<a href=\"/intl/en/about.html\">About Google</a>‎</div></div><div id=\"flci\"></div></div></div>";
// undefined
o94 = null;
// 2187
f895948954_393.returns.push(o96);
// 2188
o96.innerHTML = "<script>try {\n    ((JSBNG_Record.scriptLoad)((\"if (google.y) {\\u000a    google.y.first = [];\\u000a};\\u000a(function() {\\u000a    function b(a) {\\u000a        window.setTimeout(function() {\\u000a            var c = document.createElement(\\\"script\\\");\\u000a            c.src = a;\\u000a            document.getElementById(\\\"xjsd\\\").appendChild(c);\\u000a        }, 0);\\u000a    };\\u000a    google.dljp = function(a) {\\u000a        (google.xjsi || (google.xjsu = a, b(a)));\\u000a    };\\u000a    google.dlj = b;\\u000a})();\\u000aif (!google.xjs) {\\u000a    window._ = (window._ || {\\u000a    });\\u000a    window._._DumpException = function(e) {\\u000a        throw e;\\u000a    };\\u000a    if ((google.timers && google.timers.load.t)) {\\u000a        google.timers.load.t.xjsls = new Date().getTime();\\u000a    }\\u000a;\\u000a    google.dljp(\\\"/xjs/_/js/k=xjs.s.en_US.l3EGKs4A4V8.O/m=c,sb,cr,cdos,jp,vm,tbui,mb,wobnm,cfm,abd,bihu,kp,lu,imap,m,tnv,erh,hv,lc,ob,r,sf,sfa,tbpr,hsm,j,p,pcc,csi/am=yA/rt=j/d=1/sv=1/rs=AItRSTMbb91OwALJtHUarrkHc6mnQdhy-A\\\");\\u000a    google.xjs = 1;\\u000a}\\u000a;\\u000agoogle.pmc = {\\u000a    c: {\\u000a    },\\u000a    sb: {\\u000a        agen: false,\\u000a        cgen: true,\\u000a        client: \\\"hp\\\",\\u000a        dh: true,\\u000a        ds: \\\"\\\",\\u000a        eqch: true,\\u000a        fl: true,\\u000a        host: \\\"google.com\\\",\\u000a        jsonp: true,\\u000a        lyrs: 29,\\u000a        msgs: {\\u000a            lcky: \\\"I&#39;m Feeling Lucky\\\",\\u000a            lml: \\\"Learn more\\\",\\u000a            oskt: \\\"Input tools\\\",\\u000a            psrc: \\\"This search was removed from your \\\\u003Ca href=\\\\\\\"/history\\\\\\\"\\\\u003EWeb History\\\\u003C/a\\\\u003E\\\",\\u000a            psrl: \\\"Remove\\\",\\u000a            sbit: \\\"Search by image\\\",\\u000a            srch: \\\"Google Search\\\"\\u000a        },\\u000a        ovr: {\\u000a            ent: 1,\\u000a            l: 1,\\u000a            ms: 1\\u000a        },\\u000a        pq: \\\"\\\",\\u000a        psy: \\\"p\\\",\\u000a        qcpw: false,\\u000a        scd: 10,\\u000a        sce: 4,\\u000a        stok: \\\"umXjRAuqAKZoHP5587xA30Rb4f0\\\"\\u000a    },\\u000a    cr: {\\u000a        eup: false,\\u000a        qir: true,\\u000a        rctj: true,\\u000a        ref: false,\\u000a        uff: false\\u000a    },\\u000a    cdos: {\\u000a        dima: \\\"b\\\"\\u000a    },\\u000a    gf: {\\u000a        pid: 196\\u000a    },\\u000a    jp: {\\u000a        mcr: 5\\u000a    },\\u000a    vm: {\\u000a        bv: 48705608,\\u000a        d: \\\"aWc\\\",\\u000a        tc: true,\\u000a        te: true,\\u000a        tk: true,\\u000a        ts: true\\u000a    },\\u000a    tbui: {\\u000a        dfi: {\\u000a            am: [\\\"Jan\\\",\\\"Feb\\\",\\\"Mar\\\",\\\"Apr\\\",\\\"May\\\",\\\"Jun\\\",\\\"Jul\\\",\\\"Aug\\\",\\\"Sep\\\",\\\"Oct\\\",\\\"Nov\\\",\\\"Dec\\\",],\\u000a            df: [\\\"EEEE, MMMM d, y\\\",\\\"MMMM d, y\\\",\\\"MMM d, y\\\",\\\"M/d/yyyy\\\",],\\u000a            fdow: 6,\\u000a            nw: [\\\"S\\\",\\\"M\\\",\\\"T\\\",\\\"W\\\",\\\"T\\\",\\\"F\\\",\\\"S\\\",],\\u000a            wm: [\\\"January\\\",\\\"February\\\",\\\"March\\\",\\\"April\\\",\\\"May\\\",\\\"June\\\",\\\"July\\\",\\\"August\\\",\\\"September\\\",\\\"October\\\",\\\"November\\\",\\\"December\\\",]\\u000a        },\\u000a        g: 28,\\u000a        k: true,\\u000a        m: {\\u000a            app: true,\\u000a            bks: true,\\u000a            blg: true,\\u000a            dsc: true,\\u000a            fin: true,\\u000a            flm: true,\\u000a            frm: true,\\u000a            isch: true,\\u000a            klg: true,\\u000a            map: true,\\u000a            mobile: true,\\u000a            nws: true,\\u000a            plcs: true,\\u000a            ppl: true,\\u000a            prc: true,\\u000a            pts: true,\\u000a            rcp: true,\\u000a            shop: true,\\u000a            vid: true\\u000a        },\\u000a        t: null\\u000a    },\\u000a    mb: {\\u000a        db: false,\\u000a        m_errors: {\\u000a            \\\"default\\\": \\\"\\\\u003Cfont color=red\\\\u003EError:\\\\u003C/font\\\\u003E The server could not complete your request.  Try again in 30 seconds.\\\"\\u000a        },\\u000a        m_tip: \\\"Click for more information\\\",\\u000a        nlpm: \\\"-153px -84px\\\",\\u000a        nlpp: \\\"-153px -70px\\\",\\u000a        utp: true\\u000a    },\\u000a    wobnm: {\\u000a    },\\u000a    cfm: {\\u000a        data_url: \\\"/m/financedata?output=search&source=mus\\\"\\u000a    },\\u000a    abd: {\\u000a        abd: false,\\u000a        dabp: false,\\u000a        deb: false,\\u000a        der: false,\\u000a        det: false,\\u000a        psa: false,\\u000a        sup: false\\u000a    },\\u000a    adp: {\\u000a    },\\u000a    adp: {\\u000a    },\\u000a    llc: {\\u000a        carmode: \\\"list\\\",\\u000a        cns: false,\\u000a        dst: 3185505,\\u000a        fling_time: 300,\\u000a        float: true,\\u000a        hot: false,\\u000a        ime: true,\\u000a        mpi: 0,\\u000a        oq: \\\"\\\",\\u000a        p: false,\\u000a        sticky: true,\\u000a        t: false,\\u000a        udp: 600,\\u000a        uds: 600,\\u000a        udt: 600,\\u000a        urs: false,\\u000a        usr: true\\u000a    },\\u000a    rkab: {\\u000a        bl: \\\"Feedback / More info\\\",\\u000a        db: \\\"Reported\\\",\\u000a        di: \\\"Thank you.\\\",\\u000a        dl: \\\"Report another problem\\\",\\u000a        rb: \\\"Wrong?\\\",\\u000a        ri: \\\"Please report the problem.\\\",\\u000a        rl: \\\"Cancel\\\"\\u000a    },\\u000a    bihu: {\\u000a        MESSAGES: {\\u000a            msg_img_from: \\\"Image from %1$s\\\",\\u000a            msg_ms: \\\"More sizes\\\",\\u000a            msg_si: \\\"Similar\\\"\\u000a        }\\u000a    },\\u000a    riu: {\\u000a        cnfrm: \\\"Reported\\\",\\u000a        prmpt: \\\"Report\\\"\\u000a    },\\u000a    ifl: {\\u000a        opts: [{\\u000a            href: \\\"/url?url=/doodles/martha-grahams-117th-birthday\\\",\\u000a            id: \\\"doodley\\\",\\u000a            msg: \\\"I'm Feeling Doodley\\\"\\u000a        },{\\u000a            href: \\\"/url?url=http://www.googleartproject.com/collection/musee-dorsay-paris/artwork/dancers-edgar-degas/484111/&sa=t&usg=AFQjCNFvuPd-FAaZasCyDYcccCCOr4NcPw\\\",\\u000a            id: \\\"artistic\\\",\\u000a            msg: \\\"I'm Feeling Artistic\\\"\\u000a        },{\\u000a            href: \\\"/url?url=/search?q%3Drestaurants%26tbm%3Dplcs\\\",\\u000a            id: \\\"hungry\\\",\\u000a            msg: \\\"I'm Feeling Hungry\\\"\\u000a        },{\\u000a            href: \\\"/url?url=http://agoogleaday.com/%23date%3D2012-07-17&sa=t&usg=AFQjCNH4uOAvdBFnSR2cdquCknLiNgI-lg\\\",\\u000a            id: \\\"puzzled\\\",\\u000a            msg: \\\"I'm Feeling Puzzled\\\"\\u000a        },{\\u000a            href: \\\"/url?url=/trends/hottrends\\\",\\u000a            id: \\\"trendy\\\",\\u000a            msg: \\\"I'm Feeling Trendy\\\"\\u000a        },{\\u000a            href: \\\"/url?url=/earth/explore/showcase/hubble20th.html%23tab%3Dcrab-nebula\\\",\\u000a            id: \\\"stellar\\\",\\u000a            msg: \\\"I'm Feeling Stellar\\\"\\u000a        },{\\u000a            href: \\\"/url?url=/doodles/les-pauls-96th-birthday\\\",\\u000a            id: \\\"playful\\\",\\u000a            msg: \\\"I'm Feeling Playful\\\"\\u000a        },{\\u000a            href: \\\"/url?url=/intl/en/culturalinstitute/worldwonders/cornwall-west-devon/\\\",\\u000a            id: \\\"wonderful\\\",\\u000a            msg: \\\"I'm Feeling Wonderful\\\"\\u000a        },]\\u000a    },\\u000a    rmcl: {\\u000a        bl: \\\"Feedback / More info\\\",\\u000a        db: \\\"Reported\\\",\\u000a        di: \\\"Thank you.\\\",\\u000a        dl: \\\"Report another problem\\\",\\u000a        rb: \\\"Wrong?\\\",\\u000a        ri: \\\"Please report the problem.\\\",\\u000a        rl: \\\"Cancel\\\"\\u000a    },\\u000a    an: {\\u000a    },\\u000a    kp: {\\u000a        use_top_media_styles: true\\u000a    },\\u000a    rk: {\\u000a        bl: \\\"Feedback / More info\\\",\\u000a        db: \\\"Reported\\\",\\u000a        di: \\\"Thank you.\\\",\\u000a        dl: \\\"Report another problem\\\",\\u000a        efe: false,\\u000a        rb: \\\"Wrong?\\\",\\u000a        ri: \\\"Please report the problem.\\\",\\u000a        rl: \\\"Cancel\\\"\\u000a    },\\u000a    lu: {\\u000a        cm_hov: true,\\u000a        tt_kft: true,\\u000a        uab: true\\u000a    },\\u000a    imap: {\\u000a    },\\u000a    m: {\\u000a        ab: {\\u000a            on: true\\u000a        },\\u000a        ajax: {\\u000a            gl: \\\"us\\\",\\u000a            hl: \\\"en\\\",\\u000a            q: \\\"\\\"\\u000a        },\\u000a        css: {\\u000a            adpbc: \\\"#fec\\\",\\u000a            adpc: \\\"#fffbf2\\\",\\u000a            def: false,\\u000a            showTopNav: true\\u000a        },\\u000a        elastic: {\\u000a            js: true,\\u000a            rhs4Col: 1072,\\u000a            rhs5Col: 1160,\\u000a            rhsOn: true,\\u000a            tiny: false\\u000a        },\\u000a        exp: {\\u000a            lru: true,\\u000a            tnav: true\\u000a        },\\u000a        kfe: {\\u000a            adsClientId: 33,\\u000a            clientId: 29,\\u000a            kfeHost: \\\"clients1.google.com\\\",\\u000a            kfeUrlPrefix: \\\"/webpagethumbnail?r=4&f=3&s=400:585&query=&hl=en&gl=us\\\",\\u000a            vsH: 585,\\u000a            vsW: 400\\u000a        },\\u000a        msgs: {\\u000a            details: \\\"Result details\\\",\\u000a            hPers: \\\"Hide private results\\\",\\u000a            hPersD: \\\"Currently hiding private results\\\",\\u000a            loading: \\\"Still loading...\\\",\\u000a            mute: \\\"Mute\\\",\\u000a            noPreview: \\\"Preview not available\\\",\\u000a            sPers: \\\"Show all results\\\",\\u000a            sPersD: \\\"Currently showing private results\\\",\\u000a            unmute: \\\"Unmute\\\"\\u000a        },\\u000a        nokjs: {\\u000a            on: true\\u000a        },\\u000a        time: {\\u000a            hUnit: 1500\\u000a        }\\u000a    },\\u000a    tnv: {\\u000a        t: false\\u000a    },\\u000a    adsm: {\\u000a    },\\u000a    async: {\\u000a    },\\u000a    bds: {\\u000a    },\\u000a    ca: {\\u000a    },\\u000a    erh: {\\u000a    },\\u000a    hp: {\\u000a    },\\u000a    hv: {\\u000a    },\\u000a    lc: {\\u000a    },\\u000a    lor: {\\u000a    },\\u000a    ob: {\\u000a    },\\u000a    r: {\\u000a    },\\u000a    sf: {\\u000a    },\\u000a    sfa: {\\u000a    },\\u000a    shlb: {\\u000a    },\\u000a    st: {\\u000a    },\\u000a    tbpr: {\\u000a    },\\u000a    vs: {\\u000a    },\\u000a    hsm: {\\u000a    },\\u000a    j: {\\u000a        ahipiou: true,\\u000a        cspd: 0,\\u000a        hme: true,\\u000a        icmt: false,\\u000a        mcr: 5,\\u000a        tct: \\\" \\\\\\\\u3000?\\\"\\u000a    },\\u000a    p: {\\u000a        ae: true,\\u000a        avgTtfc: 2000,\\u000a        brba: false,\\u000a        dlen: 24,\\u000a        dper: 3,\\u000a        eae: true,\\u000a        fbdc: 500,\\u000a        fbdu: -1,\\u000a        fbh: true,\\u000a        fd: 1000000,\\u000a        focus: true,\\u000a        ftwd: 200,\\u000a        gpsj: true,\\u000a        hiue: true,\\u000a        hpt: 310,\\u000a        iavgTtfc: 2000,\\u000a        kn: true,\\u000a        knrt: true,\\u000a        maxCbt: 1500,\\u000a        mds: \\\"dfn,klg,prc,sp,mbl_he,mbl_hs,mbl_re,mbl_rs,mbl_sv\\\",\\u000a        msg: {\\u000a            dym: \\\"Did you mean:\\\",\\u000a            gs: \\\"Google Search\\\",\\u000a            kntt: \\\"Use the up and down arrow keys to select each result. Press Enter to go to the selection.\\\",\\u000a            pcnt: \\\"New Tab\\\",\\u000a            sif: \\\"Search instead for\\\",\\u000a            srf: \\\"Showing results for\\\"\\u000a        },\\u000a        nprr: 1,\\u000a        ophe: true,\\u000a        pmt: 250,\\u000a        pq: true,\\u000a        rpt: 50,\\u000a        sc: \\\"psy-ab\\\",\\u000a        tdur: 50,\\u000a        ufl: true\\u000a    },\\u000a    pcc: {\\u000a    },\\u000a    csi: {\\u000a        acsi: true,\\u000a        cbu: \\\"/gen_204\\\",\\u000a        csbu: \\\"/gen_204\\\"\\u000a    }\\u000a};\\u000agoogle.y.first.push(function() {\\u000a    google.loadAll([\\\"gf\\\",\\\"adp\\\",\\\"adp\\\",\\\"llc\\\",\\\"ifl\\\",\\\"an\\\",\\\"async\\\",\\\"vs\\\",]);\\u000a    if (google.med) {\\u000a        google.med(\\\"init\\\");\\u000a        google.initHistory();\\u000a        google.med(\\\"history\\\");\\u000a    }\\u000a;\\u000a    (google.History && google.History.initialize(\\\"/\\\"));\\u000a    ((google.hs && google.hs.init) && google.hs.init());\\u000a});\\u000aif (((google.j && google.j.en) && google.j.xi)) {\\u000a    window.setTimeout(google.j.xi, 0);\\u000a}\\u000a;\"), (\"s32d099e459d0acd3e74933c12a38935e62cf1cbf\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    if ((((JSBNG_Record.get)(google, (\"y\")))[(\"y\")])) {\n        ((JSBNG_Record.set)((((JSBNG_Record.get)(google, (\"y\")))[(\"y\")]), (\"first\"), []));\n    };\n    ((function() {\n        var s32d099e459d0acd3e74933c12a38935e62cf1cbf_0_instance;\n        ((s32d099e459d0acd3e74933c12a38935e62cf1cbf_0_instance) = ((JSBNG_Record.eventInstance)((\"s32d099e459d0acd3e74933c12a38935e62cf1cbf_0\"))));\n        return ((JSBNG_Record.markFunction)((function() {\n            if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                return ((JSBNG_Record.eventCall)((arguments.callee), (\"s32d099e459d0acd3e74933c12a38935e62cf1cbf_0\"), (s32d099e459d0acd3e74933c12a38935e62cf1cbf_0_instance), (this), (arguments)))\n            };\n            (null);\n            function b(a) {\n                if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                    return ((JSBNG_Record.eventCall)((arguments.callee), (\"s32d099e459d0acd3e74933c12a38935e62cf1cbf_1\"), (s32d099e459d0acd3e74933c12a38935e62cf1cbf_1_instance), (this), (arguments)))\n                };\n                (null);\n                (((JSBNG_Record.get)(window, (\"JSBNG__setTimeout\")))[(\"JSBNG__setTimeout\")])(((function() {\n                    var s32d099e459d0acd3e74933c12a38935e62cf1cbf_2_instance;\n                    ((s32d099e459d0acd3e74933c12a38935e62cf1cbf_2_instance) = ((JSBNG_Record.eventInstance)((\"s32d099e459d0acd3e74933c12a38935e62cf1cbf_2\"))));\n                    return ((JSBNG_Record.markFunction)((function() {\n                        if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                            return ((JSBNG_Record.eventCall)((arguments.callee), (\"s32d099e459d0acd3e74933c12a38935e62cf1cbf_2\"), (s32d099e459d0acd3e74933c12a38935e62cf1cbf_2_instance), (this), (arguments)))\n                        };\n                        (null);\n                        var c = (((JSBNG_Record.get)(JSBNG__document, (\"createElement\")))[(\"createElement\")])(\"script\");\n                        ((JSBNG_Record.set)(c, (\"src\"), a));\n                        (((JSBNG_Record.get)((((JSBNG_Record.get)(JSBNG__document, (\"getElementById\")))[(\"getElementById\")])(\"xjsd\"), (\"appendChild\")))[(\"appendChild\")])(c);\n                    })));\n                })()), 0);\n            };\n            var s32d099e459d0acd3e74933c12a38935e62cf1cbf_1_instance;\n            ((s32d099e459d0acd3e74933c12a38935e62cf1cbf_1_instance) = ((JSBNG_Record.eventInstance)((\"s32d099e459d0acd3e74933c12a38935e62cf1cbf_1\"))));\n            ((JSBNG_Record.markFunction)((b)));\n            ((JSBNG_Record.set)(google, (\"dljp\"), ((function() {\n                var s32d099e459d0acd3e74933c12a38935e62cf1cbf_3_instance;\n                ((s32d099e459d0acd3e74933c12a38935e62cf1cbf_3_instance) = ((JSBNG_Record.eventInstance)((\"s32d099e459d0acd3e74933c12a38935e62cf1cbf_3\"))));\n                return ((JSBNG_Record.markFunction)((function(a) {\n                    if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                        return ((JSBNG_Record.eventCall)((arguments.callee), (\"s32d099e459d0acd3e74933c12a38935e62cf1cbf_3\"), (s32d099e459d0acd3e74933c12a38935e62cf1cbf_3_instance), (this), (arguments)))\n                    };\n                    (null);\n                    ((((JSBNG_Record.get)(google, (\"xjsi\")))[(\"xjsi\")]) || (((JSBNG_Record.set)(google, (\"xjsu\"), a)), b(a)));\n                })));\n            })())));\n            ((JSBNG_Record.set)(google, (\"dlj\"), b));\n        })));\n    })())();\n    if (!(((JSBNG_Record.get)(google, (\"xjs\")))[(\"xjs\")])) {\n        ((JSBNG_Record.set)(window, (\"_\"), ((((JSBNG_Record.get)(window, (\"_\")))[(\"_\")]) || {\n        })));\n        ((JSBNG_Record.set)((((JSBNG_Record.get)(window, (\"_\")))[(\"_\")]), (\"_DumpException\"), ((function() {\n            var s32d099e459d0acd3e74933c12a38935e62cf1cbf_4_instance;\n            ((s32d099e459d0acd3e74933c12a38935e62cf1cbf_4_instance) = ((JSBNG_Record.eventInstance)((\"s32d099e459d0acd3e74933c12a38935e62cf1cbf_4\"))));\n            return ((JSBNG_Record.markFunction)((function(e) {\n                if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                    return ((JSBNG_Record.eventCall)((arguments.callee), (\"s32d099e459d0acd3e74933c12a38935e62cf1cbf_4\"), (s32d099e459d0acd3e74933c12a38935e62cf1cbf_4_instance), (this), (arguments)))\n                };\n                (null);\n                throw e;\n            })));\n        })())));\n        if (((((JSBNG_Record.get)(google, (\"timers\")))[(\"timers\")]) && (((JSBNG_Record.get)((((JSBNG_Record.get)((((JSBNG_Record.get)(google, (\"timers\")))[(\"timers\")]), (\"load\")))[(\"load\")]), (\"t\")))[(\"t\")]))) {\n            ((JSBNG_Record.set)((((JSBNG_Record.get)((((JSBNG_Record.get)((((JSBNG_Record.get)(google, (\"timers\")))[(\"timers\")]), (\"load\")))[(\"load\")]), (\"t\")))[(\"t\")]), (\"xjsls\"), (((JSBNG_Record.get)(new JSBNG__Date(), (\"getTime\")))[(\"getTime\")])()));\n        }\n    ;\n        (((JSBNG_Record.get)(google, (\"dljp\")))[(\"dljp\")])(\"/xjs/_/js/k=xjs.s.en_US.l3EGKs4A4V8.O/m=c,sb,cr,cdos,jp,vm,tbui,mb,wobnm,cfm,abd,bihu,kp,lu,imap,m,tnv,erh,hv,lc,ob,r,sf,sfa,tbpr,hsm,j,p,pcc,csi/am=yA/rt=j/d=1/sv=1/rs=AItRSTMbb91OwALJtHUarrkHc6mnQdhy-A\");\n        ((JSBNG_Record.set)(google, (\"xjs\"), 1));\n    }\n;\n    ((JSBNG_Record.set)(google, (\"pmc\"), {\n        c: {\n        },\n        sb: {\n            agen: false,\n            cgen: true,\n            client: \"hp\",\n            dh: true,\n            ds: \"\",\n            eqch: true,\n            fl: true,\n            host: \"google.com\",\n            jsonp: true,\n            lyrs: 29,\n            msgs: {\n                lcky: \"I&#39;m Feeling Lucky\",\n                lml: \"Learn more\",\n                oskt: \"Input tools\",\n                psrc: \"This search was removed from your \\u003Ca href=\\\"/history\\\"\\u003EWeb History\\u003C/a\\u003E\",\n                psrl: \"Remove\",\n                sbit: \"Search by image\",\n                srch: \"Google Search\"\n            },\n            ovr: {\n                ent: 1,\n                l: 1,\n                ms: 1\n            },\n            pq: \"\",\n            psy: \"p\",\n            qcpw: false,\n            scd: 10,\n            sce: 4,\n            stok: \"umXjRAuqAKZoHP5587xA30Rb4f0\"\n        },\n        cr: {\n            eup: false,\n            qir: true,\n            rctj: true,\n            ref: false,\n            uff: false\n        },\n        cdos: {\n            dima: \"b\"\n        },\n        gf: {\n            pid: 196\n        },\n        jp: {\n            mcr: 5\n        },\n        vm: {\n            bv: 48705608,\n            d: \"aWc\",\n            tc: true,\n            te: true,\n            tk: true,\n            ts: true\n        },\n        tbui: {\n            dfi: {\n                am: [\"Jan\",\"Feb\",\"Mar\",\"Apr\",\"May\",\"Jun\",\"Jul\",\"Aug\",\"Sep\",\"Oct\",\"Nov\",\"Dec\",],\n                df: [\"EEEE, MMMM d, y\",\"MMMM d, y\",\"MMM d, y\",\"M/d/yyyy\",],\n                fdow: 6,\n                nw: [\"S\",\"M\",\"T\",\"W\",\"T\",\"F\",\"S\",],\n                wm: [\"January\",\"February\",\"March\",\"April\",\"May\",\"June\",\"July\",\"August\",\"September\",\"October\",\"November\",\"December\",]\n            },\n            g: 28,\n            k: true,\n            m: {\n                app: true,\n                bks: true,\n                blg: true,\n                dsc: true,\n                fin: true,\n                flm: true,\n                frm: true,\n                isch: true,\n                klg: true,\n                map: true,\n                mobile: true,\n                nws: true,\n                plcs: true,\n                ppl: true,\n                prc: true,\n                pts: true,\n                rcp: true,\n                shop: true,\n                vid: true\n            },\n            t: null\n        },\n        mb: {\n            db: false,\n            m_errors: {\n                \"default\": \"\\u003Cfont color=red\\u003EError:\\u003C/font\\u003E The server could not complete your request.  Try again in 30 seconds.\"\n            },\n            m_tip: \"Click for more information\",\n            nlpm: \"-153px -84px\",\n            nlpp: \"-153px -70px\",\n            utp: true\n        },\n        wobnm: {\n        },\n        cfm: {\n            data_url: \"/m/financedata?output=search&source=mus\"\n        },\n        abd: {\n            abd: false,\n            dabp: false,\n            deb: false,\n            der: false,\n            det: false,\n            psa: false,\n            sup: false\n        },\n        adp: {\n        },\n        adp: {\n        },\n        llc: {\n            carmode: \"list\",\n            cns: false,\n            dst: 3185505,\n            fling_time: 300,\n            float: true,\n            hot: false,\n            ime: true,\n            mpi: 0,\n            oq: \"\",\n            p: false,\n            sticky: true,\n            t: false,\n            udp: 600,\n            uds: 600,\n            udt: 600,\n            urs: false,\n            usr: true\n        },\n        rkab: {\n            bl: \"Feedback / More info\",\n            db: \"Reported\",\n            di: \"Thank you.\",\n            dl: \"Report another problem\",\n            rb: \"Wrong?\",\n            ri: \"Please report the problem.\",\n            rl: \"Cancel\"\n        },\n        bihu: {\n            MESSAGES: {\n                msg_img_from: \"Image from %1$s\",\n                msg_ms: \"More sizes\",\n                msg_si: \"Similar\"\n            }\n        },\n        riu: {\n            cnfrm: \"Reported\",\n            prmpt: \"Report\"\n        },\n        ifl: {\n            opts: [{\n                href: \"/url?url=/doodles/martha-grahams-117th-birthday\",\n                id: \"doodley\",\n                msg: \"I'm Feeling Doodley\"\n            },{\n                href: \"/url?url=http://www.googleartproject.com/collection/musee-dorsay-paris/artwork/dancers-edgar-degas/484111/&sa=t&usg=AFQjCNFvuPd-FAaZasCyDYcccCCOr4NcPw\",\n                id: \"artistic\",\n                msg: \"I'm Feeling Artistic\"\n            },{\n                href: \"/url?url=/search?q%3Drestaurants%26tbm%3Dplcs\",\n                id: \"hungry\",\n                msg: \"I'm Feeling Hungry\"\n            },{\n                href: \"/url?url=http://agoogleaday.com/%23date%3D2012-07-17&sa=t&usg=AFQjCNH4uOAvdBFnSR2cdquCknLiNgI-lg\",\n                id: \"puzzled\",\n                msg: \"I'm Feeling Puzzled\"\n            },{\n                href: \"/url?url=/trends/hottrends\",\n                id: \"trendy\",\n                msg: \"I'm Feeling Trendy\"\n            },{\n                href: \"/url?url=/earth/explore/showcase/hubble20th.html%23tab%3Dcrab-nebula\",\n                id: \"stellar\",\n                msg: \"I'm Feeling Stellar\"\n            },{\n                href: \"/url?url=/doodles/les-pauls-96th-birthday\",\n                id: \"playful\",\n                msg: \"I'm Feeling Playful\"\n            },{\n                href: \"/url?url=/intl/en/culturalinstitute/worldwonders/cornwall-west-devon/\",\n                id: \"wonderful\",\n                msg: \"I'm Feeling Wonderful\"\n            },]\n        },\n        rmcl: {\n            bl: \"Feedback / More info\",\n            db: \"Reported\",\n            di: \"Thank you.\",\n            dl: \"Report another problem\",\n            rb: \"Wrong?\",\n            ri: \"Please report the problem.\",\n            rl: \"Cancel\"\n        },\n        an: {\n        },\n        kp: {\n            use_top_media_styles: true\n        },\n        rk: {\n            bl: \"Feedback / More info\",\n            db: \"Reported\",\n            di: \"Thank you.\",\n            dl: \"Report another problem\",\n            efe: false,\n            rb: \"Wrong?\",\n            ri: \"Please report the problem.\",\n            rl: \"Cancel\"\n        },\n        lu: {\n            cm_hov: true,\n            tt_kft: true,\n            uab: true\n        },\n        imap: {\n        },\n        m: {\n            ab: {\n                JSBNG__on: true\n            },\n            ajax: {\n                gl: \"us\",\n                hl: \"en\",\n                q: \"\"\n            },\n            css: {\n                adpbc: \"#fec\",\n                adpc: \"#fffbf2\",\n                def: false,\n                showTopNav: true\n            },\n            elastic: {\n                js: true,\n                rhs4Col: 1072,\n                rhs5Col: 1160,\n                rhsOn: true,\n                tiny: false\n            },\n            exp: {\n                lru: true,\n                tnav: true\n            },\n            kfe: {\n                adsClientId: 33,\n                clientId: 29,\n                kfeHost: \"clients1.google.com\",\n                kfeUrlPrefix: \"/webpagethumbnail?r=4&f=3&s=400:585&query=&hl=en&gl=us\",\n                vsH: 585,\n                vsW: 400\n            },\n            msgs: {\n                details: \"Result details\",\n                hPers: \"Hide private results\",\n                hPersD: \"Currently hiding private results\",\n                loading: \"Still loading...\",\n                mute: \"Mute\",\n                noPreview: \"Preview not available\",\n                sPers: \"Show all results\",\n                sPersD: \"Currently showing private results\",\n                unmute: \"Unmute\"\n            },\n            nokjs: {\n                JSBNG__on: true\n            },\n            time: {\n                hUnit: 1500\n            }\n        },\n        tnv: {\n            t: false\n        },\n        adsm: {\n        },\n        async: {\n        },\n        bds: {\n        },\n        ca: {\n        },\n        erh: {\n        },\n        hp: {\n        },\n        hv: {\n        },\n        lc: {\n        },\n        lor: {\n        },\n        ob: {\n        },\n        r: {\n        },\n        sf: {\n        },\n        sfa: {\n        },\n        shlb: {\n        },\n        st: {\n        },\n        tbpr: {\n        },\n        vs: {\n        },\n        hsm: {\n        },\n        j: {\n            ahipiou: true,\n            cspd: 0,\n            hme: true,\n            icmt: false,\n            mcr: 5,\n            tct: \" \\\\u3000?\"\n        },\n        p: {\n            ae: true,\n            avgTtfc: 2000,\n            brba: false,\n            dlen: 24,\n            dper: 3,\n            eae: true,\n            fbdc: 500,\n            fbdu: -1,\n            fbh: true,\n            fd: 1000000,\n            JSBNG__focus: true,\n            ftwd: 200,\n            gpsj: true,\n            hiue: true,\n            hpt: 310,\n            iavgTtfc: 2000,\n            kn: true,\n            knrt: true,\n            maxCbt: 1500,\n            mds: \"dfn,klg,prc,sp,mbl_he,mbl_hs,mbl_re,mbl_rs,mbl_sv\",\n            msg: {\n                dym: \"Did you mean:\",\n                gs: \"Google Search\",\n                kntt: \"Use the up and down arrow keys to select each result. Press Enter to go to the selection.\",\n                pcnt: \"New Tab\",\n                sif: \"Search instead for\",\n                srf: \"Showing results for\"\n            },\n            nprr: 1,\n            ophe: true,\n            pmt: 250,\n            pq: true,\n            rpt: 50,\n            sc: \"psy-ab\",\n            tdur: 50,\n            ufl: true\n        },\n        pcc: {\n        },\n        csi: {\n            acsi: true,\n            cbu: \"/gen_204\",\n            csbu: \"/gen_204\"\n        }\n    }));\n    (((JSBNG_Record.get)((((JSBNG_Record.get)((((JSBNG_Record.get)(google, (\"y\")))[(\"y\")]), (\"first\")))[(\"first\")]), (\"push\")))[(\"push\")])(((function() {\n        var s32d099e459d0acd3e74933c12a38935e62cf1cbf_5_instance;\n        ((s32d099e459d0acd3e74933c12a38935e62cf1cbf_5_instance) = ((JSBNG_Record.eventInstance)((\"s32d099e459d0acd3e74933c12a38935e62cf1cbf_5\"))));\n        return ((JSBNG_Record.markFunction)((function() {\n            if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                return ((JSBNG_Record.eventCall)((arguments.callee), (\"s32d099e459d0acd3e74933c12a38935e62cf1cbf_5\"), (s32d099e459d0acd3e74933c12a38935e62cf1cbf_5_instance), (this), (arguments)))\n            };\n            (null);\n            (((JSBNG_Record.get)(google, (\"loadAll\")))[(\"loadAll\")])([\"gf\",\"adp\",\"adp\",\"llc\",\"ifl\",\"an\",\"async\",\"vs\",]);\n            if ((((JSBNG_Record.get)(google, (\"med\")))[(\"med\")])) {\n                (((JSBNG_Record.get)(google, (\"med\")))[(\"med\")])(\"init\");\n                (((JSBNG_Record.get)(google, (\"initHistory\")))[(\"initHistory\")])();\n                (((JSBNG_Record.get)(google, (\"med\")))[(\"med\")])(\"JSBNG__history\");\n            }\n            ;\n            ((((JSBNG_Record.get)(google, (\"History\")))[(\"History\")]) && (((JSBNG_Record.get)((((JSBNG_Record.get)(google, (\"History\")))[(\"History\")]), (\"initialize\")))[(\"initialize\")])(\"/\"));\n            (((((JSBNG_Record.get)(google, (\"hs\")))[(\"hs\")]) && (((JSBNG_Record.get)((((JSBNG_Record.get)(google, (\"hs\")))[(\"hs\")]), (\"init\")))[(\"init\")])) && (((JSBNG_Record.get)((((JSBNG_Record.get)(google, (\"hs\")))[(\"hs\")]), (\"init\")))[(\"init\")])());\n        })));\n    })()));\n    if ((((((JSBNG_Record.get)(google, (\"j\")))[(\"j\")]) && (((JSBNG_Record.get)((((JSBNG_Record.get)(google, (\"j\")))[(\"j\")]), (\"en\")))[(\"en\")])) && (((JSBNG_Record.get)((((JSBNG_Record.get)(google, (\"j\")))[(\"j\")]), (\"xi\")))[(\"xi\")]))) {\n        (((JSBNG_Record.get)(window, (\"JSBNG__setTimeout\")))[(\"JSBNG__setTimeout\")])((((JSBNG_Record.get)((((JSBNG_Record.get)(google, (\"j\")))[(\"j\")]), (\"xi\")))[(\"xi\")]), 0);\n    }\n;\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};</script>";
// undefined
o96 = null;
// 2190
f895948954_393.returns.push(o29);
// 2191
o29.getElementsByTagName = f895948954_450;
// 2192
o94 = {};
// 2193
f895948954_450.returns.push(o94);
// 2194
o94["0"] = o38;
// 2195
o38.id = "gb_119";
// 2197
o38.href = "http://jsbngssl.plus.google.com/?gpsrc=ogpy0&tab=wX";
// 2198
o94["1"] = o39;
// 2199
o39.id = "gb_1";
// 2201
o39.href = "http://www.google.com/webhp?hl=en&tab=ww";
// 2202
o94["2"] = o40;
// 2203
o40.id = "gb_2";
// 2205
o40.href = "http://www.google.com/imghp?hl=en&tab=wi";
// 2206
o94["3"] = o41;
// 2207
o41.id = "gb_8";
// 2209
o41.href = "http://maps.google.com/maps?hl=en&tab=wl";
// 2210
o94["4"] = o42;
// 2211
o42.id = "gb_78";
// 2213
o42.href = "http://jsbngssl.play.google.com/?hl=en&tab=w8";
// 2214
o94["5"] = o23;
// 2215
o23.id = "gb_36";
// 2217
o23.href = "http://www.youtube.com/?tab=w1";
// 2218
o94["6"] = o43;
// 2219
o43.id = "gb_5";
// 2221
o43.href = "http://news.google.com/nwshp?hl=en&tab=wn";
// 2222
o94["7"] = o44;
// 2223
o44.id = "gb_23";
// 2225
o44.href = "http://jsbngssl.mail.google.com/mail/?tab=wm";
// 2226
o94["8"] = o45;
// 2227
o45.id = "gb_25";
// 2229
o45.href = "http://jsbngssl.drive.google.com/?tab=wo";
// 2230
o94["9"] = o46;
// 2231
o46.id = "gb_24";
// 2233
o46.href = "http://jsbngssl.www.google.com/calendar?tab=wc";
// 2234
o94["10"] = o47;
// 2235
o47.id = "gbztm";
// 2236
o94["11"] = o48;
// 2237
o48.id = "gb_51";
// 2239
o48.href = "http://translate.google.com/?hl=en&tab=wT";
// 2240
o94["12"] = o49;
// 2241
o49.id = "gb_17";
// 2243
o49.href = "http://www.google.com/mobile/?hl=en&tab=wD";
// 2244
o94["13"] = o50;
// 2245
o50.id = "gb_10";
// 2247
o50.href = "http://books.google.com/bkshp?hl=en&tab=wp";
// 2248
o94["14"] = o51;
// 2249
o51.id = "gb_172";
// 2251
o51.href = "http://jsbngssl.www.google.com/offers?utm_source=xsell&utm_medium=products&utm_campaign=sandbar&hl=en&tab=wG";
// 2252
o94["15"] = o52;
// 2253
o52.id = "gb_212";
// 2255
o52.href = "http://jsbngssl.wallet.google.com/manage/?tab=wa";
// 2256
o94["16"] = o53;
// 2257
o53.id = "gb_6";
// 2259
o53.href = "http://www.google.com/shopping?hl=en&tab=wf";
// 2260
o94["17"] = o54;
// 2261
o54.id = "gb_30";
// 2263
o54.href = "http://www.blogger.com/?tab=wj";
// 2264
o94["18"] = o55;
// 2265
o55.id = "gb_27";
// 2267
o55.href = "http://www.google.com/finance?tab=we";
// 2268
o94["19"] = o56;
// 2269
o56.id = "gb_31";
// 2271
o56.href = "http://jsbngssl.plus.google.com/photos?tab=wq";
// 2272
o94["20"] = o57;
// 2273
o57.id = "gb_12";
// 2275
o57.href = "http://video.google.com/?hl=en&tab=wv";
// 2276
o94["21"] = o58;
// 2277
o58.id = "";
// 2278
o94["22"] = o59;
// 2279
o59.id = "";
// 2280
o94["23"] = o10;
// 2281
o10.id = "gb_70";
// 2283
o10.href = "http://jsbngssl.accounts.google.com/ServiceLogin?hl=en&continue=http://www.google.com/";
// 2284
o94["24"] = o60;
// 2285
o60.id = "";
// 2286
o94["25"] = o61;
// 2287
o61.id = "gmlas";
// 2288
o94["26"] = o62;
// 2289
o62.id = "";
// 2290
o94["27"] = o63;
// 2291
o63.id = "";
// 2292
o94["28"] = void 0;
// undefined
o94 = null;
// 2293
f895948954_7.returns.push(undefined);
// 2295
o94 = {};
// 2296
f895948954_393.returns.push(o94);
// 2297
o96 = {};
// undefined
fo895948954_534_dataset = function() { return fo895948954_534_dataset.returns[fo895948954_534_dataset.inst++]; };
fo895948954_534_dataset.returns = [];
fo895948954_534_dataset.inst = 0;
defineGetter(o94, "dataset", fo895948954_534_dataset, undefined);
// undefined
o94 = null;
// undefined
fo895948954_534_dataset.returns.push(o96);
// undefined
o96 = null;
// undefined
fo895948954_534_dataset.returns.push(null);
// 2305
o94 = {};
// 2306
o16.style = o94;
// 2307
// 2310
// 2312
o96 = {};
// 2313
f895948954_428.returns.push(o96);
// 2314
// 2316
f895948954_393.returns.push(null);
// 2319
f895948954_431.returns.push(o96);
// undefined
o96 = null;
// 2321
o96 = {};
// 2322
f895948954_393.returns.push(o96);
// 2323
o96.tagName = void 0;
// undefined
o96 = null;
// 2324
f895948954_539 = function() { return f895948954_539.returns[f895948954_539.inst++]; };
f895948954_539.returns = [];
f895948954_539.inst = 0;
// 2325
o0.getElementsByName = f895948954_539;
// 2326
o96 = {};
// 2327
f895948954_539.returns.push(o96);
// 2328
o96["0"] = void 0;
// undefined
o96 = null;
// 2330
o96 = {};
// 2331
f895948954_539.returns.push(o96);
// 2332
o96["0"] = void 0;
// undefined
o96 = null;
// 2336
o96 = {};
// 2337
f895948954_539.returns.push(o96);
// 2338
o96["0"] = void 0;
// undefined
o96 = null;
// 2342
o96 = {};
// 2343
f895948954_539.returns.push(o96);
// 2344
o96["0"] = void 0;
// undefined
o96 = null;
// 2345
f895948954_7.returns.push(undefined);
// 2348
f895948954_449.returns.push(undefined);
// 2349
f895948954_544 = function() { return f895948954_544.returns[f895948954_544.inst++]; };
f895948954_544.returns = [];
f895948954_544.inst = 0;
// 2350
o4.pushState = f895948954_544;
// undefined
o4 = null;
// 2351
f895948954_6.returns.push(undefined);
// 2352
f895948954_6.returns.push(undefined);
// 2353
f895948954_545 = function() { return f895948954_545.returns[f895948954_545.inst++]; };
f895948954_545.returns = [];
f895948954_545.inst = 0;
// 2354
ow895948954.JSBNG__onhashchange = f895948954_545;
// 2355
f895948954_7.returns.push(undefined);
// 2357
f895948954_393.returns.push(null);
// 2359
o4 = {};
// 2360
f895948954_417.returns.push(o4);
// 2361
o4["0"] = void 0;
// undefined
o4 = null;
// 2363
o4 = {};
// 2364
f895948954_417.returns.push(o4);
// 2365
o96 = {};
// 2366
o4["0"] = o96;
// 2367
o96.className = "";
// undefined
o96 = null;
// 2368
o96 = {};
// 2369
o4["1"] = o96;
// 2370
o96.className = "";
// undefined
o96 = null;
// 2371
o4["2"] = o38;
// 2373
o4["3"] = o39;
// 2375
o4["4"] = o40;
// 2377
o4["5"] = o41;
// 2379
o4["6"] = o42;
// 2381
o4["7"] = o23;
// 2383
o4["8"] = o43;
// 2385
o4["9"] = o44;
// 2387
o4["10"] = o45;
// 2389
o4["11"] = o46;
// 2391
o4["12"] = o47;
// 2393
o4["13"] = o48;
// 2395
o4["14"] = o49;
// 2397
o4["15"] = o50;
// 2399
o4["16"] = o51;
// 2401
o4["17"] = o52;
// 2403
o4["18"] = o53;
// 2405
o4["19"] = o54;
// 2407
o4["20"] = o55;
// 2409
o4["21"] = o56;
// 2411
o4["22"] = o57;
// 2413
o4["23"] = o58;
// 2415
o4["24"] = o59;
// 2417
o4["25"] = o10;
// 2419
o4["26"] = o60;
// 2421
o4["27"] = o61;
// 2423
o4["28"] = o62;
// 2425
o4["29"] = o63;
// 2427
o96 = {};
// 2428
o4["30"] = o96;
// 2429
o96.className = "";
// undefined
o96 = null;
// 2430
o96 = {};
// 2431
o4["31"] = o96;
// 2432
o96.className = "";
// undefined
o96 = null;
// 2433
o96 = {};
// 2434
o4["32"] = o96;
// 2435
o96.className = "";
// undefined
o96 = null;
// 2436
o96 = {};
// 2437
o4["33"] = o96;
// 2438
o96.className = "";
// undefined
o96 = null;
// 2439
o96 = {};
// 2440
o4["34"] = o96;
// 2441
o96.className = "";
// undefined
o96 = null;
// 2442
o96 = {};
// 2443
o4["35"] = o96;
// 2444
o96.className = "";
// undefined
o96 = null;
// 2445
o4["36"] = void 0;
// undefined
o4 = null;
// 2447
f895948954_393.returns.push(null);
// 2448
f895948954_556 = function() { return f895948954_556.returns[f895948954_556.inst++]; };
f895948954_556.returns = [];
f895948954_556.inst = 0;
// 2449
o0.querySelectorAll = f895948954_556;
// 2450
f895948954_557 = function() { return f895948954_557.returns[f895948954_557.inst++]; };
f895948954_557.returns = [];
f895948954_557.inst = 0;
// 2451
o0.querySelector = f895948954_557;
// 2453
f895948954_557.returns.push(null);
// 2455
f895948954_393.returns.push(null);
// 2459
f895948954_557.returns.push(null);
// 2461
f895948954_393.returns.push(null);
// 2463
f895948954_393.returns.push(null);
// 2465
f895948954_393.returns.push(null);
// 2467
o4 = {};
// 2468
f895948954_556.returns.push(o4);
// 2469
o4.length = 0;
// 2472
o96 = {};
// 2473
f895948954_556.returns.push(o96);
// 2474
o96["0"] = void 0;
// undefined
o96 = null;
// 2478
o96 = {};
// 2479
f895948954_556.returns.push(o96);
// 2480
o96["0"] = o95;
// undefined
o96 = null;
// 2482
o96 = {};
// 2483
f895948954_428.returns.push(o96);
// 2484
// 2485
o95.appendChild = f895948954_431;
// undefined
o95 = null;
// 2486
f895948954_431.returns.push(o96);
// undefined
o96 = null;
// 2488
f895948954_393.returns.push(null);
// 2490
f895948954_393.returns.push(null);
// 2492
f895948954_393.returns.push(null);
// 2494
f895948954_393.returns.push(null);
// 2496
f895948954_557.returns.push(null);
// 2498
o16.nodeType = 1;
// 2499
o16.ownerDocument = o0;
// 2503
o95 = {};
// 2504
f895948954_4.returns.push(o95);
// 2505
o95.direction = void 0;
// 2506
o95.getPropertyValue = void 0;
// undefined
o95 = null;
// 2508
f895948954_393.returns.push(null);
// 2510
f895948954_393.returns.push(null);
// 2512
f895948954_393.returns.push(null);
// 2514
f895948954_393.returns.push(null);
// 2516
f895948954_393.returns.push(null);
// 2518
f895948954_393.returns.push(null);
// 2520
f895948954_406.returns.push(null);
// 2522
f895948954_407.returns.push(undefined);
// 2523
f895948954_7.returns.push(undefined);
// 2525
o95 = {};
// 2526
f895948954_393.returns.push(o95);
// 2527
o95.value = "";
// undefined
o95 = null;
// 2530
f895948954_389.returns.push(1373476565573);
// 2533
o5.search = "";
// 2534
f895948954_16.returns.push(8);
// 2535
f895948954_389.returns.push(1373476565577);
// 2536
o7.ist_rc = void 0;
// undefined
o7 = null;
// 2538
f895948954_393.returns.push(null);
// 2540
f895948954_393.returns.push(null);
// 2542
f895948954_393.returns.push(null);
// 2544
f895948954_393.returns.push(null);
// 2545
o0.webkitVisibilityState = void 0;
// 2547
o7 = {};
// 2548
f895948954_393.returns.push(o7);
// undefined
o7 = null;
// 2549
o3.connection = void 0;
// 2550
o7 = {};
// 2551
o8.timing = o7;
// undefined
o8 = null;
// 2552
o7.navigationStart = 1373476536814;
// 2553
o7.connectEnd = 1373476536820;
// 2554
o7.connectStart = 1373476536820;
// 2557
o7.domainLookupEnd = 1373476536820;
// 2558
o7.domainLookupStart = 1373476536820;
// 2561
o7.redirectEnd = 0;
// 2562
o7.responseEnd = 1373476538870;
// 2563
o7.requestStart = 1373476536822;
// 2567
o7.responseStart = 1373476538856;
// 2570
o0.JSBNG__location = o5;
// 2572
o8 = {};
// 2573
f895948954_65.returns.push(o8);
// 2574
// 2575
// 2576
// undefined
o8 = null;
// 2577
o8 = {};
// undefined
o8 = null;
// 2578
o8 = {};
// 2580
o8.which = 1;
// 2581
o8.type = "mouseout";
// 2582
o8.srcElement = void 0;
// 2583
o8.target = o75;
// 2589
o95 = {};
// 2591
o95.which = 1;
// 2592
o95.type = "mouseover";
// 2593
o95.srcElement = void 0;
// 2594
o95.target = o36;
// 2606
o96 = {};
// 2608
o96.which = 1;
// 2609
o96.type = "mouseout";
// 2610
o96.srcElement = void 0;
// 2611
o96.target = o36;
// 2623
o97 = {};
// 2625
o97.which = 1;
// 2626
o97.type = "mouseover";
// 2627
o97.srcElement = void 0;
// 2628
o97.target = o87;
// 2641
o98 = {};
// 2643
o98.which = 1;
// 2644
o98.type = "mouseout";
// 2645
o98.srcElement = void 0;
// 2646
o98.target = o87;
// 2659
o99 = {};
// 2661
o99.which = 1;
// 2662
o99.type = "mouseover";
// 2663
o99.srcElement = void 0;
// 2664
o99.target = o20;
// 2678
o100 = {};
// 2680
o100.which = 1;
// 2681
o100.type = "mouseout";
// 2682
o100.srcElement = void 0;
// 2683
o100.target = o20;
// 2697
o101 = {};
// 2699
o101.which = 1;
// 2700
o101.type = "mouseover";
// 2701
o101.srcElement = void 0;
// 2702
o101.target = o87;
// 2715
o102 = {};
// 2717
o102.which = 1;
// 2718
o102.type = "mouseout";
// 2719
o102.srcElement = void 0;
// 2720
o102.target = o87;
// 2733
o103 = {};
// 2735
o103.which = 1;
// 2736
o103.type = "mouseover";
// 2737
o103.srcElement = void 0;
// 2738
o103.target = o75;
// 2745
f895948954_16.returns.push(9);
// 2747
f895948954_393.returns.push(o67);
// 2749
o104 = {};
// 2750
f895948954_393.returns.push(o104);
// 2751
o104.getAttribute = f895948954_435;
// undefined
o104 = null;
// 2752
f895948954_435.returns.push("0CAMQnRs");
// 2754
o104 = {};
// 2755
f895948954_428.returns.push(o104);
// 2756
// 2757
// 2758
f895948954_580 = function() { return f895948954_580.returns[f895948954_580.inst++]; };
f895948954_580.returns = [];
f895948954_580.inst = 0;
// 2759
o104.setAttribute = f895948954_580;
// 2760
f895948954_580.returns.push(undefined);
// 2761
o105 = {};
// 2762
o104.firstChild = o105;
// undefined
o105 = null;
// 2763
o105 = {};
// 2764
o67.parentNode = o105;
// 2766
f895948954_583 = function() { return f895948954_583.returns[f895948954_583.inst++]; };
f895948954_583.returns = [];
f895948954_583.inst = 0;
// 2767
o105.insertBefore = f895948954_583;
// 2768
o67.nextSibling = null;
// 2769
f895948954_583.returns.push(o104);
// undefined
o104 = null;
// 2770
o104 = {};
// 2771
o67.firstChild = o104;
// undefined
o104 = null;
// 2774
o104 = {};
// 2775
f895948954_4.returns.push(o104);
// 2776
o104.getPropertyValue = void 0;
// undefined
o104 = null;
// 2780
o104 = {};
// 2781
f895948954_556.returns.push(o104);
// 2782
o104.length = 0;
// undefined
o104 = null;
// 2784
f895948954_557.returns.push(null);
// 2786
f895948954_557.returns.push(null);
// 2788
f895948954_393.returns.push(null);
// 2790
f895948954_557.returns.push(null);
// 2792
f895948954_393.returns.push(null);
// 2794
f895948954_393.returns.push(null);
// 2796
f895948954_393.returns.push(null);
// 2798
f895948954_393.returns.push(null);
// 2800
f895948954_393.returns.push(null);
// 2804
o104 = {};
// 2806
o104.which = 1;
// 2807
o104.type = "mouseout";
// 2808
o104.srcElement = void 0;
// 2809
o104.target = o75;
// 2815
o106 = {};
// 2817
o106.which = 1;
// 2818
o106.type = "mouseover";
// 2819
o106.srcElement = void 0;
// 2820
o106.target = o36;
// 2832
o107 = {};
// 2834
o107.which = 1;
// 2835
o107.type = "mouseout";
// 2836
o107.srcElement = void 0;
// 2837
o107.target = o36;
// 2849
o108 = {};
// 2851
o108.which = 1;
// 2852
o108.type = "mouseover";
// 2853
o108.srcElement = void 0;
// 2854
o108.target = o87;
// 2867
o109 = {};
// 2869
o109.which = 1;
// 2870
o109.type = "mouseout";
// 2871
o109.srcElement = void 0;
// 2872
o109.target = o87;
// 2885
o110 = {};
// 2887
o110.which = 1;
// 2888
o110.type = "mouseover";
// 2889
o110.srcElement = void 0;
// 2890
o110.target = o20;
// 2904
o111 = {};
// 2906
o111.which = 1;
// 2907
o111.type = "mousedown";
// 2908
o111.srcElement = void 0;
// 2909
o111.target = o20;
// 2923
o112 = {};
// 2925
o112.which = 1;
// 2926
o112.type = "mouseup";
// 2927
o112.srcElement = void 0;
// 2928
o112.target = o20;
// 2942
o113 = {};
// 2944
o113.metaKey = false;
// 2945
o113.which = 1;
// 2947
o113.shiftKey = false;
// 2949
o113.type = "click";
// 2950
o113.srcElement = void 0;
// 2951
o113.target = o20;
// 2968
o20.tagName = "INPUT";
// 2969
o20.JSBNG__onclick = null;
// 2972
o87.tagName = "DIV";
// 2973
o87.JSBNG__onclick = null;
// 2976
o36.tagName = "DIV";
// 2977
o36.JSBNG__onclick = null;
// 2980
o70.tagName = "DIV";
// 2981
o70.JSBNG__onclick = null;
// 2984
o11.tagName = "FIELDSET";
// 2985
o11.JSBNG__onclick = null;
// 2988
o19.tagName = "FORM";
// 2989
o19.JSBNG__onclick = null;
// 2992
o37.tagName = "DIV";
// 2993
o37.JSBNG__onclick = null;
// 2996
o71.tagName = "DIV";
// 2997
o71.JSBNG__onclick = null;
// 3000
o72.tagName = "DIV";
// 3001
o72.JSBNG__onclick = null;
// 3004
o28.tagName = "DIV";
// 3005
o28.JSBNG__onclick = null;
// 3008
o9.tagName = "DIV";
// 3009
o9.JSBNG__onclick = null;
// 3012
o29.tagName = "DIV";
// 3013
o29.JSBNG__onclick = null;
// 3016
o16.tagName = "BODY";
// 3017
o16.JSBNG__onclick = null;
// 3019
o6.parentNode = o0;
// 3020
o6.tagName = "HTML";
// 3021
o6.JSBNG__onclick = null;
// 3023
o0.parentNode = null;
// 3024
o113.clientX = 277;
// 3026
o16.scrollLeft = 0;
// 3028
o6.scrollLeft = 0;
// 3029
o113.clientY = 326;
// 3031
o16.scrollTop = 0;
// 3033
o6.scrollTop = 0;
// 3035
o20.nodeName = "INPUT";
// 3037
o87.nodeName = "DIV";
// 3039
o36.nodeName = "DIV";
// 3041
o70.nodeName = "DIV";
// 3043
o11.nodeName = "FIELDSET";
// 3045
o19.nodeName = "FORM";
// 3047
o37.nodeName = "DIV";
// 3049
o71.nodeName = "DIV";
// 3051
o72.nodeName = "DIV";
// 3053
o28.nodeName = "DIV";
// 3055
o9.nodeName = "DIV";
// 3057
o29.nodeName = "DIV";
// 3059
o16.nodeName = "BODY";
// 3061
o6.nodeName = "HTML";
// 3063
o0.nodeName = "#document";
// 3095
o0.tagName = void 0;
// 3097
o114 = {};
// 3099
o114.which = 1;
// 3100
o114.type = "mousedown";
// 3101
o114.srcElement = void 0;
// 3102
o114.target = o20;
// 3116
o115 = {};
// 3118
o115.which = 1;
// 3119
o115.type = "mouseup";
// 3120
o115.srcElement = void 0;
// 3121
o115.target = o20;
// 3135
o116 = {};
// 3137
o116.metaKey = false;
// 3138
o116.which = 1;
// 3140
o116.shiftKey = false;
// 3142
o116.type = "click";
// 3143
o116.srcElement = void 0;
// 3144
o116.target = o20;
// 3217
o116.clientX = 277;
// 3222
o116.clientY = 320;
// 3290
o117 = {};
// 3292
o117.which = 1;
// 3293
o117.type = "mouseout";
// 3294
o117.srcElement = void 0;
// 3295
o117.target = o20;
// 3309
o118 = {};
// 3311
o118.which = 1;
// 3312
o118.type = "mouseover";
// 3313
o118.srcElement = void 0;
// 3314
o118.target = o75;
// 3320
o119 = {};
// 3322
o119.which = 1;
// 3323
o119.type = "mouseout";
// 3324
o119.srcElement = void 0;
// 3325
o119.target = o75;
// 3331
o120 = {};
// 3333
o120.which = 1;
// 3334
o120.type = "mouseover";
// 3335
o120.srcElement = void 0;
// 3336
o120.target = o78;
// 3342
o121 = {};
// 3344
o121.which = 1;
// 3345
o121.type = "mouseout";
// 3346
o121.srcElement = void 0;
// 3347
o121.target = o78;
// 3353
o122 = {};
// 3355
o122.which = 1;
// 3356
o122.type = "mouseover";
// 3357
o122.srcElement = void 0;
// 3358
o122.target = o75;
// 3364
o123 = {};
// 3366
o123.which = 1;
// 3367
o123.type = "mouseout";
// 3368
o123.srcElement = void 0;
// 3369
o123.target = o75;
// 3375
o124 = {};
// 3377
o124.which = 1;
// 3378
o124.type = "mouseover";
// 3379
o124.srcElement = void 0;
// 3380
o124.target = o87;
// 3393
o125 = {};
// 3395
o125.which = 1;
// 3396
o125.type = "mouseout";
// 3397
o125.srcElement = void 0;
// 3398
o125.target = o87;
// 3411
o126 = {};
// 3413
o126.which = 1;
// 3414
o126.type = "mouseover";
// 3415
o126.srcElement = void 0;
// 3416
o126.target = o20;
// 3430
o127 = {};
// 3432
o127.which = 1;
// 3433
o127.type = "mousedown";
// 3434
o127.srcElement = void 0;
// 3435
o127.target = o20;
// 3449
o128 = {};
// 3451
o128.which = 1;
// 3452
o128.type = "mouseup";
// 3453
o128.srcElement = void 0;
// 3454
o128.target = o20;
// 3468
o129 = {};
// 3470
o129.metaKey = false;
// 3471
o129.which = 1;
// 3473
o129.shiftKey = false;
// 3475
o129.type = "click";
// 3476
o129.srcElement = void 0;
// 3477
o129.target = o20;
// 3550
o129.clientX = 261;
// 3555
o129.clientY = 320;
// 3623
o130 = {};
// 3625
o130.which = 84;
// 3626
o130.type = "keydown";
// 3627
o130.srcElement = void 0;
// 3628
o130.target = o20;
// 3642
o131 = {};
// 3644
o131.which = 116;
// 3645
o131.type = "keypress";
// 3646
o131.srcElement = void 0;
// 3647
o131.target = o20;
// 3664
o132 = {};
// 3666
o132.which = 72;
// 3667
o132.type = "keydown";
// 3668
o132.srcElement = void 0;
// 3669
o132.target = o20;
// 3683
o133 = {};
// 3685
o133.which = 104;
// 3686
o133.type = "keypress";
// 3687
o133.srcElement = void 0;
// 3688
o133.target = o20;
// 3705
o134 = {};
// 3707
o134.which = 73;
// 3708
o134.type = "keydown";
// 3709
o134.srcElement = void 0;
// 3710
o134.target = o20;
// 3724
o135 = {};
// 3726
o135.which = 105;
// 3727
o135.type = "keypress";
// 3728
o135.srcElement = void 0;
// 3729
o135.target = o20;
// 3746
o136 = {};
// 3748
o136.which = 83;
// 3749
o136.type = "keydown";
// 3750
o136.srcElement = void 0;
// 3751
o136.target = o20;
// 3765
o137 = {};
// 3767
o137.which = 115;
// 3768
o137.type = "keypress";
// 3769
o137.srcElement = void 0;
// 3770
o137.target = o20;
// 3787
o138 = {};
// 3789
o138.which = 32;
// 3790
o138.type = "keydown";
// 3791
o138.srcElement = void 0;
// 3792
o138.target = o20;
// 3806
o139 = {};
// 3808
o139.which = 32;
// 3809
o139.type = "keypress";
// 3810
o139.srcElement = void 0;
// 3811
o139.target = o20;
// 3828
o140 = {};
// 3830
o140.which = 73;
// 3831
o140.type = "keydown";
// 3832
o140.srcElement = void 0;
// 3833
o140.target = o20;
// 3847
o141 = {};
// 3849
o141.which = 105;
// 3850
o141.type = "keypress";
// 3851
o141.srcElement = void 0;
// 3852
o141.target = o20;
// 3869
o142 = {};
// 3871
o142.which = 83;
// 3872
o142.type = "keydown";
// 3873
o142.srcElement = void 0;
// 3874
o142.target = o20;
// 3888
o143 = {};
// 3890
o143.which = 115;
// 3891
o143.type = "keypress";
// 3892
o143.srcElement = void 0;
// 3893
o143.target = o20;
// 3910
o144 = {};
// 3912
o144.which = 32;
// 3913
o144.type = "keydown";
// 3914
o144.srcElement = void 0;
// 3915
o144.target = o20;
// 3929
o145 = {};
// 3931
o145.which = 32;
// 3932
o145.type = "keypress";
// 3933
o145.srcElement = void 0;
// 3934
o145.target = o20;
// 3951
o146 = {};
// 3953
o146.which = 65;
// 3954
o146.type = "keydown";
// 3955
o146.srcElement = void 0;
// 3956
o146.target = o20;
// 3970
o147 = {};
// 3972
o147.which = 97;
// 3973
o147.type = "keypress";
// 3974
o147.srcElement = void 0;
// 3975
o147.target = o20;
// 3992
o148 = {};
// 3994
o148.which = 32;
// 3995
o148.type = "keydown";
// 3996
o148.srcElement = void 0;
// 3997
o148.target = o20;
// 4011
o149 = {};
// 4013
o149.which = 32;
// 4014
o149.type = "keypress";
// 4015
o149.srcElement = void 0;
// 4016
o149.target = o20;
// 4033
o150 = {};
// 4035
o150.which = 84;
// 4036
o150.type = "keydown";
// 4037
o150.srcElement = void 0;
// 4038
o150.target = o20;
// 4052
o151 = {};
// 4054
o151.which = 116;
// 4055
o151.type = "keypress";
// 4056
o151.srcElement = void 0;
// 4057
o151.target = o20;
// 4074
o152 = {};
// 4076
o152.which = 69;
// 4077
o152.type = "keydown";
// 4078
o152.srcElement = void 0;
// 4079
o152.target = o20;
// 4093
o153 = {};
// 4095
o153.which = 101;
// 4096
o153.type = "keypress";
// 4097
o153.srcElement = void 0;
// 4098
o153.target = o20;
// 4115
o154 = {};
// 4117
o154.which = 83;
// 4118
o154.type = "keydown";
// 4119
o154.srcElement = void 0;
// 4120
o154.target = o20;
// 4134
o155 = {};
// 4136
o155.which = 115;
// 4137
o155.type = "keypress";
// 4138
o155.srcElement = void 0;
// 4139
o155.target = o20;
// 4156
o156 = {};
// 4158
o156.which = 84;
// 4159
o156.type = "keydown";
// 4160
o156.srcElement = void 0;
// 4161
o156.target = o20;
// 4175
o157 = {};
// 4177
o157.which = 116;
// 4178
o157.type = "keypress";
// 4179
o157.srcElement = void 0;
// 4180
o157.target = o20;
// 4197
o158 = {};
// 4199
o158.which = 32;
// 4200
o158.type = "keydown";
// 4201
o158.srcElement = void 0;
// 4202
o158.target = o20;
// 4216
o159 = {};
// 4218
o159.which = 32;
// 4219
o159.type = "keypress";
// 4220
o159.srcElement = void 0;
// 4221
o159.target = o20;
// 4238
o160 = {};
// 4240
o160.which = 79;
// 4241
o160.type = "keydown";
// 4242
o160.srcElement = void 0;
// 4243
o160.target = o20;
// 4257
o161 = {};
// 4259
o161.which = 111;
// 4260
o161.type = "keypress";
// 4261
o161.srcElement = void 0;
// 4262
o161.target = o20;
// 4279
o162 = {};
// 4281
o162.which = 70;
// 4282
o162.type = "keydown";
// 4283
o162.srcElement = void 0;
// 4284
o162.target = o20;
// 4298
o163 = {};
// 4300
o163.which = 102;
// 4301
o163.type = "keypress";
// 4302
o163.srcElement = void 0;
// 4303
o163.target = o20;
// 4320
o164 = {};
// 4322
o164.which = 32;
// 4323
o164.type = "keydown";
// 4324
o164.srcElement = void 0;
// 4325
o164.target = o20;
// 4339
o165 = {};
// 4341
o165.which = 32;
// 4342
o165.type = "keypress";
// 4343
o165.srcElement = void 0;
// 4344
o165.target = o20;
// 4361
o166 = {};
// 4363
o166.which = 71;
// 4364
o166.type = "keydown";
// 4365
o166.srcElement = void 0;
// 4366
o166.target = o20;
// 4380
o167 = {};
// 4382
o167.which = 103;
// 4383
o167.type = "keypress";
// 4384
o167.srcElement = void 0;
// 4385
o167.target = o20;
// 4402
o168 = {};
// 4404
o168.which = 79;
// 4405
o168.type = "keydown";
// 4406
o168.srcElement = void 0;
// 4407
o168.target = o20;
// 4421
o169 = {};
// 4423
o169.which = 111;
// 4424
o169.type = "keypress";
// 4425
o169.srcElement = void 0;
// 4426
o169.target = o20;
// 4443
o170 = {};
// 4445
o170.which = 79;
// 4446
o170.type = "keydown";
// 4447
o170.srcElement = void 0;
// 4448
o170.target = o20;
// 4462
o171 = {};
// 4464
o171.which = 111;
// 4465
o171.type = "keypress";
// 4466
o171.srcElement = void 0;
// 4467
o171.target = o20;
// 4484
o172 = {};
// 4486
o172.which = 71;
// 4487
o172.type = "keydown";
// 4488
o172.srcElement = void 0;
// 4489
o172.target = o20;
// 4503
o173 = {};
// 4505
o173.which = 103;
// 4506
o173.type = "keypress";
// 4507
o173.srcElement = void 0;
// 4508
o173.target = o20;
// 4525
o174 = {};
// 4527
o174.which = 76;
// 4528
o174.type = "keydown";
// 4529
o174.srcElement = void 0;
// 4530
o174.target = o20;
// 4544
o175 = {};
// 4546
o175.which = 108;
// 4547
o175.type = "keypress";
// 4548
o175.srcElement = void 0;
// 4549
o175.target = o20;
// 4566
o176 = {};
// 4568
o176.which = 69;
// 4569
o176.type = "keydown";
// 4570
o176.srcElement = void 0;
// 4571
o176.target = o20;
// 4585
o177 = {};
// 4587
o177.which = 101;
// 4588
o177.type = "keypress";
// 4589
o177.srcElement = void 0;
// 4590
o177.target = o20;
// 4607
o178 = {};
// 4609
o178.which = 32;
// 4610
o178.type = "keydown";
// 4611
o178.srcElement = void 0;
// 4612
o178.target = o20;
// 4626
o179 = {};
// 4628
o179.which = 32;
// 4629
o179.type = "keypress";
// 4630
o179.srcElement = void 0;
// 4631
o179.target = o20;
// 4648
o180 = {};
// 4650
o180.which = 65;
// 4651
o180.type = "keydown";
// 4652
o180.srcElement = void 0;
// 4653
o180.target = o20;
// 4667
o181 = {};
// 4669
o181.which = 97;
// 4670
o181.type = "keypress";
// 4671
o181.srcElement = void 0;
// 4672
o181.target = o20;
// 4689
o182 = {};
// 4691
o182.which = 85;
// 4692
o182.type = "keydown";
// 4693
o182.srcElement = void 0;
// 4694
o182.target = o20;
// 4708
o183 = {};
// 4710
o183.which = 117;
// 4711
o183.type = "keypress";
// 4712
o183.srcElement = void 0;
// 4713
o183.target = o20;
// 4730
o184 = {};
// 4732
o184.which = 84;
// 4733
o184.type = "keydown";
// 4734
o184.srcElement = void 0;
// 4735
o184.target = o20;
// 4749
o185 = {};
// 4751
o185.which = 116;
// 4752
o185.type = "keypress";
// 4753
o185.srcElement = void 0;
// 4754
o185.target = o20;
// 4771
o186 = {};
// 4773
o186.which = 79;
// 4774
o186.type = "keydown";
// 4775
o186.srcElement = void 0;
// 4776
o186.target = o20;
// 4790
o187 = {};
// 4792
o187.which = 111;
// 4793
o187.type = "keypress";
// 4794
o187.srcElement = void 0;
// 4795
o187.target = o20;
// 4812
o188 = {};
// 4814
o188.which = 67;
// 4815
o188.type = "keydown";
// 4816
o188.srcElement = void 0;
// 4817
o188.target = o20;
// 4831
o189 = {};
// 4833
o189.which = 99;
// 4834
o189.type = "keypress";
// 4835
o189.srcElement = void 0;
// 4836
o189.target = o20;
// 4853
o190 = {};
// 4855
o190.which = 79;
// 4856
o190.type = "keydown";
// 4857
o190.srcElement = void 0;
// 4858
o190.target = o20;
// 4872
o191 = {};
// 4874
o191.which = 111;
// 4875
o191.type = "keypress";
// 4876
o191.srcElement = void 0;
// 4877
o191.target = o20;
// 4894
o192 = {};
// 4896
o192.which = 77;
// 4897
o192.type = "keydown";
// 4898
o192.srcElement = void 0;
// 4899
o192.target = o20;
// 4913
o193 = {};
// 4915
o193.which = 109;
// 4916
o193.type = "keypress";
// 4917
o193.srcElement = void 0;
// 4918
o193.target = o20;
// 4935
o194 = {};
// 4937
o194.which = 80;
// 4938
o194.type = "keydown";
// 4939
o194.srcElement = void 0;
// 4940
o194.target = o20;
// 4954
o195 = {};
// 4956
o195.which = 112;
// 4957
o195.type = "keypress";
// 4958
o195.srcElement = void 0;
// 4959
o195.target = o20;
// 4976
o196 = {};
// 4978
o196.which = 76;
// 4979
o196.type = "keydown";
// 4980
o196.srcElement = void 0;
// 4981
o196.target = o20;
// 4995
o197 = {};
// 4997
o197.which = 108;
// 4998
o197.type = "keypress";
// 4999
o197.srcElement = void 0;
// 5000
o197.target = o20;
// 5017
o198 = {};
// 5019
o198.which = 69;
// 5020
o198.type = "keydown";
// 5021
o198.srcElement = void 0;
// 5022
o198.target = o20;
// 5036
o199 = {};
// 5038
o199.which = 101;
// 5039
o199.type = "keypress";
// 5040
o199.srcElement = void 0;
// 5041
o199.target = o20;
// 5058
o200 = {};
// 5060
o200.which = 84;
// 5061
o200.type = "keydown";
// 5062
o200.srcElement = void 0;
// 5063
o200.target = o20;
// 5077
o201 = {};
// 5079
o201.which = 116;
// 5080
o201.type = "keypress";
// 5081
o201.srcElement = void 0;
// 5082
o201.target = o20;
// 5099
o202 = {};
// 5101
o202.which = 69;
// 5102
o202.type = "keydown";
// 5103
o202.srcElement = void 0;
// 5104
o202.target = o20;
// 5118
o203 = {};
// 5120
o203.which = 101;
// 5121
o203.type = "keypress";
// 5122
o203.srcElement = void 0;
// 5123
o203.target = o20;
// 5140
o204 = {};
// 5142
o204.which = 1;
// 5143
o204.type = "mouseout";
// 5144
o204.srcElement = void 0;
// 5145
o204.target = o20;
// 5159
o205 = {};
// 5161
o205.which = 1;
// 5162
o205.type = "mouseover";
// 5163
o205.srcElement = void 0;
// 5164
o205.target = o87;
// 5177
o206 = {};
// 5179
o206.which = 1;
// 5180
o206.type = "mouseout";
// 5181
o206.srcElement = void 0;
// 5182
o206.target = o87;
// 5195
o207 = {};
// 5197
o207.which = 1;
// 5198
o207.type = "mouseover";
// 5199
o207.srcElement = void 0;
// 5200
o207.target = o75;
// 5206
o208 = {};
// 5208
o208.which = 1;
// 5209
o208.type = "mouseout";
// 5210
o208.srcElement = void 0;
// 5211
o208.target = o75;
// 5217
o209 = {};
// 5219
o209.which = 1;
// 5220
o209.type = "mouseover";
// 5221
o209.srcElement = void 0;
// 5222
o209.target = o78;
// 5228
o210 = {};
// 5230
o210.which = 1;
// 5231
o210.type = "mousedown";
// 5232
o210.srcElement = void 0;
// 5233
o210.target = o78;
// 5239
o211 = {};
// 5241
o211.which = void 0;
// 5242
o211.keyCode = void 0;
// 5243
o211.key = void 0;
// 5244
o211.type = "change";
// 5245
o211.srcElement = void 0;
// 5246
o211.target = o20;
// 5260
o212 = {};
// 5262
o212.which = 1;
// 5263
o212.type = "mouseup";
// 5264
o212.srcElement = void 0;
// 5265
o212.target = o78;
// 5271
o213 = {};
// 5273
o213.metaKey = false;
// 5274
o213.which = 1;
// 5276
o213.shiftKey = false;
// 5278
o213.type = "click";
// 5279
o213.srcElement = void 0;
// 5280
o213.target = o78;
// 5289
o78.tagName = "DIV";
// 5290
o78.JSBNG__onclick = null;
// 5293
o33.tagName = "CENTER";
// 5294
o33.JSBNG__onclick = null;
// 5297
o34.tagName = "SPAN";
// 5298
o34.JSBNG__onclick = null;
// 5301
o35.tagName = "DIV";
// 5302
o35.JSBNG__onclick = null;
// 5313
o213.clientX = 241;
// 5318
o213.clientY = 423;
// 5324
o78.nodeName = "DIV";
// 5326
o33.nodeName = "CENTER";
// 5328
o34.nodeName = "SPAN";
// 5330
o35.nodeName = "DIV";
// 5354
o214 = {};
// 5356
o214.which = 224;
// 5357
o214.type = "keydown";
// 5358
o214.srcElement = void 0;
// 5359
o214.target = o16;
// 5361
o215 = {};
// 5363
o215.which = 87;
// 5364
o215.type = "keydown";
// 5365
o215.srcElement = void 0;
// 5366
o215.target = o16;
// 5368
o216 = {};
// 5370
o216.which = 119;
// 5371
o216.type = "keypress";
// 5372
o216.srcElement = void 0;
// 5373
o216.target = o16;
// 5375
o16.isContentEditable = false;
// 5376
o216.ctrlKey = false;
// 5377
o216.shiftKey = false;
// 5378
o216.altKey = false;
// 5379
o216.metaKey = true;
// 5383
o217 = {};
// 5385
o217.which = 1;
// 5386
o217.type = "mouseout";
// 5387
o217.srcElement = void 0;
// 5388
o217.target = o78;
// 5394
// 0
JSBNG_Replay$ = function(real, cb) { if (!real) return;
// 820
o3.userAgent = "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.8; rv:21.0) Gecko/20100101 Firefox/21.0";
// 821
o3.userAgent = "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.8; rv:21.0) Gecko/20100101 Firefox/21.0";
// 822
o3.userAgent = "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.8; rv:21.0) Gecko/20100101 Firefox/21.0";
// 824
o3.userAgent = "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.8; rv:21.0) Gecko/20100101 Firefox/21.0";
// 829
o6.JSBNG__addEventListener = f895948954_391;
// 831
o6.JSBNG__addEventListener = f895948954_391;
// 832
o6.JSBNG__addEventListener = f895948954_391;
// 834
o6.JSBNG__addEventListener = f895948954_391;
// 835
o6.JSBNG__addEventListener = f895948954_391;
// 837
o6.JSBNG__addEventListener = f895948954_391;
// 838
o6.JSBNG__addEventListener = f895948954_391;
// 840
o6.JSBNG__addEventListener = f895948954_391;
// 841
o6.JSBNG__addEventListener = f895948954_391;
// 843
o6.JSBNG__addEventListener = f895948954_391;
// 844
o6.JSBNG__addEventListener = f895948954_391;
// 846
o6.JSBNG__addEventListener = f895948954_391;
// 847
o6.JSBNG__addEventListener = f895948954_391;
// 849
o6.JSBNG__addEventListener = f895948954_391;
// 850
o6.JSBNG__addEventListener = f895948954_391;
// 852
o6.JSBNG__addEventListener = f895948954_391;
// 853
o6.JSBNG__addEventListener = f895948954_391;
// 855
o6.JSBNG__addEventListener = f895948954_391;
// 856
o6.JSBNG__addEventListener = f895948954_391;
// 858
o6.JSBNG__addEventListener = f895948954_391;
// 859
o6.JSBNG__addEventListener = f895948954_391;
// 861
o6.JSBNG__addEventListener = f895948954_391;
// 862
o6.JSBNG__addEventListener = f895948954_391;
// 864
o6.JSBNG__addEventListener = f895948954_391;
// 865
o6.JSBNG__addEventListener = f895948954_391;
// 867
o6.JSBNG__addEventListener = f895948954_391;
// 868
o6.JSBNG__addEventListener = f895948954_391;
// 870
o6.JSBNG__addEventListener = f895948954_391;
// 871
o6.JSBNG__addEventListener = f895948954_391;
// 810
geval("(function() {\n    window.google = {\n        kEI: \"uJbdUZ3TOOKQyAHtz4D4Cg\",\n        getEI: function(a) {\n            for (var b; ((a && ((!a.getAttribute || !(b = a.getAttribute(\"eid\")))))); ) {\n                a = a.parentNode;\n            ;\n            };\n        ;\n            return ((b || google.kEI));\n        },\n        https: function() {\n            return ((\"https:\" == window.JSBNG__location.protocol));\n        },\n        kEXPI: \"17259,4000116,4002854,4004334,4004844,4004948,4004952,4005348,4005864,4005875,4006036,4006291,4006426,4006442,4006466,4006727,4007055,4007080,4007117,4007158,4007173,4007232,4007244,4007472,4007533,4007566,4007638,4007661,4007668,4007687,4007762,4007772,4007779,4007798,4007804,4007874,4007893,4007917,4008028,4008041,4008067,4008079,4008133,4008170,4008290,4008409\",\n        kCSI: {\n            e: \"17259,4000116,4002854,4004334,4004844,4004948,4004952,4005348,4005864,4005875,4006036,4006291,4006426,4006442,4006466,4006727,4007055,4007080,4007117,4007158,4007173,4007232,4007244,4007472,4007533,4007566,4007638,4007661,4007668,4007687,4007762,4007772,4007779,4007798,4007804,4007874,4007893,4007917,4008028,4008041,4008067,4008079,4008133,4008170,4008290,4008409\",\n            ei: \"uJbdUZ3TOOKQyAHtz4D4Cg\"\n        },\n        authuser: 0,\n        ml: function() {\n        \n        },\n        kHL: \"en\",\n        time: function() {\n            return (new JSBNG__Date).getTime();\n        },\n        log: function(a, b, c, l, k) {\n            var d = new JSBNG__Image, f = google.lc, e = google.li, g = \"\", h = \"gen_204\";\n            ((k && (h = k)));\n            d.JSBNG__onerror = d.JSBNG__onload = d.JSBNG__onabort = function() {\n                delete f[e];\n            };\n            f[e] = d;\n            ((((c || ((-1 != b.search(\"&ei=\"))))) || (g = ((\"&ei=\" + google.getEI(l))))));\n            c = ((c || ((((((((((((((((\"/\" + h)) + \"?atyp=i&ct=\")) + a)) + \"&cad=\")) + b)) + g)) + \"&zx=\")) + google.time()))));\n            a = /^http:/i;\n            ((((a.test(c) && google.https())) ? (google.ml(Error(\"GLMM\"), !1, {\n                src: c\n            }), delete f[e]) : (d.src = c, google.li = ((e + 1)))));\n        },\n        lc: [],\n        li: 0,\n        j: {\n            en: 1,\n            b: ((!!JSBNG__location.hash && !!JSBNG__location.hash.match(\"[#&]((q|fp)=|tbs=simg|tbs=sbi)\"))),\n            bv: 21,\n            cf: \"\",\n            pm: \"p\",\n            u: \"c9c918f0\"\n        },\n        Toolbelt: {\n        },\n        y: {\n        },\n        x: function(a, b) {\n            google.y[a.id] = [a,b,];\n            return !1;\n        },\n        load: function(a, b) {\n            google.x({\n                id: ((a + m++))\n            }, function() {\n                google.load(a, b);\n            });\n        }\n    };\n    var m = 0;\n    window.JSBNG__onpopstate = function() {\n        google.j.psc = 1;\n    };\n    ((window.chrome || (window.chrome = {\n    })));\n    window.chrome.sv = 2;\n    ((window.chrome.searchBox || (window.chrome.searchBox = {\n    })));\n    var n = function() {\n        google.x({\n            id: \"psyapi\"\n        }, function() {\n            var a = encodeURIComponent(window.chrome.searchBox.value);\n            google.nav.search({\n                q: a,\n                sourceid: \"chrome-psyapi2\"\n            });\n        });\n    };\n    window.chrome.searchBox.JSBNG__onsubmit = n;\n})();\n(function() {\n    google.sn = \"webhp\";\n    google.timers = {\n    };\n    google.startTick = function(a, b) {\n        google.timers[a] = {\n            t: {\n                start: google.time()\n            },\n            bfr: !!b\n        };\n    };\n    google.tick = function(a, b, g) {\n        ((google.timers[a] || google.startTick(a)));\n        google.timers[a].t[b] = ((g || google.time()));\n    };\n    google.startTick(\"load\", !0);\n    try {\n        google.pt = ((window.gtbExternal && window.gtbExternal.pageT()));\n    } catch (d) {\n    \n    };\n;\n})();\n(function() {\n    \"use strict\";\n    var c = this, g = ((JSBNG__Date.now || function() {\n        return +new JSBNG__Date;\n    }));\n    var m = function(d, k) {\n        return function(a) {\n            ((a || (a = window.JSBNG__event)));\n            return k.call(d, a);\n        };\n    }, t = ((((\"undefined\" != typeof JSBNG__navigator)) && /Macintosh/.test(JSBNG__navigator.userAgent))), u = ((((((\"undefined\" != typeof JSBNG__navigator)) && !/Opera/.test(JSBNG__navigator.userAgent))) && /WebKit/.test(JSBNG__navigator.userAgent))), v = ((((((\"undefined\" != typeof JSBNG__navigator)) && !/Opera|WebKit/.test(JSBNG__navigator.userAgent))) && /Gecko/.test(JSBNG__navigator.product))), x = ((v ? \"keypress\" : \"keydown\"));\n    var y = function() {\n        this.g = [];\n        this.a = [];\n        this.e = {\n        };\n        this.d = null;\n        this.c = [];\n    }, z = ((((\"undefined\" != typeof JSBNG__navigator)) && /iPhone|iPad|iPod/.test(JSBNG__navigator.userAgent))), A = /\\s*;\\s*/, B = function(d, k) {\n        return ((window.top.JSBNG_Replay.push)((window.top.JSBNG_Replay.scee579e12329888b8b29697b3debcf1653f58642_22), function(a) {\n            var b;\n            i:\n            {\n                b = k;\n                if (((((\"click\" == b)) && ((((((((((t && a.metaKey)) || ((!t && a.ctrlKey)))) || ((2 == a.which)))) || ((((null == a.which)) && ((4 == a.button)))))) || a.shiftKey))))) b = \"clickmod\";\n                 else {\n                    var e = ((((a.which || a.keyCode)) || a.key)), f;\n                    if (f = ((a.type == x))) {\n                        f = ((a.srcElement || a.target));\n                        var n = f.tagName.toUpperCase();\n                        f = ((((!((((((((((\"TEXTAREA\" == n)) || ((\"BUTTON\" == n)))) || ((\"INPUT\" == n)))) || ((\"A\" == n)))) || f.isContentEditable)) && !((((((a.ctrlKey || a.shiftKey)) || a.altKey)) || a.metaKey)))) && ((((((13 == e)) || ((32 == e)))) || ((u && ((3 == e))))))));\n                    }\n                ;\n                ;\n                    ((f && (b = \"clickkey\")));\n                }\n            ;\n            ;\n                for (f = e = ((a.srcElement || a.target)); ((f && ((f != this)))); f = f.parentNode) {\n                    var n = f, l;\n                    var h = n;\n                    l = b;\n                    var p = h.__jsaction;\n                    if (!p) {\n                        p = {\n                        };\n                        h.__jsaction = p;\n                        var r = null;\n                        ((((\"getAttribute\" in h)) && (r = h.getAttribute(\"jsaction\"))));\n                        if (h = r) {\n                            for (var h = h.split(A), r = 0, P = ((h ? h.length : 0)); ((r < P)); r++) {\n                                var q = h[r];\n                                if (q) {\n                                    var w = q.indexOf(\":\"), H = ((-1 != w)), Q = ((H ? q.substr(0, w).replace(/^\\s+/, \"\").replace(/\\s+$/, \"\") : \"click\")), q = ((H ? q.substr(((w + 1))).replace(/^\\s+/, \"\").replace(/\\s+$/, \"\") : q));\n                                    p[Q] = q;\n                                }\n                            ;\n                            ;\n                            };\n                        }\n                    ;\n                    ;\n                    }\n                ;\n                ;\n                    h = void 0;\n                    ((((\"clickkey\" == l)) ? l = \"click\" : ((((\"click\" == l)) && (h = ((p.click || p.clickonly)))))));\n                    l = (((h = ((h || p[l]))) ? {\n                        h: l,\n                        action: h\n                    } : void 0));\n                    if (l) {\n                        b = {\n                            eventType: l.h,\n                            JSBNG__event: a,\n                            targetElement: e,\n                            action: l.action,\n                            actionElement: n\n                        };\n                        break i;\n                    }\n                ;\n                ;\n                };\n            ;\n                b = null;\n            };\n        ;\n            if (b) {\n                if (((a.stopPropagation ? a.stopPropagation() : a.cancelBubble = !0)), ((((((\"A\" == b.actionElement.tagName)) && ((\"click\" == k)))) && ((a.preventDefault ? a.preventDefault() : a.returnValue = !1)))), d.d) d.d(b);\n                 else {\n                    var s;\n                    if ((((((e = c.JSBNG__document) && !e.createEvent)) && e.createEventObject))) {\n                        try {\n                            s = e.createEventObject(a);\n                        } catch (U) {\n                            s = a;\n                        };\n                    }\n                     else {\n                        s = a;\n                    }\n                ;\n                ;\n                    ((v && (s.timeStamp = g())));\n                    b.JSBNG__event = s;\n                    d.c.push(b);\n                }\n            ;\n            }\n        ;\n        ;\n        }));\n    }, C = function(d, k) {\n        return function(a) {\n            var b = d, e = k, f = !1;\n            if (a.JSBNG__addEventListener) {\n                if (((((\"JSBNG__focus\" == b)) || ((\"JSBNG__blur\" == b))))) {\n                    f = !0;\n                }\n            ;\n            ;\n                a.JSBNG__addEventListener(b, e, f);\n            }\n             else ((a.JSBNG__attachEvent && (((((\"JSBNG__focus\" == b)) ? b = \"focusin\" : ((((\"JSBNG__blur\" == b)) && (b = \"focusout\"))))), e = m(a, e), a.JSBNG__attachEvent(((\"JSBNG__on\" + b)), e))));\n        ;\n        ;\n            return {\n                h: b,\n                i: e,\n                capture: f\n            };\n        };\n    }, D = function(d, k) {\n        if (!d.e.hasOwnProperty(k)) {\n            var a = B(d, k), b = C(k, a);\n            d.e[k] = a;\n            d.g.push(b);\n            for (a = 0; ((a < d.a.length)); ++a) {\n                var e = d.a[a];\n                e.c.push(b.call(null, e.a));\n            };\n        ;\n            ((((\"click\" == k)) && D(d, x)));\n        }\n    ;\n    ;\n    };\n    y.prototype.i = function(d) {\n        return this.e[d];\n    };\n    var F = function() {\n        this.a = E;\n        this.c = [];\n    };\n    var G = new y, E = window.JSBNG__document.documentElement, I;\n    i:\n    {\n        for (var J = 0; ((J < G.a.length)); J++) {\n            for (var K = G.a[J].a, L = E; ((((K != L)) && L.parentNode)); ) {\n                L = L.parentNode;\n            ;\n            };\n        ;\n            if (((K == L))) {\n                I = !0;\n                break i;\n            }\n        ;\n        ;\n        };\n    ;\n        I = !1;\n    };\n;\n    if (!I) {\n        ((z && (E.style.cursor = \"pointer\")));\n        for (var M = new F, N = 0; ((N < G.g.length)); ++N) {\n            M.c.push(G.g[N].call(null, M.a));\n        ;\n        };\n    ;\n        G.a.push(M);\n    }\n;\n;\n    D(G, \"click\");\n    D(G, \"JSBNG__focus\");\n    D(G, \"focusin\");\n    D(G, \"JSBNG__blur\");\n    D(G, \"focusout\");\n    D(G, \"change\");\n    D(G, \"keydown\");\n    D(G, \"keypress\");\n    D(G, \"mousedown\");\n    D(G, \"mouseout\");\n    D(G, \"mouseover\");\n    D(G, \"mouseup\");\n    D(G, \"touchstart\");\n    D(G, \"touchmove\");\n    D(G, \"touchend\");\n    var O = function(d) {\n        G.d = d;\n        ((G.c && (((((0 < G.c.length)) && d(G.c))), G.c = null)));\n    }, R = [\"google\",\"jsad\",], S = c;\n    ((((((R[0] in S)) || !S.execScript)) || S.execScript(((\"var \" + R[0])))));\n    for (var T; ((R.length && (T = R.shift()))); ) {\n        ((((R.length || ((void 0 === O)))) ? S = ((S[T] ? S[T] : S[T] = {\n        })) : S[T] = O));\n    ;\n    };\n;\n}).call(window);\ngoogle.arwt = function(a) {\n    a.href = JSBNG__document.getElementById(a.id.substring(1)).href;\n    return !0;\n};");
// 880
ow895948954.JSBNG__innerHeight = 603;
// 881
ow895948954.JSBNG__innerHeight = 603;
// 882
ow895948954.JSBNG__innerWidth = 994;
// 883
ow895948954.JSBNG__innerWidth = 994;
// 887
o0.getElementById = f895948954_393;
// 889
ow895948954.JSBNG__innerHeight = 603;
// 890
ow895948954.JSBNG__innerHeight = 603;
// 891
ow895948954.JSBNG__innerWidth = 994;
// 892
ow895948954.JSBNG__innerWidth = 994;
// 893
o0.getElementById = f895948954_393;
// 895
o0.getElementById = f895948954_393;
// 897
o0.getElementById = f895948954_393;
// 899
o0.getElementById = f895948954_393;
// 901
o0.getElementById = f895948954_393;
// 903
o0.getElementById = f895948954_393;
// 905
o0.getElementById = f895948954_393;
// 907
o0.getElementById = f895948954_393;
// 909
o0.getElementById = f895948954_393;
// 911
o0.getElementById = f895948954_393;
// 913
o0.getElementById = f895948954_393;
// 915
o0.getElementById = f895948954_393;
// 917
o0.getElementById = f895948954_393;
// 919
o0.getElementById = f895948954_393;
// 921
o0.getElementById = f895948954_393;
// 923
o0.getElementById = f895948954_393;
// 925
o0.getElementById = f895948954_393;
// 927
o0.getElementById = f895948954_393;
// 929
o0.getElementById = f895948954_393;
// 931
o0.getElementById = f895948954_393;
// 933
o0.getElementById = f895948954_393;
// 935
o0.getElementById = f895948954_393;
// 937
o0.getElementById = f895948954_393;
// 939
o0.getElementById = f895948954_393;
// 941
o0.getElementById = f895948954_393;
// 943
o0.getElementById = f895948954_393;
// 945
o0.getElementById = f895948954_393;
// 948
o0.getElementById = f895948954_393;
// 950
o0.getElementById = f895948954_393;
// 873
geval("var _gjwl = JSBNG__location;\nfunction _gjuc() {\n    var a = _gjwl.href.indexOf(\"#\");\n    return ((((((0 <= a)) && (a = _gjwl.href.substring(((a + 1))), ((((/(^|&)q=/.test(a) && ((-1 == a.indexOf(\"#\"))))) && !/(^|&)cad=h($|&)/.test(a)))))) ? (_gjwl.replace(((((\"/search?\" + a.replace(/(^|&)fp=[^&]*/g, \"\"))) + \"&cad=h\"))), 1) : 0));\n};\n;\nfunction _gjp() {\n    ((((window._gjwl.hash && window._gjuc())) || JSBNG__setTimeout(_gjp, 500)));\n};\n;\n;\nwindow.rwt = function(a, g, h, m, n, i, c, o, j, d) {\n    return true;\n};\n(function() {\n    try {\n        var e = !0, h = null, k = !1;\n        var ba = function(a, b, c, d) {\n            d = ((d || {\n            }));\n            d._sn = [\"cfg\",b,c,].join(\".\");\n            window.gbar.logger.ml(a, d);\n        };\n        var n = window.gbar = ((window.gbar || {\n        })), q = window.gbar.i = ((window.gbar.i || {\n        })), ca;\n        function _tvn(a, b) {\n            var c = parseInt(a, 10);\n            return ((isNaN(c) ? b : c));\n        };\n    ;\n        function _tvf(a, b) {\n            var c = parseFloat(a);\n            return ((isNaN(c) ? b : c));\n        };\n    ;\n        function _tvv(a) {\n            return !!a;\n        };\n    ;\n        function r(a, b, c) {\n            ((c || n))[a] = b;\n        };\n    ;\n        n.bv = {\n            n: _tvn(\"2\", 0),\n            r: \"r_qf.\",\n            f: \".36.40.65.70.\",\n            e: \"0\",\n            m: _tvn(\"2\", 1)\n        };\n        function da(a, b, c) {\n            var d = ((\"JSBNG__on\" + b));\n            if (a.JSBNG__addEventListener) {\n                a.JSBNG__addEventListener(b, c, k);\n            }\n             else {\n                if (a.JSBNG__attachEvent) a.JSBNG__attachEvent(d, c);\n                 else {\n                    var g = a[d];\n                    a[d] = function() {\n                        var a = g.apply(this, arguments), b = c.apply(this, arguments);\n                        return ((((void 0 == a)) ? b : ((((void 0 == b)) ? a : ((b && a))))));\n                    };\n                }\n            ;\n            }\n        ;\n        ;\n        };\n    ;\n        var ea = function(a) {\n            return function() {\n                return ((n.bv.m == a));\n            };\n        }, fa = ea(1), ga = ea(2);\n        r(\"sb\", fa);\n        r(\"kn\", ga);\n        q.a = _tvv;\n        q.b = _tvf;\n        q.c = _tvn;\n        q.i = ba;\n        var t = window.gbar.i.i;\n        var u = function() {\n        \n        }, v = function() {\n        \n        }, w = function(a) {\n            var b = new JSBNG__Image, c = ha;\n            b.JSBNG__onerror = b.JSBNG__onload = b.JSBNG__onabort = function() {\n                try {\n                    delete ia[c];\n                } catch (a) {\n                \n                };\n            ;\n            };\n            ia[c] = b;\n            b.src = a;\n            ha = ((c + 1));\n        }, ia = [], ha = 0;\n        r(\"logger\", {\n            il: v,\n            ml: u,\n            log: w\n        });\n        var x = window.gbar.logger;\n        var y = {\n        }, ja = {\n        }, z = [], ka = q.b(\"0.1\", 1479), la = q.a(\"1\", e), ma = function(a, b) {\n            z.push([a,b,]);\n        }, na = function(a, b) {\n            y[a] = b;\n        }, oa = function(a) {\n            return ((a in y));\n        }, A = {\n        }, C = function(a, b) {\n            ((A[a] || (A[a] = [])));\n            A[a].push(b);\n        }, D = function(a) {\n            C(\"m\", a);\n        }, pa = function(a, b) {\n            var c = JSBNG__document.createElement(\"script\");\n            c.src = a;\n            c.async = la;\n            ((((Math.JSBNG__random() < ka)) && (c.JSBNG__onerror = function() {\n                c.JSBNG__onerror = h;\n                u(Error(((((((\"Bundle load failed: name=\" + ((b || \"UNK\")))) + \" url=\")) + a))));\n            })));\n            ((JSBNG__document.getElementById(\"xjsc\") || JSBNG__document.body)).appendChild(c);\n        }, G = function(a) {\n            for (var b = 0, c; (((c = z[b]) && ((c[0] != a)))); ++b) {\n            ;\n            };\n        ;\n            ((((c && ((!c[1].l && !c[1].s)))) && (c[1].s = e, E(2, a), ((c[1].url && pa(c[1].url, a))), ((((c[1].libs && F)) && F(c[1].libs))))));\n        }, qa = function(a) {\n            C(\"gc\", a);\n        }, H = h, ra = function(a) {\n            H = a;\n        }, E = function(a, b, c) {\n            if (H) {\n                a = {\n                    t: a,\n                    b: b\n                };\n                if (c) {\n                    {\n                        var fin0keys = ((window.top.JSBNG_Replay.forInKeys)((c))), fin0i = (0);\n                        var d;\n                        for (; (fin0i < fin0keys.length); (fin0i++)) {\n                            ((d) = (fin0keys[fin0i]));\n                            {\n                                a[d] = c[d];\n                            ;\n                            };\n                        };\n                    };\n                }\n            ;\n            ;\n                try {\n                    H(a);\n                } catch (g) {\n                \n                };\n            ;\n            }\n        ;\n        ;\n        };\n        r(\"mdc\", y);\n        r(\"mdi\", ja);\n        r(\"bnc\", z);\n        r(\"qGC\", qa);\n        r(\"qm\", D);\n        r(\"qd\", A);\n        r(\"lb\", G);\n        r(\"mcf\", na);\n        r(\"bcf\", ma);\n        r(\"aq\", C);\n        r(\"mdd\", \"\");\n        r(\"has\", oa);\n        r(\"trh\", ra);\n        r(\"tev\", E);\n        if (q.a(\"1\")) {\n            var I = q.a(\"1\"), sa = q.a(\"\"), ta = q.a(\"\"), ua = window.gapi = {\n            }, va = function(a, b) {\n                var c = function() {\n                    n.dgl(a, b);\n                };\n                ((I ? D(c) : (C(\"gl\", c), G(\"gl\"))));\n            }, wa = {\n            }, xa = function(a) {\n                a = a.split(\":\");\n                for (var b; (((b = a.pop()) && wa[b])); ) {\n                ;\n                };\n            ;\n                return !b;\n            }, F = function(a) {\n                function b() {\n                    for (var b = a.split(\":\"), d = 0, g; g = b[d]; ++d) {\n                        wa[g] = 1;\n                    ;\n                    };\n                ;\n                    for (b = 0; d = z[b]; ++b) {\n                        d = d[1], (((((g = d.libs) && ((((!d.l && d.i)) && xa(g))))) && d.i()));\n                    ;\n                    };\n                ;\n                };\n            ;\n                n.dgl(a, b);\n            }, J = window.___jsl = {\n            };\n            J.h = \"m;/_/scs/abc-static/_/js/k=gapi.gapi.en.aBqw11eoBzM.O/m=__features__/am=EA/rt=j/d=1/rs=AItRSTMkiisOVRW5P7l3Ig59NtxV0JdMMA\";\n            J.ms = \"http://jsbngssl.apis.google.com\";\n            J.m = \"\";\n            J.l = [];\n            ((I || z.push([\"gl\",{\n                url: \"//ssl.gstatic.com/gb/js/abc/glm_e7bb39a7e1a24581ff4f8d199678b1b9.js\"\n            },])));\n            var ya = {\n                pu: sa,\n                sh: \"\",\n                si: ta\n            };\n            y.gl = ya;\n            r(\"load\", va, ua);\n            r(\"dgl\", va);\n            r(\"agl\", xa);\n            q.o = I;\n        }\n    ;\n    ;\n    ;\n        var za = q.b(\"0.1\", 3118), Aa = 0;\n        function _mlToken(a, b) {\n            try {\n                if (((1 > Aa))) {\n                    Aa++;\n                    var c, d = a, g = ((b || {\n                    })), f = encodeURIComponent, m = \"es_plusone_gc_20130619.0_p0\", l = [\"//www.google.com/gen_204?atyp=i&zx=\",(new JSBNG__Date).getTime(),\"&jexpid=\",f(\"37102\"),\"&srcpg=\",f(\"prop=1\"),\"&jsr=\",Math.round(((1 / za))),\"&ogev=\",f(\"uJbdUZ3sONTYyAHI-IHoCA\"),\"&ogf=\",n.bv.f,\"&ogrp=\",f(\"\"),\"&ogv=\",f(\"1372717546.1372341082\"),((m ? ((\"&oggv=\" + f(m))) : \"\")),\"&ogd=\",f(\"com\"),\"&ogl=\",f(\"en\"),];\n                    ((g._sn && (g._sn = ((\"og.\" + g._sn)))));\n                    {\n                        var fin1keys = ((window.top.JSBNG_Replay.forInKeys)((g))), fin1i = (0);\n                        var p;\n                        for (; (fin1i < fin1keys.length); (fin1i++)) {\n                            ((p) = (fin1keys[fin1i]));\n                            {\n                                l.push(\"&\"), l.push(f(p)), l.push(\"=\"), l.push(f(g[p]));\n                            ;\n                            };\n                        };\n                    };\n                ;\n                    l.push(\"&emsg=\");\n                    l.push(f(((((d.JSBNG__name + \":\")) + d.message))));\n                    var s = l.join(\"\");\n                    ((Ba(s) && (s = s.substr(0, 2000))));\n                    c = s;\n                    var B = window.gbar.logger._aem(a, c);\n                    w(B);\n                }\n            ;\n            ;\n            } catch (Y) {\n            \n            };\n        ;\n        };\n    ;\n        var Ba = function(a) {\n            return ((2000 <= a.length));\n        }, Da = function(a, b) {\n            return b;\n        };\n        function Ga(a) {\n            u = a;\n            r(\"_itl\", Ba, x);\n            r(\"_aem\", Da, x);\n            r(\"ml\", u, x);\n            a = {\n            };\n            y.er = a;\n        };\n    ;\n        ((q.a(\"\") ? Ga(function(a) {\n            throw a;\n        }) : ((((q.a(\"1\") && ((Math.JSBNG__random() < za)))) && Ga(_mlToken)))));\n        var _E = \"left\", L = function(a, b) {\n            var c = a.className;\n            ((K(a, b) || (a.className += ((((((\"\" != c)) ? \" \" : \"\")) + b)))));\n        }, M = function(a, b) {\n            var c = a.className, d = RegExp(((((\"\\\\s?\\\\b\" + b)) + \"\\\\b\")));\n            ((((c && c.match(d))) && (a.className = c.replace(d, \"\"))));\n        }, K = function(a, b) {\n            var c = RegExp(((((\"\\\\b\" + b)) + \"\\\\b\"))), d = a.className;\n            return !((!d || !d.match(c)));\n        }, Ha = function(a, b) {\n            ((K(a, b) ? M(a, b) : L(a, b)));\n        };\n        r(\"ca\", L);\n        r(\"cr\", M);\n        r(\"cc\", K);\n        q.k = L;\n        q.l = M;\n        q.m = K;\n        q.n = Ha;\n        var Ia = [\"gb_71\",\"gb_155\",], N;\n        function Ja(a) {\n            N = a;\n        };\n    ;\n        function Ka(a) {\n            var b = ((((N && !a.href.match(/.*\\/accounts\\/ClearSID[?]/))) && encodeURIComponent(N())));\n            ((b && (a.href = a.href.replace(/([?&]continue=)[^&]*/, ((\"$1\" + b))))));\n        };\n    ;\n        function La(a) {\n            ((window.gApplication && (a.href = window.gApplication.getTabUrl(a.href))));\n        };\n    ;\n        function Ma(a) {\n            try {\n                var b = ((JSBNG__document.forms[0].q || \"\")).value;\n                ((b && (a.href = a.href.replace(/([?&])q=[^&]*|$/, function(a, c) {\n                    return ((((((c || \"&\")) + \"q=\")) + encodeURIComponent(b)));\n                }))));\n            } catch (c) {\n                t(c, \"sb\", \"pq\");\n            };\n        ;\n        };\n    ;\n        var Na = function() {\n            for (var a = [], b = 0, c; c = Ia[b]; ++b) {\n                (((c = JSBNG__document.getElementById(c)) && a.push(c)));\n            ;\n            };\n        ;\n            return a;\n        }, Oa = function() {\n            var a = Na();\n            return ((((0 < a.length)) ? a[0] : h));\n        }, Pa = function() {\n            return JSBNG__document.getElementById(\"gb_70\");\n        }, O = {\n        }, P = {\n        }, Qa = {\n        }, Q = {\n        }, R = void 0, Va = function(a, b) {\n            try {\n                var c = JSBNG__document.getElementById(\"gb\");\n                L(c, \"gbpdjs\");\n                S();\n                ((Ra(JSBNG__document.getElementById(\"gb\")) && L(c, \"gbrtl\")));\n                if (((b && b.getAttribute))) {\n                    var d = b.getAttribute(\"aria-owns\");\n                    if (d.length) {\n                        var g = JSBNG__document.getElementById(d);\n                        if (g) {\n                            var f = b.parentNode;\n                            if (((R == d))) R = void 0, M(f, \"gbto\");\n                             else {\n                                if (R) {\n                                    var m = JSBNG__document.getElementById(R);\n                                    if (((m && m.getAttribute))) {\n                                        var l = m.getAttribute(\"aria-owner\");\n                                        if (l.length) {\n                                            var p = JSBNG__document.getElementById(l);\n                                            ((((p && p.parentNode)) && M(p.parentNode, \"gbto\")));\n                                        }\n                                    ;\n                                    ;\n                                    }\n                                ;\n                                ;\n                                }\n                            ;\n                            ;\n                                ((Sa(g) && Ta(g)));\n                                R = d;\n                                L(f, \"gbto\");\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                    }\n                ;\n                ;\n                }\n            ;\n            ;\n                D(function() {\n                    n.tg(a, b, e);\n                });\n                Ua(a);\n            } catch (s) {\n                t(s, \"sb\", \"tg\");\n            };\n        ;\n        }, Wa = function(a) {\n            D(function() {\n                n.close(a);\n            });\n        }, Xa = function(a) {\n            D(function() {\n                n.rdd(a);\n            });\n        }, Ra = function(a) {\n            var b, c = \"direction\", d = JSBNG__document.defaultView;\n            ((((d && d.JSBNG__getComputedStyle)) ? (((a = d.JSBNG__getComputedStyle(a, \"\")) && (b = a[c]))) : b = ((a.currentStyle ? a.currentStyle[c] : a.style[c]))));\n            return ((\"rtl\" == b));\n        }, Za = function(a, b, c) {\n            if (a) {\n                try {\n                    var d = JSBNG__document.getElementById(\"gbd5\");\n                    if (d) {\n                        var g = d.firstChild, f = g.firstChild, m = JSBNG__document.createElement(\"li\");\n                        m.className = ((b + \" gbmtc\"));\n                        m.id = c;\n                        a.className = \"gbmt\";\n                        m.appendChild(a);\n                        if (f.hasChildNodes()) {\n                            c = [[\"gbkc\",],[\"gbf\",\"gbe\",\"gbn\",],[\"gbkp\",],[\"gbnd\",],];\n                            for (var d = 0, l = f.childNodes.length, g = k, p = -1, s = 0, B; B = c[s]; s++) {\n                                for (var Y = 0, $; $ = B[Y]; Y++) {\n                                    for (; ((((d < l)) && K(f.childNodes[d], $))); ) {\n                                        d++;\n                                    ;\n                                    };\n                                ;\n                                    if ((($ == b))) {\n                                        f.insertBefore(m, ((f.childNodes[d] || h)));\n                                        g = e;\n                                        break;\n                                    }\n                                ;\n                                ;\n                                };\n                            ;\n                                if (g) {\n                                    if (((((d + 1)) < f.childNodes.length))) {\n                                        var Ca = f.childNodes[((d + 1))];\n                                        ((((!K(Ca.firstChild, \"gbmh\") && !Ya(Ca, B))) && (p = ((d + 1)))));\n                                    }\n                                     else if (((0 <= ((d - 1))))) {\n                                        var Ea = f.childNodes[((d - 1))];\n                                        ((((!K(Ea.firstChild, \"gbmh\") && !Ya(Ea, B))) && (p = d)));\n                                    }\n                                    \n                                ;\n                                ;\n                                    break;\n                                }\n                            ;\n                            ;\n                                ((((((0 < d)) && ((((d + 1)) < l)))) && d++));\n                            };\n                        ;\n                            if (((0 <= p))) {\n                                var aa = JSBNG__document.createElement(\"li\"), Fa = JSBNG__document.createElement(\"div\");\n                                aa.className = \"gbmtc\";\n                                Fa.className = \"gbmt gbmh\";\n                                aa.appendChild(Fa);\n                                f.insertBefore(aa, f.childNodes[p]);\n                            }\n                        ;\n                        ;\n                            ((n.addHover && n.addHover(a)));\n                        }\n                         else f.appendChild(m);\n                    ;\n                    ;\n                    }\n                ;\n                ;\n                } catch (xb) {\n                    t(xb, \"sb\", \"al\");\n                };\n            }\n        ;\n        ;\n        }, Ya = function(a, b) {\n            for (var c = b.length, d = 0; ((d < c)); d++) {\n                if (K(a, b[d])) {\n                    return e;\n                }\n            ;\n            ;\n            };\n        ;\n            return k;\n        }, $a = function(a, b, c) {\n            Za(a, b, c);\n        }, ab = function(a, b) {\n            Za(a, \"gbe\", b);\n        }, bb = function() {\n            D(function() {\n                ((n.pcm && n.pcm()));\n            });\n        }, cb = function() {\n            D(function() {\n                ((n.pca && n.pca()));\n            });\n        }, db = function(a, b, c, d, g, f, m, l, p, s) {\n            D(function() {\n                ((n.paa && n.paa(a, b, c, d, g, f, m, l, p, s)));\n            });\n        }, eb = function(a, b) {\n            ((O[a] || (O[a] = [])));\n            O[a].push(b);\n        }, fb = function(a, b) {\n            ((P[a] || (P[a] = [])));\n            P[a].push(b);\n        }, gb = function(a, b) {\n            Qa[a] = b;\n        }, hb = function(a, b) {\n            ((Q[a] || (Q[a] = [])));\n            Q[a].push(b);\n        }, Ua = function(a) {\n            ((a.preventDefault && a.preventDefault()));\n            a.returnValue = k;\n            a.cancelBubble = e;\n        }, ib = h, Ta = function(a, b) {\n            S();\n            if (a) {\n                jb(a, \"Opening&hellip;\");\n                T(a, e);\n                var c = ((((\"undefined\" != typeof b)) ? b : 10000)), d = function() {\n                    kb(a);\n                };\n                ib = window.JSBNG__setTimeout(d, c);\n            }\n        ;\n        ;\n        }, lb = function(a) {\n            S();\n            ((a && (T(a, k), jb(a, \"\"))));\n        }, kb = function(a) {\n            try {\n                S();\n                var b = ((a || JSBNG__document.getElementById(R)));\n                ((b && (jb(b, \"This service is currently unavailable.%1$sPlease try again later.\", \"%1$s\"), T(b, e))));\n            } catch (c) {\n                t(c, \"sb\", \"sdhe\");\n            };\n        ;\n        }, jb = function(a, b, c) {\n            if (((a && b))) {\n                var d = Sa(a);\n                if (d) {\n                    if (c) {\n                        d.innerHTML = \"\";\n                        b = b.split(c);\n                        c = 0;\n                        for (var g; g = b[c]; c++) {\n                            var f = JSBNG__document.createElement(\"div\");\n                            f.innerHTML = g;\n                            d.appendChild(f);\n                        };\n                    ;\n                    }\n                     else d.innerHTML = b;\n                ;\n                ;\n                    T(a, e);\n                }\n            ;\n            ;\n            }\n        ;\n        ;\n        }, T = function(a, b) {\n            var c = ((((void 0 !== b)) ? b : e));\n            ((c ? L(a, \"gbmsgo\") : M(a, \"gbmsgo\")));\n        }, Sa = function(a) {\n            for (var b = 0, c; c = a.childNodes[b]; b++) {\n                if (K(c, \"gbmsg\")) {\n                    return c;\n                }\n            ;\n            ;\n            };\n        ;\n        }, S = function() {\n            ((ib && window.JSBNG__clearTimeout(ib)));\n        }, mb = function(a) {\n            var b = ((\"JSBNG__inner\" + a));\n            a = ((\"offset\" + a));\n            return ((window[b] ? window[b] : ((((JSBNG__document.documentElement && JSBNG__document.documentElement[a])) ? JSBNG__document.documentElement[a] : 0))));\n        }, nb = function() {\n            return k;\n        }, ob = function() {\n            return !!R;\n        };\n        r(\"so\", Oa);\n        r(\"sos\", Na);\n        r(\"si\", Pa);\n        r(\"tg\", Va);\n        r(\"close\", Wa);\n        r(\"rdd\", Xa);\n        r(\"addLink\", $a);\n        r(\"addExtraLink\", ab);\n        r(\"pcm\", bb);\n        r(\"pca\", cb);\n        r(\"paa\", db);\n        r(\"ddld\", Ta);\n        r(\"ddrd\", lb);\n        r(\"dderr\", kb);\n        r(\"rtl\", Ra);\n        r(\"op\", ob);\n        r(\"bh\", O);\n        r(\"abh\", eb);\n        r(\"dh\", P);\n        r(\"adh\", fb);\n        r(\"ch\", Q);\n        r(\"ach\", hb);\n        r(\"eh\", Qa);\n        r(\"aeh\", gb);\n        ca = ((q.a(\"\") ? La : Ma));\n        r(\"qs\", ca);\n        r(\"setContinueCb\", Ja);\n        r(\"pc\", Ka);\n        r(\"bsy\", nb);\n        q.d = Ua;\n        q.j = mb;\n        var pb = {\n        };\n        y.base = pb;\n        z.push([\"m\",{\n            url: \"//ssl.gstatic.com/gb/js/sem_a0af21c60b0dddc27b96d9294b7d5d8f.js\"\n        },]);\n        n.sg = {\n            c: \"1\"\n        };\n        r(\"wg\", {\n            rg: {\n            }\n        });\n        var qb = {\n            tiw: q.c(\"15000\", 0),\n            tie: q.c(\"30000\", 0)\n        };\n        y.wg = qb;\n        var rb = {\n            thi: q.c(\"10000\", 0),\n            thp: q.c(\"180000\", 0),\n            tho: q.c(\"5000\", 0),\n            tet: q.b(\"0.5\", 0)\n        };\n        y.wm = rb;\n        if (q.a(\"1\")) {\n            var sb = q.a(\"\");\n            z.push([\"gc\",{\n                auto: sb,\n                url: \"//ssl.gstatic.com/gb/js/abc/gci_91f30755d6a6b787dcc2a4062e6e9824.js\",\n                libs: \"googleapis.client:plusone\"\n            },]);\n            var tb = {\n                version: \"gci_91f30755d6a6b787dcc2a4062e6e9824.js\",\n                index: \"\",\n                lang: \"en\"\n            };\n            y.gc = tb;\n            var ub = function(a) {\n                ((((window.googleapis && window.iframes)) ? ((a && a())) : (((a && qa(a))), G(\"gc\"))));\n            };\n            r(\"lGC\", ub);\n            ((q.a(\"1\") && r(\"lPWF\", ub)));\n        }\n    ;\n    ;\n    ;\n        window.__PVT = \"\";\n        if (((q.a(\"1\") && q.a(\"1\")))) {\n            var vb = function(a) {\n                ub(function() {\n                    C(\"pw\", a);\n                    G(\"pw\");\n                });\n            };\n            r(\"lPW\", vb);\n            z.push([\"pw\",{\n                url: \"//ssl.gstatic.com/gb/js/abc/pwm_45f73e4df07a0e388b0fa1f3d30e7280.js\"\n            },]);\n            var wb = [], yb = function(a) {\n                wb[0] = a;\n            }, zb = function(a, b) {\n                var c = ((b || {\n                }));\n                c._sn = \"pw\";\n                u(a, c);\n            }, Ab = {\n                signed: wb,\n                elog: zb,\n                base: \"http://jsbngssl.plusone.google.com/u/0\",\n                loadTime: (new JSBNG__Date).getTime()\n            };\n            y.pw = Ab;\n            var Bb = function(a, b) {\n                for (var c = b.split(\".\"), d = function() {\n                    var b = arguments;\n                    a(function() {\n                        for (var a = n, d = 0, f = ((c.length - 1)); ((d < f)); ++d) {\n                            a = a[c[d]];\n                        ;\n                        };\n                    ;\n                        a[c[d]].apply(a, b);\n                    });\n                }, g = n, f = 0, m = ((c.length - 1)); ((f < m)); ++f) {\n                    g = g[c[f]] = ((g[c[f]] || {\n                    }));\n                ;\n                };\n            ;\n                return g[c[f]] = d;\n            };\n            Bb(vb, \"pw.clk\");\n            Bb(vb, \"pw.hvr\");\n            r(\"su\", yb, n.pw);\n        }\n    ;\n    ;\n    ;\n        var Cb = [1,2,3,4,5,6,9,10,11,13,14,28,29,30,34,35,37,38,39,40,41,42,43,500,];\n        var Db = q.b(\"0.001\", 22105), Eb = q.b(\"1.0\", 1), Fb = k, Gb = k;\n        if (q.a(\"1\")) {\n            var Hb = Math.JSBNG__random();\n            ((((Hb <= Db)) && (Fb = e)));\n            ((((Hb <= Eb)) && (Gb = e)));\n        }\n    ;\n    ;\n        var U = h;\n        function Ib() {\n            var a = 0, b = function(b, d) {\n                ((q.a(d) && (a |= b)));\n            };\n            b(1, \"\");\n            b(2, \"\");\n            b(4, \"\");\n            b(8, \"\");\n            return a;\n        };\n    ;\n        function Jb(a, b) {\n            var c = Db, d = Fb, g;\n            g = a;\n            if (!U) {\n                U = {\n                };\n                for (var f = 0; ((f < Cb.length)); f++) {\n                    var m = Cb[f];\n                    U[m] = e;\n                };\n            ;\n            }\n        ;\n        ;\n            if (g = !!U[g]) {\n                c = Eb, d = Gb;\n            }\n        ;\n        ;\n            if (d) {\n                d = encodeURIComponent;\n                g = \"es_plusone_gc_20130619.0_p0\";\n                ((n.rp ? (f = n.rp(), f = ((((\"-1\" != f)) ? f : \"\"))) : f = \"\"));\n                c = [\"//www.google.com/gen_204?atyp=i&zx=\",(new JSBNG__Date).getTime(),\"&oge=\",a,\"&ogex=\",d(\"37102\"),\"&ogev=\",d(\"uJbdUZ3sONTYyAHI-IHoCA\"),\"&ogf=\",n.bv.f,\"&ogp=\",d(\"1\"),\"&ogrp=\",d(f),\"&ogsr=\",Math.round(((1 / c))),\"&ogv=\",d(\"1372717546.1372341082\"),((g ? ((\"&oggv=\" + d(g))) : \"\")),\"&ogd=\",d(\"com\"),\"&ogl=\",d(\"en\"),\"&ogus=\",Ib(),];\n                if (b) {\n                    ((((\"ogw\" in b)) && (c.push(((\"&ogw=\" + b.ogw))), delete b.ogw)));\n                    var l;\n                    g = b;\n                    f = [];\n                    {\n                        var fin2keys = ((window.top.JSBNG_Replay.forInKeys)((g))), fin2i = (0);\n                        (0);\n                        for (; (fin2i < fin2keys.length); (fin2i++)) {\n                            ((l) = (fin2keys[fin2i]));\n                            {\n                                ((((0 != f.length)) && f.push(\",\"))), f.push(Kb(l)), f.push(\".\"), f.push(Kb(g[l]));\n                            ;\n                            };\n                        };\n                    };\n                ;\n                    l = f.join(\"\");\n                    ((((\"\" != l)) && (c.push(\"&ogad=\"), c.push(d(l)))));\n                }\n            ;\n            ;\n                w(c.join(\"\"));\n            }\n        ;\n        ;\n        };\n    ;\n        function Kb(a) {\n            ((((\"number\" == typeof a)) && (a += \"\")));\n            return ((((\"string\" == typeof a)) ? a.replace(\".\", \"%2E\").replace(\",\", \"%2C\") : a));\n        };\n    ;\n        v = Jb;\n        r(\"il\", v, x);\n        var Lb = {\n        };\n        y.il = Lb;\n        var Mb = function(a, b, c, d, g, f, m, l, p, s) {\n            D(function() {\n                n.paa(a, b, c, d, g, f, m, l, p, s);\n            });\n        }, Nb = function() {\n            D(function() {\n                n.prm();\n            });\n        }, Ob = function(a) {\n            D(function() {\n                n.spn(a);\n            });\n        }, Pb = function(a) {\n            D(function() {\n                n.sps(a);\n            });\n        }, Qb = function(a) {\n            D(function() {\n                n.spp(a);\n            });\n        }, Rb = {\n            27: \"//ssl.gstatic.com/gb/images/silhouette_27.png\",\n            27: \"//ssl.gstatic.com/gb/images/silhouette_27.png\",\n            27: \"//ssl.gstatic.com/gb/images/silhouette_27.png\"\n        }, Sb = function(a) {\n            return (((a = Rb[a]) || \"//ssl.gstatic.com/gb/images/silhouette_27.png\"));\n        }, Tb = function() {\n            D(function() {\n                n.spd();\n            });\n        };\n        r(\"spn\", Ob);\n        r(\"spp\", Qb);\n        r(\"sps\", Pb);\n        r(\"spd\", Tb);\n        r(\"paa\", Mb);\n        r(\"prm\", Nb);\n        eb(\"gbd4\", Nb);\n        if (q.a(\"\")) {\n            var Ub = {\n                d: q.a(\"\"),\n                e: \"\",\n                sanw: q.a(\"\"),\n                p: \"//ssl.gstatic.com/gb/images/silhouette_96.png\",\n                cp: \"1\",\n                xp: q.a(\"1\"),\n                mg: \"%1$s (delegated)\",\n                md: \"%1$s (default)\",\n                mh: \"220\",\n                s: \"1\",\n                pp: Sb,\n                ppl: q.a(\"\"),\n                ppa: q.a(\"\"),\n                ppm: \"Google+ page\"\n            };\n            y.prf = Ub;\n        }\n    ;\n    ;\n    ;\n        var V, Vb, W, Wb, X = 0, Xb = function(a, b, c) {\n            if (a.indexOf) {\n                return a.indexOf(b, c);\n            }\n        ;\n        ;\n            if (Array.indexOf) {\n                return Array.indexOf(a, b, c);\n            }\n        ;\n        ;\n            for (c = ((((c == h)) ? 0 : ((((0 > c)) ? Math.max(0, ((a.length + c))) : c)))); ((c < a.length)); c++) {\n                if (((((c in a)) && ((a[c] === b))))) {\n                    return c;\n                }\n            ;\n            ;\n            };\n        ;\n            return -1;\n        }, Z = function(a, b) {\n            return ((((-1 == Xb(a, X))) ? (t(Error(((((X + \"_\")) + b))), \"up\", \"caa\"), k) : e));\n        }, Zb = function(a, b) {\n            ((Z([1,2,], \"r\") && (V[a] = ((V[a] || [])), V[a].push(b), ((((2 == X)) && window.JSBNG__setTimeout(function() {\n                b(Yb(a));\n            }, 0))))));\n        }, $b = function(a, b, c) {\n            if (((Z([1,], \"nap\") && c))) {\n                for (var d = 0; ((d < c.length)); d++) {\n                    Vb[c[d]] = e;\n                ;\n                };\n            ;\n                n.up.spl(a, b, \"nap\", c);\n            }\n        ;\n        ;\n        }, ac = function(a, b, c) {\n            if (((Z([1,], \"aop\") && c))) {\n                if (W) {\n                    var fin3keys = ((window.top.JSBNG_Replay.forInKeys)((W))), fin3i = (0);\n                    var d;\n                    for (; (fin3i < fin3keys.length); (fin3i++)) {\n                        ((d) = (fin3keys[fin3i]));\n                        {\n                            W[d] = ((W[d] && ((-1 != Xb(c, d)))));\n                        ;\n                        };\n                    };\n                }\n                 else {\n                    W = {\n                    };\n                    for (d = 0; ((d < c.length)); d++) {\n                        W[c[d]] = e;\n                    ;\n                    };\n                ;\n                }\n            ;\n            ;\n                n.up.spl(a, b, \"aop\", c);\n            }\n        ;\n        ;\n        }, bc = function() {\n            try {\n                if (X = 2, !Wb) {\n                    Wb = e;\n                    {\n                        var fin4keys = ((window.top.JSBNG_Replay.forInKeys)((V))), fin4i = (0);\n                        var a;\n                        for (; (fin4i < fin4keys.length); (fin4i++)) {\n                            ((a) = (fin4keys[fin4i]));\n                            {\n                                for (var b = V[a], c = 0; ((c < b.length)); c++) {\n                                    try {\n                                        b[c](Yb(a));\n                                    } catch (d) {\n                                        t(d, \"up\", \"tp\");\n                                    };\n                                ;\n                                };\n                            ;\n                            };\n                        };\n                    };\n                ;\n                }\n            ;\n            ;\n            } catch (g) {\n                t(g, \"up\", \"mtp\");\n            };\n        ;\n        }, Yb = function(a) {\n            if (Z([2,], \"ssp\")) {\n                var b = !Vb[a];\n                ((W && (b = ((b && !!W[a])))));\n                return b;\n            }\n        ;\n        ;\n        };\n        Wb = k;\n        V = {\n        };\n        Vb = {\n        };\n        W = h;\n        var X = 1, cc = function(a) {\n            var b = e;\n            try {\n                b = !a.cookie;\n            } catch (c) {\n            \n            };\n        ;\n            return b;\n        }, dc = function() {\n            try {\n                return ((!!window.JSBNG__localStorage && ((\"object\" == typeof window.JSBNG__localStorage))));\n            } catch (a) {\n                return k;\n            };\n        ;\n        }, ec = function(a) {\n            return ((((((a && a.style)) && a.style.g)) && ((\"undefined\" != typeof a.load))));\n        }, fc = function(a, b, c, d) {\n            try {\n                ((cc(JSBNG__document) || (((d || (b = ((\"og-up-\" + b))))), ((dc() ? window.JSBNG__localStorage.setItem(b, c) : ((ec(a) && (a.setAttribute(b, c), a.save(a.id)))))))));\n            } catch (g) {\n                ((((g.code != JSBNG__DOMException.QUOTA_EXCEEDED_ERR)) && t(g, \"up\", \"spd\")));\n            };\n        ;\n        }, gc = function(a, b, c) {\n            try {\n                if (cc(JSBNG__document)) {\n                    return \"\";\n                }\n            ;\n            ;\n                ((c || (b = ((\"og-up-\" + b)))));\n                if (dc()) {\n                    return window.JSBNG__localStorage.getItem(b);\n                }\n            ;\n            ;\n                if (ec(a)) {\n                    return a.load(a.id), a.getAttribute(b);\n                }\n            ;\n            ;\n            } catch (d) {\n                ((((d.code != JSBNG__DOMException.QUOTA_EXCEEDED_ERR)) && t(d, \"up\", \"gpd\")));\n            };\n        ;\n            return \"\";\n        }, hc = function(a, b, c) {\n            ((a.JSBNG__addEventListener ? a.JSBNG__addEventListener(b, c, k) : ((a.JSBNG__attachEvent && a.JSBNG__attachEvent(((\"JSBNG__on\" + b)), c)))));\n        }, ic = function(a) {\n            for (var b = 0, c; c = a[b]; b++) {\n                var d = n.up;\n                c = ((((c in d)) && d[c]));\n                if (!c) {\n                    return k;\n                }\n            ;\n            ;\n            };\n        ;\n            return e;\n        };\n        r(\"up\", {\n            r: Zb,\n            nap: $b,\n            aop: ac,\n            tp: bc,\n            ssp: Yb,\n            spd: fc,\n            gpd: gc,\n            aeh: hc,\n            aal: ic\n        });\n        var jc = function(a, b) {\n            a[b] = function(c) {\n                var d = arguments;\n                n.qm(function() {\n                    a[b].apply(this, d);\n                });\n            };\n        };\n        jc(n.up, \"sl\");\n        jc(n.up, \"si\");\n        jc(n.up, \"spl\");\n        n.mcf(\"up\", {\n            sp: q.b(\"0.01\", 1),\n            tld: \"com\",\n            prid: \"1\"\n        });\n        function kc() {\n            {\n                function a() {\n                    for (var b; (((b = f[m++]) && !((((\"m\" == b[0])) || b[1].auto)))); ) {\n                    ;\n                    };\n                ;\n                    ((b && (E(2, b[0]), ((b[1].url && pa(b[1].url, b[0]))), ((((b[1].libs && F)) && F(b[1].libs))))));\n                    ((((m < f.length)) && JSBNG__setTimeout(a, 0)));\n                };\n                ((window.top.JSBNG_Replay.sffd704e1601e1b9a8fa55951b1471268b42138a2_127.push)((a)));\n            };\n        ;\n            function b() {\n                ((((0 < g--)) ? JSBNG__setTimeout(b, 0) : a()));\n            };\n        ;\n            var c = q.a(\"1\"), d = q.a(\"\"), g = 3, f = z, m = 0, l = window.gbarOnReady;\n            if (l) {\n                try {\n                    l();\n                } catch (p) {\n                    t(p, \"ml\", \"or\");\n                };\n            }\n        ;\n        ;\n            ((d ? r(\"ldb\", a) : ((c ? da(window, \"load\", b) : b()))));\n        };\n    ;\n        r(\"rdl\", kc);\n    } catch (e) {\n        ((((window.gbar && gbar.logger)) && gbar.logger.ml(e, {\n            _sn: \"cfg.init\"\n        })));\n    };\n;\n})();\n(function() {\n    try {\n        var b = window.gbar;\n        var d = function(a, c) {\n            b[a] = function() {\n                return ((((window.JSBNG__navigator && window.JSBNG__navigator.userAgent)) ? c(window.JSBNG__navigator.userAgent) : !1));\n            };\n        }, e = function(a) {\n            return !((/AppleWebKit\\/.+(?:Version\\/[35]\\.|Chrome\\/[01]\\.)/.test(a) || ((-1 != a.indexOf(\"Firefox/3.5.\")))));\n        };\n        d(\"bs_w\", e);\n    } catch (e) {\n        ((((window.gbar && gbar.logger)) && gbar.logger.ml(e, {\n            _sn: \"cfg.init\"\n        })));\n    };\n;\n})();\n(function() {\n    try {\n        var a = window.gbar;\n        a.mcf(\"sf\", {\n        });\n    } catch (e) {\n        ((((window.gbar && gbar.logger)) && gbar.logger.ml(e, {\n            _sn: \"cfg.init\"\n        })));\n    };\n;\n})();\n(function() {\n    try {\n        var aa = window.gbar.i.i;\n        var a = window.gbar;\n        var e = a.i;\n        var k, n;\n        var u = function(b, d) {\n            aa(b, \"es\", d);\n        }, v = function(b) {\n            return JSBNG__document.getElementById(b);\n        }, w = function(b, d) {\n            var f = Array.prototype.slice.call(arguments, 1);\n            return function() {\n                var c = Array.prototype.slice.call(arguments);\n                c.unshift.apply(c, f);\n                return b.apply(this, c);\n            };\n        }, x = void 0, y = void 0, ba = e.c(\"840\"), ca = e.c(\"640\");\n        e.c(\"840\");\n        var ia = e.c(\"640\"), ja = e.c(\"590\"), ka = e.c(\"1514\"), la = e.c(\"1474\");\n        e.c(\"1474\");\n        var ma = e.c(\"1252\"), na = e.c(\"1060\"), oa = e.c(\"995\"), pa = e.c(\"851\"), A = {\n        }, B = {\n        }, C = {\n        }, D = {\n        }, E = {\n        }, F = {\n        }, G = {\n        };\n        A.h = e.c(\"102\");\n        A.m = e.c(\"44\");\n        A.f = e.c(\"126\");\n        B.h = e.c(\"102\");\n        B.m = e.c(\"44\");\n        B.f = e.c(\"126\");\n        C.h = e.c(\"102\");\n        C.m = e.c(\"44\");\n        C.f = e.c(\"126\");\n        D.h = e.c(\"102\");\n        D.m = e.c(\"28\");\n        D.f = e.c(\"126\");\n        E.h = e.c(\"102\");\n        E.m = e.c(\"16\");\n        E.f = e.c(\"126\");\n        F.h = e.c(\"102\");\n        F.m = e.c(\"16\");\n        F.f = e.c(\"126\");\n        G.h = e.c(\"102\");\n        G.m = e.c(\"12\");\n        G.f = e.c(\"126\");\n        var H = e.c(\"16\"), J = e.c(\"572\"), qa = e.c(\"434\"), ra = e.c(\"319\"), sa = e.c(\"572\"), ta = e.c(\"572\"), ua = e.c(\"572\"), va = e.c(\"434\"), wa = e.c(\"319\"), xa = e.c(\"126\"), ya = e.c(\"126\"), za = e.c(\"126\"), Aa = e.c(\"126\"), Ba = e.c(\"126\"), Ca = e.c(\"126\"), Da = e.c(\"126\"), Ea = e.c(\"15\"), Fa = e.c(\"15\"), K = e.c(\"15\"), Ga = e.c(\"15\"), Ha = e.c(\"6\"), Ia = e.c(\"6\"), Ja = e.c(\"6\"), Ka = e.c(\"44\"), La = e.c(\"44\"), Ma = e.c(\"44\"), Na = e.c(\"28\"), Oa = e.c(\"16\"), Pa = e.c(\"16\"), Qa = e.c(\"12\"), Ra = e.c(\"30\"), Sa = e.c(\"236\"), Ta = e.c(\"304\"), Ua = e.c(\"35\");\n        e.a(\"1\");\n        var Va = e.c(\"980\"), Wa = \"gb gbq gbu gbzw gbpr gbq2 gbqf gbqff gbq3 gbq4 gbq1 gbqlw gbql gbx1 gbx2 gbx3 gbx4 gbg1 gbg3 gbg4 gbd1 gbd3 gbd4 gbs gbwc gbprc\".split(\" \"), M = [\"gbzw\",], Q = e.a(\"\"), Xa = e.a(\"\"), R = [], U = !0, W = function(b) {\n            try {\n                a.close();\n                var d = e.c(\"27\");\n                ((((\"xxl\" == b)) ? (V(\"gbexxl\"), d = e.c(\"27\")) : ((((\"xl\" == b)) ? (V(\"gbexl\"), d = e.c(\"27\")) : ((((\"lg\" == b)) ? (V(\"\"), d = e.c(\"27\")) : ((((\"md\" == b)) ? (V(\"gbem\"), d = e.c(\"27\")) : ((((\"sm\" == b)) ? V(\"gbes\") : ((((\"ty\" == b)) ? V(\"gbet\") : ((((\"ut\" == b)) && V(\"gbeu\")))))))))))))));\n                if (window.JSBNG__opera) {\n                    var f = M.length;\n                    for (b = 0; ((b < f)); b++) {\n                        var c = v(M[b]);\n                        if (c) {\n                            var q = c.style.display;\n                            c.style.display = \"none\";\n                            b += ((0 * c.clientHeight));\n                            c.style.display = q;\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                }\n            ;\n            ;\n                a.sps(d);\n            } catch (r) {\n                u(r, \"stem\");\n            };\n        ;\n        }, Ya = w(W, \"xxl\"), Za = w(W, \"xl\"), $a = w(W, \"lg\"), ab = w(W, \"md\"), bb = w(W, \"sm\"), cb = w(W, \"ty\"), db = w(W, \"ut\"), Y = function(b) {\n            try {\n                W(b);\n                var d = e.j(\"Height\"), f = e.j(\"Width\"), c = C;\n                switch (b) {\n                  case \"ut\":\n                    c = G;\n                    break;\n                  case \"ty\":\n                    c = F;\n                    break;\n                  case \"sm\":\n                    c = E;\n                    break;\n                  case \"md\":\n                    c = D;\n                    break;\n                  case \"lg\":\n                    c = C;\n                    break;\n                  case \"xl\":\n                    c = B;\n                    break;\n                  case \"xxl\":\n                    c = A;\n                };\n            ;\n                eb(d, f, b, c);\n                X();\n            } catch (q) {\n                u(q, \"seme\");\n            };\n        ;\n        }, fb = function(b) {\n            try {\n                R.push(b);\n            } catch (d) {\n                u(d, \"roec\");\n            };\n        ;\n        }, gb = function() {\n            if (U) {\n                try {\n                    for (var b = 0, d; d = R[b]; ++b) {\n                        d(k);\n                    ;\n                    };\n                ;\n                } catch (f) {\n                    u(f, \"eoec\");\n                };\n            }\n        ;\n        ;\n        }, hb = function(b) {\n            try {\n                return U = b;\n            } catch (d) {\n                u(d, \"ear\");\n            };\n        ;\n        }, ib = function() {\n            var b = e.j(\"Height\"), d = e.j(\"Width\"), f = C, c = \"lg\";\n            if (((((d < pa)) && Q))) {\n                c = \"ut\", f = G;\n            }\n             else {\n                if (((((d < oa)) && Q))) {\n                    c = \"ty\", f = F;\n                }\n                 else {\n                    if (((((d < na)) || ((b < ja))))) {\n                        c = \"sm\", f = E;\n                    }\n                     else {\n                        if (((((d < ma)) || ((b < ia))))) {\n                            c = \"md\", f = D;\n                        }\n                    ;\n                    }\n                ;\n                }\n            ;\n            }\n        ;\n        ;\n            ((Xa && (((((((d > la)) && ((b > ca)))) && (c = \"xl\", f = B))), ((((((d > ka)) && ((b > ba)))) && (c = \"xxl\", f = A))))));\n            eb(b, d, c, f);\n            return c;\n        }, X = function() {\n            try {\n                var b = v(\"gbx1\");\n                if (b) {\n                    var d = a.rtl(v(\"gb\")), f = b.clientWidth, b = ((f <= Va)), c = v(\"gb_70\"), q = v(\"gbg4\"), r = ((v(\"gbg6\") || q));\n                    if (!x) {\n                        if (c) {\n                            x = c.clientWidth;\n                        }\n                         else {\n                            if (r) {\n                                x = r.clientWidth;\n                            }\n                             else {\n                                return;\n                            }\n                        ;\n                        }\n                    ;\n                    }\n                ;\n                ;\n                    if (!y) {\n                        var s = v(\"gbg3\");\n                        ((s && (y = s.clientWidth)));\n                    }\n                ;\n                ;\n                    var N = k.mo, t, m, l;\n                    switch (N) {\n                      case \"xxl\":\n                        t = Ka;\n                        m = Ea;\n                        l = xa;\n                        break;\n                      case \"xl\":\n                        t = La;\n                        m = Fa;\n                        l = ya;\n                        break;\n                      case \"md\":\n                        t = Na;\n                        m = Ga;\n                        l = Aa;\n                        break;\n                      case \"sm\":\n                        t = ((Oa - H));\n                        m = Ha;\n                        l = Ba;\n                        break;\n                      case \"ty\":\n                        t = ((Pa - H));\n                        m = Ia;\n                        l = Ca;\n                        break;\n                      case \"ut\":\n                        t = ((Qa - H));\n                        m = Ja;\n                        l = Da;\n                        break;\n                      default:\n                        t = Ma, m = K, l = za;\n                    };\n                ;\n                    var p = ((a.snw && a.snw()));\n                    ((p && (l += ((p + m)))));\n                    var p = x, z = v(\"gbg1\");\n                    ((z && (p += ((z.clientWidth + m)))));\n                    (((s = v(\"gbg3\")) && (p += ((y + m)))));\n                    var S = v(\"gbgs4dn\");\n                    ((((q && !S)) && (p += ((q.clientWidth + m)))));\n                    var da = v(\"gbd4\"), T = v(\"gb_71\");\n                    ((((T && !da)) && (p += ((((T.clientWidth + m)) + K)))));\n                    p = Math.min(Ta, p);\n                    l += t;\n                    var O = v(\"gbqfbw\"), I = v(\"gbq4\");\n                    ((I && (l += I.offsetWidth)));\n                    ((O && (O.style.display = \"\", l += ((O.clientWidth + Ra)))));\n                    var I = ((f - l)), ea = v(\"gbqf\"), fa = v(\"gbqff\"), h = ((a.gpcc && a.gpcc()));\n                    if (((((ea && fa)) && !h))) {\n                        h = ((((f - p)) - l));\n                        switch (N) {\n                          case \"ut\":\n                            h = Math.min(h, wa);\n                            h = Math.max(h, ra);\n                            break;\n                          case \"ty\":\n                            h = Math.min(h, va);\n                            h = Math.max(h, qa);\n                            break;\n                          case \"xl\":\n                            h = Math.min(h, ua);\n                            h = Math.max(h, J);\n                            break;\n                          case \"xxl\":\n                            h = Math.min(h, ta);\n                            h = Math.max(h, J);\n                            break;\n                          default:\n                            h = Math.min(h, sa), h = Math.max(h, J);\n                        };\n                    ;\n                        ea.style.maxWidth = ((h + \"px\"));\n                        fa.style.maxWidth = ((h + \"px\"));\n                        I -= h;\n                    }\n                ;\n                ;\n                    var g = v(\"gbgs3\");\n                    if (g) {\n                        var N = ((I <= Sa)), ga = a.cc(g, \"gbsbc\");\n                        ((((N && !ga)) ? (a.ca(g, \"gbsbc\"), a.close()) : ((((!N && ga)) && (a.cr(g, \"gbsbc\"), a.close())))));\n                    }\n                ;\n                ;\n                    g = I;\n                    ((z && (z.style.display = \"\", g -= ((z.clientWidth + m)))));\n                    ((s && (s.style.display = \"\", g -= ((s.clientWidth + m)))));\n                    ((((q && !S)) && (g -= ((q.clientWidth + m)))));\n                    ((((T && !da)) && (g -= ((((T.clientWidth + m)) + K)))));\n                    var q = ((S ? 0 : Ua)), P = ((S || v(\"gbi4t\")));\n                    if (((P && !c))) {\n                        ((((g > q)) ? (P.style.display = \"\", P.style.maxWidth = ((g + \"px\"))) : P.style.display = \"none\"));\n                        ((r && (r.style.width = ((((((g < x)) && ((g > q)))) ? ((g + \"px\")) : \"\")))));\n                        var ha = v(\"gbgs4d\"), r = \"left\";\n                        ((((((x > g)) ^ d)) && (r = \"right\")));\n                        P.style.textAlign = r;\n                        ((ha && (ha.style.textAlign = r)));\n                    }\n                ;\n                ;\n                    ((((s && ((0 > g)))) && (g += s.clientWidth, s.style.display = \"none\")));\n                    ((((z && ((0 > g)))) && (g += z.clientWidth, z.style.display = \"none\")));\n                    if (((O && ((((0 > g)) || ((c && ((g < c.clientWidth))))))))) {\n                        O.style.display = \"none\";\n                    }\n                ;\n                ;\n                    var c = ((d ? \"right\" : \"left\")), d = ((d ? \"left\" : \"right\")), L = v(\"gbu\"), lb = ((\"\" != L.style[c]));\n                    ((b ? (L.style[c] = ((((((f - L.clientWidth)) - t)) + \"px\")), L.style[d] = \"auto\") : (L.style[c] = \"\", L.style[d] = \"\")));\n                    ((((((b != lb)) && a.swsc)) && a.swsc(b)));\n                }\n            ;\n            ;\n            } catch (mb) {\n                u(mb, \"cb\");\n            };\n        ;\n        }, eb = function(b, d, f, c) {\n            k = {\n            };\n            k.mo = f;\n            k.vh = b;\n            k.vw = d;\n            k.es = c;\n            ((((f != n)) && (gb(), ((e.f && e.f())))));\n        }, jb = function(b) {\n            A.h += b;\n            B.h += b;\n            C.h += b;\n            D.h += b;\n            E.h += b;\n            F.h += b;\n            G.h += b;\n        }, kb = function() {\n            return k;\n        }, nb = function() {\n            try {\n                if (((!0 == U))) {\n                    var b = n;\n                    n = ib();\n                    if (((b != n))) {\n                        switch (n) {\n                          case \"ut\":\n                            db();\n                            break;\n                          case \"ty\":\n                            cb();\n                            break;\n                          case \"sm\":\n                            bb();\n                            break;\n                          case \"md\":\n                            ab();\n                            break;\n                          case \"xl\":\n                            Za();\n                            break;\n                          case \"xxl\":\n                            Ya();\n                            break;\n                          default:\n                            $a();\n                        };\n                    }\n                ;\n                ;\n                }\n            ;\n            ;\n                X();\n                var d = v(\"gb\");\n                if (d) {\n                    var f = d.style.opacity;\n                    d.style.opacity = \".99\";\n                    for (b = 0; ((1 > b)); b++) {\n                        b += ((0 * d.offsetWidth));\n                    ;\n                    };\n                ;\n                    d.style.opacity = f;\n                }\n            ;\n            ;\n            } catch (c) {\n                u(c, \"sem\");\n            };\n        ;\n        }, V = function(b) {\n            var d = v(\"gb\");\n            ((d && Z(d, \"gbexxli gbexli  gbemi gbesi gbeti gbeui\".split(\" \"))));\n            for (var d = [], f = 0, c; c = Wa[f]; f++) {\n                if (c = v(c)) {\n                    switch (b) {\n                      case \"gbexxl\":\n                        Z(c, \"gbexl  gbem gbes gbet gbeu\".split(\" \"));\n                        a.ca(c, b);\n                        break;\n                      case \"gbexl\":\n                        Z(c, \"gbexxl  gbem gbes gbet gbeu\".split(\" \"));\n                        a.ca(c, b);\n                        break;\n                      case \"\":\n                        Z(c, \"gbexxl gbexl gbem gbes gbet gbeu\".split(\" \"));\n                        a.ca(c, b);\n                        break;\n                      case \"gbem\":\n                        Z(c, \"gbexxl gbexl  gbes gbet gbeu\".split(\" \"));\n                        a.ca(c, b);\n                        break;\n                      case \"gbes\":\n                        Z(c, \"gbexxl gbexl  gbem gbet gbeu\".split(\" \"));\n                        a.ca(c, b);\n                        break;\n                      case \"gbet\":\n                        Z(c, \"gbexxl gbexl  gbem gbes gbeu\".split(\" \"));\n                        a.ca(c, b);\n                        break;\n                      case \"gbeu\":\n                        Z(c, \"gbexxl gbexl  gbem gbes gbet\".split(\" \")), a.ca(c, b);\n                    };\n                ;\n                    d.push(c);\n                }\n            ;\n            ;\n            };\n        ;\n            return d;\n        }, Z = function(b, d) {\n            for (var f = 0, c = d.length; ((f < c)); ++f) {\n                ((d[f] && a.cr(b, d[f])));\n            ;\n            };\n        ;\n        }, ob = function() {\n            try {\n                if (((!0 == U))) {\n                    switch (ib()) {\n                      case \"ut\":\n                        $(\"gbeui\");\n                        break;\n                      case \"ty\":\n                        $(\"gbeti\");\n                        break;\n                      case \"sm\":\n                        $(\"gbesi\");\n                        break;\n                      case \"md\":\n                        $(\"gbemi\");\n                        break;\n                      case \"xl\":\n                        $(\"gbexli\");\n                        break;\n                      case \"xxl\":\n                        $(\"gbexxli\");\n                        break;\n                      default:\n                        $(\"\");\n                    };\n                }\n            ;\n            ;\n                X();\n            } catch (b) {\n                u(b, \"semol\");\n            };\n        ;\n        }, $ = function(b) {\n            var d = v(\"gb\");\n            ((d && a.ca(d, b)));\n        };\n        a.eli = ob;\n        a.elg = nb;\n        a.elxxl = w(Y, \"xxl\");\n        a.elxl = w(Y, \"xl\");\n        a.ell = w(Y, \"lg\");\n        a.elm = w(Y, \"md\");\n        a.els = w(Y, \"sm\");\n        a.elr = kb;\n        a.elc = fb;\n        a.elx = gb;\n        a.elh = jb;\n        a.ela = hb;\n        a.elp = X;\n        a.upel = w(Y, \"lg\");\n        a.upes = w(Y, \"md\");\n        a.upet = w(Y, \"sm\");\n        ob();\n        nb();\n        a.mcf(\"el\", {\n        });\n    } catch (e) {\n        ((((window.gbar && gbar.logger)) && gbar.logger.ml(e, {\n            _sn: \"cfg.init\"\n        })));\n    };\n;\n})();\n(function() {\n    try {\n        var a = window.gbar;\n        var d = function() {\n            return JSBNG__document.getElementById(\"gbqfqw\");\n        }, h = function() {\n            return JSBNG__document.getElementById(\"gbqfq\");\n        }, k = function() {\n            return JSBNG__document.getElementById(\"gbqf\");\n        }, l = function() {\n            return JSBNG__document.getElementById(\"gbqfb\");\n        }, n = function(b) {\n            var c = JSBNG__document.getElementById(\"gbqfaa\");\n            c.appendChild(b);\n            m();\n        }, p = function(b) {\n            var c = JSBNG__document.getElementById(\"gbqfab\");\n            c.appendChild(b);\n            m();\n        }, m = function() {\n            var b = JSBNG__document.getElementById(\"gbqfqwb\");\n            if (b) {\n                var c = JSBNG__document.getElementById(\"gbqfaa\"), e = JSBNG__document.getElementById(\"gbqfab\");\n                if (((c || e))) {\n                    var f = \"left\", g = \"right\";\n                    ((a.rtl(JSBNG__document.getElementById(\"gb\")) && (f = \"right\", g = \"left\")));\n                    ((c && (b.style[f] = ((c.offsetWidth + \"px\")))));\n                    ((e && (b.style[g] = ((e.offsetWidth + \"px\")))));\n                }\n            ;\n            ;\n            }\n        ;\n        ;\n        }, q = function(b) {\n            a.qm(function() {\n                a.qfhi(b);\n            });\n        };\n        a.qfgw = d;\n        a.qfgq = h;\n        a.qfgf = k;\n        a.qfas = n;\n        a.qfae = p;\n        a.qfau = m;\n        a.qfhi = q;\n        a.qfsb = l;\n    } catch (e) {\n        ((((window.gbar && gbar.logger)) && gbar.logger.ml(e, {\n            _sn: \"cfg.init\"\n        })));\n    };\n;\n})();\n(function() {\n    try {\n        var c = window.gbar.i.i;\n        var e = window.gbar;\n        var f = \"gbq1 gbq2 gbpr gbqfbwa gbx1 gbx2\".split(\" \"), h = function(b) {\n            var a = JSBNG__document.getElementById(\"gbqld\");\n            if (((a && (a.style.display = ((b ? \"none\" : \"block\")), a = JSBNG__document.getElementById(\"gbql\"))))) {\n                a.style.display = ((b ? \"block\" : \"none\"));\n            }\n        ;\n        ;\n        }, k = function() {\n            try {\n                for (var b = 0, a; a = f[b]; b++) {\n                    var d = JSBNG__document.getElementById(a);\n                    ((d && e.ca(d, \"gbqfh\")));\n                };\n            ;\n                ((e.elp && e.elp()));\n                h(!0);\n            } catch (g) {\n                c(g, \"gas\", \"ahcc\");\n            };\n        ;\n        }, l = function() {\n            try {\n                for (var b = 0, a; a = f[b]; b++) {\n                    var d = JSBNG__document.getElementById(a);\n                    ((d && e.cr(d, \"gbqfh\")));\n                };\n            ;\n                ((e.elp && e.elp()));\n                h(!1);\n            } catch (g) {\n                c(g, \"gas\", \"rhcc\");\n            };\n        ;\n        }, m = function() {\n            try {\n                var b = JSBNG__document.getElementById(f[0]);\n                return ((b && e.cc(b, \"gbqfh\")));\n            } catch (a) {\n                c(a, \"gas\", \"ih\");\n            };\n        ;\n        };\n        e.gpca = k;\n        e.gpcr = l;\n        e.gpcc = m;\n    } catch (e) {\n        ((((window.gbar && gbar.logger)) && gbar.logger.ml(e, {\n            _sn: \"cfg.init\"\n        })));\n    };\n;\n})();\n(function() {\n    try {\n        var b = window.gbar.i.i;\n        var c = window.gbar;\n        var f = function(d) {\n            try {\n                var a = JSBNG__document.getElementById(\"gbom\");\n                ((a && d.appendChild(a.cloneNode(!0))));\n            } catch (e) {\n                b(e, \"omas\", \"aomc\");\n            };\n        ;\n        };\n        c.aomc = f;\n    } catch (e) {\n        ((((window.gbar && gbar.logger)) && gbar.logger.ml(e, {\n            _sn: \"cfg.init\"\n        })));\n    };\n;\n})();\n(function() {\n    try {\n        var a = window.gbar;\n        a.mcf(\"pm\", {\n            p: \"\"\n        });\n    } catch (e) {\n        ((((window.gbar && gbar.logger)) && gbar.logger.ml(e, {\n            _sn: \"cfg.init\"\n        })));\n    };\n;\n})();\n(function() {\n    try {\n        var a = window.gbar;\n        a.mcf(\"mm\", {\n            s: \"1\"\n        });\n    } catch (e) {\n        ((((window.gbar && gbar.logger)) && gbar.logger.ml(e, {\n            _sn: \"cfg.init\"\n        })));\n    };\n;\n})();\n(function() {\n    try {\n        var d = window.gbar.i.i;\n        var e = window.gbar;\n        var f = e.i;\n        var g = f.c(\"1\", 0), h = /\\bgbmt\\b/, k = function(a) {\n            try {\n                var b = JSBNG__document.getElementById(((\"gb_\" + g))), c = JSBNG__document.getElementById(((\"gb_\" + a)));\n                ((b && f.l(b, ((h.test(b.className) ? \"gbm0l\" : \"gbz0l\")))));\n                ((c && f.k(c, ((h.test(c.className) ? \"gbm0l\" : \"gbz0l\")))));\n            } catch (l) {\n                d(l, \"sj\", \"ssp\");\n            };\n        ;\n            g = a;\n        }, m = e.qs, n = function(a) {\n            var b;\n            b = a.href;\n            var c = window.JSBNG__location.href.match(/.*?:\\/\\/[^\\/]*/)[0], c = RegExp(((((\"^\" + c)) + \"/search\\\\?\")));\n            if ((((b = c.test(b)) && !/(^|\\\\?|&)ei=/.test(a.href)))) {\n                if ((((b = window.google) && b.kEXPI))) {\n                    a.href += ((\"&ei=\" + b.kEI));\n                }\n            ;\n            }\n        ;\n        ;\n        }, p = function(a) {\n            m(a);\n            n(a);\n        }, q = function() {\n            if (((window.google && window.google.sn))) {\n                var a = /.*hp$/;\n                return ((a.test(window.google.sn) ? \"\" : \"1\"));\n            }\n        ;\n        ;\n            return \"-1\";\n        };\n        e.rp = q;\n        e.slp = k;\n        e.qs = p;\n        e.qsi = n;\n    } catch (e) {\n        ((((window.gbar && gbar.logger)) && gbar.logger.ml(e, {\n            _sn: \"cfg.init\"\n        })));\n    };\n;\n})();\n(function() {\n    try {\n        window.gbar.rdl();\n    } catch (e) {\n        ((((window.gbar && gbar.logger)) && gbar.logger.ml(e, {\n            _sn: \"cfg.init\"\n        })));\n    };\n;\n})();\n(window[\"gbar\"] = ((window[\"gbar\"] || {\n})))._CONFIG = [[[0,\"www.gstatic.com\",\"og.og.en_US.L-7sWZRn8Fk.O\",\"com\",\"en\",\"1\",0,[\"2\",\"2\",\".36.40.65.70.\",\"r_qf.\",\"0\",\"1372717546\",\"1372341082\",],\"37102\",\"uJbdUZ3sONTYyAHI-IHoCA\",0,0,\"og.og.-krlms5hen2wq.L.F4.O\",\"AItRSTPeWOYRYdxy8ogBqCfqYf5-akG9rw\",\"AItRSTOaIkSWFupuExr0K5Hwl7VpuFhjOw\",],null,0,[\"m;/_/scs/abc-static/_/js/k=gapi.gapi.en.aBqw11eoBzM.O/m=__features__/am=EA/rt=j/d=1/rs=AItRSTMkiisOVRW5P7l3Ig59NtxV0JdMMA\",\"http://jsbngssl.apis.google.com\",\"\",\"\",\"\",\"\",\"\",1,\"es_plusone_gc_20130619.0_p0\",],[\"1\",\"gci_91f30755d6a6b787dcc2a4062e6e9824.js\",\"googleapis.client:plusone\",\"\",\"en\",],null,null,null,[\"0.01\",\"com\",\"1\",[[\"\",\"\",\"\",],\"\",\"w\",[\"\",\"\",\"\",],],[[\"\",\"\",\"\",],\"\",[\"\",\"\",\"\",],0,0,],],null,[0,0,0,0,\"\",],[1,\"0.001\",\"1.0\",],[1,\"0.1\",],[],[],[],[[\"\",],[\"\",],],],];");
// 953
geval("{\n    function e153384e2bbdb8f88631a9c9ac7fff7b593b9ceec(JSBNG__event) {\n        try {\n            if (!google.j.b) {\n                ((JSBNG__document.f && JSBNG__document.f.q.JSBNG__focus()));\n                ((JSBNG__document.gbqf && JSBNG__document.gbqf.q.JSBNG__focus()));\n            }\n        ;\n        ;\n        } catch (e) {\n        \n        };\n    ;\n        if (JSBNG__document.images) {\n            new JSBNG__Image().src = \"/images/nav_logo129.png\";\n        }\n    ;\n    ;\n    };\n    ((window.top.JSBNG_Replay.sbcd2c599c3a3e31210e95c8713224c80f8baadbe_0.push)((e153384e2bbdb8f88631a9c9ac7fff7b593b9ceec)));\n};\n;");
// 954
geval("if (google.j.b) {\n    JSBNG__document.body.style.visibility = \"hidden\";\n}\n;\n;");
// 956
ow895948954.JSBNG__innerHeight = 603;
// 957
ow895948954.JSBNG__innerHeight = 603;
// 958
ow895948954.JSBNG__innerWidth = 994;
// 959
ow895948954.JSBNG__innerWidth = 994;
// 960
o0.getElementById = f895948954_393;
// 964
o9.className = "";
// 965
o9.className = "";
// 967
o0.getElementById = f895948954_393;
// 955
geval("((((window.gbar && gbar.eli)) && gbar.eli()));");
// 969
geval("function eae4346d72bc8f96062bb7ab2b12e961d1ad85557(JSBNG__event) {\n    gbar.logger.il(1, {\n        t: 119\n    });\n};\n;");
// 970
geval("function ec6bc5503a6badeb76b0e93a2a5ad36db520897ab(JSBNG__event) {\n    gbar.logger.il(1, {\n        t: 1\n    });\n};\n;");
// 971
geval("function ec4e689506b357941dd951ca10cf9880303fe7065(JSBNG__event) {\n    gbar.qs(this);\n    gbar.logger.il(1, {\n        t: 2\n    });\n};\n;");
// 972
geval("function e045488247597dc620d04c272fa1750333d86a019(JSBNG__event) {\n    gbar.qs(this);\n    gbar.logger.il(1, {\n        t: 8\n    });\n};\n;");
// 973
geval("function e048cab60887eee68f84fca757c326c5630b6e15a(JSBNG__event) {\n    gbar.logger.il(1, {\n        t: 78\n    });\n};\n;");
// 974
geval("function eef1dd6f0c7bf2d9196e9a68776ebd2b031db6834(JSBNG__event) {\n    gbar.qs(this);\n    gbar.logger.il(1, {\n        t: 36\n    });\n};\n;");
// 975
geval("function e3282b767ddf36ab57dd05244727ae00f66e35ac8(JSBNG__event) {\n    gbar.logger.il(1, {\n        t: 5\n    });\n};\n;");
// 976
geval("function eda2ffe93842b31e3aaf8217b7ced26dcec419dfd(JSBNG__event) {\n    gbar.logger.il(1, {\n        t: 23\n    });\n};\n;");
// 977
geval("function e77af0dd6e6e7476cf8d36baf7310f1b22ab44679(JSBNG__event) {\n    gbar.logger.il(1, {\n        t: 25\n    });\n};\n;");
// 978
geval("function e87bfe6ab582c47b2f33a725880993914ceda8728(JSBNG__event) {\n    gbar.logger.il(1, {\n        t: 24\n    });\n};\n;");
// 979
geval("function e3a73582e8c3e27a06e33d4cb40749b4e8d57f7ee(JSBNG__event) {\n    gbar.tg(JSBNG__event, this);\n};\n;");
// 980
geval("function e46a2a93b449da644895c069e81c918581e5269f3(JSBNG__event) {\n    gbar.qs(this);\n    gbar.logger.il(1, {\n        t: 51\n    });\n};\n;");
// 981
geval("function ec5f561288a29cd363ab3799154cb1c53a76f8010(JSBNG__event) {\n    gbar.logger.il(1, {\n        t: 17\n    });\n};\n;");
// 982
geval("function ec59fc75ddd43928f56f890cdd127b8c207e66983(JSBNG__event) {\n    gbar.qs(this);\n    gbar.logger.il(1, {\n        t: 10\n    });\n};\n;");
// 983
geval("function ed850d9ca7ba45024eeb96ba160c4f618e935e7f4(JSBNG__event) {\n    gbar.logger.il(1, {\n        t: 172\n    });\n};\n;");
// 984
geval("function e77efa1cefed8d3bc4fc729bcbdc13c33aec807c0(JSBNG__event) {\n    gbar.logger.il(1, {\n        t: 212\n    });\n};\n;");
// 985
geval("function eb705422081f45b9f08e7f2252ae7b9241b486c2f(JSBNG__event) {\n    gbar.qs(this);\n    gbar.logger.il(1, {\n        t: 6\n    });\n};\n;");
// 986
geval("function e12845d1ea727e336c85ce5b7e8c9cd5c1831a225(JSBNG__event) {\n    gbar.logger.il(1, {\n        t: 30\n    });\n};\n;");
// 987
geval("function e476e68dc359c79dcc26d23bf0cce935a06e90a58(JSBNG__event) {\n    gbar.qs(this);\n    gbar.logger.il(1, {\n        t: 27\n    });\n};\n;");
// 988
geval("function e377362bfe2a628644f682b306af8f1500097422f(JSBNG__event) {\n    gbar.qs(this);\n    gbar.logger.il(1, {\n        t: 31\n    });\n};\n;");
// 989
geval("function e7f4e9514ba8d6802de006ec97b95918cc605284d(JSBNG__event) {\n    gbar.qs(this);\n    gbar.logger.il(1, {\n        t: 12\n    });\n};\n;");
// 990
geval("function ea610ec43459576430a2749c639ffd5c9165b2ed6(JSBNG__event) {\n    gbar.logger.il(1, {\n        t: 66\n    });\n};\n;");
// 991
geval("function e8f4137518d5cff579195e99a689dceee0b296dfc(JSBNG__event) {\n    gbar.logger.il(39);\n};\n;");
// 992
geval("function eaf547de4537d51c80fc57ae316d443bb1bb947cf(JSBNG__event) {\n    gbar.logger.il(31);\n};\n;");
// 993
geval("function eab7f7ec6a10fd1352f1a37ab00d2abcbd864f82d(JSBNG__event) {\n    google.x(this, function() {\n        ((google.ifl && google.ifl.o()));\n    });\n};\n;");
// 994
geval("function ee036a5c8eb25b8246ce8e4506057fae892972219(JSBNG__event) {\n    gbar.logger.il(9, {\n        l: \"i\"\n    });\n};\n;");
// 996
o0.getElementById = f895948954_393;
// 999
o0.getElementById = f895948954_393;
// 1006
o0.getElementById = f895948954_393;
// 1009
o0.getElementById = f895948954_393;
// 1011
o0.getElementById = f895948954_393;
// 1014
o0.getElementById = f895948954_393;
// 1016
o0.getElementById = f895948954_393;
// 1018
o0.getElementById = f895948954_393;
// 1020
o0.getElementById = f895948954_393;
// 1022
o0.getElementById = f895948954_393;
// 1024
o0.getElementById = f895948954_393;
// 1026
o0.getElementById = f895948954_393;
// 1029
o0.getElementById = f895948954_393;
// 1035
o0.getElementById = f895948954_393;
// 1038
o0.getElementById = f895948954_393;
// 1041
o0.getElementById = f895948954_393;
// 1045
o0.getElementById = f895948954_393;
// 1047
o0.getElementById = f895948954_393;
// 1049
o10.clientWidth = 73;
// 1050
o0.getElementById = f895948954_393;
// 1056
o13.style = o14;
// 1058
o13.style = o14;
// 995
geval("((((window.gbar && gbar.elp)) && gbar.elp()));");
// 1060
geval("function eb9de603517591e48f057c7e6086bbd305cb1ab63(JSBNG__event) {\n    ((((google.promos && google.promos.toast)) && google.promos.toast.cpc()));\n};\n;");
// 1061
geval("function ecb5dd2f554ffdaa5dbca76b6834768842fd1de9a(JSBNG__event) {\n    ((((google.promos && google.promos.toast)) && google.promos.toast.cl()));\n};\n;");
// 1063
o0.getElementById = f895948954_393;
// 1062
geval("(function() {\n    var a = {\n        v: \"a\",\n        w: \"c\",\n        i: \"d\",\n        k: \"h\",\n        g: \"i\",\n        K: \"n\",\n        Q: \"x\",\n        H: \"ma\",\n        I: \"mc\",\n        J: \"mi\",\n        A: \"pa\",\n        B: \"pc\",\n        D: \"pi\",\n        G: \"pn\",\n        F: \"px\",\n        C: \"pd\",\n        L: \"gpa\",\n        N: \"gpi\",\n        O: \"gpn\",\n        P: \"gpx\",\n        M: \"gpd\"\n    };\n    var c = {\n        o: \"hplogo\",\n        s: \"pmocntr2\"\n    }, e, g, k = JSBNG__document.getElementById(c.s);\n    google.promos = ((google.promos || {\n    }));\n    google.promos.toast = ((google.promos.toast || {\n    }));\n    function l(b) {\n        ((k && (k.style.display = ((b ? \"\" : \"none\")), ((k.parentNode && (k.parentNode.style.position = ((b ? \"relative\" : \"\"))))))));\n    };\n;\n    function m(b) {\n        try {\n            if (((((((k && b)) && b.es)) && b.es.m))) {\n                var d = ((window.gbar.rtl(JSBNG__document.body) ? \"left\" : \"right\"));\n                k.style[d] = ((((((b.es.m - 16)) + 2)) + \"px\"));\n                k.style.JSBNG__top = \"20px\";\n            }\n        ;\n        ;\n        } catch (f) {\n            google.ml(f, !1, {\n                cause: ((e + \"_PT\"))\n            });\n        };\n    ;\n    };\n;\n    google.promos.toast.cl = function() {\n        try {\n            window.gbar.up.sl(g, e, a.k, void 0, 1);\n        } catch (b) {\n            google.ml(b, !1, {\n                cause: ((e + \"_CL\"))\n            });\n        };\n    ;\n    };\n    google.promos.toast.cpc = function() {\n        try {\n            ((k && (l(!1), window.gbar.up.spd(k, c.a, 1, !0), window.gbar.up.sl(g, e, a.i, void 0, 1))));\n        } catch (b) {\n            google.ml(b, !1, {\n                cause: ((e + \"_CPC\"))\n            });\n        };\n    ;\n    };\n    google.promos.toast.hideOnSmallWindow_ = function() {\n        try {\n            if (k) {\n                var b = 276, d = JSBNG__document.getElementById(c.o);\n                ((d && (b = Math.max(b, d.offsetWidth))));\n                var f = ((parseInt(k.style.right, 10) || 0));\n                k.style.visibility = ((((((((2 * ((k.offsetWidth + f)))) + b)) > JSBNG__document.body.clientWidth)) ? \"hidden\" : \"\"));\n            }\n        ;\n        ;\n        } catch (h) {\n            google.ml(h, !1, {\n                cause: ((e + \"_HOSW\"))\n            });\n        };\n    ;\n    };\n    function q() {\n        var b = [\"gpd\",\"spd\",\"aeh\",\"sl\",];\n        if (((!window.gbar || !window.gbar.up))) {\n            return !1;\n        }\n    ;\n    ;\n        for (var d = 0, f; f = b[d]; d++) {\n            if (!((f in window.gbar.up))) {\n                return !1;\n            }\n        ;\n        ;\n        };\n    ;\n        return !0;\n    };\n;\n    google.promos.toast.init = function(b, d, f, h, n) {\n        try {\n            if (!q()) {\n                google.ml(Error(\"apa\"), !1, {\n                    cause: ((e + \"_INIT\"))\n                });\n            }\n             else {\n                if (k) {\n                    window.gbar.up.aeh(window, \"resize\", google.promos.toast.hideOnSmallWindow_);\n                    window.lol = google.promos.toast.hideOnSmallWindow_;\n                    c.d = ((((\"toast_count_\" + d)) + ((h ? ((\"_\" + h)) : \"\"))));\n                    c.a = ((((\"toast_dp_\" + d)) + ((n ? ((\"_\" + n)) : \"\"))));\n                    e = f;\n                    g = b;\n                    var p = ((window.gbar.up.gpd(k, c.d, !0) || 0));\n                    ((((((window.gbar.up.gpd(k, c.a, !0) || ((25 < p)))) || ((k.currentStyle && ((\"absolute\" != k.currentStyle.position)))))) ? l(!1) : (window.gbar.up.spd(k, c.d, ++p, !0), ((window.gbar.elr && m(window.gbar.elr()))), ((window.gbar.elc && window.gbar.elc(m))), l(!0), window.gbar.up.sl(g, e, a.g))));\n                }\n            ;\n            }\n        ;\n        ;\n        } catch (r) {\n            google.ml(r, !1, {\n                cause: ((e + \"_INIT\"))\n            });\n        };\n    ;\n    };\n})();");
// 1066
geval("(function() {\n    var sourceWebappPromoID = 144002;\n    var sourceWebappGroupID = 5;\n    var payloadType = 5;\n    ((((((window.gbar && gbar.up)) && gbar.up.r)) && gbar.up.r(payloadType, function(show) {\n        if (show) {\n            google.promos.toast.init(sourceWebappPromoID, sourceWebappGroupID, payloadType, \"0612\");\n        }\n    ;\n    ;\n    })));\n})();");
// 1067
geval("function eef50192d0e0654bc148db359edb6aaecd1ea3ba9(JSBNG__event) {\n    ((window.lol && lol()));\n};\n;");
// 1074
o0.cookie = "PREF=ID=1027cc612e36f2f9:FF=0:TM=1373476536:LM=1373476536:S=0SCCQkPlw7pcnOlV";
// 1075
o2.getItem = f895948954_406;
// 1078
o0.cookie = "PREF=ID=1027cc612e36f2f9:FF=0:TM=1373476536:LM=1373476536:S=0SCCQkPlw7pcnOlV";
// 1084
o0.defaultView = ow895948954;
// 1091
o15.style = o18;
// 1093
o15.style = o18;
// 1094
o0.getElementById = f895948954_393;
// 1097
o0.getElementById = f895948954_393;
// 1101
o0.getElementById = f895948954_393;
// 1103
o0.getElementById = f895948954_393;
// 1105
o10.clientWidth = 73;
// 1106
o0.getElementById = f895948954_393;
// 1112
o13.style = o14;
// 1114
o13.style = o14;
// undefined
o13 = null;
// undefined
o14 = null;
// 1068
geval("((((((window.gbar && gbar.up)) && gbar.up.tp)) && gbar.up.tp()));");
// 1116
geval("function eb9de603517591e48f057c7e6086bbd305cb1ab63(JSBNG__event) {\n    ((((google.promos && google.promos.toast)) && google.promos.toast.cpc()));\n};\n;");
// 1117
geval("function ecb5dd2f554ffdaa5dbca76b6834768842fd1de9a(JSBNG__event) {\n    ((((google.promos && google.promos.toast)) && google.promos.toast.cl()));\n};\n;");
// 1119
o0.getElementById = f895948954_393;
// 1118
geval("(function() {\n    var a = {\n        v: \"a\",\n        w: \"c\",\n        i: \"d\",\n        k: \"h\",\n        g: \"i\",\n        K: \"n\",\n        Q: \"x\",\n        H: \"ma\",\n        I: \"mc\",\n        J: \"mi\",\n        A: \"pa\",\n        B: \"pc\",\n        D: \"pi\",\n        G: \"pn\",\n        F: \"px\",\n        C: \"pd\",\n        L: \"gpa\",\n        N: \"gpi\",\n        O: \"gpn\",\n        P: \"gpx\",\n        M: \"gpd\"\n    };\n    var c = {\n        o: \"hplogo\",\n        s: \"pmocntr2\"\n    }, e, g, k = JSBNG__document.getElementById(c.s);\n    google.promos = ((google.promos || {\n    }));\n    google.promos.toast = ((google.promos.toast || {\n    }));\n    function l(b) {\n        ((k && (k.style.display = ((b ? \"\" : \"none\")), ((k.parentNode && (k.parentNode.style.position = ((b ? \"relative\" : \"\"))))))));\n    };\n;\n    function m(b) {\n        try {\n            if (((((((k && b)) && b.es)) && b.es.m))) {\n                var d = ((window.gbar.rtl(JSBNG__document.body) ? \"left\" : \"right\"));\n                k.style[d] = ((((((b.es.m - 16)) + 2)) + \"px\"));\n                k.style.JSBNG__top = \"20px\";\n            }\n        ;\n        ;\n        } catch (f) {\n            google.ml(f, !1, {\n                cause: ((e + \"_PT\"))\n            });\n        };\n    ;\n    };\n;\n    google.promos.toast.cl = function() {\n        try {\n            window.gbar.up.sl(g, e, a.k, void 0, 1);\n        } catch (b) {\n            google.ml(b, !1, {\n                cause: ((e + \"_CL\"))\n            });\n        };\n    ;\n    };\n    google.promos.toast.cpc = function() {\n        try {\n            ((k && (l(!1), window.gbar.up.spd(k, c.a, 1, !0), window.gbar.up.sl(g, e, a.i, void 0, 1))));\n        } catch (b) {\n            google.ml(b, !1, {\n                cause: ((e + \"_CPC\"))\n            });\n        };\n    ;\n    };\n    google.promos.toast.hideOnSmallWindow_ = function() {\n        try {\n            if (k) {\n                var b = 276, d = JSBNG__document.getElementById(c.o);\n                ((d && (b = Math.max(b, d.offsetWidth))));\n                var f = ((parseInt(k.style.right, 10) || 0));\n                k.style.visibility = ((((((((2 * ((k.offsetWidth + f)))) + b)) > JSBNG__document.body.clientWidth)) ? \"hidden\" : \"\"));\n            }\n        ;\n        ;\n        } catch (h) {\n            google.ml(h, !1, {\n                cause: ((e + \"_HOSW\"))\n            });\n        };\n    ;\n    };\n    function q() {\n        var b = [\"gpd\",\"spd\",\"aeh\",\"sl\",];\n        if (((!window.gbar || !window.gbar.up))) {\n            return !1;\n        }\n    ;\n    ;\n        for (var d = 0, f; f = b[d]; d++) {\n            if (!((f in window.gbar.up))) {\n                return !1;\n            }\n        ;\n        ;\n        };\n    ;\n        return !0;\n    };\n;\n    google.promos.toast.init = function(b, d, f, h, n) {\n        try {\n            if (!q()) {\n                google.ml(Error(\"apa\"), !1, {\n                    cause: ((e + \"_INIT\"))\n                });\n            }\n             else {\n                if (k) {\n                    window.gbar.up.aeh(window, \"resize\", google.promos.toast.hideOnSmallWindow_);\n                    window.lol = google.promos.toast.hideOnSmallWindow_;\n                    c.d = ((((\"toast_count_\" + d)) + ((h ? ((\"_\" + h)) : \"\"))));\n                    c.a = ((((\"toast_dp_\" + d)) + ((n ? ((\"_\" + n)) : \"\"))));\n                    e = f;\n                    g = b;\n                    var p = ((window.gbar.up.gpd(k, c.d, !0) || 0));\n                    ((((((window.gbar.up.gpd(k, c.a, !0) || ((25 < p)))) || ((k.currentStyle && ((\"absolute\" != k.currentStyle.position)))))) ? l(!1) : (window.gbar.up.spd(k, c.d, ++p, !0), ((window.gbar.elr && m(window.gbar.elr()))), ((window.gbar.elc && window.gbar.elc(m))), l(!0), window.gbar.up.sl(g, e, a.g))));\n                }\n            ;\n            }\n        ;\n        ;\n        } catch (r) {\n            google.ml(r, !1, {\n                cause: ((e + \"_INIT\"))\n            });\n        };\n    ;\n    };\n})();");
// 1122
geval("(function() {\n    var sourceWebappPromoID = 144002;\n    var sourceWebappGroupID = 5;\n    var payloadType = 5;\n    ((((((window.gbar && gbar.up)) && gbar.up.r)) && gbar.up.r(payloadType, function(show) {\n        if (show) {\n            google.promos.toast.init(sourceWebappPromoID, sourceWebappGroupID, payloadType, \"0612\");\n        }\n    ;\n    ;\n    })));\n})();");
// 1123
geval("function eef50192d0e0654bc148db359edb6aaecd1ea3ba9(JSBNG__event) {\n    ((window.lol && lol()));\n};\n;");
// 1126
o0.cookie = "PREF=ID=1027cc612e36f2f9:FF=0:TM=1373476536:LM=1373476536:S=0SCCQkPlw7pcnOlV";
// 1128
o2.getItem = f895948954_406;
// 1130
o0.cookie = "PREF=ID=1027cc612e36f2f9:FF=0:TM=1373476536:LM=1373476536:S=0SCCQkPlw7pcnOlV";
// 1131
o2.getItem = f895948954_406;
// 1134
o0.cookie = "PREF=ID=1027cc612e36f2f9:FF=0:TM=1373476536:LM=1373476536:S=0SCCQkPlw7pcnOlV";
// 1136
o2.setItem = f895948954_407;
// undefined
o2 = null;
// 1139
o0.body = o16;
// 1140
o0.defaultView = ow895948954;
// 1147
o15.style = o18;
// 1149
o15.style = o18;
// undefined
o18 = null;
// 1150
o0.getElementById = f895948954_393;
// 1154
o15.parentNode = o12;
// undefined
o15 = null;
// undefined
o12 = null;
// 1124
geval("((((((window.gbar && gbar.up)) && gbar.up.tp)) && gbar.up.tp()));");
// 1159
o0.getElementById = f895948954_393;
// 1163
o0.getElementById = f895948954_393;
// 1158
geval("try {\n    (function() {\n        var _co = \"[\\\"body\\\",\\\"footer\\\",\\\"xjsi\\\"]\";\n        var _mstr = \"\\u003Cspan class=ctr-p id=body\\u003E\\u003C/span\\u003E\\u003Cspan class=ctr-p id=footer\\u003E\\u003C/span\\u003E\\u003Cspan id=xjsi\\u003E\\u003C/span\\u003E\";\n        function _gjp() {\n            ((!((JSBNG__location.hash && _gjuc())) && JSBNG__setTimeout(_gjp, 500)));\n        };\n    ;\n        var _coarr = eval(((((\"(\" + _co)) + \")\")));\n        google.j[1] = {\n            cc: [],\n            co: _coarr,\n            bl: [\"mngb\",\"gb_\",],\n            funcs: [{\n                n: \"pcs\",\n                i: \"gstyle\",\n                css: JSBNG__document.getElementById(\"gstyle\").innerHTML,\n                is: \"\",\n                r: true,\n                sc: true\n            },{\n                n: \"pc\",\n                i: \"cst\",\n                h: JSBNG__document.getElementById(\"cst\").innerHTML,\n                is: \"\",\n                r: true,\n                sc: true\n            },{\n                n: \"pc\",\n                i: \"main\",\n                h: _mstr,\n                is: \"\",\n                r: true,\n                sc: true\n            },]\n        };\n    })();\n} catch (JSBNG_ex) {\n\n};");
// 1167
geval("function wgjp() {\n    var xjs = JSBNG__document.createElement(\"script\");\n    xjs.src = JSBNG__document.getElementById(\"ecs\").getAttribute(\"data-url\");\n    ((JSBNG__document.getElementById(\"xjsd\") || JSBNG__document.body)).appendChild(xjs);\n};\n;\n;");
// 1168
geval("if (google.y) {\n    google.y.first = [];\n}\n;\n;\n(function() {\n    function b(a) {\n        window.JSBNG__setTimeout(function() {\n            var c = JSBNG__document.createElement(\"script\");\n            c.src = a;\n            JSBNG__document.getElementById(\"xjsd\").appendChild(c);\n        }, 0);\n    };\n;\n    google.dljp = function(a) {\n        ((google.xjsi || (google.xjsu = a, b(a))));\n    };\n    google.dlj = b;\n})();\nif (!google.xjs) {\n    window._ = ((window._ || {\n    }));\n    window._._DumpException = function(e) {\n        throw e;\n    };\n    if (((google.timers && google.timers.load.t))) {\n        google.timers.load.t.xjsls = new JSBNG__Date().getTime();\n    }\n;\n;\n    google.dljp(\"/xjs/_/js/k=xjs.s.en_US.l3EGKs4A4V8.O/m=c,sb,cr,cdos,jp,vm,tbui,mb,wobnm,cfm,abd,bihu,kp,lu,imap,m,tnv,erh,hv,lc,ob,r,sf,sfa,tbpr,hsm,j,p,pcc,csi/am=yA/rt=j/d=1/sv=1/rs=AItRSTMbb91OwALJtHUarrkHc6mnQdhy-A\");\n    google.xjs = 1;\n}\n;\n;\ngoogle.pmc = {\n    c: {\n    },\n    sb: {\n        agen: false,\n        cgen: true,\n        client: \"hp\",\n        dh: true,\n        ds: \"\",\n        eqch: true,\n        fl: true,\n        host: \"google.com\",\n        jsonp: true,\n        lyrs: 29,\n        msgs: {\n            lcky: \"I&#39;m Feeling Lucky\",\n            lml: \"Learn more\",\n            oskt: \"Input tools\",\n            psrc: \"This search was removed from your \\u003Ca href=\\\"/history\\\"\\u003EWeb History\\u003C/a\\u003E\",\n            psrl: \"Remove\",\n            sbit: \"Search by image\",\n            srch: \"Google Search\"\n        },\n        ovr: {\n            ent: 1,\n            l: 1,\n            ms: 1\n        },\n        pq: \"\",\n        psy: \"p\",\n        qcpw: false,\n        scd: 10,\n        sce: 4,\n        stok: \"umXjRAuqAKZoHP5587xA30Rb4f0\"\n    },\n    cr: {\n        eup: false,\n        qir: true,\n        rctj: true,\n        ref: false,\n        uff: false\n    },\n    cdos: {\n        dima: \"b\"\n    },\n    gf: {\n        pid: 196\n    },\n    jp: {\n        mcr: 5\n    },\n    vm: {\n        bv: 48705608,\n        d: \"aWc\",\n        tc: true,\n        te: true,\n        tk: true,\n        ts: true\n    },\n    tbui: {\n        dfi: {\n            am: [\"Jan\",\"Feb\",\"Mar\",\"Apr\",\"May\",\"Jun\",\"Jul\",\"Aug\",\"Sep\",\"Oct\",\"Nov\",\"Dec\",],\n            df: [\"EEEE, MMMM d, y\",\"MMMM d, y\",\"MMM d, y\",\"M/d/yyyy\",],\n            fdow: 6,\n            nw: [\"S\",\"M\",\"T\",\"W\",\"T\",\"F\",\"S\",],\n            wm: [\"January\",\"February\",\"March\",\"April\",\"May\",\"June\",\"July\",\"August\",\"September\",\"October\",\"November\",\"December\",]\n        },\n        g: 28,\n        k: true,\n        m: {\n            app: true,\n            bks: true,\n            blg: true,\n            dsc: true,\n            fin: true,\n            flm: true,\n            frm: true,\n            isch: true,\n            klg: true,\n            map: true,\n            mobile: true,\n            nws: true,\n            plcs: true,\n            ppl: true,\n            prc: true,\n            pts: true,\n            rcp: true,\n            shop: true,\n            vid: true\n        },\n        t: null\n    },\n    mb: {\n        db: false,\n        m_errors: {\n            \"default\": \"\\u003Cfont color=red\\u003EError:\\u003C/font\\u003E The server could not complete your request.  Try again in 30 seconds.\"\n        },\n        m_tip: \"Click for more information\",\n        nlpm: \"-153px -84px\",\n        nlpp: \"-153px -70px\",\n        utp: true\n    },\n    wobnm: {\n    },\n    cfm: {\n        data_url: \"/m/financedata?output=search&source=mus\"\n    },\n    abd: {\n        abd: false,\n        dabp: false,\n        deb: false,\n        der: false,\n        det: false,\n        psa: false,\n        sup: false\n    },\n    adp: {\n    },\n    adp: {\n    },\n    llc: {\n        carmode: \"list\",\n        cns: false,\n        dst: 3185505,\n        fling_time: 300,\n        float: true,\n        hot: false,\n        ime: true,\n        mpi: 0,\n        oq: \"\",\n        p: false,\n        sticky: true,\n        t: false,\n        udp: 600,\n        uds: 600,\n        udt: 600,\n        urs: false,\n        usr: true\n    },\n    rkab: {\n        bl: \"Feedback / More info\",\n        db: \"Reported\",\n        di: \"Thank you.\",\n        dl: \"Report another problem\",\n        rb: \"Wrong?\",\n        ri: \"Please report the problem.\",\n        rl: \"Cancel\"\n    },\n    bihu: {\n        MESSAGES: {\n            msg_img_from: \"Image from %1$s\",\n            msg_ms: \"More sizes\",\n            msg_si: \"Similar\"\n        }\n    },\n    riu: {\n        cnfrm: \"Reported\",\n        prmpt: \"Report\"\n    },\n    ifl: {\n        opts: [{\n            href: \"/url?url=/doodles/martha-grahams-117th-birthday\",\n            id: \"doodley\",\n            msg: \"I'm Feeling Doodley\"\n        },{\n            href: \"/url?url=http://www.googleartproject.com/collection/musee-dorsay-paris/artwork/dancers-edgar-degas/484111/&sa=t&usg=AFQjCNFvuPd-FAaZasCyDYcccCCOr4NcPw\",\n            id: \"artistic\",\n            msg: \"I'm Feeling Artistic\"\n        },{\n            href: \"/url?url=/search?q%3Drestaurants%26tbm%3Dplcs\",\n            id: \"hungry\",\n            msg: \"I'm Feeling Hungry\"\n        },{\n            href: \"/url?url=http://agoogleaday.com/%23date%3D2012-07-17&sa=t&usg=AFQjCNH4uOAvdBFnSR2cdquCknLiNgI-lg\",\n            id: \"puzzled\",\n            msg: \"I'm Feeling Puzzled\"\n        },{\n            href: \"/url?url=/trends/hottrends\",\n            id: \"trendy\",\n            msg: \"I'm Feeling Trendy\"\n        },{\n            href: \"/url?url=/earth/explore/showcase/hubble20th.html%23tab%3Dcrab-nebula\",\n            id: \"stellar\",\n            msg: \"I'm Feeling Stellar\"\n        },{\n            href: \"/url?url=/doodles/les-pauls-96th-birthday\",\n            id: \"playful\",\n            msg: \"I'm Feeling Playful\"\n        },{\n            href: \"/url?url=/intl/en/culturalinstitute/worldwonders/cornwall-west-devon/\",\n            id: \"wonderful\",\n            msg: \"I'm Feeling Wonderful\"\n        },]\n    },\n    rmcl: {\n        bl: \"Feedback / More info\",\n        db: \"Reported\",\n        di: \"Thank you.\",\n        dl: \"Report another problem\",\n        rb: \"Wrong?\",\n        ri: \"Please report the problem.\",\n        rl: \"Cancel\"\n    },\n    an: {\n    },\n    kp: {\n        use_top_media_styles: true\n    },\n    rk: {\n        bl: \"Feedback / More info\",\n        db: \"Reported\",\n        di: \"Thank you.\",\n        dl: \"Report another problem\",\n        efe: false,\n        rb: \"Wrong?\",\n        ri: \"Please report the problem.\",\n        rl: \"Cancel\"\n    },\n    lu: {\n        cm_hov: true,\n        tt_kft: true,\n        uab: true\n    },\n    imap: {\n    },\n    m: {\n        ab: {\n            JSBNG__on: true\n        },\n        ajax: {\n            gl: \"us\",\n            hl: \"en\",\n            q: \"\"\n        },\n        css: {\n            adpbc: \"#fec\",\n            adpc: \"#fffbf2\",\n            def: false,\n            showTopNav: true\n        },\n        elastic: {\n            js: true,\n            rhs4Col: 1072,\n            rhs5Col: 1160,\n            rhsOn: true,\n            tiny: false\n        },\n        exp: {\n            lru: true,\n            tnav: true\n        },\n        kfe: {\n            adsClientId: 33,\n            clientId: 29,\n            kfeHost: \"clients1.google.com\",\n            kfeUrlPrefix: \"/webpagethumbnail?r=4&f=3&s=400:585&query=&hl=en&gl=us\",\n            vsH: 585,\n            vsW: 400\n        },\n        msgs: {\n            details: \"Result details\",\n            hPers: \"Hide private results\",\n            hPersD: \"Currently hiding private results\",\n            loading: \"Still loading...\",\n            mute: \"Mute\",\n            noPreview: \"Preview not available\",\n            sPers: \"Show all results\",\n            sPersD: \"Currently showing private results\",\n            unmute: \"Unmute\"\n        },\n        nokjs: {\n            JSBNG__on: true\n        },\n        time: {\n            hUnit: 1500\n        }\n    },\n    tnv: {\n        t: false\n    },\n    adsm: {\n    },\n    async: {\n    },\n    bds: {\n    },\n    ca: {\n    },\n    erh: {\n    },\n    hp: {\n    },\n    hv: {\n    },\n    lc: {\n    },\n    lor: {\n    },\n    ob: {\n    },\n    r: {\n    },\n    sf: {\n    },\n    sfa: {\n    },\n    shlb: {\n    },\n    st: {\n    },\n    tbpr: {\n    },\n    vs: {\n    },\n    hsm: {\n    },\n    j: {\n        ahipiou: true,\n        cspd: 0,\n        hme: true,\n        icmt: false,\n        mcr: 5,\n        tct: \" \\\\u3000?\"\n    },\n    p: {\n        ae: true,\n        avgTtfc: 2000,\n        brba: false,\n        dlen: 24,\n        dper: 3,\n        eae: true,\n        fbdc: 500,\n        fbdu: -1,\n        fbh: true,\n        fd: 1000000,\n        JSBNG__focus: true,\n        ftwd: 200,\n        gpsj: true,\n        hiue: true,\n        hpt: 310,\n        iavgTtfc: 2000,\n        kn: true,\n        knrt: true,\n        maxCbt: 1500,\n        mds: \"dfn,klg,prc,sp,mbl_he,mbl_hs,mbl_re,mbl_rs,mbl_sv\",\n        msg: {\n            dym: \"Did you mean:\",\n            gs: \"Google Search\",\n            kntt: \"Use the up and down arrow keys to select each result. Press Enter to go to the selection.\",\n            pcnt: \"New Tab\",\n            sif: \"Search instead for\",\n            srf: \"Showing results for\"\n        },\n        nprr: 1,\n        ophe: true,\n        pmt: 250,\n        pq: true,\n        rpt: 50,\n        sc: \"psy-ab\",\n        tdur: 50,\n        ufl: true\n    },\n    pcc: {\n    },\n    csi: {\n        acsi: true,\n        cbu: \"/gen_204\",\n        csbu: \"/gen_204\"\n    }\n};\ngoogle.y.first.push(function() {\n    google.loadAll([\"gf\",\"adp\",\"adp\",\"llc\",\"ifl\",\"an\",\"async\",\"vs\",]);\n    if (google.med) {\n        google.med(\"init\");\n        google.initHistory();\n        google.med(\"JSBNG__history\");\n    }\n;\n;\n    ((google.History && google.History.initialize(\"/\")));\n    ((((google.hs && google.hs.init)) && google.hs.init()));\n});\nif (((((google.j && google.j.en)) && google.j.xi))) {\n    window.JSBNG__setTimeout(google.j.xi, 0);\n}\n;\n;");
// 1174
geval("(function() {\n    var b, c, d, e;\n    function g(a, f) {\n        ((a.JSBNG__removeEventListener ? (a.JSBNG__removeEventListener(\"load\", f, !1), a.JSBNG__removeEventListener(\"error\", f, !1)) : (a.JSBNG__detachEvent(\"JSBNG__onload\", f), a.JSBNG__detachEvent(\"JSBNG__onerror\", f))));\n    };\n;\n    function h(a) {\n        e = (new JSBNG__Date).getTime();\n        ++c;\n        a = ((a || window.JSBNG__event));\n        a = ((a.target || a.srcElement));\n        g(a, h);\n    };\n;\n    var k = JSBNG__document.getElementsByTagName(\"img\");\n    b = k.length;\n    for (var l = c = 0, m; ((l < b)); ++l) {\n        m = k[l], ((((((m.complete || ((\"string\" != typeof m.src)))) || !m.src)) ? ++c : ((m.JSBNG__addEventListener ? (m.JSBNG__addEventListener(\"load\", h, !1), m.JSBNG__addEventListener(\"error\", h, !1)) : (m.JSBNG__attachEvent(\"JSBNG__onload\", h), m.JSBNG__attachEvent(\"JSBNG__onerror\", h))))));\n    ;\n    };\n;\n    d = ((b - c));\n    {\n        function n() {\n            if (google.timers.load.t) {\n                google.timers.load.t.ol = (new JSBNG__Date).getTime();\n                google.timers.load.t.iml = e;\n                google.kCSI.imc = c;\n                google.kCSI.imn = b;\n                google.kCSI.imp = d;\n                ((((void 0 !== google.stt)) && (google.kCSI.stt = google.stt)));\n                ((google.csiReport && google.csiReport()));\n            }\n        ;\n        ;\n        };\n        ((window.top.JSBNG_Replay.s2afb35f1712c138a3da2176b6be804eeb2d614f5_3.push)((n)));\n    };\n;\n    ((window.JSBNG__addEventListener ? window.JSBNG__addEventListener(\"load\", n, !1) : ((window.JSBNG__attachEvent && window.JSBNG__attachEvent(\"JSBNG__onload\", n)))));\n    google.timers.load.t.prt = e = (new JSBNG__Date).getTime();\n})();");
// 1196
o0.gbqf = o19;
// 1192
JSBNG_Replay.sbcd2c599c3a3e31210e95c8713224c80f8baadbe_0[0](o17);
// 1218
o0.getElementById = f895948954_393;
// 1226
o0.createElement = f895948954_428;
// 1232
o0.getElementById = f895948954_393;
// 1234
o0.body = o16;
// 1208
JSBNG_Replay.s2afb35f1712c138a3da2176b6be804eeb2d614f5_3[0](o17);
// undefined
o17 = null;
// 1238
JSBNG_Replay.sffd704e1601e1b9a8fa55951b1471268b42138a2_127[0]();
// 1240
fpc.call(JSBNG_Replay.scee579e12329888b8b29697b3debcf1653f58642_22[10], o6,o21);
// undefined
o21 = null;
// 1310
o22.parentNode = o23;
// undefined
o22 = null;
// 1311
o23.parentNode = o24;
// 1312
o24.parentNode = o25;
// undefined
o24 = null;
// 1313
o25.parentNode = o26;
// undefined
o25 = null;
// 1314
o26.parentNode = o27;
// undefined
o26 = null;
// 1315
o27.parentNode = o28;
// undefined
o27 = null;
// 1316
o28.parentNode = o9;
// 1317
o9.parentNode = o29;
// 1318
o29.parentNode = o16;
// 1319
o16.parentNode = o6;
// 1305
fpc.call(JSBNG_Replay.scee579e12329888b8b29697b3debcf1653f58642_22[9], o6,o30);
// undefined
o30 = null;
// 1350
o16.parentNode = o6;
// 1321
fpc.call(JSBNG_Replay.scee579e12329888b8b29697b3debcf1653f58642_22[10], o6,o31);
// undefined
o31 = null;
// 1352
f895948954_0.now = f895948954_389;
// 1353
o3.userAgent = "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.8; rv:21.0) Gecko/20100101 Firefox/21.0";
// 1354
o3.product = "Gecko";
// 1355
o3.userAgent = "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.8; rv:21.0) Gecko/20100101 Firefox/21.0";
// 1358
o0.getElementById = f895948954_393;
// 1364
o0.getElementById = f895948954_393;
// 1422
o0.getElementById = f895948954_393;
// 1425
o0.getElementById = f895948954_393;
// 1427
o0.getElementById = f895948954_393;
// 1441
o38.className = "gbzt";
// 1442
o38.className = "gbzt";
// 1443
o38.className = "gbzt";
// 1444
o38.className = "gbzt";
// 1445
o38.className = "gbzt";
// 1446
o38.className = "gbzt";
// 1447
o38.className = "gbzt";
// 1449
o39.className = "gbzt gbz0l gbp1";
// 1450
o39.className = "gbzt gbz0l gbp1";
// 1451
o39.className = "gbzt gbz0l gbp1";
// 1452
o39.className = "gbzt gbz0l gbp1";
// 1453
o39.className = "gbzt gbz0l gbp1";
// 1454
o39.className = "gbzt gbz0l gbp1";
// 1455
o39.className = "gbzt gbz0l gbp1";
// 1457
o40.className = "gbzt";
// 1458
o40.className = "gbzt";
// 1459
o40.className = "gbzt";
// 1460
o40.className = "gbzt";
// 1461
o40.className = "gbzt";
// 1462
o40.className = "gbzt";
// 1463
o40.className = "gbzt";
// 1465
o41.className = "gbzt";
// 1466
o41.className = "gbzt";
// 1467
o41.className = "gbzt";
// 1468
o41.className = "gbzt";
// 1469
o41.className = "gbzt";
// 1470
o41.className = "gbzt";
// 1471
o41.className = "gbzt";
// 1473
o42.className = "gbzt";
// 1474
o42.className = "gbzt";
// 1475
o42.className = "gbzt";
// 1476
o42.className = "gbzt";
// 1477
o42.className = "gbzt";
// 1478
o42.className = "gbzt";
// 1479
o42.className = "gbzt";
// 1481
o23.className = "gbzt";
// 1482
o23.className = "gbzt";
// 1483
o23.className = "gbzt";
// 1484
o23.className = "gbzt";
// 1485
o23.className = "gbzt";
// 1486
o23.className = "gbzt";
// 1487
o23.className = "gbzt";
// 1489
o43.className = "gbzt";
// 1490
o43.className = "gbzt";
// 1491
o43.className = "gbzt";
// 1492
o43.className = "gbzt";
// 1493
o43.className = "gbzt";
// 1494
o43.className = "gbzt";
// 1495
o43.className = "gbzt";
// 1497
o44.className = "gbzt";
// 1498
o44.className = "gbzt";
// 1499
o44.className = "gbzt";
// 1500
o44.className = "gbzt";
// 1501
o44.className = "gbzt";
// 1502
o44.className = "gbzt";
// 1503
o44.className = "gbzt";
// 1505
o45.className = "gbzt";
// 1506
o45.className = "gbzt";
// 1507
o45.className = "gbzt";
// 1508
o45.className = "gbzt";
// 1509
o45.className = "gbzt";
// 1510
o45.className = "gbzt";
// 1511
o45.className = "gbzt";
// 1513
o46.className = "gbzt";
// 1514
o46.className = "gbzt";
// 1515
o46.className = "gbzt";
// 1516
o46.className = "gbzt";
// 1517
o46.className = "gbzt";
// 1518
o46.className = "gbzt";
// 1519
o46.className = "gbzt";
// 1523
o47.JSBNG__addEventListener = f895948954_391;
// 1526
o48.className = "gbmt";
// 1527
o48.className = "gbmt";
// 1528
o48.className = "gbmt";
// 1529
o48.className = "gbmt";
// 1530
o48.className = "gbmt";
// 1531
o48.className = "gbmt";
// 1532
o48.className = "gbmt";
// 1534
o49.className = "gbmt";
// 1535
o49.className = "gbmt";
// 1536
o49.className = "gbmt";
// 1537
o49.className = "gbmt";
// 1538
o49.className = "gbmt";
// 1539
o49.className = "gbmt";
// 1540
o49.className = "gbmt";
// 1542
o50.className = "gbmt";
// 1543
o50.className = "gbmt";
// 1544
o50.className = "gbmt";
// 1545
o50.className = "gbmt";
// 1546
o50.className = "gbmt";
// 1547
o50.className = "gbmt";
// 1548
o50.className = "gbmt";
// 1550
o51.className = "gbmt";
// 1551
o51.className = "gbmt";
// 1552
o51.className = "gbmt";
// 1553
o51.className = "gbmt";
// 1554
o51.className = "gbmt";
// 1555
o51.className = "gbmt";
// 1556
o51.className = "gbmt";
// 1558
o52.className = "gbmt";
// 1559
o52.className = "gbmt";
// 1560
o52.className = "gbmt";
// 1561
o52.className = "gbmt";
// 1562
o52.className = "gbmt";
// 1563
o52.className = "gbmt";
// 1564
o52.className = "gbmt";
// 1566
o53.className = "gbmt";
// 1567
o53.className = "gbmt";
// 1568
o53.className = "gbmt";
// 1569
o53.className = "gbmt";
// 1570
o53.className = "gbmt";
// 1571
o53.className = "gbmt";
// 1572
o53.className = "gbmt";
// 1574
o54.className = "gbmt";
// 1575
o54.className = "gbmt";
// 1576
o54.className = "gbmt";
// 1577
o54.className = "gbmt";
// 1578
o54.className = "gbmt";
// 1579
o54.className = "gbmt";
// 1580
o54.className = "gbmt";
// 1582
o55.className = "gbmt";
// 1583
o55.className = "gbmt";
// 1584
o55.className = "gbmt";
// 1585
o55.className = "gbmt";
// 1586
o55.className = "gbmt";
// 1587
o55.className = "gbmt";
// 1588
o55.className = "gbmt";
// 1590
o56.className = "gbmt";
// 1591
o56.className = "gbmt";
// 1592
o56.className = "gbmt";
// 1593
o56.className = "gbmt";
// 1594
o56.className = "gbmt";
// 1595
o56.className = "gbmt";
// 1596
o56.className = "gbmt";
// 1598
o57.className = "gbmt";
// 1599
o57.className = "gbmt";
// 1600
o57.className = "gbmt";
// 1601
o57.className = "gbmt";
// 1602
o57.className = "gbmt";
// 1603
o57.className = "gbmt";
// 1604
o57.className = "gbmt";
// 1606
o58.className = "gbmt";
// 1607
o58.className = "gbmt";
// 1608
o58.className = "gbmt";
// 1609
o58.className = "gbmt";
// 1610
o58.className = "gbmt";
// 1611
o58.className = "gbmt";
// 1612
o58.className = "gbmt";
// 1614
o59.className = "gbqla";
// 1615
o59.className = "gbqla";
// 1616
o59.className = "gbqla";
// 1617
o59.className = "gbqla";
// 1618
o59.className = "gbqla";
// 1619
o59.className = "gbqla";
// 1620
o59.className = "gbqla";
// 1624
o10.JSBNG__addEventListener = f895948954_391;
// 1627
o60.className = "gbmt";
// 1628
o60.className = "gbmt";
// 1629
o60.className = "gbmt";
// 1630
o60.className = "gbmt";
// 1631
o60.className = "gbmt";
// 1632
o60.className = "gbmt";
// 1633
o60.className = "gbmt";
// 1635
o61.className = "gbmt";
// 1636
o61.className = "gbmt";
// 1637
o61.className = "gbmt";
// 1638
o61.className = "gbmt";
// 1639
o61.className = "gbmt";
// 1640
o61.className = "gbmt";
// 1641
o61.className = "gbmt";
// 1643
o62.className = "gbmt";
// 1644
o62.className = "gbmt";
// 1645
o62.className = "gbmt";
// 1646
o62.className = "gbmt";
// 1647
o62.className = "gbmt";
// 1648
o62.className = "gbmt";
// 1649
o62.className = "gbmt";
// 1651
o63.className = "gbmt";
// 1652
o63.className = "gbmt";
// 1653
o63.className = "gbmt";
// 1654
o63.className = "gbmt";
// 1655
o63.className = "gbmt";
// 1656
o63.className = "gbmt";
// 1657
o63.className = "gbmt";
// 1659
o65.className = "gbqfb";
// 1660
o65.className = "gbqfb";
// 1661
o65.className = "gbqfb";
// 1662
o65.className = "gbqfb";
// 1665
o65.JSBNG__addEventListener = f895948954_391;
// undefined
o65 = null;
// 1668
o66.className = "gbqfba";
// 1669
o66.className = "gbqfba";
// 1670
o66.className = "gbqfba";
// 1671
o66.className = "gbqfba";
// 1672
o66.className = "gbqfba";
// 1675
o66.JSBNG__addEventListener = f895948954_391;
// undefined
o66 = null;
// 1678
o67.className = "gbqfba";
// 1679
o67.className = "gbqfba";
// 1680
o67.className = "gbqfba";
// 1681
o67.className = "gbqfba";
// 1682
o67.className = "gbqfba";
// 1685
o67.JSBNG__addEventListener = f895948954_391;
// 1687
o0.getElementById = f895948954_393;
// 1689
o0.getElementById = f895948954_393;
// 1692
o0.getElementById = f895948954_393;
// 1695
o0.getElementById = f895948954_393;
// 1698
o0.getElementById = f895948954_393;
// 1705
o64.querySelector = f895948954_488;
// 1708
o64.querySelectorAll = f895948954_487;
// 1709
o64.querySelector = f895948954_488;
// 1710
o64.querySelector = f895948954_488;
// undefined
o64 = null;
// 1351
geval("(function() {\n    try {\n        var k = void 0, l = !0, n = null, p = !1, q, r = this, s = function(a, b, c) {\n            a = a.split(\".\");\n            c = ((c || r));\n            ((((!((a[0] in c)) && c.execScript)) && c.execScript(((\"var \" + a[0])))));\n            for (var d; ((a.length && (d = a.shift()))); ) {\n                ((((!a.length && ((b !== k)))) ? c[d] = b : c = ((c[d] ? c[d] : c[d] = {\n                }))));\n            ;\n            };\n        ;\n        }, ca = function(a) {\n            var b = typeof a;\n            if (((\"object\" == b))) {\n                if (a) {\n                    if (((a instanceof Array))) {\n                        return \"array\";\n                    }\n                ;\n                ;\n                    if (((a instanceof Object))) {\n                        return b;\n                    }\n                ;\n                ;\n                    var c = Object.prototype.toString.call(a);\n                    if (((\"[object Window]\" == c))) {\n                        return \"object\";\n                    }\n                ;\n                ;\n                    if (((((\"[object Array]\" == c)) || ((((((((\"number\" == typeof a.length)) && ((\"undefined\" != typeof a.splice)))) && ((\"undefined\" != typeof a.propertyIsEnumerable)))) && !a.propertyIsEnumerable(\"splice\")))))) {\n                        return \"array\";\n                    }\n                ;\n                ;\n                    if (((((\"[object Function]\" == c)) || ((((((\"undefined\" != typeof a.call)) && ((\"undefined\" != typeof a.propertyIsEnumerable)))) && !a.propertyIsEnumerable(\"call\")))))) {\n                        return \"function\";\n                    }\n                ;\n                ;\n                }\n                 else return \"null\"\n            ;\n            }\n             else {\n                if (((((\"function\" == b)) && ((\"undefined\" == typeof a.call))))) {\n                    return \"object\";\n                }\n            ;\n            }\n        ;\n        ;\n            return b;\n        }, da = function(a) {\n            var b = ca(a);\n            return ((((\"array\" == b)) || ((((\"object\" == b)) && ((\"number\" == typeof a.length))))));\n        }, u = function(a) {\n            return ((\"string\" == typeof a));\n        }, ea = function(a) {\n            var b = typeof a;\n            return ((((((\"object\" == b)) && ((a != n)))) || ((\"function\" == b))));\n        }, fa = function(a, b, c) {\n            return a.call.apply(a.bind, arguments);\n        }, ga = function(a, b, c) {\n            if (!a) {\n                throw Error();\n            }\n        ;\n        ;\n            if (((2 < arguments.length))) {\n                var d = Array.prototype.slice.call(arguments, 2);\n                return function() {\n                    var c = Array.prototype.slice.call(arguments);\n                    Array.prototype.unshift.apply(c, d);\n                    return a.apply(b, c);\n                };\n            }\n        ;\n        ;\n            return function() {\n                return a.apply(b, arguments);\n            };\n        }, x = function(a, b, c) {\n            x = ((((Function.prototype.bind && ((-1 != Function.prototype.bind.toString().indexOf(\"native code\"))))) ? fa : ga));\n            return x.apply(n, arguments);\n        }, ha = function(a, b) {\n            var c = Array.prototype.slice.call(arguments, 1);\n            return function() {\n                var b = Array.prototype.slice.call(arguments);\n                b.unshift.apply(b, c);\n                return a.apply(this, b);\n            };\n        }, ia = ((JSBNG__Date.now || function() {\n            return +new JSBNG__Date;\n        }));\n        ((window.gbar.tev && window.gbar.tev(3, \"m\")));\n        ((window.gbar.bls && window.gbar.bls(\"m\")));\n        var oa = function(a) {\n            if (!ja.test(a)) {\n                return a;\n            }\n        ;\n        ;\n            ((((-1 != a.indexOf(\"&\"))) && (a = a.replace(ka, \"&amp;\"))));\n            ((((-1 != a.indexOf(\"\\u003C\"))) && (a = a.replace(la, \"&lt;\"))));\n            ((((-1 != a.indexOf(\"\\u003E\"))) && (a = a.replace(ma, \"&gt;\"))));\n            ((((-1 != a.indexOf(\"\\\"\"))) && (a = a.replace(na, \"&quot;\"))));\n            return a;\n        }, ka = /&/g, la = /</g, ma = />/g, na = /\\\"/g, ja = /[&<>\\\"]/;\n        var y = Array.prototype, pa = ((y.indexOf ? function(a, b, c) {\n            return y.indexOf.call(a, b, c);\n        } : function(a, b, c) {\n            c = ((((c == n)) ? 0 : ((((0 > c)) ? Math.max(0, ((a.length + c))) : c))));\n            if (u(a)) {\n                return ((((!u(b) || ((1 != b.length)))) ? -1 : a.indexOf(b, c)));\n            }\n        ;\n        ;\n            for (; ((c < a.length)); c++) {\n                if (((((c in a)) && ((a[c] === b))))) {\n                    return c;\n                }\n            ;\n            ;\n            };\n        ;\n            return -1;\n        })), qa = ((y.forEach ? function(a, b, c) {\n            y.forEach.call(a, b, c);\n        } : function(a, b, c) {\n            for (var d = a.length, e = ((u(a) ? a.split(\"\") : a)), f = 0; ((f < d)); f++) {\n                ((((f in e)) && b.call(c, e[f], f, a)));\n            ;\n            };\n        ;\n        })), ra = ((y.filter ? function(a, b, c) {\n            return y.filter.call(a, b, c);\n        } : function(a, b, c) {\n            for (var d = a.length, e = [], f = 0, g = ((u(a) ? a.split(\"\") : a)), h = 0; ((h < d)); h++) {\n                if (((h in g))) {\n                    var m = g[h];\n                    ((b.call(c, m, h, a) && (e[f++] = m)));\n                }\n            ;\n            ;\n            };\n        ;\n            return e;\n        })), sa = function(a) {\n            var b = a.length;\n            if (((0 < b))) {\n                for (var c = Array(b), d = 0; ((d < b)); d++) {\n                    c[d] = a[d];\n                ;\n                };\n            ;\n                return c;\n            }\n        ;\n        ;\n            return [];\n        }, ta = function(a, b, c) {\n            return ((((2 >= arguments.length)) ? y.slice.call(a, b) : y.slice.call(a, b, c)));\n        };\n        var A = function(a, b) {\n            this.x = ((((a !== k)) ? a : 0));\n            this.y = ((((b !== k)) ? b : 0));\n        };\n        A.prototype.floor = function() {\n            this.x = Math.floor(this.x);\n            this.y = Math.floor(this.y);\n            return this;\n        };\n        var ua = function(a, b) {\n            this.width = a;\n            this.height = b;\n        };\n        ua.prototype.floor = function() {\n            this.width = Math.floor(this.width);\n            this.height = Math.floor(this.height);\n            return this;\n        };\n        var va = function(a, b) {\n            {\n                var fin5keys = ((window.top.JSBNG_Replay.forInKeys)((a))), fin5i = (0);\n                var c;\n                for (; (fin5i < fin5keys.length); (fin5i++)) {\n                    ((c) = (fin5keys[fin5i]));\n                    {\n                        b.call(k, a[c], c, a);\n                    ;\n                    };\n                };\n            };\n        ;\n        }, wa = \"constructor hasOwnProperty isPrototypeOf propertyIsEnumerable toLocaleString toString valueOf\".split(\" \"), xa = function(a, b) {\n            for (var c, d, e = 1; ((e < arguments.length)); e++) {\n                d = arguments[e];\n                {\n                    var fin6keys = ((window.top.JSBNG_Replay.forInKeys)((d))), fin6i = (0);\n                    (0);\n                    for (; (fin6i < fin6keys.length); (fin6i++)) {\n                        ((c) = (fin6keys[fin6i]));\n                        {\n                            a[c] = d[c];\n                        ;\n                        };\n                    };\n                };\n            ;\n                for (var f = 0; ((f < wa.length)); f++) {\n                    c = wa[f], ((Object.prototype.hasOwnProperty.call(d, c) && (a[c] = d[c])));\n                ;\n                };\n            ;\n            };\n        ;\n        };\n        var ya, za, Aa, Ba, Ca = function() {\n            return ((r.JSBNG__navigator ? r.JSBNG__navigator.userAgent : n));\n        };\n        Ba = Aa = za = ya = p;\n        var Da;\n        if (Da = Ca()) {\n            var Ea = r.JSBNG__navigator;\n            ya = ((0 == Da.indexOf(\"Opera\")));\n            za = ((!ya && ((-1 != Da.indexOf(\"MSIE\")))));\n            Aa = ((!ya && ((-1 != Da.indexOf(\"WebKit\")))));\n            Ba = ((((!ya && !Aa)) && ((\"Gecko\" == Ea.product))));\n        }\n    ;\n    ;\n        var Fa = ya, C = za, Ga = Ba, Ha = Aa, Ia = function() {\n            var a = r.JSBNG__document;\n            return ((a ? a.documentMode : k));\n        }, Ja;\n        t:\n        {\n            var Ka = \"\", La;\n            if (((Fa && r.JSBNG__opera))) {\n                var Ma = r.JSBNG__opera.version, Ka = ((((\"function\" == typeof Ma)) ? Ma() : Ma));\n            }\n             else {\n                if (((Ga ? La = /rv\\:([^\\);]+)(\\)|;)/ : ((C ? La = /MSIE\\s+([^\\);]+)(\\)|;)/ : ((Ha && (La = /WebKit\\/(\\S+)/))))))), La) {\n                    var Na = La.exec(Ca()), Ka = ((Na ? Na[1] : \"\"));\n                }\n            ;\n            }\n        ;\n        ;\n            if (C) {\n                var Oa = Ia();\n                if (((Oa > parseFloat(Ka)))) {\n                    Ja = String(Oa);\n                    break t;\n                }\n            ;\n            ;\n            }\n        ;\n        ;\n            Ja = Ka;\n        };\n    ;\n        var Pa = Ja, Qa = {\n        }, Ra = function(a) {\n            var b;\n            if (!(b = Qa[a])) {\n                b = 0;\n                for (var c = String(Pa).replace(/^[\\s\\xa0]+|[\\s\\xa0]+$/g, \"\").split(\".\"), d = String(a).replace(/^[\\s\\xa0]+|[\\s\\xa0]+$/g, \"\").split(\".\"), e = Math.max(c.length, d.length), f = 0; ((((0 == b)) && ((f < e)))); f++) {\n                    var g = ((c[f] || \"\")), h = ((d[f] || \"\")), m = RegExp(\"(\\\\d*)(\\\\D*)\", \"g\"), t = RegExp(\"(\\\\d*)(\\\\D*)\", \"g\");\n                    do {\n                        var v = ((m.exec(g) || [\"\",\"\",\"\",])), w = ((t.exec(h) || [\"\",\"\",\"\",]));\n                        if (((((0 == v[0].length)) && ((0 == w[0].length))))) {\n                            break;\n                        }\n                    ;\n                    ;\n                        b = ((((((((((((0 == v[1].length)) ? 0 : parseInt(v[1], 10))) < ((((0 == w[1].length)) ? 0 : parseInt(w[1], 10))))) ? -1 : ((((((((0 == v[1].length)) ? 0 : parseInt(v[1], 10))) > ((((0 == w[1].length)) ? 0 : parseInt(w[1], 10))))) ? 1 : 0)))) || ((((((0 == v[2].length)) < ((0 == w[2].length)))) ? -1 : ((((((0 == v[2].length)) > ((0 == w[2].length)))) ? 1 : 0)))))) || ((((v[2] < w[2])) ? -1 : ((((v[2] > w[2])) ? 1 : 0))))));\n                    } while (((0 == b)));\n                };\n            ;\n                b = Qa[a] = ((0 <= b));\n            }\n        ;\n        ;\n            return b;\n        }, Sa = r.JSBNG__document, Ta = ((((!Sa || !C)) ? k : ((Ia() || ((((\"CSS1Compat\" == Sa.compatMode)) ? parseInt(Pa, 10) : 5))))));\n        var Ua, Va = ((!C || ((C && ((9 <= Ta))))));\n        ((((((!Ga && !C)) || ((((C && C)) && ((9 <= Ta)))))) || ((Ga && Ra(\"1.9.1\")))));\n        var Ya = ((C && !Ra(\"9\")));\n        var Za = function(a) {\n            a = a.className;\n            return ((((u(a) && a.match(/\\S+/g))) || []));\n        }, ab = function(a, b) {\n            var c = Za(a), d = ta(arguments, 1), e = ((c.length + d.length));\n            $a(c, d);\n            a.className = c.join(\" \");\n            return ((c.length == e));\n        }, cb = function(a, b) {\n            var c = Za(a), d = ta(arguments, 1), e = bb(c, d);\n            a.className = e.join(\" \");\n            return ((e.length == ((c.length - d.length))));\n        }, $a = function(a, b) {\n            for (var c = 0; ((c < b.length)); c++) {\n                ((((0 <= pa(a, b[c]))) || a.push(b[c])));\n            ;\n            };\n        ;\n        }, bb = function(a, b) {\n            return ra(a, function(a) {\n                return !((0 <= pa(b, a)));\n            });\n        };\n        var fb = function(a) {\n            return ((a ? new db(eb(a)) : ((Ua || (Ua = new db)))));\n        }, hb = function(a, b) {\n            var c = ((b || JSBNG__document));\n            return ((((c.querySelectorAll && c.querySelector)) ? c.querySelectorAll(((\".\" + a))) : ((c.getElementsByClassName ? c.getElementsByClassName(a) : gb(a, b)))));\n        }, ib = function(a, b) {\n            var c = ((b || JSBNG__document)), d = n;\n            return (((d = ((((c.querySelectorAll && c.querySelector)) ? c.querySelector(((\".\" + a))) : hb(a, b)[0]))) || n));\n        }, gb = function(a, b) {\n            var c, d, e, f;\n            c = JSBNG__document;\n            c = ((b || c));\n            if (((((c.querySelectorAll && c.querySelector)) && a))) {\n                return c.querySelectorAll(((\"\" + ((a ? ((\".\" + a)) : \"\")))));\n            }\n        ;\n        ;\n            if (((a && c.getElementsByClassName))) {\n                var g = c.getElementsByClassName(a);\n                return g;\n            }\n        ;\n        ;\n            g = c.getElementsByTagName(\"*\");\n            if (a) {\n                f = {\n                };\n                for (d = e = 0; c = g[d]; d++) {\n                    var h = c.className;\n                    ((((((\"function\" == typeof h.split)) && ((0 <= pa(h.split(/\\s+/), a))))) && (f[e++] = c)));\n                };\n            ;\n                f.length = e;\n                return f;\n            }\n        ;\n        ;\n            return g;\n        }, kb = function(a, b) {\n            va(b, function(b, d) {\n                ((((\"style\" == d)) ? a.style.cssText = b : ((((\"class\" == d)) ? a.className = b : ((((\"for\" == d)) ? a.htmlFor = b : ((((d in jb)) ? a.setAttribute(jb[d], b) : ((((((0 == d.lastIndexOf(\"aria-\", 0))) || ((0 == d.lastIndexOf(\"data-\", 0))))) ? a.setAttribute(d, b) : a[d] = b))))))))));\n            });\n        }, jb = {\n            cellpadding: \"cellPadding\",\n            cellspacing: \"cellSpacing\",\n            colspan: \"colSpan\",\n            frameborder: \"frameBorder\",\n            height: \"height\",\n            maxlength: \"maxLength\",\n            role: \"role\",\n            rowspan: \"rowSpan\",\n            type: \"type\",\n            usemap: \"useMap\",\n            valign: \"vAlign\",\n            width: \"width\"\n        }, mb = function(a, b, c) {\n            var d = arguments, e = JSBNG__document, f = d[0], g = d[1];\n            if (((((!Va && g)) && ((g.JSBNG__name || g.type))))) {\n                f = [\"\\u003C\",f,];\n                ((g.JSBNG__name && f.push(\" name=\\\"\", oa(g.JSBNG__name), \"\\\"\")));\n                if (g.type) {\n                    f.push(\" type=\\\"\", oa(g.type), \"\\\"\");\n                    var h = {\n                    };\n                    xa(h, g);\n                    delete h.type;\n                    g = h;\n                }\n            ;\n            ;\n                f.push(\"\\u003E\");\n                f = f.join(\"\");\n            }\n        ;\n        ;\n            f = e.createElement(f);\n            ((g && ((u(g) ? f.className = g : ((((\"array\" == ca(g))) ? ab.apply(n, [f,].concat(g)) : kb(f, g)))))));\n            ((((2 < d.length)) && lb(e, f, d, 2)));\n            return f;\n        }, lb = function(a, b, c, d) {\n            function e(c) {\n                ((c && b.appendChild(((u(c) ? a.createTextNode(c) : c)))));\n            };\n        ;\n            for (; ((d < c.length)); d++) {\n                var f = c[d];\n                ((((da(f) && !((ea(f) && ((0 < f.nodeType)))))) ? qa(((nb(f) ? sa(f) : f)), e) : e(f)));\n            };\n        ;\n        }, ob = function(a, b) {\n            lb(eb(a), a, arguments, 1);\n        }, eb = function(a) {\n            return ((((9 == a.nodeType)) ? a : ((a.ownerDocument || a.JSBNG__document))));\n        }, pb = {\n            SCRIPT: 1,\n            STYLE: 1,\n            HEAD: 1,\n            IFRAME: 1,\n            OBJECT: 1\n        }, qb = {\n            IMG: \" \",\n            BR: \"\\u000a\"\n        }, rb = function(a, b, c) {\n            if (!((a.nodeName in pb))) {\n                if (((3 == a.nodeType))) {\n                    ((c ? b.push(String(a.nodeValue).replace(/(\\r\\n|\\r|\\n)/g, \"\")) : b.push(a.nodeValue)));\n                }\n                 else {\n                    if (((a.nodeName in qb))) {\n                        b.push(qb[a.nodeName]);\n                    }\n                     else {\n                        for (a = a.firstChild; a; ) {\n                            rb(a, b, c), a = a.nextSibling;\n                        ;\n                        };\n                    }\n                ;\n                }\n            ;\n            }\n        ;\n        ;\n        }, nb = function(a) {\n            if (((a && ((\"number\" == typeof a.length))))) {\n                if (ea(a)) {\n                    return ((((\"function\" == typeof a.item)) || ((\"string\" == typeof a.item))));\n                }\n            ;\n            ;\n                if (((\"function\" == ca(a)))) {\n                    return ((\"function\" == typeof a.item));\n                }\n            ;\n            ;\n            }\n        ;\n        ;\n            return p;\n        }, db = function(a) {\n            this.a = ((((a || r.JSBNG__document)) || JSBNG__document));\n        }, sb = function(a) {\n            var b = a.a;\n            a = ((((!Ha && ((\"CSS1Compat\" == b.compatMode)))) ? b.documentElement : b.body));\n            b = ((b.parentWindow || b.defaultView));\n            return ((((((C && Ra(\"10\"))) && ((b.JSBNG__pageYOffset != a.scrollTop)))) ? new A(a.scrollLeft, a.scrollTop) : new A(((b.JSBNG__pageXOffset || a.scrollLeft)), ((b.JSBNG__pageYOffset || a.scrollTop)))));\n        };\n        var tb = function(a) {\n            tb[\" \"](a);\n            return a;\n        };\n        tb[\" \"] = function() {\n        \n        };\n        var ub = function(a, b) {\n            try {\n                return tb(a[b]), l;\n            } catch (c) {\n            \n            };\n        ;\n            return p;\n        };\n        var D = function(a, b, c, d) {\n            d = ((d || {\n            }));\n            d._sn = [\"m\",b,c,].join(\".\");\n            window.gbar.logger.ml(a, d);\n        };\n        var G = window.gbar;\n        var vb = {\n            Oa: 1,\n            $a: 2,\n            Za: 3,\n            Qa: 4,\n            Pa: 5,\n            Sa: 6,\n            Ra: 7,\n            Wa: 8\n        };\n        var wb = [], yb = n, I = function(a, b) {\n            wb.push([a,b,]);\n        }, zb = function(a, b) {\n            var c = n;\n            ((b && (c = {\n                m: b\n            })));\n            ((G.tev && G.tev(a, \"m\", c)));\n        };\n        s(\"gbar.mddn\", function() {\n            for (var a = [], b = 0, c; c = wb[b]; ++b) {\n                a.push(c[0]);\n            ;\n            };\n        ;\n            return a.join(\",\");\n        }, k);\n        var Ab, Lb = function() {\n            Bb();\n            s(\"gbar.addHover\", Cb, k);\n            s(\"gbar.close\", Db, k);\n            s(\"gbar.cls\", Eb, k);\n            s(\"gbar.tg\", Fb, k);\n            s(\"gbar.rdd\", Gb, k);\n            s(\"gbar.bsy\", Hb, k);\n            s(\"gbar.op\", Ib, k);\n            G.adh(\"gbd4\", function() {\n                Jb(5);\n            });\n            G.adh(\"gbd5\", function() {\n                Jb(6);\n            });\n            Kb();\n        }, Kb = function() {\n            var a = J(\"gbg6\"), b = J(\"gbg4\");\n            ((((a && b)) && (L(a, \"click\", function() {\n                G.logger.il(42);\n            }), L(b, \"click\", function() {\n                G.logger.il(43);\n            }))));\n        }, Mb = function() {\n            ((((Ab === k)) && (Ab = /MSIE (\\d+)\\.(\\d+);/.exec(JSBNG__navigator.userAgent))));\n            return Ab;\n        }, Nb = function() {\n            var a = Mb();\n            return ((((a && ((1 < a.length)))) ? new Number(a[1]) : n));\n        }, Ob = \"\", M = k, Pb = k, Qb = k, Rb = k, Sb = p, Tb = k, Ub = \"gbgt gbg0l gbml1 gbmlb gbqfb gbqfba gbqfbb gbqfqw\".split(\" \"), L = ((JSBNG__document.JSBNG__addEventListener ? function(a, b, c, d) {\n            a.JSBNG__addEventListener(b, c, !!d);\n        } : ((JSBNG__document.JSBNG__attachEvent ? function(a, b, c) {\n            a.JSBNG__attachEvent(((\"JSBNG__on\" + b)), c);\n        } : function(a, b, c) {\n            b = ((\"JSBNG__on\" + b));\n            var d = a[b];\n            a[b] = function() {\n                var a = d.apply(this, arguments), b = c.apply(this, arguments);\n                return ((((a == k)) ? b : ((((b == k)) ? a : ((b && a))))));\n            };\n        })))), J = function(a) {\n            return JSBNG__document.getElementById(a);\n        }, Vb = function() {\n            var a = J(\"gbx1\");\n            return ((((((G.kn && G.kn())) && a)) ? a.clientWidth : ((((JSBNG__document.documentElement && JSBNG__document.documentElement.clientWidth)) ? JSBNG__document.documentElement.clientWidth : JSBNG__document.body.clientWidth))));\n        }, Wb = function(a) {\n            var b = {\n            };\n            if (((\"none\" != a.style.display))) {\n                return b.width = a.offsetWidth, b.height = a.offsetHeight, b;\n            }\n        ;\n        ;\n            var c = a.style, d = c.display, e = c.visibility, f = c.position;\n            c.visibility = \"hidden\";\n            c.position = \"absolute\";\n            c.display = \"inline\";\n            var g;\n            g = a.offsetWidth;\n            a = a.offsetHeight;\n            c.display = d;\n            c.position = f;\n            c.visibility = e;\n            b.width = g;\n            b.height = a;\n            return b;\n        }, Xb = function(a) {\n            if (((Qb === k))) {\n                var b = JSBNG__document.body.style;\n                Qb = !((((((((b.WebkitBoxShadow !== k)) || ((b.MozBoxShadow !== k)))) || ((b.boxShadow !== k)))) || ((b.BoxShadow !== k))));\n            }\n        ;\n        ;\n            if (Qb) {\n                var b = ((a.id + \"-gbxms\")), c = J(b);\n                ((c || (c = JSBNG__document.createElement(\"span\"), c.id = b, c.className = \"gbxms\", a.appendChild(c))));\n                ((((Rb === k)) && (Rb = ((c.offsetHeight < ((a.offsetHeight / 2)))))));\n                ((Rb && (c.style.height = ((((a.offsetHeight - 5)) + \"px\")), c.style.width = ((((a.offsetWidth - 3)) + \"px\")))));\n            }\n        ;\n        ;\n        }, Yb = function(a, b) {\n            if (a) {\n                var c = a.style, d = ((b || J(Ob)));\n                ((d && (((a.parentNode && a.parentNode.appendChild(d))), d = d.style, d.width = ((a.offsetWidth + \"px\")), d.height = ((a.offsetHeight + \"px\")), d.left = c.left, d.right = c.right)));\n            }\n        ;\n        ;\n        }, Zb = function(a) {\n            try {\n                if (((M && ((!G.eh[M] || !((((!a && !window.JSBNG__event)) ? 0 : ((((((a || window.JSBNG__event)).ctrlKey || ((a || window.JSBNG__event)).metaKey)) || ((2 == ((a || window.JSBNG__event)).which))))))))))) {\n                    var b = J(Ob);\n                    ((b && (b.style.cssText = \"\", b.style.visibility = \"hidden\")));\n                    var c = J(M);\n                    if (c) {\n                        c.style.cssText = \"\";\n                        c.style.visibility = \"hidden\";\n                        var d = c.getAttribute(\"aria-owner\"), e = ((d ? J(d) : n));\n                        ((e && (N(e.parentNode, \"gbto\"), e.JSBNG__blur())));\n                    }\n                ;\n                ;\n                    ((Pb && (Pb(), Pb = k)));\n                    var f = G.ch[M];\n                    if (f) {\n                        a = 0;\n                        for (var g; g = f[a]; a++) {\n                            try {\n                                g();\n                            } catch (h) {\n                                D(h, \"sb\", \"cdd1\");\n                            };\n                        ;\n                        };\n                    ;\n                    }\n                ;\n                ;\n                    M = k;\n                }\n            ;\n            ;\n            } catch (m) {\n                D(m, \"sb\", \"cdd2\");\n            };\n        ;\n        }, $b = function(a, b) {\n            try {\n                if (M) {\n                    for (var c = ((b.target || b.srcElement)); ((\"a\" != c.tagName.toLowerCase())); ) {\n                        if (((c.id == a))) {\n                            return b.cancelBubble = l, c;\n                        }\n                    ;\n                    ;\n                        c = c.parentNode;\n                    };\n                }\n            ;\n            ;\n            } catch (d) {\n                D(d, \"sb\", \"kdo\");\n            };\n        ;\n            return n;\n        }, Jb = function(a) {\n            var b = {\n                s: ((!M ? \"o\" : \"c\"))\n            };\n            ((((-1 != a)) && G.logger.il(a, b)));\n        }, bc = function(a, b) {\n            if (ub(a, \"className\")) {\n                var c = a.className;\n                ((ac(a, b) || (a.className += ((((((\"\" != c)) ? \" \" : \"\")) + b)))));\n            }\n        ;\n        ;\n        }, N = function(a, b) {\n            var c = a.className, d = RegExp(((((\"\\\\s?\\\\b\" + b)) + \"\\\\b\")));\n            ((((c && c.match(d))) && (a.className = c.replace(d, \"\"))));\n        }, ac = function(a, b) {\n            var c = RegExp(((((\"\\\\b\" + b)) + \"\\\\b\"))), d = a.className;\n            return !((!d || !d.match(c)));\n        }, Fb = function(a, b, c, d) {\n            try {\n                a = ((a || window.JSBNG__event));\n                c = ((c || p));\n                if (!Ob) {\n                    var e = JSBNG__document.createElement(\"div\");\n                    e.frameBorder = \"0\";\n                    e.tabIndex = \"-1\";\n                    Ob = e.id = \"gbs\";\n                    e.src = \"javascript:''\";\n                    e.setAttribute(\"aria-hidden\", \"true\");\n                    e.setAttribute(\"title\", \"empty\");\n                    J(\"gbw\").appendChild(e);\n                }\n            ;\n            ;\n                ((Sb || (L(JSBNG__document, \"click\", Db), L(JSBNG__document, \"keyup\", cc), Sb = l)));\n                ((c || (((a.preventDefault && a.preventDefault())), a.returnValue = p, a.cancelBubble = l)));\n                if (!b) {\n                    b = ((a.target || a.srcElement));\n                    for (var f = b.parentNode.id; !ac(b.parentNode, \"gbt\"); ) {\n                        if (((\"gb\" == f))) {\n                            return;\n                        }\n                    ;\n                    ;\n                        b = b.parentNode;\n                        f = b.parentNode.id;\n                    };\n                ;\n                }\n            ;\n            ;\n                var g = b.getAttribute(\"aria-owns\");\n                if (((g && g.length))) {\n                    if (((d || b.JSBNG__focus())), ((M == g))) Eb(g);\n                     else {\n                        var h = b.offsetWidth;\n                        a = 0;\n                        do a += ((b.offsetLeft || 0)); while (b = b.offsetParent);\n                        if (((Tb === k))) {\n                            var m = J(\"gb\"), t, v = JSBNG__document.defaultView;\n                            if (((v && v.JSBNG__getComputedStyle))) {\n                                var w = v.JSBNG__getComputedStyle(m, \"\");\n                                ((w && (t = w.direction)));\n                            }\n                             else t = ((m.currentStyle ? m.currentStyle.direction : m.style.direction));\n                        ;\n                        ;\n                            Tb = ((\"rtl\" == t));\n                        }\n                    ;\n                    ;\n                        b = ((Tb ? p : l));\n                        m = ((Tb ? p : l));\n                        ((((\"gbd\" == g)) && (m = !m)));\n                        ((M && Zb()));\n                        var z = G.bh[g];\n                        if (z) {\n                            for (var B = 0, E; E = z[B]; B++) {\n                                try {\n                                    E();\n                                } catch (F) {\n                                    D(F, \"sb\", \"t1\");\n                                };\n                            ;\n                            };\n                        }\n                    ;\n                    ;\n                        var z = a, H = J(g);\n                        if (H) {\n                            var Q = H.style, K = H.offsetWidth;\n                            if (((K < h))) {\n                                Q.width = ((h + \"px\"));\n                                var K = h, O = H.offsetWidth;\n                                ((((O != h)) && (Q.width = ((((h - ((O - h)))) + \"px\")))));\n                            }\n                        ;\n                        ;\n                            O = 5;\n                            if (((0 > z))) {\n                                var aa = Vb(), V = window.JSBNG__document, Wa = ((((\"CSS1Compat\" == V.compatMode)) ? V.documentElement : V.body)), O = ((O - ((aa - (new ua(Wa.clientWidth, Wa.clientHeight)).width))));\n                            }\n                        ;\n                        ;\n                            var Xa, ba, aa = Vb();\n                            if (m) {\n                                if (Xa = ((b ? Math.max(((((aa - z)) - K)), O) : ((((aa - z)) - h)))), ba = -((((((aa - z)) - h)) - Xa)), Mb()) {\n                                    var Gc = Nb();\n                                    if (((((6 == Gc)) || ((((7 == Gc)) && ((\"BackCompat\" == JSBNG__document.compatMode))))))) {\n                                        ba -= 2;\n                                    }\n                                ;\n                                ;\n                                }\n                            ;\n                            ;\n                            }\n                             else Xa = ((b ? z : Math.max(((((z + h)) - K)), O))), ba = ((Xa - z));\n                        ;\n                        ;\n                            var Hc = J(\"gbw\"), Ic = J(\"gb\");\n                            if (((Hc && Ic))) {\n                                var Jc = Hc.offsetLeft;\n                                ((((Jc != Ic.offsetLeft)) && (ba -= Jc)));\n                            }\n                        ;\n                        ;\n                            Xb(H);\n                            Q.right = ((m ? ((ba + \"px\")) : \"auto\"));\n                            Q.left = ((m ? \"auto\" : ((ba + \"px\"))));\n                            Q.visibility = \"visible\";\n                            var Kc = H.getAttribute(\"aria-owner\"), Lc = ((Kc ? J(Kc) : n));\n                            ((Lc && bc(Lc.parentNode, \"gbto\")));\n                            var xb = J(Ob);\n                            ((xb && (Yb(H, xb), xb.style.visibility = \"visible\")));\n                            M = g;\n                        }\n                    ;\n                    ;\n                        var Mc = G.dh[g];\n                        if (Mc) {\n                            for (B = 0; E = Mc[B]; B++) {\n                                try {\n                                    E();\n                                } catch (ie) {\n                                    D(ie, \"sb\", \"t2\");\n                                };\n                            ;\n                            };\n                        }\n                    ;\n                    ;\n                    }\n                ;\n                }\n            ;\n            ;\n            } catch (je) {\n                D(je, \"sb\", \"t3\");\n            };\n        ;\n        }, cc = function(a) {\n            if (M) {\n                try {\n                    a = ((a || window.JSBNG__event));\n                    var b = ((a.target || a.srcElement));\n                    if (((a.keyCode && b))) {\n                        if (((a.keyCode && ((27 == a.keyCode))))) {\n                            Zb();\n                        }\n                         else {\n                            if (((((((\"a\" == b.tagName.toLowerCase())) && ((-1 != b.className.indexOf(\"gbgt\"))))) && ((((13 == a.keyCode)) || ((3 == a.keyCode))))))) {\n                                var c = JSBNG__document.getElementById(M);\n                                if (c) {\n                                    var d = c.getElementsByTagName(\"a\");\n                                    ((((d && ((d.length && d[0].JSBNG__focus)))) && d[0].JSBNG__focus()));\n                                }\n                            ;\n                            ;\n                            }\n                        ;\n                        }\n                    ;\n                    }\n                ;\n                ;\n                } catch (e) {\n                    D(e, \"sb\", \"kuh\");\n                };\n            }\n        ;\n        ;\n        }, Bb = function() {\n            var a = J(\"gb\");\n            if (a) {\n                N(a, \"gbpdjs\");\n                for (var b = a.getElementsByTagName(\"a\"), a = [], c = J(\"gbqfw\"), d = 0, e; e = b[d]; d++) {\n                    a.push(e);\n                ;\n                };\n            ;\n                if (c) {\n                    var f = J(\"gbqfqw\"), d = J(\"gbqfwc\"), b = J(\"gbqfwe\");\n                    e = c.getElementsByTagName(\"button\");\n                    c = [];\n                    ((((f && !G.sg.c)) && c.push(f)));\n                    if (((e && ((0 < e.length))))) {\n                        for (var f = 0, g; g = e[f]; f++) {\n                            c.push(g);\n                        ;\n                        };\n                    }\n                ;\n                ;\n                    ((((d && b)) && (c.push(d), c.push(b))));\n                    for (d = 0; b = c[d]; d++) {\n                        a.push(b);\n                    ;\n                    };\n                ;\n                }\n            ;\n            ;\n                for (d = 0; c = a[d]; d++) {\n                    (((b = dc(c)) && ec(c, ha(fc, b))));\n                ;\n                };\n            ;\n            }\n        ;\n        ;\n        }, Cb = function(a) {\n            var b = dc(a);\n            ((b && ec(a, ha(fc, b))));\n        }, dc = function(a) {\n            for (var b = 0, c; c = Ub[b]; b++) {\n                if (ac(a, c)) {\n                    return c;\n                }\n            ;\n            ;\n            };\n        ;\n        }, ec = function(a, b) {\n            var c = function(a, b) {\n                return function(c) {\n                    try {\n                        c = ((c || window.JSBNG__event));\n                        var g, h = c.relatedTarget;\n                        g = ((((h && ub(h, \"parentNode\"))) ? h : n));\n                        var m;\n                        if (!(m = ((a === g)))) {\n                            if (((a === g))) m = p;\n                             else {\n                                for (; ((g && ((g !== a)))); ) {\n                                    g = g.parentNode;\n                                ;\n                                };\n                            ;\n                                m = ((g === a));\n                            }\n                        ;\n                        }\n                    ;\n                    ;\n                        ((m || b(c, a)));\n                    } catch (t) {\n                        D(t, \"sb\", \"bhe\");\n                    };\n                ;\n                };\n            }(a, b);\n            L(a, \"mouseover\", c);\n            L(a, \"mouseout\", c);\n        }, fc = function(a, b, c) {\n            try {\n                if (a += \"-hvr\", ((\"mouseover\" == b.type))) {\n                    bc(c, a);\n                    var d = JSBNG__document.activeElement;\n                    if (((d && ub(d, \"className\")))) {\n                        var e = ((ac(d, \"gbgt\") || ac(d, \"gbzt\"))), f = ((ac(c, \"gbgt\") || ac(c, \"gbzt\")));\n                        ((((e && f)) && d.JSBNG__blur()));\n                    }\n                ;\n                ;\n                }\n                 else ((((\"mouseout\" == b.type)) && N(c, a)));\n            ;\n            ;\n            } catch (g) {\n                D(g, \"sb\", \"moaoh\");\n            };\n        ;\n        }, gc = function(a) {\n            for (; ((a && a.hasChildNodes())); ) {\n                a.removeChild(a.firstChild);\n            ;\n            };\n        ;\n        }, Db = function(a) {\n            Zb(a);\n        }, Eb = function(a) {\n            ((((a == M)) && Zb()));\n        }, hc = function(a, b) {\n            var c = JSBNG__document.createElement(a);\n            c.className = b;\n            return c;\n        }, Gb = function(a) {\n            ((((a && ((\"visible\" == a.style.visibility)))) && (Xb(a), Yb(a))));\n        }, Hb = function() {\n            try {\n                var a = JSBNG__document.getElementById(\"gbd3\");\n                if (a) {\n                    return ((\"visible\" == a.style.visibility.toLowerCase()));\n                }\n            ;\n            ;\n            } catch (b) {\n                D(b, \"sb\", \"bsy\");\n            };\n        ;\n            return p;\n        }, Ib = function() {\n            return !!M;\n        };\n        I(\"base\", {\n            init: function() {\n                Lb();\n            }\n        });\n        var ic = function(a, b) {\n            var c;\n            t:\n            {\n                c = eb(a);\n                if (((((c.defaultView && c.defaultView.JSBNG__getComputedStyle)) && (c = c.defaultView.JSBNG__getComputedStyle(a, n))))) {\n                    c = ((((c[b] || c.getPropertyValue(b))) || \"\"));\n                    break t;\n                }\n            ;\n            ;\n                c = \"\";\n            };\n        ;\n            return ((((c || ((a.currentStyle ? a.currentStyle[b] : n)))) || ((a.style && a.style[b]))));\n        }, jc = function(a) {\n            var b;\n            try {\n                b = a.getBoundingClientRect();\n            } catch (c) {\n                return {\n                    left: 0,\n                    JSBNG__top: 0,\n                    right: 0,\n                    bottom: 0\n                };\n            };\n        ;\n            ((C && (a = a.ownerDocument, b.left -= ((a.documentElement.clientLeft + a.body.clientLeft)), b.JSBNG__top -= ((a.documentElement.clientTop + a.body.clientTop)))));\n            return b;\n        }, kc = function(a) {\n            if (((C && !((C && ((8 <= Ta))))))) {\n                return a.offsetParent;\n            }\n        ;\n        ;\n            var b = eb(a), c = ic(a, \"position\"), d = ((((\"fixed\" == c)) || ((\"absolute\" == c))));\n            for (a = a.parentNode; ((a && ((a != b)))); a = a.parentNode) {\n                if (c = ic(a, \"position\"), d = ((((((d && ((\"static\" == c)))) && ((a != b.documentElement)))) && ((a != b.body)))), ((!d && ((((((((((a.scrollWidth > a.clientWidth)) || ((a.scrollHeight > a.clientHeight)))) || ((\"fixed\" == c)))) || ((\"absolute\" == c)))) || ((\"relative\" == c))))))) {\n                    return a;\n                }\n            ;\n            ;\n            };\n        ;\n            return n;\n        }, lc = function(a) {\n            var b, c = eb(a), d = ic(a, \"position\"), e = ((((((((((Ga && c.getBoxObjectFor)) && !a.getBoundingClientRect)) && ((\"absolute\" == d)))) && (b = c.getBoxObjectFor(a)))) && ((((0 > b.JSBNG__screenX)) || ((0 > b.JSBNG__screenY)))))), f = new A(0, 0), g;\n            b = ((c ? eb(c) : JSBNG__document));\n            if (g = C) {\n                if (g = !((C && ((9 <= Ta))))) {\n                    g = ((\"CSS1Compat\" != fb(b).a.compatMode));\n                }\n            ;\n            }\n        ;\n        ;\n            g = ((g ? b.body : b.documentElement));\n            if (((a == g))) {\n                return f;\n            }\n        ;\n        ;\n            if (a.getBoundingClientRect) {\n                b = jc(a), a = sb(fb(c)), f.x = ((b.left + a.x)), f.y = ((b.JSBNG__top + a.y));\n            }\n             else {\n                if (((c.getBoxObjectFor && !e))) b = c.getBoxObjectFor(a), a = c.getBoxObjectFor(g), f.x = ((b.JSBNG__screenX - a.JSBNG__screenX)), f.y = ((b.JSBNG__screenY - a.JSBNG__screenY));\n                 else {\n                    e = a;\n                    do {\n                        f.x += e.offsetLeft;\n                        f.y += e.offsetTop;\n                        ((((e != a)) && (f.x += ((e.clientLeft || 0)), f.y += ((e.clientTop || 0)))));\n                        if (((Ha && ((\"fixed\" == ic(e, \"position\")))))) {\n                            f.x += c.body.scrollLeft;\n                            f.y += c.body.scrollTop;\n                            break;\n                        }\n                    ;\n                    ;\n                        e = e.offsetParent;\n                    } while (((e && ((e != a)))));\n                    if (((Fa || ((Ha && ((\"absolute\" == d))))))) {\n                        f.y -= c.body.offsetTop;\n                    }\n                ;\n                ;\n                    for (e = a; (((((e = kc(e)) && ((e != c.body)))) && ((e != g)))); ) {\n                        if (f.x -= e.scrollLeft, ((!Fa || ((\"TR\" != e.tagName))))) {\n                            f.y -= e.scrollTop;\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                }\n            ;\n            }\n        ;\n        ;\n            return f;\n        }, nc = function(a) {\n            if (((\"none\" != ic(a, \"display\")))) {\n                return mc(a);\n            }\n        ;\n        ;\n            var b = a.style, c = b.display, d = b.visibility, e = b.position;\n            b.visibility = \"hidden\";\n            b.position = \"absolute\";\n            b.display = \"inline\";\n            a = mc(a);\n            b.display = c;\n            b.position = e;\n            b.visibility = d;\n            return a;\n        }, mc = function(a) {\n            var b = a.offsetWidth, c = a.offsetHeight, d = ((((Ha && !b)) && !c));\n            return ((((((((b === k)) || d)) && a.getBoundingClientRect)) ? (a = jc(a), new ua(((a.right - a.left)), ((a.bottom - a.JSBNG__top)))) : new ua(b, c)));\n        }, oc = function(a, b) {\n            var c = a.style;\n            ((((\"opacity\" in c)) ? c.opacity = b : ((((\"MozOpacity\" in c)) ? c.MozOpacity = b : ((((\"filter\" in c)) && (c.filter = ((((\"\" === b)) ? \"\" : ((((\"alpha(opacity=\" + ((100 * b)))) + \")\")))))))))));\n        }, pc = /matrix\\([0-9\\.\\-]+, [0-9\\.\\-]+, [0-9\\.\\-]+, [0-9\\.\\-]+, ([0-9\\.\\-]+)p?x?, ([0-9\\.\\-]+)p?x?\\)/;\n        var qc = window.gbar.i;\n        var rc = function(a, b) {\n            this.k = a;\n            this.a = b;\n            ((((!this.k || !this.a)) ? D(Error(\"Missing DOM\"), \"sbr\", \"init\") : (this.f = ib(\"gbsbt\", this.k), this.b = ib(\"gbsbb\", this.k), ((((!this.f || !this.b)) ? D(Error(((\"Missing Drop Shadows for \" + b.id))), \"sbr\", \"init\") : (this.F(), L(b, \"JSBNG__scroll\", x(this.F, this), p)))))));\n        };\n        rc.prototype.F = function() {\n            try {\n                var a = this.a.scrollTop, b = ((this.a.scrollHeight - this.a.clientHeight));\n                ((((0 == b)) ? (oc(this.f, 0), oc(this.b, 0)) : (oc(this.f, ((a / b))), oc(this.b, ((((b - a)) / b))))));\n            } catch (c) {\n                D(c, \"sbr\", \"sh\");\n            };\n        ;\n        };\n        var P = function(a) {\n            var b = x(this.va, this);\n            s(\"gbar.pcm\", b, k);\n            b = x(this.ua, this);\n            s(\"gbar.paa\", b, k);\n            b = x(this.wa, this);\n            s(\"gbar.pca\", b, k);\n            b = x(this.da, this);\n            s(\"gbar.prm\", b, k);\n            b = x(this.$, this);\n            s(\"gbar.pge\", b, k);\n            b = x(this.ba, this);\n            s(\"gbar.ppe\", b, k);\n            b = x(this.pa, this);\n            s(\"gbar.pae\", b, k);\n            b = x(this.ta, this);\n            s(\"gbar.spn\", b, k);\n            b = x(this.ya, this);\n            s(\"gbar.spp\", b, k);\n            b = x(this.za, this);\n            s(\"gbar.sps\", b, k);\n            b = x(this.Aa, this);\n            s(\"gbar.spd\", b, k);\n            this.C = this.aa = this.Y = this.f = this.Z = p;\n            this.ka = ((a.mg || \"%1$s\"));\n            this.ja = ((a.md || \"%1$s\"));\n            this.k = a.ppa;\n            this.qa = a.cp;\n            this.na = a.mh;\n            this.ra = a.d;\n            this.b = a.e;\n            this.D = a.p;\n            this.oa = a.ppl;\n            this.L = a.pp;\n            this.la = a.ppm;\n            this.sa = a.s;\n            this.ma = a.sanw;\n            (((((b = J(\"gbi4i\")) && b.loadError)) && this.$()));\n            (((((b = J(\"gbmpi\")) && b.loadError)) && this.ba()));\n            ((this.Z || ((((b = J(\"gbd4\")) && L(b, \"click\", x($b, this, \"gbd4\"), l))), this.Z = l)));\n            try {\n                var c = J(\"gbmpas\"), d = J(\"gbmpasb\");\n                ((((this.sa && ((c && d)))) && (this.a = new rc(d, c), G.adh(\"gbd4\", x(this.xa, this)))));\n            } catch (e) {\n                D(e, \"sp\", \"ssb\");\n            };\n        ;\n            if (this.qa) {\n                try {\n                    var f = JSBNG__document.getElementById(\"gbd4\");\n                    ((f && (L(f, \"mouseover\", x(this.R, this, cb), p), L(f, \"mouseout\", x(this.R, this, ab), p), this.R(ab))));\n                } catch (g) {\n                    D(g, \"sp\", \"smh\");\n                };\n            }\n        ;\n        ;\n            if (((((!this.ra && (c = J(\"gbmpn\")))) && ((sc(c) == this.b))))) {\n                c = this.b.indexOf(\"@\"), ((((0 <= c)) && tc(this.b.substring(0, c))));\n            }\n        ;\n        ;\n            ((a.xp && (a = J(\"gbg4\"), c = J(\"gbg6\"), ((a && (L(a, \"mouseover\", x(this.M, this)), ((this.k && L(a, \"mouseover\", x(this.ca, this))))))), ((c && (L(c, \"mouseover\", x(this.M, this)), ((this.k && L(c, \"mouseover\", x(this.ca, this))))))))));\n            if (((this.k && (this.w = {\n            }, a = J(\"gbmpas\"))))) {\n                a = hb(\"gbmt\", a);\n                for (c = 0; d = a[c]; ++c) {\n                    ((d && (f = ib(\"gbps3\", d), d = ib(\"gbmpia\", d), ((((f && d)) && (b = k, ((((Ya && ((\"innerText\" in f)))) ? b = f.innerText.replace(/(\\r\\n|\\r|\\n)/g, \"\\u000a\") : (b = [], rb(f, b, l), b = b.join(\"\")))), b = b.replace(/ \\xAD /g, \" \").replace(/\\xAD/g, \"\"), b = b.replace(/\\u200B/g, \"\"), ((Ya || (b = b.replace(/ +/g, \" \")))), ((((\" \" != b)) && (b = b.replace(/^\\s*/, \"\")))), f = b, d = d.getAttribute(\"data-asrc\"), this.w[f] = d))))));\n                ;\n                };\n            ;\n            }\n        ;\n        ;\n            this.X = [];\n            a = Nb();\n            ((((((a != n)) && ((7 >= a)))) && (this.da(), this.f = p)));\n        };\n        q = P.prototype;\n        q.R = function(a) {\n            var b = JSBNG__document.getElementById(\"gbmpicb\"), c = JSBNG__document.getElementById(\"gbmpicp\");\n            ((b && a(b, \"gbxo\")));\n            ((c && a(c, \"gbxo\")));\n        };\n        q.va = function() {\n            try {\n                var a = J(\"gbmpas\");\n                ((a && gc(a)));\n                ((this.a && this.a.F()));\n                this.f = p;\n                uc(this, p);\n            } catch (b) {\n                D(b, \"sp\", \"cam\");\n            };\n        ;\n        };\n        q.da = function() {\n            var a = J(\"gbmpdv\"), b = J(\"gbmps\");\n            if (((((a && b)) && !this.f))) {\n                var c = J(\"gbmpal\"), d = J(\"gbpm\");\n                if (c) {\n                    a.style.width = \"\";\n                    b.style.width = \"\";\n                    c.style.width = \"\";\n                    ((d && (d.style.width = \"1px\")));\n                    var e = Wb(a).width, f = Wb(b).width, e = ((((e > f)) ? e : f));\n                    if (f = J(\"gbg4\")) {\n                        f = Wb(f).width, ((((f > e)) && (e = f)));\n                    }\n                ;\n                ;\n                    if (((Mb() && (f = Nb(), ((((6 == f)) || ((((7 == f)) && ((\"BackCompat\" == JSBNG__document.compatMode)))))))))) {\n                        e += 2;\n                    }\n                ;\n                ;\n                    e += \"px\";\n                    a.style.width = e;\n                    b.style.width = e;\n                    c.style.width = e;\n                    ((d && (d.style.width = e)));\n                    ((this.a && this.a.F()));\n                    this.f = l;\n                }\n            ;\n            ;\n            }\n        ;\n        ;\n        };\n        q.wa = function() {\n            for (var a = 0, b; b = this.X[a]; ++a) {\n                ((((((b && b)) && b.parentNode)) && b.parentNode.removeChild(b)));\n            ;\n            };\n        ;\n            ((this.a && this.a.F()));\n            this.f = p;\n            uc(this, p);\n        };\n        q.ua = function(a, b, c, d, e, f, g, h, m, t) {\n            try {\n                var v = J(\"gbmpas\");\n                if (a) {\n                    for (var w = hb(\"gbp0\", v), z = 0, B; B = w[z]; ++z) {\n                        ((B && cb(B, \"gbp0\")));\n                    ;\n                    };\n                }\n            ;\n            ;\n                if (v) {\n                    w = \"gbmtc\";\n                    ((a && (w += \" gbp0\")));\n                    ((f || (w += \" gbpd\")));\n                    var E = hc(\"div\", w), F = hc(((f ? \"a\" : \"span\")), \"gbmt\");\n                    if (f) {\n                        if (h) {\n                            {\n                                var fin7keys = ((window.top.JSBNG_Replay.forInKeys)((h))), fin7i = (0);\n                                var H;\n                                for (; (fin7i < fin7keys.length); (fin7i++)) {\n                                    ((H) = (fin7keys[fin7i]));\n                                    {\n                                        F.setAttribute(H, h[H]);\n                                    ;\n                                    };\n                                };\n                            };\n                        }\n                    ;\n                    ;\n                        F.href = g;\n                        ec(F, ha(fc, \"gbmt\"));\n                        ((this.ma && (F.target = \"_blank\", F.rel = \"noreferrer\")));\n                    }\n                ;\n                ;\n                    if (this.k) {\n                        var Q = hc(\"span\", \"gbmpiaw\"), K = hc(\"img\", \"gbmpia\");\n                        K.height = \"48\";\n                        K.width = \"48\";\n                        ((d ? K.alt = d : K.alt = e));\n                        a = ((t ? \"//ssl.gstatic.com/gb/images/pluspages_48.png\" : \"//ssl.gstatic.com/gb/images/silhouette_48.png\"));\n                        ((m ? (a = m, this.w[e] = m) : ((this.w[e] && (a = this.w[e])))));\n                        K.setAttribute(\"src\", a);\n                        K.setAttribute(\"data-asrc\", a);\n                        Q.appendChild(K);\n                        F.appendChild(Q);\n                    }\n                ;\n                ;\n                    var O = hc(\"span\", \"gbmpnw\"), aa = hc(\"span\", \"gbps\");\n                    O.appendChild(aa);\n                    aa.appendChild(JSBNG__document.createTextNode(((d || e))));\n                    var V = hc(\"span\", \"gbps2\");\n                    ((b ? vc(this.ja, e, V) : ((c ? vc(this.ka, e, V) : ((t ? V.appendChild(JSBNG__document.createTextNode(this.la)) : vc(n, e, V)))))));\n                    O.appendChild(V);\n                    F.appendChild(O);\n                    E.appendChild(F);\n                    v.appendChild(E);\n                    this.X.push(E);\n                    ((this.a && this.a.F()));\n                    ((((t && !this.C)) && uc(this, t)));\n                }\n            ;\n            ;\n            } catch (Wa) {\n                D(Wa, \"sp\", \"aa\");\n            };\n        ;\n        };\n        var vc = function(a, b, c) {\n            var d = hc(\"span\", \"gbps3\");\n            d.appendChild(JSBNG__document.createTextNode(b));\n            ((a ? (a = a.split(\"%1$s\"), b = JSBNG__document.createTextNode(a[1]), c.appendChild(JSBNG__document.createTextNode(a[0])), c.appendChild(d), c.appendChild(b)) : c.appendChild(d)));\n        }, uc = function(a, b) {\n            var c = J(\"gbmppc\");\n            ((c && ((b ? (N(c, \"gbxx\"), a.C = l) : (bc(c, \"gbxx\"), a.C = p)))));\n        }, tc = function(a) {\n            var b = J(\"gbd4\"), c = J(\"gbmpn\");\n            ((((b && c)) && (gc(c), c.appendChild(JSBNG__document.createTextNode(a)), Gb(b))));\n        }, wc = function() {\n            var a = J(\"gbmpas\");\n            return ((a ? hb(\"gbmpiaw\", a) : n));\n        };\n        P.prototype.$ = function() {\n            try {\n                xc(\"gbi4i\", \"gbi4id\");\n            } catch (a) {\n                D(a, \"sp\", \"gbpe\");\n            };\n        ;\n        };\n        P.prototype.ba = function() {\n            try {\n                xc(\"gbmpi\", \"gbmpid\");\n            } catch (a) {\n                D(a, \"sp\", \"ppe\");\n            };\n        ;\n        };\n        P.prototype.pa = function() {\n            try {\n                var a = wc();\n                if (a) {\n                    for (var b = 0, c; c = a[b]; ++b) {\n                        ((c && (c.style.display = \"none\")));\n                    ;\n                    };\n                }\n            ;\n            ;\n            } catch (d) {\n                D(d, \"sp\", \"pae\");\n            };\n        ;\n        };\n        var xc = function(a, b) {\n            var c = J(a);\n            ((c && (c.style.backgroundImage = \"url(//ssl.gstatic.com/gb/images/s_513818bc.png)\", c.style.display = \"none\")));\n            if (c = J(b)) {\n                c.style.display = \"\", c.style.backgroundImage = \"url(//ssl.gstatic.com/gb/images/s_513818bc.png)\";\n            }\n        ;\n        ;\n        };\n        P.prototype.M = function() {\n            try {\n                if (!this.Y) {\n                    var a = J(\"gbmpi\");\n                    ((((a && this.D)) && (a.src = this.D, this.Y = l)));\n                }\n            ;\n            ;\n            } catch (b) {\n                D(b, \"sp\", \"swp\");\n            };\n        ;\n        };\n        P.prototype.ca = function() {\n            try {\n                if (!this.aa) {\n                    this.aa = l;\n                    var a = wc();\n                    if (a) {\n                        for (var b = 0, c; c = a[b]; ++b) {\n                            if (c) {\n                                var d = hb(\"gbmpia\", c)[0];\n                                d.setAttribute(\"src\", d.getAttribute(\"data-asrc\"));\n                                N(c, \"gbxv\");\n                            }\n                        ;\n                        ;\n                        };\n                    }\n                ;\n                ;\n                }\n            ;\n            ;\n            } catch (e) {\n                D(e, \"sp\", \"sap\");\n            };\n        ;\n        };\n        P.prototype.ta = function(a) {\n            try {\n                var b = J(\"gbi4t\");\n                ((((sc(J(\"gbmpn\")) == this.b)) || tc(a)));\n                ((((sc(b) != this.b)) && (gc(b), b.appendChild(JSBNG__document.createTextNode(a)))));\n            } catch (c) {\n                D(c, \"sp\", \"spn\");\n            };\n        ;\n        };\n        var sc = function(a) {\n            return ((((a.firstChild && a.firstChild.nodeValue)) ? a.firstChild.nodeValue : \"\"));\n        };\n        q = P.prototype;\n        q.ya = function(a) {\n            try {\n                this.L = a;\n                var b = J(\"gbmpi\");\n                if (b) {\n                    var c = a(b.height);\n                    ((c && (this.D = b.src = c)));\n                }\n            ;\n            ;\n                var d = J(\"gbi4i\");\n                if (d) {\n                    var e = a(d.height);\n                    ((e && (d.src = e)));\n                }\n            ;\n            ;\n            } catch (f) {\n                D(f, \"sp\", \"spp\");\n            };\n        ;\n        };\n        q.za = function(a) {\n            try {\n                if (this.oa) {\n                    var b = J(\"gbi4i\"), c = J(\"gbi4ip\");\n                    if (((((b && c)) && (b.width = b.height = c.width = c.height = a, ((((\"none\" != b.style.display)) && (c.src = b.src, c.style.display = \"\", b.JSBNG__onload = P.prototype.Ta, this.L))))))) {\n                        var d = this.L(a);\n                        ((d && (b.src = d)));\n                    }\n                ;\n                ;\n                }\n            ;\n            ;\n            } catch (e) {\n                D(e, \"sp\", \"sps\");\n            };\n        ;\n        };\n        q.Ta = function() {\n            var a = J(\"gbi4i\");\n            a.JSBNG__onload = n;\n            a.style.display = \"\";\n            J(\"gbi4ip\").style.display = \"none\";\n        };\n        q.Aa = function() {\n            try {\n                var a = J(\"gbg4\");\n                this.M();\n                Fb(n, a, l, l);\n            } catch (b) {\n                D(b, \"sp\", \"sd\");\n            };\n        ;\n        };\n        q.xa = function() {\n            try {\n                var a = J(\"gbmpas\");\n                if (a) {\n                    var b = qc.j(\"Height\"), c = J(\"gbd4\"), d;\n                    if (((1 == c.nodeType))) {\n                        var e;\n                        if (c.getBoundingClientRect) {\n                            var f = jc(c);\n                            e = new A(f.left, f.JSBNG__top);\n                        }\n                         else {\n                            var g = sb(fb(c)), h = lc(c);\n                            e = new A(((h.x - g.x)), ((h.y - g.y)));\n                        }\n                    ;\n                    ;\n                        var m;\n                        if (((Ga && !Ra(12)))) {\n                            var t = e, v;\n                            var w;\n                            ((C ? w = \"-ms-transform\" : ((Ha ? w = \"-webkit-transform\" : ((Fa ? w = \"-o-transform\" : ((Ga && (w = \"-moz-transform\")))))))));\n                            var z;\n                            ((w && (z = ic(c, w))));\n                            ((z || (z = ic(c, \"transform\"))));\n                            if (z) {\n                                var B = z.match(pc);\n                                v = ((!B ? new A(0, 0) : new A(parseFloat(B[1]), parseFloat(B[2]))));\n                            }\n                             else v = new A(0, 0);\n                        ;\n                        ;\n                            m = new A(((t.x + v.x)), ((t.y + v.y)));\n                        }\n                         else m = e;\n                    ;\n                    ;\n                        d = m;\n                    }\n                     else t = ((\"function\" == ca(c.a))), m = c, ((c.targetTouches ? m = c.targetTouches[0] : ((((t && c.a().targetTouches)) && (m = c.a().targetTouches[0]))))), d = new A(m.clientX, m.clientY);\n                ;\n                ;\n                    var E = d.y, F = nc(c).height, b = ((((E + F)) - ((b - 20)))), H = nc(a).height, Q = Math.min(((H - b)), this.na);\n                    a.style.maxHeight = ((Math.max(74, Q) + \"px\"));\n                    Gb(c);\n                    this.a.F();\n                }\n            ;\n            ;\n            } catch (K) {\n                D(K, \"sp\", \"rac\");\n            };\n        ;\n        };\n        I(\"prf\", {\n            init: function(a) {\n                new P(a);\n            }\n        });\n        var yc = function() {\n        \n        };\n        yc.a = function() {\n            ((yc.b || (yc.b = new yc)));\n        };\n        var zc = n;\n        I(\"il\", {\n            init: function() {\n                yc.a();\n                var a;\n                if (!zc) {\n                    t:\n                    {\n                        a = [\"gbar\",\"logger\",];\n                        for (var b = r, c; c = a.shift(); ) {\n                            if (((b[c] != n))) b = b[c];\n                             else {\n                                a = n;\n                                break t;\n                            }\n                        ;\n                        ;\n                        };\n                    ;\n                        a = b;\n                    };\n                ;\n                    zc = ((a || {\n                    }));\n                }\n            ;\n            ;\n                a = zc;\n                ((((\"function\" == ca(a.il))) && a.il(8, k)));\n            }\n        });\n        var Dc = function(a) {\n            var b = a.match(Ac);\n            return ((b ? new Bc(((b[1] || \"\")), ((b[2] || \"\")), ((b[3] || \"\")), \"\", ((((b[4] || b[5])) || \"\"))) : (((b = a.match(Cc)) ? new Bc(\"\", ((b[1] || \"\")), \"\", ((b[2] || \"\")), ((b[3] || \"\"))) : n))));\n        }, Ac = RegExp(\"^    at(?: (?:(.*?)\\\\.)?((?:new )?(?:[a-zA-Z_$][\\\\w$]*|\\u003Canonymous\\u003E))(?: \\\\[as ([a-zA-Z_$][\\\\w$]*)\\\\])?)? (?:\\\\(unknown source\\\\)|\\\\(native\\\\)|\\\\((?:eval at )?((?:http|https|file)://[^\\\\s)]+|javascript:.*)\\\\)|((?:http|https|file)://[^\\\\s)]+|javascript:.*))$\"), Cc = /^([a-zA-Z_$][\\w$]*)?(\\(.*\\))?@(?::0|((?:http|https|file):\\/\\/[^\\s)]+|javascript:.*))$/, Fc = function() {\n            for (var a = [], b = arguments.callee.caller, c = 0; ((b && ((20 > c)))); ) {\n                var d;\n                d = (((d = Function.prototype.toString.call(b).match(Ec)) ? d[1] : \"\"));\n                var e = b, f = [\"(\",];\n                if (e.arguments) {\n                    for (var g = 0; ((g < e.arguments.length)); g++) {\n                        var h = e.arguments[g];\n                        ((((0 < g)) && f.push(\", \")));\n                        ((((\"string\" == typeof h)) ? f.push(\"\\\"\", h, \"\\\"\") : f.push(String(h))));\n                    };\n                }\n                 else {\n                    f.push(\"unknown\");\n                }\n            ;\n            ;\n                f.push(\")\");\n                a.push(new Bc(\"\", d, \"\", f.join(\"\"), \"\"));\n                try {\n                    if (((b == b.caller))) {\n                        break;\n                    }\n                ;\n                ;\n                    b = b.caller;\n                } catch (m) {\n                    break;\n                };\n            ;\n                c++;\n            };\n        ;\n            return a;\n        }, Ec = /^function ([a-zA-Z_$][\\w$]*)/, Bc = function(a, b, c, d, e) {\n            this.f = a;\n            this.JSBNG__name = b;\n            this.b = c;\n            this.k = d;\n            this.a = e;\n        }, Nc = function(a) {\n            var b = [((a.f ? ((a.f + \".\")) : \"\")),((a.JSBNG__name ? a.JSBNG__name : \"anonymous\")),a.k,((a.b ? ((((\" [as \" + a.b)) + \"]\")) : \"\")),];\n            ((a.a && (b.push(\" at \"), b.push(a.a))));\n            a = b.join(\"\");\n            for (b = window.JSBNG__location.href.replace(/#.*/, \"\"); ((0 <= a.indexOf(b))); ) {\n                a = a.replace(b, \"[page]\");\n            ;\n            };\n        ;\n            return a = a.replace(/http.*?extern_js.*?\\.js/g, \"[xjs]\");\n        };\n        var Oc = function(a, b) {\n            if (window.gbar.logger._itl(b)) {\n                return b;\n            }\n        ;\n        ;\n            var c = a.stack;\n            if (c) {\n                for (var c = c.replace(/\\s*$/, \"\").split(\"\\u000a\"), d = [], e = 0; ((e < c.length)); e++) {\n                    d.push(Dc(c[e]));\n                ;\n                };\n            ;\n                c = d;\n            }\n             else c = Fc();\n        ;\n        ;\n            for (var d = c, e = 0, f = ((d.length - 1)), g = 0; ((g <= f)); g++) {\n                if (((d[g] && ((0 <= d[g].JSBNG__name.indexOf(\"_mlToken\")))))) {\n                    e = ((g + 1));\n                    break;\n                }\n            ;\n            ;\n            };\n        ;\n            ((((0 == e)) && f--));\n            c = [];\n            for (g = e; ((g <= f)); g++) {\n                ((((d[g] && !((0 <= d[g].JSBNG__name.indexOf(\"_onErrorToken\"))))) && c.push(((\"\\u003E \" + Nc(d[g]))))));\n            ;\n            };\n        ;\n            d = [b,\"&jsst=\",c.join(\"\"),];\n            e = d.join(\"\");\n            return ((((!window.gbar.logger._itl(e) || ((((2 < c.length)) && (d[2] = ((((c[0] + \"...\")) + c[((c.length - 1))])), e = d.join(\"\"), !window.gbar.logger._itl(e)))))) ? e : b));\n        };\n        I(\"er\", {\n            init: function() {\n                window.gbar.logger._aem = Oc;\n            }\n        });\n        var Pc = function(a) {\n            this.a = a;\n        }, Qc = /\\s*;\\s*/;\n        Pc.prototype.isEnabled = function() {\n            return JSBNG__navigator.cookieEnabled;\n        };\n        var Sc = function() {\n            for (var a = ((Rc.a.cookie || \"\")).split(Qc), b = 0, c; c = a[b]; b++) {\n                if (((0 == c.lastIndexOf(\"OGP=\", 0)))) {\n                    return c.substr(4);\n                }\n            ;\n            ;\n                if (((\"OGP\" == c))) {\n                    break;\n                }\n            ;\n            ;\n            };\n        ;\n            return \"\";\n        }, Rc = new Pc(JSBNG__document);\n        Rc.b = 3950;\n        var Tc, Uc, Vc, Wc = function(a, b, c, d, e) {\n            try {\n                var f = Tc;\n                if (((((e != k)) && ((e != n))))) {\n                    if (((((0 <= e)) && ((1 >= e))))) f = e;\n                     else {\n                        D(Error(((((((((b + \"_\")) + c)) + \"_\")) + e))), \"up\", \"log\");\n                        return;\n                    }\n                ;\n                }\n            ;\n            ;\n                if (((Math.JSBNG__random() <= f))) {\n                    var g = [\"//www.google.com/gen_204?atyp=i\",((\"zx=\" + (new JSBNG__Date).getTime())),((\"ogsr=\" + ((f / 1)))),((\"ct=\" + b)),((\"cad=\" + c)),((\"id=\" + a)),((\"loc=\" + ((window.google ? window.google.sn : \"\")))),((\"prid=\" + encodeURIComponent(Vc))),((\"ogd=\" + encodeURIComponent(Uc))),\"ogprm=up\",];\n                    ((d && g.push(d)));\n                    G.logger.log(g.join(\"&\"));\n                }\n            ;\n            ;\n            } catch (h) {\n                D(Error(((((((((b + \"_\")) + c)) + \"_\")) + e))), \"up\", \"log\");\n            };\n        ;\n        };\n        s(\"gbar.up.sl\", Wc, k);\n        s(\"gbar.up.spl\", function(a, b, c, d) {\n            Wc(a, b, c, ((\"tpt=\" + d.join(\",\"))));\n        }, k);\n        I(\"up\", {\n            init: function(a) {\n                Tc = a.sp;\n                Uc = a.tld;\n                Vc = a.prid;\n                G.up.tp();\n            }\n        });\n        var Yc = function(a) {\n            this.a = {\n            };\n            qc.g = x(this.f, this);\n            qc.h = x(this.b, this);\n            var b = this.a;\n            a = a.p.split(\":\");\n            for (var c = 0, d; d = a[c]; ++c) {\n                if (d = d.split(\",\"), ((5 == d.length))) {\n                    var e = {\n                    };\n                    e.id = d[0];\n                    e.key = d[1];\n                    e.A = d[2];\n                    e.Xa = qc.c(d[3], 0);\n                    e.Ya = qc.c(d[4], 0);\n                    b[e.A] = e;\n                }\n            ;\n            ;\n            };\n        ;\n            Xc(this);\n        }, Zc = {\n            7: [\"gbprc\",\"gbprca\",]\n        };\n        Yc.prototype.f = function(a) {\n            if (a = this.a[a]) {\n                $c(a), Wc(a.id, a.A, \"d\", k, 1);\n            }\n        ;\n        ;\n        };\n        Yc.prototype.b = function(a) {\n            if (a = this.a[a]) {\n                $c(a), Wc(a.id, a.A, \"h\", k, 1);\n            }\n        ;\n        ;\n        };\n        var $c = function(a) {\n            var b = Zc[a.A];\n            if (b) {\n                for (var c = 0; ((c < b.length)); c++) {\n                    var d = JSBNG__document.getElementById(b[c]);\n                    ((d && N(d, \"gbto\")));\n                };\n            }\n        ;\n        ;\n            if (((((\"7\" == a.A)) && (b = ad())))) {\n                b = b.style, b.width = \"\", b.height = \"\", b.visibility = \"\", b.JSBNG__top = \"\", b.left = \"\";\n            }\n        ;\n        ;\n            (((b = Sc()) && (b += \":\")));\n            for (var b = ((b + ((\"-\" + a.key)))), e; ((((50 < b.length)) && ((-1 != (e = b.indexOf(\":\")))))); ) {\n                b = b.substring(((e + 1)));\n            ;\n            };\n        ;\n            a = window.JSBNG__location.hostname;\n            e = a.indexOf(\".google.\");\n            c = ((((0 < e)) ? a.substring(e) : k));\n            if (((((50 >= b.length)) && c))) {\n                a = b;\n                e = Rc;\n                b = 2592000;\n                if (/[;=\\s]/.test(\"OGP\")) {\n                    throw Error(\"Invalid cookie name \\\"OGP\\\"\");\n                }\n            ;\n            ;\n                if (/[;\\r\\n]/.test(a)) {\n                    throw Error(((((\"Invalid cookie value \\\"\" + a)) + \"\\\"\")));\n                }\n            ;\n            ;\n                ((((b !== k)) || (b = -1)));\n                c = ((c ? ((\";domain=\" + c)) : \"\"));\n                b = ((((0 > b)) ? \"\" : ((((0 == b)) ? ((\";expires=\" + (new JSBNG__Date(1970, 1, 1)).toUTCString())) : ((\";expires=\" + (new JSBNG__Date(((ia() + ((1000 * b)))))).toUTCString()))))));\n                e.a.cookie = ((((((((((\"OGP=\" + a)) + c)) + \";path=/\")) + b)) + \"\"));\n            }\n        ;\n        ;\n        }, Xc = function(a) {\n            {\n                var fin8keys = ((window.top.JSBNG_Replay.forInKeys)((a.a))), fin8i = (0);\n                var b;\n                for (; (fin8i < fin8keys.length); (fin8i++)) {\n                    ((b) = (fin8keys[fin8i]));\n                    {\n                        if (a.a.hasOwnProperty(b)) {\n                            var c = a.a[b];\n                            G.up.r(c.A, function(a) {\n                                if (((a && ((-1 == Sc().indexOf(((\"-\" + c.key)))))))) {\n                                    a = c;\n                                    var b = Zc[a.A];\n                                    if (b) {\n                                        for (var f = 0; ((f < b.length)); f++) {\n                                            var g = JSBNG__document.getElementById(b[f]);\n                                            ((g && bc(g, \"gbto\")));\n                                            Wc(a.id, a.A, \"i\");\n                                        };\n                                    }\n                                ;\n                                ;\n                                    if (((((\"7\" == a.A)) && (a = JSBNG__document.getElementById(\"gbprcc\"))))) {\n                                        if (b = ad()) {\n                                            a.appendChild(b), b = b.style, b.width = ((a.offsetWidth + \"px\")), b.height = ((a.offsetHeight + \"px\")), b.visibility = \"visible\", b.JSBNG__top = \"-1px\", b.left = \"-1px\";\n                                        }\n                                    ;\n                                    }\n                                ;\n                                ;\n                                }\n                            ;\n                            ;\n                            });\n                        }\n                    ;\n                    ;\n                    };\n                };\n            };\n        ;\n        }, ad = function() {\n            var a = JSBNG__document.getElementById(\"gbprcs\");\n            if (a) {\n                return a;\n            }\n        ;\n        ;\n            a = JSBNG__document.createElement(\"div\");\n            a.frameBorder = \"0\";\n            a.tabIndex = \"-1\";\n            a.id = \"gbprcs\";\n            a.src = \"javascript:''\";\n            J(\"gbw\").appendChild(a);\n            return a;\n        };\n        I(\"pm\", {\n            init: function(a) {\n                new Yc(a);\n            }\n        });\n        var bd = function(a) {\n            this.J = a;\n            this.v = 0;\n            this.O = p;\n            this.Fa = l;\n            this.N = this.K = n;\n        }, R = function(a) {\n            return ((((5 == a.v)) || ((4 == a.v))));\n        };\n        bd.prototype.isEnabled = function() {\n            return this.Fa;\n        };\n        var cd = function(a, b) {\n            var c = ((b || {\n            })), d = x(a.Ga, a);\n            c.fc = d;\n            d = x(a.Ma, a);\n            c.rc = d;\n            d = x(a.Na, a);\n            c.sc = d;\n            d = x(a.W, a);\n            c.hc = d;\n            d = x(a.U, a);\n            c.cc = d;\n            d = x(a.La, a);\n            c.os = d;\n            d = x(a.V, a);\n            c.or = d;\n            d = x(a.Ja, a);\n            c.oh = d;\n            d = x(a.Ha, a);\n            c.oc = d;\n            d = x(a.Ia, a);\n            c.oe = d;\n            d = x(a.Ka, a);\n            c.oi = d;\n            return c;\n        };\n        var dd = function(a, b, c) {\n            this.a = ((a || {\n            }));\n            this.b = ((b || 0));\n            this.k = ((c || 0));\n            this.f = cd(this);\n        };\n        q = dd.prototype;\n        q.Ma = function(a, b, c) {\n            try {\n                a = ((a + ((((b != n)) ? ((\"_\" + b)) : \"\")))), c.sm(this.f, a), this.a[a] = new bd(c);\n            } catch (d) {\n                return p;\n            };\n        ;\n            return l;\n        };\n        q.Ga = function(a, b) {\n            var c = this.a[((a + ((((b != n)) ? ((\"_\" + b)) : \"\"))))];\n            return ((c ? c.J : n));\n        };\n        q.Na = function(a) {\n            var b = S(this, a);\n            if (((((((b && ((((2 == b.v)) || ((3 == b.v)))))) && b.isEnabled())) && !b.O))) {\n                try {\n                    a.sh();\n                } catch (c) {\n                    ed(c, \"am\", \"shc\");\n                };\n            ;\n                b.O = l;\n            }\n        ;\n        ;\n        };\n        q.W = function(a) {\n            var b = S(this, a);\n            if (((((b && ((((((2 == b.v)) || ((3 == b.v)))) || R(b))))) && b.O))) {\n                try {\n                    a.hi();\n                } catch (c) {\n                    ed(c, \"am\", \"hic\");\n                };\n            ;\n                b.O = p;\n            }\n        ;\n        ;\n        };\n        q.U = function(a) {\n            var b = S(this, a);\n            if (((b && ((5 != b.v))))) {\n                try {\n                    this.W(a), a.cl();\n                } catch (c) {\n                    ed(c, \"am\", \"clc\");\n                };\n            ;\n                this.Q(b);\n            }\n        ;\n        ;\n        };\n        q.La = function(a) {\n            if ((((a = S(this, a)) && ((0 == a.v))))) {\n                fd(this, a), a.v = 1;\n            }\n        ;\n        ;\n        };\n        var fd = function(a, b) {\n            if (a.b) {\n                var c = JSBNG__setTimeout(x(function() {\n                    ((R(b) || (gd(b, 6), hd(this, b))));\n                }, a), a.b);\n                b.N = c;\n            }\n             else hd(a, b);\n        ;\n        ;\n        }, hd = function(a, b) {\n            var c = ((a.k - a.b));\n            ((((0 < c)) && (c = JSBNG__setTimeout(x(function() {\n                ((R(b) || (gd(b, 7), b.v = 4, this.U(b.J))));\n            }, a), c), b.N = c)));\n        }, id = function(a) {\n            ((((a.N != n)) && (JSBNG__clearTimeout(a.N), a.N = n)));\n        };\n        q = dd.prototype;\n        q.V = function(a) {\n            if ((((a = S(this, a)) && !R(a)))) {\n                gd(a, 5), ((((1 == a.v)) && (id(a), a.v = 3)));\n            }\n        ;\n        ;\n        };\n        q.Ja = function(a) {\n            if ((((a = S(this, a)) && !R(a)))) {\n                a.O = p;\n            }\n        ;\n        ;\n        };\n        q.Ha = function(a) {\n            var b = S(this, a);\n            if (((b && !R(b)))) {\n                try {\n                    this.W(a);\n                } catch (c) {\n                    ed(c, \"am\", \"oc\");\n                };\n            ;\n                this.Q(b);\n            }\n        ;\n        ;\n        };\n        q.Ia = function(a, b, c, d, e, f) {\n            if ((((a = S(this, a)) && !R(a)))) {\n                ed(c, d, e, a, b, f), a.v = 4, this.U(a.J);\n            }\n        ;\n        ;\n        };\n        q.Ka = function(a, b, c, d) {\n            if ((((a = S(this, a)) && !R(a)))) {\n                gd(a, b, c, d), ((((((2 <= b)) && ((((4 >= b)) && !R(a))))) && (id(a), a.v = 2)));\n            }\n        ;\n        ;\n        };\n        q.Q = function(a) {\n            id(a);\n            a.v = 5;\n            var b = this.a, c;\n            {\n                var fin9keys = ((window.top.JSBNG_Replay.forInKeys)((b))), fin9i = (0);\n                (0);\n                for (; (fin9i < fin9keys.length); (fin9i++)) {\n                    ((c) = (fin9keys[fin9i]));\n                    {\n                        ((((b[c] == a)) && delete b[c]));\n                    ;\n                    };\n                };\n            };\n        ;\n        };\n        var S = function(a, b) {\n            return a.a[b.n];\n        };\n        var jd, kd, ld, md, nd = function(a, b, c) {\n            dd.call(this, a, b, c);\n        };\n        (function() {\n            function a() {\n            \n            };\n        ;\n            a.prototype = dd.prototype;\n            nd.a = dd.prototype;\n            nd.prototype = new a;\n        })();\n        var ed = function(a, b, c, d, e, f) {\n            f = ((f || {\n            }));\n            ((d && (f._wg = d.J.n)));\n            ((((((e !== k)) && ((-1 != e)))) && (f._c = e)));\n            D(a, b, c, f);\n        }, gd = function(a, b, c, d) {\n            d = ((d || {\n            }));\n            d._wg = a.J.n;\n            d._c = b;\n            ((c && (d._m = c)));\n            G.logger.il(25, d);\n        };\n        nd.prototype.V = function(a, b) {\n            nd.a.V.call(this, a, b);\n            ((G.wg.owrd && G.wg.owrd(a)));\n        };\n        nd.prototype.Q = function(a) {\n            nd.a.Q.call(this, a);\n            var b = this.a, c;\n            {\n                var fin10keys = ((window.top.JSBNG_Replay.forInKeys)((b))), fin10i = (0);\n                (0);\n                for (; (fin10i < fin10keys.length); (fin10i++)) {\n                    ((c) = (fin10keys[fin10i]));\n                    {\n                        ((((((b[c] == a)) && G.wg.owcl)) && G.wg.owcl(a)));\n                    ;\n                    };\n                };\n            };\n        ;\n        };\n        I(\"wg\", {\n            init: function(a) {\n                jd = new nd(G.wg.rg, a.tiw, a.tie);\n                cd(jd, G.wg);\n            }\n        });\n        var od = \"xec clkc xc rqd rt te\".split(\" \"), pd = function() {\n            this.B = this.a = n;\n        }, qd = function(a, b, c) {\n            var d = a.B[b];\n            a = a.a[b];\n            ((((((d != n)) && ((a != n)))) && c.push([b,\"~\",((d - a)),].join(\"\"))));\n        }, rd = function(a, b) {\n            var c;\n            if (b) {\n                c = new pd;\n                c.a = {\n                };\n                var d = c.a;\n                d.t = (new JSBNG__Date).getTime();\n                for (var e = 0, f; f = od[e]; ++e) {\n                    d[f] = 0;\n                ;\n                };\n            ;\n            }\n             else c = n;\n        ;\n        ;\n            a.K = c;\n        }, sd = function(a) {\n            return ((((3 == a.v)) && !!a.K));\n        }, td = 0, T = n, ud = 0, vd = 0, wd = p, xd = function(a, b) {\n            ((wd || ((((((T == n)) && ((1000 <= b)))) ? (ud = (new JSBNG__Date).getTime(), T = JSBNG__setTimeout(function() {\n                T = n;\n                ((((((0 < vd)) && (((((new JSBNG__Date).getTime() - ud)) < ((b * vd)))))) && (wd = l)));\n                a();\n            }, b)) : D(Error(\"\"), \"wm\", \"shmt\")))));\n        }, yd = p, Ad = function() {\n            try {\n                var a = [], b = G.wg.rg, c;\n                {\n                    var fin11keys = ((window.top.JSBNG_Replay.forInKeys)((b))), fin11i = (0);\n                    (0);\n                    for (; (fin11i < fin11keys.length); (fin11i++)) {\n                        ((c) = (fin11keys[fin11i]));\n                        {\n                            var d = b[c];\n                            if (sd(d)) {\n                                var e = d.K, f = \"\";\n                                if (((e.B != n))) {\n                                    var g = [];\n                                    qd(e, \"t\", g);\n                                    for (var h = 0, m; m = od[h]; ++h) {\n                                        qd(e, m, g);\n                                    ;\n                                    };\n                                ;\n                                    f = g.join(\",\");\n                                }\n                                 else f = \"_h~0\";\n                            ;\n                            ;\n                                a.push([c,\"~{\",f,\"}\",].join(\"\"));\n                                f = e;\n                                ((f.B && (f.a = f.B, f.B = n)));\n                            }\n                        ;\n                        ;\n                        };\n                    };\n                };\n            ;\n                if (((0 < a.length))) {\n                    var t = {\n                        ogw: a.join(\",\"),\n                        _cn: td++\n                    };\n                    ((wd && (t._tmfault = \"1\")));\n                    G.logger.il(26, t);\n                }\n            ;\n            ;\n                yd = p;\n                zd();\n            } catch (v) {\n                D(v, \"wm\", \"shr\");\n            };\n        ;\n        }, Bd = function(a, b) {\n            try {\n                a.B = {\n                };\n                var c = a.B;\n                c.t = (new JSBNG__Date).getTime();\n                for (var d = 0, e; e = od[d]; ++d) {\n                    c[e] = b[e];\n                ;\n                };\n            ;\n                var c = l, f = G.wg.rg, g;\n                {\n                    var fin12keys = ((window.top.JSBNG_Replay.forInKeys)((f))), fin12i = (0);\n                    (0);\n                    for (; (fin12i < fin12keys.length); (fin12i++)) {\n                        ((g) = (fin12keys[fin12i]));\n                        {\n                            var h = f[g];\n                            if (((sd(h) && !h.K.B))) {\n                                c = p;\n                                break;\n                            }\n                        ;\n                        ;\n                        };\n                    };\n                };\n            ;\n                ((c && (((((T != n)) && (JSBNG__clearTimeout(T), T = n))), Ad())));\n            } catch (m) {\n                D(m, \"wm\", \"ovr\");\n            };\n        ;\n        }, Cd = function() {\n            try {\n                var a = G.wg.rg, b;\n                {\n                    var fin13keys = ((window.top.JSBNG_Replay.forInKeys)((a))), fin13i = (0);\n                    (0);\n                    for (; (fin13i < fin13keys.length); (fin13i++)) {\n                        ((b) = (fin13keys[fin13i]));\n                        {\n                            try {\n                                var c = a[b];\n                                ((sd(c) && c.J.vr(\"base\", ha(Bd, c.K))));\n                            } catch (d) {\n                                D(d, \"wm\", \"dhcw\");\n                            };\n                        ;\n                        };\n                    };\n                };\n            ;\n                yd = l;\n                xd(Ad, kd);\n            } catch (e) {\n                D(e, \"wm\", \"dhc\");\n            };\n        ;\n        }, zd = function() {\n            if (((((((0 < ld)) || ((0 < md)))) && !yd))) {\n                ((((T != n)) && (JSBNG__clearTimeout(T), T = n)));\n                var a = 0, b = p, c = G.wg.rg, d;\n                {\n                    var fin14keys = ((window.top.JSBNG_Replay.forInKeys)((c))), fin14i = (0);\n                    (0);\n                    for (; (fin14i < fin14keys.length); (fin14i++)) {\n                        ((d) = (fin14keys[fin14i]));\n                        {\n                            var e = c[d];\n                            ((sd(e) ? ++a : ((((3 == e.v)) && (rd(e, l), b = l, ++a)))));\n                        };\n                    };\n                };\n            ;\n                ((((0 < a)) && (a = ((((b && ((0 < ld)))) ? ld : md)), ((((0 < a)) && xd(Cd, a))))));\n            }\n        ;\n        ;\n        }, Dd = function() {\n            zd();\n        }, Ed = function(a) {\n            ((((sd(a) && ((!yd || !a.K.B)))) && rd(a, p)));\n        };\n        I(\"wm\", {\n            init: function(a) {\n                ld = ((a.thi || 0));\n                md = ((a.thp || 0));\n                kd = ((a.tho || 0));\n                vd = ((a.tet || 0));\n                G.wg.owrd = Dd;\n                G.wg.owcl = Ed;\n                zd();\n            }\n        });\n        var Fd = function() {\n            this.b = p;\n            ((this.b || (L(window, \"resize\", x(this.k, this), l), this.b = l)));\n        };\n        Fd.prototype.a = 0;\n        Fd.prototype.f = function() {\n            G.elg();\n            this.a = 0;\n        };\n        Fd.prototype.k = function() {\n            G.elg();\n            ((this.a && window.JSBNG__clearTimeout(this.a)));\n            this.a = window.JSBNG__setTimeout(x(this.f, this), 1500);\n        };\n        I(\"el\", {\n            init: function() {\n                new Fd;\n            }\n        });\n        var Gd = function() {\n            this.k = p;\n            if (!G.sg.c) {\n                var a = JSBNG__document.getElementById(\"gbqfq\"), b = JSBNG__document.getElementById(\"gbqfqwb\"), c = JSBNG__document.getElementById(\"gbqfqw\"), d = JSBNG__document.getElementById(\"gbqfb\");\n                if (!this.k) {\n                    ((((a && b)) && (L(a, \"JSBNG__focus\", x(this.a, this, c)), L(a, \"JSBNG__blur\", x(this.f, this, c)), L(b, \"click\", x(this.b, this, a)))));\n                    ((d && (L(d, \"click\", ha(bc, d, \"gbqfb-no-focus\")), L(d, \"JSBNG__blur\", ha(N, d, \"gbqfb-no-focus\")))));\n                    var a = JSBNG__document.getElementById(\"gbqfqb\"), b = JSBNG__document.getElementById(\"gbqfwd\"), c = JSBNG__document.getElementById(\"gbqfwc\"), d = JSBNG__document.getElementById(\"gbqfqc\"), e = JSBNG__document.getElementById(\"gbqfwf\"), f = JSBNG__document.getElementById(\"gbqfwe\");\n                    ((((a && ((((b && d)) && e)))) && (L(a, \"JSBNG__focus\", x(this.a, this, c)), L(a, \"JSBNG__blur\", x(this.f, this, c)), L(b, \"click\", x(this.b, this, a)), L(d, \"JSBNG__focus\", x(this.a, this, f)), L(d, \"JSBNG__blur\", x(this.f, this, f)), L(e, \"click\", x(this.b, this, d)))));\n                    this.k = l;\n                }\n            ;\n            ;\n                a = JSBNG__document.getElementById(\"gbqfqw\");\n                ((((JSBNG__document.activeElement == JSBNG__document.getElementById(\"gbqfq\"))) && this.a(a)));\n            }\n        ;\n        ;\n            a = x(this.w, this);\n            s(\"gbar.qfhi\", a, k);\n        };\n        Gd.prototype.a = function(a) {\n            try {\n                ((a && bc(a, \"gbqfqwf\")));\n            } catch (b) {\n                D(b, \"sf\", \"stf\");\n            };\n        ;\n        };\n        Gd.prototype.f = function(a) {\n            try {\n                ((a && N(a, \"gbqfqwf\")));\n            } catch (b) {\n                D(b, \"sf\", \"stb\");\n            };\n        ;\n        };\n        Gd.prototype.b = function(a) {\n            try {\n                ((a && a.JSBNG__focus()));\n            } catch (b) {\n                D(b, \"sf\", \"sf\");\n            };\n        ;\n        };\n        Gd.prototype.w = function(a) {\n            var b = JSBNG__document.getElementById(\"gbqffd\");\n            if (((b && (b.innerHTML = \"\", a)))) {\n                {\n                    var fin15keys = ((window.top.JSBNG_Replay.forInKeys)((a))), fin15i = (0);\n                    var c;\n                    for (; (fin15i < fin15keys.length); (fin15i++)) {\n                        ((c) = (fin15keys[fin15i]));\n                        {\n                            var d = JSBNG__document.createElement(\"input\");\n                            d.JSBNG__name = c;\n                            d.value = a[c];\n                            d.type = \"hidden\";\n                            b.appendChild(d);\n                        };\n                    };\n                };\n            }\n        ;\n        ;\n        };\n        I(\"sf\", {\n            init: function() {\n                new Gd;\n            }\n        });\n        var Hd, Id, Ld = function() {\n            Jd();\n            Kd(l);\n            JSBNG__setTimeout(function() {\n                JSBNG__document.getElementById(\"gbbbc\").style.display = \"none\";\n            }, 1000);\n            Hd = k;\n        }, Md = function(a) {\n            for (var b = a[0], c = [], d = 1; ((3 >= d)); d++) {\n                var e;\n                e = (((e = /^(.*?)\\$(\\d)\\$(.*)$/.exec(b)) ? {\n                    index: parseInt(e[2], 10),\n                    ha: e[1],\n                    Va: e[3]\n                } : n));\n                if (!e) {\n                    break;\n                }\n            ;\n            ;\n                if (((3 < e.index))) {\n                    throw Error();\n                }\n            ;\n            ;\n                ((e.ha && c.push(e.ha)));\n                c.push(mb(\"A\", {\n                    href: ((\"#gbbb\" + e.index))\n                }, a[e.index]));\n                b = e.Va;\n            };\n        ;\n            ((b && c.push(b)));\n            for (a = JSBNG__document.getElementById(\"gbbbc\"); b = a.firstChild; ) {\n                a.removeChild(b);\n            ;\n            };\n        ;\n            ob(a, c);\n        }, Nd = function(a) {\n            var b = ((a.target || a.srcElement));\n            ((((3 == b.nodeType)) && (b = b.parentNode)));\n            if (b = b.hash) {\n                b = parseInt(b.charAt(((b.length - 1))), 10), ((Hd && Hd(b))), ((a.preventDefault && a.preventDefault())), a.returnValue = p, a.cancelBubble = l;\n            }\n        ;\n        ;\n        }, Jd = function() {\n            ((Id && (JSBNG__clearTimeout(Id), Id = k)));\n        }, Kd = function(a) {\n            var b = JSBNG__document.getElementById(\"gbbbb\").style;\n            ((a ? (b.WebkitTransition = \"opacity 1s, -webkit-transform 0 linear 1s\", b.MozTransition = \"opacity 1s, -moz-transform 0s linear 1s\", b.OTransition = \"opacity 1s, -o-transform 0 linear 1s\", b.transition = \"opacity 1s, transform 0 linear 1s\") : (b.WebkitTransition = b.MozTransition = b.transition = \"\", b.OTransition = \"all 0s\")));\n            b.opacity = \"0\";\n            b.filter = \"alpha(opacity=0)\";\n            b.WebkitTransform = b.MozTransform = b.OTransform = b.transform = \"scale(.2)\";\n        }, Od = function() {\n            var a = JSBNG__document.getElementById(\"gbbbb\").style;\n            a.WebkitTransition = a.MozTransition = a.OTransition = a.transition = \"all 0.218s\";\n            a.opacity = \"1\";\n            a.filter = \"alpha(opacity=100)\";\n            a.WebkitTransform = a.MozTransform = a.OTransform = a.transform = \"scale(1)\";\n        };\n        s(\"gbar.bbs\", function(a, b, c) {\n            try {\n                JSBNG__document.getElementById(\"gbbbc\").style.display = \"inline\", Md(a), Hd = b, Jd(), Kd(p), JSBNG__setTimeout(Od, 0), ((((0 < c)) && (Id = JSBNG__setTimeout(Ld, ((1000 * c))))));\n            } catch (d) {\n                D(d, \"bb\", \"s\");\n            };\n        ;\n        }, k);\n        s(\"gbar.bbr\", function(a, b, c) {\n            try {\n                Md(a), Hd = ((b || Hd)), ((c && (Jd(), ((((0 < c)) && (Id = JSBNG__setTimeout(Ld, ((1000 * c)))))))));\n            } catch (d) {\n                D(d, \"bb\", \"r\");\n            };\n        ;\n        }, k);\n        s(\"gbar.bbh\", Ld, k);\n        I(\"bub\", {\n            init: function() {\n                var a = JSBNG__document.getElementById(\"gbbbb\").style;\n                a.WebkitBorderRadius = a.MozBorderRadius = a.b = \"2px\";\n                a.WebkitBoxShadow = a.a = a.f = \"0px 2px 4px rgba(0,0,0,0.2)\";\n                Kd(p);\n                a.display = \"inline-block\";\n                L(JSBNG__document.getElementById(\"gbbbc\"), \"click\", Nd);\n            }\n        });\n        var Pd = function(a) {\n            this.f = J(\"gbd\");\n            this.b = J(\"gbmmb\");\n            this.a = J(\"gbmm\");\n            ((((Boolean(a.s) && ((((this.f && this.a)) && this.b)))) && (this.w = new rc(this.b, this.a), G.adh(\"gbd\", x(this.k, this)))));\n        };\n        Pd.prototype.k = function() {\n            try {\n                var a = qc.j(\"Height\"), b = JSBNG__document, c = b.body, d = b.documentElement, e = (new A(((c.scrollLeft || d.scrollLeft)), ((c.scrollTop || d.scrollTop)))).y, f = ((lc(this.a).y - e));\n                this.a.style.maxHeight = ((((a - ((2 * f)))) + \"px\"));\n                Gb(this.f);\n                this.w.F();\n            } catch (g) {\n                D(g, \"mm\", \"oo\");\n            };\n        ;\n        };\n        I(\"mm\", {\n            init: function(a) {\n                new Pd(a);\n            }\n        });\n        var Qd = function() {\n            var a = x(this.a, this);\n            s(\"gbar.tsl\", a, k);\n            a = x(this.b, this);\n            s(\"gbar.tst\", a, k);\n        }, Rd = [\"gbx1\",\"gbi4t\",\"gbgs4d\",\"gbg1\",];\n        Qd.prototype.a = function(a, b, c, d) {\n            try {\n                var e = JSBNG__document.getElementById(\"gbqld\");\n                if (e) e.src = a, ((b && (e.alt = b))), ((c && (e.width = c))), ((d && (e.height = d)));\n                 else {\n                    var f = JSBNG__document.getElementById(\"gbqlw\");\n                    if (f) {\n                        gc(f);\n                        var g = mb(\"img\", {\n                            id: \"gbqld\",\n                            src: a,\n                            class: \"gbqldr\"\n                        });\n                        ((b && (g.alt = b)));\n                        ((c && (g.width = c)));\n                        ((d && (g.height = d)));\n                        f.appendChild(g);\n                    }\n                ;\n                ;\n                }\n            ;\n            ;\n            } catch (h) {\n                D(h, \"t\", \"tsl\");\n            };\n        ;\n        };\n        Qd.prototype.b = function(a) {\n            try {\n                var b = [], c = [];\n                switch (a) {\n                  case \"default\":\n                    b = [\"gbthc\",];\n                    c = [\"gbtha\",\"gbthb\",\"gb_gbthb\",];\n                    break;\n                  case \"light\":\n                    b = [\"gbtha\",];\n                    c = [\"gbthc\",\"gbthb\",\"gb_gbthb\",];\n                    break;\n                  case \"dark\":\n                    b = [\"gbthb\",\"gb_gbthb\",];\n                    c = [\"gbthc\",\"gbtha\",];\n                    break;\n                  default:\n                    return;\n                };\n            ;\n                for (a = 0; ((a < Rd.length)); a++) {\n                    var d = JSBNG__document.getElementById(Rd[a]);\n                    if (d) {\n                        var e = d, f = c, g = b, h = Za(e);\n                        if (u(f)) {\n                            var m = h, t = pa(m, f);\n                            ((((0 <= t)) && y.splice.call(m, t, 1)));\n                        }\n                         else ((((\"array\" == ca(f))) && (h = bb(h, f))));\n                    ;\n                    ;\n                        ((((u(g) && !((0 <= pa(h, g))))) ? h.push(g) : ((((\"array\" == ca(g))) && $a(h, g)))));\n                        e.className = h.join(\" \");\n                    }\n                ;\n                ;\n                };\n            ;\n            } catch (v) {\n                D(v, \"t\", \"tst\");\n            };\n        ;\n        };\n        I(\"t\", {\n            init: function() {\n                new Qd;\n            }\n        });\n        var Sd = function(a, b, c, d) {\n            var e = [\"i1\",\"i2\",], f = [], f = ((((0 == ((a.a % 2)))) ? [c,b,] : [b,c,]));\n            b = [];\n            for (c = 0; ((c < e.length)); c++) {\n                b.push({\n                    G: f[c].G,\n                    url: [\"//\",[[a.b,a.k,a.f,a.a,].join(\"-\"),e[c],f[c].P,].join(\"-\"),((\"\" + d)),].join(\"\")\n                });\n            ;\n            };\n        ;\n            return b;\n        }, Td = function(a, b, c) {\n            this.Ea = a;\n            this.Da = b;\n            this.H = c;\n        }, Ud = function(a, b) {\n            function c(a) {\n                ((((e != n)) && (d = Math.abs(((new JSBNG__Date - e))), ((((a || p)) && (d *= -1))))));\n            };\n        ;\n            var d = -1, e = n;\n            this.a = function() {\n                var b = new JSBNG__Image(0, 0);\n                b.JSBNG__onload = function() {\n                    c();\n                };\n                b.JSBNG__onerror = b.JSBNG__onabort = function() {\n                    c(l);\n                };\n                e = new JSBNG__Date;\n                b.src = a;\n            };\n            this.ea = function() {\n                return b;\n            };\n            this.Ba = function() {\n                return d;\n            };\n            this.S = function() {\n                return [b,d,].join(\"=\");\n            };\n        };\n        var U = function() {\n        \n        };\n        U.id = \"3\";\n        U.a = \"/v6exp3/6.gif\";\n        U.M = {\n            G: \"v4_img_dt\",\n            P: \"v6exp3-v4.metric.gstatic.com\"\n        };\n        U.f = {\n            G: \"ds_img_dt\",\n            P: \"v6exp3-ds.metric.gstatic.com\"\n        };\n        U.T = function(a) {\n            return Sd(a, U.M, U.f, U.a);\n        };\n        var W = function() {\n        \n        };\n        W.id = \"dz\";\n        W.L = \"v6exp3-ds.metric.ipv6test.net\";\n        W.k = \"v6exp3-ds.metric.ipv6test.com\";\n        W.a = \"/v6exp3/6.gif\";\n        W.D = {\n            G: \"4z_img_dt\",\n            P: W.L\n        };\n        W.C = {\n            G: \"dz_img_dt\",\n            P: W.k\n        };\n        W.T = function(a) {\n            return Sd(a, W.D, W.C, W.a);\n        };\n        var Vd = function() {\n        \n        };\n        Vd.id = \"ad\";\n        Vd.w = \"//www.google.com/favicon.ico?\";\n        Vd.b = \"//pagead2.googlesyndication.com/favicon.ico?\";\n        Vd.T = function(a) {\n            var b = a.S(), c = {\n                G: \"g_img_dt\",\n                url: ((Vd.w + b))\n            }, b = {\n                G: \"a_img_dt\",\n                url: ((Vd.b + b))\n            };\n            return ((((0 == ((a.a % 2)))) ? [c,b,] : [b,c,]));\n        };\n        var Wd = [new Td(40512, l, Vd),new Td(1, p, W),new Td(98.9, l, U),], Xd = function(a, b, c) {\n            this.b = String(a);\n            ((((\"p\" != this.b.charAt(0))) && (this.b = ((\"p\" + this.b)))));\n            this.k = b;\n            this.f = c;\n            b = Math.JSBNG__random();\n            this.a = Math.floor(((900000 * b)));\n            this.a += 100000;\n            a = ((\"https:\" == JSBNG__document.JSBNG__location.protocol));\n            b *= 100;\n            c = Wd[((Wd.length - 1))].H;\n            var d, e = 0;\n            for (d = 0; ((((d < Wd.length)) && !(e += Wd[d].Ea, ((e >= b))))); d++) {\n            ;\n            };\n        ;\n            if (((((d < Wd.length)) && ((!a || Wd[d].Da))))) {\n                c = Wd[d].H;\n            }\n        ;\n        ;\n            this.H = c;\n        };\n        Xd.prototype.S = function() {\n            return [\"ipv6exp=\",this.H.id,\"&p=\",this.b,\"&rnd=\",this.k,\"&hmac=\",this.f,\"&nonce=\",this.a,].join(\"\");\n        };\n        var Yd = function(a) {\n            for (var b = a.H.T(a), c = 0; ((c < b.length)); c++) {\n                var d = new Ud(b[c].url, b[c].G);\n                d.a();\n                b[c] = d;\n            };\n        ;\n            JSBNG__setTimeout(function() {\n                var c;\n                c = [((\"/gen_204?ipv6exp=\" + a.H.id)),\"sentinel=1\",];\n                for (var d = {\n                    Ca: []\n                }, g = 0; ((g < b.length)); g++) {\n                    c.push(b[g].S()), d[b[g].ea()] = b[g].Ba(), d.Ca.push(b[g].ea());\n                ;\n                };\n            ;\n                c = [\"//\",[[a.b,a.k,a.f,a.a,].join(\"-\"),\"s1-v6exp3-v4.metric.gstatic.com\",].join(\"-\"),c.join(\"&\"),].join(\"\");\n                (new JSBNG__Image(0, 0)).src = c;\n            }, 30000);\n        }, $d = function() {\n            var a = new Xd(Zd[0], Zd[1], Zd[2]);\n            JSBNG__setTimeout(function() {\n                Yd(a);\n            }, 10000);\n        };\n        t:\n        if (((G && G.v6b))) {\n            for (var ae = [\"p\",\"rnd\",\"hmac\",], be = 0; ((be < ae.length)); be++) {\n                if (!G.v6b[ae[be]]) {\n                    break t;\n                }\n            ;\n            ;\n            };\n        ;\n            var ce = ((((((((((G.v6b.p + \"-\")) + G.v6b.rnd)) + \"-\")) + G.v6b.hmac)) + \"-if-v6exp3-v4.metric.gstatic.com\"));\n            try {\n                var de = ((ce || window.JSBNG__location.hostname)), Zd = [], ee = de.indexOf(\".metric.\");\n                (((((Zd = ((((-1 < ee)) ? de.substring(0, ee).split(\"-\") : de.split(\".\")))) && ((3 <= Zd.length)))) && $d()));\n            } catch (fe) {\n                G.logger.ml(fe);\n            };\n        ;\n        }\n    ;\n    ;\n    ;\n        var ge = window, he = JSBNG__document, ke = ge.JSBNG__location, le = function() {\n        \n        }, me = /\\[native code\\]/, X = function(a, b, c) {\n            return a[b] = ((a[b] || c));\n        }, ne = function(a) {\n            for (var b = 0; ((b < this.length)); b++) {\n                if (((this[b] === a))) {\n                    return b;\n                }\n            ;\n            ;\n            };\n        ;\n            return -1;\n        }, oe = function(a) {\n            a = a.sort();\n            for (var b = [], c = k, d = 0; ((d < a.length)); d++) {\n                var e = a[d];\n                ((((e != c)) && b.push(e)));\n                c = e;\n            };\n        ;\n            return b;\n        }, Y = function() {\n            var a;\n            if ((((a = Object.create) && me.test(a)))) a = a(n);\n             else {\n                a = {\n                };\n                {\n                    var fin16keys = ((window.top.JSBNG_Replay.forInKeys)((a))), fin16i = (0);\n                    var b;\n                    for (; (fin16i < fin16keys.length); (fin16i++)) {\n                        ((b) = (fin16keys[fin16i]));\n                        {\n                            a[b] = k;\n                        ;\n                        };\n                    };\n                };\n            ;\n            }\n        ;\n        ;\n            return a;\n        }, pe = function(a, b) {\n            for (var c = 0; ((((c < b.length)) && a)); c++) {\n                a = a[b[c]];\n            ;\n            };\n        ;\n            return a;\n        }, qe = X(ge, \"gapi\", {\n        });\n        var re = function(a, b, c) {\n            var d = RegExp(((((\"([#].*&|[#])\" + b)) + \"=([^&#]*)\")), \"g\");\n            b = RegExp(((((\"([?#].*&|[?#])\" + b)) + \"=([^&#]*)\")), \"g\");\n            if (a = ((a && ((d.exec(a) || b.exec(a)))))) {\n                try {\n                    c = decodeURIComponent(a[2]);\n                } catch (e) {\n                \n                };\n            }\n        ;\n        ;\n            return c;\n        };\n        var Z;\n        Z = X(ge, \"___jsl\", Y());\n        X(Z, \"I\", 0);\n        X(Z, \"hel\", 10);\n        var se = function() {\n            var a = ke.href;\n            return ((!Z.dpo ? re(a, \"jsh\", Z.h) : Z.h));\n        }, te = function(a) {\n            var b = X(Z, \"PQ\", []);\n            Z.PQ = [];\n            var c = b.length;\n            if (((0 === c))) {\n                a();\n            }\n             else {\n                for (var d = 0, e = function() {\n                    ((((++d === c)) && a()));\n                }, f = 0; ((f < c)); f++) {\n                    b[f](e);\n                ;\n                };\n            }\n        ;\n        ;\n        }, ue = function(a) {\n            return X(X(Z, \"H\", Y()), a, Y());\n        }, ve = function(a) {\n            var b = X(Z, \"us\", []);\n            b.push(a);\n            (((a = /^https:(.*)$/.exec(a)) && b.push(((\"http:\" + a[1])))));\n        };\n        var we = X(Z, \"perf\", Y());\n        X(we, \"g\", Y());\n        var xe = X(we, \"i\", Y());\n        X(we, \"r\", []);\n        Y();\n        Y();\n        var ze = function(a, b, c) {\n            ((((b && ((0 < b.length)))) && (b = ye(b), ((((c && ((0 < c.length)))) && (b += ((\"___\" + ye(c)))))), ((((28 < b.length)) && (b = ((b.substr(0, 28) + ((b.length - 28))))))), c = b, b = X(xe, \"_p\", Y()), X(b, c, Y())[a] = (new JSBNG__Date).getTime(), b = we.r, ((((\"function\" === typeof b)) ? b(a, \"_p\", c) : b.push([a,\"_p\",c,]))))));\n        }, ye = function(a) {\n            return a.join(\"__\").replace(/\\./g, \"_\").replace(/\\-/g, \"_\").replace(/\\,/g, \"_\");\n        };\n        var Ae = Y(), Be = [], $ = function(a) {\n            throw Error(((\"Bad hint\" + ((a ? ((\": \" + a)) : \"\")))));\n        };\n        Be.push([\"jsl\",function(a) {\n            {\n                var fin17keys = ((window.top.JSBNG_Replay.forInKeys)((a))), fin17i = (0);\n                var b;\n                for (; (fin17i < fin17keys.length); (fin17i++)) {\n                    ((b) = (fin17keys[fin17i]));\n                    {\n                        if (Object.prototype.hasOwnProperty.call(a, b)) {\n                            var c = a[b];\n                            ((((\"object\" == typeof c)) ? Z[b] = X(Z, b, []).concat(c) : X(Z, b, c)));\n                        }\n                    ;\n                    ;\n                    };\n                };\n            };\n        ;\n            (((a = a.u) && ve(a)));\n        },]);\n        var Ce = /^(\\/[a-zA-Z0-9_\\-]+)+$/, De = /^[a-zA-Z0-9\\-_\\.!]+$/, Ee = /^gapi\\.loaded_[0-9]+$/, Fe = /^[a-zA-Z0-9,._-]+$/, Je = function(a, b, c, d) {\n            var e = a.split(\";\"), f = Ae[e.shift()], g = n;\n            ((f && (g = f(e, b, c, d))));\n            if (!(b = !g)) {\n                b = g, c = b.match(Ge), d = b.match(He), b = !((((((((d && ((1 === d.length)))) && Ie.test(b))) && c)) && ((1 === c.length))));\n            }\n        ;\n        ;\n            ((b && $(a)));\n            return g;\n        }, Me = function(a, b, c, d) {\n            a = Ke(a);\n            ((Ee.test(c) || $(\"invalid_callback\")));\n            b = Le(b);\n            d = ((((d && d.length)) ? Le(d) : n));\n            var e = function(a) {\n                return encodeURIComponent(a).replace(/%2C/g, \",\");\n            };\n            return [encodeURIComponent(a.Ua).replace(/%2C/g, \",\").replace(/%2F/g, \"/\"),\"/k=\",e(a.version),\"/m=\",e(b),((d ? ((\"/exm=\" + e(d))) : \"\")),\"/rt=j/sv=1/d=1/ed=1\",((a.fa ? ((\"/am=\" + e(a.fa))) : \"\")),((a.ga ? ((\"/rs=\" + e(a.ga))) : \"\")),\"/cb=\",e(c),].join(\"\");\n        }, Ke = function(a) {\n            ((((\"/\" !== a.charAt(0))) && $(\"relative path\")));\n            for (var b = a.substring(1).split(\"/\"), c = []; b.length; ) {\n                a = b.shift();\n                if (((!a.length || ((0 == a.indexOf(\".\")))))) {\n                    $(\"empty/relative directory\");\n                }\n                 else {\n                    if (((0 < a.indexOf(\"=\")))) {\n                        b.unshift(a);\n                        break;\n                    }\n                ;\n                }\n            ;\n            ;\n                c.push(a);\n            };\n        ;\n            a = {\n            };\n            for (var d = 0, e = b.length; ((d < e)); ++d) {\n                var f = b[d].split(\"=\"), g = decodeURIComponent(f[0]), h = decodeURIComponent(f[1]);\n                ((((((2 != f.length)) || ((!g || !h)))) || (a[g] = ((a[g] || h)))));\n            };\n        ;\n            b = ((\"/\" + c.join(\"/\")));\n            ((Ce.test(b) || $(\"invalid_prefix\")));\n            c = Ne(a, \"k\", l);\n            d = Ne(a, \"am\");\n            a = Ne(a, \"rs\");\n            return {\n                Ua: b,\n                version: c,\n                fa: d,\n                ga: a\n            };\n        }, Le = function(a) {\n            for (var b = [], c = 0, d = a.length; ((c < d)); ++c) {\n                var e = a[c].replace(/\\./g, \"_\").replace(/-/g, \"_\");\n                ((Fe.test(e) && b.push(e)));\n            };\n        ;\n            return b.join(\",\");\n        }, Ne = function(a, b, c) {\n            a = a[b];\n            ((((!a && c)) && $(((\"missing: \" + b)))));\n            if (a) {\n                if (De.test(a)) {\n                    return a;\n                }\n            ;\n            ;\n                $(((\"invalid: \" + b)));\n            }\n        ;\n        ;\n            return n;\n        }, Ie = /^https?:\\/\\/[a-z0-9_.-]+\\.google\\.com(:\\d+)?\\/[a-zA-Z0-9_.,!=\\-\\/]+$/, He = /\\/cb=/g, Ge = /\\/\\//g, Oe = function() {\n            var a = se();\n            if (!a) {\n                throw Error(\"Bad hint\");\n            }\n        ;\n        ;\n            return a;\n        };\n        Ae.m = function(a, b, c, d) {\n            (((a = a[0]) || $(\"missing_hint\")));\n            return ((\"https://apis.google.com\" + Me(a, b, c, d)));\n        };\n        var Pe = decodeURI(\"%73cript\"), Qe = function(a, b) {\n            for (var c = [], d = 0; ((d < a.length)); ++d) {\n                var e = a[d];\n                ((((e && ((0 > ne.call(b, e))))) && c.push(e)));\n            };\n        ;\n            return c;\n        }, Se = function(a) {\n            ((((\"loading\" != he.readyState)) ? Re(a) : he.write(((((((((((((\"\\u003C\" + Pe)) + \" src=\\\"\")) + encodeURI(a))) + \"\\\"\\u003E\\u003C/\")) + Pe)) + \"\\u003E\")))));\n        }, Re = function(a) {\n            var b = he.createElement(Pe);\n            b.setAttribute(\"src\", a);\n            b.async = \"true\";\n            (((a = he.getElementsByTagName(Pe)[0]) ? a.parentNode.insertBefore(b, a) : ((((he.head || he.body)) || he.documentElement)).appendChild(b)));\n        }, Te = function(a, b) {\n            var c = ((b && b._c));\n            if (c) {\n                for (var d = 0; ((d < Be.length)); d++) {\n                    var e = Be[d][0], f = Be[d][1];\n                    ((((f && Object.prototype.hasOwnProperty.call(c, e))) && f(c[e], a, b)));\n                };\n            }\n        ;\n        ;\n        }, Ve = function(a, b) {\n            Ue(function() {\n                var c;\n                c = ((((b === se())) ? X(qe, \"_\", Y()) : Y()));\n                c = X(ue(b), \"_\", c);\n                a(c);\n            });\n        }, We = function() {\n            return p;\n        }, Ye = function(a, b) {\n            var c = ((b || {\n            }));\n            ((((\"function\" == typeof b)) && (c = {\n            }, c.callback = b)));\n            if (((!We || !We(c)))) {\n                Te(a, c);\n                var d = ((a ? a.split(\":\") : [])), e = ((c.h || Oe())), f = X(Z, \"ah\", Y());\n                if (((!f[\"::\"] || !d.length))) Xe(((d || [])), c, e);\n                 else {\n                    for (var g = [], h = n; h = d.shift(); ) {\n                        var m = h.split(\".\"), m = ((((f[h] || f[((((m[1] && ((\"ns:\" + m[0])))) || \"\"))])) || e)), t = ((((g.length && g[((g.length - 1))])) || n)), v = t;\n                        if (((!t || ((t.hint != m))))) {\n                            v = {\n                                hint: m,\n                                ia: []\n                            }, g.push(v);\n                        }\n                    ;\n                    ;\n                        v.ia.push(h);\n                    };\n                ;\n                    var w = g.length;\n                    if (((1 < w))) {\n                        var z = c.callback;\n                        ((z && (c.callback = function() {\n                            ((((0 == --w)) && z()));\n                        })));\n                    }\n                ;\n                ;\n                    for (; d = g.shift(); ) {\n                        Xe(d.ia, c, d.hint);\n                    ;\n                    };\n                ;\n                }\n            ;\n            ;\n            }\n        ;\n        ;\n        }, Xe = function(a, b, c) {\n            a = ((oe(a) || []));\n            var d = b.callback, e = b.config, f = b.timeout, g = b.ontimeout, h = n, m = p;\n            if (((((f && !g)) || ((!f && g))))) {\n                throw \"Timeout requires both the timeout parameter and ontimeout parameter to be set\";\n            }\n        ;\n        ;\n            var t = X(ue(c), \"r\", []).sort(), v = X(ue(c), \"L\", []).sort(), w = [].concat(t), z = function(a, b) {\n                if (m) {\n                    return 0;\n                }\n            ;\n            ;\n                ge.JSBNG__clearTimeout(h);\n                v.push.apply(v, B);\n                var d = ((((qe || {\n                })).config || {\n                })).update;\n                ((d ? d(e) : ((e && X(Z, \"cu\", []).push(e)))));\n                if (b) {\n                    ze(\"me0\", a, w);\n                    try {\n                        Ve(b, c);\n                    } finally {\n                        ze(\"me1\", a, w);\n                    };\n                ;\n                }\n            ;\n            ;\n                return 1;\n            };\n            ((((0 < f)) && (h = ge.JSBNG__setTimeout(function() {\n                m = l;\n                g();\n            }, f))));\n            var B = Qe(a, v);\n            if (B.length) {\n                var B = Qe(a, t), E = X(Z, \"CP\", []), F = E.length;\n                E[F] = function(a) {\n                    if (!a) {\n                        return 0;\n                    }\n                ;\n                ;\n                    ze(\"ml1\", B, w);\n                    var b = function(b) {\n                        E[F] = n;\n                        ((z(B, a) && te(function() {\n                            ((d && d()));\n                            b();\n                        })));\n                    }, c = function() {\n                        var a = E[((F + 1))];\n                        ((a && a()));\n                    };\n                    ((((((0 < F)) && E[((F - 1))])) ? E[F] = function() {\n                        b(c);\n                    } : b(c)));\n                };\n                if (B.length) {\n                    var H = ((\"loaded_\" + Z.I++));\n                    qe[H] = function(a) {\n                        E[F](a);\n                        qe[H] = n;\n                    };\n                    a = Je(c, B, ((\"gapi.\" + H)), t);\n                    t.push.apply(t, B);\n                    ze(\"ml0\", B, w);\n                    ((((b.sync || ge.___gapisync)) ? Se(a) : Re(a)));\n                }\n                 else E[F](le);\n            ;\n            ;\n            }\n             else ((((z(B) && d)) && d()));\n        ;\n        ;\n        };\n        var Ue = function(a) {\n            if (((Z.hee && ((0 < Z.hel))))) {\n                try {\n                    return a();\n                } catch (b) {\n                    Z.hel--, Ye(\"debug_error\", function() {\n                        window.___jsl.hefn(b);\n                    });\n                };\n            }\n             else {\n                return a();\n            }\n        ;\n        ;\n        };\n        qe.load = function(a, b) {\n            return Ue(function() {\n                return Ye(a, b);\n            });\n        };\n        var Ze = function(a, b, c, d, e, f, g) {\n            this.b = a;\n            this.f = b;\n            this.a = c;\n            this.D = d;\n            this.w = e;\n            this.C = f;\n            this.k = g;\n        };\n        Ze.prototype.toString = function() {\n            var a = [];\n            ((((n !== this.b)) && a.push(this.b, \":\")));\n            ((((n !== this.a)) && (a.push(\"//\"), ((((n !== this.f)) && a.push(this.f, \"@\"))), a.push(this.a), ((((n !== this.D)) && a.push(\":\", this.D.toString()))))));\n            ((((n !== this.w)) && a.push(this.w)));\n            ((((n !== this.C)) && a.push(\"?\", this.C)));\n            ((((n !== this.k)) && a.push(\"#\", this.k)));\n            return a.join(\"\");\n        };\n        var $e = function(a) {\n            return ((((((\"string\" == typeof a)) && ((0 < a.length)))) ? a : n));\n        }, af = /^(?:([^:/?#]+):)?(?:\\/\\/(?:([^/?#]*)@)?([^/?#:@]*)(?::([0-9]+))?)?([^?#]+)?(?:\\?([^#]*))?(?:#(.*))?$/;\n        var bf = /\\.?[a-zA-Z0-9-]+\\.google\\.com$/, cf = function(a, b) {\n            if (b) {\n                var c;\n                c = a.match(af);\n                c = ((!c ? n : new Ze($e(c[1]), $e(c[2]), $e(c[3]), $e(c[4]), $e(c[5]), $e(c[6]), $e(c[7]))));\n                if (!c) {\n                    return p;\n                }\n            ;\n            ;\n                var d = ((c.b && decodeURIComponent(c.b).replace(/\\+/g, \" \")));\n                if (((((\"http\" != d)) && ((\"https\" != d))))) {\n                    return p;\n                }\n            ;\n            ;\n                c = ((c.a && decodeURIComponent(c.a).replace(/\\+/g, \" \")));\n                if (!c) {\n                    return p;\n                }\n            ;\n            ;\n                for (var d = b.split(\",\"), e = 0, f = d.length; ((e < f)); ++e) {\n                    var g = d[e];\n                    if (bf.test(g)) {\n                        var h = c.length, m = g.length;\n                        if (((((h >= m)) && ((c.substring(((h - m))) == g))))) {\n                            return l;\n                        }\n                    ;\n                    ;\n                    }\n                ;\n                ;\n                };\n            ;\n            }\n        ;\n        ;\n            return p;\n        };\n        Ae.n = function(a, b, c, d) {\n            ((((2 != a.length)) && $(\"dev_hint_2_components_only\")));\n            var e = a[0].replace(/\\/+$/, \"\");\n            if (cf(e, Z.m)) {\n                return a = Me(a[1], b, c, d), ((e + a));\n            }\n        ;\n        ;\n        };\n        var df = /([^\\/]*\\/\\/[^\\/]*)(\\/js\\/.*)$/, We = function(a) {\n            var b = pe(a, [\"_c\",\"jsl\",\"u\",]), c = df.exec(b);\n            if (((((Z.dpo || !b)) || !c))) {\n                return p;\n            }\n        ;\n        ;\n            var d = c[1], c = c[2], e = re(b, \"nr\"), f = re(ge.JSBNG__location.href, \"_bsh\");\n            a = pe(a, [\"_c\",\"jsl\",\"m\",]);\n            ((((f && ((!a || !cf(f, a))))) && $()));\n            if (((((((e == k)) && f)) && ((f != d))))) {\n                return d = ((((((((f + c)) + ((((0 <= c.indexOf(\"?\"))) ? \"&\" : \"?\")))) + \"nr=\")) + encodeURIComponent(b))), a = he.getElementsByTagName(Pe), a = a[((a.length - 1))].src, ((((((b && b.replace(/^.*:/, \"\"))) == ((a && a.replace(/^.*:/, \"\"))))) ? Se(d) : Re(d))), l;\n            }\n        ;\n        ;\n            ((/^http/.test(e) && ve(decodeURIComponent(String(e)))));\n            return p;\n        };\n        var ef = function(a) {\n            var b = window.gapi.load;\n            s(\"dgl\", b, G);\n            try {\n                var c = {\n                    isPlusUser: a.pu,\n                    \"googleapis.config\": {\n                        signedIn: a.si\n                    }\n                }, d = a.sh;\n                ((d && (c.iframes = {\n                    \":socialhost:\": d\n                })));\n                ((b && b(\"\", {\n                    config: c\n                })));\n            } catch (e) {\n                D(e, \"gl\", \"init\");\n            };\n        ;\n        };\n        ((qc.o && I(\"gl\", {\n            init: ef\n        })));\n        zb(vb.Wa);\n        (function() {\n            zb(vb.Qa);\n            var a, b;\n            for (a = 0; (((b = G.bnc[a]) && ((\"m\" != b[0])))); ++a) {\n            ;\n            };\n        ;\n            ((((b && !b[1].l)) && (a = function() {\n                for (var a = G.mdc, d = ((G.mdi || {\n                })), e = 0, f; f = wb[e]; ++e) {\n                    var g = f[0], h = a[g], m = d[g], t;\n                    if (t = h) {\n                        if (m = !m) {\n                            var v;\n                            t:\n                            {\n                                m = g;\n                                if (t = G.mdd) {\n                                    try {\n                                        if (!yb) {\n                                            yb = {\n                                            };\n                                            var w = t.split(/;/);\n                                            for (t = 0; ((t < w.length)); ++t) {\n                                                yb[w[t]] = l;\n                                            ;\n                                            };\n                                        ;\n                                        }\n                                    ;\n                                    ;\n                                        v = yb[m];\n                                        break t;\n                                    } catch (z) {\n                                        ((G.logger && G.logger.ml(z)));\n                                    };\n                                }\n                            ;\n                            ;\n                                v = p;\n                            };\n                        ;\n                            m = !v;\n                        }\n                    ;\n                    ;\n                        t = m;\n                    }\n                ;\n                ;\n                    if (t) {\n                        zb(vb.Sa, g);\n                        try {\n                            f[1].init(h), d[g] = l;\n                        } catch (B) {\n                            ((G.logger && G.logger.ml(B)));\n                        };\n                    ;\n                        zb(vb.Ra, g);\n                    }\n                ;\n                ;\n                };\n            ;\n                if (a = G.qd.m) {\n                    G.qd.m = [];\n                    for (d = 0; e = a[d]; ++d) {\n                        try {\n                            e();\n                        } catch (E) {\n                            ((G.logger && G.logger.ml(E)));\n                        };\n                    ;\n                    };\n                ;\n                }\n            ;\n            ;\n                b[1].l = l;\n                zb(vb.Pa);\n                t:\n                {\n                    for (a = 0; d = G.bnc[a]; ++a) {\n                        if (((((d[1].auto || ((\"m\" == d[0])))) && !d[1].l))) {\n                            a = p;\n                            break t;\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    a = l;\n                };\n            ;\n                ((a && zb(vb.Oa)));\n            }, ((((!b[1].libs || ((G.agl && G.agl(b[1].libs))))) ? a() : b[1].i = a)))));\n        })();\n    } catch (e) {\n        ((((window.gbar && gbar.logger)) && gbar.logger.ml(e, {\n            _sn: \"m.init\",\n            _mddn: ((gbar.mddn ? gbar.mddn() : \"0\"))\n        })));\n    };\n;\n})();");
// 1733
o32.parentNode = o33;
// undefined
o32 = null;
// 1734
o33.parentNode = o34;
// 1735
o34.parentNode = o35;
// 1736
o35.parentNode = o16;
// 1737
o16.parentNode = o6;
// 1728
fpc.call(JSBNG_Replay.scee579e12329888b8b29697b3debcf1653f58642_22[9], o6,o68);
// undefined
o68 = null;
// 1783
o28.parentNode = o9;
// 1784
o9.parentNode = o29;
// 1785
o29.parentNode = o16;
// 1786
o16.parentNode = o6;
// 1739
fpc.call(JSBNG_Replay.scee579e12329888b8b29697b3debcf1653f58642_22[10], o6,o69);
// undefined
o69 = null;
// 1793
o36.parentNode = o70;
// 1794
o70.parentNode = o11;
// 1795
o11.parentNode = o19;
// 1796
o19.parentNode = o37;
// 1797
o37.parentNode = o71;
// 1798
o71.parentNode = o72;
// 1799
o72.parentNode = o28;
// 1800
o28.parentNode = o9;
// 1801
o9.parentNode = o29;
// 1802
o29.parentNode = o16;
// 1803
o16.parentNode = o6;
// 1788
fpc.call(JSBNG_Replay.scee579e12329888b8b29697b3debcf1653f58642_22[9], o6,o73);
// undefined
o73 = null;
// 1816
o33.parentNode = o34;
// 1817
o34.parentNode = o35;
// 1818
o35.parentNode = o16;
// 1819
o16.parentNode = o6;
// 1805
fpc.call(JSBNG_Replay.scee579e12329888b8b29697b3debcf1653f58642_22[10], o6,o74);
// undefined
o74 = null;
// 1826
o75.parentNode = o33;
// 1827
o33.parentNode = o34;
// 1828
o34.parentNode = o35;
// 1829
o35.parentNode = o16;
// 1830
o16.parentNode = o6;
// 1821
fpc.call(JSBNG_Replay.scee579e12329888b8b29697b3debcf1653f58642_22[9], o6,o76);
// undefined
o76 = null;
// 1843
o33.parentNode = o34;
// 1844
o34.parentNode = o35;
// 1845
o35.parentNode = o16;
// 1846
o16.parentNode = o6;
// 1832
fpc.call(JSBNG_Replay.scee579e12329888b8b29697b3debcf1653f58642_22[10], o6,o77);
// undefined
o77 = null;
// 1853
o78.parentNode = o33;
// 1854
o33.parentNode = o34;
// 1855
o34.parentNode = o35;
// 1856
o35.parentNode = o16;
// 1857
o16.parentNode = o6;
// 1848
fpc.call(JSBNG_Replay.scee579e12329888b8b29697b3debcf1653f58642_22[9], o6,o79);
// undefined
o79 = null;
// 1864
o16.parentNode = o6;
// 1859
fpc.call(JSBNG_Replay.scee579e12329888b8b29697b3debcf1653f58642_22[10], o6,o80);
// undefined
o80 = null;
// 1871
o16.parentNode = o6;
// 1866
fpc.call(JSBNG_Replay.scee579e12329888b8b29697b3debcf1653f58642_22[9], o6,o81);
// undefined
o81 = null;
// 1878
o78.parentNode = o33;
// 1879
o33.parentNode = o34;
// 1880
o34.parentNode = o35;
// 1881
o35.parentNode = o16;
// 1882
o16.parentNode = o6;
// 1873
fpc.call(JSBNG_Replay.scee579e12329888b8b29697b3debcf1653f58642_22[10], o6,o82);
// undefined
o82 = null;
// 1889
o78.parentNode = o33;
// 1890
o33.parentNode = o34;
// 1891
o34.parentNode = o35;
// 1892
o35.parentNode = o16;
// 1893
o16.parentNode = o6;
// 1884
fpc.call(JSBNG_Replay.scee579e12329888b8b29697b3debcf1653f58642_22[9], o6,o83);
// undefined
o83 = null;
// 1900
o75.parentNode = o33;
// 1901
o33.parentNode = o34;
// 1902
o34.parentNode = o35;
// 1903
o35.parentNode = o16;
// 1904
o16.parentNode = o6;
// 1895
fpc.call(JSBNG_Replay.scee579e12329888b8b29697b3debcf1653f58642_22[10], o6,o84);
// undefined
o84 = null;
// 1911
o75.parentNode = o33;
// 1912
o33.parentNode = o34;
// 1913
o34.parentNode = o35;
// 1914
o35.parentNode = o16;
// 1915
o16.parentNode = o6;
// 1906
fpc.call(JSBNG_Replay.scee579e12329888b8b29697b3debcf1653f58642_22[9], o6,o85);
// undefined
o85 = null;
// 1928
o36.parentNode = o70;
// 1929
o70.parentNode = o11;
// 1930
o11.parentNode = o19;
// 1931
o19.parentNode = o37;
// 1932
o37.parentNode = o71;
// 1933
o71.parentNode = o72;
// 1934
o72.parentNode = o28;
// 1935
o28.parentNode = o9;
// 1936
o9.parentNode = o29;
// 1937
o29.parentNode = o16;
// 1938
o16.parentNode = o6;
// 1917
fpc.call(JSBNG_Replay.scee579e12329888b8b29697b3debcf1653f58642_22[10], o6,o86);
// undefined
o86 = null;
// 1945
o87.parentNode = o36;
// 1946
o36.parentNode = o70;
// 1947
o70.parentNode = o11;
// 1948
o11.parentNode = o19;
// 1949
o19.parentNode = o37;
// 1950
o37.parentNode = o71;
// 1951
o71.parentNode = o72;
// 1952
o72.parentNode = o28;
// 1953
o28.parentNode = o9;
// 1954
o9.parentNode = o29;
// 1955
o29.parentNode = o16;
// 1956
o16.parentNode = o6;
// 1940
fpc.call(JSBNG_Replay.scee579e12329888b8b29697b3debcf1653f58642_22[9], o6,o88);
// undefined
o88 = null;
// 1969
o87.parentNode = o36;
// 1970
o36.parentNode = o70;
// 1971
o70.parentNode = o11;
// 1972
o11.parentNode = o19;
// 1973
o19.parentNode = o37;
// 1974
o37.parentNode = o71;
// 1975
o71.parentNode = o72;
// 1976
o72.parentNode = o28;
// 1977
o28.parentNode = o9;
// 1978
o9.parentNode = o29;
// 1979
o29.parentNode = o16;
// 1980
o16.parentNode = o6;
// 1958
fpc.call(JSBNG_Replay.scee579e12329888b8b29697b3debcf1653f58642_22[10], o6,o89);
// undefined
o89 = null;
// 1987
o20.parentNode = o87;
// 1988
o87.parentNode = o36;
// 1989
o36.parentNode = o70;
// 1990
o70.parentNode = o11;
// 1991
o11.parentNode = o19;
// 1992
o19.parentNode = o37;
// 1993
o37.parentNode = o71;
// 1994
o71.parentNode = o72;
// 1995
o72.parentNode = o28;
// 1996
o28.parentNode = o9;
// 1997
o9.parentNode = o29;
// 1998
o29.parentNode = o16;
// 1999
o16.parentNode = o6;
// 1982
fpc.call(JSBNG_Replay.scee579e12329888b8b29697b3debcf1653f58642_22[9], o6,o90);
// undefined
o90 = null;
// 2006
o87.parentNode = o36;
// 2007
o36.parentNode = o70;
// 2008
o70.parentNode = o11;
// 2009
o11.parentNode = o19;
// 2010
o19.parentNode = o37;
// 2011
o37.parentNode = o71;
// 2012
o71.parentNode = o72;
// 2013
o72.parentNode = o28;
// 2014
o28.parentNode = o9;
// 2015
o9.parentNode = o29;
// 2016
o29.parentNode = o16;
// 2017
o16.parentNode = o6;
// 2001
fpc.call(JSBNG_Replay.scee579e12329888b8b29697b3debcf1653f58642_22[10], o6,o91);
// undefined
o91 = null;
// 2024
o87.parentNode = o36;
// 2025
o36.parentNode = o70;
// 2026
o70.parentNode = o11;
// 2027
o11.parentNode = o19;
// 2028
o19.parentNode = o37;
// 2029
o37.parentNode = o71;
// 2030
o71.parentNode = o72;
// 2031
o72.parentNode = o28;
// 2032
o28.parentNode = o9;
// 2033
o9.parentNode = o29;
// 2034
o29.parentNode = o16;
// 2035
o16.parentNode = o6;
// 2019
fpc.call(JSBNG_Replay.scee579e12329888b8b29697b3debcf1653f58642_22[9], o6,o92);
// undefined
o92 = null;
// 2042
o75.parentNode = o33;
// 2043
o33.parentNode = o34;
// 2044
o34.parentNode = o35;
// 2045
o35.parentNode = o16;
// 2046
o16.parentNode = o6;
// 2037
fpc.call(JSBNG_Replay.scee579e12329888b8b29697b3debcf1653f58642_22[10], o6,o93);
// undefined
o93 = null;
// 2049
f895948954_0.now = f895948954_389;
// 2051
o3.userAgent = "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.8; rv:21.0) Gecko/20100101 Firefox/21.0";
// 2052
ow895948954.JSBNG__opera = undefined;
// 2053
o3.userAgent = "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.8; rv:21.0) Gecko/20100101 Firefox/21.0";
// 2054
o3.product = "Gecko";
// 2057
o3.userAgent = "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.8; rv:21.0) Gecko/20100101 Firefox/21.0";
// 2058
o3.userAgent = "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.8; rv:21.0) Gecko/20100101 Firefox/21.0";
// 2063
o3.userAgent = "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.8; rv:21.0) Gecko/20100101 Firefox/21.0";
// 2069
o0.getElementsByTagName = f895948954_417;
// 2074
o0.documentElement = o6;
// 2078
ow895948954.JSBNG__devicePixelRatio = 1;
// 2081
o0.JSBNG__addEventListener = f895948954_449;
// 2082
o0.JSBNG__addEventListener = f895948954_449;
// 2084
o3.userAgent = "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.8; rv:21.0) Gecko/20100101 Firefox/21.0";
// 2085
o3.userAgent = "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.8; rv:21.0) Gecko/20100101 Firefox/21.0";
// 2086
o3.userAgent = "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.8; rv:21.0) Gecko/20100101 Firefox/21.0";
// undefined
o3 = null;
// 2088
o0.createElement = f895948954_428;
// 2100
o5.pathname = "/";
// 2101
o0.getElementById = f895948954_393;
// 2103
o0.getElementById = f895948954_393;
// 2106
o0.getElementById = f895948954_393;
// 2109
o5.href = "http://www.google.com/";
// 2110
o5.href = "http://www.google.com/";
// 2111
o5.href = "http://www.google.com/";
// 2113
o5.href = "http://www.google.com/";
// 2114
o5.pathname = "/";
// 2115
o5.href = "http://www.google.com/";
// 2117
o0.getElementsByTagName = f895948954_417;
// 2126
o19.JSBNG__onsubmit = f895948954_532;
// 2130
o0.JSBNG__addEventListener = f895948954_449;
// 2131
o0.JSBNG__addEventListener = f895948954_449;
// 2133
o5.hash = "";
// 2134
o5.hash = "";
// 2137
o1.getItem = f895948954_406;
// 2139
o1.setItem = f895948954_407;
// 2141
o1.getItem = f895948954_406;
// 2143
o1.setItem = f895948954_407;
// 2145
o1.getItem = f895948954_406;
// 2147
o1.setItem = f895948954_407;
// 2149
o1.setItem = f895948954_407;
// 2151
o1.getItem = f895948954_406;
// 2153
o1.getItem = f895948954_406;
// 2155
o1.setItem = f895948954_407;
// 2157
o1.getItem = f895948954_406;
// 2159
o1.setItem = f895948954_407;
// 2161
o1.getItem = f895948954_406;
// 2163
o1.setItem = f895948954_407;
// 2165
o1.setItem = f895948954_407;
// 2167
o1.setItem = f895948954_407;
// 2169
o1.getItem = f895948954_406;
// 2171
o1.getItem = f895948954_406;
// 2173
o1.getItem = f895948954_406;
// 2175
o1.getItem = f895948954_406;
// 2178
o0.body = o16;
// 2180
o0.getElementById = f895948954_393;
// 2183
o0.getElementById = f895948954_393;
// 2186
o0.getElementById = f895948954_393;
// 2189
o0.getElementById = f895948954_393;
// 2196
o38.id = "gb_119";
// 2200
o39.id = "gb_1";
// 2204
o40.id = "gb_2";
// 2208
o41.id = "gb_8";
// 2212
o42.id = "gb_78";
// 2216
o23.id = "gb_36";
// 2220
o43.id = "gb_5";
// 2224
o44.id = "gb_23";
// 2228
o45.id = "gb_25";
// 2232
o46.id = "gb_24";
// 2238
o48.id = "gb_51";
// 2242
o49.id = "gb_17";
// 2246
o50.id = "gb_10";
// 2250
o51.id = "gb_172";
// 2254
o52.id = "gb_212";
// 2258
o53.id = "gb_6";
// 2262
o54.id = "gb_30";
// 2266
o55.id = "gb_27";
// 2270
o56.id = "gb_31";
// 2274
o57.id = "gb_12";
// 2282
o10.id = "gb_70";
// 2294
o0.getElementById = f895948954_393;
// 2300
o5.hash = "";
// 2301
o5.hash = "";
// 2302
o5.hash = "";
// 2303
o5.href = "http://www.google.com/";
// 2304
o0.body = o16;
// 2308
o0.body = o16;
// 2309
o16.style = o94;
// undefined
o94 = null;
// 2311
o0.createElement = f895948954_428;
// 2315
o0.getElementById = f895948954_393;
// 2317
o0.body = o16;
// 2318
o16.appendChild = f895948954_431;
// 2320
o0.getElementById = f895948954_393;
// 2329
o0.getElementsByName = f895948954_539;
// 2333
ow895948954.JSBNG__innerWidth = 994;
// 2334
ow895948954.JSBNG__innerWidth = 994;
// 2335
o0.getElementsByName = f895948954_539;
// 2339
ow895948954.JSBNG__innerHeight = 603;
// 2340
ow895948954.JSBNG__innerHeight = 603;
// 2341
o0.getElementsByName = f895948954_539;
// 2346
o0.JSBNG__addEventListener = f895948954_449;
// 2347
o0.JSBNG__addEventListener = f895948954_449;
// 2356
o0.getElementById = f895948954_393;
// 2358
o0.getElementsByTagName = f895948954_417;
// 2362
o0.getElementsByTagName = f895948954_417;
// 2372
o38.className = "gbzt";
// undefined
o38 = null;
// 2374
o39.className = "gbzt gbz0l gbp1";
// undefined
o39 = null;
// 2376
o40.className = "gbzt";
// undefined
o40 = null;
// 2378
o41.className = "gbzt";
// undefined
o41 = null;
// 2380
o42.className = "gbzt";
// undefined
o42 = null;
// 2382
o23.className = "gbzt";
// undefined
o23 = null;
// 2384
o43.className = "gbzt";
// undefined
o43 = null;
// 2386
o44.className = "gbzt";
// undefined
o44 = null;
// 2388
o45.className = "gbzt";
// undefined
o45 = null;
// 2390
o46.className = "gbzt";
// undefined
o46 = null;
// 2392
o47.className = "gbgt";
// undefined
o47 = null;
// 2394
o48.className = "gbmt";
// undefined
o48 = null;
// 2396
o49.className = "gbmt";
// undefined
o49 = null;
// 2398
o50.className = "gbmt";
// undefined
o50 = null;
// 2400
o51.className = "gbmt";
// undefined
o51 = null;
// 2402
o52.className = "gbmt";
// undefined
o52 = null;
// 2404
o53.className = "gbmt";
// undefined
o53 = null;
// 2406
o54.className = "gbmt";
// undefined
o54 = null;
// 2408
o55.className = "gbmt";
// undefined
o55 = null;
// 2410
o56.className = "gbmt";
// undefined
o56 = null;
// 2412
o57.className = "gbmt";
// undefined
o57 = null;
// 2414
o58.className = "gbmt";
// undefined
o58 = null;
// 2416
o59.className = "gbqla";
// undefined
o59 = null;
// 2418
o10.className = "gbgt";
// undefined
o10 = null;
// 2420
o60.className = "gbmt";
// undefined
o60 = null;
// 2422
o61.className = "gbmt";
// undefined
o61 = null;
// 2424
o62.className = "gbmt";
// undefined
o62 = null;
// 2426
o63.className = "gbmt";
// undefined
o63 = null;
// 2446
o0.getElementById = f895948954_393;
// 2452
o0.querySelector = f895948954_557;
// 2454
o0.getElementById = f895948954_393;
// 2456
o0.querySelectorAll = f895948954_556;
// 2457
o0.querySelector = f895948954_557;
// 2458
o0.querySelector = f895948954_557;
// 2460
o0.getElementById = f895948954_393;
// 2462
o0.getElementById = f895948954_393;
// 2464
o0.getElementById = f895948954_393;
// 2466
o0.querySelectorAll = f895948954_556;
// 2470
o4.length = 0;
// undefined
o4 = null;
// 2471
o0.querySelectorAll = f895948954_556;
// 2475
o0.querySelectorAll = f895948954_556;
// 2476
o0.querySelector = f895948954_557;
// 2477
o0.querySelectorAll = f895948954_556;
// 2481
o0.createElement = f895948954_428;
// 2487
o0.getElementById = f895948954_393;
// 2489
o0.getElementById = f895948954_393;
// 2491
o0.getElementById = f895948954_393;
// 2493
o0.getElementById = f895948954_393;
// 2495
o0.querySelector = f895948954_557;
// 2497
o0.body = o16;
// 2500
o0.defaultView = ow895948954;
// 2501
o0.defaultView = ow895948954;
// 2502
o0.defaultView = ow895948954;
// 2507
o0.getElementById = f895948954_393;
// 2509
o0.getElementById = f895948954_393;
// 2511
o0.getElementById = f895948954_393;
// 2513
o0.getElementById = f895948954_393;
// 2515
o0.getElementById = f895948954_393;
// 2517
o0.getElementById = f895948954_393;
// 2519
o1.getItem = f895948954_406;
// 2521
o1.setItem = f895948954_407;
// undefined
o1 = null;
// 2524
o0.getElementById = f895948954_393;
// 2528
o5.hash = "";
// 2529
o5.href = "http://www.google.com/";
// 2531
o5.hash = "";
// 2532
o5.hash = "";
// 2537
o0.getElementById = f895948954_393;
// 2539
o0.getElementById = f895948954_393;
// 2541
o0.getElementById = f895948954_393;
// 2543
o0.getElementById = f895948954_393;
// 2546
o0.getElementById = f895948954_393;
// 2555
o7.connectEnd = 1373476536820;
// 2556
o7.connectStart = 1373476536820;
// 2559
o7.domainLookupEnd = 1373476536820;
// 2560
o7.domainLookupStart = 1373476536820;
// 2564
o7.responseEnd = 1373476538870;
// 2565
o7.requestStart = 1373476536822;
// 2566
o7.responseEnd = 1373476538870;
// 2568
o7.responseEnd = 1373476538870;
// 2569
o7.responseStart = 1373476538856;
// undefined
o7 = null;
// 2571
o5.protocol = "http:";
// 2047
geval("var _ = ((_ || {\n}));\n(function(_) {\n    var window = this;\n    try {\n        var aaa;\n        var Ya;\n        _.aa = function() {\n            return function(a) {\n                return a;\n            };\n        };\n        _.ka = function() {\n            return function() {\n            \n            };\n        };\n        _.la = function(a) {\n            return function(b) {\n                this[a] = b;\n            };\n        };\n        _.ma = function(a) {\n            return function() {\n                return this[a];\n            };\n        };\n        _.ua = function(a) {\n            return function() {\n                return a;\n            };\n        };\n        _.za = function(a, b, c) {\n            a = a.split(\".\");\n            c = ((c || _.Ca));\n            ((((((a[0] in c)) || !c.execScript)) || c.execScript(((\"var \" + a[0])))));\n            for (var d; ((a.length && (d = a.shift()))); ) {\n                ((((a.length || ((void 0 === b)))) ? c = ((c[d] ? c[d] : c[d] = {\n                })) : c[d] = b));\n            ;\n            };\n        ;\n        };\n        _.Fa = function(a, b) {\n            for (var c = a.split(\".\"), d = ((b || _.Ca)), e; e = c.shift(); ) {\n                if (((null != d[e]))) {\n                    d = d[e];\n                }\n                 else {\n                    return null;\n                }\n            ;\n            ;\n            };\n        ;\n            return d;\n        };\n        _.Ga = function() {\n        \n        };\n        _.Ia = function(a) {\n            a.G = function() {\n                return ((a.JQ ? a.JQ : a.JQ = new a));\n            };\n        };\n        _.La = function(a) {\n            var b = typeof a;\n            if (((\"object\" == b))) {\n                if (a) {\n                    if (((a instanceof Array))) {\n                        return \"array\";\n                    }\n                ;\n                ;\n                    if (((a instanceof Object))) {\n                        return b;\n                    }\n                ;\n                ;\n                    var c = Object.prototype.toString.call(a);\n                    if (((\"[object Window]\" == c))) {\n                        return \"object\";\n                    }\n                ;\n                ;\n                    if (((((\"[object Array]\" == c)) || ((((((((\"number\" == typeof a.length)) && ((\"undefined\" != typeof a.splice)))) && ((\"undefined\" != typeof a.propertyIsEnumerable)))) && !a.propertyIsEnumerable(\"splice\")))))) {\n                        return \"array\";\n                    }\n                ;\n                ;\n                    if (((((\"[object Function]\" == c)) || ((((((\"undefined\" != typeof a.call)) && ((\"undefined\" != typeof a.propertyIsEnumerable)))) && !a.propertyIsEnumerable(\"call\")))))) {\n                        return \"function\";\n                    }\n                ;\n                ;\n                }\n                 else return \"null\"\n            ;\n            }\n             else {\n                if (((((\"function\" == b)) && ((\"undefined\" == typeof a.call))))) {\n                    return \"object\";\n                }\n            ;\n            }\n        ;\n        ;\n            return b;\n        };\n        _.Ma = function(a) {\n            return ((void 0 !== a));\n        };\n        _.Oa = function(a) {\n            return ((\"array\" == (0, _.La)(a)));\n        };\n        _.Qa = function(a) {\n            var b = (0, _.La)(a);\n            return ((((\"array\" == b)) || ((((\"object\" == b)) && ((\"number\" == typeof a.length))))));\n        };\n        _.Ra = function(a) {\n            return ((\"string\" == typeof a));\n        };\n        _.Sa = function(a) {\n            return ((\"number\" == typeof a));\n        };\n        _.Va = function(a) {\n            return ((\"function\" == (0, _.La)(a)));\n        };\n        _.Wa = function(a) {\n            var b = typeof a;\n            return ((((((\"object\" == b)) && ((null != a)))) || ((\"function\" == b))));\n        };\n        _.Xa = function(a) {\n            return ((a[Ya] || (a[Ya] = ++aaa)));\n        };\n        var baa = function(a, b, c) {\n            return a.call.apply(a.bind, arguments);\n        };\n        var caa = function(a, b, c) {\n            if (!a) {\n                throw Error();\n            }\n        ;\n        ;\n            if (((2 < arguments.length))) {\n                var d = Array.prototype.slice.call(arguments, 2);\n                return function() {\n                    var c = Array.prototype.slice.call(arguments);\n                    Array.prototype.unshift.apply(c, d);\n                    return a.apply(b, c);\n                };\n            }\n        ;\n        ;\n            return function() {\n                return a.apply(b, arguments);\n            };\n        };\n        _.$a = function(a, b, c) {\n            _.$a = ((((Function.prototype.bind && ((-1 != Function.prototype.bind.toString().indexOf(\"native code\"))))) ? baa : caa));\n            return _.$a.apply(null, arguments);\n        };\n        _.ab = function(a, b) {\n            var c = Array.prototype.slice.call(arguments, 1);\n            return function() {\n                var b = Array.prototype.slice.call(arguments);\n                b.unshift.apply(b, c);\n                return a.apply(this, b);\n            };\n        };\n        _.cb = function(a, b, c) {\n            (0, _.za)(a, b, c);\n        };\n        _.db = function(a, b) {\n            function c() {\n            \n            };\n        ;\n            c.prototype = b.prototype;\n            a.ja = b.prototype;\n            a.prototype = new c;\n            a.prototype.constructor = a;\n        };\n        _.fb = function(a) {\n            ((Error.captureStackTrace ? Error.captureStackTrace(this, _.fb) : this.stack = ((Error().stack || \"\"))));\n            ((a && (this.message = String(a))));\n        };\n        _.gb = function(a, b) {\n            return ((0 == a.lastIndexOf(b, 0)));\n        };\n        _.ib = function(a, b) {\n            var c = ((a.length - b.length));\n            return ((((0 <= c)) && ((a.indexOf(b, c) == c))));\n        };\n        _.jb = function(a, b) {\n            for (var c = a.split(\"%s\"), d = \"\", e = Array.prototype.slice.call(arguments, 1); ((e.length && ((1 < c.length)))); ) {\n                d += ((c.shift() + e.shift()));\n            ;\n            };\n        ;\n            return ((d + c.join(\"%s\")));\n        };\n        _.kb = function(a) {\n            return a.replace(/[\\s\\xa0]+/g, \" \").replace(/^\\s+|\\s+$/g, \"\");\n        };\n        _.lb = function(a) {\n            return /^[\\s\\xa0]*$/.test(a);\n        };\n        _.ob = function(a) {\n            return (0, _.lb)(((((null == a)) ? \"\" : String(a))));\n        };\n        _.pb = function(a) {\n            return a.replace(/^[\\s\\xa0]+|[\\s\\xa0]+$/g, \"\");\n        };\n        _.qb = function(a, b) {\n            if (b) {\n                return a.replace(rb, \"&amp;\").replace(sb, \"&lt;\").replace(tb, \"&gt;\").replace(ub, \"&quot;\");\n            }\n        ;\n        ;\n            if (!daa.test(a)) {\n                return a;\n            }\n        ;\n        ;\n            ((((-1 != a.indexOf(\"&\"))) && (a = a.replace(rb, \"&amp;\"))));\n            ((((-1 != a.indexOf(\"\\u003C\"))) && (a = a.replace(sb, \"&lt;\"))));\n            ((((-1 != a.indexOf(\"\\u003E\"))) && (a = a.replace(tb, \"&gt;\"))));\n            ((((-1 != a.indexOf(\"\\\"\"))) && (a = a.replace(ub, \"&quot;\"))));\n            return a;\n        };\n        _.vb = function(a) {\n            return String(a).replace(/([-()\\[\\]{}+?*.$\\^|,:#<!\\\\])/g, \"\\\\$1\").replace(/\\x08/g, \"\\\\x08\");\n        };\n        _.wb = function(a, b) {\n            return Array(((b + 1))).join(a);\n        };\n        _.xb = function(a) {\n            var b = Number(a);\n            return ((((((0 == b)) && (0, _.lb)(a))) ? window.NaN : b));\n        };\n        _.yb = function(a) {\n            return String(a).replace(/\\-([a-z])/g, function(a, c) {\n                return c.toUpperCase();\n            });\n        };\n        var zb = function(a) {\n            return String(a).replace(/([A-Z])/g, \"-$1\").toLowerCase();\n        };\n        var eaa = function(a, b) {\n            var c = (((0, _.Ra)(b) ? (0, _.vb)(b) : \"\\\\s\")), c = ((c ? ((((\"|[\" + c)) + \"]+\")) : \"\"));\n            return a.replace(RegExp(((((\"(^\" + c)) + \")([a-z])\")), \"g\"), function(a, b, c) {\n                return ((b + c.toUpperCase()));\n            });\n        };\n        _.Cb = function(a, b, c) {\n            for (var d = (((0, _.Ra)(a) ? a.split(\"\") : a)), e = ((a.length - 1)); ((0 <= e)); --e) {\n                ((((e in d)) && b.call(c, d[e], e, a)));\n            ;\n            };\n        ;\n        };\n        _.Db = function(a, b, c) {\n            b = (0, _.Eb)(a, b, c);\n            return ((((0 > b)) ? null : (((0, _.Ra)(a) ? a.charAt(b) : a[b]))));\n        };\n        _.Eb = function(a, b, c) {\n            for (var d = a.length, e = (((0, _.Ra)(a) ? a.split(\"\") : a)), f = 0; ((f < d)); f++) {\n                if (((((f in e)) && b.call(c, e[f], f, a)))) {\n                    return f;\n                }\n            ;\n            ;\n            };\n        ;\n            return -1;\n        };\n        _.Fb = function(a, b) {\n            return ((0 <= (0, _.Gb)(a, b)));\n        };\n        _.Hb = function(a, b) {\n            (((0, _.Fb)(a, b) || a.push(b)));\n        };\n        _.Ib = function(a, b) {\n            var c = (0, _.Gb)(a, b), d;\n            (((d = ((0 <= c))) && (0, _.Jb)(a, c)));\n            return d;\n        };\n        _.Jb = function(a, b) {\n            return ((1 == Kb.splice.call(a, b, 1).length));\n        };\n        _.Lb = function(a) {\n            return Kb.concat.apply(Kb, arguments);\n        };\n        _.Mb = function(a) {\n            var b = a.length;\n            if (((0 < b))) {\n                for (var c = Array(b), d = 0; ((d < b)); d++) {\n                    c[d] = a[d];\n                ;\n                };\n            ;\n                return c;\n            }\n        ;\n        ;\n            return [];\n        };\n        _.Nb = function(a, b) {\n            for (var c = 1; ((c < arguments.length)); c++) {\n                var d = arguments[c], e;\n                if ((((0, _.Oa)(d) || (((e = (0, _.Qa)(d)) && Object.prototype.hasOwnProperty.call(d, \"callee\")))))) {\n                    a.push.apply(a, d);\n                }\n                 else {\n                    if (e) {\n                        for (var f = a.length, g = d.length, h = 0; ((h < g)); h++) {\n                            a[((f + h))] = d[h];\n                        ;\n                        };\n                    }\n                     else {\n                        a.push(d);\n                    }\n                ;\n                }\n            ;\n            ;\n            };\n        ;\n        };\n        _.Ob = function(a, b, c, d) {\n            return Kb.splice.apply(a, (0, _.Pb)(arguments, 1));\n        };\n        _.Pb = function(a, b, c) {\n            return ((((2 >= arguments.length)) ? Kb.slice.call(a, b) : Kb.slice.call(a, b, c)));\n        };\n        _.Sb = function(a, b) {\n            for (var c = ((b || a)), d = {\n            }, e = 0, f = 0; ((f < a.length)); ) {\n                var g = a[f++], h = (((0, _.Wa)(g) ? ((\"o\" + (0, _.Xa)(g))) : (((typeof g).charAt(0) + g))));\n                ((Object.prototype.hasOwnProperty.call(d, h) || (d[h] = !0, c[e++] = g)));\n            };\n        ;\n            c.length = e;\n        };\n        _.Tb = function(a, b) {\n            Kb.sort.call(a, ((b || _.Ub)));\n        };\n        _.Ub = function(a, b) {\n            return ((((a > b)) ? 1 : ((((a < b)) ? -1 : 0))));\n        };\n        _.Vb = function() {\n        \n        };\n        var Wb = function(a) {\n            if (((a instanceof _.Vb))) {\n                return a;\n            }\n        ;\n        ;\n            if (((\"function\" == typeof a.nx))) {\n                return a.nx(!1);\n            }\n        ;\n        ;\n            if ((0, _.Qa)(a)) {\n                var b = 0, c = new _.Vb;\n                c.next = function() {\n                    for (; ; ) {\n                        if (((b >= a.length))) {\n                            throw Xb;\n                        }\n                    ;\n                    ;\n                        if (((b in a))) {\n                            return a[b++];\n                        }\n                    ;\n                    ;\n                        b++;\n                    };\n                ;\n                };\n                return c;\n            }\n        ;\n        ;\n            throw Error(\"Not implemented\");\n        };\n        var Yb = function(a, b, c) {\n            if ((0, _.Qa)(a)) try {\n                (0, _.Zb)(a, b, c);\n            } catch (d) {\n                if (((d !== Xb))) {\n                    throw d;\n                }\n            ;\n            ;\n            }\n             else {\n                a = Wb(a);\n                try {\n                    for (; ; ) {\n                        b.call(c, a.next(), void 0, a);\n                    ;\n                    };\n                ;\n                } catch (e) {\n                    if (((e !== Xb))) {\n                        throw e;\n                    }\n                ;\n                ;\n                };\n            ;\n            }\n        ;\n        ;\n        };\n        var faa = function(a) {\n            if ((0, _.Qa)(a)) {\n                return (0, _.Mb)(a);\n            }\n        ;\n        ;\n            a = Wb(a);\n            var b = [];\n            Yb(a, function(a) {\n                b.push(a);\n            });\n            return b;\n        };\n        _.$b = function(a, b, c) {\n            {\n                var fin18keys = ((window.top.JSBNG_Replay.forInKeys)((a))), fin18i = (0);\n                var d;\n                for (; (fin18i < fin18keys.length); (fin18i++)) {\n                    ((d) = (fin18keys[fin18i]));\n                    {\n                        b.call(c, a[d], d, a);\n                    ;\n                    };\n                };\n            };\n        ;\n        };\n        _.ac = function(a) {\n            var b = 0, c;\n            {\n                var fin19keys = ((window.top.JSBNG_Replay.forInKeys)((a))), fin19i = (0);\n                (0);\n                for (; (fin19i < fin19keys.length); (fin19i++)) {\n                    ((c) = (fin19keys[fin19i]));\n                    {\n                        b++;\n                    ;\n                    };\n                };\n            };\n        ;\n            return b;\n        };\n        _.bc = function(a) {\n            var b = [], c = 0, d;\n            {\n                var fin20keys = ((window.top.JSBNG_Replay.forInKeys)((a))), fin20i = (0);\n                (0);\n                for (; (fin20i < fin20keys.length); (fin20i++)) {\n                    ((d) = (fin20keys[fin20i]));\n                    {\n                        b[c++] = a[d];\n                    ;\n                    };\n                };\n            };\n        ;\n            return b;\n        };\n        _.dc = function(a) {\n            var b = [], c = 0, d;\n            {\n                var fin21keys = ((window.top.JSBNG_Replay.forInKeys)((a))), fin21i = (0);\n                (0);\n                for (; (fin21i < fin21keys.length); (fin21i++)) {\n                    ((d) = (fin21keys[fin21i]));\n                    {\n                        b[c++] = d;\n                    ;\n                    };\n                };\n            };\n        ;\n            return b;\n        };\n        _.fc = function(a) {\n            {\n                var fin22keys = ((window.top.JSBNG_Replay.forInKeys)((a))), fin22i = (0);\n                var b;\n                for (; (fin22i < fin22keys.length); (fin22i++)) {\n                    ((b) = (fin22keys[fin22i]));\n                    {\n                        return !1;\n                    };\n                };\n            };\n        ;\n            return !0;\n        };\n        _.hc = function(a, b) {\n            var c;\n            (((c = ((b in a))) && delete a[b]));\n            return c;\n        };\n        _.ic = function(a, b, c) {\n            return ((((b in a)) ? a[b] : c));\n        };\n        _.jc = function(a) {\n            var b = {\n            }, c;\n            {\n                var fin23keys = ((window.top.JSBNG_Replay.forInKeys)((a))), fin23i = (0);\n                (0);\n                for (; (fin23i < fin23keys.length); (fin23i++)) {\n                    ((c) = (fin23keys[fin23i]));\n                    {\n                        b[c] = a[c];\n                    ;\n                    };\n                };\n            };\n        ;\n            return b;\n        };\n        _.kc = function(a) {\n            var b = {\n            }, c;\n            {\n                var fin24keys = ((window.top.JSBNG_Replay.forInKeys)((a))), fin24i = (0);\n                (0);\n                for (; (fin24i < fin24keys.length); (fin24i++)) {\n                    ((c) = (fin24keys[fin24i]));\n                    {\n                        b[a[c]] = c;\n                    ;\n                    };\n                };\n            };\n        ;\n            return b;\n        };\n        _.lc = function(a, b) {\n            for (var c, d, e = 1; ((e < arguments.length)); e++) {\n                d = arguments[e];\n                {\n                    var fin25keys = ((window.top.JSBNG_Replay.forInKeys)((d))), fin25i = (0);\n                    (0);\n                    for (; (fin25i < fin25keys.length); (fin25i++)) {\n                        ((c) = (fin25keys[fin25i]));\n                        {\n                            a[c] = d[c];\n                        ;\n                        };\n                    };\n                };\n            ;\n                for (var f = 0; ((f < mc.length)); f++) {\n                    c = mc[f], ((Object.prototype.hasOwnProperty.call(d, c) && (a[c] = d[c])));\n                ;\n                };\n            ;\n            };\n        ;\n        };\n        _.nc = function(a) {\n            var b = arguments.length;\n            if (((((1 == b)) && (0, _.Oa)(arguments[0])))) {\n                return _.nc.apply(null, arguments[0]);\n            }\n        ;\n        ;\n            for (var c = {\n            }, d = 0; ((d < b)); d++) {\n                c[arguments[d]] = !0;\n            ;\n            };\n        ;\n            return c;\n        };\n        _.oc = function(a, b) {\n            this.Qc = {\n            };\n            this.A = [];\n            var c = arguments.length;\n            if (((1 < c))) {\n                if (((c % 2))) {\n                    throw Error(\"Uneven number of arguments\");\n                }\n            ;\n            ;\n                for (var d = 0; ((d < c)); d += 2) {\n                    this.set(arguments[d], arguments[((d + 1))]);\n                ;\n                };\n            ;\n            }\n             else if (a) {\n                ((((a instanceof _.oc)) ? (c = a.vw(), d = a.ot()) : (c = (0, _.dc)(a), d = (0, _.bc)(a))));\n                for (var e = 0; ((e < c.length)); e++) {\n                    this.set(c[e], d[e]);\n                ;\n                };\n            ;\n            }\n            \n        ;\n        ;\n        };\n        var gaa = function(a, b) {\n            return ((a === b));\n        };\n        var pc = function(a) {\n            if (((a.Yh != a.A.length))) {\n                for (var b = 0, c = 0; ((b < a.A.length)); ) {\n                    var d = a.A[b];\n                    (((0, _.qc)(a.Qc, d) && (a.A[c++] = d)));\n                    b++;\n                };\n            ;\n                a.A.length = c;\n            }\n        ;\n        ;\n            if (((a.Yh != a.A.length))) {\n                for (var e = {\n                }, c = b = 0; ((b < a.A.length)); ) {\n                    d = a.A[b], (((0, _.qc)(e, d) || (a.A[c++] = d, e[d] = 1))), b++;\n                ;\n                };\n            ;\n                a.A.length = c;\n            }\n        ;\n        ;\n        };\n        _.qc = function(a, b) {\n            return Object.prototype.hasOwnProperty.call(a, b);\n        };\n        var rc = function(a) {\n            {\n                var fin26keys = ((window.top.JSBNG_Replay.forInKeys)((_.sc))), fin26i = (0);\n                var b;\n                for (; (fin26i < fin26keys.length); (fin26i++)) {\n                    ((b) = (fin26keys[fin26i]));\n                    {\n                        _.sc[b] = !1;\n                    ;\n                    };\n                };\n            };\n        ;\n            {\n                var fin27keys = ((window.top.JSBNG_Replay.forInKeys)((_.tc))), fin27i = (0);\n                var c;\n                for (; (fin27i < fin27keys.length); (fin27i++)) {\n                    ((c) = (fin27keys[fin27i]));\n                    {\n                        _.tc[c] = !1;\n                    ;\n                    };\n                };\n            };\n        ;\n            b = c = null;\n            if (window.JSBNG__opera) {\n                _.sc.JSBNG__opera = !0;\n                _.tc.JSBNG__opera = !0;\n                var d = window.JSBNG__opera.version;\n                ((d ? _.uc = _.vc = (((0, _.Va)(d) ? d() : d)) : c = b = /Opera[\\/\\s](\\S+)/));\n            }\n             else ((((0 <= a.indexOf(\"MSIE\"))) ? (_.sc.Hc = !0, _.tc.Hc = !0, c = b = /MSIE\\s+([^\\);]+)(\\)|;)/) : ((((0 <= a.indexOf(\"WebKit\"))) ? (_.sc.Yr = !0, c = /Version\\/(\\S+)/, ((((0 <= a.indexOf(\"Silk-Accelerated\"))) ? (_.tc.Fq = !0, _.tc.bF = !0, b = c) : ((((((0 <= a.indexOf(\"Android\"))) && ((0 > a.indexOf(\"Mobile\"))))) ? (_.tc.Fq = !0, ((((0 <= a.indexOf(\"Chrome\"))) && (_.tc.WJ = !0))), b = c) : ((((((0 <= a.indexOf(\"Android\"))) && ((0 <= a.indexOf(\"Mobile\"))))) ? (_.tc.Eq = !0, ((((0 <= a.indexOf(\"Chrome\"))) && (_.tc.gB = !0))), b = c) : ((((0 <= a.indexOf(\"Chrome\"))) ? (_.tc.kw = !0, b = /Chrome\\/(\\S+)/) : ((((0 <= a.indexOf(\"Safari\"))) && (_.tc.Fz = !0, b = c))))))))))), ((((0 <= a.indexOf(\"iPad\"))) ? (_.tc.Oq = !0, ((_.tc.Fz || (_.tc.Fz = !0, b = c)))) : ((((0 <= a.indexOf(\"iPhone\"))) && (_.tc.xt = !0, ((_.tc.Fz || (_.tc.Fz = !0, b = c)))))))), c = /WebKit\\/(\\S+)/) : ((((0 <= a.indexOf(\"Gecko\"))) && (_.sc.vx = !0, ((((0 <= a.indexOf(\"Firefox\"))) && (_.tc.qw = !0, b = /Firefox\\/(\\S+)/))), c = /rv\\:([^\\);]+)(\\)|;)/)))))));\n        ;\n        ;\n            ((c && (_.vc = (((c = c.exec(a)) ? c[1] : \"\")))));\n            ((b && (_.uc = (((c = b.exec(a)) ? c[1] : \"\")), ((((((_.tc.Hc && (a = ((window.JSBNG__document ? window.JSBNG__document.documentMode : void 0))))) && ((a > (0, window.parseFloat)(_.uc))))) && (_.uc = a.toFixed(1).toString()))))));\n            (0, _.za)(\"google.browser.engine.IE\", _.sc.Hc, void 0);\n            (0, _.za)(\"google.browser.engine.GECKO\", _.sc.vx, void 0);\n            (0, _.za)(\"google.browser.engine.WEBKIT\", _.sc.Yr, void 0);\n            (0, _.za)(\"google.browser.engine.OPERA\", _.sc.JSBNG__opera, void 0);\n            (0, _.za)(\"google.browser.engine.version\", _.vc, void 0);\n            (0, _.za)(\"google.browser.product.IE\", _.tc.Hc, void 0);\n            (0, _.za)(\"google.browser.product.FIREFOX\", _.tc.qw, void 0);\n            (0, _.za)(\"google.browser.product.SAFARI\", _.tc.Fz, void 0);\n            (0, _.za)(\"google.browser.product.IPAD\", _.tc.Oq, void 0);\n            (0, _.za)(\"google.browser.product.IPHONE\", _.tc.xt, void 0);\n            (0, _.za)(\"google.browser.product.CHROME\", _.tc.kw, void 0);\n            (0, _.za)(\"google.browser.product.ANDROID_TABLET\", _.tc.Fq, void 0);\n            (0, _.za)(\"google.browser.product.ANDROID_MOBILE\", _.tc.Eq, void 0);\n            (0, _.za)(\"google.browser.product.KINDLE_FIRE\", _.tc.bF, void 0);\n            (0, _.za)(\"google.browser.product.OPERA\", _.tc.JSBNG__opera, void 0);\n            (0, _.za)(\"google.browser.product.version\", _.uc, void 0);\n        };\n        _.wc = function(a, b) {\n            for (var c = 0, d = a.replace(/^\\s+|\\s+$/g, \"\").split(\".\"), e = b.replace(/^\\s+|\\s+$/g, \"\").split(\".\"), f = Math.max(d.length, e.length), g = 0; ((((0 == c)) && ((g < f)))); g++) {\n                var h = ((d[g] || \"\")), k = ((e[g] || \"\")), l = RegExp(\"(\\\\d*)(\\\\D*)\", \"g\"), n = RegExp(\"(\\\\d*)(\\\\D*)\", \"g\");\n                do {\n                    var p = ((l.exec(h) || [\"\",\"\",\"\",])), m = ((n.exec(k) || [\"\",\"\",\"\",]));\n                    if (((((0 == p[0].length)) && ((0 == m[0].length))))) {\n                        break;\n                    }\n                ;\n                ;\n                    c = ((((((((((((0 == p[1].length)) ? 0 : (0, window.parseInt)(p[1], 10))) < ((((0 == m[1].length)) ? 0 : (0, window.parseInt)(m[1], 10))))) ? -1 : ((((((((0 == p[1].length)) ? 0 : (0, window.parseInt)(p[1], 10))) > ((((0 == m[1].length)) ? 0 : (0, window.parseInt)(m[1], 10))))) ? 1 : 0)))) || ((((((0 == p[2].length)) < ((0 == m[2].length)))) ? -1 : ((((((0 == p[2].length)) > ((0 == m[2].length)))) ? 1 : 0)))))) || ((((p[2] < m[2])) ? -1 : ((((p[2] > m[2])) ? 1 : 0))))));\n                } while (((0 == c)));\n            };\n        ;\n            return c;\n        };\n        _.xc = function(a) {\n            return ((0 <= (0, _.wc)(_.vc, a)));\n        };\n        _.yc = function(a) {\n            return ((0 <= (0, _.wc)(_.uc, a)));\n        };\n        _.zc = function(a) {\n            var b = ((((0 == a)) || ((2 == a))));\n            a = ((((((0 == a)) || ((1 == a)))) ? \"Height\" : \"Width\"));\n            if (((_.sc.Yr && ((((_.tc.Fq || _.tc.Eq)) || _.tc.bF))))) {\n                if (_.tc.bF) {\n                    var b = window.JSBNG__outerWidth, c = window.JSBNG__screen.width, d = window.JSBNG__screen.height, e = window.JSBNG__devicePixelRatio;\n                    ((((((0 < e)) && ((e < Number.MAX_VALUE)))) || (e = 1)));\n                    ((((null == Ac)) && (Ac = new _.oc, Ac.set(600, 1024), Ac.set(1024, 600), Ac.set(800, 1200), Ac.set(1200, 800))));\n                    for (var f = 0, g = Ac.vw(), h = 0; ((h < g.length)); ++h) {\n                        var k = (0, window.parseInt)(g[h], 10);\n                        if (((((b >= ((k - 5)))) && ((b <= ((k + 5))))))) {\n                            f = ((((\"Width\" == a)) ? k : (0, window.parseInt)(Ac.get(k), 10)));\n                            break;\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    ((((0 == f)) && (f = ((((\"Width\" == a)) ? c : d)))));\n                    return ((f / e));\n                }\n            ;\n            ;\n                if (((\"Width\" == a))) {\n                    return window.JSBNG__document.documentElement.offsetWidth;\n                }\n            ;\n            ;\n                a = ((window.JSBNG__screen.height / window.JSBNG__screen.width));\n                ((((((0 < a)) && ((a < Number.MAX_VALUE)))) || (a = 1)));\n                b = ((window.JSBNG__outerHeight / window.JSBNG__outerWidth));\n                if (((((((1 < b)) && ((1 > a)))) || ((((1 > b)) && ((1 < a))))))) {\n                    a = ((1 / a));\n                }\n            ;\n            ;\n                return Math.round(((window.JSBNG__document.documentElement.offsetWidth * a)));\n            }\n        ;\n        ;\n            if (b) {\n                if (window[((\"JSBNG__inner\" + a))]) {\n                    return window[((\"JSBNG__inner\" + a))];\n                }\n            ;\n            ;\n                if (((window.JSBNG__document.documentElement && window.JSBNG__document.documentElement[((\"offset\" + a))]))) {\n                    return window.JSBNG__document.documentElement[((\"offset\" + a))];\n                }\n            ;\n            ;\n            }\n             else return ((((\"CSS1Compat\" == window.JSBNG__document.compatMode)) ? window.JSBNG__document.documentElement : window.JSBNG__document.body))[((\"client\" + a))]\n        ;\n            return 0;\n        };\n        var Bc = function() {\n            return ((_.Ca.JSBNG__navigator ? _.Ca.JSBNG__navigator.userAgent : null));\n        };\n        var Cc = function() {\n            return _.Ca.JSBNG__navigator;\n        };\n        var Dc = function() {\n            var a = _.Ca.JSBNG__document;\n            return ((a ? a.documentMode : void 0));\n        };\n        _.Ec = function(a) {\n            var b;\n            if (!(b = Gc[a])) {\n                b = 0;\n                for (var c = (0, _.pb)(String(Hc)).split(\".\"), d = (0, _.pb)(String(a)).split(\".\"), e = Math.max(c.length, d.length), f = 0; ((((0 == b)) && ((f < e)))); f++) {\n                    var g = ((c[f] || \"\")), h = ((d[f] || \"\")), k = RegExp(\"(\\\\d*)(\\\\D*)\", \"g\"), l = RegExp(\"(\\\\d*)(\\\\D*)\", \"g\");\n                    do {\n                        var n = ((k.exec(g) || [\"\",\"\",\"\",])), p = ((l.exec(h) || [\"\",\"\",\"\",]));\n                        if (((((0 == n[0].length)) && ((0 == p[0].length))))) {\n                            break;\n                        }\n                    ;\n                    ;\n                        b = ((((((((((((0 == n[1].length)) ? 0 : (0, window.parseInt)(n[1], 10))) < ((((0 == p[1].length)) ? 0 : (0, window.parseInt)(p[1], 10))))) ? -1 : ((((((((0 == n[1].length)) ? 0 : (0, window.parseInt)(n[1], 10))) > ((((0 == p[1].length)) ? 0 : (0, window.parseInt)(p[1], 10))))) ? 1 : 0)))) || ((((((0 == n[2].length)) < ((0 == p[2].length)))) ? -1 : ((((((0 == n[2].length)) > ((0 == p[2].length)))) ? 1 : 0)))))) || ((((n[2] < p[2])) ? -1 : ((((n[2] > p[2])) ? 1 : 0))))));\n                    } while (((0 == b)));\n                };\n            ;\n                b = Gc[a] = ((0 <= b));\n            }\n        ;\n        ;\n            return b;\n        };\n        _.Ic = function(a) {\n            return ((_.Jc && ((haa >= a))));\n        };\n        _.Kc = function(a) {\n            a = a.className;\n            return (((((0, _.Ra)(a) && a.match(/\\S+/g))) || []));\n        };\n        _.Lc = function(a, b) {\n            var c = (0, _.Kc)(a), d = (0, _.Pb)(arguments, 1), e = ((c.length + d.length));\n            (0, _.Mc)(c, d);\n            d = c.join(\" \");\n            a.className = d;\n            return ((c.length == e));\n        };\n        _.Nc = function(a, b) {\n            var c = (0, _.Kc)(a), d = (0, _.Pb)(arguments, 1), e = (0, _.Oc)(c, d), f = e.join(\" \");\n            a.className = f;\n            return ((e.length == ((c.length - d.length))));\n        };\n        _.Mc = function(a, b) {\n            for (var c = 0; ((c < b.length)); c++) {\n                (((0, _.Fb)(a, b[c]) || a.push(b[c])));\n            ;\n            };\n        ;\n        };\n        _.Oc = function(a, b) {\n            return (0, _.Pc)(a, function(a) {\n                return !(0, _.Fb)(b, a);\n            });\n        };\n        _.Qc = function(a, b, c) {\n            return Math.min(Math.max(a, b), c);\n        };\n        _.Rc = function(a, b) {\n            this.x = (((0, _.Ma)(a) ? a : 0));\n            this.y = (((0, _.Ma)(b) ? b : 0));\n        };\n        _.Sc = function(a, b) {\n            this.width = a;\n            this.height = b;\n        };\n        _.Tc = function(a, b) {\n            return ((((a == b)) ? !0 : ((((a && b)) ? ((((a.width == b.width)) && ((a.height == b.height)))) : !1))));\n        };\n        _.Uc = function(a) {\n            return ((a ? new _.Vc((0, _.Wc)(a)) : ((Xc || (Xc = new _.Vc)))));\n        };\n        _.v = function(a) {\n            return (((0, _.Ra)(a) ? window.JSBNG__document.getElementById(a) : a));\n        };\n        _.Yc = function(a, b, c) {\n            return (0, _.Zc)(window.JSBNG__document, a, b, c);\n        };\n        _.$c = function(a, b) {\n            var c = ((b || window.JSBNG__document));\n            return ((((c.querySelectorAll && c.querySelector)) ? c.querySelectorAll(((\".\" + a))) : ((c.getElementsByClassName ? c.getElementsByClassName(a) : (0, _.Zc)(window.JSBNG__document, \"*\", a, b)))));\n        };\n        _.ad = function(a, b) {\n            var c = ((b || window.JSBNG__document)), d = null;\n            return (((d = ((((c.querySelectorAll && c.querySelector)) ? c.querySelector(((\".\" + a))) : (0, _.$c)(a, b)[0]))) || null));\n        };\n        _.Zc = function(a, b, c, d) {\n            a = ((d || a));\n            b = ((((b && ((\"*\" != b)))) ? b.toUpperCase() : \"\"));\n            if (((((a.querySelectorAll && a.querySelector)) && ((b || c))))) {\n                return a.querySelectorAll(((b + ((c ? ((\".\" + c)) : \"\")))));\n            }\n        ;\n        ;\n            if (((c && a.getElementsByClassName))) {\n                a = a.getElementsByClassName(c);\n                if (b) {\n                    d = {\n                    };\n                    for (var e = 0, f = 0, g; g = a[f]; f++) {\n                        ((((b == g.nodeName)) && (d[e++] = g)));\n                    ;\n                    };\n                ;\n                    d.length = e;\n                    return d;\n                }\n            ;\n            ;\n                return a;\n            }\n        ;\n        ;\n            a = a.getElementsByTagName(((b || \"*\")));\n            if (c) {\n                d = {\n                };\n                for (f = e = 0; g = a[f]; f++) {\n                    b = g.className, ((((((\"function\" == typeof b.split)) && (0, _.Fb)(b.split(/\\s+/), c))) && (d[e++] = g)));\n                ;\n                };\n            ;\n                d.length = e;\n                return d;\n            }\n        ;\n        ;\n            return a;\n        };\n        _.bd = function(a, b) {\n            (0, _.$b)(b, function(b, d) {\n                ((((\"style\" == d)) ? a.style.cssText = b : ((((\"class\" == d)) ? a.className = b : ((((\"for\" == d)) ? a.htmlFor = b : ((((d in cd)) ? a.setAttribute(cd[d], b) : (((((0, _.gb)(d, \"aria-\") || (0, _.gb)(d, \"data-\"))) ? a.setAttribute(d, b) : a[d] = b))))))))));\n            });\n        };\n        _.dd = function(a) {\n            return ed(((a || window)));\n        };\n        var ed = function(a) {\n            a = a.JSBNG__document;\n            a = ((fd(a) ? a.documentElement : a.body));\n            return new _.Sc(a.clientWidth, a.clientHeight);\n        };\n        _.gd = function(a) {\n            var b = a.JSBNG__document, c = 0;\n            if (b) {\n                a = ed(a).height;\n                var c = b.body, d = b.documentElement;\n                if (((fd(b) && d.scrollHeight))) c = ((((d.scrollHeight != a)) ? d.scrollHeight : d.offsetHeight));\n                 else {\n                    var b = d.scrollHeight, e = d.offsetHeight;\n                    ((((d.clientHeight != e)) && (b = c.scrollHeight, e = c.offsetHeight)));\n                    c = ((((b > a)) ? ((((b > e)) ? b : e)) : ((((b < e)) ? b : e))));\n                }\n            ;\n            ;\n            }\n        ;\n        ;\n            return c;\n        };\n        _.hd = function(a) {\n            var b = (0, _.id)(a);\n            a = ((a.parentWindow || a.defaultView));\n            return ((((((_.Jc && (0, _.Ec)(\"10\"))) && ((a.JSBNG__pageYOffset != b.scrollTop)))) ? new _.Rc(b.scrollLeft, b.scrollTop) : new _.Rc(((a.JSBNG__pageXOffset || b.scrollLeft)), ((a.JSBNG__pageYOffset || b.scrollTop)))));\n        };\n        _.id = function(a) {\n            return ((((!_.jd && fd(a))) ? a.documentElement : a.body));\n        };\n        _.kd = function(a) {\n            return ((a ? ((a.parentWindow || a.defaultView)) : window));\n        };\n        _.ld = function(a, b, c) {\n            return md(window.JSBNG__document, arguments);\n        };\n        var md = function(a, b) {\n            var c = b[0], d = b[1];\n            if (((((!iaa && d)) && ((d.JSBNG__name || d.type))))) {\n                c = [\"\\u003C\",c,];\n                ((d.JSBNG__name && c.push(\" name=\\\"\", (0, _.qb)(d.JSBNG__name), \"\\\"\")));\n                if (d.type) {\n                    c.push(\" type=\\\"\", (0, _.qb)(d.type), \"\\\"\");\n                    var e = {\n                    };\n                    (0, _.lc)(e, d);\n                    delete e.type;\n                    d = e;\n                }\n            ;\n            ;\n                c.push(\"\\u003E\");\n                c = c.join(\"\");\n            }\n        ;\n        ;\n            c = a.createElement(c);\n            ((d && (((0, _.Ra)(d) ? c.className = d : (((0, _.Oa)(d) ? _.Lc.apply(null, [c,].concat(d)) : (0, _.bd)(c, d)))))));\n            ((((2 < b.length)) && nd(a, c, b, 2)));\n            return c;\n        };\n        var nd = function(a, b, c, d) {\n            function e(c) {\n                ((c && b.appendChild((((0, _.Ra)(c) ? a.createTextNode(c) : c)))));\n            };\n        ;\n            for (; ((d < c.length)); d++) {\n                var f = c[d];\n                ((((!(0, _.Qa)(f) || (((0, _.Wa)(f) && ((0 < f.nodeType)))))) ? e(f) : (0, _.Zb)(((jaa(f) ? (0, _.Mb)(f) : f)), e)));\n            };\n        ;\n        };\n        _.od = function(a) {\n            return window.JSBNG__document.createElement(a);\n        };\n        _.pd = function(a) {\n            return window.JSBNG__document.createTextNode(String(a));\n        };\n        _.qd = function(a, b, c, d) {\n            for (var e = [\"\\u003Ctr\\u003E\",], f = 0; ((f < c)); f++) {\n                e.push(((d ? \"\\u003Ctd\\u003E&nbsp;\\u003C/td\\u003E\" : \"\\u003Ctd\\u003E\\u003C/td\\u003E\")));\n            ;\n            };\n        ;\n            e.push(\"\\u003C/tr\\u003E\");\n            e = e.join(\"\");\n            c = [\"\\u003Ctable\\u003E\",];\n            for (f = 0; ((f < b)); f++) {\n                c.push(e);\n            ;\n            };\n        ;\n            c.push(\"\\u003C/table\\u003E\");\n            a = a.createElement(\"DIV\");\n            a.innerHTML = c.join(\"\");\n            return a.removeChild(a.firstChild);\n        };\n        _.rd = function(a, b) {\n            var c = a.createElement(\"div\");\n            ((_.Jc ? (c.innerHTML = ((\"\\u003Cbr\\u003E\" + b)), c.removeChild(c.firstChild)) : c.innerHTML = b));\n            if (((1 == c.childNodes.length))) {\n                return c.removeChild(c.firstChild);\n            }\n        ;\n        ;\n            for (var d = a.createDocumentFragment(); c.firstChild; ) {\n                d.appendChild(c.firstChild);\n            ;\n            };\n        ;\n            return d;\n        };\n        var fd = function(a) {\n            return ((\"CSS1Compat\" == a.compatMode));\n        };\n        _.sd = function(a, b) {\n            a.appendChild(b);\n        };\n        _.td = function(a, b) {\n            nd((0, _.Wc)(a), a, arguments, 1);\n        };\n        _.ud = function(a) {\n            for (var b; b = a.firstChild; ) {\n                a.removeChild(b);\n            ;\n            };\n        ;\n        };\n        _.vd = function(a, b) {\n            ((b.parentNode && b.parentNode.insertBefore(a, b)));\n        };\n        _.wd = function(a, b) {\n            ((b.parentNode && b.parentNode.insertBefore(a, b.nextSibling)));\n        };\n        _.xd = function(a, b, c) {\n            a.insertBefore(b, ((a.childNodes[c] || null)));\n        };\n        _.yd = function(a) {\n            return ((((a && a.parentNode)) ? a.parentNode.removeChild(a) : null));\n        };\n        _.zd = function(a, b) {\n            var c = b.parentNode;\n            ((c && c.replaceChild(a, b)));\n        };\n        _.Ad = function(a) {\n            return ((((kaa && ((void 0 != a.children)))) ? a.children : (0, _.Pc)(a.childNodes, function(a) {\n                return ((1 == a.nodeType));\n            })));\n        };\n        _.Bd = function(a) {\n            return ((((void 0 != a.firstElementChild)) ? a.firstElementChild : (0, _.Cd)(a.firstChild, !0)));\n        };\n        _.Dd = function(a) {\n            return ((((void 0 != a.nextElementSibling)) ? a.nextElementSibling : (0, _.Cd)(a.nextSibling, !0)));\n        };\n        _.Ed = function(a) {\n            return ((((void 0 != a.previousElementSibling)) ? a.previousElementSibling : (0, _.Cd)(a.previousSibling, !1)));\n        };\n        _.Cd = function(a, b) {\n            for (; ((a && ((1 != a.nodeType)))); ) {\n                a = ((b ? a.nextSibling : a.previousSibling));\n            ;\n            };\n        ;\n            return a;\n        };\n        _.Fd = function(a) {\n            return (((0, _.Wa)(a) && ((1 == a.nodeType))));\n        };\n        _.Gd = function(a) {\n            if (((laa && !((((((((_.Jc && (0, _.Ec)(\"9\"))) && !(0, _.Ec)(\"10\"))) && _.Ca.JSBNG__SVGElement)) && ((a instanceof _.Ca.JSBNG__SVGElement))))))) {\n                return a.parentElement;\n            }\n        ;\n        ;\n            a = a.parentNode;\n            return (((0, _.Fd)(a) ? a : null));\n        };\n        _.Hd = function(a, b) {\n            if (((a.contains && ((1 == b.nodeType))))) {\n                return ((((a == b)) || a.contains(b)));\n            }\n        ;\n        ;\n            if (((\"undefined\" != typeof a.compareDocumentPosition))) {\n                return ((((a == b)) || Boolean(((a.compareDocumentPosition(b) & 16)))));\n            }\n        ;\n        ;\n            for (; ((b && ((a != b)))); ) {\n                b = b.parentNode;\n            ;\n            };\n        ;\n            return ((b == a));\n        };\n        _.Wc = function(a) {\n            return ((((9 == a.nodeType)) ? a : ((a.ownerDocument || a.JSBNG__document))));\n        };\n        _.Id = function(a, b) {\n            if (((\"textContent\" in a))) {\n                a.textContent = b;\n            }\n             else {\n                if (((a.firstChild && ((3 == a.firstChild.nodeType))))) {\n                    for (; ((a.lastChild != a.firstChild)); ) {\n                        a.removeChild(a.lastChild);\n                    ;\n                    };\n                ;\n                    a.firstChild.data = b;\n                }\n                 else (0, _.ud)(a), a.appendChild((0, _.Wc)(a).createTextNode(String(b)));\n            ;\n            }\n        ;\n        ;\n        };\n        _.Jd = function(a, b, c, d) {\n            if (((null != a))) {\n                for (a = a.firstChild; a; ) {\n                    if (((((b(a) && (c.push(a), d))) || (0, _.Jd)(a, b, c, d)))) {\n                        return !0;\n                    }\n                ;\n                ;\n                    a = a.nextSibling;\n                };\n            }\n        ;\n        ;\n            return !1;\n        };\n        _.Kd = function(a) {\n            if (((Ld && ((\"innerText\" in a))))) a = a.innerText.replace(/(\\r\\n|\\r|\\n)/g, \"\\u000a\");\n             else {\n                var b = [];\n                (0, _.Md)(a, b, !0);\n                a = b.join(\"\");\n            }\n        ;\n        ;\n            a = a.replace(/ \\xAD /g, \" \").replace(/\\xAD/g, \"\");\n            a = a.replace(/\\u200B/g, \"\");\n            ((Ld || (a = a.replace(/ +/g, \" \"))));\n            ((((\" \" != a)) && (a = a.replace(/^\\s*/, \"\"))));\n            return a;\n        };\n        _.Md = function(a, b, c) {\n            if (!((a.nodeName in maa))) {\n                if (((3 == a.nodeType))) {\n                    ((c ? b.push(String(a.nodeValue).replace(/(\\r\\n|\\r|\\n)/g, \"\")) : b.push(a.nodeValue)));\n                }\n                 else {\n                    if (((a.nodeName in Nd))) {\n                        b.push(Nd[a.nodeName]);\n                    }\n                     else {\n                        for (a = a.firstChild; a; ) {\n                            (0, _.Md)(a, b, c), a = a.nextSibling;\n                        ;\n                        };\n                    }\n                ;\n                }\n            ;\n            }\n        ;\n        ;\n        };\n        var jaa = function(a) {\n            if (((a && ((\"number\" == typeof a.length))))) {\n                if ((0, _.Wa)(a)) {\n                    return ((((\"function\" == typeof a.item)) || ((\"string\" == typeof a.item))));\n                }\n            ;\n            ;\n                if ((0, _.Va)(a)) {\n                    return ((\"function\" == typeof a.item));\n                }\n            ;\n            ;\n            }\n        ;\n        ;\n            return !1;\n        };\n        _.Od = function(a, b, c) {\n            if (((!b && !c))) {\n                return null;\n            }\n        ;\n        ;\n            var d = ((b ? b.toUpperCase() : null));\n            return (0, _.Pd)(a, function(a) {\n                return ((((!d || ((a.nodeName == d)))) && ((!c || (0, _.Fb)((0, _.Kc)(a), c)))));\n            }, !0);\n        };\n        _.Qd = function(a, b) {\n            return (0, _.Od)(a, null, b);\n        };\n        _.Pd = function(a, b, c, d) {\n            ((c || (a = a.parentNode)));\n            c = ((null == d));\n            for (var e = 0; ((a && ((c || ((e <= d)))))); ) {\n                if (b(a)) {\n                    return a;\n                }\n            ;\n            ;\n                a = a.parentNode;\n                e++;\n            };\n        ;\n            return null;\n        };\n        _.Rd = function(a) {\n            try {\n                return ((a && a.activeElement));\n            } catch (b) {\n            \n            };\n        ;\n            return null;\n        };\n        _.Vc = function(a) {\n            this.A = ((((a || _.Ca.JSBNG__document)) || window.JSBNG__document));\n        };\n        _.Sd = function(a, b) {\n            return a.A.createTextNode(String(b));\n        };\n        _.Td = function(a) {\n            return fd(a.A);\n        };\n        _.Ud = function(a) {\n            return (0, _.hd)(a.A);\n        };\n        _.Vd = function() {\n            return ((_.jd ? \"Webkit\" : ((_.Wd ? \"Moz\" : ((_.Jc ? \"ms\" : ((_.Xd ? \"O\" : null))))))));\n        };\n        _.Yd = function() {\n            return ((_.jd ? \"-webkit\" : ((_.Wd ? \"-moz\" : ((_.Jc ? \"-ms\" : ((_.Xd ? \"-o\" : null))))))));\n        };\n        _.Zd = function(a, b, c, d) {\n            this.JSBNG__top = a;\n            this.right = b;\n            this.bottom = c;\n            this.left = d;\n        };\n        _.$d = function(a, b, c, d) {\n            this.left = a;\n            this.JSBNG__top = b;\n            this.width = c;\n            this.height = d;\n        };\n        var naa = function(a, b) {\n            var c = ((((b.x < a.left)) ? ((a.left - b.x)) : Math.max(((b.x - ((a.left + a.width)))), 0))), d = ((((b.y < a.JSBNG__top)) ? ((a.JSBNG__top - b.y)) : Math.max(((b.y - ((a.JSBNG__top + a.height)))), 0)));\n            return ((((c * c)) + ((d * d))));\n        };\n        _.ae = function(a, b, c) {\n            (((0, _.Ra)(b) ? be(a, c, b) : (0, _.$b)(b, (0, _.ab)(be, a))));\n        };\n        var be = function(a, b, c) {\n            (((c = ce(a, c)) && (a.style[c] = b)));\n        };\n        var ce = function(a, b) {\n            var c = (0, _.yb)(b);\n            if (((void 0 === a.style[c]))) {\n                var d = (((0, _.Vd)() + eaa(b)));\n                if (((void 0 !== a.style[d]))) {\n                    return d;\n                }\n            ;\n            ;\n            }\n        ;\n        ;\n            return c;\n        };\n        _.de = function(a, b) {\n            var c = a.style[(0, _.yb)(b)];\n            return ((((\"undefined\" !== typeof c)) ? c : ((a.style[ce(a, b)] || \"\"))));\n        };\n        _.ee = function(a, b) {\n            var c = (0, _.Wc)(a);\n            return ((((((c.defaultView && c.defaultView.JSBNG__getComputedStyle)) && (c = c.defaultView.JSBNG__getComputedStyle(a, null)))) ? ((((c[b] || c.getPropertyValue(b))) || \"\")) : \"\"));\n        };\n        _.fe = function(a, b) {\n            return (((((0, _.ee)(a, b) || ((a.currentStyle ? a.currentStyle[b] : null)))) || ((a.style && a.style[b]))));\n        };\n        _.ge = function(a) {\n            return (0, _.fe)(a, \"position\");\n        };\n        _.he = function(a, b, c) {\n            var d, e = ((((_.Wd && ((_.ie || ke)))) && (0, _.Ec)(\"1.9\")));\n            ((((b instanceof _.Rc)) ? (d = b.x, b = b.y) : (d = b, b = c)));\n            a.style.left = le(d, e);\n            a.style.JSBNG__top = le(b, e);\n        };\n        _.me = function(a) {\n            return new _.Rc(a.offsetLeft, a.offsetTop);\n        };\n        _.ne = function(a) {\n            a = ((a ? (0, _.Wc)(a) : window.JSBNG__document));\n            return ((((((!_.Jc || (0, _.Ic)(9))) || (0, _.Td)((0, _.Uc)(a)))) ? a.documentElement : a.body));\n        };\n        var oe = function(a) {\n            var b;\n            try {\n                b = a.getBoundingClientRect();\n            } catch (c) {\n                return {\n                    left: 0,\n                    JSBNG__top: 0,\n                    right: 0,\n                    bottom: 0\n                };\n            };\n        ;\n            ((_.Jc && (a = a.ownerDocument, b.left -= ((a.documentElement.clientLeft + a.body.clientLeft)), b.JSBNG__top -= ((a.documentElement.clientTop + a.body.clientTop)))));\n            return b;\n        };\n        _.pe = function(a) {\n            if (((_.Jc && !(0, _.Ic)(8)))) {\n                return a.offsetParent;\n            }\n        ;\n        ;\n            var b = (0, _.Wc)(a), c = (0, _.fe)(a, \"position\"), d = ((((\"fixed\" == c)) || ((\"absolute\" == c))));\n            for (a = a.parentNode; ((a && ((a != b)))); a = a.parentNode) {\n                if (c = (0, _.fe)(a, \"position\"), d = ((((((d && ((\"static\" == c)))) && ((a != b.documentElement)))) && ((a != b.body)))), ((!d && ((((((((((a.scrollWidth > a.clientWidth)) || ((a.scrollHeight > a.clientHeight)))) || ((\"fixed\" == c)))) || ((\"absolute\" == c)))) || ((\"relative\" == c))))))) {\n                    return a;\n                }\n            ;\n            ;\n            };\n        ;\n            return null;\n        };\n        _.qe = function(a) {\n            var b, c = (0, _.Wc)(a), d = (0, _.fe)(a, \"position\"), e = ((((((((((_.Wd && c.getBoxObjectFor)) && !a.getBoundingClientRect)) && ((\"absolute\" == d)))) && (b = c.getBoxObjectFor(a)))) && ((((0 > b.JSBNG__screenX)) || ((0 > b.JSBNG__screenY)))))), f = new _.Rc(0, 0), g = (0, _.ne)(c);\n            if (((a == g))) {\n                return f;\n            }\n        ;\n        ;\n            if (a.getBoundingClientRect) {\n                b = oe(a), a = (0, _.Ud)((0, _.Uc)(c)), f.x = ((b.left + a.x)), f.y = ((b.JSBNG__top + a.y));\n            }\n             else {\n                if (((c.getBoxObjectFor && !e))) b = c.getBoxObjectFor(a), a = c.getBoxObjectFor(g), f.x = ((b.JSBNG__screenX - a.JSBNG__screenX)), f.y = ((b.JSBNG__screenY - a.JSBNG__screenY));\n                 else {\n                    b = a;\n                    do {\n                        f.x += b.offsetLeft;\n                        f.y += b.offsetTop;\n                        ((((b != a)) && (f.x += ((b.clientLeft || 0)), f.y += ((b.clientTop || 0)))));\n                        if (((_.jd && ((\"fixed\" == (0, _.ge)(b)))))) {\n                            f.x += c.body.scrollLeft;\n                            f.y += c.body.scrollTop;\n                            break;\n                        }\n                    ;\n                    ;\n                        b = b.offsetParent;\n                    } while (((b && ((b != a)))));\n                    if (((_.Xd || ((_.jd && ((\"absolute\" == d))))))) {\n                        f.y -= c.body.offsetTop;\n                    }\n                ;\n                ;\n                    for (b = a; (((((b = (0, _.pe)(b)) && ((b != c.body)))) && ((b != g)))); ) {\n                        f.x -= b.scrollLeft, ((((_.Xd && ((\"TR\" == b.tagName)))) || (f.y -= b.scrollTop)));\n                    ;\n                    };\n                ;\n                }\n            ;\n            }\n        ;\n        ;\n            return f;\n        };\n        _.re = function(a) {\n            return (0, _.qe)(a).x;\n        };\n        _.se = function(a) {\n            return (0, _.qe)(a).y;\n        };\n        _.te = function(a) {\n            var b;\n            if (a.getBoundingClientRect) b = oe(a), b = new _.Rc(b.left, b.JSBNG__top);\n             else {\n                b = (0, _.Ud)((0, _.Uc)(a));\n                var c = (0, _.qe)(a);\n                b = new _.Rc(((c.x - b.x)), ((c.y - b.y)));\n            }\n        ;\n        ;\n            ((((_.Wd && !(0, _.Ec)(12))) ? (a = (0, _.ue)(a), a = new _.Rc(((b.x + a.x)), ((b.y + a.y)))) : a = b));\n            return a;\n        };\n        _.ve = function(a) {\n            if (((1 == a.nodeType))) {\n                return (0, _.te)(a);\n            }\n        ;\n        ;\n            var b = (0, _.Va)(a.mW), c = a;\n            ((a.targetTouches ? c = a.targetTouches[0] : ((((b && a.tl.targetTouches)) && (c = a.tl.targetTouches[0])))));\n            return new _.Rc(c.clientX, c.clientY);\n        };\n        _.we = function(a, b, c) {\n            if (((b instanceof _.Sc))) {\n                c = b.height, b = b.width;\n            }\n             else {\n                if (((void 0 == c))) {\n                    throw Error(\"missing height argument\");\n                }\n            ;\n            }\n        ;\n        ;\n            (0, _.xe)(a, b);\n            (0, _.ye)(a, c);\n        };\n        var le = function(a, b) {\n            ((((\"number\" == typeof a)) && (a = ((((b ? Math.round(a) : a)) + \"px\")))));\n            return a;\n        };\n        _.ye = function(a, b) {\n            a.style.height = le(b, !0);\n        };\n        _.xe = function(a, b) {\n            a.style.width = le(b, !0);\n        };\n        _.ze = function(a) {\n            var b;\n            var c = oaa;\n            if (((\"none\" != (0, _.fe)(a, \"display\")))) b = c(a);\n             else {\n                b = a.style;\n                var d = b.display, e = b.visibility, f = b.position;\n                b.visibility = \"hidden\";\n                b.position = \"absolute\";\n                b.display = \"inline\";\n                a = c(a);\n                b.display = d;\n                b.position = f;\n                b.visibility = e;\n                b = a;\n            }\n        ;\n        ;\n            return b;\n        };\n        var oaa = function(a) {\n            var b = a.offsetWidth, c = a.offsetHeight, d = ((((_.jd && !b)) && !c));\n            return (((((((0, _.Ma)(b) && !d)) || !a.getBoundingClientRect)) ? new _.Sc(b, c) : (a = oe(a), new _.Sc(((a.right - a.left)), ((a.bottom - a.JSBNG__top))))));\n        };\n        _.Ae = function(a) {\n            var b = (0, _.qe)(a);\n            a = (0, _.ze)(a);\n            return new _.$d(b.x, b.y, a.width, a.height);\n        };\n        _.Be = function(a, b) {\n            var c = a.style;\n            ((((\"opacity\" in c)) ? c.opacity = b : ((((\"MozOpacity\" in c)) ? c.MozOpacity = b : ((((\"filter\" in c)) && (c.filter = ((((\"\" === b)) ? \"\" : ((((\"alpha(opacity=\" + ((100 * b)))) + \")\")))))))))));\n        };\n        _.Ce = function(a, b) {\n            a.style.display = ((b ? \"\" : \"none\"));\n        };\n        _.De = function(a) {\n            return ((\"none\" != a.style.display));\n        };\n        _.Ee = function(a, b) {\n            var c = (0, _.Uc)(b), d = null;\n            if (_.Jc) c = d = c.A.createStyleSheet(), ((_.Jc ? c.cssText = a : c.innerHTML = a));\n             else {\n                var e = (0, _.Zc)(c.A, \"head\", void 0, void 0)[0];\n                ((e || (d = (0, _.Zc)(c.A, \"body\", void 0, void 0)[0], e = c.Qe(\"head\"), d.parentNode.insertBefore(e, d))));\n                var f = d = c.Qe(\"style\");\n                ((_.Jc ? f.cssText = a : f.innerHTML = a));\n                c.appendChild(e, d);\n            }\n        ;\n        ;\n            return d;\n        };\n        _.Fe = function(a) {\n            return ((\"rtl\" == (0, _.fe)(a, \"direction\")));\n        };\n        _.Ge = function(a, b, c) {\n            c = ((c ? null : a.getElementsByTagName(\"*\")));\n            if (He) {\n                if (b = ((b ? \"none\" : \"\")), a.style[He] = b, c) {\n                    a = 0;\n                    for (var d; d = c[a]; a++) {\n                        d.style[He] = b;\n                    ;\n                    };\n                ;\n                }\n            ;\n            ;\n            }\n             else if (((_.Jc || _.Xd))) {\n                if (b = ((b ? \"JSBNG__on\" : \"\")), a.setAttribute(\"unselectable\", b), c) {\n                    for (a = 0; d = c[a]; a++) {\n                        d.setAttribute(\"unselectable\", b);\n                    ;\n                    };\n                }\n            ;\n            }\n            \n        ;\n        ;\n        };\n        _.Ie = function(a, b, c, d) {\n            if (/^\\d+px?$/.test(b)) {\n                return (0, window.parseInt)(b, 10);\n            }\n        ;\n        ;\n            var e = a.style[c], f = a.runtimeStyle[c];\n            a.runtimeStyle[c] = a.currentStyle[c];\n            a.style[c] = b;\n            b = a.style[d];\n            a.style[c] = e;\n            a.runtimeStyle[c] = f;\n            return b;\n        };\n        var Je = function(a, b) {\n            var c = ((a.currentStyle ? a.currentStyle[b] : null));\n            return ((c ? (0, _.Ie)(a, c, \"left\", \"pixelLeft\") : 0));\n        };\n        _.Ke = function(a, b) {\n            if (_.Jc) {\n                var c = Je(a, ((b + \"Left\"))), d = Je(a, ((b + \"Right\"))), e = Je(a, ((b + \"Top\"))), f = Je(a, ((b + \"Bottom\")));\n                return new _.Zd(e, d, f, c);\n            }\n        ;\n        ;\n            c = (0, _.ee)(a, ((b + \"Left\")));\n            d = (0, _.ee)(a, ((b + \"Right\")));\n            e = (0, _.ee)(a, ((b + \"Top\")));\n            f = (0, _.ee)(a, ((b + \"Bottom\")));\n            return new _.Zd((0, window.parseFloat)(e), (0, window.parseFloat)(d), (0, window.parseFloat)(f), (0, window.parseFloat)(c));\n        };\n        _.Le = function(a) {\n            return (0, _.Ke)(a, \"margin\");\n        };\n        _.ue = function(a) {\n            var b;\n            ((_.Jc ? b = \"-ms-transform\" : ((_.jd ? b = \"-webkit-transform\" : ((_.Xd ? b = \"-o-transform\" : ((_.Wd && (b = \"-moz-transform\")))))))));\n            var c;\n            ((b && (c = (0, _.fe)(a, b))));\n            ((c || (c = (0, _.fe)(a, \"transform\"))));\n            return ((c ? (((a = c.match(paa)) ? new _.Rc((0, window.parseFloat)(a[1]), (0, window.parseFloat)(a[2])) : new _.Rc(0, 0))) : new _.Rc(0, 0)));\n        };\n        _.Me = function(a) {\n            return (((0, _.v)(\"xjsc\") || window.JSBNG__document.body)).appendChild(a);\n        };\n        _.Ne = function(a, b) {\n            var c = a.match(Oe), d = window.JSBNG__document.createElement(c[1]);\n            ((c[2] && (d.className = c[2])));\n            ((b && (d.innerHTML = b)));\n            return d;\n        };\n        _.Pe = function(a, b) {\n            for (var c = 1; ((c < arguments.length)); c += 2) {\n                var d = arguments[c], e = arguments[((c + 1))], f = a.style;\n                ((((f && ((d in f)))) ? f[d] = e : ((((d in a)) ? a[d] = e : ((((_.sc.Hc && ((f && ((\"opacity\" == d)))))) && (a.zoom = 1, d = ((f.filter || \"\")).replace(/alpha\\([^)]*\\)/, \"\"), (((0, window.isNaN)((0, window.parseFloat)(e)) || (d += ((((\"alpha(opacity=\" + ((100 * e)))) + \")\"))))), f.filter = d)))))));\n            };\n        ;\n            return a;\n        };\n        _.Qe = function(a, b) {\n            try {\n                var c = a.getAttribute(b);\n                return ((c ? c : \"\"));\n            } catch (d) {\n                return (((c = a.getAttributeNode(b)) ? c.value : \"\"));\n            };\n        ;\n        };\n        _.Re = function(a, b) {\n            var c = (0, _.se)((0, _.v)(a));\n            ((((0 <= c)) && (c += ((b || 0)), window.JSBNG__scrollTo(0, c))));\n        };\n        var qaa = function(a) {\n            return a;\n        };\n        _.Se = function(a) {\n            return ((((((3 - ((2 * a)))) * a)) * a));\n        };\n        _.Te = function(a, b, c) {\n            for (var d = 0, e; e = b[d++]; ) {\n                var f = ((\"string\" == typeof e[2]));\n                ((f ? (e[2] = Ue(e[2]), e[3] = Ue(e[3]), e[5] = \"\") : e[5] = ((((null == e[5])) ? \"px\" : e[5]))));\n                e[4] = ((e[4] || qaa));\n                e[6] = f;\n                (0, _.Pe)(e[0], e[1], ((f ? ((((\"rgb(\" + e[2].join(\",\"))) + \")\")) : ((e[2] + e[5])))));\n            };\n        ;\n            var g = {\n                kB: a,\n                gh: c,\n                SM: (0, _.Ve)(),\n                Nx: b\n            };\n            We.push(g);\n            Xe = ((Xe || window.JSBNG__setInterval(Ye, 15)));\n            return {\n                finish: function() {\n                    ((g.lB || (g.lB = !0, Ye())));\n                }\n            };\n        };\n        var Ye = function() {\n            ++raa;\n            for (var a = 0, b; b = We[a++]; ) {\n                var c = (((0, _.Ve)() - b.SM));\n                if (((((c >= b.kB)) || b.lB))) {\n                    for (var d = 0, e = void 0; e = b.Nx[d++]; ) {\n                        (0, _.Pe)(e[0], e[1], ((e[6] ? ((((\"rgb(\" + e[3].join(\",\"))) + \")\")) : ((e[3] + e[5])))));\n                    ;\n                    };\n                ;\n                    b.lB = !0;\n                    ((b.gh && b.gh()));\n                    b = 0;\n                }\n                 else {\n                    for (d = 0; e = b.Nx[d++]; ) {\n                        var f = e[4](((c / b.kB))), g;\n                        if (e[6]) {\n                            g = Ze(e[2][0], e[3][0], f, !0);\n                            var h = Ze(e[2][1], e[3][1], f, !0), f = Ze(e[2][2], e[3][2], f, !0);\n                            g = ((((\"rgb(\" + [g,h,f,].join())) + \")\"));\n                        }\n                         else g = Ze(e[2], e[3], f, ((\"px\" == e[5])));\n                    ;\n                    ;\n                        (0, _.Pe)(e[0], e[1], ((g + e[5])));\n                    };\n                ;\n                    b = 1;\n                }\n            ;\n            ;\n                ((b || We.splice(--a, 1)));\n            };\n        ;\n            ((We.length || (window.JSBNG__clearInterval(Xe), Xe = 0)));\n        };\n        var Ze = function(a, b, c, d) {\n            a += ((((b - a)) * c));\n            return ((d ? Math.round(a) : a));\n        };\n        var Ue = function(a) {\n            a = a.match(/#(..)(..)(..)/).slice(1);\n            for (var b = 0; ((3 > b)); ++b) {\n                a[b] = (0, window.parseInt)(a[b], 16);\n            ;\n            };\n        ;\n            return a;\n        };\n        _.$e = function(a, b, c, d) {\n            ((a.JSBNG__addEventListener ? a.JSBNG__addEventListener(b, c, !1) : a.JSBNG__attachEvent(((\"JSBNG__on\" + b)), c)));\n            ((((((((((((((a == window)) || ((a == window.JSBNG__document)))) || ((a == window.JSBNG__document.documentElement)))) || ((a == window.JSBNG__document.body)))) && window.google.jsad)) && window.google.jsa)) && window.google.jsa.adc(b, c, !!d)));\n        };\n        _.af = function(a, b, c) {\n            ((a.JSBNG__removeEventListener ? a.JSBNG__removeEventListener(b, c, !1) : a.JSBNG__detachEvent(((\"JSBNG__on\" + b)), c)));\n            ((((((((((((((a == window)) || ((a == window.JSBNG__document)))) || ((a == window.JSBNG__document.documentElement)))) || ((a == window.JSBNG__document.body)))) && window.google.jsad)) && window.google.jsa)) && window.google.jsa.rdc(b, c)));\n        };\n        var bf = function(a) {\n            return ((((\"function\" == typeof a.ys)) ? a.ys() : (((((0, _.Qa)(a) || (0, _.Ra)(a))) ? a.length : (0, _.ac)(a)))));\n        };\n        var cf = function(a) {\n            if (((\"function\" == typeof a.ot))) {\n                return a.ot();\n            }\n        ;\n        ;\n            if ((0, _.Ra)(a)) {\n                return a.split(\"\");\n            }\n        ;\n        ;\n            if ((0, _.Qa)(a)) {\n                for (var b = [], c = a.length, d = 0; ((d < c)); d++) {\n                    b.push(a[d]);\n                ;\n                };\n            ;\n                return b;\n            }\n        ;\n        ;\n            return (0, _.bc)(a);\n        };\n        var df = function(a) {\n            if (((\"function\" == typeof a.vw))) {\n                return a.vw();\n            }\n        ;\n        ;\n            if (((\"function\" != typeof a.ot))) {\n                if ((((0, _.Qa)(a) || (0, _.Ra)(a)))) {\n                    var b = [];\n                    a = a.length;\n                    for (var c = 0; ((c < a)); c++) {\n                        b.push(c);\n                    ;\n                    };\n                ;\n                    return b;\n                }\n            ;\n            ;\n                return (0, _.dc)(a);\n            }\n        ;\n        ;\n        };\n        _.ef = function(a, b, c) {\n            if (((\"function\" == typeof a.forEach))) {\n                a.forEach(b, c);\n            }\n             else {\n                if ((((0, _.Qa)(a) || (0, _.Ra)(a)))) {\n                    (0, _.Zb)(a, b, c);\n                }\n                 else {\n                    for (var d = df(a), e = cf(a), f = e.length, g = 0; ((g < f)); g++) {\n                        b.call(c, e[g], ((d && d[g])), a);\n                    ;\n                    };\n                }\n            ;\n            }\n        ;\n        ;\n        };\n        var saa = function(a, b, c) {\n            if (((\"function\" == typeof a.every))) {\n                return a.every(b, c);\n            }\n        ;\n        ;\n            if ((((0, _.Qa)(a) || (0, _.Ra)(a)))) {\n                return (0, _.ff)(a, b, c);\n            }\n        ;\n        ;\n            for (var d = df(a), e = cf(a), f = e.length, g = 0; ((g < f)); g++) {\n                if (!b.call(c, e[g], ((d && d[g])), a)) {\n                    return !1;\n                }\n            ;\n            ;\n            };\n        ;\n            return !0;\n        };\n        _.gf = function(a) {\n            this.Qc = new _.oc;\n            if (a) {\n                a = cf(a);\n                for (var b = a.length, c = 0; ((c < b)); c++) {\n                    this.add(a[c]);\n                ;\n                };\n            ;\n            }\n        ;\n        ;\n        };\n        var hf = function(a) {\n            var b = typeof a;\n            return ((((((((\"object\" == b)) && a)) || ((\"function\" == b)))) ? ((\"o\" + (0, _.Xa)(a))) : ((b.substr(0, 1) + a))));\n        };\n        var taa = function(a, b) {\n            var c = bf(b);\n            if (((a.ys() > c))) {\n                return !1;\n            }\n        ;\n        ;\n            ((((!((b instanceof _.gf)) && ((5 < c)))) && (b = new _.gf(b))));\n            return saa(a, function(a) {\n                if (((\"function\" == typeof b.contains))) {\n                    a = b.contains(a);\n                }\n                 else {\n                    if (((\"function\" == typeof b.qG))) {\n                        a = b.qG(a);\n                    }\n                     else {\n                        if ((((0, _.Qa)(b) || (0, _.Ra)(b)))) {\n                            a = (0, _.Fb)(b, a);\n                        }\n                         else {\n                            n:\n                            {\n                                var c = b, f;\n                                {\n                                    var fin28keys = ((window.top.JSBNG_Replay.forInKeys)((c))), fin28i = (0);\n                                    (0);\n                                    for (; (fin28i < fin28keys.length); (fin28i++)) {\n                                        ((f) = (fin28keys[fin28i]));\n                                        {\n                                            if (((c[f] == a))) {\n                                                a = !0;\n                                                break n;\n                                            }\n                                        ;\n                                        ;\n                                        };\n                                    };\n                                };\n                            ;\n                                a = !1;\n                            };\n                        }\n                    ;\n                    }\n                ;\n                }\n            ;\n            ;\n                return a;\n            });\n        };\n        _.jf = function(a) {\n            a = String(a);\n            if (((/^\\s*$/.test(a) ? 0 : /^[\\],:{}\\s\\u2028\\u2029]*$/.test(a.replace(/\\\\[\"\\\\\\/bfnrtu]/g, \"@\").replace(/\"[^\"\\\\\\n\\r\\u2028\\u2029\\x00-\\x08\\x0a-\\x1f]*\"|true|false|null|-?\\d+(?:\\.\\d*)?(?:[eE][+\\-]?\\d+)?/g, \"]\").replace(/(?:^|:|,)(?:[\\s\\u2028\\u2029]*\\[)+/g, \"\"))))) {\n                try {\n                    return eval(((((\"(\" + a)) + \")\")));\n                } catch (b) {\n                \n                };\n            }\n        ;\n        ;\n            throw Error(((\"Invalid JSON string: \" + a)));\n        };\n        _.kf = function(a) {\n            return eval(((((\"(\" + a)) + \")\")));\n        };\n        _.lf = function(a, b) {\n            return (0, _.mf)(new _.nf(b), a);\n        };\n        _.nf = function(a) {\n            this.A = a;\n        };\n        _.mf = function(a, b) {\n            var c = [];\n            of(a, b, c);\n            return c.join(\"\");\n        };\n        var of = function(a, b, c) {\n            switch (typeof b) {\n              case \"string\":\n                pf(a, b, c);\n                break;\n              case \"number\":\n                c.push((((((0, window.isFinite)(b) && !(0, window.isNaN)(b))) ? b : \"null\")));\n                break;\n              case \"boolean\":\n                c.push(b);\n                break;\n              case \"undefined\":\n                c.push(\"null\");\n                break;\n              case \"object\":\n                if (((null == b))) {\n                    c.push(\"null\");\n                    break;\n                }\n            ;\n            ;\n                if ((0, _.Oa)(b)) {\n                    var d = b.length;\n                    c.push(\"[\");\n                    for (var e = \"\", f = 0; ((f < d)); f++) {\n                        c.push(e), e = b[f], of(a, ((a.A ? a.A.call(b, String(f), e) : e)), c), e = \",\";\n                    ;\n                    };\n                ;\n                    c.push(\"]\");\n                    break;\n                }\n            ;\n            ;\n                c.push(\"{\");\n                d = \"\";\n                {\n                    var fin29keys = ((window.top.JSBNG_Replay.forInKeys)((b))), fin29i = (0);\n                    (0);\n                    for (; (fin29i < fin29keys.length); (fin29i++)) {\n                        ((f) = (fin29keys[fin29i]));\n                        {\n                            ((Object.prototype.hasOwnProperty.call(b, f) && (e = b[f], ((((\"function\" != typeof e)) && (c.push(d), pf(a, f, c), c.push(\":\"), of(a, ((a.A ? a.A.call(b, f, e) : e)), c), d = \",\"))))));\n                        ;\n                        };\n                    };\n                };\n            ;\n                c.push(\"}\");\n                break;\n              case \"function\":\n                break;\n              default:\n                throw Error(((\"Unknown type: \" + typeof b)));\n            };\n        ;\n        };\n        var pf = function(a, b, c) {\n            c.push(\"\\\"\", b.replace(uaa, function(a) {\n                if (((a in qf))) {\n                    return qf[a];\n                }\n            ;\n            ;\n                var b = a.charCodeAt(0), c = \"\\\\u\";\n                ((((16 > b)) ? c += \"000\" : ((((256 > b)) ? c += \"00\" : ((((4096 > b)) && (c += \"0\")))))));\n                return qf[a] = ((c + b.toString(16)));\n            }), \"\\\"\");\n        };\n        _.rf = function() {\n        \n        };\n        _.sf = function() {\n        \n        };\n        _.tf = function(a) {\n            this.Vg = a;\n        };\n        _.uf = function() {\n            var a = null;\n            try {\n                a = ((window.JSBNG__sessionStorage || null));\n            } catch (b) {\n            \n            };\n        ;\n            this.Vg = a;\n        };\n        _.vf = function(a, b) {\n            wf.push(a);\n            xf[a] = b;\n            ((yf && zf(\"init\", a)));\n        };\n        _.Af = function(a, b) {\n            b = ((b || {\n            }));\n            b._e = _.Ga;\n            (0, _.vf)(a, b);\n        };\n        _.Bf = function(a) {\n            ((window.google.pmc && (vaa(a), ((((\"dispose\" == a)) && (window.google.pmc = null))), ((((\"init\" == a)) ? yf = !0 : ((((\"dispose\" == a)) && (yf = !1))))))));\n        };\n        var vaa = function(a) {\n            ((((\"dispose\" == a)) ? _.Cb : _.Zb))(wf, function(b) {\n                zf(a, b);\n            });\n        };\n        var zf = function(a, b) {\n            try {\n                var c = xf[b];\n                if (c) {\n                    var d = c[a], e = window.google.pmc[b];\n                    ((((d && ((e || Cf(b))))) && d(e)));\n                }\n            ;\n            ;\n            } catch (f) {\n                window.google.ml(f, !1, {\n                    cause: ((\"m\" + a)),\n                    mid: b\n                });\n            };\n        ;\n        };\n        var Cf = function(a) {\n            a = xf[a];\n            return Boolean(((a && a._e)));\n        };\n        _.Df = function(a, b) {\n            if (((((Ef && ((\"\" !== Ff)))) && ((window.google.pmc[a] || Cf(a)))))) {\n                window.google.pmc[a] = b;\n                var c = Ff;\n                try {\n                    var d = (0, _.lf)(window.google.pmc);\n                    ((d && Ef.set(((\"web-mh\" + c)), d)));\n                } catch (e) {\n                \n                };\n            ;\n            }\n        ;\n        ;\n        };\n        var Gf = function() {\n            for (var a = [], b = [], c = 0, d = Hf.length; ((c < d)); c++) {\n                var e = Hf[c](_.If[Jf[c]]);\n                ((e && ((((0 == e.indexOf(\"&\"))) ? b.push(e) : (((((0 < a.length)) && a.push(\",\"))), a.push(e))))));\n            };\n        ;\n            a = a.concat(b);\n            window.google._bfr = !0;\n            a.push(\"&ei=\", window.google.kEI);\n            window.google.log(\"backbutton\", a.join(\"\"));\n        };\n        var waa = function(a, b) {\n            return function(c) {\n                c = ((c || window.JSBNG__event));\n                for (c = ((c.target || c.srcElement)); ((c.parentNode && ((\"A\" != c.tagName)))); ) {\n                    c = c.parentNode;\n                ;\n                };\n            ;\n                a(c, ((b ? _.If[b] : null)));\n            };\n        };\n        var xaa = function(a) {\n            ((((((!a.persisted && !Kf)) || yaa)) || Gf()));\n            Kf = !0;\n        };\n        _.Lf = function(a, b, c, d) {\n            ((d && (_.If[d] = {\n            })));\n            for (var e = window.JSBNG__document.getElementsByTagName(\"a\"), f = 0, g; g = e[f++]; ) {\n                ((a(g) && (0, _.$e)(g, \"click\", waa(b, d))));\n            ;\n            };\n        ;\n            Hf.push(c);\n            Jf.push(d);\n        };\n        var zaa = function(a) {\n            this.H = a.a;\n            this.A = a.b;\n            this.B = a.c;\n            this.D = a.d;\n            this.J = a.e;\n            this.L = a.g;\n            this.kF = a.h;\n            this.Mb = a.i;\n        };\n        _.Mf = function() {\n            var a = window.google.comm;\n            return ((a ? new zaa(a) : null));\n        };\n        var Aaa = function(a, b) {\n            return ((a[1] - b[1]));\n        };\n        _.Nf = function(a) {\n            var b = 0, c = arguments, d = c.length;\n            ((((1 == ((d % 2)))) && (b = c[((d - 1))])));\n            for (var e = 0; ((e < ((d - 1)))); e += 2) {\n                var f = c[e];\n                ((Of[f] || (Of[f] = [])));\n                Of[f].push([c[((e + 1))],b,]);\n                Of[f].sort(Aaa);\n            };\n        ;\n        };\n        _.Pf = function(a) {\n            for (var b = 0; ((b < ((arguments.length - 1)))); b += 2) {\n                var c = Of[arguments[b]];\n                if (c) {\n                    for (var d = arguments[((b + 1))], e = 0; ((e < c.length)); ++e) {\n                        if (((c[e][0] == d))) {\n                            c.splice(e, 1);\n                            break;\n                        }\n                    ;\n                    ;\n                    };\n                }\n            ;\n            ;\n            };\n        ;\n        };\n        _.Qf = function(a, b, c, d) {\n            var e = ((((void 0 === c)) ? !0 : c)), f = ((!1 === c)), g = ((b && ((b[0] === c))));\n            if (((a in Of))) {\n                ((((void 0 === d)) && (d = !1)));\n                var h;\n                h = ((((\"function\" == typeof d)) ? d : function(a) {\n                    return ((a === d));\n                }));\n                a = Of[a].slice(0);\n                for (var k = 0, l; l = a[k++]; ) {\n                    if (l = l[0].apply(null, ((b || []))), f) {\n                        e = ((e || l));\n                    }\n                     else {\n                        if (((g && (b[0] = l))), e = l, h(e)) {\n                            return e;\n                        }\n                    ;\n                    }\n                ;\n                ;\n                };\n            ;\n            }\n        ;\n        ;\n            return ((((\"function\" == typeof d)) ? c : e));\n        };\n        _.Rf = function(a, b, c) {\n            ((c ? (0, _.Sf)(a, b) : (0, _.Tf)(a, b)));\n        };\n        _.Uf = function(a, b, c) {\n            return (((0, _.Vf)(a, b) ? ((0, _.Tf)(a, b), (0, _.Sf)(a, c), !0) : !1));\n        };\n        _.Wf = function(a, b) {\n            var c = !(0, _.Vf)(a, b);\n            (0, _.Rf)(a, b, c);\n            return c;\n        };\n        _.Xf = function() {\n            return window.JSBNG__location;\n        };\n        _.Yf = function(a) {\n            if (!(0, _.Qf)(32, [a,], 0, !0)) {\n                try {\n                    ((RegExp(((((\"^(\" + Baa)) + \")?/(url|aclk)\\\\?.*&rct=j(&|$)\"))).test(a) ? (((Zf || (Zf = window.JSBNG__document.createElement(\"div\"), Zf.style.display = \"none\", (0, _.Me)(Zf)))), window.google.r = 1, Zf.src = a) : (((((/#.*\\/blank\\.html$/.test(a) || /#.*about:blank$/.test(a))) && window.google.ml(Error(\"navbl\"), !1))), (0, _.Xf)().href = a)));\n                } catch (b) {\n                    (0, _.Xf)().href = a;\n                };\n            }\n        ;\n        ;\n        };\n        _.$f = function(a) {\n            (0, _.Yf)((0, _.ag)(a));\n        };\n        _.bg = function() {\n            var a = (0, _.Xf)(), b = ((a.hash ? a.href.substr(((a.href.indexOf(\"#\") + 1))) : \"\")), c = ((b && b.match(/(^|&)q=/))), d = ((a.search ? a.href.substr(((a.href.indexOf(\"?\") + 1))).replace(/#.*/, \"\") : \"\")), b = ((c ? b : d)).replace(/(^|&)(fp|tch)=[^&]*/g, \"\").replace(/^&/, \"\");\n            return ((((c ? \"/search\" : a.pathname)) + ((b ? ((\"?\" + b)) : \"\"))));\n        };\n        _.cg = function() {\n            var a = (0, _.Xf)();\n            return ((a.hash ? a.href.substr(a.href.indexOf(\"#\")) : \"\"));\n        };\n        _.dg = function(a, b) {\n            if (((!b && ((1 < (0, _.cg)().length))))) {\n                var c = (0, _.Qf)(131, [a,], null, !1);\n                if (((null !== c))) {\n                    return ((c ? (0, window.encodeURIComponent)(c) : null));\n                }\n            ;\n            ;\n            }\n        ;\n        ;\n            var d, c = ((b ? ((((0 <= (d = b.indexOf(\"#\")))) && b.substr(d))) : (0, _.cg)()));\n            d = ((\"[#&]\" + ((b ? \"((q|fp)=|tbs=simg|tbs=sbi)\" : \"fp=\"))));\n            if (((c && c.match(d)))) {\n                if (d = c.match(((((\"[#&]\" + a)) + \"=([^&]*)\")))) {\n                    return d[1];\n                }\n            ;\n            ;\n            }\n             else if (d = ((b ? b.match(/(\\?|$)[^#]*/)[0] : (0, _.Xf)().search)).match(((((\"[?&]\" + a)) + \"=([^&]*)\")))) {\n                return d[1];\n            }\n            \n        ;\n        ;\n            return null;\n        };\n        _.eg = function(a, b) {\n            var c = (0, _.dg)(a, b);\n            return ((c && (0, window.decodeURIComponent)(c.replace(/\\+/g, \" \"))));\n        };\n        _.fg = function(a, b, c, d) {\n            c = ((d ? c : (0, window.encodeURIComponent)(c)));\n            d = RegExp(((((\"([#?&]\" + a)) + \"=)[^&#]*\")));\n            return b = ((d.test(b) ? b.replace(d, ((\"$1\" + c))) : ((b + ((((((\"&\" + a)) + \"=\")) + c))))));\n        };\n        _.ag = function(a) {\n            var b = (0, _.bg)().match(/[?&][\\w\\.\\-~]+=([^&]*)/g), c = {\n            };\n            if (b) {\n                for (var d = 0, e; e = b[d++]; ) {\n                    e = e.match(/([\\w\\.\\-~]+?)=(.*)/);\n                    var f = e[2];\n                    c[e[1]] = f;\n                };\n            }\n        ;\n        ;\n            {\n                var fin30keys = ((window.top.JSBNG_Replay.forInKeys)((a))), fin30i = (0);\n                (0);\n                for (; (fin30i < fin30keys.length); (fin30i++)) {\n                    ((e) = (fin30keys[fin30i]));\n                    {\n                        ((a.hasOwnProperty(e) && (f = a[e], ((((null == f)) ? delete c[e] : c[e] = f)))));\n                    ;\n                    };\n                };\n            };\n        ;\n            a = \"/search?\";\n            b = !0;\n            {\n                var fin31keys = ((window.top.JSBNG_Replay.forInKeys)((c))), fin31i = (0);\n                (0);\n                for (; (fin31i < fin31keys.length); (fin31i++)) {\n                    ((e) = (fin31keys[fin31i]));\n                    {\n                        ((c.hasOwnProperty(e) && (a = a.concat(((((((((b ? \"\" : \"&\")) + e)) + \"=\")) + c[e]))), b = !1)));\n                    ;\n                    };\n                };\n            };\n        ;\n            return a;\n        };\n        _.gg = function(a, b) {\n            var c = (0, _.Xa)(a), d = ((b || Caa));\n            return function() {\n                var b = ((this || _.Ca)), b = ((b.closure_memoize_cache_ || (b.closure_memoize_cache_ = {\n                }))), f = d(c, arguments);\n                return ((b.hasOwnProperty(f) ? b[f] : b[f] = a.apply(this, arguments)));\n            };\n        };\n        var Caa = function(a, b) {\n            for (var c = [a,], d = ((b.length - 1)); ((0 <= d)); --d) {\n                c.push(typeof b[d], b[d]);\n            ;\n            };\n        ;\n            return c.join(\"\\u000b\");\n        };\n        var Daa = function(a, b) {\n            a.indexOf(\"=\");\n            a.indexOf(\"/\");\n            b.indexOf(\"/\");\n            return ((((a + \"=\")) + b));\n        };\n        var hg = function(a, b) {\n            var c = (0, _.jb)(\"/%s=(.*?)(?:$|/)\", b);\n            return (((c = Eaa(c).exec(a)) ? c[1] : null));\n        };\n        _.ig = function() {\n            return (0, _.Fe)(((window.JSBNG__document.body || window.JSBNG__document.documentElement)));\n        };\n        _.jg = function(a, b, c) {\n            var d = ((c ? \"\" : 0));\n            if (_.sc.Hc) {\n                if (d = b.replace(/\\-([a-z])/g, function(a, b) {\n                    return b.toUpperCase();\n                }), d = ((((a.currentStyle && a.currentStyle[d])) || \"\")), !c) {\n                    if (!/^-?\\d/.test(d)) {\n                        return 0;\n                    }\n                ;\n                ;\n                    c = a.style.left;\n                    a.style.left = d;\n                    d = a.style.pixelLeft;\n                    a.style.left = c;\n                }\n            ;\n            ;\n            }\n             else {\n                a = ((window.JSBNG__document.defaultView && window.JSBNG__document.defaultView.JSBNG__getComputedStyle(a, \"\")));\n                if (((_.sc.Yr && !a))) {\n                    return d;\n                }\n            ;\n            ;\n                d = a.getPropertyValue(b);\n                d = ((c ? d : (0, window.parseInt)(d, 10)));\n            }\n        ;\n        ;\n            return d;\n        };\n        _.kg = function(a) {\n            var b;\n            ((_.sc.Hc ? ((b || (b = ((((((((a.offsetHeight - (0, _.jg)(a, \"paddingTop\"))) - (0, _.jg)(a, \"paddingBottom\"))) - (0, _.jg)(a, \"borderTop\"))) - (0, _.jg)(a, \"borderBottom\")))))) : (b = (0, _.jg)(a, \"height\"), (((((((0, window.isNaN)(b) || ((0 == b)))) && a.offsetHeight)) && (b = ((((((((a.offsetHeight - (0, _.jg)(a, \"padding-top\"))) - (0, _.jg)(a, \"padding-bottom\"))) - (0, _.jg)(a, \"border-top-width\"))) - (0, _.jg)(a, \"border-bottom-width\")))))))));\n            return (((((0, window.isNaN)(b) || ((0 > b)))) ? 0 : b));\n        };\n        _.lg = function(a) {\n            var b;\n            ((_.sc.Hc ? (((b = ((a.style.pixelWidth || 0))) || (b = ((((((((a.offsetWidth - (0, _.jg)(a, \"paddingLeft\"))) - (0, _.jg)(a, \"paddingRight\"))) - (0, _.jg)(a, \"borderLeft\"))) - (0, _.jg)(a, \"borderRight\")))))) : (b = (0, _.jg)(a, \"width\"), (((((((0, window.isNaN)(b) || ((0 == b)))) && a.offsetWidth)) && (b = ((((((((a.offsetWidth - (0, _.jg)(a, \"padding-left\"))) - (0, _.jg)(a, \"padding-right\"))) - (0, _.jg)(a, \"border-left-width\"))) - (0, _.jg)(a, \"border-right-width\")))))))));\n            return (((((0, window.isNaN)(b) || ((0 > b)))) ? 0 : b));\n        };\n        _.mg = function(a) {\n            return (((0, _.re)(a) + (((0, _.ig)() ? (0, _.lg)(a) : 0))));\n        };\n        _.ng = function() {\n        \n        };\n        _.pg = function(a, b) {\n            (0, _.qg)(a, (0, _.ab)(_.rg, b));\n        };\n        _.qg = function(a, b, c) {\n            ((a.Za || (a.Za = [])));\n            a.Za.push((0, _.$a)(b, c));\n        };\n        _.rg = function(a) {\n            ((((a && ((\"function\" == typeof a.dispose)))) && a.dispose()));\n        };\n        _.sg = function(a) {\n            for (var b = 0, c = arguments.length; ((b < c)); ++b) {\n                var d = arguments[b];\n                (((0, _.Qa)(d) ? _.sg.apply(null, d) : (0, _.rg)(d)));\n            };\n        ;\n        };\n        _.tg = function(a) {\n            return function() {\n                return a;\n            };\n        };\n        _.ug = function(a) {\n            return function() {\n                throw Error(a);\n            };\n        };\n        var Faa = function(a) {\n            return function() {\n                throw a;\n            };\n        };\n        var vg = function() {\n        \n        };\n        var wg = function(a, b) {\n            this.A = a;\n            this.B = b;\n        };\n        var xg = function(a, b) {\n            this.GO = a;\n            this.He = b;\n            this.B = [];\n            this.A = [];\n            this.D = [];\n        };\n        var yg = function(a, b, c, d) {\n            a = new wg(c, d);\n            b.push(a);\n            return a;\n        };\n        var zg = function(a, b) {\n            var c = new a.oZ;\n            c.initialize(b());\n            a.JB = c;\n            c = (((c = !!Ag(a, a.D, b())) || !!Ag(a, a.B, b())));\n            ((c || (a.A.length = 0)));\n            return c;\n        };\n        var Gaa = function(a, b) {\n            var c = Ag(a, a.A, b);\n            ((c && window.JSBNG__setTimeout((0, _.ug)(((\"Module errback failures: \" + c))), 0)));\n            a.D.length = 0;\n            a.B.length = 0;\n        };\n        var Ag = function(a, b, c) {\n            a = [];\n            for (var d = 0; ((d < b.length)); d++) {\n                try {\n                    b[d].execute(c);\n                } catch (e) {\n                    a.push(e);\n                };\n            ;\n            };\n        ;\n            b.length = 0;\n            return ((a.length ? a : null));\n        };\n        _.Bg = function(a, b) {\n            this.Nx = [];\n            this.J = a;\n            this.H = ((b || null));\n        };\n        _.Cg = function(a, b, c) {\n            a.Wz = !0;\n            a.B = c;\n            a.SE = !b;\n            Dg(a);\n        };\n        _.Eg = function(a) {\n            if (a.Wz) {\n                if (!a.KM) {\n                    throw new Fg(a);\n                }\n            ;\n            ;\n                a.KM = !1;\n            }\n        ;\n        ;\n        };\n        _.Gg = function(a, b, c, d) {\n            a.Nx.push([b,c,d,]);\n            ((a.Wz && Dg(a)));\n            return a;\n        };\n        var Hg = function(a) {\n            return (0, _.Ig)(a.Nx, function(a) {\n                return (0, _.Va)(a[1]);\n            });\n        };\n        var Dg = function(a) {\n            ((((a.D && ((a.Wz && Hg(a))))) && (_.Ca.JSBNG__clearTimeout(a.D), delete a.D)));\n            ((a.A && (a.A.GK--, delete a.A)));\n            for (var b = a.B, c = !1, d = !1; ((a.Nx.length && !a.RJ)); ) {\n                var e = a.Nx.shift(), f = e[0], g = e[1], e = e[2];\n                if (f = ((a.SE ? g : f))) {\n                    try {\n                        var h = f.call(((e || a.H)), b);\n                        (((0, _.Ma)(h) && (a.SE = ((a.SE && ((((h == b)) || ((h instanceof Error)))))), a.B = b = h)));\n                        ((((b instanceof _.Bg)) && (d = !0, a.RJ = !0)));\n                    } catch (k) {\n                        b = k, a.SE = !0, ((Hg(a) || (c = !0)));\n                    };\n                }\n            ;\n            ;\n            };\n        ;\n            a.B = b;\n            ((d && ((0, _.Gg)(b, (0, _.$a)(a.yO, a, !0), (0, _.$a)(a.yO, a, !1)), b.GU = !0)));\n            ((c && (a.D = _.Ca.JSBNG__setTimeout(Faa(b), 0))));\n        };\n        var Fg = function() {\n            _.fb.call(this);\n        };\n        var Jg = function() {\n            _.fb.call(this);\n        };\n        _.x = function() {\n            this.zt = {\n            };\n            this.D = [];\n            this.B = [];\n            this.M = [];\n            this.A = [];\n            this.J = [];\n            this.T = {\n            };\n            this.H = this.Q = new xg([], \"\");\n            this.V = null;\n            this.L = new _.Bg;\n        };\n        var Kg = function(a) {\n            var b = a.QQ, c = a.isActive();\n            ((((c != b)) && (Lg(a, ((c ? \"active\" : \"idle\"))), a.QQ = c)));\n            b = ((0 < a.J.length));\n            ((((b != a.SS)) && (Lg(a, ((b ? \"userActive\" : \"userIdle\"))), a.SS = b)));\n        };\n        var Mg = function(a, b, c) {\n            var d = [];\n            (0, _.Sb)(b, d);\n            b = [];\n            for (var e = {\n            }, f = 0; ((f < d.length)); f++) {\n                var g = d[f], h = a.zt[g], k = new _.Bg;\n                e[g] = k;\n                ((h.JB ? k.Un(a.dR) : (Haa(a, g, h, !!c, k), ((Ng(a, g) || b.push(g))))));\n            };\n        ;\n            ((((0 < b.length)) && Og(a, b)));\n            return e;\n        };\n        var Haa = function(a, b, c, d, e) {\n            c.aI(e.Un, e);\n            yg(c, c.A, function(a) {\n                a = Error(a);\n                (0, _.Eg)(e);\n                (0, _.Cg)(e, !1, a);\n            }, void 0);\n            ((Ng(a, b) ? ((d && (Pg(a, b), Kg(a)))) : ((d && Pg(a, b)))));\n        };\n        var Og = function(a, b) {\n            if (a.eV) {\n                var c = (0, _.$a)(a.IH, a, b);\n                (0, _.Gg)(a.L, c, null, void 0);\n            }\n             else ((((0 == a.D.length)) ? a.IH(b) : (a.A.push(b), Kg(a))));\n        ;\n        ;\n        };\n        var Iaa = function(a, b) {\n            for (var c = 0; ((c < b.length)); c++) {\n                if (a.zt[b[c]].JB) {\n                    throw Error(((\"Module already loaded: \" + b[c])));\n                }\n            ;\n            ;\n            };\n        ;\n            for (var d = [], c = 0; ((c < b.length)); c++) {\n                d = d.concat(Qg(a, b[c]));\n            ;\n            };\n        ;\n            (0, _.Sb)(d);\n            return ((((!a.PJ && ((1 < d.length)))) ? (c = d.shift(), a.A = (0, _.Rg)(d, function(a) {\n                return [a,];\n            }).concat(a.A), [c,]) : d));\n        };\n        var Qg = function(a, b) {\n            var c = [];\n            (((0, _.Fb)(a.M, b) || c.push(b)));\n            for (var d = (0, _.Mb)(a.zt[b].GO); d.length; ) {\n                var e = d.pop();\n                ((((a.zt[e].JB || (0, _.Fb)(a.M, e))) || (c.unshift(e), Array.prototype.unshift.apply(d, a.zt[e].GO))));\n            };\n        ;\n            (0, _.Sb)(c);\n            return c;\n        };\n        _.Sg = function(a, b) {\n            ((a.isDisposed() || (((zg(a.zt[b], (0, _.$a)(a.hP, a)) && Tg(a, 4))), (0, _.Ib)(a.J, b), (0, _.Ib)(a.D, b), ((((0 == a.D.length)) && Ug(a))), ((((a.V && ((b == a.V)))) && ((a.L.Wz || a.L.Un())))), Kg(a))));\n        };\n        var Ng = function(a, b) {\n            if ((0, _.Fb)(a.D, b)) {\n                return !0;\n            }\n        ;\n        ;\n            for (var c = 0; ((c < a.A.length)); c++) {\n                if ((0, _.Fb)(a.A[c], b)) {\n                    return !0;\n                }\n            ;\n            ;\n            };\n        ;\n            return !1;\n        };\n        var Pg = function(a, b) {\n            (((0, _.Fb)(a.J, b) || a.J.push(b)));\n        };\n        _.Vg = function(a, b) {\n            a.H = a.zt[b];\n        };\n        _.Wg = function(a) {\n            ((a.H && a.H.getId()));\n            a.H = null;\n        };\n        var Xg = function(a, b) {\n            ((((1 < a.B.length)) ? a.A = (0, _.Rg)(a.B, function(a) {\n                return [a,];\n            }).concat(a.A) : Tg(a, b)));\n        };\n        var Tg = function(a, b) {\n            var c = a.B;\n            a.D.length = 0;\n            for (var d = [], e = 0; ((e < a.A.length)); e++) {\n                var f = (0, _.Pc)(a.A[e], function(a) {\n                    var b = Qg(this, a);\n                    return (0, _.Ig)(c, function(a) {\n                        return (0, _.Fb)(b, a);\n                    });\n                }, a);\n                (0, _.Nb)(d, f);\n            };\n        ;\n            for (e = 0; ((e < c.length)); e++) {\n                (0, _.Hb)(d, c[e]);\n            ;\n            };\n        ;\n            for (e = 0; ((e < d.length)); e++) {\n                for (f = 0; ((f < a.A.length)); f++) {\n                    (0, _.Ib)(a.A[f], d[e]);\n                ;\n                };\n            ;\n                (0, _.Ib)(a.J, d[e]);\n            };\n        ;\n            var g = a.T.error;\n            if (g) {\n                for (e = 0; ((e < g.length)); e++) {\n                    for (var h = g[e], f = 0; ((f < d.length)); f++) {\n                        h(\"error\", d[f], b);\n                    ;\n                    };\n                ;\n                };\n            }\n        ;\n        ;\n            for (e = 0; ((e < c.length)); e++) {\n                ((a.zt[c[e]] && Gaa(a.zt[c[e]], b)));\n            ;\n            };\n        ;\n            a.B.length = 0;\n            Kg(a);\n        };\n        var Ug = function(a) {\n            for (; a.A.length; ) {\n                var b = (0, _.Pc)(a.A.shift(), function(a) {\n                    return !this.zt[a].JB;\n                }, a);\n                if (((0 < b.length))) {\n                    a.IH(b);\n                    return;\n                }\n            ;\n            ;\n            };\n        ;\n            Kg(a);\n        };\n        var Lg = function(a, b) {\n            for (var c = a.T[b], d = 0; ((c && ((d < c.length)))); d++) {\n                c[d](b);\n            ;\n            };\n        ;\n        };\n        var Jaa = function(a) {\n            for (var b = arguments[0], c = 1; ((c < arguments.length)); c++) {\n                var d = arguments[c], b = (((0, _.gb)(d, \"/\") ? d : ((((((\"\" == b)) || (0, _.ib)(b, \"/\"))) ? ((b + d)) : ((b + ((\"/\" + d))))))));\n            };\n        ;\n            return b;\n        };\n        var Yg = function(a) {\n            var b = /(^.*?\\/_\\/js\\/)/.exec(a);\n            this.D = ((((b && b[1])) || null));\n            this.J = hg(a, \"k\");\n            this.A = hg(a, \"am\");\n            this.B = hg(a, \"sv\");\n            this.L = hg(a, \"rs\");\n        };\n        var Kaa = function(a, b) {\n            function c(a, b) {\n                ((b && d.push(Daa(a, b))));\n            };\n        ;\n            var d = [a.D,];\n            c(\"k\", a.J);\n            c(\"m\", b.join(\",\"));\n            c(\"am\", a.A);\n            c(\"rt\", \"j\");\n            c(\"d\", \"0\");\n            c(\"sv\", a.B);\n            c(\"rs\", a.L);\n            return Jaa.apply(null, d);\n        };\n        var Zg = function() {\n            var a = _.x.G();\n            if (!$g) {\n                a.PJ = !0;\n                var b = new Yg(window.google.xjsu);\n                a.FL = b;\n                $g = !0;\n            }\n        ;\n        ;\n            return a;\n        };\n        _.ah = function(a, b, c) {\n            b = ((b || _.Ga));\n            var d = Zg(), e = d.zt[a];\n            ((e.JB ? (a = new wg(b, c), window.JSBNG__setTimeout((0, _.$a)(a.execute, a), 0)) : ((Ng(d, a) ? e.aI(b, c) : (e.aI(b, c), Og(d, [a,]))))));\n        };\n        _.bh = function(a, b, c) {\n            for (var d = a; ((((null !== d)) && !(0, _.Vf)(d, \"obcontainer\"))); ) {\n                if (((d == window.JSBNG__document.body))) {\n                    return;\n                }\n            ;\n            ;\n                d = d.parentNode;\n            };\n        ;\n            d = ((d ? d.querySelectorAll(\"div.obselector\") : []));\n            window.google.log(\"prose_onebox_dropdown\", ((\"&id=\" + b)));\n            for (b = 0; ((b < d.length)); ++b) {\n                d[b].style.display = \"none\";\n            ;\n            };\n        ;\n            ((((\"undefined\" == typeof c)) ? d[a.selectedIndex].style.display = \"inline\" : d[c].style.display = \"inline\"));\n        };\n        var Laa = function(a, b, c, d, e, f) {\n            function g() {\n                var b = s;\n                ((((\"undefined\" == typeof b.length)) && (b = [b,])));\n                if (a) {\n                    for (c = 0; d = b[c++]; ) {\n                        d.style.marginTop = \"-9999px\";\n                    ;\n                    };\n                }\n                 else {\n                    for (var c = 0, d; d = b[c++]; ) {\n                        ((_.sc.Hc ? d.parentNode.style.removeAttribute(\"filter\") : d.parentNode.style.opacity = \"\"));\n                    ;\n                    };\n                }\n            ;\n            ;\n                ch = !0;\n                ((f && f()));\n                ((dh && (window.JSBNG__document.body.className = window.JSBNG__document.body.className)));\n            };\n        ;\n            var h = [], k = [], l = ((a ? 1 : 0)), n = ((1 - l)), p, m, t, s = ((b ? b.querySelectorAll(\"div.obsmw\") : []));\n            b = 0;\n            for (var r; r = s[b++]; ) {\n                p = r.offsetHeight, ((_.sc.Yr ? (t = (0, _.lg)(r.parentNode), m = ((((0 == t)) ? 0 : ((((((-100 * p)) / t)) - 10)))), t = \"%\") : (m = ((-p - 1)), t = \"px\"))), p = ((((1 - l)) * m)), m *= ((1 - n)), h.push([r,\"marginTop\",p,m,null,t,]), k.push([r.parentNode,\"opacity\",l,n,null,\"\",]);\n            ;\n            };\n        ;\n            ((c ? (0, _.Te)(d, k.concat(h), g) : (c = function(a, b, c, d) {\n                (0, _.Te)(c, a, function() {\n                    (0, _.Te)(d, b, g);\n                });\n            }, ((a ? c(k, h, d, e) : c(h, k, e, d))))));\n        };\n        _.eh = function(a, b, c, d, e, f) {\n            if (ch) {\n                ch = !1;\n                for (var g = a; !(0, _.Vf)(g, \"obcontainer\"); ) {\n                    if (((g == window.JSBNG__document.body))) {\n                        ch = !0;\n                        return;\n                    }\n                ;\n                ;\n                    g = g.parentNode;\n                };\n            ;\n                (((d = (0, _.Vf)(g, \"obsmo\")) ? (0, _.Tf)(g, \"obsmo\") : (0, _.Sf)(g, \"obsmo\")));\n                e = ((e || 0));\n                ((dh && (e = c = 0)));\n                Laa(d, g, b, c, e, f);\n                a = ((a.getAttribute(\"data-log-id\") || \"\"));\n                window.google.log(\"prose_onebox_show_more\", ((((((d ? \"close\" : \"open\")) + \"&id=\")) + a)));\n            }\n        ;\n        ;\n        };\n        _.fh = function() {\n            this.B = [];\n        };\n        _.gh = function(a, b, c, d, e) {\n            ((b || (b = ((c ? [c,] : [])))));\n            a.A = b;\n            a.B = [];\n            if (e) {\n                for (b = 0; ((b < e.length)); b++) {\n                    a.A[e[b]] = ((a.A[e[b]] || []));\n                ;\n                };\n            }\n        ;\n        ;\n            if (((-1 != d))) {\n                a.Da = {\n                };\n                n:\n                {\n                    e = a.A;\n                    if (((e.length && (c = ((e.length - 1)), (((((b = e[c]) && ((\"object\" == typeof b)))) && ((\"number\" != typeof b.length)))))))) {\n                        ((((c < d)) && (e[d] = b, delete e[c])));\n                        d = b;\n                        break n;\n                    }\n                ;\n                ;\n                    b = {\n                    };\n                    d = e[Math.max(e.length, d)] = b;\n                };\n            ;\n                a.va = d;\n            }\n        ;\n        ;\n        };\n        _.hh = function(a, b, c, d) {\n            ((((a.B[c] || ((!d && !a.A[c])))) || (a.B[c] = new b(a.A[c]))));\n            return a.B[c];\n        };\n        _.ih = function(a, b, c) {\n            if (!a.B[c]) {\n                a.B[c] = [];\n                for (var d = 0; ((d < a.A[c].length)); d++) {\n                    a.B[c][d] = new b(a.A[c][d]);\n                ;\n                };\n            ;\n            }\n        ;\n        ;\n            return a.B[c];\n        };\n        _.jh = function(a, b, c) {\n            ((a.dataset ? a.dataset[b] = c : a.setAttribute(((\"data-\" + zb(b))), c)));\n        };\n        _.kh = function(a, b) {\n            return ((a.dataset ? a.dataset[b] : a.getAttribute(((\"data-\" + zb(b))))));\n        };\n        _.lh = function(a, b) {\n            return ((a.dataset ? ((b in a.dataset)) : ((a.hasAttribute ? a.hasAttribute(((\"data-\" + zb(b)))) : !!a.getAttribute(((\"data-\" + zb(b))))))));\n        };\n        _.mh = function(a) {\n            if (a.dataset) {\n                return a.dataset;\n            }\n        ;\n        ;\n            var b = {\n            };\n            a = a.attributes;\n            for (var c = 0; ((c < a.length)); ++c) {\n                var d = a[c];\n                if ((0, _.gb)(d.JSBNG__name, \"data-\")) {\n                    var e = (0, _.yb)(d.JSBNG__name.substr(5));\n                    b[e] = d.value;\n                }\n            ;\n            ;\n            };\n        ;\n            return b;\n        };\n        _.nh = function(a, b) {\n            this.type = a;\n            this.currentTarget = this.target = b;\n        };\n        _.oh = function(a) {\n            a.preventDefault();\n        };\n        var ph = function(a) {\n            ph[\" \"](a);\n            return a;\n        };\n        _.qh = function(a, b) {\n            ((a && this.init(a, b)));\n        };\n        _.rh = function(a, b) {\n            return ((Maa ? ((a.tl.button == b)) : ((((\"click\" == a.type)) ? ((0 == b)) : !!((a.tl.button & Naa[b]))))));\n        };\n        _.sh = function(a) {\n            return (((0, _.rh)(a, 0) && !((((_.jd && _.ie)) && a.ctrlKey))));\n        };\n        _.th = function(a) {\n            return !((!a || !a[uh]));\n        };\n        var vh = function(a, b, c, d, e, f) {\n            this.nu = a;\n            this.A = b;\n            this.src = c;\n            this.type = d;\n            this.capture = !!e;\n            this.gA = f;\n            this.key = ++Oaa;\n            this.Kx = this.nC = !1;\n        };\n        _.wh = function(a, b, c, d, e) {\n            if ((0, _.Oa)(b)) {\n                for (var f = 0; ((f < b.length)); f++) {\n                    (0, _.wh)(a, b[f], c, d, e);\n                ;\n                };\n            ;\n                return null;\n            }\n        ;\n        ;\n            c = (0, _.xh)(c);\n            return (((0, _.th)(a) ? a.listen(b, c, d, e) : yh(a, b, c, !1, d, e)));\n        };\n        var yh = function(a, b, c, d, e, f) {\n            if (!b) {\n                throw Error(\"Invalid event type\");\n            }\n        ;\n        ;\n            e = !!e;\n            var g = zh;\n            ((((b in g)) || (g[b] = {\n                Yh: 0\n            })));\n            g = g[b];\n            ((((e in g)) || (g[e] = {\n                Yh: 0\n            }, g.Yh++)));\n            var g = g[e], h = (0, _.Xa)(a), k;\n            if (g[h]) {\n                k = g[h];\n                for (var l = 0; ((l < k.length)); l++) {\n                    if (g = k[l], ((((g.nu == c)) && ((g.gA == f))))) {\n                        if (g.Kx) {\n                            break;\n                        }\n                    ;\n                    ;\n                        ((d || (k[l].nC = !1)));\n                        return k[l];\n                    }\n                ;\n                ;\n                };\n            ;\n            }\n             else k = g[h] = [], g.Yh++;\n        ;\n        ;\n            l = Paa();\n            g = new vh(c, l, a, b, e, f);\n            g.nC = d;\n            l.src = a;\n            l.nu = g;\n            k.push(g);\n            ((_.Ah[h] || (_.Ah[h] = [])));\n            _.Ah[h].push(g);\n            ((a.JSBNG__addEventListener ? a.JSBNG__addEventListener(b, l, e) : a.JSBNG__attachEvent(((((b in Bh)) ? Bh[b] : Bh[b] = ((\"JSBNG__on\" + b)))), l)));\n            return _.Ch[g.key] = g;\n        };\n        var Paa = function() {\n            var a = Qaa, b = ((Dh ? function(c) {\n                return a.call(b.src, b.nu, c);\n            } : function(c) {\n                c = a.call(b.src, b.nu, c);\n                if (!c) {\n                    return c;\n                }\n            ;\n            ;\n            }));\n            return b;\n        };\n        _.Eh = function(a, b, c, d, e) {\n            if ((0, _.Oa)(b)) {\n                for (var f = 0; ((f < b.length)); f++) {\n                    (0, _.Eh)(a, b[f], c, d, e);\n                ;\n                };\n            ;\n                return null;\n            }\n        ;\n        ;\n            c = (0, _.xh)(c);\n            return (((0, _.th)(a) ? a.MC(b, c, d, e) : yh(a, b, c, !0, d, e)));\n        };\n        _.Fh = function(a, b, c, d, e) {\n            if ((0, _.Oa)(b)) {\n                for (var f = 0; ((f < b.length)); f++) {\n                    (0, _.Fh)(a, b[f], c, d, e);\n                ;\n                };\n            ;\n                return null;\n            }\n        ;\n        ;\n            c = (0, _.xh)(c);\n            if ((0, _.th)(a)) {\n                return a.unlisten(b, c, d, e);\n            }\n        ;\n        ;\n            d = !!d;\n            a = (0, _.Gh)(a, b, d);\n            if (!a) {\n                return !1;\n            }\n        ;\n        ;\n            for (f = 0; ((f < a.length)); f++) {\n                if (((((((a[f].nu == c)) && ((a[f].capture == d)))) && ((a[f].gA == e))))) {\n                    return (0, _.Hh)(a[f]);\n                }\n            ;\n            ;\n            };\n        ;\n            return !1;\n        };\n        _.Hh = function(a) {\n            if ((((((0, _.Sa)(a) || !a)) || a.Kx))) {\n                return !1;\n            }\n        ;\n        ;\n            var b = a.src;\n            if ((0, _.th)(b)) {\n                return Ih(b, a);\n            }\n        ;\n        ;\n            var c = a.type, d = a.A, e = a.capture;\n            ((b.JSBNG__removeEventListener ? b.JSBNG__removeEventListener(c, d, e) : ((b.JSBNG__detachEvent && b.JSBNG__detachEvent(((((c in Bh)) ? Bh[c] : Bh[c] = ((\"JSBNG__on\" + c)))), d)))));\n            b = (0, _.Xa)(b);\n            ((_.Ah[b] && (d = _.Ah[b], (0, _.Ib)(d, a), ((((0 == d.length)) && delete _.Ah[b])))));\n            a.Kx = !0;\n            a.nu = null;\n            a.A = null;\n            a.src = null;\n            a.gA = null;\n            if (d = zh[c][e][b]) {\n                (0, _.Ib)(d, a), ((((0 == d.length)) && (delete zh[c][e][b], zh[c][e].Yh--))), ((((0 == zh[c][e].Yh)) && (delete zh[c][e], zh[c].Yh--))), ((((0 == zh[c].Yh)) && delete zh[c]));\n            }\n        ;\n        ;\n            delete _.Ch[a.key];\n            return !0;\n        };\n        _.Gh = function(a, b, c) {\n            var d = zh;\n            return ((((((b in d)) && (d = d[b], ((((c in d)) && (d = d[c], a = (0, _.Xa)(a), d[a])))))) ? d[a] : null));\n        };\n        _.Jh = function(a, b, c, d) {\n            if ((0, _.th)(a)) {\n                return Kh(a, b, c, d);\n            }\n        ;\n        ;\n            var e = zh;\n            return ((((((b in e)) && (e = e[b], ((c in e))))) ? Lh(e[c], a, b, c, d) : !0));\n        };\n        var Lh = function(a, b, c, d, e) {\n            c = 1;\n            b = (0, _.Xa)(b);\n            if (a[b]) {\n                for (a = (0, _.Mb)(a[b]), b = 0; ((b < a.length)); b++) {\n                    (((((d = a[b]) && !d.Kx)) && (c &= ((!1 !== Mh(d, e))))));\n                ;\n                };\n            }\n        ;\n        ;\n            return Boolean(c);\n        };\n        var Mh = function(a, b) {\n            var c = a.nu, d = ((a.gA || a.src));\n            ((a.nC && (0, _.Hh)(a)));\n            return c.call(d, b);\n        };\n        var Qaa = function(a, b) {\n            if (a.Kx) {\n                return !0;\n            }\n        ;\n        ;\n            var c = a.type, d = zh;\n            if (!((c in d))) {\n                return !0;\n            }\n        ;\n        ;\n            var d = d[c], e, f;\n            if (!Dh) {\n                e = ((b || (0, _.Fa)(\"window.JSBNG__event\")));\n                var g = ((!0 in d)), h = ((!1 in d));\n                if (g) {\n                    if (((((0 > e.keyCode)) || ((void 0 != e.returnValue))))) {\n                        return !0;\n                    }\n                ;\n                ;\n                    n:\n                    {\n                        var k = !1;\n                        if (((0 == e.keyCode))) {\n                            try {\n                                e.keyCode = -1;\n                                break n;\n                            } catch (l) {\n                                k = !0;\n                            };\n                        }\n                    ;\n                    ;\n                        if (((k || ((void 0 == e.returnValue))))) {\n                            e.returnValue = !0;\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                }\n            ;\n            ;\n                k = new _.qh;\n                k.init(e, this);\n                e = !0;\n                try {\n                    if (g) {\n                        for (var n = [], p = k.currentTarget; p; p = p.parentNode) {\n                            n.push(p);\n                        ;\n                        };\n                    ;\n                        f = d[!0];\n                        for (var m = ((n.length - 1)); ((!k.nA && ((0 <= m)))); m--) {\n                            k.currentTarget = n[m], e &= Lh(f, n[m], c, !0, k);\n                        ;\n                        };\n                    ;\n                        if (h) {\n                            for (f = d[!1], m = 0; ((!k.nA && ((m < n.length)))); m++) {\n                                k.currentTarget = n[m], e &= Lh(f, n[m], c, !1, k);\n                            ;\n                            };\n                        }\n                    ;\n                    ;\n                    }\n                     else e = Mh(a, k);\n                ;\n                ;\n                } finally {\n                    ((n && (n.length = 0)));\n                };\n            ;\n                return e;\n            }\n        ;\n        ;\n            c = new _.qh(b, this);\n            return e = Mh(a, c);\n        };\n        _.xh = function(a) {\n            return (((0, _.Va)(a) ? a : ((a[Nh] || (a[Nh] = function(b) {\n                return a.handleEvent(b);\n            })))));\n        };\n        _.Oh = function() {\n            this.L = {\n            };\n            this.mr = this;\n        };\n        var Ph = function(a, b, c, d, e, f) {\n            var g = ((a.L[b] || (a.L[b] = []))), h = (0, _.Qh)(g, c, e, f);\n            if (((-1 < h))) {\n                return a = g[h], ((d || (a.nC = !1))), a;\n            }\n        ;\n        ;\n            a = new vh(c, null, a, b, !!e, f);\n            a.nC = d;\n            g.push(a);\n            return a;\n        };\n        var Ih = function(a, b) {\n            var c = b.type;\n            if (!((c in a.L))) {\n                return !1;\n            }\n        ;\n        ;\n            if (c = (0, _.Ib)(a.L[c], b)) {\n                b.Kx = !0;\n            }\n        ;\n        ;\n            return c;\n        };\n        var Kh = function(a, b, c, d) {\n            if (!((b in a.L))) {\n                return !0;\n            }\n        ;\n        ;\n            var e = !0;\n            b = (0, _.Mb)(a.L[b]);\n            for (var f = 0; ((f < b.length)); ++f) {\n                var g = b[f];\n                if (((((g && !g.Kx)) && ((g.capture == c))))) {\n                    var h = g.nu, k = ((g.gA || g.src));\n                    ((g.nC && Ih(a, g)));\n                    e = ((((!1 !== h.call(k, d))) && e));\n                }\n            ;\n            ;\n            };\n        ;\n            return ((e && ((!1 != d.bS))));\n        };\n        _.Qh = function(a, b, c, d) {\n            for (var e = 0; ((e < a.length)); ++e) {\n                var f = a[e];\n                if (((((((f.nu == b)) && ((f.capture == !!c)))) && ((f.gA == d))))) {\n                    return e;\n                }\n            ;\n            ;\n            };\n        ;\n            return -1;\n        };\n        _.Rh = function(a, b) {\n            _.Oh.call(this);\n            this.B = ((a || 1));\n            this.A = ((b || _.Ca));\n            this.D = (0, _.$a)(this.DW, this);\n            this.H = (0, _.Ve)();\n        };\n        _.Sh = function(a, b, c) {\n            if ((0, _.Va)(a)) {\n                ((c && (a = (0, _.$a)(a, c))));\n            }\n             else {\n                if (((a && ((\"function\" == typeof a.handleEvent))))) {\n                    a = (0, _.$a)(a.handleEvent, a);\n                }\n                 else {\n                    throw Error(\"Invalid listener argument\");\n                }\n            ;\n            }\n        ;\n        ;\n            return ((((2147483647 < b)) ? -1 : _.Ca.JSBNG__setTimeout(a, ((b || 0)))));\n        };\n        var Th = function(a) {\n            var b = _.Ca.JSBNG__document;\n            if (((((b && !b.createEvent)) && b.createEventObject))) {\n                try {\n                    return b.createEventObject(a);\n                } catch (c) {\n                    return a;\n                };\n            }\n             else {\n                return a;\n            }\n        ;\n        ;\n        };\n        var Uh = function(a, b, c, d) {\n            _.Oh.call(this);\n            this.V = a.replace(Raa, \"_\");\n            this.Da = a;\n            this.aF = ((b || null));\n            this.$ = ((c ? Th(c) : null));\n            this.H = [];\n            this.T = {\n            };\n            this.ca = this.Q = ((d || (0, _.Ve)()));\n            this.A = {\n            };\n            this.A[\"main-actionflow-branch\"] = 1;\n            this.J = new _.gf;\n            this.D = !1;\n            this.B = {\n            };\n            this.M = {\n            };\n            this.va = !1;\n            ((((c && ((b && ((\"click\" == c.type)))))) && this.action(b)));\n            Vh.push(this);\n        };\n        var Wh = function(a, b, c, d) {\n            if (((a.D || !a.A[b]))) a.Uz(\"done\", b);\n             else {\n                ((c && a.tick(c, d)));\n                a.A[b]--;\n                ((((0 == a.A[b])) && delete a.A[b]));\n                if (b = (0, _.fc)(a.A)) {\n                    ((a.va ? b = !0 : (((((0 < a.J.ys())) && (a.M.dup = a.J.ot().join(\"|\")))), b = new Xh(\"beforedone\", a), ((((a.JSBNG__dispatchEvent(b) && Yh.JSBNG__dispatchEvent(b))) ? ((((c = Saa(a.M)) && (a.B.cad = c))), b.type = \"done\", b = Yh.JSBNG__dispatchEvent(b)) : b = !1)))));\n                }\n            ;\n            ;\n                ((b && (a.D = !0, (0, _.Ib)(Vh, a), a.aF = null, a.$ = null, a.dispose())));\n            }\n        ;\n        ;\n        };\n        var Taa = function(a, b, c, d) {\n            ((a.D && a.Uz(\"branch\", b)));\n            ((c && a.tick(c, d)));\n            ((a.A[b] ? a.A[b]++ : a.A[b] = 1));\n        };\n        var Zh = function(a) {\n            ((a.D && a.Uz(\"tick\")));\n        };\n        var Saa = function(a) {\n            var b = [];\n            (0, _.$b)(a, function(a, d) {\n                var e = (0, window.encodeURIComponent)(d);\n                (0, window.encodeURIComponent)(a).replace(/%7C/g, \"|\");\n                b.push(((((e + \":\")) + a)));\n            });\n            return b.join(\",\");\n        };\n        var Uaa = function(a, b, c) {\n            Zh(a);\n            a.M[b] = c.toString().replace(/[:;,\\s]/g, \"_\");\n        };\n        var Vaa = function(a, b) {\n            for (var c = a; ((c && ((1 == c.nodeType)))); c = c.parentNode) {\n                b(c);\n            ;\n            };\n        ;\n        };\n        var Xh = function(a, b) {\n            _.nh.call(this, a, b);\n        };\n        var $h = function(a, b) {\n            this.B = {\n            };\n            this.H = {\n            };\n            this.V = {\n            };\n            this.D = null;\n            this.J = {\n            };\n            this.A = [];\n            this.T = ((a || Waa));\n            this.M = b;\n        };\n        var Waa = function(a) {\n            return new Uh(a.action, a.actionElement, a.JSBNG__event);\n        };\n        var Xaa = function(a, b, c, d) {\n            (0, _.$b)(d, (0, _.$a)(function(a, d) {\n                var g = ((c ? (0, _.$a)(a, c) : a));\n                ((b ? this.B[((((b + \".\")) + d))] = g : this.B[d] = g));\n            }, a));\n            ai(a);\n        };\n        var ai = function(a) {\n            ((((a.L && ((0 != a.A.length)))) && _.Ca.JSBNG__setTimeout((0, _.$a)(function() {\n                this.L(this.A, this);\n            }, a), 0)));\n        };\n        var Yaa = function(a, b) {\n            a.L = b;\n            ai(a);\n        };\n        _.bi = function(a) {\n            var b;\n            b = a.JSBNG__event;\n            var c = a.eventType, d = ((c || b.type));\n            if (((((((\"keypress\" == d)) || ((\"keydown\" == d)))) || ((\"keyup\" == d))))) {\n                if (((((_.Xd && !(0, _.Ec)(\"12.14\"))) || _.ci))) d = di(b, c), d.ctrlKey = b.ctrlKey, d.altKey = b.altKey, d.shiftKey = b.shiftKey, d.metaKey = b.metaKey, d.keyCode = b.keyCode, d.charCode = b.charCode, b = d;\n                 else {\n                    if (window.JSBNG__document.createEvent) {\n                        if (d = window.JSBNG__document.createEvent(\"JSBNG__KeyboardEvent\"), d.initKeyboardEvent) {\n                            var e;\n                            e = b.ctrlKey;\n                            var f = b.metaKey, g = b.shiftKey, h = [];\n                            ((b.altKey && h.push(\"Alt\")));\n                            ((e && h.push(\"Control\")));\n                            ((f && h.push(\"Meta\")));\n                            ((g && h.push(\"Shift\")));\n                            e = h.join(\" \");\n                            d.initKeyboardEvent(((c || b.type)), !0, !0, window, b.charCode, b.keyCode, b.JSBNG__location, e, b.repeat, b.locale);\n                            if (((_.jd || ((_.Jc && (0, _.Ec)(\"9.0\")))))) {\n                                b = (0, _.tg)(b.keyCode), Object.defineProperty(d, \"keyCode\", {\n                                    get: b\n                                }), Object.defineProperty(d, \"which\", {\n                                    get: b\n                                });\n                            }\n                        ;\n                        ;\n                        }\n                         else d.initKeyEvent(((c || b.type)), !0, !0, window, b.ctrlKey, b.altKey, b.shiftKey, b.metaKey, b.keyCode, b.charCode);\n                    ;\n                    }\n                     else {\n                        d = window.JSBNG__document.createEventObject(), d.type = ((c || b.type)), d.repeat = b.repeat, d.ctrlKey = b.ctrlKey, d.altKey = b.altKey, d.shiftKey = b.shiftKey, d.metaKey = b.metaKey, d.keyCode = b.keyCode, d.charCode = b.charCode;\n                    }\n                ;\n                ;\n                    b = d;\n                }\n            ;\n            }\n             else {\n                ((((((((((((((\"click\" == d)) || ((\"dblclick\" == d)))) || ((\"mousedown\" == d)))) || ((\"mouseover\" == d)))) || ((\"mouseout\" == d)))) || ((\"mousemove\" == d)))) ? (((window.JSBNG__document.createEvent ? (d = window.JSBNG__document.createEvent(\"JSBNG__MouseEvent\"), d.initMouseEvent(((c || b.type)), !0, !0, window, ((b.detail || 1)), ((b.JSBNG__screenX || 0)), ((b.JSBNG__screenY || 0)), ((b.clientX || 0)), ((b.clientY || 0)), ((b.ctrlKey || !1)), ((b.altKey || !1)), ((b.shiftKey || !1)), ((b.metaKey || !1)), ((b.button || 0)), ((b.relatedTarget || null)))) : (d = window.JSBNG__document.createEventObject(), d.type = ((c || b.type)), d.clientX = b.clientX, d.clientY = b.clientY, d.button = b.button, d.detail = b.detail, d.ctrlKey = b.ctrlKey, d.altKey = b.altKey, d.shiftKey = b.shiftKey, d.metaKey = b.metaKey))), b = d) : b = di(b, c)));\n            }\n        ;\n        ;\n            a = a.targetElement;\n            ((a.JSBNG__dispatchEvent ? a.JSBNG__dispatchEvent(b) : a.fireEvent(((\"JSBNG__on\" + b.type)), b)));\n        };\n        var di = function(a, b) {\n            var c;\n            ((window.JSBNG__document.createEvent ? (c = window.JSBNG__document.createEvent(\"JSBNG__Event\"), c.initEvent(((b || a.type)), !0, !0)) : (c = window.JSBNG__document.createEventObject(), c.type = ((b || a.type)))));\n            return c;\n        };\n        var ei = function(a) {\n            var b = a.__r_ctrl;\n            ((((b && !b.fM)) && (b = null)));\n            ((b || (b = a.getAttribute(\"data-rtid\"), (((b = _.fi[b]) && (a.__r_ctrl = b))))));\n            return b;\n        };\n        var Zaa = function(a, b) {\n            for (var c = 0; ((c < a.length)); ) {\n                var d = a[c];\n                ((((b.B.hasOwnProperty(d.action) || b.H.hasOwnProperty(d.action.split(\".\")[0]))) ? ((0, _.bi)(d), (0, _.Ob)(a, c, 1)) : c++));\n            };\n        ;\n        };\n        var $aa = function(a, b, c) {\n            var d = \"\";\n            ((c && (d += ((c + \":\")))));\n            return d += ((((a + \".\")) + b));\n        };\n        var aba = function(a, b, c) {\n            gi[$aa(a, b)] = c;\n            var d = {\n            };\n            d[b] = function(a) {\n                var b = a.aF, d = (0, _.mh)(b), h = a.JSBNG__event();\n                if (((c(b, d, h, a) && (a = hi[h.type])))) {\n                    for (b = 0; ((b < a.length)); ++b) {\n                        a[b].Un(h);\n                    ;\n                    };\n                }\n            ;\n            ;\n            };\n            Xaa(ii, a, null, d);\n        };\n        _.ji = function(a, b, c) {\n            if (window.google.jsad) {\n                {\n                    var fin32keys = ((window.top.JSBNG_Replay.forInKeys)((b))), fin32i = (0);\n                    var d;\n                    for (; (fin32i < fin32keys.length); (fin32i++)) {\n                        ((d) = (fin32keys[fin32i]));\n                        {\n                            aba(a, d, b[d]);\n                        ;\n                        };\n                    };\n                };\n            ;\n                if (!c) {\n                    {\n                        var fin33keys = ((window.top.JSBNG_Replay.forInKeys)((ki[a] = ((ki[a] || [])), b))), fin33i = (0);\n                        (0);\n                        for (; (fin33i < fin33keys.length); (fin33i++)) {\n                            ((d) = (fin33keys[fin33i]));\n                            {\n                                (((0, _.Fb)(ki[a], d) || (0, _.Hb)(ki[a], d)));\n                            ;\n                            };\n                        };\n                    };\n                }\n            ;\n            ;\n            }\n        ;\n        ;\n        };\n        _.li = function(a, b) {\n            for (var c = 0; ((c < b.length)); ++c) {\n                var d = b[c], e = null, e = ((a ? ((((a + \".\")) + d)) : d));\n                delete ii.B[e];\n                ((((a in ki)) && ((0, _.Ib)(ki[a], b[c]), ((((0 == ki[a].length)) && delete ki[a])))));\n            };\n        ;\n        };\n        var mi = function(a, b) {\n            var c = hi[a];\n            if (!c) {\n                return null;\n            }\n        ;\n        ;\n            for (var d = 0; ((d < c.length)); ++d) {\n                if (((c[d].Un == b))) {\n                    return c[d];\n                }\n            ;\n            ;\n            };\n        ;\n            return null;\n        };\n        var bba = function(a, b) {\n            try {\n                (0, _.ah)(b);\n            } catch (c) {\n            \n            };\n        ;\n        };\n        var cba = function(a) {\n            var b = (0, _.Mf)();\n            ((b && b.Mb()));\n            ((((window.google.j && window.google.j.init)) || ((a && (0, _.Yf)(a.href)))));\n            return !0;\n        };\n        var dba = function(a, b) {\n            (0, _.Yf)(b.url);\n        };\n        var eba = function(a, b) {\n            window.google.log(b.ct, ((b.data || \"\")), b.src);\n        };\n        var fba = function(a, b) {\n            window.open(b.url, ((b.target || \"_blank\")), ((b.opt || \"\")));\n        };\n        var gba = function(a) {\n            (((0, _.Va)(a.select) && a.select()));\n        };\n        var ni = function() {\n        \n        };\n        var oi = function(a, b) {\n            this.J = a;\n            this.H = b;\n        };\n        _.pi = function() {\n            return _.pi.A.A();\n        };\n        var qi = function() {\n        \n        };\n        var ri = function(a) {\n            if (_.pi.B) {\n                return \"\";\n            }\n        ;\n        ;\n            if (((((!a.H && ((\"undefined\" == typeof window.JSBNG__XMLHttpRequest)))) && ((\"undefined\" != typeof window.ActiveXObject))))) {\n                for (var b = [\"MSXML2.XMLHTTP.6.0\",\"MSXML2.XMLHTTP.3.0\",\"MSXML2.XMLHTTP\",\"Microsoft.XMLHTTP\",], c = 0; ((c < b.length)); c++) {\n                    var d = b[c];\n                    try {\n                        return new window.ActiveXObject(d), a.H = d;\n                    } catch (e) {\n                    \n                    };\n                ;\n                };\n            ;\n                throw Error(\"Could not create ActiveXObject. ActiveX might be disabled, or MSXML might not be installed\");\n            }\n        ;\n        ;\n            return a.H;\n        };\n        var hba = function(a, b) {\n            var c = b.xhr, d = (0, _.pi)();\n            d.open(\"GET\", c, !0);\n            d.send(\"\");\n            c = (0, _.ad)(\"nossln\");\n            (0, _.Ce)(c, !1);\n        };\n        _.si = function(a) {\n            var b = {\n            };\n            if (a) {\n                a = (0, window.decodeURIComponent)(a.replace(/\\+/g, \" \"));\n                a = a.split(\",\");\n                for (var c = 0, d; d = a[c++]; ) {\n                    d = d.split(\":\");\n                    var e = ((d[1] || \"\")), e = e.replace(/_3/g, \":\").replace(/_2/g, \",\").replace(/_1/g, \"_\");\n                    b[d[0]] = e;\n                };\n            ;\n            }\n        ;\n        ;\n            return b;\n        };\n        _.ti = function(a) {\n            return ((((a && (0, _.Fd)(a))) ? (((0, _.kh)(a, \"ved\") || \"\")) : \"\"));\n        };\n        _.ui = function(a) {\n            if (a) {\n                for (var b = 0, c; c = a.childNodes[b]; b++) {\n                    if (c = (0, _.ti)(c)) {\n                        return c;\n                    }\n                ;\n                ;\n                };\n            }\n        ;\n        ;\n            return \"\";\n        };\n        _.vi = function() {\n            this.A = [];\n            this.B = \"\";\n        };\n        _.wi = function(a, b, c) {\n            a.A.push({\n                KF: b,\n                targetElement: ((c || \"\")),\n                bH: 0\n            });\n        };\n        var xi = function(a, b, c) {\n            a.A.push({\n                KF: ((b || \"\")),\n                targetElement: ((c || \"\")),\n                bH: 1\n            });\n        };\n        var yi = function(a, b) {\n            var c = \"\";\n            ((b && (c = ((((\"string\" == typeof b)) ? b : window.google.getEI(b))))));\n            return ((((c && ((c != a.B)))) ? c : \"\"));\n        };\n        _.zi = function(a) {\n            for (var b = a.A.length, c = [], d, e, f = 0; ((f < b)); ++f) {\n                (((((d = yi(a, a.A[f].targetElement)) || ((0 != a.A[f].bH)))) ? ((((1 == a.A[f].bH)) ? c.push(((((((a.A[f].KF + \".\")) + d)) + \".h\"))) : ((((2 == a.A[f].bH)) ? (e = (((e = yi(a, a.A[f].Q3)) ? ((\".\" + e)) : \"\")), ((((a.A[f].MP && a.A[f].MP)) && c.push(((((((((((a.A[f].KF + \".\")) + d)) + \".c.\")) + a.A[f].MP)) + e)))))) : c.push(((((a.A[f].KF + \".\")) + d))))))) : c.push(a.A[f].KF)));\n            ;\n            };\n        ;\n            a = ((\"&vet=1\" + c.join(\";\")));\n            return a = ((((0 < b)) ? a : \"\"));\n        };\n        _.Ai = function(a) {\n            for (var b = 0; ((b < _.Bi.length)); b += 2) {\n                a = a.replace(RegExp(_.Bi[b], \"g\"), _.Bi[((b + 1))]);\n            ;\n            };\n        ;\n            return a;\n        };\n        _.Ci = function(a) {\n            ((a || (a = window.JSBNG__event)));\n            return ((a.target || a.srcElement));\n        };\n        _.Di = function(a) {\n            a = ((a || window.JSBNG__event));\n            ((_.sc.Hc ? a.cancelBubble = !0 : ((a.stopPropagation && a.stopPropagation()))));\n        };\n        var Ei = function(a) {\n            (0, _.Ce)(a, !1);\n            ((Fi[a.id] && (0, _.af)(window.JSBNG__document.body, \"click\", Fi[a.id])));\n        };\n        _.Gi = function(a, b, c, d, e, f, g) {\n            var h = ((a ? ((\"&ved=\" + a)) : \"\")), k = ((b ? window.google.getEI(b) : window.google.kEI)), l = ((c || []));\n            d = ((d || []));\n            e = ((e || []));\n            f = ((f || \"\"));\n            g = ((g || \"\"));\n            var n = new _.vi, p = l.length, m = e.length;\n            n.B = k;\n            for (k = 0; ((k < p)); k++) {\n                ((((((k >= m)) || e[k])) ? (0, _.wi)(n, l[k], d[k]) : xi(n, l[k], d[k])));\n            ;\n            };\n        ;\n            ((((((0 == p)) && ((((0 < e.length)) && !e[0])))) && xi(n)));\n            l = (0, _.zi)(n);\n            (((k = ((b || ((d && d[0]))))) ? window.google.log(f, ((((g + h)) + l)), \"\", k) : window.google.ml(Error(\"lbved\"), !1, {\n                ved: a,\n                trE: b,\n                vet: ((c && c[0])),\n                taE: ((d && d[0])),\n                ct: f,\n                data: g\n            })));\n        };\n        _.Hi = function(a, b, c, d, e) {\n            var f = ((a ? (0, _.ti)(a) : \"\")), g = [];\n            if (b) {\n                for (var h = 0, k; k = b[h]; h++) {\n                    (((k = (0, _.ti)(k)) && g.push(k)));\n                ;\n                };\n            }\n        ;\n        ;\n            (0, _.Gi)(f, a, g, b, c, d, e);\n        };\n        _.Ii = function() {\n            var a = _.Ji.value;\n            _.Ki = ((a ? (0, _.kf)(a) : {\n            }));\n        };\n        _.Li = ((_.Li || {\n        }));\n        _.Ca = this;\n        Ya = ((\"closure_uid_\" + ((((1000000000 * Math.JSBNG__random())) >>> 0))));\n        aaa = 0;\n        _.Ve = ((JSBNG__Date.now || function() {\n            return +new JSBNG__Date;\n        }));\n        Function.prototype.bind = ((Function.prototype.bind || function(a, b) {\n            if (((1 < arguments.length))) {\n                var c = Array.prototype.slice.call(arguments, 1);\n                c.unshift(this, a);\n                return _.$a.apply(null, c);\n            }\n        ;\n        ;\n            return (0, _.$a)(this, a);\n        }));\n        (0, _.db)(_.fb, Error);\n        _.fb.prototype.JSBNG__name = \"CustomError\";\n        var daa;\n        var ub;\n        var tb;\n        var sb;\n        var rb;\n        rb = /&/g;\n        sb = /</g;\n        tb = />/g;\n        ub = /\\\"/g;\n        daa = /[&<>\\\"]/;\n        _.iba = ((((2147483648 * Math.JSBNG__random())) | 0));\n        var Kb;\n        Kb = Array.prototype;\n        _.Gb = ((Kb.indexOf ? function(a, b, c) {\n            return Kb.indexOf.call(a, b, c);\n        } : function(a, b, c) {\n            c = ((((null == c)) ? 0 : ((((0 > c)) ? Math.max(0, ((a.length + c))) : c))));\n            if ((0, _.Ra)(a)) {\n                return (((((0, _.Ra)(b) && ((1 == b.length)))) ? a.indexOf(b, c) : -1));\n            }\n        ;\n        ;\n            for (; ((c < a.length)); c++) {\n                if (((((c in a)) && ((a[c] === b))))) {\n                    return c;\n                }\n            ;\n            ;\n            };\n        ;\n            return -1;\n        }));\n        _.Zb = ((Kb.forEach ? function(a, b, c) {\n            Kb.forEach.call(a, b, c);\n        } : function(a, b, c) {\n            for (var d = a.length, e = (((0, _.Ra)(a) ? a.split(\"\") : a)), f = 0; ((f < d)); f++) {\n                ((((f in e)) && b.call(c, e[f], f, a)));\n            ;\n            };\n        ;\n        }));\n        _.Pc = ((Kb.filter ? function(a, b, c) {\n            return Kb.filter.call(a, b, c);\n        } : function(a, b, c) {\n            for (var d = a.length, e = [], f = 0, g = (((0, _.Ra)(a) ? a.split(\"\") : a)), h = 0; ((h < d)); h++) {\n                if (((h in g))) {\n                    var k = g[h];\n                    ((b.call(c, k, h, a) && (e[f++] = k)));\n                }\n            ;\n            ;\n            };\n        ;\n            return e;\n        }));\n        _.Rg = ((Kb.map ? function(a, b, c) {\n            return Kb.map.call(a, b, c);\n        } : function(a, b, c) {\n            for (var d = a.length, e = Array(d), f = (((0, _.Ra)(a) ? a.split(\"\") : a)), g = 0; ((g < d)); g++) {\n                ((((g in f)) && (e[g] = b.call(c, f[g], g, a))));\n            ;\n            };\n        ;\n            return e;\n        }));\n        _.Ig = ((Kb.some ? function(a, b, c) {\n            return Kb.some.call(a, b, c);\n        } : function(a, b, c) {\n            for (var d = a.length, e = (((0, _.Ra)(a) ? a.split(\"\") : a)), f = 0; ((f < d)); f++) {\n                if (((((f in e)) && b.call(c, e[f], f, a)))) {\n                    return !0;\n                }\n            ;\n            ;\n            };\n        ;\n            return !1;\n        }));\n        _.ff = ((Kb.every ? function(a, b, c) {\n            return Kb.every.call(a, b, c);\n        } : function(a, b, c) {\n            for (var d = a.length, e = (((0, _.Ra)(a) ? a.split(\"\") : a)), f = 0; ((f < d)); f++) {\n                if (((((f in e)) && !b.call(c, e[f], f, a)))) {\n                    return !1;\n                }\n            ;\n            ;\n            };\n        ;\n            return !0;\n        }));\n        var Xb = ((((\"StopIteration\" in _.Ca)) ? _.Ca.StopIteration : Error(\"StopIteration\")));\n        _.Vb.prototype.next = function() {\n            throw Xb;\n        };\n        _.Vb.prototype.nx = function() {\n            return this;\n        };\n        var mc = \"constructor hasOwnProperty isPrototypeOf propertyIsEnumerable toLocaleString toString valueOf\".split(\" \");\n        _.q = _.oc.prototype;\n        _.q.Yh = 0;\n        _.q.QF = 0;\n        _.q.ys = (0, _.ma)(\"Yh\");\n        _.q.ot = function() {\n            pc(this);\n            for (var a = [], b = 0; ((b < this.A.length)); b++) {\n                a.push(this.Qc[this.A[b]]);\n            ;\n            };\n        ;\n            return a;\n        };\n        _.q.vw = function() {\n            pc(this);\n            return this.A.concat();\n        };\n        _.q.qG = function(a) {\n            for (var b = 0; ((b < this.A.length)); b++) {\n                var c = this.A[b];\n                if ((((0, _.qc)(this.Qc, c) && ((this.Qc[c] == a))))) {\n                    return !0;\n                }\n            ;\n            ;\n            };\n        ;\n            return !1;\n        };\n        _.q.equals = function(a, b) {\n            if (((this === a))) {\n                return !0;\n            }\n        ;\n        ;\n            if (((this.Yh != a.ys()))) {\n                return !1;\n            }\n        ;\n        ;\n            var c = ((b || gaa));\n            pc(this);\n            for (var d, e = 0; d = this.A[e]; e++) {\n                if (!c(this.get(d), a.get(d))) {\n                    return !1;\n                }\n            ;\n            ;\n            };\n        ;\n            return !0;\n        };\n        _.q.isEmpty = function() {\n            return ((0 == this.Yh));\n        };\n        _.q.clear = function() {\n            this.Qc = {\n            };\n            this.QF = this.Yh = this.A.length = 0;\n        };\n        _.q.remove = function(a) {\n            return (((0, _.qc)(this.Qc, a) ? (delete this.Qc[a], this.Yh--, this.QF++, ((((this.A.length > ((2 * this.Yh)))) && pc(this))), !0) : !1));\n        };\n        _.q.get = function(a, b) {\n            return (((0, _.qc)(this.Qc, a) ? this.Qc[a] : b));\n        };\n        _.q.set = function(a, b) {\n            (((0, _.qc)(this.Qc, a) || (this.Yh++, this.A.push(a), this.QF++)));\n            this.Qc[a] = b;\n        };\n        _.q.clone = function() {\n            return new _.oc(this);\n        };\n        _.q.nx = function(a) {\n            pc(this);\n            var b = 0, c = this.A, d = this.Qc, e = this.QF, f = this, g = new _.Vb;\n            g.next = function() {\n                for (; ; ) {\n                    if (((e != f.QF))) {\n                        throw Error(\"The map has changed since the iterator was created\");\n                    }\n                ;\n                ;\n                    if (((b >= c.length))) {\n                        throw Xb;\n                    }\n                ;\n                ;\n                    var g = c[b++];\n                    return ((a ? g : d[g]));\n                };\n            ;\n            };\n            return g;\n        };\n        var Ac;\n        _.sc = {\n            Hc: !1,\n            vx: !1,\n            Yr: !1,\n            JSBNG__opera: !1\n        };\n        _.tc = {\n            Hc: !1,\n            qw: !1,\n            Fz: !1,\n            Oq: !1,\n            xt: !1,\n            kw: !1,\n            WJ: !1,\n            gB: !1,\n            Fq: !1,\n            Eq: !1,\n            JSBNG__opera: !1,\n            bF: !1\n        };\n        Ac = null;\n        _.vc = \"\";\n        _.uc = \"\";\n        (0, _.za)(\"google.browser.init\", rc, void 0);\n        (0, _.za)(\"google.browser.compareVersions\", _.wc, void 0);\n        (0, _.za)(\"google.browser.isEngineVersion\", _.xc, void 0);\n        (0, _.za)(\"google.browser.isProductVersion\", _.yc, void 0);\n        (0, _.za)(\"google.browser.getBrowserDimension\", _.zc, void 0);\n        (0, _.za)(\"google.browser.Dimension\", {\n            HEIGHT_WITH_SCROLLBARS: 0,\n            HEIGHT_WITHOUT_SCROLLBARS: 1,\n            WIDTH_WITH_SCROLLBARS: 2,\n            WIDTH_WITHOUT_SCROLLBARS: 3\n        }, void 0);\n        rc(((window.google.ua || window.JSBNG__navigator.userAgent)));\n        var aj;\n        var Yi;\n        var Xi;\n        var ke;\n        var Qi;\n        var Pi;\n        var Oi;\n        var Ni;\n        var Mi;\n        Qi = Pi = Oi = Ni = Mi = !1;\n        var Vi;\n        if (Vi = Bc()) {\n            var jba = Cc();\n            Mi = ((0 == Vi.indexOf(\"Opera\")));\n            Ni = ((!Mi && ((-1 != Vi.indexOf(\"MSIE\")))));\n            Pi = (((Oi = ((!Mi && ((-1 != Vi.indexOf(\"WebKit\")))))) && ((-1 != Vi.indexOf(\"Mobile\")))));\n            Qi = ((((!Mi && !Oi)) && ((\"Gecko\" == jba.product))));\n        }\n    ;\n    ;\n        _.Xd = Mi;\n        _.Jc = Ni;\n        _.Wd = Qi;\n        _.jd = Oi;\n        _.Wi = Pi;\n        Xi = Cc();\n        Yi = ((((Xi && Xi.platform)) || \"\"));\n        _.ie = ((-1 != Yi.indexOf(\"Mac\")));\n        _.Ri = ((-1 != Yi.indexOf(\"Win\")));\n        _.Si = ((-1 != Yi.indexOf(\"Linux\")));\n        ke = ((!!Cc() && ((-1 != ((Cc().appVersion || \"\")).indexOf(\"X11\")))));\n        var Zi = Bc();\n        _.Ti = ((!!Zi && ((0 <= Zi.indexOf(\"Android\")))));\n        _.Ui = ((!!Zi && ((0 <= Zi.indexOf(\"iPhone\")))));\n        _.$i = ((!!Zi && ((0 <= Zi.indexOf(\"iPad\")))));\n        n:\n        {\n            var bj = \"\", cj;\n            if (((_.Xd && _.Ca.JSBNG__opera))) {\n                var dj = _.Ca.JSBNG__opera.version, bj = ((((\"function\" == typeof dj)) ? dj() : dj));\n            }\n             else {\n                if (((_.Wd ? cj = /rv\\:([^\\);]+)(\\)|;)/ : ((_.Jc ? cj = /MSIE\\s+([^\\);]+)(\\)|;)/ : ((_.jd && (cj = /WebKit\\/(\\S+)/))))))), cj) {\n                    var ej = cj.exec(Bc()), bj = ((ej ? ej[1] : \"\"));\n                }\n            ;\n            }\n        ;\n        ;\n            if (_.Jc) {\n                var fj = Dc();\n                if (((fj > (0, window.parseFloat)(bj)))) {\n                    aj = String(fj);\n                    break n;\n                }\n            ;\n            ;\n            }\n        ;\n        ;\n            aj = bj;\n        };\n    ;\n        var Hc = aj, Gc = {\n        }, gj = _.Ca.JSBNG__document, haa = ((((gj && _.Jc)) ? ((Dc() || ((((\"CSS1Compat\" == gj.compatMode)) ? (0, window.parseInt)(Hc, 10) : 5)))) : void 0));\n        var Xc, iaa = ((!_.Jc || (0, _.Ic)(9))), kaa = ((((((!_.Wd && !_.Jc)) || ((_.Jc && (0, _.Ic)(9))))) || ((_.Wd && (0, _.Ec)(\"1.9.1\"))))), Ld = ((_.Jc && !(0, _.Ec)(\"9\"))), laa = ((((_.Jc || _.Xd)) || _.jd));\n        _.q = _.Rc.prototype;\n        _.q.clone = function() {\n            return new _.Rc(this.x, this.y);\n        };\n        _.q.ceil = function() {\n            this.x = Math.ceil(this.x);\n            this.y = Math.ceil(this.y);\n            return this;\n        };\n        _.q.floor = function() {\n            this.x = Math.floor(this.x);\n            this.y = Math.floor(this.y);\n            return this;\n        };\n        _.q.round = function() {\n            this.x = Math.round(this.x);\n            this.y = Math.round(this.y);\n            return this;\n        };\n        _.q.translate = function(a, b) {\n            ((((a instanceof _.Rc)) ? (this.x += a.x, this.y += a.y) : (this.x += a, (((0, _.Sa)(b) && (this.y += b))))));\n            return this;\n        };\n        _.q.scale = function(a, b) {\n            var c = (((0, _.Sa)(b) ? b : a));\n            this.x *= a;\n            this.y *= c;\n            return this;\n        };\n        _.q = _.Sc.prototype;\n        _.q.clone = function() {\n            return new _.Sc(this.width, this.height);\n        };\n        _.q.isEmpty = function() {\n            return !((this.width * this.height));\n        };\n        _.q.ceil = function() {\n            this.width = Math.ceil(this.width);\n            this.height = Math.ceil(this.height);\n            return this;\n        };\n        _.q.floor = function() {\n            this.width = Math.floor(this.width);\n            this.height = Math.floor(this.height);\n            return this;\n        };\n        _.q.round = function() {\n            this.width = Math.round(this.width);\n            this.height = Math.round(this.height);\n            return this;\n        };\n        _.q.scale = function(a, b) {\n            var c = (((0, _.Sa)(b) ? b : a));\n            this.width *= a;\n            this.height *= c;\n            return this;\n        };\n        var cd = {\n            cellpadding: \"cellPadding\",\n            cellspacing: \"cellSpacing\",\n            colspan: \"colSpan\",\n            frameborder: \"frameBorder\",\n            height: \"height\",\n            maxlength: \"maxLength\",\n            role: \"role\",\n            rowspan: \"rowSpan\",\n            type: \"type\",\n            usemap: \"useMap\",\n            valign: \"vAlign\",\n            width: \"width\"\n        }, maa = {\n            SCRIPT: 1,\n            STYLE: 1,\n            HEAD: 1,\n            IFRAME: 1,\n            OBJECT: 1\n        }, Nd = {\n            IMG: \" \",\n            BR: \"\\u000a\"\n        };\n        _.q = _.Vc.prototype;\n        _.q.W = function(a) {\n            return (((0, _.Ra)(a) ? this.A.getElementById(a) : a));\n        };\n        _.q.Qe = function(a, b, c) {\n            return md(this.A, arguments);\n        };\n        _.q.createElement = function(a) {\n            return this.A.createElement(a);\n        };\n        _.q.getWindow = function() {\n            return ((this.A.parentWindow || this.A.defaultView));\n        };\n        _.q.appendChild = _.sd;\n        _.q.append = _.td;\n        _.q.OG = _.ud;\n        _.q.IQ = _.vd;\n        _.q.PG = _.yd;\n        _.q.u0 = _.zd;\n        _.q.cP = _.Bd;\n        _.q.contains = _.Hd;\n        _.q.Ll = _.Wc;\n        _.q = _.Zd.prototype;\n        _.q.clone = function() {\n            return new _.Zd(this.JSBNG__top, this.right, this.bottom, this.left);\n        };\n        _.q.contains = function(a) {\n            return ((((this && a)) ? ((((a instanceof _.Zd)) ? ((((((((a.left >= this.left)) && ((a.right <= this.right)))) && ((a.JSBNG__top >= this.JSBNG__top)))) && ((a.bottom <= this.bottom)))) : ((((((((a.x >= this.left)) && ((a.x <= this.right)))) && ((a.y >= this.JSBNG__top)))) && ((a.y <= this.bottom)))))) : !1));\n        };\n        _.q.ceil = function() {\n            this.JSBNG__top = Math.ceil(this.JSBNG__top);\n            this.right = Math.ceil(this.right);\n            this.bottom = Math.ceil(this.bottom);\n            this.left = Math.ceil(this.left);\n            return this;\n        };\n        _.q.floor = function() {\n            this.JSBNG__top = Math.floor(this.JSBNG__top);\n            this.right = Math.floor(this.right);\n            this.bottom = Math.floor(this.bottom);\n            this.left = Math.floor(this.left);\n            return this;\n        };\n        _.q.round = function() {\n            this.JSBNG__top = Math.round(this.JSBNG__top);\n            this.right = Math.round(this.right);\n            this.bottom = Math.round(this.bottom);\n            this.left = Math.round(this.left);\n            return this;\n        };\n        _.q.translate = function(a, b) {\n            ((((a instanceof _.Rc)) ? (this.left += a.x, this.right += a.x, this.JSBNG__top += a.y, this.bottom += a.y) : (this.left += a, this.right += a, (((0, _.Sa)(b) && (this.JSBNG__top += b, this.bottom += b))))));\n            return this;\n        };\n        _.q.scale = function(a, b) {\n            var c = (((0, _.Sa)(b) ? b : a));\n            this.left *= a;\n            this.right *= a;\n            this.JSBNG__top *= c;\n            this.bottom *= c;\n            return this;\n        };\n        _.q = _.$d.prototype;\n        _.q.clone = function() {\n            return new _.$d(this.left, this.JSBNG__top, this.width, this.height);\n        };\n        _.q.contains = function(a) {\n            return ((((a instanceof _.$d)) ? ((((((((this.left <= a.left)) && ((((this.left + this.width)) >= ((a.left + a.width)))))) && ((this.JSBNG__top <= a.JSBNG__top)))) && ((((this.JSBNG__top + this.height)) >= ((a.JSBNG__top + a.height)))))) : ((((((((a.x >= this.left)) && ((a.x <= ((this.left + this.width)))))) && ((a.y >= this.JSBNG__top)))) && ((a.y <= ((this.JSBNG__top + this.height))))))));\n        };\n        _.q.distance = function(a) {\n            return Math.sqrt(naa(this, a));\n        };\n        _.q.ceil = function() {\n            this.left = Math.ceil(this.left);\n            this.JSBNG__top = Math.ceil(this.JSBNG__top);\n            this.width = Math.ceil(this.width);\n            this.height = Math.ceil(this.height);\n            return this;\n        };\n        _.q.floor = function() {\n            this.left = Math.floor(this.left);\n            this.JSBNG__top = Math.floor(this.JSBNG__top);\n            this.width = Math.floor(this.width);\n            this.height = Math.floor(this.height);\n            return this;\n        };\n        _.q.round = function() {\n            this.left = Math.round(this.left);\n            this.JSBNG__top = Math.round(this.JSBNG__top);\n            this.width = Math.round(this.width);\n            this.height = Math.round(this.height);\n            return this;\n        };\n        _.q.translate = function(a, b) {\n            ((((a instanceof _.Rc)) ? (this.left += a.x, this.JSBNG__top += a.y) : (this.left += a, (((0, _.Sa)(b) && (this.JSBNG__top += b))))));\n            return this;\n        };\n        _.q.scale = function(a, b) {\n            var c = (((0, _.Sa)(b) ? b : a));\n            this.left *= a;\n            this.width *= a;\n            this.JSBNG__top *= c;\n            this.height *= c;\n            return this;\n        };\n        var He = ((_.Wd ? \"MozUserSelect\" : ((_.jd ? \"WebkitUserSelect\" : null)))), paa = /matrix\\([0-9\\.\\-]+, [0-9\\.\\-]+, [0-9\\.\\-]+, [0-9\\.\\-]+, ([0-9\\.\\-]+)p?x?, ([0-9\\.\\-]+)p?x?\\)/;\n        var Oe = /^(\\w+)?(?:\\.(.+))?$/, kba = /^#([\\w-]+)$/;\n        (0, _.za)(\"google.dom.append\", _.Me, void 0);\n        (0, _.za)(\"google.dom.getAll\", function(a, b) {\n            var c;\n            if (c = a.match(kba)) {\n                var d = (0, _.v)(c[1]);\n                return ((d ? [d,] : []));\n            }\n        ;\n        ;\n            c = a.match(Oe);\n            d = ((c[2] && RegExp(((((\"\\\\b\" + c[2])) + \"\\\\b\")))));\n            c = ((b || window.JSBNG__document)).getElementsByTagName(((c[1] || \"*\")));\n            for (var e = [], f = 0, g; g = c[f++]; ) {\n                ((((d && !d.test(g.className))) || e.push(g)));\n            ;\n            };\n        ;\n            return e;\n        }, void 0);\n        (0, _.za)(\"google.dom.set\", _.Pe, void 0);\n        var Xe = 0, raa = 0, We = [];\n        (0, _.za)(\"google.listen\", _.$e, void 0);\n        (0, _.za)(\"google.unlisten\", _.af, void 0);\n        _.q = _.gf.prototype;\n        _.q.ys = function() {\n            return this.Qc.ys();\n        };\n        _.q.add = function(a) {\n            this.Qc.set(hf(a), a);\n        };\n        _.q.removeAll = function(a) {\n            a = cf(a);\n            for (var b = a.length, c = 0; ((c < b)); c++) {\n                this.remove(a[c]);\n            ;\n            };\n        ;\n        };\n        _.q.remove = function(a) {\n            return this.Qc.remove(hf(a));\n        };\n        _.q.clear = function() {\n            this.Qc.clear();\n        };\n        _.q.isEmpty = function() {\n            return this.Qc.isEmpty();\n        };\n        _.q.contains = function(a) {\n            a = hf(a);\n            return (0, _.qc)(this.Qc.Qc, a);\n        };\n        _.q.ot = function() {\n            return this.Qc.ot();\n        };\n        _.q.clone = function() {\n            return new _.gf(this);\n        };\n        _.q.equals = function(a) {\n            return ((((this.ys() == bf(a))) && taa(this, a)));\n        };\n        _.q.nx = function() {\n            return this.Qc.nx(!1);\n        };\n        var qf = {\n            \"\\\"\": \"\\\\\\\"\",\n            \"\\\\\": \"\\\\\\\\\",\n            \"/\": \"\\\\/\",\n            \"\\u0008\": \"\\\\b\",\n            \"\\u000c\": \"\\\\f\",\n            \"\\u000a\": \"\\\\n\",\n            \"\\u000d\": \"\\\\r\",\n            \"\\u0009\": \"\\\\t\",\n            \"\\u000b\": \"\\\\u000b\"\n        }, uaa = ((/\\uffff/.test(\"\\uffff\") ? /[\\\\\\\"\\x00-\\x1f\\x7f-\\uffff]/g : /[\\\\\\\"\\x00-\\x1f\\x7f-\\xff]/g));\n        (0, _.db)(_.sf, _.rf);\n        _.sf.prototype.ys = function() {\n            var a = 0;\n            Yb(this.nx(!0), function() {\n                a++;\n            });\n            return a;\n        };\n        _.sf.prototype.clear = function() {\n            var a = faa(this.nx(!0)), b = this;\n            (0, _.Zb)(a, function(a) {\n                b.remove(a);\n            });\n        };\n        (0, _.db)(_.tf, _.sf);\n        _.q = _.tf.prototype;\n        _.q.set = function(a, b) {\n            try {\n                this.Vg.setItem(a, b);\n            } catch (c) {\n                if (((0 == this.Vg.length))) {\n                    throw \"Storage mechanism: Storage disabled\";\n                }\n            ;\n            ;\n                throw \"Storage mechanism: Quota exceeded\";\n            };\n        ;\n        };\n        _.q.get = function(a) {\n            a = this.Vg.getItem(a);\n            if (((!(0, _.Ra)(a) && ((null !== a))))) {\n                throw \"Storage mechanism: Invalid value was encountered\";\n            }\n        ;\n        ;\n            return a;\n        };\n        _.q.remove = function(a) {\n            this.Vg.removeItem(a);\n        };\n        _.q.ys = function() {\n            return this.Vg.length;\n        };\n        _.q.nx = function(a) {\n            var b = 0, c = this.Vg, d = new _.Vb;\n            d.next = function() {\n                if (((b >= c.length))) {\n                    throw Xb;\n                }\n            ;\n            ;\n                var d;\n                d = c.key(b++);\n                if (a) {\n                    return d;\n                }\n            ;\n            ;\n                d = c.getItem(d);\n                if (!(0, _.Ra)(d)) {\n                    throw \"Storage mechanism: Invalid value was encountered\";\n                }\n            ;\n            ;\n                return d;\n            };\n            return d;\n        };\n        _.q.clear = function() {\n            this.Vg.clear();\n        };\n        _.q.key = function(a) {\n            return this.Vg.key(a);\n        };\n        (0, _.db)(_.uf, _.tf);\n        var Ef, Ff, xf = {\n        }, wf = [], yf = !1, lba = _.kf;\n        (0, _.za)(\"google.initHistory\", function() {\n            Ff = window.google.kEI;\n            Ef = new _.uf;\n            var a;\n            n:\n            {\n                try {\n                    var b = Ef.get(((\"web-mh\" + Ff)));\n                    if (b) {\n                        a = lba(b);\n                        break n;\n                    }\n                ;\n                ;\n                } catch (c) {\n                \n                };\n            ;\n                a = null;\n            };\n        ;\n            ((a && (window.google.pmc = a)));\n        }, void 0);\n        (0, _.za)(\"google.med\", _.Bf, void 0);\n        (0, _.za)(\"google.register\", _.vf, void 0);\n        (0, _.za)(\"google.raas\", _.Af, void 0);\n        var yaa;\n        var Jf;\n        var Hf;\n        var Kf;\n        Hf = [];\n        Jf = [];\n        yaa = ((window.google.j && window.google.j.en));\n        (0, _.Af)(\"bbd\", {\n            init: function() {\n                _.If = {\n                    persisted: !1\n                };\n                window.google._bfr = !1;\n            },\n            JSBNG__history: function(a) {\n                ((a && (_.If = a)));\n                ((_.If.persisted ? Gf() : ((_.If.persisted || (_.If.persisted = !0, (0, _.Df)(\"bbd\", _.If), ((window.JSBNG__addEventListener && (window.JSBNG__addEventListener(\"pageshow\", xaa, !1), Kf = !1))))))));\n            },\n            dispose: function() {\n                Hf.length = 0;\n                Jf.length = 0;\n            }\n        });\n        _.hj = _.Mf;\n        var Of = {\n        };\n        (0, _.za)(\"google.msg.listen\", _.Nf, void 0);\n        (0, _.za)(\"google.msg.unlisten\", _.Pf, void 0);\n        (0, _.za)(\"google.msg.send\", _.Qf, void 0);\n        var ij;\n        ij = !!_.Ca.JSBNG__DOMTokenList;\n        _.jj = ((ij ? function(a) {\n            return a.classList;\n        } : function(a) {\n            a = a.className;\n            return (((((0, _.Ra)(a) && a.match(/\\S+/g))) || []));\n        }));\n        _.Vf = ((ij ? function(a, b) {\n            return a.classList.contains(b);\n        } : function(a, b) {\n            return (0, _.Fb)((0, _.jj)(a), b);\n        }));\n        _.Sf = ((ij ? function(a, b) {\n            a.classList.add(b);\n        } : function(a, b) {\n            (((0, _.Vf)(a, b) || (a.className += ((((0 < a.className.length)) ? ((\" \" + b)) : b)))));\n        }));\n        _.kj = ((ij ? function(a, b) {\n            (0, _.Zb)(b, function(b) {\n                (0, _.Sf)(a, b);\n            });\n        } : function(a, b) {\n            var c = {\n            };\n            (0, _.Zb)((0, _.jj)(a), function(a) {\n                c[a] = !0;\n            });\n            (0, _.Zb)(b, function(a) {\n                c[a] = !0;\n            });\n            a.className = \"\";\n            {\n                var fin34keys = ((window.top.JSBNG_Replay.forInKeys)((c))), fin34i = (0);\n                var d;\n                for (; (fin34i < fin34keys.length); (fin34i++)) {\n                    ((d) = (fin34keys[fin34i]));\n                    {\n                        a.className += ((((0 < a.className.length)) ? ((\" \" + d)) : d));\n                    ;\n                    };\n                };\n            };\n        ;\n        }));\n        _.Tf = ((ij ? function(a, b) {\n            a.classList.remove(b);\n        } : function(a, b) {\n            (((0, _.Vf)(a, b) && (a.className = (0, _.Pc)((0, _.jj)(a), function(a) {\n                return ((a != b));\n            }).join(\" \"))));\n        }));\n        _.lj = ((ij ? function(a, b) {\n            (0, _.Zb)(b, function(b) {\n                (0, _.Tf)(a, b);\n            });\n        } : function(a, b) {\n            a.className = (0, _.Pc)((0, _.jj)(a), function(a) {\n                return !(0, _.Fb)(b, a);\n            }).join(\" \");\n        }));\n        var Zf, Baa = (((((0, _.Xf)().protocol + \"//\")) + (0, _.Xf)().host));\n        (0, _.za)(\"google.nav.getLocation\", _.bg, void 0);\n        (0, _.za)(\"google.nav.go\", _.Yf, void 0);\n        (0, _.za)(\"google.nav.search\", _.$f, void 0);\n        var Eaa = (0, _.gg)(function(a) {\n            return RegExp(a);\n        });\n        (0, _.za)(\"google.style.JSBNG__getComputedStyle\", _.jg, void 0);\n        (0, _.za)(\"google.style.getHeight\", _.kg, void 0);\n        (0, _.za)(\"google.style.getWidth\", _.lg, void 0);\n        (0, _.za)(\"google.style.getPageOffsetTop\", _.se, void 0);\n        (0, _.za)(\"google.style.getPageOffsetLeft\", _.re, void 0);\n        (0, _.za)(\"google.style.getPageOffsetStart\", _.mg, void 0);\n        (0, _.za)(\"google.style.hasClass\", _.Vf, void 0);\n        (0, _.za)(\"google.style.isRtl\", _.ig, void 0);\n        (0, _.za)(\"google.style.addClass\", _.Sf, void 0);\n        (0, _.za)(\"google.style.removeClass\", _.Tf, void 0);\n        _.ng.prototype.Md = !1;\n        _.ng.prototype.isDisposed = (0, _.ma)(\"Md\");\n        _.ng.prototype.dispose = function() {\n            ((this.Md || (this.Md = !0, this.La())));\n        };\n        _.ng.prototype.La = function() {\n            if (this.Za) {\n                for (; this.Za.length; ) {\n                    this.Za.shift()();\n                ;\n                };\n            }\n        ;\n        ;\n        };\n        var nj;\n        _.mj = (0, _.tg)(!1);\n        nj = (0, _.tg)(!0);\n        (0, _.db)(vg, _.ng);\n        vg.prototype.initialize = (0, _.ka)();\n        wg.prototype.execute = function(a) {\n            ((this.A && (this.A.call(((this.B || null)), a), this.A = this.B = null)));\n        };\n        wg.prototype.abort = function() {\n            this.B = this.A = null;\n        };\n        (0, _.db)(xg, _.ng);\n        _.q = xg.prototype;\n        _.q.oZ = vg;\n        _.q.JB = null;\n        _.q.getId = (0, _.ma)(\"He\");\n        _.q.aI = function(a, b) {\n            return yg(this, this.B, a, b);\n        };\n        _.q.La = function() {\n            xg.ja.La.call(this);\n            (0, _.rg)(this.JB);\n        };\n        _.q = _.Bg.prototype;\n        _.q.Wz = !1;\n        _.q.SE = !1;\n        _.q.RJ = !1;\n        _.q.GU = !1;\n        _.q.KM = !1;\n        _.q.GK = 0;\n        _.q.cancel = function(a) {\n            if (this.Wz) ((((this.B instanceof _.Bg)) && this.B.cancel()));\n             else {\n                if (this.A) {\n                    var b = this.A;\n                    delete this.A;\n                    ((a ? b.cancel(a) : (b.GK--, ((((0 >= b.GK)) && b.cancel())))));\n                }\n            ;\n            ;\n                ((this.J ? this.J.call(this.H, this) : this.KM = !0));\n                ((this.Wz || (a = new Jg(this), (0, _.Eg)(this), (0, _.Cg)(this, !1, a))));\n            }\n        ;\n        ;\n        };\n        _.q.yO = function(a, b) {\n            this.RJ = !1;\n            (0, _.Cg)(this, a, b);\n        };\n        _.q.Un = function(a) {\n            (0, _.Eg)(this);\n            (0, _.Cg)(this, !0, a);\n        };\n        (0, _.db)(Fg, _.fb);\n        Fg.prototype.message = \"Deferred has already fired\";\n        Fg.prototype.JSBNG__name = \"AlreadyCalledError\";\n        (0, _.db)(Jg, _.fb);\n        Jg.prototype.message = \"Deferred was canceled\";\n        Jg.prototype.JSBNG__name = \"CanceledError\";\n        (0, _.db)(_.x, _.ng);\n        (0, _.Ia)(_.x);\n        _.q = _.x.prototype;\n        _.q.PJ = !1;\n        _.q.eV = !1;\n        _.q.FL = null;\n        _.q.pG = 0;\n        _.q.QQ = !1;\n        _.q.SS = !1;\n        _.q.dR = null;\n        _.q.H0 = function(a, b) {\n            if ((0, _.Ra)(a)) {\n                for (var c = a.split(\"/\"), d = [], e = 0; ((e < c.length)); e++) {\n                    var f = c[e].split(\":\"), g = f[0];\n                    if (f[1]) {\n                        for (var f = f[1].split(\",\"), h = 0; ((h < f.length)); h++) {\n                            f[h] = d[(0, window.parseInt)(f[h], 36)];\n                        ;\n                        };\n                    }\n                     else {\n                        f = [];\n                    }\n                ;\n                ;\n                    d.push(g);\n                    this.zt[g] = new xg(f, g);\n                };\n            ;\n                ((((b && b.length)) ? ((0, _.Nb)(this.D, b), this.V = b[((b.length - 1))]) : ((this.L.Wz || this.L.Un()))));\n                ((((this.H == this.Q)) && (this.H = null, ((zg(this.Q, (0, _.$a)(this.hP, this)) && Tg(this, 4))))));\n            }\n        ;\n        ;\n        };\n        _.q.hP = (0, _.ma)(\"dR\");\n        _.q.isActive = function() {\n            return ((0 < this.D.length));\n        };\n        _.q.IH = function(a, b, c) {\n            ((b || (this.pG = 0)));\n            this.D = b = Iaa(this, a);\n            ((this.PJ ? this.B = a : this.B = (0, _.Mb)(b)));\n            Kg(this);\n            ((((0 != b.length)) && (this.M.push.apply(this.M, b), a = (0, _.$a)(this.FL.H, this.FL, (0, _.Mb)(b), this.zt, null, (0, _.$a)(this.VX, this, this.B, b), (0, _.$a)(this.WX, this), !!c), (((c = ((5000 * Math.pow(this.pG, 2)))) ? window.JSBNG__setTimeout(a, c) : a())))));\n        };\n        _.q.load = function(a, b) {\n            return Mg(this, [a,], b)[a];\n        };\n        _.q.VX = function(a, b, c) {\n            this.pG++;\n            this.B = a;\n            (0, _.Zb)(b, (0, _.ab)(_.Ib, this.M), this);\n            ((((401 == c)) ? (Tg(this, 0), this.A.length = 0) : ((((410 == c)) ? (Xg(this, 3), Ug(this)) : ((((3 <= this.pG)) ? (Xg(this, 1), Ug(this)) : this.IH(this.B, !0, ((8001 == c)))))))));\n        };\n        _.q.WX = function() {\n            Xg(this, 2);\n            Ug(this);\n        };\n        _.q.aI = function(a, b) {\n            (((0, _.Oa)(a) || (a = [a,])));\n            for (var c = 0; ((c < a.length)); c++) {\n                var d = a[c], e = b, f = this.T;\n                ((f[d] || (f[d] = [])));\n                f[d].push(e);\n            };\n        ;\n        };\n        _.q.La = function() {\n            _.x.ja.La.call(this);\n            (0, _.sg)((0, _.bc)(this.zt), this.Q);\n            this.T = this.A = this.J = this.B = this.D = this.zt = null;\n        };\n        Yg.prototype.H = function(a) {\n            if (((null === a))) window.google.ml(Error(\"LM null\"), !1);\n             else {\n                a = Kaa(this, a);\n                var b = window.JSBNG__document.createElement(\"script\");\n                b.src = a;\n                (0, _.Me)(b);\n            }\n        ;\n        ;\n        };\n        var $g = !1;\n        (0, _.za)(\"google.load\", _.ah, void 0);\n        (0, _.za)(\"google.loadAll\", function(a) {\n            var b = Zg();\n            Mg(b, a, void 0);\n        }, void 0);\n        var ch = !0, dh = ((_.sc.Hc && ((0 > (0, _.wc)(_.vc, \"9\")))));\n        _.fh.prototype.Id = (0, _.ma)(\"A\");\n        _.fh.prototype.toString = function() {\n            return this.A.toString();\n        };\n        var Maa = ((!_.Jc || (0, _.Ic)(9))), Dh = ((!_.Jc || (0, _.Ic)(9))), mba = ((_.Jc && !(0, _.Ec)(\"9\")));\n        ((!_.jd || (0, _.Ec)(\"528\")));\n        ((((((((_.Wd && (0, _.Ec)(\"1.9b\"))) || ((_.Jc && (0, _.Ec)(\"8\"))))) || ((_.Xd && (0, _.Ec)(\"9.5\"))))) || ((_.jd && (0, _.Ec)(\"528\")))));\n        ((((_.Wd && !(0, _.Ec)(\"8\"))) || ((_.Jc && (0, _.Ec)(\"9\")))));\n        _.q = _.nh.prototype;\n        _.q.dispose = (0, _.ka)();\n        _.q.nA = !1;\n        _.q.bS = !0;\n        _.q.stopPropagation = function() {\n            this.nA = !0;\n        };\n        _.q.preventDefault = function() {\n            this.bS = !1;\n        };\n        ph[\" \"] = _.Ga;\n        (0, _.db)(_.qh, _.nh);\n        var Naa = [1,4,2,];\n        _.q = _.qh.prototype;\n        _.q.target = null;\n        _.q.relatedTarget = null;\n        _.q.oP = 0;\n        _.q.pP = 0;\n        _.q.clientX = 0;\n        _.q.clientY = 0;\n        _.q.JSBNG__screenX = 0;\n        _.q.JSBNG__screenY = 0;\n        _.q.button = 0;\n        _.q.keyCode = 0;\n        _.q.charCode = 0;\n        _.q.ctrlKey = !1;\n        _.q.altKey = !1;\n        _.q.shiftKey = !1;\n        _.q.metaKey = !1;\n        _.q.UC = !1;\n        _.q.tl = null;\n        _.q.init = function(a, b) {\n            var c = this.type = a.type;\n            _.nh.call(this, c);\n            this.target = ((a.target || a.srcElement));\n            this.currentTarget = b;\n            var d = a.relatedTarget;\n            if (d) {\n                if (_.Wd) {\n                    var e;\n                    n:\n                    {\n                        try {\n                            ph(d.nodeName);\n                            e = !0;\n                            break n;\n                        } catch (f) {\n                        \n                        };\n                    ;\n                        e = !1;\n                    };\n                ;\n                    ((e || (d = null)));\n                }\n            ;\n            ;\n            }\n             else ((((\"mouseover\" == c)) ? d = a.fromElement : ((((\"mouseout\" == c)) && (d = a.toElement)))));\n        ;\n        ;\n            this.relatedTarget = d;\n            this.oP = ((((_.jd || ((void 0 !== a.offsetX)))) ? a.offsetX : a.layerX));\n            this.pP = ((((_.jd || ((void 0 !== a.offsetY)))) ? a.offsetY : a.layerY));\n            this.clientX = ((((void 0 !== a.clientX)) ? a.clientX : a.pageX));\n            this.clientY = ((((void 0 !== a.clientY)) ? a.clientY : a.pageY));\n            this.JSBNG__screenX = ((a.JSBNG__screenX || 0));\n            this.JSBNG__screenY = ((a.JSBNG__screenY || 0));\n            this.button = a.button;\n            this.keyCode = ((a.keyCode || 0));\n            this.charCode = ((a.charCode || ((((\"keypress\" == c)) ? a.keyCode : 0))));\n            this.ctrlKey = a.ctrlKey;\n            this.altKey = a.altKey;\n            this.shiftKey = a.shiftKey;\n            this.metaKey = a.metaKey;\n            this.UC = ((_.ie ? a.metaKey : a.ctrlKey));\n            this.state = a.state;\n            this.tl = a;\n            ((a.defaultPrevented && this.preventDefault()));\n            delete this.nA;\n        };\n        _.q.stopPropagation = function() {\n            _.qh.ja.stopPropagation.call(this);\n            ((this.tl.stopPropagation ? this.tl.stopPropagation() : this.tl.cancelBubble = !0));\n        };\n        _.q.preventDefault = function() {\n            _.qh.ja.preventDefault.call(this);\n            var a = this.tl;\n            if (a.preventDefault) {\n                a.preventDefault();\n            }\n             else {\n                if (a.returnValue = !1, mba) {\n                    try {\n                        if (((a.ctrlKey || ((((112 <= a.keyCode)) && ((123 >= a.keyCode))))))) {\n                            a.keyCode = -1;\n                        }\n                    ;\n                    ;\n                    } catch (b) {\n                    \n                    };\n                }\n            ;\n            }\n        ;\n        ;\n        };\n        _.q.mW = (0, _.ma)(\"tl\");\n        var uh = ((\"closure_listenable_\" + ((((1000000 * Math.JSBNG__random())) | 0)))), Oaa = 0;\n        var Nh;\n        var Bh;\n        var zh;\n        _.Ch = {\n        };\n        zh = {\n        };\n        _.Ah = {\n        };\n        Bh = {\n        };\n        Nh = ((\"__closure_events_fn_\" + ((((1000000000 * Math.JSBNG__random())) >>> 0))));\n        (0, _.db)(_.Oh, _.ng);\n        _.Oh.prototype[uh] = !0;\n        _.q = _.Oh.prototype;\n        _.q.VH = null;\n        _.q.wM = (0, _.la)(\"VH\");\n        _.q.JSBNG__addEventListener = function(a, b, c, d) {\n            (0, _.wh)(this, a, b, c, d);\n        };\n        _.q.JSBNG__removeEventListener = function(a, b, c, d) {\n            (0, _.Fh)(this, a, b, c, d);\n        };\n        _.q.JSBNG__dispatchEvent = function(a) {\n            var b, c = this.VH;\n            if (c) {\n                b = [];\n                for (var d = 1; c; c = c.VH) {\n                    b.push(c), ++d;\n                ;\n                };\n            ;\n            }\n        ;\n        ;\n            c = this.mr;\n            d = ((a.type || a));\n            if ((0, _.Ra)(a)) {\n                a = new _.nh(a, c);\n            }\n             else {\n                if (((a instanceof _.nh))) a.target = ((a.target || c));\n                 else {\n                    var e = a;\n                    a = new _.nh(d, c);\n                    (0, _.lc)(a, e);\n                }\n            ;\n            }\n        ;\n        ;\n            var e = !0, f;\n            if (b) {\n                for (var g = ((b.length - 1)); ((!a.nA && ((0 <= g)))); g--) {\n                    f = a.currentTarget = b[g], e = ((Kh(f, d, !0, a) && e));\n                ;\n                };\n            }\n        ;\n        ;\n            ((a.nA || (f = a.currentTarget = c, e = ((Kh(f, d, !0, a) && e)), ((a.nA || (e = ((Kh(f, d, !1, a) && e))))))));\n            if (b) {\n                for (g = 0; ((!a.nA && ((g < b.length)))); g++) {\n                    f = a.currentTarget = b[g], e = ((Kh(f, d, !1, a) && e));\n                ;\n                };\n            }\n        ;\n        ;\n            return e;\n        };\n        _.q.La = function() {\n            _.Oh.ja.La.call(this);\n            this.removeAllListeners();\n            this.VH = null;\n        };\n        _.q.listen = function(a, b, c, d) {\n            return Ph(this, a, b, !1, c, d);\n        };\n        _.q.MC = function(a, b, c, d) {\n            return Ph(this, a, b, !0, c, d);\n        };\n        _.q.unlisten = function(a, b, c, d) {\n            if (!((a in this.L))) {\n                return !1;\n            }\n        ;\n        ;\n            a = this.L[a];\n            b = (0, _.Qh)(a, b, c, d);\n            return ((((-1 < b)) ? (a[b].Kx = !0, (0, _.Jb)(a, b)) : !1));\n        };\n        _.q.removeAllListeners = function(a) {\n            var b = 0, c;\n            {\n                var fin35keys = ((window.top.JSBNG_Replay.forInKeys)((this.L))), fin35i = (0);\n                (0);\n                for (; (fin35i < fin35keys.length); (fin35i++)) {\n                    ((c) = (fin35keys[fin35i]));\n                    {\n                        if (((!a || ((c == a))))) {\n                            for (var d = this.L[c], e = 0; ((e < d.length)); e++) {\n                                ++b, d[e].Kx = !0;\n                            ;\n                            };\n                        ;\n                            d.length = 0;\n                        }\n                    ;\n                    ;\n                    };\n                };\n            };\n        ;\n            return b;\n        };\n        (0, _.db)(_.Rh, _.Oh);\n        _.q = _.Rh.prototype;\n        _.q.enabled = !1;\n        _.q.Cx = null;\n        _.q.DW = function() {\n            if (this.enabled) {\n                var a = (((0, _.Ve)() - this.H));\n                ((((((0 < a)) && ((a < ((77918 * this.B)))))) ? this.Cx = this.A.JSBNG__setTimeout(this.D, ((this.B - a))) : (((this.Cx && (this.A.JSBNG__clearTimeout(this.Cx), this.Cx = null))), this.JSBNG__dispatchEvent(\"tick\"), ((this.enabled && (this.Cx = this.A.JSBNG__setTimeout(this.D, this.B), this.H = (0, _.Ve)()))))));\n            }\n        ;\n        ;\n        };\n        _.q.start = function() {\n            this.enabled = !0;\n            ((this.Cx || (this.Cx = this.A.JSBNG__setTimeout(this.D, this.B), this.H = (0, _.Ve)())));\n        };\n        _.q.JSBNG__stop = function() {\n            this.enabled = !1;\n            ((this.Cx && (this.A.JSBNG__clearTimeout(this.Cx), this.Cx = null)));\n        };\n        _.q.La = function() {\n            _.Rh.ja.La.call(this);\n            this.JSBNG__stop();\n            delete this.A;\n        };\n        var oj, pj, qj, rj;\n        rj = qj = pj = oj = !1;\n        var sj = Bc();\n        ((sj && ((((((-1 != sj.indexOf(\"Firefox\"))) || ((-1 != sj.indexOf(\"Camino\"))))) || ((((((-1 != sj.indexOf(\"iPhone\"))) || ((-1 != sj.indexOf(\"iPod\"))))) ? oj = !0 : ((((-1 != sj.indexOf(\"iPad\"))) ? pj = !0 : ((((-1 != sj.indexOf(\"Android\"))) ? qj = !0 : ((((-1 != sj.indexOf(\"Chrome\"))) || ((((-1 != sj.indexOf(\"Safari\"))) && (rj = !0)))))))))))))));\n        _.tj = oj;\n        _.uj = pj;\n        _.vj = qj;\n        _.ci = rj;\n        (0, _.db)(Uh, _.Oh);\n        var Vh = [], Yh = new _.Oh, Raa = /[~.,?&-]/g;\n        _.q = Uh.prototype;\n        _.q.getTick = function(a) {\n            return ((((\"start\" == a)) ? this.Q : this.T[a]));\n        };\n        _.q.I = (0, _.ma)(\"V\");\n        _.q.tick = function(a, b) {\n            Zh(this);\n            b = ((b || {\n            }));\n            ((((a in this.T)) && this.J.add(a)));\n            var c = ((b.time || (0, _.Ve)()));\n            ((((!b.vV && ((!b.L3 && ((c > this.ca)))))) && (this.ca = c)));\n            for (var d = ((c - this.Q)), e = this.H.length; ((((0 < e)) && ((this.H[((e - 1))][1] > d)))); ) {\n                e--;\n            ;\n            };\n        ;\n            (0, _.Ob)(this.H, e, 0, [a,d,b.vV,]);\n            this.T[a] = c;\n        };\n        _.q.timers = (0, _.ma)(\"H\");\n        _.q.Uz = function(a, b) {\n            var c = new Xh(\"error\", this);\n            c.error = a;\n            ((b && (c.A = b)));\n            Yh.JSBNG__dispatchEvent(c);\n        };\n        _.q.action = function(a) {\n            Zh(this);\n            var b = [], c = null, d = null, e = null, f = null;\n            Vaa(a, function(a) {\n                var h;\n                ((((!a.__oi && a.getAttribute)) && (a.__oi = a.getAttribute(\"oi\"))));\n                if (h = a.__oi) {\n                    b.unshift(h), ((c || (c = a.getAttribute(\"jsinstance\"))));\n                }\n            ;\n            ;\n                ((((e || ((d && ((\"1\" != d)))))) || (e = a.getAttribute(\"ved\"))));\n                ((d || (d = a.getAttribute(\"jstrack\"))));\n                ((f || (f = a.getAttribute(\"jstrackrate\"))));\n            });\n            ((d && (this.B.ct = this.V, ((((0 < b.length)) && Uaa(this, \"oi\", b.join(\".\")))), ((c && (c = ((((\"*\" == c.charAt(0))) ? (0, window.parseInt)(c.substr(1), 10) : (0, window.parseInt)(c, 10))), this.B.cd = c))), ((((\"1\" != d)) && (this.B.ei = d))), ((e && (this.B.ved = e))))));\n        };\n        _.q.Un = function(a, b, c, d) {\n            Taa(this, b, c);\n            var e = this;\n            return function() {\n                var c = a.apply(this, arguments);\n                Wh(e, b, d);\n                return c;\n            };\n        };\n        _.q.JSBNG__event = (0, _.ma)(\"$\");\n        _.q.value = function(a) {\n            var b = this.aF;\n            return ((b ? b[a] : void 0));\n        };\n        (0, _.db)(Xh, _.nh);\n        $h.prototype.Q = function(a) {\n            if ((0, _.Oa)(a)) this.A = (0, _.Mb)(a), ai(this);\n             else {\n                var b = a.action, c = b.split(\".\")[0], d = this.H[c], e;\n                ((this.M ? e = this.M(a) : ((d ? ((d.accept(a) && (e = d.handle))) : e = this.B[b]))));\n                ((e ? (c = this.T(a), e(c), Wh(c, \"main-actionflow-branch\")) : (((e = Th(a.JSBNG__event), a.JSBNG__event = e, this.A.push(a), d) || (((a = this.V[c], a) ? ((a.NU || (a.S3(this, c), a.NU = !0))) : ((((!this.D || ((c in this.J)))) || (this.J[c] = !0, this.D(this, c))))))))));\n            }\n        ;\n        ;\n        };\n        _.wj = {\n        };\n        _.xj = {\n        };\n        _.yj = {\n        };\n        _.fi = {\n        };\n        var ii = new $h;\n        ii.H.r = {\n            accept: ((function(a) {\n                return !!ei(a.actionElement);\n            } || nj)),\n            handle: function(a) {\n                var b = ei(a.aF);\n                if (b) {\n                    var c = _.wj[a.Da.split(\".\")[1]];\n                    ((c && (c.call(b, b.fM.nZ, a), _.zj.H())));\n                }\n            ;\n            ;\n            }\n        };\n        var ki = {\n        }, gi = {\n        }, hi = {\n        };\n        ni.prototype.D = null;\n        ni.prototype.B = function() {\n            var a;\n            (((a = this.D) || (a = {\n            }, ((ri(this) && (a[0] = !0, a[1] = !0))), a = this.D = a)));\n            return a;\n        };\n        (0, _.db)(oi, ni);\n        oi.prototype.A = function() {\n            return this.J();\n        };\n        oi.prototype.B = function() {\n            return this.H();\n        };\n        _.pi.B = !1;\n        _.pi.D = function() {\n            return _.pi.A.B();\n        };\n        _.pi.Cf = function(a, b) {\n            _.pi.eb(new oi(a, b));\n        };\n        _.pi.eb = function(a) {\n            _.pi.A = a;\n        };\n        (0, _.db)(qi, ni);\n        qi.prototype.A = function() {\n            var a = ri(this);\n            return ((a ? new window.ActiveXObject(a) : new window.JSBNG__XMLHttpRequest));\n        };\n        _.pi.eb(new qi);\n        (0, _.za)(\"google.exportSymbol\", _.cb, void 0);\n        (0, _.za)(\"google.xhr\", _.pi, void 0);\n        (0, _.za)(\"google.jsa.adc\", function(a, b, c) {\n            hi[a] = ((hi[a] || []));\n            ((mi(a, b) || hi[a].push({\n                Un: b,\n                A0: !!c\n            })));\n        }, void 0);\n        (0, _.za)(\"google.jsa.rdc\", function(a, b) {\n            ((mi(a, b) && (0, _.Ib)(hi[a], mi(a, b))));\n        }, void 0);\n        (0, _.za)(\"google.jsa.ia\", function(a, b, c, d, e) {\n            return (((a = gi[a]) ? (((((!c && b)) && (c = (0, _.mh)(b)))), a(b, c, d, e)) : !1));\n        }, void 0);\n        (0, _.za)(\"google.fx.animate\", _.Te, void 0);\n        (0, _.za)(\"google.Toolbelt.parseTbs\", _.si, void 0);\n        (0, _.Af)(\"anim\", {\n            dispose: function() {\n                window.JSBNG__clearInterval(Xe);\n                Xe = 0;\n                We = [];\n            }\n        });\n        (0, _.Af)(\"nos\", {\n            init: function() {\n                (0, _.ji)(\"nos\", {\n                    d: hba\n                });\n            }\n        });\n        (0, _.Af)(\"jsa\", {\n            init: function() {\n                Yaa(ii, Zaa);\n                ii.D = bba;\n                ((window.google.jsad && window.google.jsad((0, _.$a)(ii.Q, ii))));\n                (0, _.ji)(\"jsa\", {\n                    go: dba,\n                    log: eba,\n                    popup: fba,\n                    select: gba,\n                    \"true\": nj\n                });\n                (0, _.ji)(\"lr\", {\n                    smt: function(a, b) {\n                        var c = Boolean(Number(b.se)), d = (((0, _.xb)(b.fs) || 200)), e = ((b.tag || \"\")), f = (((0, _.xb)(b.ss) || 200)), g = b.e;\n                        ((b.h ? (0, _.Ce)(a, !1) : ((g && window.google.mobile_live_result.expand(a)))));\n                        (0, _.eh)(a, c, d, e, f);\n                    },\n                    ddu: function(a, b) {\n                        (0, _.bh)(a, b.tag, (0, _.xb)(b.idx));\n                    },\n                    wobt: function(a, b) {\n                        window.wob.toggle(b.url);\n                    }\n                });\n                (0, _.ji)(\"spl\", {\n                    cc: cba\n                });\n                (0, _.ji)(\"ppl\", {\n                    pv: function(a, b) {\n                        var c = b.se, d = b.ee, e = a.firstChild, f = e.lastChild, g = (((0, _.lg)(e) / 2));\n                        e.style[c] = ((((-g + 2)) + \"px\"));\n                        f.style[d] = ((((g + 1)) + \"px\"));\n                    }\n                });\n            },\n            dispose: function() {\n                {\n                    var fin36keys = ((window.top.JSBNG_Replay.forInKeys)((ki))), fin36i = (0);\n                    var a;\n                    for (; (fin36i < fin36keys.length); (fin36i++)) {\n                        ((a) = (fin36keys[fin36i]));\n                        {\n                            (0, _.li)(a, ki[a]);\n                        ;\n                        };\n                    };\n                };\n            ;\n                {\n                    var fin37keys = ((window.top.JSBNG_Replay.forInKeys)((hi))), fin37i = (0);\n                    var b;\n                    for (; (fin37i < fin37keys.length); (fin37i++)) {\n                        ((b) = (fin37keys[fin37i]));\n                        {\n                            a = hi[b];\n                            for (var c = ((a.length - 1)); ((0 <= c)); --c) {\n                                ((a[c].A0 || (0, _.Jb)(a, c)));\n                            ;\n                            };\n                        ;\n                        };\n                    };\n                };\n            ;\n                gi = {\n                };\n            }\n        });\n        _.vi.prototype.initialize = function() {\n            this.A = [];\n            this.B = \"\";\n        };\n        var Fi;\n        Fi = {\n        };\n        _.Bi = \"& &amp; \\u003C &lt; \\u003E &gt; \\\" &quot; ' &#39; { &#123;\".split(\" \");\n        (0, _.za)(\"google.util.arrayIndexOf\", _.Gb, void 0);\n        (0, _.za)(\"google.util.logVisibilityChange\", _.Hi, void 0);\n        (0, _.za)(\"google.util.togglePopup\", function(a) {\n            var b = (0, _.v)(a);\n            if (((null !== b))) {\n                if ((0, _.De)(b)) Ei(b);\n                 else {\n                    (0, _.Ce)(b, !0);\n                    var c = !1;\n                    Fi[a] = function() {\n                        ((c ? Ei(b) : c = !0));\n                    };\n                    (0, _.$e)(window.JSBNG__document.body, \"click\", Fi[a]);\n                }\n            ;\n            }\n        ;\n        ;\n        }, void 0);\n        ((((window.google.timers && window.google.timers.load.t)) && (window.google.timers.load.t.xjses = window.google.time())));\n        var Cj;\n        _.Aj = [];\n        _.Bj = \"/\";\n        Cj = [];\n        (0, _.za)(\"google.History.initialize\", function(a) {\n            _.Bj = a;\n            _.Ki = null;\n            if (_.Ji = (0, _.v)(\"hcache\")) {\n                (0, _.Ii)();\n                for (a = 0; ((a < _.Aj.length)); ++a) {\n                    ((((_.Ki && ((_.Ki[_.Bj] && _.Ki[_.Bj][a])))) && _.Aj[a].call(null, _.Ki[_.Bj][a])));\n                ;\n                };\n            ;\n                a = 0;\n                for (var b; b = Cj[a++]; ) {\n                    b();\n                ;\n                };\n            ;\n                Cj = [];\n            }\n        ;\n        ;\n        }, void 0);\n        _._ModuleManager_initialize = (0, _.$a)(_.x.prototype.H0, _.x.G());\n        (0, _._ModuleManager_initialize)(\"sy0/bct:0/sy1/sy2/sy4/sy3:2,3,4/cr:2,3,4,5/crp:4/sy5/cdos:8/sy7/sy6:a/c:a,b/cb/sy9/sy8:e/csi:e,f/sy10/dbm:h/el/gf/sy11/hsm:l/sy12/hv:n/riu/sy13/sy15/sy14:r/sy18/sy16:2,a,q,s,t/sy19:l,u/sy21:u/sy25/sy26:u,v,x/sy23:u/sy24:u,w,z/sy27:u,v,w/sy28:11,l,u,v/sy20:10,11,12,3,4,5,f,l,q,s,u,v,w,y,z/j:10,11,12,13,2,3,4,5,a,e,f,l,q,r,s,t,u,v,w,x,y,z/sy29:u,v,y,z/jp:15,2,a,l,q,r,s,t,u,v,x,y,z/kx/sy30/lc:18,a/sy31/hov:1a/mb:a/o3i/oh/sy32/sy33/sy34:1f,1g/aaq:1f,1g,1h/sy35:x/abd:1j,a,e,x/sy36/sy37/sy38/sy39:1n/sy41/sy42:1p/sy43:1q/sy46:1h,1l,1n,1o/sy44:1h,1l,1n,1o,1q,1r,1s/sy45:1h,1l,1n,1o,1s/sy47:1h,1l,1n,1o,1q,1s,1t,1u/sy48:1h,1l,1s,1t,1u,1v/sy49:1h,1l,1s,1t,1v/sy40:1m,1n,1o,1q,1w,1x/adct:1f,1g,1h,1l,1m,1n,1o,1p,1q,1r,1s,1t,1u,1v,1w,1x,1y/adch/adp/ca:a/adnsp/ddad/fa/adso:h/sy50/sy52:1j,27/lare:1j,27,28,x/sy54:q/sy56/sy55:2a,2b,a,q/sy53:18,1n,27,2c,q/larh:18,1n,27,2a,2b,2c,2d,a,q/sy57:a,x/sy58:2f/adsm:2f,2g,a,x/sy59/sy60:2i/sy62/sy61:2i,2j,2k/sy64/sy65:2i,2m/sy63:2i,2l,2m,2n/sy72/sy67:1a,2p/sy68/sy69:2r/sy70/sy71:2s,2t/sy74:1q,1r/sy75:1f,1n,2r/sy73:1q,1r,2v,2w/sy66:1f,1h,1n,1q,1r,2p,2q,2u,2w,2x/sy76:1q,1r,2w,2x/sy77:2z/pla:1a,1f,1g,1h,1l,1n,1o,1p,1q,1r,1s,1t,1u,1v,2i,2j,2k,2l,2m,2n,2o,2p,2q,2r,2s,2t,2u,2v,2w,2x,2y,2z,30/sy78:2b/sy79:1g,1h,1l,1o,2b,32/cu:1f,1g,1h,1l,1n,1o,2b,32,33,a/sy80/wta:35/wmh:e/sem:e/pih:n/sy81/sy82/sy83:1m,2r,2s,t/sy84:1p,2r,3b,3c/als:1f,1g,1j,1l,1m,1n,1o,1p,1q,2f,2r,2s,3a,3b,3c,3d,a,t,x/sy85/rmcl:3f/sy86:3f,q/rkab:3f,3h,q/sy87/sy88:2i,2l,2m,2n/sy89:3j/sy90:a/sy91:1h,1s,1t/sy92:1h,1u,2p,2q/llc:11,1a,1f,1g,1h,1l,1m,1n,1o,1p,1q,1r,1s,1t,1u,1v,1w,1x,1y,2,2a,2b,2c,2i,2j,2k,2l,2m,2n,2o,2p,2q,2t,32,3f,3h,3j,3k,3l,3m,3n,3o,a,l,q,r,s,t,u,v,w/aspn/sy93:15,2f/async:15,2,2f,3r,a,l,q,r,s,t,u,v,x,y,z/lb:15,2,3,a,l,q,r,s,t,u,v,x,y,z/bgd/col:1f,1g,1h,1j,2b,32,r,x/d_kbn:r,s/dict/gol:1f/sy95/sy96:3z/zr:3z,40/sy97/sy98/sy99/sy100:12,43,44,q,s,u,v/esp:11,12,18,1f,1j,1n,2,2a,2b,2c,42,43,44,45,a,l,q,r,s,t,u,v,w,x/erh/sy101/sy102:2i,2l,3j,48/cfm:2i,2j,2k,2l,3j,48,49/vfm:2i,2j,2k,2l,3j,48,49/fu:1f,1g,1h,1l,1n,1o,2b,32,33,a/foot/sy103/spg:4e/sy104:2f/hw:2f,4g,a,x/ht:1m/hss/hkp/hfm/sy107/sy109:4m/sy108:4m/sy105:10,1j,2c,2i,3j,4m,4n,4o,a/sy106/sy110/boee:10,1f,1j,1n,1o,2,2a,2b,2c,2i,3j,3z,40,4m,4n,4o,4p,4q,4r,a,q,r,s,t,u,w,x,z/sy113:2i,48/sy111:1n,2j,2k,3,4t/sy112:1f,1p/irc:1f,1j,1m,1n,1o,1p,2,2i,2j,2k,2p,2r,2s,3,3b,3c,3d,4,48,4m,4q,4r,4t,4u,4v,5,a,l,t,x/sy114:4o/sy115:2i,2m,2n,3j,4m,4t,4x,a,l/sy116:4m,4o,4x,a/bb:2i,2m,2n,3j,48,4m,4o,4t,4x,4y,4z,a,l/ivf:4m,4o,4x,4z,a/prw:1f,1p,4v/jstr:10,1j,2,2a,2b,2c,2i,3j,4m,4n,4o,4p,a,q,r,s,t,u,w,x,z/str:10,1j,2,2a,2b,2c,2i,3j,4m,4n,4o,4p,a,q,r,s,t,u,w,x,z/ifl/itp:1j,2f,2i,2j,4g,a,l,x/sy117/an:57/kpvlbx:1n/knf:57/sy118:3f,l/kp:3f,5b,l/rk:1j,3,3f,x/lpt:1j,2i,48,4t,x/la/lr:2i,2j,2k,2l,2m,2n,2o,3k,x/dob/sy119/fy:1f,1g,1h,1l,1n,1o,1p,1q,1r,1s,1t,1u,1v,1x,5i/fob:2i,2j,2k,2l,2m,2n,3k/shlb:1m,1n,1p,2r,2s,3b,3c,3d,5i,l,t/cwsc:1n,2i,3j/cwuc/sy120/sc:5i,5o/sc3d:5o/sy121/sy122:5r/wobd:5r,5s/hp:1f,1g,1h,1l,1n,1o,2b,32,33/imap:3j,3l/lu:1j,27,28,x/pl/plcs:1j,27,28,x/sy124:1f,1p/sy123:1h,1l,1n,2r,2w,5z/lor:15,1f,1g,1h,1l,1n,1o,1p,1q,1r,1s,1t,1u,1v,1w,2,2f,2r,2w,3r,5z,60,a,l,q,r,s,t,u,v,x,y,z/mfd:2i,2j,2k,2l,2m,2n/m:18,1n,27,2a,2b,2c,2d,a,q/nvm:1n,2i,2j,2m,48/nqsb/mock/nmd/nws/ppl:1f,1p,5z,a/pi:4e,a/prs:a/sy125/sy126/psrpc:1a,1f,1g,1h,1l,1m,1n,1o,1p,1q,1r,1s,1u,2p,2q,2r,2s,2t,2u,2v,2w,2x,2y,2z,3b,3c,3d,3o,6c,6d,t/gnko:6d/sy127:2p,3a,x/sy128:1f,1h,1l/gksp:1f,1g,1h,1l,1n,1o,1p,1q,1r,1s,1t,1u,1v,1x,2f,2p,2r,2s,2t,2u,2w,3a,5z,60,6d,6g,6h,a,x/pgl:1j,5i,q,x/pis:1j,5i,x/psj:1f,1g,1h,1l,1n,1o,1p,1q,1r,1s,1t,1u,1v,1w,6c/pmp/ptbm:1f,1g,1h,1l,1n,1o,1p,1q,1r,1s,1t,2r,2v,2w/pswtr/pstt:1f,1g,1h,1l,1n,1o,1p,1q,1r,1s,1t,1u,1v,1w,6c/dvdu/ob/qi:8,q,x/spr/ctm:2i/gsac:5r/sy129/sy131/sy130:6w,6x/gsai:2i,2m,2n,3j,48,4m,4o,4t,4x,4y,5r,6w,6x,6y,a,l/csp/bds:3z,40,x/ntf:x/sy132/ho:1f,1j,2p,6x,73,x/sy133/srst:1j,2a,6d,75,q,x/cirosm:2i,2j,2k,2l,2m,2n,2o,3j,48/st/sfa:3z/sic/skp:1f,2i,2j,2k,2l,3b/exy:1n,4m,4n/sy134:4u/tnv:1n,2i,2j,2k,2l,2m,2n,2o,3,48,4t,4u,7d/tnt:2i,2j,2k,2l,2m,2n,2o,3j/sy135/tdu:1f,2i,2j,2k,2l,2m,2n,2o,5o,75,7g/tts:l/duf:7g/vt:1j,2f,a,x/pcc/p:10,11,12,13,2,3,4,43,44,45,5,a,e,f,l,q,r,s,t,u,v,w,x,y,z/rcs/r/rem:18,2f,a,x/ssb/sf/sy136/srl:35,3z,40,7s/tbt/sy137/tbpr:7v/tbui:2a,2b,2c,7v,a,q/ttbcdr:1f,1g,1h,1l,1n,1o,2b,2i,2j,2k,3,32,33,48,4t,4u,7d/vm:2/vac/sb:18,a,b/sb_dcsp:18,a,b/sb_he:a,b/sb_sri:18,a,b/sb_mas:a,b/sb_mob:a,b/sb_mobh:a,b/sb_mps:a,b/sb_omni:42,44,a,b/sb_tab:a,b/tr:1f,1g,1h,1l,1n,6h/wobnm:2i,2j,2k,2l,2m,2n,2o,48,4t,5r,5s/sy138:a/ppr:8d,a/sy139:6d/sbub:1a,1f,1g,1h,1n,1p,1q,1r,2p,2q,2r,2s,2t,2u,2v,2w,2x,2y,6d,8f/tbh/sy140/sy141:6w/sy142:0,6w,6y,8i,8j,a/dvl:0,6w,6x,6y,8i,8j,8k,a/tic/tiu:2i,2m,2n,3j,48,4m,4o,4t,4x,4y,4z,a,l/sy143:27,3j/vs:27,3j,8o/sy144/agsa:5r,8q,l/agsacm:1f,1g,1h,1l,1n,1o,1p,1q,1r,1s,1t,1u,1v,1w,1x,3n/gsaiv:4m,4o,4x,4z,5r,a/gsapr:5r/gsarm:8q/sac:6d/epb:r,s/ccu/aur/idck/bihu:n/sy145/mpck:1f,1l,1m,1n,2r,2s,3c,8d,92,a,t/psb:6d/sdl:1a,1f,1g,1h,1l,1n,1o,1s,1u,2p,2q,3o,6d/prec:1f,1g,1h,1l,1n,1o,1p,1q,1r,1s,1t,1u,1v,1x,2f,2r,2v,2w,2x,2z,3,5z,60,6d,73,a,x/stsm:1f,1n,1p,1q,1r,2r,2v,2w,2x,2z,30,6d,8f/am:35,7s/stt:1f,1g,1h,1l,1n,1o,1p,1q,1r,1s,1t,1u,1v,1w,6c,6d/spop:1f,1m,1n,1p,2f,2p,2r,2s,3a,3b,3c,3d,6d,6g,92,a,t,x/kpt:2i,2j,2k,2l,2m,2n,2o,3f,5b,l/tlie:3m,a/tab:2i,a/vst/sy146/owt:2i,2j,2k,2l,2m,2n,2o,48,4t,9f/duf2:7g/nmns:2i,2j,2k,2l,2m,2n,2o/sy148/sy147:3j,9j/miuv:3j,4m,4o,4x,4z,9j,9k,a,l/ms:3j,4m,9j,9k,a/kpm:2i,2j,2k,2l,2m,2n,2o,3f,3j,5b,l/kptm:4r/mlr/wobf:5r,5s/wob:3j,5r,5s/df:0,6w,6x,6y,8i,8j,8k,a/mld:27,3j,8i,8o,9j,a,l/mgq:0,8i/mbhp:1j,x/mfh:3j/mbje/mbpe:43/mbsf:a/mhsb:r,s/msbb:6w,8j,r,s/mbsk/mbsb/mad:2f,2g,a,x/pmsrpc/owm:3j,9f\");\n    } catch (e) {\n        _._DumpException(e);\n    };\n;\n    try {\n        var lk = function(a) {\n            this.api = a;\n            this.ll = a.c;\n            this.Wa = a.e;\n            this.ca = a.f;\n            this.B = a.g;\n            this.A = a.h;\n            this.J = a.i;\n            this.D = a.j;\n            this.dd = a.k;\n            this.L = a.l;\n            this.M = a.n;\n            this.Q = a.r;\n            this.V = a.s;\n            this.$ = a.t;\n            this.H = a.u;\n            this.Gb = a.v;\n            this.AM = a.x;\n            this.T = a.y;\n            this.Ma = a.z;\n            this.Da = a.aa;\n            this.va = a.ab;\n            this.Za = a.ac;\n        };\n        _.mk = function(a, b) {\n            return ((b ? new lk(b.api) : null));\n        };\n        _.nk = function(a, b, c) {\n            return (((a = a.L(b, c)) ? new lk(a) : null));\n        };\n        _.ok = function(a) {\n            switch (a) {\n              case 200:\n            \n              case 201:\n            \n              case 202:\n            \n              case 204:\n            \n              case 206:\n            \n              case 304:\n            \n              case 1223:\n                return !0;\n              default:\n                return !1;\n            };\n        ;\n        };\n        (0, _.Vg)(_.x.G(), \"sy7\");\n        _.y = ((_.y || {\n        }));\n        (0, _.Sg)(_.x.G(), \"sy7\");\n        (0, _.Wg)(_.x.G(), \"sy7\");\n    } catch (e) {\n        _._DumpException(e);\n    };\n;\n    try {\n        (0, _.Vg)(_.x.G(), \"sy6\");\n        (0, _.Sg)(_.x.G(), \"sy6\");\n        (0, _.Wg)(_.x.G(), \"sy6\");\n    } catch (e) {\n        _._DumpException(e);\n    };\n;\n    try {\n        var xba = function(a, b, c, d, e, f) {\n            function g(a) {\n                ((a && (a.send(null), n.push(a))));\n            };\n        ;\n            function h(a, c) {\n                var d = [0,!1,];\n                return function() {\n                    if (((1 != a.readyState))) {\n                        try {\n                            if (((((4 == a.readyState)) && ((0 == a.JSBNG__status))))) {\n                                f.handleError(1, 21, l, null, c);\n                                k(a);\n                                return;\n                            }\n                        ;\n                        ;\n                        } catch (e) {\n                            f.handleError(1, 21, l, null, c);\n                            k(a);\n                            return;\n                        };\n                    ;\n                        ((((((((((3 == a.readyState)) || ((4 == a.readyState)))) && ((200 == a.JSBNG__status)))) && ((0 > ((a.getResponseHeader(\"Content-Type\") || \"\")).indexOf(\"application/json\"))))) ? (f.handleError(1, 12, l, null, {\n                            response: a.responseText,\n                            url: c\n                        }), k(a)) : ((((((3 == a.readyState)) && b)) ? d = f.HR(a.responseText, d[0], l, c) : ((((4 == a.readyState)) && (((((200 == a.JSBNG__status)) ? d = f.HR(a.responseText, d[0], l, c, !0) : ((((((400 <= a.JSBNG__status)) && ((500 > a.JSBNG__status)))) ? f.handleError(1, 0, l, null, c) : ((((((500 <= a.JSBNG__status)) && ((600 > a.JSBNG__status)))) && f.handleError(1, 1, l, null, c))))))), ((d[1] && k(a))))))))));\n                    }\n                ;\n                ;\n                };\n            };\n        ;\n            function k(a) {\n                for (var b = 0, c; c = n[b]; ++b) {\n                    if (((a == c))) {\n                        n.splice(b, 1);\n                        break;\n                    }\n                ;\n                ;\n                };\n            ;\n                for (; ((((n.length < d)) && p.length)); ) {\n                    g(p.shift());\n                ;\n                };\n            ;\n                ((a.A && a.A()));\n            };\n        ;\n            var l = f.Sf(((a ? 5 : ((b ? 1 : 2))))), n = [], p = [];\n            if (((((\"number\" != typeof d)) || ((1 > d))))) {\n                d = 5;\n            }\n        ;\n        ;\n            return {\n                open: function() {\n                    var b = (0, _.pi)();\n                    return ((a ? ((!!b && ((\"withCredentials\" in b)))) : !!b));\n                },\n                dd: function(b, k) {\n                    var l = (0, _.pi)();\n                    if (l) {\n                        if (l.open(\"GET\", b), ((a && (l.withCredentials = !0))), l.A = k, l.onreadystatechange = h(l, b), ((n.length < d))) {\n                            g(l);\n                        }\n                         else {\n                            if (c) {\n                                for (; n.length; ) {\n                                    var r = n.shift();\n                                    r.onreadystatechange = (0, _.ka)();\n                                    r.abort();\n                                    ((r.A && r.A()));\n                                };\n                            ;\n                                g(l);\n                                ((e && f.VQ(d)));\n                            }\n                             else p.push(l);\n                        ;\n                        }\n                    ;\n                    }\n                ;\n                ;\n                },\n                getInfo: function() {\n                    return l;\n                },\n                xE: function() {\n                    return b;\n                },\n                EI: function() {\n                    return ((c && ((n.length >= d))));\n                },\n                close: function() {\n                    p = [];\n                    for (var a = 0; ((a < n.length)); ++a) {\n                        var b = n[a];\n                        ((b && (b.onreadystatechange = (0, _.ka)())));\n                        ((((b && ((((0 != b.readyState)) && ((4 != b.readyState)))))) && b.abort()));\n                        ((b.A && b.A()));\n                    };\n                ;\n                    n = [];\n                }\n            };\n        };\n        var yba = function(a, b, c, d, e) {\n            function f() {\n                return ((b && ((p.length >= c))));\n            };\n        ;\n            function g(a) {\n                var b = t[a];\n                if (b) {\n                    delete t[a];\n                    for (var c = 0; ((c < p.length)); ++c) {\n                        if (((p[c] == a))) {\n                            p.splice(c, 1);\n                            break;\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    window.JSBNG__setTimeout(function() {\n                        try {\n                            (0, _.yd)(b), b.src = ((_.sc.Hc ? \"blank.html\" : \"about:blank\"));\n                        } catch (a) {\n                        \n                        };\n                    ;\n                    }, 0);\n                    ((m[a] && (m[a](), delete m[a])));\n                }\n            ;\n            ;\n            };\n        ;\n            function h(a, b) {\n                ((_.sc.Hc ? b.onreadystatechange = function() {\n                    var c = b.readyState;\n                    ((((((\"loaded\" != c)) && ((\"complete\" != c)))) || g(a)));\n                } : b.JSBNG__onload = function() {\n                    g(a);\n                }));\n            };\n        ;\n            var k = ((((\"tljp\" + (0, _.Ve)())) + a)), l = e.Sf(4), n = 0, p = [], m = {\n            }, t = {\n            };\n            return {\n                open: (0, _.ua)(!0),\n                dd: function(a, b) {\n                    var l = window.JSBNG__document.createElement(\"script\"), G = ((k + n++));\n                    l.src = ((((a + \"&wrapid=\")) + G));\n                    t[G] = l;\n                    if (f()) {\n                        for (; p.length; ) {\n                            g(p[0]);\n                        ;\n                        };\n                    ;\n                        ((d && e.VQ(c)));\n                    }\n                ;\n                ;\n                    p.push(G);\n                    ((b && (m[G] = b)));\n                    h(G, l);\n                    (0, _.Me)(l);\n                },\n                kF: function(a, b, c) {\n                    ((t[a] && (e.VE(b), ((((c && m[a])) && (m[a](), delete m[a]))))));\n                },\n                getName: function() {\n                    return k;\n                },\n                getInfo: function() {\n                    return l;\n                },\n                xE: (0, _.ua)(!1),\n                EI: f,\n                close: function() {\n                    {\n                        var fin38keys = ((window.top.JSBNG_Replay.forInKeys)((t))), fin38i = (0);\n                        var a;\n                        for (; (fin38i < fin38keys.length); (fin38i++)) {\n                            ((a) = (fin38keys[fin38i]));\n                            {\n                                g(a), ((m[a] && (m[a](), delete m[a])));\n                            ;\n                            };\n                        };\n                    };\n                ;\n                }\n            };\n        };\n        var zba = function(a, b, c, d) {\n            function e(a, b, c) {\n                function e() {\n                    n:\n                    {\n                        var b, f;\n                        try {\n                            b = a.JSBNG__location.href, f = ((((7 >= r)) || ((\"complete\" == a.JSBNG__document.readyState))));\n                        } catch (h) {\n                            d.handleError(1, 13, l, h, void 0);\n                            break n;\n                        };\n                    ;\n                        try {\n                            ((((n.test(b) || ((((a.google && a.google.loc)) || !((f && ((0 > b.indexOf(p[c]))))))))) || d.handleError(1, 19, l, void 0, void 0)));\n                        } catch (m) {\n                            d.handleError(1, 7, l, m, void 0);\n                        };\n                    ;\n                        ((((((w == g.nJ)) && a)) && (a.src = \"about:blank\")));\n                    };\n                ;\n                };\n            ;\n                b = window.JSBNG__document.getElementsByName(b);\n                for (var h = 0, m; m = b[h++]; ) {\n                    ((((\"div\" == m.nodeName)) && ((0, _.$e)(m, \"load\", e), f(m))));\n                ;\n                };\n            ;\n                if (((((w == g.cJ)) && !p[c]))) {\n                    try {\n                        a.JSBNG__document.title = window.JSBNG__document.title;\n                    } catch (k) {\n                    \n                    };\n                }\n            ;\n            ;\n            };\n        ;\n            function f(a) {\n                if (((((w == g.nJ)) && ((8 <= r))))) {\n                    var b = window.JSBNG__document.createElement(\"div\");\n                    b.style.display = \"none\";\n                    (0, _.vd)(b, a);\n                }\n            ;\n            ;\n            };\n        ;\n            var g = {\n                nJ: 0,\n                cJ: 1\n            }, h = ((b || ((((\"tlif\" + (0, _.Ve)())) + a)))), k = ((((\"^\" + h)) + \"[0-9]+$\")), l = d.Sf(3), n = /(\\/blank\\.html|about:blank)$/, p = [], m = {\n            }, t = [], s = 0, r = 0, w, G = window.JSBNG__document;\n            if (((((\"number\" != typeof c)) || ((1 > c))))) {\n                c = 1;\n            }\n        ;\n        ;\n            ((_.sc.Hc && (r = ((window.JSBNG__document.documentMode ? window.JSBNG__document.documentMode : (0, window.parseInt)(_.vc.split(\".\")[0], 10))))));\n            w = ((((r && ((7 >= r)))) ? g.cJ : g.nJ));\n            return {\n                open: function() {\n                    if (((_.sc.Hc && !(0, _.yc)(\"10\")))) {\n                        try {\n                            var a = window.google.ihtmlfile = new window.ActiveXObject(\"htmlfile\");\n                            a.open();\n                            a.close();\n                            a.parentWindow.google = window.google;\n                            (0, _.$e)(window, \"unload\", function() {\n                                ((window.google.ihtmlfile && (window.google.ihtmlfile.parentWindow.google = null, window.google.ihtmlfile = null)));\n                            });\n                            G = a;\n                        } catch (b) {\n                            G = window.JSBNG__document, d.handleError(1, 2, l, b, void 0);\n                        };\n                    }\n                ;\n                ;\n                    for (a = 0; ((a < c)); ++a) {\n                        var f = ((h + a)), g;\n                        if (!t[a]) {\n                            try {\n                                var m = G.createElement(\"div\");\n                                m.JSBNG__name = f;\n                                m.style.display = \"none\";\n                                m.src = \"about:blank\";\n                                var r = G.createElement(\"DIV\");\n                                r.id = f;\n                                r.appendChild(m);\n                                G.body.appendChild(r);\n                                g = t[a] = m.contentWindow;\n                            } catch (k) {\n                                return d.handleError(1, 5, l, k, void 0), !1;\n                            };\n                        }\n                    ;\n                    ;\n                        if (!g) {\n                            return !1;\n                        }\n                    ;\n                    ;\n                        e(g, f, a);\n                    };\n                ;\n                    return !0;\n                },\n                dd: function(a, b) {\n                    s = ((((s + 1)) % c));\n                    var d = ((h + s));\n                    a += ((\"&wrapid=\" + (0, window.encodeURIComponent)(d)));\n                    var e = t[s].JSBNG__location;\n                    ((((w == g.cJ)) ? e.href = a : e.replace(a)));\n                    ((b && (m[d] = b)));\n                    p[s] = a;\n                },\n                kF: function(a, b, c) {\n                    ((((a && a.match(k))) && (d.VE(b), ((((c && m[a])) && (m[a](), delete m[a]))))));\n                },\n                getName: function() {\n                    return h;\n                },\n                getInfo: function() {\n                    return l;\n                },\n                xE: (0, _.ua)(!0),\n                close: function() {\n                    for (var a = 0; ((a < c)); ++a) {\n                        var b = ((h + a));\n                        (0, _.yd)(G.getElementById(b));\n                        ((m[b] && (m[b](), delete m[b])));\n                    };\n                ;\n                }\n            };\n        };\n        var Aba = function(a) {\n            function b() {\n                l.reset();\n                n.reset();\n                for (var a = 0, b = 0, c = 0, d = 0; ((d < h.length)); ++d) {\n                    var e = g[h[d]], f = ((e.Ft || 0)), k = e.wu, e = e.Ct;\n                    ((((0 < f)) && (l.Ft += f, a++)));\n                    ((((0 < k)) && (l.wu += k, b++)));\n                    ((((0 < e)) && (l.Ct += e, c++)));\n                    n.Ft = Math.max(f, n.Ft);\n                    n.wu = Math.max(k, n.wu);\n                    n.Ct = Math.max(e, n.Ct);\n                };\n            ;\n                ((((1 < a)) && (l.Ft = ((((l.Ft - n.Ft)) / ((a - 1)))))));\n                ((((1 < b)) && (l.wu = ((((l.wu - n.wu)) / ((b - 1)))))));\n                ((((1 < c)) && (l.Ct = ((((l.Ct - n.Ct)) / ((c - 1)))))));\n            };\n        ;\n            function c() {\n                var a = {\n                    Ft: null,\n                    wu: 0,\n                    Ct: 0,\n                    reset: function() {\n                        a.Ft = a.wu = a.Ct = 0;\n                    }\n                };\n                return a;\n            };\n        ;\n            function d(a, b, d, e) {\n                var r = g[a];\n                if (!r) {\n                    var n = r = c(), l = h[k];\n                    ((l && delete g[l]));\n                    g[a] = n;\n                    h[k] = a;\n                    k = ((((k + 1)) % f));\n                }\n            ;\n            ;\n                ((((((null != b)) && ((null == r.Ft)))) && (r.Ft = b)));\n                ((((null != d)) && (r.wu = d)));\n                ((((null != e)) && (r.Ct += e)));\n            };\n        ;\n            function e(a, b) {\n                for (var c = 0, d; ((c < a.length)); ++c) {\n                    if (d = b[c], ((((0 < d)) && ((a[c] > d))))) {\n                        return !0;\n                    }\n                ;\n                ;\n                };\n            ;\n                return !1;\n            };\n        ;\n            var f = ((a || 10)), g = {\n            }, h = [], k = 0, l = c(), n = c();\n            a = {\n                Q1: function(a, b) {\n                    d(a, b, null, null);\n                },\n                R1: function(a, b) {\n                    d(a, null, b, null);\n                },\n                L1: function(a, b) {\n                    d(a, null, null, b);\n                },\n                ZU: function(a, c, d) {\n                    b();\n                    var g = [l.Ft,l.wu,l.Ct,], r = [n.Ft,n.wu,n.Ct,];\n                    if (a = a.BK(c, d)) {\n                        if (c = ((((h.length == f)) && e(g, a[0]))), ((e(r, a[1]) || c))) {\n                            return g.concat(r);\n                        }\n                    ;\n                    }\n                ;\n                ;\n                    return null;\n                },\n                l0: b,\n                lW: function() {\n                    return l;\n                },\n                xK: function() {\n                    return n;\n                },\n                yW: function() {\n                    return h.length;\n                }\n            };\n            a.f4 = d;\n            return a;\n        };\n        var pk = function(a, b) {\n            function c() {\n                return ((!0 == a));\n            };\n        ;\n            var d = ((b || window.google.time())), e = !0, f, g, h, k, l = !0, n, p, m, t, s = !0;\n            return {\n                pU: function(a, b, d, m, t) {\n                    ((h || (h = [], k = {\n                    }, l = !0, n = a)));\n                    if (t) {\n                        var p = k, s;\n                        {\n                            var fin39keys = ((window.top.JSBNG_Replay.forInKeys)((t))), fin39i = (0);\n                            (0);\n                            for (; (fin39i < fin39keys.length); (fin39i++)) {\n                                ((s) = (fin39keys[fin39i]));\n                                {\n                                    p[s] = t[s];\n                                ;\n                                };\n                            };\n                        };\n                    ;\n                    }\n                ;\n                ;\n                    ((((b && c())) && h.push({\n                        data: b,\n                        url: a\n                    })));\n                    ((d && (e = !1)));\n                    f = window.google.time();\n                    g = m;\n                },\n                sE: function() {\n                    return ((k ? k : {\n                    }));\n                },\n                qK: function() {\n                    return ((h ? h.length : 0));\n                },\n                Gh: function() {\n                    return p;\n                },\n                YO: function(a) {\n                    return ((h ? h[a].data : null));\n                },\n                bP: function() {\n                    return t;\n                },\n                wE: function() {\n                    return ((!1 == e));\n                },\n                wK: c,\n                sW: function() {\n                    return l;\n                },\n                CE: function() {\n                    return d;\n                },\n                xW: function(a) {\n                    return ((((((((a && h)) && ((h.length > a)))) && h[a].url)) ? h[a].url : n));\n                },\n                MG: function() {\n                    return m;\n                },\n                refresh: function() {\n                    var a = window.google.time();\n                    ((((((f + ((1000 * g)))) < a)) && (h = [], l = !1)));\n                },\n                lS: function(a) {\n                    p = a;\n                },\n                L0: function(a) {\n                    t = a;\n                },\n                yM: function(a) {\n                    s = a;\n                },\n                sS: function(a) {\n                    m = a;\n                },\n                S0: function(a) {\n                    g = a;\n                },\n                tW: function() {\n                    return ((!1 == s));\n                }\n            };\n        };\n        var Bba = function() {\n            function a(b) {\n                if (((((((b && ((b.source == window)))) && c.length)) && ((((\"comm.df\" == b.data)) || ((\"comm.df.daisy\" == b.data))))))) {\n                    var d = (0, _.Ve)();\n                    do c.shift()(); while (((c.length && ((20 > (((0, _.Ve)() - d)))))));\n                    ((((c.length && ((\"comm.df.daisy\" == b.data)))) && window.JSBNG__setTimeout(function() {\n                        a(b);\n                    }, 0)));\n                }\n            ;\n            ;\n            };\n        ;\n            function b(b) {\n                ((c || (c = [], ((window.JSBNG__postMessage && (0, _.$e)(window, \"message\", a))))));\n                c.push(b);\n            };\n        ;\n            var c, d = !1;\n            return {\n                defer: function(e) {\n                    ((((d && (0, _.Qf)(76, []))) ? (b(e), ((((1 == c.length)) && window.JSBNG__setTimeout(function() {\n                        a({\n                            source: window,\n                            data: \"comm.df.daisy\"\n                        });\n                    }, 0)))) : ((window.JSBNG__postMessage ? (b(e), window.JSBNG__postMessage(\"comm.df\", window.JSBNG__location.href)) : window.JSBNG__setTimeout(e, 0)))));\n                },\n                sZ: function() {\n                    return ((d || ((!!c && ((0 < c.length))))));\n                },\n                AM: function(a) {\n                    d = a;\n                }\n            };\n        };\n        var Cba = function(a, b) {\n            function c() {\n                if (((((1 != l)) && (l = 1, ((((!p && window.JSBNG__document.JSBNG__addEventListener)) && (window.JSBNG__document.JSBNG__addEventListener(\"webkitvisibilitychange\", e, !1), p = !0))), e(), ((1 == l)))))) {\n                    var b = (0, _.Ve)(), c = function() {\n                        var e = (0, _.Ve)();\n                        d(((e - b)));\n                        ((((1 == l)) && (b = e, n = window.JSBNG__setTimeout(c, a))));\n                    };\n                    n = window.JSBNG__setTimeout(c, a);\n                }\n            ;\n            ;\n            };\n        ;\n            function d(b) {\n                b -= a;\n                ((((0 > b)) && (b = 0)));\n                h[k] = b;\n                k = ((((k + 1)) % g));\n            };\n        ;\n            function e() {\n                f(!!window.JSBNG__document.webkitHidden);\n            };\n        ;\n            function f(a) {\n                ((((a && ((1 == l)))) && (window.JSBNG__clearTimeout(n), l = 2)));\n                ((((a || ((2 != l)))) || c()));\n            };\n        ;\n            var g = ((b || 20)), h = [], k = 0, l = 0, n, p = !1, m = {\n                start: c,\n                JSBNG__stop: function() {\n                    window.JSBNG__clearTimeout(n);\n                    l = 0;\n                },\n                jW: function() {\n                    return h.slice(k).concat(h.slice(0, k));\n                }\n            };\n            m.H3 = d;\n            m.R3 = f;\n            return m;\n        };\n        var Dba = function(a) {\n            function b() {\n                return null;\n            };\n        ;\n            function c() {\n            \n            };\n        ;\n            function d() {\n                return !1;\n            };\n        ;\n            function e(a, b, c) {\n                for (var d = 0, e; e = t[d++]; ) {\n                    e.VE(a, b, c);\n                ;\n                };\n            ;\n            };\n        ;\n            function f(a, b, c, d, e) {\n                c = 0;\n                for (var f; f = t[c++]; ) {\n                    f.handleError(a, b, d, e);\n                ;\n                };\n            ;\n            };\n        ;\n            function g(a, b, c, d, f) {\n                a = a.split(\"/*\\\"\\\"*/\");\n                f = ((f ? 0 : -1));\n                for (var g = b; ((g < ((a.length + f)))); ++g) {\n                    ++b, ((a[g] && e(h(a[g], c, d))));\n                ;\n                };\n            ;\n                return [b,((((0 == a[((a.length - 1))].length)) && ((b == a.length)))),];\n            };\n        ;\n            function h(a, b, c) {\n                try {\n                    return ((_.sc.Hc ? (0, _.kf)(a) : (new Function(((\"return \" + a))))()));\n                } catch (d) {\n                    f(1, 9, b, d, c);\n                };\n            ;\n                return a;\n            };\n        ;\n            function k(a) {\n                return {\n                    Ni: a\n                };\n            };\n        ;\n            function l(a) {\n                window.google.log(\"omcr\", a.toString());\n            };\n        ;\n            var n = {\n                TF: !0,\n                Fd: !1\n            }, p = a.Ni, m, t = [], s = 1;\n            (function() {\n                var b = {\n                    VE: e,\n                    A: h,\n                    HR: g,\n                    Sf: k,\n                    handleError: f,\n                    VQ: l\n                };\n                switch (p) {\n                  case qk.Nz:\n                    m = zba(a.aK, a.iL, a.TL, b);\n                    break;\n                  case qk.NA:\n                    m = yba(a.aK, a.$A, a.IB, a.DB, b);\n                    break;\n                  case qk.fC:\n                \n                  case qk.BD:\n                \n                  case qk.iC:\n                    m = xba(((((p == qk.iC)) ? n.TF : n.Fd)), ((((p == qk.fC)) || ((p == qk.iC)))), a.$A, a.IB, a.DB, b);\n                };\n            ;\n            })();\n            if (!m) {\n                return null;\n            }\n        ;\n        ;\n            var r = {\n                I: function() {\n                    return p;\n                },\n                n0: function(a) {\n                    t.push(a);\n                },\n                p0: function(a) {\n                    for (var b = 0, c; c = t[b]; ++b) {\n                        if (((c == a))) {\n                            t.splice(b, 1);\n                            break;\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    ((t.length || (a.hM(), m.close())));\n                },\n                wW: function() {\n                    return (s++).toString();\n                },\n                open: m.open,\n                dd: m.dd,\n                kF: ((m.kF || c)),\n                EI: ((m.EI || d)),\n                getName: ((m.getName || b)),\n                getInfo: m.getInfo,\n                xE: m.xE\n            };\n            r.VE = e;\n            return r;\n        };\n        var Eba = function(a, b) {\n            function c(a) {\n                a = a.replace(/^http[s]?:\\/\\/[^\\/]*/, \"\");\n                var b = a.indexOf(\"?\");\n                return ((((-1 == b)) ? a : a.substring(0, b)));\n            };\n        ;\n            function d(a) {\n                return a.substring(((a.indexOf(\"?\") + 1))).split(\"&\").sort().join(\"&\");\n            };\n        ;\n            function e(a, b) {\n                ((b ? (((((X[b] && ((((X[b].JSBNG__name != a.JSBNG__name)) || ((X[b].toString() != a.toString())))))) && k(T.FT, 4, null, b))), X[b] = a) : $ = function(b, c) {\n                    var d = X[c];\n                    return ((d ? d(b) : a(b)));\n                }));\n            };\n        ;\n            function f() {\n                ++fa;\n            };\n        ;\n            function g(a) {\n                if (((\"string\" == typeof a))) {\n                    var b = c(a);\n                    if (b) {\n                        return a = $(a, b), wa.XO(b, a);\n                    }\n                ;\n                ;\n                }\n            ;\n            ;\n                return null;\n            };\n        ;\n            function h() {\n                return ja;\n            };\n        ;\n            function k(a, b, c, d) {\n                if (((((a == T.sN)) || ((a == T.ERROR))))) {\n                    var e = ((S ? S.getInfo() : null)), e = {\n                        _svty: a,\n                        _err: b,\n                        _type: ((e && e.Ni))\n                    };\n                    ((d && (e._data = (0, window.encodeURIComponent)(((\"\" + d))))));\n                    try {\n                        e._wl = (0, window.encodeURIComponent)((0, _.bg)()), window.google.ml(((c || Error(\"comm\"))), !1, e);\n                    } catch (f) {\n                    \n                    };\n                ;\n                }\n            ;\n            ;\n                for (c = 0; e = ga[c++]; ) {\n                    e.zb(a, b, d);\n                ;\n                };\n            ;\n            };\n        ;\n            function l(a, b) {\n                var c = ((((-1 == a.indexOf(\"?\"))) ? \"?\" : \"&\")), d = P;\n                if (window.google.mcp) {\n                    var d = P.split(\".\"), e = window.google.mcp(d[1]), d = ((((d[0] + \".\")) + e));\n                }\n            ;\n            ;\n                return ((((((((((((((((((a + c)) + \"tch=\")) + S.I())) + \"&ech=\")) + b)) + \"&psi=\")) + d)) + \".\")) + fa));\n            };\n        ;\n            function n(a) {\n                if (a = Dba(a)) {\n                    if (a.n0(ya), a.open()) {\n                        return S = a, b.m0(S), ja = !0;\n                    }\n                ;\n                }\n            ;\n            ;\n                return !1;\n            };\n        ;\n            function p(a, b, c) {\n                a.push({\n                    zb: b,\n                    Pd: ((c || 0))\n                });\n                a.sort(function(a, b) {\n                    return ((b.Pd - a.Pd));\n                });\n            };\n        ;\n            function m(a, b) {\n                for (var c = 0, d; d = a[c]; ++c) {\n                    if (((d.zb == b))) {\n                        a.splice(c, 1);\n                        break;\n                    }\n                ;\n                ;\n                };\n            ;\n            };\n        ;\n            function t(a, b, c) {\n                return ((a.wK() ? function() {\n                    var d = \"\";\n                    if (a) {\n                        for (var e = a.qK(), e = ((c ? Math.min(c, e) : e)), f = 0; ((f < e)); ++f) {\n                            var g = a.YO(f);\n                            ((g && (d += g)));\n                        };\n                    }\n                ;\n                ;\n                    return ((d.length ? d : b));\n                } : function() {\n                    return b;\n                }));\n            };\n        ;\n            function s(a) {\n                return ((((S && ja)) ? ((S.I() == a)) : !1));\n            };\n        ;\n            function r(a) {\n                return ((((a && (a = a.match(Fba)))) ? a[1] : \"\"));\n            };\n        ;\n            function w(a, b, c, d, e, f) {\n                var g = wa.nW(b, d, !0);\n                ((g || (((g = wa.oW(b, c, !0)) ? wa.TN(b, g.Gh(), d, g) : (g = ((f ? Z.iN : Z.eN)), a = $(a, b), g = pk(g, da[c]), g.sS(c), g.yM(e), wa.TN(b, a, d, g))))));\n                return g;\n            };\n        ;\n            function G(a, b, c, d, e, f, g, h, m, r) {\n                var n = ((W[d] || W[\"_?\"]));\n                if (((n && n.length))) {\n                    d = 0;\n                    for (var l; l = n[d]; ++d) {\n                        l.zb(a, c, f, !b, ((g == R.uN)), e, h, m, r);\n                    ;\n                    };\n                ;\n                }\n                 else k(T.ERROR, 10, null, d);\n            ;\n            ;\n            };\n        ;\n            function J(a, b) {\n                var c = wa.XO(a, b);\n                if (c) {\n                    var d = c.MG(), e = c.bP(), f = c.wE(), g = c.qK(), h = c.sE(), m = (0, _.Ve)();\n                    c.yM(ca.vN);\n                    for (var r = 0; ((r < g)); ++r) {\n                        (function(b, f, g) {\n                            L.defer(function() {\n                                G(b, f, t(c, b, ((g + 1))), a, m, c.xW(g), R.uN, d, e, h);\n                            });\n                        })(c.YO(r), ((f && ((r == ((g - 1)))))), r);\n                    ;\n                    };\n                ;\n                    return d;\n                }\n            ;\n            ;\n            };\n        ;\n            function u(a, b, c, d) {\n                var e = b.wE();\n                ((((((c == F.uT)) || ((e && d)))) ? wa.abort(a, b) : ((e && wa.bV(a, b)))));\n            };\n        ;\n            function E(a, b) {\n                if (!ha[a]) {\n                    var c = (((0, _.Ve)() - b.CE())), d = b.MG();\n                    na.Q1(d, c);\n                    ((b.wE() && na.R1(d, c)));\n                }\n            ;\n            ;\n            };\n        ;\n            var F = {\n                uT: -1,\n                s3: 0,\n                UT: 1\n            }, R = {\n                uN: !0,\n                BT: !1\n            }, Z = Gba, T = Hba, ca = Iba, P = ((((window.google.kEI + \".\")) + (0, _.Ve)())), S, $, X = {\n            }, W = {\n            }, ga = [], ja = !1, V = 59, ia, ha = {\n            }, da = {\n            }, na, Y, fa = 0, wa, L;\n            e(d);\n            na = Aba();\n            wa = b.pW();\n            L = Bba();\n            var ya = {\n                VE: function(a, b, d) {\n                    if (ja) {\n                        var e = a.u, f = ((e ? c(e) : \"\")), g = r(e), h = a.e, m = w(e, f, g, h, a.p, d);\n                        E(f, m);\n                        b = a.c;\n                        var k = ((!b || ((b != F.UT)))), n = a.d;\n                        a = a.a;\n                        if (((((\"undefined\" != typeof n)) && ((null != n))))) {\n                            var l = ((e ? e.replace(Jba, \"\") : \"\"));\n                            m.pU(l, n, k, V, a);\n                            a = function() {\n                                var a = (0, _.Ve)();\n                                G(n, k, t(m, n), f, m.CE(), l, R.BT, g, h, m.sE());\n                                ((((1 < m.qK())) && (a = (((0, _.Ve)() - a)), na.L1(g, a), ((((((((k && ia)) && (a = na.ZU(ia, f, e)))) && ia.vI)) && ia.vI(a))))));\n                            };\n                            ((m.tW() || ((L.sZ() ? L.defer(a) : a()))));\n                        }\n                    ;\n                    ;\n                        u(f, m, b, d);\n                    }\n                ;\n                ;\n                },\n                handleError: k,\n                hM: function() {\n                    b.hM(S);\n                }\n            };\n            return {\n                a: (0, _.ua)(\"_?\"),\n                b: h,\n                c: function() {\n                    na.l0();\n                    var a = na.lW(), b = na.xK(), c = na.yW(), a = [[c,a.Ft,a.wu,a.Ct,],[c,b.Ft,b.wu,b.Ct,],];\n                    return ((Y ? a.concat([Y.jW(),]) : a));\n                },\n                d: function(a) {\n                    V = a;\n                },\n                e: function(a) {\n                    ia = {\n                        BK: a.a,\n                        vI: a.b\n                    };\n                },\n                f: function(a) {\n                    ((((\"function\" == typeof a)) && (c = a)));\n                },\n                g: e,\n                h: function(a, b, c) {\n                    if (b) {\n                        var d = W[b];\n                        ((d || (d = W[b] = [])));\n                        p(d, a, c);\n                    }\n                ;\n                ;\n                },\n                i: function(a, b) {\n                    p(ga, a, b);\n                },\n                j: function(c) {\n                    if (ja) {\n                        return !0;\n                    }\n                ;\n                ;\n                    ++fa;\n                    var d = b.AW();\n                    if (c) {\n                        for (var e = null, f = 0, g; g = a[f]; ++f) {\n                            if (((((g.Ni == qk.Nz)) ? ((((((g.Ni == c.Ni)) && ((g.iL == c.iL)))) && ((g.TL == c.TL)))) : ((((((((g.Ni == c.Ni)) && ((g.$A == c.$A)))) && ((g.IB == c.IB)))) && ((g.DB == c.DB))))))) {\n                                e = g;\n                                break;\n                            }\n                        ;\n                        ;\n                        };\n                    ;\n                        ((e || (e = c, a.push(e))));\n                        e.aK = d;\n                        return n(e);\n                    }\n                ;\n                ;\n                    for (f = 0; g = a[f]; ++f) {\n                        g.aK = d;\n                        if (n(g)) {\n                            return !0;\n                        }\n                    ;\n                    ;\n                        a.splice(f--, 1);\n                    };\n                ;\n                    return !1;\n                },\n                k: function(a, b, d, e, f) {\n                    if (ja) {\n                        var h = c(a), m = $(a, h), r = void 0;\n                        if (((((!b && !d)) && (r = J(h, m))))) {\n                            return L.defer(function() {\n                                (((((0, _.Qf)(82, [a,e,]) && e)) && e()));\n                            }), r;\n                        }\n                    ;\n                    ;\n                        d = S.wW();\n                        f = ((f ? ca.tT : ca.vN));\n                        b = pk(((b ? Z.iN : Z.eN)));\n                        da[d] = b.CE();\n                        b.yM(f);\n                        wa.oU(h, m, d, b);\n                        ((S.EI() && ++fa));\n                        a = l(a, d);\n                        S.dd(a, function() {\n                            var b = a, d = c(b);\n                            (((((b = g(b)) && !b.wE())) && wa.abort(d, b)));\n                            ((e && L.defer(e)));\n                        });\n                        return d;\n                    }\n                ;\n                ;\n                    k(T.sN, 14);\n                },\n                l: function(a) {\n                    return !!g(a);\n                },\n                m: function() {\n                    return s(qk.Nz);\n                },\n                n: function() {\n                    return s(qk.NA);\n                },\n                o: function() {\n                    return s(qk.BD);\n                },\n                p: function() {\n                    return s(qk.fC);\n                },\n                r: function() {\n                    return s(qk.iC);\n                },\n                s: function() {\n                    return ((((S && ja)) ? S.xE() : !1));\n                },\n                t: f,\n                u: function() {\n                    ((ja ? (ja = !1, S.p0(ya), S = null) : k(T.ERROR, 3)));\n                },\n                v: function(a, b) {\n                    var c = W[b];\n                    ((c && m(c, a)));\n                },\n                w: function(a) {\n                    m(ga, a);\n                },\n                x: function(a) {\n                    L.AM(a);\n                },\n                y: function(a) {\n                    ha[a] = 1;\n                },\n                z: function(a) {\n                    ((((((0 < a)) && !window.google.commPmActive)) && (window.google.commPmActive = !0, Y = Cba(a), Y.start())));\n                },\n                aa: function(a) {\n                    return ((((a && X[a])) ? X[a] : d));\n                },\n                ab: function(a, b) {\n                    var c = g(a);\n                    return ((((c && c.wE())) ? (c.S0(b), !0) : !1));\n                },\n                ac: function(a) {\n                    delete ha[a];\n                },\n                rW: h,\n                EY: f\n            };\n        };\n        var Kba = function() {\n            function a(a, b) {\n                var c = e[a];\n                if (c) {\n                    var d = b.MG();\n                    delete c.qF[d];\n                    delete c.gI[b.bP()];\n                }\n            ;\n            ;\n            };\n        ;\n            function b() {\n                function a(b) {\n                    {\n                        var fin40keys = ((window.top.JSBNG_Replay.forInKeys)((b))), fin40i = (0);\n                        var c;\n                        for (; (fin40i < fin40keys.length); (fin40i++)) {\n                            ((c) = (fin40keys[fin40i]));\n                            {\n                                ((d(b[c]) || delete b[c]));\n                            ;\n                            };\n                        };\n                    };\n                ;\n                };\n            ;\n                {\n                    var fin41keys = ((window.top.JSBNG_Replay.forInKeys)((e))), fin41i = (0);\n                    var b;\n                    for (; (fin41i < fin41keys.length); (fin41i++)) {\n                        ((b) = (fin41keys[fin41i]));\n                        {\n                            var h = c(b);\n                            a(h.qF);\n                            a(h.gI);\n                            a(h.VB);\n                        };\n                    };\n                };\n            ;\n            };\n        ;\n            function c(a) {\n                var b = e[a];\n                ((b || (b = e[a] = {\n                    qF: {\n                    },\n                    gI: {\n                    },\n                    VB: {\n                    }\n                })));\n                return b;\n            };\n        ;\n            function d(a) {\n                return ((((a && (a.refresh(), a.sW()))) ? a : null));\n            };\n        ;\n            var e = {\n            };\n            window.JSBNG__setInterval(b, 90000);\n            return {\n                oU: function(a, b, d, e) {\n                    a = c(a);\n                    ((d && (a.qF[d] = e, e.sS(d))));\n                    ((((b && e.wK())) && (a.VB[b] = e, e.lS(b))));\n                },\n                TN: function(a, b, d, e) {\n                    a = c(a);\n                    ((d && (a.gI[d] = e, e.L0(d))));\n                    ((((b && e.wK())) && (a.VB[b] = e, e.lS(b))));\n                    b = e.MG();\n                    delete a.qF[b];\n                },\n                oW: function(a, b, c) {\n                    return (((a = e[a]) ? (b = a.qF[b], ((c ? b : d(b)))) : null));\n                },\n                nW: function(a, b, c) {\n                    return (((a = e[a]) ? (b = a.gI[b], ((c ? b : d(b)))) : null));\n                },\n                XO: function(a, b) {\n                    var c = e[a];\n                    return ((c ? d(c.VB[b]) : null));\n                },\n                bV: a,\n                clear: function(a) {\n                    if (a) {\n                        for (var b = 0, c; c = a[b++]; ) {\n                            if (c = e[c]) {\n                                c.VB = {\n                                };\n                            }\n                        ;\n                        ;\n                        };\n                    }\n                     else {\n                        {\n                            var fin42keys = ((window.top.JSBNG_Replay.forInKeys)((e))), fin42i = (0);\n                            (0);\n                            for (; (fin42i < fin42keys.length); (fin42i++)) {\n                                ((c) = (fin42keys[fin42i]));\n                                {\n                                    if (a = e[c]) {\n                                        a.VB = {\n                                        };\n                                    }\n                                ;\n                                ;\n                                };\n                            };\n                        };\n                    }\n                ;\n                ;\n                },\n                abort: function(b, c) {\n                    var d = e[b];\n                    ((d && (a(b, c), delete d.VB[c.Gh()])));\n                },\n                A: b\n            };\n        };\n        var qk = {\n            B3: 0,\n            fC: 1,\n            BD: 2,\n            Nz: 3,\n            NA: 4,\n            iC: 5\n        }, Gba = {\n            eN: !0,\n            iN: !1\n        }, Hba = {\n            sN: 0,\n            ERROR: 1,\n            FT: 2\n        }, Iba = {\n            vN: !0,\n            tT: !1\n        }, Fba = /[&\\?]ech=([0-9]+)/, Jba = /[\\?&#](tch|ech|psi|wrapid)=[^&]*/g;\n        (0, _.Vg)(_.x.G(), \"c\");\n        var Lba = function() {\n            function a(a, b) {\n                return {\n                    Ni: g.Nz,\n                    iL: b,\n                    TL: ((a || 1))\n                };\n            };\n        ;\n            function b(a, b, c) {\n                return {\n                    Ni: g.NA,\n                    $A: !!a,\n                    IB: ((b || 5)),\n                    DB: !!c\n                };\n            };\n        ;\n            function c(a, b, c) {\n                return {\n                    Ni: g.BD,\n                    $A: !!a,\n                    IB: ((b || 5)),\n                    DB: !!c\n                };\n            };\n        ;\n            function d(a, b, c) {\n                return {\n                    Ni: g.fC,\n                    $A: !!a,\n                    IB: ((b || 5)),\n                    DB: !!c\n                };\n            };\n        ;\n            function e(a, b, c, d) {\n                if (((((b == g.Nz)) || ((b == g.NA))))) {\n                    b = l[b];\n                    {\n                        var fin43keys = ((window.top.JSBNG_Replay.forInKeys)((b))), fin43i = (0);\n                        var e;\n                        for (; (fin43i < fin43keys.length); (fin43i++)) {\n                            ((e) = (fin43keys[fin43i]));\n                            {\n                                b[e].kF(a, c, d);\n                            ;\n                            };\n                        };\n                    };\n                ;\n                }\n            ;\n            ;\n            };\n        ;\n            function f(a) {\n                switch (a) {\n                  case g.Nz:\n                \n                  case g.NA:\n                \n                  case g.BD:\n                    return !0;\n                  case g.fC:\n                    return ((!_.sc.Hc || ((_.sc.Hc && (0, _.yc)(\"10\")))));\n                  case g.iC:\n                    return !_.sc.Hc;\n                };\n            ;\n                return !1;\n            };\n        ;\n            var g = qk, h, k = [], l = {\n            }, n = 0, p;\n            l[g.Nz] = {\n            };\n            l[g.NA] = {\n            };\n            p = Kba();\n            (0, _.za)(\"google.td\", e, void 0);\n            var m = {\n                AW: function() {\n                    return n++;\n                },\n                m0: function(a) {\n                    var b = l[a.I()];\n                    ((b && (b[a.getName()] = a)));\n                },\n                hM: function(a) {\n                    var b = l[a.I()];\n                    ((b && delete b[a.getName()]));\n                },\n                pW: function() {\n                    return p;\n                }\n            };\n            return {\n                a: a,\n                b: b,\n                c: c,\n                d: d,\n                e: function(a, b, c) {\n                    return {\n                        Ni: g.iC,\n                        $A: !!a,\n                        IB: ((b || 5)),\n                        DB: !!c\n                    };\n                },\n                g: function(e) {\n                    if (e) {\n                        for (var n = [], r = 0, l; l = e[r++]; ) {\n                            ((f(l.Ni) && n.push(l)));\n                        ;\n                        };\n                    ;\n                        e = ((n.length ? n : null));\n                    }\n                     else if (((\"undefined\" != typeof h))) e = h;\n                     else {\n                        e = [[g.fC,d,],[g.BD,c,],[g.Nz,a,],[g.NA,b,],];\n                        n = [];\n                        for (r = 0; l = e[r++]; ) {\n                            ((f(l[0]) && (l = l[1](), n.push(l))));\n                        ;\n                        };\n                    ;\n                        e = h = ((n.length ? n : null));\n                    }\n                    \n                ;\n                ;\n                    if (!e) {\n                        return null;\n                    }\n                ;\n                ;\n                    e = Eba(e, m);\n                    k.push(e);\n                    return e;\n                },\n                h: e,\n                i: function(a) {\n                    p.clear(a);\n                    if (((((a && ((\"undefined\" != typeof a)))) && ((null != a))))) {\n                        var b = [], c;\n                        {\n                            var fin44keys = ((window.top.JSBNG_Replay.forInKeys)((a))), fin44i = (0);\n                            (0);\n                            for (; (fin44i < fin44keys.length); (fin44i++)) {\n                                ((c) = (fin44keys[fin44i]));\n                                {\n                                    if (!(0, _.Va)(a[c])) {\n                                        var d = ((c + \" = \"));\n                                        try {\n                                            d += a[c];\n                                        } catch (e) {\n                                            d += ((((\"*** \" + e)) + \" ***\"));\n                                        };\n                                    ;\n                                        b.push(d);\n                                    }\n                                ;\n                                ;\n                                };\n                            };\n                        };\n                    ;\n                        b.join(\"\\u000a\");\n                    }\n                ;\n                ;\n                    for (a = 0; b = k[a++]; ) {\n                        ((b.rW() && b.EY()));\n                    ;\n                    };\n                ;\n                }\n            };\n        }();\n        (0, _.za)(\"google.comm\", Lba, void 0);\n        (0, _.Sg)(_.x.G(), \"c\");\n        (0, _.Wg)(_.x.G(), \"c\");\n    } catch (e) {\n        _._DumpException(e);\n    };\n;\n    try {\n        _.Sq = function(a, b, c, d) {\n            this.B = a;\n            this.V = b;\n            this.A = null;\n            this.J = ((c || 0));\n            this.T = ((d || (0, _.ua)(!0)));\n            ((((null == a.getAttribute(\"aria-label\"))) && a.setAttribute(\"aria-label\", b)));\n            this.L = (0, _.$a)(this.nU, this);\n            this.D = (0, _.$a)(this.qV, this);\n            (0, _.$e)(this.B, \"mouseover\", this.L);\n            (0, _.$e)(this.B, \"mouseout\", this.D);\n            (0, _.$e)(this.B, \"JSBNG__focus\", this.L);\n            (0, _.$e)(this.B, \"focusin\", this.L);\n            (0, _.$e)(this.B, \"JSBNG__blur\", this.D);\n            (0, _.$e)(this.B, \"focusout\", this.D);\n            (0, _.$e)(this.B, \"mousedown\", this.D);\n            (0, _.$e)(this.B, \"click\", this.D);\n            (0, _.$e)(this.B, \"keydown\", this.D);\n        };\n        (0, _.Vg)(_.x.G(), \"sy30\");\n        _.q = _.Sq.prototype;\n        _.q.destroy = function() {\n            (0, window.JSBNG__clearTimeout)(this.Q);\n            (0, window.JSBNG__clearTimeout)(this.M);\n            this.aR();\n            (0, _.af)(this.B, \"mouseover\", this.L);\n            (0, _.af)(this.B, \"mouseout\", this.D);\n            (0, _.af)(this.B, \"JSBNG__focus\", this.L);\n            (0, _.af)(this.B, \"focusin\", this.L);\n            (0, _.af)(this.B, \"JSBNG__blur\", this.D);\n            (0, _.af)(this.B, \"focusout\", this.D);\n            (0, _.af)(this.B, \"mousedown\", this.D);\n            (0, _.af)(this.B, \"click\", this.D);\n            (0, _.af)(this.B, \"keydown\", this.D);\n        };\n        _.q.nU = function() {\n            ((this.T() && (window.JSBNG__clearTimeout(this.M), this.Q = window.JSBNG__setTimeout((0, _.$a)(this.fZ, this), 130))));\n        };\n        _.q.qV = function() {\n            window.JSBNG__clearTimeout(this.Q);\n            this.M = window.JSBNG__setTimeout((0, _.$a)(this.aR, this), 130);\n        };\n        _.q.fZ = function() {\n            if (!this.A) {\n                this.A = (0, _.Ne)(\"div\", this.V);\n                this.H = (0, _.Ne)(\"div\");\n                this.A.style.cssText = \"background:#2d2d2d;border:1px solid;border-color:#fff;box-shadow:1px 2px 4px rgba(0,0,0,0.2);box-sizing:border-box;color:#fff;display:block;font-size:11px;font-weight:bold;height:29px;line-height:29px;padding:0 10px;position:absolute;text-align:center;transition:opacity 0.13s;white-space:nowrap;visibility:hidden;z-index:2000;\";\n                ((_.sc.WEBKIT ? this.A.style.cssText += \"-webkit-box-shadow:0px 1px 4px rgba(0,0,0,0.2);-webkit-box-sizing:border-box;-webkit-transition:opacity 0.13s;\" : ((_.sc.GECKO ? this.A.style.cssText += \"-moz-box-shadow:0px 1px 4px rgba(0,0,0,0.2);-moz-box-sizing:border-box;-moz-transition:opacity 0.13s;\" : ((_.sc.OPERA && (this.A.style.cssText += \"-o-transition:opacity 0.13s;\")))))));\n                this.H.style.cssText = \"border:6px solid;border-color:#fff transparent;border-top-width:0;content:'';display:block;font-size:0px;height:0;line-height:0;position:absolute;top:-6px;width:0;\";\n                var a = (0, _.Ne)(\"div\");\n                a.style.cssText = this.H.style.cssText;\n                a.style.JSBNG__top = \"1px\";\n                a.style.left = \"-6px\";\n                a.style.borderColor = \"#2d2d2d transparent\";\n                this.H.appendChild(a);\n                this.A.appendChild(this.H);\n                window.JSBNG__document.body.appendChild(this.A);\n                var a = (0, _.qe)(this.B), b = this.B.offsetWidth, c = a.x, d = this.A.offsetWidth;\n                if (((0 == this.J))) {\n                    this.A.style.left = ((((((((b / 2)) - ((d / 2)))) + c)) + \"px\"));\n                    var e = (0, _.re)(this.A), f = (0, _.zc)(3);\n                    ((((((e + d)) > f)) ? this.A.style.left = ((((((((c + b)) - d)) + 1)) + \"px\")) : ((((0 > e)) && (this.A.style.left = ((((c - 1)) + \"px\")))))));\n                }\n                 else e = (0, _.ig)(), this.A.style.left = ((((((3 == this.J)) || ((((1 == this.J)) && e)))) ? ((((((((c + b)) - d)) + 1)) + \"px\")) : ((((c - 1)) + \"px\"))));\n            ;\n            ;\n                this.A.style.JSBNG__top = ((((((a.y + this.B.offsetHeight)) + 5)) + \"px\"));\n                ((((0 == this.J)) ? this.H.style.left = ((((((((((a.x + ((this.B.offsetWidth / 2)))) - this.A.offsetLeft)) - 1)) - 6)) + \"px\")) : (a = (0, _.ig)(), ((((((3 == this.J)) || ((((1 == this.J)) && a)))) ? this.H.style.right = \"18px\" : this.H.style.left = \"18px\")))));\n                this.A.style.visibility = \"visible\";\n            }\n        ;\n        ;\n        };\n        _.q.aR = function() {\n            ((this.A && ((0, _.yd)(this.A), this.A = null)));\n        };\n        (0, _.Sg)(_.x.G(), \"sy30\");\n        (0, _.Wg)(_.x.G(), \"sy30\");\n    } catch (e) {\n        _._DumpException(e);\n    };\n;\n    try {\n        (0, _.Vg)(_.x.G(), \"sb\");\n        _.y.$w = null;\n        _.y.xp = /^[6-9]$/;\n        var jTa = {\n            km: 0,\n            Wh: 1,\n            jm: 2,\n            Xd: 3\n        }, C4 = {\n            Ke: 0,\n            Oi: 5,\n            Qo: 19,\n            Pp: 30,\n            Wo: 32,\n            Di: 33,\n            Xo: 34,\n            Ah: 35,\n            Ik: 38,\n            bm: 39,\n            Lk: 40,\n            Uj: 41,\n            bz: 42,\n            ky: 43,\n            Cl: 44,\n            il: 45,\n            qp: 46,\n            Ey: 47,\n            Dy: 48,\n            By: 49,\n            ez: 50,\n            gz: 51,\n            ny: 52,\n            my: 54,\n            uy: 55,\n            qq: 56,\n            vy: 66,\n            Gy: 68,\n            Eu: 69,\n            Uy: 70,\n            Ov: 71,\n            Fo: 400,\n            Yx: 401,\n            Zx: 403,\n            Cy: 404,\n            Xx: 406,\n            Go: 407,\n            hz: 408,\n            Zr: 500,\n            Ty: 503,\n            jy: 504,\n            gy: 505,\n            ty: 507\n        }, kTa = {\n            EMPTY: 0,\n            Zl: 1,\n            Nh: 2\n        }, lTa = {\n            zq: 0,\n            Eo: 1,\n            Vx: 2,\n            Xp: 3,\n            Wp: 4\n        }, mTa = {\n            dD: 1,\n            hD: 2,\n            oD: 3,\n            LD: 4,\n            pD: 5,\n            qD: 6,\n            rD: 7,\n            Pv: 8,\n            sD: 9,\n            DD: 10,\n            ID: 11,\n            JD: 16,\n            KD: 12,\n            Zv: 13,\n            $v: 14,\n            MD: 15\n        }, nTa = {\n            Wl: 1,\n            $l: 2,\n            gx: 3,\n            Ul: 4,\n            cm: 5,\n            kx: 6,\n            bx: 7,\n            Ee: 8\n        }, D4 = {\n            IE: 0,\n            GECKO: 1,\n            OPERA: 2,\n            CHROME: 3,\n            SAFARI: 4,\n            WEBKIT: 5,\n            cj: 6,\n            $i: 7\n        }, oTa = {\n            Ng: \"left\",\n            JI: \"center\",\n            Fj: \"right\"\n        }, pTa = {\n            mx: 0,\n            Ng: 1,\n            Tn: 2\n        }, qTa = {\n            Fp: 0\n        }, E4 = {\n            DONT_CARE: 1,\n            Ci: 2,\n            nm: 3\n        }, rTa = {\n            Qh: 0,\n            mm: 1,\n            Xd: 2\n        }, sTa = {\n            Xy: \"a\",\n            Vy: \"d\",\n            bj: \"e\",\n            xy: \"h\",\n            Fy: \"i\",\n            Ry: \"j\",\n            ey: \"k\",\n            My: \"l\",\n            Sy: \"m\",\n            Ly: \"n\",\n            Ei: \"o\",\n            Fi: \"p\",\n            Qp: \"q\",\n            cz: \"r\",\n            hy: \"t\"\n        }, tTa = {\n            Ro: 0,\n            lq: 1,\n            Ho: 2,\n            Io: 3,\n            Ap: 4,\n            Np: 5,\n            nq: 6,\n            mq: 7,\n            yp: 8,\n            Uo: 9,\n            Gp: 10,\n            Cp: 11,\n            Dp: 12,\n            $p: 13,\n            Tp: 14,\n            yq: 15,\n            So: 16,\n            Vo: 17,\n            Op: 18,\n            rp: 19,\n            bj: 20,\n            Qs: 21,\n            To: 22,\n            py: 23,\n            Qy: 24,\n            Po: 25,\n            Ja: 26,\n            Ue: 27,\n            fq: 28,\n            Zy: 29\n        };\n        _.y.Rp = [23,24,];\n        _.y.F = {\n            um: 0,\n            Yw: 114,\n            Ua: 115,\n            Jb: 116,\n            wa: 117,\n            Z: 118,\n            ob: 119,\n            Ja: 374,\n            $a: 120,\n            Xa: 121,\n            Zf: 122,\n            Ca: 123,\n            yb: 124,\n            ec: 125,\n            gm: 230,\n            Ga: 126,\n            Pa: 127,\n            ra: 128,\n            Bh: 343,\n            gc: 129,\n            Xw: 231,\n            gb: 130,\n            Af: 131,\n            yh: 237,\n            hx: 132,\n            od: 134,\n            Qb: 189,\n            dm: 246,\n            jx: 264,\n            nc: 133,\n            jl: 184,\n            Og: 419,\n            Sd: 173,\n            vb: 135,\n            Ta: 136,\n            Xb: 137,\n            Sc: 138,\n            Ea: 139,\n            Rd: 140,\n            Bb: 141,\n            kg: 142,\n            lg: 240,\n            Ze: 143,\n            Cc: 144,\n            Mh: 347,\n            Dc: 191,\n            Db: 150,\n            Ib: 145,\n            Ic: 146,\n            Cb: 147,\n            lx: 148,\n            Df: 245,\n            De: 155,\n            Ab: 149,\n            jf: 154,\n            fh: 311,\n            Te: 153,\n            RENDERER: 152,\n            kb: 156,\n            qc: 151,\n            Ff: 158,\n            Vh: 294,\n            hm: 157,\n            Vc: 160,\n            Wd: 159\n        };\n        var uTa = {\n            Fd: 161,\n            Xh: 162\n        };\n        _.y.C = {\n        };\n        _.y.Ip = function(a) {\n            return {\n                xd: function() {\n                    return a.xd();\n                },\n                ha: function() {\n                    return a.ha();\n                },\n                Ba: function() {\n                    return a.Ba();\n                }\n            };\n        };\n        _.y.vq = function() {\n            function a(a) {\n                for (var b = [], e = 0, f; f = a[e++]; ) {\n                    b.push(((f.api || {\n                        a: f.Nb,\n                        b: f.X,\n                        c: f.Ya,\n                        d: f.I,\n                        e: f.Gc,\n                        f: f.ni,\n                        g: f.Ch,\n                        i: f.Dd,\n                        j: f.U,\n                        k: f.ke,\n                        l: f.Fg\n                    })));\n                ;\n                };\n            ;\n                return b;\n            };\n        ;\n            function b(a) {\n                for (var b = [], e = 0, f; f = a[e++]; ) {\n                    f = ((f.api || f)), b.push({\n                        api: f,\n                        Nb: f.a,\n                        X: f.b,\n                        Ya: f.c,\n                        I: f.d,\n                        Gc: f.e,\n                        ni: f.f,\n                        Ch: f.g,\n                        Dd: f.i,\n                        U: f.j,\n                        ke: f.k,\n                        Fg: f.l\n                    });\n                ;\n                };\n            ;\n                return b;\n            };\n        ;\n            _.y.Ob = function(a) {\n                var b = {\n                };\n                if (a) {\n                    for (var e = 0; ((e < a.length)); ++e) {\n                        b[a[e]] = !0;\n                    ;\n                    };\n                }\n            ;\n            ;\n                return b;\n            };\n            _.y.ej = function(b) {\n                var d = a(b.Ba());\n                return ((b.api || {\n                    a: b.ha,\n                    b: function() {\n                        return d;\n                    },\n                    c: b.xd\n                }));\n            };\n            _.y.Xq = a;\n            _.y.Uw = function(a) {\n                a = ((a.api || a));\n                var d = b(a.b());\n                return {\n                    api: a,\n                    ha: a.a,\n                    Ba: function() {\n                        return d;\n                    },\n                    xd: a.c\n                };\n            };\n            _.y.Ux = b;\n            _.y.kj = function(a) {\n                return ((a ? (a = a.toLowerCase(), ((((((((\"zh-tw\" == a)) || ((\"zh-cn\" == a)))) || ((\"ja\" == a)))) || ((\"ko\" == a))))) : !1));\n            };\n            _.y.getTime = function() {\n                return (new JSBNG__Date).getTime();\n            };\n            _.y.rf = function(a) {\n                return ((\"string\" == typeof a));\n            };\n            _.y.lj = function(a) {\n                return ((\"number\" == typeof a));\n            };\n        };\n        _.y.vq();\n        _.y.iy = null;\n        _.y.Ue = 19;\n        _.y.hp = function() {\n            return {\n                G: function() {\n                    var a = C4;\n                    return {\n                        Fe: \"hp\",\n                        Xe: \"hp\",\n                        Pg: \"google.com\",\n                        wi: \"\",\n                        Od: \"en\",\n                        vh: \"\",\n                        Li: \"\",\n                        zf: \"\",\n                        authuser: 0,\n                        Ki: \"\",\n                        fg: \"\",\n                        $f: !1,\n                        mj: \"\",\n                        we: \"\",\n                        Hb: 0,\n                        Pj: null,\n                        gg: !1,\n                        Mj: !1,\n                        Ii: !1,\n                        nb: _.y.Ob([a.Qo,a.Oi,a.Ke,]),\n                        Bs: !1,\n                        Dm: !0,\n                        Zg: 10,\n                        mg: !0,\n                        ng: !0,\n                        Qk: !1,\n                        Ri: !1,\n                        vo: !1,\n                        Jg: !1,\n                        sL: !1,\n                        Fv: !1,\n                        IJ: !0,\n                        MM: \"en\",\n                        Hg: !0,\n                        Am: !1,\n                        xk: 500,\n                        Tg: !1,\n                        Vi: !0,\n                        Ev: !0,\n                        mi: !1,\n                        Kg: \"\",\n                        Mr: \"//www.google.com/textinputassistant\",\n                        Nr: \"\",\n                        Pr: 7,\n                        Cs: !1,\n                        ln: !1,\n                        Gg: !1,\n                        Hr: !0,\n                        Ir: !1,\n                        Uf: !1,\n                        Yi: !1,\n                        Xi: !1,\n                        ye: 1,\n                        Bn: !0,\n                        Rf: !1,\n                        Nd: !1,\n                        Qi: !1,\n                        zo: 10,\n                        qg: !1,\n                        pk: 0,\n                        du: !1,\n                        Vk: !0,\n                        Em: !1,\n                        Yg: window.JSBNG__document.body,\n                        mn: !0,\n                        On: null,\n                        Ra: {\n                        },\n                        Rk: {\n                        },\n                        Wi: 0,\n                        bo: !1,\n                        nn: !0,\n                        Rb: !1,\n                        Qx: null,\n                        Il: !1,\n                        Ix: null,\n                        Rx: null,\n                        Cm: !1,\n                        Es: !0,\n                        Vn: !1,\n                        zj: 1,\n                        sx: 1,\n                        spellcheck: !1,\n                        yo: !1,\n                        Sl: \"Search\",\n                        Ne: \"I'm  Feeling Lucky\",\n                        Tr: \"\",\n                        xl: \"Learn more\",\n                        yl: \"Remove\",\n                        Wk: \"This search was removed from your Web History\",\n                        hk: \"\",\n                        ux: \"Did you mean:\",\n                        Or: \"\",\n                        Sr: \"\",\n                        NM: \"Search by voice\",\n                        $n: !1,\n                        Uk: null,\n                        Ug: 0,\n                        $q: 0,\n                        Xc: \"\",\n                        Bf: \"\",\n                        isRtl: !1,\n                        lf: \"absolute\",\n                        Ol: !1,\n                        hn: !1,\n                        uf: null,\n                        Pl: !0,\n                        Sx: 0,\n                        We: [0,0,0,],\n                        Bm: null,\n                        Pn: null,\n                        xm: [0,],\n                        Ok: 0,\n                        Lj: 1,\n                        vf: \"\",\n                        jr: \"\",\n                        ir: \"\",\n                        xs: null,\n                        Tu: \"\",\n                        Su: \"\",\n                        Rt: 1,\n                        Fh: {\n                        },\n                        Fl: !0\n                    };\n                }\n            };\n        };\n        _.y.Mo = /<\\/?(?:b|em)>/gi;\n        _.y.Bj = !0;\n        _.y.Eh = !0;\n        _.y.$e = \"gstl_\";\n        var F4 = {\n            rr: 1,\n            Iy: 2,\n            Xl: 3,\n            Sh: 4,\n            Th: 5,\n            Kk: 6,\n            Jk: 7,\n            mk: 8,\n            Hy: 9,\n            Ky: 10,\n            qv: 11,\n            vv: 12,\n            uv: 13,\n            wv: 14,\n            rv: 15,\n            Jy: 16\n        }, G4 = {\n            Gk: 8,\n            Ee: 9,\n            Bi: 13,\n            Se: 27,\n            Lt: 32,\n            Ek: 37,\n            Ai: 38,\n            Fk: 39,\n            zi: 40,\n            lk: 46\n        }, vTa = {\n            Do: 0,\n            Lo: 1,\n            Ko: 2\n        }, wTa = {\n            dC: \"/complete/search\",\n            Ku: \"/complete/deleteitems\"\n        }, xTa = {\n            Hk: \"a\",\n            Mt: \"b\"\n        }, yTa = {\n            Bu: \"a\",\n            ak: \"b\",\n            It: \"c\",\n            Jt: \"d\",\n            Kt: \"e\",\n            ly: \"f\",\n            wy: \"g\",\n            VF: \"h\",\n            UF: \"i\",\n            oy: \"j\",\n            aG: \"k\",\n            SF: \"l\",\n            dz: \"m\",\n            uD: \"n\",\n            wD: \"o\"\n        }, zTa = {\n            Bu: \"a\",\n            ak: \"b\",\n            It: \"c\",\n            Jt: \"d\",\n            Kt: \"e\",\n            ly: \"f\",\n            wy: \"g\",\n            oy: \"h\",\n            $r: \"i\",\n            dz: \"j\",\n            uD: \"k\",\n            wD: \"l\"\n        };\n        _.y.gq = function() {\n            var a = _.y.Y, b = 0, c = {\n            }, d = {\n            }, e = {\n            }, f = {\n            }, g = {\n            };\n            return {\n                Tm: function() {\n                    return b++;\n                },\n                eh: function(a, b, c) {\n                    d[a] = c;\n                    g[a] = [b,];\n                },\n                register: function(b, c, d) {\n                    var n = f[b];\n                    ((n ? ((((n != a)) && (f[b] = a))) : f[b] = d));\n                    (((n = g[b]) ? n.push(c) : g[b] = [c,]));\n                    e[c] = d;\n                },\n                Km: function() {\n                    return g;\n                },\n                G: function(b, g) {\n                    var l = c[b];\n                    return ((l ? l : (((l = d[b]) ? c[b] = l() : ((g ? (((l = e[g]) ? l() : null)) : (((((l = f[b]) && ((l != a)))) ? l() : null))))))));\n                }\n            };\n        };\n        _.y.O = _.y.gq();\n        _.y.ep = function(a, b, c, d, e, f) {\n            function g() {\n                if (F) {\n                    for (var a = 0, b; b = E[a++]; ) {\n                        ((b.xa && b.xa()));\n                    ;\n                    };\n                ;\n                    F = !1;\n                }\n            ;\n            ;\n            };\n        ;\n            function h(a) {\n                {\n                    var fin45keys = ((window.top.JSBNG_Replay.forInKeys)((a))), fin45i = (0);\n                    var b;\n                    for (; (fin45i < fin45keys.length); (fin45i++)) {\n                        ((b) = (fin45keys[fin45i]));\n                        {\n                            var c = b, d = a[c];\n                            if (((d != p.Fd))) {\n                                if (t[c]) {\n                                    for (var e = ((G[c] || [])), f = 0, g = void 0; ((f < d.length)); ++f) {\n                                        (((g = k(c, d[f])) && e.push(g)));\n                                    ;\n                                    };\n                                ;\n                                    G[c] = e;\n                                }\n                                 else (((d = k(c, d)) && (w[c] = d)));\n                            ;\n                            }\n                        ;\n                        ;\n                        };\n                    };\n                };\n            ;\n            };\n        ;\n            function k(a, b) {\n                var c;\n                if (((b && ((b instanceof Object))))) {\n                    c = b;\n                }\n                 else {\n                    if (c = R.G(a, b), !c) {\n                        return null;\n                    }\n                ;\n                }\n            ;\n            ;\n                if (c.Gd) {\n                    var d = c.Gd();\n                    if (d) {\n                        for (var e = 0, f, g, m; f = d[e++]; ) {\n                            m = !1;\n                            g = f.I();\n                            if (t[g]) {\n                                if (m = J[g]) {\n                                    m.push(f);\n                                    continue;\n                                }\n                            ;\n                            ;\n                                m = !0;\n                            }\n                        ;\n                        ;\n                            J[g] = ((m ? [f,] : f));\n                        };\n                    }\n                ;\n                ;\n                }\n            ;\n            ;\n                u.push([c,a,]);\n                E.push(c);\n                return c;\n            };\n        ;\n            function l(a) {\n                for (var b = _.y.F.um, c = 0, d; d = u[c++]; ) {\n                    ((((d[0] == a)) && (b = d[1])));\n                ;\n                };\n            ;\n                return b;\n            };\n        ;\n            function n(a, b) {\n                var c = _.y.indexOf(a.I(), r), d = _.y.indexOf(b.I(), r);\n                return ((((0 > c)) ? 1 : ((((0 > d)) ? -1 : ((c - d))))));\n            };\n        ;\n            var p = uTa, m = _.y.F, t = _.y.Ob([m.Wd,m.De,m.Ab,m.Te,m.jf,m.fh,m.RENDERER,m.kb,m.qc,m.Ff,m.Vh,m.Vc,]), s = [m.Ib,m.wa,m.Z,m.ob,m.Ja,m.Ga,m.Ua,m.Jb,m.$a,m.Cb,m.Xa,m.nc,m.Zf,m.Ca,m.yb,m.ec,m.Pa,m.ra,m.Bh,m.gc,], r = [m.Qb,m.Pa,m.Ab,m.od,m.Ca,m.Xa,m.Ga,m.Z,m.Ua,m.ra,m.Vc,m.Sd,m.ob,m.Jb,m.RENDERER,m.Te,m.gc,m.$a,m.Ja,m.yb,m.Ff,m.De,m.Af,m.gb,m.Cb,m.Bb,m.kg,m.Xb,m.lg,m.Ze,m.Sc,m.Cc,m.Ea,m.Rd,m.vb,m.Ta,], w = {\n            }, G = {\n            }, J = {\n            }, u = [], E = [], F = !1, R = _.y.O, Z = {\n                P: function(a) {\n                    g();\n                    for (var b = 0, c; c = E[b++]; ) {\n                        ((c.P && c.P(a)));\n                    ;\n                    };\n                ;\n                    F = !0;\n                },\n                xa: g,\n                isActive: function() {\n                    return F;\n                },\n                get: function(a, b) {\n                    var c = w[a];\n                    if (c) {\n                        return ((c.K ? c.K(l(b)) : {\n                        }));\n                    }\n                ;\n                ;\n                },\n                Ia: function(a, b) {\n                    var c = G[a];\n                    if (c) {\n                        for (var d = [], e = l(b), f = 0, g; g = c[f++]; ) {\n                            d.push(((g.K ? g.K(e) : {\n                            })));\n                        ;\n                        };\n                    ;\n                        return d;\n                    }\n                ;\n                ;\n                    return [];\n                },\n                Zb: function() {\n                    return a;\n                },\n                wc: function() {\n                    return e;\n                },\n                eo: function(a, b) {\n                    var c = G[m.Wd];\n                    if (c) {\n                        for (var d = 0, e; e = c[d++]; ) {\n                            if (((e.N() == a))) {\n                                return ((e.K ? e.K(l(b)) : {\n                                }));\n                            }\n                        ;\n                        ;\n                        };\n                    }\n                ;\n                ;\n                    return null;\n                }\n            };\n            (function() {\n                if (f.Fl) {\n                    var e = R.Km(), g, m, r, l;\n                    {\n                        var fin46keys = ((window.top.JSBNG_Replay.forInKeys)((e))), fin46i = (0);\n                        (0);\n                        for (; (fin46i < fin46keys.length); (fin46i++)) {\n                            ((l) = (fin46keys[fin46i]));\n                            {\n                                var G = l;\n                                g = e[G];\n                                m = t[G];\n                                if (r = b[G]) {\n                                    if (((((((r != p.Fd)) && m)) && r.length))) {\n                                        m = b;\n                                        r = r.slice(0);\n                                        for (var u = [], ga = {\n                                        }, ja = 0, V = void 0, ia = void 0; ia = r[ja++]; ) {\n                                            ((((ia instanceof Object)) && (V = ia.N(), ((ga[V] || (u.push(ia), ga[V] = 1))), r.splice(--ja, 1))));\n                                        ;\n                                        };\n                                    ;\n                                        ja = _.y.Ob(r);\n                                        ((ja[p.Xh] && (ja = _.y.Ob(r.concat(g)), delete ja[p.Xh])));\n                                        {\n                                            var fin47keys = ((window.top.JSBNG_Replay.forInKeys)((ja))), fin47i = (0);\n                                            (0);\n                                            for (; (fin47i < fin47keys.length); (fin47i++)) {\n                                                ((V) = (fin47keys[fin47i]));\n                                                {\n                                                    ((ga[V] || u.push((0, window.parseInt)(V, 10))));\n                                                ;\n                                                };\n                                            };\n                                        };\n                                    ;\n                                        m[G] = u;\n                                    }\n                                ;\n                                ;\n                                }\n                                 else b[G] = ((m ? g : g[0]));\n                            ;\n                            ;\n                            };\n                        };\n                    };\n                ;\n                }\n            ;\n            ;\n                h(b);\n                for (e = 0; l = s[e++]; ) {\n                    ((b[l] || (((m = k(l, void 0)) && (w[l] = m)))));\n                ;\n                };\n            ;\n                h(J);\n                E.sort(n);\n                for (e = 0; l = E[e++]; ) {\n                    ((l.qa && l.qa(c, d)));\n                ;\n                };\n            ;\n                a.Rc(d, c.ue());\n                d.vm();\n                for (e = 0; l = E[e++]; ) {\n                    ((l.R && l.R(Z)));\n                ;\n                };\n            ;\n                for (e = 0; l = E[e++]; ) {\n                    ((l.ga && l.ga(f)));\n                ;\n                };\n            ;\n                for (e = 0; l = E[e++]; ) {\n                    ((l.P && l.P(f)));\n                ;\n                };\n            ;\n                F = !0;\n            })();\n            return Z;\n        };\n        _.y.Uh = function(a, b, c) {\n            function d() {\n                return a;\n            };\n        ;\n            function e() {\n                return s;\n            };\n        ;\n            function f() {\n                return r;\n            };\n        ;\n            function g() {\n                return b;\n            };\n        ;\n            function h() {\n                return ((c || \"\"));\n            };\n        ;\n            function k(a, b) {\n                m(a, b);\n            };\n        ;\n            function l(a, b) {\n                m(a, b, !0);\n            };\n        ;\n            function n() {\n                ((E || (F = R = !0)));\n            };\n        ;\n            function p() {\n                T = !0;\n            };\n        ;\n            function m(a, b, c) {\n                ((E || (F = !0, w[a] = b, ((c && (G[a] = b))))));\n            };\n        ;\n            var t = _.y.Kq(), s, r, w = {\n            }, G = {\n            }, J, u, E = !1, F = !1, R = !1, Z = !1, T = !1, ca = {\n                getId: function() {\n                    return t;\n                },\n                hi: function() {\n                    var a = (0, window.parseInt)(t, 36);\n                    return (((0, window.isNaN)(a) ? -1 : a));\n                },\n                ha: d,\n                Gi: e,\n                Sa: f,\n                Kb: g,\n                U: function() {\n                    return w;\n                },\n                Gh: function() {\n                    return J;\n                },\n                ij: h,\n                Sg: function() {\n                    return u;\n                },\n                $h: function() {\n                    return {\n                        ha: d,\n                        Gi: e,\n                        Sa: f,\n                        Kb: g,\n                        ij: h,\n                        setParameter: k,\n                        Ye: l,\n                        A: n,\n                        yr: p\n                    };\n                },\n                setParameter: k,\n                Ye: l,\n                A: n,\n                yr: p,\n                xn: function() {\n                    return R;\n                },\n                rn: function() {\n                    F = Z = !0;\n                },\n                zn: function(d, e, f) {\n                    return ((((((!F && ((a == d)))) && b.equals(e))) && ((c == f))));\n                },\n                oi: function() {\n                    return Z;\n                },\n                vl: function() {\n                    return T;\n                },\n                Gm: function() {\n                    ((E || (u = _.y.getTime(), ((((\"cp\" in G)) || l(\"cp\", b.getPosition()))), m(\"gs_id\", t), J = ((((_.y.Ge(G) + \":\")) + a)), F = E = !0)));\n                }\n            };\n            s = a.toLowerCase();\n            r = _.y.Nc(s);\n            return ca;\n        };\n        _.y.Hd = function(a, b, c, d, e, f, g) {\n            function h() {\n                return ((!!c && !!c[0]));\n            };\n        ;\n            var k, l = !0, n, p = {\n                wb: function() {\n                    return a;\n                },\n                ha: function() {\n                    return b;\n                },\n                rd: function() {\n                    return ((h() ? c[0] : null));\n                },\n                Ba: function() {\n                    return c;\n                },\n                Fb: h,\n                U: function() {\n                    return d;\n                },\n                nh: function() {\n                    return e;\n                },\n                Ud: function() {\n                    return f;\n                },\n                Ji: function() {\n                    return g;\n                },\n                I: function() {\n                    return l;\n                },\n                gi: function() {\n                    ((n || (n = _.y.Ip(p))));\n                    return n;\n                },\n                xd: function() {\n                    return k;\n                }\n            };\n            ((c ? ((((c.length && ((33 == c[0].I())))) && (f = l = !1))) : c = []));\n            ((d ? k = d.Kl(\"t\") : d = _.y.Yf));\n            return p;\n        };\n        _.y.Bd = function(a, b, c, d, e, f) {\n            function g(a) {\n                if (e) {\n                    for (var b = 0, c; c = a[b++]; ) {\n                        if (((-1 != _.y.indexOf(c, e)))) {\n                            return !0;\n                        }\n                    ;\n                    ;\n                    };\n                }\n            ;\n            ;\n                return !1;\n            };\n        ;\n            var h = {\n                Ei: \"za\",\n                Fi: \"zb\",\n                zA: \"zc\"\n            }, k = !1, l = {\n                Nb: function() {\n                    return a;\n                },\n                X: function() {\n                    return b;\n                },\n                Ya: function() {\n                    return c;\n                },\n                I: function() {\n                    return d;\n                },\n                ke: function() {\n                    return f.ka(h.Ei);\n                },\n                Fg: function() {\n                    return f.ka(h.Fi);\n                },\n                Gc: function() {\n                    return ((e || []));\n                },\n                ni: function(a) {\n                    return ((!!e && g([a,])));\n                },\n                Ch: g,\n                U: function() {\n                    return f;\n                },\n                Dd: function() {\n                    return k;\n                }\n            };\n            (function() {\n                var a = C4;\n                switch (d) {\n                  case a.Ke:\n                \n                  case a.Wo:\n                \n                  case a.Ik:\n                \n                  case a.bm:\n                \n                  case a.Fo:\n                \n                  case a.Go:\n                \n                  case a.Ah:\n                \n                  case a.Di:\n                \n                  case a.Uj:\n                \n                  case a.Xo:\n                \n                  case a.Cl:\n                \n                  case a.il:\n                \n                  case a.Lk:\n                \n                  case a.qp:\n                \n                  case a.qq:\n                \n                  case a.Pp:\n                    k = !0;\n                };\n            ;\n                ((f || (f = _.y.Yf)));\n            })();\n            return l;\n        };\n        _.y.Aq = function() {\n            function a(a) {\n                return ((a ? ((((-1 < a.indexOf(\" \"))) || f.test(a))) : !1));\n            };\n        ;\n            var b = /\\s/g, c = /\\u3000/g, d = /^\\s/, e = /\\s+$/, f = /\\s+/, g = /\\s+/g, h = /^\\s+|\\s+$/g, k = /^\\s+$/, l = /<[^>]*>/g, n = /&nbsp;/g, p = /&#x3000;/g, m = [/&/g,/&amp;/g,/</g,/&lt;/g,/>/g,/&gt;/g,/\"/g,/&quot;/g,/'/g,/&#39;/g,/{/g,/&#123;/g,], t = window.JSBNG__document.getElementsByTagName(\"head\")[0], s = 0;\n            _.y.Me = function(a, b) {\n                function c() {\n                    return b;\n                };\n            ;\n                ((((void 0 === b)) && (b = a)));\n                return {\n                    getPosition: c,\n                    ji: function() {\n                        return a;\n                    },\n                    Xm: c,\n                    A: function() {\n                        return ((a < b));\n                    },\n                    equals: function(c) {\n                        return ((((c && ((a == c.ji())))) && ((b == c.Xm()))));\n                    }\n                };\n            };\n            _.y.xb = function(a, b, c, d) {\n                if (((((null == b)) || ((\"\" === b))))) {\n                    if (!d) {\n                        return;\n                    }\n                ;\n                ;\n                    b = \"\";\n                }\n            ;\n            ;\n                c.push(((((a + \"=\")) + (0, window.encodeURIComponent)(String(b)))));\n            };\n            _.y.Ge = function(a) {\n                var b = [], c;\n                {\n                    var fin48keys = ((window.top.JSBNG_Replay.forInKeys)((a))), fin48i = (0);\n                    (0);\n                    for (; (fin48i < fin48keys.length); (fin48i++)) {\n                        ((c) = (fin48keys[fin48i]));\n                        {\n                            _.y.xb(c, a[c], b);\n                        ;\n                        };\n                    };\n                };\n            ;\n                return b.join(\"&\");\n            };\n            _.y.Vt = function(a) {\n                var b = {\n                }, c = Math.max(a.indexOf(\"?\"), a.indexOf(\"#\"));\n                a = a.substr(((c + 1)));\n                if (((((0 <= c)) && a))) {\n                    c = a.split(\"&\");\n                    a = 0;\n                    for (var d; ((a < c.length)); ++a) {\n                        if (d = c[a]) {\n                            d = d.split(\"=\"), b[d[0]] = ((d[1] || \"\"));\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                }\n            ;\n            ;\n                return b;\n            };\n            _.y.kd = function(a) {\n                return ((!!a && !k.test(a)));\n            };\n            _.y.Jr = function(a) {\n                return e.test(a);\n            };\n            _.y.escape = function(a) {\n                for (var b = m.length, c = 0; ((c < b)); c += 2) {\n                    a = a.replace(m[c], m[((c + 1))].source);\n                ;\n                };\n            ;\n                return a;\n            };\n            _.y.unescape = function(a) {\n                for (var b = m.length, c = 0; ((c < b)); c += 2) {\n                    a = a.replace(m[((c + 1))], m[c].source);\n                ;\n                };\n            ;\n                a = a.replace(n, \" \");\n                return a.replace(p, \"\\u3000\");\n            };\n            _.y.sj = function(a) {\n                return a.replace(_.y.Mo, \"\");\n            };\n            _.y.rj = function(a) {\n                return a.replace(l, \"\");\n            };\n            _.y.Nq = function(d) {\n                return ((a(d) ? (d = d.replace(c, \"&#x3000;\"), d.replace(b, \"&nbsp;\")) : d));\n            };\n            _.y.jz = a;\n            _.y.Nc = function(b, c) {\n                return ((a(b) ? (b = b.replace(g, \" \"), b.replace(((c ? h : d)), \"\")) : b));\n            };\n            _.y.trim = function(a) {\n                return a.replace(h, \"\");\n            };\n            _.y.Gz = function(a) {\n                return a.replace(e, \"\");\n            };\n            _.y.jc = function(a, b, c) {\n                ((c && (a = a.toLowerCase(), b = b.toLowerCase())));\n                return ((((b.length <= a.length)) && ((a.substring(0, b.length) == b))));\n            };\n            _.y.kz = function(a, b, c) {\n                ((c && (a = a.toLowerCase(), b = b.toLowerCase())));\n                c = ((a.length - b.length));\n                return ((((-1 < c)) && ((a.lastIndexOf(b) == c))));\n            };\n            _.y.Gq = function(a, b) {\n                return ((((a || b)) ? ((((!!a && !!b)) && ((a.toLowerCase() == b.toLowerCase())))) : !0));\n            };\n            _.y.Lb = function(a) {\n                window.JSBNG__clearTimeout(a);\n            };\n            _.y.Y = (0, _.ka)();\n            _.y.$g = function() {\n                return t;\n            };\n            _.y.Kq = function() {\n                return (s++).toString(36);\n            };\n            _.y.wj = function(a) {\n                return _.y.xp.test(a);\n            };\n            _.y.qu = function(a, b) {\n                return _.y.Bd(a.Nb(), a.X(), b, a.I(), a.Gc(), a.U());\n            };\n            _.y.indexOf = function(a, b) {\n                if (b.indexOf) {\n                    return b.indexOf(a);\n                }\n            ;\n            ;\n                for (var c = 0, d = b.length; ((c < d)); ++c) {\n                    if (((b[c] === a))) {\n                        return c;\n                    }\n                ;\n                ;\n                };\n            ;\n                return -1;\n            };\n            _.y.gj = function(a, b) {\n                return ((a.Fa() - b.Fa()));\n            };\n            _.y.Hq = function(a, b) {\n                return ((b.Fa() - a.Fa()));\n            };\n            _.y.fj = function(a) {\n                var b = {\n                }, c;\n                {\n                    var fin49keys = ((window.top.JSBNG_Replay.forInKeys)((a))), fin49i = (0);\n                    (0);\n                    for (; (fin49i < fin49keys.length); (fin49i++)) {\n                        ((c) = (fin49keys[fin49i]));\n                        {\n                            b[c] = a[c];\n                        ;\n                        };\n                    };\n                };\n            ;\n                return b;\n            };\n            _.y.sg = function(a, b, c) {\n                ((((b in a)) || (a[b] = [162,])));\n                a[b].push(c);\n            };\n        };\n        _.y.Aq();\n        _.y.jg = function(a) {\n            return {\n                contains: function(b) {\n                    return ((b in a));\n                },\n                Xt: function(b) {\n                    return !!a[b];\n                },\n                Ae: function(b) {\n                    return ((a[b] || 0));\n                },\n                ka: function(b) {\n                    return ((a[b] || \"\"));\n                },\n                Kl: function(b) {\n                    return ((a[b] || null));\n                }\n            };\n        };\n        _.y.Yf = _.y.jg({\n        });\n        _.y.Bq = function() {\n            function a(a, b) {\n                var c = window.JSBNG__document.createElement(a);\n                ((b && (c.className = b)));\n                return c;\n            };\n        ;\n            function b(b) {\n                return a(\"div\", b);\n            };\n        ;\n            function c(a, b, c) {\n                var d = a.style;\n                ((((\"INPUT\" != a.nodeName)) && (c += 1)));\n                d.left = d.right = \"\";\n                d[b] = ((c + \"px\"));\n            };\n        ;\n            function d(a) {\n                return ((((\"rtl\" == a)) ? \"right\" : \"left\"));\n            };\n        ;\n            function e(a, b) {\n                var c = a.getElementsByTagName(\"input\");\n                if (c) {\n                    for (var d = 0, e; e = c[d++]; ) {\n                        if (((((e.JSBNG__name == b)) && ((\"submit\" != e.type.toLowerCase()))))) {\n                            return e;\n                        }\n                    ;\n                    ;\n                    };\n                }\n            ;\n            ;\n                return null;\n            };\n        ;\n            function f(a) {\n                ((a && (((a.preventDefault && a.preventDefault())), a.returnValue = !1)));\n                return !1;\n            };\n        ;\n            function g(a) {\n                return ((a ? ((a.ownerDocument || a.JSBNG__document)) : window.JSBNG__document));\n            };\n        ;\n            function h(a) {\n                return ((a ? (a = g(a), ((a.defaultView || a.parentWindow))) : window));\n            };\n        ;\n            function k(a, b, c) {\n                return ((b + ((a * ((c - b))))));\n            };\n        ;\n            function l(a) {\n                return ((n ? ((a + \"\")) : [((_.y.Bg ? \"progid:DXImageTransform.Microsoft.Alpha(\" : \"alpha(\")),\"opacity=\",Math.floor(((100 * a))),\")\",].join(\"\")));\n            };\n        ;\n            var n = ((void 0 != window.JSBNG__document.documentElement.style.opacity)), p = {\n                rtl: \"right\",\n                ltr: \"left\"\n            };\n            _.y.Nj = function(a, b) {\n                try {\n                    if (a.setSelectionRange) {\n                        a.setSelectionRange(b, b);\n                    }\n                     else {\n                        if (a.createTextRange) {\n                            var c = a.createTextRange();\n                            c.collapse(!0);\n                            c.moveStart(\"character\", b);\n                            c.select();\n                        }\n                    ;\n                    }\n                ;\n                ;\n                } catch (d) {\n                \n                };\n            ;\n            };\n            _.y.Kb = function(a) {\n                try {\n                    var b, c;\n                    if (((\"selectionStart\" in a))) b = a.selectionStart, c = a.selectionEnd;\n                     else {\n                        var d = a.createTextRange(), e = g(a).selection.createRange();\n                        ((d.inRange(e) && (d.setEndPoint(\"EndToStart\", e), b = d.text.length, d.setEndPoint(\"EndToEnd\", e), c = d.text.length)));\n                    }\n                ;\n                ;\n                    if (((void 0 !== b))) {\n                        return _.y.Me(b, c);\n                    }\n                ;\n                ;\n                } catch (f) {\n                \n                };\n            ;\n                return null;\n            };\n            _.y.hj = function(a, b) {\n                for (var c = 0, d = 0; ((a && ((!b || ((a != b)))))); ) {\n                    c += a.offsetTop;\n                    d += a.offsetLeft;\n                    try {\n                        a = a.offsetParent;\n                    } catch (e) {\n                        a = null;\n                    };\n                ;\n                };\n            ;\n                return {\n                    Qd: c,\n                    Wb: d\n                };\n            };\n            _.y.$c = function(a) {\n                try {\n                    return ((g(a).activeElement == a));\n                } catch (b) {\n                \n                };\n            ;\n                return !1;\n            };\n            _.y.Kj = function(a) {\n                var b = G4;\n                return ((((a == b.Ai)) || ((a == b.zi))));\n            };\n            _.y.ea = a;\n            _.y.Jc = function() {\n                var b = a(\"table\");\n                b.cellPadding = b.cellSpacing = 0;\n                b.style.width = \"100%\";\n                return b;\n            };\n            _.y.Ka = b;\n            _.y.ii = function(a, c) {\n                var d = b(a), e = d.style;\n                e.background = \"transparent\";\n                e.color = \"#000\";\n                e.padding = 0;\n                e.position = \"absolute\";\n                ((c && (e.zIndex = c)));\n                e.whiteSpace = \"pre\";\n                return d;\n            };\n            _.y.xe = function(a, b) {\n                ((((a.innerHTML != b)) && (((b && ((_.y.Bg ? b = _.y.Nq(b) : ((_.y.Zk && (b = [\"\\u003Cpre style=\\\"font:inherit;margin:0\\\"\\u003E\",b,\"\\u003C/pre\\u003E\",].join(\"\")))))))), a.innerHTML = b)));\n            };\n            _.y.zl = function(a, b) {\n                ((((a.dir != b)) && (c(a, d(b), 0), a.dir = b)));\n            };\n            _.y.er = c;\n            _.y.Ij = d;\n            _.y.qj = function(a, b) {\n                ((((a.dir != b)) && (a.dir = b, a.style.textAlign = p[b])));\n            };\n            _.y.Le = function(b, c, d) {\n                if (e(b, c)) {\n                    return null;\n                }\n            ;\n            ;\n                var f = a(\"input\");\n                f.type = \"hidden\";\n                f.JSBNG__name = c;\n                ((d && (f.value = d)));\n                return b.appendChild(f);\n            };\n            _.y.Hh = e;\n            _.y.hr = function(a) {\n                var b = window.JSBNG__document.createEvent(\"JSBNG__KeyboardEvent\");\n                ((b.initKeyEvent && (b.initKeyEvent(\"keypress\", !0, !0, null, !1, !1, !0, !1, 27, 0), a.JSBNG__dispatchEvent(b))));\n            };\n            _.y.preventDefault = f;\n            _.y.Sb = function(a) {\n                if (a = ((a || window.JSBNG__event))) {\n                    ((a.stopPropagation && a.stopPropagation())), a.cancelBubble = a.cancel = !0;\n                }\n            ;\n            ;\n                return f(a);\n            };\n            _.y.Jj = function(a, b) {\n                b.parentNode.insertBefore(a, b.nextSibling);\n            };\n            _.y.Wg = function(a) {\n                a = a.insertCell(-1);\n                var b = _.y.ea(\"a\");\n                b.href = \"#ifl\";\n                b.className = \"gssb_j gss_ifl\";\n                a.appendChild(b);\n                return b;\n            };\n            _.y.JSBNG__getComputedStyle = function(a, b) {\n                var c = h(a);\n                return (((c = ((c.JSBNG__getComputedStyle ? c.JSBNG__getComputedStyle(a, \"\") : a.currentStyle))) ? c[b] : null));\n            };\n            _.y.jj = function(a) {\n                var b = ((a || window));\n                a = b.JSBNG__document;\n                var c = b.JSBNG__innerWidth, b = b.JSBNG__innerHeight;\n                if (!c) {\n                    var d = a.documentElement;\n                    ((d && (c = d.clientWidth, b = d.clientHeight)));\n                    ((c || (c = a.body.clientWidth, b = a.body.clientHeight)));\n                }\n            ;\n            ;\n                return {\n                    Je: c,\n                    Be: b\n                };\n            };\n            _.y.Jq = function(a) {\n                return ((a || window)).JSBNG__document.documentElement.clientWidth;\n            };\n            _.y.Eg = function(a, b, c, d, e) {\n                function f(a, b) {\n                    g.push(a, ((a ? \"px\" : \"\")), ((b ? \"\" : \" \")));\n                };\n            ;\n                var g = [];\n                f(a);\n                f(((e ? d : b)));\n                f(c);\n                f(((e ? b : d)), !0);\n                return g.join(\"\");\n            };\n            _.y.nj = function(a) {\n                a = a.style;\n                a.border = \"none\";\n                a.padding = ((((_.y.gd || _.y.ub)) ? \"0 1px\" : \"0\"));\n                a.margin = \"0\";\n                a.height = \"auto\";\n                a.width = \"100%\";\n            };\n            _.y.Um = function(a) {\n                return ((((((((n ? \"opacity\" : \"filter\")) + \":\")) + l(a))) + \";\"));\n            };\n            _.y.lv = function(a, b) {\n                a.style[((n ? \"opacity\" : \"filter\"))] = l(b);\n            };\n            _.y.Tl = function(a, b) {\n                a.innerHTML = \"\";\n                a.appendChild(window.JSBNG__document.createTextNode(b));\n            };\n            _.y.Rg = function(a) {\n                var b = {\n                };\n                if (a) {\n                    for (var c = 0, d; d = a[c++]; ) {\n                        b[d.Ub()] = d;\n                    ;\n                    };\n                }\n            ;\n            ;\n                return b;\n            };\n            _.y.Ll = g;\n            _.y.getWindow = h;\n            _.y.interpolate = k;\n            _.y.vz = function(a, b, c) {\n                return Math.round(k(a, b, c));\n            };\n            _.y.Ur = function(a) {\n                ((_.y.gd && (a.tabIndex = 0)));\n            };\n            _.y.Px = function(a, b) {\n                a.setAttribute(\"aria-label\", b);\n            };\n            _.y.Ds = function(a) {\n                a.setAttribute(\"aria-hidden\", \"true\");\n            };\n        };\n        _.y.Bq();\n        _.y.No = function() {\n            function a(a) {\n                ((_.y.rf(a) && (a = d(a))));\n                var b = \"\";\n                if (a) {\n                    for (var c = a.length, e = 0, f = 0, g = 0; c--; ) {\n                        for (f <<= 8, f |= a[g++], e += 8; ((6 <= e)); ) {\n                            var h = ((((f >> ((e - 6)))) & 63)), b = ((b + \"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_\".charAt(h))), e = ((e - 6));\n                        };\n                    ;\n                    };\n                ;\n                    ((e && (f <<= 8, e += 8, h = ((((f >> ((e - 6)))) & 63)), b += \"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_\".charAt(h))));\n                }\n            ;\n            ;\n                return b;\n            };\n        ;\n            function b(a) {\n                var b = [];\n                if (a) {\n                    for (var c = 0, d = 0, e = 0; ((e < a.length)); ++e) {\n                        var f = a.charCodeAt(e);\n                        if (((((((32 > f)) || ((127 < f)))) || !k[((f - 32))]))) {\n                            return [];\n                        }\n                    ;\n                    ;\n                        c <<= 6;\n                        c |= ((k[((f - 32))] - 1));\n                        d += 6;\n                        ((((8 <= d)) && (b.push(((((c >> ((d - 8)))) & 255))), d -= 8)));\n                    };\n                }\n            ;\n            ;\n                return b;\n            };\n        ;\n            function c(a, b) {\n                var c = {\n                };\n                c.ya = Array(4);\n                c.buffer = Array(4);\n                c.Rn = Array(4);\n                c.padding = Array(64);\n                c.padding[0] = 128;\n                for (var k = 1; ((64 > k)); ++k) {\n                    c.padding[k] = 0;\n                ;\n                };\n            ;\n                e(c);\n                var k = Array(64), r;\n                ((((64 < b.length)) ? (e(c), g(c, b), r = h(c)) : r = b));\n                for (var n = 0; ((n < r.length)); ++n) {\n                    k[n] = ((r[n] ^ 92));\n                ;\n                };\n            ;\n                for (n = r.length; ((64 > n)); ++n) {\n                    k[n] = 92;\n                ;\n                };\n            ;\n                e(c);\n                for (n = 0; ((64 > n)); ++n) {\n                    c.buffer[n] = ((k[n] ^ 106));\n                ;\n                };\n            ;\n                f(c, c.buffer);\n                c.total = 64;\n                g(c, d(a));\n                r = h(c);\n                e(c);\n                f(c, k);\n                c.total = 64;\n                g(c, r);\n                return h(c);\n            };\n        ;\n            function d(a) {\n                for (var b = [], c = 0, d = 0; ((d < a.length)); ++d) {\n                    var e = a.charCodeAt(d);\n                    ((((128 > e)) ? b[c++] = e : (((((2048 > e)) ? b[c++] = ((((e >> 6)) | 192)) : (b[c++] = ((((e >> 12)) | 224)), b[c++] = ((((((e >> 6)) & 63)) | 128))))), b[c++] = ((((e & 63)) | 128)))));\n                };\n            ;\n                return b;\n            };\n        ;\n            function e(a) {\n                a.ya[0] = 1732584193;\n                a.ya[1] = 4023233417;\n                a.ya[2] = 2562383102;\n                a.ya[3] = 271733878;\n                a.Yd = a.total = 0;\n            };\n        ;\n            function f(a, b) {\n                for (var c = a.Rn, d = 0; ((64 > d)); d += 4) {\n                    c[((d / 4))] = ((((((b[d] | ((b[((d + 1))] << 8)))) | ((b[((d + 2))] << 16)))) | ((b[((d + 3))] << 24))));\n                ;\n                };\n            ;\n                for (var d = a.ya[0], e = a.ya[1], f = a.ya[2], g = a.ya[3], h, k, E, F = 0; ((64 > F)); ++F) {\n                    ((((16 > F)) ? (h = ((g ^ ((e & ((f ^ g)))))), k = F) : ((((32 > F)) ? (h = ((f ^ ((g & ((e ^ f)))))), k = ((((((5 * F)) + 1)) & 15))) : ((((48 > F)) ? (h = ((((e ^ f)) ^ g)), k = ((((((3 * F)) + 5)) & 15))) : (h = ((f ^ ((e | ~g)))), k = ((((7 * F)) & 15))))))))), E = g, g = f, f = e, e = ((((e + ((((((((((((((d + h)) + n[F])) + c[k])) & 4294967295)) << l[F])) | ((((((((((d + h)) + n[F])) + c[k])) & 4294967295)) >>> ((32 - l[F])))))) & 4294967295)))) & 4294967295)), d = E;\n                ;\n                };\n            ;\n                a.ya[0] = ((((a.ya[0] + d)) & 4294967295));\n                a.ya[1] = ((((a.ya[1] + e)) & 4294967295));\n                a.ya[2] = ((((a.ya[2] + f)) & 4294967295));\n                a.ya[3] = ((((a.ya[3] + g)) & 4294967295));\n            };\n        ;\n            function g(a, b, c) {\n                ((c || (c = b.length)));\n                a.total += c;\n                for (var d = 0; ((d < c)); ++d) {\n                    a.buffer[a.Yd++] = b[d], ((((64 == a.Yd)) && (f(a, a.buffer), a.Yd = 0)));\n                ;\n                };\n            ;\n            };\n        ;\n            function h(a) {\n                var b = Array(16), c = ((8 * a.total)), d = a.Yd;\n                g(a, a.padding, ((((56 > d)) ? ((56 - d)) : ((64 - ((d - 56)))))));\n                for (var e = 56; ((64 > e)); ++e) {\n                    a.buffer[e] = ((c & 255)), c >>>= 8;\n                ;\n                };\n            ;\n                f(a, a.buffer);\n                for (e = d = 0; ((4 > e)); ++e) {\n                    for (c = 0; ((32 > c)); c += 8) {\n                        b[d++] = ((((a.ya[e] >> c)) & 255));\n                    ;\n                    };\n                ;\n                };\n            ;\n                return b;\n            };\n        ;\n            var k = [0,0,0,0,0,0,0,0,0,0,0,0,0,63,0,0,53,54,55,56,57,58,59,60,61,62,0,0,0,0,0,0,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,0,0,0,0,64,0,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,0,0,0,0,0,], l = [7,12,17,22,7,12,17,22,7,12,17,22,7,12,17,22,5,9,14,20,5,9,14,20,5,9,14,20,5,9,14,20,4,11,16,23,4,11,16,23,4,11,16,23,4,11,16,23,6,10,15,21,6,10,15,21,6,10,15,21,6,10,15,21,], n = [3614090360,3905402710,606105819,3250441966,4118548399,1200080426,2821735955,4249261313,1770035416,2336552879,4294925233,2304563134,1804603682,4254626195,2792965006,1236535329,4129170786,3225465664,643717713,3921069994,3593408605,38016083,3634488961,3889429448,568446438,3275163606,4107603335,1163531501,2850285829,4243563512,1735328473,2368359562,4294588738,2272392833,1839030562,4259657740,2763975236,1272893353,4139469664,3200236656,681279174,3936430074,3572445317,76029189,3654602809,3873151461,530742520,3299628645,4096336452,1126891415,2878612391,4237533241,1700485571,2399980690,4293915773,2240044497,1873313359,4264355552,2734768916,1309151649,4149444226,3174756917,718787259,3951481745,];\n            return {\n                I: function() {\n                    return _.y.F.Dc;\n                },\n                N: function() {\n                    return _.y.C.Dc;\n                },\n                K: function() {\n                    return {\n                        rk: a,\n                        kl: b,\n                        ql: c\n                    };\n                }\n            };\n        };\n        _.y.C.Dc = 192;\n        _.y.O.eh(_.y.F.Dc, _.y.C.Dc, _.y.No);\n        _.y.Oo = function() {\n            function a(a, c) {\n                c = _.y.escape(_.y.sj(c));\n                a = _.y.escape(_.y.Nc(a, _.y.Eh));\n                if (_.y.jc(c, a)) {\n                    return [a,\"\\u003Cb\\u003E\",c.substr(a.length),\"\\u003C/b\\u003E\",].join(\"\");\n                }\n            ;\n            ;\n                for (var d = [], e = [], f = ((c.length - 1)), g = 0, h = -1, k; k = c.charAt(g); ++g) {\n                    if (((((\" \" == k)) || ((\"\\u0009\" == k))))) {\n                        ((d.length && (k = ((g + 1)), e.push({\n                            t: d.join(\"\"),\n                            s: h,\n                            e: k\n                        }), d = [], h = -1)));\n                    }\n                     else {\n                        if (d.push(k), ((-1 == h))) {\n                            h = g;\n                        }\n                         else {\n                            if (((g == f))) {\n                                k = h;\n                                var l = ((g + 1));\n                                e.push({\n                                    t: d.join(\"\"),\n                                    s: k,\n                                    e: l\n                                });\n                            }\n                        ;\n                        }\n                    ;\n                    }\n                ;\n                ;\n                };\n            ;\n                d = a.split(/\\s+/);\n                g = {\n                };\n                for (f = 0; h = d[f++]; ) {\n                    g[h] = 1;\n                ;\n                };\n            ;\n                k = -1;\n                d = [];\n                l = ((e.length - 1));\n                for (f = 0; h = e[f]; ++f) {\n                    ((g[h.t] ? (h = ((-1 == k)), ((((f == l)) ? d.push({\n                        s: ((h ? f : k)),\n                        e: f\n                    }) : ((h && (k = f)))))) : ((((-1 < k)) && (d.push({\n                        s: k,\n                        e: ((f - 1))\n                    }), k = -1)))));\n                ;\n                };\n            ;\n                if (!d.length) {\n                    return [\"\\u003Cb\\u003E\",c,\"\\u003C/b\\u003E\",].join(\"\");\n                }\n            ;\n            ;\n                f = [];\n                for (g = h = 0; k = d[g]; ++g) {\n                    (((l = e[k.s].s) && f.push(\"\\u003Cb\\u003E\", c.substring(h, ((l - 1))), \"\\u003C/b\\u003E \"))), h = e[k.e].e, f.push(c.substring(l, h));\n                ;\n                };\n            ;\n                ((((h < c.length)) && f.push(\"\\u003Cb\\u003E\", c.substring(h), \"\\u003C/b\\u003E \")));\n                return f.join(\"\");\n            };\n        ;\n            return {\n                I: function() {\n                    return _.y.F.Db;\n                },\n                N: function() {\n                    return _.y.C.Db;\n                },\n                K: function() {\n                    return {\n                        bold: a\n                    };\n                }\n            };\n        };\n        _.y.C.Db = 95;\n        _.y.O.eh(_.y.F.Db, _.y.C.Db, _.y.Oo);\n        _.y.Bp = function() {\n            function a(a) {\n                a = b(a, p, c);\n                a = b(a, m, d);\n                return b(a, s, e);\n            };\n        ;\n            function b(a, b, c) {\n                for (var d, e, f = 0; ((null != (d = b.exec(a)))); ) {\n                    ((e || (e = []))), ((((f < d.index)) && e.push(a.substring(f, d.index)))), e.push(c(d[0])), f = b.lastIndex;\n                ;\n                };\n            ;\n                if (!e) {\n                    return a;\n                }\n            ;\n            ;\n                ((((f < a.length)) && e.push(a.substring(f))));\n                return e.join(\"\");\n            };\n        ;\n            function c(a) {\n                return String.fromCharCode(((a.charCodeAt(0) - 65248)));\n            };\n        ;\n            function d(a) {\n                var b = a.charCodeAt(0);\n                return ((((1 == a.length)) ? g.charAt(((b - 65377))) : ((((65438 == a.charCodeAt(1))) ? h.charAt(((b - 65395))) : k.charAt(((b - 65418)))))));\n            };\n        ;\n            function e(a) {\n                var b = a.charCodeAt(0);\n                return ((((12443 == a.charCodeAt(1))) ? l.charAt(((b - 12454))) : n.charAt(((b - 12495)))));\n            };\n        ;\n            function f(a) {\n                return eval(((((\"\\\"\\\\u30\" + a.split(\",\").join(\"\\\\u30\"))) + \"\\\"\")));\n            };\n        ;\n            var g = f(\"02,0C,0D,01,FB,F2,A1,A3,A5,A7,A9,E3,E5,E7,C3,FC,A2,A4,A6,A8,AA,AB,AD,AF,B1,B3,B5,B7,B9,BB,BD,BF,C1,C4,C6,C8,CA,CB,CC,CD,CE,CF,D2,D5,D8,DB,DE,DF,E0,E1,E2,E4,E6,E8,E9,EA,EB,EC,ED,EF,F3,9B,9C\"), h = f(\"F4__,AC,AE,B0,B2,B4,B6,B8,BA,BC,BE,C0,C2,C5,C7,C9_____,D0,D3,D6,D9,DC\"), k = f(\"D1,D4,D7,DA,DD\"), l = f(\"F4____,AC_,AE_,B0_,B2_,B4_,B6_,B8_,BA_,BC_,BE_,C0_,C2__,C5_,C7_,C9______,D0__,D3__,D6__,D9__,DC\"), n = f(\"D1__,D4__,D7__,DA__,DD\"), p = /[\\uFF01-\\uFF5E]/g, m = RegExp(\"([\\uff73\\uff76-\\uff84\\uff8a-\\uff8e]\\uff9e)|([\\uff8a-\\uff8e]\\uff9f)|([\\uff61-\\uff9f])\", \"g\"), t = ((((((((\"([\" + f(\"A6,AB,AD,AF,B1,B3,B5,B7,B9,BB,BD,BF,C1,C4,C6,C8,CF,D2,D5,D8,DB\"))) + \"]\\u309b)|([\")) + f(\"CF,D2,D5,D8,DB\"))) + \"]\\u309c)\")), s = RegExp(t, \"g\");\n            return {\n                I: function() {\n                    return _.y.F.Ic;\n                },\n                N: function() {\n                    return _.y.C.Ic;\n                },\n                K: function() {\n                    return {\n                        Dn: a\n                    };\n                }\n            };\n        };\n        _.y.C.Ic = 12;\n        _.y.O.register(_.y.F.Ic, _.y.C.Ic, _.y.Bp);\n        _.y.kp = function(a, b, c, d, e) {\n            var f = ((_.y.dc ? \"-moz-\" : ((_.y.ub ? \"-ms-\" : ((_.y.gd ? \"-o-\" : ((_.y.Jd ? \"-webkit-\" : \"\")))))))), g = ((((\".\" + _.y.$e)) + d)), h = RegExp(((((\"(\\\\.(\" + e.join(\"|\"))) + \")\\\\b)\"))), k = [];\n            return {\n                addRule: function(a, d) {\n                    if (b) {\n                        if (c) {\n                            for (var e = a.split(\",\"), f = [], t = 0, s; s = e[t++]; ) {\n                                s = ((h.test(s) ? s.replace(h, ((g + \"$1\"))) : ((((g + \" \")) + s)))), f.push(s);\n                            ;\n                            };\n                        ;\n                            a = f.join(\",\");\n                        }\n                    ;\n                    ;\n                        k.push(a, \"{\", d, \"}\");\n                    }\n                ;\n                ;\n                },\n                vm: function() {\n                    if (((b && k.length))) {\n                        b = !1;\n                        var c = _.y.ea(\"style\");\n                        c.setAttribute(\"type\", \"text/css\");\n                        ((a || _.y.$g())).appendChild(c);\n                        var d = k.join(\"\");\n                        k = null;\n                        ((c.styleSheet ? c.styleSheet.cssText = d : c.appendChild(window.JSBNG__document.createTextNode(d))));\n                    }\n                ;\n                ;\n                },\n                prefix: function(a, b) {\n                    var c = [a,((b || \"\")),];\n                    ((f && (c = c.concat(((b ? [a,f,b,] : [f,a,]))))));\n                    return c.join(\"\");\n                }\n            };\n        };\n        _.y.Vp = function() {\n            function a(a) {\n                var b = 0;\n                ((a && (((g || c())), d(), ((((a in h)) ? b = h[a] : (_.y.xe(g, _.y.escape(a)), h[a] = b = g.offsetWidth, _.y.xe(g, \"\")))))));\n                return b;\n            };\n        ;\n            function b() {\n                ((g || c()));\n                d();\n                ((k || (_.y.xe(g, \"|\"), k = g.offsetHeight)));\n                return k;\n            };\n        ;\n            function c() {\n                g = _.y.ii(e.Xc);\n                g.style.visibility = \"hidden\";\n                f.appendChild(g);\n            };\n        ;\n            function d() {\n                var a = _.y.getTime();\n                if (((!n || ((((n + 3000)) < a))))) {\n                    n = a, a = _.y.JSBNG__getComputedStyle(g, \"fontSize\"), ((((l && ((a == l)))) || (h = {\n                    }, k = null, l = a)));\n                }\n            ;\n            ;\n            };\n        ;\n            var e, f, g, h, k, l, n;\n            return {\n                qa: function(a) {\n                    f = ((a.Qg() || window.JSBNG__document.body));\n                },\n                ga: function(a) {\n                    e = a;\n                },\n                I: function() {\n                    return _.y.F.Cb;\n                },\n                N: function() {\n                    return _.y.C.Cb;\n                },\n                K: function() {\n                    return {\n                        getWidth: a,\n                        getHeight: b\n                    };\n                }\n            };\n        };\n        _.y.C.Cb = 10;\n        _.y.O.register(_.y.F.Cb, _.y.C.Cb, _.y.Vp);\n        _.y.$o = function(a) {\n            var b;\n            (function() {\n                function c(b) {\n                    return ((a[b] || d));\n                };\n            ;\n                function d() {\n                \n                };\n            ;\n                ((a || (a = {\n                })));\n                b = {\n                    Lc: c(\"a\"),\n                    search: c(\"b\"),\n                    ne: c(\"c\"),\n                    ic: c(\"d\"),\n                    vd: c(\"e\"),\n                    fe: c(\"f\"),\n                    Nf: c(\"g\"),\n                    Of: c(\"h\"),\n                    Jf: c(\"i\"),\n                    Cd: c(\"j\"),\n                    ce: c(\"k\"),\n                    Kf: c(\"l\"),\n                    Mf: c(\"m\"),\n                    yf: c(\"n\"),\n                    Yc: c(\"o\"),\n                    Zc: c(\"p\"),\n                    Zd: c(\"q\"),\n                    Rc: c(\"r\"),\n                    ug: c(\"s\"),\n                    vg: c(\"t\"),\n                    Wc: c(\"u\"),\n                    Pf: c(\"w\"),\n                    Gf: c(\"x\"),\n                    Lf: c(\"y\"),\n                    If: c(\"z\"),\n                    Hf: c(\"aa\"),\n                    Qf: c(\"ab\"),\n                    Ce: c(\"ac\")\n                };\n            })();\n            return {\n                Lc: function() {\n                    return b.Lc();\n                },\n                search: function(a, d) {\n                    b.search(a, d);\n                },\n                ne: function(a) {\n                    b.ne(a);\n                },\n                ic: function(a) {\n                    b.ic(a);\n                },\n                vd: function(a) {\n                    return b.vd(a);\n                },\n                fe: function(a) {\n                    b.fe(a);\n                },\n                Nf: function(a) {\n                    b.Nf(a);\n                },\n                Of: function(a) {\n                    b.Of(a);\n                },\n                Jf: function(a) {\n                    b.Jf(a);\n                },\n                Cd: function(a, d) {\n                    b.Cd(a, d);\n                },\n                ce: function(a, d) {\n                    b.ce(a, d);\n                },\n                Kf: function() {\n                    b.Kf();\n                },\n                Mf: function(a) {\n                    b.Mf(a);\n                },\n                yf: function(a) {\n                    b.yf(a);\n                },\n                Yc: function() {\n                    b.Yc();\n                },\n                Zc: function() {\n                    b.Zc();\n                },\n                Zd: function(a) {\n                    b.Zd(a);\n                },\n                Rc: function(a, d) {\n                    b.Rc(a, d);\n                },\n                ug: function(a) {\n                    b.ug(a);\n                },\n                vg: function() {\n                    b.vg();\n                },\n                Wc: function() {\n                    b.Wc();\n                },\n                Lf: function() {\n                    b.Lf();\n                },\n                Pf: function(a) {\n                    b.Pf(a);\n                },\n                Gf: function() {\n                    b.Gf();\n                },\n                If: function() {\n                    b.If();\n                },\n                Hf: function() {\n                    b.Hf();\n                },\n                Qf: function() {\n                    b.Qf();\n                },\n                Ce: function(a, d) {\n                    return b.Ce(a, d);\n                }\n            };\n        };\n        _.y.Mp = function() {\n            function a(a, b, c, d) {\n                var f = a.getId(), g = a.ha();\n                ((r.$f || e()));\n                b = [n,p,m,\"?\",((t ? ((t + \"&\")) : \"\")),((b ? ((b + \"&\")) : \"\")),].join(\"\");\n                var k = _.y.xb;\n                a = [];\n                k(\"q\", g, a, _.y.Bj);\n                ((r.gg || k(\"callback\", ((\"google.sbox.p\" + l)), a)));\n                if (s) {\n                    for (var g = [], J = ((4 + Math.floor(((32 * Math.JSBNG__random()))))), S = 0, $; ((S < J)); ++S) {\n                        $ = ((((132443 > Math.JSBNG__random())) ? ((48 + Math.floor(((10 * Math.JSBNG__random()))))) : ((((((132494 < Math.JSBNG__random())) ? 65 : 97)) + Math.floor(((26 * Math.JSBNG__random()))))))), g.push(String.fromCharCode($));\n                    ;\n                    };\n                ;\n                    g = g.join(\"\");\n                    k(\"gs_gbg\", g, a);\n                }\n            ;\n            ;\n                k = _.y.ea(\"script\");\n                k.src = ((b + a.join(\"&\")));\n                k.charset = \"utf-8\";\n                w[f] = k;\n                G = ((r.$f ? d : c));\n                h.appendChild(k);\n                return !0;\n            };\n        ;\n            function b() {\n                return 0;\n            };\n        ;\n            function c() {\n                return 0;\n            };\n        ;\n            function d(a) {\n                var b = w[a];\n                ((b && (h.removeChild(b), delete w[a])));\n            };\n        ;\n            function e() {\n                {\n                    var fin50keys = ((window.top.JSBNG_Replay.forInKeys)((w))), fin50i = (0);\n                    var a;\n                    for (; (fin50i < fin50keys.length); (fin50i++)) {\n                        ((a) = (fin50keys[fin50i]));\n                        {\n                            h.removeChild(w[a]);\n                        ;\n                        };\n                    };\n                };\n            ;\n                w = {\n                };\n                G = null;\n            };\n        ;\n            function f(a) {\n                ((G && G(a)));\n            };\n        ;\n            function g(a) {\n                ((a || (a = _.y.Y)));\n                var b = window.google;\n                ((r.gg ? b.ac.h = a : b.sbox[((\"p\" + l))] = a));\n            };\n        ;\n            var h = _.y.$g(), k, l, n, p, m, t, s, r, w = {\n            }, G, J = {\n                R: function(a) {\n                    k = a.get(_.y.F.Pa, J);\n                    l = a.wc().getId();\n                },\n                P: function(a) {\n                    r = a;\n                    ((((0 == a.Hb)) && (a = k.Sf(), n = a.protocol, p = a.host, m = a.we, t = a.Mg, s = ((\"https:\" == window.JSBNG__document.JSBNG__location.protocol)), g(f), (new window.JSBNG__Image).src = ((((n + p)) + \"/generate_204\")))));\n                },\n                I: function() {\n                    return _.y.F.Ab;\n                },\n                N: function() {\n                    return _.y.C.Ph;\n                },\n                K: function() {\n                    return {\n                        dd: a,\n                        Dg: d,\n                        Mb: _.y.Y,\n                        Oe: b,\n                        Pe: c\n                    };\n                },\n                xa: function() {\n                    g(null);\n                    e();\n                }\n            };\n            return J;\n        };\n        _.y.C.Ph = 6;\n        _.y.O.register(_.y.F.Ab, _.y.C.Ph, _.y.Mp);\n        _.y.mp = function() {\n            function a(a) {\n                if (!h) {\n                    return !0;\n                }\n            ;\n            ;\n                for (var b = !1, c = !1, f = 0, g; ((f < a.length)); ++f) {\n                    if (g = a.charAt(f), ((!d.test(g) && (((e.test(g) ? c = !0 : b = !0)), ((c && b)))))) {\n                        return !0;\n                    }\n                ;\n                ;\n                };\n            ;\n                return !1;\n            };\n        ;\n            function b(a, b, c) {\n                if (!h) {\n                    return !0;\n                }\n            ;\n            ;\n                var e = f.test(c), k = g.test(b);\n                return ((((\"ltr\" == a)) ? ((((((e || k)) || d.test(c))) || d.test(b))) : ((!e || !k))));\n            };\n        ;\n            function c(a) {\n                var b = k;\n                ((h && ((e.test(a) ? b = \"ltr\" : ((d.test(a) || (b = \"rtl\")))))));\n                return b;\n            };\n        ;\n            var d = RegExp(\"^[\\u0000- !-@[-`{-\\u00bf\\u00d7\\u00f7\\u02b9-\\u02ff\\u2000-\\u2bff]*$\"), e = RegExp(\"^[\\u0000- !-@[-`{-\\u00bf\\u00d7\\u00f7\\u02b9-\\u02ff\\u2000-\\u2bff]*(?:\\\\d[\\u0000- !-@[-`{-\\u00bf\\u00d7\\u00f7\\u02b9-\\u02ff\\u2000-\\u2bff]*$|[A-Za-z\\u00c0-\\u00d6\\u00d8-\\u00f6\\u00f8-\\u02b8\\u0300-\\u0590\\u0800-\\u1fff\\u2c00-\\ufb1c\\ufdfe-\\ufe6f\\ufefd-\\uffff])\"), f = RegExp(\"^[\\u0000- !-@[-`{-\\u00bf\\u00d7\\u00f7\\u02b9-\\u02ff\\u2000-\\u2bff]*(?:\\\\d|[A-Za-z\\u00c0-\\u00d6\\u00d8-\\u00f6\\u00f8-\\u02b8\\u0300-\\u0590\\u0800-\\u1fff\\u2c00-\\ufb1c\\ufdfe-\\ufe6f\\ufefd-\\uffff])\"), g = RegExp(\"(?:\\\\d|[A-Za-z\\u00c0-\\u00d6\\u00d8-\\u00f6\\u00f8-\\u02b8\\u0300-\\u0590\\u0800-\\u1fff\\u2c00-\\ufb1c\\ufdfe-\\ufe6f\\ufefd-\\uffff])[\\u0000- !-@[-`{-\\u00bf\\u00d7\\u00f7\\u02b9-\\u02ff\\u2000-\\u2bff]*$\"), h = e.test(\"x\"), k;\n            return {\n                qa: function(a) {\n                    k = a.ud();\n                },\n                I: function() {\n                    return _.y.F.Ib;\n                },\n                N: function() {\n                    return _.y.C.Ib;\n                },\n                K: function() {\n                    return {\n                        Lq: a,\n                        wn: b,\n                        yd: c\n                    };\n                }\n            };\n        };\n        _.y.C.Ib = 1;\n        _.y.O.register(_.y.F.Ib, _.y.C.Ib, _.y.mp);\n        _.y.wp = function() {\n            function a(a, b, c, d, e) {\n                var f = n(a);\n                ((f || (f = {\n                }, s.push({\n                    element: a,\n                    gn: f\n                }))));\n                var g = f[b];\n                ((g || (g = f[b] = [], f = ((a.Vl ? window : _.y.getWindow(a))), f = l(b, f, g), ((_.y.rf(b) ? ((a.JSBNG__addEventListener ? a.JSBNG__addEventListener(b, f, !1) : a[((\"JSBNG__on\" + b))] = f)) : a[b] = f)))));\n                d = ((d || 0));\n                g.push({\n                    vn: !!e,\n                    Wf: !1,\n                    Pd: d,\n                    zb: c\n                });\n                g.sort(m);\n                c.Fm = b;\n            };\n        ;\n            function b(a, b) {\n                var c = n(a);\n                if (((c && (c = c[b.Fm])))) {\n                    for (var d = 0, e; e = c[d++]; ) {\n                        if (((e.zb == b))) {\n                            e.Wf = !0;\n                            break;\n                        }\n                    ;\n                    ;\n                    };\n                }\n            ;\n            ;\n            };\n        ;\n            function c(b, c, d, e) {\n                a(r, b, c, d, e);\n            };\n        ;\n            function d(a) {\n                b(r, a);\n            };\n        ;\n            function e(a, b) {\n                var c = ((b || {\n                })), d = r[a];\n                ((d && d(c, c.wd)));\n            };\n        ;\n            function f(a, b, c) {\n                ((a.JSBNG__addEventListener ? a.JSBNG__addEventListener(b, c, !1) : a.JSBNG__attachEvent(((\"JSBNG__on\" + b)), c)));\n            };\n        ;\n            function g(a, b, c) {\n                ((a.JSBNG__removeEventListener ? a.JSBNG__removeEventListener(b, c, !1) : a.JSBNG__detachEvent(((\"JSBNG__on\" + b)), c)));\n            };\n        ;\n            function h(a) {\n                ((t ? (((w || (w = [], f(window, \"message\", k)))), w.push(a), a = window.JSBNG__location.href, window.JSBNG__postMessage(\"sbox.df\", ((/HTTPS?:\\/\\//i.test(a) ? a : \"*\")))) : window.JSBNG__setTimeout(a, 0)));\n            };\n        ;\n            function k(a) {\n                ((((w && ((((a && ((((a.source == window)) && ((\"sbox.df\" == a.data)))))) && w.length)))) && (w.shift()(), ((((w && w.length)) && window.JSBNG__postMessage(\"sbox.df\", window.JSBNG__location.href))))));\n            };\n        ;\n            function l(a, b, c) {\n                return function(d, e) {\n                    if (c.length) {\n                        var f;\n                        if (!(f = d)) {\n                            f = {\n                            };\n                            var g = b.JSBNG__event;\n                            ((g && (((g.keyCode && (f.keyCode = g.keyCode))), f.un = !0)));\n                        }\n                    ;\n                    ;\n                        f.wd = ((e || a));\n                        for (var g = f, m, h, r = 0, k; k = c[r++]; ) {\n                            ((k.Wf ? h = !0 : ((m || ((k.vn ? p(k, g) : m = k.zb(g)))))));\n                        ;\n                        };\n                    ;\n                        if (h) {\n                            for (r = 0; k = c[r]; ) {\n                                ((k.Wf ? c.splice(r, 1) : ++r));\n                            ;\n                            };\n                        }\n                    ;\n                    ;\n                        if (f.Ie) {\n                            return delete f.Ie, ((f.un && (f = ((b.JSBNG__event || f))))), _.y.Sb(f), f.returnValue = !1;\n                        }\n                    ;\n                    ;\n                    }\n                ;\n                ;\n                };\n            };\n        ;\n            function n(a) {\n                for (var b = 0, c; ((b < s.length)); ++b) {\n                    if (c = s[b], ((c.element == a))) {\n                        return c.gn;\n                    }\n                ;\n                ;\n                };\n            ;\n                return null;\n            };\n        ;\n            function p(a, b) {\n                h(function() {\n                    a.zb(b);\n                });\n            };\n        ;\n            function m(a, b) {\n                return ((b.Pd - a.Pd));\n            };\n        ;\n            var t = ((window.JSBNG__postMessage && !((((_.y.ub || _.y.Hp)) || _.y.gd)))), s = [], r = {\n                Vl: 1\n            }, w;\n            return {\n                I: function() {\n                    return _.y.F.wa;\n                },\n                N: function() {\n                    return _.y.C.wa;\n                },\n                K: function() {\n                    return {\n                        Na: a,\n                        Ag: b,\n                        fc: c,\n                        A: d,\n                        Aa: e,\n                        listen: f,\n                        unlisten: g,\n                        defer: h\n                    };\n                },\n                xa: function() {\n                    w = null;\n                }\n            };\n        };\n        _.y.C.wa = 2;\n        _.y.O.register(_.y.F.wa, _.y.C.wa, _.y.wp);\n        _.y.Lp = function() {\n            function a(a) {\n                e[a] = !0;\n                f = a;\n            };\n        ;\n            function b() {\n                var a = [], b;\n                {\n                    var fin51keys = ((window.top.JSBNG_Replay.forInKeys)((e))), fin51i = (0);\n                    (0);\n                    for (; (fin51i < fin51keys.length); (fin51i++)) {\n                        ((b) = (fin51keys[fin51i]));\n                        {\n                            a.push((0, window.parseInt)(b, 10));\n                        ;\n                        };\n                    };\n                };\n            ;\n                return a;\n            };\n        ;\n            function c() {\n                return f;\n            };\n        ;\n            function d() {\n                e = {\n                };\n                f = null;\n            };\n        ;\n            var e, f;\n            return {\n                P: function() {\n                    d();\n                },\n                I: function() {\n                    return _.y.F.Ja;\n                },\n                N: function() {\n                    return _.y.C.Ja;\n                },\n                K: function() {\n                    return {\n                        add: a,\n                        Zm: b,\n                        Qm: c,\n                        reset: d\n                    };\n                }\n            };\n        };\n        _.y.C.Ja = 375;\n        _.y.O.register(_.y.F.Ja, _.y.C.Ja, _.y.Lp);\n        _.y.Sp = function() {\n            function a(a) {\n                var b = n.Va(), c;\n                c = [];\n                var g = tTa;\n                c[g.Ue] = _.y.Ue;\n                c[g.Ro] = d(r.Fe);\n                c[g.fq] = d(r.Xe);\n                c[g.lq] = ((((void 0 == a)) ? \"\" : ((a + \"\"))));\n                c[g.Ja] = p.Zm().join(\"j\");\n                a = g.Ho;\n                var u = \"\";\n                ((m.Tf() ? u = \"o\" : ((t.Pc() && (u = ((t.Hi() + \"\")))))));\n                c[a] = u;\n                a = g.Io;\n                var u = \"\", ca = t.Ba();\n                if (ca) {\n                    for (var P, S = 0, $ = 0, X; X = ca[$++]; ) {\n                        var W = X;\n                        X = ((W.I() + \"\"));\n                        W = W.Gc();\n                        ((W.length && (X += ((\"i\" + W.join(\"i\"))))));\n                        ((((X != P)) && (((((1 < S)) && (u += ((\"l\" + S))))), u += ((((P ? \"j\" : \"\")) + X)), S = 0, P = X)));\n                        ++S;\n                    };\n                ;\n                    ((((1 < S)) && (u += ((\"l\" + S)))));\n                }\n            ;\n            ;\n                c[a] = u;\n                c[g.Ap] = e(n.Lm());\n                c[g.Np] = e(n.Om());\n                c[g.nq] = w;\n                c[g.mq] = ((_.y.getTime() - G));\n                c[g.Op] = e(n.Pm());\n                c[g.yp] = l.Wm();\n                if (P = l.Hm()) {\n                    c[g.Po] = ((P.yn ? [\"1\",((r.mg ? \"a\" : \"\")),((r.ng ? \"c\" : \"\")),].join(\"\") : \"\")), c[g.Gp] = P.tn;\n                }\n            ;\n            ;\n                c[g.Cp] = l.cg();\n                c[g.Dp] = l.Mm();\n                if (P = l.ll()) {\n                    c[g.Uo] = P.In, c[g.To] = P.Gn, c[g.Vo] = P.Jn;\n                }\n            ;\n            ;\n                c[g.$p] = l.Vm();\n                c[g.Tp] = l.Rm();\n                c[g.yq] = l.Ym();\n                c[g.So] = l.Im();\n                c[g.rp] = d(r.fg);\n                g = g.bj;\n                P = (((P = m.Eb()) ? ((P.U().ka(\"e\") ? \"1\" : \"\")) : \"\"));\n                c[g] = P;\n                for (g = 0; P = s[g++]; ) {\n                    a = P.Ya(), ((h[a] && (c[a] = ((((void 0 == c[a])) ? d(P.getValue()) : \"\")))));\n                ;\n                };\n            ;\n                c = c.join(\".\").replace(f, \"\");\n                ((((k && J)) ? (g = ((b + c)), P = k.kl(J), g = k.ql(g, P), g = g.slice(0, 8), g = k.rk(g)) : g = \"\"));\n                c = [c,g,].join(\".\");\n                return {\n                    oq: b,\n                    gs_l: c\n                };\n            };\n        ;\n            function b() {\n                G = _.y.getTime();\n                ++w;\n                n.xc();\n                p.reset();\n                l.xc();\n                for (var a = 0, b; b = s[a++]; ) {\n                    b.reset();\n                ;\n                };\n            ;\n            };\n        ;\n            function c(a) {\n                J = a;\n            };\n        ;\n            function d(a) {\n                return ((a ? a.replace(g, \"-\") : \"\"));\n            };\n        ;\n            function e(a) {\n                return Math.max(((a - G)), 0);\n            };\n        ;\n            var f = /\\.+$/, g = /\\./g, h = _.y.Ob(_.y.Rp), k, l, n, p, m, t, s, r, w = -1, G, J, u = {\n                R: function(a) {\n                    var b = _.y.F;\n                    k = a.get(b.Dc, u);\n                    l = a.get(b.Ca, u);\n                    n = a.get(b.Z, u);\n                    p = a.get(b.Ja, u);\n                    m = a.get(b.Ga, u);\n                    t = a.get(b.ra, u);\n                    s = a.Ia(b.fh, u);\n                    _.y.Rg(a.Ia(b.RENDERER, u));\n                },\n                ga: function(a) {\n                    J = a.Ki;\n                },\n                P: function(a) {\n                    r = a;\n                    b();\n                },\n                I: function() {\n                    return _.y.F.$a;\n                },\n                N: function() {\n                    return _.y.C.$a;\n                },\n                K: function() {\n                    return {\n                        U: a,\n                        reset: b,\n                        Al: c\n                    };\n                }\n            };\n            return u;\n        };\n        _.y.C.$a = 9;\n        _.y.O.register(_.y.F.$a, _.y.C.$a, _.y.Sp);\n        _.y.cq = function() {\n            function a(a, b) {\n                if (t) {\n                    for (var c = !1, d = 0, e; e = t[d++]; ) {\n                        ((((2 == e.Tc(a, b))) && (c = !0)));\n                    ;\n                    };\n                ;\n                    if (c) {\n                        return;\n                    }\n                ;\n                ;\n                }\n            ;\n            ;\n                if (((((_.y.kd(a) || E.Rb)) || ((k && k.Rb()))))) {\n                    ((_.y.wj(b) ? ((((u && !J)) && (J = _.y.Le(u, \"btnI\", \"1\")))) : ((J && (u.removeChild(J), J = null))))), g(b), G.search(a, b), f(), l.Aa(14, {\n                        query: a\n                    });\n                }\n            ;\n            ;\n            };\n        ;\n            function b(a) {\n                g();\n                G.ne(a);\n                f();\n            };\n        ;\n            function c(a) {\n                g();\n                G.ic(a);\n                f();\n            };\n        ;\n            function d(a) {\n                g(1);\n                G.Zd(a);\n                f();\n            };\n        ;\n            function e(a) {\n                return G.vd(a);\n            };\n        ;\n            function f() {\n                n.Vf();\n                n.ym();\n                m.reset();\n                ((r ? r.clear() : s.clear()));\n                ((((p.Va() != p.Ha())) && p.zm()));\n                ((w && w.clear()));\n            };\n        ;\n            function g(a) {\n                ((((h && E.Cm)) && h.qi(a)));\n            };\n        ;\n            var h, k, l, n, p, m, t, s, r, w, G, J, u, E, F = {\n                qa: function(a) {\n                    u = a.Qg();\n                },\n                R: function(a) {\n                    var b = _.y.F;\n                    h = a.get(b.Mh, F);\n                    k = a.get(b.gb, F);\n                    l = a.get(b.wa, F);\n                    n = a.get(b.Ca, F);\n                    p = a.get(b.Z, F);\n                    m = a.get(b.$a, F);\n                    s = a.get(b.ra, F);\n                    r = a.get(b.Bh, F);\n                    w = a.get(b.Ea, F);\n                    G = a.Zb();\n                    t = a.Ia(b.Vh, F);\n                },\n                P: function(a) {\n                    E = a;\n                },\n                I: function() {\n                    return _.y.F.Xa;\n                },\n                N: function() {\n                    return _.y.C.Xa;\n                },\n                K: function() {\n                    return {\n                        search: a,\n                        ne: b,\n                        ic: c,\n                        Zd: d,\n                        vd: e\n                    };\n                }\n            };\n            return F;\n        };\n        _.y.C.Xa = 11;\n        _.y.O.register(_.y.F.Xa, _.y.C.Xa, _.y.cq);\n        _.y.jq = function() {\n            function a(a) {\n                return ((a[f.Xd] || {\n                })).j;\n            };\n        ;\n            function b(a) {\n                return a[f.Qh];\n            };\n        ;\n            function c(a, b) {\n                var c = a[f.Qh], e = a[f.mm], g = {\n                }, h = a[f.Xd];\n                if (h) {\n                    {\n                        var fin52keys = ((window.top.JSBNG_Replay.forInKeys)((h))), fin52i = (0);\n                        var k;\n                        for (; (fin52i < fin52keys.length); (fin52i++)) {\n                            ((k) = (fin52keys[fin52i]));\n                            {\n                                var l = h[k];\n                                ((((k in n)) && (l = n[k].parse(l))));\n                                g[k] = l;\n                            };\n                        };\n                    };\n                }\n            ;\n            ;\n                return _.y.Hd(b, c, d(c, e), _.y.jg(g), !1, !0, !1);\n            };\n        ;\n            function d(a, b) {\n                for (var c = !1, d = !1, f = !1, n = 0, p; p = b[n++]; ) {\n                    if (((((33 == ((p[g.Wh] || 0)))) ? d = !0 : c = !0)), ((d && c))) {\n                        f = !0;\n                        break;\n                    }\n                ;\n                ;\n                };\n            ;\n                c = 0;\n                d = [];\n                for (n = 0; p = b[n++]; ) {\n                    var u = ((p[g.Wh] || 0));\n                    if (((h[u] && ((!f || ((33 != u))))))) {\n                        var E;\n                        E = p[g.km];\n                        ((l && (E = k.bold(a.toLowerCase(), _.y.rj(_.y.unescape(E))))));\n                        d.push(_.y.Bd(E, _.y.rj(_.y.unescape(E)), c++, u, ((p[g.jm] || [])), e(p)));\n                    }\n                ;\n                ;\n                };\n            ;\n                return d;\n            };\n        ;\n            function e(a) {\n                return (((a = a[g.Xd]) ? _.y.jg(a) : _.y.Yf));\n            };\n        ;\n            var f = rTa, g = jTa, h, k, l, n = {\n            }, p = {\n                R: function(a) {\n                    var b = _.y.F;\n                    k = a.get(b.Db, p);\n                    if (a = a.Ia(b.Ff, p)) {\n                        for (var b = 0, c; c = a[b++]; ) {\n                            n[c.yx()] = c;\n                        ;\n                        };\n                    }\n                ;\n                ;\n                },\n                P: function(a) {\n                    h = a.nb;\n                    l = a.qg;\n                },\n                I: function() {\n                    return _.y.F.yb;\n                },\n                N: function() {\n                    return _.y.C.yb;\n                },\n                K: function() {\n                    return {\n                        En: a,\n                        dr: b,\n                        Xf: c\n                    };\n                }\n            };\n            return p;\n        };\n        _.y.C.yb = 14;\n        _.y.O.register(_.y.F.yb, _.y.C.yb, _.y.jq);\n        _.y.kq = function() {\n            function a(a) {\n                var d = b(a);\n                if (d) {\n                    ((((e && !a.Ji())) && (a = e.kt(a))));\n                    f.Mn(a);\n                    var k = a, m = k.wb().ha(), t = k.Ba();\n                    ((g.isEnabled() && ((t.length ? (k = ((!1 == k.I())), g.setSuggestions(m, t, k)) : g.clear()))));\n                    c.Aa(3, {\n                        input: m,\n                        nd: t\n                    });\n                }\n            ;\n            ;\n                h.Cd(a, d);\n                return d;\n            };\n        ;\n            function b(a) {\n                var b = d.Ha(), c = f.Eb(), b = b.toLowerCase(), e = a.ha().toLowerCase();\n                ((((b == e)) ? c = !0 : (b = _.y.Nc(b), a = (((e = a.wb()) ? e.Sa() : _.y.Nc(a.ha().toLowerCase()))), c = ((c ? c.wb().Sa() : \"\")), c = ((((0 == b.indexOf(a))) ? ((((0 == b.indexOf(c))) ? ((a.length >= c.length)) : !0)) : !1)))));\n                return c;\n            };\n        ;\n            var c, d, e, f, g, h, k = {\n                R: function(a) {\n                    var b = _.y.F;\n                    c = a.get(b.wa, k);\n                    d = a.get(b.Z, k);\n                    e = a.get(b.Zf, k);\n                    f = a.get(b.Ga, k);\n                    g = a.get(b.ra, k);\n                    h = a.Zb();\n                },\n                I: function() {\n                    return _.y.F.ec;\n                },\n                N: function() {\n                    return _.y.C.ec;\n                },\n                K: function() {\n                    return {\n                        zb: a,\n                        Vd: b\n                    };\n                }\n            };\n            return k;\n        };\n        _.y.C.ec = 15;\n        _.y.O.register(_.y.F.ec, _.y.C.ec, _.y.kq);\n        _.y.iq = function() {\n            function a(a, b) {\n                if (((na && !((oa || (($ && $.El()))))))) {\n                    a.Ye(\"ds\", ta.vh);\n                    a.Ye(\"pq\", Ka);\n                    a.Gm();\n                    var c = !0, d = a.hi();\n                    ((((d > fa)) && (fa = d)));\n                    ++L;\n                    var d = _.y.getTime(), e;\n                    {\n                        var fin53keys = ((window.top.JSBNG_Replay.forInKeys)((wa))), fin53i = (0);\n                        (0);\n                        for (; (fin53i < fin53keys.length); (fin53i++)) {\n                            ((e) = (fin53keys[fin53i]));\n                            {\n                                var f = wa[e].Sg();\n                                ((((2500 < ((d - f)))) && R(e)));\n                            };\n                        };\n                    };\n                ;\n                    ((((sa && (e = S.get(a)))) && ((((((c = ((ba || a.xn()))) && ta.nn)) && a.rn())), V.zb(e), ((e.nh() && ++va)), Y = null)));\n                    ((c && (Y = a, ((((U && !b)) || F())))));\n                }\n            ;\n            ;\n            };\n        ;\n            function b() {\n                return ((((((10 <= ya)) || ((3 <= X.Pe())))) ? !0 : !1));\n            };\n        ;\n            function c() {\n                ra = fa;\n            };\n        ;\n            function d() {\n                return ((fa <= ra));\n            };\n        ;\n            function e() {\n                Y = null;\n            };\n        ;\n            function f() {\n                return L;\n            };\n        ;\n            function g() {\n                return {\n                    yn: sa,\n                    tn: ((sa ? S.ho() : 0))\n                };\n            };\n        ;\n            function h() {\n                return ((sa ? S.cg() : 0));\n            };\n        ;\n            function k() {\n                return va;\n            };\n        ;\n            function l() {\n                return {\n                    In: Ea,\n                    Gn: Ba,\n                    Jn: Pa\n                };\n            };\n        ;\n            function n() {\n                return Ta;\n            };\n        ;\n            function p() {\n                return Ha;\n            };\n        ;\n            function m(a) {\n                a = ja.Xf(a, null);\n                return V.Vd(a);\n            };\n        ;\n            function t() {\n                return qa;\n            };\n        ;\n            function s() {\n                for (var a = [], b = 0, c, d = 0; ((d <= ca)); ++d) {\n                    c = Aa[d], ((((0 == c)) ? b++ : (b = ((((1 == b)) ? \"0j\" : ((((1 < b)) ? ((d + \"-\")) : \"\")))), a.push(((b + c))), b = 0)));\n                ;\n                };\n            ;\n                return a.join(\"j\");\n            };\n        ;\n            function r() {\n                ((sa && S.Pk()));\n            };\n        ;\n            function w(a) {\n                ((sa && S.Xn(a)));\n            };\n        ;\n            function G(a, b) {\n                return ja.Xf(a, b);\n            };\n        ;\n            function J() {\n                ((sa && S.xc()));\n                qa = Ha = Ta = Pa = Ba = Ea = va = ya = L = 0;\n                Aa = [];\n                for (var a = 0; ((a <= ca)); ++a) {\n                    Aa[a] = 0;\n                ;\n                };\n            ;\n            };\n        ;\n            function u(a) {\n                Ka = a;\n            };\n        ;\n            function E(a) {\n                return function(b) {\n                    Z(b, a);\n                };\n            };\n        ;\n            function F() {\n                _.y.Lb(U);\n                U = null;\n                if (((!((2 < X.Pe())) && Y))) {\n                    var a = [], b = Y.U();\n                    if (b) {\n                        {\n                            var fin54keys = ((window.top.JSBNG_Replay.forInKeys)((b))), fin54i = (0);\n                            var c;\n                            for (; (fin54i < fin54keys.length); (fin54i++)) {\n                                ((c) = (fin54keys[fin54i]));\n                                {\n                                    _.y.xb(c, b[c], a);\n                                ;\n                                };\n                            };\n                        };\n                    }\n                ;\n                ;\n                    da.Kf();\n                    a = a.join(\"&\");\n                    a = X.dd(Y, a, E(Y), Z);\n                    ((Y.oi() || (++Ea, ((a ? (a = Y, wa[a.getId()] = a, ++ya) : ++Ba)))));\n                    Y = null;\n                    a = 100;\n                    b = ((((ya - 2)) / 2));\n                    for (c = 1; ((c++ <= b)); ) {\n                        a *= 2;\n                    ;\n                    };\n                ;\n                    ((((a < pa)) && (a = pa)));\n                    U = window.JSBNG__setTimeout(F, a);\n                }\n            ;\n            ;\n            };\n        ;\n            function R(a) {\n                X.Dg(a);\n                delete wa[a];\n                ((ya && --ya));\n            };\n        ;\n            function Z(a, b) {\n                if (na) {\n                    if (!b) {\n                        var c = ja.En(a);\n                        b = wa[c];\n                        if (!b) {\n                            return;\n                        }\n                    ;\n                    ;\n                    }\n                ;\n                ;\n                    if (!b.oi()) {\n                        c = ja.Xf(a, b);\n                        if (ia) {\n                            var d = W.Ha(), c = ia.Lx(c, d);\n                        }\n                    ;\n                    ;\n                        ((sa && S.put(c)));\n                        ((((b.hi() <= ra)) || (++Pa, ((V.zb(c) || ++Ta)), d = b, pa = c.U().Ae(\"d\"), ((d && (R(d.getId()), d = d.Sg(), d = ((_.y.getTime() - d)), qa += d, Ha = Math.max(d, Ha), ++Aa[((((d > P)) ? ca : T[Math.floor(((d / 100)))]))]))))));\n                        ((c && (d = sTa, (((c = c.U().ka(d.Qp)) && ga.Al(c))))));\n                    }\n                ;\n                ;\n                }\n            ;\n            ;\n            };\n        ;\n            var T = [0,1,2,3,4,5,5,6,6,6,7,7,7,7,7,8,8,8,8,8,], ca = ((T[((T.length - 1))] + 1)), P = ((((100 * T.length)) - 1)), S, $, X, W, ga, ja, V, ia, ha, da, na = !1, Y, fa = -1, wa, L, ya, va, Ea, Ba, Pa, Ta, Ha, qa, Aa, pa, U, ba, oa, ra, sa, ta, Ka, Ja = {\n                R: function(a) {\n                    var b = _.y.F;\n                    S = a.get(b.nc, Ja);\n                    $ = a.get(b.gb, Ja);\n                    a.get(b.wa, Ja);\n                    W = a.get(b.Z, Ja);\n                    ga = a.get(b.$a, Ja);\n                    ja = a.get(b.yb, Ja);\n                    V = a.get(b.ec, Ja);\n                    ia = a.get(b.gm, Ja);\n                    a.get(b.Ga, Ja);\n                    ha = a.get(b.Pa, Ja);\n                    a.get(b.ra, Ja);\n                    da = a.Zb();\n                },\n                P: function(a) {\n                    X = ha.Jm();\n                    ta = a;\n                    na = !0;\n                    wa = {\n                    };\n                    pa = 0;\n                    ba = a.Ri;\n                    oa = a.Ii;\n                    ra = -1;\n                    sa = ((ta.Dm && !!S));\n                    Ka = a.Li;\n                },\n                I: function() {\n                    return _.y.F.Ca;\n                },\n                N: function() {\n                    return _.y.C.Ca;\n                },\n                K: function() {\n                    return {\n                        wh: a,\n                        Tf: b,\n                        Vf: c,\n                        Ih: d,\n                        ym: e,\n                        Wm: f,\n                        Hm: g,\n                        cg: h,\n                        Mm: k,\n                        ll: l,\n                        Vm: n,\n                        Rm: p,\n                        Vd: m,\n                        Ym: t,\n                        Im: s,\n                        Mb: r,\n                        Yn: w,\n                        Jh: G,\n                        xc: J,\n                        Lh: u\n                    };\n                },\n                xa: function() {\n                    na = !1;\n                    _.y.Lb(U);\n                    wa = Y = U = null;\n                    c();\n                }\n            };\n            return Ja;\n        };\n        _.y.C.Ca = 13;\n        _.y.O.register(_.y.F.Ca, _.y.C.Ca, _.y.iq);\n        _.y.tq = function() {\n            function a() {\n                return e.Tf();\n            };\n        ;\n            function b(a) {\n                f = a;\n            };\n        ;\n            function c() {\n                return f;\n            };\n        ;\n            function d() {\n                f = null;\n            };\n        ;\n            var e, f, g = {\n                R: function(a) {\n                    e = a.get(_.y.F.Ca, g);\n                },\n                P: function() {\n                    f = null;\n                },\n                I: function() {\n                    return _.y.F.Ga;\n                },\n                N: function() {\n                    return _.y.C.Ga;\n                },\n                K: function() {\n                    return {\n                        Tf: a,\n                        Mn: b,\n                        Eb: c,\n                        A: d\n                    };\n                }\n            };\n            return g;\n        };\n        _.y.C.Ga = 5;\n        _.y.O.register(_.y.F.Ga, _.y.C.Ga, _.y.tq);\n        _.y.uq = function() {\n            function a() {\n                return e;\n            };\n        ;\n            function b() {\n                return f;\n            };\n        ;\n            function c() {\n                ((e && e.Mb()));\n            };\n        ;\n            var d = {\n            }, e, f, g, h = {\n                R: function(a) {\n                    for (var b = _.y.F, c = a.Ia(b.Ab, h), e = 0, f; f = c[e++]; ) {\n                        d[f.Oe()] = f;\n                    ;\n                    };\n                ;\n                    g = a.get(b.Qb, h);\n                },\n                P: function(a) {\n                    var b = ((\"https:\" == window.JSBNG__document.JSBNG__location.protocol)), c = ((g && g.isEnabled())), b = ((b || c)), c = _.y.xb, h = [];\n                    c(\"client\", a.Fe, h);\n                    c(\"hl\", a.Od, h);\n                    c(\"gl\", a.wi, h);\n                    c(\"sugexp\", a.fg, h);\n                    c(\"gs_rn\", _.y.Ue, h);\n                    c(\"gs_ri\", a.Xe, h);\n                    ((a.authuser && c(\"authuser\", a.authuser, h)));\n                    f = {\n                        protocol: ((((\"http\" + ((b ? \"s\" : \"\")))) + \"://\")),\n                        host: ((a.mj || ((\"clients1.\" + a.Pg)))),\n                        we: ((a.we || \"/complete/search\")),\n                        Mg: ((h.length ? h.join(\"&\") : \"\"))\n                    };\n                    ((((e && ((e.Oe() == a.Hb)))) || (e = d[a.Hb])));\n                },\n                I: function() {\n                    return _.y.F.Pa;\n                },\n                N: function() {\n                    return _.y.C.Pa;\n                },\n                K: function(d) {\n                    return {\n                        Jm: ((((d == _.y.F.Ca)) ? a : _.y.Y)),\n                        Sf: b,\n                        zr: c\n                    };\n                }\n            };\n            return h;\n        };\n        _.y.C.Pa = 16;\n        _.y.O.register(_.y.F.Pa, _.y.C.Pa, _.y.uq);\n        _.y.np = function() {\n            function a(a) {\n                k.oe(a);\n            };\n        ;\n            function b() {\n                return l;\n            };\n        ;\n            function c(a) {\n                if (((a in n))) {\n                    if (p) {\n                        if (((a == p.kh()))) {\n                            return;\n                        }\n                    ;\n                    ;\n                        f();\n                        p.wk();\n                    }\n                ;\n                ;\n                    p = n[a];\n                    k.setPanel(p);\n                }\n            ;\n            ;\n            };\n        ;\n            function d() {\n                return ((l ? k.getHeight() : 0));\n            };\n        ;\n            function e() {\n                ((l || (k.show(g()), l = !0)));\n            };\n        ;\n            function f() {\n                ((l && (k.hide(), l = !1)));\n            };\n        ;\n            function g() {\n                var a = _.y.fj(h);\n                p.ok(a);\n                return a;\n            };\n        ;\n            var h = {\n                jn: !1,\n                lh: \"left\",\n                yk: !0,\n                Pb: null,\n                marginWidth: 0\n            }, k, l, n = {\n            }, p, m = {\n                R: function(a) {\n                    var b = _.y.F;\n                    k = a.get(b.Jb, m);\n                    if (a = a.Ia(b.jf, m)) {\n                        for (var b = 0, c; c = a[b++]; ) {\n                            n[c.kh()] = c;\n                        ;\n                        };\n                    }\n                ;\n                ;\n                },\n                P: function() {\n                    l = !1;\n                },\n                I: function() {\n                    return _.y.F.Ua;\n                },\n                N: function() {\n                    return _.y.C.Ua;\n                },\n                K: function() {\n                    return {\n                        Oa: b,\n                        setPanel: c,\n                        getHeight: d,\n                        show: e,\n                        hide: f,\n                        oe: a\n                    };\n                },\n                xa: function() {\n                    f();\n                }\n            };\n            return m;\n        };\n        _.y.C.Ua = 7;\n        _.y.O.register(_.y.F.Ua, _.y.C.Ua, _.y.np);\n        _.y.Jp = function() {\n            function a() {\n                var a = {\n                };\n                sa.Aa(13, a);\n                ((((!a.cancel && Za.Hg)) && sa.defer(ea.Kd)));\n                Ua.Lf();\n            };\n        ;\n            function b() {\n                sa.Aa(12);\n                Ua.Wc();\n            };\n        ;\n            function c() {\n                Ba(\"rtl\");\n            };\n        ;\n            function d() {\n                Ba(\"ltr\");\n            };\n        ;\n            function e() {\n                ea.Ln();\n            };\n        ;\n            function f(a) {\n                ((ea.Fb() ? ea.Rl() : ea.$d(a)));\n            };\n        ;\n            function g() {\n                var a = lTa;\n                if (((Za.ye == a.zq))) {\n                    return !1;\n                }\n            ;\n            ;\n                if (((Za.ye == a.Wp))) {\n                    return Ua.Qf(), !1;\n                }\n            ;\n            ;\n                var b = Pa();\n                if (b) {\n                    switch (Za.ye) {\n                      case a.Eo:\n                        if (Ta(b, !0)) {\n                            return Ka.add(U.Ee), !0;\n                        }\n                    ;\n                    ;\n                        break;\n                      case a.Xp:\n                        return ea.jd(b);\n                    };\n                }\n            ;\n            ;\n                return !1;\n            };\n        ;\n            function h() {\n                ((Za.Yi ? wa(5) : (((ea.Oa() ? ea.Kd() : r())), R())));\n            };\n        ;\n            function k(a) {\n                ((((xa && ((a.ji() == xa.length)))) && (((mb && mb.clear())), ((Za.Xi && wa(2))), Ua.Jf(xa))));\n            };\n        ;\n            function l(a) {\n                ((((oa && ((0 == a.getPosition())))) && oa.Bk()));\n            };\n        ;\n            function n(a, b, c, d) {\n                ((((Za.Em && !a)) && ea.xf(!0)));\n                ((((Za.Am && ((!ea.Oa() && ((\"mousedown\" == c)))))) && ea.$d(b)));\n                var e;\n                ((((Bb && Bb.zn(a, b, c))) ? e = Bb : Bb = e = _.y.Uh(a, b, c)));\n                var f = b = !1;\n                if (((((a != xa)) || ((\"onremovechip\" == c))))) {\n                    ((_.y.jc(c, \"key\") ? Ka.add(U.Wl) : ((((\"paste\" == c)) && Ka.add(U.$l))))), b = !0, Aa(a), sa.Aa(1, {\n                        wd: c,\n                        Pb: nb\n                    }), Ua.fe(a), f = _.y.getTime(), ((Qb || (Qb = f))), gc = f, ((_.y.kd(a) && (d = !0))), f = !0;\n                }\n            ;\n            ;\n                a = pa.DONT_CARE;\n                var g = e.$h(), m = Na.Eb();\n                if (Da) {\n                    for (var h = 0, r; r = Da[h++]; ) {\n                        r = r.Tc(g, m), ((((r > a)) && (a = r)));\n                    ;\n                    };\n                }\n            ;\n            ;\n                switch (a) {\n                  case pa.Ci:\n                    d = !0;\n                    break;\n                  case pa.nm:\n                    d = !1;\n                };\n            ;\n                ((d ? (((b && ea.Nn())), ((Rb && e.setParameter(\"gs_is\", 1))), Ua.Mf(Rb), ta.wh(e), Bb = null) : ((f && (ea.clear(), ta.Vf())))));\n                sa.Aa(2, {\n                    wd: c\n                });\n            };\n        ;\n            function p(a) {\n                (((Rb = a) && Ka.add(U.Ul)));\n            };\n        ;\n            function m(a) {\n                ((((cc != a)) && (((cc = a) ? Ua.If() : Ua.Hf()))));\n            };\n        ;\n            function t(a) {\n                Ha(a);\n            };\n        ;\n            function s() {\n                ba.JSBNG__focus();\n            };\n        ;\n            function r() {\n                ba.JSBNG__blur();\n            };\n        ;\n            function w() {\n                return ba.$c();\n            };\n        ;\n            function G(a, b, c) {\n                ((_.y.jc(a, xa, !0) && (a = ((xa + a.substr(xa.length))))));\n                c = ((c || _.y.Me(a.length)));\n                n(a, c, \"\", b);\n                Ha(a, !0);\n            };\n        ;\n            function J(a) {\n                G(a, !0);\n                ec = _.y.getTime();\n                Ka.add(U.cm);\n            };\n        ;\n            function u() {\n                n(xa, $(), \"onremovechip\");\n            };\n        ;\n            function E(a) {\n                Aa(a);\n                ba.refresh();\n                sa.Aa(4, {\n                    Pb: nb,\n                    input: a\n                });\n            };\n        ;\n            function F() {\n                ba.select();\n            };\n        ;\n            function R() {\n                ((((xa != eb)) && Aa(eb)));\n                sa.Aa(5, {\n                    input: eb,\n                    nd: ea.Ba(),\n                    Pb: nb\n                });\n                ba.refresh();\n                Ua.Of(eb);\n            };\n        ;\n            function Z() {\n                eb = xa;\n            };\n        ;\n            function T() {\n                return ba.hh();\n            };\n        ;\n            function ca() {\n                return eb;\n            };\n        ;\n            function P() {\n                return xa;\n            };\n        ;\n            function S() {\n                return nb;\n            };\n        ;\n            function $() {\n                return ba.Kb();\n            };\n        ;\n            function X() {\n                return ba.of();\n            };\n        ;\n            function W() {\n                return ba.getHeight();\n            };\n        ;\n            function ga() {\n                return ba.getWidth();\n            };\n        ;\n            function ja() {\n                return ba.xg();\n            };\n        ;\n            function V() {\n                return Qb;\n            };\n        ;\n            function ia() {\n                return gc;\n            };\n        ;\n            function ha() {\n                return ec;\n            };\n        ;\n            function da() {\n                return ((0 != Fc));\n            };\n        ;\n            function na() {\n                if (Ab) {\n                    if (Za.Tg) {\n                        return !0;\n                    }\n                ;\n                ;\n                    for (var a = 0, b; b = hb[a++]; ) {\n                        if (b.isEnabled()) {\n                            return !0;\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                }\n            ;\n            ;\n                return !1;\n            };\n        ;\n            function Y(a) {\n                if (((a == xa))) {\n                    return !0;\n                }\n            ;\n            ;\n                var b = xa.length;\n                return ((((a.substr(0, b) == xa)) ? ra.wn(nb, xa, a.substr(b)) : !1));\n            };\n        ;\n            function fa() {\n                ba.Lg();\n            };\n        ;\n            function wa(a) {\n                Ja.search(xa, a);\n            };\n        ;\n            function L(a) {\n                ((xa && (Aa(\"\"), ba.clear(), sa.Aa(1), ea.clear(), Ua.fe(xa))));\n                ((a && Ua.Gf()));\n            };\n        ;\n            function ya() {\n                ec = gc = Qb = 0;\n            };\n        ;\n            function va(a) {\n                ba.zg(a);\n            };\n        ;\n            function Ea() {\n                var a = Pa();\n                ((a && Ta(a)));\n            };\n        ;\n            function Ba(a) {\n                var b = $().getPosition();\n                ((((nb == a)) ? ((((ea.Fb() && ((b == xa.length)))) && ((ea.Pc() ? ((Za.Rf && (a = ea.Oc(), Ja.search(a.X(), 6)))) : ((Za.Bn && g())))))) : ((((oa && ((0 == b)))) && oa.Bk()))));\n            };\n        ;\n            function Pa() {\n                if (ea.Fb()) {\n                    var a = ((ea.Pc() ? ea.Oc() : ea.rd()));\n                    if (a.Dd()) {\n                        return a;\n                    }\n                ;\n                ;\n                }\n            ;\n            ;\n                return null;\n            };\n        ;\n            function Ta(a, b) {\n                var c = a.X();\n                return ((_.y.Gq(eb, c) ? !1 : (Z(), ((b ? G(c, !0) : E(c))), !0)));\n            };\n        ;\n            function Ha(a, b) {\n                xa = ((a || \"\"));\n                qa();\n                ba.refresh();\n                ((b || (sa.Aa(4, {\n                    Pb: nb,\n                    input: xa\n                }), Ua.Nf(xa))));\n            };\n        ;\n            function qa() {\n                var a = ra.yd(xa);\n                ((((a != nb)) && (ba.Kc(a), nb = a)));\n            };\n        ;\n            function Aa(a) {\n                xa = eb = ((a || \"\"));\n                qa();\n            };\n        ;\n            var pa = E4, U = nTa, ba, oa, ra, sa, ta, Ka, Ja, Da, Na, ea, mb, Ab, hb, Ua, eb, xa, nb, Fc, Qb, gc, ec, Rb, cc, Bb, Za, bb = {\n                R: function(a) {\n                    var b = _.y.F;\n                    ba = a.get(b.ob, bb);\n                    oa = a.get(b.gb, bb);\n                    ra = a.get(b.Ib, bb);\n                    sa = a.get(b.wa, bb);\n                    ta = a.get(b.Ca, bb);\n                    Ka = a.get(b.Ja, bb);\n                    Ja = a.get(b.Xa, bb);\n                    Da = a.Ia(b.kb, bb);\n                    Na = a.get(b.Ga, bb);\n                    ea = a.get(b.ra, bb);\n                    mb = a.get(b.Ea, bb);\n                    Ab = a.get(b.Sd, bb);\n                    hb = a.Ia(b.Vc, bb);\n                    Ua = a.Zb();\n                    Fc = a.wc().zd();\n                },\n                ga: function(a) {\n                    Za = a;\n                    Da.sort(_.y.gj);\n                    xa = eb = ((ba.Nm() || \"\"));\n                },\n                P: function(a) {\n                    Za = a;\n                    cc = Rb = !1;\n                    qa();\n                },\n                I: function() {\n                    return _.y.F.Z;\n                },\n                N: function() {\n                    return _.y.C.Z;\n                },\n                K: function() {\n                    return {\n                        Ui: a,\n                        oo: b,\n                        qo: c,\n                        to: d,\n                        fn: e,\n                        cn: f,\n                        jd: g,\n                        no: h,\n                        bn: k,\n                        jo: l,\n                        po: n,\n                        Bo: p,\n                        Zi: m,\n                        uc: t,\n                        pg: s,\n                        Td: r,\n                        dv: w,\n                        rg: G,\n                        bu: J,\n                        cu: u,\n                        yc: E,\n                        Kh: F,\n                        oj: R,\n                        zm: Z,\n                        hh: T,\n                        Va: ca,\n                        Ha: P,\n                        yd: S,\n                        Kb: $,\n                        of: X,\n                        getHeight: W,\n                        getWidth: ga,\n                        xg: ja,\n                        Lm: V,\n                        Om: ia,\n                        Pm: ha,\n                        uo: da,\n                        yg: na,\n                        br: Y,\n                        Lg: fa,\n                        search: wa,\n                        clear: L,\n                        xc: ya,\n                        zg: va,\n                        uh: Ea\n                    };\n                }\n            };\n            return bb;\n        };\n        _.y.C.Z = 3;\n        _.y.O.register(_.y.F.Z, _.y.C.Z, _.y.Jp);\n        _.y.wq = function() {\n            function a(a) {\n                a.Pb = Da;\n                a.marginWidth = Ja;\n                var b = Na.Pn;\n                ((b || (b = ((((\"rtl\" == Da)) ? \"right\" : \"left\")))));\n                a.lh = b;\n            };\n        ;\n            function b(a, b, d) {\n                a = ((Ha && Ha.Ew(b)));\n                R();\n                if ((((pa = b) && b.length))) {\n                    var e = b[0].X();\n                    ((wa.Lq(e) && (e = va.Va())));\n                    Da = wa.yd(e);\n                    e = !1;\n                    ((d ? (oa = Y.Zl, e = fa.Hn(b, Da), d = xTa, b = b[0].U().ka(d.Hk), b = _.y.unescape(b), Ja = Ea.getWidth(b)) : (oa = Y.Nh, e = fa.render(V(), Da), Ja = 0)));\n                    ((a && (ba = Ha.yw(), c(Ha.uw()))));\n                    ((e ? E() : R()));\n                }\n            ;\n            ;\n            };\n        ;\n            function c(a) {\n                na();\n                if (((U != a))) {\n                    var b = U;\n                    U = a;\n                    da(b);\n                }\n            ;\n            ;\n            };\n        ;\n            function d() {\n                if (G()) {\n                    if (ra) {\n                        var a = U;\n                        ((((U == ((pa.length - 1)))) ? ba = U = null : ((((null == U)) ? U = 0 : ++U))));\n                        ba = U;\n                        ha(a, d);\n                    }\n                     else E();\n                ;\n                }\n            ;\n            ;\n            };\n        ;\n            function e() {\n                if (G()) {\n                    if (ra) {\n                        var a = U;\n                        ((((pa && ((0 != U)))) ? ((((null == U)) ? U = ((pa.length - 1)) : --U)) : ba = U = null));\n                        ba = U;\n                        ha(a, e);\n                    }\n                     else E();\n                ;\n                }\n            ;\n            ;\n            };\n        ;\n            function f(a) {\n                var b = ((a ? 4 : 3));\n                ((J() ? (a = r(), ((fa.ve(a) || va.search(b))), b = va.Va(), Aa.ce(b, a)) : va.search(b)));\n            };\n        ;\n            function g(a) {\n                return fa.jd(a);\n            };\n        ;\n            function h(a) {\n                ba = U = a;\n                a = pa[a];\n                var b = va.Va();\n                Aa.ce(b, a);\n            };\n        ;\n            function k() {\n                return ra;\n            };\n        ;\n            function l() {\n                return sa;\n            };\n        ;\n            function n(a) {\n                ((((sa && !a)) && R()));\n                sa = a;\n            };\n        ;\n            function p() {\n                return oa;\n            };\n        ;\n            function m() {\n                return pa;\n            };\n        ;\n            function t() {\n                return ((G() ? pa[0] : null));\n            };\n        ;\n            function s() {\n                return U;\n            };\n        ;\n            function r() {\n                return ((J() ? pa[ba] : null));\n            };\n        ;\n            function w() {\n                return ba;\n            };\n        ;\n            function G() {\n                return !((!pa || !pa.length));\n            };\n        ;\n            function J() {\n                return ((null != ba));\n            };\n        ;\n            function u() {\n                ((((ra && !ta)) && (ta = window.JSBNG__setTimeout(R, Na.xk))));\n            };\n        ;\n            function E() {\n                ((ra || (L.setPanel(ja()), L.show(), ra = !0, Aa.Yc())));\n            };\n        ;\n            function F() {\n                ((ra && (((ta && (_.y.Lb(ta), ta = null))), L.hide(), ra = !1, Aa.Zc())));\n            };\n        ;\n            function R() {\n                F();\n                pa = null;\n                oa = Y.EMPTY;\n                ((((null != U)) && fa.Ac(U)));\n                ba = U = null;\n                fa.clear();\n            };\n        ;\n            function Z() {\n                ya.Vf();\n                F();\n            };\n        ;\n            function T() {\n                ((((null != U)) && fa.Ac(U)));\n                ba = U = null;\n            };\n        ;\n            function ca() {\n                na();\n                Ka = window.JSBNG__setTimeout(T, 0);\n            };\n        ;\n            function P() {\n                na();\n            };\n        ;\n            function S(a) {\n                if (G()) E();\n                 else {\n                    var b = va.Va();\n                    if (b) {\n                        a = ((a || va.Kb()));\n                        b = _.y.Uh(b, a);\n                        if (Pa) {\n                            a = b.$h();\n                            for (var c = Ta.Eb(), d = 0, e; e = Pa[d++]; ) {\n                                e.Tc(a, c);\n                            ;\n                            };\n                        ;\n                        }\n                    ;\n                    ;\n                        ya.wh(b);\n                    }\n                ;\n                ;\n                }\n            ;\n            ;\n            };\n        ;\n            function $() {\n                return fa.za();\n            };\n        ;\n            function X() {\n                return fa.qf();\n            };\n        ;\n            function W() {\n                ra = !1;\n            };\n        ;\n            function ga() {\n                fa.$b();\n            };\n        ;\n            function ja() {\n                return _.y.C.ra;\n            };\n        ;\n            function V() {\n                if (((G() && ((oa == Y.Nh))))) {\n                    for (var a = [], b = [], c = 0, d; (((d = Ba[c++]) && !d.getMessage(va.Va(), pa, b))); ) {\n                    ;\n                    };\n                ;\n                    c = vTa;\n                    (((d = ((b ? b.length : 0))) && (d -= ia(b, a, c.Do))));\n                    for (var e = 0; ((e < pa.length)); ++e) {\n                        a.push(pa[e]);\n                    ;\n                    };\n                ;\n                    ((d && (d -= ia(b, a, c.Lo))));\n                    ((Na.Gg && a.push(1)));\n                    ((d && ia(b, a, c.Ko)));\n                    ((Na.Uf && a.push(2)));\n                    ((qa && qa.ox(a)));\n                    return a;\n                }\n            ;\n            ;\n                return null;\n            };\n        ;\n            function ia(a, b, c) {\n                for (var d = 0, e = 0, f; ((e < a.length)); ++e) {\n                    (((((f = a[e]) && ((f.position == c)))) && (b.push(f), ++d)));\n                ;\n                };\n            ;\n                return d;\n            };\n        ;\n            function ha(a, b) {\n                if (((((null == U)) || fa.hb(U)))) {\n                    if (da(a), ((null == U))) va.oj();\n                     else {\n                        var c = fa.qd(pa[U]);\n                        va.uc(c);\n                        Aa.Pf(c);\n                    }\n                ;\n                }\n                 else {\n                    fa.Ac(a), b();\n                }\n            ;\n            ;\n            };\n        ;\n            function da(a) {\n                na();\n                ((((null != a)) && fa.Ac(a)));\n                ((((null != U)) && fa.bh(U)));\n            };\n        ;\n            function na() {\n                ((Ka && (_.y.Lb(Ka), Ka = null)));\n            };\n        ;\n            var Y = kTa, fa, wa, L, ya, va, Ea, Ba, Pa, Ta, Ha, qa, Aa, pa, U, ba, oa, ra, sa, ta, Ka, Ja, Da, Na, ea = {\n                R: function(a) {\n                    var b = _.y.F;\n                    fa = a.get(b.gc, ea);\n                    wa = a.get(b.Ib, ea);\n                    L = a.get(b.Ua, ea);\n                    ya = a.get(b.Ca, ea);\n                    va = a.get(b.Z, ea);\n                    Ea = a.get(b.Cb, ea);\n                    Ba = a.Ia(b.Te, ea);\n                    Pa = a.Ia(b.kb, ea);\n                    Ta = a.get(b.Ga, ea);\n                    Ha = a.get(b.jl, ea);\n                    qa = a.get(b.hm, ea);\n                    Aa = a.Zb();\n                },\n                ga: function() {\n                    Pa.sort(_.y.gj);\n                    Ba.sort(_.y.Hq);\n                },\n                P: function(a) {\n                    Na = a;\n                    ba = U = null;\n                    oa = Y.EMPTY;\n                    ra = !1;\n                    sa = !0;\n                    Da = \"\";\n                    Ja = 0;\n                },\n                I: function() {\n                    return _.y.F.ra;\n                },\n                N: function() {\n                    return _.y.C.ra;\n                },\n                K: function() {\n                    return {\n                        setSuggestions: b,\n                        Ck: c,\n                        Rl: d,\n                        Ln: e,\n                        ve: f,\n                        jd: g,\n                        $m: h,\n                        Oa: k,\n                        isEnabled: l,\n                        xf: n,\n                        Sm: p,\n                        Ba: m,\n                        rd: t,\n                        Zq: s,\n                        Oc: r,\n                        Hi: w,\n                        Fb: G,\n                        Pc: J,\n                        Nn: u,\n                        show: E,\n                        hide: F,\n                        clear: R,\n                        Kd: Z,\n                        yj: T,\n                        Qr: ca,\n                        A: P,\n                        $d: S\n                    };\n                },\n                Gd: function() {\n                    var b = {\n                        ok: a,\n                        za: $,\n                        qf: X,\n                        wk: W,\n                        $b: ga,\n                        kh: ja\n                    };\n                    return [{\n                        qa: _.y.Y,\n                        R: _.y.Y,\n                        ga: _.y.Y,\n                        P: _.y.Y,\n                        I: function() {\n                            return _.y.F.jf;\n                        },\n                        N: function() {\n                            return _.y.C.ra;\n                        },\n                        K: function() {\n                            return b;\n                        },\n                        Gd: _.y.Y,\n                        xa: _.y.Y\n                    },];\n                },\n                xa: function() {\n                    ((ta && (_.y.Lb(ta), ta = null)));\n                    pa = null;\n                    F();\n                }\n            };\n            return ea;\n        };\n        _.y.C.ra = 17;\n        _.y.O.register(_.y.F.ra, _.y.C.ra, _.y.wq);\n        _.y.pp = function() {\n            function a(a) {\n                ((((a != F)) && (F = a, a = a.za(), ((R ? ((((a != R)) && u.replaceChild(a, R))) : u.appendChild(a))), R = a)));\n            };\n        ;\n            function b() {\n                ((E || (E = ((u ? Math.max(u.offsetHeight, 0) : 0)))));\n                return E;\n            };\n        ;\n            function c(a) {\n                u.className = ((a.jn ? \"gssb_e gsdd_a\" : \"gssb_e\"));\n                var b = ((a.Pb || S));\n                ((((r != b)) && (r = b, _.y.qj(s, b))));\n                b = a.marginWidth;\n                if (((J != b))) {\n                    var c = G.style;\n                    ((b ? (((w.hasChildNodes() || w.appendChild(G))), c.width = ((b + \"px\")), ((_.y.dc && (c.paddingLeft = \"1px\")))) : (((w.hasChildNodes() && w.removeChild(G))), c.paddingLeft = \"\")));\n                    J = b;\n                }\n            ;\n            ;\n                X = a.yk;\n                W = a.lh;\n                k(Z, !0);\n                k(P, !0);\n                p.Aa(16);\n                e();\n            };\n        ;\n            function d() {\n                E = 0;\n                k(Z, !1);\n                k(P, !1);\n                p.Aa(11);\n            };\n        ;\n            function e() {\n                E = 0;\n                g();\n                if (P) {\n                    var a = m.xm[qTa.Fp], c = P.style;\n                    ((((\"relative\" != m.lf)) && (c.JSBNG__top = s.style.JSBNG__top, c.left = ((((s.offsetLeft + w.offsetWidth)) + \"px\")))));\n                    a = ((b() + a));\n                    P.style.height = ((Math.max(a, 0) + \"px\"));\n                    h(P, u.offsetWidth);\n                }\n            ;\n            ;\n                ((F && F.$b()));\n            };\n        ;\n            function f(a) {\n                if (T) ((((ca != a)) && T.replaceChild(a, ca)));\n                 else {\n                    var b = s.insertRow(-1);\n                    b.style.height = \"0\";\n                    b.insertCell(-1);\n                    T = b.insertCell(-1);\n                    ((l.Oa() || (k(u, !1), k(s, !0), e())));\n                    Z = u;\n                    T.appendChild(a);\n                }\n            ;\n            ;\n                ca = a;\n            };\n        ;\n            function g() {\n                var a = ((F && F.qf())), b = ((a ? a.offsetWidth : n.getWidth())), c = $;\n                ((c ? ((_.y.rf(c) && (c = null))) : ((((J || !X)) ? (u.style.width = \"\", s.style.width = \"\") : (u.style.width = \"100%\", c = ((b + m.We[2])), h(s, c))))));\n                if (((\"relative\" != m.lf))) {\n                    var d = n.of();\n                    ((a && (d.Wb = _.y.hj(a).Wb)));\n                    var a = c, e = m.We, c = e[1], e = e[0], e = ((((d.Qd + n.getHeight())) + e));\n                    ((((\"right\" == W)) ? (a = _.y.getWindow(s), b = {\n                        Kn: ((_.y.Jq(a) - ((((d.Wb - c)) + b)))),\n                        Qd: e\n                    }) : (d = ((d.Wb + c)), ((((((\"center\" == W)) && a)) && (d += ((((b - a)) / 2))))), b = {\n                        Wb: d,\n                        Qd: e\n                    })));\n                    d = s.style;\n                    d.JSBNG__top = ((b.Qd + \"px\"));\n                    d.left = d.right = \"\";\n                    ((((void 0 != b.Wb)) ? d.left = ((b.Wb + \"px\")) : d.right = ((b.Kn + \"px\"))));\n                }\n            ;\n            ;\n                ((_.y.Bg && (d.zoom = \"normal\", d.zoom = 1)));\n            };\n        ;\n            function h(a, b) {\n                ((_.y.lj(b) ? ((((0 < b)) && (a.style.width = ((b + \"px\"))))) : a.style.width = b));\n            };\n        ;\n            function k(a, b) {\n                ((a && (a.style.display = ((b ? \"\" : \"none\")))));\n            };\n        ;\n            var l, n, p, m, t, s, r, w, G, J, u, E, F, R, Z, T, ca, P, S, $, X = !0, W, ga = {\n                qa: function(a, b) {\n                    S = a.ud();\n                    b.addRule(\".gssb_c\", \"border:0;position:absolute;z-index:989\");\n                    b.addRule(\".gssb_e\", [\"border:1px solid #ccc;border-top-color:#d9d9d9;\",b.prefix(\"box-shadow:0 2px 4px rgba(0,0,0,0.2);\"),\"cursor:default\",].join(\"\"));\n                    b.addRule(\".gssb_f\", \"visibility:hidden;white-space:nowrap\");\n                    b.addRule(\".gssb_k\", \"border:0;display:block;position:absolute;top:0;z-index:988\");\n                    b.addRule(\".gsdd_a\", \"border:none!important\");\n                },\n                R: function(a) {\n                    var b = _.y.F;\n                    l = a.get(b.Ua, ga);\n                    n = a.get(b.Z, ga);\n                    p = a.get(b.wa, ga);\n                    t = a.wc().getId();\n                },\n                ga: function(a) {\n                    m = a;\n                    s = _.y.Jc();\n                    s.className = ((((_.y.$e + t)) + \" gssb_c\"));\n                    k(s, !1);\n                    Z = s;\n                    var b = s.insertRow(-1);\n                    w = b.insertCell(-1);\n                    w.className = \"gssb_f\";\n                    G = _.y.Ka();\n                    u = b.insertCell(-1);\n                    u.className = \"gssb_e\";\n                    u.style.width = \"100%\";\n                    ((m.hn && (P = _.y.ea(\"div\", ((((_.y.$e + t)) + \" gssb_k\"))), k(P, !1), ((m.Yg || window.JSBNG__document.body)).appendChild(P))));\n                    if ($ = m.Bm) {\n                        ((_.y.lj($) && ($ += m.We[pTa.Tn]))), h(s, $);\n                    }\n                ;\n                ;\n                    g();\n                    ((a.Yg || window.JSBNG__document.body)).appendChild(s);\n                    p.fc(8, e);\n                },\n                P: function(a) {\n                    m = a;\n                    s.style.position = a.lf;\n                },\n                I: function() {\n                    return _.y.F.Jb;\n                },\n                N: function() {\n                    return _.y.C.Jb;\n                },\n                K: function() {\n                    return {\n                        setPanel: a,\n                        getHeight: b,\n                        oe: f,\n                        show: c,\n                        hide: d,\n                        $b: e\n                    };\n                }\n            };\n            return ga;\n        };\n        _.y.C.Jb = 8;\n        _.y.O.register(_.y.F.Jb, _.y.C.Jb, _.y.pp);\n        _.y.Kp = function() {\n            function a(a, b) {\n                ((Pa && (Pa = !1, Y.Ag(L, P), Y.Ag(L, S))));\n                ((b || (b = a)));\n                L.parentNode.replaceChild(a, L);\n                b.appendChild(L);\n                ((((Ba && Ea.Vk)) && ((((_.y.ub || _.y.dc)) ? Y.defer(function() {\n                    L.JSBNG__focus();\n                    _.y.Nj(L, qa.getPosition());\n                }) : L.JSBNG__focus()))));\n                $();\n            };\n        ;\n            function b() {\n                return oa;\n            };\n        ;\n            function c(a) {\n                var b = ((((\"rtl\" == a)) == ((\"rtl\" == Da))));\n                L.dir = a;\n                if (ra) {\n                    fa.Kc(a);\n                    var c = U.parentNode;\n                    c.removeChild(ra);\n                    ((b ? _.y.Jj(ra, U) : c.insertBefore(ra, U)));\n                }\n            ;\n            ;\n                ((oa && (oa.dir = a, c = oa.parentNode, c.removeChild(oa), ((b ? c.insertBefore(oa, U) : _.y.Jj(oa, U))))));\n                ((((0 != ya)) && (a = _.y.Ij(a), _.y.er(L, a, 0))));\n            };\n        ;\n            function d() {\n                return qa;\n            };\n        ;\n            function e() {\n                return _.y.hj(ba);\n            };\n        ;\n            function f() {\n                var a = ((ba ? ba.offsetHeight : 0));\n                ((((ea > a)) && (a = ea)));\n                return a;\n            };\n        ;\n            function g() {\n                return ((mb ? mb : ((ba ? ba.offsetWidth : 0))));\n            };\n        ;\n            function h() {\n                var a = L.offsetWidth;\n                ((Ea.Jg && (a -= L.offsetHeight)));\n                return a;\n            };\n        ;\n            function k() {\n                return L.value;\n            };\n        ;\n            function l(a) {\n                ((Ea.$n ? L : ((((U || Ab)) || L)))).style.background = ((a || \"transparent\"));\n            };\n        ;\n            function n() {\n                pa = !0;\n            };\n        ;\n            function p() {\n                L.select();\n                V();\n            };\n        ;\n            function m() {\n                ((_.y.Cj && (L.value = \"\")));\n                L.value = da.Ha();\n                ((_.y.Cj && (L.value = L.value)));\n                J();\n            };\n        ;\n            function t() {\n                if (!Ba) {\n                    try {\n                        L.JSBNG__focus(), Ba = !0, J();\n                    } catch (a) {\n                    \n                    };\n                }\n            ;\n            ;\n            };\n        ;\n            function s() {\n                ((Ba && (L.JSBNG__blur(), Ba = !1)));\n            };\n        ;\n            function r() {\n                return Ba;\n            };\n        ;\n            function w() {\n                L.value = \"\";\n            };\n        ;\n            function G() {\n                var b = Na.get(\"gs_id\");\n                if (b) oa = Na.get(\"gs_ttc\"), U = Na.get(\"gs_tti\"), ((((da.yg() && fa)) && (sa = fa.za(), ra = sa.parentNode)));\n                 else {\n                    b = _.y.Jc();\n                    b.id = Na.getId(\"gs_id\");\n                    b.className = ((((((_.y.$e + va)) + \" \")) + ((Ea.vf || L.className))));\n                    var c = b.insertRow(-1), d = b.style, e = L.style;\n                    d.width = ((mb ? ((mb + \"px\")) : e.width));\n                    d.height = ((ea ? ((ea + \"px\")) : e.height));\n                    d.padding = \"0\";\n                    _.y.nj(L);\n                    L.className = Ea.Xc;\n                    ((Ja && (oa = c.insertCell(-1), oa.id = Na.getId(\"gs_ttc\"), oa.style.whiteSpace = \"nowrap\")));\n                    U = c.insertCell(-1);\n                    U.id = Na.getId(\"gs_tti\");\n                    U.className = \"gsib_a\";\n                    ((((da.yg() && fa)) && (sa = fa.za(), ra = c.insertCell(-1), ra.className = \"gsib_b\", ra.appendChild(sa))));\n                    a(b, U);\n                }\n            ;\n            ;\n                ((((_.y.zh && _.y.Jd)) && (L.style.height = \"1.25em\", L.style.marginTop = \"-0.0625em\")));\n                u(b);\n                ba = b;\n            };\n        ;\n            function J() {\n                if (Ba) {\n                    var a = L.value.length;\n                    qa = _.y.Me(a);\n                    _.y.Nj(L, a);\n                }\n            ;\n            ;\n            };\n        ;\n            function u(a) {\n                Y.Na(a, \"mouseup\", function() {\n                    L.JSBNG__focus();\n                });\n            };\n        ;\n            function E() {\n                function a(c) {\n                    Y.Na(L, c, ca, 10, b);\n                };\n            ;\n                Y.Na(L, \"keydown\", R);\n                ((((_.y.gd || Ea.Vn)) && Y.Na(L, \"keypress\", T)));\n                Y.Na(L, \"select\", V, 10);\n                var b = !1;\n                a(\"mousedown\");\n                a(\"keyup\");\n                a(\"keypress\");\n                b = !0;\n                a(\"mouseup\");\n                a(\"keydown\");\n                a(\"JSBNG__focus\");\n                a(\"JSBNG__blur\");\n                a(\"cut\");\n                a(\"paste\");\n                a(\"input\");\n                Y.Na(L, \"compositionstart\", F);\n                Y.Na(L, \"compositionend\", F);\n            };\n        ;\n            function F(a) {\n                a = a.type;\n                ((((\"compositionstart\" == a)) ? da.Zi(!0) : ((((\"compositionend\" == a)) && da.Zi(!1)))));\n            };\n        ;\n            function R(a) {\n                var b = a.keyCode;\n                Aa = b;\n                var c = ((((((_.y.Jd || _.y.dc)) && _.y.Kj(b))) && na.Fb())), d = ((b == ha.Bi)), e = ((b == ha.Se));\n                ta = !1;\n                ((((b == ha.Ee)) && (ta = da.jd())));\n                ((d && (((((b = na.Oc()) && Z(b))) ? na.ve(a.shiftKey) : Y.defer(function() {\n                    na.ve(a.shiftKey);\n                })))));\n                if (((((((c || d)) || e)) || ta))) {\n                    a.Ie = !0;\n                }\n            ;\n            ;\n            };\n        ;\n            function Z(a) {\n                return (((a = wa[a.I()].wz) && a()));\n            };\n        ;\n            function T(a) {\n                var b = a.keyCode, c = ((b == ha.Se)), d = ((((b == ha.Ee)) && ta));\n                if (((((((b == ha.Bi)) || c)) || d))) {\n                    a.Ie = !0;\n                }\n            ;\n            ;\n            };\n        ;\n            function ca(a) {\n                if (!Ka) {\n                    var b = a.wd;\n                    if (!((((((((b.indexOf(\"key\") || a.ctrlKey)) || a.altKey)) || a.shiftKey)) || a.metaKey))) {\n                        n:\n                        if (a = a.keyCode, ((\"keypress\" != b))) {\n                            var c = _.y.Kj(a), d;\n                            if (((\"keydown\" == b))) {\n                                if (d = ((229 == a)), da.Bo(d), c) {\n                                    break n;\n                                }\n                            ;\n                            ;\n                            }\n                             else if (d = ((a != Aa)), Aa = -1, ((!c || d))) {\n                                break n;\n                            }\n                            \n                        ;\n                        ;\n                            switch (a) {\n                              case ha.Se:\n                                da.no();\n                                break;\n                              case ha.Ek:\n                                da.qo();\n                                break;\n                              case ha.Fk:\n                                da.to();\n                                break;\n                              case ha.Ai:\n                                da.fn();\n                                break;\n                              case ha.zi:\n                                da.cn(qa);\n                                break;\n                              case ha.lk:\n                                da.bn(qa);\n                                break;\n                              case ha.Gk:\n                                da.jo(qa);\n                            };\n                        ;\n                        }\n                    ;\n                    }\n                ;\n                ;\n                    V();\n                    da.po(L.value, qa, b);\n                }\n            ;\n            ;\n            };\n        ;\n            function P() {\n                Ba = !0;\n                da.oo();\n            };\n        ;\n            function S() {\n                Ba = !1;\n                da.Ui();\n            };\n        ;\n            function $() {\n                ((Pa || (Pa = !0, Y.Na(L, \"JSBNG__focus\", P, 99), Y.Na(L, \"JSBNG__blur\", S, 99))));\n            };\n        ;\n            function X() {\n                ((Ha || (Ha = window.JSBNG__setInterval(ga, ((Ea.zo || 50))))));\n            };\n        ;\n            function W() {\n                ((Ha && (_.y.Lb(Ha), Ha = null)));\n            };\n        ;\n            function ga() {\n                ca({\n                    wd: \"polling\"\n                });\n            };\n        ;\n            function ja() {\n                ((_.y.dc && _.y.hr(L)));\n            };\n        ;\n            function V() {\n                if (Ba) {\n                    var a = _.y.Kb(L);\n                    ((a && (qa = a)));\n                }\n            ;\n            ;\n            };\n        ;\n            function ia() {\n                var a;\n                Y.listen(window, \"pagehide\", function() {\n                    Ka = !0;\n                    a = L.value;\n                });\n                Y.listen(window, \"pageshow\", function(b) {\n                    Ka = !1;\n                    ((b.persisted && da.yc(a)));\n                });\n            };\n        ;\n            var ha = G4, da, na, Y, fa, wa, L, ya, va, Ea, Ba, Pa = !1, Ta, Ha, qa = _.y.Me(0), Aa = -1, pa = !1, U, ba, oa, ra, sa, ta, Ka, Ja, Da, Na, ea, mb, Ab, hb = {\n                qa: function(a, b) {\n                    Na = a;\n                    L = a.je();\n                    Da = a.ud();\n                    ((a.ue() || (b.addRule(\".gsib_a\", \"width:100%;padding:4px 6px 0\"), b.addRule(\".gsib_a,.gsib_b\", \"vertical-align:top\"))));\n                },\n                R: function(a) {\n                    var b = _.y.F;\n                    da = a.get(b.Z, hb);\n                    Y = a.get(b.wa, hb);\n                    na = a.get(b.ra, hb);\n                    fa = a.get(b.Sd, hb);\n                    wa = _.y.Rg(a.Ia(b.RENDERER, hb));\n                    a = a.wc();\n                    ya = a.zd();\n                    va = a.getId();\n                },\n                ga: function(a) {\n                    Ea = a;\n                    ea = a.Ug;\n                    mb = a.$q;\n                    Ba = _.y.$c(L);\n                    V();\n                    ((_.y.ub && Y.Na(L, \"beforedeactivate\", function(a) {\n                        ((pa && (pa = !1, a.Ie = !0)));\n                    }, 10)));\n                    ((_.y.dc && ia()));\n                    ba = L;\n                    Ja = !!a.Ra[_.y.F.gb];\n                    ((((((((da.uo() || da.yg())) || Ja)) || a.bo)) && G()));\n                    ((a.Qi && (Y.Na(L, \"JSBNG__blur\", W, 10), Y.Na(L, \"JSBNG__focus\", X, 10), Ta = !0)));\n                    Y.fc(8, ja);\n                    E();\n                    $();\n                },\n                P: function(a) {\n                    Ea = a;\n                    var b = a.Uk;\n                    ((b && (Ab = Na.Fc(b))));\n                    L.setAttribute(\"autocomplete\", \"off\");\n                    L.setAttribute(\"spellcheck\", a.spellcheck);\n                    L.style.outline = ((a.yo ? \"\" : \"none\"));\n                    ((Ta && X()));\n                },\n                I: function() {\n                    return _.y.F.ob;\n                },\n                N: function() {\n                    return _.y.C.ob;\n                },\n                K: function() {\n                    return {\n                        Vq: a,\n                        hh: b,\n                        Kc: c,\n                        Kb: d,\n                        of: e,\n                        getHeight: f,\n                        getWidth: g,\n                        xg: h,\n                        Nm: k,\n                        zg: l,\n                        Lg: n,\n                        select: p,\n                        refresh: m,\n                        JSBNG__focus: t,\n                        JSBNG__blur: s,\n                        $c: r,\n                        clear: w\n                    };\n                },\n                xa: function() {\n                    ((Ta && W()));\n                    ((Ea.Hg && Y.Ag(L, da.Ui)));\n                }\n            };\n            return hb;\n        };\n        _.y.C.ob = 4;\n        _.y.O.register(_.y.F.ob, _.y.C.ob, _.y.Kp);\n        _.y.fw = function() {\n            function a(a, b) {\n                if (!V) {\n                    return !1;\n                }\n            ;\n            ;\n                ga = b;\n                G();\n                for (var c = !1, d = 0, e; e = a[d++]; ) {\n                    ((m(e) && (c = !0)));\n                ;\n                };\n            ;\n                return c;\n            };\n        ;\n            function b(a) {\n                var b = F[a.I()];\n                return ((((b && b.dn)) ? b.dn(a) : !1));\n            };\n        ;\n            function c(a) {\n                return F[a.I()].Vb(null, a, R);\n            };\n        ;\n            function d(a) {\n                var b = F[a.I()];\n                if (((b && b.qd))) {\n                    var c = E.Va();\n                    return b.qd(a, c);\n                }\n            ;\n            ;\n                return a.X();\n            };\n        ;\n            function e(a, b) {\n                if (!V) {\n                    return !1;\n                }\n            ;\n            ;\n                ga = b;\n                G();\n                for (var c = !1, d = 0, e; e = a[d++]; ) {\n                    if (((1 == e))) {\n                        if (ha) ia.appendChild(ha);\n                         else {\n                            e = s();\n                            var f = e.style;\n                            f.textAlign = \"center\";\n                            f.whiteSpace = \"nowrap\";\n                            e.dir = ja;\n                            f = _.y.Ka();\n                            f.style.position = \"relative\";\n                            da = _.y.Ka();\n                            da.className = \"gssb_g\";\n                            ((T.Uf && (da.style.paddingBottom = \"1px\")));\n                            var g = mTa;\n                            t(T.Sl, da, g.Zv);\n                            ((T.Hr ? t(T.Ne, da, g.Pv) : ((T.Ir && t(T.Tr, da, g.$v)))));\n                            f.appendChild(da);\n                            e.appendChild(f);\n                            ha = e.parentNode;\n                        }\n                    ;\n                    }\n                     else {\n                        ((((2 == e)) ? ((na ? ia.appendChild(na) : (e = s(), f = e.style, f.padding = \"1px 4px 2px 0\", f.fontSize = \"11px\", f.textAlign = \"right\", f = _.y.ea(\"a\"), f.id = \"gssb_b\", f.href = ((((\"http://www.google.com/support/websearch/bin/answer.py?hl=\" + T.Od)) + \"&answer=106230\")), f.innerHTML = T.xl, e.appendChild(f), na = e.parentNode))) : ((((3 == e)) ? (((e = $.pop()) ? ia.appendChild(e) : (e = V.insertRow(-1), e.An = !0, e = e.insertCell(-1), f = _.y.ea(\"div\", \"gssb_l\"), e.appendChild(f)))) : ((m(e) && (c = !0)))))));\n                    }\n                ;\n                ;\n                };\n            ;\n                return c;\n            };\n        ;\n            function f(a) {\n                r(a, Y);\n                var b = J.Ba();\n                ((b && u.Aa(9, {\n                    index: a,\n                    Rw: b[a],\n                    ZC: X[a]\n                })));\n            };\n        ;\n            function g(a) {\n                r(a, \"\");\n                u.Aa(10);\n            };\n        ;\n            function h() {\n                for (var a, b, c; c = P.pop(); ) {\n                    a = c.I(), (((b = ca[a]) || (b = ca[a] = []))), b.push(c), a = c.za(), a.parentNode.removeChild(a);\n                ;\n                };\n            ;\n                for (; a = ia.firstChild; ) {\n                    a = ia.removeChild(a), ((a.An ? $.push(a) : ((((((a != ha)) && ((a != na)))) && S.push(a)))));\n                ;\n                };\n            ;\n                X = [];\n            };\n        ;\n            function k(a) {\n                return (((a = X[a]) ? a.hb() : !1));\n            };\n        ;\n            function l() {\n                G();\n            };\n        ;\n            function n() {\n                return V;\n            };\n        ;\n            function p() {\n                return ((((T.Pl || ((ja == ga)))) ? W : null));\n            };\n        ;\n            function m(a) {\n                var b = a.I(), c = F[b];\n                if (!c) {\n                    return !1;\n                }\n            ;\n            ;\n                var d = (((b = ca[b]) && b.pop()));\n                ((d || (d = c.Tb(R))));\n                c.render(a, d);\n                P.push(d);\n                var e = d.za(), b = s();\n                b.className = ((\"gssb_a \" + T.Bf));\n                b.appendChild(e);\n                if (((void 0 !== a.Ya))) {\n                    X.push(d);\n                    var d = ga, f = a.Ya();\n                    ((T.Es && (e.JSBNG__onmouseover = function() {\n                        J.Ck(f);\n                    }, e.JSBNG__onmouseout = function() {\n                        J.Qr();\n                    })));\n                    e.JSBNG__onclick = function(b) {\n                        E.Td();\n                        ((a.Dd() && E.uc(a.X())));\n                        J.yj();\n                        J.$m(f);\n                        b = ((b || _.y.getWindow(e).JSBNG__event));\n                        c.tb(b, a, R);\n                    };\n                }\n                 else d = ja;\n            ;\n            ;\n                _.y.qj(b, d);\n                return !0;\n            };\n        ;\n            function t(a, b, c) {\n                var d = _.y.ea(\"input\");\n                d.type = \"button\";\n                d.value = _.y.unescape(a);\n                d.JSBNG__onclick = function() {\n                    R.search(E.Ha(), c);\n                };\n                var e;\n                if (T.Ol) {\n                    a = \"lsb\";\n                    e = _.y.ea(\"span\");\n                    var f = _.y.ea(\"span\");\n                    e.className = \"ds\";\n                    f.className = \"lsbb\";\n                    e.appendChild(f);\n                    f.appendChild(d);\n                }\n                 else a = \"gssb_h\", e = d;\n            ;\n            ;\n                d.className = a;\n                b.appendChild(e);\n            };\n        ;\n            function s() {\n                var a = S.pop();\n                if (a) {\n                    return ia.appendChild(a), a.firstChild;\n                }\n            ;\n            ;\n                a = V.insertRow(-1);\n                a = a.insertCell(-1);\n                a.className = T.Bf;\n                a.JSBNG__onmousedown = w;\n                return a;\n            };\n        ;\n            function r(a, b) {\n                var c = X[a];\n                ((((c && c.hb())) && (c.za().parentNode.parentNode.className = b)));\n            };\n        ;\n            function w(a) {\n                a = ((a || _.y.getWindow(V).JSBNG__event));\n                ((a.stopPropagation ? a.stopPropagation() : ((_.y.gd || ((_.y.ub && E.Lg()))))));\n                return !1;\n            };\n        ;\n            function G() {\n                if (da) {\n                    var a = ((T.Ok ? T.Ok : ((E.getWidth() - 3))));\n                    ((((0 < a)) && (da.style.width = ((a + \"px\")))));\n                }\n            ;\n            ;\n            };\n        ;\n            var J, u, E, F, R, Z, T, ca = {\n            }, P = [], S = [], $ = [], X = [], W, ga, ja, V, ia, ha, da, na, Y, fa = {\n                qa: function(a, b) {\n                    Z = a;\n                    ja = a.ud();\n                    b.addRule(\".gssb_a\", \"padding:0 7px\");\n                    b.addRule(\".gssb_a,.gssb_a td\", \"white-space:nowrap;overflow:hidden;line-height:22px\");\n                    b.addRule(\"#gssb_b\", \"font-size:11px;color:#36c;text-decoration:none\");\n                    b.addRule(\"#gssb_b:hover\", \"font-size:11px;color:#36c;text-decoration:underline\");\n                    b.addRule(\".gssb_g\", \"text-align:center;padding:8px 0 7px;position:relative\");\n                    b.addRule(\".gssb_h\", [\"font-size:15px;height:28px;margin:0.2em\",((_.y.Jd ? \";-webkit-appearance:button\" : \"\")),].join(\"\"));\n                    b.addRule(\".gssb_i\", \"background:#eee\");\n                    b.addRule(\".gss_ifl\", \"visibility:hidden;padding-left:5px\");\n                    b.addRule(\".gssb_i .gss_ifl\", \"visibility:visible\");\n                    b.addRule(\"a.gssb_j\", \"font-size:13px;color:#36c;text-decoration:none;line-height:100%\");\n                    b.addRule(\"a.gssb_j:hover\", \"text-decoration:underline\");\n                    b.addRule(\".gssb_l\", \"height:1px;background-color:#e5e5e5\");\n                    b.addRule(\".gssb_m\", \"color:#000;background:#fff\");\n                },\n                R: function(a) {\n                    var b = _.y.F;\n                    J = a.get(b.ra, fa);\n                    u = a.get(b.wa, fa);\n                    E = a.get(b.Z, fa);\n                    R = a.get(b.Xa, fa);\n                    F = _.y.Rg(a.Ia(b.RENDERER, fa));\n                },\n                ga: function(a) {\n                    T = a;\n                    V = _.y.Jc();\n                    a = _.y.ea(\"tbody\");\n                    V.appendChild(a);\n                    ia = V.getElementsByTagName(\"tbody\")[0];\n                },\n                P: function(a) {\n                    T = a;\n                    var b = a.uf;\n                    ((b && (W = Z.Fc(b))));\n                    V.className = ((a.jr || \"gssb_m\"));\n                    Y = ((a.ir || \"gssb_i\"));\n                },\n                I: function() {\n                    return _.y.F.gc;\n                },\n                N: function() {\n                    return _.y.C.gc;\n                },\n                K: function() {\n                    return {\n                        Hn: a,\n                        qd: d,\n                        ve: c,\n                        jd: b,\n                        render: e,\n                        bh: f,\n                        Ac: g,\n                        clear: h,\n                        hb: k,\n                        $b: l,\n                        za: n,\n                        qf: p\n                    };\n                }\n            };\n            return fa;\n        };\n        _.y.C.gc = 18;\n        _.y.O.register(_.y.F.gc, _.y.C.gc, _.y.fw);\n        _.y.hq = function() {\n            function a(a) {\n                h(a);\n                var b = a.wb();\n                if (((((!b || !b.vl())) && p))) {\n                    for (b = 0; ((b < p.length)); ++b) {\n                        p[b].update(a);\n                    ;\n                    };\n                }\n            ;\n            ;\n            };\n        ;\n            function b(a) {\n                var b = ((n[a.Gh()] || null));\n                if (b) {\n                    ++m;\n                }\n                 else {\n                    if (((p && !a.vl()))) {\n                        for (var c = 0; ((c < p.length)); ++c) {\n                            if (b = p[c].get(a)) {\n                                h(b);\n                                ++t;\n                                break;\n                            }\n                        ;\n                        ;\n                        };\n                    }\n                ;\n                }\n            ;\n            ;\n                ((b && (c = a.ha(), ((((c != b.ha())) && (b = _.y.Hd(a, c, b.Ba(), b.U(), b.nh(), b.Ud(), b.Ji())))))));\n                return b;\n            };\n        ;\n            function c() {\n                return m;\n            };\n        ;\n            function d() {\n                return t;\n            };\n        ;\n            function e() {\n                t = m = 0;\n            };\n        ;\n            function f(a) {\n                var b, c, d, e;\n                {\n                    var fin55keys = ((window.top.JSBNG_Replay.forInKeys)((n))), fin55i = (0);\n                    (0);\n                    for (; (fin55i < fin55keys.length); (fin55i++)) {\n                        ((e) = (fin55keys[fin55i]));\n                        {\n                            for (b = n[e], b = b.Ba(), d = 0; c = b[d++]; ) {\n                                if (((c.I() == a))) {\n                                    delete n[e];\n                                    break;\n                                }\n                            ;\n                            ;\n                            };\n                        ;\n                        };\n                    };\n                };\n            ;\n                k();\n            };\n        ;\n            function g() {\n                n = {\n                };\n                k();\n            };\n        ;\n            function h(a) {\n                ((((a && a.Ud())) && (n[a.wb().Gh()] = a)));\n            };\n        ;\n            function k() {\n                if (p) {\n                    for (var a = 0; ((a < p.length)); ++a) {\n                        p[a].reset();\n                    ;\n                    };\n                }\n            ;\n            ;\n            };\n        ;\n            function l(a, b) {\n                return ((b.Fa() - a.Fa()));\n            };\n        ;\n            var n = {\n            }, p, m, t, s = {\n                R: function(a) {\n                    p = a.Ia(_.y.F.qc, s);\n                    p.sort(l);\n                },\n                P: function() {\n                    e();\n                },\n                I: function() {\n                    return _.y.F.nc;\n                },\n                N: function() {\n                    return _.y.C.nc;\n                },\n                K: function() {\n                    return {\n                        put: a,\n                        get: b,\n                        ho: c,\n                        cg: d,\n                        xc: e,\n                        Xn: f,\n                        Pk: g\n                    };\n                }\n            };\n            return s;\n        };\n        _.y.C.nc = 21;\n        _.y.O.register(_.y.F.nc, _.y.C.nc, _.y.hq);\n        _.y.Zw = function(a, b, c, d, e, f, g, h, k, l, n, p, m, t, s) {\n            var r = {\n                Yt: function() {\n                    return a;\n                },\n                Fa: function() {\n                    return b;\n                },\n                Aw: function() {\n                    return c;\n                },\n                zw: function() {\n                    return d;\n                },\n                uB: function() {\n                    return e;\n                },\n                tB: function() {\n                    return f;\n                },\n                rw: function() {\n                    return g;\n                },\n                eb: function(a, b) {\n                    return ((h ? h(r, a, b) : !1));\n                },\n                El: function() {\n                    return k;\n                },\n                Vi: function() {\n                    return l;\n                },\n                Rb: function() {\n                    return n;\n                },\n                wf: function() {\n                    return p;\n                },\n                EB: function(a) {\n                    return ((m ? m(r, a) : !0));\n                },\n                remove: function(a) {\n                    ((t && t(r, a)));\n                },\n                qB: function() {\n                    return s;\n                },\n                equals: function(d) {\n                    return ((((r == d)) || ((((((d && ((d.Yt() == a)))) && ((d.Fa() == b)))) && ((d.Aw() == c))))));\n                }\n            };\n            return r;\n        };\n        _.y.BA = function() {\n            function a(a) {\n                if (f(a)) {\n                    return !1;\n                }\n            ;\n            ;\n                var b = P[S];\n                l(b);\n                P.push(a);\n                P.sort(u);\n                var c = E(a);\n                R.TB(a, c);\n                ((b && k(b)));\n                F();\n                return !0;\n            };\n        ;\n            function b(b) {\n                b = _.y.Vt(((b || window.JSBNG__location.href)));\n                for (var c = P.length, d; d = P[--c]; ) {\n                    ((d.EB(b) || n(d, !1)));\n                ;\n                };\n            ;\n                for (c = 0; d = ca[c++]; ) {\n                    if (d = d.tx(b)) {\n                        for (var e = 0, f; f = d[e++]; ) {\n                            a(f);\n                        ;\n                        };\n                    }\n                ;\n                ;\n                };\n            ;\n            };\n        ;\n            function c() {\n                for (var a = P.length, b; b = P[--a]; ) {\n                    if (b = b.rw()) {\n                        return b;\n                    }\n                ;\n                ;\n                };\n            ;\n                return \"\";\n            };\n        ;\n            function d() {\n                return !!P.length;\n            };\n        ;\n            function e() {\n                return ((-1 != S));\n            };\n        ;\n            function f(a) {\n                return ((-1 != E(a)));\n            };\n        ;\n            function g(a) {\n                return ((e() && ((E(a) == S))));\n            };\n        ;\n            function h() {\n                ((d() && k(P[((P.length - 1))])));\n            };\n        ;\n            function k(a) {\n                a = E(a);\n                ((((a != S)) && (((e() && R.Ac(S))), Z.Td(), S = a, ((e() && R.bh(S))))));\n            };\n        ;\n            function l(a) {\n                ((e() && (a = E(a), R.Ac(a), ((((a == S)) && (S = -1))))));\n            };\n        ;\n            function n(a, b) {\n                var c = E(a);\n                if (((-1 == c))) {\n                    return !1;\n                }\n            ;\n            ;\n                var d = P[S];\n                l(d);\n                P.splice(c, 1);\n                R.Dt(c);\n                ((d && k(d)));\n                F();\n                a.remove(!!b);\n                Z.pg();\n                ((b && Z.cu()));\n                return !0;\n            };\n        ;\n            function p() {\n                ((((0 < S)) && (R.Ac(S), --S, R.bh(S))));\n            };\n        ;\n            function m() {\n                ((e() && ((((((S + 1)) == P.length)) ? (R.Ac(S), S = -1, Z.pg()) : (R.Ac(S), ++S, R.bh(S))))));\n            };\n        ;\n            function t() {\n                n(P[S], !0);\n            };\n        ;\n            function s() {\n                ((e() && (l(P[S]), Z.pg())));\n            };\n        ;\n            function r() {\n                return $;\n            };\n        ;\n            function w() {\n                for (var a = 0, b; b = P[a++]; ) {\n                    if (b.Rb()) {\n                        return !0;\n                    }\n                ;\n                ;\n                };\n            ;\n                return !1;\n            };\n        ;\n            function G() {\n                for (var a = P.length, b; b = P[--a]; ) {\n                    if (b = b.wf()) {\n                        return b;\n                    }\n                ;\n                ;\n                };\n            ;\n                return \"\";\n            };\n        ;\n            function J() {\n                return P.slice(0);\n            };\n        ;\n            function u(a, b) {\n                return ((a.Fa() - b.Fa()));\n            };\n        ;\n            function E(a) {\n                for (var b = 0, c = P.length; ((b < c)); ++b) {\n                    if (P[b].equals(a)) {\n                        return b;\n                    }\n                ;\n                ;\n                };\n            ;\n                return -1;\n            };\n        ;\n            function F() {\n                for (var a = 0, b; b = P[a++]; ) {\n                    if (b.El()) {\n                        T.xf(!1);\n                        $ = !0;\n                        return;\n                    }\n                ;\n                ;\n                };\n            ;\n                T.xf(!0);\n                $ = !1;\n            };\n        ;\n            var R, Z, T, ca, P = [], S = -1, $ = !1, X = {\n                R: function(a) {\n                    var b = _.y.F;\n                    R = a.get(b.Af, X);\n                    Z = a.get(b.Z, X);\n                    T = a.get(b.ra, X);\n                    ca = a.Ia(b.De, X);\n                },\n                P: function() {\n                    b();\n                },\n                I: function() {\n                    return _.y.F.gb;\n                },\n                N: function() {\n                    return _.y.C.gb;\n                },\n                K: function() {\n                    return {\n                        A: a,\n                        qh: b,\n                        rw: c,\n                        eb: d,\n                        B: e,\n                        isActive: f,\n                        $E: g,\n                        Bk: h,\n                        select: k,\n                        Qu: l,\n                        Dt: n,\n                        Qw: p,\n                        Pw: m,\n                        SB: t,\n                        dB: s,\n                        El: r,\n                        Rb: w,\n                        wf: G,\n                        oB: J\n                    };\n                }\n            };\n            return X;\n        };\n        _.y.C.gb = 22;\n        _.y.O.register(_.y.F.gb, _.y.C.gb, _.y.BA);\n        _.y.CA = function() {\n            function a(a, b) {\n                var f = c.DONT_CARE;\n                if (e) {\n                    for (var l = d.oB(), n = 0, p; p = l[n++]; ) {\n                        ((p.eb(a, b) && (f = c.Ci)));\n                    ;\n                    };\n                }\n            ;\n            ;\n                return f;\n            };\n        ;\n            function b() {\n                return 11;\n            };\n        ;\n            var c = E4, d, e, f = {\n                R: function(a) {\n                    d = a.get(_.y.F.gb, f);\n                },\n                P: function(a) {\n                    e = !!a.Ra[_.y.C.bq];\n                },\n                I: function() {\n                    return _.y.F.kb;\n                },\n                N: function() {\n                    return _.y.C.bq;\n                },\n                K: function() {\n                    return {\n                        Tc: a,\n                        Fa: b\n                    };\n                }\n            };\n            return f;\n        };\n        _.y.C.bq = 112;\n        _.y.O.register(_.y.F.kb, _.y.C.bq, _.y.CA);\n        _.y.DA = function() {\n            function a(a, b) {\n                function c() {\n                    var a = _.y.ea(\"span\", \"gscp_e\");\n                    d.appendChild(a);\n                };\n            ;\n                var d = _.y.ea(\"a\", \"gscp_a\");\n                ((n && (d.style.margin = ((n + \"px\")))));\n                ((l && (d.style.height = d.style.lineHeight = ((l + \"px\")))));\n                _.y.Ur(d);\n                d.href = \"#\";\n                d.JSBNG__onclick = function() {\n                    h.defer(function() {\n                        f.select(a);\n                    });\n                    return !1;\n                };\n                d.JSBNG__onfocus = function() {\n                    f.select(a);\n                };\n                d.JSBNG__onblur = function() {\n                    f.Qu(a);\n                };\n                d.JSBNG__onkeydown = e;\n                var g = a.Aw();\n                if (g) {\n                    var p = a.uB(), J = a.tB();\n                    if (a.zw()) {\n                        var u = _.y.ea(\"span\", \"gscp_f\"), E = u.style;\n                        E.width = ((p + \"px\"));\n                        E.height = ((J + \"px\"));\n                        E.background = [\"url(\",g,\") no-repeat \",a.zw(),].join(\"\");\n                    }\n                     else u = _.y.ea(\"img\", \"gscp_f\"), u.src = g, u.width = p, u.height = J;\n                ;\n                ;\n                    ((((J < l)) && (u.style.marginBottom = ((((((l - J)) / 2)) + \"px\")))));\n                    d.appendChild(u);\n                }\n            ;\n            ;\n                c();\n                g = _.y.ea(\"span\", \"gscp_c\");\n                _.y.Tl(g, a.Yt());\n                d.appendChild(g);\n                ((a.Vi() ? (g = _.y.ea(\"span\", \"gscp_d\"), g.innerHTML = \"&times;\", g.JSBNG__onclick = function(b) {\n                    f.Dt(a, !0);\n                    return _.y.Sb(b);\n                }, d.appendChild(g)) : c()));\n                ((k && ((((b >= k.childNodes.length)) ? k.appendChild(d) : k.insertBefore(d, k.childNodes[b])))));\n            };\n        ;\n            function b(a) {\n                if (a = k.childNodes[a]) {\n                    a.className = \"gscp_a gscp_b\", a.JSBNG__focus();\n                }\n            ;\n            ;\n            };\n        ;\n            function c(a) {\n                if (a = k.childNodes[a]) {\n                    a.className = \"gscp_a\";\n                }\n            ;\n            ;\n            };\n        ;\n            function d(a) {\n                k.removeChild(k.childNodes[a]);\n            };\n        ;\n            function e(a) {\n                a = ((a || window.JSBNG__event));\n                var b = G4, c = a.keyCode, d = ((\"rtl\" == g.yd()));\n                switch (c) {\n                  case b.Ek:\n                    ((d ? f.Pw() : f.Qw()));\n                    break;\n                  case b.Fk:\n                    ((d ? f.Qw() : f.Pw()));\n                    break;\n                  case b.lk:\n                \n                  case b.Gk:\n                    f.SB();\n                    break;\n                  case b.Se:\n                \n                  case b.Lt:\n                    f.dB();\n                  default:\n                    return;\n                };\n            ;\n                _.y.Sb(a);\n            };\n        ;\n            var f, g, h, k, l, n, p = {\n                qa: function(a, b) {\n                    b.addRule(\".gscp_a,.gscp_c,.gscp_d,.gscp_e,.gscp_f\", \"display:inline-block;vertical-align:bottom\");\n                    b.addRule(\".gscp_f\", \"border:none\");\n                    b.addRule(\".gscp_a\", [\"background:#d9e7fe;border:1px solid #9cb0d8;cursor:default;outline:none;text-decoration:none!important;\",b.prefix(\"user-select:none;\"),].join(\"\"));\n                    b.addRule(\".gscp_a:hover\", \"border-color:#869ec9\");\n                    b.addRule(\".gscp_a.gscp_b\", \"background:#4787ec;border-color:#3967bf\");\n                    b.addRule(\".gscp_c\", \"color:#444;font-size:13px;font-weight:bold\");\n                    b.addRule(\".gscp_d\", \"color:#aeb8cb;cursor:pointer;font:21px arial,sans-serif;line-height:inherit;padding:0 7px\");\n                    if (((_.y.Du || ((_.y.Yk && _.y.Cu))))) {\n                        b.addRule(\".gscp_d\", \"position:relative;top:1px\"), ((_.y.ub && b.addRule(\".gscp_c\", \"position:relative;top:1px\")));\n                    }\n                ;\n                ;\n                    b.addRule(\".gscp_a:hover .gscp_d\", \"color:#575b66\");\n                    b.addRule(\".gscp_c:hover,.gscp_a .gscp_d:hover\", \"color:#222\");\n                    b.addRule(\".gscp_a.gscp_b .gscp_c,.gscp_a.gscp_b .gscp_d\", \"color:#fff\");\n                    b.addRule(\".gscp_e\", \"height:100%;padding:0 4px\");\n                },\n                R: function(a) {\n                    var b = _.y.F;\n                    f = a.get(b.gb, p);\n                    g = a.get(b.Z, p);\n                    h = a.get(b.wa, p);\n                },\n                ga: function(a) {\n                    ((a.Ra[_.y.F.gb] && (n = a.Rt, k = g.hh(), (((a = a.Ug) && (l = ((a - ((2 * ((n + 1))))))))))));\n                },\n                I: function() {\n                    return _.y.F.Af;\n                },\n                N: function() {\n                    return _.y.C.Af;\n                },\n                K: function() {\n                    return {\n                        TB: a,\n                        bh: b,\n                        Ac: c,\n                        Dt: d\n                    };\n                }\n            };\n            return p;\n        };\n        _.y.C.Af = 23;\n        _.y.O.register(_.y.F.Af, _.y.C.Af, _.y.DA);\n        _.y.tD = function() {\n            function a() {\n                ((n && k.jw(h)));\n            };\n        ;\n            function b() {\n                ((n && k.uu(h)));\n            };\n        ;\n            function c() {\n                ((n && l.jw(h)));\n            };\n        ;\n            function d() {\n                ((n && l.uu(h)));\n            };\n        ;\n            var e, f, g, h, k, l, n = !1, p = {\n                qa: function(a, b) {\n                    function c(a) {\n                        return [\"box-shadow:\",a,\"-moz-box-shadow:\",a,\"-webkit-box-shadow:\",a,].join(\"\");\n                    };\n                ;\n                    g = a;\n                    b.addRule(\".gsfe_a\", [\"border:1px solid #b9b9b9;border-top-color:#a0a0a0;\",c(\"inset 0px 1px 2px rgba(0,0,0,0.1);\"),].join(\"\"));\n                    b.addRule(\".gsfe_b\", [\"border:1px solid #4d90fe;outline:none;\",c(\"inset 0px 1px 2px rgba(0,0,0,0.3);\"),].join(\"\"));\n                },\n                R: function(a) {\n                    var b = _.y.F;\n                    e = a.get(b.wa, p);\n                    f = a.get(b.Z, p);\n                },\n                ga: function(f) {\n                    var n = f.xs;\n                    if (h = ((n ? g.Fc(n) : null))) {\n                        e.fc(F4.vv, c), e.fc(F4.uv, d), e.Na(h, \"mouseover\", a), e.Na(h, \"mouseout\", b), k = _.y.Sz(((f.Tu || \"gsfe_a\"))), l = _.y.Sz(((f.Su || \"gsfe_b\")));\n                    }\n                ;\n                ;\n                },\n                P: function() {\n                    n = !0;\n                    ((((h && f.dv())) && l.jw(h)));\n                },\n                I: function() {\n                    return _.y.F.Wd;\n                },\n                N: function() {\n                    return _.y.C.Mz;\n                },\n                xa: function() {\n                    n = !1;\n                    ((h && (k.uu(h), l.uu(h))));\n                }\n            };\n            return p;\n        };\n        _.y.C.Mz = 190;\n        _.y.O.register(_.y.F.Wd, _.y.C.Mz, _.y.tD);\n        _.y.Sz = function(a) {\n            var b = RegExp(((((\"(?:^|\\\\s+)\" + a)) + \"(?:$|\\\\s+)\")));\n            return {\n                jw: function(c) {\n                    ((((c && !b.test(c.className))) && (c.className += ((\" \" + a)))));\n                },\n                uu: function(a) {\n                    ((a && (a.className = a.className.replace(b, \" \"))));\n                }\n            };\n        };\n        _.y.or = function() {\n            function a(a) {\n                a = f.getWidth(a);\n                var b = d.xg();\n                return ((a < b));\n            };\n        ;\n            function b(a) {\n                c(a, !0);\n            };\n        ;\n            function c(b, c) {\n                if (((g && a(d.Ha())))) {\n                    if (((!h || c))) {\n                        e.Aa(6, b), h = !0;\n                    }\n                ;\n                ;\n                }\n                 else ((h && (e.Aa(7), h = !1)));\n            ;\n            ;\n            };\n        ;\n            var d, e, f, g, h = !0, k = {\n                R: function(a) {\n                    var b = _.y.F;\n                    e = a.get(b.wa, k);\n                    d = a.get(b.Z, k);\n                    f = a.get(b.Cb, k);\n                },\n                ga: function() {\n                    var a = e.fc;\n                    a(F4.rr, b);\n                    a(F4.Sh, b);\n                    a(F4.Th, b);\n                    a(F4.mk, c);\n                },\n                P: function(a) {\n                    g = !!a.Ra[_.y.F.Ta];\n                    c(null, !0);\n                },\n                I: function() {\n                    return _.y.F.Ta;\n                },\n                N: function() {\n                    return _.y.C.Ta;\n                },\n                K: function() {\n                    return {\n                        Pq: a\n                    };\n                }\n            };\n            return k;\n        };\n        _.y.C.Ta = 46;\n        _.y.O.register(_.y.F.Ta, _.y.C.Ta, _.y.or);\n        _.y.qr = function() {\n            function a() {\n                return d;\n            };\n        ;\n            var b, c, d, e, f = {\n                qa: function(a) {\n                    e = a;\n                },\n                R: function(a) {\n                    b = a.get(_.y.F.ob, f);\n                    c = a.wc();\n                },\n                ga: function() {\n                    d = e.get(\"gs_lc\");\n                    if (!d) {\n                        d = _.y.Ka();\n                        d.id = e.getId(\"gs_lc\");\n                        d.style.position = \"relative\";\n                        var a = c.zd(), f = e.je().style;\n                        ((((2 == a)) && (f.overflow = \"hidden\")));\n                        f.background = \"transparent url(data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw%3D%3D)\";\n                        f.position = \"absolute\";\n                        f.zIndex = 6;\n                        b.Vq(d);\n                    }\n                ;\n                ;\n                },\n                I: function() {\n                    return _.y.F.Bb;\n                },\n                N: function() {\n                    return _.y.C.Bb;\n                },\n                K: function() {\n                    return {\n                        Jl: a\n                    };\n                }\n            };\n            return f;\n        };\n        _.y.C.Bb = 43;\n        _.y.O.register(_.y.F.Bb, _.y.C.Bb, _.y.qr);\n        _.y.GA = function() {\n            function a() {\n                return k;\n            };\n        ;\n            function b() {\n                ((((((g && k)) && !e.Ha())) ? ((h || (d.show(), h = !0))) : c()));\n            };\n        ;\n            function c() {\n                ((h && (d.hide(), h = !1)));\n            };\n        ;\n            var d, e, f, g, h = !0, k, l = {\n                R: function(a) {\n                    var b = _.y.F;\n                    d = a.get(b.Rd, l);\n                    e = a.get(b.Z, l);\n                    f = a.get(b.wa, l);\n                },\n                ga: function() {\n                    var a = f.fc;\n                    a(F4.Kk, b);\n                    a(F4.Sh, b);\n                    a(F4.Th, b);\n                    a(F4.Jk, c);\n                },\n                P: function(a) {\n                    g = !!a.Ra[_.y.F.vb];\n                    d.Kc(e.yd());\n                    a = ((a.hk || \"\"));\n                    ((((k != a)) && (k = a, d.refresh())));\n                    b();\n                },\n                I: function() {\n                    return _.y.F.vb;\n                },\n                N: function() {\n                    return _.y.C.vb;\n                },\n                K: function() {\n                    return {\n                        Ha: a\n                    };\n                }\n            };\n            return l;\n        };\n        _.y.C.vb = 38;\n        _.y.O.register(_.y.F.vb, _.y.C.vb, _.y.GA);\n        _.y.HA = function() {\n            function a() {\n                var a = e.Ha();\n                ((p ? _.y.xe(n, _.y.escape(a)) : ((((n.value != a)) && (n.value = a, _.y.Px(k.je(), a))))));\n            };\n        ;\n            function b() {\n                n.style.visibility = \"\";\n            };\n        ;\n            function c() {\n                n.style.visibility = \"hidden\";\n            };\n        ;\n            function d(a) {\n                _.y.zl(n, a);\n            };\n        ;\n            var e, f, g, h, k, l, n, p, m = {\n                qa: function(a) {\n                    k = a;\n                },\n                R: function(a) {\n                    var b = _.y.F;\n                    e = a.get(b.vb, m);\n                    f = a.get(b.Bb, m);\n                    g = a.wc();\n                },\n                ga: function(a) {\n                    l = f.Jl();\n                    h = g.getId();\n                    p = ((2 == g.zd()));\n                    var b = ((((p ? \"gs_htd\" : \"gs_htif\")) + h)), c = k.Fc(b);\n                    ((c ? n = c : (((p ? c = _.y.ii(a.Xc, 1) : (c = _.y.ea(\"input\", a.Xc), c.disabled = \"disabled\", c.autocapitalize = c.autocomplete = c.autocorrect = \"off\", _.y.Ds(c), _.y.nj(c), a = c.style, a.position = \"absolute\", a.zIndex = 1, a.backgroundColor = \"transparent\", a.outline = \"\", ((_.y.Jd && (a.WebkitTextFillColor = \"silver\")))))), c.id = b, c.style.color = \"silver\", l.appendChild(c), n = c)));\n                },\n                I: function() {\n                    return _.y.F.Rd;\n                },\n                N: function() {\n                    return _.y.C.Rd;\n                },\n                K: function() {\n                    return {\n                        refresh: a,\n                        show: b,\n                        hide: c,\n                        Kc: d\n                    };\n                }\n            };\n            return m;\n        };\n        _.y.C.Rd = 42;\n        _.y.O.register(_.y.F.Rd, _.y.C.Rd, _.y.HA);\n        _.y.Rv = function() {\n            function a(a) {\n                return _.y.Sv(e, a);\n            };\n        ;\n            function b(a, b) {\n                b.render(a.Nb(), a.X(), f);\n            };\n        ;\n            function c(a, b, c) {\n                c.search(b.X(), 1);\n            };\n        ;\n            function d() {\n                return 38;\n            };\n        ;\n            var e, f, g = {\n                qa: function(a, b) {\n                    b.addRule(\".gsmq_a\", \"padding:0\");\n                },\n                R: function(a) {\n                    e = a.get(_.y.F.Z, g);\n                },\n                P: function(a) {\n                    f = ((a.Nd ? a.Ne : \"\"));\n                },\n                I: function() {\n                    return _.y.F.RENDERER;\n                },\n                N: function() {\n                    return _.y.C.ur;\n                },\n                K: function() {\n                    return {\n                        Tb: a,\n                        render: b,\n                        tb: c,\n                        Vb: _.y.Y,\n                        Ub: d\n                    };\n                }\n            };\n            return g;\n        };\n        _.y.C.ur = 94;\n        _.y.O.register(_.y.F.RENDERER, _.y.C.ur, _.y.Rv);\n        _.y.Sv = function(a, b) {\n            var c, d, e, f, g;\n            (function() {\n                c = _.y.Ka();\n                c.className = \"gsmq_a\";\n                var a = _.y.Jc();\n                c.appendChild(a);\n                d = a.insertRow(-1);\n                a = d.insertCell(-1);\n                a.style.width = \"100%\";\n                e = _.y.ea(\"span\");\n                a.appendChild(e);\n            })();\n            return {\n                za: function() {\n                    return c;\n                },\n                I: (0, _.ua)(38),\n                hb: (0, _.ua)(!0),\n                render: function(c, k, l) {\n                    e.innerHTML = c;\n                    g = k;\n                    ((((l && !f)) && (f = _.y.Wg(d), f.JSBNG__onclick = function(c) {\n                        a.Td();\n                        a.uc(g);\n                        b.search(g, 9);\n                        return _.y.Sb(c);\n                    })));\n                    ((l ? (f.innerHTML = ((l + \" &raquo;\")), f.style.display = \"\") : ((f && (f.style.display = \"none\")))));\n                }\n            };\n        };\n        _.y.Tv = function() {\n            function a(a, b) {\n                if (((c && b))) {\n                    var f = b.U().ka(\"i\");\n                    a.setParameter(\"gs_mss\", f);\n                }\n            ;\n            ;\n                return 1;\n            };\n        ;\n            function b() {\n                return 7;\n            };\n        ;\n            var c;\n            return {\n                P: function(a) {\n                    c = !!a.Ra[_.y.C.uj];\n                },\n                I: function() {\n                    return _.y.F.kb;\n                },\n                N: function() {\n                    return _.y.C.uj;\n                },\n                K: function() {\n                    return {\n                        Tc: a,\n                        Fa: b\n                    };\n                }\n            };\n        };\n        _.y.C.uj = 49;\n        _.y.O.register(_.y.F.kb, _.y.C.uj, _.y.Tv);\n        _.y.Iu = function() {\n            function a(a) {\n                n = a.Lj;\n                p = a.yl;\n                m = a.Wk;\n                t = ((a.Nd ? a.Ne : \"\"));\n            };\n        ;\n            function b(a) {\n                return _.y.Ju(f, g, h, k, l, a, n, m);\n            };\n        ;\n            function c(a, b) {\n                b.render(a.Nb(), a.X(), a.Ya(), p, t);\n            };\n        ;\n            function d(a, b, c) {\n                c.search(b.X(), 1);\n            };\n        ;\n            function e() {\n                return 35;\n            };\n        ;\n            var f, g, h, k, l, n, p, m, t, s = {\n                qa: function(a, b) {\n                    b.addRule(\"a.gspqs_a\", \"padding:0 3px 0 8px\");\n                    b.addRule(\".gspqs_b\", \"color:#666;line-height:22px\");\n                },\n                R: function(a) {\n                    var b = _.y.F;\n                    h = a.get(b.Ca, s);\n                    k = a.get(b.Z, s);\n                    g = a.get(b.Qb, s);\n                    f = a.get(b.Pa, s);\n                    l = a.get(b.ra, s);\n                },\n                ga: a,\n                P: a,\n                I: function() {\n                    return _.y.F.RENDERER;\n                },\n                N: function() {\n                    return _.y.C.Pt;\n                },\n                K: function() {\n                    return {\n                        Tb: b,\n                        render: c,\n                        tb: d,\n                        Vb: _.y.Y,\n                        Ub: e\n                    };\n                }\n            };\n            return s;\n        };\n        _.y.C.Pt = 33;\n        _.y.O.register(_.y.F.RENDERER, _.y.C.Pt, _.y.Iu);\n        _.y.Ju = function(a, b, c, d, e, f, g, h) {\n            function k(a) {\n                E = !0;\n                b.Ak(G, l);\n                return _.y.Sb(a);\n            };\n        ;\n            function l() {\n                ((E && (c.Yn(35), a.zr(), n.JSBNG__onmouseover = n.JSBNG__onmouseout = n.JSBNG__onclick = null, p.style.display = \"none\", m.style.display = \"\", ((((e.Hi() == J)) && d.oj())), ((((e.Zq() == J)) && (e.yj(), d.pg()))), u = !1)));\n            };\n        ;\n            var n, p, m, t, s, r, w, G, J, u = !0, E = !1;\n            (function() {\n                n = _.y.Ka();\n                n.className = \"gsq_a\";\n                var a = _.y.Jc();\n                n.appendChild(a);\n                p = a.insertRow(-1);\n                var b = p.insertCell(-1);\n                t = _.y.ea(\"span\");\n                t.style.color = \"#52188c\";\n                b.appendChild(t);\n                if (((0 != g))) {\n                    r = _.y.ea(\"a\");\n                    r.href = \"#ps\";\n                    r.className = \"gspqs_a gssb_j\";\n                    var c = p.insertCell(-1);\n                    c.appendChild(r);\n                    ((((2 == g)) ? c : b)).style.width = \"100%\";\n                    m = a.insertRow(-1);\n                    w = m.insertCell(-1);\n                    w.className = \"gspqs_b\";\n                    w.innerHTML = h;\n                    w.colSpan = \"2\";\n                }\n            ;\n            ;\n            })();\n            return {\n                za: function() {\n                    return n;\n                },\n                I: (0, _.ua)(35),\n                hb: function() {\n                    return u;\n                },\n                render: function(a, b, c, e, h) {\n                    E = !1;\n                    u = !0;\n                    G = b;\n                    J = c;\n                    p.style.display = \"\";\n                    t.innerHTML = a;\n                    ((((0 != g)) && (m.style.display = \"none\", r.innerHTML = e, r.JSBNG__onclick = k)));\n                    ((((h && !s)) && (s = _.y.Wg(p), s.JSBNG__onclick = function(a) {\n                        d.Td();\n                        d.uc(G);\n                        f.search(G, 9);\n                        return _.y.Sb(a);\n                    })));\n                    ((h ? (s.innerHTML = ((h + \" &raquo;\")), s.style.display = \"\") : ((s && (s.style.display = \"none\")))));\n                }\n            };\n        };\n        _.y.Gu = function() {\n            function a() {\n                var a = {\n                };\n                ((f && (a.tok = e)));\n                return a;\n            };\n        ;\n            function b() {\n                return f;\n            };\n        ;\n            function c(a, b) {\n                d.kv(a, b);\n            };\n        ;\n            var d, e, f, g = {\n                R: function(a) {\n                    d = a.get(_.y.F.od, g);\n                },\n                P: function(a) {\n                    e = a.zf;\n                    var b = ((\"https:\" == window.JSBNG__document.JSBNG__location.protocol)), b = ((((0 == a.Hb)) || b));\n                    a = !!a.nb[C4.Ah];\n                    f = !!((((((d && e)) && b)) && a));\n                },\n                I: function() {\n                    return _.y.F.Qb;\n                },\n                N: function() {\n                    return _.y.C.Qb;\n                },\n                K: function() {\n                    return {\n                        Wu: a,\n                        isEnabled: b,\n                        Ak: c\n                    };\n                }\n            };\n            return g;\n        };\n        _.y.C.Qb = 188;\n        _.y.O.register(_.y.F.Qb, _.y.C.Qb, _.y.Gu);\n        _.y.Fu = function() {\n            function a(a, b) {\n                l[a] = b;\n                var n = [];\n                _.y.xb(\"delq\", a, n);\n                _.y.xb(\"client\", h, n);\n                _.y.xb(\"callback\", ((\"google.sbox.d\" + d)), n);\n                var s = e;\n                _.y.xb(\"tok\", f, n);\n                ((g && _.y.xb(\"authuser\", g, n)));\n                k = _.y.ea(\"script\");\n                k.src = ((s + n.join(\"&\")));\n                c.appendChild(k);\n            };\n        ;\n            function b(a) {\n                ((k && (c.removeChild(k), k = null)));\n                a = a[0];\n                var b = l[a];\n                ((b && (delete l[a], b())));\n            };\n        ;\n            var c = _.y.$g(), d, e, f, g, h, k, l = {\n            }, n = {\n                R: function(a) {\n                    a.get(_.y.F.Qb, n);\n                    d = a.wc().getId();\n                },\n                ga: function() {\n                    window.google.sbox[((\"d\" + d))] = b;\n                },\n                P: function(a) {\n                    e = ((((((\"https://\" + ((a.mj || ((\"clients1.\" + a.Pg)))))) + wTa.Ku)) + \"?\"));\n                    f = a.zf;\n                    g = a.authuser;\n                    h = a.Fe;\n                },\n                I: function() {\n                    return _.y.F.od;\n                },\n                N: function() {\n                    return _.y.C.od;\n                },\n                K: function() {\n                    return {\n                        kv: a\n                    };\n                },\n                xa: function() {\n                    ((k && (c.removeChild(k), k = null)));\n                }\n            };\n            return n;\n        };\n        _.y.C.od = 186;\n        _.y.O.register(_.y.F.od, _.y.C.od, _.y.Fu);\n        _.y.Hu = function() {\n            function a(a) {\n                var b = c.Wu(), d;\n                {\n                    var fin56keys = ((window.top.JSBNG_Replay.forInKeys)((b))), fin56i = (0);\n                    (0);\n                    for (; (fin56i < fin56keys.length); (fin56i++)) {\n                        ((d) = (fin56keys[fin56i]));\n                        {\n                            a.setParameter(d, b[d]);\n                        ;\n                        };\n                    };\n                };\n            ;\n                return 1;\n            };\n        ;\n            function b() {\n                return 12;\n            };\n        ;\n            var c, d = {\n                R: function(a) {\n                    c = a.get(_.y.F.Qb, d);\n                },\n                I: function() {\n                    return _.y.F.kb;\n                },\n                N: function() {\n                    return _.y.C.Sn;\n                },\n                K: function() {\n                    return {\n                        Tc: a,\n                        Fa: b\n                    };\n                }\n            };\n            return d;\n        };\n        _.y.C.Sn = 187;\n        _.y.O.register(_.y.F.kb, _.y.C.Sn, _.y.Hu);\n        _.y.ZI = function() {\n            function a(a, b) {\n                var c;\n                if (c = f) {\n                    c = a.Kb();\n                    var d = a.ha(), w = _.y.getTime();\n                    ((((d == k)) ? (((c.equals(l) || (g = null))), c = !1) : (((((d && ((d != g)))) ? ((g ? ((((((b && b.Fb())) && ((b.rd().X() == a.Sa())))) && (g = null))) : ((((((d.length < k.length)) && ((500 <= ((w - n)))))) && (g = k, h = null, e.AF(g)))))) : g = null)), l = c, k = d, n = w, c = !!g)));\n                    if (c) {\n                        n:\n                        {\n                            var p = a.ha(), J = a.Kb().getPosition();\n                            ((((null == h)) && (h = J)));\n                            for (c = 0; ((((c < h)) && ((g[c] == p[c])))); ) {\n                                ++c;\n                            ;\n                            };\n                        ;\n                            d = ((g.length - p.length));\n                            w = ((J + d));\n                            if (((((c < w)) && (p = p.substr(J), J = g.substr(w), ((((c || p)) && ((p == J)))))))) {\n                                h = c;\n                                a.Ye(\"dc\", g.substring(c, w));\n                                c = ((((w - c)) - d));\n                                ((((0 < c)) && a.Ye(\"ac\", c)));\n                                c = !0;\n                                break n;\n                            }\n                        ;\n                        ;\n                            g = null;\n                            c = !1;\n                        };\n                    }\n                ;\n                ;\n                }\n            ;\n            ;\n                return ((c ? (e.bE(a), 2) : 1));\n            };\n        ;\n            function b() {\n                return 5;\n            };\n        ;\n            function c(a) {\n                g = null;\n                k = a.input;\n                n = _.y.getTime();\n            };\n        ;\n            var d, e, f, g, h, k = \"\", l, n = _.y.getTime(), p = {\n                R: function(a) {\n                    var b = _.y.F;\n                    d = a.get(b.wa, p);\n                    e = a.get(b.Ws, p);\n                },\n                ga: function() {\n                    d.fc(4, c);\n                },\n                P: function(a) {\n                    f = !!a.Ra[_.y.C.Jz];\n                },\n                I: function() {\n                    return _.y.F.kb;\n                },\n                N: function() {\n                    return _.y.C.Jz;\n                },\n                K: function() {\n                    return {\n                        Tc: a,\n                        Fa: b\n                    };\n                }\n            };\n            return p;\n        };\n        _.y.C.Jz = 26;\n        _.y.O.register(_.y.F.kb, _.y.C.Jz, _.y.ZI);\n        _.y.qJ = function() {\n            function a(a) {\n                var b = e.DONT_CARE;\n                if (h) {\n                    var d = a.ha(), f = a.Kb().getPosition(), r;\n                    r = f;\n                    if (((r >= d.length))) r = -1;\n                     else {\n                        for (var n = [!0,!0,], G = 0, J = 0; ((J <= r)); ++J) {\n                            n.push(!_.y.kd(d.charAt(J))), ((((n[1] || ((!n[2] && !n[0])))) || ++G)), n.shift();\n                        ;\n                        };\n                    ;\n                        r = G;\n                    }\n                ;\n                ;\n                    ((((r != k)) && (k = r, ((((d && ((d == l)))) && (f = c(d, f), a.Ye(\"cp\", f), g.AF(d), g.bE(a), b = e.Ci))))));\n                    l = d;\n                }\n            ;\n            ;\n                return b;\n            };\n        ;\n            function b() {\n                return 4;\n            };\n        ;\n            function c(a, b) {\n                function c(d) {\n                    return _.y.kd(a.charAt(((b + d))));\n                };\n            ;\n                var d = a.length;\n                if (((b >= d))) {\n                    return d;\n                }\n            ;\n            ;\n                for (d = ((((((0 < b)) && c(0))) && c(-1))); ((((0 < b)) && ((c(-1) == d)))); ) {\n                    --b;\n                ;\n                };\n            ;\n                ((((d && c(1))) && ++b));\n                return b;\n            };\n        ;\n            function d() {\n                k = -1;\n            };\n        ;\n            var e = E4, f, g, h, k, l, n = {\n                R: function(a) {\n                    var b = _.y.F;\n                    f = a.get(b.wa, n);\n                    g = a.get(b.Ws, n);\n                },\n                ga: function() {\n                    f.fc(4, d);\n                },\n                P: function(a) {\n                    h = !!a.Ra[_.y.C.by];\n                },\n                I: function() {\n                    return _.y.F.kb;\n                },\n                N: function() {\n                    return _.y.C.by;\n                },\n                K: function() {\n                    return {\n                        Tc: a,\n                        Fa: b\n                    };\n                }\n            };\n            return n;\n        };\n        _.y.C.by = 28;\n        _.y.O.register(_.y.F.kb, _.y.C.by, _.y.qJ);\n        _.y.jJ = function() {\n            function a(a) {\n                d = null;\n                if (((a && c))) {\n                    var b = c.Ha();\n                    ((((b && _.y.jc(b, a))) && (d = b.substr(a.length))));\n                }\n            ;\n            ;\n            };\n        ;\n            function b(a) {\n                ((d && a.setParameter(\"gs_ta\", d)));\n                a.yr();\n            };\n        ;\n            var c, d, e = {\n                R: function(a) {\n                    c = a.get(_.y.F.Ea, e);\n                },\n                I: function() {\n                    return _.y.F.Ws;\n                },\n                N: function() {\n                    return _.y.C.Ws;\n                },\n                K: function() {\n                    return {\n                        AF: a,\n                        bE: b\n                    };\n                }\n            };\n            return e;\n        };\n        _.y.C.Ws = 204;\n        _.y.F.Ws = 256;\n        _.y.O.register(_.y.F.Ws, _.y.C.Ws, _.y.jJ);\n        _.y.kJ = function() {\n            function a(a) {\n                return _.y.lJ(e, a);\n            };\n        ;\n            function b(a, b) {\n                b.render(a.Nb(), a.X(), f);\n            };\n        ;\n            function c(a, b, c) {\n                c.search(b.X(), 1);\n            };\n        ;\n            function d() {\n                return 39;\n            };\n        ;\n            var e, f, g = {\n                qa: function(a, b) {\n                    b.addRule(\".gsqn_a\", \"padding:0\");\n                },\n                R: function(a) {\n                    e = a.get(_.y.F.Z, g);\n                },\n                P: function(a) {\n                    f = ((a.Nd ? a.Ne : \"\"));\n                },\n                I: function() {\n                    return _.y.F.RENDERER;\n                },\n                N: function() {\n                    return _.y.C.VD;\n                },\n                K: function() {\n                    return {\n                        Tb: a,\n                        render: b,\n                        tb: c,\n                        Vb: _.y.Y,\n                        Ub: d\n                    };\n                }\n            };\n            return g;\n        };\n        _.y.C.VD = 50;\n        _.y.O.register(_.y.F.RENDERER, _.y.C.VD, _.y.kJ);\n        _.y.lJ = function(a, b) {\n            var c, d, e, f, g;\n            (function() {\n                c = _.y.Ka();\n                c.className = \"gsqn_a\";\n                var a = _.y.Jc();\n                c.appendChild(a);\n                d = a.insertRow(-1);\n                a = d.insertCell(-1);\n                a.style.width = \"100%\";\n                e = _.y.ea(\"span\");\n                a.appendChild(e);\n            })();\n            return {\n                za: function() {\n                    return c;\n                },\n                I: (0, _.ua)(39),\n                hb: (0, _.ua)(!0),\n                render: function(c, k, l) {\n                    e.innerHTML = c;\n                    g = k;\n                    ((((l && !f)) && (f = _.y.Wg(d), f.JSBNG__onclick = function(c) {\n                        a.Td();\n                        a.uc(g);\n                        b.search(g, 9);\n                        return _.y.Sb(c);\n                    })));\n                    ((l ? (f.innerHTML = ((l + \" &raquo;\")), f.style.display = \"\") : ((f && (f.style.display = \"none\")))));\n                }\n            };\n        };\n        _.y.GD = function() {\n            function a() {\n                return ((n ? [_.y.Zw(k, 0, f, \"\", g, h, l, null, !1, !0, !0, \"\", null, b, null),] : []));\n            };\n        ;\n            function b(a, b) {\n                if (b) {\n                    var d = {\n                    }, f = _.y.Hh(c, \"tbs\");\n                    if (f) {\n                        var g = {\n                        };\n                        g.tbs = f.value;\n                        d.tbs = window.google.Toolbelt.unset(\"sbi\", g).tbs;\n                    }\n                ;\n                ;\n                    d.tbm = \"isch\";\n                    _.y.ff(c, d);\n                    ((e.Ha() && c.submit()));\n                }\n            ;\n            ;\n            };\n        ;\n            var c, d, e, f, g, h, k, l, n;\n            d = {\n                P: function(a) {\n                    n = !!a.Rk[_.y.C.Mw];\n                },\n                xa: _.y.Y,\n                ga: _.y.Y,\n                I: function() {\n                    return _.y.F.De;\n                },\n                N: function() {\n                    return _.y.C.Mw;\n                },\n                K: function() {\n                    return {\n                        tx: a\n                    };\n                },\n                Gd: _.y.Y,\n                qa: function(a) {\n                    c = a.Qg();\n                },\n                R: function(a) {\n                    e = a.get(_.y.F.Z, p);\n                }\n            };\n            var p = {\n                Uu: function() {\n                    return d;\n                },\n                wF: function(a, b, c, d, e) {\n                    f = a;\n                    g = b;\n                    h = c;\n                    k = d;\n                    l = e;\n                }\n            };\n            return p;\n        };\n        _.y.C.Mw = 183;\n        _.y.XF = function() {\n            function a(a) {\n                return ((((t && ((m == a.ha())))) ? _.y.Hd(a, m, t, _.y.Yf, !0, !1, !1) : null));\n            };\n        ;\n            function b(a) {\n                return ((!!a && ((0 <= a.indexOf(\"**\")))));\n            };\n        ;\n            function c() {\n                return G;\n            };\n        ;\n            function d() {\n                G = \"\";\n            };\n        ;\n            function e() {\n                var a = ((!s || !l.Ha()));\n                ((((a != r)) && (((r ? w.removeAttribute(\"x-webkit-speech\") : w.setAttribute(\"x-webkit-speech\", \"\"))), r = a)));\n            };\n        ;\n            function f(a, b) {\n                b = _.y.escape(b);\n                a = _.y.escape(_.y.Nc(a, _.y.Eh));\n                for (var c = a.split(\" \"), d = b.split(\" \"), e, f = 0; ((f < d.length)); ++f) {\n                    e = d[f], ((((0 > c.indexOf(e))) && (d[f] = e.bold())));\n                ;\n                };\n            ;\n                return d.join(\" \").replace(h, \" \");\n            };\n        ;\n            function g(a) {\n                a = ((((a && a.results)) ? a.results : []));\n                var c = Math.min(a.length, 3);\n                m = a[0].utterance;\n                n.add(6);\n                if (b(m)) {\n                    t = [];\n                    for (var d = 0; ((d < c)); ++d) {\n                        var e = a[d].utterance;\n                        ((b(e) || t.push(_.y.Bd(f(m, e), e, d, 40, null))));\n                    };\n                ;\n                }\n                 else t = null, G = m, p.search(m, 15);\n            ;\n            ;\n            };\n        ;\n            var h = /<\\/b> <b>/gi, k, l, n, p, m, t, s, r, w, G = \"\", J = {\n                qa: function(a) {\n                    w = a.je();\n                },\n                R: function(a) {\n                    var b = _.y.F;\n                    k = a.get(b.wa, J);\n                    l = a.get(b.Z, J);\n                    n = a.get(b.Ja, J);\n                    p = a.get(b.Xa, J);\n                },\n                ga: function(a) {\n                    s = a.Fv;\n                    e();\n                    w.setAttribute(\"x-webkit-grammar\", \"builtin:search\");\n                    ((((\"\" != a.Od)) && w.setAttribute(\"lang\", a.Od)));\n                    (((a = window.google.listen) ? a(w, \"webkitspeechchange\", g) : k.listen(w, \"webkitspeechchange\", g)));\n                    ((s && (k.fc(4, e), k.fc(5, e), k.fc(1, e))));\n                },\n                I: function() {\n                    return _.y.F.Og;\n                },\n                N: function() {\n                    return _.y.C.Og;\n                },\n                K: function() {\n                    return {\n                        hE: d,\n                        yE: c,\n                        zE: a,\n                        qk: b\n                    };\n                }\n            };\n            return J;\n        };\n        _.y.C.Og = 90;\n        _.y.OD = function(a) {\n            var b = _.y.F, c = _.y.XF();\n            a[b.Og] = c;\n            _.y.sg(a, b.kb, _.y.ZF());\n            _.y.sg(a, b.qc, _.y.$F());\n            _.y.sg(a, b.RENDERER, _.y.YF());\n        };\n        _.y.YF = function() {\n            function a(a) {\n                return _.y.PD(e, a);\n            };\n        ;\n            function b(a, b) {\n                b.render(a.Nb(), a.X(), f);\n            };\n        ;\n            function c(a, b, c) {\n                c.search(b.X(), 1);\n            };\n        ;\n            function d() {\n                return 40;\n            };\n        ;\n            var e, f, g = {\n                qa: function(a, b) {\n                    b.addRule(\".gsq_a\", \"padding:0\");\n                },\n                R: function(a) {\n                    e = a.get(_.y.F.Z, g);\n                },\n                P: function(a) {\n                    f = ((a.Nd ? a.Ne : \"\"));\n                },\n                I: function() {\n                    return _.y.F.RENDERER;\n                },\n                N: function() {\n                    return _.y.C.$D;\n                },\n                K: function() {\n                    return {\n                        Tb: a,\n                        render: b,\n                        tb: c,\n                        Vb: _.y.Y,\n                        Ub: d\n                    };\n                }\n            };\n            return g;\n        };\n        _.y.C.$D = 30;\n        _.y.PD = function(a, b) {\n            var c, d, e, f, g;\n            (function() {\n                c = _.y.Ka();\n                c.className = \"gsq_a\";\n                var a = _.y.Jc();\n                c.appendChild(a);\n                d = a.insertRow(-1);\n                a = d.insertCell(-1);\n                a.style.width = \"100%\";\n                e = _.y.ea(\"span\");\n                a.appendChild(e);\n            })();\n            return {\n                za: function() {\n                    return c;\n                },\n                I: (0, _.ua)(40),\n                hb: (0, _.ua)(!0),\n                render: function(c, k, l) {\n                    e.innerHTML = c;\n                    g = k;\n                    ((((l && !f)) && (f = _.y.Wg(d), f.JSBNG__onclick = function(c) {\n                        a.Td();\n                        a.uc(g);\n                        b.search(g, 9);\n                        return _.y.Sb(c);\n                    })));\n                    ((l ? (f.innerHTML = ((l + \" &raquo;\")), f.style.display = \"\") : ((f && (f.style.display = \"none\")))));\n                }\n            };\n        };\n        _.y.ZF = function() {\n            function a(a) {\n                var b = a.ij();\n                return ((((((c && ((\"input\" == b)))) && ((c.yE() == a.ha())))) ? (c.hE(), 3) : 1));\n            };\n        ;\n            function b() {\n                return 22;\n            };\n        ;\n            var c, d = {\n                R: function(a) {\n                    c = a.get(_.y.F.Og, d);\n                },\n                I: function() {\n                    return _.y.F.kb;\n                },\n                N: function() {\n                    return _.y.C.oE;\n                },\n                K: function() {\n                    return {\n                        Tc: a,\n                        Fa: b\n                    };\n                }\n            };\n            return d;\n        };\n        _.y.C.oE = 465;\n        _.y.$F = function() {\n            function a() {\n                return 1;\n            };\n        ;\n            function b(a) {\n                var b = null;\n                ((c && (b = c.zE(a))));\n                return b;\n            };\n        ;\n            var c, d = {\n                I: function() {\n                    return _.y.F.qc;\n                },\n                R: function(a) {\n                    c = a.get(_.y.F.Og, d);\n                },\n                N: function() {\n                    return _.y.C.rE;\n                },\n                K: function() {\n                    return {\n                        Fa: a,\n                        update: _.y.Y,\n                        get: b,\n                        reset: _.y.Y\n                    };\n                }\n            };\n            return d;\n        };\n        _.y.C.rE = 100;\n        _.y.QD = function() {\n            function a() {\n                if (k) {\n                    var a = h.Eb(), e = f.Ha();\n                    if (((((((_.y.kd(e) && g.Pq(e))) && ((a && _.y.jc(e, a.ha()))))) && (a = a.U().ka(\"p\"))))) {\n                        e = f.yd();\n                        ((((e != n)) && (n = e, d.Kc(e))));\n                        a = a.replace(c, \"\\u003Cspan class=gsc_b\\u003E$1\\u003C/span\\u003E\");\n                        d.refresh(a);\n                        ((l || (d.show(), l = !0)));\n                        return;\n                    }\n                ;\n                ;\n                }\n            ;\n            ;\n                b();\n            };\n        ;\n            function b() {\n                ((l && (d.hide(), l = !1)));\n            };\n        ;\n            var c = /<se>(.*?)<\\/se>/g, d, e, f, g, h, k, l = !0, n, p = {\n                R: function(a) {\n                    var b = _.y.F;\n                    e = a.get(b.wa, p);\n                    f = a.get(b.Z, p);\n                    g = a.get(b.Ta, p);\n                    h = a.get(b.Ga, p);\n                    a.get(b.ra, p);\n                    d = a.get(b.Ze, p);\n                },\n                ga: function() {\n                    var c = e.fc;\n                    c(F4.qv, b);\n                    c(F4.Jk, b);\n                    c(F4.Sh, b);\n                    c(F4.Th, a);\n                    c(F4.Xl, a);\n                    c(F4.Kk, a);\n                },\n                P: function(b) {\n                    k = !!b.Ra[_.y.F.Sc];\n                    a();\n                },\n                I: function() {\n                    return _.y.F.Sc;\n                },\n                N: function() {\n                    return _.y.C.Sc;\n                }\n            };\n            return p;\n        };\n        _.y.C.Sc = 44;\n        _.y.O.register(_.y.F.Sc, _.y.C.Sc, _.y.QD);\n        _.y.RD = function() {\n            function a(a) {\n                _.y.xe(g, a);\n            };\n        ;\n            function b() {\n                g.style.visibility = \"\";\n            };\n        ;\n            function c() {\n                g.style.visibility = \"hidden\";\n                _.y.xe(g, \"\");\n            };\n        ;\n            function d(a) {\n                _.y.zl(g, a);\n            };\n        ;\n            var e, f, g, h, k = {\n                qa: function(a, b) {\n                    h = a;\n                    ((a.ue() || b.addRule(\".gsc_b\", \"background:url(data:image/gif;base64,R0lGODlhCgAEAMIEAP9BGP6pl//Wy/7//P///////////////yH5BAEKAAQALAAAAAAKAAQAAAMROCOhK0oA0MIUMmTAZhsWBCYAOw==) repeat-x scroll 0 100% transparent;display:inline-block;padding-bottom:1px\")));\n                },\n                R: function(a) {\n                    e = a.get(_.y.F.Bb, k);\n                },\n                ga: function(a) {\n                    f = e.Jl();\n                    var b = h.get(\"gs_sc\");\n                    ((b || (b = _.y.ii(a.Xc, 2), b.id = h.getId(\"gs_sc\"), b.style.color = \"transparent\", f.appendChild(b))));\n                    g = b;\n                },\n                I: function() {\n                    return _.y.F.Ze;\n                },\n                N: function() {\n                    return _.y.C.Ze;\n                },\n                K: function() {\n                    return {\n                        refresh: a,\n                        show: b,\n                        hide: c,\n                        Kc: d\n                    };\n                }\n            };\n            return k;\n        };\n        _.y.C.Ze = 39;\n        _.y.O.register(_.y.F.Ze, _.y.C.Ze, _.y.RD);\n        _.y.Us = function() {\n            function a() {\n                return E;\n            };\n        ;\n            function b(a) {\n                E = a;\n                f();\n                ((J && w.ug(a)));\n            };\n        ;\n            function c() {\n                var a = t.Eb();\n                if (((((J && a)) && a.Fb()))) {\n                    var c = a.ha();\n                    var e = a.rd();\n                    if (((((c && e)) && e.Dd()))) {\n                        var a = c.replace(k, \" \"), f = _.y.Nc(a, _.y.Eh).toLowerCase(), f = f.replace(l, \"\");\n                        ((G && (f = G.Dn(f))));\n                        var g = e.Fg(), e = ((g ? _.y.unescape(g.replace(n, \"\")) : e.X())).replace(l, \"\");\n                        ((_.y.jc(e, f, !0) && ((((((f = e.substr(f.length)) && _.y.Jr(a))) && (f = _.y.trim(f)))), c = ((c + f)))));\n                    }\n                     else c = \"\";\n                ;\n                ;\n                    b(c);\n                }\n                 else d();\n            ;\n            ;\n            };\n        ;\n            function d() {\n                ((E && (E = \"\", F = !1, ((u && p.refresh())), w.vg())));\n            };\n        ;\n            function e(a) {\n                if (E) {\n                    var b = m.Ha();\n                    ((((_.y.kd(b) && !E.indexOf(b))) || d()));\n                }\n            ;\n            ;\n                ((a.Pb && p.Kc(a.Pb)));\n                g();\n            };\n        ;\n            function f() {\n                F = ((((((J && !!E)) && s.Pq(E))) && m.br(E)));\n                ((u ? ((F ? p.refresh() : h())) : ((F && g()))));\n            };\n        ;\n            function g() {\n                ((((!u && F)) && (p.refresh(), p.show(), u = !0)));\n            };\n        ;\n            function h() {\n                ((u && (p.hide(), u = !1)));\n            };\n        ;\n            var k = /((^|\\s)[!\"%',:;<>?[\\\\\\]`{|}~]+)|[,\\\\]+/g, l = /^\\+/, n = /<\\/?se>/gi, p, m, t, s, r, w, G, J, u = !0, E, F, R = {\n                R: function(a) {\n                    var b = _.y.F;\n                    p = a.get(b.Cc, R);\n                    r = a.get(b.wa, R);\n                    G = a.get(b.Ic, R);\n                    m = a.get(b.Z, R);\n                    s = a.get(b.Ta, R);\n                    t = a.get(b.Ga, R);\n                    w = a.Zb();\n                },\n                ga: function(a) {\n                    var b = r.fc;\n                    b(F4.Kk, e);\n                    ((((1 == a.zj)) && b(F4.Xl, c)));\n                    b(F4.Sh, d);\n                    b(F4.Th, c);\n                    b(F4.mk, f);\n                    b(F4.Jk, h);\n                },\n                P: function(a) {\n                    J = !!a.Ra[_.y.F.Ea];\n                    p.Kc(m.yd());\n                    c();\n                },\n                I: function() {\n                    return _.y.F.Ea;\n                },\n                N: function() {\n                    return _.y.C.Ea;\n                },\n                K: function() {\n                    return {\n                        Ha: a,\n                        uc: b,\n                        refresh: c,\n                        clear: d\n                    };\n                }\n            };\n            return R;\n        };\n        _.y.C.Ea = 41;\n        _.y.O.register(_.y.F.Ea, _.y.C.Ea, _.y.Us);\n        _.y.Vs = function() {\n            function a() {\n                var a = e.Ha();\n                ((p ? _.y.xe(n, _.y.escape(a)) : ((((n.value != a)) && (n.value = a)))));\n            };\n        ;\n            function b() {\n                n.style.visibility = \"\";\n            };\n        ;\n            function c() {\n                n.style.visibility = \"hidden\";\n            };\n        ;\n            function d(a) {\n                _.y.zl(n, a);\n            };\n        ;\n            var e, f, g, h, k, l, n, p, m = {\n                qa: function(a) {\n                    k = a;\n                },\n                R: function(a) {\n                    var b = _.y.F;\n                    e = a.get(b.Ea, m);\n                    f = a.get(b.Bb, m);\n                    g = a.wc();\n                },\n                ga: function(a) {\n                    l = f.Jl();\n                    h = g.getId();\n                    p = ((2 == g.zd()));\n                    var b = ((((p ? \"gs_tad\" : \"gs_taif\")) + h)), c = k.Fc(b);\n                    ((c ? n = c : (((p ? c = _.y.ii(a.Xc, 1) : (c = _.y.ea(\"input\", a.Xc), c.disabled = \"disabled\", c.autocapitalize = c.autocomplete = c.autocorrect = \"off\", _.y.Ds(c), _.y.nj(c), a = c.style, a.position = \"absolute\", a.zIndex = 1, a.backgroundColor = \"transparent\", a.outline = \"\", ((_.y.Jd && (a.WebkitTextFillColor = \"silver\")))))), c.id = b, c.style.color = \"silver\", l.appendChild(c), n = c)));\n                },\n                I: function() {\n                    return _.y.F.Cc;\n                },\n                N: function() {\n                    return _.y.C.Cc;\n                },\n                K: function() {\n                    return {\n                        refresh: a,\n                        show: b,\n                        hide: c,\n                        Kc: d\n                    };\n                }\n            };\n            return m;\n        };\n        _.y.C.Cc = 51;\n        _.y.O.register(_.y.F.Cc, _.y.C.Cc, _.y.Vs);\n        _.y.Uv = function() {\n            function a(a) {\n                if (k) {\n                    var f = d(a);\n                    if (f) {\n                        a = {\n                        };\n                        a[e.$r] = f.Kw;\n                        a[e.ak] = f.OB;\n                        var f = f.userName, h = \"\", r = a[e.ak];\n                        ((((r && g.test(r))) && (h = ((r + \"?sz=23\")))));\n                        return [_.y.Zw(f, 0, h, \"\", 23, 23, \"\", null, !0, !0, !0, f, b, c, a),];\n                    }\n                ;\n                ;\n                }\n            ;\n            ;\n                return [];\n            };\n        ;\n            function b(a, b) {\n                var c = d(b);\n                if (c) {\n                    var f = ((a.qB()[e.$r] || \"\"));\n                    return ((c.Kw == f));\n                }\n            ;\n            ;\n                return !1;\n            };\n        ;\n            function c() {\n                _.y.Hl(l, \"tbs\");\n            };\n        ;\n            function d(a) {\n                var b = window.google.Toolbelt.parseTbs(a.tbs);\n                a = b.ppl_nps;\n                var c = b.ppl_ids;\n                if (((c && a))) {\n                    a = a.replace(f, \" \");\n                    var d = \"\";\n                    (((b = b.ppl_im) && (d = [\"//\",b,\"/photo.jpg\",].join(\"\"))));\n                    return {\n                        Kw: c,\n                        userName: a,\n                        OB: d\n                    };\n                }\n            ;\n            ;\n                return null;\n            };\n        ;\n            var e = zTa, f = /\\+/g, g = /^\\/\\/lh\\d+\\.googleusercontent\\.com\\//, h, k, l, n;\n            n = {\n                qa: function(a) {\n                    l = a.Qg();\n                },\n                R: function(a) {\n                    h = a.get(_.y.F.ra, p);\n                },\n                ga: _.y.Y,\n                P: function(a) {\n                    k = !!a.Rk[_.y.C.eq];\n                },\n                I: function() {\n                    return _.y.F.De;\n                },\n                N: function() {\n                    return _.y.C.eq;\n                },\n                K: function() {\n                    return {\n                        tx: a\n                    };\n                },\n                Gd: _.y.Y,\n                xa: _.y.Y\n            };\n            var p = {\n                Uu: function() {\n                    return n;\n                },\n                sB: function() {\n                    if (h.Pc()) {\n                        var a = h.Oc();\n                        if (((44 == a.I()))) {\n                            var b = a.X(), c = a.U(), a = {\n                            }, d = c.ka(e.$r);\n                            if (!d) {\n                                var f = c.ka(e.Bu);\n                                ((f && (d = [\"-\",f,].join(\"\"))));\n                            }\n                        ;\n                        ;\n                            window.google.Toolbelt.set(\"ppl_ids\", ((d || \"\")), a);\n                            window.google.Toolbelt.set(\"ppl_nps\", b, a);\n                            if (b = c.ka(e.ak)) {\n                                b = b.substring(2, ((b.length - 10))), window.google.Toolbelt.set(\"ppl_im\", b, a);\n                            }\n                        ;\n                        ;\n                            return (0, window.decodeURIComponent)(a.tbs);\n                        }\n                    ;\n                    ;\n                    }\n                ;\n                ;\n                    return \"\";\n                }\n            };\n            return p;\n        };\n        _.y.C.eq = 24;\n        _.y.O.register(_.y.F.De, _.y.C.eq, _.y.Uv);\n        _.y.UA = function() {\n            function a() {\n                return _.y.Lu(44);\n            };\n        ;\n            function b(a, b) {\n                f.render(a.Nb(), a.U(), b, 44);\n            };\n        ;\n            function c(a, b, c) {\n                c.search(b.X(), 1);\n            };\n        ;\n            function d() {\n                return !1;\n            };\n        ;\n            function e() {\n                return 44;\n            };\n        ;\n            var f, g = {\n                R: function(a) {\n                    f = a.get(_.y.F.Df, g);\n                },\n                I: function() {\n                    return _.y.F.RENDERER;\n                },\n                N: function() {\n                    return _.y.C.Lw;\n                },\n                K: function() {\n                    return {\n                        Tb: a,\n                        render: b,\n                        tb: c,\n                        Vb: d,\n                        Ub: e\n                    };\n                }\n            };\n            return g;\n        };\n        _.y.C.Lw = 242;\n        _.y.O.register(_.y.F.RENDERER, _.y.C.Lw, _.y.UA);\n        _.y.Lu = function(a) {\n            var b, c, d, e;\n            (function() {\n                b = _.y.Ka();\n                b.className = \"gsso_a\";\n                var a = _.y.Jc();\n                b.appendChild(a);\n                var g = a.insertRow(-1), h = g.insertCell(-1);\n                h.className = \"gsso_b\";\n                h.rowSpan = 2;\n                c = _.y.ea(\"img\");\n                c.className = \"gsso_c\";\n                h.appendChild(c);\n                h = g.insertCell(-1);\n                h.rowSpan = 2;\n                var k = _.y.Ka(\"gsso_d\");\n                h.appendChild(k);\n                g = g.insertCell(-1);\n                g.className = \"gsso_e\";\n                d = _.y.ea(\"span\");\n                g.appendChild(d);\n                h = _.y.ea(\"span\", \"gsso_g\");\n                h.innerHTML = \" &middot; plus.google.com\";\n                g.appendChild(h);\n                g = a.insertRow(-1);\n                e = g.insertCell(-1);\n                e.className = \"gsso_f\";\n            })();\n            return {\n                za: function() {\n                    return b;\n                },\n                I: function() {\n                    return a;\n                },\n                hb: (0, _.ua)(!0),\n                render: function(a, b, h, k, l) {\n                    c.src = b;\n                    d.innerHTML = a;\n                    a = [];\n                    ((l && a.push(l)));\n                    ((h && a.push(h)));\n                    ((k && a.push(k)));\n                    _.y.Tl(e, a.join(\" \\u2022 \"));\n                }\n            };\n        };\n        _.y.$y = function() {\n            function a(a, c, d, e) {\n                if (((45 == e))) {\n                    e = yTa;\n                }\n                 else {\n                    if (((44 == e))) {\n                        e = zTa;\n                    }\n                     else {\n                        return;\n                    }\n                ;\n                }\n            ;\n            ;\n                var f = \"//www.google.com/images/ps_placeholder_25.png\", g = c.ka(e.ak);\n                ((g && (f = ((g + \"?sz=36\")))));\n                d.render(a, f, c.ka(e.Kt), c.ka(e.Jt), c.ka(e.It));\n            };\n        ;\n            return {\n                qa: function(a, c) {\n                    c.addRule(\".gsso_a\", \"padding:3px 0\");\n                    c.addRule(\".gsso_a td\", \"line-height:18px\");\n                    c.addRule(\".gsso_b\", \"width:36px\");\n                    c.addRule(\".gsso_c\", \"height:36px;vertical-align:middle;width:36px\");\n                    c.addRule(\".gsso_d\", \"width:7px\");\n                    c.addRule(\".gsso_e\", \"width:100%\");\n                    c.addRule(\".gsso_f\", \"color:#666;font-size:13px;padding-bottom:2px\");\n                    c.addRule(\".gsso_g\", \"color:#093;font-size:13px\");\n                },\n                I: function() {\n                    return _.y.F.Df;\n                },\n                N: function() {\n                    return _.y.C.Df;\n                },\n                K: function() {\n                    return {\n                        render: a\n                    };\n                }\n            };\n        };\n        _.y.C.Df = 244;\n        _.y.O.eh(_.y.F.Df, _.y.C.Df, _.y.$y);\n        _.y.Ny = function() {\n            function a() {\n                return _.y.Lu(45);\n            };\n        ;\n            function b(a, b) {\n                var c = a.U(), d = c.ka(\"l\");\n                g.render(d, c, b, 45);\n            };\n        ;\n            function c(a, b, c) {\n                f(a, b, c);\n            };\n        ;\n            function d(a, b, c) {\n                f(a, b, c);\n                return !0;\n            };\n        ;\n            function e() {\n                return 45;\n            };\n        ;\n            function f(a, b, c) {\n                (((a = b.U().ka(\"k\")) ? c.ic(a) : c.search(b.X(), 1)));\n            };\n        ;\n            var g, h = {\n                R: function(a) {\n                    g = a.get(_.y.F.Df, h);\n                },\n                I: function() {\n                    return _.y.F.RENDERER;\n                },\n                N: function() {\n                    return _.y.C.Ut;\n                },\n                K: function() {\n                    return {\n                        Tb: a,\n                        render: b,\n                        tb: c,\n                        Vb: d,\n                        Ub: e\n                    };\n                }\n            };\n            return h;\n        };\n        _.y.C.Ut = 243;\n        _.y.O.register(_.y.F.RENDERER, _.y.C.Ut, _.y.Ny);\n        _.y.Qa = function(a) {\n            function b(b) {\n                var c = J.G(), e = d(), f = ((Z != t.gf));\n                if (((X[1] || _.y.kj(window.google.kHL)))) {\n                    c.Qi = !0;\n                }\n            ;\n            ;\n                c.vh = F;\n                c.Li = ((W.pq || \"\"));\n                c.zf = ((W.token || \"\"));\n                c.Ki = ((W.stok || \"\"));\n                c.fg = ((W.exp || \"\"));\n                c.wi = ((W.scc || \"\"));\n                c.vo = !0;\n                c.ye = ((e ? 1 : 0));\n                c.Od = window.google.kHL;\n                c.authuser = window.google.authuser;\n                c.Mj = f;\n                c.Ug = 27;\n                ((W.soff && (c.Ii = !0)));\n                c.mg = W.agen;\n                c.ng = W.cgen;\n                var g = W.lyrs, h = ((((g & s.Xb)) && e)), l = ((((g & s.Ea)) && e)), p = ((((g & s.dk)) && e)), T = ((g & s.vb)), va = ((g & s.sr)), V = c.Ra;\n                V[r.Ta] = ((g & s.Xj));\n                V[r.Xb] = h;\n                V[r.Ea] = l;\n                V[r.Sc] = p;\n                V[r.vb] = T;\n                V[r.lg] = va;\n                c.zj = ((l ? 2 : 0));\n                g = C4;\n                ((R && (c.Yi = !0, c.Zg = ((e ? W.sce : W.scd)))));\n                ((e && (c.Xi = !0, c.Ri = !0, ((W.navs || delete c.nb[g.Oi])), c.nb[g.Di] = !0)));\n                ((W.jsonp ? (c.Hb = 0, c.Pg = W.host, c.gg = !0) : c.Hb = 1));\n                ((((((((R || f)) && ((window.google.j && window.google.j.gt)))) && (e = window.google.j.gt()))) && (c.Hb = 2, c.Pj = (0, _.mk)((0, _.hj)(), e))));\n                ((a.gk && a.gk(c)));\n                if (e = W.ovr) {\n                    f = e, ((((((\"ent\" in f)) && (S = !!f.ent))) && (c.nb[46] = !0))), ((((\"he\" in f)) && (c.uf = f.he))), ((a.fk && a.fk(f, c)));\n                }\n            ;\n            ;\n                k(c);\n                e = ((e || {\n                }));\n                _.y.Qa.eb(e, c);\n                e = !1;\n                ((a.P && (e = a.P(c))));\n                if (((w && ca))) n(), ((((((((!R || P)) || b)) || e)) ? w.P(c) : ((d() || w.qh())))), ((a.Ao && a.Ao()));\n                 else {\n                    w = G.G(E, u, ja, 0);\n                    w.Ef(c);\n                    _.y.Dq(u, w);\n                    b = [m.Cg,m.Ad,];\n                    for (c = 0; e = b[c++]; ) {\n                        $[e] = w.Le(u, e);\n                    ;\n                    };\n                ;\n                    for (b = 0; c = ga[b++]; ) {\n                        window.google.msg.listen(c.xj, c.jk, c.Pd);\n                    ;\n                    };\n                ;\n                    ((a.Ef && a.Ef()));\n                }\n            ;\n            ;\n            };\n        ;\n            function c() {\n                return w;\n            };\n        ;\n            function d() {\n                return ((Z == t.dj));\n            };\n        ;\n            function e(a, b, c) {\n                ga.push({\n                    xj: a,\n                    jk: b,\n                    Pd: c\n                });\n            };\n        ;\n            function f() {\n                return X;\n            };\n        ;\n            function g(a) {\n                var b = w.Ti();\n                return ((((a + \"&\")) + w.Ge(b)));\n            };\n        ;\n            function h(a, b, c, d) {\n                ((((null != d)) && (c[m.Vj] = d)));\n                _.y.ff(u, c);\n                c = w.Ti(b);\n                a = [a,_.y.wj(b),];\n                ((window.google.msg.send(15, a) && (a = m.Cg, (($[a] && ($[a].value = c[a]))), a = m.Ad, (($[a] && ($[a].value = c[a]))), ((((u.JSBNG__onsubmit && ((!1 == u.JSBNG__onsubmit())))) || u.submit())))));\n                _.y.gr();\n                ((((null != d)) && (w.yc(d), _.y.Hl(u, m.Vj))));\n            };\n        ;\n            function k(b) {\n                function c(a, b, f) {\n                    ((((e & a)) || (d[b] = d[f] = 161)));\n                };\n            ;\n                var d = {\n                }, e = W.lyrs;\n                c(s.Xj, r.Ta, r.Bb);\n                c(s.Xb, r.Xb, r.kg);\n                c(s.Ea, r.Ea, r.Cc);\n                c(s.dk, r.Sc, r.Ze);\n                c(s.vb, r.vb, r.Rd);\n                ((a.ek && (d[r.Wd] = [162,], a.ek(b, d))));\n                _.y.Qa.A(d, W);\n                b.Fh = d;\n            };\n        ;\n            function l() {\n                var b = {\n                };\n                ((a.Nl && (b = a.Nl())));\n                if (S) {\n                    var c = m.kf;\n                    if (!((c in b))) {\n                        var d = w.uk(c);\n                        ((d && (b[c] = d)));\n                    }\n                ;\n                ;\n                }\n            ;\n            ;\n                ((((6 == w.Cr())) && (b[m.MA] = \"1\")));\n                return b;\n            };\n        ;\n            function n() {\n                var a = m.Cg;\n                (($[a] && ($[a].value = \"\")));\n                a = m.Ad;\n                (($[a] && ($[a].value = \"\")));\n            };\n        ;\n            function p(a) {\n                a = ((a ? t.dj : t.gf));\n                ((((a != Z)) && (Z = a, ca = T = !0, b(!0))));\n            };\n        ;\n            var m = {\n                Cg: \"oq\",\n                Vj: \"dq\",\n                MA: \"gs_ivs\",\n                wr: \"tbs\",\n                Ad: \"gs_l\",\n                kf: \"gs_ssp\"\n            }, t = {\n                dj: \"p\",\n                Oz: \"i\",\n                gf: \"b\"\n            }, s = {\n                Xj: 1,\n                Xb: 2,\n                Ea: 4,\n                dk: 8,\n                vb: 16,\n                sr: 32\n            }, r = _.y.F, w, G, J, u, E, F, R, Z = t.gf, T = !1, ca, P, S, $ = {\n            }, X, W, ga = [], ja = {\n                a: f,\n                b: function(a, b) {\n                    var c = l();\n                    if (((m.wr in c))) {\n                        h(a, b, c, \"\");\n                    }\n                     else {\n                        if (_.y.kd(a)) h(a, b, c);\n                         else {\n                            var d = w.wf();\n                            ((d && (w.yc(d), h(d, b, c, a))));\n                        }\n                    ;\n                    }\n                ;\n                ;\n                },\n                c: function(a) {\n                    window.JSBNG__location = a;\n                },\n                d: function(b) {\n                    ((a.ic ? a.ic(b) : (b = g(b), ((((((window.google && window.google.nav)) && window.google.nav.go)) ? window.google.nav.go(b) : window.JSBNG__location = b)))));\n                },\n                e: g,\n                f: function(a) {\n                    _.y.ff(u, {\n                    });\n                    window.google.msg.send(49, [a,]);\n                },\n                h: function(a) {\n                    _.y.ff(u, {\n                    });\n                    window.google.msg.send(66, [a,]);\n                },\n                i: function(a) {\n                    window.google.msg.send(50, [a,]);\n                },\n                j: function(b, c) {\n                    ((a.Cd && a.Cd(b, c)));\n                    ((_.y.Nc(b.ha()) && window.google.msg.send(9, [b.ha(),_.y.Xq(b.Ba()),b.xd(),c,])));\n                },\n                k: function(a, b) {\n                    var c = b.X();\n                    window.google.msg.send(23, [a,c,]);\n                },\n                l: function() {\n                    n();\n                },\n                m: (0, _.ka)(),\n                o: function() {\n                    ((a.Yc && a.Yc()));\n                    window.google.msg.send(22);\n                },\n                p: function() {\n                    ((a.Zc && a.Zc()));\n                    window.google.msg.send(11);\n                },\n                r: function(b, c) {\n                    ((a.Rc && a.Rc(b, c)));\n                    _.y.Qa.B(b, c);\n                },\n                s: function(a) {\n                    window.google.msg.send(54, [a,]);\n                },\n                t: function() {\n                    window.google.msg.send(55);\n                },\n                u: function() {\n                    ((a.Wc && a.Wc()));\n                },\n                w: function(a) {\n                    _.y.ff(u, l());\n                    var b = a;\n                    ((_.y.kd(a) || (b = ((w.wf() || a)))));\n                    window.google.msg.send(12, [b,]);\n                },\n                z: function() {\n                    window.google.msg.send(74);\n                },\n                aa: function() {\n                    window.google.msg.send(75);\n                },\n                ac: function(b, c) {\n                    if (a.Ce) {\n                        return a.Ce(b, c);\n                    }\n                ;\n                ;\n                }\n            }, V = {\n                Lc: f,\n                zs: function() {\n                    return F;\n                },\n                je: function() {\n                    return E;\n                },\n                io: c,\n                dg: function() {\n                    return W;\n                },\n                zk: d,\n                xo: function() {\n                    return R;\n                },\n                Ot: e\n            };\n            X = _.y.Lc();\n            window.google.ac = {\n                a: b,\n                gs: c,\n                cc: function() {\n                    w.Mb();\n                }\n            };\n            G = _.y.Mk();\n            J = _.y.hp();\n            _.y.Rq(function(c) {\n                var d = _.y.Ml(), e = d.q, f = c.ds;\n                ca = ((((u == d)) && ((E == e))));\n                P = ((F != f));\n                u = d;\n                E = e;\n                F = f;\n                W = c;\n                c = ((c.psy || t.gf));\n                R = ((c == t.dj));\n                ((T || (Z = c)));\n                ((w || window.google.msg.listen(62, p)));\n                ((a.Fn && a.Fn()));\n                b(!1);\n            }, function() {\n                if (w) {\n                    if (!R) {\n                        for (var a = 0, b; b = ga[a++]; ) {\n                            window.google.msg.unlisten(b.xj, b.jk);\n                        ;\n                        };\n                    ;\n                        w.xa();\n                    }\n                ;\n                ;\n                    n();\n                }\n            ;\n            ;\n            });\n            e(4, function(a) {\n                w.yc(a);\n                return null;\n            }, 50);\n            return V;\n        };\n        _.y.Qa.eb = _.y.Y;\n        _.y.Qa.Cf = function(a) {\n            _.y.Qa.eb = a;\n        };\n        _.y.Qa.B = _.y.Y;\n        _.y.Qa.hg = function(a) {\n            _.y.Qa.B = a;\n        };\n        _.y.Qa.A = _.y.Y;\n        _.y.Qa.D = function(a) {\n            _.y.Qa.A = a;\n        };\n        _.y.Cq = function() {\n            function a(a, b, c) {\n                e(a.getId(), a.ha(), b, c);\n                return !0;\n            };\n        ;\n            function b() {\n                return 1;\n            };\n        ;\n            function c() {\n                return t;\n            };\n        ;\n            function d(a) {\n                var b = m[a];\n                ((b && (g(b), delete m[a])));\n            };\n        ;\n            function e(a, b, c, e) {\n                ((s.$f || f()));\n                var g = h();\n                ((g && (b = [n,\"?\",((p ? ((p + \"&\")) : \"\")),((c ? ((c + \"&\")) : \"\")),\"q=\",(0, window.encodeURIComponent)(b),\"&xhr=t\",].join(\"\"), g.open(\"GET\", b, !0), g.onreadystatechange = function() {\n                    if (((4 == g.readyState))) {\n                        switch (g.JSBNG__status) {\n                          case 403:\n                            t = 1000;\n                            break;\n                          case 302:\n                        \n                          case 500:\n                        \n                          case 502:\n                        \n                          case 503:\n                            ++t;\n                            break;\n                          case 200:\n                            e(eval(g.responseText));\n                          default:\n                            t = 0;\n                        };\n                    ;\n                        d(a);\n                    }\n                ;\n                ;\n                }, m[a] = g, g.send(null))));\n            };\n        ;\n            function f() {\n                {\n                    var fin57keys = ((window.top.JSBNG_Replay.forInKeys)((m))), fin57i = (0);\n                    var a;\n                    for (; (fin57i < fin57keys.length); (fin57i++)) {\n                        ((a) = (fin57keys[fin57i]));\n                        {\n                            g(m[a]);\n                        ;\n                        };\n                    };\n                };\n            ;\n                m = {\n                };\n            };\n        ;\n            function g(a) {\n                a.onreadystatechange = _.y.Y;\n                var b = a.readyState;\n                ((((((0 != b)) && ((4 != b)))) && a.abort()));\n            };\n        ;\n            function h() {\n                var a = null;\n                ((_.y.ub ? a = ((k(\"Msxml2\") || k(\"Microsoft\"))) : ((((\"undefined\" != typeof window.JSBNG__XMLHttpRequest)) && (a = new window.JSBNG__XMLHttpRequest)))));\n                return a;\n            };\n        ;\n            function k(a) {\n                var b = null;\n                try {\n                    b = new window.ActiveXObject(((a + \".XMLHTTP\")));\n                } catch (c) {\n                \n                };\n            ;\n                return b;\n            };\n        ;\n            var l, n, p, m = {\n            }, t = 0, s, r = {\n                R: function(a) {\n                    l = a.get(_.y.F.Pa, r);\n                },\n                P: function(a) {\n                    ((((1 == a.Hb)) && (s = a, a = l.Sf(), n = a.we, p = a.Mg)));\n                },\n                I: function() {\n                    return _.y.F.Ab;\n                },\n                N: function() {\n                    return _.y.C.Rh;\n                },\n                K: function() {\n                    return {\n                        dd: a,\n                        Dg: d,\n                        Mb: _.y.Y,\n                        Oe: b,\n                        Pe: c\n                    };\n                },\n                xa: function() {\n                    f();\n                    t = 0;\n                }\n            };\n            return r;\n        };\n        _.y.C.Rh = 180;\n        _.y.O.register(_.y.F.Ab, _.y.C.Rh, _.y.Cq);\n        _.y.Ns = function() {\n            function a(a, b, c, d) {\n                c = a.ha();\n                b = [\"/complete/search?\",((w ? ((w + \"&\")) : \"\")),((b ? ((b + \"&\")) : \"\")),].join(\"\");\n                var e = [];\n                _.y.xb(\"xhr\", \"t\", e);\n                _.y.xb(\"q\", c, e, _.y.Bj);\n                b = ((b + e.join(\"&\")));\n                if (((t.Mj && (b = window.google.msg.send(16, [b,!1,c,], b), !b)))) {\n                    return !1;\n                }\n            ;\n            ;\n                J[c] = a;\n                G = d;\n                r.dd(b);\n                return !0;\n            };\n        ;\n            function b() {\n                J = {\n                };\n                ((s && s.Mb([\"/complete/search\",\"/s\",])));\n            };\n        ;\n            function c() {\n                return 2;\n            };\n        ;\n            function d() {\n                return 0;\n            };\n        ;\n            function e() {\n                var a = [s.A(),s.B(),s.D(),], a = (0, _.nk)(s, a);\n                a.D();\n                f(a, !0);\n            };\n        ;\n            function f(a, b) {\n                if (a) {\n                    ((r && r.H()));\n                    r = a = ((b ? a : (0, _.mk)(s, a)));\n                    a.J(l, 10);\n                    var c = g(h), d = \"/complete/search\";\n                    a.A(c, d);\n                    a.B(k, d);\n                    d = \"/s\";\n                    a.B(k, d);\n                    ((((window.google.ucp || ((!a.M() && !a.Q())))) && a.A(c, d)));\n                }\n            ;\n            ;\n            };\n        ;\n            function g(a) {\n                return function(b, c, d, e, f) {\n                    if (!e) {\n                        ((c && (b = c())));\n                        try {\n                            ((_.y.rf(b) && (b = eval(((((\"(\" + b)) + \")\")))))), a(b, f);\n                        } catch (g) {\n                            b = {\n                                _response: b,\n                                _url: d,\n                                _isPartial: e,\n                                _opt_fromCache: f\n                            };\n                            try {\n                                window.google.ml(g, !1, b);\n                            } catch (h) {\n                            \n                            };\n                        ;\n                        };\n                    ;\n                    }\n                ;\n                ;\n                    return !0;\n                };\n            };\n        ;\n            function h(a, b) {\n                var c = m.dr(a), d = J[c];\n                if (d) {\n                    if (b) {\n                        var e = a[2];\n                        ((e && (e.j = d.getId())));\n                    }\n                ;\n                ;\n                    J[c] = null;\n                }\n            ;\n            ;\n                ((G && G(a)));\n            };\n        ;\n            function k(a) {\n                a = a.substring(((a.indexOf(\"?\") + 1))).split(\"&\");\n                for (var b = [], c = {\n                }, d = 0, e; e = a[d++]; ) {\n                    var f = e.split(\"=\");\n                    ((((2 == f.length)) && (f = f[0], ((((n[f] && !c[f])) && (((((\"q\" == f)) && (e = e.toLowerCase().replace(/\\+/g, \" \")))), b.push(e), c[f] = !0))))));\n                };\n            ;\n                b.sort();\n                return (0, window.decodeURIComponent)(b.join(\"&\"));\n            };\n        ;\n            function l(a, b, c) {\n                ((window.google.msg.send(17, [a,b,c,], !1) && e()));\n            };\n        ;\n            var n = _.y.Ob(\"ac client cp dc ds expIds hl pq pws q se tok xhr\".split(\" \")), p, m, t, s, r, w, G, J, u = {\n                R: function(a) {\n                    var b = _.y.F;\n                    p = a.get(b.Pa, u);\n                    m = a.get(b.yb, u);\n                },\n                ga: function() {\n                    s = (0, _.hj)();\n                },\n                P: function(a) {\n                    J = {\n                    };\n                    ((((2 == a.Hb)) && (t = a, w = p.Sf().Mg, (((a = a.Pj) ? ((((r && ((r.api == a.api)))) || f(a))) : e())))));\n                },\n                I: function() {\n                    return _.y.F.Ab;\n                },\n                N: function() {\n                    return _.y.C.$k;\n                },\n                K: function() {\n                    return {\n                        dd: a,\n                        Dg: _.y.Y,\n                        Mb: b,\n                        Oe: c,\n                        Pe: d\n                    };\n                }\n            };\n            return u;\n        };\n        _.y.C.$k = 19;\n        _.y.O.register(_.y.F.Ab, _.y.C.$k, _.y.Ns);\n        _.y.Jo = function() {\n            function a() {\n                return 2;\n            };\n        ;\n            function b(a) {\n                if (g) {\n                    var b = a.Ba();\n                    if (!((b.length >= m.Zg))) {\n                        var c = a.wb().Sa();\n                        if (b.length) {\n                            for (var d = 0, k; k = b[d]; ++d) {\n                                if (!h[k.I()]) {\n                                    return;\n                                }\n                            ;\n                            ;\n                                k = k.X();\n                                if (!_.y.jc(k, c, !0)) {\n                                    return;\n                                }\n                            ;\n                            ;\n                            };\n                        ;\n                            e(a);\n                        }\n                         else ((((m.Qk || f.test(c))) || e(a)));\n                    ;\n                    ;\n                    }\n                ;\n                ;\n                }\n            ;\n            ;\n            };\n        ;\n            function c(a) {\n                if (g) {\n                    var b, c = a.Sa(), d = Math.min(c.length, n);\n                    if (((d >= l))) {\n                        for (var e; ((0 < d)); --d) {\n                            if (b = k[d]) {\n                                if (e = c.substring(0, d), b = b[e]) {\n                                    c = b;\n                                    d = c.Ba();\n                                    if (d.length) {\n                                        b = a.ha();\n                                        e = b.toLowerCase();\n                                        for (var f = a.Sa(), h = c.U(), t = ((m.qg || !h.Ae(\"k\"))), R = [], Z = void 0, T = void 0, ca = 0, P = 0, S = void 0; S = d[P++]; ) {\n                                            T = S.X(), ((_.y.jc(T, f, !0) && (Z = ((t ? p.bold(e, T) : _.y.escape(T))), R.push(_.y.Bd(Z, T, ca++, S.I(), S.Gc(), S.U())))));\n                                        ;\n                                        };\n                                    ;\n                                        a = _.y.Hd(a, b, R, h, !0, c.Ud(), !1);\n                                    }\n                                     else a = c;\n                                ;\n                                ;\n                                    return a;\n                                }\n                            ;\n                            }\n                        ;\n                        ;\n                        };\n                    }\n                ;\n                ;\n                }\n            ;\n            ;\n                return null;\n            };\n        ;\n            function d() {\n                k = {\n                };\n                l = Number.MAX_VALUE;\n                n = 0;\n            };\n        ;\n            function e(a) {\n                var b = a.wb().Sa(), c = b.length;\n                ((((c < l)) && (l = c)));\n                ((((c > n)) && (n = c)));\n                var d = k[c];\n                ((d || (d = k[c] = {\n                })));\n                d[b] = a;\n            };\n        ;\n            var f = /^[!\"#$%'()*,\\/:;<=>?[\\\\\\]^`{|}~]+$/, g = !0, h, k, l, n, p, m, t = {\n                R: function(a) {\n                    p = a.get(_.y.F.Db, t);\n                },\n                ga: function() {\n                    h = _.y.Ob([C4.Ke,]);\n                    d();\n                },\n                P: function(a) {\n                    m = a;\n                    g = a.mg;\n                },\n                I: function() {\n                    return _.y.F.qc;\n                },\n                N: function() {\n                    return _.y.C.Cf;\n                },\n                K: function() {\n                    return {\n                        Fa: a,\n                        update: b,\n                        get: c,\n                        reset: d\n                    };\n                },\n                xa: function() {\n                    g = !1;\n                }\n            };\n            return t;\n        };\n        _.y.C.Cf = 97;\n        _.y.O.register(_.y.F.qc, _.y.C.Cf, _.y.Jo);\n        _.y.jp = function() {\n            function a() {\n                return 3;\n            };\n        ;\n            function b(a) {\n                if (e) {\n                    var b = a.wb(), c = a.Ba();\n                    if (c.length) {\n                        var d = b.Sa();\n                        n:\n                        for (var b = Number.MAX_VALUE, h, k = 0; h = c[k++]; ) {\n                            if (!f[h.I()]) {\n                                b = -1;\n                                break n;\n                            }\n                        ;\n                        ;\n                            h = h.X();\n                            b = Math.min(h.length, b);\n                        };\n                    ;\n                        if (((-1 != b))) {\n                            var l = c[0].X();\n                            if (_.y.jc(l, d, !0)) {\n                                for (k = ((d.length + 1)); ((k <= b)); ) {\n                                    d = null;\n                                    for (h = 0; l = c[h++]; ) {\n                                        l = l.X();\n                                        if (((k > l.length))) {\n                                            return;\n                                        }\n                                    ;\n                                    ;\n                                        l = l.substr(0, k);\n                                        if (!d) {\n                                            d = l;\n                                        }\n                                         else {\n                                            if (((d != l))) {\n                                                return;\n                                            }\n                                        ;\n                                        }\n                                    ;\n                                    ;\n                                    };\n                                ;\n                                    g[d] = a;\n                                    ++k;\n                                };\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                    }\n                ;\n                ;\n                }\n            ;\n            ;\n            };\n        ;\n            function c(a) {\n                if (e) {\n                    var b = g[a.Sa()];\n                    if (b) {\n                        var c = a.Gi(), d = a.Sa();\n                        b.wb().Sa();\n                        for (var f = b.U(), r = ((k || !f.Ae(\"k\"))), l = [], G, J, u = b.Ba(), E = 0, F; F = u[E++]; ) {\n                            J = F.X(), G = ((r ? h.bold(c, J) : _.y.escape(J))), l.push(_.y.Bd(G, J, F.Ya(), F.I(), F.Gc(), F.U()));\n                        ;\n                        };\n                    ;\n                        delete g[d];\n                        return _.y.Hd(a, a.ha(), l, f, !0, b.Ud(), !1);\n                    }\n                ;\n                ;\n                }\n            ;\n            ;\n                return null;\n            };\n        ;\n            function d() {\n                g = {\n                };\n            };\n        ;\n            var e = !0, f, g = {\n            }, h, k, l = {\n                R: function(a) {\n                    h = a.get(_.y.F.Db, l);\n                },\n                ga: function() {\n                    f = _.y.Ob([C4.Ke,]);\n                },\n                P: function(a) {\n                    k = a.qg;\n                    e = a.ng;\n                },\n                I: function() {\n                    return _.y.F.qc;\n                },\n                N: function() {\n                    return _.y.C.Oh;\n                },\n                K: function() {\n                    return {\n                        Fa: a,\n                        update: b,\n                        get: c,\n                        reset: d\n                    };\n                },\n                xa: function() {\n                    e = !1;\n                }\n            };\n            return l;\n        };\n        _.y.C.Oh = 98;\n        _.y.O.register(_.y.F.qc, _.y.C.Oh, _.y.jp);\n        _.y.Yo = function() {\n            function a() {\n                return _.y.Zo();\n            };\n        ;\n            function b(a, b) {\n                var c = a.U(), d = c.ka(f.Ng), c = c.ka(f.Fj);\n                b.render(d, c);\n            };\n        ;\n            function c(a, b, c) {\n                c.search(b.X(), 1);\n            };\n        ;\n            function d(a, b, c) {\n                c.search(b.X(), 1);\n                return !0;\n            };\n        ;\n            function e() {\n                return 19;\n            };\n        ;\n            var f = {\n                Ng: \"a\",\n                Fj: \"b\"\n            };\n            return {\n                I: function() {\n                    return _.y.F.RENDERER;\n                },\n                N: function() {\n                    return _.y.C.hg;\n                },\n                K: function() {\n                    return {\n                        Tb: a,\n                        render: b,\n                        tb: c,\n                        Vb: d,\n                        Ub: e\n                    };\n                }\n            };\n        };\n        _.y.C.hg = 35;\n        _.y.O.register(_.y.F.RENDERER, _.y.C.hg, _.y.Yo);\n        _.y.Zo = function() {\n            var a;\n            a = _.y.Ka();\n            return {\n                za: function() {\n                    return a;\n                },\n                I: (0, _.ua)(19),\n                hb: (0, _.ua)(!0),\n                render: function(b, c) {\n                    a.innerHTML = [\"\\u003Cb\\u003E\",b,\" = \",c,\"\\u003C/b\\u003E\",].join(\"\");\n                }\n            };\n        };\n        _.y.qy = function() {\n            function a(a) {\n                return _.y.sy(h, a);\n            };\n        ;\n            function b(a, b) {\n                var c = a.U(), d = c.ka(g.ov), e = f(a), c = c.ka(g.Ls);\n                b.render(d, e, k, c);\n            };\n        ;\n            function c(a) {\n                return f(a);\n            };\n        ;\n            function d(a, b, c) {\n                a = f(b);\n                h.uc(a);\n                c.search(a, 1);\n            };\n        ;\n            function e() {\n                return 46;\n            };\n        ;\n            function f(a) {\n                return ((a.U().ka(g.Os) || a.X()));\n            };\n        ;\n            var g = {\n                IA: \"a\",\n                Ls: \"b\",\n                Os: \"c\",\n                ov: \"d\",\n                SA: \"e\",\n                KA: \"f\",\n                kf: \"g\",\n                ex: \"h\"\n            }, h, k, l = {\n                qa: function(a, b) {\n                    b.addRule(\".gsen_a\", \"color:#333\");\n                },\n                R: function(a) {\n                    h = a.get(_.y.F.Z, l);\n                },\n                P: function(a) {\n                    k = ((a.Nd ? a.Ne : \"\"));\n                },\n                I: function() {\n                    return _.y.F.RENDERER;\n                },\n                N: function() {\n                    return _.y.C.Nt;\n                },\n                K: function() {\n                    return {\n                        Tb: a,\n                        render: b,\n                        qd: c,\n                        tb: d,\n                        Vb: _.y.Y,\n                        Ub: e\n                    };\n                }\n            };\n            return l;\n        };\n        _.y.C.Nt = 377;\n        _.y.O.register(_.y.F.RENDERER, _.y.C.Nt, _.y.qy);\n        _.y.sy = function(a, b) {\n            var c, d, e, f, g, h;\n            (function() {\n                c = _.y.Ka();\n                c.className = \"gsen_b\";\n                var a = _.y.Jc();\n                c.appendChild(a);\n                d = a.insertRow(-1);\n                a = d.insertCell(-1);\n                a.style.width = \"100%\";\n                e = _.y.ea(\"span\");\n                a.appendChild(e);\n                f = _.y.ea(\"span\");\n                f.className = \"gsen_a\";\n                a.appendChild(f);\n            })();\n            return {\n                za: function() {\n                    return c;\n                },\n                I: (0, _.ua)(46),\n                hb: (0, _.ua)(!0),\n                render: function(c, l, n, p) {\n                    e.innerHTML = c;\n                    f.innerHTML = ((p ? ((\"&nbsp;&ndash; \" + p)) : \"\"));\n                    h = l;\n                    ((((n && !g)) && (g = _.y.Wg(d), g.JSBNG__onclick = function(c) {\n                        a.Td();\n                        a.uc(h);\n                        b.search(h, 9);\n                        return _.y.Sb(c);\n                    })));\n                    ((n ? (g.innerHTML = ((n + \" &raquo;\")), g.style.display = \"\") : ((g && (g.style.display = \"none\")))));\n                }\n            };\n        };\n        _.y.Yp = function() {\n            function a(a) {\n                return _.y.Zp(a);\n            };\n        ;\n            function b(a, b) {\n                var c = a.U(), d = c.ka(h.aj), c = c.ka(h.om), e = a.Nb(), f = e.replace(/HTTPS?:\\/\\//gi, \"\"), e = _.y.sj(e);\n                ((/^HTTPS?:\\/\\//i.test(e) || (e = ((((((((0 < d.indexOf(\"/url?url=https:\"))) ? \"https\" : \"http\")) + \"://\")) + e)))));\n                b.render(c, f, e, d);\n            };\n        ;\n            function c(a, b) {\n                return b;\n            };\n        ;\n            function d(a, b, c) {\n                return g(a, b, c);\n            };\n        ;\n            function e(a, b, c) {\n                g(a, b, c);\n                return !0;\n            };\n        ;\n            function f() {\n                return 5;\n            };\n        ;\n            function g(a, b, c) {\n                b = b.U().ka(h.aj);\n                c.ic(b);\n                return _.y.Sb(a);\n            };\n        ;\n            var h = {\n                aj: \"a\",\n                om: \"b\"\n            };\n            return {\n                qa: function(a, b) {\n                    b.addRule(\".gsn_a\", \"padding-top:4px;padding-bottom:1px\");\n                    b.addRule(\".gsn_b\", \"display:block;line-height:16px\");\n                    b.addRule(\".gsn_c\", \"color:green;font-size:13px\");\n                },\n                I: function() {\n                    return _.y.F.RENDERER;\n                },\n                N: function() {\n                    return _.y.C.Wj;\n                },\n                K: function() {\n                    return {\n                        Tb: a,\n                        render: b,\n                        qd: c,\n                        tb: d,\n                        Vb: e,\n                        Ub: f\n                    };\n                }\n            };\n        };\n        _.y.C.Wj = 32;\n        _.y.O.register(_.y.F.RENDERER, _.y.C.Wj, _.y.Yp);\n        _.y.Zp = function(a) {\n            function b(a) {\n                return ((l ? (_.y.Sb(a), !0) : !1));\n            };\n        ;\n            function c(b) {\n                b = ((b || window.JSBNG__event));\n                l = !1;\n                ((b.which ? l = ((2 == b.which)) : ((b.button && (l = ((4 == b.button)))))));\n                f.href = a.vd(k);\n            };\n        ;\n            function d(a, b) {\n                var c = _.y.ea(\"span\");\n                c.className = a;\n                b.appendChild(c);\n                return c;\n            };\n        ;\n            var e, f, g, h, k, l;\n            (function() {\n                e = _.y.Ka();\n                e.className = \"gsn_a\";\n                e.style.lineHeight = \"117%\";\n                var a = d(\"gsn_b\", e);\n                f = _.y.ea(\"a\");\n                a.appendChild(f);\n                g = _.y.ea(\"br\");\n                a.appendChild(g);\n                h = d(\"gsn_c\", a);\n            })();\n            return {\n                za: function() {\n                    return e;\n                },\n                I: (0, _.ua)(5),\n                hb: (0, _.ua)(!0),\n                render: function(a, d, e, l) {\n                    f.innerHTML = a;\n                    f.JSBNG__onmousedown = c;\n                    f.JSBNG__onclick = b;\n                    f.href = e;\n                    ((a ? (f.style.display = \"\", g.style.display = \"\") : (f.style.display = \"none\", g.style.display = \"none\")));\n                    h.innerHTML = d;\n                    k = l;\n                }\n            };\n        };\n        _.y.Oy = function() {\n            function a(a) {\n                return _.y.Py(a);\n            };\n        ;\n            function b(a, b) {\n                var c = a.U(), d = xTa, k = c.ka(d.Hk), c = c.ka(d.Mt), d = a.X();\n                b.render(k, c, d);\n            };\n        ;\n            function c(a, b, c) {\n                c.search(b.X(), 1);\n            };\n        ;\n            function d() {\n                return 33;\n            };\n        ;\n            return {\n                qa: function(a, b) {\n                    b.addRule(\".gspr_a\", \"padding-right:1px\");\n                },\n                I: function() {\n                    return _.y.F.RENDERER;\n                },\n                N: function() {\n                    return _.y.C.Wt;\n                },\n                K: function() {\n                    return {\n                        Tb: a,\n                        render: b,\n                        tb: c,\n                        Vb: _.y.Y,\n                        Ub: d\n                    };\n                }\n            };\n        };\n        _.y.C.Wt = 31;\n        _.y.O.register(_.y.F.RENDERER, _.y.C.Wt, _.y.Oy);\n        _.y.Py = function() {\n            var a;\n            a = _.y.Ka();\n            a.className = \"gspr_a\";\n            return {\n                I: (0, _.ua)(33),\n                za: function() {\n                    return a;\n                },\n                hb: (0, _.ua)(!0),\n                render: function(b, c) {\n                    a.innerHTML = c;\n                }\n            };\n        };\n        _.y.Vv = function() {\n            function a(a) {\n                return _.y.Wv(e, a);\n            };\n        ;\n            function b(a, b) {\n                b.render(a.Nb(), a.X(), f);\n            };\n        ;\n            function c(a, b, c) {\n                c.search(b.X(), 1);\n            };\n        ;\n            function d() {\n                return 0;\n            };\n        ;\n            var e, f, g = {\n                qa: function(a, b) {\n                    b.addRule(\".gsq_a\", \"padding:0\");\n                },\n                R: function(a) {\n                    e = a.get(_.y.F.Z, g);\n                },\n                P: function(a) {\n                    f = ((a.Nd ? a.Ne : \"\"));\n                },\n                I: function() {\n                    return _.y.F.RENDERER;\n                },\n                N: function() {\n                    return _.y.C.Zt;\n                },\n                K: function() {\n                    return {\n                        Tb: a,\n                        render: b,\n                        tb: c,\n                        Vb: _.y.Y,\n                        Ub: d\n                    };\n                }\n            };\n            return g;\n        };\n        _.y.C.Zt = 20;\n        _.y.O.register(_.y.F.RENDERER, _.y.C.Zt, _.y.Vv);\n        _.y.Wv = function(a, b) {\n            var c, d, e, f, g;\n            (function() {\n                c = _.y.Ka();\n                c.className = \"gsq_a\";\n                var a = _.y.Jc();\n                c.appendChild(a);\n                d = a.insertRow(-1);\n                a = d.insertCell(-1);\n                a.style.width = \"100%\";\n                e = _.y.ea(\"span\");\n                a.appendChild(e);\n            })();\n            return {\n                za: function() {\n                    return c;\n                },\n                I: (0, _.ua)(0),\n                hb: (0, _.ua)(!0),\n                render: function(c, k, l) {\n                    e.innerHTML = c;\n                    g = k;\n                    ((((l && !f)) && (f = _.y.Wg(d), f.JSBNG__onclick = function(c) {\n                        a.Td();\n                        a.uc(g);\n                        b.search(g, 9);\n                        return _.y.Sb(c);\n                    })));\n                    ((l ? (f.innerHTML = ((l + \" &raquo;\")), f.style.display = \"\") : ((f && (f.style.display = \"none\")))));\n                }\n            };\n        };\n        _.y.TA = function() {\n            function a() {\n                return r;\n            };\n        ;\n            function b() {\n                return _.y.C.Ts;\n            };\n        ;\n            function c() {\n                return 2;\n            };\n        ;\n            function d() {\n                return E;\n            };\n        ;\n            function e() {\n                return {\n                    Kv: s\n                };\n            };\n        ;\n            function f(a) {\n                if (!R) {\n                    a = window.JSBNG__document.createElement(\"script\"), a.src = [\"//www.google.com/textinputassistant/\",u,\"/\",J,\"_tia.js\",].join(\"\"), window.JSBNG__document.body.appendChild(a), R = !0, p.add(3);\n                }\n                 else {\n                    if (w.JSBNG__onclick) {\n                        w.JSBNG__onclick(a);\n                    }\n                ;\n                }\n            ;\n            ;\n            };\n        ;\n            function g() {\n                m.Kd();\n            };\n        ;\n            function h() {\n                t.BB();\n            };\n        ;\n            function k(a) {\n                t.aC(b(), a);\n            };\n        ;\n            function l(a) {\n                t.cC(b(), a);\n            };\n        ;\n            function n(a) {\n                E.className = ((\"gsok_a gsst_e \" + a));\n            };\n        ;\n            var p, m, t, s, r, w, G, J, u, E, F, R, Z = {\n                qa: function(a, b) {\n                    F = a;\n                    ((a.ue() || (b.addRule(\".gsok_a\", \"background:url(data:image/gif;base64,R0lGODlhEwALAKECAAAAABISEv///////yH5BAEKAAIALAAAAAATAAsAAAIdDI6pZ+suQJyy0ocV3bbm33EcCArmiUYk1qxAUAAAOw==) no-repeat center;display:inline-block;height:11px;line-height:0;width:19px\"), b.addRule(\".gsok_a img\", \"border:none;visibility:hidden\"))));\n                },\n                R: function(a) {\n                    var b = _.y.F;\n                    p = a.get(b.Ja, Z);\n                    m = a.get(b.ra, Z);\n                    t = a.get(b.Sd, Z);\n                },\n                ga: function(a) {\n                    r = !!a.mi;\n                    G = a.Mr;\n                    J = a.Kg;\n                    u = a.Pr;\n                    s = a.Or;\n                    (((E = F.get(\"gs_ok\")) ? w = E.firstChild : (w = _.y.ea(\"img\"), w.src = ((G + \"/tia.png\")), E = _.y.ea(\"span\", \"gsok_a gsst_e\"), E.id = F.getId(\"gs_ok\"), E.appendChild(w))));\n                    w.ds = g;\n                    w.hd = h;\n                    w.sc = n;\n                    w.sd = k;\n                    w.td = l;\n                    w.setAttribute(\"tia_field_name\", F.je().JSBNG__name);\n                    w.setAttribute(\"tia_disable_swap\", !0);\n                },\n                P: function(a) {\n                    ((a.Tg && (r = !!a.mi)));\n                    w.setAttribute(\"tia_property\", a.Nr);\n                },\n                I: function() {\n                    return _.y.F.Vc;\n                },\n                N: function() {\n                    return _.y.C.Ts;\n                },\n                K: function() {\n                    return {\n                        isEnabled: a,\n                        Fr: b,\n                        Fa: c,\n                        za: d,\n                        Dr: e,\n                        tb: f\n                    };\n                }\n            };\n            return Z;\n        };\n        _.y.C.Ts = 78;\n        _.y.O.register(_.y.F.Vc, _.y.C.Ts, _.y.TA);\n        _.y.YA = function() {\n            function a() {\n                return g;\n            };\n        ;\n            function b() {\n                return _.y.C.Xs;\n            };\n        ;\n            function c() {\n                return 3;\n            };\n        ;\n            function d() {\n                return h;\n            };\n        ;\n            function e() {\n                return {\n                    Kv: l\n                };\n            };\n        ;\n            function f() {\n                window.google.load(\"qi\", function() {\n                    window.google.qb.tp();\n                });\n            };\n        ;\n            var g, h, k, l;\n            return {\n                qa: function(a, b) {\n                    k = a;\n                    ((a.ue() || b.addRule(\"#qbi.gssi_a\", \"background:url(data:image/gif;base64,R0lGODlhEgANAOMKAAAAABUVFRoaGisrKzk5OUxMTGRkZLS0tM/Pz9/f3////////////////////////yH5BAEKAA8ALAAAAAASAA0AAART8Ml5Arg3nMkluQIhXMRUYNiwSceAnYAwAkOCGISBJC4mSKMDwpJBHFC/h+xhQAEMSuSo9EFRnSCmEzrDComAgBGbsuF0PHJq9WipnYJB9/UmFyIAOw==) no-repeat center;cursor:pointer;display:inline-block;height:13px;padding:0;width:18px\")));\n                },\n                ga: function(a) {\n                    g = !!a.ln;\n                    l = a.Sr;\n                    h = k.get(\"gs_si\");\n                    ((h || (h = _.y.ea(\"span\"), h.id = k.getId(\"gs_si\"), a = _.y.ea(\"span\", \"gssi_a gsst_e\"), a.id = \"qbi\", h.appendChild(a))));\n                },\n                P: function(a) {\n                    ((a.Tg && (g = !!a.ln)));\n                },\n                I: function() {\n                    return _.y.F.Vc;\n                },\n                N: function() {\n                    return _.y.C.Xs;\n                },\n                K: function() {\n                    return {\n                        isEnabled: a,\n                        Fr: b,\n                        Fa: c,\n                        za: d,\n                        Dr: e,\n                        tb: f\n                    };\n                }\n            };\n        };\n        _.y.C.Xs = 79;\n        _.y.O.register(_.y.F.Vc, _.y.C.Xs, _.y.YA);\n        _.y.ZA = function() {\n            function a() {\n                return _.y.C.Zs;\n            };\n        ;\n            function b(a) {\n                ((((V != a)) && (ca.dir = V = a, f())));\n            };\n        ;\n            function c() {\n                return ca;\n            };\n        ;\n            function d(a) {\n                (((((a = S[a]) && a.style)) && (a.style.display = \"\")));\n            };\n        ;\n            function e(a) {\n                (((((a = S[a]) && a.style)) && (a.style.display = \"none\")));\n            };\n        ;\n            function f() {\n                (($ && (S[$].className = \"gsst_a\", u.hide(), $ = null)));\n            };\n        ;\n            function g(a, b) {\n                $ = a;\n                var c = S[a];\n                c.className = \"gsst_a gsst_g\";\n                var d = X.lastChild;\n                ((((d != b)) && ((((d == W)) ? X.appendChild(b) : X.replaceChild(b, d)))));\n                u.setPanel(m());\n                u.show();\n                c = c.clientWidth;\n                W.style.width = ((c + \"px\"));\n                W.style.left = ((((\"rtl\" == V)) ? \"0\" : ((((X.clientWidth - c)) + \"px\"))));\n            };\n        ;\n            function h(a, b) {\n                (((($ == a)) ? f() : g(a, b)));\n            };\n        ;\n            function k(a) {\n                var b = oTa;\n                a.lh = ((((\"rtl\" == V)) ? b.Ng : b.Fj));\n                a.yk = !1;\n            };\n        ;\n            function l() {\n                return X;\n            };\n        ;\n            function n() {\n                return ((((T.Pl || ((ja == V)))) ? ia : null));\n            };\n        ;\n            function p() {\n                f();\n            };\n        ;\n            function m() {\n                return _.y.C.Zs;\n            };\n        ;\n            function t(a, b) {\n                return ((b.Fa() - a.Fa()));\n            };\n        ;\n            function s() {\n                ((((ga != $)) && f()));\n            };\n        ;\n            function r() {\n                for (var a, b = 0, c; c = R[b++]; ) {\n                    if (c.isEnabled()) {\n                        a = !0;\n                        var d = _.y.ea(\"a\", \"gsst_a\");\n                        J(d, c);\n                        d.appendChild(c.za());\n                        ca.appendChild(d);\n                    }\n                ;\n                ;\n                };\n            ;\n                ca.style.display = ((a ? \"\" : \"none\"));\n            };\n        ;\n            function w() {\n                ga = null;\n            };\n        ;\n            function G() {\n                S = {\n                };\n                for (var a = 0, b; b = R[a++]; ) {\n                    if (b.isEnabled()) {\n                        var c = b.Fr(), d = b.za().parentNode;\n                        d.JSBNG__onclick = b.tb;\n                        d.JSBNG__onmouseover = function() {\n                            ga = c;\n                        };\n                        d.JSBNG__onmouseout = w;\n                        S[c] = d;\n                        ((b.Dr && (b = b.Dr(), ((b.AH && e(c))), (((((b = b.Kv) && !Z.Ce(d, b))) && (d.title = b))))));\n                    }\n                ;\n                ;\n                };\n            ;\n            };\n        ;\n            function J(a, b) {\n                a.href = \"javascript:void(0)\";\n                _.y.Ur(a);\n                a.JSBNG__onkeydown = function(a) {\n                    a = ((a || window.JSBNG__event));\n                    var c = a.keyCode;\n                    if (((((13 == c)) || ((32 == c))))) {\n                        b.tb(a), F.pg(), _.y.Sb(a);\n                    }\n                ;\n                ;\n                };\n            };\n        ;\n            var u, E, F, R, Z, T, ca, P, S = {\n            }, $, X, W, ga, ja, V, ia, ha, da = {\n                qa: function(a, b) {\n                    P = a;\n                    ja = a.ud();\n                    ((a.ue() || (b.addRule(\".gsst_a\", \"display:inline-block\"), b.addRule(\".gsst_a\", \"cursor:pointer;padding:0 4px\"), b.addRule(\".gsst_a:hover\", \"text-decoration:none!important\"), b.addRule(\".gsst_b\", [\"font-size:16px;padding:0 2px;position:relative;\",b.prefix(\"user-select:none;\"),\"white-space:nowrap\",].join(\"\")), b.addRule(\".gsst_e\", _.y.Um(210660)), b.addRule(\".gsst_a:hover .gsst_e,.gsst_a:focus .gsst_e\", _.y.Um(210730)), b.addRule(\".gsst_a:active .gsst_e\", _.y.Um(1)), b.addRule(\".gsst_f\", \"background:white;text-align:left\"), b.addRule(\".gsst_g\", [\"background-color:white;border:1px solid #ccc;border-top-color:#d9d9d9;\",b.prefix(\"box-shadow:0 2px 4px rgba(0,0,0,0.2);\"),\"margin:-1px -3px;padding:0 6px\",].join(\"\")), b.addRule(\".gsst_h\", \"background-color:white;height:1px;margin-bottom:-1px;position:relative;top:-1px\"))));\n                },\n                R: function(a) {\n                    u = a.get(_.y.F.Ua, da);\n                    E = a.get(_.y.F.wa, da);\n                    F = a.get(_.y.F.Z, da);\n                    R = a.Ia(_.y.F.Vc, da);\n                    Z = a.Zb();\n                },\n                ga: function(a) {\n                    ha = a.Tg;\n                    R.sort(t);\n                    ca = P.get(\"gs_st\");\n                    if (!ca) {\n                        ca = _.y.Ka(\"gsst_b\");\n                        ca.id = P.getId(\"gs_st\");\n                        if (a = a.Ug) {\n                            ca.style.lineHeight = ((a + \"px\"));\n                        }\n                    ;\n                    ;\n                        r();\n                    }\n                ;\n                ;\n                    G();\n                },\n                P: function(a) {\n                    T = a;\n                    (((a = a.uf) && (ia = P.Fc(a))));\n                    if (ha) {\n                        a = 0;\n                        for (var b; b = R[a++]; ) {\n                            var c = !!S[b.Fr()];\n                            if (((b.isEnabled() != c))) {\n                                for (; ca.hasChildNodes(); ) {\n                                    ca.removeChild(ca.lastChild);\n                                ;\n                                };\n                            ;\n                                r();\n                                G();\n                                break;\n                            }\n                        ;\n                        ;\n                        };\n                    ;\n                    }\n                ;\n                ;\n                    W = _.y.Ka(\"gsst_h\");\n                    X = _.y.Ka(\"gsst_f\");\n                    X.dir = \"ltr\";\n                    X.appendChild(W);\n                    E.fc(13, s);\n                },\n                I: function() {\n                    return _.y.F.Sd;\n                },\n                N: a,\n                K: function() {\n                    return {\n                        Kc: b,\n                        za: c,\n                        pI: d,\n                        qH: e,\n                        BB: f,\n                        aC: g,\n                        cC: h\n                    };\n                },\n                Gd: function() {\n                    var b = {\n                        ok: k,\n                        za: l,\n                        qf: n,\n                        wk: p,\n                        $b: _.y.Y,\n                        kh: m\n                    };\n                    return [{\n                        qa: _.y.Y,\n                        R: _.y.Y,\n                        ga: _.y.Y,\n                        P: _.y.Y,\n                        I: function() {\n                            return _.y.F.jf;\n                        },\n                        N: a,\n                        K: function() {\n                            return b;\n                        },\n                        Gd: _.y.Y,\n                        xa: _.y.Y\n                    },];\n                }\n            };\n            return da;\n        };\n        _.y.C.Zs = 174;\n        _.y.O.register(_.y.F.Sd, _.y.C.Zs, _.y.ZA);\n        _.y.Ep = function() {\n            function a() {\n                var a = window.JSBNG__document.getElementById(\"gbqf\");\n                return ((((a && ((\"FORM\" == a.tagName)))) ? a : null));\n            };\n        ;\n            function b(a, b, c) {\n                var d = a[b], e = ((d && d.parentNode));\n                ((((null === c)) ? ((e && e.removeChild(d))) : (((e || (e = ((((window.JSBNG__document.getElementById(\"gbqffd\") || window.JSBNG__document.getElementById(\"tophf\"))) || a)), d = window.JSBNG__document.createElement(\"input\"), d.type = \"hidden\", d.JSBNG__name = b, e.appendChild(d)))), d.value = c)));\n            };\n        ;\n            var c = {\n                webhp: 1,\n                imghp: 1,\n                mobilewebhp: 1\n            }, d, e = {\n            };\n            _.y.Ml = function() {\n                var b = a();\n                if (b) {\n                    return b;\n                }\n            ;\n            ;\n                for (var c = [\"f\",\"gs\",], d = 0; b = c[d++]; ) {\n                    if (b = window.JSBNG__document.getElementsByName(b)[0]) {\n                        return b;\n                    }\n                ;\n                ;\n                };\n            ;\n                return null;\n            };\n            _.y.Mq = function() {\n                return !!a();\n            };\n            _.y.Rq = function(a, b) {\n                window.google.register(\"sb\", {\n                    init: a,\n                    dispose: b\n                });\n            };\n            _.y.ik = function() {\n                return !((window.google.sn in c));\n            };\n            _.y.Lc = function() {\n                if (!d) {\n                    var a = window.google.browser.engine, b = window.google.browser.product;\n                    d = {\n                    };\n                    d[D4.IE] = a.IE;\n                    d[D4.GECKO] = a.GECKO;\n                    d[D4.OPERA] = b.OPERA;\n                    d[D4.WEBKIT] = a.WEBKIT;\n                    d[D4.SAFARI] = b.SAFARI;\n                    d[D4.CHROME] = b.CHROME;\n                    d[D4.cj] = ((((b.IPAD || b.IPOD)) || b.IPHONE));\n                    d[D4.$i] = ((b.ANDROID_MOBILE || b.ANDROID_TABLET));\n                }\n            ;\n            ;\n                return d;\n            };\n            _.y.ff = function(a, c) {\n                {\n                    var fin58keys = ((window.top.JSBNG_Replay.forInKeys)((e))), fin58i = (0);\n                    var d;\n                    for (; (fin58i < fin58keys.length); (fin58i++)) {\n                        ((d) = (fin58keys[fin58i]));\n                        {\n                            ((((d in c)) || (b(a, d, e[d]), delete e[d])));\n                        ;\n                        };\n                    };\n                };\n            ;\n                {\n                    var fin59keys = ((window.top.JSBNG_Replay.forInKeys)((c))), fin59i = (0);\n                    (0);\n                    for (; (fin59i < fin59keys.length); (fin59i++)) {\n                        ((d) = (fin59keys[fin59i]));\n                        {\n                            if (!((d in e))) {\n                                var k = a[d];\n                                e[d] = ((((k && k.parentNode)) ? k.value : null));\n                            }\n                        ;\n                        ;\n                            b(a, d, c[d]);\n                        };\n                    };\n                };\n            ;\n            };\n            _.y.Hl = function(a, c) {\n                b(a, c, null);\n            };\n            _.y.gr = function() {\n                e = {\n                };\n            };\n        };\n        _.y.Ep();\n        _.y.bp = function() {\n            function a(a, c, d, e) {\n                ((((((a && c)) && (a = a[d]))) && c.Pi(((a[0] || a)), e)));\n            };\n        ;\n            _.y.Pi = a;\n            _.y.Dq = function(b, c) {\n                a(b, c, \"btnG\", 12);\n                a(b, c, \"btnK\", 12);\n                a(b, c, \"btnI\", 7);\n            };\n            _.y.Fc = function(a) {\n                return window.JSBNG__document.getElementById(a);\n            };\n            _.y.Iv = function(a) {\n                var c = window.gbar;\n                (((c = ((c && c.elc))) && c(function() {\n                    window.JSBNG__setTimeout(a.Xk, 0);\n                })));\n            };\n        };\n        _.y.bp();\n        _.y.Mk = function() {\n            function a(a) {\n                return {\n                    api: a,\n                    Ef: a.a,\n                    P: a.b,\n                    xa: a.c,\n                    wx: a.d,\n                    Le: a.e,\n                    Va: a.f,\n                    Ha: a.g,\n                    Fb: a.h,\n                    Pc: a.i,\n                    Ti: a.j,\n                    Ge: a.k,\n                    ju: a.l,\n                    Ax: a.m,\n                    Pi: a.n,\n                    Mb: a.o,\n                    yv: a.p,\n                    rg: a.q,\n                    Vu: a.r,\n                    St: a.s,\n                    Vd: a.t,\n                    Kh: a.u,\n                    JSBNG__focus: a.v,\n                    JSBNG__blur: a.w,\n                    Ih: a.x,\n                    Eb: a.y,\n                    yc: a.z,\n                    Jh: a.aa,\n                    xc: a.ab,\n                    search: a.ad,\n                    Hv: a.ae,\n                    Jv: a.af,\n                    $d: a.ag,\n                    Oc: a.ah,\n                    Xk: a.ai,\n                    uh: a.al,\n                    isActive: a.am,\n                    qh: a.an,\n                    Rb: a.ao,\n                    wf: a.ap,\n                    Hh: a.aq,\n                    zd: a.ar,\n                    getId: a.as,\n                    xv: a.at,\n                    setSuggestions: a.au,\n                    jv: a.av,\n                    $c: a.aw,\n                    Lh: a.ax,\n                    oe: a.ay,\n                    wl: a.az,\n                    ke: a.ba,\n                    Nw: a.bb,\n                    uk: a.bc,\n                    qi: a.bd,\n                    Cr: a.be,\n                    qk: a.bf\n                };\n            };\n        ;\n            return {\n                G: function(b, c, d, e) {\n                    try {\n                        var f = window.google.sbox(b, c, d, e);\n                        return a(f);\n                    } catch (g) {\n                        return null;\n                    };\n                ;\n                },\n                translate: function(b) {\n                    return a(((b.api || b)));\n                }\n            };\n        };\n        _.y.sq = function() {\n            var a = _.y.C, b = _.y.F, c = C4, d, e = \"hp\", f, g, h, k, l = {\n                Fn: function() {\n                    var a = d.dg(), b = a.msgs;\n                    e = a.client;\n                    a = !!a.sbih;\n                    f = ((!!b.sbi || a));\n                },\n                P: function(c) {\n                    var e = d.dg(), g = d.xo(), l = d.zk(), s = 0;\n                    ((_.y.Mq() && (s = 1)));\n                    c.We = [s,0,0,];\n                    c.Gg = !g;\n                    ((f && (c.Cs = !0)));\n                    ((((\"i\" == d.zs())) ? (c.Gg = !1, c.Uf = !1) : ((_.y.ik() && (c.Gg = !1)))));\n                    ((f && (g = e.msgs.sbih, h.wF(e.sbiu, e.sbiw, e.sbih, e.msgs.sbi, g), ((g && (c.hk = g))))));\n                    c.Ra[b.gb] = ((l || f));\n                    ((c.Ra[b.gb] && (c.Ra[a.bq] = !0)));\n                    e = ((c.hk != k));\n                    k = c.hk;\n                    c.Rk[a.eq] = l;\n                    c.Rk[a.Mw] = f;\n                    return e;\n                },\n                Ao: function() {\n                    ((f && d.io().yc(d.dg().sbiq)));\n                },\n                Ef: function() {\n                    var a = d.io();\n                    ((((((\"webhp\" != window.google.sn)) && ((\"imghp\" != window.google.sn)))) || a.JSBNG__focus()));\n                    ((f && a.yc(d.dg().sbiq)));\n                    _.y.Iv(a);\n                },\n                Rc: function(a, b) {\n                    ((_.y.Mq() && (a.addRule(\".gssb_a\", \"padding:0 10px\"), a.addRule(\".gssb_c\", \"z-index:986\"), ((b || a.addRule(\".gsib_a\", ((((\"padding:\" + ((((((_.y.zh && _.y.Jd)) || ((_.y.ub && !_.y.Zk)))) ? 6 : 5)))) + \"px 9px 0\"))))))));\n                },\n                gk: function(a) {\n                    var b = d.zk(), f = d.dg();\n                    a.Fe = e;\n                    a.Xe = ((b ? \"psy-ab\" : e));\n                    a.Vi = !1;\n                    a.Nd = ((b && f.fl));\n                    a.Rf = a.Nd;\n                    a.vf = \"lst-t\";\n                    a.hk = f.hint;\n                    a.Ol = !0;\n                    a.Uf = !!f.lm;\n                    a.Jg = !!f.spch;\n                    a.Tg = !0;\n                    ((_.y.Mq() ? (a.Xc = \"gbqfif\", a.Bf = \"gbqfsf\", a.uf = \"gbqfqw\", a.xs = \"gbqfqw\") : (a.Xc = \"gsfi\", a.Bf = \"gsfs\", a.uf = \"sftab\")));\n                    a.nb[c.Cl] = !0;\n                    a.nb[c.il] = !0;\n                    if (((((\"hp\" == e)) || ((\"serp\" == e))))) {\n                        a.nb[c.Di] = !0;\n                    }\n                ;\n                ;\n                    ((d.xo() && (a.nb[c.Lk] = !0)));\n                    ((b && (a.Hg = !1, a.Lj = 2)));\n                    ((((\"token\" in f)) && (a.nb[c.Ah] = !0)));\n                    b = f.msgs;\n                    a.Sl = b.srch;\n                    a.Ne = b.lcky;\n                    a.xl = b.lml;\n                    a.yl = b.psrl;\n                    a.Wk = b.psrc;\n                    a.Or = b.oskt;\n                    a.Sr = b.sbit;\n                    if (b = f.kbl) {\n                        a.mi = !0, a.Kg = b, a.Mr = \"//www.gstatic.com/inputtools/images\", a.Nr = ((((\"i\" == d.zs())) ? \"images\" : \"web\")), ((((\"kbv\" in f)) && (a.Pr = f.kbv)));\n                    }\n                ;\n                ;\n                },\n                fk: function(b, e) {\n                    if (((\"ms\" in b))) {\n                        var f = b.ms;\n                        e.Ra[a.uj] = f;\n                        e.nb[c.Ik] = f;\n                    }\n                ;\n                ;\n                    ((((\"qe\" in b)) && (e.ln = b.qe)));\n                    ((((((\"qn\" in b)) && d.zk())) && (f = !!b.qn, e.Ra[a.Jz] = f, (((e.Ra[a.by] = f) && (e.nb[c.bm] = !0))))));\n                    ((((\"q\" in b)) && (e.Cs = b.q)));\n                    ((((\"tds\" in b)) && (e.du = b.tds)));\n                },\n                ek: function(a, c) {\n                    ((g || (g = _.y.Uv())));\n                    ((h || (h = _.y.GD())));\n                    c[b.De] = [g.Uu(),h.Uu(),];\n                    ((a.Jg && _.y.OD(c)));\n                },\n                Nl: function() {\n                    var a = {\n                    }, b = ((g && g.sB()));\n                    ((b && (a.tbs = b, a.dq = \"\")));\n                    return a;\n                },\n                Ce: function(a, b) {\n                    if (a) {\n                        return new _.Sq(a, b), !0;\n                    }\n                ;\n                ;\n                }\n            };\n            (function() {\n                d = _.y.Qa(l);\n                d.Ot(64, function() {\n                    d.io().Xk();\n                }, 50);\n            })();\n            return l;\n        };\n        _.y.sq();\n        _.y.rq = function(a, b, c, d) {\n            function e() {\n                F.xa();\n            };\n        ;\n            function f(a) {\n                S.yc(((a || \"\")));\n            };\n        ;\n            function g() {\n                return fa;\n            };\n        ;\n            function h() {\n                return Y;\n            };\n        ;\n            function k() {\n                return S.Ha();\n            };\n        ;\n            function l() {\n                return ha.Oc();\n            };\n        ;\n            function n() {\n                ca.Aa(8);\n            };\n        ;\n            function p(a) {\n                return W.U(a);\n            };\n        ;\n            function m() {\n                return ((L || ((!!Z && Z.Rb()))));\n            };\n        ;\n            function t() {\n                return X.Qm();\n            };\n        ;\n            function s() {\n                if (a) {\n                    for (var b = a; b = b.parentNode; ) {\n                        var c = b.dir;\n                        if (c) {\n                            return c;\n                        }\n                    ;\n                    ;\n                    };\n                }\n            ;\n            ;\n                return \"ltr\";\n            };\n        ;\n            function r(a) {\n                a = _.y.fj(a);\n                ((a.nb[35] || (a.zf = \"\")));\n                var b = a.Kg;\n                ((b ? a.Kg = b.toLowerCase() : a.mi = !1));\n                ((((a.Rf && !a.Nd)) && (a.Rf = !1)));\n                ((_.y.Yk || (a.Jg = !1)));\n                return a;\n            };\n        ;\n            function w(a, b) {\n                var c = b.exec(a);\n                return ((((c && c[1])) ? (((0, window.parseInt)(c[1], 10) || 0)) : 0));\n            };\n        ;\n            function G() {\n                var b = _.y.getWindow(a), c = _.y.jj(b);\n                ca.listen(b, \"resize\", function() {\n                    var a = _.y.jj(b);\n                    if (((((a.Je != c.Je)) || ((a.Be != c.Be))))) {\n                        c = a, n();\n                    }\n                ;\n                ;\n                });\n            };\n        ;\n            function J(a) {\n                var b = _.y.F, c = a.Ra, d = c[b.vb], e = c[b.Xb], f = c[b.lg], g = c[b.Sc], h = c[b.Ea], f = ((((e || g)) || f));\n                ((((((((c[b.Ta] || h)) || d)) || f)) ? (a.Ra[b.Ta] = !0, a.Ra[b.Bb] = !0, ((f ? (a = _.y.kj(a.Od), ((((((!e || ((_.y.dc && ((_.y.zh || a)))))) || ((_.y.ub && a)))) ? (fa = 3, c[b.Xb] = !1, c[b.kg] = !1) : fa = 2))) : fa = 1))) : fa = 0));\n            };\n        ;\n            var u = {\n                Ad: \"gs_l\",\n                kf: \"gs_ssp\",\n                Yl: \"oq\"\n            }, E, F, R, Z, T, ca, P, S, $, X, W, ga, ja, V, ia, ha, da, na, Y, fa, wa = !1, L, ya = {\n                a: function(c) {\n                    if (!wa) {\n                        c = r(c);\n                        var d = _.y.Ll(a), e = s(), f = !!d.getElementById(((\"gs_id\" + Y))), g = [\"gssb_c\",\"gssb_k\",];\n                        ((c.vf && g.push(c.vf)));\n                        g = _.y.kp(c.On, c.mn, c.Il, Y, g);\n                        J(c);\n                        L = c.Rb;\n                        F = _.y.ep(E, ((c.Fh || {\n                        })), {\n                            ue: function() {\n                                return f;\n                            },\n                            get: function(a) {\n                                return d.getElementById(((a + Y)));\n                            },\n                            Fc: function(a) {\n                                return d.getElementById(a);\n                            },\n                            Qg: function() {\n                                return b;\n                            },\n                            ud: function() {\n                                return e;\n                            },\n                            getId: function(a) {\n                                return ((a + Y));\n                            },\n                            je: function() {\n                                return a;\n                            }\n                        }, g, ya, c);\n                        c = _.y.F;\n                        R = F.get(c.Mh, ya);\n                        Z = F.get(c.gb, ya);\n                        T = F.get(c.Ua, ya);\n                        ca = F.get(c.wa, ya);\n                        P = F.get(c.Ca, ya);\n                        S = F.get(c.Z, ya);\n                        $ = F.get(c.ob, ya);\n                        X = F.get(c.Ja, ya);\n                        W = F.get(c.$a, ya);\n                        ga = F.get(c.Qb, ya);\n                        ja = F.get(c.dm, ya);\n                        V = F.get(c.Og, ya);\n                        ia = F.get(c.Ga, ya);\n                        ha = F.get(c.ra, ya);\n                        da = F.get(c.Ea, ya);\n                        na = F.get(c.Xa, ya);\n                        G();\n                        wa = !0;\n                    }\n                ;\n                ;\n                },\n                b: function(a) {\n                    e();\n                    a = r(a);\n                    J(a);\n                    L = a.Rb;\n                    F.P(a);\n                },\n                c: e,\n                d: function() {\n                    return b;\n                },\n                e: function(a, b) {\n                    return _.y.Le(a, b);\n                },\n                f: function() {\n                    return S.Va();\n                },\n                g: k,\n                h: function() {\n                    return ha.Fb();\n                },\n                i: function() {\n                    return ha.Pc();\n                },\n                j: p,\n                k: function(a, b) {\n                    ((a || (a = W.U(b))));\n                    return _.y.Ge(a);\n                },\n                l: function() {\n                    return ha.Oa();\n                },\n                m: function() {\n                    return ha.Sm();\n                },\n                n: function(a, b) {\n                    ca.listen(a, \"click\", function(a) {\n                        na.search(k(), b);\n                        return _.y.preventDefault(a);\n                    });\n                },\n                o: function() {\n                    P.Mb();\n                },\n                p: function() {\n                    ha.Kd();\n                },\n                q: function(a) {\n                    S.rg(((a || \"\")));\n                },\n                r: function() {\n                    return T.getHeight();\n                },\n                s: function() {\n                    S.clear();\n                },\n                t: function(a) {\n                    return P.Vd(a);\n                },\n                u: function() {\n                    S.Kh();\n                },\n                v: function() {\n                    $.JSBNG__focus();\n                },\n                w: function() {\n                    $.JSBNG__blur();\n                },\n                x: function() {\n                    return P.Ih();\n                },\n                y: function() {\n                    var a = ia.Eb();\n                    return ((a ? _.y.ej(a.gi()) : null));\n                },\n                z: f,\n                aa: function(a) {\n                    a = P.Jh(a, null);\n                    return _.y.ej(a.gi());\n                },\n                ab: function() {\n                    W.reset();\n                },\n                ad: function(a, b) {\n                    na.search(a, b);\n                },\n                ae: function() {\n                    ((da && da.refresh()));\n                },\n                af: function(a) {\n                    ha.xf(a);\n                },\n                ag: function() {\n                    ha.$d();\n                },\n                ah: l,\n                ai: n,\n                al: function() {\n                    S.uh();\n                },\n                am: function() {\n                    return ((F && F.isActive()));\n                },\n                an: function(a) {\n                    ((Z && Z.qh(a)));\n                },\n                ao: m,\n                ap: function() {\n                    return ((((m() && Z)) ? Z.wf() : \"\"));\n                },\n                aq: function(a, b) {\n                    return _.y.Hh(a, b);\n                },\n                ar: g,\n                as: h,\n                at: function() {\n                    ((da && da.clear()));\n                },\n                au: function(a, b) {\n                    f(a);\n                    ((ha.isEnabled() && ha.setSuggestions(a, b, !1)));\n                },\n                av: function(a) {\n                    ca.Aa(15, {\n                        query: a\n                    });\n                },\n                aw: function() {\n                    return $.$c();\n                },\n                ax: function(a) {\n                    P.Lh(a);\n                },\n                ay: function(a) {\n                    T.oe(a);\n                },\n                az: function(a) {\n                    return ((!!ja && ja.wl(a)));\n                },\n                ba: function() {\n                    var a, b = ia.Eb();\n                    if (b) {\n                        var c = b.rd();\n                        ((c && (((a = c.ke()) || (a = b.U().ka(\"o\"))))));\n                    }\n                ;\n                ;\n                    return ((a || \"\"));\n                },\n                bb: function(a, b) {\n                    return ((ga ? (ga.Ak(a, b), !0) : !1));\n                },\n                bc: function(a, b) {\n                    switch (a) {\n                      case u.Yl:\n                    \n                      case u.Ad:\n                        return ((p(b)[a] || null));\n                      case u.kf:\n                        var c;\n                        n:\n                        {\n                            if ((((((c = l()) && ((46 == c.I())))) && (c = c.U().ka(\"g\"))))) {\n                                break n;\n                            }\n                        ;\n                        ;\n                            c = null;\n                        };\n                    ;\n                        return c;\n                      default:\n                        return null;\n                    };\n                ;\n                },\n                bd: function(a) {\n                    ((R && R.qi(a)));\n                },\n                be: t,\n                bf: function(a) {\n                    return ((((((6 == t())) && !!V)) && V.qk(a)));\n                },\n                getId: h,\n                zd: g\n            };\n            Y = ((((null == d)) ? _.y.O.Tm() : d));\n            E = _.y.$o(c);\n            (function(a) {\n                var b = E.Lc(), c = w(a, /Version\\/(\\d+)/);\n                ((c || (c = w(a, /(?:Android|Chrome|Firefox|Opera|MSIE)[\\s\\/](\\d+)/))));\n                ((c || (c = w(a, /Trident[^)]*rv:(\\d+)/))));\n                a = c;\n                _.y.ub = b[D4.IE];\n                _.y.Zk = ((_.y.ub && ((8 >= a))));\n                _.y.Bg = ((_.y.ub && ((7 >= a))));\n                _.y.dc = b[D4.GECKO];\n                _.y.yy = ((_.y.dc && ((3 >= a))));\n                _.y.gd = b[D4.OPERA];\n                _.y.Jd = b[D4.WEBKIT];\n                _.y.Hp = b[D4.SAFARI];\n                _.y.Yk = b[D4.CHROME];\n                _.y.zy = b[D4.cj];\n                _.y.Cj = b[D4.$i];\n            })(window.JSBNG__navigator.userAgent);\n            (function() {\n                var a = ((((window.JSBNG__navigator && ((window.JSBNG__navigator.platform || window.JSBNG__navigator.appVersion)))) || \"\"));\n                _.y.Cu = /Linux/.test(a);\n                _.y.zh = /Mac/.test(a);\n                _.y.Du = /Win/.test(a);\n            })();\n            return ya;\n        };\n        ((window.google || (window.google = {\n        })));\n        window.google.sbox = _.y.rq;\n        (0, _.Sg)(_.x.G(), \"sb\");\n        (0, _.Wg)(_.x.G(), \"sb\");\n    } catch (e) {\n        _._DumpException(e);\n    };\n;\n    try {\n        _.Fj = function() {\n            var a = [];\n            ((Gj && a.push(((\"bv.\" + Gj)))));\n            ((((Hj && Ij)) && a.push(\"bs.1\")));\n            ((Jj && a.push(((\"d.\" + Jj)))));\n            return ((((0 < a.length)) ? ((\"&bvm=\" + a.join(\",\"))) : \"\"));\n        };\n        (0, _.Vg)(_.x.G(), \"sy1\");\n        var Hj;\n        var Mj;\n        var Kj;\n        var Jj;\n        var Ij;\n        var Gj;\n        Gj = 0;\n        Ij = !1;\n        Jj = \"\";\n        Kj = !1;\n        _.Lj = !1;\n        Mj = !1;\n        _.Nj = !1;\n        Hj = !1;\n        (0, _.vf)(\"vm\", {\n            init: function(a) {\n                ((Kj ? ((((((\"bv\" in a)) && ((a.bv != Gj)))) && (Ij = !0))) : (Kj = !0, ((((\"bv\" in a)) && (Gj = a.bv))), Ij = !1, ((((\"d\" in a)) && (Jj = a.d))), ((((\"tc\" in a)) && (_.Lj = a.tc))), ((((\"te\" in a)) && (Mj = a.te))), ((((\"ts\" in a)) && (_.Nj = a.ts))), ((((\"tk\" in a)) && (Hj = a.tk))))));\n            }\n        });\n        (0, _.za)(\"google.vm.e\", function() {\n            return ((Mj ? (0, _.Fj)() : \"\"));\n        }, void 0);\n        (0, _.Sg)(_.x.G(), \"sy1\");\n        (0, _.Wg)(_.x.G(), \"sy1\");\n    } catch (e) {\n        _._DumpException(e);\n    };\n;\n    try {\n        _.Oj = function() {\n        \n        };\n        _.Pj = function(a, b) {\n            ((a.ja || (0, _.db)(a, _.Oj)));\n            b.rC = a;\n        };\n        _.Qj = function(a, b, c) {\n            ((a.ja || (0, _.db)(a, b)));\n            c = ((c || 0));\n            a.EO = c;\n            if (b.Pu) {\n                b = b.Pu;\n                for (var d = 0, e = ((b.length - 1)); ((d <= e)); ) {\n                    var f = ((((d + e)) >> 1));\n                    ((((c > b[f].EO)) ? e = ((f - 1)) : d = ((f + 1))));\n                };\n            ;\n                ((((((d < b.length)) && ((b[d].EO == c)))) && ++d));\n                b.splice(d, 0, a);\n            }\n             else b.Pu = [a,];\n        ;\n        ;\n        };\n        var qba = function(a) {\n            function b(a) {\n                arguments.callee.ja.constructor.call(this, a);\n                var b = this.Pu.length;\n                this.A = [];\n                for (var c = 0; ((c < b)); ++c) {\n                    ((this.Pu[c].J3 || (this.A[c] = new this.Pu[c](a))));\n                ;\n                };\n            ;\n            };\n        ;\n            var c = a.rC;\n            (0, _.db)(b, c);\n            for (var d = []; a; ) {\n                if (c = a.rC) {\n                    ((c.Pu && (0, _.Nb)(d, c.Pu)));\n                    var c = c.prototype, e;\n                    {\n                        var fin60keys = ((window.top.JSBNG_Replay.forInKeys)((c))), fin60i = (0);\n                        (0);\n                        for (; (fin60i < fin60keys.length); (fin60i++)) {\n                            ((e) = (fin60keys[fin60i]));\n                            {\n                                if (((((c.hasOwnProperty(e) && (0, _.Va)(c[e]))) && ((c[e] !== a))))) {\n                                    var f = !!c[e].JU, g = rba(e, c, d, f);\n                                    (((f = sba(e, c, g, f)) && (b.prototype[e] = f)));\n                                }\n                            ;\n                            ;\n                            };\n                        };\n                    };\n                ;\n                }\n            ;\n            ;\n                a = ((a.ja && a.ja.constructor));\n            };\n        ;\n            b.prototype.Pu = d;\n            return b;\n        };\n        var rba = function(a, b, c, d) {\n            for (var e = [], f = 0; ((((f < c.length)) && ((((c[f].prototype[a] === b[a])) || (e.push(f), !d))))); ++f) {\n            ;\n            };\n        ;\n            return e;\n        };\n        var sba = function(a, b, c, d) {\n            return ((c.length ? ((d ? function(b) {\n                var d = this.A[c[0]];\n                return ((d ? d[a].apply(this.A[c[0]], arguments) : this.Pu[c[0]].prototype[a].apply(this, arguments)));\n            } : ((b[a].MU ? function(b) {\n                var d;\n                n:\n                {\n                    d = Array.prototype.slice.call(arguments, 0);\n                    for (var g = 0; ((g < c.length)); ++g) {\n                        var h = this.A[c[g]];\n                        if (h = ((h ? h[a].apply(h, d) : this.Pu[c[g]].prototype[a].apply(this, d)))) {\n                            d = h;\n                            break n;\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    d = !1;\n                };\n            ;\n                return d;\n            } : ((b[a].KU ? function(b) {\n                var d;\n                n:\n                {\n                    d = Array.prototype.slice.call(arguments, 0);\n                    for (var g = 0; ((g < c.length)); ++g) {\n                        var h = this.A[c[g]], h = ((h ? h[a].apply(h, d) : this.Pu[c[g]].prototype[a].apply(this, d)));\n                        if (((null != h))) {\n                            d = h;\n                            break n;\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    d = void 0;\n                };\n            ;\n                return d;\n            } : ((b[a].hF ? function(b) {\n                for (var d = Array.prototype.slice.call(arguments, 0), g = 0; ((g < c.length)); ++g) {\n                    var h = this.A[c[g]];\n                    ((h ? h[a].apply(h, d) : this.Pu[c[g]].prototype[a].apply(this, d)));\n                };\n            ;\n            } : function(b) {\n                for (var d = Array.prototype.slice.call(arguments, 0), g = [], h = 0; ((h < c.length)); ++h) {\n                    var k = this.A[c[h]];\n                    g.push(((k ? k[a].apply(k, d) : this.Pu[c[h]].prototype[a].apply(this, d))));\n                };\n            ;\n                return g;\n            })))))))) : ((((((((d || b[a].MU)) || b[a].KU)) || b[a].hF)) ? null : tba))));\n        };\n        var tba = function() {\n            return [];\n        };\n        _.Rj = function() {\n            return (0, _.ka)();\n        };\n        _.Sj = function(a) {\n            if (!a.jt) {\n                var b;\n                for (b = a.constructor; ((b && !b.rC)); ) {\n                    b = ((b.ja && b.ja.constructor));\n                ;\n                };\n            ;\n                ((b.rC.FO || (b.rC.FO = qba(b))));\n                b = new b.rC.FO(a);\n                a.jt = b;\n                ((a.jK || (a.jK = uba)));\n            }\n        ;\n        ;\n        };\n        var uba = function(a) {\n            return this.jt.jK(a);\n        };\n        (0, _.Vg)(_.x.G(), \"sy2\");\n        _.Oj.prototype.jK = function(a) {\n            if (this.A) {\n                for (var b = 0; ((b < this.A.length)); ++b) {\n                    if (((this.A[b] instanceof a))) {\n                        return this.A[b];\n                    }\n                ;\n                ;\n                };\n            }\n        ;\n        ;\n            return null;\n        };\n        (0, _.Sg)(_.x.G(), \"sy2\");\n        (0, _.Wg)(_.x.G(), \"sy2\");\n    } catch (e) {\n        _._DumpException(e);\n    };\n;\n    try {\n        _.Vj = function(a) {\n            a = ((a ? a : (0, _.ka)()));\n            a.JU = !0;\n            return a;\n        };\n        _.Wj = function() {\n            (0, _.Sj)(this);\n            this.A = this.B = this.L = !1;\n            this.H = !0;\n            this.D = !1;\n        };\n        _.Xj = function() {\n        \n        };\n        _.Yj = function(a, b) {\n            return !!((((((((((a.altKey || a.ctrlKey)) || a.shiftKey)) || a.metaKey)) || ((a.button && ((0 != a.button)))))) || ((1 < b))));\n        };\n        var vba = function(a, b) {\n            var c = ((((window.JSBNG__event && (0, _.Sa)(window.JSBNG__event.button))) ? window.JSBNG__event.button : void 0));\n            return function(d) {\n                (((((0, _.Yj)(d, c) || b.target)) || ((0, _.Yf)(a), (0, _.Di)(d), ((d.preventDefault && d.preventDefault())), d.returnValue = !1)));\n            };\n        };\n        (0, _.Vg)(_.x.G(), \"sy3\");\n        (0, _.Ia)(_.Wj);\n        (0, _.db)(_.Xj, _.Oj);\n        (0, _.Pj)(_.Xj, _.Wj);\n        _.Wj.prototype.J = function(a, b, c, d, e, f, g, h, k, l, n) {\n            try {\n                var p = window.google.getEI(a);\n                if (((a === window))) {\n                    for (a = window.JSBNG__event.srcElement, p = window.google.getEI(a); ((a && !a.href)); ) {\n                        a = a.parentNode;\n                    ;\n                    };\n                }\n            ;\n            ;\n                b = ((window.encodeURIComponent || window.escape));\n                var m = ((_.sc.Hc ? a.getAttribute(\"href\", 2) : a.getAttribute(\"href\"))), t, s, r, w = (0, _.Ve)();\n                ((window.google.v6 && (t = window.google.v6.src, s = ((((window.google.v6.complete || window.google.v6s)) ? 2 : 1)), r = ((w - window.google.v6t)), delete window.google.v6)));\n                ((((g && ((\"&sig2=\" != g.substring(0, 6))))) && (g = ((\"&sig2=\" + g)))));\n                var G = ((((window.google.psy && window.google.psy.q)) && window.google.psy.q())), J = ((G ? b(G) : (0, _.dg)(\"q\"))), u = ((this.H && ((this.B || this.A)))), E = ((!u && ((this.B || this.A)))), w = \"\";\n                ((((this.A && ((((\"encrypted.google.com\" != window.JSBNG__location.hostname)) && ((\"https:\" != m.substr(0, 6))))))) && (w = ((((\"http://\" + window.JSBNG__location.hostname)) + ((window.google.kPTP ? ((\":\" + window.google.kPTP)) : \"\")))))));\n                G = \"\";\n                ((((c && ((\"docid=\" == c.substr(0, 6))))) && (G = c)));\n                c = ((((\"\" != G)) ? !0 : !1));\n                var F = ((((((n && n.button)) && ((2 == n.button)))) ? \"&cad=rja\" : \"\")), R;\n                if (this.D) {\n                    n = m;\n                    d = \"\";\n                    for (var Z = 0, T = n.length; ((Z < T)); ++Z) {\n                        d += ((\"%\" + n.charCodeAt(Z).toString(16)));\n                    ;\n                    };\n                ;\n                    R = d;\n                }\n                 else R = b(m).replace(/\\+/g, \"%2B\");\n            ;\n            ;\n                var m = R, ca = [w,\"/url?sa=\",((l ? \"i\" : \"t\")),((((this.B || this.A)) ? \"&rct=j\" : \"\")),((u ? ((\"&q=\" + ((J || \"\")))) : \"\")),((E ? \"&q=&esrc=s\" : \"\")),((((this.A && this.L)) ? \"&frm=1\" : \"\")),\"&source=\",window.google.sn,\"&cd=\",b(e),F,((c ? ((\"&\" + G)) : \"\")),((((window.google.j && window.google.j.pf)) ? \"&sqi=2\" : \"\")),\"&ved=\",b(h),\"&url=\",m,\"&ei=\",p,((k ? ((\"&authuser=\" + b(k.toString()))) : \"\")),((t ? ((((((((((\"&v6u=\" + b