/* Replayable replacements for global functions */

/***************************************************************
 * BEGIN STABLE.JS
 **************************************************************/
//! stable.js 0.1.3, https://github.com/Two-Screen/stable
//! © 2012 Stéphan Kochen, Angry Bytes. MIT licensed.
(function() {

// A stable array sort, because `Array#sort()` is not guaranteed stable.
// This is an implementation of merge sort, without recursion.

var stable = function(arr, comp) {
    if (typeof(comp) !== 'function') {
        comp = function(a, b) {
            a = String(a);
            b = String(b);
            if (a < b) return -1;
            if (a > b) return 1;
            return 0;
        };
    }

    var len = arr.length;

    if (len <= 1) return arr;

    // Rather than dividing input, simply iterate chunks of 1, 2, 4, 8, etc.
    // Chunks are the size of the left or right hand in merge sort.
    // Stop when the left-hand covers all of the array.
    var oarr = arr;
    for (var chk = 1; chk < len; chk *= 2) {
        arr = pass(arr, comp, chk);
    }
    for (var i = 0; i < len; i++) {
        oarr[i] = arr[i];
    }
    return oarr;
};

// Run a single pass with the given chunk size. Returns a new array.
var pass = function(arr, comp, chk) {
    var len = arr.length;
    // Output, and position.
    var result = new Array(len);
    var i = 0;
    // Step size / double chunk size.
    var dbl = chk * 2;
    // Bounds of the left and right chunks.
    var l, r, e;
    // Iterators over the left and right chunk.
    var li, ri;

    // Iterate over pairs of chunks.
    for (l = 0; l < len; l += dbl) {
        r = l + chk;
        e = r + chk;
        if (r > len) r = len;
        if (e > len) e = len;

        // Iterate both chunks in parallel.
        li = l;
        ri = r;
        while (true) {
            // Compare the chunks.
            if (li < r && ri < e) {
                // This works for a regular `sort()` compatible comparator,
                // but also for a simple comparator like: `a > b`
                if (comp(arr[li], arr[ri]) <= 0) {
                    result[i++] = arr[li++];
                }
                else {
                    result[i++] = arr[ri++];
                }
            }
            // Nothing to compare, just flush what's left.
            else if (li < r) {
                result[i++] = arr[li++];
            }
            else if (ri < e) {
                result[i++] = arr[ri++];
            }
            // Both iterators are at the chunk ends.
            else {
                break;
            }
        }
    }

    return result;
};

var arrsort = function(comp) {
    return stable(this, comp);
};

if (Object.defineProperty) {
    Object.defineProperty(Array.prototype, "sort", {
        configurable: true, writable: true, enumerable: false,
        value: arrsort
    });
} else {
    Array.prototype.sort = arrsort;
}

})();
/***************************************************************
 * END STABLE.JS
 **************************************************************/

/*
 * In a generated replay, this file is partially common, boilerplate code
 * included in every replay, and partially generated replay code. The following
 * header applies to the boilerplate code. A comment indicating "Auto-generated
 * below this comment" marks the separation between these two parts.
 *
 * Copyright (C) 2011, 2012 Purdue University
 * Written by Gregor Richards
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

(function() {
    // global eval alias
    var geval = eval;

    // detect if we're in a browser or not
    var inbrowser = false;
    var inharness = false;
    var finished = false;
    if (typeof window !== "undefined" && "document" in window) {
        inbrowser = true;
        if (window.parent && "JSBNG_handleResult" in window.parent) {
            inharness = true;
        }
    } else if (typeof global !== "undefined") {
        window = global;
        window.top = window;
    } else {
        window = (function() { return this; })();
        window.top = window;
    }

    if ("console" in window) {
        window.JSBNG_Console = window.console;
    }

    var callpath = [];

    // Workaround for bound functions as events
    delete Function.prototype.bind;

    // global state
    var JSBNG_Replay = window.top.JSBNG_Replay = {
        push: function(arr, fun) {
            arr.push(fun);
            return fun;
        },

        path: function(str) {
            verifyPath(str);
        },

        forInKeys: function(of) {
            var keys = [];
            for (var k in of)
                keys.push(k);
            return keys.sort();
        }
    };

    var currentTimeInMS;
    if (inharness) {
        currentTimeInMS = window.parent.currentTimeInMS;
    } else {
        if (window.performance && window.performance.now)
            currentTimeInMS = function() { return window.performance.now() };
        else if (typeof preciseTime !== 'undefined')
            currentTimeInMS = function() { return preciseTime() * 1000; };
        else
            currentTimeInMS = function() { return Date.now(); };
    }

    // the actual replay runner
    function onload() {
        try {
            delete window.onload;
        } catch (ex) {}

        var jr = JSBNG_Replay$;
        var cb = function() {
            var end = currentTimeInMS();
            finished = true;

            var msg = "Time: " + (end - st) + "ms";
    
            if (inharness) {
                window.parent.JSBNG_handleResult({error:false, time:(end - st)});
            } else if (inbrowser) {
                var res = document.createElement("div");
    
                res.style.position = "fixed";
                res.style.left = "1em";
                res.style.top = "1em";
                res.style.width = "35em";
                res.style.height = "5em";
                res.style.padding = "1em";
                res.style.backgroundColor = "white";
                res.style.color = "black";
                res.appendChild(document.createTextNode(msg));
    
                document.body.appendChild(res);
            } else if (typeof console !== "undefined") {
                console.log(msg);
            } else if (typeof print !== "undefined") {
                // hopefully not the browser print() function :)
                print(msg);
            }
        };

        // force it to JIT
        jr(false);

        // then time it
        var st = currentTimeInMS();
        while (jr !== null) {
            jr = jr(true, cb);
        }
    }

    // add a frame at replay time
    function iframe(pageid) {
        var iw;
        if (inbrowser) {
            // represent the iframe as an iframe (of course)
            var iframe = document.createElement("iframe");
            iframe.style.display = "none";
            document.body.appendChild(iframe);
            iw = iframe.contentWindow;
            iw.document.write("<script type=\"text/javascript\">var JSBNG_Replay_geval = eval;</script>");
            iw.document.close();
        } else {
            // no general way, just lie and do horrible things
            var topwin = window;
            (function() {
                var window = {};
                window.window = window;
                window.top = topwin;
                window.JSBNG_Replay_geval = function(str) {
                    eval(str);
                }
                iw = window;
            })();
        }
        return iw;
    }

    // called at the end of the replay stuff
    function finalize() {
        if (inbrowser) {
            setTimeout(onload, 0);
        } else {
            onload();
        }
    }

    // verify this recorded value and this replayed value are close enough
    function verify(rep, rec) {
        if (rec !== rep &&
            (rep === rep || rec === rec) /* NaN test */) {
            // FIXME?
            if (typeof rec === "function" && typeof rep === "function") {
                return true;
            }
            if (typeof rec !== "object" || rec === null ||
                !(("__JSBNG_unknown_" + typeof(rep)) in rec)) {
                return false;
            }
        }
        return true;
    }

    // general message
    var firstMessage = true;
    function replayMessage(msg) {
        if (inbrowser) {
            if (firstMessage)
                document.open();
            firstMessage = false;
            document.write(msg);
        } else {
            console.log(msg);
        }
    }

    // complain when there's an error
    function verificationError(msg) {
        if (finished) return;
        if (inharness) {
            window.parent.JSBNG_handleResult({error:true, msg: msg});
        } else replayMessage(msg);
        throw new Error();
    }

    // to verify a set
    function verifySet(objstr, obj, prop, gvalstr, gval) {
        if (/^on/.test(prop)) {
            // these aren't instrumented compatibly
            return;
        }

        if (!verify(obj[prop], gval)) {
            var bval = obj[prop];
            var msg = "Verification failure! " + objstr + "." + prop + " is not " + gvalstr + ", it's " + bval + "!";
            verificationError(msg);
        }
    }

    // to verify a call or new
    function verifyCall(iscall, func, cthis, cargs) {
        var ok = true;
        var callArgs = func.callArgs[func.inst];
        iscall = iscall ? 1 : 0;
        if (cargs.length !== callArgs.length - 1) {
            ok = false;
        } else {
            if (iscall && !verify(cthis, callArgs[0])) ok = false;
            for (var i = 0; i < cargs.length; i++) {
                if (!verify(cargs[i], callArgs[i+1])) ok = false;
            }
        }
        if (!ok) {
            var msg = "Call verification failure!";
            verificationError(msg);
        }

        return func.returns[func.inst++];
    }

    // to verify the callpath
    function verifyPath(func) {
        var real = callpath.shift();
        if (real !== func) {
            var msg = "Call path verification failure! Expected " + real + ", found " + func;
            verificationError(msg);
        }
    }

    // figure out how to define getters
    var defineGetter;
    if (Object.defineProperty) {
        var odp = Object.defineProperty;
        defineGetter = function(obj, prop, getter, setter) {
            if (typeof setter === "undefined") setter = function(){};
            odp(obj, prop, {"enumerable": true, "configurable": true, "get": getter, "set": setter});
        };
    } else if (Object.prototype.__defineGetter__) {
        var opdg = Object.prototype.__defineGetter__;
        var opds = Object.prototype.__defineSetter__;
        defineGetter = function(obj, prop, getter, setter) {
            if (typeof setter === "undefined") setter = function(){};
            opdg.call(obj, prop, getter);
            opds.call(obj, prop, setter);
        };
    } else {
        defineGetter = function() {
            verificationError("This replay requires getters for correct behavior, and your JS engine appears to be incapable of defining getters. Sorry!");
        };
    }

    var defineRegetter = function(obj, prop, getter, setter) {
        defineGetter(obj, prop, function() {
            return getter.call(this, prop);
        }, function(val) {
            // once it's set by the client, it's claimed
            setter.call(this, prop, val);
            Object.defineProperty(obj, prop, {
                "enumerable": true, "configurable": true, "writable": true,
                "value": val
            });
        });
    }

    // for calling events
    var fpc = Function.prototype.call;

// resist the urge, don't put a })(); here!
/******************************************************************************
 * Auto-generated below this comment
 *****************************************************************************/
var ow989148965 = window;
var f989148965_0;
var o0;
var o1;
var f989148965_7;
var f989148965_12;
var o2;
var o3;
var f989148965_56;
var f989148965_143;
var f989148965_417;
var o4;
var f989148965_419;
var f989148965_420;
var f989148965_421;
var o5;
var f989148965_423;
var f989148965_424;
var o6;
var o7;
var o8;
var f989148965_429;
var o9;
var o10;
var o11;
var f989148965_439;
var f989148965_443;
var f989148965_448;
var f989148965_449;
var f989148965_451;
var f989148965_459;
var fo989148965_460_length;
var f989148965_463;
var f989148965_465;
var f989148965_468;
var f989148965_472;
var f989148965_473;
var f989148965_474;
var f989148965_475;
var f989148965_477;
var f989148965_487;
var f989148965_490;
var f989148965_492;
var f989148965_493;
var f989148965_494;
var f989148965_496;
var f989148965_508;
var f989148965_525;
var f989148965_696;
var f989148965_697;
JSBNG_Replay.s19277ddcd28db6dd01a1d67d562dfbbffa3c6a17_1 = [];
JSBNG_Replay.s19277ddcd28db6dd01a1d67d562dfbbffa3c6a17_4 = [];
// 1
// record generated by JSBench  at 2013-07-10T19:04:57.531Z
// 2
// 3
f989148965_0 = function() { return f989148965_0.returns[f989148965_0.inst++]; };
f989148965_0.returns = [];
f989148965_0.inst = 0;
// 4
ow989148965.JSBNG__Date = f989148965_0;
// 5
o0 = {};
// 6
ow989148965.JSBNG__document = o0;
// 9
o1 = {};
// 10
ow989148965.JSBNG__localStorage = o1;
// 17
f989148965_7 = function() { return f989148965_7.returns[f989148965_7.inst++]; };
f989148965_7.returns = [];
f989148965_7.inst = 0;
// 18
ow989148965.JSBNG__addEventListener = f989148965_7;
// 19
ow989148965.JSBNG__top = ow989148965;
// 24
ow989148965.JSBNG__scrollX = 0;
// 25
ow989148965.JSBNG__scrollY = 0;
// 30
f989148965_12 = function() { return f989148965_12.returns[f989148965_12.inst++]; };
f989148965_12.returns = [];
f989148965_12.inst = 0;
// 31
ow989148965.JSBNG__setTimeout = f989148965_12;
// 42
ow989148965.JSBNG__frames = ow989148965;
// 45
ow989148965.JSBNG__self = ow989148965;
// 46
o2 = {};
// 47
ow989148965.JSBNG__navigator = o2;
// 62
ow989148965.JSBNG__closed = false;
// 65
ow989148965.JSBNG__opener = null;
// 66
ow989148965.JSBNG__defaultStatus = "";
// 67
o3 = {};
// 68
ow989148965.JSBNG__location = o3;
// 69
ow989148965.JSBNG__innerWidth = 1024;
// 70
ow989148965.JSBNG__innerHeight = 702;
// 71
ow989148965.JSBNG__outerWidth = 1024;
// 72
ow989148965.JSBNG__outerHeight = 774;
// 73
ow989148965.JSBNG__screenX = 79;
// 74
ow989148965.JSBNG__screenY = 22;
// 75
ow989148965.JSBNG__pageXOffset = 0;
// 76
ow989148965.JSBNG__pageYOffset = 0;
// 101
ow989148965.JSBNG__frameElement = null;
// 112
ow989148965.JSBNG__screenLeft = 79;
// 113
ow989148965.JSBNG__clientInformation = o2;
// 114
ow989148965.JSBNG__defaultstatus = "";
// 119
ow989148965.JSBNG__devicePixelRatio = 1;
// 122
ow989148965.JSBNG__offscreenBuffering = true;
// 123
ow989148965.JSBNG__screenTop = 22;
// 138
f989148965_56 = function() { return f989148965_56.returns[f989148965_56.inst++]; };
f989148965_56.returns = [];
f989148965_56.inst = 0;
// 139
ow989148965.JSBNG__XMLHttpRequest = f989148965_56;
// 142
ow989148965.JSBNG__name = "";
// 149
ow989148965.JSBNG__status = "";
// 314
f989148965_143 = function() { return f989148965_143.returns[f989148965_143.inst++]; };
f989148965_143.returns = [];
f989148965_143.inst = 0;
// 315
ow989148965.JSBNG__Document = f989148965_143;
// 588
ow989148965.JSBNG__XMLDocument = f989148965_143;
// 863
ow989148965.JSBNG__onerror = null;
// 864
f989148965_417 = function() { return f989148965_417.returns[f989148965_417.inst++]; };
f989148965_417.returns = [];
f989148965_417.inst = 0;
// 865
ow989148965.Math.JSBNG__random = f989148965_417;
// 866
// 868
o4 = {};
// 869
o0.documentElement = o4;
// 871
o4.className = "";
// 873
f989148965_419 = function() { return f989148965_419.returns[f989148965_419.inst++]; };
f989148965_419.returns = [];
f989148965_419.inst = 0;
// 874
o4.getAttribute = f989148965_419;
// 875
f989148965_419.returns.push("swift-loading");
// 876
// 878
// 879
// 880
// 881
// 882
f989148965_12.returns.push(2);
// 884
f989148965_420 = function() { return f989148965_420.returns[f989148965_420.inst++]; };
f989148965_420.returns = [];
f989148965_420.inst = 0;
// 885
o0.JSBNG__addEventListener = f989148965_420;
// 887
f989148965_420.returns.push(undefined);
// 889
f989148965_420.returns.push(undefined);
// 891
// 892
o0.nodeType = 9;
// 893
f989148965_421 = function() { return f989148965_421.returns[f989148965_421.inst++]; };
f989148965_421.returns = [];
f989148965_421.inst = 0;
// 894
o0.createElement = f989148965_421;
// 895
o5 = {};
// 896
f989148965_421.returns.push(o5);
// 897
f989148965_423 = function() { return f989148965_423.returns[f989148965_423.inst++]; };
f989148965_423.returns = [];
f989148965_423.inst = 0;
// 898
o5.setAttribute = f989148965_423;
// 899
f989148965_423.returns.push(undefined);
// 900
// 901
f989148965_424 = function() { return f989148965_424.returns[f989148965_424.inst++]; };
f989148965_424.returns = [];
f989148965_424.inst = 0;
// 902
o5.getElementsByTagName = f989148965_424;
// 903
o6 = {};
// 904
f989148965_424.returns.push(o6);
// 906
o7 = {};
// 907
f989148965_424.returns.push(o7);
// 908
o8 = {};
// 909
o7["0"] = o8;
// undefined
o7 = null;
// 910
o6.length = 4;
// undefined
o6 = null;
// 912
o6 = {};
// 913
f989148965_421.returns.push(o6);
// 914
f989148965_429 = function() { return f989148965_429.returns[f989148965_429.inst++]; };
f989148965_429.returns = [];
f989148965_429.inst = 0;
// 915
o6.appendChild = f989148965_429;
// 917
o7 = {};
// 918
f989148965_421.returns.push(o7);
// 919
f989148965_429.returns.push(o7);
// 921
o9 = {};
// 922
f989148965_424.returns.push(o9);
// 923
o10 = {};
// 924
o9["0"] = o10;
// undefined
o9 = null;
// 925
o9 = {};
// 926
o8.style = o9;
// 927
// 928
o11 = {};
// 929
o5.firstChild = o11;
// 930
o11.nodeType = 3;
// undefined
o11 = null;
// 932
o11 = {};
// 933
f989148965_424.returns.push(o11);
// 934
o11.length = 0;
// undefined
o11 = null;
// 936
o11 = {};
// 937
f989148965_424.returns.push(o11);
// 938
o11.length = 1;
// undefined
o11 = null;
// 939
o8.getAttribute = f989148965_419;
// undefined
o8 = null;
// 940
f989148965_419.returns.push("top: 1px; float: left; opacity: 0.5; ");
// 942
f989148965_419.returns.push("/a");
// 944
o9.opacity = "0.5";
// 946
o9.cssFloat = "left";
// undefined
o9 = null;
// 947
o10.value = "on";
// 948
o7.selected = true;
// 949
o5.className = "";
// 951
o8 = {};
// 952
f989148965_421.returns.push(o8);
// 953
o8.enctype = "application/x-www-form-urlencoded";
// undefined
o8 = null;
// 955
o8 = {};
// 956
f989148965_421.returns.push(o8);
// 957
f989148965_439 = function() { return f989148965_439.returns[f989148965_439.inst++]; };
f989148965_439.returns = [];
f989148965_439.inst = 0;
// 958
o8.cloneNode = f989148965_439;
// undefined
o8 = null;
// 959
o8 = {};
// 960
f989148965_439.returns.push(o8);
// 961
o8.outerHTML = "<nav></nav>";
// undefined
o8 = null;
// 962
o0.compatMode = "CSS1Compat";
// 963
// 964
o10.cloneNode = f989148965_439;
// undefined
o10 = null;
// 965
o8 = {};
// 966
f989148965_439.returns.push(o8);
// 967
o8.checked = true;
// undefined
o8 = null;
// 968
// undefined
o6 = null;
// 969
o7.disabled = false;
// undefined
o7 = null;
// 970
// 971
o5.JSBNG__addEventListener = f989148965_420;
// 973
o6 = {};
// 974
f989148965_421.returns.push(o6);
// 975
// 976
o6.setAttribute = f989148965_423;
// 977
f989148965_423.returns.push(undefined);
// 979
f989148965_423.returns.push(undefined);
// 981
f989148965_423.returns.push(undefined);
// 982
o5.appendChild = f989148965_429;
// 983
f989148965_429.returns.push(o6);
// 984
f989148965_443 = function() { return f989148965_443.returns[f989148965_443.inst++]; };
f989148965_443.returns = [];
f989148965_443.inst = 0;
// 985
o0.createDocumentFragment = f989148965_443;
// 986
o7 = {};
// 987
f989148965_443.returns.push(o7);
// 988
o7.appendChild = f989148965_429;
// 989
o5.lastChild = o6;
// 990
f989148965_429.returns.push(o6);
// 991
o7.cloneNode = f989148965_439;
// 992
o8 = {};
// 993
f989148965_439.returns.push(o8);
// 994
o8.cloneNode = f989148965_439;
// undefined
o8 = null;
// 995
o8 = {};
// 996
f989148965_439.returns.push(o8);
// 997
o9 = {};
// 998
o8.lastChild = o9;
// undefined
o8 = null;
// 999
o9.checked = true;
// undefined
o9 = null;
// 1000
o6.checked = true;
// 1001
f989148965_448 = function() { return f989148965_448.returns[f989148965_448.inst++]; };
f989148965_448.returns = [];
f989148965_448.inst = 0;
// 1002
o7.removeChild = f989148965_448;
// undefined
o7 = null;
// 1003
f989148965_448.returns.push(o6);
// undefined
o6 = null;
// 1005
f989148965_429.returns.push(o5);
// 1006
o5.JSBNG__attachEvent = void 0;
// 1007
o0.readyState = "interactive";
// 1010
f989148965_420.returns.push(undefined);
// 1011
f989148965_7.returns.push(undefined);
// 1013
f989148965_448.returns.push(o5);
// undefined
o5 = null;
// 1014
f989148965_417.returns.push(0.9546113463584334);
// 1015
f989148965_449 = function() { return f989148965_449.returns[f989148965_449.inst++]; };
f989148965_449.returns = [];
f989148965_449.inst = 0;
// 1016
o0.JSBNG__removeEventListener = f989148965_449;
// 1017
f989148965_417.returns.push(0.45179418730549514);
// 1020
o5 = {};
// 1021
f989148965_421.returns.push(o5);
// 1022
o5.appendChild = f989148965_429;
// 1023
f989148965_451 = function() { return f989148965_451.returns[f989148965_451.inst++]; };
f989148965_451.returns = [];
f989148965_451.inst = 0;
// 1024
o0.createComment = f989148965_451;
// 1025
o6 = {};
// 1026
f989148965_451.returns.push(o6);
// 1027
f989148965_429.returns.push(o6);
// undefined
o6 = null;
// 1028
o5.getElementsByTagName = f989148965_424;
// undefined
o5 = null;
// 1029
o5 = {};
// 1030
f989148965_424.returns.push(o5);
// 1031
o5.length = 0;
// undefined
o5 = null;
// 1033
o5 = {};
// 1034
f989148965_421.returns.push(o5);
// 1035
// 1036
o6 = {};
// 1037
o5.firstChild = o6;
// undefined
o5 = null;
// 1039
o6.getAttribute = f989148965_419;
// undefined
o6 = null;
// 1042
f989148965_419.returns.push("#");
// 1044
o5 = {};
// 1045
f989148965_421.returns.push(o5);
// 1046
// 1047
o6 = {};
// 1048
o5.lastChild = o6;
// undefined
o5 = null;
// 1049
o6.getAttribute = f989148965_419;
// undefined
o6 = null;
// 1050
f989148965_419.returns.push(null);
// 1052
o5 = {};
// 1053
f989148965_421.returns.push(o5);
// 1054
// 1055
f989148965_459 = function() { return f989148965_459.returns[f989148965_459.inst++]; };
f989148965_459.returns = [];
f989148965_459.inst = 0;
// 1056
o5.getElementsByClassName = f989148965_459;
// 1058
o6 = {};
// 1059
f989148965_459.returns.push(o6);
// undefined
fo989148965_460_length = function() { return fo989148965_460_length.returns[fo989148965_460_length.inst++]; };
fo989148965_460_length.returns = [];
fo989148965_460_length.inst = 0;
defineGetter(o6, "length", fo989148965_460_length, undefined);
// undefined
fo989148965_460_length.returns.push(1);
// 1061
o7 = {};
// 1062
o5.lastChild = o7;
// undefined
o5 = null;
// 1063
// undefined
o7 = null;
// 1065
f989148965_459.returns.push(o6);
// undefined
o6 = null;
// undefined
fo989148965_460_length.returns.push(2);
// 1068
o5 = {};
// 1069
f989148965_421.returns.push(o5);
// 1070
// 1071
// 1072
f989148965_463 = function() { return f989148965_463.returns[f989148965_463.inst++]; };
f989148965_463.returns = [];
f989148965_463.inst = 0;
// 1073
o4.insertBefore = f989148965_463;
// 1074
o6 = {};
// 1075
o4.firstChild = o6;
// 1076
f989148965_463.returns.push(o5);
// 1077
f989148965_465 = function() { return f989148965_465.returns[f989148965_465.inst++]; };
f989148965_465.returns = [];
f989148965_465.inst = 0;
// 1078
o0.getElementsByName = f989148965_465;
// 1080
o7 = {};
// 1081
f989148965_465.returns.push(o7);
// 1082
o7.length = 2;
// undefined
o7 = null;
// 1084
o7 = {};
// 1085
f989148965_465.returns.push(o7);
// 1086
o7.length = 0;
// undefined
o7 = null;
// 1087
f989148965_468 = function() { return f989148965_468.returns[f989148965_468.inst++]; };
f989148965_468.returns = [];
f989148965_468.inst = 0;
// 1088
o0.getElementById = f989148965_468;
// 1089
f989148965_468.returns.push(null);
// 1090
o4.removeChild = f989148965_448;
// 1091
f989148965_448.returns.push(o5);
// undefined
o5 = null;
// 1092
o5 = {};
// 1093
o4.childNodes = o5;
// 1094
o5.length = 3;
// 1095
o5["0"] = o6;
// 1096
o7 = {};
// 1097
o5["1"] = o7;
// undefined
o7 = null;
// 1098
o7 = {};
// 1099
o5["2"] = o7;
// undefined
o5 = null;
// 1100
f989148965_472 = function() { return f989148965_472.returns[f989148965_472.inst++]; };
f989148965_472.returns = [];
f989148965_472.inst = 0;
// 1101
o4.contains = f989148965_472;
// 1102
f989148965_473 = function() { return f989148965_473.returns[f989148965_473.inst++]; };
f989148965_473.returns = [];
f989148965_473.inst = 0;
// 1103
o4.compareDocumentPosition = f989148965_473;
// 1104
f989148965_474 = function() { return f989148965_474.returns[f989148965_474.inst++]; };
f989148965_474.returns = [];
f989148965_474.inst = 0;
// 1105
o0.querySelectorAll = f989148965_474;
// 1106
o4.matchesSelector = void 0;
// 1107
o4.mozMatchesSelector = void 0;
// 1108
f989148965_475 = function() { return f989148965_475.returns[f989148965_475.inst++]; };
f989148965_475.returns = [];
f989148965_475.inst = 0;
// 1109
o4.webkitMatchesSelector = f989148965_475;
// 1111
o5 = {};
// 1112
f989148965_421.returns.push(o5);
// 1113
// 1114
f989148965_477 = function() { return f989148965_477.returns[f989148965_477.inst++]; };
f989148965_477.returns = [];
f989148965_477.inst = 0;
// 1115
o5.querySelectorAll = f989148965_477;
// undefined
o5 = null;
// 1116
o5 = {};
// 1117
f989148965_477.returns.push(o5);
// 1118
o5.length = 1;
// undefined
o5 = null;
// 1120
o5 = {};
// 1121
f989148965_477.returns.push(o5);
// 1122
o5.length = 1;
// undefined
o5 = null;
// 1124
o5 = {};
// 1125
f989148965_421.returns.push(o5);
// 1126
// 1127
o5.querySelectorAll = f989148965_477;
// 1128
o8 = {};
// 1129
f989148965_477.returns.push(o8);
// 1130
o8.length = 0;
// undefined
o8 = null;
// 1131
// undefined
o5 = null;
// 1133
o5 = {};
// 1134
f989148965_477.returns.push(o5);
// 1135
o5.length = 1;
// undefined
o5 = null;
// 1137
o5 = {};
// 1138
f989148965_421.returns.push(o5);
// undefined
o5 = null;
// 1139
f989148965_475.returns.push(true);
// 1141
o5 = {};
// 1142
f989148965_443.returns.push(o5);
// 1143
o5.createElement = void 0;
// 1144
o5.appendChild = f989148965_429;
// undefined
o5 = null;
// 1146
o5 = {};
// 1147
f989148965_421.returns.push(o5);
// 1148
f989148965_429.returns.push(o5);
// undefined
o5 = null;
// 1149
o2.userAgent = "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_3) AppleWebKit/536.29.13 (KHTML, like Gecko) Version/6.0.4 Safari/536.29.13";
// undefined
o2 = null;
// 1150
o3.href = "https://twitter.com/search?q=%23javascript";
// undefined
o3 = null;
// 1151
o2 = {};
// 1152
f989148965_0.returns.push(o2);
// 1153
f989148965_487 = function() { return f989148965_487.returns[f989148965_487.inst++]; };
f989148965_487.returns = [];
f989148965_487.inst = 0;
// 1154
o2.getTime = f989148965_487;
// undefined
o2 = null;
// 1155
f989148965_487.returns.push(1373483112142);
// 1156
o2 = {};
// 1157
f989148965_56.returns.push(o2);
// undefined
o2 = null;
// 1158
o2 = {};
// 1159
f989148965_0.prototype = o2;
// 1160
f989148965_490 = function() { return f989148965_490.returns[f989148965_490.inst++]; };
f989148965_490.returns = [];
f989148965_490.inst = 0;
// 1161
o2.toISOString = f989148965_490;
// 1162
o3 = {};
// 1163
f989148965_0.returns.push(o3);
// 1164
o3.toISOString = f989148965_490;
// undefined
o3 = null;
// 1165
f989148965_490.returns.push("-000001-01-01T00:00:00.000Z");
// 1166
f989148965_492 = function() { return f989148965_492.returns[f989148965_492.inst++]; };
f989148965_492.returns = [];
f989148965_492.inst = 0;
// 1167
f989148965_0.now = f989148965_492;
// 1169
f989148965_493 = function() { return f989148965_493.returns[f989148965_493.inst++]; };
f989148965_493.returns = [];
f989148965_493.inst = 0;
// 1170
o2.toJSON = f989148965_493;
// undefined
o2 = null;
// 1171
f989148965_494 = function() { return f989148965_494.returns[f989148965_494.inst++]; };
f989148965_494.returns = [];
f989148965_494.inst = 0;
// 1172
f989148965_0.parse = f989148965_494;
// 1174
f989148965_494.returns.push(8640000000000000);
// 1176
o2 = {};
// 1177
f989148965_421.returns.push(o2);
// undefined
o2 = null;
// 1178
ow989148965.JSBNG__attachEvent = undefined;
// 1179
f989148965_496 = function() { return f989148965_496.returns[f989148965_496.inst++]; };
f989148965_496.returns = [];
f989148965_496.inst = 0;
// 1180
o0.getElementsByTagName = f989148965_496;
// 1181
o2 = {};
// 1182
f989148965_496.returns.push(o2);
// 1184
o3 = {};
// 1185
f989148965_421.returns.push(o3);
// 1186
o5 = {};
// 1187
o2["0"] = o5;
// 1188
o5.src = "http://jsbngssl.twitter.com/JSBENCH_NG_RECORD_OBJECTS.js";
// 1189
o8 = {};
// 1190
o2["1"] = o8;
// 1191
o8.src = "http://jsbngssl.twitter.com/JSBENCH_NG_RECORD.js";
// undefined
o8 = null;
// 1192
o8 = {};
// 1193
o2["2"] = o8;
// 1194
o8.src = "";
// undefined
o8 = null;
// 1195
o8 = {};
// 1196
o2["3"] = o8;
// 1197
o8.src = "";
// undefined
o8 = null;
// 1198
o8 = {};
// 1199
o2["4"] = o8;
// 1200
o8.src = "";
// undefined
o8 = null;
// 1201
o8 = {};
// 1202
o2["5"] = o8;
// 1203
o8.src = "";
// undefined
o8 = null;
// 1204
o8 = {};
// 1205
o2["6"] = o8;
// 1206
o8.src = "http://jsbngssl.abs.twimg.com/c/swift/en/init.fc6418142bd015a47a0c8c1f3f5b7acd225021e8.js";
// undefined
o8 = null;
// 1207
o2["7"] = void 0;
// 1209
o8 = {};
// 1210
f989148965_468.returns.push(o8);
// 1211
o8.parentNode = o7;
// 1212
o8.id = "swift-module-path";
// 1213
o8.type = "hidden";
// 1214
o8.nodeName = "INPUT";
// 1215
o8.value = "http://jsbngssl.abs.twimg.com/c/swift/en";
// undefined
o8 = null;
// 1217
o0.ownerDocument = null;
// 1219
o4.nodeName = "HTML";
// 1223
o8 = {};
// 1224
f989148965_474.returns.push(o8);
// 1225
o8["0"] = void 0;
// undefined
o8 = null;
// 1230
f989148965_508 = function() { return f989148965_508.returns[f989148965_508.inst++]; };
f989148965_508.returns = [];
f989148965_508.inst = 0;
// 1231
o0.getElementsByClassName = f989148965_508;
// 1233
o8 = {};
// 1234
f989148965_508.returns.push(o8);
// 1235
o8["0"] = void 0;
// undefined
o8 = null;
// 1236
o8 = {};
// 1237
f989148965_0.returns.push(o8);
// 1238
o8.getTime = f989148965_487;
// undefined
o8 = null;
// 1239
f989148965_487.returns.push(1373483112185);
// 1240
o8 = {};
// 1241
f989148965_0.returns.push(o8);
// 1242
o8.getTime = f989148965_487;
// undefined
o8 = null;
// 1243
f989148965_487.returns.push(1373483112185);
// 1244
o8 = {};
// 1245
f989148965_0.returns.push(o8);
// 1246
o8.getTime = f989148965_487;
// undefined
o8 = null;
// 1247
f989148965_487.returns.push(1373483112186);
// 1248
o8 = {};
// 1249
f989148965_0.returns.push(o8);
// 1250
o8.getTime = f989148965_487;
// undefined
o8 = null;
// 1251
f989148965_487.returns.push(1373483112186);
// 1252
o8 = {};
// 1253
f989148965_0.returns.push(o8);
// 1254
o8.getTime = f989148965_487;
// undefined
o8 = null;
// 1255
f989148965_487.returns.push(1373483112187);
// 1256
o8 = {};
// 1257
f989148965_0.returns.push(o8);
// 1258
o8.getTime = f989148965_487;
// undefined
o8 = null;
// 1259
f989148965_487.returns.push(1373483112187);
// 1260
o8 = {};
// 1261
f989148965_0.returns.push(o8);
// 1262
o8.getTime = f989148965_487;
// undefined
o8 = null;
// 1263
f989148965_487.returns.push(1373483112187);
// 1264
o8 = {};
// 1265
f989148965_0.returns.push(o8);
// 1266
o8.getTime = f989148965_487;
// undefined
o8 = null;
// 1267
f989148965_487.returns.push(1373483112187);
// 1268
o8 = {};
// 1269
f989148965_0.returns.push(o8);
// 1270
o8.getTime = f989148965_487;
// undefined
o8 = null;
// 1271
f989148965_487.returns.push(1373483112188);
// 1272
o8 = {};
// 1273
f989148965_0.returns.push(o8);
// 1274
o8.getTime = f989148965_487;
// undefined
o8 = null;
// 1275
f989148965_487.returns.push(1373483112189);
// 1276
o8 = {};
// 1277
f989148965_0.returns.push(o8);
// 1278
o8.getTime = f989148965_487;
// undefined
o8 = null;
// 1279
f989148965_487.returns.push(1373483112189);
// 1280
o8 = {};
// 1281
f989148965_0.returns.push(o8);
// 1282
o8.getTime = f989148965_487;
// undefined
o8 = null;
// 1283
f989148965_487.returns.push(1373483112190);
// 1284
o8 = {};
// 1285
f989148965_0.returns.push(o8);
// 1286
o8.getTime = f989148965_487;
// undefined
o8 = null;
// 1287
f989148965_487.returns.push(1373483112190);
// 1288
o8 = {};
// 1289
f989148965_0.returns.push(o8);
// 1290
o8.getTime = f989148965_487;
// undefined
o8 = null;
// 1291
f989148965_487.returns.push(1373483112191);
// 1292
o8 = {};
// 1293
f989148965_0.returns.push(o8);
// 1294
o8.getTime = f989148965_487;
// undefined
o8 = null;
// 1295
f989148965_487.returns.push(1373483112191);
// 1296
f989148965_525 = function() { return f989148965_525.returns[f989148965_525.inst++]; };
f989148965_525.returns = [];
f989148965_525.inst = 0;
// 1297
o1.getItem = f989148965_525;
// 1298
f989148965_525.returns.push(null);
// 1300
f989148965_525.returns.push(null);
// 1301
o8 = {};
// 1302
f989148965_0.returns.push(o8);
// 1303
o8.getTime = f989148965_487;
// undefined
o8 = null;
// 1304
f989148965_487.returns.push(1373483112192);
// 1305
o8 = {};
// 1306
f989148965_0.returns.push(o8);
// 1307
o8.getTime = f989148965_487;
// undefined
o8 = null;
// 1308
f989148965_487.returns.push(1373483112192);
// 1309
o8 = {};
// 1310
f989148965_0.returns.push(o8);
// 1311
o8.getTime = f989148965_487;
// undefined
o8 = null;
// 1312
f989148965_487.returns.push(1373483112193);
// 1313
o8 = {};
// 1314
f989148965_0.returns.push(o8);
// 1315
o8.getTime = f989148965_487;
// undefined
o8 = null;
// 1316
f989148965_487.returns.push(1373483112193);
// 1317
o8 = {};
// 1318
f989148965_0.returns.push(o8);
// 1319
o8.getTime = f989148965_487;
// undefined
o8 = null;
// 1320
f989148965_487.returns.push(1373483112193);
// 1321
o8 = {};
// 1322
f989148965_0.returns.push(o8);
// 1323
o8.getTime = f989148965_487;
// undefined
o8 = null;
// 1324
f989148965_487.returns.push(1373483112193);
// 1330
o8 = {};
// 1331
f989148965_496.returns.push(o8);
// 1332
o8["0"] = o4;
// 1333
o8["1"] = void 0;
// undefined
o8 = null;
// 1334
o4.nodeType = 1;
// 1342
o8 = {};
// 1343
f989148965_474.returns.push(o8);
// 1344
o9 = {};
// 1345
o8["0"] = o9;
// 1346
o8["1"] = void 0;
// undefined
o8 = null;
// 1347
o9.nodeType = 1;
// 1348
o9.type = "hidden";
// 1349
o9.nodeName = "INPUT";
// 1350
o9.value = "app/pages/search/search";
// undefined
o9 = null;
// 1351
o8 = {};
// 1352
f989148965_0.returns.push(o8);
// 1353
o8.getTime = f989148965_487;
// undefined
o8 = null;
// 1354
f989148965_487.returns.push(1373483112200);
// 1355
o8 = {};
// 1356
f989148965_0.returns.push(o8);
// 1357
o8.getTime = f989148965_487;
// undefined
o8 = null;
// 1358
f989148965_487.returns.push(1373483112215);
// 1359
o3.cloneNode = f989148965_439;
// undefined
o3 = null;
// 1360
o3 = {};
// 1361
f989148965_439.returns.push(o3);
// 1362
// 1363
// 1364
// 1365
// 1366
// 1367
// 1368
// 1370
o5.parentNode = o6;
// undefined
o5 = null;
// 1371
o6.insertBefore = f989148965_463;
// 1373
f989148965_463.returns.push(o3);
// 1374
o5 = {};
// 1376
o5.target = o4;
// 1378
o4.tagName = "HTML";
// 1381
f989148965_419.returns.push(null);
// 1382
o5.metaKey = false;
// 1383
o5.clientX = 973;
// 1384
o5.shiftKey = false;
// 1387
o4.hostname = void 0;
// undefined
o4 = null;
// 1389
// 1390
// 1391
// 1392
o4 = {};
// 1394
o4.target = o7;
// 1396
o7.tagName = "BODY";
// 1398
o7.getAttribute = f989148965_419;
// 1399
f989148965_419.returns.push(null);
// 1400
o4.metaKey = false;
// 1401
o4.clientX = void 0;
// 1404
o7.hostname = void 0;
// 1406
// 1407
// 1408
// 1409
o8 = {};
// 1411
o8.target = o7;
// 1416
f989148965_419.returns.push(null);
// 1417
o8.metaKey = false;
// 1418
o8.clientX = void 0;
// 1423
// 1424
// 1425
// 1426
o9 = {};
// 1428
o9.target = o7;
// undefined
o7 = null;
// 1433
f989148965_419.returns.push(null);
// 1434
o9.metaKey = false;
// 1435
o9.clientX = void 0;
// 1440
// 1441
// 1442
// 1444
// 1445
// 1446
// 1447
// 1449
o7 = {};
// 1450
ow989148965.JSBNG__event = o7;
// 1451
o7.type = "load";
// undefined
o7 = null;
// 1452
// 1453
o7 = {};
// 1454
f989148965_0.returns.push(o7);
// 1455
o7.getTime = f989148965_487;
// undefined
o7 = null;
// 1456
f989148965_487.returns.push(1373483124915);
// 1457
o7 = {};
// 1458
f989148965_0.returns.push(o7);
// 1459
o7.getTime = f989148965_487;
// undefined
o7 = null;
// 1460
f989148965_487.returns.push(1373483124915);
// 1461
o7 = {};
// 1462
f989148965_0.returns.push(o7);
// 1463
o7.getTime = f989148965_487;
// undefined
o7 = null;
// 1464
f989148965_487.returns.push(1373483124917);
// 1465
o7 = {};
// 1466
f989148965_0.returns.push(o7);
// 1467
o7.getTime = f989148965_487;
// undefined
o7 = null;
// 1468
f989148965_487.returns.push(1373483124917);
// 1469
o7 = {};
// 1470
f989148965_0.returns.push(o7);
// 1471
o7.getTime = f989148965_487;
// undefined
o7 = null;
// 1472
f989148965_487.returns.push(1373483124918);
// 1473
o7 = {};
// 1474
f989148965_0.returns.push(o7);
// 1475
o7.getTime = f989148965_487;
// undefined
o7 = null;
// 1476
f989148965_487.returns.push(1373483124928);
// 1478
o7 = {};
// 1479
f989148965_439.returns.push(o7);
// 1480
// 1481
// 1482
// 1483
// 1484
// 1485
// 1486
// 1488
o3.parentNode = o6;
// undefined
o6 = null;
// 1491
f989148965_463.returns.push(o7);
// undefined
o7 = null;
// 1492
o6 = {};
// 1493
f989148965_0.returns.push(o6);
// 1494
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1495
f989148965_487.returns.push(1373483124930);
// 1496
o6 = {};
// 1497
f989148965_0.returns.push(o6);
// 1498
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1499
f989148965_487.returns.push(1373483124932);
// 1500
o6 = {};
// 1501
f989148965_0.returns.push(o6);
// 1502
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1503
f989148965_487.returns.push(1373483124933);
// 1504
o6 = {};
// 1505
f989148965_0.returns.push(o6);
// 1506
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1507
f989148965_487.returns.push(1373483124933);
// 1508
o6 = {};
// 1509
f989148965_0.returns.push(o6);
// 1510
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1511
f989148965_487.returns.push(1373483124934);
// 1512
o6 = {};
// 1513
f989148965_0.returns.push(o6);
// 1514
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1515
f989148965_487.returns.push(1373483124934);
// 1516
o6 = {};
// 1517
f989148965_0.returns.push(o6);
// 1518
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1519
f989148965_487.returns.push(1373483124935);
// 1520
o6 = {};
// 1521
f989148965_0.returns.push(o6);
// 1522
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1523
f989148965_487.returns.push(1373483124935);
// 1524
o6 = {};
// 1525
f989148965_0.returns.push(o6);
// 1526
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1527
f989148965_487.returns.push(1373483124935);
// 1528
o6 = {};
// 1529
f989148965_0.returns.push(o6);
// 1530
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1531
f989148965_487.returns.push(1373483124936);
// 1532
o6 = {};
// 1533
f989148965_0.returns.push(o6);
// 1534
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1535
f989148965_487.returns.push(1373483124936);
// 1536
o6 = {};
// 1537
f989148965_0.returns.push(o6);
// 1538
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1539
f989148965_487.returns.push(1373483124936);
// 1540
o6 = {};
// 1541
f989148965_0.returns.push(o6);
// 1542
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1543
f989148965_487.returns.push(1373483124936);
// 1544
o6 = {};
// 1545
f989148965_0.returns.push(o6);
// 1546
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1547
f989148965_487.returns.push(1373483124937);
// 1548
o6 = {};
// 1549
f989148965_0.returns.push(o6);
// 1550
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1551
f989148965_487.returns.push(1373483124937);
// 1552
o6 = {};
// 1553
f989148965_0.returns.push(o6);
// 1554
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1555
f989148965_487.returns.push(1373483124937);
// 1556
o6 = {};
// 1557
f989148965_0.returns.push(o6);
// 1558
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1559
f989148965_487.returns.push(1373483124941);
// 1560
o6 = {};
// 1561
f989148965_0.returns.push(o6);
// 1562
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1563
f989148965_487.returns.push(1373483124941);
// 1564
o6 = {};
// 1565
f989148965_0.returns.push(o6);
// 1566
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1567
f989148965_487.returns.push(1373483124942);
// 1568
o6 = {};
// 1569
f989148965_0.returns.push(o6);
// 1570
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1571
f989148965_487.returns.push(1373483124942);
// 1572
o6 = {};
// 1573
f989148965_0.returns.push(o6);
// 1574
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1575
f989148965_487.returns.push(1373483124943);
// 1576
o6 = {};
// 1577
f989148965_0.returns.push(o6);
// 1578
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1579
f989148965_487.returns.push(1373483124943);
// 1580
o6 = {};
// 1581
f989148965_0.returns.push(o6);
// 1582
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1583
f989148965_487.returns.push(1373483124943);
// 1584
o6 = {};
// 1585
f989148965_0.returns.push(o6);
// 1586
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1587
f989148965_487.returns.push(1373483124943);
// 1588
o6 = {};
// 1589
f989148965_0.returns.push(o6);
// 1590
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1591
f989148965_487.returns.push(1373483124943);
// 1592
o6 = {};
// 1593
f989148965_0.returns.push(o6);
// 1594
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1595
f989148965_487.returns.push(1373483124944);
// 1596
o6 = {};
// 1597
f989148965_0.returns.push(o6);
// 1598
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1599
f989148965_487.returns.push(1373483124944);
// 1600
o6 = {};
// 1601
f989148965_0.returns.push(o6);
// 1602
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1603
f989148965_487.returns.push(1373483124944);
// 1604
o6 = {};
// 1605
f989148965_0.returns.push(o6);
// 1606
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1607
f989148965_487.returns.push(1373483124944);
// 1608
o6 = {};
// 1609
f989148965_0.returns.push(o6);
// 1610
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1611
f989148965_487.returns.push(1373483124944);
// 1612
o6 = {};
// 1613
f989148965_0.returns.push(o6);
// 1614
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1615
f989148965_487.returns.push(1373483124945);
// 1616
o6 = {};
// 1617
f989148965_0.returns.push(o6);
// 1618
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1619
f989148965_487.returns.push(1373483124945);
// 1620
o6 = {};
// 1621
f989148965_0.returns.push(o6);
// 1622
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1623
f989148965_487.returns.push(1373483124945);
// 1624
o6 = {};
// 1625
f989148965_0.returns.push(o6);
// 1626
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1627
f989148965_487.returns.push(1373483124945);
// 1628
o6 = {};
// 1629
f989148965_0.returns.push(o6);
// 1630
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1631
f989148965_487.returns.push(1373483124946);
// 1632
o6 = {};
// 1633
f989148965_0.returns.push(o6);
// 1634
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1635
f989148965_487.returns.push(1373483124946);
// 1636
o6 = {};
// 1637
f989148965_0.returns.push(o6);
// 1638
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1639
f989148965_487.returns.push(1373483124946);
// 1640
o6 = {};
// 1641
f989148965_0.returns.push(o6);
// 1642
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1643
f989148965_487.returns.push(1373483124946);
// 1644
o6 = {};
// 1645
f989148965_0.returns.push(o6);
// 1646
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1647
f989148965_487.returns.push(1373483124946);
// 1648
o6 = {};
// 1649
f989148965_0.returns.push(o6);
// 1650
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1651
f989148965_487.returns.push(1373483124947);
// 1652
o6 = {};
// 1653
f989148965_0.returns.push(o6);
// 1654
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1655
f989148965_487.returns.push(1373483124947);
// 1656
o6 = {};
// 1657
f989148965_0.returns.push(o6);
// 1658
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1659
f989148965_487.returns.push(1373483124947);
// 1660
o6 = {};
// 1661
f989148965_0.returns.push(o6);
// 1662
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1663
f989148965_487.returns.push(1373483124947);
// 1664
o6 = {};
// 1665
f989148965_0.returns.push(o6);
// 1666
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1667
f989148965_487.returns.push(1373483124951);
// 1668
o6 = {};
// 1669
f989148965_0.returns.push(o6);
// 1670
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1671
f989148965_487.returns.push(1373483124951);
// 1672
o6 = {};
// 1673
f989148965_0.returns.push(o6);
// 1674
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1675
f989148965_487.returns.push(1373483124951);
// 1676
o6 = {};
// 1677
f989148965_0.returns.push(o6);
// 1678
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1679
f989148965_487.returns.push(1373483124952);
// 1680
o6 = {};
// 1681
f989148965_0.returns.push(o6);
// 1682
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1683
f989148965_487.returns.push(1373483124952);
// 1684
o6 = {};
// 1685
f989148965_0.returns.push(o6);
// 1686
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1687
f989148965_487.returns.push(1373483124952);
// 1688
o6 = {};
// 1689
f989148965_0.returns.push(o6);
// 1690
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1691
f989148965_487.returns.push(1373483124952);
// 1692
o6 = {};
// 1693
f989148965_0.returns.push(o6);
// 1694
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1695
f989148965_487.returns.push(1373483124952);
// 1696
o6 = {};
// 1697
f989148965_0.returns.push(o6);
// 1698
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1699
f989148965_487.returns.push(1373483124952);
// 1700
o6 = {};
// 1701
f989148965_0.returns.push(o6);
// 1702
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1703
f989148965_487.returns.push(1373483124952);
// 1704
o6 = {};
// 1705
f989148965_0.returns.push(o6);
// 1706
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1707
f989148965_487.returns.push(1373483124953);
// 1708
o6 = {};
// 1709
f989148965_0.returns.push(o6);
// 1710
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1711
f989148965_487.returns.push(1373483124953);
// 1712
o6 = {};
// 1713
f989148965_0.returns.push(o6);
// 1714
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1715
f989148965_487.returns.push(1373483124954);
// 1716
o6 = {};
// 1717
f989148965_0.returns.push(o6);
// 1718
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1719
f989148965_487.returns.push(1373483124954);
// 1720
o6 = {};
// 1721
f989148965_0.returns.push(o6);
// 1722
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1723
f989148965_487.returns.push(1373483124954);
// 1724
o6 = {};
// 1725
f989148965_0.returns.push(o6);
// 1726
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1727
f989148965_487.returns.push(1373483124957);
// 1728
o6 = {};
// 1729
f989148965_0.returns.push(o6);
// 1730
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1731
f989148965_487.returns.push(1373483124957);
// 1732
o6 = {};
// 1733
f989148965_0.returns.push(o6);
// 1734
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1735
f989148965_487.returns.push(1373483124957);
// 1736
o6 = {};
// 1737
f989148965_0.returns.push(o6);
// 1738
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1739
f989148965_487.returns.push(1373483124958);
// 1740
o6 = {};
// 1741
f989148965_0.returns.push(o6);
// 1742
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1743
f989148965_487.returns.push(1373483124958);
// 1744
o6 = {};
// 1745
f989148965_0.returns.push(o6);
// 1746
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1747
f989148965_487.returns.push(1373483124958);
// 1748
o6 = {};
// 1749
f989148965_0.returns.push(o6);
// 1750
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1751
f989148965_487.returns.push(1373483124959);
// 1752
o6 = {};
// 1753
f989148965_0.returns.push(o6);
// 1754
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1755
f989148965_487.returns.push(1373483124959);
// 1756
o6 = {};
// 1757
f989148965_0.returns.push(o6);
// 1758
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1759
f989148965_487.returns.push(1373483124959);
// 1760
o6 = {};
// 1761
f989148965_0.returns.push(o6);
// 1762
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1763
f989148965_487.returns.push(1373483124959);
// 1764
o6 = {};
// 1765
f989148965_0.returns.push(o6);
// 1766
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1767
f989148965_487.returns.push(1373483124959);
// 1768
o6 = {};
// 1769
f989148965_0.returns.push(o6);
// 1770
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1771
f989148965_487.returns.push(1373483124960);
// 1772
o6 = {};
// 1773
f989148965_0.returns.push(o6);
// 1774
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1775
f989148965_487.returns.push(1373483124966);
// 1776
o6 = {};
// 1777
f989148965_0.returns.push(o6);
// 1778
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1779
f989148965_487.returns.push(1373483124967);
// 1780
o6 = {};
// 1781
f989148965_0.returns.push(o6);
// 1782
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1783
f989148965_487.returns.push(1373483124967);
// 1784
o6 = {};
// 1785
f989148965_0.returns.push(o6);
// 1786
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1787
f989148965_487.returns.push(1373483124968);
// 1788
o6 = {};
// 1789
f989148965_0.returns.push(o6);
// 1790
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1791
f989148965_487.returns.push(1373483124968);
// 1792
o6 = {};
// 1793
f989148965_0.returns.push(o6);
// 1794
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1795
f989148965_487.returns.push(1373483124968);
// 1796
o6 = {};
// 1797
f989148965_0.returns.push(o6);
// 1798
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1799
f989148965_487.returns.push(1373483124969);
// 1800
o6 = {};
// 1801
f989148965_0.returns.push(o6);
// 1802
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1803
f989148965_487.returns.push(1373483124969);
// 1804
o6 = {};
// 1805
f989148965_0.returns.push(o6);
// 1806
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1807
f989148965_487.returns.push(1373483124969);
// 1808
o6 = {};
// 1809
f989148965_0.returns.push(o6);
// 1810
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1811
f989148965_487.returns.push(1373483124969);
// 1812
o6 = {};
// 1813
f989148965_0.returns.push(o6);
// 1814
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1815
f989148965_487.returns.push(1373483124970);
// 1816
o6 = {};
// 1817
f989148965_0.returns.push(o6);
// 1818
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1819
f989148965_487.returns.push(1373483124970);
// 1820
o6 = {};
// 1821
f989148965_0.returns.push(o6);
// 1822
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1823
f989148965_487.returns.push(1373483124971);
// 1824
o6 = {};
// 1825
f989148965_0.returns.push(o6);
// 1826
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1827
f989148965_487.returns.push(1373483124971);
// 1828
o6 = {};
// 1829
f989148965_0.returns.push(o6);
// 1830
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1831
f989148965_487.returns.push(1373483124971);
// 1832
o6 = {};
// 1833
f989148965_0.returns.push(o6);
// 1834
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1835
f989148965_487.returns.push(1373483124972);
// 1836
o6 = {};
// 1837
f989148965_0.returns.push(o6);
// 1838
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1839
f989148965_487.returns.push(1373483124973);
// 1840
o6 = {};
// 1841
f989148965_0.returns.push(o6);
// 1842
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1843
f989148965_487.returns.push(1373483124973);
// 1844
o6 = {};
// 1845
f989148965_0.returns.push(o6);
// 1846
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1847
f989148965_487.returns.push(1373483124973);
// 1848
o6 = {};
// 1849
f989148965_0.returns.push(o6);
// 1850
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1851
f989148965_487.returns.push(1373483124974);
// 1852
o6 = {};
// 1853
f989148965_0.returns.push(o6);
// 1854
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1855
f989148965_487.returns.push(1373483124974);
// 1856
o6 = {};
// 1857
f989148965_0.returns.push(o6);
// 1858
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1859
f989148965_487.returns.push(1373483124974);
// 1860
o6 = {};
// 1861
f989148965_0.returns.push(o6);
// 1862
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1863
f989148965_487.returns.push(1373483124975);
// 1864
o6 = {};
// 1865
f989148965_0.returns.push(o6);
// 1866
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1867
f989148965_487.returns.push(1373483124975);
// 1868
o6 = {};
// 1869
f989148965_0.returns.push(o6);
// 1870
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1871
f989148965_487.returns.push(1373483124975);
// 1872
o6 = {};
// 1873
f989148965_0.returns.push(o6);
// 1874
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1875
f989148965_487.returns.push(1373483124976);
// 1876
o6 = {};
// 1877
f989148965_0.returns.push(o6);
// 1878
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1879
f989148965_487.returns.push(1373483124977);
// 1880
o6 = {};
// 1881
f989148965_0.returns.push(o6);
// 1882
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1883
f989148965_487.returns.push(1373483124981);
// 1884
o6 = {};
// 1885
f989148965_0.returns.push(o6);
// 1886
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1887
f989148965_487.returns.push(1373483124981);
// 1888
o6 = {};
// 1889
f989148965_0.returns.push(o6);
// 1890
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1891
f989148965_487.returns.push(1373483124981);
// 1892
o6 = {};
// 1893
f989148965_0.returns.push(o6);
// 1894
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1895
f989148965_487.returns.push(1373483124981);
// 1896
o6 = {};
// 1897
f989148965_0.returns.push(o6);
// 1898
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1899
f989148965_487.returns.push(1373483124982);
// 1900
o6 = {};
// 1901
f989148965_0.returns.push(o6);
// 1902
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1903
f989148965_487.returns.push(1373483124982);
// 1904
o6 = {};
// 1905
f989148965_0.returns.push(o6);
// 1906
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1907
f989148965_487.returns.push(1373483124983);
// 1908
o6 = {};
// 1909
f989148965_0.returns.push(o6);
// 1910
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1911
f989148965_487.returns.push(1373483124993);
// 1912
o6 = {};
// 1913
f989148965_0.returns.push(o6);
// 1914
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1915
f989148965_487.returns.push(1373483124993);
// 1916
o6 = {};
// 1917
f989148965_0.returns.push(o6);
// 1918
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1919
f989148965_487.returns.push(1373483124993);
// 1920
o6 = {};
// 1921
f989148965_0.returns.push(o6);
// 1922
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1923
f989148965_487.returns.push(1373483124993);
// 1924
o6 = {};
// 1925
f989148965_0.returns.push(o6);
// 1926
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1927
f989148965_487.returns.push(1373483124994);
// 1928
o6 = {};
// 1929
f989148965_0.returns.push(o6);
// 1930
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1931
f989148965_487.returns.push(1373483124994);
// 1932
o6 = {};
// 1933
f989148965_0.returns.push(o6);
// 1934
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1935
f989148965_487.returns.push(1373483124995);
// 1936
o6 = {};
// 1937
f989148965_0.returns.push(o6);
// 1938
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1939
f989148965_487.returns.push(1373483124995);
// 1940
o6 = {};
// 1941
f989148965_0.returns.push(o6);
// 1942
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1943
f989148965_487.returns.push(1373483124995);
// 1944
o6 = {};
// 1945
f989148965_0.returns.push(o6);
// 1946
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1947
f989148965_487.returns.push(1373483124995);
// 1948
o6 = {};
// 1949
f989148965_0.returns.push(o6);
// 1950
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1951
f989148965_487.returns.push(1373483124996);
// 1952
o6 = {};
// 1953
f989148965_0.returns.push(o6);
// 1954
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1955
f989148965_487.returns.push(1373483124996);
// 1956
o6 = {};
// 1957
f989148965_0.returns.push(o6);
// 1958
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1959
f989148965_487.returns.push(1373483124997);
// 1960
o6 = {};
// 1961
f989148965_0.returns.push(o6);
// 1962
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1963
f989148965_487.returns.push(1373483124997);
// 1964
o6 = {};
// 1965
f989148965_0.returns.push(o6);
// 1966
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1967
f989148965_487.returns.push(1373483124997);
// 1968
o6 = {};
// 1969
f989148965_0.returns.push(o6);
// 1970
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1971
f989148965_487.returns.push(1373483124997);
// 1972
o6 = {};
// 1973
f989148965_0.returns.push(o6);
// 1974
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1975
f989148965_487.returns.push(1373483124998);
// 1976
o6 = {};
// 1977
f989148965_0.returns.push(o6);
// 1978
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1979
f989148965_487.returns.push(1373483124998);
// 1980
o6 = {};
// 1981
f989148965_0.returns.push(o6);
// 1982
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1983
f989148965_487.returns.push(1373483124998);
// 1984
o6 = {};
// 1985
f989148965_0.returns.push(o6);
// 1986
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1987
f989148965_487.returns.push(1373483124999);
// 1988
o6 = {};
// 1989
f989148965_0.returns.push(o6);
// 1990
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1991
f989148965_487.returns.push(1373483125005);
// 1992
o6 = {};
// 1993
f989148965_0.returns.push(o6);
// 1994
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1995
f989148965_487.returns.push(1373483125006);
// 1996
o6 = {};
// 1997
f989148965_0.returns.push(o6);
// 1998
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 1999
f989148965_487.returns.push(1373483125007);
// 2000
o6 = {};
// 2001
f989148965_0.returns.push(o6);
// 2002
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 2003
f989148965_487.returns.push(1373483125007);
// 2004
o6 = {};
// 2005
f989148965_0.returns.push(o6);
// 2006
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 2007
f989148965_487.returns.push(1373483125007);
// 2008
o6 = {};
// 2009
f989148965_0.returns.push(o6);
// 2010
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 2011
f989148965_487.returns.push(1373483125008);
// 2012
o6 = {};
// 2013
f989148965_0.returns.push(o6);
// 2014
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 2015
f989148965_487.returns.push(1373483125008);
// 2016
o6 = {};
// 2017
f989148965_0.returns.push(o6);
// 2018
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 2019
f989148965_487.returns.push(1373483125008);
// 2020
o6 = {};
// 2021
f989148965_0.returns.push(o6);
// 2022
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 2023
f989148965_487.returns.push(1373483125008);
// 2024
o6 = {};
// 2025
f989148965_0.returns.push(o6);
// 2026
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 2027
f989148965_487.returns.push(1373483125008);
// 2028
o6 = {};
// 2029
f989148965_0.returns.push(o6);
// 2030
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 2031
f989148965_487.returns.push(1373483125009);
// 2032
o6 = {};
// 2033
f989148965_0.returns.push(o6);
// 2034
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 2035
f989148965_487.returns.push(1373483125009);
// 2036
o6 = {};
// 2037
f989148965_0.returns.push(o6);
// 2038
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 2039
f989148965_487.returns.push(1373483125009);
// 2040
o6 = {};
// 2041
f989148965_0.returns.push(o6);
// 2042
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 2043
f989148965_487.returns.push(1373483125010);
// 2044
o6 = {};
// 2045
f989148965_0.returns.push(o6);
// 2046
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 2047
f989148965_487.returns.push(1373483125010);
// 2048
o6 = {};
// 2049
f989148965_0.returns.push(o6);
// 2050
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 2051
f989148965_487.returns.push(1373483125010);
// 2052
o6 = {};
// 2053
f989148965_0.returns.push(o6);
// 2054
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 2055
f989148965_487.returns.push(1373483125010);
// 2056
o6 = {};
// 2057
f989148965_0.returns.push(o6);
// 2058
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 2059
f989148965_487.returns.push(1373483125010);
// 2060
o6 = {};
// 2061
f989148965_0.returns.push(o6);
// 2062
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 2063
f989148965_487.returns.push(1373483125010);
// 2064
o6 = {};
// 2065
f989148965_0.returns.push(o6);
// 2066
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 2067
f989148965_487.returns.push(1373483125011);
// 2068
o6 = {};
// 2069
f989148965_0.returns.push(o6);
// 2070
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 2071
f989148965_487.returns.push(1373483125011);
// 2072
o6 = {};
// 2073
f989148965_0.returns.push(o6);
// 2074
o6.getTime = f989148965_487;
// undefined
o6 = null;
// 2075
f989148965_487.returns.push(1373483125011);
// 2076
f989148965_696 = function() { return f989148965_696.returns[f989148965_696.inst++]; };
f989148965_696.returns = [];
f989148965_696.inst = 0;
// 2077
o1.setItem = f989148965_696;
// 2078
f989148965_696.returns.push(undefined);
// 2079
f989148965_697 = function() { return f989148965_697.returns[f989148965_697.inst++]; };
f989148965_697.returns = [];
f989148965_697.inst = 0;
// 2080
o1.removeItem = f989148965_697;
// undefined
o1 = null;
// 2081
f989148965_697.returns.push(undefined);
// 2082
o1 = {};
// 2083
f989148965_0.returns.push(o1);
// 2084
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2085
f989148965_487.returns.push(1373483125012);
// 2086
o1 = {};
// 2087
f989148965_0.returns.push(o1);
// 2088
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2089
f989148965_487.returns.push(1373483125013);
// 2090
o1 = {};
// 2091
f989148965_0.returns.push(o1);
// 2092
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2093
f989148965_487.returns.push(1373483125013);
// 2094
o1 = {};
// 2095
f989148965_0.returns.push(o1);
// 2096
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2097
f989148965_487.returns.push(1373483125018);
// 2098
o1 = {};
// 2099
f989148965_0.returns.push(o1);
// 2100
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2101
f989148965_487.returns.push(1373483125018);
// 2102
o1 = {};
// 2103
f989148965_0.returns.push(o1);
// 2104
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2105
f989148965_487.returns.push(1373483125019);
// 2106
o1 = {};
// 2107
f989148965_0.returns.push(o1);
// 2108
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2109
f989148965_487.returns.push(1373483125019);
// 2110
o1 = {};
// 2111
f989148965_0.returns.push(o1);
// 2112
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2113
f989148965_487.returns.push(1373483125020);
// 2114
o1 = {};
// 2115
f989148965_0.returns.push(o1);
// 2116
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2117
f989148965_487.returns.push(1373483125020);
// 2118
o1 = {};
// 2119
f989148965_0.returns.push(o1);
// 2120
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2121
f989148965_487.returns.push(1373483125021);
// 2122
o1 = {};
// 2123
f989148965_0.returns.push(o1);
// 2124
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2125
f989148965_487.returns.push(1373483125021);
// 2126
o1 = {};
// 2127
f989148965_0.returns.push(o1);
// 2128
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2129
f989148965_487.returns.push(1373483125021);
// 2130
o1 = {};
// 2131
f989148965_0.returns.push(o1);
// 2132
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2133
f989148965_487.returns.push(1373483125021);
// 2134
o1 = {};
// 2135
f989148965_0.returns.push(o1);
// 2136
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2137
f989148965_487.returns.push(1373483125022);
// 2138
o1 = {};
// 2139
f989148965_0.returns.push(o1);
// 2140
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2141
f989148965_487.returns.push(1373483125022);
// 2142
o1 = {};
// 2143
f989148965_0.returns.push(o1);
// 2144
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2145
f989148965_487.returns.push(1373483125022);
// 2146
o1 = {};
// 2147
f989148965_0.returns.push(o1);
// 2148
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2149
f989148965_487.returns.push(1373483125023);
// 2150
o1 = {};
// 2151
f989148965_0.returns.push(o1);
// 2152
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2153
f989148965_487.returns.push(1373483125023);
// 2154
o1 = {};
// 2155
f989148965_0.returns.push(o1);
// 2156
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2157
f989148965_487.returns.push(1373483125023);
// 2158
o1 = {};
// 2159
f989148965_0.returns.push(o1);
// 2160
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2161
f989148965_487.returns.push(1373483125023);
// 2162
o1 = {};
// 2163
f989148965_0.returns.push(o1);
// 2164
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2165
f989148965_487.returns.push(1373483125024);
// 2166
o1 = {};
// 2167
f989148965_0.returns.push(o1);
// 2168
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2169
f989148965_487.returns.push(1373483125024);
// 2170
o1 = {};
// 2171
f989148965_0.returns.push(o1);
// 2172
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2173
f989148965_487.returns.push(1373483125024);
// 2174
o1 = {};
// 2175
f989148965_0.returns.push(o1);
// 2176
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2177
f989148965_487.returns.push(1373483125025);
// 2178
o1 = {};
// 2179
f989148965_0.returns.push(o1);
// 2180
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2181
f989148965_487.returns.push(1373483125025);
// 2182
o1 = {};
// 2183
f989148965_0.returns.push(o1);
// 2184
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2185
f989148965_487.returns.push(1373483125026);
// 2186
o1 = {};
// 2187
f989148965_0.returns.push(o1);
// 2188
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2189
f989148965_487.returns.push(1373483125026);
// 2190
o1 = {};
// 2191
f989148965_0.returns.push(o1);
// 2192
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2193
f989148965_487.returns.push(1373483125026);
// 2194
o1 = {};
// 2195
f989148965_0.returns.push(o1);
// 2196
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2197
f989148965_487.returns.push(1373483125026);
// 2198
o1 = {};
// 2199
f989148965_0.returns.push(o1);
// 2200
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2201
f989148965_487.returns.push(1373483125027);
// 2202
o1 = {};
// 2203
f989148965_0.returns.push(o1);
// 2204
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2205
f989148965_487.returns.push(1373483125034);
// 2206
o1 = {};
// 2207
f989148965_0.returns.push(o1);
// 2208
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2209
f989148965_487.returns.push(1373483125034);
// 2210
o1 = {};
// 2211
f989148965_0.returns.push(o1);
// 2212
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2213
f989148965_487.returns.push(1373483125035);
// 2214
o1 = {};
// 2215
f989148965_0.returns.push(o1);
// 2216
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2217
f989148965_487.returns.push(1373483125035);
// 2218
o1 = {};
// 2219
f989148965_0.returns.push(o1);
// 2220
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2221
f989148965_487.returns.push(1373483125035);
// 2222
o1 = {};
// 2223
f989148965_0.returns.push(o1);
// 2224
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2225
f989148965_487.returns.push(1373483125036);
// 2226
o1 = {};
// 2227
f989148965_0.returns.push(o1);
// 2228
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2229
f989148965_487.returns.push(1373483125036);
// 2230
o1 = {};
// 2231
f989148965_0.returns.push(o1);
// 2232
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2233
f989148965_487.returns.push(1373483125036);
// 2234
o1 = {};
// 2235
f989148965_0.returns.push(o1);
// 2236
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2237
f989148965_487.returns.push(1373483125037);
// 2238
o1 = {};
// 2239
f989148965_0.returns.push(o1);
// 2240
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2241
f989148965_487.returns.push(1373483125037);
// 2242
o1 = {};
// 2243
f989148965_0.returns.push(o1);
// 2244
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2245
f989148965_487.returns.push(1373483125037);
// 2246
o1 = {};
// 2247
f989148965_0.returns.push(o1);
// 2248
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2249
f989148965_487.returns.push(1373483125038);
// 2250
o1 = {};
// 2251
f989148965_0.returns.push(o1);
// 2252
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2253
f989148965_487.returns.push(1373483125038);
// 2254
o1 = {};
// 2255
f989148965_0.returns.push(o1);
// 2256
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2257
f989148965_487.returns.push(1373483125038);
// 2258
o1 = {};
// 2259
f989148965_0.returns.push(o1);
// 2260
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2261
f989148965_487.returns.push(1373483125038);
// 2262
o1 = {};
// 2263
f989148965_0.returns.push(o1);
// 2264
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2265
f989148965_487.returns.push(1373483125038);
// 2266
o1 = {};
// 2267
f989148965_0.returns.push(o1);
// 2268
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2269
f989148965_487.returns.push(1373483125039);
// 2270
o1 = {};
// 2271
f989148965_0.returns.push(o1);
// 2272
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2273
f989148965_487.returns.push(1373483125039);
// 2274
o1 = {};
// 2275
f989148965_0.returns.push(o1);
// 2276
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2277
f989148965_487.returns.push(1373483125039);
// 2278
o1 = {};
// 2279
f989148965_0.returns.push(o1);
// 2280
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2281
f989148965_487.returns.push(1373483125039);
// 2282
o1 = {};
// 2283
f989148965_0.returns.push(o1);
// 2284
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2285
f989148965_487.returns.push(1373483125039);
// 2286
o1 = {};
// 2287
f989148965_0.returns.push(o1);
// 2288
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2289
f989148965_487.returns.push(1373483125039);
// 2290
o1 = {};
// 2291
f989148965_0.returns.push(o1);
// 2292
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2293
f989148965_487.returns.push(1373483125040);
// 2294
o1 = {};
// 2295
f989148965_0.returns.push(o1);
// 2296
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2297
f989148965_487.returns.push(1373483125040);
// 2298
o1 = {};
// 2299
f989148965_0.returns.push(o1);
// 2300
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2301
f989148965_487.returns.push(1373483125040);
// 2302
o1 = {};
// 2303
f989148965_0.returns.push(o1);
// 2304
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2305
f989148965_487.returns.push(1373483125040);
// 2306
o1 = {};
// 2307
f989148965_0.returns.push(o1);
// 2308
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2309
f989148965_487.returns.push(1373483125042);
// 2310
o1 = {};
// 2311
f989148965_0.returns.push(o1);
// 2312
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2313
f989148965_487.returns.push(1373483125046);
// 2314
o1 = {};
// 2315
f989148965_0.returns.push(o1);
// 2316
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2317
f989148965_487.returns.push(1373483125046);
// 2318
o1 = {};
// 2319
f989148965_0.returns.push(o1);
// 2320
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2321
f989148965_487.returns.push(1373483125046);
// 2322
o1 = {};
// 2323
f989148965_0.returns.push(o1);
// 2324
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2325
f989148965_487.returns.push(1373483125047);
// 2326
o1 = {};
// 2327
f989148965_0.returns.push(o1);
// 2328
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2329
f989148965_487.returns.push(1373483125047);
// 2330
o1 = {};
// 2331
f989148965_0.returns.push(o1);
// 2332
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2333
f989148965_487.returns.push(1373483125047);
// 2334
o1 = {};
// 2335
f989148965_0.returns.push(o1);
// 2336
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2337
f989148965_487.returns.push(1373483125048);
// 2338
o1 = {};
// 2339
f989148965_0.returns.push(o1);
// 2340
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2341
f989148965_487.returns.push(1373483125048);
// 2342
o1 = {};
// 2343
f989148965_0.returns.push(o1);
// 2344
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2345
f989148965_487.returns.push(1373483125048);
// 2346
o1 = {};
// 2347
f989148965_0.returns.push(o1);
// 2348
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2349
f989148965_487.returns.push(1373483125048);
// 2350
o1 = {};
// 2351
f989148965_0.returns.push(o1);
// 2352
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2353
f989148965_487.returns.push(1373483125048);
// 2354
o1 = {};
// 2355
f989148965_0.returns.push(o1);
// 2356
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2357
f989148965_487.returns.push(1373483125048);
// 2358
o1 = {};
// 2359
f989148965_0.returns.push(o1);
// 2360
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2361
f989148965_487.returns.push(1373483125049);
// 2362
o1 = {};
// 2363
f989148965_0.returns.push(o1);
// 2364
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2365
f989148965_487.returns.push(1373483125049);
// 2366
o1 = {};
// 2367
f989148965_0.returns.push(o1);
// 2368
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2369
f989148965_487.returns.push(1373483125049);
// 2370
o1 = {};
// 2371
f989148965_0.returns.push(o1);
// 2372
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2373
f989148965_487.returns.push(1373483125049);
// 2374
o1 = {};
// 2375
f989148965_0.returns.push(o1);
// 2376
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2377
f989148965_487.returns.push(1373483125049);
// 2378
o1 = {};
// 2379
f989148965_0.returns.push(o1);
// 2380
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2381
f989148965_487.returns.push(1373483125050);
// 2382
o1 = {};
// 2383
f989148965_0.returns.push(o1);
// 2384
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2385
f989148965_487.returns.push(1373483125050);
// 2386
o1 = {};
// 2387
f989148965_0.returns.push(o1);
// 2388
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2389
f989148965_487.returns.push(1373483125050);
// 2390
o1 = {};
// 2391
f989148965_0.returns.push(o1);
// 2392
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2393
f989148965_487.returns.push(1373483125050);
// 2394
o1 = {};
// 2395
f989148965_0.returns.push(o1);
// 2396
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2397
f989148965_487.returns.push(1373483125050);
// 2398
o1 = {};
// 2399
f989148965_0.returns.push(o1);
// 2400
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2401
f989148965_487.returns.push(1373483125050);
// 2402
o1 = {};
// 2403
f989148965_0.returns.push(o1);
// 2404
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2405
f989148965_487.returns.push(1373483125051);
// 2406
o1 = {};
// 2407
f989148965_0.returns.push(o1);
// 2408
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2409
f989148965_487.returns.push(1373483125051);
// 2410
o1 = {};
// 2411
f989148965_0.returns.push(o1);
// 2412
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2413
f989148965_487.returns.push(1373483125051);
// 2414
o1 = {};
// 2415
f989148965_0.returns.push(o1);
// 2416
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2417
f989148965_487.returns.push(1373483125051);
// 2418
o1 = {};
// 2419
f989148965_0.returns.push(o1);
// 2420
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2421
f989148965_487.returns.push(1373483125056);
// 2422
o1 = {};
// 2423
f989148965_0.returns.push(o1);
// 2424
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2425
f989148965_487.returns.push(1373483125058);
// 2426
o1 = {};
// 2427
f989148965_0.returns.push(o1);
// 2428
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2429
f989148965_487.returns.push(1373483125058);
// 2430
o1 = {};
// 2431
f989148965_0.returns.push(o1);
// 2432
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2433
f989148965_487.returns.push(1373483125058);
// 2434
o1 = {};
// 2435
f989148965_0.returns.push(o1);
// 2436
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2437
f989148965_487.returns.push(1373483125061);
// 2438
o1 = {};
// 2439
f989148965_0.returns.push(o1);
// 2440
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2441
f989148965_487.returns.push(1373483125061);
// 2442
o1 = {};
// 2443
f989148965_0.returns.push(o1);
// 2444
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2445
f989148965_487.returns.push(1373483125062);
// 2446
o1 = {};
// 2447
f989148965_0.returns.push(o1);
// 2448
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2449
f989148965_487.returns.push(1373483125062);
// 2450
o1 = {};
// 2451
f989148965_0.returns.push(o1);
// 2452
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2453
f989148965_487.returns.push(1373483125063);
// 2454
o1 = {};
// 2455
f989148965_0.returns.push(o1);
// 2456
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2457
f989148965_487.returns.push(1373483125063);
// 2458
o1 = {};
// 2459
f989148965_0.returns.push(o1);
// 2460
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2461
f989148965_487.returns.push(1373483125063);
// 2462
o1 = {};
// 2463
f989148965_0.returns.push(o1);
// 2464
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2465
f989148965_487.returns.push(1373483125064);
// 2466
o1 = {};
// 2467
f989148965_0.returns.push(o1);
// 2468
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2469
f989148965_487.returns.push(1373483125064);
// 2470
o1 = {};
// 2471
f989148965_0.returns.push(o1);
// 2472
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2473
f989148965_487.returns.push(1373483125064);
// 2474
o1 = {};
// 2475
f989148965_0.returns.push(o1);
// 2476
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2477
f989148965_487.returns.push(1373483125065);
// 2478
o1 = {};
// 2479
f989148965_0.returns.push(o1);
// 2480
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2481
f989148965_487.returns.push(1373483125065);
// 2482
o1 = {};
// 2483
f989148965_0.returns.push(o1);
// 2484
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2485
f989148965_487.returns.push(1373483125065);
// 2486
o1 = {};
// 2487
f989148965_0.returns.push(o1);
// 2488
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2489
f989148965_487.returns.push(1373483125065);
// 2490
o1 = {};
// 2491
f989148965_0.returns.push(o1);
// 2492
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2493
f989148965_487.returns.push(1373483125065);
// 2494
o1 = {};
// 2495
f989148965_0.returns.push(o1);
// 2496
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2497
f989148965_487.returns.push(1373483125065);
// 2498
o1 = {};
// 2499
f989148965_0.returns.push(o1);
// 2500
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2501
f989148965_487.returns.push(1373483125066);
// 2502
o1 = {};
// 2503
f989148965_0.returns.push(o1);
// 2504
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2505
f989148965_487.returns.push(1373483125066);
// 2506
o1 = {};
// 2507
f989148965_0.returns.push(o1);
// 2508
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2509
f989148965_487.returns.push(1373483125066);
// 2510
o1 = {};
// 2511
f989148965_0.returns.push(o1);
// 2512
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2513
f989148965_487.returns.push(1373483125066);
// 2514
o1 = {};
// 2515
f989148965_0.returns.push(o1);
// 2516
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2517
f989148965_487.returns.push(1373483125066);
// 2518
o1 = {};
// 2519
f989148965_0.returns.push(o1);
// 2520
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2521
f989148965_487.returns.push(1373483125067);
// 2522
o1 = {};
// 2523
f989148965_0.returns.push(o1);
// 2524
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2525
f989148965_487.returns.push(1373483125067);
// 2526
o1 = {};
// 2527
f989148965_0.returns.push(o1);
// 2528
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2529
f989148965_487.returns.push(1373483125073);
// 2530
o1 = {};
// 2531
f989148965_0.returns.push(o1);
// 2532
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2533
f989148965_487.returns.push(1373483125073);
// 2534
o1 = {};
// 2535
f989148965_0.returns.push(o1);
// 2536
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2537
f989148965_487.returns.push(1373483125074);
// 2538
o1 = {};
// 2539
f989148965_0.returns.push(o1);
// 2540
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2541
f989148965_487.returns.push(1373483125074);
// 2542
o1 = {};
// 2543
f989148965_0.returns.push(o1);
// 2544
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2545
f989148965_487.returns.push(1373483125074);
// 2546
o1 = {};
// 2547
f989148965_0.returns.push(o1);
// 2548
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2549
f989148965_487.returns.push(1373483125074);
// 2550
o1 = {};
// 2551
f989148965_0.returns.push(o1);
// 2552
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2553
f989148965_487.returns.push(1373483125075);
// 2554
o1 = {};
// 2555
f989148965_0.returns.push(o1);
// 2556
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2557
f989148965_487.returns.push(1373483125075);
// 2558
o1 = {};
// 2559
f989148965_0.returns.push(o1);
// 2560
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2561
f989148965_487.returns.push(1373483125075);
// 2562
o1 = {};
// 2563
f989148965_0.returns.push(o1);
// 2564
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2565
f989148965_487.returns.push(1373483125076);
// 2566
o1 = {};
// 2567
f989148965_0.returns.push(o1);
// 2568
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2569
f989148965_487.returns.push(1373483125076);
// 2570
o1 = {};
// 2571
f989148965_0.returns.push(o1);
// 2572
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2573
f989148965_487.returns.push(1373483125076);
// 2574
o1 = {};
// 2575
f989148965_0.returns.push(o1);
// 2576
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2577
f989148965_487.returns.push(1373483125076);
// 2578
o1 = {};
// 2579
f989148965_0.returns.push(o1);
// 2580
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2581
f989148965_487.returns.push(1373483125077);
// 2582
o1 = {};
// 2583
f989148965_0.returns.push(o1);
// 2584
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2585
f989148965_487.returns.push(1373483125077);
// 2586
o1 = {};
// 2587
f989148965_0.returns.push(o1);
// 2588
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2589
f989148965_487.returns.push(1373483125077);
// 2590
o1 = {};
// 2591
f989148965_0.returns.push(o1);
// 2592
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2593
f989148965_487.returns.push(1373483125077);
// 2594
o1 = {};
// 2595
f989148965_0.returns.push(o1);
// 2596
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2597
f989148965_487.returns.push(1373483125077);
// 2598
o1 = {};
// 2599
f989148965_0.returns.push(o1);
// 2600
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2601
f989148965_487.returns.push(1373483125078);
// 2602
o1 = {};
// 2603
f989148965_0.returns.push(o1);
// 2604
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2605
f989148965_487.returns.push(1373483125078);
// 2606
o1 = {};
// 2607
f989148965_0.returns.push(o1);
// 2608
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2609
f989148965_487.returns.push(1373483125078);
// 2610
o1 = {};
// 2611
f989148965_0.returns.push(o1);
// 2612
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2613
f989148965_487.returns.push(1373483125078);
// 2614
o1 = {};
// 2615
f989148965_0.returns.push(o1);
// 2616
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2617
f989148965_487.returns.push(1373483125079);
// 2618
o1 = {};
// 2619
f989148965_0.returns.push(o1);
// 2620
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2621
f989148965_487.returns.push(1373483125079);
// 2622
o1 = {};
// 2623
f989148965_0.returns.push(o1);
// 2624
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2625
f989148965_487.returns.push(1373483125083);
// 2626
o1 = {};
// 2627
f989148965_0.returns.push(o1);
// 2628
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2629
f989148965_487.returns.push(1373483125084);
// 2630
o1 = {};
// 2631
f989148965_0.returns.push(o1);
// 2632
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2633
f989148965_487.returns.push(1373483125084);
// 2634
o1 = {};
// 2635
f989148965_0.returns.push(o1);
// 2636
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2637
f989148965_487.returns.push(1373483125092);
// 2638
o1 = {};
// 2639
f989148965_0.returns.push(o1);
// 2640
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2641
f989148965_487.returns.push(1373483125093);
// 2642
o1 = {};
// 2643
f989148965_0.returns.push(o1);
// 2644
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2645
f989148965_487.returns.push(1373483125093);
// 2646
o1 = {};
// 2647
f989148965_0.returns.push(o1);
// 2648
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2649
f989148965_487.returns.push(1373483125094);
// 2650
o1 = {};
// 2651
f989148965_0.returns.push(o1);
// 2652
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2653
f989148965_487.returns.push(1373483125094);
// 2654
o1 = {};
// 2655
f989148965_0.returns.push(o1);
// 2656
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2657
f989148965_487.returns.push(1373483125094);
// 2658
o1 = {};
// 2659
f989148965_0.returns.push(o1);
// 2660
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2661
f989148965_487.returns.push(1373483125095);
// 2662
o1 = {};
// 2663
f989148965_0.returns.push(o1);
// 2664
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2665
f989148965_487.returns.push(1373483125095);
// 2666
o1 = {};
// 2667
f989148965_0.returns.push(o1);
// 2668
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2669
f989148965_487.returns.push(1373483125095);
// 2670
o1 = {};
// 2671
f989148965_0.returns.push(o1);
// 2672
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2673
f989148965_487.returns.push(1373483125096);
// 2674
o1 = {};
// 2675
f989148965_0.returns.push(o1);
// 2676
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2677
f989148965_487.returns.push(1373483125096);
// 2678
o1 = {};
// 2679
f989148965_0.returns.push(o1);
// 2680
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2681
f989148965_487.returns.push(1373483125097);
// 2682
o1 = {};
// 2683
f989148965_0.returns.push(o1);
// 2684
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2685
f989148965_487.returns.push(1373483125097);
// 2686
o1 = {};
// 2687
f989148965_0.returns.push(o1);
// 2688
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2689
f989148965_487.returns.push(1373483125098);
// 2690
o1 = {};
// 2691
f989148965_0.returns.push(o1);
// 2692
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2693
f989148965_487.returns.push(1373483125099);
// 2694
o1 = {};
// 2695
f989148965_0.returns.push(o1);
// 2696
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2697
f989148965_487.returns.push(1373483125099);
// 2698
o1 = {};
// 2699
f989148965_0.returns.push(o1);
// 2700
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2701
f989148965_487.returns.push(1373483125099);
// 2702
o1 = {};
// 2703
f989148965_0.returns.push(o1);
// 2704
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2705
f989148965_487.returns.push(1373483125100);
// 2706
o1 = {};
// 2707
f989148965_0.returns.push(o1);
// 2708
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2709
f989148965_487.returns.push(1373483125100);
// 2710
o1 = {};
// 2711
f989148965_0.returns.push(o1);
// 2712
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2713
f989148965_487.returns.push(1373483125101);
// 2714
o1 = {};
// 2715
f989148965_0.returns.push(o1);
// 2716
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2717
f989148965_487.returns.push(1373483125101);
// 2718
o1 = {};
// 2719
f989148965_0.returns.push(o1);
// 2720
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2721
f989148965_487.returns.push(1373483125101);
// 2722
o1 = {};
// 2723
f989148965_0.returns.push(o1);
// 2724
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2725
f989148965_487.returns.push(1373483125102);
// 2726
o1 = {};
// 2727
f989148965_0.returns.push(o1);
// 2728
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2729
f989148965_487.returns.push(1373483125102);
// 2730
o1 = {};
// 2731
f989148965_0.returns.push(o1);
// 2732
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2733
f989148965_487.returns.push(1373483125102);
// 2734
o1 = {};
// 2735
f989148965_0.returns.push(o1);
// 2736
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2737
f989148965_487.returns.push(1373483125102);
// 2738
o1 = {};
// 2739
f989148965_0.returns.push(o1);
// 2740
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2741
f989148965_487.returns.push(1373483125102);
// 2742
o1 = {};
// 2743
f989148965_0.returns.push(o1);
// 2744
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2745
f989148965_487.returns.push(1373483125106);
// 2746
o1 = {};
// 2747
f989148965_0.returns.push(o1);
// 2748
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2749
f989148965_487.returns.push(1373483125106);
// 2750
o1 = {};
// 2751
f989148965_0.returns.push(o1);
// 2752
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2753
f989148965_487.returns.push(1373483125106);
// 2754
o1 = {};
// 2755
f989148965_0.returns.push(o1);
// 2756
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2757
f989148965_487.returns.push(1373483125107);
// 2758
o1 = {};
// 2759
f989148965_0.returns.push(o1);
// 2760
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2761
f989148965_487.returns.push(1373483125107);
// 2762
o1 = {};
// 2763
f989148965_0.returns.push(o1);
// 2764
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2765
f989148965_487.returns.push(1373483125107);
// 2766
o1 = {};
// 2767
f989148965_0.returns.push(o1);
// 2768
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2769
f989148965_487.returns.push(1373483125107);
// 2770
o1 = {};
// 2771
f989148965_0.returns.push(o1);
// 2772
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2773
f989148965_487.returns.push(1373483125107);
// 2774
o1 = {};
// 2775
f989148965_0.returns.push(o1);
// 2776
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2777
f989148965_487.returns.push(1373483125108);
// 2778
o1 = {};
// 2779
f989148965_0.returns.push(o1);
// 2780
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2781
f989148965_487.returns.push(1373483125108);
// 2782
o1 = {};
// 2783
f989148965_0.returns.push(o1);
// 2784
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2785
f989148965_487.returns.push(1373483125108);
// 2786
o1 = {};
// 2787
f989148965_0.returns.push(o1);
// 2788
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2789
f989148965_487.returns.push(1373483125108);
// 2790
o1 = {};
// 2791
f989148965_0.returns.push(o1);
// 2792
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2793
f989148965_487.returns.push(1373483125108);
// 2794
o1 = {};
// 2795
f989148965_0.returns.push(o1);
// 2796
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2797
f989148965_487.returns.push(1373483125108);
// 2798
o1 = {};
// 2799
f989148965_0.returns.push(o1);
// 2800
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2801
f989148965_487.returns.push(1373483125109);
// 2802
o1 = {};
// 2803
f989148965_0.returns.push(o1);
// 2804
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2805
f989148965_487.returns.push(1373483125109);
// 2806
o1 = {};
// 2807
f989148965_0.returns.push(o1);
// 2808
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2809
f989148965_487.returns.push(1373483125109);
// 2810
o1 = {};
// 2811
f989148965_0.returns.push(o1);
// 2812
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2813
f989148965_487.returns.push(1373483125121);
// 2814
o1 = {};
// 2815
f989148965_0.returns.push(o1);
// 2816
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2817
f989148965_487.returns.push(1373483125121);
// 2818
o1 = {};
// 2819
f989148965_0.returns.push(o1);
// 2820
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2821
f989148965_487.returns.push(1373483125121);
// 2822
o1 = {};
// 2823
f989148965_0.returns.push(o1);
// 2824
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2825
f989148965_487.returns.push(1373483125122);
// 2826
o1 = {};
// 2827
f989148965_0.returns.push(o1);
// 2828
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2829
f989148965_487.returns.push(1373483125124);
// 2830
o1 = {};
// 2831
f989148965_0.returns.push(o1);
// 2832
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2833
f989148965_487.returns.push(1373483125124);
// 2834
o1 = {};
// 2835
f989148965_0.returns.push(o1);
// 2836
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2837
f989148965_487.returns.push(1373483125124);
// 2838
o1 = {};
// 2839
f989148965_0.returns.push(o1);
// 2840
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2841
f989148965_487.returns.push(1373483125126);
// 2842
o1 = {};
// 2843
f989148965_0.returns.push(o1);
// 2844
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2845
f989148965_487.returns.push(1373483125126);
// 2846
o1 = {};
// 2847
f989148965_0.returns.push(o1);
// 2848
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2849
f989148965_487.returns.push(1373483125126);
// 2850
o1 = {};
// 2851
f989148965_0.returns.push(o1);
// 2852
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2853
f989148965_487.returns.push(1373483125132);
// 2854
o1 = {};
// 2855
f989148965_0.returns.push(o1);
// 2856
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2857
f989148965_487.returns.push(1373483125132);
// 2858
o1 = {};
// 2859
f989148965_0.returns.push(o1);
// 2860
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2861
f989148965_487.returns.push(1373483125133);
// 2862
o1 = {};
// 2863
f989148965_0.returns.push(o1);
// 2864
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2865
f989148965_487.returns.push(1373483125133);
// 2866
o1 = {};
// 2867
f989148965_0.returns.push(o1);
// 2868
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2869
f989148965_487.returns.push(1373483125133);
// 2870
o1 = {};
// 2871
f989148965_0.returns.push(o1);
// 2872
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2873
f989148965_487.returns.push(1373483125134);
// 2874
o1 = {};
// 2875
f989148965_0.returns.push(o1);
// 2876
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2877
f989148965_487.returns.push(1373483125134);
// 2878
o1 = {};
// 2879
f989148965_0.returns.push(o1);
// 2880
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2881
f989148965_487.returns.push(1373483125134);
// 2882
o1 = {};
// 2883
f989148965_0.returns.push(o1);
// 2884
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2885
f989148965_487.returns.push(1373483125136);
// 2886
o1 = {};
// 2887
f989148965_0.returns.push(o1);
// 2888
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2889
f989148965_487.returns.push(1373483125136);
// 2890
o1 = {};
// 2891
f989148965_0.returns.push(o1);
// 2892
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2893
f989148965_487.returns.push(1373483125136);
// 2894
o1 = {};
// 2895
f989148965_0.returns.push(o1);
// 2896
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2897
f989148965_487.returns.push(1373483125137);
// 2898
o1 = {};
// 2899
f989148965_0.returns.push(o1);
// 2900
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2901
f989148965_487.returns.push(1373483125137);
// 2902
o1 = {};
// 2903
f989148965_0.returns.push(o1);
// 2904
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2905
f989148965_487.returns.push(1373483125137);
// 2906
o1 = {};
// 2907
f989148965_0.returns.push(o1);
// 2908
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2909
f989148965_487.returns.push(1373483125138);
// 2910
o1 = {};
// 2911
f989148965_0.returns.push(o1);
// 2912
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2913
f989148965_487.returns.push(1373483125138);
// 2914
o1 = {};
// 2915
f989148965_0.returns.push(o1);
// 2916
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2917
f989148965_487.returns.push(1373483125139);
// 2918
o1 = {};
// 2919
f989148965_0.returns.push(o1);
// 2920
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2921
f989148965_487.returns.push(1373483125139);
// 2922
o1 = {};
// 2923
f989148965_0.returns.push(o1);
// 2924
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2925
f989148965_487.returns.push(1373483125139);
// 2926
o1 = {};
// 2927
f989148965_0.returns.push(o1);
// 2928
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2929
f989148965_487.returns.push(1373483125140);
// 2930
o1 = {};
// 2931
f989148965_0.returns.push(o1);
// 2932
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2933
f989148965_487.returns.push(1373483125141);
// 2934
o1 = {};
// 2935
f989148965_0.returns.push(o1);
// 2936
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2937
f989148965_487.returns.push(1373483125142);
// 2938
o1 = {};
// 2939
f989148965_0.returns.push(o1);
// 2940
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2941
f989148965_487.returns.push(1373483125142);
// 2942
o1 = {};
// 2943
f989148965_0.returns.push(o1);
// 2944
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2945
f989148965_487.returns.push(1373483125143);
// 2946
o1 = {};
// 2947
f989148965_0.returns.push(o1);
// 2948
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2949
f989148965_487.returns.push(1373483125143);
// 2950
o1 = {};
// 2951
f989148965_0.returns.push(o1);
// 2952
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2953
f989148965_487.returns.push(1373483125143);
// 2954
o1 = {};
// 2955
f989148965_0.returns.push(o1);
// 2956
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2957
f989148965_487.returns.push(1373483125144);
// 2958
o1 = {};
// 2959
f989148965_0.returns.push(o1);
// 2960
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2961
f989148965_487.returns.push(1373483125157);
// 2962
o1 = {};
// 2963
f989148965_0.returns.push(o1);
// 2964
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2965
f989148965_487.returns.push(1373483125157);
// 2966
o1 = {};
// 2967
f989148965_0.returns.push(o1);
// 2968
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2969
f989148965_487.returns.push(1373483125158);
// 2970
o1 = {};
// 2971
f989148965_0.returns.push(o1);
// 2972
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2973
f989148965_487.returns.push(1373483125158);
// 2974
o1 = {};
// 2975
f989148965_0.returns.push(o1);
// 2976
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2977
f989148965_487.returns.push(1373483125158);
// 2978
o1 = {};
// 2979
f989148965_0.returns.push(o1);
// 2980
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2981
f989148965_487.returns.push(1373483125160);
// 2982
o1 = {};
// 2983
f989148965_0.returns.push(o1);
// 2984
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2985
f989148965_487.returns.push(1373483125161);
// 2986
o1 = {};
// 2987
f989148965_0.returns.push(o1);
// 2988
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2989
f989148965_487.returns.push(1373483125161);
// 2990
o1 = {};
// 2991
f989148965_0.returns.push(o1);
// 2992
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2993
f989148965_487.returns.push(1373483125161);
// 2994
o1 = {};
// 2995
f989148965_0.returns.push(o1);
// 2996
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 2997
f989148965_487.returns.push(1373483125162);
// 2998
o1 = {};
// 2999
f989148965_0.returns.push(o1);
// 3000
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3001
f989148965_487.returns.push(1373483125162);
// 3002
o1 = {};
// 3003
f989148965_0.returns.push(o1);
// 3004
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3005
f989148965_487.returns.push(1373483125162);
// 3006
o1 = {};
// 3007
f989148965_0.returns.push(o1);
// 3008
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3009
f989148965_487.returns.push(1373483125163);
// 3010
o1 = {};
// 3011
f989148965_0.returns.push(o1);
// 3012
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3013
f989148965_487.returns.push(1373483125163);
// 3014
o1 = {};
// 3015
f989148965_0.returns.push(o1);
// 3016
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3017
f989148965_487.returns.push(1373483125163);
// 3018
o1 = {};
// 3019
f989148965_0.returns.push(o1);
// 3020
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3021
f989148965_487.returns.push(1373483125163);
// 3022
o1 = {};
// 3023
f989148965_0.returns.push(o1);
// 3024
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3025
f989148965_487.returns.push(1373483125163);
// 3026
o1 = {};
// 3027
f989148965_0.returns.push(o1);
// 3028
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3029
f989148965_487.returns.push(1373483125164);
// 3030
o1 = {};
// 3031
f989148965_0.returns.push(o1);
// 3032
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3033
f989148965_487.returns.push(1373483125164);
// 3034
o1 = {};
// 3035
f989148965_0.returns.push(o1);
// 3036
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3037
f989148965_487.returns.push(1373483125164);
// 3038
o1 = {};
// 3039
f989148965_0.returns.push(o1);
// 3040
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3041
f989148965_487.returns.push(1373483125164);
// 3042
o1 = {};
// 3043
f989148965_0.returns.push(o1);
// 3044
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3045
f989148965_487.returns.push(1373483125164);
// 3046
o1 = {};
// 3047
f989148965_0.returns.push(o1);
// 3048
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3049
f989148965_487.returns.push(1373483125164);
// 3050
o1 = {};
// 3051
f989148965_0.returns.push(o1);
// 3052
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3053
f989148965_487.returns.push(1373483125165);
// 3054
o1 = {};
// 3055
f989148965_0.returns.push(o1);
// 3056
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3057
f989148965_487.returns.push(1373483125165);
// 3058
o1 = {};
// 3059
f989148965_0.returns.push(o1);
// 3060
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3061
f989148965_487.returns.push(1373483125165);
// 3062
o1 = {};
// 3063
f989148965_0.returns.push(o1);
// 3064
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3065
f989148965_487.returns.push(1373483125165);
// 3066
o1 = {};
// 3067
f989148965_0.returns.push(o1);
// 3068
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3069
f989148965_487.returns.push(1373483125171);
// 3070
o1 = {};
// 3071
f989148965_0.returns.push(o1);
// 3072
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3073
f989148965_487.returns.push(1373483125171);
// 3074
o1 = {};
// 3075
f989148965_0.returns.push(o1);
// 3076
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3077
f989148965_487.returns.push(1373483125171);
// 3078
o1 = {};
// 3079
f989148965_0.returns.push(o1);
// 3080
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3081
f989148965_487.returns.push(1373483125172);
// 3082
o1 = {};
// 3083
f989148965_0.returns.push(o1);
// 3084
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3085
f989148965_487.returns.push(1373483125172);
// 3086
o1 = {};
// 3087
f989148965_0.returns.push(o1);
// 3088
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3089
f989148965_487.returns.push(1373483125172);
// 3090
o1 = {};
// 3091
f989148965_0.returns.push(o1);
// 3092
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3093
f989148965_487.returns.push(1373483125173);
// 3094
o1 = {};
// 3095
f989148965_0.returns.push(o1);
// 3096
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3097
f989148965_487.returns.push(1373483125173);
// 3098
o1 = {};
// 3099
f989148965_0.returns.push(o1);
// 3100
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3101
f989148965_487.returns.push(1373483125173);
// 3102
o1 = {};
// 3103
f989148965_0.returns.push(o1);
// 3104
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3105
f989148965_487.returns.push(1373483125173);
// 3106
o1 = {};
// 3107
f989148965_0.returns.push(o1);
// 3108
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3109
f989148965_487.returns.push(1373483125173);
// 3110
o1 = {};
// 3111
f989148965_0.returns.push(o1);
// 3112
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3113
f989148965_487.returns.push(1373483125174);
// 3114
o1 = {};
// 3115
f989148965_0.returns.push(o1);
// 3116
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3117
f989148965_487.returns.push(1373483125174);
// 3118
o1 = {};
// 3119
f989148965_0.returns.push(o1);
// 3120
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3121
f989148965_487.returns.push(1373483125174);
// 3122
o1 = {};
// 3123
f989148965_0.returns.push(o1);
// 3124
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3125
f989148965_487.returns.push(1373483125174);
// 3126
o1 = {};
// 3127
f989148965_0.returns.push(o1);
// 3128
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3129
f989148965_487.returns.push(1373483125175);
// 3130
o1 = {};
// 3131
f989148965_0.returns.push(o1);
// 3132
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3133
f989148965_487.returns.push(1373483125175);
// 3134
o1 = {};
// 3135
f989148965_0.returns.push(o1);
// 3136
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3137
f989148965_487.returns.push(1373483125176);
// 3138
o1 = {};
// 3139
f989148965_0.returns.push(o1);
// 3140
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3141
f989148965_487.returns.push(1373483125176);
// 3142
o1 = {};
// 3143
f989148965_0.returns.push(o1);
// 3144
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3145
f989148965_487.returns.push(1373483125176);
// 3146
o1 = {};
// 3147
f989148965_0.returns.push(o1);
// 3148
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3149
f989148965_487.returns.push(1373483125176);
// 3150
o1 = {};
// 3151
f989148965_0.returns.push(o1);
// 3152
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3153
f989148965_487.returns.push(1373483125177);
// 3154
o1 = {};
// 3155
f989148965_0.returns.push(o1);
// 3156
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3157
f989148965_487.returns.push(1373483125177);
// 3158
o1 = {};
// 3159
f989148965_0.returns.push(o1);
// 3160
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3161
f989148965_487.returns.push(1373483125177);
// 3162
o1 = {};
// 3163
f989148965_0.returns.push(o1);
// 3164
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3165
f989148965_487.returns.push(1373483125177);
// 3166
o1 = {};
// 3167
f989148965_0.returns.push(o1);
// 3168
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3169
f989148965_487.returns.push(1373483125178);
// 3170
o1 = {};
// 3171
f989148965_0.returns.push(o1);
// 3172
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3173
f989148965_487.returns.push(1373483125178);
// 3174
o1 = {};
// 3175
f989148965_0.returns.push(o1);
// 3176
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3177
f989148965_487.returns.push(1373483125186);
// 3178
o1 = {};
// 3179
f989148965_0.returns.push(o1);
// 3180
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3181
f989148965_487.returns.push(1373483125186);
// 3182
o1 = {};
// 3183
f989148965_0.returns.push(o1);
// 3184
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3185
f989148965_487.returns.push(1373483125187);
// 3186
o1 = {};
// 3187
f989148965_0.returns.push(o1);
// 3188
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3189
f989148965_487.returns.push(1373483125187);
// 3190
o1 = {};
// 3191
f989148965_0.returns.push(o1);
// 3192
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3193
f989148965_487.returns.push(1373483125187);
// 3194
o1 = {};
// 3195
f989148965_0.returns.push(o1);
// 3196
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3197
f989148965_487.returns.push(1373483125187);
// 3198
o1 = {};
// 3199
f989148965_0.returns.push(o1);
// 3200
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3201
f989148965_487.returns.push(1373483125189);
// 3202
o1 = {};
// 3203
f989148965_0.returns.push(o1);
// 3204
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3205
f989148965_487.returns.push(1373483125190);
// 3206
o1 = {};
// 3207
f989148965_0.returns.push(o1);
// 3208
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3209
f989148965_487.returns.push(1373483125190);
// 3210
o1 = {};
// 3211
f989148965_0.returns.push(o1);
// 3212
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3213
f989148965_487.returns.push(1373483125190);
// 3214
o1 = {};
// 3215
f989148965_0.returns.push(o1);
// 3216
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3217
f989148965_487.returns.push(1373483125191);
// 3218
o1 = {};
// 3219
f989148965_0.returns.push(o1);
// 3220
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3221
f989148965_487.returns.push(1373483125191);
// 3222
o1 = {};
// 3223
f989148965_0.returns.push(o1);
// 3224
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3225
f989148965_487.returns.push(1373483125191);
// 3226
o1 = {};
// 3227
f989148965_0.returns.push(o1);
// 3228
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3229
f989148965_487.returns.push(1373483125191);
// 3230
o1 = {};
// 3231
f989148965_0.returns.push(o1);
// 3232
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3233
f989148965_487.returns.push(1373483125193);
// 3234
o1 = {};
// 3235
f989148965_0.returns.push(o1);
// 3236
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3237
f989148965_487.returns.push(1373483125193);
// 3238
o1 = {};
// 3239
f989148965_0.returns.push(o1);
// 3240
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3241
f989148965_487.returns.push(1373483125193);
// 3242
o1 = {};
// 3243
f989148965_0.returns.push(o1);
// 3244
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3245
f989148965_487.returns.push(1373483125193);
// 3246
o1 = {};
// 3247
f989148965_0.returns.push(o1);
// 3248
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3249
f989148965_487.returns.push(1373483125194);
// 3250
o1 = {};
// 3251
f989148965_0.returns.push(o1);
// 3252
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3253
f989148965_487.returns.push(1373483125195);
// 3254
o1 = {};
// 3255
f989148965_0.returns.push(o1);
// 3256
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3257
f989148965_487.returns.push(1373483125195);
// 3258
o1 = {};
// 3259
f989148965_0.returns.push(o1);
// 3260
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3261
f989148965_487.returns.push(1373483125195);
// 3262
o1 = {};
// 3263
f989148965_0.returns.push(o1);
// 3264
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3265
f989148965_487.returns.push(1373483125196);
// 3266
o1 = {};
// 3267
f989148965_0.returns.push(o1);
// 3268
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3269
f989148965_487.returns.push(1373483125196);
// 3270
o1 = {};
// 3271
f989148965_0.returns.push(o1);
// 3272
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3273
f989148965_487.returns.push(1373483125196);
// 3274
o1 = {};
// 3275
f989148965_0.returns.push(o1);
// 3276
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3277
f989148965_487.returns.push(1373483125196);
// 3278
o1 = {};
// 3279
f989148965_0.returns.push(o1);
// 3280
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3281
f989148965_487.returns.push(1373483125196);
// 3282
o1 = {};
// 3283
f989148965_0.returns.push(o1);
// 3284
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3285
f989148965_487.returns.push(1373483125202);
// 3286
o1 = {};
// 3287
f989148965_0.returns.push(o1);
// 3288
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3289
f989148965_487.returns.push(1373483125202);
// 3290
o1 = {};
// 3291
f989148965_0.returns.push(o1);
// 3292
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3293
f989148965_487.returns.push(1373483125202);
// 3294
o1 = {};
// 3295
f989148965_0.returns.push(o1);
// 3296
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3297
f989148965_487.returns.push(1373483125203);
// 3298
o1 = {};
// 3299
f989148965_0.returns.push(o1);
// 3300
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3301
f989148965_487.returns.push(1373483125203);
// 3302
o1 = {};
// 3303
f989148965_0.returns.push(o1);
// 3304
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3305
f989148965_487.returns.push(1373483125203);
// 3306
o1 = {};
// 3307
f989148965_0.returns.push(o1);
// 3308
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3309
f989148965_487.returns.push(1373483125203);
// 3310
o1 = {};
// 3311
f989148965_0.returns.push(o1);
// 3312
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3313
f989148965_487.returns.push(1373483125203);
// 3314
o1 = {};
// 3315
f989148965_0.returns.push(o1);
// 3316
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3317
f989148965_487.returns.push(1373483125205);
// 3318
o1 = {};
// 3319
f989148965_0.returns.push(o1);
// 3320
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3321
f989148965_487.returns.push(1373483125205);
// 3322
o1 = {};
// 3323
f989148965_0.returns.push(o1);
// 3324
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3325
f989148965_487.returns.push(1373483125205);
// 3326
o1 = {};
// 3327
f989148965_0.returns.push(o1);
// 3328
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3329
f989148965_487.returns.push(1373483125206);
// 3330
o1 = {};
// 3331
f989148965_0.returns.push(o1);
// 3332
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3333
f989148965_487.returns.push(1373483125206);
// 3334
o1 = {};
// 3335
f989148965_0.returns.push(o1);
// 3336
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3337
f989148965_487.returns.push(1373483125206);
// 3338
o1 = {};
// 3339
f989148965_0.returns.push(o1);
// 3340
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3341
f989148965_487.returns.push(1373483125208);
// 3342
o1 = {};
// 3343
f989148965_0.returns.push(o1);
// 3344
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3345
f989148965_487.returns.push(1373483125208);
// 3346
o1 = {};
// 3347
f989148965_0.returns.push(o1);
// 3348
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3349
f989148965_487.returns.push(1373483125209);
// 3350
o1 = {};
// 3351
f989148965_0.returns.push(o1);
// 3352
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3353
f989148965_487.returns.push(1373483125209);
// 3354
o1 = {};
// 3355
f989148965_0.returns.push(o1);
// 3356
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3357
f989148965_487.returns.push(1373483125209);
// 3358
o1 = {};
// 3359
f989148965_0.returns.push(o1);
// 3360
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3361
f989148965_487.returns.push(1373483125210);
// 3362
o1 = {};
// 3363
f989148965_0.returns.push(o1);
// 3364
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3365
f989148965_487.returns.push(1373483125210);
// 3366
o1 = {};
// 3367
f989148965_0.returns.push(o1);
// 3368
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3369
f989148965_487.returns.push(1373483125210);
// 3370
o1 = {};
// 3371
f989148965_0.returns.push(o1);
// 3372
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3373
f989148965_487.returns.push(1373483125212);
// 3374
o1 = {};
// 3375
f989148965_0.returns.push(o1);
// 3376
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3377
f989148965_487.returns.push(1373483125212);
// 3378
o1 = {};
// 3379
f989148965_0.returns.push(o1);
// 3380
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3381
f989148965_487.returns.push(1373483125212);
// 3382
o1 = {};
// 3383
f989148965_0.returns.push(o1);
// 3384
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3385
f989148965_487.returns.push(1373483125214);
// 3386
o1 = {};
// 3387
f989148965_0.returns.push(o1);
// 3388
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3389
f989148965_487.returns.push(1373483125214);
// 3390
o1 = {};
// 3391
f989148965_0.returns.push(o1);
// 3392
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3393
f989148965_487.returns.push(1373483125222);
// 3394
o1 = {};
// 3395
f989148965_0.returns.push(o1);
// 3396
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3397
f989148965_487.returns.push(1373483125222);
// 3398
o1 = {};
// 3399
f989148965_0.returns.push(o1);
// 3400
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3401
f989148965_487.returns.push(1373483125222);
// 3402
o1 = {};
// 3403
f989148965_0.returns.push(o1);
// 3404
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3405
f989148965_487.returns.push(1373483125223);
// 3406
o1 = {};
// 3407
f989148965_0.returns.push(o1);
// 3408
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3409
f989148965_487.returns.push(1373483125223);
// 3410
o1 = {};
// 3411
f989148965_0.returns.push(o1);
// 3412
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3413
f989148965_487.returns.push(1373483125223);
// 3414
o1 = {};
// 3415
f989148965_0.returns.push(o1);
// 3416
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3417
f989148965_487.returns.push(1373483125223);
// 3418
o1 = {};
// 3419
f989148965_0.returns.push(o1);
// 3420
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3421
f989148965_487.returns.push(1373483125223);
// 3422
o1 = {};
// 3423
f989148965_0.returns.push(o1);
// 3424
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3425
f989148965_487.returns.push(1373483125224);
// 3426
o1 = {};
// 3427
f989148965_0.returns.push(o1);
// 3428
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3429
f989148965_487.returns.push(1373483125224);
// 3430
o1 = {};
// 3431
f989148965_0.returns.push(o1);
// 3432
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3433
f989148965_487.returns.push(1373483125224);
// 3434
o1 = {};
// 3435
f989148965_0.returns.push(o1);
// 3436
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3437
f989148965_487.returns.push(1373483125225);
// 3438
o1 = {};
// 3439
f989148965_0.returns.push(o1);
// 3440
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3441
f989148965_487.returns.push(1373483125225);
// 3442
o1 = {};
// 3443
f989148965_0.returns.push(o1);
// 3444
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3445
f989148965_487.returns.push(1373483125225);
// 3446
o1 = {};
// 3447
f989148965_0.returns.push(o1);
// 3448
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3449
f989148965_487.returns.push(1373483125225);
// 3450
o1 = {};
// 3451
f989148965_0.returns.push(o1);
// 3452
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3453
f989148965_487.returns.push(1373483125226);
// 3454
o1 = {};
// 3455
f989148965_0.returns.push(o1);
// 3456
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3457
f989148965_487.returns.push(1373483125227);
// 3458
o1 = {};
// 3459
f989148965_0.returns.push(o1);
// 3460
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3461
f989148965_487.returns.push(1373483125227);
// 3462
o1 = {};
// 3463
f989148965_0.returns.push(o1);
// 3464
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3465
f989148965_487.returns.push(1373483125227);
// 3466
o1 = {};
// 3467
f989148965_0.returns.push(o1);
// 3468
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3469
f989148965_487.returns.push(1373483125227);
// 3470
o1 = {};
// 3471
f989148965_0.returns.push(o1);
// 3472
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3473
f989148965_487.returns.push(1373483125228);
// 3474
o1 = {};
// 3475
f989148965_0.returns.push(o1);
// 3476
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3477
f989148965_487.returns.push(1373483125228);
// 3478
o1 = {};
// 3479
f989148965_0.returns.push(o1);
// 3480
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3481
f989148965_487.returns.push(1373483125229);
// 3482
o1 = {};
// 3483
f989148965_0.returns.push(o1);
// 3484
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3485
f989148965_487.returns.push(1373483125229);
// 3486
o1 = {};
// 3487
f989148965_0.returns.push(o1);
// 3488
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3489
f989148965_487.returns.push(1373483125229);
// 3490
o1 = {};
// 3491
f989148965_0.returns.push(o1);
// 3492
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3493
f989148965_487.returns.push(1373483125229);
// 3494
o1 = {};
// 3495
f989148965_0.returns.push(o1);
// 3496
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3497
f989148965_487.returns.push(1373483125230);
// 3498
o1 = {};
// 3499
f989148965_0.returns.push(o1);
// 3500
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3501
f989148965_487.returns.push(1373483125233);
// 3502
o1 = {};
// 3503
f989148965_0.returns.push(o1);
// 3504
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3505
f989148965_487.returns.push(1373483125233);
// 3506
o1 = {};
// 3507
f989148965_0.returns.push(o1);
// 3508
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3509
f989148965_487.returns.push(1373483125234);
// 3510
o1 = {};
// 3511
f989148965_0.returns.push(o1);
// 3512
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3513
f989148965_487.returns.push(1373483125234);
// 3514
o1 = {};
// 3515
f989148965_0.returns.push(o1);
// 3516
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3517
f989148965_487.returns.push(1373483125235);
// 3518
o1 = {};
// 3519
f989148965_0.returns.push(o1);
// 3520
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3521
f989148965_487.returns.push(1373483125235);
// 3522
o1 = {};
// 3523
f989148965_0.returns.push(o1);
// 3524
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3525
f989148965_487.returns.push(1373483125235);
// 3526
o1 = {};
// 3527
f989148965_0.returns.push(o1);
// 3528
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3529
f989148965_487.returns.push(1373483125235);
// 3530
o1 = {};
// 3531
f989148965_0.returns.push(o1);
// 3532
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3533
f989148965_487.returns.push(1373483125235);
// 3534
o1 = {};
// 3535
f989148965_0.returns.push(o1);
// 3536
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3537
f989148965_487.returns.push(1373483125235);
// 3538
o1 = {};
// 3539
f989148965_0.returns.push(o1);
// 3540
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3541
f989148965_487.returns.push(1373483125236);
// 3542
o1 = {};
// 3543
f989148965_0.returns.push(o1);
// 3544
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3545
f989148965_487.returns.push(1373483125236);
// 3546
o1 = {};
// 3547
f989148965_0.returns.push(o1);
// 3548
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3549
f989148965_487.returns.push(1373483125236);
// 3550
o1 = {};
// 3551
f989148965_0.returns.push(o1);
// 3552
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3553
f989148965_487.returns.push(1373483125237);
// 3554
o1 = {};
// 3555
f989148965_0.returns.push(o1);
// 3556
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3557
f989148965_487.returns.push(1373483125237);
// 3558
o1 = {};
// 3559
f989148965_0.returns.push(o1);
// 3560
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3561
f989148965_487.returns.push(1373483125237);
// 3562
o1 = {};
// 3563
f989148965_0.returns.push(o1);
// 3564
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3565
f989148965_487.returns.push(1373483125237);
// 3566
o1 = {};
// 3567
f989148965_0.returns.push(o1);
// 3568
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3569
f989148965_487.returns.push(1373483125237);
// 3570
o1 = {};
// 3571
f989148965_0.returns.push(o1);
// 3572
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3573
f989148965_487.returns.push(1373483125238);
// 3574
o1 = {};
// 3575
f989148965_0.returns.push(o1);
// 3576
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3577
f989148965_487.returns.push(1373483125238);
// 3578
o1 = {};
// 3579
f989148965_0.returns.push(o1);
// 3580
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3581
f989148965_487.returns.push(1373483125238);
// 3582
o1 = {};
// 3583
f989148965_0.returns.push(o1);
// 3584
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3585
f989148965_487.returns.push(1373483125239);
// 3586
o1 = {};
// 3587
f989148965_0.returns.push(o1);
// 3588
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3589
f989148965_487.returns.push(1373483125239);
// 3590
o1 = {};
// 3591
f989148965_0.returns.push(o1);
// 3592
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3593
f989148965_487.returns.push(1373483125239);
// 3594
o1 = {};
// 3595
f989148965_0.returns.push(o1);
// 3596
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3597
f989148965_487.returns.push(1373483125240);
// 3598
o1 = {};
// 3599
f989148965_0.returns.push(o1);
// 3600
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3601
f989148965_487.returns.push(1373483125240);
// 3602
o1 = {};
// 3603
f989148965_0.returns.push(o1);
// 3604
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3605
f989148965_487.returns.push(1373483125246);
// 3606
o1 = {};
// 3607
f989148965_0.returns.push(o1);
// 3608
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3609
f989148965_487.returns.push(1373483125246);
// 3610
o1 = {};
// 3611
f989148965_0.returns.push(o1);
// 3612
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3613
f989148965_487.returns.push(1373483125247);
// 3614
o1 = {};
// 3615
f989148965_0.returns.push(o1);
// 3616
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3617
f989148965_487.returns.push(1373483125247);
// 3618
o1 = {};
// 3619
f989148965_0.returns.push(o1);
// 3620
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3621
f989148965_487.returns.push(1373483125247);
// 3622
o1 = {};
// 3623
f989148965_0.returns.push(o1);
// 3624
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3625
f989148965_487.returns.push(1373483125247);
// 3626
o1 = {};
// 3627
f989148965_0.returns.push(o1);
// 3628
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3629
f989148965_487.returns.push(1373483125247);
// 3630
o1 = {};
// 3631
f989148965_0.returns.push(o1);
// 3632
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3633
f989148965_487.returns.push(1373483125248);
// 3634
o1 = {};
// 3635
f989148965_0.returns.push(o1);
// 3636
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3637
f989148965_487.returns.push(1373483125248);
// 3638
o1 = {};
// 3639
f989148965_0.returns.push(o1);
// 3640
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3641
f989148965_487.returns.push(1373483125249);
// 3642
o1 = {};
// 3643
f989148965_0.returns.push(o1);
// 3644
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3645
f989148965_487.returns.push(1373483125249);
// 3646
o1 = {};
// 3647
f989148965_0.returns.push(o1);
// 3648
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3649
f989148965_487.returns.push(1373483125249);
// 3650
o1 = {};
// 3651
f989148965_0.returns.push(o1);
// 3652
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3653
f989148965_487.returns.push(1373483125250);
// 3654
o1 = {};
// 3655
f989148965_0.returns.push(o1);
// 3656
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3657
f989148965_487.returns.push(1373483125250);
// 3658
o1 = {};
// 3659
f989148965_0.returns.push(o1);
// 3660
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3661
f989148965_487.returns.push(1373483125260);
// 3662
o1 = {};
// 3663
f989148965_0.returns.push(o1);
// 3664
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3665
f989148965_487.returns.push(1373483125260);
// 3666
o1 = {};
// 3667
f989148965_0.returns.push(o1);
// 3668
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3669
f989148965_487.returns.push(1373483125261);
// 3670
o1 = {};
// 3671
f989148965_0.returns.push(o1);
// 3672
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3673
f989148965_487.returns.push(1373483125261);
// 3674
o1 = {};
// 3675
f989148965_0.returns.push(o1);
// 3676
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3677
f989148965_487.returns.push(1373483125261);
// 3678
o1 = {};
// 3679
f989148965_0.returns.push(o1);
// 3680
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3681
f989148965_487.returns.push(1373483125261);
// 3682
o1 = {};
// 3683
f989148965_0.returns.push(o1);
// 3684
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3685
f989148965_487.returns.push(1373483125261);
// 3686
o1 = {};
// 3687
f989148965_0.returns.push(o1);
// 3688
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3689
f989148965_487.returns.push(1373483125261);
// 3690
o1 = {};
// 3691
f989148965_0.returns.push(o1);
// 3692
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3693
f989148965_487.returns.push(1373483125262);
// 3694
o1 = {};
// 3695
f989148965_0.returns.push(o1);
// 3696
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3697
f989148965_487.returns.push(1373483125262);
// 3698
o1 = {};
// 3699
f989148965_0.returns.push(o1);
// 3700
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3701
f989148965_487.returns.push(1373483125262);
// 3702
o1 = {};
// 3703
f989148965_0.returns.push(o1);
// 3704
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3705
f989148965_487.returns.push(1373483125262);
// 3706
o1 = {};
// 3707
f989148965_0.returns.push(o1);
// 3708
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3709
f989148965_487.returns.push(1373483125263);
// 3710
o1 = {};
// 3711
f989148965_0.returns.push(o1);
// 3712
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3713
f989148965_487.returns.push(1373483125267);
// 3714
o1 = {};
// 3715
f989148965_0.returns.push(o1);
// 3716
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3717
f989148965_487.returns.push(1373483125267);
// 3718
o1 = {};
// 3719
f989148965_0.returns.push(o1);
// 3720
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3721
f989148965_487.returns.push(1373483125268);
// 3722
o1 = {};
// 3723
f989148965_0.returns.push(o1);
// 3724
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3725
f989148965_487.returns.push(1373483125268);
// 3726
o1 = {};
// 3727
f989148965_0.returns.push(o1);
// 3728
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3729
f989148965_487.returns.push(1373483125268);
// 3730
o1 = {};
// 3731
f989148965_0.returns.push(o1);
// 3732
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3733
f989148965_487.returns.push(1373483125268);
// 3734
o1 = {};
// 3735
f989148965_0.returns.push(o1);
// 3736
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3737
f989148965_487.returns.push(1373483125268);
// 3738
o1 = {};
// 3739
f989148965_0.returns.push(o1);
// 3740
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3741
f989148965_487.returns.push(1373483125269);
// 3742
o1 = {};
// 3743
f989148965_0.returns.push(o1);
// 3744
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3745
f989148965_487.returns.push(1373483125269);
// 3746
o1 = {};
// 3747
f989148965_0.returns.push(o1);
// 3748
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3749
f989148965_487.returns.push(1373483125270);
// 3750
o1 = {};
// 3751
f989148965_0.returns.push(o1);
// 3752
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3753
f989148965_487.returns.push(1373483125270);
// 3754
o1 = {};
// 3755
f989148965_0.returns.push(o1);
// 3756
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3757
f989148965_487.returns.push(1373483125271);
// 3758
o1 = {};
// 3759
f989148965_0.returns.push(o1);
// 3760
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3761
f989148965_487.returns.push(1373483125271);
// 3762
o1 = {};
// 3763
f989148965_0.returns.push(o1);
// 3764
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3765
f989148965_487.returns.push(1373483125271);
// 3766
o1 = {};
// 3767
f989148965_0.returns.push(o1);
// 3768
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3769
f989148965_487.returns.push(1373483125272);
// 3770
o1 = {};
// 3771
f989148965_0.returns.push(o1);
// 3772
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3773
f989148965_487.returns.push(1373483125272);
// 3774
o1 = {};
// 3775
f989148965_0.returns.push(o1);
// 3776
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3777
f989148965_487.returns.push(1373483125272);
// 3778
o1 = {};
// 3779
f989148965_0.returns.push(o1);
// 3780
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3781
f989148965_487.returns.push(1373483125272);
// 3782
o1 = {};
// 3783
f989148965_0.returns.push(o1);
// 3784
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3785
f989148965_487.returns.push(1373483125273);
// 3786
o1 = {};
// 3787
f989148965_0.returns.push(o1);
// 3788
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3789
f989148965_487.returns.push(1373483125274);
// 3790
o1 = {};
// 3791
f989148965_0.returns.push(o1);
// 3792
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3793
f989148965_487.returns.push(1373483125274);
// 3794
o1 = {};
// 3795
f989148965_0.returns.push(o1);
// 3796
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3797
f989148965_487.returns.push(1373483125274);
// 3798
o1 = {};
// 3799
f989148965_0.returns.push(o1);
// 3800
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3801
f989148965_487.returns.push(1373483125275);
// 3802
o1 = {};
// 3803
f989148965_0.returns.push(o1);
// 3804
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3805
f989148965_487.returns.push(1373483125276);
// 3806
o1 = {};
// 3807
f989148965_0.returns.push(o1);
// 3808
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3809
f989148965_487.returns.push(1373483125276);
// 3810
o1 = {};
// 3811
f989148965_0.returns.push(o1);
// 3812
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3813
f989148965_487.returns.push(1373483125276);
// 3814
o1 = {};
// 3815
f989148965_0.returns.push(o1);
// 3816
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3817
f989148965_487.returns.push(1373483125281);
// 3818
o1 = {};
// 3819
f989148965_0.returns.push(o1);
// 3820
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3821
f989148965_487.returns.push(1373483125282);
// 3822
o1 = {};
// 3823
f989148965_0.returns.push(o1);
// 3824
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3825
f989148965_487.returns.push(1373483125282);
// 3826
o1 = {};
// 3827
f989148965_0.returns.push(o1);
// 3828
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3829
f989148965_487.returns.push(1373483125282);
// 3830
o1 = {};
// 3831
f989148965_0.returns.push(o1);
// 3832
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3833
f989148965_487.returns.push(1373483125282);
// 3834
o1 = {};
// 3835
f989148965_0.returns.push(o1);
// 3836
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3837
f989148965_487.returns.push(1373483125283);
// 3838
o1 = {};
// 3839
f989148965_0.returns.push(o1);
// 3840
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3841
f989148965_487.returns.push(1373483125283);
// 3842
o1 = {};
// 3843
f989148965_0.returns.push(o1);
// 3844
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3845
f989148965_487.returns.push(1373483125284);
// 3846
o1 = {};
// 3847
f989148965_0.returns.push(o1);
// 3848
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3849
f989148965_487.returns.push(1373483125284);
// 3850
o1 = {};
// 3851
f989148965_0.returns.push(o1);
// 3852
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3853
f989148965_487.returns.push(1373483125284);
// 3854
o1 = {};
// 3855
f989148965_0.returns.push(o1);
// 3856
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3857
f989148965_487.returns.push(1373483125285);
// 3858
o1 = {};
// 3859
f989148965_0.returns.push(o1);
// 3860
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3861
f989148965_487.returns.push(1373483125285);
// 3862
o1 = {};
// 3863
f989148965_0.returns.push(o1);
// 3864
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3865
f989148965_487.returns.push(1373483125286);
// 3866
o1 = {};
// 3867
f989148965_0.returns.push(o1);
// 3868
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3869
f989148965_487.returns.push(1373483125287);
// 3870
o1 = {};
// 3871
f989148965_0.returns.push(o1);
// 3872
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3873
f989148965_487.returns.push(1373483125287);
// 3874
o1 = {};
// 3875
f989148965_0.returns.push(o1);
// 3876
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3877
f989148965_487.returns.push(1373483125287);
// 3878
o1 = {};
// 3879
f989148965_0.returns.push(o1);
// 3880
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3881
f989148965_487.returns.push(1373483125287);
// 3882
o1 = {};
// 3883
f989148965_0.returns.push(o1);
// 3884
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3885
f989148965_487.returns.push(1373483125287);
// 3886
o1 = {};
// 3887
f989148965_0.returns.push(o1);
// 3888
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3889
f989148965_487.returns.push(1373483125287);
// 3890
o1 = {};
// 3891
f989148965_0.returns.push(o1);
// 3892
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3893
f989148965_487.returns.push(1373483125288);
// 3894
o1 = {};
// 3895
f989148965_0.returns.push(o1);
// 3896
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3897
f989148965_487.returns.push(1373483125288);
// 3898
o1 = {};
// 3899
f989148965_0.returns.push(o1);
// 3900
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3901
f989148965_487.returns.push(1373483125288);
// 3902
o1 = {};
// 3903
f989148965_0.returns.push(o1);
// 3904
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3905
f989148965_487.returns.push(1373483125289);
// 3906
o1 = {};
// 3907
f989148965_0.returns.push(o1);
// 3908
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3909
f989148965_487.returns.push(1373483125289);
// 3910
o1 = {};
// 3911
f989148965_0.returns.push(o1);
// 3912
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3913
f989148965_487.returns.push(1373483125289);
// 3914
o1 = {};
// 3915
f989148965_0.returns.push(o1);
// 3916
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3917
f989148965_487.returns.push(1373483125289);
// 3918
o1 = {};
// 3919
f989148965_0.returns.push(o1);
// 3920
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3921
f989148965_487.returns.push(1373483125289);
// 3922
o1 = {};
// 3923
f989148965_0.returns.push(o1);
// 3924
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3925
f989148965_487.returns.push(1373483125293);
// 3926
o1 = {};
// 3927
f989148965_0.returns.push(o1);
// 3928
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3929
f989148965_487.returns.push(1373483125293);
// 3930
o1 = {};
// 3931
f989148965_0.returns.push(o1);
// 3932
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3933
f989148965_487.returns.push(1373483125293);
// 3934
o1 = {};
// 3935
f989148965_0.returns.push(o1);
// 3936
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3937
f989148965_487.returns.push(1373483125294);
// 3938
o1 = {};
// 3939
f989148965_0.returns.push(o1);
// 3940
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3941
f989148965_487.returns.push(1373483125294);
// 3942
o1 = {};
// 3943
f989148965_0.returns.push(o1);
// 3944
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3945
f989148965_487.returns.push(1373483125295);
// 3946
o1 = {};
// 3947
f989148965_0.returns.push(o1);
// 3948
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3949
f989148965_487.returns.push(1373483125295);
// 3950
o1 = {};
// 3951
f989148965_0.returns.push(o1);
// 3952
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3953
f989148965_487.returns.push(1373483125295);
// 3954
o1 = {};
// 3955
f989148965_0.returns.push(o1);
// 3956
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3957
f989148965_487.returns.push(1373483125295);
// 3958
o1 = {};
// 3959
f989148965_0.returns.push(o1);
// 3960
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3961
f989148965_487.returns.push(1373483125295);
// 3962
o1 = {};
// 3963
f989148965_0.returns.push(o1);
// 3964
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3965
f989148965_487.returns.push(1373483125295);
// 3966
o1 = {};
// 3967
f989148965_0.returns.push(o1);
// 3968
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3969
f989148965_487.returns.push(1373483125296);
// 3970
o1 = {};
// 3971
f989148965_0.returns.push(o1);
// 3972
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3973
f989148965_487.returns.push(1373483125296);
// 3974
o1 = {};
// 3975
f989148965_0.returns.push(o1);
// 3976
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3977
f989148965_487.returns.push(1373483125296);
// 3978
o1 = {};
// 3979
f989148965_0.returns.push(o1);
// 3980
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3981
f989148965_487.returns.push(1373483125297);
// 3982
o1 = {};
// 3983
f989148965_0.returns.push(o1);
// 3984
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3985
f989148965_487.returns.push(1373483125297);
// 3986
o1 = {};
// 3987
f989148965_0.returns.push(o1);
// 3988
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3989
f989148965_487.returns.push(1373483125297);
// 3990
o1 = {};
// 3991
f989148965_0.returns.push(o1);
// 3992
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3993
f989148965_487.returns.push(1373483125298);
// 3994
o1 = {};
// 3995
f989148965_0.returns.push(o1);
// 3996
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 3997
f989148965_487.returns.push(1373483125298);
// 3998
o1 = {};
// 3999
f989148965_0.returns.push(o1);
// 4000
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4001
f989148965_487.returns.push(1373483125298);
// 4002
o1 = {};
// 4003
f989148965_0.returns.push(o1);
// 4004
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4005
f989148965_487.returns.push(1373483125299);
// 4006
o1 = {};
// 4007
f989148965_0.returns.push(o1);
// 4008
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4009
f989148965_487.returns.push(1373483125299);
// 4010
o1 = {};
// 4011
f989148965_0.returns.push(o1);
// 4012
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4013
f989148965_487.returns.push(1373483125299);
// 4014
o1 = {};
// 4015
f989148965_0.returns.push(o1);
// 4016
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4017
f989148965_487.returns.push(1373483125299);
// 4018
o1 = {};
// 4019
f989148965_0.returns.push(o1);
// 4020
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4021
f989148965_487.returns.push(1373483125299);
// 4022
o1 = {};
// 4023
f989148965_0.returns.push(o1);
// 4024
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4025
f989148965_487.returns.push(1373483125299);
// 4026
o1 = {};
// 4027
f989148965_0.returns.push(o1);
// 4028
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4029
f989148965_487.returns.push(1373483125305);
// 4030
o1 = {};
// 4031
f989148965_0.returns.push(o1);
// 4032
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4033
f989148965_487.returns.push(1373483125306);
// 4034
o1 = {};
// 4035
f989148965_0.returns.push(o1);
// 4036
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4037
f989148965_487.returns.push(1373483125306);
// 4038
o1 = {};
// 4039
f989148965_0.returns.push(o1);
// 4040
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4041
f989148965_487.returns.push(1373483125307);
// 4042
o1 = {};
// 4043
f989148965_0.returns.push(o1);
// 4044
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4045
f989148965_487.returns.push(1373483125307);
// 4046
o1 = {};
// 4047
f989148965_0.returns.push(o1);
// 4048
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4049
f989148965_487.returns.push(1373483125307);
// 4050
o1 = {};
// 4051
f989148965_0.returns.push(o1);
// 4052
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4053
f989148965_487.returns.push(1373483125308);
// 4054
o1 = {};
// 4055
f989148965_0.returns.push(o1);
// 4056
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4057
f989148965_487.returns.push(1373483125308);
// 4058
o1 = {};
// 4059
f989148965_0.returns.push(o1);
// 4060
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4061
f989148965_487.returns.push(1373483125309);
// 4062
o1 = {};
// 4063
f989148965_0.returns.push(o1);
// 4064
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4065
f989148965_487.returns.push(1373483125309);
// 4066
o1 = {};
// 4067
f989148965_0.returns.push(o1);
// 4068
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4069
f989148965_487.returns.push(1373483125309);
// 4070
o1 = {};
// 4071
f989148965_0.returns.push(o1);
// 4072
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4073
f989148965_487.returns.push(1373483125310);
// 4074
o1 = {};
// 4075
f989148965_0.returns.push(o1);
// 4076
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4077
f989148965_487.returns.push(1373483125310);
// 4078
o1 = {};
// 4079
f989148965_0.returns.push(o1);
// 4080
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4081
f989148965_487.returns.push(1373483125311);
// 4082
o1 = {};
// 4083
f989148965_0.returns.push(o1);
// 4084
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4085
f989148965_487.returns.push(1373483125311);
// 4086
o1 = {};
// 4087
f989148965_0.returns.push(o1);
// 4088
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4089
f989148965_487.returns.push(1373483125311);
// 4090
o1 = {};
// 4091
f989148965_0.returns.push(o1);
// 4092
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4093
f989148965_487.returns.push(1373483125312);
// 4094
o1 = {};
// 4095
f989148965_0.returns.push(o1);
// 4096
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4097
f989148965_487.returns.push(1373483125312);
// 4098
o1 = {};
// 4099
f989148965_0.returns.push(o1);
// 4100
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4101
f989148965_487.returns.push(1373483125312);
// 4102
o1 = {};
// 4103
f989148965_0.returns.push(o1);
// 4104
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4105
f989148965_487.returns.push(1373483125312);
// 4106
o1 = {};
// 4107
f989148965_0.returns.push(o1);
// 4108
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4109
f989148965_487.returns.push(1373483125312);
// 4110
o1 = {};
// 4111
f989148965_0.returns.push(o1);
// 4112
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4113
f989148965_487.returns.push(1373483125313);
// 4114
o1 = {};
// 4115
f989148965_0.returns.push(o1);
// 4116
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4117
f989148965_487.returns.push(1373483125313);
// 4118
o1 = {};
// 4119
f989148965_0.returns.push(o1);
// 4120
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4121
f989148965_487.returns.push(1373483125313);
// 4122
o1 = {};
// 4123
f989148965_0.returns.push(o1);
// 4124
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4125
f989148965_487.returns.push(1373483125314);
// 4126
o1 = {};
// 4127
f989148965_0.returns.push(o1);
// 4128
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4129
f989148965_487.returns.push(1373483125314);
// 4130
o1 = {};
// 4131
f989148965_0.returns.push(o1);
// 4132
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4133
f989148965_487.returns.push(1373483125315);
// 4134
o1 = {};
// 4135
f989148965_0.returns.push(o1);
// 4136
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4137
f989148965_487.returns.push(1373483125322);
// 4138
o1 = {};
// 4139
f989148965_0.returns.push(o1);
// 4140
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4141
f989148965_487.returns.push(1373483125322);
// 4142
o1 = {};
// 4143
f989148965_0.returns.push(o1);
// 4144
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4145
f989148965_487.returns.push(1373483125322);
// 4146
o1 = {};
// 4147
f989148965_0.returns.push(o1);
// 4148
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4149
f989148965_487.returns.push(1373483125322);
// 4150
o1 = {};
// 4151
f989148965_0.returns.push(o1);
// 4152
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4153
f989148965_487.returns.push(1373483125323);
// 4154
o1 = {};
// 4155
f989148965_0.returns.push(o1);
// 4156
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4157
f989148965_487.returns.push(1373483125323);
// 4158
o1 = {};
// 4159
f989148965_0.returns.push(o1);
// 4160
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4161
f989148965_487.returns.push(1373483125323);
// 4162
o1 = {};
// 4163
f989148965_0.returns.push(o1);
// 4164
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4165
f989148965_487.returns.push(1373483125323);
// 4166
o1 = {};
// 4167
f989148965_0.returns.push(o1);
// 4168
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4169
f989148965_487.returns.push(1373483125324);
// 4170
o1 = {};
// 4171
f989148965_0.returns.push(o1);
// 4172
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4173
f989148965_487.returns.push(1373483125324);
// 4174
o1 = {};
// 4175
f989148965_0.returns.push(o1);
// 4176
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4177
f989148965_487.returns.push(1373483125324);
// 4178
o1 = {};
// 4179
f989148965_0.returns.push(o1);
// 4180
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4181
f989148965_487.returns.push(1373483125324);
// 4182
o1 = {};
// 4183
f989148965_0.returns.push(o1);
// 4184
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4185
f989148965_487.returns.push(1373483125325);
// 4186
o1 = {};
// 4187
f989148965_0.returns.push(o1);
// 4188
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4189
f989148965_487.returns.push(1373483125325);
// 4190
o1 = {};
// 4191
f989148965_0.returns.push(o1);
// 4192
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4193
f989148965_487.returns.push(1373483125325);
// 4194
o1 = {};
// 4195
f989148965_0.returns.push(o1);
// 4196
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4197
f989148965_487.returns.push(1373483125325);
// 4198
o1 = {};
// 4199
f989148965_0.returns.push(o1);
// 4200
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4201
f989148965_487.returns.push(1373483125325);
// 4202
o1 = {};
// 4203
f989148965_0.returns.push(o1);
// 4204
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4205
f989148965_487.returns.push(1373483125325);
// 4206
o1 = {};
// 4207
f989148965_0.returns.push(o1);
// 4208
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4209
f989148965_487.returns.push(1373483125325);
// 4210
o1 = {};
// 4211
f989148965_0.returns.push(o1);
// 4212
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4213
f989148965_487.returns.push(1373483125326);
// 4214
o1 = {};
// 4215
f989148965_0.returns.push(o1);
// 4216
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4217
f989148965_487.returns.push(1373483125326);
// 4218
o1 = {};
// 4219
f989148965_0.returns.push(o1);
// 4220
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4221
f989148965_487.returns.push(1373483125326);
// 4222
o1 = {};
// 4223
f989148965_0.returns.push(o1);
// 4224
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4225
f989148965_487.returns.push(1373483125326);
// 4226
o1 = {};
// 4227
f989148965_0.returns.push(o1);
// 4228
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4229
f989148965_487.returns.push(1373483125327);
// 4230
o1 = {};
// 4231
f989148965_0.returns.push(o1);
// 4232
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4233
f989148965_487.returns.push(1373483125327);
// 4234
o1 = {};
// 4235
f989148965_0.returns.push(o1);
// 4236
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4237
f989148965_487.returns.push(1373483125328);
// 4238
o1 = {};
// 4239
f989148965_0.returns.push(o1);
// 4240
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4241
f989148965_487.returns.push(1373483125333);
// 4242
o1 = {};
// 4243
f989148965_0.returns.push(o1);
// 4244
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4245
f989148965_487.returns.push(1373483125333);
// 4246
o1 = {};
// 4247
f989148965_0.returns.push(o1);
// 4248
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4249
f989148965_487.returns.push(1373483125334);
// 4250
o1 = {};
// 4251
f989148965_0.returns.push(o1);
// 4252
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4253
f989148965_487.returns.push(1373483125334);
// 4254
o1 = {};
// 4255
f989148965_0.returns.push(o1);
// 4256
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4257
f989148965_487.returns.push(1373483125334);
// 4258
o1 = {};
// 4259
f989148965_0.returns.push(o1);
// 4260
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4261
f989148965_487.returns.push(1373483125334);
// 4262
o1 = {};
// 4263
f989148965_0.returns.push(o1);
// 4264
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4265
f989148965_487.returns.push(1373483125335);
// 4266
o1 = {};
// 4267
f989148965_0.returns.push(o1);
// 4268
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4269
f989148965_487.returns.push(1373483125335);
// 4270
o1 = {};
// 4271
f989148965_0.returns.push(o1);
// 4272
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4273
f989148965_487.returns.push(1373483125335);
// 4274
o1 = {};
// 4275
f989148965_0.returns.push(o1);
// 4276
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4277
f989148965_487.returns.push(1373483125336);
// 4278
o1 = {};
// 4279
f989148965_0.returns.push(o1);
// 4280
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4281
f989148965_487.returns.push(1373483125336);
// 4282
o1 = {};
// 4283
f989148965_0.returns.push(o1);
// 4284
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4285
f989148965_487.returns.push(1373483125337);
// 4286
o1 = {};
// 4287
f989148965_0.returns.push(o1);
// 4288
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4289
f989148965_487.returns.push(1373483125337);
// 4290
o1 = {};
// 4291
f989148965_0.returns.push(o1);
// 4292
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4293
f989148965_487.returns.push(1373483125337);
// 4294
o1 = {};
// 4295
f989148965_0.returns.push(o1);
// 4296
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4297
f989148965_487.returns.push(1373483125337);
// 4298
o1 = {};
// 4299
f989148965_0.returns.push(o1);
// 4300
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4301
f989148965_487.returns.push(1373483125338);
// 4302
o1 = {};
// 4303
f989148965_0.returns.push(o1);
// 4304
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4305
f989148965_487.returns.push(1373483125338);
// 4306
o1 = {};
// 4307
f989148965_0.returns.push(o1);
// 4308
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4309
f989148965_487.returns.push(1373483125338);
// 4310
o1 = {};
// 4311
f989148965_0.returns.push(o1);
// 4312
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4313
f989148965_487.returns.push(1373483125339);
// 4314
o1 = {};
// 4315
f989148965_0.returns.push(o1);
// 4316
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4317
f989148965_487.returns.push(1373483125339);
// 4318
o1 = {};
// 4319
f989148965_0.returns.push(o1);
// 4320
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4321
f989148965_487.returns.push(1373483125339);
// 4322
o1 = {};
// 4323
f989148965_0.returns.push(o1);
// 4324
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4325
f989148965_487.returns.push(1373483125340);
// 4326
o1 = {};
// 4327
f989148965_0.returns.push(o1);
// 4328
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4329
f989148965_487.returns.push(1373483125340);
// 4330
o1 = {};
// 4331
f989148965_0.returns.push(o1);
// 4332
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4333
f989148965_487.returns.push(1373483125340);
// 4334
o1 = {};
// 4335
f989148965_0.returns.push(o1);
// 4336
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4337
f989148965_487.returns.push(1373483125340);
// 4338
o1 = {};
// 4339
f989148965_0.returns.push(o1);
// 4340
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4341
f989148965_487.returns.push(1373483125340);
// 4342
o1 = {};
// 4343
f989148965_0.returns.push(o1);
// 4344
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4345
f989148965_487.returns.push(1373483125341);
// 4346
o1 = {};
// 4347
f989148965_0.returns.push(o1);
// 4348
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4349
f989148965_487.returns.push(1373483125345);
// 4350
o1 = {};
// 4351
f989148965_0.returns.push(o1);
// 4352
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4353
f989148965_487.returns.push(1373483125346);
// 4354
o1 = {};
// 4355
f989148965_0.returns.push(o1);
// 4356
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4357
f989148965_487.returns.push(1373483125346);
// 4358
o1 = {};
// 4359
f989148965_0.returns.push(o1);
// 4360
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4361
f989148965_487.returns.push(1373483125346);
// 4362
o1 = {};
// 4363
f989148965_0.returns.push(o1);
// 4364
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4365
f989148965_487.returns.push(1373483125346);
// 4366
o1 = {};
// 4367
f989148965_0.returns.push(o1);
// 4368
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4369
f989148965_487.returns.push(1373483125346);
// 4370
o1 = {};
// 4371
f989148965_0.returns.push(o1);
// 4372
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4373
f989148965_487.returns.push(1373483125346);
// 4374
o1 = {};
// 4375
f989148965_0.returns.push(o1);
// 4376
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4377
f989148965_487.returns.push(1373483125347);
// 4378
o1 = {};
// 4379
f989148965_0.returns.push(o1);
// 4380
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4381
f989148965_487.returns.push(1373483125347);
// 4382
o1 = {};
// 4383
f989148965_0.returns.push(o1);
// 4384
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4385
f989148965_487.returns.push(1373483125347);
// 4386
o1 = {};
// 4387
f989148965_0.returns.push(o1);
// 4388
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4389
f989148965_487.returns.push(1373483125348);
// 4390
o1 = {};
// 4391
f989148965_0.returns.push(o1);
// 4392
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4393
f989148965_487.returns.push(1373483125348);
// 4394
o1 = {};
// 4395
f989148965_0.returns.push(o1);
// 4396
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4397
f989148965_487.returns.push(1373483125348);
// 4398
o1 = {};
// 4399
f989148965_0.returns.push(o1);
// 4400
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4401
f989148965_487.returns.push(1373483125348);
// 4402
o1 = {};
// 4403
f989148965_0.returns.push(o1);
// 4404
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4405
f989148965_487.returns.push(1373483125348);
// 4406
o1 = {};
// 4407
f989148965_0.returns.push(o1);
// 4408
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4409
f989148965_487.returns.push(1373483125348);
// 4410
o1 = {};
// 4411
f989148965_0.returns.push(o1);
// 4412
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4413
f989148965_487.returns.push(1373483125349);
// 4414
o1 = {};
// 4415
f989148965_0.returns.push(o1);
// 4416
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4417
f989148965_487.returns.push(1373483125349);
// 4418
o1 = {};
// 4419
f989148965_0.returns.push(o1);
// 4420
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4421
f989148965_487.returns.push(1373483125349);
// 4422
o1 = {};
// 4423
f989148965_0.returns.push(o1);
// 4424
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4425
f989148965_487.returns.push(1373483125349);
// 4426
o1 = {};
// 4427
f989148965_0.returns.push(o1);
// 4428
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4429
f989148965_487.returns.push(1373483125350);
// 4430
o1 = {};
// 4431
f989148965_0.returns.push(o1);
// 4432
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4433
f989148965_487.returns.push(1373483125350);
// 4434
o1 = {};
// 4435
f989148965_0.returns.push(o1);
// 4436
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4437
f989148965_487.returns.push(1373483125351);
// 4438
o1 = {};
// 4439
f989148965_0.returns.push(o1);
// 4440
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4441
f989148965_487.returns.push(1373483125351);
// 4442
o1 = {};
// 4443
f989148965_0.returns.push(o1);
// 4444
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4445
f989148965_487.returns.push(1373483125351);
// 4446
o1 = {};
// 4447
f989148965_0.returns.push(o1);
// 4448
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4449
f989148965_487.returns.push(1373483125351);
// 4450
o1 = {};
// 4451
f989148965_0.returns.push(o1);
// 4452
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4453
f989148965_487.returns.push(1373483125356);
// 4454
o1 = {};
// 4455
f989148965_0.returns.push(o1);
// 4456
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4457
f989148965_487.returns.push(1373483125357);
// 4458
o1 = {};
// 4459
f989148965_0.returns.push(o1);
// 4460
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4461
f989148965_487.returns.push(1373483125357);
// 4462
o1 = {};
// 4463
f989148965_0.returns.push(o1);
// 4464
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4465
f989148965_487.returns.push(1373483125357);
// 4466
o1 = {};
// 4467
f989148965_0.returns.push(o1);
// 4468
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4469
f989148965_487.returns.push(1373483125358);
// 4470
o1 = {};
// 4471
f989148965_0.returns.push(o1);
// 4472
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4473
f989148965_487.returns.push(1373483125358);
// 4474
o1 = {};
// 4475
f989148965_0.returns.push(o1);
// 4476
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4477
f989148965_487.returns.push(1373483125358);
// 4478
o1 = {};
// 4479
f989148965_0.returns.push(o1);
// 4480
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4481
f989148965_487.returns.push(1373483125358);
// 4482
o1 = {};
// 4483
f989148965_0.returns.push(o1);
// 4484
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4485
f989148965_487.returns.push(1373483125359);
// 4486
o1 = {};
// 4487
f989148965_0.returns.push(o1);
// 4488
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4489
f989148965_487.returns.push(1373483125359);
// 4490
o1 = {};
// 4491
f989148965_0.returns.push(o1);
// 4492
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4493
f989148965_487.returns.push(1373483125359);
// 4494
o1 = {};
// 4495
f989148965_0.returns.push(o1);
// 4496
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4497
f989148965_487.returns.push(1373483125359);
// 4498
o1 = {};
// 4499
f989148965_0.returns.push(o1);
// 4500
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4501
f989148965_487.returns.push(1373483125360);
// 4502
o1 = {};
// 4503
f989148965_0.returns.push(o1);
// 4504
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4505
f989148965_487.returns.push(1373483125360);
// 4506
o1 = {};
// 4507
f989148965_0.returns.push(o1);
// 4508
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4509
f989148965_487.returns.push(1373483125360);
// 4510
o1 = {};
// 4511
f989148965_0.returns.push(o1);
// 4512
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4513
f989148965_487.returns.push(1373483125360);
// 4514
o1 = {};
// 4515
f989148965_0.returns.push(o1);
// 4516
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4517
f989148965_487.returns.push(1373483125360);
// 4518
o1 = {};
// 4519
f989148965_0.returns.push(o1);
// 4520
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4521
f989148965_487.returns.push(1373483125360);
// 4522
o1 = {};
// 4523
f989148965_0.returns.push(o1);
// 4524
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4525
f989148965_487.returns.push(1373483125361);
// 4526
o1 = {};
// 4527
f989148965_0.returns.push(o1);
// 4528
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4529
f989148965_487.returns.push(1373483125361);
// 4530
o1 = {};
// 4531
f989148965_0.returns.push(o1);
// 4532
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4533
f989148965_487.returns.push(1373483125361);
// 4534
o1 = {};
// 4535
f989148965_0.returns.push(o1);
// 4536
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4537
f989148965_487.returns.push(1373483125361);
// 4538
o1 = {};
// 4539
f989148965_0.returns.push(o1);
// 4540
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4541
f989148965_487.returns.push(1373483125362);
// 4542
o1 = {};
// 4543
f989148965_0.returns.push(o1);
// 4544
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4545
f989148965_487.returns.push(1373483125362);
// 4546
o1 = {};
// 4547
f989148965_0.returns.push(o1);
// 4548
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4549
f989148965_487.returns.push(1373483125362);
// 4550
o1 = {};
// 4551
f989148965_0.returns.push(o1);
// 4552
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4553
f989148965_487.returns.push(1373483125362);
// 4554
o1 = {};
// 4555
f989148965_0.returns.push(o1);
// 4556
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4557
f989148965_487.returns.push(1373483125363);
// 4559
o1 = {};
// 4560
f989148965_421.returns.push(o1);
// 4561
o6 = {};
// 4562
o1.style = o6;
// undefined
o1 = null;
// undefined
o6 = null;
// 4563
o1 = {};
// 4564
f989148965_0.returns.push(o1);
// 4565
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4566
f989148965_487.returns.push(1373483125383);
// 4567
o1 = {};
// 4568
f989148965_0.returns.push(o1);
// 4569
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4570
f989148965_487.returns.push(1373483125384);
// 4571
o1 = {};
// 4572
f989148965_0.returns.push(o1);
// 4573
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4574
f989148965_487.returns.push(1373483125384);
// 4575
o1 = {};
// 4576
f989148965_0.returns.push(o1);
// 4577
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4578
f989148965_487.returns.push(1373483125384);
// 4579
o1 = {};
// 4580
f989148965_0.returns.push(o1);
// 4581
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4582
f989148965_487.returns.push(1373483125384);
// 4583
o1 = {};
// 4584
f989148965_0.returns.push(o1);
// 4585
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4586
f989148965_487.returns.push(1373483125384);
// 4587
o1 = {};
// 4588
f989148965_0.returns.push(o1);
// 4589
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4590
f989148965_487.returns.push(1373483125388);
// 4591
o1 = {};
// 4592
f989148965_0.returns.push(o1);
// 4593
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4594
f989148965_487.returns.push(1373483125388);
// 4595
o1 = {};
// 4596
f989148965_0.returns.push(o1);
// 4597
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4598
f989148965_487.returns.push(1373483125388);
// 4599
o1 = {};
// 4600
f989148965_0.returns.push(o1);
// 4601
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4602
f989148965_487.returns.push(1373483125389);
// 4603
o1 = {};
// 4604
f989148965_0.returns.push(o1);
// 4605
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4606
f989148965_487.returns.push(1373483125389);
// 4607
o1 = {};
// 4608
f989148965_0.returns.push(o1);
// 4609
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4610
f989148965_487.returns.push(1373483125389);
// 4611
o1 = {};
// 4612
f989148965_0.returns.push(o1);
// 4613
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4614
f989148965_487.returns.push(1373483125389);
// 4615
o1 = {};
// 4616
f989148965_0.returns.push(o1);
// 4617
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4618
f989148965_487.returns.push(1373483125390);
// 4619
o1 = {};
// 4620
f989148965_0.returns.push(o1);
// 4621
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4622
f989148965_487.returns.push(1373483125390);
// 4623
o1 = {};
// 4624
f989148965_0.returns.push(o1);
// 4625
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4626
f989148965_487.returns.push(1373483125390);
// 4627
o1 = {};
// 4628
f989148965_0.returns.push(o1);
// 4629
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4630
f989148965_487.returns.push(1373483125391);
// 4631
o1 = {};
// 4632
f989148965_0.returns.push(o1);
// 4633
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4634
f989148965_487.returns.push(1373483125391);
// 4635
o1 = {};
// 4636
f989148965_0.returns.push(o1);
// 4637
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4638
f989148965_487.returns.push(1373483125391);
// 4639
o1 = {};
// 4640
f989148965_0.returns.push(o1);
// 4641
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4642
f989148965_487.returns.push(1373483125392);
// 4643
o1 = {};
// 4644
f989148965_0.returns.push(o1);
// 4645
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4646
f989148965_487.returns.push(1373483125392);
// 4647
o1 = {};
// 4648
f989148965_0.returns.push(o1);
// 4649
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4650
f989148965_487.returns.push(1373483125392);
// 4651
o1 = {};
// 4652
f989148965_0.returns.push(o1);
// 4653
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4654
f989148965_487.returns.push(1373483125393);
// 4655
o1 = {};
// 4656
f989148965_0.returns.push(o1);
// 4657
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4658
f989148965_487.returns.push(1373483125393);
// 4659
o1 = {};
// 4660
f989148965_0.returns.push(o1);
// 4661
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4662
f989148965_487.returns.push(1373483125395);
// 4663
o1 = {};
// 4664
f989148965_0.returns.push(o1);
// 4665
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4666
f989148965_487.returns.push(1373483125402);
// 4667
o1 = {};
// 4668
f989148965_0.returns.push(o1);
// 4669
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4670
f989148965_487.returns.push(1373483125402);
// 4671
o1 = {};
// 4672
f989148965_0.returns.push(o1);
// 4673
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4674
f989148965_487.returns.push(1373483125402);
// 4675
o1 = {};
// 4676
f989148965_0.returns.push(o1);
// 4677
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4678
f989148965_487.returns.push(1373483125402);
// 4679
o1 = {};
// 4680
f989148965_0.returns.push(o1);
// 4681
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4682
f989148965_487.returns.push(1373483125403);
// 4683
o1 = {};
// 4684
f989148965_0.returns.push(o1);
// 4685
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4686
f989148965_487.returns.push(1373483125403);
// 4687
o1 = {};
// 4688
f989148965_0.returns.push(o1);
// 4689
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4690
f989148965_487.returns.push(1373483125403);
// 4691
o1 = {};
// 4692
f989148965_0.returns.push(o1);
// 4693
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4694
f989148965_487.returns.push(1373483125404);
// 4695
o1 = {};
// 4696
f989148965_0.returns.push(o1);
// 4697
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4698
f989148965_487.returns.push(1373483125404);
// 4699
o1 = {};
// 4700
f989148965_0.returns.push(o1);
// 4701
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4702
f989148965_487.returns.push(1373483125404);
// 4703
o1 = {};
// 4704
f989148965_0.returns.push(o1);
// 4705
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4706
f989148965_487.returns.push(1373483125404);
// 4707
o1 = {};
// 4708
f989148965_0.returns.push(o1);
// 4709
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4710
f989148965_487.returns.push(1373483125405);
// 4711
o1 = {};
// 4712
f989148965_0.returns.push(o1);
// 4713
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4714
f989148965_487.returns.push(1373483125405);
// 4715
o1 = {};
// 4716
f989148965_0.returns.push(o1);
// 4717
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4718
f989148965_487.returns.push(1373483125405);
// 4719
o1 = {};
// 4720
f989148965_0.returns.push(o1);
// 4721
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4722
f989148965_487.returns.push(1373483125406);
// 4723
o1 = {};
// 4724
f989148965_0.returns.push(o1);
// 4725
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4726
f989148965_487.returns.push(1373483125406);
// 4727
o1 = {};
// 4728
f989148965_0.returns.push(o1);
// 4729
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4730
f989148965_487.returns.push(1373483125406);
// 4731
o1 = {};
// 4732
f989148965_0.returns.push(o1);
// 4733
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4734
f989148965_487.returns.push(1373483125406);
// 4735
o1 = {};
// 4736
f989148965_0.returns.push(o1);
// 4737
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4738
f989148965_487.returns.push(1373483125407);
// 4739
o1 = {};
// 4740
f989148965_0.returns.push(o1);
// 4741
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4742
f989148965_487.returns.push(1373483125407);
// 4743
o1 = {};
// 4744
f989148965_0.returns.push(o1);
// 4745
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4746
f989148965_487.returns.push(1373483125407);
// 4747
o1 = {};
// 4748
f989148965_0.returns.push(o1);
// 4749
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4750
f989148965_487.returns.push(1373483125407);
// 4751
o1 = {};
// 4752
f989148965_0.returns.push(o1);
// 4753
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4754
f989148965_487.returns.push(1373483125407);
// 4755
o1 = {};
// 4756
f989148965_0.returns.push(o1);
// 4757
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4758
f989148965_487.returns.push(1373483125408);
// 4759
o1 = {};
// 4760
f989148965_0.returns.push(o1);
// 4761
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4762
f989148965_487.returns.push(1373483125408);
// 4763
o1 = {};
// 4764
f989148965_0.returns.push(o1);
// 4765
o1.getTime = f989148965_487;
// undefined
o1 = null;
// 4766
f989148965_487.returns.push(1373483125408);
// 4767
o1 = {};
// 4768
f989148965_0.returns.push(o1);
// undefined
o1 = null;
// 0
JSBNG_Replay$ = function(real, cb) { if (!real) return;
// 867
geval("JSBNG__document.documentElement.className = ((((JSBNG__document.documentElement.className + \" \")) + JSBNG__document.documentElement.getAttribute(\"data-fouc-class-names\")));");
// 877
geval("(function() {\n    {\n        function f(a) {\n            a = ((a || window.JSBNG__event));\n            if (!a) {\n                return;\n            }\n        ;\n        ;\n            ((((!a.target && a.srcElement)) && (a.target = a.srcElement)));\n            if (!j(a)) {\n                return;\n            }\n        ;\n        ;\n            if (!JSBNG__document.JSBNG__addEventListener) {\n                var b = {\n                };\n                {\n                    var fin0keys = ((window.top.JSBNG_Replay.forInKeys)((a))), fin0i = (0);\n                    var c;\n                    for (; (fin0i < fin0keys.length); (fin0i++)) {\n                        ((c) = (fin0keys[fin0i]));\n                        {\n                            b[c] = a[c];\n                        ;\n                        };\n                    };\n                };\n            ;\n                a = b;\n            }\n        ;\n        ;\n            a.preventDefault = a.stopPropagation = a.stopImmediatePropagation = function() {\n            \n            };\n            d.push(a);\n            return !1;\n        };\n        ((window.top.JSBNG_Replay.s19277ddcd28db6dd01a1d67d562dfbbffa3c6a17_1.push)((f)));\n    };\n;\n    function g($) {\n        i();\n        for (var b = 0, c; c = d[b]; b++) {\n            var e = $(c.target);\n            if (((((c.type == \"click\")) && ((c.target.tagName.toLowerCase() == \"a\"))))) {\n                var f = $.data(e.get(0), \"events\"), g = ((f && f.click)), j = ((!c.target.hostname.match(a) || !c.target.href.match(/#$/)));\n                if (((!g && j))) {\n                    window.JSBNG__location = c.target.href;\n                    continue;\n                }\n            ;\n            ;\n            }\n        ;\n        ;\n            e.trigger(c);\n        };\n    ;\n        window.swiftActionQueue.wasFlushed = !0;\n    };\n;\n    {\n        function i() {\n            ((e && JSBNG__clearTimeout(e)));\n            for (var a = 0; ((a < c.length)); a++) {\n                JSBNG__document[((\"JSBNG__on\" + c[a]))] = null;\n            ;\n            };\n        ;\n        };\n        ((window.top.JSBNG_Replay.s19277ddcd28db6dd01a1d67d562dfbbffa3c6a17_4.push)((i)));\n    };\n;\n    function j(c) {\n        var d = c.target.tagName.toLowerCase();\n        if (((d == \"label\"))) {\n            if (c.target.getAttribute(\"for\")) {\n                var e = JSBNG__document.getElementById(c.target.getAttribute(\"for\"));\n                if (((e.getAttribute(\"type\") == \"checkbox\"))) {\n                    return !1;\n                }\n            ;\n            ;\n            }\n             else for (var f = 0; ((f < c.target.childNodes.length)); f++) {\n                if (((((((c.target.childNodes[f].tagName || \"\")).toLowerCase() == \"input\")) && ((c.target.childNodes[f].getAttribute(\"type\") == \"checkbox\"))))) {\n                    return !1;\n                }\n            ;\n            ;\n            }\n        ;\n        }\n    ;\n    ;\n        if (((((((d == \"textarea\")) || ((((d == \"input\")) && ((c.target.getAttribute(\"type\") == \"text\")))))) || ((c.target.getAttribute(\"contenteditable\") == \"true\"))))) {\n            if (c.type.match(b)) {\n                return !1;\n            }\n        ;\n        }\n    ;\n    ;\n        return ((c.metaKey ? !1 : ((((((c.clientX && c.shiftKey)) && ((d == \"a\")))) ? !1 : ((((((c.target && c.target.hostname)) && !c.target.hostname.match(a))) ? !1 : !0))))));\n    };\n;\n    var a = /^([^\\.]+\\.)*twitter.com$/, b = /^key/, c = [\"click\",\"keydown\",\"keypress\",\"keyup\",], d = [], e = null;\n    for (var k = 0; ((k < c.length)); k++) {\n        JSBNG__document[((\"JSBNG__on\" + c[k]))] = f;\n    ;\n    };\n;\n    JSBNG__setTimeout(i, 10000);\n    window.swiftActionQueue = {\n        flush: g,\n        wasFlushed: !1\n    };\n})();");
// 883
geval("(function() {\n    function a(a) {\n        a.target.setAttribute(\"data-in-composition\", \"true\");\n    };\n;\n    function b(a) {\n        a.target.removeAttribute(\"data-in-composition\");\n    };\n;\n    if (JSBNG__document.JSBNG__addEventListener) {\n        JSBNG__document.JSBNG__addEventListener(\"compositionstart\", a, !1);\n        JSBNG__document.JSBNG__addEventListener(\"compositionend\", b, !1);\n    }\n;\n;\n})();");
// 890
geval("try {\n    JSBNG__document.domain = \"twitter.com\";\n    (function() {\n        function a() {\n            JSBNG__document.write = \"\";\n            window.JSBNG__top.JSBNG__location = window.JSBNG__self.JSBNG__location;\n            JSBNG__setTimeout(function() {\n                JSBNG__document.body.innerHTML = \"\";\n            }, 0);\n            window.JSBNG__self.JSBNG__onload = function(a) {\n                JSBNG__document.body.innerHTML = \"\";\n            };\n        };\n    ;\n        if (((window.JSBNG__top !== window.JSBNG__self))) {\n            try {\n                ((window.JSBNG__top.JSBNG__location.host || a()));\n            } catch (b) {\n                a();\n            };\n        }\n    ;\n    ;\n    })();\n    (function(a, b) {\n        function H(a) {\n            var b = G[a] = {\n            };\n            q.each(a.split(t), function(_, a) {\n                b[a] = !0;\n            });\n            return b;\n        };\n    ;\n        function K(a, c, d) {\n            if (((((d === b)) && ((a.nodeType === 1))))) {\n                var e = ((\"data-\" + c.replace(J, \"-$1\").toLowerCase()));\n                d = a.getAttribute(e);\n                if (((typeof d == \"string\"))) {\n                    try {\n                        d = ((((d === \"true\")) ? !0 : ((((d === \"false\")) ? !1 : ((((d === \"null\")) ? null : ((((((+d + \"\")) === d)) ? +d : ((I.test(d) ? q.parseJSON(d) : d))))))))));\n                    } catch (f) {\n                    \n                    };\n                ;\n                    q.data(a, c, d);\n                }\n                 else d = b;\n            ;\n            ;\n            }\n        ;\n        ;\n            return d;\n        };\n    ;\n        function L(a) {\n            var b;\n            {\n                var fin1keys = ((window.top.JSBNG_Replay.forInKeys)((a))), fin1i = (0);\n                (0);\n                for (; (fin1i < fin1keys.length); (fin1i++)) {\n                    ((b) = (fin1keys[fin1i]));\n                    {\n                        if (((((b === \"data\")) && q.isEmptyObject(a[b])))) {\n                            continue;\n                        }\n                    ;\n                    ;\n                        if (((b !== \"toJSON\"))) {\n                            return !1;\n                        }\n                    ;\n                    ;\n                    };\n                };\n            };\n        ;\n            return !0;\n        };\n    ;\n        function db() {\n            return !1;\n        };\n    ;\n        function eb() {\n            return !0;\n        };\n    ;\n        function kb(a) {\n            return ((((!a || !a.parentNode)) || ((a.parentNode.nodeType === 11))));\n        };\n    ;\n        function lb(a, b) {\n            do a = a[b]; while (((a && ((a.nodeType !== 1)))));\n            return a;\n        };\n    ;\n        function mb(a, b, c) {\n            b = ((b || 0));\n            if (q.isFunction(b)) {\n                return q.grep(a, function(a, d) {\n                    var e = !!b.call(a, d, a);\n                    return ((e === c));\n                });\n            }\n        ;\n        ;\n            if (b.nodeType) {\n                return q.grep(a, function(a, d) {\n                    return ((((a === b)) === c));\n                });\n            }\n        ;\n        ;\n            if (((typeof b == \"string\"))) {\n                var d = q.grep(a, function(a) {\n                    return ((a.nodeType === 1));\n                });\n                if (hb.test(b)) {\n                    return q.filter(b, d, !c);\n                }\n            ;\n            ;\n                b = q.filter(b, d);\n            }\n        ;\n        ;\n            return q.grep(a, function(a, d) {\n                return ((((q.inArray(a, b) >= 0)) === c));\n            });\n        };\n    ;\n        function nb(a) {\n            var b = ob.split(\"|\"), c = a.createDocumentFragment();\n            if (c.createElement) {\n                while (b.length) {\n                    c.createElement(b.pop());\n                ;\n                };\n            }\n        ;\n        ;\n            return c;\n        };\n    ;\n        function Fb(a, b) {\n            return ((a.getElementsByTagName(b)[0] || a.appendChild(a.ownerDocument.createElement(b))));\n        };\n    ;\n        function Gb(a, b) {\n            if (((((b.nodeType !== 1)) || !q.hasData(a)))) {\n                return;\n            }\n        ;\n        ;\n            var c, d, e, f = q._data(a), g = q._data(b, f), i = f.events;\n            if (i) {\n                delete g.handle;\n                g.events = {\n                };\n                {\n                    var fin2keys = ((window.top.JSBNG_Replay.forInKeys)((i))), fin2i = (0);\n                    (0);\n                    for (; (fin2i < fin2keys.length); (fin2i++)) {\n                        ((c) = (fin2keys[fin2i]));\n                        {\n                            for (d = 0, e = i[c].length; ((d < e)); d++) {\n                                q.JSBNG__event.add(b, c, i[c][d]);\n                            ;\n                            };\n                        ;\n                        };\n                    };\n                };\n            ;\n            }\n        ;\n        ;\n            ((g.data && (g.data = q.extend({\n            }, g.data))));\n        };\n    ;\n        function Hb(a, b) {\n            var c;\n            if (((b.nodeType !== 1))) {\n                return;\n            }\n        ;\n        ;\n            ((b.clearAttributes && b.clearAttributes()));\n            ((b.mergeAttributes && b.mergeAttributes(a)));\n            c = b.nodeName.toLowerCase();\n            if (((c === \"object\"))) {\n                ((b.parentNode && (b.outerHTML = a.outerHTML)));\n                ((((((q.support.html5Clone && a.innerHTML)) && !q.trim(b.innerHTML))) && (b.innerHTML = a.innerHTML)));\n            }\n             else if (((((c === \"input\")) && yb.test(a.type)))) {\n                b.defaultChecked = b.checked = a.checked;\n                ((((b.value !== a.value)) && (b.value = a.value)));\n            }\n             else ((((c === \"option\")) ? b.selected = a.defaultSelected : ((((((c === \"input\")) || ((c === \"textarea\")))) ? b.defaultValue = a.defaultValue : ((((((c === \"script\")) && ((b.text !== a.text)))) && (b.text = a.text)))))));\n            \n        ;\n        ;\n            b.removeAttribute(q.expando);\n        };\n    ;\n        function Ib(a) {\n            return ((((typeof a.getElementsByTagName != \"undefined\")) ? a.getElementsByTagName(\"*\") : ((((typeof a.querySelectorAll != \"undefined\")) ? a.querySelectorAll(\"*\") : []))));\n        };\n    ;\n        function Jb(a) {\n            ((yb.test(a.type) && (a.defaultChecked = a.checked)));\n        };\n    ;\n        function _b(a, b) {\n            if (((b in a))) {\n                return b;\n            }\n        ;\n        ;\n            var c = ((b.charAt(0).toUpperCase() + b.slice(1))), d = b, e = Zb.length;\n            while (e--) {\n                b = ((Zb[e] + c));\n                if (((b in a))) {\n                    return b;\n                }\n            ;\n            ;\n            };\n        ;\n            return d;\n        };\n    ;\n        function ac(a, b) {\n            a = ((b || a));\n            return ((((q.css(a, \"display\") === \"none\")) || !q.contains(a.ownerDocument, a)));\n        };\n    ;\n        function bc(a, b) {\n            var c, d, e = [], f = 0, g = a.length;\n            for (; ((f < g)); f++) {\n                c = a[f];\n                if (!c.style) {\n                    continue;\n                }\n            ;\n            ;\n                e[f] = q._data(c, \"olddisplay\");\n                if (b) {\n                    ((((!e[f] && ((c.style.display === \"none\")))) && (c.style.display = \"\")));\n                    ((((((c.style.display === \"\")) && ac(c))) && (e[f] = q._data(c, \"olddisplay\", fc(c.nodeName)))));\n                }\n                 else {\n                    d = Kb(c, \"display\");\n                    ((((!e[f] && ((d !== \"none\")))) && q._data(c, \"olddisplay\", d)));\n                }\n            ;\n            ;\n            };\n        ;\n            for (f = 0; ((f < g)); f++) {\n                c = a[f];\n                if (!c.style) {\n                    continue;\n                }\n            ;\n            ;\n                if (((((!b || ((c.style.display === \"none\")))) || ((c.style.display === \"\"))))) {\n                    c.style.display = ((b ? ((e[f] || \"\")) : \"none\"));\n                }\n            ;\n            ;\n            };\n        ;\n            return a;\n        };\n    ;\n        function cc(a, b, c) {\n            var d = Sb.exec(b);\n            return ((d ? ((Math.max(0, ((d[1] - ((c || 0))))) + ((d[2] || \"px\")))) : b));\n        };\n    ;\n        function dc(a, b, c, d) {\n            var e = ((((c === ((d ? \"border\" : \"JSBNG__content\")))) ? 4 : ((((b === \"width\")) ? 1 : 0)))), f = 0;\n            for (; ((e < 4)); e += 2) {\n                ((((c === \"margin\")) && (f += q.css(a, ((c + Yb[e])), !0))));\n                if (d) {\n                    ((((c === \"JSBNG__content\")) && (f -= ((parseFloat(Kb(a, ((\"padding\" + Yb[e])))) || 0)))));\n                    ((((c !== \"margin\")) && (f -= ((parseFloat(Kb(a, ((((\"border\" + Yb[e])) + \"Width\")))) || 0)))));\n                }\n                 else {\n                    f += ((parseFloat(Kb(a, ((\"padding\" + Yb[e])))) || 0));\n                    ((((c !== \"padding\")) && (f += ((parseFloat(Kb(a, ((((\"border\" + Yb[e])) + \"Width\")))) || 0)))));\n                }\n            ;\n            ;\n            };\n        ;\n            return f;\n        };\n    ;\n        function ec(a, b, c) {\n            var d = ((((b === \"width\")) ? a.offsetWidth : a.offsetHeight)), e = !0, f = ((q.support.boxSizing && ((q.css(a, \"boxSizing\") === \"border-box\"))));\n            if (((((d <= 0)) || ((d == null))))) {\n                d = Kb(a, b);\n                if (((((d < 0)) || ((d == null))))) {\n                    d = a.style[b];\n                }\n            ;\n            ;\n                if (Tb.test(d)) {\n                    return d;\n                }\n            ;\n            ;\n                e = ((f && ((q.support.boxSizingReliable || ((d === a.style[b]))))));\n                d = ((parseFloat(d) || 0));\n            }\n        ;\n        ;\n            return ((((d + dc(a, b, ((c || ((f ? \"border\" : \"JSBNG__content\")))), e))) + \"px\"));\n        };\n    ;\n        function fc(a) {\n            if (Vb[a]) {\n                return Vb[a];\n            }\n        ;\n        ;\n            var b = q(((((\"\\u003C\" + a)) + \"\\u003E\"))).appendTo(e.body), c = b.css(\"display\");\n            b.remove();\n            if (((((c === \"none\")) || ((c === \"\"))))) {\n                Lb = e.body.appendChild(((Lb || q.extend(e.createElement(\"div\"), {\n                    frameBorder: 0,\n                    width: 0,\n                    height: 0\n                }))));\n                if (((!Mb || !Lb.createElement))) {\n                    Mb = ((Lb.contentWindow || Lb.contentDocument)).JSBNG__document;\n                    Mb.write(\"\\u003C!doctype html\\u003E\\u003Chtml\\u003E\\u003Cbody\\u003E\");\n                    Mb.close();\n                }\n            ;\n            ;\n                b = Mb.body.appendChild(Mb.createElement(a));\n                c = Kb(b, \"display\");\n                e.body.removeChild(Lb);\n            }\n        ;\n        ;\n            Vb[a] = c;\n            return c;\n        };\n    ;\n        function lc(a, b, c, d) {\n            var e;\n            if (q.isArray(b)) {\n                q.each(b, function(b, e) {\n                    ((((c || hc.test(a))) ? d(a, e) : lc(((((((a + \"[\")) + ((((typeof e == \"object\")) ? b : \"\")))) + \"]\")), e, c, d)));\n                });\n            }\n             else {\n                if (((!c && ((q.type(b) === \"object\"))))) {\n                    {\n                        var fin3keys = ((window.top.JSBNG_Replay.forInKeys)((b))), fin3i = (0);\n                        (0);\n                        for (; (fin3i < fin3keys.length); (fin3i++)) {\n                            ((e) = (fin3keys[fin3i]));\n                            {\n                                lc(((((((a + \"[\")) + e)) + \"]\")), b[e], c, d);\n                            ;\n                            };\n                        };\n                    };\n                }\n                 else {\n                    d(a, b);\n                }\n            ;\n            }\n        ;\n        ;\n        };\n    ;\n        function Cc(a) {\n            return function(b, c) {\n                if (((typeof b != \"string\"))) {\n                    c = b;\n                    b = \"*\";\n                }\n            ;\n            ;\n                var d, e, f, g = b.toLowerCase().split(t), i = 0, j = g.length;\n                if (q.isFunction(c)) {\n                    for (; ((i < j)); i++) {\n                        d = g[i];\n                        f = /^\\+/.test(d);\n                        ((f && (d = ((d.substr(1) || \"*\")))));\n                        e = a[d] = ((a[d] || []));\n                        e[((f ? \"unshift\" : \"push\"))](c);\n                    };\n                }\n            ;\n            ;\n            };\n        };\n    ;\n        function Dc(a, c, d, e, f, g) {\n            f = ((f || c.dataTypes[0]));\n            g = ((g || {\n            }));\n            g[f] = !0;\n            var i, j = a[f], k = 0, l = ((j ? j.length : 0)), m = ((a === yc));\n            for (; ((((k < l)) && ((m || !i)))); k++) {\n                i = j[k](c, d, e);\n                if (((typeof i == \"string\"))) {\n                    if (((!m || g[i]))) i = b;\n                     else {\n                        c.dataTypes.unshift(i);\n                        i = Dc(a, c, d, e, i, g);\n                    }\n                ;\n                }\n            ;\n            ;\n            };\n        ;\n            ((((((m || !i)) && !g[\"*\"])) && (i = Dc(a, c, d, e, \"*\", g))));\n            return i;\n        };\n    ;\n        function Ec(a, c) {\n            var d, e, f = ((q.ajaxSettings.flatOptions || {\n            }));\n            {\n                var fin4keys = ((window.top.JSBNG_Replay.forInKeys)((c))), fin4i = (0);\n                (0);\n                for (; (fin4i < fin4keys.length); (fin4i++)) {\n                    ((d) = (fin4keys[fin4i]));\n                    {\n                        ((((c[d] !== b)) && (((f[d] ? a : ((e || (e = {\n                        })))))[d] = c[d])));\n                    ;\n                    };\n                };\n            };\n        ;\n            ((e && q.extend(!0, a, e)));\n        };\n    ;\n        function Fc(a, c, d) {\n            var e, f, g, i, j = a.contents, k = a.dataTypes, l = a.responseFields;\n            {\n                var fin5keys = ((window.top.JSBNG_Replay.forInKeys)((l))), fin5i = (0);\n                (0);\n                for (; (fin5i < fin5keys.length); (fin5i++)) {\n                    ((f) = (fin5keys[fin5i]));\n                    {\n                        ((((f in d)) && (c[l[f]] = d[f])));\n                    ;\n                    };\n                };\n            };\n        ;\n            while (((k[0] === \"*\"))) {\n                k.shift();\n                ((((e === b)) && (e = ((a.mimeType || c.getResponseHeader(\"content-type\"))))));\n            };\n        ;\n            if (e) {\n                {\n                    var fin6keys = ((window.top.JSBNG_Replay.forInKeys)((j))), fin6i = (0);\n                    (0);\n                    for (; (fin6i < fin6keys.length); (fin6i++)) {\n                        ((f) = (fin6keys[fin6i]));\n                        {\n                            if (((j[f] && j[f].test(e)))) {\n                                k.unshift(f);\n                                break;\n                            }\n                        ;\n                        ;\n                        };\n                    };\n                };\n            }\n        ;\n        ;\n            if (((k[0] in d))) g = k[0];\n             else {\n                {\n                    var fin7keys = ((window.top.JSBNG_Replay.forInKeys)((d))), fin7i = (0);\n                    (0);\n                    for (; (fin7i < fin7keys.length); (fin7i++)) {\n                        ((f) = (fin7keys[fin7i]));\n                        {\n                            if (((!k[0] || a.converters[((((f + \" \")) + k[0]))]))) {\n                                g = f;\n                                break;\n                            }\n                        ;\n                        ;\n                            ((i || (i = f)));\n                        };\n                    };\n                };\n            ;\n                g = ((g || i));\n            }\n        ;\n        ;\n            if (g) {\n                ((((g !== k[0])) && k.unshift(g)));\n                return d[g];\n            }\n        ;\n        ;\n        };\n    ;\n        function Gc(a, b) {\n            var c, d, e, f, g = a.dataTypes.slice(), i = g[0], j = {\n            }, k = 0;\n            ((a.dataFilter && (b = a.dataFilter(b, a.dataType))));\n            if (g[1]) {\n                {\n                    var fin8keys = ((window.top.JSBNG_Replay.forInKeys)((a.converters))), fin8i = (0);\n                    (0);\n                    for (; (fin8i < fin8keys.length); (fin8i++)) {\n                        ((c) = (fin8keys[fin8i]));\n                        {\n                            j[c.toLowerCase()] = a.converters[c];\n                        ;\n                        };\n                    };\n                };\n            }\n        ;\n        ;\n            for (; e = g[++k]; ) {\n                if (((e !== \"*\"))) {\n                    if (((((i !== \"*\")) && ((i !== e))))) {\n                        c = ((j[((((i + \" \")) + e))] || j[((\"* \" + e))]));\n                        if (!c) {\n                            {\n                                var fin9keys = ((window.top.JSBNG_Replay.forInKeys)((j))), fin9i = (0);\n                                (0);\n                                for (; (fin9i < fin9keys.length); (fin9i++)) {\n                                    ((d) = (fin9keys[fin9i]));\n                                    {\n                                        f = d.split(\" \");\n                                        if (((f[1] === e))) {\n                                            c = ((j[((((i + \" \")) + f[0]))] || j[((\"* \" + f[0]))]));\n                                            if (c) {\n                                                if (((c === !0))) {\n                                                    c = j[d];\n                                                }\n                                                 else {\n                                                    if (((j[d] !== !0))) {\n                                                        e = f[0];\n                                                        g.splice(k--, 0, e);\n                                                    }\n                                                ;\n                                                }\n                                            ;\n                                            ;\n                                                break;\n                                            }\n                                        ;\n                                        ;\n                                        }\n                                    ;\n                                    ;\n                                    };\n                                };\n                            };\n                        }\n                    ;\n                    ;\n                        if (((c !== !0))) {\n                            if (((c && a[\"throws\"]))) {\n                                b = c(b);\n                            }\n                             else {\n                                try {\n                                    b = c(b);\n                                } catch (l) {\n                                    return {\n                                        state: \"parsererror\",\n                                        error: ((c ? l : ((((((\"No conversion from \" + i)) + \" to \")) + e))))\n                                    };\n                                };\n                            }\n                        ;\n                        }\n                    ;\n                    ;\n                    }\n                ;\n                ;\n                    i = e;\n                }\n            ;\n            ;\n            };\n        ;\n            return {\n                state: \"success\",\n                data: b\n            };\n        };\n    ;\n        function Oc() {\n            try {\n                return new a.JSBNG__XMLHttpRequest;\n            } catch (b) {\n            \n            };\n        ;\n        };\n    ;\n        function Pc() {\n            try {\n                return new a.ActiveXObject(\"Microsoft.XMLHTTP\");\n            } catch (b) {\n            \n            };\n        ;\n        };\n    ;\n        function Xc() {\n            JSBNG__setTimeout(function() {\n                Qc = b;\n            }, 0);\n            return Qc = q.now();\n        };\n    ;\n        function Yc(a, b) {\n            q.each(b, function(b, c) {\n                var d = ((Wc[b] || [])).concat(Wc[\"*\"]), e = 0, f = d.length;\n                for (; ((e < f)); e++) {\n                    if (d[e].call(a, b, c)) {\n                        return;\n                    }\n                ;\n                ;\n                };\n            ;\n            });\n        };\n    ;\n        function Zc(a, b, c) {\n            var d, e = 0, f = 0, g = Vc.length, i = q.Deferred().always(function() {\n                delete j.elem;\n            }), j = function() {\n                var b = ((Qc || Xc())), c = Math.max(0, ((((k.startTime + k.duration)) - b))), d = ((((c / k.duration)) || 0)), e = ((1 - d)), f = 0, g = k.tweens.length;\n                for (; ((f < g)); f++) {\n                    k.tweens[f].run(e);\n                ;\n                };\n            ;\n                i.notifyWith(a, [k,e,c,]);\n                if (((((e < 1)) && g))) {\n                    return c;\n                }\n            ;\n            ;\n                i.resolveWith(a, [k,]);\n                return !1;\n            }, k = i.promise({\n                elem: a,\n                props: q.extend({\n                }, b),\n                opts: q.extend(!0, {\n                    specialEasing: {\n                    }\n                }, c),\n                originalProperties: b,\n                originalOptions: c,\n                startTime: ((Qc || Xc())),\n                duration: c.duration,\n                tweens: [],\n                createTween: function(b, c, d) {\n                    var e = q.Tween(a, k.opts, b, c, ((k.opts.specialEasing[b] || k.opts.easing)));\n                    k.tweens.push(e);\n                    return e;\n                },\n                JSBNG__stop: function(b) {\n                    var c = 0, d = ((b ? k.tweens.length : 0));\n                    for (; ((c < d)); c++) {\n                        k.tweens[c].run(1);\n                    ;\n                    };\n                ;\n                    ((b ? i.resolveWith(a, [k,b,]) : i.rejectWith(a, [k,b,])));\n                    return this;\n                }\n            }), l = k.props;\n            $c(l, k.opts.specialEasing);\n            for (; ((e < g)); e++) {\n                d = Vc[e].call(k, a, l, k.opts);\n                if (d) {\n                    return d;\n                }\n            ;\n            ;\n            };\n        ;\n            Yc(k, l);\n            ((q.isFunction(k.opts.start) && k.opts.start.call(a, k)));\n            q.fx.timer(q.extend(j, {\n                anim: k,\n                queue: k.opts.queue,\n                elem: a\n            }));\n            return k.progress(k.opts.progress).done(k.opts.done, k.opts.complete).fail(k.opts.fail).always(k.opts.always);\n        };\n    ;\n        function $c(a, b) {\n            var c, d, e, f, g;\n            {\n                var fin10keys = ((window.top.JSBNG_Replay.forInKeys)((a))), fin10i = (0);\n                (0);\n                for (; (fin10i < fin10keys.length); (fin10i++)) {\n                    ((c) = (fin10keys[fin10i]));\n                    {\n                        d = q.camelCase(c);\n                        e = b[d];\n                        f = a[c];\n                        if (q.isArray(f)) {\n                            e = f[1];\n                            f = a[c] = f[0];\n                        }\n                    ;\n                    ;\n                        if (((c !== d))) {\n                            a[d] = f;\n                            delete a[c];\n                        }\n                    ;\n                    ;\n                        g = q.cssHooks[d];\n                        if (((g && ((\"expand\" in g))))) {\n                            f = g.expand(f);\n                            delete a[d];\n                            {\n                                var fin11keys = ((window.top.JSBNG_Replay.forInKeys)((f))), fin11i = (0);\n                                (0);\n                                for (; (fin11i < fin11keys.length); (fin11i++)) {\n                                    ((c) = (fin11keys[fin11i]));\n                                    {\n                                        if (!((c in a))) {\n                                            a[c] = f[c];\n                                            b[c] = e;\n                                        }\n                                    ;\n                                    ;\n                                    };\n                                };\n                            };\n                        ;\n                        }\n                         else b[d] = e;\n                    ;\n                    ;\n                    };\n                };\n            };\n        ;\n        };\n    ;\n        function _c(a, b, c) {\n            var d, e, f, g, i, j, k, l, m, n = this, o = a.style, p = {\n            }, r = [], s = ((a.nodeType && ac(a)));\n            if (!c.queue) {\n                l = q._queueHooks(a, \"fx\");\n                if (((l.unqueued == null))) {\n                    l.unqueued = 0;\n                    m = l.empty.fire;\n                    l.empty.fire = function() {\n                        ((l.unqueued || m()));\n                    };\n                }\n            ;\n            ;\n                l.unqueued++;\n                n.always(function() {\n                    n.always(function() {\n                        l.unqueued--;\n                        ((q.queue(a, \"fx\").length || l.empty.fire()));\n                    });\n                });\n            }\n        ;\n        ;\n            if (((((a.nodeType === 1)) && ((((\"height\" in b)) || ((\"width\" in b))))))) {\n                c.overflow = [o.overflow,o.overflowX,o.overflowY,];\n                ((((((q.css(a, \"display\") === \"inline\")) && ((q.css(a, \"float\") === \"none\")))) && ((((!q.support.inlineBlockNeedsLayout || ((fc(a.nodeName) === \"inline\")))) ? o.display = \"inline-block\" : o.zoom = 1))));\n            }\n        ;\n        ;\n            if (c.overflow) {\n                o.overflow = \"hidden\";\n                ((q.support.shrinkWrapBlocks || n.done(function() {\n                    o.overflow = c.overflow[0];\n                    o.overflowX = c.overflow[1];\n                    o.overflowY = c.overflow[2];\n                })));\n            }\n        ;\n        ;\n            {\n                var fin12keys = ((window.top.JSBNG_Replay.forInKeys)((b))), fin12i = (0);\n                (0);\n                for (; (fin12i < fin12keys.length); (fin12i++)) {\n                    ((d) = (fin12keys[fin12i]));\n                    {\n                        f = b[d];\n                        if (Sc.exec(f)) {\n                            delete b[d];\n                            j = ((j || ((f === \"toggle\"))));\n                            if (((f === ((s ? \"hide\" : \"show\"))))) {\n                                continue;\n                            }\n                        ;\n                        ;\n                            r.push(d);\n                        }\n                    ;\n                    ;\n                    };\n                };\n            };\n        ;\n            g = r.length;\n            if (g) {\n                i = ((q._data(a, \"fxshow\") || q._data(a, \"fxshow\", {\n                })));\n                ((((\"hidden\" in i)) && (s = i.hidden)));\n                ((j && (i.hidden = !s)));\n                ((s ? q(a).show() : n.done(function() {\n                    q(a).hide();\n                })));\n                n.done(function() {\n                    var b;\n                    q.removeData(a, \"fxshow\", !0);\n                    {\n                        var fin13keys = ((window.top.JSBNG_Replay.forInKeys)((p))), fin13i = (0);\n                        (0);\n                        for (; (fin13i < fin13keys.length); (fin13i++)) {\n                            ((b) = (fin13keys[fin13i]));\n                            {\n                                q.style(a, b, p[b]);\n                            ;\n                            };\n                        };\n                    };\n                ;\n                });\n                for (d = 0; ((d < g)); d++) {\n                    e = r[d];\n                    k = n.createTween(e, ((s ? i[e] : 0)));\n                    p[e] = ((i[e] || q.style(a, e)));\n                    if (!((e in i))) {\n                        i[e] = k.start;\n                        if (s) {\n                            k.end = k.start;\n                            k.start = ((((((e === \"width\")) || ((e === \"height\")))) ? 1 : 0));\n                        }\n                    ;\n                    ;\n                    }\n                ;\n                ;\n                };\n            ;\n            }\n        ;\n        ;\n        };\n    ;\n        function ad(a, b, c, d, e) {\n            return new ad.prototype.init(a, b, c, d, e);\n        };\n    ;\n        function bd(a, b) {\n            var c, d = {\n                height: a\n            }, e = 0;\n            b = ((b ? 1 : 0));\n            for (; ((e < 4)); e += ((2 - b))) {\n                c = Yb[e];\n                d[((\"margin\" + c))] = d[((\"padding\" + c))] = a;\n            };\n        ;\n            ((b && (d.opacity = d.width = a)));\n            return d;\n        };\n    ;\n        function dd(a) {\n            return ((q.isWindow(a) ? a : ((((a.nodeType === 9)) ? ((a.defaultView || a.parentWindow)) : !1))));\n        };\n    ;\n        var c, d, e = a.JSBNG__document, f = a.JSBNG__location, g = a.JSBNG__navigator, i = a.jQuery, j = a.$, k = Array.prototype.push, l = Array.prototype.slice, m = Array.prototype.indexOf, n = Object.prototype.toString, o = Object.prototype.hasOwnProperty, p = String.prototype.trim, q = function(a, b) {\n            return new q.fn.init(a, b, c);\n        }, r = /[\\-+]?(?:\\d*\\.|)\\d+(?:[eE][\\-+]?\\d+|)/.source, s = /\\S/, t = /\\s+/, u = /^[\\s\\uFEFF\\xA0]+|[\\s\\uFEFF\\xA0]+$/g, v = /^(?:[^#<]*(<[\\w\\W]+>)[^>]*$|#([\\w\\-]*)$)/, w = /^<(\\w+)\\s*\\/?>(?:<\\/\\1>|)$/, x = /^[\\],:{}\\s]*$/, y = /(?:^|:|,)(?:\\s*\\[)+/g, z = /\\\\(?:[\"\\\\\\/bfnrt]|u[\\da-fA-F]{4})/g, A = /\"[^\"\\\\\\r\\n]*\"|true|false|null|-?(?:\\d\\d*\\.|)\\d+(?:[eE][\\-+]?\\d+|)/g, B = /^-ms-/, C = /-([\\da-z])/gi, D = function(a, b) {\n            return ((b + \"\")).toUpperCase();\n        }, E = function() {\n            if (e.JSBNG__addEventListener) {\n                e.JSBNG__removeEventListener(\"DOMContentLoaded\", E, !1);\n                q.ready();\n            }\n             else if (((e.readyState === \"complete\"))) {\n                e.JSBNG__detachEvent(\"onreadystatechange\", E);\n                q.ready();\n            }\n            \n        ;\n        ;\n        }, F = {\n        };\n        q.fn = q.prototype = {\n            constructor: q,\n            init: function(a, c, d) {\n                var f, g, i, j;\n                if (!a) {\n                    return this;\n                }\n            ;\n            ;\n                if (a.nodeType) {\n                    this.context = this[0] = a;\n                    this.length = 1;\n                    return this;\n                }\n            ;\n            ;\n                if (((typeof a == \"string\"))) {\n                    ((((((((a.charAt(0) === \"\\u003C\")) && ((a.charAt(((a.length - 1))) === \"\\u003E\")))) && ((a.length >= 3)))) ? f = [null,a,null,] : f = v.exec(a)));\n                    if (((f && ((f[1] || !c))))) {\n                        if (f[1]) {\n                            c = ((((c instanceof q)) ? c[0] : c));\n                            j = ((((c && c.nodeType)) ? ((c.ownerDocument || c)) : e));\n                            a = q.parseHTML(f[1], j, !0);\n                            ((((w.test(f[1]) && q.isPlainObject(c))) && this.attr.call(a, c, !0)));\n                            return q.merge(this, a);\n                        }\n                    ;\n                    ;\n                        g = e.getElementById(f[2]);\n                        if (((g && g.parentNode))) {\n                            if (((g.id !== f[2]))) {\n                                return d.JSBNG__find(a);\n                            }\n                        ;\n                        ;\n                            this.length = 1;\n                            this[0] = g;\n                        }\n                    ;\n                    ;\n                        this.context = e;\n                        this.selector = a;\n                        return this;\n                    }\n                ;\n                ;\n                    return ((((!c || c.jquery)) ? ((c || d)).JSBNG__find(a) : this.constructor(c).JSBNG__find(a)));\n                }\n            ;\n            ;\n                if (q.isFunction(a)) {\n                    return d.ready(a);\n                }\n            ;\n            ;\n                if (((a.selector !== b))) {\n                    this.selector = a.selector;\n                    this.context = a.context;\n                }\n            ;\n            ;\n                return q.makeArray(a, this);\n            },\n            selector: \"\",\n            jquery: \"1.8.3\",\n            length: 0,\n            size: function() {\n                return this.length;\n            },\n            toArray: function() {\n                return l.call(this);\n            },\n            get: function(a) {\n                return ((((a == null)) ? this.toArray() : ((((a < 0)) ? this[((this.length + a))] : this[a]))));\n            },\n            pushStack: function(a, b, c) {\n                var d = q.merge(this.constructor(), a);\n                d.prevObject = this;\n                d.context = this.context;\n                ((((b === \"JSBNG__find\")) ? d.selector = ((((this.selector + ((this.selector ? \" \" : \"\")))) + c)) : ((b && (d.selector = ((((((((((this.selector + \".\")) + b)) + \"(\")) + c)) + \")\")))))));\n                return d;\n            },\n            each: function(a, b) {\n                return q.each(this, a, b);\n            },\n            ready: function(a) {\n                q.ready.promise().done(a);\n                return this;\n            },\n            eq: function(a) {\n                a = +a;\n                return ((((a === -1)) ? this.slice(a) : this.slice(a, ((a + 1)))));\n            },\n            first: function() {\n                return this.eq(0);\n            },\n            last: function() {\n                return this.eq(-1);\n            },\n            slice: function() {\n                return this.pushStack(l.apply(this, arguments), \"slice\", l.call(arguments).join(\",\"));\n            },\n            map: function(a) {\n                return this.pushStack(q.map(this, function(b, c) {\n                    return a.call(b, c, b);\n                }));\n            },\n            end: function() {\n                return ((this.prevObject || this.constructor(null)));\n            },\n            push: k,\n            sort: [].sort,\n            splice: [].splice\n        };\n        q.fn.init.prototype = q.fn;\n        q.extend = q.fn.extend = function() {\n            var a, c, d, e, f, g, i = ((arguments[0] || {\n            })), j = 1, k = arguments.length, l = !1;\n            if (((typeof i == \"boolean\"))) {\n                l = i;\n                i = ((arguments[1] || {\n                }));\n                j = 2;\n            }\n        ;\n        ;\n            ((((((typeof i != \"object\")) && !q.isFunction(i))) && (i = {\n            })));\n            if (((k === j))) {\n                i = this;\n                --j;\n            }\n        ;\n        ;\n            for (; ((j < k)); j++) {\n                if ((((a = arguments[j]) != null))) {\n                    {\n                        var fin14keys = ((window.top.JSBNG_Replay.forInKeys)((a))), fin14i = (0);\n                        (0);\n                        for (; (fin14i < fin14keys.length); (fin14i++)) {\n                            ((c) = (fin14keys[fin14i]));\n                            {\n                                d = i[c];\n                                e = a[c];\n                                if (((i === e))) {\n                                    continue;\n                                }\n                            ;\n                            ;\n                                if (((((l && e)) && ((q.isPlainObject(e) || (f = q.isArray(e))))))) {\n                                    if (f) {\n                                        f = !1;\n                                        g = ((((d && q.isArray(d))) ? d : []));\n                                    }\n                                     else g = ((((d && q.isPlainObject(d))) ? d : {\n                                    }));\n                                ;\n                                ;\n                                    i[c] = q.extend(l, g, e);\n                                }\n                                 else ((((e !== b)) && (i[c] = e)));\n                            ;\n                            ;\n                            };\n                        };\n                    };\n                }\n            ;\n            ;\n            };\n        ;\n            return i;\n        };\n        q.extend({\n            noConflict: function(b) {\n                ((((a.$ === q)) && (a.$ = j)));\n                ((((b && ((a.jQuery === q)))) && (a.jQuery = i)));\n                return q;\n            },\n            isReady: !1,\n            readyWait: 1,\n            holdReady: function(a) {\n                ((a ? q.readyWait++ : q.ready(!0)));\n            },\n            ready: function(a) {\n                if (((((a === !0)) ? --q.readyWait : q.isReady))) {\n                    return;\n                }\n            ;\n            ;\n                if (!e.body) {\n                    return JSBNG__setTimeout(q.ready, 1);\n                }\n            ;\n            ;\n                q.isReady = !0;\n                if (((((a !== !0)) && ((--q.readyWait > 0))))) {\n                    return;\n                }\n            ;\n            ;\n                d.resolveWith(e, [q,]);\n                ((q.fn.trigger && q(e).trigger(\"ready\").off(\"ready\")));\n            },\n            isFunction: function(a) {\n                return ((q.type(a) === \"function\"));\n            },\n            isArray: ((Array.isArray || function(a) {\n                return ((q.type(a) === \"array\"));\n            })),\n            isWindow: function(a) {\n                return ((((a != null)) && ((a == a.window))));\n            },\n            isNumeric: function(a) {\n                return ((!isNaN(parseFloat(a)) && isFinite(a)));\n            },\n            type: function(a) {\n                return ((((a == null)) ? String(a) : ((F[n.call(a)] || \"object\"))));\n            },\n            isPlainObject: function(a) {\n                if (((((((!a || ((q.type(a) !== \"object\")))) || a.nodeType)) || q.isWindow(a)))) {\n                    return !1;\n                }\n            ;\n            ;\n                try {\n                    if (((((a.constructor && !o.call(a, \"constructor\"))) && !o.call(a.constructor.prototype, \"isPrototypeOf\")))) {\n                        return !1;\n                    }\n                ;\n                ;\n                } catch (c) {\n                    return !1;\n                };\n            ;\n                var d;\n                {\n                    var fin15keys = ((window.top.JSBNG_Replay.forInKeys)((a))), fin15i = (0);\n                    (0);\n                    for (; (fin15i < fin15keys.length); (fin15i++)) {\n                        ((d) = (fin15keys[fin15i]));\n                        {\n                        ;\n                        };\n                    };\n                };\n            ;\n                return ((((d === b)) || o.call(a, d)));\n            },\n            isEmptyObject: function(a) {\n                var b;\n                {\n                    var fin16keys = ((window.top.JSBNG_Replay.forInKeys)((a))), fin16i = (0);\n                    (0);\n                    for (; (fin16i < fin16keys.length); (fin16i++)) {\n                        ((b) = (fin16keys[fin16i]));\n                        {\n                            return !1;\n                        };\n                    };\n                };\n            ;\n                return !0;\n            },\n            error: function(a) {\n                throw new Error(a);\n            },\n            parseHTML: function(a, b, c) {\n                var d;\n                if (((!a || ((typeof a != \"string\"))))) {\n                    return null;\n                }\n            ;\n            ;\n                if (((typeof b == \"boolean\"))) {\n                    c = b;\n                    b = 0;\n                }\n            ;\n            ;\n                b = ((b || e));\n                if (d = w.exec(a)) {\n                    return [b.createElement(d[1]),];\n                }\n            ;\n            ;\n                d = q.buildFragment([a,], b, ((c ? null : [])));\n                return q.merge([], ((d.cacheable ? q.clone(d.fragment) : d.fragment)).childNodes);\n            },\n            parseJSON: function(b) {\n                if (((!b || ((typeof b != \"string\"))))) {\n                    return null;\n                }\n            ;\n            ;\n                b = q.trim(b);\n                if (((a.JSON && a.JSON.parse))) {\n                    return a.JSON.parse(b);\n                }\n            ;\n            ;\n                if (x.test(b.replace(z, \"@\").replace(A, \"]\").replace(y, \"\"))) {\n                    return (new Function(((\"return \" + b))))();\n                }\n            ;\n            ;\n                q.error(((\"Invalid JSON: \" + b)));\n            },\n            parseXML: function(c) {\n                var d, e;\n                if (((!c || ((typeof c != \"string\"))))) {\n                    return null;\n                }\n            ;\n            ;\n                try {\n                    if (a.JSBNG__DOMParser) {\n                        e = new JSBNG__DOMParser;\n                        d = e.parseFromString(c, \"text/xml\");\n                    }\n                     else {\n                        d = new ActiveXObject(\"Microsoft.XMLDOM\");\n                        d.async = \"false\";\n                        d.loadXML(c);\n                    }\n                ;\n                ;\n                } catch (f) {\n                    d = b;\n                };\n            ;\n                ((((((!d || !d.documentElement)) || d.getElementsByTagName(\"parsererror\").length)) && q.error(((\"Invalid XML: \" + c)))));\n                return d;\n            },\n            noop: function() {\n            \n            },\n            globalEval: function(b) {\n                ((((b && s.test(b))) && ((a.execScript || function(b) {\n                    a.eval.call(a, b);\n                }))(b)));\n            },\n            camelCase: function(a) {\n                return a.replace(B, \"ms-\").replace(C, D);\n            },\n            nodeName: function(a, b) {\n                return ((a.nodeName && ((a.nodeName.toLowerCase() === b.toLowerCase()))));\n            },\n            each: function(a, c, d) {\n                var e, f = 0, g = a.length, i = ((((g === b)) || q.isFunction(a)));\n                if (d) {\n                    if (i) {\n                        {\n                            var fin17keys = ((window.top.JSBNG_Replay.forInKeys)((a))), fin17i = (0);\n                            (0);\n                            for (; (fin17i < fin17keys.length); (fin17i++)) {\n                                ((e) = (fin17keys[fin17i]));\n                                {\n                                    if (((c.apply(a[e], d) === !1))) {\n                                        break;\n                                    }\n                                ;\n                                ;\n                                };\n                            };\n                        };\n                    ;\n                    }\n                     else for (; ((f < g)); ) {\n                        if (((c.apply(a[f++], d) === !1))) {\n                            break;\n                        }\n                    ;\n                    ;\n                    }\n                ;\n                ;\n                }\n                 else if (i) {\n                    {\n                        var fin18keys = ((window.top.JSBNG_Replay.forInKeys)((a))), fin18i = (0);\n                        (0);\n                        for (; (fin18i < fin18keys.length); (fin18i++)) {\n                            ((e) = (fin18keys[fin18i]));\n                            {\n                                if (((c.call(a[e], e, a[e]) === !1))) {\n                                    break;\n                                }\n                            ;\n                            ;\n                            };\n                        };\n                    };\n                ;\n                }\n                 else for (; ((f < g)); ) {\n                    if (((c.call(a[f], f, a[f++]) === !1))) {\n                        break;\n                    }\n                ;\n                ;\n                }\n                \n            ;\n            ;\n                return a;\n            },\n            trim: ((((p && !p.call(\"\\ufeff\\u00a0\"))) ? function(a) {\n                return ((((a == null)) ? \"\" : p.call(a)));\n            } : function(a) {\n                return ((((a == null)) ? \"\" : ((a + \"\")).replace(u, \"\")));\n            })),\n            makeArray: function(a, b) {\n                var c, d = ((b || []));\n                if (((a != null))) {\n                    c = q.type(a);\n                    ((((((((((((a.length == null)) || ((c === \"string\")))) || ((c === \"function\")))) || ((c === \"regexp\")))) || q.isWindow(a))) ? k.call(d, a) : q.merge(d, a)));\n                }\n            ;\n            ;\n                return d;\n            },\n            inArray: function(a, b, c) {\n                var d;\n                if (b) {\n                    if (m) {\n                        return m.call(b, a, c);\n                    }\n                ;\n                ;\n                    d = b.length;\n                    c = ((c ? ((((c < 0)) ? Math.max(0, ((d + c))) : c)) : 0));\n                    for (; ((c < d)); c++) {\n                        if (((((c in b)) && ((b[c] === a))))) {\n                            return c;\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                }\n            ;\n            ;\n                return -1;\n            },\n            merge: function(a, c) {\n                var d = c.length, e = a.length, f = 0;\n                if (((typeof d == \"number\"))) {\n                    for (; ((f < d)); f++) {\n                        a[e++] = c[f];\n                    ;\n                    };\n                }\n                 else {\n                    while (((c[f] !== b))) {\n                        a[e++] = c[f++];\n                    ;\n                    };\n                }\n            ;\n            ;\n                a.length = e;\n                return a;\n            },\n            grep: function(a, b, c) {\n                var d, e = [], f = 0, g = a.length;\n                c = !!c;\n                for (; ((f < g)); f++) {\n                    d = !!b(a[f], f);\n                    ((((c !== d)) && e.push(a[f])));\n                };\n            ;\n                return e;\n            },\n            map: function(a, c, d) {\n                var e, f, g = [], i = 0, j = a.length, k = ((((a instanceof q)) || ((((((j !== b)) && ((typeof j == \"number\")))) && ((((((((((j > 0)) && a[0])) && a[((j - 1))])) || ((j === 0)))) || q.isArray(a)))))));\n                if (k) {\n                    for (; ((i < j)); i++) {\n                        e = c(a[i], i, d);\n                        ((((e != null)) && (g[g.length] = e)));\n                    };\n                }\n                 else {\n                    {\n                        var fin19keys = ((window.top.JSBNG_Replay.forInKeys)((a))), fin19i = (0);\n                        (0);\n                        for (; (fin19i < fin19keys.length); (fin19i++)) {\n                            ((f) = (fin19keys[fin19i]));\n                            {\n                                e = c(a[f], f, d);\n                                ((((e != null)) && (g[g.length] = e)));\n                            };\n                        };\n                    };\n                }\n            ;\n            ;\n                return g.concat.apply([], g);\n            },\n            guid: 1,\n            proxy: function(a, c) {\n                var d, e, f;\n                if (((typeof c == \"string\"))) {\n                    d = a[c];\n                    c = a;\n                    a = d;\n                }\n            ;\n            ;\n                if (!q.isFunction(a)) {\n                    return b;\n                }\n            ;\n            ;\n                e = l.call(arguments, 2);\n                f = function() {\n                    return a.apply(c, e.concat(l.call(arguments)));\n                };\n                f.guid = a.guid = ((a.guid || q.guid++));\n                return f;\n            },\n            access: function(a, c, d, e, f, g, i) {\n                var j, k = ((d == null)), l = 0, m = a.length;\n                if (((d && ((typeof d == \"object\"))))) {\n                    {\n                        var fin20keys = ((window.top.JSBNG_Replay.forInKeys)((d))), fin20i = (0);\n                        (0);\n                        for (; (fin20i < fin20keys.length); (fin20i++)) {\n                            ((l) = (fin20keys[fin20i]));\n                            {\n                                q.access(a, c, l, d[l], 1, g, e);\n                            ;\n                            };\n                        };\n                    };\n                ;\n                    f = 1;\n                }\n                 else if (((e !== b))) {\n                    j = ((((i === b)) && q.isFunction(e)));\n                    if (k) {\n                        if (j) {\n                            j = c;\n                            c = function(a, b, c) {\n                                return j.call(q(a), c);\n                            };\n                        }\n                         else {\n                            c.call(a, e);\n                            c = null;\n                        }\n                    ;\n                    }\n                ;\n                ;\n                    if (c) {\n                        for (; ((l < m)); l++) {\n                            c(a[l], d, ((j ? e.call(a[l], l, c(a[l], d)) : e)), i);\n                        ;\n                        };\n                    }\n                ;\n                ;\n                    f = 1;\n                }\n                \n            ;\n            ;\n                return ((f ? a : ((k ? c.call(a) : ((m ? c(a[0], d) : g))))));\n            },\n            now: function() {\n                return (new JSBNG__Date).getTime();\n            }\n        });\n        q.ready.promise = function(b) {\n            if (!d) {\n                d = q.Deferred();\n                if (((e.readyState === \"complete\"))) {\n                    JSBNG__setTimeout(q.ready, 1);\n                }\n                 else {\n                    if (e.JSBNG__addEventListener) {\n                        e.JSBNG__addEventListener(\"DOMContentLoaded\", E, !1);\n                        a.JSBNG__addEventListener(\"load\", q.ready, !1);\n                    }\n                     else {\n                        e.JSBNG__attachEvent(\"onreadystatechange\", E);\n                        a.JSBNG__attachEvent(\"JSBNG__onload\", q.ready);\n                        var c = !1;\n                        try {\n                            c = ((((a.JSBNG__frameElement == null)) && e.documentElement));\n                        } catch (f) {\n                        \n                        };\n                    ;\n                        ((((c && c.doScroll)) && function g() {\n                            if (!q.isReady) {\n                                try {\n                                    c.doScroll(\"left\");\n                                } catch (a) {\n                                    return JSBNG__setTimeout(g, 50);\n                                };\n                            ;\n                                q.ready();\n                            }\n                        ;\n                        ;\n                        }()));\n                    }\n                ;\n                }\n            ;\n            ;\n            }\n        ;\n        ;\n            return d.promise(b);\n        };\n        q.each(\"Boolean Number String Function Array Date RegExp Object\".split(\" \"), function(a, b) {\n            F[((((\"[object \" + b)) + \"]\"))] = b.toLowerCase();\n        });\n        c = q(e);\n        var G = {\n        };\n        q.Callbacks = function(a) {\n            a = ((((typeof a == \"string\")) ? ((G[a] || H(a))) : q.extend({\n            }, a)));\n            var c, d, e, f, g, i, j = [], k = ((!a.once && [])), l = function(b) {\n                c = ((a.memory && b));\n                d = !0;\n                i = ((f || 0));\n                f = 0;\n                g = j.length;\n                e = !0;\n                for (; ((j && ((i < g)))); i++) {\n                    if (((((j[i].apply(b[0], b[1]) === !1)) && a.stopOnFalse))) {\n                        c = !1;\n                        break;\n                    }\n                ;\n                ;\n                };\n            ;\n                e = !1;\n                ((j && ((k ? ((k.length && l(k.shift()))) : ((c ? j = [] : m.disable()))))));\n            }, m = {\n                add: function() {\n                    if (j) {\n                        var b = j.length;\n                        (function d(b) {\n                            q.each(b, function(_, b) {\n                                var c = q.type(b);\n                                ((((c === \"function\")) ? ((((!a.unique || !m.has(b))) && j.push(b))) : ((((((b && b.length)) && ((c !== \"string\")))) && d(b)))));\n                            });\n                        })(arguments);\n                        if (e) {\n                            g = j.length;\n                        }\n                         else {\n                            if (c) {\n                                f = b;\n                                l(c);\n                            }\n                        ;\n                        }\n                    ;\n                    ;\n                    }\n                ;\n                ;\n                    return this;\n                },\n                remove: function() {\n                    ((j && q.each(arguments, function(_, a) {\n                        var b;\n                        while ((((b = q.inArray(a, j, b)) > -1))) {\n                            j.splice(b, 1);\n                            if (e) {\n                                ((((b <= g)) && g--));\n                                ((((b <= i)) && i--));\n                            }\n                        ;\n                        ;\n                        };\n                    ;\n                    })));\n                    return this;\n                },\n                has: function(a) {\n                    return ((q.inArray(a, j) > -1));\n                },\n                empty: function() {\n                    j = [];\n                    return this;\n                },\n                disable: function() {\n                    j = k = c = b;\n                    return this;\n                },\n                disabled: function() {\n                    return !j;\n                },\n                lock: function() {\n                    k = b;\n                    ((c || m.disable()));\n                    return this;\n                },\n                locked: function() {\n                    return !k;\n                },\n                fireWith: function(a, b) {\n                    b = ((b || []));\n                    b = [a,((b.slice ? b.slice() : b)),];\n                    ((((j && ((!d || k)))) && ((e ? k.push(b) : l(b)))));\n                    return this;\n                },\n                fire: function() {\n                    m.fireWith(this, arguments);\n                    return this;\n                },\n                fired: function() {\n                    return !!d;\n                }\n            };\n            return m;\n        };\n        q.extend({\n            Deferred: function(a) {\n                var b = [[\"resolve\",\"done\",q.Callbacks(\"once memory\"),\"resolved\",],[\"reject\",\"fail\",q.Callbacks(\"once memory\"),\"rejected\",],[\"notify\",\"progress\",q.Callbacks(\"memory\"),],], c = \"pending\", d = {\n                    state: function() {\n                        return c;\n                    },\n                    always: function() {\n                        e.done(arguments).fail(arguments);\n                        return this;\n                    },\n                    then: function() {\n                        var a = arguments;\n                        return q.Deferred(function(c) {\n                            q.each(b, function(b, d) {\n                                var f = d[0], g = a[b];\n                                e[d[1]](((q.isFunction(g) ? function() {\n                                    var a = g.apply(this, arguments);\n                                    ((((a && q.isFunction(a.promise))) ? a.promise().done(c.resolve).fail(c.reject).progress(c.notify) : c[((f + \"With\"))](((((this === e)) ? c : this)), [a,])));\n                                } : c[f])));\n                            });\n                            a = null;\n                        }).promise();\n                    },\n                    promise: function(a) {\n                        return ((((a != null)) ? q.extend(a, d) : d));\n                    }\n                }, e = {\n                };\n                d.pipe = d.then;\n                q.each(b, function(a, f) {\n                    var g = f[2], i = f[3];\n                    d[f[1]] = g.add;\n                    ((i && g.add(function() {\n                        c = i;\n                    }, b[((a ^ 1))][2].disable, b[2][2].lock)));\n                    e[f[0]] = g.fire;\n                    e[((f[0] + \"With\"))] = g.fireWith;\n                });\n                d.promise(e);\n                ((a && a.call(e, e)));\n                return e;\n            },\n            when: function(a) {\n                var b = 0, c = l.call(arguments), d = c.length, e = ((((((d !== 1)) || ((a && q.isFunction(a.promise))))) ? d : 0)), f = ((((e === 1)) ? a : q.Deferred())), g = function(a, b, c) {\n                    return function(d) {\n                        b[a] = this;\n                        c[a] = ((((arguments.length > 1)) ? l.call(arguments) : d));\n                        ((((c === i)) ? f.notifyWith(b, c) : ((--e || f.resolveWith(b, c)))));\n                    };\n                }, i, j, k;\n                if (((d > 1))) {\n                    i = new Array(d);\n                    j = new Array(d);\n                    k = new Array(d);\n                    for (; ((b < d)); b++) {\n                        ((((c[b] && q.isFunction(c[b].promise))) ? c[b].promise().done(g(b, k, c)).fail(f.reject).progress(g(b, j, i)) : --e));\n                    ;\n                    };\n                ;\n                }\n            ;\n            ;\n                ((e || f.resolveWith(k, c)));\n                return f.promise();\n            }\n        });\n        q.support = function() {\n            var b, c, d, f, g, i, j, k, l, m, n, o = e.createElement(\"div\");\n            o.setAttribute(\"className\", \"t\");\n            o.innerHTML = \"  \\u003Clink/\\u003E\\u003Ctable\\u003E\\u003C/table\\u003E\\u003Ca href='/a'\\u003Ea\\u003C/a\\u003E\\u003Cinput type='checkbox'/\\u003E\";\n            c = o.getElementsByTagName(\"*\");\n            d = o.getElementsByTagName(\"a\")[0];\n            if (((((!c || !d)) || !c.length))) {\n                return {\n                };\n            }\n        ;\n        ;\n            f = e.createElement(\"select\");\n            g = f.appendChild(e.createElement(\"option\"));\n            i = o.getElementsByTagName(\"input\")[0];\n            d.style.cssText = \"top:1px;float:left;opacity:.5\";\n            b = {\n                leadingWhitespace: ((o.firstChild.nodeType === 3)),\n                tbody: !o.getElementsByTagName(\"tbody\").length,\n                htmlSerialize: !!o.getElementsByTagName(\"link\").length,\n                style: /top/.test(d.getAttribute(\"style\")),\n                hrefNormalized: ((d.getAttribute(\"href\") === \"/a\")),\n                opacity: /^0.5/.test(d.style.opacity),\n                cssFloat: !!d.style.cssFloat,\n                checkOn: ((i.value === \"JSBNG__on\")),\n                optSelected: g.selected,\n                getSetAttribute: ((o.className !== \"t\")),\n                enctype: !!e.createElement(\"form\").enctype,\n                html5Clone: ((e.createElement(\"nav\").cloneNode(!0).outerHTML !== \"\\u003C:nav\\u003E\\u003C/:nav\\u003E\")),\n                boxModel: ((e.compatMode === \"CSS1Compat\")),\n                submitBubbles: !0,\n                changeBubbles: !0,\n                focusinBubbles: !1,\n                deleteExpando: !0,\n                noCloneEvent: !0,\n                inlineBlockNeedsLayout: !1,\n                shrinkWrapBlocks: !1,\n                reliableMarginRight: !0,\n                boxSizingReliable: !0,\n                pixelPosition: !1\n            };\n            i.checked = !0;\n            b.noCloneChecked = i.cloneNode(!0).checked;\n            f.disabled = !0;\n            b.optDisabled = !g.disabled;\n            try {\n                delete o.test;\n            } catch (p) {\n                b.deleteExpando = !1;\n            };\n        ;\n            if (((((!o.JSBNG__addEventListener && o.JSBNG__attachEvent)) && o.fireEvent))) {\n                o.JSBNG__attachEvent(\"JSBNG__onclick\", n = function() {\n                    b.noCloneEvent = !1;\n                });\n                o.cloneNode(!0).fireEvent(\"JSBNG__onclick\");\n                o.JSBNG__detachEvent(\"JSBNG__onclick\", n);\n            }\n        ;\n        ;\n            i = e.createElement(\"input\");\n            i.value = \"t\";\n            i.setAttribute(\"type\", \"radio\");\n            b.radioValue = ((i.value === \"t\"));\n            i.setAttribute(\"checked\", \"checked\");\n            i.setAttribute(\"JSBNG__name\", \"t\");\n            o.appendChild(i);\n            j = e.createDocumentFragment();\n            j.appendChild(o.lastChild);\n            b.checkClone = j.cloneNode(!0).cloneNode(!0).lastChild.checked;\n            b.appendChecked = i.checked;\n            j.removeChild(i);\n            j.appendChild(o);\n            if (o.JSBNG__attachEvent) {\n                {\n                    var fin21keys = ((window.top.JSBNG_Replay.forInKeys)(({\n                        submit: !0,\n                        change: !0,\n                        focusin: !0\n                    }))), fin21i = (0);\n                    (0);\n                    for (; (fin21i < fin21keys.length); (fin21i++)) {\n                        ((l) = (fin21keys[fin21i]));\n                        {\n                            k = ((\"JSBNG__on\" + l));\n                            m = ((k in o));\n                            if (!m) {\n                                o.setAttribute(k, \"return;\");\n                                m = ((typeof o[k] == \"function\"));\n                            }\n                        ;\n                        ;\n                            b[((l + \"Bubbles\"))] = m;\n                        };\n                    };\n                };\n            }\n        ;\n        ;\n            q(function() {\n                var c, d, f, g, i = \"padding:0;margin:0;border:0;display:block;overflow:hidden;\", j = e.getElementsByTagName(\"body\")[0];\n                if (!j) {\n                    return;\n                }\n            ;\n            ;\n                c = e.createElement(\"div\");\n                c.style.cssText = \"visibility:hidden;border:0;width:0;height:0;position:static;top:0;margin-top:1px\";\n                j.insertBefore(c, j.firstChild);\n                d = e.createElement(\"div\");\n                c.appendChild(d);\n                d.innerHTML = \"\\u003Ctable\\u003E\\u003Ctr\\u003E\\u003Ctd\\u003E\\u003C/td\\u003E\\u003Ctd\\u003Et\\u003C/td\\u003E\\u003C/tr\\u003E\\u003C/table\\u003E\";\n                f = d.getElementsByTagName(\"td\");\n                f[0].style.cssText = \"padding:0;margin:0;border:0;display:none\";\n                m = ((f[0].offsetHeight === 0));\n                f[0].style.display = \"\";\n                f[1].style.display = \"none\";\n                b.reliableHiddenOffsets = ((m && ((f[0].offsetHeight === 0))));\n                d.innerHTML = \"\";\n                d.style.cssText = \"box-sizing:border-box;-moz-box-sizing:border-box;-webkit-box-sizing:border-box;padding:1px;border:1px;display:block;width:4px;margin-top:1%;position:absolute;top:1%;\";\n                b.boxSizing = ((d.offsetWidth === 4));\n                b.doesNotIncludeMarginInBodyOffset = ((j.offsetTop !== 1));\n                if (a.JSBNG__getComputedStyle) {\n                    b.pixelPosition = ((((a.JSBNG__getComputedStyle(d, null) || {\n                    })).JSBNG__top !== \"1%\"));\n                    b.boxSizingReliable = ((((a.JSBNG__getComputedStyle(d, null) || {\n                        width: \"4px\"\n                    })).width === \"4px\"));\n                    g = e.createElement(\"div\");\n                    g.style.cssText = d.style.cssText = i;\n                    g.style.marginRight = g.style.width = \"0\";\n                    d.style.width = \"1px\";\n                    d.appendChild(g);\n                    b.reliableMarginRight = !parseFloat(((a.JSBNG__getComputedStyle(g, null) || {\n                    })).marginRight);\n                }\n            ;\n            ;\n                if (((typeof d.style.zoom != \"undefined\"))) {\n                    d.innerHTML = \"\";\n                    d.style.cssText = ((i + \"width:1px;padding:1px;display:inline;zoom:1\"));\n                    b.inlineBlockNeedsLayout = ((d.offsetWidth === 3));\n                    d.style.display = \"block\";\n                    d.style.overflow = \"visible\";\n                    d.innerHTML = \"\\u003Cdiv\\u003E\\u003C/div\\u003E\";\n                    d.firstChild.style.width = \"5px\";\n                    b.shrinkWrapBlocks = ((d.offsetWidth !== 3));\n                    c.style.zoom = 1;\n                }\n            ;\n            ;\n                j.removeChild(c);\n                c = d = f = g = null;\n            });\n            j.removeChild(o);\n            c = d = f = g = i = j = o = null;\n            return b;\n        }();\n        var I = /(?:\\{[\\s\\S]*\\}|\\[[\\s\\S]*\\])$/, J = /([A-Z])/g;\n        q.extend({\n            cache: {\n            },\n            deletedIds: [],\n            uuid: 0,\n            expando: ((\"jQuery\" + ((q.fn.jquery + Math.JSBNG__random())).replace(/\\D/g, \"\"))),\n            noData: {\n                embed: !0,\n                object: \"clsid:D27CDB6E-AE6D-11cf-96B8-444553540000\",\n                applet: !0\n            },\n            hasData: function(a) {\n                a = ((a.nodeType ? q.cache[a[q.expando]] : a[q.expando]));\n                return ((!!a && !L(a)));\n            },\n            data: function(a, c, d, e) {\n                if (!q.acceptData(a)) {\n                    return;\n                }\n            ;\n            ;\n                var f, g, i = q.expando, j = ((typeof c == \"string\")), k = a.nodeType, l = ((k ? q.cache : a)), m = ((k ? a[i] : ((a[i] && i))));\n                if (((((((((!m || !l[m])) || ((!e && !l[m].data)))) && j)) && ((d === b))))) {\n                    return;\n                }\n            ;\n            ;\n                ((m || ((k ? a[i] = m = ((q.deletedIds.pop() || q.guid++)) : m = i))));\n                if (!l[m]) {\n                    l[m] = {\n                    };\n                    ((k || (l[m].toJSON = q.noop)));\n                }\n            ;\n            ;\n                if (((((typeof c == \"object\")) || ((typeof c == \"function\"))))) {\n                    ((e ? l[m] = q.extend(l[m], c) : l[m].data = q.extend(l[m].data, c)));\n                }\n            ;\n            ;\n                f = l[m];\n                if (!e) {\n                    ((f.data || (f.data = {\n                    })));\n                    f = f.data;\n                }\n            ;\n            ;\n                ((((d !== b)) && (f[q.camelCase(c)] = d)));\n                if (j) {\n                    g = f[c];\n                    ((((g == null)) && (g = f[q.camelCase(c)])));\n                }\n                 else g = f;\n            ;\n            ;\n                return g;\n            },\n            removeData: function(a, b, c) {\n                if (!q.acceptData(a)) {\n                    return;\n                }\n            ;\n            ;\n                var d, e, f, g = a.nodeType, i = ((g ? q.cache : a)), j = ((g ? a[q.expando] : q.expando));\n                if (!i[j]) {\n                    return;\n                }\n            ;\n            ;\n                if (b) {\n                    d = ((c ? i[j] : i[j].data));\n                    if (d) {\n                        if (!q.isArray(b)) {\n                            if (((b in d))) b = [b,];\n                             else {\n                                b = q.camelCase(b);\n                                ((((b in d)) ? b = [b,] : b = b.split(\" \")));\n                            }\n                        ;\n                        }\n                    ;\n                    ;\n                        for (e = 0, f = b.length; ((e < f)); e++) {\n                            delete d[b[e]];\n                        ;\n                        };\n                    ;\n                        if (!((c ? L : q.isEmptyObject))(d)) {\n                            return;\n                        }\n                    ;\n                    ;\n                    }\n                ;\n                ;\n                }\n            ;\n            ;\n                if (!c) {\n                    delete i[j].data;\n                    if (!L(i[j])) {\n                        return;\n                    }\n                ;\n                ;\n                }\n            ;\n            ;\n                ((g ? q.cleanData([a,], !0) : ((((q.support.deleteExpando || ((i != i.window)))) ? delete i[j] : i[j] = null))));\n            },\n            _data: function(a, b, c) {\n                return q.data(a, b, c, !0);\n            },\n            acceptData: function(a) {\n                var b = ((a.nodeName && q.noData[a.nodeName.toLowerCase()]));\n                return ((!b || ((((b !== !0)) && ((a.getAttribute(\"classid\") === b))))));\n            }\n        });\n        q.fn.extend({\n            data: function(a, c) {\n                var d, e, f, g, i, j = this[0], k = 0, l = null;\n                if (((a === b))) {\n                    if (this.length) {\n                        l = q.data(j);\n                        if (((((j.nodeType === 1)) && !q._data(j, \"parsedAttrs\")))) {\n                            f = j.attributes;\n                            for (i = f.length; ((k < i)); k++) {\n                                g = f[k].JSBNG__name;\n                                if (!g.indexOf(\"data-\")) {\n                                    g = q.camelCase(g.substring(5));\n                                    K(j, g, l[g]);\n                                }\n                            ;\n                            ;\n                            };\n                        ;\n                            q._data(j, \"parsedAttrs\", !0);\n                        }\n                    ;\n                    ;\n                    }\n                ;\n                ;\n                    return l;\n                }\n            ;\n            ;\n                if (((typeof a == \"object\"))) {\n                    return this.each(function() {\n                        q.data(this, a);\n                    });\n                }\n            ;\n            ;\n                d = a.split(\".\", 2);\n                d[1] = ((d[1] ? ((\".\" + d[1])) : \"\"));\n                e = ((d[1] + \"!\"));\n                return q.access(this, function(c) {\n                    if (((c === b))) {\n                        l = this.triggerHandler(((\"getData\" + e)), [d[0],]);\n                        if (((((l === b)) && j))) {\n                            l = q.data(j, a);\n                            l = K(j, a, l);\n                        }\n                    ;\n                    ;\n                        return ((((((l === b)) && d[1])) ? this.data(d[0]) : l));\n                    }\n                ;\n                ;\n                    d[1] = c;\n                    this.each(function() {\n                        var b = q(this);\n                        b.triggerHandler(((\"setData\" + e)), d);\n                        q.data(this, a, c);\n                        b.triggerHandler(((\"changeData\" + e)), d);\n                    });\n                }, null, c, ((arguments.length > 1)), null, !1);\n            },\n            removeData: function(a) {\n                return this.each(function() {\n                    q.removeData(this, a);\n                });\n            }\n        });\n        q.extend({\n            queue: function(a, b, c) {\n                var d;\n                if (a) {\n                    b = ((((b || \"fx\")) + \"queue\"));\n                    d = q._data(a, b);\n                    ((c && ((((!d || q.isArray(c))) ? d = q._data(a, b, q.makeArray(c)) : d.push(c)))));\n                    return ((d || []));\n                }\n            ;\n            ;\n            },\n            dequeue: function(a, b) {\n                b = ((b || \"fx\"));\n                var c = q.queue(a, b), d = c.length, e = c.shift(), f = q._queueHooks(a, b), g = function() {\n                    q.dequeue(a, b);\n                };\n                if (((e === \"inprogress\"))) {\n                    e = c.shift();\n                    d--;\n                }\n            ;\n            ;\n                if (e) {\n                    ((((b === \"fx\")) && c.unshift(\"inprogress\")));\n                    delete f.JSBNG__stop;\n                    e.call(a, g, f);\n                }\n            ;\n            ;\n                ((((!d && f)) && f.empty.fire()));\n            },\n            _queueHooks: function(a, b) {\n                var c = ((b + \"queueHooks\"));\n                return ((q._data(a, c) || q._data(a, c, {\n                    empty: q.Callbacks(\"once memory\").add(function() {\n                        q.removeData(a, ((b + \"queue\")), !0);\n                        q.removeData(a, c, !0);\n                    })\n                })));\n            }\n        });\n        q.fn.extend({\n            queue: function(a, c) {\n                var d = 2;\n                if (((typeof a != \"string\"))) {\n                    c = a;\n                    a = \"fx\";\n                    d--;\n                }\n            ;\n            ;\n                return ((((arguments.length < d)) ? q.queue(this[0], a) : ((((c === b)) ? this : this.each(function() {\n                    var b = q.queue(this, a, c);\n                    q._queueHooks(this, a);\n                    ((((((a === \"fx\")) && ((b[0] !== \"inprogress\")))) && q.dequeue(this, a)));\n                })))));\n            },\n            dequeue: function(a) {\n                return this.each(function() {\n                    q.dequeue(this, a);\n                });\n            },\n            delay: function(a, b) {\n                a = ((q.fx ? ((q.fx.speeds[a] || a)) : a));\n                b = ((b || \"fx\"));\n                return this.queue(b, function(b, c) {\n                    var d = JSBNG__setTimeout(b, a);\n                    c.JSBNG__stop = function() {\n                        JSBNG__clearTimeout(d);\n                    };\n                });\n            },\n            clearQueue: function(a) {\n                return this.queue(((a || \"fx\")), []);\n            },\n            promise: function(a, c) {\n                var d, e = 1, f = q.Deferred(), g = this, i = this.length, j = function() {\n                    ((--e || f.resolveWith(g, [g,])));\n                };\n                if (((typeof a != \"string\"))) {\n                    c = a;\n                    a = b;\n                }\n            ;\n            ;\n                a = ((a || \"fx\"));\n                while (i--) {\n                    d = q._data(g[i], ((a + \"queueHooks\")));\n                    if (((d && d.empty))) {\n                        e++;\n                        d.empty.add(j);\n                    }\n                ;\n                ;\n                };\n            ;\n                j();\n                return f.promise(c);\n            }\n        });\n        var M, N, O, P = /[\\t\\r\\n]/g, Q = /\\r/g, R = /^(?:button|input)$/i, S = /^(?:button|input|object|select|textarea)$/i, T = /^a(?:rea|)$/i, U = /^(?:autofocus|autoplay|async|checked|controls|defer|disabled|hidden|loop|multiple|open|readonly|required|scoped|selected)$/i, V = q.support.getSetAttribute;\n        q.fn.extend({\n            attr: function(a, b) {\n                return q.access(this, q.attr, a, b, ((arguments.length > 1)));\n            },\n            removeAttr: function(a) {\n                return this.each(function() {\n                    q.removeAttr(this, a);\n                });\n            },\n            prop: function(a, b) {\n                return q.access(this, q.prop, a, b, ((arguments.length > 1)));\n            },\n            removeProp: function(a) {\n                a = ((q.propFix[a] || a));\n                return this.each(function() {\n                    try {\n                        this[a] = b;\n                        delete this[a];\n                    } catch (c) {\n                    \n                    };\n                ;\n                });\n            },\n            addClass: function(a) {\n                var b, c, d, e, f, g, i;\n                if (q.isFunction(a)) {\n                    return this.each(function(b) {\n                        q(this).addClass(a.call(this, b, this.className));\n                    });\n                }\n            ;\n            ;\n                if (((a && ((typeof a == \"string\"))))) {\n                    b = a.split(t);\n                    for (c = 0, d = this.length; ((c < d)); c++) {\n                        e = this[c];\n                        if (((e.nodeType === 1))) {\n                            if (((!e.className && ((b.length === 1))))) e.className = a;\n                             else {\n                                f = ((((\" \" + e.className)) + \" \"));\n                                for (g = 0, i = b.length; ((g < i)); g++) {\n                                    ((((f.indexOf(((((\" \" + b[g])) + \" \"))) < 0)) && (f += ((b[g] + \" \")))));\n                                ;\n                                };\n                            ;\n                                e.className = q.trim(f);\n                            }\n                        ;\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                }\n            ;\n            ;\n                return this;\n            },\n            removeClass: function(a) {\n                var c, d, e, f, g, i, j;\n                if (q.isFunction(a)) {\n                    return this.each(function(b) {\n                        q(this).removeClass(a.call(this, b, this.className));\n                    });\n                }\n            ;\n            ;\n                if (((((a && ((typeof a == \"string\")))) || ((a === b))))) {\n                    c = ((a || \"\")).split(t);\n                    for (i = 0, j = this.length; ((i < j)); i++) {\n                        e = this[i];\n                        if (((((e.nodeType === 1)) && e.className))) {\n                            d = ((((\" \" + e.className)) + \" \")).replace(P, \" \");\n                            for (f = 0, g = c.length; ((f < g)); f++) {\n                                while (((d.indexOf(((((\" \" + c[f])) + \" \"))) >= 0))) {\n                                    d = d.replace(((((\" \" + c[f])) + \" \")), \" \");\n                                ;\n                                };\n                            ;\n                            };\n                        ;\n                            e.className = ((a ? q.trim(d) : \"\"));\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                }\n            ;\n            ;\n                return this;\n            },\n            toggleClass: function(a, b) {\n                var c = typeof a, d = ((typeof b == \"boolean\"));\n                return ((q.isFunction(a) ? this.each(function(c) {\n                    q(this).toggleClass(a.call(this, c, this.className, b), b);\n                }) : this.each(function() {\n                    if (((c === \"string\"))) {\n                        var e, f = 0, g = q(this), i = b, j = a.split(t);\n                        while (e = j[f++]) {\n                            i = ((d ? i : !g.hasClass(e)));\n                            g[((i ? \"addClass\" : \"removeClass\"))](e);\n                        };\n                    ;\n                    }\n                     else if (((((c === \"undefined\")) || ((c === \"boolean\"))))) {\n                        ((this.className && q._data(this, \"__className__\", this.className)));\n                        this.className = ((((this.className || ((a === !1)))) ? \"\" : ((q._data(this, \"__className__\") || \"\"))));\n                    }\n                    \n                ;\n                ;\n                })));\n            },\n            hasClass: function(a) {\n                var b = ((((\" \" + a)) + \" \")), c = 0, d = this.length;\n                for (; ((c < d)); c++) {\n                    if (((((this[c].nodeType === 1)) && ((((((\" \" + this[c].className)) + \" \")).replace(P, \" \").indexOf(b) >= 0))))) {\n                        return !0;\n                    }\n                ;\n                ;\n                };\n            ;\n                return !1;\n            },\n            val: function(a) {\n                var c, d, e, f = this[0];\n                if (!arguments.length) {\n                    if (f) {\n                        c = ((q.valHooks[f.type] || q.valHooks[f.nodeName.toLowerCase()]));\n                        if (((((c && ((\"get\" in c)))) && (((d = c.get(f, \"value\")) !== b))))) {\n                            return d;\n                        }\n                    ;\n                    ;\n                        d = f.value;\n                        return ((((typeof d == \"string\")) ? d.replace(Q, \"\") : ((((d == null)) ? \"\" : d))));\n                    }\n                ;\n                ;\n                    return;\n                }\n            ;\n            ;\n                e = q.isFunction(a);\n                return this.each(function(d) {\n                    var f, g = q(this);\n                    if (((this.nodeType !== 1))) {\n                        return;\n                    }\n                ;\n                ;\n                    ((e ? f = a.call(this, d, g.val()) : f = a));\n                    ((((f == null)) ? f = \"\" : ((((typeof f == \"number\")) ? f += \"\" : ((q.isArray(f) && (f = q.map(f, function(a) {\n                        return ((((a == null)) ? \"\" : ((a + \"\"))));\n                    }))))))));\n                    c = ((q.valHooks[this.type] || q.valHooks[this.nodeName.toLowerCase()]));\n                    if (((((!c || !((\"set\" in c)))) || ((c.set(this, f, \"value\") === b))))) {\n                        this.value = f;\n                    }\n                ;\n                ;\n                });\n            }\n        });\n        q.extend({\n            valHooks: {\n                option: {\n                    get: function(a) {\n                        var b = a.attributes.value;\n                        return ((((!b || b.specified)) ? a.value : a.text));\n                    }\n                },\n                select: {\n                    get: function(a) {\n                        var b, c, d = a.options, e = a.selectedIndex, f = ((((a.type === \"select-one\")) || ((e < 0)))), g = ((f ? null : [])), i = ((f ? ((e + 1)) : d.length)), j = ((((e < 0)) ? i : ((f ? e : 0))));\n                        for (; ((j < i)); j++) {\n                            c = d[j];\n                            if (((((((c.selected || ((j === e)))) && ((q.support.optDisabled ? !c.disabled : ((c.getAttribute(\"disabled\") === null)))))) && ((!c.parentNode.disabled || !q.nodeName(c.parentNode, \"optgroup\")))))) {\n                                b = q(c).val();\n                                if (f) {\n                                    return b;\n                                }\n                            ;\n                            ;\n                                g.push(b);\n                            }\n                        ;\n                        ;\n                        };\n                    ;\n                        return g;\n                    },\n                    set: function(a, b) {\n                        var c = q.makeArray(b);\n                        q(a).JSBNG__find(\"option\").each(function() {\n                            this.selected = ((q.inArray(q(this).val(), c) >= 0));\n                        });\n                        ((c.length || (a.selectedIndex = -1)));\n                        return c;\n                    }\n                }\n            },\n            attrFn: {\n            },\n            attr: function(a, c, d, e) {\n                var f, g, i, j = a.nodeType;\n                if (((((((!a || ((j === 3)))) || ((j === 8)))) || ((j === 2))))) {\n                    return;\n                }\n            ;\n            ;\n                if (((e && q.isFunction(q.fn[c])))) {\n                    return q(a)[c](d);\n                }\n            ;\n            ;\n                if (((typeof a.getAttribute == \"undefined\"))) {\n                    return q.prop(a, c, d);\n                }\n            ;\n            ;\n                i = ((((j !== 1)) || !q.isXMLDoc(a)));\n                if (i) {\n                    c = c.toLowerCase();\n                    g = ((q.attrHooks[c] || ((U.test(c) ? N : M))));\n                }\n            ;\n            ;\n                if (((d !== b))) {\n                    if (((d === null))) {\n                        q.removeAttr(a, c);\n                        return;\n                    }\n                ;\n                ;\n                    if (((((((g && ((\"set\" in g)))) && i)) && (((f = g.set(a, d, c)) !== b))))) {\n                        return f;\n                    }\n                ;\n                ;\n                    a.setAttribute(c, ((d + \"\")));\n                    return d;\n                }\n            ;\n            ;\n                if (((((((g && ((\"get\" in g)))) && i)) && (((f = g.get(a, c)) !== null))))) {\n                    return f;\n                }\n            ;\n            ;\n                f = a.getAttribute(c);\n                return ((((f === null)) ? b : f));\n            },\n            removeAttr: function(a, b) {\n                var c, d, e, f, g = 0;\n                if (((b && ((a.nodeType === 1))))) {\n                    d = b.split(t);\n                    for (; ((g < d.length)); g++) {\n                        e = d[g];\n                        if (e) {\n                            c = ((q.propFix[e] || e));\n                            f = U.test(e);\n                            ((f || q.attr(a, e, \"\")));\n                            a.removeAttribute(((V ? e : c)));\n                            ((((f && ((c in a)))) && (a[c] = !1)));\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                }\n            ;\n            ;\n            },\n            attrHooks: {\n                type: {\n                    set: function(a, b) {\n                        if (((R.test(a.nodeName) && a.parentNode))) {\n                            q.error(\"type property can't be changed\");\n                        }\n                         else {\n                            if (((((!q.support.radioValue && ((b === \"radio\")))) && q.nodeName(a, \"input\")))) {\n                                var c = a.value;\n                                a.setAttribute(\"type\", b);\n                                ((c && (a.value = c)));\n                                return b;\n                            }\n                        ;\n                        }\n                    ;\n                    ;\n                    }\n                },\n                value: {\n                    get: function(a, b) {\n                        return ((((M && q.nodeName(a, \"button\"))) ? M.get(a, b) : ((((b in a)) ? a.value : null))));\n                    },\n                    set: function(a, b, c) {\n                        if (((M && q.nodeName(a, \"button\")))) {\n                            return M.set(a, b, c);\n                        }\n                    ;\n                    ;\n                        a.value = b;\n                    }\n                }\n            },\n            propFix: {\n                tabindex: \"tabIndex\",\n                readonly: \"readOnly\",\n                \"for\": \"htmlFor\",\n                class: \"className\",\n                maxlength: \"maxLength\",\n                cellspacing: \"cellSpacing\",\n                cellpadding: \"cellPadding\",\n                rowspan: \"rowSpan\",\n                colspan: \"colSpan\",\n                usemap: \"useMap\",\n                frameborder: \"frameBorder\",\n                contenteditable: \"contentEditable\"\n            },\n            prop: function(a, c, d) {\n                var e, f, g, i = a.nodeType;\n                if (((((((!a || ((i === 3)))) || ((i === 8)))) || ((i === 2))))) {\n                    return;\n                }\n            ;\n            ;\n                g = ((((i !== 1)) || !q.isXMLDoc(a)));\n                if (g) {\n                    c = ((q.propFix[c] || c));\n                    f = q.propHooks[c];\n                }\n            ;\n            ;\n                return ((((d !== b)) ? ((((((f && ((\"set\" in f)))) && (((e = f.set(a, d, c)) !== b)))) ? e : a[c] = d)) : ((((((f && ((\"get\" in f)))) && (((e = f.get(a, c)) !== null)))) ? e : a[c]))));\n            },\n            propHooks: {\n                tabIndex: {\n                    get: function(a) {\n                        var c = a.getAttributeNode(\"tabindex\");\n                        return ((((c && c.specified)) ? parseInt(c.value, 10) : ((((S.test(a.nodeName) || ((T.test(a.nodeName) && a.href)))) ? 0 : b))));\n                    }\n                }\n            }\n        });\n        N = {\n            get: function(a, c) {\n                var d, e = q.prop(a, c);\n                return ((((((e === !0)) || ((((((typeof e != \"boolean\")) && (d = a.getAttributeNode(c)))) && ((d.nodeValue !== !1)))))) ? c.toLowerCase() : b));\n            },\n            set: function(a, b, c) {\n                var d;\n                if (((b === !1))) q.removeAttr(a, c);\n                 else {\n                    d = ((q.propFix[c] || c));\n                    ((((d in a)) && (a[d] = !0)));\n                    a.setAttribute(c, c.toLowerCase());\n                }\n            ;\n            ;\n                return c;\n            }\n        };\n        if (!V) {\n            O = {\n                JSBNG__name: !0,\n                id: !0,\n                coords: !0\n            };\n            M = q.valHooks.button = {\n                get: function(a, c) {\n                    var d;\n                    d = a.getAttributeNode(c);\n                    return ((((d && ((O[c] ? ((d.value !== \"\")) : d.specified)))) ? d.value : b));\n                },\n                set: function(a, b, c) {\n                    var d = a.getAttributeNode(c);\n                    if (!d) {\n                        d = e.createAttribute(c);\n                        a.setAttributeNode(d);\n                    }\n                ;\n                ;\n                    return d.value = ((b + \"\"));\n                }\n            };\n            q.each([\"width\",\"height\",], function(a, b) {\n                q.attrHooks[b] = q.extend(q.attrHooks[b], {\n                    set: function(a, c) {\n                        if (((c === \"\"))) {\n                            a.setAttribute(b, \"auto\");\n                            return c;\n                        }\n                    ;\n                    ;\n                    }\n                });\n            });\n            q.attrHooks.contenteditable = {\n                get: M.get,\n                set: function(a, b, c) {\n                    ((((b === \"\")) && (b = \"false\")));\n                    M.set(a, b, c);\n                }\n            };\n        }\n    ;\n    ;\n        ((q.support.hrefNormalized || q.each([\"href\",\"src\",\"width\",\"height\",], function(a, c) {\n            q.attrHooks[c] = q.extend(q.attrHooks[c], {\n                get: function(a) {\n                    var d = a.getAttribute(c, 2);\n                    return ((((d === null)) ? b : d));\n                }\n            });\n        })));\n        ((q.support.style || (q.attrHooks.style = {\n            get: function(a) {\n                return ((a.style.cssText.toLowerCase() || b));\n            },\n            set: function(a, b) {\n                return a.style.cssText = ((b + \"\"));\n            }\n        })));\n        ((q.support.optSelected || (q.propHooks.selected = q.extend(q.propHooks.selected, {\n            get: function(a) {\n                var b = a.parentNode;\n                if (b) {\n                    b.selectedIndex;\n                    ((b.parentNode && b.parentNode.selectedIndex));\n                }\n            ;\n            ;\n                return null;\n            }\n        }))));\n        ((q.support.enctype || (q.propFix.enctype = \"encoding\")));\n        ((q.support.checkOn || q.each([\"radio\",\"checkbox\",], function() {\n            q.valHooks[this] = {\n                get: function(a) {\n                    return ((((a.getAttribute(\"value\") === null)) ? \"JSBNG__on\" : a.value));\n                }\n            };\n        })));\n        q.each([\"radio\",\"checkbox\",], function() {\n            q.valHooks[this] = q.extend(q.valHooks[this], {\n                set: function(a, b) {\n                    if (q.isArray(b)) {\n                        return a.checked = ((q.inArray(q(a).val(), b) >= 0));\n                    }\n                ;\n                ;\n                }\n            });\n        });\n        var W = /^(?:textarea|input|select)$/i, X = /^([^\\.]*|)(?:\\.(.+)|)$/, Y = /(?:^|\\s)hover(\\.\\S+|)\\b/, Z = /^key/, ab = /^(?:mouse|contextmenu)|click/, bb = /^(?:focusinfocus|focusoutblur)$/, cb = function(a) {\n            return ((q.JSBNG__event.special.hover ? a : a.replace(Y, \"mouseenter$1 mouseleave$1\")));\n        };\n        q.JSBNG__event = {\n            add: function(a, c, d, e, f) {\n                var g, i, j, k, l, m, n, o, p, r, s;\n                if (((((((((((a.nodeType === 3)) || ((a.nodeType === 8)))) || !c)) || !d)) || !(g = q._data(a))))) {\n                    return;\n                }\n            ;\n            ;\n                if (d.handler) {\n                    p = d;\n                    d = p.handler;\n                    f = p.selector;\n                }\n            ;\n            ;\n                ((d.guid || (d.guid = q.guid++)));\n                j = g.events;\n                ((j || (g.events = j = {\n                })));\n                i = g.handle;\n                if (!i) {\n                    g.handle = i = function(a) {\n                        return ((((((typeof q == \"undefined\")) || ((!!a && ((q.JSBNG__event.triggered === a.type)))))) ? b : q.JSBNG__event.dispatch.apply(i.elem, arguments)));\n                    };\n                    i.elem = a;\n                }\n            ;\n            ;\n                c = q.trim(cb(c)).split(\" \");\n                for (k = 0; ((k < c.length)); k++) {\n                    l = ((X.exec(c[k]) || []));\n                    m = l[1];\n                    n = ((l[2] || \"\")).split(\".\").sort();\n                    s = ((q.JSBNG__event.special[m] || {\n                    }));\n                    m = ((((f ? s.delegateType : s.bindType)) || m));\n                    s = ((q.JSBNG__event.special[m] || {\n                    }));\n                    o = q.extend({\n                        type: m,\n                        origType: l[1],\n                        data: e,\n                        handler: d,\n                        guid: d.guid,\n                        selector: f,\n                        needsContext: ((f && q.expr.match.needsContext.test(f))),\n                        namespace: n.join(\".\")\n                    }, p);\n                    r = j[m];\n                    if (!r) {\n                        r = j[m] = [];\n                        r.delegateCount = 0;\n                        if (((!s.setup || ((s.setup.call(a, e, n, i) === !1))))) {\n                            ((a.JSBNG__addEventListener ? a.JSBNG__addEventListener(m, i, !1) : ((a.JSBNG__attachEvent && a.JSBNG__attachEvent(((\"JSBNG__on\" + m)), i)))));\n                        }\n                    ;\n                    ;\n                    }\n                ;\n                ;\n                    if (s.add) {\n                        s.add.call(a, o);\n                        ((o.handler.guid || (o.handler.guid = d.guid)));\n                    }\n                ;\n                ;\n                    ((f ? r.splice(r.delegateCount++, 0, o) : r.push(o)));\n                    q.JSBNG__event.global[m] = !0;\n                };\n            ;\n                a = null;\n            },\n            global: {\n            },\n            remove: function(a, b, c, d, e) {\n                var f, g, i, j, k, l, m, n, o, p, r, s = ((q.hasData(a) && q._data(a)));\n                if (((!s || !(n = s.events)))) {\n                    return;\n                }\n            ;\n            ;\n                b = q.trim(cb(((b || \"\")))).split(\" \");\n                for (f = 0; ((f < b.length)); f++) {\n                    g = ((X.exec(b[f]) || []));\n                    i = j = g[1];\n                    k = g[2];\n                    if (!i) {\n                        {\n                            var fin22keys = ((window.top.JSBNG_Replay.forInKeys)((n))), fin22i = (0);\n                            (0);\n                            for (; (fin22i < fin22keys.length); (fin22i++)) {\n                                ((i) = (fin22keys[fin22i]));\n                                {\n                                    q.JSBNG__event.remove(a, ((i + b[f])), c, d, !0);\n                                ;\n                                };\n                            };\n                        };\n                    ;\n                        continue;\n                    }\n                ;\n                ;\n                    o = ((q.JSBNG__event.special[i] || {\n                    }));\n                    i = ((((d ? o.delegateType : o.bindType)) || i));\n                    p = ((n[i] || []));\n                    l = p.length;\n                    k = ((k ? new RegExp(((((\"(^|\\\\.)\" + k.split(\".\").sort().join(\"\\\\.(?:.*\\\\.|)\"))) + \"(\\\\.|$)\"))) : null));\n                    for (m = 0; ((m < p.length)); m++) {\n                        r = p[m];\n                        if (((((((((e || ((j === r.origType)))) && ((!c || ((c.guid === r.guid)))))) && ((!k || k.test(r.namespace))))) && ((((!d || ((d === r.selector)))) || ((((d === \"**\")) && r.selector))))))) {\n                            p.splice(m--, 1);\n                            ((r.selector && p.delegateCount--));\n                            ((o.remove && o.remove.call(a, r)));\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    if (((((p.length === 0)) && ((l !== p.length))))) {\n                        ((((!o.teardown || ((o.teardown.call(a, k, s.handle) === !1)))) && q.removeEvent(a, i, s.handle)));\n                        delete n[i];\n                    }\n                ;\n                ;\n                };\n            ;\n                if (q.isEmptyObject(n)) {\n                    delete s.handle;\n                    q.removeData(a, \"events\", !0);\n                }\n            ;\n            ;\n            },\n            customEvent: {\n                getData: !0,\n                setData: !0,\n                changeData: !0\n            },\n            trigger: function(c, d, f, g) {\n                if (((!f || ((((f.nodeType !== 3)) && ((f.nodeType !== 8))))))) {\n                    var i, j, k, l, m, n, o, p, r, s, t = ((c.type || c)), u = [];\n                    if (bb.test(((t + q.JSBNG__event.triggered)))) {\n                        return;\n                    }\n                ;\n                ;\n                    if (((t.indexOf(\"!\") >= 0))) {\n                        t = t.slice(0, -1);\n                        j = !0;\n                    }\n                ;\n                ;\n                    if (((t.indexOf(\".\") >= 0))) {\n                        u = t.split(\".\");\n                        t = u.shift();\n                        u.sort();\n                    }\n                ;\n                ;\n                    if (((((!f || q.JSBNG__event.customEvent[t])) && !q.JSBNG__event.global[t]))) {\n                        return;\n                    }\n                ;\n                ;\n                    c = ((((typeof c == \"object\")) ? ((c[q.expando] ? c : new q.JSBNG__Event(t, c))) : new q.JSBNG__Event(t)));\n                    c.type = t;\n                    c.isTrigger = !0;\n                    c.exclusive = j;\n                    c.namespace = u.join(\".\");\n                    c.namespace_re = ((c.namespace ? new RegExp(((((\"(^|\\\\.)\" + u.join(\"\\\\.(?:.*\\\\.|)\"))) + \"(\\\\.|$)\"))) : null));\n                    n = ((((t.indexOf(\":\") < 0)) ? ((\"JSBNG__on\" + t)) : \"\"));\n                    if (!f) {\n                        i = q.cache;\n                        {\n                            var fin23keys = ((window.top.JSBNG_Replay.forInKeys)((i))), fin23i = (0);\n                            (0);\n                            for (; (fin23i < fin23keys.length); (fin23i++)) {\n                                ((k) = (fin23keys[fin23i]));\n                                {\n                                    ((((i[k].events && i[k].events[t])) && q.JSBNG__event.trigger(c, d, i[k].handle.elem, !0)));\n                                ;\n                                };\n                            };\n                        };\n                    ;\n                        return;\n                    }\n                ;\n                ;\n                    c.result = b;\n                    ((c.target || (c.target = f)));\n                    d = ((((d != null)) ? q.makeArray(d) : []));\n                    d.unshift(c);\n                    o = ((q.JSBNG__event.special[t] || {\n                    }));\n                    if (((o.trigger && ((o.trigger.apply(f, d) === !1))))) {\n                        return;\n                    }\n                ;\n                ;\n                    r = [[f,((o.bindType || t)),],];\n                    if (((((!g && !o.noBubble)) && !q.isWindow(f)))) {\n                        s = ((o.delegateType || t));\n                        l = ((bb.test(((s + t))) ? f : f.parentNode));\n                        for (m = f; l; l = l.parentNode) {\n                            r.push([l,s,]);\n                            m = l;\n                        };\n                    ;\n                        ((((m === ((f.ownerDocument || e)))) && r.push([((((m.defaultView || m.parentWindow)) || a)),s,])));\n                    }\n                ;\n                ;\n                    for (k = 0; ((((k < r.length)) && !c.isPropagationStopped())); k++) {\n                        l = r[k][0];\n                        c.type = r[k][1];\n                        p = ((((q._data(l, \"events\") || {\n                        }))[c.type] && q._data(l, \"handle\")));\n                        ((p && p.apply(l, d)));\n                        p = ((n && l[n]));\n                        ((((((((p && q.acceptData(l))) && p.apply)) && ((p.apply(l, d) === !1)))) && c.preventDefault()));\n                    };\n                ;\n                    c.type = t;\n                    if (((((((((((((((((!g && !c.isDefaultPrevented())) && ((!o._default || ((o._default.apply(f.ownerDocument, d) === !1)))))) && ((((t !== \"click\")) || !q.nodeName(f, \"a\"))))) && q.acceptData(f))) && n)) && f[t])) && ((((((t !== \"JSBNG__focus\")) && ((t !== \"JSBNG__blur\")))) || ((c.target.offsetWidth !== 0)))))) && !q.isWindow(f)))) {\n                        m = f[n];\n                        ((m && (f[n] = null)));\n                        q.JSBNG__event.triggered = t;\n                        f[t]();\n                        q.JSBNG__event.triggered = b;\n                        ((m && (f[n] = m)));\n                    }\n                ;\n                ;\n                    return c.result;\n                }\n            ;\n            ;\n                return;\n            },\n            dispatch: function(c) {\n                c = q.JSBNG__event.fix(((c || a.JSBNG__event)));\n                var d, e, f, g, i, j, k, m, n, o, p = ((((q._data(this, \"events\") || {\n                }))[c.type] || [])), r = p.delegateCount, s = l.call(arguments), t = ((!c.exclusive && !c.namespace)), u = ((q.JSBNG__event.special[c.type] || {\n                })), v = [];\n                s[0] = c;\n                c.delegateTarget = this;\n                if (((u.preDispatch && ((u.preDispatch.call(this, c) === !1))))) {\n                    return;\n                }\n            ;\n            ;\n                if (((r && ((!c.button || ((c.type !== \"click\"))))))) {\n                    for (f = c.target; ((f != this)); f = ((f.parentNode || this))) {\n                        if (((((f.disabled !== !0)) || ((c.type !== \"click\"))))) {\n                            i = {\n                            };\n                            k = [];\n                            for (d = 0; ((d < r)); d++) {\n                                m = p[d];\n                                n = m.selector;\n                                ((((i[n] === b)) && (i[n] = ((m.needsContext ? ((q(n, this).index(f) >= 0)) : q.JSBNG__find(n, this, null, [f,]).length)))));\n                                ((i[n] && k.push(m)));\n                            };\n                        ;\n                            ((k.length && v.push({\n                                elem: f,\n                                matches: k\n                            })));\n                        }\n                    ;\n                    ;\n                    };\n                }\n            ;\n            ;\n                ((((p.length > r)) && v.push({\n                    elem: this,\n                    matches: p.slice(r)\n                })));\n                for (d = 0; ((((d < v.length)) && !c.isPropagationStopped())); d++) {\n                    j = v[d];\n                    c.currentTarget = j.elem;\n                    for (e = 0; ((((e < j.matches.length)) && !c.isImmediatePropagationStopped())); e++) {\n                        m = j.matches[e];\n                        if (((((t || ((!c.namespace && !m.namespace)))) || ((c.namespace_re && c.namespace_re.test(m.namespace)))))) {\n                            c.data = m.data;\n                            c.handleObj = m;\n                            g = ((((q.JSBNG__event.special[m.origType] || {\n                            })).handle || m.handler)).apply(j.elem, s);\n                            if (((g !== b))) {\n                                c.result = g;\n                                if (((g === !1))) {\n                                    c.preventDefault();\n                                    c.stopPropagation();\n                                }\n                            ;\n                            ;\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                };\n            ;\n                ((u.postDispatch && u.postDispatch.call(this, c)));\n                return c.result;\n            },\n            props: \"attrChange attrName relatedNode srcElement altKey bubbles cancelable ctrlKey currentTarget eventPhase metaKey relatedTarget shiftKey target timeStamp view which\".split(\" \"),\n            fixHooks: {\n            },\n            keyHooks: {\n                props: \"char charCode key keyCode\".split(\" \"),\n                filter: function(a, b) {\n                    ((((a.which == null)) && (a.which = ((((b.charCode != null)) ? b.charCode : b.keyCode)))));\n                    return a;\n                }\n            },\n            mouseHooks: {\n                props: \"button buttons clientX clientY fromElement offsetX offsetY pageX pageY screenX screenY toElement\".split(\" \"),\n                filter: function(a, c) {\n                    var d, f, g, i = c.button, j = c.fromElement;\n                    if (((((a.pageX == null)) && ((c.clientX != null))))) {\n                        d = ((a.target.ownerDocument || e));\n                        f = d.documentElement;\n                        g = d.body;\n                        a.pageX = ((((c.clientX + ((((((f && f.scrollLeft)) || ((g && g.scrollLeft)))) || 0)))) - ((((((f && f.clientLeft)) || ((g && g.clientLeft)))) || 0))));\n                        a.pageY = ((((c.clientY + ((((((f && f.scrollTop)) || ((g && g.scrollTop)))) || 0)))) - ((((((f && f.clientTop)) || ((g && g.clientTop)))) || 0))));\n                    }\n                ;\n                ;\n                    ((((!a.relatedTarget && j)) && (a.relatedTarget = ((((j === a.target)) ? c.toElement : j)))));\n                    ((((!a.which && ((i !== b)))) && (a.which = ((((i & 1)) ? 1 : ((((i & 2)) ? 3 : ((((i & 4)) ? 2 : 0)))))))));\n                    return a;\n                }\n            },\n            fix: function(a) {\n                if (a[q.expando]) {\n                    return a;\n                }\n            ;\n            ;\n                var b, c, d = a, f = ((q.JSBNG__event.fixHooks[a.type] || {\n                })), g = ((f.props ? this.props.concat(f.props) : this.props));\n                a = q.JSBNG__Event(d);\n                for (b = g.length; b; ) {\n                    c = g[--b];\n                    a[c] = d[c];\n                };\n            ;\n                ((a.target || (a.target = ((d.srcElement || e)))));\n                ((((a.target.nodeType === 3)) && (a.target = a.target.parentNode)));\n                a.metaKey = !!a.metaKey;\n                return ((f.filter ? f.filter(a, d) : a));\n            },\n            special: {\n                load: {\n                    noBubble: !0\n                },\n                JSBNG__focus: {\n                    delegateType: \"focusin\"\n                },\n                JSBNG__blur: {\n                    delegateType: \"focusout\"\n                },\n                beforeunload: {\n                    setup: function(a, b, c) {\n                        ((q.isWindow(this) && (this.JSBNG__onbeforeunload = c)));\n                    },\n                    teardown: function(a, b) {\n                        ((((this.JSBNG__onbeforeunload === b)) && (this.JSBNG__onbeforeunload = null)));\n                    }\n                }\n            },\n            simulate: function(a, b, c, d) {\n                var e = q.extend(new q.JSBNG__Event, c, {\n                    type: a,\n                    isSimulated: !0,\n                    originalEvent: {\n                    }\n                });\n                ((d ? q.JSBNG__event.trigger(e, null, b) : q.JSBNG__event.dispatch.call(b, e)));\n                ((e.isDefaultPrevented() && c.preventDefault()));\n            }\n        };\n        q.JSBNG__event.handle = q.JSBNG__event.dispatch;\n        q.removeEvent = ((e.JSBNG__removeEventListener ? function(a, b, c) {\n            ((a.JSBNG__removeEventListener && a.JSBNG__removeEventListener(b, c, !1)));\n        } : function(a, b, c) {\n            var d = ((\"JSBNG__on\" + b));\n            if (a.JSBNG__detachEvent) {\n                ((((typeof a[d] == \"undefined\")) && (a[d] = null)));\n                a.JSBNG__detachEvent(d, c);\n            }\n        ;\n        ;\n        }));\n        q.JSBNG__Event = function(a, b) {\n            if (!((this instanceof q.JSBNG__Event))) {\n                return new q.JSBNG__Event(a, b);\n            }\n        ;\n        ;\n            if (((a && a.type))) {\n                this.originalEvent = a;\n                this.type = a.type;\n                this.isDefaultPrevented = ((((((a.defaultPrevented || ((a.returnValue === !1)))) || ((a.getPreventDefault && a.getPreventDefault())))) ? eb : db));\n            }\n             else this.type = a;\n        ;\n        ;\n            ((b && q.extend(this, b)));\n            this.timeStamp = ((((a && a.timeStamp)) || q.now()));\n            this[q.expando] = !0;\n        };\n        q.JSBNG__Event.prototype = {\n            preventDefault: function() {\n                this.isDefaultPrevented = eb;\n                var a = this.originalEvent;\n                if (!a) {\n                    return;\n                }\n            ;\n            ;\n                ((a.preventDefault ? a.preventDefault() : a.returnValue = !1));\n            },\n            stopPropagation: function() {\n                this.isPropagationStopped = eb;\n                var a = this.originalEvent;\n                if (!a) {\n                    return;\n                }\n            ;\n            ;\n                ((a.stopPropagation && a.stopPropagation()));\n                a.cancelBubble = !0;\n            },\n            stopImmediatePropagation: function() {\n                this.isImmediatePropagationStopped = eb;\n                this.stopPropagation();\n            },\n            isDefaultPrevented: db,\n            isPropagationStopped: db,\n            isImmediatePropagationStopped: db\n        };\n        q.each({\n            mouseenter: \"mouseover\",\n            mouseleave: \"mouseout\"\n        }, function(a, b) {\n            q.JSBNG__event.special[a] = {\n                delegateType: b,\n                bindType: b,\n                handle: function(a) {\n                    var c, d = this, e = a.relatedTarget, f = a.handleObj, g = f.selector;\n                    if (((!e || ((((e !== d)) && !q.contains(d, e)))))) {\n                        a.type = f.origType;\n                        c = f.handler.apply(this, arguments);\n                        a.type = b;\n                    }\n                ;\n                ;\n                    return c;\n                }\n            };\n        });\n        ((q.support.submitBubbles || (q.JSBNG__event.special.submit = {\n            setup: function() {\n                if (q.nodeName(this, \"form\")) {\n                    return !1;\n                }\n            ;\n            ;\n                q.JSBNG__event.add(this, \"click._submit keypress._submit\", function(a) {\n                    var c = a.target, d = ((((q.nodeName(c, \"input\") || q.nodeName(c, \"button\"))) ? c.form : b));\n                    if (((d && !q._data(d, \"_submit_attached\")))) {\n                        q.JSBNG__event.add(d, \"submit._submit\", function(a) {\n                            a._submit_bubble = !0;\n                        });\n                        q._data(d, \"_submit_attached\", !0);\n                    }\n                ;\n                ;\n                });\n            },\n            postDispatch: function(a) {\n                if (a._submit_bubble) {\n                    delete a._submit_bubble;\n                    ((((this.parentNode && !a.isTrigger)) && q.JSBNG__event.simulate(\"submit\", this.parentNode, a, !0)));\n                }\n            ;\n            ;\n            },\n            teardown: function() {\n                if (q.nodeName(this, \"form\")) {\n                    return !1;\n                }\n            ;\n            ;\n                q.JSBNG__event.remove(this, \"._submit\");\n            }\n        })));\n        ((q.support.changeBubbles || (q.JSBNG__event.special.change = {\n            setup: function() {\n                if (W.test(this.nodeName)) {\n                    if (((((this.type === \"checkbox\")) || ((this.type === \"radio\"))))) {\n                        q.JSBNG__event.add(this, \"propertychange._change\", function(a) {\n                            ((((a.originalEvent.propertyName === \"checked\")) && (this._just_changed = !0)));\n                        });\n                        q.JSBNG__event.add(this, \"click._change\", function(a) {\n                            ((((this._just_changed && !a.isTrigger)) && (this._just_changed = !1)));\n                            q.JSBNG__event.simulate(\"change\", this, a, !0);\n                        });\n                    }\n                ;\n                ;\n                    return !1;\n                }\n            ;\n            ;\n                q.JSBNG__event.add(this, \"beforeactivate._change\", function(a) {\n                    var b = a.target;\n                    if (((W.test(b.nodeName) && !q._data(b, \"_change_attached\")))) {\n                        q.JSBNG__event.add(b, \"change._change\", function(a) {\n                            ((((((this.parentNode && !a.isSimulated)) && !a.isTrigger)) && q.JSBNG__event.simulate(\"change\", this.parentNode, a, !0)));\n                        });\n                        q._data(b, \"_change_attached\", !0);\n                    }\n                ;\n                ;\n                });\n            },\n            handle: function(a) {\n                var b = a.target;\n                if (((((((((this !== b)) || a.isSimulated)) || a.isTrigger)) || ((((b.type !== \"radio\")) && ((b.type !== \"checkbox\"))))))) {\n                    return a.handleObj.handler.apply(this, arguments);\n                }\n            ;\n            ;\n            },\n            teardown: function() {\n                q.JSBNG__event.remove(this, \"._change\");\n                return !W.test(this.nodeName);\n            }\n        })));\n        ((q.support.focusinBubbles || q.each({\n            JSBNG__focus: \"focusin\",\n            JSBNG__blur: \"focusout\"\n        }, function(a, b) {\n            var c = 0, d = function(a) {\n                q.JSBNG__event.simulate(b, a.target, q.JSBNG__event.fix(a), !0);\n            };\n            q.JSBNG__event.special[b] = {\n                setup: function() {\n                    ((((c++ === 0)) && e.JSBNG__addEventListener(a, d, !0)));\n                },\n                teardown: function() {\n                    ((((--c === 0)) && e.JSBNG__removeEventListener(a, d, !0)));\n                }\n            };\n        })));\n        q.fn.extend({\n            JSBNG__on: function(a, c, d, e, f) {\n                var g, i;\n                if (((typeof a == \"object\"))) {\n                    if (((typeof c != \"string\"))) {\n                        d = ((d || c));\n                        c = b;\n                    }\n                ;\n                ;\n                    {\n                        var fin24keys = ((window.top.JSBNG_Replay.forInKeys)((a))), fin24i = (0);\n                        (0);\n                        for (; (fin24i < fin24keys.length); (fin24i++)) {\n                            ((i) = (fin24keys[fin24i]));\n                            {\n                                this.JSBNG__on(i, c, d, a[i], f);\n                            ;\n                            };\n                        };\n                    };\n                ;\n                    return this;\n                }\n            ;\n            ;\n                if (((((d == null)) && ((e == null))))) {\n                    e = c;\n                    d = c = b;\n                }\n                 else if (((e == null))) {\n                    if (((typeof c == \"string\"))) {\n                        e = d;\n                        d = b;\n                    }\n                     else {\n                        e = d;\n                        d = c;\n                        c = b;\n                    }\n                ;\n                }\n                \n            ;\n            ;\n                if (((e === !1))) {\n                    e = db;\n                }\n                 else {\n                    if (!e) {\n                        return this;\n                    }\n                ;\n                }\n            ;\n            ;\n                if (((f === 1))) {\n                    g = e;\n                    e = function(a) {\n                        q().off(a);\n                        return g.apply(this, arguments);\n                    };\n                    e.guid = ((g.guid || (g.guid = q.guid++)));\n                }\n            ;\n            ;\n                return this.each(function() {\n                    q.JSBNG__event.add(this, a, e, d, c);\n                });\n            },\n            one: function(a, b, c, d) {\n                return this.JSBNG__on(a, b, c, d, 1);\n            },\n            off: function(a, c, d) {\n                var e, f;\n                if (((((a && a.preventDefault)) && a.handleObj))) {\n                    e = a.handleObj;\n                    q(a.delegateTarget).off(((e.namespace ? ((((e.origType + \".\")) + e.namespace)) : e.origType)), e.selector, e.handler);\n                    return this;\n                }\n            ;\n            ;\n                if (((typeof a == \"object\"))) {\n                    {\n                        var fin25keys = ((window.top.JSBNG_Replay.forInKeys)((a))), fin25i = (0);\n                        (0);\n                        for (; (fin25i < fin25keys.length); (fin25i++)) {\n                            ((f) = (fin25keys[fin25i]));\n                            {\n                                this.off(f, c, a[f]);\n                            ;\n                            };\n                        };\n                    };\n                ;\n                    return this;\n                }\n            ;\n            ;\n                if (((((c === !1)) || ((typeof c == \"function\"))))) {\n                    d = c;\n                    c = b;\n                }\n            ;\n            ;\n                ((((d === !1)) && (d = db)));\n                return this.each(function() {\n                    q.JSBNG__event.remove(this, a, d, c);\n                });\n            },\n            bind: function(a, b, c) {\n                return this.JSBNG__on(a, null, b, c);\n            },\n            unbind: function(a, b) {\n                return this.off(a, null, b);\n            },\n            live: function(a, b, c) {\n                q(this.context).JSBNG__on(a, this.selector, b, c);\n                return this;\n            },\n            die: function(a, b) {\n                q(this.context).off(a, ((this.selector || \"**\")), b);\n                return this;\n            },\n            delegate: function(a, b, c, d) {\n                return this.JSBNG__on(b, a, c, d);\n            },\n            undelegate: function(a, b, c) {\n                return ((((arguments.length === 1)) ? this.off(a, \"**\") : this.off(b, ((a || \"**\")), c)));\n            },\n            trigger: function(a, b) {\n                return this.each(function() {\n                    q.JSBNG__event.trigger(a, b, this);\n                });\n            },\n            triggerHandler: function(a, b) {\n                if (this[0]) {\n                    return q.JSBNG__event.trigger(a, b, this[0], !0);\n                }\n            ;\n            ;\n            },\n            toggle: function(a) {\n                var b = arguments, c = ((a.guid || q.guid++)), d = 0, e = function(c) {\n                    var e = ((((q._data(this, ((\"lastToggle\" + a.guid))) || 0)) % d));\n                    q._data(this, ((\"lastToggle\" + a.guid)), ((e + 1)));\n                    c.preventDefault();\n                    return ((b[e].apply(this, arguments) || !1));\n                };\n                e.guid = c;\n                while (((d < b.length))) {\n                    b[d++].guid = c;\n                ;\n                };\n            ;\n                return this.click(e);\n            },\n            hover: function(a, b) {\n                return this.mouseenter(a).mouseleave(((b || a)));\n            }\n        });\n        q.each(\"blur focus focusin focusout load resize scroll unload click dblclick mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave change select submit keydown keypress keyup error contextmenu\".split(\" \"), function(a, b) {\n            q.fn[b] = function(a, c) {\n                if (((c == null))) {\n                    c = a;\n                    a = null;\n                }\n            ;\n            ;\n                return ((((arguments.length > 0)) ? this.JSBNG__on(b, null, a, c) : this.trigger(b)));\n            };\n            ((Z.test(b) && (q.JSBNG__event.fixHooks[b] = q.JSBNG__event.keyHooks)));\n            ((ab.test(b) && (q.JSBNG__event.fixHooks[b] = q.JSBNG__event.mouseHooks)));\n        });\n        (function(a, b) {\n            function fb(a, b, c, d) {\n                c = ((c || []));\n                b = ((b || s));\n                var e, f, j, k, l = b.nodeType;\n                if (((!a || ((typeof a != \"string\"))))) {\n                    return c;\n                }\n            ;\n            ;\n                if (((((l !== 1)) && ((l !== 9))))) {\n                    return [];\n                }\n            ;\n            ;\n                j = g(b);\n                if (((!j && !d))) {\n                    if (e = Q.exec(a)) {\n                        if (k = e[1]) {\n                            if (((l === 9))) {\n                                f = b.getElementById(k);\n                                if (((!f || !f.parentNode))) {\n                                    return c;\n                                }\n                            ;\n                            ;\n                                if (((f.id === k))) {\n                                    c.push(f);\n                                    return c;\n                                }\n                            ;\n                            ;\n                            }\n                             else if (((((((b.ownerDocument && (f = b.ownerDocument.getElementById(k)))) && i(b, f))) && ((f.id === k))))) {\n                                c.push(f);\n                                return c;\n                            }\n                            \n                        ;\n                        ;\n                        }\n                         else {\n                            if (e[2]) {\n                                x.apply(c, y.call(b.getElementsByTagName(a), 0));\n                                return c;\n                            }\n                        ;\n                        ;\n                            if ((((((k = e[3]) && cb)) && b.getElementsByClassName))) {\n                                x.apply(c, y.call(b.getElementsByClassName(k), 0));\n                                return c;\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    }\n                ;\n                }\n            ;\n            ;\n                return sb(a.replace(M, \"$1\"), b, c, d, j);\n            };\n        ;\n            function gb(a) {\n                return function(b) {\n                    var c = b.nodeName.toLowerCase();\n                    return ((((c === \"input\")) && ((b.type === a))));\n                };\n            };\n        ;\n            function hb(a) {\n                return function(b) {\n                    var c = b.nodeName.toLowerCase();\n                    return ((((((c === \"input\")) || ((c === \"button\")))) && ((b.type === a))));\n                };\n            };\n        ;\n            function ib(a) {\n                return A(function(b) {\n                    b = +b;\n                    return A(function(c, d) {\n                        var e, f = a([], c.length, b), g = f.length;\n                        while (g--) {\n                            ((c[e = f[g]] && (c[e] = !(d[e] = c[e]))));\n                        ;\n                        };\n                    ;\n                    });\n                });\n            };\n        ;\n            function jb(a, b, c) {\n                if (((a === b))) {\n                    return c;\n                }\n            ;\n            ;\n                var d = a.nextSibling;\n                while (d) {\n                    if (((d === b))) {\n                        return -1;\n                    }\n                ;\n                ;\n                    d = d.nextSibling;\n                };\n            ;\n                return 1;\n            };\n        ;\n            function kb(a, b) {\n                var c, d, f, g, i, j, k, l = D[p][((a + \" \"))];\n                if (l) {\n                    return ((b ? 0 : l.slice(0)));\n                }\n            ;\n            ;\n                i = a;\n                j = [];\n                k = e.preFilter;\n                while (i) {\n                    if (((!c || (d = N.exec(i))))) {\n                        ((d && (i = ((i.slice(d[0].length) || i)))));\n                        j.push(f = []);\n                    }\n                ;\n                ;\n                    c = !1;\n                    if (d = O.exec(i)) {\n                        f.push(c = new r(d.shift()));\n                        i = i.slice(c.length);\n                        c.type = d[0].replace(M, \" \");\n                    }\n                ;\n                ;\n                    {\n                        var fin26keys = ((window.top.JSBNG_Replay.forInKeys)((e.filter))), fin26i = (0);\n                        (0);\n                        for (; (fin26i < fin26keys.length); (fin26i++)) {\n                            ((g) = (fin26keys[fin26i]));\n                            {\n                                if ((((d = X[g].exec(i)) && ((!k[g] || (d = k[g](d))))))) {\n                                    f.push(c = new r(d.shift()));\n                                    i = i.slice(c.length);\n                                    c.type = g;\n                                    c.matches = d;\n                                }\n                            ;\n                            ;\n                            };\n                        };\n                    };\n                ;\n                    if (!c) {\n                        break;\n                    }\n                ;\n                ;\n                };\n            ;\n                return ((b ? i.length : ((i ? fb.error(a) : D(a, j).slice(0)))));\n            };\n        ;\n            function lb(a, b, d) {\n                var e = b.dir, f = ((d && ((b.dir === \"parentNode\")))), g = v++;\n                return ((b.first ? function(b, c, d) {\n                    while (b = b[e]) {\n                        if (((f || ((b.nodeType === 1))))) {\n                            return a(b, c, d);\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                } : function(b, d, i) {\n                    if (!i) {\n                        var j, k = ((((((u + \" \")) + g)) + \" \")), l = ((k + c));\n                        while (b = b[e]) {\n                            if (((f || ((b.nodeType === 1))))) {\n                                if ((((j = b[p]) === l))) {\n                                    return b.sizset;\n                                }\n                            ;\n                            ;\n                                if (((((typeof j == \"string\")) && ((j.indexOf(k) === 0))))) {\n                                    if (b.sizset) {\n                                        return b;\n                                    }\n                                ;\n                                ;\n                                }\n                                 else {\n                                    b[p] = l;\n                                    if (a(b, d, i)) {\n                                        b.sizset = !0;\n                                        return b;\n                                    }\n                                ;\n                                ;\n                                    b.sizset = !1;\n                                }\n                            ;\n                            ;\n                            }\n                        ;\n                        ;\n                        };\n                    ;\n                    }\n                     else while (b = b[e]) {\n                        if (((f || ((b.nodeType === 1))))) {\n                            if (a(b, d, i)) {\n                                return b;\n                            }\n                        ;\n                        }\n                    ;\n                    ;\n                    }\n                ;\n                ;\n                }));\n            };\n        ;\n            function mb(a) {\n                return ((((a.length > 1)) ? function(b, c, d) {\n                    var e = a.length;\n                    while (e--) {\n                        if (!a[e](b, c, d)) {\n                            return !1;\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    return !0;\n                } : a[0]));\n            };\n        ;\n            function nb(a, b, c, d, e) {\n                var f, g = [], i = 0, j = a.length, k = ((b != null));\n                for (; ((i < j)); i++) {\n                    if (f = a[i]) {\n                        if (((!c || c(f, d, e)))) {\n                            g.push(f);\n                            ((k && b.push(i)));\n                        }\n                    ;\n                    }\n                ;\n                ;\n                };\n            ;\n                return g;\n            };\n        ;\n            function ob(a, b, c, d, e, f) {\n                ((((d && !d[p])) && (d = ob(d))));\n                ((((e && !e[p])) && (e = ob(e, f))));\n                return A(function(f, g, i, j) {\n                    var k, l, m, n = [], o = [], p = g.length, q = ((f || rb(((b || \"*\")), ((i.nodeType ? [i,] : i)), []))), r = ((((a && ((f || !b)))) ? nb(q, n, a, i, j) : q)), s = ((c ? ((((e || ((f ? a : ((p || d)))))) ? [] : g)) : r));\n                    ((c && c(r, s, i, j)));\n                    if (d) {\n                        k = nb(s, o);\n                        d(k, [], i, j);\n                        l = k.length;\n                        while (l--) {\n                            if (m = k[l]) {\n                                s[o[l]] = !(r[o[l]] = m);\n                            }\n                        ;\n                        ;\n                        };\n                    ;\n                    }\n                ;\n                ;\n                    if (f) {\n                        if (((e || a))) {\n                            if (e) {\n                                k = [];\n                                l = s.length;\n                                while (l--) {\n                                    (((m = s[l]) && k.push(r[l] = m)));\n                                ;\n                                };\n                            ;\n                                e(null, s = [], k, j);\n                            }\n                        ;\n                        ;\n                            l = s.length;\n                            while (l--) {\n                                (((((m = s[l]) && (((k = ((e ? z.call(f, m) : n[l]))) > -1)))) && (f[k] = !(g[k] = m))));\n                            ;\n                            };\n                        ;\n                        }\n                    ;\n                    ;\n                    }\n                     else {\n                        s = nb(((((s === g)) ? s.splice(p, s.length) : s)));\n                        ((e ? e(null, g, s, j) : x.apply(g, s)));\n                    }\n                ;\n                ;\n                });\n            };\n        ;\n            function pb(a) {\n                var b, c, d, f = a.length, g = e.relative[a[0].type], i = ((g || e.relative[\" \"])), j = ((g ? 1 : 0)), k = lb(function(a) {\n                    return ((a === b));\n                }, i, !0), l = lb(function(a) {\n                    return ((z.call(b, a) > -1));\n                }, i, !0), n = [function(a, c, d) {\n                    return ((((!g && ((d || ((c !== m)))))) || (((b = c).nodeType ? k(a, c, d) : l(a, c, d)))));\n                },];\n                for (; ((j < f)); j++) {\n                    if (c = e.relative[a[j].type]) n = [lb(mb(n), c),];\n                     else {\n                        c = e.filter[a[j].type].apply(null, a[j].matches);\n                        if (c[p]) {\n                            d = ++j;\n                            for (; ((d < f)); d++) {\n                                if (e.relative[a[d].type]) {\n                                    break;\n                                }\n                            ;\n                            ;\n                            };\n                        ;\n                            return ob(((((j > 1)) && mb(n))), ((((j > 1)) && a.slice(0, ((j - 1))).join(\"\").replace(M, \"$1\"))), c, ((((j < d)) && pb(a.slice(j, d)))), ((((d < f)) && pb(a = a.slice(d)))), ((((d < f)) && a.join(\"\"))));\n                        }\n                    ;\n                    ;\n                        n.push(c);\n                    }\n                ;\n                ;\n                };\n            ;\n                return mb(n);\n            };\n        ;\n            function qb(a, b) {\n                var d = ((b.length > 0)), f = ((a.length > 0)), g = function(i, j, k, l, n) {\n                    var o, p, q, r = [], t = 0, v = \"0\", y = ((i && [])), z = ((n != null)), A = m, B = ((i || ((f && e.JSBNG__find.TAG(\"*\", ((((n && j.parentNode)) || j))))))), C = u += ((((A == null)) ? 1 : Math.E));\n                    if (z) {\n                        m = ((((j !== s)) && j));\n                        c = g.el;\n                    }\n                ;\n                ;\n                    for (; (((o = B[v]) != null)); v++) {\n                        if (((f && o))) {\n                            for (p = 0; q = a[p]; p++) {\n                                if (q(o, j, k)) {\n                                    l.push(o);\n                                    break;\n                                }\n                            ;\n                            ;\n                            };\n                        ;\n                            if (z) {\n                                u = C;\n                                c = ++g.el;\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                        if (d) {\n                            (((o = ((!q && o))) && t--));\n                            ((i && y.push(o)));\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    t += v;\n                    if (((d && ((v !== t))))) {\n                        for (p = 0; q = b[p]; p++) {\n                            q(y, r, j, k);\n                        ;\n                        };\n                    ;\n                        if (i) {\n                            if (((t > 0))) {\n                                while (v--) {\n                                    ((((!y[v] && !r[v])) && (r[v] = w.call(l))));\n                                ;\n                                };\n                            }\n                        ;\n                        ;\n                            r = nb(r);\n                        }\n                    ;\n                    ;\n                        x.apply(l, r);\n                        ((((((((z && !i)) && ((r.length > 0)))) && ((((t + b.length)) > 1)))) && fb.uniqueSort(l)));\n                    }\n                ;\n                ;\n                    if (z) {\n                        u = C;\n                        m = A;\n                    }\n                ;\n                ;\n                    return y;\n                };\n                g.el = 0;\n                return ((d ? A(g) : g));\n            };\n        ;\n            function rb(a, b, c) {\n                var d = 0, e = b.length;\n                for (; ((d < e)); d++) {\n                    fb(a, b[d], c);\n                ;\n                };\n            ;\n                return c;\n            };\n        ;\n            function sb(a, b, c, d, f) {\n                var g, i, k, l, m, n = kb(a), o = n.length;\n                if (((!d && ((n.length === 1))))) {\n                    i = n[0] = n[0].slice(0);\n                    if (((((((((((i.length > 2)) && (((k = i[0]).type === \"ID\")))) && ((b.nodeType === 9)))) && !f)) && e.relative[i[1].type]))) {\n                        b = e.JSBNG__find.ID(k.matches[0].replace(W, \"\"), b, f)[0];\n                        if (!b) {\n                            return c;\n                        }\n                    ;\n                    ;\n                        a = a.slice(i.shift().length);\n                    }\n                ;\n                ;\n                    for (g = ((X.POS.test(a) ? -1 : ((i.length - 1)))); ((g >= 0)); g--) {\n                        k = i[g];\n                        if (e.relative[l = k.type]) {\n                            break;\n                        }\n                    ;\n                    ;\n                        if (m = e.JSBNG__find[l]) {\n                            if (d = m(k.matches[0].replace(W, \"\"), ((((S.test(i[0].type) && b.parentNode)) || b)), f)) {\n                                i.splice(g, 1);\n                                a = ((d.length && i.join(\"\")));\n                                if (!a) {\n                                    x.apply(c, y.call(d, 0));\n                                    return c;\n                                }\n                            ;\n                            ;\n                                break;\n                            }\n                        ;\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                }\n            ;\n            ;\n                j(a, n)(d, b, f, c, S.test(a));\n                return c;\n            };\n        ;\n            function tb() {\n            \n            };\n        ;\n            var c, d, e, f, g, i, j, k, l, m, n = !0, o = \"undefined\", p = ((\"sizcache\" + Math.JSBNG__random())).replace(\".\", \"\"), r = String, s = a.JSBNG__document, t = s.documentElement, u = 0, v = 0, w = [].pop, x = [].push, y = [].slice, z = (([].indexOf || function(a) {\n                var b = 0, c = this.length;\n                for (; ((b < c)); b++) {\n                    if (((this[b] === a))) {\n                        return b;\n                    }\n                ;\n                ;\n                };\n            ;\n                return -1;\n            })), A = function(a, b) {\n                a[p] = ((((b == null)) || b));\n                return a;\n            }, B = function() {\n                var a = {\n                }, b = [];\n                return A(function(c, d) {\n                    ((((b.push(c) > e.cacheLength)) && delete a[b.shift()]));\n                    return a[((c + \" \"))] = d;\n                }, a);\n            }, C = B(), D = B(), E = B(), F = \"[\\\\x20\\\\t\\\\r\\\\n\\\\f]\", G = \"(?:\\\\\\\\.|[-\\\\w]|[^\\\\x00-\\\\xa0])+\", H = G.replace(\"w\", \"w#\"), I = \"([*^$|!~]?=)\", J = ((((((((((((((((((((((((((\"\\\\[\" + F)) + \"*(\")) + G)) + \")\")) + F)) + \"*(?:\")) + I)) + F)) + \"*(?:(['\\\"])((?:\\\\\\\\.|[^\\\\\\\\])*?)\\\\3|(\")) + H)) + \")|)|)\")) + F)) + \"*\\\\]\")), K = ((((((((\":(\" + G)) + \")(?:\\\\((?:(['\\\"])((?:\\\\\\\\.|[^\\\\\\\\])*?)\\\\2|([^()[\\\\]]*|(?:(?:\")) + J)) + \")|[^:]|\\\\\\\\.)*|.*))\\\\)|)\")), L = ((((((((\":(even|odd|eq|gt|lt|nth|first|last)(?:\\\\(\" + F)) + \"*((?:-\\\\d)?\\\\d*)\")) + F)) + \"*\\\\)|)(?=[^-]|$)\")), M = new RegExp(((((((((\"^\" + F)) + \"+|((?:^|[^\\\\\\\\])(?:\\\\\\\\.)*)\")) + F)) + \"+$\")), \"g\"), N = new RegExp(((((((((\"^\" + F)) + \"*,\")) + F)) + \"*\"))), O = new RegExp(((((((((\"^\" + F)) + \"*([\\\\x20\\\\t\\\\r\\\\n\\\\f\\u003E+~])\")) + F)) + \"*\"))), P = new RegExp(K), Q = /^(?:#([\\w\\-]+)|(\\w+)|\\.([\\w\\-]+))$/, R = /^:not/, S = /[\\x20\\t\\r\\n\\f]*[+~]/, T = /:not\\($/, U = /h\\d/i, V = /input|select|textarea|button/i, W = /\\\\(?!\\\\)/g, X = {\n                ID: new RegExp(((((\"^#(\" + G)) + \")\"))),\n                CLASS: new RegExp(((((\"^\\\\.(\" + G)) + \")\"))),\n                NAME: new RegExp(((((\"^\\\\[name=['\\\"]?(\" + G)) + \")['\\\"]?\\\\]\"))),\n                TAG: new RegExp(((((\"^(\" + G.replace(\"w\", \"w*\"))) + \")\"))),\n                ATTR: new RegExp(((\"^\" + J))),\n                PSEUDO: new RegExp(((\"^\" + K))),\n                POS: new RegExp(L, \"i\"),\n                CHILD: new RegExp(((((((((((((((((\"^:(only|nth|first|last)-child(?:\\\\(\" + F)) + \"*(even|odd|(([+-]|)(\\\\d*)n|)\")) + F)) + \"*(?:([+-]|)\")) + F)) + \"*(\\\\d+)|))\")) + F)) + \"*\\\\)|)\")), \"i\"),\n                needsContext: new RegExp(((((((\"^\" + F)) + \"*[\\u003E+~]|\")) + L)), \"i\")\n            }, Y = function(a) {\n                var b = s.createElement(\"div\");\n                try {\n                    return a(b);\n                } catch (c) {\n                    return !1;\n                } finally {\n                    b = null;\n                };\n            ;\n            }, Z = Y(function(a) {\n                a.appendChild(s.createComment(\"\"));\n                return !a.getElementsByTagName(\"*\").length;\n            }), ab = Y(function(a) {\n                a.innerHTML = \"\\u003Ca href='#'\\u003E\\u003C/a\\u003E\";\n                return ((((a.firstChild && ((typeof a.firstChild.getAttribute !== o)))) && ((a.firstChild.getAttribute(\"href\") === \"#\"))));\n            }), bb = Y(function(a) {\n                a.innerHTML = \"\\u003Cselect\\u003E\\u003C/select\\u003E\";\n                var b = typeof a.lastChild.getAttribute(\"multiple\");\n                return ((((b !== \"boolean\")) && ((b !== \"string\"))));\n            }), cb = Y(function(a) {\n                a.innerHTML = \"\\u003Cdiv class='hidden e'\\u003E\\u003C/div\\u003E\\u003Cdiv class='hidden'\\u003E\\u003C/div\\u003E\";\n                if (((!a.getElementsByClassName || !a.getElementsByClassName(\"e\").length))) {\n                    return !1;\n                }\n            ;\n            ;\n                a.lastChild.className = \"e\";\n                return ((a.getElementsByClassName(\"e\").length === 2));\n            }), db = Y(function(a) {\n                a.id = ((p + 0));\n                a.innerHTML = ((((((((\"\\u003Ca name='\" + p)) + \"'\\u003E\\u003C/a\\u003E\\u003Cdiv name='\")) + p)) + \"'\\u003E\\u003C/div\\u003E\"));\n                t.insertBefore(a, t.firstChild);\n                var b = ((s.getElementsByName && ((s.getElementsByName(p).length === ((2 + s.getElementsByName(((p + 0))).length))))));\n                d = !s.getElementById(p);\n                t.removeChild(a);\n                return b;\n            });\n            try {\n                y.call(t.childNodes, 0)[0].nodeType;\n            } catch (eb) {\n                y = function(a) {\n                    var b, c = [];\n                    for (; b = this[a]; a++) {\n                        c.push(b);\n                    ;\n                    };\n                ;\n                    return c;\n                };\n            };\n        ;\n            fb.matches = function(a, b) {\n                return fb(a, null, null, b);\n            };\n            fb.matchesSelector = function(a, b) {\n                return ((fb(b, null, null, [a,]).length > 0));\n            };\n            f = fb.getText = function(a) {\n                var b, c = \"\", d = 0, e = a.nodeType;\n                if (e) {\n                    if (((((((e === 1)) || ((e === 9)))) || ((e === 11))))) {\n                        if (((typeof a.textContent == \"string\"))) {\n                            return a.textContent;\n                        }\n                    ;\n                    ;\n                        for (a = a.firstChild; a; a = a.nextSibling) {\n                            c += f(a);\n                        ;\n                        };\n                    ;\n                    }\n                     else if (((((e === 3)) || ((e === 4))))) {\n                        return a.nodeValue;\n                    }\n                    \n                ;\n                ;\n                }\n                 else for (; b = a[d]; d++) {\n                    c += f(b);\n                ;\n                }\n            ;\n            ;\n                return c;\n            };\n            g = fb.isXML = function(a) {\n                var b = ((a && ((a.ownerDocument || a)).documentElement));\n                return ((b ? ((b.nodeName !== \"HTML\")) : !1));\n            };\n            i = fb.contains = ((t.contains ? function(a, b) {\n                var c = ((((a.nodeType === 9)) ? a.documentElement : a)), d = ((b && b.parentNode));\n                return ((((a === d)) || !!((((((d && ((d.nodeType === 1)))) && c.contains)) && c.contains(d)))));\n            } : ((t.compareDocumentPosition ? function(a, b) {\n                return ((b && !!((a.compareDocumentPosition(b) & 16))));\n            } : function(a, b) {\n                while (b = b.parentNode) {\n                    if (((b === a))) {\n                        return !0;\n                    }\n                ;\n                ;\n                };\n            ;\n                return !1;\n            }))));\n            fb.attr = function(a, b) {\n                var c, d = g(a);\n                ((d || (b = b.toLowerCase())));\n                if (c = e.attrHandle[b]) {\n                    return c(a);\n                }\n            ;\n            ;\n                if (((d || bb))) {\n                    return a.getAttribute(b);\n                }\n            ;\n            ;\n                c = a.getAttributeNode(b);\n                return ((c ? ((((typeof a[b] == \"boolean\")) ? ((a[b] ? b : null)) : ((c.specified ? c.value : null)))) : null));\n            };\n            e = fb.selectors = {\n                cacheLength: 50,\n                createPseudo: A,\n                match: X,\n                attrHandle: ((ab ? {\n                } : {\n                    href: function(a) {\n                        return a.getAttribute(\"href\", 2);\n                    },\n                    type: function(a) {\n                        return a.getAttribute(\"type\");\n                    }\n                })),\n                JSBNG__find: {\n                    ID: ((d ? function(a, b, c) {\n                        if (((((typeof b.getElementById !== o)) && !c))) {\n                            var d = b.getElementById(a);\n                            return ((((d && d.parentNode)) ? [d,] : []));\n                        }\n                    ;\n                    ;\n                    } : function(a, c, d) {\n                        if (((((typeof c.getElementById !== o)) && !d))) {\n                            var e = c.getElementById(a);\n                            return ((e ? ((((((e.id === a)) || ((((typeof e.getAttributeNode !== o)) && ((e.getAttributeNode(\"id\").value === a)))))) ? [e,] : b)) : []));\n                        }\n                    ;\n                    ;\n                    })),\n                    TAG: ((Z ? function(a, b) {\n                        if (((typeof b.getElementsByTagName !== o))) {\n                            return b.getElementsByTagName(a);\n                        }\n                    ;\n                    ;\n                    } : function(a, b) {\n                        var c = b.getElementsByTagName(a);\n                        if (((a === \"*\"))) {\n                            var d, e = [], f = 0;\n                            for (; d = c[f]; f++) {\n                                ((((d.nodeType === 1)) && e.push(d)));\n                            ;\n                            };\n                        ;\n                            return e;\n                        }\n                    ;\n                    ;\n                        return c;\n                    })),\n                    NAME: ((db && function(a, b) {\n                        if (((typeof b.getElementsByName !== o))) {\n                            return b.getElementsByName(JSBNG__name);\n                        }\n                    ;\n                    ;\n                    })),\n                    CLASS: ((cb && function(a, b, c) {\n                        if (((((typeof b.getElementsByClassName !== o)) && !c))) {\n                            return b.getElementsByClassName(a);\n                        }\n                    ;\n                    ;\n                    }))\n                },\n                relative: {\n                    \"\\u003E\": {\n                        dir: \"parentNode\",\n                        first: !0\n                    },\n                    \" \": {\n                        dir: \"parentNode\"\n                    },\n                    \"+\": {\n                        dir: \"previousSibling\",\n                        first: !0\n                    },\n                    \"~\": {\n                        dir: \"previousSibling\"\n                    }\n                },\n                preFilter: {\n                    ATTR: function(a) {\n                        a[1] = a[1].replace(W, \"\");\n                        a[3] = ((((a[4] || a[5])) || \"\")).replace(W, \"\");\n                        ((((a[2] === \"~=\")) && (a[3] = ((((\" \" + a[3])) + \" \")))));\n                        return a.slice(0, 4);\n                    },\n                    CHILD: function(a) {\n                        a[1] = a[1].toLowerCase();\n                        if (((a[1] === \"nth\"))) {\n                            ((a[2] || fb.error(a[0])));\n                            a[3] = +((a[3] ? ((a[4] + ((a[5] || 1)))) : ((2 * ((((a[2] === \"even\")) || ((a[2] === \"odd\"))))))));\n                            a[4] = +((((a[6] + a[7])) || ((a[2] === \"odd\"))));\n                        }\n                         else ((a[2] && fb.error(a[0])));\n                    ;\n                    ;\n                        return a;\n                    },\n                    PSEUDO: function(a) {\n                        var b, c;\n                        if (X.CHILD.test(a[0])) {\n                            return null;\n                        }\n                    ;\n                    ;\n                        if (a[3]) {\n                            a[2] = a[3];\n                        }\n                         else {\n                            if (b = a[4]) {\n                                if (((((P.test(b) && (c = kb(b, !0)))) && (c = ((b.indexOf(\")\", ((b.length - c))) - b.length)))))) {\n                                    b = b.slice(0, c);\n                                    a[0] = a[0].slice(0, c);\n                                }\n                            ;\n                            ;\n                                a[2] = b;\n                            }\n                        ;\n                        }\n                    ;\n                    ;\n                        return a.slice(0, 3);\n                    }\n                },\n                filter: {\n                    ID: ((d ? function(a) {\n                        a = a.replace(W, \"\");\n                        return function(b) {\n                            return ((b.getAttribute(\"id\") === a));\n                        };\n                    } : function(a) {\n                        a = a.replace(W, \"\");\n                        return function(b) {\n                            var c = ((((typeof b.getAttributeNode !== o)) && b.getAttributeNode(\"id\")));\n                            return ((c && ((c.value === a))));\n                        };\n                    })),\n                    TAG: function(a) {\n                        if (((a === \"*\"))) {\n                            return function() {\n                                return !0;\n                            };\n                        }\n                    ;\n                    ;\n                        a = a.replace(W, \"\").toLowerCase();\n                        return function(b) {\n                            return ((b.nodeName && ((b.nodeName.toLowerCase() === a))));\n                        };\n                    },\n                    CLASS: function(a) {\n                        var b = C[p][((a + \" \"))];\n                        return ((b || (((b = new RegExp(((((((((((((\"(^|\" + F)) + \")\")) + a)) + \"(\")) + F)) + \"|$)\")))) && C(a, function(a) {\n                            return b.test(((((a.className || ((((typeof a.getAttribute !== o)) && a.getAttribute(\"class\"))))) || \"\")));\n                        })))));\n                    },\n                    ATTR: function(a, b, c) {\n                        return function(d, e) {\n                            var f = fb.attr(d, a);\n                            if (((f == null))) {\n                                return ((b === \"!=\"));\n                            }\n                        ;\n                        ;\n                            if (!b) {\n                                return !0;\n                            }\n                        ;\n                        ;\n                            f += \"\";\n                            return ((((b === \"=\")) ? ((f === c)) : ((((b === \"!=\")) ? ((f !== c)) : ((((b === \"^=\")) ? ((c && ((f.indexOf(c) === 0)))) : ((((b === \"*=\")) ? ((c && ((f.indexOf(c) > -1)))) : ((((b === \"$=\")) ? ((c && ((f.substr(((f.length - c.length))) === c)))) : ((((b === \"~=\")) ? ((((((\" \" + f)) + \" \")).indexOf(c) > -1)) : ((((b === \"|=\")) ? ((((f === c)) || ((f.substr(0, ((c.length + 1))) === ((c + \"-\")))))) : !1))))))))))))));\n                        };\n                    },\n                    CHILD: function(a, b, c, d) {\n                        return ((((a === \"nth\")) ? function(a) {\n                            var b, e, f = a.parentNode;\n                            if (((((c === 1)) && ((d === 0))))) {\n                                return !0;\n                            }\n                        ;\n                        ;\n                            if (f) {\n                                e = 0;\n                                for (b = f.firstChild; b; b = b.nextSibling) {\n                                    if (((b.nodeType === 1))) {\n                                        e++;\n                                        if (((a === b))) {\n                                            break;\n                                        }\n                                    ;\n                                    ;\n                                    }\n                                ;\n                                ;\n                                };\n                            ;\n                            }\n                        ;\n                        ;\n                            e -= d;\n                            return ((((e === c)) || ((((((e % c)) === 0)) && ((((e / c)) >= 0))))));\n                        } : function(b) {\n                            var c = b;\n                            switch (a) {\n                              case \"only\":\n                            \n                              case \"first\":\n                                while (c = c.previousSibling) {\n                                    if (((c.nodeType === 1))) {\n                                        return !1;\n                                    }\n                                ;\n                                ;\n                                };\n                            ;\n                                if (((a === \"first\"))) {\n                                    return !0;\n                                }\n                            ;\n                            ;\n                                c = b;\n                              case \"last\":\n                                while (c = c.nextSibling) {\n                                    if (((c.nodeType === 1))) {\n                                        return !1;\n                                    }\n                                ;\n                                ;\n                                };\n                            ;\n                                return !0;\n                            };\n                        ;\n                        }));\n                    },\n                    PSEUDO: function(a, b) {\n                        var c, d = ((((e.pseudos[a] || e.setFilters[a.toLowerCase()])) || fb.error(((\"unsupported pseudo: \" + a)))));\n                        if (d[p]) {\n                            return d(b);\n                        }\n                    ;\n                    ;\n                        if (((d.length > 1))) {\n                            c = [a,a,\"\",b,];\n                            return ((e.setFilters.hasOwnProperty(a.toLowerCase()) ? A(function(a, c) {\n                                var e, f = d(a, b), g = f.length;\n                                while (g--) {\n                                    e = z.call(a, f[g]);\n                                    a[e] = !(c[e] = f[g]);\n                                };\n                            ;\n                            }) : function(a) {\n                                return d(a, 0, c);\n                            }));\n                        }\n                    ;\n                    ;\n                        return d;\n                    }\n                },\n                pseudos: {\n                    not: A(function(a) {\n                        var b = [], c = [], d = j(a.replace(M, \"$1\"));\n                        return ((d[p] ? A(function(a, b, c, e) {\n                            var f, g = d(a, null, e, []), i = a.length;\n                            while (i--) {\n                                if (f = g[i]) {\n                                    a[i] = !(b[i] = f);\n                                }\n                            ;\n                            ;\n                            };\n                        ;\n                        }) : function(a, e, f) {\n                            b[0] = a;\n                            d(b, null, f, c);\n                            return !c.pop();\n                        }));\n                    }),\n                    has: A(function(a) {\n                        return function(b) {\n                            return ((fb(a, b).length > 0));\n                        };\n                    }),\n                    contains: A(function(a) {\n                        return function(b) {\n                            return ((((((b.textContent || b.innerText)) || f(b))).indexOf(a) > -1));\n                        };\n                    }),\n                    enabled: function(a) {\n                        return ((a.disabled === !1));\n                    },\n                    disabled: function(a) {\n                        return ((a.disabled === !0));\n                    },\n                    checked: function(a) {\n                        var b = a.nodeName.toLowerCase();\n                        return ((((((b === \"input\")) && !!a.checked)) || ((((b === \"option\")) && !!a.selected))));\n                    },\n                    selected: function(a) {\n                        ((a.parentNode && a.parentNode.selectedIndex));\n                        return ((a.selected === !0));\n                    },\n                    parent: function(a) {\n                        return !e.pseudos.empty(a);\n                    },\n                    empty: function(a) {\n                        var b;\n                        a = a.firstChild;\n                        while (a) {\n                            if (((((((a.nodeName > \"@\")) || (((b = a.nodeType) === 3)))) || ((b === 4))))) {\n                                return !1;\n                            }\n                        ;\n                        ;\n                            a = a.nextSibling;\n                        };\n                    ;\n                        return !0;\n                    },\n                    header: function(a) {\n                        return U.test(a.nodeName);\n                    },\n                    text: function(a) {\n                        var b, c;\n                        return ((((((a.nodeName.toLowerCase() === \"input\")) && (((b = a.type) === \"text\")))) && (((((c = a.getAttribute(\"type\")) == null)) || ((c.toLowerCase() === b))))));\n                    },\n                    radio: gb(\"radio\"),\n                    checkbox: gb(\"checkbox\"),\n                    file: gb(\"file\"),\n                    password: gb(\"password\"),\n                    image: gb(\"image\"),\n                    submit: hb(\"submit\"),\n                    reset: hb(\"reset\"),\n                    button: function(a) {\n                        var b = a.nodeName.toLowerCase();\n                        return ((((((b === \"input\")) && ((a.type === \"button\")))) || ((b === \"button\"))));\n                    },\n                    input: function(a) {\n                        return V.test(a.nodeName);\n                    },\n                    JSBNG__focus: function(a) {\n                        var b = a.ownerDocument;\n                        return ((((((a === b.activeElement)) && ((!b.hasFocus || b.hasFocus())))) && !!((((a.type || a.href)) || ~a.tabIndex))));\n                    },\n                    active: function(a) {\n                        return ((a === a.ownerDocument.activeElement));\n                    },\n                    first: ib(function() {\n                        return [0,];\n                    }),\n                    last: ib(function(a, b) {\n                        return [((b - 1)),];\n                    }),\n                    eq: ib(function(a, b, c) {\n                        return [((((c < 0)) ? ((c + b)) : c)),];\n                    }),\n                    even: ib(function(a, b) {\n                        for (var c = 0; ((c < b)); c += 2) {\n                            a.push(c);\n                        ;\n                        };\n                    ;\n                        return a;\n                    }),\n                    odd: ib(function(a, b) {\n                        for (var c = 1; ((c < b)); c += 2) {\n                            a.push(c);\n                        ;\n                        };\n                    ;\n                        return a;\n                    }),\n                    lt: ib(function(a, b, c) {\n                        for (var d = ((((c < 0)) ? ((c + b)) : c)); ((--d >= 0)); ) {\n                            a.push(d);\n                        ;\n                        };\n                    ;\n                        return a;\n                    }),\n                    gt: ib(function(a, b, c) {\n                        for (var d = ((((c < 0)) ? ((c + b)) : c)); ((++d < b)); ) {\n                            a.push(d);\n                        ;\n                        };\n                    ;\n                        return a;\n                    })\n                }\n            };\n            k = ((t.compareDocumentPosition ? function(a, b) {\n                if (((a === b))) {\n                    l = !0;\n                    return 0;\n                }\n            ;\n            ;\n                return ((((((!a.compareDocumentPosition || !b.compareDocumentPosition)) ? a.compareDocumentPosition : ((a.compareDocumentPosition(b) & 4)))) ? -1 : 1));\n            } : function(a, b) {\n                if (((a === b))) {\n                    l = !0;\n                    return 0;\n                }\n            ;\n            ;\n                if (((a.sourceIndex && b.sourceIndex))) {\n                    return ((a.sourceIndex - b.sourceIndex));\n                }\n            ;\n            ;\n                var c, d, e = [], f = [], g = a.parentNode, i = b.parentNode, j = g;\n                if (((g === i))) {\n                    return jb(a, b);\n                }\n            ;\n            ;\n                if (!g) {\n                    return -1;\n                }\n            ;\n            ;\n                if (!i) {\n                    return 1;\n                }\n            ;\n            ;\n                while (j) {\n                    e.unshift(j);\n                    j = j.parentNode;\n                };\n            ;\n                j = i;\n                while (j) {\n                    f.unshift(j);\n                    j = j.parentNode;\n                };\n            ;\n                c = e.length;\n                d = f.length;\n                for (var k = 0; ((((k < c)) && ((k < d)))); k++) {\n                    if (((e[k] !== f[k]))) {\n                        return jb(e[k], f[k]);\n                    }\n                ;\n                ;\n                };\n            ;\n                return ((((k === c)) ? jb(a, f[k], -1) : jb(e[k], b, 1)));\n            }));\n            [0,0,].sort(k);\n            n = !l;\n            fb.uniqueSort = function(a) {\n                var b, c = [], d = 1, e = 0;\n                l = n;\n                a.sort(k);\n                if (l) {\n                    for (; b = a[d]; d++) {\n                        ((((b === a[((d - 1))])) && (e = c.push(d))));\n                    ;\n                    };\n                ;\n                    while (e--) {\n                        a.splice(c[e], 1);\n                    ;\n                    };\n                ;\n                }\n            ;\n            ;\n                return a;\n            };\n            fb.error = function(a) {\n                throw new Error(((\"Syntax error, unrecognized expression: \" + a)));\n            };\n            j = fb.compile = function(a, b) {\n                var c, d = [], e = [], f = E[p][((a + \" \"))];\n                if (!f) {\n                    ((b || (b = kb(a))));\n                    c = b.length;\n                    while (c--) {\n                        f = pb(b[c]);\n                        ((f[p] ? d.push(f) : e.push(f)));\n                    };\n                ;\n                    f = E(a, qb(e, d));\n                }\n            ;\n            ;\n                return f;\n            };\n            ((s.querySelectorAll && function() {\n                var a, b = sb, c = /'|\\\\/g, d = /\\=[\\x20\\t\\r\\n\\f]*([^'\"\\]]*)[\\x20\\t\\r\\n\\f]*\\]/g, e = [\":focus\",], f = [\":active\",], i = ((((((((t.matchesSelector || t.mozMatchesSelector)) || t.webkitMatchesSelector)) || t.oMatchesSelector)) || t.msMatchesSelector));\n                Y(function(a) {\n                    a.innerHTML = \"\\u003Cselect\\u003E\\u003Coption selected=''\\u003E\\u003C/option\\u003E\\u003C/select\\u003E\";\n                    ((a.querySelectorAll(\"[selected]\").length || e.push(((((\"\\\\[\" + F)) + \"*(?:checked|disabled|ismap|multiple|readonly|selected|value)\")))));\n                    ((a.querySelectorAll(\":checked\").length || e.push(\":checked\")));\n                });\n                Y(function(a) {\n                    a.innerHTML = \"\\u003Cp test=''\\u003E\\u003C/p\\u003E\";\n                    ((a.querySelectorAll(\"[test^='']\").length && e.push(((((\"[*^$]=\" + F)) + \"*(?:\\\"\\\"|'')\")))));\n                    a.innerHTML = \"\\u003Cinput type='hidden'/\\u003E\";\n                    ((a.querySelectorAll(\":enabled\").length || e.push(\":enabled\", \":disabled\")));\n                });\n                e = new RegExp(e.join(\"|\"));\n                sb = function(a, d, f, g, i) {\n                    if (((((!g && !i)) && !e.test(a)))) {\n                        var j, k, l = !0, m = p, n = d, o = ((((d.nodeType === 9)) && a));\n                        if (((((d.nodeType === 1)) && ((d.nodeName.toLowerCase() !== \"object\"))))) {\n                            j = kb(a);\n                            (((l = d.getAttribute(\"id\")) ? m = l.replace(c, \"\\\\$&\") : d.setAttribute(\"id\", m)));\n                            m = ((((\"[id='\" + m)) + \"'] \"));\n                            k = j.length;\n                            while (k--) {\n                                j[k] = ((m + j[k].join(\"\")));\n                            ;\n                            };\n                        ;\n                            n = ((((S.test(a) && d.parentNode)) || d));\n                            o = j.join(\",\");\n                        }\n                    ;\n                    ;\n                        if (o) {\n                            try {\n                                x.apply(f, y.call(n.querySelectorAll(o), 0));\n                                return f;\n                            } catch (q) {\n                            \n                            } finally {\n                                ((l || d.removeAttribute(\"id\")));\n                            };\n                        }\n                    ;\n                    ;\n                    }\n                ;\n                ;\n                    return b(a, d, f, g, i);\n                };\n                if (i) {\n                    Y(function(b) {\n                        a = i.call(b, \"div\");\n                        try {\n                            i.call(b, \"[test!='']:sizzle\");\n                            f.push(\"!=\", K);\n                        } catch (c) {\n                        \n                        };\n                    ;\n                    });\n                    f = new RegExp(f.join(\"|\"));\n                    fb.matchesSelector = function(b, c) {\n                        c = c.replace(d, \"='$1']\");\n                        if (((((!g(b) && !f.test(c))) && !e.test(c)))) {\n                            try {\n                                var j = i.call(b, c);\n                                if (((((j || a)) || ((b.JSBNG__document && ((b.JSBNG__document.nodeType !== 11))))))) {\n                                    return j;\n                                }\n                            ;\n                            ;\n                            } catch (k) {\n                            \n                            };\n                        }\n                    ;\n                    ;\n                        return ((fb(c, null, null, [b,]).length > 0));\n                    };\n                }\n            ;\n            ;\n            }()));\n            e.pseudos.nth = e.pseudos.eq;\n            e.filters = tb.prototype = e.pseudos;\n            e.setFilters = new tb;\n            fb.attr = q.attr;\n            q.JSBNG__find = fb;\n            q.expr = fb.selectors;\n            q.expr[\":\"] = q.expr.pseudos;\n            q.unique = fb.uniqueSort;\n            q.text = fb.getText;\n            q.isXMLDoc = fb.isXML;\n            q.contains = fb.contains;\n        })(a);\n        var fb = /Until$/, gb = /^(?:parents|prev(?:Until|All))/, hb = /^.[^:#\\[\\.,]*$/, ib = q.expr.match.needsContext, jb = {\n            children: !0,\n            contents: !0,\n            next: !0,\n            prev: !0\n        };\n        q.fn.extend({\n            JSBNG__find: function(a) {\n                var b, c, d, e, f, g, i = this;\n                if (((typeof a != \"string\"))) {\n                    return q(a).filter(function() {\n                        for (b = 0, c = i.length; ((b < c)); b++) {\n                            if (q.contains(i[b], this)) {\n                                return !0;\n                            }\n                        ;\n                        ;\n                        };\n                    ;\n                    });\n                }\n            ;\n            ;\n                g = this.pushStack(\"\", \"JSBNG__find\", a);\n                for (b = 0, c = this.length; ((b < c)); b++) {\n                    d = g.length;\n                    q.JSBNG__find(a, this[b], g);\n                    if (((b > 0))) {\n                        for (e = d; ((e < g.length)); e++) {\n                            for (f = 0; ((f < d)); f++) {\n                                if (((g[f] === g[e]))) {\n                                    g.splice(e--, 1);\n                                    break;\n                                }\n                            ;\n                            ;\n                            };\n                        ;\n                        };\n                    }\n                ;\n                ;\n                };\n            ;\n                return g;\n            },\n            has: function(a) {\n                var b, c = q(a, this), d = c.length;\n                return this.filter(function() {\n                    for (b = 0; ((b < d)); b++) {\n                        if (q.contains(this, c[b])) {\n                            return !0;\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                });\n            },\n            not: function(a) {\n                return this.pushStack(mb(this, a, !1), \"not\", a);\n            },\n            filter: function(a) {\n                return this.pushStack(mb(this, a, !0), \"filter\", a);\n            },\n            is: function(a) {\n                return ((!!a && ((((typeof a == \"string\")) ? ((ib.test(a) ? ((q(a, this.context).index(this[0]) >= 0)) : ((q.filter(a, this).length > 0)))) : ((this.filter(a).length > 0))))));\n            },\n            closest: function(a, b) {\n                var c, d = 0, e = this.length, f = [], g = ((((ib.test(a) || ((typeof a != \"string\")))) ? q(a, ((b || this.context))) : 0));\n                for (; ((d < e)); d++) {\n                    c = this[d];\n                    while (((((((c && c.ownerDocument)) && ((c !== b)))) && ((c.nodeType !== 11))))) {\n                        if (((g ? ((g.index(c) > -1)) : q.JSBNG__find.matchesSelector(c, a)))) {\n                            f.push(c);\n                            break;\n                        }\n                    ;\n                    ;\n                        c = c.parentNode;\n                    };\n                ;\n                };\n            ;\n                f = ((((f.length > 1)) ? q.unique(f) : f));\n                return this.pushStack(f, \"closest\", a);\n            },\n            index: function(a) {\n                return ((a ? ((((typeof a == \"string\")) ? q.inArray(this[0], q(a)) : q.inArray(((a.jquery ? a[0] : a)), this))) : ((((this[0] && this[0].parentNode)) ? this.prevAll().length : -1))));\n            },\n            add: function(a, b) {\n                var c = ((((typeof a == \"string\")) ? q(a, b) : q.makeArray(((((a && a.nodeType)) ? [a,] : a))))), d = q.merge(this.get(), c);\n                return this.pushStack(((((kb(c[0]) || kb(d[0]))) ? d : q.unique(d))));\n            },\n            addBack: function(a) {\n                return this.add(((((a == null)) ? this.prevObject : this.prevObject.filter(a))));\n            }\n        });\n        q.fn.andSelf = q.fn.addBack;\n        q.each({\n            parent: function(a) {\n                var b = a.parentNode;\n                return ((((b && ((b.nodeType !== 11)))) ? b : null));\n            },\n            parents: function(a) {\n                return q.dir(a, \"parentNode\");\n            },\n            parentsUntil: function(a, b, c) {\n                return q.dir(a, \"parentNode\", c);\n            },\n            next: function(a) {\n                return lb(a, \"nextSibling\");\n            },\n            prev: function(a) {\n                return lb(a, \"previousSibling\");\n            },\n            nextAll: function(a) {\n                return q.dir(a, \"nextSibling\");\n            },\n            prevAll: function(a) {\n                return q.dir(a, \"previousSibling\");\n            },\n            nextUntil: function(a, b, c) {\n                return q.dir(a, \"nextSibling\", c);\n            },\n            prevUntil: function(a, b, c) {\n                return q.dir(a, \"previousSibling\", c);\n            },\n            siblings: function(a) {\n                return q.sibling(((a.parentNode || {\n                })).firstChild, a);\n            },\n            children: function(a) {\n                return q.sibling(a.firstChild);\n            },\n            contents: function(a) {\n                return ((q.nodeName(a, \"div\") ? ((a.contentDocument || a.contentWindow.JSBNG__document)) : q.merge([], a.childNodes)));\n            }\n        }, function(a, b) {\n            q.fn[a] = function(c, d) {\n                var e = q.map(this, b, c);\n                ((fb.test(a) || (d = c)));\n                ((((d && ((typeof d == \"string\")))) && (e = q.filter(d, e))));\n                e = ((((((this.length > 1)) && !jb[a])) ? q.unique(e) : e));\n                ((((((this.length > 1)) && gb.test(a))) && (e = e.reverse())));\n                return this.pushStack(e, a, l.call(arguments).join(\",\"));\n            };\n        });\n        q.extend({\n            filter: function(a, b, c) {\n                ((c && (a = ((((\":not(\" + a)) + \")\")))));\n                return ((((b.length === 1)) ? ((q.JSBNG__find.matchesSelector(b[0], a) ? [b[0],] : [])) : q.JSBNG__find.matches(a, b)));\n            },\n            dir: function(a, c, d) {\n                var e = [], f = a[c];\n                while (((((f && ((f.nodeType !== 9)))) && ((((((d === b)) || ((f.nodeType !== 1)))) || !q(f).is(d)))))) {\n                    ((((f.nodeType === 1)) && e.push(f)));\n                    f = f[c];\n                };\n            ;\n                return e;\n            },\n            sibling: function(a, b) {\n                var c = [];\n                for (; a; a = a.nextSibling) {\n                    ((((((a.nodeType === 1)) && ((a !== b)))) && c.push(a)));\n                ;\n                };\n            ;\n                return c;\n            }\n        });\n        var ob = \"abbr|article|aside|audio|bdi|canvas|data|datalist|details|figcaption|figure|footer|header|hgroup|mark|meter|nav|output|progress|section|summary|time|video\", pb = / jQuery\\d+=\"(?:null|\\d+)\"/g, qb = /^\\s+/, rb = /<(?!area|br|col|embed|hr|img|input|link|meta|param)(([\\w:]+)[^>]*)\\/>/gi, sb = /<([\\w:]+)/, tb = /<tbody/i, ub = /<|&#?\\w+;/, vb = /<(?:script|style|link)/i, wb = /<(?:script|object|embed|option|style)/i, xb = new RegExp(((((\"\\u003C(?:\" + ob)) + \")[\\\\s/\\u003E]\")), \"i\"), yb = /^(?:checkbox|radio)$/, zb = /checked\\s*(?:[^=]|=\\s*.checked.)/i, Ab = /\\/(java|ecma)script/i, Bb = /^\\s*<!(?:\\[CDATA\\[|\\-\\-)|[\\]\\-]{2}>\\s*$/g, Cb = {\n            option: [1,\"\\u003Cselect multiple='multiple'\\u003E\",\"\\u003C/select\\u003E\",],\n            legend: [1,\"\\u003Cfieldset\\u003E\",\"\\u003C/fieldset\\u003E\",],\n            thead: [1,\"\\u003Ctable\\u003E\",\"\\u003C/table\\u003E\",],\n            tr: [2,\"\\u003Ctable\\u003E\\u003Ctbody\\u003E\",\"\\u003C/tbody\\u003E\\u003C/table\\u003E\",],\n            td: [3,\"\\u003Ctable\\u003E\\u003Ctbody\\u003E\\u003Ctr\\u003E\",\"\\u003C/tr\\u003E\\u003C/tbody\\u003E\\u003C/table\\u003E\",],\n            col: [2,\"\\u003Ctable\\u003E\\u003Ctbody\\u003E\\u003C/tbody\\u003E\\u003Ccolgroup\\u003E\",\"\\u003C/colgroup\\u003E\\u003C/table\\u003E\",],\n            area: [1,\"\\u003Cmap\\u003E\",\"\\u003C/map\\u003E\",],\n            _default: [0,\"\",\"\",]\n        }, Db = nb(e), Eb = Db.appendChild(e.createElement(\"div\"));\n        Cb.optgroup = Cb.option;\n        Cb.tbody = Cb.tfoot = Cb.colgroup = Cb.caption = Cb.thead;\n        Cb.th = Cb.td;\n        ((q.support.htmlSerialize || (Cb._default = [1,\"X\\u003Cdiv\\u003E\",\"\\u003C/div\\u003E\",])));\n        q.fn.extend({\n            text: function(a) {\n                return q.access(this, function(a) {\n                    return ((((a === b)) ? q.text(this) : this.empty().append(((((this[0] && this[0].ownerDocument)) || e)).createTextNode(a))));\n                }, null, a, arguments.length);\n            },\n            wrapAll: function(a) {\n                if (q.isFunction(a)) {\n                    return this.each(function(b) {\n                        q(this).wrapAll(a.call(this, b));\n                    });\n                }\n            ;\n            ;\n                if (this[0]) {\n                    var b = q(a, this[0].ownerDocument).eq(0).clone(!0);\n                    ((this[0].parentNode && b.insertBefore(this[0])));\n                    b.map(function() {\n                        var a = this;\n                        while (((a.firstChild && ((a.firstChild.nodeType === 1))))) {\n                            a = a.firstChild;\n                        ;\n                        };\n                    ;\n                        return a;\n                    }).append(this);\n                }\n            ;\n            ;\n                return this;\n            },\n            wrapInner: function(a) {\n                return ((q.isFunction(a) ? this.each(function(b) {\n                    q(this).wrapInner(a.call(this, b));\n                }) : this.each(function() {\n                    var b = q(this), c = b.contents();\n                    ((c.length ? c.wrapAll(a) : b.append(a)));\n                })));\n            },\n            wrap: function(a) {\n                var b = q.isFunction(a);\n                return this.each(function(c) {\n                    q(this).wrapAll(((b ? a.call(this, c) : a)));\n                });\n            },\n            unwrap: function() {\n                return this.parent().each(function() {\n                    ((q.nodeName(this, \"body\") || q(this).replaceWith(this.childNodes)));\n                }).end();\n            },\n            append: function() {\n                return this.domManip(arguments, !0, function(a) {\n                    ((((((this.nodeType === 1)) || ((this.nodeType === 11)))) && this.appendChild(a)));\n                });\n            },\n            prepend: function() {\n                return this.domManip(arguments, !0, function(a) {\n                    ((((((this.nodeType === 1)) || ((this.nodeType === 11)))) && this.insertBefore(a, this.firstChild)));\n                });\n            },\n            before: function() {\n                if (!kb(this[0])) {\n                    return this.domManip(arguments, !1, function(a) {\n                        this.parentNode.insertBefore(a, this);\n                    });\n                }\n            ;\n            ;\n                if (arguments.length) {\n                    var a = q.clean(arguments);\n                    return this.pushStack(q.merge(a, this), \"before\", this.selector);\n                }\n            ;\n            ;\n            },\n            after: function() {\n                if (!kb(this[0])) {\n                    return this.domManip(arguments, !1, function(a) {\n                        this.parentNode.insertBefore(a, this.nextSibling);\n                    });\n                }\n            ;\n            ;\n                if (arguments.length) {\n                    var a = q.clean(arguments);\n                    return this.pushStack(q.merge(this, a), \"after\", this.selector);\n                }\n            ;\n            ;\n            },\n            remove: function(a, b) {\n                var c, d = 0;\n                for (; (((c = this[d]) != null)); d++) {\n                    if (((!a || q.filter(a, [c,]).length))) {\n                        if (((!b && ((c.nodeType === 1))))) {\n                            q.cleanData(c.getElementsByTagName(\"*\"));\n                            q.cleanData([c,]);\n                        }\n                    ;\n                    ;\n                        ((c.parentNode && c.parentNode.removeChild(c)));\n                    }\n                ;\n                ;\n                };\n            ;\n                return this;\n            },\n            empty: function() {\n                var a, b = 0;\n                for (; (((a = this[b]) != null)); b++) {\n                    ((((a.nodeType === 1)) && q.cleanData(a.getElementsByTagName(\"*\"))));\n                    while (a.firstChild) {\n                        a.removeChild(a.firstChild);\n                    ;\n                    };\n                ;\n                };\n            ;\n                return this;\n            },\n            clone: function(a, b) {\n                a = ((((a == null)) ? !1 : a));\n                b = ((((b == null)) ? a : b));\n                return this.map(function() {\n                    return q.clone(this, a, b);\n                });\n            },\n            html: function(a) {\n                return q.access(this, function(a) {\n                    var c = ((this[0] || {\n                    })), d = 0, e = this.length;\n                    if (((a === b))) {\n                        return ((((c.nodeType === 1)) ? c.innerHTML.replace(pb, \"\") : b));\n                    }\n                ;\n                ;\n                    if (((((((((((typeof a == \"string\")) && !vb.test(a))) && ((q.support.htmlSerialize || !xb.test(a))))) && ((q.support.leadingWhitespace || !qb.test(a))))) && !Cb[((sb.exec(a) || [\"\",\"\",]))[1].toLowerCase()]))) {\n                        a = a.replace(rb, \"\\u003C$1\\u003E\\u003C/$2\\u003E\");\n                        try {\n                            for (; ((d < e)); d++) {\n                                c = ((this[d] || {\n                                }));\n                                if (((c.nodeType === 1))) {\n                                    q.cleanData(c.getElementsByTagName(\"*\"));\n                                    c.innerHTML = a;\n                                }\n                            ;\n                            ;\n                            };\n                        ;\n                            c = 0;\n                        } catch (f) {\n                        \n                        };\n                    ;\n                    }\n                ;\n                ;\n                    ((c && this.empty().append(a)));\n                }, null, a, arguments.length);\n            },\n            replaceWith: function(a) {\n                if (!kb(this[0])) {\n                    if (q.isFunction(a)) {\n                        return this.each(function(b) {\n                            var c = q(this), d = c.html();\n                            c.replaceWith(a.call(this, b, d));\n                        });\n                    }\n                ;\n                ;\n                    ((((typeof a != \"string\")) && (a = q(a).detach())));\n                    return this.each(function() {\n                        var b = this.nextSibling, c = this.parentNode;\n                        q(this).remove();\n                        ((b ? q(b).before(a) : q(c).append(a)));\n                    });\n                }\n            ;\n            ;\n                return ((this.length ? this.pushStack(q(((q.isFunction(a) ? a() : a))), \"replaceWith\", a) : this));\n            },\n            detach: function(a) {\n                return this.remove(a, !0);\n            },\n            domManip: function(a, c, d) {\n                a = [].concat.apply([], a);\n                var e, f, g, i, j = 0, k = a[0], l = [], m = this.length;\n                if (((((((!q.support.checkClone && ((m > 1)))) && ((typeof k == \"string\")))) && zb.test(k)))) {\n                    return this.each(function() {\n                        q(this).domManip(a, c, d);\n                    });\n                }\n            ;\n            ;\n                if (q.isFunction(k)) {\n                    return this.each(function(e) {\n                        var f = q(this);\n                        a[0] = k.call(this, e, ((c ? f.html() : b)));\n                        f.domManip(a, c, d);\n                    });\n                }\n            ;\n            ;\n                if (this[0]) {\n                    e = q.buildFragment(a, this, l);\n                    g = e.fragment;\n                    f = g.firstChild;\n                    ((((g.childNodes.length === 1)) && (g = f)));\n                    if (f) {\n                        c = ((c && q.nodeName(f, \"tr\")));\n                        for (i = ((e.cacheable || ((m - 1)))); ((j < m)); j++) {\n                            d.call(((((c && q.nodeName(this[j], \"table\"))) ? Fb(this[j], \"tbody\") : this[j])), ((((j === i)) ? g : q.clone(g, !0, !0))));\n                        ;\n                        };\n                    ;\n                    }\n                ;\n                ;\n                    g = f = null;\n                    ((l.length && q.each(l, function(a, b) {\n                        ((b.src ? ((q.ajax ? q.ajax({\n                            url: b.src,\n                            type: \"GET\",\n                            dataType: \"script\",\n                            async: !1,\n                            global: !1,\n                            throws: !0\n                        }) : q.error(\"no ajax\"))) : q.globalEval(((((((b.text || b.textContent)) || b.innerHTML)) || \"\")).replace(Bb, \"\"))));\n                        ((b.parentNode && b.parentNode.removeChild(b)));\n                    })));\n                }\n            ;\n            ;\n                return this;\n            }\n        });\n        q.buildFragment = function(a, c, d) {\n            var f, g, i, j = a[0];\n            c = ((c || e));\n            c = ((((!c.nodeType && c[0])) || c));\n            c = ((c.ownerDocument || c));\n            if (((((((((((((((((a.length === 1)) && ((typeof j == \"string\")))) && ((j.length < 512)))) && ((c === e)))) && ((j.charAt(0) === \"\\u003C\")))) && !wb.test(j))) && ((q.support.checkClone || !zb.test(j))))) && ((q.support.html5Clone || !xb.test(j)))))) {\n                g = !0;\n                f = q.fragments[j];\n                i = ((f !== b));\n            }\n        ;\n        ;\n            if (!f) {\n                f = c.createDocumentFragment();\n                q.clean(a, c, f, d);\n                ((g && (q.fragments[j] = ((i && f)))));\n            }\n        ;\n        ;\n            return {\n                fragment: f,\n                cacheable: g\n            };\n        };\n        q.fragments = {\n        };\n        q.each({\n            appendTo: \"append\",\n            prependTo: \"prepend\",\n            insertBefore: \"before\",\n            insertAfter: \"after\",\n            replaceAll: \"replaceWith\"\n        }, function(a, b) {\n            q.fn[a] = function(c) {\n                var d, e = 0, f = [], g = q(c), i = g.length, j = ((((this.length === 1)) && this[0].parentNode));\n                if (((((((j == null)) || ((((j && ((j.nodeType === 11)))) && ((j.childNodes.length === 1)))))) && ((i === 1))))) {\n                    g[b](this[0]);\n                    return this;\n                }\n            ;\n            ;\n                for (; ((e < i)); e++) {\n                    d = ((((e > 0)) ? this.clone(!0) : this)).get();\n                    q(g[e])[b](d);\n                    f = f.concat(d);\n                };\n            ;\n                return this.pushStack(f, a, g.selector);\n            };\n        });\n        q.extend({\n            clone: function(a, b, c) {\n                var d, e, f, g;\n                if (((((q.support.html5Clone || q.isXMLDoc(a))) || !xb.test(((((\"\\u003C\" + a.nodeName)) + \"\\u003E\")))))) g = a.cloneNode(!0);\n                 else {\n                    Eb.innerHTML = a.outerHTML;\n                    Eb.removeChild(g = Eb.firstChild);\n                }\n            ;\n            ;\n                if (((((((!q.support.noCloneEvent || !q.support.noCloneChecked)) && ((((a.nodeType === 1)) || ((a.nodeType === 11)))))) && !q.isXMLDoc(a)))) {\n                    Hb(a, g);\n                    d = Ib(a);\n                    e = Ib(g);\n                    for (f = 0; d[f]; ++f) {\n                        ((e[f] && Hb(d[f], e[f])));\n                    ;\n                    };\n                ;\n                }\n            ;\n            ;\n                if (b) {\n                    Gb(a, g);\n                    if (c) {\n                        d = Ib(a);\n                        e = Ib(g);\n                        for (f = 0; d[f]; ++f) {\n                            Gb(d[f], e[f]);\n                        ;\n                        };\n                    ;\n                    }\n                ;\n                ;\n                }\n            ;\n            ;\n                d = e = null;\n                return g;\n            },\n            clean: function(a, b, c, d) {\n                var f, g, i, j, k, l, m, n, o, p, r, s, t = ((((b === e)) && Db)), u = [];\n                if (((!b || ((typeof b.createDocumentFragment == \"undefined\"))))) {\n                    b = e;\n                }\n            ;\n            ;\n                for (f = 0; (((i = a[f]) != null)); f++) {\n                    ((((typeof i == \"number\")) && (i += \"\")));\n                    if (!i) {\n                        continue;\n                    }\n                ;\n                ;\n                    if (((typeof i == \"string\"))) {\n                        if (!ub.test(i)) i = b.createTextNode(i);\n                         else {\n                            t = ((t || nb(b)));\n                            m = b.createElement(\"div\");\n                            t.appendChild(m);\n                            i = i.replace(rb, \"\\u003C$1\\u003E\\u003C/$2\\u003E\");\n                            j = ((sb.exec(i) || [\"\",\"\",]))[1].toLowerCase();\n                            k = ((Cb[j] || Cb._default));\n                            l = k[0];\n                            m.innerHTML = ((((k[1] + i)) + k[2]));\n                            while (l--) {\n                                m = m.lastChild;\n                            ;\n                            };\n                        ;\n                            if (!q.support.tbody) {\n                                n = tb.test(i);\n                                o = ((((((j === \"table\")) && !n)) ? ((m.firstChild && m.firstChild.childNodes)) : ((((((k[1] === \"\\u003Ctable\\u003E\")) && !n)) ? m.childNodes : []))));\n                                for (g = ((o.length - 1)); ((g >= 0)); --g) {\n                                    ((((q.nodeName(o[g], \"tbody\") && !o[g].childNodes.length)) && o[g].parentNode.removeChild(o[g])));\n                                ;\n                                };\n                            ;\n                            }\n                        ;\n                        ;\n                            ((((!q.support.leadingWhitespace && qb.test(i))) && m.insertBefore(b.createTextNode(qb.exec(i)[0]), m.firstChild)));\n                            i = m.childNodes;\n                            m.parentNode.removeChild(m);\n                        }\n                    ;\n                    }\n                ;\n                ;\n                    ((i.nodeType ? u.push(i) : q.merge(u, i)));\n                };\n            ;\n                ((m && (i = m = t = null)));\n                if (!q.support.appendChecked) {\n                    for (f = 0; (((i = u[f]) != null)); f++) {\n                        ((q.nodeName(i, \"input\") ? Jb(i) : ((((typeof i.getElementsByTagName != \"undefined\")) && q.grep(i.getElementsByTagName(\"input\"), Jb)))));\n                    ;\n                    };\n                }\n            ;\n            ;\n                if (c) {\n                    r = function(a) {\n                        if (((!a.type || Ab.test(a.type)))) {\n                            return ((d ? d.push(((a.parentNode ? a.parentNode.removeChild(a) : a))) : c.appendChild(a)));\n                        }\n                    ;\n                    ;\n                    };\n                    for (f = 0; (((i = u[f]) != null)); f++) {\n                        if (((!q.nodeName(i, \"script\") || !r(i)))) {\n                            c.appendChild(i);\n                            if (((typeof i.getElementsByTagName != \"undefined\"))) {\n                                s = q.grep(q.merge([], i.getElementsByTagName(\"script\")), r);\n                                u.splice.apply(u, [((f + 1)),0,].concat(s));\n                                f += s.length;\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                }\n            ;\n            ;\n                return u;\n            },\n            cleanData: function(a, b) {\n                var c, d, e, f, g = 0, i = q.expando, j = q.cache, k = q.support.deleteExpando, l = q.JSBNG__event.special;\n                for (; (((e = a[g]) != null)); g++) {\n                    if (((b || q.acceptData(e)))) {\n                        d = e[i];\n                        c = ((d && j[d]));\n                        if (c) {\n                            if (c.events) {\n                                {\n                                    var fin27keys = ((window.top.JSBNG_Replay.forInKeys)((c.events))), fin27i = (0);\n                                    (0);\n                                    for (; (fin27i < fin27keys.length); (fin27i++)) {\n                                        ((f) = (fin27keys[fin27i]));\n                                        {\n                                            ((l[f] ? q.JSBNG__event.remove(e, f) : q.removeEvent(e, f, c.handle)));\n                                        ;\n                                        };\n                                    };\n                                };\n                            }\n                        ;\n                        ;\n                            if (j[d]) {\n                                delete j[d];\n                                ((k ? delete e[i] : ((e.removeAttribute ? e.removeAttribute(i) : e[i] = null))));\n                                q.deletedIds.push(d);\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                    }\n                ;\n                ;\n                };\n            ;\n            }\n        });\n        (function() {\n            var a, b;\n            q.uaMatch = function(a) {\n                a = a.toLowerCase();\n                var b = ((((((((((/(chrome)[ \\/]([\\w.]+)/.exec(a) || /(webkit)[ \\/]([\\w.]+)/.exec(a))) || /(opera)(?:.*version|)[ \\/]([\\w.]+)/.exec(a))) || /(msie) ([\\w.]+)/.exec(a))) || ((((a.indexOf(\"compatible\") < 0)) && /(mozilla)(?:.*? rv:([\\w.]+)|)/.exec(a))))) || []));\n                return {\n                    browser: ((b[1] || \"\")),\n                    version: ((b[2] || \"0\"))\n                };\n            };\n            a = q.uaMatch(g.userAgent);\n            b = {\n            };\n            if (a.browser) {\n                b[a.browser] = !0;\n                b.version = a.version;\n            }\n        ;\n        ;\n            ((b.chrome ? b.webkit = !0 : ((b.webkit && (b.safari = !0)))));\n            q.browser = b;\n            q.sub = function() {\n                function a(b, c) {\n                    return new a.fn.init(b, c);\n                };\n            ;\n                q.extend(!0, a, this);\n                a.superclass = this;\n                a.fn = a.prototype = this();\n                a.fn.constructor = a;\n                a.sub = this.sub;\n                a.fn.init = function(d, e) {\n                    ((((((e && ((e instanceof q)))) && !((e instanceof a)))) && (e = a(e))));\n                    return q.fn.init.call(this, d, e, b);\n                };\n                a.fn.init.prototype = a.fn;\n                var b = a(e);\n                return a;\n            };\n        })();\n        var Kb, Lb, Mb, Nb = /alpha\\([^)]*\\)/i, Ob = /opacity=([^)]*)/, Pb = /^(top|right|bottom|left)$/, Qb = /^(none|table(?!-c[ea]).+)/, Rb = /^margin/, Sb = new RegExp(((((\"^(\" + r)) + \")(.*)$\")), \"i\"), Tb = new RegExp(((((\"^(\" + r)) + \")(?!px)[a-z%]+$\")), \"i\"), Ub = new RegExp(((((\"^([-+])=(\" + r)) + \")\")), \"i\"), Vb = {\n            BODY: \"block\"\n        }, Wb = {\n            position: \"absolute\",\n            visibility: \"hidden\",\n            display: \"block\"\n        }, Xb = {\n            letterSpacing: 0,\n            fontWeight: 400\n        }, Yb = [\"Top\",\"Right\",\"Bottom\",\"Left\",], Zb = [\"Webkit\",\"O\",\"Moz\",\"ms\",], $b = q.fn.toggle;\n        q.fn.extend({\n            css: function(a, c) {\n                return q.access(this, function(a, c, d) {\n                    return ((((d !== b)) ? q.style(a, c, d) : q.css(a, c)));\n                }, a, c, ((arguments.length > 1)));\n            },\n            show: function() {\n                return bc(this, !0);\n            },\n            hide: function() {\n                return bc(this);\n            },\n            toggle: function(a, b) {\n                var c = ((typeof a == \"boolean\"));\n                return ((((q.isFunction(a) && q.isFunction(b))) ? $b.apply(this, arguments) : this.each(function() {\n                    ((((c ? a : ac(this))) ? q(this).show() : q(this).hide()));\n                })));\n            }\n        });\n        q.extend({\n            cssHooks: {\n                opacity: {\n                    get: function(a, b) {\n                        if (b) {\n                            var c = Kb(a, \"opacity\");\n                            return ((((c === \"\")) ? \"1\" : c));\n                        }\n                    ;\n                    ;\n                    }\n                }\n            },\n            cssNumber: {\n                fillOpacity: !0,\n                fontWeight: !0,\n                lineHeight: !0,\n                opacity: !0,\n                orphans: !0,\n                widows: !0,\n                zIndex: !0,\n                zoom: !0\n            },\n            cssProps: {\n                float: ((q.support.cssFloat ? \"cssFloat\" : \"styleFloat\"))\n            },\n            style: function(a, c, d, e) {\n                if (((((((!a || ((a.nodeType === 3)))) || ((a.nodeType === 8)))) || !a.style))) {\n                    return;\n                }\n            ;\n            ;\n                var f, g, i, j = q.camelCase(c), k = a.style;\n                c = ((q.cssProps[j] || (q.cssProps[j] = _b(k, j))));\n                i = ((q.cssHooks[c] || q.cssHooks[j]));\n                if (((d === b))) {\n                    return ((((((i && ((\"get\" in i)))) && (((f = i.get(a, !1, e)) !== b)))) ? f : k[c]));\n                }\n            ;\n            ;\n                g = typeof d;\n                if (((((g === \"string\")) && (f = Ub.exec(d))))) {\n                    d = ((((((f[1] + 1)) * f[2])) + parseFloat(q.css(a, c))));\n                    g = \"number\";\n                }\n            ;\n            ;\n                if (((((d == null)) || ((((g === \"number\")) && isNaN(d)))))) {\n                    return;\n                }\n            ;\n            ;\n                ((((((g === \"number\")) && !q.cssNumber[j])) && (d += \"px\")));\n                if (((((!i || !((\"set\" in i)))) || (((d = i.set(a, d, e)) !== b))))) {\n                    try {\n                        k[c] = d;\n                    } catch (l) {\n                    \n                    };\n                }\n            ;\n            ;\n            },\n            css: function(a, c, d, e) {\n                var f, g, i, j = q.camelCase(c);\n                c = ((q.cssProps[j] || (q.cssProps[j] = _b(a.style, j))));\n                i = ((q.cssHooks[c] || q.cssHooks[j]));\n                ((((i && ((\"get\" in i)))) && (f = i.get(a, !0, e))));\n                ((((f === b)) && (f = Kb(a, c))));\n                ((((((f === \"normal\")) && ((c in Xb)))) && (f = Xb[c])));\n                if (((d || ((e !== b))))) {\n                    g = parseFloat(f);\n                    return ((((d || q.isNumeric(g))) ? ((g || 0)) : f));\n                }\n            ;\n            ;\n                return f;\n            },\n            swap: function(a, b, c) {\n                var d, e, f = {\n                };\n                {\n                    var fin28keys = ((window.top.JSBNG_Replay.forInKeys)((b))), fin28i = (0);\n                    (0);\n                    for (; (fin28i < fin28keys.length); (fin28i++)) {\n                        ((e) = (fin28keys[fin28i]));\n                        {\n                            f[e] = a.style[e];\n                            a.style[e] = b[e];\n                        };\n                    };\n                };\n            ;\n                d = c.call(a);\n                {\n                    var fin29keys = ((window.top.JSBNG_Replay.forInKeys)((b))), fin29i = (0);\n                    (0);\n                    for (; (fin29i < fin29keys.length); (fin29i++)) {\n                        ((e) = (fin29keys[fin29i]));\n                        {\n                            a.style[e] = f[e];\n                        ;\n                        };\n                    };\n                };\n            ;\n                return d;\n            }\n        });\n        ((a.JSBNG__getComputedStyle ? Kb = function(b, c) {\n            var d, e, f, g, i = a.JSBNG__getComputedStyle(b, null), j = b.style;\n            if (i) {\n                d = ((i.getPropertyValue(c) || i[c]));\n                ((((((d === \"\")) && !q.contains(b.ownerDocument, b))) && (d = q.style(b, c))));\n                if (((Tb.test(d) && Rb.test(c)))) {\n                    e = j.width;\n                    f = j.minWidth;\n                    g = j.maxWidth;\n                    j.minWidth = j.maxWidth = j.width = d;\n                    d = i.width;\n                    j.width = e;\n                    j.minWidth = f;\n                    j.maxWidth = g;\n                }\n            ;\n            ;\n            }\n        ;\n        ;\n            return d;\n        } : ((e.documentElement.currentStyle && (Kb = function(a, b) {\n            var c, d, e = ((a.currentStyle && a.currentStyle[b])), f = a.style;\n            ((((((((e == null)) && f)) && f[b])) && (e = f[b])));\n            if (((Tb.test(e) && !Pb.test(b)))) {\n                c = f.left;\n                d = ((a.runtimeStyle && a.runtimeStyle.left));\n                ((d && (a.runtimeStyle.left = a.currentStyle.left)));\n                f.left = ((((b === \"fontSize\")) ? \"1em\" : e));\n                e = ((f.pixelLeft + \"px\"));\n                f.left = c;\n                ((d && (a.runtimeStyle.left = d)));\n            }\n        ;\n        ;\n            return ((((e === \"\")) ? \"auto\" : e));\n        })))));\n        q.each([\"height\",\"width\",], function(a, b) {\n            q.cssHooks[b] = {\n                get: function(a, c, d) {\n                    if (c) {\n                        return ((((((a.offsetWidth === 0)) && Qb.test(Kb(a, \"display\")))) ? q.swap(a, Wb, function() {\n                            return ec(a, b, d);\n                        }) : ec(a, b, d)));\n                    }\n                ;\n                ;\n                },\n                set: function(a, c, d) {\n                    return cc(a, c, ((d ? dc(a, b, d, ((q.support.boxSizing && ((q.css(a, \"boxSizing\") === \"border-box\"))))) : 0)));\n                }\n            };\n        });\n        ((q.support.opacity || (q.cssHooks.opacity = {\n            get: function(a, b) {\n                return ((Ob.test(((((((b && a.currentStyle)) ? a.currentStyle.filter : a.style.filter)) || \"\"))) ? ((((77546 * parseFloat(RegExp.$1))) + \"\")) : ((b ? \"1\" : \"\"))));\n            },\n            set: function(a, b) {\n                var c = a.style, d = a.currentStyle, e = ((q.isNumeric(b) ? ((((\"alpha(opacity=\" + ((b * 100)))) + \")\")) : \"\")), f = ((((((d && d.filter)) || c.filter)) || \"\"));\n                c.zoom = 1;\n                if (((((((b >= 1)) && ((q.trim(f.replace(Nb, \"\")) === \"\")))) && c.removeAttribute))) {\n                    c.removeAttribute(\"filter\");\n                    if (((d && !d.filter))) {\n                        return;\n                    }\n                ;\n                ;\n                }\n            ;\n            ;\n                c.filter = ((Nb.test(f) ? f.replace(Nb, e) : ((((f + \" \")) + e))));\n            }\n        })));\n        q(function() {\n            ((q.support.reliableMarginRight || (q.cssHooks.marginRight = {\n                get: function(a, b) {\n                    return q.swap(a, {\n                        display: \"inline-block\"\n                    }, function() {\n                        if (b) {\n                            return Kb(a, \"marginRight\");\n                        }\n                    ;\n                    ;\n                    });\n                }\n            })));\n            ((((!q.support.pixelPosition && q.fn.position)) && q.each([\"JSBNG__top\",\"left\",], function(a, b) {\n                q.cssHooks[b] = {\n                    get: function(a, c) {\n                        if (c) {\n                            var d = Kb(a, b);\n                            return ((Tb.test(d) ? ((q(a).position()[b] + \"px\")) : d));\n                        }\n                    ;\n                    ;\n                    }\n                };\n            })));\n        });\n        if (((q.expr && q.expr.filters))) {\n            q.expr.filters.hidden = function(a) {\n                return ((((((a.offsetWidth === 0)) && ((a.offsetHeight === 0)))) || ((!q.support.reliableHiddenOffsets && ((((((a.style && a.style.display)) || Kb(a, \"display\"))) === \"none\"))))));\n            };\n            q.expr.filters.visible = function(a) {\n                return !q.expr.filters.hidden(a);\n            };\n        }\n    ;\n    ;\n        q.each({\n            margin: \"\",\n            padding: \"\",\n            border: \"Width\"\n        }, function(a, b) {\n            q.cssHooks[((a + b))] = {\n                expand: function(c) {\n                    var d, e = ((((typeof c == \"string\")) ? c.split(\" \") : [c,])), f = {\n                    };\n                    for (d = 0; ((d < 4)); d++) {\n                        f[((((a + Yb[d])) + b))] = ((((e[d] || e[((d - 2))])) || e[0]));\n                    ;\n                    };\n                ;\n                    return f;\n                }\n            };\n            ((Rb.test(a) || (q.cssHooks[((a + b))].set = cc)));\n        });\n        var gc = /%20/g, hc = /\\[\\]$/, ic = /\\r?\\n/g, jc = /^(?:color|date|datetime|datetime-local|email|hidden|month|number|password|range|search|tel|text|time|url|week)$/i, kc = /^(?:select|textarea)/i;\n        q.fn.extend({\n            serialize: function() {\n                return q.param(this.serializeArray());\n            },\n            serializeArray: function() {\n                return this.map(function() {\n                    return ((this.elements ? q.makeArray(this.elements) : this));\n                }).filter(function() {\n                    return ((((this.JSBNG__name && !this.disabled)) && ((((this.checked || kc.test(this.nodeName))) || jc.test(this.type)))));\n                }).map(function(a, b) {\n                    var c = q(this).val();\n                    return ((((c == null)) ? null : ((q.isArray(c) ? q.map(c, function(a, c) {\n                        return {\n                            JSBNG__name: b.JSBNG__name,\n                            value: a.replace(ic, \"\\u000d\\u000a\")\n                        };\n                    }) : {\n                        JSBNG__name: b.JSBNG__name,\n                        value: c.replace(ic, \"\\u000d\\u000a\")\n                    }))));\n                }).get();\n            }\n        });\n        q.param = function(a, c) {\n            var d, e = [], f = function(a, b) {\n                b = ((q.isFunction(b) ? b() : ((((b == null)) ? \"\" : b))));\n                e[e.length] = ((((encodeURIComponent(a) + \"=\")) + encodeURIComponent(b)));\n            };\n            ((((c === b)) && (c = ((q.ajaxSettings && q.ajaxSettings.traditional)))));\n            if (((q.isArray(a) || ((a.jquery && !q.isPlainObject(a)))))) {\n                q.each(a, function() {\n                    f(this.JSBNG__name, this.value);\n                });\n            }\n             else {\n                {\n                    var fin30keys = ((window.top.JSBNG_Replay.forInKeys)((a))), fin30i = (0);\n                    (0);\n                    for (; (fin30i < fin30keys.length); (fin30i++)) {\n                        ((d) = (fin30keys[fin30i]));\n                        {\n                            lc(d, a[d], c, f);\n                        ;\n                        };\n                    };\n                };\n            }\n        ;\n        ;\n            return e.join(\"&\").replace(gc, \"+\");\n        };\n        var mc, nc, oc = /#.*$/, pc = /^(.*?):[ \\t]*([^\\r\\n]*)\\r?$/gm, qc = /^(?:about|app|app\\-storage|.+\\-extension|file|res|widget):$/, rc = /^(?:GET|HEAD)$/, sc = /^\\/\\//, tc = /\\?/, uc = /<script\\b[^<]*(?:(?!<\\/script>)<[^<]*)*<\\/script>/gi, vc = /([?&])_=[^&]*/, wc = /^([\\w\\+\\.\\-]+:)(?:\\/\\/([^\\/?#:]*)(?::(\\d+)|)|)/, xc = q.fn.load, yc = {\n        }, zc = {\n        }, Ac = (([\"*/\",] + [\"*\",]));\n        try {\n            nc = f.href;\n        } catch (Bc) {\n            nc = e.createElement(\"a\");\n            nc.href = \"\";\n            nc = nc.href;\n        };\n    ;\n        mc = ((wc.exec(nc.toLowerCase()) || []));\n        q.fn.load = function(a, c, d) {\n            if (((((typeof a != \"string\")) && xc))) {\n                return xc.apply(this, arguments);\n            }\n        ;\n        ;\n            if (!this.length) {\n                return this;\n            }\n        ;\n        ;\n            var e, f, g, i = this, j = a.indexOf(\" \");\n            if (((j >= 0))) {\n                e = a.slice(j, a.length);\n                a = a.slice(0, j);\n            }\n        ;\n        ;\n            if (q.isFunction(c)) {\n                d = c;\n                c = b;\n            }\n             else ((((c && ((typeof c == \"object\")))) && (f = \"POST\")));\n        ;\n        ;\n            q.ajax({\n                url: a,\n                type: f,\n                dataType: \"html\",\n                data: c,\n                complete: function(a, b) {\n                    ((d && i.each(d, ((g || [a.responseText,b,a,])))));\n                }\n            }).done(function(a) {\n                g = arguments;\n                i.html(((e ? q(\"\\u003Cdiv\\u003E\").append(a.replace(uc, \"\")).JSBNG__find(e) : a)));\n            });\n            return this;\n        };\n        q.each(\"ajaxStart ajaxStop ajaxComplete ajaxError ajaxSuccess ajaxSend\".split(\" \"), function(a, b) {\n            q.fn[b] = function(a) {\n                return this.JSBNG__on(b, a);\n            };\n        });\n        q.each([\"get\",\"post\",], function(a, c) {\n            q[c] = function(a, d, e, f) {\n                if (q.isFunction(d)) {\n                    f = ((f || e));\n                    e = d;\n                    d = b;\n                }\n            ;\n            ;\n                return q.ajax({\n                    type: c,\n                    url: a,\n                    data: d,\n                    success: e,\n                    dataType: f\n                });\n            };\n        });\n        q.extend({\n            getScript: function(a, c) {\n                return q.get(a, b, c, \"script\");\n            },\n            getJSON: function(a, b, c) {\n                return q.get(a, b, c, \"json\");\n            },\n            ajaxSetup: function(a, b) {\n                if (b) Ec(a, q.ajaxSettings);\n                 else {\n                    b = a;\n                    a = q.ajaxSettings;\n                }\n            ;\n            ;\n                Ec(a, b);\n                return a;\n            },\n            ajaxSettings: {\n                url: nc,\n                isLocal: qc.test(mc[1]),\n                global: !0,\n                type: \"GET\",\n                contentType: \"application/x-www-form-urlencoded; charset=UTF-8\",\n                processData: !0,\n                async: !0,\n                accepts: {\n                    xml: \"application/xml, text/xml\",\n                    html: \"text/html\",\n                    text: \"text/plain\",\n                    json: \"application/json, text/javascript\",\n                    \"*\": Ac\n                },\n                contents: {\n                    xml: /xml/,\n                    html: /html/,\n                    json: /json/\n                },\n                responseFields: {\n                    xml: \"responseXML\",\n                    text: \"responseText\"\n                },\n                converters: {\n                    \"* text\": a.String,\n                    \"text html\": !0,\n                    \"text json\": q.parseJSON,\n                    \"text xml\": q.parseXML\n                },\n                flatOptions: {\n                    context: !0,\n                    url: !0\n                }\n            },\n            ajaxPrefilter: Cc(yc),\n            ajaxTransport: Cc(zc),\n            ajax: function(a, c) {\n                function z(a, c, f, j) {\n                    var l, t, u, v, x, z = c;\n                    if (((w === 2))) {\n                        return;\n                    }\n                ;\n                ;\n                    w = 2;\n                    ((i && JSBNG__clearTimeout(i)));\n                    g = b;\n                    e = ((j || \"\"));\n                    y.readyState = ((((a > 0)) ? 4 : 0));\n                    ((f && (v = Fc(m, y, f))));\n                    if (((((((a >= 200)) && ((a < 300)))) || ((a === 304))))) {\n                        if (m.ifModified) {\n                            x = y.getResponseHeader(\"Last-Modified\");\n                            ((x && (q.lastModified[d] = x)));\n                            x = y.getResponseHeader(\"Etag\");\n                            ((x && (q.etag[d] = x)));\n                        }\n                    ;\n                    ;\n                        if (((a === 304))) {\n                            z = \"notmodified\";\n                            l = !0;\n                        }\n                         else {\n                            l = Gc(m, v);\n                            z = l.state;\n                            t = l.data;\n                            u = l.error;\n                            l = !u;\n                        }\n                    ;\n                    ;\n                    }\n                     else {\n                        u = z;\n                        if (((!z || a))) {\n                            z = \"error\";\n                            ((((a < 0)) && (a = 0)));\n                        }\n                    ;\n                    ;\n                    }\n                ;\n                ;\n                    y.JSBNG__status = a;\n                    y.statusText = ((((c || z)) + \"\"));\n                    ((l ? p.resolveWith(n, [t,z,y,]) : p.rejectWith(n, [y,z,u,])));\n                    y.statusCode(s);\n                    s = b;\n                    ((k && o.trigger(((\"ajax\" + ((l ? \"Success\" : \"Error\")))), [y,m,((l ? t : u)),])));\n                    r.fireWith(n, [y,z,]);\n                    if (k) {\n                        o.trigger(\"ajaxComplete\", [y,m,]);\n                        ((--q.active || q.JSBNG__event.trigger(\"ajaxStop\")));\n                    }\n                ;\n                ;\n                };\n            ;\n                if (((typeof a == \"object\"))) {\n                    c = a;\n                    a = b;\n                }\n            ;\n            ;\n                c = ((c || {\n                }));\n                var d, e, f, g, i, j, k, l, m = q.ajaxSetup({\n                }, c), n = ((m.context || m)), o = ((((((n !== m)) && ((n.nodeType || ((n instanceof q)))))) ? q(n) : q.JSBNG__event)), p = q.Deferred(), r = q.Callbacks(\"once memory\"), s = ((m.statusCode || {\n                })), u = {\n                }, v = {\n                }, w = 0, x = \"canceled\", y = {\n                    readyState: 0,\n                    setRequestHeader: function(a, b) {\n                        if (!w) {\n                            var c = a.toLowerCase();\n                            a = v[c] = ((v[c] || a));\n                            u[a] = b;\n                        }\n                    ;\n                    ;\n                        return this;\n                    },\n                    getAllResponseHeaders: function() {\n                        return ((((w === 2)) ? e : null));\n                    },\n                    getResponseHeader: function(a) {\n                        var c;\n                        if (((w === 2))) {\n                            if (!f) {\n                                f = {\n                                };\n                                while (c = pc.exec(e)) {\n                                    f[c[1].toLowerCase()] = c[2];\n                                ;\n                                };\n                            ;\n                            }\n                        ;\n                        ;\n                            c = f[a.toLowerCase()];\n                        }\n                    ;\n                    ;\n                        return ((((c === b)) ? null : c));\n                    },\n                    overrideMimeType: function(a) {\n                        ((w || (m.mimeType = a)));\n                        return this;\n                    },\n                    abort: function(a) {\n                        a = ((a || x));\n                        ((g && g.abort(a)));\n                        z(0, a);\n                        return this;\n                    }\n                };\n                p.promise(y);\n                y.success = y.done;\n                y.error = y.fail;\n                y.complete = r.add;\n                y.statusCode = function(a) {\n                    if (a) {\n                        var b;\n                        if (((w < 2))) {\n                            var fin31keys = ((window.top.JSBNG_Replay.forInKeys)((a))), fin31i = (0);\n                            (0);\n                            for (; (fin31i < fin31keys.length); (fin31i++)) {\n                                ((b) = (fin31keys[fin31i]));\n                                {\n                                    s[b] = [s[b],a[b],];\n                                ;\n                                };\n                            };\n                        }\n                         else {\n                            b = a[y.JSBNG__status];\n                            y.always(b);\n                        }\n                    ;\n                    ;\n                    }\n                ;\n                ;\n                    return this;\n                };\n                m.url = ((((a || m.url)) + \"\")).replace(oc, \"\").replace(sc, ((mc[1] + \"//\")));\n                m.dataTypes = q.trim(((m.dataType || \"*\"))).toLowerCase().split(t);\n                if (((m.crossDomain == null))) {\n                    j = wc.exec(m.url.toLowerCase());\n                    m.crossDomain = !((!j || ((((((j[1] === mc[1])) && ((j[2] === mc[2])))) && ((((j[3] || ((((j[1] === \"http:\")) ? 80 : 443)))) == ((mc[3] || ((((mc[1] === \"http:\")) ? 80 : 443))))))))));\n                }\n            ;\n            ;\n                ((((((m.data && m.processData)) && ((typeof m.data != \"string\")))) && (m.data = q.param(m.data, m.traditional))));\n                Dc(yc, m, c, y);\n                if (((w === 2))) {\n                    return y;\n                }\n            ;\n            ;\n                k = m.global;\n                m.type = m.type.toUpperCase();\n                m.hasContent = !rc.test(m.type);\n                ((((k && ((q.active++ === 0)))) && q.JSBNG__event.trigger(\"ajaxStart\")));\n                if (!m.hasContent) {\n                    if (m.data) {\n                        m.url += ((((tc.test(m.url) ? \"&\" : \"?\")) + m.data));\n                        delete m.data;\n                    }\n                ;\n                ;\n                    d = m.url;\n                    if (((m.cache === !1))) {\n                        var A = q.now(), B = m.url.replace(vc, ((\"$1_=\" + A)));\n                        m.url = ((B + ((((B === m.url)) ? ((((((tc.test(m.url) ? \"&\" : \"?\")) + \"_=\")) + A)) : \"\"))));\n                    }\n                ;\n                ;\n                }\n            ;\n            ;\n                ((((((((m.data && m.hasContent)) && ((m.contentType !== !1)))) || c.contentType)) && y.setRequestHeader(\"Content-Type\", m.contentType)));\n                if (m.ifModified) {\n                    d = ((d || m.url));\n                    ((q.lastModified[d] && y.setRequestHeader(\"If-Modified-Since\", q.lastModified[d])));\n                    ((q.etag[d] && y.setRequestHeader(\"If-None-Match\", q.etag[d])));\n                }\n            ;\n            ;\n                y.setRequestHeader(\"Accept\", ((((m.dataTypes[0] && m.accepts[m.dataTypes[0]])) ? ((m.accepts[m.dataTypes[0]] + ((((m.dataTypes[0] !== \"*\")) ? ((((\", \" + Ac)) + \"; q=0.01\")) : \"\")))) : m.accepts[\"*\"])));\n                {\n                    var fin32keys = ((window.top.JSBNG_Replay.forInKeys)((m.headers))), fin32i = (0);\n                    (0);\n                    for (; (fin32i < fin32keys.length); (fin32i++)) {\n                        ((l) = (fin32keys[fin32i]));\n                        {\n                            y.setRequestHeader(l, m.headers[l]);\n                        ;\n                        };\n                    };\n                };\n            ;\n                if (((!m.beforeSend || ((((m.beforeSend.call(n, y, m) !== !1)) && ((w !== 2))))))) {\n                    x = \"abort\";\n                    {\n                        var fin33keys = ((window.top.JSBNG_Replay.forInKeys)(({\n                            success: 1,\n                            error: 1,\n                            complete: 1\n                        }))), fin33i = (0);\n                        (0);\n                        for (; (fin33i < fin33keys.length); (fin33i++)) {\n                            ((l) = (fin33keys[fin33i]));\n                            {\n                                y[l](m[l]);\n                            ;\n                            };\n                        };\n                    };\n                ;\n                    g = Dc(zc, m, c, y);\n                    if (!g) z(-1, \"No Transport\");\n                     else {\n                        y.readyState = 1;\n                        ((k && o.trigger(\"ajaxSend\", [y,m,])));\n                        ((((m.async && ((m.timeout > 0)))) && (i = JSBNG__setTimeout(function() {\n                            y.abort(\"timeout\");\n                        }, m.timeout))));\n                        try {\n                            w = 1;\n                            g.send(u, z);\n                        } catch (C) {\n                            if (!((w < 2))) {\n                                throw C;\n                            }\n                        ;\n                        ;\n                            z(-1, C);\n                        };\n                    ;\n                    }\n                ;\n                ;\n                    return y;\n                }\n            ;\n            ;\n                return y.abort();\n            },\n            active: 0,\n            lastModified: {\n            },\n            etag: {\n            }\n        });\n        var Hc = [], Ic = /\\?/, Jc = /(=)\\?(?=&|$)|\\?\\?/, Kc = q.now();\n        q.ajaxSetup({\n            jsonp: \"callback\",\n            jsonpCallback: function() {\n                var a = ((Hc.pop() || ((((q.expando + \"_\")) + Kc++))));\n                this[a] = !0;\n                return a;\n            }\n        });\n        q.ajaxPrefilter(\"json jsonp\", function(c, d, e) {\n            var f, g, i, j = c.data, k = c.url, l = ((c.jsonp !== !1)), m = ((l && Jc.test(k))), n = ((((((((l && !m)) && ((typeof j == \"string\")))) && !((c.contentType || \"\")).indexOf(\"application/x-www-form-urlencoded\"))) && Jc.test(j)));\n            if (((((((c.dataTypes[0] === \"jsonp\")) || m)) || n))) {\n                f = c.jsonpCallback = ((q.isFunction(c.jsonpCallback) ? c.jsonpCallback() : c.jsonpCallback));\n                g = a[f];\n                ((m ? c.url = k.replace(Jc, ((\"$1\" + f))) : ((n ? c.data = j.replace(Jc, ((\"$1\" + f))) : ((l && (c.url += ((((((((Ic.test(k) ? \"&\" : \"?\")) + c.jsonp)) + \"=\")) + f)))))))));\n                c.converters[\"script json\"] = function() {\n                    ((i || q.error(((f + \" was not called\")))));\n                    return i[0];\n                };\n                c.dataTypes[0] = \"json\";\n                a[f] = function() {\n                    i = arguments;\n                };\n                e.always(function() {\n                    a[f] = g;\n                    if (c[f]) {\n                        c.jsonpCallback = d.jsonpCallback;\n                        Hc.push(f);\n                    }\n                ;\n                ;\n                    ((((i && q.isFunction(g))) && g(i[0])));\n                    i = g = b;\n                });\n                return \"script\";\n            }\n        ;\n        ;\n        });\n        q.ajaxSetup({\n            accepts: {\n                script: \"text/javascript, application/javascript, application/ecmascript, application/x-ecmascript\"\n            },\n            contents: {\n                script: /javascript|ecmascript/\n            },\n            converters: {\n                \"text script\": function(a) {\n                    q.globalEval(a);\n                    return a;\n                }\n            }\n        });\n        q.ajaxPrefilter(\"script\", function(a) {\n            ((((a.cache === b)) && (a.cache = !1)));\n            if (a.crossDomain) {\n                a.type = \"GET\";\n                a.global = !1;\n            }\n        ;\n        ;\n        });\n        q.ajaxTransport(\"script\", function(a) {\n            if (a.crossDomain) {\n                var c, d = ((((e.head || e.getElementsByTagName(\"head\")[0])) || e.documentElement));\n                return {\n                    send: function(_, f) {\n                        c = e.createElement(\"script\");\n                        c.async = \"async\";\n                        ((a.scriptCharset && (c.charset = a.scriptCharset)));\n                        c.src = a.url;\n                        c.JSBNG__onload = c.onreadystatechange = function(_, a) {\n                            if (((((a || !c.readyState)) || /loaded|complete/.test(c.readyState)))) {\n                                c.JSBNG__onload = c.onreadystatechange = null;\n                                ((((d && c.parentNode)) && d.removeChild(c)));\n                                c = b;\n                                ((a || f(200, \"success\")));\n                            }\n                        ;\n                        ;\n                        };\n                        d.insertBefore(c, d.firstChild);\n                    },\n                    abort: function() {\n                        ((c && c.JSBNG__onload(0, 1)));\n                    }\n                };\n            }\n        ;\n        ;\n        });\n        var Lc, Mc = ((a.ActiveXObject ? function() {\n            {\n                var fin34keys = ((window.top.JSBNG_Replay.forInKeys)((Lc))), fin34i = (0);\n                var a;\n                for (; (fin34i < fin34keys.length); (fin34i++)) {\n                    ((a) = (fin34keys[fin34i]));\n                    {\n                        Lc[a](0, 1);\n                    ;\n                    };\n                };\n            };\n        ;\n        } : !1)), Nc = 0;\n        q.ajaxSettings.xhr = ((a.ActiveXObject ? function() {\n            return ((((!this.isLocal && Oc())) || Pc()));\n        } : Oc));\n        (function(a) {\n            q.extend(q.support, {\n                ajax: !!a,\n                cors: ((!!a && ((\"withCredentials\" in a))))\n            });\n        })(q.ajaxSettings.xhr());\n        ((q.support.ajax && q.ajaxTransport(function(c) {\n            if (((!c.crossDomain || q.support.cors))) {\n                var d;\n                return {\n                    send: function(e, f) {\n                        var g, i, j = c.xhr();\n                        ((c.username ? j.open(c.type, c.url, c.async, c.username, c.password) : j.open(c.type, c.url, c.async)));\n                        if (c.xhrFields) {\n                            {\n                                var fin35keys = ((window.top.JSBNG_Replay.forInKeys)((c.xhrFields))), fin35i = (0);\n                                (0);\n                                for (; (fin35i < fin35keys.length); (fin35i++)) {\n                                    ((i) = (fin35keys[fin35i]));\n                                    {\n                                        j[i] = c.xhrFields[i];\n                                    ;\n                                    };\n                                };\n                            };\n                        }\n                    ;\n                    ;\n                        ((((c.mimeType && j.overrideMimeType)) && j.overrideMimeType(c.mimeType)));\n                        ((((!c.crossDomain && !e[\"X-Requested-With\"])) && (e[\"X-Requested-With\"] = \"JSBNG__XMLHttpRequest\")));\n                        try {\n                            {\n                                var fin36keys = ((window.top.JSBNG_Replay.forInKeys)((e))), fin36i = (0);\n                                (0);\n                                for (; (fin36i < fin36keys.length); (fin36i++)) {\n                                    ((i) = (fin36keys[fin36i]));\n                                    {\n                                        j.setRequestHeader(i, e[i]);\n                                    ;\n                                    };\n                                };\n                            };\n                        ;\n                        } catch (_) {\n                        \n                        };\n                    ;\n                        j.send(((((c.hasContent && c.data)) || null)));\n                        d = function(_, a) {\n                            var e, i, k, l, m;\n                            try {\n                                if (((d && ((a || ((j.readyState === 4))))))) {\n                                    d = b;\n                                    if (g) {\n                                        j.onreadystatechange = q.noop;\n                                        ((Mc && delete Lc[g]));\n                                    }\n                                ;\n                                ;\n                                    if (a) ((((j.readyState !== 4)) && j.abort()));\n                                     else {\n                                        e = j.JSBNG__status;\n                                        k = j.getAllResponseHeaders();\n                                        l = {\n                                        };\n                                        m = j.responseXML;\n                                        ((((m && m.documentElement)) && (l.xml = m)));\n                                        try {\n                                            l.text = j.responseText;\n                                        } catch (n) {\n                                        \n                                        };\n                                    ;\n                                        try {\n                                            i = j.statusText;\n                                        } catch (n) {\n                                            i = \"\";\n                                        };\n                                    ;\n                                        ((((((!e && c.isLocal)) && !c.crossDomain)) ? e = ((l.text ? 200 : 404)) : ((((e === 1223)) && (e = 204)))));\n                                    }\n                                ;\n                                ;\n                                }\n                            ;\n                            ;\n                            } catch (o) {\n                                ((a || f(-1, o)));\n                            };\n                        ;\n                            ((l && f(e, i, l, k)));\n                        };\n                        if (!c.async) {\n                            d();\n                        }\n                         else {\n                            if (((j.readyState === 4))) JSBNG__setTimeout(d, 0);\n                             else {\n                                g = ++Nc;\n                                if (Mc) {\n                                    if (!Lc) {\n                                        Lc = {\n                                        };\n                                        q(a).unload(Mc);\n                                    }\n                                ;\n                                ;\n                                    Lc[g] = d;\n                                }\n                            ;\n                            ;\n                                j.onreadystatechange = d;\n                            }\n                        ;\n                        }\n                    ;\n                    ;\n                    },\n                    abort: function() {\n                        ((d && d(0, 1)));\n                    }\n                };\n            }\n        ;\n        ;\n        })));\n        var Qc, Rc, Sc = /^(?:toggle|show|hide)$/, Tc = new RegExp(((((\"^(?:([-+])=|)(\" + r)) + \")([a-z%]*)$\")), \"i\"), Uc = /queueHooks$/, Vc = [_c,], Wc = {\n            \"*\": [function(a, b) {\n                var c, d, e = this.createTween(a, b), f = Tc.exec(b), g = e.cur(), i = ((+g || 0)), j = 1, k = 20;\n                if (f) {\n                    c = +f[2];\n                    d = ((f[3] || ((q.cssNumber[a] ? \"\" : \"px\"))));\n                    if (((((d !== \"px\")) && i))) {\n                        i = ((((q.css(e.elem, a, !0) || c)) || 1));\n                        do {\n                            j = ((j || \".5\"));\n                            i /= j;\n                            q.style(e.elem, a, ((i + d)));\n                        } while (((((((j !== (j = ((e.cur() / g))))) && ((j !== 1)))) && --k)));\n                    }\n                ;\n                ;\n                    e.unit = d;\n                    e.start = i;\n                    e.end = ((f[1] ? ((i + ((((f[1] + 1)) * c)))) : c));\n                }\n            ;\n            ;\n                return e;\n            },]\n        };\n        q.Animation = q.extend(Zc, {\n            tweener: function(a, b) {\n                if (q.isFunction(a)) {\n                    b = a;\n                    a = [\"*\",];\n                }\n                 else a = a.split(\" \");\n            ;\n            ;\n                var c, d = 0, e = a.length;\n                for (; ((d < e)); d++) {\n                    c = a[d];\n                    Wc[c] = ((Wc[c] || []));\n                    Wc[c].unshift(b);\n                };\n            ;\n            },\n            prefilter: function(a, b) {\n                ((b ? Vc.unshift(a) : Vc.push(a)));\n            }\n        });\n        q.Tween = ad;\n        ad.prototype = {\n            constructor: ad,\n            init: function(a, b, c, d, e, f) {\n                this.elem = a;\n                this.prop = c;\n                this.easing = ((e || \"swing\"));\n                this.options = b;\n                this.start = this.now = this.cur();\n                this.end = d;\n                this.unit = ((f || ((q.cssNumber[c] ? \"\" : \"px\"))));\n            },\n            cur: function() {\n                var a = ad.propHooks[this.prop];\n                return ((((a && a.get)) ? a.get(this) : ad.propHooks._default.get(this)));\n            },\n            run: function(a) {\n                var b, c = ad.propHooks[this.prop];\n                ((this.options.duration ? this.pos = b = q.easing[this.easing](a, ((this.options.duration * a)), 0, 1, this.options.duration) : this.pos = b = a));\n                this.now = ((((((this.end - this.start)) * b)) + this.start));\n                ((this.options.step && this.options.step.call(this.elem, this.now, this)));\n                ((((c && c.set)) ? c.set(this) : ad.propHooks._default.set(this)));\n                return this;\n            }\n        };\n        ad.prototype.init.prototype = ad.prototype;\n        ad.propHooks = {\n            _default: {\n                get: function(a) {\n                    var b;\n                    if (((((a.elem[a.prop] == null)) || ((!!a.elem.style && ((a.elem.style[a.prop] != null))))))) {\n                        b = q.css(a.elem, a.prop, !1, \"\");\n                        return ((((!b || ((b === \"auto\")))) ? 0 : b));\n                    }\n                ;\n                ;\n                    return a.elem[a.prop];\n                },\n                set: function(a) {\n                    ((q.fx.step[a.prop] ? q.fx.step[a.prop](a) : ((((a.elem.style && ((((a.elem.style[q.cssProps[a.prop]] != null)) || q.cssHooks[a.prop])))) ? q.style(a.elem, a.prop, ((a.now + a.unit))) : a.elem[a.prop] = a.now))));\n                }\n            }\n        };\n        ad.propHooks.scrollTop = ad.propHooks.scrollLeft = {\n            set: function(a) {\n                ((((a.elem.nodeType && a.elem.parentNode)) && (a.elem[a.prop] = a.now)));\n            }\n        };\n        q.each([\"toggle\",\"show\",\"hide\",], function(a, b) {\n            var c = q.fn[b];\n            q.fn[b] = function(d, e, f) {\n                return ((((((((d == null)) || ((typeof d == \"boolean\")))) || ((((!a && q.isFunction(d))) && q.isFunction(e))))) ? c.apply(this, arguments) : this.animate(bd(b, !0), d, e, f)));\n            };\n        });\n        q.fn.extend({\n            fadeTo: function(a, b, c, d) {\n                return this.filter(ac).css(\"opacity\", 0).show().end().animate({\n                    opacity: b\n                }, a, c, d);\n            },\n            animate: function(a, b, c, d) {\n                var e = q.isEmptyObject(a), f = q.speed(b, c, d), g = function() {\n                    var b = Zc(this, q.extend({\n                    }, a), f);\n                    ((e && b.JSBNG__stop(!0)));\n                };\n                return ((((e || ((f.queue === !1)))) ? this.each(g) : this.queue(f.queue, g)));\n            },\n            JSBNG__stop: function(a, c, d) {\n                var e = function(a) {\n                    var b = a.JSBNG__stop;\n                    delete a.JSBNG__stop;\n                    b(d);\n                };\n                if (((typeof a != \"string\"))) {\n                    d = c;\n                    c = a;\n                    a = b;\n                }\n            ;\n            ;\n                ((((c && ((a !== !1)))) && this.queue(((a || \"fx\")), [])));\n                return this.each(function() {\n                    var b = !0, c = ((((a != null)) && ((a + \"queueHooks\")))), f = q.timers, g = q._data(this);\n                    if (c) {\n                        ((((g[c] && g[c].JSBNG__stop)) && e(g[c])));\n                    }\n                     else {\n                        {\n                            var fin37keys = ((window.top.JSBNG_Replay.forInKeys)((g))), fin37i = (0);\n                            (0);\n                            for (; (fin37i < fin37keys.length); (fin37i++)) {\n                                ((c) = (fin37keys[fin37i]));\n                                {\n                                    ((((((g[c] && g[c].JSBNG__stop)) && Uc.test(c))) && e(g[c])));\n                                ;\n                                };\n                            };\n                        };\n                    }\n                ;\n                ;\n                    for (c = f.length; c--; ) {\n                        if (((((f[c].elem === this)) && ((((a == null)) || ((f[c].queue === a))))))) {\n                            f[c].anim.JSBNG__stop(d);\n                            b = !1;\n                            f.splice(c, 1);\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    ((((b || !d)) && q.dequeue(this, a)));\n                });\n            }\n        });\n        q.each({\n            slideDown: bd(\"show\"),\n            slideUp: bd(\"hide\"),\n            slideToggle: bd(\"toggle\"),\n            fadeIn: {\n                opacity: \"show\"\n            },\n            fadeOut: {\n                opacity: \"hide\"\n            },\n            fadeToggle: {\n                opacity: \"toggle\"\n            }\n        }, function(a, b) {\n            q.fn[a] = function(a, c, d) {\n                return this.animate(b, a, c, d);\n            };\n        });\n        q.speed = function(a, b, c) {\n            var d = ((((a && ((typeof a == \"object\")))) ? q.extend({\n            }, a) : {\n                complete: ((((c || ((!c && b)))) || ((q.isFunction(a) && a)))),\n                duration: a,\n                easing: ((((c && b)) || ((((b && !q.isFunction(b))) && b))))\n            }));\n            d.duration = ((q.fx.off ? 0 : ((((typeof d.duration == \"number\")) ? d.duration : ((((d.duration in q.fx.speeds)) ? q.fx.speeds[d.duration] : q.fx.speeds._default))))));\n            if (((((d.queue == null)) || ((d.queue === !0))))) {\n                d.queue = \"fx\";\n            }\n        ;\n        ;\n            d.old = d.complete;\n            d.complete = function() {\n                ((q.isFunction(d.old) && d.old.call(this)));\n                ((d.queue && q.dequeue(this, d.queue)));\n            };\n            return d;\n        };\n        q.easing = {\n            linear: function(a) {\n                return a;\n            },\n            swing: function(a) {\n                return ((91581 - ((Math.cos(((a * Math.PI))) / 2))));\n            }\n        };\n        q.timers = [];\n        q.fx = ad.prototype.init;\n        q.fx.tick = function() {\n            var a, c = q.timers, d = 0;\n            Qc = q.now();\n            for (; ((d < c.length)); d++) {\n                a = c[d];\n                ((((!a() && ((c[d] === a)))) && c.splice(d--, 1)));\n            };\n        ;\n            ((c.length || q.fx.JSBNG__stop()));\n            Qc = b;\n        };\n        q.fx.timer = function(a) {\n            ((((((a() && q.timers.push(a))) && !Rc)) && (Rc = JSBNG__setInterval(q.fx.tick, q.fx.interval))));\n        };\n        q.fx.interval = 13;\n        q.fx.JSBNG__stop = function() {\n            JSBNG__clearInterval(Rc);\n            Rc = null;\n        };\n        q.fx.speeds = {\n            slow: 600,\n            fast: 200,\n            _default: 400\n        };\n        q.fx.step = {\n        };\n        ((((q.expr && q.expr.filters)) && (q.expr.filters.animated = function(a) {\n            return q.grep(q.timers, function(b) {\n                return ((a === b.elem));\n            }).length;\n        })));\n        var cd = /^(?:body|html)$/i;\n        q.fn.offset = function(a) {\n            if (arguments.length) {\n                return ((((a === b)) ? this : this.each(function(b) {\n                    q.offset.setOffset(this, a, b);\n                })));\n            }\n        ;\n        ;\n            var c, d, e, f, g, i, j, k = {\n                JSBNG__top: 0,\n                left: 0\n            }, l = this[0], m = ((l && l.ownerDocument));\n            if (!m) {\n                return;\n            }\n        ;\n        ;\n            if ((((d = m.body) === l))) {\n                return q.offset.bodyOffset(l);\n            }\n        ;\n        ;\n            c = m.documentElement;\n            if (!q.contains(c, l)) {\n                return k;\n            }\n        ;\n        ;\n            ((((typeof l.getBoundingClientRect != \"undefined\")) && (k = l.getBoundingClientRect())));\n            e = dd(m);\n            f = ((((c.clientTop || d.clientTop)) || 0));\n            g = ((((c.clientLeft || d.clientLeft)) || 0));\n            i = ((e.JSBNG__pageYOffset || c.scrollTop));\n            j = ((e.JSBNG__pageXOffset || c.scrollLeft));\n            return {\n                JSBNG__top: ((((k.JSBNG__top + i)) - f)),\n                left: ((((k.left + j)) - g))\n            };\n        };\n        q.offset = {\n            bodyOffset: function(a) {\n                var b = a.offsetTop, c = a.offsetLeft;\n                if (q.support.doesNotIncludeMarginInBodyOffset) {\n                    b += ((parseFloat(q.css(a, \"marginTop\")) || 0));\n                    c += ((parseFloat(q.css(a, \"marginLeft\")) || 0));\n                }\n            ;\n            ;\n                return {\n                    JSBNG__top: b,\n                    left: c\n                };\n            },\n            setOffset: function(a, b, c) {\n                var d = q.css(a, \"position\");\n                ((((d === \"static\")) && (a.style.position = \"relative\")));\n                var e = q(a), f = e.offset(), g = q.css(a, \"JSBNG__top\"), i = q.css(a, \"left\"), j = ((((((d === \"absolute\")) || ((d === \"fixed\")))) && ((q.inArray(\"auto\", [g,i,]) > -1)))), k = {\n                }, l = {\n                }, m, n;\n                if (j) {\n                    l = e.position();\n                    m = l.JSBNG__top;\n                    n = l.left;\n                }\n                 else {\n                    m = ((parseFloat(g) || 0));\n                    n = ((parseFloat(i) || 0));\n                }\n            ;\n            ;\n                ((q.isFunction(b) && (b = b.call(a, c, f))));\n                ((((b.JSBNG__top != null)) && (k.JSBNG__top = ((((b.JSBNG__top - f.JSBNG__top)) + m)))));\n                ((((b.left != null)) && (k.left = ((((b.left - f.left)) + n)))));\n                ((((\"using\" in b)) ? b.using.call(a, k) : e.css(k)));\n            }\n        };\n        q.fn.extend({\n            position: function() {\n                if (!this[0]) {\n                    return;\n                }\n            ;\n            ;\n                var a = this[0], b = this.offsetParent(), c = this.offset(), d = ((cd.test(b[0].nodeName) ? {\n                    JSBNG__top: 0,\n                    left: 0\n                } : b.offset()));\n                c.JSBNG__top -= ((parseFloat(q.css(a, \"marginTop\")) || 0));\n                c.left -= ((parseFloat(q.css(a, \"marginLeft\")) || 0));\n                d.JSBNG__top += ((parseFloat(q.css(b[0], \"borderTopWidth\")) || 0));\n                d.left += ((parseFloat(q.css(b[0], \"borderLeftWidth\")) || 0));\n                return {\n                    JSBNG__top: ((c.JSBNG__top - d.JSBNG__top)),\n                    left: ((c.left - d.left))\n                };\n            },\n            offsetParent: function() {\n                return this.map(function() {\n                    var a = ((this.offsetParent || e.body));\n                    while (((((a && !cd.test(a.nodeName))) && ((q.css(a, \"position\") === \"static\"))))) {\n                        a = a.offsetParent;\n                    ;\n                    };\n                ;\n                    return ((a || e.body));\n                });\n            }\n        });\n        q.each({\n            scrollLeft: \"JSBNG__pageXOffset\",\n            scrollTop: \"JSBNG__pageYOffset\"\n        }, function(a, c) {\n            var d = /Y/.test(c);\n            q.fn[a] = function(e) {\n                return q.access(this, function(a, e, f) {\n                    var g = dd(a);\n                    if (((f === b))) {\n                        return ((g ? ((((c in g)) ? g[c] : g.JSBNG__document.documentElement[e])) : a[e]));\n                    }\n                ;\n                ;\n                    ((g ? g.JSBNG__scrollTo(((d ? q(g).scrollLeft() : f)), ((d ? f : q(g).scrollTop()))) : a[e] = f));\n                }, a, e, arguments.length, null);\n            };\n        });\n        q.each({\n            Height: \"height\",\n            Width: \"width\"\n        }, function(a, c) {\n            q.each({\n                padding: ((\"JSBNG__inner\" + a)),\n                JSBNG__content: c,\n                \"\": ((\"JSBNG__outer\" + a))\n            }, function(d, e) {\n                q.fn[e] = function(e, f) {\n                    var g = ((arguments.length && ((d || ((typeof e != \"boolean\")))))), i = ((d || ((((((e === !0)) || ((f === !0)))) ? \"margin\" : \"border\"))));\n                    return q.access(this, function(c, d, e) {\n                        var f;\n                        if (q.isWindow(c)) {\n                            return c.JSBNG__document.documentElement[((\"client\" + a))];\n                        }\n                    ;\n                    ;\n                        if (((c.nodeType === 9))) {\n                            f = c.documentElement;\n                            return Math.max(c.body[((\"JSBNG__scroll\" + a))], f[((\"JSBNG__scroll\" + a))], c.body[((\"offset\" + a))], f[((\"offset\" + a))], f[((\"client\" + a))]);\n                        }\n                    ;\n                    ;\n                        return ((((e === b)) ? q.css(c, d, e, i) : q.style(c, d, e, i)));\n                    }, c, ((g ? e : b)), g, null);\n                };\n            });\n        });\n        a.jQuery = a.$ = q;\n        ((((((((typeof define == \"function\")) && define.amd)) && define.amd.jQuery)) && define(\"jquery\", [], function() {\n            return q;\n        })));\n    })(window);\n    (function(a) {\n        ((((typeof define == \"function\")) ? define(a) : ((((typeof YUI == \"function\")) ? YUI.add(\"es5\", a) : a()))));\n    })(function() {\n        ((Function.prototype.bind || (Function.prototype.bind = function(b) {\n            var c = this;\n            if (((typeof c != \"function\"))) {\n                throw new TypeError(((\"Function.prototype.bind called on incompatible \" + c)));\n            }\n        ;\n        ;\n            var e = d.call(arguments, 1), f = function() {\n                if (((this instanceof f))) {\n                    var a = function() {\n                    \n                    };\n                    a.prototype = c.prototype;\n                    var g = new a, i = c.apply(g, e.concat(d.call(arguments)));\n                    return ((((Object(i) === i)) ? i : g));\n                }\n            ;\n            ;\n                return c.apply(b, e.concat(d.call(arguments)));\n            };\n            return f;\n        })));\n        var a = Function.prototype.call, b = Array.prototype, c = Object.prototype, d = b.slice, e = a.bind(c.toString), f = a.bind(c.hasOwnProperty), g, i, j, k, l;\n        if (l = f(c, \"__defineGetter__\")) {\n            g = a.bind(c.__defineGetter__);\n            i = a.bind(c.__defineSetter__);\n            j = a.bind(c.__lookupGetter__);\n            k = a.bind(c.__lookupSetter__);\n        }\n    ;\n    ;\n        ((Array.isArray || (Array.isArray = function(b) {\n            return ((e(b) == \"[object Array]\"));\n        })));\n        ((Array.prototype.forEach || (Array.prototype.forEach = function(b) {\n            var c = v(this), d = arguments[1], f = -1, g = ((c.length >>> 0));\n            if (((e(b) != \"[object Function]\"))) {\n                throw new TypeError;\n            }\n        ;\n        ;\n            while (((++f < g))) {\n                ((((f in c)) && b.call(d, c[f], f, c)));\n            ;\n            };\n        ;\n        })));\n        ((Array.prototype.map || (Array.prototype.map = function(b) {\n            var c = v(this), d = ((c.length >>> 0)), f = Array(d), g = arguments[1];\n            if (((e(b) != \"[object Function]\"))) {\n                throw new TypeError(((b + \" is not a function\")));\n            }\n        ;\n        ;\n            for (var i = 0; ((i < d)); i++) {\n                ((((i in c)) && (f[i] = b.call(g, c[i], i, c))));\n            ;\n            };\n        ;\n            return f;\n        })));\n        ((Array.prototype.filter || (Array.prototype.filter = function(b) {\n            var c = v(this), d = ((c.length >>> 0)), f = [], g, i = arguments[1];\n            if (((e(b) != \"[object Function]\"))) {\n                throw new TypeError(((b + \" is not a function\")));\n            }\n        ;\n        ;\n            for (var j = 0; ((j < d)); j++) {\n                if (((j in c))) {\n                    g = c[j];\n                    ((b.call(i, g, j, c) && f.push(g)));\n                }\n            ;\n            ;\n            };\n        ;\n            return f;\n        })));\n        ((Array.prototype.every || (Array.prototype.every = function(b) {\n            var c = v(this), d = ((c.length >>> 0)), f = arguments[1];\n            if (((e(b) != \"[object Function]\"))) {\n                throw new TypeError(((b + \" is not a function\")));\n            }\n        ;\n        ;\n            for (var g = 0; ((g < d)); g++) {\n                if (((((g in c)) && !b.call(f, c[g], g, c)))) {\n                    return !1;\n                }\n            ;\n            ;\n            };\n        ;\n            return !0;\n        })));\n        ((Array.prototype.some || (Array.prototype.some = function(b) {\n            var c = v(this), d = ((c.length >>> 0)), f = arguments[1];\n            if (((e(b) != \"[object Function]\"))) {\n                throw new TypeError(((b + \" is not a function\")));\n            }\n        ;\n        ;\n            for (var g = 0; ((g < d)); g++) {\n                if (((((g in c)) && b.call(f, c[g], g, c)))) {\n                    return !0;\n                }\n            ;\n            ;\n            };\n        ;\n            return !1;\n        })));\n        ((Array.prototype.reduce || (Array.prototype.reduce = function(b) {\n            var c = v(this), d = ((c.length >>> 0));\n            if (((e(b) != \"[object Function]\"))) {\n                throw new TypeError(((b + \" is not a function\")));\n            }\n        ;\n        ;\n            if (((!d && ((arguments.length == 1))))) {\n                throw new TypeError(\"reduce of empty array with no initial value\");\n            }\n        ;\n        ;\n            var f = 0, g;\n            if (((arguments.length >= 2))) {\n                g = arguments[1];\n            }\n             else {\n                do {\n                    if (((f in c))) {\n                        g = c[f++];\n                        break;\n                    }\n                ;\n                ;\n                    if (((++f >= d))) {\n                        throw new TypeError(\"reduce of empty array with no initial value\");\n                    }\n                ;\n                ;\n                } while (!0);\n            }\n        ;\n        ;\n            for (; ((f < d)); f++) {\n                ((((f in c)) && (g = b.call(void 0, g, c[f], f, c))));\n            ;\n            };\n        ;\n            return g;\n        })));\n        ((Array.prototype.reduceRight || (Array.prototype.reduceRight = function(b) {\n            var c = v(this), d = ((c.length >>> 0));\n            if (((e(b) != \"[object Function]\"))) {\n                throw new TypeError(((b + \" is not a function\")));\n            }\n        ;\n        ;\n            if (((!d && ((arguments.length == 1))))) {\n                throw new TypeError(\"reduceRight of empty array with no initial value\");\n            }\n        ;\n        ;\n            var f, g = ((d - 1));\n            if (((arguments.length >= 2))) {\n                f = arguments[1];\n            }\n             else {\n                do {\n                    if (((g in c))) {\n                        f = c[g--];\n                        break;\n                    }\n                ;\n                ;\n                    if (((--g < 0))) {\n                        throw new TypeError(\"reduceRight of empty array with no initial value\");\n                    }\n                ;\n                ;\n                } while (!0);\n            }\n        ;\n        ;\n            do ((((g in this)) && (f = b.call(void 0, f, c[g], g, c)))); while (g--);\n            return f;\n        })));\n        ((Array.prototype.indexOf || (Array.prototype.indexOf = function(b) {\n            var c = v(this), d = ((c.length >>> 0));\n            if (!d) {\n                return -1;\n            }\n        ;\n        ;\n            var e = 0;\n            ((((arguments.length > 1)) && (e = t(arguments[1]))));\n            e = ((((e >= 0)) ? e : Math.max(0, ((d + e)))));\n            for (; ((e < d)); e++) {\n                if (((((e in c)) && ((c[e] === b))))) {\n                    return e;\n                }\n            ;\n            ;\n            };\n        ;\n            return -1;\n        })));\n        ((Array.prototype.lastIndexOf || (Array.prototype.lastIndexOf = function(b) {\n            var c = v(this), d = ((c.length >>> 0));\n            if (!d) {\n                return -1;\n            }\n        ;\n        ;\n            var e = ((d - 1));\n            ((((arguments.length > 1)) && (e = Math.min(e, t(arguments[1])))));\n            e = ((((e >= 0)) ? e : ((d - Math.abs(e)))));\n            for (; ((e >= 0)); e--) {\n                if (((((e in c)) && ((b === c[e]))))) {\n                    return e;\n                }\n            ;\n            ;\n            };\n        ;\n            return -1;\n        })));\n        if (!Object.keys) {\n            var m = !0, n = [\"toString\",\"toLocaleString\",\"valueOf\",\"hasOwnProperty\",\"isPrototypeOf\",\"propertyIsEnumerable\",\"constructor\",], o = n.length;\n            {\n                var fin38keys = ((window.top.JSBNG_Replay.forInKeys)(({\n                    toString: null\n                }))), fin38i = (0);\n                var p;\n                for (; (fin38i < fin38keys.length); (fin38i++)) {\n                    ((p) = (fin38keys[fin38i]));\n                    {\n                        m = !1;\n                    ;\n                    };\n                };\n            };\n        ;\n            Object.keys = function w(a) {\n                if (((((((typeof a != \"object\")) && ((typeof a != \"function\")))) || ((a === null))))) {\n                    throw new TypeError(\"Object.keys called on a non-object\");\n                }\n            ;\n            ;\n                var w = [];\n                {\n                    var fin39keys = ((window.top.JSBNG_Replay.forInKeys)((a))), fin39i = (0);\n                    var b;\n                    for (; (fin39i < fin39keys.length); (fin39i++)) {\n                        ((b) = (fin39keys[fin39i]));\n                        {\n                            ((f(a, b) && w.push(b)));\n                        ;\n                        };\n                    };\n                };\n            ;\n                if (m) {\n                    for (var c = 0, d = o; ((c < d)); c++) {\n                        var e = n[c];\n                        ((f(a, e) && w.push(e)));\n                    };\n                }\n            ;\n            ;\n                return w;\n            };\n        }\n    ;\n    ;\n        if (((!JSBNG__Date.prototype.toISOString || (((new JSBNG__Date(-62198755200000)).toISOString().indexOf(\"-000001\") === -1))))) {\n            JSBNG__Date.prototype.toISOString = function() {\n                var b, c, d, e;\n                if (!isFinite(this)) {\n                    throw new RangeError(\"JSBNG__Date.prototype.toISOString called on non-finite value.\");\n                }\n            ;\n            ;\n                b = [((this.getUTCMonth() + 1)),this.getUTCDate(),this.getUTCHours(),this.getUTCMinutes(),this.getUTCSeconds(),];\n                e = this.getUTCFullYear();\n                e = ((((((e < 0)) ? \"-\" : ((((e > 9999)) ? \"+\" : \"\")))) + ((\"00000\" + Math.abs(e))).slice(((((((0 <= e)) && ((e <= 9999)))) ? -4 : -6)))));\n                c = b.length;\n                while (c--) {\n                    d = b[c];\n                    ((((d < 10)) && (b[c] = ((\"0\" + d)))));\n                };\n            ;\n                return ((((((((((((((e + \"-\")) + b.slice(0, 2).join(\"-\"))) + \"T\")) + b.slice(2).join(\":\"))) + \".\")) + ((\"000\" + this.getUTCMilliseconds())).slice(-3))) + \"Z\"));\n            };\n        }\n    ;\n    ;\n        ((JSBNG__Date.now || (JSBNG__Date.now = function() {\n            return (new JSBNG__Date).getTime();\n        })));\n        ((JSBNG__Date.prototype.toJSON || (JSBNG__Date.prototype.toJSON = function(b) {\n            if (((typeof this.toISOString != \"function\"))) {\n                throw new TypeError(\"toISOString property is not callable\");\n            }\n        ;\n        ;\n            return this.toISOString();\n        })));\n        if (((!JSBNG__Date.parse || ((JSBNG__Date.parse(\"+275760-09-13T00:00:00.000Z\") !== 8640000000000000))))) {\n            JSBNG__Date = function(a) {\n                var b = function e(b, c, d, h, f, g, i) {\n                    var j = arguments.length;\n                    if (((this instanceof a))) {\n                        var k = ((((((j == 1)) && ((String(b) === b)))) ? new a(e.parse(b)) : ((((j >= 7)) ? new a(b, c, d, h, f, g, i) : ((((j >= 6)) ? new a(b, c, d, h, f, g) : ((((j >= 5)) ? new a(b, c, d, h, f) : ((((j >= 4)) ? new a(b, c, d, h) : ((((j >= 3)) ? new a(b, c, d) : ((((j >= 2)) ? new a(b, c) : ((((j >= 1)) ? new a(b) : new a))))))))))))))));\n                        k.constructor = e;\n                        return k;\n                    }\n                ;\n                ;\n                    return a.apply(this, arguments);\n                }, c = new RegExp(\"^(\\\\d{4}|[+-]\\\\d{6})(?:-(\\\\d{2})(?:-(\\\\d{2})(?:T(\\\\d{2}):(\\\\d{2})(?::(\\\\d{2})(?:\\\\.(\\\\d{3}))?)?(?:Z|(?:([-+])(\\\\d{2}):(\\\\d{2})))?)?)?)?$\");\n                {\n                    var fin40keys = ((window.top.JSBNG_Replay.forInKeys)((a))), fin40i = (0);\n                    var d;\n                    for (; (fin40i < fin40keys.length); (fin40i++)) {\n                        ((d) = (fin40keys[fin40i]));\n                        {\n                            b[d] = a[d];\n                        ;\n                        };\n                    };\n                };\n            ;\n                b.now = a.now;\n                b.UTC = a.UTC;\n                b.prototype = a.prototype;\n                b.prototype.constructor = b;\n                b.parse = function(d) {\n                    var e = c.exec(d);\n                    if (e) {\n                        e.shift();\n                        for (var f = 1; ((f < 7)); f++) {\n                            e[f] = +((e[f] || ((((f < 3)) ? 1 : 0))));\n                            ((((f == 1)) && e[f]--));\n                        };\n                    ;\n                        var g = +e.pop(), i = +e.pop(), j = e.pop(), k = 0;\n                        if (j) {\n                            if (((((i > 23)) || ((g > 59))))) {\n                                return NaN;\n                            }\n                        ;\n                        ;\n                            k = ((((((((i * 60)) + g)) * 60000)) * ((((j == \"+\")) ? -1 : 1))));\n                        }\n                    ;\n                    ;\n                        var l = +e[0];\n                        if (((((0 <= l)) && ((l <= 99))))) {\n                            e[0] = ((l + 400));\n                            return ((((a.UTC.apply(this, e) + k)) - 12622780800000));\n                        }\n                    ;\n                    ;\n                        return ((a.UTC.apply(this, e) + k));\n                    }\n                ;\n                ;\n                    return a.parse.apply(this, arguments);\n                };\n                return b;\n            }(JSBNG__Date);\n        }\n    ;\n    ;\n        var q = \"\\u0009\\u000a\\u000b\\u000c\\u000d \\u00a0\\u1680\\u180e\\u2000\\u2001\\u2002\\u2003\\u2004\\u2005\\u2006\\u2007\\u2008\\u2009\\u200a\\u202f\\u205f\\u3000\\u2028\\u2029\\ufeff\";\n        if (((!String.prototype.trim || q.trim()))) {\n            q = ((((\"[\" + q)) + \"]\"));\n            var r = new RegExp(((((((\"^\" + q)) + q)) + \"*\"))), s = new RegExp(((((q + q)) + \"*$\")));\n            String.prototype.trim = function() {\n                if (((((this === undefined)) || ((this === null))))) {\n                    throw new TypeError(((((\"can't convert \" + this)) + \" to object\")));\n                }\n            ;\n            ;\n                return String(this).replace(r, \"\").replace(s, \"\");\n            };\n        }\n    ;\n    ;\n        var t = function(a) {\n            a = +a;\n            ((((a !== a)) ? a = 0 : ((((((((a !== 0)) && ((a !== ((1 / 0)))))) && ((a !== -Infinity)))) && (a = ((((((a > 0)) || -1)) * Math.floor(Math.abs(a)))))))));\n            return a;\n        }, u = ((\"a\"[0] != \"a\")), v = function(a) {\n            if (((a == null))) {\n                throw new TypeError(((((\"can't convert \" + a)) + \" to object\")));\n            }\n        ;\n        ;\n            return ((((((u && ((typeof a == \"string\")))) && a)) ? a.split(\"\") : Object(a)));\n        };\n    });\n    (function(a) {\n        ((((typeof define == \"function\")) ? define(a) : ((((typeof YUI == \"function\")) ? YUI.add(\"es5-sham\", a) : a()))));\n    })(function() {\n        function b(a) {\n            try {\n                Object.defineProperty(a, \"sentinel\", {\n                });\n                return ((\"sentinel\" in a));\n            } catch (b) {\n            \n            };\n        ;\n        };\n    ;\n        ((Object.getPrototypeOf || (Object.getPrototypeOf = function(b) {\n            return ((b.__proto__ || ((b.constructor ? b.constructor.prototype : prototypeOfObject))));\n        })));\n        if (!Object.getOwnPropertyDescriptor) {\n            var a = \"Object.getOwnPropertyDescriptor called on a non-object: \";\n            Object.getOwnPropertyDescriptor = function(c, d) {\n                if (((((((typeof c != \"object\")) && ((typeof c != \"function\")))) || ((c === null))))) {\n                    throw new TypeError(((a + c)));\n                }\n            ;\n            ;\n                if (!owns(c, d)) {\n                    return;\n                }\n            ;\n            ;\n                var e = {\n                    enumerable: !0,\n                    configurable: !0\n                };\n                if (supportsAccessors) {\n                    var f = c.__proto__;\n                    c.__proto__ = prototypeOfObject;\n                    var g = lookupGetter(c, d), i = lookupSetter(c, d);\n                    c.__proto__ = f;\n                    if (((g || i))) {\n                        ((g && (e.get = g)));\n                        ((i && (e.set = i)));\n                        return e;\n                    }\n                ;\n                ;\n                }\n            ;\n            ;\n                e.value = c[d];\n                return e;\n            };\n        }\n    ;\n    ;\n        ((Object.getOwnPropertyNames || (Object.getOwnPropertyNames = function(b) {\n            return Object.keys(b);\n        })));\n        ((Object.create || (Object.create = function(b, c) {\n            var d;\n            if (((b === null))) d = {\n                __proto__: null\n            };\n             else {\n                if (((typeof b != \"object\"))) {\n                    throw new TypeError(((((\"typeof prototype[\" + typeof b)) + \"] != 'object'\")));\n                }\n            ;\n            ;\n                var e = function() {\n                \n                };\n                e.prototype = b;\n                d = new e;\n                d.__proto__ = b;\n            }\n        ;\n        ;\n            ((((c !== void 0)) && Object.defineProperties(d, c)));\n            return d;\n        })));\n        if (Object.defineProperty) {\n            var c = b({\n            }), d = ((((typeof JSBNG__document == \"undefined\")) || b(JSBNG__document.createElement(\"div\"))));\n            if (((!c || !d))) {\n                var e = Object.defineProperty;\n            }\n        ;\n        ;\n        }\n    ;\n    ;\n        if (((!Object.defineProperty || e))) {\n            var f = \"Property description must be an object: \", g = \"Object.defineProperty called on non-object: \", i = \"getters & setters can not be defined on this javascript engine\";\n            Object.defineProperty = function(b, c, d) {\n                if (((((((typeof b != \"object\")) && ((typeof b != \"function\")))) || ((b === null))))) {\n                    throw new TypeError(((g + b)));\n                }\n            ;\n            ;\n                if (((((((typeof d != \"object\")) && ((typeof d != \"function\")))) || ((d === null))))) {\n                    throw new TypeError(((f + d)));\n                }\n            ;\n            ;\n                if (e) {\n                    try {\n                        return e.call(Object, b, c, d);\n                    } catch (j) {\n                    \n                    };\n                }\n            ;\n            ;\n                if (owns(d, \"value\")) if (((supportsAccessors && ((lookupGetter(b, c) || lookupSetter(b, c)))))) {\n                    var k = b.__proto__;\n                    b.__proto__ = prototypeOfObject;\n                    delete b[c];\n                    b[c] = d.value;\n                    b.__proto__ = k;\n                }\n                 else b[c] = d.value;\n                \n                 else {\n                    if (!supportsAccessors) {\n                        throw new TypeError(i);\n                    }\n                ;\n                ;\n                    ((owns(d, \"get\") && defineGetter(b, c, d.get)));\n                    ((owns(d, \"set\") && defineSetter(b, c, d.set)));\n                }\n            ;\n            ;\n                return b;\n            };\n        }\n    ;\n    ;\n        ((Object.defineProperties || (Object.defineProperties = function(b, c) {\n            {\n                var fin41keys = ((window.top.JSBNG_Replay.forInKeys)((c))), fin41i = (0);\n                var d;\n                for (; (fin41i < fin41keys.length); (fin41i++)) {\n                    ((d) = (fin41keys[fin41i]));\n                    {\n                        ((((owns(c, d) && ((d != \"__proto__\")))) && Object.defineProperty(b, d, c[d])));\n                    ;\n                    };\n                };\n            };\n        ;\n            return b;\n        })));\n        ((Object.seal || (Object.seal = function(b) {\n            return b;\n        })));\n        ((Object.freeze || (Object.freeze = function(b) {\n            return b;\n        })));\n        try {\n            Object.freeze(function() {\n            \n            });\n        } catch (j) {\n            Object.freeze = function(b) {\n                return function(c) {\n                    return ((((typeof c == \"function\")) ? c : b(c)));\n                };\n            }(Object.freeze);\n        };\n    ;\n        ((Object.preventExtensions || (Object.preventExtensions = function(b) {\n            return b;\n        })));\n        ((Object.isSealed || (Object.isSealed = function(b) {\n            return !1;\n        })));\n        ((Object.isFrozen || (Object.isFrozen = function(b) {\n            return !1;\n        })));\n        ((Object.isExtensible || (Object.isExtensible = function(b) {\n            if (((Object(b) !== b))) {\n                throw new TypeError;\n            }\n        ;\n        ;\n            var c = \"\";\n            while (owns(b, c)) {\n                c += \"?\";\n            ;\n            };\n        ;\n            b[c] = !0;\n            var d = owns(b, c);\n            delete b[c];\n            return d;\n        })));\n    });\n    (function(a, b) {\n        function t(a) {\n            for (var b = 1, c; c = arguments[b]; b++) {\n                {\n                    var fin42keys = ((window.top.JSBNG_Replay.forInKeys)((c))), fin42i = (0);\n                    var d;\n                    for (; (fin42i < fin42keys.length); (fin42i++)) {\n                        ((d) = (fin42keys[fin42i]));\n                        {\n                            a[d] = c[d];\n                        ;\n                        };\n                    };\n                };\n            ;\n            };\n        ;\n            return a;\n        };\n    ;\n        function u(a) {\n            return Array.prototype.slice.call(a);\n        };\n    ;\n        function w(a, b) {\n            for (var c = 0, d; d = a[c]; c++) {\n                if (((b == d))) {\n                    return c;\n                }\n            ;\n            ;\n            };\n        ;\n            return -1;\n        };\n    ;\n        function x() {\n            var a = u(arguments), b = [];\n            for (var c = 0, d = a.length; ((c < d)); c++) {\n                ((((a[c].length > 0)) && b.push(a[c].replace(/\\/$/, \"\"))));\n            ;\n            };\n        ;\n            return b.join(\"/\");\n        };\n    ;\n        function y(a, b, c) {\n            var d = b.split(\"/\"), e = a;\n            while (((d.length > 1))) {\n                var f = d.shift();\n                e = e[f] = ((e[f] || {\n                }));\n            };\n        ;\n            e[d[0]] = c;\n        };\n    ;\n        function z() {\n        \n        };\n    ;\n        function A(a, b) {\n            ((a && (this.id = this.path = this.resolvePath(a))));\n            this.originalPath = a;\n            this.force = !!b;\n        };\n    ;\n        function B(a, b) {\n            this.id = a;\n            this.path = this.resolvePath(a);\n            this.force = b;\n        };\n    ;\n        function C(a, b) {\n            this.id = a;\n            this.contents = b;\n            this.dep = O(a);\n            this.deps = [];\n            this.path = this.dep.path;\n        };\n    ;\n        function D(a, b) {\n            var d;\n            this.body = b;\n            if (!a) if (c) {\n                d = ((i || K()));\n                if (d) {\n                    this.setId(d.id);\n                    delete j[d.scriptId];\n                    this.then(function(a) {\n                        d.complete.call(d, a);\n                    });\n                }\n            ;\n            ;\n            }\n             else g = this;\n            \n             else {\n                this.setId(a);\n                (((d = p[((\"module_\" + this.id))]) && this.then(function(a) {\n                    d.complete.call(d, a);\n                })));\n            }\n        ;\n        ;\n        };\n    ;\n        function E(a) {\n            var b = [];\n            for (var c = 0, d; d = a[c]; c++) {\n                ((((d instanceof H)) ? b = b.concat(E(d.deps)) : ((((d instanceof B)) && b.push(d)))));\n            ;\n            };\n        ;\n            return b;\n        };\n    ;\n        function F() {\n            for (var a = 0, b; b = this.deps[a]; a++) {\n                if (b.forceFetch) b.forceFetch();\n                 else {\n                    b.force = !0;\n                    b.start();\n                }\n            ;\n            ;\n            };\n        ;\n            return this;\n        };\n    ;\n        function G(a) {\n            this.deps = a;\n            ((((this.deps.length == 0)) && this.complete()));\n        };\n    ;\n        function H(a) {\n            this.deps = a;\n        };\n    ;\n        function J() {\n            this.entries = {\n            };\n        };\n    ;\n        function K() {\n            {\n                var fin43keys = ((window.top.JSBNG_Replay.forInKeys)((d))), fin43i = (0);\n                var a;\n                for (; (fin43i < fin43keys.length); (fin43i++)) {\n                    ((a) = (fin43keys[fin43i]));\n                    {\n                        if (((d[a].readyState == \"interactive\"))) {\n                            return j[d[a].id];\n                        }\n                    ;\n                    ;\n                    };\n                };\n            };\n        ;\n        };\n    ;\n        function L() {\n            var a = u(arguments), b, c;\n            ((((typeof a[0] == \"string\")) && (b = a.shift())));\n            c = a.shift();\n            return new D(b, c);\n        };\n    ;\n        function M() {\n            var a = u(arguments), b;\n            ((((typeof a[((a.length - 1))] == \"function\")) && (b = a.pop())));\n            var c = new G(N(a));\n            ((b && c.then(b)));\n            return c;\n        };\n    ;\n        function N(a) {\n            var b = [];\n            for (var c = 0, d; d = a[c]; c++) {\n                ((((typeof d == \"string\")) && (d = O(d))));\n                ((v(d) && (d = new H(N(d)))));\n                b.push(d);\n            };\n        ;\n            return b;\n        };\n    ;\n        function O(a) {\n            var b, c;\n            for (var d = 0, e; e = M.matchers[d]; d++) {\n                var f = e[0], g = e[1];\n                if (b = a.match(f)) {\n                    return g(a);\n                }\n            ;\n            ;\n            };\n        ;\n            throw new Error(((a + \" was not recognised by loader\")));\n        };\n    ;\n        function Q() {\n            a.using = k;\n            a.provide = l;\n            a.loadrunner = m;\n            return P;\n        };\n    ;\n        function R(a) {\n            function d(b, d) {\n                c[d] = ((c[d] || {\n                }));\n                c[d][a] = {\n                    key: a,\n                    start: b.startTime,\n                    end: b.endTime,\n                    duration: ((b.endTime - ((b.startTime || (new JSBNG__Date).getTime())))),\n                    JSBNG__status: d,\n                    origin: b\n                };\n            };\n        ;\n            var b, c = {\n            };\n            if (((a && (((((b = o[a]) || (b = p[a]))) || (b = n[a])))))) {\n                return {\n                    start: b.startTime,\n                    end: b.endTime,\n                    duration: ((b.endTime - ((b.startTime || (new JSBNG__Date).getTime())))),\n                    origin: b\n                };\n            }\n        ;\n        ;\n            {\n                var fin44keys = ((window.top.JSBNG_Replay.forInKeys)((o))), fin44i = (0);\n                var a;\n                for (; (fin44i < fin44keys.length); (fin44i++)) {\n                    ((a) = (fin44keys[fin44i]));\n                    {\n                        d(o[a], \"met\");\n                    ;\n                    };\n                };\n            };\n        ;\n            {\n                var fin45keys = ((window.top.JSBNG_Replay.forInKeys)((p))), fin45i = (0);\n                var a;\n                for (; (fin45i < fin45keys.length); (fin45i++)) {\n                    ((a) = (fin45keys[fin45i]));\n                    {\n                        d(p[a], \"inProgress\");\n                    ;\n                    };\n                };\n            };\n        ;\n            {\n                var fin46keys = ((window.top.JSBNG_Replay.forInKeys)((n))), fin46i = (0);\n                var a;\n                for (; (fin46i < fin46keys.length); (fin46i++)) {\n                    ((a) = (fin46keys[fin46i]));\n                    {\n                        d(n[a], \"paused\");\n                    ;\n                    };\n                };\n            };\n        ;\n            return c;\n        };\n    ;\n        function S() {\n            n = {\n            };\n            o = {\n            };\n            p = {\n            };\n            M.bundles = new J;\n            B.exports = {\n            };\n            D.provided = {\n            };\n        };\n    ;\n        function T(a) {\n            return ((M.bundles.get(a) || undefined));\n        };\n    ;\n        var c = ((a.JSBNG__attachEvent && !a.JSBNG__opera)), d = b.getElementsByTagName(\"script\"), e, f = b.createElement(\"script\"), g, i, j = {\n        }, k = a.using, l = a.provide, m = a.loadrunner, n = {\n        }, o = {\n        }, p = {\n        };\n        for (var q = 0, r; r = d[q]; q++) {\n            if (r.src.match(/loadrunner\\.js(\\?|#|$)/)) {\n                e = r;\n                break;\n            }\n        ;\n        ;\n        };\n    ;\n        var s = function() {\n            var a = 0;\n            return function() {\n                return a++;\n            };\n        }(), v = ((Array.isArray || function(a) {\n            return ((a.constructor == Array));\n        }));\n        z.prototype.then = function(b) {\n            this.callbacks = ((this.callbacks || []));\n            this.callbacks.push(b);\n            ((this.completed ? b.apply(a, this.results) : ((((this.callbacks.length == 1)) && this.start()))));\n            return this;\n        };\n        z.prototype.key = function() {\n            ((this.id || (this.id = s())));\n            return ((\"dependency_\" + this.id));\n        };\n        z.prototype.start = function() {\n            var a = this, b, c;\n            this.startTime = (new JSBNG__Date).getTime();\n            if (b = o[this.key()]) {\n                this.complete.apply(this, b.results);\n            }\n             else {\n                if (c = p[this.key()]) {\n                    c.then(function() {\n                        a.complete.apply(a, arguments);\n                    });\n                }\n                 else {\n                    if (this.shouldFetch()) {\n                        p[this.key()] = this;\n                        this.fetch();\n                    }\n                     else {\n                        n[this.key()] = ((n[this.key()] || []));\n                        n[this.key()].push(this);\n                    }\n                ;\n                }\n            ;\n            }\n        ;\n        ;\n        };\n        z.prototype.shouldFetch = function() {\n            return !0;\n        };\n        z.prototype.complete = function() {\n            var b;\n            this.endTime = (new JSBNG__Date).getTime();\n            delete p[this.key()];\n            ((o[this.key()] || (o[this.key()] = this)));\n            if (!this.completed) {\n                this.results = u(arguments);\n                this.completed = !0;\n                if (this.callbacks) {\n                    for (var c = 0, d; d = this.callbacks[c]; c++) {\n                        d.apply(a, this.results);\n                    ;\n                    };\n                }\n            ;\n            ;\n                if (b = n[this.key()]) {\n                    for (var c = 0, e; e = b[c]; c++) {\n                        e.complete.apply(e, arguments);\n                    ;\n                    };\n                ;\n                    delete n[this.key()];\n                }\n            ;\n            ;\n            }\n        ;\n        ;\n        };\n        A.autoFetch = !0;\n        A.xhrTransport = function() {\n            var a, b = this;\n            if (window.JSBNG__XMLHttpRequest) {\n                a = new window.JSBNG__XMLHttpRequest;\n            }\n             else {\n                try {\n                    a = new window.ActiveXObject(\"Microsoft.XMLHTTP\");\n                } catch (c) {\n                    return new Error(\"XHR not found.\");\n                };\n            }\n        ;\n        ;\n            a.onreadystatechange = function() {\n                var c;\n                ((((a.readyState == 4)) && b.loaded(a.responseText)));\n            };\n            a.open(\"GET\", this.path, !0);\n            a.send(null);\n        };\n        A.scriptTagTransport = function() {\n            var b = f.cloneNode(!1), c = this;\n            this.scriptId = ((\"LR\" + s()));\n            b.id = this.scriptId;\n            b.type = \"text/javascript\";\n            b.async = !0;\n            b.JSBNG__onerror = function() {\n                throw new Error(((c.path + \" not loaded\")));\n            };\n            b.onreadystatechange = b.JSBNG__onload = function(b) {\n                b = ((a.JSBNG__event || b));\n                if (((((b.type == \"load\")) || ((w([\"loaded\",\"complete\",], this.readyState) > -1))))) {\n                    this.onreadystatechange = null;\n                    c.loaded();\n                }\n            ;\n            ;\n            };\n            b.src = this.path;\n            i = this;\n            d[0].parentNode.insertBefore(b, d[0]);\n            i = null;\n            j[this.scriptId] = this;\n        };\n        A.prototype = new z;\n        A.prototype.start = function() {\n            var a = this, b;\n            (((def = D.provided[this.originalPath]) ? def.then(function() {\n                a.complete();\n            }) : (((b = T(this.originalPath)) ? b.then(function() {\n                a.start();\n            }) : z.prototype.start.call(this)))));\n        };\n        A.prototype.resolvePath = function(a) {\n            a = a.replace(/^\\$/, ((M.path.replace(/\\/$/, \"\") + \"/\")));\n            return a;\n        };\n        A.prototype.key = function() {\n            return ((\"script_\" + this.id));\n        };\n        A.prototype.shouldFetch = function() {\n            return ((A.autoFetch || this.force));\n        };\n        A.prototype.fetch = A.scriptTagTransport;\n        A.prototype.loaded = function() {\n            this.complete();\n        };\n        B.exports = {\n        };\n        B.prototype = new A;\n        B.prototype.start = function() {\n            var a = this, b, c;\n            (((b = D.provided[this.id]) ? b.then(function(b) {\n                a.complete.call(a, b);\n            }) : (((c = T(this.id)) ? c.then(function() {\n                a.start();\n            }) : A.prototype.start.call(this)))));\n        };\n        B.prototype.key = function() {\n            return ((\"module_\" + this.id));\n        };\n        B.prototype.resolvePath = function(a) {\n            return x(M.path, ((a + \".js\")));\n        };\n        B.prototype.loaded = function() {\n            var a, b, d = this;\n            if (!c) {\n                a = g;\n                g = null;\n                if (a) {\n                    a.setId(this.id);\n                    a.then(function(a) {\n                        d.complete.call(d, a);\n                    });\n                }\n                 else if (!D.provided[this.id]) {\n                    throw new Error(((((\"Tried to load '\" + this.id)) + \"' as a module, but it didn't have a 'provide()' in it.\")));\n                }\n                \n            ;\n            ;\n            }\n        ;\n        ;\n        };\n        C.prototype = new A;\n        C.prototype.start = function() {\n            var a = this, b, c, d;\n            for (var e = 0, f = this.contents.length; ((e < f)); e++) {\n                c = O(this.contents[e]);\n                this.deps.push(c);\n                d = c.key();\n                ((((((!o[d] && !p[d])) && !n[d])) && (n[d] = this)));\n            };\n        ;\n            A.prototype.start.call(this);\n        };\n        C.prototype.loaded = function() {\n            var a, b, c = this, d, e;\n            for (var f = 0, g = this.deps.length; ((f < g)); f++) {\n                d = this.deps[f];\n                e = d.key();\n                delete n[e];\n                o[e] = this;\n            };\n        ;\n            A.prototype.loaded.call(this);\n        };\n        D.provided = {\n        };\n        D.prototype = new z;\n        D.prototype.key = function() {\n            ((this.id || (this.id = ((\"anon_\" + s())))));\n            return ((\"definition_\" + this.id));\n        };\n        D.prototype.setId = function(a) {\n            this.id = a;\n            D.provided[a] = this;\n        };\n        D.prototype.fetch = function() {\n            var a = this;\n            ((((typeof this.body == \"object\")) ? this.complete(this.body) : ((((typeof this.body == \"function\")) && this.body(function(b) {\n                a.complete(b);\n            })))));\n        };\n        D.prototype.complete = function(a) {\n            a = ((a || {\n            }));\n            ((this.id && (this.exports = B.exports[this.id] = a)));\n            z.prototype.complete.call(this, a);\n        };\n        G.prototype = new z;\n        G.prototype.fetch = function() {\n            function b() {\n                var b = [];\n                for (var c = 0, d; d = a.deps[c]; c++) {\n                    if (!d.completed) {\n                        return;\n                    }\n                ;\n                ;\n                    ((((d.results.length > 0)) && (b = b.concat(d.results))));\n                };\n            ;\n                a.complete.apply(a, b);\n            };\n        ;\n            var a = this;\n            for (var c = 0, d; d = this.deps[c]; c++) {\n                d.then(b);\n            ;\n            };\n        ;\n            return this;\n        };\n        G.prototype.forceFetch = F;\n        G.prototype.as = function(a) {\n            var b = this;\n            return this.then(function() {\n                var c = E(b.deps), d = {\n                };\n                for (var e = 0, f; f = c[e]; e++) {\n                    y(d, f.id, arguments[e]);\n                ;\n                };\n            ;\n                a.apply(this, [d,].concat(u(arguments)));\n            });\n        };\n        H.prototype = new z;\n        H.prototype.fetch = function() {\n            var a = this, b = 0, c = [];\n            (function d() {\n                var e = a.deps[b++];\n                ((e ? e.then(function(a) {\n                    ((((e.results.length > 0)) && (c = c.concat(e.results))));\n                    d();\n                }) : a.complete.apply(a, c)));\n            })();\n            return this;\n        };\n        H.prototype.forceFetch = F;\n        var I = [];\n        J.prototype.push = function(a) {\n            {\n                var fin47keys = ((window.top.JSBNG_Replay.forInKeys)((a))), fin47i = (0);\n                var b;\n                for (; (fin47i < fin47keys.length); (fin47i++)) {\n                    ((b) = (fin47keys[fin47i]));\n                    {\n                        I[b] = new C(b, a[b]);\n                        for (var c = 0, d; d = a[b][c]; c++) {\n                            this.entries[d] = I[b];\n                        ;\n                        };\n                    ;\n                    };\n                };\n            };\n        ;\n        };\n        J.prototype.get = function(a) {\n            return this.entries[a];\n        };\n        var P = function(a) {\n            return a(M, L, P);\n        };\n        P.Script = A;\n        P.Module = B;\n        P.Collection = G;\n        P.Sequence = H;\n        P.Definition = D;\n        P.Dependency = z;\n        P.noConflict = Q;\n        P.debug = R;\n        P.reset = S;\n        a.loadrunner = P;\n        a.using = M;\n        a.provide = L;\n        M.path = \"\";\n        M.bundles = new J;\n        M.matchers = [];\n        M.matchers.add = function(a, b) {\n            this.unshift([a,b,]);\n        };\n        M.matchers.add(/^(lr!)?[a-zA-Z0-9_\\/.-]+$/, function(a) {\n            var b = new B(a.replace(/^lr!/, \"\"));\n            return b;\n        });\n        M.matchers.add(/(^script!|\\.js$)/, function(a) {\n            var b = new A(a.replace(/^script!/, \"\"));\n            return b;\n        });\n        if (e) {\n            M.path = ((((e.getAttribute(\"data-path\") || e.src.split(/loadrunner\\.js/)[0])) || \"\"));\n            (((main = e.getAttribute(\"data-main\")) && M.apply(a, main.split(/\\s*,\\s*/)).then(function() {\n            \n            })));\n        }\n    ;\n    ;\n    })(this, JSBNG__document);\n    (function(a) {\n        loadrunner(function(b, c) {\n            function e(a, b) {\n                return new loadrunner.Definition(a, function(a) {\n                    a(b());\n                });\n            };\n        ;\n            var d;\n            a.deferred = e;\n            b.matchers.add(/(^script!|\\.js(!?)$)/, function(a) {\n                var b = !!a.match(/!$/);\n                a = a.replace(/!$/, \"\");\n                if (d = loadrunner.Definition.provided[a]) {\n                    return d;\n                }\n            ;\n            ;\n                var c = new loadrunner.Script(a, b);\n                ((b && c.start()));\n                return c;\n            });\n        });\n    })(this);\n    (function(a) {\n        loadrunner(function(b, c) {\n            function d(a) {\n                return Array.prototype.slice.call(a);\n            };\n        ;\n            function f(a, b) {\n                for (var c = 0, d; d = a[c]; c++) {\n                    if (((b == d))) {\n                        return c;\n                    }\n                ;\n                ;\n                };\n            ;\n                return -1;\n            };\n        ;\n            function g(a, b) {\n                var c = ((b.id || \"\")), d = c.split(\"/\");\n                d.pop();\n                var e = a.split(\"/\"), f = !1;\n                while (((((e[0] == \"..\")) && d.length))) {\n                    d.pop();\n                    e.shift();\n                    f = !0;\n                };\n            ;\n                if (((e[0] == \".\"))) {\n                    e.shift();\n                    f = !0;\n                }\n            ;\n            ;\n                ((f && (e = d.concat(e))));\n                return e.join(\"/\");\n            };\n        ;\n            function i(a, b) {\n                function d(a) {\n                    return loadrunner.Module.exports[g(a.replace(/^.+!/, \"\"), b)];\n                };\n            ;\n                var c = [];\n                for (var e = 0, f = a.length; ((e < f)); e++) {\n                    if (((a[e] == \"require\"))) {\n                        c.push(d);\n                        continue;\n                    }\n                ;\n                ;\n                    if (((a[e] == \"exports\"))) {\n                        b.exports = ((b.exports || {\n                        }));\n                        c.push(b.exports);\n                        continue;\n                    }\n                ;\n                ;\n                    if (((a[e] == \"module\"))) {\n                        c.push(b);\n                        continue;\n                    }\n                ;\n                ;\n                    c.push(d(a[e]));\n                };\n            ;\n                return c;\n            };\n        ;\n            function j() {\n                var a = d(arguments), c = [], j, k;\n                ((((typeof a[0] == \"string\")) && (j = a.shift())));\n                ((e(a[0]) && (c = a.shift())));\n                k = a.shift();\n                var l = new loadrunner.Definition(j, function(a) {\n                    function l() {\n                        var b = i(d(c), j), e;\n                        ((((typeof k == \"function\")) ? e = k.apply(j, b) : e = k));\n                        ((((typeof e == \"undefined\")) && (e = j.exports)));\n                        a(e);\n                    };\n                ;\n                    var e = [], j = this;\n                    for (var m = 0, n = c.length; ((m < n)); m++) {\n                        var o = c[m];\n                        ((((f([\"require\",\"exports\",\"module\",], o) == -1)) && e.push(g(o, j))));\n                    };\n                ;\n                    ((((e.length > 0)) ? b.apply(this, e.concat(l)) : l()));\n                });\n                return l;\n            };\n        ;\n            var e = ((Array.isArray || function(a) {\n                return ((a.constructor == Array));\n            }));\n            a.define = j;\n        });\n    })(this);\n    loadrunner(function(a, b, c, d) {\n        function e(a) {\n            this.id = this.path = a;\n        };\n    ;\n        e.loaded = {\n        };\n        e.prototype = new c.Dependency;\n        e.prototype.start = function() {\n            if (e.loaded[this.path]) this.complete();\n             else {\n                e.loaded[this.path] = !0;\n                this.load();\n            }\n        ;\n        ;\n        };\n        e.prototype.load = function() {\n            function j() {\n                if ((($(f).length > 0))) {\n                    return i();\n                }\n            ;\n            ;\n                c += 1;\n                ((((c < 200)) ? b = JSBNG__setTimeout(j, 50) : i()));\n            };\n        ;\n            function k() {\n                var d;\n                try {\n                    d = !!a.sheet.cssRules;\n                } catch (e) {\n                    c += 1;\n                    ((((c < 200)) ? b = JSBNG__setTimeout(k, 50) : i()));\n                    return;\n                };\n            ;\n                i();\n            };\n        ;\n            var a, b, c, d = JSBNG__document, e = this.path, f = ((((\"link[href=\\\"\" + e)) + \"\\\"]\")), g = $.browser;\n            if ((($(f).length > 0))) {\n                return this.complete();\n            }\n        ;\n        ;\n            var i = function() {\n                JSBNG__clearTimeout(b);\n                a.JSBNG__onload = a.JSBNG__onerror = null;\n                this.complete();\n            }.bind(this);\n            if (((g.webkit || g.mozilla))) {\n                c = 0;\n                if (g.webkit) j();\n                 else {\n                    a = d.createElement(\"style\");\n                    a.innerHTML = ((((\"@import \\\"\" + e)) + \"\\\";\"));\n                    k(a);\n                }\n            ;\n            ;\n            }\n        ;\n        ;\n            if (!a) {\n                a = d.createElement(\"link\");\n                a.setAttribute(\"rel\", \"stylesheet\");\n                a.setAttribute(\"href\", e);\n                a.setAttribute(\"charset\", \"utf-8\");\n            }\n        ;\n        ;\n            a.JSBNG__onload = a.JSBNG__onerror = i;\n            ((d.head || d.getElementsByTagName(\"head\")[0])).appendChild(a);\n        };\n        a.matchers.add(/^css!/, function(a) {\n            a = a.replace(/^css!/, \"\");\n            return new e(a);\n        });\n    });\n    using.aliases = {\n        \"$jasmine.b28c2693f489d65bb33ece420c8a7abea6b777c2.js\": [\"test/core/clock_spec\",\"test/core/parameterize_spec\",\"test/fixtures/news_onebox\",\"test/fixtures/user_search\",\"test/fixtures/saved_searches_dropdown\",\"test/fixtures/advanced_search\",\"test/fixtures/trends_location_dialog_api\",\"test/fixtures/resend_password_help\",\"test/fixtures/own_profile_header\",\"test/fixtures/profile_image_upload_dialog\",\"test/fixtures/trends_api\",\"test/fixtures/discover_stories\",\"test/fixtures/user_onebox\",\"test/fixtures/tweet_export_dialog\",\"test/fixtures/user_actions_chatty\",\"test/fixtures/settings_design_page\",\"test/fixtures/media_onebox\",\"test/app/utils/image_spec\",\"test/app/utils/setup_polling_with_backoff_spec\",\"test/app/utils/params_spec\",\"test/app/utils/cookie_spec\",\"test/app/utils/ellipsis_spec\",\"test/app/utils/oauth_popup_spec\",\"test/app/utils/image_thumbnail_spec\",\"test/app/utils/third_party_application_spec\",\"test/app/utils/querystring_spec\",\"test/app/utils/request_logger_spec\",\"test/app/utils/with_event_params_spec\",\"test/app/utils/drag_drop_helper_spec\",\"test/app/utils/time_spec\",\"test/app/utils/image_resize_spec\",\"test/app/utils/html_text_spec\",\"test/app/utils/sandboxed_ajax_spec\",\"test/app/utils/auth_token_spec\",\"test/app/utils/chrome_spec\",\"test/app/utils/with_session_spec\",\"test/app/utils/string_spec\",\"test/app/utils/tweet_helper_spec\",\"test/app/utils/typeahead_helpers_spec\",\"test/app/utils/hide_or_show_divider_spec\",\"test/app/helpers/log_client_events_spec\",\"test/app/helpers/second_data_component\",\"test/app/helpers/global_after_each_spec\",\"test/app/helpers/test_component\",\"test/app/helpers/describe_component_spec\",\"test/app/helpers/extra_jquery_helpers_spec\",\"test/app/helpers/test_module\",\"test/app/helpers/describe_mixin_spec\",\"test/app/helpers/ajax_respond_with_spec\",\"test/app/helpers/test_scribing_component\",\"test/app/helpers/describe_component_with_data_components_spec\",\"test/app/helpers/describe_module_spec\",\"test/app/helpers/first_data_component\",\"test/app/helpers/test_mixin\",\"test/app/data/with_data_spec\",\"test/app/data/trends_scribe_spec\",\"test/app/data/resend_password_help_scribe_spec\",\"test/app/data/tweet_actions_spec\",\"test/app/data/permalink_scribe_spec\",\"test/app/data/activity_popup_scribe_spec\",\"test/app/data/login_verification_spec\",\"test/app/data/item_actions_scribe_spec\",\"test/app/data/resend_password_spec\",\"test/app/data/user_search_spec\",\"test/app/data/who_to_follow_scribe_spec\",\"test/app/data/url_resolver_spec\",\"test/app/data/oembed_scribe_spec\",\"test/app/data/promoted_logger_spec\",\"test/app/data/login_scribe_spec\",\"test/app/data/user_actions_scribe_spec\",\"test/app/data/facets_timeline_spec\",\"test/app/data/typeahead_scribe_spec\",\"test/app/data/saved_searches_spec\",\"test/app/data/geo_spec\",\"test/app/data/tweet_actions_scribe_spec\",\"test/app/data/scribing_context_spec\",\"test/app/data/prompt_mobile_app_scribe_spec\",\"test/app/data/settings_spec\",\"test/app/data/trends_spec\",\"test/app/data/tweet_translation_spec\",\"test/app/data/oembed_spec\",\"test/app/data/search_input_scribe_spec\",\"test/app/data/list_follow_card_spec\",\"test/app/data/notifications_spec\",\"test/app/data/tweet_box_scribe_spec\",\"test/app/data/conversations_spec\",\"test/app/data/embed_stats_scribe_spec\",\"test/app/data/search_assistance_scribe_spec\",\"test/app/data/activity_popup_spec\",\"test/app/data/with_widgets_spec\",\"test/app/data/list_members_dashboard_spec\",\"test/app/data/frontpage_scribe_spec\",\"test/app/data/ttft_navigation_spec\",\"test/app/data/share_via_email_dialog_data_spec\",\"test/app/data/contact_import_scribe_spec\",\"test/app/data/profile_popup_spec\",\"test/app/data/direct_messages_spec\",\"test/app/data/profile_canopy_scribe_spec\",\"test/app/data/form_scribe_spec\",\"test/app/data/with_conversation_metadata_spec\",\"test/app/data/simple_event_scribe_spec\",\"test/app/data/email_banner_spec\",\"test/app/data/timeline_spec\",\"test/app/data/user_info_spec\",\"test/app/data/with_interaction_data_scribe_spec\",\"test/app/data/dm_poll_spec\",\"test/app/data/profile_social_proof_scribe_spec\",\"test/app/data/async_profile_spec\",\"test/app/data/gallery_scribe_spec\",\"test/app/data/lists_spec\",\"test/app/data/tweet_spec\",\"test/app/data/with_scribe_spec\",\"test/app/data/user_search_scribe_spec\",\"test/app/data/follower_request_spec\",\"test/app/data/user_completion_module_scribe_spec\",\"test/app/data/temporary_password_spec\",\"test/app/data/profile_popup_scribe_spec\",\"test/app/data/archive_navigator_scribe_spec\",\"test/app/data/notification_listener_spec\",\"test/app/data/embed_scribe_spec\",\"test/app/data/signup_click_scribe_spec\",\"test/app/data/contact_import_spec\",\"test/app/data/with_card_metadata_spec\",\"test/app/data/onebox_scribe_spec\",\"test/app/data/media_settings_spec\",\"test/app/data/page_visibility_scribe_spec\",\"test/app/data/inline_edit_scribe_spec\",\"test/app/data/story_scribe_spec\",\"test/app/data/signup_data_spec\",\"test/app/data/user_spec\",\"test/app/data/media_timeline_spec\",\"test/app/data/direct_messages_scribe_spec\",\"test/app/data/navigation_spec\",\"test/app/data/with_auth_token_spec\",\"test/app/data/suggested_users_spec\",\"test/app/data/promptbird_spec\",\"test/app/data/signup_scribe_spec\",\"test/app/data/who_to_tweet_spec\",\"test/app/data/who_to_follow_spec\",\"test/app/data/media_thumbnails_scribe_spec\",\"test/app/ui/message_drawer_spec\",\"test/app/ui/color_picker_spec\",\"test/app/ui/with_forgot_password_spec\",\"test/app/ui/theme_preview_spec\",\"test/app/ui/search_query_source_spec\",\"test/app/ui/signin_dropdown_spec\",\"test/app/ui/tooltips_spec\",\"test/app/ui/user_search_spec\",\"test/app/ui/search_input_spec\",\"test/app/ui/with_focus_highlight_spec\",\"test/app/ui/with_inline_image_editing_spec\",\"test/app/ui/user_completion_module_spec\",\"test/app/ui/validating_fieldset_spec\",\"test/app/ui/alert_banner_to_message_drawer_spec\",\"test/app/ui/protected_verified_dialog_spec\",\"test/app/ui/with_item_actions_spec\",\"test/app/ui/oauth_revoker_spec\",\"test/app/ui/with_profile_stats_spec\",\"test/app/ui/with_timestamp_updating_spec\",\"test/app/ui/geo_deletion_spec\",\"test/app/ui/permalink_keyboard_support_spec\",\"test/app/ui/drag_state_spec\",\"test/app/ui/tweet_box_spec\",\"test/app/ui/with_story_clicks_spec\",\"test/app/ui/temporary_password_button_spec\",\"test/app/ui/with_loading_indicator_spec\",\"test/app/ui/navigation_links_spec\",\"test/app/ui/profile_image_monitor_dom_spec\",\"test/app/ui/image_uploader_spec\",\"test/app/ui/with_dialog_spec\",\"test/app/ui/with_upload_photo_affordance_spec\",\"test/app/ui/with_import_services_spec\",\"test/app/ui/hidden_descendants_spec\",\"test/app/ui/list_follow_card_spec\",\"test/app/ui/password_dialog_spec\",\"test/app/ui/keyboard_shortcuts_spec\",\"test/app/ui/infinite_scroll_watcher_spec\",\"test/app/ui/signup_call_out_spec\",\"test/app/ui/capped_file_upload_spec\",\"test/app/ui/list_members_dashboard_spec\",\"test/app/ui/alert_banner_spec\",\"test/app/ui/with_select_all_spec\",\"test/app/ui/password_match_pair_spec\",\"test/app/ui/password_spec\",\"test/app/ui/login_verification_confirmation_dialog_spec\",\"test/app/ui/settings_controls_spec\",\"test/app/ui/profile_popup_spec\",\"test/app/ui/aria_event_logger_spec\",\"test/app/ui/tweet_injector_spec\",\"test/app/ui/page_title_spec\",\"test/app/ui/page_visibility_spec\",\"test/app/ui/captcha_dialog_spec\",\"test/app/ui/with_discover_expando_spec\",\"test/app/ui/direct_message_link_handler_spec\",\"test/app/ui/with_dropdown_spec\",\"test/app/ui/facets_spec\",\"test/app/ui/inline_edit_spec\",\"test/app/ui/dashboard_tweetbox_spec\",\"test/app/ui/timezone_detector_spec\",\"test/app/ui/email_confirmation_spec\",\"test/app/ui/with_removable_stream_items_spec\",\"test/app/ui/cookie_warning_spec\",\"test/app/ui/inline_profile_editing_initializor_spec\",\"test/app/ui/with_stream_users_spec\",\"test/app/ui/geo_picker_spec\",\"test/app/ui/image_selector_spec\",\"test/app/ui/with_position_spec\",\"test/app/ui/with_user_actions_spec\",\"test/app/ui/email_field_highlight_spec\",\"test/app/ui/with_rich_editor_spec\",\"test/app/ui/theme_picker_spec\",\"test/app/ui/tweet_box_thumbnails_spec\",\"test/app/ui/with_rtl_tweet_box_spec\",\"test/app/ui/login_verification_form_spec\",\"test/app/ui/direct_message_dialog_spec\",\"test/app/ui/profile_image_monitor_spec\",\"test/app/ui/with_image_selection_spec\",\"test/app/ui/with_tweet_actions_spec\",\"test/app/ui/embed_stats_spec\",\"test/app/ui/with_tweet_translation_spec\",\"test/app/ui/search_dropdown_spec\",\"test/app/ui/new_tweet_button_spec\",\"test/app/ui/impression_cookies_spec\",\"test/app/ui/field_edit_warning_spec\",\"test/app/ui/profile_edit_param_spec\",\"test/app/ui/hidden_ancestors_spec\",\"test/app/ui/advanced_search_spec\",\"test/app/ui/with_click_outside_spec\",\"test/app/ui/discover_spec\",\"test/app/ui/design_spec\",\"test/app/ui/tweet_dialog_spec\",\"test/app/ui/with_inline_image_options_spec\",\"test/app/ui/global_nav_spec\",\"test/app/ui/navigation_spec\",\"test/app/ui/toolbar_spec\",\"test/app/ui/suggested_users_spec\",\"test/app/ui/promptbird_spec\",\"test/app/ui/deactivated_spec\",\"test/app/ui/with_conversation_actions_spec\",\"test/app/ui/who_to_tweet_spec\",\"test/app/ui/with_text_polling_spec\",\"test/app/ui/password_strength_spec\",\"test/app/ui/inline_profile_editing_spec\",\"test/app/ui/user_dropdown_spec\",\"test/app/ui/with_interaction_data_spec\",\"test/app/ui/with_password_strength_spec\",\"test/app/utils/image/image_loader_spec\",\"test/app/utils/crypto/aes_spec\",\"test/app/utils/storage/with_crypto_spec\",\"test/app/utils/storage/with_expiry_spec\",\"test/app/utils/storage/custom_spec\",\"test/app/utils/storage/core_spec\",\"test/app/data/feedback/feedback_spec\",\"test/app/data/typeahead/with_cache_spec\",\"test/app/data/typeahead/with_external_event_listeners_spec\",\"test/app/data/typeahead/context_helper_datasource_spec\",\"test/app/data/typeahead/typeahead_spec\",\"test/app/data/typeahead/saved_searches_datasource_spec\",\"test/app/data/typeahead/trend_locations_datasource_spec\",\"test/app/data/typeahead/topics_datasource_spec\",\"test/app/data/typeahead/recent_searches_datasource_spec\",\"test/app/data/typeahead/accounts_datasource_spec\",\"test/app/data/who_to_follow/web_personalized_proxy_spec\",\"test/app/data/who_to_follow/web_personalized_scribe_spec\",\"test/app/data/settings/facebook_proxy_spec\",\"test/app/data/settings/login_verification_test_run_spec\",\"test/app/data/welcome/intro_scribe_spec\",\"test/app/data/welcome/lifeline_scribe_spec\",\"test/app/data/welcome/welcome_cards_scribe_spec\",\"test/app/data/welcome/interests_picker_scribe_spec\",\"test/app/data/welcome/invitations_scribe_spec\",\"test/app/data/welcome/welcome_data_spec\",\"test/app/data/welcome/preview_stream_scribe_spec\",\"test/app/data/welcome/flow_nav_scribe_spec\",\"test/app/data/welcome/users_cards_spec\",\"test/app/data/mobile_gallery/download_links_scribe_spec\",\"test/app/data/mobile_gallery/send_download_link_spec\",\"test/app/data/trends/recent_locations_spec\",\"test/app/data/trends/location_dialog_spec\",\"test/app/ui/gallery/with_gallery_spec\",\"test/app/ui/gallery/grid_spec\",\"test/app/ui/gallery/gallery_spec\",\"test/app/ui/gallery/with_grid_spec\",\"test/app/ui/dialogs/temporary_password_dialog_spec\",\"test/app/ui/dialogs/delete_tweet_dialog_spec\",\"test/app/ui/dialogs/embed_tweet_spec\",\"test/app/ui/dialogs/block_user_dialog_spec\",\"test/app/ui/dialogs/profile_edit_error_dialog_spec\",\"test/app/ui/dialogs/promptbird_invite_contacts_dialog_spec\",\"test/app/ui/dialogs/sensitive_flag_confirmation_spec\",\"test/app/ui/dialogs/in_product_help_dialog_spec\",\"test/app/ui/dialogs/iph_search_result_dialog_spec\",\"test/app/ui/dialogs/activity_popup_spec\",\"test/app/ui/dialogs/goto_user_dialog_spec\",\"test/app/ui/dialogs/signin_or_signup_spec\",\"test/app/ui/dialogs/retweet_dialog_spec\",\"test/app/ui/dialogs/profile_confirm_image_delete_dialog_spec\",\"test/app/ui/dialogs/list_membership_dialog_spec\",\"test/app/ui/dialogs/list_operations_dialog_spec\",\"test/app/ui/dialogs/confirm_dialog_spec\",\"test/app/ui/dialogs/with_modal_tweet_spec\",\"test/app/ui/dialogs/tweet_export_dialog_spec\",\"test/app/ui/dialogs/profile_image_upload_dialog_spec\",\"test/app/ui/dialogs/confirm_email_dialog_spec\",\"test/app/ui/feedback/feedback_report_link_handler_spec\",\"test/app/ui/feedback/feedback_dialog_spec\",\"test/app/ui/search/related_queries_spec\",\"test/app/ui/search/user_onebox_spec\",\"test/app/ui/search/news_onebox_spec\",\"test/app/ui/search/archive_navigator_spec\",\"test/app/ui/search/media_onebox_spec\",\"test/app/ui/search/spelling_corrections_spec\",\"test/app/ui/typeahead/context_helpers_renderer_spec\",\"test/app/ui/typeahead/recent_searches_renderer_spec\",\"test/app/ui/typeahead/typeahead_input_spec\",\"test/app/ui/typeahead/saved_searches_renderer_spec\",\"test/app/ui/typeahead/accounts_renderer_spec\",\"test/app/ui/typeahead/trend_locations_renderer_spec\",\"test/app/ui/typeahead/typeahead_dropdown_spec\",\"test/app/ui/typeahead/topics_renderer_spec\",\"test/app/ui/vit/verification_step_spec\",\"test/app/ui/vit/mobile_topbar_spec\",\"test/app/ui/profile/canopy_spec\",\"test/app/ui/profile/head_spec\",\"test/app/ui/profile/social_proof_spec\",\"test/app/ui/account/resend_password_controls_spec\",\"test/app/ui/account/resend_password_help_controls_spec\",\"test/app/ui/expando/with_expanding_containers_spec\",\"test/app/ui/expando/expanding_tweets_spec\",\"test/app/ui/expando/with_expanding_social_activity_spec\",\"test/app/ui/expando/expando_helpers_spec\",\"test/app/ui/expando/close_all_button_spec\",\"test/app/ui/signup/with_signup_validation_spec\",\"test/app/ui/signup/suggestions_spec\",\"test/app/ui/signup/signup_form_spec\",\"test/app/ui/signup/stream_end_signup_module_spec\",\"test/app/ui/signup/with_captcha_spec\",\"test/app/ui/media/with_hidden_display_spec\",\"test/app/ui/media/with_legacy_media_spec\",\"test/app/ui/media/with_legacy_embeds_spec\",\"test/app/ui/media/with_flag_action_spec\",\"test/app/ui/media/media_thumbnails_spec\",\"test/app/ui/media/with_legacy_icons_spec\",\"test/app/ui/media/card_thumbnails_spec\",\"test/app/ui/signup_download/next_and_skip_buttons_spec\",\"test/app/ui/signup_download/us_phone_number_checker_spec\",\"test/app/ui/who_to_follow/import_services_spec\",\"test/app/ui/who_to_follow/web_personalized_settings_spec\",\"test/app/ui/who_to_follow/matched_contacts_list_spec\",\"test/app/ui/who_to_follow/with_unmatched_contacts_spec\",\"test/app/ui/who_to_follow/who_to_follow_dashboard_spec\",\"test/app/ui/who_to_follow/find_friends_spec\",\"test/app/ui/who_to_follow/invite_form_spec\",\"test/app/ui/who_to_follow/with_invite_messages_spec\",\"test/app/ui/who_to_follow/who_to_follow_timeline_spec\",\"test/app/ui/who_to_follow/with_user_recommendations_spec\",\"test/app/ui/who_to_follow/web_personalized_signup_spec\",\"test/app/ui/who_to_follow/with_invite_preview_spec\",\"test/app/ui/settings/facebook_iframe_height_adjuster_spec\",\"test/app/ui/settings/with_cropper_spec\",\"test/app/ui/settings/tweet_export_spec\",\"test/app/ui/settings/facebook_login_spec\",\"test/app/ui/settings/facebook_connect_spec\",\"test/app/ui/settings/sms_phone_create_form_spec\",\"test/app/ui/settings/tweet_export_download_spec\",\"test/app/ui/settings/notifications_spec\",\"test/app/ui/settings/widgets_configurator_spec\",\"test/app/ui/settings/device_verified_form_spec\",\"test/app/ui/settings/change_photo_spec\",\"test/app/ui/settings/facebook_spinner_spec\",\"test/app/ui/settings/facebook_connection_conflict_spec\",\"test/app/ui/settings/sms_phone_verify_form_spec\",\"test/app/ui/settings/facebook_connected_spec\",\"test/app/ui/settings/facebook_missing_permissions_spec\",\"test/app/ui/settings/widgets_spec\",\"test/app/ui/settings/facebook_mismatched_connection_spec\",\"test/app/ui/settings/login_verification_sms_check_spec\",\"test/app/ui/timelines/event_timeline_spec\",\"test/app/ui/timelines/with_cursor_pagination_spec\",\"test/app/ui/timelines/user_timeline_spec\",\"test/app/ui/timelines/universal_timeline_spec\",\"test/app/ui/timelines/with_keyboard_navigation_spec\",\"test/app/ui/timelines/with_story_pagination_spec\",\"test/app/ui/timelines/with_polling_spec\",\"test/app/ui/timelines/discover_timeline_spec\",\"test/app/ui/timelines/follower_request_timeline_spec\",\"test/app/ui/timelines/with_pinned_stream_items_spec\",\"test/app/ui/timelines/with_most_recent_story_pagination_spec\",\"test/app/ui/timelines/with_preserved_scroll_position_spec\",\"test/app/ui/timelines/with_tweet_pagination_spec\",\"test/app/ui/timelines/tweet_timeline_spec\",\"test/app/ui/timelines/with_activity_supplements_spec\",\"test/app/ui/welcome/interests_header_search_spec\",\"test/app/ui/welcome/intro_video_spec\",\"test/app/ui/welcome/import_services_cards_spec\",\"test/app/ui/welcome/lifeline_device_follow_dialog_spec\",\"test/app/ui/welcome/with_similarities_spec\",\"test/app/ui/welcome/invite_dialog_spec\",\"test/app/ui/welcome/learn_dashboard_spec\",\"test/app/ui/welcome/interests_category_flow_nav_spec\",\"test/app/ui/welcome/profile_flow_nav_spec\",\"test/app/ui/welcome/profile_form_spec\",\"test/app/ui/welcome/custom_interest_spec\",\"test/app/ui/welcome/with_nav_buttons_spec\",\"test/app/ui/welcome/with_interests_spec\",\"test/app/ui/welcome/interests_picker_spec\",\"test/app/ui/welcome/with_more_results_spec\",\"test/app/ui/welcome/with_welcome_search_spec\",\"test/app/ui/welcome/users_cards_spec\",\"test/app/ui/welcome/internal_link_disabler_spec\",\"test/app/ui/mobile_gallery/gallery_buttons_spec\",\"test/app/ui/forms/select_box_spec\",\"test/app/ui/forms/with_submit_disable_spec\",\"test/app/ui/forms/input_with_placeholder_spec\",\"test/app/ui/forms/mobile_gallery_email_form_spec\",\"test/app/ui/forms/form_value_modification_spec\",\"test/app/ui/forms/element_group_toggler_spec\",\"test/app/ui/trends/trends_spec\",\"test/app/ui/trends/trends_dialog_spec\",\"test/app/ui/banners/email_banner_spec\",\"test/app/ui/promptbird/with_invite_contacts_spec\",\"test/app/ui/promptbird/with_invite_contacts\",\"test/app/utils/storage/array/with_max_elements_spec\",\"test/app/utils/storage/array/with_array_spec\",\"test/app/utils/storage/array/with_unique_elements_spec\",\"test/app/ui/timelines/conversations/ancestor_timeline_spec\",\"test/app/ui/timelines/conversations/descendant_timeline_spec\",\"test/app/ui/trends/dialog/nearby_trends_spec\",\"test/app/ui/trends/dialog/with_location_info_spec\",\"test/app/ui/trends/dialog/recent_trends_spec\",\"test/app/ui/trends/dialog/location_search_spec\",\"test/app/ui/trends/dialog/location_dropdown_spec\",\"test/app/ui/trends/dialog/dialog_spec\",\"test/app/ui/trends/dialog/current_location_spec\",\"test/app/ui/trends/dialog/with_location_list_picker_spec\",\"app/data/welcome/preview_stream_scribe\",\"app/ui/welcome/with_nav_buttons\",\"app/ui/welcome/interests_category_flow_nav\",\"app/ui/welcome/with_similarities\",],\n        \"$bundle/boot.2a31b60b327963d16b704386722149661e1cb6ea.js\": [\"app/data/geo\",\"app/data/tweet\",\"app/ui/tweet_dialog\",\"app/ui/new_tweet_button\",\"app/data/tweet_box_scribe\",\"lib/twitter-text\",\"app/ui/with_character_counter\",\"app/utils/with_event_params\",\"app/utils/caret\",\"app/ui/with_draft_tweets\",\"app/ui/with_text_polling\",\"app/ui/with_rtl_tweet_box\",\"app/ui/toolbar\",\"app/utils/tweet_helper\",\"app/utils/html_text\",\"app/ui/with_rich_editor\",\"app/ui/with_upload_photo_affordance\",\"$lib/jquery.swfobject.js\",\"app/utils/image\",\"app/utils/drag_drop_helper\",\"app/ui/with_drop_events\",\"app/ui/with_droppable_image\",\"app/ui/tweet_box\",\"app/utils/image_thumbnail\",\"app/ui/tweet_box_thumbnails\",\"app/utils/image_resize\",\"app/ui/with_image_selection\",\"app/ui/image_selector\",\"app/ui/typeahead/accounts_renderer\",\"app/ui/typeahead/saved_searches_renderer\",\"app/ui/typeahead/recent_searches_renderer\",\"app/ui/typeahead/topics_renderer\",\"app/ui/typeahead/trend_locations_renderer\",\"app/ui/typeahead/context_helpers_renderer\",\"app/utils/rtl_text\",\"app/ui/typeahead/typeahead_dropdown\",\"app/utils/event_support\",\"app/utils/string\",\"app/ui/typeahead/typeahead_input\",\"app/ui/with_click_outside\",\"app/ui/geo_picker\",\"app/ui/tweet_box_manager\",\"app/boot/tweet_boxes\",\"app/ui/user_dropdown\",\"app/ui/signin_dropdown\",\"app/ui/search_input\",\"app/utils/animate_window_scrolltop\",\"app/ui/global_nav\",\"app/ui/navigation_links\",\"app/data/search_input_scribe\",\"app/boot/top_bar\",\"app/ui/keyboard_shortcuts\",\"app/ui/dialogs/keyboard_shortcuts_dialog\",\"app/ui/dialogs/with_modal_tweet\",\"app/ui/dialogs/retweet_dialog\",\"app/ui/dialogs/delete_tweet_dialog\",\"app/ui/dialogs/block_user_dialog\",\"app/ui/dialogs/confirm_dialog\",\"app/ui/dialogs/confirm_email_dialog\",\"app/ui/dialogs/list_membership_dialog\",\"app/ui/dialogs/list_operations_dialog\",\"app/data/direct_messages\",\"app/data/direct_messages_scribe\",\"app/ui/direct_message_link_handler\",\"app/ui/with_timestamp_updating\",\"app/ui/direct_message_dialog\",\"app/boot/direct_messages\",\"app/data/profile_popup\",\"app/data/profile_popup_scribe\",\"app/ui/with_user_actions\",\"app/ui/with_item_actions\",\"app/ui/with_profile_stats\",\"app/ui/with_handle_overflow\",\"app/ui/profile_popup\",\"app/data/profile_edit_btn_scribe\",\"app/data/user\",\"app/data/lists\",\"app/boot/profile_popup\",\"app/data/typeahead/with_cache\",\"app/utils/typeahead_helpers\",\"app/data/with_datasource_helpers\",\"app/data/typeahead/accounts_datasource\",\"app/data/typeahead/saved_searches_datasource\",\"app/data/typeahead/recent_searches_datasource\",\"app/data/typeahead/with_external_event_listeners\",\"app/data/typeahead/topics_datasource\",\"app/data/typeahead/context_helper_datasource\",\"app/data/typeahead/trend_locations_datasource\",\"app/data/typeahead/typeahead\",\"app/data/typeahead_scribe\",\"app/ui/dialogs/goto_user_dialog\",\"app/utils/setup_polling_with_backoff\",\"app/ui/page_title\",\"app/ui/feedback/with_feedback_tweet\",\"app/ui/feedback/feedback_stories\",\"app/ui/feedback/with_feedback_discover\",\"app/ui/feedback/feedback_dialog\",\"app/ui/feedback/feedback_report_link_handler\",\"app/data/feedback/feedback\",\"app/ui/search_query_source\",\"app/ui/banners/email_banner\",\"app/data/email_banner\",\"app/ui/media/phoenix_shim\",\"app/utils/twt\",\"app/ui/media/types\",\"$lib/easyXDM.js\",\"app/utils/easy_xdm\",\"app/utils/sandboxed_ajax\",\"app/ui/media/with_legacy_icons\",\"app/utils/third_party_application\",\"app/ui/media/legacy_embed\",\"app/ui/media/with_legacy_embeds\",\"app/ui/media/with_flag_action\",\"app/ui/media/with_hidden_display\",\"app/ui/media/with_legacy_media\",\"app/utils/image/image_loader\",\"app/ui/with_tweet_actions\",\"app/ui/gallery/gallery\",\"app/data/gallery_scribe\",\"app/data/share_via_email_dialog_data\",\"app/ui/dialogs/share_via_email_dialog\",\"app/data/with_widgets\",\"app/ui/dialogs/embed_tweet\",\"app/data/embed_scribe\",\"app/data/oembed\",\"app/data/oembed_scribe\",\"app/ui/with_drag_events\",\"app/ui/drag_state\",\"app/data/notification_listener\",\"app/data/dm_poll\",\"app/boot/app\",],\n        \"$bundle/frontpage.4fadf7a73f7269b9c27c826f2ebf9bed67255e74.js\": [\"app/data/frontpage_scribe\",\"app/ui/cookie_warning\",\"app/pages/frontpage\",\"app/data/login_scribe\",\"app/pages/login\",],\n        \"$bundle/signup.990c69542ff942eb94bd30c41f9c7c6d04997ca3.js\": [\"app/ui/signup/with_captcha\",\"app/utils/common_regexp\",\"app/ui/signup/with_signup_validation\",\"app/ui/signup/signup_form\",\"app/ui/with_password_strength\",\"app/data/signup_data\",\"app/data/settings\",\"app/data/signup_scribe\",\"app/ui/signup/suggestions\",\"app/ui/signup/small_print_expander\",\"app/ui/signup_download/us_phone_number_checker\",\"app/pages/signup/signup\",],\n        \"$bundle/timeline.b98b3cb4be7ab03238736d9d12f3be01e878d262.js\": [\"app/data/tweet_actions\",\"app/ui/expando/with_expanding_containers\",\"app/ui/expando/expando_helpers\",\"app/ui/gallery/with_gallery\",\"app/ui/with_tweet_translation\",\"app/ui/tweets\",\"app/ui/tweet_injector\",\"app/ui/expando/with_expanding_social_activity\",\"app/ui/expando/expanding_tweets\",\"app/ui/embed_stats\",\"app/data/url_resolver\",\"app/ui/media/with_native_media\",\"app/ui/media/media_tweets\",\"app/data/trends\",\"app/data/trends/location_dialog\",\"app/data/trends/recent_locations\",\"app/utils/scribe_event_initiators\",\"app/data/trends_scribe\",\"app/ui/trends/trends\",\"app/ui/trends/trends_dialog\",\"app/ui/trends/dialog/with_location_info\",\"app/ui/trends/dialog/location_dropdown\",\"app/ui/trends/dialog/location_search\",\"app/ui/trends/dialog/current_location\",\"app/ui/trends/dialog/with_location_list_picker\",\"app/ui/trends/dialog/nearby_trends\",\"app/ui/trends/dialog/recent_trends\",\"app/ui/trends/dialog/dialog\",\"app/boot/trends\",\"app/ui/infinite_scroll_watcher\",\"app/data/timeline\",\"app/boot/timeline\",\"app/data/activity_popup\",\"app/ui/dialogs/activity_popup\",\"app/data/activity_popup_scribe\",\"app/boot/activity_popup\",\"app/data/tweet_translation\",\"app/data/conversations\",\"app/data/media_settings\",\"app/ui/dialogs/sensitive_flag_confirmation\",\"app/ui/user_actions\",\"app/data/prompt_mobile_app_scribe\",\"app/boot/tweets\",\"app/boot/help_pips_enable\",\"app/data/help_pips\",\"app/data/help_pips_scribe\",\"app/ui/help_pip\",\"app/ui/help_pips_injector\",\"app/boot/help_pips\",\"app/ui/expando/close_all_button\",\"app/ui/timelines/with_keyboard_navigation\",\"app/ui/with_focus_highlight\",\"app/ui/timelines/with_base_timeline\",\"app/ui/timelines/with_old_items\",\"app/utils/chrome\",\"app/ui/timelines/with_traveling_ptw\",\"app/ui/timelines/with_autoplaying_timeline\",\"app/ui/timelines/with_polling\",\"app/ui/timelines/with_new_items\",\"app/ui/timelines/with_tweet_pagination\",\"app/ui/timelines/with_preserved_scroll_position\",\"app/ui/timelines/with_activity_supplements\",\"app/ui/with_conversation_actions\",\"app/ui/timelines/with_pinned_stream_items\",\"app/ui/timelines/tweet_timeline\",\"app/boot/tweet_timeline\",\"app/ui/user_completion_module\",\"app/data/user_completion_module_scribe\",\"app/boot/user_completion_module\",\"app/ui/who_to_follow/with_user_recommendations\",\"app/ui/who_to_follow/who_to_follow_dashboard\",\"app/ui/who_to_follow/who_to_follow_timeline\",\"app/data/who_to_follow\",\"app/data/who_to_follow_scribe\",\"app/ui/profile/recent_connections_module\",\"app/ui/promptbird/with_invite_contacts\",\"app/ui/promptbird\",\"app/utils/oauth_popup\",\"app/data/promptbird\",\"app/data/promptbird_scribe\",\"app/ui/with_select_all\",\"app/ui/who_to_follow/with_invite_messages\",\"app/ui/who_to_follow/with_invite_preview\",\"app/ui/who_to_follow/with_unmatched_contacts\",\"app/ui/dialogs/promptbird_invite_contacts_dialog\",\"app/data/contact_import\",\"app/data/contact_import_scribe\",\"app/ui/with_import_services\",\"app/ui/who_to_follow/import_services\",\"app/ui/who_to_follow/import_loading_dialog\",\"app/ui/dashboard_tweetbox\",\"app/utils/boomerang\",\"app/ui/profile_stats\",\"app/pages/home\",\"app/boot/wtf_module\",\"app/data/who_to_tweet\",\"app/boot/connect\",\"app/ui/who_to_follow/with_list_resizing\",\"app/ui/who_to_follow/matched_contacts_list\",\"app/ui/who_to_follow/unmatched_contacts_list\",\"app/ui/who_to_tweet\",\"app/ui/with_loading_indicator\",\"app/ui/who_to_follow/find_friends\",\"app/pages/connect/interactions\",\"app/pages/connect/mentions\",\"app/pages/connect/network_activity\",\"app/ui/inline_edit\",\"app/data/async_profile\",\"$lib/jquery_ui.profile.js\",\"$lib/jquery_webcam.js\",\"app/ui/settings/with_cropper\",\"app/ui/settings/with_webcam\",\"app/utils/is_showing_avatar_options\",\"app/ui/dialogs/profile_image_upload_dialog\",\"app/ui/dialogs/profile_edit_error_dialog\",\"app/ui/dialogs/profile_confirm_image_delete_dialog\",\"app/ui/droppable_image\",\"app/ui/profile_image_monitor\",\"app/data/inline_edit_scribe\",\"app/data/settings/profile_image_upload_scribe\",\"app/data/drag_and_drop_scribe\",\"app/ui/settings/change_photo\",\"app/ui/image_uploader\",\"app/ui/inline_profile_editing_initializor\",\"app/utils/hide_or_show_divider\",\"app/ui/with_inline_image_options\",\"app/ui/with_inline_image_editing\",\"app/ui/inline_profile_editing\",\"app/data/settings\",\"app/ui/profile_edit_param\",\"app/ui/alert_banner_to_message_drawer\",\"app/boot/inline_edit\",\"app/ui/profile/canopy\",\"app/data/profile_canopy_scribe\",\"app/ui/profile/head\",\"app/data/profile_head_scribe\",\"app/ui/profile/social_proof\",\"app/data/profile_social_proof_scribe\",\"app/ui/media/card_thumbnails\",\"app/data/media_timeline\",\"app/data/media_thumbnails_scribe\",\"app/ui/suggested_users\",\"app/data/suggested_users\",\"app/ui/gallery/grid\",\"app/boot/profile\",\"app/pages/profile/tweets\",\"app/ui/timelines/with_cursor_pagination\",\"app/ui/with_stream_users\",\"app/ui/timelines/user_timeline\",\"app/boot/user_timeline\",\"app/ui/timelines/follower_request_timeline\",\"app/data/follower_request\",\"app/pages/profile/follower_requests\",\"app/pages/profile/followers\",\"app/pages/profile/following\",\"app/pages/profile/favorites\",\"app/ui/timelines/list_timeline\",\"app/boot/list_timeline\",\"app/pages/profile/lists\",\"app/ui/with_removable_stream_items\",\"app/ui/similar_to\",\"app/pages/profile/similar_to\",\"app/ui/facets\",\"app/data/facets_timeline\",\"app/ui/dialogs/iph_search_result_dialog\",\"app/ui/search/archive_navigator\",\"app/data/archive_navigator_scribe\",\"app/boot/search\",\"app/ui/timelines/with_story_pagination\",\"app/ui/gallery/with_grid\",\"app/ui/timelines/universal_timeline\",\"app/boot/universal_timeline\",\"app/data/user_search\",\"app/data/user_search_scribe\",\"app/ui/user_search\",\"app/data/saved_searches\",\"app/ui/search_dropdown\",\"app/data/story_scribe\",\"app/data/onebox_scribe\",\"app/ui/with_story_clicks\",\"$lib/jquery_autoellipsis.js\",\"app/utils/ellipsis\",\"app/ui/with_story_ellipsis\",\"app/ui/search/news_onebox\",\"app/ui/search/user_onebox\",\"app/ui/search/event_onebox\",\"app/ui/search/media_onebox\",\"app/ui/search/spelling_corrections\",\"app/ui/search/related_queries\",\"app/data/search_assistance_scribe\",\"app/data/timeline_controls_scribe\",\"app/pages/search/search\",\"app/ui/timelines/with_search_media_pagination\",\"app/ui/timelines/media_timeline\",\"app/boot/media_timeline\",\"app/pages/search/media\",\"app/pages/simple_t1\",],\n        \"$bundle/permalink.db92252904761daedf68bf11bbb2750235e32ce7.js\": [\"app/ui/permalink_keyboard_support\",\"app/ui/hidden_ancestors\",\"app/ui/hidden_descendants\",\"app/ui/dialogs/sms_codes\",\"app/ui/timelines/conversations/descendant_timeline\",\"app/ui/timelines/conversations/ancestor_timeline\",\"app/data/embed_stats_scribe\",\"app/data/permalink_scribe\",\"app/pages/permalink\",\"app/pages/permalink_photo\",],\n        \"$bundle/lists_permalink.6e3de5369fc1b6a20122d38d988602ec8ea6a3e1.js\": [\"app/ui/list_members_dashboard\",\"app/data/list_members_dashboard\",\"app/ui/list_follow_card\",\"app/data/list_follow_card\",\"app/boot/list_permalink\",\"app/pages/list/permalink_tweets\",\"app/pages/list/permalink_users\",],\n        \"$bundle/discover.814fb8dadcc0776c9fc9424643d16957d677e3c2.js\": [\"app/ui/discover_nav\",\"app/boot/discover\",\"app/ui/timelines/with_most_recent_story_pagination\",\"app/ui/timelines/discover_timeline\",\"app/boot/discover_timeline\",\"app/ui/with_discover_expando\",\"app/ui/discover\",\"app/pages/discover/discover\",\"app/ui/people_search_input\",\"app/boot/who_to_follow\",\"app/utils/common_regexp\",\"app/ui/who_to_follow/invite_form\",\"app/ui/who_to_follow/pymk_kicker\",\"app/ui/who_to_follow/wipe_addressbook_dialog\",\"app/pages/who_to_follow/import\",\"app/pages/who_to_follow/interests\",\"app/pages/who_to_follow/invite\",\"app/pages/who_to_follow/lifeline\",\"app/pages/who_to_follow/matches\",\"app/pages/who_to_follow/suggestions\",\"app/data/who_to_follow/web_personalized_scribe\",\"app/data/who_to_follow/web_personalized_proxy\",\"app/ui/who_to_follow/web_personalized_settings\",\"app/ui/who_to_follow/web_personalized_signup\",\"app/pages/who_to_follow/web_personalized\",],\n        \"$bundle/settings.746ec42b535d98004e7c1b839e01418210fb34ed.js\": [\"app/ui/alert_banner\",\"app/ui/forms/with_submit_disable\",\"app/ui/forms/form_value_modification\",\"app/boot/settings\",\"app/data/settings/account_scribe\",\"app/data/settings/login_verification_test_run\",\"app/data/form_scribe\",\"app/ui/with_forgot_password\",\"app/ui/password_dialog\",\"app/ui/settings/login_verification_sms_check\",\"app/ui/login_verification_confirmation_dialog\",\"app/ui/protected_verified_dialog\",\"app/ui/email_field_highlight\",\"app/ui/validating_fieldset\",\"app/ui/email_confirmation\",\"app/ui/settings/tweet_export\",\"app/ui/dialogs/tweet_export_dialog\",\"app/ui/timezone_detector\",\"app/ui/deactivated\",\"app/ui/geo_deletion\",\"app/ui/settings_controls\",\"app/pages/settings/account\",\"app/data/temporary_password\",\"app/data/settings/applications_scribe\",\"app/ui/dialogs/temporary_password_dialog\",\"app/ui/temporary_password_button\",\"app/ui/oauth_revoker\",\"app/pages/settings/applications\",\"app/data/settings/confirm_deactivation_scribe\",\"app/pages/settings/confirm_deactivation\",\"app/data/settings/design_scribe\",\"$lib/jquery_color_picker.js\",\"app/ui/color_picker\",\"app/ui/design\",\"app/ui/theme_preview\",\"app/ui/theme_picker\",\"app/pages/settings/design\",\"app/pages/settings/email_follow\",\"app/ui/settings/tweet_export_download\",\"app/pages/settings/tweet_export_download\",\"app/ui/settings/notifications\",\"app/pages/settings/notifications\",\"app/ui/password\",\"app/ui/password_match_pair\",\"app/ui/with_password_strength\",\"app/ui/password_strength\",\"app/pages/settings/password\",\"app/boot/avatar_uploading\",\"app/data/settings/profile_scribe\",\"app/ui/settings/facebook_iframe_height_adjuster\",\"app/ui/field_edit_warning\",\"app/ui/dialogs/in_product_help_dialog\",\"app/boot/header_upload\",\"app/ui/bio_box\",\"app/pages/settings/profile\",\"app/data/settings/facebook_proxy\",\"app/ui/settings/with_facebook_container\",\"app/ui/settings/facebook_spinner\",\"app/ui/settings/with_facebook_banner\",\"app/ui/settings/facebook_login\",\"app/ui/settings/facebook_connect\",\"app/ui/settings/facebook_missing_permissions\",\"app/ui/settings/facebook_mismatched_connection\",\"app/ui/settings/facebook_connection_conflict\",\"app/ui/settings/facebook_connected\",\"app/data/settings/facebook_scribe\",\"app/pages/settings/facebook\",\"app/data/settings/sms_scribe\",\"app/ui/forms/select_box\",\"app/ui/settings/sms_phone_create_form\",\"app/ui/forms/element_group_toggler\",\"app/ui/settings/device_verified_form\",\"app/ui/settings/sms_phone_verify_form\",\"app/pages/settings/sms\",\"app/ui/settings/widgets\",\"app/pages/settings/widgets\",\"app/ui/settings/widgets_configurator\",\"app/pages/settings/widgets_configurator\",],\n        \"$bundle/events.d9845cf638173afdb25220e5ab241f0f6c09021a.js\": [\"app/ui/media/media_thumbnails\",\"app/ui/timelines/event_timeline\",\"app/ui/page_visibility\",\"app/data/page_visibility_scribe\",\"app/pages/events/hashtag\",],\n        \"$bundle/accounts.0ca4815a3944f19c9eaeef0c85bf7984b25d3632.js\": [\"app/ui/account/password_reset_controls\",\"app/ui/password_match_pair\",\"app/ui/with_password_strength\",\"app/ui/password_strength\",\"app/pages/account/password_reset\",\"app/ui/captcha_dialog\",\"app/ui/account/resend_password_controls\",\"app/ui/validating_fieldset\",\"app/data/resend_password\",\"app/pages/account/resend_password\",\"app/ui/account/verify_personal_information_controls\",\"app/pages/account/verify_personal_information\",\"app/ui/account/verify_device_token_controls\",\"app/pages/account/verify_device_token\",\"app/ui/account/resend_password_help_controls\",\"app/data/resend_password_help\",\"app/data/resend_password_help_scribe\",\"app/pages/account/resend_password_help\",\"app/pages/account/errors\",],\n        \"$bundle/search.b7757a9e20dfb014aacc3cd4959de0a8058f4006.js\": [\"app/ui/dialogs/search_operators_dialog\",\"app/pages/search/home\",\"app/ui/advanced_search\",\"app/pages/search/advanced\",\"app/pages/search/users\",],\n        \"$bundle/vitonboarding.bc3a6ee0b7d3407a82a383148a420a678f6925af.js\": [\"$lib/jquery.hashchange.js\",\"app/ui/vit/verification_step\",\"app/ui/vit/mobile_topbar\",\"app/pages/vit/onboarding\",],\n        \"$bundle/mobile_gallery.db430b6898f0144b313838368d3e6edcee89eb6f.js\": [\"app/ui/dialogs/mobile_gallery_download_dialog\",\"app/ui/mobile_gallery/gallery_buttons\",\"app/ui/forms/mobile_gallery_email_form\",\"app/data/mobile_gallery/send_download_link\",\"app/pages/mobile_gallery/gallery\",\"app/pages/mobile_gallery/apps\",\"app/ui/mobile_gallery/firefox_tweet_button\",\"app/pages/mobile_gallery/firefox\",\"app/data/mobile_gallery/download_links_scribe\",\"app/pages/mobile_gallery/splash\",],\n        \"$bundle/signup_download.8c964a5fd99e25aca3f0844968e0379e4a42ed59.js\": [\"app/ui/signup_download/next_and_skip_buttons\",\"app/ui/signup_download/us_phone_number_checker\",\"app/pages/signup_download/download\",\"app/ui/signup_download/signup_phone_verify_form\",\"app/pages/signup_download/verify\",],\n        \"$bundle/welcome.0a6e0a3608c754e79a2a771e71faf0945c0627ad.js\": [\"app/data/welcome/invitations_scribe\",\"app/data/welcome/welcome_cards_scribe\",\"app/data/welcome/flow_nav_scribe\",\"app/data/welcome/preview_stream\",\"app/ui/welcome/invite_dialog\",\"app/ui/welcome/with_nav_buttons\",\"app/ui/welcome/header_progress\",\"app/ui/welcome/internal_link_disabler\",\"app/ui/welcome/learn_dashboard\",\"app/ui/welcome/learn_preview_timeline\",\"app/boot/welcome\",\"app/pages/welcome/import\",\"app/data/welcome/intro_scribe\",\"app/ui/welcome/flow_nav\",\"app/ui/welcome/intro_video\",\"app/ui/welcome/lifeline_device_follow_dialog\",\"app/pages/welcome/intro\",\"app/data/welcome/interests_picker_scribe\",\"app/ui/welcome/with_interests\",\"app/ui/welcome/custom_interest\",\"app/ui/welcome/interests_header_search\",\"app/ui/welcome/interests_picker\",\"app/data/welcome/welcome_data\",\"app/pages/welcome/interests\",\"app/data/welcome/users_cards\",\"app/ui/welcome/import_services_cards\",\"app/ui/welcome/with_card_scribe_context\",\"app/ui/welcome/with_more_results\",\"app/ui/welcome/with_welcome_search\",\"app/ui/welcome/users_cards\",\"app/pages/welcome/interests_category\",\"app/data/welcome/lifeline_scribe\",\"app/pages/welcome/lifeline\",\"app/boot/avatar_uploading\",\"app/ui/alert_banner\",\"app/ui/welcome/profile_flow_nav\",\"app/ui/welcome/profile_form\",\"app/pages/welcome/profile\",\"app/pages/welcome/recommendations\",],\n        \"$bundle/directory.5bb8717366f875004b902864cc429411910c67f8.js\": [\"app/ui/history_back\",\"app/pages/directory/directory\",],\n        \"$bundle/boomerang.ce977240704bc785401822f8d5486667b860593d.js\": [\"$lib/boomerang.js\",\"app/utils/boomerang_lib\",],\n        \"$bundle/sandbox.1a1d8d9e5b807e92548fba6d79824ebe5104b03a.js\": [\"$components/jquery/jquery.js\",\"$lib/easyXDM.js\",\"app/boot/sandbox\",],\n        \"$bundle/html2canvas.82a64ea2711e964e829140881de78438319774a0.js\": [\"$lib/html2canvas.js\",],\n        \"$bundle/loginverification.c610b4269b6c7632a1176cc616d0766fdfdcef42.js\": [\"app/ui/login_verification_form\",\"app/data/login_verification\",\"app/pages/login_verification_page\",]\n    };\n    define(\"components/flight/lib/utils\", [], function() {\n        var a = [], b = 100, c = {\n            isDomObj: function(a) {\n                return ((!!a.nodeType || ((a === window))));\n            },\n            toArray: function(b, c) {\n                return a.slice.call(b, c);\n            },\n            merge: function() {\n                var a = arguments.length, b = 0, c = new Array(((a + 1)));\n                for (; ((b < a)); b++) {\n                    c[((b + 1))] = arguments[b];\n                ;\n                };\n            ;\n                return ((((a === 0)) ? {\n                } : (c[0] = {\n                }, ((((c[((c.length - 1))] === !0)) && (c.pop(), c.unshift(!0)))), $.extend.apply(undefined, c))));\n            },\n            push: function(a, b, c) {\n                return ((a && Object.keys(((b || {\n                }))).forEach(function(d) {\n                    if (((a[d] && c))) {\n                        throw Error(((((\"utils.push attempted to overwrite '\" + d)) + \"' while running in protected mode\")));\n                    }\n                ;\n                ;\n                    ((((((typeof a[d] == \"object\")) && ((typeof b[d] == \"object\")))) ? this.push(a[d], b[d]) : a[d] = b[d]));\n                }, this))), a;\n            },\n            isEnumerable: function(a, b) {\n                return ((Object.keys(a).indexOf(b) > -1));\n            },\n            compose: function() {\n                var a = arguments;\n                return function() {\n                    var b = arguments;\n                    for (var c = ((a.length - 1)); ((c >= 0)); c--) {\n                        b = [a[c].apply(this, b),];\n                    ;\n                    };\n                ;\n                    return b[0];\n                };\n            },\n            uniqueArray: function(a) {\n                var b = {\n                }, c = [];\n                for (var d = 0, e = a.length; ((d < e)); ++d) {\n                    if (b.hasOwnProperty(a[d])) {\n                        continue;\n                    }\n                ;\n                ;\n                    c.push(a[d]), b[a[d]] = 1;\n                };\n            ;\n                return c;\n            },\n            debounce: function(a, c, d) {\n                ((((typeof c != \"number\")) && (c = b)));\n                var e, f;\n                return function() {\n                    var b = this, g = arguments, h = function() {\n                        e = null, ((d || (f = a.apply(b, g))));\n                    }, i = ((d && !e));\n                    return JSBNG__clearTimeout(e), e = JSBNG__setTimeout(h, c), ((i && (f = a.apply(b, g)))), f;\n                };\n            },\n            throttle: function(a, c) {\n                ((((typeof c != \"number\")) && (c = b)));\n                var d, e, f, g, h, i, j = this.debounce(function() {\n                    h = g = !1;\n                }, c);\n                return function() {\n                    d = this, e = arguments;\n                    var b = function() {\n                        f = null, ((h && (i = a.apply(d, e)))), j();\n                    };\n                    return ((f || (f = JSBNG__setTimeout(b, c)))), ((g ? h = !0 : (g = !0, i = a.apply(d, e)))), j(), i;\n                };\n            },\n            countThen: function(a, b) {\n                return function() {\n                    if (!--a) {\n                        return b.apply(this, arguments);\n                    }\n                ;\n                ;\n                };\n            },\n            delegate: function(a) {\n                return function(b, c) {\n                    var d = $(b.target), e;\n                    Object.keys(a).forEach(function(f) {\n                        if ((e = d.closest(f)).length) {\n                            return c = ((c || {\n                            })), c.el = e[0], a[f].apply(this, [b,c,]);\n                        }\n                    ;\n                    ;\n                    }, this);\n                };\n            }\n        };\n        return c;\n    });\n    define(\"components/flight/lib/registry\", [\"./utils\",], function(a) {\n        function b(a, b) {\n            var c, d, e, f = b.length;\n            return ((((typeof b[((f - 1))] == \"function\")) && (f -= 1, e = b[f]))), ((((typeof b[((f - 1))] == \"object\")) && (f -= 1))), ((((f == 2)) ? (c = b[0], d = b[1]) : (c = a.node, d = b[0]))), {\n                element: c,\n                type: d,\n                callback: e\n            };\n        };\n    ;\n        function c(a, b) {\n            return ((((((a.element == b.element)) && ((a.type == b.type)))) && ((((b.callback == null)) || ((a.callback == b.callback))))));\n        };\n    ;\n        function d() {\n            function d(b) {\n                this.component = b, this.attachedTo = [], this.instances = {\n                }, this.addInstance = function(a) {\n                    var b = new e(a);\n                    return this.instances[a.identity] = b, this.attachedTo.push(a.node), b;\n                }, this.removeInstance = function(b) {\n                    delete this.instances[b.identity];\n                    var c = this.attachedTo.indexOf(b.node);\n                    ((((c > -1)) && this.attachedTo.splice(c, 1))), ((Object.keys(this.instances).length || a.removeComponentInfo(this)));\n                }, this.isAttachedTo = function(a) {\n                    return ((this.attachedTo.indexOf(a) > -1));\n                };\n            };\n        ;\n            function e(b) {\n                this.instance = b, this.events = [], this.addBind = function(b) {\n                    this.events.push(b), a.events.push(b);\n                }, this.removeBind = function(a) {\n                    for (var b = 0, d; d = this.events[b]; b++) {\n                        ((c(d, a) && this.events.splice(b, 1)));\n                    ;\n                    };\n                ;\n                };\n            };\n        ;\n            var a = this;\n            (this.reset = function() {\n                this.components = [], this.allInstances = {\n                }, this.events = [];\n            }).call(this), this.addInstance = function(a) {\n                var b = this.findComponentInfo(a);\n                ((b || (b = new d(a.constructor), this.components.push(b))));\n                var c = b.addInstance(a);\n                return this.allInstances[a.identity] = c, b;\n            }, this.removeInstance = function(a) {\n                var b, c = this.findInstanceInfo(a), d = this.findComponentInfo(a);\n                ((d && d.removeInstance(a))), delete this.allInstances[a.identity];\n            }, this.removeComponentInfo = function(a) {\n                var b = this.components.indexOf(a);\n                ((((b > -1)) && this.components.splice(b, 1)));\n            }, this.findComponentInfo = function(a) {\n                var b = ((a.attachTo ? a : a.constructor));\n                for (var c = 0, d; d = this.components[c]; c++) {\n                    if (((d.component === b))) {\n                        return d;\n                    }\n                ;\n                ;\n                };\n            ;\n                return null;\n            }, this.findInstanceInfo = function(a) {\n                return ((this.allInstances[a.identity] || null));\n            }, this.findInstanceInfoByNode = function(a) {\n                var b = [];\n                return Object.keys(this.allInstances).forEach(function(c) {\n                    var d = this.allInstances[c];\n                    ((((d.instance.node === a)) && b.push(d)));\n                }, this), b;\n            }, this.JSBNG__on = function(c) {\n                var d = a.findInstanceInfo(this), e, f = arguments.length, g = 1, h = new Array(((f - 1)));\n                for (; ((g < f)); g++) {\n                    h[((g - 1))] = arguments[g];\n                ;\n                };\n            ;\n                if (d) {\n                    e = c.apply(null, h), ((e && (h[((h.length - 1))] = e)));\n                    var i = b(this, h);\n                    d.addBind(i);\n                }\n            ;\n            ;\n            }, this.off = function(d, e, f) {\n                var g = b(this, arguments), h = a.findInstanceInfo(this);\n                ((h && h.removeBind(g)));\n                for (var i = 0, j; j = a.events[i]; i++) {\n                    ((c(j, g) && a.events.splice(i, 1)));\n                ;\n                };\n            ;\n            }, a.trigger = new Function, this.teardown = function() {\n                a.removeInstance(this);\n            }, this.withRegistration = function() {\n                this.before(\"initialize\", function() {\n                    a.addInstance(this);\n                }), this.around(\"JSBNG__on\", a.JSBNG__on), this.after(\"off\", a.off), ((((window.DEBUG && DEBUG.enabled)) && this.after(\"trigger\", a.trigger))), this.after(\"teardown\", {\n                    obj: a,\n                    fnName: \"teardown\"\n                });\n            };\n        };\n    ;\n        return new d;\n    });\n    define(\"components/flight/tools/debug/debug\", [\"../../lib/registry\",\"../../lib/utils\",], function(a, b) {\n        function d(a, b, c) {\n            var c = ((c || {\n            })), e = ((c.obj || window)), g = ((c.path || ((((e == window)) ? \"window\" : \"\")))), h = Object.keys(e);\n            h.forEach(function(c) {\n                ((((f[a] || a))(b, e, c) && JSBNG__console.log([g,\".\",c,].join(\"\"), \"-\\u003E\", [\"(\",typeof e[c],\")\",].join(\"\"), e[c]))), ((((((((Object.prototype.toString.call(e[c]) == \"[object Object]\")) && ((e[c] != e)))) && ((g.split(\".\").indexOf(c) == -1)))) && d(a, b, {\n                    obj: e[c],\n                    path: [g,c,].join(\".\")\n                })));\n            });\n        };\n    ;\n        function e(a, b, c, e) {\n            ((((!b || ((typeof c == b)))) ? d(a, c, e) : JSBNG__console.error([c,\"must be\",b,].join(\" \"))));\n        };\n    ;\n        function g(a, b) {\n            e(\"JSBNG__name\", \"string\", a, b);\n        };\n    ;\n        function h(a, b) {\n            e(\"nameContains\", \"string\", a, b);\n        };\n    ;\n        function i(a, b) {\n            e(\"type\", \"function\", a, b);\n        };\n    ;\n        function j(a, b) {\n            e(\"value\", null, a, b);\n        };\n    ;\n        function k(a, b) {\n            e(\"valueCoerced\", null, a, b);\n        };\n    ;\n        function l(a, b) {\n            d(a, null, b);\n        };\n    ;\n        function p() {\n            var a = [].slice.call(arguments);\n            ((c.eventNames.length || (c.eventNames = m))), c.actions = ((a.length ? a : m)), t();\n        };\n    ;\n        function q() {\n            var a = [].slice.call(arguments);\n            ((c.actions.length || (c.actions = m))), c.eventNames = ((a.length ? a : m)), t();\n        };\n    ;\n        function r() {\n            c.actions = [], c.eventNames = [], t();\n        };\n    ;\n        function s() {\n            c.actions = m, c.eventNames = m, t();\n        };\n    ;\n        function t() {\n            ((window.JSBNG__localStorage && (JSBNG__localStorage.setItem(\"logFilter_eventNames\", c.eventNames), JSBNG__localStorage.setItem(\"logFilter_actions\", c.actions))));\n        };\n    ;\n        function u() {\n            var a = {\n                eventNames: ((((window.JSBNG__localStorage && JSBNG__localStorage.getItem(\"logFilter_eventNames\"))) || n)),\n                actions: ((((window.JSBNG__localStorage && JSBNG__localStorage.getItem(\"logFilter_actions\"))) || o))\n            };\n            return Object.keys(a).forEach(function(b) {\n                var c = a[b];\n                ((((((typeof c == \"string\")) && ((c !== m)))) && (a[b] = c.split(\",\"))));\n            }), a;\n        };\n    ;\n        var c, f = {\n            JSBNG__name: function(a, b, c) {\n                return ((a == c));\n            },\n            nameContains: function(a, b, c) {\n                return ((c.indexOf(a) > -1));\n            },\n            type: function(a, b, c) {\n                return ((b[c] instanceof a));\n            },\n            value: function(a, b, c) {\n                return ((b[c] === a));\n            },\n            valueCoerced: function(a, b, c) {\n                return ((b[c] == a));\n            }\n        }, m = \"all\", n = [], o = [], c = u();\n        return {\n            enable: function(a) {\n                this.enabled = !!a, ((((a && window.JSBNG__console)) && (JSBNG__console.info(\"Booting in DEBUG mode\"), JSBNG__console.info(\"You can configure event logging with DEBUG.events.logAll()/logNone()/logByName()/logByAction()\")))), window.DEBUG = this;\n            },\n            JSBNG__find: {\n                byName: g,\n                byNameContains: h,\n                byType: i,\n                byValue: j,\n                byValueCoerced: k,\n                custom: l\n            },\n            events: {\n                logFilter: c,\n                logByAction: p,\n                logByName: q,\n                logAll: s,\n                logNone: r\n            }\n        };\n    });\n    define(\"components/flight/lib/compose\", [\"./utils\",\"../tools/debug/debug\",], function(a, b) {\n        function f(a, b) {\n            if (!c) {\n                return;\n            }\n        ;\n        ;\n            var e = Object.create(null);\n            Object.keys(a).forEach(function(c) {\n                if (((d.indexOf(c) < 0))) {\n                    var f = Object.getOwnPropertyDescriptor(a, c);\n                    f.writable = b, e[c] = f;\n                }\n            ;\n            ;\n            }), Object.defineProperties(a, e);\n        };\n    ;\n        function g(a, b, d) {\n            var e;\n            if (((!c || !a.hasOwnProperty(b)))) {\n                d.call(a);\n                return;\n            }\n        ;\n        ;\n            e = Object.getOwnPropertyDescriptor(a, b).writable, Object.defineProperty(a, b, {\n                writable: !0\n            }), d.call(a), Object.defineProperty(a, b, {\n                writable: e\n            });\n        };\n    ;\n        function h(a, b) {\n            a.mixedIn = ((a.hasOwnProperty(\"mixedIn\") ? a.mixedIn : [])), b.forEach(function(b) {\n                ((((a.mixedIn.indexOf(b) == -1)) && (f(a, !1), b.call(a), a.mixedIn.push(b))));\n            }), f(a, !0);\n        };\n    ;\n        var c = ((b.enabled && !a.isEnumerable(Object, \"getOwnPropertyDescriptor\"))), d = [\"mixedIn\",];\n        if (c) {\n            try {\n                Object.getOwnPropertyDescriptor(Object, \"keys\");\n            } catch (e) {\n                c = !1;\n            };\n        }\n    ;\n    ;\n        return {\n            mixin: h,\n            unlockProperty: g\n        };\n    });\n    define(\"components/flight/lib/advice\", [\"./utils\",\"./compose\",], function(a, b) {\n        var c = {\n            around: function(a, b) {\n                return function() {\n                    var d = 0, e = arguments.length, f = new Array(((e + 1)));\n                    f[0] = a.bind(this);\n                    for (; ((d < e)); d++) {\n                        f[((d + 1))] = arguments[d];\n                    ;\n                    };\n                ;\n                    return b.apply(this, f);\n                };\n            },\n            before: function(a, b) {\n                var c = ((((typeof b == \"function\")) ? b : b.obj[b.fnName]));\n                return function() {\n                    return c.apply(this, arguments), a.apply(this, arguments);\n                };\n            },\n            after: function(a, b) {\n                var c = ((((typeof b == \"function\")) ? b : b.obj[b.fnName]));\n                return function() {\n                    var d = ((a.unbound || a)).apply(this, arguments);\n                    return c.apply(this, arguments), d;\n                };\n            },\n            withAdvice: function() {\n                [\"before\",\"after\",\"around\",].forEach(function(a) {\n                    this[a] = function(d, e) {\n                        b.unlockProperty(this, d, function() {\n                            return ((((typeof this[d] == \"function\")) ? this[d] = c[a](this[d], e) : this[d] = e));\n                        });\n                    };\n                }, this);\n            }\n        };\n        return c;\n    });\n    define(\"components/flight/lib/logger\", [\"./compose\",\"./utils\",], function(a, b) {\n        function d(a) {\n            var b = ((a.tagName ? a.tagName.toLowerCase() : a.toString())), c = ((a.className ? ((\".\" + a.className)) : \"\")), d = ((b + c));\n            return ((a.tagName ? [\"'\",\"'\",].join(d) : d));\n        };\n    ;\n        function e(a, b, e) {\n            var f, g, h, i, j, k, l, m;\n            ((((typeof e[((e.length - 1))] == \"function\")) && (h = e.pop(), h = ((h.unbound || h))))), ((((typeof e[((e.length - 1))] == \"object\")) && e.pop())), ((((e.length == 2)) ? (g = e[0], f = e[1]) : (g = b.$node[0], f = e[0]))), ((((window.DEBUG && window.DEBUG.enabled)) && (j = DEBUG.events.logFilter, l = ((((j.actions == \"all\")) || ((j.actions.indexOf(a) > -1)))), k = function(a) {\n                return ((a.test ? a : new RegExp(((((\"^\" + a.replace(/\\*/g, \".*\"))) + \"$\")))));\n            }, m = ((((j.eventNames == \"all\")) || j.eventNames.some(function(a) {\n                return k(a).test(f);\n            }))), ((((l && m)) && JSBNG__console.info(c[a], a, ((((\"[\" + f)) + \"]\")), d(g), b.constructor.describe.split(\" \").slice(0, 3).join(\" \")))))));\n        };\n    ;\n        function f() {\n            this.before(\"trigger\", function() {\n                e(\"trigger\", this, b.toArray(arguments));\n            }), this.before(\"JSBNG__on\", function() {\n                e(\"JSBNG__on\", this, b.toArray(arguments));\n            }), this.before(\"off\", function(a) {\n                e(\"off\", this, b.toArray(arguments));\n            });\n        };\n    ;\n        var c = {\n            JSBNG__on: \"\\u003C-\",\n            trigger: \"-\\u003E\",\n            off: \"x \"\n        };\n        return f;\n    });\n    define(\"components/flight/lib/component\", [\"./advice\",\"./utils\",\"./compose\",\"./registry\",\"./logger\",\"../tools/debug/debug\",], function(a, b, c, d, e, f) {\n        function i(a) {\n            a.events.slice().forEach(function(a) {\n                var b = [a.type,];\n                ((a.element && b.unshift(a.element))), ((((typeof a.callback == \"function\")) && b.push(a.callback))), this.off.apply(this, b);\n            }, a.instance);\n        };\n    ;\n        function j() {\n            i(d.findInstanceInfo(this));\n        };\n    ;\n        function k() {\n            var a = d.findComponentInfo(this);\n            ((a && Object.keys(a.instances).forEach(function(b) {\n                var c = a.instances[b];\n                c.instance.teardown();\n            })));\n        };\n    ;\n        function l(a, b) {\n            try {\n                window.JSBNG__postMessage(b, \"*\");\n            } catch (c) {\n                throw JSBNG__console.log(\"unserializable data for event\", a, \":\", b), new Error([\"The event\",a,\"on component\",this.toString(),\"was triggered with non-serializable data\",].join(\" \"));\n            };\n        ;\n        };\n    ;\n        function m() {\n            this.trigger = function() {\n                var a, b, c, d, e, g = ((arguments.length - 1)), h = arguments[g];\n                return ((((((typeof h != \"string\")) && ((!h || !h.defaultBehavior)))) && (g--, c = h))), ((((g == 1)) ? (a = $(arguments[0]), d = arguments[1]) : (a = this.$node, d = arguments[0]))), ((d.defaultBehavior && (e = d.defaultBehavior, d = $.JSBNG__Event(d.type)))), b = ((d.type || d)), ((((f.enabled && window.JSBNG__postMessage)) && l.call(this, b, c))), ((((typeof this.attr.eventData == \"object\")) && (c = $.extend(!0, {\n                }, this.attr.eventData, c)))), a.trigger(((d || b)), c), ((((e && !d.isDefaultPrevented())) && ((this[e] || e)).call(this))), a;\n            }, this.JSBNG__on = function() {\n                var a, c, d, e, f = ((arguments.length - 1)), g = arguments[f];\n                ((((typeof g == \"object\")) ? e = b.delegate(this.resolveDelegateRules(g)) : e = g)), ((((f == 2)) ? (a = $(arguments[0]), c = arguments[1]) : (a = this.$node, c = arguments[0])));\n                if (((((typeof e != \"function\")) && ((typeof e != \"object\"))))) {\n                    throw new Error(((((\"Unable to bind to '\" + c)) + \"' because the given callback is not a function or an object\")));\n                }\n            ;\n            ;\n                return d = e.bind(this), d.target = e, ((e.guid && (d.guid = e.guid))), a.JSBNG__on(c, d), e.guid = d.guid, d;\n            }, this.off = function() {\n                var a, b, c, d = ((arguments.length - 1));\n                return ((((typeof arguments[d] == \"function\")) && (c = arguments[d], d -= 1))), ((((d == 1)) ? (a = $(arguments[0]), b = arguments[1]) : (a = this.$node, b = arguments[0]))), a.off(b, c);\n            }, this.resolveDelegateRules = function(a) {\n                var b = {\n                };\n                return Object.keys(a).forEach(function(c) {\n                    if (((!c in this.attr))) {\n                        throw new Error(((((((((\"Component \\\"\" + this.toString())) + \"\\\" wants to listen on \\\"\")) + c)) + \"\\\" but no such attribute was defined.\")));\n                    }\n                ;\n                ;\n                    b[this.attr[c]] = a[c];\n                }, this), b;\n            }, this.defaultAttrs = function(a) {\n                ((b.push(this.defaults, a, !0) || (this.defaults = a)));\n            }, this.select = function(a) {\n                return this.$node.JSBNG__find(this.attr[a]);\n            }, this.initialize = $.noop, this.teardown = j;\n        };\n    ;\n        function n(a) {\n            var c = arguments.length, e = new Array(((c - 1)));\n            for (var f = 1; ((f < c)); f++) {\n                e[((f - 1))] = arguments[f];\n            ;\n            };\n        ;\n            if (!a) {\n                throw new Error(\"Component needs to be attachTo'd a jQuery object, native node or selector string\");\n            }\n        ;\n        ;\n            var g = b.merge.apply(b, e);\n            $(a).each(function(a, b) {\n                var c = ((b.jQuery ? b[0] : b)), e = d.findComponentInfo(this);\n                if (((e && e.isAttachedTo(c)))) {\n                    return;\n                }\n            ;\n            ;\n                new this(b, g);\n            }.bind(this));\n        };\n    ;\n        function o() {\n            function l(a, b) {\n                b = ((b || {\n                })), this.identity = h++;\n                if (!a) {\n                    throw new Error(\"Component needs a node\");\n                }\n            ;\n            ;\n                ((a.jquery ? (this.node = a[0], this.$node = a) : (this.node = a, this.$node = $(a)))), this.toString = l.toString, ((f.enabled && (this.describe = this.toString())));\n                var c = Object.create(b);\n                {\n                    var fin48keys = ((window.top.JSBNG_Replay.forInKeys)((this.defaults))), fin48i = (0);\n                    var d;\n                    for (; (fin48i < fin48keys.length); (fin48i++)) {\n                        ((d) = (fin48keys[fin48i]));\n                        {\n                            ((b.hasOwnProperty(d) || (c[d] = this.defaults[d])));\n                        ;\n                        };\n                    };\n                };\n            ;\n                this.attr = c, this.initialize.call(this, b);\n            };\n        ;\n            var b = arguments.length, i = new Array(((b + 3)));\n            for (var j = 0; ((j < b)); j++) {\n                i[j] = arguments[j];\n            ;\n            };\n        ;\n            return l.toString = function() {\n                var a = i.map(function(a) {\n                    if (((a.JSBNG__name == null))) {\n                        var b = a.toString().match(g);\n                        return ((((b && b[1])) ? b[1] : \"\"));\n                    }\n                ;\n                ;\n                    return ((((a.JSBNG__name != \"withBaseComponent\")) ? a.JSBNG__name : \"\"));\n                }).filter(Boolean).join(\", \");\n                return a;\n            }, ((f.enabled && (l.describe = l.toString()))), l.attachTo = n, l.teardownAll = k, ((f.enabled && i.unshift(e))), i.unshift(m, a.withAdvice, d.withRegistration), c.mixin(l.prototype, i), l;\n        };\n    ;\n        var g = /function (.*?)\\s?\\(/, h = 0;\n        return o.teardownAll = function() {\n            d.components.slice().forEach(function(a) {\n                a.component.teardownAll();\n            }), d.reset();\n        }, o;\n    });\n    define(\"core/component\", [\"module\",\"require\",\"exports\",\"components/flight/lib/component\",], function(module, require, exports) {\n        var flightComponent = require(\"components/flight/lib/component\");\n        module.exports = flightComponent;\n    });\n    define(\"core/registry\", [\"module\",\"require\",\"exports\",\"components/flight/lib/registry\",], function(module, require, exports) {\n        var flightRegistry = require(\"components/flight/lib/registry\");\n        module.exports = flightRegistry;\n    });\n    provide(\"core/clock\", function(a) {\n        using(\"core/component\", \"core/registry\", function(b, c) {\n            function h() {\n            \n            };\n        ;\n            function i() {\n                this.timers = [], this.clockComponent = function() {\n                    if (((!this.currentClock || !c.findInstanceInfo(this.currentClock)))) {\n                        this.reset(), this.currentClock = new d(JSBNG__document);\n                    }\n                ;\n                ;\n                    return this.currentClock;\n                }, this.trigger = function(a, b) {\n                    this.clockComponent().trigger(a, b);\n                }, this.reset = function() {\n                    this.timers = [];\n                }, this.tick = function() {\n                    this.timers.forEach(function(a) {\n                        a.tick(f);\n                    });\n                }, this.setTicker = function() {\n                    this.pause(), this.ticker = window.JSBNG__setInterval(this.tick.bind(this), f);\n                }, this.init = function() {\n                    this.clockComponent(), ((this.ticker || this.setTicker()));\n                }, this.clear = function(a) {\n                    ((a && this.timers.splice(this.timers.indexOf(a), 1)));\n                }, this.setTimeoutEvent = function(a, b, c) {\n                    if (((typeof a != \"string\"))) {\n                        return JSBNG__console.error(\"clock.setTimeoutEvent was passed a function instead of a string.\");\n                    }\n                ;\n                ;\n                    this.init();\n                    var d = new k(a, b, c);\n                    return this.timers.push(d), d;\n                }, this.JSBNG__clearTimeout = function(a) {\n                    ((((a instanceof k)) && this.clear(a)));\n                }, this.setIntervalEvent = function(a, b, c) {\n                    if (((typeof a != \"string\"))) {\n                        return JSBNG__console.error(\"clock.setIntervalEvent was passed a function instead of a string.\");\n                    }\n                ;\n                ;\n                    this.init();\n                    var d = new m(a, b, c);\n                    return this.timers.push(d), d;\n                }, this.JSBNG__clearInterval = function(a) {\n                    ((((a instanceof m)) && this.clear(a)));\n                }, this.resume = this.restart = this.setTicker, this.pause = function(a, b) {\n                    JSBNG__clearInterval(((this.ticker || 0)));\n                };\n            };\n        ;\n            function j() {\n                this.callback = function() {\n                    e.trigger(this.eventName, this.data);\n                }, this.clear = function() {\n                    e.clear(this);\n                }, this.pause = function() {\n                    this.paused = !0;\n                }, this.resume = function() {\n                    this.paused = !1;\n                }, this.tickUnlessPaused = this.tick, this.tick = function() {\n                    if (this.paused) {\n                        return;\n                    }\n                ;\n                ;\n                    this.tickUnlessPaused.apply(this, arguments);\n                };\n            };\n        ;\n            function k(a, b, c) {\n                this.countdown = b, this.eventName = a, this.data = c;\n            };\n        ;\n            function m(a, b, c) {\n                this.countdown = this.interval = this.maxInterval = this.initialInterval = b, this.backoffFactor = g, this.eventName = a, this.data = c;\n            };\n        ;\n            var d = b(h), e = new i, f = 1000, g = 2, l = function() {\n                this.tick = function(a) {\n                    this.countdown -= a, ((((this.countdown <= 0)) && (this.clear(), this.callback())));\n                };\n            };\n            l.call(k.prototype), j.call(k.prototype);\n            var n = function() {\n                this.tick = function(a) {\n                    this.countdown -= a;\n                    if (((this.countdown <= 0))) {\n                        this.callback();\n                        if (((this.interval < this.maxInterval))) {\n                            var b = ((Math.ceil(((((this.interval * this.backoffFactor)) / f))) * f));\n                            this.interval = Math.min(b, this.maxInterval);\n                        }\n                    ;\n                    ;\n                        this.countdown = this.interval;\n                    }\n                ;\n                ;\n                }, this.backoff = function(a, b) {\n                    this.maxInterval = a, this.backoffFactor = ((b || g)), ((((this.interval > this.maxInterval)) && (this.interval = a)));\n                }, this.cancelBackoff = function() {\n                    this.interval = this.maxInterval = this.initialInterval, this.countdown = Math.min(this.countdown, this.interval), this.resume();\n                };\n            };\n            n.call(m.prototype), j.call(m.prototype), a(e);\n        });\n    });\n    define(\"core/compose\", [\"module\",\"require\",\"exports\",\"components/flight/lib/compose\",], function(module, require, exports) {\n        var flightCompose = require(\"components/flight/lib/compose\");\n        module.exports = flightCompose;\n    });\n    define(\"core/advice\", [\"module\",\"require\",\"exports\",\"components/flight/lib/advice\",], function(module, require, exports) {\n        var flightAdvice = require(\"components/flight/lib/advice\");\n        module.exports = flightAdvice;\n    });\n    provide(\"core/parameterize\", function(a) {\n        function c(a, c, d) {\n            return ((c ? a.replace(b, function(a, b) {\n                if (b) {\n                    if (c[b]) {\n                        return c[b];\n                    }\n                ;\n                ;\n                    if (d) {\n                        throw new Error(((\"Cannot parameterize string, no replacement found for \" + b)));\n                    }\n                ;\n                ;\n                    return \"\";\n                }\n            ;\n            ;\n                return a;\n            }) : a));\n        };\n    ;\n        var b = /\\{\\{(.+?)\\}\\}/g;\n        a(c);\n    });\n    provide(\"core/i18n\", function(a) {\n        using(\"core/parameterize\", function(b) {\n            a(b);\n        });\n    });\n    define(\"core/logger\", [\"module\",\"require\",\"exports\",\"components/flight/lib/logger\",], function(module, require, exports) {\n        var flightLogger = require(\"components/flight/lib/logger\");\n        module.exports = flightLogger;\n    });\n    define(\"core/utils\", [\"module\",\"require\",\"exports\",\"components/flight/lib/utils\",], function(module, require, exports) {\n        var flightUtils = require(\"components/flight/lib/utils\");\n        module.exports = flightUtils;\n    });\n    define(\"debug/debug\", [\"module\",\"require\",\"exports\",\"components/flight/tools/debug/debug\",], function(module, require, exports) {\n        var flightDebug = require(\"components/flight/tools/debug/debug\");\n        module.exports = flightDebug;\n    });\n    provide(\"app/utils/auth_token\", function(a) {\n        var b;\n        a({\n            get: function() {\n                if (!b) {\n                    throw new Error(\"authToken should have been set!\");\n                }\n            ;\n            ;\n                return b;\n            },\n            set: function(a) {\n                b = a;\n            },\n            addTo: function(a, c) {\n                return a.authenticity_token = b, ((c && (a.post_authenticity_token = b))), a;\n            }\n        });\n    });\n    define(\"app/data/scribe_transport\", [\"module\",\"require\",\"exports\",], function(module, require, exports) {\n        function ScribeTransport(a) {\n            this.SESSION_BUFFER_KEY = \"ScribeTransport\", this.SCRIBE_API_ENDPOINT = \"/i/jot\", this.options = {\n            }, ((a && (this.updateOptions(a), this.registerEventHandlers(a))));\n        };\n    ;\n        ScribeTransport.prototype = {\n            flush: function(a, b) {\n                if (((!a || !a.length))) {\n                    return;\n                }\n            ;\n            ;\n                ((((b === undefined)) && (b = !!this.options.sync)));\n                if (this.options.useAjax) {\n                    var c = {\n                        url: this.options.url,\n                        data: $.extend(this.ajaxParams(a), this.options.requestParameters),\n                        type: \"POST\",\n                        dataType: \"json\",\n                        async: !b\n                    };\n                    ((this.options.debug && (((this.options.debugHandler && (c.success = this.options.debugHandler))), c.data.debug = \"1\"))), $.ajax(c);\n                }\n                 else {\n                    var d = ((this.options.debug ? \"&debug=1\" : \"\"));\n                    (new JSBNG__Image).src = ((((((((((this.options.url + \"?q=\")) + (+(new JSBNG__Date)).toString().slice(-4))) + d)) + \"&\")) + this.imageParams(a)));\n                }\n            ;\n            ;\n                this.reset();\n            },\n            ajaxParams: function(a) {\n                if (((typeof a == \"string\"))) {\n                    return {\n                        log: ((((\"[\" + a)) + \"]\"))\n                    };\n                }\n            ;\n            ;\n                var b = this.options.encodeParameters;\n                return ((((b && ((typeof b == \"function\")))) ? b.apply(this, arguments) : {\n                    log: JSON.stringify(a)\n                }));\n            },\n            imageParams: function(a) {\n                if (((typeof a == \"string\"))) {\n                    return ((((\"log=%5B\" + a)) + \"%5D\"));\n                }\n            ;\n            ;\n                var b = this.options.encodeParameters;\n                return ((((b && ((typeof b == \"function\")))) ? b.apply(this, arguments) : ((\"log=\" + encodeURIComponent(JSON.stringify(a))))));\n            },\n            reset: function() {\n                ((this.options.bufferEvents && (this.skipUnloadFlush = !1, JSBNG__sessionStorage.removeItem(this.options.bufferKey))));\n            },\n            getBuffer: function() {\n                return ((JSBNG__sessionStorage.getItem(this.options.bufferKey) || \"\"));\n            },\n            send: function(a, b, c) {\n                if (((((!b || !a)) || ((this.options.bufferSize < 0))))) {\n                    return;\n                }\n            ;\n            ;\n                a._category_ = b;\n                if (((((c || !this.options.bufferEvents)) || !this.options.bufferSize))) this.flush([a,], c);\n                 else {\n                    var d = JSON.stringify(a);\n                    ((this.options.useAjax || (d = encodeURIComponent(d))));\n                    var e = this.getBuffer(), f = ((e + ((e ? ((this.SEPARATOR + d)) : d))));\n                    ((((this.options.bufferSize && this.fullBuffer(f))) ? ((this.options.useAjax ? this.flush(f) : (this.flush(e), JSBNG__sessionStorage.setItem(this.options.bufferKey, d)))) : JSBNG__sessionStorage.setItem(this.options.bufferKey, f)));\n                }\n            ;\n            ;\n                ((this.options.debug && $(JSBNG__document).trigger(((\"scribedata.\" + this.options.bufferKey)), a))), ((((this.options.metrics && ((a.event_info != \"debug\")))) && $(JSBNG__document).trigger(\"debugscribe\", a)));\n            },\n            fullBuffer: function(a) {\n                return ((a.length >= ((this.options.useAjax ? ((this.options.bufferSize * 2083)) : ((2050 - this.options.url.length))))));\n            },\n            updateOptions: function(a) {\n                this.options = $.extend({\n                }, this.options, a), ((this.options.requestParameters || (this.options.requestParameters = {\n                }))), ((((this.options.flushOnUnload === undefined)) && (this.options.flushOnUnload = !0))), ((this.options.bufferKey || (this.options.bufferKey = this.SESSION_BUFFER_KEY))), ((((this.options.bufferSize === 0)) && (this.options.bufferEvents = !1))), ((((this.options.useAjax === undefined)) && (this.options.useAjax = !0)));\n                if (((this.options.bufferEvents || ((this.options.bufferEvents == undefined))))) {\n                    try {\n                        JSBNG__sessionStorage.setItem(((this.SESSION_BUFFER_KEY + \".init\")), \"test\");\n                        var b = ((JSBNG__sessionStorage.getItem(((this.SESSION_BUFFER_KEY + \".init\"))) == \"test\"));\n                        JSBNG__sessionStorage.removeItem(((this.SESSION_BUFFER_KEY + \".init\"))), this.options.bufferEvents = b;\n                    } catch (c) {\n                        this.options.bufferEvents = !1;\n                    };\n                }\n            ;\n            ;\n                if (((this.options.debug && !this.options.debugHandler))) {\n                    var d = this;\n                    this.options.debugHandler = ((a.debugHandler || function(a) {\n                        $(JSBNG__document).trigger(((\"handlescribe.\" + d.options.bufferKey)), a);\n                    }));\n                }\n            ;\n            ;\n                var e = ((((window.JSBNG__location.protocol === \"https:\")) ? \"https:\" : \"http:\"));\n                ((((this.options.url === undefined)) ? ((this.options.useAjax ? this.options.url = this.SCRIBE_API_ENDPOINT : this.options.url = ((\"https://twitter.com\" + this.SCRIBE_API_ENDPOINT)))) : this.options.url = this.options.url.replace(/^[a-z]+:/g, e).replace(/\\/$/, \"\"))), ((((this.options.bufferEvents && ((this.options.bufferSize === undefined)))) && (this.options.bufferSize = 20)));\n            },\n            appHost: function() {\n                return window.JSBNG__location.host;\n            },\n            registerEventHandlers: function() {\n                var a = this, b = $(JSBNG__document);\n                if (this.options.bufferEvents) {\n                    b.JSBNG__on(((\"flushscribe.\" + a.options.bufferKey)), function(b) {\n                        a.flush(a.getBuffer(), !0);\n                    });\n                    if (this.options.flushOnUnload) {\n                        var c = function(b) {\n                            a.skipUnloadFlush = ((((!b || !b.match(/http/))) || !!b.match(new RegExp(((\"^https?://\" + a.appHost())), \"gi\")))), ((a.skipUnloadFlush && window.JSBNG__setTimeout(function() {\n                                a.skipUnloadFlush = !1;\n                            }, 3000)));\n                        };\n                        b.JSBNG__on(((\"mouseup.\" + this.options.bufferKey)), \"a\", function(a) {\n                            if (((((((((((this.getAttribute(\"target\") || a.button)) || a.metaKey)) || a.shiftKey)) || a.altKey)) || a.ctrlKey))) {\n                                return;\n                            }\n                        ;\n                        ;\n                            c(this.getAttribute(\"href\"));\n                        }), b.JSBNG__on(((\"submit.\" + this.options.bufferKey)), \"form\", function(a) {\n                            c(this.getAttribute(\"action\"));\n                        }), b.JSBNG__on(((\"uiNavigate.\" + this.options.bufferKey)), function(a, b) {\n                            c(b.url);\n                        }), $(window).JSBNG__on(((\"unload.\" + this.options.bufferKey)), function() {\n                            ((a.skipUnloadFlush || a.flush(a.getBuffer(), !0))), a.skipUnloadFlush = !1;\n                        });\n                    }\n                ;\n                ;\n                }\n            ;\n            ;\n                this.SEPARATOR = ((this.options.useAjax ? \",\" : encodeURIComponent(\",\")));\n            },\n            destroy: function() {\n                this.flush(this.getBuffer()), $(JSBNG__document).off(((\"flushscribe.\" + this.options.bufferKey))), $(window).off(((\"unload.\" + this.options.bufferKey))), $(JSBNG__document).off(((\"mouseup.\" + this.options.bufferKey))), $(JSBNG__document).off(((\"submit.\" + this.options.bufferKey))), $(JSBNG__document).off(((\"uiNavigate.\" + this.options.bufferKey)));\n            }\n        }, module.exports = new ScribeTransport;\n    });\n    define(\"app/data/scribe_monitor\", [\"module\",\"require\",\"exports\",\"core/component\",], function(module, require, exports) {\n        function scribeMonitor() {\n            function a(a) {\n                if (((window.scribeConsole && window.scribeConsole.JSBNG__postMessage))) {\n                    var b = ((((window.JSBNG__location.protocol + \"//\")) + window.JSBNG__location.host));\n                    try {\n                        window.scribeConsole.JSBNG__postMessage(a, b);\n                    } catch (c) {\n                        var d = ((((\"ScribeMonitor.postToConsole - Scribe Console error or unserializable data [\" + a._category_)) + \"]\"));\n                        JSBNG__console.error(d, a);\n                    };\n                ;\n                }\n            ;\n            ;\n            };\n        ;\n            this.after(\"initialize\", function() {\n                this.JSBNG__on(\"keypress\", function(a) {\n                    if (((((((a.charCode == 205)) && a.shiftKey)) && a.altKey))) {\n                        var b = \"menubar=no,toolbar=no,personalbar=no,location=no,resizable=yes,status=no,dependent=yes,height=600,width=600,screenX=100,screenY=100,scrollbars=yes\", c = window.JSBNG__location.host;\n                        if (((!c || !c.match(/^(staging[0-9]+\\.[^\\.]+\\.twitter.com|twitter\\.com|localhost\\.twitter\\.com\\:[0-9]+)$/)))) {\n                            c = \"twitter.com\";\n                        }\n                    ;\n                    ;\n                        window.scribeConsole = window.open(((((((window.JSBNG__location.protocol + \"//\")) + c)) + \"/scribe/console\")), \"scribe_console\", b);\n                    }\n                ;\n                ;\n                }), this.JSBNG__on(\"scribedata.ScribeTransport handlescribe.ScribeTransport\", function(b, c) {\n                    a(c);\n                }), ((this.attr.scribesForScribeConsole && this.JSBNG__on(\"uiSwiftLoaded uiPageChanged\", function(b, c) {\n                    ((((((b.type == \"uiSwiftLoaded\")) || !c.fromCache)) && this.attr.scribesForScribeConsole.forEach(function(b) {\n                        b._category_ = \"client_event\", a(b);\n                    })));\n                })));\n            });\n        };\n    ;\n        var defineComponent = require(\"core/component\");\n        module.exports = defineComponent(scribeMonitor);\n    });\n    define(\"app/data/client_event\", [\"module\",\"require\",\"exports\",\"app/data/scribe_transport\",], function(module, require, exports) {\n        function ClientEvent(a) {\n            this.scribeContext = {\n            }, this.scribeData = {\n            }, this.scribe = function(b, c) {\n                var d = ((a || window.scribeTransport));\n                if (!d) {\n                    throw new Error(\"You must create a global scribeTransport variable or pass one into this constructor.\");\n                }\n            ;\n            ;\n                if (((((!b || ((typeof b != \"object\")))) || ((c && ((typeof c != \"object\"))))))) {\n                    throw new Error(\"Invalid terms or data hash argument when calling ClientEvent.scribe().\");\n                }\n            ;\n            ;\n                if (this.scribeContext) {\n                    var e = ((((typeof this.scribeContext == \"function\")) ? this.scribeContext() : this.scribeContext));\n                    b = $.extend({\n                    }, e, b);\n                }\n            ;\n            ;\n                {\n                    var fin49keys = ((window.top.JSBNG_Replay.forInKeys)((b))), fin49i = (0);\n                    var f;\n                    for (; (fin49i < fin49keys.length); (fin49i++)) {\n                        ((f) = (fin49keys[fin49i]));\n                        {\n                            b[f] = ((b[f] && ((\"\" + b[f])).toLowerCase().replace(/_?[^a-z0-9_]+_?/g, \"_\")));\n                        ;\n                        };\n                    };\n                };\n            ;\n                ((d.options.debug && $.each([\"client\",\"action\",], function(a, c) {\n                    if (!b[c]) {\n                        throw new Error(((((\"You must specify a \" + c)) + \" term in your client_event.\")));\n                    }\n                ;\n                ;\n                })));\n                var c = $.extend({\n                }, c);\n                if (this.scribeData) {\n                    var g = ((((typeof this.scribeData == \"function\")) ? this.scribeData() : this.scribeData));\n                    c = $.extend({\n                    }, g, c);\n                }\n            ;\n            ;\n                c.event_namespace = b, c.triggered_on = ((c.triggered_on || +(new JSBNG__Date))), c.format_version = ((c.format_version || 2)), d.send(c, \"client_event\");\n            };\n        };\n    ;\n        var scribeTransport = require(\"app/data/scribe_transport\");\n        module.exports = new ClientEvent(scribeTransport);\n    });\n    define(\"app/data/ddg\", [\"module\",\"require\",\"exports\",\"app/data/client_event\",], function(module, require, exports) {\n        function DDG(a, b) {\n            this.experiments = ((a || {\n            })), this.impressions = {\n            }, this.scribeExperiment = function(a, c, d) {\n                var e = $.extend({\n                    page: \"ddg\",\n                    section: a.experiment_key,\n                    component: \"\",\n                    element: \"\"\n                }, c);\n                d = ((d || {\n                })), d.experiment_key = a.experiment_key, d.bucket = a.bucket, d.version = a.version, ((b || window.clientEvent)).scribe(e, d);\n            }, this.impression = function(a) {\n                var b = this.experiments[a];\n                ((b && (a = b.experiment_key, ((this.impressions[a] || (this.scribeExperiment(b, {\n                    action: \"experiment\"\n                }), this.impressions[a] = !0))))));\n            }, this.track = function(a, b, c) {\n                if (!b) {\n                    throw new Error(\"You must specify an event name to track custom DDG events. Event names should be lower-case, snake_cased strings.\");\n                }\n            ;\n            ;\n                var d = this.experiments[a];\n                ((d && this.scribeExperiment(d, {\n                    element: b,\n                    action: \"track\"\n                }, c)));\n            }, this.bucket = function(a) {\n                var b = this.experiments[a];\n                return ((b ? b.bucket : \"\"));\n            };\n        };\n    ;\n        var clientEvent = require(\"app/data/client_event\");\n        module.exports = new DDG({\n        }, clientEvent);\n    });\n    define(\"app/utils/scribe_association_types\", [\"module\",\"require\",\"exports\",], function(module, require, exports) {\n        module.exports = {\n            associatedTweet: 1,\n            platformCardPublisher: 2,\n            platformCardCreator: 3,\n            conversationOrigin: 4,\n            associatedUser: 5,\n            associatedTimeline: 6\n        };\n    });\n    define(\"app/data/with_scribe\", [\"module\",\"require\",\"exports\",\"app/data/client_event\",\"core/utils\",], function(module, require, exports) {\n        function withScribe() {\n            function a(a) {\n                if (!a) {\n                    return;\n                }\n            ;\n            ;\n                a = ((a.sourceEventData ? a.sourceEventData : a));\n                if (((a.scribeContext || a.scribeData))) {\n                    return a;\n                }\n            ;\n            ;\n            };\n        ;\n            this.scribe = function() {\n                var b = Array.prototype.slice.call(arguments), c, d, e, f, g;\n                c = ((((typeof b[0] == \"string\")) ? {\n                    action: b[0]\n                } : b[0])), b.shift();\n                if (b[0]) {\n                    e = b[0], ((e.sourceEventData && (e = e.sourceEventData)));\n                    if (((e.scribeContext || e.scribeData))) {\n                        f = e.scribeContext, g = e.scribeData;\n                    }\n                ;\n                ;\n                    ((((((((b[0].scribeContext || b[0].scribeData)) || b[0].sourceEventData)) || ((b.length === 2)))) && b.shift()));\n                }\n            ;\n            ;\n                c = utils.merge({\n                }, f, c), d = ((((typeof b[0] == \"function\")) ? b[0].bind(this)(e) : b[0])), d = utils.merge({\n                }, g, d), this.transport(c, d);\n            }, this.scribeOnEvent = function(b, c, d) {\n                this.JSBNG__on(b, function(a, b) {\n                    b = ((b || {\n                    })), this.scribe(c, ((b.sourceEventData || b)), d);\n                });\n            }, this.transport = function(b, c) {\n                clientEvent.scribe(b, c);\n            };\n        };\n    ;\n        var clientEvent = require(\"app/data/client_event\"), utils = require(\"core/utils\");\n        module.exports = withScribe;\n    });\n    define(\"app/utils/with_session\", [\"module\",\"require\",\"exports\",], function(module, require, exports) {\n        function withSession() {\n            this.setSessionItem = function(a, b) {\n                ((window.JSBNG__sessionStorage && JSBNG__sessionStorage.setItem(a, b)));\n            }, this.removeSessionItem = function(a) {\n                ((window.JSBNG__sessionStorage && JSBNG__sessionStorage.removeItem(a)));\n            }, this.getSessionItem = function(a) {\n                return ((window.JSBNG__sessionStorage && JSBNG__sessionStorage.getItem(a)));\n            }, this.setSessionObject = function(a, b) {\n                ((((b === undefined)) ? this.removeSessionItem(a) : this.setSessionItem(a, JSON.stringify(b))));\n            }, this.getSessionObject = function(a) {\n                var b = this.getSessionItem(a);\n                return ((((b === undefined)) ? b : JSON.parse(b)));\n            };\n        };\n    ;\n        module.exports = withSession;\n    });\n    define(\"app/utils/scribe_item_types\", [\"module\",\"require\",\"exports\",], function(module, require, exports) {\n        module.exports = {\n            tweet: 0,\n            promotedTweet: 1,\n            popularTweet: 2,\n            retweet: 10,\n            user: 3,\n            promotedUser: 4,\n            message: 6,\n            story: 7,\n            trend: 8,\n            promotedTrend: 9,\n            popularTrend: 15,\n            list: 11,\n            search: 12,\n            savedSearch: 13,\n            peopleSearch: 14\n        };\n    });\n    define(\"app/data/with_interaction_data_scribe\", [\"module\",\"require\",\"exports\",\"core/compose\",\"app/data/with_scribe\",\"app/utils/with_session\",\"app/utils/scribe_item_types\",\"app/utils/scribe_association_types\",\"app/data/client_event\",\"core/utils\",], function(module, require, exports) {\n        function withInteractionDataScribe() {\n            this.defaultAttrs({\n                profileClickContextExpirationMs: 600000,\n                profileClickContextSessionKey: \"profileClickContext\"\n            }), compose.mixin(this, [withScribe,withSession,]), this.scribeInteraction = function(a, b, c) {\n                if (((!a || !b))) {\n                    return;\n                }\n            ;\n            ;\n                ((((typeof a == \"string\")) && (a = {\n                    action: a\n                })));\n                var d = a.action;\n                if (!d) {\n                    return;\n                }\n            ;\n            ;\n                b = utils.merge(b, b.sourceEventData), a = this.getInteractionScribeContext(a, b);\n                var e = {\n                };\n                ((b.url && (e.url = b.url))), ((b.query && (e.query = b.query))), ((b.impressionId && (e.promoted = !0)));\n                var f = this.interactionItem(b);\n                ((f && (e.items = [f,])));\n                var g = this.interactionTarget(b, a);\n                ((g && (e.targets = [g,]))), c = utils.merge(e, c, b.scribeData), ((b.conversationOriginTweetId && (c.associations = ((c.associations || {\n                })), c.associations[associationTypes.conversationOrigin] = {\n                    association_id: b.conversationOriginTweetId,\n                    association_type: itemTypes.tweet\n                }))), ((((((d == \"profile_click\")) || ((d == \"mention_click\")))) && this.saveProfileClickContext(b)));\n                if (((((d == \"report_as_spam\")) || ((d == \"block\"))))) {\n                    var h = this.getUserActionAssociations(b);\n                    ((h && (c.associations = utils.merge(c.associations, h))));\n                }\n            ;\n            ;\n                this.scribe(a, b, c);\n            }, this.interactionItem = function(a) {\n                var b = {\n                };\n                if (((((a.position === 0)) || a.position))) {\n                    b.position = a.position;\n                }\n            ;\n            ;\n                ((a.impressionId && (b.promoted_id = a.impressionId)));\n                switch (a.itemType) {\n                  case \"user\":\n                    this.userDetails(b, a);\n                    break;\n                  case \"tweet\":\n                    this.tweetDetails(b, a), this.cardDetails(b, a), this.translationDetails(b, a), this.conversationDetails(b, a);\n                    break;\n                  case \"activity\":\n                    this.activityDetails(b, a), ((((a.activityType == \"follow\")) ? (this.userDetails(b, a), ((a.isNetworkActivity || (b.id = this.attr.userId)))) : ((a.listId ? this.listDetails(b, a) : (this.tweetDetails(b, a), this.cardDetails(b, a))))));\n                    break;\n                  case \"story\":\n                    this.storyDetails(b, a), ((a.tweetId ? this.tweetDetails(b, a) : ((a.userId ? this.userDetails(b, a) : b.item_type = itemTypes.story))));\n                };\n            ;\n                return b;\n            }, this.interactionTarget = function(a, b) {\n                if (this.isUserTarget(b.action)) {\n                    var c = ((((a.isMentionClick ? a.userId : a.targetUserId)) || a.userId));\n                    return this.userDetails({\n                    }, {\n                        userId: c\n                    });\n                }\n            ;\n            ;\n            }, this.tweetDetails = function(a, b) {\n                return a.id = b.tweetId, a.item_type = itemTypes.tweet, ((b.relevanceType && (a.is_popular_tweet = !0))), ((b.retweetId && (a.retweeting_tweet_id = b.retweetId))), a;\n            }, this.cardDetails = function(a, b) {\n                return ((b.cardItem && utils.push(a, b.cardItem))), a;\n            }, this.translationDetails = function(a, b) {\n                return a.dest = b.dest, a;\n            }, this.conversationDetails = function(a, b) {\n                ((b.isConversation && (a.description = \"focal\"))), ((b.isConversationComponent && (a.description = b.description, a.id = b.tweetId)));\n            }, this.userDetails = function(a, b) {\n                return a.id = ((b.containerUserId || b.userId)), a.item_type = itemTypes.user, ((b.feedbackToken && (a.token = b.feedbackToken))), a;\n            }, this.listDetails = function(a, b) {\n                return a.id = b.listId, a.item_type = itemTypes.list, a;\n            }, this.activityDetails = function(a, b) {\n                return a.activity_type = b.activityType, ((b.actingUserIds && (a.acting_user_ids = b.actingUserIds))), a;\n            }, this.storyDetails = function(a, b) {\n                return a.story_type = b.storyType, a.story_source = b.storySource, a.social_proof_type = b.socialProofType, a;\n            }, this.isUserTarget = function(a) {\n                return (([\"mention_click\",\"profile_click\",\"follow\",\"unfollow\",\"block\",\"unblock\",\"report_as_spam\",\"add_to_list\",\"dm\",].indexOf(a) != -1));\n            }, this.getInteractionScribeContext = function(a, b) {\n                return ((((((a.action == \"profile_click\")) && ((a.element === undefined)))) && (a.element = ((b.isPromotedBadgeClick ? \"promoted_badge\" : b.profileClickTarget))))), a;\n            }, this.scribeInteractiveResults = function(a, b, c, d) {\n                var e = [], f = !1;\n                ((((typeof a == \"string\")) && (a = {\n                    action: a\n                })));\n                if (((!a.action || !b))) {\n                    return;\n                }\n            ;\n            ;\n                ((b.length || (a.action = \"no_results\"))), b.forEach(function(a) {\n                    ((f || (f = !!a.impressionId))), e.push(this.interactionItem(a));\n                }.bind(this)), a = this.getInteractionScribeContext(a, c);\n                var g = {\n                };\n                ((((e && e.length)) && (g.items = e))), ((f && (g.promoted = !0))), this.scribe(a, c, utils.merge(g, d));\n            }, this.associationNamespace = function(a, b) {\n                var c = {\n                    page: a.page,\n                    section: a.section\n                };\n                return (((([\"conversation\",\"replies\",\"in_reply_to\",].indexOf(b) >= 0)) && (c.component = b))), c;\n            }, this.getProfileUserAssociations = function() {\n                var a = ((this.attr.profile_user && this.attr.profile_user.id_str)), b = null;\n                return ((a && (b = {\n                }, b[associationTypes.associatedUser] = {\n                    association_id: a,\n                    association_type: itemTypes.user,\n                    association_namespace: this.associationNamespace(clientEvent.scribeContext)\n                }))), b;\n            }, this.getProfileClickContextAssociations = function(a) {\n                var b = ((this.getSessionObject(this.attr.profileClickContextSessionKey) || null));\n                return ((((((((b && ((b.userId == a)))) && ((b.expires > (new JSBNG__Date).getTime())))) && b.associations)) || null));\n            }, this.saveProfileClickContext = function(a) {\n                var b = {\n                };\n                ((a.tweetId ? (b[associationTypes.associatedTweet] = {\n                    association_id: a.tweetId,\n                    association_type: itemTypes.tweet,\n                    association_namespace: this.associationNamespace(clientEvent.scribeContext, a.scribeContext.component)\n                }, ((a.conversationOriginTweetId && (b[associationTypes.conversationOrigin] = {\n                    association_id: a.conversationOriginTweetId,\n                    association_type: itemTypes.tweet\n                })))) : b = this.getProfileUserAssociations())), this.setSessionObject(this.attr.profileClickContextSessionKey, {\n                    userId: a.userId,\n                    associations: b,\n                    expires: (((new JSBNG__Date).getTime() + this.attr.profileClickContextExpirationMs))\n                });\n            }, this.getUserActionAssociations = function(a) {\n                var b = a.scribeContext.component, c;\n                return ((((((b == \"profile_dialog\")) || ((b == \"profile_follow_card\")))) ? c = this.getProfileClickContextAssociations(a.userId) : ((((b == \"user\")) ? c = this.getProfileUserAssociations() : c = null)))), c;\n            };\n        };\n    ;\n        var compose = require(\"core/compose\"), withScribe = require(\"app/data/with_scribe\"), withSession = require(\"app/utils/with_session\"), itemTypes = require(\"app/utils/scribe_item_types\"), associationTypes = require(\"app/utils/scribe_association_types\"), clientEvent = require(\"app/data/client_event\"), utils = require(\"core/utils\");\n        module.exports = withInteractionDataScribe;\n    });\n    define(\"app/utils/scribe_card_types\", [\"module\",\"require\",\"exports\",], function(module, require, exports) {\n        module.exports = {\n            photoTweet: 1,\n            photoCard: 2,\n            playerCard: 3,\n            summaryCard: 4,\n            promotionCard: 5,\n            plusCard: 6\n        };\n    });\n    define(\"app/data/with_card_metadata\", [\"module\",\"require\",\"exports\",\"core/compose\",\"app/utils/scribe_association_types\",\"app/data/with_interaction_data_scribe\",\"app/utils/scribe_item_types\",\"app/utils/scribe_card_types\",], function(module, require, exports) {\n        function withCardMetadata() {\n            compose.mixin(this, [withInteractionDataScribe,]);\n            var a = \"Swift-1\";\n            this.cardAssociationsForData = function(a) {\n                var b = {\n                    associations: {\n                    }\n                };\n                return b.associations[associationTypes.platformCardPublisher] = {\n                    association_id: a.publisherUserId,\n                    association_type: itemTypes.user\n                }, b.associations[associationTypes.platformCardCreator] = {\n                    association_id: a.creatorUserId,\n                    association_type: itemTypes.user\n                }, b.message = a.cardUrl, b;\n            }, this.getCardDataFromTweet = function(a) {\n                var b = {\n                }, c = a.closest(\".tweet\"), d, e, f, g;\n                return (((d = c.closest(\".permalink-tweet-container\")).length || (d = $(c.attr(\"data-expanded-footer\"))))), b.tweetHasCard = c.hasClass(\"has-cards\"), g = !!d.JSBNG__find(\".card2\").length, b.interactionInsideCard = !1, ((g ? (b.tweetHasCard2 = g, b.tweetPreExpanded = c.hasClass(\"preexpanded\"), b.itemId = ((c.attr(\"data-item-id\") || null)), b.promotedId = ((c.attr(\"data-impression-id\") || null)), f = d.JSBNG__find(\".card2\"), b.cardName = f.attr(\"data-card2-name\"), b.cardUrl = f.JSBNG__find(\".card2-holder\").attr(\"data-card2-url\"), b.publisherUserId = this.getUserIdFromElement(f.JSBNG__find(\".card2-attribution\").JSBNG__find(\".js-user-profile-link\")), b.creatorUserId = this.getUserIdFromElement(f.JSBNG__find(\".card2-byline\").JSBNG__find(\".js-user-profile-link\")), b.interactionInsideCard = !!a.closest(\".card2\").length) : ((b.tweetHasCard && (e = d.JSBNG__find(\".cards-base\"), ((((e.length > 0)) && (b.cardType = e.data(\"card-type\"), b.cardUrl = e.data(\"card-url\"), b.publisherUserId = this.getUserIdFromElement(e.JSBNG__find(\".source .js-user-profile-link\")), b.creatorUserId = this.getUserIdFromElement(e.JSBNG__find(\".byline .js-user-profile-link\")), b.interactionInsideCard = this.interactionInsideCard(a))))))))), b;\n            }, this.interactionInsideCard = function(a) {\n                return !!a.closest(\".cards-base\").length;\n            }, this.scribeCardInteraction = function(a, b) {\n                ((b.tweetHasCard2 ? this.scribeCard2Interaction(a, b) : ((b.tweetHasCard && this.scribeClassicCardInteraction(a, b)))));\n            }, this.scribeClassicCardInteraction = function(a, b) {\n                var c = this.cardAssociationsForData(b);\n                this.scribeInteraction({\n                    element: ((((\"platform_\" + b.cardType)) + \"_card\")),\n                    action: a\n                }, b, c);\n            }, this.getCard2Item = function(b) {\n                return {\n                    item_type: itemTypes.tweet,\n                    id: b.itemId,\n                    promoted_id: b.promotedId,\n                    pre_expanded: ((b.tweetPreExpanded || !1)),\n                    card_type: cardTypes.plusCard,\n                    card_name: b.cardName,\n                    card_url: b.cardUrl,\n                    card_platform_key: a,\n                    publisher_id: b.publisherUserId\n                };\n            }, this.scribeCard2Interaction = function(a, b) {\n                var c = {\n                    items: [this.getCard2Item(b),]\n                };\n                this.scribeInteraction({\n                    element: \"platform_card\",\n                    action: a\n                }, b, c);\n            }, this.getUserIdFromElement = function(a) {\n                return ((a.length ? a.attr(\"data-user-id\") : null));\n            };\n        };\n    ;\n        var compose = require(\"core/compose\"), associationTypes = require(\"app/utils/scribe_association_types\"), withInteractionDataScribe = require(\"app/data/with_interaction_data_scribe\"), itemTypes = require(\"app/utils/scribe_item_types\"), cardTypes = require(\"app/utils/scribe_card_types\");\n        module.exports = withCardMetadata;\n    });\n    define(\"app/data/with_conversation_metadata\", [\"module\",\"require\",\"exports\",], function(module, require, exports) {\n        module.exports = function() {\n            this.defaultAttrs({\n                hasConversationModuleClassAlt: \"has-conversation-module\",\n                conversationModuleSelectorAlt: \".conversation-module\",\n                rootClass: \"root\",\n                conversationRootTweetSelector: \".conversation-module .conversation-tweet-item.root .tweet\",\n                conversationAncestorTweetSelector: \".conversation-module .conversation-tweet-item:not(root) .tweet\"\n            }), this.getConversationAttrs = function(a) {\n                var b = {\n                };\n                if (a.hasClass(this.attr.hasConversationModuleClass)) {\n                    var c = a.closest(this.attr.conversationModuleSelector);\n                    b.isConversation = !0, b.conversationAncestors = c.attr(\"data-ancestors\").split(\",\");\n                }\n                 else ((a.hasClass(\"conversation-tweet\") && (b.isConversationComponent = !0, b.description = ((a.hasClass(this.attr.rootClass) ? \"root\" : \"ancestor\")))));\n            ;\n            ;\n                return b;\n            }, this.conversationComponentInteractionData = function(a, b) {\n                return {\n                    itemType: \"tweet\",\n                    tweetId: $(a).attr(\"data-item-id\"),\n                    description: b,\n                    isConversationComponent: !0\n                };\n            }, this.extraInteractionData = function(a) {\n                if (((a.JSBNG__find(this.attr.conversationModuleSelector).length > 0))) {\n                    var b = a.JSBNG__find(this.conversationRootTweetSelector).map(function(a, b) {\n                        return this.conversationComponentInteractionData(b, \"root\");\n                    }.bind(this)).get(), c = a.JSBNG__find(this.attr.conversationAncestorTweetSelector).map(function(a, b) {\n                        return this.conversationComponentInteractionData(b, \"ancestor\");\n                    }.bind(this)).get();\n                    return b.concat(c);\n                }\n            ;\n            ;\n                return [];\n            }, this.addConversationScribeContext = function(a, b) {\n                return ((((b && b.isConversation)) ? (a.component = \"conversation\", a.element = \"tweet\") : ((((b && b.isConversationComponent)) && (a.component = \"conversation\", a.element = b.description))))), a;\n            }, this.after(\"initialize\", function() {\n                ((this.attr.conversationModuleSelector || (this.attr.conversationModuleSelector = this.attr.conversationModuleSelectorAlt))), ((this.attr.hasConversationModuleClass || (this.attr.hasConversationModuleClass = this.attr.hasConversationModuleClassAlt)));\n            });\n        };\n    });\n    define(\"app/ui/with_interaction_data\", [\"module\",\"require\",\"exports\",\"core/compose\",\"core/utils\",\"app/data/with_card_metadata\",\"app/data/with_conversation_metadata\",], function(module, require, exports) {\n        function withInteractionData() {\n            compose.mixin(this, [withCardMetadata,withConversationMetadata,]), this.defaultAttrs({\n                genericInteractionItemSelector: \".js-stream-item\",\n                expandoContainerSelector: \".expanded-conversation\",\n                expandoAncestorSelector: \".ancestor\",\n                expandoDescendantSelector: \".descendant\",\n                streamItemContainerSelector: \".js-stream-item, .permalink\",\n                activityTargetSelector: \".activity-truncated-tweet .js-actionable-tweet, .js-activity-list_member_added [data-list-id]\",\n                activityItemSelector: \".js-activity\",\n                itemAvatarSelector: \".js-action-profile-avatar, .avatar.size48\",\n                itemSmallAvatarSelector: \".avatar.size24, .avatar.size32\",\n                itemMentionSelector: \".twitter-atreply\",\n                discoveryStoryItemSelector: \".js-story-item\",\n                discoveryStoryHeadlineSelector: \".js-news-headline a\",\n                originalTweetSelector: \".js-original-tweet[data-tweet-id]\",\n                promotedBadgeSelector: \".js-promoted-badge\",\n                elementContextSelector: \"[data-element-context]\",\n                componentContextSelector: \"[data-component-context]\",\n                scribeContextSelector: \"[data-scribe-context]\",\n                userTargetSelector: \".js-user-profile-link, .twitter-atreply\"\n            });\n            var a = {\n                feedbackToken: \"data-feedback-token\",\n                impressionId: \"data-impression-id\",\n                disclosureType: \"data-disclosure-type\",\n                impressionCookie: \"data-impression-cookie\",\n                relevanceType: \"data-relevance-type\",\n                associatedTweetId: \"data-associated-tweet-id\"\n            }, b = utils.merge({\n                tweetId: \"data-tweet-id\",\n                retweetId: \"data-retweet-id\",\n                isReplyTo: \"data-is-reply-to\",\n                hasParentTweet: \"data-has-parent-tweet\"\n            }, a), c = utils.merge({\n                activityType: \"data-activity-type\"\n            }, b), d = utils.merge({\n                storyType: \"data-story-type\",\n                query: \"data-query\",\n                url: \"data-url\",\n                storySource: \"data-source\",\n                storyMediaType: \"data-card-media-type\",\n                socialProofType: \"data-social-proof-type\"\n            }, b);\n            this.interactionDataWithCard = function(a, b) {\n                return this.interactionData(a, b, !0);\n            }, this.interactionData = function(a, b, c) {\n                var d = {\n                }, e = {\n                }, f = !!c, g = ((a.target ? $(a.target) : $(a)));\n                ((this.setItemType && this.setItemType(g))), b = ((b || {\n                })), ((this.attr.eventData && (d = this.attr.eventData.scribeContext, e = this.attr.eventData.scribeData)));\n                var h = utils.merge(this.getEventData(g, f), b), i = g.closest(this.attr.scribeContextSelector).data(\"scribe-context\");\n                ((i && (e = utils.merge(i, e)))), d = utils.merge({\n                }, d, this.getScribeContext(g, h));\n                if (((((this.attr.itemType == \"tweet\")) && (([\"replies\",\"conversation\",\"in_reply_to\",].indexOf(d.component) >= 0))))) {\n                    var j = g.closest(this.attr.streamItemContainerSelector).JSBNG__find(this.attr.originalTweetSelector);\n                    ((j.length && (h.conversationOriginTweetId = j.attr(\"data-tweet-id\"))));\n                }\n            ;\n            ;\n                return utils.merge({\n                    scribeContext: d,\n                    scribeData: e\n                }, h);\n            }, this.getScribeContext = function(a, b) {\n                var c = {\n                }, d = a.closest(this.attr.componentContextSelector).attr(\"data-component-context\");\n                ((d && (c.component = d)));\n                var e = a.closest(this.attr.elementContextSelector).attr(\"data-element-context\");\n                ((e && (c.element = e)));\n                if (((c.element || c.component))) {\n                    return c;\n                }\n            ;\n            ;\n            }, this.getInteractionItemPosition = function(a, b) {\n                if (((b && ((b.position >= 0))))) {\n                    return b.position;\n                }\n            ;\n            ;\n                var c = ((this.getItemPosition && this.getItemPosition(a)));\n                return ((((c >= 0)) ? c : (c = this.getExpandoPosition(a), ((((c != -1)) ? c : ((((a.attr(\"data-is-tweet-proof\") === \"true\")) ? this.getTweetProofPosition(a) : this.getStreamPosition(a))))))));\n            }, this.getExpandoPosition = function(a) {\n                var b, c = -1, d = a.closest(this.attr.expandoAncestorSelector), e = a.closest(this.attr.expandoDescendantSelector);\n                return ((d.length && (b = d.closest(this.attr.expandoContainerSelector), c = b.JSBNG__find(this.attr.expandoAncestorSelector).index(d)))), ((e.length && (b = e.closest(this.attr.expandoContainerSelector), c = b.JSBNG__find(this.attr.expandoDescendantSelector).index(e)))), ((a.closest(\".in-reply-to,.replies-to\").length && (b = a.closest(\".in-reply-to,.replies-to\"), c = b.JSBNG__find(\".tweet\").index(a.closest(\".tweet\"))))), c;\n            }, this.getTweetProofPosition = function(a) {\n                var b = a.closest(this.attr.trendItemSelector).index();\n                return ((((b != -1)) ? b : -1));\n            }, this.getStreamPosition = function(a) {\n                var b = a.closest(this.attr.genericInteractionItemSelector).index();\n                if (((b != -1))) {\n                    return b;\n                }\n            ;\n            ;\n            }, this.getEventData = function(c, d) {\n                var e, f;\n                switch (this.attr.itemType) {\n                  case \"activity\":\n                    return this.getActivityEventData(c);\n                  case \"story\":\n                    return this.getStoryEventData(c);\n                  case \"user\":\n                    return this.getDataAttrs(c, a);\n                  case \"tweet\":\n                    return f = utils.merge(this.getDataAttrs(c, b), this.getConversationAttrs(c)), ((d ? utils.merge(this.getCardAttrs(c), f) : f));\n                  case \"list\":\n                    return this.getDataAttrs(c, a);\n                  case \"trend\":\n                    return this.getDataAttrs(c, b);\n                  default:\n                    return JSBNG__console.warn(\"You must configure your UI component with an \\\"itemType\\\" attribute of activity, story, user, tweet, list, or trend in order for it to scribe properly.\"), {\n                    };\n                };\n            ;\n            }, this.getActivityEventData = function(a) {\n                var b = a.closest(this.attr.activityItemSelector), d = b.JSBNG__find(this.attr.activityTargetSelector);\n                ((d.length || (d = a)));\n                var e = this.getDataAttrs(a, c, d);\n                e.isNetworkActivity = !!a.closest(\".discover-stream\").length, ((e.activityType || ((e.isReplyTo ? e.activityType = \"reply\" : e.activityType = ((e.retweetId ? \"retweet\" : \"mention\"))))));\n                var f = [], g = ((e.isNetworkActivity ? \".stream-item-activity-header\" : \"ol.activity-supplement\"));\n                return b.JSBNG__find(((g + \" a[data-user-id]\"))).each(function() {\n                    f.push($(this).data(\"user-id\"));\n                }), ((f.length && (e.actingUserIds = f))), e;\n            }, this.getStoryEventData = function(a) {\n                var b = this.getDataAttrs(a, d), c = a.closest(this.attr.discoveryStoryItemSelector), e = c.JSBNG__find(this.attr.discoveryStoryHeadlineSelector).text();\n                return b.storyTitle = e.replace(/^\\s+|\\s+$/g, \"\"), b;\n            }, this.getTargetUserId = function(a) {\n                var b = a.closest(this.attr.userTargetSelector);\n                if (b.length) {\n                    return ((b.closest(\"[data-user-id]\").attr(\"data-user-id\") || b.JSBNG__find(\"[data-user-id]\").attr(\"data-user-id\")));\n                }\n            ;\n            ;\n            }, this.getDataAttrs = function(a, b, c) {\n                var d = {\n                };\n                c = ((c || a)), $.each(b, function(a, b) {\n                    ((c.is(((((\"[\" + b)) + \"]\"))) ? d[a] = c.attr(b) : d[a] = c.closest(((((\"[\" + b)) + \"]\"))).attr(b)));\n                }), d.isReplyTo = ((d.isReplyTo === \"true\")), d = utils.merge(d, {\n                    position: this.getInteractionItemPosition(a, d),\n                    isMentionClick: ((a.closest(this.attr.itemMentionSelector).length > 0)),\n                    isPromotedBadgeClick: ((a.closest(this.attr.promotedBadgeSelector).length > 0)),\n                    itemType: this.attr.itemType\n                }), ((a.is(this.attr.itemAvatarSelector) ? d.profileClickTarget = \"avatar\" : ((a.is(this.attr.itemSmallAvatarSelector) ? d.profileClickTarget = \"mini_avatar\" : d.profileClickTarget = \"screen_name\"))));\n                var e = this.getTargetUserId(a);\n                return ((e && (d.targetUserId = e))), d.userId = a.closest(\"[data-user-id]\").attr(\"data-user-id\"), d.containerUserId = c.closest(\"[data-user-id]\").attr(\"data-user-id\"), d;\n            }, this.getCardAttrs = function(a) {\n                var b = this.getCardDataFromTweet(a);\n                return ((b.tweetHasCard2 ? {\n                    cardItem: this.getCard2Item(b)\n                } : {\n                }));\n            };\n        };\n    ;\n        var compose = require(\"core/compose\"), utils = require(\"core/utils\"), withCardMetadata = require(\"app/data/with_card_metadata\"), withConversationMetadata = require(\"app/data/with_conversation_metadata\");\n        module.exports = withInteractionData;\n    });\n    define(\"app/data/tweet_actions_scribe\", [\"module\",\"require\",\"exports\",\"core/component\",\"core/utils\",\"app/ui/with_interaction_data\",\"app/data/with_conversation_metadata\",\"app/data/with_interaction_data_scribe\",], function(module, require, exports) {\n        function tweetActionsScribe() {\n            this.scribeTweet = function(a) {\n                return function(b, c) {\n                    var d = this.addConversationScribeContext({\n                        action: a\n                    }, c.sourceEventData);\n                    this.scribeInteraction(d, utils.merge(c, c.sourceEventData));\n                }.bind(this);\n            }, this.after(\"initialize\", function() {\n                this.JSBNG__on(\"uiReplyButtonTweetSuccess\", this.scribeTweet(\"reply\")), this.JSBNG__on(\"uiDidRetweetSuccess\", this.scribeTweet(\"retweet\")), this.JSBNG__on(\"uiDidDeleteTweet\", this.scribeTweet(\"delete\")), this.JSBNG__on(\"dataDidFavoriteTweet\", this.scribeTweet(\"favorite\")), this.JSBNG__on(\"dataDidUnfavoriteTweet\", this.scribeTweet(\"unfavorite\")), this.JSBNG__on(\"dataDidUnretweet\", this.scribeTweet(\"unretweet\")), this.JSBNG__on(\"uiPermalinkClick\", this.scribeTweet(\"permalink\")), this.JSBNG__on(\"uiDidShareViaEmailSuccess\", this.scribeTweet(\"share_via_email\")), this.JSBNG__on(\"dataTweetTranslationSuccess\", this.scribeTweet(\"translate\"));\n            });\n        };\n    ;\n        var defineComponent = require(\"core/component\"), utils = require(\"core/utils\"), withInteractionData = require(\"app/ui/with_interaction_data\"), withConversationMetadata = require(\"app/data/with_conversation_metadata\"), withInteractionDataScribe = require(\"app/data/with_interaction_data_scribe\");\n        module.exports = defineComponent(tweetActionsScribe, withInteractionData, withConversationMetadata, withInteractionDataScribe);\n    });\n    define(\"app/data/user_actions_scribe\", [\"module\",\"require\",\"exports\",\"core/component\",\"app/utils/scribe_item_types\",\"app/utils/scribe_association_types\",\"app/data/with_interaction_data_scribe\",], function(module, require, exports) {\n        function userActionsScribe() {\n            function a(a) {\n                var b = ((a && a.associatedTweetId)), c = {\n                };\n                if (!b) {\n                    return;\n                }\n            ;\n            ;\n                return c[associationTypes.associatedTweet] = {\n                    association_type: itemTypes.tweet,\n                    association_id: b\n                }, {\n                    associations: c\n                };\n            };\n        ;\n            this.defaultAttrs({\n                urlToActionMap: {\n                    \"/i/user/follow\": \"follow\",\n                    \"/i/user/unfollow\": \"unfollow\",\n                    \"/i/user/block\": \"block\",\n                    \"/i/user/unblock\": \"unblock\",\n                    \"/i/user/report_spam\": \"report_as_spam\",\n                    \"/i/user/hide\": \"dismiss\"\n                },\n                userActionToActionMap: {\n                    uiMentionAction: \"reply\",\n                    uiDmAction: \"dm\",\n                    uiListAction: \"add_to_list\",\n                    uiRetweetOnAction: {\n                        element: \"allow_retweets\",\n                        action: \"JSBNG__on\"\n                    },\n                    uiRetweetOffAction: {\n                        element: \"allow_retweets\",\n                        action: \"off\"\n                    },\n                    uiDeviceNotificationsOnAction: {\n                        element: \"mobile_notifications\",\n                        action: \"JSBNG__on\"\n                    },\n                    uiDeviceNotificationsOffAction: {\n                        element: \"mobile_notifications\",\n                        action: \"off\"\n                    },\n                    uiShowMobileNotificationsConfirm: {\n                        element: \"mobile_notifications\",\n                        action: \"failure\"\n                    },\n                    uiShowPushTweetsNotificationsConfirm: {\n                        element: \"mobile_notifications\",\n                        action: \"failure\"\n                    },\n                    uiEmailFollowAction: {\n                        element: \"email_follow\",\n                        action: \"email_follow\"\n                    },\n                    uiEmailUnfollowAction: {\n                        element: \"email_follow\",\n                        action: \"email_unfollow\"\n                    }\n                }\n            }), this.handleUserEvent = function(b, c) {\n                this.scribeInteraction(this.attr.urlToActionMap[c.requestUrl], c, a(c.sourceEventData)), ((c.isFollowBack && this.scribeInteraction(\"follow_back\", c, a(c.sourceEventData))));\n            }, this.handleAction = function(b, c) {\n                this.scribeInteraction(this.attr.userActionToActionMap[b.type], c, a(c));\n            }, this.after(\"initialize\", function() {\n                this.JSBNG__on(JSBNG__document, \"dataFollowStateChange dataUserActionSuccess dataEmailFollow dataEmailUnfollow\", this.handleUserEvent), this.JSBNG__on(JSBNG__document, \"uiMentionAction uiListAction uiDmAction uiRetweetOnAction uiRetweetOffAction uiDeviceNotificationsOnAction uiDeviceNotificationsOffAction uiShowMobileNotificationsConfirm uiShowPushTweetsNotificationsConfirm uiEmailFollowAction uiEmailUnfollowAction\", this.handleAction);\n            });\n        };\n    ;\n        var defineComponent = require(\"core/component\"), itemTypes = require(\"app/utils/scribe_item_types\"), associationTypes = require(\"app/utils/scribe_association_types\"), withInteractionDataScribe = require(\"app/data/with_interaction_data_scribe\");\n        module.exports = defineComponent(userActionsScribe, withInteractionDataScribe);\n    });\n    define(\"app/data/item_actions_scribe\", [\"module\",\"require\",\"exports\",\"core/component\",\"app/data/with_interaction_data_scribe\",\"app/data/with_conversation_metadata\",\"app/data/with_card_metadata\",], function(module, require, exports) {\n        function itemActionsScribe() {\n            this.handleNewerTimelineItems = function(a, b) {\n                this.scribeInteractiveResults({\n                    element: \"newer\",\n                    action: \"results\"\n                }, b.items, b);\n            }, this.handleRangeTimelineItems = function(a, b) {\n                this.scribeInteractiveResults({\n                    element: \"range\",\n                    action: \"results\"\n                }, b.items, b);\n            }, this.handleProfilePopup = function(a, b) {\n                var c = b.sourceEventData, d = ((c.isMentionClick ? \"mention_click\" : \"profile_click\"));\n                c.userId = b.user_id, ((c.interactionInsideCard ? this.scribeCardAction(d, a, c) : this.scribeInteraction(d, c)));\n            }, this.scribeItemAction = function(a, b, c) {\n                var d = this.addConversationScribeContext({\n                    action: a\n                }, c);\n                this.scribeInteraction(d, c);\n            }, this.scribeSearchTagClick = function(a, b) {\n                var c = ((((a.type == \"uiCashtagClick\")) ? \"cashtag\" : \"hashtag\"));\n                this.scribeInteraction({\n                    element: c,\n                    action: \"search\"\n                }, b);\n            }, this.scribeLinkClick = function(a, b) {\n                var c = {\n                };\n                ((b.tcoUrl && (c.message = b.tcoUrl))), ((((b.text && ((b.text.indexOf(\"pic.twitter.com\") == 0)))) && (b.url = ((\"http://\" + b.text))))), this.scribeInteraction(\"open_link\", b, c);\n            }, this.scribeCardAction = function(a, b, c) {\n                ((((c && c.tweetHasCard)) && this.scribeCardInteraction(a, c)));\n            }, this.after(\"initialize\", function() {\n                this.JSBNG__on(JSBNG__document, \"uiHasInjectedNewTimeline\", this.handleNewerTimelineItems), this.JSBNG__on(JSBNG__document, \"uiHasInjectedRangeTimelineItems\", this.handleRangeTimelineItems), this.JSBNG__on(JSBNG__document, \"dataProfilePopupSuccess\", this.handleProfilePopup), this.JSBNG__on(JSBNG__document, \"uiItemSelected\", this.scribeItemAction.bind(this, \"select\")), this.JSBNG__on(JSBNG__document, \"uiItemDeselected\", this.scribeItemAction.bind(this, \"deselect\")), this.JSBNG__on(JSBNG__document, \"uiHashtagClick uiCashtagClick\", this.scribeSearchTagClick), this.JSBNG__on(JSBNG__document, \"uiItemLinkClick\", this.scribeLinkClick), this.JSBNG__on(JSBNG__document, \"uiCardInteractionLinkClick\", this.scribeCardAction.bind(this, \"click\")), this.JSBNG__on(JSBNG__document, \"uiCardExternalLinkClick\", this.scribeCardAction.bind(this, \"open_link\")), this.JSBNG__on(JSBNG__document, \"uiItemSelected\", this.scribeCardAction.bind(this, \"show\")), this.JSBNG__on(JSBNG__document, \"uiItemDeselected\", this.scribeCardAction.bind(this, \"hide\")), this.JSBNG__on(JSBNG__document, \"uiMapShow\", this.scribeItemAction.bind(this, \"show\")), this.JSBNG__on(JSBNG__document, \"uiMapClick\", this.scribeItemAction.bind(this, \"click\")), this.JSBNG__on(JSBNG__document, \"uiShareViaEmailDialogOpened\", this.scribeItemAction.bind(this, \"open\"));\n            });\n        };\n    ;\n        var defineComponent = require(\"core/component\"), withInteractionDataScribe = require(\"app/data/with_interaction_data_scribe\"), withConversationMetadata = require(\"app/data/with_conversation_metadata\"), withCardMetadata = require(\"app/data/with_card_metadata\");\n        module.exports = defineComponent(itemActionsScribe, withInteractionDataScribe, withConversationMetadata, withCardMetadata);\n    });\n    define(\"app/utils/full_path\", [\"module\",\"require\",\"exports\",], function(module, require, exports) {\n        function fullPath() {\n            return [JSBNG__location.pathname,JSBNG__location.search,].join(\"\");\n        };\n    ;\n        module.exports = fullPath;\n    });\n    define(\"app/data/navigation_scribe\", [\"module\",\"require\",\"exports\",\"core/component\",\"app/data/client_event\",\"app/data/with_scribe\",\"app/utils/full_path\",], function(module, require, exports) {\n        function navigationScribe() {\n            this.scribeNav = function(a, b) {\n                this.scribe(\"JSBNG__navigate\", b, {\n                    url: b.url\n                });\n            }, this.scribeCachedImpression = function(a, b) {\n                ((b.fromCache && this.scribe(\"impression\")));\n            }, this.after(\"initialize\", function() {\n                clientEvent.internalReferer = fullPath(), this.JSBNG__on(\"uiNavigationLinkClick\", this.scribeNav), this.JSBNG__on(\"uiPageChanged\", this.scribeCachedImpression);\n            });\n        };\n    ;\n        var defineComponent = require(\"core/component\"), clientEvent = require(\"app/data/client_event\"), withScribe = require(\"app/data/with_scribe\"), fullPath = require(\"app/utils/full_path\");\n        module.exports = defineComponent(navigationScribe, withScribe);\n    });\n    define(\"app/data/simple_event_scribe\", [\"module\",\"require\",\"exports\",\"core/component\",\"app/data/with_scribe\",], function(module, require, exports) {\n        function simpleEventScribe() {\n            this.defaultAttrs({\n                eventToActionMap: {\n                    uiEnableEmailFollowAction: {\n                        action: \"enable\"\n                    },\n                    uiDisableEmailFollowAction: {\n                        action: \"disable\"\n                    }\n                }\n            }), this.scribeSimpleEvent = function(a, b) {\n                this.scribe(this.attr.eventToActionMap[a.type], b);\n            }, this.after(\"initialize\", function() {\n                this.JSBNG__on(\"uiEnableEmailFollowAction\", this.scribeSimpleEvent), this.JSBNG__on(\"uiDisableEmailFollowAction\", this.scribeSimpleEvent);\n            });\n        };\n    ;\n        var defineComponent = require(\"core/component\"), withScribe = require(\"app/data/with_scribe\");\n        module.exports = defineComponent(simpleEventScribe, withScribe);\n    });\n    define(\"app/boot/scribing\", [\"module\",\"require\",\"exports\",\"app/data/scribe_transport\",\"app/data/scribe_monitor\",\"app/data/client_event\",\"app/data/ddg\",\"app/data/tweet_actions_scribe\",\"app/data/user_actions_scribe\",\"app/data/item_actions_scribe\",\"app/data/navigation_scribe\",\"app/data/simple_event_scribe\",], function(module, require, exports) {\n        function initialize(a) {\n            var b = {\n                useAjax: !0,\n                bufferEvents: ((((((a.environment != \"development\")) && ((a.environment != \"staging\")))) && !a.preflight)),\n                flushOnUnload: ((a.environment != \"selenium\")),\n                bufferSize: ((((a.environment == \"selenium\")) ? ((1000 * a.scribeBufferSize)) : a.scribeBufferSize)),\n                debug: !!a.debugAllowed,\n                requestParameters: a.scribeParameters\n            };\n            scribeTransport.updateOptions(b), scribeTransport.registerEventHandlers(), clientEvent.scribeContext = {\n                client: \"web\",\n                page: a.pageName,\n                section: a.sectionName\n            }, clientEvent.scribeData = {\n                internal_referer: ((clientEvent.internalReferer || a.internalReferer)),\n                client_version: ((a.macawSwift ? \"macaw-swift\" : \"swift\"))\n            }, delete clientEvent.internalReferer, ((a.loggedIn || (clientEvent.scribeData.user_id = 0))), ddg.experiments = a.experiments, ((((((((a.environment != \"production\")) || a.preflight)) || a.scribesForScribeConsole)) && ScribeMonitor.attachTo(JSBNG__document, {\n                scribesForScribeConsole: a.scribesForScribeConsole\n            }))), TweetActionsScribe.attachTo(JSBNG__document, a), UserActionsScribe.attachTo(JSBNG__document, a), ItemActionsScribe.attachTo(JSBNG__document, a), NavigationScribe.attachTo(JSBNG__document, a), SimpleEventScribe.attachTo(JSBNG__document, a);\n        };\n    ;\n        var scribeTransport = require(\"app/data/scribe_transport\"), ScribeMonitor = require(\"app/data/scribe_monitor\"), clientEvent = require(\"app/data/client_event\"), ddg = require(\"app/data/ddg\"), TweetActionsScribe = require(\"app/data/tweet_actions_scribe\"), UserActionsScribe = require(\"app/data/user_actions_scribe\"), ItemActionsScribe = require(\"app/data/item_actions_scribe\"), NavigationScribe = require(\"app/data/navigation_scribe\"), SimpleEventScribe = require(\"app/data/simple_event_scribe\");\n        module.exports = initialize;\n    });\n    define(\"app/ui/navigation\", [\"module\",\"require\",\"exports\",\"core/component\",\"app/utils/full_path\",], function(module, require, exports) {\n        function navigation() {\n            this.defaultAttrs({\n                spinnerContainer: \"body\",\n                pushStateSelector: \"a.js-nav\",\n                pageContainer: \"#page-container\",\n                docContainer: \"#doc\",\n                globalHeadingSelector: \".global-nav h1\",\n                spinnerClass: \"pushing-state\",\n                spinnerSelector: \".pushstate-spinner\",\n                baseFoucClass: \"swift-loading\"\n            }), this.JSBNG__navigate = function(a) {\n                var b, c;\n                if (((((((a.shiftKey || a.ctrlKey)) || a.metaKey)) || ((((a.which != undefined)) && ((a.which > 1))))))) {\n                    return;\n                }\n            ;\n            ;\n                b = $(a.target), c = b.closest(this.attr.pushStateSelector), ((((c.length && !a.isDefaultPrevented())) && (this.trigger(c, \"uiNavigate\", {\n                    href: c.attr(\"href\")\n                }), a.preventDefault(), a.stopImmediatePropagation())));\n            }, this.updatePage = function(a, b, c) {\n                this.hideSpinner(), this.trigger(\"uiBeforePageChanged\", b), this.trigger(\"uiTeardown\", b), $(\"html\").attr(\"class\", ((((b.init_data.htmlClassNames + \" \")) + b.init_data.htmlFoucClassNames))), $(\"body\").attr(\"class\", b.body_class_names), this.select(\"docContainer\").attr(\"class\", b.doc_class_names), this.select(\"pageContainer\").attr(\"class\", b.page_container_class_names);\n                var d = ((((b.banners && !b.fromCache)) ? ((b.banners + b.page)) : b.page));\n                this.$node.JSBNG__find(b.init_data.viewContainer).html(d), ((b.isPopState || $(window).scrollTop(0))), using(b.module, function(a) {\n                    a(b.init_data), $(\"html\").removeClass(this.attr.baseFoucClass), this.trigger(\"uiPageChanged\", b);\n                }.bind(this));\n            }, this.showSpinner = function(a, b) {\n                this.select(\"spinnerContainer\").addClass(this.attr.spinnerClass);\n            }, this.hideSpinner = function(a, b) {\n                this.select(\"spinnerContainer\").removeClass(this.attr.spinnerClass);\n            }, this.addSpinner = function() {\n                ((this.select(\"spinnerSelector\").length || $(\"\\u003Cdiv class=\\\"pushstate-spinner\\\"\\u003E\\u003C/div\\u003E\").insertAfter(this.select(\"globalHeadingSelector\"))));\n            }, this.onPopState = function(a) {\n                ((a.originalEvent.state && (((isSafari && (JSBNG__document.body.style.display = \"none\", JSBNG__document.body.offsetHeight, JSBNG__document.body.style.display = \"block\"))), this.trigger(\"uiNavigate\", {\n                    isPopState: !0,\n                    href: fullPath()\n                }))));\n            }, this.after(\"initialize\", function() {\n                this.JSBNG__on(\"click\", this.JSBNG__navigate), this.JSBNG__on(window, \"popstate\", this.onPopState), this.JSBNG__on(\"uiSwiftLoaded\", this.addSpinner), this.JSBNG__on(\"dataPageRefresh\", this.updatePage), this.JSBNG__on(\"dataPageFetch\", this.showSpinner);\n            });\n        };\n    ;\n        var component = require(\"core/component\"), fullPath = require(\"app/utils/full_path\"), Navigation = component(navigation), isSafari = (($.browser.safari === !0));\n        module.exports = Navigation;\n    });\n    provide(\"app/utils/time\", function(a) {\n        function b(a) {\n            this.ms = a;\n        };\n    ;\n        function c(a) {\n            var c = {\n                seconds: new b(((a * 1000))),\n                minutes: new b(((((a * 1000)) * 60))),\n                hours: new b(((((((a * 1000)) * 60)) * 60))),\n                days: new b(((((((((a * 1000)) * 60)) * 60)) * 24)))\n            };\n            return c.second = c.seconds, c.minute = c.minutes, c.hour = c.hours, c.day = c.days, c;\n        };\n    ;\n        c.now = function() {\n            return (new JSBNG__Date).getTime();\n        }, b.prototype.fromNow = function() {\n            return new JSBNG__Date(((c.now() + this.ms)));\n        }, b.prototype.ago = function() {\n            return new JSBNG__Date(((c.now() - this.ms)));\n        }, b.prototype.getTime = b.prototype.valueOf = function() {\n            return this.ms;\n        }, a(c);\n    });\n    define(\"app/utils/storage/core\", [\"module\",\"require\",\"exports\",\"core/compose\",\"core/advice\",], function(module, require, exports) {\n        function JSBNG__localStorage() {\n            this.initialize = function(a) {\n                this.namespace = a, this.prefix = [\"__\",this.namespace,\"__:\",].join(\"\"), this.matcher = new RegExp(((\"^\" + this.prefix)));\n            }, this.getItem = function(a) {\n                return this.decode(window.JSBNG__localStorage.getItem(((this.prefix + a))));\n            }, this.setItem = function(a, b) {\n                try {\n                    return window.JSBNG__localStorage.setItem(((this.prefix + a)), this.encode(b));\n                } catch (c) {\n                    return ((((window.DEBUG && window.DEBUG.enabled)) && JSBNG__console.error(c))), undefined;\n                };\n            ;\n            }, this.removeItem = function(a) {\n                return window.JSBNG__localStorage.removeItem(((this.prefix + a)));\n            }, this.keys = function() {\n                var a = [];\n                for (var b = 0, c = window.JSBNG__localStorage.length, d; ((b < c)); b++) {\n                    d = window.JSBNG__localStorage.key(b), ((d.match(this.matcher) && a.push(d.replace(this.matcher, \"\"))));\n                ;\n                };\n            ;\n                return a;\n            }, this.clear = function() {\n                this.keys().forEach(function(a) {\n                    this.removeItem(a);\n                }, this);\n            }, this.clearAll = function() {\n                window.JSBNG__localStorage.clear();\n            };\n        };\n    ;\n        function userData() {\n            function b(b, c) {\n                var d = c.xmlDocument.documentElement;\n                a[b] = {\n                };\n                while (d.firstChild) {\n                    d.removeChild(d.firstChild);\n                ;\n                };\n            ;\n                c.save(b);\n            };\n        ;\n            function c(a) {\n                return JSBNG__document.getElementById(((\"__storage_\" + a)));\n            };\n        ;\n            var a = {\n            };\n            this.initialize = function(b) {\n                this.namespace = b, (((this.dataStore = c(this.namespace)) || this.createStorageElement())), this.xmlDoc = this.dataStore.xmlDocument, this.xmlDocEl = this.xmlDoc.documentElement, a[this.namespace] = ((a[this.namespace] || {\n                }));\n            }, this.createStorageElement = function() {\n                this.dataStore = JSBNG__document.createElement(\"div\"), this.dataStore.id = ((\"__storage_\" + this.namespace)), this.dataStore.style.display = \"none\", JSBNG__document.appendChild(this.dataStore), this.dataStore.addBehavior(\"#default#userData\"), this.dataStore.load(this.namespace);\n            }, this.getNodeByKey = function(b) {\n                var c = this.xmlDocEl.childNodes, d;\n                if (d = a[this.namespace][b]) {\n                    return d;\n                }\n            ;\n            ;\n                for (var e = 0, f = c.length; ((e < f)); e++) {\n                    d = c.item(e);\n                    if (((d.getAttribute(\"key\") == b))) {\n                        return a[this.namespace][b] = d, d;\n                    }\n                ;\n                ;\n                };\n            ;\n                return null;\n            }, this.getItem = function(a) {\n                var b = this.getNodeByKey(a), c = null;\n                return ((b && (c = b.getAttribute(\"value\")))), this.decode(c);\n            }, this.setItem = function(b, c) {\n                var d = this.getNodeByKey(b);\n                return ((d ? d.setAttribute(\"value\", this.encode(c)) : (d = this.xmlDoc.createNode(1, \"item\", \"\"), d.setAttribute(\"key\", b), d.setAttribute(\"value\", this.encode(c)), this.xmlDocEl.appendChild(d), a[this.namespace][b] = d))), this.dataStore.save(this.namespace), c;\n            }, this.removeItem = function(b) {\n                var c = this.getNodeByKey(b);\n                ((c && (this.xmlDocEl.removeChild(c), delete a[this.namespace][b]))), this.dataStore.save(this.namespace);\n            }, this.keys = function() {\n                var a = this.xmlDocEl.childNodes.length, b = [];\n                for (var c = 0; ((c < a)); c++) {\n                    b.push(this.xmlDocEl.childNodes[c].getAttribute(\"key\"));\n                ;\n                };\n            ;\n                return b;\n            }, this.clear = function() {\n                b(this.namespace, this.dataStore);\n            }, this.clearAll = function() {\n                {\n                    var fin50keys = ((window.top.JSBNG_Replay.forInKeys)((a))), fin50i = (0);\n                    var d;\n                    for (; (fin50i < fin50keys.length); (fin50i++)) {\n                        ((d) = (fin50keys[fin50i]));\n                        {\n                            b(d, c(d)), a[d] = {\n                            };\n                        ;\n                        };\n                    };\n                };\n            ;\n            };\n        };\n    ;\n        function noStorage() {\n            this.initialize = $.noop, this.getNodeByKey = function(a) {\n                return null;\n            }, this.getItem = function(a) {\n                return null;\n            }, this.setItem = function(a, b) {\n                return b;\n            }, this.removeItem = function(a) {\n                return null;\n            }, this.keys = function() {\n                return [];\n            }, this.clear = $.noop, this.clearAll = $.noop;\n        };\n    ;\n        function memory() {\n            this.initialize = function(a) {\n                this.namespace = a, ((memoryStore[this.namespace] || (memoryStore[this.namespace] = {\n                }))), this.store = memoryStore[this.namespace];\n            }, this.getItem = function(a) {\n                return ((this.store[a] ? this.decode(this.store[a]) : undefined));\n            }, this.setItem = function(a, b) {\n                return this.store[a] = this.encode(b);\n            }, this.removeItem = function(a) {\n                delete this.store[a];\n            }, this.keys = function() {\n                return Object.keys(this.store);\n            }, this.clear = function() {\n                this.store = memoryStore[this.namespace] = {\n                };\n            }, this.clearAll = function() {\n                memoryStore = {\n                };\n            };\n        };\n    ;\n        function browserStore() {\n            ((supportsLocalStorage() ? JSBNG__localStorage.call(this) : ((JSBNG__document.documentElement.addBehavior ? noStorage.call(this) : memory.call(this)))));\n        };\n    ;\n        function supportsLocalStorage() {\n            if (((doesLocalStorage === undefined))) {\n                try {\n                    window.JSBNG__localStorage.setItem(\"~~~~\", 1), window.JSBNG__localStorage.removeItem(\"~~~~\"), doesLocalStorage = !0;\n                } catch (a) {\n                    doesLocalStorage = !1;\n                };\n            }\n        ;\n        ;\n            return doesLocalStorage;\n        };\n    ;\n        function encoding() {\n            this.encode = function(a) {\n                return ((((a === undefined)) && (a = null))), JSON.stringify(a);\n            }, this.decode = function(a) {\n                return JSON.parse(a);\n            };\n        };\n    ;\n        function CoreStorage() {\n            ((arguments.length && this.initialize.apply(this, arguments)));\n        };\n    ;\n        var compose = require(\"core/compose\"), advice = require(\"core/advice\"), memoryStore = {\n        }, doesLocalStorage;\n        compose.mixin(CoreStorage.prototype, [encoding,browserStore,advice.withAdvice,]), CoreStorage.clearAll = CoreStorage.prototype.clearAll, module.exports = CoreStorage;\n    });\n    define(\"app/data/notifications\", [\"module\",\"require\",\"exports\",\"core/clock\",\"app/utils/storage/core\",\"app/utils/time\",], function(module, require, exports) {\n        function JSBNG__Notification(a, b, c, d) {\n            this.key = b, this.timestamp = 0, this.active = a, this.seenFirstResponse = !1, this.pollEvent = c, this.paramAdder = d;\n        };\n    ;\n        function Notifications() {\n            this.entries = [];\n        };\n    ;\n        var clock = require(\"core/clock\"), JSBNG__Storage = require(\"app/utils/storage/core\"), time = require(\"app/utils/time\"), pollDelay = 20000, storage = new JSBNG__Storage(\"DM\"), filteredEndpoints = [\"/i/users/recommendations\",\"/i/timeline\",\"/i/profiles/show\",\"/messages\",];\n        JSBNG__Notification.prototype = {\n            reset: function() {\n                this.timestamp = time.now();\n            },\n            isResponseValid: function(a) {\n                return ((((((((((this.active && a)) && a[this.key])) && a.notCached)) && ((a[this.key].JSBNG__status == \"ok\")))) && ((a[this.key].response !== null))));\n            },\n            update: function(a) {\n                ((this.isResponseValid(a) ? this.reset() : ((((!this.seenFirstResponse && this.pollEvent)) && $(JSBNG__document).trigger(this.pollEvent))))), this.seenFirstResponse = !0;\n            },\n            shouldPoll: function() {\n                return ((((time.now() - this.timestamp)) > pollDelay));\n            },\n            addParam: function(a) {\n                this.paramAdder(a);\n            }\n        }, Notifications.prototype = {\n            init: function(a) {\n                this.initialized = !0, this.dm = new JSBNG__Notification(a.notifications_dm, \"d\", \"uiDMPoll\", this.addDMData), this.connect = new JSBNG__Notification(a.notifications_timeline, \"t\", null, function() {\n                \n                }), this.spoonbill = new JSBNG__Notification(a.notifications_spoonbill, \"n\", null, function() {\n                \n                }), this.entries = [this.dm,this.connect,this.spoonbill,], ((a.notifications_dm_poll_scale && (pollDelay = ((a.notifications_dm_poll_scale * 1000)))));\n            },\n            getPollDelay: function() {\n                return pollDelay;\n            },\n            addDMData: function(a) {\n                a.oldest_unread_id = ((storage.getItem(\"oldestUnreadMessageId\") || 0));\n            },\n            updateNotificationState: function(a) {\n                this.entries.forEach(function(b) {\n                    b.update(a);\n                });\n            },\n            resetDMState: function(a, b) {\n                this.dm.reset();\n            },\n            shouldPoll: function() {\n                return ((this.initialized ? ((this.dm.active ? this.dm.shouldPoll() : !1)) : !1));\n            },\n            extraParameters: function(a) {\n                if (((!a || !this.shouldPoll()))) {\n                    return {\n                    };\n                }\n            ;\n            ;\n                var b = {\n                };\n                return ((filteredEndpoints.some(function(b) {\n                    return ((a.indexOf(b) == 0));\n                }) && this.entries.forEach(function(a) {\n                    a.addParam(b);\n                }))), b;\n            }\n        }, module.exports = new Notifications;\n    });\n    provide(\"app/utils/querystring\", function(a) {\n        function b(a) {\n            return encodeURIComponent(a).replace(/\\+/g, \"%2B\");\n        };\n    ;\n        function c(a) {\n            return decodeURIComponent(a.replace(/\\+/g, \" \"));\n        };\n    ;\n        function d(a) {\n            var c = [];\n            {\n                var fin51keys = ((window.top.JSBNG_Replay.forInKeys)((a))), fin51i = (0);\n                var d;\n                for (; (fin51i < fin51keys.length); (fin51i++)) {\n                    ((d) = (fin51keys[fin51i]));\n                    {\n                        ((((((a[d] !== null)) && ((typeof a[d] != \"undefined\")))) && c.push(((((b(d) + \"=\")) + b(a[d]))))));\n                    ;\n                    };\n                };\n            };\n        ;\n            return c.sort().join(\"&\");\n        };\n    ;\n        function e(a) {\n            var b = {\n            }, d, e, f, g;\n            if (a) {\n                d = a.split(\"&\");\n                for (g = 0; f = d[g]; g++) {\n                    e = f.split(\"=\"), ((((e.length == 2)) && (b[c(e[0])] = c(e[1]))));\n                ;\n                };\n            ;\n            }\n        ;\n        ;\n            return b;\n        };\n    ;\n        a({\n            decode: e,\n            encode: d,\n            encodePart: b,\n            decodePart: c\n        });\n    });\n    define(\"app/utils/params\", [\"module\",\"require\",\"exports\",\"app/utils/querystring\",], function(module, require, exports) {\n        var qs = require(\"app/utils/querystring\"), fromQuery = function(a) {\n            var b = a.search.substr(1);\n            return qs.decode(b);\n        }, fromFragment = function(a) {\n            var b = a.href, c = b.indexOf(\"#\"), d = ((((c < 0)) ? \"\" : b.substring(((c + 1)))));\n            return qs.decode(d);\n        }, combined = function(a) {\n            var b = {\n            }, c = fromQuery(a), d = fromFragment(a);\n            {\n                var fin52keys = ((window.top.JSBNG_Replay.forInKeys)((c))), fin52i = (0);\n                var e;\n                for (; (fin52i < fin52keys.length); (fin52i++)) {\n                    ((e) = (fin52keys[fin52i]));\n                    {\n                        ((c.hasOwnProperty(e) && (b[e] = c[e])));\n                    ;\n                    };\n                };\n            };\n        ;\n            {\n                var fin53keys = ((window.top.JSBNG_Replay.forInKeys)((d))), fin53i = (0);\n                var e;\n                for (; (fin53i < fin53keys.length); (fin53i++)) {\n                    ((e) = (fin53keys[fin53i]));\n                    {\n                        ((d.hasOwnProperty(e) && (b[e] = d[e])));\n                    ;\n                    };\n                };\n            };\n        ;\n            return b;\n        };\n        module.exports = {\n            combined: combined,\n            fromQuery: fromQuery,\n            fromFragment: fromFragment\n        };\n    });\n    define(\"app/data/with_auth_token\", [\"module\",\"require\",\"exports\",\"app/utils/auth_token\",\"core/utils\",], function(module, require, exports) {\n        function withAuthToken() {\n            this.addAuthToken = function(b) {\n                if (!authToken.get()) {\n                    throw \"addAuthToken requires a formAuthenticityToken\";\n                }\n            ;\n            ;\n                return b = ((b || {\n                })), utils.merge(b, {\n                    authenticity_token: authToken.get()\n                });\n            }, this.addPHXAuthToken = function(b) {\n                if (!authToken.get()) {\n                    throw \"addPHXAuthToken requires a formAuthenticityToken\";\n                }\n            ;\n            ;\n                return b = ((b || {\n                })), utils.merge(b, {\n                    post_authenticity_token: authToken.get()\n                });\n            }, this.getAuthToken = function() {\n                return this.attr.formAuthenticityToken;\n            };\n        };\n    ;\n        var authToken = require(\"app/utils/auth_token\"), utils = require(\"core/utils\");\n        module.exports = withAuthToken;\n    });\n    deferred(\"$lib/gibberish-aes.js\", function() {\n        (function(a) {\n            var b = function() {\n                var a = 14, c = 8, d = !1, e = function(a) {\n                    try {\n                        return unescape(encodeURIComponent(a));\n                    } catch (b) {\n                        throw \"Error on UTF-8 encode\";\n                    };\n                ;\n                }, f = function(a) {\n                    try {\n                        return decodeURIComponent(escape(a));\n                    } catch (b) {\n                        throw \"Bad Key\";\n                    };\n                ;\n                }, g = function(a) {\n                    var b = [], c, d;\n                    ((((a.length < 16)) && (c = ((16 - a.length)), b = [c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,])));\n                    for (d = 0; ((d < a.length)); d++) {\n                        b[d] = a[d];\n                    ;\n                    };\n                ;\n                    return b;\n                }, h = function(a, b) {\n                    var c = \"\", d, e;\n                    if (b) {\n                        d = a[15];\n                        if (((d > 16))) {\n                            throw \"Decryption error: Maybe bad key\";\n                        }\n                    ;\n                    ;\n                        if (((d == 16))) {\n                            return \"\";\n                        }\n                    ;\n                    ;\n                        for (e = 0; ((e < ((16 - d)))); e++) {\n                            c += String.fromCharCode(a[e]);\n                        ;\n                        };\n                    ;\n                    }\n                     else for (e = 0; ((e < 16)); e++) {\n                        c += String.fromCharCode(a[e]);\n                    ;\n                    }\n                ;\n                ;\n                    return c;\n                }, i = function(a) {\n                    var b = \"\", c;\n                    for (c = 0; ((c < a.length)); c++) {\n                        b += ((((((a[c] < 16)) ? \"0\" : \"\")) + a[c].toString(16)));\n                    ;\n                    };\n                ;\n                    return b;\n                }, j = function(a) {\n                    var b = [];\n                    return a.replace(/(..)/g, function(a) {\n                        b.push(parseInt(a, 16));\n                    }), b;\n                }, k = function(a) {\n                    a = e(a);\n                    var b = [], c;\n                    for (c = 0; ((c < a.length)); c++) {\n                        b[c] = a.charCodeAt(c);\n                    ;\n                    };\n                ;\n                    return b;\n                }, l = function(b) {\n                    switch (b) {\n                      case 128:\n                        a = 10, c = 4;\n                        break;\n                      case 192:\n                        a = 12, c = 6;\n                        break;\n                      case 256:\n                        a = 14, c = 8;\n                        break;\n                      default:\n                        throw ((\"Invalid Key Size Specified:\" + b));\n                    };\n                ;\n                }, m = function(a) {\n                    var b = [], c;\n                    for (c = 0; ((c < a)); c++) {\n                        b = b.concat(Math.floor(((Math.JSBNG__random() * 256))));\n                    ;\n                    };\n                ;\n                    return b;\n                }, n = function(d, e) {\n                    var f = ((((a >= 12)) ? 3 : 2)), g = [], h = [], i = [], j = [], k = d.concat(e), l;\n                    i[0] = b.Hash.MD5(k), j = i[0];\n                    for (l = 1; ((l < f)); l++) {\n                        i[l] = b.Hash.MD5(i[((l - 1))].concat(k)), j = j.concat(i[l]);\n                    ;\n                    };\n                ;\n                    return g = j.slice(0, ((4 * c))), h = j.slice(((4 * c)), ((((4 * c)) + 16))), {\n                        key: g,\n                        iv: h\n                    };\n                }, o = function(a, b, c) {\n                    b = x(b);\n                    var d = Math.ceil(((a.length / 16))), e = [], f, h = [];\n                    for (f = 0; ((f < d)); f++) {\n                        e[f] = g(a.slice(((f * 16)), ((((f * 16)) + 16))));\n                    ;\n                    };\n                ;\n                    ((((((a.length % 16)) === 0)) && (e.push([16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,]), d++)));\n                    for (f = 0; ((f < e.length)); f++) {\n                        e[f] = ((((f === 0)) ? w(e[f], c) : w(e[f], h[((f - 1))]))), h[f] = q(e[f], b);\n                    ;\n                    };\n                ;\n                    return h;\n                }, p = function(a, b, c, d) {\n                    b = x(b);\n                    var e = ((a.length / 16)), g = [], i, j = [], k = \"\";\n                    for (i = 0; ((i < e)); i++) {\n                        g.push(a.slice(((i * 16)), ((((i + 1)) * 16))));\n                    ;\n                    };\n                ;\n                    for (i = ((g.length - 1)); ((i >= 0)); i--) {\n                        j[i] = r(g[i], b), j[i] = ((((i === 0)) ? w(j[i], c) : w(j[i], g[((i - 1))])));\n                    ;\n                    };\n                ;\n                    for (i = 0; ((i < ((e - 1)))); i++) {\n                        k += h(j[i]);\n                    ;\n                    };\n                ;\n                    return k += h(j[i], !0), ((d ? k : f(k)));\n                }, q = function(b, c) {\n                    d = !1;\n                    var e = v(b, c, 0), f;\n                    for (f = 1; ((f < ((a + 1)))); f++) {\n                        e = s(e), e = t(e), ((((f < a)) && (e = u(e)))), e = v(e, c, f);\n                    ;\n                    };\n                ;\n                    return e;\n                }, r = function(b, c) {\n                    d = !0;\n                    var e = v(b, c, a), f;\n                    for (f = ((a - 1)); ((f > -1)); f--) {\n                        e = t(e), e = s(e), e = v(e, c, f), ((((f > 0)) && (e = u(e))));\n                    ;\n                    };\n                ;\n                    return e;\n                }, s = function(a) {\n                    var b = ((d ? B : A)), c = [], e;\n                    for (e = 0; ((e < 16)); e++) {\n                        c[e] = b[a[e]];\n                    ;\n                    };\n                ;\n                    return c;\n                }, t = function(a) {\n                    var b = [], c = ((d ? [0,13,10,7,4,1,14,11,8,5,2,15,12,9,6,3,] : [0,5,10,15,4,9,14,3,8,13,2,7,12,1,6,11,])), e;\n                    for (e = 0; ((e < 16)); e++) {\n                        b[e] = a[c[e]];\n                    ;\n                    };\n                ;\n                    return b;\n                }, u = function(a) {\n                    var b = [], c;\n                    if (!d) {\n                        for (c = 0; ((c < 4)); c++) {\n                            b[((c * 4))] = ((((((D[a[((c * 4))]] ^ E[a[((1 + ((c * 4))))]])) ^ a[((2 + ((c * 4))))])) ^ a[((3 + ((c * 4))))])), b[((1 + ((c * 4))))] = ((((((a[((c * 4))] ^ D[a[((1 + ((c * 4))))]])) ^ E[a[((2 + ((c * 4))))]])) ^ a[((3 + ((c * 4))))])), b[((2 + ((c * 4))))] = ((((((a[((c * 4))] ^ a[((1 + ((c * 4))))])) ^ D[a[((2 + ((c * 4))))]])) ^ E[a[((3 + ((c * 4))))]])), b[((3 + ((c * 4))))] = ((((((E[a[((c * 4))]] ^ a[((1 + ((c * 4))))])) ^ a[((2 + ((c * 4))))])) ^ D[a[((3 + ((c * 4))))]]));\n                        ;\n                        };\n                    }\n                     else {\n                        for (c = 0; ((c < 4)); c++) {\n                            b[((c * 4))] = ((((((I[a[((c * 4))]] ^ G[a[((1 + ((c * 4))))]])) ^ H[a[((2 + ((c * 4))))]])) ^ F[a[((3 + ((c * 4))))]])), b[((1 + ((c * 4))))] = ((((((F[a[((c * 4))]] ^ I[a[((1 + ((c * 4))))]])) ^ G[a[((2 + ((c * 4))))]])) ^ H[a[((3 + ((c * 4))))]])), b[((2 + ((c * 4))))] = ((((((H[a[((c * 4))]] ^ F[a[((1 + ((c * 4))))]])) ^ I[a[((2 + ((c * 4))))]])) ^ G[a[((3 + ((c * 4))))]])), b[((3 + ((c * 4))))] = ((((((G[a[((c * 4))]] ^ H[a[((1 + ((c * 4))))]])) ^ F[a[((2 + ((c * 4))))]])) ^ I[a[((3 + ((c * 4))))]]));\n                        ;\n                        };\n                    }\n                ;\n                ;\n                    return b;\n                }, v = function(a, b, c) {\n                    var d = [], e;\n                    for (e = 0; ((e < 16)); e++) {\n                        d[e] = ((a[e] ^ b[c][e]));\n                    ;\n                    };\n                ;\n                    return d;\n                }, w = function(a, b) {\n                    var c = [], d;\n                    for (d = 0; ((d < 16)); d++) {\n                        c[d] = ((a[d] ^ b[d]));\n                    ;\n                    };\n                ;\n                    return c;\n                }, x = function(b) {\n                    var d = [], e = [], f, g, h, i = [], j;\n                    for (f = 0; ((f < c)); f++) {\n                        g = [b[((4 * f))],b[((((4 * f)) + 1))],b[((((4 * f)) + 2))],b[((((4 * f)) + 3))],], d[f] = g;\n                    ;\n                    };\n                ;\n                    for (f = c; ((f < ((4 * ((a + 1)))))); f++) {\n                        d[f] = [];\n                        for (h = 0; ((h < 4)); h++) {\n                            e[h] = d[((f - 1))][h];\n                        ;\n                        };\n                    ;\n                        ((((((f % c)) === 0)) ? (e = y(z(e)), e[0] ^= C[((((f / c)) - 1))]) : ((((((c > 6)) && ((((f % c)) == 4)))) && (e = y(e))))));\n                        for (h = 0; ((h < 4)); h++) {\n                            d[f][h] = ((d[((f - c))][h] ^ e[h]));\n                        ;\n                        };\n                    ;\n                    };\n                ;\n                    for (f = 0; ((f < ((a + 1)))); f++) {\n                        i[f] = [];\n                        for (j = 0; ((j < 4)); j++) {\n                            i[f].push(d[((((f * 4)) + j))][0], d[((((f * 4)) + j))][1], d[((((f * 4)) + j))][2], d[((((f * 4)) + j))][3]);\n                        ;\n                        };\n                    ;\n                    };\n                ;\n                    return i;\n                }, y = function(a) {\n                    for (var b = 0; ((b < 4)); b++) {\n                        a[b] = A[a[b]];\n                    ;\n                    };\n                ;\n                    return a;\n                }, z = function(a) {\n                    var b = a[0], c;\n                    for (c = 0; ((c < 4)); c++) {\n                        a[c] = a[((c + 1))];\n                    ;\n                    };\n                ;\n                    return a[3] = b, a;\n                }, A = [99,124,119,123,242,107,111,197,48,1,103,43,254,215,171,118,202,130,201,125,250,89,71,240,173,212,162,175,156,164,114,192,183,253,147,38,54,63,247,204,52,165,229,241,113,216,49,21,4,199,35,195,24,150,5,154,7,18,128,226,235,39,178,117,9,131,44,26,27,110,90,160,82,59,214,179,41,227,47,132,83,209,0,237,32,252,177,91,106,203,190,57,74,76,88,207,208,239,170,251,67,77,51,133,69,249,2,127,80,60,159,168,81,163,64,143,146,157,56,245,188,182,218,33,16,255,243,210,205,12,19,236,95,151,68,23,196,167,126,61,100,93,25,115,96,129,79,220,34,42,144,136,70,238,184,20,222,94,11,219,224,50,58,10,73,6,36,92,194,211,172,98,145,149,228,121,231,200,55,109,141,213,78,169,108,86,244,234,101,122,174,8,186,120,37,46,28,166,180,198,232,221,116,31,75,189,139,138,112,62,181,102,72,3,246,14,97,53,87,185,134,193,29,158,225,248,152,17,105,217,142,148,155,30,135,233,206,85,40,223,140,161,137,13,191,230,66,104,65,153,45,15,176,84,187,22,], B = [82,9,106,213,48,54,165,56,191,64,163,158,129,243,215,251,124,227,57,130,155,47,255,135,52,142,67,68,196,222,233,203,84,123,148,50,166,194,35,61,238,76,149,11,66,250,195,78,8,46,161,102,40,217,36,178,118,91,162,73,109,139,209,37,114,248,246,100,134,104,152,22,212,164,92,204,93,101,182,146,108,112,72,80,253,237,185,218,94,21,70,87,167,141,157,132,144,216,171,0,140,188,211,10,247,228,88,5,184,179,69,6,208,44,30,143,202,63,15,2,193,175,189,3,1,19,138,107,58,145,17,65,79,103,220,234,151,242,207,206,240,180,230,115,150,172,116,34,231,173,53,133,226,249,55,232,28,117,223,110,71,241,26,113,29,41,197,137,111,183,98,14,170,24,190,27,252,86,62,75,198,210,121,32,154,219,192,254,120,205,90,244,31,221,168,51,136,7,199,49,177,18,16,89,39,128,236,95,96,81,127,169,25,181,74,13,45,229,122,159,147,201,156,239,160,224,59,77,174,42,245,176,200,235,187,60,131,83,153,97,23,43,4,126,186,119,214,38,225,105,20,99,85,33,12,125,], C = [1,2,4,8,16,32,64,128,27,54,108,216,171,77,154,47,94,188,99,198,151,53,106,212,179,125,250,239,197,145,], D = [0,2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,94,96,98,100,102,104,106,108,110,112,114,116,118,120,122,124,126,128,130,132,134,136,138,140,142,144,146,148,150,152,154,156,158,160,162,164,166,168,170,172,174,176,178,180,182,184,186,188,190,192,194,196,198,200,202,204,206,208,210,212,214,216,218,220,222,224,226,228,230,232,234,236,238,240,242,244,246,248,250,252,254,27,25,31,29,19,17,23,21,11,9,15,13,3,1,7,5,59,57,63,61,51,49,55,53,43,41,47,45,35,33,39,37,91,89,95,93,83,81,87,85,75,73,79,77,67,65,71,69,123,121,127,125,115,113,119,117,107,105,111,109,99,97,103,101,155,153,159,157,147,145,151,149,139,137,143,141,131,129,135,133,187,185,191,189,179,177,183,181,171,169,175,173,163,161,167,165,219,217,223,221,211,209,215,213,203,201,207,205,195,193,199,197,251,249,255,253,243,241,247,245,235,233,239,237,227,225,231,229,], E = [0,3,6,5,12,15,10,9,24,27,30,29,20,23,18,17,48,51,54,53,60,63,58,57,40,43,46,45,36,39,34,33,96,99,102,101,108,111,106,105,120,123,126,125,116,119,114,113,80,83,86,85,92,95,90,89,72,75,78,77,68,71,66,65,192,195,198,197,204,207,202,201,216,219,222,221,212,215,210,209,240,243,246,245,252,255,250,249,232,235,238,237,228,231,226,225,160,163,166,165,172,175,170,169,184,187,190,189,180,183,178,177,144,147,150,149,156,159,154,153,136,139,142,141,132,135,130,129,155,152,157,158,151,148,145,146,131,128,133,134,143,140,137,138,171,168,173,174,167,164,161,162,179,176,181,182,191,188,185,186,251,248,253,254,247,244,241,242,227,224,229,230,239,236,233,234,203,200,205,206,199,196,193,194,211,208,213,214,223,220,217,218,91,88,93,94,87,84,81,82,67,64,69,70,79,76,73,74,107,104,109,110,103,100,97,98,115,112,117,118,127,124,121,122,59,56,61,62,55,52,49,50,35,32,37,38,47,44,41,42,11,8,13,14,7,4,1,2,19,16,21,22,31,28,25,26,], F = [0,9,18,27,36,45,54,63,72,65,90,83,108,101,126,119,144,153,130,139,180,189,166,175,216,209,202,195,252,245,238,231,59,50,41,32,31,22,13,4,115,122,97,104,87,94,69,76,171,162,185,176,143,134,157,148,227,234,241,248,199,206,213,220,118,127,100,109,82,91,64,73,62,55,44,37,26,19,8,1,230,239,244,253,194,203,208,217,174,167,188,181,138,131,152,145,77,68,95,86,105,96,123,114,5,12,23,30,33,40,51,58,221,212,207,198,249,240,235,226,149,156,135,142,177,184,163,170,236,229,254,247,200,193,218,211,164,173,182,191,128,137,146,155,124,117,110,103,88,81,74,67,52,61,38,47,16,25,2,11,215,222,197,204,243,250,225,232,159,150,141,132,187,178,169,160,71,78,85,92,99,106,113,120,15,6,29,20,43,34,57,48,154,147,136,129,190,183,172,165,210,219,192,201,246,255,228,237,10,3,24,17,46,39,60,53,66,75,80,89,102,111,116,125,161,168,179,186,133,140,151,158,233,224,251,242,205,196,223,214,49,56,35,42,21,28,7,14,121,112,107,98,93,84,79,70,], G = [0,11,22,29,44,39,58,49,88,83,78,69,116,127,98,105,176,187,166,173,156,151,138,129,232,227,254,245,196,207,210,217,123,112,109,102,87,92,65,74,35,40,53,62,15,4,25,18,203,192,221,214,231,236,241,250,147,152,133,142,191,180,169,162,246,253,224,235,218,209,204,199,174,165,184,179,130,137,148,159,70,77,80,91,106,97,124,119,30,21,8,3,50,57,36,47,141,134,155,144,161,170,183,188,213,222,195,200,249,242,239,228,61,54,43,32,17,26,7,12,101,110,115,120,73,66,95,84,247,252,225,234,219,208,205,198,175,164,185,178,131,136,149,158,71,76,81,90,107,96,125,118,31,20,9,2,51,56,37,46,140,135,154,145,160,171,182,189,212,223,194,201,248,243,238,229,60,55,42,33,16,27,6,13,100,111,114,121,72,67,94,85,1,10,23,28,45,38,59,48,89,82,79,68,117,126,99,104,177,186,167,172,157,150,139,128,233,226,255,244,197,206,211,216,122,113,108,103,86,93,64,75,34,41,52,63,14,5,24,19,202,193,220,215,230,237,240,251,146,153,132,143,190,181,168,163,], H = [0,13,26,23,52,57,46,35,104,101,114,127,92,81,70,75,208,221,202,199,228,233,254,243,184,181,162,175,140,129,150,155,187,182,161,172,143,130,149,152,211,222,201,196,231,234,253,240,107,102,113,124,95,82,69,72,3,14,25,20,55,58,45,32,109,96,119,122,89,84,67,78,5,8,31,18,49,60,43,38,189,176,167,170,137,132,147,158,213,216,207,194,225,236,251,246,214,219,204,193,226,239,248,245,190,179,164,169,138,135,144,157,6,11,28,17,50,63,40,37,110,99,116,121,90,87,64,77,218,215,192,205,238,227,244,249,178,191,168,165,134,139,156,145,10,7,16,29,62,51,36,41,98,111,120,117,86,91,76,65,97,108,123,118,85,88,79,66,9,4,19,30,61,48,39,42,177,188,171,166,133,136,159,146,217,212,195,206,237,224,247,250,183,186,173,160,131,142,153,148,223,210,197,200,235,230,241,252,103,106,125,112,83,94,73,68,15,2,21,24,59,54,33,44,12,1,22,27,56,53,34,47,100,105,126,115,80,93,74,71,220,209,198,203,232,229,242,255,180,185,174,163,128,141,154,151,], I = [0,14,28,18,56,54,36,42,112,126,108,98,72,70,84,90,224,238,252,242,216,214,196,202,144,158,140,130,168,166,180,186,219,213,199,201,227,237,255,241,171,165,183,185,147,157,143,129,59,53,39,41,3,13,31,17,75,69,87,89,115,125,111,97,173,163,177,191,149,155,137,135,221,211,193,207,229,235,249,247,77,67,81,95,117,123,105,103,61,51,33,47,5,11,25,23,118,120,106,100,78,64,82,92,6,8,26,20,62,48,34,44,150,152,138,132,174,160,178,188,230,232,250,244,222,208,194,204,65,79,93,83,121,119,101,107,49,63,45,35,9,7,21,27,161,175,189,179,153,151,133,139,209,223,205,195,233,231,245,251,154,148,134,136,162,172,190,176,234,228,246,248,210,220,206,192,122,116,102,104,66,76,94,80,10,4,22,24,50,60,46,32,236,226,240,254,212,218,200,198,156,146,128,142,164,170,184,182,12,2,16,30,52,58,40,38,124,114,96,110,68,74,88,86,55,57,43,37,15,1,19,29,71,73,91,85,127,113,99,109,215,217,203,197,239,225,243,253,167,169,187,181,159,145,131,141,], J = function(a, b, c) {\n                    var d = m(8), e = n(k(b), d), f = e.key, g = e.iv, h, i = [[83,97,108,116,101,100,95,95,].concat(d),];\n                    return ((c || (a = k(a)))), h = o(a, f, g), h = i.concat(h), M.encode(h);\n                }, K = function(a, b, c) {\n                    var d = M.decode(a), e = d.slice(8, 16), f = n(k(b), e), g = f.key, h = f.iv;\n                    return d = d.slice(16, d.length), a = p(d, g, h, c), a;\n                }, L = function(a) {\n                    function b(a, b) {\n                        return ((((a << b)) | ((a >>> ((32 - b))))));\n                    };\n                ;\n                    function c(a, b) {\n                        var c, d, e, f, g;\n                        return e = ((a & 2147483648)), f = ((b & 2147483648)), c = ((a & 1073741824)), d = ((b & 1073741824)), g = ((((a & 1073741823)) + ((b & 1073741823)))), ((((c & d)) ? ((((((g ^ 2147483648)) ^ e)) ^ f)) : ((((c | d)) ? ((((g & 1073741824)) ? ((((((g ^ 3221225472)) ^ e)) ^ f)) : ((((((g ^ 1073741824)) ^ e)) ^ f)))) : ((((g ^ e)) ^ f))))));\n                    };\n                ;\n                    function d(a, b, c) {\n                        return ((((a & b)) | ((~a & c))));\n                    };\n                ;\n                    function e(a, b, c) {\n                        return ((((a & c)) | ((b & ~c))));\n                    };\n                ;\n                    function f(a, b, c) {\n                        return ((((a ^ b)) ^ c));\n                    };\n                ;\n                    function g(a, b, c) {\n                        return ((b ^ ((a | ~c))));\n                    };\n                ;\n                    function h(a, e, f, g, h, i, j) {\n                        return a = c(a, c(c(d(e, f, g), h), j)), c(b(a, i), e);\n                    };\n                ;\n                    function i(a, d, f, g, h, i, j) {\n                        return a = c(a, c(c(e(d, f, g), h), j)), c(b(a, i), d);\n                    };\n                ;\n                    function j(a, d, e, g, h, i, j) {\n                        return a = c(a, c(c(f(d, e, g), h), j)), c(b(a, i), d);\n                    };\n                ;\n                    function k(a, d, e, f, h, i, j) {\n                        return a = c(a, c(c(g(d, e, f), h), j)), c(b(a, i), d);\n                    };\n                ;\n                    function l(a) {\n                        var b, c = a.length, d = ((c + 8)), e = ((((d - ((d % 64)))) / 64)), f = ((((e + 1)) * 16)), g = [], h = 0, i = 0;\n                        while (((i < c))) {\n                            b = ((((i - ((i % 4)))) / 4)), h = ((((i % 4)) * 8)), g[b] = ((g[b] | ((a[i] << h)))), i++;\n                        ;\n                        };\n                    ;\n                        return b = ((((i - ((i % 4)))) / 4)), h = ((((i % 4)) * 8)), g[b] = ((g[b] | ((128 << h)))), g[((f - 2))] = ((c << 3)), g[((f - 1))] = ((c >>> 29)), g;\n                    };\n                ;\n                    function m(a) {\n                        var b, c, d = [];\n                        for (c = 0; ((c <= 3)); c++) {\n                            b = ((((a >>> ((c * 8)))) & 255)), d = d.concat(b);\n                        ;\n                        };\n                    ;\n                        return d;\n                    };\n                ;\n                    var n = [], o, p, q, r, s, t, u, v, w, x = 7, y = 12, z = 17, A = 22, B = 5, C = 9, D = 14, E = 20, F = 4, G = 11, H = 16, I = 23, J = 6, K = 10, L = 15, M = 21;\n                    n = l(a), t = 1732584193, u = 4023233417, v = 2562383102, w = 271733878;\n                    for (o = 0; ((o < n.length)); o += 16) {\n                        p = t, q = u, r = v, s = w, t = h(t, u, v, w, n[((o + 0))], x, 3614090360), w = h(w, t, u, v, n[((o + 1))], y, 3905402710), v = h(v, w, t, u, n[((o + 2))], z, 606105819), u = h(u, v, w, t, n[((o + 3))], A, 3250441966), t = h(t, u, v, w, n[((o + 4))], x, 4118548399), w = h(w, t, u, v, n[((o + 5))], y, 1200080426), v = h(v, w, t, u, n[((o + 6))], z, 2821735955), u = h(u, v, w, t, n[((o + 7))], A, 4249261313), t = h(t, u, v, w, n[((o + 8))], x, 1770035416), w = h(w, t, u, v, n[((o + 9))], y, 2336552879), v = h(v, w, t, u, n[((o + 10))], z, 4294925233), u = h(u, v, w, t, n[((o + 11))], A, 2304563134), t = h(t, u, v, w, n[((o + 12))], x, 1804603682), w = h(w, t, u, v, n[((o + 13))], y, 4254626195), v = h(v, w, t, u, n[((o + 14))], z, 2792965006), u = h(u, v, w, t, n[((o + 15))], A, 1236535329), t = i(t, u, v, w, n[((o + 1))], B, 4129170786), w = i(w, t, u, v, n[((o + 6))], C, 3225465664), v = i(v, w, t, u, n[((o + 11))], D, 643717713), u = i(u, v, w, t, n[((o + 0))], E, 3921069994), t = i(t, u, v, w, n[((o + 5))], B, 3593408605), w = i(w, t, u, v, n[((o + 10))], C, 38016083), v = i(v, w, t, u, n[((o + 15))], D, 3634488961), u = i(u, v, w, t, n[((o + 4))], E, 3889429448), t = i(t, u, v, w, n[((o + 9))], B, 568446438), w = i(w, t, u, v, n[((o + 14))], C, 3275163606), v = i(v, w, t, u, n[((o + 3))], D, 4107603335), u = i(u, v, w, t, n[((o + 8))], E, 1163531501), t = i(t, u, v, w, n[((o + 13))], B, 2850285829), w = i(w, t, u, v, n[((o + 2))], C, 4243563512), v = i(v, w, t, u, n[((o + 7))], D, 1735328473), u = i(u, v, w, t, n[((o + 12))], E, 2368359562), t = j(t, u, v, w, n[((o + 5))], F, 4294588738), w = j(w, t, u, v, n[((o + 8))], G, 2272392833), v = j(v, w, t, u, n[((o + 11))], H, 1839030562), u = j(u, v, w, t, n[((o + 14))], I, 4259657740), t = j(t, u, v, w, n[((o + 1))], F, 2763975236), w = j(w, t, u, v, n[((o + 4))], G, 1272893353), v = j(v, w, t, u, n[((o + 7))], H, 4139469664), u = j(u, v, w, t, n[((o + 10))], I, 3200236656), t = j(t, u, v, w, n[((o + 13))], F, 681279174), w = j(w, t, u, v, n[((o + 0))], G, 3936430074), v = j(v, w, t, u, n[((o + 3))], H, 3572445317), u = j(u, v, w, t, n[((o + 6))], I, 76029189), t = j(t, u, v, w, n[((o + 9))], F, 3654602809), w = j(w, t, u, v, n[((o + 12))], G, 3873151461), v = j(v, w, t, u, n[((o + 15))], H, 530742520), u = j(u, v, w, t, n[((o + 2))], I, 3299628645), t = k(t, u, v, w, n[((o + 0))], J, 4096336452), w = k(w, t, u, v, n[((o + 7))], K, 1126891415), v = k(v, w, t, u, n[((o + 14))], L, 2878612391), u = k(u, v, w, t, n[((o + 5))], M, 4237533241), t = k(t, u, v, w, n[((o + 12))], J, 1700485571), w = k(w, t, u, v, n[((o + 3))], K, 2399980690), v = k(v, w, t, u, n[((o + 10))], L, 4293915773), u = k(u, v, w, t, n[((o + 1))], M, 2240044497), t = k(t, u, v, w, n[((o + 8))], J, 1873313359), w = k(w, t, u, v, n[((o + 15))], K, 4264355552), v = k(v, w, t, u, n[((o + 6))], L, 2734768916), u = k(u, v, w, t, n[((o + 13))], M, 1309151649), t = k(t, u, v, w, n[((o + 4))], J, 4149444226), w = k(w, t, u, v, n[((o + 11))], K, 3174756917), v = k(v, w, t, u, n[((o + 2))], L, 718787259), u = k(u, v, w, t, n[((o + 9))], M, 3951481745), t = c(t, p), u = c(u, q), v = c(v, r), w = c(w, s);\n                    ;\n                    };\n                ;\n                    return m(t).concat(m(u), m(v), m(w));\n                }, M = function() {\n                    var a = \"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/\", b = a.split(\"\"), c = function(a, c) {\n                        var d = [], e = \"\", f, g;\n                        totalChunks = Math.floor(((((a.length * 16)) / 3)));\n                        for (f = 0; ((f < ((a.length * 16)))); f++) {\n                            d.push(a[Math.floor(((f / 16)))][((f % 16))]);\n                        ;\n                        };\n                    ;\n                        for (f = 0; ((f < d.length)); f += 3) {\n                            e += b[((d[f] >> 2))], e += b[((((((d[f] & 3)) << 4)) | ((d[((f + 1))] >> 4))))], ((((d[((f + 1))] !== undefined)) ? e += b[((((((d[((f + 1))] & 15)) << 2)) | ((d[((f + 2))] >> 6))))] : e += \"=\")), ((((d[((f + 2))] !== undefined)) ? e += b[((d[((f + 2))] & 63))] : e += \"=\"));\n                        ;\n                        };\n                    ;\n                        g = ((e.slice(0, 64) + \"\\u000a\"));\n                        for (f = 1; ((f < Math.ceil(((e.length / 64))))); f++) {\n                            g += ((e.slice(((f * 64)), ((((f * 64)) + 64))) + ((((Math.ceil(((e.length / 64))) == ((f + 1)))) ? \"\" : \"\\u000a\"))));\n                        ;\n                        };\n                    ;\n                        return g;\n                    }, d = function(b) {\n                        b = b.replace(/\\n/g, \"\");\n                        var c = [], d = [], e = [], f;\n                        for (f = 0; ((f < b.length)); f += 4) {\n                            d[0] = a.indexOf(b.charAt(f)), d[1] = a.indexOf(b.charAt(((f + 1)))), d[2] = a.indexOf(b.charAt(((f + 2)))), d[3] = a.indexOf(b.charAt(((f + 3)))), e[0] = ((((d[0] << 2)) | ((d[1] >> 4)))), e[1] = ((((((d[1] & 15)) << 4)) | ((d[2] >> 2)))), e[2] = ((((((d[2] & 3)) << 6)) | d[3])), c.push(e[0], e[1], e[2]);\n                        ;\n                        };\n                    ;\n                        return c = c.slice(0, ((c.length - ((c.length % 16))))), c;\n                    };\n                    return ((((typeof Array.indexOf == \"function\")) && (a = b))), {\n                        encode: c,\n                        decode: d\n                    };\n                }();\n                return {\n                    size: l,\n                    h2a: j,\n                    expandKey: x,\n                    encryptBlock: q,\n                    decryptBlock: r,\n                    Decrypt: d,\n                    s2a: k,\n                    rawEncrypt: o,\n                    dec: K,\n                    openSSLKey: n,\n                    a2h: i,\n                    enc: J,\n                    Hash: {\n                        MD5: L\n                    },\n                    Base64: M\n                };\n            }();\n            a.GibberishAES = b;\n        })(window);\n    });\n    provide(\"app/utils/crypto/aes\", function(a) {\n        using(\"$lib/gibberish-aes.js\", function() {\n            var b = GibberishAES;\n            window.GibberishAES = null, a(b);\n        });\n    });\n    define(\"app/utils/storage/with_crypto\", [\"module\",\"require\",\"exports\",\"app/utils/crypto/aes\",], function(module, require, exports) {\n        function withCrypto() {\n            this.after(\"initialize\", function(a, b) {\n                this.secret = b;\n            }), this.around(\"getItem\", function(a, b) {\n                try {\n                    return a(b);\n                } catch (c) {\n                    return this.removeItem(b), null;\n                };\n            ;\n            }), this.around(\"decode\", function(a, b) {\n                return a(aes.dec(b, this.secret));\n            }), this.around(\"encode\", function(a, b) {\n                return aes.enc(a(b), this.secret);\n            });\n        };\n    ;\n        var aes = require(\"app/utils/crypto/aes\");\n        module.exports = withCrypto;\n    });\n    define(\"app/utils/storage/with_expiry\", [\"module\",\"require\",\"exports\",\"app/utils/storage/core\",], function(module, require, exports) {\n        function withExpiry() {\n            this.now = function() {\n                return (new JSBNG__Date).getTime();\n            }, this.isExpired = function(a) {\n                var b = this.ttl.getItem(a);\n                return ((((((typeof b == \"number\")) && ((this.now() > b)))) ? !0 : !1));\n            }, this.updateTTL = function(a, b) {\n                ((((typeof b == \"number\")) && this.ttl.setItem(a, ((this.now() + b)))));\n            }, this.getCacheAge = function(a, b) {\n                var c = this.ttl.getItem(a);\n                if (((c == null))) {\n                    return -1;\n                }\n            ;\n            ;\n                var d = ((c - b)), e = ((this.now() - d));\n                return ((((e < 0)) ? -1 : Math.floor(((e / 3600000)))));\n            }, this.after(\"initialize\", function() {\n                this.ttl = new JSBNG__Storage(((this.namespace + \"_ttl\")));\n            }), this.around(\"setItem\", function(a, b, c, d) {\n                return ((((typeof d == \"number\")) ? this.ttl.setItem(b, ((this.now() + d))) : this.ttl.removeItem(b))), a(b, c);\n            }), this.around(\"getItem\", function(a, b) {\n                var c = this.ttl.getItem(b);\n                return ((((((typeof c == \"number\")) && ((this.now() > c)))) && this.removeItem(b))), a(b);\n            }), this.after(\"removeItem\", function(a) {\n                this.ttl.removeItem(a);\n            }), this.after(\"clear\", function() {\n                this.ttl.clear();\n            });\n        };\n    ;\n        var JSBNG__Storage = require(\"app/utils/storage/core\");\n        module.exports = withExpiry;\n    });\n    define(\"app/utils/storage/array/with_array\", [\"module\",\"require\",\"exports\",], function(module, require, exports) {\n        function withArray() {\n            this.getArray = function(a) {\n                return ((this.getItem(a) || []));\n            }, this.push = function(a, b) {\n                var c = this.getArray(a), d = c.push(b);\n                return this.setItem(a, c), d;\n            }, this.pushAll = function(a, b) {\n                var c = this.getArray(a);\n                return c.push.apply(c, b), this.setItem(a, c), c;\n            };\n        };\n    ;\n        module.exports = withArray;\n    });\n    define(\"app/utils/storage/array/with_max_elements\", [\"module\",\"require\",\"exports\",\"core/compose\",\"app/utils/storage/array/with_array\",], function(module, require, exports) {\n        function withMaxElements() {\n            compose.mixin(this, [withArray,]), this.maxElements = {\n            }, this.getMaxElements = function(a) {\n                return ((this.maxElements[a] || 0));\n            }, this.setMaxElements = function(a, b) {\n                this.maxElements[a] = b;\n            }, this.before(\"push\", function(a, b) {\n                this.makeRoomFor(a, 1);\n            }), this.around(\"pushAll\", function(a, b, c) {\n                return c = ((c || [])), this.makeRoomFor(b, c.length), a(b, c.slice(Math.max(0, ((c.length - this.getMaxElements(b))))));\n            }), this.makeRoomFor = function(a, b) {\n                var c = this.getArray(a), d = ((((c.length + b)) - this.getMaxElements(a)));\n                ((((d > 0)) && (c.splice(0, d), this.setItem(a, c))));\n            };\n        };\n    ;\n        var compose = require(\"core/compose\"), withArray = require(\"app/utils/storage/array/with_array\");\n        module.exports = withMaxElements;\n    });\n    define(\"app/utils/storage/array/with_unique_elements\", [\"module\",\"require\",\"exports\",\"core/compose\",\"app/utils/storage/array/with_array\",], function(module, require, exports) {\n        function withUniqueElements() {\n            compose.mixin(this, [withArray,]), this.before(\"push\", function(a, b) {\n                var c = this.getArray(a);\n                ((this.deleteElement(c, b) && this.setItem(a, c)));\n            }), this.around(\"pushAll\", function(a, b, c) {\n                c = ((c || []));\n                var d = this.getArray(b), e = !1, f = [], g = {\n                };\n                return c.forEach(function(a) {\n                    ((g[a] || (e = ((this.deleteElement(d, a) || e)), g[a] = !0, f.push(a))));\n                }, this), ((e && this.setItem(b, d))), a(b, f);\n            }), this.deleteElement = function(a, b) {\n                var c = -1;\n                return (((((c = a.indexOf(b)) >= 0)) ? (a.splice(c, 1), !0) : !1));\n            };\n        };\n    ;\n        var compose = require(\"core/compose\"), withArray = require(\"app/utils/storage/array/with_array\");\n        module.exports = withUniqueElements;\n    });\n    define(\"app/utils/storage/custom\", [\"module\",\"require\",\"exports\",\"core/compose\",\"app/utils/storage/core\",\"app/utils/storage/with_crypto\",\"app/utils/storage/with_expiry\",\"app/utils/storage/array/with_array\",\"app/utils/storage/array/with_max_elements\",\"app/utils/storage/array/with_unique_elements\",], function(module, require, exports) {\n        function storageConstr(a) {\n            var b = Object.keys(a).filter(function(b) {\n                return a[b];\n            }).sort().join(\",\"), c;\n            if (c = lookup[b]) {\n                return c;\n            }\n        ;\n        ;\n            c = function() {\n                CoreStorage.apply(this, arguments);\n            }, c.prototype = new CoreStorage;\n            var d = [];\n            return ((a.withCrypto && d.push(withCrypto))), ((a.withExpiry && d.push(withExpiry))), ((a.withArray && d.push(withArray))), ((a.withUniqueElements && d.push(withUniqueElements))), ((a.withMaxElements && d.push(withMaxElements))), ((((d.length > 0)) && compose.mixin(c.prototype, d))), lookup[b] = c, c;\n        };\n    ;\n        var compose = require(\"core/compose\"), CoreStorage = require(\"app/utils/storage/core\"), withCrypto = require(\"app/utils/storage/with_crypto\"), withExpiry = require(\"app/utils/storage/with_expiry\"), withArray = require(\"app/utils/storage/array/with_array\"), withMaxElements = require(\"app/utils/storage/array/with_max_elements\"), withUniqueElements = require(\"app/utils/storage/array/with_unique_elements\"), lookup = {\n        };\n        module.exports = storageConstr;\n    });\n    define(\"app/data/with_data\", [\"module\",\"require\",\"exports\",\"core/compose\",\"core/i18n\",\"app/data/notifications\",\"app/utils/params\",\"app/data/with_auth_token\",\"app/utils/storage/custom\",\"app/utils/storage/core\",], function(module, require, exports) {\n        function initializeXhrStorage() {\n            ((xhrStorage || (xhrStorage = new CoreStorage(\"XHRNotes\"))));\n        };\n    ;\n        function withData() {\n            compose.mixin(this, [withAuthToken,]);\n            var a = [];\n            this.composeData = function(a, b) {\n                return a = ((a || {\n                })), ((b.eventData && (a.sourceEventData = b.eventData))), a;\n            }, this.callSuccessHandler = function(a, b, c) {\n                ((((typeof a == \"function\")) ? a(b) : this.trigger(a, b)));\n            }, this.callErrorHandler = function(a, b, c) {\n                ((((typeof a == \"function\")) ? a(b) : this.trigger(a, b)));\n            }, this.createSuccessHandler = function(b, c) {\n                return initializeXhrStorage(), function(d, e, f) {\n                    a.slice(a.indexOf(f), 1);\n                    var g = d, h = null, i = encodeURIComponent(c.url);\n                    if (((((d && d.hasOwnProperty(\"note\"))) && d.hasOwnProperty(\"JSBNG__inner\")))) {\n                        g = d.JSBNG__inner, h = d.note;\n                        var j = f.getResponseHeader(\"x-transaction\");\n                        ((((j && ((j != xhrStorage.getItem(i))))) && (h.notCached = !0, xhrStorage.setItem(i, j))));\n                    }\n                ;\n                ;\n                    g = this.composeData(g, c), ((c.cache_ttl && storage.setItem(i, {\n                        data: g,\n                        time: (new JSBNG__Date).getTime()\n                    }, c.cache_ttl))), this.callSuccessHandler(b, g, c), ((h && (notifications.updateNotificationState(h), ((h.notCached && this.trigger(\"dataNotificationsReceived\", h)))))), ((g.debug && this.trigger(\"dataSetDebugData\", g.debug)));\n                }.bind(this);\n            }, this.createErrorHandler = function(b, c) {\n                return function(d) {\n                    a.slice(a.indexOf(d), 1);\n                    var e;\n                    try {\n                        e = JSON.parse(d.responseText), ((((((e && e.message)) && !this.attr.noShowError)) && this.trigger(\"uiShowError\", e)));\n                    } catch (f) {\n                        e = {\n                            xhr: {\n                            }\n                        }, ((((d && d.statusText)) && (e.xhr.statusText = d.statusText)));\n                    };\n                ;\n                    ((e.message || (e.message = _(\"Internal server error.\")))), e = this.composeData(e, c), this.callErrorHandler(b, e, c);\n                }.bind(this);\n            }, this.sortData = function(a) {\n                if (((!a || ((typeof a != \"object\"))))) {\n                    return a;\n                }\n            ;\n            ;\n                var b = {\n                }, c = Object.keys(a).sort();\n                return c.forEach(function(c) {\n                    b[c] = a[c];\n                }), b;\n            }, this.extractParams = function(a, b) {\n                var c = {\n                }, d = params.fromQuery(b);\n                return Object.keys(d).forEach(function(b) {\n                    ((a[b] && (c[b] = d[b])));\n                }), c;\n            }, this.JSONRequest = function(b, c) {\n                var d;\n                if (b.cache_ttl) {\n                    ((storage || (storage = new StorageConstr(\"with_data\")))), d = storage.getItem(encodeURIComponent(b.url));\n                    if (((d && ((((new JSBNG__Date - d.time)) <= b.cache_ttl))))) {\n                        ((b.success && this.callSuccessHandler(b.success, d.data)));\n                        return;\n                    }\n                ;\n                ;\n                }\n            ;\n            ;\n                var e = ((((c == \"POST\")) || ((c == \"DELETE\"))));\n                ((((e && ((b.isMutation === !1)))) && (e = !1))), delete b.isMutation, ((((this.trigger && e)) && this.trigger(\"dataPageMutated\"))), [\"url\",].forEach(function(a) {\n                    if (!b.hasOwnProperty(a)) {\n                        throw new Error(((\"getJSONRequest called without required option: \" + a)), arguments);\n                    }\n                ;\n                ;\n                });\n                var f = ((b.data || {\n                })), g = b.headers;\n                (((([\"GET\",\"POST\",].indexOf(c) < 0)) && (f = $.extend({\n                    _method: c\n                }, f), c = \"POST\"))), ((((c == \"POST\")) && (f = this.addAuthToken(f), ((((g && g[\"X-PHX\"])) && (f = this.addPHXAuthToken(f)))))));\n                var h = $.extend({\n                    lang: !0\n                }, b.echoParams);\n                f = $.extend(f, this.extractParams(h, window.JSBNG__location)), ((b.success && (b.success = this.createSuccessHandler(b.success, b)))), ((b.error && (b.error = this.createErrorHandler(b.error, b)))), $.extend(f, notifications.extraParameters(b.url));\n                var i = $.ajax($.extend(b, {\n                    url: b.url,\n                    data: this.sortData(f),\n                    dataType: ((b.dataType || \"json\")),\n                    type: c\n                }));\n                return ((b.noAbortOnNavigate || a.push(i))), i;\n            }, this.get = function(a) {\n                return this.JSONRequest(a, \"GET\");\n            }, this.post = function(a) {\n                return this.JSONRequest(a, \"POST\");\n            }, this.destroy = function(a) {\n                return this.JSONRequest(a, \"DELETE\");\n            }, this.abortAllXHR = function() {\n                a.forEach(function(a) {\n                    ((((a && a.abort)) && a.abort()));\n                }), a = [];\n            }, this.after(\"initialize\", function() {\n                this.JSBNG__on(JSBNG__document, \"dataBeforeNavigate\", this.abortAllXHR);\n            });\n        };\n    ;\n        var compose = require(\"core/compose\"), _ = require(\"core/i18n\"), notifications = require(\"app/data/notifications\"), params = require(\"app/utils/params\"), withAuthToken = require(\"app/data/with_auth_token\"), customStorage = require(\"app/utils/storage/custom\"), CoreStorage = require(\"app/utils/storage/core\"), StorageConstr = customStorage({\n            withExpiry: !0\n        }), storage, xhrStorage;\n        module.exports = withData;\n    });\n    define(\"app/data/navigation\", [\"module\",\"require\",\"exports\",\"core/component\",\"core/utils\",\"core/registry\",\"app/utils/time\",\"app/utils/full_path\",\"app/data/with_data\",], function(module, require, exports) {\n        function navigationData() {\n            this.defaultAttrs({\n                viewContainer: \"#page-container\",\n                pushStateRequestHeaders: {\n                    \"X-Push-State-Request\": !0\n                },\n                pushState: !0,\n                pushStateSupported: !0,\n                pushStatePageLimit: 500000,\n                assetsBasePath: \"/\",\n                noTeardown: !0,\n                init_data: {\n                }\n            });\n            var a = /\\/a\\/(\\d+)/, b, c, d;\n            this.pageCache = {\n            }, this.pageCacheTTLs = {\n            }, this.pageCacheScroll = {\n            }, this.navigateUsingPushState = function(a, b) {\n                var e = fullPath();\n                d = b.href, c = b.isPopState;\n                if (((((!c && ((b.href == e)))) && this.pageCache[e]))) {\n                    return;\n                }\n            ;\n            ;\n                this.getPageData(b.href);\n            }, this.sweepPageCache = function() {\n                var a = time.now();\n                {\n                    var fin54keys = ((window.top.JSBNG_Replay.forInKeys)((this.pageCacheTTLs))), fin54i = (0);\n                    var b;\n                    for (; (fin54i < fin54keys.length); (fin54i++)) {\n                        ((b) = (fin54keys[fin54i]));\n                        {\n                            ((((a > this.pageCacheTTLs[b])) && (delete this.pageCache[b], delete this.pageCacheTTLs[b])));\n                        ;\n                        };\n                    };\n                };\n            ;\n            }, this.hasDeployTimestampChanged = function(b) {\n                var c = ((this.attr.assetsBasePath && this.attr.assetsBasePath.match(a))), d = ((b.init_data.assetsBasePath && b.init_data.assetsBasePath.match(a)));\n                return ((((c && d)) && ((d[1] != c[1]))));\n            }, this.getPageData = function(a) {\n                var b;\n                this.trigger(\"dataBeforeNavigate\"), ((this.attr.init_data.initialState && this.createInitialState())), this.sweepPageCache(), this.trigger(\"uiBeforeNewPageLoad\");\n                if (b = this.pageCache[a]) b.fromCache = !0, this.pageDataReceived(a, b);\n                 else {\n                    this.trigger(\"dataPageFetch\");\n                    var c = this.attr.pushStateRequestHeaders, e = this.pageCacheScroll[a];\n                    ((e && (c = utils.merge(c, {\n                        TopViewportItem: e.topItem\n                    })))), this.get({\n                        headers: c,\n                        url: a,\n                        success: function(b) {\n                            var c;\n                            if (((((b.init_data && b.page)) && b.module))) {\n                                c = b.init_data.href, b.href = c;\n                                if (!b.init_data.pushState) {\n                                    this.navigateTo(c);\n                                    return;\n                                }\n                            ;\n                            ;\n                                if (this.hasDeployTimestampChanged(b)) {\n                                    this.navigateTo(c);\n                                    return;\n                                }\n                            ;\n                            ;\n                                if (((b.init_data.viewContainer != this.attr.viewContainer))) {\n                                    this.attr.viewContainer = b.init_data.viewContainer, this.navigateTo(c);\n                                    return;\n                                }\n                            ;\n                            ;\n                                this.cacheState(c, b);\n                                if (((d != a))) {\n                                    return;\n                                }\n                            ;\n                            ;\n                                ((e && (b.scrollPosition = e))), this.pageDataReceived(c, b);\n                            }\n                             else this.navigateTo(((b.href || a)));\n                        ;\n                        ;\n                        }.bind(this),\n                        error: function(b) {\n                            this.navigateTo(a);\n                        }.bind(this)\n                    });\n                }\n            ;\n            ;\n            }, this.setTimelineScrollPosition = function(a, c) {\n                this.pageCacheScroll[b] = c;\n            }, this.updatePageState = function() {\n                var a = this.pageCache[b];\n                ((a && (a.page = this.select(\"viewContainer\").html(), this.pageCacheTTLs[b] = time(a.cache_ttl).seconds.fromNow().getTime(), ((((a.page.length > this.attr.pushStatePageLimit)) && (delete this.pageCache[b], delete this.pageCacheTTLs[b]))))));\n            }, this.cacheState = function(a, b) {\n                this.pageCache[a] = b, this.pageCacheTTLs[a] = time(b.cache_ttl).seconds.fromNow().getTime();\n            }, this.pageDataReceived = function(a, b) {\n                ((((a != fullPath())) && JSBNG__history.pushState({\n                }, b.title, a))), b.isPopState = c, this.trigger(\"dataPageRefresh\", b);\n            }, this.swiftTeardownAll = function() {\n                Object.keys(registry.allInstances).forEach(function(a) {\n                    var b = registry.allInstances[a].instance;\n                    ((b.attr.noTeardown || b.teardown()));\n                });\n            }, this.doTeardown = function(a, c) {\n                this.swiftTeardownAll(), ((((c.href != b)) && this.updatePageState()));\n            }, this.createInitialState = function() {\n                var a = utils.merge(this.attr.init_data.initialState, !0);\n                a.init_data = utils.merge(this.attr.init_data, !0), delete a.init_data.initialState, this.attr.init_data.initialState = null, this.cacheState(b, a), JSBNG__history.replaceState({\n                }, a.title, b);\n            }, this.resetPageCache = function(a, b) {\n                this.pageCache = {\n                }, this.pageCacheTTLs = {\n                };\n            }, this.removePageFromCache = function(a, b) {\n                var c = b.href;\n                ((this.pageCache[c] && (delete this.pageCache[c], delete this.pageCacheTTLs[c])));\n            }, this.navigateTo = function(a) {\n                JSBNG__location.href = a;\n            }, this.navigateUsingRedirect = function(a, c) {\n                var d = c.href;\n                ((((d != b)) && this.navigateTo(d)));\n            }, this.destroyCurrentPageState = function() {\n                JSBNG__history.replaceState(null, JSBNG__document.title, b);\n            }, this.resetStateVariables = function() {\n                b = fullPath(), c = !1, d = null;\n            }, this.after(\"initialize\", function() {\n                ((((this.attr.pushState && this.attr.pushStateSupported)) ? (this.JSBNG__on(\"uiSwiftLoaded uiPageChanged\", this.resetStateVariables), this.JSBNG__on(\"uiNavigate\", this.navigateUsingPushState), this.JSBNG__on(JSBNG__document, \"uiTimelineScrollSet\", this.setTimelineScrollPosition), this.JSBNG__on(\"uiTeardown\", this.doTeardown), this.JSBNG__on(JSBNG__document, \"dataPageMutated\", this.resetPageCache), this.JSBNG__on(JSBNG__document, \"uiPromotedLinkClick\", this.removePageFromCache), this.JSBNG__on(window, \"beforeunload\", this.destroyCurrentPageState)) : (this.JSBNG__on(\"uiSwiftLoaded\", this.resetStateVariables), this.JSBNG__on(\"uiNavigate\", this.navigateUsingRedirect))));\n            });\n        };\n    ;\n        var component = require(\"core/component\"), utils = require(\"core/utils\"), registry = require(\"core/registry\"), time = require(\"app/utils/time\"), fullPath = require(\"app/utils/full_path\"), withData = require(\"app/data/with_data\"), NavigationData = component(navigationData, withData);\n        module.exports = NavigationData;\n    });\n    define(\"app/ui/with_dropdown\", [\"module\",\"require\",\"exports\",], function(module, require, exports) {\n        function withDropdown() {\n            this.toggleDisplay = function(a) {\n                this.$node.toggleClass(\"open\"), ((this.$node.hasClass(\"open\") && (this.activeEl = JSBNG__document.activeElement, this.trigger(\"uiDropdownOpened\")))), ((a && a.preventDefault()));\n            }, this.ignoreCloseEvent = !1, this.closeDropdown = function() {\n                this.$node.removeClass(\"open\");\n            }, this.closeAndRestoreFocus = function(a) {\n                this.closeDropdown(), ((this.activeEl && (a.preventDefault(), this.activeEl.JSBNG__focus(), this.activeEl = null)));\n            }, this.close = function(a) {\n                var b = $(this.attr.toggler);\n                if (((((((a.target === this.$node)) || ((this.$node.has(a.target).length > 0)))) && !this.isItemClick(a)))) {\n                    return;\n                }\n            ;\n            ;\n                if (((this.isItemClick(a) && this.ignoreCloseEvent))) {\n                    return;\n                }\n            ;\n            ;\n                this.closeDropdown();\n            }, this.isItemClick = function(a) {\n                return ((((!this.attr.itemSelector || !a)) ? !1 : (($(a.target).closest(this.attr.itemSelector).length > 0))));\n            }, this.after(\"initialize\", function() {\n                this.JSBNG__on(\"click\", {\n                    toggler: this.toggleDisplay\n                }), this.JSBNG__on(JSBNG__document, \"click\", this.close), this.JSBNG__on(JSBNG__document, \"uiCloseDropdowns uiNavigate\", this.closeDropdown), this.JSBNG__on(JSBNG__document, \"uiShortcutEsc\", this.closeAndRestoreFocus);\n            });\n        };\n    ;\n        module.exports = withDropdown;\n    });\n    define(\"app/ui/language_dropdown\", [\"module\",\"require\",\"exports\",\"core/component\",\"app/ui/with_dropdown\",], function(module, require, exports) {\n        function languageDropdown() {\n            this.defaultAttrs({\n                toggler: \".dropdown-toggle\"\n            });\n        };\n    ;\n        var defineComponent = require(\"core/component\"), withDropdown = require(\"app/ui/with_dropdown\"), LanguageDropdown = defineComponent(languageDropdown, withDropdown);\n        module.exports = LanguageDropdown;\n    });\n    define(\"app/ui/google\", [\"module\",\"require\",\"exports\",\"core/component\",], function(module, require, exports) {\n        function googleAnalytics() {\n            this.defaultAttrs({\n                gaPageName: window.JSBNG__location.pathname\n            }), this.initGoogle = function() {\n                window._gaq = ((window._gaq || [])), window._gaq.push([\"_setAccount\",\"UA-30775-6\",], [\"_trackPageview\",this.attr.gaPageName,], [\"_setDomainName\",\"twitter.com\",]);\n                var a = JSBNG__document.getElementsByTagName(\"script\")[0], b = JSBNG__document.createElement(\"script\");\n                b.async = !0, b.src = ((((((JSBNG__document.JSBNG__location.protocol == \"https:\")) ? \"https://ssl\" : \"http://www\")) + \".google-analytics.com/ga.js\")), a.parentNode.insertBefore(b, a), this.off(\"uiSwiftLoaded\", this.initGoogle);\n            }, this.trackPageChange = function(a, b) {\n                b = b.init_data, window._gaq.push([\"_trackPageview\",((((b && b.gaPageName)) || window.JSBNG__location.pathname)),]);\n            }, this.after(\"initialize\", function() {\n                this.JSBNG__on(\"uiSwiftLoaded\", this.initGoogle), this.JSBNG__on(\"uiPageChanged\", this.trackPageChange);\n            });\n        };\n    ;\n        var defineComponent = require(\"core/component\"), GoogleAnalytics = defineComponent(googleAnalytics);\n        module.exports = GoogleAnalytics;\n    });\n    define(\"app/utils/cookie\", [\"module\",\"require\",\"exports\",], function(module, require, exports) {\n        module.exports = function(b, c, d) {\n            var e = $.extend({\n            }, d);\n            if (((((arguments.length > 1)) && ((String(c) !== \"[object Object]\"))))) {\n                if (((((c === null)) || ((c === undefined))))) {\n                    e.expires = -1, c = \"\";\n                }\n            ;\n            ;\n                if (((typeof e.expires == \"number\"))) {\n                    var f = e.expires, g = new JSBNG__Date((((new JSBNG__Date).getTime() + ((((((((f * 24)) * 60)) * 60)) * 1000)))));\n                    e.expires = g;\n                }\n            ;\n            ;\n                return c = String(c), JSBNG__document.cookie = [encodeURIComponent(b),\"=\",((e.raw ? c : encodeURIComponent(c))),((e.expires ? ((\"; expires=\" + e.expires.toUTCString())) : \"\")),((\"; path=\" + ((e.path || \"/\")))),((e.domain ? ((\"; domain=\" + e.domain)) : \"\")),((e.secure ? \"; secure\" : \"\")),].join(\"\");\n            }\n        ;\n        ;\n            e = ((c || {\n            }));\n            var h, i = ((e.raw ? function(a) {\n                return a;\n            } : decodeURIComponent));\n            return (((h = (new RegExp(((((\"(?:^|; )\" + encodeURIComponent(b))) + \"=([^;]*)\")))).exec(JSBNG__document.cookie)) ? i(h[1]) : null));\n        };\n    });\n    define(\"app/ui/impression_cookies\", [\"module\",\"require\",\"exports\",\"core/component\",\"app/utils/cookie\",], function(module, require, exports) {\n        function impressionCookies() {\n            this.defaultAttrs({\n                sendImpressionCookieSelector: \"a[data-send-impression-cookie]\",\n                link: \"a\"\n            }), this.setCookie = function(a, b) {\n                cookie(\"ic\", a, {\n                    expires: b\n                });\n            }, this.sendImpressionCookie = function(a, b) {\n                var c = b.el;\n                if (((((((!c || ((c.hostname != window.JSBNG__location.hostname)))) || !c.pathname)) || ((c.pathname.indexOf(\"/#!/\") == 0))))) {\n                    return;\n                }\n            ;\n            ;\n                var d = $(c), e = d.closest(\"[data-impression-cookie]\").attr(\"data-impression-cookie\");\n                if (!e) {\n                    return;\n                }\n            ;\n            ;\n                this.trigger(\"uiPromotedLinkClick\", {\n                    href: d.attr(\"href\")\n                });\n                var f = new JSBNG__Date, g = 60000, h = new JSBNG__Date(((f.getTime() + g)));\n                this.setCookie(e, h);\n            }, this.after(\"initialize\", function(a) {\n                this.JSBNG__on(\"click\", {\n                    sendImpressionCookieSelector: this.sendImpressionCookie\n                }), this.JSBNG__on(\"uiShowProfileNewWindow\", {\n                    link: this.sendImpressionCookie\n                });\n            });\n        };\n    ;\n        var defineComponent = require(\"core/component\"), cookie = require(\"app/utils/cookie\");\n        module.exports = defineComponent(impressionCookies);\n    });\n    define(\"app/data/promoted_logger\", [\"module\",\"require\",\"exports\",\"core/component\",\"app/data/with_data\",], function(module, require, exports) {\n        function promotedLogger() {\n            this.defaultAttrs({\n                tweetHashtagLinkSelector: \".tweet .twitter-hashtag\",\n                tweetLinkSelector: \".tweet .twitter-timeline-link\"\n            }), this.logEvent = function(a, b) {\n                this.get({\n                    url: \"/i/promoted_content/log.json\",\n                    data: a,\n                    eventData: {\n                    },\n                    headers: {\n                        \"X-PHX\": !0\n                    },\n                    success: \"dataLogEventSuccess\",\n                    error: \"dataLogEventError\",\n                    async: !b,\n                    noAbortOnNavigate: !0\n                });\n            }, this.isEarnedMedia = function(a) {\n                return ((a == \"earned\"));\n            }, this.logPromotedTrendImpression = function(a, b) {\n                var c = b.items, d = b.source;\n                if (((d == \"clock\"))) {\n                    return;\n                }\n            ;\n            ;\n                var e = c.filter(function(a) {\n                    return !!a.promotedTrendId;\n                });\n                if (!e.length) {\n                    return;\n                }\n            ;\n            ;\n                this.logEvent({\n                    JSBNG__event: \"i\",\n                    promoted_trend_id: e[0].promotedTrendId\n                });\n            }, this.logPromotedTrendClick = function(a, b) {\n                if (!b.promotedTrendId) {\n                    return;\n                }\n            ;\n            ;\n                this.logEvent({\n                    JSBNG__event: \"c\",\n                    promoted_trend_id: b.promotedTrendId\n                }, !0);\n            }, this.logPromotedTweetImpression = function(a, b) {\n                var c = b.tweets.filter(function(a) {\n                    return a.impressionId;\n                });\n                c.forEach(function(a) {\n                    this.logEvent({\n                        JSBNG__event: \"impression\",\n                        impression_id: a.impressionId,\n                        earned: this.isEarnedMedia(a.disclosureType)\n                    });\n                }, this);\n            }, this.logPromotedTweetLinkClick = function(a) {\n                var b = $(a.target).closest(\"[data-impression-id]\").attr(\"data-impression-id\"), c = $(a.target).closest(\"[data-impression-id]\").attr(\"data-disclosure-type\");\n                if (!b) {\n                    return;\n                }\n            ;\n            ;\n                this.logEvent({\n                    JSBNG__event: \"url_click\",\n                    impression_id: b,\n                    earned: this.isEarnedMedia(c)\n                }, !0);\n            }, this.logPromotedTweetHashtagClick = function(a) {\n                var b = $(a.target).closest(\"[data-impression-id]\").attr(\"data-impression-id\"), c = $(a.target).closest(\"[data-impression-id]\").attr(\"data-disclosure-type\");\n                if (!b) {\n                    return;\n                }\n            ;\n            ;\n                this.logEvent({\n                    JSBNG__event: \"hashtag_click\",\n                    impression_id: b,\n                    earned: this.isEarnedMedia(c)\n                }, !0);\n            }, this.logPromotedUserImpression = function(a, b) {\n                var c = b.users.filter(function(a) {\n                    return a.impressionId;\n                });\n                c.forEach(function(a) {\n                    this.logEvent({\n                        JSBNG__event: \"impression\",\n                        impression_id: a.impressionId\n                    });\n                }, this);\n            }, this.logPromotedTweetShareViaEmail = function(a, b) {\n                var c = b.impressionId;\n                if (!c) {\n                    return;\n                }\n            ;\n            ;\n                var d = this.isEarnedMedia(b.disclosureType);\n                this.logEvent({\n                    JSBNG__event: \"email_tweet\",\n                    impression_id: c,\n                    earned: d\n                });\n            }, this.logPromotedUserClick = function(a, b) {\n                var c = b.impressionId;\n                if (!c) {\n                    return;\n                }\n            ;\n            ;\n                var d = this.isEarnedMedia(b.disclosureType);\n                ((((b.profileClickTarget === \"avatar\")) ? this.logEvent({\n                    JSBNG__event: \"profile_image_click\",\n                    impression_id: c,\n                    earned: d\n                }) : ((b.isMentionClick ? this.logEvent({\n                    JSBNG__event: \"user_mention_click\",\n                    impression_id: c,\n                    earned: d\n                }) : ((b.isPromotedBadgeClick ? this.logEvent({\n                    JSBNG__event: \"footer_profile\",\n                    impression_id: c,\n                    earned: d\n                }) : this.logEvent({\n                    JSBNG__event: \"screen_name_click\",\n                    impression_id: c,\n                    earned: d\n                })))))));\n            }, this.logPromotedUserDismiss = function(a, b) {\n                var c = b.impressionId;\n                if (!c) {\n                    return;\n                }\n            ;\n            ;\n                this.logEvent({\n                    JSBNG__event: \"dismiss\",\n                    impression_id: c\n                });\n            }, this.logPromotedTweetDismiss = function(a, b) {\n                var c = b.impressionId, d = b.disclosureType;\n                if (!c) {\n                    return;\n                }\n            ;\n            ;\n                this.logEvent({\n                    JSBNG__event: \"dismiss\",\n                    impression_id: c,\n                    earned: this.isEarnedMedia(d)\n                });\n            }, this.logPromotedTweetDetails = function(a, b) {\n                var c = b.impressionId, d = b.disclosureType;\n                if (!c) {\n                    return;\n                }\n            ;\n            ;\n                this.logEvent({\n                    JSBNG__event: \"view_details\",\n                    impression_id: c,\n                    earned: this.isEarnedMedia(d)\n                });\n            }, this.after(\"initialize\", function() {\n                this.JSBNG__on(\"uiTrendsDisplayed\", this.logPromotedTrendImpression), this.JSBNG__on(\"uiTrendSelected\", this.logPromotedTrendClick), this.JSBNG__on(\"uiTweetsDisplayed\", this.logPromotedTweetImpression), this.JSBNG__on(\"click\", {\n                    tweetLinkSelector: this.logPromotedTweetLinkClick,\n                    tweetHashtagLinkSelector: this.logPromotedTweetHashtagClick\n                }), this.JSBNG__on(\"uiHasExpandedTweet\", this.logPromotedTweetDetails), this.JSBNG__on(\"uiTweetDismissed\", this.logPromotedTweetDismiss), this.JSBNG__on(\"uiDidShareViaEmailSuccess\", this.logPromotedTweetShareViaEmail), this.JSBNG__on(\"uiUsersDisplayed\", this.logPromotedUserImpression), this.JSBNG__on(\"uiDismissUserRecommendation\", this.logPromotedUserDismiss), this.JSBNG__on(\"uiShowProfilePopup uiShowProfileNewWindow\", this.logPromotedUserClick);\n            });\n        };\n    ;\n        var defineComponent = require(\"core/component\"), withData = require(\"app/data/with_data\"), PromotedLogger = defineComponent(promotedLogger, withData);\n        module.exports = PromotedLogger;\n    });\n    define(\"app/ui/message_drawer\", [\"module\",\"require\",\"exports\",\"core/component\",], function(module, require, exports) {\n        function messageDrawer() {\n            this.defaultAttrs({\n                fadeTimeout: 2000,\n                closeSelector: \".dismiss\",\n                reloadSelector: \".js-reload\",\n                textSelector: \".message-text\",\n                bannersSelector: \"#banners\",\n                topOffset: 47\n            });\n            var a = function() {\n                this.$node.css(\"opacity\", 1).animate({\n                    opacity: 0\n                }, 1000, function() {\n                    this.closeMessage();\n                }.bind(this));\n            };\n            this.calculateFadeTimeout = function(a) {\n                var b = a.split(\" \").length, c = ((((((b * 1000)) / 5)) + 225));\n                return ((((c < this.attr.fadeTimeout)) ? this.attr.fadeTimeout : c));\n            }, this.showMessage = function(b, c) {\n                this.$node.css({\n                    opacity: 1,\n                    JSBNG__top: ((this.attr.topOffset + $(this.attr.bannersSelector).height()))\n                }), this.select(\"textSelector\").html(c.message), this.select(\"closeSelector\").hide(), this.$node.removeClass(\"hidden\"), JSBNG__clearTimeout(this.messageTimeout), this.$node.JSBNG__stop(), this.messageTimeout = JSBNG__setTimeout(a.bind(this), this.calculateFadeTimeout(c.message));\n            }, this.showError = function(a, b) {\n                this.$node.css(\"opacity\", 1), this.select(\"textSelector\").html(b.message), this.select(\"closeSelector\").show(), this.$node.removeClass(\"hidden\");\n            }, this.closeMessage = function(a) {\n                ((a && a.preventDefault())), this.$node.addClass(\"hidden\");\n            }, this.reloadPageHandler = function() {\n                this.reloadPage();\n            }, this.reloadPage = function() {\n                window.JSBNG__location.reload();\n            }, this.after(\"initialize\", function() {\n                this.JSBNG__on(JSBNG__document, \"uiShowMessage\", this.showMessage), this.JSBNG__on(JSBNG__document, \"uiShowError\", this.showError), this.JSBNG__on(\"click\", {\n                    reloadSelector: this.reloadPageHandler,\n                    closeSelector: this.closeMessage\n                }), this.JSBNG__on(JSBNG__document, \"uiBeforePageChanged\", this.closeMessage);\n            });\n        };\n    ;\n        var defineComponent = require(\"core/component\"), MessageDrawer = defineComponent(messageDrawer);\n        module.exports = MessageDrawer;\n    });\n    deferred(\"$lib/bootstrap_tooltip.js\", function() {\n        !function($) {\n            \"use strict\";\n            var a = function(a, b) {\n                this.init(\"tooltip\", a, b);\n            };\n            a.prototype = {\n                constructor: a,\n                init: function(a, b, c) {\n                    var d, e;\n                    this.type = a, this.$element = $(b), this.options = this.getOptions(c), this.enabled = !0, ((((this.options.trigger != \"manual\")) && (d = ((((this.options.trigger == \"hover\")) ? \"mouseenter\" : \"JSBNG__focus\")), e = ((((this.options.trigger == \"hover\")) ? \"mouseleave\" : \"JSBNG__blur\")), this.$element.JSBNG__on(d, this.options.selector, $.proxy(this.enter, this)), this.$element.JSBNG__on(e, this.options.selector, $.proxy(this.leave, this))))), ((this.options.selector ? this._options = $.extend({\n                    }, this.options, {\n                        trigger: \"manual\",\n                        selector: \"\"\n                    }) : this.fixTitle()));\n                },\n                getOptions: function(a) {\n                    return a = $.extend({\n                    }, $.fn[this.type].defaults, a, this.$element.data()), ((((a.delay && ((typeof a.delay == \"number\")))) && (a.delay = {\n                        show: a.delay,\n                        hide: a.delay\n                    }))), a;\n                },\n                enter: function(a) {\n                    var b = $(a.currentTarget)[this.type](this._options).data(this.type);\n                    ((((!b.options.delay || !b.options.delay.show)) ? b.show() : (b.hoverState = \"in\", JSBNG__setTimeout(function() {\n                        ((((b.hoverState == \"in\")) && b.show()));\n                    }, b.options.delay.show))));\n                },\n                leave: function(a) {\n                    var b = $(a.currentTarget)[this.type](this._options).data(this.type);\n                    ((((!b.options.delay || !b.options.delay.hide)) ? b.hide() : (b.hoverState = \"out\", JSBNG__setTimeout(function() {\n                        ((((b.hoverState == \"out\")) && b.hide()));\n                    }, b.options.delay.hide))));\n                },\n                show: function() {\n                    var a, b, c, d, e, f, g;\n                    if (((this.hasContent() && this.enabled))) {\n                        a = this.tip(), this.setContent(), ((this.options.animation && a.addClass(\"fade\"))), f = ((((typeof this.options.placement == \"function\")) ? this.options.placement.call(this, a[0], this.$element[0]) : this.options.placement)), b = /in/.test(f), a.remove().css({\n                            JSBNG__top: 0,\n                            left: 0,\n                            display: \"block\"\n                        }).appendTo(((b ? this.$element : JSBNG__document.body))), c = this.getPosition(b), d = a[0].offsetWidth, e = a[0].offsetHeight;\n                        switch (((b ? f.split(\" \")[1] : f))) {\n                          case \"bottom\":\n                            g = {\n                                JSBNG__top: ((c.JSBNG__top + c.height)),\n                                left: ((((c.left + ((c.width / 2)))) - ((d / 2))))\n                            };\n                            break;\n                          case \"JSBNG__top\":\n                            g = {\n                                JSBNG__top: ((c.JSBNG__top - e)),\n                                left: ((((c.left + ((c.width / 2)))) - ((d / 2))))\n                            };\n                            break;\n                          case \"left\":\n                            g = {\n                                JSBNG__top: ((((c.JSBNG__top + ((c.height / 2)))) - ((e / 2)))),\n                                left: ((c.left - d))\n                            };\n                            break;\n                          case \"right\":\n                            g = {\n                                JSBNG__top: ((((c.JSBNG__top + ((c.height / 2)))) - ((e / 2)))),\n                                left: ((c.left + c.width))\n                            };\n                        };\n                    ;\n                        a.css(g).addClass(f).addClass(\"in\");\n                    }\n                ;\n                ;\n                },\n                setContent: function() {\n                    var a = this.tip();\n                    a.JSBNG__find(\".tooltip-inner\").html(this.getTitle()), a.removeClass(\"fade in top bottom left right\");\n                },\n                hide: function() {\n                    function c() {\n                        var a = JSBNG__setTimeout(function() {\n                            b.off($.support.transition.end).remove();\n                        }, 500);\n                        b.one($.support.transition.end, function() {\n                            JSBNG__clearTimeout(a), b.remove();\n                        });\n                    };\n                ;\n                    var a = this, b = this.tip();\n                    b.removeClass(\"in\"), (((($.support.transition && this.$tip.hasClass(\"fade\"))) ? c() : b.remove()));\n                },\n                fixTitle: function() {\n                    var a = this.$element;\n                    ((((a.attr(\"title\") || ((typeof a.attr(\"data-original-title\") != \"string\")))) && a.attr(\"data-original-title\", ((a.attr(\"title\") || \"\"))).removeAttr(\"title\")));\n                },\n                hasContent: function() {\n                    return this.getTitle();\n                },\n                getPosition: function(a) {\n                    return $.extend({\n                    }, ((a ? {\n                        JSBNG__top: 0,\n                        left: 0\n                    } : this.$element.offset())), {\n                        width: this.$element[0].offsetWidth,\n                        height: this.$element[0].offsetHeight\n                    });\n                },\n                getTitle: function() {\n                    var a, b = this.$element, c = this.options;\n                    return a = ((b.attr(\"data-original-title\") || ((((typeof c.title == \"function\")) ? c.title.call(b[0]) : c.title)))), a = ((a || \"\")).toString().replace(/(^\\s*|\\s*$)/, \"\"), a;\n                },\n                tip: function() {\n                    return this.$tip = ((this.$tip || $(this.options.template)));\n                },\n                validate: function() {\n                    ((this.$element[0].parentNode || (this.hide(), this.$element = null, this.options = null)));\n                },\n                enable: function() {\n                    this.enabled = !0;\n                },\n                disable: function() {\n                    this.enabled = !1;\n                },\n                toggleEnabled: function() {\n                    this.enabled = !this.enabled;\n                },\n                toggle: function() {\n                    this[((this.tip().hasClass(\"in\") ? \"hide\" : \"show\"))]();\n                }\n            }, $.fn.tooltip = function(b) {\n                return this.each(function() {\n                    var c = $(this), d = c.data(\"tooltip\"), e = ((((typeof b == \"object\")) && b));\n                    ((d || c.data(\"tooltip\", d = new a(this, e)))), ((((typeof b == \"string\")) && d[b]()));\n                });\n            }, $.fn.tooltip.Constructor = a, $.fn.tooltip.defaults = {\n                animation: !0,\n                delay: 0,\n                selector: !1,\n                placement: \"JSBNG__top\",\n                trigger: \"hover\",\n                title: \"\",\n                template: \"\\u003Cdiv class=\\\"tooltip\\\"\\u003E\\u003Cdiv class=\\\"tooltip-arrow\\\"\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"tooltip-inner\\\"\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\"\n            };\n        }(window.jQuery);\n    });\n    define(\"app/ui/tooltips\", [\"module\",\"require\",\"exports\",\"core/component\",\"$lib/bootstrap_tooltip.js\",], function(module, require, exports) {\n        function tooltips() {\n            this.defaultAttrs({\n                tooltipSelector: \".js-tooltip\"\n            }), this.hide = function() {\n                this.select(\"tooltipSelector\").tooltip(\"hide\");\n            }, this.after(\"initialize\", function() {\n                this.$node.tooltip({\n                    selector: this.attr.tooltipSelector\n                }), this.JSBNG__on(JSBNG__document, \"uiBeforePageChanged uiShowProfilePopup\", this.hide);\n            });\n        };\n    ;\n        var defineComponent = require(\"core/component\");\n        require(\"$lib/bootstrap_tooltip.js\"), module.exports = defineComponent(tooltips);\n    });\n    define(\"app/data/ttft_navigation\", [\"module\",\"require\",\"exports\",\"core/component\",\"app/data/scribe_transport\",], function(module, require, exports) {\n        function ttftNavigate() {\n            this.beforeNewPageLoad = function(a, b) {\n                this.log(\"beforeNewPageLoad\", a, b), time = {\n                    beforeNewPageLoad: +(new JSBNG__Date),\n                    source: {\n                        page: this.attr.pageName,\n                        action: this.attr.sectionName,\n                        path: window.JSBNG__location.pathname\n                    }\n                };\n            }, this.afterPageChanged = function(a, b) {\n                this.log(\"afterPageChanged\", a, b), time.afterPageChanged = +(new JSBNG__Date), this.fromCache = !!b.fromCache, this.hookTimelineListener(!0), this.timelineListener = JSBNG__setTimeout(function() {\n                    this.hookTimelineListener(!1), this.report();\n                }.bind(this), 1), time.ajaxCount = this.ajaxCountdown = $.active, (($.active && this.hookAjaxListener(!0)));\n            }, this.timelineRefreshRequest = function(a, b) {\n                JSBNG__clearTimeout(this.timelineListener), this.hookTimelineListener(!1), ((b.navigated && (this.listeningForTimeline = !0, this.hookTimelineResults(!0))));\n            }, this.timelineSuccess = function(a, b) {\n                this.log(\"timelineSuccess\", a, b), this.listeningForTimeline = !1, this.hookTimelineResults(!1), time.timelineSuccess = +(new JSBNG__Date), this.report();\n            }, this.timelineError = function(a, b) {\n                this.log(\"timelineError\", a, b), this.listeningForTimeline = !1, this.hookTimelineResults(!1), this.report();\n            }, this.ajaxComplete = function(a, b) {\n                ((--this.ajaxCountdown || (this.log(\"ajaxComplete\", a, b), this.hookAjaxListener(!1), time.ajaxComplete = +(new JSBNG__Date), this.report())));\n            }, this.report = function() {\n                if (((this.ajaxCountdown && time.ajaxCount))) {\n                    return;\n                }\n            ;\n            ;\n                if (((this.listeningForTimeline && !time.timelineSuccess))) {\n                    return;\n                }\n            ;\n            ;\n                var a = {\n                    event_name: \"route_time\",\n                    source_page: time.source.page,\n                    source_action: time.source.action,\n                    source_path: time.source.path,\n                    dest_page: this.attr.pageName,\n                    dest_action: this.attr.sectionName,\n                    dest_path: window.JSBNG__location.pathname,\n                    cached: this.fromCache,\n                    start_time: time.beforeNewPageLoad,\n                    stream_switch_time: time.afterPageChanged,\n                    stream_complete_time: ((time.timelineSuccess || time.afterPageChanged)),\n                    ajax_count: time.ajaxCount\n                };\n                ((time.ajaxCount && (a.ajax_complete_time = time.ajaxComplete))), this.scribeTransport.send(a, \"route_timing\"), this.log(a);\n            }, this.log = function() {\n            \n            }, this.time = function() {\n                return time;\n            }, this.scribeTransport = scribeTransport, this.hookAjaxListener = function(a) {\n                this[((a ? \"JSBNG__on\" : \"off\"))](\"ajaxComplete\", this.ajaxComplete);\n            }, this.hookTimelineListener = function(a) {\n                this[((a ? \"JSBNG__on\" : \"off\"))](\"uiTimelineShouldRefresh\", this.timelineRefreshRequest);\n            }, this.hookTimelineResults = function(a) {\n                this[((a ? \"JSBNG__on\" : \"off\"))](\"dataGotMoreTimelineItems\", this.timelineSuccess), this[((a ? \"JSBNG__on\" : \"off\"))](\"dataGotMoreTimelineItemsError\", this.timelineError);\n            }, this.after(\"initialize\", function() {\n                this.JSBNG__on(\"uiBeforeNewPageLoad\", this.beforeNewPageLoad), this.JSBNG__on(\"uiPageChanged\", this.afterPageChanged);\n            });\n        };\n    ;\n        var component = require(\"core/component\"), scribeTransport = require(\"app/data/scribe_transport\");\n        module.exports = component(ttftNavigate);\n        var time = {\n        };\n    });\n    define(\"app/data/user_info\", [\"module\",\"require\",\"exports\",], function(module, require, exports) {\n        var user = {\n        }, userInfo = {\n            set: function(a) {\n                user.screenName = a.screenName, user.deciders = ((a.deciders || {\n                })), user.experiments = ((a.experiments || {\n                }));\n            },\n            reset: function() {\n                this.set({\n                    screenName: null,\n                    deciders: {\n                    },\n                    experiments: {\n                    }\n                });\n            },\n            user: user,\n            getDecider: function(a) {\n                return !!user.deciders[a];\n            },\n            getExperimentGroup: function(a) {\n                return user.experiments[a];\n            }\n        };\n        userInfo.reset(), module.exports = userInfo;\n    });\n    define(\"app/ui/aria_event_logger\", [\"module\",\"require\",\"exports\",\"core/component\",\"core/i18n\",], function(module, require, exports) {\n        function ariaEventLogger() {\n            this.MESSAGES = {\n                FAVORITED: _(\"Favorited\"),\n                UNFAVORITED: _(\"Unfavorited\"),\n                RETWEETED: _(\"Retweeted\"),\n                UNRETWEETED: _(\"Unretweeted\"),\n                EXPANDED: _(\"Expanded\"),\n                COLLAPSED: _(\"Collapsed\"),\n                RENDERING_CONVERSATION: _(\"Loading conversation.\"),\n                CONVERSATION_RENDERED: _(\"Conversation loaded. Press j or k to review Tweets.\"),\n                CONVERSATION_START: _(\"Conversation start.\"),\n                CONVERSATION_END: _(\"Conversation end.\"),\n                NEW_ITEMS_BAR_VISIBLE: _(\"New Tweets available. Press period to review them.\")\n            }, this.CLEAR_LOG_EVENTS = [\"uiPageChanged\",\"uiShortcutSelectPrev\",\"uiShortcutSelectNext\",\"uiSelectNext\",\"uiSelectItem\",\"uiShortcutGotoTopOfScreen\",\"uiSelectTopTweet\",].join(\" \"), this.createLog = function() {\n                var a = $(\"\\u003Cdiv id=\\\"sr-event-log\\\" class=\\\"visuallyhidden\\\" aria-live=\\\"assertive\\\"\\u003E\\u003C/div\\u003E\");\n                $(\"body\").append(a), this.$log = a;\n            }, this.logMessage = function(a, b) {\n                ((this.$log && (((b || (b = \"assertive\"))), ((((b != this.$log.attr(\"aria-live\"))) && this.$log.attr(\"aria-live\", b))), this.$log.append(((((\"\\u003Cp\\u003E\" + a)) + \"\\u003C/p\\u003E\"))), ((((this.$log.children().length > 3)) && this.$log.children().first().remove())))));\n            }, this.logEvent = function(a, b) {\n                return function() {\n                    this.logMessage(this.MESSAGES[a], b);\n                }.bind(this);\n            }, this.logConversationStart = function(a) {\n                var b = $(a.target);\n                ((((((b.closest(\".expanded-conversation\").length && !b.prev().length)) && b.next().length)) && this.logMessage(this.MESSAGES.CONVERSATION_START, \"polite\")));\n            }, this.logConversationEnd = function(a) {\n                var b = $(a.target);\n                ((((((b.closest(\".expanded-conversation\").length && !b.next().length)) && b.prev().length)) && this.logMessage(this.MESSAGES.CONVERSATION_END, \"polite\")));\n            }, this.logCharCountWarning = function(a, b) {\n                this.clearLog(), this.logMessage(b.charCount, \"polite\");\n            }, this.clearLog = function() {\n                ((this.$log && this.$log.html(\"\")));\n            }, this.after(\"initialize\", function() {\n                this.JSBNG__on(JSBNG__document, \"uiSwiftLoaded\", this.createLog), this.JSBNG__on(JSBNG__document, \"uiDidFavoriteTweet dataFailedToUnfavoriteTweet\", this.logEvent(\"FAVORITED\")), this.JSBNG__on(JSBNG__document, \"uiDidUnfavoriteTweet dataFailedToFavoriteTweet\", this.logEvent(\"UNFAVORITED\")), this.JSBNG__on(JSBNG__document, \"uiDidRetweet dataFailedToUnretweet\", this.logEvent(\"RETWEETED\")), this.JSBNG__on(JSBNG__document, \"uiDidUnretweet dataFailedToRetweet\", this.logEvent(\"UNRETWEETED\")), this.JSBNG__on(JSBNG__document, \"uiHasExpandedTweet\", this.logEvent(\"EXPANDED\")), this.JSBNG__on(JSBNG__document, \"uiHasCollapsedTweet\", this.logEvent(\"COLLAPSED\")), this.JSBNG__on(JSBNG__document, \"uiRenderingExpandedConversation\", this.logEvent(\"RENDERING_CONVERSATION\", \"polite\")), this.JSBNG__on(JSBNG__document, \"uiExpandedConversationRendered\", this.logEvent(\"CONVERSATION_RENDERED\", \"polite\")), this.JSBNG__on(JSBNG__document, \"uiNextItemSelected\", this.logConversationEnd), this.JSBNG__on(JSBNG__document, \"uiPreviousItemSelected\", this.logConversationStart), this.JSBNG__on(JSBNG__document, \"uiNewItemsBarVisible\", this.logEvent(\"NEW_ITEMS_BAR_VISIBLE\")), this.JSBNG__on(JSBNG__document, \"uiCharCountWarningVisible\", this.logCharCountWarning), this.JSBNG__on(JSBNG__document, this.CLEAR_LOG_EVENTS, this.clearLog);\n            });\n        };\n    ;\n        var defineComponent = require(\"core/component\"), _ = require(\"core/i18n\"), ARIAEventLogger = defineComponent(ariaEventLogger);\n        module.exports = ARIAEventLogger;\n    });\n    define(\"app/boot/common\", [\"module\",\"require\",\"exports\",\"app/utils/auth_token\",\"app/boot/scribing\",\"app/ui/navigation\",\"app/data/navigation\",\"app/ui/language_dropdown\",\"app/ui/google\",\"app/ui/impression_cookies\",\"app/data/promoted_logger\",\"app/ui/message_drawer\",\"app/ui/tooltips\",\"app/data/ttft_navigation\",\"app/utils/cookie\",\"app/utils/querystring\",\"app/data/user_info\",\"app/ui/aria_event_logger\",], function(module, require, exports) {\n        function shimConsole(a) {\n            ((window.JSBNG__console || (window.JSBNG__console = {\n            }))), LOG_METHODS.forEach(function(b) {\n                if (((a || !JSBNG__console[b]))) {\n                    JSBNG__console[b] = NO_OP;\n                }\n            ;\n            ;\n            });\n        };\n    ;\n        function getLoginTime() {\n            return ((parseInt(querystring.decode(cookie(\"twll\")).l, 10) || 0));\n        };\n    ;\n        function verifySession() {\n            ((((getLoginTime() !== initialLoginTime)) && window.JSBNG__location.reload(!0)));\n        };\n    ;\n        var authToken = require(\"app/utils/auth_token\"), scribing = require(\"app/boot/scribing\"), NavigationUI = require(\"app/ui/navigation\"), NavigationData = require(\"app/data/navigation\"), LanguageDropdown = require(\"app/ui/language_dropdown\"), GoogleAnalytics = require(\"app/ui/google\"), ImpressionCookies = require(\"app/ui/impression_cookies\"), PromotedLogger = require(\"app/data/promoted_logger\"), MessageDrawer = require(\"app/ui/message_drawer\"), Tooltips = require(\"app/ui/tooltips\"), TTFTNavigation = require(\"app/data/ttft_navigation\"), cookie = require(\"app/utils/cookie\"), querystring = require(\"app/utils/querystring\"), userInfo = require(\"app/data/user_info\"), ARIAEventLogger = require(\"app/ui/aria_event_logger\"), ttftNavigationEnabled = !1, LOG_METHODS = [\"log\",\"warn\",\"debug\",\"info\",], NO_OP = function() {\n        \n        }, initialLoginTime = 0;\n        module.exports = function(b) {\n            var c = b.environment, d = (([\"production\",\"preflight\",].indexOf(c) > -1));\n            shimConsole(d), authToken.set(b.formAuthenticityToken), userInfo.set(b), ImpressionCookies.attachTo(JSBNG__document, {\n                noTeardown: !0\n            }), GoogleAnalytics.attachTo(JSBNG__document, {\n                noTeardown: !0\n            }), scribing(b), PromotedLogger.attachTo(JSBNG__document, {\n                noTeardown: !0\n            });\n            var e = ((!!window.JSBNG__history && !!JSBNG__history.pushState));\n            ((((b.pushState && e)) && NavigationUI.attachTo(JSBNG__document, {\n                viewContainer: b.viewContainer,\n                noTeardown: !0\n            }))), NavigationData.attachTo(JSBNG__document, {\n                init_data: b,\n                pushState: b.pushState,\n                pushStateSupported: e,\n                pushStatePageLimit: b.pushStatePageLimit,\n                assetsBasePath: b.assetsBasePath,\n                pushStateRequestHeaders: b.pushStateRequestHeaders,\n                viewContainer: b.viewContainer,\n                noTeardown: !0\n            }), Tooltips.attachTo(JSBNG__document, {\n                noTeardown: !0\n            }), MessageDrawer.attachTo(\"#message-drawer\", {\n                noTeardown: !0\n            }), ARIAEventLogger.attachTo(JSBNG__document, {\n                noTeardown: !0\n            }), ((b.loggedIn || LanguageDropdown.attachTo(\".js-language-dropdown\"))), ((((b.initialState && b.initialState.ttft_navigation)) && (ttftNavigationEnabled = !0))), ((ttftNavigationEnabled && TTFTNavigation.attachTo(JSBNG__document, {\n                pageName: b.pageName,\n                sectionName: b.sectionName\n            }))), ((b.loggedIn && (initialLoginTime = getLoginTime(), JSBNG__setInterval(verifySession, 10000))));\n        };\n    });\n    define(\"app/ui/with_position\", [\"module\",\"require\",\"exports\",], function(module, require, exports) {\n        function Position() {\n            this.adjacent = function(a, b, c) {\n                var d, e;\n                c = ((c || {\n                })), d = e = b.offset(), e.gravity = c.gravity, e.weight = c.weight;\n                var f = {\n                    height: b.JSBNG__outerHeight(),\n                    width: b.JSBNG__outerWidth()\n                }, g = {\n                    height: a.JSBNG__outerHeight(),\n                    width: a.JSBNG__outerWidth()\n                }, h = {\n                    height: $(window).height(),\n                    width: $(window).width()\n                }, i = {\n                    height: $(\"body\").height(),\n                    width: $(\"body\").width()\n                };\n                return ((e.gravity || (e.gravity = \"vertical\"))), ((((\"vertical,north,south\".indexOf(e.gravity) != -1)) && (((((\"right,left,center\".indexOf(e.weight) == -1)) && (e.weight = ((((d.left > ((h.width / 2)))) ? \"right\" : \"left\"))))), ((((e.gravity == \"vertical\")) && (e.gravity = ((((((d.JSBNG__top + g.height)) > (($(window).scrollTop() + h.height)))) ? \"south\" : \"north\"))))), ((((c.position == \"relative\")) && (d = {\n                    left: 0,\n                    JSBNG__top: 0\n                }, e.left = 0))), ((((e.weight == \"right\")) ? e.left = ((((d.left - g.width)) + f.width)) : ((((e.weight == \"center\")) && (e.left = ((d.left - ((((g.width - f.width)) / 2))))))))), e.JSBNG__top = ((((e.gravity == \"north\")) ? ((d.JSBNG__top + f.height)) : ((d.JSBNG__top - g.height))))))), ((((\"horizontal,east,west\".indexOf(e.gravity) != -1)) && (((((\"top,bottom,center\".indexOf(e.weight) == -1)) && ((((((d.JSBNG__top - ((g.height / 2)))) < 0)) ? e.weight = \"JSBNG__top\" : ((((((d.JSBNG__top + ((g.height / 2)))) > Math.max(h.height, i.height))) ? e.weight = \"bottom\" : e.weight = \"center\")))))), ((((e.gravity == \"horizontal\")) && (e.gravity = ((((((d.left + ((f.width / 2)))) > ((h.width / 2)))) ? \"east\" : \"west\"))))), ((((c.position == \"relative\")) && (d = {\n                    left: 0,\n                    JSBNG__top: 0\n                }, e.JSBNG__top = 0))), ((((e.weight == \"center\")) ? e.JSBNG__top = ((((d.JSBNG__top + ((f.height / 2)))) - ((g.height / 2)))) : ((((e.weight == \"bottom\")) && (e.JSBNG__top = ((((d.JSBNG__top - g.height)) + f.height))))))), e.left = ((((e.gravity == \"west\")) ? ((d.left + f.width)) : ((d.left - g.width))))))), e;\n            };\n        };\n    ;\n        module.exports = Position;\n    });\n    define(\"app/ui/with_scrollbar_width\", [\"module\",\"require\",\"exports\",], function(module, require, exports) {\n        function ScrollbarWidth() {\n            this.calculateScrollbarWidth = function() {\n                if ((($(\"#scrollbar-width\").length > 0))) {\n                    return;\n                }\n            ;\n            ;\n                var a = $(\"\\u003Cdiv class=\\\"modal-measure-scrollbar\\\"/\\u003E\").prependTo($(\"body\")), b = $(\"\\u003Cdiv class=\\\"inner\\\"/\\u003E\").appendTo(a), c = ((a.width() - b.width()));\n                a.remove(), $(\"head\").append(((((((((\"\\u003Cstyle id=\\\"scrollbar-width\\\"\\u003E        .compensate-for-scrollbar,        .modal-enabled,        .modal-enabled .global-nav-inner,        .profile-editing,        .profile-editing .global-nav-inner,        .gallery-enabled,        .grid-enabled,        .grid-enabled .global-nav-inner,        .gallery-enabled .global-nav-inner {          margin-right: \" + c)) + \"px      }         .grid-header {          right: \")) + c)) + \"px      }      \\u003C/style\\u003E\")));\n            };\n        };\n    ;\n        module.exports = ScrollbarWidth;\n    });\n    deferred(\"$lib/jquery.JSBNG__event.drag.js\", function() {\n        (function($) {\n            $.fn.drag = function(a, b, c) {\n                var d = ((((typeof a == \"string\")) ? a : \"\")), e = (($.isFunction(a) ? a : (($.isFunction(b) ? b : null))));\n                return ((((d.indexOf(\"drag\") !== 0)) && (d = ((\"drag\" + d))))), c = ((((((a == e)) ? b : c)) || {\n                })), ((e ? this.bind(d, c, e) : this.trigger(d)));\n            };\n            var a = $.JSBNG__event, b = a.special, c = b.drag = {\n                defaults: {\n                    which: 1,\n                    distance: 0,\n                    not: \":input\",\n                    handle: null,\n                    relative: !1,\n                    drop: !0,\n                    click: !1\n                },\n                datakey: \"dragdata\",\n                livekey: \"livedrag\",\n                add: function(b) {\n                    var d = $.data(this, c.datakey), e = ((b.data || {\n                    }));\n                    d.related += 1, ((((!d.live && b.selector)) && (d.live = !0, a.add(this, ((\"draginit.\" + c.livekey)), c.delegate)))), $.each(c.defaults, function(a, b) {\n                        ((((e[a] !== undefined)) && (d[a] = e[a])));\n                    });\n                },\n                remove: function() {\n                    $.data(this, c.datakey).related -= 1;\n                },\n                setup: function() {\n                    if ($.data(this, c.datakey)) {\n                        return;\n                    }\n                ;\n                ;\n                    var b = $.extend({\n                        related: 0\n                    }, c.defaults);\n                    $.data(this, c.datakey, b), a.add(this, \"mousedown\", c.init, b), ((this.JSBNG__attachEvent && this.JSBNG__attachEvent(\"JSBNG__ondragstart\", c.dontstart)));\n                },\n                teardown: function() {\n                    if ($.data(this, c.datakey).related) {\n                        return;\n                    }\n                ;\n                ;\n                    $.removeData(this, c.datakey), a.remove(this, \"mousedown\", c.init), a.remove(this, \"draginit\", c.delegate), c.textselect(!0), ((this.JSBNG__detachEvent && this.JSBNG__detachEvent(\"JSBNG__ondragstart\", c.dontstart)));\n                },\n                init: function(d) {\n                    var e = d.data, f;\n                    if (((((e.which > 0)) && ((d.which != e.which))))) {\n                        return;\n                    }\n                ;\n                ;\n                    if ($(d.target).is(e.not)) {\n                        return;\n                    }\n                ;\n                ;\n                    if (((e.handle && !$(d.target).closest(e.handle, d.currentTarget).length))) {\n                        return;\n                    }\n                ;\n                ;\n                    e.propagates = 1, e.interactions = [c.interaction(this, e),], e.target = d.target, e.pageX = d.pageX, e.pageY = d.pageY, e.dragging = null, f = c.hijack(d, \"draginit\", e);\n                    if (!e.propagates) {\n                        return;\n                    }\n                ;\n                ;\n                    return f = c.flatten(f), ((((f && f.length)) && (e.interactions = [], $.each(f, function() {\n                        e.interactions.push(c.interaction(this, e));\n                    })))), e.propagates = e.interactions.length, ((((((e.drop !== !1)) && b.drop)) && b.drop.handler(d, e))), c.textselect(!1), a.add(JSBNG__document, \"mousemove mouseup\", c.handler, e), !1;\n                },\n                interaction: function(a, b) {\n                    return {\n                        drag: a,\n                        callback: new c.callback,\n                        droppable: [],\n                        offset: (($(a)[((b.relative ? \"position\" : \"offset\"))]() || {\n                            JSBNG__top: 0,\n                            left: 0\n                        }))\n                    };\n                },\n                handler: function(d) {\n                    var e = d.data;\n                    switch (d.type) {\n                      case ((!e.dragging && \"mousemove\")):\n                        if (((((Math.pow(((d.pageX - e.pageX)), 2) + Math.pow(((d.pageY - e.pageY)), 2))) < Math.pow(e.distance, 2)))) {\n                            break;\n                        }\n                    ;\n                    ;\n                        d.target = e.target, c.hijack(d, \"dragstart\", e), ((e.propagates && (e.dragging = !0)));\n                      case \"mousemove\":\n                        if (e.dragging) {\n                            c.hijack(d, \"drag\", e);\n                            if (e.propagates) {\n                                ((((((e.drop !== !1)) && b.drop)) && b.drop.handler(d, e)));\n                                break;\n                            }\n                        ;\n                        ;\n                            d.type = \"mouseup\";\n                        }\n                    ;\n                    ;\n                    ;\n                      case \"mouseup\":\n                        a.remove(JSBNG__document, \"mousemove mouseup\", c.handler), ((e.dragging && (((((((e.drop !== !1)) && b.drop)) && b.drop.handler(d, e))), c.hijack(d, \"dragend\", e)))), c.textselect(!0), ((((((e.click === !1)) && e.dragging)) && ($.JSBNG__event.triggered = !0, JSBNG__setTimeout(function() {\n                            $.JSBNG__event.triggered = !1;\n                        }, 20), e.dragging = !1)));\n                    };\n                ;\n                },\n                delegate: function(b) {\n                    var d = [], e, f = (($.data(this, \"events\") || {\n                    }));\n                    return $.each(((f.live || [])), function(f, g) {\n                        if (((g.preType.indexOf(\"drag\") !== 0))) {\n                            return;\n                        }\n                    ;\n                    ;\n                        e = $(b.target).closest(g.selector, b.currentTarget)[0];\n                        if (!e) {\n                            return;\n                        }\n                    ;\n                    ;\n                        a.add(e, ((((g.origType + \".\")) + c.livekey)), g.origHandler, g.data), (((($.inArray(e, d) < 0)) && d.push(e)));\n                    }), ((d.length ? $(d).bind(((\"dragend.\" + c.livekey)), function() {\n                        a.remove(this, ((\".\" + c.livekey)));\n                    }) : !1));\n                },\n                hijack: function(b, d, e, f, g) {\n                    if (!e) {\n                        return;\n                    }\n                ;\n                ;\n                    var h = {\n                        JSBNG__event: b.originalEvent,\n                        type: b.type\n                    }, i = ((d.indexOf(\"drop\") ? \"drag\" : \"drop\")), j, k = ((f || 0)), l, m, n, o = ((isNaN(f) ? e.interactions.length : f));\n                    b.type = d, b.originalEvent = null, e.results = [];\n                    do if (l = e.interactions[k]) {\n                        if (((((d !== \"dragend\")) && l.cancelled))) {\n                            continue;\n                        }\n                    ;\n                    ;\n                        n = c.properties(b, e, l), l.results = [], $(((((g || l[i])) || e.droppable))).each(function(f, g) {\n                            n.target = g, j = ((g ? a.handle.call(g, b, n) : null)), ((((j === !1)) ? (((((i == \"drag\")) && (l.cancelled = !0, e.propagates -= 1))), ((((d == \"drop\")) && (l[i][f] = null)))) : ((((d == \"dropinit\")) && l.droppable.push(((c.element(j) || g))))))), ((((d == \"dragstart\")) && (l.proxy = $(((c.element(j) || l.drag)))[0]))), l.results.push(j), delete b.result;\n                            if (((d !== \"dropinit\"))) {\n                                return j;\n                            }\n                        ;\n                        ;\n                        }), e.results[k] = c.flatten(l.results), ((((d == \"dropinit\")) && (l.droppable = c.flatten(l.droppable)))), ((((((d == \"dragstart\")) && !l.cancelled)) && n.update()));\n                    }\n                     while (((++k < o)));\n                    return b.type = h.type, b.originalEvent = h.JSBNG__event, c.flatten(e.results);\n                },\n                properties: function(a, b, d) {\n                    var e = d.callback;\n                    return e.drag = d.drag, e.proxy = ((d.proxy || d.drag)), e.startX = b.pageX, e.startY = b.pageY, e.deltaX = ((a.pageX - b.pageX)), e.deltaY = ((a.pageY - b.pageY)), e.originalX = d.offset.left, e.originalY = d.offset.JSBNG__top, e.offsetX = ((a.pageX - ((b.pageX - e.originalX)))), e.offsetY = ((a.pageY - ((b.pageY - e.originalY)))), e.drop = c.flatten(((d.drop || [])).slice()), e.available = c.flatten(((d.droppable || [])).slice()), e;\n                },\n                element: function(a) {\n                    if (((a && ((a.jquery || ((a.nodeType == 1))))))) {\n                        return a;\n                    }\n                ;\n                ;\n                },\n                flatten: function(a) {\n                    return $.map(a, function(a) {\n                        return ((((a && a.jquery)) ? $.makeArray(a) : ((((a && a.length)) ? c.flatten(a) : a))));\n                    });\n                },\n                textselect: function(a) {\n                    $(JSBNG__document)[((a ? \"unbind\" : \"bind\"))](\"selectstart\", c.dontstart).attr(\"unselectable\", ((a ? \"off\" : \"JSBNG__on\"))).css(\"MozUserSelect\", ((a ? \"\" : \"none\")));\n                },\n                dontstart: function() {\n                    return !1;\n                },\n                callback: function() {\n                \n                }\n            };\n            c.callback.prototype = {\n                update: function() {\n                    ((((b.drop && this.available.length)) && $.each(this.available, function(a) {\n                        b.drop.locate(this, a);\n                    })));\n                }\n            }, b.draginit = b.dragstart = b.dragend = c;\n        })(jQuery);\n    });\n    define(\"app/ui/with_dialog\", [\"module\",\"require\",\"exports\",\"core/compose\",\"app/ui/with_scrollbar_width\",\"$lib/jquery.JSBNG__event.drag.js\",], function(module, require, exports) {\n        function withDialog() {\n            compose.mixin(this, [withScrollbarWidth,]), this.center = function(a) {\n                var b = $(window), c = {\n                    JSBNG__top: parseInt(((((b.height() - a.JSBNG__outerHeight())) / 2))),\n                    left: parseInt(((((b.width() - a.JSBNG__outerWidth())) / 2)))\n                };\n                return c;\n            }, this.windowHeight = function() {\n                return $(window).height();\n            }, this.scrollTop = function() {\n                return $(window).scrollTop();\n            }, this.position = function() {\n                var a = this.center(this.$dialog);\n                ((((this.attr.JSBNG__top != null)) && (a.JSBNG__top = this.attr.JSBNG__top))), ((((this.attr.left != null)) && (a.left = this.attr.left))), ((((this.attr.maxTop != null)) && (a.JSBNG__top = Math.min(a.JSBNG__top, this.attr.maxTop)))), ((((this.attr.maxLeft != null)) && (a.left = Math.min(a.left, this.attr.maxLeft)))), (((($(\"body\").attr(\"dir\") === \"rtl\")) ? this.$dialog.css({\n                    JSBNG__top: a.JSBNG__top,\n                    right: a.left\n                }) : this.$dialog.css({\n                    JSBNG__top: a.JSBNG__top,\n                    left: a.left\n                }))), ((((this.windowHeight() < this.$dialog.JSBNG__outerHeight())) ? (this.$dialog.css(\"position\", \"absolute\"), this.$dialog.css(\"JSBNG__top\", ((this.scrollTop() + \"px\")))) : ((((this.attr.fixed === !1)) && this.$dialog.css(\"JSBNG__top\", ((a.JSBNG__top + this.scrollTop())))))));\n            }, this.resize = function() {\n                ((this.attr.width && this.$dialog.css(\"width\", this.attr.width))), ((this.attr.height && this.$dialog.css(\"height\", this.attr.height)));\n            }, this.applyDraggability = function() {\n                if (!this.$dialog.hasClass(\"draggable\")) {\n                    return;\n                }\n            ;\n            ;\n                var a = this, b = {\n                    relative: !0,\n                    handle: \".modal-header\"\n                }, c = function(a, b) {\n                    (((($(\"body\").attr(\"dir\") === \"rtl\")) ? this.$dialog.css({\n                        JSBNG__top: b.offsetY,\n                        right: ((b.originalX - b.deltaX))\n                    }) : this.$dialog.css({\n                        JSBNG__top: b.offsetY,\n                        left: b.offsetX\n                    })));\n                };\n                this.$dialog.drag(\"start\", function() {\n                    a.$dialog.addClass(\"unselectable\"), $(\"#doc\").addClass(\"unselectable\");\n                }), this.$dialog.drag(\"end\", function() {\n                    a.$dialog.removeClass(\"unselectable\"), $(\"#doc\").removeClass(\"unselectable\");\n                }), this.$dialog.drag(c.bind(this), b);\n            }, this.setFocus = function() {\n                var a = this.$dialog.JSBNG__find(\".primary-btn\");\n                ((((a.length && a.is(\":not(:disabled)\"))) && a.JSBNG__focus()));\n            }, this.hasFocus = function() {\n                return (($.contains(this.node, JSBNG__document.activeElement) || ((this.node == JSBNG__document.activeElement))));\n            }, this.JSBNG__blur = function() {\n                ((this.hasFocus() && JSBNG__document.activeElement.JSBNG__blur()));\n            }, this.isOpen = function() {\n                if (((((window.DEBUG && window.DEBUG.enabled)) && ((this.openState !== this.$dialogContainer.is(\":visible\")))))) {\n                    throw new Error(\"Dialog markup and internal openState variable are out of sync.\");\n                }\n            ;\n            ;\n                return this.openState;\n            }, this.dialogVisible = function() {\n                this.trigger(\"uiDialogFadeInComplete\");\n            }, this.open = function() {\n                ((this.isOpen() || (this.openState = !0, this.$dialogContainer.fadeIn(\"fast\", this.dialogVisible.bind(this)), this.calculateScrollbarWidth(), $(\"body\").addClass(\"modal-enabled\"), this.resize(), this.position(), this.applyDraggability(), this.setFocus(), this.trigger(\"uiCloseDropdowns\"), this.trigger(\"uiDialogOpened\"))));\n            }, this.afterClose = function() {\n                (($(\".modal-container:visible\").length || $(\"body\").removeClass(\"modal-enabled\"))), this.openState = !1, this.trigger(\"uiDialogClosed\");\n            }, this.blurAndClose = function() {\n                this.JSBNG__blur(), this.$dialogContainer.fadeOut(\"fast\", this.afterClose.bind(this));\n            }, this.blurAndCloseImmediately = function() {\n                this.JSBNG__blur(), this.$dialogContainer.hide(), this.afterClose();\n            }, this.close = function() {\n                if (!this.isOpen()) {\n                    return;\n                }\n            ;\n            ;\n                this.trigger(this.node, {\n                    type: \"uiDialogCloseRequested\",\n                    defaultBehavior: \"blurAndClose\"\n                });\n            }, this.closeImmediately = function() {\n                ((this.isOpen() && this.blurAndCloseImmediately()));\n            }, this.triggerClicked = function(a) {\n                a.preventDefault(), this.open();\n            }, this.after(\"initialize\", function() {\n                this.openState = !1, this.$dialogContainer = ((this.$dialog || this.$node)), this.$dialog = this.$dialogContainer.JSBNG__find(\"div.modal\"), this.attr.closeSelector = ((this.attr.closeSelector || \".modal-close, .close-modal-background-target\")), this.JSBNG__on(this.select(\"closeSelector\"), \"click\", this.close), this.JSBNG__on(JSBNG__document, \"uiShortcutEsc uiCloseDialog\", this.close), this.JSBNG__on(JSBNG__document, \"uiBeforePageChanged\", this.closeImmediately), ((this.attr.triggerSelector && this.JSBNG__on(this.attr.triggerSelector, \"click\", this.triggerClicked)));\n            });\n        };\n    ;\n        var compose = require(\"core/compose\"), withScrollbarWidth = require(\"app/ui/with_scrollbar_width\");\n        require(\"$lib/jquery.JSBNG__event.drag.js\"), module.exports = withDialog;\n    });\n    define(\"app/ui/dialogs/signin_or_signup\", [\"module\",\"require\",\"exports\",\"core/component\",\"app/ui/with_position\",\"app/ui/with_dialog\",], function(module, require, exports) {\n        function signinOrSignupDialog() {\n            this.defaultAttrs({\n                dialogSelector: \"#signin-or-signup\",\n                signupOnlyScreenNameSelector: \".modal-title.signup-only span\"\n            }), this.openSigninDialog = function(a, b) {\n                ((b.signUpOnly ? (this.$node.addClass(\"signup-only-dialog\"), this.select(\"dialogSelector\").addClass(\"signup-only\").removeClass(\"not-signup-only\"), ((b.screenName && this.select(\"signupOnlyScreenNameSelector\").text(b.screenName)))) : (this.$node.removeClass(\"signup-only-dialog\"), this.select(\"dialogSelector\").addClass(\"not-signup-only\").removeClass(\"signup-only\")))), this.open(), this.trigger(\"uiSigninOrSignupDialogOpened\");\n            }, this.notifyClosed = function() {\n                this.trigger(\"uiSigninOrSignupDialogClosed\");\n            }, this.after(\"initialize\", function(a) {\n                this.$dialog = this.select(\"dialogSelector\"), this.$dialog.JSBNG__find(\"form.signup\").bind(\"submit\", function() {\n                    this.trigger(\"uiSignupButtonClicked\");\n                }.bind(this)), this.JSBNG__on(JSBNG__document, \"uiOpenSigninOrSignupDialog\", this.openSigninDialog), this.JSBNG__on(JSBNG__document, \"uiCloseSigninOrSignupDialog\", this.close), this.JSBNG__on(this.$node, \"uiDialogClosed\", this.notifyClosed);\n            });\n        };\n    ;\n        var defineComponent = require(\"core/component\"), withPosition = require(\"app/ui/with_position\"), withDialog = require(\"app/ui/with_dialog\"), SigninOrSignupDialog = defineComponent(signinOrSignupDialog, withDialog, withPosition);\n        module.exports = SigninOrSignupDialog;\n    });\n    define(\"app/ui/forms/input_with_placeholder\", [\"module\",\"require\",\"exports\",\"core/component\",], function(module, require, exports) {\n        function inputWithPlaceholder() {\n            this.defaultAttrs({\n                hidePlaceholderClassName: \"hasome\",\n                placeholder: \".holder\",\n                elementType: \"input\"\n            }), this.focusInput = function(a) {\n                this.$input.JSBNG__focus();\n            }, this.inputBlurred = function(a) {\n                if (((this.$input.val() == \"\"))) {\n                    return this.$node.removeClass(this.attr.hidePlaceholderClassName), !0;\n                }\n            ;\n            ;\n            }, this.checkForChange = function() {\n                ((this.inputBlurred() || this.inputChanged()));\n            }, this.inputChanged = function(a) {\n                this.$node.addClass(this.attr.hidePlaceholderClassName);\n            }, this.after(\"initialize\", function() {\n                this.$input = this.select(\"elementType\");\n                if (((this.$input.length != 1))) {\n                    throw new Error(\"InputWithPlaceholder must be attached to a container with exactly one input element inside of it\");\n                }\n            ;\n            ;\n                this.$placeholder = this.select(\"placeholder\");\n                if (((this.$placeholder.length != 1))) {\n                    throw new Error(\"InputWithPlaceholder must be attached to a container with exactly one placeholder element inside of it\");\n                }\n            ;\n            ;\n                this.JSBNG__on(this.$input, \"JSBNG__blur\", this.inputBlurred), this.JSBNG__on(this.$input, \"keydown paste\", this.inputChanged), this.JSBNG__on(this.$placeholder, \"click\", this.focusInput), this.JSBNG__on(this.$input, \"uiInputChanged\", this.checkForChange), this.checkForChange();\n            });\n        };\n    ;\n        var defineComponent = require(\"core/component\"), InputWithPlaceholder = defineComponent(inputWithPlaceholder);\n        module.exports = InputWithPlaceholder;\n    });\n    define(\"app/ui/signup_call_out\", [\"module\",\"require\",\"exports\",\"core/component\",], function(module, require, exports) {\n        function signupCallOut() {\n            this.after(\"initialize\", function() {\n                this.$node.bind(\"submit\", function() {\n                    this.trigger(\"uiSignupButtonClicked\");\n                }.bind(this));\n            });\n        };\n    ;\n        var defineComponent = require(\"core/component\"), SignupCallOut = defineComponent(signupCallOut);\n        module.exports = SignupCallOut;\n    });\n    define(\"app/data/signup_click_scribe\", [\"module\",\"require\",\"exports\",\"core/component\",\"app/data/with_scribe\",], function(module, require, exports) {\n        function loggedOutScribe() {\n            this.scribeSignupClick = function(a, b) {\n                this.scribe({\n                    action: \"signup_click\"\n                }, b);\n            }, this.scribeSigninOrSignupDialogOpened = function(a, b) {\n                this.scribe({\n                    action: \"open\"\n                }, b);\n            }, this.scribeSigninOrSignupDialogClosed = function(a, b) {\n                this.scribe({\n                    action: \"close\"\n                }, b);\n            }, this.after(\"initialize\", function() {\n                this.JSBNG__on(\"uiSignupButtonClicked\", this.scribeSignupClick), this.JSBNG__on(\"uiSigninOrSignupDialogOpened\", this.scribeSigninOrSignupDialogOpened), this.JSBNG__on(\"uiSigninOrSignupDialogClosed\", this.scribeSigninOrSignupDialogClosed);\n            });\n        };\n    ;\n        var defineComponent = require(\"core/component\"), withScribe = require(\"app/data/with_scribe\");\n        module.exports = defineComponent(loggedOutScribe, withScribe);\n    });\n    define(\"app/ui/signup/stream_end_signup_module\", [\"module\",\"require\",\"exports\",\"core/component\",], function(module, require, exports) {\n        function streamEndSignupModule() {\n            this.triggerSignupClick = function() {\n                this.trigger(\"uiSignupButtonClicked\");\n            }, this.after(\"initialize\", function() {\n                this.JSBNG__on(\"click\", this.triggerSignupClick);\n            });\n        };\n    ;\n        var defineComponent = require(\"core/component\");\n        module.exports = defineComponent(streamEndSignupModule);\n    });\n    define(\"app/boot/logged_out\", [\"module\",\"require\",\"exports\",\"app/ui/dialogs/signin_or_signup\",\"app/ui/forms/input_with_placeholder\",\"app/ui/signup_call_out\",\"app/data/signup_click_scribe\",\"app/ui/signup/stream_end_signup_module\",], function(module, require, exports) {\n        var SigninOrSignupDialog = require(\"app/ui/dialogs/signin_or_signup\"), InputWithPlaceholder = require(\"app/ui/forms/input_with_placeholder\"), SignupCallOut = require(\"app/ui/signup_call_out\"), LoggedOutScribe = require(\"app/data/signup_click_scribe\"), StreamEndSignupModule = require(\"app/ui/signup/stream_end_signup_module\");\n        module.exports = function(b) {\n            InputWithPlaceholder.attachTo(\"#signin-or-signup-dialog .holding, .profile-signup-call-out .holding, .search-signup-call-out .holding\"), SigninOrSignupDialog.attachTo(\"#signin-or-signup-dialog\", {\n                eventData: {\n                    scribeContext: {\n                        component: \"auth_dialog\",\n                        element: \"unauth_follow\"\n                    }\n                }\n            }), SignupCallOut.attachTo(\".signup-call-out form.signup\", {\n                eventData: {\n                    scribeContext: {\n                        component: \"signup_callout\",\n                        element: \"form\"\n                    }\n                }\n            }), StreamEndSignupModule.attachTo(\".stream-end .signup-btn\", {\n                eventData: {\n                    scribeContext: {\n                        component: \"stream_end\",\n                        element: \"signup_button\"\n                    }\n                }\n            }), LoggedOutScribe.attachTo(JSBNG__document);\n        };\n    });\n    define(\"app/utils/ttft\", [\"module\",\"require\",\"exports\",\"app/data/scribe_transport\",], function(module, require, exports) {\n        function scribeTTFTData(a, b) {\n            if (((((!recorded && window.JSBNG__performance)) && a))) {\n                recorded = !0;\n                var c = a;\n                c.did_load = b, c.web_timings = $.extend({\n                }, window.JSBNG__performance.timing), ((c.web_timings.toJSON && delete c.web_timings.toJSON)), c.navigation = {\n                    type: window.JSBNG__performance.navigation.type,\n                    redirectCount: window.JSBNG__performance.navigation.redirectCount\n                }, c.referrer = JSBNG__document.referrer, scribeTransport.send(c, \"swift_time_to_first_tweet\", !1), using(\"app/utils/params\", function(a) {\n                    if (a.fromQuery(window.JSBNG__location).show_ttft) {\n                        var b = c.web_timings;\n                        $(JSBNG__document).trigger(\"uiShowError\", {\n                            message: ((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((\"\\u003Ctable width=80%\\u003E\\u003Cthead\\u003E\\u003Cth\\u003Emilestone\\u003Cth\\u003Etime\\u003Cth\\u003Ecumulative\\u003C/thead\\u003E\\u003Ctbody\\u003E\\u003Ctr\\u003E\\u003Ctd\\u003Econnect:       \\u003Ctd\\u003E\" + ((b.connectEnd - b.navigationStart)))) + \"\\u003Ctd\\u003E\")) + ((b.connectEnd - b.navigationStart)))) + \"\\u003C/tr\\u003E\")) + \"\\u003Ctr\\u003E\\u003Ctd\\u003Eprocess:       \\u003Ctd\\u003E\")) + ((b.responseStart - b.connectEnd)))) + \"\\u003Ctd\\u003E\")) + ((b.responseStart - b.navigationStart)))) + \"\\u003C/tr\\u003E\")) + \"\\u003Ctr\\u003E\\u003Ctd\\u003Eresponse:      \\u003Ctd\\u003E\")) + ((b.responseEnd - b.responseStart)))) + \"\\u003Ctd\\u003E\")) + ((b.responseEnd - b.navigationStart)))) + \"\\u003C/tr\\u003E\")) + \"\\u003Ctr\\u003E\\u003Ctd\\u003Erender:        \\u003Ctd\\u003E\")) + ((c.client_record_time - b.responseEnd)))) + \"\\u003Ctd\\u003E\")) + ((c.client_record_time - b.navigationStart)))) + \"\\u003C/tr\\u003E\")) + \"\\u003Ctr\\u003E\\u003Ctd\\u003Einteractivity: \\u003Ctd\\u003E\")) + ((c.aq_empty_time - c.client_record_time)))) + \"\\u003Ctd\\u003E\")) + ((c.aq_empty_time - b.navigationStart)))) + \"\\u003C/tr\\u003E\")) + \"\\u003Ctr\\u003E\\u003Ctd\\u003Eajax_complete: \\u003Ctd\\u003E\")) + ((c.ajax_complete_time - c.aq_empty_time)))) + \"\\u003Ctd\\u003E\")) + ((c.ajax_complete_time - b.navigationStart)))) + \"\\u003C/tr\\u003E\")) + \"\\u003Ctr\\u003E\\u003Ctd\\u003Eajax_count:    \\u003Ctd\\u003E\")) + c.ajax_count)) + \"\\u003C/tr\\u003E\")) + \"\\u003C/tbody\\u003E\\u003C/table\\u003E\"))\n                        });\n                    }\n                ;\n                ;\n                });\n                try {\n                    delete window.ttft;\n                } catch (d) {\n                    window.ttft = undefined;\n                };\n            ;\n            }\n        ;\n        ;\n        };\n    ;\n        function scribeMilestones(a) {\n            if (!window.ttftData) {\n                return;\n            }\n        ;\n        ;\n            var b = !0;\n            for (var c = 0; ((c < requiredMilestones.length)); ++c) {\n                if (!((requiredMilestones[c] in window.ttftData))) {\n                    b = !1;\n                    break;\n                }\n            ;\n            ;\n            };\n        ;\n            ((((a || b)) && scribeTTFTData(window.ttftData, b)));\n        };\n    ;\n        function onAjaxComplete(a, b, c) {\n            if (((c && ((c.url in newAjaxRequests))))) {\n                for (var d = 0; ((d < newAjaxRequests[c.url].length)); d++) {\n                    if (((c === newAjaxRequests[c.url][d]))) {\n                        newAjaxRequests[c.url].splice(d, 1);\n                        return;\n                    }\n                ;\n                ;\n                };\n            }\n        ;\n        ;\n            pendingAjaxCount--;\n            if (((((pendingAjaxCount == 0)) || (($.active == 0))))) {\n                unbindAjaxHandlers(), recordPendingAjaxComplete();\n            }\n        ;\n        ;\n        };\n    ;\n        function onAjaxSend(a, b, c) {\n            ((((c && c.url)) && (((newAjaxRequests[c.url] || (newAjaxRequests[c.url] = []))), newAjaxRequests[c.url].push(c))));\n        };\n    ;\n        function recordPendingAjaxComplete() {\n            recordMilestone(\"ajax_complete_time\", (new JSBNG__Date).getTime());\n        };\n    ;\n        function bindAjaxHandlers() {\n            $(JSBNG__document).bind(\"ajaxComplete\", onAjaxComplete), $(JSBNG__document).bind(\"ajaxSend\", onAjaxSend);\n        };\n    ;\n        function unbindAjaxHandlers() {\n            $(JSBNG__document).unbind(\"ajaxComplete\", onAjaxComplete), $(JSBNG__document).unbind(\"ajaxSend\", onAjaxSend);\n        };\n    ;\n        function startAjaxTracking() {\n            startingAjaxCount = pendingAjaxCount = $.active, recordMilestone(\"ajax_count\", startingAjaxCount), ((((startingAjaxCount == 0)) ? recordPendingAjaxComplete() : (unbindAjaxHandlers(), bindAjaxHandlers())));\n        };\n    ;\n        function recordMilestone(a, b) {\n            ((((window.ttftData && !window.ttftData[a])) && (window.ttftData[a] = b))), scribeMilestones(!1);\n        };\n    ;\n        var scribeTransport = require(\"app/data/scribe_transport\"), recorded = !1, requiredMilestones = [\"page\",\"client_record_time\",\"aq_empty_time\",\"ajax_complete_time\",\"ajax_count\",], startingAjaxCount = 0, pendingAjaxCount = 0, newAjaxRequests = {\n        };\n        window.ttft = {\n            recordMilestone: recordMilestone\n        }, scribeMilestones(!1), JSBNG__setTimeout(function() {\n            scribeMilestones(!0);\n        }, 45000), module.exports = {\n            startAjaxTracking: startAjaxTracking\n        };\n    });\n    function makePromptSpanPage(a) {\n        ((a.length && a.prependTo(\"#page-container\").css({\n            padding: 0,\n            border: 0\n        })));\n    };\n;\n    using.path = $(\"#swift-module-path\").val();\n    makePromptSpanPage($(\"div[data-prompt-id=\\\"262\\\"]\"));\n    ((using.aliases && using.bundles.push(using.aliases)));\n    $(\".loadrunner-alias\").each(function(a, b) {\n        using.bundles.push(JSON.parse($(b).val()));\n    });\n    using(\"debug/debug\", function(a) {\n        function b() {\n            function d() {\n                c.forEach(function(a) {\n                    a(b);\n                });\n                var a = $(JSBNG__document);\n                a.JSBNG__on(\"uiSwiftLoaded uiPageChanged\", function() {\n                    window.__swift_loaded = !0;\n                });\n                a.JSBNG__on(\"uiBeforeNewPageLoad\", function() {\n                    window.__swift_loaded = !1;\n                });\n                $(\"html\").removeClass(b.baseFoucClass);\n                a.trigger(\"uiSwiftLoaded\");\n                ((window.swiftActionQueue && window.swiftActionQueue.flush($)));\n                if (window.ttftData) {\n                    ((window.ttft && window.ttft.recordMilestone(\"aq_empty_time\", (new JSBNG__Date).getTime())));\n                    using(\"app/utils/ttft\", function(a) {\n                        a.startAjaxTracking();\n                    });\n                }\n            ;\n            ;\n            };\n        ;\n            var a = $(\"#init-data\").val(), b = JSON.parse(a), c = $.makeArray(arguments);\n            ((b.moreCSSBundle ? using(((\"css!\" + b.moreCSSBundle)), d) : d()));\n        };\n    ;\n        if ($(\"html\").hasClass(\"debug\")) {\n            window.DEBUG = a;\n            a.enable(!0);\n        }\n         else a.enable(!1);\n    ;\n    ;\n        var c = $(\"input.swift-boot-module\").map(function(a, b) {\n            return $(b).val();\n        }).toArray();\n        using.apply(this, c.concat(b));\n    });\n} catch (JSBNG_ex) {\n\n};");
// 1375
fpc.call(JSBNG_Replay.s19277ddcd28db6dd01a1d67d562dfbbffa3c6a17_1[0], o0,o5);
// undefined
o5 = null;
// 1393
fpc.call(JSBNG_Replay.s19277ddcd28db6dd01a1d67d562dfbbffa3c6a17_1[0], o0,o4);
// undefined
o4 = null;
// 1410
fpc.call(JSBNG_Replay.s19277ddcd28db6dd01a1d67d562dfbbffa3c6a17_1[0], o0,o8);
// undefined
o8 = null;
// 1427
fpc.call(JSBNG_Replay.s19277ddcd28db6dd01a1d67d562dfbbffa3c6a17_1[0], o0,o9);
// undefined
o0 = null;
// undefined
o9 = null;
// 1443
JSBNG_Replay.s19277ddcd28db6dd01a1d67d562dfbbffa3c6a17_4[0]();
// 1487
o2["0"] = o3;
// undefined
o2 = null;
// undefined
o3 = null;
// 1448
geval("define(\"app/data/tweet_actions\", [\"module\",\"require\",\"exports\",\"core/component\",\"app/data/with_data\",], function(module, require, exports) {\n    function tweetActions() {\n        this.defaultAttrs({\n            successFromEndpoints: {\n                destroy: \"dataDidDeleteTweet\",\n                retweet: \"dataDidRetweet\",\n                favorite: \"dataDidFavoriteTweet\",\n                unretweet: \"dataDidUnretweet\",\n                unfavorite: \"dataDidUnfavoriteTweet\"\n            },\n            errorsFromEndpoints: {\n                destroy: \"dataFailedToDeleteTweet\",\n                retweet: \"dataFailedToRetweet\",\n                favorite: \"dataFailedToFavoriteTweet\",\n                unretweet: \"dataFailedToUnretweet\",\n                unfavorite: \"dataFailedToUnfavoriteTweet\"\n            }\n        }), this.takeAction = function(a, b, c) {\n            var d = function(b) {\n                ((((b && b.message)) && this.trigger(\"uiShowMessage\", {\n                    message: b.message\n                }))), this.trigger(this.attr.successFromEndpoints[a], b), this.trigger(JSBNG__document, \"dataGotProfileStats\", {\n                    stats: b.profile_stats\n                });\n            }, e;\n            ((((((((a === \"favorite\")) || ((a === \"retweet\")))) && ((\"retweetId\" in c)))) ? e = {\n                id: c.retweetId\n            } : e = {\n                id: c.id\n            })), ((c.impressionId && (e.impression_id = c.impressionId, ((c.disclosureType && (e.earned = ((c.disclosureType == \"earned\"))))))));\n            var f = {\n                destroy: \"DELETE\",\n                unretweet: \"DELETE\"\n            };\n            this.JSONRequest({\n                url: ((\"/i/tweet/\" + a)),\n                data: e,\n                eventData: c,\n                success: d.bind(this),\n                error: this.attr.errorsFromEndpoints[a]\n            }, ((f[a] || \"POST\")));\n        }, this.hitEndpoint = function(a) {\n            return this.takeAction.bind(this, a);\n        }, this.getTweet = function(a, b) {\n            var c = {\n                id: b.id\n            };\n            this.get({\n                url: \"/i/tweet/html\",\n                data: c,\n                eventData: b,\n                success: \"dataGotTweet\",\n                error: $.noop\n            });\n        }, this.after(\"initialize\", function() {\n            this.JSBNG__on(\"uiDidRetweet\", this.hitEndpoint(\"retweet\")), this.JSBNG__on(\"uiDidUnretweet\", this.hitEndpoint(\"unretweet\")), this.JSBNG__on(\"uiDidDeleteTweet\", this.hitEndpoint(\"destroy\")), this.JSBNG__on(\"uiDidFavoriteTweet\", this.hitEndpoint(\"favorite\")), this.JSBNG__on(\"uiDidUnfavoriteTweet\", this.hitEndpoint(\"unfavorite\")), this.JSBNG__on(\"uiGetTweet\", this.getTweet);\n        });\n    };\n;\n    var defineComponent = require(\"core/component\"), withData = require(\"app/data/with_data\"), TweetActions = defineComponent(tweetActions, withData);\n    module.exports = TweetActions;\n});\ndefine(\"app/ui/expando/with_expanding_containers\", [\"module\",\"require\",\"exports\",], function(module, require, exports) {\n    function withExpandingContainers() {\n        this.MARGIN_ANIMATION_SPEED = 85, this.DETACHED_MARGIN = 8, this.defaultAttrs({\n            openClass: \"open\",\n            openSelector: \".open\",\n            afterExpandedClass: \"after-expanded\",\n            beforeExpandedClass: \"before-expanded\",\n            marginBreaking: !0\n        }), this.flipClassState = function(a, b, c) {\n            a.filter(((\".\" + b))).removeClass(b).addClass(c);\n        }, this.fixMarginForAdjacentItem = function(a) {\n            $(a.target).next().filter(this.attr.openSelector).css(\"margin-top\", this.DETACHED_MARGIN).prev().addClass(this.attr.beforeExpandedClass);\n        }, this.enterDetachedState = function(a, b) {\n            var c = a.prev(), d = a.next();\n            a.addClass(this.attr.openClass), ((this.attr.marginBreaking && a.animate({\n                marginTop: ((c.length ? this.DETACHED_MARGIN : 0)),\n                marginBottom: ((d.length ? this.DETACHED_MARGIN : 0))\n            }, {\n                duration: ((b ? 0 : this.MARGIN_ANIMATION_SPEED))\n            }))), c.addClass(this.attr.beforeExpandedClass), d.addClass(this.attr.afterExpandedClass);\n        }, this.exitDetachedState = function(a, b) {\n            var c = function() {\n                a.prev().removeClass(this.attr.beforeExpandedClass).end().next().removeClass(this.attr.afterExpandedClass);\n            }.bind(this);\n            a.removeClass(this.attr.openClass), ((this.attr.marginBreaking ? a.animate({\n                marginTop: 0,\n                marginBottom: 0\n            }, {\n                duration: ((b ? 0 : this.MARGIN_ANIMATION_SPEED)),\n                complete: c\n            }) : c()));\n        }, this.after(\"initialize\", function() {\n            this.JSBNG__on(\"uiHasInjectedTimelineItem uiShouldFixMargins\", this.fixMarginForAdjacentItem);\n        });\n    };\n;\n    module.exports = withExpandingContainers;\n});\ndefine(\"app/ui/expando/expando_helpers\", [\"module\",\"require\",\"exports\",], function(module, require, exports) {\n    var SPEED_COEFFICIENT = 105, expandoHelpers = {\n        buildExpandoStruct: function(a) {\n            var b = a.$tweet, c = b.hasClass(a.originalClass), d = a.preexpanded, e = ((c ? b.closest(a.containingSelector) : b)), f = ((c ? e.get(0) : b.closest(\"li\").get(0))), g = b.closest(a.expansionSelector, f).get(0), h = ((g ? $(g) : $())), i = {\n                $tweet: b,\n                $container: e,\n                $scaffold: h,\n                $ancestors: $(),\n                $descendants: $(),\n                auto_expanded: b.hasClass(\"auto-expanded\"),\n                isTopLevel: c,\n                originalHeight: null,\n                animating: !1,\n                preexpanded: d,\n                skipAnimation: a.skipAnimation,\n                open: ((b.hasClass(a.openedTweetClass) && !d))\n            };\n            return i;\n        },\n        guessGoodSpeed: function() {\n            var a = Math.max.apply(Math, arguments);\n            return Math.round(((((4045 * Math.log(a))) * SPEED_COEFFICIENT)));\n        },\n        getNaturalHeight: function(a) {\n            var b = a.height(), c = a.height(\"auto\").height();\n            return a.height(b), c;\n        },\n        closeAllButPreserveScroll: function(a) {\n            var b = a.$scope.JSBNG__find(a.openSelector);\n            if (!b.length) {\n                return !1;\n            }\n        ;\n        ;\n            var c = $(window).scrollTop(), d = expandoHelpers.firstVisibleItemBelow(a.$scope, a.itemSelector, c);\n            if (((!d || !d.length))) {\n                return !1;\n            }\n        ;\n        ;\n            var e = d.offset().JSBNG__top;\n            b.each(a.callback);\n            var f = d.offset().JSBNG__top, g = ((e - f));\n            return $(window).scrollTop(((c - g))), g;\n        },\n        firstVisibleItemBelow: function(a, b, c) {\n            var d;\n            return a.JSBNG__find(b).each(function() {\n                var a = $(this);\n                if (((a.offset().JSBNG__top >= c))) {\n                    return d = a, !1;\n                }\n            ;\n            ;\n            }), d;\n        }\n    };\n    module.exports = expandoHelpers;\n});\ndefine(\"app/ui/gallery/with_gallery\", [\"module\",\"require\",\"exports\",], function(module, require, exports) {\n    module.exports = function() {\n        this.defaultAttrs({\n            mediaThumbnailSelector: \".media-thumbnail\",\n            previewClass: \"is-preview\"\n        }), this.expandPreview = function(a) {\n            var b = a.closest(this.attr.mediaThumbnailSelector);\n            if (b.hasClass(this.attr.previewClass)) {\n                var c = a.parents(\".tweet.with-media-preview:not(.opened-tweet)\");\n                if (c.length) {\n                    return this.trigger(c, \"uiExpandTweet\"), !0;\n                }\n            ;\n            ;\n            }\n        ;\n        ;\n            return !1;\n        }, this.openMediaGallery = function(a) {\n            a.preventDefault(), a.stopPropagation();\n            var b = $(a.target);\n            ((this.expandPreview(b) || this.trigger(a.target, \"uiOpenGallery\", {\n                title: \"Photo\"\n            }))), this.trigger(\"uiMediaThumbnailClick\", {\n                url: b.attr(\"data-url\"),\n                mediaType: ((b.hasClass(\"video\") ? \"video\" : \"photo\"))\n            });\n        }, this.after(\"initialize\", function(a) {\n            ((((a.permalinkCardsGallery || a.timelineCardsGallery)) && this.JSBNG__on(\"click\", {\n                mediaThumbnailSelector: this.openMediaGallery\n            })));\n        });\n    };\n});\ndefine(\"app/ui/with_tweet_translation\", [\"module\",\"require\",\"exports\",\"core/compose\",\"app/utils/tweet_helper\",\"app/ui/with_interaction_data\",\"app/utils/rtl_text\",\"core/i18n\",], function(module, require, exports) {\n    function withTweetTranslation() {\n        compose.mixin(this, [withInteractionData,]), this.defaultAttrs({\n            tweetSelector: \"div.tweet\",\n            tweetTranslationSelector: \".tweet-translation\",\n            tweetTranslationTextSelector: \".tweet-translation-text\",\n            translateTweetSelector: \".js-translate-tweet\",\n            translateLabelSelector: \".translate-label\",\n            permalinkContainerSelector: \".permalink-tweet-container\",\n            permalinkClass: \"permalink-tweet-container\"\n        }), this.handleTranslateTweetClick = function(a, b) {\n            var c, d;\n            c = $(a.target).closest(this.attr.tweetSelector);\n            if (((((a.type === \"uiTimelineNeedsTranslation\")) && c.closest(this.attr.permalinkContainerSelector).length))) {\n                return;\n            }\n        ;\n        ;\n            ((c.JSBNG__find(this.attr.tweetTranslationSelector).is(\":hidden\") && (d = this.interactionData(c), d.dest = JSBNG__document.documentElement.getAttribute(\"lang\"), this.trigger(c, \"uiNeedsTweetTranslation\", d))));\n        }, this.showTweetTranslation = function(a, b) {\n            var c;\n            ((b.item_html && (c = this.findTweetTranslation(b.id_str), c.JSBNG__find(this.attr.tweetTranslationTextSelector).html(b.item_html), c.show(), ((this.$node.hasClass(this.attr.permalinkClass) && this.$node.JSBNG__find(this.attr.translateTweetSelector).hide())))));\n        }, this.findTweetTranslation = function(a) {\n            var b = this.$node.JSBNG__find(((((((this.attr.tweetSelector + \"[data-tweet-id=\")) + a.replace(/\\D/g, \"\"))) + \"]\")));\n            return b.JSBNG__find(this.attr.tweetTranslationSelector);\n        }, this.showError = function(a, b) {\n            this.trigger(\"uiShowMessage\", {\n                message: _(\"Unable to translate this Tweet. Please try again later.\")\n            });\n        }, this.after(\"initialize\", function(a) {\n            this.JSBNG__on(JSBNG__document, \"dataTweetTranslationSuccess\", this.showTweetTranslation), this.JSBNG__on(JSBNG__document, \"dataTweetTranslationError\", this.showError), this.JSBNG__on(JSBNG__document, \"uiTimelineNeedsTranslation\", this.handleTranslateTweetClick), this.JSBNG__on(\"click\", {\n                translateTweetSelector: this.handleTranslateTweetClick\n            });\n        });\n    };\n;\n    var compose = require(\"core/compose\"), tweetHelper = require(\"app/utils/tweet_helper\"), withInteractionData = require(\"app/ui/with_interaction_data\"), RTLText = require(\"app/utils/rtl_text\"), _ = require(\"core/i18n\");\n    module.exports = withTweetTranslation;\n});\ndefine(\"app/ui/tweets\", [\"module\",\"require\",\"exports\",\"core/component\",\"app/ui/with_tweet_actions\",\"app/ui/with_user_actions\",\"app/ui/gallery/with_gallery\",\"app/ui/with_item_actions\",\"app/ui/with_tweet_translation\",], function(module, require, exports) {\n    var defineComponent = require(\"core/component\"), withTweetActions = require(\"app/ui/with_tweet_actions\"), withUserActions = require(\"app/ui/with_user_actions\"), withGallery = require(\"app/ui/gallery/with_gallery\"), withItemActions = require(\"app/ui/with_item_actions\"), withTweetTranslation = require(\"app/ui/with_tweet_translation\");\n    module.exports = defineComponent(withUserActions, withTweetActions, withGallery, withItemActions, withTweetTranslation);\n});\ndefine(\"app/ui/tweet_injector\", [\"module\",\"require\",\"exports\",\"core/component\",], function(module, require, exports) {\n    function tweetInjector() {\n        this.defaultAttrs({\n            descendantClass: \"descendant\",\n            descendantScribeContext: \"replies\",\n            tweetSelector: \".tweet\"\n        }), this.insertTweet = function(a, b) {\n            var c = this.$node.closest(\".permalink\");\n            ((c.length && (c.addClass(\"has-replies\"), this.$node.closest(\".replies-to\").removeClass(\"hidden\"))));\n            var d = $(b.tweet_html);\n            d.JSBNG__find(this.attr.tweetSelector).addClass(this.attr.descendantClass).attr(\"data-component-context\", this.attr.descendantScribeContext);\n            var e;\n            ((this.attr.guard(b) && (e = this.$node.JSBNG__find(\".view-more-container\"), ((e.length ? d.insertBefore(e.closest(\"li\")) : this.$node.append(d))), this.trigger(\"uiTweetInserted\", b))));\n        }, this.after(\"initialize\", function() {\n            this.JSBNG__on(JSBNG__document, \"dataTweetSuccess\", this.insertTweet);\n        });\n    };\n;\n    var defineComponent = require(\"core/component\");\n    module.exports = defineComponent(tweetInjector);\n});\ndefine(\"app/ui/expando/with_expanding_social_activity\", [\"module\",\"require\",\"exports\",\"app/ui/expando/expando_helpers\",\"core/i18n\",\"app/utils/tweet_helper\",\"app/ui/tweets\",\"app/ui/tweet_injector\",], function(module, require, exports) {\n    function withExpandingSocialActivity() {\n        this.defaultAttrs({\n            animating: \"animating\",\n            socialProofSelector: \".js-tweet-stats-container\",\n            requestRetweetedSelector: \".request-retweeted-popup\",\n            requestFavoritedSelector: \".request-favorited-popup\",\n            targetTweetSelector: \".tweet\",\n            targetTitleSelector: \"[data-activity-popup-title]\",\n            inlineReplyTweetBoxFormSelector: \".inline-reply-tweetbox .tweet-form\",\n            inlineReplyTweetBoxFormCloneSrcSelector: \"#inline-reply-tweetbox .tweet-form\",\n            inlineReplyTweetboxSelector: \".inline-reply-tweetbox\",\n            inlineReplyUserImageSelector: \".inline-reply-user-image\",\n            permalinkTweetClasses: \"opened-tweet permalink-tweet\",\n            parentStreamItemSelector: \".stream-item\",\n            viewMoreContainerSelector: \".view-more-container\",\n            ancestorsSelector: \".ancestor-items\\u003Eli\",\n            descendantsSelector: \".tweets-wrapper\\u003Eli\"\n        }), this.calculateMargins = function(a) {\n            var b, c, d = 0, e = 0;\n            ((a.$ancestors.length && (c = a.$ancestors.first(), d = Math.abs(parseInt(c.css(\"marginTop\"), 10)), ((d || (d = ((a.$tweet.offset().JSBNG__top - c.offset().JSBNG__top))))))));\n            var f, g, h;\n            return ((a.$descendants.length && (f = a.$descendants.last(), e = Math.abs(parseInt(f.css(\"marginBottom\"), 10)), ((e || (b = a.$tweet.JSBNG__outerHeight(), g = f.JSBNG__outerHeight(), h = f.offset().JSBNG__top, e = ((((h + g)) - ((b + a.$tweet.offset().JSBNG__top)))))))))), {\n                JSBNG__top: d,\n                bottom: e\n            };\n        }, this.animateScaffoldHeight = function(a) {\n            var b = a.expando, c = a.marginTop, d = a.marginBottom, e = b.$ancestors.length, f = b.$descendants.length, g;\n            ((((a.noAnimation || ((!b.open && !b.animating)))) ? g = 0 : ((((e || f)) ? g = a.speed : g = expandoHelpers.guessGoodSpeed(Math.abs(((b.$scaffold.height() - a.height))))))));\n            var h = 1;\n            ((e && h++)), ((f && h++));\n            var i = function() {\n                h--, ((((h == 0)) && (b.animating = !1, ((e && b.$ancestors.first().css(\"marginTop\", \"\"))), ((f && b.$descendants.last().css(\"marginBottom\", \"\"))), ((a.complete && a.complete())))));\n            }.bind(this);\n            b.$scaffold.animate({\n                height: a.height\n            }, {\n                duration: g,\n                complete: i\n            }), ((e && b.$ancestors.first().animate({\n                marginTop: c\n            }, {\n                duration: g,\n                step: a.stepFn,\n                complete: i\n            }))), ((f && b.$descendants.last().animate({\n                marginBottom: d\n            }, {\n                duration: g,\n                complete: i\n            })));\n        }, this.animateTweetOpen = function(a) {\n            var b = a.expando, c = expandoHelpers.getNaturalHeight(b.$scaffold), d = this.calculateMargins(b), e = a.complete;\n            b.animating = !0, ((b.$ancestors.length && b.$ancestors.first().css(\"margin-top\", -d.JSBNG__top))), ((b.$descendants.length && b.$descendants.last().css(\"margin-bottom\", -d.bottom))), this.animateScaffoldHeight({\n                expando: b,\n                height: c,\n                noAnimation: a.noAnimation,\n                speed: expandoHelpers.guessGoodSpeed(d.JSBNG__top, d.bottom),\n                marginTop: 0,\n                marginBottom: 0,\n                complete: function() {\n                    b.$scaffold.height(\"auto\"), ((e && e()));\n                }.bind(this)\n            });\n        }, this.animateTweetClosed = function(a) {\n            var b = a.expando, c = this.calculateMargins(b), d = a.complete;\n            b.animating = !0, this.animateScaffoldHeight({\n                expando: b,\n                height: b.originalHeight,\n                noAnimation: a.noAnimation,\n                speed: expandoHelpers.guessGoodSpeed(c.JSBNG__top, c.bottom),\n                stepFn: a.stepFn,\n                marginTop: -c.JSBNG__top,\n                marginBottom: -c.bottom,\n                complete: function() {\n                    b.$scaffold.height(b.originalHeight), b.$container.css({\n                        \"margin-top\": \"\",\n                        \"margin-bottom\": \"\"\n                    }), ((d && d()));\n                }\n            });\n        }, this.initTweetsInConversation = function(a) {\n            ((((a.$container.closest(this.attr.parentStreamItemSelector).length && a.$scaffold.JSBNG__find(this.attr.inlineReplyTweetboxSelector).length)) && (Tweets.attachTo(a.$scaffold, {\n                screenName: this.attr.screenName,\n                loggedIn: this.attr.loggedIn,\n                itemType: a.$container.attr(\"data-item-type\")\n            }), ((this.attr.loggedIn && TweetInjector.attachTo(a.$scaffold, {\n                guard: function(b) {\n                    return ((b.in_reply_to_status_id == a.$tweet.attr(\"data-tweet-id\")));\n                }\n            }))))));\n        }, this.animateConversationEntrance = function(a, b) {\n            var c = $(a.target).data(\"expando\"), d = $(a.target).attr(\"focus-reply\");\n            $(a.target).removeAttr(\"focus-reply\"), ((c.$tweet.data(\"is-reply-to\") || (b.ancestors = \"\"))), c.$scaffold.height(c.$scaffold.JSBNG__outerHeight());\n            var e = $(b.ancestors), f = $(b.descendants);\n            c.$ancestors = e.JSBNG__find(this.attr.ancestorsSelector), c.$descendants = f.JSBNG__find(this.attr.descendantsSelector);\n            var g = ((c.$ancestors.length || c.$descendants.length));\n            ((g && this.trigger(c.$tweet, \"uiRenderingExpandedConversation\"))), c.$tweet.after(f.JSBNG__find(this.attr.inlineReplyTweetboxSelector)), c.$scaffold.prepend(c.$ancestors), c.$scaffold.append(c.$descendants);\n            var h = f.JSBNG__find(this.attr.viewMoreContainerSelector), i;\n            ((h.length && (i = $(\"\\u003Cli/\\u003E\"), h.appendTo(i), c.$scaffold.append(i), c.$descendants = c.$descendants.add(i))));\n            var j = this.renderInlineTweetbox(c, b.sourceEventData);\n            this.animateTweetOpen({\n                expando: c,\n                complete: function() {\n                    c.open = !0, c.$scaffold.removeClass(this.attr.animating), c.$scaffold.css(\"height\", \"auto\"), this.trigger(c.$tweet, \"uiTimelineNeedsTranslation\"), ((((d && j)) && this.trigger(j, \"uiExpandFocus\")));\n                }.bind(this)\n            }), this.initTweetsInConversation(c), ((g && this.trigger(c.$tweet, \"uiExpandedConversationRendered\")));\n        }, this.renderConversation = function(a, b) {\n            var c = $(a.target).data(\"expando\");\n            if (!c) {\n                return;\n            }\n        ;\n        ;\n            ((c.animating ? c.$scaffold.queue(function() {\n                this.animateConversationEntrance(a, b), c.$scaffold.dequeue();\n            }.bind(this)) : this.animateConversationEntrance(a, b)));\n        }, this.renderInlineTweetbox = function(a, b) {\n            var c, d = a.$scaffold.JSBNG__find(this.attr.inlineReplyTweetBoxFormSelector);\n            ((((d.length === 0)) && (d = $(this.attr.inlineReplyTweetBoxFormCloneSrcSelector).clone(), c = ((\"tweet-box-reply-to-\" + a.$tweet.attr(\"data-tweet-id\"))), d.JSBNG__find(\"textarea\").attr(\"id\", c), d.JSBNG__find(\"label\").attr(\"for\", c), a.$scaffold.JSBNG__find(this.attr.inlineReplyTweetboxSelector).empty(), d.appendTo(a.$scaffold.JSBNG__find(this.attr.inlineReplyTweetboxSelector)))));\n            var e = tweetHelper.extractMentionsForReply(a.$tweet, this.attr.screenName), f = ((((\"@\" + e.join(\" @\"))) + \" \"));\n            b = ((b || {\n            }));\n            var g = {\n                condensable: !0,\n                defaultText: f,\n                condensedText: _(\"Reply to {{screen_names}}\", {\n                    screen_names: f\n                }),\n                inReplyToTweetData: b,\n                inReplyToStatusId: a.$tweet.attr(\"data-tweet-id\"),\n                impressionId: a.$tweet.attr(\"data-impression-id\"),\n                disclosureType: a.$tweet.attr(\"data-disclosure-type\"),\n                eventData: {\n                    scribeContext: {\n                        component: \"tweet_box_inline_reply\"\n                    }\n                }\n            };\n            return ((b.itemType && (g.itemType = b.itemType))), this.trigger(d, \"uiInitTweetbox\", g), d;\n        }, this.renderEmptyConversation = function(a, b) {\n            this.renderConversation(a);\n        }, this.requestActivityPopup = function(a) {\n            var b = $(a.target), c = b.closest(this.attr.targetTweetSelector), d = !!b.closest(this.attr.requestRetweetedSelector).length;\n            a.preventDefault(), a.stopPropagation(), this.trigger(\"uiRequestActivityPopup\", {\n                titleHtml: b.closest(this.attr.targetTitleSelector).attr(\"data-activity-popup-title\"),\n                tweetHtml: $(\"\\u003Cdiv\\u003E\").html(c.clone().removeClass(this.attr.permalinkTweetClasses)).html(),\n                isRetweeted: d\n            });\n        }, this.renderSocialProof = function(a, b) {\n            var c = $(a.target).JSBNG__find(this.attr.socialProofSelector);\n            ((c.JSBNG__find(\".stats\").length || c.append(b.social_proof))), $(a.target).trigger(\"uiHasRenderedTweetSocialProof\");\n        }, this.after(\"initialize\", function() {\n            this.JSBNG__on(JSBNG__document, \"dataTweetConversationResult\", this.renderConversation), this.JSBNG__on(JSBNG__document, \"dataTweetSocialProofResult\", this.renderSocialProof), this.JSBNG__on(\"click\", {\n                requestRetweetedSelector: this.requestActivityPopup,\n                requestFavoritedSelector: this.requestActivityPopup\n            });\n        });\n    };\n;\n    var expandoHelpers = require(\"app/ui/expando/expando_helpers\"), _ = require(\"core/i18n\"), tweetHelper = require(\"app/utils/tweet_helper\"), Tweets = require(\"app/ui/tweets\"), TweetInjector = require(\"app/ui/tweet_injector\");\n    module.exports = withExpandingSocialActivity;\n});\ndefine(\"app/ui/expando/expanding_tweets\", [\"module\",\"require\",\"exports\",\"core/component\",\"core/utils\",\"app/ui/expando/with_expanding_containers\",\"app/ui/expando/with_expanding_social_activity\",\"app/ui/expando/expando_helpers\",\"app/utils/caret\",], function(module, require, exports) {\n    function expandingTweets() {\n        this.defaultAttrs({\n            playerCardIframeSelector: \".cards-base.cards-multimedia iframe, .card2 iframe\",\n            insideProxyTweet: \".proxy-tweet-container *\",\n            expandingTweetSelector: \".js-stream-tweet\",\n            topLevelTweetSelector: \".js-stream-tweet.original-tweet\",\n            tweetSelector: \".tweet\",\n            detailsSelector: \".js-tweet-details-dropdown\",\n            expansionSelector: \".expansion-container\",\n            expandedContentSelector: \".expanded-content\",\n            expansionClasses: \"expansion-container js-expansion-container animating\",\n            openedTweetClass: \"opened-tweet\",\n            originalTweetClass: \"original-tweet\",\n            withSocialProofClass: \"with-social-proof\",\n            expandoHandleSelector: \".js-open-close-tweet span\",\n            containingItemSelector: \".js-stream-item\",\n            preexpandedOpenTweetSelector: \"li.js-preexpanded div.opened-tweet\",\n            preexpandedTweetClass: \"preexpanded\",\n            expandedIframeDataStash: \"data-expando-iframe-media-url\",\n            jsLinkSelector: \".js-link\",\n            tweetFormSelector: \".tweet-form\",\n            withheldTweetClass: \"withheld-tweet\",\n            jsDetailsSelector: \".js-details\",\n            jsStreamItemSelector: \".js-stream-item\",\n            jsTranslateTweetSelector: \".js-translate-tweet\",\n            openedOriginalTweetSelector: \".js-original-tweet.opened-tweet\",\n            expandedConversationSelector: \".expanded-conversation\",\n            expandedConversationClass: \"expanded-conversation\",\n            inlineReplyTweetBoxSelector: \".inline-reply-tweetbox\",\n            openChildrenSelector: \".ancestor.opened-tweet,.descendant.opened-tweet\",\n            enableAnimation: !0,\n            SCROLL_TOP_OFFSET: 55,\n            MAX_PLAYER_WIDTH_IN_PIXELS: 435,\n            hasConversationModuleClass: \"has-conversation-module\",\n            conversationModuleSelector: \".conversation-module\",\n            conversationRootClass: \"conversation-root\",\n            hadConversationClass: \"had-conversation\",\n            animatingClass: \"animating\"\n        }), this.handleTweetClick = function(a, b) {\n            var c = $(b.el);\n            ((this.shouldExpandWhenTargetIs($(a.target), c) && (a.preventDefault(), ((this.handleConversationExpansion(c) || this.expandTweet(c))))));\n        }, this.handleConversationExpansion = function(a) {\n            if (a.hasClass(this.attr.conversationRootClass)) {\n                return a.trigger(\"uiExpandConversationRoot\"), !0;\n            }\n        ;\n        ;\n            if (a.closest(this.attr.containingItemSelector).hasClass(this.attr.hadConversationClass)) {\n                return a.trigger(\"uiRestoreConversationModule\"), !0;\n            }\n        ;\n        ;\n        }, this.shouldExpandWhenTargetIs = function(a, b) {\n            var c = b.hasClass(this.attr.withheldTweetClass), d = a.is(this.attr.expandoHandleSelector), e = ((a.closest(this.attr.jsDetailsSelector, b).length > 0)), f = ((a.closest(this.attr.jsTranslateTweetSelector, b).length > 0)), g = ((((!a.closest(\"a\", b).length && !a.closest(\"button\", b).length)) && !a.closest(this.attr.jsLinkSelector, b).length));\n            return ((((((((((d || g)) || e)) || f)) && !c)) && !this.selectedText()));\n        }, this.selectedText = function() {\n            return caret.JSBNG__getSelection();\n        }, this.resetCard = function(a, b) {\n            b = ((((b || a.data(\"expando\"))) || this.loadTweet(a)));\n            if (b.auto_expanded) {\n                return;\n            }\n        ;\n        ;\n            var c = this;\n            a.JSBNG__find(this.attr.playerCardIframeSelector).each(function(a, b) {\n                b.setAttribute(c.attr.expandedIframeDataStash, b.src), b.src = \"\";\n            });\n        }, this.expandItem = function(a, b) {\n            this.expandTweet($(a.target).JSBNG__find(this.attr.tweetSelector).eq(0), b);\n        }, this.expandTweetByReply = function(a, b) {\n            var c = $(a.target);\n            c.attr(\"focus-reply\", !0), b.focusReply = !0, this.expandTweet(c, b);\n        }, this.focusReplyTweetbox = function(a) {\n            var b = a.parent().JSBNG__find(this.attr.tweetFormSelector);\n            ((((b.length > 0)) && this.trigger(b, \"uiExpandFocus\")));\n        }, this.expandTweet = function(a, b) {\n            b = ((b || {\n            }));\n            var c = ((a.data(\"expando\") || this.loadTweet(a, b)));\n            if (c.open) {\n                if (b.focusReply) {\n                    this.focusReplyTweetbox(a);\n                    return;\n                }\n            ;\n            ;\n                this.closeTweet(a, c, b);\n            }\n             else this.openTweet(a, c, b);\n        ;\n        ;\n        }, this.collapseTweet = function(a, b) {\n            (($(b).hasClass(this.attr.openedTweetClass) && this.expandTweet($(b), {\n                noAnimation: !0\n            })));\n        }, this.loadTweet = function(a, b) {\n            b = ((b || {\n            }));\n            var c = ((b.expando || expandoHelpers.buildExpandoStruct({\n                $tweet: a,\n                preexpanded: b.preexpanded,\n                openedTweetClass: this.attr.openedTweetClass,\n                expansionSelector: this.attr.expansionSelector,\n                originalClass: this.attr.originalTweetClass,\n                containingSelector: this.attr.containingItemSelector\n            })));\n            a.data(\"expando\", c);\n            var d;\n            this.setOriginalHeight(a, c);\n            if (((((((!c.$descendants.length || !c.$ancestors.length)) || c.preexpanded)) || c.auto_expanded))) {\n                this.scaffoldForAnimation(a, c), delete b.focusReply, this.loadHtmlFragmentsFromAttributes(a, c, b), this.resizePlayerCards(a);\n            }\n        ;\n        ;\n            return c;\n        }, this.setOriginalHeight = function(a, b) {\n            a.removeClass(this.attr.openedTweetClass), b.originalHeight = a.JSBNG__outerHeight(), a.addClass(this.attr.openedTweetClass);\n        }, this.resizePlayerCard = function(a, b) {\n            var c = $(b), d = parseFloat(c.attr(\"width\"));\n            if (((d > this.attr.MAX_PLAYER_WIDTH_IN_PIXELS))) {\n                var e = parseFloat(c.attr(\"height\")), f = ((d / e)), g = ((this.attr.MAX_PLAYER_WIDTH_IN_PIXELS / f));\n                c.attr(\"width\", this.attr.MAX_PLAYER_WIDTH_IN_PIXELS), c.attr(\"height\", Math.floor(g));\n            }\n        ;\n        ;\n        }, this.resizePlayerCards = function(a) {\n            var b = a.JSBNG__find(this.attr.playerCardIframeSelector);\n            b.each(this.resizePlayerCard.bind(this));\n        }, this.loadPreexpandedTweet = function(a, b) {\n            var c = $(b), d = this.loadTweet(c, {\n                preexpanded: !0\n            });\n            this.openTweet(c, d, {\n                skipAnimation: !0\n            });\n            var e = $.trim(c.JSBNG__find(this.attr.expandedContentSelector).html());\n            ((e && c.attr(\"data-expanded-footer\", e))), this.JSBNG__on(b, \"uiHasAddedLegacyMediaIcon\", function() {\n                this.setOriginalHeight(c, d), this.trigger(b, \"uiWantsMediaForTweet\", {\n                });\n            });\n        }, this.createStepFn = function(a) {\n            var b = $(window), c = Math.abs(((a.from - a.to))), d = Math.min(a.from, a.to), e = a.expando.$container.offset().JSBNG__top, f = b.scrollTop(), g = ((((f + this.attr.SCROLL_TOP_OFFSET)) - e)), h = function(a) {\n                var e = ((a - d)), h = ((e / c));\n                ((((g > 0)) && b.scrollTop(((f - ((g * ((1 - h)))))))));\n            };\n            return h;\n        }, this.openTweet = function(a, b, c) {\n            ((b.isTopLevel && this.enterDetachedState(b.$container, c.skipAnimation))), this.beforeOpeningTweet(b);\n            if (((!this.attr.enableAnimation || c.skipAnimation))) {\n                return this.afterOpeningTweet(b);\n            }\n        ;\n        ;\n            this.trigger(a, \"uiHasExpandedTweet\", {\n                organicExpansion: !c.focusReply,\n                impressionId: a.closest(\"[data-impression-id]\").attr(\"data-impression-id\"),\n                disclosureType: a.closest(\"[data-impression-id]\").attr(\"data-disclosure-type\")\n            });\n            var d = {\n                expando: b\n            };\n            ((a.hasClass(this.attr.originalTweetClass) || (d.complete = function() {\n                this.afterOpeningTweet(b);\n            }.bind(this)))), this.animateTweetOpen(d);\n        }, this.beforeOpeningTweet = function(a) {\n            if (a.$tweet.is(this.attr.insideProxyTweet)) {\n                return;\n            }\n        ;\n        ;\n            ((a.auto_expanded || a.$tweet.JSBNG__find(((((\"iframe[\" + this.attr.expandedIframeDataStash)) + \"]\"))).each(function(a, b) {\n                var c = b.getAttribute(this.attr.expandedIframeDataStash);\n                ((!c || (b.src = c)));\n            }.bind(this)))), a.$tweet.addClass(this.attr.openedTweetClass);\n        }, this.afterOpeningTweet = function(a) {\n            if (a.$tweet.is(this.attr.insideProxyTweet)) {\n                return;\n            }\n        ;\n        ;\n            a.open = !0, a.$scaffold.removeClass(this.attr.animatingClass), a.$scaffold.css(\"height\", \"auto\"), a.$container.removeClass(this.attr.preexpandedTweetClass), this.trigger(a.$tweet, \"uiTimelineNeedsTranslation\");\n        }, this.removeExpando = function(a, b) {\n            var c = a.JSBNG__find(this.attr.jsDetailsSelector).is(JSBNG__document.activeElement), d, e;\n            ((((a.closest(\".supplement\").length || !b.isTopLevel)) ? d = b.$scaffold.parent() : d = a.closest(this.attr.jsStreamItemSelector))), ((a.hasClass(this.attr.hasConversationModuleClass) ? (e = a.closest(this.attr.conversationModuleSelector), e.JSBNG__find(\".descendant\").closest(\"li\").remove(), e.JSBNG__find(\".view-more-container\").closest(\"li\").remove(), e.JSBNG__find(this.attr.inlineReplyTweetBoxSelector).remove(), b.$scaffold.css(\"height\", \"auto\"), a.data(\"expando\", null)) : (e = a, d.html(e)))), d.removeClass(\"js-has-navigable-stream\"), ((c && d.JSBNG__find(this.attr.jsDetailsSelector).JSBNG__focus())), this.trigger(d, \"uiSelectItem\", {\n                setFocus: !c\n            });\n        }, this.closeTweet = function(a, b, c) {\n            ((b.isTopLevel && this.exitDetachedState(b.$container, c.noAnimation)));\n            var d = function() {\n                this.resetCard(a, b), b.open = !1, a.removeClass(this.attr.openedTweetClass), b.$scaffold.removeClass(this.attr.animatingClass), this.removeExpando(a, b), this.trigger(a, \"uiHasCollapsedTweet\");\n            }.bind(this), e = this.createStepFn({\n                expando: b,\n                to: b.originalHeight,\n                from: b.$scaffold.height()\n            });\n            b.$scaffold.addClass(this.attr.animatingClass), this.animateTweetClosed({\n                expando: b,\n                complete: d,\n                stepFn: e,\n                noAnimation: c.noAnimation\n            });\n        }, this.hasConversationModule = function(a) {\n            return a.hasClass(this.attr.hasConversationModuleClass);\n        }, this.shouldLoadFullConversation = function(a, b) {\n            return ((((b.isTopLevel && !b.preexpanded)) && !this.hasConversationModule(a)));\n        }, this.loadHtmlFragmentsFromAttributes = function(a, b, c) {\n            ((a.JSBNG__find(this.attr.detailsSelector).children().length || (a.JSBNG__find(this.attr.detailsSelector).append($(a.data(\"expanded-footer\"))), this.trigger(a, \"uiWantsMediaForTweet\"))));\n            var d = utils.merge(c, {\n                fullConversation: this.shouldLoadFullConversation(a, b),\n                descendantsOnly: this.hasConversationModule(a),\n                facepileMax: ((b.isTopLevel ? 7 : 6))\n            });\n            ((((b.isTopLevel && b.preexpanded)) && a.attr(\"data-use-reply-dialog\", \"true\"))), delete d.expando, this.trigger(a, \"uiNeedsTweetExpandedContent\", d);\n        }, this.scaffoldForAnimation = function(a, b) {\n            if (!this.attr.enableAnimation) {\n                return;\n            }\n        ;\n        ;\n            var c = a.JSBNG__find(this.attr.jsDetailsSelector).is(JSBNG__document.activeElement), d;\n            ((c && (d = JSBNG__document.activeElement)));\n            var e, f, g, h = {\n                class: this.attr.expansionClasses,\n                height: b.originalHeight\n            };\n            ((a.closest(this.attr.topLevelTweetSelector).length ? ((a.closest(this.attr.conversationModuleSelector).length ? (e = a.closest(this.attr.conversationModuleSelector), e.addClass(this.attr.expansionClasses), e.height(e.JSBNG__outerHeight()), b.originalHeight = e.JSBNG__outerHeight()) : (h[\"class\"] = [this.attr.expandedConversationClass,this.attr.expansionClasses,\"js-navigable-stream\",].join(\" \"), e = $(\"\\u003Col/\\u003E\", h), e.appendTo(a.parent()), f = $(\"\\u003Cli class=\\\"original-tweet-container\\\"/\\u003E\"), f.appendTo(e), b.$container.addClass(\"js-has-navigable-stream\"), a.appendTo(f), this.trigger(e.JSBNG__find(\".original-tweet-container\"), \"uiSelectItem\", {\n                setFocus: !c\n            })))) : (e = $(\"\\u003Cdiv/\\u003E\", h), e.appendTo(a.parent()), a.appendTo(e), g = e.parent().JSBNG__find(this.attr.inlineReplyTweetBoxSelector), ((g.length && g.appendTo(e)))))), ((d && d.JSBNG__focus())), b.$scaffold = e;\n        }, this.indicateSocialProof = function(a, b) {\n            var c = $(a.target);\n            ((b.social_proof && c.addClass(this.attr.withSocialProofClass)));\n        }, this.closeAllChildTweets = function(a) {\n            a.$scaffold.JSBNG__find(this.attr.openChildrenSelector).each(this.collapseTweet.bind(this));\n        }, this.closeAllTopLevelTweets = function() {\n            expandoHelpers.closeAllButPreserveScroll({\n                $scope: this.$node,\n                openSelector: this.attr.openedOriginalTweetSelector,\n                itemSelector: this.attr.jsStreamItemSelector,\n                callback: this.collapseTweet.bind(this)\n            });\n        }, this.fullyLoadPreexpandedTweets = function() {\n            this.select(\"preexpandedOpenTweetSelector\").each(this.loadPreexpandedTweet.bind(this));\n        }, this.after(\"initialize\", function(a) {\n            this.JSBNG__on(\"dataTweetSocialProofResult\", this.indicateSocialProof), this.JSBNG__on(\"uiShouldToggleExpandedState\", this.expandItem), this.JSBNG__on(\"uiPromotionCardUrlClick\", this.expandItem), this.JSBNG__on(\"click uiExpandTweet\", {\n                expandingTweetSelector: this.handleTweetClick\n            }), this.JSBNG__on(\"expandTweetByReply\", this.expandTweetByReply), this.JSBNG__on(\"uiWantsToCloseAllTweets\", this.closeAllTopLevelTweets), this.JSBNG__on(JSBNG__document, \"uiSwiftLoaded uiPageChanged uiHasInjectedNewTimeline\", this.fullyLoadPreexpandedTweets), this.before(\"teardown\", this.closeAllTopLevelTweets);\n        });\n    };\n;\n    var defineComponent = require(\"core/component\"), utils = require(\"core/utils\"), withExpandingContainers = require(\"app/ui/expando/with_expanding_containers\"), withExpandingSocialActivity = require(\"app/ui/expando/with_expanding_social_activity\"), expandoHelpers = require(\"app/ui/expando/expando_helpers\"), caret = require(\"app/utils/caret\");\n    module.exports = defineComponent(expandingTweets, withExpandingContainers, withExpandingSocialActivity);\n});\ndefine(\"app/ui/embed_stats\", [\"module\",\"require\",\"exports\",\"app/ui/with_item_actions\",\"core/component\",], function(module, require, exports) {\n    function embedStats() {\n        this.defaultAttrs({\n            permalinkSelector: \".permalink-tweet\",\n            embeddedLinkSelector: \".embed-stats-url-link\",\n            moreButtonSelector: \".embed-stats-more-button\",\n            moreStatsContainerSelector: \".embed-stats-more\",\n            itemType: \"user\"\n        }), this.expandMoreResults = function(a) {\n            this.select(\"moreButtonSelector\").hide(), this.select(\"moreStatsContainerSelector\").show(), this.trigger(\"uiExpandedMoreEmbeddedTweetLinks\", {\n                tweetId: this.tweetId\n            }), a.preventDefault();\n        }, this.clickLink = function(a) {\n            this.trigger(\"uiClickedEmbeddedTweetLink\", {\n                tweetId: this.tweetId,\n                url: (($(a.target).data(\"expanded-url\") || a.target.href))\n            });\n        }, this.after(\"initialize\", function() {\n            this.tweetId = this.select(\"permalinkSelector\").data(\"tweet-id\"), this.JSBNG__on(\"click\", {\n                embeddedLinkSelector: this.clickLink,\n                moreButtonSelector: this.expandMoreResults\n            });\n        });\n    };\n;\n    var withItemActions = require(\"app/ui/with_item_actions\"), defineComponent = require(\"core/component\");\n    module.exports = defineComponent(embedStats, withItemActions);\n});\ndefine(\"app/data/url_resolver\", [\"module\",\"require\",\"exports\",\"core/component\",\"app/data/with_data\",], function(module, require, exports) {\n    function urlResolver() {\n        this.resolveLink = function(a, b) {\n            JSBNG__clearTimeout(this.batch);\n            var c = this.linksToResolve[b.url];\n            c = ((c || [])), c.push(a.target), this.linksToResolve[b.url] = c, this.batch = JSBNG__setTimeout(this.sendBatchRequest.bind(this), 0);\n        }, this.sendBatchRequest = function() {\n            var a = Object.keys(this.linksToResolve);\n            if (((a.length === 0))) {\n                return;\n            }\n        ;\n        ;\n            this.get({\n                data: {\n                    urls: a\n                },\n                eventData: {\n                },\n                url: \"/i/resolve.json\",\n                headers: {\n                    \"X-PHX\": !0\n                },\n                type: \"JSON\",\n                success: this.handleBatch.bind(this),\n                error: \"dataBatchRequestError\"\n            });\n        }, this.handleBatch = function(a) {\n            delete a.sourceEventData, Object.keys(a).forEach(function(b) {\n                ((this.linksToResolve[b] && this.linksToResolve[b].forEach(function(c) {\n                    this.trigger(c, \"dataDidResolveUrl\", {\n                        url: a[b]\n                    });\n                }, this))), delete this.linksToResolve[b];\n            }, this);\n        }, this.after(\"initialize\", function() {\n            this.linksToResolve = {\n            }, this.JSBNG__on(\"uiWantsLinkResolution\", this.resolveLink);\n        });\n    };\n;\n    var defineComponent = require(\"core/component\"), withData = require(\"app/data/with_data\"), UrlResolver = defineComponent(urlResolver, withData);\n    module.exports = UrlResolver;\n});\ndefine(\"app/ui/media/with_native_media\", [\"module\",\"require\",\"exports\",], function(module, require, exports) {\n    function withNativeMedia() {\n        this.defaultAttrs({\n            expandedContentHolderWithPreloadableMedia: \"div[data-expanded-footer].has-preloadable-media\"\n        }), this.preloadEmbeddedMedia = function(a) {\n            $(a.target).JSBNG__find(this.attr.expandedContentHolderWithPreloadableMedia).each(function(a, b) {\n                $(\"\\u003Cdiv/\\u003E\").append($(b).data(\"expanded-footer\")).remove();\n            });\n        }, this.after(\"initialize\", function() {\n            this.preloadEmbeddedMedia({\n                target: this.$node\n            }), this.JSBNG__on(\"uiHasInjectedTimelineItem\", this.preloadEmbeddedMedia);\n        });\n    };\n;\n    module.exports = withNativeMedia;\n});\nprovide(\"app/ui/media/media_tweets\", function(a) {\n    using(\"core/component\", \"app/ui/media/with_legacy_media\", \"app/ui/media/with_native_media\", function(b, c, d) {\n        var e = b(c, d);\n        a(e);\n    });\n});\ndefine(\"app/data/trends\", [\"module\",\"require\",\"exports\",\"core/component\",\"app/utils/setup_polling_with_backoff\",\"app/data/with_data\",], function(module, require, exports) {\n    function trendsData() {\n        this.defaultAttrs({\n            src: \"module\",\n            $backoffNode: $(window),\n            trendsPollingOptions: {\n                focusedInterval: 300000,\n                blurredInterval: 1200000,\n                eventData: {\n                    source: \"clock\"\n                }\n            }\n        }), this.makeTrendsRequest = function(a) {\n            var b = a.woeid, c = a.source, d = function(a) {\n                a.source = c, this.trigger(\"dataTrendsRefreshed\", a);\n            };\n            this.get({\n                url: \"/trends\",\n                eventData: a,\n                data: {\n                    k: this.currentCacheKey,\n                    woeid: b,\n                    pc: !0,\n                    personalized: a.personalized,\n                    src: this.attr.src\n                },\n                success: d.bind(this),\n                error: \"dataTrendsRefreshedError\"\n            });\n        }, this.makeTrendsDialogRequest = function(a, b) {\n            var c = {\n                woeid: a.woeid,\n                personalized: a.personalized,\n                pc: !0\n            }, d = function(a) {\n                this.trigger(\"dataGotTrendsDialog\", a), ((((this.currentWoeid && ((this.currentWoeid !== a.woeid)))) && this.trigger(\"dataTrendsLocationChanged\"))), this.currentWoeid = a.woeid, ((a.trends_cache_key && (this.currentCacheKey = a.trends_cache_key, this.trigger(\"dataPageMutated\")))), ((a.module_html && this.trigger(\"dataTrendsRefreshed\", a)));\n            }, e = ((b ? this.post : this.get));\n            e.call(this, {\n                url: \"/trends/dialog\",\n                eventData: a,\n                data: c,\n                success: d.bind(this),\n                error: \"dataGotTrendsDialogError\"\n            });\n        }, this.changeTrendsLocation = function(a, b) {\n            this.makeTrendsDialogRequest(b, !0);\n        }, this.refreshTrends = function(a, b) {\n            b = ((b || {\n            })), this.makeTrendsRequest(b);\n        }, this.getTrendsDialog = function(a, b) {\n            b = ((b || {\n            })), this.makeTrendsDialogRequest(b);\n        }, this.updateTrendsCacheKey = function(a, b) {\n            this.currentCacheKey = b.trendsCacheKey;\n        }, this.after(\"initialize\", function(a) {\n            this.currentCacheKey = a.trendsCacheKey, this.timer = setupPollingWithBackoff(\"uiRefreshTrends\", this.attr.$backoffNode, this.attr.trendsPollingOptions), this.JSBNG__on(\"uiWantsTrendsDialog\", this.getTrendsDialog), this.JSBNG__on(\"uiChangeTrendsLocation\", this.changeTrendsLocation), this.JSBNG__on(\"uiRefreshTrends\", this.refreshTrends), this.JSBNG__on(\"dataTempTrendsCacheKeyChanged\", this.updateTrendsCacheKey);\n        });\n    };\n;\n    var defineComponent = require(\"core/component\"), setupPollingWithBackoff = require(\"app/utils/setup_polling_with_backoff\"), withData = require(\"app/data/with_data\");\n    module.exports = defineComponent(trendsData, withData);\n});\ndefine(\"app/data/trends/location_dialog\", [\"module\",\"require\",\"exports\",\"core/component\",\"app/data/with_data\",], function(module, require, exports) {\n    function trendsLocationDialogData() {\n        this.getTrendsLocationDialog = function(a, b) {\n            var c = function(a) {\n                this.trigger(\"dataGotTrendsLocationDialog\", a), ((a.trendLocations && this.trigger(\"dataLoadedTrendLocations\", {\n                    trendLocations: a.trendLocations\n                })));\n            };\n            this.get({\n                url: \"/trends/location_dialog\",\n                eventData: b,\n                success: c.bind(this),\n                error: \"dataGotTrendsLocationDialogError\"\n            });\n        }, this.updateTrendsLocation = function(a, b) {\n            var c = ((b.JSBNG__location || {\n            })), d = {\n                woeid: c.woeid,\n                personalized: b.personalized,\n                pc: !0\n            }, e = function(a) {\n                this.trigger(\"dataChangedTrendLocation\", {\n                    personalized: a.personalized,\n                    JSBNG__location: c\n                }), ((a.trends_cache_key && (this.trigger(\"dataTempTrendsCacheKeyChanged\", {\n                    trendsCacheKey: a.trends_cache_key\n                }), this.trigger(\"dataPageMutated\")))), ((a.module_html && this.trigger(\"dataTrendsRefreshed\", a)));\n            };\n            this.post({\n                url: \"/trends/dialog\",\n                eventData: b,\n                data: d,\n                success: e.bind(this),\n                error: \"dataGotTrendsLocationDialogError\"\n            });\n        }, this.after(\"initialize\", function() {\n            this.JSBNG__on(\"uiWantsTrendsLocationDialog\", this.getTrendsLocationDialog), this.JSBNG__on(\"uiChangeLocation\", this.updateTrendsLocation);\n        });\n    };\n;\n    var defineComponent = require(\"core/component\"), withData = require(\"app/data/with_data\");\n    module.exports = defineComponent(trendsLocationDialogData, withData);\n});\ndefine(\"app/data/trends/recent_locations\", [\"module\",\"require\",\"exports\",\"core/component\",\"app/utils/storage/custom\",\"app/data/with_data\",], function(module, require, exports) {\n    function trendsRecentLocations() {\n        this.defaultAttrs({\n            storageName: \"recent_trend_locations\",\n            storageKey: \"locations\",\n            maxRecentLocations: 5\n        }), this.initializeStorage = function() {\n            var a = customStorage({\n                withArray: !0,\n                withMaxElements: !0\n            });\n            this.storage = new a(this.attr.storageName), this.storage.setMaxElements(this.attr.storageKey, this.attr.maxRecentLocations);\n        }, this.getRecentTrendLocations = function() {\n            this.trigger(\"dataGotRecentTrendLocations\", {\n                trendLocations: this.storage.getArray(this.attr.storageKey)\n            });\n        }, this.saveRecentLocation = function(a, b) {\n            var c = ((b.JSBNG__location || {\n            }));\n            if (((!c.woeid || this.hasRecentLocation(c.woeid)))) {\n                return;\n            }\n        ;\n        ;\n            this.storage.push(this.attr.storageKey, c), this.getRecentTrendLocations();\n        }, this.hasRecentLocation = function(a) {\n            var b = this.storage.getArray(this.attr.storageKey);\n            return b.some(function(b) {\n                return ((b.woeid === a));\n            });\n        }, this.after(\"initialize\", function() {\n            this.initializeStorage(), this.JSBNG__on(\"uiWantsRecentTrendLocations\", this.getRecentTrendLocations), this.JSBNG__on(\"dataChangedTrendLocation\", this.saveRecentLocation);\n        });\n    };\n;\n    var defineComponent = require(\"core/component\"), customStorage = require(\"app/utils/storage/custom\"), withData = require(\"app/data/with_data\");\n    module.exports = defineComponent(trendsRecentLocations, withData);\n});\ndefine(\"app/utils/scribe_event_initiators\", [\"module\",\"require\",\"exports\",], function(module, require, exports) {\n    module.exports = {\n        clientSideUser: 0,\n        serverSideUser: 1,\n        clientSideApp: 2,\n        serverSideApp: 3\n    };\n});\ndefine(\"app/data/trends_scribe\", [\"module\",\"require\",\"exports\",\"core/component\",\"app/data/with_scribe\",\"app/utils/scribe_item_types\",\"app/utils/scribe_event_initiators\",], function(module, require, exports) {\n    function trendsScribe() {\n        this.scribeTrendClick = function(a, b) {\n            this.scribe(\"search\", b);\n        }, this.scribeTrendsResults = function(a, b) {\n            var c = [], d = ((b.initial ? \"initial\" : \"newer\")), e = {\n                element: d,\n                action: ((((b.items && b.items.length)) ? \"results\" : \"no_results\"))\n            }, f = {\n                referring_event: d\n            }, g = !1;\n            f.items = b.items.map(function(a, b) {\n                var c = {\n                    JSBNG__name: a.JSBNG__name,\n                    item_type: itemTypes.trend,\n                    item_query: a.JSBNG__name,\n                    position: b\n                };\n                return ((a.promotedTrendId && (c.promoted_id = a.promotedTrendId, g = !0))), c;\n            }), ((g && (f.promoted = g))), ((((b.source === \"clock\")) && (f.event_initiator = eventInitiators.clientSideApp))), this.scribe(e, b, f), ((b.initial && this.scribeTrendsImpression(b)));\n        }, this.scribeTrendsImpression = function(a) {\n            this.scribe(\"impression\", a);\n        }, this.after(\"initialize\", function() {\n            this.scribeOnEvent(\"uiTrendsDialogOpened\", \"open\"), this.JSBNG__on(\"uiTrendSelected\", this.scribeTrendClick), this.JSBNG__on(\"uiTrendsDisplayed\", this.scribeTrendsResults);\n        });\n    };\n;\n    var defineComponent = require(\"core/component\"), withScribe = require(\"app/data/with_scribe\"), itemTypes = require(\"app/utils/scribe_item_types\"), eventInitiators = require(\"app/utils/scribe_event_initiators\");\n    module.exports = defineComponent(trendsScribe, withScribe);\n});\ndefine(\"app/ui/trends/trends\", [\"module\",\"require\",\"exports\",\"core/component\",\"app/data/ddg\",\"app/utils/scribe_item_types\",\"app/ui/with_tweet_actions\",\"app/ui/with_item_actions\",], function(module, require, exports) {\n    function trendsModule() {\n        this.defaultAttrs({\n            changeLinkSelector: \".change-trends\",\n            trendsInnerSelector: \".trends-inner\",\n            trendItemSelector: \".js-trend-item\",\n            promotedTweetProofSelector: \".tweet-proof-container.promoted-tweet\",\n            trendLinkItemSelector: \".js-trend-item a\",\n            eventTrendClass: \"event-trend\",\n            itemType: \"trend\"\n        }), this.openChangeTrendsDialog = function(a) {\n            this.trigger(\"uiShowTrendsLocationDialog\"), a.preventDefault();\n        }, this.updateModuleContent = function(a, b) {\n            var c = this.$node.hasClass(\"hidden\"), d = b.source;\n            this.select(\"trendsInnerSelector\").html(b.module_html), this.currentWoeid = b.woeid, this.$node.removeClass(\"hidden\");\n            var e = this.getTrendData(this.select(\"trendItemSelector\"));\n            this.trigger(\"uiTrendsDisplayed\", {\n                items: e,\n                initial: c,\n                source: d,\n                scribeData: {\n                    woeid: this.currentWoeid\n                }\n            });\n            var f = this.getPromotedTweetProofData(this.select(\"promotedTweetProofSelector\"));\n            this.trigger(\"uiTweetsDisplayed\", {\n                tweets: f\n            });\n        }, this.trendSelected = function(a, b) {\n            var c = $(b.el).closest(this.attr.trendItemSelector), d = this.getTrendData(c)[0], e = c.index(), f = {\n                JSBNG__name: d.JSBNG__name,\n                item_query: d.JSBNG__name,\n                position: e,\n                item_type: itemTypes.trend\n            }, g = {\n                position: e,\n                query: d.JSBNG__name,\n                url: c.JSBNG__find(\"a\").attr(\"href\"),\n                woeid: this.currentWoeid\n            };\n            ((d.promotedTrendId && (f.promoted_id = d.promotedTrendId, g.promoted = !0))), g.items = [f,], this.trigger(\"uiTrendSelected\", {\n                isPromoted: !!d.promotedTrendId,\n                promotedTrendId: d.promotedTrendId,\n                scribeContext: {\n                    element: \"trend\"\n                },\n                scribeData: g\n            }), this.trackTrendSelected(!!d.promotedTrendId, c.hasClass(this.attr.eventTrendClass));\n        }, this.trackTrendSelected = function(a, b) {\n            var c = ((b ? \"event_trend_click\" : ((a ? \"promoted_trend_click\" : \"trend_click\"))));\n            ddg.track(\"olympic_trends_320\", c);\n        }, this.getTrendData = function(a) {\n            return a.map(function() {\n                var a = $(this);\n                return {\n                    JSBNG__name: a.data(\"trend-name\"),\n                    promotedTrendId: a.data(\"promoted-trend-id\"),\n                    trendingEvent: a.hasClass(\"event-trend\")\n                };\n            }).toArray();\n        }, this.getPromotedTweetProofData = function(a) {\n            return a.map(function(a, b) {\n                return {\n                    impressionId: $(b).data(\"impression-id\")\n                };\n            }).toArray();\n        }, this.after(\"initialize\", function() {\n            this.JSBNG__on(JSBNG__document, \"dataTrendsRefreshed\", this.updateModuleContent), this.JSBNG__on(\"click\", {\n                changeLinkSelector: this.openChangeTrendsDialog,\n                trendLinkItemSelector: this.trendSelected\n            }), this.trigger(\"uiRefreshTrends\");\n        });\n    };\n;\n    var defineComponent = require(\"core/component\"), ddg = require(\"app/data/ddg\"), itemTypes = require(\"app/utils/scribe_item_types\"), withTweetActions = require(\"app/ui/with_tweet_actions\"), withItemActions = require(\"app/ui/with_item_actions\");\n    module.exports = defineComponent(trendsModule, withTweetActions, withItemActions);\n});\ndefine(\"app/ui/trends/trends_dialog\", [\"module\",\"require\",\"exports\",\"core/component\",\"app/ui/with_dialog\",\"app/ui/with_position\",], function(module, require, exports) {\n    function trendsDialog() {\n        this.defaultAttrs({\n            contentSelector: \"#trends_dialog_content\",\n            trendItemSelector: \".js-trend-link\",\n            toggleSelector: \".customize-by-location\",\n            personalizedSelector: \".trends-personalized\",\n            byLocationSelector: \".trends-by-location\",\n            doneSelector: \".done\",\n            selectDefaultSelector: \".select-default\",\n            errorSelector: \".trends-dialog-error p\",\n            loadingSelector: \".loading\",\n            deciderPersonalizedTrends: !1\n        }), this.openTrendsDialog = function(a, b) {\n            this.trigger(\"uiTrendsDialogOpened\"), ((this.hasContent() ? this.selectActiveView() : this.trigger(\"uiWantsTrendsDialog\"))), this.$node.removeClass(\"has-error\"), this.open();\n        }, this.showPersonalizedView = function() {\n            this.select(\"byLocationSelector\").hide(), this.select(\"personalizedSelector\").show();\n        }, this.showLocationView = function() {\n            this.select(\"personalizedSelector\").hide(), this.select(\"byLocationSelector\").show();\n        }, this.updateDialogContent = function(a, b) {\n            var c = ((this.personalized && b.personalized));\n            this.personalized = b.personalized, this.currentWoeid = b.woeid;\n            if (((c && !this.hasError()))) {\n                return;\n            }\n        ;\n        ;\n            this.select(\"contentSelector\").html(b.dialog_html), this.selectActiveView(), ((!b.personalized && this.markSelected(b.woeid)));\n        }, this.selectActiveView = function() {\n            ((this.isPersonalized() ? this.showPersonalizedView() : this.showLocationView()));\n        }, this.showError = function(a, b) {\n            this.select(\"byLocationSelector\").hide(), this.select(\"personalizedSelector\").hide(), this.$node.addClass(\"has-error\"), this.select(\"errorSelector\").html(b.message);\n        }, this.hasContent = function() {\n            return ((((this.select(\"loadingSelector\").length == 0)) && !this.hasError()));\n        }, this.hasError = function() {\n            return this.$node.hasClass(\"has-error\");\n        }, this.markSelected = function(a) {\n            this.select(\"trendItemSelector\").removeClass(\"selected\").filter(((((\"[data-woeid=\" + a)) + \"]\"))).addClass(\"selected\");\n        }, this.clearSelectedBreadcrumb = function() {\n            this.select(\"selectedBreadCrumbSelector\").removeClass(\"checkmark\");\n        }, this.changeSelectedItem = function(a, b) {\n            var c = $(b.el).data(\"woeid\");\n            if (((this.isPersonalized() || ((c !== this.currentWoeid))))) {\n                this.markSelected(c), this.trigger(\"uiChangeTrendsLocation\", {\n                    woeid: c\n                });\n            }\n        ;\n        ;\n            a.preventDefault();\n        }, this.selectDefault = function(a, b) {\n            var c = !!$(a.target).data(\"personalized\"), b = {\n            };\n            ((c ? b.personalized = !0 : b.woeid = 1)), this.trigger(\"uiChangeTrendsLocation\", b), this.close();\n        }, this.toggleView = function(a, b) {\n            ((this.select(\"personalizedSelector\").is(\":visible\") ? this.showLocationView() : this.showPersonalizedView()));\n        }, this.isPersonalized = function() {\n            return ((this.attr.deciderPersonalizedTrends && this.personalized));\n        }, this.after(\"initialize\", function() {\n            this.select(\"byLocationSelector\").hide(), this.select(\"personalizedSelector\").hide(), this.JSBNG__on(JSBNG__document, \"uiShowTrendsLocationDialog\", this.openTrendsDialog), this.JSBNG__on(JSBNG__document, \"dataGotTrendsDialog\", this.updateDialogContent), this.JSBNG__on(JSBNG__document, \"dataGotTrendsDialogError\", this.showError), this.JSBNG__on(\"click\", {\n                trendItemSelector: this.changeSelectedItem,\n                toggleSelector: this.toggleView,\n                doneSelector: this.close,\n                selectDefaultSelector: this.selectDefault\n            });\n        });\n    };\n;\n    var defineComponent = require(\"core/component\"), withDialog = require(\"app/ui/with_dialog\"), withPosition = require(\"app/ui/with_position\");\n    module.exports = defineComponent(trendsDialog, withDialog, withPosition);\n});\ndefine(\"app/ui/trends/dialog/with_location_info\", [\"module\",\"require\",\"exports\",], function(module, require, exports) {\n    function withLocationInfo() {\n        this.defaultAttrs({\n            JSBNG__location: {\n            },\n            personalized: !1\n        }), this.setLocationInfo = function(a, b) {\n            this.personalized = !!b.personalized, this.JSBNG__location = ((b.JSBNG__location || {\n            })), this.trigger(\"uiLocationInfoUpdated\");\n        }, this.changeLocationInfo = function(a) {\n            this.trigger(\"uiChangeLocation\", {\n                JSBNG__location: a\n            });\n        }, this.setPersonalizedTrends = function() {\n            this.trigger(\"uiChangeLocation\", {\n                personalized: !0\n            });\n        }, this.before(\"initialize\", function() {\n            this.personalized = this.attr.personalized, this.JSBNG__location = this.attr.JSBNG__location;\n        }), this.after(\"initialize\", function() {\n            this.JSBNG__on(JSBNG__document, \"dataChangedTrendLocation\", this.setLocationInfo);\n        });\n    };\n;\n    module.exports = withLocationInfo;\n});\ndefine(\"app/ui/trends/dialog/location_dropdown\", [\"module\",\"require\",\"exports\",\"core/component\",\"app/ui/trends/dialog/with_location_info\",], function(module, require, exports) {\n    function trendsLocationDropdown() {\n        this.defaultAttrs({\n            regionsSelector: \"select[name=\\\"regions\\\"]\",\n            citiesSelector: \"select[name=\\\"cities\\\"]\"\n        }), this.initializeCities = function() {\n            this.citiesByRegionWoeid = {\n            };\n            var a = this.$cities.JSBNG__find(\"option\");\n            a.each(function(a, b) {\n                var c = $(b), d = c.data(\"woeid\");\n                ((this.citiesByRegionWoeid[d] || (this.citiesByRegionWoeid[d] = []))), this.citiesByRegionWoeid[d].push(c);\n            }.bind(this));\n        }, this.updateDropdown = function() {\n            var a = this.$regions.val(), b = ((this.citiesByRegionWoeid[a] || \"\"));\n            this.$cities.empty(), this.$cities.html(b);\n        }, this.updateRegion = function() {\n            this.updateDropdown();\n            var a = this.$cities.children().first();\n            ((a.length && (a.prop(\"selected\", !0), a.change())));\n        }, this.updateCity = function() {\n            var a = this.$cities.JSBNG__find(\"option:selected\"), b = parseInt(a.val(), 10), c = a.data(\"JSBNG__name\");\n            this.currentSelection = b, this.changeLocationInfo({\n                woeid: b,\n                JSBNG__name: c\n            });\n        }, this.possiblyClearSelection = function() {\n            ((((this.currentSelection != this.JSBNG__location.woeid)) && this.reset()));\n        }, this.reset = function() {\n            this.currentSelection = null;\n            var a = this.$regions.JSBNG__find(\"option[value=\\\"\\\"]\");\n            a.prop(\"selected\", !0), this.updateDropdown();\n        }, this.after(\"initialize\", function() {\n            this.$regions = this.select(\"regionsSelector\"), this.$cities = this.select(\"citiesSelector\"), this.initializeCities(), this.JSBNG__on(this.$regions, \"change\", this.updateRegion), this.JSBNG__on(this.$cities, \"change\", this.updateCity), this.JSBNG__on(JSBNG__document, \"uiTrendsDialogReset\", this.reset), this.JSBNG__on(\"uiLocationInfoUpdated\", this.possiblyClearSelection), this.updateDropdown();\n        });\n    };\n;\n    var defineComponent = require(\"core/component\"), withLocationInfo = require(\"app/ui/trends/dialog/with_location_info\");\n    module.exports = defineComponent(trendsLocationDropdown, withLocationInfo);\n});\ndefine(\"app/ui/trends/dialog/location_search\", [\"module\",\"require\",\"exports\",\"core/component\",\"app/ui/trends/dialog/with_location_info\",\"app/ui/typeahead/typeahead_dropdown\",\"app/ui/typeahead/typeahead_input\",], function(module, require, exports) {\n    function trendsLocationSearch() {\n        this.defaultAttrs({\n            inputSelector: \"input.trends-location-search-input\"\n        }), this.executeTypeaheadSelection = function(a, b) {\n            if (((b.item.woeid == -1))) {\n                this.trigger(\"uiTrendsLocationSearchNoResults\");\n                return;\n            }\n        ;\n        ;\n            this.currentSelection = b.item, this.changeLocationInfo({\n                woeid: b.item.woeid,\n                JSBNG__name: b.item.JSBNG__name\n            });\n        }, this.possiblyClearSelection = function() {\n            ((((this.currentSelection && ((this.currentSelection.woeid != this.JSBNG__location.woeid)))) && this.reset()));\n        }, this.reset = function(a, b) {\n            this.currentSelection = null, this.$input.val(\"\");\n        }, this.after(\"initialize\", function() {\n            this.$input = this.select(\"inputSelector\"), this.JSBNG__on(\"uiTypeaheadItemSelected uiTypeaheadItemComplete\", this.executeTypeaheadSelection), this.JSBNG__on(\"uiLocationInfoUpdated\", this.possiblyClearSelection), this.JSBNG__on(JSBNG__document, \"uiTrendsDialogReset\", this.reset), TypeaheadInput.attachTo(this.$node, {\n                inputSelector: this.attr.inputSelector\n            }), TypeaheadDropdown.attachTo(this.$node, {\n                inputSelector: this.attr.inputSelector,\n                blockLinkActions: !0,\n                datasourceRenders: [[\"trendLocations\",[\"trendLocations\",],],],\n                deciders: this.attr.typeaheadData,\n                eventData: {\n                    scribeContext: {\n                        component: \"trends_location_search\"\n                    }\n                }\n            });\n        });\n    };\n;\n    var defineComponent = require(\"core/component\"), withLocationInfo = require(\"app/ui/trends/dialog/with_location_info\"), TypeaheadDropdown = require(\"app/ui/typeahead/typeahead_dropdown\"), TypeaheadInput = require(\"app/ui/typeahead/typeahead_input\");\n    module.exports = defineComponent(trendsLocationSearch, withLocationInfo);\n});\ndefine(\"app/ui/trends/dialog/current_location\", [\"module\",\"require\",\"exports\",\"core/component\",\"app/ui/trends/dialog/with_location_info\",], function(module, require, exports) {\n    function trendsCurrentLocation() {\n        this.defaultAttrs({\n            personalizedSelector: \".js-location-personalized\",\n            nonpersonalizedSelector: \".js-location-nonpersonalized\",\n            currentLocationSelector: \".current-location\"\n        }), this.updateView = function() {\n            var a = !!this.personalized;\n            ((a || this.select(\"currentLocationSelector\").text(this.JSBNG__location.JSBNG__name))), this.select(\"nonpersonalizedSelector\").toggle(!a), this.select(\"personalizedSelector\").toggle(a);\n        }, this.after(\"initialize\", function() {\n            this.updateView(), this.JSBNG__on(\"uiLocationInfoUpdated\", this.updateView);\n        });\n    };\n;\n    var defineComponent = require(\"core/component\"), withLocationInfo = require(\"app/ui/trends/dialog/with_location_info\");\n    module.exports = defineComponent(trendsCurrentLocation, withLocationInfo);\n});\ndefine(\"app/ui/trends/dialog/with_location_list_picker\", [\"module\",\"require\",\"exports\",\"core/compose\",\"app/ui/trends/dialog/with_location_info\",], function(module, require, exports) {\n    function withLocationListPicker() {\n        compose.mixin(this, [withLocationInfo,]), this.defaultAttrs({\n            locationSelector: \".trend-location-picker-item\",\n            selectedAttr: \"selected\"\n        }), this.selectLocation = function(a, b) {\n            a.preventDefault();\n            var c = $(b.el), d = {\n                woeid: c.data(\"woeid\"),\n                JSBNG__name: c.data(\"JSBNG__name\")\n            };\n            this.changeLocationInfo(d), this.showSelected(d.woeid, !1);\n        }, this.showSelected = function(a, b) {\n            var c = this.select(\"locationSelector\");\n            c.removeClass(this.attr.selectedAttr), ((((!b && a)) && c.filter(((((\"[data-woeid=\\\"\" + a)) + \"\\\"]\"))).addClass(this.attr.selectedAttr)));\n        }, this.locationInfoUpdated = function() {\n            this.showSelected(this.JSBNG__location.woeid, this.personalized);\n        }, this.after(\"initialize\", function() {\n            this.JSBNG__on(\"uiLocationInfoUpdated\", this.locationInfoUpdated), this.JSBNG__on(\"click\", {\n                locationSelector: this.selectLocation\n            }), this.showSelected(this.JSBNG__location.woeid, this.personalized);\n        });\n    };\n;\n    var compose = require(\"core/compose\"), withLocationInfo = require(\"app/ui/trends/dialog/with_location_info\");\n    module.exports = withLocationListPicker;\n});\ndefine(\"app/ui/trends/dialog/nearby_trends\", [\"module\",\"require\",\"exports\",\"core/component\",\"app/ui/trends/dialog/with_location_list_picker\",], function(module, require, exports) {\n    function trendsNearby() {\n    \n    };\n;\n    var defineComponent = require(\"core/component\"), withLocationListPicker = require(\"app/ui/trends/dialog/with_location_list_picker\");\n    module.exports = defineComponent(trendsNearby, withLocationListPicker);\n});\ndefine(\"app/ui/trends/dialog/recent_trends\", [\"module\",\"require\",\"exports\",\"core/component\",\"app/ui/trends/dialog/with_location_list_picker\",], function(module, require, exports) {\n    function trendsRecent() {\n        this.defaultAttrs({\n            listContainerSelector: \".trend-location-picker\"\n        }), this.loadTrendLocations = function(a, b) {\n            var c = b.trendLocations;\n            this.$list.empty(), c.forEach(function(a) {\n                var b = this.$template.clone(!1), c = b.JSBNG__find(\"button\");\n                c.text(a.JSBNG__name), c.attr(\"data-woeid\", a.woeid), c.attr(\"data-name\", a.JSBNG__name), this.$list.append(b);\n            }, this), this.$node.toggle(((c.length > 0)));\n        }, this.after(\"initialize\", function() {\n            this.$list = this.select(\"listContainerSelector\"), this.$template = this.$list.JSBNG__find(\"li:first\").clone(!1), this.JSBNG__on(JSBNG__document, \"dataGotRecentTrendLocations\", this.loadTrendLocations), this.trigger(\"uiWantsRecentTrendLocations\");\n        });\n    };\n;\n    var defineComponent = require(\"core/component\"), withLocationListPicker = require(\"app/ui/trends/dialog/with_location_list_picker\");\n    module.exports = defineComponent(trendsRecent, withLocationListPicker);\n});\ndefine(\"app/ui/trends/dialog/dialog\", [\"module\",\"require\",\"exports\",\"core/component\",\"app/ui/with_dialog\",\"app/ui/with_position\",\"app/ui/trends/dialog/location_dropdown\",\"app/ui/trends/dialog/location_search\",\"app/ui/trends/dialog/current_location\",\"app/ui/trends/dialog/nearby_trends\",\"app/ui/trends/dialog/recent_trends\",\"app/ui/trends/dialog/with_location_info\",], function(module, require, exports) {\n    function trendsLocationDialog() {\n        this.defaultAttrs({\n            contentSelector: \"#trends_dialog_content\",\n            quickSelectSelector: \"#trend-locations-quick-select\",\n            dropdownSelector: \"#trend-locations-dropdown-select\",\n            personalizedSelector: \".trends-personalized\",\n            nonPersonalizedSelector: \".trends-by-location\",\n            changeTrendsSelector: \".customize-by-location\",\n            showDropdownSelector: \".js-show-dropdown-select\",\n            showQuickSelectSelector: \".js-show-quick-select\",\n            searchSelector: \".trends-search-locations\",\n            nearbySelector: \".trends-nearby-locations\",\n            recentSelector: \".trends-recent-locations\",\n            currentLocationSelector: \".trends-current-location\",\n            loadingSelector: \"#trend-locations-loading\",\n            defaultSelector: \".select-default\",\n            doneSelector: \".done\",\n            errorSelector: \".trends-dialog-error p\",\n            errorClass: \"has-error\"\n        }), this.JSBNG__openDialog = function(a, b) {\n            this.trigger(\"uiTrendsDialogOpened\"), ((this.initialized ? this.setCurrentView() : (this.trigger(\"uiWantsTrendsLocationDialog\"), this.initialized = !0))), this.$node.removeClass(\"has-error\"), this.open();\n        }, this.setCurrentView = function() {\n            ((this.personalized ? this.showPersonalizedView() : this.showNonpersonalizedView()));\n        }, this.showPersonalizedView = function() {\n            this.select(\"nonPersonalizedSelector\").hide(), this.select(\"personalizedSelector\").show();\n        }, this.showNonpersonalizedView = function() {\n            this.select(\"personalizedSelector\").hide(), this.select(\"nonPersonalizedSelector\").show();\n        }, this.showQuickSelectContainer = function(a, b) {\n            this.showNonpersonalizedView(), this.select(\"dropdownSelector\").hide(), this.select(\"quickSelectSelector\").show();\n        }, this.showDropdownContainer = function(a, b) {\n            this.showNonpersonalizedView(), this.select(\"quickSelectSelector\").hide(), this.select(\"dropdownSelector\").show();\n        }, this.hideViews = function() {\n            this.select(\"personalizedSelector\").hide(), this.select(\"nonPersonalizedSelector\").hide();\n        }, this.showError = function(a, b) {\n            this.hideViews(), this.hideLoading(), this.initialized = !1, this.$node.addClass(this.attr.errorClass), this.select(\"errorSelector\").html(b.message);\n        }, this.selectDefault = function(a, b) {\n            var c = $(a.target), d = !!c.data(\"personalized\");\n            ((d ? this.setPersonalizedTrends() : this.changeLocationInfo({\n                JSBNG__name: c.data(\"JSBNG__name\"),\n                woeid: c.data(\"woeid\")\n            }))), this.close();\n        }, this.reset = function(a, b) {\n            this.showQuickSelectContainer(), this.trigger(\"uiTrendsDialogReset\");\n        }, this.initializeDialog = function(a, b) {\n            this.select(\"contentSelector\").html(b.dialog_html), this.setLocationInfo(a, b), this.initializeComponents(), this.setCurrentView();\n        }, this.showLoading = function() {\n            this.select(\"loadingSelector\").show();\n        }, this.hideLoading = function() {\n            this.select(\"loadingSelector\").hide();\n        }, this.initializeComponents = function(a, b) {\n            CurrentLocation.attachTo(this.attr.currentLocationSelector, {\n                JSBNG__location: this.JSBNG__location,\n                personalized: this.personalized\n            }), LocationSearch.attachTo(this.attr.searchSelector, {\n                typeaheadData: this.attr.typeaheadData\n            }), LocationDropdown.attachTo(this.attr.dropdownSelector), NearbyTrends.attachTo(this.attr.nearbySelector, {\n                JSBNG__location: this.JSBNG__location,\n                personalized: this.personalized\n            }), RecentTrends.attachTo(this.attr.recentSelector, {\n                JSBNG__location: this.JSBNG__location,\n                personalized: this.personalized\n            });\n        }, this.after(\"initialize\", function() {\n            this.hideViews(), this.JSBNG__on(\"uiChangeLocation\", this.showLoading), this.JSBNG__on(\"uiTrendsLocationSearchNoResults\", this.showDropdownContainer), this.JSBNG__on(JSBNG__document, \"uiShowTrendsLocationDialog\", this.JSBNG__openDialog), this.JSBNG__on(JSBNG__document, \"uiDialogClosed\", this.reset), this.JSBNG__on(JSBNG__document, \"dataGotTrendsLocationDialog\", this.initializeDialog), this.JSBNG__on(JSBNG__document, \"dataGotTrendsLocationDialogError\", this.showError), this.JSBNG__on(\"uiLocationInfoUpdated\", this.hideLoading), this.JSBNG__on(\"click\", {\n                doneSelector: this.close,\n                defaultSelector: this.selectDefault,\n                changeTrendsSelector: this.showNonpersonalizedView,\n                showDropdownSelector: this.showDropdownContainer,\n                showQuickSelectSelector: this.showQuickSelectContainer\n            });\n        });\n    };\n;\n    var defineComponent = require(\"core/component\"), withDialog = require(\"app/ui/with_dialog\"), withPosition = require(\"app/ui/with_position\"), LocationDropdown = require(\"app/ui/trends/dialog/location_dropdown\"), LocationSearch = require(\"app/ui/trends/dialog/location_search\"), CurrentLocation = require(\"app/ui/trends/dialog/current_location\"), NearbyTrends = require(\"app/ui/trends/dialog/nearby_trends\"), RecentTrends = require(\"app/ui/trends/dialog/recent_trends\"), withLocationInfo = require(\"app/ui/trends/dialog/with_location_info\");\n    module.exports = defineComponent(trendsLocationDialog, withDialog, withPosition, withLocationInfo);\n});\ndefine(\"app/boot/trends\", [\"module\",\"require\",\"exports\",\"app/data/trends\",\"app/data/trends/location_dialog\",\"app/data/trends/recent_locations\",\"app/data/trends_scribe\",\"app/ui/trends/trends\",\"app/ui/trends/trends_dialog\",\"app/ui/trends/dialog/dialog\",], function(module, require, exports) {\n    var TrendsData = require(\"app/data/trends\"), TrendsLocationDialogData = require(\"app/data/trends/location_dialog\"), TrendsRecentLocationsData = require(\"app/data/trends/recent_locations\"), TrendsScribe = require(\"app/data/trends_scribe\"), TrendsModule = require(\"app/ui/trends/trends\"), TrendsDialog = require(\"app/ui/trends/trends_dialog\"), TrendsLocationDialog = require(\"app/ui/trends/dialog/dialog\");\n    module.exports = function(b) {\n        TrendsScribe.attachTo(JSBNG__document, b), TrendsData.attachTo(JSBNG__document, b), TrendsModule.attachTo(\".module.trends\", {\n            loggedIn: b.loggedIn,\n            eventData: {\n                scribeContext: {\n                    component: \"trends\"\n                }\n            }\n        }), ((b.trendsLocationDialogEnabled ? (TrendsLocationDialogData.attachTo(JSBNG__document, b), TrendsRecentLocationsData.attachTo(JSBNG__document, b), TrendsLocationDialog.attachTo(\"#trends_dialog\", {\n            typeaheadData: b.typeaheadData,\n            eventData: {\n                scribeContext: {\n                    component: \"trends_location_dialog\"\n                }\n            }\n        })) : TrendsDialog.attachTo(\"#trends_dialog\", {\n            deciderPersonalizedTrends: b.decider_personalized_trends,\n            eventData: {\n                scribeContext: {\n                    component: \"trends_dialog\"\n                }\n            }\n        })));\n    };\n});\ndefine(\"app/ui/infinite_scroll_watcher\", [\"module\",\"require\",\"exports\",\"core/component\",\"core/utils\",], function(module, require, exports) {\n    function infiniteScrollWatcher() {\n        var a = 0, b = 1;\n        this.checkScrollPosition = function() {\n            var c = this.$content.height(), d = !1;\n            ((((this.inTriggerRange(a) && ((((c > this.lastTriggeredHeight)) || this.lastTriggeredFrom(b))))) ? (this.trigger(\"uiNearTheTop\"), this.lastTriggerFrom = a, d = !0) : ((((this.inTriggerRange(b) && ((((c > this.lastTriggeredHeight)) || this.lastTriggeredFrom(a))))) && (this.trigger(\"uiNearTheBottom\"), this.lastTriggerFrom = b, d = !0))))), ((d && (this.lastTriggeredHeight = c)));\n        }, this.inTriggerRange = function(c) {\n            var d = this.$content.height(), e = this.$node.scrollTop(), f = ((e + this.$node.height())), g = Math.abs(Math.min(((f - d)), 0)), h = ((this.$node.height() / 2));\n            return ((((((e < h)) && ((c == a)))) || ((((g < h)) && ((c == b))))));\n        }, this.lastTriggeredFrom = function(a) {\n            return ((this.lastTriggerFrom === a));\n        }, this.resetScrollState = function() {\n            this.lastTriggeredHeight = 0, this.lastTriggerFrom = -1;\n        }, this.after(\"initialize\", function(a) {\n            this.resetScrollState(), this.$content = ((a.contentSelector ? this.select(\"contentSelector\") : $(JSBNG__document))), this.JSBNG__on(\"JSBNG__scroll\", utils.throttle(this.checkScrollPosition.bind(this), 100)), this.JSBNG__on(\"uiTimelineReset\", this.resetScrollState);\n        });\n    };\n;\n    var defineComponent = require(\"core/component\"), utils = require(\"core/utils\"), InfiniteScrollWatcher = defineComponent(infiniteScrollWatcher);\n    module.exports = InfiniteScrollWatcher;\n});\ndefine(\"app/data/timeline\", [\"module\",\"require\",\"exports\",\"core/component\",\"core/utils\",\"app/data/with_data\",], function(module, require, exports) {\n    function timeline() {\n        this.defaultAttrs({\n            defaultAjaxData: {\n                include_entities: 1,\n                include_available_features: 1\n            },\n            noShowError: !0\n        }), this.requestItems = function(a, b) {\n            var c = function(b) {\n                this.trigger(a.target, \"dataGotMoreTimelineItems\", b);\n            }, d = function(b) {\n                this.trigger(a.target, \"dataGotMoreTimelineItemsError\", b);\n            }, e = {\n            };\n            ((((b && b.fromPolling)) && (e[\"X-Twitter-Polling\"] = !0)));\n            var f = {\n                since_id: b.since_id,\n                max_id: b.max_id,\n                cursor: b.cursor,\n                is_forward: b.is_forward,\n                latent_count: b.latent_count,\n                composed_count: b.composed_count,\n                include_new_items_bar: b.include_new_items_bar,\n                preexpanded_id: b.preexpanded_id,\n                interval: b.interval,\n                count: b.count,\n                timeline_empty: b.timeline_empty\n            };\n            ((b.query && (f.q = b.query))), ((b.curated_timeline_since_id && (f.curated_timeline_since_id = b.curated_timeline_since_id))), ((b.scroll_cursor && (f.scroll_cursor = b.scroll_cursor))), ((b.refresh_cursor && (f.refresh_cursor = b.refresh_cursor))), this.get({\n                url: this.attr.endpoint,\n                headers: e,\n                data: utils.merge(this.attr.defaultAjaxData, f),\n                eventData: b,\n                success: c.bind(this),\n                error: d.bind(this)\n            });\n        }, this.after(\"initialize\", function(a) {\n            this.JSBNG__on(\"uiWantsMoreTimelineItems\", this.requestItems);\n        });\n    };\n;\n    var defineComponent = require(\"core/component\"), utils = require(\"core/utils\"), withData = require(\"app/data/with_data\");\n    module.exports = defineComponent(timeline, withData);\n});\ndefine(\"app/boot/timeline\", [\"module\",\"require\",\"exports\",\"app/ui/infinite_scroll_watcher\",\"app/data/timeline\",], function(module, require, exports) {\n    function initialize(a) {\n        ((a.no_global_infinite_scroll || InfiniteScrollWatcher.attachTo(window))), TimelineData.attachTo(JSBNG__document, a);\n    };\n;\n    var InfiniteScrollWatcher = require(\"app/ui/infinite_scroll_watcher\"), TimelineData = require(\"app/data/timeline\");\n    module.exports = initialize;\n});\ndefine(\"app/data/activity_popup\", [\"module\",\"require\",\"exports\",\"core/component\",\"app/data/with_data\",], function(module, require, exports) {\n    function activityPopupData() {\n        this.defaultAttrs({\n            noShowError: !0\n        }), this.getUsers = function(a, b) {\n            var c = ((b.isRetweeted ? \"/i/activity/retweeted_popup\" : \"/i/activity/favorited_popup\"));\n            this.get({\n                url: c,\n                data: {\n                    id: b.tweetId\n                },\n                eventData: b,\n                success: \"dataActivityPopupSuccess\",\n                error: \"dataActivityPopupError\"\n            });\n        }, this.after(\"initialize\", function() {\n            this.JSBNG__on(\"uiFetchActivityPopup\", this.getUsers);\n        });\n    };\n;\n    var defineComponent = require(\"core/component\"), withData = require(\"app/data/with_data\");\n    module.exports = defineComponent(activityPopupData, withData);\n});\ndefine(\"app/ui/dialogs/activity_popup\", [\"module\",\"require\",\"exports\",\"core/component\",\"core/utils\",\"app/ui/with_position\",\"app/ui/with_dialog\",\"app/ui/with_user_actions\",\"app/ui/with_item_actions\",], function(module, require, exports) {\n    function activityPopup() {\n        this.defaultAttrs({\n            itemType: \"user\",\n            titleSelector: \".modal-title\",\n            tweetSelector: \".activity-tweet\",\n            contentSelector: \".activity-content\",\n            openDropdownSelector: \".user-dropdown.open .dropdown-menu\",\n            usersSelector: \".activity-popup-users\"\n        }), this.setTitle = function(a) {\n            this.select(\"titleSelector\").html(a);\n        }, this.setContent = function(a) {\n            this.$node.toggleClass(\"has-content\", !!a), this.select(\"contentSelector\").html(a);\n        }, this.requestPopup = function(a, b) {\n            this.attr.eventData = utils.merge(this.attr.eventData, {\n                scribeContext: {\n                    component: ((b.isRetweeted ? \"retweeted_dialog\" : \"favorited_dialog\"))\n                }\n            }, !0), this.setTitle(b.titleHtml);\n            var c = $(b.tweetHtml);\n            this.select(\"tweetSelector\").html(c), this.setContent(\"\"), this.open(), this.trigger(\"uiFetchActivityPopup\", {\n                tweetId: c.attr(\"data-tweet-id\"),\n                isRetweeted: b.isRetweeted\n            });\n        }, this.updateUsers = function(a, b) {\n            this.setTitle(b.htmlTitle), this.setContent(b.htmlUsers);\n            var c = this.select(\"usersSelector\");\n            ((((c.height() >= parseInt(c.css(\"max-height\"), 10))) && c.addClass(\"dropdown-threshold\")));\n        }, this.showError = function(a, b) {\n            this.setContent($(\"\\u003Cp\\u003E\").addClass(\"error\").html(b.message));\n        }, this.after(\"initialize\", function() {\n            this.JSBNG__on(JSBNG__document, \"uiRequestActivityPopup\", this.requestPopup), this.JSBNG__on(JSBNG__document, \"dataActivityPopupSuccess\", this.updateUsers), this.JSBNG__on(JSBNG__document, \"dataActivityPopupError\", this.showError), this.JSBNG__on(JSBNG__document, \"uiShowProfilePopup uiOpenTweetDialogWithOptions uiNeedsDMDialog uiOpenSigninOrSignupDialog\", this.close);\n        });\n    };\n;\n    var defineComponent = require(\"core/component\"), utils = require(\"core/utils\"), withPosition = require(\"app/ui/with_position\"), withDialog = require(\"app/ui/with_dialog\"), withUserActions = require(\"app/ui/with_user_actions\"), withItemActions = require(\"app/ui/with_item_actions\");\n    module.exports = defineComponent(activityPopup, withDialog, withPosition, withUserActions, withItemActions);\n});\ndefine(\"app/data/activity_popup_scribe\", [\"module\",\"require\",\"exports\",\"core/component\",\"app/data/with_scribe\",], function(module, require, exports) {\n    function activityPopupScribe() {\n        this.scribeActivityPopupOpen = function(a, b) {\n            var c = b.sourceEventData;\n            this.scribe(\"open\", b, {\n                item_ids: [c.tweetId,],\n                item_count: 1\n            });\n        }, this.after(\"initialize\", function() {\n            this.JSBNG__on(JSBNG__document, \"dataActivityPopupSuccess\", this.scribeActivityPopupOpen);\n        });\n    };\n;\n    var defineComponent = require(\"core/component\"), withScribe = require(\"app/data/with_scribe\");\n    module.exports = defineComponent(activityPopupScribe, withScribe);\n});\ndefine(\"app/boot/activity_popup\", [\"module\",\"require\",\"exports\",\"app/data/activity_popup\",\"app/ui/dialogs/activity_popup\",\"app/data/activity_popup_scribe\",], function(module, require, exports) {\n    function initialize(a) {\n        ActivityPopupData.attachTo(JSBNG__document, a), ActivityPopupScribe.attachTo(JSBNG__document, a), ActivityPopup.attachTo(activityPopupSelector, a);\n    };\n;\n    var ActivityPopupData = require(\"app/data/activity_popup\"), ActivityPopup = require(\"app/ui/dialogs/activity_popup\"), ActivityPopupScribe = require(\"app/data/activity_popup_scribe\"), activityPopupSelector = \"#activity-popup-dialog\";\n    module.exports = initialize;\n});\ndefine(\"app/data/tweet_translation\", [\"module\",\"require\",\"exports\",\"core/component\",\"app/data/with_data\",], function(module, require, exports) {\n    function tweetTranslation() {\n        this.getTweetTranslation = function(a, b) {\n            var c = function(a) {\n                ((((a && a.message)) && this.trigger(\"uiShowMessage\", {\n                    message: a.message\n                }))), this.trigger(\"dataTweetTranslationSuccess\", a);\n            }, d = function(a, c, d) {\n                this.trigger(\"dataTweetTranslationError\", {\n                    id: b.id,\n                    JSBNG__status: c,\n                    errorThrown: d\n                });\n            }, e = {\n                id: b.tweetId,\n                dest: b.dest\n            };\n            this.get({\n                url: \"/i/translations/show.json\",\n                data: e,\n                headers: {\n                    \"X-Phx\": !0\n                },\n                eventData: b,\n                success: c.bind(this),\n                error: d.bind(this)\n            });\n        }, this.after(\"initialize\", function() {\n            this.JSBNG__on(\"uiNeedsTweetTranslation\", this.getTweetTranslation);\n        });\n    };\n;\n    var defineComponent = require(\"core/component\"), withData = require(\"app/data/with_data\"), TweetTranslation = defineComponent(tweetTranslation, withData);\n    module.exports = TweetTranslation;\n});\ndefine(\"app/data/conversations\", [\"module\",\"require\",\"exports\",\"core/component\",\"app/data/with_data\",], function(module, require, exports) {\n    function conversations() {\n        this.requestExpansion = function(a, b) {\n            var c = function(b) {\n                this.trigger(a.target, \"dataTweetConversationResult\", b), this.trigger(a.target, \"dataTweetSocialProofResult\", b);\n            }, d = function(b, c, d) {\n                this.trigger(a.target, \"dataTweetExpansionError\", {\n                    JSBNG__status: c,\n                    errorThrown: d\n                });\n            }, e = [\"social_proof\",];\n            ((b.fullConversation ? e.push(\"ancestors\", \"descendants\") : ((b.descendantsOnly && e.push(\"descendants\")))));\n            var f = {\n                include: e\n            };\n            ((b.facepileMax && (f.facepile_max = b.facepileMax)));\n            var g = window.JSBNG__location.search.match(/[?&]js_maps=([^&]+)/);\n            ((g && (f.js_maps = g[1]))), this.get({\n                url: ((\"/i/expanded/batch/\" + encodeURIComponent($(a.target).attr(\"data-tweet-id\")))),\n                data: f,\n                eventData: b,\n                success: c.bind(this),\n                error: d.bind(this)\n            });\n        }, this.after(\"initialize\", function() {\n            this.JSBNG__on(\"uiNeedsTweetExpandedContent\", this.requestExpansion);\n        });\n    };\n;\n    var defineComponent = require(\"core/component\"), withData = require(\"app/data/with_data\"), Conversations = defineComponent(conversations, withData);\n    module.exports = Conversations;\n});\ndefine(\"app/data/media_settings\", [\"module\",\"require\",\"exports\",\"core/component\",\"app/data/with_data\",\"core/i18n\",], function(module, require, exports) {\n    function mediaSettings() {\n        this.flagMedia = function(a, b) {\n            this.post({\n                url: \"/i/expanded/flag_possibly_sensitive\",\n                eventData: b,\n                data: b,\n                success: \"dataFlaggedMediaResult\",\n                error: \"dataFlaggedMediaError\"\n            });\n        }, this.updateViewPossiblySensitive = function(a, b) {\n            this.post({\n                url: \"/i/expanded/update_view_possibly_sensitive\",\n                eventData: b,\n                data: b,\n                success: \"dataUpdatedViewPossiblySensitiveResult\",\n                error: \"dataUpdatedViewPossiblySensitiveError\"\n            });\n        }, this.after(\"initialize\", function() {\n            this.JSBNG__on(\"uiFlagMedia\", this.flagMedia), this.JSBNG__on(\"uiUpdateViewPossiblySensitive\", this.updateViewPossiblySensitive), this.JSBNG__on(\"dataUpdatedViewPossiblySensitiveResult\", function() {\n                this.trigger(\"uiShowMessage\", {\n                    message: _(\"Your media display settings have been changed.\")\n                });\n            }), this.JSBNG__on(\"dataUpdatedViewPossiblySensitiveError\", function() {\n                this.trigger(\"uiShowError\", {\n                    message: _(\"Couldn't set inline media settings.\")\n                });\n            });\n        });\n    };\n;\n    var defineComponent = require(\"core/component\"), withData = require(\"app/data/with_data\"), _ = require(\"core/i18n\");\n    module.exports = defineComponent(mediaSettings, withData);\n});\ndefine(\"app/ui/dialogs/sensitive_flag_confirmation\", [\"module\",\"require\",\"exports\",\"core/component\",\"app/ui/with_dialog\",\"app/ui/with_position\",], function(module, require, exports) {\n    function flagDialog() {\n        this.defaultAttrs({\n            dialogSelector: \"#sensitive_flag_dialog\",\n            cancelSelector: \"#cancel_flag_confirmation\",\n            submitSelector: \"#submit_flag_confirmation\",\n            settingsSelector: \"#sensitive-settings-checkbox\",\n            illegalSelector: \"#sensitive-illegal-checkbox\"\n        }), this.flag = function() {\n            ((this.select(\"settingsSelector\").attr(\"checked\") && this.trigger(\"uiUpdateViewPossiblySensitive\", {\n                do_show: !1\n            }))), ((this.select(\"illegalSelector\").attr(\"checked\") && this.trigger(\"uiFlagMedia\", {\n                id: this.$dialog.attr(\"data-tweet-id\")\n            }))), this.close();\n        }, this.openWithId = function(b, c) {\n            this.$dialog.attr(\"data-tweet-id\", c.id), this.open();\n        }, this.after(\"initialize\", function(a) {\n            this.$dialog = this.select(\"dialogSelector\"), this.JSBNG__on(JSBNG__document, \"uiFlagConfirmation\", this.openWithId), this.JSBNG__on(\"click\", {\n                submitSelector: this.flag,\n                cancelSelector: this.close\n            });\n        });\n    };\n;\n    var defineComponent = require(\"core/component\"), withDialog = require(\"app/ui/with_dialog\"), withPosition = require(\"app/ui/with_position\");\n    module.exports = defineComponent(flagDialog, withDialog, withPosition);\n});\ndefine(\"app/ui/user_actions\", [\"module\",\"require\",\"exports\",\"core/component\",\"app/ui/with_user_actions\",], function(module, require, exports) {\n    function userActions() {\n    \n    };\n;\n    var defineComponent = require(\"core/component\"), withUserActions = require(\"app/ui/with_user_actions\");\n    module.exports = defineComponent(userActions, withUserActions);\n});\ndefine(\"app/data/prompt_mobile_app_scribe\", [\"module\",\"require\",\"exports\",\"core/component\",\"app/data/with_scribe\",], function(module, require, exports) {\n    function mobileAppPromptScribe() {\n        this.scribeOnClick = function(a, b) {\n            var c = a.target;\n            ((((c.getAttribute(\"id\") == \"iphone_download\")) ? this.scribe({\n                component: \"promptbird_262\",\n                element: \"iphone_download\",\n                action: \"click\"\n            }) : ((((c.getAttribute(\"id\") == \"android_download\")) ? this.scribe({\n                component: \"promptbird_262\",\n                element: \"android_download\",\n                action: \"click\"\n            }) : ((((c.className == \"dismiss-white\")) && this.scribe({\n                component: \"promptbird_262\",\n                action: \"dismiss\"\n            })))))));\n        }, this.after(\"initialize\", function() {\n            this.JSBNG__on(\"click\", this.scribeOnClick);\n        });\n    };\n;\n    var defineComponent = require(\"core/component\"), withScribe = require(\"app/data/with_scribe\");\n    module.exports = defineComponent(mobileAppPromptScribe, withScribe);\n});\ndefine(\"app/boot/tweets\", [\"module\",\"require\",\"exports\",\"app/boot/activity_popup\",\"app/data/tweet_actions\",\"app/data/tweet_translation\",\"app/data/conversations\",\"app/data/media_settings\",\"app/ui/dialogs/sensitive_flag_confirmation\",\"app/ui/expando/expanding_tweets\",\"app/ui/media/media_tweets\",\"app/data/url_resolver\",\"app/ui/user_actions\",\"app/data/prompt_mobile_app_scribe\",\"core/utils\",], function(module, require, exports) {\n    function initialize(a, b) {\n        activityPopupBoot(b), TweetActionsData.attachTo(JSBNG__document, b), TweetTranslationData.attachTo(JSBNG__document, b), ConversationsData.attachTo(JSBNG__document, b), MediaSettingsData.attachTo(JSBNG__document, b), UrlResolver.attachTo(JSBNG__document), ExpandingTweets.attachTo(a, b), ((b.excludeUserActions || UserActions.attachTo(a, utils.merge(b, {\n            genericItemSelector: \".js-stream-item\"\n        })))), MediaTweets.attachTo(a, b), SensitiveFlagConfirmationDialog.attachTo(JSBNG__document), MobileAppPromptScribe.attachTo($(\"div[data-prompt-id=262]\"));\n    };\n;\n    var activityPopupBoot = require(\"app/boot/activity_popup\"), TweetActionsData = require(\"app/data/tweet_actions\"), TweetTranslationData = require(\"app/data/tweet_translation\"), ConversationsData = require(\"app/data/conversations\"), MediaSettingsData = require(\"app/data/media_settings\"), SensitiveFlagConfirmationDialog = require(\"app/ui/dialogs/sensitive_flag_confirmation\"), ExpandingTweets = require(\"app/ui/expando/expanding_tweets\"), MediaTweets = require(\"app/ui/media/media_tweets\"), UrlResolver = require(\"app/data/url_resolver\"), UserActions = require(\"app/ui/user_actions\"), MobileAppPromptScribe = require(\"app/data/prompt_mobile_app_scribe\"), utils = require(\"core/utils\");\n    module.exports = initialize;\n});\ndefine(\"app/boot/help_pips_enable\", [\"module\",\"require\",\"exports\",\"app/utils/cookie\",\"app/utils/storage/core\",], function(module, require, exports) {\n    function initialize(a) {\n        var b = new JSBNG__Storage(\"help_pips\"), c = +(new JSBNG__Date);\n        b.clear(), b.setItem(\"until\", ((c + 1209600000))), cookie(\"help_pips\", null);\n    };\n;\n    var cookie = require(\"app/utils/cookie\"), JSBNG__Storage = require(\"app/utils/storage/core\");\n    module.exports = initialize;\n});\ndefine(\"app/data/help_pips\", [\"module\",\"require\",\"exports\",\"core/component\",\"app/data/with_data\",], function(module, require, exports) {\n    function helpPipsData() {\n        this.defaultAttrs({\n            noShowError: !0\n        }), this.loadHelpPips = function(a, b) {\n            var c = function(a) {\n                this.trigger(\"dataHelpPipsLoaded\", {\n                    pips: a\n                });\n            }.bind(this), d = function(a) {\n                this.trigger(\"dataHelpPipsError\");\n            }.bind(this);\n            this.get({\n                url: \"/i/help/pips\",\n                data: {\n                },\n                eventData: b,\n                success: c,\n                error: d\n            });\n        }, this.after(\"initialize\", function() {\n            this.loadHelpPips();\n        });\n    };\n;\n    var defineComponent = require(\"core/component\"), withData = require(\"app/data/with_data\");\n    module.exports = defineComponent(helpPipsData, withData);\n});\ndefine(\"app/data/help_pips_scribe\", [\"module\",\"require\",\"exports\",\"core/component\",\"app/data/with_scribe\",], function(module, require, exports) {\n    function helpPipsScribe() {\n        this.after(\"initialize\", function() {\n            this.scribeOnEvent(\"uiHelpPipIconAdded\", \"impression\"), this.scribeOnEvent(\"uiHelpPipIconClicked\", \"open\"), this.scribeOnEvent(\"uiHelpPipPromptFollowed\", \"success\"), this.scribeOnEvent(\"uiHelpPipExplainTriggered\", \"show\"), this.scribeOnEvent(\"uiHelpPipExplainClicked\", \"dismiss\"), this.scribeOnEvent(\"uiHelpPipExplainFollowed\", \"complete\");\n        });\n    };\n;\n    var defineComponent = require(\"core/component\"), withScribe = require(\"app/data/with_scribe\");\n    module.exports = defineComponent(helpPipsScribe, withScribe);\n});\ndefine(\"app/ui/help_pip\", [\"module\",\"require\",\"exports\",\"core/component\",], function(module, require, exports) {\n    function helpPip() {\n        this.explainTriggered = function(a) {\n            var b = $(a.target).closest(\".js-stream-item\");\n            if (!b.length) {\n                return;\n            }\n        ;\n        ;\n            if (((this.pip.matcher && ((b.JSBNG__find(this.pip.matcher).length == 0))))) {\n                return;\n            }\n        ;\n        ;\n            if (((this.state == \"icon\"))) this.trigger(\"uiHelpPipExplainTriggered\");\n             else {\n                if (((this.state != \"JSBNG__prompt\"))) {\n                    return;\n                }\n            ;\n            ;\n                this.trigger(\"uiHelpPipPromptFollowed\");\n            }\n        ;\n        ;\n            this.showState(\"explain\", b);\n        }, this.dismissTriggered = function(a) {\n            var b = $(a.target).closest(\".js-stream-item\");\n            if (((((b.length && this.pip.matcher)) && ((b.JSBNG__find(this.pip.matcher).length == 0))))) {\n                return;\n            }\n        ;\n        ;\n            ((((((!b.length || ((b[0] == this.$streamItem[0])))) && ((this.state == \"explain\")))) && this.trigger(\"uiHelpPipExplainFollowed\"))), this.dismiss();\n        }, this.clicked = function(a) {\n            ((((this.state == \"icon\")) ? (this.trigger(\"uiHelpPipIconClicked\"), this.showState(\"JSBNG__prompt\")) : ((((this.state == \"explain\")) && (this.trigger(\"uiHelpPipExplainClicked\"), this.dismiss())))));\n        }, this.showState = function(a, b) {\n            if (((((a == \"JSBNG__prompt\")) && !this.pip.html.JSBNG__prompt))) {\n                return this.showState(\"explain\", b);\n            }\n        ;\n        ;\n            b = ((b || this.$streamItem));\n            if (((this.state == a))) {\n                return;\n            }\n        ;\n        ;\n            ((((((this.state == \"icon\")) && ((((a == \"JSBNG__prompt\")) || ((a == \"explain\")))))) && this.trigger(\"uiHelpPipOpened\", {\n                pip: this.pip\n            }))), ((((this.$streamItem[0] != b[0])) && this.unhighlight())), this.state = a, this.$streamItem = b;\n            var c = this.$pip.JSBNG__find(\".js-pip\");\n            c.prependTo(this.$pip.parent()).fadeOut(\"fast\", function() {\n                c.remove();\n                var b = this.pip.html[a], d = this.pip[((a + \"Highlight\"))];\n                this.$pip.html(b).fadeIn(\"fast\"), ((((d && ((d != \"remove\")))) ? this.highlight(d) : this.unhighlight(((d == \"remove\")))));\n            }.bind(this)), this.$pip.hide().prependTo(b);\n        }, this.dismiss = function() {\n            ((this.$streamItem && this.unhighlight())), this.$pip.fadeOut(function() {\n                this.remove(), this.teardown(), this.trigger(\"uiHelpPipDismissed\");\n            }.bind(this));\n        }, this.highlight = function(a) {\n            if (this.$streamItem.JSBNG__find(a).is(\".stork-highlighted\")) {\n                return;\n            }\n        ;\n        ;\n            this.unhighlight(), this.$streamItem.JSBNG__find(a).each(function() {\n                var a = $(this), b = $(\"\\u003Cspan\\u003E\").addClass(\"stork-highlight-background\"), c = $(\"\\u003Cspan\\u003E\").addClass(\"stork-highlight-container\").css({\n                    width: a.JSBNG__outerWidth(),\n                    height: a.JSBNG__outerHeight()\n                });\n                a.wrap(c).before(b).addClass(\"stork-highlighted\"), b.fadeIn();\n            });\n        }, this.unhighlight = function(a) {\n            this.$streamItem.JSBNG__find(\".stork-highlighted\").each(function() {\n                var b = $(this), c = b.parent().JSBNG__find(\".stork-highlight-background\"), d = function() {\n                    c.remove(), b.unwrap();\n                };\n                b.removeClass(\"stork-highlighted\"), ((a ? d() : c.fadeOut(d)));\n            });\n        }, this.remove = function() {\n            this.$pip.remove();\n        }, this.after(\"initialize\", function(a) {\n            this.state = \"icon\", this.pip = a.pip, this.$streamItem = a.$streamItem, this.$pip = $(\"\\u003Cdiv\\u003E\\u003C/div\\u003E\").html(this.pip.html.icon), this.$pip.hide().prependTo(this.$streamItem).fadeIn(\"fast\"), this.JSBNG__on(this.$pip, \"click\", this.clicked), this.trigger(\"uiHelpPipIconAdded\"), this.JSBNG__on(JSBNG__document, \"uiBeforePageChanged\", this.remove), ((this.pip.explainOn && (((((typeof this.pip.explainOn == \"string\")) && (this.pip.explainOn = {\n                JSBNG__event: this.pip.explainOn\n            }))), ((this.pip.explainOn.selector ? this.JSBNG__on(this.$node.JSBNG__find(this.pip.explainOn.selector), this.pip.explainOn.JSBNG__event, this.explainTriggered) : this.JSBNG__on(this.pip.explainOn.JSBNG__event, this.explainTriggered)))))), ((this.pip.dismissOn && (((((typeof this.pip.dismissOn == \"string\")) && (this.pip.dismissOn = {\n                JSBNG__event: this.pip.dismissOn\n            }))), ((this.pip.dismissOn.selector ? this.JSBNG__on(this.$node.JSBNG__find(this.pip.dismissOn.selector), this.pip.dismissOn.JSBNG__event, this.dismissTriggered) : this.JSBNG__on(this.pip.dismissOn.JSBNG__event, this.dismissTriggered))))));\n        });\n    };\n;\n    var defineComponent = require(\"core/component\");\n    module.exports = defineComponent(helpPip);\n});\ndefine(\"app/ui/help_pips_injector\", [\"module\",\"require\",\"exports\",\"core/component\",\"app/ui/help_pip\",\"app/utils/storage/core\",], function(module, require, exports) {\n    function helpPipsInjector() {\n        this.defaultAttrs({\n            pipSelector: \".js-pip\",\n            tweetSelector: \".js-stream-item\"\n        }), this.pipsLoaded = function(a, b) {\n            this.pips = b.pips, this.injectPips();\n        }, this.tweetsDisplayed = function(a) {\n            this.injectPips();\n        }, this.pipOpened = function(a, b) {\n            this.storage.setItem(b.pip.category, !0);\n        }, this.pipDismissed = function(a) {\n            this.injectPips();\n        }, this.injectPips = function() {\n            if (!this.pips) {\n                return;\n            }\n        ;\n        ;\n            if (this.select(\"pipSelector\").length) {\n                return;\n            }\n        ;\n        ;\n            var a = this.pips.filter(function(a) {\n                return !this.storage.getItem(a.category);\n            }.bind(this)), b = this.select(\"tweetSelector\").slice(0, 10);\n            b.each(function(b, c) {\n                var d = $(c), e = !1;\n                if (((d.attr(\"data-promoted\") || ((d.JSBNG__find(\"[data-promoted]\").length > 0))))) {\n                    return;\n                }\n            ;\n            ;\n                $.each(a, function(a, b) {\n                    if (d.JSBNG__find(b.matcher).length) {\n                        return HelpPip.attachTo(this.$node, {\n                            $streamItem: d,\n                            pip: b,\n                            eventData: {\n                                scribeContext: {\n                                    component: \"stork\",\n                                    element: b.id\n                                }\n                            }\n                        }), e = !0, !1;\n                    }\n                ;\n                ;\n                }.bind(this));\n                if (e) {\n                    return !1;\n                }\n            ;\n            ;\n            }.bind(this));\n        }, this.after(\"initialize\", function() {\n            this.deferredDisplays = [], this.storage = new JSBNG__Storage(\"help_pips\"), this.JSBNG__on(JSBNG__document, \"uiTweetsDisplayed\", this.tweetsDisplayed), this.JSBNG__on(JSBNG__document, \"dataHelpPipsLoaded\", this.pipsLoaded), this.JSBNG__on(\"uiHelpPipDismissed\", this.pipDismissed), this.JSBNG__on(\"uiHelpPipOpened\", this.pipOpened);\n        });\n    };\n;\n    var defineComponent = require(\"core/component\"), HelpPip = require(\"app/ui/help_pip\"), JSBNG__Storage = require(\"app/utils/storage/core\");\n    module.exports = defineComponent(helpPipsInjector);\n});\ndefine(\"app/boot/help_pips\", [\"module\",\"require\",\"exports\",\"app/utils/cookie\",\"app/utils/storage/core\",\"app/boot/help_pips_enable\",\"app/data/help_pips\",\"app/data/help_pips_scribe\",\"app/ui/help_pips_injector\",], function(module, require, exports) {\n    function initialize(a) {\n        var b = new JSBNG__Storage(\"help_pips\"), c = +(new JSBNG__Date);\n        ((cookie(\"help_pips\") && enableHelpPips())), ((((((b.getItem(\"until\") || 0)) > c)) && (HelpPipsData.attachTo(JSBNG__document), HelpPipsInjector.attachTo(\"#timeline\"), HelpPipsScribe.attachTo(JSBNG__document))));\n    };\n;\n    var cookie = require(\"app/utils/cookie\"), JSBNG__Storage = require(\"app/utils/storage/core\"), enableHelpPips = require(\"app/boot/help_pips_enable\"), HelpPipsData = require(\"app/data/help_pips\"), HelpPipsScribe = require(\"app/data/help_pips_scribe\"), HelpPipsInjector = require(\"app/ui/help_pips_injector\");\n    module.exports = initialize;\n});\ndefine(\"app/ui/expando/close_all_button\", [\"module\",\"require\",\"exports\",\"core/component\",], function(module, require, exports) {\n    function closeAllButton() {\n        this.incrementOpenCount = function() {\n            this.toggleButton(++this.openCount);\n        }, this.decrementOpenCount = function() {\n            this.toggleButton(--this.openCount);\n        }, this.toggleButton = function(a) {\n            this.$node[((((a > 0)) ? \"fadeIn\" : \"fadeOut\"))](200);\n        }, this.broadcastClose = function(a) {\n            a.preventDefault(), this.trigger(this.attr.where, this.attr.closeAllEvent);\n        }, this.readOpenCountFromTimeline = function() {\n            this.openCount = $(this.attr.where).JSBNG__find(\".open\").length, this.toggleButton(this.openCount);\n        }, this.hide = function() {\n            this.$node.hide();\n        }, this.after(\"initialize\", function(a) {\n            this.openCount = 0, this.JSBNG__on(JSBNG__document, \"uiSwiftLoaded uiPageChanged\", this.readOpenCountFromTimeline), this.JSBNG__on(a.where, a.addEvent, this.incrementOpenCount), this.JSBNG__on(a.where, a.subtractEvent, this.decrementOpenCount), this.JSBNG__on(\"click\", this.broadcastClose), this.JSBNG__on(JSBNG__document, \"uiShortcutCloseAll\", this.broadcastClose), this.JSBNG__on(JSBNG__document, \"uiBeforePageChanged\", this.hide);\n        });\n    };\n;\n    var defineComponent = require(\"core/component\");\n    module.exports = defineComponent(closeAllButton);\n});\ndefine(\"app/ui/timelines/with_keyboard_navigation\", [\"module\",\"require\",\"exports\",], function(module, require, exports) {\n    function withKeyboardNavigation() {\n        this.defaultAttrs({\n            selectedClass: \"selected-stream-item\",\n            selectedSelector: \".selected-stream-item\",\n            unselectableClass: \"js-unselectable-stream-item\",\n            firstItemSelector: \".js-stream-item:first-child:not(.js-unselectable-stream-item)\",\n            ownTweetSelector: \".my-tweet\",\n            replyLinkSelector: \"div.tweet ul.js-actions a.js-action-reply\",\n            profileCardSelector: \".profile-card\",\n            streamTweetSelector: \".js-stream-tweet\",\n            activityMentionClass: \"js-activity-mention\",\n            activityReplyClass: \"js-activity-reply\",\n            pushStateSelector: \"a.js-nav\",\n            navigationActiveClass: \"js-navigation-active\"\n        }), this.moveSelection = function(a) {\n            var b = $(a.target);\n            if (b.closest(this.attr.selectedSelector).length) {\n                return;\n            }\n        ;\n        ;\n            var c;\n            ((b.closest(\".js-expansion-container\") ? c = b.closest(\"li\") : c = b.closest(this.attr.genericItemSelector))), ((b.closest(this.attr.pushStateSelector).length && (this.$linkClicked = c, JSBNG__clearTimeout(this.linkTimer), this.linkTimer = JSBNG__setTimeout(function() {\n                this.$linkClicked = $();\n            }.bind(this), 0)))), ((this.$selected.length && this.selectItem(c)));\n        }, this.clearSelection = function() {\n            this.$selected.removeClass(this.attr.selectedClass), this.$selected = $();\n        }, this.selectTopItem = function() {\n            this.clearSelection(), this.trigger(\"uiInjectNewItems\"), this.selectAdjacentItem(\"next\");\n        }, this.injectAndPossiblySelectTopItem = function() {\n            var a = this.$selected.length;\n            ((a && this.clearSelection())), this.trigger(\"uiInjectNewItems\"), ((a && this.selectAdjacentItem(\"next\")));\n        }, this.selectPrevItem = function() {\n            this.selectAdjacentItem(\"prev\");\n        }, this.selectNextItem = function(a, b) {\n            this.selectAdjacentItem(\"next\", b);\n        }, this.selectNextItemNotFrom = function(a) {\n            var b = \"next\", c = this.$selected;\n            while (((this.getUserId() == a))) {\n                this.selectAdjacentItem(b);\n                if (((c == this.$selected))) {\n                    if (((b != \"next\"))) {\n                        return;\n                    }\n                ;\n                ;\n                    b = \"prev\";\n                }\n                 else c = this.$selected;\n            ;\n            ;\n            };\n        ;\n        }, this.getAdjacentParentItem = function(a, b) {\n            var c = a.closest(\".js-navigable-stream\"), d = a;\n            if (c.length) {\n                a = c.closest(\".stream-item\"), d = a[b]();\n                if (!d.length) {\n                    return this.getAdjacentParentItem(a, b);\n                }\n            ;\n            ;\n            }\n        ;\n        ;\n            return d;\n        }, this.getAdjacentChildItem = function(a, b) {\n            var c = a, d = c.hasClass(\"js-has-navigable-stream\"), e = ((((b == \"next\")) ? \"first-child\" : \"last-child\"));\n            return ((((c.length && d)) ? (c = c.JSBNG__find(\".js-navigable-stream\").eq(0).JSBNG__find(((\"\\u003Eli:\" + e))), this.getAdjacentChildItem(c, b)) : c));\n        }, this.selectAdjacentItem = function(a, b) {\n            var c;\n            ((this.$selected.length ? c = this.$selected[a]() : c = this.select(\"firstItemSelector\").eq(0))), ((c.length || (c = this.getAdjacentParentItem(this.$selected, a)))), c = this.getAdjacentChildItem(c, a);\n            if (((c.length && c.hasClass(this.attr.unselectableClass)))) {\n                return this.$selected = c, this.selectAdjacentItem(a, b);\n            }\n        ;\n        ;\n            this.selectItem(c), this.setARIALabel(), this.focusSelected(), ((((c.length && ((!b || !b.maintainPosition)))) && this.adjustScrollForSelectedItem()));\n            var d = ((((a == \"next\")) ? \"uiNextItemSelected\" : \"uiPreviousItemSelected\"));\n            this.trigger(this.$selected, d);\n        }, this.selectItem = function(a) {\n            var b = this.$selected;\n            if (((!a.length || ((b == a))))) {\n                return;\n            }\n        ;\n        ;\n            this.$selected = a, this.$node.JSBNG__find(this.attr.selectedSelector).removeClass(this.attr.selectedClass), b.removeClass(this.attr.selectedClass), b.removeAttr(\"tabIndex\"), b.removeAttr(\"aria-labelledby\"), this.$selected.addClass(this.attr.selectedClass);\n        }, this.setARIALabel = function() {\n            var a = this.$selected.JSBNG__find(\".tweet\"), b = ((a.attr(\"id\") || ((\"tweet-\" + a.attr(\"data-tweet-id\"))))), c = [], d = [\".stream-item-header\",\".tweet-text\",\".context\",];\n            ((a.hasClass(\"favorited\") && d.push(\".tweet-actions .unfavorite\"))), ((a.hasClass(\"retweeted\") && d.push(\".tweet-actions .undo-retweet\"))), d.push(\".expanded-content\"), a.JSBNG__find(d.join()).each(function(a, d) {\n                var e = d.id;\n                ((e || (e = ((((b + \"-\")) + a)), d.setAttribute(\"id\", e)))), c.push(e);\n            }), this.$selected.attr(\"aria-labelledby\", c.join(\" \"));\n        }, this.focusSelected = function() {\n            this.$selected.attr(\"tabIndex\", -1).JSBNG__focus();\n        }, this.deselect = function(a) {\n            var b = (([\"HTML\",\"BODY\",].indexOf(a.target.tagName) != -1)), c = ((((a.target.id == \"page-outer\")) && !$(a.target).parents(\"#page-container\").length));\n            ((((b || c)) && this.clearSelection()));\n        }, this.favoriteItem = function() {\n            this.trigger(this.$selected, \"uiDidFavoriteTweetToggle\");\n        }, this.retweetItem = function() {\n            ((this.itemSelectedIsMine() || this.trigger(this.$selected, \"uiDidRetweetTweetToggle\")));\n        }, this.replyItem = function() {\n            var a = this.$selected.JSBNG__find(this.attr.replyLinkSelector).first();\n            this.trigger(a, \"uiDidReplyTweetToggle\");\n        }, this.blockUser = function() {\n            this.takeAction(\"uiOpenBlockUserDialog\");\n        }, this.unblockUser = function() {\n            this.takeAction(\"uiUnblockAction\");\n        }, this.takeAction = function(a) {\n            ((((!this.itemSelectedIsMine() && this.itemSelectedIsBlockable())) && this.trigger(this.$selected, a, {\n                userId: this.getUserId(),\n                username: this.getUsername(),\n                fromShortcut: !0\n            })));\n        }, this.getUserId = function() {\n            return this.$selected.JSBNG__find(this.attr.streamTweetSelector).attr(\"data-user-id\");\n        }, this.getUsername = function() {\n            return this.$selected.JSBNG__find(this.attr.streamTweetSelector).attr(\"data-name\");\n        }, this.itemSelectedIsMine = function() {\n            return (($(this.$selected).JSBNG__find(this.attr.ownTweetSelector).length > 0));\n        }, this.itemSelectedIsBlockable = function() {\n            return (((((($(this.$selected).children(this.attr.streamTweetSelector).length > 0)) || $(this.$selected).hasClass(this.attr.activityReplyClass))) || $(this.$selected).hasClass(this.attr.activityMentionClass)));\n        }, this.updateAfterBlock = function(a, b) {\n            (((($(this.attr.profileCardSelector).size() === 0)) && (this.selectNextItemNotFrom(b.userId), this.trigger(\"uiRemoveTweetsFromUser\", b))));\n        }, this.adjustScrollForItem = function(a) {\n            ((a.length && $(window).scrollTop(((a.offset().JSBNG__top - (($(window).height() / 2)))))));\n        }, this.notifyExpansionRequest = function() {\n            this.trigger(this.$selected, \"uiShouldToggleExpandedState\");\n        }, this.adjustScrollForSelectedItem = function() {\n            this.adjustScrollForItem(this.$selected);\n        }, this.processActiveNavigation = function() {\n            var a = 2;\n            JSBNG__setTimeout(this.removeActiveNavigationClass.bind(this), ((a * 1000)));\n        }, this.setNavigationActive = function() {\n            this.$linkClicked.addClass(this.attr.navigationActiveClass);\n        }, this.removeActiveNavigationClass = function() {\n            var a = this.$node.JSBNG__find(((\".\" + this.attr.navigationActiveClass)));\n            a.removeClass(this.attr.navigationActiveClass);\n        }, this.handleEvent = function(a) {\n            return function() {\n                (($(\"body\").hasClass(\"modal-enabled\") || this[a].apply(this, arguments)));\n            };\n        }, this.changeSelection = function(a, b) {\n            var c = $(a.target);\n            ((this.$selected.length && (this.selectItem(c), ((((b && b.setFocus)) && (this.setARIALabel(), this.focusSelected()))))));\n        }, this.after(\"initialize\", function() {\n            this.$selected = this.$node.JSBNG__find(this.attr.selectedSelector), this.$linkClicked = $(), this.JSBNG__on(JSBNG__document, \"uiShortcutSelectPrev\", this.handleEvent(\"selectPrevItem\")), this.JSBNG__on(JSBNG__document, \"uiShortcutSelectNext uiSelectNext\", this.handleEvent(\"selectNextItem\")), this.JSBNG__on(JSBNG__document, \"uiSelectItem\", this.handleEvent(\"changeSelection\")), this.JSBNG__on(JSBNG__document, \"uiShortcutEnter\", this.handleEvent(\"notifyExpansionRequest\")), this.JSBNG__on(JSBNG__document, \"uiShortcutGotoTopOfScreen uiSelectTopTweet\", this.handleEvent(\"selectTopItem\")), this.JSBNG__on(JSBNG__document, \"uiGotoTopOfScreen\", this.handleEvent(\"injectAndPossiblySelectTopItem\")), this.JSBNG__on(JSBNG__document, \"uiShortcutFavorite\", this.handleEvent(\"favoriteItem\")), this.JSBNG__on(JSBNG__document, \"uiShortcutRetweet\", this.handleEvent(\"retweetItem\")), this.JSBNG__on(JSBNG__document, \"uiShortcutReply\", this.handleEvent(\"replyItem\")), this.JSBNG__on(JSBNG__document, \"uiShortcutBlock\", this.handleEvent(\"blockUser\")), this.JSBNG__on(JSBNG__document, \"uiShortcutUnblock\", this.handleEvent(\"unblockUser\")), this.JSBNG__on(JSBNG__document, \"uiUpdateAfterBlock\", this.updateAfterBlock), this.JSBNG__on(JSBNG__document, \"uiRemovedSomeTweets\", this.adjustScrollForSelectedItem), this.JSBNG__on(JSBNG__document, \"uiBeforePageChanged uiClearSelection\", this.clearSelection), this.JSBNG__on(JSBNG__document, \"uiPageChanged\", this.processActiveNavigation), this.JSBNG__on(\"click\", {\n                genericItemSelector: this.moveSelection\n            }), this.JSBNG__on(JSBNG__document, \"uiNavigate\", this.setNavigationActive), this.JSBNG__on(JSBNG__document, \"click\", this.deselect);\n        });\n    };\n;\n    module.exports = withKeyboardNavigation;\n});\ndefine(\"app/ui/with_focus_highlight\", [\"module\",\"require\",\"exports\",], function(module, require, exports) {\n    function focusHighlight() {\n        this.defaultAttrs({\n            focusClass: \"JSBNG__focus\",\n            focusContainerSelector: \".tweet\"\n        }), this.addFocusStyle = function(a, b) {\n            $(b.el).addClass(this.attr.focusClass);\n        }, this.removeFocusStyle = function(a, b) {\n            JSBNG__setTimeout(function() {\n                var a = b.el, c = JSBNG__document.activeElement;\n                ((((!$.contains(a, c) && ((a != c)))) && $(a).removeClass(this.attr.focusClass)));\n            }.bind(this), 0);\n        }, this.after(\"initialize\", function() {\n            this.JSBNG__on(\"focusin\", {\n                focusContainerSelector: this.addFocusStyle\n            }), this.JSBNG__on(\"focusout\", {\n                focusContainerSelector: this.removeFocusStyle\n            });\n        });\n    };\n;\n    module.exports = focusHighlight;\n});\ndefine(\"app/ui/timelines/with_base_timeline\", [\"module\",\"require\",\"exports\",\"app/ui/timelines/with_keyboard_navigation\",\"app/ui/with_interaction_data\",\"app/utils/scribe_event_initiators\",\"app/ui/with_focus_highlight\",\"core/compose\",\"app/utils/animate_window_scrolltop\",], function(module, require, exports) {\n    function withBaseTimeline() {\n        compose.mixin(this, [withKeyboardNavigation,withInteractionData,withFocusHighLight,]), this.defaultAttrs({\n            containerSelector: \".stream-container\",\n            itemsSelector: \"#stream-items-id\",\n            genericItemSelector: \".js-stream-item\",\n            timelineEndSelector: \".timeline-end\",\n            backToTopSelector: \".back-to-top\",\n            lastItemSelector: \".stream-item:last\",\n            streamItemContentsSelector: \".js-actionable-tweet, .js-actionable-user, .js-activity, .js-story-item\"\n        }), this.findFirstItemContent = function(a) {\n            var b = a.JSBNG__find(this.attr.streamItemContentsSelector);\n            return b = b.not(\".conversation-tweet\"), $(b[0]);\n        }, this.injectItems = function(a, b, c, d) {\n            var e = $(\"\\u003Cdiv/\\u003E\").html(b).children();\n            return ((((e.length > 0)) && this.select(\"timelineEndSelector\").addClass(\"has-items\"))), this.select(\"itemsSelector\")[a](e), this.reportInjectedItems(e, c, d), e;\n        }, this.removeDuplicates = function(a) {\n            var b = [];\n            return a.filter(function(a) {\n                return ((a.tweetId ? ((((b.indexOf(a.tweetId) === -1)) ? (b.push(a.tweetId), !0) : !1)) : !0));\n            });\n        }, this.reportInjectedItems = function(a, b, c) {\n            var d = [];\n            a.each(function(a, c) {\n                if (((((((b === \"uiHasInjectedNewTimeline\")) || ((b === \"uiHasInjectedOldTimelineItems\")))) || ((b === \"uiHasInjectedRangeTimelineItems\"))))) {\n                    d = d.concat(this.extraInteractionData($(c))), d.push(this.interactionData(this.findFirstItemContent($(c))));\n                }\n            ;\n            ;\n                this.trigger(c, \"uiHasInjectedTimelineItem\");\n            }.bind(this)), d = this.removeDuplicates(d);\n            var e = {\n            };\n            if (((((((b === \"uiHasInjectedNewTimeline\")) || ((b === \"uiHasInjectedOldTimelineItems\")))) || ((b === \"uiHasInjectedRangeTimelineItems\"))))) {\n                e = {\n                    scribeContext: {\n                        component: ((this.attr.itemType && ((this.attr.itemType + \"_stream\"))))\n                    },\n                    scribeData: {\n                    },\n                    items: d\n                }, ((((c && c.autoplay)) && (e.scribeData.event_initiator = eventInitiators.clientSideApp)));\n            }\n        ;\n        ;\n            this.trigger(\"uiWantsToRefreshTimestamps\"), this.trigger(b, e);\n        }, this.inspectItemsFromServer = function(a, b) {\n            ((this.isOldItem(b) ? this.injectOldItems(b) : ((this.isNewItem(b) ? this.notifyNewItems(b) : ((this.wasRangeRequest(b) && this.injectRangeItems(b)))))));\n        }, this.investigateDataError = function(a, b) {\n            var c = b.sourceEventData;\n            if (!c) {\n                return;\n            }\n        ;\n        ;\n            ((this.wasRangeRequest(c) ? this.notifyRangeItemsError(b) : ((this.wasNewItemsRequest(c) || ((this.wasOldItemsRequest(c) && this.notifyOldItemsError(b)))))));\n        }, this.possiblyShowBackToTop = function() {\n            var a = this.select(\"lastItemSelector\").position();\n            ((((a && ((a.JSBNG__top >= $(window).height())))) && this.select(\"backToTopSelector\").show()));\n        }, this.scrollToTop = function() {\n            animateWinScrollTop(0, \"fast\");\n        }, this.getTimelinePosition = function(a) {\n            return a.closest(this.attr.genericItemSelector).index();\n        }, this.after(\"initialize\", function(a) {\n            this.JSBNG__on(\"dataGotMoreTimelineItems\", this.inspectItemsFromServer), this.JSBNG__on(\"dataGotMoreTimelineItemsError\", this.investigateDataError), this.JSBNG__on(\"click\", {\n                backToTopSelector: this.scrollToTop\n            }), this.possiblyShowBackToTop();\n        });\n    };\n;\n    var withKeyboardNavigation = require(\"app/ui/timelines/with_keyboard_navigation\"), withInteractionData = require(\"app/ui/with_interaction_data\"), eventInitiators = require(\"app/utils/scribe_event_initiators\"), withFocusHighLight = require(\"app/ui/with_focus_highlight\"), compose = require(\"core/compose\"), animateWinScrollTop = require(\"app/utils/animate_window_scrolltop\");\n    module.exports = withBaseTimeline;\n});\ndefine(\"app/ui/timelines/with_old_items\", [\"module\",\"require\",\"exports\",], function(module, require, exports) {\n    function withOldItems() {\n        this.defaultAttrs({\n            endOfStreamSelector: \".stream-footer\",\n            errorMessageSelector: \".stream-fail-container\",\n            tryAgainSelector: \".try-again-after-whale\",\n            allowInfiniteScroll: !0\n        }), this.getOldItems = function() {\n            ((((this.shouldGetOldItems() && !this.requestInProgress)) && (this.requestInProgress = !0, this.trigger(\"uiWantsMoreTimelineItems\", this.getOldItemsData()))));\n        }, this.injectOldItems = function(a) {\n            this.hideWhaleEnd(), this.resetStateVariables(a), ((a.has_more_items ? this.showMoreSpinner() : this.hideMoreSpinner()));\n            var b = this.$document.height();\n            this.injectItems(((this.attr.isBackward ? \"prepend\" : \"append\")), a.items_html, \"uiHasInjectedOldTimelineItems\"), ((this.attr.isBackward ? (this.$window.scrollTop(((this.$document.height() - b))), ((a.has_more_items || this.select(\"endOfStreamSelector\").remove()))) : this.possiblyShowBackToTop())), this.requestInProgress = !1;\n        }, this.notifyOldItemsError = function(a) {\n            this.showWhaleEnd(), this.requestInProgress = !1;\n        }, this.showWhaleEnd = function() {\n            this.select(\"errorMessageSelector\").show(), this.select(\"endOfStreamSelector\").hide();\n        }, this.hideWhaleEnd = function() {\n            this.select(\"errorMessageSelector\").hide(), this.select(\"endOfStreamSelector\").show();\n        }, this.showMoreSpinner = function() {\n            this.select(\"timelineEndSelector\").addClass(\"has-more-items\");\n        }, this.hideMoreSpinner = function() {\n            this.select(\"timelineEndSelector\").removeClass(\"has-more-items\");\n        }, this.tryAgainAfterWhale = function(a) {\n            a.preventDefault(), this.hideWhaleEnd(), this.getOldItems();\n        }, this.after(\"initialize\", function(a) {\n            this.requestInProgress = !1, ((this.attr.allowInfiniteScroll && this.JSBNG__on(window, ((this.attr.isBackward ? \"uiNearTheTop\" : \"uiNearTheBottom\")), this.getOldItems))), this.$document = $(JSBNG__document), this.$window = $(window), this.JSBNG__on(\"click\", {\n                tryAgainSelector: this.tryAgainAfterWhale\n            });\n        });\n    };\n;\n    module.exports = withOldItems;\n});\ndefine(\"app/utils/chrome\", [\"module\",\"require\",\"exports\",], function(module, require, exports) {\n    var chrome = {\n        globalYOffset: null,\n        selectors: {\n            globalNav: \".global-nav\"\n        },\n        getGlobalYOffset: function() {\n            return ((((chrome.globalYOffset === null)) && (chrome.globalYOffset = $(chrome.selectors.globalNav).height()))), chrome.globalYOffset;\n        },\n        getCanvasYOffset: function(a) {\n            return ((a.offset().JSBNG__top - chrome.getGlobalYOffset()));\n        }\n    };\n    module.exports = chrome;\n});\ndefine(\"app/ui/timelines/with_traveling_ptw\", [\"module\",\"require\",\"exports\",], function(module, require, exports) {\n    function withTravelingPTw() {\n        this.closePromotedItem = function(a) {\n            ((a.hasClass(\"open\") && this.trigger(a, \"uiShouldToggleExpandedState\", {\n                noAnimation: !0\n            })));\n        }, this.transferClass = function(a, b, c) {\n            ((a.hasClass(b) && (a.removeClass(b), c.addClass(b))));\n        }, this.repositionPromotedItem = function(a) {\n            var b = this.$promotedItem;\n            this.transferClass(b, \"before-expanded\", b.prev()), this.transferClass(b, \"after-expanded\", b.next()), a.call(this, b.detach()), this.transferClass(b.next(), \"after-expanded\", \"prev\");\n        }, this.after(\"initialize\", function(a) {\n            this.travelingPromoted = a.travelingPromoted, this.$promotedItem = this.$node.JSBNG__find(\".promoted-tweet\").first().closest(\".stream-item\");\n        }), this.movePromotedToTop = function() {\n            if (this.autoplay) {\n                return;\n            }\n        ;\n        ;\n            this.repositionPromotedItem(function(a) {\n                var b = this.$node.JSBNG__find(this.attr.streamItemsSelector).children().first();\n                b[((b.hasClass(\"open\") ? \"after\" : \"before\"))](a);\n            });\n        };\n    };\n;\n    module.exports = withTravelingPTw;\n});\ndefine(\"app/ui/timelines/with_autoplaying_timeline\", [\"module\",\"require\",\"exports\",\"core/compose\",\"app/utils/chrome\",\"app/ui/timelines/with_traveling_ptw\",\"app/utils/animate_window_scrolltop\",], function(module, require, exports) {\n    function withAutoplayingTimeline() {\n        compose.mixin(this, [withTravelingPTw,]);\n        var a = 700, b = 750, c = 300;\n        this.defaultAttrs({\n            autoplayControlSelector: \".autoplay-control .play-pause\",\n            streamItemsSelector: \".stream-items\",\n            socialProofSelector: \".tweet-stats-container\",\n            autoplayMarkerSelector: \".stream-autoplay-marker\",\n            notificationBarOpacity: 94796\n        }), this.autoplayNewItems = function(a, b) {\n            if (!a) {\n                return;\n            }\n        ;\n        ;\n            var c = this.$window.scrollTop(), d = ((c + this.$window.height())), e = ((this.$promotedItem.length && ((this.$promotedItem.offset().JSBNG__top > d)))), f = this.injectNewItems({\n            }, {\n                autoplay: !0\n            });\n            ((((this.travelingPTw && e)) && this.repositionPromotedItem(function(a) {\n                f.first().before(a), f = f.add(a), this.trigger(a, \"uiShouldFixMargins\");\n            })));\n            var g = f.first().offset().JSBNG__top, h = ((((g > c)) && ((g < d)))), i = this.$container.offset().JSBNG__top, j = ((((f.last().next().offset().JSBNG__top - i)) + 1));\n            if (h) this.$container.css(\"marginTop\", -j), this.animateBlockOfItems(f);\n             else {\n                var k = chrome.getGlobalYOffset(), l = ((this.$notification.is(\":visible\") ? k : -100));\n                this.showingAutoplayMarker = !1, this.setScrollerScrollTop(((c + j))), this.$notification.show().JSBNG__find(\".text\").text($(a).text()).end().css({\n                    JSBNG__top: l,\n                    opacity: this.attr.notificationBarOpacity\n                }).animate({\n                    JSBNG__top: k\n                }, {\n                    duration: 500,\n                    complete: function() {\n                        var a = this.newItemsXLine;\n                        this.newItemsXLine = ((((a > 0)) ? ((a + j)) : ((i + j)))), this.showingAutoplayMarker = !0, this.latentItems.count = b;\n                    }.bind(this)\n                });\n            }\n        ;\n        ;\n        }, this.animateBlockOfItems = function(b) {\n            var c = this.$window.scrollTop(), d = parseFloat(this.$container.css(\"marginTop\")), e = -b.first().position().JSBNG__top;\n            this.isAnimating = !0, this.$container.parent().css(\"overflow\", \"hidden\"), this.$container.animate({\n                marginTop: 0\n            }, {\n                duration: ((a + Math.abs(d))),\n                step: function(a) {\n                    ((this.lockedTimelineScroll && this.setScrollerScrollTop(((c + Math.abs(((d - Math.ceil(a)))))))));\n                }.bind(this),\n                complete: function() {\n                    this.$container.parent().css(\"overflow\", \"inherit\"), this.isAnimating = !1, this.afterAnimationQueue.forEach(function(a) {\n                        a.call(this);\n                    }, this), this.afterAnimationQueue = [];\n                }.bind(this)\n            });\n        }, this.handleSocialProofPops = function(a) {\n            var b = $(a.target).closest(\".stream-item\");\n            if (((this.lastClickedItem && ((b[0] === this.lastClickedItem))))) {\n                return;\n            }\n        ;\n        ;\n            var c = $(a.target).JSBNG__find(this.attr.socialProofSelector).hide(), d = function() {\n                var a = b.next().offset().JSBNG__top;\n                c.show();\n                var d = b.next().offset().JSBNG__top, e = this.$window.scrollTop();\n                ((((this.lockedTimelineScroll || ((e > d)))) && this.setScrollerScrollTop(((e + ((d - a)))))));\n            }.bind(this);\n            ((this.isAnimating ? this.afterAnimationQueue.push(d) : d()));\n        }, this.animateScrollToTop = function() {\n            var a = ((this.$container.offset().JSBNG__top - 150)), d = {\n                duration: b\n            };\n            ((this.attr.overflowScroll ? this.$node.animate({\n                scrollTop: a\n            }, d) : animateWinScrollTop(a, d))), this.$notification.animate({\n                JSBNG__top: -200,\n                opacity: 0\n            }, {\n                duration: c\n            });\n        }, this.setScrollerScrollTop = function(a) {\n            var b = ((this.attr.overflowScroll ? this.$node : $(window)));\n            b.scrollTop(a);\n        }, this.removeAutoplayMarkerOnScroll = function() {\n            var a, b = function() {\n                ((this.showingAutoplayMarker ? (this.showingAutoplayMarker = !1, this.$notification.fadeOut(200)) : ((((((this.newItemsXLine > 0)) && ((this.$window.scrollTop() < this.newItemsXLine)))) && (this.newItemsXLine = 0, this.latentItems.count = 0)))));\n            }.bind(this);\n            this.$window.JSBNG__scroll(function(c) {\n                if (!this.autoplay) {\n                    return;\n                }\n            ;\n            ;\n                JSBNG__clearTimeout(a), a = JSBNG__setTimeout(b, 0);\n            }.bind(this));\n        }, this.toggleAutoplay = function(a) {\n            $(\".tooltip\").remove(), (($(a.target).parent().toggleClass(\"paused\").hasClass(\"paused\") ? this.disableAutoplay() : this.reenableAutoplay()));\n        }, this.disableAutoplay = function() {\n            this.autoplay = !1, this.trigger(\"uiHasDisabledAutoplay\");\n        }, this.reenableAutoplay = function() {\n            this.autoplay = !0, this.lockedTimelineScroll = !1, this.trigger(\"uiHasEnabledAutoplay\");\n            var a = this.select(\"newItemsBarSelector\");\n            a.animate({\n                marginTop: -a.JSBNG__outerHeight(),\n                opacity: 0\n            }, {\n                duration: 225,\n                complete: this.autoplayNewItems.bind(this, a.html())\n            });\n        }, this.enableAutoplay = function(a) {\n            this.autoplay = !0, this.travelingPTw = a.travelingPTw, this.lockedTimelineScroll = !1, this.afterAnimationQueue = [], this.newItemsXLine = 0, this.$container = this.select(\"streamItemsSelector\"), this.$notification = this.select(\"autoplayMarkerSelector\"), this.$window = ((a.overflowScroll ? this.$node : $(window))), this.JSBNG__on(\"mouseover\", function() {\n                this.lockedTimelineScroll = !0;\n            }), this.JSBNG__on(\"mouseleave\", function() {\n                this.lockedTimelineScroll = !1;\n            }), this.JSBNG__on(\"uiHasRenderedTweetSocialProof\", this.handleSocialProofPops), this.JSBNG__on(\"uiHasExpandedTweet\", function(a) {\n                this.lastClickedItem = $(a.target).data(\"expando\").$container.get(0);\n            }), this.JSBNG__on(\"click\", {\n                autoplayControlSelector: this.toggleAutoplay,\n                autoplayMarkerSelector: this.animateScrollToTop\n            }), this.removeAutoplayMarkerOnScroll(), this.$notification.width(this.$notification.width()).css(\"position\", \"fixed\");\n        }, this.after(\"initialize\", function(a) {\n            ((a.autoplay && this.enableAutoplay(a)));\n        });\n    };\n;\n    var compose = require(\"core/compose\"), chrome = require(\"app/utils/chrome\"), withTravelingPTw = require(\"app/ui/timelines/with_traveling_ptw\"), animateWinScrollTop = require(\"app/utils/animate_window_scrolltop\");\n    module.exports = withAutoplayingTimeline;\n});\ndefine(\"app/ui/timelines/with_polling\", [\"module\",\"require\",\"exports\",\"core/utils\",\"app/utils/setup_polling_with_backoff\",], function(module, require, exports) {\n    function withPolling() {\n        this.defaultAttrs({\n            pollingWatchNode: $(window),\n            pollingEnabled: !0\n        }), this.pausePolling = function() {\n            this.pollingTimer.pause(), this.pollingPaused = !0;\n        }, this.resetPolling = function() {\n            this.backoffEmptyResponseCount = 0, this.pollingPaused = !1;\n        }, this.pollForNewItems = function(a, b) {\n            this.trigger(\"uiTimelineShouldRefresh\", {\n                injectImmediately: !1,\n                interval: this.pollingTimer.interval,\n                fromPolling: !0\n            });\n        }, this.onGotMoreTimelineItems = function(a, b) {\n            if (!((((((this.attr.pollingOptions && this.attr.pollingOptions.pauseAfterBackoff)) && b)) && b.sourceEventData))) {\n                return;\n            }\n        ;\n        ;\n            var c = b.sourceEventData;\n            ((c.fromPolling && ((((this.isNewItem(b) || ((c.interval < this.attr.pollingOptions.blurredInterval)))) ? this.resetPolling() : ((((++this.backoffEmptyResponseCount >= this.attr.pollingOptions.backoffEmptyResponseLimit)) && this.pausePolling()))))));\n        }, this.modifyNewItemsData = function(a) {\n            var b = a();\n            return ((((this.pollingPaused && this.attr.pollingOptions)) ? (this.resetPolling(), utils.merge(b, {\n                count: this.attr.pollingOptions.resumeItemCount\n            })) : b));\n        }, this.possiblyRefreshBeforeInject = function(a, b, c) {\n            return ((((((this.pollingPaused && b)) && ((b.type === \"click\")))) && this.trigger(\"uiTimelineShouldRefresh\", {\n                injectImmediately: !0\n            }))), a(b, c);\n        }, this.around(\"getNewItemsData\", this.modifyNewItemsData), this.around(\"injectNewItems\", this.possiblyRefreshBeforeInject), this.after(\"initialize\", function() {\n            if (!this.attr.pollingEnabled) {\n                return;\n            }\n        ;\n        ;\n            this.JSBNG__on(JSBNG__document, \"uiTimelinePollForNewItems\", this.pollForNewItems), this.JSBNG__on(JSBNG__document, \"dataGotMoreTimelineItems\", this.onGotMoreTimelineItems), this.pollingTimer = setupPollingWithBackoff(\"uiTimelinePollForNewItems\", this.attr.pollingWatchNode, this.attr.pollingOptions), this.resetPolling();\n        });\n    };\n;\n    var utils = require(\"core/utils\"), setupPollingWithBackoff = require(\"app/utils/setup_polling_with_backoff\");\n    module.exports = withPolling;\n});\ndefine(\"app/ui/timelines/with_new_items\", [\"module\",\"require\",\"exports\",\"core/utils\",\"core/compose\",\"app/utils/chrome\",\"app/ui/timelines/with_autoplaying_timeline\",\"app/ui/timelines/with_polling\",], function(module, require, exports) {\n    function withNewItems() {\n        this.injectNewItems = function(a, b) {\n            if (!this.latentItems.html) {\n                return;\n            }\n        ;\n        ;\n            this.select(\"newItemsBarSelector\").remove();\n            var c = this.injectItems(\"prepend\", this.latentItems.html, \"uiHasInjectedNewTimeline\", b);\n            return this.resetLatentItems(), c;\n        }, this.handleNewItemsBarClick = function(a, b) {\n            this.injectNewItems(a, b), this.trigger(\"uiRefreshUserRecsOnNewTweets\");\n        }, compose.mixin(this, [withAutoplayingTimeline,withPolling,]), this.defaultAttrs({\n            newItemsBarSelector: \".js-new-tweets-bar\",\n            streamItemSelector: \".stream-item\",\n            refreshOnReturn: !0\n        }), this.getNewItems = function(a, b) {\n            this.trigger(\"uiWantsMoreTimelineItems\", utils.merge({\n                include_new_items_bar: ((!b || !b.injectImmediately)),\n                latent_count: this.latentItems.count,\n                composed_count: Object.keys(this.composedThenInjectedTweetIds).length\n            }, this.getNewItemsData(), b));\n        }, this.notifyNewItems = function(a) {\n            if (!a.items_html) {\n                return;\n            }\n        ;\n        ;\n            var b = ((a.sourceEventData || {\n            }));\n            this.resetStateVariables(a);\n            var c = ((this.attr.injectComposedTweets && this.removeComposedTweetsFromPayload(a)));\n            if (!a.items_html) {\n                return;\n            }\n        ;\n        ;\n            this.latentItems.html = ((a.items_html + ((this.latentItems.html || \"\"))));\n            if (a.new_tweets_bar_html) {\n                var d, e = a.new_tweets_bar_alternate_html;\n                ((((((((this.attr.injectComposedTweets && ((c > 0)))) && e)) && e[((c - 1))])) ? d = $(e[((c - 1))]) : d = $(a.new_tweets_bar_html))), this.latentItems.count = d.children().first().data(\"item-count\"), ((this.autoplay ? this.autoplayNewItems(a.new_tweets_bar_html, this.latentItems.count) : ((b.injectImmediately || this.updateNewItemsBar(d))))), this.trigger(\"uiAddPageCount\", {\n                    count: this.latentItems.count\n                });\n            }\n        ;\n        ;\n            ((((b.injectImmediately || b.timeline_empty)) && this.trigger(\"uiInjectNewItems\"))), ((b.scrollToTop && this.scrollToTop())), ((b.selectTopTweet && this.trigger(\"uiSelectTopTweet\")));\n        }, this.removeComposedTweetsFromPayload = function(a) {\n            var b = this.composedThenInjectedTweetIds, c = $(a.items_html).filter(this.attr.streamItemSelector);\n            if (((c.length == 0))) {\n                return 0;\n            }\n        ;\n        ;\n            var d = 0, e = c.filter(function(a, c) {\n                var e = $(c).attr(\"data-item-id\");\n                return ((((e in b)) ? (d++, delete b[e], !1) : !0));\n            });\n            return a.items_html = $(\"\\u003Cdiv/\\u003E\").append(e).html(), d;\n        }, this.updateNewItemsBar = function(a) {\n            var b = this.select(\"newItemsBarSelector\"), c = this.select(\"containerSelector\"), d = $(window).scrollTop(), e = chrome.getCanvasYOffset(c);\n            ((b.length ? (b.parent().remove(), a.prependTo(c)) : (a.hide().prependTo(c), ((((d > e)) ? (a.show(), $(\"html, body\").scrollTop(((d + a.height())))) : a.slideDown()))))), this.trigger(\"uiNewItemsBarVisible\");\n        }, this.resetLatentItems = function() {\n            this.latentItems = {\n                count: 0,\n                html: \"\"\n            };\n        }, this.refreshOnNavigate = function(a, b) {\n            ((((b.fromCache && this.attr.refreshOnReturn)) && this.trigger(\"uiTimelineShouldRefresh\", {\n                navigated: !0\n            })));\n        }, this.refreshAndSelectTopTweet = function(a, b) {\n            this.trigger(\"uiTimelineShouldRefresh\", {\n                injectImmediately: !0,\n                selectTopTweet: !0\n            });\n        }, this.injectComposedTweet = function(a, b) {\n            if (b.in_reply_to_status_id) {\n                return;\n            }\n        ;\n        ;\n            this.injectNewItems();\n            var c = $(b.tweet_html).filter(this.attr.streamItemSelector).first().attr(\"data-item-id\");\n            if (this.$node.JSBNG__find(((((\".original-tweet[data-tweet-id='\" + c)) + \"']:first\"))).length) {\n                return;\n            }\n        ;\n        ;\n            this.latentItems.html = b.tweet_html, this.injectNewItems(), this.composedThenInjectedTweetIds[b.tweet_id] = !0;\n        }, this.refreshAndInjectImmediately = function(a, b) {\n            this.trigger(\"uiTimelineShouldRefresh\", {\n                injectImmediately: !0,\n                selectTopTweet: ((this.$selected.length == 1))\n            });\n        }, this.resetCacheOfComposedInjectedTweets = function(a, b) {\n            this.composedThenInjectedTweetIds = composedThenInjectedTweetIds = {\n            };\n        }, this.after(\"initialize\", function(a) {\n            this.composedThenInjectedTweetIds = composedThenInjectedTweetIds, this.resetLatentItems(), this.JSBNG__on(\"uiInjectNewItems\", this.injectNewItems), this.JSBNG__on(JSBNG__document, \"uiTimelineShouldRefresh\", this.getNewItems), this.JSBNG__on(JSBNG__document, \"uiBeforePageChanged\", this.injectNewItems), this.JSBNG__on(JSBNG__document, \"uiPageChanged\", this.refreshOnNavigate), this.JSBNG__on(JSBNG__document, \"uiGotoTopOfScreen\", this.refreshAndInjectImmediately), this.JSBNG__on(JSBNG__document, \"uiShortcutGotoTopOfScreen\", this.refreshAndSelectTopTweet), this.JSBNG__on(JSBNG__document, \"dataPageMutated\", this.resetCacheOfComposedInjectedTweets), ((this.attr.injectComposedTweets && this.JSBNG__on(JSBNG__document, \"dataTweetSuccess\", this.injectComposedTweet))), this.JSBNG__on(\"click\", {\n                newItemsBarSelector: this.handleNewItemsBarClick\n            });\n        });\n    };\n;\n    var utils = require(\"core/utils\"), compose = require(\"core/compose\"), chrome = require(\"app/utils/chrome\"), withAutoplayingTimeline = require(\"app/ui/timelines/with_autoplaying_timeline\"), withPolling = require(\"app/ui/timelines/with_polling\"), composedThenInjectedTweetIds = {\n    };\n    module.exports = withNewItems;\n});\ndefine(\"app/ui/timelines/with_tweet_pagination\", [\"module\",\"require\",\"exports\",\"app/utils/string\",], function(module, require, exports) {\n    function withTweetPagination() {\n        this.isOldItem = function(a) {\n            return ((a.max_id && ((!this.max_id || ((string.compare(this.max_id, a.max_id) >= 0))))));\n        }, this.isNewItem = function(a) {\n            return ((a.since_id && ((!this.since_id || ((string.compare(this.since_id, a.since_id) < 0))))));\n        }, this.wasRangeRequest = function(a) {\n            return ((a.max_id && a.since_id));\n        }, this.wasNewItemsRequest = function(a) {\n            return a.since_id;\n        }, this.wasOldItemsRequest = function(a) {\n            return a.max_id;\n        }, this.shouldGetOldItems = function() {\n            var a = ((((typeof this.max_id != \"undefined\")) && ((this.max_id !== null))));\n            return ((!a || ((this.max_id != \"-1\"))));\n        }, this.getOldItemsData = function() {\n            return {\n                max_id: this.max_id,\n                query: this.query\n            };\n        }, this.getRangeItemsData = function(a, b) {\n            return {\n                since_id: a,\n                max_id: b,\n                query: this.query\n            };\n        }, this.getNewItemsData = function() {\n            var a = {\n                since_id: this.since_id,\n                query: this.query\n            };\n            return ((((this.select(\"itemsSelector\").children().length == 0)) && (a.timeline_empty = !0))), a;\n        }, this.resetStateVariables = function(a) {\n            [\"max_id\",\"since_id\",\"query\",].forEach(function(b, c) {\n                ((((typeof a[b] != \"undefined\")) && (this[b] = a[b], ((((((b == \"max_id\")) || ((b == \"since_id\")))) && this.select(\"containerSelector\").attr(((\"data-\" + b.replace(\"_\", \"-\"))), this[b]))))));\n            }, this);\n        }, this.after(\"initialize\", function(a) {\n            this.since_id = ((this.select(\"containerSelector\").attr(\"data-since-id\") || undefined)), this.max_id = ((this.select(\"containerSelector\").attr(\"data-max-id\") || undefined)), this.query = ((a.query || \"\"));\n        });\n    };\n;\n    var string = require(\"app/utils/string\");\n    module.exports = withTweetPagination;\n});\ndefine(\"app/ui/timelines/with_preserved_scroll_position\", [\"module\",\"require\",\"exports\",\"core/utils\",\"core/i18n\",\"app/utils/string\",\"app/data/user_info\",\"core/compose\",], function(module, require, exports) {\n    function withPreservedScrollPosition() {\n        this.defaultAttrs({\n            firstTweetSelector: \".stream-items .js-stream-item:first-child\",\n            listSelector: \".stream-items:not(.conversation-module)\",\n            tearClass: \"tear\",\n            tearSelector: \".tear\",\n            tearProcessingClass: \"tear-processing\",\n            tearProcessingSelector: \".tear-processing\",\n            currentScrollPosClass: \"current-scroll-pos\",\n            currentScrollPosSelector: \".current-scroll-pos\",\n            topOfViewportTweetSelector: \".top-of-viewport-tweet\",\n            countAboveTear: 10,\n            countBelowTearAboveCurrent: 3,\n            countBelowCurrent: 10,\n            preservedScrollEnabled: !1\n        }), this.findTweetAtTop = function() {\n            var a = $(), b = $(window).scrollTop();\n            return this.select(\"genericItemSelector\").each(function(c, d) {\n                var e = $(d);\n                if (((e.offset().JSBNG__top > b))) {\n                    return a = e, !1;\n                }\n            ;\n            ;\n            }), a;\n        }, this.findNearestRealTweet = function(a, b) {\n            while (((a.length && ((a.JSBNG__find(\"[data-promoted=true]\").length || a.hasClass(this.attr.tearClass)))))) {\n                a = a[b]();\n            ;\n            };\n        ;\n            return a;\n        }, this.findSiblingTweets = function(a, b, c) {\n            var d = $(), e = a, f = 0;\n            while ((((e = e[b]()).length && ((f < c))))) {\n                if (((!e.is(\"[data-item-type=tweet]\") && ((b == \"prev\"))))) {\n                    break;\n                }\n            ;\n            ;\n                d = d.add(e), f++;\n            };\n        ;\n            return d;\n        }, this.getTweetId = function(a) {\n            var b = a.JSBNG__find(\".tweet\").attr(\"data-retweet-id\");\n            return ((b ? b : a.attr(\"data-item-id\")));\n        }, this.recordTweetAtTop = function() {\n            var a = this.findTweetAtTop();\n            if (a.length) {\n                var b = this.getTweetId(this.findNearestRealTweet(a, \"next\")), c = ((a.offset().JSBNG__top - $(window).scrollTop()));\n                a.addClass(this.attr.currentScrollPosClass), a.attr(\"data-offset\", c), this.trigger(\"uiTimelineScrollSet\", {\n                    topItem: b,\n                    offset: c\n                });\n            }\n        ;\n        ;\n        }, this.trimTimeline = function() {\n            var a = this.select(\"currentScrollPosSelector\"), b = this.select(\"firstTweetSelector\"), c, d;\n            ((a.length || (a = b)));\n            if (!a.length) {\n                return;\n            }\n        ;\n        ;\n            d = $(), d = d.add(a), d = d.add(this.findSiblingTweets(a, \"next\", this.attr.countBelowCurrent)), d = d.add(this.findSiblingTweets(a, \"prev\", this.attr.countBelowTearAboveCurrent)), c = d.first();\n            if (((c.index() >= this.attr.countAboveTear))) {\n                var e = $(TEAR_HTML);\n                c.before(e), d = d.add(e);\n            }\n        ;\n        ;\n            ((((this.attr.countAboveTear > 0)) && (d = d.add(b), d = d.add(this.findSiblingTweets(b, \"next\", ((this.attr.countAboveTear - 1)))))));\n            var f = this.findNearestRealTweet(d.last(), \"prev\");\n            this.select(\"containerSelector\").attr(\"data-max-id\", string.subtractOne(this.getTweetId(f))), this.select(\"listSelector\").html(d);\n        }, this.restorePosition = function(a, b) {\n            var c = {\n            }, d = 0;\n            ((((b && b.fromCache)) ? (c = this.select(\"currentScrollPosSelector\"), d = ((-1 * c.attr(\"data-offset\")))) : ((((b && b.scrollPosition)) && (c = this.select(\"topOfViewportTweetSelector\"), d = ((-1 * b.scrollPosition.offset)))))));\n            var e, f, g;\n            ((c.length && (f = $(window).scrollLeft(), g = ((c.offset().JSBNG__top + d)), window.JSBNG__scrollTo(f, g), c.removeClass(this.attr.currentScrollPosClass), $(JSBNG__document).one(\"JSBNG__scroll\", function() {\n                window.JSBNG__scrollTo(f, g);\n            }))));\n        }, this.expandTear = function(a, b, c) {\n            var d = $(a.target);\n            ((d.hasClass(this.attr.tearClass) || (d = d.closest(this.attr.tearSelector)))), d.addClass(this.attr.tearProcessingClass);\n            var e = this.findNearestRealTweet(d.prev(), \"prev\"), f = this.findNearestRealTweet(d.next(), \"next\"), g = this.getTweetId(f), h = this.getTweetId(e);\n            d.attr(\"data-prev-id\", h), d.attr(\"data-next-id\", g), this.trigger(\"uiWantsMoreTimelineItems\", this.getRangeItemsData(string.subtractOne(g), h));\n        }, this.injectRangeItems = function(a) {\n            var b = this.select(\"tearSelector\"), c = $(a.items_html);\n            b.each(function(b, d) {\n                var e = $(d), f = e.attr(\"data-prev-id\"), g = e.attr(\"data-next-id\"), h = !0;\n                ((((a.since_id == f)) && (((((f == this.getTweetId(c.first()))) && (c = c.not(c.first())))), ((((g == this.getTweetId(c.last()))) && (c = c.not(c.last()), h = !1))), c.hide(), e.before(c), e.removeClass(this.attr.tearProcessingClass), ((h || e.remove())), c.filter(\".js-stream-item\").slideDown(\"fast\"), this.reportInjectedItems(c, \"uiHasInjectedRangeTimelineItems\"))));\n            }.bind(this));\n        }, this.notifyRangeItemsError = function(a) {\n            this.select(\"tearProcessingSelector\").removeClass(this.attr.tearProcessingClass);\n        }, this.after(\"initialize\", function() {\n            var a = userInfo.getExperimentGroup(\"home_timeline_snapback_951\"), b = userInfo.getExperimentGroup(\"web_conversations\"), c = ((((a && ((a.bucket == \"preserve\")))) || ((((b && ((b.experiment_key == \"conversations_on_home_timeline_785\")))) && ((b.bucket != \"control\")))))), d = userInfo.getDecider(\"preserve_scroll_position\");\n            ((((this.attr.preservedScrollEnabled && ((c || d)))) && (this.preserveScrollPosition = !0, this.JSBNG__on(JSBNG__document, \"uiPageChanged\", this.restorePosition), this.JSBNG__on(JSBNG__document, \"uiBeforePageChanged\", this.recordTweetAtTop), this.before(\"teardown\", this.trimTimeline), this.JSBNG__on(\"click\", {\n                tearSelector: this.expandTear\n            }))));\n        });\n    };\n;\n    var utils = require(\"core/utils\"), _ = require(\"core/i18n\"), string = require(\"app/utils/string\"), userInfo = require(\"app/data/user_info\"), compose = require(\"core/compose\"), TEAR_HTML = ((((\"\\u003Cli class=\\\"tear stream-item\\\"\\u003E\\u003Cbutton class=\\\"tear-inner btn-link\\\" type=\\\"button\\\"\\u003E\\u003Cspan class=\\\"tear-text\\\"\\u003E\" + _(\"Load more tweets\"))) + \"\\u003C/span\\u003E\\u003C/button\\u003E\\u003C/li\\u003E\"));\n    module.exports = withPreservedScrollPosition;\n});\ndefine(\"app/ui/timelines/with_activity_supplements\", [\"module\",\"require\",\"exports\",], function(module, require, exports) {\n    function withActivitySupplements() {\n        this.defaultAttrs({\n            networkActivityPageViewAllToggle: \".stream-item-activity-network\",\n            viewAllSupplementsButton: \"button.view-all-supplements\",\n            interactionsPageViewAllToggle: \".stream-item-activity-me button.view-all-supplements\",\n            additionalStreamItemsSelector: \".sub-stream-item-showing,.sub-stream-item-hidden\",\n            additionalNetworkActivityItems: \".hidden-supplement, .hidden-supplement-expanded\",\n            hiddenSupplement: \"hidden-supplement\",\n            visibleSupplement: \"hidden-supplement-expanded\",\n            hiddenSubItem: \"sub-stream-item-hidden\",\n            visibleSubItem: \"sub-stream-item-showing\",\n            visibleSupplementSelector: \".visible-supplement\"\n        }), this.toggleSupplementTrigger = function(a) {\n            var b = a.hasClass(\"show\");\n            return a.toggleClass(\"hide\", b).toggleClass(\"show\", !b), b;\n        }, this.toggleInteractionsSupplements = function(a, b) {\n            var c = $(b.el), d = this.toggleSupplementTrigger(c);\n            this.toggleSubStreamItemsVisibility(c.parent(), d);\n        }, this.toggleNetworkActivitySupplements = function(a, b) {\n            if ((($(a.target).closest(\".supplement\").length > 0))) {\n                return;\n            }\n        ;\n        ;\n            var c = $(b.el), d = this.toggleSupplementTrigger(c.JSBNG__find(this.attr.viewAllSupplementsButton));\n            ((d || this.trigger(c.JSBNG__find(\".activity-supplement \\u003E .stream-item.open\"), \"uiShouldToggleExpandedState\"))), this.toggleSubStreamItemsVisibility(c, d), c.JSBNG__find(this.attr.additionalNetworkActivityItems).toggleClass(\"hidden-supplement\", !d).toggleClass(\"hidden-supplement-expanded\", d);\n            var e = c.closest(\".js-stream-item\"), f;\n            ((d ? (e.addClass(\"js-has-navigable-stream\"), f = e.JSBNG__find(\".activity-supplement .stream-item:first-child\"), e.JSBNG__find(\".activity-supplement \\u003E .js-unselectable-stream-item\").removeClass(\"js-unselectable-stream-item\"), this.trigger(f, \"uiSelectItem\", {\n                setFocus: !0\n            })) : (e.removeClass(\"js-has-navigable-stream\"), e.JSBNG__find(\".activity-supplement \\u003E .hidden-supplement\").addClass(\"js-unselectable-stream-item\"), this.trigger(e, \"uiSelectItem\", {\n                setFocus: !0\n            }))));\n        }, this.toggleSubStreamItemsVisibility = function(a, b) {\n            a.JSBNG__find(this.attr.additionalStreamItemsSelector).toggleClass(\"sub-stream-item-hidden\", !b).toggleClass(\"sub-stream-item-showing\", b);\n        }, this.selectAndFocusTopLevelStreamItem = function(a, b) {\n            var c = $(b.el), d = c.hasClass(\"js-has-navigable-stream\"), e = this.select(\"viewAllSupplementsButton\").hasClass(\"show\"), f = c.closest(\".js-stream-item\");\n            ((((e && !d)) && (a.stopPropagation(), f.removeClass(\"js-has-navigable-stream\"), this.trigger(f, \"uiSelectItem\", {\n                setFocus: !0\n            }))));\n        }, this.after(\"initialize\", function(a) {\n            this.JSBNG__on(\"click\", {\n                interactionsPageViewAllToggle: this.toggleInteractionsSupplements,\n                networkActivityPageViewAllToggle: this.toggleNetworkActivitySupplements\n            }), this.JSBNG__on(\"uiSelectItem\", {\n                visibleSupplementSelector: this.selectAndFocusTopLevelStreamItem\n            });\n        });\n    };\n;\n    module.exports = withActivitySupplements;\n});\ndefine(\"app/ui/with_conversation_actions\", [\"module\",\"require\",\"exports\",], function(module, require, exports) {\n    module.exports = function() {\n        this.defaultAttrs({\n            conversationModuleSelector: \".conversation-module\",\n            hasConversationModuleSelector: \".tweet.has-conversation-module\",\n            viewMoreSelector: \"a.view-more\",\n            missingTweetsLinkSelector: \"a.missing-tweets-link\",\n            conversationRootSelector: \"li.conversation-root\",\n            repliesCountSelector: \".replies-count\",\n            otherRepliesSelector: \".other-replies\",\n            topLevelStreamItemSelector: \".stream-item:not(.conversation-tweet-item)\",\n            afterExpandedClass: \"after-expanded\",\n            beforeExpandedClass: \"before-expanded\",\n            repliesCountClass: \"replies-count\",\n            visuallyHiddenClass: \"visuallyhidden\",\n            conversationRootClass: \"conversation-root\",\n            originalTweetClass: \"original-tweet\",\n            hadConversationClass: \"had-conversation\",\n            conversationHtmlKey: \"conversationHtml\",\n            restoreConversationDelay: 100,\n            animationTime: 200\n        }), this.dedupAndCollapse = function(a, b) {\n            this.dedupConversations(), this.collapseConversations(((b && b.tweets)));\n        }, this.dedupConversations = function() {\n            var a = this.select(\"conversationModuleSelector\");\n            a.each(function(a, b) {\n                if (!b.parentNode) {\n                    return;\n                }\n            ;\n            ;\n                var c = $(b).attr(\"data-ancestors\").split(\",\"), d = $(this.idsToSelector(c));\n                d.addClass(\"to-be-removed\"), d.prev().removeClass(this.attr.beforeExpandedClass).end().next().removeClass(this.attr.afterExpandedClass);\n                var e = this;\n                d.slideUp(function() {\n                    var a = $(this);\n                    ((a.hasClass(e.attr.selectedClass) && e.trigger(\"uiSelectNext\", {\n                        maintainPosition: !0\n                    }))), JSBNG__setTimeout(function() {\n                        a.remove();\n                    }, 0);\n                });\n            }.bind(this));\n        }, this.idToSelector = function(a) {\n            return ((\"#stream-item-tweet-\" + a));\n        }, this.idsToSelector = function(a) {\n            return a.map(this.idToSelector).join(\",\");\n        }, this.collapseConversations = function(a) {\n            var b;\n            if (a) {\n                var c = a.map(function(a) {\n                    return a.tweetId;\n                }), d = this.$node.JSBNG__find(this.idsToSelector(c));\n                b = d.JSBNG__find(this.attr.conversationModuleSelector);\n            }\n             else b = this.select(\"conversationModuleSelector\");\n        ;\n        ;\n            var e = {\n            }, f = {\n            };\n            b.get().reverse().forEach(function(a) {\n                var b = $(a), c = b.attr(\"data-ancestors\"), d = b.JSBNG__find(\".conversation-root .tweet\").attr(\"data-item-id\");\n                ((((!b.hasClass(\"dont-collapse\") && !b.hasClass(\"to-be-removed\"))) && ((e[c] ? this.collapseAncestors(b) : ((f[d] && this.collapseRoot(b))))))), e[c] = !0, f[d] = !0;\n            }.bind(this));\n        }, this.expandConversationHandler = function(a, b) {\n            a.preventDefault();\n            var c = $(a.target).closest(this.attr.conversationModuleSelector);\n            this.expandConversation(c), c.addClass(\"dont-collapse\");\n        }, this.expandConversation = function(a) {\n            ((((a.JSBNG__find(\".conversation-tweet-item.conversation-ancestor:visible\").length > 0)) ? this.expandRoot(a) : this.expandAncestors(a)));\n        }, this.expandAncestors = function(a) {\n            var b = a.JSBNG__find(\".conversation-header\"), c = a.JSBNG__find(\".conversation-tweet-item, .missing-tweets-bar\"), d = a.JSBNG__find(\".original-tweet-item\");\n            this.slideAndFadeContent(b, c, d);\n        }, this.expandRoot = function(a) {\n            var b = a.JSBNG__find(\".conversation-header\"), c = a.JSBNG__find(\".conversation-tweet-item.conversation-root, .missing-tweets-bar\"), d = a.JSBNG__find(\".conversation-tweet-item.conversation-ancestor:not(.conversation-root):first\");\n            ((((d.length === 0)) && (d = a.JSBNG__find(\".original-tweet-item\")))), this.slideAndFadeContent(b, c, d);\n        }, this.collapseAncestors = function(a) {\n            var b = a.JSBNG__find(\".conversation-tweet-item, .missing-tweets-bar\"), c = a.JSBNG__find(\".conversation-header\"), d = a.JSBNG__find(\".original-tweet-item\");\n            this.slideAndFadeContent(b, c, d);\n        }, this.collapseRoot = function(a) {\n            var b = a.JSBNG__find(\".conversation-tweet-item.conversation-root, .missing-tweets-bar\"), c = a.JSBNG__find(\".conversation-header\"), d = a.JSBNG__find(\".conversation-tweet-item.conversation-ancestor:not(.conversation-root):first\");\n            ((((d.length === 0)) && (d = a.JSBNG__find(\".original-tweet-item\")))), this.slideAndFadeContent(b, c, d);\n        }, this.slideAndFadeContent = function(a, b, c) {\n            if (a.is(\":hidden\")) {\n                return;\n            }\n        ;\n        ;\n            var d = c.offset().JSBNG__top, e = this.getCombinedHeight(a);\n            a.hide();\n            var f = c.offset().JSBNG__top;\n            b.show();\n            var g = this.getCombinedHeight(b), h = c.offset().JSBNG__top;\n            this.setAbsolutePosition(b), b.hide(), a.show(), this.setAbsolutePosition(a);\n            var i = ((d - f)), j = ((d - h));\n            c.css(\"paddingTop\", e), a.fadeOut(this.attr.animationTime), b.fadeIn(this.attr.animationTime), c.animate({\n                paddingTop: g\n            }, this.attr.animationTime, function() {\n                this.resetCss(a), this.resetCss(b), this.resetCss(c);\n            }.bind(this));\n        }, this.resetCss = function(a) {\n            var b = {\n                position: \"\",\n                JSBNG__top: \"\",\n                width: \"\",\n                height: \"\",\n                paddingTop: \"\"\n            };\n            a.css(b);\n        }, this.setAbsolutePosition = function(a) {\n            a.get().reverse().forEach(function(a) {\n                var b = $(a), c = b.width(), d = b.height();\n                b.css({\n                    position: \"absolute\",\n                    JSBNG__top: b.position().JSBNG__top\n                }), b.width(c), b.height(d);\n            });\n        }, this.getCombinedHeight = function(a) {\n            var b = 0;\n            return a.each(function() {\n                b += $(this).JSBNG__outerHeight();\n            }), b;\n        }, this.convertRootToStandardTweet = function(a) {\n            a.data(this.attr.conversationHtmlKey, a.html());\n            var b = a.JSBNG__find(this.attr.conversationRootSelector);\n            a.empty().addClass(this.attr.hadConversationClass).html(b.html());\n            var c = a.JSBNG__find(this.attr.tweetSelector);\n            c.addClass(this.attr.originalTweetClass).removeClass(this.attr.conversationRootClass);\n        }, this.restoreConversation = function(a, b) {\n            var c = this.streamItemFromEvent(a), d = c.data(this.attr.conversationHtmlKey);\n            ((d && (c.html(d), c.removeClass(this.attr.hadConversationClass), c.data(this.attr.conversationHtmlKey, null))));\n        }, this.expandConversationRoot = function(a, b) {\n            a.preventDefault();\n            var c = this.streamItemFromEvent(a);\n            this.convertRootToStandardTweet(c), c.trigger(\"uiShouldToggleExpandedState\");\n        }, this.collapseRootAndRestoreConversation = function(a, b) {\n            var c = this.streamItemFromEvent(a);\n            c.trigger(\"uiShouldToggleExpandedState\"), JSBNG__setTimeout(function() {\n                this.restoreConversation(a, b);\n            }.bind(this), this.attr.restoreConversationDelay);\n        }, this.streamItemFromEvent = function(a) {\n            return $(a.target).closest(this.attr.topLevelStreamItemSelector);\n        }, this.after(\"initialize\", function(a) {\n            this.JSBNG__on(JSBNG__document, \"uiHasInjectedNewTimeline uiHasInjectedOldTimelineItems\", this.dedupAndCollapse), this.JSBNG__on(\"click\", {\n                viewMoreSelector: this.expandConversationHandler,\n                missingTweetsLinkSelector: this.expandConversationRoot\n            }), this.JSBNG__on(\"uiExpandConversationRoot\", this.expandConversationRoot), this.JSBNG__on(\"uiRestoreConversationModule\", this.collapseRootAndRestoreConversation), this.dedupAndCollapse();\n        });\n    };\n});\ndefine(\"app/ui/timelines/with_pinned_stream_items\", [\"module\",\"require\",\"exports\",], function(module, require, exports) {\n    function withPinnedStreamItems() {\n        this.defaultAttrs({\n            pinnedStreamItemSelector: \"li.js-pinned\"\n        }), this.keepPinnedStreamItemsOnTop = function() {\n            if (!this.$pinnedStreamItems.length) {\n                return;\n            }\n        ;\n        ;\n            var a = this.$pinnedStreamItems.first(), b = this.$pinnedStreamItems.last(), c = this.$items.children().first(), d = a.prev(), e = b.next();\n            a.css(\"margin-top\", \"0\"), ((a.hasClass(\"open\") && d.removeClass(\"before-expanded\"))), ((b.hasClass(\"open\") && (e.removeClass(\"after-expanded\"), c.addClass(\"after-expanded\")))), this.$items.prepend(this.$pinnedStreamItems.detach());\n        }, this.after(\"initialize\", function(a) {\n            this.$items = this.select(\"itemsSelector\"), this.$pinnedStreamItems = this.select(\"pinnedStreamItemSelector\"), this.JSBNG__on(\"uiHasInjectedNewTimeline\", this.keepPinnedStreamItemsOnTop);\n        });\n    };\n;\n    module.exports = withPinnedStreamItems;\n});\ndefine(\"app/ui/timelines/tweet_timeline\", [\"module\",\"require\",\"exports\",\"core/component\",\"app/ui/timelines/with_base_timeline\",\"app/ui/timelines/with_old_items\",\"app/ui/timelines/with_new_items\",\"app/ui/timelines/with_tweet_pagination\",\"app/ui/timelines/with_preserved_scroll_position\",\"app/ui/timelines/with_activity_supplements\",\"app/ui/with_timestamp_updating\",\"app/ui/with_tweet_actions\",\"app/ui/with_tweet_translation\",\"app/ui/with_conversation_actions\",\"app/ui/with_item_actions\",\"app/ui/timelines/with_traveling_ptw\",\"app/ui/timelines/with_pinned_stream_items\",\"app/ui/gallery/with_gallery\",], function(module, require, exports) {\n    function tweetTimeline() {\n        this.defaultAttrs({\n            itemType: \"tweet\"\n        }), this.reportInitialTweetsDisplayed = function() {\n            var b = this.select(\"genericItemSelector\"), c = [], d = function(b, d) {\n                var e = this.interactionData(this.findFirstItemContent($(d)));\n                ((this.attr.reinjectedPromotedTweets && (e.impressionId = undefined))), c.push(e);\n            }.bind(this);\n            for (var e = 0, f = b.length; ((e < f)); e++) {\n                d(e, b[e]);\n            ;\n            };\n        ;\n            var g = {\n                scribeContext: {\n                    component: \"stream\"\n                },\n                tweets: c\n            };\n            this.trigger(\"uiTweetsDisplayed\", g);\n        }, this.reportTweetsDisplayed = function(a, b) {\n            b.tweets = b.items, this.trigger(\"uiTweetsDisplayed\", b);\n        }, this.removeTweetsFromUser = function(a, b) {\n            var c = this.$node.JSBNG__find(((((\"[data-user-id=\" + b.userId)) + \"]\")));\n            c.parent().remove(), this.trigger(\"uiRemovedSomeTweets\");\n        }, this.after(\"initialize\", function(a) {\n            this.attr.reinjectedPromotedTweets = a.reinjectedPromotedTweets, this.reportInitialTweetsDisplayed(), this.JSBNG__on(\"uiHasInjectedNewTimeline uiHasInjectedOldTimelineItems uiHasInjectedRangeTimelineItems\", this.reportTweetsDisplayed), this.JSBNG__on(\"uiRemoveTweetsFromUser\", this.removeTweetsFromUser);\n        });\n    };\n;\n    var defineComponent = require(\"core/component\"), withBaseTimeline = require(\"app/ui/timelines/with_base_timeline\"), withOldItems = require(\"app/ui/timelines/with_old_items\"), withNewItems = require(\"app/ui/timelines/with_new_items\"), withTweetPagination = require(\"app/ui/timelines/with_tweet_pagination\"), withPreservedScrollPosition = require(\"app/ui/timelines/with_preserved_scroll_position\"), withActivitySupplements = require(\"app/ui/timelines/with_activity_supplements\"), withTimestampUpdating = require(\"app/ui/with_timestamp_updating\"), withTweetActions = require(\"app/ui/with_tweet_actions\"), withTweetTranslation = require(\"app/ui/with_tweet_translation\"), withConversationActions = require(\"app/ui/with_conversation_actions\"), withItemActions = require(\"app/ui/with_item_actions\"), withTravelingPtw = require(\"app/ui/timelines/with_traveling_ptw\"), withPinnedStreamItems = require(\"app/ui/timelines/with_pinned_stream_items\"), withGallery = require(\"app/ui/gallery/with_gallery\");\n    module.exports = defineComponent(tweetTimeline, withBaseTimeline, withTweetPagination, withPreservedScrollPosition, withOldItems, withNewItems, withTimestampUpdating, withTweetActions, withTweetTranslation, withConversationActions, withItemActions, withTravelingPtw, withPinnedStreamItems, withActivitySupplements, withGallery);\n});\ndefine(\"app/boot/tweet_timeline\", [\"module\",\"require\",\"exports\",\"app/boot/timeline\",\"app/boot/tweets\",\"app/boot/help_pips\",\"app/ui/expando/close_all_button\",\"app/ui/timelines/tweet_timeline\",\"core/utils\",], function(module, require, exports) {\n    function initialize(a, b, c, d) {\n        var e = utils.merge(a, {\n            endpoint: b,\n            itemType: c,\n            eventData: {\n                scribeContext: {\n                    component: ((d || c))\n                }\n            }\n        });\n        timelineBoot(e), tweetsBoot(\"#timeline\", e), ((e.help_pips_decider && helpPipsBoot(e))), CloseAllButton.attachTo(\"#close-all-button\", {\n            addEvent: \"uiHasExpandedTweet\",\n            subtractEvent: \"uiHasCollapsedTweet\",\n            where: \"#timeline\",\n            closeAllEvent: \"uiWantsToCloseAllTweets\"\n        }), TweetTimeline.attachTo(\"#timeline\", utils.merge(e, {\n            tweetItemSelector: \"div.original-tweet, .conversation-tweet-item div.tweet\"\n        }));\n    };\n;\n    var timelineBoot = require(\"app/boot/timeline\"), tweetsBoot = require(\"app/boot/tweets\"), helpPipsBoot = require(\"app/boot/help_pips\"), CloseAllButton = require(\"app/ui/expando/close_all_button\"), TweetTimeline = require(\"app/ui/timelines/tweet_timeline\"), utils = require(\"core/utils\");\n    module.exports = initialize;\n});\ndefine(\"app/ui/user_completion_module\", [\"module\",\"require\",\"exports\",\"core/component\",], function(module, require, exports) {\n    function userCompletionModule() {\n        this.defaultAttrs({\n            completeProfileSelector: \"#complete-profile-step\",\n            confirmEmailSelector: \"#confirm-email-step[href=#]:not(.completed)\",\n            confirmEmailInboxLinkSelector: \"#confirm-email-step[href!=#]:not(.completed)\",\n            followAccountsSelector: \"#follow-accounts-step\"\n        }), this.openConfirmEmailDialog = function() {\n            this.trigger(\"uiOpenConfirmEmailDialog\");\n        }, this.resendConfirmationEmail = function() {\n            this.trigger(\"uiResendConfirmationEmail\");\n        }, this.setCompleteProfileStepCompleted = function(a, b) {\n            ((((b.sourceEventData.uploadType == \"avatar\")) && this.setStepCompleted(\"completeProfileSelector\")));\n        }, this.setFollowAccountsStepCompleted = function() {\n            this.setStepCompleted(\"followAccountsSelector\");\n        }, this.setStepCompleted = function(a) {\n            this.select(a).removeClass(\"selected\").addClass(\"completed\");\n        }, this.after(\"initialize\", function() {\n            this.JSBNG__on(JSBNG__document, \"dataImageEnqueued\", this.setCompleteProfileStepCompleted), this.JSBNG__on(JSBNG__document, \"uiDidReachTargetFollowingCount\", this.setFollowAccountsStepCompleted), this.JSBNG__on(\"click\", {\n                confirmEmailSelector: this.openConfirmEmailDialog,\n                confirmEmailInboxLinkSelector: this.resendConfirmationEmail\n            });\n        });\n    };\n;\n    var defineComponent = require(\"core/component\");\n    module.exports = defineComponent(userCompletionModule);\n});\ndefine(\"app/data/user_completion_module_scribe\", [\"module\",\"require\",\"exports\",\"core/component\",\"app/data/with_scribe\",], function(module, require, exports) {\n    function userCompletionModuleScribe() {\n        this.defaultAttrs({\n            userCompletionStepSelector: \".user-completion-step:not(.completed)\"\n        }), this.scribeStepClick = function(a, b) {\n            var c = $(a.target).data(\"scribe-element\");\n            this.scribe({\n                component: \"user_completion\",\n                element: c,\n                action: \"click\"\n            });\n        }, this.after(\"initialize\", function() {\n            this.JSBNG__on(\"click\", {\n                userCompletionStepSelector: this.scribeStepClick\n            });\n        });\n    };\n;\n    var defineComponent = require(\"core/component\"), withScribe = require(\"app/data/with_scribe\");\n    module.exports = defineComponent(userCompletionModuleScribe, withScribe);\n});\ndefine(\"app/boot/user_completion_module\", [\"module\",\"require\",\"exports\",\"app/ui/user_completion_module\",\"app/data/user_completion_module_scribe\",\"core/utils\",], function(module, require, exports) {\n    function initialize(a) {\n        var b = \"#user-completion-module\", c = utils.merge(a, {\n            eventData: {\n                scribeContext: {\n                    component: \"user_completion\"\n                }\n            }\n        });\n        UserCompletionModule.attachTo(b, c), UserCompletionModuleScribe.attachTo(b, c);\n    };\n;\n    var UserCompletionModule = require(\"app/ui/user_completion_module\"), UserCompletionModuleScribe = require(\"app/data/user_completion_module_scribe\"), utils = require(\"core/utils\");\n    module.exports = initialize;\n});\ndefine(\"app/ui/who_to_follow/with_user_recommendations\", [\"module\",\"require\",\"exports\",\"core/utils\",\"$lib/bootstrap_tooltip.js\",], function(module, require, exports) {\n    function withUserRecommendations() {\n        this.defaultAttrs({\n            refreshAnimationDuration: 200,\n            cycleTimeout: 1000,\n            experimentCycleTimeout: 300,\n            wtfOptions: {\n            },\n            selfPromotedAccountHtml: \"\",\n            $accountPriorToPreview: null,\n            wtfRefreshOnNewTweets: !1,\n            recListSelector: \".js-recommended-followers\",\n            recSelector: \".js-actionable-user\",\n            refreshRecsSelector: \".js-refresh-suggestions\",\n            similarToContainerSelector: \".js-expanded-similar-to\",\n            expandedContainerSelector: \".js-expanded-container\",\n            itemType: \"user\"\n        }), this.refreshRecommendations = function(a, b) {\n            if (!this.currentlyRefreshing) {\n                this.currentlyRefreshing = !0;\n                var c = ((this.getVisibleIds(null, !0).length || this.attr.wtfOptions.limit));\n                this.trigger(\"uiRefreshUserRecommendations\", utils.merge(this.attr.wtfOptions, {\n                    excluded: this.getVisibleIds(),\n                    limit: c,\n                    refreshType: a.type\n                })), this.hideRecommendations();\n            }\n        ;\n        ;\n        }, this.getUserRecommendations = function(a, b) {\n            this.trigger(\"uiGetUserRecommendations\", utils.merge(this.attr.wtfOptions, ((a || {\n            })))), this.hideRecommendations();\n        }, this.hideRecommendations = function() {\n            this.animateContentOut(this.select(\"recListSelector\"), \"animationCallback\");\n        }, this.handleRecommendationsResponse = function(a, b) {\n            if (this.disabled) {\n                return;\n            }\n        ;\n        ;\n            b = ((b || {\n            }));\n            var c = b.user_recommendations_html;\n            if (c) {\n                var d = this.currentlyRefreshingUser(b);\n                this.$node.addClass(\"has-content\");\n                if (this.shouldExpandWtf(b)) {\n                    var e = $(c), f = e.filter(this.attr.recSelector).first(), g = e.filter(this.attr.expandedContainerSelector);\n                    ((d && this.animateContentIn(d, \"animationCallback\", $(\"\\u003Cdiv\\u003E\").append(f).html(), {\n                        modOp: \"replaceWith\",\n                        scribeCallback: function() {\n                            ((this.currentlyExpanding ? this.pendingScribe = !0 : this.reportUsersDisplayed(b)));\n                        }.bind(this)\n                    }))), ((g.size() && this.animateExpansion(g, b)));\n                }\n                 else {\n                    var h = this.select(\"recListSelector\"), i;\n                    ((d && (h = d, i = \"replaceWith\"))), this.animateContentIn(h, \"animationCallback\", c, {\n                        modOp: i,\n                        scribeCallback: function() {\n                            this.reportUsersDisplayed(b);\n                        }.bind(this)\n                    });\n                }\n            ;\n            ;\n            }\n             else this.handleEmptyRefreshResponse(a, b), this.trigger(\"uiGotEmptyRecommendationsResponse\", b);\n        ;\n        ;\n        }, this.handleRefreshError = function(a, b) {\n            this.handleEmptyRefreshResponse(a, b);\n        }, this.handleEmptyRefreshResponse = function(a, b) {\n            if (!this.select(\"recSelector\").length) {\n                return;\n            }\n        ;\n        ;\n            var c = this.select(\"recListSelector\"), d = this.currentlyRefreshingUser(b);\n            ((d && (c = d))), this.animateContentIn(c, \"animationCallback\", c.html());\n        }, this.getVisibleIds = function(a, b) {\n            var c = this.select(\"recSelector\").not(a);\n            return ((b || (c = c.not(\".promoted-account\")))), c.map(function() {\n                return $(this).attr(\"data-user-id\");\n            }).toArray();\n        }, this.originalItemCount = function() {\n            return $(this.attr.recListSelector).children(this.attr.recSelector).length;\n        }, this.doAfterFollowAction = function(a, b) {\n            if (((this.disabled || ((b.newState != \"following\"))))) {\n                return;\n            }\n        ;\n        ;\n            var c = ((this.expandBucket ? this.attr.experimentCycleTimeout : this.attr.cycleTimeout));\n            JSBNG__setTimeout(function() {\n                if (this.currentlyRefreshing) {\n                    return;\n                }\n            ;\n            ;\n                var a = this.select(\"recSelector\").filter(((((\"[data-user-id='\" + b.userId)) + \"']\")));\n                if (!a.length) {\n                    return;\n                }\n            ;\n            ;\n                this.cycleRecommendation(a, b);\n            }.bind(this), c);\n        }, this.isInSimilarToSection = function(a) {\n            return !!a.closest(this.attr.similarToContainerSelector).length;\n        }, this.cycleRecommendation = function(a, b) {\n            this.animateContentOut(a, \"animationCallback\");\n            var c = utils.merge(this.attr.wtfOptions, {\n                limit: 1,\n                visible: this.getVisibleIds(a),\n                refreshUserId: b.userId\n            });\n            ((this.isInSimilarToSection(a) && (c.user_id = this.select(\"similarToContainerSelector\").data(\"similar-to-user-id\")))), this.trigger(\"uiGetUserRecommendations\", c);\n        }, this.animateExpansion = function(a, b) {\n            var c = this.select(\"recListSelector\"), d = this.select(\"expandedContainerSelector\"), e = function() {\n                ((this.pendingScribe && (this.reportUsersDisplayed(b), this.pendingScribe = !1))), this.currentlyExpanding = !1;\n            };\n            ((d.length ? d.html(a.html()) : c.append(a))), ((a.is(\":visible\") ? e.bind(this)() : a.slideDown(\"slow\", e.bind(this))));\n        }, this.animateContentIn = function(a, b, c, d) {\n            if (!a.length) {\n                return;\n            }\n        ;\n        ;\n            d = ((d || {\n            }));\n            var e = function() {\n                ((a.is(this.attr.recListSelector) && (this.currentlyRefreshing = !1))), a[((d.modOp || \"html\"))](c).animate({\n                    opacity: 1\n                }, this.attr.refreshAnimationDuration), ((d.scribeCallback && d.scribeCallback()));\n            }.bind(this);\n            ((a.is(\":animated\") ? this[b] = e : e()));\n        }, this.animateContentOut = function(a, b) {\n            a.animate({\n                opacity: 0\n            }, {\n                duration: this.attr.refreshAnimationDuration,\n                complete: function() {\n                    ((this[b] && this[b]())), this[b] = null;\n                }.bind(this)\n            });\n        }, this.getItemPosition = function(a) {\n            var b = this.originalItemCount();\n            return ((this.isInSimilarToSection(a) ? ((((b + a.closest(this.attr.recSelector).index())) - 1)) : ((a.closest(this.attr.expandedContainerSelector).length ? ((b + a.closest(this.attr.recSelector).index())) : a.closest(this.attr.recSelector).index()))));\n        }, this.currentlyRefreshingUser = function(a) {\n            return ((((((!a || !a.sourceEventData)) || !a.sourceEventData.refreshUserId)) ? null : this.select(\"recSelector\").filter(((((\"[data-user-id=\" + a.sourceEventData.refreshUserId)) + \"]\")))));\n        }, this.shouldExpandWtf = function(a) {\n            return !!((((a && a.sourceEventData)) && a.sourceEventData.get_replacement));\n        }, this.getUsersDisplayed = function() {\n            var a = this.select(\"recSelector\"), b = [];\n            return a.each(function(a, c) {\n                var d = $(c);\n                b.push({\n                    id: d.attr(\"data-user-id\"),\n                    impressionId: d.attr(\"data-impression-id\")\n                });\n            }), b;\n        }, this.reportUsersDisplayed = function(a) {\n            var b = this.getUsersDisplayed();\n            this.trigger(\"uiUsersDisplayed\", {\n                users: b\n            }), this.trigger(\"uiDidGetRecommendations\", a);\n        }, this.verifyInitialRecommendations = function() {\n            ((this.hasRecommendations() ? this.reportUsersDisplayed({\n                initialResults: !0\n            }) : this.getUserRecommendations({\n                initialResults: !0\n            })));\n        }, this.hasRecommendations = function() {\n            return ((this.select(\"recSelector\").length > 0));\n        }, this.storeSelfPromotedAccount = function(a, b) {\n            ((b.html && (this.selfPromotedAccountHtml = b.html)));\n        }, this.replaceUser = function(a, b) {\n            a.tooltip(\"hide\"), ((a.parent().hasClass(\"preview-wrapper\") && a.unwrap())), a.replaceWith(b);\n        }, this.replaceUserAnimation = function(a, b) {\n            a.tooltip(\"hide\"), this.before(\"teardown\", function() {\n                this.replaceUser(a, b);\n            });\n            var c = $(\"\\u003Cdiv/\\u003E\", {\n                class: a.attr(\"class\"),\n                style: a.attr(\"style\")\n            }).addClass(\"preview-wrapper\");\n            a.wrap(c);\n            var d = a.css(\"minHeight\");\n            a.css({\n                minHeight: 0\n            }).slideUp(70, function() {\n                b.attr(\"style\", a.attr(\"style\")), a.replaceWith(b), b.delay(350).slideDown(70, function() {\n                    b.css({\n                        minHeight: d\n                    }), b.unwrap(), JSBNG__setTimeout(function() {\n                        b.tooltip(\"show\"), JSBNG__setTimeout(function() {\n                            b.tooltip(\"hide\");\n                        }, 8000);\n                    }, 500);\n                });\n            });\n        }, this.handlePreviewPromotedAccount = function() {\n            if (this.disabled) {\n                return;\n            }\n        ;\n        ;\n            if (this.selfPromotedAccountHtml) {\n                var a = $(this.selfPromotedAccountHtml), b = this.select(\"recSelector\").first();\n                this.attr.$accountPriorToPreview = b.clone(), this.replaceUserAnimation(b, a), a.JSBNG__find(\"a\").JSBNG__on(\"click\", function(a) {\n                    a.preventDefault(), a.stopPropagation();\n                });\n            }\n        ;\n        ;\n        }, this.maybeRestoreAccountPriorToPreview = function() {\n            var a = this.attr.$accountPriorToPreview;\n            if (!a) {\n                return;\n            }\n        ;\n        ;\n            this.replaceUser(this.select(\"recSelector\").first(), a), this.attr.$accountPriorToPreview = null;\n        }, this.after(\"initialize\", function() {\n            this.JSBNG__on(JSBNG__document, \"dataDidGetUserRecommendations\", this.handleRecommendationsResponse), this.JSBNG__on(JSBNG__document, \"dataFailedToGetUserRecommendations\", this.handleRefreshError), this.JSBNG__on(JSBNG__document, \"dataFollowStateChange\", this.doAfterFollowAction), this.JSBNG__on(\"click\", {\n                refreshRecsSelector: this.refreshRecommendations\n            }), this.JSBNG__on(JSBNG__document, \"dataDidGetSelfPromotedAccount\", this.storeSelfPromotedAccount), this.JSBNG__on(JSBNG__document, \"uiPromptbirdPreviewPromotedAccount\", this.handlePreviewPromotedAccount), this.JSBNG__on(JSBNG__document, \"uiPromptbirdDismissPrompt\", this.maybeRestoreAccountPriorToPreview), ((this.attr.wtfRefreshOnNewTweets && this.JSBNG__on(JSBNG__document, \"uiRefreshUserRecsOnNewTweets uiPageChanged\", this.refreshRecommendations)));\n        });\n    };\n;\n    var utils = require(\"core/utils\");\n    require(\"$lib/bootstrap_tooltip.js\"), module.exports = withUserRecommendations;\n});\ndefine(\"app/ui/who_to_follow/who_to_follow_dashboard\", [\"module\",\"require\",\"exports\",\"core/i18n\",\"core/utils\",\"core/component\",\"app/ui/with_user_actions\",\"app/ui/with_item_actions\",\"app/ui/who_to_follow/with_user_recommendations\",], function(module, require, exports) {\n    function whoToFollowDashboard() {\n        this.defaultAttrs({\n            dashboardSelector: \".dashboard-user-recommendations\",\n            recUserSelector: \".dashboard-user-recommendations .js-actionable-user\",\n            dismissRecSelector: \".dashboard-user-recommendations .js-actionable-user .js-action-dismiss\",\n            viewAllSelector: \".js-view-all-link\",\n            interestsSelector: \".js-interests-link\",\n            findFriendsSelector: \".js-find-friends-link\"\n        }), this.dismissRecommendation = function(a, b) {\n            if (!this.currentlyRefreshing) {\n                this.currentlyDismissing = !0;\n                var c = $(a.target).closest(this.attr.recSelector), d = c.attr(\"data-user-id\");\n                this.trigger(\"uiDismissUserRecommendation\", {\n                    recommended_user_id: d,\n                    impressionId: c.attr(\"data-impression-id\"),\n                    excluded: [d,],\n                    visible: this.getVisibleIds(c),\n                    token: c.attr(\"data-feedback-token\"),\n                    dismissable: this.attr.wtfOptions.dismissable,\n                    refreshUserId: d\n                }), this.animateContentOut(c, \"animationCallback\");\n            }\n        ;\n        ;\n        }, this.handleDismissResponse = function(a, b) {\n            b = ((b || {\n            })), this.currentlyDismissing = !1;\n            if (b.user_recommendations_html) {\n                var c = this.currentlyRefreshingUser(b), d = $(b.user_recommendations_html), e = this.getItemPosition(c);\n                this.animateContentIn(c, \"animationCallback\", b.user_recommendations_html, {\n                    modOp: \"replaceWith\",\n                    scribeCallback: function() {\n                        var a = {\n                            oldUser: this.interactionData(c, {\n                                position: e\n                            })\n                        };\n                        ((d.length && (a.newUser = this.interactionData(d, {\n                            position: e\n                        })))), this.trigger(\"uiDidDismissUserRecommendation\", a);\n                    }.bind(this)\n                });\n            }\n             else this.handleEmptyDismissResponse();\n        ;\n        ;\n        }, this.handleDismissError = function(a, b) {\n            var c = this.currentlyRefreshingUser(b);\n            ((c && c.remove())), this.handleEmptyDismissResponse();\n        }, this.handleEmptyDismissResponse = function() {\n            ((this.select(\"recSelector\").length || (this.trigger(\"uiShowMessage\", {\n                message: _(\"You have no more recommendations today!\")\n            }), this.$node.remove())));\n        }, this.enable = function() {\n            this.disabled = !1, this.refreshRecommendations({\n                type: \"empty-timeline\"\n            }), this.$node.show();\n        }, this.initRecommendations = function() {\n            ((this.disabled ? this.$node.hide() : this.verifyInitialRecommendations()));\n        }, this.reset = function() {\n            ((((this.currentlyRefreshing || this.currentlyDismissing)) ? this.select(\"dashboardSelector\").html(\"\") : (this.select(\"dashboardSelector\").css(\"opacity\", 1), this.select(\"recUserSelector\").css(\"opacity\", 1))));\n        }, this.expandWhoToFollow = function(a, b) {\n            this.currentlyExpanding = !0;\n            var c = utils.merge(this.attr.wtfOptions, {\n                limit: 3,\n                visible: this.getVisibleIds(a),\n                refreshUserId: b.userId,\n                get_replacement: !0\n            });\n            this.trigger(\"uiGetUserRecommendations\", c);\n        }, this.triggerLinkClickScribes = function(a) {\n            var b = this, c = {\n                interests_link: this.attr.interestsSelector,\n                import_link: this.attr.findFriendsSelector,\n                view_all_link: this.attr.viewAllSelector,\n                refresh_link: this.attr.refreshRecsSelector\n            }, d = $(a.target);\n            $.each(c, function(a, c) {\n                ((d.is(c) && b.trigger(JSBNG__document, \"uiClickedWtfLink\", {\n                    element: a\n                })));\n            });\n        }, this.after(\"initialize\", function() {\n            this.disabled = ((this.attr.wtfOptions ? this.attr.wtfOptions.disabled : !1)), this.JSBNG__on(JSBNG__document, \"dataDidDismissRecommendation\", this.handleDismissResponse), this.JSBNG__on(JSBNG__document, \"dataFailedToDismissUserRecommendation\", this.handleDismissError), this.JSBNG__on(JSBNG__document, \"uiDidHideEmptyTimelineModule\", this.enable), this.JSBNG__on(JSBNG__document, \"uiSwiftLoaded uiPageChanged\", this.initRecommendations), this.JSBNG__on(JSBNG__document, \"uiBeforePageChanged\", this.reset), this.JSBNG__on(\"click\", {\n                dismissRecSelector: this.dismissRecommendation,\n                interestsSelector: this.triggerLinkClickScribes,\n                viewAllSelector: this.triggerLinkClickScribes,\n                findFriendsSelector: this.triggerLinkClickScribes,\n                refreshRecsSelector: this.triggerLinkClickScribes\n            }), this.around(\"cycleRecommendation\", function(a, b, c) {\n                ((((((((this.attr.wtfOptions.display_location === \"wtf-component\")) && !this.currentlyExpanding)) && ((this.getVisibleIds(null, !0).length <= 3)))) ? this.expandWhoToFollow(b, c) : a(b, c)));\n            });\n        });\n    };\n;\n    var _ = require(\"core/i18n\"), utils = require(\"core/utils\"), defineComponent = require(\"core/component\"), withUserActions = require(\"app/ui/with_user_actions\"), withItemActions = require(\"app/ui/with_item_actions\"), withUserRecommendations = require(\"app/ui/who_to_follow/with_user_recommendations\");\n    module.exports = defineComponent(whoToFollowDashboard, withUserActions, withItemActions, withUserRecommendations);\n});\ndefine(\"app/ui/who_to_follow/who_to_follow_timeline\", [\"module\",\"require\",\"exports\",\"core/i18n\",\"core/component\",\"app/ui/with_user_actions\",\"app/ui/with_item_actions\",\"app/ui/who_to_follow/with_user_recommendations\",], function(module, require, exports) {\n    function whoToFollowTimeline() {\n        this.defaultAttrs({\n            doneButtonSelector: \".empty-timeline .js-done\",\n            headerTextSelector: \".empty-timeline .header-text\",\n            targetFollowingCount: 5,\n            titles: {\n                0: _(\"Here are some people you might enjoy following.\"),\n                1: _(\"Victory! That\\u2019s 1.\"),\n                2: _(\"Congratulations! That\\u2019s 2.\"),\n                3: _(\"Excellent! You\\u2019re making progress.\"),\n                4: _(\"Good work! You\\u2019ve almost reached 5.\"),\n                5: _(\"Yee-haw! That\\u2019s 5 follows. Now you\\u2019re on a roll.\")\n            }\n        }), this.dismissAllRecommendations = function(a, b) {\n            var c = $(b.el);\n            if (c.is(\":disabled\")) {\n                return;\n            }\n        ;\n        ;\n            var d = this.getVisibleIds();\n            this.trigger(\"uiDidDismissEmptyTimelineRecommendations\", {\n                userIds: d\n            }), this.trigger(\"uiDidHideEmptyTimelineModule\"), this.$node.remove();\n        }, this.refreshDoneButtonState = function() {\n            if (((this.followingCount >= this.attr.targetFollowingCount))) {\n                var a = this.select(\"doneButtonSelector\");\n                a.attr(\"disabled\", !1), this.trigger(\"uiDidReachTargetFollowingCount\");\n            }\n        ;\n        ;\n        }, this.refreshTitle = function() {\n            var a = this.attr.titles[this.followingCount.toString()];\n            this.select(\"headerTextSelector\").text(a);\n        }, this.refreshTimeline = function() {\n            this.trigger(\"uiTimelineShouldRefresh\", {\n                injectImmediately: !0\n            });\n        }, this.increaseFollowingCount = function() {\n            this.followingCount++;\n        }, this.decreaseFollowingCount = function() {\n            this.followingCount--;\n        }, this.initRecommendations = function() {\n            this.followingCount = this.attr.wtfOptions.followingCount, this.verifyInitialRecommendations();\n        }, this.after(\"initialize\", function() {\n            this.attr.wtfOptions = ((this.attr.emptyTimelineOptions || {\n            })), this.JSBNG__on(JSBNG__document, \"uiFollowAction\", this.increaseFollowingCount), this.JSBNG__on(JSBNG__document, \"uiUnfollowAction\", this.decreaseFollowingCount), this.JSBNG__on(JSBNG__document, \"dataFollowStateChange\", this.refreshDoneButtonState), this.JSBNG__on(JSBNG__document, \"dataFollowStateChange\", this.refreshTitle), this.JSBNG__on(JSBNG__document, \"dataFollowStateChange\", this.refreshTimeline), this.JSBNG__on(JSBNG__document, \"uiSwiftLoaded uiPageChanged\", this.initRecommendations), this.JSBNG__on(\"click\", {\n                doneButtonSelector: this.dismissAllRecommendations\n            });\n        });\n    };\n;\n    var _ = require(\"core/i18n\"), defineComponent = require(\"core/component\"), withUserActions = require(\"app/ui/with_user_actions\"), withItemActions = require(\"app/ui/with_item_actions\"), withUserRecommendations = require(\"app/ui/who_to_follow/with_user_recommendations\");\n    module.exports = defineComponent(whoToFollowTimeline, withUserActions, withItemActions, withUserRecommendations);\n});\ndefine(\"app/data/who_to_follow\", [\"module\",\"require\",\"exports\",\"core/component\",\"core/utils\",\"app/utils/storage/custom\",\"app/data/with_data\",], function(module, require, exports) {\n    function whoToFollowData() {\n        this.defaults = {\n            maxExcludedRecsInLocalStorage: 100,\n            endpoints: {\n                users: {\n                    url: \"/i/users/recommendations\",\n                    method: \"GET\",\n                    successEvent: \"dataDidGetUserRecommendations\",\n                    errorEvent: \"dataFailedToGetUserRecommendations\"\n                },\n                dismiss: {\n                    url: \"/i/users/recommendations/hide\",\n                    method: \"POST\",\n                    successEvent: \"dataDidDismissRecommendation\",\n                    errorEvent: \"dataFailedToDismissUserRecommendation\"\n                },\n                promoted_self: {\n                    url: \"/i/users/promoted_self\",\n                    method: \"GET\",\n                    successEvent: \"dataDidGetSelfPromotedAccount\",\n                    errorEvent: \"dataFailedToGetSelfPromotedAccount\"\n                }\n            }\n        }, this.refreshEndpoint = function(a) {\n            return this.hitEndpoint(a, {\n                \"Cache-Control\": \"max-age=0\",\n                Pragma: \"no-cache\"\n            });\n        }, this.hitEndpoint = function(a, b) {\n            var b = ((b || {\n            })), c = this.defaults.endpoints[a];\n            return function(a, d) {\n                d = ((d || {\n                })), d.excluded = ((d.excluded || []));\n                var e = ((d.visible || []));\n                delete d.visible, this.JSONRequest({\n                    type: c.method,\n                    url: c.url,\n                    headers: b,\n                    dataType: \"json\",\n                    data: utils.merge(d, {\n                        excluded: this.storage.pushAll(\"excluded\", d.excluded).concat(e).join(\",\")\n                    }),\n                    eventData: d,\n                    success: c.successEvent,\n                    error: c.errorEvent\n                }, c.method);\n            }.bind(this);\n        }, this.excludeUsers = function(a, b) {\n            this.storage.pushAll(\"excluded\", b.userIds), this.trigger(\"dataDidExcludeUserRecommendations\", b);\n        }, this.excludeFollowed = function(a, b) {\n            b = ((b || {\n            })), ((((((b.newState === \"following\")) && b.userId)) && this.storage.push(\"excluded\", b.userId)));\n        }, this.after(\"initialize\", function(a) {\n            var b = customStorage({\n                withArray: !0,\n                withMaxElements: !0,\n                withUniqueElements: !0\n            });\n            this.storage = new b(\"excluded_wtf_recs\"), this.storage.setMaxElements(\"excluded\", this.attr.maxExcludedRecsInLocalStorage), this.JSBNG__on(JSBNG__document, \"uiRefreshUserRecommendations\", this.refreshEndpoint(\"users\")), this.JSBNG__on(JSBNG__document, \"uiGetUserRecommendations\", this.hitEndpoint(\"users\")), this.JSBNG__on(JSBNG__document, \"uiDismissUserRecommendation\", this.hitEndpoint(\"dismiss\")), this.JSBNG__on(JSBNG__document, \"uiDidDismissEmptyTimelineRecommendations\", this.excludeUsers), this.JSBNG__on(JSBNG__document, \"dataFollowStateChange\", this.excludeFollowed), this.JSBNG__on(JSBNG__document, \"uiGotPromptbirdDashboardProfile\", this.hitEndpoint(\"promoted_self\"));\n        });\n    };\n;\n    var defineComponent = require(\"core/component\"), utils = require(\"core/utils\"), customStorage = require(\"app/utils/storage/custom\"), withData = require(\"app/data/with_data\"), WhoToFollowData = defineComponent(whoToFollowData, withData);\n    module.exports = WhoToFollowData;\n});\ndefine(\"app/data/who_to_follow_scribe\", [\"module\",\"require\",\"exports\",\"core/component\",\"app/ui/with_interaction_data\",\"app/data/with_interaction_data_scribe\",\"core/utils\",], function(module, require, exports) {\n    function whoToFollowScribe() {\n        this.defaultAttrs({\n            userSelector: \".js-actionable-user\",\n            itemType: \"user\"\n        }), this.scribeDismissRecommendation = function(a, b) {\n            this.scribeInteraction(\"dismiss\", b.oldUser), ((b.newUser && this.scribeInteraction({\n                element: \"replace\",\n                action: \"results\"\n            }, b.newUser, {\n                referring_event: \"replace\"\n            })));\n        }, this.scribeRecommendationResults = function(a, b) {\n            var c = [];\n            ((a.emptyResponse || this.$node.JSBNG__find(this.attr.userSelector).map(function(a, b) {\n                c.push(this.interactionData($(b), {\n                    position: a\n                }));\n            }.bind(this))));\n            var d = ((a.emptyResponse ? \"no_results\" : \"results\"));\n            this.scribeInteractiveResults({\n                element: b,\n                action: d\n            }, c, a, {\n                referring_event: b\n            });\n        }, this.scribeRecommendations = function(a, b) {\n            var c = ((b.sourceEventData || {\n            })), d = ((b.initialResults || c.initialResults));\n            ((d ? (this.scribeRecommendationResults(b, \"initial\"), ((b.emptyResponse || this.scribeRecommendationImpression(b)))) : (this.scribe({\n                action: \"refresh\"\n            }, b, {\n                event_info: c.refreshType\n            }), this.scribeRecommendationResults(b, \"newer\"))));\n        }, this.scribeEmptyRecommendationsResponse = function(a, b) {\n            this.scribeRecommendations(a, utils.merge(b, {\n                emptyResponse: !0\n            }));\n        }, this.scribeRecommendationImpression = function(a) {\n            this.scribe(\"impression\", a);\n        }, this.scribeLinkClicks = function(a, b) {\n            this.scribe({\n                component: \"user_recommendations\",\n                element: b.element,\n                action: \"click\"\n            });\n        }, this.after(\"initialize\", function() {\n            this.JSBNG__on(JSBNG__document, \"uiDidDismissUserRecommendation\", this.scribeDismissRecommendation), this.JSBNG__on(JSBNG__document, \"uiDidGetRecommendations\", this.scribeRecommendations), this.JSBNG__on(JSBNG__document, \"uiGotEmptyRecommendationsResponse\", this.scribeEmptyRecommendationsResponse), this.JSBNG__on(JSBNG__document, \"uiClickedWtfLink\", this.scribeLinkClicks);\n        });\n    };\n;\n    var defineComponent = require(\"core/component\"), withInteractionData = require(\"app/ui/with_interaction_data\"), withInteractionDataScribe = require(\"app/data/with_interaction_data_scribe\"), utils = require(\"core/utils\");\n    module.exports = defineComponent(whoToFollowScribe, withInteractionData, withInteractionDataScribe);\n});\ndefine(\"app/ui/profile/recent_connections_module\", [\"module\",\"require\",\"exports\",\"core/component\",\"app/ui/with_user_actions\",\"app/ui/with_item_actions\",], function(module, require, exports) {\n    function recentConnectionsModule() {\n        this.defaultAttrs({\n            itemType: \"user\"\n        });\n    };\n;\n    var defineComponent = require(\"core/component\"), withUserActions = require(\"app/ui/with_user_actions\"), withItemActions = require(\"app/ui/with_item_actions\");\n    module.exports = defineComponent(recentConnectionsModule, withUserActions, withItemActions);\n});\ndefine(\"app/ui/promptbird/with_invite_contacts\", [\"module\",\"require\",\"exports\",], function(module, require, exports) {\n    function withInviteContacts() {\n        this.defaultAttrs({\n            inviteContactsSelector: \".invite_contacts_prompt.prompt + .promptbird-action-bar .call-to-action\"\n        }), this.doInviteContacts = function(b, c) {\n            b.preventDefault(), this.trigger(\"uiPromptbirdShowInviteContactsDialog\");\n        }, this.after(\"initialize\", function() {\n            this.JSBNG__on(\"click\", {\n                inviteContactsSelector: this.doInviteContacts\n            });\n        });\n    };\n;\n    module.exports = withInviteContacts;\n});\ndefine(\"app/ui/promptbird\", [\"module\",\"require\",\"exports\",\"core/component\",\"app/ui/promptbird/with_invite_contacts\",\"app/ui/tweet_dialog\",], function(module, require, exports) {\n    function promptbirdPrompt() {\n        this.defaultAttrs({\n            promptSelector: \".JSBNG__prompt\",\n            languageSelector: \".language\",\n            callToActionSelector: \".call-to-action\",\n            callToActionDismissSelector: \".call-to-action.dismiss-prompt\",\n            delayedDismissSelector: \".js-follow-btn\",\n            dismissSelector: \"a.js-dismiss\",\n            setLanguageSelector: \".call-to-action.set-language\",\n            oneClickImportSelector: \".call-to-action.one-click-import-button\",\n         