/* Replayable replacements for global functions */

/***************************************************************
 * BEGIN STABLE.JS
 **************************************************************/
//! stable.js 0.1.3, https://github.com/Two-Screen/stable
//! © 2012 Stéphan Kochen, Angry Bytes. MIT licensed.
(function() {

// A stable array sort, because `Array#sort()` is not guaranteed stable.
// This is an implementation of merge sort, without recursion.

var stable = function(arr, comp) {
    if (typeof(comp) !== 'function') {
        comp = function(a, b) {
            a = String(a);
            b = String(b);
            if (a < b) return -1;
            if (a > b) return 1;
            return 0;
        };
    }

    var len = arr.length;

    if (len <= 1) return arr;

    // Rather than dividing input, simply iterate chunks of 1, 2, 4, 8, etc.
    // Chunks are the size of the left or right hand in merge sort.
    // Stop when the left-hand covers all of the array.
    var oarr = arr;
    for (var chk = 1; chk < len; chk *= 2) {
        arr = pass(arr, comp, chk);
    }
    for (var i = 0; i < len; i++) {
        oarr[i] = arr[i];
    }
    return oarr;
};

// Run a single pass with the given chunk size. Returns a new array.
var pass = function(arr, comp, chk) {
    var len = arr.length;
    // Output, and position.
    var result = new Array(len);
    var i = 0;
    // Step size / double chunk size.
    var dbl = chk * 2;
    // Bounds of the left and right chunks.
    var l, r, e;
    // Iterators over the left and right chunk.
    var li, ri;

    // Iterate over pairs of chunks.
    for (l = 0; l < len; l += dbl) {
        r = l + chk;
        e = r + chk;
        if (r > len) r = len;
        if (e > len) e = len;

        // Iterate both chunks in parallel.
        li = l;
        ri = r;
        while (true) {
            // Compare the chunks.
            if (li < r && ri < e) {
                // This works for a regular `sort()` compatible comparator,
                // but also for a simple comparator like: `a > b`
                if (comp(arr[li], arr[ri]) <= 0) {
                    result[i++] = arr[li++];
                }
                else {
                    result[i++] = arr[ri++];
                }
            }
            // Nothing to compare, just flush what's left.
            else if (li < r) {
                result[i++] = arr[li++];
            }
            else if (ri < e) {
                result[i++] = arr[ri++];
            }
            // Both iterators are at the chunk ends.
            else {
                break;
            }
        }
    }

    return result;
};

var arrsort = function(comp) {
    return stable(this, comp);
};

if (Object.defineProperty) {
    Object.defineProperty(Array.prototype, "sort", {
        configurable: true, writable: true, enumerable: false,
        value: arrsort
    });
} else {
    Array.prototype.sort = arrsort;
}

})();
/***************************************************************
 * END STABLE.JS
 **************************************************************/

/*
 * In a generated replay, this file is partially common, boilerplate code
 * included in every replay, and partially generated replay code. The following
 * header applies to the boilerplate code. A comment indicating "Auto-generated
 * below this comment" marks the separation between these two parts.
 *
 * Copyright (C) 2011, 2012 Purdue University
 * Written by Gregor Richards
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

(function() {
    // global eval alias
    var geval = eval;

    // detect if we're in a browser or not
    var inbrowser = false;
    var inharness = false;
    var finished = false;
    if (typeof window !== "undefined" && "document" in window) {
        inbrowser = true;
        if (window.parent && "JSBNG_handleResult" in window.parent) {
            inharness = true;
        }
    } else if (typeof global !== "undefined") {
        window = global;
        window.top = window;
    } else {
        window = (function() { return this; })();
        window.top = window;
    }

    if ("console" in window) {
        window.JSBNG_Console = window.console;
    }

    var callpath = [];

    // global state
    var JSBNG_Replay = window.top.JSBNG_Replay = {
        push: function(arr, fun) {
            arr.push(fun);
            return fun;
        },

        path: function(str) {
            verifyPath(str);
        },

        forInKeys: function(of) {
            var keys = [];
            for (var k in of)
                keys.push(k);
            return keys.sort();
        }
    };

    var currentTimeInMS;
    if (inharness) {
        currentTimeInMS = window.parent.currentTimeInMS;
    } else {
        if (window.performance && window.performance.now)
            currentTimeInMS = function() { return window.performance.now() };
        else if (typeof preciseTime !== 'undefined')
            currentTimeInMS = function() { return preciseTime() * 1000; };
        else
            currentTimeInMS = function() { return Date.now(); };
    }

    // the actual replay runner
    function onload() {
        try {
            delete window.onload;
        } catch (ex) {}

        var jr = JSBNG_Replay$;
        var cb = function() {
            var end = currentTimeInMS();
            finished = true;

            var msg = "Time: " + (end - st) + "ms";
    
            if (inharness) {
                window.parent.JSBNG_handleResult({error:false, time:(end - st)});
            } else if (inbrowser) {
                var res = document.createElement("div");
    
                res.style.position = "fixed";
                res.style.left = "1em";
                res.style.top = "1em";
                res.style.width = "35em";
                res.style.height = "5em";
                res.style.padding = "1em";
                res.style.backgroundColor = "white";
                res.style.color = "black";
                res.appendChild(document.createTextNode(msg));
    
                document.body.appendChild(res);
            } else if (typeof console !== "undefined") {
                console.log(msg);
            } else if (typeof print !== "undefined") {
                // hopefully not the browser print() function :)
                print(msg);
            }
        };

        // force it to JIT
        jr(false);

        // then time it
        var st = currentTimeInMS();
        while (jr !== null) {
            jr = jr(true, cb);
        }
    }

    // add a frame at replay time
    function iframe(pageid) {
        var iw;
        if (inbrowser) {
            // represent the iframe as an iframe (of course)
            var iframe = document.createElement("iframe");
            iframe.style.display = "none";
            document.body.appendChild(iframe);
            iw = iframe.contentWindow;
            iw.document.write("<script type=\"text/javascript\">var JSBNG_Replay_geval = eval;</script>");
            iw.document.close();
        } else {
            // no general way, just lie and do horrible things
            var topwin = window;
            (function() {
                var window = {};
                window.window = window;
                window.top = topwin;
                window.JSBNG_Replay_geval = function(str) {
                    eval(str);
                }
                iw = window;
            })();
        }
        return iw;
    }

    // called at the end of the replay stuff
    function finalize() {
        if (inbrowser) {
            setTimeout(onload, 0);
        } else {
            onload();
        }
    }

    // verify this recorded value and this replayed value are close enough
    function verify(rep, rec) {
        if (rec !== rep &&
            (rep === rep || rec === rec) /* NaN test */) {
            // FIXME?
            if (typeof rec === "function" && typeof rep === "function") {
                return true;
            }
            if (typeof rec !== "object" || rec === null ||
                !(("__JSBNG_unknown_" + typeof(rep)) in rec)) {
                return false;
            }
        }
        return true;
    }

    // general message
    var firstMessage = true;
    function replayMessage(msg) {
        if (inbrowser) {
            if (firstMessage)
                document.open();
            firstMessage = false;
            document.write(msg);
        } else {
            console.log(msg);
        }
    }

    // complain when there's an error
    function verificationError(msg) {
        if (finished) return;
        if (inharness) {
            window.parent.JSBNG_handleResult({error:true, msg: msg});
        } else replayMessage(msg);
        throw new Error();
    }

    // to verify a set
    function verifySet(objstr, obj, prop, gvalstr, gval) {
        if (/^on/.test(prop)) {
            // these aren't instrumented compatibly
            return;
        }

        if (!verify(obj[prop], gval)) {
            var bval = obj[prop];
            var msg = "Verification failure! " + objstr + "." + prop + " is not " + gvalstr + ", it's " + bval + "!";
            verificationError(msg);
        }
    }

    // to verify a call or new
    function verifyCall(iscall, func, cthis, cargs) {
        var ok = true;
        var callArgs = func.callArgs[func.inst];
        iscall = iscall ? 1 : 0;
        if (cargs.length !== callArgs.length - 1) {
            ok = false;
        } else {
            if (iscall && !verify(cthis, callArgs[0])) ok = false;
            for (var i = 0; i < cargs.length; i++) {
                if (!verify(cargs[i], callArgs[i+1])) ok = false;
            }
        }
        if (!ok) {
            var msg = "Call verification failure!";
            verificationError(msg);
        }

        return func.returns[func.inst++];
    }

    // to verify the callpath
    function verifyPath(func) {
        var real = callpath.shift();
        if (real !== func) {
            var msg = "Call path verification failure! Expected " + real + ", found " + func;
            verificationError(msg);
        }
    }

    // figure out how to define getters
    var defineGetter;
    if (Object.defineProperty) {
        var odp = Object.defineProperty;
        defineGetter = function(obj, prop, getter, setter) {
            if (typeof setter === "undefined") setter = function(){};
            odp(obj, prop, {"enumerable": true, "configurable": true, "get": getter, "set": setter});
        };
    } else if (Object.prototype.__defineGetter__) {
        var opdg = Object.prototype.__defineGetter__;
        var opds = Object.prototype.__defineSetter__;
        defineGetter = function(obj, prop, getter, setter) {
            if (typeof setter === "undefined") setter = function(){};
            opdg.call(obj, prop, getter);
            opds.call(obj, prop, setter);
        };
    } else {
        defineGetter = function() {
            verificationError("This replay requires getters for correct behavior, and your JS engine appears to be incapable of defining getters. Sorry!");
        };
    }

    var defineRegetter = function(obj, prop, getter, setter) {
        defineGetter(obj, prop, function() {
            return getter.call(this, prop);
        }, function(val) {
            // once it's set by the client, it's claimed
            setter.call(this, prop, val);
            Object.defineProperty(obj, prop, {
                "enumerable": true, "configurable": true, "writable": true,
                "value": val
            });
        });
    }

    // for calling events
    var fpc = Function.prototype.call;

// resist the urge, don't put a })(); here!
/******************************************************************************
 * Auto-generated below this comment
 *****************************************************************************/
var ow911113496 = window;
var f911113496_0;
var o0;
var f911113496_4;
var f911113496_6;
var f911113496_7;
var f911113496_12;
var f911113496_13;
var f911113496_14;
var f911113496_15;
var o1;
var o2;
var o3;
var o4;
var f911113496_49;
var f911113496_51;
var o5;
var f911113496_53;
var f911113496_54;
var o6;
var f911113496_57;
var o7;
var f911113496_59;
var f911113496_60;
var f911113496_61;
var f911113496_62;
var f911113496_70;
var f911113496_71;
var f911113496_86;
var f911113496_157;
var f911113496_420;
var f911113496_470;
var f911113496_472;
var o8;
var f911113496_475;
var f911113496_476;
var o9;
var fo911113496_1_body;
var f911113496_479;
var f911113496_481;
var o10;
var o11;
var o12;
var o13;
var f911113496_488;
var f911113496_504;
var fo911113496_473_style;
var f911113496_508;
var f911113496_509;
var fo911113496_480_lastChild;
var o14;
var o15;
var f911113496_513;
var o16;
var o17;
var f911113496_520;
var f911113496_521;
var fo911113496_1_cookie;
var f911113496_523;
var f911113496_524;
var f911113496_526;
var f911113496_527;
var f911113496_528;
var o18;
var o19;
var o20;
var o21;
var o22;
var o23;
var o24;
var o25;
var o26;
var o27;
var o28;
var o29;
var o30;
var o31;
var o32;
var f911113496_546;
var f911113496_547;
var o33;
var o34;
var o35;
var o36;
var o37;
var o38;
var o39;
var o40;
var o41;
var o42;
var o43;
var o44;
var o45;
var o46;
var o47;
var o48;
var o49;
var o50;
var o51;
var o52;
var o53;
var o54;
var o55;
var o56;
var o57;
var o58;
var o59;
var o60;
var o61;
var o62;
var o63;
var o64;
var o65;
var o66;
var o67;
var o68;
var o69;
var o70;
var o71;
var o72;
var o73;
var o74;
var o75;
var o76;
var o77;
var f911113496_711;
var o78;
var o79;
var f911113496_717;
var f911113496_719;
var f911113496_720;
var f911113496_721;
var f911113496_724;
var f911113496_727;
var f911113496_730;
var f911113496_737;
var f911113496_738;
var o80;
var f911113496_741;
var o81;
var f911113496_747;
var o82;
var f911113496_749;
var o83;
var o84;
var f911113496_753;
var f911113496_754;
var f911113496_755;
var o85;
var f911113496_760;
var f911113496_770;
var f911113496_773;
var f911113496_774;
var o86;
var o87;
var fo911113496_516_scrollTop;
var o88;
var o89;
var o90;
var fo911113496_786_parentNode;
var f911113496_787;
var f911113496_791;
var f911113496_792;
var o91;
var f911113496_799;
var fo911113496_803_parentNode;
var fo911113496_814_parentNode;
var fo911113496_835_parentNode;
var f911113496_856;
var f911113496_1013;
var f911113496_1017;
var f911113496_1315;
var f911113496_1344;
var f911113496_1347;
var f911113496_1350;
var f911113496_1357;
var f911113496_1360;
var f911113496_1500;
var f911113496_1551;
var f911113496_1598;
var fo911113496_1597_id;
var o92;
var o93;
var o94;
var o95;
var o96;
var o97;
var o98;
var o99;
var o100;
var o101;
var o102;
var o103;
var o104;
var o105;
var f911113496_1697;
var f911113496_1698;
var fo911113496_1727_parentNode;
var f911113496_1887;
var f911113496_1890;
var f911113496_1923;
var f911113496_1926;
var f911113496_1929;
JSBNG_Replay.s826a4a446437adf56a244a52dcd854244ec4dee7_361 = [];
JSBNG_Replay.sa574ed15f3859e0ddbd1b958865b71be53ed3521_48 = [];
JSBNG_Replay.s826a4a446437adf56a244a52dcd854244ec4dee7_316 = [];
JSBNG_Replay.s826a4a446437adf56a244a52dcd854244ec4dee7_371 = [];
JSBNG_Replay.s826a4a446437adf56a244a52dcd854244ec4dee7_349 = [];
JSBNG_Replay.s826a4a446437adf56a244a52dcd854244ec4dee7_6 = [];
JSBNG_Replay.s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_11 = [];
JSBNG_Replay.sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_0 = [];
JSBNG_Replay.sa574ed15f3859e0ddbd1b958865b71be53ed3521_312 = [];
JSBNG_Replay.s9840219b8a67b41faa089cd0ad1fad465972c548_0 = [];
JSBNG_Replay.sa574ed15f3859e0ddbd1b958865b71be53ed3521_280 = [];
// 1
// record generated by JSBench a851ecb530f7 at 2013-07-10T18:39:11.137Z
// 2
// 3
// 4
// 5
f911113496_0 = function() { return f911113496_0.returns[f911113496_0.inst++]; };
f911113496_0.returns = [];
f911113496_0.inst = 0;
// 6
ow911113496.JSBNG__Date = f911113496_0;
// 7
o0 = {};
// 8
ow911113496.JSBNG__document = o0;
// 13
f911113496_4 = function() { return f911113496_4.returns[f911113496_4.inst++]; };
f911113496_4.returns = [];
f911113496_4.inst = 0;
// 14
ow911113496.JSBNG__getComputedStyle = f911113496_4;
// 17
f911113496_6 = function() { return f911113496_6.returns[f911113496_6.inst++]; };
f911113496_6.returns = [];
f911113496_6.inst = 0;
// 18
ow911113496.JSBNG__removeEventListener = f911113496_6;
// 19
f911113496_7 = function() { return f911113496_7.returns[f911113496_7.inst++]; };
f911113496_7.returns = [];
f911113496_7.inst = 0;
// 20
ow911113496.JSBNG__addEventListener = f911113496_7;
// 21
ow911113496.JSBNG__top = ow911113496;
// 26
ow911113496.JSBNG__scrollX = 0;
// 27
ow911113496.JSBNG__scrollY = 0;
// 32
f911113496_12 = function() { return f911113496_12.returns[f911113496_12.inst++]; };
f911113496_12.returns = [];
f911113496_12.inst = 0;
// 33
ow911113496.JSBNG__setTimeout = f911113496_12;
// 34
f911113496_13 = function() { return f911113496_13.returns[f911113496_13.inst++]; };
f911113496_13.returns = [];
f911113496_13.inst = 0;
// 35
ow911113496.JSBNG__setInterval = f911113496_13;
// 36
f911113496_14 = function() { return f911113496_14.returns[f911113496_14.inst++]; };
f911113496_14.returns = [];
f911113496_14.inst = 0;
// 37
ow911113496.JSBNG__clearTimeout = f911113496_14;
// 38
f911113496_15 = function() { return f911113496_15.returns[f911113496_15.inst++]; };
f911113496_15.returns = [];
f911113496_15.inst = 0;
// 39
ow911113496.JSBNG__clearInterval = f911113496_15;
// 44
ow911113496.JSBNG__frames = ow911113496;
// 47
ow911113496.JSBNG__self = ow911113496;
// 48
o1 = {};
// 49
ow911113496.JSBNG__navigator = o1;
// 50
o2 = {};
// 51
ow911113496.JSBNG__screen = o2;
// 52
o3 = {};
// 53
ow911113496.JSBNG__history = o3;
// 64
ow911113496.JSBNG__closed = false;
// 67
ow911113496.JSBNG__opener = null;
// 68
ow911113496.JSBNG__defaultStatus = "";
// 69
o4 = {};
// 70
ow911113496.JSBNG__location = o4;
// 71
ow911113496.JSBNG__innerWidth = 1050;
// 72
ow911113496.JSBNG__innerHeight = 548;
// 73
ow911113496.JSBNG__outerWidth = 1050;
// 74
ow911113496.JSBNG__outerHeight = 660;
// 75
ow911113496.JSBNG__screenX = 12;
// 76
ow911113496.JSBNG__screenY = 29;
// 77
ow911113496.JSBNG__pageXOffset = 0;
// 78
ow911113496.JSBNG__pageYOffset = 0;
// 103
ow911113496.JSBNG__frameElement = null;
// 120
f911113496_49 = function() { return f911113496_49.returns[f911113496_49.inst++]; };
f911113496_49.returns = [];
f911113496_49.inst = 0;
// 121
ow911113496.JSBNG__webkitIDBTransaction = f911113496_49;
// 124
f911113496_51 = function() { return f911113496_51.returns[f911113496_51.inst++]; };
f911113496_51.returns = [];
f911113496_51.inst = 0;
// 125
ow911113496.JSBNG__webkitIDBIndex = f911113496_51;
// 126
o5 = {};
// 127
ow911113496.JSBNG__webkitIndexedDB = o5;
// 128
ow911113496.JSBNG__screenLeft = 12;
// 129
f911113496_53 = function() { return f911113496_53.returns[f911113496_53.inst++]; };
f911113496_53.returns = [];
f911113496_53.inst = 0;
// 130
ow911113496.JSBNG__webkitIDBFactory = f911113496_53;
// 131
ow911113496.JSBNG__clientInformation = o1;
// 132
f911113496_54 = function() { return f911113496_54.returns[f911113496_54.inst++]; };
f911113496_54.returns = [];
f911113496_54.inst = 0;
// 133
ow911113496.JSBNG__webkitIDBCursor = f911113496_54;
// 134
ow911113496.JSBNG__defaultstatus = "";
// 137
o6 = {};
// 138
ow911113496.JSBNG__performance = o6;
// 139
f911113496_57 = function() { return f911113496_57.returns[f911113496_57.inst++]; };
f911113496_57.returns = [];
f911113496_57.inst = 0;
// 140
ow911113496.JSBNG__webkitIDBDatabase = f911113496_57;
// 141
o7 = {};
// 142
ow911113496.JSBNG__console = o7;
// 143
f911113496_59 = function() { return f911113496_59.returns[f911113496_59.inst++]; };
f911113496_59.returns = [];
f911113496_59.inst = 0;
// 144
ow911113496.JSBNG__webkitIDBRequest = f911113496_59;
// 145
f911113496_60 = function() { return f911113496_60.returns[f911113496_60.inst++]; };
f911113496_60.returns = [];
f911113496_60.inst = 0;
// 146
ow911113496.JSBNG__webkitIDBObjectStore = f911113496_60;
// 147
ow911113496.JSBNG__devicePixelRatio = 1;
// 148
f911113496_61 = function() { return f911113496_61.returns[f911113496_61.inst++]; };
f911113496_61.returns = [];
f911113496_61.inst = 0;
// 149
ow911113496.JSBNG__webkitURL = f911113496_61;
// 150
f911113496_62 = function() { return f911113496_62.returns[f911113496_62.inst++]; };
f911113496_62.returns = [];
f911113496_62.inst = 0;
// 151
ow911113496.JSBNG__webkitIDBKeyRange = f911113496_62;
// 152
ow911113496.JSBNG__offscreenBuffering = true;
// 153
ow911113496.JSBNG__screenTop = 29;
// 168
f911113496_70 = function() { return f911113496_70.returns[f911113496_70.inst++]; };
f911113496_70.returns = [];
f911113496_70.inst = 0;
// 169
ow911113496.JSBNG__XMLHttpRequest = f911113496_70;
// 170
f911113496_71 = function() { return f911113496_71.returns[f911113496_71.inst++]; };
f911113496_71.returns = [];
f911113496_71.inst = 0;
// 171
ow911113496.JSBNG__Image = f911113496_71;
// 172
ow911113496.JSBNG__URL = f911113496_61;
// 173
ow911113496.JSBNG__name = "";
// 180
ow911113496.JSBNG__status = "";
// 203
f911113496_86 = function() { return f911113496_86.returns[f911113496_86.inst++]; };
f911113496_86.returns = [];
f911113496_86.inst = 0;
// 204
ow911113496.JSBNG__Worker = f911113496_86;
// 345
f911113496_157 = function() { return f911113496_157.returns[f911113496_157.inst++]; };
f911113496_157.returns = [];
f911113496_157.inst = 0;
// 346
ow911113496.JSBNG__Document = f911113496_157;
// 621
ow911113496.JSBNG__XMLDocument = f911113496_157;
// 842
ow911113496.JSBNG__TEMPORARY = 0;
// 843
ow911113496.JSBNG__PERSISTENT = 1;
// 874
f911113496_420 = function() { return f911113496_420.returns[f911113496_420.inst++]; };
f911113496_420.returns = [];
f911113496_420.inst = 0;
// 875
ow911113496.JSBNG__WebKitMutationObserver = f911113496_420;
// 894
ow911113496.JSBNG__indexedDB = o5;
// undefined
o5 = null;
// 895
o5 = {};
// 896
ow911113496.JSBNG__Intl = o5;
// 897
ow911113496.JSBNG__v8Intl = o5;
// undefined
o5 = null;
// 948
ow911113496.JSBNG__IDBTransaction = f911113496_49;
// 949
ow911113496.JSBNG__IDBRequest = f911113496_59;
// 952
ow911113496.JSBNG__IDBObjectStore = f911113496_60;
// 953
ow911113496.JSBNG__IDBKeyRange = f911113496_62;
// 954
ow911113496.JSBNG__IDBIndex = f911113496_51;
// 955
ow911113496.JSBNG__IDBFactory = f911113496_53;
// 956
ow911113496.JSBNG__IDBDatabase = f911113496_57;
// 959
ow911113496.JSBNG__IDBCursor = f911113496_54;
// 960
ow911113496.JSBNG__MutationObserver = f911113496_420;
// 985
ow911113496.JSBNG__onerror = null;
// 986
f911113496_470 = function() { return f911113496_470.returns[f911113496_470.inst++]; };
f911113496_470.returns = [];
f911113496_470.inst = 0;
// 987
ow911113496.Math.JSBNG__random = f911113496_470;
// 988
// 990
o5 = {};
// 991
f911113496_0.returns.push(o5);
// 992
f911113496_472 = function() { return f911113496_472.returns[f911113496_472.inst++]; };
f911113496_472.returns = [];
f911113496_472.inst = 0;
// 993
o5.getTime = f911113496_472;
// undefined
o5 = null;
// 994
f911113496_472.returns.push(1373481534584);
// 996
o5 = {};
// 997
o0.documentElement = o5;
// 998
o5.className = "";
// 999
o8 = {};
// 1000
f911113496_0.returns.push(o8);
// 1001
o8.getTime = f911113496_472;
// undefined
o8 = null;
// 1002
f911113496_472.returns.push(1373481541511);
// 1003
// 1004
f911113496_475 = function() { return f911113496_475.returns[f911113496_475.inst++]; };
f911113496_475.returns = [];
f911113496_475.inst = 0;
// 1005
o0.getElementById = f911113496_475;
// 1006
f911113496_475.returns.push(null);
// 1007
f911113496_476 = function() { return f911113496_476.returns[f911113496_476.inst++]; };
f911113496_476.returns = [];
f911113496_476.inst = 0;
// 1008
o0.createElement = f911113496_476;
// 1009
o8 = {};
// 1010
f911113496_476.returns.push(o8);
// 1011
// 1012
o9 = {};
// 1013
o8.firstChild = o9;
// undefined
o8 = null;
// undefined
fo911113496_1_body = function() { return fo911113496_1_body.returns[fo911113496_1_body.inst++]; };
fo911113496_1_body.returns = [];
fo911113496_1_body.inst = 0;
defineGetter(o0, "body", fo911113496_1_body, undefined);
// undefined
fo911113496_1_body.returns.push(null);
// 1015
f911113496_479 = function() { return f911113496_479.returns[f911113496_479.inst++]; };
f911113496_479.returns = [];
f911113496_479.inst = 0;
// 1016
o5.insertBefore = f911113496_479;
// 1017
o8 = {};
// 1018
o5.firstChild = o8;
// 1019
f911113496_479.returns.push(o9);
// 1020
f911113496_481 = function() { return f911113496_481.returns[f911113496_481.inst++]; };
f911113496_481.returns = [];
f911113496_481.inst = 0;
// 1021
o0.getElementsByTagName = f911113496_481;
// 1022
o10 = {};
// 1023
f911113496_481.returns.push(o10);
// 1024
o10.length = 5;
// 1025
o11 = {};
// 1026
o10["0"] = o11;
// 1027
o11.src = "http://news.yahoo.com/JSBENCH_NG_RECORD_OBJECTS.js";
// 1028
o12 = {};
// 1029
o10["1"] = o12;
// 1030
o12.src = "http://news.yahoo.com/JSBENCH_NG_RECORD.js";
// 1031
o13 = {};
// 1032
o10["2"] = o13;
// 1033
o13.src = "";
// undefined
o13 = null;
// 1034
o13 = {};
// 1035
o10["3"] = o13;
// 1036
o13.src = "";
// undefined
o13 = null;
// 1037
o13 = {};
// 1038
o10["4"] = o13;
// undefined
o10 = null;
// 1039
o13.src = "http://l.yimg.com/zz/combo?yui:3.9.1/build/yui/yui-min.js&os/mit/media/p/common/rmp-min-1217643.js&os/mit/media/m/base/viewport-loader-min-1228633.js&ss/rapid-3.4.6.js";
// 1040
f911113496_7.returns.push(undefined);
// 1044
f911113496_475.returns.push(o9);
// 1046
f911113496_475.returns.push(o9);
// 1047
f911113496_488 = function() { return f911113496_488.returns[f911113496_488.inst++]; };
f911113496_488.returns = [];
f911113496_488.inst = 0;
// 1048
f911113496_0.now = f911113496_488;
// 1049
o1.cajaVersion = void 0;
// 1050
o1.userAgent = "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/27.0.1453.116 Safari/537.36";
// 1051
o4.href = "http://news.yahoo.com/";
// 1052
o9.currentStyle = void 0;
// 1053
// 1054
o0.defaultView = ow911113496;
// 1055
o10 = {};
// 1056
f911113496_4.returns.push(o10);
// 1057
o10.display = "block";
// undefined
o10 = null;
// 1058
// 1060
// 1062
o10 = {};
// 1063
f911113496_4.returns.push(o10);
// 1064
o10.display = "block";
// undefined
o10 = null;
// 1065
// 1067
// 1069
o10 = {};
// 1070
f911113496_4.returns.push(o10);
// 1071
o10.display = "block";
// undefined
o10 = null;
// 1072
// 1074
// 1076
o10 = {};
// 1077
f911113496_4.returns.push(o10);
// 1078
o10.display = "block";
// undefined
o10 = null;
// 1079
// 1081
// 1083
o10 = {};
// 1084
f911113496_4.returns.push(o10);
// 1085
o10.display = "block";
// undefined
o10 = null;
// 1086
// 1088
// 1090
o10 = {};
// 1091
f911113496_4.returns.push(o10);
// 1092
o10.display = "block";
// undefined
o10 = null;
// 1093
// 1095
// 1097
o10 = {};
// 1098
f911113496_4.returns.push(o10);
// 1099
o10.display = "block";
// undefined
o10 = null;
// 1100
// 1102
// 1104
o10 = {};
// 1105
f911113496_4.returns.push(o10);
// 1106
o10.display = "block";
// undefined
o10 = null;
// 1107
// 1109
// 1111
o10 = {};
// 1112
f911113496_4.returns.push(o10);
// 1113
o10.display = "block";
// undefined
o10 = null;
// 1114
// 1116
// 1118
o10 = {};
// 1119
f911113496_4.returns.push(o10);
// 1120
o10.display = "block";
// undefined
o10 = null;
// 1121
// 1123
// 1125
o10 = {};
// 1126
f911113496_4.returns.push(o10);
// 1127
o10.display = "block";
// undefined
o10 = null;
// 1128
// 1130
// 1132
o10 = {};
// 1133
f911113496_4.returns.push(o10);
// 1134
o10.display = "block";
// undefined
o10 = null;
// 1135
// 1137
// 1139
o10 = {};
// 1140
f911113496_4.returns.push(o10);
// 1141
o10.display = "block";
// undefined
o10 = null;
// 1142
// 1144
// 1146
o10 = {};
// 1147
f911113496_4.returns.push(o10);
// 1148
o10.display = "block";
// undefined
o10 = null;
// 1149
// 1153
f911113496_7.returns.push(undefined);
// 1156
o10 = {};
// 1157
o0.implementation = o10;
// 1158
f911113496_504 = function() { return f911113496_504.returns[f911113496_504.inst++]; };
f911113496_504.returns = [];
f911113496_504.inst = 0;
// 1159
o10.hasFeature = f911113496_504;
// undefined
o10 = null;
// 1160
f911113496_504.returns.push(true);
// 1162
o10 = {};
// undefined
fo911113496_473_style = function() { return fo911113496_473_style.returns[fo911113496_473_style.inst++]; };
fo911113496_473_style.returns = [];
fo911113496_473_style.inst = 0;
defineGetter(o5, "style", fo911113496_473_style, undefined);
// undefined
fo911113496_473_style.returns.push(o10);
// undefined
o10 = null;
// 1165
o10 = {};
// 1166
f911113496_476.returns.push(o10);
// 1167
o10.async = true;
// undefined
o10 = null;
// 1170
o0.uniqueID = void 0;
// 1171
o0._yuid = void 0;
// 1172
// 1174
o10 = {};
// 1175
f911113496_481.returns.push(o10);
// 1176
o10["0"] = void 0;
// undefined
o10 = null;
// 1177
o0.head = o8;
// 1178
f911113496_508 = function() { return f911113496_508.returns[f911113496_508.inst++]; };
f911113496_508.returns = [];
f911113496_508.inst = 0;
// 1179
o8.appendChild = f911113496_508;
// 1180
f911113496_509 = function() { return f911113496_509.returns[f911113496_509.inst++]; };
f911113496_509.returns = [];
f911113496_509.inst = 0;
// 1181
o0.createTextNode = f911113496_509;
// 1182
o10 = {};
// 1183
f911113496_509.returns.push(o10);
// 1184
f911113496_508.returns.push(o10);
// undefined
fo911113496_480_lastChild = function() { return fo911113496_480_lastChild.returns[fo911113496_480_lastChild.inst++]; };
fo911113496_480_lastChild.returns = [];
fo911113496_480_lastChild.inst = 0;
defineGetter(o8, "lastChild", fo911113496_480_lastChild, undefined);
// undefined
fo911113496_480_lastChild.returns.push(o10);
// 1187
o14 = {};
// 1188
f911113496_476.returns.push(o14);
// 1190
o15 = {};
// 1191
f911113496_476.returns.push(o15);
// 1192
f911113496_513 = function() { return f911113496_513.returns[f911113496_513.inst++]; };
f911113496_513.returns = [];
f911113496_513.inst = 0;
// 1193
o15.setAttribute = f911113496_513;
// 1194
f911113496_513.returns.push(undefined);
// 1195
o15.className = "a";
// undefined
o15 = null;
// 1196
o14.setAttribute = f911113496_513;
// 1197
f911113496_513.returns.push(undefined);
// 1199
f911113496_513.returns.push(undefined);
// 1201
f911113496_513.returns.push(undefined);
// 1202
// 1203
// 1204
// 1205
o10.parentNode = o8;
// undefined
o10 = null;
// 1206
o8.insertBefore = f911113496_479;
// 1207
f911113496_479.returns.push(o14);
// 1210
o10 = {};
// 1211
f911113496_476.returns.push(o10);
// 1212
o10.setAttribute = f911113496_513;
// 1213
f911113496_513.returns.push(undefined);
// 1215
f911113496_513.returns.push(undefined);
// 1217
f911113496_513.returns.push(undefined);
// 1218
// 1219
// 1220
// 1223
f911113496_479.returns.push(o10);
// 1226
o15 = {};
// 1227
f911113496_0.returns.push(o15);
// 1228
o15.getTime = f911113496_472;
// undefined
o15 = null;
// 1229
f911113496_472.returns.push(1373481541715);
// 1231
o15 = {};
// undefined
fo911113496_1_body.returns.push(o15);
// undefined
fo911113496_1_body.returns.push(o15);
// 1234
o15.className = "no-js yog-type-index yog-full yog-version-v2 yog-ltr yuac-fixedpos-1 yuac-svg-1";
// 1235
// undefined
fo911113496_1_body.returns.push(o15);
// 1237
o15.offsetHeight = 0;
// 1242
o16 = {};
// 1243
f911113496_475.returns.push(o16);
// 1244
o16.innerHTML = "<center><div id=\"yom-ad-MAST-iframe\" class=\"yom-ad\"><center>\n<script>try {\n    ((JSBNG_Record.scriptLoad)((\"(function() {\\u000a    var wrap = document.getElementById(\\\"yom-ad-MAST\\\");\\u000a    if ((null == wrap)) {\\u000a        wrap = (document.getElementById(\\\"yom-ad-MAST-iframe\\\") || {\\u000a        });\\u000a    }\\u000a;\\u000a    var content = (wrap.innerHTML || \\\"\\\");\\u000a    if ((content && (content.substr(0, content.lastIndexOf(\\\"\\\\u003Cscript\\\\u003E\\\")).indexOf(\\\"loc=MAST noad\\\") !== -1))) {\\u000a        wrap.style.display = \\\"none\\\";\\u000a    }\\u000a;\\u000a}());\"), (\"se1fbd0603f526202587a2b4f56de690dd114e5bb\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    (((function() {\n        var se1fbd0603f526202587a2b4f56de690dd114e5bb_0_instance;\n        ((se1fbd0603f526202587a2b4f56de690dd114e5bb_0_instance) = ((JSBNG_Record.eventInstance)((\"se1fbd0603f526202587a2b4f56de690dd114e5bb_0\"))));\n        return ((JSBNG_Record.markFunction)((function() {\n            if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                return ((JSBNG_Record.eventCall)((arguments.callee), (\"se1fbd0603f526202587a2b4f56de690dd114e5bb_0\"), (se1fbd0603f526202587a2b4f56de690dd114e5bb_0_instance), (this), (arguments)))\n            };\n            (null);\n            var wrap = (((JSBNG_Record.get)(JSBNG__document, (\"getElementById\")))[(\"getElementById\")])(\"yom-ad-MAST\");\n            if ((null == wrap)) {\n                wrap = ((((JSBNG_Record.get)(JSBNG__document, (\"getElementById\")))[(\"getElementById\")])(\"yom-ad-MAST-iframe\") || {\n                });\n            }\n            ;\n            var JSBNG__content = ((((JSBNG_Record.get)(wrap, (\"innerHTML\")))[(\"innerHTML\")]) || \"\");\n            if ((JSBNG__content && ((((JSBNG_Record.get)((((JSBNG_Record.get)(JSBNG__content, (\"substr\")))[(\"substr\")])(0, (((JSBNG_Record.get)(JSBNG__content, (\"lastIndexOf\")))[(\"lastIndexOf\")])(\"\\u003Cscript\\u003E\")), (\"indexOf\")))[(\"indexOf\")])(\"loc=MAST noad\") !== -1))) {\n                ((JSBNG_Record.set)((((JSBNG_Record.get)(wrap, (\"style\")))[(\"style\")]), (\"display\"), \"none\"));\n            }\n            ;\n        })));\n    })())());\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};</script></center></div></center>";
// undefined
o16 = null;
// 1247
o16 = {};
// 1248
f911113496_475.returns.push(o16);
// 1249
o16.innerHTML = "<center><div id=\"yom-ad-LREC-iframe\" class=\"yom-ad\"><center>\n<script>try {\n    ((JSBNG_Record.scriptLoad)((\"(function() {\\u000a    var wrap = document.getElementById(\\\"yom-ad-LREC\\\");\\u000a    if ((null == wrap)) {\\u000a        wrap = (document.getElementById(\\\"yom-ad-LREC-iframe\\\") || {\\u000a        });\\u000a    }\\u000a;\\u000a    var content = (wrap.innerHTML || \\\"\\\");\\u000a    if ((content && (content.substr(0, content.lastIndexOf(\\\"\\\\u003Cscript\\\\u003E\\\")).indexOf(\\\"loc=LREC noad\\\") !== -1))) {\\u000a        wrap.style.display = \\\"none\\\";\\u000a    }\\u000a;\\u000a}());\"), (\"s948e0e6035133da5ed82f540da07ab5598a1a8dd\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    (((function() {\n        var s948e0e6035133da5ed82f540da07ab5598a1a8dd_0_instance;\n        ((s948e0e6035133da5ed82f540da07ab5598a1a8dd_0_instance) = ((JSBNG_Record.eventInstance)((\"s948e0e6035133da5ed82f540da07ab5598a1a8dd_0\"))));\n        return ((JSBNG_Record.markFunction)((function() {\n            if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                return ((JSBNG_Record.eventCall)((arguments.callee), (\"s948e0e6035133da5ed82f540da07ab5598a1a8dd_0\"), (s948e0e6035133da5ed82f540da07ab5598a1a8dd_0_instance), (this), (arguments)))\n            };\n            (null);\n            var wrap = (((JSBNG_Record.get)(JSBNG__document, (\"getElementById\")))[(\"getElementById\")])(\"yom-ad-LREC\");\n            if ((null == wrap)) {\n                wrap = ((((JSBNG_Record.get)(JSBNG__document, (\"getElementById\")))[(\"getElementById\")])(\"yom-ad-LREC-iframe\") || {\n                });\n            }\n            ;\n            var JSBNG__content = ((((JSBNG_Record.get)(wrap, (\"innerHTML\")))[(\"innerHTML\")]) || \"\");\n            if ((JSBNG__content && ((((JSBNG_Record.get)((((JSBNG_Record.get)(JSBNG__content, (\"substr\")))[(\"substr\")])(0, (((JSBNG_Record.get)(JSBNG__content, (\"lastIndexOf\")))[(\"lastIndexOf\")])(\"\\u003Cscript\\u003E\")), (\"indexOf\")))[(\"indexOf\")])(\"loc=LREC noad\") !== -1))) {\n                ((JSBNG_Record.set)((((JSBNG_Record.get)(wrap, (\"style\")))[(\"style\")]), (\"display\"), \"none\"));\n            }\n            ;\n        })));\n    })())());\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};</script></center></div></center>";
// 1252
o17 = {};
// 1253
f911113496_475.returns.push(o17);
// 1254
o17.innerHTML = "<center><div id=\"yom-ad-LREC2-iframe\" class=\"yom-ad\"><center>\n<script>try {\n    ((JSBNG_Record.scriptLoad)((\"(function() {\\u000a    var wrap = document.getElementById(\\\"yom-ad-LREC2\\\");\\u000a    if ((null == wrap)) {\\u000a        wrap = (document.getElementById(\\\"yom-ad-LREC2-iframe\\\") || {\\u000a        });\\u000a    }\\u000a;\\u000a    var content = (wrap.innerHTML || \\\"\\\");\\u000a    if ((content && (content.substr(0, content.lastIndexOf(\\\"\\\\u003Cscript\\\\u003E\\\")).indexOf(\\\"loc=LREC2 noad\\\") !== -1))) {\\u000a        wrap.style.display = \\\"none\\\";\\u000a    }\\u000a;\\u000a}());\"), (\"sd991c19676f447c2f197b3bd52a4d38a8eef7ce7\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    (((function() {\n        var sd991c19676f447c2f197b3bd52a4d38a8eef7ce7_0_instance;\n        ((sd991c19676f447c2f197b3bd52a4d38a8eef7ce7_0_instance) = ((JSBNG_Record.eventInstance)((\"sd991c19676f447c2f197b3bd52a4d38a8eef7ce7_0\"))));\n        return ((JSBNG_Record.markFunction)((function() {\n            if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                return ((JSBNG_Record.eventCall)((arguments.callee), (\"sd991c19676f447c2f197b3bd52a4d38a8eef7ce7_0\"), (sd991c19676f447c2f197b3bd52a4d38a8eef7ce7_0_instance), (this), (arguments)))\n            };\n            (null);\n            var wrap = (((JSBNG_Record.get)(JSBNG__document, (\"getElementById\")))[(\"getElementById\")])(\"yom-ad-LREC2\");\n            if ((null == wrap)) {\n                wrap = ((((JSBNG_Record.get)(JSBNG__document, (\"getElementById\")))[(\"getElementById\")])(\"yom-ad-LREC2-iframe\") || {\n                });\n            }\n            ;\n            var JSBNG__content = ((((JSBNG_Record.get)(wrap, (\"innerHTML\")))[(\"innerHTML\")]) || \"\");\n            if ((JSBNG__content && ((((JSBNG_Record.get)((((JSBNG_Record.get)(JSBNG__content, (\"substr\")))[(\"substr\")])(0, (((JSBNG_Record.get)(JSBNG__content, (\"lastIndexOf\")))[(\"lastIndexOf\")])(\"\\u003Cscript\\u003E\")), (\"indexOf\")))[(\"indexOf\")])(\"loc=LREC2 noad\") !== -1))) {\n                ((JSBNG_Record.set)((((JSBNG_Record.get)(wrap, (\"style\")))[(\"style\")]), (\"display\"), \"none\"));\n            }\n            ;\n        })));\n    })())());\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};</script></center></div></center>";
// 1261
f911113496_7.returns.push(undefined);
// 1263
f911113496_520 = function() { return f911113496_520.returns[f911113496_520.inst++]; };
f911113496_520.returns = [];
f911113496_520.inst = 0;
// 1264
o7.log = f911113496_520;
// 1265
f911113496_521 = function() { return f911113496_521.returns[f911113496_521.inst++]; };
f911113496_521.returns = [];
f911113496_521.inst = 0;
// 1266
o7.error = f911113496_521;
// undefined
o7 = null;
// 1268
o4.protocol = "http:";
// 1269
o0.JSBNG__location = o4;
// 1270
f911113496_470.returns.push(0.5538800491485745);
// 1271
f911113496_470.returns.push(0.5022839542943984);
// 1272
f911113496_470.returns.push(0.7930454909801483);
// 1273
f911113496_470.returns.push(0.9353800876997411);
// 1274
f911113496_470.returns.push(0.024789008079096675);
// 1275
f911113496_470.returns.push(0.09485800517722964);
// 1276
f911113496_470.returns.push(0.24569016648456454);
// 1277
f911113496_470.returns.push(0.16021590097807348);
// 1278
f911113496_470.returns.push(0.9522030979860574);
// 1279
f911113496_470.returns.push(0.5304499589838088);
// 1280
f911113496_470.returns.push(0.7523346887901425);
// 1281
f911113496_470.returns.push(0.25030468706972897);
// 1283
o0.referrer = "";
// undefined
fo911113496_1_cookie = function() { return fo911113496_1_cookie.returns[fo911113496_1_cookie.inst++]; };
fo911113496_1_cookie.returns = [];
fo911113496_1_cookie.inst = 0;
defineGetter(o0, "cookie", fo911113496_1_cookie, undefined);
// undefined
fo911113496_1_cookie.returns.push("B=br5diod8trahs&b=3&s=iu");
// 1286
f911113496_470.returns.push(0.3680493936408311);
// 1287
o7 = {};
// 1288
f911113496_0.returns.push(o7);
// 1289
f911113496_523 = function() { return f911113496_523.returns[f911113496_523.inst++]; };
f911113496_523.returns = [];
f911113496_523.inst = 0;
// 1290
o7.setTime = f911113496_523;
// 1291
o7.getTime = f911113496_472;
// 1292
f911113496_472.returns.push(1373481542220);
// 1293
f911113496_523.returns.push(1688841542220);
// 1294
f911113496_524 = function() { return f911113496_524.returns[f911113496_524.inst++]; };
f911113496_524.returns = [];
f911113496_524.inst = 0;
// 1295
o7.toGMTString = f911113496_524;
// undefined
o7 = null;
// 1296
f911113496_524.returns.push("Sat, 08 Jul 2023 18:39:02 GMT");
// 1297
// 1299
o7 = {};
// 1300
f911113496_475.returns.push(o7);
// 1302
f911113496_526 = function() { return f911113496_526.returns[f911113496_526.inst++]; };
f911113496_526.returns = [];
f911113496_526.inst = 0;
// 1303
o5.hasAttribute = f911113496_526;
// 1304
f911113496_527 = function() { return f911113496_527.returns[f911113496_527.inst++]; };
f911113496_527.returns = [];
f911113496_527.inst = 0;
// 1305
o7.getAttribute = f911113496_527;
// 1307
f911113496_527.returns.push(null);
// 1312
f911113496_527.returns.push("mid:mediacontentnavigation;mpos:1;");
// 1313
f911113496_528 = function() { return f911113496_528.returns[f911113496_528.inst++]; };
f911113496_528.returns = [];
f911113496_528.inst = 0;
// 1314
o7.getElementsByTagName = f911113496_528;
// 1315
o18 = {};
// 1316
f911113496_528.returns.push(o18);
// 1317
o18.length = 14;
// 1318
o19 = {};
// 1319
o18["0"] = o19;
// 1320
o20 = {};
// 1321
o18["1"] = o20;
// 1322
o21 = {};
// 1323
o18["2"] = o21;
// 1324
o22 = {};
// 1325
o18["3"] = o22;
// 1326
o23 = {};
// 1327
o18["4"] = o23;
// 1328
o24 = {};
// 1329
o18["5"] = o24;
// 1330
o25 = {};
// 1331
o18["6"] = o25;
// 1332
o26 = {};
// 1333
o18["7"] = o26;
// 1334
o27 = {};
// 1335
o18["8"] = o27;
// 1336
o28 = {};
// 1337
o18["9"] = o28;
// 1338
o29 = {};
// 1339
o18["10"] = o29;
// 1340
o30 = {};
// 1341
o18["11"] = o30;
// 1342
o31 = {};
// 1343
o18["12"] = o31;
// 1344
o32 = {};
// 1345
o18["13"] = o32;
// undefined
o18 = null;
// 1347
o18 = {};
// 1348
f911113496_528.returns.push(o18);
// 1349
o18.length = 0;
// undefined
o18 = null;
// 1351
o18 = {};
// 1352
f911113496_528.returns.push(o18);
// 1353
o18.length = 0;
// undefined
o18 = null;
// 1354
o19.sourceIndex = void 0;
// 1355
f911113496_546 = function() { return f911113496_546.returns[f911113496_546.inst++]; };
f911113496_546.returns = [];
f911113496_546.inst = 0;
// 1356
o19.compareDocumentPosition = f911113496_546;
// 1358
f911113496_546.returns.push(4);
// 1359
o21.compareDocumentPosition = f911113496_546;
// 1360
f911113496_546.returns.push(4);
// 1361
o23.compareDocumentPosition = f911113496_546;
// 1362
f911113496_546.returns.push(4);
// 1363
o25.compareDocumentPosition = f911113496_546;
// 1364
f911113496_546.returns.push(4);
// 1365
o27.compareDocumentPosition = f911113496_546;
// 1366
f911113496_546.returns.push(4);
// 1367
o29.compareDocumentPosition = f911113496_546;
// 1368
f911113496_546.returns.push(4);
// 1369
o31.compareDocumentPosition = f911113496_546;
// 1370
f911113496_546.returns.push(4);
// 1372
f911113496_546.returns.push(4);
// 1373
o20.compareDocumentPosition = f911113496_546;
// 1374
f911113496_546.returns.push(4);
// 1376
f911113496_546.returns.push(4);
// 1377
o24.compareDocumentPosition = f911113496_546;
// 1378
f911113496_546.returns.push(4);
// 1380
f911113496_546.returns.push(4);
// 1381
o28.compareDocumentPosition = f911113496_546;
// 1382
f911113496_546.returns.push(4);
// 1384
f911113496_546.returns.push(4);
// 1386
f911113496_546.returns.push(4);
// 1388
f911113496_546.returns.push(4);
// 1389
o22.compareDocumentPosition = f911113496_546;
// 1390
f911113496_546.returns.push(4);
// 1392
f911113496_546.returns.push(4);
// 1394
f911113496_546.returns.push(4);
// 1396
f911113496_546.returns.push(4);
// 1397
o30.compareDocumentPosition = f911113496_546;
// 1398
f911113496_546.returns.push(4);
// 1400
f911113496_546.returns.push(4);
// 1402
f911113496_546.returns.push(4);
// 1404
f911113496_546.returns.push(4);
// 1406
f911113496_546.returns.push(4);
// 1408
f911113496_546.returns.push(4);
// 1410
f911113496_546.returns.push(4);
// 1412
f911113496_546.returns.push(4);
// 1413
o26.compareDocumentPosition = f911113496_546;
// 1414
f911113496_546.returns.push(4);
// 1419
f911113496_527.returns.push("yom-mod navigation");
// 1424
f911113496_527.returns.push("yom-mod navigation");
// 1429
f911113496_527.returns.push("yom-mod navigation");
// 1434
f911113496_527.returns.push("yom-mod navigation");
// 1439
f911113496_527.returns.push(null);
// 1440
o19.setAttribute = f911113496_513;
// 1441
f911113496_513.returns.push(undefined);
// 1442
o19.nodeName = "A";
// 1443
o19.textContent = "Home";
// 1446
o19.getAttribute = f911113496_527;
// 1448
f911113496_527.returns.push("navigate");
// 1453
f911113496_527.returns.push("itc:0;tar:news.yahoo.com;ct:;ltxt:home;sec:lnav-s;slk:link;cpos:1;");
// 1454
o20.setAttribute = f911113496_513;
// 1455
f911113496_513.returns.push(undefined);
// 1456
o20.nodeName = "A";
// 1457
o20.textContent = "U.S.";
// 1460
o20.getAttribute = f911113496_527;
// 1462
f911113496_527.returns.push("navigate");
// 1467
f911113496_527.returns.push("itc:0;tar:news.yahoo.com;ct:;ltxt:us;sec:lnav-s;slk:link;cpos:2;");
// 1468
o21.setAttribute = f911113496_513;
// 1469
f911113496_513.returns.push(undefined);
// 1470
o21.nodeName = "A";
// 1471
o21.textContent = "World";
// 1474
o21.getAttribute = f911113496_527;
// 1476
f911113496_527.returns.push("navigate");
// 1481
f911113496_527.returns.push("itc:0;tar:news.yahoo.com;ct:;ltxt:world;sec:lnav-s;slk:link;cpos:3;");
// 1482
o22.setAttribute = f911113496_513;
// 1483
f911113496_513.returns.push(undefined);
// 1484
o22.nodeName = "A";
// 1485
o22.textContent = "Politics";
// 1488
o22.getAttribute = f911113496_527;
// 1490
f911113496_527.returns.push("navigate");
// 1495
f911113496_527.returns.push("itc:0;tar:news.yahoo.com;ct:;ltxt:politics;sec:lnav-s;slk:link;cpos:4;");
// 1496
o23.setAttribute = f911113496_513;
// 1497
f911113496_513.returns.push(undefined);
// 1498
o23.nodeName = "A";
// 1499
o23.textContent = "Tech";
// 1502
o23.getAttribute = f911113496_527;
// 1504
f911113496_527.returns.push("navigate");
// 1509
f911113496_527.returns.push("itc:0;tar:news.yahoo.com;ct:;ltxt:tech;sec:lnav-s;slk:link;cpos:5;");
// 1510
o24.setAttribute = f911113496_513;
// 1511
f911113496_513.returns.push(undefined);
// 1512
o24.nodeName = "A";
// 1513
o24.textContent = "Science";
// 1516
o24.getAttribute = f911113496_527;
// 1518
f911113496_527.returns.push("navigate");
// 1523
f911113496_527.returns.push("itc:0;tar:news.yahoo.com;ct:;ltxt:science;sec:lnav-s;slk:link;cpos:6;");
// 1524
o25.setAttribute = f911113496_513;
// 1525
f911113496_513.returns.push(undefined);
// 1526
o25.nodeName = "A";
// 1527
o25.textContent = "Health";
// 1530
o25.getAttribute = f911113496_527;
// 1532
f911113496_527.returns.push("navigate");
// 1537
f911113496_527.returns.push("itc:0;tar:news.yahoo.com;ct:;ltxt:health;sec:lnav-s;slk:link;cpos:7;");
// 1538
o26.setAttribute = f911113496_513;
// 1539
f911113496_513.returns.push(undefined);
// 1540
o26.nodeName = "A";
// 1541
o26.textContent = "Odd News";
// 1544
o26.getAttribute = f911113496_527;
// 1546
f911113496_527.returns.push("navigate");
// 1551
f911113496_527.returns.push("itc:0;tar:news.yahoo.com;ct:;ltxt:oddnews;sec:lnav-s;slk:link;cpos:8;");
// 1552
o27.setAttribute = f911113496_513;
// 1553
f911113496_513.returns.push(undefined);
// 1554
o27.nodeName = "A";
// 1555
o27.textContent = "Opinion";
// 1558
o27.getAttribute = f911113496_527;
// 1560
f911113496_527.returns.push("navigate");
// 1565
f911113496_527.returns.push("itc:0;tar:news.yahoo.com;ct:;ltxt:opinion;sec:lnav-s;slk:link;cpos:9;");
// 1566
o28.setAttribute = f911113496_513;
// 1567
f911113496_513.returns.push(undefined);
// 1568
o28.nodeName = "A";
// 1569
o28.textContent = "Local";
// 1572
o28.getAttribute = f911113496_527;
// 1574
f911113496_527.returns.push("navigate");
// 1579
f911113496_527.returns.push("itc:0;tar:news.yahoo.com;ct:;ltxt:local;sec:lnav-s;slk:link;cpos:10;");
// 1580
o29.setAttribute = f911113496_513;
// 1581
f911113496_513.returns.push(undefined);
// 1582
o29.nodeName = "A";
// 1583
o29.textContent = "Dear Abby";
// 1586
o29.getAttribute = f911113496_527;
// 1588
f911113496_527.returns.push("navigate");
// 1593
f911113496_527.returns.push("itc:0;tar:news.yahoo.com;ct:;ltxt:dearabby;sec:lnav-s;slk:link;cpos:11;");
// 1594
o30.setAttribute = f911113496_513;
// 1595
f911113496_513.returns.push(undefined);
// 1596
o30.nodeName = "A";
// 1597
o30.textContent = "Comics";
// 1600
o30.getAttribute = f911113496_527;
// 1602
f911113496_527.returns.push("navigate");
// 1607
f911113496_527.returns.push("itc:0;tar:news.yahoo.com;ct:;ltxt:comics;sec:lnav-s;slk:link;cpos:12;");
// 1608
o31.setAttribute = f911113496_513;
// 1609
f911113496_513.returns.push(undefined);
// 1610
o31.nodeName = "A";
// 1611
o31.textContent = "ABC News";
// 1614
o31.getAttribute = f911113496_527;
// 1616
f911113496_527.returns.push("navigate");
// 1621
f911113496_527.returns.push("itc:0;tar:news.yahoo.com;ct:;ltxt:abcnews;sec:lnav-s;slk:link;cpos:13;");
// 1622
o32.setAttribute = f911113496_513;
// 1623
f911113496_513.returns.push(undefined);
// 1624
o32.nodeName = "A";
// 1625
o32.textContent = "Y! News Originals";
// 1628
o32.getAttribute = f911113496_527;
// 1630
f911113496_527.returns.push("navigate");
// 1635
f911113496_527.returns.push("itc:0;tar:news.yahoo.com;ct:;ltxt:ynewsori;sec:lnav-s;slk:link;cpos:14;");
// 1636
f911113496_547 = function() { return f911113496_547.returns[f911113496_547.inst++]; };
f911113496_547.returns = [];
f911113496_547.inst = 0;
// 1637
o7.JSBNG__addEventListener = f911113496_547;
// 1639
f911113496_547.returns.push(undefined);
// 1641
f911113496_475.returns.push(null);
// 1643
f911113496_521.returns.push(undefined);
// 1645
o18 = {};
// 1646
f911113496_475.returns.push(o18);
// 1649
o18.getAttribute = f911113496_527;
// 1651
f911113496_527.returns.push(null);
// 1656
f911113496_527.returns.push("mid:mediacontentlead;mpos:1;sec:mod-ld;");
// 1657
o18.getElementsByTagName = f911113496_528;
// 1658
o33 = {};
// 1659
f911113496_528.returns.push(o33);
// 1660
o33.length = 7;
// 1661
o34 = {};
// 1662
o33["0"] = o34;
// 1663
o35 = {};
// 1664
o33["1"] = o35;
// 1665
o36 = {};
// 1666
o33["2"] = o36;
// 1667
o37 = {};
// 1668
o33["3"] = o37;
// 1669
o38 = {};
// 1670
o33["4"] = o38;
// 1671
o39 = {};
// 1672
o33["5"] = o39;
// 1673
o40 = {};
// 1674
o33["6"] = o40;
// undefined
o33 = null;
// 1676
o33 = {};
// 1677
f911113496_528.returns.push(o33);
// 1678
o33.length = 0;
// undefined
o33 = null;
// 1680
o33 = {};
// 1681
f911113496_528.returns.push(o33);
// 1682
o33.length = 0;
// undefined
o33 = null;
// 1683
o34.sourceIndex = void 0;
// 1684
o34.compareDocumentPosition = f911113496_546;
// 1686
f911113496_546.returns.push(4);
// 1687
o36.compareDocumentPosition = f911113496_546;
// 1688
f911113496_546.returns.push(4);
// 1689
o38.compareDocumentPosition = f911113496_546;
// 1690
f911113496_546.returns.push(4);
// 1692
f911113496_546.returns.push(4);
// 1693
o35.compareDocumentPosition = f911113496_546;
// 1694
f911113496_546.returns.push(4);
// 1696
f911113496_546.returns.push(4);
// 1697
o39.compareDocumentPosition = f911113496_546;
// 1698
f911113496_546.returns.push(4);
// 1700
f911113496_546.returns.push(4);
// 1702
f911113496_546.returns.push(4);
// 1704
f911113496_546.returns.push(4);
// 1705
o37.compareDocumentPosition = f911113496_546;
// 1706
f911113496_546.returns.push(4);
// 1711
f911113496_527.returns.push("yom-mod yom-lead clearfix");
// 1716
f911113496_527.returns.push("yom-mod yom-lead clearfix");
// 1721
f911113496_527.returns.push("yom-mod yom-lead clearfix");
// 1726
f911113496_527.returns.push("yom-mod yom-lead clearfix");
// 1731
f911113496_527.returns.push(null);
// 1732
o34.setAttribute = f911113496_513;
// 1733
f911113496_513.returns.push(undefined);
// 1734
o34.nodeName = "A";
// 1735
o34.textContent = "  ";
// 1736
o33 = {};
// 1737
o34.childNodes = o33;
// 1738
o41 = {};
// 1739
o33["0"] = o41;
// 1740
o41.nodeType = 3;
// undefined
o41 = null;
// 1742
o41 = {};
// 1743
o33["1"] = o41;
// 1744
o41.nodeType = 1;
// 1745
o41.nodeName = "SPAN";
// 1746
o42 = {};
// 1747
o41.childNodes = o42;
// undefined
o41 = null;
// 1748
o42["0"] = void 0;
// undefined
o42 = null;
// 1750
o41 = {};
// 1751
o33["2"] = o41;
// 1752
o41.nodeType = 3;
// undefined
o41 = null;
// 1754
o33["3"] = void 0;
// undefined
o33 = null;
// 1757
o34.getAttribute = f911113496_527;
// 1759
f911113496_527.returns.push("http://news.yahoo.com/judge-rules-against-zimmerman-evidence-132354666.html");
// 1764
f911113496_527.returns.push(null);
// 1769
f911113496_527.returns.push("itc:0;tar:news.yahoo.com;ct:1;sec:mod-ld;slk:link;cpos:1;pkgt:1;pos:1;g:8a1c7605-0ff6-3150-9990-76dae34185d8;prov:Associated Press;test:gs03;");
// 1770
o35.setAttribute = f911113496_513;
// 1771
f911113496_513.returns.push(undefined);
// 1772
o35.nodeName = "A";
// 1773
o35.textContent = "Judge rules against Zimmerman on evidence";
// 1776
o35.getAttribute = f911113496_527;
// 1778
f911113496_527.returns.push(null);
// 1783
f911113496_527.returns.push("itc:0;tar:news.yahoo.com;ct:1;sec:mod-ld;slk:link;cpos:1;pkgt:1;pos:1;g:8a1c7605-0ff6-3150-9990-76dae34185d8;prov:Associated Press;test:gs03;");
// 1784
o36.setAttribute = f911113496_513;
// 1785
f911113496_513.returns.push(undefined);
// 1786
o36.nodeName = "A";
// 1787
o36.textContent = "Read More »";
// 1790
o36.getAttribute = f911113496_527;
// 1792
f911113496_527.returns.push(null);
// 1797
f911113496_527.returns.push("itc:0;tar:news.yahoo.com;ct:1;sec:mod-ld;slk:link;cpos:1;pkgt:1;pos:1;g:8a1c7605-0ff6-3150-9990-76dae34185d8;prov:Associated Press;test:gs03;");
// 1798
o37.setAttribute = f911113496_513;
// 1799
f911113496_513.returns.push(undefined);
// 1800
o37.nodeName = "A";
// 1801
o37.textContent = "  ";
// 1802
o33 = {};
// 1803
o37.childNodes = o33;
// 1804
o41 = {};
// 1805
o33["0"] = o41;
// 1806
o41.nodeType = 3;
// undefined
o41 = null;
// 1808
o41 = {};
// 1809
o33["1"] = o41;
// 1810
o41.nodeType = 1;
// 1811
o41.nodeName = "SPAN";
// 1812
o42 = {};
// 1813
o41.childNodes = o42;
// undefined
o41 = null;
// 1814
o42["0"] = void 0;
// undefined
o42 = null;
// 1816
o41 = {};
// 1817
o33["2"] = o41;
// 1818
o41.nodeType = 3;
// undefined
o41 = null;
// 1820
o33["3"] = void 0;
// undefined
o33 = null;
// 1823
o37.getAttribute = f911113496_527;
// 1825
f911113496_527.returns.push("http://news.yahoo.com/bombing-suspect-heads-1st-public-court-hearing-104650701.html");
// 1830
f911113496_527.returns.push(null);
// 1835
f911113496_527.returns.push("itc:0;tar:news.yahoo.com;ct:1;sec:mod-ld;slk:link;cpos:2;pkgt:1;pos:1;g:578e6c22-0186-30ad-82bc-d1ce5f90105b;prov:Associated Press;test:gs03;");
// 1836
o38.setAttribute = f911113496_513;
// 1837
f911113496_513.returns.push(undefined);
// 1838
o38.nodeName = "A";
// 1839
o38.textContent = "Bombing suspect heads to 1st public court hearing";
// 1842
o38.getAttribute = f911113496_527;
// 1844
f911113496_527.returns.push(null);
// 1849
f911113496_527.returns.push("itc:0;tar:news.yahoo.com;ct:1;sec:mod-ld;slk:link;cpos:2;pkgt:1;pos:1;g:578e6c22-0186-30ad-82bc-d1ce5f90105b;prov:Associated Press;test:gs03;");
// 1850
o39.setAttribute = f911113496_513;
// 1851
f911113496_513.returns.push(undefined);
// 1852
o39.nodeName = "A";
// 1853
o39.textContent = "  ";
// 1854
o33 = {};
// 1855
o39.childNodes = o33;
// 1856
o41 = {};
// 1857
o33["0"] = o41;
// 1858
o41.nodeType = 3;
// undefined
o41 = null;
// 1860
o41 = {};
// 1861
o33["1"] = o41;
// 1862
o41.nodeType = 1;
// 1863
o41.nodeName = "SPAN";
// 1864
o42 = {};
// 1865
o41.childNodes = o42;
// undefined
o41 = null;
// 1866
o42["0"] = void 0;
// undefined
o42 = null;
// 1868
o41 = {};
// 1869
o33["2"] = o41;
// 1870
o41.nodeType = 3;
// undefined
o41 = null;
// 1872
o33["3"] = void 0;
// undefined
o33 = null;
// 1875
o39.getAttribute = f911113496_527;
// 1877
f911113496_527.returns.push("http://news.yahoo.com/sf-probe-brings-questions-over-auto-speed-controls-084646467.html");
// 1882
f911113496_527.returns.push(null);
// 1887
f911113496_527.returns.push("itc:0;tar:news.yahoo.com;ct:1;sec:mod-ld;slk:link;cpos:3;pkgt:1;pos:1;g:43e80a47-79ec-3809-ac98-1518389138c7;prov:Associated Press;test:gs03;");
// 1888
o40.setAttribute = f911113496_513;
// 1889
f911113496_513.returns.push(undefined);
// 1890
o40.nodeName = "A";
// 1891
o40.textContent = "SF probe brings questions over auto speed controls";
// 1894
o40.getAttribute = f911113496_527;
// 1896
f911113496_527.returns.push(null);
// 1901
f911113496_527.returns.push("itc:0;tar:news.yahoo.com;ct:1;sec:mod-ld;slk:link;cpos:3;pkgt:1;pos:1;g:43e80a47-79ec-3809-ac98-1518389138c7;prov:Associated Press;test:gs03;");
// 1902
o18.JSBNG__addEventListener = f911113496_547;
// 1904
f911113496_547.returns.push(undefined);
// 1906
f911113496_475.returns.push(null);
// 1908
f911113496_521.returns.push(undefined);
// 1910
f911113496_475.returns.push(null);
// 1912
f911113496_521.returns.push(undefined);
// 1914
o33 = {};
// 1915
f911113496_475.returns.push(o33);
// 1918
o33.getAttribute = f911113496_527;
// 1920
f911113496_527.returns.push(null);
// 1925
f911113496_527.returns.push("mid:mediacontentgenericlistings;mpos:1;");
// 1926
o33.getElementsByTagName = f911113496_528;
// 1927
o41 = {};
// 1928
f911113496_528.returns.push(o41);
// 1929
o41.length = 20;
// 1930
o42 = {};
// 1931
o41["0"] = o42;
// 1932
o43 = {};
// 1933
o41["1"] = o43;
// 1934
o44 = {};
// 1935
o41["2"] = o44;
// 1936
o45 = {};
// 1937
o41["3"] = o45;
// 1938
o46 = {};
// 1939
o41["4"] = o46;
// 1940
o47 = {};
// 1941
o41["5"] = o47;
// 1942
o48 = {};
// 1943
o41["6"] = o48;
// 1944
o49 = {};
// 1945
o41["7"] = o49;
// 1946
o50 = {};
// 1947
o41["8"] = o50;
// 1948
o51 = {};
// 1949
o41["9"] = o51;
// 1950
o52 = {};
// 1951
o41["10"] = o52;
// 1952
o53 = {};
// 1953
o41["11"] = o53;
// 1954
o54 = {};
// 1955
o41["12"] = o54;
// 1956
o55 = {};
// 1957
o41["13"] = o55;
// 1958
o56 = {};
// 1959
o41["14"] = o56;
// 1960
o57 = {};
// 1961
o41["15"] = o57;
// 1962
o58 = {};
// 1963
o41["16"] = o58;
// 1964
o59 = {};
// 1965
o41["17"] = o59;
// 1966
o60 = {};
// 1967
o41["18"] = o60;
// 1968
o61 = {};
// 1969
o41["19"] = o61;
// undefined
o41 = null;
// 1971
o41 = {};
// 1972
f911113496_528.returns.push(o41);
// 1973
o41.length = 0;
// undefined
o41 = null;
// 1975
o41 = {};
// 1976
f911113496_528.returns.push(o41);
// 1977
o41.length = 0;
// undefined
o41 = null;
// 1978
o42.sourceIndex = void 0;
// 1979
o42.compareDocumentPosition = f911113496_546;
// 1981
f911113496_546.returns.push(4);
// 1982
o44.compareDocumentPosition = f911113496_546;
// 1983
f911113496_546.returns.push(4);
// 1984
o46.compareDocumentPosition = f911113496_546;
// 1985
f911113496_546.returns.push(4);
// 1986
o48.compareDocumentPosition = f911113496_546;
// 1987
f911113496_546.returns.push(4);
// 1988
o50.compareDocumentPosition = f911113496_546;
// 1989
f911113496_546.returns.push(4);
// 1990
o52.compareDocumentPosition = f911113496_546;
// 1991
f911113496_546.returns.push(4);
// 1992
o54.compareDocumentPosition = f911113496_546;
// 1993
f911113496_546.returns.push(4);
// 1994
o56.compareDocumentPosition = f911113496_546;
// 1995
f911113496_546.returns.push(4);
// 1996
o58.compareDocumentPosition = f911113496_546;
// 1997
f911113496_546.returns.push(4);
// 1998
o60.compareDocumentPosition = f911113496_546;
// 1999
f911113496_546.returns.push(4);
// 2001
f911113496_546.returns.push(4);
// 2002
o43.compareDocumentPosition = f911113496_546;
// 2003
f911113496_546.returns.push(4);
// 2005
f911113496_546.returns.push(4);
// 2006
o47.compareDocumentPosition = f911113496_546;
// 2007
f911113496_546.returns.push(4);
// 2009
f911113496_546.returns.push(4);
// 2010
o51.compareDocumentPosition = f911113496_546;
// 2011
f911113496_546.returns.push(4);
// 2013
f911113496_546.returns.push(4);
// 2014
o55.compareDocumentPosition = f911113496_546;
// 2015
f911113496_546.returns.push(4);
// 2017
f911113496_546.returns.push(4);
// 2018
o59.compareDocumentPosition = f911113496_546;
// 2019
f911113496_546.returns.push(4);
// 2021
f911113496_546.returns.push(4);
// 2023
f911113496_546.returns.push(4);
// 2025
f911113496_546.returns.push(4);
// 2026
o45.compareDocumentPosition = f911113496_546;
// 2027
f911113496_546.returns.push(4);
// 2029
f911113496_546.returns.push(4);
// 2031
f911113496_546.returns.push(4);
// 2033
f911113496_546.returns.push(4);
// 2034
o53.compareDocumentPosition = f911113496_546;
// 2035
f911113496_546.returns.push(4);
// 2037
f911113496_546.returns.push(4);
// 2039
f911113496_546.returns.push(4);
// 2041
f911113496_546.returns.push(4);
// 2043
f911113496_546.returns.push(4);
// 2045
f911113496_546.returns.push(4);
// 2047
f911113496_546.returns.push(4);
// 2049
f911113496_546.returns.push(4);
// 2050
o49.compareDocumentPosition = f911113496_546;
// 2051
f911113496_546.returns.push(4);
// 2053
f911113496_546.returns.push(4);
// 2055
f911113496_546.returns.push(4);
// 2057
f911113496_546.returns.push(4);
// 2059
f911113496_546.returns.push(4);
// 2061
f911113496_546.returns.push(4);
// 2063
f911113496_546.returns.push(4);
// 2065
f911113496_546.returns.push(4);
// 2067
f911113496_546.returns.push(4);
// 2069
f911113496_546.returns.push(4);
// 2071
f911113496_546.returns.push(4);
// 2073
f911113496_546.returns.push(4);
// 2075
f911113496_546.returns.push(4);
// 2077
f911113496_546.returns.push(4);
// 2079
f911113496_546.returns.push(4);
// 2081
f911113496_546.returns.push(4);
// 2082
o57.compareDocumentPosition = f911113496_546;
// 2083
f911113496_546.returns.push(4);
// 2088
f911113496_527.returns.push("yom-mod ");
// 2093
f911113496_527.returns.push("yom-mod ");
// 2098
f911113496_527.returns.push("yom-mod ");
// 2103
f911113496_527.returns.push("yom-mod ");
// 2108
f911113496_527.returns.push(null);
// 2109
o42.setAttribute = f911113496_513;
// 2110
f911113496_513.returns.push(undefined);
// 2111
o42.nodeName = "A";
// 2112
o42.textContent = "   ";
// 2113
o41 = {};
// 2114
o42.childNodes = o41;
// 2115
o62 = {};
// 2116
o41["0"] = o62;
// 2117
o62.nodeType = 3;
// undefined
o62 = null;
// 2119
o62 = {};
// 2120
o41["1"] = o62;
// 2121
o62.nodeType = 1;
// 2122
o62.nodeName = "IMG";
// 2125
o62.getAttribute = f911113496_527;
// 2127
f911113496_527.returns.push(null);
// 2128
o63 = {};
// 2129
o62.childNodes = o63;
// 2130
o63["0"] = void 0;
// undefined
o63 = null;
// 2132
o63 = {};
// 2133
o41["2"] = o63;
// 2134
o63.nodeType = 3;
// undefined
o63 = null;
// 2136
o63 = {};
// 2137
o41["3"] = o63;
// 2138
o63.nodeType = 1;
// 2139
o63.nodeName = "SPAN";
// 2140
o64 = {};
// 2141
o63.childNodes = o64;
// undefined
o63 = null;
// 2142
o63 = {};
// 2143
o64["0"] = o63;
// 2144
o63.nodeType = 1;
// 2145
o63.nodeName = "I";
// 2146
o65 = {};
// 2147
o63.childNodes = o65;
// undefined
o63 = null;
// 2148
o65["0"] = void 0;
// undefined
o65 = null;
// 2150
o64["1"] = void 0;
// undefined
o64 = null;
// 2152
o63 = {};
// 2153
o41["4"] = o63;
// 2154
o63.nodeType = 3;
// undefined
o63 = null;
// 2156
o41["5"] = void 0;
// undefined
o41 = null;
// 2159
o42.getAttribute = f911113496_527;
// 2161
f911113496_527.returns.push("/video/david-tillmans-midday-weather-forecast-174557836.html");
// 2166
f911113496_527.returns.push(null);
// 2171
f911113496_527.returns.push("itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:DavidTil;cpos:1;test:;g:d99db792-ac02-3755-89d1-c481368027b5;");
// 2172
o43.setAttribute = f911113496_513;
// 2173
f911113496_513.returns.push(undefined);
// 2174
o43.nodeName = "A";
// 2175
o43.textContent = "David Tillman's midday weather forecast";
// 2178
o43.getAttribute = f911113496_527;
// 2180
f911113496_527.returns.push(null);
// 2185
f911113496_527.returns.push("itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:DavidTil;cpos:1;test:;g:d99db792-ac02-3755-89d1-c481368027b5;");
// 2186
o44.setAttribute = f911113496_513;
// 2187
f911113496_513.returns.push(undefined);
// 2188
o44.nodeName = "A";
// 2189
o44.textContent = "   ";
// 2190
o41 = {};
// 2191
o44.childNodes = o41;
// 2192
o63 = {};
// 2193
o41["0"] = o63;
// 2194
o63.nodeType = 3;
// undefined
o63 = null;
// 2196
o63 = {};
// 2197
o41["1"] = o63;
// 2198
o63.nodeType = 1;
// 2199
o63.nodeName = "IMG";
// 2202
o63.getAttribute = f911113496_527;
// 2204
f911113496_527.returns.push(null);
// 2205
o64 = {};
// 2206
o63.childNodes = o64;
// 2207
o64["0"] = void 0;
// undefined
o64 = null;
// 2209
o64 = {};
// 2210
o41["2"] = o64;
// 2211
o64.nodeType = 3;
// undefined
o64 = null;
// 2213
o64 = {};
// 2214
o41["3"] = o64;
// 2215
o64.nodeType = 1;
// 2216
o64.nodeName = "SPAN";
// 2217
o65 = {};
// 2218
o64.childNodes = o65;
// undefined
o64 = null;
// 2219
o64 = {};
// 2220
o65["0"] = o64;
// 2221
o64.nodeType = 1;
// 2222
o64.nodeName = "I";
// 2223
o66 = {};
// 2224
o64.childNodes = o66;
// undefined
o64 = null;
// 2225
o66["0"] = void 0;
// undefined
o66 = null;
// 2227
o65["1"] = void 0;
// undefined
o65 = null;
// 2229
o64 = {};
// 2230
o41["4"] = o64;
// 2231
o64.nodeType = 3;
// undefined
o64 = null;
// 2233
o41["5"] = void 0;
// undefined
o41 = null;
// 2236
o44.getAttribute = f911113496_527;
// 2238
f911113496_527.returns.push("/video/printer-ink-efficiency-tested-consumer-174417327.html");
// 2243
f911113496_527.returns.push(null);
// 2248
f911113496_527.returns.push("itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:Printeri;cpos:2;test:;g:c621133c-f907-3f42-93ff-20ef01effa97;");
// 2249
o45.setAttribute = f911113496_513;
// 2250
f911113496_513.returns.push(undefined);
// 2251
o45.nodeName = "A";
// 2252
o45.textContent = "Printer ink efficiency tested by Consumer Reports";
// 2255
o45.getAttribute = f911113496_527;
// 2257
f911113496_527.returns.push(null);
// 2262
f911113496_527.returns.push("itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:Printeri;cpos:2;test:;g:c621133c-f907-3f42-93ff-20ef01effa97;");
// 2263
o46.setAttribute = f911113496_513;
// 2264
f911113496_513.returns.push(undefined);
// 2265
o46.nodeName = "A";
// 2266
o46.textContent = "   ";
// 2267
o41 = {};
// 2268
o46.childNodes = o41;
// 2269
o64 = {};
// 2270
o41["0"] = o64;
// 2271
o64.nodeType = 3;
// undefined
o64 = null;
// 2273
o64 = {};
// 2274
o41["1"] = o64;
// 2275
o64.nodeType = 1;
// 2276
o64.nodeName = "IMG";
// 2279
o64.getAttribute = f911113496_527;
// 2281
f911113496_527.returns.push(null);
// 2282
o65 = {};
// 2283
o64.childNodes = o65;
// 2284
o65["0"] = void 0;
// undefined
o65 = null;
// 2286
o65 = {};
// 2287
o41["2"] = o65;
// 2288
o65.nodeType = 3;
// undefined
o65 = null;
// 2290
o65 = {};
// 2291
o41["3"] = o65;
// 2292
o65.nodeType = 1;
// 2293
o65.nodeName = "SPAN";
// 2294
o66 = {};
// 2295
o65.childNodes = o66;
// undefined
o65 = null;
// 2296
o65 = {};
// 2297
o66["0"] = o65;
// 2298
o65.nodeType = 1;
// 2299
o65.nodeName = "I";
// 2300
o67 = {};
// 2301
o65.childNodes = o67;
// undefined
o65 = null;
// 2302
o67["0"] = void 0;
// undefined
o67 = null;
// 2304
o66["1"] = void 0;
// undefined
o66 = null;
// 2306
o65 = {};
// 2307
o41["4"] = o65;
// 2308
o65.nodeType = 3;
// undefined
o65 = null;
// 2310
o41["5"] = void 0;
// undefined
o41 = null;
// 2313
o46.getAttribute = f911113496_527;
// 2315
f911113496_527.returns.push("/video/rare-film-shows-fdr-pushed-174224035.html");
// 2320
f911113496_527.returns.push(null);
// 2325
f911113496_527.returns.push("itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:RareFilm;cpos:3;test:;g:331b7a46-49c4-3836-a09b-e384123ad646;");
// 2326
o47.setAttribute = f911113496_513;
// 2327
f911113496_513.returns.push(undefined);
// 2328
o47.nodeName = "A";
// 2329
o47.textContent = "Rare Film Shows FDR Pushed in Wheelchair";
// 2332
o47.getAttribute = f911113496_527;
// 2334
f911113496_527.returns.push(null);
// 2339
f911113496_527.returns.push("itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:RareFilm;cpos:3;test:;g:331b7a46-49c4-3836-a09b-e384123ad646;");
// 2340
o48.setAttribute = f911113496_513;
// 2341
f911113496_513.returns.push(undefined);
// 2342
o48.nodeName = "A";
// 2343
o48.textContent = "   ";
// 2344
o41 = {};
// 2345
o48.childNodes = o41;
// 2346
o65 = {};
// 2347
o41["0"] = o65;
// 2348
o65.nodeType = 3;
// undefined
o65 = null;
// 2350
o65 = {};
// 2351
o41["1"] = o65;
// 2352
o65.nodeType = 1;
// 2353
o65.nodeName = "IMG";
// 2356
o65.getAttribute = f911113496_527;
// 2358
f911113496_527.returns.push(null);
// 2359
o66 = {};
// 2360
o65.childNodes = o66;
// 2361
o66["0"] = void 0;
// undefined
o66 = null;
// 2363
o66 = {};
// 2364
o41["2"] = o66;
// 2365
o66.nodeType = 3;
// undefined
o66 = null;
// 2367
o66 = {};
// 2368
o41["3"] = o66;
// 2369
o66.nodeType = 1;
// 2370
o66.nodeName = "SPAN";
// 2371
o67 = {};
// 2372
o66.childNodes = o67;
// undefined
o66 = null;
// 2373
o66 = {};
// 2374
o67["0"] = o66;
// 2375
o66.nodeType = 1;
// 2376
o66.nodeName = "I";
// 2377
o68 = {};
// 2378
o66.childNodes = o68;
// undefined
o66 = null;
// 2379
o68["0"] = void 0;
// undefined
o68 = null;
// 2381
o67["1"] = void 0;
// undefined
o67 = null;
// 2383
o66 = {};
// 2384
o41["4"] = o66;
// 2385
o66.nodeType = 3;
// undefined
o66 = null;
// 2387
o41["5"] = void 0;
// undefined
o41 = null;
// 2390
o48.getAttribute = f911113496_527;
// 2392
f911113496_527.returns.push("/video/lunch-break-07-10-13-172614033.html");
// 2397
f911113496_527.returns.push(null);
// 2402
f911113496_527.returns.push("itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:LunchBre;cpos:4;test:;g:67587838-99cc-37a2-b1b2-3dcb29642ad9;");
// 2403
o49.setAttribute = f911113496_513;
// 2404
f911113496_513.returns.push(undefined);
// 2405
o49.nodeName = "A";
// 2406
o49.textContent = "Lunch Break 07-10-13";
// 2409
o49.getAttribute = f911113496_527;
// 2411
f911113496_527.returns.push(null);
// 2416
f911113496_527.returns.push("itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:LunchBre;cpos:4;test:;g:67587838-99cc-37a2-b1b2-3dcb29642ad9;");
// 2417
o50.setAttribute = f911113496_513;
// 2418
f911113496_513.returns.push(undefined);
// 2419
o50.nodeName = "A";
// 2420
o50.textContent = "   ";
// 2421
o41 = {};
// 2422
o50.childNodes = o41;
// 2423
o66 = {};
// 2424
o41["0"] = o66;
// 2425
o66.nodeType = 3;
// undefined
o66 = null;
// 2427
o66 = {};
// 2428
o41["1"] = o66;
// 2429
o66.nodeType = 1;
// 2430
o66.nodeName = "IMG";
// 2433
o66.getAttribute = f911113496_527;
// 2435
f911113496_527.returns.push(null);
// 2436
o67 = {};
// 2437
o66.childNodes = o67;
// 2438
o67["0"] = void 0;
// undefined
o67 = null;
// 2440
o67 = {};
// 2441
o41["2"] = o67;
// 2442
o67.nodeType = 3;
// undefined
o67 = null;
// 2444
o67 = {};
// 2445
o41["3"] = o67;
// 2446
o67.nodeType = 1;
// 2447
o67.nodeName = "SPAN";
// 2448
o68 = {};
// 2449
o67.childNodes = o68;
// undefined
o67 = null;
// 2450
o67 = {};
// 2451
o68["0"] = o67;
// 2452
o67.nodeType = 1;
// 2453
o67.nodeName = "I";
// 2454
o69 = {};
// 2455
o67.childNodes = o69;
// undefined
o67 = null;
// 2456
o69["0"] = void 0;
// undefined
o69 = null;
// 2458
o68["1"] = void 0;
// undefined
o68 = null;
// 2460
o67 = {};
// 2461
o41["4"] = o67;
// 2462
o67.nodeType = 3;
// undefined
o67 = null;
// 2464
o41["5"] = void 0;
// undefined
o41 = null;
// 2467
o50.getAttribute = f911113496_527;
// 2469
f911113496_527.returns.push("/video/wishbone-bombay-spice-grill-among-172554941.html");
// 2474
f911113496_527.returns.push(null);
// 2479
f911113496_527.returns.push("itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:Wishbone;cpos:5;test:;g:673e2bc5-5e04-3db5-b7ee-847fb557c4b5;");
// 2480
o51.setAttribute = f911113496_513;
// 2481
f911113496_513.returns.push(undefined);
// 2482
o51.nodeName = "A";
// 2483
o51.textContent = "Wishbone, Bombay Spice & Grill, among newcomers at …";
// 2486
o51.getAttribute = f911113496_527;
// 2488
f911113496_527.returns.push(null);
// 2493
f911113496_527.returns.push("itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:Wishbone;cpos:5;test:;g:673e2bc5-5e04-3db5-b7ee-847fb557c4b5;");
// 2494
o52.setAttribute = f911113496_513;
// 2495
f911113496_513.returns.push(undefined);
// 2496
o52.nodeName = "A";
// 2497
o52.textContent = "   ";
// 2498
o41 = {};
// 2499
o52.childNodes = o41;
// 2500
o67 = {};
// 2501
o41["0"] = o67;
// 2502
o67.nodeType = 3;
// undefined
o67 = null;
// 2504
o67 = {};
// 2505
o41["1"] = o67;
// 2506
o67.nodeType = 1;
// 2507
o67.nodeName = "IMG";
// 2510
o67.getAttribute = f911113496_527;
// 2512
f911113496_527.returns.push(null);
// 2513
o68 = {};
// 2514
o67.childNodes = o68;
// 2515
o68["0"] = void 0;
// undefined
o68 = null;
// 2517
o68 = {};
// 2518
o41["2"] = o68;
// 2519
o68.nodeType = 3;
// undefined
o68 = null;
// 2521
o68 = {};
// 2522
o41["3"] = o68;
// 2523
o68.nodeType = 1;
// 2524
o68.nodeName = "SPAN";
// 2525
o69 = {};
// 2526
o68.childNodes = o69;
// undefined
o68 = null;
// 2527
o68 = {};
// 2528
o69["0"] = o68;
// 2529
o68.nodeType = 1;
// 2530
o68.nodeName = "I";
// 2531
o70 = {};
// 2532
o68.childNodes = o70;
// undefined
o68 = null;
// 2533
o70["0"] = void 0;
// undefined
o70 = null;
// 2535
o69["1"] = void 0;
// undefined
o69 = null;
// 2537
o68 = {};
// 2538
o41["4"] = o68;
// 2539
o68.nodeType = 3;
// undefined
o68 = null;
// 2541
o41["5"] = void 0;
// undefined
o41 = null;
// 2544
o52.getAttribute = f911113496_527;
// 2546
f911113496_527.returns.push("/video/whitey-bulger-ex-partner-trade-171312946.html");
// 2551
f911113496_527.returns.push(null);
// 2556
f911113496_527.returns.push("itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:WhiteyBu;cpos:6;test:;g:8c9b8433-216b-3de6-902e-875865d62d79;");
// 2557
o53.setAttribute = f911113496_513;
// 2558
f911113496_513.returns.push(undefined);
// 2559
o53.nodeName = "A";
// 2560
o53.textContent = "Whitey Bulger, ex-partner trade curses in courtroo …";
// 2563
o53.getAttribute = f911113496_527;
// 2565
f911113496_527.returns.push(null);
// 2570
f911113496_527.returns.push("itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:WhiteyBu;cpos:6;test:;g:8c9b8433-216b-3de6-902e-875865d62d79;");
// 2571
o54.setAttribute = f911113496_513;
// 2572
f911113496_513.returns.push(undefined);
// 2573
o54.nodeName = "A";
// 2574
o54.textContent = "   ";
// 2575
o41 = {};
// 2576
o54.childNodes = o41;
// 2577
o68 = {};
// 2578
o41["0"] = o68;
// 2579
o68.nodeType = 3;
// undefined
o68 = null;
// 2581
o68 = {};
// 2582
o41["1"] = o68;
// 2583
o68.nodeType = 1;
// 2584
o68.nodeName = "IMG";
// 2587
o68.getAttribute = f911113496_527;
// 2589
f911113496_527.returns.push(null);
// 2590
o69 = {};
// 2591
o68.childNodes = o69;
// 2592
o69["0"] = void 0;
// undefined
o69 = null;
// 2594
o69 = {};
// 2595
o41["2"] = o69;
// 2596
o69.nodeType = 3;
// undefined
o69 = null;
// 2598
o69 = {};
// 2599
o41["3"] = o69;
// 2600
o69.nodeType = 1;
// 2601
o69.nodeName = "SPAN";
// 2602
o70 = {};
// 2603
o69.childNodes = o70;
// undefined
o69 = null;
// 2604
o69 = {};
// 2605
o70["0"] = o69;
// 2606
o69.nodeType = 1;
// 2607
o69.nodeName = "I";
// 2608
o71 = {};
// 2609
o69.childNodes = o71;
// undefined
o69 = null;
// 2610
o71["0"] = void 0;
// undefined
o71 = null;
// 2612
o70["1"] = void 0;
// undefined
o70 = null;
// 2614
o69 = {};
// 2615
o41["4"] = o69;
// 2616
o69.nodeType = 3;
// undefined
o69 = null;
// 2618
o41["5"] = void 0;
// undefined
o41 = null;
// 2621
o54.getAttribute = f911113496_527;
// 2623
f911113496_527.returns.push("/video/taste-chicago-2013-opens-165744456.html");
// 2628
f911113496_527.returns.push(null);
// 2633
f911113496_527.returns.push("itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:TasteofC;cpos:7;test:;g:523fedde-cc12-38fb-86ca-60629888845c;");
// 2634
o55.setAttribute = f911113496_513;
// 2635
f911113496_513.returns.push(undefined);
// 2636
o55.nodeName = "A";
// 2637
o55.textContent = "Taste of Chicago 2013 opens";
// 2640
o55.getAttribute = f911113496_527;
// 2642
f911113496_527.returns.push(null);
// 2647
f911113496_527.returns.push("itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:TasteofC;cpos:7;test:;g:523fedde-cc12-38fb-86ca-60629888845c;");
// 2648
o56.setAttribute = f911113496_513;
// 2649
f911113496_513.returns.push(undefined);
// 2650
o56.nodeName = "A";
// 2651
o56.textContent = "   ";
// 2652
o41 = {};
// 2653
o56.childNodes = o41;
// 2654
o69 = {};
// 2655
o41["0"] = o69;
// 2656
o69.nodeType = 3;
// undefined
o69 = null;
// 2658
o69 = {};
// 2659
o41["1"] = o69;
// 2660
o69.nodeType = 1;
// 2661
o69.nodeName = "IMG";
// 2664
o69.getAttribute = f911113496_527;
// 2666
f911113496_527.returns.push(null);
// 2667
o70 = {};
// 2668
o69.childNodes = o70;
// 2669
o70["0"] = void 0;
// undefined
o70 = null;
// 2671
o70 = {};
// 2672
o41["2"] = o70;
// 2673
o70.nodeType = 3;
// undefined
o70 = null;
// 2675
o70 = {};
// 2676
o41["3"] = o70;
// 2677
o70.nodeType = 1;
// 2678
o70.nodeName = "SPAN";
// 2679
o71 = {};
// 2680
o70.childNodes = o71;
// undefined
o70 = null;
// 2681
o70 = {};
// 2682
o71["0"] = o70;
// 2683
o70.nodeType = 1;
// 2684
o70.nodeName = "I";
// 2685
o72 = {};
// 2686
o70.childNodes = o72;
// undefined
o70 = null;
// 2687
o72["0"] = void 0;
// undefined
o72 = null;
// 2689
o71["1"] = void 0;
// undefined
o71 = null;
// 2691
o70 = {};
// 2692
o41["4"] = o70;
// 2693
o70.nodeType = 3;
// undefined
o70 = null;
// 2695
o41["5"] = void 0;
// undefined
o41 = null;
// 2698
o56.getAttribute = f911113496_527;
// 2700
f911113496_527.returns.push("/video/officials-defend-paulsboro-train-derailment-163843236.html");
// 2705
f911113496_527.returns.push(null);
// 2710
f911113496_527.returns.push("itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:Official;cpos:8;test:;g:51aceae4-c48c-3955-bc3d-deabf73b0d4c;");
// 2711
o57.setAttribute = f911113496_513;
// 2712
f911113496_513.returns.push(undefined);
// 2713
o57.nodeName = "A";
// 2714
o57.textContent = "Officials defend Paulsboro train derailment respon …";
// 2717
o57.getAttribute = f911113496_527;
// 2719
f911113496_527.returns.push(null);
// 2724
f911113496_527.returns.push("itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:Official;cpos:8;test:;g:51aceae4-c48c-3955-bc3d-deabf73b0d4c;");
// 2725
o58.setAttribute = f911113496_513;
// 2726
f911113496_513.returns.push(undefined);
// 2727
o58.nodeName = "A";
// 2728
o58.textContent = "   ";
// 2729
o41 = {};
// 2730
o58.childNodes = o41;
// 2731
o70 = {};
// 2732
o41["0"] = o70;
// 2733
o70.nodeType = 3;
// undefined
o70 = null;
// 2735
o70 = {};
// 2736
o41["1"] = o70;
// 2737
o70.nodeType = 1;
// 2738
o70.nodeName = "IMG";
// 2741
o70.getAttribute = f911113496_527;
// 2743
f911113496_527.returns.push(null);
// 2744
o71 = {};
// 2745
o70.childNodes = o71;
// 2746
o71["0"] = void 0;
// undefined
o71 = null;
// 2748
o71 = {};
// 2749
o41["2"] = o71;
// 2750
o71.nodeType = 3;
// undefined
o71 = null;
// 2752
o71 = {};
// 2753
o41["3"] = o71;
// 2754
o71.nodeType = 1;
// 2755
o71.nodeName = "SPAN";
// 2756
o72 = {};
// 2757
o71.childNodes = o72;
// undefined
o71 = null;
// 2758
o71 = {};
// 2759
o72["0"] = o71;
// 2760
o71.nodeType = 1;
// 2761
o71.nodeName = "I";
// 2762
o73 = {};
// 2763
o71.childNodes = o73;
// undefined
o71 = null;
// 2764
o73["0"] = void 0;
// undefined
o73 = null;
// 2766
o72["1"] = void 0;
// undefined
o72 = null;
// 2768
o71 = {};
// 2769
o41["4"] = o71;
// 2770
o71.nodeType = 3;
// undefined
o71 = null;
// 2772
o41["5"] = void 0;
// undefined
o41 = null;
// 2775
o58.getAttribute = f911113496_527;
// 2777
f911113496_527.returns.push("/video/humboldt-park-sex-assault-near-112404068.html");
// 2782
f911113496_527.returns.push(null);
// 2787
f911113496_527.returns.push("itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:Policese;cpos:9;test:;g:77d99ad3-23b2-31a4-9d15-beda9147cf9e;");
// 2788
o59.setAttribute = f911113496_513;
// 2789
f911113496_513.returns.push(undefined);
// 2790
o59.nodeName = "A";
// 2791
o59.textContent = "Police searching for bus stop attacker in Humboldt …";
// 2794
o59.getAttribute = f911113496_527;
// 2796
f911113496_527.returns.push(null);
// 2801
f911113496_527.returns.push("itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:Policese;cpos:9;test:;g:77d99ad3-23b2-31a4-9d15-beda9147cf9e;");
// 2802
o60.setAttribute = f911113496_513;
// 2803
f911113496_513.returns.push(undefined);
// 2804
o60.nodeName = "A";
// 2805
o60.textContent = "   ";
// 2806
o41 = {};
// 2807
o60.childNodes = o41;
// 2808
o71 = {};
// 2809
o41["0"] = o71;
// 2810
o71.nodeType = 3;
// undefined
o71 = null;
// 2812
o71 = {};
// 2813
o41["1"] = o71;
// 2814
o71.nodeType = 1;
// 2815
o71.nodeName = "IMG";
// 2818
o71.getAttribute = f911113496_527;
// 2820
f911113496_527.returns.push(null);
// 2821
o72 = {};
// 2822
o71.childNodes = o72;
// 2823
o72["0"] = void 0;
// undefined
o72 = null;
// 2825
o72 = {};
// 2826
o41["2"] = o72;
// 2827
o72.nodeType = 3;
// undefined
o72 = null;
// 2829
o72 = {};
// 2830
o41["3"] = o72;
// 2831
o72.nodeType = 1;
// 2832
o72.nodeName = "SPAN";
// 2833
o73 = {};
// 2834
o72.childNodes = o73;
// undefined
o72 = null;
// 2835
o72 = {};
// 2836
o73["0"] = o72;
// 2837
o72.nodeType = 1;
// 2838
o72.nodeName = "I";
// 2839
o74 = {};
// 2840
o72.childNodes = o74;
// undefined
o72 = null;
// 2841
o74["0"] = void 0;
// undefined
o74 = null;
// 2843
o73["1"] = void 0;
// undefined
o73 = null;
// 2845
o72 = {};
// 2846
o41["4"] = o72;
// 2847
o72.nodeType = 3;
// undefined
o72 = null;
// 2849
o41["5"] = void 0;
// undefined
o41 = null;
// 2852
o60.getAttribute = f911113496_527;
// 2854
f911113496_527.returns.push("/video/teen-being-questioned-mothers-murder-112642183.html");
// 2859
f911113496_527.returns.push(null);
// 2864
f911113496_527.returns.push("itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:Teenchar;cpos:10;test:;g:442d0366-9815-3b70-aad9-fdc81b8f7177;");
// 2865
o61.setAttribute = f911113496_513;
// 2866
f911113496_513.returns.push(undefined);
// 2867
o61.nodeName = "A";
// 2868
o61.textContent = "Teen charged in mother's murder";
// 2871
o61.getAttribute = f911113496_527;
// 2873
f911113496_527.returns.push(null);
// 2878
f911113496_527.returns.push("itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:Teenchar;cpos:10;test:;g:442d0366-9815-3b70-aad9-fdc81b8f7177;");
// 2879
o33.JSBNG__addEventListener = f911113496_547;
// undefined
o33 = null;
// 2881
f911113496_547.returns.push(undefined);
// 2883
o33 = {};
// 2884
f911113496_475.returns.push(o33);
// 2887
o33.getAttribute = f911113496_527;
// 2889
f911113496_527.returns.push(null);
// 2894
f911113496_527.returns.push(null);
// 2895
o33.getElementsByTagName = f911113496_528;
// 2896
o41 = {};
// 2897
f911113496_528.returns.push(o41);
// 2898
o41.length = 6;
// 2899
o72 = {};
// 2900
o41["0"] = o72;
// 2901
o73 = {};
// 2902
o41["1"] = o73;
// 2903
o74 = {};
// 2904
o41["2"] = o74;
// 2905
o75 = {};
// 2906
o41["3"] = o75;
// 2907
o76 = {};
// 2908
o41["4"] = o76;
// 2909
o77 = {};
// 2910
o41["5"] = o77;
// undefined
o41 = null;
// 2912
o41 = {};
// 2913
f911113496_528.returns.push(o41);
// 2914
o41.length = 0;
// undefined
o41 = null;
// 2916
o41 = {};
// 2917
f911113496_528.returns.push(o41);
// 2918
o41.length = 0;
// undefined
o41 = null;
// 2919
o72.sourceIndex = void 0;
// 2920
o72.compareDocumentPosition = f911113496_546;
// 2922
f911113496_546.returns.push(4);
// 2923
o74.compareDocumentPosition = f911113496_546;
// 2924
f911113496_546.returns.push(4);
// 2925
o76.compareDocumentPosition = f911113496_546;
// 2926
f911113496_546.returns.push(4);
// 2928
f911113496_546.returns.push(4);
// 2929
o73.compareDocumentPosition = f911113496_546;
// 2930
f911113496_546.returns.push(4);
// 2932
f911113496_546.returns.push(4);
// 2934
f911113496_546.returns.push(4);
// 2936
f911113496_546.returns.push(4);
// 2937
o75.compareDocumentPosition = f911113496_546;
// 2938
f911113496_546.returns.push(4);
// 2943
f911113496_527.returns.push("yom-mod yom-footer-info");
// 2948
f911113496_527.returns.push("yom-mod yom-footer-info");
// 2953
f911113496_527.returns.push("yom-mod yom-footer-info");
// 2958
f911113496_527.returns.push("yom-mod yom-footer-info");
// 2963
f911113496_527.returns.push(null);
// 2964
o72.setAttribute = f911113496_513;
// 2965
f911113496_513.returns.push(undefined);
// 2966
o72.nodeName = "A";
// 2967
o72.textContent = "Help";
// 2970
o72.getAttribute = f911113496_527;
// 2972
f911113496_527.returns.push(null);
// 2977
f911113496_527.returns.push(null);
// 2978
o73.setAttribute = f911113496_513;
// 2979
f911113496_513.returns.push(undefined);
// 2980
o73.nodeName = "A";
// 2981
o73.textContent = "Suggestions";
// 2984
o73.getAttribute = f911113496_527;
// 2986
f911113496_527.returns.push(null);
// 2991
f911113496_527.returns.push(null);
// 2992
o74.setAttribute = f911113496_513;
// 2993
f911113496_513.returns.push(undefined);
// 2994
o74.nodeName = "A";
// 2995
o74.textContent = "Privacy Policy";
// 2998
o74.getAttribute = f911113496_527;
// 3000
f911113496_527.returns.push(null);
// 3005
f911113496_527.returns.push(null);
// 3006
o75.setAttribute = f911113496_513;
// 3007
f911113496_513.returns.push(undefined);
// 3008
o75.nodeName = "A";
// 3009
o75.textContent = "About Our Ads";
// 3012
o75.getAttribute = f911113496_527;
// 3014
f911113496_527.returns.push(null);
// 3019
f911113496_527.returns.push(null);
// 3020
o76.setAttribute = f911113496_513;
// 3021
f911113496_513.returns.push(undefined);
// 3022
o76.nodeName = "A";
// 3023
o76.textContent = "Terms of Service";
// 3026
o76.getAttribute = f911113496_527;
// 3028
f911113496_527.returns.push(null);
// 3033
f911113496_527.returns.push(null);
// 3034
o77.setAttribute = f911113496_513;
// 3035
f911113496_513.returns.push(undefined);
// 3036
o77.nodeName = "A";
// 3037
o77.textContent = "Copyright/IP Policy";
// 3040
o77.getAttribute = f911113496_527;
// 3042
f911113496_527.returns.push(null);
// 3047
f911113496_527.returns.push(null);
// 3048
o33.JSBNG__addEventListener = f911113496_547;
// undefined
o33 = null;
// 3050
f911113496_547.returns.push(undefined);
// 3051
f911113496_14.returns.push(undefined);
// 3052
o33 = {};
// 3053
f911113496_0.returns.push(o33);
// undefined
o33 = null;
// 3054
f911113496_12.returns.push(1);
// undefined
fo911113496_1_cookie.returns.push("B=br5diod8trahs&b=3&s=iu; ywadp10001393120079=1580760108");
// 3056
f911113496_470.returns.push(0.28436125139705837);
// 3057
f911113496_470.returns.push(0.5957471495494246);
// 3058
f911113496_470.returns.push(0.5139660534914583);
// 3059
f911113496_470.returns.push(0.011120016453787684);
// 3060
f911113496_470.returns.push(0.7088405443355441);
// 3061
f911113496_470.returns.push(0.9863577336072922);
// 3062
f911113496_470.returns.push(0.6215029733721167);
// 3063
f911113496_470.returns.push(0.5735060356091708);
// 3064
f911113496_470.returns.push(0.5010241868440062);
// 3065
f911113496_470.returns.push(0.49257025797851384);
// 3066
f911113496_470.returns.push(0.39341611810959876);
// 3067
f911113496_470.returns.push(0.6177286738529801);
// 3068
o0.title = "Yahoo! News - Latest News & Headlines";
// 3069
o33 = {};
// 3070
f911113496_0.returns.push(o33);
// undefined
o33 = null;
// 3072
o2.width = 1280;
// 3073
o2.height = 800;
// 3074
o2.colorDepth = 24;
// undefined
o2 = null;
// 3075
o2 = {};
// 3076
f911113496_0.returns.push(o2);
// 3077
f911113496_711 = function() { return f911113496_711.returns[f911113496_711.inst++]; };
f911113496_711.returns = [];
f911113496_711.inst = 0;
// 3079
f911113496_711.returns.push(1373481542443);
// 3081
o33 = {};
// 3082
f911113496_481.returns.push(o33);
// 3083
o33.length = 1;
// 3085
o41 = {};
// 3086
f911113496_476.returns.push(o41);
// 3087
o41.setAttribute = f911113496_513;
// 3088
f911113496_513.returns.push(undefined);
// 3090
f911113496_513.returns.push(undefined);
// 3092
f911113496_513.returns.push(undefined);
// 3094
f911113496_513.returns.push(undefined);
// 3095
o41.JSBNG__addEventListener = f911113496_547;
// 3096
f911113496_547.returns.push(undefined);
// 3097
o33["0"] = o8;
// undefined
o33 = null;
// 3099
f911113496_508.returns.push(o41);
// 3101
o33 = {};
// 3102
f911113496_0.returns.push(o33);
// 3104
f911113496_711.returns.push(1373481542569);
// 3105
o78 = {};
// 3106
f911113496_86.returns.push(o78);
// 3107
// 3108
// 3109
o79 = {};
// 3110
f911113496_0.returns.push(o79);
// undefined
o79 = null;
// 3111
f911113496_717 = function() { return f911113496_717.returns[f911113496_717.inst++]; };
f911113496_717.returns = [];
f911113496_717.inst = 0;
// 3112
o78.JSBNG__postMessage = f911113496_717;
// 3113
f911113496_717.returns.push(undefined);
// 3114
f911113496_12.returns.push(2);
// 3116
o79 = {};
// undefined
o79 = null;
// 3117
// 3123
f911113496_719 = function() { return f911113496_719.returns[f911113496_719.inst++]; };
f911113496_719.returns = [];
f911113496_719.inst = 0;
// 3124
o0.createEvent = f911113496_719;
// 3125
f911113496_720 = function() { return f911113496_720.returns[f911113496_720.inst++]; };
f911113496_720.returns = [];
f911113496_720.inst = 0;
// 3127
f911113496_721 = function() { return f911113496_721.returns[f911113496_721.inst++]; };
f911113496_721.returns = [];
f911113496_721.inst = 0;
// 3128
f911113496_720.returns.push(f911113496_721);
// 3129
o79 = {};
// 3130
f911113496_0.returns.push(o79);
// undefined
o79 = null;
// 3131
o79 = {};
// 3132
f911113496_0.returns.push(o79);
// undefined
o79 = null;
// 3135
f911113496_724 = function() { return f911113496_724.returns[f911113496_724.inst++]; };
f911113496_724.returns = [];
f911113496_724.inst = 0;
// 3136
f911113496_720.returns.push(f911113496_724);
// 3137
o79 = {};
// 3138
f911113496_0.returns.push(o79);
// undefined
o79 = null;
// 3139
o79 = {};
// 3140
f911113496_0.returns.push(o79);
// undefined
o79 = null;
// 3141
o0.JSBNG__addEventListener = f911113496_547;
// 3143
f911113496_727 = function() { return f911113496_727.returns[f911113496_727.inst++]; };
f911113496_727.returns = [];
f911113496_727.inst = 0;
// 3144
f911113496_720.returns.push(f911113496_727);
// 3145
o79 = {};
// 3146
f911113496_0.returns.push(o79);
// undefined
o79 = null;
// 3147
f911113496_547.returns.push(undefined);
// 3148
o79 = {};
// 3149
f911113496_0.returns.push(o79);
// undefined
o79 = null;
// 3151
f911113496_730 = function() { return f911113496_730.returns[f911113496_730.inst++]; };
f911113496_730.returns = [];
f911113496_730.inst = 0;
// 3152
f911113496_720.returns.push(f911113496_730);
// 3153
o79 = {};
// 3154
f911113496_0.returns.push(o79);
// undefined
o79 = null;
// 3155
f911113496_7.returns.push(undefined);
// 3156
o79 = {};
// 3157
f911113496_0.returns.push(o79);
// undefined
o79 = null;
// undefined
fo911113496_1_body.returns.push(o15);
// 3159
o79 = {};
// 3160
f911113496_0.returns.push(o79);
// 3161
o79.getTime = f911113496_472;
// undefined
o79 = null;
// 3162
f911113496_472.returns.push(1373481542744);
// 3165
o79 = {};
// 3166
f911113496_475.returns.push(o79);
// 3167
o79.innerHTML = "<center><div id=\"yom-ad-SDARLA-iframe\" class=\"yom-ad\"><center><script type=\"text/javascript\" src=\"http://l.yimg.com/rq/darla/2-6-3/js/g-r-min.js\"></script><script type=\"text/plain\" id=\"fc\" _ver=\"2-6-3\">{ \"positions\": [ { \"html\": \"<!--Vendor: Doubleclick, Format: EXPANDABLE, IO: 123456-->\\n<SCR\"+\"IPT language='JavaScript1.1' SRC=\\\"http://ad.doubleclick.net/adj/N5823.Yahoo/B7708110.17;sz=300x250;dcopt=rcl;mtfIFPath=nofile;click=http://clicks.beap.bc.yahoo.com/yc/YnY9MS4wLjAmYnM9KDE1dWZxbm83MChnaWQkclBVUHFRckhnai45bGJMRFVkMnFQQURiWXRjS1QxSGRxandBQ1AuTCxzdCQxMzczNDgxNTMyNjEwMTQ4LHNpJDQ0NjQwNTEsc3AkODExMjE0NTIsY3IkMzYwMjUwNDU1MSx2JDIuMCxhaWQkeW1RVFoyS0w0TkUtLGN0JDI1LHlieCRXcVU2LmgyaVZzbm1SMGpjUTVIQm9nLGJpJDE4NDgwMTQ1NTEsciQwLHJkJDE2aXRza2M2aSkp/0/*http://global.ard.yahoo.com/SIG=15jdskivn/M=999999.999999.999999.999999/D=yahoo/S=81121452:LREC/Y=YAHOO/EXP=1373488732/L=rPUPqQrHgj.9lbLDUd2qPADbYtcKT1HdqjwACP.L/B=ymQTZ2KL4NE-/J=1373481532645679/K=kH8ldoKcvhSl3WdU9IHexw/A=7769920327943012471/R=0/X=6/*;ord=1373481532.645679?\\\"></SCR\"+\"IPT><NOSCR\"+\"IPT><A HREF=\\\"http://clicks.beap.bc.yahoo.com/yc/YnY9MS4wLjAmYnM9KDE1dW9jZTFsYyhnaWQkclBVUHFRckhnai45bGJMRFVkMnFQQURiWXRjS1QxSGRxandBQ1AuTCxzdCQxMzczNDgxNTMyNjEwMTQ4LHNpJDQ0NjQwNTEsc3AkODExMjE0NTIsY3IkMzYwMjUwNDU1MSx2JDIuMCxhaWQkeW1RVFoyS0w0TkUtLGN0JDI1LHlieCRXcVU2LmgyaVZzbm1SMGpjUTVIQm9nLGJpJDE4NDgwMTQ1NTEsciQxLHJkJDE2aXZocTdnOCkp/0/*http://global.ard.yahoo.com/SIG=15jdskivn/M=999999.999999.999999.999999/D=yahoo/S=81121452:LREC/Y=YAHOO/EXP=1373488732/L=rPUPqQrHgj.9lbLDUd2qPADbYtcKT1HdqjwACP.L/B=ymQTZ2KL4NE-/J=1373481532645679/K=kH8ldoKcvhSl3WdU9IHexw/A=7769920327943012471/R=1/X=6/*http://ad.doubleclick.net/jump/N5823.Yahoo/B7708110.17;sz=300x250;dcopt=rcl;mtfIFPath=nofile;click=http://clicks.beap.bc.yahoo.com/yc/YnY9MS4wLjAmYnM9KDE1dTMyZDE5MihnaWQkclBVUHFRckhnai45bGJMRFVkMnFQQURiWXRjS1QxSGRxandBQ1AuTCxzdCQxMzczNDgxNTMyNjEwMTQ4LHNpJDQ0NjQwNTEsc3AkODExMjE0NTIsY3IkMzYwMjUwNDU1MSx2JDIuMCxhaWQkeW1RVFoyS0w0TkUtLGN0JDI1LHlieCRXcVU2LmgyaVZzbm1SMGpjUTVIQm9nLGJpJDE4NDgwMTQ1NTEsciQyLHJkJDE2aXJkMGlzNCkp/0/*http://global.ard.yahoo.com/SIG=15jdskivn/M=999999.999999.999999.999999/D=yahoo/S=81121452:LREC/Y=YAHOO/EXP=1373488732/L=rPUPqQrHgj.9lbLDUd2qPADbYtcKT1HdqjwACP.L/B=ymQTZ2KL4NE-/J=1373481532645679/K=kH8ldoKcvhSl3WdU9IHexw/A=7769920327943012471/R=2/X=6/*;ord=1373481532.645679?\\\"><IMG SRC=\\\"http://ad.doubleclick.net/ad/N5823.Yahoo/B7708110.17;sz=300x250;dcopt=rcl;mtfIFPath=nofile;click=http://clicks.beap.bc.yahoo.com/yc/YnY9MS4wLjAmYnM9KDE1dWlvM2Q5NihnaWQkclBVUHFRckhnai45bGJMRFVkMnFQQURiWXRjS1QxSGRxandBQ1AuTCxzdCQxMzczNDgxNTMyNjEwMTQ4LHNpJDQ0NjQwNTEsc3AkODExMjE0NTIsY3IkMzYwMjUwNDU1MSx2JDIuMCxhaWQkeW1RVFoyS0w0TkUtLGN0JDI1LHlieCRXcVU2LmgyaVZzbm1SMGpjUTVIQm9nLGJpJDE4NDgwMTQ1NTEsciQzLHJkJDE2aWZpNzJkcCkp/0/*http://global.ard.yahoo.com/SIG=15jdskivn/M=999999.999999.999999.999999/D=yahoo/S=81121452:LREC/Y=YAHOO/EXP=1373488732/L=rPUPqQrHgj.9lbLDUd2qPADbYtcKT1HdqjwACP.L/B=ymQTZ2KL4NE-/J=1373481532645679/K=kH8ldoKcvhSl3WdU9IHexw/A=7769920327943012471/R=3/X=6/*;ord=1373481532.645679?\\\" BORDER=0 WIDTH=300 HEIGHT=250 ALT=\\\"Advertisement\\\"></A></NOSCR\"+\"IPT>\\n\\n<!--Vendor: TRUSTe, Format: Floating, IO: 123456-->\\n<span id=\\\"te-clearads-js-[cachebuster]\\\">\\n<SCR\"+\"IPT type=\\\"text/javascr\"+\"ipt\\\" src=\\\"http://choices.truste.com/ca?pid=hp01&aid=hp02&cid=98875939&c=[cachebuster]&w=300&h=250&plc=tl&js=10\\\"></scr\"+\"ipt></span>\\n\\n<!--Vendor: AdSafe, Format: Pixel, IO: 123456-->\\n<IMG SRC=\\\"http://pixel.adsafeprotected.com/rfw/st/18662/1154987/skeleton.gif?&_u=1373481532.645679\\\" BORDER=0 WIDTH=1 HEIGHT=1 ALT=\\\"\\\"><!--QYZ 1848014551,3602504551,98.139.229.180;;LREC;81121452;1;-->\", \"id\": \"LREC\", \"meta\": { \"y\": { \"cscHTML\": \"<scr\"+\"ipt language=javascr\"+\"ipt>\\nif(window.xzq_d==null)window.xzq_d=new Object();\\nwindow.xzq_d['ymQTZ2KL4NE-']='(as$12re24ipd,aid$ymQTZ2KL4NE-,bi$1848014551,cr$3602504551,ct$25,at$H,eob$-1)';\\n</scr\"+\"ipt><noscr\"+\"ipt><img width=1 height=1 alt=\\\"\\\" src=\\\"http://csc.beap.bc.yahoo.com/yi?bv=1.0.0&bs=(134dc4tfh(gid$rPUPqQrHgj.9lbLDUd2qPADbYtcKT1HdqjwACP.L,st$1373481532610148,si$4464051,sp$81121452,pv$0,v$2.0))&t=J_3-D_3&al=(as$12re24ipd,aid$ymQTZ2KL4NE-,bi$1848014551,cr$3602504551,ct$25,at$H,eob$-1)\\\"></noscr\"+\"ipt>\", \"cscURI\": \"http://csc.beap.bc.yahoo.com/yi?bv=1.0.0&bs=(134dc4tfh(gid$rPUPqQrHgj.9lbLDUd2qPADbYtcKT1HdqjwACP.L,st$1373481532610148,si$4464051,sp$81121452,pv$0,v$2.0))&t=J_3-D_3&al=(as$12re24ipd,aid$ymQTZ2KL4NE-,bi$1848014551,cr$3602504551,ct$25,at$H,eob$-1)\", \"creativeID\": \"3602504551\", \"behavior\": \"ajax_exp\", \"adID\": \"7769920327943012471\", \"matchID\": \"999999.999999.999999.999999\", \"err\": \"\", \"hasExternal\": 0, \"size\": \"300x250\", \"bookID\": \"1848014551\", \"serveType\": \"-1\", \"slotID\": \"0\" } } },{ \"html\": \"<!-- SpaceID=81121452 loc=MAST noad --><!-- fac-gd2-noad --><!-- gd2-status-2 --><!--QYZ CMS_NONE_AVAIL,,98.139.229.180;;MAST;81121452;2;-->\", \"id\": \"MAST\", \"meta\": { \"y\": { \"cscHTML\": \"<scr\"+\"ipt language=javascr\"+\"ipt>\\nif(window.xzq_d==null)window.xzq_d=new Object();\\nwindow.xzq_d['magTZ2KL4NE-']='(as$125c9ssij,aid$magTZ2KL4NE-,cr$-1,ct$25,at$H,eob$-1)';\\n</scr\"+\"ipt><noscr\"+\"ipt><img width=1 height=1 alt=\\\"\\\" src=\\\"http://csc.beap.bc.yahoo.com/yi?bv=1.0.0&bs=(134dc4tfh(gid$rPUPqQrHgj.9lbLDUd2qPADbYtcKT1HdqjwACP.L,st$1373481532610148,si$4464051,sp$81121452,pv$0,v$2.0))&t=J_3-D_3&al=(as$125c9ssij,aid$magTZ2KL4NE-,cr$-1,ct$25,at$H,eob$-1)\\\"></noscr\"+\"ipt>\", \"cscURI\": \"http://csc.beap.bc.yahoo.com/yi?bv=1.0.0&bs=(134dc4tfh(gid$rPUPqQrHgj.9lbLDUd2qPADbYtcKT1HdqjwACP.L,st$1373481532610148,si$4464051,sp$81121452,pv$0,v$2.0))&t=J_3-D_3&al=(as$125c9ssij,aid$magTZ2KL4NE-,cr$-1,ct$25,at$H,eob$-1)\", \"creativeID\": \"-1\", \"behavior\": \"non_exp\", \"adID\": \"#2\", \"matchID\": \"#2\", \"err\": \"invalid_space\", \"hasExternal\": 0, \"size\": \"\", \"bookID\": \"CMS_NONE_AVAIL\", \"serveType\": \"-1\", \"slotID\": \"1\" } } },{ \"html\": \"<!--Vendor: Right Media, Format: IFrame --><div ALLOWTRANSPARENCY=TRUE FRAMEBORDER=0 MARGINWIDTH=0 MARGINHEIGHT=0 SCROLLING=NO WIDTH=300 HEIGHT=250 SRC=\\\"http://ad.yieldmanager.com/st?ad_type=div&publisher_blob=${RS}|rPUPqQrHgj.9lbLDUd2qPADbYtcKT1HdqjwACP.L|81121452|LREC2|1373481532.646478&cnt=yan&ad_size=300x250&site=140477&section_code=2288163051&cb=1373481532.646478&yud=smpv%3d3%26ed%3dzAomdE.7n1vQ06Bzq5du4W6H0h1AhZ0BrKw-&pub_redirect_unencoded=1&pub_redirect=http://clicks.beap.bc.yahoo.com/yc/YnY9MS4wLjAmYnM9KDE1dWVuNGhscyhnaWQkclBVUHFRckhnai45bGJMRFVkMnFQQURiWXRjS1QxSGRxandBQ1AuTCxzdCQxMzczNDgxNTMyNjEwMTQ4LHNpJDQ0NjQwNTEsc3AkODExMjE0NTIsY3IkMzA4NTQ4MDU1MSx2JDIuMCxhaWQkYU93VFoyS0w0TkUtLGN0JDI1LHlieCRXcVU2LmgyaVZzbm1SMGpjUTVIQm9nLGJpJDE1ODUwOTMwNTEsciQwLHJkJDE2aXU2cGJwMCkp/0/*http://global.ard.yahoo.com/SIG=15kvg4h3o/M=999999.999999.999999.999999/D=yahoo/S=81121452:LREC2/Y=YAHOO/EXP=1373488732/L=rPUPqQrHgj.9lbLDUd2qPADbYtcKT1HdqjwACP.L/B=aOwTZ2KL4NE-/J=1373481532646478/K=kH8ldoKcvhSl3WdU9IHexw/A=6647776369999917826/R=0/X=6/*\\\"></div><!--QYZ 1585093051,3085480551,98.139.229.180;;LREC2;81121452;1;-->\", \"id\": \"LREC2\", \"meta\": { \"y\": { \"cscHTML\": \"<scr\"+\"ipt language=javascr\"+\"ipt>\\nif(window.xzq_d==null)window.xzq_d=new Object();\\nwindow.xzq_d['aOwTZ2KL4NE-']='(as$12r31pu2o,aid$aOwTZ2KL4NE-,bi$1585093051,cr$3085480551,ct$25,at$H,eob$-1)';\\n</scr\"+\"ipt><noscr\"+\"ipt><img width=1 height=1 alt=\\\"\\\" src=\\\"http://csc.beap.bc.yahoo.com/yi?bv=1.0.0&bs=(134dc4tfh(gid$rPUPqQrHgj.9lbLDUd2qPADbYtcKT1HdqjwACP.L,st$1373481532610148,si$4464051,sp$81121452,pv$0,v$2.0))&t=J_3-D_3&al=(as$12r31pu2o,aid$aOwTZ2KL4NE-,bi$1585093051,cr$3085480551,ct$25,at$H,eob$-1)\\\"></noscr\"+\"ipt>\", \"cscURI\": \"http://csc.beap.bc.yahoo.com/yi?bv=1.0.0&bs=(134dc4tfh(gid$rPUPqQrHgj.9lbLDUd2qPADbYtcKT1HdqjwACP.L,st$1373481532610148,si$4464051,sp$81121452,pv$0,v$2.0))&t=J_3-D_3&al=(as$12r31pu2o,aid$aOwTZ2KL4NE-,bi$1585093051,cr$3085480551,ct$25,at$H,eob$-1)\", \"creativeID\": \"3085480551\", \"behavior\": \"non_exp\", \"adID\": \"6647776369999917826\", \"matchID\": \"999999.999999.999999.999999\", \"err\": \"\", \"hasExternal\": 0, \"size\": \"300x250\", \"bookID\": \"1585093051\", \"serveType\": \"-1\", \"slotID\": \"2\" } } } ], \"meta\": { \"y\": { \"pageEndHTML\": \"<scr\"+\"ipt language=javascr\"+\"ipt>\\n(function(){window.xzq_p=function(R){M=R};window.xzq_svr=function(R){J=R};function F(S){var T=document;if(T.xzq_i==null){T.xzq_i=new Array();T.xzq_i.c=0}var R=T.xzq_i;R[++R.c]=new Image();R[R.c].src=S}window.xzq_sr=function(){var S=window;var Y=S.xzq_d;if(Y==null){return }if(J==null){return }var T=J+M;if(T.length>P){C();return }var X=\\\"\\\";var U=0;var W=Math.random();var V=(Y.hasOwnProperty!=null);var R;for(R in Y){if(typeof Y[R]==\\\"string\\\"){if(V&&!Y.hasOwnProperty(R)){continue}if(T.length+X.length+Y[R].length<=P){X+=Y[R]}else{if(T.length+Y[R].length>P){}else{U++;N(T,X,U,W);X=Y[R]}}}}if(U){U++}N(T,X,U,W);C()};function N(R,U,S,T){if(U.length>0){R+=\\\"&al=\\\"}F(R+U+\\\"&s=\\\"+S+\\\"&r=\\\"+T)}function C(){window.xzq_d=null;M=null;J=null}function K(R){xzq_sr()}function B(R){xzq_sr()}function L(U,V,W){if(W){var R=W.toString();var T=U;var Y=R.match(new RegExp(\\\"\\\\\\\\\\\\\\\\(([^\\\\\\\\\\\\\\\\)]*)\\\\\\\\\\\\\\\\)\\\"));Y=(Y[1].length>0?Y[1]:\\\"e\\\");T=T.replace(new RegExp(\\\"\\\\\\\\\\\\\\\\([^\\\\\\\\\\\\\\\\)]*\\\\\\\\\\\\\\\\)\\\",\\\"g\\\"),\\\"(\\\"+Y+\\\")\\\");if(R.indexOf(T)<0){var X=R.indexOf(\\\"{\\\");if(X>0){R=R.substring(X,R.length)}else{return W}R=R.replace(new RegExp(\\\"([^a-zA-Z0-9$_])this([^a-zA-Z0-9$_])\\\",\\\"g\\\"),\\\"$1xzq_this$2\\\");var Z=T+\\\";var rv = f( \\\"+Y+\\\",this);\\\";var S=\\\"{var a0 = '\\\"+Y+\\\"';var ofb = '\\\"+escape(R)+\\\"' ;var f = new Function( a0, 'xzq_this', unescape(ofb));\\\"+Z+\\\"return rv;}\\\";return new Function(Y,S)}else{return W}}return V}window.xzq_eh=function(){if(E||I){this.onload=L(\\\"xzq_onload(e)\\\",K,this.onload,0);if(E&&typeof (this.onbeforeunload)!=O){this.onbeforeunload=L(\\\"xzq_dobeforeunload(e)\\\",B,this.onbeforeunload,0)}}};window.xzq_s=function(){setTimeout(\\\"xzq_sr()\\\",1)};var J=null;var M=null;var Q=navigator.appName;var H=navigator.appVersion;var G=navigator.userAgent;var A=parseInt(H);var D=Q.indexOf(\\\"Microsoft\\\");var E=D!=-1&&A>=4;var I=(Q.indexOf(\\\"Netscape\\\")!=-1||Q.indexOf(\\\"Opera\\\")!=-1)&&A>=4;var O=\\\"undefined\\\";var P=2000})();\\n</scr\"+\"ipt><scr\"+\"ipt language=javascr\"+\"ipt>\\nif(window.xzq_svr)xzq_svr('http://csc.beap.bc.yahoo.com/');\\nif(window.xzq_p)xzq_p('yi?bv=1.0.0&bs=(134dc4tfh(gid$rPUPqQrHgj.9lbLDUd2qPADbYtcKT1HdqjwACP.L,st$1373481532610148,si$4464051,sp$81121452,pv$0,v$2.0))&t=J_3-D_3');\\nif(window.xzq_s)xzq_s();\\n</scr\"+\"ipt><noscr\"+\"ipt><img width=1 height=1 alt=\\\"\\\" src=\\\"http://csc.beap.bc.yahoo.com/yi?bv=1.0.0&bs=(134dc4tfh(gid$rPUPqQrHgj.9lbLDUd2qPADbYtcKT1HdqjwACP.L,st$1373481532610148,si$4464051,sp$81121452,pv$0,v$2.0))&t=J_3-D_3\\\"></noscr\"+\"ipt>\", \"pos_list\": [ \"LREC\",\"MAST\",\"LREC2\" ], \"spaceID\": \"81121452\", \"host\": \"news.yahoo.com\", \"lookupTime\": \"41\", \"k2_uri\": \"\", \"fac_rt\": \"39632\", \"pvid\": \"rPUPqQrHgj.9lbLDUd2qPADbYtcKT1HdqjwACP.L\", \"tID\": \"darla_prefetch_1373481532608_787402516_1\" } } } </script>\n<script>try {\n    ((JSBNG_Record.scriptLoad)((\"(function() {\\u000a    var wrap = document.getElementById(\\\"yom-ad-SDARLA\\\");\\u000a    if ((null == wrap)) {\\u000a        wrap = (document.getElementById(\\\"yom-ad-SDARLA-iframe\\\") || {\\u000a        });\\u000a    }\\u000a;\\u000a    var content = (wrap.innerHTML || \\\"\\\");\\u000a    if ((content && (content.substr(0, content.lastIndexOf(\\\"\\\\u003Cscript\\\\u003E\\\")).indexOf(\\\"loc=SDARLA noad\\\") !== -1))) {\\u000a        wrap.style.display = \\\"none\\\";\\u000a    }\\u000a;\\u000a}());\"), (\"s82fcb8176770e30faa77ce41eb7ce50f4335ce51\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    (((function() {\n        var s82fcb8176770e30faa77ce41eb7ce50f4335ce51_0_instance;\n        ((s82fcb8176770e30faa77ce41eb7ce50f4335ce51_0_instance) = ((JSBNG_Record.eventInstance)((\"s82fcb8176770e30faa77ce41eb7ce50f4335ce51_0\"))));\n        return ((JSBNG_Record.markFunction)((function() {\n            if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                return ((JSBNG_Record.eventCall)((arguments.callee), (\"s82fcb8176770e30faa77ce41eb7ce50f4335ce51_0\"), (s82fcb8176770e30faa77ce41eb7ce50f4335ce51_0_instance), (this), (arguments)))\n            };\n            (null);\n            var wrap = (((JSBNG_Record.get)(JSBNG__document, (\"getElementById\")))[(\"getElementById\")])(\"yom-ad-SDARLA\");\n            if ((null == wrap)) {\n                wrap = ((((JSBNG_Record.get)(JSBNG__document, (\"getElementById\")))[(\"getElementById\")])(\"yom-ad-SDARLA-iframe\") || {\n                });\n            }\n            ;\n            var JSBNG__content = ((((JSBNG_Record.get)(wrap, (\"innerHTML\")))[(\"innerHTML\")]) || \"\");\n            if ((JSBNG__content && ((((JSBNG_Record.get)((((JSBNG_Record.get)(JSBNG__content, (\"substr\")))[(\"substr\")])(0, (((JSBNG_Record.get)(JSBNG__content, (\"lastIndexOf\")))[(\"lastIndexOf\")])(\"\\u003Cscript\\u003E\")), (\"indexOf\")))[(\"indexOf\")])(\"loc=SDARLA noad\") !== -1))) {\n                ((JSBNG_Record.set)((((JSBNG_Record.get)(wrap, (\"style\")))[(\"style\")]), (\"display\"), \"none\"));\n            }\n            ;\n        })));\n    })())());\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};</script></center></div></center>";
// undefined
o79 = null;
// 3169
f911113496_7.returns.push(undefined);
// 3172
o79 = {};
// 3173
f911113496_475.returns.push(o79);
// 3174
o79.innerHTML = "<center><div id=\"yom-ad-SDARLAEXTRA-iframe\" class=\"yom-ad\"><center>    \n        <script type=\"text/javascript\">try {\n    ((JSBNG_Record.scriptLoad)((\"function loadAdsAfterOnLoad() {\\u000a    YMedia.later(10, this, function() {\\u000a        YMedia.use(\\\"node-base\\\", function(Y) {\\u000a            YUI.AdsDarla = (function() {\\u000a                var nodes = {\\u000a                    \\\"yom-ad-LREC\\\": {\\u000a                        node: \\\"\\\\u003Cdiv id='yom-ad-LREC-iframe' class='yom-ad-iframe' marginwidth='0' marginheight='0'\\\\u000a                                    hspace='0' vspace='0' frameborder='0' scrolling='no' style='display:none;\\\\u000a                                    width:300px;height:266px;'\\\\u003E\\\\u000a                            \\\\u003C/div\\\\u003E\\\",\\u000a                        id: \\\"yom-ad-LREC-iframe\\\"\\u000a                    },\\u000a                    \\\"yom-ad-LREC2\\\": {\\u000a                        node: \\\"\\\\u003Cdiv id='yom-ad-LREC2-iframe' class='yom-ad-iframe' marginwidth='0' marginheight='0'\\\\u000a                                    hspace='0' vspace='0' frameborder='0' scrolling='no' style='display:none;\\\\u000a                                    width:300px;height:266px;'\\\\u003E\\\\u000a                            \\\\u003C/div\\\\u003E\\\",\\u000a                        id: \\\"yom-ad-LREC2-iframe\\\"\\u000a                    },\\u000a                    \\\"yom-ad-LDRB\\\": {\\u000a                        node: \\\"\\\\u003Cdiv id='yom-ad-LDRB-iframe' class='yom-ad-iframe' marginwidth='0' marginheight='0'\\\\u000a                                    hspace='0' vspace='0' frameborder='0' scrolling='no' style='display:none;\\\\u000a                                    width:728px;height:93px;'\\\\u003E\\\\u000a                            \\\\u003C/div\\\\u003E\\\",\\u000a                        id: \\\"yom-ad-LDRB-iframe\\\"\\u000a                    },\\u000a                    \\\"yom-ad-LDRB2\\\": {\\u000a                        node: \\\"\\\\u003Cdiv id='yom-ad-LDRB2-iframe' class='yom-ad-iframe' marginwidth='0' marginheight='0'\\\\u000a                                    hspace='0' vspace='0' frameborder='0' scrolling='no' style='display:none;\\\\u000a                                    width:728px;height:93px;'\\\\u003E\\\\u000a                            \\\\u003C/div\\\\u003E\\\",\\u000a                        id: \\\"yom-ad-LDRB2-iframe\\\"\\u000a                    },\\u000a                    \\\"yom-ad-LDRB3\\\": {\\u000a                        node: \\\"\\\\u003Cdiv id='yom-ad-LDRB3-iframe' class='yom-ad-iframe' marginwidth='0' marginheight='0'\\\\u000a                                    hspace='0' vspace='0' frameborder='0' scrolling='no' style='display:none;\\\\u000a                                    width:728px;height:93px;'\\\\u003E\\\\u000a                            \\\\u003C/div\\\\u003E\\\",\\u000a                        id: \\\"yom-ad-LDRB3-iframe\\\"\\u000a                    },\\u000a                    \\\"yom-ad-MAST\\\": {\\u000a                        node: \\\"\\\\u003Cdiv id='yom-ad-MAST-iframe' class='yom-ad-iframe' marginwidth='0' marginheight='0'\\\\u000a                                    hspace='0' vspace='0' frameborder='0' scrolling='no' style='display:none;\\\\u000a                                    width:970px;height:31px;'\\\\u003E\\\\u000a                            \\\\u003C/div\\\\u003E\\\",\\u000a                        id: \\\"yom-ad-MAST-iframe\\\"\\u000a                    },\\u000a                    \\\"yom-ad-WPS\\\": {\\u000a                        node: \\\"\\\\u003Cdiv id='yom-ad-WPS-iframe' class='yom-ad-iframe' marginwidth='0' marginheight='0'\\\\u000a                                    hspace='0' vspace='0' frameborder='0' scrolling='no' style='display:none;\\\\u000a                                    width:320px;height:66px;'\\\\u003E\\\\u000a                            \\\\u003C/div\\\\u003E\\\",\\u000a                        id: \\\"yom-ad-WPS-iframe\\\"\\u000a                    }\\u000a                };\\u000a                DARLA_CONFIG = {\\u000a                    servicePath: \\\"http://news.yahoo.com/__darla/php/fc.php\\\",\\u000a                    beaconPath: \\\"http://news.yahoo.com/__darla/php/b.php\\\",\\u000a                    renderPath: \\\"\\\",\\u000a                    allowFiF: false,\\u000a                    srenderPath: \\\"http://l.yimg.com/rq/darla/2-6-3/html/r-sf.html\\\",\\u000a                    renderFile: \\\"http://l.yimg.com/rq/darla/2-6-3/html/r-sf.html\\\",\\u000a                    sfbrenderPath: \\\"http://l.yimg.com/rq/darla/2-6-3/html/r-sf.html\\\",\\u000a                    msgPath: \\\"http://news.yahoo.com/__darla/2-6-3/html/msg.html\\\",\\u000a                    cscPath: \\\"http://l.yimg.com/rq/darla/2-6-3/html/r-csc.html\\\",\\u000a                    root: \\\"__darla\\\",\\u000a                    edgeRoot: \\\"http://l.yimg.com/rq/darla/2-6-3\\\",\\u000a                    sedgeRoot: \\\"https://s.yimg.com/rq/darla/2-6-3\\\",\\u000a                    version: \\\"2-6-3\\\",\\u000a                    tpbURI: \\\"\\\",\\u000a                    beaconsDisabled: true,\\u000a                    rotationTimingDisabled: true,\\u000a                    positions: {\\u000a                        LREC: {\\u000a                            w: 300,\\u000a                            h: 250\\u000a                        },\\u000a                        MAST: [],\\u000a                        LREC2: {\\u000a                            w: 300,\\u000a                            h: 250\\u000a                        }\\u000a                    }\\u000a                };\\u000a                DARLA_CONFIG.servicePath = DARLA_CONFIG.servicePath.replace(/\\\\:8033/g, \\\"\\\");\\u000a                DARLA_CONFIG.msgPath = DARLA_CONFIG.msgPath.replace(/\\\\:8033/g, \\\"\\\");\\u000a                DARLA_CONFIG.positions = {\\u000a                    LREC2: {\\u000a                        w: \\\"300\\\",\\u000a                        h: 266,\\u000a                        dest: \\\"yom-ad-LREC2-iframe\\\",\\u000a                        fr: \\\"expIfr_exp\\\",\\u000a                        pos: \\\"LREC2\\\",\\u000a                        id: \\\"LREC2\\\",\\u000a                        clean: \\\"yom-ad-LREC2\\\",\\u000a                        rmxp: 0,\\u000a                        z: 10\\u000a                    },\\u000a                    MAST: {\\u000a                        w: \\\"970\\\",\\u000a                        h: 31,\\u000a                        dest: \\\"yom-ad-MAST-iframe\\\",\\u000a                        fr: \\\"expIfr_exp\\\",\\u000a                        pos: \\\"MAST\\\",\\u000a                        id: \\\"MAST\\\",\\u000a                        clean: \\\"yom-ad-MAST\\\",\\u000a                        rmxp: 0,\\u000a                        supports: {\\u000a                            \\\"*\\\": 1\\u000a                        }\\u000a                    },\\u000a                    LREC: {\\u000a                        w: \\\"300\\\",\\u000a                        h: 266,\\u000a                        dest: \\\"yom-ad-LREC-iframe\\\",\\u000a                        fr: \\\"expIfr_exp\\\",\\u000a                        pos: \\\"LREC\\\",\\u000a                        id: \\\"LREC\\\",\\u000a                        clean: \\\"yom-ad-LREC\\\",\\u000a                        rmxp: 0,\\u000a                        z: 10\\u000a                    },\\u000a                    WPS: {\\u000a                        w: \\\"320\\\",\\u000a                        h: 66,\\u000a                        dest: \\\"yom-ad-WPS-iframe\\\",\\u000a                        fr: \\\"expIfr_exp\\\",\\u000a                        pos: \\\"WPS\\\",\\u000a                        id: \\\"WPS\\\",\\u000a                        clean: \\\"yom-ad-WPS\\\",\\u000a                        rmxp: 0,\\u000a                        metaSize: true\\u000a                    },\\u000a                    LDRB3: {\\u000a                        w: \\\"728\\\",\\u000a                        h: 93,\\u000a                        dest: \\\"yom-ad-LDRB3-iframe\\\",\\u000a                        fr: \\\"expIfr_exp\\\",\\u000a                        pos: \\\"LDRB3\\\",\\u000a                        id: \\\"LDRB3\\\",\\u000a                        clean: \\\"yom-ad-LDRB3\\\",\\u000a                        rmxp: 0\\u000a                    },\\u000a                    LDRB2: {\\u000a                        w: \\\"728\\\",\\u000a                        h: 93,\\u000a                        dest: \\\"yom-ad-LDRB2-iframe\\\",\\u000a                        fr: \\\"expIfr_exp\\\",\\u000a                        pos: \\\"LDRB2\\\",\\u000a                        id: \\\"LDRB2\\\",\\u000a                        clean: \\\"yom-ad-LDRB2\\\",\\u000a                        rmxp: 0\\u000a                    },\\u000a                    LDRB: {\\u000a                        w: \\\"728\\\",\\u000a                        h: 93,\\u000a                        dest: \\\"yom-ad-LDRB-iframe\\\",\\u000a                        fr: \\\"expIfr_exp\\\",\\u000a                        pos: \\\"LDRB\\\",\\u000a                        id: \\\"LDRB\\\",\\u000a                        clean: \\\"yom-ad-LDRB\\\",\\u000a                        rmxp: 0\\u000a                    }\\u000a                };\\u000a                DARLA_CONFIG.events = {\\u000a                    mediaadsdarla: {\\u000a                        lvl: \\\"2\\\",\\u000a                        sp: \\\"81121452\\\",\\u000a                        npv: \\\"1\\\",\\u000a                        bg: \\\"FFFFFF\\\",\\u000a                        sa: \\\"\\\\\\\"minihome\\\\\\\"=\\\\\\\"home\\\\\\\" \\\\\\\"type\\\\\\\"=\\\\\\\"page\\\\\\\" lang=\\\\\\\"en-US\\\\\\\"  can_suppress_ugc=\\\\\\\"1\\\\\\\" LREC=\\\\\\\"300x250\\\\\\\" LREC2=\\\\\\\"300x250\\\\\\\"\\\",\\u000a                        sa_orig: \\\"\\\\\\\"minihome\\\\\\\"=\\\\\\\"home\\\\\\\" \\\\\\\"type\\\\\\\"=\\\\\\\"page\\\\\\\" lang=\\\\\\\"en-US\\\\\\\"  can_suppress_ugc=\\\\\\\"1\\\\\\\" LREC=\\\\\\\"300x250\\\\\\\" LREC2=\\\\\\\"300x250\\\\\\\"\\\",\\u000a                        filter: \\\"no_expandable;exp_iframe_expandable;\\\",\\u000a                        mpid: \\\"692\\\",\\u000a                        mpnm: \\\"yahoo_mobile_us_web\\\",\\u000a                        locale: \\\"US\\\",\\u000a                        ps: \\\"LREC,LREC2,LDRB,LDRB2,LDRB3,MAST,WPS\\\",\\u000a                        ml: \\\"\\\",\\u000a                        mps: \\\"\\\"\\u000a                    }\\u000a                };\\u000a                DARLA_CONFIG.onFinishPosRender = function(pos_id) {\\u000a                    var pos_conf, id, el, par, shm;\\u000a                    if (pos_id) {\\u000a                        pos_conf = DARLA.posSettings(pos_id);\\u000a                        id = ((pos_conf && pos_conf.dest));\\u000a                        el = (((id && document.getElementById(id))) || null);\\u000a                        par = ((el && el.parentNode));\\u000a                        shm = ((id && document.getElementById((\\\"shm_\\\" + id))));\\u000a                        if (par) {\\u000a                            par.style.zIndex = 99;\\u000a                        }\\u000a                    ;\\u000a                        if (shm) {\\u000a                            shm.style.zIndex = 99;\\u000a                        }\\u000a                    ;\\u000a                        if (el) {\\u000a                            el.style.zIndex = 100;\\u000a                        }\\u000a                    ;\\u000a                    }\\u000a                ;\\u000a                };\\u000a                DARLA_CONFIG.onPosMsg = function(msg, id) {\\u000a                    if (!DARLA.isIE) {\\u000a                        return\\u000a                    };\\u000a                    setTimeout(function() {\\u000a                        var i = 0, iframes, iframe, id, zmap = {\\u000a                        }, shim = [], d = document;\\u000a                        if (((msg === \\\"exp-ovr\\\") || (msg === \\\"exp-push\\\"))) {\\u000a                            iframes = d.getElementsByTagName(\\\"iframe\\\");\\u000a                            for (; iframe = iframes[i++]; ) {\\u000a                                id = iframe.id;\\u000a                                zmap[id] = iframe.style.zIndex;\\u000a                                if ((id.indexOf(\\\"shm_\\\") === 0)) {\\u000a                                    shim[shim.length] = id;\\u000a                                }\\u000a                            ;\\u000a                            };\\u000a                            if ((shim.length \\u003E 0)) {\\u000a                                for (i = 0; iframe = shim[i++]; ) {\\u000a                                    id = iframe.substr(4);\\u000a                                    d.getElementById(iframe).style.zIndex = (zmap[id] - 1);\\u000a                                };\\u000a                            }\\u000a                        ;\\u000a                        }\\u000a                    ;\\u000a                    }, 10);\\u000a                };\\u000a                DARLA_CONFIG.onSuccess = function(eventId, positions) {\\u000a                    Y.Global.fire(\\\"darla:success\\\", {\\u000a                        positions: positions\\u000a                    });\\u000a                    Y.log((\\\"fetch ad success: \\\" + positions.join(\\\", \\\")), \\\"info\\\", \\\"darla\\\");\\u000a                };\\u000a                DARLA_CONFIG.onFailure = function(eventId) {\\u000a                    var positions = null;\\u000a                    try {\\u000a                        positions = DARLA_CONFIG.events[eventId].ps.split(\\\",\\\");\\u000a                    } catch (e) {\\u000a                    \\u000a                    };\\u000a                    Y.Global.fire(\\\"darla:failure\\\", {\\u000a                        positions: positions\\u000a                    });\\u000a                    Y.log((\\\"fetch ad failure\\\" + ((positions ? ((\\\": \\\" + positions.join(\\\", \\\"))) : \\\"\\\"))), \\\"warn\\\", \\\"darla\\\");\\u000a                };\\u000a                var _prepareNodes = function() {\\u000a                    for (var cleanId in nodes) {\\u000a                        var center = Y.one(((\\\"#\\\" + cleanId) + \\\" \\\\u003E center\\\"));\\u000a                        if ((((center != null) && center) && !Y.one((\\\"#\\\" + nodes[cleanId].id)))) {\\u000a                            center.set(\\\"innerHTML\\\", \\\"\\\");\\u000a                            center.insert(nodes[cleanId].node);\\u000a                        }\\u000a                    ;\\u000a                    };\\u000a                };\\u000a                var w = window, D = w.DARLA, C = w.DARLA_CONFIG, DM = (w.DOC_DOMAIN_SET || 0);\\u000a                if (D) {\\u000a                    if ((D && C)) {\\u000a                        C.dm = DM;\\u000a                    }\\u000a                ;\\u000a                    _prepareNodes();\\u000a                    DARLA.config(C);\\u000a                    DARLA.render();\\u000a                }\\u000a            ;\\u000a                return {\\u000a                    event: function(eventId, spaceId, adsSa) {\\u000a                        if ((window.DARLA && eventId)) {\\u000a                            _prepareNodes();\\u000a                            var eventConfig = {\\u000a                            };\\u000a                            if (!isNaN(spaceId)) {\\u000a                                eventConfig.sp = spaceId;\\u000a                            }\\u000a                        ;\\u000a                            adsSa = ((((typeof adsSa !== \\\"undefined\\\") && (adsSa !== null))) ? adsSa : \\\"\\\");\\u000a                            eventConfig.sa = (DARLA_CONFIG.events[eventId].sa_orig.replace ? DARLA_CONFIG.events[eventId].sa_orig.replace(\\\"ADSSA\\\", adsSa) : \\\"\\\");\\u000a                            DARLA.event(eventId, eventConfig);\\u000a                        }\\u000a                    ;\\u000a                    }\\u000a                };\\u000a            })();\\u000a            YUI.AdsDarla.mediaadsdarla = {\\u000a                fetch: (Y.bind(YUI.AdsDarla.event, YUI.AdsDarla, \\\"mediaadsdarla\\\"))\\u000a            };\\u000a            YUI.AdsDarla.fetch = YUI.AdsDarla.mediaadsdarla.fetch;\\u000a            Y.Global.fire(\\\"darla:ready\\\");\\u000a        });\\u000a    });\\u000a};\\u000a;\\u000aif (window.addEventListener) {\\u000a    window.addEventListener(\\\"load\\\", loadAdsAfterOnLoad, 0);\\u000a} else {\\u000a    if (window.attachEvent) {\\u000a        window.attachEvent(\\\"onload\\\", loadAdsAfterOnLoad);\\u000a    }\\u000a};\"), (\"sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    function loadAdsAfterOnLoad() {\n        if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n            return ((JSBNG_Record.eventCall)((arguments.callee), (\"sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_0\"), (sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_0_instance), (this), (arguments)))\n        };\n        (null);\n        (((JSBNG_Record.get)(YMedia, (\"later\")))[(\"later\")])(10, this, ((function() {\n            var sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_1_instance;\n            ((sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_1_instance) = ((JSBNG_Record.eventInstance)((\"sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_1\"))));\n            return ((JSBNG_Record.markFunction)((function() {\n                if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                    return ((JSBNG_Record.eventCall)((arguments.callee), (\"sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_1\"), (sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_1_instance), (this), (arguments)))\n                };\n                (null);\n                (((JSBNG_Record.get)(YMedia, (\"use\")))[(\"use\")])(\"node-base\", ((function() {\n                    var sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_2_instance;\n                    ((sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_2_instance) = ((JSBNG_Record.eventInstance)((\"sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_2\"))));\n                    return ((JSBNG_Record.markFunction)((function(Y) {\n                        if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                            return ((JSBNG_Record.eventCall)((arguments.callee), (\"sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_2\"), (sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_2_instance), (this), (arguments)))\n                        };\n                        (null);\n                        ((JSBNG_Record.set)(YUI, (\"AdsDarla\"), ((function() {\n                            var sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_3_instance;\n                            ((sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_3_instance) = ((JSBNG_Record.eventInstance)((\"sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_3\"))));\n                            return ((JSBNG_Record.markFunction)((function() {\n                                if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                                    return ((JSBNG_Record.eventCall)((arguments.callee), (\"sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_3\"), (sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_3_instance), (this), (arguments)))\n                                };\n                                (null);\n                                var nodes = {\n                                    \"yom-ad-LREC\": {\n                                        node: \"\\u003Cdiv id='yom-ad-LREC-iframe' class='yom-ad-iframe' marginwidth='0' marginheight='0'\\u000a                                    hspace='0' vspace='0' frameborder='0' scrolling='no' style='display:none;\\u000a                                    width:300px;height:266px;'\\u003E\\u000a                            \\u003C/div\\u003E\",\n                                        id: \"yom-ad-LREC-iframe\"\n                                    },\n                                    \"yom-ad-LREC2\": {\n                                        node: \"\\u003Cdiv id='yom-ad-LREC2-iframe' class='yom-ad-iframe' marginwidth='0' marginheight='0'\\u000a                                    hspace='0' vspace='0' frameborder='0' scrolling='no' style='display:none;\\u000a                                    width:300px;height:266px;'\\u003E\\u000a                            \\u003C/div\\u003E\",\n                                        id: \"yom-ad-LREC2-iframe\"\n                                    },\n                                    \"yom-ad-LDRB\": {\n                                        node: \"\\u003Cdiv id='yom-ad-LDRB-iframe' class='yom-ad-iframe' marginwidth='0' marginheight='0'\\u000a                                    hspace='0' vspace='0' frameborder='0' scrolling='no' style='display:none;\\u000a                                    width:728px;height:93px;'\\u003E\\u000a                            \\u003C/div\\u003E\",\n                                        id: \"yom-ad-LDRB-iframe\"\n                                    },\n                                    \"yom-ad-LDRB2\": {\n                                        node: \"\\u003Cdiv id='yom-ad-LDRB2-iframe' class='yom-ad-iframe' marginwidth='0' marginheight='0'\\u000a                                    hspace='0' vspace='0' frameborder='0' scrolling='no' style='display:none;\\u000a                                    width:728px;height:93px;'\\u003E\\u000a                            \\u003C/div\\u003E\",\n                                        id: \"yom-ad-LDRB2-iframe\"\n                                    },\n                                    \"yom-ad-LDRB3\": {\n                                        node: \"\\u003Cdiv id='yom-ad-LDRB3-iframe' class='yom-ad-iframe' marginwidth='0' marginheight='0'\\u000a                                    hspace='0' vspace='0' frameborder='0' scrolling='no' style='display:none;\\u000a                                    width:728px;height:93px;'\\u003E\\u000a                            \\u003C/div\\u003E\",\n                                        id: \"yom-ad-LDRB3-iframe\"\n                                    },\n                                    \"yom-ad-MAST\": {\n                                        node: \"\\u003Cdiv id='yom-ad-MAST-iframe' class='yom-ad-iframe' marginwidth='0' marginheight='0'\\u000a                                    hspace='0' vspace='0' frameborder='0' scrolling='no' style='display:none;\\u000a                                    width:970px;height:31px;'\\u003E\\u000a                            \\u003C/div\\u003E\",\n                                        id: \"yom-ad-MAST-iframe\"\n                                    },\n                                    \"yom-ad-WPS\": {\n                                        node: \"\\u003Cdiv id='yom-ad-WPS-iframe' class='yom-ad-iframe' marginwidth='0' marginheight='0'\\u000a                                    hspace='0' vspace='0' frameborder='0' scrolling='no' style='display:none;\\u000a                                    width:320px;height:66px;'\\u003E\\u000a                            \\u003C/div\\u003E\",\n                                        id: \"yom-ad-WPS-iframe\"\n                                    }\n                                };\n                                DARLA_CONFIG = {\n                                    servicePath: \"http://news.yahoo.com/__darla/php/fc.php\",\n                                    beaconPath: \"http://news.yahoo.com/__darla/php/b.php\",\n                                    renderPath: \"\",\n                                    allowFiF: false,\n                                    srenderPath: \"http://l.yimg.com/rq/darla/2-6-3/html/r-sf.html\",\n                                    renderFile: \"http://l.yimg.com/rq/darla/2-6-3/html/r-sf.html\",\n                                    sfbrenderPath: \"http://l.yimg.com/rq/darla/2-6-3/html/r-sf.html\",\n                                    msgPath: \"http://news.yahoo.com/__darla/2-6-3/html/msg.html\",\n                                    cscPath: \"http://l.yimg.com/rq/darla/2-6-3/html/r-csc.html\",\n                                    root: \"__darla\",\n                                    edgeRoot: \"http://l.yimg.com/rq/darla/2-6-3\",\n                                    sedgeRoot: \"https://s.yimg.com/rq/darla/2-6-3\",\n                                    version: \"2-6-3\",\n                                    tpbURI: \"\",\n                                    beaconsDisabled: true,\n                                    rotationTimingDisabled: true,\n                                    positions: {\n                                        LREC: {\n                                            w: 300,\n                                            h: 250\n                                        },\n                                        MAST: [],\n                                        LREC2: {\n                                            w: 300,\n                                            h: 250\n                                        }\n                                    }\n                                };\n                                ((JSBNG_Record.set)(DARLA_CONFIG, (\"servicePath\"), (((JSBNG_Record.get)((((JSBNG_Record.get)(DARLA_CONFIG, (\"servicePath\")))[(\"servicePath\")]), (\"replace\")))[(\"replace\")])(/\\:8033/g, \"\")));\n                                ((JSBNG_Record.set)(DARLA_CONFIG, (\"msgPath\"), (((JSBNG_Record.get)((((JSBNG_Record.get)(DARLA_CONFIG, (\"msgPath\")))[(\"msgPath\")]), (\"replace\")))[(\"replace\")])(/\\:8033/g, \"\")));\n                                ((JSBNG_Record.set)(DARLA_CONFIG, (\"positions\"), {\n                                    LREC2: {\n                                        w: \"300\",\n                                        h: 266,\n                                        dest: \"yom-ad-LREC2-iframe\",\n                                        fr: \"expIfr_exp\",\n                                        pos: \"LREC2\",\n                                        id: \"LREC2\",\n                                        clean: \"yom-ad-LREC2\",\n                                        rmxp: 0,\n                                        z: 10\n                                    },\n                                    MAST: {\n                                        w: \"970\",\n                                        h: 31,\n                                        dest: \"yom-ad-MAST-iframe\",\n                                        fr: \"expIfr_exp\",\n                                        pos: \"MAST\",\n                                        id: \"MAST\",\n                                        clean: \"yom-ad-MAST\",\n                                        rmxp: 0,\n                                        supports: {\n                                            \"*\": 1\n                                        }\n                                    },\n                                    LREC: {\n                                        w: \"300\",\n                                        h: 266,\n                                        dest: \"yom-ad-LREC-iframe\",\n                                        fr: \"expIfr_exp\",\n                                        pos: \"LREC\",\n                                        id: \"LREC\",\n                                        clean: \"yom-ad-LREC\",\n                                        rmxp: 0,\n                                        z: 10\n                                    },\n                                    WPS: {\n                                        w: \"320\",\n                                        h: 66,\n                                        dest: \"yom-ad-WPS-iframe\",\n                                        fr: \"expIfr_exp\",\n                                        pos: \"WPS\",\n                                        id: \"WPS\",\n                                        clean: \"yom-ad-WPS\",\n                                        rmxp: 0,\n                                        metaSize: true\n                                    },\n                                    LDRB3: {\n                                        w: \"728\",\n                                        h: 93,\n                                        dest: \"yom-ad-LDRB3-iframe\",\n                                        fr: \"expIfr_exp\",\n                                        pos: \"LDRB3\",\n                                        id: \"LDRB3\",\n                                        clean: \"yom-ad-LDRB3\",\n                                        rmxp: 0\n                                    },\n                                    LDRB2: {\n                                        w: \"728\",\n                                        h: 93,\n                                        dest: \"yom-ad-LDRB2-iframe\",\n                                        fr: \"expIfr_exp\",\n                                        pos: \"LDRB2\",\n                                        id: \"LDRB2\",\n                                        clean: \"yom-ad-LDRB2\",\n                                        rmxp: 0\n                                    },\n                                    LDRB: {\n                                        w: \"728\",\n                                        h: 93,\n                                        dest: \"yom-ad-LDRB-iframe\",\n                                        fr: \"expIfr_exp\",\n                                        pos: \"LDRB\",\n                                        id: \"LDRB\",\n                                        clean: \"yom-ad-LDRB\",\n                                        rmxp: 0\n                                    }\n                                }));\n                                ((JSBNG_Record.set)(DARLA_CONFIG, (\"events\"), {\n                                    mediaadsdarla: {\n                                        lvl: \"2\",\n                                        sp: \"81121452\",\n                                        npv: \"1\",\n                                        bg: \"FFFFFF\",\n                                        sa: \"\\\"minihome\\\"=\\\"home\\\" \\\"type\\\"=\\\"page\\\" lang=\\\"en-US\\\"  can_suppress_ugc=\\\"1\\\" LREC=\\\"300x250\\\" LREC2=\\\"300x250\\\"\",\n                                        sa_orig: \"\\\"minihome\\\"=\\\"home\\\" \\\"type\\\"=\\\"page\\\" lang=\\\"en-US\\\"  can_suppress_ugc=\\\"1\\\" LREC=\\\"300x250\\\" LREC2=\\\"300x250\\\"\",\n                                        filter: \"no_expandable;exp_iframe_expandable;\",\n                                        mpid: \"692\",\n                                        mpnm: \"yahoo_mobile_us_web\",\n                                        locale: \"US\",\n                                        ps: \"LREC,LREC2,LDRB,LDRB2,LDRB3,MAST,WPS\",\n                                        ml: \"\",\n                                        mps: \"\"\n                                    }\n                                }));\n                                ((JSBNG_Record.set)(DARLA_CONFIG, (\"onFinishPosRender\"), ((function() {\n                                    var sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_4_instance;\n                                    ((sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_4_instance) = ((JSBNG_Record.eventInstance)((\"sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_4\"))));\n                                    return ((JSBNG_Record.markFunction)((function(pos_id) {\n                                        if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                                            return ((JSBNG_Record.eventCall)((arguments.callee), (\"sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_4\"), (sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_4_instance), (this), (arguments)))\n                                        };\n                                        (null);\n                                        var pos_conf, id, el, par, shm;\n                                        if (pos_id) {\n                                            pos_conf = (((JSBNG_Record.get)(DARLA, (\"posSettings\")))[(\"posSettings\")])(pos_id);\n                                            id = ((pos_conf && (((JSBNG_Record.get)(pos_conf, (\"dest\")))[(\"dest\")])));\n                                            el = (((id && (((JSBNG_Record.get)(JSBNG__document, (\"getElementById\")))[(\"getElementById\")])(id))) || null);\n                                            par = ((el && (((JSBNG_Record.get)(el, (\"parentNode\")))[(\"parentNode\")])));\n                                            shm = ((id && (((JSBNG_Record.get)(JSBNG__document, (\"getElementById\")))[(\"getElementById\")])((\"shm_\" + id))));\n                                            if (par) {\n                                                ((JSBNG_Record.set)((((JSBNG_Record.get)(par, (\"style\")))[(\"style\")]), (\"zIndex\"), 99));\n                                            }\n                                        ;\n                                            if (shm) {\n                                                ((JSBNG_Record.set)((((JSBNG_Record.get)(shm, (\"style\")))[(\"style\")]), (\"zIndex\"), 99));\n                                            }\n                                        ;\n                                            if (el) {\n                                                ((JSBNG_Record.set)((((JSBNG_Record.get)(el, (\"style\")))[(\"style\")]), (\"zIndex\"), 100));\n                                            }\n                                        ;\n                                        }\n                                        ;\n                                    })));\n                                })())));\n                                ((JSBNG_Record.set)(DARLA_CONFIG, (\"onPosMsg\"), ((function() {\n                                    var sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_5_instance;\n                                    ((sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_5_instance) = ((JSBNG_Record.eventInstance)((\"sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_5\"))));\n                                    return ((JSBNG_Record.markFunction)((function(msg, id) {\n                                        if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                                            return ((JSBNG_Record.eventCall)((arguments.callee), (\"sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_5\"), (sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_5_instance), (this), (arguments)))\n                                        };\n                                        (null);\n                                        if (!(((JSBNG_Record.get)(DARLA, (\"isIE\")))[(\"isIE\")])) {\n                                            return\n                                        };\n                                        JSBNG__setTimeout(((function() {\n                                            var sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_6_instance;\n                                            ((sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_6_instance) = ((JSBNG_Record.eventInstance)((\"sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_6\"))));\n                                            return ((JSBNG_Record.markFunction)((function() {\n                                                if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                                                    return ((JSBNG_Record.eventCall)((arguments.callee), (\"sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_6\"), (sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_6_instance), (this), (arguments)))\n                                                };\n                                                (null);\n                                                var i = 0, iframes, iframe, id, zmap = {\n                                                }, shim = [], d = JSBNG__document;\n                                                if (((msg === \"exp-ovr\") || (msg === \"exp-push\"))) {\n                                                    iframes = (((JSBNG_Record.get)(d, (\"getElementsByTagName\")))[(\"getElementsByTagName\")])(\"div\");\n                                                    for (; iframe = (((JSBNG_Record.get)(iframes, ((JSBNG_Record.temps.t09e392a19f0c05089aa4414418c656e9ddd98d1a) = i++)))[(JSBNG_Record.temps.t09e392a19f0c05089aa4414418c656e9ddd98d1a)]); ) {\n                                                        id = (((JSBNG_Record.get)(iframe, (\"id\")))[(\"id\")]);\n                                                        ((JSBNG_Record.set)(zmap, id, (((JSBNG_Record.get)((((JSBNG_Record.get)(iframe, (\"style\")))[(\"style\")]), (\"zIndex\")))[(\"zIndex\")])));\n                                                        if (((((JSBNG_Record.get)(id, (\"indexOf\")))[(\"indexOf\")])(\"shm_\") === 0)) {\n                                                            ((JSBNG_Record.set)(shim, (((JSBNG_Record.get)(shim, (\"length\")))[(\"length\")]), id));\n                                                        }\n                                                    ;\n                                                    };\n                                                    if (((((JSBNG_Record.get)(shim, (\"length\")))[(\"length\")]) > 0)) {\n                                                        for (i = 0; iframe = (((JSBNG_Record.get)(shim, ((JSBNG_Record.temps.tc56e5d231177ce79ee8b8312fe7d60999881a710) = i++)))[(JSBNG_Record.temps.tc56e5d231177ce79ee8b8312fe7d60999881a710)]); ) {\n                                                            id = (((JSBNG_Record.get)(iframe, (\"substr\")))[(\"substr\")])(4);\n                                                            ((JSBNG_Record.set)((((JSBNG_Record.get)((((JSBNG_Record.get)(d, (\"getElementById\")))[(\"getElementById\")])(iframe), (\"style\")))[(\"style\")]), (\"zIndex\"), ((((JSBNG_Record.get)(zmap, id))[id]) - 1)));\n                                                        };\n                                                    }\n                                                ;\n                                                }\n                                                ;\n                                            })));\n                                        })()), 10);\n                                    })));\n                                })())));\n                                ((JSBNG_Record.set)(DARLA_CONFIG, (\"onSuccess\"), ((function() {\n                                    var sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_7_instance;\n                                    ((sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_7_instance) = ((JSBNG_Record.eventInstance)((\"sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_7\"))));\n                                    return ((JSBNG_Record.markFunction)((function(eventId, positions) {\n                                        if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                                            return ((JSBNG_Record.eventCall)((arguments.callee), (\"sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_7\"), (sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_7_instance), (this), (arguments)))\n                                        };\n                                        (null);\n                                        (((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Global\")))[(\"Global\")]), (\"fire\")))[(\"fire\")])(\"darla:success\", {\n                                            positions: positions\n                                        });\n                                        (((JSBNG_Record.get)(Y, (\"log\")))[(\"log\")])((\"fetch ad success: \" + (((JSBNG_Record.get)(positions, (\"join\")))[(\"join\")])(\", \")), \"info\", \"darla\");\n                                    })));\n                                })())));\n                                ((JSBNG_Record.set)(DARLA_CONFIG, (\"onFailure\"), ((function() {\n                                    var sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_8_instance;\n                                    ((sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_8_instance) = ((JSBNG_Record.eventInstance)((\"sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_8\"))));\n                                    return ((JSBNG_Record.markFunction)((function(eventId) {\n                                        if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                                            return ((JSBNG_Record.eventCall)((arguments.callee), (\"sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_8\"), (sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_8_instance), (this), (arguments)))\n                                        };\n                                        (null);\n                                        var positions = null;\n                                        try {\n                                            positions = (((JSBNG_Record.get)((((JSBNG_Record.get)((((JSBNG_Record.get)((((JSBNG_Record.get)(DARLA_CONFIG, (\"events\")))[(\"events\")]), eventId))[eventId]), (\"ps\")))[(\"ps\")]), (\"split\")))[(\"split\")])(\",\");\n                                        } catch (e) {\n                                        \n                                        };\n                                        (((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Global\")))[(\"Global\")]), (\"fire\")))[(\"fire\")])(\"darla:failure\", {\n                                            positions: positions\n                                        });\n                                        (((JSBNG_Record.get)(Y, (\"log\")))[(\"log\")])((\"fetch ad failure\" + ((positions ? ((\": \" + (((JSBNG_Record.get)(positions, (\"join\")))[(\"join\")])(\", \"))) : \"\"))), \"warn\", \"darla\");\n                                    })));\n                                })())));\n                                var _prepareNodes = ((function() {\n                                    var sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_9_instance;\n                                    ((sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_9_instance) = ((JSBNG_Record.eventInstance)((\"sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_9\"))));\n                                    return ((JSBNG_Record.markFunction)((function() {\n                                        if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                                            return ((JSBNG_Record.eventCall)((arguments.callee), (\"sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_9\"), (sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_9_instance), (this), (arguments)))\n                                        };\n                                        (null);\n                                        {\n                                            var fin0keys = ((JSBNG_Record.forInKeys)(((JSBNG_Record.getUnwrapped)((nodes))))), fin0i = (0);\n                                            var cleanId;\n                                            for (; (fin0i < fin0keys.length); (fin0i++)) {\n                                                ((cleanId) = (fin0keys[fin0i]));\n                                                {\n                                                    var center = (((JSBNG_Record.get)(Y, (\"one\")))[(\"one\")])(((\"#\" + cleanId) + \" \\u003E center\"));\n                                                    if ((((center != null) && center) && !(((JSBNG_Record.get)(Y, (\"one\")))[(\"one\")])((\"#\" + (((JSBNG_Record.get)((((JSBNG_Record.get)(nodes, cleanId))[cleanId]), (\"id\")))[(\"id\")]))))) {\n                                                        (((JSBNG_Record.get)(center, (\"set\")))[(\"set\")])(\"innerHTML\", \"\");\n                                                        (((JSBNG_Record.get)(center, (\"insert\")))[(\"insert\")])((((JSBNG_Record.get)((((JSBNG_Record.get)(nodes, cleanId))[cleanId]), (\"node\")))[(\"node\")]));\n                                                    }\n                                                ;\n                                                };\n                                            };\n                                        };\n                                    })));\n                                })());\n                                var w = window, D = (((JSBNG_Record.get)(w, (\"DARLA\")))[(\"DARLA\")]), C = (((JSBNG_Record.get)(w, (\"DARLA_CONFIG\")))[(\"DARLA_CONFIG\")]), DM = ((((JSBNG_Record.get)(w, (\"DOC_DOMAIN_SET\")))[(\"DOC_DOMAIN_SET\")]) || 0);\n                                if (D) {\n                                    if ((D && C)) {\n                                        ((JSBNG_Record.set)(C, (\"dm\"), DM));\n                                    }\n                                ;\n                                    _prepareNodes();\n                                    (((JSBNG_Record.get)(DARLA, (\"config\")))[(\"config\")])(C);\n                                    (((JSBNG_Record.get)(DARLA, (\"render\")))[(\"render\")])();\n                                }\n                                ;\n                                return {\n                                    JSBNG__event: ((function() {\n                                        var sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_10_instance;\n                                        ((sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_10_instance) = ((JSBNG_Record.eventInstance)((\"sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_10\"))));\n                                        return ((JSBNG_Record.markFunction)((function(eventId, spaceId, adsSa) {\n                                            if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                                                return ((JSBNG_Record.eventCall)((arguments.callee), (\"sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_10\"), (sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_10_instance), (this), (arguments)))\n                                            };\n                                            (null);\n                                            if (((((JSBNG_Record.get)(window, (\"DARLA\")))[(\"DARLA\")]) && eventId)) {\n                                                _prepareNodes();\n                                                var eventConfig = {\n                                                };\n                                                if (!isNaN(spaceId)) {\n                                                    ((JSBNG_Record.set)(eventConfig, (\"sp\"), spaceId));\n                                                }\n                                            ;\n                                                adsSa = ((((typeof adsSa !== \"undefined\") && (adsSa !== null))) ? adsSa : \"\");\n                                                ((JSBNG_Record.set)(eventConfig, (\"sa\"), ((((JSBNG_Record.get)((((JSBNG_Record.get)((((JSBNG_Record.get)((((JSBNG_Record.get)(DARLA_CONFIG, (\"events\")))[(\"events\")]), eventId))[eventId]), (\"sa_orig\")))[(\"sa_orig\")]), (\"replace\")))[(\"replace\")]) ? (((JSBNG_Record.get)((((JSBNG_Record.get)((((JSBNG_Record.get)((((JSBNG_Record.get)(DARLA_CONFIG, (\"events\")))[(\"events\")]), eventId))[eventId]), (\"sa_orig\")))[(\"sa_orig\")]), (\"replace\")))[(\"replace\")])(\"ADSSA\", adsSa) : \"\")));\n                                                (((JSBNG_Record.get)(DARLA, (\"JSBNG__event\")))[(\"JSBNG__event\")])(eventId, eventConfig);\n                                            }\n                                            ;\n                                        })));\n                                    })())\n                                };\n                            })));\n                        })())()));\n                        ((JSBNG_Record.set)((((JSBNG_Record.get)(YUI, (\"AdsDarla\")))[(\"AdsDarla\")]), (\"mediaadsdarla\"), {\n                            fetch: ((((JSBNG_Record.get)(Y, (\"bind\")))[(\"bind\")])((((JSBNG_Record.get)((((JSBNG_Record.get)(YUI, (\"AdsDarla\")))[(\"AdsDarla\")]), (\"JSBNG__event\")))[(\"JSBNG__event\")]), (((JSBNG_Record.get)(YUI, (\"AdsDarla\")))[(\"AdsDarla\")]), \"mediaadsdarla\"))\n                        }));\n                        ((JSBNG_Record.set)((((JSBNG_Record.get)(YUI, (\"AdsDarla\")))[(\"AdsDarla\")]), (\"fetch\"), (((JSBNG_Record.get)((((JSBNG_Record.get)((((JSBNG_Record.get)(YUI, (\"AdsDarla\")))[(\"AdsDarla\")]), (\"mediaadsdarla\")))[(\"mediaadsdarla\")]), (\"fetch\")))[(\"fetch\")])));\n                        (((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Global\")))[(\"Global\")]), (\"fire\")))[(\"fire\")])(\"darla:ready\");\n                    })));\n                })()));\n            })));\n        })()));\n    };\n    var sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_0_instance;\n    ((sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_0_instance) = ((JSBNG_Record.eventInstance)((\"sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_0\"))));\n    ((JSBNG_Record.markFunction)((loadAdsAfterOnLoad)));\n;\n    if ((((JSBNG_Record.get)(window, (\"JSBNG__addEventListener\")))[(\"JSBNG__addEventListener\")])) {\n        (((JSBNG_Record.get)(window, (\"JSBNG__addEventListener\")))[(\"JSBNG__addEventListener\")])(\"load\", loadAdsAfterOnLoad, 0);\n    } else {\n        if ((((JSBNG_Record.get)(window, (\"JSBNG__attachEvent\")))[(\"JSBNG__attachEvent\")])) {\n            (((JSBNG_Record.get)(window, (\"JSBNG__attachEvent\")))[(\"JSBNG__attachEvent\")])(\"JSBNG__onload\", loadAdsAfterOnLoad);\n        }\n    };\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};</script>\n<script>try {\n    ((JSBNG_Record.scriptLoad)((\"(function() {\\u000a    var wrap = document.getElementById(\\\"yom-ad-SDARLAEXTRA\\\");\\u000a    if ((null == wrap)) {\\u000a        wrap = (document.getElementById(\\\"yom-ad-SDARLAEXTRA-iframe\\\") || {\\u000a        });\\u000a    }\\u000a;\\u000a    var content = (wrap.innerHTML || \\\"\\\");\\u000a    if ((content && (content.substr(0, content.lastIndexOf(\\\"\\\\u003Cscript\\\\u003E\\\")).indexOf(\\\"loc=SDARLAEXTRA noad\\\") !== -1))) {\\u000a        wrap.style.display = \\\"none\\\";\\u000a    }\\u000a;\\u000a}());\"), (\"s2dff277a1759446eeb4b9cef5eca4a6a3bc5cb8e\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    (((function() {\n        var s2dff277a1759446eeb4b9cef5eca4a6a3bc5cb8e_0_instance;\n        ((s2dff277a1759446eeb4b9cef5eca4a6a3bc5cb8e_0_instance) = ((JSBNG_Record.eventInstance)((\"s2dff277a1759446eeb4b9cef5eca4a6a3bc5cb8e_0\"))));\n        return ((JSBNG_Record.markFunction)((function() {\n            if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                return ((JSBNG_Record.eventCall)((arguments.callee), (\"s2dff277a1759446eeb4b9cef5eca4a6a3bc5cb8e_0\"), (s2dff277a1759446eeb4b9cef5eca4a6a3bc5cb8e_0_instance), (this), (arguments)))\n            };\n            (null);\n            var wrap = (((JSBNG_Record.get)(JSBNG__document, (\"getElementById\")))[(\"getElementById\")])(\"yom-ad-SDARLAEXTRA\");\n            if ((null == wrap)) {\n                wrap = ((((JSBNG_Record.get)(JSBNG__document, (\"getElementById\")))[(\"getElementById\")])(\"yom-ad-SDARLAEXTRA-iframe\") || {\n                });\n            }\n            ;\n            var JSBNG__content = ((((JSBNG_Record.get)(wrap, (\"innerHTML\")))[(\"innerHTML\")]) || \"\");\n            if ((JSBNG__content && ((((JSBNG_Record.get)((((JSBNG_Record.get)(JSBNG__content, (\"substr\")))[(\"substr\")])(0, (((JSBNG_Record.get)(JSBNG__content, (\"lastIndexOf\")))[(\"lastIndexOf\")])(\"\\u003Cscript\\u003E\")), (\"indexOf\")))[(\"indexOf\")])(\"loc=SDARLAEXTRA noad\") !== -1))) {\n                ((JSBNG_Record.set)((((JSBNG_Record.get)(wrap, (\"style\")))[(\"style\")]), (\"display\"), \"none\"));\n            }\n            ;\n        })));\n    })())());\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};</script></center></div></center>";
// undefined
o79 = null;
// 3175
o79 = {};
// 3177
f911113496_737 = function() { return f911113496_737.returns[f911113496_737.inst++]; };
f911113496_737.returns = [];
f911113496_737.inst = 0;
// 3178
o0.JSBNG__removeEventListener = f911113496_737;
// 3180
f911113496_738 = function() { return f911113496_738.returns[f911113496_738.inst++]; };
f911113496_738.returns = [];
f911113496_738.inst = 0;
// 3181
f911113496_720.returns.push(f911113496_738);
// 3182
o80 = {};
// 3183
f911113496_0.returns.push(o80);
// undefined
o80 = null;
// 3184
f911113496_737.returns.push(undefined);
// 3185
o80 = {};
// 3186
f911113496_0.returns.push(o80);
// undefined
o80 = null;
// 3188
f911113496_741 = function() { return f911113496_741.returns[f911113496_741.inst++]; };
f911113496_741.returns = [];
f911113496_741.inst = 0;
// 3189
f911113496_720.returns.push(f911113496_741);
// 3190
o80 = {};
// 3191
f911113496_0.returns.push(o80);
// undefined
o80 = null;
// 3192
f911113496_6.returns.push(undefined);
// 3193
o80 = {};
// 3194
f911113496_0.returns.push(o80);
// undefined
o80 = null;
// 3195
o80 = {};
// 3197
o81 = {};
// 3198
f911113496_0.returns.push(o81);
// 3199
o81.setTime = f911113496_523;
// 3200
o81.getTime = f911113496_472;
// 3201
f911113496_472.returns.push(1373481542779);
// 3202
f911113496_523.returns.push(1405017542779);
// 3203
o81.toGMTString = f911113496_524;
// undefined
o81 = null;
// 3204
f911113496_524.returns.push("Thu, 10 Jul 2014 18:39:02 GMT");
// 3205
// 3206
o81 = {};
// 3209
f911113496_747 = function() { return f911113496_747.returns[f911113496_747.inst++]; };
f911113496_747.returns = [];
f911113496_747.inst = 0;
// 3210
o8.removeChild = f911113496_747;
// 3211
f911113496_747.returns.push(o41);
// 3212
o82 = {};
// 3214
o82.message = "Uncaught SyntaxError: Unexpected token if";
// 3216
f911113496_521.returns.push(undefined);
// 3217
f911113496_749 = function() { return f911113496_749.returns[f911113496_749.inst++]; };
f911113496_749.returns = [];
f911113496_749.inst = 0;
// 3218
o78.terminate = f911113496_749;
// 3219
f911113496_749.returns.push(undefined);
// 3220
// 3221
o83 = {};
// 3222
f911113496_70.returns.push(o83);
// undefined
o83 = null;
// 3223
o83 = {};
// 3224
f911113496_70.returns.push(o83);
// 3225
f911113496_470.returns.push(0.2357519082725048);
// 3226
f911113496_470.returns.push(0.9552003999706358);
// 3227
f911113496_470.returns.push(0.061567238764837384);
// 3228
f911113496_470.returns.push(0.4144419839140028);
// 3229
f911113496_470.returns.push(0.9259526305831969);
// 3230
f911113496_470.returns.push(0.8151535249780864);
// 3231
f911113496_470.returns.push(0.48749324842356145);
// 3232
f911113496_470.returns.push(0.7023613655474037);
// 3233
f911113496_470.returns.push(0.8522753245197237);
// 3234
f911113496_470.returns.push(0.7338947518728673);
// 3235
f911113496_470.returns.push(0.49201289168559015);
// 3236
f911113496_470.returns.push(0.00240473635494709);
// 3237
o84 = {};
// 3238
f911113496_0.returns.push(o84);
// 3240
f911113496_711.returns.push(1373481543584);
// 3241
f911113496_753 = function() { return f911113496_753.returns[f911113496_753.inst++]; };
f911113496_753.returns = [];
f911113496_753.inst = 0;
// 3242
o83.open = f911113496_753;
// 3243
f911113496_753.returns.push(undefined);
// 3244
// 3245
f911113496_754 = function() { return f911113496_754.returns[f911113496_754.inst++]; };
f911113496_754.returns = [];
f911113496_754.inst = 0;
// 3246
o83.setRequestHeader = f911113496_754;
// 3247
f911113496_754.returns.push(undefined);
// 3248
f911113496_755 = function() { return f911113496_755.returns[f911113496_755.inst++]; };
f911113496_755.returns = [];
f911113496_755.inst = 0;
// 3249
o83.send = f911113496_755;
// undefined
o83 = null;
// 3250
f911113496_755.returns.push(undefined);
// 3254
f911113496_547.returns.push(undefined);
// 3255
o83 = {};
// undefined
o83 = null;
// 3256
// 3259
f911113496_504.returns.push(true);
// 3261
o83 = {};
// undefined
fo911113496_473_style.returns.push(o83);
// undefined
o83 = null;
// 3264
o83 = {};
// 3265
f911113496_476.returns.push(o83);
// 3266
o83.appendChild = f911113496_508;
// 3268
o85 = {};
// 3269
f911113496_509.returns.push(o85);
// 3270
f911113496_508.returns.push(o85);
// undefined
o85 = null;
// 3271
f911113496_760 = function() { return f911113496_760.returns[f911113496_760.inst++]; };
f911113496_760.returns = [];
f911113496_760.inst = 0;
// 3272
o83.contains = f911113496_760;
// undefined
o83 = null;
// 3273
f911113496_760.returns.push(true);
// 3275
o5.textContent = "JSBNG_Record.sendMessageStmt(\"pageload\", {\"data\":\"\\n\\u003Chtml lang=\\\"en-US\\\" xmlns:og=\\\"http://ogp.me/ns#\\\" xmlns:fb=\\\"http://www.facebook.com/2008/fbml\\\"\\u003E\\n    \\u003Chead\\u003E\\n        \\u003Cscript\\u003Evar t_headstart=new Date().getTime();\\u003C/script\\u003E\\n        \\u003Cmeta http-equiv=\\\"content-type\\\" content=\\\"text/html; charset=UTF-8\\\"/\\u003E\\n\\t\\u003Ctitle\\u003EYahoo! News - Latest News &amp; Headlines\\u003C/title\\u003E\\n\\t\\u003Cmeta name=\\\"keywords\\\" lang=\\\"en-US\\\" content=\\\"news, news headlines, daily news, current events, top headlines, breaking news, news photos, news video, full coverage, yahoo news, yahoo\\\"/\\u003E\\n\\t\\u003Cmeta name=\\\"description\\\" lang=\\\"en-US\\\" content=\\\"The latest news and headlines from Yahoo! News. Get breaking news stories and in-depth coverage with videos and photos.\\\"/\\u003E\\n\\t\\u003Clink rel=\\\"canonical\\\" href=\\\"http://news.yahoo.com/\\\"/\\u003E\\n\\t\\u003Cmeta property=\\\"fb:app_id\\\" content=\\\"90376669494\\\"/\\u003E\\n\\t\\u003Cmeta property=\\\"og:description\\\" content=\\\"The latest news and headlines from Yahoo! News. Get breaking news stories and in-depth coverage with videos and photos.\\\"/\\u003E\\n\\t\\u003Cmeta property=\\\"og:image\\\" content=\\\"http://l2.yimg.com/bt/api/res/1.2/BvlRk2eMuZ5S5ZVts0i.Uw--/YXBwaWQ9eW5ld3M7cT04NTt3PTYwMA--/http://l.yimg.com/os/publish-images/news/2013-03-19/528dd2af-804a-4db8-b6eb-53b18b9b0592_ybang_225x225.png\\\"/\\u003E\\n\\t\\u003Cmeta property=\\\"og:site_name\\\" content=\\\"Yahoo! News\\\"/\\u003E\\n\\t\\u003Cmeta property=\\\"og:title\\\" content=\\\"Yahoo! News - Latest News &amp; Headlines\\\"/\\u003E\\n\\t\\u003Cmeta property=\\\"og:type\\\" content=\\\"website\\\"/\\u003E\\n\\t\\u003Cmeta property=\\\"og:url\\\" content=\\\"http://news.yahoo.com/\\\"/\\u003E\\n\\t\\u003Cmeta property=\\\"twitter:card\\\" content=\\\"summary\\\"/\\u003E\\n\\t\\u003Cmeta property=\\\"twitter:description\\\" content=\\\"The latest news and headlines from Yahoo! News. Get breaking news stories and in-depth coverage with videos and photos.\\\"/\\u003E\\n\\t\\u003Cmeta property=\\\"twitter:title\\\" content=\\\"Yahoo! News - Latest News &amp; Headlines\\\"/\\u003E\\n\\t\\u003Cmeta name=\\\"application-name\\\" content=\\\"Yahoo! News - Latest News &amp; Headlines\\\"/\\u003E\\n\\t\\u003Cmeta name=\\\"msapplication-TileColor\\\" content=\\\"#6e329d\\\"/\\u003E\\n\\t\\u003Cmeta name=\\\"msapplication-TileImage\\\" content=\\\"http://l.yimg.com/j/assets/ipt/win8-tile.png\\\"/\\u003E\\n\\t\\u003Clink rel=\\\"apple-touch-icon\\\"  href=\\\"http://l.yimg.com/j/assets/ipt/default-apple-touch-icon.png\\\"\\u003E\\n\\t\\u003Clink rel=\\\"apple-touch-icon\\\" sizes=\\\"114x114\\\" href=\\\"http://l.yimg.com/j/assets/ipt/default-apple-touch-icon-high.png\\\"\\u003E\\n\\t\\u003Clink rel=\\\"apple-touch-icon\\\" sizes=\\\"72x72\\\" href=\\\"http://l.yimg.com/j/assets/ipt/default-apple-touch-icon-tablet.png\\\"\\u003E\\n\\t\\u003Clink rel=\\\"apple-touch-icon\\\" sizes=\\\"144x144\\\" href=\\\"http://l.yimg.com/j/assets/ipt/default-apple-touch-icon-tablet-high.png\\\"\\u003E\\n        \\n        \\u003Cmeta name=\\\"apple-mobile-web-app-capable\\\" content=\\\"yes\\\"\\u003E\\n        \\u003Cmeta name=\\\"apple-mobile-web-app-status-bar-style\\\" content=\\\"black\\\"\\u003E\\n        \\n\\u003C!--[if lt IE 9]\\u003E\\n                        \\u003Cscript type=\\\"text/javascript\\\" src=\\\"http://l.yimg.com/os/mit/media/p/presentation/html5shiv-min-1218427.js\\\"\\u003E\\u003C/script\\u003E\\n                        \\u003C![endif]--\\u003E\\n\\n\\u003Clink rel=\\\"stylesheet\\\" type=\\\"text/css\\\" href=\\\"http://l.yimg.com/zz/combo?d/lib/yui/3.4.1/build/cssreset/cssreset-min.css&d/lib/yui/3.4.1/build/cssfonts/cssfonts-min.css&d/lib/yui/3.4.1/build/cssgrids/cssgrids-min.css&os/mit/media/p/content/grids/v2-master-min-1335630.css&os/mit/media/p/content/grids/v2-desktop-min-1335630.css&os/mit/media/p/content/other/ad-controller-desktop-min-1335630.css&os/mit/media/p/content/other/pane-manager-desktop-min-1335630.css&os/mit/media/p/content/base/v2-master-min-1304022.css&os/mit/media/p/content/base/v2-desktop-min-1335630.css&os/mit/media/p/content/overrides/classic-overrides-min-1280824.css&os/mit/media/m/content_photo/lightbox/lb-desktop-min-1314917.css&os/mit/media/m/header/header-uh3-desktop-min-1325508.css&os/mit/media/m/ads/ads-min-1305513.css&os/mit/media/m/navigation/content-navigation-desktop-min-1335637.css&os/mit/media/m/content_index/lead-desktop-min-1335719.css&os/mit/media/m/footer/footer_info-min-323669.css&os/mit/media/m/footer/footer_info-desktop-min-1338005.css&os/mit/media/m/content_social/media-content-share-buttons-desktop-min-1339153.css\\\" /\\u003E\\n\\n\\u003Clink rel=\\\"stylesheet\\\" type=\\\"text/css\\\" href=\\\"http://l.yimg.com/zz/combo?os/mit/media/p/content/other/my-topics-nav-min-1267768.css&os/mit/media/m/content_index/comic-desktop-min-1315714.css&os/mit/media/m/content_index/generic-listings-desktop-min-1311732.css\\\" /\\u003E\\n\\n\\u003Clink rel=\\\"stylesheet\\\" type=\\\"text/css\\\" href=\\\"http://l.yimg.com/zz/combo?os/mit/media/themes/v2_base/base-min-1145251.css&os/mit/media/themes/v2_base/base-imagery-min-1313085.css&os/mit/media/themes/v2_navyblue/theme-min-1340051.css&os/mit/media/themes/v2_navyblue/theme-imagery-min-1202855.css&os/mit/media/p/news/region/US-min-759849.css\\\" /\\u003E\\n\\n\\u003Cscript type=\\\"text/javascript\\\" src=\\\"http://l.yimg.com/zz/combo?yui:3.9.1/build/yui/yui-min.js&os/mit/media/p/common/rmp-min-1217643.js&os/mit/media/m/base/viewport-loader-min-1228633.js&ss/rapid-3.4.6.js\\\"\\u003E\\u003C/script\\u003E\\n\\u003Cscript\\u003Eif (!window.YAHOO) { window.YAHOO = {}; } if (!YAHOO.Media) { YAHOO.Media = {}; } if (!YAHOO.widget) { YAHOO.widget = {}; }\\u003C/script\\u003E\\n\\u003Cscript\\u003Eif (!window.YMedia) { var YMedia = YUI(); YMedia.includes = []; }\\u003C/script\\u003E\\n\\u003Cscript\\u003Ewindow.YMEDIA_REQ_ATTR = {device:{\\\"os\\\":\\\"mac os x\\\",\\\"osver\\\":\\\"10.8\\\"},instr:{request_id:\\\"20beee72-ba7b-48ae-b47d-afd6a8b221f3\\\",authfb:0},csbeacon:function() { if(! this._hasIssuedCsBeacon) { this._hasIssuedCsBeacon = true; if(typeof YAHOO === \\\"object\\\" && typeof YAHOO.i13n === \\\"object\\\" && typeof YAHOO.i13n.sendComscoreEvent === \\\"function\\\") {if(YAHOO.i13n.setEga){YAHOO.i13n.setEga(\\\"\\\");} if(YAHOO.i13n.setRdg){YAHOO.i13n.setRdg(\\\"-1\\\");} if(YAHOO.i13n.setSpaceid){YAHOO.i13n.setSpaceid(81121452);} YAHOO.i13n.sendComscoreEvent(); } } },_hasIssuedCsBeacon:false};\\u003C/script\\u003E\\u003Cnoscript\\u003E\\u003Cdiv\\u003E\\u003Cimg src=\\\"http://b.scorecardresearch.com/b?c1=2&c2=7241469&c7=news.yahoo.com%2F&c5=81121452&c15=$-1&cv=2.0&cj=1\\\" style=\\\"display:none\\\" width=\\\"0\\\" height=\\\"0\\\" alt=\\\"\\\" /\\u003E\\u003C/div\\u003E\\u003C/noscript\\u003E\\u003Cscript\\u003Ewindow.YMEDIA_CRUMB = \\\"XiIAUj5vwDC\\\";\\u003C/script\\u003E\\u003C!-- fe708.global.media.bf1.yahoo.com compressed Wed Jul 10 18:38:52 UTC 2013 --\\u003E\\n\\n\\u003Cscript\\u003EYUI.Env.add(window, 'unload', function() { try { YMEDIA_REQ_ATTR.csbeacon(); } catch (e) {} });\\u003C/script\\u003E\\n\\u003Cscript\\u003E\\n                                window.YAHOO = window.YAHOO || {};\\n                                window.YAHOO.i13n = window.YAHOO.i13n || {};\\n                                \\n                                YAHOO.i13n.YWA_CF_MAP = {\\\"ad\\\":58,\\\"authfb\\\":11,\\\"bpos\\\":24,\\\"cat\\\":25,\\\"cpos\\\":21,\\\"ct\\\":23,\\\"ft\\\":51,\\\"ltxt\\\":17,\\\"mrkt\\\":12,\\\"pct\\\":48,\\\"pd\\\":46,\\\"pkgt\\\":22,\\\"pos\\\":20,\\\"pstcat\\\":47,\\\"pt\\\":13,\\\"sca\\\":53,\\\"sec\\\":18,\\\"site\\\":42,\\\"slk\\\":19,\\\"sort\\\":28,\\\"test\\\":14,\\\"v\\\":52,\\\"ver\\\":49,\\\"x\\\":50};\\n                                YAHOO.i13n.YWA_ACTION_MAP = {\\\"click\\\":12,\\\"detecthpset\\\":10,\\\"expand\\\":9,\\\"hover\\\":17,\\\"hswipe\\\":19,\\\"key\\\":13,\\\"scrolldown\\\":16,\\\"scrollup\\\":15,\\\"secview\\\":18,\\\"shrink\\\":11,\\\"svct\\\":14};\\n                                YAHOO.i13n.YWA_OUTCOME_MAP = {\\\"abuse\\\":51,\\\"authview\\\":48,\\\"close\\\":34,\\\"comment\\\":49,\\\"connect\\\":36,\\\"cueauthview\\\":43,\\\"cueconnectview\\\":46,\\\"cuehpset\\\":50,\\\"cueinfoview\\\":45,\\\"cueloadview\\\":44,\\\"cueswipeview\\\":42,\\\"cuetop\\\":48,\\\"drag\\\":21,\\\"drop\\\":22,\\\"end\\\":31,\\\"entitydeclaration\\\":40,\\\"feedback\\\":37,\\\"fetch\\\":30,\\\"filter\\\":35,\\\"hpset\\\":27,\\\"insert\\\":28,\\\"interest\\\":51,\\\"itemdeclaration\\\":37,\\\"loadview\\\":49,\\\"login\\\":33,\\\"msgview\\\":47,\\\"navigate\\\":25,\\\"newview\\\":50,\\\"open\\\":29,\\\"reauthfb\\\":24,\\\"rmct\\\":32,\\\"setlayout\\\":38,\\\"share\\\":23,\\\"sort\\\":39,\\\"top\\\":26,\\\"undo\\\":41,\\\"vswipe\\\":20};\\n                                \\n                                YMedia.rapid = {\\n                                    rapidConfig: {\\\"spaceid\\\":\\\"81121452\\\",\\\"tracked_mods\\\":[\\\"mediacontentnavigation\\\",\\\"mediamoduletieheader\\\",\\\"mediacontentlead\\\",\\\"p_30345786\\\",\\\"mediaadsdmros\\\",\\\"mediacontentgenericlistings\\\",\\\"mediafooterinfo\\\"],\\\"text_link_len\\\":8,\\\"client_only\\\":1,\\\"compr_type\\\":\\\"deflate\\\",\\\"ult_token_capture\\\":true,\\\"webworker_file\\\":\\\"\\\\/rapid-worker.js\\\",\\\"test_id\\\":null,\\\"keys\\\":{\\\"x\\\":\\\"114\\\",\\\"juris\\\":\\\"US\\\",\\\"lang\\\":\\\"en-US\\\",\\\"mrkt\\\":\\\"US\\\",\\\"pcp\\\":\\\"\\\",\\\"pct\\\":\\\"\\\",\\\"pd\\\":\\\"\\\",\\\"pst\\\":\\\"\\\",\\\"pstaid\\\":\\\"5f01278b-803a-3803-9798-7fc79bab4f7d\\\",\\\"pstcat\\\":\\\"news\\\",\\\"pt\\\":\\\"2\\\",\\\"site\\\":\\\"news\\\",\\\"test\\\":\\\"\\\",\\\"ver\\\":\\\"grandslam\\\"},\\\"ywa\\\":{\\\"project_id\\\":\\\"10001393120079\\\",\\\"document_group\\\":\\\"\\\",\\\"document_name\\\":\\\"\\\",\\\"host\\\":\\\"y3.analytics.yahoo.com\\\"},\\\"nofollow_class\\\":[\\\"rapid-nf\\\",\\\"rapidnofollow\\\",\\\"yom-mod\\\",\\\"yog-nw\\\",\\\"yom-hero\\\",\\\"yom-tiles\\\",\\\"yom-menu\\\",\\\"yom-nav-tablet\\\",\\\"yom-card-main\\\",\\\"yom-lightbox\\\",\\\"yom-card-related\\\",\\\"yom-nlist\\\",\\\"yom-nlist-scroll\\\",\\\"yom-header\\\"]},\\n                                    rapidInstance: null,\\n                                    moduleQueue: [],\\n                                    addModules: function(modInfo) {\\n                                        this.moduleQueue.push(modInfo);\\n                                    }\\n                                };\\n                            \\u003C/script\\u003E\\n\\n\\t\\t\\u003Cscript language=\\\"javascript\\\"\\u003E\\n\\t\\t\\nYUI.YUICfg = {\\\"gallery\\\":\\\"gallery-2011.04.20-13-04\\\",\\\"groups\\\":{\\\"group01c9d8dea06e05460a64eed4dadd622b6\\\":{\\\"base\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/\\\",\\\"comboBase\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/zz\\\\/combo?\\\",\\\"modules\\\":{\\\"media-v2-chrome\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/p\\\\/presentation\\\\/v2-chrome-min-1335634.js\\\"},\\\"media-tracking\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/m\\\\/base\\\\/tracking-min-1154405.js\\\"},\\\"media-imageloader\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/m\\\\/base\\\\/imageloader-min-1277138.js\\\"},\\\"media-imageloader-bootstrap\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/m\\\\/base\\\\/imageloader-bootstrap-min-815727.js\\\"},\\\"media-rapid-tracking\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/p\\\\/common\\\\/rapid-tracking-min-1330602.js\\\"},\\\"media-header-uh3-desktop\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/m\\\\/header\\\\/header-uh3-desktop-min-1322619.js\\\"}},\\\"combine\\\":true,\\\"filter\\\":\\\"min\\\",\\\"root\\\":\\\"\\\\/\\\"}},\\\"combine\\\":true,\\\"allowRollup\\\":true,\\\"comboBase\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/zz\\\\/combo?\\\",\\\"maxURLLength\\\":\\\"2000\\\"}\\nYUI.YUICfg.root='yui:'+YUI.version+'/build/';\\nYMedia.applyConfig(YUI.YUICfg);\\nYUI.Env[YUI.version].groups.gallery.root = 'yui:gallery-2011.04.20-13-04/build/';\\nYMedia.use(\\\"media-rmp\\\",\\\"media-viewport-loader\\\",\\\"media-v2-chrome\\\",\\\"media-tracking\\\",\\\"node-base\\\",\\\"event-custom\\\",\\\"dom-deprecated\\\",\\\"node-deprecated\\\",\\\"substitute\\\",\\\"media-imageloader\\\",\\\"media-imageloader-bootstrap\\\",\\\"base-base\\\",\\\"node-style\\\",\\\"node-screen\\\",\\\"media-rapid-tracking\\\",\\\"base\\\",\\\"node\\\",\\\"media-header-uh3-desktop\\\",\\\"intl\\\",function(Y){\\n    \\t  \\n    Y.later(10, this, function() {Y.applyConfig({debug: false});});\\n    Y.later(10, this, function() {\\n                YUI.namespace(\\\"Media\\\").LANGDIR='ltr';\\n                YUI.namespace(\\\"Media\\\").CONTENT_ID = \\\"5f01278b-803a-3803-9798-7fc79bab4f7d\\\";\\n                });\\n    Y.later(10, this, function() {if (Y.Media && Y.Media.Chrome) {\\n                    Y.Media.pageChrome = Y.Media.Chrome(Y, \\n                    {\\n                        site: 'news',\\n                        lang: 'en-US',\\n                        region: 'US',\\n                        spaceId: '81121452',\\n                        contentId: '5f01278b-803a-3803-9798-7fc79bab4f7d',\\n                        gridType: 'index',\\n                        device: 'full',\\n                        deviceOS: (YMEDIA_REQ_ATTR && YMEDIA_REQ_ATTR.device && YMEDIA_REQ_ATTR.device.os) || '',\\n                        deviceOSVer: (YMEDIA_REQ_ATTR && YMEDIA_REQ_ATTR.device && YMEDIA_REQ_ATTR.device.osver) || '',\\n                        projectId: '10001393120079',\\n                        enableYwaTracking: '0',\\n                        enable2xImgs: '0',\\n                        imgItemsSelector: '.js .yog-bd img',\\n                        enableViewportManagement: '0',\\n                        viewportItemsSelector: '.js .yog-content img,.yog-smartphone.js .yog-bd img',\\n                        transparentImgUrl: 'http://l.yimg.com/os/mit/media/m/base/images/transparent-1093278.png',\\n                        enableRapidTracking: 1,\\n                        rapidConf : {\\\"spaceid\\\":\\\"81121452\\\",\\\"tracked_mods\\\":[\\\"mediacontentnavigation\\\",\\\"mediamoduletieheader\\\",\\\"mediacontentlead\\\",\\\"p_30345786\\\",\\\"mediaadsdmros\\\",\\\"mediacontentgenericlistings\\\",\\\"mediafooterinfo\\\"],\\\"text_link_len\\\":8,\\\"client_only\\\":1,\\\"compr_type\\\":\\\"deflate\\\",\\\"ult_token_capture\\\":true,\\\"webworker_file\\\":\\\"\\\\/rapid-worker.js\\\",\\\"test_id\\\":null,\\\"keys\\\":{\\\"x\\\":\\\"114\\\",\\\"juris\\\":\\\"US\\\",\\\"lang\\\":\\\"en-US\\\",\\\"mrkt\\\":\\\"US\\\",\\\"pcp\\\":\\\"\\\",\\\"pct\\\":\\\"\\\",\\\"pd\\\":\\\"\\\",\\\"pst\\\":\\\"\\\",\\\"pstaid\\\":\\\"5f01278b-803a-3803-9798-7fc79bab4f7d\\\",\\\"pstcat\\\":\\\"news\\\",\\\"pt\\\":\\\"2\\\",\\\"site\\\":\\\"news\\\",\\\"test\\\":\\\"\\\",\\\"ver\\\":\\\"grandslam\\\"},\\\"ywa\\\":{\\\"project_id\\\":\\\"10001393120079\\\",\\\"document_group\\\":\\\"\\\",\\\"document_name\\\":\\\"\\\",\\\"host\\\":\\\"y3.analytics.yahoo.com\\\"},\\\"nofollow_class\\\":[\\\"rapid-nf\\\",\\\"rapidnofollow\\\",\\\"yom-mod\\\",\\\"yog-nw\\\",\\\"yom-hero\\\",\\\"yom-tiles\\\",\\\"yom-menu\\\",\\\"yom-nav-tablet\\\",\\\"yom-card-main\\\",\\\"yom-lightbox\\\",\\\"yom-card-related\\\",\\\"yom-nlist\\\",\\\"yom-nlist-scroll\\\",\\\"yom-header\\\"]},\\n                        bucketId : '',\\n                        baseImageryFallbackCss : 'http://l.yimg.com/os/mit/media/themes/v2_base/base-imagery-fallback-min-1313085.css',\\n                        baseImageryFallbackCssLteIe7 : 'http://l.yimg.com/os/mit/media/themes/v2_base/base-imagery-fallback-lteIE7-min-1313085.css'\\n                    });\\n                };});\\n    Y.later(10, this, function() {Y.on('domready', function() { \\n                                            DOMIMG = new Image(); \\n                                            DOMIMG.src = 'http://geo.yahoo.com/p?s=81121452&pt=2&test=nacelle&btype=dom&t='+Math.random(); \\n                                        });});\\n    Y.later(10, this, function() {Y.namespace(\\\"Global.Media\\\").ILBoot = new Y.ImageLoaderBootstrap(200);});\\n    Y.later(10, this, function() {// create RapidTracking object reusing existing moduleQueue\\n                            YMedia.rapid = new Y.Media.RapidTracking({\\n                                instance:    YMedia.rapid && YMedia.rapid.rapidInstance,\\n                                moduleQueue: YMedia.rapid && YMedia.rapid.moduleQueue,\\n                                rapidConfig: YMedia.rapid && YMedia.rapid.rapidConfig,\\n                                config: { \\n                                    selectors: {\\n                                        'bd'   : '#yog-bd',\\n                                        'mods' : '.yom-mod'\\n                                    }\\n                                }\\n                            });});\\n    Y.later(10, this, function() {if(Y.Media.HeaderUH3)Y.Media.HeaderUH3(Y);});\\n\\t\\t   \\n});\\n\\n\\t\\t\\n\\t    \\u003C/script\\u003E\\n\\n        \\n\\u003Cscript type=\\\"text/javascript\\\"\\u003Eif(typeof rt_pushMoment!=='undefined')rt_pushMoment(\\\"t1\\\");\\u003C/script\\u003E\\n        \\u003Cscript\\u003Evar t_headend=new Date().getTime();\\u003C/script\\u003E\\n    \\u003C/head\\u003E\\n    \\u003Cbody id=\\\"yog-body\\\" dir=\\\"ltr\\\" class=\\\"no-js yog-type-index yog-full yog-version-v2 yog-ltr yuac-fixedpos-1 yuac-svg-1\\\"\\u003E\\n        \\u003Cscript type=\\\"text/javascript\\\"\\u003Edocument.body.className = document.body.className.replace('no-js', 'js'); document.body.offsetHeight;\\u003C/script\\u003E\\n        \\u003Cdiv id=\\\"yog-page\\\" class=\\\"yog-page\\\"\\u003E\\n            \\u003Cheader id=\\\"yog-hd\\\" class=\\\"yog-hd\\\"\\u003E\\n                \\n                \\u003Csection id=\\\"header\\\" class=\\\"yom-mod yom-header yom-header-property-0\\\" role=\\\"banner\\\"\\u003E\\u003Clink rel=\\\"stylesheet\\\" type=\\\"text/css\\\" href=\\\"http://l.yimg.com/zz/combo?kx/yucs/uh3/uh/css/599/uh_non_mail-min.css&kx/yucs/uh3/uh3_top_bar/css/224/no_icons-min.css&kx/yucs/uh3/search/css/357/blue_border-min.css\\\"/\\u003E\\n\\n\\u003Cstyle\\u003E#header,#yucs,#y-hd,#hd .yfi_doc,#yfi_hd{background:#fff !important}#yog-hd,#yfi-hd,#ysp-hd,#hd,#yfimh,#yfi_hd,#yfi_fp_hd,#masthead,#yfi_nav_header #navigation,#y-nav #navigation,.ad_in_head{background-color:#fff;background-image:none}#header,#hd .yfi_doc,#y-hd .yfi_doc,#yfi_hd .yfi_doc{width:100% !important}#yucs{margin:0 auto;width:970px}#yfi_nav_header,.y-nav-legobg,#y-nav #navigation{margin:0 auto;width:970px}#yucs .yucs-avatar{height:22px;width:22px}#yucs #yucs-profile_text .yuhead-name-greeting{display:none}#yucs #yucs-profile_text .yuhead-name{top:0;max-width:65px}#yucs-profile_text{max-width:65px}#yog-bd .yom-stage{background:transparent}#yog-hd{height:84px}.yog-bd,.yog-grid{padding:4px 10px}#yucs #yucs-search .yucs-button_theme{background:-moz-linear-gradient(top, #26376a 0, #192446 100%);background:-webkit-gradient(linear, left top, left bottom, color-stop(0%, #26376a), color-stop(100%, #192446));background:-webkit-linear-gradient(top, #26376a 0, #192446 100%);background:-o-linear-gradient(top, #26376a 0, #192446 100%);background:-ms-linear-gradient(top, #26376a 0, #192446 100%);background:linear-gradient(to bottom, #26376a 0, #192446 100%);-webkit-box-shadow:inset 0 1px 3px 0 #3f5baf;box-shadow:inset 0 1px 3px 0 #3f5baf;background-color:#2f477a;background-color:transparent\\\\0/IE9;background-color:transparent\\\\9;*background:none;border:1px solid #152756}#yucs #yucs-search #yucs-prop_search_button_wrapper .yucs-gradient{filter:progid:DXImageTransform.Microsoft.gradient(startColorstr='#26376a', endColorstr='#192446',GradientType=0 );-ms-filter:\\\"progid:DXImageTransform.Microsoft.gradient( startColorstr='#26376a', endColorstr='#192446',GradientType=0 )\\\";background-color:#2f477a\\\\0/IE9}#yucs #yucs-search #yucs-prop_search_button_wrapper{*border:1px solid #152756}\\u003C/style\\u003E\\u003Cstyle\\u003E#yog-hd .yom-bar, #yog-hd .yom-nav, #y-nav, #hd .ysp-full-bar,  #yfi_nav_header, #hd .mast {\\r\\nfloat: none;\\r\\nwidth: 970px;\\r\\nmargin: 0 auto;\\r\\n}\\r\\n\\r\\n#yog-bd .yom-stage {\\r\\nbackground: transparent;\\r\\n}\\r\\n\\r\\n#y-nav .yom-nav {\\r\\npadding-top: 0px;\\r\\n}\\r\\n\\r\\n#ysp-search-assist .bd {\\r\\ndisplay:none;\\r\\n}\\r\\n\\r\\n#ysp-search-assist h4 {\\r\\npadding-left: 8px;\\r\\n}\\r\\n\\r\\n\\r\\n    #yfi-portfolios-multi-quotes #y-nav, #yfi-portfolios-multi-quotes #navigation, #yfi-portfolios-multi-quotes .y-nav-legobg, \\r\\n    #yfi-portfolios-my-portfolios #y-nav, #yfi-portfolios-my-portfolios #navigation, #yfi-portfolios-my-portfolios .y-nav-legobg {\\r\\n        width : 100%;\\r\\n    }\\u003C/style\\u003E\\u003Cdiv id=\\\"yucsHead\\\" class=\\\"yucs-news yucs-en-us \\\"\\u003E\\u003Cdiv id=\\\"yucs-top-bar\\\" class='yucs-ps'\\u003E    \\u003Cdiv id='yucs-top-inner'\\u003E        \\u003Cul id='yucs-top-list'\\u003E            \\u003Cli id='yucs-top-home'\\u003E\\u003Ca href=\\\"http://us.lrd.yahoo.com/_ylt=AihO6TuCu4AmWEPbX0j8zfes0NUE;_ylu=X3oDMTBzdWkzZ2l1BHNlYwNVSCAzIERlc2t0b3AgVG9wIEJhciAxMDA-;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--;_ylv=0/SIG=119jpksvl/EXP=1374691132/**http%3A//www.yahoo.com/\\\"\\u003E\\u003Cspan class=\\\"sp yucs-top-ico\\\"\\u003E\\u003C/span\\u003EHome\\u003C/a\\u003E\\u003C/li\\u003E            \\u003Cli id='yucs-top-mail'\\u003E\\u003Ca href=\\\"http://mail.yahoo.com/;_ylt=AnEmD3Uup5ZNAmmYIYZBzH.s0NUE;_ylu=X3oDMTBzdWkzZ2l1BHNlYwNVSCAzIERlc2t0b3AgVG9wIEJhciAxMDA-;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--;_ylv=3\\\"\\u003EMail\\u003C/a\\u003E\\u003C/li\\u003E            \\u003Cli id='yucs-top-news'\\u003E\\u003Ca href=\\\"http://news.yahoo.com/;_ylt=ApcW0T4vzALzYweIi1Ta2p6s0NUE;_ylu=X3oDMTBzdWkzZ2l1BHNlYwNVSCAzIERlc2t0b3AgVG9wIEJhciAxMDA-;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--;_ylv=3\\\"\\u003ENews\\u003C/a\\u003E\\u003C/li\\u003E            \\u003Cli id='yucs-top-sports'\\u003E\\u003Ca href=\\\"http://sports.yahoo.com/;_ylt=AqaghSmliBZKLd8NthSpl76s0NUE;_ylu=X3oDMTBzdWkzZ2l1BHNlYwNVSCAzIERlc2t0b3AgVG9wIEJhciAxMDA-;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--;_ylv=3\\\"\\u003ESports\\u003C/a\\u003E\\u003C/li\\u003E            \\u003Cli id='yucs-top-finance'\\u003E\\u003Ca href=\\\"http://finance.yahoo.com/;_ylt=AgIGs1jJIrZOoXEYDHNYYqqs0NUE;_ylu=X3oDMTBzdWkzZ2l1BHNlYwNVSCAzIERlc2t0b3AgVG9wIEJhciAxMDA-;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--;_ylv=3\\\"\\u003EFinance\\u003C/a\\u003E\\u003C/li\\u003E            \\u003Cli id='yucs-top-weather'\\u003E\\u003Ca href=\\\"http://weather.yahoo.com/;_ylt=AjL4PX3EGHiEzIpnDgqgwYqs0NUE;_ylu=X3oDMTBzdWkzZ2l1BHNlYwNVSCAzIERlc2t0b3AgVG9wIEJhciAxMDA-;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--;_ylv=3\\\"\\\"\\u003EWeather\\u003C/a\\u003E\\u003C/li\\u003E            \\u003Cli id='yucs-top-games'\\u003E\\u003Ca href=\\\"http://games.yahoo.com/;_ylt=Aj6Ow3_.1C8Ku21vl3XzqdKs0NUE;_ylu=X3oDMTBzdWkzZ2l1BHNlYwNVSCAzIERlc2t0b3AgVG9wIEJhciAxMDA-;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--\\\"\\u003EGames\\u003C/a\\u003E\\u003C/li\\u003E            \\u003Cli id='yucs-top-groups'\\u003E\\u003Ca href=\\\"http://us.lrd.yahoo.com/_ylt=AiULD2o.fRwQUq22RV2S4Aas0NUE;_ylu=X3oDMTBzdWkzZ2l1BHNlYwNVSCAzIERlc2t0b3AgVG9wIEJhciAxMDA-;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--;_ylv=0/SIG=11c3u1b2c/EXP=1374691132/**http%3A//groups.yahoo.com/\\\"\\u003EGroups\\u003C/a\\u003E\\u003C/li\\u003E            \\u003Cli id='yucs-top-answers'\\u003E\\u003Ca href=\\\"http://answers.yahoo.com/;_ylt=Agy1.W1tuppU1eDE0pVfS9ys0NUE;_ylu=X3oDMTBzdWkzZ2l1BHNlYwNVSCAzIERlc2t0b3AgVG9wIEJhciAxMDA-;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--;_ylv=3\\\"\\u003EAnswers\\u003C/a\\u003E\\u003C/li\\u003E            \\u003Cli id='yucs-top-flickr'\\u003E\\u003Ca href=\\\"http://us.lrd.yahoo.com/_ylt=AtOsIdBfV9aFn0ZW63qpdTSs0NUE;_ylu=X3oDMTBzdWkzZ2l1BHNlYwNVSCAzIERlc2t0b3AgVG9wIEJhciAxMDA-;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--;_ylv=0/SIG=11ac5nkej/EXP=1374691132/**http%3A//www.flickr.com/\\\"\\u003EFlickr\\u003C/a\\u003E\\u003C/li\\u003E            \\u003Cli id='yucs-more' class='yucs-menu yucs-more-activate' data-ylt=\\\"/;_ylt=Aq_5I.IScRw3VWdJx3J.txWs0NUE;_ylu=X3oDMTBzdWkzZ2l1BHNlYwNVSCAzIERlc2t0b3AgVG9wIEJhciAxMDA-;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--;_ylv=3\\\"\\u003E\\u003Ca href=\\\"http://us.lrd.yahoo.com/_ylt=AoTAQhWgqXSR.kFG_c2rnB.s0NUE;_ylu=X3oDMTBzdWkzZ2l1BHNlYwNVSCAzIERlc2t0b3AgVG9wIEJhciAxMDA-;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--;_ylv=0/SIG=11gp6s1ge/EXP=1374691132/**http%3A//everything.yahoo.com/\\\" id='yucs-more-link' class='yucs-leavable'\\u003EMore\\u003Cspan class=\\\"sp yucs-top-ico\\\"\\u003E\\u003C/span\\u003E\\u003C/a\\u003E                \\u003Cdiv id='yucs-top-menu'\\u003E                    \\u003Cdiv class='yui3-menu-content'\\u003E                        \\u003Cul class='yucs-hide yucs-leavable'\\u003E                            \\u003Cli id='yucs-top-omg'\\u003E\\u003Ca href=\\\"http://omg.yahoo.com/;_ylt=AklsB9PqkFO6e.N3eqvBVEOs0NUE;_ylu=X3oDMTBzdWkzZ2l1BHNlYwNVSCAzIERlc2t0b3AgVG9wIEJhciAxMDA-;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--;_ylv=3\\\"\\u003Eomg!\\u003C/a\\u003E\\u003C/li\\u003E                            \\u003Cli id='yucs-top-shine'\\u003E\\u003Ca href=\\\"http://shine.yahoo.com/;_ylt=AvTQH0UnGfU5FsNgdxOUycCs0NUE;_ylu=X3oDMTBzdWkzZ2l1BHNlYwNVSCAzIERlc2t0b3AgVG9wIEJhciAxMDA-;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--;_ylv=3\\\"\\u003EShine\\u003C/a\\u003E\\u003C/li\\u003E                            \\u003Cli id='yucs-top-movies'\\u003E\\u003Ca href=\\\"http://us.lrd.yahoo.com/_ylt=Ashumn8Vxai54rdBU5I877.s0NUE;_ylu=X3oDMTBzdWkzZ2l1BHNlYwNVSCAzIERlc2t0b3AgVG9wIEJhciAxMDA-;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--;_ylv=0/SIG=11c6nvig4/EXP=1374691132/**http%3A//movies.yahoo.com/\\\"\\u003EMovies\\u003C/a\\u003E\\u003C/li\\u003E                            \\u003Cli id='yucs-top-music'\\u003E\\u003Ca href=\\\"http://us.lrd.yahoo.com/_ylt=AsLJTC4.JAk6q8sFqzydE26s0NUE;_ylu=X3oDMTBzdWkzZ2l1BHNlYwNVSCAzIERlc2t0b3AgVG9wIEJhciAxMDA-;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--;_ylv=0/SIG=11b1o0h0s/EXP=1374691132/**http%3A//music.yahoo.com/\\\"\\u003EMusic\\u003C/a\\u003E\\u003C/li\\u003E                            \\u003Cli id='yucs-top-tv'\\u003E\\u003Ca href=\\\"http://us.lrd.yahoo.com/_ylt=Ap0GZ4chYya4U_etLbska8ms0NUE;_ylu=X3oDMTBzdWkzZ2l1BHNlYwNVSCAzIERlc2t0b3AgVG9wIEJhciAxMDA-;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--;_ylv=0/SIG=118n1ctka/EXP=1374691132/**http%3A//tv.yahoo.com/\\\"\\u003ETV\\u003C/a\\u003E\\u003C/li\\u003E                            \\u003Cli id='yucs-top-health'\\u003E\\u003Ca href=\\\"http://us.lrd.yahoo.com/_ylt=AkZ95lvn1KQ1oIxgAkumP4as0NUE;_ylu=X3oDMTBzdWkzZ2l1BHNlYwNVSCAzIERlc2t0b3AgVG9wIEJhciAxMDA-;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--;_ylv=0/SIG=11ccqta2t/EXP=1374691132/**http%3A//health.yahoo.com/\\\"\\u003EHealth\\u003C/a\\u003E\\u003C/li\\u003E                            \\u003Cli id='yucs-top-shopping'\\u003E\\u003Ca href=\\\"http://shopping.yahoo.com/;_ylt=Ag6WH5l1_adRiRzu3yA4p3Gs0NUE;_ylu=X3oDMTBzdWkzZ2l1BHNlYwNVSCAzIERlc2t0b3AgVG9wIEJhciAxMDA-;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--\\\"\\u003EShopping\\u003C/a\\u003E\\u003C/li\\u003E                            \\u003Cli id='yucs-top-travel'\\u003E\\u003Ca href=\\\"http://travel.yahoo.com/;_ylt=AtBHxQBstpfcpZT1j6qZNxis0NUE;_ylu=X3oDMTBzdWkzZ2l1BHNlYwNVSCAzIERlc2t0b3AgVG9wIEJhciAxMDA-;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--\\\"\\u003ETravel\\u003C/a\\u003E\\u003C/li\\u003E                            \\u003Cli id='yucs-top-autos'\\u003E\\u003Ca href=\\\"http://autos.yahoo.com/;_ylt=Aqgfl6zsZaSPH2oGJvpFk6Os0NUE;_ylu=X3oDMTBzdWkzZ2l1BHNlYwNVSCAzIERlc2t0b3AgVG9wIEJhciAxMDA-;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--\\\"\\u003EAutos\\u003C/a\\u003E\\u003C/li\\u003E                            \\u003Cli id='yucs-top-homes'\\u003E\\u003Ca href=\\\"http://us.lrd.yahoo.com/_ylt=AvW3XtXTaHTsNTLj2pcabS2s0NUE;_ylu=X3oDMTBzdWkzZ2l1BHNlYwNVSCAzIERlc2t0b3AgVG9wIEJhciAxMDA-;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--;_ylv=0/SIG=11kvk4q0p/EXP=1374691132/**http%3A//homes.yahoo.com/own-rent/\\\"\\u003EHomes\\u003C/a\\u003E\\u003C/li\\u003E                        \\u003C/ul\\u003E                    \\u003C/div\\u003E                \\u003C/div\\u003E            \\u003C/li\\u003E        \\u003C/ul\\u003E    \\u003C/div\\u003E\\u003C/div\\u003E\\u003Cdiv id=\\\"yucs\\\" class=\\\"yucs-mc \\\" data-lang=\\\"en-us\\\" data-property=\\\"news\\\" data-flight=\\\"1373481532\\\" data-linktarget=\\\"_top\\\" data-uhvc=\\\"/;_ylt=Au3riQ87E9MURRJao7.O._ms0NUE;_ylu=X3oDMTBsMTFvc2NjBHNlYwNVSCBWaWV3IENvdW50IDEwMA--;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--;_ylv=3\\\"\\u003E        \\u003Cdiv class=\\\"yucs-fl-left\\\"\\u003E                \\u003Cdiv id=\\\"yucs-logo\\\"\\u003E    \\u003Cstyle\\u003E        #yucs #yucs-logo {width:123px ;}         #yucs #yucs-logo h2 {            width:123px;            height:36px ;            background-image:url(http://l.yimg.com/rz/uh/logos/news/news-20130429.png) ;            _background-image:url(http://l.yimg.com/rz/uh/logos/news/news-20130429.gif) ;        }        #yucs #yucs-logo a {          display:block ;          width:123px ;          height:36px;          overflow: hidden;        }        @media        only screen and (-webkit-min-device-pixel-ratio: 2),        only screen and ( min--moz-device-pixel-ratio: 2),        only screen and ( -o-min-device-pixel-ratio: 2/1),        only screen and ( min-device-pixel-ratio: 2),        only screen and ( min-resolution: 192dpi),        only screen and ( min-resolution: 2dppx) {            #yucs #yucs-logo h2 {                background-image: url(http://l.yimg.com/rz/uh/logos/news/news-20130429-x2.png) !important;                background-size: 275px 120px;            }        }    \\u003C/style\\u003E    \\u003Ch2\\u003E        \\u003Ca id=\\\"yucs-logo_link\\\" href=\\\"http://news.yahoo.com/;_ylt=As23q1QO_74ygHZ9x.QMHVys0NUE;_ylu=X3oDMTE1NnJlMDc0BHNlYwNVSCAzIERlc2t0b3AgQnJhbmQgSWRlbnRpZmllciAxMDA-;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--;_ylv=3\\\"           target=\\\"_top\\\"\\u003E          Yahoo! News        \\u003C/a\\u003E    \\u003C/h2\\u003E\\u003C/div\\u003E    \\u003Cdiv id=\\\"yucs-search\\\"  style=\\\"width: 570px; display: block;\\\" class=' yucs-search-activate'\\u003E    \\u003Cform role=\\\"search\\\" class=\\\"yucs-search yucs-activate\\\" target=\\\"_top\\\"        data-webaction=\\\"http://search.yahoo.com/search;_ylt=AgGxq8uK6_ec7ngXdZg.Yres0NUE;_ylu=X3oDMTBwNm1oMDIxBHNlYwNVSCAzIERlc2t0b3AgU2VhcmNoIDE-;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--;_ylv=3\\\"        action=\\\"http://news.search.yahoo.com/search;_ylt=AvN6d8RpQ8iZioTtHCkDtt6s0NUE;_ylu=X3oDMTBwNm1oMDIxBHNlYwNVSCAzIERlc2t0b3AgU2VhcmNoIDE-;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--\\\"        method=\\\"get\\\"\\u003E        \\u003Ctable role=\\\"presentation\\\"\\u003E            \\u003Ctbody role=\\\"presentation\\\"\\u003E                \\u003Ctr role=\\\"presentation\\\"\\u003E                    \\u003Ctd class=\\\"yucs-form-input\\\" role=\\\"presentation\\\"\\u003E                        \\u003Cinput autocomplete=\\\"off\\\" class=\\\"yucs-search-input\\\" name=\\\"p\\\" type=\\\"search\\\"                            aria-describedby=\\\"mnp-search_box\\\"                            data-yltvsearch=\\\"http://news.search.yahoo.com/search;_ylt=AqN6kQCdNENIYsXMO7dgcFis0NUE;_ylu=X3oDMTBwNm1oMDIxBHNlYwNVSCAzIERlc2t0b3AgU2VhcmNoIDE-;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--\\\"                            data-yltvsearchsugg=\\\"/;_ylt=Aqeac4X3cMGhSIr5Wh3T9lOs0NUE;_ylu=X3oDMTBwNm1oMDIxBHNlYwNVSCAzIERlc2t0b3AgU2VhcmNoIDE-;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--;_ylv=3\\\"                            data-satype=\\\"mini\\\"                            data-gosurl=\\\"http://gossip-ss.us.search.yahoo.com/gossip-us_ss/\\\"                            data-pubid=\\\"104\\\"                            data-maxresults=\\\"10\\\"                            id=\\\"mnp-search_box\\\" /\\u003E                    \\u003C/td\\u003E\\u003Ctd NOWRAP class=\\\"yucs-form-btn\\\" role=\\\"presentation\\\"\\u003E\\u003Cdiv id=\\\"yucs-prop_search_button_wrapper\\\" class=\\\"yucs-search-buttons\\\"\\u003E\\u003Cdiv class=\\\"yucs-shadow\\\"\\u003E\\u003Cdiv class=\\\"yucs-gradient\\\"\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003Cbutton id=\\\"yucs-sprop_button\\\" class=\\\"yucs-action_btn yucs-button_theme yucs-vsearch-button\\\" type=\\\"submit\\\"                            data-vfr=\\\"us_news_header_gs_uh3_vert\\\"                            data-vsearch=\\\"http://news.search.yahoo.com/search\\\"\\u003ESearch News\\u003C/button\\u003E\\u003C/div\\u003E\\u003Cdiv id=\\\"yucs-web_search_button_wrapper\\\" class=\\\"yucs-search-buttons\\\"\\u003E\\u003Cdiv class=\\\"yucs-shadow\\\"\\u003E\\u003Cdiv class=\\\"yucs-gradient\\\"\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003Cbutton id=\\\"yucs-search_button\\\"                            class=\\\"yucs-action_btn yucs-wsearch-button\\\"                            type=\\\"submit\\\"\\u003ESearch Web\\u003C/button\\u003E\\u003C/div\\u003E\\u003C/td\\u003E\\u003C/tr\\u003E            \\u003C/tbody\\u003E    \\u003C/table\\u003E    \\u003Cinput type=\\\"hidden\\\" name=\\\"type\\\" value=\\\"2button\\\" /\\u003E    \\u003Cinput type=\\\"hidden\\\" id=\\\"fr\\\" name=\\\"fr\\\" value=\\\"us_news_header_gs_uh3_web\\\" /\\u003E            \\u003C/form\\u003E    \\u003Cdiv id=\\\"yucs-satray\\\" class=\\\"sa-tray sa-hidden\\\"        data-wstext=\\\"Search Web for: \\\"        data-wsearch=\\\"http://search.yahoo.com/search;_ylt=AuxDR8Djj8wtsCmx6.h3zOys0NUE;_ylu=X3oDMTBwNm1oMDIxBHNlYwNVSCAzIERlc2t0b3AgU2VhcmNoIDE-;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--;_ylv=3\\\"        data-vfr=\\\"us_news_header_gs_uh3_vert\\\"        data-vsearch=\\\"http://news.search.yahoo.com/search;_ylt=AkMULUjkIRe5UZD0DK70Vles0NUE;_ylu=X3oDMTBwNm1oMDIxBHNlYwNVSCAzIERlc2t0b3AgU2VhcmNoIDE-;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--\\\"        data-vstext= \\\"Search News for: \\\"        \\u003E    \\u003C/div\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"yucs-fl-right\\\"\\u003E  \\u003Cdiv id=\\\"yucs-profile\\\" class=\\\"yucs-profile yucs-signedout\\\"\\u003E    \\u003Ca id=\\\"yucs-menu_link_profile_signed_out\\\" href=\\\"http://jsbngssl.login.yahoo.com/config/login;_ylt=Am8_9FmE6Dgdlv7JqoCdHJas0NUE;_ylu=X3oDMTExZ2JhaGd1BHNlYwNVSCAzIERlc2t0b3AgUHJvZmlsZSBNZW51IDEwMA--;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--;_ylv=3?.src=yn&.intl=us&.lang=en-US&.done=http://news.yahoo.com/\\\"  target=\\\"_top\\\" rel=\\\"nofollow\\\" class=\\\"sp yucs-fc\\\" aria-label=\\\"Profile\\\"\\u003E    \\u003C/a\\u003E    \\u003Cdiv id=\\\"yucs-profile_text\\\" class=\\\"yucs-fc\\\"\\u003E        \\u003Ca id=\\\"yucs-login_signIn\\\" href=\\\"http://jsbngssl.login.yahoo.com/config/login;_ylt=AvwU2ec_GDu70kAa.pMkaoqs0NUE;_ylu=X3oDMTExZ2JhaGd1BHNlYwNVSCAzIERlc2t0b3AgUHJvZmlsZSBNZW51IDEwMA--;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--;_ylv=3?.src=yn&.intl=us&.lang=en-US&.done=http://news.yahoo.com/\\\"  target=\\\"_top\\\" rel=\\\"nofollow\\\" class=\\\"yucs-fc\\\"\\u003E            Sign In        \\u003C/a\\u003E    \\u003C/div\\u003E\\u003C/div\\u003E  \\u003Cdiv class=\\\"yucs-mail_link yucs-mailpreview-ancestor\\\"\\u003E\\u003Ca id=\\\"yucs-mail_link_id\\\" class=\\\"sp yltasis yucs-fc\\\" href=\\\"http://mail.yahoo.com/;_ylt=AohpZ7..F8A6KkneOl5DhpWs0NUE;_ylu=X3oDMTB1cWVlMWZyBHNlYwNVSCAzIERlc2t0b3AgTWFpbCBJY29uIDEwMA--;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--;_ylv=3?.intl=us&.lang=en-US\\\" rel=\\\"nofollow\\\" target=\\\"_top\\\"\\u003E    Mail    \\u003C/a\\u003E\\u003Cdiv class=\\\"yucs-mail-preview-panel yucs-menu yucs-hide\\\" data-mail-txt=\\\"Mail\\\"    data-uri-scheme=\\\"http\\\"     data-uri-path=\\\"ucs.query.yahoo.com/v1/console/yql\\\"     data-mail-view=\\\"Go to Mail\\\"    data-mail-help-txt=\\\"Help\\\"    data-mail-help-url=\\\"http://help.yahoo.com/l/us/yahoo/mail/ymail/\\\"    data-mail-loading-txt=\\\"Loading...\\\"    data-languagetag=\\\"en-us\\\"    data-authstate=\\\"signedout\\\"    data-middleauth-signin-text=\\\"Click here to view your mail\\\"    data-popup-login-url=\\\"http://jsbngssl.login.yahoo.com/config/login_verify2?.pd=c%3DOIVaOGq62e5hAP8Tv..nr5E3&.src=sc\\\"    data-middleauthtext=\\\"You have {count} new mail.\\\"    data-yltmessage-link=\\\"http://us.lrd.yahoo.com/_ylt=AgTeUpmoviH2RUcx7ZjJKS.s0NUE;_ylu=X3oDMTB1cWVlMWZyBHNlYwNVSCAzIERlc2t0b3AgTWFpbCBJY29uIDEwMA--;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--;_ylv=0/SIG=12fb6ui49/EXP=1374691132/**http%3A//mrd.mail.yahoo.com/msg%3Fmid=%7BmsgID%7D%26fid=Inbox\\\"    data-yltviewall-link=\\\"http://mail.yahoo.com/;_ylt=AuHgKHMcjzpPW9qzZZS2OaWs0NUE;_ylu=X3oDMTB1cWVlMWZyBHNlYwNVSCAzIERlc2t0b3AgTWFpbCBJY29uIDEwMA--;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--;_ylv=3\\\"    data-yltpanelshown=\\\"/;_ylt=AtJh1xg9pqJrZSiBptRXoFms0NUE;_ylu=X3oDMTB1cWVlMWZyBHNlYwNVSCAzIERlc2t0b3AgTWFpbCBJY29uIDEwMA--;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--;_ylv=3\\\"    data-ylterror=\\\"/;_ylt=AiwoW0tDcwf9yEK4G4eiCPOs0NUE;_ylu=X3oDMTB1cWVlMWZyBHNlYwNVSCAzIERlc2t0b3AgTWFpbCBJY29uIDEwMA--;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--;_ylv=3\\\"    data-ylttimeout=\\\"/;_ylt=ArIbXBrY_dRyY.XOzzzHseGs0NUE;_ylu=X3oDMTB1cWVlMWZyBHNlYwNVSCAzIERlc2t0b3AgTWFpbCBJY29uIDEwMA--;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--;_ylv=3\\\"    data-generic-error=\\\"We're unable to preview your mail.\\u003Cbr\\u003EGo to Mail.\\\"    data-nosubject=\\\"[No Subject]\\\"    data-timestamp='short'\\u003E\\u003C/div\\u003E\\u003C/div\\u003E    \\u003C!-- notification --\\u003E    \\u003Cdiv id=\\\"yucs-help\\\" class=\\\"yucs-activate yucs-help yucs-menu_nav\\\"\\u003E    \\u003Ca id=\\\"yucs-help_button\\\" class=\\\"sp yltasis\\\"         href=\\\"javascript:void(0);\\\"        aria-label=\\\"Help\\\" rel=\\\"nofollow\\\"\\u003E        \\u003Cem class=\\\"yucs-hide yucs-menu_anchor\\\"\\u003EHelp\\u003C/em\\u003E    \\u003C/a\\u003E    \\u003Cdiv id=\\\"yucs-help_inner\\\" class=\\\"yucs-hide yucs-menu yucs-hm-activate\\\"          data-yltmenushown=\\\"/;_ylt=AlJrVc3oSU7q2_lCoFU.gY6s0NUE;_ylu=X3oDMTB0b2V0ZGxzBHNlYwNVSCAzIERlc2t0b3AgQ29nIE1lbnUgMTAw;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--;_ylv=3\\\"\\u003E        \\u003Cspan class=\\\"sp yucs-dock\\\"\\u003E\\u003C/span\\u003E        \\u003Cul id=\\\"yuhead-help-panel\\\"\\u003E            \\u003Cli\\u003E\\u003Ca class=\\\"yucs-acct-link\\\" href=\\\"http://jsbngssl.us.lrd.yahoo.com/_ylt=AklNNGH.9TJkYGzy4JXrulOs0NUE;_ylu=X3oDMTB0b2V0ZGxzBHNlYwNVSCAzIERlc2t0b3AgQ29nIE1lbnUgMTAw;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--;_ylv=0/SIG=156l02lpf/EXP=1374691132/**https%3A//edit.yahoo.com/mc2.0/eval_profile%3F.intl=us%26.lang=en-US%26.done=http%3A//news.yahoo.com/%26amp;.src=yn%26amp;.intl=us%26amp;.lang=en-US\\\" target=\\\"_top\\\"\\u003EAccount Info\\u003C/a\\u003E\\u003C/li\\u003E            \\u003Cli\\u003E\\u003Ca href=\\\"http://help.yahoo.com/l/us/yahoo/news_global/;_ylt=Ar0Fsf0kUANcLPmUrKxpX_Ws0NUE;_ylu=X3oDMTB0b2V0ZGxzBHNlYwNVSCAzIERlc2t0b3AgQ29nIE1lbnUgMTAw;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--\\\"                 rel=\\\"nofollow\\\" \\u003EHelp\\u003C/a\\u003E\\u003C/li\\u003E            \\u003Cspan class=\\\"yucs-separator\\\" role=\\\"presentation\\\" style=\\\"display: block;\\\"\\u003E\\u003C/span\\u003E            \\u003Cli\\u003E\\u003Ca href=\\\"http://us.lrd.yahoo.com/_ylt=Ag5WgS4jxjNNP_qv6LwbQ4qs0NUE;_ylu=X3oDMTB0b2V0ZGxzBHNlYwNVSCAzIERlc2t0b3AgQ29nIE1lbnUgMTAw;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--;_ylv=0/SIG=11rodk7q7/EXP=1374691132/**http%3A//feedback.yahoo.com/forums/204992\\\"                  rel=\\\"nofollow\\\" \\u003ESuggestions\\u003C/a\\u003E\\u003C/li\\u003E        \\u003C/ul\\u003E    \\u003C/div\\u003E\\u003C/div\\u003E    \\u003Cdiv id=\\\"yucs-network_link\\\"\\u003E\\u003Ca id=\\\"yucs-home_link\\\" href=\\\"http://us.lrd.yahoo.com/_ylt=Ati.v7n5T0gL0dzxb4jHyqSs0NUE;_ylu=X3oDMTE3ZGQ1N2JkBHNlYwNVSCAzIERlc2t0b3AgTmV0d29yayBOYXZpZ2F0aW9uIDEwMA--;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--;_ylv=0/SIG=119jpksvl/EXP=1374691132/**http%3A//www.yahoo.com/\\\" rel=\\\"nofollow\\\" target=\\\"_top\\\"\\u003EYahoo!\\u003C/a\\u003E\\u003C/div\\u003E        \\u003C!-- empty breaking news component --\\u003E     \\u003C/div\\u003E          \\u003C/div\\u003E \\u003C!-- contextual_shortcuts --\\u003E\\u003C!-- /contextual_shortcuts --\\u003E\\u003C!-- property: news | languagetag: en-us | status: active | spaceid: 81121452 | cobrand: standard | markup: empty --\\u003E\\u003Cdiv id=\\\"yUnivHead\\\" class=\\\"yucs-hide\\\"\\u003E\\u003C!-- empty --\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\n\\u003Cscript\\u003EYMedia.use(\\\"event\\\", \\\"get\\\", function(Y){ Y.once(\\\"load\\\", function(){ Y.Get.js(\\\"http://l.yimg.com/zz/combo?kx/yucs/uh3/uh/js/1/uh-min.js&kx/yucs/uh3/uh/js/102/gallery-jsonp-min.js&kx/yucs/uh3/uh/js/565/menu_utils_v3-min.js&kx/yucs/uh3/uh/js/549/timestamp_library-min.js&kx/yucs/uh3/uh3_top_bar/js/148/top_bar_v3-min.js&kx/yucs/uh3/search/js/361/search-min.js&kx/ucs/common/js/131/jsonp-super-cached-min.js&kx/yucs/uh3/avatar/js/9/avatar-min.js&kx/yucs/uh3/mail_link/js/60/mailcount-min.js&kx/yucs/uh3/help/js/46/help_menu_v3-min.js\\\"); }); });\\u003C/script\\u003E\\u003C/section\\u003E\\u003C!-- fe713.global.media.bf1.yahoo.com compressed Wed Jul 10 18:38:52 UTC 2013 --\\u003E\\n\\n                \\n            \\u003C/header\\u003E\\n            \\n\\u003Cscript type=\\\"text/javascript\\\"\\u003Eif(typeof rt_pushMoment!=='undefined')rt_pushMoment(\\\"t2\\\");\\u003C/script\\u003E\\n            \\u003Cdiv id=\\\"yog-bd\\\" class=\\\"yog-bd\\\" role=\\\"main\\\" data-type=\\\"homepage\\\" data-spaceid=\\\"81121452\\\"\\u003E\\n                \\u003C!-- Content --\\u003E\\n                \\n\\u003C!-- START full --\\u003E\\n\\n\\u003C!-- START N_C_R --\\u003E\\n\\u003Cdiv class=\\\"yog-wrap\\\"\\u003E\\n    \\u003Cdiv id=\\\"yog-sp\\\" class=\\\"yog-row yog-sp\\\"\\u003E\\n        \\u003Cdiv id=\\\"yog-sw\\\" class=\\\"yog-sw\\\"\\u003E\\n            \\u003Cdiv id=\\\"yog-stage\\\" class=\\\"yog-stage\\\"\\u003E\\n                \\u003C!-- --\\u003E\\u003Cdiv id=\\\"yom-ad-MAST\\\" class=\\\"yom-ad yom-ad-MAST\\\" style=\\\"visibility: inherit;\\\"\\u003E\\u003Ccenter\\u003E\\u003Cdiv id=\\\"yom-ad-MAST-iframe\\\" class=\\\"yom-ad\\\"\\u003E\\u003Ccenter\\u003E\\n\\u003Cscript\\u003E(function(){ var wrap = document.getElementById(\\\"yom-ad-MAST\\\"); if (null == wrap) { wrap = document.getElementById(\\\"yom-ad-MAST-iframe\\\") || {}; } var content = wrap.innerHTML || \\\"\\\"; if (content && content.substr(0, content.lastIndexOf(\\\"\\u003Cscript\\u003E\\\")).indexOf(\\\"loc=MAST noad\\\") !== -1) { wrap.style.display = \\\"none\\\"; } }())\\u003C/script\\u003E\\u003C/center\\u003E\\u003C/div\\u003E\\u003C/center\\u003E\\u003C/div\\u003E\\n            \\u003C/div\\u003E\\n        \\u003C/div\\u003E\\n    \\u003C/div\\u003E\\n    \\u003Cdiv id=\\\"yog-np\\\" class=\\\"yog-col yog-np\\\"\\u003E\\n        \\u003Cdiv id=\\\"yog-nw\\\" class=\\\"yog-nw\\\"\\u003E\\n            \\u003Cdiv id=\\\"yog-nav\\\" class=\\\"yog-nav\\\"\\u003E\\n                \\u003C!-- --\\u003E\\u003Cdiv id=\\\"mediacontentnavigation\\\" class=\\\"yom-mod navigation\\\" role=\\\"navigation\\\" data-ylk=\\\"mid:mediacontentnavigation;mpos:1;\\\"\\u003E\\n    \\u003Cnav\\u003E\\n        \\u003Cul class=\\\"navlist\\\"\\u003E\\n                \\u003Cli\\u003E\\n                    \\u003Ca href=\\\"/\\\" class=\\\"selected\\\" data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:;ltxt:home;sec:lnav-s;slk:link;cpos:1;\\\" data-action-outcome=\\\"navigate\\\"\\u003EHome\\u003C/a\\u003E\\n                \\u003C/li\\u003E\\n                \\u003Cli\\u003E\\n                    \\u003Ca href=\\\"/us/\\\" data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:;ltxt:us;sec:lnav-s;slk:link;cpos:2;\\\" data-action-outcome=\\\"navigate\\\"\\u003EU.S.\\u003C/a\\u003E\\n                \\u003C/li\\u003E\\n                \\u003Cli\\u003E\\n                    \\u003Ca href=\\\"/world/\\\" data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:;ltxt:world;sec:lnav-s;slk:link;cpos:3;\\\" data-action-outcome=\\\"navigate\\\"\\u003EWorld\\u003C/a\\u003E\\n                \\u003C/li\\u003E\\n                \\u003Cli\\u003E\\n                    \\u003Ca href=\\\"/politics/\\\" data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:;ltxt:politics;sec:lnav-s;slk:link;cpos:4;\\\" data-action-outcome=\\\"navigate\\\"\\u003EPolitics\\u003C/a\\u003E\\n                \\u003C/li\\u003E\\n                \\u003Cli\\u003E\\n                    \\u003Ca href=\\\"/tech/\\\" data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:;ltxt:tech;sec:lnav-s;slk:link;cpos:5;\\\" data-action-outcome=\\\"navigate\\\"\\u003ETech\\u003C/a\\u003E\\n                \\u003C/li\\u003E\\n                \\u003Cli\\u003E\\n                    \\u003Ca href=\\\"/science/\\\" data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:;ltxt:science;sec:lnav-s;slk:link;cpos:6;\\\" data-action-outcome=\\\"navigate\\\"\\u003EScience\\u003C/a\\u003E\\n                \\u003C/li\\u003E\\n                \\u003Cli\\u003E\\n                    \\u003Ca href=\\\"/health/\\\" data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:;ltxt:health;sec:lnav-s;slk:link;cpos:7;\\\" data-action-outcome=\\\"navigate\\\"\\u003EHealth\\u003C/a\\u003E\\n                \\u003C/li\\u003E\\n                \\u003Cli\\u003E\\n                    \\u003Ca href=\\\"/odd-news/\\\" data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:;ltxt:oddnews;sec:lnav-s;slk:link;cpos:8;\\\" data-action-outcome=\\\"navigate\\\"\\u003EOdd News\\u003C/a\\u003E\\n                \\u003C/li\\u003E\\n                \\u003Cli\\u003E\\n                    \\u003Ca href=\\\"/opinion/\\\" data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:;ltxt:opinion;sec:lnav-s;slk:link;cpos:9;\\\" data-action-outcome=\\\"navigate\\\"\\u003EOpinion\\u003C/a\\u003E\\n                \\u003C/li\\u003E\\n                \\u003Cli\\u003E\\n                    \\u003Ca href=\\\"/local/\\\" data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:;ltxt:local;sec:lnav-s;slk:link;cpos:10;\\\" data-action-outcome=\\\"navigate\\\"\\u003ELocal\\u003C/a\\u003E\\n                \\u003C/li\\u003E\\n                \\u003Cli\\u003E\\n                    \\u003Ca href=\\\"/dear-abby/\\\" data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:;ltxt:dearabby;sec:lnav-s;slk:link;cpos:11;\\\" data-action-outcome=\\\"navigate\\\"\\u003EDear Abby\\u003C/a\\u003E\\n                \\u003C/li\\u003E\\n                \\u003Cli\\u003E\\n                    \\u003Ca href=\\\"/comics/\\\" data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:;ltxt:comics;sec:lnav-s;slk:link;cpos:12;\\\" data-action-outcome=\\\"navigate\\\"\\u003EComics\\u003C/a\\u003E\\n                \\u003C/li\\u003E\\n                \\u003Cli\\u003E\\n                    \\u003Ca href=\\\"/abc-news/\\\" data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:;ltxt:abcnews;sec:lnav-s;slk:link;cpos:13;\\\" data-action-outcome=\\\"navigate\\\"\\u003EABC News\\u003C/a\\u003E\\n                \\u003C/li\\u003E\\n                \\u003Cli\\u003E\\n                    \\u003Ca href=\\\"/originals/\\\" data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:;ltxt:ynewsori;sec:lnav-s;slk:link;cpos:14;\\\" data-action-outcome=\\\"navigate\\\"\\u003EY! News Originals\\u003C/a\\u003E\\n                \\u003C/li\\u003E\\n        \\u003C/ul\\u003E\\n        \\u003Cscript id=\\\"nav-addon-template\\\" type=\\\"text/template\\\"\\u003E\\n            \\u003Cdiv class=\\\"nav-wrap pos-{{position}} {{classname}}\\\" data-position=\\\"{{position}}\\\"\\u003E\\n                \\u003Ch3\\u003E{{header}}\\u003C/h3\\u003E\\n                \\u003Cul class=\\\"navlist\\\"\\u003E\\n                    {{#entries}}\\n                        \\u003Cli\\u003E\\n                            \\u003Ca href=\\\"{{link}}\\\" {{#title_attrib}}title=\\\"{{title_attrib}}\\\"{{/title_attrib}}{{#class}}class=\\\"{{class}}\\\"{{/class}} {{{tracking}}} data-action-outcome=\\\"navigate\\\" data-item-id=\\\"{{id}}\\\"\\u003E{{{text}}}\\u003C/a\\u003E\\n                        \\u003C/li\\u003E\\n                    {{/entries}}\\n                    {{#show_more}}\\n                        \\u003Cdiv class=\\\"subnav\\\"\\u003E\\n                            \\u003Cli\\u003E\\u003Ca href=\\\"#\\\" class=\\\"more\\\"\\u003EMore \\u003Cstrong\\u003E&rsaquo;\\u003C/strong\\u003E\\u003C/a\\u003E\\n                                \\u003Cdiv class=\\\"subnav-more\\\"\\u003E\\n                                    \\u003Ci class=\\\"arrow\\\"\\u003E\\u003C/i\\u003E\\n                                \\u003Cul\\u003E\\n                                {{#more_entries}}\\n                                \\u003Cli\\u003E\\n                                     \\u003Ca href=\\\"{{link}}\\\" {{#title_attrib}}title=\\\"{{title_attrib}}\\\"{{/title_attrib}}{{#class}}class=\\\"{{class}}\\\"{{/class}} {{{tracking}}} data-action-outcome=\\\"navigate\\\" data-item-id=\\\"{{id}}\\\"\\u003E{{{text}}}\\u003C/a\\u003E\\n                                \\u003C/li\\u003E\\n                                 {{/more_entries}}\\n                                 \\u003C/ul\\u003E\\n                                 \\u003C/div\\u003E\\n                            \\u003C/li\\u003E\\n                        \\u003C/div\\u003E\\n                    {{/show_more}}\\n                \\u003C/ul\\u003E\\n            \\u003C/div\\u003E\\n        \\u003C/script\\u003E\\n    \\u003C/nav\\u003E\\n\\u003C/div\\u003E\\n            \\u003C/div\\u003E\\n        \\u003C/div\\u003E\\n    \\u003C/div\\u003E\\n    \\u003Cdiv id=\\\"yog-cp\\\" class=\\\"yog-col yog-cp\\\"\\u003E\\n        \\u003Cdiv id=\\\"yog-cw\\\" class=\\\"yog-cw\\\"\\u003E\\n            \\u003Cdiv id=\\\"yog-content\\\" class=\\\"yog-content yog-card\\\"\\u003E\\n                \\u003C!-- --\\u003E\\n\\n \\u003Csection class=\\\"yom-mod yom-lead clearfix\\\" id=\\\"mediacontentlead\\\" data-ylk=\\\"mid:mediacontentlead;mpos:1;sec:mod-ld;\\\"\\u003E \\u003C!--[if gte IE 9]\\u003E \\u003Cstyle type=\\\"text/css\\\"\\u003E .gradient { filter: none; } \\u003C/style\\u003E \\u003C![endif]--\\u003E  \\u003Cdiv class=\\\"lead-left\\\" data-img=\\\"http://l2.yimg.com/bt/api/res/1.2/F_zWVTc7lGRGKSyVjNIR5Q--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTM2MDtweW9mZj0yNTtxPTg1O3c9NDgw/http://media.zenfs.com/en_us/News/ap_webfeeds/d475fdac10c72e17370f6a706700275c.jpg\\\" data-uuid=\\\"8a1c7605-0ff6-3150-9990-76dae34185d8\\\" data-type=\\\"story\\\" data-url=\\\"http://news.yahoo.com/judge-rules-against-zimmerman-evidence-132354666.html\\\" data-title=\\\"Judge rules against Zimmerman on evidence\\\"\\u003E \\u003Cdiv class=\\\"yom-lead-featured-item\\\"\\u003E \\u003Ca data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:1;sec:mod-ld;slk:link;cpos:1;pkgt:1;pos:1;g:8a1c7605-0ff6-3150-9990-76dae34185d8;prov:Associated Press;test:gs03;\\\" class=\\\"yom-lead-featured-image\\\" href=\\\"http://news.yahoo.com/judge-rules-against-zimmerman-evidence-132354666.html\\\" style=\\\"background-image:url(http://l2.yimg.com/bt/api/res/1.2/F_zWVTc7lGRGKSyVjNIR5Q--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTM2MDtweW9mZj0yNTtxPTg1O3c9NDgw/http://media.zenfs.com/en_us/News/ap_webfeeds/d475fdac10c72e17370f6a706700275c.jpg)\\\" data-uuid=\\\"8a1c7605-0ff6-3150-9990-76dae34185d8\\\"\\u003E \\u003Cspan class=\\\"lead-overlay-icon-small lead-asset-article\\\"\\u003E\\u003C/span\\u003E \\u003C/a\\u003E \\u003Cdiv class=\\\"yom-lead-featured-overlay gradient\\\"\\u003E \\u003Cdiv class=\\\"lead-summary \\\"\\u003E  \\u003Ch3 class=\\\"yom-lead-featured-title\\\"\\u003E\\u003Ca data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:1;sec:mod-ld;slk:link;cpos:1;pkgt:1;pos:1;g:8a1c7605-0ff6-3150-9990-76dae34185d8;prov:Associated Press;test:gs03;\\\" class=\\\"yom-featured-title-link\\\" href=\\\"http://news.yahoo.com/judge-rules-against-zimmerman-evidence-132354666.html\\\" data-uuid=\\\"8a1c7605-0ff6-3150-9990-76dae34185d8\\\"\\u003EJudge rules against Zimmerman on evidence\\u003C/a\\u003E\\u003C/h3\\u003E  \\u003Cdiv class=\\\"yom-lead-summary-text\\\"\\u003E \\u003Cspan class=\\\"yom-lead-featured-blurb\\\"\\u003ESANFORD, Fla. (AP) — A Florida judge ruled Wednesday that Trayvon Martin's cellphone text messages&nbsp;&hellip;\\u003C/span\\u003E \\u003Ca data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:1;sec:mod-ld;slk:link;cpos:1;pkgt:1;pos:1;g:8a1c7605-0ff6-3150-9990-76dae34185d8;prov:Associated Press;test:gs03;\\\" class=\\\"yom-lead-more\\\" href=\\\"http://news.yahoo.com/judge-rules-against-zimmerman-evidence-132354666.html\\\"\\u003E\\u003Cspan class=\\\"lead-overlay-icon-xsmall lead-asset-article\\\"\\u003E\\u003C/span\\u003ERead More &raquo;\\u003C/a\\u003E \\u003C/div\\u003E  \\u003Cdiv class=\\\"lead-related-group\\\"\\u003E  \\u003C/div\\u003E   \\u003C/div\\u003E \\u003C/div\\u003E \\u003C/div\\u003E \\u003C/div\\u003E  \\u003Cdiv class=\\\"lead-right top\\\" data-img=\\\"http://l.yimg.com/bt/api/res/1.2/tSLQaTybdbnYf.h_nYrDIw--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE5MDtweW9mZj0yNTtxPTg1O3c9MzE2Ljg-/http://media.zenfs.com/en_us/News/ap_webfeeds/809bc9a8114b3017370f6a7067002d5c.jpg\\\" data-uuid=\\\"578e6c22-0186-30ad-82bc-d1ce5f90105b\\\" data-type=\\\"story\\\" data-url=\\\"http://news.yahoo.com/bombing-suspect-heads-1st-public-court-hearing-104650701.html\\\" data-title=\\\"Bombing suspect heads to 1st public court hearing\\\"\\u003E \\u003Cdiv class=\\\"yom-lead-featured-item\\\"\\u003E \\u003Ca data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:1;sec:mod-ld;slk:link;cpos:2;pkgt:1;pos:1;g:578e6c22-0186-30ad-82bc-d1ce5f90105b;prov:Associated Press;test:gs03;\\\" class=\\\"yom-lead-featured-image\\\" href=\\\"http://news.yahoo.com/bombing-suspect-heads-1st-public-court-hearing-104650701.html\\\" style=\\\"background-image:url(http://l.yimg.com/bt/api/res/1.2/tSLQaTybdbnYf.h_nYrDIw--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE5MDtweW9mZj0yNTtxPTg1O3c9MzE2Ljg-/http://media.zenfs.com/en_us/News/ap_webfeeds/809bc9a8114b3017370f6a7067002d5c.jpg)\\\" data-uuid=\\\"578e6c22-0186-30ad-82bc-d1ce5f90105b\\\"\\u003E \\u003Cspan class=\\\"lead-overlay-icon-small lead-asset-article\\\"\\u003E\\u003C/span\\u003E \\u003C/a\\u003E \\u003Cdiv class=\\\"yom-lead-featured-overlay gradient\\\"\\u003E \\u003Cdiv class=\\\"lead-summary \\\"\\u003E  \\u003Ch3 class=\\\"yom-lead-featured-title\\\"\\u003E\\u003Ca data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:1;sec:mod-ld;slk:link;cpos:2;pkgt:1;pos:1;g:578e6c22-0186-30ad-82bc-d1ce5f90105b;prov:Associated Press;test:gs03;\\\" class=\\\"yom-featured-title-link\\\" href=\\\"http://news.yahoo.com/bombing-suspect-heads-1st-public-court-hearing-104650701.html\\\" data-uuid=\\\"578e6c22-0186-30ad-82bc-d1ce5f90105b\\\"\\u003EBombing suspect heads to 1st public court hearing\\u003C/a\\u003E\\u003C/h3\\u003E  \\u003C/div\\u003E \\u003C/div\\u003E \\u003C/div\\u003E \\u003C/div\\u003E  \\u003Cdiv class=\\\"lead-right bottom\\\" data-img=\\\"http://l2.yimg.com/bt/api/res/1.2/AWwr0E007DW9IjSVxe3qBQ--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE5MDtweW9mZj0yNTtxPTg1O3c9MzE2Ljg-/http://media.zenfs.com/en_us/News/ap_webfeeds/dd090b10f3111b16370f6a706700e344.jpg\\\" data-uuid=\\\"43e80a47-79ec-3809-ac98-1518389138c7\\\" data-type=\\\"story\\\" data-url=\\\"http://news.yahoo.com/sf-probe-brings-questions-over-auto-speed-controls-084646467.html\\\" data-title=\\\"SF probe brings questions over auto speed controls\\\"\\u003E \\u003Cdiv class=\\\"yom-lead-featured-item\\\"\\u003E \\u003Ca data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:1;sec:mod-ld;slk:link;cpos:3;pkgt:1;pos:1;g:43e80a47-79ec-3809-ac98-1518389138c7;prov:Associated Press;test:gs03;\\\" class=\\\"yom-lead-featured-image\\\" href=\\\"http://news.yahoo.com/sf-probe-brings-questions-over-auto-speed-controls-084646467.html\\\" style=\\\"background-image:url(http://l2.yimg.com/bt/api/res/1.2/AWwr0E007DW9IjSVxe3qBQ--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE5MDtweW9mZj0yNTtxPTg1O3c9MzE2Ljg-/http://media.zenfs.com/en_us/News/ap_webfeeds/dd090b10f3111b16370f6a706700e344.jpg)\\\" data-uuid=\\\"43e80a47-79ec-3809-ac98-1518389138c7\\\"\\u003E \\u003Cspan class=\\\"lead-overlay-icon-small lead-asset-article\\\"\\u003E\\u003C/span\\u003E \\u003C/a\\u003E \\u003Cdiv class=\\\"yom-lead-featured-overlay gradient\\\"\\u003E \\u003Cdiv class=\\\"lead-summary \\\"\\u003E  \\u003Ch3 class=\\\"yom-lead-featured-title\\\"\\u003E\\u003Ca data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:1;sec:mod-ld;slk:link;cpos:3;pkgt:1;pos:1;g:43e80a47-79ec-3809-ac98-1518389138c7;prov:Associated Press;test:gs03;\\\" class=\\\"yom-featured-title-link\\\" href=\\\"http://news.yahoo.com/sf-probe-brings-questions-over-auto-speed-controls-084646467.html\\\" data-uuid=\\\"43e80a47-79ec-3809-ac98-1518389138c7\\\"\\u003ESF probe brings questions over auto speed controls\\u003C/a\\u003E\\u003C/h3\\u003E  \\u003C/div\\u003E \\u003C/div\\u003E \\u003C/div\\u003E \\u003C/div\\u003E  \\u003C/section\\u003E\\n\\u003Cdiv class=\\\"yom-remote\\\"\\u003E\\u003Cdiv class=\\\"yom-loading\\\" id=\\\"p_30345786_container\\\"\\u003E\\u003C!-- --\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\n            \\u003C/div\\u003E\\n        \\u003C/div\\u003E\\n    \\u003C/div\\u003E\\n    \\u003Cdiv id=\\\"yog-rp\\\" class=\\\"yog-col yog-rp\\\"\\u003E\\n         \\u003Cdiv id=\\\"yog-rw\\\" class=\\\"yog-rw\\\"\\u003E\\n            \\u003Cdiv id=\\\"yog-related\\\" class=\\\"yog-related\\\"\\u003E\\n                \\u003C!-- --\\u003E\\u003Cdiv id=\\\"yom-ad-LREC\\\" class=\\\"yom-ad yom-ad-LREC\\\" style=\\\"visibility: inherit;\\\"\\u003E\\u003Ccenter\\u003E\\u003Cdiv id=\\\"yom-ad-LREC-iframe\\\" class=\\\"yom-ad\\\"\\u003E\\u003Ccenter\\u003E\\n\\u003Cscript\\u003E(function(){ var wrap = document.getElementById(\\\"yom-ad-LREC\\\"); if (null == wrap) { wrap = document.getElementById(\\\"yom-ad-LREC-iframe\\\") || {}; } var content = wrap.innerHTML || \\\"\\\"; if (content && content.substr(0, content.lastIndexOf(\\\"\\u003Cscript\\u003E\\\")).indexOf(\\\"loc=LREC noad\\\") !== -1) { wrap.style.display = \\\"none\\\"; } }())\\u003C/script\\u003E\\u003C/center\\u003E\\u003C/div\\u003E\\u003C/center\\u003E\\u003C/div\\u003E\\n\\u003Cdiv class=\\\"yom-remote\\\"\\u003E\\u003Cdiv class=\\\"yom-loading\\\" id=\\\"mediacontentweather_container\\\"\\u003E\\u003C!-- --\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\n \\u003Csection class=\\\"yom-mod yom-comic yom-app clearfix\\\" id=\\\"mediacontentcomic\\\" data-ylk=\\\"mid:mediacontentcomic;mpos:2;sec:app-com;\\\"\\u003E \\u003Cdiv class=\\\"hd\\\"\\u003E \\u003Cdiv class=\\\"top-nav\\\"\\u003E \\u003Ch3 class=\\\"title\\\"\\u003EComics\\u003C/h3\\u003E \\u003Cdiv class=\\\"dropdown\\\"\\u003E \\u003Cselect class=\\\"comic-select\\\"\\u003E  \\u003Coption value=\\\"92df5b73-9c06-3216-9539-45edc1a84bfa\\\"\\u003EAndy Capp\\u003C/option\\u003E  \\u003Coption value=\\\"9b9275a0-146b-3b57-ad6b-fc1f634bebd5\\\"\\u003EDoonesbury\\u003C/option\\u003E  \\u003Coption value=\\\"d2fd1039-306e-3a5b-a65e-ffc43d494d83\\\"\\u003E9 Chickweed Lane\\u003C/option\\u003E  \\u003Coption value=\\\"d427f3cd-b845-3305-a401-87d41f754230\\\"\\u003EDilbert\\u003C/option\\u003E  \\u003Coption value=\\\"0d4e9718-aab2-366c-84a9-719aeb1161ae\\\"\\u003EPeanuts\\u003C/option\\u003E  \\u003Coption value=\\\"97cb2d44-fca7-35b9-8ce0-2271e5140061\\\"\\u003EWizard of Id\\u003C/option\\u003E  \\u003Coption value=\\\"e6f925cc-09d1-3de6-a6a9-1b508dabcec5\\\"\\u003EB.C.\\u003C/option\\u003E  \\u003Coption value=\\\"04db50ed-cd87-36b1-a3cf-a9c12e762d5f\\\"\\u003ELuann\\u003C/option\\u003E  \\u003Coption value=\\\"702ab4a0-145a-3b69-9a83-aed16a8a024a\\\"\\u003EGarfield\\u003C/option\\u003E  \\u003Coption value=\\\"47c04e74-8cd0-3574-8191-0ee3dfbf5745\\\"\\u003EPearls Before Swine\\u003C/option\\u003E  \\u003C/select\\u003E \\u003C/div\\u003E \\u003C/div\\u003E \\u003C/div\\u003E \\u003Cdiv class=\\\"bd yui3-skin-sam\\\"\\u003E \\u003Cdiv id=\\\"comic_main\\\"\\u003E \\u003Cdiv class=\\\"sub-nav\\\"\\u003E \\u003Cbutton class=\\\"nav-bt prev\\\"\\u003E \\u003Cspan class=\\\"icon-black-prev-xsmall\\\"\\u003E\\u003C/span\\u003E \\u003Cimg class=\\\"icon-ie-fix\\\" src=\\\"http://l.yimg.com/os/mit/media/themes/v2_base/images/icons/png/icon_black_prev_xsmall-1269670.png\\\"\\u003E\\u003C/img\\u003E \\u003C/button\\u003E \\u003Cbutton class=\\\"nav-bt next inactive\\\"\\u003E \\u003Cspan class=\\\"icon-black-next-xsmall\\\"\\u003E\\u003C/span\\u003E \\u003Cimg class=\\\"icon-ie-fix\\\" src=\\\"http://l.yimg.com/os/mit/media/themes/v2_base/images/icons/png/icon_black_next_xsmall-1269670.png\\\"\\u003E\\u003C/img\\u003E \\u003C/button\\u003E \\u003Cdiv class=\\\"more-comic\\\"\\u003E\\u003Ca class=\\\"more-comic-main\\\" href=\\\"/comics/\\\"\\u003E\\u003Cspan class=\\\"more\\\"\\u003EMore\\u003C/span\\u003E\\u003C/a\\u003E\\u003C/div\\u003E \\u003C/div\\u003E \\u003Cdiv class=\\\"slideshow\\\"\\u003E \\u003Cp class=\\\"date\\\"\\u003EWed, Jul 10\\u003C/p\\u003E \\u003Ca id='comic_img_holder'\\u003E\\u003Cimg class=\\\"comic-image\\\" src =\\\"http://l2.yimg.com/bt/api/res/1.2/bbvN0UJx2GpIp_uEggkMQQ--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTEwMjtweW9mZj0wO3E9ODU7dz0zNjQ-/http://media.zenfs.com/en_us/News/ucomics.com/crcap130710.gif\\\"\\u003E\\u003C/a\\u003E \\u003C/div\\u003E \\u003Cimg class=\\\"pre-load-comic hide\\\"/\\u003E \\u003C/div\\u003E \\u003Cdiv id=\\\"comic_overlay\\\" class=\\\"hide\\\"\\u003E \\u003Cbutton class=\\\"nav-bt prev\\\"\\u003E\\u003C/button\\u003E \\u003Cdiv class=\\\"slideshow\\\"\\u003E \\u003Cp class=\\\"hd\\\"\\u003E \\u003C!--TODO inject title by js --\\u003E \\u003Cspan class=\\\"title\\\"\\u003EAndy Capp\\u003C/span\\u003E \\u003Cspan class=\\\"date\\\"\\u003EWednesday, July 10\\u003C/span\\u003E \\u003Ca class=\\\"more-comic-overlay\\\" href=\\\"/comics/\\\"\\u003E\\u003Cspan class=\\\"more\\\"\\u003EMore\\u003C/span\\u003E\\u003C/a\\u003E \\u003Cbutton class=\\\"close\\\"\\u003E\\u003C/button\\u003E \\u003C/p\\u003E \\u003Cimg class=\\\"comic-image\\\"\\u003E \\u003C/div\\u003E \\u003Cbutton class=\\\"nav-bt next inactive\\\"\\u003E\\u003C/button\\u003E \\u003Cimg class=\\\"pre-load-comic hide\\\"/\\u003E \\u003C/div\\u003E \\u003C/div\\u003E \\u003C/section\\u003E\\n            \\u003Cstyle type=\\\"text/css\\\"\\u003E#dmRosAdWrapper-east iframe{width:100%} #yog-cw .dmros_ad {border-color: #E0E0E0; border-style: solid; border-width: 0 0 1px;}\\u003C/style\\u003E\\n            \\u003Cdiv id=\\\"dmRosAdWrapper-east\\\" class=\\\"dmros_ad yom-app\\\"\\u003E\\n                \\u003Cnoscript\\u003E\\n                    \\u003Cdiv id=\\\"dmRosAd-1-east\\\" width=\\\"300\\\" height=\\\"300\\\" frameborder=\\\"0\\\" marginheight=\\\"0\\\" marginwidth=\\\"0\\\" scrolling=\\\"no\\\" src=\\\"http://dmros.ysm.yahoo.com/ros/?c=e5879714&w=300&h=300&ty=noscript&tt=Yahoo%21+News+-+Latest+News+%26amp%3B+Headlines&r=\\\"\\u003E\\u003C/div\\u003E\\n                \\u003C/noscript\\u003E\\n            \\u003C/div\\u003E\\n \\u003Csection class=\\\"yom-mod \\\" id=\\\"mediacontentgenericlistings\\\" data-ylk=\\\"mid:mediacontentgenericlistings;mpos:1;\\\"\\u003E \\u003Cdiv class=\\\"yom-generic-listings-module yom-app\\\" id=\\\"mediacontentgenericlistings\\\"\\u003E \\u003Cdiv class=\\\"hd\\\"\\u003E \\u003Ch1\\u003ELatest Videos\\u003C/h1\\u003E \\u003C/div\\u003E \\u003Cdiv class=\\\"bd\\\"\\u003E \\u003Cdiv class=\\\"latest-content-inline\\\"\\u003E \\u003Cul\\u003E  \\u003Cli\\u003E  \\u003Ca class=\\\"thumb-link\\\" href=\\\"/video/david-tillmans-midday-weather-forecast-174557836.html\\\" data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:DavidTil;cpos:1;test:;g:d99db792-ac02-3755-89d1-c481368027b5;\\\"\\u003E \\u003Cimg src=\\\"http://l1.yimg.com/bt/api/res/1.2/veN8qLz8lKvAVAumLAlo0g--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTg0O3B5b2ZmPTA7cT04NTt3PTE0OQ--/http://media.zenfs.com/en-US/video/video.krtk.abc.news.com/071d287ffca0c9b91d8d54936799af58\\\" width=\\\"149\\\" height=\\\"84\\\"/\\u003E \\u003Cspan class=\\\"overlay_asset_video overlay-icon\\\"\\u003E\\u003Ci\\u003E\\u003C/i\\u003E\\u003C/span\\u003E \\u003C/a\\u003E \\u003Cdiv class=\\\"listing-title\\\"\\u003E \\u003Ca href=\\\"/video/david-tillmans-midday-weather-forecast-174557836.html\\\" data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:DavidTil;cpos:1;test:;g:d99db792-ac02-3755-89d1-c481368027b5;\\\"\\u003EDavid Tillman's midday weather forecast\\u003C/a\\u003E  \\u003Cdiv class=\\\"content-length\\\"\\u003E02:50\\u003C/div\\u003E  \\u003C/div\\u003E   \\u003C/li\\u003E  \\u003Cli\\u003E  \\u003Ca class=\\\"thumb-link\\\" href=\\\"/video/printer-ink-efficiency-tested-consumer-174417327.html\\\" data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:Printeri;cpos:2;test:;g:c621133c-f907-3f42-93ff-20ef01effa97;\\\"\\u003E \\u003Cimg src=\\\"http://l2.yimg.com/bt/api/res/1.2/CwfQcCkClv52oyjQ7g7scg--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTg0O3B5b2ZmPTA7cT04NTt3PTE0OQ--/http://media.zenfs.com/en-US/video/video.kgo.abc.news.com/20a2be41046b838e6399259f73c9f47d\\\" width=\\\"149\\\" height=\\\"84\\\"/\\u003E \\u003Cspan class=\\\"overlay_asset_video overlay-icon\\\"\\u003E\\u003Ci\\u003E\\u003C/i\\u003E\\u003C/span\\u003E \\u003C/a\\u003E \\u003Cdiv class=\\\"listing-title\\\"\\u003E \\u003Ca href=\\\"/video/printer-ink-efficiency-tested-consumer-174417327.html\\\" data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:Printeri;cpos:2;test:;g:c621133c-f907-3f42-93ff-20ef01effa97;\\\"\\u003EPrinter ink efficiency tested by Consumer Reports\\u003C/a\\u003E  \\u003Cdiv class=\\\"content-length\\\"\\u003E02:33\\u003C/div\\u003E  \\u003C/div\\u003E   \\u003C/li\\u003E  \\u003Cli\\u003E  \\u003Ca class=\\\"thumb-link\\\" href=\\\"/video/rare-film-shows-fdr-pushed-174224035.html\\\" data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:RareFilm;cpos:3;test:;g:331b7a46-49c4-3836-a09b-e384123ad646;\\\"\\u003E \\u003Cimg src=\\\"http://l1.yimg.com/bt/api/res/1.2/ItGx6oCodQwaOTyUM6GFKA--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTg0O3B5b2ZmPTA7cT04NTt3PTE0OQ--/http://media.zenfs.com/en-US/video/video.abcnewsplus.com/89475392ef9ada92079c7c09ae98e51c\\\" width=\\\"149\\\" height=\\\"84\\\"/\\u003E \\u003Cspan class=\\\"overlay_asset_video overlay-icon\\\"\\u003E\\u003Ci\\u003E\\u003C/i\\u003E\\u003C/span\\u003E \\u003C/a\\u003E \\u003Cdiv class=\\\"listing-title\\\"\\u003E \\u003Ca href=\\\"/video/rare-film-shows-fdr-pushed-174224035.html\\\" data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:RareFilm;cpos:3;test:;g:331b7a46-49c4-3836-a09b-e384123ad646;\\\"\\u003ERare Film Shows FDR Pushed in Wheelchair\\u003C/a\\u003E  \\u003Cdiv class=\\\"content-length\\\"\\u003E00:34\\u003C/div\\u003E  \\u003C/div\\u003E   \\u003C/li\\u003E  \\u003Cli\\u003E  \\u003Ca class=\\\"thumb-link\\\" href=\\\"/video/lunch-break-07-10-13-172614033.html\\\" data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:LunchBre;cpos:4;test:;g:67587838-99cc-37a2-b1b2-3dcb29642ad9;\\\"\\u003E \\u003Cimg src=\\\"http://l3.yimg.com/bt/api/res/1.2/LkkjfAYKWSekT6nQFdS.KQ--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTg0O3B5b2ZmPTA7cT04NTt3PTE0OQ--/http://media.zenfs.com/en-US/video/video.wls.abc.news.com/c03c4c7494c4c8714e06c1c7df916bf3\\\" width=\\\"149\\\" height=\\\"84\\\"/\\u003E \\u003Cspan class=\\\"overlay_asset_video overlay-icon\\\"\\u003E\\u003Ci\\u003E\\u003C/i\\u003E\\u003C/span\\u003E \\u003C/a\\u003E \\u003Cdiv class=\\\"listing-title\\\"\\u003E \\u003Ca href=\\\"/video/lunch-break-07-10-13-172614033.html\\\" data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:LunchBre;cpos:4;test:;g:67587838-99cc-37a2-b1b2-3dcb29642ad9;\\\"\\u003ELunch Break 07-10-13\\u003C/a\\u003E  \\u003Cdiv class=\\\"content-length\\\"\\u003E03:12\\u003C/div\\u003E  \\u003C/div\\u003E   \\u003C/li\\u003E  \\u003Cli\\u003E  \\u003Ca class=\\\"thumb-link\\\" href=\\\"/video/wishbone-bombay-spice-grill-among-172554941.html\\\" data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:Wishbone;cpos:5;test:;g:673e2bc5-5e04-3db5-b7ee-847fb557c4b5;\\\"\\u003E \\u003Cimg src=\\\"http://l2.yimg.com/bt/api/res/1.2/HWac8J1.q6.22cUflOnyzQ--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTg0O3B5b2ZmPTA7cT04NTt3PTE0OQ--/http://media.zenfs.com/en-US/video/video.wls.abc.news.com/0df3426dec4bd34f6caf8891f8b503f4\\\" width=\\\"149\\\" height=\\\"84\\\"/\\u003E \\u003Cspan class=\\\"overlay_asset_video overlay-icon\\\"\\u003E\\u003Ci\\u003E\\u003C/i\\u003E\\u003C/span\\u003E \\u003C/a\\u003E \\u003Cdiv class=\\\"listing-title\\\"\\u003E \\u003Ca href=\\\"/video/wishbone-bombay-spice-grill-among-172554941.html\\\" data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:Wishbone;cpos:5;test:;g:673e2bc5-5e04-3db5-b7ee-847fb557c4b5;\\\"\\u003EWishbone, Bombay Spice & Grill, among newcomers at&nbsp;&hellip;\\u003C/a\\u003E  \\u003Cdiv class=\\\"content-length\\\"\\u003E03:26\\u003C/div\\u003E  \\u003C/div\\u003E   \\u003C/li\\u003E  \\u003Cli\\u003E  \\u003Ca class=\\\"thumb-link\\\" href=\\\"/video/whitey-bulger-ex-partner-trade-171312946.html\\\" data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:WhiteyBu;cpos:6;test:;g:8c9b8433-216b-3de6-902e-875865d62d79;\\\"\\u003E \\u003Cimg src=\\\"http://l1.yimg.com/bt/api/res/1.2/QpmK2meJSQYDMJay5HtPOA--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTg0O3B5b2ZmPTA7cT04NTt3PTE0OQ--/http://media.zenfs.com/en-US/video/video.fbc.news.com/bcb728d0f33817491fd4df7bf72bbe17\\\" width=\\\"149\\\" height=\\\"84\\\"/\\u003E \\u003Cspan class=\\\"overlay_asset_video overlay-icon\\\"\\u003E\\u003Ci\\u003E\\u003C/i\\u003E\\u003C/span\\u003E \\u003C/a\\u003E \\u003Cdiv class=\\\"listing-title\\\"\\u003E \\u003Ca href=\\\"/video/whitey-bulger-ex-partner-trade-171312946.html\\\" data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:WhiteyBu;cpos:6;test:;g:8c9b8433-216b-3de6-902e-875865d62d79;\\\"\\u003EWhitey Bulger, ex-partner trade curses in courtroo&nbsp;&hellip;\\u003C/a\\u003E  \\u003Cdiv class=\\\"content-length\\\"\\u003E04:57\\u003C/div\\u003E  \\u003C/div\\u003E   \\u003C/li\\u003E  \\u003Cli\\u003E  \\u003Ca class=\\\"thumb-link\\\" href=\\\"/video/taste-chicago-2013-opens-165744456.html\\\" data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:TasteofC;cpos:7;test:;g:523fedde-cc12-38fb-86ca-60629888845c;\\\"\\u003E \\u003Cimg src=\\\"http://l3.yimg.com/bt/api/res/1.2/QTz_4cBuB9J64_imAFveDw--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTg0O3B5b2ZmPTA7cT04NTt3PTE0OQ--/http://media.zenfs.com/en-US/video/video.wls.abc.news.com/7a447cc09cf3fad88945422ce5004b74\\\" width=\\\"149\\\" height=\\\"84\\\"/\\u003E \\u003Cspan class=\\\"overlay_asset_video overlay-icon\\\"\\u003E\\u003Ci\\u003E\\u003C/i\\u003E\\u003C/span\\u003E \\u003C/a\\u003E \\u003Cdiv class=\\\"listing-title\\\"\\u003E \\u003Ca href=\\\"/video/taste-chicago-2013-opens-165744456.html\\\" data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:TasteofC;cpos:7;test:;g:523fedde-cc12-38fb-86ca-60629888845c;\\\"\\u003ETaste of Chicago 2013 opens\\u003C/a\\u003E  \\u003Cdiv class=\\\"content-length\\\"\\u003E02:37\\u003C/div\\u003E  \\u003C/div\\u003E   \\u003C/li\\u003E  \\u003Cli\\u003E  \\u003Ca class=\\\"thumb-link\\\" href=\\\"/video/officials-defend-paulsboro-train-derailment-163843236.html\\\" data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:Official;cpos:8;test:;g:51aceae4-c48c-3955-bc3d-deabf73b0d4c;\\\"\\u003E \\u003Cimg src=\\\"http://l2.yimg.com/bt/api/res/1.2/ufVoV8B0.7gXA6JYfCi21g--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTg0O3B5b2ZmPTA7cT04NTt3PTE0OQ--/http://media.zenfs.com/en-US/video/video.wpvi.abc.news.com/5e4045e37715007a85f25d8519373f5d\\\" width=\\\"149\\\" height=\\\"84\\\"/\\u003E \\u003Cspan class=\\\"overlay_asset_video overlay-icon\\\"\\u003E\\u003Ci\\u003E\\u003C/i\\u003E\\u003C/span\\u003E \\u003C/a\\u003E \\u003Cdiv class=\\\"listing-title\\\"\\u003E \\u003Ca href=\\\"/video/officials-defend-paulsboro-train-derailment-163843236.html\\\" data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:Official;cpos:8;test:;g:51aceae4-c48c-3955-bc3d-deabf73b0d4c;\\\"\\u003EOfficials defend Paulsboro train derailment respon&nbsp;&hellip;\\u003C/a\\u003E  \\u003Cdiv class=\\\"content-length\\\"\\u003E00:32\\u003C/div\\u003E  \\u003C/div\\u003E   \\u003C/li\\u003E  \\u003Cli\\u003E  \\u003Ca class=\\\"thumb-link\\\" href=\\\"/video/humboldt-park-sex-assault-near-112404068.html\\\" data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:Policese;cpos:9;test:;g:77d99ad3-23b2-31a4-9d15-beda9147cf9e;\\\"\\u003E \\u003Cimg src=\\\"http://l1.yimg.com/bt/api/res/1.2/Kk3MDF03zGjNCkXlW4fjYw--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTg0O3B5b2ZmPTA7cT04NTt3PTE0OQ--/http://media.zenfs.com/en-US/video/video.wls.abc.news.com/64d1c12ccfd7675a309c02587c14b3dd\\\" width=\\\"149\\\" height=\\\"84\\\"/\\u003E \\u003Cspan class=\\\"overlay_asset_video overlay-icon\\\"\\u003E\\u003Ci\\u003E\\u003C/i\\u003E\\u003C/span\\u003E \\u003C/a\\u003E \\u003Cdiv class=\\\"listing-title\\\"\\u003E \\u003Ca href=\\\"/video/humboldt-park-sex-assault-near-112404068.html\\\" data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:Policese;cpos:9;test:;g:77d99ad3-23b2-31a4-9d15-beda9147cf9e;\\\"\\u003EPolice searching for bus stop attacker in Humboldt&nbsp;&hellip;\\u003C/a\\u003E  \\u003Cdiv class=\\\"content-length\\\"\\u003E02:16\\u003C/div\\u003E  \\u003C/div\\u003E   \\u003C/li\\u003E  \\u003Cli\\u003E  \\u003Ca class=\\\"thumb-link\\\" href=\\\"/video/teen-being-questioned-mothers-murder-112642183.html\\\" data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:Teenchar;cpos:10;test:;g:442d0366-9815-3b70-aad9-fdc81b8f7177;\\\"\\u003E \\u003Cimg src=\\\"http://l2.yimg.com/bt/api/res/1.2/W9.dxej3b2EFxrhoMNiOkg--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTg0O3B5b2ZmPTA7cT04NTt3PTE0OQ--/http://media.zenfs.com/en-US/video/video.krtk.abc.news.com/dd80edf723819cd2c3f73555a9a8fea1\\\" width=\\\"149\\\" height=\\\"84\\\"/\\u003E \\u003Cspan class=\\\"overlay_asset_video overlay-icon\\\"\\u003E\\u003Ci\\u003E\\u003C/i\\u003E\\u003C/span\\u003E \\u003C/a\\u003E \\u003Cdiv class=\\\"listing-title\\\"\\u003E \\u003Ca href=\\\"/video/teen-being-questioned-mothers-murder-112642183.html\\\" data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:Teenchar;cpos:10;test:;g:442d0366-9815-3b70-aad9-fdc81b8f7177;\\\"\\u003ETeen charged in mother's murder\\u003C/a\\u003E  \\u003Cdiv class=\\\"content-length\\\"\\u003E02:55\\u003C/div\\u003E  \\u003C/div\\u003E   \\u003C/li\\u003E  \\u003C/ul\\u003E \\u003C/div\\u003E \\u003C/div\\u003E \\u003C/div\\u003E \\u003C/section\\u003E\\n\\u003Cdiv id=\\\"yom-ad-LREC2\\\" class=\\\"yom-ad yom-ad-LREC2\\\" style=\\\"visibility: inherit;\\\"\\u003E\\u003Ccenter\\u003E\\u003Cdiv id=\\\"yom-ad-LREC2-iframe\\\" class=\\\"yom-ad\\\"\\u003E\\u003Ccenter\\u003E\\n\\u003Cscript\\u003E(function(){ var wrap = document.getElementById(\\\"yom-ad-LREC2\\\"); if (null == wrap) { wrap = document.getElementById(\\\"yom-ad-LREC2-iframe\\\") || {}; } var content = wrap.innerHTML || \\\"\\\"; if (content && content.substr(0, content.lastIndexOf(\\\"\\u003Cscript\\u003E\\\")).indexOf(\\\"loc=LREC2 noad\\\") !== -1) { wrap.style.display = \\\"none\\\"; } }())\\u003C/script\\u003E\\u003C/center\\u003E\\u003C/div\\u003E\\u003C/center\\u003E\\u003C/div\\u003E\\n\\u003Cdiv class=\\\"yom-remote\\\"\\u003E\\u003Cdiv class=\\\"yom-loading\\\" id=\\\"mediacontentfollowproperty_container\\\"\\u003E\\u003C!-- --\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\n\\u003Cdiv id=\\\"mediafooterinfo\\\" class=\\\"yom-mod yom-footer-info\\\" role=\\\"contentinfo\\\"\\u003E\\n    \\u003Cdiv class=\\\"bd\\\"\\u003E\\n        \\u003Cdiv class=\\\"copyright-providers\\\"\\u003E\\n            \\u003Ccite\\u003E\\u003C/cite\\u003E\\n        \\u003C/div\\u003E\\n        \\u003Cdiv class=\\\"disclaimer\\\"\\u003E\\n            \\u003Ccite\\u003E\\u003C/cite\\u003E\\n        \\u003C/div\\u003E\\n        \\u003Cdiv class=\\\"copyright\\\"\\u003E\\n            \\u003Ccite\\u003E\\n                Copyright © 2013 Yahoo! Inc. All rights reserved.\\n            \\u003C/cite\\u003E\\n            \\u003Cspan\\u003E\\n                 | Yahoo! - ABC News Network | \\n            \\u003C/span\\u003E\\n            \\u003Cul\\u003E\\n                \\u003Cli class=\\\"first\\\"\\u003E\\u003Ca href=\\\"http://help.yahoo.com/l/us/yahoo/news_global/\\\"\\u003EHelp\\u003C/a\\u003E / \\u003Ca href=\\\"http://feedback.yahoo.com/forums/204992\\\"\\u003ESuggestions\\u003C/a\\u003E\\u003C/li\\u003E\\n                \\u003Cli\\u003E\\u003Ca href=\\\"http://info.yahoo.com/privacy/us/yahoo/news/\\\"\\u003EPrivacy Policy\\u003C/a\\u003E\\u003C/li\\u003E\\n                \\u003Cli\\u003E\\u003Ca href=\\\"http://info.yahoo.com/relevantads/\\\"\\u003EAbout Our Ads\\u003C/a\\u003E\\u003C/li\\u003E\\n                \\u003Cli\\u003E\\u003Ca href=\\\"http://info.yahoo.com/legal/us/yahoo/utos/utos-173.html\\\"\\u003ETerms of Service\\u003C/a\\u003E\\u003C/li\\u003E\\n                \\u003Cli class=\\\"last\\\"\\u003E\\u003Ca href=\\\"http://docs.yahoo.com/info/copyright/copyright.html\\\"\\u003ECopyright/IP Policy\\u003C/a\\u003E\\u003C/li\\u003E\\n            \\u003C/ul\\u003E\\n        \\u003C/div\\u003E\\n        \\u003Cdiv class=\\\"notice\\\"\\u003E\\n            \\u003Ccite\\u003E\\u003C/cite\\u003E\\n        \\u003C/div\\u003E\\n        \\n    \\u003C/div\\u003E\\n\\u003C/div\\u003E\\n            \\u003C/div\\u003E\\n        \\u003C/div\\u003E\\n    \\u003C/div\\u003E\\n\\u003C/div\\u003E\\n\\n\\u003C!-- END N_C_R --\\u003E\\n\\n\\u003C!-- START wrap --\\u003E\\n\\u003Cdiv class=\\\"yog-wrap yog-full\\\"\\u003E\\n    \\u003Cdiv id=\\\"yom-ad-darla-callframe-mediaadsdarla\\\" style=\\\"display:none;\\\"\\u003E\\u003C/div\\u003E\\n\\u003C/div\\u003E\\n\\n\\n\\u003C!-- END wrap --\\u003E\\n\\n\\n\\u003C!-- END full --\\u003E\\n\\n                \\u003C!-- Social Events --\\u003E\\n                \\n                \\u003C!-- Feedback --\\u003E\\n                \\n            \\u003C/div\\u003E\\n            \\n\\u003Cscript type=\\\"text/javascript\\\"\\u003Eif(typeof rt_pushMoment!=='undefined')rt_pushMoment(\\\"t3\\\");\\u003C/script\\u003E\\n        \\u003C/div\\u003E\\n        \\u003Cdiv id=\\\"yom-ad-FOOT9\\\" class=\\\"yom-ad yom-ad-FOOT9\\\" style=\\\"visibility: inherit;\\\"\\u003E\\u003Ccenter\\u003E\\u003C/center\\u003E\\u003C/div\\u003E\\n        \\n\\u003Cscript type=\\\"text/javascript\\\"\\u003Eif(typeof rt_pushMoment!=='undefined')rt_pushMoment(\\\"t4\\\");\\u003C/script\\u003E\\n        \\n        \\n\\u003Cscript\\u003EYMedia.use(\\\"media-rmp\\\", \\\"media-viewport-loader\\\", function(Y){Y.Global.Media.ViewportLoader.addContainers([{selector: \\\"#mediacontentfollowproperty_container\\\",callback: function (node) {Y.Media.RMP.load({srcNode: \\\"#mediacontentfollowproperty_container\\\",response: \\\"\\\\r\\\\n--dali-response-split-51ddaa39596e9\\\\r\\\\nContent-Type: text\\\\/plain; charset=utf-8\\\\r\\\\nRMP-Embed-Location: top\\\\r\\\\n\\\\r\\\\n\\u003Clink rel=\\\\\\\"stylesheet\\\\\\\" type=\\\\\\\"text\\\\/css\\\\\\\" href=\\\\\\\"http:\\\\/\\\\/l.yimg.com\\\\/zz\\\\/combo?os\\\\/mit\\\\/media\\\\/m\\\\/content_social\\\\/media-content-follow-property-desktop-min-1339299.css\\\\\\\" \\\\/\\u003E\\\\r\\\\n--dali-response-split-51ddaa39596e9\\\\r\\\\nContent-Type: text\\\\/plain; charset=utf-8\\\\r\\\\nRMP-Embed-Location: bottom\\\\r\\\\n\\\\r\\\\n\\u003Cscript language=\\\\\\\"javascript\\\\\\\"\\u003E\\\\n\\\\t\\\\t\\\\nYUI.YUICfg = {\\\\\\\"gallery\\\\\\\":\\\\\\\"gallery-2011.04.20-13-04\\\\\\\",\\\\\\\"groups\\\\\\\":{\\\\\\\"group01c9d8dea06e05460a64eed4dadd622b6\\\\\\\":{\\\\\\\"base\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/\\\\\\\",\\\\\\\"comboBase\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/zz\\\\\\\\\\\\/combo?\\\\\\\",\\\\\\\"modules\\\\\\\":{\\\\\\\"media-content-social-base\\\\\\\":{\\\\\\\"path\\\\\\\":\\\\\\\"os\\\\\\\\\\\\/mit\\\\\\\\\\\\/media\\\\\\\\\\\\/m\\\\\\\\\\\\/content_social\\\\\\\\\\\\/content-social-base-min-1339203.js\\\\\\\"},\\\\\\\"media-content-follow-property\\\\\\\":{\\\\\\\"path\\\\\\\":\\\\\\\"os\\\\\\\\\\\\/mit\\\\\\\\\\\\/media\\\\\\\\\\\\/m\\\\\\\\\\\\/content_social\\\\\\\\\\\\/content-follow-property-min-1306078.js\\\\\\\"}},\\\\\\\"combine\\\\\\\":true,\\\\\\\"filter\\\\\\\":\\\\\\\"min\\\\\\\",\\\\\\\"root\\\\\\\":\\\\\\\"\\\\\\\\\\\\/\\\\\\\"}},\\\\\\\"combine\\\\\\\":true,\\\\\\\"allowRollup\\\\\\\":true,\\\\\\\"comboBase\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/zz\\\\\\\\\\\\/combo?\\\\\\\",\\\\\\\"maxURLLength\\\\\\\":\\\\\\\"2000\\\\\\\"}\\\\nYUI.YUICfg.root='yui:'+YUI.version+'\\\\/build\\\\/';\\\\nYMedia.applyConfig(YUI.YUICfg);\\\\nYUI.Env[YUI.version].groups.gallery.root = 'yui:gallery-2011.04.20-13-04\\\\/build\\\\/';\\\\nYMedia.use(\\\\\\\"media-content-social-base\\\\\\\",\\\\\\\"media-content-follow-property\\\\\\\",\\\\\\\"base\\\\\\\",\\\\\\\"event\\\\\\\",\\\\\\\"node\\\\\\\",function(Y){\\\\n    \\\\t  \\\\n    Y.later(10, this, function() {new Y.Media.MediaContentFollowProperty({\\\\\\\"item_facebook\\\\\\\":{\\\\\\\"follow_url\\\\\\\":\\\\\\\"www.facebook.com\\\\\\\",\\\\\\\"follow_site\\\\\\\":\\\\\\\"facebook\\\\\\\",\\\\\\\"follow_id\\\\\\\":\\\\\\\"yahoonews\\\\\\\",\\\\\\\"follow_title\\\\\\\":\\\\\\\" on Facebook\\\\\\\",\\\\\\\"lang\\\\\\\":\\\\\\\"en_US\\\\\\\",\\\\\\\"tracking\\\\\\\":\\\\\\\"data-ylk=\\\\\\\\\\\\\\\"sec:mod-sh-fwm;itc:1;test:;act:click;slk:btn-sh-fb;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"outcome\\\\\\\":\\\\\\\"share\\\\\\\",\\\\\\\"is_tumblr\\\\\\\":false},\\\\\\\"item_twitter\\\\\\\":{\\\\\\\"follow_url\\\\\\\":\\\\\\\"twitter.com\\\\\\\",\\\\\\\"follow_site\\\\\\\":\\\\\\\"twitter\\\\\\\",\\\\\\\"follow_id\\\\\\\":\\\\\\\"yahoonews\\\\\\\",\\\\\\\"follow_title\\\\\\\":\\\\\\\" on Twitter\\\\\\\",\\\\\\\"lang\\\\\\\":\\\\\\\"en_US\\\\\\\",\\\\\\\"tracking\\\\\\\":\\\\\\\"data-ylk=\\\\\\\\\\\\\\\"sec:mod-sh-fwm;itc:1;test:;act:click;slk:btn-sh-tw;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"outcome\\\\\\\":\\\\\\\"share\\\\\\\",\\\\\\\"is_tumblr\\\\\\\":false},\\\\\\\"mod_id\\\\\\\":\\\\\\\"mediacontentfollowproperty\\\\\\\",\\\\\\\"mixer\\\\\\\":{\\\\\\\"site\\\\\\\":\\\\\\\"news\\\\\\\",\\\\\\\"region\\\\\\\":\\\\\\\"US\\\\\\\",\\\\\\\"lang\\\\\\\":\\\\\\\"en-US\\\\\\\",\\\\\\\"scrumb\\\\\\\":\\\\\\\"GYY7b.GZpxdOt6SP\\\\\\\",\\\\\\\"content_id\\\\\\\":\\\\\\\"5f01278b-803a-3803-9798-7fc79bab4f7d\\\\\\\",\\\\\\\"title_orig\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"url_orig\\\\\\\":\\\\\\\"\\\\\\\"}});});\\\\n\\\\t\\\\t   \\\\n});\\\\n\\\\nYUI.Env.add(window, \\\\\\\"load\\\\\\\", function(){\\\\nYMedia.use(\\\\\\\"\\\\\\\",function(Y){\\\\n    \\\\t  \\\\n    Y.later(10, this, function() {(function(){ var rapid = YMedia.rapid; if (rapid) { rapid.addModules(\\\\\\\"mediacontentfollowproperty\\\\\\\"); } }());\\\\n    });\\\\n});\\\\n});\\\\n\\\\t\\\\t\\\\n\\\\t    \\u003C\\\\/script\\u003E\\\\r\\\\n--dali-response-split-51ddaa39596e9\\\\r\\\\nContent-Type: text\\\\/html; charset=utf-8\\\\r\\\\n\\\\r\\\\n \\u003Csection class=\\\\\\\"yom-mod \\\\\\\" id=\\\\\\\"mediacontentfollowproperty\\\\\\\" data-ylk=\\\\\\\"mid:mediacontentfollowproperty;mpos:1;sec:mod-sh-fwm;test:;set:mod-sh-fwm;itc:1;\\\\\\\"\\u003E  \\u003Cdiv id=\\\\\\\"yom-follow-property\\\\\\\" class=\\\\\\\"yom-mod yom-follow-property\\\\\\\" data-ylk=\\\\\\\"mid:mediacontentfollowproperty;mpos:1;sec:mod-sh-fwm;test:;set:mod-sh-fwm;itc:1;\\\\\\\"\\u003E \\u003Cdiv class=\\\\\\\"hd\\\\\\\"\\u003E \\u003Ch3\\u003EFollow Yahoo! News\\u003C\\\\/h3\\u003E \\u003C\\\\/div\\u003E \\u003Cdiv class=\\\\\\\"bd\\\\\\\"\\u003E \\u003Cul\\u003E   \\u003Cli class=\\\\\\\"follow-property-facebook clearfix\\\\\\\"\\u003E \\u003Cdiv class=\\\\\\\"follow-icon\\\\\\\"\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/www.facebook.com\\\\/yahoonews\\\\\\\" role=\\\\\\\"link\\\\\\\" target=\\\\\\\"_blank\\\\\\\" title=\\\\\\\" on Facebook\\\\\\\" data-ylk=&quot;sec:mod-sh-fwm;itc:1;test:;act:click;slk:btn-sh-fb;&quot; data-action-outcome=\\\\\\\"share\\\\\\\"\\u003E\\u003Cspan\\u003E\\u003C\\\\/span\\u003E\\u003C\\\\/a\\u003E\\u003C\\\\/div\\u003E \\u003Cdiv class=\\\\\\\"follow-title\\\\\\\"\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/www.facebook.com\\\\/yahoonews\\\\\\\" role=\\\\\\\"link\\\\\\\" target=\\\\\\\"_blank\\\\\\\" title=\\\\\\\" on Facebook\\\\\\\" data-ylk=&quot;sec:mod-sh-fwm;itc:1;test:;act:click;slk:btn-sh-fb;&quot; data-action-outcome=\\\\\\\"share\\\\\\\"\\u003E on Facebook\\u003C\\\\/a\\u003E\\u003C\\\\/div\\u003E \\u003C\\\\/li\\u003E     \\u003Cli class=\\\\\\\"follow-property-twitter clearfix\\\\\\\"\\u003E \\u003Cdiv class=\\\\\\\"follow-icon\\\\\\\"\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/twitter.com\\\\/yahoonews\\\\\\\" role=\\\\\\\"link\\\\\\\" target=\\\\\\\"_blank\\\\\\\" title=\\\\\\\" on Twitter\\\\\\\" data-ylk=&quot;sec:mod-sh-fwm;itc:1;test:;act:click;slk:btn-sh-tw;&quot; data-action-outcome=\\\\\\\"share\\\\\\\"\\u003E\\u003Cspan\\u003E\\u003C\\\\/span\\u003E\\u003C\\\\/a\\u003E\\u003C\\\\/div\\u003E \\u003Cdiv class=\\\\\\\"follow-title\\\\\\\"\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/twitter.com\\\\/yahoonews\\\\\\\" role=\\\\\\\"link\\\\\\\" target=\\\\\\\"_blank\\\\\\\" title=\\\\\\\" on Twitter\\\\\\\" data-ylk=&quot;sec:mod-sh-fwm;itc:1;test:;act:click;slk:btn-sh-tw;&quot; data-action-outcome=\\\\\\\"share\\\\\\\"\\u003E on Twitter\\u003C\\\\/a\\u003E\\u003C\\\\/div\\u003E \\u003C\\\\/li\\u003E    \\u003C\\\\/ul\\u003E \\u003C\\\\/div\\u003E \\u003C\\\\/div\\u003E \\u003C\\\\/section\\u003E\\\\n\\\\r\\\\n--dali-response-split-51ddaa39596e9--\\\\r\\\\n\\\"});}}]);});\\u003C/script\\u003E\\u003C!-- fe585.global.media.bf1.yahoo.com compressed Wed Jul 10 18:38:49 UTC 2013 --\\u003E\\n\\n\\u003Cscript\\u003EYMedia.use(\\\"media-rmp\\\", \\\"media-viewport-loader\\\", function(Y){Y.Global.Media.ViewportLoader.addContainers([{selector: \\\"#mediacontentweather_container\\\",callback: function (node) {Y.Media.RMP.load({srcNode: \\\"#mediacontentweather_container\\\",response: \\\"\\\\r\\\\n--dali-response-split-51ddaa3cb982c\\\\r\\\\nContent-Type: text\\\\/plain; charset=utf-8\\\\r\\\\nRMP-Embed-Location: top\\\\r\\\\n\\\\r\\\\n\\u003Clink rel=\\\\\\\"stylesheet\\\\\\\" type=\\\\\\\"text\\\\/css\\\\\\\" href=\\\\\\\"http:\\\\/\\\\/l.yimg.com\\\\/zz\\\\/combo?rl\\\\/ulw\\\\/2.2.3\\\\/location_widget-min.css&os\\\\/mit\\\\/media\\\\/m\\\\/content_index\\\\/weather-desktop-min-1311126.css\\\\\\\" \\\\/\\u003E\\\\n\\\\n\\\\t\\\\t\\u003Cscript language=\\\\\\\"javascript\\\\\\\"\\u003E\\\\n\\\\t\\\\t\\\\nYUI.YUICfg = {\\\\\\\"gallery\\\\\\\":\\\\\\\"gallery-2011.04.20-13-04\\\\\\\",\\\\\\\"groups\\\\\\\":{\\\\\\\"group01c9d8dea06e05460a64eed4dadd622b6\\\\\\\":{\\\\\\\"base\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/\\\\\\\",\\\\\\\"comboBase\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/zz\\\\\\\\\\\\/combo?\\\\\\\",\\\\\\\"modules\\\\\\\":{\\\\\\\"media-lw-base64\\\\\\\":{\\\\\\\"path\\\\\\\":\\\\\\\"rl\\\\\\\\\\\\/ulw\\\\\\\\\\\\/2.2.3\\\\\\\\\\\\/lw-base64-min.js\\\\\\\"},\\\\\\\"media-lw-overlay\\\\\\\":{\\\\\\\"path\\\\\\\":\\\\\\\"rl\\\\\\\\\\\\/ulw\\\\\\\\\\\\/2.2.3\\\\\\\\\\\\/lw-overlay-min.js\\\\\\\"},\\\\\\\"media-locdrop-patch-2.2.4\\\\\\\":{\\\\\\\"path\\\\\\\":\\\\\\\"os\\\\\\\\\\\\/mit\\\\\\\\\\\\/media\\\\\\\\\\\\/m\\\\\\\\\\\\/weather\\\\\\\\\\\\/locdrop-patch-2.2.4-min-1275196.js\\\\\\\"}},\\\\\\\"combine\\\\\\\":true,\\\\\\\"filter\\\\\\\":\\\\\\\"min\\\\\\\",\\\\\\\"root\\\\\\\":\\\\\\\"\\\\\\\\\\\\/\\\\\\\"}},\\\\\\\"combine\\\\\\\":true,\\\\\\\"allowRollup\\\\\\\":true,\\\\\\\"comboBase\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/zz\\\\\\\\\\\\/combo?\\\\\\\",\\\\\\\"maxURLLength\\\\\\\":\\\\\\\"2000\\\\\\\"}\\\\nYUI.YUICfg.root='yui:'+YUI.version+'\\\\/build\\\\/';\\\\nYMedia.applyConfig(YUI.YUICfg);\\\\nYUI.Env[YUI.version].groups.gallery.root = 'yui:gallery-2011.04.20-13-04\\\\/build\\\\/';\\\\nYMedia.use(\\\\\\\"media-lw-base64\\\\\\\",\\\\\\\"media-lw-overlay\\\\\\\",\\\\\\\"media-locdrop-patch-2.2.4\\\\\\\",function(Y){\\\\n    \\\\t  \\\\n\\\\t\\\\t   \\\\n});\\\\n\\\\n\\\\t\\\\t\\\\n\\\\t    \\u003C\\\\/script\\u003E\\\\r\\\\n--dali-response-split-51ddaa3cb982c\\\\r\\\\nContent-Type: text\\\\/plain; charset=utf-8\\\\r\\\\nRMP-Embed-Location: bottom\\\\r\\\\n\\\\r\\\\n\\u003Cscript language=\\\\\\\"javascript\\\\\\\"\\u003E\\\\n\\\\t\\\\t\\\\nYUI.YUICfg = {\\\\\\\"gallery\\\\\\\":\\\\\\\"gallery-2011.04.20-13-04\\\\\\\",\\\\\\\"groups\\\\\\\":{\\\\\\\"group01c9d8dea06e05460a64eed4dadd622b6\\\\\\\":{\\\\\\\"base\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/\\\\\\\",\\\\\\\"comboBase\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/zz\\\\\\\\\\\\/combo?\\\\\\\",\\\\\\\"modules\\\\\\\":{\\\\\\\"media-weather\\\\\\\":{\\\\\\\"path\\\\\\\":\\\\\\\"os\\\\\\\\\\\\/mit\\\\\\\\\\\\/media\\\\\\\\\\\\/m\\\\\\\\\\\\/content_index\\\\\\\\\\\\/weather-min-1321733.js\\\\\\\"}},\\\\\\\"combine\\\\\\\":true,\\\\\\\"filter\\\\\\\":\\\\\\\"min\\\\\\\",\\\\\\\"root\\\\\\\":\\\\\\\"\\\\\\\\\\\\/\\\\\\\"}},\\\\\\\"combine\\\\\\\":true,\\\\\\\"allowRollup\\\\\\\":true,\\\\\\\"comboBase\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/zz\\\\\\\\\\\\/combo?\\\\\\\",\\\\\\\"maxURLLength\\\\\\\":\\\\\\\"2000\\\\\\\"}\\\\nYUI.YUICfg.root='yui:'+YUI.version+'\\\\/build\\\\/';\\\\nYMedia.applyConfig(YUI.YUICfg);\\\\nYUI.Env[YUI.version].groups.gallery.root = 'yui:gallery-2011.04.20-13-04\\\\/build\\\\/';\\\\nYMedia.use(\\\\\\\"media-weather\\\\\\\",function(Y){\\\\n    \\\\t  \\\\n\\\\t\\\\t   \\\\n});\\\\n\\\\nYUI.Env.add(window, \\\\\\\"load\\\\\\\", function(){\\\\nYMedia.use(\\\\\\\"media-weather\\\\\\\",\\\\\\\"jsonp\\\\\\\",\\\\\\\"jsonp-url\\\\\\\",\\\\\\\"node-focusmanager\\\\\\\",\\\\\\\"lw-overlay\\\\\\\",\\\\\\\"lw-base64\\\\\\\",\\\\\\\"ulwv2-locdrop\\\\\\\",\\\\\\\"array-extras\\\\\\\",function(Y){\\\\n    \\\\t  \\\\n    Y.later(10, this, function() {Y.Media.Weather.MediaContentWeather.Weather.init({\\\\\\\"modId\\\\\\\":\\\\\\\"mediacontentweather\\\\\\\",\\\\\\\"bucket\\\\\\\":null,\\\\\\\"crumbVal\\\\\\\":\\\\\\\"Nmx0cEd0UDU5YmU-\\\\\\\",\\\\\\\"curLocObj\\\\\\\":{\\\\\\\"addr\\\\\\\":\\\\\\\"Lafayette, Indiana, United States, 47905\\\\\\\",\\\\\\\"app\\\\\\\":\\\\\\\"yahoo.globalmedia.auth-yca.ups.env-prod\\\\\\\",\\\\\\\"cc\\\\\\\":\\\\\\\"US\\\\\\\",\\\\\\\"city\\\\\\\":\\\\\\\"Lafayette\\\\\\\",\\\\\\\"conf\\\\\\\":60,\\\\\\\"country_conf\\\\\\\":90,\\\\\\\"ctry\\\\\\\":\\\\\\\"United States\\\\\\\",\\\\\\\"ctx\\\\\\\":\\\\\\\"global\\\\\\\",\\\\\\\"dtime\\\\\\\":\\\\\\\"2013-07-10T18:38:52Z\\\\\\\",\\\\\\\"freq\\\\\\\":1,\\\\\\\"id\\\\\\\":\\\\\\\"id_current\\\\\\\",\\\\\\\"input\\\\\\\":\\\\\\\"ip\\\\\\\",\\\\\\\"lat\\\\\\\":40.424388885498,\\\\\\\"lon\\\\\\\":-86.808479309082,\\\\\\\"lvl\\\\\\\":1,\\\\\\\"rad\\\\\\\":15781,\\\\\\\"raw\\\\\\\":\\\\\\\"98.215.10.79\\\\\\\",\\\\\\\"sc\\\\\\\":\\\\\\\"IN\\\\\\\",\\\\\\\"src\\\\\\\":\\\\\\\"gt_locip\\\\\\\",\\\\\\\"state\\\\\\\":\\\\\\\"Indiana\\\\\\\",\\\\\\\"state_conf\\\\\\\":60,\\\\\\\"town_conf\\\\\\\":60,\\\\\\\"type\\\\\\\":\\\\\\\"physical\\\\\\\",\\\\\\\"woe\\\\\\\":12778444,\\\\\\\"woetype\\\\\\\":\\\\\\\"zip\\\\\\\",\\\\\\\"zip\\\\\\\":\\\\\\\"47905\\\\\\\",\\\\\\\"zip_conf\\\\\\\":60},\\\\\\\"defLocObj\\\\\\\":null,\\\\\\\"spaceId\\\\\\\":\\\\\\\"2143334674\\\\\\\",\\\\\\\"locale\\\\\\\":\\\\\\\"en-US\\\\\\\",\\\\\\\"lang\\\\\\\":\\\\\\\"US\\\\\\\",\\\\\\\"fpHost\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/weather.yahoo.com\\\\\\\",\\\\\\\"unit\\\\\\\":\\\\\\\"f\\\\\\\"});\\\\n    });\\\\n    Y.later(10, this, function() {(function(){ var rapid = YMedia.rapid; if (rapid) { rapid.addModules(\\\\\\\"mediacontentweather\\\\\\\"); } }());\\\\n    });\\\\n});\\\\n});\\\\n\\\\t\\\\t\\\\n\\\\t    \\u003C\\\\/script\\u003E\\\\r\\\\n--dali-response-split-51ddaa3cb982c\\\\r\\\\nContent-Type: text\\\\/html; charset=utf-8\\\\r\\\\n\\\\r\\\\n \\u003Csection class=\\\\\\\"yom-mod yom-weather yom-app clearfix\\\\\\\" id=\\\\\\\"mediacontentweather\\\\\\\" data-ylk=\\\\\\\"mid:mediacontentweather;mpos:1;sec:app-wea;\\\\\\\"\\u003E  \\u003Cform id=\\\\\\\"fixIE10Enter\\\\\\\" onsubmit=\\\\\\\"return false;\\\\\\\"\\u003E \\u003Ch2 class=\\\\\\\"hide\\\\\\\"\\u003EWeather Today\\u003C\\\\/h2\\u003E  \\u003Cul\\u003E  \\u003Cli class=\\\\\\\"current clearfix\\\\\\\" data-uri=\\\\\\\"http:\\\\/\\\\/weather.yahoo.com\\\\/united-states\\\\/indiana\\\\/lafayette-12778444\\\\/\\\\\\\"\\u003E \\u003Ca href=\\\\\\\"http:\\\\/\\\\/weather.yahoo.com\\\\/united-states\\\\/indiana\\\\/lafayette-12778444\\\\/\\\\\\\" data-ylk=\\\\\\\"sec:app-wea;cpos:1;pos:2;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\\\\\"\\u003E \\u003Cimg src=\\\\\\\"http:\\\\/\\\\/l4.yimg.com\\\\/dh\\\\/ap\\\\/default\\\\/121210\\\\/8_IE6.png\\\\\\\" alt=\\\\\\\"Light Rain\\\\\\\" title=\\\\\\\"Light Rain\\\\\\\" class=\\\\\\\"cond-icon\\\\\\\"\\u003E \\u003C\\\\/a\\u003E \\u003Ch3 class=\\\\\\\"hd\\\\\\\"\\u003E \\u003Cp id=\\\\\\\"weather_lw_switch\\\\\\\"\\u003E \\u003Cspan class=\\\\\\\"ell\\\\\\\" title=\\\\\\\"Lafayette, IN\\\\\\\"\\u003ELafayette, IN\\u003C\\\\/span\\u003E \\u003Cspan id=\\\\\\\"ulw-start\\\\\\\"\\u003E&nbsp;\\u003C\\\\/span\\u003E\\u003C\\\\/p\\u003E \\u003Ca href=\\\\\\\"http:\\\\/\\\\/weather.yahoo.com\\\\/united-states\\\\/indiana\\\\/lafayette-12778444\\\\/\\\\\\\" class=\\\\\\\"cond\\\\\\\" data-ylk=\\\\\\\"sec:app-wea;cpos:1;pos:1;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\\\\\"\\u003E \\u003Cem class=\\\\\\\"temp temp-f \\\\\\\"\\u003E 70\\u003Cspan class=\\\\\\\"unit\\\\\\\"\\u003E&deg;F\\u003C\\\\/span\\u003E\\u003Cspan class=\\\\\\\"cond-title\\\\\\\"\\u003ELight Rain\\u003C\\\\/span\\u003E \\u003C\\\\/em\\u003E \\u003Cem class=\\\\\\\"temp temp-c hide\\\\\\\"\\u003E 21\\u003Cspan class=\\\\\\\"unit\\\\\\\"\\u003E&deg;C\\u003C\\\\/span\\u003E\\u003Cspan class=\\\\\\\"cond-title\\\\\\\"\\u003ELight Rain\\u003C\\\\/span\\u003E \\u003C\\\\/em\\u003E \\u003C\\\\/a\\u003E \\u003C\\\\/h3\\u003E \\u003C\\\\/li\\u003E   \\u003Cli class=\\\\\\\"forecast\\\\\\\"\\u003E \\u003Ca href=\\\\\\\"http:\\\\/\\\\/weather.yahoo.com\\\\/united-states\\\\/indiana\\\\/lafayette-12778444\\\\/\\\\\\\" data-ylk=\\\\\\\"sec:app-wea;cpos:2;pos:1;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\\\\\"\\u003E \\u003Cimg src=\\\\\\\"http:\\\\/\\\\/l4.yimg.com\\\\/dh\\\\/ap\\\\/default\\\\/121210\\\\/8_IE6.png\\\\\\\" alt=\\\\\\\"\\\\\\\" class=\\\\\\\"cond-icon\\\\\\\"\\u003E \\u003C\\\\/a\\u003E \\u003Ch3 class=\\\\\\\"hd\\\\\\\"\\u003E \\u003Ca href=\\\\\\\"http:\\\\/\\\\/weather.yahoo.com\\\\/united-states\\\\/indiana\\\\/lafayette-12778444\\\\/\\\\\\\" class=\\\\\\\"ell\\\\\\\" data-ylk=\\\\\\\"sec:app-wea;cpos:2;pos:2;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\\\\\"\\u003EToday\\u003C\\\\/a\\u003E \\u003Ca href=\\\\\\\"http:\\\\/\\\\/weather.yahoo.com\\\\/united-states\\\\/indiana\\\\/lafayette-12778444\\\\/\\\\\\\" class=\\\\\\\"temp temp-f \\\\\\\" data-ylk=\\\\\\\"sec:app-wea;cpos:2;pos:3;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\\\\\"\\u003E \\u003Cspan class=\\\\\\\"high\\\\\\\"\\u003E84&deg;\\u003C\\\\/span\\u003E \\u003Cspan class=\\\\\\\"low\\\\\\\"\\u003E60&deg;\\u003C\\\\/span\\u003E \\u003C\\\\/a\\u003E \\u003Ca href=\\\\\\\"http:\\\\/\\\\/weather.yahoo.com\\\\/united-states\\\\/indiana\\\\/lafayette-12778444\\\\/\\\\\\\" class=\\\\\\\"temp temp-c hide\\\\\\\" data-ylk=\\\\\\\"sec:app-wea;cpos:2;pos:3;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\\\\\"\\u003E \\u003Cspan class=\\\\\\\"high\\\\\\\"\\u003E29&deg;\\u003C\\\\/span\\u003E \\u003Cspan class=\\\\\\\"low\\\\\\\"\\u003E16&deg;\\u003C\\\\/span\\u003E \\u003C\\\\/a\\u003E \\u003C\\\\/h3\\u003E \\u003C\\\\/li\\u003E  \\u003Cli class=\\\\\\\"forecast\\\\\\\"\\u003E \\u003Ca href=\\\\\\\"http:\\\\/\\\\/weather.yahoo.com\\\\/united-states\\\\/indiana\\\\/lafayette-12778444\\\\/\\\\\\\" data-ylk=\\\\\\\"sec:app-wea;cpos:3;pos:1;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\\\\\"\\u003E \\u003Cimg src=\\\\\\\"http:\\\\/\\\\/l4.yimg.com\\\\/dh\\\\/ap\\\\/default\\\\/121210\\\\/33_IE6.png\\\\\\\" alt=\\\\\\\"\\\\\\\" class=\\\\\\\"cond-icon\\\\\\\"\\u003E \\u003C\\\\/a\\u003E \\u003Ch3 class=\\\\\\\"hd\\\\\\\"\\u003E \\u003Ca href=\\\\\\\"http:\\\\/\\\\/weather.yahoo.com\\\\/united-states\\\\/indiana\\\\/lafayette-12778444\\\\/\\\\\\\" class=\\\\\\\"ell\\\\\\\" data-ylk=\\\\\\\"sec:app-wea;cpos:3;pos:2;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\\\\\"\\u003ETomorrow\\u003C\\\\/a\\u003E \\u003Ca href=\\\\\\\"http:\\\\/\\\\/weather.yahoo.com\\\\/united-states\\\\/indiana\\\\/lafayette-12778444\\\\/\\\\\\\" class=\\\\\\\"temp temp-f \\\\\\\" data-ylk=\\\\\\\"sec:app-wea;cpos:3;pos:3;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\\\\\"\\u003E \\u003Cspan class=\\\\\\\"high\\\\\\\"\\u003E81&deg;\\u003C\\\\/span\\u003E \\u003Cspan class=\\\\\\\"low\\\\\\\"\\u003E55&deg;\\u003C\\\\/span\\u003E \\u003C\\\\/a\\u003E \\u003Ca href=\\\\\\\"http:\\\\/\\\\/weather.yahoo.com\\\\/united-states\\\\/indiana\\\\/lafayette-12778444\\\\/\\\\\\\" class=\\\\\\\"temp temp-c hide\\\\\\\" data-ylk=\\\\\\\"sec:app-wea;cpos:3;pos:3;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\\\\\"\\u003E \\u003Cspan class=\\\\\\\"high\\\\\\\"\\u003E27&deg;\\u003C\\\\/span\\u003E \\u003Cspan class=\\\\\\\"low\\\\\\\"\\u003E13&deg;\\u003C\\\\/span\\u003E \\u003C\\\\/a\\u003E \\u003C\\\\/h3\\u003E \\u003C\\\\/li\\u003E  \\u003Cli class=\\\\\\\"forecast\\\\\\\"\\u003E \\u003Ca href=\\\\\\\"http:\\\\/\\\\/weather.yahoo.com\\\\/united-states\\\\/indiana\\\\/lafayette-12778444\\\\/\\\\\\\" data-ylk=\\\\\\\"sec:app-wea;cpos:4;pos:1;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\\\\\"\\u003E \\u003Cimg src=\\\\\\\"http:\\\\/\\\\/l4.yimg.com\\\\/dh\\\\/ap\\\\/default\\\\/121210\\\\/31_IE6.png\\\\\\\" alt=\\\\\\\"\\\\\\\" class=\\\\\\\"cond-icon\\\\\\\"\\u003E \\u003C\\\\/a\\u003E \\u003Ch3 class=\\\\\\\"hd\\\\\\\"\\u003E \\u003Ca href=\\\\\\\"http:\\\\/\\\\/weather.yahoo.com\\\\/united-states\\\\/indiana\\\\/lafayette-12778444\\\\/\\\\\\\" class=\\\\\\\"ell\\\\\\\" data-ylk=\\\\\\\"sec:app-wea;cpos:4;pos:2;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\\\\\"\\u003EFriday\\u003C\\\\/a\\u003E \\u003Ca href=\\\\\\\"http:\\\\/\\\\/weather.yahoo.com\\\\/united-states\\\\/indiana\\\\/lafayette-12778444\\\\/\\\\\\\" class=\\\\\\\"temp temp-f \\\\\\\" data-ylk=\\\\\\\"sec:app-wea;cpos:4;pos:3;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\\\\\"\\u003E \\u003Cspan class=\\\\\\\"high\\\\\\\"\\u003E79&deg;\\u003C\\\\/span\\u003E \\u003Cspan class=\\\\\\\"low\\\\\\\"\\u003E57&deg;\\u003C\\\\/span\\u003E \\u003C\\\\/a\\u003E \\u003Ca href=\\\\\\\"http:\\\\/\\\\/weather.yahoo.com\\\\/united-states\\\\/indiana\\\\/lafayette-12778444\\\\/\\\\\\\" class=\\\\\\\"temp temp-c hide\\\\\\\" data-ylk=\\\\\\\"sec:app-wea;cpos:4;pos:3;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\\\\\"\\u003E \\u003Cspan class=\\\\\\\"high\\\\\\\"\\u003E26&deg;\\u003C\\\\/span\\u003E \\u003Cspan class=\\\\\\\"low\\\\\\\"\\u003E14&deg;\\u003C\\\\/span\\u003E \\u003C\\\\/a\\u003E \\u003C\\\\/h3\\u003E \\u003C\\\\/li\\u003E  \\u003C\\\\/ul\\u003E   \\u003C\\\\/form\\u003E \\u003Cdiv class=\\\\\\\"weather_credit\\\\\\\"\\u003E \\u003Cspan class=\\\\\\\"weather_credit_text\\\\\\\"\\u003EPowered by\\u003C\\\\/span\\u003E \\u003Ca href=\\\\\\\"http:\\\\/\\\\/www.weather.com\\\\\\\" class=\\\\\\\"twc_icon\\\\\\\"\\u003E \\u003Cspan class=\\\\\\\"weather_twc_icon\\\\\\\"\\\\/\\u003E\\u003C\\\\/span\\u003E \\u003C\\\\/a\\u003E \\u003C\\\\/div\\u003E \\u003C\\\\/section\\u003E\\\\n\\\\r\\\\n--dali-response-split-51ddaa3cb982c--\\\\r\\\\n\\\"});}}]);});\\u003C/script\\u003E\\u003C!-- fe702.global.media.bf1.yahoo.com compressed Wed Jul 10 18:38:52 UTC 2013 --\\u003E\\n\\n\\u003Cscript\\u003EYMedia.use(\\\"media-rmp\\\", function(Y){Y.Media.RMP.load({srcNode: \\\"#p_30345786_container\\\", continueOnError: true, response:\\\"--dali-response-split-51ddaa3c96973Content-Type: text\\\\/plain; charset=utf-8\\\\nRMP-Embed-Location: top\\\\n\\\\n\\\\n\\u003Clink rel=\\\\\\\"stylesheet\\\\\\\" type=\\\\\\\"text\\\\/css\\\\\\\" href=\\\\\\\"http:\\\\/\\\\/l.yimg.com\\\\/zz\\\\/combo?nn\\\\/lib\\\\/metro\\\\/g\\\\/ui\\\\/helpers_0.0.6.css&nn\\\\/lib\\\\/metro\\\\/g\\\\/ui\\\\/typography_0.0.2.css&nn\\\\/lib\\\\/metro\\\\/g\\\\/theme\\\\/default\\\\/common_0.0.29.css&nn\\\\/lib\\\\/metro\\\\/g\\\\/theme\\\\/default\\\\/desktop_0.0.62.css&nn\\\\/lib\\\\/metro\\\\/g\\\\/uiplugins\\\\/tooltip_service_1.0.12.css\\\\\\\" \\\\/\\u003E\\\\n\\\\n\\u003Clink rel=\\\\\\\"stylesheet\\\\\\\" type=\\\\\\\"text\\\\/css\\\\\\\" href=\\\\\\\"http:\\\\/\\\\/l.yimg.com\\\\/zz\\\\/combo?nn\\\\/lib\\\\/metro\\\\/g\\\\/stream\\\\/stream_0.0.271.css&nn\\\\/lib\\\\/metro\\\\/g\\\\/stream\\\\/theme_gs_0.0.45.css&nn\\\\/lib\\\\/metro\\\\/g\\\\/uiplugins\\\\/login_service_0.0.3.css&nn\\\\/lib\\\\/metro\\\\/g\\\\/stream\\\\/rmx_ads_0.0.8.css&nn\\\\/lib\\\\/metro\\\\/g\\\\/fstream\\\\/fstream_desktop_0.0.21.css&nn\\\\/lib\\\\/metro\\\\/g\\\\/login\\\\/login_0.0.71.css\\\\\\\" \\\\/\\u003E\\\\n\\\\n--dali-response-split-51ddaa3c96973Content-Type: text\\\\/html; charset=utf-8\\\\nRMP-Embed-Location: bottom\\\\n\\\\n\\u003Cdiv id=\\\\\\\"p_30345786\\\\\\\" class=\\\\\\\"rapidnofollow rapid-container dev-desktop\\\\\\\" data-ylk=\\\\\\\"sec:td-strm\\\\\\\"\\u003E\\\\n\\u003Cdiv id=\\\\\\\"default-u_30345786\\\\\\\" class=\\\\\\\"mod view_default\\\\\\\"\\u003E  \\u003Cdiv id=\\\\\\\"default-u_30345786-bd\\\\\\\" class=\\\\\\\"bd type_stream type_stream_default\\\\\\\"\\u003E\\u003Cdiv id=\\\\\\\"default-p_30345810_eab\\\\\\\" class=\\\\\\\"mod view_default\\\\\\\"\\u003E  \\u003Cdiv id=\\\\\\\"default-p_30345810_eab-bd\\\\\\\" class=\\\\\\\"bd type_fstream type_fstream_default\\\\\\\"\\u003E\\u003Cstyle\\u003E .type_fstream .dropdown-label-text, .type_fstream .tab-list .filter-item .filter-name, .type_fstream .filter-bar-section { background-color:#0e2b5c !important;border:solid 1px #0e2b5c !important;color:#fff !important } .type_fstream .tab-list .filter-item { opacity: 0.7; -ms-filter:\\\\\\\"progid:DXImageTransform.Microsoft.Alpha(Opacity=70)\\\\\\\"; filter: alpha(opacity=70); }.type_fstream .tab-list .filter-selected { opacity: 1; -ms-filter:\\\\\\\"progid:DXImageTransform.Microsoft.Alpha(Opacity=100)\\\\\\\"; filter: alpha(opacity=100); }\\u003C\\\\/style\\u003E\\u003Cdiv class=\\\\\\\"filter-bar-section\\\\\\\"\\u003E\\u003Cul class=\\\\\\\"tab-list d-ib fz-xs pos-r\\\\\\\"\\u003E\\u003Cli class=\\\\\\\"filter-item d-ib\\\\\\\" data-filter=\\\\\\\"\\\\\\\"\\u003E\\\\n    \\u003Ca href=\\\\\\\"#\\\\\\\" data-ylk=\\\\\\\"sec:fltr-strm;slk:YPROP:TOPSTORIES;cpos:1;pos:0;ft:1\\\\\\\"  data-action-outcome=\\\\\\\"filter\\\\\\\" class=\\\\\\\"filter-name rapidnofollow fz-s\\\\\\\" role=\\\\\\\"button\\\\\\\"\\u003EAll News\\u003C\\\\/a\\u003E\\\\n\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"filter-item d-ib\\\\\\\" data-filter=\\\\\\\"LISTID:c435b248-2107-445e-97ea-89e2ec5df60c\\\\\\\"\\u003E\\\\n    \\u003Ca href=\\\\\\\"#\\\\\\\" data-ylk=\\\\\\\"sec:fltr-strm;slk:LISTID:c435b248-2107-445e-97ea-89e2ec5df60c;cpos:2;pos:0;ft:1\\\\\\\"  data-action-outcome=\\\\\\\"filter\\\\\\\" class=\\\\\\\"filter-name rapidnofollow fz-s\\\\\\\" role=\\\\\\\"button\\\\\\\"\\u003EY! News Originals\\u003C\\\\/a\\u003E\\\\n\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"filter-item d-ib\\\\\\\" data-filter=\\\\\\\"YPROV:ABCNEWS\\\\\\\"\\u003E\\\\n    \\u003Ca href=\\\\\\\"#\\\\\\\" data-ylk=\\\\\\\"sec:fltr-strm;slk:YPROV:ABCNEWS;cpos:3;pos:0;ft:1\\\\\\\"  data-action-outcome=\\\\\\\"filter\\\\\\\" class=\\\\\\\"filter-name rapidnofollow fz-s\\\\\\\" role=\\\\\\\"button\\\\\\\"\\u003EABC News\\u003C\\\\/a\\u003E\\\\n\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"filter-item d-ib\\\\\\\" data-filter=\\\\\\\"YPROV:ap.org\\\\\\\"\\u003E\\\\n    \\u003Ca href=\\\\\\\"#\\\\\\\" data-ylk=\\\\\\\"sec:fltr-strm;slk:YPROV:ap.org;cpos:4;pos:0;ft:1\\\\\\\"  data-action-outcome=\\\\\\\"filter\\\\\\\" class=\\\\\\\"filter-name rapidnofollow fz-s\\\\\\\" role=\\\\\\\"button\\\\\\\"\\u003EAP\\u003C\\\\/a\\u003E\\\\n\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"filter-item d-ib\\\\\\\" data-filter=\\\\\\\"YPROV:reuters.com\\\\\\\"\\u003E\\\\n    \\u003Ca href=\\\\\\\"#\\\\\\\" data-ylk=\\\\\\\"sec:fltr-strm;slk:YPROV:reuters.com;cpos:5;pos:0;ft:1\\\\\\\"  data-action-outcome=\\\\\\\"filter\\\\\\\" class=\\\\\\\"filter-name rapidnofollow fz-s\\\\\\\" role=\\\\\\\"button\\\\\\\"\\u003EReuters\\u003C\\\\/a\\u003E\\\\n\\u003C\\\\/li\\u003E\\u003C\\\\/ul\\u003E\\u003C\\\\/div\\u003E    \\u003C\\\\/div\\u003E\\\\n\\u003C\\\\/div\\u003E\\u003Cul\\u003E\\u003Cli class=\\\\\\\"content has-image voh-parent cf\\\\\\\" data-uuid=\\\\\\\"a2b156e2-bdc5-3dab-bf3c-241d681ef099\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:1;pkgt:4;ccode:news;g:a2b156e2-bdc5-3dab-bf3c-241d681ef099;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fnews.yahoo.com%2Fexpert-zimmerman-worse-shape-martin-144959889.html\\\\\\\" data-wikiids=\\\\\\\"YCT:001000667|YCT:001000780|WIKIID:Shooting_of_Trayvon_Martin\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"img ov-h thumb-left  \\\\\\\" href=\\\\\\\"\\\\/expert-zimmerman-worse-shape-martin-144959889.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:1;g:a2b156e2-bdc5-3dab-bf3c-241d681ef099;tar:news.yahoo.com;ltxt:Expert:Z;ct:1;pkgt:4;r:4100002718;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" tabindex=\\\\\\\"-1\\\\\\\"\\u003E\\u003Cimg src=\\\\\\\"http:\\\\/\\\\/l.yimg.com\\\\/os\\\\/mit\\\\/media\\\\/m\\\\/base\\\\/images\\\\/transparent-95031.png\\\\\\\" style=\\\\\\\"margin-left:-15px;background-image:url('http:\\\\/\\\\/l1.yimg.com\\\\/ts\\\\/api\\\\/res\\\\/1.2\\\\/XITng7YWKM1CwU3GfV_RdA--\\\\/YXBwaWQ9eWhvbWVydW47cT04NTtzbT0xO3c9MjUwO2g9MTg1\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/ap_webfeeds\\\\/d475fdac10c72e17370f6a706700275c.jpg');\\\\\\\" width=\\\\\\\"111\\\\\\\" height=\\\\\\\"82\\\\\\\" alt=\\\\\\\"\\\\\\\" title=\\\\\\\"\\\\\\\" class=\\\\\\\"lzbg\\\\\\\"\\u003E\\u003C\\\\/a\\u003E\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\u003E\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"\\\\/expert-zimmerman-worse-shape-martin-144959889.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:1;g:a2b156e2-bdc5-3dab-bf3c-241d681ef099;tar:news.yahoo.com;ltxt:Expert:Z;ct:1;pkgt:4;r:4100002718;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\u003EExpert: Zimmerman was in worse shape than Martin\\u003C\\\\/a\\u003E\\u003C\\\\/h3\\u003E\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\u003ESANFORD, Fla. (AP) \\\\u2014 A Florida judge ruled Wednesday that Trayvon Martin&#39;s cellphone text messages about fighting and a defense animation depicting the struggle between Martin and George Zimmerman won&#39;t be introduced as evidence at Zimmerman&#39;s trial. Defense attorneys had wanted to use those pieces\\\\u2026\\u003C\\\\/p\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\u003E\\u003Cspan class=\\\\\\\"source\\\\\\\"\\u003EAssociated Press\\u003C\\\\/span\\u003E\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\u003E\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/news.yahoo.com\\\\/society-and-culture\\\\/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"YCT:001000780\\\\\\\" data-ylk=\\\\\\\"slk:Society;sec:td-strm;cpos:1;itc:0;g:a2b156e2-bdc5-3dab-bf3c-241d681ef099;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\u003ESociety\\u003C\\\\/a\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/www.yahoo.com\\\\/topic\\\\/shooting-of-trayvon-martin\\\\/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"WIKIID:Shooting_of_Trayvon_Martin\\\\\\\" data-ylk=\\\\\\\"slk:Shooting of Trayvon Martin;sec:td-strm;cpos:2;itc:0;g:a2b156e2-bdc5-3dab-bf3c-241d681ef099;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\u003EShooting of Trayvon Martin\\u003C\\\\/a\\u003E\\u003C\\\\/li\\u003E\\u003C\\\\/ul\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\u003E\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\u003ERemove\\u003C\\\\/button\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"content voh-parent cf\\\\\\\" data-uuid=\\\\\\\"359b4757-f472-3d49-a211-389223ffe98a\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:2;pkgt:3;ccode:news;g:359b4757-f472-3d49-a211-389223ffe98a;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fnews.yahoo.com%2Fgop-remember-data-show-immigrants-enforce-not-threaten-171614860.html\\\\\\\" data-wikiids=\\\\\\\"YCT:001000661|YCT:001000700|WIKIID:Culture_of_the_United_States\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\u003E\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"\\\\/gop-remember-data-show-immigrants-enforce-not-threaten-171614860.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:2;g:359b4757-f472-3d49-a211-389223ffe98a;tar:news.yahoo.com;ltxt:GOPshoul;ct:1;pkgt:3;r:4100001700;slk:title;itc:0;prov:ChristianScience;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\u003EGOP should remember: Data show immigrants enforce, not threaten, US values\\u003C\\\\/a\\u003E\\u003C\\\\/h3\\u003E\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\u003EA comprehensive immigration reform bill has passed the Senate, but it faces dubious prospects in the House, where it probably won\\\\u2019t garner enough of the Republican support needed to bring it to a floor vote. One Republican sticking point is that the prospective law doesn\\\\u2019t go far enough to ensure\\\\u2026\\u003C\\\\/p\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\u003E\\u003Cspan class=\\\\\\\"source\\\\\\\"\\u003EChristian Science Monitor\\u003C\\\\/span\\u003E\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\u003E\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/news.yahoo.com\\\\/politics-and-government\\\\/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"YCT:001000661\\\\\\\" data-ylk=\\\\\\\"slk:Politics;sec:td-strm;cpos:1;itc:0;g:359b4757-f472-3d49-a211-389223ffe98a;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\u003EPolitics\\u003C\\\\/a\\u003E\\u003C\\\\/li\\u003E\\u003C\\\\/ul\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\u003E\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\u003ERemove\\u003C\\\\/button\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"content rmx-ad has-image voh-parent cf\\\\\\\" data-uuid=\\\\\\\"21671635\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:3;pkgt:4;ccode:news;g:21671635;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fad.yieldmanager.com%2Fclk%3F3%2CeJytjd8KgjAYxV.Ii03d3BhdTKdi6SxahZfDP0NNghCknr40qRfoB-fjHL4DBzoM4NrTutIexLTGoGTQaUpag6aqkAUYY7ZHMfIQocTiM3syHiah7v3NX7I4SjXxD-Yt3wRrb76hcHZar--z7Q.8LwR0y5PVJ8uuEYSj5mkeivjfWly4mS1bKUI3vZxQHhdjpqJr1sJWdiVKVTjJjoNiiIZcyF7-BjaWBV6lHk77%2Chttp%253A%252F%252Fad.doubleclick.net%252Fclk%253B274020025%253B100435305%253Be%253Fhttp%253A%252F%252Fspectrum2.pch.com%252FPath%252FJulyTV2013SitespectControl%252FStart.aspx%253Ftid%253D7e9b938d-f8ce-489a-bdef-81f419556b96%2526utm_source%253DYahoo%2526utm_medium%253Dcpc%2526utm_campaign%253DYahoo_Stream_Ad15\\\\\\\" data-wikiids=\\\\\\\"\\\\\\\" data-rmx-beacon=\\\\\\\"http:\\\\/\\\\/ad.yieldmanager.com\\\\/csc?ve=2&1hrw95l2wp0XrFYnLhJqzLriWXhdDwpnt4Kf8wPuQSdLFrDaBJiYaKu9f1YrQOidHRIOdpedQRTCvjgtn02eC7Z.kUCxocI7GY.iTTTyz1z9dQiud2A_gKVQ6OIxOTIR5cFUThlHzJQWkyL5X1ciNIdkmpatnBHwKLAKPqs6I_4yWYRJTXbVPyik7I1NKh.tyFCWf1UkfkF2Sgq.gXbfEHQYDwxYJbqQyzukOp0e8wvfBzwRHGSEex.SIRDn1Qvd_bYkVW3v52haZ5uXOsSaZxkj7hZd4sQq61ZJQb7DH8gwceeen.qgGa_LfI8XVDHpJTbx4rQ6ElpR9lwZUJjGbvvYdIiS06cOu.oZZzRJIShdNUTlN4USP27Qs8zP7eUC6e3.yYlPsePXNnYWBzrfkA.qZBIK6Wmj8AJaB5Q__6zTcGJs6mPBDjJLQ7VDfm52vpQADTT3RIcQy40cepLkw2TeLCCI3vHJgpDQPvDYw9BOF9_pamfg7Yp0On6SlPTv28c.iqT6.oMcn9nGoiTHgT336BzgkFd.9XUZVVEvXNhIjGTa0iWtdrqWkLHs8Qol7MNcNxfD.Or_gkholvmdAG6lb6__Al.Py2gFkLbWJ.Xoet5wOI7Lo0KaeLXCUpTNEmklwkYhxsNLaRk8Jb0R7zZNita2HETQb92McUTc15px6SBP983kJetQ8RMGEa1xvgIF_FmQoXR2sSCblmyfouYyDMCAZl3pj4_Ij4JD3zgwGp4rj3SCBMx_FWfD9Wr7wl3sCrjXTxu0n079i2LlbGeeq3tdEPjpZMypM.GozXdvMRIkndXbIihqK9iPM.MJlw--&ap=3\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"img ov-h thumb-left  \\\\\\\" href=\\\\\\\"http:\\\\/\\\\/ad.yieldmanager.com\\\\/clk?3,eJytjd8KgjAYxV.Ii03d3BhdTKdi6SxahZfDP0NNghCknr40qRfoB-fjHL4DBzoM4NrTutIexLTGoGTQaUpag6aqkAUYY7ZHMfIQocTiM3syHiah7v3NX7I4SjXxD-Yt3wRrb76hcHZar--z7Q.8LwR0y5PVJ8uuEYSj5mkeivjfWly4mS1bKUI3vZxQHhdjpqJr1sJWdiVKVTjJjoNiiIZcyF7-BjaWBV6lHk77,http%3A%2F%2Fad.doubleclick.net%2Fclk%3B274020025%3B100435305%3Be%3Fhttp%3A%2F%2Fspectrum2.pch.com%2FPath%2FJulyTV2013SitespectControl%2FStart.aspx%3Ftid%3D7e9b938d-f8ce-489a-bdef-81f419556b96%26utm_source%3DYahoo%26utm_medium%3Dcpc%26utm_campaign%3DYahoo_Stream_Ad15\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:3;g:21671635;tar:ad.yieldmanager.com;ltxt:$5,000aW;ct:1;pkgt:4;ad:1;slk:title;itc:0;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" target=\\\\\\\"_blank\\\\\\\" tabindex=\\\\\\\"-1\\\\\\\"\\u003E\\u003Cimg src=\\\\\\\"http:\\\\/\\\\/l.yimg.com\\\\/os\\\\/mit\\\\/media\\\\/m\\\\/base\\\\/images\\\\/transparent-95031.png\\\\\\\" style=\\\\\\\"background-image:url('http:\\\\/\\\\/l5.yimg.com\\\\/av\\\\/moneyball\\\\/ads\\\\/0-1372704499-6168.jpg');\\\\\\\" width=\\\\\\\"82\\\\\\\" height=\\\\\\\"82\\\\\\\" alt=\\\\\\\"\\\\\\\" title=\\\\\\\"\\\\\\\" class=\\\\\\\"lzbg\\\\\\\"\\u003E\\u003C\\\\/a\\u003E\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\u003E\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"http:\\\\/\\\\/ad.yieldmanager.com\\\\/clk?3,eJytjd8KgjAYxV.Ii03d3BhdTKdi6SxahZfDP0NNghCknr40qRfoB-fjHL4DBzoM4NrTutIexLTGoGTQaUpag6aqkAUYY7ZHMfIQocTiM3syHiah7v3NX7I4SjXxD-Yt3wRrb76hcHZar--z7Q.8LwR0y5PVJ8uuEYSj5mkeivjfWly4mS1bKUI3vZxQHhdjpqJr1sJWdiVKVTjJjoNiiIZcyF7-BjaWBV6lHk77,http%3A%2F%2Fad.doubleclick.net%2Fclk%3B274020025%3B100435305%3Be%3Fhttp%3A%2F%2Fspectrum2.pch.com%2FPath%2FJulyTV2013SitespectControl%2FStart.aspx%3Ftid%3D7e9b938d-f8ce-489a-bdef-81f419556b96%26utm_source%3DYahoo%26utm_medium%3Dcpc%26utm_campaign%3DYahoo_Stream_Ad15\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:3;g:21671635;tar:ad.yieldmanager.com;ltxt:$5,000aW;ct:1;pkgt:4;ad:1;slk:title;itc:0;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" target=\\\\\\\"_blank\\\\\\\"\\u003E$5,000 a Week &quot;Forever&quot; Contest \\u003C\\\\/a\\u003E\\u003C\\\\/h3\\u003E\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\u003EPass Your Prize To Your Loved Ones. Don't Wait, Enter Now at PCH.com! \\u003C\\\\/p\\u003E\\u003Ca class=\\\\\\\"adlink fz-xxs rapid-noclick-resp\\\\\\\" href=\\\\\\\"http:\\\\/\\\\/info.yahoo.com\\\\/privacy\\\\/us\\\\/yahoo\\\\/adinfo_geo.html\\\\\\\" target=\\\\\\\"_blank\\\\\\\"\\u003EAdChoices\\u003Ci class=\\\\\\\"img-sprite\\\\\\\"\\u003E\\u003C\\\\/i\\u003E\\u003C\\\\/a\\u003E\\\\n\\u003Ca class=\\\\\\\"fz-xxs adv rapid-noclick-resp\\\\\\\" href=\\\\\\\"http:\\\\/\\\\/ad.yieldmanager.com\\\\/clk?3,eJytjd8KgjAYxV.Ii03d3BhdTKdi6SxahZfDP0NNghCknr40qRfoB-fjHL4DBzoM4NrTutIexLTGoGTQaUpag6aqkAUYY7ZHMfIQocTiM3syHiah7v3NX7I4SjXxD-Yt3wRrb76hcHZar--z7Q.8LwR0y5PVJ8uuEYSj5mkeivjfWly4mS1bKUI3vZxQHhdjpqJr1sJWdiVKVTjJjoNiiIZcyF7-BjaWBV6lHk77,http%3A%2F%2Fad.doubleclick.net%2Fclk%3B274020025%3B100435305%3Be%3Fhttp%3A%2F%2Fspectrum2.pch.com%2FPath%2FJulyTV2013SitespectControl%2FStart.aspx%3Ftid%3D7e9b938d-f8ce-489a-bdef-81f419556b96%26utm_source%3DYahoo%26utm_medium%3Dcpc%26utm_campaign%3DYahoo_Stream_Ad15\\\\\\\" target=\\\\\\\"_blank\\\\\\\"\\u003E\\u003Cspan class=\\\\\\\"source\\\\\\\"\\u003EPCH.com\\u003C\\\\/span\\u003E\\u003C\\\\/a\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/help.yahoo.com\\\\/kb\\\\/index?page=content&y=PROD_FRONT&locale=en_US&id=SLN14553\\\\\\\" class=\\\\\\\"fz-xxs sp rapid-noclick-resp\\\\\\\" target=\\\\\\\"_blank\\\\\\\"\\u003ESponsored\\u003C\\\\/a\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\u003E\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\u003E\\u003C\\\\/ul\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"content voh-parent cf\\\\\\\" data-uuid=\\\\\\\"950129f1-e974-33ae-b739-227b6ca2e187\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:4;pkgt:3;ccode:news;g:950129f1-e974-33ae-b739-227b6ca2e187;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fnews.yahoo.com%2Fblogs%2Ftrending-now%2Ftoddler-buys-car-ebay-using-father-smartphone-172026670.html\\\\\\\" data-wikiids=\\\\\\\"\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\u003E\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"\\\\/blogs\\\\/trending-now\\\\/toddler-buys-car-ebay-using-father-smartphone-172026670.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:4;g:950129f1-e974-33ae-b739-227b6ca2e187;tar:news.yahoo.com;ltxt:ToddlerB;ct:2;pkgt:3;r:4100001324;slk:title;itc:0;prov:TrendingNow;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\u003EToddler Buys Car on eBay Using Father\\\\u2019s Smartphone\\u003C\\\\/a\\u003E\\u003C\\\\/h3\\u003E\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\u003ELast month Sorella Stoute from Portland, Oregon, purchased a 1962 Austin-Healey Sprite on eBay. Now, this might not sound like much of a story, until you learn that Sorella is only 14 months old. Here&#39;s what happened. The tiny online shopper was playing with her father Paul Stoute&#39;s smartphone when\\\\u2026\\u003C\\\\/p\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\u003E\\u003Cspan class=\\\\\\\"source\\\\\\\"\\u003ETrending Now\\u003C\\\\/span\\u003E\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\u003E\\u003C\\\\/ul\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\u003E\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\u003ERemove\\u003C\\\\/button\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"content voh-parent cf\\\\\\\" data-uuid=\\\\\\\"a5d908b7-4f0c-3334-81a0-3d378bbeb520\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:5;pkgt:3;ccode:news;g:a5d908b7-4f0c-3334-81a0-3d378bbeb520;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fnews.yahoo.com%2Fntsb-findings-sf-plane-crash-133726993.html\\\\\\\" data-wikiids=\\\\\\\"YCT:001000346|YCT:001000992\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\u003E\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"\\\\/ntsb-findings-sf-plane-crash-133726993.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:5;g:a5d908b7-4f0c-3334-81a0-3d378bbeb520;tar:news.yahoo.com;ltxt:NTSBfind;ct:1;pkgt:3;r:4100001409;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\u003ENTSB findings on SF plane crash at a glance\\u003C\\\\/a\\u003E\\u003C\\\\/h3\\u003E\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\u003EAfter departing from Shanghai and stopping in Seoul, Asiana Flight 214 makes its final approach into San Francisco International Airport following a 10-hour flight across the Pacific Ocean. A preliminary ...\\u003C\\\\/p\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\u003E\\u003Cspan class=\\\\\\\"source\\\\\\\"\\u003EAssociated Press\\u003C\\\\/span\\u003E\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\u003E\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/news.yahoo.com\\\\/personal-investing-ideas-and-strategies\\\\/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"YCT:001000346\\\\\\\" data-ylk=\\\\\\\"slk:Personal Investing Ideas & Strategies;sec:td-strm;cpos:1;itc:0;g:a5d908b7-4f0c-3334-81a0-3d378bbeb520;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\u003EPersonal Investing Ideas & Strategies\\u003C\\\\/a\\u003E\\u003C\\\\/li\\u003E\\u003C\\\\/ul\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\u003E\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\u003ERemove\\u003C\\\\/button\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"content voh-parent cf\\\\\\\" data-uuid=\\\\\\\"fe94cddd-d36b-3ce5-9246-733c1229ba93\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:6;pkgt:3;ccode:news;g:fe94cddd-d36b-3ce5-9246-733c1229ba93;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fgma.yahoo.com%2Fblogs%2Fabc-blogs%2Froyal-baby-american-british-birthing-practices-differ-115918234.html\\\\\\\" data-wikiids=\\\\\\\"YCT:001000395|YCT:001000495\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\u003E\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"http:\\\\/\\\\/gma.yahoo.com\\\\/blogs\\\\/abc-blogs\\\\/royal-baby-american-british-birthing-practices-differ-115918234.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:6;g:fe94cddd-d36b-3ce5-9246-733c1229ba93;tar:gma.yahoo.com;ltxt:HowKate&;ct:2;pkgt:3;r:4100001177;slk:title;itc:0;prov:ABCNews;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\u003EHow Kate&#39;s Delivery Will Differ From U.S. Experience\\u003C\\\\/a\\u003E\\u003C\\\\/h3\\u003E\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\u003EThe future British monarch is due to be born any day now. Kate Middleton will deliver her child at Mary\\\\u2019s Hospital in London, in the same wing where Princess Diana gave birth to her own children. \\\\u201cIt\\\\u2019s a beautiful unit,\\\\u201d Regina Curran, a British midwife,...\\u003C\\\\/p\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\u003E\\u003Cspan class=\\\\\\\"source\\\\\\\"\\u003EABC News\\u003C\\\\/span\\u003E\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\u003E\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/news.yahoo.com\\\\/health\\\\/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"YCT:001000395\\\\\\\" data-ylk=\\\\\\\"slk:Health;sec:td-strm;cpos:1;itc:0;g:fe94cddd-d36b-3ce5-9246-733c1229ba93;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\u003EHealth\\u003C\\\\/a\\u003E\\u003C\\\\/li\\u003E\\u003C\\\\/ul\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\u003E\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\u003ERemove\\u003C\\\\/button\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"content voh-parent cf\\\\\\\" data-uuid=\\\\\\\"8714ae80-beb0-39b6-9ee1-bd13ffb3f5c5\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:7;pkgt:3;ccode:news;g:8714ae80-beb0-39b6-9ee1-bd13ffb3f5c5;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fgma.yahoo.com%2Fblogs%2Fabc-blogs%2Fprince-william-play-polo-while-nine-months-pregnant-150649675.html\\\\\\\" data-wikiids=\\\\\\\"YCT:001000069|YCT:001000070|WIKIID:Prince_Harry_of_Wales|WIKIID:Kensington_Palace\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\u003E\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"http:\\\\/\\\\/gma.yahoo.com\\\\/blogs\\\\/abc-blogs\\\\/prince-william-play-polo-while-nine-months-pregnant-150649675.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:7;g:8714ae80-beb0-39b6-9ee1-bd13ffb3f5c5;tar:gma.yahoo.com;ltxt:PrinceWi;ct:2;pkgt:3;r:4100000846;slk:title;itc:0;prov:ABCNews;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\u003EPrince William to Play Polo While Nine-Months-Pregnant Kate Waits\\u003C\\\\/a\\u003E\\u003C\\\\/h3\\u003E\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\u003EPrince William has plans this weekend, but they don\\\\u2019t include a hospital. While his nine-months-pregnant wife, Kate, stays back home at the couple\\\\u2019s Kensington Palace home, Prince William will go ahead with plans to play in a charity polo match Sunday in Glouchestershire, nearly 100...\\u003C\\\\/p\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\u003E\\u003Cspan class=\\\\\\\"source\\\\\\\"\\u003EABC News\\u003C\\\\/span\\u003E\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\u003E\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/news.yahoo.com\\\\/celebrities\\\\/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"YCT:001000069\\\\\\\" data-ylk=\\\\\\\"slk:Celebrities;sec:td-strm;cpos:1;itc:0;g:8714ae80-beb0-39b6-9ee1-bd13ffb3f5c5;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\u003ECelebrities\\u003C\\\\/a\\u003E\\u003C\\\\/li\\u003E\\u003C\\\\/ul\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\u003E\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\u003ERemove\\u003C\\\\/button\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"content cavideo has-image voh-parent cf\\\\\\\" data-uuid=\\\\\\\"04cc60e0-a193-3352-8e5c-ff896228e590\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:8;pkgt:4;ccode:news;g:04cc60e0-a193-3352-8e5c-ff896228e590;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fnews.yahoo.com%2Fvideo%2Fmajor-setback-defense-george-zimmerman-161228577.html\\\\\\\" data-wikiids=\\\\\\\"\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"img ov-h thumb-left  \\\\\\\" href=\\\\\\\"\\\\/video\\\\/major-setback-defense-george-zimmerman-161228577.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:8;g:04cc60e0-a193-3352-8e5c-ff896228e590;tar:news.yahoo.com;ltxt:Majorset;ct:3;pkgt:4;r:4100001232;slk:title;itc:0;prov:WABC\\\\u2013NY;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" tabindex=\\\\\\\"-1\\\\\\\"\\u003E\\u003Cimg src=\\\\\\\"http:\\\\/\\\\/l.yimg.com\\\\/os\\\\/mit\\\\/media\\\\/m\\\\/base\\\\/images\\\\/transparent-95031.png\\\\\\\" style=\\\\\\\"margin-left:-32px;background-image:url('http:\\\\/\\\\/l3.yimg.com\\\\/ts\\\\/api\\\\/res\\\\/1.2\\\\/3aHYmihw4JqFgqXUDpm5bA--\\\\/YXBwaWQ9eWhvbWVydW47cT04NTtzbT0xO3c9MjUwO2g9MTQx\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en-US\\\\/video\\\\/video.wabc.abc.news.com\\\\/10a5262f6a2220ce4bf4830c048b3257');\\\\\\\" width=\\\\\\\"145\\\\\\\" height=\\\\\\\"82\\\\\\\" alt=\\\\\\\"\\\\\\\" title=\\\\\\\"\\\\\\\" class=\\\\\\\"lzbg\\\\\\\"\\u003E\\u003Cspan class=\\\\\\\"icon-overlay\\\\\\\"\\u003E\\u003Cspan class=\\\\\\\"video-icon d-ib\\\\\\\"\\u003E\\u003Ci class=\\\\\\\"icon-sprite\\\\\\\"\\u003E\\u003C\\\\/i\\u003E \\u003Cspan class=\\\\\\\"play-now fz-xxs\\\\\\\"\\u003EPlay\\u003C\\\\/span\\u003E\\u003C\\\\/span\\u003E\\u003C\\\\/span\\u003E\\u003C\\\\/a\\u003E\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\u003E\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"\\\\/video\\\\/major-setback-defense-george-zimmerman-161228577.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:8;g:04cc60e0-a193-3352-8e5c-ff896228e590;tar:news.yahoo.com;ltxt:Majorset;ct:3;pkgt:4;r:4100001232;slk:title;itc:0;prov:WABC\\\\u2013NY;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\u003EMajor setback for the defense at George Zimmerman trial\\u003C\\\\/a\\u003E\\u003C\\\\/h3\\u003E\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\u003EMarci Gonzalez reports for ABC News from Sanford, Florida\\u003C\\\\/p\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\u003E\\u003Cspan class=\\\\\\\"source\\\\\\\"\\u003EWABC \\\\u2013 NY\\u003C\\\\/span\\u003E\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\u003E\\u003C\\\\/ul\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\u003E\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\u003ERemove\\u003C\\\\/button\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"content voh-parent cf\\\\\\\" data-uuid=\\\\\\\"c200730b-eb18-376d-a3d3-1892197b9f54\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:9;pkgt:3;ccode:news;g:c200730b-eb18-376d-a3d3-1892197b9f54;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fnews.yahoo.com%2Fwashington-vilified-both-sides-egypts-divide-174446715.html\\\\\\\" data-wikiids=\\\\\\\"YCT:001000661|YCT:001000680|WIKIID:Barack_Obama|WIKIID:Mohamed_Morsi|WIKIID:Egypt|WIKIID:United_States|WIKIID:Hosni_Mubarak|WIKIID:Cairo\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\u003E\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"\\\\/washington-vilified-both-sides-egypts-divide-174446715.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:9;g:c200730b-eb18-376d-a3d3-1892197b9f54;tar:news.yahoo.com;ltxt:Washingt;ct:1;pkgt:3;r:4090000779;slk:title;itc:0;prov:Reuters;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\u003EWashington vilified on both sides of Egypt&#39;s divide\\u003C\\\\/a\\u003E\\u003C\\\\/h3\\u003E\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\u003EBy Maggie Fick and Tom Finn CAIRO (Reuters) - Pictures of Barack Obama have popped up all over Cairo. Some have his faced crossed out in paint. Heavy black beards are daubed onto others. No matter which side you talk to in Egypt, where people have been polarized by a violent political crisis, the\\\\u2026\\u003C\\\\/p\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\u003E\\u003Cspan class=\\\\\\\"source\\\\\\\"\\u003EReuters\\u003C\\\\/span\\u003E\\u003Cspan class=\\\\\\\"time\\\\\\\"\\u003E54 mins ago\\u003C\\\\/span\\u003E\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\u003E\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/news.yahoo.com\\\\/politics-and-government\\\\/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"YCT:001000661\\\\\\\" data-ylk=\\\\\\\"slk:Politics;sec:td-strm;cpos:1;itc:0;g:c200730b-eb18-376d-a3d3-1892197b9f54;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\u003EPolitics\\u003C\\\\/a\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/news.yahoo.com\\\\/foreign-policy\\\\/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"YCT:001000680\\\\\\\" data-ylk=\\\\\\\"slk:Foreign Policy;sec:td-strm;cpos:2;itc:0;g:c200730b-eb18-376d-a3d3-1892197b9f54;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\u003EForeign Policy\\u003C\\\\/a\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/news.yahoo.com\\\\/barack-obama\\\\/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"WIKIID:Barack_Obama\\\\\\\" data-ylk=\\\\\\\"slk:Barack Obama;sec:td-strm;cpos:3;itc:0;g:c200730b-eb18-376d-a3d3-1892197b9f54;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\u003EBarack Obama\\u003C\\\\/a\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/www.yahoo.com\\\\/topic\\\\/mohamed-morsi\\\\/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"WIKIID:Mohamed_Morsi\\\\\\\" data-ylk=\\\\\\\"slk:Mohamed Morsi;sec:td-strm;cpos:4;itc:0;g:c200730b-eb18-376d-a3d3-1892197b9f54;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\u003EMohamed Morsi\\u003C\\\\/a\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/news.yahoo.com\\\\/egypt\\\\/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"WIKIID:Egypt\\\\\\\" data-ylk=\\\\\\\"slk:Egypt;sec:td-strm;cpos:5;itc:0;g:c200730b-eb18-376d-a3d3-1892197b9f54;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\u003EEgypt\\u003C\\\\/a\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/www.yahoo.com\\\\/topic\\\\/united-states\\\\/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"WIKIID:United_States\\\\\\\" data-ylk=\\\\\\\"slk:United States;sec:td-strm;cpos:6;itc:0;g:c200730b-eb18-376d-a3d3-1892197b9f54;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\u003EUnited States\\u003C\\\\/a\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/news.yahoo.com\\\\/hosni-mubarak\\\\/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"WIKIID:Hosni_Mubarak\\\\\\\" data-ylk=\\\\\\\"slk:Hosni Mubarak;sec:td-strm;cpos:7;itc:0;g:c200730b-eb18-376d-a3d3-1892197b9f54;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\u003EHosni Mubarak\\u003C\\\\/a\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/www.yahoo.com\\\\/topic\\\\/cairo\\\\/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"WIKIID:Cairo\\\\\\\" data-ylk=\\\\\\\"slk:Cairo;sec:td-strm;cpos:8;itc:0;g:c200730b-eb18-376d-a3d3-1892197b9f54;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\u003ECairo\\u003C\\\\/a\\u003E\\u003C\\\\/li\\u003E\\u003C\\\\/ul\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\u003E\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\u003ERemove\\u003C\\\\/button\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"content voh-parent cf\\\\\\\" data-uuid=\\\\\\\"03ea9147-55d7-3820-996b-2c161860b5a2\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:10;pkgt:3;ccode:news;g:03ea9147-55d7-3820-996b-2c161860b5a2;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fnews.yahoo.com%2Fpublicly-shaming-girls-short-shorts-elementary-school-principal-132008451.html\\\\\\\" data-wikiids=\\\\\\\"YCT:001000267|YCT:001000269|WIKIID:Elementary_school\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\u003E\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"\\\\/publicly-shaming-girls-short-shorts-elementary-school-principal-132008451.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:10;g:03ea9147-55d7-3820-996b-2c161860b5a2;tar:news.yahoo.com;ltxt:Afterpub;ct:1;pkgt:3;r:4100000546;slk:title;itc:0;prov:TheDailyCaller;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\u003EAfter publicly shaming girls for short shorts, elementary school principal apologizes\\u003C\\\\/a\\u003E\\u003C\\\\/h3\\u003E\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\u003EThe principal at a highly selective and highly prestigious Chicago elementary school has apologized for singling out and publicly shaming seven girls on the last day of school for the immodest lengths of their shorts.\\u003C\\\\/p\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\u003E\\u003Cspan class=\\\\\\\"source\\\\\\\"\\u003EThe Daily Caller\\u003C\\\\/span\\u003E\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\u003E\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/news.yahoo.com\\\\/education\\\\/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"YCT:001000267\\\\\\\" data-ylk=\\\\\\\"slk:Education;sec:td-strm;cpos:1;itc:0;g:03ea9147-55d7-3820-996b-2c161860b5a2;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\u003EEducation\\u003C\\\\/a\\u003E\\u003C\\\\/li\\u003E\\u003C\\\\/ul\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\u003E\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\u003ERemove\\u003C\\\\/button\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"content has-image voh-parent cf\\\\\\\" data-uuid=\\\\\\\"590c8c6f-61a8-3dea-9ba7-8cb83525a33b\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:11;pkgt:4;ccode:news;g:590c8c6f-61a8-3dea-9ba7-8cb83525a33b;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fnews.yahoo.com%2Fbush-benevolent-spirit-must-drive-reform-plans-141956367.html\\\\\\\" data-wikiids=\\\\\\\"YCT:001000661|YCT:001000700|WIKIID:Immigration_reform\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"img ov-h thumb-left  \\\\\\\" href=\\\\\\\"\\\\/bush-benevolent-spirit-must-drive-reform-plans-141956367.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:11;g:590c8c6f-61a8-3dea-9ba7-8cb83525a33b;tar:news.yahoo.com;ltxt:Bush:&#3;ct:1;pkgt:4;r:4072900665;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" tabindex=\\\\\\\"-1\\\\\\\"\\u003E\\u003Cimg src=\\\\\\\"http:\\\\/\\\\/l.yimg.com\\\\/os\\\\/mit\\\\/media\\\\/m\\\\/base\\\\/images\\\\/transparent-95031.png\\\\\\\" style=\\\\\\\"margin-left:-18px;background-image:url('http:\\\\/\\\\/l2.yimg.com\\\\/ts\\\\/api\\\\/res\\\\/1.2\\\\/kM94ldkpwhbbDP4OY9UnYQ--\\\\/YXBwaWQ9eWhvbWVydW47cT04NTtzbT0xO3c9MjUwO2g9MTcz\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/ap_webfeeds\\\\/4e2f582e10be2e17370f6a7067003150.jpg');\\\\\\\" width=\\\\\\\"118\\\\\\\" height=\\\\\\\"82\\\\\\\" alt=\\\\\\\"\\\\\\\" title=\\\\\\\"\\\\\\\" class=\\\\\\\"lzbg\\\\\\\"\\u003E\\u003C\\\\/a\\u003E\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\u003E\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"\\\\/bush-benevolent-spirit-must-drive-reform-plans-141956367.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:11;g:590c8c6f-61a8-3dea-9ba7-8cb83525a33b;tar:news.yahoo.com;ltxt:Bush:&#3;ct:1;pkgt:4;r:4072900665;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\u003EBush: &#39;Benevolent spirit&#39; must drive reform plans\\u003C\\\\/a\\u003E\\u003C\\\\/h3\\u003E\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\u003EDALLAS (AP) \\\\u2014 Making a rare return to the political arena, former President George W. Bush urged Congress on Wednesday to reach a &quot;positive resolution&quot; on immigration reform, an issue that eluded him during his presidency and now confronts fellow Republicans in the aftermath of a 2012 election\\\\u2026\\u003C\\\\/p\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\u003E\\u003Cspan class=\\\\\\\"source\\\\\\\"\\u003EAssociated Press\\u003C\\\\/span\\u003E\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\u003E\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/news.yahoo.com\\\\/politics-and-government\\\\/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"YCT:001000661\\\\\\\" data-ylk=\\\\\\\"slk:Politics;sec:td-strm;cpos:1;itc:0;g:590c8c6f-61a8-3dea-9ba7-8cb83525a33b;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\u003EPolitics\\u003C\\\\/a\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/www.yahoo.com\\\\/topic\\\\/immigration-reform\\\\/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"WIKIID:Immigration_reform\\\\\\\" data-ylk=\\\\\\\"slk:Immigration reform;sec:td-strm;cpos:2;itc:0;g:590c8c6f-61a8-3dea-9ba7-8cb83525a33b;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\u003EImmigration reform\\u003C\\\\/a\\u003E\\u003C\\\\/li\\u003E\\u003C\\\\/ul\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\u003E\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\u003ERemove\\u003C\\\\/button\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"content has-image voh-parent cf\\\\\\\" data-uuid=\\\\\\\"e4009e04-8a14-3454-b2ef-0adfa809f2c3\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:12;pkgt:4;ccode:news;g:e4009e04-8a14-3454-b2ef-0adfa809f2c3;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fnews.yahoo.com%2Fnavy-attempt-1st-unmanned-carrier-landing-093729424.html\\\\\\\" data-wikiids=\\\\\\\"YCT:001000705|YCT:001000661|WIKIID:Unmanned_aerial_vehicle|WIKIID:Aircraft_carrier|WIKIID:Patuxent_River\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"img ov-h thumb-left  \\\\\\\" href=\\\\\\\"\\\\/navy-attempt-1st-unmanned-carrier-landing-093729424.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:12;g:e4009e04-8a14-3454-b2ef-0adfa809f2c3;tar:news.yahoo.com;ltxt:Navytoat;ct:1;pkgt:4;r:4100000592;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" tabindex=\\\\\\\"-1\\\\\\\"\\u003E\\u003Cimg src=\\\\\\\"http:\\\\/\\\\/l.yimg.com\\\\/os\\\\/mit\\\\/media\\\\/m\\\\/base\\\\/images\\\\/transparent-95031.png\\\\\\\" style=\\\\\\\"margin-left:-37px;background-image:url('http:\\\\/\\\\/l2.yimg.com\\\\/ts\\\\/api\\\\/res\\\\/1.2\\\\/qYZjBoAYvbF1JWrX_Eav.g--\\\\/YXBwaWQ9eWhvbWVydW47cT04NTtzbT0xO3c9MjUwO2g9MTMx\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/ap_webfeeds\\\\/c6ce26150eb22417370f6a706700137b.jpg');\\\\\\\" width=\\\\\\\"156\\\\\\\" height=\\\\\\\"82\\\\\\\" alt=\\\\\\\"\\\\\\\" title=\\\\\\\"\\\\\\\" class=\\\\\\\"lzbg\\\\\\\"\\u003E\\u003C\\\\/a\\u003E\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\u003E\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"\\\\/navy-attempt-1st-unmanned-carrier-landing-093729424.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:12;g:e4009e04-8a14-3454-b2ef-0adfa809f2c3;tar:news.yahoo.com;ltxt:Navytoat;ct:1;pkgt:4;r:4100000592;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\u003ENavy to attempt 1st unmanned carrier landing\\u003C\\\\/a\\u003E\\u003C\\\\/h3\\u003E\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\u003ENORFOLK, Va. (AP) \\\\u2014 The Navy will attempt to land a drone the size of a fighter jet aboard an aircraft carrier for the first time Wednesday, showcasing the military&#39;s capability to have a computer program perform one of the most difficult tasks a pilot is asked to do.\\u003C\\\\/p\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\u003E\\u003Cspan class=\\\\\\\"source\\\\\\\"\\u003EAssociated Press\\u003C\\\\/span\\u003E\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\u003E\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/news.yahoo.com\\\\/military-and-defense\\\\/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"YCT:001000705\\\\\\\" data-ylk=\\\\\\\"slk:Military;sec:td-strm;cpos:1;itc:0;g:e4009e04-8a14-3454-b2ef-0adfa809f2c3;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\u003EMilitary\\u003C\\\\/a\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/news.yahoo.com\\\\/politics-and-government\\\\/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"YCT:001000661\\\\\\\" data-ylk=\\\\\\\"slk:Politics;sec:td-strm;cpos:2;itc:0;g:e4009e04-8a14-3454-b2ef-0adfa809f2c3;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\u003EPolitics\\u003C\\\\/a\\u003E\\u003C\\\\/li\\u003E\\u003C\\\\/ul\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\u003E\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\u003ERemove\\u003C\\\\/button\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"content cavideo has-image voh-parent cf\\\\\\\" data-uuid=\\\\\\\"999a3ee7-37dc-34bd-99a7-51b289bd05a6\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:13;pkgt:4;ccode:news;g:999a3ee7-37dc-34bd-99a7-51b289bd05a6;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fnews.yahoo.com%2Fvideo%2Fskinny-dipping-wife-helps-husband-112335504.html\\\\\\\" data-wikiids=\\\\\\\"\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"img ov-h thumb-left  \\\\\\\" href=\\\\\\\"\\\\/video\\\\/skinny-dipping-wife-helps-husband-112335504.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:13;g:999a3ee7-37dc-34bd-99a7-51b289bd05a6;tar:news.yahoo.com;ltxt:Skinny-d;ct:3;pkgt:4;r:4100001466;slk:title;itc:0;prov:WPVI\\\\u2013Philadelphi;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" tabindex=\\\\\\\"-1\\\\\\\"\\u003E\\u003Cimg src=\\\\\\\"http:\\\\/\\\\/l.yimg.com\\\\/os\\\\/mit\\\\/media\\\\/m\\\\/base\\\\/images\\\\/transparent-95031.png\\\\\\\" style=\\\\\\\"margin-left:-32px;background-image:url('http:\\\\/\\\\/l1.yimg.com\\\\/ts\\\\/api\\\\/res\\\\/1.2\\\\/k0Uux1mipxEie_NcST2_RA--\\\\/YXBwaWQ9eWhvbWVydW47cT04NTtzbT0xO3c9MjUwO2g9MTQx\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en-US\\\\/video\\\\/video.wpvi.abc.news.com\\\\/fd9ca258c081f44a75f5d0ce3c14d921');\\\\\\\" width=\\\\\\\"145\\\\\\\" height=\\\\\\\"82\\\\\\\" alt=\\\\\\\"\\\\\\\" title=\\\\\\\"\\\\\\\" class=\\\\\\\"lzbg\\\\\\\"\\u003E\\u003Cspan class=\\\\\\\"icon-overlay\\\\\\\"\\u003E\\u003Cspan class=\\\\\\\"video-icon d-ib\\\\\\\"\\u003E\\u003Ci class=\\\\\\\"icon-sprite\\\\\\\"\\u003E\\u003C\\\\/i\\u003E \\u003Cspan class=\\\\\\\"play-now fz-xxs\\\\\\\"\\u003EPlay\\u003C\\\\/span\\u003E\\u003C\\\\/span\\u003E\\u003C\\\\/span\\u003E\\u003C\\\\/a\\u003E\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\u003E\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"\\\\/video\\\\/skinny-dipping-wife-helps-husband-112335504.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:13;g:999a3ee7-37dc-34bd-99a7-51b289bd05a6;tar:news.yahoo.com;ltxt:Skinny-d;ct:3;pkgt:4;r:4100001466;slk:title;itc:0;prov:WPVI\\\\u2013Philadelphi;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\u003ESkinny-dipping wife helps husband steal\\u003C\\\\/a\\u003E\\u003C\\\\/h3\\u003E\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\u003EClick play to watch the report from Action News\\u003C\\\\/p\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\u003E\\u003Cspan class=\\\\\\\"source\\\\\\\"\\u003EWPVI \\\\u2013 Philadelphia\\u003C\\\\/span\\u003E\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\u003E\\u003C\\\\/ul\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\u003E\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\u003ERemove\\u003C\\\\/button\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"content has-image voh-parent cf\\\\\\\" data-uuid=\\\\\\\"95413a0a-1d88-3f94-817c-d6b5fb824b6f\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:14;pkgt:4;ccode:news;g:95413a0a-1d88-3f94-817c-d6b5fb824b6f;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fnews.yahoo.com%2Fpanera-retool-latest-pay-idea-051305138.html\\\\\\\" data-wikiids=\\\\\\\"YCT:001000123|WIKIID:Panera_Bread\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"img ov-h thumb-left  \\\\\\\" href=\\\\\\\"\\\\/panera-retool-latest-pay-idea-051305138.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:14;g:95413a0a-1d88-3f94-817c-d6b5fb824b6f;tar:news.yahoo.com;ltxt:Panerato;ct:1;pkgt:4;r:4100000490;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" tabindex=\\\\\\\"-1\\\\\\\"\\u003E\\u003Cimg src=\\\\\\\"http:\\\\/\\\\/l.yimg.com\\\\/os\\\\/mit\\\\/media\\\\/m\\\\/base\\\\/images\\\\/transparent-95031.png\\\\\\\" style=\\\\\\\"margin-left:-21px;background-image:url('http:\\\\/\\\\/l3.yimg.com\\\\/ts\\\\/api\\\\/res\\\\/1.2\\\\/GRTmxi74dUkPM0bN5Tu_EA--\\\\/YXBwaWQ9eWhvbWVydW47cT04NTtzbT0xO3c9MjUwO2g9MTY3\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/ap_webfeeds\\\\/a4d177310ec22417370f6a7067000233.jpg');\\\\\\\" width=\\\\\\\"123\\\\\\\" height=\\\\\\\"82\\\\\\\" alt=\\\\\\\"\\\\\\\" title=\\\\\\\"\\\\\\\" class=\\\\\\\"lzbg\\\\\\\"\\u003E\\u003C\\\\/a\\u003E\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\u003E\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"\\\\/panera-retool-latest-pay-idea-051305138.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:14;g:95413a0a-1d88-3f94-817c-d6b5fb824b6f;tar:news.yahoo.com;ltxt:Panerato;ct:1;pkgt:4;r:4100000490;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\u003EPanera to retool latest pay-what-you-can idea\\u003C\\\\/a\\u003E\\u003C\\\\/h3\\u003E\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\u003EST. LOUIS (AP) \\\\u2014 Panera Bread&#39;s latest pay-what-you-can experiment will be retooled and brought back next winter as a seasonal offering rather than a permanent one, the chain&#39;s founder says.\\u003C\\\\/p\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\u003E\\u003Cspan class=\\\\\\\"source\\\\\\\"\\u003EAssociated Press\\u003C\\\\/span\\u003E\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\u003E\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/www.yahoo.com\\\\/topic\\\\/panera-bread\\\\/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"WIKIID:Panera_Bread\\\\\\\" data-ylk=\\\\\\\"slk:Panera Bread;sec:td-strm;cpos:1;itc:0;g:95413a0a-1d88-3f94-817c-d6b5fb824b6f;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\u003EPanera Bread\\u003C\\\\/a\\u003E\\u003C\\\\/li\\u003E\\u003C\\\\/ul\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\u003E\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\u003ERemove\\u003C\\\\/button\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"content slideshow has-image voh-parent cf\\\\\\\" data-uuid=\\\\\\\"706337c9-1922-33ac-b86f-a5280ffcc242\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:15;pkgt:21;ccode:news;g:706337c9-1922-33ac-b86f-a5280ffcc242;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fnews.yahoo.com%2Fphotos%2Fcarpenter-1-fire-rages-outside-las-vegas-1373414067-slideshow%2F\\\\\\\" data-wikiids=\\\\\\\"\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"img ov-h thumb-left  \\\\\\\" href=\\\\\\\"\\\\/photos\\\\/carpenter-1-fire-rages-outside-las-vegas-1373414067-slideshow\\\\/\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:15;g:706337c9-1922-33ac-b86f-a5280ffcc242;tar:news.yahoo.com;ltxt:Carpente;ct:4;pkgt:21;r:4100001677;slk:title;itc:0;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" tabindex=\\\\\\\"-1\\\\\\\"\\u003E\\u003Cimg src=\\\\\\\"http:\\\\/\\\\/l.yimg.com\\\\/os\\\\/mit\\\\/media\\\\/m\\\\/base\\\\/images\\\\/transparent-95031.png\\\\\\\" style=\\\\\\\"background-image:url('http:\\\\/\\\\/l1.yimg.com\\\\/ts\\\\/api\\\\/res\\\\/1.2\\\\/vv0qulgbBMDqq9r94wVCzw--\\\\/YXBwaWQ9eWhvbWVydW47cT04NTtzbT0xO2ZpPWZpbGw7dz0xMDA7aD0xMDA7cHlvZmY9MA--\\\\/http:\\\\/\\\\/l.yimg.com\\\\/os\\\\/publish-images\\\\/news\\\\/2013-07-09\\\\/147c5e94-9385-462b-85d7-4916b61620c4_fire7.jpg');\\\\\\\" width=\\\\\\\"82\\\\\\\" height=\\\\\\\"82\\\\\\\" alt=\\\\\\\"\\\\\\\" title=\\\\\\\"\\\\\\\" class=\\\\\\\"lzbg\\\\\\\"\\u003E\\u003Cspan class=\\\\\\\"icon-overlay\\\\\\\"\\u003E\\u003Cspan class=\\\\\\\"gallery-icon\\\\\\\"\\u003E\\u003Ci class=\\\\\\\"icon-sprite\\\\\\\"\\u003E\\u003C\\\\/i\\u003E \\u003Cspan class=\\\\\\\"view-now fz-xxs\\\\\\\"\\u003EView\\u003C\\\\/span\\u003E\\u003C\\\\/span\\u003E\\u003C\\\\/span\\u003E\\u003C\\\\/a\\u003E\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\u003E\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"\\\\/photos\\\\/carpenter-1-fire-rages-outside-las-vegas-1373414067-slideshow\\\\/\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:15;g:706337c9-1922-33ac-b86f-a5280ffcc242;tar:news.yahoo.com;ltxt:Carpente;ct:4;pkgt:21;r:4100001677;slk:title;itc:0;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-uuid=\\\\\\\"de60ffd9-ff42-4ec7-b62c-b733917baeca\\\\\\\"\\u003ECarpenter 1 fire rages outside Las Vegas \\u003Csmall\\u003E(14 photos)\\u003C\\\\/small\\u003E\\u003C\\\\/a\\u003E\\u003C\\\\/h3\\u003E\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\u003EPhotos from the Carpenter 1 fire outside Las Vegas, Nev., which has charred an area the size of Manhattan Island, according to the Associated Press .\\u003C\\\\/p\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\u003E\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\u003E\\u003C\\\\/ul\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\u003E\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\u003ERemove\\u003C\\\\/button\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"content rmx-ad has-image voh-parent cf\\\\\\\" data-uuid=\\\\\\\"21675196\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:16;pkgt:4;ccode:news;g:21675196;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fad.yieldmanager.com%2Fclk%3F3%2CeJytjcsOgjAURH-IRQFb2jQuCgUC0qIJSnCHPMozbohEv96ARH.As5g7kzvJ6CaFiOQIV7ggBQEIWFQ364JUoC5LpAFKqWERBC2ICdbYwhFPp9nBD.durzlsbhfFPizXVs7WW9Tl5iHPt3d6vE7sLzgkZMHmg3VXccxg.VLPBNvfmp.thCF7wYcuSs8w9rNJJN4gWr2VXdlEiTvLjoFs9MaYy17-BvaaBt5Mc081%2Chttp%253A%252F%252Fwww.nextag.com%252Fgoto.jsp%253Fp%253D357374%2526crid%253D70102%2526search%253Ddress\\\\\\\" data-wikiids=\\\\\\\"\\\\\\\" data-rmx-beacon=\\\\\\\"http:\\\\/\\\\/ad.yieldmanager.com\\\\/csc?ve=2&eDVBQF12wp2gYuJLPlTbhXlzA6IWivR8TvUupIdTtxWWT_KRcUq_k3JeHFR5Axmf8W8Eu_SnJ6nsBcHGXwM.EPjNsm3pCuLboxmB5dStxjLbeGiiF.eCSA9lwNfB2G248fAPjGPhyi3N7PQqZ.svAsKQwK05a3JLjQajId3GqR92_txBMmy1awX8Zn3nrwjgHFvzLPIFJ1svmulxdP_g7Hb5tjnpXXyCnpmH1NpTll3NAd7wk9XWEeun8rqrw2ZNNfF6WZS5RPwYCev7k9LVM1VTjs2yqGg0nIQH4pYpgN6oyO.mxW3BkIqa9snxkq7mfa0nH4otnvlfoNJjq9yWwUQNtnQKiq4pUms7HrqZzbDqLfDraJSxWV.1sb4QtExWizh6e_eURb_7vtwbvHKWqWH4WU1Emy4c7jaJG2.Hs8h_XLhYZjLbKs9DsiFP5RrghHN6TNdK9aVIZxIoWsOagptRElaqbCAXQh.HKAVOgd.xwnFkStxahe_BgtmjXbbFsLFdh299IqaYF6j.k.6curquTM6C_WFVtHERJUhjsQYk6noMOLdpgBDFCmQ6r0EzWsWEW_.W_twMnzL6ky.3z6EXJBkmtA.j18qFVulOuP.NogVvbhqtsQH0yB2vbDuX7JTWCDY24pQqw8IwgVO0UcFt6CwFS0PtCtn1AnMCgGjkXCcIYqVbNhLL7zg40ZDc8OcR2UHQkHGDnF7m918m1ULk2gJMFi_x.pyiODRnuDg34PxmKSQku37Js.LjNL11buxN2AshqV4gt8R3y02COFdxzswHg1pFZaRwDdDAiDXU_xBaYPWURpeIFxN0XlMHBw--&ap=16\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"img ov-h thumb-left  \\\\\\\" href=\\\\\\\"http:\\\\/\\\\/ad.yieldmanager.com\\\\/clk?3,eJytjcsOgjAURH-IRQFb2jQuCgUC0qIJSnCHPMozbohEv96ARH.As5g7kzvJ6CaFiOQIV7ggBQEIWFQ364JUoC5LpAFKqWERBC2ICdbYwhFPp9nBD.durzlsbhfFPizXVs7WW9Tl5iHPt3d6vE7sLzgkZMHmg3VXccxg.VLPBNvfmp.thCF7wYcuSs8w9rNJJN4gWr2VXdlEiTvLjoFs9MaYy17-BvaaBt5Mc081,http%3A%2F%2Fwww.nextag.com%2Fgoto.jsp%3Fp%3D357374%26crid%3D70102%26search%3Ddress\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:16;g:21675196;tar:ad.yieldmanager.com;ltxt:Top10Dre;ct:1;pkgt:4;ad:1;slk:title;itc:0;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" target=\\\\\\\"_blank\\\\\\\" tabindex=\\\\\\\"-1\\\\\\\"\\u003E\\u003Cimg src=\\\\\\\"http:\\\\/\\\\/l.yimg.com\\\\/os\\\\/mit\\\\/media\\\\/m\\\\/base\\\\/images\\\\/transparent-95031.png\\\\\\\" style=\\\\\\\"background-image:url('http:\\\\/\\\\/l2.yimg.com\\\\/av\\\\/moneyball\\\\/ads\\\\/bulk\\\\/6473\\\\/c1b5c4a6baf815019e3f6c79b13674e1.jpg');\\\\\\\" width=\\\\\\\"82\\\\\\\" height=\\\\\\\"82\\\\\\\" alt=\\\\\\\"\\\\\\\" title=\\\\\\\"\\\\\\\" class=\\\\\\\"lzbg\\\\\\\"\\u003E\\u003C\\\\/a\\u003E\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\u003E\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"http:\\\\/\\\\/ad.yieldmanager.com\\\\/clk?3,eJytjcsOgjAURH-IRQFb2jQuCgUC0qIJSnCHPMozbohEv96ARH.As5g7kzvJ6CaFiOQIV7ggBQEIWFQ364JUoC5LpAFKqWERBC2ICdbYwhFPp9nBD.durzlsbhfFPizXVs7WW9Tl5iHPt3d6vE7sLzgkZMHmg3VXccxg.VLPBNvfmp.thCF7wYcuSs8w9rNJJN4gWr2VXdlEiTvLjoFs9MaYy17-BvaaBt5Mc081,http%3A%2F%2Fwww.nextag.com%2Fgoto.jsp%3Fp%3D357374%26crid%3D70102%26search%3Ddress\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:16;g:21675196;tar:ad.yieldmanager.com;ltxt:Top10Dre;ct:1;pkgt:4;ad:1;slk:title;itc:0;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" target=\\\\\\\"_blank\\\\\\\"\\u003ETop 10 Dresses for 2013\\u003C\\\\/a\\u003E\\u003C\\\\/h3\\u003E\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\u003EHottest Dresses on sale.  Awesome selection and deals.\\u003C\\\\/p\\u003E\\u003Ca class=\\\\\\\"adlink fz-xxs rapid-noclick-resp\\\\\\\" href=\\\\\\\"http:\\\\/\\\\/info.yahoo.com\\\\/privacy\\\\/us\\\\/yahoo\\\\/adinfo_geo.html\\\\\\\" target=\\\\\\\"_blank\\\\\\\"\\u003EAdChoices\\u003Ci class=\\\\\\\"img-sprite\\\\\\\"\\u003E\\u003C\\\\/i\\u003E\\u003C\\\\/a\\u003E\\\\n\\u003Ca class=\\\\\\\"fz-xxs adv rapid-noclick-resp\\\\\\\" href=\\\\\\\"http:\\\\/\\\\/ad.yieldmanager.com\\\\/clk?3,eJytjcsOgjAURH-IRQFb2jQuCgUC0qIJSnCHPMozbohEv96ARH.As5g7kzvJ6CaFiOQIV7ggBQEIWFQ364JUoC5LpAFKqWERBC2ICdbYwhFPp9nBD.durzlsbhfFPizXVs7WW9Tl5iHPt3d6vE7sLzgkZMHmg3VXccxg.VLPBNvfmp.thCF7wYcuSs8w9rNJJN4gWr2VXdlEiTvLjoFs9MaYy17-BvaaBt5Mc081,http%3A%2F%2Fwww.nextag.com%2Fgoto.jsp%3Fp%3D357374%26crid%3D70102%26search%3Ddress\\\\\\\" target=\\\\\\\"_blank\\\\\\\"\\u003E\\u003Cspan class=\\\\\\\"source\\\\\\\"\\u003EOfficial Nextag Site\\u003C\\\\/span\\u003E\\u003C\\\\/a\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/help.yahoo.com\\\\/kb\\\\/index?page=content&y=PROD_FRONT&locale=en_US&id=SLN14553\\\\\\\" class=\\\\\\\"fz-xxs sp rapid-noclick-resp\\\\\\\" target=\\\\\\\"_blank\\\\\\\"\\u003ESponsored\\u003C\\\\/a\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\u003E\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\u003E\\u003C\\\\/ul\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"content voh-parent cf\\\\\\\" data-uuid=\\\\\\\"35246d27-ef1f-3c2f-ac82-50ee6d2511ee\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:17;pkgt:3;ccode:news;g:35246d27-ef1f-3c2f-ac82-50ee6d2511ee;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fnews.yahoo.com%2Fky-church-wants-pastor-gone-wifes-column-083204548.html\\\\\\\" data-wikiids=\\\\\\\"YCT:001000804|YCT:001000780|WIKIID:Southern_Baptist_Convention\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\u003E\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"\\\\/ky-church-wants-pastor-gone-wifes-column-083204548.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:17;g:35246d27-ef1f-3c2f-ac82-50ee6d2511ee;tar:news.yahoo.com;ltxt:Ky.churc;ct:1;pkgt:3;r:4059001073;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\u003EKy. church wants pastor gone after wife&#39;s column\\u003C\\\\/a\\u003E\\u003C\\\\/h3\\u003E\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\u003ELOUISVILLE, Ky. (AP) \\\\u2014 A newspaper column lampooning Southern Baptists, calling the group &quot;the crazy old paranoid uncle of evangelical Christians,&quot; is causing quite a stir in a Kentucky city and put a pastor&#39;s job in jeopardy.\\u003C\\\\/p\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\u003E\\u003Cspan class=\\\\\\\"source\\\\\\\"\\u003EAssociated Press\\u003C\\\\/span\\u003E\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\u003E\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/news.yahoo.com\\\\/religion-and-beliefs\\\\/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"YCT:001000804\\\\\\\" data-ylk=\\\\\\\"slk:Religion;sec:td-strm;cpos:1;itc:0;g:35246d27-ef1f-3c2f-ac82-50ee6d2511ee;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\u003EReligion\\u003C\\\\/a\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/news.yahoo.com\\\\/society-and-culture\\\\/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"YCT:001000780\\\\\\\" data-ylk=\\\\\\\"slk:Society;sec:td-strm;cpos:2;itc:0;g:35246d27-ef1f-3c2f-ac82-50ee6d2511ee;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\u003ESociety\\u003C\\\\/a\\u003E\\u003C\\\\/li\\u003E\\u003C\\\\/ul\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\u003E\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\u003ERemove\\u003C\\\\/button\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"content has-image voh-parent cf\\\\\\\" data-uuid=\\\\\\\"89342141-8982-3a32-9a2e-81cda1656e16\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:18;pkgt:4;ccode:news;g:89342141-8982-3a32-9a2e-81cda1656e16;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fnews.yahoo.com%2Fformer-judge-admits-flaws-secret-court-145541583.html\\\\\\\" data-wikiids=\\\\\\\"YCT:001000661|WIKIID:National_Security_Agency|WIKIID:Barack_Obama\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"img ov-h thumb-left  \\\\\\\" href=\\\\\\\"\\\\/former-judge-admits-flaws-secret-court-145541583.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:18;g:89342141-8982-3a32-9a2e-81cda1656e16;tar:news.yahoo.com;ltxt:Formerju;ct:1;pkgt:4;r:4072901757;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" tabindex=\\\\\\\"-1\\\\\\\"\\u003E\\u003Cimg src=\\\\\\\"http:\\\\/\\\\/l.yimg.com\\\\/os\\\\/mit\\\\/media\\\\/m\\\\/base\\\\/images\\\\/transparent-95031.png\\\\\\\" style=\\\\\\\"background-image:url('http:\\\\/\\\\/l2.yimg.com\\\\/ts\\\\/api\\\\/res\\\\/1.2\\\\/V1oj15r8LwVhitDeCoj3_g--\\\\/YXBwaWQ9eWhvbWVydW47cT04NTtzbT0xO3c9MjA4O2g9MjUw\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/ap_webfeeds\\\\/fab40ba5f2431816370f6a706700947e.jpg');\\\\\\\" width=\\\\\\\"82\\\\\\\" height=\\\\\\\"99\\\\\\\" alt=\\\\\\\"\\\\\\\" title=\\\\\\\"\\\\\\\" class=\\\\\\\"lzbg\\\\\\\"\\u003E\\u003C\\\\/a\\u003E\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\u003E\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"\\\\/former-judge-admits-flaws-secret-court-145541583.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:18;g:89342141-8982-3a32-9a2e-81cda1656e16;tar:news.yahoo.com;ltxt:Formerju;ct:1;pkgt:4;r:4072901757;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\u003EFormer judge admits flaws in secret court\\u003C\\\\/a\\u003E\\u003C\\\\/h3\\u003E\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\u003EWASHINGTON (AP) \\\\u2014 A former federal judge who served on a secret court overseeing the National Security Agency&#39;s secret surveillance programs said Tuesday the panel is independent but flawed because only the government&#39;s side is represented effectively in its deliberations.\\u003C\\\\/p\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\u003E\\u003Cspan class=\\\\\\\"source\\\\\\\"\\u003EAssociated Press\\u003C\\\\/span\\u003E\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\u003E\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/news.yahoo.com\\\\/politics-and-government\\\\/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"YCT:001000661\\\\\\\" data-ylk=\\\\\\\"slk:Politics;sec:td-strm;cpos:1;itc:0;g:89342141-8982-3a32-9a2e-81cda1656e16;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\u003EPolitics\\u003C\\\\/a\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/www.yahoo.com\\\\/topic\\\\/national-security-agency\\\\/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"WIKIID:National_Security_Agency\\\\\\\" data-ylk=\\\\\\\"slk:National Security Agency;sec:td-strm;cpos:2;itc:0;g:89342141-8982-3a32-9a2e-81cda1656e16;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\u003ENational Security Agency\\u003C\\\\/a\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/news.yahoo.com\\\\/barack-obama\\\\/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"WIKIID:Barack_Obama\\\\\\\" data-ylk=\\\\\\\"slk:Barack Obama;sec:td-strm;cpos:3;itc:0;g:89342141-8982-3a32-9a2e-81cda1656e16;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\u003EBarack Obama\\u003C\\\\/a\\u003E\\u003C\\\\/li\\u003E\\u003C\\\\/ul\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\u003E\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\u003ERemove\\u003C\\\\/button\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"content has-image voh-parent cf\\\\\\\" data-uuid=\\\\\\\"545a4a5d-31f1-3d2b-b3a1-af6ab035ba08\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:19;pkgt:4;ccode:news;g:545a4a5d-31f1-3d2b-b3a1-af6ab035ba08;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fnews.yahoo.com%2F30-000-california-prisoners-refusing-meals-030023796.html\\\\\\\" data-wikiids=\\\\\\\"WIKIID:California|WIKIID:Solitary_confinement\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"img ov-h thumb-left  \\\\\\\" href=\\\\\\\"\\\\/30-000-california-prisoners-refusing-meals-030023796.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:19;g:545a4a5d-31f1-3d2b-b3a1-af6ab035ba08;tar:news.yahoo.com;ltxt:30,000Ca;ct:1;pkgt:4;r:4100000793;slk:title;itc:0;prov:TheAtlanticWire;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" tabindex=\\\\\\\"-1\\\\\\\"\\u003E\\u003Cimg src=\\\\\\\"http:\\\\/\\\\/l.yimg.com\\\\/os\\\\/mit\\\\/media\\\\/m\\\\/base\\\\/images\\\\/transparent-95031.png\\\\\\\" style=\\\\\\\"margin-left:-25px;background-image:url('http:\\\\/\\\\/l1.yimg.com\\\\/ts\\\\/api\\\\/res\\\\/1.2\\\\/cIsjQVUHZJZ7HCJhBG6m2Q--\\\\/YXBwaWQ9eWhvbWVydW47cT04NTtzbT0xO3c9MjUwO2g9MTU2\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/theatlanticwire\\\\/30_000_California_Prisoners_Are_Refusing-b255dfae58903c7ee92b601e81fb15da');\\\\\\\" width=\\\\\\\"131\\\\\\\" height=\\\\\\\"82\\\\\\\" alt=\\\\\\\"\\\\\\\" title=\\\\\\\"\\\\\\\" class=\\\\\\\"lzbg\\\\\\\"\\u003E\\u003C\\\\/a\\u003E\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\u003E\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"\\\\/30-000-california-prisoners-refusing-meals-030023796.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:19;g:545a4a5d-31f1-3d2b-b3a1-af6ab035ba08;tar:news.yahoo.com;ltxt:30,000Ca;ct:1;pkgt:4;r:4100000793;slk:title;itc:0;prov:TheAtlanticWire;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\u003E30,000 California Prisoners Are Refusing Meals\\u003C\\\\/a\\u003E\\u003C\\\\/h3\\u003E\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\u003EOver 30,000 California prisoners started refusing meals on Monday morning in what might become the biggest hunger strike in California prison history, according to California&#39;s corrections department.\\u003C\\\\/p\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\u003E\\u003Cspan class=\\\\\\\"source\\\\\\\"\\u003EThe Atlantic Wire\\u003C\\\\/span\\u003E\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\u003E\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/news.yahoo.com\\\\/california\\\\/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"WIKIID:California\\\\\\\" data-ylk=\\\\\\\"slk:California;sec:td-strm;cpos:1;itc:0;g:545a4a5d-31f1-3d2b-b3a1-af6ab035ba08;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\u003ECalifornia\\u003C\\\\/a\\u003E\\u003C\\\\/li\\u003E\\u003C\\\\/ul\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\u003E\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\u003ERemove\\u003C\\\\/button\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"content has-image voh-parent cf\\\\\\\" data-uuid=\\\\\\\"c20cc012-29f6-3120-a12f-ef78c41a0a22\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:20;pkgt:4;ccode:news;g:c20cc012-29f6-3120-a12f-ef78c41a0a22;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fnews.yahoo.com%2F3-years-obamacare-incompetence-tells-us-white-house-074000304.html\\\\\\\" data-wikiids=\\\\\\\"YCT:001000661|YCT:001000681|WIKIID:White_House|WIKIID:Presidency_of_Barack_Obama|WIKIID:Patient_Protection_and_Affordable_Care_Act\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"img ov-h thumb-left  \\\\\\\" href=\\\\\\\"\\\\/3-years-obamacare-incompetence-tells-us-white-house-074000304.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:20;g:c20cc012-29f6-3120-a12f-ef78c41a0a22;tar:news.yahoo.com;ltxt:What3yea;ct:1;pkgt:4;r:4065600903;slk:title;itc:0;prov:TheWeek;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" tabindex=\\\\\\\"-1\\\\\\\"\\u003E\\u003Cimg src=\\\\\\\"http:\\\\/\\\\/l.yimg.com\\\\/os\\\\/mit\\\\/media\\\\/m\\\\/base\\\\/images\\\\/transparent-95031.png\\\\\\\" style=\\\\\\\"margin-left:-27px;background-image:url('http:\\\\/\\\\/l2.yimg.com\\\\/ts\\\\/api\\\\/res\\\\/1.2\\\\/Rntt.Xg7T8Y5NxTOWahOJg--\\\\/YXBwaWQ9eWhvbWVydW47cT04NTtzbT0xO3c9MjUwO2g9MTUx\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/theweek\\\\/is-president-obamas-signature-legislative-achievement-turning-into-a-messy-failure.jpg');\\\\\\\" width=\\\\\\\"136\\\\\\\" height=\\\\\\\"82\\\\\\\" alt=\\\\\\\"\\\\\\\" title=\\\\\\\"\\\\\\\" class=\\\\\\\"lzbg\\\\\\\"\\u003E\\u003C\\\\/a\\u003E\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\u003E\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"\\\\/3-years-obamacare-incompetence-tells-us-white-house-074000304.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:20;g:c20cc012-29f6-3120-a12f-ef78c41a0a22;tar:news.yahoo.com;ltxt:What3yea;ct:1;pkgt:4;r:4065600903;slk:title;itc:0;prov:TheWeek;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\u003EWhat 3 years of ObamaCare incompetence tells us about the White House\\u003C\\\\/a\\u003E\\u003C\\\\/h3\\u003E\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\u003EThe administration is gradually scaling back its signature legislation \\\\u2014 just as critics have long demanded\\u003C\\\\/p\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\u003E\\u003Cspan class=\\\\\\\"source\\\\\\\"\\u003EThe Week\\u003C\\\\/span\\u003E\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\u003E\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/news.yahoo.com\\\\/politics-and-government\\\\/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"YCT:001000661\\\\\\\" data-ylk=\\\\\\\"slk:Politics;sec:td-strm;cpos:1;itc:0;g:c20cc012-29f6-3120-a12f-ef78c41a0a22;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\u003EPolitics\\u003C\\\\/a\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/news.yahoo.com\\\\/white-house-2\\\\/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"WIKIID:White_House\\\\\\\" data-ylk=\\\\\\\"slk:White House;sec:td-strm;cpos:2;itc:0;g:c20cc012-29f6-3120-a12f-ef78c41a0a22;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\u003EWhite House\\u003C\\\\/a\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/www.yahoo.com\\\\/topic\\\\/presidency-of-barack-obama\\\\/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"WIKIID:Presidency_of_Barack_Obama\\\\\\\" data-ylk=\\\\\\\"slk:Presidency of Barack Obama;sec:td-strm;cpos:3;itc:0;g:c20cc012-29f6-3120-a12f-ef78c41a0a22;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\u003EPresidency of Barack Obama\\u003C\\\\/a\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/news.yahoo.com\\\\/patient-protection-and-affordable-care-act\\\\/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"WIKIID:Patient_Protection_and_Affordable_Care_Act\\\\\\\" data-ylk=\\\\\\\"slk:Patient Protection and Affordable Care Act;sec:td-strm;cpos:4;itc:0;g:c20cc012-29f6-3120-a12f-ef78c41a0a22;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\u003EPatient Protection and Affordable Care Act\\u003C\\\\/a\\u003E\\u003C\\\\/li\\u003E\\u003C\\\\/ul\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\u003E\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\u003ERemove\\u003C\\\\/button\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"content has-image voh-parent cf\\\\\\\" data-uuid=\\\\\\\"2e88e31e-a379-3340-96cb-7c5d904edd46\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:21;pkgt:4;ccode:news;g:2e88e31e-a379-3340-96cb-7c5d904edd46;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fnews.yahoo.com%2Fchina-discovers-primitive-5-000-old-writing-143034872.html\\\\\\\" data-wikiids=\\\\\\\"\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"img ov-h thumb-left  \\\\\\\" href=\\\\\\\"\\\\/china-discovers-primitive-5-000-old-writing-143034872.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:21;g:2e88e31e-a379-3340-96cb-7c5d904edd46;tar:news.yahoo.com;ltxt:Chinadis;ct:1;pkgt:4;r:4100000352;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" tabindex=\\\\\\\"-1\\\\\\\"\\u003E\\u003Cimg src=\\\\\\\"http:\\\\/\\\\/l.yimg.com\\\\/os\\\\/mit\\\\/media\\\\/m\\\\/base\\\\/images\\\\/transparent-95031.png\\\\\\\" style=\\\\\\\"margin-left:-36px;background-image:url('http:\\\\/\\\\/l4.yimg.com\\\\/ts\\\\/api\\\\/res\\\\/1.2\\\\/_7o1U7C.tcvQqh88tfjw8Q--\\\\/YXBwaWQ9eWhvbWVydW47cT04NTtzbT0xO3c9MjUwO2g9MTM0\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/ap_webfeeds\\\\/ba42591610ce2e17370f6a7067004e28.jpg');\\\\\\\" width=\\\\\\\"153\\\\\\\" height=\\\\\\\"82\\\\\\\" alt=\\\\\\\"\\\\\\\" title=\\\\\\\"\\\\\\\" class=\\\\\\\"lzbg\\\\\\\"\\u003E\\u003C\\\\/a\\u003E\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\u003E\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"\\\\/china-discovers-primitive-5-000-old-writing-143034872.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:21;g:2e88e31e-a379-3340-96cb-7c5d904edd46;tar:news.yahoo.com;ltxt:Chinadis;ct:1;pkgt:4;r:4100000352;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\u003EChina discovers primitive, 5,000-year-old writing\\u003C\\\\/a\\u003E\\u003C\\\\/h3\\u003E\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\u003EBEIJING (AP) \\\\u2014 Archaeologists say they have discovered some of the world&#39;s oldest known primitive writing, dating back about 5,000 years, in eastern China, and some of the markings etched on broken axes resemble a modern Chinese character.\\u003C\\\\/p\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\u003E\\u003Cspan class=\\\\\\\"source\\\\\\\"\\u003EAssociated Press\\u003C\\\\/span\\u003E\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\u003E\\u003C\\\\/ul\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\u003E\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\u003ERemove\\u003C\\\\/button\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"content cavideo has-image voh-parent cf\\\\\\\" data-uuid=\\\\\\\"c621133c-f907-3f42-93ff-20ef01effa97\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:22;pkgt:4;ccode:news;g:c621133c-f907-3f42-93ff-20ef01effa97;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fnews.yahoo.com%2Fvideo%2Fprinter-ink-efficiency-tested-consumer-174417327.html\\\\\\\" data-wikiids=\\\\\\\"WIKIID:Ink_cartridge\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"img ov-h thumb-left  \\\\\\\" href=\\\\\\\"\\\\/video\\\\/printer-ink-efficiency-tested-consumer-174417327.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:22;g:c621133c-f907-3f42-93ff-20ef01effa97;tar:news.yahoo.com;ltxt:Printeri;ct:3;pkgt:4;r:4100001074;slk:title;itc:0;prov:KGO\\\\u2013SanFrancisco;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" tabindex=\\\\\\\"-1\\\\\\\"\\u003E\\u003Cimg src=\\\\\\\"http:\\\\/\\\\/l.yimg.com\\\\/os\\\\/mit\\\\/media\\\\/m\\\\/base\\\\/images\\\\/transparent-95031.png\\\\\\\" style=\\\\\\\"margin-left:-32px;background-image:url('http:\\\\/\\\\/l3.yimg.com\\\\/ts\\\\/api\\\\/res\\\\/1.2\\\\/etz.tfpoo6Au9ixj1O3c4g--\\\\/YXBwaWQ9eWhvbWVydW47cT04NTtzbT0xO3c9MjUwO2g9MTQx\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en-US\\\\/video\\\\/video.kgo.abc.news.com\\\\/20a2be41046b838e6399259f73c9f47d');\\\\\\\" width=\\\\\\\"145\\\\\\\" height=\\\\\\\"82\\\\\\\" alt=\\\\\\\"\\\\\\\" title=\\\\\\\"\\\\\\\" class=\\\\\\\"lzbg\\\\\\\"\\u003E\\u003Cspan class=\\\\\\\"icon-overlay\\\\\\\"\\u003E\\u003Cspan class=\\\\\\\"video-icon d-ib\\\\\\\"\\u003E\\u003Ci class=\\\\\\\"icon-sprite\\\\\\\"\\u003E\\u003C\\\\/i\\u003E \\u003Cspan class=\\\\\\\"play-now fz-xxs\\\\\\\"\\u003EPlay\\u003C\\\\/span\\u003E\\u003C\\\\/span\\u003E\\u003C\\\\/span\\u003E\\u003C\\\\/a\\u003E\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\u003E\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"\\\\/video\\\\/printer-ink-efficiency-tested-consumer-174417327.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:22;g:c621133c-f907-3f42-93ff-20ef01effa97;tar:news.yahoo.com;ltxt:Printeri;ct:3;pkgt:4;r:4100001074;slk:title;itc:0;prov:KGO\\\\u2013SanFrancisco;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\u003EPrinter ink efficiency tested by Consumer Reports\\u003C\\\\/a\\u003E\\u003C\\\\/h3\\u003E\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\u003EMany don&#39;t realize it, but printer ink is one of the most expensive liquids you can buy.\\u003C\\\\/p\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\u003E\\u003Cspan class=\\\\\\\"source\\\\\\\"\\u003EKGO \\\\u2013 San Francisco\\u003C\\\\/span\\u003E\\u003Cspan class=\\\\\\\"time\\\\\\\"\\u003E54 mins ago\\u003C\\\\/span\\u003E\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\u003E\\u003C\\\\/ul\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\u003E\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\u003ERemove\\u003C\\\\/button\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"next-batch notice loading\\\\\\\" data-key=\\\\\\\"1\\\\\\\" data-ylk=\\\\\\\"slk:fetch;ltxt:fetch;pos:0;bpos:2;cpos:23;itc:1;sec:td-strm;test:900;intl:us;cat:default;ccode:news;\\\\\\\"  data-action=\\\\\\\"click\\\\\\\" data-action-outcome=\\\\\\\"fetch\\\\\\\"\\u003E\\u003Cbutton class=\\\\\\\"fz-xs\\\\\\\"\\u003ELoad more stories\\u003C\\\\/button\\u003E\\u003C\\\\/li\\u003E\\u003C\\\\/ul\\u003E\\u003Cinput type=\\\\\\\"hidden\\\\\\\" class=\\\\\\\"historystate\\\\\\\" data-time=\\\\\\\"1373481532.5925\\\\\\\"\\u003E    \\u003C\\\\/div\\u003E\\\\n\\u003C\\\\/div\\u003E\\\\n\\u003C\\\\/div\\u003E\\\\n\\\\n--dali-response-split-51ddaa3c96973Content-Type: text\\\\/plain; charset=utf-8\\\\nRMP-Embed-Location: bottom\\\\n\\\\n\\u003Cscript type=\\\\\\\"text\\\\/javascript\\\\\\\"\\u003E\\\\nYUI.namespace(\\\\\\\"presentation\\\\\\\");\\\\nYUI.presentation.lazyScriptList = [\\\\\\\"http:\\\\/\\\\/l.yimg.com\\\\/zz\\\\/combo?nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/oop_3.8.1.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/event-custom-base_3.8.1.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/event-base_3.8.1.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/io-base_3.8.1.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/json-parse_3.8.1.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/json-stringify_3.8.1.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/cookie_3.8.1.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/jsonp_3.8.1.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/dom-core_3.8.1.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/dom-base_3.8.1.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/dom-style_3.8.1.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/selector-native_3.8.1.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/selector_3.8.1.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/node-core_3.8.1.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/node-base_3.8.1.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/node-style_3.8.1.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/transition_3.8.2.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/selector-css2_3.8.1.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/selector-css3_3.8.1.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/event-custom-complex_3.8.1.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/event-synthetic_3.8.1.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/event-focus_3.8.1.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/event-delegate_3.8.1.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/node-event-delegate_3.8.1.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/pluginhost-base_3.8.1.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/pluginhost-config_3.8.1.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/node-pluginhost_3.8.1.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/dom-screen_3.8.1.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/node-screen_3.8.1.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/gallery-storage-lite_3.8.1.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/uicontrib\\\\/dali\\\\/module_platform_1.1.14.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/uicontrib\\\\/dali\\\\/resourcemgr_1.1.14.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/uicontrib\\\\/dali\\\\/dali_transport_1.1.34.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/uicontrib\\\\/dali\\\\/metro_dali_1.0.27.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/uicontrib\\\\/dali\\\\/module_api_1.1.16.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/uicontrib\\\\/dali\\\\/yui_service_0.1.17.js\\\\\\\"];\\\\n\\u003C\\\\/script\\u003E\\\\n\\\\n\\u003Cscript type=\\\\\\\"text\\\\/javascript\\\\\\\"\\u003E\\\\nYUI.presentation.lazyScriptList = YUI.presentation.lazyScriptList.concat([\\\\\\\"http:\\\\/\\\\/l.yimg.com\\\\/zz\\\\/combo?nn\\\\/lib\\\\/metro\\\\/g\\\\/uiplugins\\\\/metro_viewtype_0.1.24.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/uiplugins\\\\/default_viewtype_0.1.61.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/uiplugins\\\\/edit_viewtype_0.1.40.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/uicontrib\\\\/ylc_1.8.22.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/uiplugins\\\\/instrumentation_service_0.1.83.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/uiplugins\\\\/userinfo_service_0.1.15.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/uiplugins\\\\/statemgr_service_0.1.20.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/uiplugins\\\\/metrologger_service_0.1.18.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/uiplugins\\\\/tooltip_service_0.1.56.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/uiplugins\\\\/autohide_service_0.1.15.js\\\\\\\"]);\\\\n\\u003C\\\\/script\\u003E\\\\n\\\\n\\u003Cscript type=\\\\\\\"text\\\\/javascript\\\\\\\"\\u003E\\\\nYUI.presentation.lazyScriptList = YUI.presentation.lazyScriptList.concat([\\\\\\\"http:\\\\/\\\\/l.yimg.com\\\\/zz\\\\/combo?nn\\\\/lib\\\\/metro2\\\\/g\\\\/badge\\\\/badge_0.1.20.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/stream\\\\/stream_0.0.456.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/uiplugins\\\\/storage_service_0.0.1.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/uiplugins\\\\/login_service_0.0.38.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/uiplugins\\\\/interests_service_0.1.1.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/fstream\\\\/fstream_0.0.95.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/login\\\\/login_0.0.32.js\\\\\\\"]);\\\\n\\u003C\\\\/script\\u003E\\\\n\\\\n\\u003Cscript type=\\\\\\\"text\\\\/javascript\\\\\\\"\\u003E\\\\n(function()\\\\n{\\\\n    YMedia.namespace('dali').config = {\\\\\\\"props\\\\\\\":{\\\\\\\"dali\\\\\\\":{\\\\\\\"crumb\\\\\\\":\\\\\\\"OBQpwrpfCly\\\\\\\",\\\\\\\"yuid\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"loggedIn\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"mLogin\\\\\\\":0},\\\\\\\"proxyUrl\\\\\\\":\\\\\\\"\\\\\\\\\\\\/hjs?_mode=html&_create=1&_action=show&_type=badge&_container=1&_chrome=0&view=default&pInitLevel=lite&m_id=p_30345786&m_mode=multipart&configId=MediaRemoteIncludeExternalConfig&hide=0&mod_units=19&app=gs&content_id=5f01278b-803a-3803-9798-7fc79bab4f7d&juris=US&lang=en-US&pu=news.yahoo.com&region=US&se=4402687&site=news&mod_id=p_30345786&suid=30345786&pagetype=minihome&nolz=1&y_proc_embeds=1&y_map_urn=urn%3Armp%3Alite&_product_version=v2&r_inc=1&c_id=p_30345786_container&_sig=8nhtS_52JeXfdiYY25izjGGXZ2I-\\\\\\\"},\\\\\\\"data\\\\\\\":null,\\\\\\\"mods\\\\\\\":[{\\\\\\\"data\\\\\\\":{\\\\\\\"maple\\\\\\\":{\\\\\\\"platform\\\\\\\":{},\\\\\\\"module\\\\\\\":\\\\\\\"badge\\\\\\\",\\\\\\\"instance\\\\\\\":\\\\\\\"badge\\\\\\\",\\\\\\\"signature\\\\\\\":\\\\\\\"he5R2PEbnkHjPiFGhQuSNQ--\\\\\\\"},\\\\\\\"moduleId\\\\\\\":\\\\\\\"u_30345786\\\\\\\"},\\\\\\\"props\\\\\\\":{\\\\\\\"refHandler\\\\\\\":\\\\\\\"cfg.maple_dali.handler.refresh\\\\\\\",\\\\\\\"id\\\\\\\":\\\\\\\"badge\\\\\\\",\\\\\\\"ns\\\\\\\":\\\\\\\"badge\\\\\\\",\\\\\\\"trusted\\\\\\\":true},\\\\\\\"state\\\\\\\":{},\\\\\\\"strs\\\\\\\":{\\\\\\\"STR.MODULE.ERROR_FALLBACK_TEXT\\\\\\\":\\\\\\\"Requested module is not available. Please try again.\\\\\\\",\\\\\\\"STR.EDIT\\\\\\\":\\\\\\\"Settings\\\\\\\",\\\\\\\"STR.EDIT.CLOSE\\\\\\\":\\\\\\\"Close Settings\\\\\\\"},\\\\\\\"res\\\\\\\":{},\\\\\\\"mods\\\\\\\":[{\\\\\\\"data\\\\\\\":{\\\\\\\"maple\\\\\\\":{\\\\\\\"platform\\\\\\\":{},\\\\\\\"module\\\\\\\":\\\\\\\"u_30345786\\\\\\\",\\\\\\\"instance\\\\\\\":\\\\\\\"__mmh_0\\\\\\\",\\\\\\\"ba\\\\\\\":{\\\\\\\"_action\\\\\\\":\\\\\\\"show\\\\\\\",\\\\\\\"chrome\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"_id\\\\\\\":\\\\\\\"u_30345786\\\\\\\"},\\\\\\\"signature\\\\\\\":\\\\\\\"5nh6UiryEE9aP5zSGTFEXg--\\\\\\\"},\\\\\\\"woeId\\\\\\\":12778444,\\\\\\\"intl\\\\\\\":\\\\\\\"us\\\\\\\",\\\\\\\"socialEnabled\\\\\\\":true,\\\\\\\"swipeEnabled\\\\\\\":false,\\\\\\\"fbAcctLinked\\\\\\\":false,\\\\\\\"clientPagination\\\\\\\":true,\\\\\\\"dynamicEnabled\\\\\\\":true,\\\\\\\"removalMenuEnabled\\\\\\\":true,\\\\\\\"closeEnabled\\\\\\\":true,\\\\\\\"markAsReadEnabled\\\\\\\":true,\\\\\\\"tooltipsEnabled\\\\\\\":true,\\\\\\\"batchPause\\\\\\\":0,\\\\\\\"interestFiltersEnabled\\\\\\\":true,\\\\\\\"interestFiltersBroadcast\\\\\\\":true,\\\\\\\"minArticleCount\\\\\\\":6,\\\\\\\"broadcastDynamicEnabled\\\\\\\":true,\\\\\\\"sortBy\\\\\\\":0,\\\\\\\"shareDrawerEnabled\\\\\\\":false,\\\\\\\"saveEnabled\\\\\\\":false,\\\\\\\"scrollBuffer\\\\\\\":900,\\\\\\\"writeMixerActions\\\\\\\":true,\\\\\\\"isRmp\\\\\\\":true,\\\\\\\"interestFiltersNavigate\\\\\\\":true,\\\\\\\"itemClickBroadcastOnly\\\\\\\":true,\\\\\\\"itemClickContext\\\\\\\":true,\\\\\\\"restoreStateExpire\\\\\\\":1800000,\\\\\\\"restoreStateMethod\\\\\\\":\\\\\\\"LOCAL_STORAGE\\\\\\\",\\\\\\\"restoreStateOnCacheMiss\\\\\\\":true,\\\\\\\"batchSize\\\\\\\":20,\\\\\\\"locationPickerEnabled\\\\\\\":false,\\\\\\\"beacon_sec\\\\\\\":\\\\\\\"app-loc\\\\\\\",\\\\\\\"beacon_slk\\\\\\\":\\\\\\\"s-op\\\\\\\",\\\\\\\"beacon_bucketid\\\\\\\":\\\\\\\"900\\\\\\\",\\\\\\\"dynamicCategories\\\\\\\":[{\\\\\\\"name\\\\\\\":\\\\\\\"Politics\\\\\\\",\\\\\\\"id\\\\\\\":\\\\\\\"YCT:001000661\\\\\\\",\\\\\\\"points\\\\\\\":158.92,\\\\\\\"src\\\\\\\":\\\\\\\"core\\\\\\\",\\\\\\\"count\\\\\\\":59,\\\\\\\"occurances\\\\\\\":{\\\\\\\"1\\\\\\\":6,\\\\\\\"2\\\\\\\":2,\\\\\\\"3\\\\\\\":4,\\\\\\\"4\\\\\\\":6,\\\\\\\"5\\\\\\\":7,\\\\\\\"6\\\\\\\":8,\\\\\\\"7\\\\\\\":8,\\\\\\\"8\\\\\\\":13,\\\\\\\"9\\\\\\\":5},\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/news.yahoo.com\\\\\\\\\\\\/politics-and-government\\\\\\\\\\\\/\\\\\\\"},{\\\\\\\"name\\\\\\\":\\\\\\\"Society\\\\\\\",\\\\\\\"id\\\\\\\":\\\\\\\"YCT:001000780\\\\\\\",\\\\\\\"points\\\\\\\":103.8,\\\\\\\"src\\\\\\\":\\\\\\\"core\\\\\\\",\\\\\\\"count\\\\\\\":36,\\\\\\\"occurances\\\\\\\":{\\\\\\\"1\\\\\\\":2,\\\\\\\"2\\\\\\\":6,\\\\\\\"3\\\\\\\":3,\\\\\\\"4\\\\\\\":4,\\\\\\\"5\\\\\\\":8,\\\\\\\"6\\\\\\\":3,\\\\\\\"7\\\\\\\":4,\\\\\\\"8\\\\\\\":3,\\\\\\\"9\\\\\\\":3},\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/news.yahoo.com\\\\\\\\\\\\/society-and-culture\\\\\\\\\\\\/\\\\\\\"},{\\\\\\\"name\\\\\\\":\\\\\\\"Crime & Justice\\\\\\\",\\\\\\\"id\\\\\\\":\\\\\\\"YCT:001000667\\\\\\\",\\\\\\\"points\\\\\\\":34.83,\\\\\\\"src\\\\\\\":\\\\\\\"core\\\\\\\",\\\\\\\"count\\\\\\\":14,\\\\\\\"occurances\\\\\\\":{\\\\\\\"1\\\\\\\":1,\\\\\\\"2\\\\\\\":1,\\\\\\\"4\\\\\\\":1,\\\\\\\"5\\\\\\\":2,\\\\\\\"6\\\\\\\":4,\\\\\\\"7\\\\\\\":3,\\\\\\\"8\\\\\\\":1,\\\\\\\"9\\\\\\\":1},\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/news.yahoo.com\\\\\\\\\\\\/crime-and-justice\\\\\\\\\\\\/\\\\\\\"},{\\\\\\\"name\\\\\\\":\\\\\\\"Education\\\\\\\",\\\\\\\"id\\\\\\\":\\\\\\\"YCT:001000267\\\\\\\",\\\\\\\"points\\\\\\\":29.77,\\\\\\\"src\\\\\\\":\\\\\\\"core\\\\\\\",\\\\\\\"count\\\\\\\":8,\\\\\\\"occurances\\\\\\\":{\\\\\\\"1\\\\\\\":1,\\\\\\\"2\\\\\\\":1,\\\\\\\"3\\\\\\\":2,\\\\\\\"4\\\\\\\":2,\\\\\\\"5\\\\\\\":1,\\\\\\\"9\\\\\\\":1},\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/news.yahoo.com\\\\\\\\\\\\/education\\\\\\\\\\\\/\\\\\\\"},{\\\\\\\"name\\\\\\\":\\\\\\\"Health\\\\\\\",\\\\\\\"id\\\\\\\":\\\\\\\"YCT:001000395\\\\\\\",\\\\\\\"points\\\\\\\":26.66,\\\\\\\"src\\\\\\\":\\\\\\\"core\\\\\\\",\\\\\\\"count\\\\\\\":6,\\\\\\\"occurances\\\\\\\":{\\\\\\\"1\\\\\\\":1,\\\\\\\"2\\\\\\\":1,\\\\\\\"3\\\\\\\":2,\\\\\\\"4\\\\\\\":2},\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/news.yahoo.com\\\\\\\\\\\\/health\\\\\\\\\\\\/\\\\\\\"}],\\\\\\\"dynamicEntities\\\\\\\":[{\\\\\\\"name\\\\\\\":\\\\\\\"Barack Obama\\\\\\\",\\\\\\\"id\\\\\\\":\\\\\\\"WIKIID:Barack_Obama\\\\\\\",\\\\\\\"points\\\\\\\":293,\\\\\\\"src\\\\\\\":\\\\\\\"core\\\\\\\",\\\\\\\"count\\\\\\\":293,\\\\\\\"occurances\\\\\\\":{\\\\\\\"1\\\\\\\":2},\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/news.yahoo.com\\\\\\\\\\\\/barack-obama\\\\\\\\\\\\/\\\\\\\",\\\\\\\"uuid\\\\\\\":\\\\\\\"c200730b-eb18-376d-a3d3-1892197b9f54\\\\\\\"},{\\\\\\\"name\\\\\\\":\\\\\\\"Egypt\\\\\\\",\\\\\\\"id\\\\\\\":\\\\\\\"WIKIID:Egypt\\\\\\\",\\\\\\\"points\\\\\\\":188,\\\\\\\"src\\\\\\\":\\\\\\\"core\\\\\\\",\\\\\\\"count\\\\\\\":188,\\\\\\\"occurances\\\\\\\":{\\\\\\\"1\\\\\\\":1},\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/news.yahoo.com\\\\\\\\\\\\/egypt\\\\\\\\\\\\/\\\\\\\",\\\\\\\"uuid\\\\\\\":\\\\\\\"c200730b-eb18-376d-a3d3-1892197b9f54\\\\\\\"},{\\\\\\\"name\\\\\\\":\\\\\\\"United States\\\\\\\",\\\\\\\"id\\\\\\\":\\\\\\\"WIKIID:United_States\\\\\\\",\\\\\\\"points\\\\\\\":136,\\\\\\\"src\\\\\\\":\\\\\\\"core\\\\\\\",\\\\\\\"count\\\\\\\":136,\\\\\\\"occurances\\\\\\\":{\\\\\\\"1\\\\\\\":1},\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/www.yahoo.com\\\\\\\\\\\\/topic\\\\\\\\\\\\/united-states\\\\\\\\\\\\/\\\\\\\",\\\\\\\"uuid\\\\\\\":\\\\\\\"c200730b-eb18-376d-a3d3-1892197b9f54\\\\\\\"},{\\\\\\\"name\\\\\\\":\\\\\\\"White House\\\\\\\",\\\\\\\"id\\\\\\\":\\\\\\\"WIKIID:White_House\\\\\\\",\\\\\\\"points\\\\\\\":128,\\\\\\\"src\\\\\\\":\\\\\\\"core\\\\\\\",\\\\\\\"count\\\\\\\":128,\\\\\\\"occurances\\\\\\\":{\\\\\\\"1\\\\\\\":2},\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/news.yahoo.com\\\\\\\\\\\\/white-house-2\\\\\\\\\\\\/\\\\\\\",\\\\\\\"uuid\\\\\\\":\\\\\\\"590c8c6f-61a8-3dea-9ba7-8cb83525a33b\\\\\\\"},{\\\\\\\"name\\\\\\\":\\\\\\\"Shooting of Trayvon Martin\\\\\\\",\\\\\\\"id\\\\\\\":\\\\\\\"WIKIID:Shooting_of_Trayvon_Martin\\\\\\\",\\\\\\\"points\\\\\\\":120,\\\\\\\"src\\\\\\\":\\\\\\\"core\\\\\\\",\\\\\\\"count\\\\\\\":120,\\\\\\\"occurances\\\\\\\":{\\\\\\\"1\\\\\\\":1},\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/www.yahoo.com\\\\\\\\\\\\/topic\\\\\\\\\\\\/shooting-of-trayvon-martin\\\\\\\\\\\\/\\\\\\\",\\\\\\\"uuid\\\\\\\":\\\\\\\"a2b156e2-bdc5-3dab-bf3c-241d681ef099\\\\\\\"}],\\\\\\\"items\\\\\\\":[{\\\\\\\"u\\\\\\\":\\\\\\\"41b84caa-3b4d-32c7-9ee7-e45c21fc0fb6\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4089900430\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"6f4ca8cf-c412-35d3-853f-9ee636b92373\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000384\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"62787508-255a-3395-82ba-9e62e75cb0f0\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000435\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"8cc97ab2-66d0-3bbb-8b6f-c20ba8d932c4\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4059000616\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"8682b543-884b-33da-a257-f0d05e1a3dfa\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4090000408\\\\\\\"},{\\\\\\\"u\\\\\\\":21370595,\\\\\\\"s\\\\\\\":\\\\\\\"If you have a $500,000 portfolio, download the &quot;15-Minute Retirement Plan&quot; by Forbes columnist Ken Fisher's Firm.\\\\\\\",\\\\\\\"im\\\\\\\":{\\\\\\\"original\\\\\\\":{\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l2.yimg.com\\\\\\\\\\\\/av\\\\\\\\\\\\/moneyball\\\\\\\\\\\\/ads\\\\\\\\\\\\/0-1371163702-9044.jpg\\\\\\\",\\\\\\\"width\\\\\\\":82,\\\\\\\"height\\\\\\\":61,\\\\\\\"orientation\\\\\\\":\\\\\\\"landscape\\\\\\\",\\\\\\\"ratio\\\\\\\":1.344262295082}},\\\\\\\"ur\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/ad.yieldmanager.com\\\\\\\\\\\\/clk?3,eJytjcsKgzAURH.IRTSmRkIX0ahoNbaQUrK0xqS-doLUr2-1rx.ogbkwzHDHhsRpkAYuwKCutHYVJjbUtd8ArZRnAUKI4.k75CHsY4uuHPF0mlkX9zLYfAaFmOkL81RgwndvvRGDh6p6x-k1GOlfCP2Mpp-v265hmCK9mLvAwbeWSLdw-FAs6pZfzqhM5FSIeChau-WdanMRzbyjQI7xWDLe89.A3rLAA6jKT6A=,http%3A%2F%2Fclk.atdmt.com%2FINV%2Fgo%2F451647339%2Fdirect%2F01%2F\\\\\\\",\\\\\\\"t\\\\\\\":\\\\\\\"4 Ways to Avoid Running Out of Money in Retirement\\\\\\\",\\\\\\\"b\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/ad.yieldmanager.com\\\\\\\\\\\\/csc?ve=2&nnedaxJ2wp1pT4ZwGV4gDhYeBEElHwTeHaR66EZPtofFZiP.h3qhAh8D1AlHKzUtktlm12a7lhoaiOxNXb7GPmZy2_VWgTyZzw0xt4aw4mb0_3.5Xu8vcd6SGbF585AHOSTh4pCkdgD7vLoQQ_grHIGl_iCGeDDWb14hcb1OcM5DXq6CLJ8j7K81RZcK.4yJhLz3zTE1OEy3XTYzeA.2TDpLgb68IWRkxY7AKma09CzCbzc.eaNXMGJoCuEvmx.MWug_0mFZ2f_u8khz6Vef0VU7KHYGF93fjHs7c6fZsPAJOZAMZvjtnMZNZYIVTOPWzVD_xB6q_.rHZxX4vheZSNgDhvWuIrcJsu4O_Ur7fWcsyu09Pf_uhSyvwSynUHOxqqPrFqkwcZvRM3_flzSXlWitUznMKGHbIfqWSdmWpSdWEQlil66ZxJP3_XhC4tN8TLfOBNqHvhFwXOOazr0qTmVo.EnXCKZGYCkIeRcy.lhko303jyby1lOyMDrWvmUbqZzZxJJaurUZu1SvfrJ0zJ6oSxA9G33en7QsXtfKP4hqiyob.bOI6KX561sUNSq3A5z8Q61yK.AVSqnZnuMd0ImeL2AT2RO6TVzpXNOyx.4wuiwwcYzchdGVTj_YQkypq1C_7s3lVrWL4zUcCR_AL570O6DuX2g2lEZkb8XpWmk9qpNT1DxIm.nBD1DSV1ZwyKXeaOTVSu8gVVGyHjBi.6akODrY1IoHbGLXWFhY9vV68jSdu5bEZyBI0GCcC5OjwxVahDzX0ruhzsA8QRyFm528h0Zl07chJwDPYi_PkAyGXLLhJqg3oElWSLC87g1Uzw--&ap=29\\\\\\\",\\\\\\\"ia\\\\\\\":1,\\\\\\\"at\\\\\\\":\\\\\\\"Fisher Investments\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"acfa2983-d731-3cbc-a0fc-2ff8ef78e075\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100001372\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"1733412d-c645-3dcc-898f-a3e6b23632c3\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4090000563\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"fa2d95f2-4e85-3cfa-aee0-d5b0c031529f\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000730\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"523fedde-cc12-38fb-86ca-60629888845c\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4090001194\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"e8fcb3d3-00f3-3804-b31c-d387f5b7c8e2\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4053100529\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"d344ace7-22fe-3cab-b829-5c23eb17e754\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4090001080\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"1099eb81-1582-311e-b36e-9a15c7f141e0\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4053100516\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"0827042a-7b69-3744-876a-e63bbaf67e6d\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000368\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"61d9ae23-9b3a-343a-9309-6e2f3cf1dc01\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000293\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"6e2cca72-5335-3ef9-8ebb-e93683d1ee71\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000273\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"f87eaebd-5628-3ec6-b863-c404b0abcee4\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100001060\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"34c6686d-577e-34a0-bb2b-887d9b40d3f5\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000353\\\\\\\"},{\\\\\\\"u\\\\\\\":20637846,\\\\\\\"s\\\\\\\":\\\\\\\"Find Out Which Vehicles Get The Best Gas Mileage. See Our Top 10 Results for Cars, Trucks, and SUVs.\\\\\\\",\\\\\\\"im\\\\\\\":{\\\\\\\"original\\\\\\\":{\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l3.yimg.com\\\\\\\\\\\\/av\\\\\\\\\\\\/moneyball\\\\\\\\\\\\/cleansed\\\\\\\\\\\\/282855.jpg\\\\\\\",\\\\\\\"width\\\\\\\":82,\\\\\\\"height\\\\\\\":82,\\\\\\\"orientation\\\\\\\":\\\\\\\"square\\\\\\\",\\\\\\\"ratio\\\\\\\":1}},\\\\\\\"ur\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/ad.yieldmanager.com\\\\\\\\\\\\/clk?3,eJytjdsKgkAYhF.IYD2srixd7EHF0DVhS7wM1zVN6caQevryQL1AH8zPDP.AmDa2aqiBAxCoLlo7CmHT1pVfA62UZwCMseX5LvQg8pFBZo5ozCdWuPxOl8ycq5zISvMRbdjWm2.AYfYg-fqWO9qTv8D8A4k3Hy-7DUcE6lfzlIh-a1HppJYYhDz3SXGCWVSOqQz7tDVb0akukcEkOgLKIRwyLm7iN7A3DPAGZfRPKw==,http%3A%2F%2Fwww.autobytel.com%2Ftop-10-cars%2Fbest-gas-mileage-cars%2F%3Fid%3D32929\\\\\\\",\\\\\\\"t\\\\\\\":\\\\\\\"Top 10 Best Gas Mileage Vehicles\\\\\\\",\\\\\\\"b\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/ad.yieldmanager.com\\\\\\\\\\\\/csc?ve=2&qzsmLzV2wp2K9aGINWH7y9M8hgZ7miUHN7UiJS.BY5zkRMidN64B35nlkb.wLdLD1BL8KTn.mdRIy2FfIjyaFwOY3ZZsLej2OkhrchS.GulCXbbNSRlTn8LYQ867ug57Kg9vOarUWPjiU76cVavCRaAHVCD4kfxlODDJd.NLgmJSTE3C750JidXG5vDJA0cC4cHgavWFdkyWzRpiigqOxrDdScG6y110r6o_wo7iuP7aTI9BIrGAHlo5K_Dhayx4JBbASvrHdzV6jIp1zh_UhvGhD_ZrTpqDnEFQtlQym.V0AnPiDlp0Gmd4zIHu3.164Ep_kCb50kB9X7XLREzU0t7LxvF2QFSCpgCpPL9f29E69w_MsWjQgTRhrEm3wVHmrrgCeo_ifbyT0w9aK7.qxAtqgPRO.zhAjl2e2jAZuH9q0TiFH9ubIsF04v2Y32JnuSlZYL04WeW3rBsSg3.0cFOpVFGaTk557Z7OAq.JFCmPLfEBAqMReZYFOqFy7jv2JQS6O6KYqB3dBU6V..xtZCH8XBqj84_P2zbtS9PbTgQF44xj8TF.LNIzpGyhHW5XsOjvSfhN6.LbKXz26cDHIayxx_ahuak5Wgn6qVO2WbiJNLJ69lZULHZQt4FgJLIL5mHTQjZ1cLBNGQDVKEPtLzkd6Zvwj5xzEC.3HSblPSjtgnU1jbGWWypqbXJzQJLHOXtVy_gXDYiTqouO2bCuv69hYPY.hli.BYjuaWJiQ8CQVYcg6K1xZTJbFNC_.Bdk14dKMrVziemcYyiChWT7QoMkSJ0.Cw5H0HugXp12a.gGzq3_36IMzz3SP1DHlAWN5g--&ap=42\\\\\\\",\\\\\\\"ia\\\\\\\":1,\\\\\\\"at\\\\\\\":\\\\\\\"Autobytel\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"db5de020-1c28-3992-8b33-7759daa5e05e\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000928\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"0af9f27d-adfd-3b40-bdd2-8ff1b8643742\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4047800699\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"5c9e6d6a-5127-3f87-b77f-6580cd62dfe4\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000932\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"b1f76e13-0b85-3d35-ab05-1b263f119f5a\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000883\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"cfa94c8c-28be-3510-b57a-00b7c3588ab9\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000241\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"e4d5a136-97d8-3124-8ac6-7c020235428f\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000269\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"24e6df26-628f-3a4c-9b98-b22275506fb9\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4081001304\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"ed5c998c-1e32-3302-9d47-7f3957a1fc2f\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4043000567\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"b1151a83-318e-34e2-a2c8-0fe169c1f900\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4090000230\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"bfab8f88-77cf-3ace-b86a-80a4f5d25e89\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000483\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"b4fd501c-2f37-3258-ae09-c23c728290ba\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4059000932\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"73beeae0-a4b3-384b-bf19-be60c1176c1b\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4065600270\\\\\\\"},{\\\\\\\"u\\\\\\\":20626440,\\\\\\\"s\\\\\\\":\\\\\\\"Netflix members can watch as much as they want, anytime, anywhere, on nearly any Internet-connected screen. Only $7.99\\\\\\\\\\\\/mo. Sign up today.\\\\\\\",\\\\\\\"im\\\\\\\":{\\\\\\\"original\\\\\\\":{\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l1.yimg.com\\\\\\\\\\\\/av\\\\\\\\\\\\/moneyball\\\\\\\\\\\\/curated\\\\\\\\\\\\/202834-1366845045.jpg\\\\\\\",\\\\\\\"width\\\\\\\":82,\\\\\\\"height\\\\\\\":82,\\\\\\\"orientation\\\\\\\":\\\\\\\"square\\\\\\\",\\\\\\\"ratio\\\\\\\":1}},\\\\\\\"ur\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/ad.yieldmanager.com\\\\\\\\\\\\/clk?3,eJytjV0LgjAYhf-QF35NN0YX06kYOhMW4a0uh18VZA399aVG.YEeOC.n8B44hoWFU5WVWdYQCiAsUWLDqit01mshoKZjjE0XOcAFEEGNLBzgmCsSP-nVW3NkM67IhnzLk.6nt9yAguxB8u19ud968hd8tCfxx8frrqSQgHqWE4fetxYVdmrmis3dlJyOIIuKMeVhnzZGw1rRJTxQrCV6MYRDRlnHfgM7TdNfkp9Qvg==,https%3A%2F%2Fsignup.netflix.com%2F%3Fmqso%3D81003558\\\\\\\",\\\\\\\"t\\\\\\\":\\\\\\\"Netflix Revolutionizes Movie and TV Watching\\\\\\\",\\\\\\\"b\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/ad.yieldmanager.com\\\\\\\\\\\\/csc?ve=2&zWkYpzB2wp0ba3Tgopas6BFRYuE4xz9CbQJTUryvjLap3MzIAsGdm_gAdsSi4z93s3hCwj650aQ170QekJvPpbppwZ0JQlC5fOkR61_rGpcjztv8z0HtNrvZjMmEWj1VSSLk2vDnoCXUHJ4d13JV.r__VupHevR2lkwV81UPZLe.tHC5E84PwiDWjvY609QZPmjXCpKQ6h0rVnxHz1.yDxGJgukh1euQqi26U.AySo.L8f2Ehl8c_xZgluYHv1pqyT15XtdXcj35OQIU8weeVJi5zKhEt2muH6F5yK31DuJXXbmWyl3W9aTH.adyE2tGbtEv3A9w4W0V_senGdwWhu.dnNVGjlRSBXV7Wi0E5jRqhWa1RGsOukRYf__w69u32m7G7E2zswa2UdyBnDNQsgsjfKVZxJHbxsftB2kR1Y11ZnkxdyUYdKbjLjQYLlgC4poPd_pBwTdFWFIC5jka1dyqEaJm6EiudqR6PXTt29IFSl9vSsqFIJYxCTrbSjkwt34_Ykk9KU.wnC427dYP2k_cMOXyhTno3DtpkxDanQFmFWIzDDyxj8mj00.4OKpGs2fDII1SVM7z73pwpkfsg8xdL271Xqtf8_lHvFTM9WA32T3oPX9GLID3PcnQWTSNujIEq7hXbjlr11CsoMXFs4GcVJQvN8JxfD.PRC21p0P4ESq18bkaSY6xr0EtRNAwrXfejiX8DKqkV4rS0hfPzPt7C.8m78gKKeh95scFQ0FDRTkNkFJq8aF4N5llgv2yKH.F8bUJXVbKptR_1.LttZe6D2uIotMhQlwrLSu.1PrMEcCJhBB.cGmP1J4aummTQQ--&ap=55\\\\\\\",\\\\\\\"ia\\\\\\\":1,\\\\\\\"at\\\\\\\":\\\\\\\"Netflix\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"5287b89f-b0f0-3dab-9197-aa22905eaf4b\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000166\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"43b802f5-0558-39cc-9b76-348e3d40edc4\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000175\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"c7c72404-4eb8-3ea3-86b5-2657571ab856\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000427\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"4519c9a6-1a8f-3d9f-bcd3-dc88fec5bc77\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100001187\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"d712ff7a-7042-30b9-8867-19b51ecb96d2\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4065600232\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"37b64b20-2ba3-31e1-9e02-418af076fcf5\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4090000299\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"586a9615-991d-3faf-9c7d-e7ff8179d511\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000367\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"51aceae4-c48c-3955-bc3d-deabf73b0d4c\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100001042\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"1725fbc9-413b-3fff-a0c5-60ec4702f7c2\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000553\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"0d92f3cd-9815-312a-abc3-79c0fa565d00\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4090000263\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"fcb60a92-a1a0-35d5-abcf-08f9f9117095\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4020500659\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"c2ecaa77-69b8-38ea-9a81-866f52ad3b10\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4072900590\\\\\\\"},{\\\\\\\"u\\\\\\\":21713975,\\\\\\\"s\\\\\\\":\\\\\\\"Find out how this unexpected joint solution is helping Americans live happier, healthier lives after 50!\\\\\\\",\\\\\\\"im\\\\\\\":{\\\\\\\"original\\\\\\\":{\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l5.yimg.com\\\\\\\\\\\\/av\\\\\\\\\\\\/moneyball\\\\\\\\\\\\/ads\\\\\\\\\\\\/216216-1372864886-2128.jpg\\\\\\\",\\\\\\\"width\\\\\\\":82,\\\\\\\"height\\\\\\\":61,\\\\\\\"orientation\\\\\\\":\\\\\\\"landscape\\\\\\\",\\\\\\\"ratio\\\\\\\":1.344262295082}},\\\\\\\"ur\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/ad.yieldmanager.com\\\\\\\\\\\\/clk?3,eJytjcsOgjAURH-IRaEW2jQuylMMtJKApluoJSAkJkJQv97wiP6AZzF3JneSMSFVdlVWVqkxVkhBVVIT6opcgVYKG4BSajnERg7CBBts5oSHbGLwHDzcJR.kWNRsZb5u7W29WQMfiZFl65ub6s7-gkeOLN58vOzWPmZIv-tXjt1vLZK71MqeIs9AcimQiOSQ5mGXNmbDW9UleTDxlgHZh73w-Y3.BvaGAT430E.b,http%3A%2F%2Fwww.instaflex.com%2Freport%2Farticles.php%3Ft202id%3D512118%26t202kw%3Dysa_i_7\\\\\\\",\\\\\\\"t\\\\\\\":\\\\\\\"8 Simple Joint Ingredients You Won't Believe\\\\\\\",\\\\\\\"b\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/ad.yieldmanager.com\\\\\\\\\\\\/csc?ve=2&z5Q9IuZ2wp3bd2eG4xH9XWB4PhaW4myay4VzgY1UCeysWm4Sz3hkoRJZIxIVjvpt8.qZvkNg2VEzum.2ZV12VCpiybciLb_X6dhagEMF0YC4nWuvwZuJgvGmDEeN26B6Wuzob2wuJ3F_hXsTuPQVqBfbAb_oEG_Uyj1fJ20USxiKtqoeQ8RwdAmln_wPcjhlLo_sSFXNsj2KFFQYJxp49uHTIVfq81.mrUbHISr52A6uaYmhzcbGmAPZtkOXk6wTaHW1CAStKVb15S3d7an4BGxU8XpC.giGc4hxdHkFpTinG40ecJE2pM6VKR7vwoiVR5OEVv.6IH5rWfUga1V8.B7PWV7_975IVprtXE.glE.0xh0poAHLQXk44h0FY7I0NGnF293lajgLM6hcTcBrAwmHKHbNoO83DkMs8I2FH7qGcfms2eDI41w2ukCykrt8vNGdrdd0MU8OFdbQ2PpiqGskzIFQ9SJeULwqMJwJR2P7RXMKEJFlkihu693VR58Agi.ERg6hXn5xkdJOgFo0kIdbnTRcrK5_Fe.xeevUaNfpP6wKVJKA9iPj.S7Mqv6HJHkUIETeAWtor7mGfsYLXWzb2m.Ir8303EvFvnVlgg8Ro7xUcplwEuumMpOPqwOHA0k7NvjxvzbH_EW6_pJ8maGmPD_uAynDXpt3CnlDa7o0Nl0iOBOr_9kDgkWVyJKswytJDOCGo.bt3UPLgHKmObQMyOh94jg8R_FWsO54ZvJ6UWm4g3_0MvWvFgIM9mG83KcLeS3LywLWKEinSsY.GjCTqlpHlwJCl8bwU_yl3JsC2v71boE77slOwVsfJ_WhfQ--&ap=68\\\\\\\",\\\\\\\"ia\\\\\\\":1,\\\\\\\"at\\\\\\\":\\\\\\\"Instaflex\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"1be2994f-2025-3f60-a257-3e7a48049747\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4081000572\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"de1a9017-c4fa-375a-ba6c-f3ffea663e3d\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4072900197\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"9cf878bf-6b71-312f-aae4-95d81bab2441\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100001024\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"7c28287a-cd26-3ecf-a193-d1775345c1b9\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4081000424\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"fad57397-28be-3323-9ee7-d379519b57b8\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4090000132\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"a39d803c-107e-3210-91b9-404f0f9f688c\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4065600702\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"fccf2bde-bbc9-3aef-880e-ce36cae7f85a\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100001033\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"b4302a7d-ee75-3d80-855f-de2dee077577\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4072900375\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"9bf503a7-4f45-3294-9446-d57ed3fa0f76\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4034800382\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"87c2b200-aa22-3ecf-99d6-72a7c6012b2d\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4038700255\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"4ed583ae-67ff-3853-aaf1-86901581ce2d\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4059000197\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"47b95c91-2def-3d3c-9b80-9fd816c94043\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100001213\\\\\\\"},{\\\\\\\"u\\\\\\\":20950156,\\\\\\\"s\\\\\\\":\\\\\\\"Local auto dealers have begun cutting their prices for the summer.  If you're looking for a new car this season, buy now and save as much as ...\\\\\\\",\\\\\\\"im\\\\\\\":{\\\\\\\"original\\\\\\\":{\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l2.yimg.com\\\\\\\\\\\\/av\\\\\\\\\\\\/moneyball\\\\\\\\\\\\/ads\\\\\\\\\\\\/206635-1369234902-9746.jpg\\\\\\\",\\\\\\\"width\\\\\\\":82,\\\\\\\"height\\\\\\\":80,\\\\\\\"orientation\\\\\\\":\\\\\\\"landscape\\\\\\\",\\\\\\\"ratio\\\\\\\":1.025}},\\\\\\\"ur\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/ad.yieldmanager.com\\\\\\\\\\\\/clk?3,eJytjl8LgjAUxb-QD9M53Rg9zL9ZOhOM2KO6Zlq-hDDs05c26Av0g3M5h3vhXBtS6XVt57QKY4kklC21oerIFSgpsQUopY5PPOQjTLDFVk54rnRYPCMcbHl.I7VmX.qPgj40d-uMI3hsGrPWAE3sL4TkwDLjs623jzBD6tUvtflrJRVu4VSLGDM3v5xRmYq5qJNHMdgDH-WU17HmIwNiSqYy4nf-K9hZFngDFB1Pww==,http%3A%2F%2Fpixel.autoaffiliatenetwork.com%2Fd%2F%3Fid%3D009%26adtargeting%3Dimage_Chrysler300_text_Summer2013%26dest%3DAPF\\\\\\\",\\\\\\\"t\\\\\\\":\\\\\\\"Auto Dealers Cut Prices for Summer 2013\\\\\\\",\\\\\\\"b\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/ad.yieldmanager.com\\\\\\\\\\\\/csc?ve=2&wgk9rVF2wp3mSOqz_lLU1uYrg_eo62EPleF_B4Y8TfVRrLgxq2OucRooPK62BnKioNxCjco237tZGFe1LIRJOTt9Np0xZ6blWoAH3.gFIKMQgCz.GAk1kZvM1CZc.VrDtfOtauBmrchheiP9KEIBJhe1gmBsXrQqATXH4UPmmj8G4YSAs.ivPwBlIWTio6m6evw9Zn7B41C952pphaMA1cPMzLK2ofaUn_tcYex0pIFJtZOEvOwAM8pEhV92nVqtfnoJNoM8T68_.D0toqJJ9x.Wiu_oVFXOWCkZ4uJwLKrMfLlvXZ4wd95GW1bIKm__CwtKWQ9qfqF3Vy.9tJtMTx4iBrl1R3LnyqBCV3PNWTtXib1iNxNhWUg2vRYbiqXaBM.HYQyAHUXtc17nnjYpDJDizo3J6osrvk3dA5eDKw2ypj_P_LyaJHVeFaaAwubd0r.OZ1oGq_3b3AmAAjvdbDyihyjFEM7RxwCjW43EA6nbJFz868ZbDdMMUhGFV8kMySkUvAqaT8hAO3et8D1c8ZqPHuML3C_DfbHiC7EdlXQWhlGHbt40bN7fEo0skMKVeLYOLE5xmCYk5avdkwaHbYai8lO3m1lgv1UiTvgK5IGpipNi0LV5Jgo52I6sZ7GMMwbHIf5cqE0_Ss9MKpdU_UPDRLfQpLu87NBYUY1Qbxkb7Z9XiYUv8uEG583rZKxhVLCDdECG6q4BjgnBZwdf9KXTUyHiT.jwzyYt_f0yIHSpGACJIowkyI5MQONoaoxN05fx4TxXI761SEAGPd4LfRQ7uBQwYzjknlwGdvR6ZmlepElIPowTpbio673OH.SG_w--&ap=81\\\\\\\",\\\\\\\"ia\\\\\\\":1,\\\\\\\"at\\\\\\\":\\\\\\\"Auto-Price-Finder.com\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"3a34e541-0403-3e59-b0d0-f0fb28666525\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4025400410\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"8f518ad0-4b6e-34f0-97b0-81fcf08ebaea\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4053100205\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"e4bb5d47-7633-3c34-83d5-0612bbb1da97\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4034800337\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"dacd78e7-9feb-3a5b-93da-4671482229b2\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4034800248\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"e771ab9e-bef4-36f0-a1f6-745e13c58aa4\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4053100169\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"4832980c-2037-3392-b43e-846739d2a79e\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100001064\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"b4bebef1-c728-3d5b-9f21-cee351d0c35a\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4031300420\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"365f8ec3-3449-3292-bedd-b8525ea07a98\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4053100421\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"81e651ea-58d5-34ac-8d57-fb424d7b24a0\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4020500310\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"ade7515b-f561-356b-810d-457e63632c09\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000961\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"7ac0b3f5-9a41-3595-85e7-b394b8f49b28\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4031300207\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"840f9c6d-87ba-3b2d-aa1a-3c3c4b7a5a4c\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4022800272\\\\\\\"},{\\\\\\\"u\\\\\\\":20802476,\\\\\\\"s\\\\\\\":\\\\\\\"A recently published study shows no long-term benefit from traditional glucosamine joint supplements. See the study results to learn more.\\\\\\\",\\\\\\\"im\\\\\\\":{\\\\\\\"original\\\\\\\":{\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l3.yimg.com\\\\\\\\\\\\/av\\\\\\\\\\\\/moneyball\\\\\\\\\\\\/ads\\\\\\\\\\\\/0-1368480943-1495.jpg\\\\\\\",\\\\\\\"width\\\\\\\":50,\\\\\\\"height\\\\\\\":75,\\\\\\\"orientation\\\\\\\":\\\\\\\"portrait\\\\\\\",\\\\\\\"ratio\\\\\\\":0.66666666666667}},\\\\\\\"ur\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/ad.yieldmanager.com\\\\\\\\\\\\/clk?3,eJytjcsOgjAURH-IRXmVNo2L8gwIxRqI6ZKAraC4kUjk6xXS6A94krmZyZ1kTJsAD0IbOtJB0jJl1xLTli0-A9l12ACEEMvD0PVchJFBVw5o4nPwaBbgbznjz5pq1Ee-CnRvvVFo75tGv.nxcqd.IcAZTbVPt10VIurKRb0q5H9riXAKiy.Cyob8VLtlIqaiim9Fb.ZsUHNeRTMbKBBjPJYhu7LfwM4wwBtnLk9N,http%3A%2F%2Fwww.naturaljoint.org\\\\\\\",\\\\\\\"t\\\\\\\":\\\\\\\"Studies Show No Long-Term Benefit From Glucosamine\\\\\\\",\\\\\\\"b\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/ad.yieldmanager.com\\\\\\\\\\\\/csc?ve=2&ZQjKS5t2wp3tdUaHBIGodCYuG_f3c5Q4RHqRNOmFAIMu41CRpQIRRuAAZhRoQCp5qJKzdMRuKPM32HsWqTY84M2.gIvMeyqpFp.vbvxAwvHnDikl1xhO3T5SmF3n7_1uXWU.4F5umCyNbqAcCSf4n9qnGYNOxMSL_.KmxOc.3liYZsT_.CUaPGJ.cy4o_yTOMOXpIXVik6NPLnIGSjGNkCpatrycqxM2aZ7mTp.lyI0E8GbTfGd1QSEooEp2eEFenA8mlljk2vlxuFzN4mrivDaUVzu6X9BDgVFi21ZsDPWnGhTkBD8c2rb4yTPIwqKUBWdm6GNRabofrfmgc2zV4tnU9WpW13xA7DTsCIwTzynBadCXAq9W_vevF4rpXCgr4f0mSltZ6F_wCi.S0l29bYmKwY3vBoOWjw502JfwyHh9VSVJz.Gj.kEkeUYhCqMYDGy5dnY0B4my.n6Xv5GrxXYJpItSEU.6v_ELmSGOTvGBH.7T7ubN51tyKu2GnbYuvvTHcCy12rZ5K6F4UFiehMvRIse9ZqtRorK6PpgJ04.9KJEtxwkrjXrNEUnSGkBtO_pH4MxMlHMQBs1_8BfE1_3dwmgEkgnAbFywwYiH9eythSiYeuypC0hsSF1T37y1La2n_W6zqab560xTMLB8KDXxgxYhkykOhrrsGlutOqYFEUt_VjYxZ8MNiu6RDbJhUrTZs55XTY0qs4_Wu5BjhbyOB5QiuXFfXtR.AFpVXkfhYRZmebXzZeUKeafnJQYvAxAYVEK_KjbkdxzEBOgptMZuEqSn2UJl2PRqDhFu.qlbE7nElmRpvh6Zz9ulSbNjvw--&ap=94\\\\\\\",\\\\\\\"ia\\\\\\\":1,\\\\\\\"at\\\\\\\":\\\\\\\"Greek Island Labs\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"d443a8ca-9d9d-3adf-aaaf-00d01aee0747\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4028200497\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"036f4818-5282-3896-a7c0-e03a87689ca5\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4016600299\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"5405616f-5db9-3cf0-b76d-6c0ae86b8d0e\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4015000774\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"8ffe28b2-6ff5-3f89-87b3-73f90aab3ce0\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4020500222\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"77d99ad3-23b2-31a4-9d15-beda9147cf9e\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4090001038\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"6721eeda-5e99-3b9e-85b2-ad4f1a29ffa3\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4010000398\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"64a0f5e9-826f-30c1-b87a-cdd14e8f044b\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4022800216\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"e8f5bb9e-a7fa-3ddc-a3ed-5984194e14d1\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4018500417\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"4398511d-e0b9-3bcc-b8d7-8c927257da97\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4020500168\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"0224f7db-6b78-37eb-bb13-96c734c79645\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100001084\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"716a86c2-e772-3b80-ba2f-37ed8ecda763\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4012100274\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"3b06a203-610c-3a58-8024-a51b661e896b\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100001004\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"af11785a-f5c8-3e8d-bf22-0a8d0203aa77\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4012100286\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"fab07708-6eec-331c-a049-53f865291f9b\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4012100261\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"55836cbc-0d5c-3fbe-b9bf-13bdbb891e66\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4005302076\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"d8c76553-0434-33b6-b68c-a39e35bba1bb\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4013500176\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"95cbd68e-ffcb-3da5-8dfd-436af201ec90\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4009800349\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"e8528082-d943-35fc-af50-14e4c1f8180e\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4010900162\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"45888b8f-3460-3aa1-9a52-2dfe51afff60\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000940\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"3a8ef146-eaf8-30f1-ab7f-bab556ede552\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4010000412\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"f0e4f3e4-7690-38c4-b0b0-ba27c7800fdc\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4010000176\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"f784f21c-dea8-3214-a2bd-4448415496ff\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4007900196\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"733bf5ee-6160-3040-82d5-1d2f42636f8b\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000874\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"db5e4a50-d8ef-386f-b1e6-e25cdf7f287a\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4009800156\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"90742b99-96f2-38a3-9ad1-f55b2620aaee\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4010000159\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"2ad2eb07-5b9c-307c-b9ff-bcb3aa6bf5b8\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4009000163\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"83795d21-e026-38af-b60b-62dc9facb361\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4007100533\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"f8528bff-bebc-36e9-9e88-cc513c0787c6\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000869\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"5dc7227d-d4a6-352f-8649-0db6aa60341d\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4007100507\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"43e80a47-79ec-3809-ac98-1518389138c7\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4005300268\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"2efae028-b5e0-39a5-980b-7c19ab0f0244\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4007900187\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"9db1ef8a-a304-3fa9-9e1c-b465e737c544\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4004700714\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"6c039a5e-146d-3da8-812c-fb6d65e19f76\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4005800470\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"c2ab26f4-4d85-34de-9900-e8fb300fc296\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000965\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"0bb3174a-3588-3c95-a547-6c0cb658a1c0\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4007100521\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"b40c8d61-0cfc-365c-919f-dc77294f18e1\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4004700201\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"929877e0-37bb-39dd-9bee-f9e8bbe00dc9\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4006400154\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"8a47ca09-04b3-337f-b6ff-583211b66950\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4004700159\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"a63cf34e-c218-3e8d-892b-0bbc6156f9d8\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100001054\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"973d19f5-0a84-333c-b992-8eeedd738f43\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4005800130\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"4153a74c-4462-3ee0-bc00-dff34f2d850f\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4005200351\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"7e9aea73-f2a9-3a22-bbf3-d6e29ae9fe19\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4003800180\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"97231cf5-bb20-3ff0-802b-a452829f1fa8\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4003400207\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"09c0d581-8f4f-3555-871e-31a0b18a7951\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000916\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"3d28a848-ba81-36fe-9887-29f619d7ccf4\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4001600320\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"1216abdc-0bc1-3b4c-b978-4c4d848a26bb\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4002500171\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"45860a48-cd9e-3f22-b47b-d286f2110b6a\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000400834\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"502e5b36-45b9-3ee1-bfe1-648774619bcb\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4002200280\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"5ba9c757-db40-3d11-bf39-ae7cc0a41761\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4001100426\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"9e07f5b8-ae97-3c06-9843-1beaf8ff297e\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000935\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"f540de91-027a-3001-8280-5af27c52c12c\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000300502\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"e2b6485f-3de9-3bba-85da-4ddb382a056f\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100001019\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"fe72c946-5768-3657-aaa1-d0c92ed812b4\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000200523\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"2f6fa4bf-7163-3097-962e-5dbd610c2c21\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000200360\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"1d1e6988-fd19-36ec-a633-a290e04d1bab\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000100441\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"24f5c185-57dc-37e7-8698-dd1838bda8a4\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000200732\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"7940011d-7d91-3045-a1aa-eeecfdd0450c\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000100312\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"12577891-fe2e-3bf6-8872-48283cc99542\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000100230\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"db030f8d-4a11-31e4-86e4-cb8f0f8aaf82\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000891\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"3c1b56c7-a888-3532-8f69-823389ab58d7\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000100152\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"bd973d04-cffe-3617-bc91-64631e02e263\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000100304\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"8ca67350-b65a-3884-b411-df6018ebbf14\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000837\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"e115e1c2-e6e7-34b5-8725-65647725e6f3\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000000218\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"3184a818-422d-31fa-b2ca-3fc25f1e8306\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000000320\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"9d0d8429-ce92-3d20-96df-8dcdc20a1185\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000000347\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"da3fd914-a729-3606-93ce-58d974416a92\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000000246\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"ebe271cf-d612-3d45-8886-03aeb92bb7cd\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000000362\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"2382e5e0-34c2-3019-9bc1-dd64411f42b6\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000828\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"6ae66b10-fc06-31ad-bdce-f630dab5f4fc\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000000301\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"979f41be-1edc-32f5-ac09-17715c88e294\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000000282\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"d8ca681e-2bfb-3e08-b33f-0d41e9916217\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000000292\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"933524d2-947f-3f9c-aeae-a5a45b0619b8\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4065601209\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"d9a55b19-9a27-3da5-b16b-c6f245fbc386\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000000131\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"9d198649-3883-3f02-a39f-33e7c6ac21f8\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000000155\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"4ec09f8e-84c3-3934-b092-39cb092d10a2\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000000510\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"89f6b64e-b044-3bcf-9af8-7a8e16cba9c4\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000000328\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"8a1c7605-0ff6-3150-9990-76dae34185d8\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000002190\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"408b827f-4639-3495-bbc5-33698c6a3bc7\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000000560\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"fcc8c90a-e9a3-3d4d-b0c6-80066b5a761a\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100001013\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"c96bd902-72ef-3422-a162-bb80c37028e1\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000000207\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"44f44e84-8894-3136-b6fc-efb8b7c77f84\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000000238\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"29b950b3-b185-31cd-97ed-21927a63fabc\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000898\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"8cff3d5f-1313-3198-b0c2-c9582925c56c\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000000321\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"bcd13eef-3b76-3eb8-b13e-66e0a2432378\\\\\\\",\\\\\\\"flbk\\\\\\\":true},{\\\\\\\"u\\\\\\\":\\\\\\\"cf8c7775-d027-3207-af8c-86bffe8db6fe\\\\\\\",\\\\\\\"flbk\\\\\\\":true}],\\\\\\\"contentpos\\\\\\\":22,\\\\\\\"interestsData\\\\\\\":{\\\\\\\"YCT:001000667\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Crime & Justice\\\\\\\",\\\\\\\"count\\\\\\\":0,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/news.yahoo.com\\\\\\\\\\\\/crime-and-justice\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"YCT:001000780\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Society\\\\\\\",\\\\\\\"count\\\\\\\":164,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/news.yahoo.com\\\\\\\\\\\\/society-and-culture\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Shooting_of_Trayvon_Martin\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Shooting of Trayvon Martin\\\\\\\",\\\\\\\"count\\\\\\\":120,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/www.yahoo.com\\\\\\\\\\\\/topic\\\\\\\\\\\\/shooting-of-trayvon-martin\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"YCT:001000661\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Politics\\\\\\\",\\\\\\\"count\\\\\\\":161,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/news.yahoo.com\\\\\\\\\\\\/politics-and-government\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"YCT:001000700\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Immigration Issues\\\\\\\",\\\\\\\"count\\\\\\\":0,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/news.yahoo.com\\\\\\\\\\\\/immigration-issues\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Culture_of_the_United_States\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Culture of the United States\\\\\\\",\\\\\\\"count\\\\\\\":1,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/www.yahoo.com\\\\\\\\\\\\/topic\\\\\\\\\\\\/culture-of-the-united-states\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"YCT:001000346\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Personal Investing Ideas & Strategies\\\\\\\",\\\\\\\"count\\\\\\\":48,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/news.yahoo.com\\\\\\\\\\\\/personal-investing-ideas-and-strategies\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"YCT:001000992\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Transportation\\\\\\\",\\\\\\\"count\\\\\\\":0,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/news.yahoo.com\\\\\\\\\\\\/transportation\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"YCT:001000395\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Health\\\\\\\",\\\\\\\"count\\\\\\\":167,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/news.yahoo.com\\\\\\\\\\\\/health\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"YCT:001000495\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Family Health\\\\\\\",\\\\\\\"count\\\\\\\":0,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/news.yahoo.com\\\\\\\\\\\\/family-health\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"YCT:001000069\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Celebrities\\\\\\\",\\\\\\\"count\\\\\\\":86,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/news.yahoo.com\\\\\\\\\\\\/celebrities\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"YCT:001000070\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Royal Families\\\\\\\",\\\\\\\"count\\\\\\\":0,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/news.yahoo.com\\\\\\\\\\\\/royal-families-2\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Prince_Harry_of_Wales\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Prince Harry of Wales\\\\\\\",\\\\\\\"count\\\\\\\":1,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/www.yahoo.com\\\\\\\\\\\\/topic\\\\\\\\\\\\/prince-harry-of-wales\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Kensington_Palace\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Kensington Palace\\\\\\\",\\\\\\\"count\\\\\\\":2,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/www.yahoo.com\\\\\\\\\\\\/topic\\\\\\\\\\\\/kensington-palace\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"YCT:001000680\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Foreign Policy\\\\\\\",\\\\\\\"count\\\\\\\":39,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/news.yahoo.com\\\\\\\\\\\\/foreign-policy\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Barack_Obama\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Barack Obama\\\\\\\",\\\\\\\"count\\\\\\\":293,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/news.yahoo.com\\\\\\\\\\\\/barack-obama\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Mohamed_Morsi\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Mohamed Morsi\\\\\\\",\\\\\\\"count\\\\\\\":89,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/www.yahoo.com\\\\\\\\\\\\/topic\\\\\\\\\\\\/mohamed-morsi\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Egypt\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Egypt\\\\\\\",\\\\\\\"count\\\\\\\":188,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/news.yahoo.com\\\\\\\\\\\\/egypt\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:United_States\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"United States\\\\\\\",\\\\\\\"count\\\\\\\":136,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/www.yahoo.com\\\\\\\\\\\\/topic\\\\\\\\\\\\/united-states\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Hosni_Mubarak\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Hosni Mubarak\\\\\\\",\\\\\\\"count\\\\\\\":36,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/news.yahoo.com\\\\\\\\\\\\/hosni-mubarak\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Cairo\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Cairo\\\\\\\",\\\\\\\"count\\\\\\\":6,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/www.yahoo.com\\\\\\\\\\\\/topic\\\\\\\\\\\\/cairo\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"YCT:001000267\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Education\\\\\\\",\\\\\\\"count\\\\\\\":46,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/news.yahoo.com\\\\\\\\\\\\/education\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"YCT:001000269\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Schools\\\\\\\",\\\\\\\"count\\\\\\\":0,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/news.yahoo.com\\\\\\\\\\\\/schools\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Elementary_school\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Elementary school\\\\\\\",\\\\\\\"count\\\\\\\":1,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/news.yahoo.com\\\\\\\\\\\\/elementary-school\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Immigration_reform\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Immigration reform\\\\\\\",\\\\\\\"count\\\\\\\":32,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/www.yahoo.com\\\\\\\\\\\\/topic\\\\\\\\\\\\/immigration-reform\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"YCT:001000705\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Military\\\\\\\",\\\\\\\"count\\\\\\\":53,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/news.yahoo.com\\\\\\\\\\\\/military-and-defense\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Unmanned_aerial_vehicle\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Unmanned aerial vehicle\\\\\\\",\\\\\\\"count\\\\\\\":2,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/www.yahoo.com\\\\\\\\\\\\/topic\\\\\\\\\\\\/unmanned-aerial-vehicle\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Aircraft_carrier\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Aircraft carrier\\\\\\\",\\\\\\\"count\\\\\\\":1,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/www.yahoo.com\\\\\\\\\\\\/topic\\\\\\\\\\\\/aircraft-carrier\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Patuxent_River\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Patuxent River\\\\\\\",\\\\\\\"count\\\\\\\":1,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/www.yahoo.com\\\\\\\\\\\\/topic\\\\\\\\\\\\/patuxent-river\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"YCT:001000123\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Business\\\\\\\",\\\\\\\"count\\\\\\\":0,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/news.yahoo.com\\\\\\\\\\\\/business\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Panera_Bread\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Panera Bread\\\\\\\",\\\\\\\"count\\\\\\\":11,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/www.yahoo.com\\\\\\\\\\\\/topic\\\\\\\\\\\\/panera-bread\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"YCT:001000804\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Religion\\\\\\\",\\\\\\\"count\\\\\\\":30,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/news.yahoo.com\\\\\\\\\\\\/religion-and-beliefs\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Southern_Baptist_Convention\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Southern Baptist Convention\\\\\\\",\\\\\\\"count\\\\\\\":1,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/www.yahoo.com\\\\\\\\\\\\/topic\\\\\\\\\\\\/southern-baptist-convention\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:National_Security_Agency\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"National Security Agency\\\\\\\",\\\\\\\"count\\\\\\\":62,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/www.yahoo.com\\\\\\\\\\\\/topic\\\\\\\\\\\\/national-security-agency\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:California\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"California\\\\\\\",\\\\\\\"count\\\\\\\":73,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/news.yahoo.com\\\\\\\\\\\\/california\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Solitary_confinement\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Solitary confinement\\\\\\\",\\\\\\\"count\\\\\\\":2,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/www.yahoo.com\\\\\\\\\\\\/topic\\\\\\\\\\\\/solitary-confinement\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"YCT:001000681\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Government\\\\\\\",\\\\\\\"count\\\\\\\":0,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/news.yahoo.com\\\\\\\\\\\\/government\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:White_House\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"White House\\\\\\\",\\\\\\\"count\\\\\\\":128,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/news.yahoo.com\\\\\\\\\\\\/white-house-2\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Presidency_of_Barack_Obama\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Presidency of Barack Obama\\\\\\\",\\\\\\\"count\\\\\\\":46,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/www.yahoo.com\\\\\\\\\\\\/topic\\\\\\\\\\\\/presidency-of-barack-obama\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Patient_Protection_and_Affordable_Care_Act\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Patient Protection and Affordable Care Act\\\\\\\",\\\\\\\"count\\\\\\\":33,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/news.yahoo.com\\\\\\\\\\\\/patient-protection-and-affordable-care-act\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Ink_cartridge\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Ink cartridge\\\\\\\",\\\\\\\"count\\\\\\\":1,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/www.yahoo.com\\\\\\\\\\\\/topic\\\\\\\\\\\\/ink-cartridge\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1}},\\\\\\\"ccode\\\\\\\":\\\\\\\"news\\\\\\\"},\\\\\\\"props\\\\\\\":{\\\\\\\"refHandler\\\\\\\":\\\\\\\"cfg.maple_dali.handler.refresh\\\\\\\",\\\\\\\"id\\\\\\\":\\\\\\\"u_30345786\\\\\\\",\\\\\\\"ns\\\\\\\":\\\\\\\"type_stream\\\\\\\",\\\\\\\"trusted\\\\\\\":true,\\\\\\\"type\\\\\\\":\\\\\\\"stream\\\\\\\",\\\\\\\"contentId\\\\\\\":\\\\\\\"30345786\\\\\\\",\\\\\\\"tags\\\\\\\":[],\\\\\\\"title\\\\\\\":\\\\\\\"Stream\\\\\\\",\\\\\\\"icon\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"shortTitle\\\\\\\":\\\\\\\"Stream\\\\\\\",\\\\\\\"detailUrl\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"chromecolor\\\\\\\":\\\\\\\"blue\\\\\\\"},\\\\\\\"state\\\\\\\":{\\\\\\\"view\\\\\\\":\\\\\\\"default\\\\\\\",\\\\\\\"defer\\\\\\\":false,\\\\\\\"collapsed\\\\\\\":0},\\\\\\\"strs\\\\\\\":{\\\\\\\"STR.LOADING\\\\\\\":\\\\\\\"\\u003Cdiv class=\\\\\\\\\\\\\\\"fp-loader ti\\\\\\\\\\\\\\\"\\u003ELoad more stories\\u003C\\\\\\\\\\\\/div\\u003E\\\\\\\",\\\\\\\"STR.LOADING.CONTENT\\\\\\\":\\\\\\\"\\u003Cdiv class=\\\\\\\\\\\\\\\"loading next-batch\\\\\\\\\\\\\\\" data-key=\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\\\\\\\\\"fp-loader ti\\\\\\\\\\\\\\\"\\u003ELoad more stories&hellip;\\u003C\\\\\\\\\\\\/div\\u003E\\u003C\\\\\\\\\\\\/div\\u003E\\\\\\\",\\\\\\\"STR.BUTTON.REMOVE_DONE\\\\\\\":\\\\\\\"\\u003Cbutton class=\\\\\\\\\\\\\\\"fz-xxs remove-done uibutton rapid-noclick-resp\\\\\\\\\\\\\\\"\\u003EDone\\u003C\\\\\\\\\\\\/button\\u003E\\\\\\\",\\\\\\\"STR.REMOVE.CONFIRM\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"STR.BUTTON.WIKIID\\\\\\\":\\\\\\\"\\u003Cbutton class=\\\\\\\\\\\\\\\"fz-xxs wikiid uibutton rapid-noclick-resp {selected}\\\\\\\\\\\\\\\" data-wikiid=\\\\\\\\\\\\\\\"{id}\\\\\\\\\\\\\\\" data-interesttype=\\\\\\\\\\\\\\\"{type}\\\\\\\\\\\\\\\"\\u003E{name}\\u003Cspan class=\\\\\\\\\\\\\\\"d-ib img-sprite remove-neg\\\\\\\\\\\\\\\"\\u003E\\u003C\\\\\\\\\\\\/span\\u003E\\u003C\\\\\\\\\\\\/button\\u003E\\\\\\\",\\\\\\\"STR.SHOW.LESS\\\\\\\":\\\\\\\"\\u003Cdiv class=\\\\\\\\\\\\\\\"show-less fz-xs\\\\\\\\\\\\\\\"\\u003EShow me fewer stories about:\\u003C\\\\\\\\\\\\/div\\u003E\\\\\\\",\\\\\\\"STR.REMOVE.MENU\\\\\\\":\\\\\\\"\\u003Cdiv class=\\\\\\\\\\\\\\\"menu\\\\\\\\\\\\\\\"\\u003E\\u003Cbutton class=\\\\\\\\\\\\\\\"fz-xs undo rapid-noclick-resp\\\\\\\\\\\\\\\"\\u003EUndo\\u003C\\\\\\\\\\\\/button\\u003E\\u003Cp class=\\\\\\\\\\\\\\\"title fz-xs\\\\\\\\\\\\\\\"\\u003EStory removed\\u003C\\\\\\\\\\\\/p\\u003E\\u003Cdiv class=\\\\\\\\\\\\\\\"remove-menu-main cf\\\\\\\\\\\\\\\"\\u003E\\u003C\\\\\\\\\\\\/div\\u003E\\u003Cdiv class=\\\\\\\\\\\\\\\"login hidden\\\\\\\\\\\\\\\"\\u003E\\u003Cdiv id=\\\\\\\\\\\\\\\"default-p_30345826_e86\\\\\\\\\\\\\\\" class=\\\\\\\\\\\\\\\"mod view_default\\\\\\\\\\\\\\\"\\u003E  \\u003Cdiv id=\\\\\\\\\\\\\\\"default-p_30345826_e86-bd\\\\\\\\\\\\\\\" class=\\\\\\\\\\\\\\\"bd type_login type_login_default\\\\\\\\\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\\\\\\\\\"embed\\\\\\\\\\\\\\\"\\u003E\\u003Ch3 class=\\\\\\\\\\\\\\\"title mb-l\\\\\\\\\\\\\\\"\\u003ESign in to save your preferences:\\u003C\\\\\\\\\\\\/h3\\u003E\\u003Cdiv class=\\\\\\\\\\\\\\\"btns fz-xs\\\\\\\\\\\\\\\"\\u003E\\u003Ca class=\\\\\\\\\\\\\\\"login-svc ylogin login-btn-purple rapid-noclick-resp login-btn-small\\\\\\\\\\\\\\\" href=\\\\\\\\\\\\\\\"https:\\\\\\\\\\\\/\\\\\\\\\\\\/login.yahoo.com\\\\\\\\\\\\/config\\\\\\\\\\\\/login?.src=fpctx&.intl=us\\\\\\\\\\\\\\\" data-action=\\\\\\\\\\\\\\\"click\\\\\\\\\\\\\\\" data-action-outcome=\\\\\\\\\\\\\\\"login\\\\\\\\\\\\\\\" data-ylk=\\\\\\\\\\\\\\\"sec:td-strm-rm;slk:login-yh;itc:0;cat:;\\\\\\\\\\\\\\\"\\u003E\\u003Ci class=\\\\\\\\\\\\\\\"img-sprite y-icon\\\\\\\\\\\\\\\"\\u003E\\u003C\\\\\\\\\\\\/i\\u003EYahoo!\\u003C\\\\\\\\\\\\/a\\u003E \\u003Cspan class=\\\\\\\\\\\\\\\"login-or d-ib\\\\\\\\\\\\\\\"\\u003Eor\\u003C\\\\\\\\\\\\/span\\u003E \\u003Cspan class=\\\\\\\\\\\\\\\"fb-button-wrapper d-ib\\\\\\\\\\\\\\\"\\u003E\\u003Ca class=\\\\\\\\\\\\\\\"login-svc fblogin login-btn-fbblue rapidnofollow rapid-noclick-resp login-btn-small\\\\\\\\\\\\\\\" href=\\\\\\\\\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/open.login.yahoo.net\\\\\\\\\\\\/openid\\\\\\\\\\\\/yrp\\\\\\\\\\\\/hr_signin?.intl=us&idp=facebook&ts=1373481532&rpcrumb=GqjYGTOGPyf&.src=home&appid=90376669494&spid=b9ed13cc-ddec-11de-9c83-001b784d35e1&perms=email,user_birthday,user_education_history,user_likes,user_location,user_relationships,user_subscriptions,user_work_history,friends_birthday,friends_education_history,friends_likes,friends_location,friends_work_history\\\\\\\\\\\\\\\" data-action=\\\\\\\\\\\\\\\"click\\\\\\\\\\\\\\\" data-action-outcome=\\\\\\\\\\\\\\\"login\\\\\\\\\\\\\\\" data-ylk=\\\\\\\\\\\\\\\"sec:td-strm-rm;slk:login-fb;cat:;\\\\\\\\\\\\\\\" target=\\\\\\\\\\\\\\\"_blank\\\\\\\\\\\\\\\"\\u003E\\u003Ci class=\\\\\\\\\\\\\\\"img-sprite fb-icon\\\\\\\\\\\\\\\"\\u003E\\u003C\\\\\\\\\\\\/i\\u003EFacebook\\u003C\\\\\\\\\\\\/a\\u003E\\u003Cspan class=\\\\\\\\\\\\\\\"fb-disclaimer narrow-disclaimer fz-xxs\\\\\\\\\\\\\\\"\\u003EWe don't post anything without your permission.\\u003C\\\\\\\\\\\\/span\\u003E\\u003C\\\\\\\\\\\\/span\\u003E\\u003C\\\\\\\\\\\\/div\\u003E\\u003C\\\\\\\\\\\\/div\\u003E    \\u003C\\\\\\\\\\\\/div\\u003E\\\\\\\\n\\u003C\\\\\\\\\\\\/div\\u003E\\u003C\\\\\\\\\\\\/div\\u003E\\u003Ca class=\\\\\\\\\\\\\\\"profile-link d-ib rapid-noclick-resp fz-xs dn\\\\\\\\\\\\\\\" href=\\\\\\\\\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/profile.yahoo.com\\\\\\\\\\\\/y\\\\\\\\\\\\/settings\\\\\\\\\\\\/interests\\\\\\\\\\\\/\\\\\\\\\\\\\\\"\\u003EEdit content preferences\\u003C\\\\\\\\\\\\/a\\u003E\\u003C\\\\\\\\\\\\/div\\u003E\\\\\\\"},\\\\\\\"res\\\\\\\":{},\\\\\\\"mods\\\\\\\":[{\\\\\\\"props\\\\\\\":{\\\\\\\"trusted\\\\\\\":true,\\\\\\\"id\\\\\\\":\\\\\\\"p_30345810_eab\\\\\\\",\\\\\\\"type\\\\\\\":\\\\\\\"fstream\\\\\\\",\\\\\\\"ns\\\\\\\":\\\\\\\"type_fstream\\\\\\\",\\\\\\\"contentId\\\\\\\":\\\\\\\"30345810\\\\\\\",\\\\\\\"tags\\\\\\\":[],\\\\\\\"title\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"icon\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"shortTitle\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"detailUrl\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"chromecolor\\\\\\\":\\\\\\\"blue\\\\\\\"},\\\\\\\"data\\\\\\\":{\\\\\\\"dropdownHover\\\\\\\":true,\\\\\\\"dynamicMax\\\\\\\":0,\\\\\\\"filterRestoreEnabled\\\\\\\":false,\\\\\\\"dropdownFilter\\\\\\\":false,\\\\\\\"tabFilter\\\\\\\":true,\\\\\\\"autoHideEnabled\\\\\\\":true,\\\\\\\"recentFiltersEnabled\\\\\\\":false,\\\\\\\"saveEnabled\\\\\\\":false,\\\\\\\"swipeFilterEnabled\\\\\\\":false,\\\\\\\"filterFontSize\\\\\\\":\\\\\\\"fz-s\\\\\\\"},\\\\\\\"strs\\\\\\\":{\\\\\\\"STR.FILTERS.FILTERBY\\\\\\\":\\\\\\\"Filter by\\\\\\\"},\\\\\\\"state\\\\\\\":{\\\\\\\"view\\\\\\\":\\\\\\\"default\\\\\\\",\\\\\\\"defer\\\\\\\":false,\\\\\\\"collapsed\\\\\\\":0},\\\\\\\"prefs\\\\\\\":{\\\\\\\"isc\\\\\\\":0,\\\\\\\"_mc\\\\\\\":0}}]}]}],\\\\\\\"res\\\\\\\":{\\\\\\\"css\\\\\\\":{\\\\\\\"helpers_css\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/ui\\\\\\\\\\\\/helpers_0.0.6.css\\\\\\\",\\\\\\\"typography_css\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/ui\\\\\\\\\\\\/typography_0.0.2.css\\\\\\\",\\\\\\\"theme_default_css\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/theme\\\\\\\\\\\\/default\\\\\\\\\\\\/common_0.0.29.css\\\\\\\",\\\\\\\"theme_default_desktop_css\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/theme\\\\\\\\\\\\/default\\\\\\\\\\\\/desktop_0.0.62.css\\\\\\\",\\\\\\\"tooltip_service_css\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/uiplugins\\\\\\\\\\\\/tooltip_service_1.0.12.css\\\\\\\",\\\\\\\"type_stream_css\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/stream\\\\\\\\\\\\/stream_0.0.271.css\\\\\\\",\\\\\\\"theme_gs_css\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/stream\\\\\\\\\\\\/theme_gs_0.0.45.css\\\\\\\",\\\\\\\"login_service_css\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/uiplugins\\\\\\\\\\\\/login_service_0.0.3.css\\\\\\\",\\\\\\\"rmx_ads_css\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/stream\\\\\\\\\\\\/rmx_ads_0.0.8.css\\\\\\\",\\\\\\\"type_fstream_desktop_css\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/fstream\\\\\\\\\\\\/fstream_desktop_0.0.21.css\\\\\\\",\\\\\\\"type_login_css\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/login\\\\\\\\\\\\/login_0.0.71.css\\\\\\\"},\\\\\\\"js\\\\\\\":{\\\\\\\"oop\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/yui\\\\\\\\\\\\/oop_3.8.1.js\\\\\\\",\\\\\\\"event-custom-base\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/yui\\\\\\\\\\\\/event-custom-base_3.8.1.js\\\\\\\",\\\\\\\"event-base\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/yui\\\\\\\\\\\\/event-base_3.8.1.js\\\\\\\",\\\\\\\"io-base\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/yui\\\\\\\\\\\\/io-base_3.8.1.js\\\\\\\",\\\\\\\"json-parse\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/yui\\\\\\\\\\\\/json-parse_3.8.1.js\\\\\\\",\\\\\\\"json-stringify\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/yui\\\\\\\\\\\\/json-stringify_3.8.1.js\\\\\\\",\\\\\\\"cookie\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/yui\\\\\\\\\\\\/cookie_3.8.1.js\\\\\\\",\\\\\\\"jsonp\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/yui\\\\\\\\\\\\/jsonp_3.8.1.js\\\\\\\",\\\\\\\"dom-core\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/yui\\\\\\\\\\\\/dom-core_3.8.1.js\\\\\\\",\\\\\\\"dom-base\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/yui\\\\\\\\\\\\/dom-base_3.8.1.js\\\\\\\",\\\\\\\"dom-style\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/yui\\\\\\\\\\\\/dom-style_3.8.1.js\\\\\\\",\\\\\\\"selector-native\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/yui\\\\\\\\\\\\/selector-native_3.8.1.js\\\\\\\",\\\\\\\"selector\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/yui\\\\\\\\\\\\/selector_3.8.1.js\\\\\\\",\\\\\\\"node-core\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/yui\\\\\\\\\\\\/node-core_3.8.1.js\\\\\\\",\\\\\\\"node-base\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/yui\\\\\\\\\\\\/node-base_3.8.1.js\\\\\\\",\\\\\\\"node-style\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/yui\\\\\\\\\\\\/node-style_3.8.1.js\\\\\\\",\\\\\\\"transition\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/yui\\\\\\\\\\\\/transition_3.8.2.js\\\\\\\",\\\\\\\"selector-css2\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/yui\\\\\\\\\\\\/selector-css2_3.8.1.js\\\\\\\",\\\\\\\"selector-css3\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/yui\\\\\\\\\\\\/selector-css3_3.8.1.js\\\\\\\",\\\\\\\"event-custom-complex\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/yui\\\\\\\\\\\\/event-custom-complex_3.8.1.js\\\\\\\",\\\\\\\"event-synthetic\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/yui\\\\\\\\\\\\/event-synthetic_3.8.1.js\\\\\\\",\\\\\\\"event-focus\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/yui\\\\\\\\\\\\/event-focus_3.8.1.js\\\\\\\",\\\\\\\"event-delegate\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/yui\\\\\\\\\\\\/event-delegate_3.8.1.js\\\\\\\",\\\\\\\"node-event-delegate\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/yui\\\\\\\\\\\\/node-event-delegate_3.8.1.js\\\\\\\",\\\\\\\"pluginhost-base\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/yui\\\\\\\\\\\\/pluginhost-base_3.8.1.js\\\\\\\",\\\\\\\"pluginhost-config\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/yui\\\\\\\\\\\\/pluginhost-config_3.8.1.js\\\\\\\",\\\\\\\"node-pluginhost\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/yui\\\\\\\\\\\\/node-pluginhost_3.8.1.js\\\\\\\",\\\\\\\"dom-screen\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/yui\\\\\\\\\\\\/dom-screen_3.8.1.js\\\\\\\",\\\\\\\"node-screen\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/yui\\\\\\\\\\\\/node-screen_3.8.1.js\\\\\\\",\\\\\\\"gallery-storage-lite\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/yui\\\\\\\\\\\\/gallery-storage-lite_3.8.1.js\\\\\\\",\\\\\\\"module_platform\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/uicontrib\\\\\\\\\\\\/dali\\\\\\\\\\\\/module_platform_1.1.14.js\\\\\\\",\\\\\\\"resourcemgr\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/uicontrib\\\\\\\\\\\\/dali\\\\\\\\\\\\/resourcemgr_1.1.14.js\\\\\\\",\\\\\\\"transport\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/uicontrib\\\\\\\\\\\\/dali\\\\\\\\\\\\/dali_transport_1.1.34.js\\\\\\\",\\\\\\\"metro_ext\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/uicontrib\\\\\\\\\\\\/dali\\\\\\\\\\\\/metro_dali_1.0.27.js\\\\\\\",\\\\\\\"module_api\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/uicontrib\\\\\\\\\\\\/dali\\\\\\\\\\\\/module_api_1.1.16.js\\\\\\\",\\\\\\\"yui_service\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/uicontrib\\\\\\\\\\\\/dali\\\\\\\\\\\\/yui_service_0.1.17.js\\\\\\\",\\\\\\\"metro_viewtype\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/uiplugins\\\\\\\\\\\\/metro_viewtype_0.1.24.js\\\\\\\",\\\\\\\"default_viewtype\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/uiplugins\\\\\\\\\\\\/default_viewtype_0.1.61.js\\\\\\\",\\\\\\\"edit_viewtype\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/uiplugins\\\\\\\\\\\\/edit_viewtype_0.1.40.js\\\\\\\",\\\\\\\"ylc\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/uicontrib\\\\\\\\\\\\/ylc_1.8.22.js\\\\\\\",\\\\\\\"instrumentation_service\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/uiplugins\\\\\\\\\\\\/instrumentation_service_0.1.83.js\\\\\\\",\\\\\\\"userinfo_service\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/uiplugins\\\\\\\\\\\\/userinfo_service_0.1.15.js\\\\\\\",\\\\\\\"statemgr_service\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/uiplugins\\\\\\\\\\\\/statemgr_service_0.1.20.js\\\\\\\",\\\\\\\"metrologger_service\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/uiplugins\\\\\\\\\\\\/metrologger_service_0.1.18.js\\\\\\\",\\\\\\\"tooltip_service\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/uiplugins\\\\\\\\\\\\/tooltip_service_0.1.56.js\\\\\\\",\\\\\\\"autohide_service\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/uiplugins\\\\\\\\\\\\/autohide_service_0.1.15.js\\\\\\\",\\\\\\\"badge\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro2\\\\\\\\\\\\/g\\\\\\\\\\\\/badge\\\\\\\\\\\\/badge_0.1.20.js\\\\\\\",\\\\\\\"type_stream\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/stream\\\\\\\\\\\\/stream_0.0.456.js\\\\\\\",\\\\\\\"storage_service\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/uiplugins\\\\\\\\\\\\/storage_service_0.0.1.js\\\\\\\",\\\\\\\"login_service\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/uiplugins\\\\\\\\\\\\/login_service_0.0.38.js\\\\\\\",\\\\\\\"interests_service\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/uiplugins\\\\\\\\\\\\/interests_service_0.1.1.js\\\\\\\",\\\\\\\"type_fstream\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/fstream\\\\\\\\\\\\/fstream_0.0.95.js\\\\\\\",\\\\\\\"type_login\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/login\\\\\\\\\\\\/login_0.0.32.js\\\\\\\"}}};\\\\n}()\\\\n);\\\\n\\u003C\\\\/script\\u003E\\\\n\\\\n\\u003Cscript type=\\\\\\\"text\\\\/javascript\\\\\\\"\\u003E\\\\n(function(){\\\\n    YUI.add(\\\\\\\"metro_config\\\\\\\", function(Y){\\\\n        \\\\/\\\\/ until dali defaults this\\\\n\\\\n        Y.mix(Y.dali.config.props, {\\\\n            libRoot: \\\\\\\"\\\\\\\",\\\\n            user : \\\\\\\"\\\\\\\",\\\\n            ultSpaceId : \\\\\\\"2023538075\\\\\\\",\\\\n            ultBeaconHost : \\\\\\\"\\\\\\\\\\\\/p.gif\\\\\\\",\\\\n            modChromeHtml : \\\\\\\"\\u003Cdiv id=\\\\\\\\\\\\\\\"error-{type_name}\\\\\\\\\\\\\\\" class=\\\\\\\\\\\\\\\"mod view_error\\\\\\\\\\\\\\\"\\u003E  \\u003Cdiv id=\\\\\\\\\\\\\\\"error-{type_name}-bd\\\\\\\\\\\\\\\" class=\\\\\\\\\\\\\\\"bd  _error\\\\\\\\\\\\\\\"\\u003E{html}    \\u003C\\\\\\\\\\\\/div\\u003E\\\\\\\\n\\u003C\\\\\\\\\\\\/div\\u003E\\\\\\\",\\\\n            modErrorHtml : \\\\\\\"\\u003Cdiv class=\\\\\\\\\\\\\\\"oops-msg\\\\\\\\\\\\\\\" role=\\\\\\\\\\\\\\\"alertdialog\\\\\\\\\\\\\\\"\\u003E\\\\\\\\n                \\u003Cspan class='icon' style='background-image:url({img});_filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(enabled=true, sizingMethod=crop src=\\\\\\\\\\\\\\\"{img}\\\\\\\\\\\\\\\"); _background-image:none;'\\u003E\\u003C\\\\\\\\\\\\/span\\u003E\\u003Cspan class='shadow'\\u003E\\u003C\\\\\\\\\\\\/span\\u003E\\\\\\\\n                \\u003Ch3 class=\\\\\\\\\\\\\\\"oops\\\\\\\\\\\\\\\"\\u003E\\\\\\\\\\\\\\\"{name}\\\\\\\\\\\\\\\" encountered a problem while trying to load\\u003C\\\\\\\\\\\\/h3\\u003E\\\\\\\\n                \\u003Cp class=\\\\\\\\\\\\\\\"oops\\\\\\\\\\\\\\\"\\u003E{message}\\u003C\\\\\\\\\\\\/p\\u003E\\\\\\\\n                                \\u003Cp class=\\\\\\\\\\\\\\\"oops oops-link\\\\\\\\\\\\\\\"\\u003EOr visit \\u003Ca href=\\\\\\\\\\\\\\\"{url}\\\\\\\\\\\\\\\"\\u003E{url}\\u003C\\\\\\\\\\\\/a\\u003E\\u003C\\\\\\\\\\\\/p\\u003E\\\\\\\\n            \\u003C\\\\\\\\\\\\/div\\u003E\\\\\\\",\\\\n            crumbErrorHtml : \\\\\\\"\\u003Cdiv class=\\\\\\\\\\\\\\\"oops-msg\\\\\\\\\\\\\\\" role=\\\\\\\\\\\\\\\"alertdialog\\\\\\\\\\\\\\\"\\u003E\\\\\\\\n                \\u003Cspan class=\\\\\\\\\\\\\\\"icon icon-error y-glbl-universal\\\\\\\\\\\\\\\"\\u003E\\u003C\\\\\\\\\\\\/span\\u003E\\\\\\\\n                \\u003Ch3 class=\\\\\\\\\\\\\\\"oops\\\\\\\\\\\\\\\"\\u003EThe module encountered a problem while trying to load\\u003C\\\\\\\\\\\\/h3\\u003E\\\\\\\\n                \\u003Cp class=\\\\\\\\\\\\\\\"oops\\\\\\\\\\\\\\\"\\u003E2048\\u003C\\\\\\\\\\\\/p\\u003E\\\\\\\\n                \\\\\\\\n            \\u003C\\\\\\\\\\\\/div\\u003E\\\\\\\",\\\\n            cookieErrorHtml : \\\\\\\"\\u003Cdiv class=\\\\\\\\\\\\\\\"oops-msg\\\\\\\\\\\\\\\" role=\\\\\\\\\\\\\\\"alertdialog\\\\\\\\\\\\\\\"\\u003E\\\\\\\\n                \\u003Cspan class=\\\\\\\\\\\\\\\"icon icon-error y-glbl-universal\\\\\\\\\\\\\\\"\\u003E\\u003C\\\\\\\\\\\\/span\\u003E\\\\\\\\n                \\u003Ch3 class=\\\\\\\\\\\\\\\"oops\\\\\\\\\\\\\\\"\\u003EThe module encountered a problem while trying to load\\u003C\\\\\\\\\\\\/h3\\u003E\\\\\\\\n                \\u003Cp class=\\\\\\\\\\\\\\\"oops\\\\\\\\\\\\\\\"\\u003E16384\\u003C\\\\\\\\\\\\/p\\u003E\\\\\\\\n                \\\\\\\\n            \\u003C\\\\\\\\\\\\/div\\u003E\\\\\\\",\\\\n            proxyTimeout : 15000,\\\\n            proxyUrl : '\\\\/hjs',\\\\n            intl : \\\\\\\"us\\\\\\\",\\\\n            \\\\\\\"ywa.rapid.enabled\\\\\\\": true\\\\n        });\\\\n    });\\\\n\\\\n    var i, len, url, match, modules,\\\\n        allScripts = YUI.presentation.lazyScriptList,\\\\n        comboRoot = 'http:\\\\/\\\\/l.yimg.com\\\\/zz\\\\/combo?',\\\\n        isCombo =  allScripts[0].indexOf(comboRoot) === 0,\\\\n        yuiMods = ['metro_config'],\\\\n        lazyScripts = [];\\\\n\\\\n    if (isCombo) {\\\\n        for (i = 0, len = allScripts.length; i \\u003C len; ++i) {\\\\n            url = allScripts[i].replace(comboRoot, '');\\\\n            allScripts = allScripts.concat(url.split('&'));\\\\n        }\\\\n        allScripts = allScripts.slice(len);\\\\n    }\\\\n\\\\n    for (i = 0, len = allScripts.length; i \\u003C len; ++i) {\\\\n        url = allScripts[i];\\\\n        match = url.match(\\\\/\\\\\\\\\\\\/yui\\\\\\\\\\\\/([^._]*)\\\\/);\\\\n        if (match && match.length \\u003E 1) {\\\\n            yuiMods.push(match[1]);\\\\n        } else {\\\\n            lazyScripts.push(url);\\\\n        }\\\\n    }\\\\n\\\\n    if (isCombo) {\\\\n        lazyScripts = [comboRoot + lazyScripts.join('&')];\\\\n    }\\\\n\\\\n    if (YMedia.ModulePlatform) {\\\\n        modules = YMedia.ModulePlatform.getModules();\\\\n        YMedia.ModulePlatform.stop(modules);\\\\n        YMedia.each(modules, YMedia.ModulePlatform.unregisterModule);\\\\n    }\\\\n    YMedia.use(yuiMods, function (Y) {\\\\n        Y.dali.config.debug = false;\\\\n        Y.Get.script(lazyScripts, { onSuccess: function(){\\\\n            Y.use(\\\\\\\"*\\\\\\\", function (Y) {\\\\n                Y.ModulePlatform.init(Y.dali.config, true);\\\\n            });\\\\n        }});\\\\n        var rapid = YMedia ? YMedia.rapid : null,\\\\n            id = 'p_30345786',\\\\n            container = Y.one('#' + id);\\\\n        if (rapid && container) {\\\\n            if (rapid.isModuleTracked(id)) {\\\\n                rapid.refreshModule(id);\\\\n            } else {\\\\n                rapid.addModules(id);\\\\n            }\\\\n        }\\\\n        if (container) {\\\\n            container.addClass('jsenabled');\\\\n        }\\\\n    });\\\\n\\\\n})();\\\\n\\u003C\\\\/script\\u003E\\\\n\\\\n--dali-response-split-51ddaa3c96973--\\\"});});\\u003C/script\\u003E\\u003C!-- hdf113.fp.bf1.yahoo.com compressed Wed Jul 10 18:38:52 UTC 2013 --\\u003E\\n\\n\\n\\t\\t\\u003Cscript language=\\\"javascript\\\"\\u003E\\n\\t\\t\\nYUI.YUICfg = {\\\"gallery\\\":\\\"gallery-2011.04.20-13-04\\\",\\\"groups\\\":{\\\"group01c9d8dea06e05460a64eed4dadd622b6\\\":{\\\"base\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/\\\",\\\"comboBase\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/zz\\\\/combo?\\\",\\\"modules\\\":{\\\"media-request-manager\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/p\\\\/content\\\\/request-manager-min-1334113.js\\\"},\\\"media-content-manager\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/p\\\\/content\\\\/content-manager-min-1331468.js\\\"},\\\"media-perf-timeable\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/p\\\\/content\\\\/perf-timeable-min-1191658.js\\\"},\\\"media-ad-controller\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/p\\\\/content\\\\/ad-controller-min-1334238.js\\\"},\\\"media-pane-manager\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/p\\\\/content\\\\/pane-manager-min-1343260.js\\\"},\\\"media-next-scroll\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/p\\\\/content\\\\/next-scroll-min-1304262.js\\\"},\\\"media-tag-manager\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/p\\\\/content\\\\/tag-manager-min-1294559.js\\\"},\\\"media-content-discoverer\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/p\\\\/content\\\\/content-discoverer-min-1331680.js\\\"},\\\"media-interest-manager\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/p\\\\/content\\\\/interest-manager-min-1306018.js\\\"},\\\"media-instrumentation\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/p\\\\/content\\\\/instrumentation-min-1214752.js\\\"},\\\"media-content-ss-base\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/m\\\\/content_photo\\\\/content-ss-base-min-1330613.js\\\"},\\\"media-content-ss-no-sv\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/m\\\\/content_photo\\\\/content-ss-no-sv-min-1328161.js\\\"},\\\"media-carousel\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/m\\\\/content_photo\\\\/carousel-min-1308638.js\\\"},\\\"media-lead\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/m\\\\/content_index\\\\/lead-min-1306566.js\\\"},\\\"media-comic\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/m\\\\/content_index\\\\/comic-min-1262759.js\\\"},\\\"media-content-social-base\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/m\\\\/content_social\\\\/content-social-base-min-1339203.js\\\"},\\\"media-content-email-autocomplete\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/m\\\\/content_social\\\\/content-email-autocomplete-min-1306078.js\\\"},\\\"media-content-share-buttons\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/m\\\\/content_social\\\\/content-share-buttons-min-1339400.js\\\"},\\\"media-content-share-buttons-builder\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/m\\\\/content_social\\\\/content-share-buttons-builder-min-1337341.js\\\"},\\\"media-bc\\\":{\\\"path\\\":\\\"d\\\\/lib\\\\/bc\\\\/bc_2.0.5.js\\\"},\\\"media-beacon-manager\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/p\\\\/content\\\\/beacon-manager-min-1333171.js\\\"},\\\"media-nav-addon\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/m\\\\/navigation\\\\/nav-addon-min-1270754.js\\\"},\\\"media-recommend\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/p\\\\/content\\\\/recommend-min-1277359.js\\\"},\\\"media-personal-nav\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/p\\\\/content\\\\/personal-nav-min-1318968.js\\\"},\\\"media-strip\\\":{\\\"path\\\":\\\"ss\\\\/strip_3.2.js\\\"},\\\"media-trfsm\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/p\\\\/common\\\\/trfsm-min-797026.js\\\"},\\\"media-i13n\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/p\\\\/common\\\\/i13n-min-1154367.js\\\"},\\\"media-ywa-tracking\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/p\\\\/common\\\\/ywa-tracking-min-1234794.js\\\"},\\\"media-content-navigation-desktop\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/m\\\\/navigation\\\\/content-navigation-desktop-min-1318647.js\\\"},\\\"media-footer\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/m\\\\/footer\\\\/footer-min-923366.js\\\"}},\\\"combine\\\":true,\\\"filter\\\":\\\"min\\\",\\\"root\\\":\\\"\\\\/\\\"}},\\\"modules\\\":{\\\"media-ad-ros\\\":{\\\"fullpath\\\":\\\"http:\\\\/\\\\/ads.yimg.com\\\\/qq\\\\/dm\\\\/ad-ros-0.0.2.js\\\"}},\\\"combine\\\":true,\\\"allowRollup\\\":true,\\\"comboBase\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/zz\\\\/combo?\\\",\\\"maxURLLength\\\":\\\"2000\\\"}\\nYUI.YUICfg.root='yui:'+YUI.version+'/build/';\\nYMedia.applyConfig(YUI.YUICfg);\\nYUI.Env[YUI.version].groups.gallery.root = 'yui:gallery-2011.04.20-13-04/build/';\\nYMedia.use(\\\"media-request-manager\\\",\\\"media-content-manager\\\",\\\"media-perf-timeable\\\",\\\"node-scroll-info\\\",\\\"event-custom\\\",\\\"media-ad-controller\\\",\\\"app-base\\\",\\\"querystring-parse\\\",\\\"media-rmp\\\",\\\"media-pane-manager\\\",\\\"node-base\\\",\\\"event-touch\\\",\\\"media-next-scroll\\\",\\\"media-next-scroll\\\",\\\"event-mouseenter\\\",\\\"media-tag-manager\\\",\\\"media-tag-manager\\\",\\\"media-content-discoverer\\\",\\\"history-base\\\",\\\"media-interest-manager\\\",\\\"io-base\\\",\\\"json-parse\\\",\\\"media-instrumentation\\\",\\\"media-content-ss-base\\\",\\\"media-content-ss-no-sv\\\",\\\"node-base\\\",\\\"event-key\\\",\\\"media-carousel\\\",\\\"base\\\",\\\"json-parse\\\",\\\"querystring-stringify\\\",\\\"media-lead\\\",\\\"media-comic\\\",\\\"autocomplete\\\",\\\"autocomplete-highlighters\\\",\\\"event-base\\\",\\\"event-custom\\\",\\\"node-core\\\",\\\"io\\\",\\\"querystring\\\",\\\"overlay\\\",\\\"json\\\",\\\"gallery-node-tokeninput\\\",\\\"querystring-stringify-simple\\\",\\\"gallery-outside-events\\\",\\\"media-content-social-base\\\",\\\"media-content-email-autocomplete\\\",\\\"media-content-social-base\\\",\\\"media-content-email-autocomplete\\\",\\\"media-content-share-buttons\\\",\\\"event\\\",\\\"node\\\",\\\"media-content-share-buttons-builder\\\",function(Y){\\n    \\t  \\n    Y.later(10, this, function() {Y.Media.adController = new Y.Media.AdController({\\n                                        env: 'prod',\\n                                        hideOnFailure: false,\\n                                        fetchOnPjaxOnly: true,\\n                                        preserveLRECContainer: false\\n                                    });});\\n    Y.later(10, this, function() {Y.Media.requestManager = new Y.Media.RequestManager({\\n                        chrome: Y.Media.pageChrome,\\n                        linkSelector: 'a:not(.no-pjax)',\\n                        unsuppBrowsers: '',\\n                        continueOnError: '1',\\n                        pjaxSplit: '0',\\n                        ignoreCssErrors: '1'\\n                    }).render();});\\n    Y.later(10, this, function() {new Y.Media.ContentManager({\\n                        \\n                                        nodePaths: {content: '#yog-content', navigation: '#yog-nav .navlist', related: '#yog-related', superlead: '#yog-stage'},\\n                                        transition: {style: 'fade'}\\n                                    \\n                    });});\\n    Y.later(10, this, function() {Y.Media.pagePaneManager = new Y.Media.PaneManager(\\n                                    {\\n                                        debug: 0,\\n                                        grid_type: {\\n                                            content: {\\n                                                scroll_mode: 'bandit'\\n                                            },\\n                                            index: {\\n                                                scroll_mode: 'bandit'\\n                                            }\\n                                        },\\n                                        isYnet: 0\\n                                    });});\\n    Y.later(10, this, function() {new Y.Media.TagManager();});\\n    Y.later(10, this, function() {new Y.Media.ContentDiscoverer({\\\"enableLightboxOnStream\\\": \\\"1\\\" });});\\n    Y.later(10, this, function() {new Y.Media.InterestManager({\\n                            });});\\n    Y.later(10, this, function() {new Y.Media.Instrumentation();});\\n    Y.later(10, this, function() {new Y.Media.ContentSSNoSV({\\n                                chrome: Y.Media.pageChrome,\\n                                config: {\\n                                            modId               :'',\\n                                            setupSlideshowCover : 'false',\\n                                            enableCarousel      : '1',\\n                                            enableEndSlideRel   : '0',\\n                                            enableEndSlideMP    : '1',\\n                                            strings             : {\\n                                                'more' : 'more',\\n                                                'less' : 'less',\\n                                                'of'   : 'of'\\n                                            }\\n                                        }\\n                                });});\\n    Y.later(10, this, function() {Y.Media.shareButtonsBuilder = new Y.Media.ContentShareButtonsBuilder({\\\"modNode\\\":\\\"\\\",\\\"switches\\\":{\\\"mtf\\\":true,\\\"cmt\\\":false},\\\"loginStat\\\":{\\\"yahoo\\\":0},\\\"data\\\":{\\\"mtfRedirUrl\\\":\\\"http%3A%2F%2Fnews.yahoo.com%2F_xhr%2Fmediacontentsharebuttons%2Fpostshare%2F%3Fsrc%3Dmail\\\"},\\\"pageData\\\":{\\\"crumb\\\":\\\"\\\",\\\"title\\\":\\\"\\\",\\\"summary\\\":\\\"\\\",\\\"thumbnail\\\":\\\"\\\",\\\"url\\\":\\\"\\\",\\\"locale\\\":\\\"US\\\",\\\"prop\\\":\\\"news\\\",\\\"content_id\\\":\\\"5f01278b-803a-3803-9798-7fc79bab4f7d\\\",\\\"ult__S\\\":\\\"81121452\\\",\\\"ult_ct\\\":\\\"\\\",\\\"ult_pkg\\\":\\\"5f01278b-803a-3803-9798-7fc79bab4f7d\\\",\\\"ult_test\\\":null,\\\"ult_csrcpvid\\\":\\\"FSr0xQrHg2.G2dUfMOsImwDQDEeLIlHdqicAC52y\\\",\\\"ult_sec\\\":\\\"mit_share\\\",\\\"ult_slk\\\":\\\"mail\\\",\\\"ult_mpos\\\":1,\\\"ult_lang\\\":\\\"en-US\\\",\\\"ult_act\\\":\\\"mail\\\",\\\"ult_pstaid\\\":\\\"5f01278b-803a-3803-9798-7fc79bab4f7d\\\"},\\\"contentMetaData\\\":{\\\"id\\\":\\\"5f01278b-803a-3803-9798-7fc79bab4f7d\\\",\\\"url_orig\\\":\\\"\\\",\\\"title_orig\\\":\\\"\\\",\\\"summary\\\":\\\"\\\",\\\"type\\\":\\\"homepage\\\"},\\\"config\\\":{\\\"site\\\":\\\"news\\\",\\\"lang\\\":\\\"en-US\\\",\\\"region\\\":\\\"US\\\",\\\"scrumb\\\":false},\\\"template\\\":\\\"\\u003Cdiv class=\\\\\\\"yom-share-btns-container light\\\\\\\"\\u003E\\\\n    \\u003Cdiv class=\\\\\\\"share-btns\\\\\\\" role=\\\\\\\"menu\\\\\\\"\\u003E\\\\n        \\u003Cdiv class=\\\\\\\"share-btns-wrap\\\\\\\"\\u003E\\\\n            \\u003Cdiv class=\\\\\\\"share-btn-wrap\\\\\\\"\\u003E\\\\n                \\u003Cul\\u003E\\u003Cli class=\\\\\\\"share-btn facebook\\\\\\\"\\u003E\\\\n                        \\u003Ca href=\\\\\\\"http:\\\\/\\\\/www.facebook.com\\\\/dialog\\\\/feed?app_id=90376669494&amp;redirect_uri=http:\\\\/\\\\/news.yahoo.com\\\\/_xhr\\\\/mediacontentsharebuttons\\\\/postshare\\\\/?src=fb&amp;link=http:\\\\/\\\\/news.yahoo.com\\\\/&amp;picture=http:\\\\/\\\\/l2.yimg.com\\\\/bt\\\\/api\\\\/res\\\\/1.2\\\\/BvlRk2eMuZ5S5ZVts0i.Uw--\\\\/YXBwaWQ9eW5ld3M7cT04NTt3PTYwMA--\\\\/http:\\\\/\\\\/l.yimg.com\\\\/os\\\\/publish-images\\\\/news\\\\/2013-03-19\\\\/528dd2af-804a-4db8-b6eb-53b18b9b0592_ybang_225x225.png&amp;display=popup&amp;show_error=yes\\\\\\\" role=\\\\\\\"link\\\\\\\" title=\\\\\\\"share\\\\\\\" target=\\\\\\\"_blank\\\\\\\" data-ylk=\\\\\\\"sec:mod-sh-b;slk:btn-sh-fb;itc:1;test:;\\\\\\\" data-action-outcome=\\\\\\\"share\\\\\\\"\\u003E\\u003Cspan class=\\\\\\\"btn-icon btn-fb\\\\\\\"\\u003E\\u003C\\\\/span\\u003E\\u003Cspan class=\\\\\\\"btn-count hide\\\\\\\"\\u003E0\\u003C\\\\/span\\u003E\\u003C\\\\/a\\u003E\\\\n                    \\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"share-btn twitter\\\\\\\"\\u003E\\\\n                        \\u003Ca href=\\\\\\\"https:\\\\/\\\\/twitter.com\\\\/share?text=Yahoo%21%20News%20-%20Latest%20News%20%26%20Headlines&amp;url=http:\\\\/\\\\/news.yahoo.com\\\\/&amp;via=YahooNews\\\\\\\" role=\\\\\\\"link\\\\\\\" title=\\\\\\\"tweet\\\\\\\" target=\\\\\\\"_blank\\\\\\\" data-ylk=\\\\\\\"sec:mod-sh-b;slk:btn-sh-tw;itc:1;test:;\\\\\\\" data-action-outcome=\\\\\\\"share\\\\\\\"\\u003E\\u003Cspan class=\\\\\\\"btn-icon btn-tw\\\\\\\"\\u003E\\u003C\\\\/span\\u003E\\u003Cspan class=\\\\\\\"btn-count hide\\\\\\\"\\u003E0\\u003C\\\\/span\\u003E\\u003C\\\\/a\\u003E\\\\n                    \\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"share-btn tumblr\\\\\\\"\\u003E\\\\n                        \\u003Ca href=\\\\\\\"http:\\\\/\\\\/www.tumblr.com\\\\/share\\\\/link?url=http%3A%2F%2Fnews.yahoo.com%2F&description=The%20latest%20news%20and%20headlines%20from%20Yahoo%21%20News.%20Get%20breaking%20news%20stories%20and%20in-depth%20coverage%20with%20videos%20and%20photos.&name=Yahoo%21%20News%20-%20Latest%20News%20%26amp%3B%20Headlines\\\\\\\" role=\\\\\\\"link\\\\\\\" title=\\\\\\\"tumblr\\\\\\\" target=\\\\\\\"_blank\\\\\\\" data-ylk=\\\\\\\"sec:mod-sh-b;slk:btn-sh-tu;itc:1;test:;\\\\\\\" data-action-outcome=\\\\\\\"share\\\\\\\"\\u003E\\u003Cspan class=\\\\\\\"btn-icon btn-tu\\\\\\\"\\u003E\\u003C\\\\/span\\u003E\\u003Cspan class=\\\\\\\"btn-count hide\\\\\\\"\\u003E\\u003C\\\\/span\\u003E\\u003C\\\\/a\\u003E\\\\n                    \\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"share-btn pinterest\\\\\\\"\\u003E\\\\n                        \\u003Ca href=\\\\\\\"http:\\\\/\\\\/pinterest.com\\\\/pin\\\\/create\\\\/button\\\\/?url=http%3A%2F%2Fnews.yahoo.com%2F&description=The%20latest%20news%20and%20headlines%20from%20Yahoo%21%20News.%20Get%20breaking%20news%20stories%20and%20in-depth%20coverage%20with%20videos%20and%20photos.&media=http:\\\\/\\\\/l2.yimg.com\\\\/bt\\\\/api\\\\/res\\\\/1.2\\\\/BvlRk2eMuZ5S5ZVts0i.Uw--\\\\/YXBwaWQ9eW5ld3M7cT04NTt3PTYwMA--\\\\/http:\\\\/\\\\/l.yimg.com\\\\/os\\\\/publish-images\\\\/news\\\\/2013-03-19\\\\/528dd2af-804a-4db8-b6eb-53b18b9b0592_ybang_225x225.png\\\\\\\" role=\\\\\\\"link\\\\\\\" title=\\\\\\\"pinterest\\\\\\\" target=\\\\\\\"_blank\\\\\\\" data-ylk=\\\\\\\"sec:mod-sh-b;slk:btn-sh-pin;itc:1;test:;\\\\\\\" data-action-outcome=\\\\\\\"share\\\\\\\"\\u003E\\u003Cspan class=\\\\\\\"btn-icon btn-pin\\\\\\\"\\u003E\\u003C\\\\/span\\u003E\\u003Cspan class=\\\\\\\"btn-count hide\\\\\\\"\\u003E\\u003C\\\\/span\\u003E\\u003C\\\\/a\\u003E\\\\n                    \\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"share-btn mail email\\\\\\\"\\u003E\\\\n                        \\u003Ca href=\\\\\\\"mailto:?subject=Yahoo%21%20News%20-%20Latest%20News%20%26amp%3B%20Headlines&amp;body=http%3A%2F%2Fnews.yahoo.com%2F\\\\\\\" role=\\\\\\\"link\\\\\\\" title=\\\\\\\"email\\\\\\\" data-ylk=\\\\\\\"sec:mod-sh-b;slk:btn-sh-ma;itc:1;test:;\\\\\\\" data-action-outcome=\\\\\\\"share\\\\\\\"\\u003E\\u003Cspan class=\\\\\\\"btn-icon btn-mail\\\\\\\"\\u003E\\u003C\\\\/span\\u003E\\u003Cspan class=\\\\\\\"btn-count hide\\\\\\\"\\u003E0\\u003C\\\\/span\\u003E\\u003C\\\\/a\\u003E\\\\n                    \\u003C\\\\/li\\u003E\\\\n                \\u003C\\\\/ul\\u003E\\\\n            \\u003C\\\\/div\\u003E\\\\n            \\u003Cdiv class=\\\\\\\"clearfix\\\\\\\"\\u003E\\u003C\\\\/div\\u003E\\\\n        \\u003C\\\\/div\\u003E\\\\n    \\u003C\\\\/div\\u003E\\\\n    \\u003Cdiv class=\\\\\\\"share-btns-overlay-screen hide\\\\\\\"\\u003E\\u003C\\\\/div\\u003E\\\\n    \\u003Cdiv class=\\\\\\\"share-btns-overlay hide\\\\\\\"\\u003E\\\\n        \\u003Cdiv class=\\\\\\\"yui3-widget-hd\\\\\\\"\\u003E\\\\n            \\u003Cdiv class=\\\\\\\"close-btn\\\\\\\" role=\\\\\\\"button\\\\\\\"\\u003E&times;\\u003C\\\\/div\\u003E\\\\n        \\u003C\\\\/div\\u003E\\\\n        \\u003Cdiv class=\\\\\\\"yui3-widget-bd\\\\\\\"\\u003E\\\\n            \\u003Cdiv class=\\\\\\\"speedbump hide mail-login\\\\\\\" role=\\\\\\\"dialog\\\\\\\" aria-labelledby=\\\\\\\"Sign in to share this by email\\\\\\\"\\u003E\\\\n                \\u003Ch3 class=\\\\\\\"header\\\\\\\"\\u003ESign in to share this by email\\u003C\\\\/h3\\u003E\\\\n                \\u003Cdiv class=\\\\\\\"login-btns\\\\\\\"\\u003E\\\\n                    \\u003Cdiv class=\\\\\\\"login-link\\\\\\\"\\u003E\\\\n                        \\u003Ca class=\\\\\\\"login-btn yahoo\\\\\\\" role=\\\\\\\"link\\\\\\\" href=\\\\\\\"https:\\\\/\\\\/login.yahoo.com\\\\/config\\\\/login_verify2?.done=http%3A%2F%2Fnews.yahoo.com%2F_xhr%2Fmediacontentsharebuttons%2Fpostshare%2F%3Fsrc%3Dmail&amp;.src=mtf\\\\\\\" target=\\\\\\\"_blank\\\\\\\"\\u003E\\u003Cspan class=\\\\\\\"login-icon yahoo\\\\\\\"\\u003E\\u003C\\\\/span\\u003E\\u003Cspan class=\\\\\\\"login-text\\\\\\\"\\u003EYahoo!\\u003C\\\\/span\\u003E\\u003C\\\\/a\\u003E\\\\n                    \\u003C\\\\/div\\u003E\\\\n                    \\u003Cdiv class=\\\\\\\"login-link\\\\\\\"\\u003E\\\\n                        \\u003Ca class=\\\\\\\"login-btn facebook\\\\\\\" role=\\\\\\\"link\\\\\\\" href=\\\\\\\"https:\\\\/\\\\/open.login.yahoo.com\\\\/openid\\\\/yrp\\\\/signin?.intl=us&amp;idp=facebook&amp;.done=http:\\\\/\\\\/news.yahoo.com\\\\/%23mtf-overlay&amp;ts=1373481511&amp;.src=home&amp;appid=90376669494&amp;spid=b9ed13cc-ddec-11de-9c83-001b784d35e1&amp;perms=email,user_birthday,user_education_history,user_likes,user_location,user_relationships,user_subscriptions,user_work_history,friends_birthday,friends_education_history,friends_likes,friends_location,friends_work_history,publish_actions&amp;fbflow=1\\\\\\\" target=\\\\\\\"_blank\\\\\\\"\\u003E\\u003Cspan class=\\\\\\\"login-icon facebook\\\\\\\"\\u003E\\u003C\\\\/span\\u003E\\u003Cspan class=\\\\\\\"login-text\\\\\\\"\\u003EFacebook\\u003C\\\\/span\\u003E\\u003C\\\\/a\\u003E\\\\n                    \\u003C\\\\/div\\u003E\\\\n                \\u003C\\\\/div\\u003E\\\\n                \\u003Cp\\u003ENew here? \\u003Ca href=\\\\\\\"https:\\\\/\\\\/edit.yahoo.com\\\\/config\\\\/eval_register?.done=http%3A%2F%2Fnews.yahoo.com%2F_xhr%2Fmediacontentsharebuttons%2Fpostshare%2F%3Fsrc%3Dmail\\\\\\\" target=\\\\\\\"_blank\\\\\\\" class=\\\\\\\"signup\\\\\\\"\\u003ESign up.\\u003C\\\\/a\\u003E\\u003C\\\\/p\\u003E\\\\n            \\u003C\\\\/div\\u003E\\\\n            \\u003Cdiv class=\\\\\\\"speedbump hide mail-form\\\\\\\" role=\\\\\\\"dialog\\\\\\\" aria-labelledby=\\\\\\\"Email this\\\\\\\"\\u003E\\\\n                \\u003Ch3 class=\\\\\\\"header\\\\\\\"\\u003EEmail this\\u003C\\\\/h3\\u003E\\\\n                \\u003Cdiv class=\\\\\\\"form\\\\\\\"\\u003E\\\\n                    \\u003Cdiv class=\\\\\\\"form-input\\\\\\\"\\u003E\\\\n                        \\u003Clabel for=\\\\\\\"semail\\\\\\\"\\u003EFrom\\u003C\\\\/label\\u003E\\u003Cselect id=\\\\\\\"semail\\\\\\\" class=\\\\\\\"mail-input\\\\\\\" role=\\\\\\\"menu\\\\\\\" disabled\\u003E\\u003Coption role=\\\\\\\"menuitem\\\\\\\"\\u003ELoading...\\u003C\\\\/option\\u003E\\u003C\\\\/select\\u003E\\\\n                        \\u003Cdiv class=\\\\\\\"yom-mtf-semail-error icon-alert-small yui3-widget-hidden\\\\\\\"\\u003EPlease enter a valid email address\\u003C\\\\/div\\u003E\\\\n                    \\u003C\\\\/div\\u003E\\\\n                    \\u003Cdiv class=\\\\\\\"form-input\\\\\\\"\\u003E\\\\n                        \\u003Clabel for=\\\\\\\"remail\\\\\\\"\\u003ETo\\u003C\\\\/label\\u003E\\u003Cinput id=\\\\\\\"remail\\\\\\\" class=\\\\\\\"mail-input\\\\\\\" role=\\\\\\\"textbox\\\\\\\" disabled\\u003E\\\\n                        \\u003Cdiv class=\\\\\\\"yom-mtf-remail-error icon-alert-small yui3-widget-hidden\\\\\\\"\\u003EPlease enter valid email addresses, separated by commas\\u003C\\\\/div\\u003E\\\\n                        \\u003Cdiv class=\\\\\\\"yom-mtf-remail-max-error icon-alert-small yui3-widget-hidden\\\\\\\"\\u003EMaximum 200 character limit exceeded\\u003C\\\\/div\\u003E\\\\n                    \\u003C\\\\/div\\u003E\\\\n                    \\u003Cdiv class=\\\\\\\"form-input fb-import\\\\\\\"\\u003E\\\\n                        \\u003Clabel\\u003E&nbsp;\\u003C\\\\/label\\u003E\\u003Cspan\\u003EDon't see your Facebook contacts? \\u003Ca href=\\\\\\\"http:\\\\/\\\\/address.yahoo.com\\\\/?_src=neo&VPC=tools_import&.done=http:\\\\/\\\\/www.yahoo.com\\\\\\\" role=\\\\\\\"link\\\\\\\" target=\\\\\\\"_blank\\\\\\\" class=\\\\\\\"import\\\\\\\"\\u003EImport them\\u003C\\\\/a\\u003E\\u003C\\\\/span\\u003E\\\\n                    \\u003C\\\\/div\\u003E\\\\n                    \\u003Cdiv\\u003E\\\\n                        \\u003Ctextarea placeholder=\\\\\\\"Write a message\\\\\\\" class=\\\\\\\"mail-text\\\\\\\" role=\\\\\\\"textbox\\\\\\\" aria-multiline=\\\\\\\"true\\\\\\\"\\u003E\\u003C\\\\/textarea\\u003E \\\\n                        \\u003Cdiv class=\\\\\\\"yom-mtf-pmesg-error icon-alert-small yui3-widget-hidden\\\\\\\"\\u003EPlease enter a message\\u003C\\\\/div\\u003E\\\\n                    \\u003C\\\\/div\\u003E\\\\n                    \\u003Cdiv class=\\\\\\\"mail-article\\\\\\\"\\u003E\\\\n                        \\u003Cdiv class=\\\\\\\"article thumbnail\\\\\\\"\\u003E\\\\n                            \\u003Cimg title=\\\\\\\"Yahoo! News - Latest News &amp;amp; Headlines\\\\\\\"\\u003E\\\\n                        \\u003C\\\\/div\\u003E\\\\n                        \\u003Cdiv class=\\\\\\\"article\\\\\\\"\\u003E\\\\n                            \\u003Cdiv class=\\\\\\\"title\\\\\\\"\\u003EYahoo! News - Latest News &amp;amp; Headlines\\u003C\\\\/div\\u003E\\\\n                            \\u003Cdiv class=\\\\\\\"description\\\\\\\"\\u003EThe latest news and headlines from Yahoo! News. Get breaking news stories and in-depth coverage with videos and photos.\\u003C\\\\/div\\u003E\\\\n                        \\u003C\\\\/div\\u003E\\\\n                    \\u003C\\\\/div\\u003E\\\\n                    \\u003Cdiv class=\\\\\\\"mail-submit\\\\\\\"\\u003E\\\\n                        \\u003Cinput type=\\\\\\\"checkbox\\\\\\\" id=\\\\\\\"cc-self\\\\\\\" role=\\\\\\\"checkbox\\\\\\\"\\u003E\\u003Clabel for=\\\\\\\"cc-self\\\\\\\" class=\\\\\\\"cc-self\\\\\\\"\\u003ESend me a copy of this email\\u003C\\\\/label\\u003E\\\\n                        \\u003Cdiv class=\\\\\\\"submit-btns\\\\\\\"\\u003E\\\\n                            \\u003Cbutton class=\\\\\\\"mail-btn send\\\\\\\" role=\\\\\\\"button\\\\\\\" disabled\\u003ESend\\u003C\\\\/button\\u003E\\\\n                            \\u003Cbutton class=\\\\\\\"mail-btn close-btn\\\\\\\" role=\\\\\\\"button\\\\\\\"\\u003ECancel\\u003C\\\\/button\\u003E\\\\n                        \\u003C\\\\/div\\u003E\\\\n                        \\u003Cdiv class=\\\\\\\"clearfix\\\\\\\"\\u003E\\u003C\\\\/div\\u003E\\\\n                    \\u003C\\\\/div\\u003E\\\\n                \\u003C\\\\/div\\u003E\\\\n            \\u003C\\\\/div\\u003E\\\\n            \\u003Cdiv class=\\\\\\\"speedbump hide facebook\\\\\\\" role=\\\\\\\"dialog\\\\\\\" aria-labelledby=\\\\\\\"facebook\\\\\\\"\\u003Efacebook\\u003C\\\\/div\\u003E\\\\n            \\u003Cdiv class=\\\\\\\"speedbump hide twitter\\\\\\\" role=\\\\\\\"dialog\\\\\\\" aria-labelledby=\\\\\\\"twitter\\\\\\\"\\u003Etwitter\\u003C\\\\/div\\u003E\\\\n        \\u003C\\\\/div\\u003E\\\\n        \\u003Cdiv class=\\\\\\\"yui3-widget-ft\\\\\\\"\\u003E\\u003C\\\\/div\\u003E\\\\n    \\u003C\\\\/div\\u003E\\\\n\\u003C\\\\/div\\u003E\\\\n\\\"});});\\n\\t\\t   \\n});\\n\\nYUI.Env.add(window, \\\"load\\\", function(){\\nYMedia.use(\\\"media-rmp\\\",\\\"media-bc\\\",\\\"media-beacon-manager\\\",\\\"event-custom\\\",\\\"handlebars\\\",\\\"node-base\\\",\\\"media-nav-addon\\\",\\\"node-core\\\",\\\"node-data\\\",\\\"event-base\\\",\\\"node-event-delegate\\\",\\\"event-delegate\\\",\\\"event-tap\\\",\\\"media-tag-manager\\\",\\\"media-recommend\\\",\\\"media-personal-nav\\\",\\\"cookie\\\",\\\"querystring-parse\\\",\\\"media-strip\\\",\\\"media-trfsm\\\",\\\"base\\\",\\\"jsonp\\\",\\\"media-i13n\\\",\\\"media-ywa-tracking\\\",\\\"media-content-navigation-desktop\\\",\\\"overlay\\\",\\\"media-ad-ros\\\",\\\"media-footer\\\",function(Y){\\n    \\t  \\n    Y.later(10, this, function() {Y.Array.each(YMedia.includes, function(inc, i, ar){ if(Y.Lang.isFunction(inc)) { inc(Y); ar[i] = null; } });\\n    });\\n    Y.later(10, this, function() {new Y.Media.BeaconManager({chrome:Y.Media.pageChrome});\\n    });\\n    Y.later(10, this, function() {new Y.Media.NavAddon({\\n                                max: '3',\\n                                chrome: Y.Media.pageChrome\\n                            });\\n    });\\n    Y.later(10, this, function() {new Y.Media.Recommend({\\n                                header: 'Recommended',\\n                                position: 1,\\n                                chrome: Y.Media.pageChrome\\n                            });\\n    });\\n    Y.later(10, this, function() {new Y.Media.PersonalNav({\\n                                header: 'My Topics',\\n                                position: 2\\n                            });\\n    });\\n    Y.later(10, this, function() {Y.Global.Media.ILBoot.initImageLoader(true);\\n    });\\n    Y.later(10, this, function() {(function() {\\n                                                    var configUrl = 'http://l.yimg.com/os/assets/globalmedia/traffic/traffic-simulation.js',\\n                                                        simulator = new Y.Media.TrafficSimulator({ 'dataUrl' : configUrl });\\n                                                    simulator.load();\\n                                                })();\\n    });\\n    Y.later(10, this, function() {try {\\n                                        YMEDIA_REQ_ATTR.csbeacon();\\n                                    } catch (e) {\\n                                    }\\n    });\\n    Y.later(10, this, function() {new Y.Media.ContentNavigation({\\n                         config: {\\n                            modId               : 'mediacontentnavigation'\\n                         },\\n                         chrome: Y.Media.pageChrome\\n                         });\\n    });\\n    Y.later(10, this, function() {Y.Media.Lead.MediaContentLead.init({\\\"cat\\\":\\\"\\\",\\\"catName\\\":\\\"\\\",\\\"listid \\\":\\\"\\\"});\\n    });\\n    Y.later(10, this, function() {Y.Media.Comic.MediaContentComic.init({\\\"meta\\\":{\\\"error\\\":{\\\"error_code\\\":0},\\\"mod_id\\\":\\\"mediacontentcomic\\\",\\\"bucket\\\":null,\\\"selected_list\\\":\\\"92df5b73-9c06-3216-9539-45edc1a84bfa\\\",\\\"selected_name\\\":\\\"Andy Capp\\\",\\\"abbreviation\\\":\\\"crcap\\\",\\\"max_result_count\\\":14,\\\"start\\\":0,\\\"count\\\":14,\\\"total\\\":95,\\\"alias\\\":\\\"\\\\/comics\\\\/andy-capp-slideshow\\\\/\\\",\\\"enableLightBox\\\":0},\\\"data\\\":{\\\"92df5b73-9c06-3216-9539-45edc1a84bfa\\\":[{\\\"src\\\":\\\"http:\\\\/\\\\/l2.yimg.com\\\\/bt\\\\/api\\\\/res\\\\/1.2\\\\/uhTcIm0OGqDTd1qtuyiVHQ--\\\\/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE2OTtweW9mZj0wO3E9ODU7dz02MDA-\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/ucomics.com\\\\/crcap130710.gif\\\",\\\"rsrc\\\":\\\"http:\\\\/\\\\/l2.yimg.com\\\\/bt\\\\/api\\\\/res\\\\/1.2\\\\/bbvN0UJx2GpIp_uEggkMQQ--\\\\/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTEwMjtweW9mZj0wO3E9ODU7dz0zNjQ-\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/ucomics.com\\\\/crcap130710.gif\\\",\\\"sdate\\\":\\\"Wed, Jul 10\\\",\\\"date\\\":\\\"Wednesday, July 10\\\"},{\\\"src\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/bt\\\\/api\\\\/res\\\\/1.2\\\\/ejRT5kGg9EhhabqhJeCFUw--\\\\/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE2OTtweW9mZj0wO3E9ODU7dz02MDA-\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/ucomics.com\\\\/crcap130709.gif\\\",\\\"rsrc\\\":\\\"http:\\\\/\\\\/l1.yimg.com\\\\/bt\\\\/api\\\\/res\\\\/1.2\\\\/R52PN4koEPVG6RlHCrZM5w--\\\\/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTEwMjtweW9mZj0wO3E9ODU7dz0zNjQ-\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/ucomics.com\\\\/crcap130709.gif\\\",\\\"sdate\\\":\\\"Tue, Jul 9\\\",\\\"date\\\":\\\"Tuesday, July 9\\\"},{\\\"src\\\":\\\"http:\\\\/\\\\/l3.yimg.com\\\\/bt\\\\/api\\\\/res\\\\/1.2\\\\/T.VjgD2kZmwtsZLCYq58Bw--\\\\/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE2NztweW9mZj0wO3E9ODU7dz02MDA-\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/ucomics.com\\\\/crcap130708.gif\\\",\\\"rsrc\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/bt\\\\/api\\\\/res\\\\/1.2\\\\/AQsZOu7M1A4OPLVohVfnPw--\\\\/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTEwMTtweW9mZj0wO3E9ODU7dz0zNjQ-\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/ucomics.com\\\\/crcap130708.gif\\\",\\\"sdate\\\":\\\"Mon, Jul 8\\\",\\\"date\\\":\\\"Monday, July 8\\\"},{\\\"src\\\":\\\"http:\\\\/\\\\/l3.yimg.com\\\\/bt\\\\/api\\\\/res\\\\/1.2\\\\/vEgdLI0YlpWnMqyG2a3f8A--\\\\/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTI5NTtweW9mZj0wO3E9ODU7dz02MDA-\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/ucomics.com\\\\/crcap130707.jpg\\\",\\\"rsrc\\\":\\\"http:\\\\/\\\\/l3.yimg.com\\\\/bt\\\\/api\\\\/res\\\\/1.2\\\\/ScNgEmRCMk_IA3QPke6KBQ--\\\\/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE3ODtweW9mZj0wO3E9ODU7dz0zNjQ-\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/ucomics.com\\\\/crcap130707.jpg\\\",\\\"sdate\\\":\\\"Sun, Jul 7\\\",\\\"date\\\":\\\"Sunday, July 7\\\"},{\\\"src\\\":\\\"http:\\\\/\\\\/l2.yimg.com\\\\/bt\\\\/api\\\\/res\\\\/1.2\\\\/WqvGZ3HkRWFIQ8e57rFubQ--\\\\/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE2NztweW9mZj0wO3E9ODU7dz02MDA-\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/ucomics.com\\\\/crcap130706.gif\\\",\\\"rsrc\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/bt\\\\/api\\\\/res\\\\/1.2\\\\/VPtfwBlN9rxXr3jVq8C4iA--\\\\/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTEwMTtweW9mZj0wO3E9ODU7dz0zNjQ-\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/ucomics.com\\\\/crcap130706.gif\\\",\\\"sdate\\\":\\\"Sat, Jul 6\\\",\\\"date\\\":\\\"Saturday, July 6\\\"},{\\\"src\\\":\\\"http:\\\\/\\\\/l2.yimg.com\\\\/bt\\\\/api\\\\/res\\\\/1.2\\\\/a5kYphyMeoSHhPKhcxEDZg--\\\\/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE2NztweW9mZj0wO3E9ODU7dz02MDA-\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/ucomics.com\\\\/crcap130705.gif\\\",\\\"rsrc\\\":\\\"http:\\\\/\\\\/l1.yimg.com\\\\/bt\\\\/api\\\\/res\\\\/1.2\\\\/hlYQCS5sUa.dMuD3Xb7Qfw--\\\\/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTEwMTtweW9mZj0wO3E9ODU7dz0zNjQ-\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/ucomics.com\\\\/crcap130705.gif\\\",\\\"sdate\\\":\\\"Fri, Jul 5\\\",\\\"date\\\":\\\"Friday, July 5\\\"},{\\\"src\\\":\\\"http:\\\\/\\\\/l2.yimg.com\\\\/bt\\\\/api\\\\/res\\\\/1.2\\\\/9VOrfbDqdNECeAo854fxsQ--\\\\/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE2NztweW9mZj0wO3E9ODU7dz02MDA-\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/ucomics.com\\\\/crcap130704.gif\\\",\\\"rsrc\\\":\\\"http:\\\\/\\\\/l3.yimg.com\\\\/bt\\\\/api\\\\/res\\\\/1.2\\\\/RRmi4XsDqJ5kRo1fLYxugg--\\\\/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTEwMTtweW9mZj0wO3E9ODU7dz0zNjQ-\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/ucomics.com\\\\/crcap130704.gif\\\",\\\"sdate\\\":\\\"Thu, Jul 4\\\",\\\"date\\\":\\\"Thursday, July 4\\\"},{\\\"src\\\":\\\"http:\\\\/\\\\/l1.yimg.com\\\\/bt\\\\/api\\\\/res\\\\/1.2\\\\/wddGiTLxO4o3oKWe0vjmkQ--\\\\/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE2ODtweW9mZj0wO3E9ODU7dz02MDA-\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/ucomics.com\\\\/crcap130703.gif\\\",\\\"rsrc\\\":\\\"http:\\\\/\\\\/l3.yimg.com\\\\/bt\\\\/api\\\\/res\\\\/1.2\\\\/tCt4UGTs0jx5_3fxZQTHpA--\\\\/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTEwMTtweW9mZj0wO3E9ODU7dz0zNjQ-\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/ucomics.com\\\\/crcap130703.gif\\\",\\\"sdate\\\":\\\"Wed, Jul 3\\\",\\\"date\\\":\\\"Wednesday, July 3\\\"},{\\\"src\\\":\\\"http:\\\\/\\\\/l1.yimg.com\\\\/bt\\\\/api\\\\/res\\\\/1.2\\\\/rx5IZdGFJXxE1XeSPnthrw--\\\\/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE2NztweW9mZj0wO3E9ODU7dz02MDA-\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/ucomics.com\\\\/crcap130702.gif\\\",\\\"rsrc\\\":\\\"http:\\\\/\\\\/l3.yimg.com\\\\/bt\\\\/api\\\\/res\\\\/1.2\\\\/U5l608wGdMuWvH4wWLSOWA--\\\\/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTEwMTtweW9mZj0wO3E9ODU7dz0zNjQ-\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/ucomics.com\\\\/crcap130702.gif\\\",\\\"sdate\\\":\\\"Tue, Jul 2\\\",\\\"date\\\":\\\"Tuesday, July 2\\\"},{\\\"src\\\":\\\"http:\\\\/\\\\/l2.yimg.com\\\\/bt\\\\/api\\\\/res\\\\/1.2\\\\/QPLmjGjpBQGM.GgILcPVAw--\\\\/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE2ODtweW9mZj0wO3E9ODU7dz02MDA-\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/ucomics.com\\\\/crcap130701.gif\\\",\\\"rsrc\\\":\\\"http:\\\\/\\\\/l1.yimg.com\\\\/bt\\\\/api\\\\/res\\\\/1.2\\\\/yVcqJx_KJgeZ3t5USnC3sA--\\\\/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTEwMTtweW9mZj0wO3E9ODU7dz0zNjQ-\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/ucomics.com\\\\/crcap130701.gif\\\",\\\"sdate\\\":\\\"Mon, Jul 1\\\",\\\"date\\\":\\\"Monday, July 1\\\"},{\\\"src\\\":\\\"http:\\\\/\\\\/l1.yimg.com\\\\/bt\\\\/api\\\\/res\\\\/1.2\\\\/a0iI_iYIo5aaG1hytGz5Gg--\\\\/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTI5NTtweW9mZj0wO3E9ODU7dz02MDA-\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/ucomics.com\\\\/crcap130630.jpg\\\",\\\"rsrc\\\":\\\"http:\\\\/\\\\/l1.yimg.com\\\\/bt\\\\/api\\\\/res\\\\/1.2\\\\/7PeEGrxpeBxuJDKqoa0XOw--\\\\/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE3ODtweW9mZj0wO3E9ODU7dz0zNjQ-\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/ucomics.com\\\\/crcap130630.jpg\\\",\\\"sdate\\\":\\\"Sun, Jun 30\\\",\\\"date\\\":\\\"Sunday, June 30\\\"},{\\\"src\\\":\\\"http:\\\\/\\\\/l2.yimg.com\\\\/bt\\\\/api\\\\/res\\\\/1.2\\\\/TKLpO.JWeRvUaCs0R4gkyQ--\\\\/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE3MTtweW9mZj0wO3E9ODU7dz02MDA-\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/ucomics.com\\\\/crcap130629.gif\\\",\\\"rsrc\\\":\\\"http:\\\\/\\\\/l1.yimg.com\\\\/bt\\\\/api\\\\/res\\\\/1.2\\\\/vVbmNO317LvN7FJPH4xwuw--\\\\/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTEwMztweW9mZj0wO3E9ODU7dz0zNjQ-\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/ucomics.com\\\\/crcap130629.gif\\\",\\\"sdate\\\":\\\"Sat, Jun 29\\\",\\\"date\\\":\\\"Saturday, June 29\\\"},{\\\"src\\\":\\\"http:\\\\/\\\\/l2.yimg.com\\\\/bt\\\\/api\\\\/res\\\\/1.2\\\\/xq7OBjHfLnmWYAXbvk4oPA--\\\\/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE2NztweW9mZj0wO3E9ODU7dz02MDA-\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/ucomics.com\\\\/crcap130628.gif\\\",\\\"rsrc\\\":\\\"http:\\\\/\\\\/l2.yimg.com\\\\/bt\\\\/api\\\\/res\\\\/1.2\\\\/ARnYiJhuR4_GsUZ47t.11w--\\\\/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTEwMTtweW9mZj0wO3E9ODU7dz0zNjQ-\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/ucomics.com\\\\/crcap130628.gif\\\",\\\"sdate\\\":\\\"Fri, Jun 28\\\",\\\"date\\\":\\\"Friday, June 28\\\"},{\\\"src\\\":\\\"http:\\\\/\\\\/l2.yimg.com\\\\/bt\\\\/api\\\\/res\\\\/1.2\\\\/crH10YK705dn8aXAWV8GEg--\\\\/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE2ODtweW9mZj0wO3E9ODU7dz02MDA-\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/ucomics.com\\\\/crcap130627.gif\\\",\\\"rsrc\\\":\\\"http:\\\\/\\\\/l2.yimg.com\\\\/bt\\\\/api\\\\/res\\\\/1.2\\\\/OWpgHCEZnzuUV_d9WteS8Q--\\\\/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTEwMTtweW9mZj0wO3E9ODU7dz0zNjQ-\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/ucomics.com\\\\/crcap130627.gif\\\",\\\"sdate\\\":\\\"Thu, Jun 27\\\",\\\"date\\\":\\\"Thursday, June 27\\\"}]}});\\n    });\\n    Y.later(10, this, function() {window.dmRosAds.insertMultiAd({\\n                                        dmRosAdConfig: \\\"e5879714\\\",\\n                                        dmRosAdTypeTag: \\\"default\\\",\\n                                        \\n                                        dmRosAdSlotInfo: [\\n                                            {\\n                                                dmRosAdSlotId: \\\"east\\\",\\n                                                dmRosAdDivId: \\\"dmRosAdWrapper-east\\\",\\n                                                dmRosAdWidth: \\\"300\\\",\\n                                                dmRosAdHeight: \\\"300\\\"\\n                                            }\\n                                        ]\\n                                    });\\n    });\\n    Y.later(10, this, function() {if(Y.Media.Footer) var footer = Y.Media.Footer(Y,{footerInfoSelector:\\\"#footer-info\\\",currentDeviceType:\\\"full\\\",projectId:\\\"10001393120079\\\",enableYwaTracking:\\\"0\\\"});\\n    });\\n});\\n});\\n\\t\\t\\n\\t    \\u003C/script\\u003E\\n\\n\\n\\n                        \\u003Cscript\\u003E\\n                        (function(r) {\\n                            if(! r) { return; }\\n                            \\n                            if(typeof YMEDIA_REQ_ATTR === 'object' && typeof YMEDIA_REQ_ATTR.instr === 'object') {\\n                                r.rapidConfig.keys        = r.rapidConfig.keys || {};\\n                                r.rapidConfig.keys.authfb = YMEDIA_REQ_ATTR.instr.authfb;\\n                                r.rapidConfig.keys.rid    = YMEDIA_REQ_ATTR.instr.request_id;\\n                            }\\n                            \\n                            if(typeof r.initRapid === 'function') {\\n                                r.initRapid();\\n                            } else if(YAHOO && YAHOO.i13n && YAHOO.i13n.Rapid) {\\n                                r.rapidConfig.tracked_mods = typeof r.rapidConfig.tracked_mods === 'object' && r.rapidConfig.tracked_mods.concat(r.moduleQueue) || r.moduleQueue;\\n                                r.moduleQueue = [];\\n                                r.rapidInstance = new YAHOO.i13n.Rapid(r.rapidConfig);\\n                            }\\n                            \\n                        }(YMedia.rapid));\\n                        \\u003C/script\\u003E\\n                        \\n\\t\\u003Cdiv id=\\\"yom-ad-SDARLA\\\" class=\\\"yom-ad yom-ad-SDARLA\\\" style=\\\"visibility: inherit;\\\"\\u003E\\u003Ccenter\\u003E\\u003Cdiv id=\\\"yom-ad-SDARLA-iframe\\\" class=\\\"yom-ad\\\"\\u003E\\u003Ccenter\\u003E\\u003Cscript type='text/javascript' src='http://l.yimg.com/rq/darla/2-6-3/js/g-r-min.js'\\u003E\\u003C/script\\u003E\\u003Cscript type=\\\"text/plain\\\" id=\\\"fc\\\" _ver=\\\"2-6-3\\\"\\u003E{ \\\"positions\\\": [ { \\\"html\\\": \\\"\\u003C!--Vendor: Doubleclick, Format: EXPANDABLE, IO: 123456--\\u003E\\\\n\\u003CSCR\\\"+\\\"IPT language='JavaScript1.1' SRC=\\\\\\\"http://ad.doubleclick.net/adj/N5823.Yahoo/B7708110.17;sz=300x250;dcopt=rcl;mtfIFPath=nofile;click=http://clicks.beap.bc.yahoo.com/yc/YnY9MS4wLjAmYnM9KDE1dWZxbm83MChnaWQkclBVUHFRckhnai45bGJMRFVkMnFQQURiWXRjS1QxSGRxandBQ1AuTCxzdCQxMzczNDgxNTMyNjEwMTQ4LHNpJDQ0NjQwNTEsc3AkODExMjE0NTIsY3IkMzYwMjUwNDU1MSx2JDIuMCxhaWQkeW1RVFoyS0w0TkUtLGN0JDI1LHlieCRXcVU2LmgyaVZzbm1SMGpjUTVIQm9nLGJpJDE4NDgwMTQ1NTEsciQwLHJkJDE2aXRza2M2aSkp/0/*http://global.ard.yahoo.com/SIG=15jdskivn/M=999999.999999.999999.999999/D=yahoo/S=81121452:LREC/Y=YAHOO/EXP=1373488732/L=rPUPqQrHgj.9lbLDUd2qPADbYtcKT1HdqjwACP.L/B=ymQTZ2KL4NE-/J=1373481532645679/K=kH8ldoKcvhSl3WdU9IHexw/A=7769920327943012471/R=0/X=6/*;ord=1373481532.645679?\\\\\\\"\\u003E\\u003C/SCR\\\"+\\\"IPT\\u003E\\u003CNOSCR\\\"+\\\"IPT\\u003E\\u003CA HREF=\\\\\\\"http://clicks.beap.bc.yahoo.com/yc/YnY9MS4wLjAmYnM9KDE1dW9jZTFsYyhnaWQkclBVUHFRckhnai45bGJMRFVkMnFQQURiWXRjS1QxSGRxandBQ1AuTCxzdCQxMzczNDgxNTMyNjEwMTQ4LHNpJDQ0NjQwNTEsc3AkODExMjE0NTIsY3IkMzYwMjUwNDU1MSx2JDIuMCxhaWQkeW1RVFoyS0w0TkUtLGN0JDI1LHlieCRXcVU2LmgyaVZzbm1SMGpjUTVIQm9nLGJpJDE4NDgwMTQ1NTEsciQxLHJkJDE2aXZocTdnOCkp/0/*http://global.ard.yahoo.com/SIG=15jdskivn/M=999999.999999.999999.999999/D=yahoo/S=81121452:LREC/Y=YAHOO/EXP=1373488732/L=rPUPqQrHgj.9lbLDUd2qPADbYtcKT1HdqjwACP.L/B=ymQTZ2KL4NE-/J=1373481532645679/K=kH8ldoKcvhSl3WdU9IHexw/A=7769920327943012471/R=1/X=6/*http://ad.doubleclick.net/jump/N5823.Yahoo/B7708110.17;sz=300x250;dcopt=rcl;mtfIFPath=nofile;click=http://clicks.beap.bc.yahoo.com/yc/YnY9MS4wLjAmYnM9KDE1dTMyZDE5MihnaWQkclBVUHFRckhnai45bGJMRFVkMnFQQURiWXRjS1QxSGRxandBQ1AuTCxzdCQxMzczNDgxNTMyNjEwMTQ4LHNpJDQ0NjQwNTEsc3AkODExMjE0NTIsY3IkMzYwMjUwNDU1MSx2JDIuMCxhaWQkeW1RVFoyS0w0TkUtLGN0JDI1LHlieCRXcVU2LmgyaVZzbm1SMGpjUTVIQm9nLGJpJDE4NDgwMTQ1NTEsciQyLHJkJDE2aXJkMGlzNCkp/0/*http://global.ard.yahoo.com/SIG=15jdskivn/M=999999.999999.999999.999999/D=yahoo/S=81121452:LREC/Y=YAHOO/EXP=1373488732/L=rPUPqQrHgj.9lbLDUd2qPADbYtcKT1HdqjwACP.L/B=ymQTZ2KL4NE-/J=1373481532645679/K=kH8ldoKcvhSl3WdU9IHexw/A=7769920327943012471/R=2/X=6/*;ord=1373481532.645679?\\\\\\\"\\u003E\\u003CIMG SRC=\\\\\\\"http://ad.doubleclick.net/ad/N5823.Yahoo/B7708110.17;sz=300x250;dcopt=rcl;mtfIFPath=nofile;click=http://clicks.beap.bc.yahoo.com/yc/YnY9MS4wLjAmYnM9KDE1dWlvM2Q5NihnaWQkclBVUHFRckhnai45bGJMRFVkMnFQQURiWXRjS1QxSGRxandBQ1AuTCxzdCQxMzczNDgxNTMyNjEwMTQ4LHNpJDQ0NjQwNTEsc3AkODExMjE0NTIsY3IkMzYwMjUwNDU1MSx2JDIuMCxhaWQkeW1RVFoyS0w0TkUtLGN0JDI1LHlieCRXcVU2LmgyaVZzbm1SMGpjUTVIQm9nLGJpJDE4NDgwMTQ1NTEsciQzLHJkJDE2aWZpNzJkcCkp/0/*http://global.ard.yahoo.com/SIG=15jdskivn/M=999999.999999.999999.999999/D=yahoo/S=81121452:LREC/Y=YAHOO/EXP=1373488732/L=rPUPqQrHgj.9lbLDUd2qPADbYtcKT1HdqjwACP.L/B=ymQTZ2KL4NE-/J=1373481532645679/K=kH8ldoKcvhSl3WdU9IHexw/A=7769920327943012471/R=3/X=6/*;ord=1373481532.645679?\\\\\\\" BORDER=0 WIDTH=300 HEIGHT=250 ALT=\\\\\\\"Advertisement\\\\\\\"\\u003E\\u003C/A\\u003E\\u003C/NOSCR\\\"+\\\"IPT\\u003E\\\\n\\\\n\\u003C!--Vendor: TRUSTe, Format: Floating, IO: 123456--\\u003E\\\\n\\u003Cspan id=\\\\\\\"te-clearads-js-[cachebuster]\\\\\\\"\\u003E\\\\n\\u003CSCR\\\"+\\\"IPT type=\\\\\\\"text/javascr\\\"+\\\"ipt\\\\\\\" src=\\\\\\\"http://choices.truste.com/ca?pid=hp01&aid=hp02&cid=98875939&c=[cachebuster]&w=300&h=250&plc=tl&js=10\\\\\\\"\\u003E\\u003C/scr\\\"+\\\"ipt\\u003E\\u003C/span\\u003E\\\\n\\\\n\\u003C!--Vendor: AdSafe, Format: Pixel, IO: 123456--\\u003E\\\\n\\u003CIMG SRC=\\\\\\\"http://pixel.adsafeprotected.com/rfw/st/18662/1154987/skeleton.gif?&_u=1373481532.645679\\\\\\\" BORDER=0 WIDTH=1 HEIGHT=1 ALT=\\\\\\\"\\\\\\\"\\u003E\\u003C!--QYZ 1848014551,3602504551,98.139.229.180;;LREC;81121452;1;--\\u003E\\\", \\\"id\\\": \\\"LREC\\\", \\\"meta\\\": { \\\"y\\\": { \\\"cscHTML\\\": \\\"\\u003Cscr\\\"+\\\"ipt language=javascr\\\"+\\\"ipt\\u003E\\\\nif(window.xzq_d==null)window.xzq_d=new Object();\\\\nwindow.xzq_d['ymQTZ2KL4NE-']='(as$12re24ipd,aid$ymQTZ2KL4NE-,bi$1848014551,cr$3602504551,ct$25,at$H,eob$-1)';\\\\n\\u003C/scr\\\"+\\\"ipt\\u003E\\u003Cnoscr\\\"+\\\"ipt\\u003E\\u003Cimg width=1 height=1 alt=\\\\\\\"\\\\\\\" src=\\\\\\\"http://csc.beap.bc.yahoo.com/yi?bv=1.0.0&bs=(134dc4tfh(gid$rPUPqQrHgj.9lbLDUd2qPADbYtcKT1HdqjwACP.L,st$1373481532610148,si$4464051,sp$81121452,pv$0,v$2.0))&t=J_3-D_3&al=(as$12re24ipd,aid$ymQTZ2KL4NE-,bi$1848014551,cr$3602504551,ct$25,at$H,eob$-1)\\\\\\\"\\u003E\\u003C/noscr\\\"+\\\"ipt\\u003E\\\", \\\"cscURI\\\": \\\"http://csc.beap.bc.yahoo.com/yi?bv=1.0.0&bs=(134dc4tfh(gid$rPUPqQrHgj.9lbLDUd2qPADbYtcKT1HdqjwACP.L,st$1373481532610148,si$4464051,sp$81121452,pv$0,v$2.0))&t=J_3-D_3&al=(as$12re24ipd,aid$ymQTZ2KL4NE-,bi$1848014551,cr$3602504551,ct$25,at$H,eob$-1)\\\", \\\"creativeID\\\": \\\"3602504551\\\", \\\"behavior\\\": \\\"ajax_exp\\\", \\\"adID\\\": \\\"7769920327943012471\\\", \\\"matchID\\\": \\\"999999.999999.999999.999999\\\", \\\"err\\\": \\\"\\\", \\\"hasExternal\\\": 0, \\\"size\\\": \\\"300x250\\\", \\\"bookID\\\": \\\"1848014551\\\", \\\"serveType\\\": \\\"-1\\\", \\\"slotID\\\": \\\"0\\\" } } },{ \\\"html\\\": \\\"\\u003C!-- SpaceID=81121452 loc=MAST noad --\\u003E\\u003C!-- fac-gd2-noad --\\u003E\\u003C!-- gd2-status-2 --\\u003E\\u003C!--QYZ CMS_NONE_AVAIL,,98.139.229.180;;MAST;81121452;2;--\\u003E\\\", \\\"id\\\": \\\"MAST\\\", \\\"meta\\\": { \\\"y\\\": { \\\"cscHTML\\\": \\\"\\u003Cscr\\\"+\\\"ipt language=javascr\\\"+\\\"ipt\\u003E\\\\nif(window.xzq_d==null)window.xzq_d=new Object();\\\\nwindow.xzq_d['magTZ2KL4NE-']='(as$125c9ssij,aid$magTZ2KL4NE-,cr$-1,ct$25,at$H,eob$-1)';\\\\n\\u003C/scr\\\"+\\\"ipt\\u003E\\u003Cnoscr\\\"+\\\"ipt\\u003E\\u003Cimg width=1 height=1 alt=\\\\\\\"\\\\\\\" src=\\\\\\\"http://csc.beap.bc.yahoo.com/yi?bv=1.0.0&bs=(134dc4tfh(gid$rPUPqQrHgj.9lbLDUd2qPADbYtcKT1HdqjwACP.L,st$1373481532610148,si$4464051,sp$81121452,pv$0,v$2.0))&t=J_3-D_3&al=(as$125c9ssij,aid$magTZ2KL4NE-,cr$-1,ct$25,at$H,eob$-1)\\\\\\\"\\u003E\\u003C/noscr\\\"+\\\"ipt\\u003E\\\", \\\"cscURI\\\": \\\"http://csc.beap.bc.yahoo.com/yi?bv=1.0.0&bs=(134dc4tfh(gid$rPUPqQrHgj.9lbLDUd2qPADbYtcKT1HdqjwACP.L,st$1373481532610148,si$4464051,sp$81121452,pv$0,v$2.0))&t=J_3-D_3&al=(as$125c9ssij,aid$magTZ2KL4NE-,cr$-1,ct$25,at$H,eob$-1)\\\", \\\"creativeID\\\": \\\"-1\\\", \\\"behavior\\\": \\\"non_exp\\\", \\\"adID\\\": \\\"#2\\\", \\\"matchID\\\": \\\"#2\\\", \\\"err\\\": \\\"invalid_space\\\", \\\"hasExternal\\\": 0, \\\"size\\\": \\\"\\\", \\\"bookID\\\": \\\"CMS_NONE_AVAIL\\\", \\\"serveType\\\": \\\"-1\\\", \\\"slotID\\\": \\\"1\\\" } } },{ \\\"html\\\": \\\"\\u003C!--Vendor: Right Media, Format: IFrame --\\u003E\\u003Cdiv ALLOWTRANSPARENCY=TRUE FRAMEBORDER=0 MARGINWIDTH=0 MARGINHEIGHT=0 SCROLLING=NO WIDTH=300 HEIGHT=250 SRC=\\\\\\\"http://ad.yieldmanager.com/st?ad_type=div&publisher_blob=${RS}|rPUPqQrHgj.9lbLDUd2qPADbYtcKT1HdqjwACP.L|81121452|LREC2|1373481532.646478&cnt=yan&ad_size=300x250&site=140477&section_code=2288163051&cb=1373481532.646478&yud=smpv%3d3%26ed%3dzAomdE.7n1vQ06Bzq5du4W6H0h1AhZ0BrKw-&pub_redirect_unencoded=1&pub_redirect=http://clicks.beap.bc.yahoo.com/yc/YnY9MS4wLjAmYnM9KDE1dWVuNGhscyhnaWQkclBVUHFRckhnai45bGJMRFVkMnFQQURiWXRjS1QxSGRxandBQ1AuTCxzdCQxMzczNDgxNTMyNjEwMTQ4LHNpJDQ0NjQwNTEsc3AkODExMjE0NTIsY3IkMzA4NTQ4MDU1MSx2JDIuMCxhaWQkYU93VFoyS0w0TkUtLGN0JDI1LHlieCRXcVU2LmgyaVZzbm1SMGpjUTVIQm9nLGJpJDE1ODUwOTMwNTEsciQwLHJkJDE2aXU2cGJwMCkp/0/*http://global.ard.yahoo.com/SIG=15kvg4h3o/M=999999.999999.999999.999999/D=yahoo/S=81121452:LREC2/Y=YAHOO/EXP=1373488732/L=rPUPqQrHgj.9lbLDUd2qPADbYtcKT1HdqjwACP.L/B=aOwTZ2KL4NE-/J=1373481532646478/K=kH8ldoKcvhSl3WdU9IHexw/A=6647776369999917826/R=0/X=6/*\\\\\\\"\\u003E\\u003C/div\\u003E\\u003C!--QYZ 1585093051,3085480551,98.139.229.180;;LREC2;81121452;1;--\\u003E\\\", \\\"id\\\": \\\"LREC2\\\", \\\"meta\\\": { \\\"y\\\": { \\\"cscHTML\\\": \\\"\\u003Cscr\\\"+\\\"ipt language=javascr\\\"+\\\"ipt\\u003E\\\\nif(window.xzq_d==null)window.xzq_d=new Object();\\\\nwindow.xzq_d['aOwTZ2KL4NE-']='(as$12r31pu2o,aid$aOwTZ2KL4NE-,bi$1585093051,cr$3085480551,ct$25,at$H,eob$-1)';\\\\n\\u003C/scr\\\"+\\\"ipt\\u003E\\u003Cnoscr\\\"+\\\"ipt\\u003E\\u003Cimg width=1 height=1 alt=\\\\\\\"\\\\\\\" src=\\\\\\\"http://csc.beap.bc.yahoo.com/yi?bv=1.0.0&bs=(134dc4tfh(gid$rPUPqQrHgj.9lbLDUd2qPADbYtcKT1HdqjwACP.L,st$1373481532610148,si$4464051,sp$81121452,pv$0,v$2.0))&t=J_3-D_3&al=(as$12r31pu2o,aid$aOwTZ2KL4NE-,bi$1585093051,cr$3085480551,ct$25,at$H,eob$-1)\\\\\\\"\\u003E\\u003C/noscr\\\"+\\\"ipt\\u003E\\\", \\\"cscURI\\\": \\\"http://csc.beap.bc.yahoo.com/yi?bv=1.0.0&bs=(134dc4tfh(gid$rPUPqQrHgj.9lbLDUd2qPADbYtcKT1HdqjwACP.L,st$1373481532610148,si$4464051,sp$81121452,pv$0,v$2.0))&t=J_3-D_3&al=(as$12r31pu2o,aid$aOwTZ2KL4NE-,bi$1585093051,cr$3085480551,ct$25,at$H,eob$-1)\\\", \\\"creativeID\\\": \\\"3085480551\\\", \\\"behavior\\\": \\\"non_exp\\\", \\\"adID\\\": \\\"6647776369999917826\\\", \\\"matchID\\\": \\\"999999.999999.999999.999999\\\", \\\"err\\\": \\\"\\\", \\\"hasExternal\\\": 0, \\\"size\\\": \\\"300x250\\\", \\\"bookID\\\": \\\"1585093051\\\", \\\"serveType\\\": \\\"-1\\\", \\\"slotID\\\": \\\"2\\\" } } } ], \\\"meta\\\": { \\\"y\\\": { \\\"pageEndHTML\\\": \\\"\\u003Cscr\\\"+\\\"ipt language=javascr\\\"+\\\"ipt\\u003E\\\\n(function(){window.xzq_p=function(R){M=R};window.xzq_svr=function(R){J=R};function F(S){var T=document;if(T.xzq_i==null){T.xzq_i=new Array();T.xzq_i.c=0}var R=T.xzq_i;R[++R.c]=new Image();R[R.c].src=S}window.xzq_sr=function(){var S=window;var Y=S.xzq_d;if(Y==null){return }if(J==null){return }var T=J+M;if(T.length\\u003EP){C();return }var X=\\\\\\\"\\\\\\\";var U=0;var W=Math.random();var V=(Y.hasOwnProperty!=null);var R;for(R in Y){if(typeof Y[R]==\\\\\\\"string\\\\\\\"){if(V&&!Y.hasOwnProperty(R)){continue}if(T.length+X.length+Y[R].length\\u003C=P){X+=Y[R]}else{if(T.length+Y[R].length\\u003EP){}else{U++;N(T,X,U,W);X=Y[R]}}}}if(U){U++}N(T,X,U,W);C()};function N(R,U,S,T){if(U.length\\u003E0){R+=\\\\\\\"&al=\\\\\\\"}F(R+U+\\\\\\\"&s=\\\\\\\"+S+\\\\\\\"&r=\\\\\\\"+T)}function C(){window.xzq_d=null;M=null;J=null}function K(R){xzq_sr()}function B(R){xzq_sr()}function L(U,V,W){if(W){var R=W.toString();var T=U;var Y=R.match(new RegExp(\\\\\\\"\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\(([^\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\)]*)\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\)\\\\\\\"));Y=(Y[1].length\\u003E0?Y[1]:\\\\\\\"e\\\\\\\");T=T.replace(new RegExp(\\\\\\\"\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\([^\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\)]*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\)\\\\\\\",\\\\\\\"g\\\\\\\"),\\\\\\\"(\\\\\\\"+Y+\\\\\\\")\\\\\\\");if(R.indexOf(T)\\u003C0){var X=R.indexOf(\\\\\\\"{\\\\\\\");if(X\\u003E0){R=R.substring(X,R.length)}else{return W}R=R.replace(new RegExp(\\\\\\\"([^a-zA-Z0-9$_])this([^a-zA-Z0-9$_])\\\\\\\",\\\\\\\"g\\\\\\\"),\\\\\\\"$1xzq_this$2\\\\\\\");var Z=T+\\\\\\\";var rv = f( \\\\\\\"+Y+\\\\\\\",this);\\\\\\\";var S=\\\\\\\"{var a0 = '\\\\\\\"+Y+\\\\\\\"';var ofb = '\\\\\\\"+escape(R)+\\\\\\\"' ;var f = new Function( a0, 'xzq_this', unescape(ofb));\\\\\\\"+Z+\\\\\\\"return rv;}\\\\\\\";return new Function(Y,S)}else{return W}}return V}window.xzq_eh=function(){if(E||I){this.onload=L(\\\\\\\"xzq_onload(e)\\\\\\\",K,this.onload,0);if(E&&typeof (this.onbeforeunload)!=O){this.onbeforeunload=L(\\\\\\\"xzq_dobeforeunload(e)\\\\\\\",B,this.onbeforeunload,0)}}};window.xzq_s=function(){setTimeout(\\\\\\\"xzq_sr()\\\\\\\",1)};var J=null;var M=null;var Q=navigator.appName;var H=navigator.appVersion;var G=navigator.userAgent;var A=parseInt(H);var D=Q.indexOf(\\\\\\\"Microsoft\\\\\\\");var E=D!=-1&&A\\u003E=4;var I=(Q.indexOf(\\\\\\\"Netscape\\\\\\\")!=-1||Q.indexOf(\\\\\\\"Opera\\\\\\\")!=-1)&&A\\u003E=4;var O=\\\\\\\"undefined\\\\\\\";var P=2000})();\\\\n\\u003C/scr\\\"+\\\"ipt\\u003E\\u003Cscr\\\"+\\\"ipt language=javascr\\\"+\\\"ipt\\u003E\\\\nif(window.xzq_svr)xzq_svr('http://csc.beap.bc.yahoo.com/');\\\\nif(window.xzq_p)xzq_p('yi?bv=1.0.0&bs=(134dc4tfh(gid$rPUPqQrHgj.9lbLDUd2qPADbYtcKT1HdqjwACP.L,st$1373481532610148,si$4464051,sp$81121452,pv$0,v$2.0))&t=J_3-D_3');\\\\nif(window.xzq_s)xzq_s();\\\\n\\u003C/scr\\\"+\\\"ipt\\u003E\\u003Cnoscr\\\"+\\\"ipt\\u003E\\u003Cimg width=1 height=1 alt=\\\\\\\"\\\\\\\" src=\\\\\\\"http://csc.beap.bc.yahoo.com/yi?bv=1.0.0&bs=(134dc4tfh(gid$rPUPqQrHgj.9lbLDUd2qPADbYtcKT1HdqjwACP.L,st$1373481532610148,si$4464051,sp$81121452,pv$0,v$2.0))&t=J_3-D_3\\\\\\\"\\u003E\\u003C/noscr\\\"+\\\"ipt\\u003E\\\", \\\"pos_list\\\": [ \\\"LREC\\\",\\\"MAST\\\",\\\"LREC2\\\" ], \\\"spaceID\\\": \\\"81121452\\\", \\\"host\\\": \\\"news.yahoo.com\\\", \\\"lookupTime\\\": \\\"41\\\", \\\"k2_uri\\\": \\\"\\\", \\\"fac_rt\\\": \\\"39632\\\", \\\"pvid\\\": \\\"rPUPqQrHgj.9lbLDUd2qPADbYtcKT1HdqjwACP.L\\\", \\\"tID\\\": \\\"darla_prefetch_1373481532608_787402516_1\\\" } } } \\u003C/script\\u003E\\n\\u003Cscript\\u003E(function(){ var wrap = document.getElementById(\\\"yom-ad-SDARLA\\\"); if (null == wrap) { wrap = document.getElementById(\\\"yom-ad-SDARLA-iframe\\\") || {}; } var content = wrap.innerHTML || \\\"\\\"; if (content && content.substr(0, content.lastIndexOf(\\\"\\u003Cscript\\u003E\\\")).indexOf(\\\"loc=SDARLA noad\\\") !== -1) { wrap.style.display = \\\"none\\\"; } }())\\u003C/script\\u003E\\u003C/center\\u003E\\u003C/div\\u003E\\u003C/center\\u003E\\u003C/div\\u003E\\n\\t\\u003Cdiv id=\\\"yom-ad-SDARLAEXTRA\\\" class=\\\"yom-ad yom-ad-SDARLAEXTRA\\\" style=\\\"visibility: inherit;\\\"\\u003E\\u003Ccenter\\u003E\\u003Cdiv id=\\\"yom-ad-SDARLAEXTRA-iframe\\\" class=\\\"yom-ad\\\"\\u003E\\u003Ccenter\\u003E    \\n        \\u003Cscript type='text/javascript'\\u003E\\n    function loadAdsAfterOnLoad() {        \\n        YMedia.later(10, this, function() {\\n        \\n            YMedia.use(\\\"node-base\\\", function(Y){\\n                        \\n                /* YUI Ads Darla begins... */\\n                YUI.AdsDarla = (function (){\\n                     \\n                    var nodes = {\\\"yom-ad-LREC\\\":{\\\"node\\\":\\\"\\u003Cdiv id='yom-ad-LREC-iframe' class='yom-ad-iframe' marginwidth='0' marginheight='0'\\\\n                                    hspace='0' vspace='0' frameborder='0' scrolling='no' style='display:none;\\\\n                                    width:300px;height:266px;'\\u003E\\\\n                            \\u003C\\\\/div\\u003E\\\",\\\"id\\\":\\\"yom-ad-LREC-iframe\\\"},\\\"yom-ad-LREC2\\\":{\\\"node\\\":\\\"\\u003Cdiv id='yom-ad-LREC2-iframe' class='yom-ad-iframe' marginwidth='0' marginheight='0'\\\\n                                    hspace='0' vspace='0' frameborder='0' scrolling='no' style='display:none;\\\\n                                    width:300px;height:266px;'\\u003E\\\\n                            \\u003C\\\\/div\\u003E\\\",\\\"id\\\":\\\"yom-ad-LREC2-iframe\\\"},\\\"yom-ad-LDRB\\\":{\\\"node\\\":\\\"\\u003Cdiv id='yom-ad-LDRB-iframe' class='yom-ad-iframe' marginwidth='0' marginheight='0'\\\\n                                    hspace='0' vspace='0' frameborder='0' scrolling='no' style='display:none;\\\\n                                    width:728px;height:93px;'\\u003E\\\\n                            \\u003C\\\\/div\\u003E\\\",\\\"id\\\":\\\"yom-ad-LDRB-iframe\\\"},\\\"yom-ad-LDRB2\\\":{\\\"node\\\":\\\"\\u003Cdiv id='yom-ad-LDRB2-iframe' class='yom-ad-iframe' marginwidth='0' marginheight='0'\\\\n                                    hspace='0' vspace='0' frameborder='0' scrolling='no' style='display:none;\\\\n                                    width:728px;height:93px;'\\u003E\\\\n                            \\u003C\\\\/div\\u003E\\\",\\\"id\\\":\\\"yom-ad-LDRB2-iframe\\\"},\\\"yom-ad-LDRB3\\\":{\\\"node\\\":\\\"\\u003Cdiv id='yom-ad-LDRB3-iframe' class='yom-ad-iframe' marginwidth='0' marginheight='0'\\\\n                                    hspace='0' vspace='0' frameborder='0' scrolling='no' style='display:none;\\\\n                                    width:728px;height:93px;'\\u003E\\\\n                            \\u003C\\\\/div\\u003E\\\",\\\"id\\\":\\\"yom-ad-LDRB3-iframe\\\"},\\\"yom-ad-MAST\\\":{\\\"node\\\":\\\"\\u003Cdiv id='yom-ad-MAST-iframe' class='yom-ad-iframe' marginwidth='0' marginheight='0'\\\\n                                    hspace='0' vspace='0' frameborder='0' scrolling='no' style='display:none;\\\\n                                    width:970px;height:31px;'\\u003E\\\\n                            \\u003C\\\\/div\\u003E\\\",\\\"id\\\":\\\"yom-ad-MAST-iframe\\\"},\\\"yom-ad-WPS\\\":{\\\"node\\\":\\\"\\u003Cdiv id='yom-ad-WPS-iframe' class='yom-ad-iframe' marginwidth='0' marginheight='0'\\\\n                                    hspace='0' vspace='0' frameborder='0' scrolling='no' style='display:none;\\\\n                                    width:320px;height:66px;'\\u003E\\\\n                            \\u003C\\\\/div\\u003E\\\",\\\"id\\\":\\\"yom-ad-WPS-iframe\\\"}};\\n                                            \\n                    DARLA_CONFIG = {\\\"servicePath\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/__darla\\\\/php\\\\/fc.php\\\",\\\"beaconPath\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/__darla\\\\/php\\\\/b.php\\\",\\\"renderPath\\\":\\\"\\\",\\\"allowFiF\\\":false,\\\"srenderPath\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/rq\\\\/darla\\\\/2-6-3\\\\/html\\\\/r-sf.html\\\",\\\"renderFile\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/rq\\\\/darla\\\\/2-6-3\\\\/html\\\\/r-sf.html\\\",\\\"sfbrenderPath\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/rq\\\\/darla\\\\/2-6-3\\\\/html\\\\/r-sf.html\\\",\\\"msgPath\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/__darla\\\\/2-6-3\\\\/html\\\\/msg.html\\\",\\\"cscPath\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/rq\\\\/darla\\\\/2-6-3\\\\/html\\\\/r-csc.html\\\",\\\"root\\\":\\\"__darla\\\",\\\"edgeRoot\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/rq\\\\/darla\\\\/2-6-3\\\",\\\"sedgeRoot\\\":\\\"https:\\\\/\\\\/s.yimg.com\\\\/rq\\\\/darla\\\\/2-6-3\\\",\\\"version\\\":\\\"2-6-3\\\",\\\"tpbURI\\\":\\\"\\\",\\\"beaconsDisabled\\\":true,\\\"rotationTimingDisabled\\\":true,\\\"positions\\\":{\\\"LREC\\\":{\\\"w\\\":300,\\\"h\\\":250},\\\"MAST\\\":[],\\\"LREC2\\\":{\\\"w\\\":300,\\\"h\\\":250}}};\\n                    \\n                    /* replacing the port number */\\n                    DARLA_CONFIG.servicePath = DARLA_CONFIG.servicePath.replace(/\\\\:8033/g, \\\"\\\");\\n                    DARLA_CONFIG.msgPath = DARLA_CONFIG.msgPath.replace(/\\\\:8033/g, \\\"\\\");\\n                                        \\n                    /* configuring the Ad positions */\\n                    DARLA_CONFIG.positions = {\\\"LREC2\\\":{\\\"w\\\":\\\"300\\\",\\\"h\\\":266,\\\"dest\\\":\\\"yom-ad-LREC2-iframe\\\",\\\"fr\\\":\\\"expIfr_exp\\\",\\\"pos\\\":\\\"LREC2\\\",\\\"id\\\":\\\"LREC2\\\",\\\"clean\\\":\\\"yom-ad-LREC2\\\",\\\"rmxp\\\":0,\\\"z\\\":10},\\\"MAST\\\":{\\\"w\\\":\\\"970\\\",\\\"h\\\":31,\\\"dest\\\":\\\"yom-ad-MAST-iframe\\\",\\\"fr\\\":\\\"expIfr_exp\\\",\\\"pos\\\":\\\"MAST\\\",\\\"id\\\":\\\"MAST\\\",\\\"clean\\\":\\\"yom-ad-MAST\\\",\\\"rmxp\\\":0,\\\"supports\\\":{\\\"*\\\":1}},\\\"LREC\\\":{\\\"w\\\":\\\"300\\\",\\\"h\\\":266,\\\"dest\\\":\\\"yom-ad-LREC-iframe\\\",\\\"fr\\\":\\\"expIfr_exp\\\",\\\"pos\\\":\\\"LREC\\\",\\\"id\\\":\\\"LREC\\\",\\\"clean\\\":\\\"yom-ad-LREC\\\",\\\"rmxp\\\":0,\\\"z\\\":10},\\\"WPS\\\":{\\\"w\\\":\\\"320\\\",\\\"h\\\":66,\\\"dest\\\":\\\"yom-ad-WPS-iframe\\\",\\\"fr\\\":\\\"expIfr_exp\\\",\\\"pos\\\":\\\"WPS\\\",\\\"id\\\":\\\"WPS\\\",\\\"clean\\\":\\\"yom-ad-WPS\\\",\\\"rmxp\\\":0,\\\"metaSize\\\":true},\\\"LDRB3\\\":{\\\"w\\\":\\\"728\\\",\\\"h\\\":93,\\\"dest\\\":\\\"yom-ad-LDRB3-iframe\\\",\\\"fr\\\":\\\"expIfr_exp\\\",\\\"pos\\\":\\\"LDRB3\\\",\\\"id\\\":\\\"LDRB3\\\",\\\"clean\\\":\\\"yom-ad-LDRB3\\\",\\\"rmxp\\\":0},\\\"LDRB2\\\":{\\\"w\\\":\\\"728\\\",\\\"h\\\":93,\\\"dest\\\":\\\"yom-ad-LDRB2-iframe\\\",\\\"fr\\\":\\\"expIfr_exp\\\",\\\"pos\\\":\\\"LDRB2\\\",\\\"id\\\":\\\"LDRB2\\\",\\\"clean\\\":\\\"yom-ad-LDRB2\\\",\\\"rmxp\\\":0},\\\"LDRB\\\":{\\\"w\\\":\\\"728\\\",\\\"h\\\":93,\\\"dest\\\":\\\"yom-ad-LDRB-iframe\\\",\\\"fr\\\":\\\"expIfr_exp\\\",\\\"pos\\\":\\\"LDRB\\\",\\\"id\\\":\\\"LDRB\\\",\\\"clean\\\":\\\"yom-ad-LDRB\\\",\\\"rmxp\\\":0}};\\n                    \\n                    /* configuring the Ad events */\\n                    DARLA_CONFIG.events = {\\\"mediaadsdarla\\\":{\\\"lvl\\\":\\\"2\\\",\\\"sp\\\":\\\"81121452\\\",\\\"npv\\\":\\\"1\\\",\\\"bg\\\":\\\"FFFFFF\\\",\\\"sa\\\":\\\"\\\\\\\"minihome\\\\\\\"=\\\\\\\"home\\\\\\\" \\\\\\\"type\\\\\\\"=\\\\\\\"page\\\\\\\" lang=\\\\\\\"en-US\\\\\\\"  can_suppress_ugc=\\\\\\\"1\\\\\\\" LREC=\\\\\\\"300x250\\\\\\\" LREC2=\\\\\\\"300x250\\\\\\\"\\\",\\\"sa_orig\\\":\\\"\\\\\\\"minihome\\\\\\\"=\\\\\\\"home\\\\\\\" \\\\\\\"type\\\\\\\"=\\\\\\\"page\\\\\\\" lang=\\\\\\\"en-US\\\\\\\"  can_suppress_ugc=\\\\\\\"1\\\\\\\" LREC=\\\\\\\"300x250\\\\\\\" LREC2=\\\\\\\"300x250\\\\\\\"\\\",\\\"filter\\\":\\\"no_expandable;exp_iframe_expandable;\\\",\\\"mpid\\\":\\\"692\\\",\\\"mpnm\\\":\\\"yahoo_mobile_us_web\\\",\\\"locale\\\":\\\"US\\\",\\\"ps\\\":\\\"LREC,LREC2,LDRB,LDRB2,LDRB3,MAST,WPS\\\",\\\"ml\\\":\\\"\\\",\\\"mps\\\":\\\"\\\"}};\\n\\n                    DARLA_CONFIG.onFinishPosRender = function(pos_id) {\\n                        var pos_conf, id, el, par, shm;\\n                        if (pos_id) {\\n                            pos_conf = DARLA.posSettings(pos_id);\\n                            id = (pos_conf && pos_conf.dest);\\n                            el = (id && document.getElementById(id)) || null;\\n                            par = (el && el.parentNode);\\n                            shm = (id && document.getElementById(\\\"shm_\\\" + id));\\n                            if (par) {par.style.zIndex = 99; }\\n                            if (shm) {shm.style.zIndex = 99; }\\n                            if (el) {el.style.zIndex = 100; }\\n                        }\\n                    };\\n                    DARLA_CONFIG.onPosMsg = function(msg, id){\\n                        if( !DARLA.isIE ) return;\\n                        // this event is fired synchronously, so we must run right\\n                        // after the thread ended. setTimeout(...,1) should take care of this.\\n                        setTimeout(\\n                            function(){\\n                                var i=0,iframes, iframe, id, zmap={},shim=[],d=document;\\n                                // exp-over and exp-push are expansion over content, and expansion pushing content.\\n                                if( msg === 'exp-ovr' || msg === 'exp-push' ){\\n                                    // map all iframes on the DOM\\n                                    iframes = d.getElementsByTagName(\\\"iframe\\\");\\n                                    for(; iframe = iframes[i++] ;){\\n                                        id = iframe.id;\\n                                        // Store each iframe zIndex\\n                                        zmap[id] = iframe.style.zIndex;\\n                                        // The iframes with the prefix shm_ are Darla's shims\\n                                        if( id.indexOf('shm_') === 0 ){\\n                                            shim[shim.length] = id;\\n                                        }\\n                                    }\\n                                    if( shim.length \\u003E 0 ){\\n                                        // now look for shims and set it z-1 from it's sibling\\n                                        for(i=0; iframe = shim[i++] ;){\\n                                            // the sibling is found by removing the prefix\\n                                            id = iframe.substr(4); // - \\\"shm_\\\"\\n                                            d.getElementById(iframe).style.zIndex = zmap[id] - 1;               \\n                                        }\\n                                    }\\n                                }       \\n                            },\\n                        10);\\n                    };\\n                    \\n                    DARLA_CONFIG.onSuccess = function (eventId, positions) {\\n                        Y.Global.fire('darla:success', {\\n                            positions: positions\\n                        });\\n                        Y.log('fetch ad success: ' + positions.join(', '), 'info', 'darla');\\n                    };\\n\\n                    DARLA_CONFIG.onFailure = function (eventId) {\\n                        var positions = null;\\n                        try {\\n                            positions = DARLA_CONFIG.events[eventId].ps.split(',');\\n                        } catch (e) {}\\n\\n                        Y.Global.fire('darla:failure', {\\n                            positions: positions\\n                        });\\n                        Y.log('fetch ad failure' + (positions ? (': ' + positions.join(', ')) : ''), 'warn', 'darla');\\n                    };        \\n                    /* preparing the Nodes with iframes. Note this would be hidden iframe and not visible in the DOM */\\n                    var _prepareNodes = function(){\\n                        for(var cleanId in nodes){\\n                            var center = Y.one(\\\"#\\\"+cleanId+\\\" \\u003E center\\\");\\n                            if(center != null && center && !Y.one(\\\"#\\\" + nodes[cleanId].id)){\\n                                center.set(\\\"innerHTML\\\",\\\"\\\");\\n                                center.insert(nodes[cleanId].node);\\n                            }\\n                        }\\n                    };\\n\\n                    /* setting up DARLA events */\\n                    var w = window,\\n                        D = w.DARLA,\\n                        C = w.DARLA_CONFIG,\\n                        DM = w.DOC_DOMAIN_SET || 0;\\n                    if (D) {\\n                        if (D && C) {\\n                            C.dm = DM;\\n                            /*D.config(C);*/\\n                        }\\n                        \\n                        _prepareNodes();\\n                        \\n                        /* setting DARLA configuration */\\n                        DARLA.config(C);\\n\\n                        /* rendering prefetched Ad */\\n                        DARLA.render();  \\n                    }\\n\\n                    return {\\n                        event: function (eventId, spaceId, adsSa) {\\n                            if (window.DARLA && eventId) {\\n                                _prepareNodes();\\n                                var eventConfig = {};\\n                                if (!isNaN(spaceId)) {\\n                                    eventConfig.sp = spaceId;\\n                                }\\n                                /* Site attributes */\\n                                adsSa = (typeof adsSa !== \\\"undefined\\\" && adsSa !== null) ? adsSa : \\\"\\\";\\n                                eventConfig.sa = DARLA_CONFIG.events[eventId].sa_orig.replace ? DARLA_CONFIG.events[eventId].sa_orig.replace(\\\"ADSSA\\\", adsSa) : \\\"\\\";\\n                                DARLA.event(eventId, eventConfig);\\n                            }\\n                        }\\n                    };\\n\\n                })(); /* End of YUI.AdsDarla */\\n\\n                    YUI.AdsDarla.mediaadsdarla = { fetch: (Y.bind(YUI.AdsDarla.event, YUI.AdsDarla, 'mediaadsdarla')) };                    YUI.AdsDarla.fetch = YUI.AdsDarla.mediaadsdarla.fetch;   \\n                    Y.Global.fire('darla:ready'); \\n\\n             }); /* End of YMedia */\\n             \\n        }); /* End of YMedia.later */\\n        \\n          }; /* End of GrandSlam Onload */\\n  if(window.addEventListener)window.addEventListener('load',loadAdsAfterOnLoad,0);\\n  else if(window.attachEvent)window.attachEvent('onload',loadAdsAfterOnLoad);\\n          \\u003C/script\\u003E\\n\\u003Cscript\\u003E(function(){ var wrap = document.getElementById(\\\"yom-ad-SDARLAEXTRA\\\"); if (null == wrap) { wrap = document.getElementById(\\\"yom-ad-SDARLAEXTRA-iframe\\\") || {}; } var content = wrap.innerHTML || \\\"\\\"; if (content && content.substr(0, content.lastIndexOf(\\\"\\u003Cscript\\u003E\\\")).indexOf(\\\"loc=SDARLAEXTRA noad\\\") !== -1) { wrap.style.display = \\\"none\\\"; } }())\\u003C/script\\u003E\\u003C/center\\u003E\\u003C/div\\u003E\\u003C/center\\u003E\\u003C/div\\u003E\\n    \\u003C/body\\u003E\\n\\u003C/html\\u003E\\n\\n\\u003C!-- fe803.global.media.bf1.yahoo.com uncompressed/chunked Wed Jul 10 18:38:31 UTC 2013 --\\u003E\\n\\u003C!-- ncache4.global.media.bf1.yahoo.com compressed/chunked Wed Jul 10 18:38:31 UTC 2013 --\\u003E\\n\\u003C!-- ad prefetch pagecsc setting --\\u003E\"});\n\n    \n        try {\n    ((JSBNG_Record.scriptLoad)((\"var t_headstart = new Date().getTime();\"), (\"sf65c5bea48cdd55711164b14850e99a45658292e\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    var t_headstart = (((JSBNG_Record.get)(new JSBNG__Date(), (\"getTime\")))[(\"getTime\")])();\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};\n        \n\tYahoo! News - Latest News & Headlines\n\t\n\t\n\t\n\t\n\t\n\t\n\t\n\t\n\t\n\t\n\t\n\t\n\t\n\t\n\t\n\t\n\t\n\t\n\t\n\t\n        \n        \n        \n        \n\n\n\n\n\n\n\n\n\ntry {\n    ((JSBNG_Record.scriptLoad)((\"if (!window.YAHOO) {\\u000a    window.YAHOO = {\\u000a    };\\u000a}\\u000a;\\u000aif (!YAHOO.Media) {\\u000a    YAHOO.Media = {\\u000a    };\\u000a}\\u000a;\\u000aif (!YAHOO.widget) {\\u000a    YAHOO.widget = {\\u000a    };\\u000a}\\u000a;\"), (\"sc35bd7311d4e7278da7fca7cf652c055168acfb2\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    if (!(((JSBNG_Record.get)(window, (\"YAHOO\")))[(\"YAHOO\")])) {\n        ((JSBNG_Record.set)(window, (\"YAHOO\"), {\n        }));\n    }\n;\n    if (!(((JSBNG_Record.get)(YAHOO, (\"Media\")))[(\"Media\")])) {\n        ((JSBNG_Record.set)(YAHOO, (\"Media\"), {\n        }));\n    }\n;\n    if (!(((JSBNG_Record.get)(YAHOO, (\"widget\")))[(\"widget\")])) {\n        ((JSBNG_Record.set)(YAHOO, (\"widget\"), {\n        }));\n    }\n;\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};\ntry {\n    ((JSBNG_Record.scriptLoad)((\"if (!window.YMedia) {\\u000a    var YMedia = YUI();\\u000a    YMedia.includes = [];\\u000a}\\u000a;\"), (\"s28a4d1f9ad0fa750de8d6a05f854caf54e0c247e\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    if (!(((JSBNG_Record.get)(window, (\"YMedia\")))[(\"YMedia\")])) {\n        var YMedia = YUI();\n        ((JSBNG_Record.set)(YMedia, (\"includes\"), []));\n    }\n;\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};\ntry {\n    ((JSBNG_Record.scriptLoad)((\"window.YMEDIA_REQ_ATTR = {\\u000a    device: {\\u000a        os: \\\"mac os x\\\",\\u000a        osver: \\\"10.8\\\"\\u000a    },\\u000a    instr: {\\u000a        request_id: \\\"20beee72-ba7b-48ae-b47d-afd6a8b221f3\\\",\\u000a        authfb: 0\\u000a    },\\u000a    csbeacon: function() {\\u000a        if (!this._hasIssuedCsBeacon) {\\u000a            this._hasIssuedCsBeacon = true;\\u000a            if ((((typeof YAHOO === \\\"object\\\") && (typeof YAHOO.i13n === \\\"object\\\")) && (typeof YAHOO.i13n.sendComscoreEvent === \\\"function\\\"))) {\\u000a                if (YAHOO.i13n.setEga) {\\u000a                    YAHOO.i13n.setEga(\\\"\\\");\\u000a                }\\u000a            ;\\u000a                if (YAHOO.i13n.setRdg) {\\u000a                    YAHOO.i13n.setRdg(\\\"-1\\\");\\u000a                }\\u000a            ;\\u000a                if (YAHOO.i13n.setSpaceid) {\\u000a                    YAHOO.i13n.setSpaceid(81121452);\\u000a                }\\u000a            ;\\u000a                YAHOO.i13n.sendComscoreEvent();\\u000a            }\\u000a        ;\\u000a        }\\u000a    ;\\u000a    },\\u000a    _hasIssuedCsBeacon: false\\u000a};\"), (\"s0394e948ad80fc39ec2452893075ea547869dac6\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    ((JSBNG_Record.set)(window, (\"YMEDIA_REQ_ATTR\"), {\n        device: {\n            os: \"mac os x\",\n            osver: \"10.8\"\n        },\n        instr: {\n            request_id: \"20beee72-ba7b-48ae-b47d-afd6a8b221f3\",\n            authfb: 0\n        },\n        csbeacon: ((function() {\n            var s0394e948ad80fc39ec2452893075ea547869dac6_0_instance;\n            ((s0394e948ad80fc39ec2452893075ea547869dac6_0_instance) = ((JSBNG_Record.eventInstance)((\"s0394e948ad80fc39ec2452893075ea547869dac6_0\"))));\n            return ((JSBNG_Record.markFunction)((function() {\n                if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                    return ((JSBNG_Record.eventCall)((arguments.callee), (\"s0394e948ad80fc39ec2452893075ea547869dac6_0\"), (s0394e948ad80fc39ec2452893075ea547869dac6_0_instance), (this), (arguments)))\n                };\n                (null);\n                if (!(((JSBNG_Record.get)(this, (\"_hasIssuedCsBeacon\")))[(\"_hasIssuedCsBeacon\")])) {\n                    ((JSBNG_Record.set)(this, (\"_hasIssuedCsBeacon\"), true));\n                    if ((((typeof YAHOO === \"object\") && (typeof (((JSBNG_Record.get)(YAHOO, (\"i13n\")))[(\"i13n\")]) === \"object\")) && (typeof (((JSBNG_Record.get)((((JSBNG_Record.get)(YAHOO, (\"i13n\")))[(\"i13n\")]), (\"sendComscoreEvent\")))[(\"sendComscoreEvent\")]) === \"function\"))) {\n                        if ((((JSBNG_Record.get)((((JSBNG_Record.get)(YAHOO, (\"i13n\")))[(\"i13n\")]), (\"setEga\")))[(\"setEga\")])) {\n                            (((JSBNG_Record.get)((((JSBNG_Record.get)(YAHOO, (\"i13n\")))[(\"i13n\")]), (\"setEga\")))[(\"setEga\")])(\"\");\n                        }\n                    ;\n                        if ((((JSBNG_Record.get)((((JSBNG_Record.get)(YAHOO, (\"i13n\")))[(\"i13n\")]), (\"setRdg\")))[(\"setRdg\")])) {\n                            (((JSBNG_Record.get)((((JSBNG_Record.get)(YAHOO, (\"i13n\")))[(\"i13n\")]), (\"setRdg\")))[(\"setRdg\")])(\"-1\");\n                        }\n                    ;\n                        if ((((JSBNG_Record.get)((((JSBNG_Record.get)(YAHOO, (\"i13n\")))[(\"i13n\")]), (\"setSpaceid\")))[(\"setSpaceid\")])) {\n                            (((JSBNG_Record.get)((((JSBNG_Record.get)(YAHOO, (\"i13n\")))[(\"i13n\")]), (\"setSpaceid\")))[(\"setSpaceid\")])(81121452);\n                        }\n                    ;\n                        (((JSBNG_Record.get)((((JSBNG_Record.get)(YAHOO, (\"i13n\")))[(\"i13n\")]), (\"sendComscoreEvent\")))[(\"sendComscoreEvent\")])();\n                    }\n                ;\n                }\n                ;\n            })));\n        })()),\n        _hasIssuedCsBeacon: false\n    }));\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};<div><img src=\"http://b.scorecardresearch.com/b?c1=2&c2=7241469&c7=news.yahoo.com%2F&c5=81121452&c15=$-1&cv=2.0&cj=1\" style=\"display:none\" width=\"0\" height=\"0\" alt=\"\" /></div>try {\n    ((JSBNG_Record.scriptLoad)((\"window.YMEDIA_CRUMB = \\\"XiIAUj5vwDC\\\";\"), (\"s5932dd75a3f72fdc07932d5053ef6d901173fa6f\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    ((JSBNG_Record.set)(window, (\"YMEDIA_CRUMB\"), \"XiIAUj5vwDC\"));\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};\n\ntry {\n    ((JSBNG_Record.scriptLoad)((\"YUI.Env.add(window, \\\"unload\\\", function() {\\u000a    try {\\u000a        YMEDIA_REQ_ATTR.csbeacon();\\u000a    } catch (e) {\\u000a    \\u000a    };\\u000a});\"), (\"s9840219b8a67b41faa089cd0ad1fad465972c548\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    (((JSBNG_Record.get)((((JSBNG_Record.get)(YUI, (\"Env\")))[(\"Env\")]), (\"add\")))[(\"add\")])(window, \"unload\", ((function() {\n        var s9840219b8a67b41faa089cd0ad1fad465972c548_0_instance;\n        ((s9840219b8a67b41faa089cd0ad1fad465972c548_0_instance) = ((JSBNG_Record.eventInstance)((\"s9840219b8a67b41faa089cd0ad1fad465972c548_0\"))));\n        return ((JSBNG_Record.markFunction)((function() {\n            if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                return ((JSBNG_Record.eventCall)((arguments.callee), (\"s9840219b8a67b41faa089cd0ad1fad465972c548_0\"), (s9840219b8a67b41faa089cd0ad1fad465972c548_0_instance), (this), (arguments)))\n            };\n            (null);\n            try {\n                (((JSBNG_Record.get)(YMEDIA_REQ_ATTR, (\"csbeacon\")))[(\"csbeacon\")])();\n            } catch (e) {\n            \n            };\n        })));\n    })()));\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};\ntry {\n    ((JSBNG_Record.scriptLoad)((\"window.YAHOO = (window.YAHOO || {\\u000a});\\u000awindow.YAHOO.i13n = (window.YAHOO.i13n || {\\u000a});\\u000aYAHOO.i13n.YWA_CF_MAP = {\\u000a    ad: 58,\\u000a    authfb: 11,\\u000a    bpos: 24,\\u000a    cat: 25,\\u000a    cpos: 21,\\u000a    ct: 23,\\u000a    ft: 51,\\u000a    ltxt: 17,\\u000a    mrkt: 12,\\u000a    pct: 48,\\u000a    pd: 46,\\u000a    pkgt: 22,\\u000a    pos: 20,\\u000a    pstcat: 47,\\u000a    pt: 13,\\u000a    sca: 53,\\u000a    sec: 18,\\u000a    site: 42,\\u000a    slk: 19,\\u000a    sort: 28,\\u000a    test: 14,\\u000a    v: 52,\\u000a    ver: 49,\\u000a    x: 50\\u000a};\\u000aYAHOO.i13n.YWA_ACTION_MAP = {\\u000a    click: 12,\\u000a    detecthpset: 10,\\u000a    expand: 9,\\u000a    hover: 17,\\u000a    hswipe: 19,\\u000a    key: 13,\\u000a    scrolldown: 16,\\u000a    scrollup: 15,\\u000a    secview: 18,\\u000a    shrink: 11,\\u000a    svct: 14\\u000a};\\u000aYAHOO.i13n.YWA_OUTCOME_MAP = {\\u000a    abuse: 51,\\u000a    authview: 48,\\u000a    close: 34,\\u000a    comment: 49,\\u000a    connect: 36,\\u000a    cueauthview: 43,\\u000a    cueconnectview: 46,\\u000a    cuehpset: 50,\\u000a    cueinfoview: 45,\\u000a    cueloadview: 44,\\u000a    cueswipeview: 42,\\u000a    cuetop: 48,\\u000a    drag: 21,\\u000a    drop: 22,\\u000a    end: 31,\\u000a    entitydeclaration: 40,\\u000a    feedback: 37,\\u000a    fetch: 30,\\u000a    filter: 35,\\u000a    hpset: 27,\\u000a    insert: 28,\\u000a    interest: 51,\\u000a    itemdeclaration: 37,\\u000a    loadview: 49,\\u000a    login: 33,\\u000a    msgview: 47,\\u000a    navigate: 25,\\u000a    newview: 50,\\u000a    open: 29,\\u000a    reauthfb: 24,\\u000a    rmct: 32,\\u000a    setlayout: 38,\\u000a    share: 23,\\u000a    sort: 39,\\u000a    top: 26,\\u000a    undo: 41,\\u000a    vswipe: 20\\u000a};\\u000aYMedia.rapid = {\\u000a    rapidConfig: {\\u000a        spaceid: \\\"81121452\\\",\\u000a        tracked_mods: [\\\"mediacontentnavigation\\\",\\\"mediamoduletieheader\\\",\\\"mediacontentlead\\\",\\\"p_30345786\\\",\\\"mediaadsdmros\\\",\\\"mediacontentgenericlistings\\\",\\\"mediafooterinfo\\\",],\\u000a        text_link_len: 8,\\u000a        client_only: 1,\\u000a        compr_type: \\\"deflate\\\",\\u000a        ult_token_capture: true,\\u000a        webworker_file: \\\"/rapid-worker.js\\\",\\u000a        test_id: null,\\u000a        keys: {\\u000a            x: \\\"114\\\",\\u000a            juris: \\\"US\\\",\\u000a            lang: \\\"en-US\\\",\\u000a            mrkt: \\\"US\\\",\\u000a            pcp: \\\"\\\",\\u000a            pct: \\\"\\\",\\u000a            pd: \\\"\\\",\\u000a            pst: \\\"\\\",\\u000a            pstaid: \\\"5f01278b-803a-3803-9798-7fc79bab4f7d\\\",\\u000a            pstcat: \\\"news\\\",\\u000a            pt: \\\"2\\\",\\u000a            site: \\\"news\\\",\\u000a            test: \\\"\\\",\\u000a            ver: \\\"grandslam\\\"\\u000a        },\\u000a        ywa: {\\u000a            project_id: \\\"10001393120079\\\",\\u000a            document_group: \\\"\\\",\\u000a            document_name: \\\"\\\",\\u000a            host: \\\"y3.analytics.yahoo.com\\\"\\u000a        },\\u000a        nofollow_class: [\\\"rapid-nf\\\",\\\"rapidnofollow\\\",\\\"yom-mod\\\",\\\"yog-nw\\\",\\\"yom-hero\\\",\\\"yom-tiles\\\",\\\"yom-menu\\\",\\\"yom-nav-tablet\\\",\\\"yom-card-main\\\",\\\"yom-lightbox\\\",\\\"yom-card-related\\\",\\\"yom-nlist\\\",\\\"yom-nlist-scroll\\\",\\\"yom-header\\\",]\\u000a    },\\u000a    rapidInstance: null,\\u000a    moduleQueue: [],\\u000a    addModules: function(modInfo) {\\u000a        this.moduleQueue.push(modInfo);\\u000a    }\\u000a};\"), (\"s11eeb8209958de2b3a41d7e5087584dedeb2f518\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    ((JSBNG_Record.set)(window, (\"YAHOO\"), ((((JSBNG_Record.get)(window, (\"YAHOO\")))[(\"YAHOO\")]) || {\n    })));\n    ((JSBNG_Record.set)((((JSBNG_Record.get)(window, (\"YAHOO\")))[(\"YAHOO\")]), (\"i13n\"), ((((JSBNG_Record.get)((((JSBNG_Record.get)(window, (\"YAHOO\")))[(\"YAHOO\")]), (\"i13n\")))[(\"i13n\")]) || {\n    })));\n    ((JSBNG_Record.set)((((JSBNG_Record.get)(YAHOO, (\"i13n\")))[(\"i13n\")]), (\"YWA_CF_MAP\"), {\n        ad: 58,\n        authfb: 11,\n        bpos: 24,\n        cat: 25,\n        cpos: 21,\n        ct: 23,\n        ft: 51,\n        ltxt: 17,\n        mrkt: 12,\n        pct: 48,\n        pd: 46,\n        pkgt: 22,\n        pos: 20,\n        pstcat: 47,\n        pt: 13,\n        sca: 53,\n        sec: 18,\n        site: 42,\n        slk: 19,\n        sort: 28,\n        test: 14,\n        v: 52,\n        ver: 49,\n        x: 50\n    }));\n    ((JSBNG_Record.set)((((JSBNG_Record.get)(YAHOO, (\"i13n\")))[(\"i13n\")]), (\"YWA_ACTION_MAP\"), {\n        click: 12,\n        detecthpset: 10,\n        expand: 9,\n        hover: 17,\n        hswipe: 19,\n        key: 13,\n        scrolldown: 16,\n        scrollup: 15,\n        secview: 18,\n        shrink: 11,\n        svct: 14\n    }));\n    ((JSBNG_Record.set)((((JSBNG_Record.get)(YAHOO, (\"i13n\")))[(\"i13n\")]), (\"YWA_OUTCOME_MAP\"), {\n        abuse: 51,\n        authview: 48,\n        close: 34,\n        comment: 49,\n        connect: 36,\n        cueauthview: 43,\n        cueconnectview: 46,\n        cuehpset: 50,\n        cueinfoview: 45,\n        cueloadview: 44,\n        cueswipeview: 42,\n        cuetop: 48,\n        drag: 21,\n        drop: 22,\n        end: 31,\n        entitydeclaration: 40,\n        feedback: 37,\n        fetch: 30,\n        filter: 35,\n        hpset: 27,\n        insert: 28,\n        interest: 51,\n        itemdeclaration: 37,\n        loadview: 49,\n        login: 33,\n        msgview: 47,\n        JSBNG__navigate: 25,\n        newview: 50,\n        open: 29,\n        reauthfb: 24,\n        rmct: 32,\n        setlayout: 38,\n        share: 23,\n        sort: 39,\n        JSBNG__top: 26,\n        undo: 41,\n        vswipe: 20\n    }));\n    ((JSBNG_Record.set)(YMedia, (\"rapid\"), {\n        rapidConfig: {\n            spaceid: \"81121452\",\n            tracked_mods: [\"mediacontentnavigation\",\"mediamoduletieheader\",\"mediacontentlead\",\"p_30345786\",\"mediaadsdmros\",\"mediacontentgenericlistings\",\"mediafooterinfo\",],\n            text_link_len: 8,\n            client_only: 1,\n            compr_type: \"deflate\",\n            ult_token_capture: true,\n            webworker_file: \"/rapid-worker.js\",\n            test_id: null,\n            keys: {\n                x: \"114\",\n                juris: \"US\",\n                lang: \"en-US\",\n                mrkt: \"US\",\n                pcp: \"\",\n                pct: \"\",\n                pd: \"\",\n                pst: \"\",\n                pstaid: \"5f01278b-803a-3803-9798-7fc79bab4f7d\",\n                pstcat: \"news\",\n                pt: \"2\",\n                site: \"news\",\n                test: \"\",\n                ver: \"grandslam\"\n            },\n            ywa: {\n                project_id: \"10001393120079\",\n                document_group: \"\",\n                document_name: \"\",\n                host: \"y3.analytics.yahoo.com\"\n            },\n            nofollow_class: [\"rapid-nf\",\"rapidnofollow\",\"yom-mod\",\"yog-nw\",\"yom-hero\",\"yom-tiles\",\"yom-menu\",\"yom-nav-tablet\",\"yom-card-main\",\"yom-lightbox\",\"yom-card-related\",\"yom-nlist\",\"yom-nlist-scroll\",\"yom-header\",]\n        },\n        rapidInstance: null,\n        moduleQueue: [],\n        addModules: ((function() {\n            var s11eeb8209958de2b3a41d7e5087584dedeb2f518_0_instance;\n            ((s11eeb8209958de2b3a41d7e5087584dedeb2f518_0_instance) = ((JSBNG_Record.eventInstance)((\"s11eeb8209958de2b3a41d7e5087584dedeb2f518_0\"))));\n            return ((JSBNG_Record.markFunction)((function(modInfo) {\n                if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                    return ((JSBNG_Record.eventCall)((arguments.callee), (\"s11eeb8209958de2b3a41d7e5087584dedeb2f518_0\"), (s11eeb8209958de2b3a41d7e5087584dedeb2f518_0_instance), (this), (arguments)))\n                };\n                (null);\n                (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"moduleQueue\")))[(\"moduleQueue\")]), (\"push\")))[(\"push\")])(modInfo);\n            })));\n        })())\n    }));\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};\n\n\t\ttry {\n    ((JSBNG_Record.scriptLoad)((\"YUI.YUICfg = {\\u000a    gallery: \\\"gallery-2011.04.20-13-04\\\",\\u000a    groups: {\\u000a        group01c9d8dea06e05460a64eed4dadd622b6: {\\u000a            base: \\\"http://l.yimg.com/\\\",\\u000a            comboBase: \\\"http://l.yimg.com/zz/combo?\\\",\\u000a            modules: {\\u000a                \\\"media-v2-chrome\\\": {\\u000a                    path: \\\"os/mit/media/p/presentation/v2-chrome-min-1335634.js\\\"\\u000a                },\\u000a                \\\"media-tracking\\\": {\\u000a                    path: \\\"os/mit/media/m/base/tracking-min-1154405.js\\\"\\u000a                },\\u000a                \\\"media-imageloader\\\": {\\u000a                    path: \\\"os/mit/media/m/base/imageloader-min-1277138.js\\\"\\u000a                },\\u000a                \\\"media-imageloader-bootstrap\\\": {\\u000a                    path: \\\"os/mit/media/m/base/imageloader-bootstrap-min-815727.js\\\"\\u000a                },\\u000a                \\\"media-rapid-tracking\\\": {\\u000a                    path: \\\"os/mit/media/p/common/rapid-tracking-min-1330602.js\\\"\\u000a                },\\u000a                \\\"media-header-uh3-desktop\\\": {\\u000a                    path: \\\"os/mit/media/m/header/header-uh3-desktop-min-1322619.js\\\"\\u000a                }\\u000a            },\\u000a            combine: true,\\u000a            filter: \\\"min\\\",\\u000a            root: \\\"/\\\"\\u000a        }\\u000a    },\\u000a    combine: true,\\u000a    allowRollup: true,\\u000a    comboBase: \\\"http://l.yimg.com/zz/combo?\\\",\\u000a    maxURLLength: \\\"2000\\\"\\u000a};\\u000aYUI.YUICfg.root = ((\\\"yui:\\\" + YUI.version) + \\\"/build/\\\");\\u000aYMedia.applyConfig(YUI.YUICfg);\\u000aYUI.Env[YUI.version].groups.gallery.root = \\\"yui:gallery-2011.04.20-13-04/build/\\\";\\u000aYMedia.use(\\\"media-rmp\\\", \\\"media-viewport-loader\\\", \\\"media-v2-chrome\\\", \\\"media-tracking\\\", \\\"node-base\\\", \\\"event-custom\\\", \\\"dom-deprecated\\\", \\\"node-deprecated\\\", \\\"substitute\\\", \\\"media-imageloader\\\", \\\"media-imageloader-bootstrap\\\", \\\"base-base\\\", \\\"node-style\\\", \\\"node-screen\\\", \\\"media-rapid-tracking\\\", \\\"base\\\", \\\"node\\\", \\\"media-header-uh3-desktop\\\", \\\"intl\\\", function(Y) {\\u000a    Y.later(10, this, function() {\\u000a        Y.applyConfig({\\u000a            debug: false\\u000a        });\\u000a    });\\u000a    Y.later(10, this, function() {\\u000a        YUI.namespace(\\\"Media\\\").LANGDIR = \\\"ltr\\\";\\u000a        YUI.namespace(\\\"Media\\\").CONTENT_ID = \\\"5f01278b-803a-3803-9798-7fc79bab4f7d\\\";\\u000a    });\\u000a    Y.later(10, this, function() {\\u000a        if ((Y.Media && Y.Media.Chrome)) {\\u000a            Y.Media.pageChrome = Y.Media.Chrome(Y, {\\u000a                site: \\\"news\\\",\\u000a                lang: \\\"en-US\\\",\\u000a                region: \\\"US\\\",\\u000a                spaceId: \\\"81121452\\\",\\u000a                contentId: \\\"5f01278b-803a-3803-9798-7fc79bab4f7d\\\",\\u000a                gridType: \\\"index\\\",\\u000a                device: \\\"full\\\",\\u000a                deviceOS: ((((YMEDIA_REQ_ATTR && YMEDIA_REQ_ATTR.device) && YMEDIA_REQ_ATTR.device.os)) || \\\"\\\"),\\u000a                deviceOSVer: ((((YMEDIA_REQ_ATTR && YMEDIA_REQ_ATTR.device) && YMEDIA_REQ_ATTR.device.osver)) || \\\"\\\"),\\u000a                projectId: \\\"10001393120079\\\",\\u000a                enableYwaTracking: \\\"0\\\",\\u000a                enable2xImgs: \\\"0\\\",\\u000a                imgItemsSelector: \\\".js .yog-bd img\\\",\\u000a                enableViewportManagement: \\\"0\\\",\\u000a                viewportItemsSelector: \\\".js .yog-content img,.yog-smartphone.js .yog-bd img\\\",\\u000a                transparentImgUrl: \\\"http://l.yimg.com/os/mit/media/m/base/images/transparent-1093278.png\\\",\\u000a                enableRapidTracking: 1,\\u000a                rapidConf: {\\u000a                    spaceid: \\\"81121452\\\",\\u000a                    tracked_mods: [\\\"mediacontentnavigation\\\",\\\"mediamoduletieheader\\\",\\\"mediacontentlead\\\",\\\"p_30345786\\\",\\\"mediaadsdmros\\\",\\\"mediacontentgenericlistings\\\",\\\"mediafooterinfo\\\",],\\u000a                    text_link_len: 8,\\u000a                    client_only: 1,\\u000a                    compr_type: \\\"deflate\\\",\\u000a                    ult_token_capture: true,\\u000a                    webworker_file: \\\"/rapid-worker.js\\\",\\u000a                    test_id: null,\\u000a                    keys: {\\u000a                        x: \\\"114\\\",\\u000a                        juris: \\\"US\\\",\\u000a                        lang: \\\"en-US\\\",\\u000a                        mrkt: \\\"US\\\",\\u000a                        pcp: \\\"\\\",\\u000a                        pct: \\\"\\\",\\u000a                        pd: \\\"\\\",\\u000a                        pst: \\\"\\\",\\u000a                        pstaid: \\\"5f01278b-803a-3803-9798-7fc79bab4f7d\\\",\\u000a                        pstcat: \\\"news\\\",\\u000a                        pt: \\\"2\\\",\\u000a                        site: \\\"news\\\",\\u000a                        test: \\\"\\\",\\u000a                        ver: \\\"grandslam\\\"\\u000a                    },\\u000a                    ywa: {\\u000a                        project_id: \\\"10001393120079\\\",\\u000a                        document_group: \\\"\\\",\\u000a                        document_name: \\\"\\\",\\u000a                        host: \\\"y3.analytics.yahoo.com\\\"\\u000a                    },\\u000a                    nofollow_class: [\\\"rapid-nf\\\",\\\"rapidnofollow\\\",\\\"yom-mod\\\",\\\"yog-nw\\\",\\\"yom-hero\\\",\\\"yom-tiles\\\",\\\"yom-menu\\\",\\\"yom-nav-tablet\\\",\\\"yom-card-main\\\",\\\"yom-lightbox\\\",\\\"yom-card-related\\\",\\\"yom-nlist\\\",\\\"yom-nlist-scroll\\\",\\\"yom-header\\\",]\\u000a                },\\u000a                bucketId: \\\"\\\",\\u000a                baseImageryFallbackCss: \\\"http://l.yimg.com/os/mit/media/themes/v2_base/base-imagery-fallback-min-1313085.css\\\",\\u000a                baseImageryFallbackCssLteIe7: \\\"http://l.yimg.com/os/mit/media/themes/v2_base/base-imagery-fallback-lteIE7-min-1313085.css\\\"\\u000a            });\\u000a        }\\u000a    ;\\u000a    ;\\u000a    });\\u000a    Y.later(10, this, function() {\\u000a        Y.on(\\\"domready\\\", function() {\\u000a            DOMIMG = new Image();\\u000a            DOMIMG.src = (\\\"http://geo.yahoo.com/p?s=81121452&pt=2&test=nacelle&btype=dom&t=\\\" + Math.random());\\u000a        });\\u000a    });\\u000a    Y.later(10, this, function() {\\u000a        Y.namespace(\\\"Global.Media\\\").ILBoot = new Y.ImageLoaderBootstrap(200);\\u000a    });\\u000a    Y.later(10, this, function() {\\u000a        YMedia.rapid = new Y.Media.RapidTracking({\\u000a            instance: (YMedia.rapid && YMedia.rapid.rapidInstance),\\u000a            moduleQueue: (YMedia.rapid && YMedia.rapid.moduleQueue),\\u000a            rapidConfig: (YMedia.rapid && YMedia.rapid.rapidConfig),\\u000a            config: {\\u000a                selectors: {\\u000a                    bd: \\\"#yog-bd\\\",\\u000a                    mods: \\\".yom-mod\\\"\\u000a                }\\u000a            }\\u000a        });\\u000a    });\\u000a    Y.later(10, this, function() {\\u000a        if (Y.Media.HeaderUH3) {\\u000a            Y.Media.HeaderUH3(Y);\\u000a        };\\u000a    });\\u000a});\"), (\"sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    ((JSBNG_Record.set)(YUI, (\"YUICfg\"), {\n        gallery: \"gallery-2011.04.20-13-04\",\n        groups: {\n            group01c9d8dea06e05460a64eed4dadd622b6: {\n                base: \"http://l.yimg.com/\",\n                comboBase: \"http://l.yimg.com/zz/combo?\",\n                modules: {\n                    \"media-v2-chrome\": {\n                        path: \"os/mit/media/p/presentation/v2-chrome-min-1335634.js\"\n                    },\n                    \"media-tracking\": {\n                        path: \"os/mit/media/m/base/tracking-min-1154405.js\"\n                    },\n                    \"media-imageloader\": {\n                        path: \"os/mit/media/m/base/imageloader-min-1277138.js\"\n                    },\n                    \"media-imageloader-bootstrap\": {\n                        path: \"os/mit/media/m/base/imageloader-bootstrap-min-815727.js\"\n                    },\n                    \"media-rapid-tracking\": {\n                        path: \"os/mit/media/p/common/rapid-tracking-min-1330602.js\"\n                    },\n                    \"media-header-uh3-desktop\": {\n                        path: \"os/mit/media/m/header/header-uh3-desktop-min-1322619.js\"\n                    }\n                },\n                combine: true,\n                filter: \"min\",\n                root: \"/\"\n            }\n        },\n        combine: true,\n        allowRollup: true,\n        comboBase: \"http://l.yimg.com/zz/combo?\",\n        maxURLLength: \"2000\"\n    }));\n    ((JSBNG_Record.set)((((JSBNG_Record.get)(YUI, (\"YUICfg\")))[(\"YUICfg\")]), (\"root\"), ((\"yui:\" + (((JSBNG_Record.get)(YUI, (\"version\")))[(\"version\")])) + \"/build/\")));\n    (((JSBNG_Record.get)(YMedia, (\"applyConfig\")))[(\"applyConfig\")])((((JSBNG_Record.get)(YUI, (\"YUICfg\")))[(\"YUICfg\")]));\n    ((JSBNG_Record.set)((((JSBNG_Record.get)((((JSBNG_Record.get)((((JSBNG_Record.get)((((JSBNG_Record.get)(YUI, (\"Env\")))[(\"Env\")]), ((JSBNG_Record.temps.t4150eaf525f06880b03af164a8f137ea7416ee1b) = (((JSBNG_Record.get)(YUI, (\"version\")))[(\"version\")]))))[(JSBNG_Record.temps.t4150eaf525f06880b03af164a8f137ea7416ee1b)]), (\"groups\")))[(\"groups\")]), (\"gallery\")))[(\"gallery\")]), (\"root\"), \"yui:gallery-2011.04.20-13-04/build/\"));\n    (((JSBNG_Record.get)(YMedia, (\"use\")))[(\"use\")])(\"media-rmp\", \"media-viewport-loader\", \"media-v2-chrome\", \"media-tracking\", \"node-base\", \"event-custom\", \"dom-deprecated\", \"node-deprecated\", \"substitute\", \"media-imageloader\", \"media-imageloader-bootstrap\", \"base-base\", \"node-style\", \"node-screen\", \"media-rapid-tracking\", \"base\", \"node\", \"media-header-uh3-desktop\", \"intl\", ((function() {\n        var sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_0_instance;\n        ((sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_0_instance) = ((JSBNG_Record.eventInstance)((\"sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_0\"))));\n        return ((JSBNG_Record.markFunction)((function(Y) {\n            if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                return ((JSBNG_Record.eventCall)((arguments.callee), (\"sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_0\"), (sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_0_instance), (this), (arguments)))\n            };\n            (null);\n            (((JSBNG_Record.get)(Y, (\"later\")))[(\"later\")])(10, this, ((function() {\n                var sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_1_instance;\n                ((sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_1_instance) = ((JSBNG_Record.eventInstance)((\"sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_1\"))));\n                return ((JSBNG_Record.markFunction)((function() {\n                    if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                        return ((JSBNG_Record.eventCall)((arguments.callee), (\"sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_1\"), (sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_1_instance), (this), (arguments)))\n                    };\n                    (null);\n                    (((JSBNG_Record.get)(Y, (\"applyConfig\")))[(\"applyConfig\")])({\n                        debug: false\n                    });\n                })));\n            })()));\n            (((JSBNG_Record.get)(Y, (\"later\")))[(\"later\")])(10, this, ((function() {\n                var sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_2_instance;\n                ((sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_2_instance) = ((JSBNG_Record.eventInstance)((\"sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_2\"))));\n                return ((JSBNG_Record.markFunction)((function() {\n                    if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                        return ((JSBNG_Record.eventCall)((arguments.callee), (\"sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_2\"), (sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_2_instance), (this), (arguments)))\n                    };\n                    (null);\n                    ((JSBNG_Record.set)((((JSBNG_Record.get)(YUI, (\"namespace\")))[(\"namespace\")])(\"Media\"), (\"LANGDIR\"), \"ltr\"));\n                    ((JSBNG_Record.set)((((JSBNG_Record.get)(YUI, (\"namespace\")))[(\"namespace\")])(\"Media\"), (\"CONTENT_ID\"), \"5f01278b-803a-3803-9798-7fc79bab4f7d\"));\n                })));\n            })()));\n            (((JSBNG_Record.get)(Y, (\"later\")))[(\"later\")])(10, this, ((function() {\n                var sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_3_instance;\n                ((sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_3_instance) = ((JSBNG_Record.eventInstance)((\"sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_3\"))));\n                return ((JSBNG_Record.markFunction)((function() {\n                    if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                        return ((JSBNG_Record.eventCall)((arguments.callee), (\"sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_3\"), (sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_3_instance), (this), (arguments)))\n                    };\n                    (null);\n                    if (((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]) && (((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"Chrome\")))[(\"Chrome\")]))) {\n                        ((JSBNG_Record.set)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"pageChrome\"), (((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"Chrome\")))[(\"Chrome\")])(Y, {\n                            site: \"news\",\n                            lang: \"en-US\",\n                            region: \"US\",\n                            spaceId: \"81121452\",\n                            contentId: \"5f01278b-803a-3803-9798-7fc79bab4f7d\",\n                            gridType: \"index\",\n                            device: \"full\",\n                            deviceOS: ((((YMEDIA_REQ_ATTR && (((JSBNG_Record.get)(YMEDIA_REQ_ATTR, (\"device\")))[(\"device\")])) && (((JSBNG_Record.get)((((JSBNG_Record.get)(YMEDIA_REQ_ATTR, (\"device\")))[(\"device\")]), (\"os\")))[(\"os\")]))) || \"\"),\n                            deviceOSVer: ((((YMEDIA_REQ_ATTR && (((JSBNG_Record.get)(YMEDIA_REQ_ATTR, (\"device\")))[(\"device\")])) && (((JSBNG_Record.get)((((JSBNG_Record.get)(YMEDIA_REQ_ATTR, (\"device\")))[(\"device\")]), (\"osver\")))[(\"osver\")]))) || \"\"),\n                            projectId: \"10001393120079\",\n                            enableYwaTracking: \"0\",\n                            enable2xImgs: \"0\",\n                            imgItemsSelector: \".js .yog-bd img\",\n                            enableViewportManagement: \"0\",\n                            viewportItemsSelector: \".js .yog-content img,.yog-smartphone.js .yog-bd img\",\n                            transparentImgUrl: \"http://l.yimg.com/os/mit/media/m/base/images/transparent-1093278.png\",\n                            enableRapidTracking: 1,\n                            rapidConf: {\n                                spaceid: \"81121452\",\n                                tracked_mods: [\"mediacontentnavigation\",\"mediamoduletieheader\",\"mediacontentlead\",\"p_30345786\",\"mediaadsdmros\",\"mediacontentgenericlistings\",\"mediafooterinfo\",],\n                                text_link_len: 8,\n                                client_only: 1,\n                                compr_type: \"deflate\",\n                                ult_token_capture: true,\n                                webworker_file: \"/rapid-worker.js\",\n                                test_id: null,\n                                keys: {\n                                    x: \"114\",\n                                    juris: \"US\",\n                                    lang: \"en-US\",\n                                    mrkt: \"US\",\n                                    pcp: \"\",\n                                    pct: \"\",\n                                    pd: \"\",\n                                    pst: \"\",\n                                    pstaid: \"5f01278b-803a-3803-9798-7fc79bab4f7d\",\n                                    pstcat: \"news\",\n                                    pt: \"2\",\n                                    site: \"news\",\n                                    test: \"\",\n                                    ver: \"grandslam\"\n                                },\n                                ywa: {\n                                    project_id: \"10001393120079\",\n                                    document_group: \"\",\n                                    document_name: \"\",\n                                    host: \"y3.analytics.yahoo.com\"\n                                },\n                                nofollow_class: [\"rapid-nf\",\"rapidnofollow\",\"yom-mod\",\"yog-nw\",\"yom-hero\",\"yom-tiles\",\"yom-menu\",\"yom-nav-tablet\",\"yom-card-main\",\"yom-lightbox\",\"yom-card-related\",\"yom-nlist\",\"yom-nlist-scroll\",\"yom-header\",]\n                            },\n                            bucketId: \"\",\n                            baseImageryFallbackCss: \"http://l.yimg.com/os/mit/media/themes/v2_base/base-imagery-fallback-min-1313085.css\",\n                            baseImageryFallbackCssLteIe7: \"http://l.yimg.com/os/mit/media/themes/v2_base/base-imagery-fallback-lteIE7-min-1313085.css\"\n                        })));\n                    }\n                    ;\n                    ;\n                })));\n            })()));\n            (((JSBNG_Record.get)(Y, (\"later\")))[(\"later\")])(10, this, ((function() {\n                var sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_4_instance;\n                ((sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_4_instance) = ((JSBNG_Record.eventInstance)((\"sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_4\"))));\n                return ((JSBNG_Record.markFunction)((function() {\n                    if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                        return ((JSBNG_Record.eventCall)((arguments.callee), (\"sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_4\"), (sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_4_instance), (this), (arguments)))\n                    };\n                    (null);\n                    (((JSBNG_Record.get)(Y, (\"JSBNG__on\")))[(\"JSBNG__on\")])(\"domready\", ((function() {\n                        var sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_5_instance;\n                        ((sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_5_instance) = ((JSBNG_Record.eventInstance)((\"sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_5\"))));\n                        return ((JSBNG_Record.markFunction)((function() {\n                            if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                                return ((JSBNG_Record.eventCall)((arguments.callee), (\"sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_5\"), (sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_5_instance), (this), (arguments)))\n                            };\n                            (null);\n                            DOMIMG = new JSBNG__Image();\n                            ((JSBNG_Record.set)(DOMIMG, (\"src\"), (\"http://geo.yahoo.com/p?s=81121452&pt=2&test=nacelle&btype=dom&t=\" + (((JSBNG_Record.get)(Math, (\"JSBNG__random\")))[(\"JSBNG__random\")])())));\n                        })));\n                    })()));\n                })));\n            })()));\n            (((JSBNG_Record.get)(Y, (\"later\")))[(\"later\")])(10, this, ((function() {\n                var sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_6_instance;\n                ((sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_6_instance) = ((JSBNG_Record.eventInstance)((\"sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_6\"))));\n                return ((JSBNG_Record.markFunction)((function() {\n                    if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                        return ((JSBNG_Record.eventCall)((arguments.callee), (\"sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_6\"), (sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_6_instance), (this), (arguments)))\n                    };\n                    (null);\n                    ((JSBNG_Record.set)((((JSBNG_Record.get)(Y, (\"namespace\")))[(\"namespace\")])(\"Global.Media\"), (\"ILBoot\"), new (((JSBNG_Record.get)(Y, (\"ImageLoaderBootstrap\")))[(\"ImageLoaderBootstrap\")])(200)));\n                })));\n            })()));\n            (((JSBNG_Record.get)(Y, (\"later\")))[(\"later\")])(10, this, ((function() {\n                var sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_7_instance;\n                ((sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_7_instance) = ((JSBNG_Record.eventInstance)((\"sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_7\"))));\n                return ((JSBNG_Record.markFunction)((function() {\n                    if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                        return ((JSBNG_Record.eventCall)((arguments.callee), (\"sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_7\"), (sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_7_instance), (this), (arguments)))\n                    };\n                    (null);\n                    ((JSBNG_Record.set)(YMedia, (\"rapid\"), new (((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"RapidTracking\")))[(\"RapidTracking\")])({\n                        instance: ((((JSBNG_Record.get)(YMedia, (\"rapid\")))[(\"rapid\")]) && (((JSBNG_Record.get)((((JSBNG_Record.get)(YMedia, (\"rapid\")))[(\"rapid\")]), (\"rapidInstance\")))[(\"rapidInstance\")])),\n                        moduleQueue: ((((JSBNG_Record.get)(YMedia, (\"rapid\")))[(\"rapid\")]) && (((JSBNG_Record.get)((((JSBNG_Record.get)(YMedia, (\"rapid\")))[(\"rapid\")]), (\"moduleQueue\")))[(\"moduleQueue\")])),\n                        rapidConfig: ((((JSBNG_Record.get)(YMedia, (\"rapid\")))[(\"rapid\")]) && (((JSBNG_Record.get)((((JSBNG_Record.get)(YMedia, (\"rapid\")))[(\"rapid\")]), (\"rapidConfig\")))[(\"rapidConfig\")])),\n                        config: {\n                            selectors: {\n                                bd: \"#yog-bd\",\n                                mods: \".yom-mod\"\n                            }\n                        }\n                    })));\n                })));\n            })()));\n            (((JSBNG_Record.get)(Y, (\"later\")))[(\"later\")])(10, this, ((function() {\n                var sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_8_instance;\n                ((sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_8_instance) = ((JSBNG_Record.eventInstance)((\"sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_8\"))));\n                return ((JSBNG_Record.markFunction)((function() {\n                    if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                        return ((JSBNG_Record.eventCall)((arguments.callee), (\"sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_8\"), (sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_8_instance), (this), (arguments)))\n                    };\n                    (null);\n                    if ((((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"HeaderUH3\")))[(\"HeaderUH3\")])) {\n                        (((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"HeaderUH3\")))[(\"HeaderUH3\")])(Y);\n                    };\n                })));\n            })()));\n        })));\n    })()));\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};\n\n        \ntry {\n    ((JSBNG_Record.scriptLoad)((\"if ((typeof rt_pushMoment !== \\\"undefined\\\")) {\\u000a    rt_pushMoment(\\\"t1\\\");\\u000a};\"), (\"sfe2cfa0f38fd04b9ac8c9f59f7cb13d130ecaab4\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    if ((typeof rt_pushMoment !== \"undefined\")) {\n        rt_pushMoment(\"t1\");\n    };\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};\n        try {\n    ((JSBNG_Record.scriptLoad)((\"var t_headend = new Date().getTime();\"), (\"sbecbf625e3c2bd2725c8f1c06278391b42ebb9e2\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    var t_headend = (((JSBNG_Record.get)(new JSBNG__Date(), (\"getTime\")))[(\"getTime\")])();\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};\n    \n    \n        try {\n    ((JSBNG_Record.scriptLoad)((\"document.body.className = document.body.className.replace(\\\"no-js\\\", \\\"js\\\");\\u000adocument.body.offsetHeight;\"), (\"sfd5fc673c8a38b3a7fa34af94c82d8fe6c61a3dc\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    ((JSBNG_Record.set)((((JSBNG_Record.get)(JSBNG__document, (\"body\")))[(\"body\")]), (\"className\"), (((JSBNG_Record.get)((((JSBNG_Record.get)((((JSBNG_Record.get)(JSBNG__document, (\"body\")))[(\"body\")]), (\"className\")))[(\"className\")]), (\"replace\")))[(\"replace\")])(\"no-js\", \"js\")));\n    (((JSBNG_Record.get)((((JSBNG_Record.get)(JSBNG__document, (\"body\")))[(\"body\")]), (\"offsetHeight\")))[(\"offsetHeight\")]);\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};\n        \n            \n                \n                \n\n#header,#yucs,#y-hd,#hd .yfi_doc,#yfi_hd{background:#fff !important}#yog-hd,#yfi-hd,#ysp-hd,#hd,#yfimh,#yfi_hd,#yfi_fp_hd,#masthead,#yfi_nav_header #navigation,#y-nav #navigation,.ad_in_head{background-color:#fff;background-image:none}#header,#hd .yfi_doc,#y-hd .yfi_doc,#yfi_hd .yfi_doc{width:100% !important}#yucs{margin:0 auto;width:970px}#yfi_nav_header,.y-nav-legobg,#y-nav #navigation{margin:0 auto;width:970px}#yucs .yucs-avatar{height:22px;width:22px}#yucs #yucs-profile_text .yuhead-name-greeting{display:none}#yucs #yucs-profile_text .yuhead-name{top:0;max-width:65px}#yucs-profile_text{max-width:65px}#yog-bd .yom-stage{background:transparent}#yog-hd{height:84px}.yog-bd,.yog-grid{padding:4px 10px}#yucs #yucs-search .yucs-button_theme{background:-moz-linear-gradient(top, #26376a 0, #192446 100%);background:-webkit-gradient(linear, left top, left bottom, color-stop(0%, #26376a), color-stop(100%, #192446));background:-webkit-linear-gradient(top, #26376a 0, #192446 100%);background:-o-linear-gradient(top, #26376a 0, #192446 100%);background:-ms-linear-gradient(top, #26376a 0, #192446 100%);background:linear-gradient(to bottom, #26376a 0, #192446 100%);-webkit-box-shadow:inset 0 1px 3px 0 #3f5baf;box-shadow:inset 0 1px 3px 0 #3f5baf;background-color:#2f477a;background-color:transparent\\0/IE9;background-color:transparent\\9;*background:none;border:1px solid #152756}#yucs #yucs-search #yucs-prop_search_button_wrapper .yucs-gradient{filter:progid:DXImageTransform.Microsoft.gradient(startColorstr='#26376a', endColorstr='#192446',GradientType=0 );-ms-filter:\"progid:DXImageTransform.Microsoft.gradient( startColorstr='#26376a', endColorstr='#192446',GradientType=0 )\";background-color:#2f477a\\0/IE9}#yucs #yucs-search #yucs-prop_search_button_wrapper{*border:1px solid #152756}#yog-hd .yom-bar, #yog-hd .yom-nav, #y-nav, #hd .ysp-full-bar,  #yfi_nav_header, #hd .mast {\nfloat: none;\nwidth: 970px;\nmargin: 0 auto;\n}\n\n#yog-bd .yom-stage {\nbackground: transparent;\n}\n\n#y-nav .yom-nav {\npadding-top: 0px;\n}\n\n#ysp-search-assist .bd {\ndisplay:none;\n}\n\n#ysp-search-assist h4 {\npadding-left: 8px;\n}\n\n\n    #yfi-portfolios-multi-quotes #y-nav, #yfi-portfolios-multi-quotes #navigation, #yfi-portfolios-multi-quotes .y-nav-legobg, \n    #yfi-portfolios-my-portfolios #y-nav, #yfi-portfolios-my-portfolios #navigation, #yfi-portfolios-my-portfolios .y-nav-legobg {\n        width : 100%;\n    }                        Home            Mail            News            Sports            Finance            Weather            Games            Groups            Answers            Flickr            More                                                                                        omg!                            Shine                            Movies                            Music                            TV                            Health                            Shopping                            Travel                            Autos                            Homes                                                                                                                        #yucs #yucs-logo {width:123px ;}         #yucs #yucs-logo h2 {            width:123px;            height:36px ;            background-image:url(http://l.yimg.com/rz/uh/logos/news/news-20130429.png) ;            _background-image:url(http://l.yimg.com/rz/uh/logos/news/news-20130429.gif) ;        }        #yucs #yucs-logo a {          display:block ;          width:123px ;          height:36px;          overflow: hidden;        }        @media        only screen and (-webkit-min-device-pixel-ratio: 2),        only screen and ( min--moz-device-pixel-ratio: 2),        only screen and ( -o-min-device-pixel-ratio: 2/1),        only screen and ( min-device-pixel-ratio: 2),        only screen and ( min-resolution: 192dpi),        only screen and ( min-resolution: 2dppx) {            #yucs #yucs-logo h2 {                background-image: url(http://l.yimg.com/rz/uh/logos/news/news-20130429-x2.png) !important;                background-size: 275px 120px;            }        }                          Yahoo! News                                                                                                                        Search NewsSearch Web                                                                              Sign In                  Mail                        Help                                    Account Info            Help                        Suggestions                Yahoo!                        \ntry {\n    ((JSBNG_Record.scriptLoad)((\"YMedia.use(\\\"event\\\", \\\"get\\\", function(Y) {\\u000a    Y.once(\\\"load\\\", function() {\\u000a        Y.Get.js(\\\"http://l.yimg.com/zz/combo?kx/yucs/uh3/uh/js/1/uh-min.js&kx/yucs/uh3/uh/js/102/gallery-jsonp-min.js&kx/yucs/uh3/uh/js/565/menu_utils_v3-min.js&kx/yucs/uh3/uh/js/549/timestamp_library-min.js&kx/yucs/uh3/uh3_top_bar/js/148/top_bar_v3-min.js&kx/yucs/uh3/search/js/361/search-min.js&kx/ucs/common/js/131/jsonp-super-cached-min.js&kx/yucs/uh3/avatar/js/9/avatar-min.js&kx/yucs/uh3/mail_link/js/60/mailcount-min.js&kx/yucs/uh3/help/js/46/help_menu_v3-min.js\\\");\\u000a    });\\u000a});\"), (\"s0b6a75f6fe99368402e19542a48a63d5beec22d2\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    (((JSBNG_Record.get)(YMedia, (\"use\")))[(\"use\")])(\"JSBNG__event\", \"get\", ((function() {\n        var s0b6a75f6fe99368402e19542a48a63d5beec22d2_0_instance;\n        ((s0b6a75f6fe99368402e19542a48a63d5beec22d2_0_instance) = ((JSBNG_Record.eventInstance)((\"s0b6a75f6fe99368402e19542a48a63d5beec22d2_0\"))));\n        return ((JSBNG_Record.markFunction)((function(Y) {\n            if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                return ((JSBNG_Record.eventCall)((arguments.callee), (\"s0b6a75f6fe99368402e19542a48a63d5beec22d2_0\"), (s0b6a75f6fe99368402e19542a48a63d5beec22d2_0_instance), (this), (arguments)))\n            };\n            (null);\n            (((JSBNG_Record.get)(Y, (\"once\")))[(\"once\")])(\"load\", ((function() {\n                var s0b6a75f6fe99368402e19542a48a63d5beec22d2_1_instance;\n                ((s0b6a75f6fe99368402e19542a48a63d5beec22d2_1_instance) = ((JSBNG_Record.eventInstance)((\"s0b6a75f6fe99368402e19542a48a63d5beec22d2_1\"))));\n                return ((JSBNG_Record.markFunction)((function() {\n                    if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                        return ((JSBNG_Record.eventCall)((arguments.callee), (\"s0b6a75f6fe99368402e19542a48a63d5beec22d2_1\"), (s0b6a75f6fe99368402e19542a48a63d5beec22d2_1_instance), (this), (arguments)))\n                    };\n                    (null);\n                    (((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Get\")))[(\"Get\")]), (\"js\")))[(\"js\")])(\"http://l.yimg.com/zz/combo?kx/yucs/uh3/uh/js/1/uh-min.js&kx/yucs/uh3/uh/js/102/gallery-jsonp-min.js&kx/yucs/uh3/uh/js/565/menu_utils_v3-min.js&kx/yucs/uh3/uh/js/549/timestamp_library-min.js&kx/yucs/uh3/uh3_top_bar/js/148/top_bar_v3-min.js&kx/yucs/uh3/search/js/361/search-min.js&kx/ucs/common/js/131/jsonp-super-cached-min.js&kx/yucs/uh3/avatar/js/9/avatar-min.js&kx/yucs/uh3/mail_link/js/60/mailcount-min.js&kx/yucs/uh3/help/js/46/help_menu_v3-min.js\");\n                })));\n            })()));\n        })));\n    })()));\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};\n\n                \n            \n            \ntry {\n    ((JSBNG_Record.scriptLoad)((\"if ((typeof rt_pushMoment !== \\\"undefined\\\")) {\\u000a    rt_pushMoment(\\\"t2\\\");\\u000a};\"), (\"s3a56d1cd08626886d66f70072f43e2521a0cd07a\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    if ((typeof rt_pushMoment !== \"undefined\")) {\n        rt_pushMoment(\"t2\");\n    };\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};\n            \n                \n                \n\n\n\n\n    \n        \n            \n                \ntry {\n    ((JSBNG_Record.scriptLoad)((\"(function() {\\u000a    var wrap = document.getElementById(\\\"yom-ad-MAST\\\");\\u000a    if ((null == wrap)) {\\u000a        wrap = (document.getElementById(\\\"yom-ad-MAST-iframe\\\") || {\\u000a        });\\u000a    }\\u000a;\\u000a    var content = (wrap.innerHTML || \\\"\\\");\\u000a    if ((content && (content.substr(0, content.lastIndexOf(\\\"\\\\u003Cscript\\\\u003E\\\")).indexOf(\\\"loc=MAST noad\\\") !== -1))) {\\u000a        wrap.style.display = \\\"none\\\";\\u000a    }\\u000a;\\u000a}());\"), (\"se1fbd0603f526202587a2b4f56de690dd114e5bb\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    (((function() {\n        var se1fbd0603f526202587a2b4f56de690dd114e5bb_0_instance;\n        ((se1fbd0603f526202587a2b4f56de690dd114e5bb_0_instance) = ((JSBNG_Record.eventInstance)((\"se1fbd0603f526202587a2b4f56de690dd114e5bb_0\"))));\n        return ((JSBNG_Record.markFunction)((function() {\n            if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                return ((JSBNG_Record.eventCall)((arguments.callee), (\"se1fbd0603f526202587a2b4f56de690dd114e5bb_0\"), (se1fbd0603f526202587a2b4f56de690dd114e5bb_0_instance), (this), (arguments)))\n            };\n            (null);\n            var wrap = (((JSBNG_Record.get)(JSBNG__document, (\"getElementById\")))[(\"getElementById\")])(\"yom-ad-MAST\");\n            if ((null == wrap)) {\n                wrap = ((((JSBNG_Record.get)(JSBNG__document, (\"getElementById\")))[(\"getElementById\")])(\"yom-ad-MAST-iframe\") || {\n                });\n            }\n            ;\n            var JSBNG__content = ((((JSBNG_Record.get)(wrap, (\"innerHTML\")))[(\"innerHTML\")]) || \"\");\n            if ((JSBNG__content && ((((JSBNG_Record.get)((((JSBNG_Record.get)(JSBNG__content, (\"substr\")))[(\"substr\")])(0, (((JSBNG_Record.get)(JSBNG__content, (\"lastIndexOf\")))[(\"lastIndexOf\")])(\"\\u003Cscript\\u003E\")), (\"indexOf\")))[(\"indexOf\")])(\"loc=MAST noad\") !== -1))) {\n                ((JSBNG_Record.set)((((JSBNG_Record.get)(wrap, (\"style\")))[(\"style\")]), (\"display\"), \"none\"));\n            }\n            ;\n        })));\n    })())());\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};\n            \n        \n    \n    \n        \n            \n                \n    \n        \n                \n                    Home\n                \n                \n                    U.S.\n                \n                \n                    World\n                \n                \n                    Politics\n                \n                \n                    Tech\n                \n                \n                    Science\n                \n                \n                    Health\n                \n                \n                    Odd News\n                \n                \n                    Opinion\n                \n                \n                    Local\n                \n                \n                    Dear Abby\n                \n                \n                    Comics\n                \n                \n                    ABC News\n                \n                \n                    Y! News Originals\n                \n        \n        \n            <div class=\"nav-wrap pos-{{position}} {{classname}}\" data-position=\"{{position}}\">\n                <h3>{{header}}</h3>\n                <ul class=\"navlist\">\n                    {{#entries}}\n                        <li>\n                            <a href=\"{{link}}\" {{#title_attrib}}title=\"{{title_attrib}}\"{{/title_attrib}}{{#class}}class=\"{{class}}\"{{/class}} {{{tracking}}} data-action-outcome=\"navigate\" data-item-id=\"{{id}}\">{{{text}}}</a>\n                        </li>\n                    {{/entries}}\n                    {{#show_more}}\n                        <div class=\"subnav\">\n                            <li><a href=\"#\" class=\"more\">More <strong>&rsaquo;</strong></a>\n                                <div class=\"subnav-more\">\n                                    <i class=\"arrow\"></i>\n                                <ul>\n                                {{#more_entries}}\n                                <li>\n                                     <a href=\"{{link}}\" {{#title_attrib}}title=\"{{title_attrib}}\"{{/title_attrib}}{{#class}}class=\"{{class}}\"{{/class}} {{{tracking}}} data-action-outcome=\"navigate\" data-item-id=\"{{id}}\">{{{text}}}</a>\n                                </li>\n                                 {{/more_entries}}\n                                 </ul>\n                                 </div>\n                            </li>\n                        </div>\n                    {{/show_more}}\n                </ul>\n            </div>\n        \n    \n\n            \n        \n    \n    \n        \n            \n                \n\n            Judge rules against Zimmerman on evidence   SANFORD, Fla. (AP) — A Florida judge ruled Wednesday that Trayvon Martin's cellphone text messages … Read More »                     Bombing suspect heads to 1st public court hearing               SF probe brings questions over auto speed controls       \n\n            \n        \n    \n    \n         \n            \n                \ntry {\n    ((JSBNG_Record.scriptLoad)((\"(function() {\\u000a    var wrap = document.getElementById(\\\"yom-ad-LREC\\\");\\u000a    if ((null == wrap)) {\\u000a        wrap = (document.getElementById(\\\"yom-ad-LREC-iframe\\\") || {\\u000a        });\\u000a    }\\u000a;\\u000a    var content = (wrap.innerHTML || \\\"\\\");\\u000a    if ((content && (content.substr(0, content.lastIndexOf(\\\"\\\\u003Cscript\\\\u003E\\\")).indexOf(\\\"loc=LREC noad\\\") !== -1))) {\\u000a        wrap.style.display = \\\"none\\\";\\u000a    }\\u000a;\\u000a}());\"), (\"s948e0e6035133da5ed82f540da07ab5598a1a8dd\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    (((function() {\n        var s948e0e6035133da5ed82f540da07ab5598a1a8dd_0_instance;\n        ((s948e0e6035133da5ed82f540da07ab5598a1a8dd_0_instance) = ((JSBNG_Record.eventInstance)((\"s948e0e6035133da5ed82f540da07ab5598a1a8dd_0\"))));\n        return ((JSBNG_Record.markFunction)((function() {\n            if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                return ((JSBNG_Record.eventCall)((arguments.callee), (\"s948e0e6035133da5ed82f540da07ab5598a1a8dd_0\"), (s948e0e6035133da5ed82f540da07ab5598a1a8dd_0_instance), (this), (arguments)))\n            };\n            (null);\n            var wrap = (((JSBNG_Record.get)(JSBNG__document, (\"getElementById\")))[(\"getElementById\")])(\"yom-ad-LREC\");\n            if ((null == wrap)) {\n                wrap = ((((JSBNG_Record.get)(JSBNG__document, (\"getElementById\")))[(\"getElementById\")])(\"yom-ad-LREC-iframe\") || {\n                });\n            }\n            ;\n            var JSBNG__content = ((((JSBNG_Record.get)(wrap, (\"innerHTML\")))[(\"innerHTML\")]) || \"\");\n            if ((JSBNG__content && ((((JSBNG_Record.get)((((JSBNG_Record.get)(JSBNG__content, (\"substr\")))[(\"substr\")])(0, (((JSBNG_Record.get)(JSBNG__content, (\"lastIndexOf\")))[(\"lastIndexOf\")])(\"\\u003Cscript\\u003E\")), (\"indexOf\")))[(\"indexOf\")])(\"loc=LREC noad\") !== -1))) {\n                ((JSBNG_Record.set)((((JSBNG_Record.get)(wrap, (\"style\")))[(\"style\")]), (\"display\"), \"none\"));\n            }\n            ;\n        })));\n    })())());\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};\n\n    Comics    Andy Capp  Doonesbury  9 Chickweed Lane  Dilbert  Peanuts  Wizard of Id  B.C.  Luann  Garfield  Pearls Before Swine                 More   Wed, Jul 10          Andy Capp Wednesday, July 10 More         \n            #dmRosAdWrapper-east iframe{width:100%} #yog-cw .dmros_ad {border-color: #E0E0E0; border-style: solid; border-width: 0 0 1px;}\n            \n                \n                    <div id=\"dmRosAd-1-east\" width=\"300\" height=\"300\" frameborder=\"0\" marginheight=\"0\" marginwidth=\"0\" scrolling=\"no\" src=\"http://dmros.ysm.yahoo.com/ros/?c=e5879714&w=300&h=300&ty=noscript&tt=Yahoo%21+News+-+Latest+News+%26amp%3B+Headlines&r=\"></div>\n                \n            \n    Latest Videos             David Tillman's midday weather forecast  02:50              Printer ink efficiency tested by Consumer Reports  02:33              Rare Film Shows FDR Pushed in Wheelchair  00:34              Lunch Break 07-10-13  03:12              Wishbone, Bombay Spice & Grill, among newcomers at …  03:26              Whitey Bulger, ex-partner trade curses in courtroo …  04:57              Taste of Chicago 2013 opens  02:37              Officials defend Paulsboro train derailment respon …  00:32              Police searching for bus stop attacker in Humboldt …  02:16              Teen charged in mother's murder  02:55           \n\ntry {\n    ((JSBNG_Record.scriptLoad)((\"(function() {\\u000a    var wrap = document.getElementById(\\\"yom-ad-LREC2\\\");\\u000a    if ((null == wrap)) {\\u000a        wrap = (document.getElementById(\\\"yom-ad-LREC2-iframe\\\") || {\\u000a        });\\u000a    }\\u000a;\\u000a    var content = (wrap.innerHTML || \\\"\\\");\\u000a    if ((content && (content.substr(0, content.lastIndexOf(\\\"\\\\u003Cscript\\\\u003E\\\")).indexOf(\\\"loc=LREC2 noad\\\") !== -1))) {\\u000a        wrap.style.display = \\\"none\\\";\\u000a    }\\u000a;\\u000a}());\"), (\"sd991c19676f447c2f197b3bd52a4d38a8eef7ce7\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    (((function() {\n        var sd991c19676f447c2f197b3bd52a4d38a8eef7ce7_0_instance;\n        ((sd991c19676f447c2f197b3bd52a4d38a8eef7ce7_0_instance) = ((JSBNG_Record.eventInstance)((\"sd991c19676f447c2f197b3bd52a4d38a8eef7ce7_0\"))));\n        return ((JSBNG_Record.markFunction)((function() {\n            if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                return ((JSBNG_Record.eventCall)((arguments.callee), (\"sd991c19676f447c2f197b3bd52a4d38a8eef7ce7_0\"), (sd991c19676f447c2f197b3bd52a4d38a8eef7ce7_0_instance), (this), (arguments)))\n            };\n            (null);\n            var wrap = (((JSBNG_Record.get)(JSBNG__document, (\"getElementById\")))[(\"getElementById\")])(\"yom-ad-LREC2\");\n            if ((null == wrap)) {\n                wrap = ((((JSBNG_Record.get)(JSBNG__document, (\"getElementById\")))[(\"getElementById\")])(\"yom-ad-LREC2-iframe\") || {\n                });\n            }\n            ;\n            var JSBNG__content = ((((JSBNG_Record.get)(wrap, (\"innerHTML\")))[(\"innerHTML\")]) || \"\");\n            if ((JSBNG__content && ((((JSBNG_Record.get)((((JSBNG_Record.get)(JSBNG__content, (\"substr\")))[(\"substr\")])(0, (((JSBNG_Record.get)(JSBNG__content, (\"lastIndexOf\")))[(\"lastIndexOf\")])(\"\\u003Cscript\\u003E\")), (\"indexOf\")))[(\"indexOf\")])(\"loc=LREC2 noad\") !== -1))) {\n                ((JSBNG_Record.set)((((JSBNG_Record.get)(wrap, (\"style\")))[(\"style\")]), (\"display\"), \"none\"));\n            }\n            ;\n        })));\n    })())());\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};\n\n\n    \n        \n            \n        \n        \n            \n        \n        \n            \n                Copyright © 2013 Yahoo! Inc. All rights reserved.\n            \n            \n                 | Yahoo! - ABC News Network | \n            \n            \n                Help / Suggestions\n                Privacy Policy\n                About Our Ads\n                Terms of Service\n                Copyright/IP Policy\n            \n        \n        \n            \n        \n        \n    \n\n            \n        \n    \n\n\n\n\n\n\n    \n\n\n\n\n\n\n\n\n                \n                \n                \n                \n            \n            \ntry {\n    ((JSBNG_Record.scriptLoad)((\"if ((typeof rt_pushMoment !== \\\"undefined\\\")) {\\u000a    rt_pushMoment(\\\"t3\\\");\\u000a};\"), (\"sc2ad6e75bc9970a3d5d2eadcdf8c41b5a6326b31\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    if ((typeof rt_pushMoment !== \"undefined\")) {\n        rt_pushMoment(\"t3\");\n    };\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};\n        \n        \n        \ntry {\n    ((JSBNG_Record.scriptLoad)((\"if ((typeof rt_pushMoment !== \\\"undefined\\\")) {\\u000a    rt_pushMoment(\\\"t4\\\");\\u000a};\"), (\"sc826b587d5a8f7776f3b3628060183e7002a40eb\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    if ((typeof rt_pushMoment !== \"undefined\")) {\n        rt_pushMoment(\"t4\");\n    };\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};\n        \n        \ntry {\n    ((JSBNG_Record.scriptLoad)((\"YMedia.use(\\\"media-rmp\\\", \\\"media-viewport-loader\\\", function(Y) {\\u000a    Y.Global.Media.ViewportLoader.addContainers([{\\u000a        selector: \\\"#mediacontentfollowproperty_container\\\",\\u000a        callback: function(node) {\\u000a            Y.Media.RMP.load({\\u000a                srcNode: \\\"#mediacontentfollowproperty_container\\\",\\u000a                response: \\\"\\\\u000d\\\\u000a--dali-response-split-51ddaa39596e9\\\\u000d\\\\u000aContent-Type: text/plain; charset=utf-8\\\\u000d\\\\u000aRMP-Embed-Location: top\\\\u000d\\\\u000a\\\\u000d\\\\u000a\\\\u003Clink rel=\\\\\\\"stylesheet\\\\\\\" type=\\\\\\\"text/css\\\\\\\" href=\\\\\\\"http://l.yimg.com/zz/combo?os/mit/media/m/content_social/media-content-follow-property-desktop-min-1339299.css\\\\\\\" /\\\\u003E\\\\u000d\\\\u000a--dali-response-split-51ddaa39596e9\\\\u000d\\\\u000aContent-Type: text/plain; charset=utf-8\\\\u000d\\\\u000aRMP-Embed-Location: bottom\\\\u000d\\\\u000a\\\\u000d\\\\u000a\\\\u003Cscript language=\\\\\\\"javascript\\\\\\\"\\\\u003E\\\\u000a\\\\u0009\\\\u0009\\\\u000aYUI.YUICfg = {\\\\\\\"gallery\\\\\\\":\\\\\\\"gallery-2011.04.20-13-04\\\\\\\",\\\\\\\"groups\\\\\\\":{\\\\\\\"group01c9d8dea06e05460a64eed4dadd622b6\\\\\\\":{\\\\\\\"base\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/\\\\\\\",\\\\\\\"comboBase\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/zz\\\\\\\\/combo?\\\\\\\",\\\\\\\"modules\\\\\\\":{\\\\\\\"media-content-social-base\\\\\\\":{\\\\\\\"path\\\\\\\":\\\\\\\"os\\\\\\\\/mit\\\\\\\\/media\\\\\\\\/m\\\\\\\\/content_social\\\\\\\\/content-social-base-min-1339203.js\\\\\\\"},\\\\\\\"media-content-follow-property\\\\\\\":{\\\\\\\"path\\\\\\\":\\\\\\\"os\\\\\\\\/mit\\\\\\\\/media\\\\\\\\/m\\\\\\\\/content_social\\\\\\\\/content-follow-property-min-1306078.js\\\\\\\"}},\\\\\\\"combine\\\\\\\":true,\\\\\\\"filter\\\\\\\":\\\\\\\"min\\\\\\\",\\\\\\\"root\\\\\\\":\\\\\\\"\\\\\\\\/\\\\\\\"}},\\\\\\\"combine\\\\\\\":true,\\\\\\\"allowRollup\\\\\\\":true,\\\\\\\"comboBase\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/zz\\\\\\\\/combo?\\\\\\\",\\\\\\\"maxURLLength\\\\\\\":\\\\\\\"2000\\\\\\\"}\\\\u000aYUI.YUICfg.root='yui:'+YUI.version+'/build/';\\\\u000aYMedia.applyConfig(YUI.YUICfg);\\\\u000aYUI.Env[YUI.version].groups.gallery.root = 'yui:gallery-2011.04.20-13-04/build/';\\\\u000aYMedia.use(\\\\\\\"media-content-social-base\\\\\\\",\\\\\\\"media-content-follow-property\\\\\\\",\\\\\\\"base\\\\\\\",\\\\\\\"event\\\\\\\",\\\\\\\"node\\\\\\\",function(Y){\\\\u000a    \\\\u0009  \\\\u000a    Y.later(10, this, function() {new Y.Media.MediaContentFollowProperty({\\\\\\\"item_facebook\\\\\\\":{\\\\\\\"follow_url\\\\\\\":\\\\\\\"www.facebook.com\\\\\\\",\\\\\\\"follow_site\\\\\\\":\\\\\\\"facebook\\\\\\\",\\\\\\\"follow_id\\\\\\\":\\\\\\\"yahoonews\\\\\\\",\\\\\\\"follow_title\\\\\\\":\\\\\\\" on Facebook\\\\\\\",\\\\\\\"lang\\\\\\\":\\\\\\\"en_US\\\\\\\",\\\\\\\"tracking\\\\\\\":\\\\\\\"data-ylk=\\\\\\\\\\\\\\\"sec:mod-sh-fwm;itc:1;test:;act:click;slk:btn-sh-fb;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"outcome\\\\\\\":\\\\\\\"share\\\\\\\",\\\\\\\"is_tumblr\\\\\\\":false},\\\\\\\"item_twitter\\\\\\\":{\\\\\\\"follow_url\\\\\\\":\\\\\\\"twitter.com\\\\\\\",\\\\\\\"follow_site\\\\\\\":\\\\\\\"twitter\\\\\\\",\\\\\\\"follow_id\\\\\\\":\\\\\\\"yahoonews\\\\\\\",\\\\\\\"follow_title\\\\\\\":\\\\\\\" on Twitter\\\\\\\",\\\\\\\"lang\\\\\\\":\\\\\\\"en_US\\\\\\\",\\\\\\\"tracking\\\\\\\":\\\\\\\"data-ylk=\\\\\\\\\\\\\\\"sec:mod-sh-fwm;itc:1;test:;act:click;slk:btn-sh-tw;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"outcome\\\\\\\":\\\\\\\"share\\\\\\\",\\\\\\\"is_tumblr\\\\\\\":false},\\\\\\\"mod_id\\\\\\\":\\\\\\\"mediacontentfollowproperty\\\\\\\",\\\\\\\"mixer\\\\\\\":{\\\\\\\"site\\\\\\\":\\\\\\\"news\\\\\\\",\\\\\\\"region\\\\\\\":\\\\\\\"US\\\\\\\",\\\\\\\"lang\\\\\\\":\\\\\\\"en-US\\\\\\\",\\\\\\\"scrumb\\\\\\\":\\\\\\\"GYY7b.GZpxdOt6SP\\\\\\\",\\\\\\\"content_id\\\\\\\":\\\\\\\"5f01278b-803a-3803-9798-7fc79bab4f7d\\\\\\\",\\\\\\\"title_orig\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"url_orig\\\\\\\":\\\\\\\"\\\\\\\"}});});\\\\u000a\\\\u0009\\\\u0009   \\\\u000a});\\\\u000a\\\\u000aYUI.Env.add(window, \\\\\\\"load\\\\\\\", function(){\\\\u000aYMedia.use(\\\\\\\"\\\\\\\",function(Y){\\\\u000a    \\\\u0009  \\\\u000a    Y.later(10, this, function() {(function(){ var rapid = YMedia.rapid; if (rapid) { rapid.addModules(\\\\\\\"mediacontentfollowproperty\\\\\\\"); } }());\\\\u000a    });\\\\u000a});\\\\u000a});\\\\u000a\\\\u0009\\\\u0009\\\\u000a\\\\u0009    \\\\u003C/script\\\\u003E\\\\u000d\\\\u000a--dali-response-split-51ddaa39596e9\\\\u000d\\\\u000aContent-Type: text/html; charset=utf-8\\\\u000d\\\\u000a\\\\u000d\\\\u000a \\\\u003Csection class=\\\\\\\"yom-mod \\\\\\\" id=\\\\\\\"mediacontentfollowproperty\\\\\\\" data-ylk=\\\\\\\"mid:mediacontentfollowproperty;mpos:1;sec:mod-sh-fwm;test:;set:mod-sh-fwm;itc:1;\\\\\\\"\\\\u003E  \\\\u003Cdiv id=\\\\\\\"yom-follow-property\\\\\\\" class=\\\\\\\"yom-mod yom-follow-property\\\\\\\" data-ylk=\\\\\\\"mid:mediacontentfollowproperty;mpos:1;sec:mod-sh-fwm;test:;set:mod-sh-fwm;itc:1;\\\\\\\"\\\\u003E \\\\u003Cdiv class=\\\\\\\"hd\\\\\\\"\\\\u003E \\\\u003Ch3\\\\u003EFollow Yahoo! News\\\\u003C/h3\\\\u003E \\\\u003C/div\\\\u003E \\\\u003Cdiv class=\\\\\\\"bd\\\\\\\"\\\\u003E \\\\u003Cul\\\\u003E   \\\\u003Cli class=\\\\\\\"follow-property-facebook clearfix\\\\\\\"\\\\u003E \\\\u003Cdiv class=\\\\\\\"follow-icon\\\\\\\"\\\\u003E\\\\u003Ca href=\\\\\\\"http://www.facebook.com/yahoonews\\\\\\\" role=\\\\\\\"link\\\\\\\" target=\\\\\\\"_blank\\\\\\\" title=\\\\\\\" on Facebook\\\\\\\" data-ylk=&quot;sec:mod-sh-fwm;itc:1;test:;act:click;slk:btn-sh-fb;&quot; data-action-outcome=\\\\\\\"share\\\\\\\"\\\\u003E\\\\u003Cspan\\\\u003E\\\\u003C/span\\\\u003E\\\\u003C/a\\\\u003E\\\\u003C/div\\\\u003E \\\\u003Cdiv class=\\\\\\\"follow-title\\\\\\\"\\\\u003E\\\\u003Ca href=\\\\\\\"http://www.facebook.com/yahoonews\\\\\\\" role=\\\\\\\"link\\\\\\\" target=\\\\\\\"_blank\\\\\\\" title=\\\\\\\" on Facebook\\\\\\\" data-ylk=&quot;sec:mod-sh-fwm;itc:1;test:;act:click;slk:btn-sh-fb;&quot; data-action-outcome=\\\\\\\"share\\\\\\\"\\\\u003E on Facebook\\\\u003C/a\\\\u003E\\\\u003C/div\\\\u003E \\\\u003C/li\\\\u003E     \\\\u003Cli class=\\\\\\\"follow-property-twitter clearfix\\\\\\\"\\\\u003E \\\\u003Cdiv class=\\\\\\\"follow-icon\\\\\\\"\\\\u003E\\\\u003Ca href=\\\\\\\"http://twitter.com/yahoonews\\\\\\\" role=\\\\\\\"link\\\\\\\" target=\\\\\\\"_blank\\\\\\\" title=\\\\\\\" on Twitter\\\\\\\" data-ylk=&quot;sec:mod-sh-fwm;itc:1;test:;act:click;slk:btn-sh-tw;&quot; data-action-outcome=\\\\\\\"share\\\\\\\"\\\\u003E\\\\u003Cspan\\\\u003E\\\\u003C/span\\\\u003E\\\\u003C/a\\\\u003E\\\\u003C/div\\\\u003E \\\\u003Cdiv class=\\\\\\\"follow-title\\\\\\\"\\\\u003E\\\\u003Ca href=\\\\\\\"http://twitter.com/yahoonews\\\\\\\" role=\\\\\\\"link\\\\\\\" target=\\\\\\\"_blank\\\\\\\" title=\\\\\\\" on Twitter\\\\\\\" data-ylk=&quot;sec:mod-sh-fwm;itc:1;test:;act:click;slk:btn-sh-tw;&quot; data-action-outcome=\\\\\\\"share\\\\\\\"\\\\u003E on Twitter\\\\u003C/a\\\\u003E\\\\u003C/div\\\\u003E \\\\u003C/li\\\\u003E    \\\\u003C/ul\\\\u003E \\\\u003C/div\\\\u003E \\\\u003C/div\\\\u003E \\\\u003C/section\\\\u003E\\\\u000a\\\\u000d\\\\u000a--dali-response-split-51ddaa39596e9--\\\\u000d\\\\u000a\\\"\\u000a            });\\u000a        }\\u000a    },]);\\u000a});\"), (\"s8e71c04c971253d39181cc2fa43d5ef29ea27ffc\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    (((JSBNG_Record.get)(YMedia, (\"use\")))[(\"use\")])(\"media-rmp\", \"media-viewport-loader\", ((function() {\n        var s8e71c04c971253d39181cc2fa43d5ef29ea27ffc_0_instance;\n        ((s8e71c04c971253d39181cc2fa43d5ef29ea27ffc_0_instance) = ((JSBNG_Record.eventInstance)((\"s8e71c04c971253d39181cc2fa43d5ef29ea27ffc_0\"))));\n        return ((JSBNG_Record.markFunction)((function(Y) {\n            if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                return ((JSBNG_Record.eventCall)((arguments.callee), (\"s8e71c04c971253d39181cc2fa43d5ef29ea27ffc_0\"), (s8e71c04c971253d39181cc2fa43d5ef29ea27ffc_0_instance), (this), (arguments)))\n            };\n            (null);\n            (((JSBNG_Record.get)((((JSBNG_Record.get)((((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Global\")))[(\"Global\")]), (\"Media\")))[(\"Media\")]), (\"ViewportLoader\")))[(\"ViewportLoader\")]), (\"addContainers\")))[(\"addContainers\")])([{\n                selector: \"#mediacontentfollowproperty_container\",\n                callback: ((function() {\n                    var s8e71c04c971253d39181cc2fa43d5ef29ea27ffc_1_instance;\n                    ((s8e71c04c971253d39181cc2fa43d5ef29ea27ffc_1_instance) = ((JSBNG_Record.eventInstance)((\"s8e71c04c971253d39181cc2fa43d5ef29ea27ffc_1\"))));\n                    return ((JSBNG_Record.markFunction)((function(node) {\n                        if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                            return ((JSBNG_Record.eventCall)((arguments.callee), (\"s8e71c04c971253d39181cc2fa43d5ef29ea27ffc_1\"), (s8e71c04c971253d39181cc2fa43d5ef29ea27ffc_1_instance), (this), (arguments)))\n                        };\n                        (null);\n                        (((JSBNG_Record.get)((((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"RMP\")))[(\"RMP\")]), (\"load\")))[(\"load\")])({\n                            srcNode: \"#mediacontentfollowproperty_container\",\n                            response: \"\\u000d\\u000a--dali-response-split-51ddaa39596e9\\u000d\\u000aContent-Type: text/plain; charset=utf-8\\u000d\\u000aRMP-Embed-Location: top\\u000d\\u000a\\u000d\\u000a\\u003Clink rel=\\\"stylesheet\\\" type=\\\"text/css\\\" href=\\\"http://l.yimg.com/zz/combo?os/mit/media/m/content_social/media-content-follow-property-desktop-min-1339299.css\\\" /\\u003E\\u000d\\u000a--dali-response-split-51ddaa39596e9\\u000d\\u000aContent-Type: text/plain; charset=utf-8\\u000d\\u000aRMP-Embed-Location: bottom\\u000d\\u000a\\u000d\\u000a\\u003Cscript language=\\\"javascript\\\"\\u003E\\u000a\\u0009\\u0009\\u000aYUI.YUICfg = {\\\"gallery\\\":\\\"gallery-2011.04.20-13-04\\\",\\\"groups\\\":{\\\"group01c9d8dea06e05460a64eed4dadd622b6\\\":{\\\"base\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/\\\",\\\"comboBase\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/zz\\\\/combo?\\\",\\\"modules\\\":{\\\"media-content-social-base\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/m\\\\/content_social\\\\/content-social-base-min-1339203.js\\\"},\\\"media-content-follow-property\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/m\\\\/content_social\\\\/content-follow-property-min-1306078.js\\\"}},\\\"combine\\\":true,\\\"filter\\\":\\\"min\\\",\\\"root\\\":\\\"\\\\/\\\"}},\\\"combine\\\":true,\\\"allowRollup\\\":true,\\\"comboBase\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/zz\\\\/combo?\\\",\\\"maxURLLength\\\":\\\"2000\\\"}\\u000aYUI.YUICfg.root='yui:'+YUI.version+'/build/';\\u000aYMedia.applyConfig(YUI.YUICfg);\\u000aYUI.Env[YUI.version].groups.gallery.root = 'yui:gallery-2011.04.20-13-04/build/';\\u000aYMedia.use(\\\"media-content-social-base\\\",\\\"media-content-follow-property\\\",\\\"base\\\",\\\"event\\\",\\\"node\\\",function(Y){\\u000a    \\u0009  \\u000a    Y.later(10, this, function() {new Y.Media.MediaContentFollowProperty({\\\"item_facebook\\\":{\\\"follow_url\\\":\\\"www.facebook.com\\\",\\\"follow_site\\\":\\\"facebook\\\",\\\"follow_id\\\":\\\"yahoonews\\\",\\\"follow_title\\\":\\\" on Facebook\\\",\\\"lang\\\":\\\"en_US\\\",\\\"tracking\\\":\\\"data-ylk=\\\\\\\"sec:mod-sh-fwm;itc:1;test:;act:click;slk:btn-sh-fb;\\\\\\\"\\\",\\\"outcome\\\":\\\"share\\\",\\\"is_tumblr\\\":false},\\\"item_twitter\\\":{\\\"follow_url\\\":\\\"twitter.com\\\",\\\"follow_site\\\":\\\"twitter\\\",\\\"follow_id\\\":\\\"yahoonews\\\",\\\"follow_title\\\":\\\" on Twitter\\\",\\\"lang\\\":\\\"en_US\\\",\\\"tracking\\\":\\\"data-ylk=\\\\\\\"sec:mod-sh-fwm;itc:1;test:;act:click;slk:btn-sh-tw;\\\\\\\"\\\",\\\"outcome\\\":\\\"share\\\",\\\"is_tumblr\\\":false},\\\"mod_id\\\":\\\"mediacontentfollowproperty\\\",\\\"mixer\\\":{\\\"site\\\":\\\"news\\\",\\\"region\\\":\\\"US\\\",\\\"lang\\\":\\\"en-US\\\",\\\"scrumb\\\":\\\"GYY7b.GZpxdOt6SP\\\",\\\"content_id\\\":\\\"5f01278b-803a-3803-9798-7fc79bab4f7d\\\",\\\"title_orig\\\":\\\"\\\",\\\"url_orig\\\":\\\"\\\"}});});\\u000a\\u0009\\u0009   \\u000a});\\u000a\\u000aYUI.Env.add(window, \\\"load\\\", function(){\\u000aYMedia.use(\\\"\\\",function(Y){\\u000a    \\u0009  \\u000a    Y.later(10, this, function() {(function(){ var rapid = YMedia.rapid; if (rapid) { rapid.addModules(\\\"mediacontentfollowproperty\\\"); } }());\\u000a    });\\u000a});\\u000a});\\u000a\\u0009\\u0009\\u000a\\u0009    \\u003C/script\\u003E\\u000d\\u000a--dali-response-split-51ddaa39596e9\\u000d\\u000aContent-Type: text/html; charset=utf-8\\u000d\\u000a\\u000d\\u000a \\u003Csection class=\\\"yom-mod \\\" id=\\\"mediacontentfollowproperty\\\" data-ylk=\\\"mid:mediacontentfollowproperty;mpos:1;sec:mod-sh-fwm;test:;set:mod-sh-fwm;itc:1;\\\"\\u003E  \\u003Cdiv id=\\\"yom-follow-property\\\" class=\\\"yom-mod yom-follow-property\\\" data-ylk=\\\"mid:mediacontentfollowproperty;mpos:1;sec:mod-sh-fwm;test:;set:mod-sh-fwm;itc:1;\\\"\\u003E \\u003Cdiv class=\\\"hd\\\"\\u003E \\u003Ch3\\u003EFollow Yahoo! News\\u003C/h3\\u003E \\u003C/div\\u003E \\u003Cdiv class=\\\"bd\\\"\\u003E \\u003Cul\\u003E   \\u003Cli class=\\\"follow-property-facebook clearfix\\\"\\u003E \\u003Cdiv class=\\\"follow-icon\\\"\\u003E\\u003Ca href=\\\"http://www.facebook.com/yahoonews\\\" role=\\\"link\\\" target=\\\"_blank\\\" title=\\\" on Facebook\\\" data-ylk=&quot;sec:mod-sh-fwm;itc:1;test:;act:click;slk:btn-sh-fb;&quot; data-action-outcome=\\\"share\\\"\\u003E\\u003Cspan\\u003E\\u003C/span\\u003E\\u003C/a\\u003E\\u003C/div\\u003E \\u003Cdiv class=\\\"follow-title\\\"\\u003E\\u003Ca href=\\\"http://www.facebook.com/yahoonews\\\" role=\\\"link\\\" target=\\\"_blank\\\" title=\\\" on Facebook\\\" data-ylk=&quot;sec:mod-sh-fwm;itc:1;test:;act:click;slk:btn-sh-fb;&quot; data-action-outcome=\\\"share\\\"\\u003E on Facebook\\u003C/a\\u003E\\u003C/div\\u003E \\u003C/li\\u003E     \\u003Cli class=\\\"follow-property-twitter clearfix\\\"\\u003E \\u003Cdiv class=\\\"follow-icon\\\"\\u003E\\u003Ca href=\\\"http://twitter.com/yahoonews\\\" role=\\\"link\\\" target=\\\"_blank\\\" title=\\\" on Twitter\\\" data-ylk=&quot;sec:mod-sh-fwm;itc:1;test:;act:click;slk:btn-sh-tw;&quot; data-action-outcome=\\\"share\\\"\\u003E\\u003Cspan\\u003E\\u003C/span\\u003E\\u003C/a\\u003E\\u003C/div\\u003E \\u003Cdiv class=\\\"follow-title\\\"\\u003E\\u003Ca href=\\\"http://twitter.com/yahoonews\\\" role=\\\"link\\\" target=\\\"_blank\\\" title=\\\" on Twitter\\\" data-ylk=&quot;sec:mod-sh-fwm;itc:1;test:;act:click;slk:btn-sh-tw;&quot; data-action-outcome=\\\"share\\\"\\u003E on Twitter\\u003C/a\\u003E\\u003C/div\\u003E \\u003C/li\\u003E    \\u003C/ul\\u003E \\u003C/div\\u003E \\u003C/div\\u003E \\u003C/section\\u003E\\u000a\\u000d\\u000a--dali-response-split-51ddaa39596e9--\\u000d\\u000a\"\n                        });\n                    })));\n                })())\n            },]);\n        })));\n    })()));\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};\n\ntry {\n    ((JSBNG_Record.scriptLoad)((\"YMedia.use(\\\"media-rmp\\\", \\\"media-viewport-loader\\\", function(Y) {\\u000a    Y.Global.Media.ViewportLoader.addContainers([{\\u000a        selector: \\\"#mediacontentweather_container\\\",\\u000a        callback: function(node) {\\u000a            Y.Media.RMP.load({\\u000a                srcNode: \\\"#mediacontentweather_container\\\",\\u000a                response: \\\"\\\\u000d\\\\u000a--dali-response-split-51ddaa3cb982c\\\\u000d\\\\u000aContent-Type: text/plain; charset=utf-8\\\\u000d\\\\u000aRMP-Embed-Location: top\\\\u000d\\\\u000a\\\\u000d\\\\u000a\\\\u003Clink rel=\\\\\\\"stylesheet\\\\\\\" type=\\\\\\\"text/css\\\\\\\" href=\\\\\\\"http://l.yimg.com/zz/combo?rl/ulw/2.2.3/location_widget-min.css&os/mit/media/m/content_index/weather-desktop-min-1311126.css\\\\\\\" /\\\\u003E\\\\u000a\\\\u000a\\\\u0009\\\\u0009\\\\u003Cscript language=\\\\\\\"javascript\\\\\\\"\\\\u003E\\\\u000a\\\\u0009\\\\u0009\\\\u000aYUI.YUICfg = {\\\\\\\"gallery\\\\\\\":\\\\\\\"gallery-2011.04.20-13-04\\\\\\\",\\\\\\\"groups\\\\\\\":{\\\\\\\"group01c9d8dea06e05460a64eed4dadd622b6\\\\\\\":{\\\\\\\"base\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/\\\\\\\",\\\\\\\"comboBase\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/zz\\\\\\\\/combo?\\\\\\\",\\\\\\\"modules\\\\\\\":{\\\\\\\"media-lw-base64\\\\\\\":{\\\\\\\"path\\\\\\\":\\\\\\\"rl\\\\\\\\/ulw\\\\\\\\/2.2.3\\\\\\\\/lw-base64-min.js\\\\\\\"},\\\\\\\"media-lw-overlay\\\\\\\":{\\\\\\\"path\\\\\\\":\\\\\\\"rl\\\\\\\\/ulw\\\\\\\\/2.2.3\\\\\\\\/lw-overlay-min.js\\\\\\\"},\\\\\\\"media-locdrop-patch-2.2.4\\\\\\\":{\\\\\\\"path\\\\\\\":\\\\\\\"os\\\\\\\\/mit\\\\\\\\/media\\\\\\\\/m\\\\\\\\/weather\\\\\\\\/locdrop-patch-2.2.4-min-1275196.js\\\\\\\"}},\\\\\\\"combine\\\\\\\":true,\\\\\\\"filter\\\\\\\":\\\\\\\"min\\\\\\\",\\\\\\\"root\\\\\\\":\\\\\\\"\\\\\\\\/\\\\\\\"}},\\\\\\\"combine\\\\\\\":true,\\\\\\\"allowRollup\\\\\\\":true,\\\\\\\"comboBase\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/zz\\\\\\\\/combo?\\\\\\\",\\\\\\\"maxURLLength\\\\\\\":\\\\\\\"2000\\\\\\\"}\\\\u000aYUI.YUICfg.root='yui:'+YUI.version+'/build/';\\\\u000aYMedia.applyConfig(YUI.YUICfg);\\\\u000aYUI.Env[YUI.version].groups.gallery.root = 'yui:gallery-2011.04.20-13-04/build/';\\\\u000aYMedia.use(\\\\\\\"media-lw-base64\\\\\\\",\\\\\\\"media-lw-overlay\\\\\\\",\\\\\\\"media-locdrop-patch-2.2.4\\\\\\\",function(Y){\\\\u000a    \\\\u0009  \\\\u000a\\\\u0009\\\\u0009   \\\\u000a});\\\\u000a\\\\u000a\\\\u0009\\\\u0009\\\\u000a\\\\u0009    \\\\u003C/script\\\\u003E\\\\u000d\\\\u000a--dali-response-split-51ddaa3cb982c\\\\u000d\\\\u000aContent-Type: text/plain; charset=utf-8\\\\u000d\\\\u000aRMP-Embed-Location: bottom\\\\u000d\\\\u000a\\\\u000d\\\\u000a\\\\u003Cscript language=\\\\\\\"javascript\\\\\\\"\\\\u003E\\\\u000a\\\\u0009\\\\u0009\\\\u000aYUI.YUICfg = {\\\\\\\"gallery\\\\\\\":\\\\\\\"gallery-2011.04.20-13-04\\\\\\\",\\\\\\\"groups\\\\\\\":{\\\\\\\"group01c9d8dea06e05460a64eed4dadd622b6\\\\\\\":{\\\\\\\"base\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/\\\\\\\",\\\\\\\"comboBase\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/zz\\\\\\\\/combo?\\\\\\\",\\\\\\\"modules\\\\\\\":{\\\\\\\"media-weather\\\\\\\":{\\\\\\\"path\\\\\\\":\\\\\\\"os\\\\\\\\/mit\\\\\\\\/media\\\\\\\\/m\\\\\\\\/content_index\\\\\\\\/weather-min-1321733.js\\\\\\\"}},\\\\\\\"combine\\\\\\\":true,\\\\\\\"filter\\\\\\\":\\\\\\\"min\\\\\\\",\\\\\\\"root\\\\\\\":\\\\\\\"\\\\\\\\/\\\\\\\"}},\\\\\\\"combine\\\\\\\":true,\\\\\\\"allowRollup\\\\\\\":true,\\\\\\\"comboBase\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/zz\\\\\\\\/combo?\\\\\\\",\\\\\\\"maxURLLength\\\\\\\":\\\\\\\"2000\\\\\\\"}\\\\u000aYUI.YUICfg.root='yui:'+YUI.version+'/build/';\\\\u000aYMedia.applyConfig(YUI.YUICfg);\\\\u000aYUI.Env[YUI.version].groups.gallery.root = 'yui:gallery-2011.04.20-13-04/build/';\\\\u000aYMedia.use(\\\\\\\"media-weather\\\\\\\",function(Y){\\\\u000a    \\\\u0009  \\\\u000a\\\\u0009\\\\u0009   \\\\u000a});\\\\u000a\\\\u000aYUI.Env.add(window, \\\\\\\"load\\\\\\\", function(){\\\\u000aYMedia.use(\\\\\\\"media-weather\\\\\\\",\\\\\\\"jsonp\\\\\\\",\\\\\\\"jsonp-url\\\\\\\",\\\\\\\"node-focusmanager\\\\\\\",\\\\\\\"lw-overlay\\\\\\\",\\\\\\\"lw-base64\\\\\\\",\\\\\\\"ulwv2-locdrop\\\\\\\",\\\\\\\"array-extras\\\\\\\",function(Y){\\\\u000a    \\\\u0009  \\\\u000a    Y.later(10, this, function() {Y.Media.Weather.MediaContentWeather.Weather.init({\\\\\\\"modId\\\\\\\":\\\\\\\"mediacontentweather\\\\\\\",\\\\\\\"bucket\\\\\\\":null,\\\\\\\"crumbVal\\\\\\\":\\\\\\\"Nmx0cEd0UDU5YmU-\\\\\\\",\\\\\\\"curLocObj\\\\\\\":{\\\\\\\"addr\\\\\\\":\\\\\\\"Lafayette, Indiana, United States, 47905\\\\\\\",\\\\\\\"app\\\\\\\":\\\\\\\"yahoo.globalmedia.auth-yca.ups.env-prod\\\\\\\",\\\\\\\"cc\\\\\\\":\\\\\\\"US\\\\\\\",\\\\\\\"city\\\\\\\":\\\\\\\"Lafayette\\\\\\\",\\\\\\\"conf\\\\\\\":60,\\\\\\\"country_conf\\\\\\\":90,\\\\\\\"ctry\\\\\\\":\\\\\\\"United States\\\\\\\",\\\\\\\"ctx\\\\\\\":\\\\\\\"global\\\\\\\",\\\\\\\"dtime\\\\\\\":\\\\\\\"2013-07-10T18:38:52Z\\\\\\\",\\\\\\\"freq\\\\\\\":1,\\\\\\\"id\\\\\\\":\\\\\\\"id_current\\\\\\\",\\\\\\\"input\\\\\\\":\\\\\\\"ip\\\\\\\",\\\\\\\"lat\\\\\\\":40.424388885498,\\\\\\\"lon\\\\\\\":-86.808479309082,\\\\\\\"lvl\\\\\\\":1,\\\\\\\"rad\\\\\\\":15781,\\\\\\\"raw\\\\\\\":\\\\\\\"98.215.10.79\\\\\\\",\\\\\\\"sc\\\\\\\":\\\\\\\"IN\\\\\\\",\\\\\\\"src\\\\\\\":\\\\\\\"gt_locip\\\\\\\",\\\\\\\"state\\\\\\\":\\\\\\\"Indiana\\\\\\\",\\\\\\\"state_conf\\\\\\\":60,\\\\\\\"town_conf\\\\\\\":60,\\\\\\\"type\\\\\\\":\\\\\\\"physical\\\\\\\",\\\\\\\"woe\\\\\\\":12778444,\\\\\\\"woetype\\\\\\\":\\\\\\\"zip\\\\\\\",\\\\\\\"zip\\\\\\\":\\\\\\\"47905\\\\\\\",\\\\\\\"zip_conf\\\\\\\":60},\\\\\\\"defLocObj\\\\\\\":null,\\\\\\\"spaceId\\\\\\\":\\\\\\\"2143334674\\\\\\\",\\\\\\\"locale\\\\\\\":\\\\\\\"en-US\\\\\\\",\\\\\\\"lang\\\\\\\":\\\\\\\"US\\\\\\\",\\\\\\\"fpHost\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/weather.yahoo.com\\\\\\\",\\\\\\\"unit\\\\\\\":\\\\\\\"f\\\\\\\"});\\\\u000a    });\\\\u000a    Y.later(10, this, function() {(function(){ var rapid = YMedia.rapid; if (rapid) { rapid.addModules(\\\\\\\"mediacontentweather\\\\\\\"); } }());\\\\u000a    });\\\\u000a});\\\\u000a});\\\\u000a\\\\u0009\\\\u0009\\\\u000a\\\\u0009    \\\\u003C/script\\\\u003E\\\\u000d\\\\u000a--dali-response-split-51ddaa3cb982c\\\\u000d\\\\u000aContent-Type: text/html; charset=utf-8\\\\u000d\\\\u000a\\\\u000d\\\\u000a \\\\u003Csection class=\\\\\\\"yom-mod yom-weather yom-app clearfix\\\\\\\" id=\\\\\\\"mediacontentweather\\\\\\\" data-ylk=\\\\\\\"mid:mediacontentweather;mpos:1;sec:app-wea;\\\\\\\"\\\\u003E  \\\\u003Cform id=\\\\\\\"fixIE10Enter\\\\\\\" onsubmit=\\\\\\\"return false;\\\\\\\"\\\\u003E \\\\u003Ch2 class=\\\\\\\"hide\\\\\\\"\\\\u003EWeather Today\\\\u003C/h2\\\\u003E  \\\\u003Cul\\\\u003E  \\\\u003Cli class=\\\\\\\"current clearfix\\\\\\\" data-uri=\\\\\\\"http://weather.yahoo.com/united-states/indiana/lafayette-12778444/\\\\\\\"\\\\u003E \\\\u003Ca href=\\\\\\\"http://weather.yahoo.com/united-states/indiana/lafayette-12778444/\\\\\\\" data-ylk=\\\\\\\"sec:app-wea;cpos:1;pos:2;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\\\\\"\\\\u003E \\\\u003Cimg src=\\\\\\\"http://l4.yimg.com/dh/ap/default/121210/8_IE6.png\\\\\\\" alt=\\\\\\\"Light Rain\\\\\\\" title=\\\\\\\"Light Rain\\\\\\\" class=\\\\\\\"cond-icon\\\\\\\"\\\\u003E \\\\u003C/a\\\\u003E \\\\u003Ch3 class=\\\\\\\"hd\\\\\\\"\\\\u003E \\\\u003Cp id=\\\\\\\"weather_lw_switch\\\\\\\"\\\\u003E \\\\u003Cspan class=\\\\\\\"ell\\\\\\\" title=\\\\\\\"Lafayette, IN\\\\\\\"\\\\u003ELafayette, IN\\\\u003C/span\\\\u003E \\\\u003Cspan id=\\\\\\\"ulw-start\\\\\\\"\\\\u003E&nbsp;\\\\u003C/span\\\\u003E\\\\u003C/p\\\\u003E \\\\u003Ca href=\\\\\\\"http://weather.yahoo.com/united-states/indiana/lafayette-12778444/\\\\\\\" class=\\\\\\\"cond\\\\\\\" data-ylk=\\\\\\\"sec:app-wea;cpos:1;pos:1;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\\\\\"\\\\u003E \\\\u003Cem class=\\\\\\\"temp temp-f \\\\\\\"\\\\u003E 70\\\\u003Cspan class=\\\\\\\"unit\\\\\\\"\\\\u003E&deg;F\\\\u003C/span\\\\u003E\\\\u003Cspan class=\\\\\\\"cond-title\\\\\\\"\\\\u003ELight Rain\\\\u003C/span\\\\u003E \\\\u003C/em\\\\u003E \\\\u003Cem class=\\\\\\\"temp temp-c hide\\\\\\\"\\\\u003E 21\\\\u003Cspan class=\\\\\\\"unit\\\\\\\"\\\\u003E&deg;C\\\\u003C/span\\\\u003E\\\\u003Cspan class=\\\\\\\"cond-title\\\\\\\"\\\\u003ELight Rain\\\\u003C/span\\\\u003E \\\\u003C/em\\\\u003E \\\\u003C/a\\\\u003E \\\\u003C/h3\\\\u003E \\\\u003C/li\\\\u003E   \\\\u003Cli class=\\\\\\\"forecast\\\\\\\"\\\\u003E \\\\u003Ca href=\\\\\\\"http://weather.yahoo.com/united-states/indiana/lafayette-12778444/\\\\\\\" data-ylk=\\\\\\\"sec:app-wea;cpos:2;pos:1;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\\\\\"\\\\u003E \\\\u003Cimg src=\\\\\\\"http://l4.yimg.com/dh/ap/default/121210/8_IE6.png\\\\\\\" alt=\\\\\\\"\\\\\\\" class=\\\\\\\"cond-icon\\\\\\\"\\\\u003E \\\\u003C/a\\\\u003E \\\\u003Ch3 class=\\\\\\\"hd\\\\\\\"\\\\u003E \\\\u003Ca href=\\\\\\\"http://weather.yahoo.com/united-states/indiana/lafayette-12778444/\\\\\\\" class=\\\\\\\"ell\\\\\\\" data-ylk=\\\\\\\"sec:app-wea;cpos:2;pos:2;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\\\\\"\\\\u003EToday\\\\u003C/a\\\\u003E \\\\u003Ca href=\\\\\\\"http://weather.yahoo.com/united-states/indiana/lafayette-12778444/\\\\\\\" class=\\\\\\\"temp temp-f \\\\\\\" data-ylk=\\\\\\\"sec:app-wea;cpos:2;pos:3;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\\\\\"\\\\u003E \\\\u003Cspan class=\\\\\\\"high\\\\\\\"\\\\u003E84&deg;\\\\u003C/span\\\\u003E \\\\u003Cspan class=\\\\\\\"low\\\\\\\"\\\\u003E60&deg;\\\\u003C/span\\\\u003E \\\\u003C/a\\\\u003E \\\\u003Ca href=\\\\\\\"http://weather.yahoo.com/united-states/indiana/lafayette-12778444/\\\\\\\" class=\\\\\\\"temp temp-c hide\\\\\\\" data-ylk=\\\\\\\"sec:app-wea;cpos:2;pos:3;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\\\\\"\\\\u003E \\\\u003Cspan class=\\\\\\\"high\\\\\\\"\\\\u003E29&deg;\\\\u003C/span\\\\u003E \\\\u003Cspan class=\\\\\\\"low\\\\\\\"\\\\u003E16&deg;\\\\u003C/span\\\\u003E \\\\u003C/a\\\\u003E \\\\u003C/h3\\\\u003E \\\\u003C/li\\\\u003E  \\\\u003Cli class=\\\\\\\"forecast\\\\\\\"\\\\u003E \\\\u003Ca href=\\\\\\\"http://weather.yahoo.com/united-states/indiana/lafayette-12778444/\\\\\\\" data-ylk=\\\\\\\"sec:app-wea;cpos:3;pos:1;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\\\\\"\\\\u003E \\\\u003Cimg src=\\\\\\\"http://l4.yimg.com/dh/ap/default/121210/33_IE6.png\\\\\\\" alt=\\\\\\\"\\\\\\\" class=\\\\\\\"cond-icon\\\\\\\"\\\\u003E \\\\u003C/a\\\\u003E \\\\u003Ch3 class=\\\\\\\"hd\\\\\\\"\\\\u003E \\\\u003Ca href=\\\\\\\"http://weather.yahoo.com/united-states/indiana/lafayette-12778444/\\\\\\\" class=\\\\\\\"ell\\\\\\\" data-ylk=\\\\\\\"sec:app-wea;cpos:3;pos:2;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\\\\\"\\\\u003ETomorrow\\\\u003C/a\\\\u003E \\\\u003Ca href=\\\\\\\"http://weather.yahoo.com/united-states/indiana/lafayette-12778444/\\\\\\\" class=\\\\\\\"temp temp-f \\\\\\\" data-ylk=\\\\\\\"sec:app-wea;cpos:3;pos:3;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\\\\\"\\\\u003E \\\\u003Cspan class=\\\\\\\"high\\\\\\\"\\\\u003E81&deg;\\\\u003C/span\\\\u003E \\\\u003Cspan class=\\\\\\\"low\\\\\\\"\\\\u003E55&deg;\\\\u003C/span\\\\u003E \\\\u003C/a\\\\u003E \\\\u003Ca href=\\\\\\\"http://weather.yahoo.com/united-states/indiana/lafayette-12778444/\\\\\\\" class=\\\\\\\"temp temp-c hide\\\\\\\" data-ylk=\\\\\\\"sec:app-wea;cpos:3;pos:3;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\\\\\"\\\\u003E \\\\u003Cspan class=\\\\\\\"high\\\\\\\"\\\\u003E27&deg;\\\\u003C/span\\\\u003E \\\\u003Cspan class=\\\\\\\"low\\\\\\\"\\\\u003E13&deg;\\\\u003C/span\\\\u003E \\\\u003C/a\\\\u003E \\\\u003C/h3\\\\u003E \\\\u003C/li\\\\u003E  \\\\u003Cli class=\\\\\\\"forecast\\\\\\\"\\\\u003E \\\\u003Ca href=\\\\\\\"http://weather.yahoo.com/united-states/indiana/lafayette-12778444/\\\\\\\" data-ylk=\\\\\\\"sec:app-wea;cpos:4;pos:1;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\\\\\"\\\\u003E \\\\u003Cimg src=\\\\\\\"http://l4.yimg.com/dh/ap/default/121210/31_IE6.png\\\\\\\" alt=\\\\\\\"\\\\\\\" class=\\\\\\\"cond-icon\\\\\\\"\\\\u003E \\\\u003C/a\\\\u003E \\\\u003Ch3 class=\\\\\\\"hd\\\\\\\"\\\\u003E \\\\u003Ca href=\\\\\\\"http://weather.yahoo.com/united-states/indiana/lafayette-12778444/\\\\\\\" class=\\\\\\\"ell\\\\\\\" data-ylk=\\\\\\\"sec:app-wea;cpos:4;pos:2;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\\\\\"\\\\u003EFriday\\\\u003C/a\\\\u003E \\\\u003Ca href=\\\\\\\"http://weather.yahoo.com/united-states/indiana/lafayette-12778444/\\\\\\\" class=\\\\\\\"temp temp-f \\\\\\\" data-ylk=\\\\\\\"sec:app-wea;cpos:4;pos:3;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\\\\\"\\\\u003E \\\\u003Cspan class=\\\\\\\"high\\\\\\\"\\\\u003E79&deg;\\\\u003C/span\\\\u003E \\\\u003Cspan class=\\\\\\\"low\\\\\\\"\\\\u003E57&deg;\\\\u003C/span\\\\u003E \\\\u003C/a\\\\u003E \\\\u003Ca href=\\\\\\\"http://weather.yahoo.com/united-states/indiana/lafayette-12778444/\\\\\\\" class=\\\\\\\"temp temp-c hide\\\\\\\" data-ylk=\\\\\\\"sec:app-wea;cpos:4;pos:3;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\\\\\"\\\\u003E \\\\u003Cspan class=\\\\\\\"high\\\\\\\"\\\\u003E26&deg;\\\\u003C/span\\\\u003E \\\\u003Cspan class=\\\\\\\"low\\\\\\\"\\\\u003E14&deg;\\\\u003C/span\\\\u003E \\\\u003C/a\\\\u003E \\\\u003C/h3\\\\u003E \\\\u003C/li\\\\u003E  \\\\u003C/ul\\\\u003E   \\\\u003C/form\\\\u003E \\\\u003Cdiv class=\\\\\\\"weather_credit\\\\\\\"\\\\u003E \\\\u003Cspan class=\\\\\\\"weather_credit_text\\\\\\\"\\\\u003EPowered by\\\\u003C/span\\\\u003E \\\\u003Ca href=\\\\\\\"http://www.weather.com\\\\\\\" class=\\\\\\\"twc_icon\\\\\\\"\\\\u003E \\\\u003Cspan class=\\\\\\\"weather_twc_icon\\\\\\\"/\\\\u003E\\\\u003C/span\\\\u003E \\\\u003C/a\\\\u003E \\\\u003C/div\\\\u003E \\\\u003C/section\\\\u003E\\\\u000a\\\\u000d\\\\u000a--dali-response-split-51ddaa3cb982c--\\\\u000d\\\\u000a\\\"\\u000a            });\\u000a        }\\u000a    },]);\\u000a});\"), (\"s7b8b8a93564ff584ddbba670def88ad791a13048\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    (((JSBNG_Record.get)(YMedia, (\"use\")))[(\"use\")])(\"media-rmp\", \"media-viewport-loader\", ((function() {\n        var s7b8b8a93564ff584ddbba670def88ad791a13048_0_instance;\n        ((s7b8b8a93564ff584ddbba670def88ad791a13048_0_instance) = ((JSBNG_Record.eventInstance)((\"s7b8b8a93564ff584ddbba670def88ad791a13048_0\"))));\n        return ((JSBNG_Record.markFunction)((function(Y) {\n            if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                return ((JSBNG_Record.eventCall)((arguments.callee), (\"s7b8b8a93564ff584ddbba670def88ad791a13048_0\"), (s7b8b8a93564ff584ddbba670def88ad791a13048_0_instance), (this), (arguments)))\n            };\n            (null);\n            (((JSBNG_Record.get)((((JSBNG_Record.get)((((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Global\")))[(\"Global\")]), (\"Media\")))[(\"Media\")]), (\"ViewportLoader\")))[(\"ViewportLoader\")]), (\"addContainers\")))[(\"addContainers\")])([{\n                selector: \"#mediacontentweather_container\",\n                callback: ((function() {\n                    var s7b8b8a93564ff584ddbba670def88ad791a13048_1_instance;\n                    ((s7b8b8a93564ff584ddbba670def88ad791a13048_1_instance) = ((JSBNG_Record.eventInstance)((\"s7b8b8a93564ff584ddbba670def88ad791a13048_1\"))));\n                    return ((JSBNG_Record.markFunction)((function(node) {\n                        if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                            return ((JSBNG_Record.eventCall)((arguments.callee), (\"s7b8b8a93564ff584ddbba670def88ad791a13048_1\"), (s7b8b8a93564ff584ddbba670def88ad791a13048_1_instance), (this), (arguments)))\n                        };\n                        (null);\n                        (((JSBNG_Record.get)((((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"RMP\")))[(\"RMP\")]), (\"load\")))[(\"load\")])({\n                            srcNode: \"#mediacontentweather_container\",\n                            response: \"\\u000d\\u000a--dali-response-split-51ddaa3cb982c\\u000d\\u000aContent-Type: text/plain; charset=utf-8\\u000d\\u000aRMP-Embed-Location: top\\u000d\\u000a\\u000d\\u000a\\u003Clink rel=\\\"stylesheet\\\" type=\\\"text/css\\\" href=\\\"http://l.yimg.com/zz/combo?rl/ulw/2.2.3/location_widget-min.css&os/mit/media/m/content_index/weather-desktop-min-1311126.css\\\" /\\u003E\\u000a\\u000a\\u0009\\u0009\\u003Cscript language=\\\"javascript\\\"\\u003E\\u000a\\u0009\\u0009\\u000aYUI.YUICfg = {\\\"gallery\\\":\\\"gallery-2011.04.20-13-04\\\",\\\"groups\\\":{\\\"group01c9d8dea06e05460a64eed4dadd622b6\\\":{\\\"base\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/\\\",\\\"comboBase\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/zz\\\\/combo?\\\",\\\"modules\\\":{\\\"media-lw-base64\\\":{\\\"path\\\":\\\"rl\\\\/ulw\\\\/2.2.3\\\\/lw-base64-min.js\\\"},\\\"media-lw-overlay\\\":{\\\"path\\\":\\\"rl\\\\/ulw\\\\/2.2.3\\\\/lw-overlay-min.js\\\"},\\\"media-locdrop-patch-2.2.4\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/m\\\\/weather\\\\/locdrop-patch-2.2.4-min-1275196.js\\\"}},\\\"combine\\\":true,\\\"filter\\\":\\\"min\\\",\\\"root\\\":\\\"\\\\/\\\"}},\\\"combine\\\":true,\\\"allowRollup\\\":true,\\\"comboBase\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/zz\\\\/combo?\\\",\\\"maxURLLength\\\":\\\"2000\\\"}\\u000aYUI.YUICfg.root='yui:'+YUI.version+'/build/';\\u000aYMedia.applyConfig(YUI.YUICfg);\\u000aYUI.Env[YUI.version].groups.gallery.root = 'yui:gallery-2011.04.20-13-04/build/';\\u000aYMedia.use(\\\"media-lw-base64\\\",\\\"media-lw-overlay\\\",\\\"media-locdrop-patch-2.2.4\\\",function(Y){\\u000a    \\u0009  \\u000a\\u0009\\u0009   \\u000a});\\u000a\\u000a\\u0009\\u0009\\u000a\\u0009    \\u003C/script\\u003E\\u000d\\u000a--dali-response-split-51ddaa3cb982c\\u000d\\u000aContent-Type: text/plain; charset=utf-8\\u000d\\u000aRMP-Embed-Location: bottom\\u000d\\u000a\\u000d\\u000a\\u003Cscript language=\\\"javascript\\\"\\u003E\\u000a\\u0009\\u0009\\u000aYUI.YUICfg = {\\\"gallery\\\":\\\"gallery-2011.04.20-13-04\\\",\\\"groups\\\":{\\\"group01c9d8dea06e05460a64eed4dadd622b6\\\":{\\\"base\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/\\\",\\\"comboBase\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/zz\\\\/combo?\\\",\\\"modules\\\":{\\\"media-weather\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/m\\\\/content_index\\\\/weather-min-1321733.js\\\"}},\\\"combine\\\":true,\\\"filter\\\":\\\"min\\\",\\\"root\\\":\\\"\\\\/\\\"}},\\\"combine\\\":true,\\\"allowRollup\\\":true,\\\"comboBase\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/zz\\\\/combo?\\\",\\\"maxURLLength\\\":\\\"2000\\\"}\\u000aYUI.YUICfg.root='yui:'+YUI.version+'/build/';\\u000aYMedia.applyConfig(YUI.YUICfg);\\u000aYUI.Env[YUI.version].groups.gallery.root = 'yui:gallery-2011.04.20-13-04/build/';\\u000aYMedia.use(\\\"media-weather\\\",function(Y){\\u000a    \\u0009  \\u000a\\u0009\\u0009   \\u000a});\\u000a\\u000aYUI.Env.add(window, \\\"load\\\", function(){\\u000aYMedia.use(\\\"media-weather\\\",\\\"jsonp\\\",\\\"jsonp-url\\\",\\\"node-focusmanager\\\",\\\"lw-overlay\\\",\\\"lw-base64\\\",\\\"ulwv2-locdrop\\\",\\\"array-extras\\\",function(Y){\\u000a    \\u0009  \\u000a    Y.later(10, this, function() {Y.Media.Weather.MediaContentWeather.Weather.init({\\\"modId\\\":\\\"mediacontentweather\\\",\\\"bucket\\\":null,\\\"crumbVal\\\":\\\"Nmx0cEd0UDU5YmU-\\\",\\\"curLocObj\\\":{\\\"addr\\\":\\\"Lafayette, Indiana, United States, 47905\\\",\\\"app\\\":\\\"yahoo.globalmedia.auth-yca.ups.env-prod\\\",\\\"cc\\\":\\\"US\\\",\\\"city\\\":\\\"Lafayette\\\",\\\"conf\\\":60,\\\"country_conf\\\":90,\\\"ctry\\\":\\\"United States\\\",\\\"ctx\\\":\\\"global\\\",\\\"dtime\\\":\\\"2013-07-10T18:38:52Z\\\",\\\"freq\\\":1,\\\"id\\\":\\\"id_current\\\",\\\"input\\\":\\\"ip\\\",\\\"lat\\\":40.424388885498,\\\"lon\\\":-86.808479309082,\\\"lvl\\\":1,\\\"rad\\\":15781,\\\"raw\\\":\\\"98.215.10.79\\\",\\\"sc\\\":\\\"IN\\\",\\\"src\\\":\\\"gt_locip\\\",\\\"state\\\":\\\"Indiana\\\",\\\"state_conf\\\":60,\\\"town_conf\\\":60,\\\"type\\\":\\\"physical\\\",\\\"woe\\\":12778444,\\\"woetype\\\":\\\"zip\\\",\\\"zip\\\":\\\"47905\\\",\\\"zip_conf\\\":60},\\\"defLocObj\\\":null,\\\"spaceId\\\":\\\"2143334674\\\",\\\"locale\\\":\\\"en-US\\\",\\\"lang\\\":\\\"US\\\",\\\"fpHost\\\":\\\"http:\\\\/\\\\/weather.yahoo.com\\\",\\\"unit\\\":\\\"f\\\"});\\u000a    });\\u000a    Y.later(10, this, function() {(function(){ var rapid = YMedia.rapid; if (rapid) { rapid.addModules(\\\"mediacontentweather\\\"); } }());\\u000a    });\\u000a});\\u000a});\\u000a\\u0009\\u0009\\u000a\\u0009    \\u003C/script\\u003E\\u000d\\u000a--dali-response-split-51ddaa3cb982c\\u000d\\u000aContent-Type: text/html; charset=utf-8\\u000d\\u000a\\u000d\\u000a \\u003Csection class=\\\"yom-mod yom-weather yom-app clearfix\\\" id=\\\"mediacontentweather\\\" data-ylk=\\\"mid:mediacontentweather;mpos:1;sec:app-wea;\\\"\\u003E  \\u003Cform id=\\\"fixIE10Enter\\\" onsubmit=\\\"return false;\\\"\\u003E \\u003Ch2 class=\\\"hide\\\"\\u003EWeather Today\\u003C/h2\\u003E  \\u003Cul\\u003E  \\u003Cli class=\\\"current clearfix\\\" data-uri=\\\"http://weather.yahoo.com/united-states/indiana/lafayette-12778444/\\\"\\u003E \\u003Ca href=\\\"http://weather.yahoo.com/united-states/indiana/lafayette-12778444/\\\" data-ylk=\\\"sec:app-wea;cpos:1;pos:2;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\"\\u003E \\u003Cimg src=\\\"http://l4.yimg.com/dh/ap/default/121210/8_IE6.png\\\" alt=\\\"Light Rain\\\" title=\\\"Light Rain\\\" class=\\\"cond-icon\\\"\\u003E \\u003C/a\\u003E \\u003Ch3 class=\\\"hd\\\"\\u003E \\u003Cp id=\\\"weather_lw_switch\\\"\\u003E \\u003Cspan class=\\\"ell\\\" title=\\\"Lafayette, IN\\\"\\u003ELafayette, IN\\u003C/span\\u003E \\u003Cspan id=\\\"ulw-start\\\"\\u003E&nbsp;\\u003C/span\\u003E\\u003C/p\\u003E \\u003Ca href=\\\"http://weather.yahoo.com/united-states/indiana/lafayette-12778444/\\\" class=\\\"cond\\\" data-ylk=\\\"sec:app-wea;cpos:1;pos:1;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\"\\u003E \\u003Cem class=\\\"temp temp-f \\\"\\u003E 70\\u003Cspan class=\\\"unit\\\"\\u003E&deg;F\\u003C/span\\u003E\\u003Cspan class=\\\"cond-title\\\"\\u003ELight Rain\\u003C/span\\u003E \\u003C/em\\u003E \\u003Cem class=\\\"temp temp-c hide\\\"\\u003E 21\\u003Cspan class=\\\"unit\\\"\\u003E&deg;C\\u003C/span\\u003E\\u003Cspan class=\\\"cond-title\\\"\\u003ELight Rain\\u003C/span\\u003E \\u003C/em\\u003E \\u003C/a\\u003E \\u003C/h3\\u003E \\u003C/li\\u003E   \\u003Cli class=\\\"forecast\\\"\\u003E \\u003Ca href=\\\"http://weather.yahoo.com/united-states/indiana/lafayette-12778444/\\\" data-ylk=\\\"sec:app-wea;cpos:2;pos:1;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\"\\u003E \\u003Cimg src=\\\"http://l4.yimg.com/dh/ap/default/121210/8_IE6.png\\\" alt=\\\"\\\" class=\\\"cond-icon\\\"\\u003E \\u003C/a\\u003E \\u003Ch3 class=\\\"hd\\\"\\u003E \\u003Ca href=\\\"http://weather.yahoo.com/united-states/indiana/lafayette-12778444/\\\" class=\\\"ell\\\" data-ylk=\\\"sec:app-wea;cpos:2;pos:2;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\"\\u003EToday\\u003C/a\\u003E \\u003Ca href=\\\"http://weather.yahoo.com/united-states/indiana/lafayette-12778444/\\\" class=\\\"temp temp-f \\\" data-ylk=\\\"sec:app-wea;cpos:2;pos:3;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\"\\u003E \\u003Cspan class=\\\"high\\\"\\u003E84&deg;\\u003C/span\\u003E \\u003Cspan class=\\\"low\\\"\\u003E60&deg;\\u003C/span\\u003E \\u003C/a\\u003E \\u003Ca href=\\\"http://weather.yahoo.com/united-states/indiana/lafayette-12778444/\\\" class=\\\"temp temp-c hide\\\" data-ylk=\\\"sec:app-wea;cpos:2;pos:3;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\"\\u003E \\u003Cspan class=\\\"high\\\"\\u003E29&deg;\\u003C/span\\u003E \\u003Cspan class=\\\"low\\\"\\u003E16&deg;\\u003C/span\\u003E \\u003C/a\\u003E \\u003C/h3\\u003E \\u003C/li\\u003E  \\u003Cli class=\\\"forecast\\\"\\u003E \\u003Ca href=\\\"http://weather.yahoo.com/united-states/indiana/lafayette-12778444/\\\" data-ylk=\\\"sec:app-wea;cpos:3;pos:1;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\"\\u003E \\u003Cimg src=\\\"http://l4.yimg.com/dh/ap/default/121210/33_IE6.png\\\" alt=\\\"\\\" class=\\\"cond-icon\\\"\\u003E \\u003C/a\\u003E \\u003Ch3 class=\\\"hd\\\"\\u003E \\u003Ca href=\\\"http://weather.yahoo.com/united-states/indiana/lafayette-12778444/\\\" class=\\\"ell\\\" data-ylk=\\\"sec:app-wea;cpos:3;pos:2;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\"\\u003ETomorrow\\u003C/a\\u003E \\u003Ca href=\\\"http://weather.yahoo.com/united-states/indiana/lafayette-12778444/\\\" class=\\\"temp temp-f \\\" data-ylk=\\\"sec:app-wea;cpos:3;pos:3;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\"\\u003E \\u003Cspan class=\\\"high\\\"\\u003E81&deg;\\u003C/span\\u003E \\u003Cspan class=\\\"low\\\"\\u003E55&deg;\\u003C/span\\u003E \\u003C/a\\u003E \\u003Ca href=\\\"http://weather.yahoo.com/united-states/indiana/lafayette-12778444/\\\" class=\\\"temp temp-c hide\\\" data-ylk=\\\"sec:app-wea;cpos:3;pos:3;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\"\\u003E \\u003Cspan class=\\\"high\\\"\\u003E27&deg;\\u003C/span\\u003E \\u003Cspan class=\\\"low\\\"\\u003E13&deg;\\u003C/span\\u003E \\u003C/a\\u003E \\u003C/h3\\u003E \\u003C/li\\u003E  \\u003Cli class=\\\"forecast\\\"\\u003E \\u003Ca href=\\\"http://weather.yahoo.com/united-states/indiana/lafayette-12778444/\\\" data-ylk=\\\"sec:app-wea;cpos:4;pos:1;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\"\\u003E \\u003Cimg src=\\\"http://l4.yimg.com/dh/ap/default/121210/31_IE6.png\\\" alt=\\\"\\\" class=\\\"cond-icon\\\"\\u003E \\u003C/a\\u003E \\u003Ch3 class=\\\"hd\\\"\\u003E \\u003Ca href=\\\"http://weather.yahoo.com/united-states/indiana/lafayette-12778444/\\\" class=\\\"ell\\\" data-ylk=\\\"sec:app-wea;cpos:4;pos:2;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\"\\u003EFriday\\u003C/a\\u003E \\u003Ca href=\\\"http://weather.yahoo.com/united-states/indiana/lafayette-12778444/\\\" class=\\\"temp temp-f \\\" data-ylk=\\\"sec:app-wea;cpos:4;pos:3;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\"\\u003E \\u003Cspan class=\\\"high\\\"\\u003E79&deg;\\u003C/span\\u003E \\u003Cspan class=\\\"low\\\"\\u003E57&deg;\\u003C/span\\u003E \\u003C/a\\u003E \\u003Ca href=\\\"http://weather.yahoo.com/united-states/indiana/lafayette-12778444/\\\" class=\\\"temp temp-c hide\\\" data-ylk=\\\"sec:app-wea;cpos:4;pos:3;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\"\\u003E \\u003Cspan class=\\\"high\\\"\\u003E26&deg;\\u003C/span\\u003E \\u003Cspan class=\\\"low\\\"\\u003E14&deg;\\u003C/span\\u003E \\u003C/a\\u003E \\u003C/h3\\u003E \\u003C/li\\u003E  \\u003C/ul\\u003E   \\u003C/form\\u003E \\u003Cdiv class=\\\"weather_credit\\\"\\u003E \\u003Cspan class=\\\"weather_credit_text\\\"\\u003EPowered by\\u003C/span\\u003E \\u003Ca href=\\\"http://www.weather.com\\\" class=\\\"twc_icon\\\"\\u003E \\u003Cspan class=\\\"weather_twc_icon\\\"/\\u003E\\u003C/span\\u003E \\u003C/a\\u003E \\u003C/div\\u003E \\u003C/section\\u003E\\u000a\\u000d\\u000a--dali-response-split-51ddaa3cb982c--\\u000d\\u000a\"\n                        });\n                    })));\n                })())\n            },]);\n        })));\n    })()));\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};\n\ntry {\n    ((JSBNG_Record.scriptLoad)((\"YMedia.use(\\\"media-rmp\\\", function(Y) {\\u000a    Y.Media.RMP.load({\\u000a        srcNode: \\\"#p_30345786_container\\\",\\u000a        continueOnError: true,\\u000a        response: \\\"--dali-response-split-51ddaa3c96973Content-Type: text/plain; charset=utf-8\\\\u000aRMP-Embed-Location: top\\\\u000a\\\\u000a\\\\u000a\\\\u003Clink rel=\\\\\\\"stylesheet\\\\\\\" type=\\\\\\\"text/css\\\\\\\" href=\\\\\\\"http://l.yimg.com/zz/combo?nn/lib/metro/g/ui/helpers_0.0.6.css&nn/lib/metro/g/ui/typography_0.0.2.css&nn/lib/metro/g/theme/default/common_0.0.29.css&nn/lib/metro/g/theme/default/desktop_0.0.62.css&nn/lib/metro/g/uiplugins/tooltip_service_1.0.12.css\\\\\\\" /\\\\u003E\\\\u000a\\\\u000a\\\\u003Clink rel=\\\\\\\"stylesheet\\\\\\\" type=\\\\\\\"text/css\\\\\\\" href=\\\\\\\"http://l.yimg.com/zz/combo?nn/lib/metro/g/stream/stream_0.0.271.css&nn/lib/metro/g/stream/theme_gs_0.0.45.css&nn/lib/metro/g/uiplugins/login_service_0.0.3.css&nn/lib/metro/g/stream/rmx_ads_0.0.8.css&nn/lib/metro/g/fstream/fstream_desktop_0.0.21.css&nn/lib/metro/g/login/login_0.0.71.css\\\\\\\" /\\\\u003E\\\\u000a\\\\u000a--dali-response-split-51ddaa3c96973Content-Type: text/html; charset=utf-8\\\\u000aRMP-Embed-Location: bottom\\\\u000a\\\\u000a\\\\u003Cdiv id=\\\\\\\"p_30345786\\\\\\\" class=\\\\\\\"rapidnofollow rapid-container dev-desktop\\\\\\\" data-ylk=\\\\\\\"sec:td-strm\\\\\\\"\\\\u003E\\\\u000a\\\\u003Cdiv id=\\\\\\\"default-u_30345786\\\\\\\" class=\\\\\\\"mod view_default\\\\\\\"\\\\u003E  \\\\u003Cdiv id=\\\\\\\"default-u_30345786-bd\\\\\\\" class=\\\\\\\"bd type_stream type_stream_default\\\\\\\"\\\\u003E\\\\u003Cdiv id=\\\\\\\"default-p_30345810_eab\\\\\\\" class=\\\\\\\"mod view_default\\\\\\\"\\\\u003E  \\\\u003Cdiv id=\\\\\\\"default-p_30345810_eab-bd\\\\\\\" class=\\\\\\\"bd type_fstream type_fstream_default\\\\\\\"\\\\u003E\\\\u003Cstyle\\\\u003E .type_fstream .dropdown-label-text, .type_fstream .tab-list .filter-item .filter-name, .type_fstream .filter-bar-section { background-color:#0e2b5c !important;border:solid 1px #0e2b5c !important;color:#fff !important } .type_fstream .tab-list .filter-item { opacity: 0.7; -ms-filter:\\\\\\\"progid:DXImageTransform.Microsoft.Alpha(Opacity=70)\\\\\\\"; filter: alpha(opacity=70); }.type_fstream .tab-list .filter-selected { opacity: 1; -ms-filter:\\\\\\\"progid:DXImageTransform.Microsoft.Alpha(Opacity=100)\\\\\\\"; filter: alpha(opacity=100); }\\\\u003C/style\\\\u003E\\\\u003Cdiv class=\\\\\\\"filter-bar-section\\\\\\\"\\\\u003E\\\\u003Cul class=\\\\\\\"tab-list d-ib fz-xs pos-r\\\\\\\"\\\\u003E\\\\u003Cli class=\\\\\\\"filter-item d-ib\\\\\\\" data-filter=\\\\\\\"\\\\\\\"\\\\u003E\\\\u000a    \\\\u003Ca href=\\\\\\\"#\\\\\\\" data-ylk=\\\\\\\"sec:fltr-strm;slk:YPROP:TOPSTORIES;cpos:1;pos:0;ft:1\\\\\\\"  data-action-outcome=\\\\\\\"filter\\\\\\\" class=\\\\\\\"filter-name rapidnofollow fz-s\\\\\\\" role=\\\\\\\"button\\\\\\\"\\\\u003EAll News\\\\u003C/a\\\\u003E\\\\u000a\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"filter-item d-ib\\\\\\\" data-filter=\\\\\\\"LISTID:c435b248-2107-445e-97ea-89e2ec5df60c\\\\\\\"\\\\u003E\\\\u000a    \\\\u003Ca href=\\\\\\\"#\\\\\\\" data-ylk=\\\\\\\"sec:fltr-strm;slk:LISTID:c435b248-2107-445e-97ea-89e2ec5df60c;cpos:2;pos:0;ft:1\\\\\\\"  data-action-outcome=\\\\\\\"filter\\\\\\\" class=\\\\\\\"filter-name rapidnofollow fz-s\\\\\\\" role=\\\\\\\"button\\\\\\\"\\\\u003EY! News Originals\\\\u003C/a\\\\u003E\\\\u000a\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"filter-item d-ib\\\\\\\" data-filter=\\\\\\\"YPROV:ABCNEWS\\\\\\\"\\\\u003E\\\\u000a    \\\\u003Ca href=\\\\\\\"#\\\\\\\" data-ylk=\\\\\\\"sec:fltr-strm;slk:YPROV:ABCNEWS;cpos:3;pos:0;ft:1\\\\\\\"  data-action-outcome=\\\\\\\"filter\\\\\\\" class=\\\\\\\"filter-name rapidnofollow fz-s\\\\\\\" role=\\\\\\\"button\\\\\\\"\\\\u003EABC News\\\\u003C/a\\\\u003E\\\\u000a\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"filter-item d-ib\\\\\\\" data-filter=\\\\\\\"YPROV:ap.org\\\\\\\"\\\\u003E\\\\u000a    \\\\u003Ca href=\\\\\\\"#\\\\\\\" data-ylk=\\\\\\\"sec:fltr-strm;slk:YPROV:ap.org;cpos:4;pos:0;ft:1\\\\\\\"  data-action-outcome=\\\\\\\"filter\\\\\\\" class=\\\\\\\"filter-name rapidnofollow fz-s\\\\\\\" role=\\\\\\\"button\\\\\\\"\\\\u003EAP\\\\u003C/a\\\\u003E\\\\u000a\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"filter-item d-ib\\\\\\\" data-filter=\\\\\\\"YPROV:reuters.com\\\\\\\"\\\\u003E\\\\u000a    \\\\u003Ca href=\\\\\\\"#\\\\\\\" data-ylk=\\\\\\\"sec:fltr-strm;slk:YPROV:reuters.com;cpos:5;pos:0;ft:1\\\\\\\"  data-action-outcome=\\\\\\\"filter\\\\\\\" class=\\\\\\\"filter-name rapidnofollow fz-s\\\\\\\" role=\\\\\\\"button\\\\\\\"\\\\u003EReuters\\\\u003C/a\\\\u003E\\\\u000a\\\\u003C/li\\\\u003E\\\\u003C/ul\\\\u003E\\\\u003C/div\\\\u003E    \\\\u003C/div\\\\u003E\\\\u000a\\\\u003C/div\\\\u003E\\\\u003Cul\\\\u003E\\\\u003Cli class=\\\\\\\"content has-image voh-parent cf\\\\\\\" data-uuid=\\\\\\\"a2b156e2-bdc5-3dab-bf3c-241d681ef099\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:1;pkgt:4;ccode:news;g:a2b156e2-bdc5-3dab-bf3c-241d681ef099;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fnews.yahoo.com%2Fexpert-zimmerman-worse-shape-martin-144959889.html\\\\\\\" data-wikiids=\\\\\\\"YCT:001000667|YCT:001000780|WIKIID:Shooting_of_Trayvon_Martin\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\"img ov-h thumb-left  \\\\\\\" href=\\\\\\\"/expert-zimmerman-worse-shape-martin-144959889.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:1;g:a2b156e2-bdc5-3dab-bf3c-241d681ef099;tar:news.yahoo.com;ltxt:Expert:Z;ct:1;pkgt:4;r:4100002718;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" tabindex=\\\\\\\"-1\\\\\\\"\\\\u003E\\\\u003Cimg src=\\\\\\\"http://l.yimg.com/os/mit/media/m/base/images/transparent-95031.png\\\\\\\" style=\\\\\\\"margin-left:-15px;background-image:url('http://l1.yimg.com/ts/api/res/1.2/XITng7YWKM1CwU3GfV_RdA--/YXBwaWQ9eWhvbWVydW47cT04NTtzbT0xO3c9MjUwO2g9MTg1/http://media.zenfs.com/en_us/News/ap_webfeeds/d475fdac10c72e17370f6a706700275c.jpg');\\\\\\\" width=\\\\\\\"111\\\\\\\" height=\\\\\\\"82\\\\\\\" alt=\\\\\\\"\\\\\\\" title=\\\\\\\"\\\\\\\" class=\\\\\\\"lzbg\\\\\\\"\\\\u003E\\\\u003C/a\\\\u003E\\\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\\\u003E\\\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"/expert-zimmerman-worse-shape-martin-144959889.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:1;g:a2b156e2-bdc5-3dab-bf3c-241d681ef099;tar:news.yahoo.com;ltxt:Expert:Z;ct:1;pkgt:4;r:4100002718;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\\\u003EExpert: Zimmerman was in worse shape than Martin\\\\u003C/a\\\\u003E\\\\u003C/h3\\\\u003E\\\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\\\u003ESANFORD, Fla. (AP) \\\\u2014 A Florida judge ruled Wednesday that Trayvon Martin&#39;s cellphone text messages about fighting and a defense animation depicting the struggle between Martin and George Zimmerman won&#39;t be introduced as evidence at Zimmerman&#39;s trial. Defense attorneys had wanted to use those pieces\\\\u2026\\\\u003C/p\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\\\u003E\\\\u003Cspan class=\\\\\\\"source\\\\\\\"\\\\u003EAssociated Press\\\\u003C/span\\\\u003E\\\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\\\u003E\\\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\\\u003E\\\\u003Ca href=\\\\\\\"http://news.yahoo.com/society-and-culture/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"YCT:001000780\\\\\\\" data-ylk=\\\\\\\"slk:Society;sec:td-strm;cpos:1;itc:0;g:a2b156e2-bdc5-3dab-bf3c-241d681ef099;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\\\u003ESociety\\\\u003C/a\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\\\u003E\\\\u003Ca href=\\\\\\\"http://www.yahoo.com/topic/shooting-of-trayvon-martin/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"WIKIID:Shooting_of_Trayvon_Martin\\\\\\\" data-ylk=\\\\\\\"slk:Shooting of Trayvon Martin;sec:td-strm;cpos:2;itc:0;g:a2b156e2-bdc5-3dab-bf3c-241d681ef099;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\\\u003EShooting of Trayvon Martin\\\\u003C/a\\\\u003E\\\\u003C/li\\\\u003E\\\\u003C/ul\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\\\u003E\\\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\\\u003ERemove\\\\u003C/button\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"content voh-parent cf\\\\\\\" data-uuid=\\\\\\\"359b4757-f472-3d49-a211-389223ffe98a\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:2;pkgt:3;ccode:news;g:359b4757-f472-3d49-a211-389223ffe98a;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fnews.yahoo.com%2Fgop-remember-data-show-immigrants-enforce-not-threaten-171614860.html\\\\\\\" data-wikiids=\\\\\\\"YCT:001000661|YCT:001000700|WIKIID:Culture_of_the_United_States\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\\\u003E\\\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"/gop-remember-data-show-immigrants-enforce-not-threaten-171614860.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:2;g:359b4757-f472-3d49-a211-389223ffe98a;tar:news.yahoo.com;ltxt:GOPshoul;ct:1;pkgt:3;r:4100001700;slk:title;itc:0;prov:ChristianScience;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\\\u003EGOP should remember: Data show immigrants enforce, not threaten, US values\\\\u003C/a\\\\u003E\\\\u003C/h3\\\\u003E\\\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\\\u003EA comprehensive immigration reform bill has passed the Senate, but it faces dubious prospects in the House, where it probably won\\\\u2019t garner enough of the Republican support needed to bring it to a floor vote. One Republican sticking point is that the prospective law doesn\\\\u2019t go far enough to ensure\\\\u2026\\\\u003C/p\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\\\u003E\\\\u003Cspan class=\\\\\\\"source\\\\\\\"\\\\u003EChristian Science Monitor\\\\u003C/span\\\\u003E\\\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\\\u003E\\\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\\\u003E\\\\u003Ca href=\\\\\\\"http://news.yahoo.com/politics-and-government/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"YCT:001000661\\\\\\\" data-ylk=\\\\\\\"slk:Politics;sec:td-strm;cpos:1;itc:0;g:359b4757-f472-3d49-a211-389223ffe98a;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\\\u003EPolitics\\\\u003C/a\\\\u003E\\\\u003C/li\\\\u003E\\\\u003C/ul\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\\\u003E\\\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\\\u003ERemove\\\\u003C/button\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"content rmx-ad has-image voh-parent cf\\\\\\\" data-uuid=\\\\\\\"21671635\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:3;pkgt:4;ccode:news;g:21671635;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fad.yieldmanager.com%2Fclk%3F3%2CeJytjd8KgjAYxV.Ii03d3BhdTKdi6SxahZfDP0NNghCknr40qRfoB-fjHL4DBzoM4NrTutIexLTGoGTQaUpag6aqkAUYY7ZHMfIQocTiM3syHiah7v3NX7I4SjXxD-Yt3wRrb76hcHZar--z7Q.8LwR0y5PVJ8uuEYSj5mkeivjfWly4mS1bKUI3vZxQHhdjpqJr1sJWdiVKVTjJjoNiiIZcyF7-BjaWBV6lHk77%2Chttp%253A%252F%252Fad.doubleclick.net%252Fclk%253B274020025%253B100435305%253Be%253Fhttp%253A%252F%252Fspectrum2.pch.com%252FPath%252FJulyTV2013SitespectControl%252FStart.aspx%253Ftid%253D7e9b938d-f8ce-489a-bdef-81f419556b96%2526utm_source%253DYahoo%2526utm_medium%253Dcpc%2526utm_campaign%253DYahoo_Stream_Ad15\\\\\\\" data-wikiids=\\\\\\\"\\\\\\\" data-rmx-beacon=\\\\\\\"http://ad.yieldmanager.com/csc?ve=2&1hrw95l2wp0XrFYnLhJqzLriWXhdDwpnt4Kf8wPuQSdLFrDaBJiYaKu9f1YrQOidHRIOdpedQRTCvjgtn02eC7Z.kUCxocI7GY.iTTTyz1z9dQiud2A_gKVQ6OIxOTIR5cFUThlHzJQWkyL5X1ciNIdkmpatnBHwKLAKPqs6I_4yWYRJTXbVPyik7I1NKh.tyFCWf1UkfkF2Sgq.gXbfEHQYDwxYJbqQyzukOp0e8wvfBzwRHGSEex.SIRDn1Qvd_bYkVW3v52haZ5uXOsSaZxkj7hZd4sQq61ZJQb7DH8gwceeen.qgGa_LfI8XVDHpJTbx4rQ6ElpR9lwZUJjGbvvYdIiS06cOu.oZZzRJIShdNUTlN4USP27Qs8zP7eUC6e3.yYlPsePXNnYWBzrfkA.qZBIK6Wmj8AJaB5Q__6zTcGJs6mPBDjJLQ7VDfm52vpQADTT3RIcQy40cepLkw2TeLCCI3vHJgpDQPvDYw9BOF9_pamfg7Yp0On6SlPTv28c.iqT6.oMcn9nGoiTHgT336BzgkFd.9XUZVVEvXNhIjGTa0iWtdrqWkLHs8Qol7MNcNxfD.Or_gkholvmdAG6lb6__Al.Py2gFkLbWJ.Xoet5wOI7Lo0KaeLXCUpTNEmklwkYhxsNLaRk8Jb0R7zZNita2HETQb92McUTc15px6SBP983kJetQ8RMGEa1xvgIF_FmQoXR2sSCblmyfouYyDMCAZl3pj4_Ij4JD3zgwGp4rj3SCBMx_FWfD9Wr7wl3sCrjXTxu0n079i2LlbGeeq3tdEPjpZMypM.GozXdvMRIkndXbIihqK9iPM.MJlw--&ap=3\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\"img ov-h thumb-left  \\\\\\\" href=\\\\\\\"http://ad.yieldmanager.com/clk?3,eJytjd8KgjAYxV.Ii03d3BhdTKdi6SxahZfDP0NNghCknr40qRfoB-fjHL4DBzoM4NrTutIexLTGoGTQaUpag6aqkAUYY7ZHMfIQocTiM3syHiah7v3NX7I4SjXxD-Yt3wRrb76hcHZar--z7Q.8LwR0y5PVJ8uuEYSj5mkeivjfWly4mS1bKUI3vZxQHhdjpqJr1sJWdiVKVTjJjoNiiIZcyF7-BjaWBV6lHk77,http%3A%2F%2Fad.doubleclick.net%2Fclk%3B274020025%3B100435305%3Be%3Fhttp%3A%2F%2Fspectrum2.pch.com%2FPath%2FJulyTV2013SitespectControl%2FStart.aspx%3Ftid%3D7e9b938d-f8ce-489a-bdef-81f419556b96%26utm_source%3DYahoo%26utm_medium%3Dcpc%26utm_campaign%3DYahoo_Stream_Ad15\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:3;g:21671635;tar:ad.yieldmanager.com;ltxt:$5,000aW;ct:1;pkgt:4;ad:1;slk:title;itc:0;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" target=\\\\\\\"_blank\\\\\\\" tabindex=\\\\\\\"-1\\\\\\\"\\\\u003E\\\\u003Cimg src=\\\\\\\"http://l.yimg.com/os/mit/media/m/base/images/transparent-95031.png\\\\\\\" style=\\\\\\\"background-image:url('http://l5.yimg.com/av/moneyball/ads/0-1372704499-6168.jpg');\\\\\\\" width=\\\\\\\"82\\\\\\\" height=\\\\\\\"82\\\\\\\" alt=\\\\\\\"\\\\\\\" title=\\\\\\\"\\\\\\\" class=\\\\\\\"lzbg\\\\\\\"\\\\u003E\\\\u003C/a\\\\u003E\\\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\\\u003E\\\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"http://ad.yieldmanager.com/clk?3,eJytjd8KgjAYxV.Ii03d3BhdTKdi6SxahZfDP0NNghCknr40qRfoB-fjHL4DBzoM4NrTutIexLTGoGTQaUpag6aqkAUYY7ZHMfIQocTiM3syHiah7v3NX7I4SjXxD-Yt3wRrb76hcHZar--z7Q.8LwR0y5PVJ8uuEYSj5mkeivjfWly4mS1bKUI3vZxQHhdjpqJr1sJWdiVKVTjJjoNiiIZcyF7-BjaWBV6lHk77,http%3A%2F%2Fad.doubleclick.net%2Fclk%3B274020025%3B100435305%3Be%3Fhttp%3A%2F%2Fspectrum2.pch.com%2FPath%2FJulyTV2013SitespectControl%2FStart.aspx%3Ftid%3D7e9b938d-f8ce-489a-bdef-81f419556b96%26utm_source%3DYahoo%26utm_medium%3Dcpc%26utm_campaign%3DYahoo_Stream_Ad15\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:3;g:21671635;tar:ad.yieldmanager.com;ltxt:$5,000aW;ct:1;pkgt:4;ad:1;slk:title;itc:0;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" target=\\\\\\\"_blank\\\\\\\"\\\\u003E$5,000 a Week &quot;Forever&quot; Contest \\\\u003C/a\\\\u003E\\\\u003C/h3\\\\u003E\\\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\\\u003EPass Your Prize To Your Loved Ones. Don't Wait, Enter Now at PCH.com! \\\\u003C/p\\\\u003E\\\\u003Ca class=\\\\\\\"adlink fz-xxs rapid-noclick-resp\\\\\\\" href=\\\\\\\"http://info.yahoo.com/privacy/us/yahoo/adinfo_geo.html\\\\\\\" target=\\\\\\\"_blank\\\\\\\"\\\\u003EAdChoices\\\\u003Ci class=\\\\\\\"img-sprite\\\\\\\"\\\\u003E\\\\u003C/i\\\\u003E\\\\u003C/a\\\\u003E\\\\u000a\\\\u003Ca class=\\\\\\\"fz-xxs adv rapid-noclick-resp\\\\\\\" href=\\\\\\\"http://ad.yieldmanager.com/clk?3,eJytjd8KgjAYxV.Ii03d3BhdTKdi6SxahZfDP0NNghCknr40qRfoB-fjHL4DBzoM4NrTutIexLTGoGTQaUpag6aqkAUYY7ZHMfIQocTiM3syHiah7v3NX7I4SjXxD-Yt3wRrb76hcHZar--z7Q.8LwR0y5PVJ8uuEYSj5mkeivjfWly4mS1bKUI3vZxQHhdjpqJr1sJWdiVKVTjJjoNiiIZcyF7-BjaWBV6lHk77,http%3A%2F%2Fad.doubleclick.net%2Fclk%3B274020025%3B100435305%3Be%3Fhttp%3A%2F%2Fspectrum2.pch.com%2FPath%2FJulyTV2013SitespectControl%2FStart.aspx%3Ftid%3D7e9b938d-f8ce-489a-bdef-81f419556b96%26utm_source%3DYahoo%26utm_medium%3Dcpc%26utm_campaign%3DYahoo_Stream_Ad15\\\\\\\" target=\\\\\\\"_blank\\\\\\\"\\\\u003E\\\\u003Cspan class=\\\\\\\"source\\\\\\\"\\\\u003EPCH.com\\\\u003C/span\\\\u003E\\\\u003C/a\\\\u003E\\\\u003Ca href=\\\\\\\"http://help.yahoo.com/kb/index?page=content&y=PROD_FRONT&locale=en_US&id=SLN14553\\\\\\\" class=\\\\\\\"fz-xxs sp rapid-noclick-resp\\\\\\\" target=\\\\\\\"_blank\\\\\\\"\\\\u003ESponsored\\\\u003C/a\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\\\u003E\\\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\\\u003E\\\\u003C/ul\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"content voh-parent cf\\\\\\\" data-uuid=\\\\\\\"950129f1-e974-33ae-b739-227b6ca2e187\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:4;pkgt:3;ccode:news;g:950129f1-e974-33ae-b739-227b6ca2e187;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fnews.yahoo.com%2Fblogs%2Ftrending-now%2Ftoddler-buys-car-ebay-using-father-smartphone-172026670.html\\\\\\\" data-wikiids=\\\\\\\"\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\\\u003E\\\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"/blogs/trending-now/toddler-buys-car-ebay-using-father-smartphone-172026670.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:4;g:950129f1-e974-33ae-b739-227b6ca2e187;tar:news.yahoo.com;ltxt:ToddlerB;ct:2;pkgt:3;r:4100001324;slk:title;itc:0;prov:TrendingNow;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\\\u003EToddler Buys Car on eBay Using Father\\\\u2019s Smartphone\\\\u003C/a\\\\u003E\\\\u003C/h3\\\\u003E\\\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\\\u003ELast month Sorella Stoute from Portland, Oregon, purchased a 1962 Austin-Healey Sprite on eBay. Now, this might not sound like much of a story, until you learn that Sorella is only 14 months old. Here&#39;s what happened. The tiny online shopper was playing with her father Paul Stoute&#39;s smartphone when\\\\u2026\\\\u003C/p\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\\\u003E\\\\u003Cspan class=\\\\\\\"source\\\\\\\"\\\\u003ETrending Now\\\\u003C/span\\\\u003E\\\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\\\u003E\\\\u003C/ul\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\\\u003E\\\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\\\u003ERemove\\\\u003C/button\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"content voh-parent cf\\\\\\\" data-uuid=\\\\\\\"a5d908b7-4f0c-3334-81a0-3d378bbeb520\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:5;pkgt:3;ccode:news;g:a5d908b7-4f0c-3334-81a0-3d378bbeb520;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fnews.yahoo.com%2Fntsb-findings-sf-plane-crash-133726993.html\\\\\\\" data-wikiids=\\\\\\\"YCT:001000346|YCT:001000992\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\\\u003E\\\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"/ntsb-findings-sf-plane-crash-133726993.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:5;g:a5d908b7-4f0c-3334-81a0-3d378bbeb520;tar:news.yahoo.com;ltxt:NTSBfind;ct:1;pkgt:3;r:4100001409;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\\\u003ENTSB findings on SF plane crash at a glance\\\\u003C/a\\\\u003E\\\\u003C/h3\\\\u003E\\\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\\\u003EAfter departing from Shanghai and stopping in Seoul, Asiana Flight 214 makes its final approach into San Francisco International Airport following a 10-hour flight across the Pacific Ocean. A preliminary ...\\\\u003C/p\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\\\u003E\\\\u003Cspan class=\\\\\\\"source\\\\\\\"\\\\u003EAssociated Press\\\\u003C/span\\\\u003E\\\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\\\u003E\\\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\\\u003E\\\\u003Ca href=\\\\\\\"http://news.yahoo.com/personal-investing-ideas-and-strategies/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"YCT:001000346\\\\\\\" data-ylk=\\\\\\\"slk:Personal Investing Ideas & Strategies;sec:td-strm;cpos:1;itc:0;g:a5d908b7-4f0c-3334-81a0-3d378bbeb520;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\\\u003EPersonal Investing Ideas & Strategies\\\\u003C/a\\\\u003E\\\\u003C/li\\\\u003E\\\\u003C/ul\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\\\u003E\\\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\\\u003ERemove\\\\u003C/button\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"content voh-parent cf\\\\\\\" data-uuid=\\\\\\\"fe94cddd-d36b-3ce5-9246-733c1229ba93\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:6;pkgt:3;ccode:news;g:fe94cddd-d36b-3ce5-9246-733c1229ba93;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fgma.yahoo.com%2Fblogs%2Fabc-blogs%2Froyal-baby-american-british-birthing-practices-differ-115918234.html\\\\\\\" data-wikiids=\\\\\\\"YCT:001000395|YCT:001000495\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\\\u003E\\\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"http://gma.yahoo.com/blogs/abc-blogs/royal-baby-american-british-birthing-practices-differ-115918234.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:6;g:fe94cddd-d36b-3ce5-9246-733c1229ba93;tar:gma.yahoo.com;ltxt:HowKate&;ct:2;pkgt:3;r:4100001177;slk:title;itc:0;prov:ABCNews;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\\\u003EHow Kate&#39;s Delivery Will Differ From U.S. Experience\\\\u003C/a\\\\u003E\\\\u003C/h3\\\\u003E\\\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\\\u003EThe future British monarch is due to be born any day now. Kate Middleton will deliver her child at Mary\\\\u2019s Hospital in London, in the same wing where Princess Diana gave birth to her own children. \\\\u201cIt\\\\u2019s a beautiful unit,\\\\u201d Regina Curran, a British midwife,...\\\\u003C/p\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\\\u003E\\\\u003Cspan class=\\\\\\\"source\\\\\\\"\\\\u003EABC News\\\\u003C/span\\\\u003E\\\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\\\u003E\\\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\\\u003E\\\\u003Ca href=\\\\\\\"http://news.yahoo.com/health/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"YCT:001000395\\\\\\\" data-ylk=\\\\\\\"slk:Health;sec:td-strm;cpos:1;itc:0;g:fe94cddd-d36b-3ce5-9246-733c1229ba93;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\\\u003EHealth\\\\u003C/a\\\\u003E\\\\u003C/li\\\\u003E\\\\u003C/ul\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\\\u003E\\\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\\\u003ERemove\\\\u003C/button\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"content voh-parent cf\\\\\\\" data-uuid=\\\\\\\"8714ae80-beb0-39b6-9ee1-bd13ffb3f5c5\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:7;pkgt:3;ccode:news;g:8714ae80-beb0-39b6-9ee1-bd13ffb3f5c5;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fgma.yahoo.com%2Fblogs%2Fabc-blogs%2Fprince-william-play-polo-while-nine-months-pregnant-150649675.html\\\\\\\" data-wikiids=\\\\\\\"YCT:001000069|YCT:001000070|WIKIID:Prince_Harry_of_Wales|WIKIID:Kensington_Palace\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\\\u003E\\\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"http://gma.yahoo.com/blogs/abc-blogs/prince-william-play-polo-while-nine-months-pregnant-150649675.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:7;g:8714ae80-beb0-39b6-9ee1-bd13ffb3f5c5;tar:gma.yahoo.com;ltxt:PrinceWi;ct:2;pkgt:3;r:4100000846;slk:title;itc:0;prov:ABCNews;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\\\u003EPrince William to Play Polo While Nine-Months-Pregnant Kate Waits\\\\u003C/a\\\\u003E\\\\u003C/h3\\\\u003E\\\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\\\u003EPrince William has plans this weekend, but they don\\\\u2019t include a hospital. While his nine-months-pregnant wife, Kate, stays back home at the couple\\\\u2019s Kensington Palace home, Prince William will go ahead with plans to play in a charity polo match Sunday in Glouchestershire, nearly 100...\\\\u003C/p\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\\\u003E\\\\u003Cspan class=\\\\\\\"source\\\\\\\"\\\\u003EABC News\\\\u003C/span\\\\u003E\\\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\\\u003E\\\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\\\u003E\\\\u003Ca href=\\\\\\\"http://news.yahoo.com/celebrities/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"YCT:001000069\\\\\\\" data-ylk=\\\\\\\"slk:Celebrities;sec:td-strm;cpos:1;itc:0;g:8714ae80-beb0-39b6-9ee1-bd13ffb3f5c5;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\\\u003ECelebrities\\\\u003C/a\\\\u003E\\\\u003C/li\\\\u003E\\\\u003C/ul\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\\\u003E\\\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\\\u003ERemove\\\\u003C/button\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"content cavideo has-image voh-parent cf\\\\\\\" data-uuid=\\\\\\\"04cc60e0-a193-3352-8e5c-ff896228e590\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:8;pkgt:4;ccode:news;g:04cc60e0-a193-3352-8e5c-ff896228e590;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fnews.yahoo.com%2Fvideo%2Fmajor-setback-defense-george-zimmerman-161228577.html\\\\\\\" data-wikiids=\\\\\\\"\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\"img ov-h thumb-left  \\\\\\\" href=\\\\\\\"/video/major-setback-defense-george-zimmerman-161228577.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:8;g:04cc60e0-a193-3352-8e5c-ff896228e590;tar:news.yahoo.com;ltxt:Majorset;ct:3;pkgt:4;r:4100001232;slk:title;itc:0;prov:WABC\\\\u2013NY;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" tabindex=\\\\\\\"-1\\\\\\\"\\\\u003E\\\\u003Cimg src=\\\\\\\"http://l.yimg.com/os/mit/media/m/base/images/transparent-95031.png\\\\\\\" style=\\\\\\\"margin-left:-32px;background-image:url('http://l3.yimg.com/ts/api/res/1.2/3aHYmihw4JqFgqXUDpm5bA--/YXBwaWQ9eWhvbWVydW47cT04NTtzbT0xO3c9MjUwO2g9MTQx/http://media.zenfs.com/en-US/video/video.wabc.abc.news.com/10a5262f6a2220ce4bf4830c048b3257');\\\\\\\" width=\\\\\\\"145\\\\\\\" height=\\\\\\\"82\\\\\\\" alt=\\\\\\\"\\\\\\\" title=\\\\\\\"\\\\\\\" class=\\\\\\\"lzbg\\\\\\\"\\\\u003E\\\\u003Cspan class=\\\\\\\"icon-overlay\\\\\\\"\\\\u003E\\\\u003Cspan class=\\\\\\\"video-icon d-ib\\\\\\\"\\\\u003E\\\\u003Ci class=\\\\\\\"icon-sprite\\\\\\\"\\\\u003E\\\\u003C/i\\\\u003E \\\\u003Cspan class=\\\\\\\"play-now fz-xxs\\\\\\\"\\\\u003EPlay\\\\u003C/span\\\\u003E\\\\u003C/span\\\\u003E\\\\u003C/span\\\\u003E\\\\u003C/a\\\\u003E\\\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\\\u003E\\\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"/video/major-setback-defense-george-zimmerman-161228577.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:8;g:04cc60e0-a193-3352-8e5c-ff896228e590;tar:news.yahoo.com;ltxt:Majorset;ct:3;pkgt:4;r:4100001232;slk:title;itc:0;prov:WABC\\\\u2013NY;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\\\u003EMajor setback for the defense at George Zimmerman trial\\\\u003C/a\\\\u003E\\\\u003C/h3\\\\u003E\\\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\\\u003EMarci Gonzalez reports for ABC News from Sanford, Florida\\\\u003C/p\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\\\u003E\\\\u003Cspan class=\\\\\\\"source\\\\\\\"\\\\u003EWABC \\\\u2013 NY\\\\u003C/span\\\\u003E\\\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\\\u003E\\\\u003C/ul\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\\\u003E\\\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\\\u003ERemove\\\\u003C/button\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"content voh-parent cf\\\\\\\" data-uuid=\\\\\\\"c200730b-eb18-376d-a3d3-1892197b9f54\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:9;pkgt:3;ccode:news;g:c200730b-eb18-376d-a3d3-1892197b9f54;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fnews.yahoo.com%2Fwashington-vilified-both-sides-egypts-divide-174446715.html\\\\\\\" data-wikiids=\\\\\\\"YCT:001000661|YCT:001000680|WIKIID:Barack_Obama|WIKIID:Mohamed_Morsi|WIKIID:Egypt|WIKIID:United_States|WIKIID:Hosni_Mubarak|WIKIID:Cairo\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\\\u003E\\\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"/washington-vilified-both-sides-egypts-divide-174446715.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:9;g:c200730b-eb18-376d-a3d3-1892197b9f54;tar:news.yahoo.com;ltxt:Washingt;ct:1;pkgt:3;r:4090000779;slk:title;itc:0;prov:Reuters;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\\\u003EWashington vilified on both sides of Egypt&#39;s divide\\\\u003C/a\\\\u003E\\\\u003C/h3\\\\u003E\\\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\\\u003EBy Maggie Fick and Tom Finn CAIRO (Reuters) - Pictures of Barack Obama have popped up all over Cairo. Some have his faced crossed out in paint. Heavy black beards are daubed onto others. No matter which side you talk to in Egypt, where people have been polarized by a violent political crisis, the\\\\u2026\\\\u003C/p\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\\\u003E\\\\u003Cspan class=\\\\\\\"source\\\\\\\"\\\\u003EReuters\\\\u003C/span\\\\u003E\\\\u003Cspan class=\\\\\\\"time\\\\\\\"\\\\u003E54 mins ago\\\\u003C/span\\\\u003E\\\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\\\u003E\\\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\\\u003E\\\\u003Ca href=\\\\\\\"http://news.yahoo.com/politics-and-government/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"YCT:001000661\\\\\\\" data-ylk=\\\\\\\"slk:Politics;sec:td-strm;cpos:1;itc:0;g:c200730b-eb18-376d-a3d3-1892197b9f54;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\\\u003EPolitics\\\\u003C/a\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\\\u003E\\\\u003Ca href=\\\\\\\"http://news.yahoo.com/foreign-policy/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"YCT:001000680\\\\\\\" data-ylk=\\\\\\\"slk:Foreign Policy;sec:td-strm;cpos:2;itc:0;g:c200730b-eb18-376d-a3d3-1892197b9f54;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\\\u003EForeign Policy\\\\u003C/a\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\\\u003E\\\\u003Ca href=\\\\\\\"http://news.yahoo.com/barack-obama/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"WIKIID:Barack_Obama\\\\\\\" data-ylk=\\\\\\\"slk:Barack Obama;sec:td-strm;cpos:3;itc:0;g:c200730b-eb18-376d-a3d3-1892197b9f54;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\\\u003EBarack Obama\\\\u003C/a\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\\\u003E\\\\u003Ca href=\\\\\\\"http://www.yahoo.com/topic/mohamed-morsi/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"WIKIID:Mohamed_Morsi\\\\\\\" data-ylk=\\\\\\\"slk:Mohamed Morsi;sec:td-strm;cpos:4;itc:0;g:c200730b-eb18-376d-a3d3-1892197b9f54;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\\\u003EMohamed Morsi\\\\u003C/a\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\\\u003E\\\\u003Ca href=\\\\\\\"http://news.yahoo.com/egypt/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"WIKIID:Egypt\\\\\\\" data-ylk=\\\\\\\"slk:Egypt;sec:td-strm;cpos:5;itc:0;g:c200730b-eb18-376d-a3d3-1892197b9f54;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\\\u003EEgypt\\\\u003C/a\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\\\u003E\\\\u003Ca href=\\\\\\\"http://www.yahoo.com/topic/united-states/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"WIKIID:United_States\\\\\\\" data-ylk=\\\\\\\"slk:United States;sec:td-strm;cpos:6;itc:0;g:c200730b-eb18-376d-a3d3-1892197b9f54;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\\\u003EUnited States\\\\u003C/a\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\\\u003E\\\\u003Ca href=\\\\\\\"http://news.yahoo.com/hosni-mubarak/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"WIKIID:Hosni_Mubarak\\\\\\\" data-ylk=\\\\\\\"slk:Hosni Mubarak;sec:td-strm;cpos:7;itc:0;g:c200730b-eb18-376d-a3d3-1892197b9f54;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\\\u003EHosni Mubarak\\\\u003C/a\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\\\u003E\\\\u003Ca href=\\\\\\\"http://www.yahoo.com/topic/cairo/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"WIKIID:Cairo\\\\\\\" data-ylk=\\\\\\\"slk:Cairo;sec:td-strm;cpos:8;itc:0;g:c200730b-eb18-376d-a3d3-1892197b9f54;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\\\u003ECairo\\\\u003C/a\\\\u003E\\\\u003C/li\\\\u003E\\\\u003C/ul\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\\\u003E\\\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\\\u003ERemove\\\\u003C/button\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"content voh-parent cf\\\\\\\" data-uuid=\\\\\\\"03ea9147-55d7-3820-996b-2c161860b5a2\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:10;pkgt:3;ccode:news;g:03ea9147-55d7-3820-996b-2c161860b5a2;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fnews.yahoo.com%2Fpublicly-shaming-girls-short-shorts-elementary-school-principal-132008451.html\\\\\\\" data-wikiids=\\\\\\\"YCT:001000267|YCT:001000269|WIKIID:Elementary_school\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\\\u003E\\\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"/publicly-shaming-girls-short-shorts-elementary-school-principal-132008451.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:10;g:03ea9147-55d7-3820-996b-2c161860b5a2;tar:news.yahoo.com;ltxt:Afterpub;ct:1;pkgt:3;r:4100000546;slk:title;itc:0;prov:TheDailyCaller;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\\\u003EAfter publicly shaming girls for short shorts, elementary school principal apologizes\\\\u003C/a\\\\u003E\\\\u003C/h3\\\\u003E\\\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\\\u003EThe principal at a highly selective and highly prestigious Chicago elementary school has apologized for singling out and publicly shaming seven girls on the last day of school for the immodest lengths of their shorts.\\\\u003C/p\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\\\u003E\\\\u003Cspan class=\\\\\\\"source\\\\\\\"\\\\u003EThe Daily Caller\\\\u003C/span\\\\u003E\\\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\\\u003E\\\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\\\u003E\\\\u003Ca href=\\\\\\\"http://news.yahoo.com/education/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"YCT:001000267\\\\\\\" data-ylk=\\\\\\\"slk:Education;sec:td-strm;cpos:1;itc:0;g:03ea9147-55d7-3820-996b-2c161860b5a2;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\\\u003EEducation\\\\u003C/a\\\\u003E\\\\u003C/li\\\\u003E\\\\u003C/ul\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\\\u003E\\\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\\\u003ERemove\\\\u003C/button\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"content has-image voh-parent cf\\\\\\\" data-uuid=\\\\\\\"590c8c6f-61a8-3dea-9ba7-8cb83525a33b\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:11;pkgt:4;ccode:news;g:590c8c6f-61a8-3dea-9ba7-8cb83525a33b;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fnews.yahoo.com%2Fbush-benevolent-spirit-must-drive-reform-plans-141956367.html\\\\\\\" data-wikiids=\\\\\\\"YCT:001000661|YCT:001000700|WIKIID:Immigration_reform\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\"img ov-h thumb-left  \\\\\\\" href=\\\\\\\"/bush-benevolent-spirit-must-drive-reform-plans-141956367.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:11;g:590c8c6f-61a8-3dea-9ba7-8cb83525a33b;tar:news.yahoo.com;ltxt:Bush:&#3;ct:1;pkgt:4;r:4072900665;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" tabindex=\\\\\\\"-1\\\\\\\"\\\\u003E\\\\u003Cimg src=\\\\\\\"http://l.yimg.com/os/mit/media/m/base/images/transparent-95031.png\\\\\\\" style=\\\\\\\"margin-left:-18px;background-image:url('http://l2.yimg.com/ts/api/res/1.2/kM94ldkpwhbbDP4OY9UnYQ--/YXBwaWQ9eWhvbWVydW47cT04NTtzbT0xO3c9MjUwO2g9MTcz/http://media.zenfs.com/en_us/News/ap_webfeeds/4e2f582e10be2e17370f6a7067003150.jpg');\\\\\\\" width=\\\\\\\"118\\\\\\\" height=\\\\\\\"82\\\\\\\" alt=\\\\\\\"\\\\\\\" title=\\\\\\\"\\\\\\\" class=\\\\\\\"lzbg\\\\\\\"\\\\u003E\\\\u003C/a\\\\u003E\\\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\\\u003E\\\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"/bush-benevolent-spirit-must-drive-reform-plans-141956367.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:11;g:590c8c6f-61a8-3dea-9ba7-8cb83525a33b;tar:news.yahoo.com;ltxt:Bush:&#3;ct:1;pkgt:4;r:4072900665;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\\\u003EBush: &#39;Benevolent spirit&#39; must drive reform plans\\\\u003C/a\\\\u003E\\\\u003C/h3\\\\u003E\\\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\\\u003EDALLAS (AP) \\\\u2014 Making a rare return to the political arena, former President George W. Bush urged Congress on Wednesday to reach a &quot;positive resolution&quot; on immigration reform, an issue that eluded him during his presidency and now confronts fellow Republicans in the aftermath of a 2012 election\\\\u2026\\\\u003C/p\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\\\u003E\\\\u003Cspan class=\\\\\\\"source\\\\\\\"\\\\u003EAssociated Press\\\\u003C/span\\\\u003E\\\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\\\u003E\\\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\\\u003E\\\\u003Ca href=\\\\\\\"http://news.yahoo.com/politics-and-government/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"YCT:001000661\\\\\\\" data-ylk=\\\\\\\"slk:Politics;sec:td-strm;cpos:1;itc:0;g:590c8c6f-61a8-3dea-9ba7-8cb83525a33b;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\\\u003EPolitics\\\\u003C/a\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\\\u003E\\\\u003Ca href=\\\\\\\"http://www.yahoo.com/topic/immigration-reform/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"WIKIID:Immigration_reform\\\\\\\" data-ylk=\\\\\\\"slk:Immigration reform;sec:td-strm;cpos:2;itc:0;g:590c8c6f-61a8-3dea-9ba7-8cb83525a33b;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\\\u003EImmigration reform\\\\u003C/a\\\\u003E\\\\u003C/li\\\\u003E\\\\u003C/ul\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\\\u003E\\\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\\\u003ERemove\\\\u003C/button\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"content has-image voh-parent cf\\\\\\\" data-uuid=\\\\\\\"e4009e04-8a14-3454-b2ef-0adfa809f2c3\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:12;pkgt:4;ccode:news;g:e4009e04-8a14-3454-b2ef-0adfa809f2c3;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fnews.yahoo.com%2Fnavy-attempt-1st-unmanned-carrier-landing-093729424.html\\\\\\\" data-wikiids=\\\\\\\"YCT:001000705|YCT:001000661|WIKIID:Unmanned_aerial_vehicle|WIKIID:Aircraft_carrier|WIKIID:Patuxent_River\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\"img ov-h thumb-left  \\\\\\\" href=\\\\\\\"/navy-attempt-1st-unmanned-carrier-landing-093729424.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:12;g:e4009e04-8a14-3454-b2ef-0adfa809f2c3;tar:news.yahoo.com;ltxt:Navytoat;ct:1;pkgt:4;r:4100000592;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" tabindex=\\\\\\\"-1\\\\\\\"\\\\u003E\\\\u003Cimg src=\\\\\\\"http://l.yimg.com/os/mit/media/m/base/images/transparent-95031.png\\\\\\\" style=\\\\\\\"margin-left:-37px;background-image:url('http://l2.yimg.com/ts/api/res/1.2/qYZjBoAYvbF1JWrX_Eav.g--/YXBwaWQ9eWhvbWVydW47cT04NTtzbT0xO3c9MjUwO2g9MTMx/http://media.zenfs.com/en_us/News/ap_webfeeds/c6ce26150eb22417370f6a706700137b.jpg');\\\\\\\" width=\\\\\\\"156\\\\\\\" height=\\\\\\\"82\\\\\\\" alt=\\\\\\\"\\\\\\\" title=\\\\\\\"\\\\\\\" class=\\\\\\\"lzbg\\\\\\\"\\\\u003E\\\\u003C/a\\\\u003E\\\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\\\u003E\\\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"/navy-attempt-1st-unmanned-carrier-landing-093729424.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:12;g:e4009e04-8a14-3454-b2ef-0adfa809f2c3;tar:news.yahoo.com;ltxt:Navytoat;ct:1;pkgt:4;r:4100000592;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\\\u003ENavy to attempt 1st unmanned carrier landing\\\\u003C/a\\\\u003E\\\\u003C/h3\\\\u003E\\\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\\\u003ENORFOLK, Va. (AP) \\\\u2014 The Navy will attempt to land a drone the size of a fighter jet aboard an aircraft carrier for the first time Wednesday, showcasing the military&#39;s capability to have a computer program perform one of the most difficult tasks a pilot is asked to do.\\\\u003C/p\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\\\u003E\\\\u003Cspan class=\\\\\\\"source\\\\\\\"\\\\u003EAssociated Press\\\\u003C/span\\\\u003E\\\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\\\u003E\\\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\\\u003E\\\\u003Ca href=\\\\\\\"http://news.yahoo.com/military-and-defense/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"YCT:001000705\\\\\\\" data-ylk=\\\\\\\"slk:Military;sec:td-strm;cpos:1;itc:0;g:e4009e04-8a14-3454-b2ef-0adfa809f2c3;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\\\u003EMilitary\\\\u003C/a\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\\\u003E\\\\u003Ca href=\\\\\\\"http://news.yahoo.com/politics-and-government/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"YCT:001000661\\\\\\\" data-ylk=\\\\\\\"slk:Politics;sec:td-strm;cpos:2;itc:0;g:e4009e04-8a14-3454-b2ef-0adfa809f2c3;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\\\u003EPolitics\\\\u003C/a\\\\u003E\\\\u003C/li\\\\u003E\\\\u003C/ul\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\\\u003E\\\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\\\u003ERemove\\\\u003C/button\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"content cavideo has-image voh-parent cf\\\\\\\" data-uuid=\\\\\\\"999a3ee7-37dc-34bd-99a7-51b289bd05a6\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:13;pkgt:4;ccode:news;g:999a3ee7-37dc-34bd-99a7-51b289bd05a6;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fnews.yahoo.com%2Fvideo%2Fskinny-dipping-wife-helps-husband-112335504.html\\\\\\\" data-wikiids=\\\\\\\"\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\"img ov-h thumb-left  \\\\\\\" href=\\\\\\\"/video/skinny-dipping-wife-helps-husband-112335504.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:13;g:999a3ee7-37dc-34bd-99a7-51b289bd05a6;tar:news.yahoo.com;ltxt:Skinny-d;ct:3;pkgt:4;r:4100001466;slk:title;itc:0;prov:WPVI\\\\u2013Philadelphi;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" tabindex=\\\\\\\"-1\\\\\\\"\\\\u003E\\\\u003Cimg src=\\\\\\\"http://l.yimg.com/os/mit/media/m/base/images/transparent-95031.png\\\\\\\" style=\\\\\\\"margin-left:-32px;background-image:url('http://l1.yimg.com/ts/api/res/1.2/k0Uux1mipxEie_NcST2_RA--/YXBwaWQ9eWhvbWVydW47cT04NTtzbT0xO3c9MjUwO2g9MTQx/http://media.zenfs.com/en-US/video/video.wpvi.abc.news.com/fd9ca258c081f44a75f5d0ce3c14d921');\\\\\\\" width=\\\\\\\"145\\\\\\\" height=\\\\\\\"82\\\\\\\" alt=\\\\\\\"\\\\\\\" title=\\\\\\\"\\\\\\\" class=\\\\\\\"lzbg\\\\\\\"\\\\u003E\\\\u003Cspan class=\\\\\\\"icon-overlay\\\\\\\"\\\\u003E\\\\u003Cspan class=\\\\\\\"video-icon d-ib\\\\\\\"\\\\u003E\\\\u003Ci class=\\\\\\\"icon-sprite\\\\\\\"\\\\u003E\\\\u003C/i\\\\u003E \\\\u003Cspan class=\\\\\\\"play-now fz-xxs\\\\\\\"\\\\u003EPlay\\\\u003C/span\\\\u003E\\\\u003C/span\\\\u003E\\\\u003C/span\\\\u003E\\\\u003C/a\\\\u003E\\\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\\\u003E\\\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"/video/skinny-dipping-wife-helps-husband-112335504.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:13;g:999a3ee7-37dc-34bd-99a7-51b289bd05a6;tar:news.yahoo.com;ltxt:Skinny-d;ct:3;pkgt:4;r:4100001466;slk:title;itc:0;prov:WPVI\\\\u2013Philadelphi;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\\\u003ESkinny-dipping wife helps husband steal\\\\u003C/a\\\\u003E\\\\u003C/h3\\\\u003E\\\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\\\u003EClick play to watch the report from Action News\\\\u003C/p\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\\\u003E\\\\u003Cspan class=\\\\\\\"source\\\\\\\"\\\\u003EWPVI \\\\u2013 Philadelphia\\\\u003C/span\\\\u003E\\\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\\\u003E\\\\u003C/ul\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\\\u003E\\\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\\\u003ERemove\\\\u003C/button\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"content has-image voh-parent cf\\\\\\\" data-uuid=\\\\\\\"95413a0a-1d88-3f94-817c-d6b5fb824b6f\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:14;pkgt:4;ccode:news;g:95413a0a-1d88-3f94-817c-d6b5fb824b6f;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fnews.yahoo.com%2Fpanera-retool-latest-pay-idea-051305138.html\\\\\\\" data-wikiids=\\\\\\\"YCT:001000123|WIKIID:Panera_Bread\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\"img ov-h thumb-left  \\\\\\\" href=\\\\\\\"/panera-retool-latest-pay-idea-051305138.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:14;g:95413a0a-1d88-3f94-817c-d6b5fb824b6f;tar:news.yahoo.com;ltxt:Panerato;ct:1;pkgt:4;r:4100000490;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" tabindex=\\\\\\\"-1\\\\\\\"\\\\u003E\\\\u003Cimg src=\\\\\\\"http://l.yimg.com/os/mit/media/m/base/images/transparent-95031.png\\\\\\\" style=\\\\\\\"margin-left:-21px;background-image:url('http://l3.yimg.com/ts/api/res/1.2/GRTmxi74dUkPM0bN5Tu_EA--/YXBwaWQ9eWhvbWVydW47cT04NTtzbT0xO3c9MjUwO2g9MTY3/http://media.zenfs.com/en_us/News/ap_webfeeds/a4d177310ec22417370f6a7067000233.jpg');\\\\\\\" width=\\\\\\\"123\\\\\\\" height=\\\\\\\"82\\\\\\\" alt=\\\\\\\"\\\\\\\" title=\\\\\\\"\\\\\\\" class=\\\\\\\"lzbg\\\\\\\"\\\\u003E\\\\u003C/a\\\\u003E\\\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\\\u003E\\\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"/panera-retool-latest-pay-idea-051305138.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:14;g:95413a0a-1d88-3f94-817c-d6b5fb824b6f;tar:news.yahoo.com;ltxt:Panerato;ct:1;pkgt:4;r:4100000490;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\\\u003EPanera to retool latest pay-what-you-can idea\\\\u003C/a\\\\u003E\\\\u003C/h3\\\\u003E\\\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\\\u003EST. LOUIS (AP) \\\\u2014 Panera Bread&#39;s latest pay-what-you-can experiment will be retooled and brought back next winter as a seasonal offering rather than a permanent one, the chain&#39;s founder says.\\\\u003C/p\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\\\u003E\\\\u003Cspan class=\\\\\\\"source\\\\\\\"\\\\u003EAssociated Press\\\\u003C/span\\\\u003E\\\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\\\u003E\\\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\\\u003E\\\\u003Ca href=\\\\\\\"http://www.yahoo.com/topic/panera-bread/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"WIKIID:Panera_Bread\\\\\\\" data-ylk=\\\\\\\"slk:Panera Bread;sec:td-strm;cpos:1;itc:0;g:95413a0a-1d88-3f94-817c-d6b5fb824b6f;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\\\u003EPanera Bread\\\\u003C/a\\\\u003E\\\\u003C/li\\\\u003E\\\\u003C/ul\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\\\u003E\\\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\\\u003ERemove\\\\u003C/button\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"content slideshow has-image voh-parent cf\\\\\\\" data-uuid=\\\\\\\"706337c9-1922-33ac-b86f-a5280ffcc242\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:15;pkgt:21;ccode:news;g:706337c9-1922-33ac-b86f-a5280ffcc242;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fnews.yahoo.com%2Fphotos%2Fcarpenter-1-fire-rages-outside-las-vegas-1373414067-slideshow%2F\\\\\\\" data-wikiids=\\\\\\\"\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\"img ov-h thumb-left  \\\\\\\" href=\\\\\\\"/photos/carpenter-1-fire-rages-outside-las-vegas-1373414067-slideshow/\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:15;g:706337c9-1922-33ac-b86f-a5280ffcc242;tar:news.yahoo.com;ltxt:Carpente;ct:4;pkgt:21;r:4100001677;slk:title;itc:0;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" tabindex=\\\\\\\"-1\\\\\\\"\\\\u003E\\\\u003Cimg src=\\\\\\\"http://l.yimg.com/os/mit/media/m/base/images/transparent-95031.png\\\\\\\" style=\\\\\\\"background-image:url('http://l1.yimg.com/ts/api/res/1.2/vv0qulgbBMDqq9r94wVCzw--/YXBwaWQ9eWhvbWVydW47cT04NTtzbT0xO2ZpPWZpbGw7dz0xMDA7aD0xMDA7cHlvZmY9MA--/http://l.yimg.com/os/publish-images/news/2013-07-09/147c5e94-9385-462b-85d7-4916b61620c4_fire7.jpg');\\\\\\\" width=\\\\\\\"82\\\\\\\" height=\\\\\\\"82\\\\\\\" alt=\\\\\\\"\\\\\\\" title=\\\\\\\"\\\\\\\" class=\\\\\\\"lzbg\\\\\\\"\\\\u003E\\\\u003Cspan class=\\\\\\\"icon-overlay\\\\\\\"\\\\u003E\\\\u003Cspan class=\\\\\\\"gallery-icon\\\\\\\"\\\\u003E\\\\u003Ci class=\\\\\\\"icon-sprite\\\\\\\"\\\\u003E\\\\u003C/i\\\\u003E \\\\u003Cspan class=\\\\\\\"view-now fz-xxs\\\\\\\"\\\\u003EView\\\\u003C/span\\\\u003E\\\\u003C/span\\\\u003E\\\\u003C/span\\\\u003E\\\\u003C/a\\\\u003E\\\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\\\u003E\\\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"/photos/carpenter-1-fire-rages-outside-las-vegas-1373414067-slideshow/\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:15;g:706337c9-1922-33ac-b86f-a5280ffcc242;tar:news.yahoo.com;ltxt:Carpente;ct:4;pkgt:21;r:4100001677;slk:title;itc:0;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-uuid=\\\\\\\"de60ffd9-ff42-4ec7-b62c-b733917baeca\\\\\\\"\\\\u003ECarpenter 1 fire rages outside Las Vegas \\\\u003Csmall\\\\u003E(14 photos)\\\\u003C/small\\\\u003E\\\\u003C/a\\\\u003E\\\\u003C/h3\\\\u003E\\\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\\\u003EPhotos from the Carpenter 1 fire outside Las Vegas, Nev., which has charred an area the size of Manhattan Island, according to the Associated Press .\\\\u003C/p\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\\\u003E\\\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\\\u003E\\\\u003C/ul\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\\\u003E\\\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\\\u003ERemove\\\\u003C/button\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"content rmx-ad has-image voh-parent cf\\\\\\\" data-uuid=\\\\\\\"21675196\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:16;pkgt:4;ccode:news;g:21675196;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fad.yieldmanager.com%2Fclk%3F3%2CeJytjcsOgjAURH-IRQFb2jQuCgUC0qIJSnCHPMozbohEv96ARH.As5g7kzvJ6CaFiOQIV7ggBQEIWFQ364JUoC5LpAFKqWERBC2ICdbYwhFPp9nBD.durzlsbhfFPizXVs7WW9Tl5iHPt3d6vE7sLzgkZMHmg3VXccxg.VLPBNvfmp.thCF7wYcuSs8w9rNJJN4gWr2VXdlEiTvLjoFs9MaYy17-BvaaBt5Mc081%2Chttp%253A%252F%252Fwww.nextag.com%252Fgoto.jsp%253Fp%253D357374%2526crid%253D70102%2526search%253Ddress\\\\\\\" data-wikiids=\\\\\\\"\\\\\\\" data-rmx-beacon=\\\\\\\"http://ad.yieldmanager.com/csc?ve=2&eDVBQF12wp2gYuJLPlTbhXlzA6IWivR8TvUupIdTtxWWT_KRcUq_k3JeHFR5Axmf8W8Eu_SnJ6nsBcHGXwM.EPjNsm3pCuLboxmB5dStxjLbeGiiF.eCSA9lwNfB2G248fAPjGPhyi3N7PQqZ.svAsKQwK05a3JLjQajId3GqR92_txBMmy1awX8Zn3nrwjgHFvzLPIFJ1svmulxdP_g7Hb5tjnpXXyCnpmH1NpTll3NAd7wk9XWEeun8rqrw2ZNNfF6WZS5RPwYCev7k9LVM1VTjs2yqGg0nIQH4pYpgN6oyO.mxW3BkIqa9snxkq7mfa0nH4otnvlfoNJjq9yWwUQNtnQKiq4pUms7HrqZzbDqLfDraJSxWV.1sb4QtExWizh6e_eURb_7vtwbvHKWqWH4WU1Emy4c7jaJG2.Hs8h_XLhYZjLbKs9DsiFP5RrghHN6TNdK9aVIZxIoWsOagptRElaqbCAXQh.HKAVOgd.xwnFkStxahe_BgtmjXbbFsLFdh299IqaYF6j.k.6curquTM6C_WFVtHERJUhjsQYk6noMOLdpgBDFCmQ6r0EzWsWEW_.W_twMnzL6ky.3z6EXJBkmtA.j18qFVulOuP.NogVvbhqtsQH0yB2vbDuX7JTWCDY24pQqw8IwgVO0UcFt6CwFS0PtCtn1AnMCgGjkXCcIYqVbNhLL7zg40ZDc8OcR2UHQkHGDnF7m918m1ULk2gJMFi_x.pyiODRnuDg34PxmKSQku37Js.LjNL11buxN2AshqV4gt8R3y02COFdxzswHg1pFZaRwDdDAiDXU_xBaYPWURpeIFxN0XlMHBw--&ap=16\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\"img ov-h thumb-left  \\\\\\\" href=\\\\\\\"http://ad.yieldmanager.com/clk?3,eJytjcsOgjAURH-IRQFb2jQuCgUC0qIJSnCHPMozbohEv96ARH.As5g7kzvJ6CaFiOQIV7ggBQEIWFQ364JUoC5LpAFKqWERBC2ICdbYwhFPp9nBD.durzlsbhfFPizXVs7WW9Tl5iHPt3d6vE7sLzgkZMHmg3VXccxg.VLPBNvfmp.thCF7wYcuSs8w9rNJJN4gWr2VXdlEiTvLjoFs9MaYy17-BvaaBt5Mc081,http%3A%2F%2Fwww.nextag.com%2Fgoto.jsp%3Fp%3D357374%26crid%3D70102%26search%3Ddress\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:16;g:21675196;tar:ad.yieldmanager.com;ltxt:Top10Dre;ct:1;pkgt:4;ad:1;slk:title;itc:0;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" target=\\\\\\\"_blank\\\\\\\" tabindex=\\\\\\\"-1\\\\\\\"\\\\u003E\\\\u003Cimg src=\\\\\\\"http://l.yimg.com/os/mit/media/m/base/images/transparent-95031.png\\\\\\\" style=\\\\\\\"background-image:url('http://l2.yimg.com/av/moneyball/ads/bulk/6473/c1b5c4a6baf815019e3f6c79b13674e1.jpg');\\\\\\\" width=\\\\\\\"82\\\\\\\" height=\\\\\\\"82\\\\\\\" alt=\\\\\\\"\\\\\\\" title=\\\\\\\"\\\\\\\" class=\\\\\\\"lzbg\\\\\\\"\\\\u003E\\\\u003C/a\\\\u003E\\\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\\\u003E\\\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"http://ad.yieldmanager.com/clk?3,eJytjcsOgjAURH-IRQFb2jQuCgUC0qIJSnCHPMozbohEv96ARH.As5g7kzvJ6CaFiOQIV7ggBQEIWFQ364JUoC5LpAFKqWERBC2ICdbYwhFPp9nBD.durzlsbhfFPizXVs7WW9Tl5iHPt3d6vE7sLzgkZMHmg3VXccxg.VLPBNvfmp.thCF7wYcuSs8w9rNJJN4gWr2VXdlEiTvLjoFs9MaYy17-BvaaBt5Mc081,http%3A%2F%2Fwww.nextag.com%2Fgoto.jsp%3Fp%3D357374%26crid%3D70102%26search%3Ddress\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:16;g:21675196;tar:ad.yieldmanager.com;ltxt:Top10Dre;ct:1;pkgt:4;ad:1;slk:title;itc:0;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" target=\\\\\\\"_blank\\\\\\\"\\\\u003ETop 10 Dresses for 2013\\\\u003C/a\\\\u003E\\\\u003C/h3\\\\u003E\\\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\\\u003EHottest Dresses on sale.  Awesome selection and deals.\\\\u003C/p\\\\u003E\\\\u003Ca class=\\\\\\\"adlink fz-xxs rapid-noclick-resp\\\\\\\" href=\\\\\\\"http://info.yahoo.com/privacy/us/yahoo/adinfo_geo.html\\\\\\\" target=\\\\\\\"_blank\\\\\\\"\\\\u003EAdChoices\\\\u003Ci class=\\\\\\\"img-sprite\\\\\\\"\\\\u003E\\\\u003C/i\\\\u003E\\\\u003C/a\\\\u003E\\\\u000a\\\\u003Ca class=\\\\\\\"fz-xxs adv rapid-noclick-resp\\\\\\\" href=\\\\\\\"http://ad.yieldmanager.com/clk?3,eJytjcsOgjAURH-IRQFb2jQuCgUC0qIJSnCHPMozbohEv96ARH.As5g7kzvJ6CaFiOQIV7ggBQEIWFQ364JUoC5LpAFKqWERBC2ICdbYwhFPp9nBD.durzlsbhfFPizXVs7WW9Tl5iHPt3d6vE7sLzgkZMHmg3VXccxg.VLPBNvfmp.thCF7wYcuSs8w9rNJJN4gWr2VXdlEiTvLjoFs9MaYy17-BvaaBt5Mc081,http%3A%2F%2Fwww.nextag.com%2Fgoto.jsp%3Fp%3D357374%26crid%3D70102%26search%3Ddress\\\\\\\" target=\\\\\\\"_blank\\\\\\\"\\\\u003E\\\\u003Cspan class=\\\\\\\"source\\\\\\\"\\\\u003EOfficial Nextag Site\\\\u003C/span\\\\u003E\\\\u003C/a\\\\u003E\\\\u003Ca href=\\\\\\\"http://help.yahoo.com/kb/index?page=content&y=PROD_FRONT&locale=en_US&id=SLN14553\\\\\\\" class=\\\\\\\"fz-xxs sp rapid-noclick-resp\\\\\\\" target=\\\\\\\"_blank\\\\\\\"\\\\u003ESponsored\\\\u003C/a\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\\\u003E\\\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\\\u003E\\\\u003C/ul\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"content voh-parent cf\\\\\\\" data-uuid=\\\\\\\"35246d27-ef1f-3c2f-ac82-50ee6d2511ee\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:17;pkgt:3;ccode:news;g:35246d27-ef1f-3c2f-ac82-50ee6d2511ee;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fnews.yahoo.com%2Fky-church-wants-pastor-gone-wifes-column-083204548.html\\\\\\\" data-wikiids=\\\\\\\"YCT:001000804|YCT:001000780|WIKIID:Southern_Baptist_Convention\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\\\u003E\\\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"/ky-church-wants-pastor-gone-wifes-column-083204548.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:17;g:35246d27-ef1f-3c2f-ac82-50ee6d2511ee;tar:news.yahoo.com;ltxt:Ky.churc;ct:1;pkgt:3;r:4059001073;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\\\u003EKy. church wants pastor gone after wife&#39;s column\\\\u003C/a\\\\u003E\\\\u003C/h3\\\\u003E\\\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\\\u003ELOUISVILLE, Ky. (AP) \\\\u2014 A newspaper column lampooning Southern Baptists, calling the group &quot;the crazy old paranoid uncle of evangelical Christians,&quot; is causing quite a stir in a Kentucky city and put a pastor&#39;s job in jeopardy.\\\\u003C/p\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\\\u003E\\\\u003Cspan class=\\\\\\\"source\\\\\\\"\\\\u003EAssociated Press\\\\u003C/span\\\\u003E\\\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\\\u003E\\\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\\\u003E\\\\u003Ca href=\\\\\\\"http://news.yahoo.com/religion-and-beliefs/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"YCT:001000804\\\\\\\" data-ylk=\\\\\\\"slk:Religion;sec:td-strm;cpos:1;itc:0;g:35246d27-ef1f-3c2f-ac82-50ee6d2511ee;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\\\u003EReligion\\\\u003C/a\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\\\u003E\\\\u003Ca href=\\\\\\\"http://news.yahoo.com/society-and-culture/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"YCT:001000780\\\\\\\" data-ylk=\\\\\\\"slk:Society;sec:td-strm;cpos:2;itc:0;g:35246d27-ef1f-3c2f-ac82-50ee6d2511ee;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\\\u003ESociety\\\\u003C/a\\\\u003E\\\\u003C/li\\\\u003E\\\\u003C/ul\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\\\u003E\\\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\\\u003ERemove\\\\u003C/button\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"content has-image voh-parent cf\\\\\\\" data-uuid=\\\\\\\"89342141-8982-3a32-9a2e-81cda1656e16\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:18;pkgt:4;ccode:news;g:89342141-8982-3a32-9a2e-81cda1656e16;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fnews.yahoo.com%2Fformer-judge-admits-flaws-secret-court-145541583.html\\\\\\\" data-wikiids=\\\\\\\"YCT:001000661|WIKIID:National_Security_Agency|WIKIID:Barack_Obama\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\"img ov-h thumb-left  \\\\\\\" href=\\\\\\\"/former-judge-admits-flaws-secret-court-145541583.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:18;g:89342141-8982-3a32-9a2e-81cda1656e16;tar:news.yahoo.com;ltxt:Formerju;ct:1;pkgt:4;r:4072901757;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" tabindex=\\\\\\\"-1\\\\\\\"\\\\u003E\\\\u003Cimg src=\\\\\\\"http://l.yimg.com/os/mit/media/m/base/images/transparent-95031.png\\\\\\\" style=\\\\\\\"background-image:url('http://l2.yimg.com/ts/api/res/1.2/V1oj15r8LwVhitDeCoj3_g--/YXBwaWQ9eWhvbWVydW47cT04NTtzbT0xO3c9MjA4O2g9MjUw/http://media.zenfs.com/en_us/News/ap_webfeeds/fab40ba5f2431816370f6a706700947e.jpg');\\\\\\\" width=\\\\\\\"82\\\\\\\" height=\\\\\\\"99\\\\\\\" alt=\\\\\\\"\\\\\\\" title=\\\\\\\"\\\\\\\" class=\\\\\\\"lzbg\\\\\\\"\\\\u003E\\\\u003C/a\\\\u003E\\\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\\\u003E\\\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"/former-judge-admits-flaws-secret-court-145541583.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:18;g:89342141-8982-3a32-9a2e-81cda1656e16;tar:news.yahoo.com;ltxt:Formerju;ct:1;pkgt:4;r:4072901757;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\\\u003EFormer judge admits flaws in secret court\\\\u003C/a\\\\u003E\\\\u003C/h3\\\\u003E\\\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\\\u003EWASHINGTON (AP) \\\\u2014 A former federal judge who served on a secret court overseeing the National Security Agency&#39;s secret surveillance programs said Tuesday the panel is independent but flawed because only the government&#39;s side is represented effectively in its deliberations.\\\\u003C/p\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\\\u003E\\\\u003Cspan class=\\\\\\\"source\\\\\\\"\\\\u003EAssociated Press\\\\u003C/span\\\\u003E\\\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\\\u003E\\\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\\\u003E\\\\u003Ca href=\\\\\\\"http://news.yahoo.com/politics-and-government/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"YCT:001000661\\\\\\\" data-ylk=\\\\\\\"slk:Politics;sec:td-strm;cpos:1;itc:0;g:89342141-8982-3a32-9a2e-81cda1656e16;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\\\u003EPolitics\\\\u003C/a\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\\\u003E\\\\u003Ca href=\\\\\\\"http://www.yahoo.com/topic/national-security-agency/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"WIKIID:National_Security_Agency\\\\\\\" data-ylk=\\\\\\\"slk:National Security Agency;sec:td-strm;cpos:2;itc:0;g:89342141-8982-3a32-9a2e-81cda1656e16;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\\\u003ENational Security Agency\\\\u003C/a\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\\\u003E\\\\u003Ca href=\\\\\\\"http://news.yahoo.com/barack-obama/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"WIKIID:Barack_Obama\\\\\\\" data-ylk=\\\\\\\"slk:Barack Obama;sec:td-strm;cpos:3;itc:0;g:89342141-8982-3a32-9a2e-81cda1656e16;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\\\u003EBarack Obama\\\\u003C/a\\\\u003E\\\\u003C/li\\\\u003E\\\\u003C/ul\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\\\u003E\\\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\\\u003ERemove\\\\u003C/button\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"content has-image voh-parent cf\\\\\\\" data-uuid=\\\\\\\"545a4a5d-31f1-3d2b-b3a1-af6ab035ba08\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:19;pkgt:4;ccode:news;g:545a4a5d-31f1-3d2b-b3a1-af6ab035ba08;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fnews.yahoo.com%2F30-000-california-prisoners-refusing-meals-030023796.html\\\\\\\" data-wikiids=\\\\\\\"WIKIID:California|WIKIID:Solitary_confinement\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\"img ov-h thumb-left  \\\\\\\" href=\\\\\\\"/30-000-california-prisoners-refusing-meals-030023796.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:19;g:545a4a5d-31f1-3d2b-b3a1-af6ab035ba08;tar:news.yahoo.com;ltxt:30,000Ca;ct:1;pkgt:4;r:4100000793;slk:title;itc:0;prov:TheAtlanticWire;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" tabindex=\\\\\\\"-1\\\\\\\"\\\\u003E\\\\u003Cimg src=\\\\\\\"http://l.yimg.com/os/mit/media/m/base/images/transparent-95031.png\\\\\\\" style=\\\\\\\"margin-left:-25px;background-image:url('http://l1.yimg.com/ts/api/res/1.2/cIsjQVUHZJZ7HCJhBG6m2Q--/YXBwaWQ9eWhvbWVydW47cT04NTtzbT0xO3c9MjUwO2g9MTU2/http://media.zenfs.com/en_us/News/theatlanticwire/30_000_California_Prisoners_Are_Refusing-b255dfae58903c7ee92b601e81fb15da');\\\\\\\" width=\\\\\\\"131\\\\\\\" height=\\\\\\\"82\\\\\\\" alt=\\\\\\\"\\\\\\\" title=\\\\\\\"\\\\\\\" class=\\\\\\\"lzbg\\\\\\\"\\\\u003E\\\\u003C/a\\\\u003E\\\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\\\u003E\\\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"/30-000-california-prisoners-refusing-meals-030023796.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:19;g:545a4a5d-31f1-3d2b-b3a1-af6ab035ba08;tar:news.yahoo.com;ltxt:30,000Ca;ct:1;pkgt:4;r:4100000793;slk:title;itc:0;prov:TheAtlanticWire;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\\\u003E30,000 California Prisoners Are Refusing Meals\\\\u003C/a\\\\u003E\\\\u003C/h3\\\\u003E\\\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\\\u003EOver 30,000 California prisoners started refusing meals on Monday morning in what might become the biggest hunger strike in California prison history, according to California&#39;s corrections department.\\\\u003C/p\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\\\u003E\\\\u003Cspan class=\\\\\\\"source\\\\\\\"\\\\u003EThe Atlantic Wire\\\\u003C/span\\\\u003E\\\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\\\u003E\\\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\\\u003E\\\\u003Ca href=\\\\\\\"http://news.yahoo.com/california/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"WIKIID:California\\\\\\\" data-ylk=\\\\\\\"slk:California;sec:td-strm;cpos:1;itc:0;g:545a4a5d-31f1-3d2b-b3a1-af6ab035ba08;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\\\u003ECalifornia\\\\u003C/a\\\\u003E\\\\u003C/li\\\\u003E\\\\u003C/ul\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\\\u003E\\\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\\\u003ERemove\\\\u003C/button\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"content has-image voh-parent cf\\\\\\\" data-uuid=\\\\\\\"c20cc012-29f6-3120-a12f-ef78c41a0a22\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:20;pkgt:4;ccode:news;g:c20cc012-29f6-3120-a12f-ef78c41a0a22;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fnews.yahoo.com%2F3-years-obamacare-incompetence-tells-us-white-house-074000304.html\\\\\\\" data-wikiids=\\\\\\\"YCT:001000661|YCT:001000681|WIKIID:White_House|WIKIID:Presidency_of_Barack_Obama|WIKIID:Patient_Protection_and_Affordable_Care_Act\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\"img ov-h thumb-left  \\\\\\\" href=\\\\\\\"/3-years-obamacare-incompetence-tells-us-white-house-074000304.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:20;g:c20cc012-29f6-3120-a12f-ef78c41a0a22;tar:news.yahoo.com;ltxt:What3yea;ct:1;pkgt:4;r:4065600903;slk:title;itc:0;prov:TheWeek;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" tabindex=\\\\\\\"-1\\\\\\\"\\\\u003E\\\\u003Cimg src=\\\\\\\"http://l.yimg.com/os/mit/media/m/base/images/transparent-95031.png\\\\\\\" style=\\\\\\\"margin-left:-27px;background-image:url('http://l2.yimg.com/ts/api/res/1.2/Rntt.Xg7T8Y5NxTOWahOJg--/YXBwaWQ9eWhvbWVydW47cT04NTtzbT0xO3c9MjUwO2g9MTUx/http://media.zenfs.com/en_us/News/theweek/is-president-obamas-signature-legislative-achievement-turning-into-a-messy-failure.jpg');\\\\\\\" width=\\\\\\\"136\\\\\\\" height=\\\\\\\"82\\\\\\\" alt=\\\\\\\"\\\\\\\" title=\\\\\\\"\\\\\\\" class=\\\\\\\"lzbg\\\\\\\"\\\\u003E\\\\u003C/a\\\\u003E\\\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\\\u003E\\\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"/3-years-obamacare-incompetence-tells-us-white-house-074000304.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:20;g:c20cc012-29f6-3120-a12f-ef78c41a0a22;tar:news.yahoo.com;ltxt:What3yea;ct:1;pkgt:4;r:4065600903;slk:title;itc:0;prov:TheWeek;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\\\u003EWhat 3 years of ObamaCare incompetence tells us about the White House\\\\u003C/a\\\\u003E\\\\u003C/h3\\\\u003E\\\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\\\u003EThe administration is gradually scaling back its signature legislation \\\\u2014 just as critics have long demanded\\\\u003C/p\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\\\u003E\\\\u003Cspan class=\\\\\\\"source\\\\\\\"\\\\u003EThe Week\\\\u003C/span\\\\u003E\\\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\\\u003E\\\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\\\u003E\\\\u003Ca href=\\\\\\\"http://news.yahoo.com/politics-and-government/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"YCT:001000661\\\\\\\" data-ylk=\\\\\\\"slk:Politics;sec:td-strm;cpos:1;itc:0;g:c20cc012-29f6-3120-a12f-ef78c41a0a22;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\\\u003EPolitics\\\\u003C/a\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\\\u003E\\\\u003Ca href=\\\\\\\"http://news.yahoo.com/white-house-2/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"WIKIID:White_House\\\\\\\" data-ylk=\\\\\\\"slk:White House;sec:td-strm;cpos:2;itc:0;g:c20cc012-29f6-3120-a12f-ef78c41a0a22;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\\\u003EWhite House\\\\u003C/a\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\\\u003E\\\\u003Ca href=\\\\\\\"http://www.yahoo.com/topic/presidency-of-barack-obama/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"WIKIID:Presidency_of_Barack_Obama\\\\\\\" data-ylk=\\\\\\\"slk:Presidency of Barack Obama;sec:td-strm;cpos:3;itc:0;g:c20cc012-29f6-3120-a12f-ef78c41a0a22;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\\\u003EPresidency of Barack Obama\\\\u003C/a\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\\\u003E\\\\u003Ca href=\\\\\\\"http://news.yahoo.com/patient-protection-and-affordable-care-act/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"WIKIID:Patient_Protection_and_Affordable_Care_Act\\\\\\\" data-ylk=\\\\\\\"slk:Patient Protection and Affordable Care Act;sec:td-strm;cpos:4;itc:0;g:c20cc012-29f6-3120-a12f-ef78c41a0a22;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\\\u003EPatient Protection and Affordable Care Act\\\\u003C/a\\\\u003E\\\\u003C/li\\\\u003E\\\\u003C/ul\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\\\u003E\\\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\\\u003ERemove\\\\u003C/button\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"content has-image voh-parent cf\\\\\\\" data-uuid=\\\\\\\"2e88e31e-a379-3340-96cb-7c5d904edd46\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:21;pkgt:4;ccode:news;g:2e88e31e-a379-3340-96cb-7c5d904edd46;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fnews.yahoo.com%2Fchina-discovers-primitive-5-000-old-writing-143034872.html\\\\\\\" data-wikiids=\\\\\\\"\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\"img ov-h thumb-left  \\\\\\\" href=\\\\\\\"/china-discovers-primitive-5-000-old-writing-143034872.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:21;g:2e88e31e-a379-3340-96cb-7c5d904edd46;tar:news.yahoo.com;ltxt:Chinadis;ct:1;pkgt:4;r:4100000352;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" tabindex=\\\\\\\"-1\\\\\\\"\\\\u003E\\\\u003Cimg src=\\\\\\\"http://l.yimg.com/os/mit/media/m/base/images/transparent-95031.png\\\\\\\" style=\\\\\\\"margin-left:-36px;background-image:url('http://l4.yimg.com/ts/api/res/1.2/_7o1U7C.tcvQqh88tfjw8Q--/YXBwaWQ9eWhvbWVydW47cT04NTtzbT0xO3c9MjUwO2g9MTM0/http://media.zenfs.com/en_us/News/ap_webfeeds/ba42591610ce2e17370f6a7067004e28.jpg');\\\\\\\" width=\\\\\\\"153\\\\\\\" height=\\\\\\\"82\\\\\\\" alt=\\\\\\\"\\\\\\\" title=\\\\\\\"\\\\\\\" class=\\\\\\\"lzbg\\\\\\\"\\\\u003E\\\\u003C/a\\\\u003E\\\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\\\u003E\\\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"/china-discovers-primitive-5-000-old-writing-143034872.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:21;g:2e88e31e-a379-3340-96cb-7c5d904edd46;tar:news.yahoo.com;ltxt:Chinadis;ct:1;pkgt:4;r:4100000352;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\\\u003EChina discovers primitive, 5,000-year-old writing\\\\u003C/a\\\\u003E\\\\u003C/h3\\\\u003E\\\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\\\u003EBEIJING (AP) \\\\u2014 Archaeologists say they have discovered some of the world&#39;s oldest known primitive writing, dating back about 5,000 years, in eastern China, and some of the markings etched on broken axes resemble a modern Chinese character.\\\\u003C/p\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\\\u003E\\\\u003Cspan class=\\\\\\\"source\\\\\\\"\\\\u003EAssociated Press\\\\u003C/span\\\\u003E\\\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\\\u003E\\\\u003C/ul\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\\\u003E\\\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\\\u003ERemove\\\\u003C/button\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"content cavideo has-image voh-parent cf\\\\\\\" data-uuid=\\\\\\\"c621133c-f907-3f42-93ff-20ef01effa97\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:22;pkgt:4;ccode:news;g:c621133c-f907-3f42-93ff-20ef01effa97;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fnews.yahoo.com%2Fvideo%2Fprinter-ink-efficiency-tested-consumer-174417327.html\\\\\\\" data-wikiids=\\\\\\\"WIKIID:Ink_cartridge\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\"img ov-h thumb-left  \\\\\\\" href=\\\\\\\"/video/printer-ink-efficiency-tested-consumer-174417327.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:22;g:c621133c-f907-3f42-93ff-20ef01effa97;tar:news.yahoo.com;ltxt:Printeri;ct:3;pkgt:4;r:4100001074;slk:title;itc:0;prov:KGO\\\\u2013SanFrancisco;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" tabindex=\\\\\\\"-1\\\\\\\"\\\\u003E\\\\u003Cimg src=\\\\\\\"http://l.yimg.com/os/mit/media/m/base/images/transparent-95031.png\\\\\\\" style=\\\\\\\"margin-left:-32px;background-image:url('http://l3.yimg.com/ts/api/res/1.2/etz.tfpoo6Au9ixj1O3c4g--/YXBwaWQ9eWhvbWVydW47cT04NTtzbT0xO3c9MjUwO2g9MTQx/http://media.zenfs.com/en-US/video/video.kgo.abc.news.com/20a2be41046b838e6399259f73c9f47d');\\\\\\\" width=\\\\\\\"145\\\\\\\" height=\\\\\\\"82\\\\\\\" alt=\\\\\\\"\\\\\\\" title=\\\\\\\"\\\\\\\" class=\\\\\\\"lzbg\\\\\\\"\\\\u003E\\\\u003Cspan class=\\\\\\\"icon-overlay\\\\\\\"\\\\u003E\\\\u003Cspan class=\\\\\\\"video-icon d-ib\\\\\\\"\\\\u003E\\\\u003Ci class=\\\\\\\"icon-sprite\\\\\\\"\\\\u003E\\\\u003C/i\\\\u003E \\\\u003Cspan class=\\\\\\\"play-now fz-xxs\\\\\\\"\\\\u003EPlay\\\\u003C/span\\\\u003E\\\\u003C/span\\\\u003E\\\\u003C/span\\\\u003E\\\\u003C/a\\\\u003E\\\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\\\u003E\\\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"/video/printer-ink-efficiency-tested-consumer-174417327.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:22;g:c621133c-f907-3f42-93ff-20ef01effa97;tar:news.yahoo.com;ltxt:Printeri;ct:3;pkgt:4;r:4100001074;slk:title;itc:0;prov:KGO\\\\u2013SanFrancisco;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\\\u003EPrinter ink efficiency tested by Consumer Reports\\\\u003C/a\\\\u003E\\\\u003C/h3\\\\u003E\\\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\\\u003EMany don&#39;t realize it, but printer ink is one of the most expensive liquids you can buy.\\\\u003C/p\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\\\u003E\\\\u003Cspan class=\\\\\\\"source\\\\\\\"\\\\u003EKGO \\\\u2013 San Francisco\\\\u003C/span\\\\u003E\\\\u003Cspan class=\\\\\\\"time\\\\\\\"\\\\u003E54 mins ago\\\\u003C/span\\\\u003E\\\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\\\u003E\\\\u003C/ul\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\\\u003E\\\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\\\u003ERemove\\\\u003C/button\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"next-batch notice loading\\\\\\\" data-key=\\\\\\\"1\\\\\\\" data-ylk=\\\\\\\"slk:fetch;ltxt:fetch;pos:0;bpos:2;cpos:23;itc:1;sec:td-strm;test:900;intl:us;cat:default;ccode:news;\\\\\\\"  data-action=\\\\\\\"click\\\\\\\" data-action-outcome=\\\\\\\"fetch\\\\\\\"\\\\u003E\\\\u003Cbutton class=\\\\\\\"fz-xs\\\\\\\"\\\\u003ELoad more stories\\\\u003C/button\\\\u003E\\\\u003C/li\\\\u003E\\\\u003C/ul\\\\u003E\\\\u003Cinput type=\\\\\\\"hidden\\\\\\\" class=\\\\\\\"historystate\\\\\\\" data-time=\\\\\\\"1373481532.5925\\\\\\\"\\\\u003E    \\\\u003C/div\\\\u003E\\\\u000a\\\\u003C/div\\\\u003E\\\\u000a\\\\u003C/div\\\\u003E\\\\u000a\\\\u000a--dali-response-split-51ddaa3c96973Content-Type: text/plain; charset=utf-8\\\\u000aRMP-Embed-Location: bottom\\\\u000a\\\\u000a\\\\u003Cscript type=\\\\\\\"text/javascript\\\\\\\"\\\\u003E\\\\u000aYUI.namespace(\\\\\\\"presentation\\\\\\\");\\\\u000aYUI.presentation.lazyScriptList = [\\\\\\\"http://l.yimg.com/zz/combo?nn/lib/metro/g/yui/oop_3.8.1.js&nn/lib/metro/g/yui/event-custom-base_3.8.1.js&nn/lib/metro/g/yui/event-base_3.8.1.js&nn/lib/metro/g/yui/io-base_3.8.1.js&nn/lib/metro/g/yui/json-parse_3.8.1.js&nn/lib/metro/g/yui/json-stringify_3.8.1.js&nn/lib/metro/g/yui/cookie_3.8.1.js&nn/lib/metro/g/yui/jsonp_3.8.1.js&nn/lib/metro/g/yui/dom-core_3.8.1.js&nn/lib/metro/g/yui/dom-base_3.8.1.js&nn/lib/metro/g/yui/dom-style_3.8.1.js&nn/lib/metro/g/yui/selector-native_3.8.1.js&nn/lib/metro/g/yui/selector_3.8.1.js&nn/lib/metro/g/yui/node-core_3.8.1.js&nn/lib/metro/g/yui/node-base_3.8.1.js&nn/lib/metro/g/yui/node-style_3.8.1.js&nn/lib/metro/g/yui/transition_3.8.2.js&nn/lib/metro/g/yui/selector-css2_3.8.1.js&nn/lib/metro/g/yui/selector-css3_3.8.1.js&nn/lib/metro/g/yui/event-custom-complex_3.8.1.js&nn/lib/metro/g/yui/event-synthetic_3.8.1.js&nn/lib/metro/g/yui/event-focus_3.8.1.js&nn/lib/metro/g/yui/event-delegate_3.8.1.js&nn/lib/metro/g/yui/node-event-delegate_3.8.1.js&nn/lib/metro/g/yui/pluginhost-base_3.8.1.js&nn/lib/metro/g/yui/pluginhost-config_3.8.1.js&nn/lib/metro/g/yui/node-pluginhost_3.8.1.js&nn/lib/metro/g/yui/dom-screen_3.8.1.js&nn/lib/metro/g/yui/node-screen_3.8.1.js&nn/lib/metro/g/yui/gallery-storage-lite_3.8.1.js&nn/lib/metro/g/uicontrib/dali/module_platform_1.1.14.js&nn/lib/metro/g/uicontrib/dali/resourcemgr_1.1.14.js&nn/lib/metro/g/uicontrib/dali/dali_transport_1.1.34.js&nn/lib/metro/g/uicontrib/dali/metro_dali_1.0.27.js&nn/lib/metro/g/uicontrib/dali/module_api_1.1.16.js&nn/lib/metro/g/uicontrib/dali/yui_service_0.1.17.js\\\\\\\"];\\\\u000a\\\\u003C/script\\\\u003E\\\\u000a\\\\u000a\\\\u003Cscript type=\\\\\\\"text/javascript\\\\\\\"\\\\u003E\\\\u000aYUI.presentation.lazyScriptList = YUI.presentation.lazyScriptList.concat([\\\\\\\"http://l.yimg.com/zz/combo?nn/lib/metro/g/uiplugins/metro_viewtype_0.1.24.js&nn/lib/metro/g/uiplugins/default_viewtype_0.1.61.js&nn/lib/metro/g/uiplugins/edit_viewtype_0.1.40.js&nn/lib/metro/g/uicontrib/ylc_1.8.22.js&nn/lib/metro/g/uiplugins/instrumentation_service_0.1.83.js&nn/lib/metro/g/uiplugins/userinfo_service_0.1.15.js&nn/lib/metro/g/uiplugins/statemgr_service_0.1.20.js&nn/lib/metro/g/uiplugins/metrologger_service_0.1.18.js&nn/lib/metro/g/uiplugins/tooltip_service_0.1.56.js&nn/lib/metro/g/uiplugins/autohide_service_0.1.15.js\\\\\\\"]);\\\\u000a\\\\u003C/script\\\\u003E\\\\u000a\\\\u000a\\\\u003Cscript type=\\\\\\\"text/javascript\\\\\\\"\\\\u003E\\\\u000aYUI.presentation.lazyScriptList = YUI.presentation.lazyScriptList.concat([\\\\\\\"http://l.yimg.com/zz/combo?nn/lib/metro2/g/badge/badge_0.1.20.js&nn/lib/metro/g/stream/stream_0.0.456.js&nn/lib/metro/g/uiplugins/storage_service_0.0.1.js&nn/lib/metro/g/uiplugins/login_service_0.0.38.js&nn/lib/metro/g/uiplugins/interests_service_0.1.1.js&nn/lib/metro/g/fstream/fstream_0.0.95.js&nn/lib/metro/g/login/login_0.0.32.js\\\\\\\"]);\\\\u000a\\\\u003C/script\\\\u003E\\\\u000a\\\\u000a\\\\u003Cscript type=\\\\\\\"text/javascript\\\\\\\"\\\\u003E\\\\u000a(function()\\\\u000a{\\\\u000a    YMedia.namespace('dali').config = {\\\\\\\"props\\\\\\\":{\\\\\\\"dali\\\\\\\":{\\\\\\\"crumb\\\\\\\":\\\\\\\"OBQpwrpfCly\\\\\\\",\\\\\\\"yuid\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"loggedIn\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"mLogin\\\\\\\":0},\\\\\\\"proxyUrl\\\\\\\":\\\\\\\"\\\\\\\\/hjs?_mode=html&_create=1&_action=show&_type=badge&_container=1&_chrome=0&view=default&pInitLevel=lite&m_id=p_30345786&m_mode=multipart&configId=MediaRemoteIncludeExternalConfig&hide=0&mod_units=19&app=gs&content_id=5f01278b-803a-3803-9798-7fc79bab4f7d&juris=US&lang=en-US&pu=news.yahoo.com&region=US&se=4402687&site=news&mod_id=p_30345786&suid=30345786&pagetype=minihome&nolz=1&y_proc_embeds=1&y_map_urn=urn%3Armp%3Alite&_product_version=v2&r_inc=1&c_id=p_30345786_container&_sig=8nhtS_52JeXfdiYY25izjGGXZ2I-\\\\\\\"},\\\\\\\"data\\\\\\\":null,\\\\\\\"mods\\\\\\\":[{\\\\\\\"data\\\\\\\":{\\\\\\\"maple\\\\\\\":{\\\\\\\"platform\\\\\\\":{},\\\\\\\"module\\\\\\\":\\\\\\\"badge\\\\\\\",\\\\\\\"instance\\\\\\\":\\\\\\\"badge\\\\\\\",\\\\\\\"signature\\\\\\\":\\\\\\\"he5R2PEbnkHjPiFGhQuSNQ--\\\\\\\"},\\\\\\\"moduleId\\\\\\\":\\\\\\\"u_30345786\\\\\\\"},\\\\\\\"props\\\\\\\":{\\\\\\\"refHandler\\\\\\\":\\\\\\\"cfg.maple_dali.handler.refresh\\\\\\\",\\\\\\\"id\\\\\\\":\\\\\\\"badge\\\\\\\",\\\\\\\"ns\\\\\\\":\\\\\\\"badge\\\\\\\",\\\\\\\"trusted\\\\\\\":true},\\\\\\\"state\\\\\\\":{},\\\\\\\"strs\\\\\\\":{\\\\\\\"STR.MODULE.ERROR_FALLBACK_TEXT\\\\\\\":\\\\\\\"Requested module is not available. Please try again.\\\\\\\",\\\\\\\"STR.EDIT\\\\\\\":\\\\\\\"Settings\\\\\\\",\\\\\\\"STR.EDIT.CLOSE\\\\\\\":\\\\\\\"Close Settings\\\\\\\"},\\\\\\\"res\\\\\\\":{},\\\\\\\"mods\\\\\\\":[{\\\\\\\"data\\\\\\\":{\\\\\\\"maple\\\\\\\":{\\\\\\\"platform\\\\\\\":{},\\\\\\\"module\\\\\\\":\\\\\\\"u_30345786\\\\\\\",\\\\\\\"instance\\\\\\\":\\\\\\\"__mmh_0\\\\\\\",\\\\\\\"ba\\\\\\\":{\\\\\\\"_action\\\\\\\":\\\\\\\"show\\\\\\\",\\\\\\\"chrome\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"_id\\\\\\\":\\\\\\\"u_30345786\\\\\\\"},\\\\\\\"signature\\\\\\\":\\\\\\\"5nh6UiryEE9aP5zSGTFEXg--\\\\\\\"},\\\\\\\"woeId\\\\\\\":12778444,\\\\\\\"intl\\\\\\\":\\\\\\\"us\\\\\\\",\\\\\\\"socialEnabled\\\\\\\":true,\\\\\\\"swipeEnabled\\\\\\\":false,\\\\\\\"fbAcctLinked\\\\\\\":false,\\\\\\\"clientPagination\\\\\\\":true,\\\\\\\"dynamicEnabled\\\\\\\":true,\\\\\\\"removalMenuEnabled\\\\\\\":true,\\\\\\\"closeEnabled\\\\\\\":true,\\\\\\\"markAsReadEnabled\\\\\\\":true,\\\\\\\"tooltipsEnabled\\\\\\\":true,\\\\\\\"batchPause\\\\\\\":0,\\\\\\\"interestFiltersEnabled\\\\\\\":true,\\\\\\\"interestFiltersBroadcast\\\\\\\":true,\\\\\\\"minArticleCount\\\\\\\":6,\\\\\\\"broadcastDynamicEnabled\\\\\\\":true,\\\\\\\"sortBy\\\\\\\":0,\\\\\\\"shareDrawerEnabled\\\\\\\":false,\\\\\\\"saveEnabled\\\\\\\":false,\\\\\\\"scrollBuffer\\\\\\\":900,\\\\\\\"writeMixerActions\\\\\\\":true,\\\\\\\"isRmp\\\\\\\":true,\\\\\\\"interestFiltersNavigate\\\\\\\":true,\\\\\\\"itemClickBroadcastOnly\\\\\\\":true,\\\\\\\"itemClickContext\\\\\\\":true,\\\\\\\"restoreStateExpire\\\\\\\":1800000,\\\\\\\"restoreStateMethod\\\\\\\":\\\\\\\"LOCAL_STORAGE\\\\\\\",\\\\\\\"restoreStateOnCacheMiss\\\\\\\":true,\\\\\\\"batchSize\\\\\\\":20,\\\\\\\"locationPickerEnabled\\\\\\\":false,\\\\\\\"beacon_sec\\\\\\\":\\\\\\\"app-loc\\\\\\\",\\\\\\\"beacon_slk\\\\\\\":\\\\\\\"s-op\\\\\\\",\\\\\\\"beacon_bucketid\\\\\\\":\\\\\\\"900\\\\\\\",\\\\\\\"dynamicCategories\\\\\\\":[{\\\\\\\"name\\\\\\\":\\\\\\\"Politics\\\\\\\",\\\\\\\"id\\\\\\\":\\\\\\\"YCT:001000661\\\\\\\",\\\\\\\"points\\\\\\\":158.92,\\\\\\\"src\\\\\\\":\\\\\\\"core\\\\\\\",\\\\\\\"count\\\\\\\":59,\\\\\\\"occurances\\\\\\\":{\\\\\\\"1\\\\\\\":6,\\\\\\\"2\\\\\\\":2,\\\\\\\"3\\\\\\\":4,\\\\\\\"4\\\\\\\":6,\\\\\\\"5\\\\\\\":7,\\\\\\\"6\\\\\\\":8,\\\\\\\"7\\\\\\\":8,\\\\\\\"8\\\\\\\":13,\\\\\\\"9\\\\\\\":5},\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/news.yahoo.com\\\\\\\\/politics-and-government\\\\\\\\/\\\\\\\"},{\\\\\\\"name\\\\\\\":\\\\\\\"Society\\\\\\\",\\\\\\\"id\\\\\\\":\\\\\\\"YCT:001000780\\\\\\\",\\\\\\\"points\\\\\\\":103.8,\\\\\\\"src\\\\\\\":\\\\\\\"core\\\\\\\",\\\\\\\"count\\\\\\\":36,\\\\\\\"occurances\\\\\\\":{\\\\\\\"1\\\\\\\":2,\\\\\\\"2\\\\\\\":6,\\\\\\\"3\\\\\\\":3,\\\\\\\"4\\\\\\\":4,\\\\\\\"5\\\\\\\":8,\\\\\\\"6\\\\\\\":3,\\\\\\\"7\\\\\\\":4,\\\\\\\"8\\\\\\\":3,\\\\\\\"9\\\\\\\":3},\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/news.yahoo.com\\\\\\\\/society-and-culture\\\\\\\\/\\\\\\\"},{\\\\\\\"name\\\\\\\":\\\\\\\"Crime & Justice\\\\\\\",\\\\\\\"id\\\\\\\":\\\\\\\"YCT:001000667\\\\\\\",\\\\\\\"points\\\\\\\":34.83,\\\\\\\"src\\\\\\\":\\\\\\\"core\\\\\\\",\\\\\\\"count\\\\\\\":14,\\\\\\\"occurances\\\\\\\":{\\\\\\\"1\\\\\\\":1,\\\\\\\"2\\\\\\\":1,\\\\\\\"4\\\\\\\":1,\\\\\\\"5\\\\\\\":2,\\\\\\\"6\\\\\\\":4,\\\\\\\"7\\\\\\\":3,\\\\\\\"8\\\\\\\":1,\\\\\\\"9\\\\\\\":1},\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/news.yahoo.com\\\\\\\\/crime-and-justice\\\\\\\\/\\\\\\\"},{\\\\\\\"name\\\\\\\":\\\\\\\"Education\\\\\\\",\\\\\\\"id\\\\\\\":\\\\\\\"YCT:001000267\\\\\\\",\\\\\\\"points\\\\\\\":29.77,\\\\\\\"src\\\\\\\":\\\\\\\"core\\\\\\\",\\\\\\\"count\\\\\\\":8,\\\\\\\"occurances\\\\\\\":{\\\\\\\"1\\\\\\\":1,\\\\\\\"2\\\\\\\":1,\\\\\\\"3\\\\\\\":2,\\\\\\\"4\\\\\\\":2,\\\\\\\"5\\\\\\\":1,\\\\\\\"9\\\\\\\":1},\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/news.yahoo.com\\\\\\\\/education\\\\\\\\/\\\\\\\"},{\\\\\\\"name\\\\\\\":\\\\\\\"Health\\\\\\\",\\\\\\\"id\\\\\\\":\\\\\\\"YCT:001000395\\\\\\\",\\\\\\\"points\\\\\\\":26.66,\\\\\\\"src\\\\\\\":\\\\\\\"core\\\\\\\",\\\\\\\"count\\\\\\\":6,\\\\\\\"occurances\\\\\\\":{\\\\\\\"1\\\\\\\":1,\\\\\\\"2\\\\\\\":1,\\\\\\\"3\\\\\\\":2,\\\\\\\"4\\\\\\\":2},\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/news.yahoo.com\\\\\\\\/health\\\\\\\\/\\\\\\\"}],\\\\\\\"dynamicEntities\\\\\\\":[{\\\\\\\"name\\\\\\\":\\\\\\\"Barack Obama\\\\\\\",\\\\\\\"id\\\\\\\":\\\\\\\"WIKIID:Barack_Obama\\\\\\\",\\\\\\\"points\\\\\\\":293,\\\\\\\"src\\\\\\\":\\\\\\\"core\\\\\\\",\\\\\\\"count\\\\\\\":293,\\\\\\\"occurances\\\\\\\":{\\\\\\\"1\\\\\\\":2},\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/news.yahoo.com\\\\\\\\/barack-obama\\\\\\\\/\\\\\\\",\\\\\\\"uuid\\\\\\\":\\\\\\\"c200730b-eb18-376d-a3d3-1892197b9f54\\\\\\\"},{\\\\\\\"name\\\\\\\":\\\\\\\"Egypt\\\\\\\",\\\\\\\"id\\\\\\\":\\\\\\\"WIKIID:Egypt\\\\\\\",\\\\\\\"points\\\\\\\":188,\\\\\\\"src\\\\\\\":\\\\\\\"core\\\\\\\",\\\\\\\"count\\\\\\\":188,\\\\\\\"occurances\\\\\\\":{\\\\\\\"1\\\\\\\":1},\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/news.yahoo.com\\\\\\\\/egypt\\\\\\\\/\\\\\\\",\\\\\\\"uuid\\\\\\\":\\\\\\\"c200730b-eb18-376d-a3d3-1892197b9f54\\\\\\\"},{\\\\\\\"name\\\\\\\":\\\\\\\"United States\\\\\\\",\\\\\\\"id\\\\\\\":\\\\\\\"WIKIID:United_States\\\\\\\",\\\\\\\"points\\\\\\\":136,\\\\\\\"src\\\\\\\":\\\\\\\"core\\\\\\\",\\\\\\\"count\\\\\\\":136,\\\\\\\"occurances\\\\\\\":{\\\\\\\"1\\\\\\\":1},\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/www.yahoo.com\\\\\\\\/topic\\\\\\\\/united-states\\\\\\\\/\\\\\\\",\\\\\\\"uuid\\\\\\\":\\\\\\\"c200730b-eb18-376d-a3d3-1892197b9f54\\\\\\\"},{\\\\\\\"name\\\\\\\":\\\\\\\"White House\\\\\\\",\\\\\\\"id\\\\\\\":\\\\\\\"WIKIID:White_House\\\\\\\",\\\\\\\"points\\\\\\\":128,\\\\\\\"src\\\\\\\":\\\\\\\"core\\\\\\\",\\\\\\\"count\\\\\\\":128,\\\\\\\"occurances\\\\\\\":{\\\\\\\"1\\\\\\\":2},\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/news.yahoo.com\\\\\\\\/white-house-2\\\\\\\\/\\\\\\\",\\\\\\\"uuid\\\\\\\":\\\\\\\"590c8c6f-61a8-3dea-9ba7-8cb83525a33b\\\\\\\"},{\\\\\\\"name\\\\\\\":\\\\\\\"Shooting of Trayvon Martin\\\\\\\",\\\\\\\"id\\\\\\\":\\\\\\\"WIKIID:Shooting_of_Trayvon_Martin\\\\\\\",\\\\\\\"points\\\\\\\":120,\\\\\\\"src\\\\\\\":\\\\\\\"core\\\\\\\",\\\\\\\"count\\\\\\\":120,\\\\\\\"occurances\\\\\\\":{\\\\\\\"1\\\\\\\":1},\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/www.yahoo.com\\\\\\\\/topic\\\\\\\\/shooting-of-trayvon-martin\\\\\\\\/\\\\\\\",\\\\\\\"uuid\\\\\\\":\\\\\\\"a2b156e2-bdc5-3dab-bf3c-241d681ef099\\\\\\\"}],\\\\\\\"items\\\\\\\":[{\\\\\\\"u\\\\\\\":\\\\\\\"41b84caa-3b4d-32c7-9ee7-e45c21fc0fb6\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4089900430\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"6f4ca8cf-c412-35d3-853f-9ee636b92373\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000384\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"62787508-255a-3395-82ba-9e62e75cb0f0\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000435\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"8cc97ab2-66d0-3bbb-8b6f-c20ba8d932c4\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4059000616\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"8682b543-884b-33da-a257-f0d05e1a3dfa\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4090000408\\\\\\\"},{\\\\\\\"u\\\\\\\":21370595,\\\\\\\"s\\\\\\\":\\\\\\\"If you have a $500,000 portfolio, download the &quot;15-Minute Retirement Plan&quot; by Forbes columnist Ken Fisher's Firm.\\\\\\\",\\\\\\\"im\\\\\\\":{\\\\\\\"original\\\\\\\":{\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l2.yimg.com\\\\\\\\/av\\\\\\\\/moneyball\\\\\\\\/ads\\\\\\\\/0-1371163702-9044.jpg\\\\\\\",\\\\\\\"width\\\\\\\":82,\\\\\\\"height\\\\\\\":61,\\\\\\\"orientation\\\\\\\":\\\\\\\"landscape\\\\\\\",\\\\\\\"ratio\\\\\\\":1.344262295082}},\\\\\\\"ur\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/ad.yieldmanager.com\\\\\\\\/clk?3,eJytjcsKgzAURH.IRTSmRkIX0ahoNbaQUrK0xqS-doLUr2-1rx.ogbkwzHDHhsRpkAYuwKCutHYVJjbUtd8ArZRnAUKI4.k75CHsY4uuHPF0mlkX9zLYfAaFmOkL81RgwndvvRGDh6p6x-k1GOlfCP2Mpp-v265hmCK9mLvAwbeWSLdw-FAs6pZfzqhM5FSIeChau-WdanMRzbyjQI7xWDLe89.A3rLAA6jKT6A=,http%3A%2F%2Fclk.atdmt.com%2FINV%2Fgo%2F451647339%2Fdirect%2F01%2F\\\\\\\",\\\\\\\"t\\\\\\\":\\\\\\\"4 Ways to Avoid Running Out of Money in Retirement\\\\\\\",\\\\\\\"b\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/ad.yieldmanager.com\\\\\\\\/csc?ve=2&nnedaxJ2wp1pT4ZwGV4gDhYeBEElHwTeHaR66EZPtofFZiP.h3qhAh8D1AlHKzUtktlm12a7lhoaiOxNXb7GPmZy2_VWgTyZzw0xt4aw4mb0_3.5Xu8vcd6SGbF585AHOSTh4pCkdgD7vLoQQ_grHIGl_iCGeDDWb14hcb1OcM5DXq6CLJ8j7K81RZcK.4yJhLz3zTE1OEy3XTYzeA.2TDpLgb68IWRkxY7AKma09CzCbzc.eaNXMGJoCuEvmx.MWug_0mFZ2f_u8khz6Vef0VU7KHYGF93fjHs7c6fZsPAJOZAMZvjtnMZNZYIVTOPWzVD_xB6q_.rHZxX4vheZSNgDhvWuIrcJsu4O_Ur7fWcsyu09Pf_uhSyvwSynUHOxqqPrFqkwcZvRM3_flzSXlWitUznMKGHbIfqWSdmWpSdWEQlil66ZxJP3_XhC4tN8TLfOBNqHvhFwXOOazr0qTmVo.EnXCKZGYCkIeRcy.lhko303jyby1lOyMDrWvmUbqZzZxJJaurUZu1SvfrJ0zJ6oSxA9G33en7QsXtfKP4hqiyob.bOI6KX561sUNSq3A5z8Q61yK.AVSqnZnuMd0ImeL2AT2RO6TVzpXNOyx.4wuiwwcYzchdGVTj_YQkypq1C_7s3lVrWL4zUcCR_AL570O6DuX2g2lEZkb8XpWmk9qpNT1DxIm.nBD1DSV1ZwyKXeaOTVSu8gVVGyHjBi.6akODrY1IoHbGLXWFhY9vV68jSdu5bEZyBI0GCcC5OjwxVahDzX0ruhzsA8QRyFm528h0Zl07chJwDPYi_PkAyGXLLhJqg3oElWSLC87g1Uzw--&ap=29\\\\\\\",\\\\\\\"ia\\\\\\\":1,\\\\\\\"at\\\\\\\":\\\\\\\"Fisher Investments\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"acfa2983-d731-3cbc-a0fc-2ff8ef78e075\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100001372\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"1733412d-c645-3dcc-898f-a3e6b23632c3\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4090000563\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"fa2d95f2-4e85-3cfa-aee0-d5b0c031529f\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000730\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"523fedde-cc12-38fb-86ca-60629888845c\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4090001194\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"e8fcb3d3-00f3-3804-b31c-d387f5b7c8e2\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4053100529\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"d344ace7-22fe-3cab-b829-5c23eb17e754\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4090001080\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"1099eb81-1582-311e-b36e-9a15c7f141e0\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4053100516\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"0827042a-7b69-3744-876a-e63bbaf67e6d\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000368\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"61d9ae23-9b3a-343a-9309-6e2f3cf1dc01\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000293\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"6e2cca72-5335-3ef9-8ebb-e93683d1ee71\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000273\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"f87eaebd-5628-3ec6-b863-c404b0abcee4\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100001060\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"34c6686d-577e-34a0-bb2b-887d9b40d3f5\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000353\\\\\\\"},{\\\\\\\"u\\\\\\\":20637846,\\\\\\\"s\\\\\\\":\\\\\\\"Find Out Which Vehicles Get The Best Gas Mileage. See Our Top 10 Results for Cars, Trucks, and SUVs.\\\\\\\",\\\\\\\"im\\\\\\\":{\\\\\\\"original\\\\\\\":{\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l3.yimg.com\\\\\\\\/av\\\\\\\\/moneyball\\\\\\\\/cleansed\\\\\\\\/282855.jpg\\\\\\\",\\\\\\\"width\\\\\\\":82,\\\\\\\"height\\\\\\\":82,\\\\\\\"orientation\\\\\\\":\\\\\\\"square\\\\\\\",\\\\\\\"ratio\\\\\\\":1}},\\\\\\\"ur\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/ad.yieldmanager.com\\\\\\\\/clk?3,eJytjdsKgkAYhF.IYD2srixd7EHF0DVhS7wM1zVN6caQevryQL1AH8zPDP.AmDa2aqiBAxCoLlo7CmHT1pVfA62UZwCMseX5LvQg8pFBZo5ozCdWuPxOl8ycq5zISvMRbdjWm2.AYfYg-fqWO9qTv8D8A4k3Hy-7DUcE6lfzlIh-a1HppJYYhDz3SXGCWVSOqQz7tDVb0akukcEkOgLKIRwyLm7iN7A3DPAGZfRPKw==,http%3A%2F%2Fwww.autobytel.com%2Ftop-10-cars%2Fbest-gas-mileage-cars%2F%3Fid%3D32929\\\\\\\",\\\\\\\"t\\\\\\\":\\\\\\\"Top 10 Best Gas Mileage Vehicles\\\\\\\",\\\\\\\"b\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/ad.yieldmanager.com\\\\\\\\/csc?ve=2&qzsmLzV2wp2K9aGINWH7y9M8hgZ7miUHN7UiJS.BY5zkRMidN64B35nlkb.wLdLD1BL8KTn.mdRIy2FfIjyaFwOY3ZZsLej2OkhrchS.GulCXbbNSRlTn8LYQ867ug57Kg9vOarUWPjiU76cVavCRaAHVCD4kfxlODDJd.NLgmJSTE3C750JidXG5vDJA0cC4cHgavWFdkyWzRpiigqOxrDdScG6y110r6o_wo7iuP7aTI9BIrGAHlo5K_Dhayx4JBbASvrHdzV6jIp1zh_UhvGhD_ZrTpqDnEFQtlQym.V0AnPiDlp0Gmd4zIHu3.164Ep_kCb50kB9X7XLREzU0t7LxvF2QFSCpgCpPL9f29E69w_MsWjQgTRhrEm3wVHmrrgCeo_ifbyT0w9aK7.qxAtqgPRO.zhAjl2e2jAZuH9q0TiFH9ubIsF04v2Y32JnuSlZYL04WeW3rBsSg3.0cFOpVFGaTk557Z7OAq.JFCmPLfEBAqMReZYFOqFy7jv2JQS6O6KYqB3dBU6V..xtZCH8XBqj84_P2zbtS9PbTgQF44xj8TF.LNIzpGyhHW5XsOjvSfhN6.LbKXz26cDHIayxx_ahuak5Wgn6qVO2WbiJNLJ69lZULHZQt4FgJLIL5mHTQjZ1cLBNGQDVKEPtLzkd6Zvwj5xzEC.3HSblPSjtgnU1jbGWWypqbXJzQJLHOXtVy_gXDYiTqouO2bCuv69hYPY.hli.BYjuaWJiQ8CQVYcg6K1xZTJbFNC_.Bdk14dKMrVziemcYyiChWT7QoMkSJ0.Cw5H0HugXp12a.gGzq3_36IMzz3SP1DHlAWN5g--&ap=42\\\\\\\",\\\\\\\"ia\\\\\\\":1,\\\\\\\"at\\\\\\\":\\\\\\\"Autobytel\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"db5de020-1c28-3992-8b33-7759daa5e05e\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000928\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"0af9f27d-adfd-3b40-bdd2-8ff1b8643742\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4047800699\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"5c9e6d6a-5127-3f87-b77f-6580cd62dfe4\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000932\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"b1f76e13-0b85-3d35-ab05-1b263f119f5a\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000883\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"cfa94c8c-28be-3510-b57a-00b7c3588ab9\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000241\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"e4d5a136-97d8-3124-8ac6-7c020235428f\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000269\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"24e6df26-628f-3a4c-9b98-b22275506fb9\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4081001304\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"ed5c998c-1e32-3302-9d47-7f3957a1fc2f\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4043000567\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"b1151a83-318e-34e2-a2c8-0fe169c1f900\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4090000230\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"bfab8f88-77cf-3ace-b86a-80a4f5d25e89\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000483\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"b4fd501c-2f37-3258-ae09-c23c728290ba\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4059000932\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"73beeae0-a4b3-384b-bf19-be60c1176c1b\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4065600270\\\\\\\"},{\\\\\\\"u\\\\\\\":20626440,\\\\\\\"s\\\\\\\":\\\\\\\"Netflix members can watch as much as they want, anytime, anywhere, on nearly any Internet-connected screen. Only $7.99\\\\\\\\/mo. Sign up today.\\\\\\\",\\\\\\\"im\\\\\\\":{\\\\\\\"original\\\\\\\":{\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l1.yimg.com\\\\\\\\/av\\\\\\\\/moneyball\\\\\\\\/curated\\\\\\\\/202834-1366845045.jpg\\\\\\\",\\\\\\\"width\\\\\\\":82,\\\\\\\"height\\\\\\\":82,\\\\\\\"orientation\\\\\\\":\\\\\\\"square\\\\\\\",\\\\\\\"ratio\\\\\\\":1}},\\\\\\\"ur\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/ad.yieldmanager.com\\\\\\\\/clk?3,eJytjV0LgjAYhf-QF35NN0YX06kYOhMW4a0uh18VZA399aVG.YEeOC.n8B44hoWFU5WVWdYQCiAsUWLDqit01mshoKZjjE0XOcAFEEGNLBzgmCsSP-nVW3NkM67IhnzLk.6nt9yAguxB8u19ud968hd8tCfxx8frrqSQgHqWE4fetxYVdmrmis3dlJyOIIuKMeVhnzZGw1rRJTxQrCV6MYRDRlnHfgM7TdNfkp9Qvg==,https%3A%2F%2Fsignup.netflix.com%2F%3Fmqso%3D81003558\\\\\\\",\\\\\\\"t\\\\\\\":\\\\\\\"Netflix Revolutionizes Movie and TV Watching\\\\\\\",\\\\\\\"b\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/ad.yieldmanager.com\\\\\\\\/csc?ve=2&zWkYpzB2wp0ba3Tgopas6BFRYuE4xz9CbQJTUryvjLap3MzIAsGdm_gAdsSi4z93s3hCwj650aQ170QekJvPpbppwZ0JQlC5fOkR61_rGpcjztv8z0HtNrvZjMmEWj1VSSLk2vDnoCXUHJ4d13JV.r__VupHevR2lkwV81UPZLe.tHC5E84PwiDWjvY609QZPmjXCpKQ6h0rVnxHz1.yDxGJgukh1euQqi26U.AySo.L8f2Ehl8c_xZgluYHv1pqyT15XtdXcj35OQIU8weeVJi5zKhEt2muH6F5yK31DuJXXbmWyl3W9aTH.adyE2tGbtEv3A9w4W0V_senGdwWhu.dnNVGjlRSBXV7Wi0E5jRqhWa1RGsOukRYf__w69u32m7G7E2zswa2UdyBnDNQsgsjfKVZxJHbxsftB2kR1Y11ZnkxdyUYdKbjLjQYLlgC4poPd_pBwTdFWFIC5jka1dyqEaJm6EiudqR6PXTt29IFSl9vSsqFIJYxCTrbSjkwt34_Ykk9KU.wnC427dYP2k_cMOXyhTno3DtpkxDanQFmFWIzDDyxj8mj00.4OKpGs2fDII1SVM7z73pwpkfsg8xdL271Xqtf8_lHvFTM9WA32T3oPX9GLID3PcnQWTSNujIEq7hXbjlr11CsoMXFs4GcVJQvN8JxfD.PRC21p0P4ESq18bkaSY6xr0EtRNAwrXfejiX8DKqkV4rS0hfPzPt7C.8m78gKKeh95scFQ0FDRTkNkFJq8aF4N5llgv2yKH.F8bUJXVbKptR_1.LttZe6D2uIotMhQlwrLSu.1PrMEcCJhBB.cGmP1J4aummTQQ--&ap=55\\\\\\\",\\\\\\\"ia\\\\\\\":1,\\\\\\\"at\\\\\\\":\\\\\\\"Netflix\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"5287b89f-b0f0-3dab-9197-aa22905eaf4b\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000166\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"43b802f5-0558-39cc-9b76-348e3d40edc4\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000175\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"c7c72404-4eb8-3ea3-86b5-2657571ab856\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000427\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"4519c9a6-1a8f-3d9f-bcd3-dc88fec5bc77\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100001187\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"d712ff7a-7042-30b9-8867-19b51ecb96d2\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4065600232\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"37b64b20-2ba3-31e1-9e02-418af076fcf5\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4090000299\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"586a9615-991d-3faf-9c7d-e7ff8179d511\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000367\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"51aceae4-c48c-3955-bc3d-deabf73b0d4c\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100001042\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"1725fbc9-413b-3fff-a0c5-60ec4702f7c2\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000553\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"0d92f3cd-9815-312a-abc3-79c0fa565d00\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4090000263\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"fcb60a92-a1a0-35d5-abcf-08f9f9117095\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4020500659\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"c2ecaa77-69b8-38ea-9a81-866f52ad3b10\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4072900590\\\\\\\"},{\\\\\\\"u\\\\\\\":21713975,\\\\\\\"s\\\\\\\":\\\\\\\"Find out how this unexpected joint solution is helping Americans live happier, healthier lives after 50!\\\\\\\",\\\\\\\"im\\\\\\\":{\\\\\\\"original\\\\\\\":{\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l5.yimg.com\\\\\\\\/av\\\\\\\\/moneyball\\\\\\\\/ads\\\\\\\\/216216-1372864886-2128.jpg\\\\\\\",\\\\\\\"width\\\\\\\":82,\\\\\\\"height\\\\\\\":61,\\\\\\\"orientation\\\\\\\":\\\\\\\"landscape\\\\\\\",\\\\\\\"ratio\\\\\\\":1.344262295082}},\\\\\\\"ur\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/ad.yieldmanager.com\\\\\\\\/clk?3,eJytjcsOgjAURH-IRaEW2jQuylMMtJKApluoJSAkJkJQv97wiP6AZzF3JneSMSFVdlVWVqkxVkhBVVIT6opcgVYKG4BSajnERg7CBBts5oSHbGLwHDzcJR.kWNRsZb5u7W29WQMfiZFl65ub6s7-gkeOLN58vOzWPmZIv-tXjt1vLZK71MqeIs9AcimQiOSQ5mGXNmbDW9UleTDxlgHZh73w-Y3.BvaGAT430E.b,http%3A%2F%2Fwww.instaflex.com%2Freport%2Farticles.php%3Ft202id%3D512118%26t202kw%3Dysa_i_7\\\\\\\",\\\\\\\"t\\\\\\\":\\\\\\\"8 Simple Joint Ingredients You Won't Believe\\\\\\\",\\\\\\\"b\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/ad.yieldmanager.com\\\\\\\\/csc?ve=2&z5Q9IuZ2wp3bd2eG4xH9XWB4PhaW4myay4VzgY1UCeysWm4Sz3hkoRJZIxIVjvpt8.qZvkNg2VEzum.2ZV12VCpiybciLb_X6dhagEMF0YC4nWuvwZuJgvGmDEeN26B6Wuzob2wuJ3F_hXsTuPQVqBfbAb_oEG_Uyj1fJ20USxiKtqoeQ8RwdAmln_wPcjhlLo_sSFXNsj2KFFQYJxp49uHTIVfq81.mrUbHISr52A6uaYmhzcbGmAPZtkOXk6wTaHW1CAStKVb15S3d7an4BGxU8XpC.giGc4hxdHkFpTinG40ecJE2pM6VKR7vwoiVR5OEVv.6IH5rWfUga1V8.B7PWV7_975IVprtXE.glE.0xh0poAHLQXk44h0FY7I0NGnF293lajgLM6hcTcBrAwmHKHbNoO83DkMs8I2FH7qGcfms2eDI41w2ukCykrt8vNGdrdd0MU8OFdbQ2PpiqGskzIFQ9SJeULwqMJwJR2P7RXMKEJFlkihu693VR58Agi.ERg6hXn5xkdJOgFo0kIdbnTRcrK5_Fe.xeevUaNfpP6wKVJKA9iPj.S7Mqv6HJHkUIETeAWtor7mGfsYLXWzb2m.Ir8303EvFvnVlgg8Ro7xUcplwEuumMpOPqwOHA0k7NvjxvzbH_EW6_pJ8maGmPD_uAynDXpt3CnlDa7o0Nl0iOBOr_9kDgkWVyJKswytJDOCGo.bt3UPLgHKmObQMyOh94jg8R_FWsO54ZvJ6UWm4g3_0MvWvFgIM9mG83KcLeS3LywLWKEinSsY.GjCTqlpHlwJCl8bwU_yl3JsC2v71boE77slOwVsfJ_WhfQ--&ap=68\\\\\\\",\\\\\\\"ia\\\\\\\":1,\\\\\\\"at\\\\\\\":\\\\\\\"Instaflex\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"1be2994f-2025-3f60-a257-3e7a48049747\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4081000572\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"de1a9017-c4fa-375a-ba6c-f3ffea663e3d\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4072900197\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"9cf878bf-6b71-312f-aae4-95d81bab2441\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100001024\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"7c28287a-cd26-3ecf-a193-d1775345c1b9\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4081000424\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"fad57397-28be-3323-9ee7-d379519b57b8\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4090000132\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"a39d803c-107e-3210-91b9-404f0f9f688c\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4065600702\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"fccf2bde-bbc9-3aef-880e-ce36cae7f85a\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100001033\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"b4302a7d-ee75-3d80-855f-de2dee077577\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4072900375\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"9bf503a7-4f45-3294-9446-d57ed3fa0f76\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4034800382\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"87c2b200-aa22-3ecf-99d6-72a7c6012b2d\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4038700255\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"4ed583ae-67ff-3853-aaf1-86901581ce2d\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4059000197\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"47b95c91-2def-3d3c-9b80-9fd816c94043\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100001213\\\\\\\"},{\\\\\\\"u\\\\\\\":20950156,\\\\\\\"s\\\\\\\":\\\\\\\"Local auto dealers have begun cutting their prices for the summer.  If you're looking for a new car this season, buy now and save as much as ...\\\\\\\",\\\\\\\"im\\\\\\\":{\\\\\\\"original\\\\\\\":{\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l2.yimg.com\\\\\\\\/av\\\\\\\\/moneyball\\\\\\\\/ads\\\\\\\\/206635-1369234902-9746.jpg\\\\\\\",\\\\\\\"width\\\\\\\":82,\\\\\\\"height\\\\\\\":80,\\\\\\\"orientation\\\\\\\":\\\\\\\"landscape\\\\\\\",\\\\\\\"ratio\\\\\\\":1.025}},\\\\\\\"ur\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/ad.yieldmanager.com\\\\\\\\/clk?3,eJytjl8LgjAUxb-QD9M53Rg9zL9ZOhOM2KO6Zlq-hDDs05c26Av0g3M5h3vhXBtS6XVt57QKY4kklC21oerIFSgpsQUopY5PPOQjTLDFVk54rnRYPCMcbHl.I7VmX.qPgj40d-uMI3hsGrPWAE3sL4TkwDLjs623jzBD6tUvtflrJRVu4VSLGDM3v5xRmYq5qJNHMdgDH-WU17HmIwNiSqYy4nf-K9hZFngDFB1Pww==,http%3A%2F%2Fpixel.autoaffiliatenetwork.com%2Fd%2F%3Fid%3D009%26adtargeting%3Dimage_Chrysler300_text_Summer2013%26dest%3DAPF\\\\\\\",\\\\\\\"t\\\\\\\":\\\\\\\"Auto Dealers Cut Prices for Summer 2013\\\\\\\",\\\\\\\"b\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/ad.yieldmanager.com\\\\\\\\/csc?ve=2&wgk9rVF2wp3mSOqz_lLU1uYrg_eo62EPleF_B4Y8TfVRrLgxq2OucRooPK62BnKioNxCjco237tZGFe1LIRJOTt9Np0xZ6blWoAH3.gFIKMQgCz.GAk1kZvM1CZc.VrDtfOtauBmrchheiP9KEIBJhe1gmBsXrQqATXH4UPmmj8G4YSAs.ivPwBlIWTio6m6evw9Zn7B41C952pphaMA1cPMzLK2ofaUn_tcYex0pIFJtZOEvOwAM8pEhV92nVqtfnoJNoM8T68_.D0toqJJ9x.Wiu_oVFXOWCkZ4uJwLKrMfLlvXZ4wd95GW1bIKm__CwtKWQ9qfqF3Vy.9tJtMTx4iBrl1R3LnyqBCV3PNWTtXib1iNxNhWUg2vRYbiqXaBM.HYQyAHUXtc17nnjYpDJDizo3J6osrvk3dA5eDKw2ypj_P_LyaJHVeFaaAwubd0r.OZ1oGq_3b3AmAAjvdbDyihyjFEM7RxwCjW43EA6nbJFz868ZbDdMMUhGFV8kMySkUvAqaT8hAO3et8D1c8ZqPHuML3C_DfbHiC7EdlXQWhlGHbt40bN7fEo0skMKVeLYOLE5xmCYk5avdkwaHbYai8lO3m1lgv1UiTvgK5IGpipNi0LV5Jgo52I6sZ7GMMwbHIf5cqE0_Ss9MKpdU_UPDRLfQpLu87NBYUY1Qbxkb7Z9XiYUv8uEG583rZKxhVLCDdECG6q4BjgnBZwdf9KXTUyHiT.jwzyYt_f0yIHSpGACJIowkyI5MQONoaoxN05fx4TxXI761SEAGPd4LfRQ7uBQwYzjknlwGdvR6ZmlepElIPowTpbio673OH.SG_w--&ap=81\\\\\\\",\\\\\\\"ia\\\\\\\":1,\\\\\\\"at\\\\\\\":\\\\\\\"Auto-Price-Finder.com\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"3a34e541-0403-3e59-b0d0-f0fb28666525\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4025400410\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"8f518ad0-4b6e-34f0-97b0-81fcf08ebaea\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4053100205\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"e4bb5d47-7633-3c34-83d5-0612bbb1da97\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4034800337\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"dacd78e7-9feb-3a5b-93da-4671482229b2\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4034800248\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"e771ab9e-bef4-36f0-a1f6-745e13c58aa4\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4053100169\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"4832980c-2037-3392-b43e-846739d2a79e\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100001064\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"b4bebef1-c728-3d5b-9f21-cee351d0c35a\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4031300420\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"365f8ec3-3449-3292-bedd-b8525ea07a98\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4053100421\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"81e651ea-58d5-34ac-8d57-fb424d7b24a0\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4020500310\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"ade7515b-f561-356b-810d-457e63632c09\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000961\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"7ac0b3f5-9a41-3595-85e7-b394b8f49b28\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4031300207\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"840f9c6d-87ba-3b2d-aa1a-3c3c4b7a5a4c\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4022800272\\\\\\\"},{\\\\\\\"u\\\\\\\":20802476,\\\\\\\"s\\\\\\\":\\\\\\\"A recently published study shows no long-term benefit from traditional glucosamine joint supplements. See the study results to learn more.\\\\\\\",\\\\\\\"im\\\\\\\":{\\\\\\\"original\\\\\\\":{\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l3.yimg.com\\\\\\\\/av\\\\\\\\/moneyball\\\\\\\\/ads\\\\\\\\/0-1368480943-1495.jpg\\\\\\\",\\\\\\\"width\\\\\\\":50,\\\\\\\"height\\\\\\\":75,\\\\\\\"orientation\\\\\\\":\\\\\\\"portrait\\\\\\\",\\\\\\\"ratio\\\\\\\":0.66666666666667}},\\\\\\\"ur\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/ad.yieldmanager.com\\\\\\\\/clk?3,eJytjcsOgjAURH-IRXmVNo2L8gwIxRqI6ZKAraC4kUjk6xXS6A94krmZyZ1kTJsAD0IbOtJB0jJl1xLTli0-A9l12ACEEMvD0PVchJFBVw5o4nPwaBbgbznjz5pq1Ee-CnRvvVFo75tGv.nxcqd.IcAZTbVPt10VIurKRb0q5H9riXAKiy.Cyob8VLtlIqaiim9Fb.ZsUHNeRTMbKBBjPJYhu7LfwM4wwBtnLk9N,http%3A%2F%2Fwww.naturaljoint.org\\\\\\\",\\\\\\\"t\\\\\\\":\\\\\\\"Studies Show No Long-Term Benefit From Glucosamine\\\\\\\",\\\\\\\"b\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/ad.yieldmanager.com\\\\\\\\/csc?ve=2&ZQjKS5t2wp3tdUaHBIGodCYuG_f3c5Q4RHqRNOmFAIMu41CRpQIRRuAAZhRoQCp5qJKzdMRuKPM32HsWqTY84M2.gIvMeyqpFp.vbvxAwvHnDikl1xhO3T5SmF3n7_1uXWU.4F5umCyNbqAcCSf4n9qnGYNOxMSL_.KmxOc.3liYZsT_.CUaPGJ.cy4o_yTOMOXpIXVik6NPLnIGSjGNkCpatrycqxM2aZ7mTp.lyI0E8GbTfGd1QSEooEp2eEFenA8mlljk2vlxuFzN4mrivDaUVzu6X9BDgVFi21ZsDPWnGhTkBD8c2rb4yTPIwqKUBWdm6GNRabofrfmgc2zV4tnU9WpW13xA7DTsCIwTzynBadCXAq9W_vevF4rpXCgr4f0mSltZ6F_wCi.S0l29bYmKwY3vBoOWjw502JfwyHh9VSVJz.Gj.kEkeUYhCqMYDGy5dnY0B4my.n6Xv5GrxXYJpItSEU.6v_ELmSGOTvGBH.7T7ubN51tyKu2GnbYuvvTHcCy12rZ5K6F4UFiehMvRIse9ZqtRorK6PpgJ04.9KJEtxwkrjXrNEUnSGkBtO_pH4MxMlHMQBs1_8BfE1_3dwmgEkgnAbFywwYiH9eythSiYeuypC0hsSF1T37y1La2n_W6zqab560xTMLB8KDXxgxYhkykOhrrsGlutOqYFEUt_VjYxZ8MNiu6RDbJhUrTZs55XTY0qs4_Wu5BjhbyOB5QiuXFfXtR.AFpVXkfhYRZmebXzZeUKeafnJQYvAxAYVEK_KjbkdxzEBOgptMZuEqSn2UJl2PRqDhFu.qlbE7nElmRpvh6Zz9ulSbNjvw--&ap=94\\\\\\\",\\\\\\\"ia\\\\\\\":1,\\\\\\\"at\\\\\\\":\\\\\\\"Greek Island Labs\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"d443a8ca-9d9d-3adf-aaaf-00d01aee0747\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4028200497\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"036f4818-5282-3896-a7c0-e03a87689ca5\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4016600299\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"5405616f-5db9-3cf0-b76d-6c0ae86b8d0e\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4015000774\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"8ffe28b2-6ff5-3f89-87b3-73f90aab3ce0\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4020500222\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"77d99ad3-23b2-31a4-9d15-beda9147cf9e\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4090001038\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"6721eeda-5e99-3b9e-85b2-ad4f1a29ffa3\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4010000398\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"64a0f5e9-826f-30c1-b87a-cdd14e8f044b\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4022800216\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"e8f5bb9e-a7fa-3ddc-a3ed-5984194e14d1\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4018500417\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"4398511d-e0b9-3bcc-b8d7-8c927257da97\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4020500168\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"0224f7db-6b78-37eb-bb13-96c734c79645\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100001084\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"716a86c2-e772-3b80-ba2f-37ed8ecda763\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4012100274\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"3b06a203-610c-3a58-8024-a51b661e896b\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100001004\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"af11785a-f5c8-3e8d-bf22-0a8d0203aa77\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4012100286\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"fab07708-6eec-331c-a049-53f865291f9b\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4012100261\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"55836cbc-0d5c-3fbe-b9bf-13bdbb891e66\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4005302076\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"d8c76553-0434-33b6-b68c-a39e35bba1bb\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4013500176\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"95cbd68e-ffcb-3da5-8dfd-436af201ec90\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4009800349\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"e8528082-d943-35fc-af50-14e4c1f8180e\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4010900162\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"45888b8f-3460-3aa1-9a52-2dfe51afff60\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000940\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"3a8ef146-eaf8-30f1-ab7f-bab556ede552\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4010000412\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"f0e4f3e4-7690-38c4-b0b0-ba27c7800fdc\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4010000176\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"f784f21c-dea8-3214-a2bd-4448415496ff\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4007900196\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"733bf5ee-6160-3040-82d5-1d2f42636f8b\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000874\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"db5e4a50-d8ef-386f-b1e6-e25cdf7f287a\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4009800156\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"90742b99-96f2-38a3-9ad1-f55b2620aaee\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4010000159\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"2ad2eb07-5b9c-307c-b9ff-bcb3aa6bf5b8\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4009000163\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"83795d21-e026-38af-b60b-62dc9facb361\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4007100533\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"f8528bff-bebc-36e9-9e88-cc513c0787c6\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000869\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"5dc7227d-d4a6-352f-8649-0db6aa60341d\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4007100507\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"43e80a47-79ec-3809-ac98-1518389138c7\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4005300268\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"2efae028-b5e0-39a5-980b-7c19ab0f0244\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4007900187\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"9db1ef8a-a304-3fa9-9e1c-b465e737c544\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4004700714\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"6c039a5e-146d-3da8-812c-fb6d65e19f76\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4005800470\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"c2ab26f4-4d85-34de-9900-e8fb300fc296\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000965\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"0bb3174a-3588-3c95-a547-6c0cb658a1c0\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4007100521\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"b40c8d61-0cfc-365c-919f-dc77294f18e1\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4004700201\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"929877e0-37bb-39dd-9bee-f9e8bbe00dc9\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4006400154\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"8a47ca09-04b3-337f-b6ff-583211b66950\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4004700159\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"a63cf34e-c218-3e8d-892b-0bbc6156f9d8\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100001054\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"973d19f5-0a84-333c-b992-8eeedd738f43\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4005800130\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"4153a74c-4462-3ee0-bc00-dff34f2d850f\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4005200351\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"7e9aea73-f2a9-3a22-bbf3-d6e29ae9fe19\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4003800180\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"97231cf5-bb20-3ff0-802b-a452829f1fa8\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4003400207\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"09c0d581-8f4f-3555-871e-31a0b18a7951\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000916\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"3d28a848-ba81-36fe-9887-29f619d7ccf4\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4001600320\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"1216abdc-0bc1-3b4c-b978-4c4d848a26bb\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4002500171\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"45860a48-cd9e-3f22-b47b-d286f2110b6a\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000400834\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"502e5b36-45b9-3ee1-bfe1-648774619bcb\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4002200280\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"5ba9c757-db40-3d11-bf39-ae7cc0a41761\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4001100426\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"9e07f5b8-ae97-3c06-9843-1beaf8ff297e\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000935\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"f540de91-027a-3001-8280-5af27c52c12c\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000300502\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"e2b6485f-3de9-3bba-85da-4ddb382a056f\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100001019\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"fe72c946-5768-3657-aaa1-d0c92ed812b4\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000200523\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"2f6fa4bf-7163-3097-962e-5dbd610c2c21\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000200360\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"1d1e6988-fd19-36ec-a633-a290e04d1bab\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000100441\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"24f5c185-57dc-37e7-8698-dd1838bda8a4\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000200732\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"7940011d-7d91-3045-a1aa-eeecfdd0450c\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000100312\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"12577891-fe2e-3bf6-8872-48283cc99542\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000100230\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"db030f8d-4a11-31e4-86e4-cb8f0f8aaf82\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000891\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"3c1b56c7-a888-3532-8f69-823389ab58d7\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000100152\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"bd973d04-cffe-3617-bc91-64631e02e263\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000100304\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"8ca67350-b65a-3884-b411-df6018ebbf14\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000837\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"e115e1c2-e6e7-34b5-8725-65647725e6f3\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000000218\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"3184a818-422d-31fa-b2ca-3fc25f1e8306\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000000320\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"9d0d8429-ce92-3d20-96df-8dcdc20a1185\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000000347\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"da3fd914-a729-3606-93ce-58d974416a92\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000000246\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"ebe271cf-d612-3d45-8886-03aeb92bb7cd\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000000362\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"2382e5e0-34c2-3019-9bc1-dd64411f42b6\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000828\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"6ae66b10-fc06-31ad-bdce-f630dab5f4fc\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000000301\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"979f41be-1edc-32f5-ac09-17715c88e294\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000000282\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"d8ca681e-2bfb-3e08-b33f-0d41e9916217\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000000292\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"933524d2-947f-3f9c-aeae-a5a45b0619b8\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4065601209\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"d9a55b19-9a27-3da5-b16b-c6f245fbc386\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000000131\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"9d198649-3883-3f02-a39f-33e7c6ac21f8\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000000155\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"4ec09f8e-84c3-3934-b092-39cb092d10a2\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000000510\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"89f6b64e-b044-3bcf-9af8-7a8e16cba9c4\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000000328\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"8a1c7605-0ff6-3150-9990-76dae34185d8\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000002190\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"408b827f-4639-3495-bbc5-33698c6a3bc7\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000000560\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"fcc8c90a-e9a3-3d4d-b0c6-80066b5a761a\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100001013\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"c96bd902-72ef-3422-a162-bb80c37028e1\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000000207\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"44f44e84-8894-3136-b6fc-efb8b7c77f84\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000000238\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"29b950b3-b185-31cd-97ed-21927a63fabc\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000898\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"8cff3d5f-1313-3198-b0c2-c9582925c56c\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000000321\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"bcd13eef-3b76-3eb8-b13e-66e0a2432378\\\\\\\",\\\\\\\"flbk\\\\\\\":true},{\\\\\\\"u\\\\\\\":\\\\\\\"cf8c7775-d027-3207-af8c-86bffe8db6fe\\\\\\\",\\\\\\\"flbk\\\\\\\":true}],\\\\\\\"contentpos\\\\\\\":22,\\\\\\\"interestsData\\\\\\\":{\\\\\\\"YCT:001000667\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Crime & Justice\\\\\\\",\\\\\\\"count\\\\\\\":0,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/news.yahoo.com\\\\\\\\/crime-and-justice\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"YCT:001000780\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Society\\\\\\\",\\\\\\\"count\\\\\\\":164,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/news.yahoo.com\\\\\\\\/society-and-culture\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Shooting_of_Trayvon_Martin\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Shooting of Trayvon Martin\\\\\\\",\\\\\\\"count\\\\\\\":120,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/www.yahoo.com\\\\\\\\/topic\\\\\\\\/shooting-of-trayvon-martin\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"YCT:001000661\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Politics\\\\\\\",\\\\\\\"count\\\\\\\":161,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/news.yahoo.com\\\\\\\\/politics-and-government\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"YCT:001000700\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Immigration Issues\\\\\\\",\\\\\\\"count\\\\\\\":0,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/news.yahoo.com\\\\\\\\/immigration-issues\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Culture_of_the_United_States\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Culture of the United States\\\\\\\",\\\\\\\"count\\\\\\\":1,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/www.yahoo.com\\\\\\\\/topic\\\\\\\\/culture-of-the-united-states\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"YCT:001000346\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Personal Investing Ideas & Strategies\\\\\\\",\\\\\\\"count\\\\\\\":48,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/news.yahoo.com\\\\\\\\/personal-investing-ideas-and-strategies\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"YCT:001000992\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Transportation\\\\\\\",\\\\\\\"count\\\\\\\":0,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/news.yahoo.com\\\\\\\\/transportation\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"YCT:001000395\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Health\\\\\\\",\\\\\\\"count\\\\\\\":167,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/news.yahoo.com\\\\\\\\/health\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"YCT:001000495\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Family Health\\\\\\\",\\\\\\\"count\\\\\\\":0,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/news.yahoo.com\\\\\\\\/family-health\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"YCT:001000069\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Celebrities\\\\\\\",\\\\\\\"count\\\\\\\":86,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/news.yahoo.com\\\\\\\\/celebrities\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"YCT:001000070\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Royal Families\\\\\\\",\\\\\\\"count\\\\\\\":0,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/news.yahoo.com\\\\\\\\/royal-families-2\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Prince_Harry_of_Wales\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Prince Harry of Wales\\\\\\\",\\\\\\\"count\\\\\\\":1,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/www.yahoo.com\\\\\\\\/topic\\\\\\\\/prince-harry-of-wales\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Kensington_Palace\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Kensington Palace\\\\\\\",\\\\\\\"count\\\\\\\":2,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/www.yahoo.com\\\\\\\\/topic\\\\\\\\/kensington-palace\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"YCT:001000680\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Foreign Policy\\\\\\\",\\\\\\\"count\\\\\\\":39,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/news.yahoo.com\\\\\\\\/foreign-policy\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Barack_Obama\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Barack Obama\\\\\\\",\\\\\\\"count\\\\\\\":293,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/news.yahoo.com\\\\\\\\/barack-obama\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Mohamed_Morsi\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Mohamed Morsi\\\\\\\",\\\\\\\"count\\\\\\\":89,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/www.yahoo.com\\\\\\\\/topic\\\\\\\\/mohamed-morsi\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Egypt\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Egypt\\\\\\\",\\\\\\\"count\\\\\\\":188,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/news.yahoo.com\\\\\\\\/egypt\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:United_States\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"United States\\\\\\\",\\\\\\\"count\\\\\\\":136,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/www.yahoo.com\\\\\\\\/topic\\\\\\\\/united-states\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Hosni_Mubarak\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Hosni Mubarak\\\\\\\",\\\\\\\"count\\\\\\\":36,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/news.yahoo.com\\\\\\\\/hosni-mubarak\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Cairo\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Cairo\\\\\\\",\\\\\\\"count\\\\\\\":6,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/www.yahoo.com\\\\\\\\/topic\\\\\\\\/cairo\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"YCT:001000267\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Education\\\\\\\",\\\\\\\"count\\\\\\\":46,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/news.yahoo.com\\\\\\\\/education\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"YCT:001000269\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Schools\\\\\\\",\\\\\\\"count\\\\\\\":0,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/news.yahoo.com\\\\\\\\/schools\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Elementary_school\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Elementary school\\\\\\\",\\\\\\\"count\\\\\\\":1,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/news.yahoo.com\\\\\\\\/elementary-school\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Immigration_reform\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Immigration reform\\\\\\\",\\\\\\\"count\\\\\\\":32,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/www.yahoo.com\\\\\\\\/topic\\\\\\\\/immigration-reform\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"YCT:001000705\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Military\\\\\\\",\\\\\\\"count\\\\\\\":53,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/news.yahoo.com\\\\\\\\/military-and-defense\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Unmanned_aerial_vehicle\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Unmanned aerial vehicle\\\\\\\",\\\\\\\"count\\\\\\\":2,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/www.yahoo.com\\\\\\\\/topic\\\\\\\\/unmanned-aerial-vehicle\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Aircraft_carrier\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Aircraft carrier\\\\\\\",\\\\\\\"count\\\\\\\":1,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/www.yahoo.com\\\\\\\\/topic\\\\\\\\/aircraft-carrier\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Patuxent_River\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Patuxent River\\\\\\\",\\\\\\\"count\\\\\\\":1,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/www.yahoo.com\\\\\\\\/topic\\\\\\\\/patuxent-river\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"YCT:001000123\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Business\\\\\\\",\\\\\\\"count\\\\\\\":0,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/news.yahoo.com\\\\\\\\/business\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Panera_Bread\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Panera Bread\\\\\\\",\\\\\\\"count\\\\\\\":11,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/www.yahoo.com\\\\\\\\/topic\\\\\\\\/panera-bread\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"YCT:001000804\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Religion\\\\\\\",\\\\\\\"count\\\\\\\":30,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/news.yahoo.com\\\\\\\\/religion-and-beliefs\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Southern_Baptist_Convention\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Southern Baptist Convention\\\\\\\",\\\\\\\"count\\\\\\\":1,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/www.yahoo.com\\\\\\\\/topic\\\\\\\\/southern-baptist-convention\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:National_Security_Agency\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"National Security Agency\\\\\\\",\\\\\\\"count\\\\\\\":62,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/www.yahoo.com\\\\\\\\/topic\\\\\\\\/national-security-agency\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:California\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"California\\\\\\\",\\\\\\\"count\\\\\\\":73,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/news.yahoo.com\\\\\\\\/california\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Solitary_confinement\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Solitary confinement\\\\\\\",\\\\\\\"count\\\\\\\":2,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/www.yahoo.com\\\\\\\\/topic\\\\\\\\/solitary-confinement\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"YCT:001000681\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Government\\\\\\\",\\\\\\\"count\\\\\\\":0,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/news.yahoo.com\\\\\\\\/government\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:White_House\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"White House\\\\\\\",\\\\\\\"count\\\\\\\":128,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/news.yahoo.com\\\\\\\\/white-house-2\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Presidency_of_Barack_Obama\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Presidency of Barack Obama\\\\\\\",\\\\\\\"count\\\\\\\":46,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/www.yahoo.com\\\\\\\\/topic\\\\\\\\/presidency-of-barack-obama\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Patient_Protection_and_Affordable_Care_Act\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Patient Protection and Affordable Care Act\\\\\\\",\\\\\\\"count\\\\\\\":33,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/news.yahoo.com\\\\\\\\/patient-protection-and-affordable-care-act\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Ink_cartridge\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Ink cartridge\\\\\\\",\\\\\\\"count\\\\\\\":1,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/www.yahoo.com\\\\\\\\/topic\\\\\\\\/ink-cartridge\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1}},\\\\\\\"ccode\\\\\\\":\\\\\\\"news\\\\\\\"},\\\\\\\"props\\\\\\\":{\\\\\\\"refHandler\\\\\\\":\\\\\\\"cfg.maple_dali.handler.refresh\\\\\\\",\\\\\\\"id\\\\\\\":\\\\\\\"u_30345786\\\\\\\",\\\\\\\"ns\\\\\\\":\\\\\\\"type_stream\\\\\\\",\\\\\\\"trusted\\\\\\\":true,\\\\\\\"type\\\\\\\":\\\\\\\"stream\\\\\\\",\\\\\\\"contentId\\\\\\\":\\\\\\\"30345786\\\\\\\",\\\\\\\"tags\\\\\\\":[],\\\\\\\"title\\\\\\\":\\\\\\\"Stream\\\\\\\",\\\\\\\"icon\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"shortTitle\\\\\\\":\\\\\\\"Stream\\\\\\\",\\\\\\\"detailUrl\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"chromecolor\\\\\\\":\\\\\\\"blue\\\\\\\"},\\\\\\\"state\\\\\\\":{\\\\\\\"view\\\\\\\":\\\\\\\"default\\\\\\\",\\\\\\\"defer\\\\\\\":false,\\\\\\\"collapsed\\\\\\\":0},\\\\\\\"strs\\\\\\\":{\\\\\\\"STR.LOADING\\\\\\\":\\\\\\\"\\\\u003Cdiv class=\\\\\\\\\\\\\\\"fp-loader ti\\\\\\\\\\\\\\\"\\\\u003ELoad more stories\\\\u003C\\\\\\\\/div\\\\u003E\\\\\\\",\\\\\\\"STR.LOADING.CONTENT\\\\\\\":\\\\\\\"\\\\u003Cdiv class=\\\\\\\\\\\\\\\"loading next-batch\\\\\\\\\\\\\\\" data-key=\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\\\\\\\\\"fp-loader ti\\\\\\\\\\\\\\\"\\\\u003ELoad more stories&hellip;\\\\u003C\\\\\\\\/div\\\\u003E\\\\u003C\\\\\\\\/div\\\\u003E\\\\\\\",\\\\\\\"STR.BUTTON.REMOVE_DONE\\\\\\\":\\\\\\\"\\\\u003Cbutton class=\\\\\\\\\\\\\\\"fz-xxs remove-done uibutton rapid-noclick-resp\\\\\\\\\\\\\\\"\\\\u003EDone\\\\u003C\\\\\\\\/button\\\\u003E\\\\\\\",\\\\\\\"STR.REMOVE.CONFIRM\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"STR.BUTTON.WIKIID\\\\\\\":\\\\\\\"\\\\u003Cbutton class=\\\\\\\\\\\\\\\"fz-xxs wikiid uibutton rapid-noclick-resp {selected}\\\\\\\\\\\\\\\" data-wikiid=\\\\\\\\\\\\\\\"{id}\\\\\\\\\\\\\\\" data-interesttype=\\\\\\\\\\\\\\\"{type}\\\\\\\\\\\\\\\"\\\\u003E{name}\\\\u003Cspan class=\\\\\\\\\\\\\\\"d-ib img-sprite remove-neg\\\\\\\\\\\\\\\"\\\\u003E\\\\u003C\\\\\\\\/span\\\\u003E\\\\u003C\\\\\\\\/button\\\\u003E\\\\\\\",\\\\\\\"STR.SHOW.LESS\\\\\\\":\\\\\\\"\\\\u003Cdiv class=\\\\\\\\\\\\\\\"show-less fz-xs\\\\\\\\\\\\\\\"\\\\u003EShow me fewer stories about:\\\\u003C\\\\\\\\/div\\\\u003E\\\\\\\",\\\\\\\"STR.REMOVE.MENU\\\\\\\":\\\\\\\"\\\\u003Cdiv class=\\\\\\\\\\\\\\\"menu\\\\\\\\\\\\\\\"\\\\u003E\\\\u003Cbutton class=\\\\\\\\\\\\\\\"fz-xs undo rapid-noclick-resp\\\\\\\\\\\\\\\"\\\\u003EUndo\\\\u003C\\\\\\\\/button\\\\u003E\\\\u003Cp class=\\\\\\\\\\\\\\\"title fz-xs\\\\\\\\\\\\\\\"\\\\u003EStory removed\\\\u003C\\\\\\\\/p\\\\u003E\\\\u003Cdiv class=\\\\\\\\\\\\\\\"remove-menu-main cf\\\\\\\\\\\\\\\"\\\\u003E\\\\u003C\\\\\\\\/div\\\\u003E\\\\u003Cdiv class=\\\\\\\\\\\\\\\"login hidden\\\\\\\\\\\\\\\"\\\\u003E\\\\u003Cdiv id=\\\\\\\\\\\\\\\"default-p_30345826_e86\\\\\\\\\\\\\\\" class=\\\\\\\\\\\\\\\"mod view_default\\\\\\\\\\\\\\\"\\\\u003E  \\\\u003Cdiv id=\\\\\\\\\\\\\\\"default-p_30345826_e86-bd\\\\\\\\\\\\\\\" class=\\\\\\\\\\\\\\\"bd type_login type_login_default\\\\\\\\\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\\\\\\\\\"embed\\\\\\\\\\\\\\\"\\\\u003E\\\\u003Ch3 class=\\\\\\\\\\\\\\\"title mb-l\\\\\\\\\\\\\\\"\\\\u003ESign in to save your preferences:\\\\u003C\\\\\\\\/h3\\\\u003E\\\\u003Cdiv class=\\\\\\\\\\\\\\\"btns fz-xs\\\\\\\\\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\\\\\\\\\"login-svc ylogin login-btn-purple rapid-noclick-resp login-btn-small\\\\\\\\\\\\\\\" href=\\\\\\\\\\\\\\\"https:\\\\\\\\/\\\\\\\\/login.yahoo.com\\\\\\\\/config\\\\\\\\/login?.src=fpctx&.intl=us\\\\\\\\\\\\\\\" data-action=\\\\\\\\\\\\\\\"click\\\\\\\\\\\\\\\" data-action-outcome=\\\\\\\\\\\\\\\"login\\\\\\\\\\\\\\\" data-ylk=\\\\\\\\\\\\\\\"sec:td-strm-rm;slk:login-yh;itc:0;cat:;\\\\\\\\\\\\\\\"\\\\u003E\\\\u003Ci class=\\\\\\\\\\\\\\\"img-sprite y-icon\\\\\\\\\\\\\\\"\\\\u003E\\\\u003C\\\\\\\\/i\\\\u003EYahoo!\\\\u003C\\\\\\\\/a\\\\u003E \\\\u003Cspan class=\\\\\\\\\\\\\\\"login-or d-ib\\\\\\\\\\\\\\\"\\\\u003Eor\\\\u003C\\\\\\\\/span\\\\u003E \\\\u003Cspan class=\\\\\\\\\\\\\\\"fb-button-wrapper d-ib\\\\\\\\\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\\\\\\\\\"login-svc fblogin login-btn-fbblue rapidnofollow rapid-noclick-resp login-btn-small\\\\\\\\\\\\\\\" href=\\\\\\\\\\\\\\\"http:\\\\\\\\/\\\\\\\\/open.login.yahoo.net\\\\\\\\/openid\\\\\\\\/yrp\\\\\\\\/hr_signin?.intl=us&idp=facebook&ts=1373481532&rpcrumb=GqjYGTOGPyf&.src=home&appid=90376669494&spid=b9ed13cc-ddec-11de-9c83-001b784d35e1&perms=email,user_birthday,user_education_history,user_likes,user_location,user_relationships,user_subscriptions,user_work_history,friends_birthday,friends_education_history,friends_likes,friends_location,friends_work_history\\\\\\\\\\\\\\\" data-action=\\\\\\\\\\\\\\\"click\\\\\\\\\\\\\\\" data-action-outcome=\\\\\\\\\\\\\\\"login\\\\\\\\\\\\\\\" data-ylk=\\\\\\\\\\\\\\\"sec:td-strm-rm;slk:login-fb;cat:;\\\\\\\\\\\\\\\" target=\\\\\\\\\\\\\\\"_blank\\\\\\\\\\\\\\\"\\\\u003E\\\\u003Ci class=\\\\\\\\\\\\\\\"img-sprite fb-icon\\\\\\\\\\\\\\\"\\\\u003E\\\\u003C\\\\\\\\/i\\\\u003EFacebook\\\\u003C\\\\\\\\/a\\\\u003E\\\\u003Cspan class=\\\\\\\\\\\\\\\"fb-disclaimer narrow-disclaimer fz-xxs\\\\\\\\\\\\\\\"\\\\u003EWe don't post anything without your permission.\\\\u003C\\\\\\\\/span\\\\u003E\\\\u003C\\\\\\\\/span\\\\u003E\\\\u003C\\\\\\\\/div\\\\u003E\\\\u003C\\\\\\\\/div\\\\u003E    \\\\u003C\\\\\\\\/div\\\\u003E\\\\\\\\n\\\\u003C\\\\\\\\/div\\\\u003E\\\\u003C\\\\\\\\/div\\\\u003E\\\\u003Ca class=\\\\\\\\\\\\\\\"profile-link d-ib rapid-noclick-resp fz-xs dn\\\\\\\\\\\\\\\" href=\\\\\\\\\\\\\\\"http:\\\\\\\\/\\\\\\\\/profile.yahoo.com\\\\\\\\/y\\\\\\\\/settings\\\\\\\\/interests\\\\\\\\/\\\\\\\\\\\\\\\"\\\\u003EEdit content preferences\\\\u003C\\\\\\\\/a\\\\u003E\\\\u003C\\\\\\\\/div\\\\u003E\\\\\\\"},\\\\\\\"res\\\\\\\":{},\\\\\\\"mods\\\\\\\":[{\\\\\\\"props\\\\\\\":{\\\\\\\"trusted\\\\\\\":true,\\\\\\\"id\\\\\\\":\\\\\\\"p_30345810_eab\\\\\\\",\\\\\\\"type\\\\\\\":\\\\\\\"fstream\\\\\\\",\\\\\\\"ns\\\\\\\":\\\\\\\"type_fstream\\\\\\\",\\\\\\\"contentId\\\\\\\":\\\\\\\"30345810\\\\\\\",\\\\\\\"tags\\\\\\\":[],\\\\\\\"title\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"icon\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"shortTitle\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"detailUrl\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"chromecolor\\\\\\\":\\\\\\\"blue\\\\\\\"},\\\\\\\"data\\\\\\\":{\\\\\\\"dropdownHover\\\\\\\":true,\\\\\\\"dynamicMax\\\\\\\":0,\\\\\\\"filterRestoreEnabled\\\\\\\":false,\\\\\\\"dropdownFilter\\\\\\\":false,\\\\\\\"tabFilter\\\\\\\":true,\\\\\\\"autoHideEnabled\\\\\\\":true,\\\\\\\"recentFiltersEnabled\\\\\\\":false,\\\\\\\"saveEnabled\\\\\\\":false,\\\\\\\"swipeFilterEnabled\\\\\\\":false,\\\\\\\"filterFontSize\\\\\\\":\\\\\\\"fz-s\\\\\\\"},\\\\\\\"strs\\\\\\\":{\\\\\\\"STR.FILTERS.FILTERBY\\\\\\\":\\\\\\\"Filter by\\\\\\\"},\\\\\\\"state\\\\\\\":{\\\\\\\"view\\\\\\\":\\\\\\\"default\\\\\\\",\\\\\\\"defer\\\\\\\":false,\\\\\\\"collapsed\\\\\\\":0},\\\\\\\"prefs\\\\\\\":{\\\\\\\"isc\\\\\\\":0,\\\\\\\"_mc\\\\\\\":0}}]}]}],\\\\\\\"res\\\\\\\":{\\\\\\\"css\\\\\\\":{\\\\\\\"helpers_css\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/ui\\\\\\\\/helpers_0.0.6.css\\\\\\\",\\\\\\\"typography_css\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/ui\\\\\\\\/typography_0.0.2.css\\\\\\\",\\\\\\\"theme_default_css\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/theme\\\\\\\\/default\\\\\\\\/common_0.0.29.css\\\\\\\",\\\\\\\"theme_default_desktop_css\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/theme\\\\\\\\/default\\\\\\\\/desktop_0.0.62.css\\\\\\\",\\\\\\\"tooltip_service_css\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/uiplugins\\\\\\\\/tooltip_service_1.0.12.css\\\\\\\",\\\\\\\"type_stream_css\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/stream\\\\\\\\/stream_0.0.271.css\\\\\\\",\\\\\\\"theme_gs_css\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/stream\\\\\\\\/theme_gs_0.0.45.css\\\\\\\",\\\\\\\"login_service_css\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/uiplugins\\\\\\\\/login_service_0.0.3.css\\\\\\\",\\\\\\\"rmx_ads_css\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/stream\\\\\\\\/rmx_ads_0.0.8.css\\\\\\\",\\\\\\\"type_fstream_desktop_css\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/fstream\\\\\\\\/fstream_desktop_0.0.21.css\\\\\\\",\\\\\\\"type_login_css\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/login\\\\\\\\/login_0.0.71.css\\\\\\\"},\\\\\\\"js\\\\\\\":{\\\\\\\"oop\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/yui\\\\\\\\/oop_3.8.1.js\\\\\\\",\\\\\\\"event-custom-base\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/yui\\\\\\\\/event-custom-base_3.8.1.js\\\\\\\",\\\\\\\"event-base\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/yui\\\\\\\\/event-base_3.8.1.js\\\\\\\",\\\\\\\"io-base\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/yui\\\\\\\\/io-base_3.8.1.js\\\\\\\",\\\\\\\"json-parse\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/yui\\\\\\\\/json-parse_3.8.1.js\\\\\\\",\\\\\\\"json-stringify\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/yui\\\\\\\\/json-stringify_3.8.1.js\\\\\\\",\\\\\\\"cookie\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/yui\\\\\\\\/cookie_3.8.1.js\\\\\\\",\\\\\\\"jsonp\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/yui\\\\\\\\/jsonp_3.8.1.js\\\\\\\",\\\\\\\"dom-core\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/yui\\\\\\\\/dom-core_3.8.1.js\\\\\\\",\\\\\\\"dom-base\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/yui\\\\\\\\/dom-base_3.8.1.js\\\\\\\",\\\\\\\"dom-style\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/yui\\\\\\\\/dom-style_3.8.1.js\\\\\\\",\\\\\\\"selector-native\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/yui\\\\\\\\/selector-native_3.8.1.js\\\\\\\",\\\\\\\"selector\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/yui\\\\\\\\/selector_3.8.1.js\\\\\\\",\\\\\\\"node-core\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/yui\\\\\\\\/node-core_3.8.1.js\\\\\\\",\\\\\\\"node-base\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/yui\\\\\\\\/node-base_3.8.1.js\\\\\\\",\\\\\\\"node-style\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/yui\\\\\\\\/node-style_3.8.1.js\\\\\\\",\\\\\\\"transition\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/yui\\\\\\\\/transition_3.8.2.js\\\\\\\",\\\\\\\"selector-css2\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/yui\\\\\\\\/selector-css2_3.8.1.js\\\\\\\",\\\\\\\"selector-css3\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/yui\\\\\\\\/selector-css3_3.8.1.js\\\\\\\",\\\\\\\"event-custom-complex\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/yui\\\\\\\\/event-custom-complex_3.8.1.js\\\\\\\",\\\\\\\"event-synthetic\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/yui\\\\\\\\/event-synthetic_3.8.1.js\\\\\\\",\\\\\\\"event-focus\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/yui\\\\\\\\/event-focus_3.8.1.js\\\\\\\",\\\\\\\"event-delegate\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/yui\\\\\\\\/event-delegate_3.8.1.js\\\\\\\",\\\\\\\"node-event-delegate\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/yui\\\\\\\\/node-event-delegate_3.8.1.js\\\\\\\",\\\\\\\"pluginhost-base\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/yui\\\\\\\\/pluginhost-base_3.8.1.js\\\\\\\",\\\\\\\"pluginhost-config\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/yui\\\\\\\\/pluginhost-config_3.8.1.js\\\\\\\",\\\\\\\"node-pluginhost\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/yui\\\\\\\\/node-pluginhost_3.8.1.js\\\\\\\",\\\\\\\"dom-screen\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/yui\\\\\\\\/dom-screen_3.8.1.js\\\\\\\",\\\\\\\"node-screen\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/yui\\\\\\\\/node-screen_3.8.1.js\\\\\\\",\\\\\\\"gallery-storage-lite\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/yui\\\\\\\\/gallery-storage-lite_3.8.1.js\\\\\\\",\\\\\\\"module_platform\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/uicontrib\\\\\\\\/dali\\\\\\\\/module_platform_1.1.14.js\\\\\\\",\\\\\\\"resourcemgr\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/uicontrib\\\\\\\\/dali\\\\\\\\/resourcemgr_1.1.14.js\\\\\\\",\\\\\\\"transport\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/uicontrib\\\\\\\\/dali\\\\\\\\/dali_transport_1.1.34.js\\\\\\\",\\\\\\\"metro_ext\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/uicontrib\\\\\\\\/dali\\\\\\\\/metro_dali_1.0.27.js\\\\\\\",\\\\\\\"module_api\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/uicontrib\\\\\\\\/dali\\\\\\\\/module_api_1.1.16.js\\\\\\\",\\\\\\\"yui_service\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/uicontrib\\\\\\\\/dali\\\\\\\\/yui_service_0.1.17.js\\\\\\\",\\\\\\\"metro_viewtype\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/uiplugins\\\\\\\\/metro_viewtype_0.1.24.js\\\\\\\",\\\\\\\"default_viewtype\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/uiplugins\\\\\\\\/default_viewtype_0.1.61.js\\\\\\\",\\\\\\\"edit_viewtype\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/uiplugins\\\\\\\\/edit_viewtype_0.1.40.js\\\\\\\",\\\\\\\"ylc\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/uicontrib\\\\\\\\/ylc_1.8.22.js\\\\\\\",\\\\\\\"instrumentation_service\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/uiplugins\\\\\\\\/instrumentation_service_0.1.83.js\\\\\\\",\\\\\\\"userinfo_service\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/uiplugins\\\\\\\\/userinfo_service_0.1.15.js\\\\\\\",\\\\\\\"statemgr_service\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/uiplugins\\\\\\\\/statemgr_service_0.1.20.js\\\\\\\",\\\\\\\"metrologger_service\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/uiplugins\\\\\\\\/metrologger_service_0.1.18.js\\\\\\\",\\\\\\\"tooltip_service\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/uiplugins\\\\\\\\/tooltip_service_0.1.56.js\\\\\\\",\\\\\\\"autohide_service\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/uiplugins\\\\\\\\/autohide_service_0.1.15.js\\\\\\\",\\\\\\\"badge\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro2\\\\\\\\/g\\\\\\\\/badge\\\\\\\\/badge_0.1.20.js\\\\\\\",\\\\\\\"type_stream\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/stream\\\\\\\\/stream_0.0.456.js\\\\\\\",\\\\\\\"storage_service\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/uiplugins\\\\\\\\/storage_service_0.0.1.js\\\\\\\",\\\\\\\"login_service\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/uiplugins\\\\\\\\/login_service_0.0.38.js\\\\\\\",\\\\\\\"interests_service\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/uiplugins\\\\\\\\/interests_service_0.1.1.js\\\\\\\",\\\\\\\"type_fstream\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/fstream\\\\\\\\/fstream_0.0.95.js\\\\\\\",\\\\\\\"type_login\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/login\\\\\\\\/login_0.0.32.js\\\\\\\"}}};\\\\u000a}()\\\\u000a);\\\\u000a\\\\u003C/script\\\\u003E\\\\u000a\\\\u000a\\\\u003Cscript type=\\\\\\\"text/javascript\\\\\\\"\\\\u003E\\\\u000a(function(){\\\\u000a    YUI.add(\\\\\\\"metro_config\\\\\\\", function(Y){\\\\u000a        // until dali defaults this\\\\u000a\\\\u000a        Y.mix(Y.dali.config.props, {\\\\u000a            libRoot: \\\\\\\"\\\\\\\",\\\\u000a            user : \\\\\\\"\\\\\\\",\\\\u000a            ultSpaceId : \\\\\\\"2023538075\\\\\\\",\\\\u000a            ultBeaconHost : \\\\\\\"\\\\\\\\/p.gif\\\\\\\",\\\\u000a            modChromeHtml : \\\\\\\"\\\\u003Cdiv id=\\\\\\\\\\\\\\\"error-{type_name}\\\\\\\\\\\\\\\" class=\\\\\\\\\\\\\\\"mod view_error\\\\\\\\\\\\\\\"\\\\u003E  \\\\u003Cdiv id=\\\\\\\\\\\\\\\"error-{type_name}-bd\\\\\\\\\\\\\\\" class=\\\\\\\\\\\\\\\"bd  _error\\\\\\\\\\\\\\\"\\\\u003E{html}    \\\\u003C\\\\\\\\/div\\\\u003E\\\\\\\\n\\\\u003C\\\\\\\\/div\\\\u003E\\\\\\\",\\\\u000a            modErrorHtml : \\\\\\\"\\\\u003Cdiv class=\\\\\\\\\\\\\\\"oops-msg\\\\\\\\\\\\\\\" role=\\\\\\\\\\\\\\\"alertdialog\\\\\\\\\\\\\\\"\\\\u003E\\\\\\\\n                \\\\u003Cspan class='icon' style='background-image:url({img});_filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(enabled=true, sizingMethod=crop src=\\\\\\\\\\\\\\\"{img}\\\\\\\\\\\\\\\"); _background-image:none;'\\\\u003E\\\\u003C\\\\\\\\/span\\\\u003E\\\\u003Cspan class='shadow'\\\\u003E\\\\u003C\\\\\\\\/span\\\\u003E\\\\\\\\n                \\\\u003Ch3 class=\\\\\\\\\\\\\\\"oops\\\\\\\\\\\\\\\"\\\\u003E\\\\\\\\\\\\\\\"{name}\\\\\\\\\\\\\\\" encountered a problem while trying to load\\\\u003C\\\\\\\\/h3\\\\u003E\\\\\\\\n                \\\\u003Cp class=\\\\\\\\\\\\\\\"oops\\\\\\\\\\\\\\\"\\\\u003E{message}\\\\u003C\\\\\\\\/p\\\\u003E\\\\\\\\n                                \\\\u003Cp class=\\\\\\\\\\\\\\\"oops oops-link\\\\\\\\\\\\\\\"\\\\u003EOr visit \\\\u003Ca href=\\\\\\\\\\\\\\\"{url}\\\\\\\\\\\\\\\"\\\\u003E{url}\\\\u003C\\\\\\\\/a\\\\u003E\\\\u003C\\\\\\\\/p\\\\u003E\\\\\\\\n            \\\\u003C\\\\\\\\/div\\\\u003E\\\\\\\",\\\\u000a            crumbErrorHtml : \\\\\\\"\\\\u003Cdiv class=\\\\\\\\\\\\\\\"oops-msg\\\\\\\\\\\\\\\" role=\\\\\\\\\\\\\\\"alertdialog\\\\\\\\\\\\\\\"\\\\u003E\\\\\\\\n                \\\\u003Cspan class=\\\\\\\\\\\\\\\"icon icon-error y-glbl-universal\\\\\\\\\\\\\\\"\\\\u003E\\\\u003C\\\\\\\\/span\\\\u003E\\\\\\\\n                \\\\u003Ch3 class=\\\\\\\\\\\\\\\"oops\\\\\\\\\\\\\\\"\\\\u003EThe module encountered a problem while trying to load\\\\u003C\\\\\\\\/h3\\\\u003E\\\\\\\\n                \\\\u003Cp class=\\\\\\\\\\\\\\\"oops\\\\\\\\\\\\\\\"\\\\u003E2048\\\\u003C\\\\\\\\/p\\\\u003E\\\\\\\\n                \\\\\\\\n            \\\\u003C\\\\\\\\/div\\\\u003E\\\\\\\",\\\\u000a            cookieErrorHtml : \\\\\\\"\\\\u003Cdiv class=\\\\\\\\\\\\\\\"oops-msg\\\\\\\\\\\\\\\" role=\\\\\\\\\\\\\\\"alertdialog\\\\\\\\\\\\\\\"\\\\u003E\\\\\\\\n                \\\\u003Cspan class=\\\\\\\\\\\\\\\"icon icon-error y-glbl-universal\\\\\\\\\\\\\\\"\\\\u003E\\\\u003C\\\\\\\\/span\\\\u003E\\\\\\\\n                \\\\u003Ch3 class=\\\\\\\\\\\\\\\"oops\\\\\\\\\\\\\\\"\\\\u003EThe module encountered a problem while trying to load\\\\u003C\\\\\\\\/h3\\\\u003E\\\\\\\\n                \\\\u003Cp class=\\\\\\\\\\\\\\\"oops\\\\\\\\\\\\\\\"\\\\u003E16384\\\\u003C\\\\\\\\/p\\\\u003E\\\\\\\\n                \\\\\\\\n            \\\\u003C\\\\\\\\/div\\\\u003E\\\\\\\",\\\\u000a            proxyTimeout : 15000,\\\\u000a            proxyUrl : '/hjs',\\\\u000a            intl : \\\\\\\"us\\\\\\\",\\\\u000a            \\\\\\\"ywa.rapid.enabled\\\\\\\": true\\\\u000a        });\\\\u000a    });\\\\u000a\\\\u000a    var i, len, url, match, modules,\\\\u000a        allScripts = YUI.presentation.lazyScriptList,\\\\u000a        comboRoot = 'http://l.yimg.com/zz/combo?',\\\\u000a        isCombo =  allScripts[0].indexOf(comboRoot) === 0,\\\\u000a        yuiMods = ['metro_config'],\\\\u000a        lazyScripts = [];\\\\u000a\\\\u000a    if (isCombo) {\\\\u000a        for (i = 0, len = allScripts.length; i \\\\u003C len; ++i) {\\\\u000a            url = allScripts[i].replace(comboRoot, '');\\\\u000a            allScripts = allScripts.concat(url.split('&'));\\\\u000a        }\\\\u000a        allScripts = allScripts.slice(len);\\\\u000a    }\\\\u000a\\\\u000a    for (i = 0, len = allScripts.length; i \\\\u003C len; ++i) {\\\\u000a        url = allScripts[i];\\\\u000a        match = url.match(/\\\\\\\\/yui\\\\\\\\/([^._]*)/);\\\\u000a        if (match && match.length \\\\u003E 1) {\\\\u000a            yuiMods.push(match[1]);\\\\u000a        } else {\\\\u000a            lazyScripts.push(url);\\\\u000a        }\\\\u000a    }\\\\u000a\\\\u000a    if (isCombo) {\\\\u000a        lazyScripts = [comboRoot + lazyScripts.join('&')];\\\\u000a    }\\\\u000a\\\\u000a    if (YMedia.ModulePlatform) {\\\\u000a        modules = YMedia.ModulePlatform.getModules();\\\\u000a        YMedia.ModulePlatform.stop(modules);\\\\u000a        YMedia.each(modules, YMedia.ModulePlatform.unregisterModule);\\\\u000a    }\\\\u000a    YMedia.use(yuiMods, function (Y) {\\\\u000a        Y.dali.config.debug = false;\\\\u000a        Y.Get.script(lazyScripts, { onSuccess: function(){\\\\u000a            Y.use(\\\\\\\"*\\\\\\\", function (Y) {\\\\u000a                Y.ModulePlatform.init(Y.dali.config, true);\\\\u000a            });\\\\u000a        }});\\\\u000a        var rapid = YMedia ? YMedia.rapid : null,\\\\u000a            id = 'p_30345786',\\\\u000a            container = Y.one('#' + id);\\\\u000a        if (rapid && container) {\\\\u000a            if (rapid.isModuleTracked(id)) {\\\\u000a                rapid.refreshModule(id);\\\\u000a            } else {\\\\u000a                rapid.addModules(id);\\\\u000a            }\\\\u000a        }\\\\u000a        if (container) {\\\\u000a            container.addClass('jsenabled');\\\\u000a        }\\\\u000a    });\\\\u000a\\\\u000a})();\\\\u000a\\\\u003C/script\\\\u003E\\\\u000a\\\\u000a--dali-response-split-51ddaa3c96973--\\\"\\u000a    });\\u000a});\"), (\"s13cc272004eef102647a8d8b2d53670fe60be710\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    (((JSBNG_Record.get)(YMedia, (\"use\")))[(\"use\")])(\"media-rmp\", ((function() {\n        var s13cc272004eef102647a8d8b2d53670fe60be710_0_instance;\n        ((s13cc272004eef102647a8d8b2d53670fe60be710_0_instance) = ((JSBNG_Record.eventInstance)((\"s13cc272004eef102647a8d8b2d53670fe60be710_0\"))));\n        return ((JSBNG_Record.markFunction)((function(Y) {\n            if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                return ((JSBNG_Record.eventCall)((arguments.callee), (\"s13cc272004eef102647a8d8b2d53670fe60be710_0\"), (s13cc272004eef102647a8d8b2d53670fe60be710_0_instance), (this), (arguments)))\n            };\n            (null);\n            (((JSBNG_Record.get)((((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"RMP\")))[(\"RMP\")]), (\"load\")))[(\"load\")])({\n                srcNode: \"#p_30345786_container\",\n                continueOnError: true,\n                response: \"--dali-response-split-51ddaa3c96973Content-Type: text/plain; charset=utf-8\\u000aRMP-Embed-Location: top\\u000a\\u000a\\u000a\\u003Clink rel=\\\"stylesheet\\\" type=\\\"text/css\\\" href=\\\"http://l.yimg.com/zz/combo?nn/lib/metro/g/ui/helpers_0.0.6.css&nn/lib/metro/g/ui/typography_0.0.2.css&nn/lib/metro/g/theme/default/common_0.0.29.css&nn/lib/metro/g/theme/default/desktop_0.0.62.css&nn/lib/metro/g/uiplugins/tooltip_service_1.0.12.css\\\" /\\u003E\\u000a\\u000a\\u003Clink rel=\\\"stylesheet\\\" type=\\\"text/css\\\" href=\\\"http://l.yimg.com/zz/combo?nn/lib/metro/g/stream/stream_0.0.271.css&nn/lib/metro/g/stream/theme_gs_0.0.45.css&nn/lib/metro/g/uiplugins/login_service_0.0.3.css&nn/lib/metro/g/stream/rmx_ads_0.0.8.css&nn/lib/metro/g/fstream/fstream_desktop_0.0.21.css&nn/lib/metro/g/login/login_0.0.71.css\\\" /\\u003E\\u000a\\u000a--dali-response-split-51ddaa3c96973Content-Type: text/html; charset=utf-8\\u000aRMP-Embed-Location: bottom\\u000a\\u000a\\u003Cdiv id=\\\"p_30345786\\\" class=\\\"rapidnofollow rapid-container dev-desktop\\\" data-ylk=\\\"sec:td-strm\\\"\\u003E\\u000a\\u003Cdiv id=\\\"default-u_30345786\\\" class=\\\"mod view_default\\\"\\u003E  \\u003Cdiv id=\\\"default-u_30345786-bd\\\" class=\\\"bd type_stream type_stream_default\\\"\\u003E\\u003Cdiv id=\\\"default-p_30345810_eab\\\" class=\\\"mod view_default\\\"\\u003E  \\u003Cdiv id=\\\"default-p_30345810_eab-bd\\\" class=\\\"bd type_fstream type_fstream_default\\\"\\u003E\\u003Cstyle\\u003E .type_fstream .dropdown-label-text, .type_fstream .tab-list .filter-item .filter-name, .type_fstream .filter-bar-section { background-color:#0e2b5c !important;border:solid 1px #0e2b5c !important;color:#fff !important } .type_fstream .tab-list .filter-item { opacity: 0.7; -ms-filter:\\\"progid:DXImageTransform.Microsoft.Alpha(Opacity=70)\\\"; filter: alpha(opacity=70); }.type_fstream .tab-list .filter-selected { opacity: 1; -ms-filter:\\\"progid:DXImageTransform.Microsoft.Alpha(Opacity=100)\\\"; filter: alpha(opacity=100); }\\u003C/style\\u003E\\u003Cdiv class=\\\"filter-bar-section\\\"\\u003E\\u003Cul class=\\\"tab-list d-ib fz-xs pos-r\\\"\\u003E\\u003Cli class=\\\"filter-item d-ib\\\" data-filter=\\\"\\\"\\u003E\\u000a    \\u003Ca href=\\\"#\\\" data-ylk=\\\"sec:fltr-strm;slk:YPROP:TOPSTORIES;cpos:1;pos:0;ft:1\\\"  data-action-outcome=\\\"filter\\\" class=\\\"filter-name rapidnofollow fz-s\\\" role=\\\"button\\\"\\u003EAll News\\u003C/a\\u003E\\u000a\\u003C/li\\u003E\\u003Cli class=\\\"filter-item d-ib\\\" data-filter=\\\"LISTID:c435b248-2107-445e-97ea-89e2ec5df60c\\\"\\u003E\\u000a    \\u003Ca href=\\\"#\\\" data-ylk=\\\"sec:fltr-strm;slk:LISTID:c435b248-2107-445e-97ea-89e2ec5df60c;cpos:2;pos:0;ft:1\\\"  data-action-outcome=\\\"filter\\\" class=\\\"filter-name rapidnofollow fz-s\\\" role=\\\"button\\\"\\u003EY! News Originals\\u003C/a\\u003E\\u000a\\u003C/li\\u003E\\u003Cli class=\\\"filter-item d-ib\\\" data-filter=\\\"YPROV:ABCNEWS\\\"\\u003E\\u000a    \\u003Ca href=\\\"#\\\" data-ylk=\\\"sec:fltr-strm;slk:YPROV:ABCNEWS;cpos:3;pos:0;ft:1\\\"  data-action-outcome=\\\"filter\\\" class=\\\"filter-name rapidnofollow fz-s\\\" role=\\\"button\\\"\\u003EABC News\\u003C/a\\u003E\\u000a\\u003C/li\\u003E\\u003Cli class=\\\"filter-item d-ib\\\" data-filter=\\\"YPROV:ap.org\\\"\\u003E\\u000a    \\u003Ca href=\\\"#\\\" data-ylk=\\\"sec:fltr-strm;slk:YPROV:ap.org;cpos:4;pos:0;ft:1\\\"  data-action-outcome=\\\"filter\\\" class=\\\"filter-name rapidnofollow fz-s\\\" role=\\\"button\\\"\\u003EAP\\u003C/a\\u003E\\u000a\\u003C/li\\u003E\\u003Cli class=\\\"filter-item d-ib\\\" data-filter=\\\"YPROV:reuters.com\\\"\\u003E\\u000a    \\u003Ca href=\\\"#\\\" data-ylk=\\\"sec:fltr-strm;slk:YPROV:reuters.com;cpos:5;pos:0;ft:1\\\"  data-action-outcome=\\\"filter\\\" class=\\\"filter-name rapidnofollow fz-s\\\" role=\\\"button\\\"\\u003EReuters\\u003C/a\\u003E\\u000a\\u003C/li\\u003E\\u003C/ul\\u003E\\u003C/div\\u003E    \\u003C/div\\u003E\\u000a\\u003C/div\\u003E\\u003Cul\\u003E\\u003Cli class=\\\"content has-image voh-parent cf\\\" data-uuid=\\\"a2b156e2-bdc5-3dab-bf3c-241d681ef099\\\" data-ylk=\\\"sec:td-strm;cat:default;bpos:1;cpos:1;pkgt:4;ccode:news;g:a2b156e2-bdc5-3dab-bf3c-241d681ef099;ed:0;\\\" data-url=\\\"http%3A%2F%2Fnews.yahoo.com%2Fexpert-zimmerman-worse-shape-martin-144959889.html\\\" data-wikiids=\\\"YCT:001000667|YCT:001000780|WIKIID:Shooting_of_Trayvon_Martin\\\" data-reason=\\\"TRENDING\\\"\\u003E\\u003Cdiv class=\\\"wrapper cf\\\"\\u003E\\u003Ca class=\\\"img ov-h thumb-left  \\\" href=\\\"/expert-zimmerman-worse-shape-martin-144959889.html\\\" data-action-outcome=\\\"navigate\\\" data-ylk=\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:1;g:a2b156e2-bdc5-3dab-bf3c-241d681ef099;tar:news.yahoo.com;ltxt:Expert:Z;ct:1;pkgt:4;r:4100002718;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\" tabindex=\\\"-1\\\"\\u003E\\u003Cimg src=\\\"http://l.yimg.com/os/mit/media/m/base/images/transparent-95031.png\\\" style=\\\"margin-left:-15px;background-image:url('http://l1.yimg.com/ts/api/res/1.2/XITng7YWKM1CwU3GfV_RdA--/YXBwaWQ9eWhvbWVydW47cT04NTtzbT0xO3c9MjUwO2g9MTg1/http://media.zenfs.com/en_us/News/ap_webfeeds/d475fdac10c72e17370f6a706700275c.jpg');\\\" width=\\\"111\\\" height=\\\"82\\\" alt=\\\"\\\" title=\\\"\\\" class=\\\"lzbg\\\"\\u003E\\u003C/a\\u003E\\u003Cdiv class=\\\"body\\\"\\u003E\\u003Cdiv class=\\\"body-wrap\\\"\\u003E\\u003Ch3 class=\\\"fw-b fz-s lh-115\\\"\\u003E\\u003Ca class=\\\"\\\" href=\\\"/expert-zimmerman-worse-shape-martin-144959889.html\\\" data-action-outcome=\\\"navigate\\\" data-ylk=\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:1;g:a2b156e2-bdc5-3dab-bf3c-241d681ef099;tar:news.yahoo.com;ltxt:Expert:Z;ct:1;pkgt:4;r:4100002718;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\"\\u003EExpert: Zimmerman was in worse shape than Martin\\u003C/a\\u003E\\u003C/h3\\u003E\\u003Cp class=\\\"summary mt-xxs\\\"\\u003ESANFORD, Fla. (AP) \\u2014 A Florida judge ruled Wednesday that Trayvon Martin&#39;s cellphone text messages about fighting and a defense animation depicting the struggle between Martin and George Zimmerman won&#39;t be introduced as evidence at Zimmerman&#39;s trial. Defense attorneys had wanted to use those pieces\\u2026\\u003C/p\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"attribution fz-xxs\\\"\\u003E\\u003Cspan class=\\\"source\\\"\\u003EAssociated Press\\u003C/span\\u003E\\u003Cul class=\\\"interest-list d-ib voh\\\"\\u003E\\u003Cli class=\\\"interest-wrap d-ib\\\"\\u003E\\u003Ca href=\\\"http://news.yahoo.com/society-and-culture/\\\" class=\\\"interest-filter rapidnofollow\\\" data-filter=\\\"YCT:001000780\\\" data-ylk=\\\"slk:Society;sec:td-strm;cpos:1;itc:0;g:a2b156e2-bdc5-3dab-bf3c-241d681ef099;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\" data-action-outcome=\\\"navigate\\\"\\u003ESociety\\u003C/a\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"interest-wrap d-ib\\\"\\u003E\\u003Ca href=\\\"http://www.yahoo.com/topic/shooting-of-trayvon-martin/\\\" class=\\\"interest-filter rapidnofollow\\\" data-filter=\\\"WIKIID:Shooting_of_Trayvon_Martin\\\" data-ylk=\\\"slk:Shooting of Trayvon Martin;sec:td-strm;cpos:2;itc:0;g:a2b156e2-bdc5-3dab-bf3c-241d681ef099;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\" data-action-outcome=\\\"navigate\\\"\\u003EShooting of Trayvon Martin\\u003C/a\\u003E\\u003C/li\\u003E\\u003C/ul\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"side-buttons\\\"\\u003E\\u003Cbutton class=\\\"img-sprite close side-button voh rapid-noclick-resp\\\" data-b=\\\"\\\" title=\\\"Remove\\\"\\u003ERemove\\u003C/button\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"content voh-parent cf\\\" data-uuid=\\\"359b4757-f472-3d49-a211-389223ffe98a\\\" data-ylk=\\\"sec:td-strm;cat:default;bpos:1;cpos:2;pkgt:3;ccode:news;g:359b4757-f472-3d49-a211-389223ffe98a;ed:0;\\\" data-url=\\\"http%3A%2F%2Fnews.yahoo.com%2Fgop-remember-data-show-immigrants-enforce-not-threaten-171614860.html\\\" data-wikiids=\\\"YCT:001000661|YCT:001000700|WIKIID:Culture_of_the_United_States\\\" data-reason=\\\"TRENDING\\\"\\u003E\\u003Cdiv class=\\\"wrapper cf\\\"\\u003E\\u003Cdiv class=\\\"body\\\"\\u003E\\u003Cdiv class=\\\"body-wrap\\\"\\u003E\\u003Ch3 class=\\\"fw-b fz-s lh-115\\\"\\u003E\\u003Ca class=\\\"\\\" href=\\\"/gop-remember-data-show-immigrants-enforce-not-threaten-171614860.html\\\" data-action-outcome=\\\"navigate\\\" data-ylk=\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:2;g:359b4757-f472-3d49-a211-389223ffe98a;tar:news.yahoo.com;ltxt:GOPshoul;ct:1;pkgt:3;r:4100001700;slk:title;itc:0;prov:ChristianScience;sort:1;test:900;intl:us;cat:default;ccode:news;\\\"\\u003EGOP should remember: Data show immigrants enforce, not threaten, US values\\u003C/a\\u003E\\u003C/h3\\u003E\\u003Cp class=\\\"summary mt-xxs\\\"\\u003EA comprehensive immigration reform bill has passed the Senate, but it faces dubious prospects in the House, where it probably won\\u2019t garner enough of the Republican support needed to bring it to a floor vote. One Republican sticking point is that the prospective law doesn\\u2019t go far enough to ensure\\u2026\\u003C/p\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"attribution fz-xxs\\\"\\u003E\\u003Cspan class=\\\"source\\\"\\u003EChristian Science Monitor\\u003C/span\\u003E\\u003Cul class=\\\"interest-list d-ib voh\\\"\\u003E\\u003Cli class=\\\"interest-wrap d-ib\\\"\\u003E\\u003Ca href=\\\"http://news.yahoo.com/politics-and-government/\\\" class=\\\"interest-filter rapidnofollow\\\" data-filter=\\\"YCT:001000661\\\" data-ylk=\\\"slk:Politics;sec:td-strm;cpos:1;itc:0;g:359b4757-f472-3d49-a211-389223ffe98a;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\" data-action-outcome=\\\"navigate\\\"\\u003EPolitics\\u003C/a\\u003E\\u003C/li\\u003E\\u003C/ul\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"side-buttons\\\"\\u003E\\u003Cbutton class=\\\"img-sprite close side-button voh rapid-noclick-resp\\\" data-b=\\\"\\\" title=\\\"Remove\\\"\\u003ERemove\\u003C/button\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"content rmx-ad has-image voh-parent cf\\\" data-uuid=\\\"21671635\\\" data-ylk=\\\"sec:td-strm;cat:default;bpos:1;cpos:3;pkgt:4;ccode:news;g:21671635;ed:0;\\\" data-url=\\\"http%3A%2F%2Fad.yieldmanager.com%2Fclk%3F3%2CeJytjd8KgjAYxV.Ii03d3BhdTKdi6SxahZfDP0NNghCknr40qRfoB-fjHL4DBzoM4NrTutIexLTGoGTQaUpag6aqkAUYY7ZHMfIQocTiM3syHiah7v3NX7I4SjXxD-Yt3wRrb76hcHZar--z7Q.8LwR0y5PVJ8uuEYSj5mkeivjfWly4mS1bKUI3vZxQHhdjpqJr1sJWdiVKVTjJjoNiiIZcyF7-BjaWBV6lHk77%2Chttp%253A%252F%252Fad.doubleclick.net%252Fclk%253B274020025%253B100435305%253Be%253Fhttp%253A%252F%252Fspectrum2.pch.com%252FPath%252FJulyTV2013SitespectControl%252FStart.aspx%253Ftid%253D7e9b938d-f8ce-489a-bdef-81f419556b96%2526utm_source%253DYahoo%2526utm_medium%253Dcpc%2526utm_campaign%253DYahoo_Stream_Ad15\\\" data-wikiids=\\\"\\\" data-rmx-beacon=\\\"http://ad.yieldmanager.com/csc?ve=2&1hrw95l2wp0XrFYnLhJqzLriWXhdDwpnt4Kf8wPuQSdLFrDaBJiYaKu9f1YrQOidHRIOdpedQRTCvjgtn02eC7Z.kUCxocI7GY.iTTTyz1z9dQiud2A_gKVQ6OIxOTIR5cFUThlHzJQWkyL5X1ciNIdkmpatnBHwKLAKPqs6I_4yWYRJTXbVPyik7I1NKh.tyFCWf1UkfkF2Sgq.gXbfEHQYDwxYJbqQyzukOp0e8wvfBzwRHGSEex.SIRDn1Qvd_bYkVW3v52haZ5uXOsSaZxkj7hZd4sQq61ZJQb7DH8gwceeen.qgGa_LfI8XVDHpJTbx4rQ6ElpR9lwZUJjGbvvYdIiS06cOu.oZZzRJIShdNUTlN4USP27Qs8zP7eUC6e3.yYlPsePXNnYWBzrfkA.qZBIK6Wmj8AJaB5Q__6zTcGJs6mPBDjJLQ7VDfm52vpQADTT3RIcQy40cepLkw2TeLCCI3vHJgpDQPvDYw9BOF9_pamfg7Yp0On6SlPTv28c.iqT6.oMcn9nGoiTHgT336BzgkFd.9XUZVVEvXNhIjGTa0iWtdrqWkLHs8Qol7MNcNxfD.Or_gkholvmdAG6lb6__Al.Py2gFkLbWJ.Xoet5wOI7Lo0KaeLXCUpTNEmklwkYhxsNLaRk8Jb0R7zZNita2HETQb92McUTc15px6SBP983kJetQ8RMGEa1xvgIF_FmQoXR2sSCblmyfouYyDMCAZl3pj4_Ij4JD3zgwGp4rj3SCBMx_FWfD9Wr7wl3sCrjXTxu0n079i2LlbGeeq3tdEPjpZMypM.GozXdvMRIkndXbIihqK9iPM.MJlw--&ap=3\\\"\\u003E\\u003Cdiv class=\\\"wrapper cf\\\"\\u003E\\u003Ca class=\\\"img ov-h thumb-left  \\\" href=\\\"http://ad.yieldmanager.com/clk?3,eJytjd8KgjAYxV.Ii03d3BhdTKdi6SxahZfDP0NNghCknr40qRfoB-fjHL4DBzoM4NrTutIexLTGoGTQaUpag6aqkAUYY7ZHMfIQocTiM3syHiah7v3NX7I4SjXxD-Yt3wRrb76hcHZar--z7Q.8LwR0y5PVJ8uuEYSj5mkeivjfWly4mS1bKUI3vZxQHhdjpqJr1sJWdiVKVTjJjoNiiIZcyF7-BjaWBV6lHk77,http%3A%2F%2Fad.doubleclick.net%2Fclk%3B274020025%3B100435305%3Be%3Fhttp%3A%2F%2Fspectrum2.pch.com%2FPath%2FJulyTV2013SitespectControl%2FStart.aspx%3Ftid%3D7e9b938d-f8ce-489a-bdef-81f419556b96%26utm_source%3DYahoo%26utm_medium%3Dcpc%26utm_campaign%3DYahoo_Stream_Ad15\\\" data-action-outcome=\\\"navigate\\\" data-ylk=\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:3;g:21671635;tar:ad.yieldmanager.com;ltxt:$5,000aW;ct:1;pkgt:4;ad:1;slk:title;itc:0;sort:1;test:900;intl:us;cat:default;ccode:news;\\\" target=\\\"_blank\\\" tabindex=\\\"-1\\\"\\u003E\\u003Cimg src=\\\"http://l.yimg.com/os/mit/media/m/base/images/transparent-95031.png\\\" style=\\\"background-image:url('http://l5.yimg.com/av/moneyball/ads/0-1372704499-6168.jpg');\\\" width=\\\"82\\\" height=\\\"82\\\" alt=\\\"\\\" title=\\\"\\\" class=\\\"lzbg\\\"\\u003E\\u003C/a\\u003E\\u003Cdiv class=\\\"body\\\"\\u003E\\u003Cdiv class=\\\"body-wrap\\\"\\u003E\\u003Ch3 class=\\\"fw-b fz-s lh-115\\\"\\u003E\\u003Ca class=\\\"\\\" href=\\\"http://ad.yieldmanager.com/clk?3,eJytjd8KgjAYxV.Ii03d3BhdTKdi6SxahZfDP0NNghCknr40qRfoB-fjHL4DBzoM4NrTutIexLTGoGTQaUpag6aqkAUYY7ZHMfIQocTiM3syHiah7v3NX7I4SjXxD-Yt3wRrb76hcHZar--z7Q.8LwR0y5PVJ8uuEYSj5mkeivjfWly4mS1bKUI3vZxQHhdjpqJr1sJWdiVKVTjJjoNiiIZcyF7-BjaWBV6lHk77,http%3A%2F%2Fad.doubleclick.net%2Fclk%3B274020025%3B100435305%3Be%3Fhttp%3A%2F%2Fspectrum2.pch.com%2FPath%2FJulyTV2013SitespectControl%2FStart.aspx%3Ftid%3D7e9b938d-f8ce-489a-bdef-81f419556b96%26utm_source%3DYahoo%26utm_medium%3Dcpc%26utm_campaign%3DYahoo_Stream_Ad15\\\" data-action-outcome=\\\"navigate\\\" data-ylk=\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:3;g:21671635;tar:ad.yieldmanager.com;ltxt:$5,000aW;ct:1;pkgt:4;ad:1;slk:title;itc:0;sort:1;test:900;intl:us;cat:default;ccode:news;\\\" target=\\\"_blank\\\"\\u003E$5,000 a Week &quot;Forever&quot; Contest \\u003C/a\\u003E\\u003C/h3\\u003E\\u003Cp class=\\\"summary mt-xxs\\\"\\u003EPass Your Prize To Your Loved Ones. Don't Wait, Enter Now at PCH.com! \\u003C/p\\u003E\\u003Ca class=\\\"adlink fz-xxs rapid-noclick-resp\\\" href=\\\"http://info.yahoo.com/privacy/us/yahoo/adinfo_geo.html\\\" target=\\\"_blank\\\"\\u003EAdChoices\\u003Ci class=\\\"img-sprite\\\"\\u003E\\u003C/i\\u003E\\u003C/a\\u003E\\u000a\\u003Ca class=\\\"fz-xxs adv rapid-noclick-resp\\\" href=\\\"http://ad.yieldmanager.com/clk?3,eJytjd8KgjAYxV.Ii03d3BhdTKdi6SxahZfDP0NNghCknr40qRfoB-fjHL4DBzoM4NrTutIexLTGoGTQaUpag6aqkAUYY7ZHMfIQocTiM3syHiah7v3NX7I4SjXxD-Yt3wRrb76hcHZar--z7Q.8LwR0y5PVJ8uuEYSj5mkeivjfWly4mS1bKUI3vZxQHhdjpqJr1sJWdiVKVTjJjoNiiIZcyF7-BjaWBV6lHk77,http%3A%2F%2Fad.doubleclick.net%2Fclk%3B274020025%3B100435305%3Be%3Fhttp%3A%2F%2Fspectrum2.pch.com%2FPath%2FJulyTV2013SitespectControl%2FStart.aspx%3Ftid%3D7e9b938d-f8ce-489a-bdef-81f419556b96%26utm_source%3DYahoo%26utm_medium%3Dcpc%26utm_campaign%3DYahoo_Stream_Ad15\\\" target=\\\"_blank\\\"\\u003E\\u003Cspan class=\\\"source\\\"\\u003EPCH.com\\u003C/span\\u003E\\u003C/a\\u003E\\u003Ca href=\\\"http://help.yahoo.com/kb/index?page=content&y=PROD_FRONT&locale=en_US&id=SLN14553\\\" class=\\\"fz-xxs sp rapid-noclick-resp\\\" target=\\\"_blank\\\"\\u003ESponsored\\u003C/a\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"attribution fz-xxs\\\"\\u003E\\u003Cul class=\\\"interest-list d-ib voh\\\"\\u003E\\u003C/ul\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"content voh-parent cf\\\" data-uuid=\\\"950129f1-e974-33ae-b739-227b6ca2e187\\\" data-ylk=\\\"sec:td-strm;cat:default;bpos:1;cpos:4;pkgt:3;ccode:news;g:950129f1-e974-33ae-b739-227b6ca2e187;ed:0;\\\" data-url=\\\"http%3A%2F%2Fnews.yahoo.com%2Fblogs%2Ftrending-now%2Ftoddler-buys-car-ebay-using-father-smartphone-172026670.html\\\" data-wikiids=\\\"\\\" data-reason=\\\"TRENDING\\\"\\u003E\\u003Cdiv class=\\\"wrapper cf\\\"\\u003E\\u003Cdiv class=\\\"body\\\"\\u003E\\u003Cdiv class=\\\"body-wrap\\\"\\u003E\\u003Ch3 class=\\\"fw-b fz-s lh-115\\\"\\u003E\\u003Ca class=\\\"\\\" href=\\\"/blogs/trending-now/toddler-buys-car-ebay-using-father-smartphone-172026670.html\\\" data-action-outcome=\\\"navigate\\\" data-ylk=\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:4;g:950129f1-e974-33ae-b739-227b6ca2e187;tar:news.yahoo.com;ltxt:ToddlerB;ct:2;pkgt:3;r:4100001324;slk:title;itc:0;prov:TrendingNow;sort:1;test:900;intl:us;cat:default;ccode:news;\\\"\\u003EToddler Buys Car on eBay Using Father\\u2019s Smartphone\\u003C/a\\u003E\\u003C/h3\\u003E\\u003Cp class=\\\"summary mt-xxs\\\"\\u003ELast month Sorella Stoute from Portland, Oregon, purchased a 1962 Austin-Healey Sprite on eBay. Now, this might not sound like much of a story, until you learn that Sorella is only 14 months old. Here&#39;s what happened. The tiny online shopper was playing with her father Paul Stoute&#39;s smartphone when\\u2026\\u003C/p\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"attribution fz-xxs\\\"\\u003E\\u003Cspan class=\\\"source\\\"\\u003ETrending Now\\u003C/span\\u003E\\u003Cul class=\\\"interest-list d-ib voh\\\"\\u003E\\u003C/ul\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"side-buttons\\\"\\u003E\\u003Cbutton class=\\\"img-sprite close side-button voh rapid-noclick-resp\\\" data-b=\\\"\\\" title=\\\"Remove\\\"\\u003ERemove\\u003C/button\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"content voh-parent cf\\\" data-uuid=\\\"a5d908b7-4f0c-3334-81a0-3d378bbeb520\\\" data-ylk=\\\"sec:td-strm;cat:default;bpos:1;cpos:5;pkgt:3;ccode:news;g:a5d908b7-4f0c-3334-81a0-3d378bbeb520;ed:0;\\\" data-url=\\\"http%3A%2F%2Fnews.yahoo.com%2Fntsb-findings-sf-plane-crash-133726993.html\\\" data-wikiids=\\\"YCT:001000346|YCT:001000992\\\" data-reason=\\\"TRENDING\\\"\\u003E\\u003Cdiv class=\\\"wrapper cf\\\"\\u003E\\u003Cdiv class=\\\"body\\\"\\u003E\\u003Cdiv class=\\\"body-wrap\\\"\\u003E\\u003Ch3 class=\\\"fw-b fz-s lh-115\\\"\\u003E\\u003Ca class=\\\"\\\" href=\\\"/ntsb-findings-sf-plane-crash-133726993.html\\\" data-action-outcome=\\\"navigate\\\" data-ylk=\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:5;g:a5d908b7-4f0c-3334-81a0-3d378bbeb520;tar:news.yahoo.com;ltxt:NTSBfind;ct:1;pkgt:3;r:4100001409;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\"\\u003ENTSB findings on SF plane crash at a glance\\u003C/a\\u003E\\u003C/h3\\u003E\\u003Cp class=\\\"summary mt-xxs\\\"\\u003EAfter departing from Shanghai and stopping in Seoul, Asiana Flight 214 makes its final approach into San Francisco International Airport following a 10-hour flight across the Pacific Ocean. A preliminary ...\\u003C/p\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"attribution fz-xxs\\\"\\u003E\\u003Cspan class=\\\"source\\\"\\u003EAssociated Press\\u003C/span\\u003E\\u003Cul class=\\\"interest-list d-ib voh\\\"\\u003E\\u003Cli class=\\\"interest-wrap d-ib\\\"\\u003E\\u003Ca href=\\\"http://news.yahoo.com/personal-investing-ideas-and-strategies/\\\" class=\\\"interest-filter rapidnofollow\\\" data-filter=\\\"YCT:001000346\\\" data-ylk=\\\"slk:Personal Investing Ideas & Strategies;sec:td-strm;cpos:1;itc:0;g:a5d908b7-4f0c-3334-81a0-3d378bbeb520;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\" data-action-outcome=\\\"navigate\\\"\\u003EPersonal Investing Ideas & Strategies\\u003C/a\\u003E\\u003C/li\\u003E\\u003C/ul\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"side-buttons\\\"\\u003E\\u003Cbutton class=\\\"img-sprite close side-button voh rapid-noclick-resp\\\" data-b=\\\"\\\" title=\\\"Remove\\\"\\u003ERemove\\u003C/button\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"content voh-parent cf\\\" data-uuid=\\\"fe94cddd-d36b-3ce5-9246-733c1229ba93\\\" data-ylk=\\\"sec:td-strm;cat:default;bpos:1;cpos:6;pkgt:3;ccode:news;g:fe94cddd-d36b-3ce5-9246-733c1229ba93;ed:0;\\\" data-url=\\\"http%3A%2F%2Fgma.yahoo.com%2Fblogs%2Fabc-blogs%2Froyal-baby-american-british-birthing-practices-differ-115918234.html\\\" data-wikiids=\\\"YCT:001000395|YCT:001000495\\\" data-reason=\\\"TRENDING\\\"\\u003E\\u003Cdiv class=\\\"wrapper cf\\\"\\u003E\\u003Cdiv class=\\\"body\\\"\\u003E\\u003Cdiv class=\\\"body-wrap\\\"\\u003E\\u003Ch3 class=\\\"fw-b fz-s lh-115\\\"\\u003E\\u003Ca class=\\\"\\\" href=\\\"http://gma.yahoo.com/blogs/abc-blogs/royal-baby-american-british-birthing-practices-differ-115918234.html\\\" data-action-outcome=\\\"navigate\\\" data-ylk=\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:6;g:fe94cddd-d36b-3ce5-9246-733c1229ba93;tar:gma.yahoo.com;ltxt:HowKate&;ct:2;pkgt:3;r:4100001177;slk:title;itc:0;prov:ABCNews;sort:1;test:900;intl:us;cat:default;ccode:news;\\\"\\u003EHow Kate&#39;s Delivery Will Differ From U.S. Experience\\u003C/a\\u003E\\u003C/h3\\u003E\\u003Cp class=\\\"summary mt-xxs\\\"\\u003EThe future British monarch is due to be born any day now. Kate Middleton will deliver her child at Mary\\u2019s Hospital in London, in the same wing where Princess Diana gave birth to her own children. \\u201cIt\\u2019s a beautiful unit,\\u201d Regina Curran, a British midwife,...\\u003C/p\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"attribution fz-xxs\\\"\\u003E\\u003Cspan class=\\\"source\\\"\\u003EABC News\\u003C/span\\u003E\\u003Cul class=\\\"interest-list d-ib voh\\\"\\u003E\\u003Cli class=\\\"interest-wrap d-ib\\\"\\u003E\\u003Ca href=\\\"http://news.yahoo.com/health/\\\" class=\\\"interest-filter rapidnofollow\\\" data-filter=\\\"YCT:001000395\\\" data-ylk=\\\"slk:Health;sec:td-strm;cpos:1;itc:0;g:fe94cddd-d36b-3ce5-9246-733c1229ba93;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\" data-action-outcome=\\\"navigate\\\"\\u003EHealth\\u003C/a\\u003E\\u003C/li\\u003E\\u003C/ul\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"side-buttons\\\"\\u003E\\u003Cbutton class=\\\"img-sprite close side-button voh rapid-noclick-resp\\\" data-b=\\\"\\\" title=\\\"Remove\\\"\\u003ERemove\\u003C/button\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"content voh-parent cf\\\" data-uuid=\\\"8714ae80-beb0-39b6-9ee1-bd13ffb3f5c5\\\" data-ylk=\\\"sec:td-strm;cat:default;bpos:1;cpos:7;pkgt:3;ccode:news;g:8714ae80-beb0-39b6-9ee1-bd13ffb3f5c5;ed:0;\\\" data-url=\\\"http%3A%2F%2Fgma.yahoo.com%2Fblogs%2Fabc-blogs%2Fprince-william-play-polo-while-nine-months-pregnant-150649675.html\\\" data-wikiids=\\\"YCT:001000069|YCT:001000070|WIKIID:Prince_Harry_of_Wales|WIKIID:Kensington_Palace\\\" data-reason=\\\"TRENDING\\\"\\u003E\\u003Cdiv class=\\\"wrapper cf\\\"\\u003E\\u003Cdiv class=\\\"body\\\"\\u003E\\u003Cdiv class=\\\"body-wrap\\\"\\u003E\\u003Ch3 class=\\\"fw-b fz-s lh-115\\\"\\u003E\\u003Ca class=\\\"\\\" href=\\\"http://gma.yahoo.com/blogs/abc-blogs/prince-william-play-polo-while-nine-months-pregnant-150649675.html\\\" data-action-outcome=\\\"navigate\\\" data-ylk=\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:7;g:8714ae80-beb0-39b6-9ee1-bd13ffb3f5c5;tar:gma.yahoo.com;ltxt:PrinceWi;ct:2;pkgt:3;r:4100000846;slk:title;itc:0;prov:ABCNews;sort:1;test:900;intl:us;cat:default;ccode:news;\\\"\\u003EPrince William to Play Polo While Nine-Months-Pregnant Kate Waits\\u003C/a\\u003E\\u003C/h3\\u003E\\u003Cp class=\\\"summary mt-xxs\\\"\\u003EPrince William has plans this weekend, but they don\\u2019t include a hospital. While his nine-months-pregnant wife, Kate, stays back home at the couple\\u2019s Kensington Palace home, Prince William will go ahead with plans to play in a charity polo match Sunday in Glouchestershire, nearly 100...\\u003C/p\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"attribution fz-xxs\\\"\\u003E\\u003Cspan class=\\\"source\\\"\\u003EABC News\\u003C/span\\u003E\\u003Cul class=\\\"interest-list d-ib voh\\\"\\u003E\\u003Cli class=\\\"interest-wrap d-ib\\\"\\u003E\\u003Ca href=\\\"http://news.yahoo.com/celebrities/\\\" class=\\\"interest-filter rapidnofollow\\\" data-filter=\\\"YCT:001000069\\\" data-ylk=\\\"slk:Celebrities;sec:td-strm;cpos:1;itc:0;g:8714ae80-beb0-39b6-9ee1-bd13ffb3f5c5;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\" data-action-outcome=\\\"navigate\\\"\\u003ECelebrities\\u003C/a\\u003E\\u003C/li\\u003E\\u003C/ul\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"side-buttons\\\"\\u003E\\u003Cbutton class=\\\"img-sprite close side-button voh rapid-noclick-resp\\\" data-b=\\\"\\\" title=\\\"Remove\\\"\\u003ERemove\\u003C/button\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"content cavideo has-image voh-parent cf\\\" data-uuid=\\\"04cc60e0-a193-3352-8e5c-ff896228e590\\\" data-ylk=\\\"sec:td-strm;cat:default;bpos:1;cpos:8;pkgt:4;ccode:news;g:04cc60e0-a193-3352-8e5c-ff896228e590;ed:0;\\\" data-url=\\\"http%3A%2F%2Fnews.yahoo.com%2Fvideo%2Fmajor-setback-defense-george-zimmerman-161228577.html\\\" data-wikiids=\\\"\\\" data-reason=\\\"TRENDING\\\"\\u003E\\u003Cdiv class=\\\"wrapper cf\\\"\\u003E\\u003Ca class=\\\"img ov-h thumb-left  \\\" href=\\\"/video/major-setback-defense-george-zimmerman-161228577.html\\\" data-action-outcome=\\\"navigate\\\" data-ylk=\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:8;g:04cc60e0-a193-3352-8e5c-ff896228e590;tar:news.yahoo.com;ltxt:Majorset;ct:3;pkgt:4;r:4100001232;slk:title;itc:0;prov:WABC\\u2013NY;sort:1;test:900;intl:us;cat:default;ccode:news;\\\" tabindex=\\\"-1\\\"\\u003E\\u003Cimg src=\\\"http://l.yimg.com/os/mit/media/m/base/images/transparent-95031.png\\\" style=\\\"margin-left:-32px;background-image:url('http://l3.yimg.com/ts/api/res/1.2/3aHYmihw4JqFgqXUDpm5bA--/YXBwaWQ9eWhvbWVydW47cT04NTtzbT0xO3c9MjUwO2g9MTQx/http://media.zenfs.com/en-US/video/video.wabc.abc.news.com/10a5262f6a2220ce4bf4830c048b3257');\\\" width=\\\"145\\\" height=\\\"82\\\" alt=\\\"\\\" title=\\\"\\\" class=\\\"lzbg\\\"\\u003E\\u003Cspan class=\\\"icon-overlay\\\"\\u003E\\u003Cspan class=\\\"video-icon d-ib\\\"\\u003E\\u003Ci class=\\\"icon-sprite\\\"\\u003E\\u003C/i\\u003E \\u003Cspan class=\\\"play-now fz-xxs\\\"\\u003EPlay\\u003C/span\\u003E\\u003C/span\\u003E\\u003C/span\\u003E\\u003C/a\\u003E\\u003Cdiv class=\\\"body\\\"\\u003E\\u003Cdiv class=\\\"body-wrap\\\"\\u003E\\u003Ch3 class=\\\"fw-b fz-s lh-115\\\"\\u003E\\u003Ca class=\\\"\\\" href=\\\"/video/major-setback-defense-george-zimmerman-161228577.html\\\" data-action-outcome=\\\"navigate\\\" data-ylk=\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:8;g:04cc60e0-a193-3352-8e5c-ff896228e590;tar:news.yahoo.com;ltxt:Majorset;ct:3;pkgt:4;r:4100001232;slk:title;itc:0;prov:WABC\\u2013NY;sort:1;test:900;intl:us;cat:default;ccode:news;\\\"\\u003EMajor setback for the defense at George Zimmerman trial\\u003C/a\\u003E\\u003C/h3\\u003E\\u003Cp class=\\\"summary mt-xxs\\\"\\u003EMarci Gonzalez reports for ABC News from Sanford, Florida\\u003C/p\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"attribution fz-xxs\\\"\\u003E\\u003Cspan class=\\\"source\\\"\\u003EWABC \\u2013 NY\\u003C/span\\u003E\\u003Cul class=\\\"interest-list d-ib voh\\\"\\u003E\\u003C/ul\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"side-buttons\\\"\\u003E\\u003Cbutton class=\\\"img-sprite close side-button voh rapid-noclick-resp\\\" data-b=\\\"\\\" title=\\\"Remove\\\"\\u003ERemove\\u003C/button\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"content voh-parent cf\\\" data-uuid=\\\"c200730b-eb18-376d-a3d3-1892197b9f54\\\" data-ylk=\\\"sec:td-strm;cat:default;bpos:1;cpos:9;pkgt:3;ccode:news;g:c200730b-eb18-376d-a3d3-1892197b9f54;ed:0;\\\" data-url=\\\"http%3A%2F%2Fnews.yahoo.com%2Fwashington-vilified-both-sides-egypts-divide-174446715.html\\\" data-wikiids=\\\"YCT:001000661|YCT:001000680|WIKIID:Barack_Obama|WIKIID:Mohamed_Morsi|WIKIID:Egypt|WIKIID:United_States|WIKIID:Hosni_Mubarak|WIKIID:Cairo\\\" data-reason=\\\"TRENDING\\\"\\u003E\\u003Cdiv class=\\\"wrapper cf\\\"\\u003E\\u003Cdiv class=\\\"body\\\"\\u003E\\u003Cdiv class=\\\"body-wrap\\\"\\u003E\\u003Ch3 class=\\\"fw-b fz-s lh-115\\\"\\u003E\\u003Ca class=\\\"\\\" href=\\\"/washington-vilified-both-sides-egypts-divide-174446715.html\\\" data-action-outcome=\\\"navigate\\\" data-ylk=\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:9;g:c200730b-eb18-376d-a3d3-1892197b9f54;tar:news.yahoo.com;ltxt:Washingt;ct:1;pkgt:3;r:4090000779;slk:title;itc:0;prov:Reuters;sort:1;test:900;intl:us;cat:default;ccode:news;\\\"\\u003EWashington vilified on both sides of Egypt&#39;s divide\\u003C/a\\u003E\\u003C/h3\\u003E\\u003Cp class=\\\"summary mt-xxs\\\"\\u003EBy Maggie Fick and Tom Finn CAIRO (Reuters) - Pictures of Barack Obama have popped up all over Cairo. Some have his faced crossed out in paint. Heavy black beards are daubed onto others. No matter which side you talk to in Egypt, where people have been polarized by a violent political crisis, the\\u2026\\u003C/p\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"attribution fz-xxs\\\"\\u003E\\u003Cspan class=\\\"source\\\"\\u003EReuters\\u003C/span\\u003E\\u003Cspan class=\\\"time\\\"\\u003E54 mins ago\\u003C/span\\u003E\\u003Cul class=\\\"interest-list d-ib voh\\\"\\u003E\\u003Cli class=\\\"interest-wrap d-ib\\\"\\u003E\\u003Ca href=\\\"http://news.yahoo.com/politics-and-government/\\\" class=\\\"interest-filter rapidnofollow\\\" data-filter=\\\"YCT:001000661\\\" data-ylk=\\\"slk:Politics;sec:td-strm;cpos:1;itc:0;g:c200730b-eb18-376d-a3d3-1892197b9f54;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\" data-action-outcome=\\\"navigate\\\"\\u003EPolitics\\u003C/a\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"interest-wrap d-ib\\\"\\u003E\\u003Ca href=\\\"http://news.yahoo.com/foreign-policy/\\\" class=\\\"interest-filter rapidnofollow\\\" data-filter=\\\"YCT:001000680\\\" data-ylk=\\\"slk:Foreign Policy;sec:td-strm;cpos:2;itc:0;g:c200730b-eb18-376d-a3d3-1892197b9f54;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\" data-action-outcome=\\\"navigate\\\"\\u003EForeign Policy\\u003C/a\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"interest-wrap d-ib\\\"\\u003E\\u003Ca href=\\\"http://news.yahoo.com/barack-obama/\\\" class=\\\"interest-filter rapidnofollow\\\" data-filter=\\\"WIKIID:Barack_Obama\\\" data-ylk=\\\"slk:Barack Obama;sec:td-strm;cpos:3;itc:0;g:c200730b-eb18-376d-a3d3-1892197b9f54;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\" data-action-outcome=\\\"navigate\\\"\\u003EBarack Obama\\u003C/a\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"interest-wrap d-ib\\\"\\u003E\\u003Ca href=\\\"http://www.yahoo.com/topic/mohamed-morsi/\\\" class=\\\"interest-filter rapidnofollow\\\" data-filter=\\\"WIKIID:Mohamed_Morsi\\\" data-ylk=\\\"slk:Mohamed Morsi;sec:td-strm;cpos:4;itc:0;g:c200730b-eb18-376d-a3d3-1892197b9f54;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\" data-action-outcome=\\\"navigate\\\"\\u003EMohamed Morsi\\u003C/a\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"interest-wrap d-ib\\\"\\u003E\\u003Ca href=\\\"http://news.yahoo.com/egypt/\\\" class=\\\"interest-filter rapidnofollow\\\" data-filter=\\\"WIKIID:Egypt\\\" data-ylk=\\\"slk:Egypt;sec:td-strm;cpos:5;itc:0;g:c200730b-eb18-376d-a3d3-1892197b9f54;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\" data-action-outcome=\\\"navigate\\\"\\u003EEgypt\\u003C/a\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"interest-wrap d-ib\\\"\\u003E\\u003Ca href=\\\"http://www.yahoo.com/topic/united-states/\\\" class=\\\"interest-filter rapidnofollow\\\" data-filter=\\\"WIKIID:United_States\\\" data-ylk=\\\"slk:United States;sec:td-strm;cpos:6;itc:0;g:c200730b-eb18-376d-a3d3-1892197b9f54;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\" data-action-outcome=\\\"navigate\\\"\\u003EUnited States\\u003C/a\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"interest-wrap d-ib\\\"\\u003E\\u003Ca href=\\\"http://news.yahoo.com/hosni-mubarak/\\\" class=\\\"interest-filter rapidnofollow\\\" data-filter=\\\"WIKIID:Hosni_Mubarak\\\" data-ylk=\\\"slk:Hosni Mubarak;sec:td-strm;cpos:7;itc:0;g:c200730b-eb18-376d-a3d3-1892197b9f54;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\" data-action-outcome=\\\"navigate\\\"\\u003EHosni Mubarak\\u003C/a\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"interest-wrap d-ib\\\"\\u003E\\u003Ca href=\\\"http://www.yahoo.com/topic/cairo/\\\" class=\\\"interest-filter rapidnofollow\\\" data-filter=\\\"WIKIID:Cairo\\\" data-ylk=\\\"slk:Cairo;sec:td-strm;cpos:8;itc:0;g:c200730b-eb18-376d-a3d3-1892197b9f54;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\" data-action-outcome=\\\"navigate\\\"\\u003ECairo\\u003C/a\\u003E\\u003C/li\\u003E\\u003C/ul\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"side-buttons\\\"\\u003E\\u003Cbutton class=\\\"img-sprite close side-button voh rapid-noclick-resp\\\" data-b=\\\"\\\" title=\\\"Remove\\\"\\u003ERemove\\u003C/button\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"content voh-parent cf\\\" data-uuid=\\\"03ea9147-55d7-3820-996b-2c161860b5a2\\\" data-ylk=\\\"sec:td-strm;cat:default;bpos:1;cpos:10;pkgt:3;ccode:news;g:03ea9147-55d7-3820-996b-2c161860b5a2;ed:0;\\\" data-url=\\\"http%3A%2F%2Fnews.yahoo.com%2Fpublicly-shaming-girls-short-shorts-elementary-school-principal-132008451.html\\\" data-wikiids=\\\"YCT:001000267|YCT:001000269|WIKIID:Elementary_school\\\" data-reason=\\\"TRENDING\\\"\\u003E\\u003Cdiv class=\\\"wrapper cf\\\"\\u003E\\u003Cdiv class=\\\"body\\\"\\u003E\\u003Cdiv class=\\\"body-wrap\\\"\\u003E\\u003Ch3 class=\\\"fw-b fz-s lh-115\\\"\\u003E\\u003Ca class=\\\"\\\" href=\\\"/publicly-shaming-girls-short-shorts-elementary-school-principal-132008451.html\\\" data-action-outcome=\\\"navigate\\\" data-ylk=\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:10;g:03ea9147-55d7-3820-996b-2c161860b5a2;tar:news.yahoo.com;ltxt:Afterpub;ct:1;pkgt:3;r:4100000546;slk:title;itc:0;prov:TheDailyCaller;sort:1;test:900;intl:us;cat:default;ccode:news;\\\"\\u003EAfter publicly shaming girls for short shorts, elementary school principal apologizes\\u003C/a\\u003E\\u003C/h3\\u003E\\u003Cp class=\\\"summary mt-xxs\\\"\\u003EThe principal at a highly selective and highly prestigious Chicago elementary school has apologized for singling out and publicly shaming seven girls on the last day of school for the immodest lengths of their shorts.\\u003C/p\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"attribution fz-xxs\\\"\\u003E\\u003Cspan class=\\\"source\\\"\\u003EThe Daily Caller\\u003C/span\\u003E\\u003Cul class=\\\"interest-list d-ib voh\\\"\\u003E\\u003Cli class=\\\"interest-wrap d-ib\\\"\\u003E\\u003Ca href=\\\"http://news.yahoo.com/education/\\\" class=\\\"interest-filter rapidnofollow\\\" data-filter=\\\"YCT:001000267\\\" data-ylk=\\\"slk:Education;sec:td-strm;cpos:1;itc:0;g:03ea9147-55d7-3820-996b-2c161860b5a2;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\" data-action-outcome=\\\"navigate\\\"\\u003EEducation\\u003C/a\\u003E\\u003C/li\\u003E\\u003C/ul\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"side-buttons\\\"\\u003E\\u003Cbutton class=\\\"img-sprite close side-button voh rapid-noclick-resp\\\" data-b=\\\"\\\" title=\\\"Remove\\\"\\u003ERemove\\u003C/button\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"content has-image voh-parent cf\\\" data-uuid=\\\"590c8c6f-61a8-3dea-9ba7-8cb83525a33b\\\" data-ylk=\\\"sec:td-strm;cat:default;bpos:1;cpos:11;pkgt:4;ccode:news;g:590c8c6f-61a8-3dea-9ba7-8cb83525a33b;ed:0;\\\" data-url=\\\"http%3A%2F%2Fnews.yahoo.com%2Fbush-benevolent-spirit-must-drive-reform-plans-141956367.html\\\" data-wikiids=\\\"YCT:001000661|YCT:001000700|WIKIID:Immigration_reform\\\" data-reason=\\\"TRENDING\\\"\\u003E\\u003Cdiv class=\\\"wrapper cf\\\"\\u003E\\u003Ca class=\\\"img ov-h thumb-left  \\\" href=\\\"/bush-benevolent-spirit-must-drive-reform-plans-141956367.html\\\" data-action-outcome=\\\"navigate\\\" data-ylk=\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:11;g:590c8c6f-61a8-3dea-9ba7-8cb83525a33b;tar:news.yahoo.com;ltxt:Bush:&#3;ct:1;pkgt:4;r:4072900665;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\" tabindex=\\\"-1\\\"\\u003E\\u003Cimg src=\\\"http://l.yimg.com/os/mit/media/m/base/images/transparent-95031.png\\\" style=\\\"margin-left:-18px;background-image:url('http://l2.yimg.com/ts/api/res/1.2/kM94ldkpwhbbDP4OY9UnYQ--/YXBwaWQ9eWhvbWVydW47cT04NTtzbT0xO3c9MjUwO2g9MTcz/http://media.zenfs.com/en_us/News/ap_webfeeds/4e2f582e10be2e17370f6a7067003150.jpg');\\\" width=\\\"118\\\" height=\\\"82\\\" alt=\\\"\\\" title=\\\"\\\" class=\\\"lzbg\\\"\\u003E\\u003C/a\\u003E\\u003Cdiv class=\\\"body\\\"\\u003E\\u003Cdiv class=\\\"body-wrap\\\"\\u003E\\u003Ch3 class=\\\"fw-b fz-s lh-115\\\"\\u003E\\u003Ca class=\\\"\\\" href=\\\"/bush-benevolent-spirit-must-drive-reform-plans-141956367.html\\\" data-action-outcome=\\\"navigate\\\" data-ylk=\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:11;g:590c8c6f-61a8-3dea-9ba7-8cb83525a33b;tar:news.yahoo.com;ltxt:Bush:&#3;ct:1;pkgt:4;r:4072900665;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\"\\u003EBush: &#39;Benevolent spirit&#39; must drive reform plans\\u003C/a\\u003E\\u003C/h3\\u003E\\u003Cp class=\\\"summary mt-xxs\\\"\\u003EDALLAS (AP) \\u2014 Making a rare return to the political arena, former President George W. Bush urged Congress on Wednesday to reach a &quot;positive resolution&quot; on immigration reform, an issue that eluded him during his presidency and now confronts fellow Republicans in the aftermath of a 2012 election\\u2026\\u003C/p\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"attribution fz-xxs\\\"\\u003E\\u003Cspan class=\\\"source\\\"\\u003EAssociated Press\\u003C/span\\u003E\\u003Cul class=\\\"interest-list d-ib voh\\\"\\u003E\\u003Cli class=\\\"interest-wrap d-ib\\\"\\u003E\\u003Ca href=\\\"http://news.yahoo.com/politics-and-government/\\\" class=\\\"interest-filter rapidnofollow\\\" data-filter=\\\"YCT:001000661\\\" data-ylk=\\\"slk:Politics;sec:td-strm;cpos:1;itc:0;g:590c8c6f-61a8-3dea-9ba7-8cb83525a33b;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\" data-action-outcome=\\\"navigate\\\"\\u003EPolitics\\u003C/a\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"interest-wrap d-ib\\\"\\u003E\\u003Ca href=\\\"http://www.yahoo.com/topic/immigration-reform/\\\" class=\\\"interest-filter rapidnofollow\\\" data-filter=\\\"WIKIID:Immigration_reform\\\" data-ylk=\\\"slk:Immigration reform;sec:td-strm;cpos:2;itc:0;g:590c8c6f-61a8-3dea-9ba7-8cb83525a33b;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\" data-action-outcome=\\\"navigate\\\"\\u003EImmigration reform\\u003C/a\\u003E\\u003C/li\\u003E\\u003C/ul\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"side-buttons\\\"\\u003E\\u003Cbutton class=\\\"img-sprite close side-button voh rapid-noclick-resp\\\" data-b=\\\"\\\" title=\\\"Remove\\\"\\u003ERemove\\u003C/button\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"content has-image voh-parent cf\\\" data-uuid=\\\"e4009e04-8a14-3454-b2ef-0adfa809f2c3\\\" data-ylk=\\\"sec:td-strm;cat:default;bpos:1;cpos:12;pkgt:4;ccode:news;g:e4009e04-8a14-3454-b2ef-0adfa809f2c3;ed:0;\\\" data-url=\\\"http%3A%2F%2Fnews.yahoo.com%2Fnavy-attempt-1st-unmanned-carrier-landing-093729424.html\\\" data-wikiids=\\\"YCT:001000705|YCT:001000661|WIKIID:Unmanned_aerial_vehicle|WIKIID:Aircraft_carrier|WIKIID:Patuxent_River\\\" data-reason=\\\"TRENDING\\\"\\u003E\\u003Cdiv class=\\\"wrapper cf\\\"\\u003E\\u003Ca class=\\\"img ov-h thumb-left  \\\" href=\\\"/navy-attempt-1st-unmanned-carrier-landing-093729424.html\\\" data-action-outcome=\\\"navigate\\\" data-ylk=\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:12;g:e4009e04-8a14-3454-b2ef-0adfa809f2c3;tar:news.yahoo.com;ltxt:Navytoat;ct:1;pkgt:4;r:4100000592;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\" tabindex=\\\"-1\\\"\\u003E\\u003Cimg src=\\\"http://l.yimg.com/os/mit/media/m/base/images/transparent-95031.png\\\" style=\\\"margin-left:-37px;background-image:url('http://l2.yimg.com/ts/api/res/1.2/qYZjBoAYvbF1JWrX_Eav.g--/YXBwaWQ9eWhvbWVydW47cT04NTtzbT0xO3c9MjUwO2g9MTMx/http://media.zenfs.com/en_us/News/ap_webfeeds/c6ce26150eb22417370f6a706700137b.jpg');\\\" width=\\\"156\\\" height=\\\"82\\\" alt=\\\"\\\" title=\\\"\\\" class=\\\"lzbg\\\"\\u003E\\u003C/a\\u003E\\u003Cdiv class=\\\"body\\\"\\u003E\\u003Cdiv class=\\\"body-wrap\\\"\\u003E\\u003Ch3 class=\\\"fw-b fz-s lh-115\\\"\\u003E\\u003Ca class=\\\"\\\" href=\\\"/navy-attempt-1st-unmanned-carrier-landing-093729424.html\\\" data-action-outcome=\\\"navigate\\\" data-ylk=\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:12;g:e4009e04-8a14-3454-b2ef-0adfa809f2c3;tar:news.yahoo.com;ltxt:Navytoat;ct:1;pkgt:4;r:4100000592;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\"\\u003ENavy to attempt 1st unmanned carrier landing\\u003C/a\\u003E\\u003C/h3\\u003E\\u003Cp class=\\\"summary mt-xxs\\\"\\u003ENORFOLK, Va. (AP) \\u2014 The Navy will attempt to land a drone the size of a fighter jet aboard an aircraft carrier for the first time Wednesday, showcasing the military&#39;s capability to have a computer program perform one of the most difficult tasks a pilot is asked to do.\\u003C/p\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"attribution fz-xxs\\\"\\u003E\\u003Cspan class=\\\"source\\\"\\u003EAssociated Press\\u003C/span\\u003E\\u003Cul class=\\\"interest-list d-ib voh\\\"\\u003E\\u003Cli class=\\\"interest-wrap d-ib\\\"\\u003E\\u003Ca href=\\\"http://news.yahoo.com/military-and-defense/\\\" class=\\\"interest-filter rapidnofollow\\\" data-filter=\\\"YCT:001000705\\\" data-ylk=\\\"slk:Military;sec:td-strm;cpos:1;itc:0;g:e4009e04-8a14-3454-b2ef-0adfa809f2c3;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\" data-action-outcome=\\\"navigate\\\"\\u003EMilitary\\u003C/a\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"interest-wrap d-ib\\\"\\u003E\\u003Ca href=\\\"http://news.yahoo.com/politics-and-government/\\\" class=\\\"interest-filter rapidnofollow\\\" data-filter=\\\"YCT:001000661\\\" data-ylk=\\\"slk:Politics;sec:td-strm;cpos:2;itc:0;g:e4009e04-8a14-3454-b2ef-0adfa809f2c3;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\" data-action-outcome=\\\"navigate\\\"\\u003EPolitics\\u003C/a\\u003E\\u003C/li\\u003E\\u003C/ul\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"side-buttons\\\"\\u003E\\u003Cbutton class=\\\"img-sprite close side-button voh rapid-noclick-resp\\\" data-b=\\\"\\\" title=\\\"Remove\\\"\\u003ERemove\\u003C/button\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"content cavideo has-image voh-parent cf\\\" data-uuid=\\\"999a3ee7-37dc-34bd-99a7-51b289bd05a6\\\" data-ylk=\\\"sec:td-strm;cat:default;bpos:1;cpos:13;pkgt:4;ccode:news;g:999a3ee7-37dc-34bd-99a7-51b289bd05a6;ed:0;\\\" data-url=\\\"http%3A%2F%2Fnews.yahoo.com%2Fvideo%2Fskinny-dipping-wife-helps-husband-112335504.html\\\" data-wikiids=\\\"\\\" data-reason=\\\"TRENDING\\\"\\u003E\\u003Cdiv class=\\\"wrapper cf\\\"\\u003E\\u003Ca class=\\\"img ov-h thumb-left  \\\" href=\\\"/video/skinny-dipping-wife-helps-husband-112335504.html\\\" data-action-outcome=\\\"navigate\\\" data-ylk=\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:13;g:999a3ee7-37dc-34bd-99a7-51b289bd05a6;tar:news.yahoo.com;ltxt:Skinny-d;ct:3;pkgt:4;r:4100001466;slk:title;itc:0;prov:WPVI\\u2013Philadelphi;sort:1;test:900;intl:us;cat:default;ccode:news;\\\" tabindex=\\\"-1\\\"\\u003E\\u003Cimg src=\\\"http://l.yimg.com/os/mit/media/m/base/images/transparent-95031.png\\\" style=\\\"margin-left:-32px;background-image:url('http://l1.yimg.com/ts/api/res/1.2/k0Uux1mipxEie_NcST2_RA--/YXBwaWQ9eWhvbWVydW47cT04NTtzbT0xO3c9MjUwO2g9MTQx/http://media.zenfs.com/en-US/video/video.wpvi.abc.news.com/fd9ca258c081f44a75f5d0ce3c14d921');\\\" width=\\\"145\\\" height=\\\"82\\\" alt=\\\"\\\" title=\\\"\\\" class=\\\"lzbg\\\"\\u003E\\u003Cspan class=\\\"icon-overlay\\\"\\u003E\\u003Cspan class=\\\"video-icon d-ib\\\"\\u003E\\u003Ci class=\\\"icon-sprite\\\"\\u003E\\u003C/i\\u003E \\u003Cspan class=\\\"play-now fz-xxs\\\"\\u003EPlay\\u003C/span\\u003E\\u003C/span\\u003E\\u003C/span\\u003E\\u003C/a\\u003E\\u003Cdiv class=\\\"body\\\"\\u003E\\u003Cdiv class=\\\"body-wrap\\\"\\u003E\\u003Ch3 class=\\\"fw-b fz-s lh-115\\\"\\u003E\\u003Ca class=\\\"\\\" href=\\\"/video/skinny-dipping-wife-helps-husband-112335504.html\\\" data-action-outcome=\\\"navigate\\\" data-ylk=\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:13;g:999a3ee7-37dc-34bd-99a7-51b289bd05a6;tar:news.yahoo.com;ltxt:Skinny-d;ct:3;pkgt:4;r:4100001466;slk:title;itc:0;prov:WPVI\\u2013Philadelphi;sort:1;test:900;intl:us;cat:default;ccode:news;\\\"\\u003ESkinny-dipping wife helps husband steal\\u003C/a\\u003E\\u003C/h3\\u003E\\u003Cp class=\\\"summary mt-xxs\\\"\\u003EClick play to watch the report from Action News\\u003C/p\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"attribution fz-xxs\\\"\\u003E\\u003Cspan class=\\\"source\\\"\\u003EWPVI \\u2013 Philadelphia\\u003C/span\\u003E\\u003Cul class=\\\"interest-list d-ib voh\\\"\\u003E\\u003C/ul\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"side-buttons\\\"\\u003E\\u003Cbutton class=\\\"img-sprite close side-button voh rapid-noclick-resp\\\" data-b=\\\"\\\" title=\\\"Remove\\\"\\u003ERemove\\u003C/button\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"content has-image voh-parent cf\\\" data-uuid=\\\"95413a0a-1d88-3f94-817c-d6b5fb824b6f\\\" data-ylk=\\\"sec:td-strm;cat:default;bpos:1;cpos:14;pkgt:4;ccode:news;g:95413a0a-1d88-3f94-817c-d6b5fb824b6f;ed:0;\\\" data-url=\\\"http%3A%2F%2Fnews.yahoo.com%2Fpanera-retool-latest-pay-idea-051305138.html\\\" data-wikiids=\\\"YCT:001000123|WIKIID:Panera_Bread\\\" data-reason=\\\"TRENDING\\\"\\u003E\\u003Cdiv class=\\\"wrapper cf\\\"\\u003E\\u003Ca class=\\\"img ov-h thumb-left  \\\" href=\\\"/panera-retool-latest-pay-idea-051305138.html\\\" data-action-outcome=\\\"navigate\\\" data-ylk=\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:14;g:95413a0a-1d88-3f94-817c-d6b5fb824b6f;tar:news.yahoo.com;ltxt:Panerato;ct:1;pkgt:4;r:4100000490;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\" tabindex=\\\"-1\\\"\\u003E\\u003Cimg src=\\\"http://l.yimg.com/os/mit/media/m/base/images/transparent-95031.png\\\" style=\\\"margin-left:-21px;background-image:url('http://l3.yimg.com/ts/api/res/1.2/GRTmxi74dUkPM0bN5Tu_EA--/YXBwaWQ9eWhvbWVydW47cT04NTtzbT0xO3c9MjUwO2g9MTY3/http://media.zenfs.com/en_us/News/ap_webfeeds/a4d177310ec22417370f6a7067000233.jpg');\\\" width=\\\"123\\\" height=\\\"82\\\" alt=\\\"\\\" title=\\\"\\\" class=\\\"lzbg\\\"\\u003E\\u003C/a\\u003E\\u003Cdiv class=\\\"body\\\"\\u003E\\u003Cdiv class=\\\"body-wrap\\\"\\u003E\\u003Ch3 class=\\\"fw-b fz-s lh-115\\\"\\u003E\\u003Ca class=\\\"\\\" href=\\\"/panera-retool-latest-pay-idea-051305138.html\\\" data-action-outcome=\\\"navigate\\\" data-ylk=\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:14;g:95413a0a-1d88-3f94-817c-d6b5fb824b6f;tar:news.yahoo.com;ltxt:Panerato;ct:1;pkgt:4;r:4100000490;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\"\\u003EPanera to retool latest pay-what-you-can idea\\u003C/a\\u003E\\u003C/h3\\u003E\\u003Cp class=\\\"summary mt-xxs\\\"\\u003EST. LOUIS (AP) \\u2014 Panera Bread&#39;s latest pay-what-you-can experiment will be retooled and brought back next winter as a seasonal offering rather than a permanent one, the chain&#39;s founder says.\\u003C/p\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"attribution fz-xxs\\\"\\u003E\\u003Cspan class=\\\"source\\\"\\u003EAssociated Press\\u003C/span\\u003E\\u003Cul class=\\\"interest-list d-ib voh\\\"\\u003E\\u003Cli class=\\\"interest-wrap d-ib\\\"\\u003E\\u003Ca href=\\\"http://www.yahoo.com/topic/panera-bread/\\\" class=\\\"interest-filter rapidnofollow\\\" data-filter=\\\"WIKIID:Panera_Bread\\\" data-ylk=\\\"slk:Panera Bread;sec:td-strm;cpos:1;itc:0;g:95413a0a-1d88-3f94-817c-d6b5fb824b6f;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\" data-action-outcome=\\\"navigate\\\"\\u003EPanera Bread\\u003C/a\\u003E\\u003C/li\\u003E\\u003C/ul\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"side-buttons\\\"\\u003E\\u003Cbutton class=\\\"img-sprite close side-button voh rapid-noclick-resp\\\" data-b=\\\"\\\" title=\\\"Remove\\\"\\u003ERemove\\u003C/button\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"content slideshow has-image voh-parent cf\\\" data-uuid=\\\"706337c9-1922-33ac-b86f-a5280ffcc242\\\" data-ylk=\\\"sec:td-strm;cat:default;bpos:1;cpos:15;pkgt:21;ccode:news;g:706337c9-1922-33ac-b86f-a5280ffcc242;ed:0;\\\" data-url=\\\"http%3A%2F%2Fnews.yahoo.com%2Fphotos%2Fcarpenter-1-fire-rages-outside-las-vegas-1373414067-slideshow%2F\\\" data-wikiids=\\\"\\\" data-reason=\\\"TRENDING\\\"\\u003E\\u003Cdiv class=\\\"wrapper cf\\\"\\u003E\\u003Ca class=\\\"img ov-h thumb-left  \\\" href=\\\"/photos/carpenter-1-fire-rages-outside-las-vegas-1373414067-slideshow/\\\" data-action-outcome=\\\"navigate\\\" data-ylk=\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:15;g:706337c9-1922-33ac-b86f-a5280ffcc242;tar:news.yahoo.com;ltxt:Carpente;ct:4;pkgt:21;r:4100001677;slk:title;itc:0;sort:1;test:900;intl:us;cat:default;ccode:news;\\\" tabindex=\\\"-1\\\"\\u003E\\u003Cimg src=\\\"http://l.yimg.com/os/mit/media/m/base/images/transparent-95031.png\\\" style=\\\"background-image:url('http://l1.yimg.com/ts/api/res/1.2/vv0qulgbBMDqq9r94wVCzw--/YXBwaWQ9eWhvbWVydW47cT04NTtzbT0xO2ZpPWZpbGw7dz0xMDA7aD0xMDA7cHlvZmY9MA--/http://l.yimg.com/os/publish-images/news/2013-07-09/147c5e94-9385-462b-85d7-4916b61620c4_fire7.jpg');\\\" width=\\\"82\\\" height=\\\"82\\\" alt=\\\"\\\" title=\\\"\\\" class=\\\"lzbg\\\"\\u003E\\u003Cspan class=\\\"icon-overlay\\\"\\u003E\\u003Cspan class=\\\"gallery-icon\\\"\\u003E\\u003Ci class=\\\"icon-sprite\\\"\\u003E\\u003C/i\\u003E \\u003Cspan class=\\\"view-now fz-xxs\\\"\\u003EView\\u003C/span\\u003E\\u003C/span\\u003E\\u003C/span\\u003E\\u003C/a\\u003E\\u003Cdiv class=\\\"body\\\"\\u003E\\u003Cdiv class=\\\"body-wrap\\\"\\u003E\\u003Ch3 class=\\\"fw-b fz-s lh-115\\\"\\u003E\\u003Ca class=\\\"\\\" href=\\\"/photos/carpenter-1-fire-rages-outside-las-vegas-1373414067-slideshow/\\\" data-action-outcome=\\\"navigate\\\" data-ylk=\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:15;g:706337c9-1922-33ac-b86f-a5280ffcc242;tar:news.yahoo.com;ltxt:Carpente;ct:4;pkgt:21;r:4100001677;slk:title;itc:0;sort:1;test:900;intl:us;cat:default;ccode:news;\\\" data-uuid=\\\"de60ffd9-ff42-4ec7-b62c-b733917baeca\\\"\\u003ECarpenter 1 fire rages outside Las Vegas \\u003Csmall\\u003E(14 photos)\\u003C/small\\u003E\\u003C/a\\u003E\\u003C/h3\\u003E\\u003Cp class=\\\"summary mt-xxs\\\"\\u003EPhotos from the Carpenter 1 fire outside Las Vegas, Nev., which has charred an area the size of Manhattan Island, according to the Associated Press .\\u003C/p\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"attribution fz-xxs\\\"\\u003E\\u003Cul class=\\\"interest-list d-ib voh\\\"\\u003E\\u003C/ul\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"side-buttons\\\"\\u003E\\u003Cbutton class=\\\"img-sprite close side-button voh rapid-noclick-resp\\\" data-b=\\\"\\\" title=\\\"Remove\\\"\\u003ERemove\\u003C/button\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"content rmx-ad has-image voh-parent cf\\\" data-uuid=\\\"21675196\\\" data-ylk=\\\"sec:td-strm;cat:default;bpos:1;cpos:16;pkgt:4;ccode:news;g:21675196;ed:0;\\\" data-url=\\\"http%3A%2F%2Fad.yieldmanager.com%2Fclk%3F3%2CeJytjcsOgjAURH-IRQFb2jQuCgUC0qIJSnCHPMozbohEv96ARH.As5g7kzvJ6CaFiOQIV7ggBQEIWFQ364JUoC5LpAFKqWERBC2ICdbYwhFPp9nBD.durzlsbhfFPizXVs7WW9Tl5iHPt3d6vE7sLzgkZMHmg3VXccxg.VLPBNvfmp.thCF7wYcuSs8w9rNJJN4gWr2VXdlEiTvLjoFs9MaYy17-BvaaBt5Mc081%2Chttp%253A%252F%252Fwww.nextag.com%252Fgoto.jsp%253Fp%253D357374%2526crid%253D70102%2526search%253Ddress\\\" data-wikiids=\\\"\\\" data-rmx-beacon=\\\"http://ad.yieldmanager.com/csc?ve=2&eDVBQF12wp2gYuJLPlTbhXlzA6IWivR8TvUupIdTtxWWT_KRcUq_k3JeHFR5Axmf8W8Eu_SnJ6nsBcHGXwM.EPjNsm3pCuLboxmB5dStxjLbeGiiF.eCSA9lwNfB2G248fAPjGPhyi3N7PQqZ.svAsKQwK05a3JLjQajId3GqR92_txBMmy1awX8Zn3nrwjgHFvzLPIFJ1svmulxdP_g7Hb5tjnpXXyCnpmH1NpTll3NAd7wk9XWEeun8rqrw2ZNNfF6WZS5RPwYCev7k9LVM1VTjs2yqGg0nIQH4pYpgN6oyO.mxW3BkIqa9snxkq7mfa0nH4otnvlfoNJjq9yWwUQNtnQKiq4pUms7HrqZzbDqLfDraJSxWV.1sb4QtExWizh6e_eURb_7vtwbvHKWqWH4WU1Emy4c7jaJG2.Hs8h_XLhYZjLbKs9DsiFP5RrghHN6TNdK9aVIZxIoWsOagptRElaqbCAXQh.HKAVOgd.xwnFkStxahe_BgtmjXbbFsLFdh299IqaYF6j.k.6curquTM6C_WFVtHERJUhjsQYk6noMOLdpgBDFCmQ6r0EzWsWEW_.W_twMnzL6ky.3z6EXJBkmtA.j18qFVulOuP.NogVvbhqtsQH0yB2vbDuX7JTWCDY24pQqw8IwgVO0UcFt6CwFS0PtCtn1AnMCgGjkXCcIYqVbNhLL7zg40ZDc8OcR2UHQkHGDnF7m918m1ULk2gJMFi_x.pyiODRnuDg34PxmKSQku37Js.LjNL11buxN2AshqV4gt8R3y02COFdxzswHg1pFZaRwDdDAiDXU_xBaYPWURpeIFxN0XlMHBw--&ap=16\\\"\\u003E\\u003Cdiv class=\\\"wrapper cf\\\"\\u003E\\u003Ca class=\\\"img ov-h thumb-left  \\\" href=\\\"http://ad.yieldmanager.com/clk?3,eJytjcsOgjAURH-IRQFb2jQuCgUC0qIJSnCHPMozbohEv96ARH.As5g7kzvJ6CaFiOQIV7ggBQEIWFQ364JUoC5LpAFKqWERBC2ICdbYwhFPp9nBD.durzlsbhfFPizXVs7WW9Tl5iHPt3d6vE7sLzgkZMHmg3VXccxg.VLPBNvfmp.thCF7wYcuSs8w9rNJJN4gWr2VXdlEiTvLjoFs9MaYy17-BvaaBt5Mc081,http%3A%2F%2Fwww.nextag.com%2Fgoto.jsp%3Fp%3D357374%26crid%3D70102%26search%3Ddress\\\" data-action-outcome=\\\"navigate\\\" data-ylk=\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:16;g:21675196;tar:ad.yieldmanager.com;ltxt:Top10Dre;ct:1;pkgt:4;ad:1;slk:title;itc:0;sort:1;test:900;intl:us;cat:default;ccode:news;\\\" target=\\\"_blank\\\" tabindex=\\\"-1\\\"\\u003E\\u003Cimg src=\\\"http://l.yimg.com/os/mit/media/m/base/images/transparent-95031.png\\\" style=\\\"background-image:url('http://l2.yimg.com/av/moneyball/ads/bulk/6473/c1b5c4a6baf815019e3f6c79b13674e1.jpg');\\\" width=\\\"82\\\" height=\\\"82\\\" alt=\\\"\\\" title=\\\"\\\" class=\\\"lzbg\\\"\\u003E\\u003C/a\\u003E\\u003Cdiv class=\\\"body\\\"\\u003E\\u003Cdiv class=\\\"body-wrap\\\"\\u003E\\u003Ch3 class=\\\"fw-b fz-s lh-115\\\"\\u003E\\u003Ca class=\\\"\\\" href=\\\"http://ad.yieldmanager.com/clk?3,eJytjcsOgjAURH-IRQFb2jQuCgUC0qIJSnCHPMozbohEv96ARH.As5g7kzvJ6CaFiOQIV7ggBQEIWFQ364JUoC5LpAFKqWERBC2ICdbYwhFPp9nBD.durzlsbhfFPizXVs7WW9Tl5iHPt3d6vE7sLzgkZMHmg3VXccxg.VLPBNvfmp.thCF7wYcuSs8w9rNJJN4gWr2VXdlEiTvLjoFs9MaYy17-BvaaBt5Mc081,http%3A%2F%2Fwww.nextag.com%2Fgoto.jsp%3Fp%3D357374%26crid%3D70102%26search%3Ddress\\\" data-action-outcome=\\\"navigate\\\" data-ylk=\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:16;g:21675196;tar:ad.yieldmanager.com;ltxt:Top10Dre;ct:1;pkgt:4;ad:1;slk:title;itc:0;sort:1;test:900;intl:us;cat:default;ccode:news;\\\" target=\\\"_blank\\\"\\u003ETop 10 Dresses for 2013\\u003C/a\\u003E\\u003C/h3\\u003E\\u003Cp class=\\\"summary mt-xxs\\\"\\u003EHottest Dresses on sale.  Awesome selection and deals.\\u003C/p\\u003E\\u003Ca class=\\\"adlink fz-xxs rapid-noclick-resp\\\" href=\\\"http://info.yahoo.com/privacy/us/yahoo/adinfo_geo.html\\\" target=\\\"_blank\\\"\\u003EAdChoices\\u003Ci class=\\\"img-sprite\\\"\\u003E\\u003C/i\\u003E\\u003C/a\\u003E\\u000a\\u003Ca class=\\\"fz-xxs adv rapid-noclick-resp\\\" href=\\\"http://ad.yieldmanager.com/clk?3,eJytjcsOgjAURH-IRQFb2jQuCgUC0qIJSnCHPMozbohEv96ARH.As5g7kzvJ6CaFiOQIV7ggBQEIWFQ364JUoC5LpAFKqWERBC2ICdbYwhFPp9nBD.durzlsbhfFPizXVs7WW9Tl5iHPt3d6vE7sLzgkZMHmg3VXccxg.VLPBNvfmp.thCF7wYcuSs8w9rNJJN4gWr2VXdlEiTvLjoFs9MaYy17-BvaaBt5Mc081,http%3A%2F%2Fwww.nextag.com%2Fgoto.jsp%3Fp%3D357374%26crid%3D70102%26search%3Ddress\\\" target=\\\"_blank\\\"\\u003E\\u003Cspan class=\\\"source\\\"\\u003EOfficial Nextag Site\\u003C/span\\u003E\\u003C/a\\u003E\\u003Ca href=\\\"http://help.yahoo.com/kb/index?page=content&y=PROD_FRONT&locale=en_US&id=SLN14553\\\" class=\\\"fz-xxs sp rapid-noclick-resp\\\" target=\\\"_blank\\\"\\u003ESponsored\\u003C/a\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"attribution fz-xxs\\\"\\u003E\\u003Cul class=\\\"interest-list d-ib voh\\\"\\u003E\\u003C/ul\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"content voh-parent cf\\\" data-uuid=\\\"35246d27-ef1f-3c2f-ac82-50ee6d2511ee\\\" data-ylk=\\\"sec:td-strm;cat:default;bpos:1;cpos:17;pkgt:3;ccode:news;g:35246d27-ef1f-3c2f-ac82-50ee6d2511ee;ed:0;\\\" data-url=\\\"http%3A%2F%2Fnews.yahoo.com%2Fky-church-wants-pastor-gone-wifes-column-083204548.html\\\" data-wikiids=\\\"YCT:001000804|YCT:001000780|WIKIID:Southern_Baptist_Convention\\\" data-reason=\\\"TRENDING\\\"\\u003E\\u003Cdiv class=\\\"wrapper cf\\\"\\u003E\\u003Cdiv class=\\\"body\\\"\\u003E\\u003Cdiv class=\\\"body-wrap\\\"\\u003E\\u003Ch3 class=\\\"fw-b fz-s lh-115\\\"\\u003E\\u003Ca class=\\\"\\\" href=\\\"/ky-church-wants-pastor-gone-wifes-column-083204548.html\\\" data-action-outcome=\\\"navigate\\\" data-ylk=\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:17;g:35246d27-ef1f-3c2f-ac82-50ee6d2511ee;tar:news.yahoo.com;ltxt:Ky.churc;ct:1;pkgt:3;r:4059001073;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\"\\u003EKy. church wants pastor gone after wife&#39;s column\\u003C/a\\u003E\\u003C/h3\\u003E\\u003Cp class=\\\"summary mt-xxs\\\"\\u003ELOUISVILLE, Ky. (AP) \\u2014 A newspaper column lampooning Southern Baptists, calling the group &quot;the crazy old paranoid uncle of evangelical Christians,&quot; is causing quite a stir in a Kentucky city and put a pastor&#39;s job in jeopardy.\\u003C/p\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"attribution fz-xxs\\\"\\u003E\\u003Cspan class=\\\"source\\\"\\u003EAssociated Press\\u003C/span\\u003E\\u003Cul class=\\\"interest-list d-ib voh\\\"\\u003E\\u003Cli class=\\\"interest-wrap d-ib\\\"\\u003E\\u003Ca href=\\\"http://news.yahoo.com/religion-and-beliefs/\\\" class=\\\"interest-filter rapidnofollow\\\" data-filter=\\\"YCT:001000804\\\" data-ylk=\\\"slk:Religion;sec:td-strm;cpos:1;itc:0;g:35246d27-ef1f-3c2f-ac82-50ee6d2511ee;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\" data-action-outcome=\\\"navigate\\\"\\u003EReligion\\u003C/a\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"interest-wrap d-ib\\\"\\u003E\\u003Ca href=\\\"http://news.yahoo.com/society-and-culture/\\\" class=\\\"interest-filter rapidnofollow\\\" data-filter=\\\"YCT:001000780\\\" data-ylk=\\\"slk:Society;sec:td-strm;cpos:2;itc:0;g:35246d27-ef1f-3c2f-ac82-50ee6d2511ee;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\" data-action-outcome=\\\"navigate\\\"\\u003ESociety\\u003C/a\\u003E\\u003C/li\\u003E\\u003C/ul\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"side-buttons\\\"\\u003E\\u003Cbutton class=\\\"img-sprite close side-button voh rapid-noclick-resp\\\" data-b=\\\"\\\" title=\\\"Remove\\\"\\u003ERemove\\u003C/button\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"content has-image voh-parent cf\\\" data-uuid=\\\"89342141-8982-3a32-9a2e-81cda1656e16\\\" data-ylk=\\\"sec:td-strm;cat:default;bpos:1;cpos:18;pkgt:4;ccode:news;g:89342141-8982-3a32-9a2e-81cda1656e16;ed:0;\\\" data-url=\\\"http%3A%2F%2Fnews.yahoo.com%2Fformer-judge-admits-flaws-secret-court-145541583.html\\\" data-wikiids=\\\"YCT:001000661|WIKIID:National_Security_Agency|WIKIID:Barack_Obama\\\" data-reason=\\\"TRENDING\\\"\\u003E\\u003Cdiv class=\\\"wrapper cf\\\"\\u003E\\u003Ca class=\\\"img ov-h thumb-left  \\\" href=\\\"/former-judge-admits-flaws-secret-court-145541583.html\\\" data-action-outcome=\\\"navigate\\\" data-ylk=\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:18;g:89342141-8982-3a32-9a2e-81cda1656e16;tar:news.yahoo.com;ltxt:Formerju;ct:1;pkgt:4;r:4072901757;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\" tabindex=\\\"-1\\\"\\u003E\\u003Cimg src=\\\"http://l.yimg.com/os/mit/media/m/base/images/transparent-95031.png\\\" style=\\\"background-image:url('http://l2.yimg.com/ts/api/res/1.2/V1oj15r8LwVhitDeCoj3_g--/YXBwaWQ9eWhvbWVydW47cT04NTtzbT0xO3c9MjA4O2g9MjUw/http://media.zenfs.com/en_us/News/ap_webfeeds/fab40ba5f2431816370f6a706700947e.jpg');\\\" width=\\\"82\\\" height=\\\"99\\\" alt=\\\"\\\" title=\\\"\\\" class=\\\"lzbg\\\"\\u003E\\u003C/a\\u003E\\u003Cdiv class=\\\"body\\\"\\u003E\\u003Cdiv class=\\\"body-wrap\\\"\\u003E\\u003Ch3 class=\\\"fw-b fz-s lh-115\\\"\\u003E\\u003Ca class=\\\"\\\" href=\\\"/former-judge-admits-flaws-secret-court-145541583.html\\\" data-action-outcome=\\\"navigate\\\" data-ylk=\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:18;g:89342141-8982-3a32-9a2e-81cda1656e16;tar:news.yahoo.com;ltxt:Formerju;ct:1;pkgt:4;r:4072901757;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\"\\u003EFormer judge admits flaws in secret court\\u003C/a\\u003E\\u003C/h3\\u003E\\u003Cp class=\\\"summary mt-xxs\\\"\\u003EWASHINGTON (AP) \\u2014 A former federal judge who served on a secret court overseeing the National Security Agency&#39;s secret surveillance programs said Tuesday the panel is independent but flawed because only the government&#39;s side is represented effectively in its deliberations.\\u003C/p\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"attribution fz-xxs\\\"\\u003E\\u003Cspan class=\\\"source\\\"\\u003EAssociated Press\\u003C/span\\u003E\\u003Cul class=\\\"interest-list d-ib voh\\\"\\u003E\\u003Cli class=\\\"interest-wrap d-ib\\\"\\u003E\\u003Ca href=\\\"http://news.yahoo.com/politics-and-government/\\\" class=\\\"interest-filter rapidnofollow\\\" data-filter=\\\"YCT:001000661\\\" data-ylk=\\\"slk:Politics;sec:td-strm;cpos:1;itc:0;g:89342141-8982-3a32-9a2e-81cda1656e16;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\" data-action-outcome=\\\"navigate\\\"\\u003EPolitics\\u003C/a\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"interest-wrap d-ib\\\"\\u003E\\u003Ca href=\\\"http://www.yahoo.com/topic/national-security-agency/\\\" class=\\\"interest-filter rapidnofollow\\\" data-filter=\\\"WIKIID:National_Security_Agency\\\" data-ylk=\\\"slk:National Security Agency;sec:td-strm;cpos:2;itc:0;g:89342141-8982-3a32-9a2e-81cda1656e16;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\" data-action-outcome=\\\"navigate\\\"\\u003ENational Security Agency\\u003C/a\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"interest-wrap d-ib\\\"\\u003E\\u003Ca href=\\\"http://news.yahoo.com/barack-obama/\\\" class=\\\"interest-filter rapidnofollow\\\" data-filter=\\\"WIKIID:Barack_Obama\\\" data-ylk=\\\"slk:Barack Obama;sec:td-strm;cpos:3;itc:0;g:89342141-8982-3a32-9a2e-81cda1656e16;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\" data-action-outcome=\\\"navigate\\\"\\u003EBarack Obama\\u003C/a\\u003E\\u003C/li\\u003E\\u003C/ul\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"side-buttons\\\"\\u003E\\u003Cbutton class=\\\"img-sprite close side-button voh rapid-noclick-resp\\\" data-b=\\\"\\\" title=\\\"Remove\\\"\\u003ERemove\\u003C/button\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"content has-image voh-parent cf\\\" data-uuid=\\\"545a4a5d-31f1-3d2b-b3a1-af6ab035ba08\\\" data-ylk=\\\"sec:td-strm;cat:default;bpos:1;cpos:19;pkgt:4;ccode:news;g:545a4a5d-31f1-3d2b-b3a1-af6ab035ba08;ed:0;\\\" data-url=\\\"http%3A%2F%2Fnews.yahoo.com%2F30-000-california-prisoners-refusing-meals-030023796.html\\\" data-wikiids=\\\"WIKIID:California|WIKIID:Solitary_confinement\\\" data-reason=\\\"TRENDING\\\"\\u003E\\u003Cdiv class=\\\"wrapper cf\\\"\\u003E\\u003Ca class=\\\"img ov-h thumb-left  \\\" href=\\\"/30-000-california-prisoners-refusing-meals-030023796.html\\\" data-action-outcome=\\\"navigate\\\" data-ylk=\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:19;g:545a4a5d-31f1-3d2b-b3a1-af6ab035ba08;tar:news.yahoo.com;ltxt:30,000Ca;ct:1;pkgt:4;r:4100000793;slk:title;itc:0;prov:TheAtlanticWire;sort:1;test:900;intl:us;cat:default;ccode:news;\\\" tabindex=\\\"-1\\\"\\u003E\\u003Cimg src=\\\"http://l.yimg.com/os/mit/media/m/base/images/transparent-95031.png\\\" style=\\\"margin-left:-25px;background-image:url('http://l1.yimg.com/ts/api/res/1.2/cIsjQVUHZJZ7HCJhBG6m2Q--/YXBwaWQ9eWhvbWVydW47cT04NTtzbT0xO3c9MjUwO2g9MTU2/http://media.zenfs.com/en_us/News/theatlanticwire/30_000_California_Prisoners_Are_Refusing-b255dfae58903c7ee92b601e81fb15da');\\\" width=\\\"131\\\" height=\\\"82\\\" alt=\\\"\\\" title=\\\"\\\" class=\\\"lzbg\\\"\\u003E\\u003C/a\\u003E\\u003Cdiv class=\\\"body\\\"\\u003E\\u003Cdiv class=\\\"body-wrap\\\"\\u003E\\u003Ch3 class=\\\"fw-b fz-s lh-115\\\"\\u003E\\u003Ca class=\\\"\\\" href=\\\"/30-000-california-prisoners-refusing-meals-030023796.html\\\" data-action-outcome=\\\"navigate\\\" data-ylk=\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:19;g:545a4a5d-31f1-3d2b-b3a1-af6ab035ba08;tar:news.yahoo.com;ltxt:30,000Ca;ct:1;pkgt:4;r:4100000793;slk:title;itc:0;prov:TheAtlanticWire;sort:1;test:900;intl:us;cat:default;ccode:news;\\\"\\u003E30,000 California Prisoners Are Refusing Meals\\u003C/a\\u003E\\u003C/h3\\u003E\\u003Cp class=\\\"summary mt-xxs\\\"\\u003EOver 30,000 California prisoners started refusing meals on Monday morning in what might become the biggest hunger strike in California prison history, according to California&#39;s corrections department.\\u003C/p\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"attribution fz-xxs\\\"\\u003E\\u003Cspan class=\\\"source\\\"\\u003EThe Atlantic Wire\\u003C/span\\u003E\\u003Cul class=\\\"interest-list d-ib voh\\\"\\u003E\\u003Cli class=\\\"interest-wrap d-ib\\\"\\u003E\\u003Ca href=\\\"http://news.yahoo.com/california/\\\" class=\\\"interest-filter rapidnofollow\\\" data-filter=\\\"WIKIID:California\\\" data-ylk=\\\"slk:California;sec:td-strm;cpos:1;itc:0;g:545a4a5d-31f1-3d2b-b3a1-af6ab035ba08;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\" data-action-outcome=\\\"navigate\\\"\\u003ECalifornia\\u003C/a\\u003E\\u003C/li\\u003E\\u003C/ul\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"side-buttons\\\"\\u003E\\u003Cbutton class=\\\"img-sprite close side-button voh rapid-noclick-resp\\\" data-b=\\\"\\\" title=\\\"Remove\\\"\\u003ERemove\\u003C/button\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"content has-image voh-parent cf\\\" data-uuid=\\\"c20cc012-29f6-3120-a12f-ef78c41a0a22\\\" data-ylk=\\\"sec:td-strm;cat:default;bpos:1;cpos:20;pkgt:4;ccode:news;g:c20cc012-29f6-3120-a12f-ef78c41a0a22;ed:0;\\\" data-url=\\\"http%3A%2F%2Fnews.yahoo.com%2F3-years-obamacare-incompetence-tells-us-white-house-074000304.html\\\" data-wikiids=\\\"YCT:001000661|YCT:001000681|WIKIID:White_House|WIKIID:Presidency_of_Barack_Obama|WIKIID:Patient_Protection_and_Affordable_Care_Act\\\" data-reason=\\\"TRENDING\\\"\\u003E\\u003Cdiv class=\\\"wrapper cf\\\"\\u003E\\u003Ca class=\\\"img ov-h thumb-left  \\\" href=\\\"/3-years-obamacare-incompetence-tells-us-white-house-074000304.html\\\" data-action-outcome=\\\"navigate\\\" data-ylk=\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:20;g:c20cc012-29f6-3120-a12f-ef78c41a0a22;tar:news.yahoo.com;ltxt:What3yea;ct:1;pkgt:4;r:4065600903;slk:title;itc:0;prov:TheWeek;sort:1;test:900;intl:us;cat:default;ccode:news;\\\" tabindex=\\\"-1\\\"\\u003E\\u003Cimg src=\\\"http://l.yimg.com/os/mit/media/m/base/images/transparent-95031.png\\\" style=\\\"margin-left:-27px;background-image:url('http://l2.yimg.com/ts/api/res/1.2/Rntt.Xg7T8Y5NxTOWahOJg--/YXBwaWQ9eWhvbWVydW47cT04NTtzbT0xO3c9MjUwO2g9MTUx/http://media.zenfs.com/en_us/News/theweek/is-president-obamas-signature-legislative-achievement-turning-into-a-messy-failure.jpg');\\\" width=\\\"136\\\" height=\\\"82\\\" alt=\\\"\\\" title=\\\"\\\" class=\\\"lzbg\\\"\\u003E\\u003C/a\\u003E\\u003Cdiv class=\\\"body\\\"\\u003E\\u003Cdiv class=\\\"body-wrap\\\"\\u003E\\u003Ch3 class=\\\"fw-b fz-s lh-115\\\"\\u003E\\u003Ca class=\\\"\\\" href=\\\"/3-years-obamacare-incompetence-tells-us-white-house-074000304.html\\\" data-action-outcome=\\\"navigate\\\" data-ylk=\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:20;g:c20cc012-29f6-3120-a12f-ef78c41a0a22;tar:news.yahoo.com;ltxt:What3yea;ct:1;pkgt:4;r:4065600903;slk:title;itc:0;prov:TheWeek;sort:1;test:900;intl:us;cat:default;ccode:news;\\\"\\u003EWhat 3 years of ObamaCare incompetence tells us about the White House\\u003C/a\\u003E\\u003C/h3\\u003E\\u003Cp class=\\\"summary mt-xxs\\\"\\u003EThe administration is gradually scaling back its signature legislation \\u2014 just as critics have long demanded\\u003C/p\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"attribution fz-xxs\\\"\\u003E\\u003Cspan class=\\\"source\\\"\\u003EThe Week\\u003C/span\\u003E\\u003Cul class=\\\"interest-list d-ib voh\\\"\\u003E\\u003Cli class=\\\"interest-wrap d-ib\\\"\\u003E\\u003Ca href=\\\"http://news.yahoo.com/politics-and-government/\\\" class=\\\"interest-filter rapidnofollow\\\" data-filter=\\\"YCT:001000661\\\" data-ylk=\\\"slk:Politics;sec:td-strm;cpos:1;itc:0;g:c20cc012-29f6-3120-a12f-ef78c41a0a22;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\" data-action-outcome=\\\"navigate\\\"\\u003EPolitics\\u003C/a\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"interest-wrap d-ib\\\"\\u003E\\u003Ca href=\\\"http://news.yahoo.com/white-house-2/\\\" class=\\\"interest-filter rapidnofollow\\\" data-filter=\\\"WIKIID:White_House\\\" data-ylk=\\\"slk:White House;sec:td-strm;cpos:2;itc:0;g:c20cc012-29f6-3120-a12f-ef78c41a0a22;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\" data-action-outcome=\\\"navigate\\\"\\u003EWhite House\\u003C/a\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"interest-wrap d-ib\\\"\\u003E\\u003Ca href=\\\"http://www.yahoo.com/topic/presidency-of-barack-obama/\\\" class=\\\"interest-filter rapidnofollow\\\" data-filter=\\\"WIKIID:Presidency_of_Barack_Obama\\\" data-ylk=\\\"slk:Presidency of Barack Obama;sec:td-strm;cpos:3;itc:0;g:c20cc012-29f6-3120-a12f-ef78c41a0a22;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\" data-action-outcome=\\\"navigate\\\"\\u003EPresidency of Barack Obama\\u003C/a\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"interest-wrap d-ib\\\"\\u003E\\u003Ca href=\\\"http://news.yahoo.com/patient-protection-and-affordable-care-act/\\\" class=\\\"interest-filter rapidnofollow\\\" data-filter=\\\"WIKIID:Patient_Protection_and_Affordable_Care_Act\\\" data-ylk=\\\"slk:Patient Protection and Affordable Care Act;sec:td-strm;cpos:4;itc:0;g:c20cc012-29f6-3120-a12f-ef78c41a0a22;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\" data-action-outcome=\\\"navigate\\\"\\u003EPatient Protection and Affordable Care Act\\u003C/a\\u003E\\u003C/li\\u003E\\u003C/ul\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"side-buttons\\\"\\u003E\\u003Cbutton class=\\\"img-sprite close side-button voh rapid-noclick-resp\\\" data-b=\\\"\\\" title=\\\"Remove\\\"\\u003ERemove\\u003C/button\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"content has-image voh-parent cf\\\" data-uuid=\\\"2e88e31e-a379-3340-96cb-7c5d904edd46\\\" data-ylk=\\\"sec:td-strm;cat:default;bpos:1;cpos:21;pkgt:4;ccode:news;g:2e88e31e-a379-3340-96cb-7c5d904edd46;ed:0;\\\" data-url=\\\"http%3A%2F%2Fnews.yahoo.com%2Fchina-discovers-primitive-5-000-old-writing-143034872.html\\\" data-wikiids=\\\"\\\" data-reason=\\\"TRENDING\\\"\\u003E\\u003Cdiv class=\\\"wrapper cf\\\"\\u003E\\u003Ca class=\\\"img ov-h thumb-left  \\\" href=\\\"/china-discovers-primitive-5-000-old-writing-143034872.html\\\" data-action-outcome=\\\"navigate\\\" data-ylk=\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:21;g:2e88e31e-a379-3340-96cb-7c5d904edd46;tar:news.yahoo.com;ltxt:Chinadis;ct:1;pkgt:4;r:4100000352;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\" tabindex=\\\"-1\\\"\\u003E\\u003Cimg src=\\\"http://l.yimg.com/os/mit/media/m/base/images/transparent-95031.png\\\" style=\\\"margin-left:-36px;background-image:url('http://l4.yimg.com/ts/api/res/1.2/_7o1U7C.tcvQqh88tfjw8Q--/YXBwaWQ9eWhvbWVydW47cT04NTtzbT0xO3c9MjUwO2g9MTM0/http://media.zenfs.com/en_us/News/ap_webfeeds/ba42591610ce2e17370f6a7067004e28.jpg');\\\" width=\\\"153\\\" height=\\\"82\\\" alt=\\\"\\\" title=\\\"\\\" class=\\\"lzbg\\\"\\u003E\\u003C/a\\u003E\\u003Cdiv class=\\\"body\\\"\\u003E\\u003Cdiv class=\\\"body-wrap\\\"\\u003E\\u003Ch3 class=\\\"fw-b fz-s lh-115\\\"\\u003E\\u003Ca class=\\\"\\\" href=\\\"/china-discovers-primitive-5-000-old-writing-143034872.html\\\" data-action-outcome=\\\"navigate\\\" data-ylk=\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:21;g:2e88e31e-a379-3340-96cb-7c5d904edd46;tar:news.yahoo.com;ltxt:Chinadis;ct:1;pkgt:4;r:4100000352;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\"\\u003EChina discovers primitive, 5,000-year-old writing\\u003C/a\\u003E\\u003C/h3\\u003E\\u003Cp class=\\\"summary mt-xxs\\\"\\u003EBEIJING (AP) \\u2014 Archaeologists say they have discovered some of the world&#39;s oldest known primitive writing, dating back about 5,000 years, in eastern China, and some of the markings etched on broken axes resemble a modern Chinese character.\\u003C/p\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"attribution fz-xxs\\\"\\u003E\\u003Cspan class=\\\"source\\\"\\u003EAssociated Press\\u003C/span\\u003E\\u003Cul class=\\\"interest-list d-ib voh\\\"\\u003E\\u003C/ul\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"side-buttons\\\"\\u003E\\u003Cbutton class=\\\"img-sprite close side-button voh rapid-noclick-resp\\\" data-b=\\\"\\\" title=\\\"Remove\\\"\\u003ERemove\\u003C/button\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"content cavideo has-image voh-parent cf\\\" data-uuid=\\\"c621133c-f907-3f42-93ff-20ef01effa97\\\" data-ylk=\\\"sec:td-strm;cat:default;bpos:1;cpos:22;pkgt:4;ccode:news;g:c621133c-f907-3f42-93ff-20ef01effa97;ed:0;\\\" data-url=\\\"http%3A%2F%2Fnews.yahoo.com%2Fvideo%2Fprinter-ink-efficiency-tested-consumer-174417327.html\\\" data-wikiids=\\\"WIKIID:Ink_cartridge\\\" data-reason=\\\"TRENDING\\\"\\u003E\\u003Cdiv class=\\\"wrapper cf\\\"\\u003E\\u003Ca class=\\\"img ov-h thumb-left  \\\" href=\\\"/video/printer-ink-efficiency-tested-consumer-174417327.html\\\" data-action-outcome=\\\"navigate\\\" data-ylk=\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:22;g:c621133c-f907-3f42-93ff-20ef01effa97;tar:news.yahoo.com;ltxt:Printeri;ct:3;pkgt:4;r:4100001074;slk:title;itc:0;prov:KGO\\u2013SanFrancisco;sort:1;test:900;intl:us;cat:default;ccode:news;\\\" tabindex=\\\"-1\\\"\\u003E\\u003Cimg src=\\\"http://l.yimg.com/os/mit/media/m/base/images/transparent-95031.png\\\" style=\\\"margin-left:-32px;background-image:url('http://l3.yimg.com/ts/api/res/1.2/etz.tfpoo6Au9ixj1O3c4g--/YXBwaWQ9eWhvbWVydW47cT04NTtzbT0xO3c9MjUwO2g9MTQx/http://media.zenfs.com/en-US/video/video.kgo.abc.news.com/20a2be41046b838e6399259f73c9f47d');\\\" width=\\\"145\\\" height=\\\"82\\\" alt=\\\"\\\" title=\\\"\\\" class=\\\"lzbg\\\"\\u003E\\u003Cspan class=\\\"icon-overlay\\\"\\u003E\\u003Cspan class=\\\"video-icon d-ib\\\"\\u003E\\u003Ci class=\\\"icon-sprite\\\"\\u003E\\u003C/i\\u003E \\u003Cspan class=\\\"play-now fz-xxs\\\"\\u003EPlay\\u003C/span\\u003E\\u003C/span\\u003E\\u003C/span\\u003E\\u003C/a\\u003E\\u003Cdiv class=\\\"body\\\"\\u003E\\u003Cdiv class=\\\"body-wrap\\\"\\u003E\\u003Ch3 class=\\\"fw-b fz-s lh-115\\\"\\u003E\\u003Ca class=\\\"\\\" href=\\\"/video/printer-ink-efficiency-tested-consumer-174417327.html\\\" data-action-outcome=\\\"navigate\\\" data-ylk=\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:22;g:c621133c-f907-3f42-93ff-20ef01effa97;tar:news.yahoo.com;ltxt:Printeri;ct:3;pkgt:4;r:4100001074;slk:title;itc:0;prov:KGO\\u2013SanFrancisco;sort:1;test:900;intl:us;cat:default;ccode:news;\\\"\\u003EPrinter ink efficiency tested by Consumer Reports\\u003C/a\\u003E\\u003C/h3\\u003E\\u003Cp class=\\\"summary mt-xxs\\\"\\u003EMany don&#39;t realize it, but printer ink is one of the most expensive liquids you can buy.\\u003C/p\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"attribution fz-xxs\\\"\\u003E\\u003Cspan class=\\\"source\\\"\\u003EKGO \\u2013 San Francisco\\u003C/span\\u003E\\u003Cspan class=\\\"time\\\"\\u003E54 mins ago\\u003C/span\\u003E\\u003Cul class=\\\"interest-list d-ib voh\\\"\\u003E\\u003C/ul\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"side-buttons\\\"\\u003E\\u003Cbutton class=\\\"img-sprite close side-button voh rapid-noclick-resp\\\" data-b=\\\"\\\" title=\\\"Remove\\\"\\u003ERemove\\u003C/button\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"next-batch notice loading\\\" data-key=\\\"1\\\" data-ylk=\\\"slk:fetch;ltxt:fetch;pos:0;bpos:2;cpos:23;itc:1;sec:td-strm;test:900;intl:us;cat:default;ccode:news;\\\"  data-action=\\\"click\\\" data-action-outcome=\\\"fetch\\\"\\u003E\\u003Cbutton class=\\\"fz-xs\\\"\\u003ELoad more stories\\u003C/button\\u003E\\u003C/li\\u003E\\u003C/ul\\u003E\\u003Cinput type=\\\"hidden\\\" class=\\\"historystate\\\" data-time=\\\"1373481532.5925\\\"\\u003E    \\u003C/div\\u003E\\u000a\\u003C/div\\u003E\\u000a\\u003C/div\\u003E\\u000a\\u000a--dali-response-split-51ddaa3c96973Content-Type: text/plain; charset=utf-8\\u000aRMP-Embed-Location: bottom\\u000a\\u000a\\u003Cscript type=\\\"text/javascript\\\"\\u003E\\u000aYUI.namespace(\\\"presentation\\\");\\u000aYUI.presentation.lazyScriptList = [\\\"http://l.yimg.com/zz/combo?nn/lib/metro/g/yui/oop_3.8.1.js&nn/lib/metro/g/yui/event-custom-base_3.8.1.js&nn/lib/metro/g/yui/event-base_3.8.1.js&nn/lib/metro/g/yui/io-base_3.8.1.js&nn/lib/metro/g/yui/json-parse_3.8.1.js&nn/lib/metro/g/yui/json-stringify_3.8.1.js&nn/lib/metro/g/yui/cookie_3.8.1.js&nn/lib/metro/g/yui/jsonp_3.8.1.js&nn/lib/metro/g/yui/dom-core_3.8.1.js&nn/lib/metro/g/yui/dom-base_3.8.1.js&nn/lib/metro/g/yui/dom-style_3.8.1.js&nn/lib/metro/g/yui/selector-native_3.8.1.js&nn/lib/metro/g/yui/selector_3.8.1.js&nn/lib/metro/g/yui/node-core_3.8.1.js&nn/lib/metro/g/yui/node-base_3.8.1.js&nn/lib/metro/g/yui/node-style_3.8.1.js&nn/lib/metro/g/yui/transition_3.8.2.js&nn/lib/metro/g/yui/selector-css2_3.8.1.js&nn/lib/metro/g/yui/selector-css3_3.8.1.js&nn/lib/metro/g/yui/event-custom-complex_3.8.1.js&nn/lib/metro/g/yui/event-synthetic_3.8.1.js&nn/lib/metro/g/yui/event-focus_3.8.1.js&nn/lib/metro/g/yui/event-delegate_3.8.1.js&nn/lib/metro/g/yui/node-event-delegate_3.8.1.js&nn/lib/metro/g/yui/pluginhost-base_3.8.1.js&nn/lib/metro/g/yui/pluginhost-config_3.8.1.js&nn/lib/metro/g/yui/node-pluginhost_3.8.1.js&nn/lib/metro/g/yui/dom-screen_3.8.1.js&nn/lib/metro/g/yui/node-screen_3.8.1.js&nn/lib/metro/g/yui/gallery-storage-lite_3.8.1.js&nn/lib/metro/g/uicontrib/dali/module_platform_1.1.14.js&nn/lib/metro/g/uicontrib/dali/resourcemgr_1.1.14.js&nn/lib/metro/g/uicontrib/dali/dali_transport_1.1.34.js&nn/lib/metro/g/uicontrib/dali/metro_dali_1.0.27.js&nn/lib/metro/g/uicontrib/dali/module_api_1.1.16.js&nn/lib/metro/g/uicontrib/dali/yui_service_0.1.17.js\\\"];\\u000a\\u003C/script\\u003E\\u000a\\u000a\\u003Cscript type=\\\"text/javascript\\\"\\u003E\\u000aYUI.presentation.lazyScriptList = YUI.presentation.lazyScriptList.concat([\\\"http://l.yimg.com/zz/combo?nn/lib/metro/g/uiplugins/metro_viewtype_0.1.24.js&nn/lib/metro/g/uiplugins/default_viewtype_0.1.61.js&nn/lib/metro/g/uiplugins/edit_viewtype_0.1.40.js&nn/lib/metro/g/uicontrib/ylc_1.8.22.js&nn/lib/metro/g/uiplugins/instrumentation_service_0.1.83.js&nn/lib/metro/g/uiplugins/userinfo_service_0.1.15.js&nn/lib/metro/g/uiplugins/statemgr_service_0.1.20.js&nn/lib/metro/g/uiplugins/metrologger_service_0.1.18.js&nn/lib/metro/g/uiplugins/tooltip_service_0.1.56.js&nn/lib/metro/g/uiplugins/autohide_service_0.1.15.js\\\"]);\\u000a\\u003C/script\\u003E\\u000a\\u000a\\u003Cscript type=\\\"text/javascript\\\"\\u003E\\u000aYUI.presentation.lazyScriptList = YUI.presentation.lazyScriptList.concat([\\\"http://l.yimg.com/zz/combo?nn/lib/metro2/g/badge/badge_0.1.20.js&nn/lib/metro/g/stream/stream_0.0.456.js&nn/lib/metro/g/uiplugins/storage_service_0.0.1.js&nn/lib/metro/g/uiplugins/login_service_0.0.38.js&nn/lib/metro/g/uiplugins/interests_service_0.1.1.js&nn/lib/metro/g/fstream/fstream_0.0.95.js&nn/lib/metro/g/login/login_0.0.32.js\\\"]);\\u000a\\u003C/script\\u003E\\u000a\\u000a\\u003Cscript type=\\\"text/javascript\\\"\\u003E\\u000a(function()\\u000a{\\u000a    YMedia.namespace('dali').config = {\\\"props\\\":{\\\"dali\\\":{\\\"crumb\\\":\\\"OBQpwrpfCly\\\",\\\"yuid\\\":\\\"\\\",\\\"loggedIn\\\":\\\"0\\\",\\\"mLogin\\\":0},\\\"proxyUrl\\\":\\\"\\\\/hjs?_mode=html&_create=1&_action=show&_type=badge&_container=1&_chrome=0&view=default&pInitLevel=lite&m_id=p_30345786&m_mode=multipart&configId=MediaRemoteIncludeExternalConfig&hide=0&mod_units=19&app=gs&content_id=5f01278b-803a-3803-9798-7fc79bab4f7d&juris=US&lang=en-US&pu=news.yahoo.com&region=US&se=4402687&site=news&mod_id=p_30345786&suid=30345786&pagetype=minihome&nolz=1&y_proc_embeds=1&y_map_urn=urn%3Armp%3Alite&_product_version=v2&r_inc=1&c_id=p_30345786_container&_sig=8nhtS_52JeXfdiYY25izjGGXZ2I-\\\"},\\\"data\\\":null,\\\"mods\\\":[{\\\"data\\\":{\\\"maple\\\":{\\\"platform\\\":{},\\\"module\\\":\\\"badge\\\",\\\"instance\\\":\\\"badge\\\",\\\"signature\\\":\\\"he5R2PEbnkHjPiFGhQuSNQ--\\\"},\\\"moduleId\\\":\\\"u_30345786\\\"},\\\"props\\\":{\\\"refHandler\\\":\\\"cfg.maple_dali.handler.refresh\\\",\\\"id\\\":\\\"badge\\\",\\\"ns\\\":\\\"badge\\\",\\\"trusted\\\":true},\\\"state\\\":{},\\\"strs\\\":{\\\"STR.MODULE.ERROR_FALLBACK_TEXT\\\":\\\"Requested module is not available. Please try again.\\\",\\\"STR.EDIT\\\":\\\"Settings\\\",\\\"STR.EDIT.CLOSE\\\":\\\"Close Settings\\\"},\\\"res\\\":{},\\\"mods\\\":[{\\\"data\\\":{\\\"maple\\\":{\\\"platform\\\":{},\\\"module\\\":\\\"u_30345786\\\",\\\"instance\\\":\\\"__mmh_0\\\",\\\"ba\\\":{\\\"_action\\\":\\\"show\\\",\\\"chrome\\\":\\\"1\\\",\\\"_id\\\":\\\"u_30345786\\\"},\\\"signature\\\":\\\"5nh6UiryEE9aP5zSGTFEXg--\\\"},\\\"woeId\\\":12778444,\\\"intl\\\":\\\"us\\\",\\\"socialEnabled\\\":true,\\\"swipeEnabled\\\":false,\\\"fbAcctLinked\\\":false,\\\"clientPagination\\\":true,\\\"dynamicEnabled\\\":true,\\\"removalMenuEnabled\\\":true,\\\"closeEnabled\\\":true,\\\"markAsReadEnabled\\\":true,\\\"tooltipsEnabled\\\":true,\\\"batchPause\\\":0,\\\"interestFiltersEnabled\\\":true,\\\"interestFiltersBroadcast\\\":true,\\\"minArticleCount\\\":6,\\\"broadcastDynamicEnabled\\\":true,\\\"sortBy\\\":0,\\\"shareDrawerEnabled\\\":false,\\\"saveEnabled\\\":false,\\\"scrollBuffer\\\":900,\\\"writeMixerActions\\\":true,\\\"isRmp\\\":true,\\\"interestFiltersNavigate\\\":true,\\\"itemClickBroadcastOnly\\\":true,\\\"itemClickContext\\\":true,\\\"restoreStateExpire\\\":1800000,\\\"restoreStateMethod\\\":\\\"LOCAL_STORAGE\\\",\\\"restoreStateOnCacheMiss\\\":true,\\\"batchSize\\\":20,\\\"locationPickerEnabled\\\":false,\\\"beacon_sec\\\":\\\"app-loc\\\",\\\"beacon_slk\\\":\\\"s-op\\\",\\\"beacon_bucketid\\\":\\\"900\\\",\\\"dynamicCategories\\\":[{\\\"name\\\":\\\"Politics\\\",\\\"id\\\":\\\"YCT:001000661\\\",\\\"points\\\":158.92,\\\"src\\\":\\\"core\\\",\\\"count\\\":59,\\\"occurances\\\":{\\\"1\\\":6,\\\"2\\\":2,\\\"3\\\":4,\\\"4\\\":6,\\\"5\\\":7,\\\"6\\\":8,\\\"7\\\":8,\\\"8\\\":13,\\\"9\\\":5},\\\"url\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/politics-and-government\\\\/\\\"},{\\\"name\\\":\\\"Society\\\",\\\"id\\\":\\\"YCT:001000780\\\",\\\"points\\\":103.8,\\\"src\\\":\\\"core\\\",\\\"count\\\":36,\\\"occurances\\\":{\\\"1\\\":2,\\\"2\\\":6,\\\"3\\\":3,\\\"4\\\":4,\\\"5\\\":8,\\\"6\\\":3,\\\"7\\\":4,\\\"8\\\":3,\\\"9\\\":3},\\\"url\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/society-and-culture\\\\/\\\"},{\\\"name\\\":\\\"Crime & Justice\\\",\\\"id\\\":\\\"YCT:001000667\\\",\\\"points\\\":34.83,\\\"src\\\":\\\"core\\\",\\\"count\\\":14,\\\"occurances\\\":{\\\"1\\\":1,\\\"2\\\":1,\\\"4\\\":1,\\\"5\\\":2,\\\"6\\\":4,\\\"7\\\":3,\\\"8\\\":1,\\\"9\\\":1},\\\"url\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/crime-and-justice\\\\/\\\"},{\\\"name\\\":\\\"Education\\\",\\\"id\\\":\\\"YCT:001000267\\\",\\\"points\\\":29.77,\\\"src\\\":\\\"core\\\",\\\"count\\\":8,\\\"occurances\\\":{\\\"1\\\":1,\\\"2\\\":1,\\\"3\\\":2,\\\"4\\\":2,\\\"5\\\":1,\\\"9\\\":1},\\\"url\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/education\\\\/\\\"},{\\\"name\\\":\\\"Health\\\",\\\"id\\\":\\\"YCT:001000395\\\",\\\"points\\\":26.66,\\\"src\\\":\\\"core\\\",\\\"count\\\":6,\\\"occurances\\\":{\\\"1\\\":1,\\\"2\\\":1,\\\"3\\\":2,\\\"4\\\":2},\\\"url\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/health\\\\/\\\"}],\\\"dynamicEntities\\\":[{\\\"name\\\":\\\"Barack Obama\\\",\\\"id\\\":\\\"WIKIID:Barack_Obama\\\",\\\"points\\\":293,\\\"src\\\":\\\"core\\\",\\\"count\\\":293,\\\"occurances\\\":{\\\"1\\\":2},\\\"url\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/barack-obama\\\\/\\\",\\\"uuid\\\":\\\"c200730b-eb18-376d-a3d3-1892197b9f54\\\"},{\\\"name\\\":\\\"Egypt\\\",\\\"id\\\":\\\"WIKIID:Egypt\\\",\\\"points\\\":188,\\\"src\\\":\\\"core\\\",\\\"count\\\":188,\\\"occurances\\\":{\\\"1\\\":1},\\\"url\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/egypt\\\\/\\\",\\\"uuid\\\":\\\"c200730b-eb18-376d-a3d3-1892197b9f54\\\"},{\\\"name\\\":\\\"United States\\\",\\\"id\\\":\\\"WIKIID:United_States\\\",\\\"points\\\":136,\\\"src\\\":\\\"core\\\",\\\"count\\\":136,\\\"occurances\\\":{\\\"1\\\":1},\\\"url\\\":\\\"http:\\\\/\\\\/www.yahoo.com\\\\/topic\\\\/united-states\\\\/\\\",\\\"uuid\\\":\\\"c200730b-eb18-376d-a3d3-1892197b9f54\\\"},{\\\"name\\\":\\\"White House\\\",\\\"id\\\":\\\"WIKIID:White_House\\\",\\\"points\\\":128,\\\"src\\\":\\\"core\\\",\\\"count\\\":128,\\\"occurances\\\":{\\\"1\\\":2},\\\"url\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/white-house-2\\\\/\\\",\\\"uuid\\\":\\\"590c8c6f-61a8-3dea-9ba7-8cb83525a33b\\\"},{\\\"name\\\":\\\"Shooting of Trayvon Martin\\\",\\\"id\\\":\\\"WIKIID:Shooting_of_Trayvon_Martin\\\",\\\"points\\\":120,\\\"src\\\":\\\"core\\\",\\\"count\\\":120,\\\"occurances\\\":{\\\"1\\\":1},\\\"url\\\":\\\"http:\\\\/\\\\/www.yahoo.com\\\\/topic\\\\/shooting-of-trayvon-martin\\\\/\\\",\\\"uuid\\\":\\\"a2b156e2-bdc5-3dab-bf3c-241d681ef099\\\"}],\\\"items\\\":[{\\\"u\\\":\\\"41b84caa-3b4d-32c7-9ee7-e45c21fc0fb6\\\",\\\"i\\\":\\\"4089900430\\\"},{\\\"u\\\":\\\"6f4ca8cf-c412-35d3-853f-9ee636b92373\\\",\\\"i\\\":\\\"4100000384\\\"},{\\\"u\\\":\\\"62787508-255a-3395-82ba-9e62e75cb0f0\\\",\\\"i\\\":\\\"4100000435\\\"},{\\\"u\\\":\\\"8cc97ab2-66d0-3bbb-8b6f-c20ba8d932c4\\\",\\\"i\\\":\\\"4059000616\\\"},{\\\"u\\\":\\\"8682b543-884b-33da-a257-f0d05e1a3dfa\\\",\\\"i\\\":\\\"4090000408\\\"},{\\\"u\\\":21370595,\\\"s\\\":\\\"If you have a $500,000 portfolio, download the &quot;15-Minute Retirement Plan&quot; by Forbes columnist Ken Fisher's Firm.\\\",\\\"im\\\":{\\\"original\\\":{\\\"url\\\":\\\"http:\\\\/\\\\/l2.yimg.com\\\\/av\\\\/moneyball\\\\/ads\\\\/0-1371163702-9044.jpg\\\",\\\"width\\\":82,\\\"height\\\":61,\\\"orientation\\\":\\\"landscape\\\",\\\"ratio\\\":1.344262295082}},\\\"ur\\\":\\\"http:\\\\/\\\\/ad.yieldmanager.com\\\\/clk?3,eJytjcsKgzAURH.IRTSmRkIX0ahoNbaQUrK0xqS-doLUr2-1rx.ogbkwzHDHhsRpkAYuwKCutHYVJjbUtd8ArZRnAUKI4.k75CHsY4uuHPF0mlkX9zLYfAaFmOkL81RgwndvvRGDh6p6x-k1GOlfCP2Mpp-v265hmCK9mLvAwbeWSLdw-FAs6pZfzqhM5FSIeChau-WdanMRzbyjQI7xWDLe89.A3rLAA6jKT6A=,http%3A%2F%2Fclk.atdmt.com%2FINV%2Fgo%2F451647339%2Fdirect%2F01%2F\\\",\\\"t\\\":\\\"4 Ways to Avoid Running Out of Money in Retirement\\\",\\\"b\\\":\\\"http:\\\\/\\\\/ad.yieldmanager.com\\\\/csc?ve=2&nnedaxJ2wp1pT4ZwGV4gDhYeBEElHwTeHaR66EZPtofFZiP.h3qhAh8D1AlHKzUtktlm12a7lhoaiOxNXb7GPmZy2_VWgTyZzw0xt4aw4mb0_3.5Xu8vcd6SGbF585AHOSTh4pCkdgD7vLoQQ_grHIGl_iCGeDDWb14hcb1OcM5DXq6CLJ8j7K81RZcK.4yJhLz3zTE1OEy3XTYzeA.2TDpLgb68IWRkxY7AKma09CzCbzc.eaNXMGJoCuEvmx.MWug_0mFZ2f_u8khz6Vef0VU7KHYGF93fjHs7c6fZsPAJOZAMZvjtnMZNZYIVTOPWzVD_xB6q_.rHZxX4vheZSNgDhvWuIrcJsu4O_Ur7fWcsyu09Pf_uhSyvwSynUHOxqqPrFqkwcZvRM3_flzSXlWitUznMKGHbIfqWSdmWpSdWEQlil66ZxJP3_XhC4tN8TLfOBNqHvhFwXOOazr0qTmVo.EnXCKZGYCkIeRcy.lhko303jyby1lOyMDrWvmUbqZzZxJJaurUZu1SvfrJ0zJ6oSxA9G33en7QsXtfKP4hqiyob.bOI6KX561sUNSq3A5z8Q61yK.AVSqnZnuMd0ImeL2AT2RO6TVzpXNOyx.4wuiwwcYzchdGVTj_YQkypq1C_7s3lVrWL4zUcCR_AL570O6DuX2g2lEZkb8XpWmk9qpNT1DxIm.nBD1DSV1ZwyKXeaOTVSu8gVVGyHjBi.6akODrY1IoHbGLXWFhY9vV68jSdu5bEZyBI0GCcC5OjwxVahDzX0ruhzsA8QRyFm528h0Zl07chJwDPYi_PkAyGXLLhJqg3oElWSLC87g1Uzw--&ap=29\\\",\\\"ia\\\":1,\\\"at\\\":\\\"Fisher Investments\\\"},{\\\"u\\\":\\\"acfa2983-d731-3cbc-a0fc-2ff8ef78e075\\\",\\\"i\\\":\\\"4100001372\\\"},{\\\"u\\\":\\\"1733412d-c645-3dcc-898f-a3e6b23632c3\\\",\\\"i\\\":\\\"4090000563\\\"},{\\\"u\\\":\\\"fa2d95f2-4e85-3cfa-aee0-d5b0c031529f\\\",\\\"i\\\":\\\"4100000730\\\"},{\\\"u\\\":\\\"523fedde-cc12-38fb-86ca-60629888845c\\\",\\\"i\\\":\\\"4090001194\\\"},{\\\"u\\\":\\\"e8fcb3d3-00f3-3804-b31c-d387f5b7c8e2\\\",\\\"i\\\":\\\"4053100529\\\"},{\\\"u\\\":\\\"d344ace7-22fe-3cab-b829-5c23eb17e754\\\",\\\"i\\\":\\\"4090001080\\\"},{\\\"u\\\":\\\"1099eb81-1582-311e-b36e-9a15c7f141e0\\\",\\\"i\\\":\\\"4053100516\\\"},{\\\"u\\\":\\\"0827042a-7b69-3744-876a-e63bbaf67e6d\\\",\\\"i\\\":\\\"4100000368\\\"},{\\\"u\\\":\\\"61d9ae23-9b3a-343a-9309-6e2f3cf1dc01\\\",\\\"i\\\":\\\"4100000293\\\"},{\\\"u\\\":\\\"6e2cca72-5335-3ef9-8ebb-e93683d1ee71\\\",\\\"i\\\":\\\"4100000273\\\"},{\\\"u\\\":\\\"f87eaebd-5628-3ec6-b863-c404b0abcee4\\\",\\\"i\\\":\\\"4100001060\\\"},{\\\"u\\\":\\\"34c6686d-577e-34a0-bb2b-887d9b40d3f5\\\",\\\"i\\\":\\\"4100000353\\\"},{\\\"u\\\":20637846,\\\"s\\\":\\\"Find Out Which Vehicles Get The Best Gas Mileage. See Our Top 10 Results for Cars, Trucks, and SUVs.\\\",\\\"im\\\":{\\\"original\\\":{\\\"url\\\":\\\"http:\\\\/\\\\/l3.yimg.com\\\\/av\\\\/moneyball\\\\/cleansed\\\\/282855.jpg\\\",\\\"width\\\":82,\\\"height\\\":82,\\\"orientation\\\":\\\"square\\\",\\\"ratio\\\":1}},\\\"ur\\\":\\\"http:\\\\/\\\\/ad.yieldmanager.com\\\\/clk?3,eJytjdsKgkAYhF.IYD2srixd7EHF0DVhS7wM1zVN6caQevryQL1AH8zPDP.AmDa2aqiBAxCoLlo7CmHT1pVfA62UZwCMseX5LvQg8pFBZo5ozCdWuPxOl8ycq5zISvMRbdjWm2.AYfYg-fqWO9qTv8D8A4k3Hy-7DUcE6lfzlIh-a1HppJYYhDz3SXGCWVSOqQz7tDVb0akukcEkOgLKIRwyLm7iN7A3DPAGZfRPKw==,http%3A%2F%2Fwww.autobytel.com%2Ftop-10-cars%2Fbest-gas-mileage-cars%2F%3Fid%3D32929\\\",\\\"t\\\":\\\"Top 10 Best Gas Mileage Vehicles\\\",\\\"b\\\":\\\"http:\\\\/\\\\/ad.yieldmanager.com\\\\/csc?ve=2&qzsmLzV2wp2K9aGINWH7y9M8hgZ7miUHN7UiJS.BY5zkRMidN64B35nlkb.wLdLD1BL8KTn.mdRIy2FfIjyaFwOY3ZZsLej2OkhrchS.GulCXbbNSRlTn8LYQ867ug57Kg9vOarUWPjiU76cVavCRaAHVCD4kfxlODDJd.NLgmJSTE3C750JidXG5vDJA0cC4cHgavWFdkyWzRpiigqOxrDdScG6y110r6o_wo7iuP7aTI9BIrGAHlo5K_Dhayx4JBbASvrHdzV6jIp1zh_UhvGhD_ZrTpqDnEFQtlQym.V0AnPiDlp0Gmd4zIHu3.164Ep_kCb50kB9X7XLREzU0t7LxvF2QFSCpgCpPL9f29E69w_MsWjQgTRhrEm3wVHmrrgCeo_ifbyT0w9aK7.qxAtqgPRO.zhAjl2e2jAZuH9q0TiFH9ubIsF04v2Y32JnuSlZYL04WeW3rBsSg3.0cFOpVFGaTk557Z7OAq.JFCmPLfEBAqMReZYFOqFy7jv2JQS6O6KYqB3dBU6V..xtZCH8XBqj84_P2zbtS9PbTgQF44xj8TF.LNIzpGyhHW5XsOjvSfhN6.LbKXz26cDHIayxx_ahuak5Wgn6qVO2WbiJNLJ69lZULHZQt4FgJLIL5mHTQjZ1cLBNGQDVKEPtLzkd6Zvwj5xzEC.3HSblPSjtgnU1jbGWWypqbXJzQJLHOXtVy_gXDYiTqouO2bCuv69hYPY.hli.BYjuaWJiQ8CQVYcg6K1xZTJbFNC_.Bdk14dKMrVziemcYyiChWT7QoMkSJ0.Cw5H0HugXp12a.gGzq3_36IMzz3SP1DHlAWN5g--&ap=42\\\",\\\"ia\\\":1,\\\"at\\\":\\\"Autobytel\\\"},{\\\"u\\\":\\\"db5de020-1c28-3992-8b33-7759daa5e05e\\\",\\\"i\\\":\\\"4100000928\\\"},{\\\"u\\\":\\\"0af9f27d-adfd-3b40-bdd2-8ff1b8643742\\\",\\\"i\\\":\\\"4047800699\\\"},{\\\"u\\\":\\\"5c9e6d6a-5127-3f87-b77f-6580cd62dfe4\\\",\\\"i\\\":\\\"4100000932\\\"},{\\\"u\\\":\\\"b1f76e13-0b85-3d35-ab05-1b263f119f5a\\\",\\\"i\\\":\\\"4100000883\\\"},{\\\"u\\\":\\\"cfa94c8c-28be-3510-b57a-00b7c3588ab9\\\",\\\"i\\\":\\\"4100000241\\\"},{\\\"u\\\":\\\"e4d5a136-97d8-3124-8ac6-7c020235428f\\\",\\\"i\\\":\\\"4100000269\\\"},{\\\"u\\\":\\\"24e6df26-628f-3a4c-9b98-b22275506fb9\\\",\\\"i\\\":\\\"4081001304\\\"},{\\\"u\\\":\\\"ed5c998c-1e32-3302-9d47-7f3957a1fc2f\\\",\\\"i\\\":\\\"4043000567\\\"},{\\\"u\\\":\\\"b1151a83-318e-34e2-a2c8-0fe169c1f900\\\",\\\"i\\\":\\\"4090000230\\\"},{\\\"u\\\":\\\"bfab8f88-77cf-3ace-b86a-80a4f5d25e89\\\",\\\"i\\\":\\\"4100000483\\\"},{\\\"u\\\":\\\"b4fd501c-2f37-3258-ae09-c23c728290ba\\\",\\\"i\\\":\\\"4059000932\\\"},{\\\"u\\\":\\\"73beeae0-a4b3-384b-bf19-be60c1176c1b\\\",\\\"i\\\":\\\"4065600270\\\"},{\\\"u\\\":20626440,\\\"s\\\":\\\"Netflix members can watch as much as they want, anytime, anywhere, on nearly any Internet-connected screen. Only $7.99\\\\/mo. Sign up today.\\\",\\\"im\\\":{\\\"original\\\":{\\\"url\\\":\\\"http:\\\\/\\\\/l1.yimg.com\\\\/av\\\\/moneyball\\\\/curated\\\\/202834-1366845045.jpg\\\",\\\"width\\\":82,\\\"height\\\":82,\\\"orientation\\\":\\\"square\\\",\\\"ratio\\\":1}},\\\"ur\\\":\\\"http:\\\\/\\\\/ad.yieldmanager.com\\\\/clk?3,eJytjV0LgjAYhf-QF35NN0YX06kYOhMW4a0uh18VZA399aVG.YEeOC.n8B44hoWFU5WVWdYQCiAsUWLDqit01mshoKZjjE0XOcAFEEGNLBzgmCsSP-nVW3NkM67IhnzLk.6nt9yAguxB8u19ud968hd8tCfxx8frrqSQgHqWE4fetxYVdmrmis3dlJyOIIuKMeVhnzZGw1rRJTxQrCV6MYRDRlnHfgM7TdNfkp9Qvg==,https%3A%2F%2Fsignup.netflix.com%2F%3Fmqso%3D81003558\\\",\\\"t\\\":\\\"Netflix Revolutionizes Movie and TV Watching\\\",\\\"b\\\":\\\"http:\\\\/\\\\/ad.yieldmanager.com\\\\/csc?ve=2&zWkYpzB2wp0ba3Tgopas6BFRYuE4xz9CbQJTUryvjLap3MzIAsGdm_gAdsSi4z93s3hCwj650aQ170QekJvPpbppwZ0JQlC5fOkR61_rGpcjztv8z0HtNrvZjMmEWj1VSSLk2vDnoCXUHJ4d13JV.r__VupHevR2lkwV81UPZLe.tHC5E84PwiDWjvY609QZPmjXCpKQ6h0rVnxHz1.yDxGJgukh1euQqi26U.AySo.L8f2Ehl8c_xZgluYHv1pqyT15XtdXcj35OQIU8weeVJi5zKhEt2muH6F5yK31DuJXXbmWyl3W9aTH.adyE2tGbtEv3A9w4W0V_senGdwWhu.dnNVGjlRSBXV7Wi0E5jRqhWa1RGsOukRYf__w69u32m7G7E2zswa2UdyBnDNQsgsjfKVZxJHbxsftB2kR1Y11ZnkxdyUYdKbjLjQYLlgC4poPd_pBwTdFWFIC5jka1dyqEaJm6EiudqR6PXTt29IFSl9vSsqFIJYxCTrbSjkwt34_Ykk9KU.wnC427dYP2k_cMOXyhTno3DtpkxDanQFmFWIzDDyxj8mj00.4OKpGs2fDII1SVM7z73pwpkfsg8xdL271Xqtf8_lHvFTM9WA32T3oPX9GLID3PcnQWTSNujIEq7hXbjlr11CsoMXFs4GcVJQvN8JxfD.PRC21p0P4ESq18bkaSY6xr0EtRNAwrXfejiX8DKqkV4rS0hfPzPt7C.8m78gKKeh95scFQ0FDRTkNkFJq8aF4N5llgv2yKH.F8bUJXVbKptR_1.LttZe6D2uIotMhQlwrLSu.1PrMEcCJhBB.cGmP1J4aummTQQ--&ap=55\\\",\\\"ia\\\":1,\\\"at\\\":\\\"Netflix\\\"},{\\\"u\\\":\\\"5287b89f-b0f0-3dab-9197-aa22905eaf4b\\\",\\\"i\\\":\\\"4100000166\\\"},{\\\"u\\\":\\\"43b802f5-0558-39cc-9b76-348e3d40edc4\\\",\\\"i\\\":\\\"4100000175\\\"},{\\\"u\\\":\\\"c7c72404-4eb8-3ea3-86b5-2657571ab856\\\",\\\"i\\\":\\\"4100000427\\\"},{\\\"u\\\":\\\"4519c9a6-1a8f-3d9f-bcd3-dc88fec5bc77\\\",\\\"i\\\":\\\"4100001187\\\"},{\\\"u\\\":\\\"d712ff7a-7042-30b9-8867-19b51ecb96d2\\\",\\\"i\\\":\\\"4065600232\\\"},{\\\"u\\\":\\\"37b64b20-2ba3-31e1-9e02-418af076fcf5\\\",\\\"i\\\":\\\"4090000299\\\"},{\\\"u\\\":\\\"586a9615-991d-3faf-9c7d-e7ff8179d511\\\",\\\"i\\\":\\\"4100000367\\\"},{\\\"u\\\":\\\"51aceae4-c48c-3955-bc3d-deabf73b0d4c\\\",\\\"i\\\":\\\"4100001042\\\"},{\\\"u\\\":\\\"1725fbc9-413b-3fff-a0c5-60ec4702f7c2\\\",\\\"i\\\":\\\"4100000553\\\"},{\\\"u\\\":\\\"0d92f3cd-9815-312a-abc3-79c0fa565d00\\\",\\\"i\\\":\\\"4090000263\\\"},{\\\"u\\\":\\\"fcb60a92-a1a0-35d5-abcf-08f9f9117095\\\",\\\"i\\\":\\\"4020500659\\\"},{\\\"u\\\":\\\"c2ecaa77-69b8-38ea-9a81-866f52ad3b10\\\",\\\"i\\\":\\\"4072900590\\\"},{\\\"u\\\":21713975,\\\"s\\\":\\\"Find out how this unexpected joint solution is helping Americans live happier, healthier lives after 50!\\\",\\\"im\\\":{\\\"original\\\":{\\\"url\\\":\\\"http:\\\\/\\\\/l5.yimg.com\\\\/av\\\\/moneyball\\\\/ads\\\\/216216-1372864886-2128.jpg\\\",\\\"width\\\":82,\\\"height\\\":61,\\\"orientation\\\":\\\"landscape\\\",\\\"ratio\\\":1.344262295082}},\\\"ur\\\":\\\"http:\\\\/\\\\/ad.yieldmanager.com\\\\/clk?3,eJytjcsOgjAURH-IRaEW2jQuylMMtJKApluoJSAkJkJQv97wiP6AZzF3JneSMSFVdlVWVqkxVkhBVVIT6opcgVYKG4BSajnERg7CBBts5oSHbGLwHDzcJR.kWNRsZb5u7W29WQMfiZFl65ub6s7-gkeOLN58vOzWPmZIv-tXjt1vLZK71MqeIs9AcimQiOSQ5mGXNmbDW9UleTDxlgHZh73w-Y3.BvaGAT430E.b,http%3A%2F%2Fwww.instaflex.com%2Freport%2Farticles.php%3Ft202id%3D512118%26t202kw%3Dysa_i_7\\\",\\\"t\\\":\\\"8 Simple Joint Ingredients You Won't Believe\\\",\\\"b\\\":\\\"http:\\\\/\\\\/ad.yieldmanager.com\\\\/csc?ve=2&z5Q9IuZ2wp3bd2eG4xH9XWB4PhaW4myay4VzgY1UCeysWm4Sz3hkoRJZIxIVjvpt8.qZvkNg2VEzum.2ZV12VCpiybciLb_X6dhagEMF0YC4nWuvwZuJgvGmDEeN26B6Wuzob2wuJ3F_hXsTuPQVqBfbAb_oEG_Uyj1fJ20USxiKtqoeQ8RwdAmln_wPcjhlLo_sSFXNsj2KFFQYJxp49uHTIVfq81.mrUbHISr52A6uaYmhzcbGmAPZtkOXk6wTaHW1CAStKVb15S3d7an4BGxU8XpC.giGc4hxdHkFpTinG40ecJE2pM6VKR7vwoiVR5OEVv.6IH5rWfUga1V8.B7PWV7_975IVprtXE.glE.0xh0poAHLQXk44h0FY7I0NGnF293lajgLM6hcTcBrAwmHKHbNoO83DkMs8I2FH7qGcfms2eDI41w2ukCykrt8vNGdrdd0MU8OFdbQ2PpiqGskzIFQ9SJeULwqMJwJR2P7RXMKEJFlkihu693VR58Agi.ERg6hXn5xkdJOgFo0kIdbnTRcrK5_Fe.xeevUaNfpP6wKVJKA9iPj.S7Mqv6HJHkUIETeAWtor7mGfsYLXWzb2m.Ir8303EvFvnVlgg8Ro7xUcplwEuumMpOPqwOHA0k7NvjxvzbH_EW6_pJ8maGmPD_uAynDXpt3CnlDa7o0Nl0iOBOr_9kDgkWVyJKswytJDOCGo.bt3UPLgHKmObQMyOh94jg8R_FWsO54ZvJ6UWm4g3_0MvWvFgIM9mG83KcLeS3LywLWKEinSsY.GjCTqlpHlwJCl8bwU_yl3JsC2v71boE77slOwVsfJ_WhfQ--&ap=68\\\",\\\"ia\\\":1,\\\"at\\\":\\\"Instaflex\\\"},{\\\"u\\\":\\\"1be2994f-2025-3f60-a257-3e7a48049747\\\",\\\"i\\\":\\\"4081000572\\\"},{\\\"u\\\":\\\"de1a9017-c4fa-375a-ba6c-f3ffea663e3d\\\",\\\"i\\\":\\\"4072900197\\\"},{\\\"u\\\":\\\"9cf878bf-6b71-312f-aae4-95d81bab2441\\\",\\\"i\\\":\\\"4100001024\\\"},{\\\"u\\\":\\\"7c28287a-cd26-3ecf-a193-d1775345c1b9\\\",\\\"i\\\":\\\"4081000424\\\"},{\\\"u\\\":\\\"fad57397-28be-3323-9ee7-d379519b57b8\\\",\\\"i\\\":\\\"4090000132\\\"},{\\\"u\\\":\\\"a39d803c-107e-3210-91b9-404f0f9f688c\\\",\\\"i\\\":\\\"4065600702\\\"},{\\\"u\\\":\\\"fccf2bde-bbc9-3aef-880e-ce36cae7f85a\\\",\\\"i\\\":\\\"4100001033\\\"},{\\\"u\\\":\\\"b4302a7d-ee75-3d80-855f-de2dee077577\\\",\\\"i\\\":\\\"4072900375\\\"},{\\\"u\\\":\\\"9bf503a7-4f45-3294-9446-d57ed3fa0f76\\\",\\\"i\\\":\\\"4034800382\\\"},{\\\"u\\\":\\\"87c2b200-aa22-3ecf-99d6-72a7c6012b2d\\\",\\\"i\\\":\\\"4038700255\\\"},{\\\"u\\\":\\\"4ed583ae-67ff-3853-aaf1-86901581ce2d\\\",\\\"i\\\":\\\"4059000197\\\"},{\\\"u\\\":\\\"47b95c91-2def-3d3c-9b80-9fd816c94043\\\",\\\"i\\\":\\\"4100001213\\\"},{\\\"u\\\":20950156,\\\"s\\\":\\\"Local auto dealers have begun cutting their prices for the summer.  If you're looking for a new car this season, buy now and save as much as ...\\\",\\\"im\\\":{\\\"original\\\":{\\\"url\\\":\\\"http:\\\\/\\\\/l2.yimg.com\\\\/av\\\\/moneyball\\\\/ads\\\\/206635-1369234902-9746.jpg\\\",\\\"width\\\":82,\\\"height\\\":80,\\\"orientation\\\":\\\"landscape\\\",\\\"ratio\\\":1.025}},\\\"ur\\\":\\\"http:\\\\/\\\\/ad.yieldmanager.com\\\\/clk?3,eJytjl8LgjAUxb-QD9M53Rg9zL9ZOhOM2KO6Zlq-hDDs05c26Av0g3M5h3vhXBtS6XVt57QKY4kklC21oerIFSgpsQUopY5PPOQjTLDFVk54rnRYPCMcbHl.I7VmX.qPgj40d-uMI3hsGrPWAE3sL4TkwDLjs623jzBD6tUvtflrJRVu4VSLGDM3v5xRmYq5qJNHMdgDH-WU17HmIwNiSqYy4nf-K9hZFngDFB1Pww==,http%3A%2F%2Fpixel.autoaffiliatenetwork.com%2Fd%2F%3Fid%3D009%26adtargeting%3Dimage_Chrysler300_text_Summer2013%26dest%3DAPF\\\",\\\"t\\\":\\\"Auto Dealers Cut Prices for Summer 2013\\\",\\\"b\\\":\\\"http:\\\\/\\\\/ad.yieldmanager.com\\\\/csc?ve=2&wgk9rVF2wp3mSOqz_lLU1uYrg_eo62EPleF_B4Y8TfVRrLgxq2OucRooPK62BnKioNxCjco237tZGFe1LIRJOTt9Np0xZ6blWoAH3.gFIKMQgCz.GAk1kZvM1CZc.VrDtfOtauBmrchheiP9KEIBJhe1gmBsXrQqATXH4UPmmj8G4YSAs.ivPwBlIWTio6m6evw9Zn7B41C952pphaMA1cPMzLK2ofaUn_tcYex0pIFJtZOEvOwAM8pEhV92nVqtfnoJNoM8T68_.D0toqJJ9x.Wiu_oVFXOWCkZ4uJwLKrMfLlvXZ4wd95GW1bIKm__CwtKWQ9qfqF3Vy.9tJtMTx4iBrl1R3LnyqBCV3PNWTtXib1iNxNhWUg2vRYbiqXaBM.HYQyAHUXtc17nnjYpDJDizo3J6osrvk3dA5eDKw2ypj_P_LyaJHVeFaaAwubd0r.OZ1oGq_3b3AmAAjvdbDyihyjFEM7RxwCjW43EA6nbJFz868ZbDdMMUhGFV8kMySkUvAqaT8hAO3et8D1c8ZqPHuML3C_DfbHiC7EdlXQWhlGHbt40bN7fEo0skMKVeLYOLE5xmCYk5avdkwaHbYai8lO3m1lgv1UiTvgK5IGpipNi0LV5Jgo52I6sZ7GMMwbHIf5cqE0_Ss9MKpdU_UPDRLfQpLu87NBYUY1Qbxkb7Z9XiYUv8uEG583rZKxhVLCDdECG6q4BjgnBZwdf9KXTUyHiT.jwzyYt_f0yIHSpGACJIowkyI5MQONoaoxN05fx4TxXI761SEAGPd4LfRQ7uBQwYzjknlwGdvR6ZmlepElIPowTpbio673OH.SG_w--&ap=81\\\",\\\"ia\\\":1,\\\"at\\\":\\\"Auto-Price-Finder.com\\\"},{\\\"u\\\":\\\"3a34e541-0403-3e59-b0d0-f0fb28666525\\\",\\\"i\\\":\\\"4025400410\\\"},{\\\"u\\\":\\\"8f518ad0-4b6e-34f0-97b0-81fcf08ebaea\\\",\\\"i\\\":\\\"4053100205\\\"},{\\\"u\\\":\\\"e4bb5d47-7633-3c34-83d5-0612bbb1da97\\\",\\\"i\\\":\\\"4034800337\\\"},{\\\"u\\\":\\\"dacd78e7-9feb-3a5b-93da-4671482229b2\\\",\\\"i\\\":\\\"4034800248\\\"},{\\\"u\\\":\\\"e771ab9e-bef4-36f0-a1f6-745e13c58aa4\\\",\\\"i\\\":\\\"4053100169\\\"},{\\\"u\\\":\\\"4832980c-2037-3392-b43e-846739d2a79e\\\",\\\"i\\\":\\\"4100001064\\\"},{\\\"u\\\":\\\"b4bebef1-c728-3d5b-9f21-cee351d0c35a\\\",\\\"i\\\":\\\"4031300420\\\"},{\\\"u\\\":\\\"365f8ec3-3449-3292-bedd-b8525ea07a98\\\",\\\"i\\\":\\\"4053100421\\\"},{\\\"u\\\":\\\"81e651ea-58d5-34ac-8d57-fb424d7b24a0\\\",\\\"i\\\":\\\"4020500310\\\"},{\\\"u\\\":\\\"ade7515b-f561-356b-810d-457e63632c09\\\",\\\"i\\\":\\\"4100000961\\\"},{\\\"u\\\":\\\"7ac0b3f5-9a41-3595-85e7-b394b8f49b28\\\",\\\"i\\\":\\\"4031300207\\\"},{\\\"u\\\":\\\"840f9c6d-87ba-3b2d-aa1a-3c3c4b7a5a4c\\\",\\\"i\\\":\\\"4022800272\\\"},{\\\"u\\\":20802476,\\\"s\\\":\\\"A recently published study shows no long-term benefit from traditional glucosamine joint supplements. See the study results to learn more.\\\",\\\"im\\\":{\\\"original\\\":{\\\"url\\\":\\\"http:\\\\/\\\\/l3.yimg.com\\\\/av\\\\/moneyball\\\\/ads\\\\/0-1368480943-1495.jpg\\\",\\\"width\\\":50,\\\"height\\\":75,\\\"orientation\\\":\\\"portrait\\\",\\\"ratio\\\":0.66666666666667}},\\\"ur\\\":\\\"http:\\\\/\\\\/ad.yieldmanager.com\\\\/clk?3,eJytjcsOgjAURH-IRXmVNo2L8gwIxRqI6ZKAraC4kUjk6xXS6A94krmZyZ1kTJsAD0IbOtJB0jJl1xLTli0-A9l12ACEEMvD0PVchJFBVw5o4nPwaBbgbznjz5pq1Ee-CnRvvVFo75tGv.nxcqd.IcAZTbVPt10VIurKRb0q5H9riXAKiy.Cyob8VLtlIqaiim9Fb.ZsUHNeRTMbKBBjPJYhu7LfwM4wwBtnLk9N,http%3A%2F%2Fwww.naturaljoint.org\\\",\\\"t\\\":\\\"Studies Show No Long-Term Benefit From Glucosamine\\\",\\\"b\\\":\\\"http:\\\\/\\\\/ad.yieldmanager.com\\\\/csc?ve=2&ZQjKS5t2wp3tdUaHBIGodCYuG_f3c5Q4RHqRNOmFAIMu41CRpQIRRuAAZhRoQCp5qJKzdMRuKPM32HsWqTY84M2.gIvMeyqpFp.vbvxAwvHnDikl1xhO3T5SmF3n7_1uXWU.4F5umCyNbqAcCSf4n9qnGYNOxMSL_.KmxOc.3liYZsT_.CUaPGJ.cy4o_yTOMOXpIXVik6NPLnIGSjGNkCpatrycqxM2aZ7mTp.lyI0E8GbTfGd1QSEooEp2eEFenA8mlljk2vlxuFzN4mrivDaUVzu6X9BDgVFi21ZsDPWnGhTkBD8c2rb4yTPIwqKUBWdm6GNRabofrfmgc2zV4tnU9WpW13xA7DTsCIwTzynBadCXAq9W_vevF4rpXCgr4f0mSltZ6F_wCi.S0l29bYmKwY3vBoOWjw502JfwyHh9VSVJz.Gj.kEkeUYhCqMYDGy5dnY0B4my.n6Xv5GrxXYJpItSEU.6v_ELmSGOTvGBH.7T7ubN51tyKu2GnbYuvvTHcCy12rZ5K6F4UFiehMvRIse9ZqtRorK6PpgJ04.9KJEtxwkrjXrNEUnSGkBtO_pH4MxMlHMQBs1_8BfE1_3dwmgEkgnAbFywwYiH9eythSiYeuypC0hsSF1T37y1La2n_W6zqab560xTMLB8KDXxgxYhkykOhrrsGlutOqYFEUt_VjYxZ8MNiu6RDbJhUrTZs55XTY0qs4_Wu5BjhbyOB5QiuXFfXtR.AFpVXkfhYRZmebXzZeUKeafnJQYvAxAYVEK_KjbkdxzEBOgptMZuEqSn2UJl2PRqDhFu.qlbE7nElmRpvh6Zz9ulSbNjvw--&ap=94\\\",\\\"ia\\\":1,\\\"at\\\":\\\"Greek Island Labs\\\"},{\\\"u\\\":\\\"d443a8ca-9d9d-3adf-aaaf-00d01aee0747\\\",\\\"i\\\":\\\"4028200497\\\"},{\\\"u\\\":\\\"036f4818-5282-3896-a7c0-e03a87689ca5\\\",\\\"i\\\":\\\"4016600299\\\"},{\\\"u\\\":\\\"5405616f-5db9-3cf0-b76d-6c0ae86b8d0e\\\",\\\"i\\\":\\\"4015000774\\\"},{\\\"u\\\":\\\"8ffe28b2-6ff5-3f89-87b3-73f90aab3ce0\\\",\\\"i\\\":\\\"4020500222\\\"},{\\\"u\\\":\\\"77d99ad3-23b2-31a4-9d15-beda9147cf9e\\\",\\\"i\\\":\\\"4090001038\\\"},{\\\"u\\\":\\\"6721eeda-5e99-3b9e-85b2-ad4f1a29ffa3\\\",\\\"i\\\":\\\"4010000398\\\"},{\\\"u\\\":\\\"64a0f5e9-826f-30c1-b87a-cdd14e8f044b\\\",\\\"i\\\":\\\"4022800216\\\"},{\\\"u\\\":\\\"e8f5bb9e-a7fa-3ddc-a3ed-5984194e14d1\\\",\\\"i\\\":\\\"4018500417\\\"},{\\\"u\\\":\\\"4398511d-e0b9-3bcc-b8d7-8c927257da97\\\",\\\"i\\\":\\\"4020500168\\\"},{\\\"u\\\":\\\"0224f7db-6b78-37eb-bb13-96c734c79645\\\",\\\"i\\\":\\\"4100001084\\\"},{\\\"u\\\":\\\"716a86c2-e772-3b80-ba2f-37ed8ecda763\\\",\\\"i\\\":\\\"4012100274\\\"},{\\\"u\\\":\\\"3b06a203-610c-3a58-8024-a51b661e896b\\\",\\\"i\\\":\\\"4100001004\\\"},{\\\"u\\\":\\\"af11785a-f5c8-3e8d-bf22-0a8d0203aa77\\\",\\\"i\\\":\\\"4012100286\\\"},{\\\"u\\\":\\\"fab07708-6eec-331c-a049-53f865291f9b\\\",\\\"i\\\":\\\"4012100261\\\"},{\\\"u\\\":\\\"55836cbc-0d5c-3fbe-b9bf-13bdbb891e66\\\",\\\"i\\\":\\\"4005302076\\\"},{\\\"u\\\":\\\"d8c76553-0434-33b6-b68c-a39e35bba1bb\\\",\\\"i\\\":\\\"4013500176\\\"},{\\\"u\\\":\\\"95cbd68e-ffcb-3da5-8dfd-436af201ec90\\\",\\\"i\\\":\\\"4009800349\\\"},{\\\"u\\\":\\\"e8528082-d943-35fc-af50-14e4c1f8180e\\\",\\\"i\\\":\\\"4010900162\\\"},{\\\"u\\\":\\\"45888b8f-3460-3aa1-9a52-2dfe51afff60\\\",\\\"i\\\":\\\"4100000940\\\"},{\\\"u\\\":\\\"3a8ef146-eaf8-30f1-ab7f-bab556ede552\\\",\\\"i\\\":\\\"4010000412\\\"},{\\\"u\\\":\\\"f0e4f3e4-7690-38c4-b0b0-ba27c7800fdc\\\",\\\"i\\\":\\\"4010000176\\\"},{\\\"u\\\":\\\"f784f21c-dea8-3214-a2bd-4448415496ff\\\",\\\"i\\\":\\\"4007900196\\\"},{\\\"u\\\":\\\"733bf5ee-6160-3040-82d5-1d2f42636f8b\\\",\\\"i\\\":\\\"4100000874\\\"},{\\\"u\\\":\\\"db5e4a50-d8ef-386f-b1e6-e25cdf7f287a\\\",\\\"i\\\":\\\"4009800156\\\"},{\\\"u\\\":\\\"90742b99-96f2-38a3-9ad1-f55b2620aaee\\\",\\\"i\\\":\\\"4010000159\\\"},{\\\"u\\\":\\\"2ad2eb07-5b9c-307c-b9ff-bcb3aa6bf5b8\\\",\\\"i\\\":\\\"4009000163\\\"},{\\\"u\\\":\\\"83795d21-e026-38af-b60b-62dc9facb361\\\",\\\"i\\\":\\\"4007100533\\\"},{\\\"u\\\":\\\"f8528bff-bebc-36e9-9e88-cc513c0787c6\\\",\\\"i\\\":\\\"4100000869\\\"},{\\\"u\\\":\\\"5dc7227d-d4a6-352f-8649-0db6aa60341d\\\",\\\"i\\\":\\\"4007100507\\\"},{\\\"u\\\":\\\"43e80a47-79ec-3809-ac98-1518389138c7\\\",\\\"i\\\":\\\"4005300268\\\"},{\\\"u\\\":\\\"2efae028-b5e0-39a5-980b-7c19ab0f0244\\\",\\\"i\\\":\\\"4007900187\\\"},{\\\"u\\\":\\\"9db1ef8a-a304-3fa9-9e1c-b465e737c544\\\",\\\"i\\\":\\\"4004700714\\\"},{\\\"u\\\":\\\"6c039a5e-146d-3da8-812c-fb6d65e19f76\\\",\\\"i\\\":\\\"4005800470\\\"},{\\\"u\\\":\\\"c2ab26f4-4d85-34de-9900-e8fb300fc296\\\",\\\"i\\\":\\\"4100000965\\\"},{\\\"u\\\":\\\"0bb3174a-3588-3c95-a547-6c0cb658a1c0\\\",\\\"i\\\":\\\"4007100521\\\"},{\\\"u\\\":\\\"b40c8d61-0cfc-365c-919f-dc77294f18e1\\\",\\\"i\\\":\\\"4004700201\\\"},{\\\"u\\\":\\\"929877e0-37bb-39dd-9bee-f9e8bbe00dc9\\\",\\\"i\\\":\\\"4006400154\\\"},{\\\"u\\\":\\\"8a47ca09-04b3-337f-b6ff-583211b66950\\\",\\\"i\\\":\\\"4004700159\\\"},{\\\"u\\\":\\\"a63cf34e-c218-3e8d-892b-0bbc6156f9d8\\\",\\\"i\\\":\\\"4100001054\\\"},{\\\"u\\\":\\\"973d19f5-0a84-333c-b992-8eeedd738f43\\\",\\\"i\\\":\\\"4005800130\\\"},{\\\"u\\\":\\\"4153a74c-4462-3ee0-bc00-dff34f2d850f\\\",\\\"i\\\":\\\"4005200351\\\"},{\\\"u\\\":\\\"7e9aea73-f2a9-3a22-bbf3-d6e29ae9fe19\\\",\\\"i\\\":\\\"4003800180\\\"},{\\\"u\\\":\\\"97231cf5-bb20-3ff0-802b-a452829f1fa8\\\",\\\"i\\\":\\\"4003400207\\\"},{\\\"u\\\":\\\"09c0d581-8f4f-3555-871e-31a0b18a7951\\\",\\\"i\\\":\\\"4100000916\\\"},{\\\"u\\\":\\\"3d28a848-ba81-36fe-9887-29f619d7ccf4\\\",\\\"i\\\":\\\"4001600320\\\"},{\\\"u\\\":\\\"1216abdc-0bc1-3b4c-b978-4c4d848a26bb\\\",\\\"i\\\":\\\"4002500171\\\"},{\\\"u\\\":\\\"45860a48-cd9e-3f22-b47b-d286f2110b6a\\\",\\\"i\\\":\\\"4000400834\\\"},{\\\"u\\\":\\\"502e5b36-45b9-3ee1-bfe1-648774619bcb\\\",\\\"i\\\":\\\"4002200280\\\"},{\\\"u\\\":\\\"5ba9c757-db40-3d11-bf39-ae7cc0a41761\\\",\\\"i\\\":\\\"4001100426\\\"},{\\\"u\\\":\\\"9e07f5b8-ae97-3c06-9843-1beaf8ff297e\\\",\\\"i\\\":\\\"4100000935\\\"},{\\\"u\\\":\\\"f540de91-027a-3001-8280-5af27c52c12c\\\",\\\"i\\\":\\\"4000300502\\\"},{\\\"u\\\":\\\"e2b6485f-3de9-3bba-85da-4ddb382a056f\\\",\\\"i\\\":\\\"4100001019\\\"},{\\\"u\\\":\\\"fe72c946-5768-3657-aaa1-d0c92ed812b4\\\",\\\"i\\\":\\\"4000200523\\\"},{\\\"u\\\":\\\"2f6fa4bf-7163-3097-962e-5dbd610c2c21\\\",\\\"i\\\":\\\"4000200360\\\"},{\\\"u\\\":\\\"1d1e6988-fd19-36ec-a633-a290e04d1bab\\\",\\\"i\\\":\\\"4000100441\\\"},{\\\"u\\\":\\\"24f5c185-57dc-37e7-8698-dd1838bda8a4\\\",\\\"i\\\":\\\"4000200732\\\"},{\\\"u\\\":\\\"7940011d-7d91-3045-a1aa-eeecfdd0450c\\\",\\\"i\\\":\\\"4000100312\\\"},{\\\"u\\\":\\\"12577891-fe2e-3bf6-8872-48283cc99542\\\",\\\"i\\\":\\\"4000100230\\\"},{\\\"u\\\":\\\"db030f8d-4a11-31e4-86e4-cb8f0f8aaf82\\\",\\\"i\\\":\\\"4100000891\\\"},{\\\"u\\\":\\\"3c1b56c7-a888-3532-8f69-823389ab58d7\\\",\\\"i\\\":\\\"4000100152\\\"},{\\\"u\\\":\\\"bd973d04-cffe-3617-bc91-64631e02e263\\\",\\\"i\\\":\\\"4000100304\\\"},{\\\"u\\\":\\\"8ca67350-b65a-3884-b411-df6018ebbf14\\\",\\\"i\\\":\\\"4100000837\\\"},{\\\"u\\\":\\\"e115e1c2-e6e7-34b5-8725-65647725e6f3\\\",\\\"i\\\":\\\"4000000218\\\"},{\\\"u\\\":\\\"3184a818-422d-31fa-b2ca-3fc25f1e8306\\\",\\\"i\\\":\\\"4000000320\\\"},{\\\"u\\\":\\\"9d0d8429-ce92-3d20-96df-8dcdc20a1185\\\",\\\"i\\\":\\\"4000000347\\\"},{\\\"u\\\":\\\"da3fd914-a729-3606-93ce-58d974416a92\\\",\\\"i\\\":\\\"4000000246\\\"},{\\\"u\\\":\\\"ebe271cf-d612-3d45-8886-03aeb92bb7cd\\\",\\\"i\\\":\\\"4000000362\\\"},{\\\"u\\\":\\\"2382e5e0-34c2-3019-9bc1-dd64411f42b6\\\",\\\"i\\\":\\\"4100000828\\\"},{\\\"u\\\":\\\"6ae66b10-fc06-31ad-bdce-f630dab5f4fc\\\",\\\"i\\\":\\\"4000000301\\\"},{\\\"u\\\":\\\"979f41be-1edc-32f5-ac09-17715c88e294\\\",\\\"i\\\":\\\"4000000282\\\"},{\\\"u\\\":\\\"d8ca681e-2bfb-3e08-b33f-0d41e9916217\\\",\\\"i\\\":\\\"4000000292\\\"},{\\\"u\\\":\\\"933524d2-947f-3f9c-aeae-a5a45b0619b8\\\",\\\"i\\\":\\\"4065601209\\\"},{\\\"u\\\":\\\"d9a55b19-9a27-3da5-b16b-c6f245fbc386\\\",\\\"i\\\":\\\"4000000131\\\"},{\\\"u\\\":\\\"9d198649-3883-3f02-a39f-33e7c6ac21f8\\\",\\\"i\\\":\\\"4000000155\\\"},{\\\"u\\\":\\\"4ec09f8e-84c3-3934-b092-39cb092d10a2\\\",\\\"i\\\":\\\"4000000510\\\"},{\\\"u\\\":\\\"89f6b64e-b044-3bcf-9af8-7a8e16cba9c4\\\",\\\"i\\\":\\\"4000000328\\\"},{\\\"u\\\":\\\"8a1c7605-0ff6-3150-9990-76dae34185d8\\\",\\\"i\\\":\\\"4000002190\\\"},{\\\"u\\\":\\\"408b827f-4639-3495-bbc5-33698c6a3bc7\\\",\\\"i\\\":\\\"4000000560\\\"},{\\\"u\\\":\\\"fcc8c90a-e9a3-3d4d-b0c6-80066b5a761a\\\",\\\"i\\\":\\\"4100001013\\\"},{\\\"u\\\":\\\"c96bd902-72ef-3422-a162-bb80c37028e1\\\",\\\"i\\\":\\\"4000000207\\\"},{\\\"u\\\":\\\"44f44e84-8894-3136-b6fc-efb8b7c77f84\\\",\\\"i\\\":\\\"4000000238\\\"},{\\\"u\\\":\\\"29b950b3-b185-31cd-97ed-21927a63fabc\\\",\\\"i\\\":\\\"4100000898\\\"},{\\\"u\\\":\\\"8cff3d5f-1313-3198-b0c2-c9582925c56c\\\",\\\"i\\\":\\\"4000000321\\\"},{\\\"u\\\":\\\"bcd13eef-3b76-3eb8-b13e-66e0a2432378\\\",\\\"flbk\\\":true},{\\\"u\\\":\\\"cf8c7775-d027-3207-af8c-86bffe8db6fe\\\",\\\"flbk\\\":true}],\\\"contentpos\\\":22,\\\"interestsData\\\":{\\\"YCT:001000667\\\":{\\\"name\\\":\\\"Crime & Justice\\\",\\\"count\\\":0,\\\"url\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/crime-and-justice\\\\/\\\",\\\"declared\\\":1},\\\"YCT:001000780\\\":{\\\"name\\\":\\\"Society\\\",\\\"count\\\":164,\\\"url\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/society-and-culture\\\\/\\\",\\\"declared\\\":1},\\\"WIKIID:Shooting_of_Trayvon_Martin\\\":{\\\"name\\\":\\\"Shooting of Trayvon Martin\\\",\\\"count\\\":120,\\\"url\\\":\\\"http:\\\\/\\\\/www.yahoo.com\\\\/topic\\\\/shooting-of-trayvon-martin\\\\/\\\",\\\"declared\\\":1},\\\"YCT:001000661\\\":{\\\"name\\\":\\\"Politics\\\",\\\"count\\\":161,\\\"url\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/politics-and-government\\\\/\\\",\\\"declared\\\":1},\\\"YCT:001000700\\\":{\\\"name\\\":\\\"Immigration Issues\\\",\\\"count\\\":0,\\\"url\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/immigration-issues\\\\/\\\",\\\"declared\\\":1},\\\"WIKIID:Culture_of_the_United_States\\\":{\\\"name\\\":\\\"Culture of the United States\\\",\\\"count\\\":1,\\\"url\\\":\\\"http:\\\\/\\\\/www.yahoo.com\\\\/topic\\\\/culture-of-the-united-states\\\\/\\\",\\\"declared\\\":1},\\\"YCT:001000346\\\":{\\\"name\\\":\\\"Personal Investing Ideas & Strategies\\\",\\\"count\\\":48,\\\"url\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/personal-investing-ideas-and-strategies\\\\/\\\",\\\"declared\\\":1},\\\"YCT:001000992\\\":{\\\"name\\\":\\\"Transportation\\\",\\\"count\\\":0,\\\"url\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/transportation\\\\/\\\",\\\"declared\\\":1},\\\"YCT:001000395\\\":{\\\"name\\\":\\\"Health\\\",\\\"count\\\":167,\\\"url\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/health\\\\/\\\",\\\"declared\\\":1},\\\"YCT:001000495\\\":{\\\"name\\\":\\\"Family Health\\\",\\\"count\\\":0,\\\"url\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/family-health\\\\/\\\",\\\"declared\\\":1},\\\"YCT:001000069\\\":{\\\"name\\\":\\\"Celebrities\\\",\\\"count\\\":86,\\\"url\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/celebrities\\\\/\\\",\\\"declared\\\":1},\\\"YCT:001000070\\\":{\\\"name\\\":\\\"Royal Families\\\",\\\"count\\\":0,\\\"url\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/royal-families-2\\\\/\\\",\\\"declared\\\":1},\\\"WIKIID:Prince_Harry_of_Wales\\\":{\\\"name\\\":\\\"Prince Harry of Wales\\\",\\\"count\\\":1,\\\"url\\\":\\\"http:\\\\/\\\\/www.yahoo.com\\\\/topic\\\\/prince-harry-of-wales\\\\/\\\",\\\"declared\\\":1},\\\"WIKIID:Kensington_Palace\\\":{\\\"name\\\":\\\"Kensington Palace\\\",\\\"count\\\":2,\\\"url\\\":\\\"http:\\\\/\\\\/www.yahoo.com\\\\/topic\\\\/kensington-palace\\\\/\\\",\\\"declared\\\":1},\\\"YCT:001000680\\\":{\\\"name\\\":\\\"Foreign Policy\\\",\\\"count\\\":39,\\\"url\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/foreign-policy\\\\/\\\",\\\"declared\\\":1},\\\"WIKIID:Barack_Obama\\\":{\\\"name\\\":\\\"Barack Obama\\\",\\\"count\\\":293,\\\"url\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/barack-obama\\\\/\\\",\\\"declared\\\":1},\\\"WIKIID:Mohamed_Morsi\\\":{\\\"name\\\":\\\"Mohamed Morsi\\\",\\\"count\\\":89,\\\"url\\\":\\\"http:\\\\/\\\\/www.yahoo.com\\\\/topic\\\\/mohamed-morsi\\\\/\\\",\\\"declared\\\":1},\\\"WIKIID:Egypt\\\":{\\\"name\\\":\\\"Egypt\\\",\\\"count\\\":188,\\\"url\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/egypt\\\\/\\\",\\\"declared\\\":1},\\\"WIKIID:United_States\\\":{\\\"name\\\":\\\"United States\\\",\\\"count\\\":136,\\\"url\\\":\\\"http:\\\\/\\\\/www.yahoo.com\\\\/topic\\\\/united-states\\\\/\\\",\\\"declared\\\":1},\\\"WIKIID:Hosni_Mubarak\\\":{\\\"name\\\":\\\"Hosni Mubarak\\\",\\\"count\\\":36,\\\"url\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/hosni-mubarak\\\\/\\\",\\\"declared\\\":1},\\\"WIKIID:Cairo\\\":{\\\"name\\\":\\\"Cairo\\\",\\\"count\\\":6,\\\"url\\\":\\\"http:\\\\/\\\\/www.yahoo.com\\\\/topic\\\\/cairo\\\\/\\\",\\\"declared\\\":1},\\\"YCT:001000267\\\":{\\\"name\\\":\\\"Education\\\",\\\"count\\\":46,\\\"url\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/education\\\\/\\\",\\\"declared\\\":1},\\\"YCT:001000269\\\":{\\\"name\\\":\\\"Schools\\\",\\\"count\\\":0,\\\"url\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/schools\\\\/\\\",\\\"declared\\\":1},\\\"WIKIID:Elementary_school\\\":{\\\"name\\\":\\\"Elementary school\\\",\\\"count\\\":1,\\\"url\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/elementary-school\\\\/\\\",\\\"declared\\\":1},\\\"WIKIID:Immigration_reform\\\":{\\\"name\\\":\\\"Immigration reform\\\",\\\"count\\\":32,\\\"url\\\":\\\"http:\\\\/\\\\/www.yahoo.com\\\\/topic\\\\/immigration-reform\\\\/\\\",\\\"declared\\\":1},\\\"YCT:001000705\\\":{\\\"name\\\":\\\"Military\\\",\\\"count\\\":53,\\\"url\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/military-and-defense\\\\/\\\",\\\"declared\\\":1},\\\"WIKIID:Unmanned_aerial_vehicle\\\":{\\\"name\\\":\\\"Unmanned aerial vehicle\\\",\\\"count\\\":2,\\\"url\\\":\\\"http:\\\\/\\\\/www.yahoo.com\\\\/topic\\\\/unmanned-aerial-vehicle\\\\/\\\",\\\"declared\\\":1},\\\"WIKIID:Aircraft_carrier\\\":{\\\"name\\\":\\\"Aircraft carrier\\\",\\\"count\\\":1,\\\"url\\\":\\\"http:\\\\/\\\\/www.yahoo.com\\\\/topic\\\\/aircraft-carrier\\\\/\\\",\\\"declared\\\":1},\\\"WIKIID:Patuxent_River\\\":{\\\"name\\\":\\\"Patuxent River\\\",\\\"count\\\":1,\\\"url\\\":\\\"http:\\\\/\\\\/www.yahoo.com\\\\/topic\\\\/patuxent-river\\\\/\\\",\\\"declared\\\":1},\\\"YCT:001000123\\\":{\\\"name\\\":\\\"Business\\\",\\\"count\\\":0,\\\"url\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/business\\\\/\\\",\\\"declared\\\":1},\\\"WIKIID:Panera_Bread\\\":{\\\"name\\\":\\\"Panera Bread\\\",\\\"count\\\":11,\\\"url\\\":\\\"http:\\\\/\\\\/www.yahoo.com\\\\/topic\\\\/panera-bread\\\\/\\\",\\\"declared\\\":1},\\\"YCT:001000804\\\":{\\\"name\\\":\\\"Religion\\\",\\\"count\\\":30,\\\"url\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/religion-and-beliefs\\\\/\\\",\\\"declared\\\":1},\\\"WIKIID:Southern_Baptist_Convention\\\":{\\\"name\\\":\\\"Southern Baptist Convention\\\",\\\"count\\\":1,\\\"url\\\":\\\"http:\\\\/\\\\/www.yahoo.com\\\\/topic\\\\/southern-baptist-convention\\\\/\\\",\\\"declared\\\":1},\\\"WIKIID:National_Security_Agency\\\":{\\\"name\\\":\\\"National Security Agency\\\",\\\"count\\\":62,\\\"url\\\":\\\"http:\\\\/\\\\/www.yahoo.com\\\\/topic\\\\/national-security-agency\\\\/\\\",\\\"declared\\\":1},\\\"WIKIID:California\\\":{\\\"name\\\":\\\"California\\\",\\\"count\\\":73,\\\"url\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/california\\\\/\\\",\\\"declared\\\":1},\\\"WIKIID:Solitary_confinement\\\":{\\\"name\\\":\\\"Solitary confinement\\\",\\\"count\\\":2,\\\"url\\\":\\\"http:\\\\/\\\\/www.yahoo.com\\\\/topic\\\\/solitary-confinement\\\\/\\\",\\\"declared\\\":1},\\\"YCT:001000681\\\":{\\\"name\\\":\\\"Government\\\",\\\"count\\\":0,\\\"url\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/government\\\\/\\\",\\\"declared\\\":1},\\\"WIKIID:White_House\\\":{\\\"name\\\":\\\"White House\\\",\\\"count\\\":128,\\\"url\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/white-house-2\\\\/\\\",\\\"declared\\\":1},\\\"WIKIID:Presidency_of_Barack_Obama\\\":{\\\"name\\\":\\\"Presidency of Barack Obama\\\",\\\"count\\\":46,\\\"url\\\":\\\"http:\\\\/\\\\/www.yahoo.com\\\\/topic\\\\/presidency-of-barack-obama\\\\/\\\",\\\"declared\\\":1},\\\"WIKIID:Patient_Protection_and_Affordable_Care_Act\\\":{\\\"name\\\":\\\"Patient Protection and Affordable Care Act\\\",\\\"count\\\":33,\\\"url\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/patient-protection-and-affordable-care-act\\\\/\\\",\\\"declared\\\":1},\\\"WIKIID:Ink_cartridge\\\":{\\\"name\\\":\\\"Ink cartridge\\\",\\\"count\\\":1,\\\"url\\\":\\\"http:\\\\/\\\\/www.yahoo.com\\\\/topic\\\\/ink-cartridge\\\\/\\\",\\\"declared\\\":1}},\\\"ccode\\\":\\\"news\\\"},\\\"props\\\":{\\\"refHandler\\\":\\\"cfg.maple_dali.handler.refresh\\\",\\\"id\\\":\\\"u_30345786\\\",\\\"ns\\\":\\\"type_stream\\\",\\\"trusted\\\":true,\\\"type\\\":\\\"stream\\\",\\\"contentId\\\":\\\"30345786\\\",\\\"tags\\\":[],\\\"title\\\":\\\"Stream\\\",\\\"icon\\\":\\\"\\\",\\\"shortTitle\\\":\\\"Stream\\\",\\\"detailUrl\\\":\\\"\\\",\\\"chromecolor\\\":\\\"blue\\\"},\\\"state\\\":{\\\"view\\\":\\\"default\\\",\\\"defer\\\":false,\\\"collapsed\\\":0},\\\"strs\\\":{\\\"STR.LOADING\\\":\\\"\\u003Cdiv class=\\\\\\\"fp-loader ti\\\\\\\"\\u003ELoad more stories\\u003C\\\\/div\\u003E\\\",\\\"STR.LOADING.CONTENT\\\":\\\"\\u003Cdiv class=\\\\\\\"loading next-batch\\\\\\\" data-key=\\\\\\\"0\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"fp-loader ti\\\\\\\"\\u003ELoad more stories&hellip;\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\\",\\\"STR.BUTTON.REMOVE_DONE\\\":\\\"\\u003Cbutton class=\\\\\\\"fz-xxs remove-done uibutton rapid-noclick-resp\\\\\\\"\\u003EDone\\u003C\\\\/button\\u003E\\\",\\\"STR.REMOVE.CONFIRM\\\":\\\"\\\",\\\"STR.BUTTON.WIKIID\\\":\\\"\\u003Cbutton class=\\\\\\\"fz-xxs wikiid uibutton rapid-noclick-resp {selected}\\\\\\\" data-wikiid=\\\\\\\"{id}\\\\\\\" data-interesttype=\\\\\\\"{type}\\\\\\\"\\u003E{name}\\u003Cspan class=\\\\\\\"d-ib img-sprite remove-neg\\\\\\\"\\u003E\\u003C\\\\/span\\u003E\\u003C\\\\/button\\u003E\\\",\\\"STR.SHOW.LESS\\\":\\\"\\u003Cdiv class=\\\\\\\"show-less fz-xs\\\\\\\"\\u003EShow me fewer stories about:\\u003C\\\\/div\\u003E\\\",\\\"STR.REMOVE.MENU\\\":\\\"\\u003Cdiv class=\\\\\\\"menu\\\\\\\"\\u003E\\u003Cbutton class=\\\\\\\"fz-xs undo rapid-noclick-resp\\\\\\\"\\u003EUndo\\u003C\\\\/button\\u003E\\u003Cp class=\\\\\\\"title fz-xs\\\\\\\"\\u003EStory removed\\u003C\\\\/p\\u003E\\u003Cdiv class=\\\\\\\"remove-menu-main cf\\\\\\\"\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"login hidden\\\\\\\"\\u003E\\u003Cdiv id=\\\\\\\"default-p_30345826_e86\\\\\\\" class=\\\\\\\"mod view_default\\\\\\\"\\u003E  \\u003Cdiv id=\\\\\\\"default-p_30345826_e86-bd\\\\\\\" class=\\\\\\\"bd type_login type_login_default\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"embed\\\\\\\"\\u003E\\u003Ch3 class=\\\\\\\"title mb-l\\\\\\\"\\u003ESign in to save your preferences:\\u003C\\\\/h3\\u003E\\u003Cdiv class=\\\\\\\"btns fz-xs\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"login-svc ylogin login-btn-purple rapid-noclick-resp login-btn-small\\\\\\\" href=\\\\\\\"https:\\\\/\\\\/login.yahoo.com\\\\/config\\\\/login?.src=fpctx&.intl=us\\\\\\\" data-action=\\\\\\\"click\\\\\\\" data-action-outcome=\\\\\\\"login\\\\\\\" data-ylk=\\\\\\\"sec:td-strm-rm;slk:login-yh;itc:0;cat:;\\\\\\\"\\u003E\\u003Ci class=\\\\\\\"img-sprite y-icon\\\\\\\"\\u003E\\u003C\\\\/i\\u003EYahoo!\\u003C\\\\/a\\u003E \\u003Cspan class=\\\\\\\"login-or d-ib\\\\\\\"\\u003Eor\\u003C\\\\/span\\u003E \\u003Cspan class=\\\\\\\"fb-button-wrapper d-ib\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"login-svc fblogin login-btn-fbblue rapidnofollow rapid-noclick-resp login-btn-small\\\\\\\" href=\\\\\\\"http:\\\\/\\\\/open.login.yahoo.net\\\\/openid\\\\/yrp\\\\/hr_signin?.intl=us&idp=facebook&ts=1373481532&rpcrumb=GqjYGTOGPyf&.src=home&appid=90376669494&spid=b9ed13cc-ddec-11de-9c83-001b784d35e1&perms=email,user_birthday,user_education_history,user_likes,user_location,user_relationships,user_subscriptions,user_work_history,friends_birthday,friends_education_history,friends_likes,friends_location,friends_work_history\\\\\\\" data-action=\\\\\\\"click\\\\\\\" data-action-outcome=\\\\\\\"login\\\\\\\" data-ylk=\\\\\\\"sec:td-strm-rm;slk:login-fb;cat:;\\\\\\\" target=\\\\\\\"_blank\\\\\\\"\\u003E\\u003Ci class=\\\\\\\"img-sprite fb-icon\\\\\\\"\\u003E\\u003C\\\\/i\\u003EFacebook\\u003C\\\\/a\\u003E\\u003Cspan class=\\\\\\\"fb-disclaimer narrow-disclaimer fz-xxs\\\\\\\"\\u003EWe don't post anything without your permission.\\u003C\\\\/span\\u003E\\u003C\\\\/span\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E    \\u003C\\\\/div\\u003E\\\\n\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003Ca class=\\\\\\\"profile-link d-ib rapid-noclick-resp fz-xs dn\\\\\\\" href=\\\\\\\"http:\\\\/\\\\/profile.yahoo.com\\\\/y\\\\/settings\\\\/interests\\\\/\\\\\\\"\\u003EEdit content preferences\\u003C\\\\/a\\u003E\\u003C\\\\/div\\u003E\\\"},\\\"res\\\":{},\\\"mods\\\":[{\\\"props\\\":{\\\"trusted\\\":true,\\\"id\\\":\\\"p_30345810_eab\\\",\\\"type\\\":\\\"fstream\\\",\\\"ns\\\":\\\"type_fstream\\\",\\\"contentId\\\":\\\"30345810\\\",\\\"tags\\\":[],\\\"title\\\":\\\"\\\",\\\"icon\\\":\\\"\\\",\\\"shortTitle\\\":\\\"\\\",\\\"detailUrl\\\":\\\"\\\",\\\"chromecolor\\\":\\\"blue\\\"},\\\"data\\\":{\\\"dropdownHover\\\":true,\\\"dynamicMax\\\":0,\\\"filterRestoreEnabled\\\":false,\\\"dropdownFilter\\\":false,\\\"tabFilter\\\":true,\\\"autoHideEnabled\\\":true,\\\"recentFiltersEnabled\\\":false,\\\"saveEnabled\\\":false,\\\"swipeFilterEnabled\\\":false,\\\"filterFontSize\\\":\\\"fz-s\\\"},\\\"strs\\\":{\\\"STR.FILTERS.FILTERBY\\\":\\\"Filter by\\\"},\\\"state\\\":{\\\"view\\\":\\\"default\\\",\\\"defer\\\":false,\\\"collapsed\\\":0},\\\"prefs\\\":{\\\"isc\\\":0,\\\"_mc\\\":0}}]}]}],\\\"res\\\":{\\\"css\\\":{\\\"helpers_css\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/ui\\\\/helpers_0.0.6.css\\\",\\\"typography_css\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/ui\\\\/typography_0.0.2.css\\\",\\\"theme_default_css\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/theme\\\\/default\\\\/common_0.0.29.css\\\",\\\"theme_default_desktop_css\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/theme\\\\/default\\\\/desktop_0.0.62.css\\\",\\\"tooltip_service_css\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/uiplugins\\\\/tooltip_service_1.0.12.css\\\",\\\"type_stream_css\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/stream\\\\/stream_0.0.271.css\\\",\\\"theme_gs_css\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/stream\\\\/theme_gs_0.0.45.css\\\",\\\"login_service_css\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/uiplugins\\\\/login_service_0.0.3.css\\\",\\\"rmx_ads_css\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/stream\\\\/rmx_ads_0.0.8.css\\\",\\\"type_fstream_desktop_css\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/fstream\\\\/fstream_desktop_0.0.21.css\\\",\\\"type_login_css\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/login\\\\/login_0.0.71.css\\\"},\\\"js\\\":{\\\"oop\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/oop_3.8.1.js\\\",\\\"event-custom-base\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/event-custom-base_3.8.1.js\\\",\\\"event-base\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/event-base_3.8.1.js\\\",\\\"io-base\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/io-base_3.8.1.js\\\",\\\"json-parse\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/json-parse_3.8.1.js\\\",\\\"json-stringify\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/json-stringify_3.8.1.js\\\",\\\"cookie\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/cookie_3.8.1.js\\\",\\\"jsonp\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/jsonp_3.8.1.js\\\",\\\"dom-core\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/dom-core_3.8.1.js\\\",\\\"dom-base\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/dom-base_3.8.1.js\\\",\\\"dom-style\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/dom-style_3.8.1.js\\\",\\\"selector-native\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/selector-native_3.8.1.js\\\",\\\"selector\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/selector_3.8.1.js\\\",\\\"node-core\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/node-core_3.8.1.js\\\",\\\"node-base\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/node-base_3.8.1.js\\\",\\\"node-style\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/node-style_3.8.1.js\\\",\\\"transition\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/transition_3.8.2.js\\\",\\\"selector-css2\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/selector-css2_3.8.1.js\\\",\\\"selector-css3\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/selector-css3_3.8.1.js\\\",\\\"event-custom-complex\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/event-custom-complex_3.8.1.js\\\",\\\"event-synthetic\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/event-synthetic_3.8.1.js\\\",\\\"event-focus\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/event-focus_3.8.1.js\\\",\\\"event-delegate\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/event-delegate_3.8.1.js\\\",\\\"node-event-delegate\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/node-event-delegate_3.8.1.js\\\",\\\"pluginhost-base\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/pluginhost-base_3.8.1.js\\\",\\\"pluginhost-config\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/pluginhost-config_3.8.1.js\\\",\\\"node-pluginhost\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/node-pluginhost_3.8.1.js\\\",\\\"dom-screen\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/dom-screen_3.8.1.js\\\",\\\"node-screen\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/node-screen_3.8.1.js\\\",\\\"gallery-storage-lite\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/gallery-storage-lite_3.8.1.js\\\",\\\"module_platform\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/uicontrib\\\\/dali\\\\/module_platform_1.1.14.js\\\",\\\"resourcemgr\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/uicontrib\\\\/dali\\\\/resourcemgr_1.1.14.js\\\",\\\"transport\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/uicontrib\\\\/dali\\\\/dali_transport_1.1.34.js\\\",\\\"metro_ext\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/uicontrib\\\\/dali\\\\/metro_dali_1.0.27.js\\\",\\\"module_api\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/uicontrib\\\\/dali\\\\/module_api_1.1.16.js\\\",\\\"yui_service\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/uicontrib\\\\/dali\\\\/yui_service_0.1.17.js\\\",\\\"metro_viewtype\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/uiplugins\\\\/metro_viewtype_0.1.24.js\\\",\\\"default_viewtype\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/uiplugins\\\\/default_viewtype_0.1.61.js\\\",\\\"edit_viewtype\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/uiplugins\\\\/edit_viewtype_0.1.40.js\\\",\\\"ylc\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/uicontrib\\\\/ylc_1.8.22.js\\\",\\\"instrumentation_service\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/uiplugins\\\\/instrumentation_service_0.1.83.js\\\",\\\"userinfo_service\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/uiplugins\\\\/userinfo_service_0.1.15.js\\\",\\\"statemgr_service\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/uiplugins\\\\/statemgr_service_0.1.20.js\\\",\\\"metrologger_service\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/uiplugins\\\\/metrologger_service_0.1.18.js\\\",\\\"tooltip_service\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/uiplugins\\\\/tooltip_service_0.1.56.js\\\",\\\"autohide_service\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/uiplugins\\\\/autohide_service_0.1.15.js\\\",\\\"badge\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro2\\\\/g\\\\/badge\\\\/badge_0.1.20.js\\\",\\\"type_stream\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/stream\\\\/stream_0.0.456.js\\\",\\\"storage_service\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/uiplugins\\\\/storage_service_0.0.1.js\\\",\\\"login_service\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/uiplugins\\\\/login_service_0.0.38.js\\\",\\\"interests_service\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/uiplugins\\\\/interests_service_0.1.1.js\\\",\\\"type_fstream\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/fstream\\\\/fstream_0.0.95.js\\\",\\\"type_login\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/login\\\\/login_0.0.32.js\\\"}}};\\u000a}()\\u000a);\\u000a\\u003C/script\\u003E\\u000a\\u000a\\u003Cscript type=\\\"text/javascript\\\"\\u003E\\u000a(function(){\\u000a    YUI.add(\\\"metro_config\\\", function(Y){\\u000a        // until dali defaults this\\u000a\\u000a        Y.mix(Y.dali.config.props, {\\u000a            libRoot: \\\"\\\",\\u000a            user : \\\"\\\",\\u000a            ultSpaceId : \\\"2023538075\\\",\\u000a            ultBeaconHost : \\\"\\\\/p.gif\\\",\\u000a            modChromeHtml : \\\"\\u003Cdiv id=\\\\\\\"error-{type_name}\\\\\\\" class=\\\\\\\"mod view_error\\\\\\\"\\u003E  \\u003Cdiv id=\\\\\\\"error-{type_name}-bd\\\\\\\" class=\\\\\\\"bd  _error\\\\\\\"\\u003E{html}    \\u003C\\\\/div\\u003E\\\\n\\u003C\\\\/div\\u003E\\\",\\u000a            modErrorHtml : \\\"\\u003Cdiv class=\\\\\\\"oops-msg\\\\\\\" role=\\\\\\\"alertdialog\\\\\\\"\\u003E\\\\n                \\u003Cspan class='icon' style='background-image:url({img});_filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(enabled=true, sizingMethod=crop src=\\\\\\\"{img}\\\\\\\"); _background-image:none;'\\u003E\\u003C\\\\/span\\u003E\\u003Cspan class='shadow'\\u003E\\u003C\\\\/span\\u003E\\\\n                \\u003Ch3 class=\\\\\\\"oops\\\\\\\"\\u003E\\\\\\\"{name}\\\\\\\" encountered a problem while trying to load\\u003C\\\\/h3\\u003E\\\\n                \\u003Cp class=\\\\\\\"oops\\\\\\\"\\u003E{message}\\u003C\\\\/p\\u003E\\\\n                                \\u003Cp class=\\\\\\\"oops oops-link\\\\\\\"\\u003EOr visit \\u003Ca href=\\\\\\\"{url}\\\\\\\"\\u003E{url}\\u003C\\\\/a\\u003E\\u003C\\\\/p\\u003E\\\\n            \\u003C\\\\/div\\u003E\\\",\\u000a            crumbErrorHtml : \\\"\\u003Cdiv class=\\\\\\\"oops-msg\\\\\\\" role=\\\\\\\"alertdialog\\\\\\\"\\u003E\\\\n                \\u003Cspan class=\\\\\\\"icon icon-error y-glbl-universal\\\\\\\"\\u003E\\u003C\\\\/span\\u003E\\\\n                \\u003Ch3 class=\\\\\\\"oops\\\\\\\"\\u003EThe module encountered a problem while trying to load\\u003C\\\\/h3\\u003E\\\\n                \\u003Cp class=\\\\\\\"oops\\\\\\\"\\u003E2048\\u003C\\\\/p\\u003E\\\\n                \\\\n            \\u003C\\\\/div\\u003E\\\",\\u000a            cookieErrorHtml : \\\"\\u003Cdiv class=\\\\\\\"oops-msg\\\\\\\" role=\\\\\\\"alertdialog\\\\\\\"\\u003E\\\\n                \\u003Cspan class=\\\\\\\"icon icon-error y-glbl-universal\\\\\\\"\\u003E\\u003C\\\\/span\\u003E\\\\n                \\u003Ch3 class=\\\\\\\"oops\\\\\\\"\\u003EThe module encountered a problem while trying to load\\u003C\\\\/h3\\u003E\\\\n                \\u003Cp class=\\\\\\\"oops\\\\\\\"\\u003E16384\\u003C\\\\/p\\u003E\\\\n                \\\\n            \\u003C\\\\/div\\u003E\\\",\\u000a            proxyTimeout : 15000,\\u000a            proxyUrl : '/hjs',\\u000a            intl : \\\"us\\\",\\u000a            \\\"ywa.rapid.enabled\\\": true\\u000a        });\\u000a    });\\u000a\\u000a    var i, len, url, match, modules,\\u000a        allScripts = YUI.presentation.lazyScriptList,\\u000a        comboRoot = 'http://l.yimg.com/zz/combo?',\\u000a        isCombo =  allScripts[0].indexOf(comboRoot) === 0,\\u000a        yuiMods = ['metro_config'],\\u000a        lazyScripts = [];\\u000a\\u000a    if (isCombo) {\\u000a        for (i = 0, len = allScripts.length; i \\u003C len; ++i) {\\u000a            url = allScripts[i].replace(comboRoot, '');\\u000a            allScripts = allScripts.concat(url.split('&'));\\u000a        }\\u000a        allScripts = allScripts.slice(len);\\u000a    }\\u000a\\u000a    for (i = 0, len = allScripts.length; i \\u003C len; ++i) {\\u000a        url = allScripts[i];\\u000a        match = url.match(/\\\\/yui\\\\/([^._]*)/);\\u000a        if (match && match.length \\u003E 1) {\\u000a            yuiMods.push(match[1]);\\u000a        } else {\\u000a            lazyScripts.push(url);\\u000a        }\\u000a    }\\u000a\\u000a    if (isCombo) {\\u000a        lazyScripts = [comboRoot + lazyScripts.join('&')];\\u000a    }\\u000a\\u000a    if (YMedia.ModulePlatform) {\\u000a        modules = YMedia.ModulePlatform.getModules();\\u000a        YMedia.ModulePlatform.stop(modules);\\u000a        YMedia.each(modules, YMedia.ModulePlatform.unregisterModule);\\u000a    }\\u000a    YMedia.use(yuiMods, function (Y) {\\u000a        Y.dali.config.debug = false;\\u000a        Y.Get.script(lazyScripts, { onSuccess: function(){\\u000a            Y.use(\\\"*\\\", function (Y) {\\u000a                Y.ModulePlatform.init(Y.dali.config, true);\\u000a            });\\u000a        }});\\u000a        var rapid = YMedia ? YMedia.rapid : null,\\u000a            id = 'p_30345786',\\u000a            container = Y.one('#' + id);\\u000a        if (rapid && container) {\\u000a            if (rapid.isModuleTracked(id)) {\\u000a                rapid.refreshModule(id);\\u000a            } else {\\u000a                rapid.addModules(id);\\u000a            }\\u000a        }\\u000a        if (container) {\\u000a            container.addClass('jsenabled');\\u000a        }\\u000a    });\\u000a\\u000a})();\\u000a\\u003C/script\\u003E\\u000a\\u000a--dali-response-split-51ddaa3c96973--\"\n            });\n        })));\n    })()));\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};\n\n\n\t\ttry {\n    ((JSBNG_Record.scriptLoad)((\"YUI.YUICfg = {\\u000a    gallery: \\\"gallery-2011.04.20-13-04\\\",\\u000a    groups: {\\u000a        group01c9d8dea06e05460a64eed4dadd622b6: {\\u000a            base: \\\"http://l.yimg.com/\\\",\\u000a            comboBase: \\\"http://l.yimg.com/zz/combo?\\\",\\u000a            modules: {\\u000a                \\\"media-request-manager\\\": {\\u000a                    path: \\\"os/mit/media/p/content/request-manager-min-1334113.js\\\"\\u000a                },\\u000a                \\\"media-content-manager\\\": {\\u000a                    path: \\\"os/mit/media/p/content/content-manager-min-1331468.js\\\"\\u000a                },\\u000a                \\\"media-perf-timeable\\\": {\\u000a                    path: \\\"os/mit/media/p/content/perf-timeable-min-1191658.js\\\"\\u000a                },\\u000a                \\\"media-ad-controller\\\": {\\u000a                    path: \\\"os/mit/media/p/content/ad-controller-min-1334238.js\\\"\\u000a                },\\u000a                \\\"media-pane-manager\\\": {\\u000a                    path: \\\"os/mit/media/p/content/pane-manager-min-1343260.js\\\"\\u000a                },\\u000a                \\\"media-next-scroll\\\": {\\u000a                    path: \\\"os/mit/media/p/content/next-scroll-min-1304262.js\\\"\\u000a                },\\u000a                \\\"media-tag-manager\\\": {\\u000a                    path: \\\"os/mit/media/p/content/tag-manager-min-1294559.js\\\"\\u000a                },\\u000a                \\\"media-content-discoverer\\\": {\\u000a                    path: \\\"os/mit/media/p/content/content-discoverer-min-1331680.js\\\"\\u000a                },\\u000a                \\\"media-interest-manager\\\": {\\u000a                    path: \\\"os/mit/media/p/content/interest-manager-min-1306018.js\\\"\\u000a                },\\u000a                \\\"media-instrumentation\\\": {\\u000a                    path: \\\"os/mit/media/p/content/instrumentation-min-1214752.js\\\"\\u000a                },\\u000a                \\\"media-content-ss-base\\\": {\\u000a                    path: \\\"os/mit/media/m/content_photo/content-ss-base-min-1330613.js\\\"\\u000a                },\\u000a                \\\"media-content-ss-no-sv\\\": {\\u000a                    path: \\\"os/mit/media/m/content_photo/content-ss-no-sv-min-1328161.js\\\"\\u000a                },\\u000a                \\\"media-carousel\\\": {\\u000a                    path: \\\"os/mit/media/m/content_photo/carousel-min-1308638.js\\\"\\u000a                },\\u000a                \\\"media-lead\\\": {\\u000a                    path: \\\"os/mit/media/m/content_index/lead-min-1306566.js\\\"\\u000a                },\\u000a                \\\"media-comic\\\": {\\u000a                    path: \\\"os/mit/media/m/content_index/comic-min-1262759.js\\\"\\u000a                },\\u000a                \\\"media-content-social-base\\\": {\\u000a                    path: \\\"os/mit/media/m/content_social/content-social-base-min-1339203.js\\\"\\u000a                },\\u000a                \\\"media-content-email-autocomplete\\\": {\\u000a                    path: \\\"os/mit/media/m/content_social/content-email-autocomplete-min-1306078.js\\\"\\u000a                },\\u000a                \\\"media-content-share-buttons\\\": {\\u000a                    path: \\\"os/mit/media/m/content_social/content-share-buttons-min-1339400.js\\\"\\u000a                },\\u000a                \\\"media-content-share-buttons-builder\\\": {\\u000a                    path: \\\"os/mit/media/m/content_social/content-share-buttons-builder-min-1337341.js\\\"\\u000a                },\\u000a                \\\"media-bc\\\": {\\u000a                    path: \\\"d/lib/bc/bc_2.0.5.js\\\"\\u000a                },\\u000a                \\\"media-beacon-manager\\\": {\\u000a                    path: \\\"os/mit/media/p/content/beacon-manager-min-1333171.js\\\"\\u000a                },\\u000a                \\\"media-nav-addon\\\": {\\u000a                    path: \\\"os/mit/media/m/navigation/nav-addon-min-1270754.js\\\"\\u000a                },\\u000a                \\\"media-recommend\\\": {\\u000a                    path: \\\"os/mit/media/p/content/recommend-min-1277359.js\\\"\\u000a                },\\u000a                \\\"media-personal-nav\\\": {\\u000a                    path: \\\"os/mit/media/p/content/personal-nav-min-1318968.js\\\"\\u000a                },\\u000a                \\\"media-strip\\\": {\\u000a                    path: \\\"ss/strip_3.2.js\\\"\\u000a                },\\u000a                \\\"media-trfsm\\\": {\\u000a                    path: \\\"os/mit/media/p/common/trfsm-min-797026.js\\\"\\u000a                },\\u000a                \\\"media-i13n\\\": {\\u000a                    path: \\\"os/mit/media/p/common/i13n-min-1154367.js\\\"\\u000a                },\\u000a                \\\"media-ywa-tracking\\\": {\\u000a                    path: \\\"os/mit/media/p/common/ywa-tracking-min-1234794.js\\\"\\u000a                },\\u000a                \\\"media-content-navigation-desktop\\\": {\\u000a                    path: \\\"os/mit/media/m/navigation/content-navigation-desktop-min-1318647.js\\\"\\u000a                },\\u000a                \\\"media-footer\\\": {\\u000a                    path: \\\"os/mit/media/m/footer/footer-min-923366.js\\\"\\u000a                }\\u000a            },\\u000a            combine: true,\\u000a            filter: \\\"min\\\",\\u000a            root: \\\"/\\\"\\u000a        }\\u000a    },\\u000a    modules: {\\u000a        \\\"media-ad-ros\\\": {\\u000a            fullpath: \\\"http://ads.yimg.com/qq/dm/ad-ros-0.0.2.js\\\"\\u000a        }\\u000a    },\\u000a    combine: true,\\u000a    allowRollup: true,\\u000a    comboBase: \\\"http://l.yimg.com/zz/combo?\\\",\\u000a    maxURLLength: \\\"2000\\\"\\u000a};\\u000aYUI.YUICfg.root = ((\\\"yui:\\\" + YUI.version) + \\\"/build/\\\");\\u000aYMedia.applyConfig(YUI.YUICfg);\\u000aYUI.Env[YUI.version].groups.gallery.root = \\\"yui:gallery-2011.04.20-13-04/build/\\\";\\u000aYMedia.use(\\\"media-request-manager\\\", \\\"media-content-manager\\\", \\\"media-perf-timeable\\\", \\\"node-scroll-info\\\", \\\"event-custom\\\", \\\"media-ad-controller\\\", \\\"app-base\\\", \\\"querystring-parse\\\", \\\"media-rmp\\\", \\\"media-pane-manager\\\", \\\"node-base\\\", \\\"event-touch\\\", \\\"media-next-scroll\\\", \\\"media-next-scroll\\\", \\\"event-mouseenter\\\", \\\"media-tag-manager\\\", \\\"media-tag-manager\\\", \\\"media-content-discoverer\\\", \\\"history-base\\\", \\\"media-interest-manager\\\", \\\"io-base\\\", \\\"json-parse\\\", \\\"media-instrumentation\\\", \\\"media-content-ss-base\\\", \\\"media-content-ss-no-sv\\\", \\\"node-base\\\", \\\"event-key\\\", \\\"media-carousel\\\", \\\"base\\\", \\\"json-parse\\\", \\\"querystring-stringify\\\", \\\"media-lead\\\", \\\"media-comic\\\", \\\"autocomplete\\\", \\\"autocomplete-highlighters\\\", \\\"event-base\\\", \\\"event-custom\\\", \\\"node-core\\\", \\\"io\\\", \\\"querystring\\\", \\\"overlay\\\", \\\"json\\\", \\\"gallery-node-tokeninput\\\", \\\"querystring-stringify-simple\\\", \\\"gallery-outside-events\\\", \\\"media-content-social-base\\\", \\\"media-content-email-autocomplete\\\", \\\"media-content-social-base\\\", \\\"media-content-email-autocomplete\\\", \\\"media-content-share-buttons\\\", \\\"event\\\", \\\"node\\\", \\\"media-content-share-buttons-builder\\\", function(Y) {\\u000a    Y.later(10, this, function() {\\u000a        Y.Media.adController = new Y.Media.AdController({\\u000a            env: \\\"prod\\\",\\u000a            hideOnFailure: false,\\u000a            fetchOnPjaxOnly: true,\\u000a            preserveLRECContainer: false\\u000a        });\\u000a    });\\u000a    Y.later(10, this, function() {\\u000a        Y.Media.requestManager = new Y.Media.RequestManager({\\u000a            chrome: Y.Media.pageChrome,\\u000a            linkSelector: \\\"a:not(.no-pjax)\\\",\\u000a            unsuppBrowsers: \\\"\\\",\\u000a            continueOnError: \\\"1\\\",\\u000a            pjaxSplit: \\\"0\\\",\\u000a            ignoreCssErrors: \\\"1\\\"\\u000a        }).render();\\u000a    });\\u000a    Y.later(10, this, function() {\\u000a        new Y.Media.ContentManager({\\u000a            nodePaths: {\\u000a                content: \\\"#yog-content\\\",\\u000a                navigation: \\\"#yog-nav .navlist\\\",\\u000a                related: \\\"#yog-related\\\",\\u000a                superlead: \\\"#yog-stage\\\"\\u000a            },\\u000a            transition: {\\u000a                style: \\\"fade\\\"\\u000a            }\\u000a        });\\u000a    });\\u000a    Y.later(10, this, function() {\\u000a        Y.Media.pagePaneManager = new Y.Media.PaneManager({\\u000a            debug: 0,\\u000a            grid_type: {\\u000a                content: {\\u000a                    scroll_mode: \\\"bandit\\\"\\u000a                },\\u000a                index: {\\u000a                    scroll_mode: \\\"bandit\\\"\\u000a                }\\u000a            },\\u000a            isYnet: 0\\u000a        });\\u000a    });\\u000a    Y.later(10, this, function() {\\u000a        new Y.Media.TagManager();\\u000a    });\\u000a    Y.later(10, this, function() {\\u000a        new Y.Media.ContentDiscoverer({\\u000a            enableLightboxOnStream: \\\"1\\\"\\u000a        });\\u000a    });\\u000a    Y.later(10, this, function() {\\u000a        new Y.Media.InterestManager({\\u000a        });\\u000a    });\\u000a    Y.later(10, this, function() {\\u000a        new Y.Media.Instrumentation();\\u000a    });\\u000a    Y.later(10, this, function() {\\u000a        new Y.Media.ContentSSNoSV({\\u000a            chrome: Y.Media.pageChrome,\\u000a            config: {\\u000a                modId: \\\"\\\",\\u000a                setupSlideshowCover: \\\"false\\\",\\u000a                enableCarousel: \\\"1\\\",\\u000a                enableEndSlideRel: \\\"0\\\",\\u000a                enableEndSlideMP: \\\"1\\\",\\u000a                strings: {\\u000a                    more: \\\"more\\\",\\u000a                    less: \\\"less\\\",\\u000a                    of: \\\"of\\\"\\u000a                }\\u000a            }\\u000a        });\\u000a    });\\u000a    Y.later(10, this, function() {\\u000a        Y.Media.shareButtonsBuilder = new Y.Media.ContentShareButtonsBuilder({\\u000a            modNode: \\\"\\\",\\u000a            switches: {\\u000a                mtf: true,\\u000a                cmt: false\\u000a            },\\u000a            loginStat: {\\u000a                yahoo: 0\\u000a            },\\u000a            data: {\\u000a                mtfRedirUrl: \\\"http%3A%2F%2Fnews.yahoo.com%2F_xhr%2Fmediacontentsharebuttons%2Fpostshare%2F%3Fsrc%3Dmail\\\"\\u000a            },\\u000a            pageData: {\\u000a                crumb: \\\"\\\",\\u000a                title: \\\"\\\",\\u000a                summary: \\\"\\\",\\u000a                thumbnail: \\\"\\\",\\u000a                url: \\\"\\\",\\u000a                locale: \\\"US\\\",\\u000a                prop: \\\"news\\\",\\u000a                content_id: \\\"5f01278b-803a-3803-9798-7fc79bab4f7d\\\",\\u000a                ult__S: \\\"81121452\\\",\\u000a                ult_ct: \\\"\\\",\\u000a                ult_pkg: \\\"5f01278b-803a-3803-9798-7fc79bab4f7d\\\",\\u000a                ult_test: null,\\u000a                ult_csrcpvid: \\\"FSr0xQrHg2.G2dUfMOsImwDQDEeLIlHdqicAC52y\\\",\\u000a                ult_sec: \\\"mit_share\\\",\\u000a                ult_slk: \\\"mail\\\",\\u000a                ult_mpos: 1,\\u000a                ult_lang: \\\"en-US\\\",\\u000a                ult_act: \\\"mail\\\",\\u000a                ult_pstaid: \\\"5f01278b-803a-3803-9798-7fc79bab4f7d\\\"\\u000a            },\\u000a            contentMetaData: {\\u000a                id: \\\"5f01278b-803a-3803-9798-7fc79bab4f7d\\\",\\u000a                url_orig: \\\"\\\",\\u000a                title_orig: \\\"\\\",\\u000a                summary: \\\"\\\",\\u000a                type: \\\"homepage\\\"\\u000a            },\\u000a            config: {\\u000a                site: \\\"news\\\",\\u000a                lang: \\\"en-US\\\",\\u000a                region: \\\"US\\\",\\u000a                scrumb: false\\u000a            },\\u000a            template: \\\"\\\\u003Cdiv class=\\\\\\\"yom-share-btns-container light\\\\\\\"\\\\u003E\\\\u000a    \\\\u003Cdiv class=\\\\\\\"share-btns\\\\\\\" role=\\\\\\\"menu\\\\\\\"\\\\u003E\\\\u000a        \\\\u003Cdiv class=\\\\\\\"share-btns-wrap\\\\\\\"\\\\u003E\\\\u000a            \\\\u003Cdiv class=\\\\\\\"share-btn-wrap\\\\\\\"\\\\u003E\\\\u000a                \\\\u003Cul\\\\u003E\\\\u003Cli class=\\\\\\\"share-btn facebook\\\\\\\"\\\\u003E\\\\u000a                        \\\\u003Ca href=\\\\\\\"http://www.facebook.com/dialog/feed?app_id=90376669494&amp;redirect_uri=http://news.yahoo.com/_xhr/mediacontentsharebuttons/postshare/?src=fb&amp;link=http://news.yahoo.com/&amp;picture=http://l2.yimg.com/bt/api/res/1.2/BvlRk2eMuZ5S5ZVts0i.Uw--/YXBwaWQ9eW5ld3M7cT04NTt3PTYwMA--/http://l.yimg.com/os/publish-images/news/2013-03-19/528dd2af-804a-4db8-b6eb-53b18b9b0592_ybang_225x225.png&amp;display=popup&amp;show_error=yes\\\\\\\" role=\\\\\\\"link\\\\\\\" title=\\\\\\\"share\\\\\\\" target=\\\\\\\"_blank\\\\\\\" data-ylk=\\\\\\\"sec:mod-sh-b;slk:btn-sh-fb;itc:1;test:;\\\\\\\" data-action-outcome=\\\\\\\"share\\\\\\\"\\\\u003E\\\\u003Cspan class=\\\\\\\"btn-icon btn-fb\\\\\\\"\\\\u003E\\\\u003C/span\\\\u003E\\\\u003Cspan class=\\\\\\\"btn-count hide\\\\\\\"\\\\u003E0\\\\u003C/span\\\\u003E\\\\u003C/a\\\\u003E\\\\u000a                    \\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"share-btn twitter\\\\\\\"\\\\u003E\\\\u000a                        \\\\u003Ca href=\\\\\\\"https://twitter.com/share?text=Yahoo%21%20News%20-%20Latest%20News%20%26%20Headlines&amp;url=http://news.yahoo.com/&amp;via=YahooNews\\\\\\\" role=\\\\\\\"link\\\\\\\" title=\\\\\\\"tweet\\\\\\\" target=\\\\\\\"_blank\\\\\\\" data-ylk=\\\\\\\"sec:mod-sh-b;slk:btn-sh-tw;itc:1;test:;\\\\\\\" data-action-outcome=\\\\\\\"share\\\\\\\"\\\\u003E\\\\u003Cspan class=\\\\\\\"btn-icon btn-tw\\\\\\\"\\\\u003E\\\\u003C/span\\\\u003E\\\\u003Cspan class=\\\\\\\"btn-count hide\\\\\\\"\\\\u003E0\\\\u003C/span\\\\u003E\\\\u003C/a\\\\u003E\\\\u000a                    \\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"share-btn tumblr\\\\\\\"\\\\u003E\\\\u000a                        \\\\u003Ca href=\\\\\\\"http://www.tumblr.com/share/link?url=http%3A%2F%2Fnews.yahoo.com%2F&description=The%20latest%20news%20and%20headlines%20from%20Yahoo%21%20News.%20Get%20breaking%20news%20stories%20and%20in-depth%20coverage%20with%20videos%20and%20photos.&name=Yahoo%21%20News%20-%20Latest%20News%20%26amp%3B%20Headlines\\\\\\\" role=\\\\\\\"link\\\\\\\" title=\\\\\\\"tumblr\\\\\\\" target=\\\\\\\"_blank\\\\\\\" data-ylk=\\\\\\\"sec:mod-sh-b;slk:btn-sh-tu;itc:1;test:;\\\\\\\" data-action-outcome=\\\\\\\"share\\\\\\\"\\\\u003E\\\\u003Cspan class=\\\\\\\"btn-icon btn-tu\\\\\\\"\\\\u003E\\\\u003C/span\\\\u003E\\\\u003Cspan class=\\\\\\\"btn-count hide\\\\\\\"\\\\u003E\\\\u003C/span\\\\u003E\\\\u003C/a\\\\u003E\\\\u000a                    \\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"share-btn pinterest\\\\\\\"\\\\u003E\\\\u000a                        \\\\u003Ca href=\\\\\\\"http://pinterest.com/pin/create/button/?url=http%3A%2F%2Fnews.yahoo.com%2F&description=The%20latest%20news%20and%20headlines%20from%20Yahoo%21%20News.%20Get%20breaking%20news%20stories%20and%20in-depth%20coverage%20with%20videos%20and%20photos.&media=http://l2.yimg.com/bt/api/res/1.2/BvlRk2eMuZ5S5ZVts0i.Uw--/YXBwaWQ9eW5ld3M7cT04NTt3PTYwMA--/http://l.yimg.com/os/publish-images/news/2013-03-19/528dd2af-804a-4db8-b6eb-53b18b9b0592_ybang_225x225.png\\\\\\\" role=\\\\\\\"link\\\\\\\" title=\\\\\\\"pinterest\\\\\\\" target=\\\\\\\"_blank\\\\\\\" data-ylk=\\\\\\\"sec:mod-sh-b;slk:btn-sh-pin;itc:1;test:;\\\\\\\" data-action-outcome=\\\\\\\"share\\\\\\\"\\\\u003E\\\\u003Cspan class=\\\\\\\"btn-icon btn-pin\\\\\\\"\\\\u003E\\\\u003C/span\\\\u003E\\\\u003Cspan class=\\\\\\\"btn-count hide\\\\\\\"\\\\u003E\\\\u003C/span\\\\u003E\\\\u003C/a\\\\u003E\\\\u000a                    \\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"share-btn mail email\\\\\\\"\\\\u003E\\\\u000a                        \\\\u003Ca href=\\\\\\\"mailto:?subject=Yahoo%21%20News%20-%20Latest%20News%20%26amp%3B%20Headlines&amp;body=http%3A%2F%2Fnews.yahoo.com%2F\\\\\\\" role=\\\\\\\"link\\\\\\\" title=\\\\\\\"email\\\\\\\" data-ylk=\\\\\\\"sec:mod-sh-b;slk:btn-sh-ma;itc:1;test:;\\\\\\\" data-action-outcome=\\\\\\\"share\\\\\\\"\\\\u003E\\\\u003Cspan class=\\\\\\\"btn-icon btn-mail\\\\\\\"\\\\u003E\\\\u003C/span\\\\u003E\\\\u003Cspan class=\\\\\\\"btn-count hide\\\\\\\"\\\\u003E0\\\\u003C/span\\\\u003E\\\\u003C/a\\\\u003E\\\\u000a                    \\\\u003C/li\\\\u003E\\\\u000a                \\\\u003C/ul\\\\u003E\\\\u000a            \\\\u003C/div\\\\u003E\\\\u000a            \\\\u003Cdiv class=\\\\\\\"clearfix\\\\\\\"\\\\u003E\\\\u003C/div\\\\u003E\\\\u000a        \\\\u003C/div\\\\u003E\\\\u000a    \\\\u003C/div\\\\u003E\\\\u000a    \\\\u003Cdiv class=\\\\\\\"share-btns-overlay-screen hide\\\\\\\"\\\\u003E\\\\u003C/div\\\\u003E\\\\u000a    \\\\u003Cdiv class=\\\\\\\"share-btns-overlay hide\\\\\\\"\\\\u003E\\\\u000a        \\\\u003Cdiv class=\\\\\\\"yui3-widget-hd\\\\\\\"\\\\u003E\\\\u000a            \\\\u003Cdiv class=\\\\\\\"close-btn\\\\\\\" role=\\\\\\\"button\\\\\\\"\\\\u003E&times;\\\\u003C/div\\\\u003E\\\\u000a        \\\\u003C/div\\\\u003E\\\\u000a        \\\\u003Cdiv class=\\\\\\\"yui3-widget-bd\\\\\\\"\\\\u003E\\\\u000a            \\\\u003Cdiv class=\\\\\\\"speedbump hide mail-login\\\\\\\" role=\\\\\\\"dialog\\\\\\\" aria-labelledby=\\\\\\\"Sign in to share this by email\\\\\\\"\\\\u003E\\\\u000a                \\\\u003Ch3 class=\\\\\\\"header\\\\\\\"\\\\u003ESign in to share this by email\\\\u003C/h3\\\\u003E\\\\u000a                \\\\u003Cdiv class=\\\\\\\"login-btns\\\\\\\"\\\\u003E\\\\u000a                    \\\\u003Cdiv class=\\\\\\\"login-link\\\\\\\"\\\\u003E\\\\u000a                        \\\\u003Ca class=\\\\\\\"login-btn yahoo\\\\\\\" role=\\\\\\\"link\\\\\\\" href=\\\\\\\"https://login.yahoo.com/config/login_verify2?.done=http%3A%2F%2Fnews.yahoo.com%2F_xhr%2Fmediacontentsharebuttons%2Fpostshare%2F%3Fsrc%3Dmail&amp;.src=mtf\\\\\\\" target=\\\\\\\"_blank\\\\\\\"\\\\u003E\\\\u003Cspan class=\\\\\\\"login-icon yahoo\\\\\\\"\\\\u003E\\\\u003C/span\\\\u003E\\\\u003Cspan class=\\\\\\\"login-text\\\\\\\"\\\\u003EYahoo!\\\\u003C/span\\\\u003E\\\\u003C/a\\\\u003E\\\\u000a                    \\\\u003C/div\\\\u003E\\\\u000a                    \\\\u003Cdiv class=\\\\\\\"login-link\\\\\\\"\\\\u003E\\\\u000a                        \\\\u003Ca class=\\\\\\\"login-btn facebook\\\\\\\" role=\\\\\\\"link\\\\\\\" href=\\\\\\\"https://open.login.yahoo.com/openid/yrp/signin?.intl=us&amp;idp=facebook&amp;.done=http://news.yahoo.com/%23mtf-overlay&amp;ts=1373481511&amp;.src=home&amp;appid=90376669494&amp;spid=b9ed13cc-ddec-11de-9c83-001b784d35e1&amp;perms=email,user_birthday,user_education_history,user_likes,user_location,user_relationships,user_subscriptions,user_work_history,friends_birthday,friends_education_history,friends_likes,friends_location,friends_work_history,publish_actions&amp;fbflow=1\\\\\\\" target=\\\\\\\"_blank\\\\\\\"\\\\u003E\\\\u003Cspan class=\\\\\\\"login-icon facebook\\\\\\\"\\\\u003E\\\\u003C/span\\\\u003E\\\\u003Cspan class=\\\\\\\"login-text\\\\\\\"\\\\u003EFacebook\\\\u003C/span\\\\u003E\\\\u003C/a\\\\u003E\\\\u000a                    \\\\u003C/div\\\\u003E\\\\u000a                \\\\u003C/div\\\\u003E\\\\u000a                \\\\u003Cp\\\\u003ENew here? \\\\u003Ca href=\\\\\\\"https://edit.yahoo.com/config/eval_register?.done=http%3A%2F%2Fnews.yahoo.com%2F_xhr%2Fmediacontentsharebuttons%2Fpostshare%2F%3Fsrc%3Dmail\\\\\\\" target=\\\\\\\"_blank\\\\\\\" class=\\\\\\\"signup\\\\\\\"\\\\u003ESign up.\\\\u003C/a\\\\u003E\\\\u003C/p\\\\u003E\\\\u000a            \\\\u003C/div\\\\u003E\\\\u000a            \\\\u003Cdiv class=\\\\\\\"speedbump hide mail-form\\\\\\\" role=\\\\\\\"dialog\\\\\\\" aria-labelledby=\\\\\\\"Email this\\\\\\\"\\\\u003E\\\\u000a                \\\\u003Ch3 class=\\\\\\\"header\\\\\\\"\\\\u003EEmail this\\\\u003C/h3\\\\u003E\\\\u000a                \\\\u003Cdiv class=\\\\\\\"form\\\\\\\"\\\\u003E\\\\u000a                    \\\\u003Cdiv class=\\\\\\\"form-input\\\\\\\"\\\\u003E\\\\u000a                        \\\\u003Clabel for=\\\\\\\"semail\\\\\\\"\\\\u003EFrom\\\\u003C/label\\\\u003E\\\\u003Cselect id=\\\\\\\"semail\\\\\\\" class=\\\\\\\"mail-input\\\\\\\" role=\\\\\\\"menu\\\\\\\" disabled\\\\u003E\\\\u003Coption role=\\\\\\\"menuitem\\\\\\\"\\\\u003ELoading...\\\\u003C/option\\\\u003E\\\\u003C/select\\\\u003E\\\\u000a                        \\\\u003Cdiv class=\\\\\\\"yom-mtf-semail-error icon-alert-small yui3-widget-hidden\\\\\\\"\\\\u003EPlease enter a valid email address\\\\u003C/div\\\\u003E\\\\u000a                    \\\\u003C/div\\\\u003E\\\\u000a                    \\\\u003Cdiv class=\\\\\\\"form-input\\\\\\\"\\\\u003E\\\\u000a                        \\\\u003Clabel for=\\\\\\\"remail\\\\\\\"\\\\u003ETo\\\\u003C/label\\\\u003E\\\\u003Cinput id=\\\\\\\"remail\\\\\\\" class=\\\\\\\"mail-input\\\\\\\" role=\\\\\\\"textbox\\\\\\\" disabled\\\\u003E\\\\u000a                        \\\\u003Cdiv class=\\\\\\\"yom-mtf-remail-error icon-alert-small yui3-widget-hidden\\\\\\\"\\\\u003EPlease enter valid email addresses, separated by commas\\\\u003C/div\\\\u003E\\\\u000a                        \\\\u003Cdiv class=\\\\\\\"yom-mtf-remail-max-error icon-alert-small yui3-widget-hidden\\\\\\\"\\\\u003EMaximum 200 character limit exceeded\\\\u003C/div\\\\u003E\\\\u000a                    \\\\u003C/div\\\\u003E\\\\u000a                    \\\\u003Cdiv class=\\\\\\\"form-input fb-import\\\\\\\"\\\\u003E\\\\u000a                        \\\\u003Clabel\\\\u003E&nbsp;\\\\u003C/label\\\\u003E\\\\u003Cspan\\\\u003EDon't see your Facebook contacts? \\\\u003Ca href=\\\\\\\"http://address.yahoo.com/?_src=neo&VPC=tools_import&.done=http://www.yahoo.com\\\\\\\" role=\\\\\\\"link\\\\\\\" target=\\\\\\\"_blank\\\\\\\" class=\\\\\\\"import\\\\\\\"\\\\u003EImport them\\\\u003C/a\\\\u003E\\\\u003C/span\\\\u003E\\\\u000a                    \\\\u003C/div\\\\u003E\\\\u000a                    \\\\u003Cdiv\\\\u003E\\\\u000a                        \\\\u003Ctextarea placeholder=\\\\\\\"Write a message\\\\\\\" class=\\\\\\\"mail-text\\\\\\\" role=\\\\\\\"textbox\\\\\\\" aria-multiline=\\\\\\\"true\\\\\\\"\\\\u003E\\\\u003C/textarea\\\\u003E \\\\u000a                        \\\\u003Cdiv class=\\\\\\\"yom-mtf-pmesg-error icon-alert-small yui3-widget-hidden\\\\\\\"\\\\u003EPlease enter a message\\\\u003C/div\\\\u003E\\\\u000a                    \\\\u003C/div\\\\u003E\\\\u000a                    \\\\u003Cdiv class=\\\\\\\"mail-article\\\\\\\"\\\\u003E\\\\u000a                        \\\\u003Cdiv class=\\\\\\\"article thumbnail\\\\\\\"\\\\u003E\\\\u000a                            \\\\u003Cimg title=\\\\\\\"Yahoo! News - Latest News &amp;amp; Headlines\\\\\\\"\\\\u003E\\\\u000a                        \\\\u003C/div\\\\u003E\\\\u000a                        \\\\u003Cdiv class=\\\\\\\"article\\\\\\\"\\\\u003E\\\\u000a                            \\\\u003Cdiv class=\\\\\\\"title\\\\\\\"\\\\u003EYahoo! News - Latest News &amp;amp; Headlines\\\\u003C/div\\\\u003E\\\\u000a                            \\\\u003Cdiv class=\\\\\\\"description\\\\\\\"\\\\u003EThe latest news and headlines from Yahoo! News. Get breaking news stories and in-depth coverage with videos and photos.\\\\u003C/div\\\\u003E\\\\u000a                        \\\\u003C/div\\\\u003E\\\\u000a                    \\\\u003C/div\\\\u003E\\\\u000a                    \\\\u003Cdiv class=\\\\\\\"mail-submit\\\\\\\"\\\\u003E\\\\u000a                        \\\\u003Cinput type=\\\\\\\"checkbox\\\\\\\" id=\\\\\\\"cc-self\\\\\\\" role=\\\\\\\"checkbox\\\\\\\"\\\\u003E\\\\u003Clabel for=\\\\\\\"cc-self\\\\\\\" class=\\\\\\\"cc-self\\\\\\\"\\\\u003ESend me a copy of this email\\\\u003C/label\\\\u003E\\\\u000a                        \\\\u003Cdiv class=\\\\\\\"submit-btns\\\\\\\"\\\\u003E\\\\u000a                            \\\\u003Cbutton class=\\\\\\\"mail-btn send\\\\\\\" role=\\\\\\\"button\\\\\\\" disabled\\\\u003ESend\\\\u003C/button\\\\u003E\\\\u000a                            \\\\u003Cbutton class=\\\\\\\"mail-btn close-btn\\\\\\\" role=\\\\\\\"button\\\\\\\"\\\\u003ECancel\\\\u003C/button\\\\u003E\\\\u000a                        \\\\u003C/div\\\\u003E\\\\u000a                        \\\\u003Cdiv class=\\\\\\\"clearfix\\\\\\\"\\\\u003E\\\\u003C/div\\\\u003E\\\\u000a                    \\\\u003C/div\\\\u003E\\\\u000a                \\\\u003C/div\\\\u003E\\\\u000a            \\\\u003C/div\\\\u003E\\\\u000a            \\\\u003Cdiv class=\\\\\\\"speedbump hide facebook\\\\\\\" role=\\\\\\\"dialog\\\\\\\" aria-labelledby=\\\\\\\"facebook\\\\\\\"\\\\u003Efacebook\\\\u003C/div\\\\u003E\\\\u000a            \\\\u003Cdiv class=\\\\\\\"speedbump hide twitter\\\\\\\" role=\\\\\\\"dialog\\\\\\\" aria-labelledby=\\\\\\\"twitter\\\\\\\"\\\\u003Etwitter\\\\u003C/div\\\\u003E\\\\u000a        \\\\u003C/div\\\\u003E\\\\u000a        \\\\u003Cdiv class=\\\\\\\"yui3-widget-ft\\\\\\\"\\\\u003E\\\\u003C/div\\\\u003E\\\\u000a    \\\\u003C/div\\\\u003E\\\\u000a\\\\u003C/div\\\\u003E\\\\u000a\\\"\\u000a        });\\u000a    });\\u000a});\\u000aYUI.Env.add(window, \\\"load\\\", function() {\\u000a    YMedia.use(\\\"media-rmp\\\", \\\"media-bc\\\", \\\"media-beacon-manager\\\", \\\"event-custom\\\", \\\"handlebars\\\", \\\"node-base\\\", \\\"media-nav-addon\\\", \\\"node-core\\\", \\\"node-data\\\", \\\"event-base\\\", \\\"node-event-delegate\\\", \\\"event-delegate\\\", \\\"event-tap\\\", \\\"media-tag-manager\\\", \\\"media-recommend\\\", \\\"media-personal-nav\\\", \\\"cookie\\\", \\\"querystring-parse\\\", \\\"media-strip\\\", \\\"media-trfsm\\\", \\\"base\\\", \\\"jsonp\\\", \\\"media-i13n\\\", \\\"media-ywa-tracking\\\", \\\"media-content-navigation-desktop\\\", \\\"overlay\\\", \\\"media-ad-ros\\\", \\\"media-footer\\\", function(Y) {\\u000a        Y.later(10, this, function() {\\u000a            Y.Array.each(YMedia.includes, function(inc, i, ar) {\\u000a                if (Y.Lang.isFunction(inc)) {\\u000a                    inc(Y);\\u000a                    ar[i] = null;\\u000a                }\\u000a            ;\\u000a            });\\u000a        });\\u000a        Y.later(10, this, function() {\\u000a            new Y.Media.BeaconManager({\\u000a                chrome: Y.Media.pageChrome\\u000a            });\\u000a        });\\u000a        Y.later(10, this, function() {\\u000a            new Y.Media.NavAddon({\\u000a                max: \\\"3\\\",\\u000a                chrome: Y.Media.pageChrome\\u000a            });\\u000a        });\\u000a        Y.later(10, this, function() {\\u000a            new Y.Media.Recommend({\\u000a                header: \\\"Recommended\\\",\\u000a                position: 1,\\u000a                chrome: Y.Media.pageChrome\\u000a            });\\u000a        });\\u000a        Y.later(10, this, function() {\\u000a            new Y.Media.PersonalNav({\\u000a                header: \\\"My Topics\\\",\\u000a                position: 2\\u000a            });\\u000a        });\\u000a        Y.later(10, this, function() {\\u000a            Y.Global.Media.ILBoot.initImageLoader(true);\\u000a        });\\u000a        Y.later(10, this, function() {\\u000a            (function() {\\u000a                var configUrl = \\\"http://l.yimg.com/os/assets/globalmedia/traffic/traffic-simulation.js\\\", simulator = new Y.Media.TrafficSimulator({\\u000a                    dataUrl: configUrl\\u000a                });\\u000a                simulator.load();\\u000a            })();\\u000a        });\\u000a        Y.later(10, this, function() {\\u000a            try {\\u000a                YMEDIA_REQ_ATTR.csbeacon();\\u000a            } catch (e) {\\u000a            \\u000a            };\\u000a        });\\u000a        Y.later(10, this, function() {\\u000a            new Y.Media.ContentNavigation({\\u000a                config: {\\u000a                    modId: \\\"mediacontentnavigation\\\"\\u000a                },\\u000a                chrome: Y.Media.pageChrome\\u000a            });\\u000a        });\\u000a        Y.later(10, this, function() {\\u000a            Y.Media.Lead.MediaContentLead.init({\\u000a                cat: \\\"\\\",\\u000a                catName: \\\"\\\",\\u000a                \\\"listid \\\": \\\"\\\"\\u000a            });\\u000a        });\\u000a        Y.later(10, this, function() {\\u000a            Y.Media.Comic.MediaContentComic.init({\\u000a                meta: {\\u000a                    error: {\\u000a                        error_code: 0\\u000a                    },\\u000a                    mod_id: \\\"mediacontentcomic\\\",\\u000a                    bucket: null,\\u000a                    selected_list: \\\"92df5b73-9c06-3216-9539-45edc1a84bfa\\\",\\u000a                    selected_name: \\\"Andy Capp\\\",\\u000a                    abbreviation: \\\"crcap\\\",\\u000a                    max_result_count: 14,\\u000a                    start: 0,\\u000a                    count: 14,\\u000a                    total: 95,\\u000a                    alias: \\\"/comics/andy-capp-slideshow/\\\",\\u000a                    enableLightBox: 0\\u000a                },\\u000a                data: {\\u000a                    \\\"92df5b73-9c06-3216-9539-45edc1a84bfa\\\": [{\\u000a                        src: \\\"http://l2.yimg.com/bt/api/res/1.2/uhTcIm0OGqDTd1qtuyiVHQ--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE2OTtweW9mZj0wO3E9ODU7dz02MDA-/http://media.zenfs.com/en_us/News/ucomics.com/crcap130710.gif\\\",\\u000a                        rsrc: \\\"http://l2.yimg.com/bt/api/res/1.2/bbvN0UJx2GpIp_uEggkMQQ--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTEwMjtweW9mZj0wO3E9ODU7dz0zNjQ-/http://media.zenfs.com/en_us/News/ucomics.com/crcap130710.gif\\\",\\u000a                        sdate: \\\"Wed, Jul 10\\\",\\u000a                        date: \\\"Wednesday, July 10\\\"\\u000a                    },{\\u000a                        src: \\\"http://l.yimg.com/bt/api/res/1.2/ejRT5kGg9EhhabqhJeCFUw--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE2OTtweW9mZj0wO3E9ODU7dz02MDA-/http://media.zenfs.com/en_us/News/ucomics.com/crcap130709.gif\\\",\\u000a                        rsrc: \\\"http://l1.yimg.com/bt/api/res/1.2/R52PN4koEPVG6RlHCrZM5w--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTEwMjtweW9mZj0wO3E9ODU7dz0zNjQ-/http://media.zenfs.com/en_us/News/ucomics.com/crcap130709.gif\\\",\\u000a                        sdate: \\\"Tue, Jul 9\\\",\\u000a                        date: \\\"Tuesday, July 9\\\"\\u000a                    },{\\u000a                        src: \\\"http://l3.yimg.com/bt/api/res/1.2/T.VjgD2kZmwtsZLCYq58Bw--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE2NztweW9mZj0wO3E9ODU7dz02MDA-/http://media.zenfs.com/en_us/News/ucomics.com/crcap130708.gif\\\",\\u000a                        rsrc: \\\"http://l.yimg.com/bt/api/res/1.2/AQsZOu7M1A4OPLVohVfnPw--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTEwMTtweW9mZj0wO3E9ODU7dz0zNjQ-/http://media.zenfs.com/en_us/News/ucomics.com/crcap130708.gif\\\",\\u000a                        sdate: \\\"Mon, Jul 8\\\",\\u000a                        date: \\\"Monday, July 8\\\"\\u000a                    },{\\u000a                        src: \\\"http://l3.yimg.com/bt/api/res/1.2/vEgdLI0YlpWnMqyG2a3f8A--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTI5NTtweW9mZj0wO3E9ODU7dz02MDA-/http://media.zenfs.com/en_us/News/ucomics.com/crcap130707.jpg\\\",\\u000a                        rsrc: \\\"http://l3.yimg.com/bt/api/res/1.2/ScNgEmRCMk_IA3QPke6KBQ--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE3ODtweW9mZj0wO3E9ODU7dz0zNjQ-/http://media.zenfs.com/en_us/News/ucomics.com/crcap130707.jpg\\\",\\u000a                        sdate: \\\"Sun, Jul 7\\\",\\u000a                        date: \\\"Sunday, July 7\\\"\\u000a                    },{\\u000a                        src: \\\"http://l2.yimg.com/bt/api/res/1.2/WqvGZ3HkRWFIQ8e57rFubQ--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE2NztweW9mZj0wO3E9ODU7dz02MDA-/http://media.zenfs.com/en_us/News/ucomics.com/crcap130706.gif\\\",\\u000a                        rsrc: \\\"http://l.yimg.com/bt/api/res/1.2/VPtfwBlN9rxXr3jVq8C4iA--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTEwMTtweW9mZj0wO3E9ODU7dz0zNjQ-/http://media.zenfs.com/en_us/News/ucomics.com/crcap130706.gif\\\",\\u000a                        sdate: \\\"Sat, Jul 6\\\",\\u000a                        date: \\\"Saturday, July 6\\\"\\u000a                    },{\\u000a                        src: \\\"http://l2.yimg.com/bt/api/res/1.2/a5kYphyMeoSHhPKhcxEDZg--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE2NztweW9mZj0wO3E9ODU7dz02MDA-/http://media.zenfs.com/en_us/News/ucomics.com/crcap130705.gif\\\",\\u000a                        rsrc: \\\"http://l1.yimg.com/bt/api/res/1.2/hlYQCS5sUa.dMuD3Xb7Qfw--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTEwMTtweW9mZj0wO3E9ODU7dz0zNjQ-/http://media.zenfs.com/en_us/News/ucomics.com/crcap130705.gif\\\",\\u000a                        sdate: \\\"Fri, Jul 5\\\",\\u000a                        date: \\\"Friday, July 5\\\"\\u000a                    },{\\u000a                        src: \\\"http://l2.yimg.com/bt/api/res/1.2/9VOrfbDqdNECeAo854fxsQ--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE2NztweW9mZj0wO3E9ODU7dz02MDA-/http://media.zenfs.com/en_us/News/ucomics.com/crcap130704.gif\\\",\\u000a                        rsrc: \\\"http://l3.yimg.com/bt/api/res/1.2/RRmi4XsDqJ5kRo1fLYxugg--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTEwMTtweW9mZj0wO3E9ODU7dz0zNjQ-/http://media.zenfs.com/en_us/News/ucomics.com/crcap130704.gif\\\",\\u000a                        sdate: \\\"Thu, Jul 4\\\",\\u000a                        date: \\\"Thursday, July 4\\\"\\u000a                    },{\\u000a                        src: \\\"http://l1.yimg.com/bt/api/res/1.2/wddGiTLxO4o3oKWe0vjmkQ--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE2ODtweW9mZj0wO3E9ODU7dz02MDA-/http://media.zenfs.com/en_us/News/ucomics.com/crcap130703.gif\\\",\\u000a                        rsrc: \\\"http://l3.yimg.com/bt/api/res/1.2/tCt4UGTs0jx5_3fxZQTHpA--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTEwMTtweW9mZj0wO3E9ODU7dz0zNjQ-/http://media.zenfs.com/en_us/News/ucomics.com/crcap130703.gif\\\",\\u000a                        sdate: \\\"Wed, Jul 3\\\",\\u000a                        date: \\\"Wednesday, July 3\\\"\\u000a                    },{\\u000a                        src: \\\"http://l1.yimg.com/bt/api/res/1.2/rx5IZdGFJXxE1XeSPnthrw--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE2NztweW9mZj0wO3E9ODU7dz02MDA-/http://media.zenfs.com/en_us/News/ucomics.com/crcap130702.gif\\\",\\u000a                        rsrc: \\\"http://l3.yimg.com/bt/api/res/1.2/U5l608wGdMuWvH4wWLSOWA--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTEwMTtweW9mZj0wO3E9ODU7dz0zNjQ-/http://media.zenfs.com/en_us/News/ucomics.com/crcap130702.gif\\\",\\u000a                        sdate: \\\"Tue, Jul 2\\\",\\u000a                        date: \\\"Tuesday, July 2\\\"\\u000a                    },{\\u000a                        src: \\\"http://l2.yimg.com/bt/api/res/1.2/QPLmjGjpBQGM.GgILcPVAw--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE2ODtweW9mZj0wO3E9ODU7dz02MDA-/http://media.zenfs.com/en_us/News/ucomics.com/crcap130701.gif\\\",\\u000a                        rsrc: \\\"http://l1.yimg.com/bt/api/res/1.2/yVcqJx_KJgeZ3t5USnC3sA--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTEwMTtweW9mZj0wO3E9ODU7dz0zNjQ-/http://media.zenfs.com/en_us/News/ucomics.com/crcap130701.gif\\\",\\u000a                        sdate: \\\"Mon, Jul 1\\\",\\u000a                        date: \\\"Monday, July 1\\\"\\u000a                    },{\\u000a                        src: \\\"http://l1.yimg.com/bt/api/res/1.2/a0iI_iYIo5aaG1hytGz5Gg--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTI5NTtweW9mZj0wO3E9ODU7dz02MDA-/http://media.zenfs.com/en_us/News/ucomics.com/crcap130630.jpg\\\",\\u000a                        rsrc: \\\"http://l1.yimg.com/bt/api/res/1.2/7PeEGrxpeBxuJDKqoa0XOw--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE3ODtweW9mZj0wO3E9ODU7dz0zNjQ-/http://media.zenfs.com/en_us/News/ucomics.com/crcap130630.jpg\\\",\\u000a                        sdate: \\\"Sun, Jun 30\\\",\\u000a                        date: \\\"Sunday, June 30\\\"\\u000a                    },{\\u000a                        src: \\\"http://l2.yimg.com/bt/api/res/1.2/TKLpO.JWeRvUaCs0R4gkyQ--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE3MTtweW9mZj0wO3E9ODU7dz02MDA-/http://media.zenfs.com/en_us/News/ucomics.com/crcap130629.gif\\\",\\u000a                        rsrc: \\\"http://l1.yimg.com/bt/api/res/1.2/vVbmNO317LvN7FJPH4xwuw--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTEwMztweW9mZj0wO3E9ODU7dz0zNjQ-/http://media.zenfs.com/en_us/News/ucomics.com/crcap130629.gif\\\",\\u000a                        sdate: \\\"Sat, Jun 29\\\",\\u000a                        date: \\\"Saturday, June 29\\\"\\u000a                    },{\\u000a                        src: \\\"http://l2.yimg.com/bt/api/res/1.2/xq7OBjHfLnmWYAXbvk4oPA--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE2NztweW9mZj0wO3E9ODU7dz02MDA-/http://media.zenfs.com/en_us/News/ucomics.com/crcap130628.gif\\\",\\u000a                        rsrc: \\\"http://l2.yimg.com/bt/api/res/1.2/ARnYiJhuR4_GsUZ47t.11w--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTEwMTtweW9mZj0wO3E9ODU7dz0zNjQ-/http://media.zenfs.com/en_us/News/ucomics.com/crcap130628.gif\\\",\\u000a                        sdate: \\\"Fri, Jun 28\\\",\\u000a                        date: \\\"Friday, June 28\\\"\\u000a                    },{\\u000a                        src: \\\"http://l2.yimg.com/bt/api/res/1.2/crH10YK705dn8aXAWV8GEg--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE2ODtweW9mZj0wO3E9ODU7dz02MDA-/http://media.zenfs.com/en_us/News/ucomics.com/crcap130627.gif\\\",\\u000a                        rsrc: \\\"http://l2.yimg.com/bt/api/res/1.2/OWpgHCEZnzuUV_d9WteS8Q--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTEwMTtweW9mZj0wO3E9ODU7dz0zNjQ-/http://media.zenfs.com/en_us/News/ucomics.com/crcap130627.gif\\\",\\u000a                        sdate: \\\"Thu, Jun 27\\\",\\u000a                        date: \\\"Thursday, June 27\\\"\\u000a                    },]\\u000a                }\\u000a            });\\u000a        });\\u000a        Y.later(10, this, function() {\\u000a            window.dmRosAds.insertMultiAd({\\u000a                dmRosAdConfig: \\\"e5879714\\\",\\u000a                dmRosAdTypeTag: \\\"default\\\",\\u000a                dmRosAdSlotInfo: [{\\u000a                    dmRosAdSlotId: \\\"east\\\",\\u000a                    dmRosAdDivId: \\\"dmRosAdWrapper-east\\\",\\u000a                    dmRosAdWidth: \\\"300\\\",\\u000a                    dmRosAdHeight: \\\"300\\\"\\u000a                },]\\u000a            });\\u000a        });\\u000a        Y.later(10, this, function() {\\u000a            if (Y.Media.Footer) {\\u000a                var footer = Y.Media.Footer(Y, {\\u000a                    footerInfoSelector: \\\"#footer-info\\\",\\u000a                    currentDeviceType: \\\"full\\\",\\u000a                    projectId: \\\"10001393120079\\\",\\u000a                    enableYwaTracking: \\\"0\\\"\\u000a                })\\u000a            };\\u000a        });\\u000a    });\\u000a});\"), (\"s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    ((JSBNG_Record.set)(YUI, (\"YUICfg\"), {\n        gallery: \"gallery-2011.04.20-13-04\",\n        groups: {\n            group01c9d8dea06e05460a64eed4dadd622b6: {\n                base: \"http://l.yimg.com/\",\n                comboBase: \"http://l.yimg.com/zz/combo?\",\n                modules: {\n                    \"media-request-manager\": {\n                        path: \"os/mit/media/p/content/request-manager-min-1334113.js\"\n                    },\n                    \"media-content-manager\": {\n                        path: \"os/mit/media/p/content/content-manager-min-1331468.js\"\n                    },\n                    \"media-perf-timeable\": {\n                        path: \"os/mit/media/p/content/perf-timeable-min-1191658.js\"\n                    },\n                    \"media-ad-controller\": {\n                        path: \"os/mit/media/p/content/ad-controller-min-1334238.js\"\n                    },\n                    \"media-pane-manager\": {\n                        path: \"os/mit/media/p/content/pane-manager-min-1343260.js\"\n                    },\n                    \"media-next-scroll\": {\n                        path: \"os/mit/media/p/content/next-scroll-min-1304262.js\"\n                    },\n                    \"media-tag-manager\": {\n                        path: \"os/mit/media/p/content/tag-manager-min-1294559.js\"\n                    },\n                    \"media-content-discoverer\": {\n                        path: \"os/mit/media/p/content/content-discoverer-min-1331680.js\"\n                    },\n                    \"media-interest-manager\": {\n                        path: \"os/mit/media/p/content/interest-manager-min-1306018.js\"\n                    },\n                    \"media-instrumentation\": {\n                        path: \"os/mit/media/p/content/instrumentation-min-1214752.js\"\n                    },\n                    \"media-content-ss-base\": {\n                        path: \"os/mit/media/m/content_photo/content-ss-base-min-1330613.js\"\n                    },\n                    \"media-content-ss-no-sv\": {\n                        path: \"os/mit/media/m/content_photo/content-ss-no-sv-min-1328161.js\"\n                    },\n                    \"media-carousel\": {\n                        path: \"os/mit/media/m/content_photo/carousel-min-1308638.js\"\n                    },\n                    \"media-lead\": {\n                        path: \"os/mit/media/m/content_index/lead-min-1306566.js\"\n                    },\n                    \"media-comic\": {\n                        path: \"os/mit/media/m/content_index/comic-min-1262759.js\"\n                    },\n                    \"media-content-social-base\": {\n                        path: \"os/mit/media/m/content_social/content-social-base-min-1339203.js\"\n                    },\n                    \"media-content-email-autocomplete\": {\n                        path: \"os/mit/media/m/content_social/content-email-autocomplete-min-1306078.js\"\n                    },\n                    \"media-content-share-buttons\": {\n                        path: \"os/mit/media/m/content_social/content-share-buttons-min-1339400.js\"\n                    },\n                    \"media-content-share-buttons-builder\": {\n                        path: \"os/mit/media/m/content_social/content-share-buttons-builder-min-1337341.js\"\n                    },\n                    \"media-bc\": {\n                        path: \"d/lib/bc/bc_2.0.5.js\"\n                    },\n                    \"media-beacon-manager\": {\n                        path: \"os/mit/media/p/content/beacon-manager-min-1333171.js\"\n                    },\n                    \"media-nav-addon\": {\n                        path: \"os/mit/media/m/navigation/nav-addon-min-1270754.js\"\n                    },\n                    \"media-recommend\": {\n                        path: \"os/mit/media/p/content/recommend-min-1277359.js\"\n                    },\n                    \"media-personal-nav\": {\n                        path: \"os/mit/media/p/content/personal-nav-min-1318968.js\"\n                    },\n                    \"media-strip\": {\n                        path: \"ss/strip_3.2.js\"\n                    },\n                    \"media-trfsm\": {\n                        path: \"os/mit/media/p/common/trfsm-min-797026.js\"\n                    },\n                    \"media-i13n\": {\n                        path: \"os/mit/media/p/common/i13n-min-1154367.js\"\n                    },\n                    \"media-ywa-tracking\": {\n                        path: \"os/mit/media/p/common/ywa-tracking-min-1234794.js\"\n                    },\n                    \"media-content-navigation-desktop\": {\n                        path: \"os/mit/media/m/navigation/content-navigation-desktop-min-1318647.js\"\n                    },\n                    \"media-footer\": {\n                        path: \"os/mit/media/m/footer/footer-min-923366.js\"\n                    }\n                },\n                combine: true,\n                filter: \"min\",\n                root: \"/\"\n            }\n        },\n        modules: {\n            \"media-ad-ros\": {\n                fullpath: \"http://ads.yimg.com/qq/dm/ad-ros-0.0.2.js\"\n            }\n        },\n        combine: true,\n        allowRollup: true,\n        comboBase: \"http://l.yimg.com/zz/combo?\",\n        maxURLLength: \"2000\"\n    }));\n    ((JSBNG_Record.set)((((JSBNG_Record.get)(YUI, (\"YUICfg\")))[(\"YUICfg\")]), (\"root\"), ((\"yui:\" + (((JSBNG_Record.get)(YUI, (\"version\")))[(\"version\")])) + \"/build/\")));\n    (((JSBNG_Record.get)(YMedia, (\"applyConfig\")))[(\"applyConfig\")])((((JSBNG_Record.get)(YUI, (\"YUICfg\")))[(\"YUICfg\")]));\n    ((JSBNG_Record.set)((((JSBNG_Record.get)((((JSBNG_Record.get)((((JSBNG_Record.get)((((JSBNG_Record.get)(YUI, (\"Env\")))[(\"Env\")]), ((JSBNG_Record.temps.tea0fff04e245add475ca4aceb59d403274f120f2) = (((JSBNG_Record.get)(YUI, (\"version\")))[(\"version\")]))))[(JSBNG_Record.temps.tea0fff04e245add475ca4aceb59d403274f120f2)]), (\"groups\")))[(\"groups\")]), (\"gallery\")))[(\"gallery\")]), (\"root\"), \"yui:gallery-2011.04.20-13-04/build/\"));\n    (((JSBNG_Record.get)(YMedia, (\"use\")))[(\"use\")])(\"media-request-manager\", \"media-content-manager\", \"media-perf-timeable\", \"node-scroll-info\", \"event-custom\", \"media-ad-controller\", \"app-base\", \"querystring-parse\", \"media-rmp\", \"media-pane-manager\", \"node-base\", \"event-touch\", \"media-next-scroll\", \"media-next-scroll\", \"event-mouseenter\", \"media-tag-manager\", \"media-tag-manager\", \"media-content-discoverer\", \"history-base\", \"media-interest-manager\", \"io-base\", \"json-parse\", \"media-instrumentation\", \"media-content-ss-base\", \"media-content-ss-no-sv\", \"node-base\", \"event-key\", \"media-carousel\", \"base\", \"json-parse\", \"querystring-stringify\", \"media-lead\", \"media-comic\", \"autocomplete\", \"autocomplete-highlighters\", \"event-base\", \"event-custom\", \"node-core\", \"io\", \"querystring\", \"overlay\", \"json\", \"gallery-node-tokeninput\", \"querystring-stringify-simple\", \"gallery-outside-events\", \"media-content-social-base\", \"media-content-email-autocomplete\", \"media-content-social-base\", \"media-content-email-autocomplete\", \"media-content-share-buttons\", \"JSBNG__event\", \"node\", \"media-content-share-buttons-builder\", ((function() {\n        var s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_0_instance;\n        ((s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_0_instance) = ((JSBNG_Record.eventInstance)((\"s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_0\"))));\n        return ((JSBNG_Record.markFunction)((function(Y) {\n            if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                return ((JSBNG_Record.eventCall)((arguments.callee), (\"s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_0\"), (s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_0_instance), (this), (arguments)))\n            };\n            (null);\n            (((JSBNG_Record.get)(Y, (\"later\")))[(\"later\")])(10, this, ((function() {\n                var s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_1_instance;\n                ((s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_1_instance) = ((JSBNG_Record.eventInstance)((\"s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_1\"))));\n                return ((JSBNG_Record.markFunction)((function() {\n                    if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                        return ((JSBNG_Record.eventCall)((arguments.callee), (\"s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_1\"), (s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_1_instance), (this), (arguments)))\n                    };\n                    (null);\n                    ((JSBNG_Record.set)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"adController\"), new (((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"AdController\")))[(\"AdController\")])({\n                        env: \"prod\",\n                        hideOnFailure: false,\n                        fetchOnPjaxOnly: true,\n                        preserveLRECContainer: false\n                    })));\n                })));\n            })()));\n            (((JSBNG_Record.get)(Y, (\"later\")))[(\"later\")])(10, this, ((function() {\n                var s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_2_instance;\n                ((s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_2_instance) = ((JSBNG_Record.eventInstance)((\"s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_2\"))));\n                return ((JSBNG_Record.markFunction)((function() {\n                    if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                        return ((JSBNG_Record.eventCall)((arguments.callee), (\"s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_2\"), (s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_2_instance), (this), (arguments)))\n                    };\n                    (null);\n                    ((JSBNG_Record.set)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"requestManager\"), (((JSBNG_Record.get)(new (((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"RequestManager\")))[(\"RequestManager\")])({\n                        chrome: (((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"pageChrome\")))[(\"pageChrome\")]),\n                        linkSelector: \"a:not(.no-pjax)\",\n                        unsuppBrowsers: \"\",\n                        continueOnError: \"1\",\n                        pjaxSplit: \"0\",\n                        ignoreCssErrors: \"1\"\n                    }), (\"render\")))[(\"render\")])()));\n                })));\n            })()));\n            (((JSBNG_Record.get)(Y, (\"later\")))[(\"later\")])(10, this, ((function() {\n                var s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_3_instance;\n                ((s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_3_instance) = ((JSBNG_Record.eventInstance)((\"s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_3\"))));\n                return ((JSBNG_Record.markFunction)((function() {\n                    if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                        return ((JSBNG_Record.eventCall)((arguments.callee), (\"s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_3\"), (s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_3_instance), (this), (arguments)))\n                    };\n                    (null);\n                    new (((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"ContentManager\")))[(\"ContentManager\")])({\n                        nodePaths: {\n                            JSBNG__content: \"#yog-content\",\n                            navigation: \"#yog-nav .navlist\",\n                            related: \"#yog-related\",\n                            superlead: \"#yog-stage\"\n                        },\n                        transition: {\n                            style: \"fade\"\n                        }\n                    });\n                })));\n            })()));\n            (((JSBNG_Record.get)(Y, (\"later\")))[(\"later\")])(10, this, ((function() {\n                var s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_4_instance;\n                ((s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_4_instance) = ((JSBNG_Record.eventInstance)((\"s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_4\"))));\n                return ((JSBNG_Record.markFunction)((function() {\n                    if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                        return ((JSBNG_Record.eventCall)((arguments.callee), (\"s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_4\"), (s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_4_instance), (this), (arguments)))\n                    };\n                    (null);\n                    ((JSBNG_Record.set)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"pagePaneManager\"), new (((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"PaneManager\")))[(\"PaneManager\")])({\n                        debug: 0,\n                        grid_type: {\n                            JSBNG__content: {\n                                scroll_mode: \"bandit\"\n                            },\n                            index: {\n                                scroll_mode: \"bandit\"\n                            }\n                        },\n                        isYnet: 0\n                    })));\n                })));\n            })()));\n            (((JSBNG_Record.get)(Y, (\"later\")))[(\"later\")])(10, this, ((function() {\n                var s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_5_instance;\n                ((s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_5_instance) = ((JSBNG_Record.eventInstance)((\"s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_5\"))));\n                return ((JSBNG_Record.markFunction)((function() {\n                    if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                        return ((JSBNG_Record.eventCall)((arguments.callee), (\"s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_5\"), (s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_5_instance), (this), (arguments)))\n                    };\n                    (null);\n                    new (((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"TagManager\")))[(\"TagManager\")])();\n                })));\n            })()));\n            (((JSBNG_Record.get)(Y, (\"later\")))[(\"later\")])(10, this, ((function() {\n                var s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_6_instance;\n                ((s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_6_instance) = ((JSBNG_Record.eventInstance)((\"s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_6\"))));\n                return ((JSBNG_Record.markFunction)((function() {\n                    if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                        return ((JSBNG_Record.eventCall)((arguments.callee), (\"s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_6\"), (s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_6_instance), (this), (arguments)))\n                    };\n                    (null);\n                    new (((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"ContentDiscoverer\")))[(\"ContentDiscoverer\")])({\n                        enableLightboxOnStream: \"1\"\n                    });\n                })));\n            })()));\n            (((JSBNG_Record.get)(Y, (\"later\")))[(\"later\")])(10, this, ((function() {\n                var s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_7_instance;\n                ((s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_7_instance) = ((JSBNG_Record.eventInstance)((\"s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_7\"))));\n                return ((JSBNG_Record.markFunction)((function() {\n                    if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                        return ((JSBNG_Record.eventCall)((arguments.callee), (\"s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_7\"), (s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_7_instance), (this), (arguments)))\n                    };\n                    (null);\n                    new (((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"InterestManager\")))[(\"InterestManager\")])({\n                    });\n                })));\n            })()));\n            (((JSBNG_Record.get)(Y, (\"later\")))[(\"later\")])(10, this, ((function() {\n                var s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_8_instance;\n                ((s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_8_instance) = ((JSBNG_Record.eventInstance)((\"s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_8\"))));\n                return ((JSBNG_Record.markFunction)((function() {\n                    if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                        return ((JSBNG_Record.eventCall)((arguments.callee), (\"s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_8\"), (s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_8_instance), (this), (arguments)))\n                    };\n                    (null);\n                    new (((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"Instrumentation\")))[(\"Instrumentation\")])();\n                })));\n            })()));\n            (((JSBNG_Record.get)(Y, (\"later\")))[(\"later\")])(10, this, ((function() {\n                var s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_9_instance;\n                ((s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_9_instance) = ((JSBNG_Record.eventInstance)((\"s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_9\"))));\n                return ((JSBNG_Record.markFunction)((function() {\n                    if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                        return ((JSBNG_Record.eventCall)((arguments.callee), (\"s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_9\"), (s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_9_instance), (this), (arguments)))\n                    };\n                    (null);\n                    new (((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"ContentSSNoSV\")))[(\"ContentSSNoSV\")])({\n                        chrome: (((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"pageChrome\")))[(\"pageChrome\")]),\n                        config: {\n                            modId: \"\",\n                            setupSlideshowCover: \"false\",\n                            enableCarousel: \"1\",\n                            enableEndSlideRel: \"0\",\n                            enableEndSlideMP: \"1\",\n                            strings: {\n                                more: \"more\",\n                                less: \"less\",\n                                of: \"of\"\n                            }\n                        }\n                    });\n                })));\n            })()));\n            (((JSBNG_Record.get)(Y, (\"later\")))[(\"later\")])(10, this, ((function() {\n                var s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_10_instance;\n                ((s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_10_instance) = ((JSBNG_Record.eventInstance)((\"s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_10\"))));\n                return ((JSBNG_Record.markFunction)((function() {\n                    if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                        return ((JSBNG_Record.eventCall)((arguments.callee), (\"s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_10\"), (s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_10_instance), (this), (arguments)))\n                    };\n                    (null);\n                    ((JSBNG_Record.set)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"shareButtonsBuilder\"), new (((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"ContentShareButtonsBuilder\")))[(\"ContentShareButtonsBuilder\")])({\n                        modNode: \"\",\n                        switches: {\n                            mtf: true,\n                            cmt: false\n                        },\n                        loginStat: {\n                            yahoo: 0\n                        },\n                        data: {\n                            mtfRedirUrl: \"http%3A%2F%2Fnews.yahoo.com%2F_xhr%2Fmediacontentsharebuttons%2Fpostshare%2F%3Fsrc%3Dmail\"\n                        },\n                        pageData: {\n                            crumb: \"\",\n                            title: \"\",\n                            summary: \"\",\n                            thumbnail: \"\",\n                            url: \"\",\n                            locale: \"US\",\n                            prop: \"news\",\n                            content_id: \"5f01278b-803a-3803-9798-7fc79bab4f7d\",\n                            ult__S: \"81121452\",\n                            ult_ct: \"\",\n                            ult_pkg: \"5f01278b-803a-3803-9798-7fc79bab4f7d\",\n                            ult_test: null,\n                            ult_csrcpvid: \"FSr0xQrHg2.G2dUfMOsImwDQDEeLIlHdqicAC52y\",\n                            ult_sec: \"mit_share\",\n                            ult_slk: \"mail\",\n                            ult_mpos: 1,\n                            ult_lang: \"en-US\",\n                            ult_act: \"mail\",\n                            ult_pstaid: \"5f01278b-803a-3803-9798-7fc79bab4f7d\"\n                        },\n                        contentMetaData: {\n                            id: \"5f01278b-803a-3803-9798-7fc79bab4f7d\",\n                            url_orig: \"\",\n                            title_orig: \"\",\n                            summary: \"\",\n                            type: \"homepage\"\n                        },\n                        config: {\n                            site: \"news\",\n                            lang: \"en-US\",\n                            region: \"US\",\n                            scrumb: false\n                        },\n                        template: \"\\u003Cdiv class=\\\"yom-share-btns-container light\\\"\\u003E\\u000a    \\u003Cdiv class=\\\"share-btns\\\" role=\\\"menu\\\"\\u003E\\u000a        \\u003Cdiv class=\\\"share-btns-wrap\\\"\\u003E\\u000a            \\u003Cdiv class=\\\"share-btn-wrap\\\"\\u003E\\u000a                \\u003Cul\\u003E\\u003Cli class=\\\"share-btn facebook\\\"\\u003E\\u000a                        \\u003Ca href=\\\"http://www.facebook.com/dialog/feed?app_id=90376669494&amp;redirect_uri=http://news.yahoo.com/_xhr/mediacontentsharebuttons/postshare/?src=fb&amp;link=http://news.yahoo.com/&amp;picture=http://l2.yimg.com/bt/api/res/1.2/BvlRk2eMuZ5S5ZVts0i.Uw--/YXBwaWQ9eW5ld3M7cT04NTt3PTYwMA--/http://l.yimg.com/os/publish-images/news/2013-03-19/528dd2af-804a-4db8-b6eb-53b18b9b0592_ybang_225x225.png&amp;display=popup&amp;show_error=yes\\\" role=\\\"link\\\" title=\\\"share\\\" target=\\\"_blank\\\" data-ylk=\\\"sec:mod-sh-b;slk:btn-sh-fb;itc:1;test:;\\\" data-action-outcome=\\\"share\\\"\\u003E\\u003Cspan class=\\\"btn-icon btn-fb\\\"\\u003E\\u003C/span\\u003E\\u003Cspan class=\\\"btn-count hide\\\"\\u003E0\\u003C/span\\u003E\\u003C/a\\u003E\\u000a                    \\u003C/li\\u003E\\u003Cli class=\\\"share-btn twitter\\\"\\u003E\\u000a                        \\u003Ca href=\\\"https://twitter.com/share?text=Yahoo%21%20News%20-%20Latest%20News%20%26%20Headlines&amp;url=http://news.yahoo.com/&amp;via=YahooNews\\\" role=\\\"link\\\" title=\\\"tweet\\\" target=\\\"_blank\\\" data-ylk=\\\"sec:mod-sh-b;slk:btn-sh-tw;itc:1;test:;\\\" data-action-outcome=\\\"share\\\"\\u003E\\u003Cspan class=\\\"btn-icon btn-tw\\\"\\u003E\\u003C/span\\u003E\\u003Cspan class=\\\"btn-count hide\\\"\\u003E0\\u003C/span\\u003E\\u003C/a\\u003E\\u000a                    \\u003C/li\\u003E\\u003Cli class=\\\"share-btn tumblr\\\"\\u003E\\u000a                        \\u003Ca href=\\\"http://www.tumblr.com/share/link?url=http%3A%2F%2Fnews.yahoo.com%2F&description=The%20latest%20news%20and%20headlines%20from%20Yahoo%21%20News.%20Get%20breaking%20news%20stories%20and%20in-depth%20coverage%20with%20videos%20and%20photos.&name=Yahoo%21%20News%20-%20Latest%20News%20%26amp%3B%20Headlines\\\" role=\\\"link\\\" title=\\\"tumblr\\\" target=\\\"_blank\\\" data-ylk=\\\"sec:mod-sh-b;slk:btn-sh-tu;itc:1;test:;\\\" data-action-outcome=\\\"share\\\"\\u003E\\u003Cspan class=\\\"btn-icon btn-tu\\\"\\u003E\\u003C/span\\u003E\\u003Cspan class=\\\"btn-count hide\\\"\\u003E\\u003C/span\\u003E\\u003C/a\\u003E\\u000a                    \\u003C/li\\u003E\\u003Cli class=\\\"share-btn pinterest\\\"\\u003E\\u000a                        \\u003Ca href=\\\"http://pinterest.com/pin/create/button/?url=http%3A%2F%2Fnews.yahoo.com%2F&description=The%20latest%20news%20and%20headlines%20from%20Yahoo%21%20News.%20Get%20breaking%20news%20stories%20and%20in-depth%20coverage%20with%20videos%20and%20photos.&media=http://l2.yimg.com/bt/api/res/1.2/BvlRk2eMuZ5S5ZVts0i.Uw--/YXBwaWQ9eW5ld3M7cT04NTt3PTYwMA--/http://l.yimg.com/os/publish-images/news/2013-03-19/528dd2af-804a-4db8-b6eb-53b18b9b0592_ybang_225x225.png\\\" role=\\\"link\\\" title=\\\"pinterest\\\" target=\\\"_blank\\\" data-ylk=\\\"sec:mod-sh-b;slk:btn-sh-pin;itc:1;test:;\\\" data-action-outcome=\\\"share\\\"\\u003E\\u003Cspan class=\\\"btn-icon btn-pin\\\"\\u003E\\u003C/span\\u003E\\u003Cspan class=\\\"btn-count hide\\\"\\u003E\\u003C/span\\u003E\\u003C/a\\u003E\\u000a                    \\u003C/li\\u003E\\u003Cli class=\\\"share-btn mail email\\\"\\u003E\\u000a                        \\u003Ca href=\\\"mailto:?subject=Yahoo%21%20News%20-%20Latest%20News%20%26amp%3B%20Headlines&amp;body=http%3A%2F%2Fnews.yahoo.com%2F\\\" role=\\\"link\\\" title=\\\"email\\\" data-ylk=\\\"sec:mod-sh-b;slk:btn-sh-ma;itc:1;test:;\\\" data-action-outcome=\\\"share\\\"\\u003E\\u003Cspan class=\\\"btn-icon btn-mail\\\"\\u003E\\u003C/span\\u003E\\u003Cspan class=\\\"btn-count hide\\\"\\u003E0\\u003C/span\\u003E\\u003C/a\\u003E\\u000a                    \\u003C/li\\u003E\\u000a                \\u003C/ul\\u003E\\u000a            \\u003C/div\\u003E\\u000a            \\u003Cdiv class=\\\"clearfix\\\"\\u003E\\u003C/div\\u003E\\u000a        \\u003C/div\\u003E\\u000a    \\u003C/div\\u003E\\u000a    \\u003Cdiv class=\\\"share-btns-overlay-screen hide\\\"\\u003E\\u003C/div\\u003E\\u000a    \\u003Cdiv class=\\\"share-btns-overlay hide\\\"\\u003E\\u000a        \\u003Cdiv class=\\\"yui3-widget-hd\\\"\\u003E\\u000a            \\u003Cdiv class=\\\"close-btn\\\" role=\\\"button\\\"\\u003E&times;\\u003C/div\\u003E\\u000a        \\u003C/div\\u003E\\u000a        \\u003Cdiv class=\\\"yui3-widget-bd\\\"\\u003E\\u000a            \\u003Cdiv class=\\\"speedbump hide mail-login\\\" role=\\\"dialog\\\" aria-labelledby=\\\"Sign in to share this by email\\\"\\u003E\\u000a                \\u003Ch3 class=\\\"header\\\"\\u003ESign in to share this by email\\u003C/h3\\u003E\\u000a                \\u003Cdiv class=\\\"login-btns\\\"\\u003E\\u000a                    \\u003Cdiv class=\\\"login-link\\\"\\u003E\\u000a                        \\u003Ca class=\\\"login-btn yahoo\\\" role=\\\"link\\\" href=\\\"https://login.yahoo.com/config/login_verify2?.done=http%3A%2F%2Fnews.yahoo.com%2F_xhr%2Fmediacontentsharebuttons%2Fpostshare%2F%3Fsrc%3Dmail&amp;.src=mtf\\\" target=\\\"_blank\\\"\\u003E\\u003Cspan class=\\\"login-icon yahoo\\\"\\u003E\\u003C/span\\u003E\\u003Cspan class=\\\"login-text\\\"\\u003EYahoo!\\u003C/span\\u003E\\u003C/a\\u003E\\u000a                    \\u003C/div\\u003E\\u000a                    \\u003Cdiv class=\\\"login-link\\\"\\u003E\\u000a                        \\u003Ca class=\\\"login-btn facebook\\\" role=\\\"link\\\" href=\\\"https://open.login.yahoo.com/openid/yrp/signin?.intl=us&amp;idp=facebook&amp;.done=http://news.yahoo.com/%23mtf-overlay&amp;ts=1373481511&amp;.src=home&amp;appid=90376669494&amp;spid=b9ed13cc-ddec-11de-9c83-001b784d35e1&amp;perms=email,user_birthday,user_education_history,user_likes,user_location,user_relationships,user_subscriptions,user_work_history,friends_birthday,friends_education_history,friends_likes,friends_location,friends_work_history,publish_actions&amp;fbflow=1\\\" target=\\\"_blank\\\"\\u003E\\u003Cspan class=\\\"login-icon facebook\\\"\\u003E\\u003C/span\\u003E\\u003Cspan class=\\\"login-text\\\"\\u003EFacebook\\u003C/span\\u003E\\u003C/a\\u003E\\u000a                    \\u003C/div\\u003E\\u000a                \\u003C/div\\u003E\\u000a                \\u003Cp\\u003ENew here? \\u003Ca href=\\\"https://edit.yahoo.com/config/eval_register?.done=http%3A%2F%2Fnews.yahoo.com%2F_xhr%2Fmediacontentsharebuttons%2Fpostshare%2F%3Fsrc%3Dmail\\\" target=\\\"_blank\\\" class=\\\"signup\\\"\\u003ESign up.\\u003C/a\\u003E\\u003C/p\\u003E\\u000a            \\u003C/div\\u003E\\u000a            \\u003Cdiv class=\\\"speedbump hide mail-form\\\" role=\\\"dialog\\\" aria-labelledby=\\\"Email this\\\"\\u003E\\u000a                \\u003Ch3 class=\\\"header\\\"\\u003EEmail this\\u003C/h3\\u003E\\u000a                \\u003Cdiv class=\\\"form\\\"\\u003E\\u000a                    \\u003Cdiv class=\\\"form-input\\\"\\u003E\\u000a                        \\u003Clabel for=\\\"semail\\\"\\u003EFrom\\u003C/label\\u003E\\u003Cselect id=\\\"semail\\\" class=\\\"mail-input\\\" role=\\\"menu\\\" disabled\\u003E\\u003Coption role=\\\"menuitem\\\"\\u003ELoading...\\u003C/option\\u003E\\u003C/select\\u003E\\u000a                        \\u003Cdiv class=\\\"yom-mtf-semail-error icon-alert-small yui3-widget-hidden\\\"\\u003EPlease enter a valid email address\\u003C/div\\u003E\\u000a                    \\u003C/div\\u003E\\u000a                    \\u003Cdiv class=\\\"form-input\\\"\\u003E\\u000a                        \\u003Clabel for=\\\"remail\\\"\\u003ETo\\u003C/label\\u003E\\u003Cinput id=\\\"remail\\\" class=\\\"mail-input\\\" role=\\\"textbox\\\" disabled\\u003E\\u000a                        \\u003Cdiv class=\\\"yom-mtf-remail-error icon-alert-small yui3-widget-hidden\\\"\\u003EPlease enter valid email addresses, separated by commas\\u003C/div\\u003E\\u000a                        \\u003Cdiv class=\\\"yom-mtf-remail-max-error icon-alert-small yui3-widget-hidden\\\"\\u003EMaximum 200 character limit exceeded\\u003C/div\\u003E\\u000a                    \\u003C/div\\u003E\\u000a                    \\u003Cdiv class=\\\"form-input fb-import\\\"\\u003E\\u000a                        \\u003Clabel\\u003E&nbsp;\\u003C/label\\u003E\\u003Cspan\\u003EDon't see your Facebook contacts? \\u003Ca href=\\\"http://address.yahoo.com/?_src=neo&VPC=tools_import&.done=http://www.yahoo.com\\\" role=\\\"link\\\" target=\\\"_blank\\\" class=\\\"import\\\"\\u003EImport them\\u003C/a\\u003E\\u003C/span\\u003E\\u000a                    \\u003C/div\\u003E\\u000a                    \\u003Cdiv\\u003E\\u000a                        \\u003Ctextarea placeholder=\\\"Write a message\\\" class=\\\"mail-text\\\" role=\\\"textbox\\\" aria-multiline=\\\"true\\\"\\u003E\\u003C/textarea\\u003E \\u000a                        \\u003Cdiv class=\\\"yom-mtf-pmesg-error icon-alert-small yui3-widget-hidden\\\"\\u003EPlease enter a message\\u003C/div\\u003E\\u000a                    \\u003C/div\\u003E\\u000a                    \\u003Cdiv class=\\\"mail-article\\\"\\u003E\\u000a                        \\u003Cdiv class=\\\"article thumbnail\\\"\\u003E\\u000a                            \\u003Cimg title=\\\"Yahoo! News - Latest News &amp;amp; Headlines\\\"\\u003E\\u000a                        \\u003C/div\\u003E\\u000a                        \\u003Cdiv class=\\\"article\\\"\\u003E\\u000a                            \\u003Cdiv class=\\\"title\\\"\\u003EYahoo! News - Latest News &amp;amp; Headlines\\u003C/div\\u003E\\u000a                            \\u003Cdiv class=\\\"description\\\"\\u003EThe latest news and headlines from Yahoo! News. Get breaking news stories and in-depth coverage with videos and photos.\\u003C/div\\u003E\\u000a                        \\u003C/div\\u003E\\u000a                    \\u003C/div\\u003E\\u000a                    \\u003Cdiv class=\\\"mail-submit\\\"\\u003E\\u000a                        \\u003Cinput type=\\\"checkbox\\\" id=\\\"cc-self\\\" role=\\\"checkbox\\\"\\u003E\\u003Clabel for=\\\"cc-self\\\" class=\\\"cc-self\\\"\\u003ESend me a copy of this email\\u003C/label\\u003E\\u000a                        \\u003Cdiv class=\\\"submit-btns\\\"\\u003E\\u000a                            \\u003Cbutton class=\\\"mail-btn send\\\" role=\\\"button\\\" disabled\\u003ESend\\u003C/button\\u003E\\u000a                            \\u003Cbutton class=\\\"mail-btn close-btn\\\" role=\\\"button\\\"\\u003ECancel\\u003C/button\\u003E\\u000a                        \\u003C/div\\u003E\\u000a                        \\u003Cdiv class=\\\"clearfix\\\"\\u003E\\u003C/div\\u003E\\u000a                    \\u003C/div\\u003E\\u000a                \\u003C/div\\u003E\\u000a            \\u003C/div\\u003E\\u000a            \\u003Cdiv class=\\\"speedbump hide facebook\\\" role=\\\"dialog\\\" aria-labelledby=\\\"facebook\\\"\\u003Efacebook\\u003C/div\\u003E\\u000a            \\u003Cdiv class=\\\"speedbump hide twitter\\\" role=\\\"dialog\\\" aria-labelledby=\\\"twitter\\\"\\u003Etwitter\\u003C/div\\u003E\\u000a        \\u003C/div\\u003E\\u000a        \\u003Cdiv class=\\\"yui3-widget-ft\\\"\\u003E\\u003C/div\\u003E\\u000a    \\u003C/div\\u003E\\u000a\\u003C/div\\u003E\\u000a\"\n                    })));\n                })));\n            })()));\n        })));\n    })()));\n    (((JSBNG_Record.get)((((JSBNG_Record.get)(YUI, (\"Env\")))[(\"Env\")]), (\"add\")))[(\"add\")])(window, \"load\", ((function() {\n        var s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_11_instance;\n        ((s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_11_instance) = ((JSBNG_Record.eventInstance)((\"s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_11\"))));\n        return ((JSBNG_Record.markFunction)((function() {\n            if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                return ((JSBNG_Record.eventCall)((arguments.callee), (\"s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_11\"), (s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_11_instance), (this), (arguments)))\n            };\n            (null);\n            (((JSBNG_Record.get)(YMedia, (\"use\")))[(\"use\")])(\"media-rmp\", \"media-bc\", \"media-beacon-manager\", \"event-custom\", \"handlebars\", \"node-base\", \"media-nav-addon\", \"node-core\", \"node-data\", \"event-base\", \"node-event-delegate\", \"event-delegate\", \"event-tap\", \"media-tag-manager\", \"media-recommend\", \"media-personal-nav\", \"cookie\", \"querystring-parse\", \"media-strip\", \"media-trfsm\", \"base\", \"jsonp\", \"media-i13n\", \"media-ywa-tracking\", \"media-content-navigation-desktop\", \"overlay\", \"media-ad-ros\", \"media-footer\", ((function() {\n                var s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_12_instance;\n                ((s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_12_instance) = ((JSBNG_Record.eventInstance)((\"s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_12\"))));\n                return ((JSBNG_Record.markFunction)((function(Y) {\n                    if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                        return ((JSBNG_Record.eventCall)((arguments.callee), (\"s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_12\"), (s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_12_instance), (this), (arguments)))\n                    };\n                    (null);\n                    (((JSBNG_Record.get)(Y, (\"later\")))[(\"later\")])(10, this, ((function() {\n                        var s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_13_instance;\n                        ((s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_13_instance) = ((JSBNG_Record.eventInstance)((\"s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_13\"))));\n                        return ((JSBNG_Record.markFunction)((function() {\n                            if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                                return ((JSBNG_Record.eventCall)((arguments.callee), (\"s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_13\"), (s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_13_instance), (this), (arguments)))\n                            };\n                            (null);\n                            (((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Array\")))[(\"Array\")]), (\"each\")))[(\"each\")])((((JSBNG_Record.get)(YMedia, (\"includes\")))[(\"includes\")]), ((function() {\n                                var s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_14_instance;\n                                ((s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_14_instance) = ((JSBNG_Record.eventInstance)((\"s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_14\"))));\n                                return ((JSBNG_Record.markFunction)((function(inc, i, ar) {\n                                    if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                                        return ((JSBNG_Record.eventCall)((arguments.callee), (\"s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_14\"), (s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_14_instance), (this), (arguments)))\n                                    };\n                                    (null);\n                                    if ((((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Lang\")))[(\"Lang\")]), (\"isFunction\")))[(\"isFunction\")])(inc)) {\n                                        inc(Y);\n                                        ((JSBNG_Record.set)(ar, i, null));\n                                    }\n                                    ;\n                                })));\n                            })()));\n                        })));\n                    })()));\n                    (((JSBNG_Record.get)(Y, (\"later\")))[(\"later\")])(10, this, ((function() {\n                        var s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_15_instance;\n                        ((s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_15_instance) = ((JSBNG_Record.eventInstance)((\"s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_15\"))));\n                        return ((JSBNG_Record.markFunction)((function() {\n                            if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                                return ((JSBNG_Record.eventCall)((arguments.callee), (\"s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_15\"), (s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_15_instance), (this), (arguments)))\n                            };\n                            (null);\n                            new (((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"BeaconManager\")))[(\"BeaconManager\")])({\n                                chrome: (((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"pageChrome\")))[(\"pageChrome\")])\n                            });\n                        })));\n                    })()));\n                    (((JSBNG_Record.get)(Y, (\"later\")))[(\"later\")])(10, this, ((function() {\n                        var s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_16_instance;\n                        ((s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_16_instance) = ((JSBNG_Record.eventInstance)((\"s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_16\"))));\n                        return ((JSBNG_Record.markFunction)((function() {\n                            if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                                return ((JSBNG_Record.eventCall)((arguments.callee), (\"s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_16\"), (s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_16_instance), (this), (arguments)))\n                            };\n                            (null);\n                            new (((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"NavAddon\")))[(\"NavAddon\")])({\n                                max: \"3\",\n                                chrome: (((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"pageChrome\")))[(\"pageChrome\")])\n                            });\n                        })));\n                    })()));\n                    (((JSBNG_Record.get)(Y, (\"later\")))[(\"later\")])(10, this, ((function() {\n                        var s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_17_instance;\n                        ((s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_17_instance) = ((JSBNG_Record.eventInstance)((\"s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_17\"))));\n                        return ((JSBNG_Record.markFunction)((function() {\n                            if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                                return ((JSBNG_Record.eventCall)((arguments.callee), (\"s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_17\"), (s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_17_instance), (this), (arguments)))\n                            };\n                            (null);\n                            new (((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"Recommend\")))[(\"Recommend\")])({\n                                header: \"Recommended\",\n                                position: 1,\n                                chrome: (((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"pageChrome\")))[(\"pageChrome\")])\n                            });\n                        })));\n                    })()));\n                    (((JSBNG_Record.get)(Y, (\"later\")))[(\"later\")])(10, this, ((function() {\n                        var s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_18_instance;\n                        ((s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_18_instance) = ((JSBNG_Record.eventInstance)((\"s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_18\"))));\n                        return ((JSBNG_Record.markFunction)((function() {\n                            if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                                return ((JSBNG_Record.eventCall)((arguments.callee), (\"s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_18\"), (s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_18_instance), (this), (arguments)))\n                            };\n                            (null);\n                            new (((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"PersonalNav\")))[(\"PersonalNav\")])({\n                                header: \"My Topics\",\n                                position: 2\n                            });\n                        })));\n                    })()));\n                    (((JSBNG_Record.get)(Y, (\"later\")))[(\"later\")])(10, this, ((function() {\n                        var s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_19_instance;\n                        ((s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_19_instance) = ((JSBNG_Record.eventInstance)((\"s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_19\"))));\n                        return ((JSBNG_Record.markFunction)((function() {\n                            if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                                return ((JSBNG_Record.eventCall)((arguments.callee), (\"s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_19\"), (s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_19_instance), (this), (arguments)))\n                            };\n                            (null);\n                            (((JSBNG_Record.get)((((JSBNG_Record.get)((((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Global\")))[(\"Global\")]), (\"Media\")))[(\"Media\")]), (\"ILBoot\")))[(\"ILBoot\")]), (\"initImageLoader\")))[(\"initImageLoader\")])(true);\n                        })));\n                    })()));\n                    (((JSBNG_Record.get)(Y, (\"later\")))[(\"later\")])(10, this, ((function() {\n                        var s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_20_instance;\n                        ((s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_20_instance) = ((JSBNG_Record.eventInstance)((\"s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_20\"))));\n                        return ((JSBNG_Record.markFunction)((function() {\n                            if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                                return ((JSBNG_Record.eventCall)((arguments.callee), (\"s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_20\"), (s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_20_instance), (this), (arguments)))\n                            };\n                            (null);\n                            ((function() {\n                                var s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_21_instance;\n                                ((s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_21_instance) = ((JSBNG_Record.eventInstance)((\"s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_21\"))));\n                                return ((JSBNG_Record.markFunction)((function() {\n                                    if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                                        return ((JSBNG_Record.eventCall)((arguments.callee), (\"s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_21\"), (s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_21_instance), (this), (arguments)))\n                                    };\n                                    (null);\n                                    var configUrl = \"http://l.yimg.com/os/assets/globalmedia/traffic/traffic-simulation.js\", simulator = new (((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"TrafficSimulator\")))[(\"TrafficSimulator\")])({\n                                        dataUrl: configUrl\n                                    });\n                                    (((JSBNG_Record.get)(simulator, (\"load\")))[(\"load\")])();\n                                })));\n                            })())();\n                        })));\n                    })()));\n                    (((JSBNG_Record.get)(Y, (\"later\")))[(\"later\")])(10, this, ((function() {\n                        var s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_22_instance;\n                        ((s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_22_instance) = ((JSBNG_Record.eventInstance)((\"s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_22\"))));\n                        return ((JSBNG_Record.markFunction)((function() {\n                            if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                                return ((JSBNG_Record.eventCall)((arguments.callee), (\"s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_22\"), (s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_22_instance), (this), (arguments)))\n                            };\n                            (null);\n                            try {\n                                (((JSBNG_Record.get)(YMEDIA_REQ_ATTR, (\"csbeacon\")))[(\"csbeacon\")])();\n                            } catch (e) {\n                            \n                            };\n                        })));\n                    })()));\n                    (((JSBNG_Record.get)(Y, (\"later\")))[(\"later\")])(10, this, ((function() {\n                        var s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_23_instance;\n                        ((s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_23_instance) = ((JSBNG_Record.eventInstance)((\"s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_23\"))));\n                        return ((JSBNG_Record.markFunction)((function() {\n                            if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                                return ((JSBNG_Record.eventCall)((arguments.callee), (\"s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_23\"), (s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_23_instance), (this), (arguments)))\n                            };\n                            (null);\n                            new (((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"ContentNavigation\")))[(\"ContentNavigation\")])({\n                                config: {\n                                    modId: \"mediacontentnavigation\"\n                                },\n                                chrome: (((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"pageChrome\")))[(\"pageChrome\")])\n                            });\n                        })));\n                    })()));\n                    (((JSBNG_Record.get)(Y, (\"later\")))[(\"later\")])(10, this, ((function() {\n                        var s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_24_instance;\n                        ((s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_24_instance) = ((JSBNG_Record.eventInstance)((\"s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_24\"))));\n                        return ((JSBNG_Record.markFunction)((function() {\n                            if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                                return ((JSBNG_Record.eventCall)((arguments.callee), (\"s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_24\"), (s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_24_instance), (this), (arguments)))\n                            };\n                            (null);\n                            (((JSBNG_Record.get)((((JSBNG_Record.get)((((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"Lead\")))[(\"Lead\")]), (\"MediaContentLead\")))[(\"MediaContentLead\")]), (\"init\")))[(\"init\")])({\n                                cat: \"\",\n                                catName: \"\",\n                                \"listid \": \"\"\n                            });\n                        })));\n                    })()));\n                    (((JSBNG_Record.get)(Y, (\"later\")))[(\"later\")])(10, this, ((function() {\n                        var s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_25_instance;\n                        ((s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_25_instance) = ((JSBNG_Record.eventInstance)((\"s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_25\"))));\n                        return ((JSBNG_Record.markFunction)((function() {\n                            if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                                return ((JSBNG_Record.eventCall)((arguments.callee), (\"s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_25\"), (s48b6de687e0e7ea567b7aeb5cc7f36c5be5012e9_25_instance), (this), (arguments)))\n                            };\n                            (null);\n                            (((JSBNG_Record.get)((((JSBNG_Record.get)((((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"Comic\")))[(\"Comic\")]), (\"MediaContentComic\")))[(\"MediaContentComic\")]), (\"init\")))[(\"init\")])({\n                                meta: {\n                                    error: {\n                                        error_code: 0\n                                    },\n                                    mod_id: \"mediacontentcomic\",\n                                    bucket: null,\n                                    selected_list: \"92df5b73-9c06-3216-9539-45edc1a84bfa\",\n                                    selected_name: \"Andy Capp\",\n                                    abbreviation: \"crcap\",\n                                    max_result_count: 14,\n                                    start: 0,\n                                    count: 14,\n                                    total: 95,\n                                    alias: \"/comics/andy-capp-slideshow/\",\n                                    enableLightBox: 0\n                                },\n                                data: {\n                                    \"92df5b73-9c06-3216-9539-45edc1a84bfa\": [{\n                                        src: \"http://l2.yimg.com/bt/api/res/1.2/uhTcIm0OGqDTd1qtuyiVHQ--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE2OTtweW9mZj0wO3E9ODU7dz02MDA-/http://media.zenfs.com/en_us/News/ucomics.com/crcap130710.gif\",\n                                        rsrc: \"http://l2.yimg.com/bt/api/res/1.2/bbvN0UJx2GpIp_uEggkMQQ--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTEwMjtweW9mZj0wO3E9ODU7dz0zNjQ-/http://media.zenfs.com/en_us/News/ucomics.com/crcap130710.gif\",\n                                        sdate: \"Wed, Jul 10\",\n                                        date: \"Wednesday, July 10\"\n                                    },{\n                                        src: \"http://l.yimg.com/bt/api/res/1.2/ejRT5kGg9EhhabqhJeCFUw--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE2OTtweW9mZj0wO3E9ODU7dz02MDA-/http://media.zenfs.com/en_us/News/ucomics.com/crcap130709.gif\",\n                                        rsrc: \"http://l1.yimg.com/bt/api/res/1.2/R52PN4koEPVG6RlHCrZM5w--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTEwMjtweW9mZj0wO3E9ODU7dz0zNjQ-/http://media.zenfs.com/en_us/News/ucomics.com/crcap130709.gif\",\n                                        sdate: \"Tue, Jul 9\",\n                                        date: \"Tuesday, July 9\"\n                                    },{\n                                        src: \"http://l3.yimg.com/bt/api/res/1.2/T.VjgD2kZmwtsZLCYq58Bw--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE2NztweW9mZj0wO3E9ODU7dz02MDA-/http://media.zenfs.com/en_us/News/ucomics.com/crcap130708.gif\",\n                                        rsrc: \"http://l.yimg.com/bt/api/res/1.2/AQsZOu7M1A4OPLVohVfnPw--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTEwMTtweW9mZj0wO3E9ODU7dz0zNjQ-/http://media.zenfs.com/en_us/News/ucomics.com/crcap130708.gif\",\n                                        sdate: \"Mon, Jul 8\",\n                                        date: \"Monday, July 8\"\n                                    },{\n                                        src: \"http://l3.yimg.com/bt/api/res/1.2/vEgdLI0YlpWnMqyG2a3f8A--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTI5NTtweW9mZj0wO3E9ODU7dz02MDA-/http://media.zenfs.com/en_us/News/ucomics.com/crcap130707.jpg\",\n                                        rsrc: \"http://l3.yimg.com/bt/api/res/1.2/ScNgEmRCMk_IA3QPke6KBQ--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE3ODtweW9mZj0wO3E9ODU7dz0zNjQ-/http://media.zenfs.com/en_us/News/ucomics.com/crcap130707.jpg\",\n                                        sdate: \"Sun, Jul 7\",\n                                        date: \"Sunday, July 7\"\n                                    },{\n                                        src: \"http://l2.yimg.com/bt/api/res/1.2/WqvGZ3HkRWFIQ8e57rFubQ--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE2NztweW9mZj0wO3E9ODU7dz02MDA-/http://media.zenfs.com/en_us/News/ucomics.com/crcap130706.gif\",\n                                        rsrc: \"http://l.yimg.com/bt/api/res/1.2/VPtfwBlN9rxXr3jVq8C4iA--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTEwMTtweW9mZj0wO3E9ODU7dz0zNjQ-/http://media.zenfs.com/en_us/News/ucomics.com/crcap130706.gif\",\n                                        sdate: \"Sat, Jul 6\",\n                                        date: \"Saturday, July 6\"\n                                    },{\n                                        src: \"http://l2.yimg.com/bt/api/res/1.2/a5kYphyMeoSHhPKhcxEDZg--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE2NztweW9mZj0wO3E