/* ./library/tsf_fsdb_protocol.c -- generated by tsf_define from ./library/tsf_fsdb_protocol.t */

#include "tsf_fsdb_protocol.h"
#include "tsf_define_helpers.h"
#include <stdio.h>

static tsf_type_t *tsf_fsdb_buffer__build_type(void) TSF_ATTRIBUTE_NOINLINE;
static tsf_type_t *tsf_fsdb_state__build_type(void) TSF_ATTRIBUTE_NOINLINE;
static tsf_type_t *tsf_fsdb_command__build_type(void) TSF_ATTRIBUTE_NOINLINE;
static tsf_type_t *tsf_fsdb_response__build_type(void) TSF_ATTRIBUTE_NOINLINE;
static tsf_type_t *uint8__array__build_type(void) TSF_ATTRIBUTE_NOINLINE;
static tsf_type_t *tsf_fsdb_command__put__build_type(void) TSF_ATTRIBUTE_NOINLINE;
static tsf_type_t *tsf_fsdb_command__out_write__build_type(void) TSF_ATTRIBUTE_NOINLINE;
static tsf_type_t *tsf_fsdb_command__get__build_type(void) TSF_ATTRIBUTE_NOINLINE;
static tsf_type_t *tsf_fsdb_command__rm__build_type(void) TSF_ATTRIBUTE_NOINLINE;
static tsf_type_t *tsf_fsdb_response__payload__build_type(void) TSF_ATTRIBUTE_NOINLINE;
static tsf_type_t *tsf_fsdb_response__payload__welcome__build_type(void) TSF_ATTRIBUTE_NOINLINE;
static tsf_type_t *tsf_fsdb_response__payload__welcome__version__build_type(void) TSF_ATTRIBUTE_NOINLINE;
static tsf_type_t *tsf_fsdb_response__payload__sys_error__build_type(void) TSF_ATTRIBUTE_NOINLINE;
static tsf_type_t *tsf_fsdb_response__payload__proto_error__build_type(void) TSF_ATTRIBUTE_NOINLINE;
static tsf_type_t *tsf_fsdb_response__payload__in_data__build_type(void) TSF_ATTRIBUTE_NOINLINE;

tsf_type_t *tsf_fsdb_buffer__build_type(void) {
    tsf_type_t *result = tsf_type_dup(uint8__array__get_type());
    return result;
}

tsf_type_t *tsf_fsdb_state__build_type(void) {
    tsf_type_t *result = tsf_type_create_choice_with_native_map_aoe(&result, tsf_true, tsf_offsetof(tsf_fsdb_state_t, value), 0, sizeof(tsf_fsdb_state_t));
    tsf_choice_type_append_primitive_with_comment_aoe(&result, "clear", TSF_TK_VOID, " the connection is ready for put/get requests. ");
    tsf_choice_type_append_primitive_with_comment_aoe(&result, "put", TSF_TK_VOID, " the connection is in 'put' mode, and is expecting either\n 'out_write', 'out_commit', or 'reset' commands. ");
    tsf_choice_type_append_primitive_with_comment_aoe(&result, "get", TSF_TK_VOID, " the connection is in 'get' mode, and is sending data\n until EOF.  the only valid command is 'reset'. ");
    tsf_type_set_name_aoe(&result, "tsf_fsdb_state");
    return result;
}

tsf_type_t *tsf_fsdb_command__build_type(void) {
    tsf_type_t *result = tsf_type_create_choice_with_native_map_aoe(&result, tsf_true, tsf_offsetof(tsf_fsdb_command_t, value), tsf_offsetof(tsf_fsdb_command_t, u), sizeof(tsf_fsdb_command_t));
    tsf_choice_type_append_primitive_with_comment_aoe(&result, "ping", TSF_TK_VOID, " no-op command, which illicits an ok response. ");
    tsf_choice_type_append_from_callback_and_dup_with_comment_aoe(&result, "put", tsf_fsdb_command__put__get_type, " start putting a value at the key identified by the given\n keysum, which must be an array of 5 uint32's.  this places\n the connection into the 'put' state, and the only valid\n commands are out_write, out_commit, or reset.\n acknowledged with an 'ok' response or an error. ");
    tsf_choice_type_append_from_callback_and_dup_with_comment_aoe(&result, "out_write", tsf_fsdb_command__out_write__get_type, " write a sequence of bytes into the file opened by 'put'.\n note that there need not be a correspondence between the\n buffers from tsf_fsdb_out_write's perspective, and the\n units of data sent here.  acknowledged with an 'ok' or\n an error. ");
    tsf_choice_type_append_primitive_with_comment_aoe(&result, "out_commit", TSF_TK_VOID, " commit the 'put'.  regardless of success or failure, the\n connection switches to 'clear' state.  acknowledged with\n an 'ok' or an error. ");
    tsf_choice_type_append_from_callback_and_dup_with_comment_aoe(&result, "get", tsf_fsdb_command__get__get_type, " start getting values at the key identified by the given\n keysum, which must be an array of 5 uint32's.  this\n places the connection into the 'get' state, and the only\n valid command becomes 'reset'.  acknolwedged with\n either 'ok', 'not_found', or an error.  if acknowledged\n with 'ok', the server will start sending data.  the data\n stream will end with either 'sys_error' or 'in_eof', at\n which point the connection will be back in 'clear' state. ");
    tsf_choice_type_append_from_callback_and_dup_with_comment_aoe(&result, "rm", tsf_fsdb_command__rm__get_type, " remove an entry from the database. acknowledged with either\n an 'ok', 'not_found', or an error. ");
    tsf_choice_type_append_primitive_with_comment_aoe(&result, "reset", TSF_TK_VOID, " reset the connection back to 'clear' state.  this can\n be used to either abort a 'put' or to close a 'get'\n prematurely.  if issued in 'put' or 'clear' states, it\n is acknowledged immediately with an 'ok'.  if issued\n in 'get' state, there may be some number of 'in_data'\n or 'in_eof' packets queued up, as well as possibly a\n 'sys_error', so be sure to either ignore or report those\n and wait for the 'ok' before proceeding further.  note\n that a somewhat safer method of aborting a put or get\n is to simply disconnect from the server.  currently that\n is faster for aborting a get, but slower for aborting\n a put. ");
    tsf_type_set_name_aoe(&result, "tsf_fsdb_command");
    tsf_type_set_comment_aoe(&result, " command sent from client to server.  each command is acknowledged\n by a response, which may be just 'ok'. ");
    return result;
}

tsf_type_t *tsf_fsdb_command__put__build_type(void) {
    tsf_type_t *result = tsf_type_create_struct_with_native_size_and_destructor_aoe(sizeof(tsf_fsdb_command__put_t), (void(*)(void*))tsf_fsdb_command__put__destruct);
    tsf_struct_type_append_primitive_with_native_map_aoe(&result, "key", TSF_TK_ANY, tsf_offsetof(tsf_fsdb_command__put_t, key));
    tsf_type_set_name_aoe(&result, "tsf_fsdb_command__put");
    return result;
}

tsf_type_t *tsf_fsdb_command__out_write__build_type(void) {
    tsf_type_t *result = tsf_type_create_struct_with_native_size_and_destructor_aoe(sizeof(tsf_fsdb_command__out_write_t), (void(*)(void*))tsf_fsdb_command__out_write__destruct);
    tsf_struct_type_append_from_callback_and_dup_with_native_map_aoe(&result, "data", tsf_fsdb_buffer__get_type, tsf_offsetof(tsf_fsdb_command__out_write_t, data));
    tsf_type_set_name_aoe(&result, "tsf_fsdb_command__out_write");
    return result;
}

tsf_type_t *uint8__array__build_type(void) {
    tsf_type_t *result = tsf_type_create_array_aoe(tsf_type_create_aoe(TSF_TK_UINT8));
    return result;
}

tsf_type_t *tsf_fsdb_command__get__build_type(void) {
    tsf_type_t *result = tsf_type_create_struct_with_native_size_and_destructor_aoe(sizeof(tsf_fsdb_command__get_t), (void(*)(void*))tsf_fsdb_command__get__destruct);
    tsf_struct_type_append_primitive_with_native_map_aoe(&result, "key", TSF_TK_ANY, tsf_offsetof(tsf_fsdb_command__get_t, key));
    tsf_type_set_name_aoe(&result, "tsf_fsdb_command__get");
    return result;
}

tsf_type_t *tsf_fsdb_command__rm__build_type(void) {
    tsf_type_t *result = tsf_type_create_struct_with_native_size_and_destructor_aoe(sizeof(tsf_fsdb_command__rm_t), (void(*)(void*))tsf_fsdb_command__rm__destruct);
    tsf_struct_type_append_primitive_with_native_map_aoe(&result, "key", TSF_TK_ANY, tsf_offsetof(tsf_fsdb_command__rm_t, key));
    tsf_type_set_name_aoe(&result, "tsf_fsdb_command__rm");
    return result;
}

tsf_type_t *tsf_fsdb_response__build_type(void) {
    tsf_type_t *result = tsf_type_create_struct_with_native_size_and_destructor_aoe(sizeof(tsf_fsdb_response_t), (void(*)(void*))tsf_fsdb_response__destruct);
    tsf_struct_type_append_from_callback_and_dup_with_native_map_with_comment_aoe(&result, "state", tsf_fsdb_state__get_type, tsf_offsetof(tsf_fsdb_response_t, state), " describes the state of the connection as a result of\n the execution of the most recent command. ");
    tsf_struct_type_append_from_callback_and_dup_with_native_map_aoe(&result, "payload", tsf_fsdb_response__payload__get_type, tsf_offsetof(tsf_fsdb_response_t, payload));
    tsf_type_set_name_aoe(&result, "tsf_fsdb_response");
    tsf_type_set_comment_aoe(&result, " response sent from server to client ");
    return result;
}

tsf_type_t *tsf_fsdb_response__payload__build_type(void) {
    tsf_type_t *result = tsf_type_create_choice_with_native_map_aoe(&result, tsf_true, tsf_offsetof(tsf_fsdb_response__payload_t, value), tsf_offsetof(tsf_fsdb_response__payload_t, u), sizeof(tsf_fsdb_response__payload_t));
    tsf_choice_type_append_primitive_with_comment_aoe(&result, "ok", TSF_TK_VOID, " generic acknowledgement that the previous command\n succeeded. ");
    tsf_choice_type_append_from_callback_and_dup_with_comment_aoe(&result, "welcome", tsf_fsdb_response__payload__welcome__get_type, " response sent to a new connection. ");
    tsf_choice_type_append_from_callback_and_dup_with_comment_aoe(&result, "sys_error", tsf_fsdb_response__payload__sys_error__get_type, " an error indicating an unexpected system fault. ");
    tsf_choice_type_append_from_callback_and_dup_with_comment_aoe(&result, "proto_error", tsf_fsdb_response__payload__proto_error__get_type, " an error arising out of incorrect use of the protocol. ");
    tsf_choice_type_append_primitive_with_comment_aoe(&result, "not_found", TSF_TK_VOID, " indicates that the given key was not found in the\n database. ");
    tsf_choice_type_append_from_callback_and_dup_with_comment_aoe(&result, "in_data", tsf_fsdb_response__payload__in_data__get_type, " a data packet in response to a 'get' request.  these buffers\n may not correspond to the buffers returned from\n tsf_fsdb_in_read(), but may be at any granularity. ");
    tsf_choice_type_append_primitive_with_comment_aoe(&result, "in_eof", TSF_TK_VOID, " end-of-file on a 'get' request; indicates that all available\n data has been sent. ");
    tsf_type_set_name_aoe(&result, "tsf_fsdb_response__payload");
    return result;
}

tsf_type_t *tsf_fsdb_response__payload__welcome__build_type(void) {
    tsf_type_t *result = tsf_type_create_struct_with_native_size_and_destructor_aoe(sizeof(tsf_fsdb_response__payload__welcome_t), (void(*)(void*))tsf_fsdb_response__payload__welcome__destruct);
    tsf_struct_type_append_primitive_with_native_map_with_comment_aoe(&result, "name", TSF_TK_STRING, tsf_offsetof(tsf_fsdb_response__payload__welcome_t, name), " the name of the server software. ");
    tsf_struct_type_append_from_callback_and_dup_with_native_map_with_comment_aoe(&result, "version", tsf_fsdb_response__payload__welcome__version__get_type, tsf_offsetof(tsf_fsdb_response__payload__welcome_t, version), " the version of the server software; this is usually\n the TSF version. ");
    tsf_type_set_name_aoe(&result, "tsf_fsdb_response__payload__welcome");
    return result;
}

tsf_type_t *tsf_fsdb_response__payload__welcome__version__build_type(void) {
    tsf_type_t *result = tsf_type_create_struct_with_native_size_aoe(sizeof(tsf_fsdb_response__payload__welcome__version_t));
    tsf_struct_type_append_primitive_with_native_map_aoe(&result, "major", TSF_TK_INT32, tsf_offsetof(tsf_fsdb_response__payload__welcome__version_t, major));
    tsf_struct_type_append_primitive_with_native_map_aoe(&result, "minor", TSF_TK_INT32, tsf_offsetof(tsf_fsdb_response__payload__welcome__version_t, minor));
    tsf_struct_type_append_primitive_with_native_map_aoe(&result, "patch", TSF_TK_INT32, tsf_offsetof(tsf_fsdb_response__payload__welcome__version_t, patch));
    tsf_type_set_name_aoe(&result, "tsf_fsdb_response__payload__welcome__version");
    return result;
}

tsf_type_t *tsf_fsdb_response__payload__sys_error__build_type(void) {
    tsf_type_t *result = tsf_type_create_struct_with_native_size_and_destructor_aoe(sizeof(tsf_fsdb_response__payload__sys_error_t), (void(*)(void*))tsf_fsdb_response__payload__sys_error__destruct);
    tsf_struct_type_append_primitive_with_native_map_aoe(&result, "msg", TSF_TK_STRING, tsf_offsetof(tsf_fsdb_response__payload__sys_error_t, msg));
    tsf_type_set_name_aoe(&result, "tsf_fsdb_response__payload__sys_error");
    return result;
}

tsf_type_t *tsf_fsdb_response__payload__proto_error__build_type(void) {
    tsf_type_t *result = tsf_type_create_struct_with_native_size_and_destructor_aoe(sizeof(tsf_fsdb_response__payload__proto_error_t), (void(*)(void*))tsf_fsdb_response__payload__proto_error__destruct);
    tsf_struct_type_append_primitive_with_native_map_with_comment_aoe(&result, "msg", TSF_TK_STRING, tsf_offsetof(tsf_fsdb_response__payload__proto_error_t, msg), " a server-generated message describing what went wrong ");
    tsf_type_set_name_aoe(&result, "tsf_fsdb_response__payload__proto_error");
    return result;
}

tsf_type_t *tsf_fsdb_response__payload__in_data__build_type(void) {
    tsf_type_t *result = tsf_type_create_struct_with_native_size_and_destructor_aoe(sizeof(tsf_fsdb_response__payload__in_data_t), (void(*)(void*))tsf_fsdb_response__payload__in_data__destruct);
    tsf_struct_type_append_from_callback_and_dup_with_native_map_aoe(&result, "data", tsf_fsdb_buffer__get_type, tsf_offsetof(tsf_fsdb_response__payload__in_data_t, data));
    tsf_type_set_name_aoe(&result, "tsf_fsdb_response__payload__in_data");
    return result;
}

static tsf_type_t * volatile tsf_fsdb_buffer__type = NULL;
static tsf_genrtr_t * volatile tsf_fsdb_buffer__genrtr = NULL;
static tsf_parser_t * volatile tsf_fsdb_buffer__parser = NULL;

#ifndef TSF_HAVE_INIT_POINTER
static pthread_once_t tsf_fsdb_buffer__type__oc = PTHREAD_ONCE_INIT;
static void tsf_fsdb_buffer__type__builder(void) {
    tsf_fsdb_buffer__type = tsf_fsdb_buffer__build_type();
}
#else
static void *tsf_fsdb_buffer__type__builder(void) {
    return tsf_fsdb_buffer__build_type();
}
#endif
tsf_type_t *tsf_fsdb_buffer__get_type(void) {
#ifdef TSF_HAVE_INIT_POINTER
    return (tsf_type_t*)tsf_init_pointer((void**)&tsf_fsdb_buffer__type, tsf_fsdb_buffer__type__builder);
#else
    pthread_once(&tsf_fsdb_buffer__type__oc, tsf_fsdb_buffer__type__builder);
    return tsf_fsdb_buffer__type;
#endif
}

#ifndef TSF_HAVE_INIT_POINTER
static pthread_once_t tsf_fsdb_buffer__genrtr__oc = PTHREAD_ONCE_INIT;
static void tsf_fsdb_buffer__genrtr__builder(void) {
    tsf_fsdb_buffer__genrtr = tsf_generator_create(tsf_fsdb_buffer__get_type());
}
#else
static void *tsf_fsdb_buffer__genrtr__builder(void) {
    return tsf_generator_create(tsf_fsdb_buffer__get_type());
}
#endif
tsf_genrtr_t *tsf_fsdb_buffer__get_generator(void) {
#ifdef TSF_HAVE_INIT_POINTER
    return (tsf_genrtr_t*)tsf_init_pointer((void**)&tsf_fsdb_buffer__genrtr, tsf_fsdb_buffer__genrtr__builder);
#else
    pthread_once(&tsf_fsdb_buffer__genrtr__oc, tsf_fsdb_buffer__genrtr__builder);
    return tsf_fsdb_buffer__genrtr;
#endif
}

#ifndef TSF_HAVE_INIT_POINTER
static pthread_once_t tsf_fsdb_buffer__parser__oc = PTHREAD_ONCE_INIT;
static void tsf_fsdb_buffer__parser__builder(void) {
    tsf_fsdb_buffer__parser = tsf_parser_create(tsf_fsdb_buffer__get_type());
}
#else
static void *tsf_fsdb_buffer__parser__builder(void) {
    return tsf_parser_create(tsf_fsdb_buffer__get_type());
}
#endif
tsf_parser_t *tsf_fsdb_buffer__get_parser(void) {
#ifdef TSF_HAVE_INIT_POINTER
    return (tsf_parser_t*)tsf_init_pointer((void**)&tsf_fsdb_buffer__parser, tsf_fsdb_buffer__parser__builder);
#else
    pthread_once(&tsf_fsdb_buffer__parser__oc, tsf_fsdb_buffer__parser__builder);
    return tsf_fsdb_buffer__parser;
#endif
}
void tsf_fsdb_buffer__destruct(tsf_fsdb_buffer_t *data) {
    uint8__array__destruct(data);
}

tsf_bool_t tsf_fsdb_buffer__write(tsf_stream_file_output_t *out, tsf_fsdb_buffer_t *data) {
    return tsf_typed_data_write(out, tsf_fsdb_buffer__get_generator(), data);
}

tsf_fsdb_buffer_t *tsf_fsdb_buffer__read(tsf_stream_file_input_t *in) {
    return tsf_typed_data_read(in, tsf_fsdb_buffer__get_parser());
}

tsf_bool_t tsf_fsdb_buffer__read_into(tsf_stream_file_input_t *in, tsf_fsdb_buffer_t *result) {
    return tsf_typed_data_read_into(in, tsf_fsdb_buffer__get_parser(), result);
}

static tsf_type_t * volatile tsf_fsdb_state__type = NULL;
static tsf_genrtr_t * volatile tsf_fsdb_state__genrtr = NULL;
static tsf_parser_t * volatile tsf_fsdb_state__parser = NULL;

#ifndef TSF_HAVE_INIT_POINTER
static pthread_once_t tsf_fsdb_state__type__oc = PTHREAD_ONCE_INIT;
static void tsf_fsdb_state__type__builder(void) {
    tsf_fsdb_state__type = tsf_fsdb_state__build_type();
}
#else
static void *tsf_fsdb_state__type__builder(void) {
    return tsf_fsdb_state__build_type();
}
#endif
tsf_type_t *tsf_fsdb_state__get_type(void) {
#ifdef TSF_HAVE_INIT_POINTER
    return (tsf_type_t*)tsf_init_pointer((void**)&tsf_fsdb_state__type, tsf_fsdb_state__type__builder);
#else
    pthread_once(&tsf_fsdb_state__type__oc, tsf_fsdb_state__type__builder);
    return tsf_fsdb_state__type;
#endif
}

#ifndef TSF_HAVE_INIT_POINTER
static pthread_once_t tsf_fsdb_state__genrtr__oc = PTHREAD_ONCE_INIT;
static void tsf_fsdb_state__genrtr__builder(void) {
    tsf_fsdb_state__genrtr = tsf_generator_create(tsf_fsdb_state__get_type());
}
#else
static void *tsf_fsdb_state__genrtr__builder(void) {
    return tsf_generator_create(tsf_fsdb_state__get_type());
}
#endif
tsf_genrtr_t *tsf_fsdb_state__get_generator(void) {
#ifdef TSF_HAVE_INIT_POINTER
    return (tsf_genrtr_t*)tsf_init_pointer((void**)&tsf_fsdb_state__genrtr, tsf_fsdb_state__genrtr__builder);
#else
    pthread_once(&tsf_fsdb_state__genrtr__oc, tsf_fsdb_state__genrtr__builder);
    return tsf_fsdb_state__genrtr;
#endif
}

#ifndef TSF_HAVE_INIT_POINTER
static pthread_once_t tsf_fsdb_state__parser__oc = PTHREAD_ONCE_INIT;
static void tsf_fsdb_state__parser__builder(void) {
    tsf_fsdb_state__parser = tsf_parser_create(tsf_fsdb_state__get_type());
}
#else
static void *tsf_fsdb_state__parser__builder(void) {
    return tsf_parser_create(tsf_fsdb_state__get_type());
}
#endif
tsf_parser_t *tsf_fsdb_state__get_parser(void) {
#ifdef TSF_HAVE_INIT_POINTER
    return (tsf_parser_t*)tsf_init_pointer((void**)&tsf_fsdb_state__parser, tsf_fsdb_state__parser__builder);
#else
    pthread_once(&tsf_fsdb_state__parser__oc, tsf_fsdb_state__parser__builder);
    return tsf_fsdb_state__parser;
#endif
}

tsf_bool_t tsf_fsdb_state__write(tsf_stream_file_output_t *out, tsf_fsdb_state_t *data) {
    return tsf_typed_data_write(out, tsf_fsdb_state__get_generator(), data);
}

tsf_fsdb_state_t *tsf_fsdb_state__read(tsf_stream_file_input_t *in) {
    return tsf_typed_data_read(in, tsf_fsdb_state__get_parser());
}

tsf_bool_t tsf_fsdb_state__read_into(tsf_stream_file_input_t *in, tsf_fsdb_state_t *result) {
    return tsf_typed_data_read_into(in, tsf_fsdb_state__get_parser(), result);
}

static tsf_type_t * volatile tsf_fsdb_command__type = NULL;
static tsf_genrtr_t * volatile tsf_fsdb_command__genrtr = NULL;
static tsf_parser_t * volatile tsf_fsdb_command__parser = NULL;

#ifndef TSF_HAVE_INIT_POINTER
static pthread_once_t tsf_fsdb_command__type__oc = PTHREAD_ONCE_INIT;
static void tsf_fsdb_command__type__builder(void) {
    tsf_fsdb_command__type = tsf_fsdb_command__build_type();
}
#else
static void *tsf_fsdb_command__type__builder(void) {
    return tsf_fsdb_command__build_type();
}
#endif
tsf_type_t *tsf_fsdb_command__get_type(void) {
#ifdef TSF_HAVE_INIT_POINTER
    return (tsf_type_t*)tsf_init_pointer((void**)&tsf_fsdb_command__type, tsf_fsdb_command__type__builder);
#else
    pthread_once(&tsf_fsdb_command__type__oc, tsf_fsdb_command__type__builder);
    return tsf_fsdb_command__type;
#endif
}

#ifndef TSF_HAVE_INIT_POINTER
static pthread_once_t tsf_fsdb_command__genrtr__oc = PTHREAD_ONCE_INIT;
static void tsf_fsdb_command__genrtr__builder(void) {
    tsf_fsdb_command__genrtr = tsf_generator_create(tsf_fsdb_command__get_type());
}
#else
static void *tsf_fsdb_command__genrtr__builder(void) {
    return tsf_generator_create(tsf_fsdb_command__get_type());
}
#endif
tsf_genrtr_t *tsf_fsdb_command__get_generator(void) {
#ifdef TSF_HAVE_INIT_POINTER
    return (tsf_genrtr_t*)tsf_init_pointer((void**)&tsf_fsdb_command__genrtr, tsf_fsdb_command__genrtr__builder);
#else
    pthread_once(&tsf_fsdb_command__genrtr__oc, tsf_fsdb_command__genrtr__builder);
    return tsf_fsdb_command__genrtr;
#endif
}

#ifndef TSF_HAVE_INIT_POINTER
static pthread_once_t tsf_fsdb_command__parser__oc = PTHREAD_ONCE_INIT;
static void tsf_fsdb_command__parser__builder(void) {
    tsf_fsdb_command__parser = tsf_parser_create(tsf_fsdb_command__get_type());
}
#else
static void *tsf_fsdb_command__parser__builder(void) {
    return tsf_parser_create(tsf_fsdb_command__get_type());
}
#endif
tsf_parser_t *tsf_fsdb_command__get_parser(void) {
#ifdef TSF_HAVE_INIT_POINTER
    return (tsf_parser_t*)tsf_init_pointer((void**)&tsf_fsdb_command__parser, tsf_fsdb_command__parser__builder);
#else
    pthread_once(&tsf_fsdb_command__parser__oc, tsf_fsdb_command__parser__builder);
    return tsf_fsdb_command__parser;
#endif
}
void tsf_fsdb_command__destruct(tsf_fsdb_command_t *data) {
    switch (data->value) {
    case 1:
        tsf_fsdb_command__put__destruct(&data->u.put);
        break;
    case 2:
        tsf_fsdb_command__out_write__destruct(&data->u.out_write);
        break;
    case 4:
        tsf_fsdb_command__get__destruct(&data->u.get);
        break;
    case 5:
        tsf_fsdb_command__rm__destruct(&data->u.rm);
        break;
    default:
        break;
    }
}

tsf_bool_t tsf_fsdb_command__write(tsf_stream_file_output_t *out, tsf_fsdb_command_t *data) {
    return tsf_typed_data_write(out, tsf_fsdb_command__get_generator(), data);
}

tsf_fsdb_command_t *tsf_fsdb_command__read(tsf_stream_file_input_t *in) {
    return tsf_typed_data_read(in, tsf_fsdb_command__get_parser());
}

tsf_bool_t tsf_fsdb_command__read_into(tsf_stream_file_input_t *in, tsf_fsdb_command_t *result) {
    return tsf_typed_data_read_into(in, tsf_fsdb_command__get_parser(), result);
}

static tsf_type_t * volatile tsf_fsdb_response__type = NULL;
static tsf_genrtr_t * volatile tsf_fsdb_response__genrtr = NULL;
static tsf_parser_t * volatile tsf_fsdb_response__parser = NULL;

#ifndef TSF_HAVE_INIT_POINTER
static pthread_once_t tsf_fsdb_response__type__oc = PTHREAD_ONCE_INIT;
static void tsf_fsdb_response__type__builder(void) {
    tsf_fsdb_response__type = tsf_fsdb_response__build_type();
}
#else
static void *tsf_fsdb_response__type__builder(void) {
    return tsf_fsdb_response__build_type();
}
#endif
tsf_type_t *tsf_fsdb_response__get_type(void) {
#ifdef TSF_HAVE_INIT_POINTER
    return (tsf_type_t*)tsf_init_pointer((void**)&tsf_fsdb_response__type, tsf_fsdb_response__type__builder);
#else
    pthread_once(&tsf_fsdb_response__type__oc, tsf_fsdb_response__type__builder);
    return tsf_fsdb_response__type;
#endif
}

#ifndef TSF_HAVE_INIT_POINTER
static pthread_once_t tsf_fsdb_response__genrtr__oc = PTHREAD_ONCE_INIT;
static void tsf_fsdb_response__genrtr__builder(void) {
    tsf_fsdb_response__genrtr = tsf_generator_create(tsf_fsdb_response__get_type());
}
#else
static void *tsf_fsdb_response__genrtr__builder(void) {
    return tsf_generator_create(tsf_fsdb_response__get_type());
}
#endif
tsf_genrtr_t *tsf_fsdb_response__get_generator(void) {
#ifdef TSF_HAVE_INIT_POINTER
    return (tsf_genrtr_t*)tsf_init_pointer((void**)&tsf_fsdb_response__genrtr, tsf_fsdb_response__genrtr__builder);
#else
    pthread_once(&tsf_fsdb_response__genrtr__oc, tsf_fsdb_response__genrtr__builder);
    return tsf_fsdb_response__genrtr;
#endif
}

#ifndef TSF_HAVE_INIT_POINTER
static pthread_once_t tsf_fsdb_response__parser__oc = PTHREAD_ONCE_INIT;
static void tsf_fsdb_response__parser__builder(void) {
    tsf_fsdb_response__parser = tsf_parser_create(tsf_fsdb_response__get_type());
}
#else
static void *tsf_fsdb_response__parser__builder(void) {
    return tsf_parser_create(tsf_fsdb_response__get_type());
}
#endif
tsf_parser_t *tsf_fsdb_response__get_parser(void) {
#ifdef TSF_HAVE_INIT_POINTER
    return (tsf_parser_t*)tsf_init_pointer((void**)&tsf_fsdb_response__parser, tsf_fsdb_response__parser__builder);
#else
    pthread_once(&tsf_fsdb_response__parser__oc, tsf_fsdb_response__parser__builder);
    return tsf_fsdb_response__parser;
#endif
}
void tsf_fsdb_response__destruct(tsf_fsdb_response_t *data) {
    tsf_fsdb_response__payload__destruct(&data->payload);
}

tsf_bool_t tsf_fsdb_response__write(tsf_stream_file_output_t *out, tsf_fsdb_response_t *data) {
    return tsf_typed_data_write(out, tsf_fsdb_response__get_generator(), data);
}

tsf_fsdb_response_t *tsf_fsdb_response__read(tsf_stream_file_input_t *in) {
    return tsf_typed_data_read(in, tsf_fsdb_response__get_parser());
}

tsf_bool_t tsf_fsdb_response__read_into(tsf_stream_file_input_t *in, tsf_fsdb_response_t *result) {
    return tsf_typed_data_read_into(in, tsf_fsdb_response__get_parser(), result);
}

static tsf_type_t * volatile uint8__array__type = NULL;

#ifndef TSF_HAVE_INIT_POINTER
static pthread_once_t uint8__array__type__oc = PTHREAD_ONCE_INIT;
static void uint8__array__type__builder(void) {
    uint8__array__type = uint8__array__build_type();
}
#else
static void *uint8__array__type__builder(void) {
    return uint8__array__build_type();
}
#endif
tsf_type_t *uint8__array__get_type(void) {
#ifdef TSF_HAVE_INIT_POINTER
    return (tsf_type_t*)tsf_init_pointer((void**)&uint8__array__type, uint8__array__type__builder);
#else
    pthread_once(&uint8__array__type__oc, uint8__array__type__builder);
    return uint8__array__type;
#endif
}
void uint8__array__destruct(uint8__array_t *data) {
    free(data->data);
}

static tsf_type_t * volatile tsf_fsdb_command__put__type = NULL;

#ifndef TSF_HAVE_INIT_POINTER
static pthread_once_t tsf_fsdb_command__put__type__oc = PTHREAD_ONCE_INIT;
static void tsf_fsdb_command__put__type__builder(void) {
    tsf_fsdb_command__put__type = tsf_fsdb_command__put__build_type();
}
#else
static void *tsf_fsdb_command__put__type__builder(void) {
    return tsf_fsdb_command__put__build_type();
}
#endif
tsf_type_t *tsf_fsdb_command__put__get_type(void) {
#ifdef TSF_HAVE_INIT_POINTER
    return (tsf_type_t*)tsf_init_pointer((void**)&tsf_fsdb_command__put__type, tsf_fsdb_command__put__type__builder);
#else
    pthread_once(&tsf_fsdb_command__put__type__oc, tsf_fsdb_command__put__type__builder);
    return tsf_fsdb_command__put__type;
#endif
}
void tsf_fsdb_command__put__destruct(tsf_fsdb_command__put_t *data) {
    tsf_buffer_destroy(*&data->key);
}

static tsf_type_t * volatile tsf_fsdb_command__out_write__type = NULL;

#ifndef TSF_HAVE_INIT_POINTER
static pthread_once_t tsf_fsdb_command__out_write__type__oc = PTHREAD_ONCE_INIT;
static void tsf_fsdb_command__out_write__type__builder(void) {
    tsf_fsdb_command__out_write__type = tsf_fsdb_command__out_write__build_type();
}
#else
static void *tsf_fsdb_command__out_write__type__builder(void) {
    return tsf_fsdb_command__out_write__build_type();
}
#endif
tsf_type_t *tsf_fsdb_command__out_write__get_type(void) {
#ifdef TSF_HAVE_INIT_POINTER
    return (tsf_type_t*)tsf_init_pointer((void**)&tsf_fsdb_command__out_write__type, tsf_fsdb_command__out_write__type__builder);
#else
    pthread_once(&tsf_fsdb_command__out_write__type__oc, tsf_fsdb_command__out_write__type__builder);
    return tsf_fsdb_command__out_write__type;
#endif
}
void tsf_fsdb_command__out_write__destruct(tsf_fsdb_command__out_write_t *data) {
    tsf_fsdb_buffer__destruct(&data->data);
}

static tsf_type_t * volatile tsf_fsdb_command__get__type = NULL;

#ifndef TSF_HAVE_INIT_POINTER
static pthread_once_t tsf_fsdb_command__get__type__oc = PTHREAD_ONCE_INIT;
static void tsf_fsdb_command__get__type__builder(void) {
    tsf_fsdb_command__get__type = tsf_fsdb_command__get__build_type();
}
#else
static void *tsf_fsdb_command__get__type__builder(void) {
    return tsf_fsdb_command__get__build_type();
}
#endif
tsf_type_t *tsf_fsdb_command__get__get_type(void) {
#ifdef TSF_HAVE_INIT_POINTER
    return (tsf_type_t*)tsf_init_pointer((void**)&tsf_fsdb_command__get__type, tsf_fsdb_command__get__type__builder);
#else
    pthread_once(&tsf_fsdb_command__get__type__oc, tsf_fsdb_command__get__type__builder);
    return tsf_fsdb_command__get__type;
#endif
}
void tsf_fsdb_command__get__destruct(tsf_fsdb_command__get_t *data) {
    tsf_buffer_destroy(*&data->key);
}

static tsf_type_t * volatile tsf_fsdb_command__rm__type = NULL;

#ifndef TSF_HAVE_INIT_POINTER
static pthread_once_t tsf_fsdb_command__rm__type__oc = PTHREAD_ONCE_INIT;
static void tsf_fsdb_command__rm__type__builder(void) {
    tsf_fsdb_command__rm__type = tsf_fsdb_command__rm__build_type();
}
#else
static void *tsf_fsdb_command__rm__type__builder(void) {
    return tsf_fsdb_command__rm__build_type();
}
#endif
tsf_type_t *tsf_fsdb_command__rm__get_type(void) {
#ifdef TSF_HAVE_INIT_POINTER
    return (tsf_type_t*)tsf_init_pointer((void**)&tsf_fsdb_command__rm__type, tsf_fsdb_command__rm__type__builder);
#else
    pthread_once(&tsf_fsdb_command__rm__type__oc, tsf_fsdb_command__rm__type__builder);
    return tsf_fsdb_command__rm__type;
#endif
}
void tsf_fsdb_command__rm__destruct(tsf_fsdb_command__rm_t *data) {
    tsf_buffer_destroy(*&data->key);
}

static tsf_type_t * volatile tsf_fsdb_response__payload__type = NULL;

#ifndef TSF_HAVE_INIT_POINTER
static pthread_once_t tsf_fsdb_response__payload__type__oc = PTHREAD_ONCE_INIT;
static void tsf_fsdb_response__payload__type__builder(void) {
    tsf_fsdb_response__payload__type = tsf_fsdb_response__payload__build_type();
}
#else
static void *tsf_fsdb_response__payload__type__builder(void) {
    return tsf_fsdb_response__payload__build_type();
}
#endif
tsf_type_t *tsf_fsdb_response__payload__get_type(void) {
#ifdef TSF_HAVE_INIT_POINTER
    return (tsf_type_t*)tsf_init_pointer((void**)&tsf_fsdb_response__payload__type, tsf_fsdb_response__payload__type__builder);
#else
    pthread_once(&tsf_fsdb_response__payload__type__oc, tsf_fsdb_response__payload__type__builder);
    return tsf_fsdb_response__payload__type;
#endif
}
void tsf_fsdb_response__payload__destruct(tsf_fsdb_response__payload_t *data) {
    switch (data->value) {
    case 1:
        tsf_fsdb_response__payload__welcome__destruct(&data->u.welcome);
        break;
    case 2:
        tsf_fsdb_response__payload__sys_error__destruct(&data->u.sys_error);
        break;
    case 3:
        tsf_fsdb_response__payload__proto_error__destruct(&data->u.proto_error);
        break;
    case 5:
        tsf_fsdb_response__payload__in_data__destruct(&data->u.in_data);
        break;
    default:
        break;
    }
}

static tsf_type_t * volatile tsf_fsdb_response__payload__welcome__type = NULL;

#ifndef TSF_HAVE_INIT_POINTER
static pthread_once_t tsf_fsdb_response__payload__welcome__type__oc = PTHREAD_ONCE_INIT;
static void tsf_fsdb_response__payload__welcome__type__builder(void) {
    tsf_fsdb_response__payload__welcome__type = tsf_fsdb_response__payload__welcome__build_type();
}
#else
static void *tsf_fsdb_response__payload__welcome__type__builder(void) {
    return tsf_fsdb_response__payload__welcome__build_type();
}
#endif
tsf_type_t *tsf_fsdb_response__payload__welcome__get_type(void) {
#ifdef TSF_HAVE_INIT_POINTER
    return (tsf_type_t*)tsf_init_pointer((void**)&tsf_fsdb_response__payload__welcome__type, tsf_fsdb_response__payload__welcome__type__builder);
#else
    pthread_once(&tsf_fsdb_response__payload__welcome__type__oc, tsf_fsdb_response__payload__welcome__type__builder);
    return tsf_fsdb_response__payload__welcome__type;
#endif
}
void tsf_fsdb_response__payload__welcome__destruct(tsf_fsdb_response__payload__welcome_t *data) {
    free(*&data->name);
}

static tsf_type_t * volatile tsf_fsdb_response__payload__welcome__version__type = NULL;

#ifndef TSF_HAVE_INIT_POINTER
static pthread_once_t tsf_fsdb_response__payload__welcome__version__type__oc = PTHREAD_ONCE_INIT;
static void tsf_fsdb_response__payload__welcome__version__type__builder(void) {
    tsf_fsdb_response__payload__welcome__version__type = tsf_fsdb_response__payload__welcome__version__build_type();
}
#else
static void *tsf_fsdb_response__payload__welcome__version__type__builder(void) {
    return tsf_fsdb_response__payload__welcome__version__build_type();
}
#endif
tsf_type_t *tsf_fsdb_response__payload__welcome__version__get_type(void) {
#ifdef TSF_HAVE_INIT_POINTER
    return (tsf_type_t*)tsf_init_pointer((void**)&tsf_fsdb_response__payload__welcome__version__type, tsf_fsdb_response__payload__welcome__version__type__builder);
#else
    pthread_once(&tsf_fsdb_response__payload__welcome__version__type__oc, tsf_fsdb_response__payload__welcome__version__type__builder);
    return tsf_fsdb_response__payload__welcome__version__type;
#endif
}

static tsf_type_t * volatile tsf_fsdb_response__payload__sys_error__type = NULL;

#ifndef TSF_HAVE_INIT_POINTER
static pthread_once_t tsf_fsdb_response__payload__sys_error__type__oc = PTHREAD_ONCE_INIT;
static void tsf_fsdb_response__payload__sys_error__type__builder(void) {
    tsf_fsdb_response__payload__sys_error__type = tsf_fsdb_response__payload__sys_error__build_type();
}
#else
static void *tsf_fsdb_response__payload__sys_error__type__builder(void) {
    return tsf_fsdb_response__payload__sys_error__build_type();
}
#endif
tsf_type_t *tsf_fsdb_response__payload__sys_error__get_type(void) {
#ifdef TSF_HAVE_INIT_POINTER
    return (tsf_type_t*)tsf_init_pointer((void**)&tsf_fsdb_response__payload__sys_error__type, tsf_fsdb_response__payload__sys_error__type__builder);
#else
    pthread_once(&tsf_fsdb_response__payload__sys_error__type__oc, tsf_fsdb_response__payload__sys_error__type__builder);
    return tsf_fsdb_response__payload__sys_error__type;
#endif
}
void tsf_fsdb_response__payload__sys_error__destruct(tsf_fsdb_response__payload__sys_error_t *data) {
    free(*&data->msg);
}

static tsf_type_t * volatile tsf_fsdb_response__payload__proto_error__type = NULL;

#ifndef TSF_HAVE_INIT_POINTER
static pthread_once_t tsf_fsdb_response__payload__proto_error__type__oc = PTHREAD_ONCE_INIT;
static void tsf_fsdb_response__payload__proto_error__type__builder(void) {
    tsf_fsdb_response__payload__proto_error__type = tsf_fsdb_response__payload__proto_error__build_type();
}
#else
static void *tsf_fsdb_response__payload__proto_error__type__builder(void) {
    return tsf_fsdb_response__payload__proto_error__build_type();
}
#endif
tsf_type_t *tsf_fsdb_response__payload__proto_error__get_type(void) {
#ifdef TSF_HAVE_INIT_POINTER
    return (tsf_type_t*)tsf_init_pointer((void**)&tsf_fsdb_response__payload__proto_error__type, tsf_fsdb_response__payload__proto_error__type__builder);
#else
    pthread_once(&tsf_fsdb_response__payload__proto_error__type__oc, tsf_fsdb_response__payload__proto_error__type__builder);
    return tsf_fsdb_response__payload__proto_error__type;
#endif
}
void tsf_fsdb_response__payload__proto_error__destruct(tsf_fsdb_response__payload__proto_error_t *data) {
    free(*&data->msg);
}

static tsf_type_t * volatile tsf_fsdb_response__payload__in_data__type = NULL;

#ifndef TSF_HAVE_INIT_POINTER
static pthread_once_t tsf_fsdb_response__payload__in_data__type__oc = PTHREAD_ONCE_INIT;
static void tsf_fsdb_response__payload__in_data__type__builder(void) {
    tsf_fsdb_response__payload__in_data__type = tsf_fsdb_response__payload__in_data__build_type();
}
#else
static void *tsf_fsdb_response__payload__in_data__type__builder(void) {
    return tsf_fsdb_response__payload__in_data__build_type();
}
#endif
tsf_type_t *tsf_fsdb_response__payload__in_data__get_type(void) {
#ifdef TSF_HAVE_INIT_POINTER
    return (tsf_type_t*)tsf_init_pointer((void**)&tsf_fsdb_response__payload__in_data__type, tsf_fsdb_response__payload__in_data__type__builder);
#else
    pthread_once(&tsf_fsdb_response__payload__in_data__type__oc, tsf_fsdb_response__payload__in_data__type__builder);
    return tsf_fsdb_response__payload__in_data__type;
#endif
}
void tsf_fsdb_response__payload__in_data__destruct(tsf_fsdb_response__payload__in_data_t *data) {
    tsf_fsdb_buffer__destruct(&data->data);
}

