#!/bin/sh

PID=`pgrep hciattach`
sleep 2
if [ "x$PID" != "x" ] ; then
    kill $PID
    sleep 1
fi

echo 134 > /sys/class/gpio/export
echo out > /sys/class/gpio/gpio134/direction
echo 0 > /sys/class/gpio/gpio134/value
echo 1 > /sys/class/gpio/gpio134/value
sleep 1

/usr/bin/hciattach /dev/ttyS1 qca 2000000 -t 120
sleep 1

BT_BDADDR_MAC=$( cat /tmp/.bluetooth_mac )

if [ "x$BT_BDADDR_MAC" != "x" ] ; then

    /usr/bin/hciconfig -a hci0 up
    if [ $? -ne 0 ] ; then
        echo "Failed to Activate BT hci0"
        exit 1
    fi
    sleep 1

    /usr/bin/bdaddr -i hci0 $BT_BDADDR_MAC
    if [ $? -ne 0 ] ; then
        echo "Failed to set BT address to $BT_BDADDR_MAC"
        exit 1
    fi
    sleep 1

    /usr/bin/hciconfig -a hci0 reset
    if [ $? -ne 0 ] ; then
        echo "Failed to reset BT hci0"
        exit 1
    fi
    sleep 2

    /usr/bin/hciconfig -a hci0 down
    if [ $? -ne 0 ] ; then
        echo "Failed to reset BT hci0"
        exit 1
    fi
    sleep 1

    exit 0 
else
    echo "Unable to obtain BT MAC Address"
    exit 1
fi

