/* Replayable replacements for global functions */

/***************************************************************
 * BEGIN STABLE.JS
 **************************************************************/
//! stable.js 0.1.3, https://github.com/Two-Screen/stable
//! © 2012 Stéphan Kochen, Angry Bytes. MIT licensed.
(function() {

// A stable array sort, because `Array#sort()` is not guaranteed stable.
// This is an implementation of merge sort, without recursion.

var stable = function(arr, comp) {
    if (typeof(comp) !== 'function') {
        comp = function(a, b) {
            a = String(a);
            b = String(b);
            if (a < b) return -1;
            if (a > b) return 1;
            return 0;
        };
    }

    var len = arr.length;

    if (len <= 1) return arr;

    // Rather than dividing input, simply iterate chunks of 1, 2, 4, 8, etc.
    // Chunks are the size of the left or right hand in merge sort.
    // Stop when the left-hand covers all of the array.
    var oarr = arr;
    for (var chk = 1; chk < len; chk *= 2) {
        arr = pass(arr, comp, chk);
    }
    for (var i = 0; i < len; i++) {
        oarr[i] = arr[i];
    }
    return oarr;
};

// Run a single pass with the given chunk size. Returns a new array.
var pass = function(arr, comp, chk) {
    var len = arr.length;
    // Output, and position.
    var result = new Array(len);
    var i = 0;
    // Step size / double chunk size.
    var dbl = chk * 2;
    // Bounds of the left and right chunks.
    var l, r, e;
    // Iterators over the left and right chunk.
    var li, ri;

    // Iterate over pairs of chunks.
    for (l = 0; l < len; l += dbl) {
        r = l + chk;
        e = r + chk;
        if (r > len) r = len;
        if (e > len) e = len;

        // Iterate both chunks in parallel.
        li = l;
        ri = r;
        while (true) {
            // Compare the chunks.
            if (li < r && ri < e) {
                // This works for a regular `sort()` compatible comparator,
                // but also for a simple comparator like: `a > b`
                if (comp(arr[li], arr[ri]) <= 0) {
                    result[i++] = arr[li++];
                }
                else {
                    result[i++] = arr[ri++];
                }
            }
            // Nothing to compare, just flush what's left.
            else if (li < r) {
                result[i++] = arr[li++];
            }
            else if (ri < e) {
                result[i++] = arr[ri++];
            }
            // Both iterators are at the chunk ends.
            else {
                break;
            }
        }
    }

    return result;
};

var arrsort = function(comp) {
    return stable(this, comp);
};

if (Object.defineProperty) {
    Object.defineProperty(Array.prototype, "sort", {
        configurable: true, writable: true, enumerable: false,
        value: arrsort
    });
} else {
    Array.prototype.sort = arrsort;
}

})();
/***************************************************************
 * END STABLE.JS
 **************************************************************/

/*
 * In a generated replay, this file is partially common, boilerplate code
 * included in every replay, and partially generated replay code. The following
 * header applies to the boilerplate code. A comment indicating "Auto-generated
 * below this comment" marks the separation between these two parts.
 *
 * Copyright (C) 2011, 2012 Purdue University
 * Written by Gregor Richards
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

(function() {
    // global eval alias
    var geval = eval;

    // detect if we're in a browser or not
    var inbrowser = false;
    var inharness = false;
    var finished = false;
    if (typeof window !== "undefined" && "document" in window) {
        inbrowser = true;
        if (window.parent && "JSBNG_handleResult" in window.parent) {
            inharness = true;
        }
    } else if (typeof global !== "undefined") {
        window = global;
        window.top = window;
    } else {
        window = (function() { return this; })();
        window.top = window;
    }

    if ("console" in window) {
        window.JSBNG_Console = window.console;
    }

    var callpath = [];

    // global state
    var JSBNG_Replay = window.top.JSBNG_Replay = {
        push: function(arr, fun) {
            arr.push(fun);
            return fun;
        },

        path: function(str) {
            verifyPath(str);
        },

        forInKeys: function(of) {
            var keys = [];
            for (var k in of)
                keys.push(k);
            return keys.sort();
        }
    };

    var currentTimeInMS;
    if (inharness) {
        currentTimeInMS = window.parent.currentTimeInMS;
    } else {
        if (window.performance && window.performance.now)
            currentTimeInMS = function() { return window.performance.now() };
        else if (typeof preciseTime !== 'undefined')
            currentTimeInMS = function() { return preciseTime() * 1000; };
        else
            currentTimeInMS = function() { return Date.now(); };
    }

    // the actual replay runner
    function onload() {
        try {
            delete window.onload;
        } catch (ex) {}

        var jr = JSBNG_Replay$;
        var cb = function() {
            var end = currentTimeInMS();
            finished = true;

            var msg = "Time: " + (end - st) + "ms";
    
            if (inharness) {
                window.parent.JSBNG_handleResult({error:false, time:(end - st)});
            } else if (inbrowser) {
                var res = document.createElement("div");
    
                res.style.position = "fixed";
                res.style.left = "1em";
                res.style.top = "1em";
                res.style.width = "35em";
                res.style.height = "5em";
                res.style.padding = "1em";
                res.style.backgroundColor = "white";
                res.style.color = "black";
                res.appendChild(document.createTextNode(msg));
    
                document.body.appendChild(res);
            } else if (typeof console !== "undefined") {
                console.log(msg);
            } else if (typeof print !== "undefined") {
                // hopefully not the browser print() function :)
                print(msg);
            }
        };

        // force it to JIT
        jr(false);

        // then time it
        var st = currentTimeInMS();
        while (jr !== null) {
            jr = jr(true, cb);
        }
    }

    // add a frame at replay time
    function iframe(pageid) {
        var iw;
        if (inbrowser) {
            // represent the iframe as an iframe (of course)
            var iframe = document.createElement("iframe");
            iframe.style.display = "none";
            document.body.appendChild(iframe);
            iw = iframe.contentWindow;
            iw.document.write("<script type=\"text/javascript\">var JSBNG_Replay_geval = eval;</script>");
            iw.document.close();
        } else {
            // no general way, just lie and do horrible things
            var topwin = window;
            (function() {
                var window = {};
                window.window = window;
                window.top = topwin;
                window.JSBNG_Replay_geval = function(str) {
                    eval(str);
                }
                iw = window;
            })();
        }
        return iw;
    }

    // called at the end of the replay stuff
    function finalize() {
        if (inbrowser) {
            setTimeout(onload, 0);
        } else {
            onload();
        }
    }

    // verify this recorded value and this replayed value are close enough
    function verify(rep, rec) {
        if (rec !== rep &&
            (rep === rep || rec === rec) /* NaN test */) {
            // FIXME?
            if (typeof rec === "function" && typeof rep === "function") {
                return true;
            }
            if (typeof rec !== "object" || rec === null ||
                !(("__JSBNG_unknown_" + typeof(rep)) in rec)) {
                return false;
            }
        }
        return true;
    }

    // general message
    var firstMessage = true;
    function replayMessage(msg) {
        if (inbrowser) {
            if (firstMessage)
                document.open();
            firstMessage = false;
            document.write(msg);
        } else {
            console.log(msg);
        }
    }

    // complain when there's an error
    function verificationError(msg) {
        if (finished) return;
        if (inharness) {
            window.parent.JSBNG_handleResult({error:true, msg: msg});
        } else replayMessage(msg);
        throw new Error();
    }

    // to verify a set
    function verifySet(objstr, obj, prop, gvalstr, gval) {
        if (/^on/.test(prop)) {
            // these aren't instrumented compatibly
            return;
        }

        if (!verify(obj[prop], gval)) {
            var bval = obj[prop];
            var msg = "Verification failure! " + objstr + "." + prop + " is not " + gvalstr + ", it's " + bval + "!";
            verificationError(msg);
        }
    }

    // to verify a call or new
    function verifyCall(iscall, func, cthis, cargs) {
        var ok = true;
        var callArgs = func.callArgs[func.inst];
        iscall = iscall ? 1 : 0;
        if (cargs.length !== callArgs.length - 1) {
            ok = false;
        } else {
            if (iscall && !verify(cthis, callArgs[0])) ok = false;
            for (var i = 0; i < cargs.length; i++) {
                if (!verify(cargs[i], callArgs[i+1])) ok = false;
            }
        }
        if (!ok) {
            var msg = "Call verification failure!";
            verificationError(msg);
        }

        return func.returns[func.inst++];
    }

    // to verify the callpath
    function verifyPath(func) {
        var real = callpath.shift();
        if (real !== func) {
            var msg = "Call path verification failure! Expected " + real + ", found " + func;
            verificationError(msg);
        }
    }

    // figure out how to define getters
    var defineGetter;
    if (Object.defineProperty) {
        var odp = Object.defineProperty;
        defineGetter = function(obj, prop, getter, setter) {
            if (typeof setter === "undefined") setter = function(){};
            odp(obj, prop, {"enumerable": true, "configurable": true, "get": getter, "set": setter});
        };
    } else if (Object.prototype.__defineGetter__) {
        var opdg = Object.prototype.__defineGetter__;
        var opds = Object.prototype.__defineSetter__;
        defineGetter = function(obj, prop, getter, setter) {
            if (typeof setter === "undefined") setter = function(){};
            opdg.call(obj, prop, getter);
            opds.call(obj, prop, setter);
        };
    } else {
        defineGetter = function() {
            verificationError("This replay requires getters for correct behavior, and your JS engine appears to be incapable of defining getters. Sorry!");
        };
    }

    var defineRegetter = function(obj, prop, getter, setter) {
        defineGetter(obj, prop, function() {
            return getter.call(this, prop);
        }, function(val) {
            // once it's set by the client, it's claimed
            setter.call(this, prop, val);
            Object.defineProperty(obj, prop, {
                "enumerable": true, "configurable": true, "writable": true,
                "value": val
            });
        });
    }

    // for calling events
    var fpc = Function.prototype.call;

// resist the urge, don't put a })(); here!
/******************************************************************************
 * Auto-generated below this comment
 *****************************************************************************/
var ow876774570 = window;
var f876774570_0;
var o0;
var f876774570_6;
var f876774570_7;
var f876774570_16;
var f876774570_17;
var o1;
var o2;
var o3;
var f876774570_65;
var f876774570_396;
var f876774570_398;
var f876774570_400;
var o4;
var o5;
var f876774570_410;
var o6;
var o7;
var o8;
var f876774570_417;
var f876774570_418;
var f876774570_419;
var f876774570_429;
var f876774570_430;
var f876774570_434;
var f876774570_446;
var f876774570_450;
JSBNG_Replay.s6642b77f01f4d49ef240b29032e6da4372359178_0 = [];
JSBNG_Replay.s62d148c5af61b0a7d54ea938e5a6a16cd1eee833_1 = [];
JSBNG_Replay.s62d148c5af61b0a7d54ea938e5a6a16cd1eee833_2 = [];
JSBNG_Replay.s6642b77f01f4d49ef240b29032e6da4372359178_1 = [];
JSBNG_Replay.s8293f527e56b5e5ce44ad4d8d5c9f8f5b3feb86c_7 = [];
// 1
// record generated by JSBench 323eb38c39a6+ at 2013-07-24T19:56:06.320Z
// 2
// 3
f876774570_0 = function() { return f876774570_0.returns[f876774570_0.inst++]; };
f876774570_0.returns = [];
f876774570_0.inst = 0;
// 4
ow876774570.JSBNG__Date = f876774570_0;
// 5
o0 = {};
// 6
ow876774570.JSBNG__document = o0;
// 15
f876774570_6 = function() { return f876774570_6.returns[f876774570_6.inst++]; };
f876774570_6.returns = [];
f876774570_6.inst = 0;
// 16
ow876774570.JSBNG__removeEventListener = f876774570_6;
// 17
f876774570_7 = function() { return f876774570_7.returns[f876774570_7.inst++]; };
f876774570_7.returns = [];
f876774570_7.inst = 0;
// 18
ow876774570.JSBNG__addEventListener = f876774570_7;
// 19
ow876774570.JSBNG__top = ow876774570;
// 28
ow876774570.JSBNG__scrollX = 0;
// 29
ow876774570.JSBNG__scrollY = 0;
// 38
f876774570_16 = function() { return f876774570_16.returns[f876774570_16.inst++]; };
f876774570_16.returns = [];
f876774570_16.inst = 0;
// 39
ow876774570.JSBNG__setTimeout = f876774570_16;
// 40
f876774570_17 = function() { return f876774570_17.returns[f876774570_17.inst++]; };
f876774570_17.returns = [];
f876774570_17.inst = 0;
// 41
ow876774570.JSBNG__setInterval = f876774570_17;
// 60
ow876774570.JSBNG__frames = ow876774570;
// 63
ow876774570.JSBNG__self = ow876774570;
// 70
ow876774570.JSBNG__content = ow876774570;
// 81
ow876774570.JSBNG__closed = false;
// 84
ow876774570.JSBNG__pkcs11 = null;
// 87
ow876774570.JSBNG__opener = null;
// 88
ow876774570.JSBNG__defaultStatus = "";
// 89
o1 = {};
// 90
ow876774570.JSBNG__location = o1;
// 91
ow876774570.JSBNG__innerWidth = 1078;
// 92
ow876774570.JSBNG__innerHeight = 731;
// 93
ow876774570.JSBNG__outerWidth = 1092;
// 94
ow876774570.JSBNG__outerHeight = 826;
// 95
ow876774570.JSBNG__screenX = 48;
// 96
ow876774570.JSBNG__screenY = 0;
// 97
ow876774570.JSBNG__mozInnerScreenX = 0;
// 98
ow876774570.JSBNG__mozInnerScreenY = 0;
// 99
ow876774570.JSBNG__pageXOffset = 0;
// 100
ow876774570.JSBNG__pageYOffset = 0;
// 101
ow876774570.JSBNG__scrollMaxX = 0;
// 102
ow876774570.JSBNG__scrollMaxY = 0;
// 103
ow876774570.JSBNG__fullScreen = false;
// 136
ow876774570.JSBNG__frameElement = null;
// 141
ow876774570.JSBNG__mozPaintCount = 0;
// 144
ow876774570.JSBNG__mozAnimationStartTime = 1374695829225;
// 145
o2 = {};
// 146
ow876774570.JSBNG__mozIndexedDB = o2;
// 151
o3 = {};
// 152
ow876774570.JSBNG__performance = o3;
// 155
ow876774570.JSBNG__devicePixelRatio = 1;
// 160
f876774570_65 = function() { return f876774570_65.returns[f876774570_65.inst++]; };
f876774570_65.returns = [];
f876774570_65.inst = 0;
// 161
ow876774570.JSBNG__Image = f876774570_65;
// 166
ow876774570.JSBNG__name = "uaMatch";
// 173
ow876774570.JSBNG__status = "";
// 772
ow876774570.JSBNG__indexedDB = o2;
// undefined
o2 = null;
// 807
ow876774570.JSBNG__onerror = null;
// 0
JSBNG_Replay$ = function(real, cb) { if (!real) return;
// 814
geval("Function.prototype.bind = function(to) {\n    var f = this;\n    return function() {\n        Function.prototype.apply.call(f, to, arguments);\n    };\n};");
// 816
// 815
geval("Function.prototype.bind = function(to) {\n    var f = this;\n    return function() {\n        Function.prototype.apply.call(f, to, arguments);\n    };\n};");
// 818
o2 = {};
// 819
f876774570_0.returns.push(o2);
// undefined
o2 = null;
// 817
geval("var ue_t0 = ((ue_t0 || +new JSBNG__Date()));");
// 821
o2 = {};
// 822
f876774570_0.returns.push(o2);
// undefined
o2 = null;
// 823
o2 = {};
// 824
f876774570_0.returns.push(o2);
// undefined
o2 = null;
// 825
o2 = {};
// 826
f876774570_0.returns.push(o2);
// undefined
o2 = null;
// 827
o2 = {};
// 828
f876774570_0.returns.push(o2);
// undefined
o2 = null;
// 829
o2 = {};
// 830
f876774570_0.returns.push(o2);
// undefined
o2 = null;
// 831
ow876774570.JSBNG__onJSBNG__stop = undefined;
// 832
f876774570_396 = function() { return f876774570_396.returns[f876774570_396.inst++]; };
f876774570_396.returns = [];
f876774570_396.inst = 0;
// 833
ow876774570.JSBNG__onbeforeunload = f876774570_396;
// 834
o0.webkitHidden = void 0;
// 835
o0.oHidden = void 0;
// 836
o0.msHidden = void 0;
// 837
o0.mozHidden = false;
// 838
o0.mozVisibilityState = "visible";
// 839
o2 = {};
// 840
f876774570_0.returns.push(o2);
// undefined
o2 = null;
// 841
f876774570_398 = function() { return f876774570_398.returns[f876774570_398.inst++]; };
f876774570_398.returns = [];
f876774570_398.inst = 0;
// 842
o0.JSBNG__addEventListener = f876774570_398;
// 843
f876774570_398.returns.push(undefined);
// 844
f876774570_7.returns.push(undefined);
// 845
f876774570_7.returns.push(undefined);
// 846
o2 = {};
// 847
f876774570_0.returns.push(o2);
// 848
f876774570_400 = function() { return f876774570_400.returns[f876774570_400.inst++]; };
f876774570_400.returns = [];
f876774570_400.inst = 0;
// 849
o2.getTime = f876774570_400;
// undefined
o2 = null;
// 850
f876774570_400.returns.push(1374695829349);
// 851
o2 = {};
// 852
f876774570_0.returns.push(o2);
// undefined
o2 = null;
// 853
o2 = {};
// 854
f876774570_0.returns.push(o2);
// undefined
o2 = null;
// 855
o2 = {};
// 856
f876774570_0.returns.push(o2);
// undefined
o2 = null;
// 820
geval("var ue_csm = window;\nue_csm.ue_hob = ((ue_csm.ue_hob || +new JSBNG__Date()));\n(function(e, a) {\n    var b = {\n        ec: 0,\n        pec: 0,\n        ts: 0,\n        erl: [],\n        mxe: 50,\n        startTimer: function() {\n            b.ts++;\n            JSBNG__setInterval(function() {\n                ((((e.ue && ((b.pec < b.ec)))) && e.uex(\"at\")));\n                b.pec = b.ec;\n            }, 10000);\n        }\n    };\n    function d(f) {\n        if (((b.ec > b.mxe))) {\n            return;\n        }\n    ;\n    ;\n        b.ec++;\n        f.pageURL = ((\"\" + ((a.JSBNG__location ? a.JSBNG__location.href : \"\"))));\n        b.erl.push(f);\n    };\n;\n    function c(i, h, f) {\n        var g = {\n            m: i,\n            f: h,\n            l: f,\n            fromOnError: 1,\n            args: arguments\n        };\n        e.ueLogError(g);\n        return false;\n    };\n;\n    c.skipTrace = 1;\n    d.skipTrace = 1;\n    e.ueLogError = d;\n    e.ue_err = b;\n    a.JSBNG__onerror = c;\n})(ue_csm, window);\nue_csm.ue_hoe = +new JSBNG__Date();\nvar ue_id = \"0JNNCCYK0E23P11J4NSE\", ue_sid = \"181-0531756-0630505\", ue_mid = \"ATVPDKIKX0DER\", ue_sn = \"www.amazon.com\", ue_url = \"/JavaScript-Good-Parts-Douglas-Crockford/dp/0596517742/ref=sr_1_1/uedata/nvp/unsticky/181-0531756-0630505/Detail/ntpoffrw\", ue_furl = \"fls-na.amazon.com\", ue_pr = 0, ue_navtiming = 1, ue_log_idx = 0, ue_log_f = 0, ue_fcsn = 1, ue_ctb0tf = 1, ue_fst = 0, ue_fna = 1, ue_swi = 1, ue_swm = 4, ue_ufia = 1, ue_onbful = 3;\nif (!window.ue_csm) {\n    var ue_csm = window;\n}\n;\n;\nue_csm.ue_hob = ((ue_csm.ue_hob || +new JSBNG__Date));\nfunction ue_viz() {\n    (function(d, j, g) {\n        var b, l, e, a, c = [\"\",\"moz\",\"ms\",\"o\",\"webkit\",], k = 0, f = 20, h = \"JSBNG__addEventListener\", i = \"JSBNG__attachEvent\";\n        while ((((b = c.pop()) && !k))) {\n            l = ((((b ? ((b + \"H\")) : \"h\")) + \"idden\"));\n            if (k = ((typeof j[l] == \"boolean\"))) {\n                e = ((b + \"visibilitychange\"));\n                a = ((b + \"VisibilityState\"));\n            }\n        ;\n        ;\n        };\n    ;\n        {\n            function m(q) {\n                if (((d.ue.viz.length < f))) {\n                    var p = q.type, n = q.originalEvent;\n                    if (!((((/^focus./.test(p) && n)) && ((((n.toElement || n.fromElement)) || n.relatedTarget))))) {\n                        var r = ((j[a] || ((((((p == \"JSBNG__blur\")) || ((p == \"focusout\")))) ? \"hidden\" : \"visible\")))), o = ((+new JSBNG__Date - d.ue.t0));\n                        d.ue.viz.push(((((r + \":\")) + o)));\n                        ((((((ue.iel && ((ue.iel.length > 0)))) && ((r == \"visible\")))) && uex(\"at\")));\n                    }\n                ;\n                ;\n                }\n            ;\n            ;\n            };\n            ((window.top.JSBNG_Replay.s8293f527e56b5e5ce44ad4d8d5c9f8f5b3feb86c_7.push)((m)));\n        };\n    ;\n        m({\n        });\n        if (k) {\n            j[h](e, m, 0);\n        }\n    ;\n    ;\n    })(ue_csm, JSBNG__document, window);\n};\n;\nue_csm.ue_hoe = +new JSBNG__Date;\nue_csm.ue_hob = ((ue_csm.ue_hob || +new JSBNG__Date()));\n(function(e, h) {\n    e.ueinit = ((((e.ueinit || 0)) + 1));\n    e.ue = {\n        t0: ((h.aPageStart || e.ue_t0)),\n        id: e.ue_id,\n        url: e.ue_url,\n        a: \"\",\n        b: \"\",\n        h: {\n        },\n        r: {\n            ld: 0,\n            oe: 0,\n            ul: 0\n        },\n        s: 1,\n        t: {\n        },\n        sc: {\n        },\n        iel: [],\n        ielf: [],\n        fc_idx: {\n        },\n        viz: [],\n        v: 31\n    };\n    e.ue.tagC = function() {\n        var j = [];\n        return function(k) {\n            if (k) {\n                j.push(k);\n            }\n        ;\n        ;\n            return j.slice(0);\n        };\n    };\n    e.ue.tag = e.ue.tagC();\n    e.ue.ifr = ((((((h.JSBNG__top !== h.JSBNG__self)) || (h.JSBNG__frameElement))) ? 1 : 0));\n    function c(l, o, q, n) {\n        if (((e.ue_log_f && e.ue.log))) {\n            e.ue.log({\n                f: \"uet\",\n                en: l,\n                s: o,\n                so: q,\n                to: n\n            }, \"csm\");\n        }\n    ;\n    ;\n        var p = ((n || (new JSBNG__Date()).getTime()));\n        var j = ((!o && ((typeof q != \"undefined\"))));\n        if (j) {\n            return;\n        }\n    ;\n    ;\n        if (l) {\n            var m = ((o ? ((d(\"t\", o) || d(\"t\", o, {\n            }))) : e.ue.t));\n            m[l] = p;\n            {\n                var fin0keys = ((window.top.JSBNG_Replay.forInKeys)((q))), fin0i = (0);\n                var k;\n                for (; (fin0i < fin0keys.length); (fin0i++)) {\n                    ((k) = (fin0keys[fin0i]));\n                    {\n                        d(k, o, q[k]);\n                    };\n                };\n            };\n        ;\n        }\n    ;\n    ;\n        return p;\n    };\n;\n    function d(k, l, m) {\n        if (((e.ue_log_f && e.ue.log))) {\n            e.ue.log({\n                f: \"ues\",\n                k: k,\n                s: l,\n                v: m\n            }, \"csm\");\n        }\n    ;\n    ;\n        var n, j;\n        if (k) {\n            n = j = e.ue;\n            if (((l && ((l != n.id))))) {\n                j = n.sc[l];\n                if (!j) {\n                    j = {\n                    };\n                    ((m ? (n.sc[l] = j) : j));\n                }\n            ;\n            ;\n            }\n        ;\n        ;\n            n = ((m ? (j[k] = m) : j[k]));\n        }\n    ;\n    ;\n        return n;\n    };\n;\n    function g(n, o, m, k, j) {\n        if (((e.ue_log_f && e.ue.log))) {\n            e.ue.log({\n                f: \"ueh\",\n                ek: n\n            }, \"csm\");\n        }\n    ;\n    ;\n        var l = ((\"JSBNG__on\" + m)), p = o[l];\n        if (((typeof (p) == \"function\"))) {\n            if (n) {\n                e.ue.h[n] = p;\n            }\n        ;\n        ;\n        }\n         else {\n            p = function() {\n            \n            };\n        }\n    ;\n    ;\n        o[l] = ((j ? function(q) {\n            k(q);\n            p(q);\n        } : function(q) {\n            p(q);\n            k(q);\n        }));\n        o[l].isUeh = 1;\n    };\n;\n    function b(t, n, s) {\n        if (((e.ue_log_f && e.ue.log))) {\n            e.ue.log({\n                f: \"uex\",\n                en: t,\n                s: n,\n                so: s\n            }, \"csm\");\n        }\n    ;\n    ;\n        function l(P, N) {\n            var L = [P,], G = 0, M = {\n            }, E;\n            if (N) {\n                L.push(\"m=1\");\n                M[N] = 1;\n            }\n             else {\n                M = e.ue.sc;\n            }\n        ;\n        ;\n            {\n                var fin1keys = ((window.top.JSBNG_Replay.forInKeys)((M))), fin1i = (0);\n                var F;\n                for (; (fin1i < fin1keys.length); (fin1i++)) {\n                    ((F) = (fin1keys[fin1i]));\n                    {\n                        var H = d(\"wb\", F), K = ((d(\"t\", F) || {\n                        })), J = ((d(\"t0\", F) || e.ue.t0));\n                        if (((N || ((H == 2))))) {\n                            var O = ((H ? G++ : \"\"));\n                            L.push(((((((\"sc\" + O)) + \"=\")) + F)));\n                            {\n                                var fin2keys = ((window.top.JSBNG_Replay.forInKeys)((K))), fin2i = (0);\n                                var I;\n                                for (; (fin2i < fin2keys.length); (fin2i++)) {\n                                    ((I) = (fin2keys[fin2i]));\n                                    {\n                                        if (((((I.length <= 3)) && K[I]))) {\n                                            L.push(((((((I + O)) + \"=\")) + ((K[I] - J)))));\n                                        }\n                                    ;\n                                    ;\n                                    };\n                                };\n                            };\n                        ;\n                            L.push(((((((\"t\" + O)) + \"=\")) + K[t])));\n                            if (((d(\"ctb\", F) || d(\"wb\", F)))) {\n                                E = 1;\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                    };\n                };\n            };\n        ;\n            if (((!o && E))) {\n                L.push(\"ctb=1\");\n            }\n        ;\n        ;\n            return L.join(\"&\");\n        };\n    ;\n        function w(H, F, J, E) {\n            if (!H) {\n                return;\n            }\n        ;\n        ;\n            var I = new JSBNG__Image(), K = ((((((!E || !e.ue.log)) || !h.amznJQ)) || ((h.amznJQ && h.amznJQ.isMock)))), L = e.ue_err;\n            function G() {\n                if (!e.ue.b) {\n                    return;\n                }\n            ;\n            ;\n                var M = e.ue.b;\n                e.ue.b = \"\";\n                w(M, F, J, 1);\n            };\n        ;\n            if (((e.ue.b && !e.ue_swi))) {\n                I.JSBNG__onload = G;\n            }\n        ;\n        ;\n            if (K) {\n                e.ue.iel.push(I);\n                I.src = H;\n            }\n        ;\n        ;\n            if (((e.ue.log && ((((J || E)) || e.ue_ctb0tf))))) {\n                e.ue.log(H, \"uedata\", {\n                    n: 1\n                });\n                e.ue.ielf.push(H);\n            }\n        ;\n        ;\n            if (((L && !L.ts))) {\n                L.startTimer();\n            }\n        ;\n        ;\n            if (e.ue_swi) {\n                G();\n            }\n        ;\n        ;\n        };\n    ;\n        function C(E) {\n            if (!ue.collected) {\n                var G = E.timing, F = E.navigation;\n                if (G) {\n                    e.ue.t.na_ = G.navigationStart;\n                    e.ue.t.ul_ = G.unloadEventStart;\n                    e.ue.t._ul = G.unloadEventEnd;\n                    e.ue.t.rd_ = G.redirectStart;\n                    e.ue.t._rd = G.redirectEnd;\n                    e.ue.t.fe_ = G.fetchStart;\n                    e.ue.t.lk_ = G.domainLookupStart;\n                    e.ue.t._lk = G.domainLookupEnd;\n                    e.ue.t.co_ = G.connectStart;\n                    e.ue.t._co = G.connectEnd;\n                    e.ue.t.sc_ = G.secureConnectionStart;\n                    e.ue.t.rq_ = G.requestStart;\n                    e.ue.t.rs_ = G.responseStart;\n                    e.ue.t._rs = G.responseEnd;\n                    e.ue.t.dl_ = G.domLoading;\n                    e.ue.t.di_ = G.domInteractive;\n                    e.ue.t.de_ = G.domContentLoadedEventStart;\n                    e.ue.t._de = G.domContentLoadedEventEnd;\n                    e.ue.t._dc = G.domComplete;\n                    e.ue.t.ld_ = G.loadEventStart;\n                    e.ue.t._ld = G.loadEventEnd;\n                }\n            ;\n            ;\n                if (F) {\n                    e.ue.t.ty = ((F.type + e.ue.t0));\n                    e.ue.t.rc = ((F.redirectCount + e.ue.t0));\n                    if (e.ue.tag) {\n                        e.ue.tag(((F.redirectCount ? \"redirect\" : \"nonredirect\")));\n                    }\n                ;\n                ;\n                }\n            ;\n            ;\n                e.ue.collected = 1;\n            }\n        ;\n        ;\n        };\n    ;\n        if (((!n && ((typeof s != \"undefined\"))))) {\n            return;\n        }\n    ;\n    ;\n        {\n            var fin3keys = ((window.top.JSBNG_Replay.forInKeys)((s))), fin3i = (0);\n            var j;\n            for (; (fin3i < fin3keys.length); (fin3i++)) {\n                ((j) = (fin3keys[fin3i]));\n                {\n                    d(j, n, s[j]);\n                };\n            };\n        };\n    ;\n        c(\"pc\", n, s);\n        var y = ((d(\"id\", n) || e.ue.id)), q = ((((((((((((e.ue.url + \"?\")) + t)) + \"&v=\")) + e.ue.v)) + \"&id=\")) + y)), o = ((d(\"ctb\", n) || d(\"wb\", n)));\n        if (o) {\n            q += ((\"&ctb=\" + o));\n        }\n    ;\n    ;\n        if (((e.ueinit > 1))) {\n            q += ((\"&ic=\" + e.ueinit));\n        }\n    ;\n    ;\n        var B = ((h.JSBNG__performance || h.JSBNG__webkitPerformance)), z = e.ue.bfini, r = ((((B && B.navigation)) && ((B.navigation.type == 2)))), p = ((((n && ((n != y)))) && d(\"ctb\", n))), k;\n        if (!p) {\n            if (((z && ((z > 1))))) {\n                q += ((\"&bft=\" + ((z - 1))));\n                q += \"&bfform=1\";\n            }\n             else {\n                if (r) {\n                    q += \"&bft=1\";\n                }\n            ;\n            ;\n            }\n        ;\n        ;\n            if (r) {\n                q += \"&bfnt=1\";\n            }\n        ;\n        ;\n        }\n    ;\n    ;\n        if (((((e.ue._fi && ((t == \"at\")))) && ((!n || ((n == y))))))) {\n            q += e.ue._fi();\n        }\n    ;\n    ;\n        if (((((((t == \"ld\")) || ((t == \"ul\")))) && ((!n || ((n == y))))))) {\n            if (((t == \"ld\"))) {\n                if (((h.JSBNG__onbeforeunload && h.JSBNG__onbeforeunload.isUeh))) {\n                    h.JSBNG__onbeforeunload = null;\n                }\n            ;\n            ;\n                ue.r.ul = e.ue_onbful;\n                if (((e.ue_onbful == 3))) {\n                    i(\"beforeunload\", e.onUl);\n                }\n            ;\n            ;\n                if (((JSBNG__document.ue_backdetect && JSBNG__document.ue_backdetect.ue_back))) {\n                    JSBNG__document.ue_backdetect.ue_back.value++;\n                }\n            ;\n            ;\n                if (e._uess) {\n                    k = e._uess();\n                }\n            ;\n            ;\n            }\n        ;\n        ;\n            if (((((e.ue_navtiming && B)) && B.timing))) {\n                d(\"ctb\", y, \"1\");\n                if (((e.ue_navtiming == 1))) {\n                    e.ue.t.tc = B.timing.navigationStart;\n                }\n            ;\n            ;\n            }\n        ;\n        ;\n            if (B) {\n                C(B);\n            }\n        ;\n        ;\n            e.ue.t.hob = e.ue_hob;\n            e.ue.t.hoe = e.ue_hoe;\n            if (e.ue.ifr) {\n                q += \"&ifr=1\";\n            }\n        ;\n        ;\n        }\n    ;\n    ;\n        c(t, n, s);\n        var x = ((((((t == \"ld\")) && n)) && d(\"wb\", n))), A = 1;\n        if (x) {\n            d(\"wb\", n, 2);\n        }\n    ;\n    ;\n        {\n            var fin4keys = ((window.top.JSBNG_Replay.forInKeys)((e.ue.sc))), fin4i = (0);\n            var v;\n            for (; (fin4i < fin4keys.length); (fin4i++)) {\n                ((v) = (fin4keys[fin4i]));\n                {\n                    if (((d(\"wb\", v) == 1))) {\n                        A = 0;\n                        break;\n                    }\n                ;\n                ;\n                };\n            };\n        };\n    ;\n        if (x) {\n            if (((!e.ue.s && ((e.ue_swi || ((A && !e.ue_swi))))))) {\n                q = l(q, null);\n            }\n             else {\n                return;\n            }\n        ;\n        ;\n        }\n         else {\n            if (((((A && !e.ue_swi)) || e.ue_swi))) {\n                var D = l(q, null);\n                if (((D != q))) {\n                    e.ue.b = D;\n                }\n            ;\n            ;\n            }\n        ;\n        ;\n            if (k) {\n                q += k;\n            }\n        ;\n        ;\n            q = l(q, ((n || e.ue.id)));\n        }\n    ;\n    ;\n        if (((e.ue.b || x))) {\n            {\n                var fin5keys = ((window.top.JSBNG_Replay.forInKeys)((e.ue.sc))), fin5i = (0);\n                var v;\n                for (; (fin5i < fin5keys.length); (fin5i++)) {\n                    ((v) = (fin5keys[fin5i]));\n                    {\n                        if (((d(\"wb\", v) == 2))) {\n                            delete e.ue.sc[v];\n                        }\n                    ;\n                    ;\n                    };\n                };\n            };\n        ;\n        }\n    ;\n    ;\n        var u = 0;\n        if (!x) {\n            e.ue.s = 0;\n            var m = e.ue_err;\n            if (((((m && ((m.ec > 0)))) && ((m.pec < m.ec))))) {\n                m.pec = m.ec;\n                q += ((\"&ec=\" + m.ec));\n            }\n        ;\n        ;\n            u = d(\"ctb\", n);\n            d(\"t\", n, {\n            });\n        }\n    ;\n    ;\n        if (((!h.amznJQ && e.ue.tag))) {\n            e.ue.tag(\"noAmznJQ\");\n        }\n    ;\n    ;\n        if (((((q && e.ue.tag)) && ((e.ue.tag().length > 0))))) {\n            q += ((\"&csmtags=\" + e.ue.tag().join(\"|\")));\n            e.ue.tag = e.ue.tagC();\n        }\n    ;\n    ;\n        if (((((q && e.ue.viz)) && ((e.ue.viz.length > 0))))) {\n            q += ((\"&viz=\" + e.ue.viz.join(\"|\")));\n            e.ue.viz = [];\n        }\n    ;\n    ;\n        e.ue.a = q;\n        w(q, t, u, x);\n    };\n;\n    function a(j, k, l) {\n        l = ((l || h));\n        if (l.JSBNG__addEventListener) {\n            l.JSBNG__addEventListener(j, k, false);\n        }\n         else {\n            if (l.JSBNG__attachEvent) {\n                l.JSBNG__attachEvent(((\"JSBNG__on\" + j)), k);\n            }\n        ;\n        ;\n        }\n    ;\n    ;\n    };\n;\n    ue.attach = a;\n    function i(j, k, l) {\n        l = ((l || h));\n        if (l.JSBNG__removeEventListener) {\n            l.JSBNG__removeEventListener(j, k);\n        }\n         else {\n            if (l.JSBNG__detachEvent) {\n                l.JSBNG__detachEvent(((\"JSBNG__on\" + j)), k);\n            }\n        ;\n        ;\n        }\n    ;\n    ;\n    };\n;\n    ue.detach = i;\n    function f() {\n        if (((e.ue_log_f && e.ue.log))) {\n            e.ue.log({\n                f: \"uei\"\n            }, \"csm\");\n        }\n    ;\n    ;\n        var l = e.ue.r;\n        function k(n) {\n            return function() {\n                if (!l[n]) {\n                    l[n] = 1;\n                    b(n);\n                }\n            ;\n            ;\n            };\n        };\n    ;\n        e.onLd = k(\"ld\");\n        e.onLdEnd = k(\"ld\");\n        e.onUl = k(\"ul\");\n        var j = {\n            beforeunload: e.onUl,\n            JSBNG__stop: k(\"os\")\n        };\n        {\n            var fin6keys = ((window.top.JSBNG_Replay.forInKeys)((j))), fin6i = (0);\n            var m;\n            for (; (fin6i < fin6keys.length); (fin6i++)) {\n                ((m) = (fin6keys[fin6i]));\n                {\n                    g(0, h, m, j[m]);\n                };\n            };\n        };\n    ;\n        ((e.ue_viz && ue_viz()));\n        a(\"load\", e.onLd);\n        if (((e.ue_onbful == 3))) {\n            a(\"beforeunload\", e.onUl);\n        }\n    ;\n    ;\n        c(\"ue\");\n    };\n;\n    ue.reset = function(k, j) {\n        if (!k) {\n            return;\n        }\n    ;\n    ;\n        ((e.ue_cel && e.ue_cel.reset()));\n        e.ue.t0 = +new JSBNG__Date();\n        e.ue.rid = k;\n        e.ue.id = k;\n        e.ue.fc_idx = {\n        };\n        e.ue.viz = [];\n    };\n    e.uei = f;\n    e.ueh = g;\n    e.ues = d;\n    e.uet = c;\n    e.uex = b;\n    f();\n})(ue_csm, window);\nue_csm.ue_hoe = +new JSBNG__Date();\nue_csm.ue_hob = ((ue_csm.ue_hob || +new JSBNG__Date()));\n(function(b) {\n    var a = b.ue;\n    a.rid = b.ue_id;\n    a.sid = b.ue_sid;\n    a.mid = b.ue_mid;\n    a.furl = b.ue_furl;\n    a.sn = b.ue_sn;\n    a.lr = [];\n    a.log = function(e, d, c) {\n        if (((a.lr.length == 500))) {\n            return;\n        }\n    ;\n    ;\n        a.lr.push([\"l\",e,d,c,a.d(),a.rid,]);\n    };\n    a.d = function(c) {\n        return ((+new JSBNG__Date - ((c ? 0 : a.t0))));\n    };\n})(ue_csm);\nue_csm.ue_hoe = +new JSBNG__Date();");
// 858
o2 = {};
// 859
f876774570_65.returns.push(o2);
// 860
// undefined
o2 = null;
// 857
geval("(function() {\n    var i = new JSBNG__Image;\n    i.src = \"http://ecx.images-amazon.com/images/I/51gdVAEfPUL._BO2,204,203,200_PIsitb-sticker-arrow-click,TopRight,35,-76_AA300_SH20_OU01_.jpg\";\n})();");
// 861
geval("var amznJQ, jQueryPatchIPadOffset = false;\n(function() {\n    function f(x) {\n        return function() {\n            x.push(arguments);\n        };\n    };\n;\n    function ch(y) {\n        return String.fromCharCode(y);\n    };\n;\n    var a = [], c = [], cs = [], d = [], l = [], o = [], s = [], p = [], t = [];\n    amznJQ = {\n        _timesliceJS: false,\n        _a: a,\n        _c: c,\n        _cs: cs,\n        _d: d,\n        _l: l,\n        _o: o,\n        _s: s,\n        _pl: p,\n        addLogical: f(l),\n        addStyle: f(s),\n        addPL: f(p),\n        available: f(a),\n        chars: {\n            EOL: ch(10),\n            SQUOTE: ch(39),\n            DQUOTE: ch(34),\n            BACKSLASH: ch(92),\n            YEN: ch(165)\n        },\n        completedStage: f(cs),\n        declareAvailable: f(d),\n        onCompletion: f(c),\n        onReady: f(o),\n        strings: {\n        }\n    };\n}());");
// 862
geval("function amz_js_PopWin(url, JSBNG__name, options) {\n    var ContextWindow = window.open(url, JSBNG__name, options);\n    ContextWindow.JSBNG__focus();\n    return false;\n};\n;");
// 863
geval("function showElement(id) {\n    var elm = JSBNG__document.getElementById(id);\n    if (elm) {\n        elm.style.visibility = \"visible\";\n        if (((elm.getAttribute(\"JSBNG__name\") == \"heroQuickPromoDiv\"))) {\n            elm.style.display = \"block\";\n        }\n    ;\n    ;\n    }\n;\n;\n};\n;\nfunction hideElement(id) {\n    var elm = JSBNG__document.getElementById(id);\n    if (elm) {\n        elm.style.visibility = \"hidden\";\n        if (((elm.getAttribute(\"JSBNG__name\") == \"heroQuickPromoDiv\"))) {\n            elm.style.display = \"none\";\n        }\n    ;\n    ;\n    }\n;\n;\n};\n;\nfunction showHideElement(h_id, div_id) {\n    var hiddenTag = JSBNG__document.getElementById(h_id);\n    if (hiddenTag) {\n        showElement(div_id);\n    }\n     else {\n        hideElement(div_id);\n    }\n;\n;\n};\n;\nwindow.isBowserFeatureCleanup = 1;\nvar touchDeviceDetected = false;\nvar CSMReqs = {\n    af: {\n        c: 2,\n        e: \"amznJQ.AboveTheFold\",\n        p: \"atf\"\n    },\n    cf: {\n        c: 2,\n        e: \"amznJQ.criticalFeature\",\n        p: \"cf\"\n    }\n};\nfunction setCSMReq(a) {\n    a = a.toLowerCase();\n    var b = CSMReqs[a];\n    if (((b && ((--b.c == 0))))) {\n        if (((typeof uet == \"function\"))) {\n            uet(a);\n        }\n    ;\n    ;\n    ;\n        if (b.e) {\n            amznJQ.completedStage(b.e);\n        }\n    ;\n    ;\n    ;\n        if (((typeof P != \"undefined\"))) {\n            P.register(b.p);\n        }\n    ;\n    ;\n    ;\n    }\n;\n;\n};\n;");
// 864
geval("var gbEnableTwisterJS = 0;\nvar isTwisterPage = 0;");
// 865
geval("if (window.amznJQ) {\n    amznJQ.addLogical(\"csm-base\", [\"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/csm-base/csm-base-min-1614510824._V1_.js\",]);\n    amznJQ.available(\"csm-base\", function() {\n    \n    });\n}\n;\n;");
// 866
geval("amznJQ.onCompletion(\"amznJQ.criticalFeature\", function() {\n    amznJQ.available(\"navbarJS-jQuery\", function() {\n    \n    });\n    amznJQ.available(\"finderFitsJS\", function() {\n    \n    });\n    amznJQ.available(\"twister\", function() {\n    \n    });\n    amznJQ.available(\"swfjs\", function() {\n    \n    });\n});");
// 867
geval("(function(d) {\n    var e = function(d) {\n        function b(f, c, b) {\n            f[b] = function() {\n                a._replay.push(c.concat({\n                    m: b,\n                    a: [].slice.call(arguments)\n                }));\n            };\n        };\n    ;\n        var a = {\n        };\n        a._sourceName = d;\n        a._replay = [];\n        a.getNow = function(a, b) {\n            return b;\n        };\n        a.when = function() {\n            var a = [{\n                m: \"when\",\n                a: [].slice.call(arguments)\n            },], c = {\n            };\n            b(c, a, \"run\");\n            b(c, a, \"declare\");\n            b(c, a, \"publish\");\n            b(c, a, \"build\");\n            return c;\n        };\n        b(a, [], \"declare\");\n        b(a, [], \"build\");\n        b(a, [], \"publish\");\n        b(a, [], \"importEvent\");\n        e._shims.push(a);\n        return a;\n    };\n    e._shims = [];\n    ((d.$Nav || (d.$Nav = e(\"rcx-nav\"))));\n    ((d.$Nav.make || (d.$Nav.make = e)));\n})(window);\nwindow.$Nav.when(\"exposeSBD.enable\", \"img.horz\", \"img.vert\", \"img.spin\", \"$popover\", \"btf.full\").run(function(d, e, j, b) {\n    function a(a) {\n        switch (typeof a) {\n          case \"boolean\":\n            h = a;\n            i = !0;\n            break;\n          case \"function\":\n            g = a;\n            c++;\n            break;\n          default:\n            c++;\n        };\n    ;\n        ((((i && ((2 < c)))) && g(h)));\n    };\n;\n    function f(a, b) {\n        var c = new JSBNG__Image;\n        ((b && (c.JSBNG__onload = b)));\n        c.src = a;\n        return c;\n    };\n;\n    var c = 0, g, h, i = !1;\n    f(e, ((d && a)));\n    f(j, ((d && a)));\n    window.$Nav.declare(\"protectExposeSBD\", a);\n    window.$Nav.declare(\"preloadSpinner\", function() {\n        f(b);\n    });\n});\n((window.amznJQ && amznJQ.available(\"navbarJS-beacon\", function() {\n\n})));\nwindow._navbarSpriteUrl = \"http://g-ecx.images-amazon.com/images/G/01/gno/beacon/BeaconSprite-US-01._V397411194_.png\";\n$Nav.importEvent(\"navbarJS-beacon\");\n$Nav.importEvent(\"NavAuiJS\");\n$Nav.declare(\"exposeSBD.enable\", false);\n$Nav.declare(\"img.spin\", \"http://g-ecx.images-amazon.com/images/G/01/javascripts/lib/popover/images/snake._V192571611_.gif\");\n$Nav.when(\"$\").run(function($) {\n    var ie6 = (($.browser.msie && ((parseInt($.browser.version) <= 6))));\n    $Nav.declare(\"img.horz\", ((ie6 ? \"http://g-ecx.images-amazon.com/images/G/01/gno/beacon/nav-pop-8bit-h._V155961234_.png\" : \"http://g-ecx.images-amazon.com/images/G/01/gno/beacon/nav-pop-h-v2._V137157005_.png\")));\n    $Nav.declare(\"img.vert\", ((ie6 ? \"http://g-ecx.images-amazon.com/images/G/01/gno/beacon/nav-pop-8bit-v._V155961234_.png\" : \"http://g-ecx.images-amazon.com/images/G/01/gno/beacon/nav-pop-v-v2._V137157005_.png\")));\n});");
// 869
o2 = {};
// 870
f876774570_0.returns.push(o2);
// 871
o2.getTime = f876774570_400;
// undefined
o2 = null;
// 872
f876774570_400.returns.push(1374695829400);
// 868
geval("window.Navbar = function(options) {\n    options = ((options || {\n    }));\n    this._loadedCount = 0;\n    this._hasUedata = ((typeof uet == \"function\"));\n    this._finishLoadQuota = ((options[\"finishLoadQuota\"] || 2));\n    this._startedLoading = false;\n    this._btfFlyoutContents = [];\n    this._saFlyoutHorizOffset = -16;\n    this._saMaskHorizOffset = -17;\n    this._sbd_config = {\n        major_delay: 300,\n        minor_delay: 100,\n        target_slop: 25\n    };\n    ((window.$Nav && $Nav.declare(\"config.sbd\", this._sbd_config)));\n    this.addToBtfFlyoutContents = function(JSBNG__content, callback) {\n        this._btfFlyoutContents.push({\n            JSBNG__content: JSBNG__content,\n            callback: callback\n        });\n    };\n    this.getBtfFlyoutContents = function() {\n        return this._btfFlyoutContents;\n    };\n    this.loading = function() {\n        if (((!this._startedLoading && this._isReportingEvents()))) {\n            uet(\"ns\");\n        }\n    ;\n    ;\n        this._startedLoading = true;\n    };\n    this.componentLoaded = function() {\n        this._loadedCount++;\n        if (((((this._startedLoading && this._isReportingEvents())) && ((this._loadedCount == this._finishLoadQuota))))) {\n            uet(\"ne\");\n        }\n    ;\n    ;\n    };\n    this._isReportingEvents = function() {\n        return this._hasUedata;\n    };\n    this.browsepromos = {\n    };\n    this.issPromos = [];\n    var le = {\n    };\n    this.logEv = function(d, o) {\n    \n    };\n    ((window.$Nav && $Nav.declare(\"logEvent\", this.logEv)));\n};\nwindow._navbar = new Navbar({\n    finishLoadQuota: 1\n});\n_navbar.loading();\n((window.$Nav && $Nav.declare(\"config.lightningDeals\", ((window._navbar._lightningDealsData || {\n})))));\n((window.$Nav && $Nav.declare(\"config.swmStyleData\", ((window._navbar._swmStyleData || {\n})))));\n_navbar._ajaxProximity = [141,7,60,150,];\n((window.$Nav && $Nav.declare(\"config.ajaxProximity\", window._navbar._ajaxProximity)));");
// 874
o2 = {};
// 875
f876774570_0.returns.push(o2);
// 876
o2.getTime = f876774570_400;
// undefined
o2 = null;
// 877
f876774570_400.returns.push(1374695829403);
// 873
geval("(function(w, d, e, o) {\n    var i = \"DAnsm\";\n    if (w.uDA = ((((w.ues && w.uet)) && w.uex))) {\n        ues(\"wb\", i, 1);\n        uet(\"bb\", i, {\n            wb: 1\n        });\n    }\n;\n;\n    var methodToBind = \"amznJQ.onCompletion\";\n    if (((((!w.amznJQ && ((methodToBind == \"amznJQ.onCompletion\")))) && ((typeof (P) != \"undefined\"))))) {\n        P.when(\"amznJQ.criticalFeature\").execute(function() {\n            o = w.DA;\n            if (!o) {\n                o = w.DA = [];\n                e = d.createElement(\"script\");\n                e.src = \"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/DA-us/DA-us-1236030632._V380600703_.js\";\n                d.getElementsByTagName(\"head\")[0].appendChild(e);\n            }\n        ;\n        ;\n            o.push({\n                c: 3961,\n                a: \"site=amazon.us;pt=Detail;slot=nav-sitewide-msg;pid=0596517742;prid=0JNNCCYK0E23P11J4NSE;arid=7716c88fbe0c4f63a1e2567d4e33f705\",\n                w: 415,\n                h: 50,\n                f: 1,\n                g: \"right\",\n                r: 1,\n                v: 1,\n                y: \"na\",\n                u: \"amzn.us.dp.atn.books/computer_internet;sz=300x31;oe=ISO-8859-1;u=7716c88fbe0c4f63a1e2567d4e33f705;s=i0;s=i1;s=i2;s=i3;s=i4;s=i5;s=i6;s=i7;s=i9;s=m1;s=m4;s=u4;s=u5;s=u10;s=u35;z=1716;z=1688;z=1801;z=1782;s=3072;s=32;s=1009;cid=vegas2;dc_ref=http%3A%2F%2Fwww.amazon.com;tile=1;ord=0JNNCCYK0E23P11J4NSE;cid=vegas2\",\n                q: \"N4215\"\n            });\n        });\n    }\n     else {\n        amznJQ.onCompletion(\"amznJQ.criticalFeature\", function() {\n            o = w.DA;\n            if (!o) {\n                o = w.DA = [];\n                e = d.createElement(\"script\");\n                e.src = \"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/DA-us/DA-us-1236030632._V380600703_.js\";\n                d.getElementsByTagName(\"head\")[0].appendChild(e);\n            }\n        ;\n        ;\n            o.push({\n                c: 3961,\n                a: \"site=amazon.us;pt=Detail;slot=nav-sitewide-msg;pid=0596517742;prid=0JNNCCYK0E23P11J4NSE;arid=7716c88fbe0c4f63a1e2567d4e33f705\",\n                w: 415,\n                h: 50,\n                f: 1,\n                g: \"right\",\n                r: 1,\n                v: 1,\n                y: \"na\",\n                u: \"amzn.us.dp.atn.books/computer_internet;sz=300x31;oe=ISO-8859-1;u=7716c88fbe0c4f63a1e2567d4e33f705;s=i0;s=i1;s=i2;s=i3;s=i4;s=i5;s=i6;s=i7;s=i9;s=m1;s=m4;s=u4;s=u5;s=u10;s=u35;z=1716;z=1688;z=1801;z=1782;s=3072;s=32;s=1009;cid=vegas2;dc_ref=http%3A%2F%2Fwww.amazon.com;tile=1;ord=0JNNCCYK0E23P11J4NSE;cid=vegas2\",\n                q: \"N4215\"\n            });\n        });\n    }\n;\n;\n})(window, JSBNG__document);");
// 879
o2 = {};
// 880
f876774570_0.returns.push(o2);
// 881
o2.getTime = f876774570_400;
// 882
f876774570_400.returns.push(1374695829426);
// 883
o4 = {};
// 884
f876774570_65.returns.push(o4);
// 885
// 886
// 878
geval("_navbar.dynamicMenuUrl = \"/gp/navigation/ajax/dynamicmenu.html\";\n((window.$Nav && $Nav.declare(\"config.dynamicMenuUrl\", _navbar.dynamicMenuUrl)));\n_navbar.dismissNotificationUrl = \"/gp/navigation/ajax/dismissnotification.html\";\n((window.$Nav && $Nav.declare(\"config.dismissNotificationUrl\", _navbar.dismissNotificationUrl)));\n_navbar.dynamicMenus = true;\n((window.$Nav && $Nav.declare(\"config.enableDynamicMenus\", true)));\n_navbar.recordEvUrl = \"/gp/navigation/ajax/recordevent.html\";\n_navbar.recordEvInterval = 60000;\n_navbar.sid = \"181-0531756-0630505\";\n_navbar.rid = \"0JNNCCYK0E23P11J4NSE\";\n((window.$Nav && $Nav.declare(\"config.recordEvUrl\", _navbar.recordEvUrl)));\n((window.$Nav && $Nav.declare(\"config.recordEvInterval\", 60000)));\n((window.$Nav && $Nav.declare(\"config.sessionId\", _navbar.sid)));\n((window.$Nav && $Nav.declare(\"config.requestId\", _navbar.rid)));\n_navbar.readyOnATF = false;\n((window.$Nav && $Nav.declare(\"config.readyOnATF\", _navbar.readyOnATF)));\n_navbar.dynamicMenuArgs = {\n    isPrime: 0,\n    primeMenuWidth: 310\n};\n((window.$Nav && $Nav.declare(\"config.dynamicMenuArgs\", ((_navbar.dynamicMenuArgs || {\n})))));\n((window.$Nav && $Nav.declare(\"config.signOutText\", _navbar.signOutText)));\n((window.$Nav && $Nav.declare(\"config.yourAccountPrimeURL\", _navbar.yourAccountPrimer)));\nif (((window.amznJQ && amznJQ.available))) {\n    amznJQ.available(\"jQuery\", function() {\n        if (!jQuery.isArray) {\n            jQuery.isArray = function(o) {\n                return ((Object.prototype.toString.call(o) === \"[object Array]\"));\n            };\n        }\n    ;\n    ;\n    });\n}\n;\n;\nif (((typeof uet == \"function\"))) {\n    uet(\"bb\", \"iss-init-pc\", {\n        wb: 1\n    });\n}\n;\n;\nif (((!window.$SearchJS && window.$Nav))) {\n    window.$SearchJS = $Nav.make();\n}\n;\n;\nif (window.$SearchJS) {\n    var iss, issHost = \"completion.amazon.com/search/complete\", issMktid = \"1\", issSearchAliases = [\"aps\",\"stripbooks\",\"popular\",\"apparel\",\"electronics\",\"sporting\",\"garden\",\"videogames\",\"toys-and-games\",\"jewelry\",\"digital-text\",\"digital-music\",\"watches\",\"grocery\",\"hpc\",\"instant-video\",\"baby-products\",\"office-products\",\"software\",\"magazines\",\"tools\",\"automotive\",\"misc\",\"industrial\",\"mi\",\"pet-supplies\",\"digital-music-track\",\"digital-music-album\",\"mobile\",\"mobile-apps\",\"movies-tv\",\"music-artist\",\"music-album\",\"music-song\",\"stripbooks-spanish\",\"electronics-accessories\",\"photo\",\"audio-video\",\"computers\",\"furniture\",\"kitchen\",\"audiobooks\",\"beauty\",\"shoes\",\"arts-crafts\",\"appliances\",\"gift-cards\",\"pets\",\"outdoor\",\"lawngarden\",\"collectibles\",\"financial\",\"wine\",], updateISSCompletion = function() {\n        iss.updateAutoCompletion();\n    };\n    $SearchJS.importEvent(\"search-js-autocomplete-lib\");\n    $SearchJS.when(\"jQuery\", \"search-js-autocomplete-lib\").run(function(jQuery) {\n        $SearchJS.importEvent(\"search-csl\");\n        $SearchJS.when(\"search-csl\").run(function(searchCSL) {\n            if (!searchCSL) {\n                searchCSL = jQuery.searchCSL;\n            }\n        ;\n        ;\n            searchCSL.init(\"Detail\", \"0JNNCCYK0E23P11J4NSE\");\n            var ctw = [function() {\n                var searchSelect = jQuery(\"select.searchSelect\"), nodeRegEx = new RegExp(/node=\\d+/i);\n                return function() {\n                    var currDropdownSel = searchSelect.children();\n                    return ((((currDropdownSel.attr(\"data-root-alias\") || nodeRegEx.test(currDropdownSel.attr(\"value\")))) ? \"16458\" : undefined));\n                };\n            }(),];\n            iss = new AutoComplete({\n                src: issHost,\n                mkt: issMktid,\n                aliases: issSearchAliases,\n                fb: 1,\n                dd: \"select.searchSelect\",\n                dupElim: 0,\n                deptText: \"in {department}\",\n                sugText: \"Search suggestions\",\n                sc: 1,\n                ime: 0,\n                imeEnh: 0,\n                imeSpacing: 0,\n                isNavInline: 1,\n                iac: 0,\n                scs: 0,\n                np: 4,\n                doCTW: function(e) {\n                    for (var i = 0; ((i < ctw.length)); i++) {\n                        searchCSL.addWlt(((ctw[i].call ? ctw[i](e) : ctw[i])));\n                    };\n                ;\n                }\n            });\n            $SearchJS.publish(\"search-js-autocomplete\", iss);\n            if (((((typeof uet == \"function\")) && ((typeof uex == \"function\"))))) {\n                uet(\"be\", \"iss-init-pc\", {\n                    wb: 1\n                });\n                uex(\"ld\", \"iss-init-pc\", {\n                    wb: 1\n                });\n            }\n        ;\n        ;\n        });\n    });\n}\n;\n;\n((window.amznJQ && amznJQ.declareAvailable(\"navbarInline\")));\n((window.$Nav && $Nav.declare(\"nav.inline\")));\n((window.amznJQ && amznJQ.available(\"jQuery\", function() {\n    amznJQ.available(\"navbarJS-beacon\", function() {\n    \n    });\n})));\n_navbar._endSpriteImage = new JSBNG__Image();\n_navbar._endSpriteImage.JSBNG__onload = function() {\n    _navbar.componentLoaded();\n};\n_navbar._endSpriteImage.src = window._navbarSpriteUrl;\n((window.$Nav && $Nav.declare(\"config.autoFocus\", false)));\n((window.$Nav && $Nav.declare(\"config.responsiveGW\", !!window._navbar.responsivegw)));\n((window.$Nav && $Nav.when(\"$\", \"flyout.JSBNG__content\").run(function(jQuery) {\n    jQuery(\"#nav_amabotandroid\").parent().html(\"Get Garden of Orbs free today\");\n})));\n_navbar.browsepromos[\"android\"] = {\n    destination: \"/gp/product/ref=nav_sap_mas_13_07_24?ie=UTF8&ASIN=B006QZD2ZS\",\n    productTitle2: \"(List Price: $0.99)\",\n    button: \"Learn more\",\n    price: \"FREE\",\n    productTitle: \"Garden of Orbs\",\n    headline: \"Free App of the Day\",\n    image: \"http://ecx.images-amazon.com/images/I/81pCw%2BSz8yL._SS100_.png\"\n};\n_navbar.browsepromos[\"audible\"] = {\n    width: 477,\n    promoType: \"wide\",\n    vertOffset: \"0\",\n    horizOffset: \"-19\",\n    height: 470,\n    image: \"http://g-ecx.images-amazon.com/images/G/01/Audible/en_US/images/creative/amazon/beacon/ADBLECRE_2309_Beacon_Headphones_wool._V382188254_.png\"\n};\n_navbar.browsepromos[\"automotive-industrial\"] = {\n    width: 491,\n    promoType: \"wide\",\n    vertOffset: \"0\",\n    horizOffset: \"0\",\n    height: 472,\n    image: \"http://g-ecx.images-amazon.com/images/G/01/BISS/stores/homepage/flyouts/EducationSupplyGNO3._V379317833_.png\"\n};\n_navbar.browsepromos[\"books\"] = {\n    width: 499,\n    promoType: \"wide\",\n    vertOffset: \"0\",\n    horizOffset: \"0\",\n    height: 410,\n    image: \"http://g-ecx.images-amazon.com/images/G/01/img13/books/flyout/0219-bookself-faves-40_flyout._V374727339_.png\"\n};\n_navbar.browsepromos[\"clothing-shoes-jewelry\"] = {\n    width: 460,\n    promoType: \"wide\",\n    vertOffset: \"0\",\n    horizOffset: \"-20\",\n    height: 472,\n    image: \"http://g-ecx.images-amazon.com/images/G/01/AMAZON_FASHION/2013/GATEWAY/BTS1/FLYOUTS/FO_mens_bts1._V381438785_.png\"\n};\n_navbar.browsepromos[\"cloud-drive\"] = {\n    width: 480,\n    promoType: \"wide\",\n    vertOffset: \"0\",\n    horizOffset: \"0\",\n    height: 472,\n    image: \"http://g-ecx.images-amazon.com/images/G/01/digital/adrive/images/gno/iOs_GNO1._V385462964_.jpg\"\n};\n_navbar.browsepromos[\"digital-games-software\"] = {\n    width: 425,\n    promoType: \"wide\",\n    vertOffset: \"0\",\n    horizOffset: \"-21\",\n    height: 402,\n    image: \"http://g-ecx.images-amazon.com/images/G/01/img13/digital-video-games/flyout/5-24_5192013-dsw-msft_flyout._V384615770_.png\"\n};\n_navbar.browsepromos[\"electronics-computers\"] = {\n    width: 499,\n    promoType: \"wide\",\n    vertOffset: \"0\",\n    horizOffset: \"0\",\n    height: 136,\n    image: \"http://g-ecx.images-amazon.com/images/G/01/img13/ce_accessories/flyout/7_12_13_electronics-trade-in_GNO._V378716571_.png\"\n};\n_navbar.browsepromos[\"grocery-health-beauty\"] = {\n    width: 523,\n    promoType: \"wide\",\n    vertOffset: \"0\",\n    horizOffset: \"-39\",\n    height: 356,\n    image: \"http://g-ecx.images-amazon.com/images/G/01/img13/grocery/flyout/0621-sns-flyout-update._V381061838_.png\"\n};\n_navbar.browsepromos[\"home-garden-tools\"] = {\n    width: 492,\n    promoType: \"wide\",\n    vertOffset: 0,\n    horizOffset: 0,\n    height: 287,\n    image: \"http://g-ecx.images-amazon.com/images/G/01/img13/home/flyout/7-9_furniture-photo-shoot_flyout._V379916182_.png\"\n};\n_navbar.browsepromos[\"instant-video\"] = {\n    width: 500,\n    promoType: \"wide\",\n    vertOffset: \"-10\",\n    horizOffset: \"-20\",\n    height: 495,\n    image: \"http://g-ecx.images-amazon.com/images/G/01/digital/video/merch/GNOflyout/AIV_GNO-Flyout_Oblivion._V379395299_.png\"\n};\n_navbar.browsepromos[\"kindle\"] = {\n    width: 440,\n    promoType: \"wide\",\n    vertOffset: \"-35\",\n    horizOffset: \"28\",\n    height: 151,\n    image: \"http://g-ecx.images-amazon.com/images/G/01/gno/beacon/merch/browse/gno-family-440x151._V389693769_.png\"\n};\n_navbar.browsepromos[\"movies-music-games\"] = {\n    width: 532,\n    promoType: \"wide\",\n    vertOffset: \"-23\",\n    horizOffset: \"-38\",\n    height: 495,\n    image: \"http://g-ecx.images-amazon.com/images/G/01/img13/music/flyout/0528-evergreen-music-stack-flyout._V381699570_.png\"\n};\n_navbar.browsepromos[\"mp3\"] = {\n    width: 516,\n    promoType: \"wide\",\n    vertOffset: \"0\",\n    horizOffset: \"-21\",\n    height: 472,\n    image: \"http://g-ecx.images-amazon.com/images/G/01/img13/mp3/flyout/marc_anthony_flyout._V379296314_.png\"\n};\n_navbar.browsepromos[\"sports-outdoors\"] = {\n    width: 530,\n    promoType: \"wide\",\n    vertOffset: \"0\",\n    horizOffset: \"-32\",\n    height: 472,\n    image: \"http://g-ecx.images-amazon.com/images/G/01/stores/sport-goods/sports-apparel/0708-sports-apparel-savings-flyout_v2._V379391408_.png\"\n};\n_navbar.browsepromos[\"toys-kids-baby\"] = {\n    width: 479,\n    promoType: \"wide\",\n    vertOffset: \"0\",\n    horizOffset: \"0\",\n    height: 395,\n    image: \"http://g-ecx.images-amazon.com/images/G/01/img13/babyregistry/2013sweepstakes/flyout/baby_2013sweeps_flyout._V381448744_.jpg\"\n};\n((window.$Nav && $Nav.declare(\"config.browsePromos\", window._navbar.browsepromos)));\n((window.amznJQ && amznJQ.declareAvailable(\"navbarPromosContent\")));");
// 889
o5 = {};
// 890
f876774570_65.returns.push(o5);
// 891
// 887
geval("(function() {\n    var availableWidth = ((((window.JSBNG__innerWidth || JSBNG__document.body.offsetWidth)) - 1));\n;\n    var widths = [1280,];\n    var imageHashMain = [\"http://ecx.images-amazon.com/images/I/51gdVAEfPUL._BO2,204,203,200_PIsitb-sticker-arrow-click,TopRight,35,-76_AA300_SH20_OU01_.jpg\",\"http://ecx.images-amazon.com/images/I/51gdVAEfPUL._BO2,204,203,200_PIsitb-sticker-arrow-click,TopRight,35,-76_AA300_SH20_OU01_.jpg\",];\n    var imageObj = new JSBNG__Image();\n    var sz = 0;\n    for (; ((((sz < widths.length)) && ((availableWidth >= widths[sz])))); sz++) {\n    ;\n    };\n;\n    imageObj.src = imageHashMain[sz];\n})();");
// 892
geval("function e078472349c4006daca6d88d77fc9955fc8dc2f56(JSBNG__event) {\n;\n    if (((typeof measureATFDiff == \"function\"))) {\n        measureATFDiff(new JSBNG__Date().getTime(), 0);\n    }\n;\n;\n;\n    if (((typeof setCSMReq == \"function\"))) {\n        setCSMReq(\"af\");\n        setCSMReq(\"cf\");\n    }\n     else if (((typeof uet == \"function\"))) {\n        uet(\"af\");\n        uet(\"cf\");\n        amznJQ.completedStage(\"amznJQ.AboveTheFold\");\n    }\n    \n;\n;\n};\n;");
// 893
geval("function e22425f4fcd4847606f790e6f116625d0725e88e9(JSBNG__event) {\n    return false;\n};\n;");
// 895
f876774570_410 = function() { return f876774570_410.returns[f876774570_410.inst++]; };
f876774570_410.returns = [];
f876774570_410.inst = 0;
// 896
o0.getElementById = f876774570_410;
// 897
o6 = {};
// 898
f876774570_410.returns.push(o6);
// 901
o7 = {};
// 902
f876774570_410.returns.push(o7);
// 903
o7.className = "size0 bottom-thumbs main-image-widget-for-dp standard";
// 904
// 905
// 906
// 907
o8 = {};
// 908
o6.style = o8;
// 909
// 894
geval("var colorImages = {\n    initial: [{\n        large: \"http://ecx.images-amazon.com/images/I/51gdVAEfPUL.jpg\",\n        landing: [\"http://ecx.images-amazon.com/images/I/51gdVAEfPUL._BO2,204,203,200_PIsitb-sticker-arrow-click,TopRight,35,-76_AA300_SH20_OU01_.jpg\",],\n        hiRes: \"http://ecx.images-amazon.com/images/I/814biaGJWaL._SL1500_.jpg\",\n        thumb: \"http://ecx.images-amazon.com/images/I/51gdVAEfPUL._SS30_.jpg\",\n        main: [\"http://ecx.images-amazon.com/images/I/51gdVAEfPUL._BO2,204,203,200_PIsitb-sticker-arrow-click,TopRight,35,-76_AA300_SH20_OU01_.jpg\",\"http://ecx.images-amazon.com/images/I/51gdVAEfPUL._BO2,204,203,200_PIsitb-sticker-arrow-click,TopRight,35,-76_AA300_SH20_OU01_.jpg\",]\n    },]\n};\n(function(doc) {\n    var mi = doc.getElementById(\"main-image\");\n    var w = ((window.JSBNG__innerWidth || doc.body.offsetWidth));\n    w--;\n    var widths = [1280,];\n    var sz = 0;\n    for (; ((((sz < 1)) && ((w >= widths[sz])))); sz++) {\n    ;\n    };\n;\n    if (((sz || 1))) {\n        var miw = doc.getElementById(\"main-image-widget\");\n        miw.className = miw.className.replace(/size[0-9]+/, ((\"size\" + sz)));\n        if (((sz && 1))) {\n            mi.width = 300;\n            mi.height = 300;\n        }\n         else if (((!sz && 1))) {\n            mi.width = 300;\n            mi.height = 300;\n        }\n        \n    ;\n    ;\n        amznJQ.onCompletion(\"amznJQ.AboveTheFold\", function() {\n            var src = colorImages.initial[0].main[sz];\n            var img = new JSBNG__Image();\n            img.JSBNG__onload = function() {\n                var clone = mi.cloneNode(true);\n                clone.src = src;\n                clone.removeAttribute(\"width\");\n                clone.removeAttribute(\"height\");\n                clone.removeAttribute(\"JSBNG__onload\");\n                mi.parentNode.replaceChild(clone, mi);\n                mi = clone;\n                amznJQ.declareAvailable(\"ImageBlockATF\");\n            };\n            img.src = src;\n        });\n    }\n     else {\n        amznJQ.declareAvailable(\"ImageBlockATF\");\n    }\n;\n;\n    mi.style.display = \"inline\";\n})(JSBNG__document);");
// 910
geval("function ebc39a21f34d30ea674ee1a51ae14d6423dc6ad98(JSBNG__event) {\n    if (((typeof (SitbReader) != \"undefined\"))) {\n        SitbReader.LightboxActions.openReader(\"sib_dp_ptu\");\n        return false;\n    }\n;\n;\n};\n;");
// 911
geval("var legacyOnSelectedQuantityChange = function() {\n    if (((jQuery(\"#pricePlusShippingQty\").length > 0))) {\n        jQuery.ajax({\n            url: \"/gp/product/du/quantity-sip-update.html\",\n            data: {\n                qt: jQuery(\"#quantityDropdownDiv select\").val(),\n                a: jQuery(\"#ASIN\").val(),\n                me: jQuery(\"#merchantID\").val()\n            },\n            dataType: \"html\",\n            success: function(sipHtml) {\n                jQuery(\"#pricePlusShippingQty\").html(sipHtml);\n            }\n        });\n    }\n;\n;\n};\namznJQ.onReady(\"jQuery\", function() {\n    jQuery(\"#quantityDropdownDiv select\").change(legacyOnSelectedQuantityChange);\n    amznJQ.onCompletion(\"amznJQ.criticalFeature\", function() {\n        amznJQ.available(\"quantityDropDownJS\", function() {\n            var qdd = new jQuery.fn.quantityDropDown();\n            qdd.setPopoverContent(\"\\u003Cstrong\\u003EWe're sorry.  This item is limited to %d per customer.\\u003C/strong\\u003E\", \"\\u003Cbr /\\u003E\\u003Cbr /\\u003EWe strive to provide customers with great prices, and sometimes that means we limit quantity to ensure that the majority of customers have an opportunity to order products that have very low prices or a limited supply.\\u003Cbr /\\u003E\\u003Cbr /\\u003EWe may also adjust quantity in checkout if you have recently purchased this item.\");\n        });\n    });\n});");
// 912
geval("amznJQ.onCompletion(\"amznJQ.criticalFeature\", function() {\n    amznJQ.available(\"bbopCheckBoxJS\", function() {\n        var bbopJS = new jQuery.fn.bbopCheckBox();\n        bbopJS.initialize(1, 0, \"To get FREE Two-Day Shipping on this item, proceed to checkout using &quot;Add to Cart&quot;\");\n    });\n});");
// 913
geval("var gbSecure1Click = true;\nif (((((typeof (gbSecure1Click) != \"undefined\")) && gbSecure1Click))) {\n    amznJQ.onReady(\"jQuery\", function() {\n        jQuery(\"#oneClickBuyButton\").click(function() {\n            var hbbAction = jQuery(\"#handleBuy\").attr(\"action\").replace(\"http:\", \"https:\");\n            jQuery(\"#handleBuy\").attr(\"action\", hbbAction);\n            return true;\n        });\n    });\n}\n;\n;");
// 914
geval("if (window.gbvar) {\n    amznJQ.onReady(\"jQuery\", function() {\n        jQuery(\"#oneClickSignInLinkID\").attr(\"href\", window.gbvar);\n    });\n}\n else {\n    window.gbvar = \"http://jsbngssl.www.amazon.com/gp/product/utility/edit-one-click-pref.html?ie=UTF8&query=selectObb%3Dnew&returnPath=%2Fgp%2Fproduct%2F0596517742\";\n}\n;\n;");
// 916
o2 = {};
// 917
f876774570_0.returns.push(o2);
// 918
o2.getTime = f876774570_400;
// undefined
o2 = null;
// 919
f876774570_400.returns.push(1374695829426);
// 920
o4 = {};
// 921
f876774570_65.returns.push(o4);
// 922
// 923
// undefined
o4 = null;
// 915
geval("if (window.gbvar) {\n    amznJQ.onReady(\"jQuery\", function() {\n        jQuery(\"#oneClickSignInLinkID\").attr(\"href\", window.gbvar);\n    });\n}\n else {\n    window.gbvar = \"http://jsbngssl.www.amazon.com/gp/product/utility/edit-one-click-pref.html?ie=UTF8&query=selectObb%3Dnew&returnPath=%2Fgp%2Fproduct%2F0596517742\";\n}\n;\n;");
// 926
o5 = {};
// 927
f876774570_65.returns.push(o5);
// 928
// undefined
o5 = null;
// 924
geval("(function() {\n    var availableWidth = ((((window.JSBNG__innerWidth || JSBNG__document.body.offsetWidth)) - 1));\n;\n    var widths = [1280,];\n    var imageHashMain = [\"http://ecx.images-amazon.com/images/I/51gdVAEfPUL._BO2,204,203,200_PIsitb-sticker-arrow-click,TopRight,35,-76_AA300_SH20_OU01_.jpg\",\"http://ecx.images-amazon.com/images/I/51gdVAEfPUL._BO2,204,203,200_PIsitb-sticker-arrow-click,TopRight,35,-76_AA300_SH20_OU01_.jpg\",];\n    var imageObj = new JSBNG__Image();\n    var sz = 0;\n    for (; ((((sz < widths.length)) && ((availableWidth >= widths[sz])))); sz++) {\n    ;\n    };\n;\n    imageObj.src = imageHashMain[sz];\n})();");
// 929
geval("function e078472349c4006daca6d88d77fc9955fc8dc2f56(JSBNG__event) {\n;\n    if (((typeof measureATFDiff == \"function\"))) {\n        measureATFDiff(new JSBNG__Date().getTime(), 0);\n    }\n;\n;\n;\n    if (((typeof setCSMReq == \"function\"))) {\n        setCSMReq(\"af\");\n        setCSMReq(\"cf\");\n    }\n     else if (((typeof uet == \"function\"))) {\n        uet(\"af\");\n        uet(\"cf\");\n        amznJQ.completedStage(\"amznJQ.AboveTheFold\");\n    }\n    \n;\n;\n};\n;");
// 930
geval("function e22425f4fcd4847606f790e6f116625d0725e88e9(JSBNG__event) {\n    return false;\n};\n;");
// 932
f876774570_410 = function() { return f876774570_410.returns[f876774570_410.inst++]; };
f876774570_410.returns = [];
f876774570_410.inst = 0;
// 934
o6 = {};
// 935
f876774570_410.returns.push(o6);
// 938
o7 = {};
// 939
f876774570_410.returns.push(o7);
// 940
o7.className = "size0 bottom-thumbs main-image-widget-for-dp standard";
// 941
// undefined
o7 = null;
// 942
// 943
// 944
o8 = {};
// 945
o6.style = o8;
// undefined
o6 = null;
// 946
// undefined
o8 = null;
// 931
geval("var colorImages = {\n    initial: [{\n        large: \"http://ecx.images-amazon.com/images/I/51gdVAEfPUL.jpg\",\n        landing: [\"http://ecx.images-amazon.com/images/I/51gdVAEfPUL._BO2,204,203,200_PIsitb-sticker-arrow-click,TopRight,35,-76_AA300_SH20_OU01_.jpg\",],\n        hiRes: \"http://ecx.images-amazon.com/images/I/814biaGJWaL._SL1500_.jpg\",\n        thumb: \"http://ecx.images-amazon.com/images/I/51gdVAEfPUL._SS30_.jpg\",\n        main: [\"http://ecx.images-amazon.com/images/I/51gdVAEfPUL._BO2,204,203,200_PIsitb-sticker-arrow-click,TopRight,35,-76_AA300_SH20_OU01_.jpg\",\"http://ecx.images-amazon.com/images/I/51gdVAEfPUL._BO2,204,203,200_PIsitb-sticker-arrow-click,TopRight,35,-76_AA300_SH20_OU01_.jpg\",]\n    },]\n};\n(function(doc) {\n    var mi = doc.getElementById(\"main-image\");\n    var w = ((window.JSBNG__innerWidth || doc.body.offsetWidth));\n    w--;\n    var widths = [1280,];\n    var sz = 0;\n    for (; ((((sz < 1)) && ((w >= widths[sz])))); sz++) {\n    ;\n    };\n;\n    if (((sz || 1))) {\n        var miw = doc.getElementById(\"main-image-widget\");\n        miw.className = miw.className.replace(/size[0-9]+/, ((\"size\" + sz)));\n        if (((sz && 1))) {\n            mi.width = 300;\n            mi.height = 300;\n        }\n         else if (((!sz && 1))) {\n            mi.width = 300;\n            mi.height = 300;\n        }\n        \n    ;\n    ;\n        amznJQ.onCompletion(\"amznJQ.AboveTheFold\", function() {\n            var src = colorImages.initial[0].main[sz];\n            var img = new JSBNG__Image();\n            img.JSBNG__onload = function() {\n                var clone = mi.cloneNode(true);\n                clone.src = src;\n                clone.removeAttribute(\"width\");\n                clone.removeAttribute(\"height\");\n                clone.removeAttribute(\"JSBNG__onload\");\n                mi.parentNode.replaceChild(clone, mi);\n                mi = clone;\n                amznJQ.declareAvailable(\"ImageBlockATF\");\n            };\n            img.src = src;\n        });\n    }\n     else {\n        amznJQ.declareAvailable(\"ImageBlockATF\");\n    }\n;\n;\n    mi.style.display = \"inline\";\n})(JSBNG__document);");
// 947
geval("function ebc39a21f34d30ea674ee1a51ae14d6423dc6ad98(JSBNG__event) {\n    if (((typeof (SitbReader) != \"undefined\"))) {\n        SitbReader.LightboxActions.openReader(\"sib_dp_ptu\");\n        return false;\n    }\n;\n;\n};\n;");
// 948
geval("var legacyOnSelectedQuantityChange = function() {\n    if (((jQuery(\"#pricePlusShippingQty\").length > 0))) {\n        jQuery.ajax({\n            url: \"/gp/product/du/quantity-sip-update.html\",\n            data: {\n                qt: jQuery(\"#quantityDropdownDiv select\").val(),\n                a: jQuery(\"#ASIN\").val(),\n                me: jQuery(\"#merchantID\").val()\n            },\n            dataType: \"html\",\n            success: function(sipHtml) {\n                jQuery(\"#pricePlusShippingQty\").html(sipHtml);\n            }\n        });\n    }\n;\n;\n};\namznJQ.onReady(\"jQuery\", function() {\n    jQuery(\"#quantityDropdownDiv select\").change(legacyOnSelectedQuantityChange);\n    amznJQ.onCompletion(\"amznJQ.criticalFeature\", function() {\n        amznJQ.available(\"quantityDropDownJS\", function() {\n            var qdd = new jQuery.fn.quantityDropDown();\n            qdd.setPopoverContent(\"\\u003Cstrong\\u003EWe're sorry.  This item is limited to %d per customer.\\u003C/strong\\u003E\", \"\\u003Cbr /\\u003E\\u003Cbr /\\u003EWe strive to provide customers with great prices, and sometimes that means we limit quantity to ensure that the majority of customers have an opportunity to order products that have very low prices or a limited supply.\\u003Cbr /\\u003E\\u003Cbr /\\u003EWe may also adjust quantity in checkout if you have recently purchased this item.\");\n        });\n    });\n});");
// 949
geval("amznJQ.onCompletion(\"amznJQ.criticalFeature\", function() {\n    amznJQ.available(\"bbopCheckBoxJS\", function() {\n        var bbopJS = new jQuery.fn.bbopCheckBox();\n        bbopJS.initialize(1, 0, \"To get FREE Two-Day Shipping on this item, proceed to checkout using &quot;Add to Cart&quot;\");\n    });\n});");
// 950
geval("var gbSecure1Click = true;\nif (((((typeof (gbSecure1Click) != \"undefined\")) && gbSecure1Click))) {\n    amznJQ.onReady(\"jQuery\", function() {\n        jQuery(\"#oneClickBuyButton\").click(function() {\n            var hbbAction = jQuery(\"#handleBuy\").attr(\"action\").replace(\"http:\", \"https:\");\n            jQuery(\"#handleBuy\").attr(\"action\", hbbAction);\n            return true;\n        });\n    });\n}\n;\n;");
// 951
geval("if (window.gbvar) {\n    amznJQ.onReady(\"jQuery\", function() {\n        jQuery(\"#oneClickSignInLinkID\").attr(\"href\", window.gbvar);\n    });\n}\n else {\n    window.gbvar = \"http://jsbngssl.www.amazon.com/gp/product/utility/edit-one-click-pref.html?ie=UTF8&query=selectObb%3Dnew&returnPath=%2Fgp%2Fproduct%2F0596517742\";\n}\n;\n;");
// 953
o2 = {};
// undefined
o2 = null;
// 952
geval("if (window.gbvar) {\n    amznJQ.onReady(\"jQuery\", function() {\n        jQuery(\"#oneClickSignInLinkID\").attr(\"href\", window.gbvar);\n    });\n}\n else {\n    window.gbvar = \"http://jsbngssl.www.amazon.com/gp/product/utility/edit-one-click-pref.html?ie=UTF8&query=selectObb%3Dnew&returnPath=%2Fgp%2Fproduct%2F0596517742\";\n}\n;\n;");
// 954
geval("amznJQ.onReady(\"popover\", function() {\n    var $ = jQuery;\n});");
// 955
geval("amznJQ.onReady(\"jQuery\", function() {\n    if (((((((typeof dpLdWidget !== \"undefined\")) && ((typeof dpLdWidget.deal !== \"undefined\")))) && ((typeof dpLdWidget.deal.asins !== \"undefined\"))))) {\n        var dealPriceText;\n        if (((((((typeof Deal !== \"undefined\")) && ((typeof Deal.Price !== \"undefined\")))) && ((typeof dpLdWidget.deal.asins[0] !== \"undefined\"))))) {\n            var dp = dpLdWidget.deal.asins[0].dealPrice;\n            if (((dp.price > 396))) {\n                dealPriceText = Deal.Price.format(dp);\n                jQuery(\"#rbb_bb_trigger .bb_price, #rentalPriceBlockGrid .buyNewOffers .rentPrice\").html(dealPriceText);\n            }\n        ;\n        ;\n        }\n    ;\n    ;\n    }\n;\n;\n    jQuery(\"#rbbContainer .rbb_section .rbb_header\").click(function(e) {\n        var target = jQuery(e.target);\n        if (!target.hasClass(\"rbb_header\")) {\n            target.parents(\".rbbHeaderLink\").attr(\"href\", \"javascript:void(0);\");\n        }\n    ;\n    ;\n        var t = jQuery(this);\n        var header = ((t.hasClass(\"rbb_header\") ? t : t.parents(\".rbb_header\")));\n        if (header.parents(\".rbb_section\").hasClass(\"selected\")) {\n            return false;\n        }\n    ;\n    ;\n        jQuery(\"#radiobuyboxDivId .bb_radio\").attr(\"checked\", false);\n        header.JSBNG__find(\".bb_radio\").attr(\"checked\", \"checked\");\n        header.parents(\".rbb_section\").removeClass(\"unselected\").addClass(\"selected\");\n        jQuery(\"#radiobuyboxDivId .abbListInput\").attr(\"checked\", false);\n        var bbClicked = jQuery(this).attr(\"id\");\n        var slideMeDown, slideMeUp;\n        jQuery(\"#radiobuyboxDivId .rbb_section\").each(function(i, bb) {\n            if (((jQuery(bb).JSBNG__find(\".rbb_header\")[0].id == bbClicked))) {\n                slideMeDown = jQuery(bb);\n            }\n             else if (jQuery(bb).hasClass(\"selected\")) {\n                slideMeUp = jQuery(bb);\n            }\n            \n        ;\n        ;\n        });\n        slideMeUp.JSBNG__find(\".rbb_content\").slideUp(500, function() {\n            slideMeUp.removeClass(\"selected\").addClass(\"unselected\");\n        });\n        slideMeDown.JSBNG__find(\".rbb_content\").slideDown(500);\n        JSBNG__location.hash = ((\"#selectedObb=\" + header.attr(\"id\")));\n        return true;\n    });\n    var locationHash = JSBNG__location.hash;\n    if (((locationHash.length != 0))) {\n        var selectObb = locationHash.substring(1).split(\"=\")[1];\n        if (((typeof (selectObb) != \"undefined\"))) {\n            var target = jQuery(((\"#\" + selectObb)));\n            if (((target.length != 0))) {\n                target.trigger(\"click\");\n            }\n        ;\n        ;\n        }\n    ;\n    ;\n    }\n;\n;\n});");
// 956
geval("function e8411539754ab9827f368ae7f5e2c8ea9ebb4a635(JSBNG__event) {\n    return false;\n};\n;");
// 957
geval("if (((typeof window.amznJQ != \"undefined\"))) {\n    amznJQ.onReady(\"popover\", function() {\n        jQuery(\"#tradeinBuyboxLearnMore\").amazonPopoverTrigger({\n            closeText: \"Close\",\n            width: 580,\n            group: \"tradein\",\n            destination: \"/gp/tradein/popovers/ajax-popover.html?ie=UTF8&name=howToTradeIn\",\n            title: \"How to Trade In\"\n        });\n    });\n}\n;\n;");
// 958
geval("function e1f14b254e05033951804485a03ab10fbbe411a71(JSBNG__event) {\n    window.open(this.href, \"_blank\", \"location=yes,width=700,height=400\");\n    return false;\n};\n;");
// 959
geval("function e10ce337f851e69fefd2813bf419f648edcffd9e1(JSBNG__event) {\n    window.open(this.href, \"_blank\", \"location=yes,width=700,height=400\");\n    return false;\n};\n;");
// 960
geval("function e2725972985ec03e1744e1d7cfd25a1cba7a8672b(JSBNG__event) {\n    window.open(this.href, \"_blank\", \"location=yes,width=700,height=570\");\n    return false;\n};\n;");
// 961
geval("if (((typeof window.amznJQ != \"undefined\"))) {\n    amznJQ.onCompletion(\"amznJQ.criticalFeature\", function() {\n        amznJQ.available(\"share-with-friends-js-new\", function() {\n            var popoverParams = {\n                url: \"/gp/pdp/taf/dpPop.html/ref=cm_sw_p_view_dp_sgd8rb0NCY02P?ie=UTF8&contentID=0596517742&contentName=item&contentType=asin&contentURI=%2Fdp%2F0596517742&emailCaptionStrID=&emailCustomMsgStrID=&emailDescStrID=&emailSubjectStrID=&emailTemplate=%2Fgp%2Fpdp%2Fcommon%2Femail%2Fshare-product&forceSprites=1&id=0596517742&imageURL=&isDynamicSWF=0&isEmail=0&learnMoreButton=&merchantID=&parentASIN=0596517742&placementID=dp_sgd8rb0NCY02P&ra=taf&referer=http%253A%252F%252Fwww.amazon.com%252Fgp%252Fproduct%252F0596517742%252Fref%253D&relatedAccounts=amazondeals%2Camazonmp3&suppressPurchaseReqLogin=&titleText=&tt=sh&viaAccount=amazon\",\n                title: \"Share this item via Email\",\n                closeText: \"Close\",\n                isCompact: false,\n                token: \"69530C13771BFFCC7657C8F16A8B9D2C0CB06C31\"\n            };\n            amz_taf_triggers.swftext = popoverParams;\n            amz_taf_generatePopover(\"swftext\", false);\n        });\n    });\n}\n;\n;");
// 962
geval("amznJQ.onReady(\"bylinePopover\", function() {\n\n});");
// 963
geval("function acrPopoverHover(e, h) {\n    if (h) {\n        window.acrAsinHover = e;\n    }\n     else {\n        if (((window.acrAsinHover == e))) {\n            window.acrAsinHover = null;\n        }\n    ;\n    }\n;\n;\n};\n;\namznJQ.onReady(\"popover\", function() {\n    (function($) {\n        if ($.fn.acrPopover) {\n            return;\n        }\n    ;\n    ;\n        var popoverConfig = {\n            showOnHover: true,\n            showCloseButton: true,\n            width: null,\n            JSBNG__location: \"bottom\",\n            locationAlign: \"left\",\n            locationOffset: [-20,0,],\n            paddingLeft: 15,\n            paddingBottom: 5,\n            paddingRight: 15,\n            group: \"reviewsPopover\",\n            clone: false,\n            hoverHideDelay: 300\n        };\n        $.fn.acrPopover = function() {\n            return this.each(function() {\n                var $this = $(this);\n                if (((!$this.data(\"init\") && ((typeof $this.amazonPopoverTrigger === \"function\"))))) {\n                    $this.data(\"init\", 1);\n                    var getargs = $this.attr(\"getargs\");\n                    var ajaxURL = ((((((((((((((\"/gp/customer-reviews/common/du/displayHistoPopAjax.html?\" + \"&ASIN=\")) + $this.attr(\"JSBNG__name\"))) + \"&link=1\")) + \"&seeall=1\")) + \"&ref=\")) + $this.attr(\"ref\"))) + ((((typeof getargs != \"undefined\")) ? ((\"&getargs=\" + getargs)) : \"\"))));\n                    var myConfig = $.extend(true, {\n                        destination: ajaxURL\n                    }, popoverConfig);\n                    $this.amazonPopoverTrigger(myConfig);\n                    var w = window.acrAsinHover;\n                    if (((w && (($(w).parents(\".asinReviewsSummary\").get(0) == this))))) {\n                        $this.trigger(\"mouseover.amzPopover\");\n                        window.acrAsinHover = null;\n                    }\n                ;\n                ;\n                }\n            ;\n            ;\n            });\n        };\n        window.reviewHistPopoverConfig = popoverConfig;\n        var jqInit = window.jQueryInitHistoPopovers = function(asin) {\n            if (((typeof $(((((\".acr-popover[name=\" + asin)) + \"]\"))).acrPopover === \"function\"))) {\n                $(((((\".acr-popover[name=\" + asin)) + \"]\"))).acrPopover();\n            }\n        ;\n        ;\n        };\n        window.doInit_average_customer_reviews = jqInit;\n        window.onAjaxUpdate_average_customer_reviews = jqInit;\n        window.onCacheUpdate_average_customer_reviews = jqInit;\n        window.onCacheUpdateReselect_average_customer_reviews = jqInit;\n        amznJQ.onCompletion(\"amznJQ.criticalFeature\", function() {\n            JSBNG__setTimeout(function() {\n                amznJQ.declareAvailable(\"acrPopover\");\n            }, 10);\n        });\n    })(jQuery);\n});\namznJQ.onReady(\"acrPopover\", function() {\n    jQuery(\".acr-popover,#searchTemplate .asinReviewsSummary\").each(function() {\n        if (((typeof jQuery(this).acrPopover === \"function\"))) {\n            jQuery(this).acrPopover();\n        }\n    ;\n    ;\n    });\n});");
// 964
geval("function e8e70165fa0a99f2adde340b4b993baa0c88bcff5(JSBNG__event) {\n    return acrPopoverHover(this, 1);\n};\n;");
// 965
geval("function efbb2e003f7e954f2d7bac18a126412255145f6b4(JSBNG__event) {\n    return acrPopoverHover(this, 0);\n};\n;");
// 966
geval("function efb3607ba40f4c02222c1cf3079822836e280f9a3(JSBNG__event) {\n    return acrPopoverHover(this, 1);\n};\n;");
// 967
geval("function e013be0cdaeb0eb5fac25ade0f6533dede66427c6(JSBNG__event) {\n    return acrPopoverHover(this, 0);\n};\n;");
// 968
geval("function ec1a67f1d15a4d383d5e0e60704787e14cff1b140(JSBNG__event) {\n    return amz_js_PopWin(\"/gp/help/customer/display.html/ref=mk_sss_dp_1?ie=UTF8&nodeId=527692&pop-up=1\", \"AmazonHelp\", \"width=550,height=550,resizable=1,scrollbars=1,toolbar=0,status=0\");\n};\n;");
// 969
geval("amznJQ.declareAvailable(\"gbPriceBlockFields\");");
// 971
o2 = {};
// 972
f876774570_0.returns.push(o2);
// 973
f876774570_417 = function() { return f876774570_417.returns[f876774570_417.inst++]; };
f876774570_417.returns = [];
f876774570_417.inst = 0;
// 974
o2.getHours = f876774570_417;
// 975
f876774570_417.returns.push(12);
// 976
f876774570_418 = function() { return f876774570_418.returns[f876774570_418.inst++]; };
f876774570_418.returns = [];
f876774570_418.inst = 0;
// 977
o2.getMinutes = f876774570_418;
// 978
f876774570_418.returns.push(57);
// 979
f876774570_419 = function() { return f876774570_419.returns[f876774570_419.inst++]; };
f876774570_419.returns = [];
f876774570_419.inst = 0;
// 980
o2.getSeconds = f876774570_419;
// undefined
o2 = null;
// 981
f876774570_419.returns.push(9);
// 982
o2 = {};
// 983
f876774570_0.returns.push(o2);
// 984
o2.getHours = f876774570_417;
// 985
f876774570_417.returns.push(12);
// 986
o2.getMinutes = f876774570_418;
// 987
f876774570_418.returns.push(57);
// 988
o2.getSeconds = f876774570_419;
// undefined
o2 = null;
// 989
f876774570_419.returns.push(9);
// 990
o0.layers = void 0;
// 991
o0.all = void 0;
// 994
f876774570_410.returns.push(null);
// 999
f876774570_410.returns.push(null);
// 1000
f876774570_16.returns.push(2);
// 970
geval("try {\n    var ftCountdownElementIDs = new Array();\n    var ftEntireMessageElementIDs = new Array();\n    var FT_CurrentDisplayMin = new Array();\n    var clientServerTimeDrift;\n    var firstTimeUpdate = false;\n    function ftRegisterCountdownElementID(elementID) {\n        ftCountdownElementIDs[ftCountdownElementIDs.length] = elementID;\n    };\n;\n    function ftRegisterEntireMessageElementID(elementID) {\n        ftEntireMessageElementIDs[ftEntireMessageElementIDs.length] = elementID;\n    };\n;\n    function getTimeRemainingString(hours, minutes) {\n        var hourString = ((((hours == 1)) ? \"hr\" : \"hrs\"));\n        var minuteString = ((((minutes == 1)) ? \"min\" : \"mins\"));\n        if (((hours == 0))) {\n            return ((((minutes + \" \")) + minuteString));\n        }\n    ;\n    ;\n        if (((minutes == 0))) {\n            return ((((hours + \" \")) + hourString));\n        }\n    ;\n    ;\n        return ((((((((((((hours + \" \")) + hourString)) + \" \")) + minutes)) + \" \")) + minuteString));\n        return ((((((((((((hours + \" \")) + hourString)) + \"  \")) + minutes)) + \" \")) + minuteString));\n    };\n;\n    function FT_displayCountdown(forceUpdate) {\n        if (((((!JSBNG__document.layers && !JSBNG__document.all)) && !JSBNG__document.getElementById))) {\n            return;\n        }\n    ;\n    ;\n        FT_showHtmlElement(\"ftShipString\", true, \"inline\");\n        var FT_remainSeconds = ((FT_givenSeconds - FT_actualSeconds));\n        if (((FT_remainSeconds < 1))) {\n            FT_showEntireMessageElement(false);\n        }\n    ;\n    ;\n        var FT_secondsPerDay = ((((24 * 60)) * 60));\n        var FT_daysLong = ((FT_remainSeconds / FT_secondsPerDay));\n        var FT_days = Math.floor(FT_daysLong);\n        var FT_hoursLong = ((((FT_daysLong - FT_days)) * 24));\n        var FT_hours = Math.floor(FT_hoursLong);\n        var FT_minsLong = ((((FT_hoursLong - FT_hours)) * 60));\n        var FT_mins = Math.floor(FT_minsLong);\n        var FT_secsLong = ((((FT_minsLong - FT_mins)) * 60));\n        var FT_secs = Math.floor(FT_secsLong);\n        if (((FT_days > 0))) {\n            FT_hours = ((((FT_days * 24)) + FT_hours));\n        }\n    ;\n    ;\n        window.JSBNG__setTimeout(\"FT_getTime()\", 1000);\n        var ftCountdown = getTimeRemainingString(FT_hours, FT_mins);\n        for (var i = 0; ((i < ftCountdownElementIDs.length)); i++) {\n            var countdownElement = JSBNG__document.getElementById(ftCountdownElementIDs[i]);\n            if (countdownElement) {\n                if (((((((((FT_CurrentDisplayMin[i] != FT_mins)) || forceUpdate)) || ((countdownElement.innerHTML == \"\")))) || firstTimeUpdate))) {\n                    countdownElement.innerHTML = ftCountdown;\n                    FT_CurrentDisplayMin[i] = FT_mins;\n                    firstTimeUpdate = false;\n                }\n            ;\n            ;\n            }\n        ;\n        ;\n        };\n    ;\n    };\n;\n    function FT_showEntireMessageElement(shouldShow) {\n        for (var i = 0; ((i < ftEntireMessageElementIDs.length)); i++) {\n            FT_showHtmlElement(ftEntireMessageElementIDs[i], shouldShow);\n        };\n    ;\n    };\n;\n    function FT_showHtmlElement(elementID, shouldShow, displayStyle) {\n        var element = JSBNG__document.getElementById(elementID);\n        if (element) {\n            if (shouldShow) {\n                element.style.display = ((((displayStyle != null)) ? displayStyle : \"\"));\n            }\n             else {\n                element.style.display = \"none\";\n            }\n        ;\n        ;\n        }\n    ;\n    ;\n    };\n;\n    function FT_getAndClearCutOffEpochSeconds() {\n        var ftCutOffEpochSecondsElementID = \"ftCutOffEpochSeconds\";\n        var ftServerCurrentEpochSecondsElementID = \"ftServerCurrentEpochSeconds\";\n        if (((((JSBNG__document.layers || JSBNG__document.all)) || JSBNG__document.getElementById))) {\n            if (JSBNG__document.getElementById(ftCutOffEpochSecondsElementID)) {\n                var cutOffEpochSeconds = JSBNG__document.getElementById(ftCutOffEpochSecondsElementID).innerHTML;\n                if (((cutOffEpochSeconds != \"\"))) {\n                    JSBNG__document.getElementById(ftCutOffEpochSecondsElementID).innerHTML = \"\";\n                    if (((((clientServerTimeDrift == null)) && JSBNG__document.getElementById(ftServerCurrentEpochSecondsElementID)))) {\n                        var serverCurrentEpochSeconds = ((JSBNG__document.getElementById(ftServerCurrentEpochSecondsElementID).innerHTML * 1));\n                        clientServerTimeDrift = ((((new JSBNG__Date().getTime() / 1000)) - serverCurrentEpochSeconds));\n                    }\n                ;\n                ;\n                    return ((((((clientServerTimeDrift == null)) ? 0 : clientServerTimeDrift)) + ((cutOffEpochSeconds * 1))));\n                }\n            ;\n            ;\n            }\n        ;\n        ;\n        }\n    ;\n    ;\n        return 0;\n    };\n;\n    function FT_getCountdown(secondsLeft) {\n        var FT_currentTime = new JSBNG__Date();\n        var FT_currentHours = FT_currentTime.getHours();\n        var FT_currentMins = FT_currentTime.getMinutes();\n        var FT_currentSecs = FT_currentTime.getSeconds();\n        FT_givenSeconds = ((((((FT_currentHours * 3600)) + ((FT_currentMins * 60)))) + FT_currentSecs));\n        var FT_secondsFromCat = 10974;\n        if (((secondsLeft != null))) {\n            FT_secondsFromCat = secondsLeft;\n        }\n    ;\n    ;\n        FT_givenSeconds += FT_secondsFromCat;\n        FT_getTime();\n    };\n;\n    function FT_getTime() {\n        var FT_newCurrentTime = new JSBNG__Date();\n        var FT_actualHours = FT_newCurrentTime.getHours();\n        var FT_actualMins = FT_newCurrentTime.getMinutes();\n        var FT_actualSecs = FT_newCurrentTime.getSeconds();\n        FT_actualSeconds = ((((((FT_actualHours * 3600)) + ((FT_actualMins * 60)))) + FT_actualSecs));\n        var cutOffTimeFromPageElement = FT_getAndClearCutOffEpochSeconds();\n        if (cutOffTimeFromPageElement) {\n            var countDownSeconds = ((cutOffTimeFromPageElement - ((FT_newCurrentTime.getTime() / 1000))));\n            if (((countDownSeconds >= 1))) {\n                FT_showEntireMessageElement(true);\n            }\n        ;\n        ;\n            FT_givenSeconds = ((countDownSeconds + FT_actualSeconds));\n        }\n    ;\n    ;\n        FT_displayCountdown();\n    };\n;\n    function onAjaxUpdate_fast_track(asin) {\n        var timerDiv = JSBNG__document.getElementById(\"ftMessageTimer\");\n        var cutOffElems = JSBNG__document.getElementsByName(((\"promise-cutoff-time.\" + asin)));\n        if (((((cutOffElems == null)) || ((cutOffElems.length == 0))))) {\n            return;\n        }\n    ;\n    ;\n        if (((timerDiv && timerDiv.style))) {\n            timerDiv.style.display = \"inline\";\n        }\n    ;\n    ;\n        var cutOffTimeVal = cutOffElems[0].value;\n        var cutOffTime = parseInt(cutOffTimeVal);\n        var currSecs = ((new JSBNG__Date().getTime() / 1000));\n        var secsLeft = ((cutOffTime - currSecs));\n        FT_getCountdown(secsLeft);\n    };\n;\n    FT_getCountdown();\n} catch (JSBNG_ex) {\n\n};");
// 1001
geval("ftRegisterCountdownElementID(\"ftCountdown\");\nftRegisterEntireMessageElementID(\"ftMessage\");");
// 1002
geval("function ebccbc86cbedeb20034d6cc4d32ad790b4c606a80(JSBNG__event) {\n    return amz_js_PopWin(\"/gp/help/customer/display.html/ref=ftinfo_dp_?ie=UTF8&nodeId=3510241&pop-up=1\", \"AmazonHelp\", \"width=550,height=600,resizable=1,scrollbars=1,toolbar=1,status=1\");\n};\n;");
// 1005
o2 = {};
// 1006
f876774570_410.returns.push(o2);
// 1007
o4 = {};
// 1008
o2.style = o4;
// undefined
o2 = null;
// 1010
// undefined
o4 = null;
// 1003
geval("var timerDiv = JSBNG__document.getElementById(\"ftMessageTimer\");\nif (((timerDiv && timerDiv.style))) {\n    timerDiv.style.display = \"inline\";\n}\n;\n;");
// 1012
o2 = {};
// 1013
f876774570_0.returns.push(o2);
// 1014
o2.getTime = f876774570_400;
// undefined
o2 = null;
// 1015
f876774570_400.returns.push(1374695829560);
// 1011
geval("if (((typeof measureATFDiff == \"function\"))) {\n    measureATFDiff(0, new JSBNG__Date().getTime());\n}\n;\n;\n;\nif (((typeof setCSMReq == \"function\"))) {\n    setCSMReq(\"af\");\n}\n else if (((typeof uet == \"function\"))) {\n    uet(\"af\");\n}\n\n;\n;");
// 1016
geval("function ed0e2c2cc285b51efbb79f992ea3c7a27a8dff172(JSBNG__event) {\n    javascript:\n    Vellum.h();\n};\n;");
// 1017
geval("function e8fa411e8c7ac26afaca0c04fda6c9d3b8a0a97d4(JSBNG__event) {\n    javascript:\n    Vellum.h();\n};\n;");
// 1018
geval("amznJQ.available(\"jQuery\", function() {\n    window.sitbWeblab = \"\";\n    if (((typeof (Vellum) == \"undefined\"))) {\n        Vellum = {\n            js: \"http://z-ecx.images-amazon.com/images/G/01/digital/sitb/reader/v4/201305301526/en_US/sitb-library-js._V383092699_.js\",\n            sj: \"/gp/search-inside/js?locale=en_US&version=201305301526\",\n            css: \"http://z-ecx.images-amazon.com/images/G/01/digital/sitb/reader/v4/201305301526/en_US/sitb-library-css._V383092698_.css\",\n            pl: function() {\n                Vellum.lj(Vellum.js, Vellum.sj, Vellum.css);\n            },\n            lj: function(u, u2, uc) {\n                if (window.vellumLjDone) {\n                    return;\n                }\n            ;\n            ;\n                window.vellumLjDone = true;\n                var d = JSBNG__document;\n                var s = d.createElement(\"link\");\n                s.type = \"text/css\";\n                s.rel = \"stylesheet\";\n                s.href = uc;\n                d.getElementsByTagName(\"head\")[0].appendChild(s);\n                s = d.createElement(\"script\");\n                s.type = \"text/javascript\";\n                s.src = u2;\n                d.getElementsByTagName(\"head\")[0].appendChild(s);\n            },\n            lj2: function(u) {\n                var d = JSBNG__document;\n                var s = d.createElement(\"script\");\n                s.type = \"text/javascript\";\n                s.src = u;\n                d.getElementsByTagName(\"head\")[0].appendChild(s);\n            },\n            go: function() {\n                sitbLodStart = new JSBNG__Date().getTime();\n                jQuery(\"body\").css(\"overflow\", \"hidden\");\n                var jqw = jQuery(window);\n                var h = jqw.height();\n                var w = jqw.width();\n                var st = jqw.scrollTop();\n                jQuery(\"#vellumShade\").css({\n                    JSBNG__top: st,\n                    height: h,\n                    width: w\n                }).show();\n                var vli = jQuery(\"#vellumLdgIco\");\n                var nl = ((((w / 2)) - ((vli.width() / 2))));\n                var nt = ((((st + ((h / 2)))) - ((vli.height() / 2))));\n                vli.css({\n                    left: nl,\n                    JSBNG__top: nt\n                }).show();\n                JSBNG__setTimeout(\"Vellum.x()\", 20000);\n                Vellum.pl();\n            },\n            x: function() {\n                jQuery(\"#vellumMsgTxt\").html(\"An error occurred while trying to show this book.\");\n                jQuery(\"#vellumMsgHdr\").html(\"Server Timeout\");\n                jQuery(\"#vellumMsg\").show();\n                var reftagImage = new JSBNG__Image();\n                reftagImage.src = \"/gp/search-inside/reftag/ref=rdr_bar_jsto\";\n            },\n            h: function() {\n                jQuery(\"#vellumMsg\").hide();\n                jQuery(\"#vellumShade\").hide();\n                jQuery(\"#vellumLdgIco\").hide();\n                jQuery(\"body\").css(\"overflow\", \"auto\");\n            },\n            cf: function(a) {\n                return function() {\n                    v.mt = a;\n                    v.rg = Array.prototype.slice.call(arguments);\n                    v.go();\n                };\n            },\n            c: function(a) {\n                var v = Vellum;\n                v.mt = \"c\";\n                v.rg = [a,];\n                v.pl();\n            }\n        };\n        var f = \"opqr\".split(\"\");\n        {\n            var fin7keys = ((window.top.JSBNG_Replay.forInKeys)((f))), fin7i = (0);\n            var i;\n            for (; (fin7i < fin7keys.length); (fin7i++)) {\n                ((i) = (fin7keys[fin7i]));\n                {\n                    var v = Vellum;\n                    v[f[i]] = v.cf(f[i]);\n                };\n            };\n        };\n    ;\n        sitbAsin = \"0596517742\";\n        SitbReader = {\n            LightboxActions: {\n                openReader: function(r) {\n                    Vellum.o(\"0596517742\", r);\n                    return false;\n                },\n                openReaderToRandomPage: function(r) {\n                    Vellum.r(\"0596517742\", r);\n                    return false;\n                },\n                openReaderToSearchResults: function(q, r) {\n                    Vellum.q(\"0596517742\", q, r);\n                    return false;\n                },\n                openReaderToPage: function(p, t, r) {\n                    Vellum.p(\"0596517742\", p, t, r);\n                    return false;\n                }\n            }\n        };\n    }\n;\n;\n    amznJQ.onCompletion(\"amznJQ.criticalFeature\", function() {\n        Vellum.c(\"0596517742\");\n    });\n});");
// 1020
o2 = {};
// 1021
f876774570_0.returns.push(o2);
// undefined
o2 = null;
// 1019
geval("if (((typeof amznJQ != \"undefined\"))) {\n    amznJQ.addLogical(\"twister-media-matrix\", [\"http://z-ecx.images-amazon.com/images/G/01/nav2/gamma/tmmJS/tmmJS-combined-core-4624._V1_.js\",]);\n    window._tmm_1 = +new JSBNG__Date();\n}\n;\n;");
// 1023
o2 = {};
// 1024
f876774570_0.returns.push(o2);
// undefined
o2 = null;
// 1022
geval("window._tmm_3 = +new JSBNG__Date();\nif (((typeof amznJQ != \"undefined\"))) {\n    amznJQ.onCompletion(\"amznJQ.criticalFeature\", function() {\n        amznJQ.available(\"twister-media-matrix\", function() {\n            window._tmm_2 = +new JSBNG__Date();\n            TwisterMediaMatrix.initialize({\n                kindle_meta_binding: {\n                    n: \"1\",\n                    start: \"1\"\n                },\n                paperback_meta_binding: {\n                    n: \"4\",\n                    start: \"1\"\n                },\n                other_meta_binding: {\n                    n: \"1\",\n                    start: \"1\"\n                }\n            }, \"3\", \"books\", \"0596517742\", \"B00279BLLE\", \"book_display_on_website\", \"Loading...\", \"Error. Please try again.\", \"http://g-ecx.images-amazon.com/images/G/01/x-locale/twister/tiny-snake._V192199047_.gif\", false, \"1-1\", \"1374695818\");\n        });\n    });\n}\n;\n;\nvar disableWinnerPopup;");
// 1025
geval("function e370437b9f88e8249841359512a49370101cf0073(JSBNG__event) {\n    amz_expandPostBodyDescription(\"PS\", [\"psGradient\",\"psPlaceHolder\",]);\n    return false;\n};\n;");
// 1026
geval("function eb6ad345d049a014f5054539ac0a061c9f9306843(JSBNG__event) {\n    amz_collapsePostBodyDescription(\"PS\", [\"psGradient\",\"psPlaceHolder\",]);\n    return false;\n};\n;");
// 1027
geval("function amz_expandPostBodyDescription(id, objects) {\n    amznJQ.onReady(\"jQuery\", function() {\n        for (var i = 0; ((i < objects.length)); i++) {\n            jQuery(((\"#\" + objects[i]))).hide();\n        };\n    ;\n        jQuery(((\"#outer_postBody\" + id))).animate({\n            height: jQuery(((\"#postBody\" + id))).height()\n        }, 500);\n        jQuery(((\"#expand\" + id))).hide();\n        jQuery(((\"#collapse\" + id))).show();\n        jQuery.ajax({\n            url: \"/gp/product/utility/ajax/impression-tracking.html\",\n            data: {\n                a: \"0596517742\",\n                ref: \"dp_pd_showmore_b\"\n            }\n        });\n    });\n};\n;\nfunction amz_collapsePostBodyDescription(id, objects) {\n    amznJQ.onReady(\"jQuery\", function() {\n        for (var i = 0; ((i < objects.length)); i++) {\n            jQuery(((\"#\" + objects[i]))).show();\n        };\n    ;\n        jQuery(((\"#outer_postBody\" + id))).animate({\n            height: 200\n        }, 500);\n        jQuery(((\"#collapse\" + id))).hide();\n        jQuery(((\"#expand\" + id))).show();\n        jQuery.ajax({\n            url: \"/gp/product/utility/ajax/impression-tracking.html\",\n            data: {\n                a: \"0596517742\",\n                ref: \"dp_pd_showless_b\"\n            }\n        });\n    });\n};\n;\namznJQ.onReady(\"jQuery\", function() {\n    var psTotalHeight = jQuery(\"#postBodyPS\").height();\n    if (((psTotalHeight > 200))) {\n        jQuery(\"#outer_postBodyPS\").css(\"display\", \"block\").css(\"height\", 200);\n        jQuery(\"#psPlaceHolder\").css(\"display\", \"block\");\n        jQuery(\"#expandPS\").css(\"display\", \"block\");\n        jQuery(\"#psGradient\").css(\"display\", \"block\");\n    }\n     else {\n        jQuery(\"#outer_postBodyPS\").css(\"height\", \"auto\");\n        jQuery(\"#psGradient\").hide();\n        jQuery(\"#psPlaceHolder\").hide();\n    }\n;\n;\n});");
// 1028
geval("function ea331173646474d45878734e8c72f8df51ceff043(JSBNG__event) {\n    return amz_js_PopWin(this.href, \"AmazonHelp\", \"width=450,height=600,resizable=1,scrollbars=1,toolbar=1,status=1\");\n};\n;");
// 1031
o2 = {};
// 1032
f876774570_410.returns.push(o2);
// undefined
o2 = null;
// 1034
f876774570_410.returns.push(null);
// 1036
f876774570_410.returns.push(null);
// 1038
o2 = {};
// 1039
f876774570_410.returns.push(o2);
// 1040
o4 = {};
// 1041
o2.style = o4;
// 1042
// undefined
o4 = null;
// 1043
f876774570_429 = function() { return f876774570_429.returns[f876774570_429.inst++]; };
f876774570_429.returns = [];
f876774570_429.inst = 0;
// 1044
o2.getAttribute = f876774570_429;
// undefined
o2 = null;
// 1045
f876774570_429.returns.push(null);
// 1029
geval("try {\n    if (((typeof showHideElement == \"function\"))) {\n        showHideElement(\"specialOffersHidden\", \"specialOffersDiv\");\n        showHideElement(\"productPromosHidden\", \"heroQuickPromoDiv\");\n    }\n;\n;\n} catch (JSBNG_ex) {\n\n};");
// 1046
geval("function e103b8df299451f36f2c5afe3ffd02864825d6cf3(JSBNG__event) {\n    return false;\n};\n;");
// 1047
geval("function e774e86790852b7d5e098d5ae6a9b9d173b93d421(JSBNG__event) {\n    return false;\n};\n;");
// 1048
geval("function e0ec3ef7c4de0fa072cb66b05de1280ee4615589d(JSBNG__event) {\n    return false;\n};\n;");
// 1050
f876774570_430 = function() { return f876774570_430.returns[f876774570_430.inst++]; };
f876774570_430.returns = [];
f876774570_430.inst = 0;
// 1051
o0.createElement = f876774570_430;
// 1052
o2 = {};
// 1053
f876774570_430.returns.push(o2);
// 1054
// 1055
o4 = {};
// 1056
o0.body = o4;
// 1057
o5 = {};
// 1058
o4.childNodes = o5;
// 1059
o5.length = 2;
// 1061
f876774570_434 = function() { return f876774570_434.returns[f876774570_434.inst++]; };
f876774570_434.returns = [];
f876774570_434.inst = 0;
// 1062
o4.insertBefore = f876774570_434;
// undefined
o4 = null;
// 1065
o4 = {};
// 1066
o5["0"] = o4;
// undefined
o5 = null;
// undefined
o4 = null;
// 1067
f876774570_434.returns.push(o2);
// undefined
o2 = null;
// 1049
geval("window.AmazonPopoverImages = {\n    snake: \"http://g-ecx.images-amazon.com/images/G/01/javascripts/lib/popover/images/snake._V192571611_.gif\",\n    btnClose: \"http://g-ecx.images-amazon.com/images/G/01/javascripts/lib/popover/images/btn_close._V192188154_.gif\",\n    closeTan: \"http://g-ecx.images-amazon.com/images/G/01/nav2/images/close-tan-sm._V192185930_.gif\",\n    closeTanDown: \"http://g-ecx.images-amazon.com/images/G/01/nav2/images/close-tan-sm-dn._V192185961_.gif\",\n    loadingBar: \"http://g-ecx.images-amazon.com/images/G/01/javascripts/lib/popover/images/loading-bar-small._V192188123_.gif\",\n    pixel: \"http://g-ecx.images-amazon.com/images/G/01/icons/blank-pixel._V192192429_.gif\"\n};\nvar container = JSBNG__document.createElement(\"DIV\");\ncontainer.id = \"ap_container\";\nif (JSBNG__document.body.childNodes.length) {\n    JSBNG__document.body.insertBefore(container, JSBNG__document.body.childNodes[0]);\n}\n else {\n    JSBNG__document.body.appendChild(container);\n}\n;\n;");
// 1069
o2 = {};
// 1070
o0.head = o2;
// 1072
o4 = {};
// 1073
f876774570_430.returns.push(o4);
// 1074
// 1075
// 1076
o2.insertBefore = f876774570_434;
// 1077
o5 = {};
// 1078
o2.firstChild = o5;
// undefined
o2 = null;
// undefined
o5 = null;
// 1079
f876774570_434.returns.push(o4);
// undefined
o4 = null;
// 1068
geval("(function() {\n    var h = ((((JSBNG__document.head || JSBNG__document.getElementsByTagName(\"head\")[0])) || JSBNG__document.documentElement));\n    var s = JSBNG__document.createElement(\"script\");\n    s.async = \"async\";\n    s.src = \"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/site-wide-js-1.2.6-beacon/site-wide-6717236952._V1_.js\";\n    h.insertBefore(s, h.firstChild);\n})();");
// 1080
geval("amznJQ.addLogical(\"popover\", []);\namznJQ.addLogical(\"navbarCSSUS-beacon\", []);\namznJQ.addLogical(\"search-js-autocomplete\", []);\namznJQ.addLogical(\"navbarJS-beacon\", []);\namznJQ.addLogical(\"LBHUCCSS-US\", []);\namznJQ.addLogical(\"CustomerPopover\", [\"http://z-ecx.images-amazon.com/images/G/01/x-locale/communities/profile/customer-popover/script-13-min._V224617671_.js\",]);\namznJQ.addLogical(\"amazonShoveler\", [\"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/amazonShoveler/amazonShoveler-1466453065._V1_.js\",]);\namznJQ.addLogical(\"dpCSS\", []);\namznJQ.addLogical(\"discussionsCSS\", []);\namznJQ.addLogical(\"bxgyCSS\", []);\namznJQ.addLogical(\"simCSS\", []);\namznJQ.addLogical(\"condProbCSS\", []);\namznJQ.addLogical(\"ciuAnnotations\", []);\namznJQ.addLogical(\"dpProductImage\", [\"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/dpProductImage/dpProductImage-2900646310._V1_.js\",]);\namznJQ.addLogical(\"search-csl\", [\"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/search-csl/search-csl-2400229912._V1_.js\",]);\namznJQ.addLogical(\"AmazonHistory\", [\"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/AmazonHistory/AmazonHistory-61973207._V1_.js\",]);\namznJQ.addLogical(\"AmazonCountdown\", [\"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/AmazonCountdownMerged/AmazonCountdownMerged-27059._V1_.js\",]);\namznJQ.addLogical(\"bylinePopover\", [\"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/bylinePopover/bylinePopover-1310866238._V1_.js\",]);\namznJQ.addLogical(\"simsJS\", [\"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/simsJSMerged/simsMerged-9099816638._V1_.js\",]);\namznJQ.addLogical(\"callOnVisible\", [\"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/callOnVisible/callOnVisible-3144292562._V1_.js\",]);\namznJQ.addLogical(\"p13nlogger\", [\"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/p13nlogger/p13nlogger-1808340331._V1_.js\",]);\namznJQ.addLogical(\"gridReviewCSS-US\", []);\namznJQ.addLogical(\"reviewsCSS-US\", []);\namznJQ.addLogical(\"lazyLoadLib\", [\"http://z-ecx.images-amazon.com/images/G/01/nav2/gamma/lazyLoadLib/lazyLoadLib-lazyLoadLib-60357._V1_.js\",]);\namznJQ.addLogical(\"immersiveView\", [\"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/immersiveView/immersiveView-990982538._V1_.js\",]);\namznJQ.addLogical(\"imageBlock\", [\"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/imageBlock/imageBlock-3190704718._V1_.js\",]);\namznJQ.addLogical(\"quantityDropDownJS\", [\"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/quantityDropDownJSMerged/quantityDropDownJSMerged-63734._V1_.js\",]);\namznJQ.addLogical(\"bbopCheckBoxJS\", [\"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/bbopCheckBoxJSMerged/bbopCheckBoxJSMerged-33025._V1_.js\",]);\namznJQ.addLogical(\"share-with-friends-js-new\", [\"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/share-with-friends-js-new/share-with-friends-js-new-1687238824._V1_.js\",]);\namznJQ.addLogical(\"amazonLike\", [\"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/amazonLike/amazonLike-682075628._V1_.js\",]);");
// 1081
geval("function acrPopoverHover(e, h) {\n    if (h) {\n        window.acrAsinHover = e;\n    }\n     else {\n        if (((window.acrAsinHover == e))) {\n            window.acrAsinHover = null;\n        }\n    ;\n    }\n;\n;\n};\n;\namznJQ.onReady(\"popover\", function() {\n    (function($) {\n        if ($.fn.acrPopover) {\n            return;\n        }\n    ;\n    ;\n        var popoverConfig = {\n            showOnHover: true,\n            showCloseButton: true,\n            width: null,\n            JSBNG__location: \"bottom\",\n            locationAlign: \"left\",\n            locationOffset: [-20,0,],\n            paddingLeft: 15,\n            paddingBottom: 5,\n            paddingRight: 15,\n            group: \"reviewsPopover\",\n            clone: false,\n            hoverHideDelay: 300\n        };\n        $.fn.acrPopover = function() {\n            return this.each(function() {\n                var $this = $(this);\n                if (((!$this.data(\"init\") && ((typeof $this.amazonPopoverTrigger === \"function\"))))) {\n                    $this.data(\"init\", 1);\n                    var getargs = $this.attr(\"getargs\");\n                    var ajaxURL = ((((((((((((((\"/gp/customer-reviews/common/du/displayHistoPopAjax.html?\" + \"&ASIN=\")) + $this.attr(\"JSBNG__name\"))) + \"&link=1\")) + \"&seeall=1\")) + \"&ref=\")) + $this.attr(\"ref\"))) + ((((typeof getargs != \"undefined\")) ? ((\"&getargs=\" + getargs)) : \"\"))));\n                    var myConfig = $.extend(true, {\n                        destination: ajaxURL\n                    }, popoverConfig);\n                    $this.amazonPopoverTrigger(myConfig);\n                    var w = window.acrAsinHover;\n                    if (((w && (($(w).parents(\".asinReviewsSummary\").get(0) == this))))) {\n                        $this.trigger(\"mouseover.amzPopover\");\n                        window.acrAsinHover = null;\n                    }\n                ;\n                ;\n                }\n            ;\n            ;\n            });\n        };\n        window.reviewHistPopoverConfig = popoverConfig;\n        var jqInit = window.jQueryInitHistoPopovers = function(asin) {\n            if (((typeof $(((((\".acr-popover[name=\" + asin)) + \"]\"))).acrPopover === \"function\"))) {\n                $(((((\".acr-popover[name=\" + asin)) + \"]\"))).acrPopover();\n            }\n        ;\n        ;\n        };\n        window.doInit_average_customer_reviews = jqInit;\n        window.onAjaxUpdate_average_customer_reviews = jqInit;\n        window.onCacheUpdate_average_customer_reviews = jqInit;\n        window.onCacheUpdateReselect_average_customer_reviews = jqInit;\n        amznJQ.onCompletion(\"amznJQ.criticalFeature\", function() {\n            JSBNG__setTimeout(function() {\n                amznJQ.declareAvailable(\"acrPopover\");\n            }, 10);\n        });\n    })(jQuery);\n});\namznJQ.onReady(\"acrPopover\", function() {\n    jQuery(\".acr-popover,#searchTemplate .asinReviewsSummary\").each(function() {\n        if (((typeof jQuery(this).acrPopover === \"function\"))) {\n            jQuery(this).acrPopover();\n        }\n    ;\n    ;\n    });\n});");
// 1082
geval("function ea906d93ab2870eed3367c77c167b1c20784c5a0d(JSBNG__event) {\n    return acrPopoverHover(this, 1);\n};\n;");
// 1083
geval("function e67639d5e2ae3ccb739c64e8526980011a31739f7(JSBNG__event) {\n    return acrPopoverHover(this, 0);\n};\n;");
// 1084
geval("function e4508443fc183cda1c7d6954f25f29479dda74974(JSBNG__event) {\n    return acrPopoverHover(this, 1);\n};\n;");
// 1085
geval("function ece526a20f09cb244fb224d526c267d71ef3f5587(JSBNG__event) {\n    return acrPopoverHover(this, 0);\n};\n;");
// 1086
geval("var DEFAULT_RENDERING_TIME = 123;\namznJQ.onReady(\"popover\", function() {\n    jQuery(\"#ns_0JNNCCYK0E23P11J4NSE_1513_1_community_feedback_trigger_product-detail\").amazonPopoverTrigger({\n        title: \"What product features are missing?\",\n        destination: \"/gp/lwcf/light-weight-form.html?asin=0596517742&root=283155\",\n        showOnHover: false,\n        draggable: true,\n        width: 650,\n        paddingBottom: 0,\n        onHide: function() {\n            logCloseWidgetEvent(DEFAULT_RENDERING_TIME);\n            cleanupSearchResults();\n        }\n    });\n});");
// 1087
geval("amznJQ.onReady(\"popover\", function() {\n    jQuery(\"#ns_0JNNCCYK0E23P11J4NSE_1512_1_hmd_pricing_feedback_trigger_product-detail\").amazonPopoverTrigger({\n        title: \"Tell Us About a Lower Price\",\n        destination: \"/gp/pdp/pf/pricingFeedbackForm.html/ref=sr_1_1_pfdpb?ie=UTF8&ASIN=0596517742&PREFIX=ns_0JNNCCYK0E23P11J4NSE_1512_2_&from=product-detail&keywords=javascript%20the%20good%20parts&originalURI=%2Fgp%2Fproduct%2F0596517742&qid=1374695818&s=books&sr=1-1&storeID=books\",\n        showOnHover: false,\n        draggable: true\n    });\n});");
// 1088
geval("amznJQ.onReady(\"lazyLoadLib\", function() {\n    jQuery(\"#books-entity-teaser\").lazyLoadContent({\n        url: \"/gp/product/features/entity-teaser/books-entity-teaser-ajax.html?ASIN=0596517742\",\n        metrics: true,\n        JSBNG__name: \"books-entity-teaser\",\n        cache: true\n    });\n});");
// 1089
geval("function edd3b053ee26b8726e7f59b53d3fe5e110557602e(JSBNG__event) {\n    return amz_js_PopWin(this.href, \"AmazonHelp\", \"width=340,height=340,resizable=1,scrollbars=1,toolbar=1,status=1\");\n};\n;");
// 1090
geval("var paCusRevAllURL = \"http://product-ads-portal.amazon.com/gp/synd/?asin=0596517742&pAsin=&gl=14&sq=javascript%20the%20good%20parts&sa=&se=Amazon&noo=&pt=Detail&spt=Glance&sn=customer-reviews-top&pRID=0JNNCCYK0E23P11J4NSE&ts=1374695826&h=429073D5161E5460C7A05BBAECF8459BDBC106E6\";");
// 1092
o2 = {};
// 1093
f876774570_0.returns.push(o2);
// 1094
o2.getTime = f876774570_400;
// 1095
f876774570_400.returns.push(1374695829658);
// 1091
geval("(function(w, d, e, o) {\n    var i = \"DAcrt\";\n    if (w.uDA = ((((w.ues && w.uet)) && w.uex))) {\n        ues(\"wb\", i, 1);\n        uet(\"bb\", i, {\n            wb: 1\n        });\n    }\n;\n;\n    var methodToBind = \"amznJQ.onCompletion\";\n    if (((((!w.amznJQ && ((methodToBind == \"amznJQ.onCompletion\")))) && ((typeof (P) != \"undefined\"))))) {\n        P.when(\"amznJQ.criticalFeature\").execute(function() {\n            o = w.DA;\n            if (!o) {\n                o = w.DA = [];\n                e = d.createElement(\"script\");\n                e.src = \"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/DA-us/DA-us-1236030632._V380600703_.js\";\n                d.getElementsByTagName(\"head\")[0].appendChild(e);\n            }\n        ;\n        ;\n            o.push({\n                c: 855,\n                a: \"site=amazon.us;pt=Detail;slot=customer-reviews-top;pid=0596517742;prid=0JNNCCYK0E23P11J4NSE;arid=086cda0bd10c4f368bd73f9fd75a69ce;ef=0.00\",\n                f: 1,\n                g: \"\",\n                n: 1,\n                r: 1,\n                v: 1,\n                y: \"na\",\n                u: \"amzn.us.dp.books/computer_internet;sz=300x250;oe=ISO-8859-1;u=086cda0bd10c4f368bd73f9fd75a69ce;s=i0;s=i1;s=i2;s=i3;s=i4;s=i5;s=i6;s=i7;s=i9;s=m1;s=m4;s=u4;s=u5;s=u10;s=u35;z=153;z=141;z=180;z=173;s=3072;s=32;s=1009;dc_ref=http%3A%2F%2Fwww.amazon.com;tile=1;ord=0JNNCCYK0E23P11J4NSE\",\n                q: \"N4215\"\n            });\n        });\n    }\n     else {\n        amznJQ.onCompletion(\"amznJQ.criticalFeature\", function() {\n            o = w.DA;\n            if (!o) {\n                o = w.DA = [];\n                e = d.createElement(\"script\");\n                e.src = \"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/DA-us/DA-us-1236030632._V380600703_.js\";\n                d.getElementsByTagName(\"head\")[0].appendChild(e);\n            }\n        ;\n        ;\n            o.push({\n                c: 855,\n                a: \"site=amazon.us;pt=Detail;slot=customer-reviews-top;pid=0596517742;prid=0JNNCCYK0E23P11J4NSE;arid=086cda0bd10c4f368bd73f9fd75a69ce;ef=0.00\",\n                f: 1,\n                g: \"\",\n                n: 1,\n                r: 1,\n                v: 1,\n                y: \"na\",\n                u: \"amzn.us.dp.books/computer_internet;sz=300x250;oe=ISO-8859-1;u=086cda0bd10c4f368bd73f9fd75a69ce;s=i0;s=i1;s=i2;s=i3;s=i4;s=i5;s=i6;s=i7;s=i9;s=m1;s=m4;s=u4;s=u5;s=u10;s=u35;z=153;z=141;z=180;z=173;s=3072;s=32;s=1009;dc_ref=http%3A%2F%2Fwww.amazon.com;tile=1;ord=0JNNCCYK0E23P11J4NSE\",\n                q: \"N4215\"\n            });\n        });\n    }\n;\n;\n})(window, JSBNG__document);");
// 1097
o4 = {};
// 1098
f876774570_0.returns.push(o4);
// 1096
geval("if (((typeof setCSMReq == \"function\"))) {\n    setCSMReq(\"cf\");\n}\n else {\n    if (((typeof uet == \"function\"))) {\n        uet(\"cf\");\n    }\n;\n;\n    amznJQ.completedStage(\"amznJQ.criticalFeature\");\n}\n;\n;");
// 1099
geval("function acrPopoverHover(e, h) {\n    if (h) {\n        window.acrAsinHover = e;\n    }\n     else {\n        if (((window.acrAsinHover == e))) {\n            window.acrAsinHover = null;\n        }\n    ;\n    }\n;\n;\n};\n;\namznJQ.onReady(\"popover\", function() {\n    (function($) {\n        if ($.fn.acrPopover) {\n            return;\n        }\n    ;\n    ;\n        var popoverConfig = {\n            showOnHover: true,\n            showCloseButton: true,\n            width: null,\n            JSBNG__location: \"bottom\",\n            locationAlign: \"left\",\n            locationOffset: [-20,0,],\n            paddingLeft: 15,\n            paddingBottom: 5,\n            paddingRight: 15,\n            group: \"reviewsPopover\",\n            clone: false,\n            hoverHideDelay: 300\n        };\n        $.fn.acrPopover = function() {\n            return this.each(function() {\n                var $this = $(this);\n                if (((!$this.data(\"init\") && ((typeof $this.amazonPopoverTrigger === \"function\"))))) {\n                    $this.data(\"init\", 1);\n                    var getargs = $this.attr(\"getargs\");\n                    var ajaxURL = ((((((((((((((\"/gp/customer-reviews/common/du/displayHistoPopAjax.html?\" + \"&ASIN=\")) + $this.attr(\"JSBNG__name\"))) + \"&link=1\")) + \"&seeall=1\")) + \"&ref=\")) + $this.attr(\"ref\"))) + ((((typeof getargs != \"undefined\")) ? ((\"&getargs=\" + getargs)) : \"\"))));\n                    var myConfig = $.extend(true, {\n                        destination: ajaxURL\n                    }, popoverConfig);\n                    $this.amazonPopoverTrigger(myConfig);\n                    var w = window.acrAsinHover;\n                    if (((w && (($(w).parents(\".asinReviewsSummary\").get(0) == this))))) {\n                        $this.trigger(\"mouseover.amzPopover\");\n                        window.acrAsinHover = null;\n                    }\n                ;\n                ;\n                }\n            ;\n            ;\n            });\n        };\n        window.reviewHistPopoverConfig = popoverConfig;\n        var jqInit = window.jQueryInitHistoPopovers = function(asin) {\n            if (((typeof $(((((\".acr-popover[name=\" + asin)) + \"]\"))).acrPopover === \"function\"))) {\n                $(((((\".acr-popover[name=\" + asin)) + \"]\"))).acrPopover();\n            }\n        ;\n        ;\n        };\n        window.doInit_average_customer_reviews = jqInit;\n        window.onAjaxUpdate_average_customer_reviews = jqInit;\n        window.onCacheUpdate_average_customer_reviews = jqInit;\n        window.onCacheUpdateReselect_average_customer_reviews = jqInit;\n        amznJQ.onCompletion(\"amznJQ.criticalFeature\", function() {\n            JSBNG__setTimeout(function() {\n                amznJQ.declareAvailable(\"acrPopover\");\n            }, 10);\n        });\n    })(jQuery);\n});\namznJQ.onReady(\"acrPopover\", function() {\n    jQuery(\".acr-popover,#searchTemplate .asinReviewsSummary\").each(function() {\n        if (((typeof jQuery(this).acrPopover === \"function\"))) {\n            jQuery(this).acrPopover();\n        }\n    ;\n    ;\n    });\n});");
// 1100
geval("function ea906d93ab2870eed3367c77c167b1c20784c5a0d(JSBNG__event) {\n    return acrPopoverHover(this, 1);\n};\n;");
// 1101
geval("function e67639d5e2ae3ccb739c64e8526980011a31739f7(JSBNG__event) {\n    return acrPopoverHover(this, 0);\n};\n;");
// 1102
geval("function e4508443fc183cda1c7d6954f25f29479dda74974(JSBNG__event) {\n    return acrPopoverHover(this, 1);\n};\n;");
// 1103
geval("function ece526a20f09cb244fb224d526c267d71ef3f5587(JSBNG__event) {\n    return acrPopoverHover(this, 0);\n};\n;");
// 1104
geval("var DEFAULT_RENDERING_TIME = 123;\namznJQ.onReady(\"popover\", function() {\n    jQuery(\"#ns_0JNNCCYK0E23P11J4NSE_1513_1_community_feedback_trigger_product-detail\").amazonPopoverTrigger({\n        title: \"What product features are missing?\",\n        destination: \"/gp/lwcf/light-weight-form.html?asin=0596517742&root=283155\",\n        showOnHover: false,\n        draggable: true,\n        width: 650,\n        paddingBottom: 0,\n        onHide: function() {\n            logCloseWidgetEvent(DEFAULT_RENDERING_TIME);\n            cleanupSearchResults();\n        }\n    });\n});");
// 1105
geval("amznJQ.onReady(\"popover\", function() {\n    jQuery(\"#ns_0JNNCCYK0E23P11J4NSE_1512_1_hmd_pricing_feedback_trigger_product-detail\").amazonPopoverTrigger({\n        title: \"Tell Us About a Lower Price\",\n        destination: \"/gp/pdp/pf/pricingFeedbackForm.html/ref=sr_1_1_pfdpb?ie=UTF8&ASIN=0596517742&PREFIX=ns_0JNNCCYK0E23P11J4NSE_1512_2_&from=product-detail&keywords=javascript%20the%20good%20parts&originalURI=%2Fgp%2Fproduct%2F0596517742&qid=1374695818&s=books&sr=1-1&storeID=books\",\n        showOnHover: false,\n        draggable: true\n    });\n});");
// 1106
geval("amznJQ.onReady(\"lazyLoadLib\", function() {\n    jQuery(\"#books-entity-teaser\").lazyLoadContent({\n        url: \"/gp/product/features/entity-teaser/books-entity-teaser-ajax.html?ASIN=0596517742\",\n        metrics: true,\n        JSBNG__name: \"books-entity-teaser\",\n        cache: true\n    });\n});");
// 1107
geval("function edd3b053ee26b8726e7f59b53d3fe5e110557602e(JSBNG__event) {\n    return amz_js_PopWin(this.href, \"AmazonHelp\", \"width=340,height=340,resizable=1,scrollbars=1,toolbar=1,status=1\");\n};\n;");
// 1108
geval("var paCusRevAllURL = \"http://product-ads-portal.amazon.com/gp/synd/?asin=0596517742&pAsin=&gl=14&sq=javascript%20the%20good%20parts&sa=&se=Amazon&noo=&pt=Detail&spt=Glance&sn=customer-reviews-top&pRID=0JNNCCYK0E23P11J4NSE&ts=1374695826&h=429073D5161E5460C7A05BBAECF8459BDBC106E6\";");
// 1110
o2 = {};
// 1111
f876774570_0.returns.push(o2);
// 1112
o2.getTime = f876774570_400;
// undefined
o2 = null;
// 1113
f876774570_400.returns.push(1374695829658);
// 1109
geval("try {\n    (function(w, d, e, o) {\n        var i = \"DAcrt\";\n        if (w.uDA = ((((w.ues && w.uet)) && w.uex))) {\n            ues(\"wb\", i, 1);\n            uet(\"bb\", i, {\n                wb: 1\n            });\n        }\n    ;\n    ;\n        var methodToBind = \"amznJQ.onCompletion\";\n        if (((((!w.amznJQ && ((methodToBind == \"amznJQ.onCompletion\")))) && ((typeof (P) != \"undefined\"))))) {\n            P.when(\"amznJQ.criticalFeature\").execute(function() {\n                o = w.DA;\n                if (!o) {\n                    o = w.DA = [];\n                    e = d.createElement(\"script\");\n                    e.src = \"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/DA-us/DA-us-1236030632._V380600703_.js\";\n                    d.getElementsByTagName(\"head\")[0].appendChild(e);\n                }\n            ;\n            ;\n                o.push({\n                    c: 855,\n                    a: \"site=amazon.us;pt=Detail;slot=customer-reviews-top;pid=0596517742;prid=0JNNCCYK0E23P11J4NSE;arid=086cda0bd10c4f368bd73f9fd75a69ce;ef=0.00\",\n                    f: 1,\n                    g: \"\",\n                    n: 1,\n                    r: 1,\n                    v: 1,\n                    y: \"na\",\n                    u: \"amzn.us.dp.books/computer_internet;sz=300x250;oe=ISO-8859-1;u=086cda0bd10c4f368bd73f9fd75a69ce;s=i0;s=i1;s=i2;s=i3;s=i4;s=i5;s=i6;s=i7;s=i9;s=m1;s=m4;s=u4;s=u5;s=u10;s=u35;z=153;z=141;z=180;z=173;s=3072;s=32;s=1009;dc_ref=http%3A%2F%2Fwww.amazon.com;tile=1;ord=0JNNCCYK0E23P11J4NSE\",\n                    q: \"N4215\"\n                });\n            });\n        }\n         else {\n            amznJQ.onCompletion(\"amznJQ.criticalFeature\", function() {\n                o = w.DA;\n                if (!o) {\n                    o = w.DA = [];\n                    e = d.createElement(\"script\");\n                    e.src = \"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/DA-us/DA-us-1236030632._V380600703_.js\";\n                    d.getElementsByTagName(\"head\")[0].appendChild(e);\n                }\n            ;\n            ;\n                o.push({\n                    c: 855,\n                    a: \"site=amazon.us;pt=Detail;slot=customer-reviews-top;pid=0596517742;prid=0JNNCCYK0E23P11J4NSE;arid=086cda0bd10c4f368bd73f9fd75a69ce;ef=0.00\",\n                    f: 1,\n                    g: \"\",\n                    n: 1,\n                    r: 1,\n                    v: 1,\n                    y: \"na\",\n                    u: \"amzn.us.dp.books/computer_internet;sz=300x250;oe=ISO-8859-1;u=086cda0bd10c4f368bd73f9fd75a69ce;s=i0;s=i1;s=i2;s=i3;s=i4;s=i5;s=i6;s=i7;s=i9;s=m1;s=m4;s=u4;s=u5;s=u10;s=u35;z=153;z=141;z=180;z=173;s=3072;s=32;s=1009;dc_ref=http%3A%2F%2Fwww.amazon.com;tile=1;ord=0JNNCCYK0E23P11J4NSE\",\n                    q: \"N4215\"\n                });\n            });\n        }\n    ;\n    ;\n    })(window, JSBNG__document);\n} catch (JSBNG_ex) {\n\n};");
// 1115
o4 = {};
// 1116
f876774570_0.returns.push(o4);
// 1114
geval("try {\n    if (((typeof setCSMReq == \"function\"))) {\n        setCSMReq(\"cf\");\n    }\n     else {\n        if (((typeof uet == \"function\"))) {\n            uet(\"cf\");\n        }\n    ;\n    ;\n        amznJQ.completedStage(\"amznJQ.criticalFeature\");\n    }\n;\n;\n} catch (JSBNG_ex) {\n\n};");
// 1118
o4.getTime = f876774570_400;
// undefined
o4 = null;
// 1119
f876774570_400.returns.push(1374695829664);
// 1117
geval("try {\n    (function() {\n        var initJQuery = function() {\n            var jQuery126PatchDelay = 13;\n            var _jQuery = window.jQuery, _$ = window.$;\n            var jQuery = window.jQuery = window.$ = function(selector, context) {\n                return new jQuery.fn.init(selector, context);\n            };\n            var quickExpr = /^[^<]*(<(.|\\s)+>)[^>]*$|^#(\\w+)$/, isSimple = /^.[^:#\\[\\.]*$/, undefined;\n            jQuery.fn = jQuery.prototype = {\n                init: function(selector, context) {\n                    selector = ((selector || JSBNG__document));\n                    if (selector.nodeType) {\n                        this[0] = selector;\n                        this.length = 1;\n                        return this;\n                    }\n                ;\n                ;\n                    if (((typeof selector == \"string\"))) {\n                        var match = quickExpr.exec(selector);\n                        if (((match && ((match[1] || !context))))) {\n                            if (match[1]) {\n                                selector = jQuery.clean([match[1],], context);\n                            }\n                             else {\n                                var elem = JSBNG__document.getElementById(match[3]);\n                                if (elem) {\n                                    if (((elem.id != match[3]))) {\n                                        return jQuery().JSBNG__find(selector);\n                                    }\n                                ;\n                                ;\n                                    return jQuery(elem);\n                                }\n                            ;\n                            ;\n                                selector = [];\n                            }\n                        ;\n                        ;\n                        }\n                         else {\n                            return jQuery(context).JSBNG__find(selector);\n                        }\n                    ;\n                    ;\n                    }\n                     else {\n                        if (jQuery.isFunction(selector)) {\n                            return jQuery(JSBNG__document)[((jQuery.fn.ready ? \"ready\" : \"load\"))](selector);\n                        }\n                    ;\n                    ;\n                    }\n                ;\n                ;\n                    return this.setArray(jQuery.makeArray(selector));\n                },\n                jquery: \"1.2.6\",\n                size: function() {\n                    return this.length;\n                },\n                length: 0,\n                get: function(num) {\n                    return ((((num == undefined)) ? jQuery.makeArray(this) : this[num]));\n                },\n                pushStack: function(elems) {\n                    var ret = jQuery(elems);\n                    ret.prevObject = this;\n                    return ret;\n                },\n                setArray: function(elems) {\n                    this.length = 0;\n                    Array.prototype.push.apply(this, elems);\n                    return this;\n                },\n                each: function(callback, args) {\n                    return jQuery.each(this, callback, args);\n                },\n                index: function(elem) {\n                    var ret = -1;\n                    return jQuery.inArray(((((elem && elem.jquery)) ? elem[0] : elem)), this);\n                },\n                attr: function(JSBNG__name, value, type) {\n                    var options = JSBNG__name;\n                    if (((JSBNG__name.constructor == String))) {\n                        if (((value === undefined))) {\n                            return ((this[0] && jQuery[((type || \"attr\"))](this[0], JSBNG__name)));\n                        }\n                         else {\n                            options = {\n                            };\n                            options[JSBNG__name] = value;\n                        }\n                    ;\n                    ;\n                    }\n                ;\n                ;\n                    return this.each(function(i) {\n                        {\n                            var fin8keys = ((window.top.JSBNG_Replay.forInKeys)((options))), fin8i = (0);\n                            (0);\n                            for (; (fin8i < fin8keys.length); (fin8i++)) {\n                                ((name) = (fin8keys[fin8i]));\n                                {\n                                    jQuery.attr(((type ? this.style : this)), JSBNG__name, jQuery.prop(this, options[JSBNG__name], type, i, JSBNG__name));\n                                };\n                            };\n                        };\n                    ;\n                    });\n                },\n                css: function(key, value) {\n                    if (((((((key == \"width\")) || ((key == \"height\")))) && ((parseFloat(value) < 0))))) {\n                        value = undefined;\n                    }\n                ;\n                ;\n                    return this.attr(key, value, \"curCSS\");\n                },\n                text: function(text) {\n                    if (((((typeof text != \"object\")) && ((text != null))))) {\n                        return this.empty().append(((((this[0] && this[0].ownerDocument)) || JSBNG__document)).createTextNode(text));\n                    }\n                ;\n                ;\n                    var ret = \"\";\n                    jQuery.each(((text || this)), function() {\n                        jQuery.each(this.childNodes, function() {\n                            if (((this.nodeType != 8))) {\n                                ret += ((((this.nodeType != 1)) ? this.nodeValue : jQuery.fn.text([this,])));\n                            }\n                        ;\n                        ;\n                        });\n                    });\n                    return ret;\n                },\n                wrapAll: function(html) {\n                    if (this[0]) {\n                        jQuery(html, this[0].ownerDocument).clone().insertBefore(this[0]).map(function() {\n                            var elem = this;\n                            while (elem.firstChild) {\n                                elem = elem.firstChild;\n                            };\n                        ;\n                            return elem;\n                        }).append(this);\n                    }\n                ;\n                ;\n                    return this;\n                },\n                wrapInner: function(html) {\n                    return this.each(function() {\n                        jQuery(this).contents().wrapAll(html);\n                    });\n                },\n                wrap: function(html) {\n                    return this.each(function() {\n                        jQuery(this).wrapAll(html);\n                    });\n                },\n                append: function() {\n                    return this.domManip(arguments, true, false, function(elem) {\n                        if (((this.nodeType == 1))) {\n                            this.appendChild(elem);\n                        }\n                    ;\n                    ;\n                    });\n                },\n                prepend: function() {\n                    return this.domManip(arguments, true, true, function(elem) {\n                        if (((this.nodeType == 1))) {\n                            this.insertBefore(elem, this.firstChild);\n                        }\n                    ;\n                    ;\n                    });\n                },\n                before: function() {\n                    return this.domManip(arguments, false, false, function(elem) {\n                        this.parentNode.insertBefore(elem, this);\n                    });\n                },\n                after: function() {\n                    return this.domManip(arguments, false, true, function(elem) {\n                        this.parentNode.insertBefore(elem, this.nextSibling);\n                    });\n                },\n                end: function() {\n                    return ((this.prevObject || jQuery([])));\n                },\n                JSBNG__find: function(selector) {\n                    var elems = jQuery.map(this, function(elem) {\n                        return jQuery.JSBNG__find(selector, elem);\n                    });\n                    return this.pushStack(((((/[^+>] [^+>]/.test(selector) || ((selector.indexOf(\"..\") > -1)))) ? jQuery.unique(elems) : elems)));\n                },\n                clone: function(events) {\n                    var ret = this.map(function() {\n                        if (((jQuery.browser.msie && !jQuery.isXMLDoc(this)))) {\n                            var clone = this.cloneNode(true), container = JSBNG__document.createElement(\"div\");\n                            container.appendChild(clone);\n                            return jQuery.clean([container.innerHTML,])[0];\n                        }\n                         else {\n                            return this.cloneNode(true);\n                        }\n                    ;\n                    ;\n                    });\n                    var clone = ret.JSBNG__find(\"*\").andSelf().each(function() {\n                        if (((this[expando] != undefined))) {\n                            this[expando] = null;\n                        }\n                    ;\n                    ;\n                    });\n                    if (((events === true))) {\n                        this.JSBNG__find(\"*\").andSelf().each(function(i) {\n                            if (((this.nodeType == 3))) {\n                                return;\n                            }\n                        ;\n                        ;\n                            var events = jQuery.data(this, \"events\");\n                            {\n                                var fin9keys = ((window.top.JSBNG_Replay.forInKeys)((events))), fin9i = (0);\n                                var type;\n                                for (; (fin9i < fin9keys.length); (fin9i++)) {\n                                    ((type) = (fin9keys[fin9i]));\n                                    {\n                                        {\n                                            var fin10keys = ((window.top.JSBNG_Replay.forInKeys)((events[type]))), fin10i = (0);\n                                            var handler;\n                                            for (; (fin10i < fin10keys.length); (fin10i++)) {\n                                                ((handler) = (fin10keys[fin10i]));\n                                                {\n                                                    jQuery.JSBNG__event.add(clone[i], type, events[type][handler], events[type][handler].data);\n                                                };\n                                            };\n                                        };\n                                    ;\n                                    };\n                                };\n                            };\n                        ;\n                        });\n                    }\n                ;\n                ;\n                    return ret;\n                },\n                filter: function(selector) {\n                    return this.pushStack(((((jQuery.isFunction(selector) && jQuery.grep(this, function(elem, i) {\n                        return selector.call(elem, i);\n                    }))) || jQuery.multiFilter(selector, this))));\n                },\n                not: function(selector) {\n                    if (((selector.constructor == String))) {\n                        if (isSimple.test(selector)) {\n                            return this.pushStack(jQuery.multiFilter(selector, this, true));\n                        }\n                         else {\n                            selector = jQuery.multiFilter(selector, this);\n                        }\n                    ;\n                    ;\n                    }\n                ;\n                ;\n                    var isArrayLike = ((((selector.length && ((selector[((selector.length - 1))] !== undefined)))) && !selector.nodeType));\n                    return this.filter(function() {\n                        return ((isArrayLike ? ((jQuery.inArray(this, selector) < 0)) : ((this != selector))));\n                    });\n                },\n                add: function(selector) {\n                    return this.pushStack(jQuery.unique(jQuery.merge(this.get(), ((((typeof selector == \"string\")) ? jQuery(selector) : jQuery.makeArray(selector))))));\n                },\n                is: function(selector) {\n                    return ((!!selector && ((jQuery.multiFilter(selector, this).length > 0))));\n                },\n                hasClass: function(selector) {\n                    return this.is(((\".\" + selector)));\n                },\n                val: function(value) {\n                    if (((value == undefined))) {\n                        if (this.length) {\n                            var elem = this[0];\n                            if (jQuery.nodeName(elem, \"select\")) {\n                                var index = elem.selectedIndex, values = [], options = elem.options, one = ((elem.type == \"select-one\"));\n                                if (((index < 0))) {\n                                    return null;\n                                }\n                            ;\n                            ;\n                                for (var i = ((one ? index : 0)), max = ((one ? ((index + 1)) : options.length)); ((i < max)); i++) {\n                                    var option = options[i];\n                                    if (option.selected) {\n                                        value = ((((jQuery.browser.msie && !option.attributes.value.specified)) ? option.text : option.value));\n                                        if (one) {\n                                            return value;\n                                        }\n                                    ;\n                                    ;\n                                        values.push(value);\n                                    }\n                                ;\n                                ;\n                                };\n                            ;\n                                return values;\n                            }\n                             else {\n                                return ((this[0].value || \"\")).replace(/\\r/g, \"\");\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                        return undefined;\n                    }\n                ;\n                ;\n                    if (((value.constructor == Number))) {\n                        value += \"\";\n                    }\n                ;\n                ;\n                    return this.each(function() {\n                        if (((this.nodeType != 1))) {\n                            return;\n                        }\n                    ;\n                    ;\n                        if (((((value.constructor == Array)) && /radio|checkbox/.test(this.type)))) {\n                            this.checked = ((((jQuery.inArray(this.value, value) >= 0)) || ((jQuery.inArray(this.JSBNG__name, value) >= 0))));\n                        }\n                         else {\n                            if (jQuery.nodeName(this, \"select\")) {\n                                var values = jQuery.makeArray(value);\n                                jQuery(\"option\", this).each(function() {\n                                    this.selected = ((((jQuery.inArray(this.value, values) >= 0)) || ((jQuery.inArray(this.text, values) >= 0))));\n                                });\n                                if (!values.length) {\n                                    this.selectedIndex = -1;\n                                }\n                            ;\n                            ;\n                            }\n                             else {\n                                this.value = value;\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                    });\n                },\n                html: function(value) {\n                    return ((((value == undefined)) ? ((this[0] ? this[0].innerHTML : null)) : this.empty().append(value)));\n                },\n                replaceWith: function(value) {\n                    return this.after(value).remove();\n                },\n                eq: function(i) {\n                    return this.slice(i, ((i + 1)));\n                },\n                slice: function() {\n                    return this.pushStack(Array.prototype.slice.apply(this, arguments));\n                },\n                map: function(callback) {\n                    return this.pushStack(jQuery.map(this, function(elem, i) {\n                        return callback.call(elem, i, elem);\n                    }));\n                },\n                andSelf: function() {\n                    return this.add(this.prevObject);\n                },\n                data: function(key, value) {\n                    var parts = key.split(\".\");\n                    parts[1] = ((parts[1] ? ((\".\" + parts[1])) : \"\"));\n                    if (((value === undefined))) {\n                        var data = this.triggerHandler(((((\"getData\" + parts[1])) + \"!\")), [parts[0],]);\n                        if (((((data === undefined)) && this.length))) {\n                            data = jQuery.data(this[0], key);\n                        }\n                    ;\n                    ;\n                        return ((((((data === undefined)) && parts[1])) ? this.data(parts[0]) : data));\n                    }\n                     else {\n                        return this.trigger(((((\"setData\" + parts[1])) + \"!\")), [parts[0],value,]).each(function() {\n                            jQuery.data(this, key, value);\n                        });\n                    }\n                ;\n                ;\n                },\n                removeData: function(key) {\n                    return this.each(function() {\n                        jQuery.removeData(this, key);\n                    });\n                },\n                domManip: function(args, table, reverse, callback) {\n                    var clone = ((this.length > 1)), elems;\n                    return this.each(function() {\n                        if (!elems) {\n                            elems = jQuery.clean(args, this.ownerDocument);\n                            if (reverse) {\n                                elems.reverse();\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                        var obj = this;\n                        if (((((table && jQuery.nodeName(this, \"table\"))) && jQuery.nodeName(elems[0], \"tr\")))) {\n                            obj = ((this.getElementsByTagName(\"tbody\")[0] || this.appendChild(this.ownerDocument.createElement(\"tbody\"))));\n                        }\n                    ;\n                    ;\n                        var scripts = jQuery([]);\n                        jQuery.each(elems, function() {\n                            var elem = ((clone ? jQuery(this).clone(true)[0] : this));\n                            if (jQuery.nodeName(elem, \"script\")) {\n                                scripts = scripts.add(elem);\n                            }\n                             else {\n                                if (((elem.nodeType == 1))) {\n                                    scripts = scripts.add(jQuery(\"script\", elem).remove());\n                                }\n                            ;\n                            ;\n                                callback.call(obj, elem);\n                            }\n                        ;\n                        ;\n                        });\n                        scripts.each(evalScript);\n                    });\n                }\n            };\n            jQuery.fn.init.prototype = jQuery.fn;\n            function evalScript(i, elem) {\n                if (elem.src) {\n                    jQuery.ajax({\n                        url: elem.src,\n                        async: false,\n                        dataType: \"script\"\n                    });\n                }\n                 else {\n                    jQuery.globalEval(((((((elem.text || elem.textContent)) || elem.innerHTML)) || \"\")));\n                }\n            ;\n            ;\n                if (elem.parentNode) {\n                    elem.parentNode.removeChild(elem);\n                }\n            ;\n            ;\n            };\n        ;\n            function now() {\n                return +new JSBNG__Date;\n            };\n        ;\n            jQuery.extend = jQuery.fn.extend = function() {\n                var target = ((arguments[0] || {\n                })), i = 1, length = arguments.length, deep = false, options;\n                if (((target.constructor == Boolean))) {\n                    deep = target;\n                    target = ((arguments[1] || {\n                    }));\n                    i = 2;\n                }\n            ;\n            ;\n                if (((((typeof target != \"object\")) && ((typeof target != \"function\"))))) {\n                    target = {\n                    };\n                }\n            ;\n            ;\n                if (((length == i))) {\n                    target = this;\n                    --i;\n                }\n            ;\n            ;\n                for (; ((i < length)); i++) {\n                    if ((((options = arguments[i]) != null))) {\n                        {\n                            var fin11keys = ((window.top.JSBNG_Replay.forInKeys)((options))), fin11i = (0);\n                            var JSBNG__name;\n                            for (; (fin11i < fin11keys.length); (fin11i++)) {\n                                ((name) = (fin11keys[fin11i]));\n                                {\n                                    var src = target[JSBNG__name], copy = options[JSBNG__name];\n                                    if (((target === copy))) {\n                                        continue;\n                                    }\n                                ;\n                                ;\n                                    if (((((((deep && copy)) && ((typeof copy == \"object\")))) && !copy.nodeType))) {\n                                        target[JSBNG__name] = jQuery.extend(deep, ((src || ((((copy.length != null)) ? [] : {\n                                        })))), copy);\n                                    }\n                                     else {\n                                        if (((copy !== undefined))) {\n                                            target[JSBNG__name] = copy;\n                                        }\n                                    ;\n                                    ;\n                                    }\n                                ;\n                                ;\n                                };\n                            };\n                        };\n                    ;\n                    }\n                ;\n                ;\n                };\n            ;\n                return target;\n            };\n            var expando = ((\"jQuery\" + now())), uuid = 0, windowData = {\n            }, exclude = /z-?index|font-?weight|opacity|zoom|line-?height/i, defaultView = ((JSBNG__document.defaultView || {\n            }));\n            jQuery.extend({\n                noConflict: function(deep) {\n                    window.$ = _$;\n                    if (deep) {\n                        window.jQuery = _jQuery;\n                    }\n                ;\n                ;\n                    return jQuery;\n                },\n                isFunction: function(fn) {\n                    return ((((((((!!fn && ((typeof fn != \"string\")))) && !fn.nodeName)) && ((fn.constructor != Array)))) && /^[\\s[]?function/.test(((fn + \"\")))));\n                },\n                isXMLDoc: function(elem) {\n                    return ((((elem.documentElement && !elem.body)) || ((((elem.tagName && elem.ownerDocument)) && !elem.ownerDocument.body))));\n                },\n                globalEval: function(data) {\n                    data = jQuery.trim(data);\n                    if (data) {\n                        var head = ((JSBNG__document.getElementsByTagName(\"head\")[0] || JSBNG__document.documentElement)), script = JSBNG__document.createElement(\"script\");\n                        script.type = \"text/javascript\";\n                        if (jQuery.browser.msie) {\n                            script.text = data;\n                        }\n                         else {\n                            script.appendChild(JSBNG__document.createTextNode(data));\n                        }\n                    ;\n                    ;\n                        head.insertBefore(script, head.firstChild);\n                        head.removeChild(script);\n                    }\n                ;\n                ;\n                },\n                nodeName: function(elem, JSBNG__name) {\n                    return ((elem.nodeName && ((elem.nodeName.toUpperCase() == JSBNG__name.toUpperCase()))));\n                },\n                cache: {\n                },\n                data: function(elem, JSBNG__name, data) {\n                    elem = ((((elem == window)) ? windowData : elem));\n                    var id = elem[expando];\n                    if (!id) {\n                        id = elem[expando] = ++uuid;\n                    }\n                ;\n                ;\n                    if (((JSBNG__name && !jQuery.cache[id]))) {\n                        jQuery.cache[id] = {\n                        };\n                    }\n                ;\n                ;\n                    if (((data !== undefined))) {\n                        jQuery.cache[id][JSBNG__name] = data;\n                    }\n                ;\n                ;\n                    return ((JSBNG__name ? jQuery.cache[id][JSBNG__name] : id));\n                },\n                removeData: function(elem, JSBNG__name) {\n                    elem = ((((elem == window)) ? windowData : elem));\n                    var id = elem[expando];\n                    if (JSBNG__name) {\n                        if (jQuery.cache[id]) {\n                            delete jQuery.cache[id][JSBNG__name];\n                            JSBNG__name = \"\";\n                            {\n                                var fin12keys = ((window.top.JSBNG_Replay.forInKeys)((jQuery.cache[id]))), fin12i = (0);\n                                (0);\n                                for (; (fin12i < fin12keys.length); (fin12i++)) {\n                                    ((name) = (fin12keys[fin12i]));\n                                    {\n                                        break;\n                                    };\n                                };\n                            };\n                        ;\n                            if (!JSBNG__name) {\n                                jQuery.removeData(elem);\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                    }\n                     else {\n                        try {\n                            delete elem[expando];\n                        } catch (e) {\n                            if (elem.removeAttribute) {\n                                elem.removeAttribute(expando);\n                            }\n                        ;\n                        ;\n                        };\n                    ;\n                        delete jQuery.cache[id];\n                    }\n                ;\n                ;\n                },\n                each: function(object, callback, args) {\n                    var JSBNG__name, i = 0, length = object.length;\n                    if (args) {\n                        if (((length == undefined))) {\n                            {\n                                var fin13keys = ((window.top.JSBNG_Replay.forInKeys)((object))), fin13i = (0);\n                                (0);\n                                for (; (fin13i < fin13keys.length); (fin13i++)) {\n                                    ((name) = (fin13keys[fin13i]));\n                                    {\n                                        if (((callback.apply(object[JSBNG__name], args) === false))) {\n                                            break;\n                                        }\n                                    ;\n                                    ;\n                                    };\n                                };\n                            };\n                        ;\n                        }\n                         else {\n                            for (; ((i < length)); ) {\n                                if (((callback.apply(object[i++], args) === false))) {\n                                    break;\n                                }\n                            ;\n                            ;\n                            };\n                        ;\n                        }\n                    ;\n                    ;\n                    }\n                     else {\n                        if (((length == undefined))) {\n                            {\n                                var fin14keys = ((window.top.JSBNG_Replay.forInKeys)((object))), fin14i = (0);\n                                (0);\n                                for (; (fin14i < fin14keys.length); (fin14i++)) {\n                                    ((name) = (fin14keys[fin14i]));\n                                    {\n                                        if (((callback.call(object[JSBNG__name], JSBNG__name, object[JSBNG__name]) === false))) {\n                                            break;\n                                        }\n                                    ;\n                                    ;\n                                    };\n                                };\n                            };\n                        ;\n                        }\n                         else {\n                            for (var value = object[0]; ((((i < length)) && ((callback.call(value, i, value) !== false)))); value = object[++i]) {\n                            \n                            };\n                        ;\n                        }\n                    ;\n                    ;\n                    }\n                ;\n                ;\n                    return object;\n                },\n                prop: function(elem, value, type, i, JSBNG__name) {\n                    if (jQuery.isFunction(value)) {\n                        value = value.call(elem, i);\n                    }\n                ;\n                ;\n                    return ((((((((value && ((value.constructor == Number)))) && ((type == \"curCSS\")))) && !exclude.test(JSBNG__name))) ? ((value + \"px\")) : value));\n                },\n                className: {\n                    add: function(elem, classNames) {\n                        jQuery.each(((classNames || \"\")).split(/\\s+/), function(i, className) {\n                            if (((((elem.nodeType == 1)) && !jQuery.className.has(elem.className, className)))) {\n                                elem.className += ((((elem.className ? \" \" : \"\")) + className));\n                            }\n                        ;\n                        ;\n                        });\n                    },\n                    remove: function(elem, classNames) {\n                        if (((elem.nodeType == 1))) {\n                            elem.className = ((((classNames != undefined)) ? jQuery.grep(elem.className.split(/\\s+/), function(className) {\n                                return !jQuery.className.has(classNames, className);\n                            }).join(\" \") : \"\"));\n                        }\n                    ;\n                    ;\n                    },\n                    has: function(elem, className) {\n                        return ((jQuery.inArray(className, ((elem.className || elem)).toString().split(/\\s+/)) > -1));\n                    }\n                },\n                swap: function(elem, options, callback) {\n                    var old = {\n                    };\n                    {\n                        var fin15keys = ((window.top.JSBNG_Replay.forInKeys)((options))), fin15i = (0);\n                        var JSBNG__name;\n                        for (; (fin15i < fin15keys.length); (fin15i++)) {\n                            ((name) = (fin15keys[fin15i]));\n                            {\n                                old[JSBNG__name] = elem.style[JSBNG__name];\n                                elem.style[JSBNG__name] = options[JSBNG__name];\n                            };\n                        };\n                    };\n                ;\n                    callback.call(elem);\n                    {\n                        var fin16keys = ((window.top.JSBNG_Replay.forInKeys)((options))), fin16i = (0);\n                        var JSBNG__name;\n                        for (; (fin16i < fin16keys.length); (fin16i++)) {\n                            ((name) = (fin16keys[fin16i]));\n                            {\n                                elem.style[JSBNG__name] = old[JSBNG__name];\n                            };\n                        };\n                    };\n                ;\n                },\n                css: function(elem, JSBNG__name, force) {\n                    if (((((JSBNG__name == \"width\")) || ((JSBNG__name == \"height\"))))) {\n                        var val, props = {\n                            position: \"absolute\",\n                            visibility: \"hidden\",\n                            display: \"block\"\n                        }, which = ((((JSBNG__name == \"width\")) ? [\"Left\",\"Right\",] : [\"Top\",\"Bottom\",]));\n                        function getWH() {\n                            val = ((((JSBNG__name == \"width\")) ? elem.offsetWidth : elem.offsetHeight));\n                            var padding = 0, border = 0;\n                            jQuery.each(which, function() {\n                                padding += ((parseFloat(jQuery.curCSS(elem, ((\"padding\" + this)), true)) || 0));\n                                border += ((parseFloat(jQuery.curCSS(elem, ((((\"border\" + this)) + \"Width\")), true)) || 0));\n                            });\n                            val -= Math.round(((padding + border)));\n                        };\n                    ;\n                        if (jQuery(elem).is(\":visible\")) {\n                            getWH();\n                        }\n                         else {\n                            jQuery.swap(elem, props, getWH);\n                        }\n                    ;\n                    ;\n                        return Math.max(0, val);\n                    }\n                ;\n                ;\n                    return jQuery.curCSS(elem, JSBNG__name, force);\n                },\n                curCSS: function(elem, JSBNG__name, force) {\n                    var ret, style = elem.style;\n                    function color(elem) {\n                        if (!jQuery.browser.safari) {\n                            return false;\n                        }\n                    ;\n                    ;\n                        var ret = defaultView.JSBNG__getComputedStyle(elem, null);\n                        return ((!ret || ((ret.getPropertyValue(\"color\") == \"\"))));\n                    };\n                ;\n                    if (((((JSBNG__name == \"opacity\")) && jQuery.browser.msie))) {\n                        ret = jQuery.attr(style, \"opacity\");\n                        return ((((ret == \"\")) ? \"1\" : ret));\n                    }\n                ;\n                ;\n                    if (((jQuery.browser.JSBNG__opera && ((JSBNG__name == \"display\"))))) {\n                        var save = style.outline;\n                        style.outline = \"0 solid black\";\n                        style.outline = save;\n                    }\n                ;\n                ;\n                    if (JSBNG__name.match(/float/i)) {\n                        JSBNG__name = styleFloat;\n                    }\n                ;\n                ;\n                    if (((((!force && style)) && style[JSBNG__name]))) {\n                        ret = style[JSBNG__name];\n                    }\n                     else {\n                        if (defaultView.JSBNG__getComputedStyle) {\n                            if (JSBNG__name.match(/float/i)) {\n                                JSBNG__name = \"float\";\n                            }\n                        ;\n                        ;\n                            JSBNG__name = JSBNG__name.replace(/([A-Z])/g, \"-$1\").toLowerCase();\n                            var computedStyle = defaultView.JSBNG__getComputedStyle(elem, null);\n                            if (((computedStyle && !color(elem)))) {\n                                ret = computedStyle.getPropertyValue(JSBNG__name);\n                            }\n                             else {\n                                var swap = [], stack = [], a = elem, i = 0;\n                                for (; ((a && color(a))); a = a.parentNode) {\n                                    stack.unshift(a);\n                                };\n                            ;\n                                for (; ((i < stack.length)); i++) {\n                                    if (color(stack[i])) {\n                                        swap[i] = stack[i].style.display;\n                                        stack[i].style.display = \"block\";\n                                    }\n                                ;\n                                ;\n                                };\n                            ;\n                                ret = ((((((JSBNG__name == \"display\")) && ((swap[((stack.length - 1))] != null)))) ? \"none\" : ((((computedStyle && computedStyle.getPropertyValue(JSBNG__name))) || \"\"))));\n                                for (i = 0; ((i < swap.length)); i++) {\n                                    if (((swap[i] != null))) {\n                                        stack[i].style.display = swap[i];\n                                    }\n                                ;\n                                ;\n                                };\n                            ;\n                            }\n                        ;\n                        ;\n                            if (((((JSBNG__name == \"opacity\")) && ((ret == \"\"))))) {\n                                ret = \"1\";\n                            }\n                        ;\n                        ;\n                        }\n                         else {\n                            if (elem.currentStyle) {\n                                var camelCase = JSBNG__name.replace(/\\-(\\w)/g, function(all, letter) {\n                                    return letter.toUpperCase();\n                                });\n                                ret = ((elem.currentStyle[JSBNG__name] || elem.currentStyle[camelCase]));\n                                if (((!/^\\d+(px)?$/i.test(ret) && /^\\d/.test(ret)))) {\n                                    var left = style.left, rsLeft = elem.runtimeStyle.left;\n                                    elem.runtimeStyle.left = elem.currentStyle.left;\n                                    style.left = ((ret || 0));\n                                    ret = ((style.pixelLeft + \"px\"));\n                                    style.left = left;\n                                    elem.runtimeStyle.left = rsLeft;\n                                }\n                            ;\n                            ;\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                    }\n                ;\n                ;\n                    return ret;\n                },\n                clean: function(elems, context) {\n                    var ret = [];\n                    context = ((context || JSBNG__document));\n                    if (((typeof context.createElement == \"undefined\"))) {\n                        context = ((((context.ownerDocument || ((context[0] && context[0].ownerDocument)))) || JSBNG__document));\n                    }\n                ;\n                ;\n                    jQuery.each(elems, function(i, elem) {\n                        if (!elem) {\n                            return;\n                        }\n                    ;\n                    ;\n                        if (((elem.constructor == Number))) {\n                            elem += \"\";\n                        }\n                    ;\n                    ;\n                        if (((typeof elem == \"string\"))) {\n                            elem = elem.replace(/(<(\\w+)[^>]*?)\\/>/g, function(all, front, tag) {\n                                return ((tag.match(/^(abbr|br|col|img|input|link|meta|param|hr|area|embed)$/i) ? all : ((((((front + \"\\u003E\\u003C/\")) + tag)) + \"\\u003E\"))));\n                            });\n                            var tags = jQuery.trim(elem).toLowerCase(), div = context.createElement(\"div\");\n                            var wrap = ((((((((((((((((!tags.indexOf(\"\\u003Copt\") && [1,\"\\u003Cselect multiple='multiple'\\u003E\",\"\\u003C/select\\u003E\",])) || ((!tags.indexOf(\"\\u003Cleg\") && [1,\"\\u003Cfieldset\\u003E\",\"\\u003C/fieldset\\u003E\",])))) || ((tags.match(/^<(thead|tbody|tfoot|colg|cap)/) && [1,\"\\u003Ctable\\u003E\",\"\\u003C/table\\u003E\",])))) || ((!tags.indexOf(\"\\u003Ctr\") && [2,\"\\u003Ctable\\u003E\\u003Ctbody\\u003E\",\"\\u003C/tbody\\u003E\\u003C/table\\u003E\",])))) || ((((!tags.indexOf(\"\\u003Ctd\") || !tags.indexOf(\"\\u003Cth\"))) && [3,\"\\u003Ctable\\u003E\\u003Ctbody\\u003E\\u003Ctr\\u003E\",\"\\u003C/tr\\u003E\\u003C/tbody\\u003E\\u003C/table\\u003E\",])))) || ((!tags.indexOf(\"\\u003Ccol\") && [2,\"\\u003Ctable\\u003E\\u003Ctbody\\u003E\\u003C/tbody\\u003E\\u003Ccolgroup\\u003E\",\"\\u003C/colgroup\\u003E\\u003C/table\\u003E\",])))) || ((jQuery.browser.msie && [1,\"div\\u003Cdiv\\u003E\",\"\\u003C/div\\u003E\",])))) || [0,\"\",\"\",]));\n                            div.innerHTML = ((((wrap[1] + elem)) + wrap[2]));\n                            while (wrap[0]--) {\n                                div = div.lastChild;\n                            };\n                        ;\n                            if (jQuery.browser.msie) {\n                                var tbody = ((((!tags.indexOf(\"\\u003Ctable\") && ((tags.indexOf(\"\\u003Ctbody\") < 0)))) ? ((div.firstChild && div.firstChild.childNodes)) : ((((((wrap[1] == \"\\u003Ctable\\u003E\")) && ((tags.indexOf(\"\\u003Ctbody\") < 0)))) ? div.childNodes : []))));\n                                for (var j = ((tbody.length - 1)); ((j >= 0)); --j) {\n                                    if (((jQuery.nodeName(tbody[j], \"tbody\") && !tbody[j].childNodes.length))) {\n                                        tbody[j].parentNode.removeChild(tbody[j]);\n                                    }\n                                ;\n                                ;\n                                };\n                            ;\n                                if (/^\\s/.test(elem)) {\n                                    div.insertBefore(context.createTextNode(elem.match(/^\\s*/)[0]), div.firstChild);\n                                }\n                            ;\n                            ;\n                            }\n                        ;\n                        ;\n                            elem = jQuery.makeArray(div.childNodes);\n                        }\n                    ;\n                    ;\n                        if (((((elem.length === 0)) && ((!jQuery.nodeName(elem, \"form\") && !jQuery.nodeName(elem, \"select\")))))) {\n                            return;\n                        }\n                    ;\n                    ;\n                        if (((((((elem[0] == undefined)) || jQuery.nodeName(elem, \"form\"))) || elem.options))) {\n                            ret.push(elem);\n                        }\n                         else {\n                            ret = jQuery.merge(ret, elem);\n                        }\n                    ;\n                    ;\n                    });\n                    return ret;\n                },\n                attr: function(elem, JSBNG__name, value) {\n                    if (((((!elem || ((elem.nodeType == 3)))) || ((elem.nodeType == 8))))) {\n                        return undefined;\n                    }\n                ;\n                ;\n                    var notxml = !jQuery.isXMLDoc(elem), set = ((value !== undefined)), msie = jQuery.browser.msie;\n                    JSBNG__name = ((((notxml && jQuery.props[JSBNG__name])) || JSBNG__name));\n                    if (elem.tagName) {\n                        var special = /href|src|style/.test(JSBNG__name);\n                        if (((((JSBNG__name == \"selected\")) && jQuery.browser.safari))) {\n                            elem.parentNode.selectedIndex;\n                        }\n                    ;\n                    ;\n                        if (((((((JSBNG__name in elem)) && notxml)) && !special))) {\n                            if (set) {\n                                if (((((((JSBNG__name == \"type\")) && jQuery.nodeName(elem, \"input\"))) && elem.parentNode))) {\n                                    throw \"type property can't be changed\";\n                                }\n                            ;\n                            ;\n                                elem[JSBNG__name] = value;\n                            }\n                        ;\n                        ;\n                            if (((jQuery.nodeName(elem, \"form\") && elem.getAttributeNode(JSBNG__name)))) {\n                                return elem.getAttributeNode(JSBNG__name).nodeValue;\n                            }\n                        ;\n                        ;\n                            return elem[JSBNG__name];\n                        }\n                    ;\n                    ;\n                        if (((((msie && notxml)) && ((JSBNG__name == \"style\"))))) {\n                            return jQuery.attr(elem.style, \"cssText\", value);\n                        }\n                    ;\n                    ;\n                        if (set) {\n                            elem.setAttribute(JSBNG__name, ((\"\" + value)));\n                        }\n                    ;\n                    ;\n                        var attr = ((((((msie && notxml)) && special)) ? elem.getAttribute(JSBNG__name, 2) : elem.getAttribute(JSBNG__name)));\n                        return ((((attr === null)) ? undefined : attr));\n                    }\n                ;\n                ;\n                    if (((msie && ((JSBNG__name == \"opacity\"))))) {\n                        if (set) {\n                            elem.zoom = 1;\n                            elem.filter = ((((elem.filter || \"\")).replace(/alpha\\([^)]*\\)/, \"\") + ((((((parseInt(value) + \"\")) == \"NaN\")) ? \"\" : ((((\"alpha(opacity=\" + ((value * 100)))) + \")\"))))));\n                        }\n                    ;\n                    ;\n                        return ((((elem.filter && ((elem.filter.indexOf(\"opacity=\") >= 0)))) ? ((((parseFloat(elem.filter.match(/opacity=([^)]*)/)[1]) / 100)) + \"\")) : \"\"));\n                    }\n                ;\n                ;\n                    JSBNG__name = JSBNG__name.replace(/-([a-z])/gi, function(all, letter) {\n                        return letter.toUpperCase();\n                    });\n                    if (set) {\n                        elem[JSBNG__name] = value;\n                    }\n                ;\n                ;\n                    return elem[JSBNG__name];\n                },\n                trim: function(text) {\n                    return ((text || \"\")).replace(/^\\s+|\\s+$/g, \"\");\n                },\n                makeArray: function(array) {\n                    var ret = [];\n                    if (((array != null))) {\n                        var i = array.length;\n                        if (((((((((i == null)) || array.split)) || array.JSBNG__setInterval)) || array.call))) {\n                            ret[0] = array;\n                        }\n                         else {\n                            while (i) {\n                                ret[--i] = array[i];\n                            };\n                        ;\n                        }\n                    ;\n                    ;\n                    }\n                ;\n                ;\n                    return ret;\n                },\n                inArray: function(elem, array) {\n                    for (var i = 0, length = array.length; ((i < length)); i++) {\n                        if (((array[i] === elem))) {\n                            return i;\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    return -1;\n                },\n                merge: function(first, second) {\n                    var i = 0, elem, pos = first.length;\n                    if (jQuery.browser.msie) {\n                        while (elem = second[i++]) {\n                            if (((elem.nodeType != 8))) {\n                                first[pos++] = elem;\n                            }\n                        ;\n                        ;\n                        };\n                    ;\n                    }\n                     else {\n                        while (elem = second[i++]) {\n                            first[pos++] = elem;\n                        };\n                    ;\n                    }\n                ;\n                ;\n                    return first;\n                },\n                unique: function(array) {\n                    var ret = [], done = {\n                    };\n                    try {\n                        for (var i = 0, length = array.length; ((i < length)); i++) {\n                            var id = jQuery.data(array[i]);\n                            if (!done[id]) {\n                                done[id] = true;\n                                ret.push(array[i]);\n                            }\n                        ;\n                        ;\n                        };\n                    ;\n                    } catch (e) {\n                        ret = array;\n                    };\n                ;\n                    return ret;\n                },\n                grep: function(elems, callback, inv) {\n                    var ret = [];\n                    for (var i = 0, length = elems.length; ((i < length)); i++) {\n                        if (((!inv != !callback(elems[i], i)))) {\n                            ret.push(elems[i]);\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    return ret;\n                },\n                map: function(elems, callback) {\n                    var ret = [];\n                    for (var i = 0, length = elems.length; ((i < length)); i++) {\n                        var value = callback(elems[i], i);\n                        if (((value != null))) {\n                            ret[ret.length] = value;\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    return ret.concat.apply([], ret);\n                }\n            });\n            var userAgent = JSBNG__navigator.userAgent.toLowerCase();\n            jQuery.browser = {\n                version: ((userAgent.match(/.+(?:rv|it|ra|ie)[\\/: ]([\\d.]+)/) || []))[1],\n                safari: /webkit/.test(userAgent),\n                JSBNG__opera: /opera/.test(userAgent),\n                msie: ((/msie/.test(userAgent) && !/opera/.test(userAgent))),\n                mozilla: ((/mozilla/.test(userAgent) && !/(compatible|webkit)/.test(userAgent)))\n            };\n            var styleFloat = ((jQuery.browser.msie ? \"styleFloat\" : \"cssFloat\"));\n            jQuery.extend({\n                boxModel: ((!jQuery.browser.msie || ((JSBNG__document.compatMode == \"CSS1Compat\")))),\n                props: {\n                    \"for\": \"htmlFor\",\n                    class: \"className\",\n                    float: styleFloat,\n                    cssFloat: styleFloat,\n                    styleFloat: styleFloat,\n                    readonly: \"readOnly\",\n                    maxlength: \"maxLength\",\n                    cellspacing: \"cellSpacing\"\n                }\n            });\n            jQuery.each({\n                parent: function(elem) {\n                    return elem.parentNode;\n                },\n                parents: function(elem) {\n                    return jQuery.dir(elem, \"parentNode\");\n                },\n                next: function(elem) {\n                    return jQuery.nth(elem, 2, \"nextSibling\");\n                },\n                prev: function(elem) {\n                    return jQuery.nth(elem, 2, \"previousSibling\");\n                },\n                nextAll: function(elem) {\n                    return jQuery.dir(elem, \"nextSibling\");\n                },\n                prevAll: function(elem) {\n                    return jQuery.dir(elem, \"previousSibling\");\n                },\n                siblings: function(elem) {\n                    return jQuery.sibling(elem.parentNode.firstChild, elem);\n                },\n                children: function(elem) {\n                    return jQuery.sibling(elem.firstChild);\n                },\n                contents: function(elem) {\n                    return ((jQuery.nodeName(elem, \"div\") ? ((elem.contentDocument || elem.contentWindow.JSBNG__document)) : jQuery.makeArray(elem.childNodes)));\n                }\n            }, function(JSBNG__name, fn) {\n                jQuery.fn[JSBNG__name] = function(selector) {\n                    var ret = jQuery.map(this, fn);\n                    if (((selector && ((typeof selector == \"string\"))))) {\n                        ret = jQuery.multiFilter(selector, ret);\n                    }\n                ;\n                ;\n                    return this.pushStack(jQuery.unique(ret));\n                };\n            });\n            jQuery.each({\n                appendTo: \"append\",\n                prependTo: \"prepend\",\n                insertBefore: \"before\",\n                insertAfter: \"after\",\n                replaceAll: \"replaceWith\"\n            }, function(JSBNG__name, original) {\n                jQuery.fn[JSBNG__name] = function() {\n                    var args = arguments;\n                    return this.each(function() {\n                        for (var i = 0, length = args.length; ((i < length)); i++) {\n                            jQuery(args[i])[original](this);\n                        };\n                    ;\n                    });\n                };\n            });\n            jQuery.each({\n                removeAttr: function(JSBNG__name) {\n                    jQuery.attr(this, JSBNG__name, \"\");\n                    if (((this.nodeType == 1))) {\n                        this.removeAttribute(JSBNG__name);\n                    }\n                ;\n                ;\n                },\n                addClass: function(classNames) {\n                    jQuery.className.add(this, classNames);\n                },\n                removeClass: function(classNames) {\n                    jQuery.className.remove(this, classNames);\n                },\n                toggleClass: function(classNames) {\n                    jQuery.className[((jQuery.className.has(this, classNames) ? \"remove\" : \"add\"))](this, classNames);\n                },\n                remove: function(selector) {\n                    if (((!selector || jQuery.filter(selector, [this,]).r.length))) {\n                        jQuery(\"*\", this).add(this).each(function() {\n                            jQuery.JSBNG__event.remove(this);\n                            jQuery.removeData(this);\n                        });\n                        if (this.parentNode) {\n                            this.parentNode.removeChild(this);\n                        }\n                    ;\n                    ;\n                    }\n                ;\n                ;\n                },\n                empty: function() {\n                    jQuery(\"\\u003E*\", this).remove();\n                    while (this.firstChild) {\n                        this.removeChild(this.firstChild);\n                    };\n                ;\n                }\n            }, function(JSBNG__name, fn) {\n                jQuery.fn[JSBNG__name] = function() {\n                    return this.each(fn, arguments);\n                };\n            });\n            jQuery.each([\"Height\",\"Width\",], function(i, JSBNG__name) {\n                var type = JSBNG__name.toLowerCase();\n                jQuery.fn[type] = function(size) {\n                    return ((((this[0] == window)) ? ((((((((jQuery.browser.JSBNG__opera && JSBNG__document.body[((\"client\" + JSBNG__name))])) || ((jQuery.browser.safari && window[((\"JSBNG__inner\" + JSBNG__name))])))) || ((((JSBNG__document.compatMode == \"CSS1Compat\")) && JSBNG__document.documentElement[((\"client\" + JSBNG__name))])))) || JSBNG__document.body[((\"client\" + JSBNG__name))])) : ((((this[0] == JSBNG__document)) ? Math.max(Math.max(JSBNG__document.body[((\"JSBNG__scroll\" + JSBNG__name))], JSBNG__document.documentElement[((\"JSBNG__scroll\" + JSBNG__name))]), Math.max(JSBNG__document.body[((\"offset\" + JSBNG__name))], JSBNG__document.documentElement[((\"offset\" + JSBNG__name))])) : ((((size == undefined)) ? ((this.length ? jQuery.css(this[0], type) : null)) : this.css(type, ((((size.constructor == String)) ? size : ((size + \"px\")))))))))));\n                };\n            });\n            function num(elem, prop) {\n                return ((((elem[0] && parseInt(jQuery.curCSS(elem[0], prop, true), 10))) || 0));\n            };\n        ;\n            var chars = ((((jQuery.browser.safari && ((parseInt(jQuery.browser.version) < 417)))) ? \"(?:[\\\\w*_-]|\\\\\\\\.)\" : \"(?:[\\\\w\\u0128-\\uffff*_-]|\\\\\\\\.)\")), quickChild = new RegExp(((((\"^\\u003E\\\\s*(\" + chars)) + \"+)\"))), quickID = new RegExp(((((((((\"^(\" + chars)) + \"+)(#)(\")) + chars)) + \"+)\"))), quickClass = new RegExp(((((\"^([#.]?)(\" + chars)) + \"*)\")));\n            jQuery.extend({\n                expr: {\n                    \"\": function(a, i, m) {\n                        return ((((m[2] == \"*\")) || jQuery.nodeName(a, m[2])));\n                    },\n                    \"#\": function(a, i, m) {\n                        return ((a.getAttribute(\"id\") == m[2]));\n                    },\n                    \":\": {\n                        lt: function(a, i, m) {\n                            return ((i < ((m[3] - 0))));\n                        },\n                        gt: function(a, i, m) {\n                            return ((i > ((m[3] - 0))));\n                        },\n                        nth: function(a, i, m) {\n                            return ((((m[3] - 0)) == i));\n                        },\n                        eq: function(a, i, m) {\n                            return ((((m[3] - 0)) == i));\n                        },\n                        first: function(a, i) {\n                            return ((i == 0));\n                        },\n                        last: function(a, i, m, r) {\n                            return ((i == ((r.length - 1))));\n                        },\n                        even: function(a, i) {\n                            return ((((i % 2)) == 0));\n                        },\n                        odd: function(a, i) {\n                            return ((i % 2));\n                        },\n                        \"first-child\": function(a) {\n                            return ((a.parentNode.getElementsByTagName(\"*\")[0] == a));\n                        },\n                        \"last-child\": function(a) {\n                            return ((jQuery.nth(a.parentNode.lastChild, 1, \"previousSibling\") == a));\n                        },\n                        \"only-child\": function(a) {\n                            return !jQuery.nth(a.parentNode.lastChild, 2, \"previousSibling\");\n                        },\n                        parent: function(a) {\n                            return a.firstChild;\n                        },\n                        empty: function(a) {\n                            return !a.firstChild;\n                        },\n                        contains: function(a, i, m) {\n                            return ((((((((a.textContent || a.innerText)) || jQuery(a).text())) || \"\")).indexOf(m[3]) >= 0));\n                        },\n                        visible: function(a) {\n                            return ((((((\"hidden\" != a.type)) && ((jQuery.css(a, \"display\") != \"none\")))) && ((jQuery.css(a, \"visibility\") != \"hidden\"))));\n                        },\n                        hidden: function(a) {\n                            return ((((((\"hidden\" == a.type)) || ((jQuery.css(a, \"display\") == \"none\")))) || ((jQuery.css(a, \"visibility\") == \"hidden\"))));\n                        },\n                        enabled: function(a) {\n                            return !a.disabled;\n                        },\n                        disabled: function(a) {\n                            return a.disabled;\n                        },\n                        checked: function(a) {\n                            return a.checked;\n                        },\n                        selected: function(a) {\n                            return ((a.selected || jQuery.attr(a, \"selected\")));\n                        },\n                        text: function(a) {\n                            return ((\"text\" == a.type));\n                        },\n                        radio: function(a) {\n                            return ((\"radio\" == a.type));\n                        },\n                        checkbox: function(a) {\n                            return ((\"checkbox\" == a.type));\n                        },\n                        file: function(a) {\n                            return ((\"file\" == a.type));\n                        },\n                        password: function(a) {\n                            return ((\"password\" == a.type));\n                        },\n                        submit: function(a) {\n                            return ((\"submit\" == a.type));\n                        },\n                        image: function(a) {\n                            return ((\"image\" == a.type));\n                        },\n                        reset: function(a) {\n                            return ((\"reset\" == a.type));\n                        },\n                        button: function(a) {\n                            return ((((\"button\" == a.type)) || jQuery.nodeName(a, \"button\")));\n                        },\n                        input: function(a) {\n                            return /input|select|textarea|button/i.test(a.nodeName);\n                        },\n                        has: function(a, i, m) {\n                            return jQuery.JSBNG__find(m[3], a).length;\n                        },\n                        header: function(a) {\n                            return /h\\d/i.test(a.nodeName);\n                        },\n                        animated: function(a) {\n                            return jQuery.grep(jQuery.timers, function(fn) {\n                                return ((a == fn.elem));\n                            }).length;\n                        }\n                    }\n                },\n                parse: [/^(\\[) *@?([\\w-]+) *([!*$^~=]*) *('?\"?)(.*?)\\4 *\\]/,/^(:)([\\w-]+)\\(\"?'?(.*?(\\(.*?\\))?[^(]*?)\"?'?\\)/,new RegExp(((((\"^([:.#]*)(\" + chars)) + \"+)\"))),],\n                multiFilter: function(expr, elems, not) {\n                    var old, cur = [];\n                    while (((expr && ((expr != old))))) {\n                        old = expr;\n                        var f = jQuery.filter(expr, elems, not);\n                        expr = f.t.replace(/^\\s*,\\s*/, \"\");\n                        cur = ((not ? elems = f.r : jQuery.merge(cur, f.r)));\n                    };\n                ;\n                    return cur;\n                },\n                JSBNG__find: function(t, context) {\n                    if (((typeof t != \"string\"))) {\n                        return [t,];\n                    }\n                ;\n                ;\n                    if (((((context && ((context.nodeType != 1)))) && ((context.nodeType != 9))))) {\n                        return [];\n                    }\n                ;\n                ;\n                    context = ((context || JSBNG__document));\n                    var ret = [context,], done = [], last, nodeName;\n                    while (((t && ((last != t))))) {\n                        var r = [];\n                        last = t;\n                        t = jQuery.trim(t);\n                        var foundToken = false, re = quickChild, m = re.exec(t);\n                        if (m) {\n                            nodeName = m[1].toUpperCase();\n                            for (var i = 0; ret[i]; i++) {\n                                for (var c = ret[i].firstChild; c; c = c.nextSibling) {\n                                    if (((((c.nodeType == 1)) && ((((nodeName == \"*\")) || ((c.nodeName.toUpperCase() == nodeName))))))) {\n                                        r.push(c);\n                                    }\n                                ;\n                                ;\n                                };\n                            ;\n                            };\n                        ;\n                            ret = r;\n                            t = t.replace(re, \"\");\n                            if (((t.indexOf(\" \") == 0))) {\n                                continue;\n                            }\n                        ;\n                        ;\n                            foundToken = true;\n                        }\n                         else {\n                            re = /^([>+~])\\s*(\\w*)/i;\n                            if ((((m = re.exec(t)) != null))) {\n                                r = [];\n                                var merge = {\n                                };\n                                nodeName = m[2].toUpperCase();\n                                m = m[1];\n                                for (var j = 0, rl = ret.length; ((j < rl)); j++) {\n                                    var n = ((((((m == \"~\")) || ((m == \"+\")))) ? ret[j].nextSibling : ret[j].firstChild));\n                                    for (; n; n = n.nextSibling) {\n                                        if (((n.nodeType == 1))) {\n                                            var id = jQuery.data(n);\n                                            if (((((m == \"~\")) && merge[id]))) {\n                                                break;\n                                            }\n                                        ;\n                                        ;\n                                            if (((!nodeName || ((n.nodeName.toUpperCase() == nodeName))))) {\n                                                if (((m == \"~\"))) {\n                                                    merge[id] = true;\n                                                }\n                                            ;\n                                            ;\n                                                r.push(n);\n                                            }\n                                        ;\n                                        ;\n                                            if (((m == \"+\"))) {\n                                                break;\n                                            }\n                                        ;\n                                        ;\n                                        }\n                                    ;\n                                    ;\n                                    };\n                                ;\n                                };\n                            ;\n                                ret = r;\n                                t = jQuery.trim(t.replace(re, \"\"));\n                                foundToken = true;\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                        if (((t && !foundToken))) {\n                            if (!t.indexOf(\",\")) {\n                                if (((context == ret[0]))) {\n                                    ret.shift();\n                                }\n                            ;\n                            ;\n                                done = jQuery.merge(done, ret);\n                                r = ret = [context,];\n                                t = ((\" \" + t.substr(1, t.length)));\n                            }\n                             else {\n                                var re2 = quickID;\n                                var m = re2.exec(t);\n                                if (m) {\n                                    m = [0,m[2],m[3],m[1],];\n                                }\n                                 else {\n                                    re2 = quickClass;\n                                    m = re2.exec(t);\n                                }\n                            ;\n                            ;\n                                m[2] = m[2].replace(/\\\\/g, \"\");\n                                var elem = ret[((ret.length - 1))];\n                                if (((((((((m[1] == \"#\")) && elem)) && elem.getElementById)) && !jQuery.isXMLDoc(elem)))) {\n                                    var oid = elem.getElementById(m[2]);\n                                    if (((((((((jQuery.browser.msie || jQuery.browser.JSBNG__opera)) && oid)) && ((typeof oid.id == \"string\")))) && ((oid.id != m[2]))))) {\n                                        oid = jQuery(((((\"[@id=\\\"\" + m[2])) + \"\\\"]\")), elem)[0];\n                                    }\n                                ;\n                                ;\n                                    ret = r = ((((oid && ((!m[3] || jQuery.nodeName(oid, m[3]))))) ? [oid,] : []));\n                                }\n                                 else {\n                                    for (var i = 0; ret[i]; i++) {\n                                        var tag = ((((((m[1] == \"#\")) && m[3])) ? m[3] : ((((((m[1] != \"\")) || ((m[0] == \"\")))) ? \"*\" : m[2]))));\n                                        if (((((tag == \"*\")) && ((ret[i].nodeName.toLowerCase() == \"object\"))))) {\n                                            tag = \"param\";\n                                        }\n                                    ;\n                                    ;\n                                        r = jQuery.merge(r, ret[i].getElementsByTagName(tag));\n                                    };\n                                ;\n                                    if (((m[1] == \".\"))) {\n                                        r = jQuery.classFilter(r, m[2]);\n                                    }\n                                ;\n                                ;\n                                    if (((m[1] == \"#\"))) {\n                                        var tmp = [];\n                                        for (var i = 0; r[i]; i++) {\n                                            if (((r[i].getAttribute(\"id\") == m[2]))) {\n                                                tmp = [r[i],];\n                                                break;\n                                            }\n                                        ;\n                                        ;\n                                        };\n                                    ;\n                                        r = tmp;\n                                    }\n                                ;\n                                ;\n                                    ret = r;\n                                }\n                            ;\n                            ;\n                                t = t.replace(re2, \"\");\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                        if (t) {\n                            var val = jQuery.filter(t, r);\n                            ret = r = val.r;\n                            t = jQuery.trim(val.t);\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    if (t) {\n                        ret = [];\n                    }\n                ;\n                ;\n                    if (((ret && ((context == ret[0]))))) {\n                        ret.shift();\n                    }\n                ;\n                ;\n                    done = jQuery.merge(done, ret);\n                    return done;\n                },\n                classFilter: function(r, m, not) {\n                    m = ((((\" \" + m)) + \" \"));\n                    var tmp = [];\n                    for (var i = 0; r[i]; i++) {\n                        var pass = ((((((\" \" + r[i].className)) + \" \")).indexOf(m) >= 0));\n                        if (((((!not && pass)) || ((not && !pass))))) {\n                            tmp.push(r[i]);\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    return tmp;\n                },\n                filter: function(t, r, not) {\n                    var last;\n                    while (((t && ((t != last))))) {\n                        last = t;\n                        var p = jQuery.parse, m;\n                        for (var i = 0; p[i]; i++) {\n                            m = p[i].exec(t);\n                            if (m) {\n                                t = t.substring(m[0].length);\n                                m[2] = m[2].replace(/\\\\/g, \"\");\n                                break;\n                            }\n                        ;\n                        ;\n                        };\n                    ;\n                        if (!m) {\n                            break;\n                        }\n                    ;\n                    ;\n                        if (((((m[1] == \":\")) && ((m[2] == \"not\"))))) {\n                            r = ((isSimple.test(m[3]) ? jQuery.filter(m[3], r, true).r : jQuery(r).not(m[3])));\n                        }\n                         else {\n                            if (((m[1] == \".\"))) {\n                                r = jQuery.classFilter(r, m[2], not);\n                            }\n                             else {\n                                if (((m[1] == \"[\"))) {\n                                    var tmp = [], type = m[3];\n                                    for (var i = 0, rl = r.length; ((i < rl)); i++) {\n                                        var a = r[i], z = a[((jQuery.props[m[2]] || m[2]))];\n                                        if (((((z == null)) || /href|src|selected/.test(m[2])))) {\n                                            z = ((jQuery.attr(a, m[2]) || \"\"));\n                                        }\n                                    ;\n                                    ;\n                                        if (((((((((((((((((type == \"\")) && !!z)) || ((((type == \"=\")) && ((z == m[5])))))) || ((((type == \"!=\")) && ((z != m[5])))))) || ((((((type == \"^=\")) && z)) && !z.indexOf(m[5]))))) || ((((type == \"$=\")) && ((z.substr(((z.length - m[5].length))) == m[5])))))) || ((((((type == \"*=\")) || ((type == \"~=\")))) && ((z.indexOf(m[5]) >= 0)))))) ^ not))) {\n                                            tmp.push(a);\n                                        }\n                                    ;\n                                    ;\n                                    };\n                                ;\n                                    r = tmp;\n                                }\n                                 else {\n                                    if (((((m[1] == \":\")) && ((m[2] == \"nth-child\"))))) {\n                                        var merge = {\n                                        }, tmp = [], test = /(-?)(\\d*)n((?:\\+|-)?\\d*)/.exec(((((((((((m[3] == \"even\")) && \"2n\")) || ((((m[3] == \"odd\")) && \"2n+1\")))) || ((!/\\D/.test(m[3]) && ((\"0n+\" + m[3])))))) || m[3]))), first = ((((test[1] + ((test[2] || 1)))) - 0)), last = ((test[3] - 0));\n                                        for (var i = 0, rl = r.length; ((i < rl)); i++) {\n                                            var node = r[i], parentNode = node.parentNode, id = jQuery.data(parentNode);\n                                            if (!merge[id]) {\n                                                var c = 1;\n                                                for (var n = parentNode.firstChild; n; n = n.nextSibling) {\n                                                    if (((n.nodeType == 1))) {\n                                                        n.nodeIndex = c++;\n                                                    }\n                                                ;\n                                                ;\n                                                };\n                                            ;\n                                                merge[id] = true;\n                                            }\n                                        ;\n                                        ;\n                                            var add = false;\n                                            if (((first == 0))) {\n                                                if (((node.nodeIndex == last))) {\n                                                    add = true;\n                                                }\n                                            ;\n                                            ;\n                                            }\n                                             else {\n                                                if (((((((((node.nodeIndex - last)) % first)) == 0)) && ((((((node.nodeIndex - last)) / first)) >= 0))))) {\n                                                    add = true;\n                                                }\n                                            ;\n                                            ;\n                                            }\n                                        ;\n                                        ;\n                                            if (((add ^ not))) {\n                                                tmp.push(node);\n                                            }\n                                        ;\n                                        ;\n                                        };\n                                    ;\n                                        r = tmp;\n                                    }\n                                     else {\n                                        var fn = jQuery.expr[m[1]];\n                                        if (((typeof fn == \"object\"))) {\n                                            fn = fn[m[2]];\n                                        }\n                                    ;\n                                    ;\n                                        if (((typeof fn == \"string\"))) {\n                                            fn = eval(((((\"false||function(a,i){return \" + fn)) + \";}\")));\n                                        }\n                                    ;\n                                    ;\n                                        r = jQuery.grep(r, function(elem, i) {\n                                            return fn(elem, i, m, r);\n                                        }, not);\n                                    }\n                                ;\n                                ;\n                                }\n                            ;\n                            ;\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    return {\n                        r: r,\n                        t: t\n                    };\n                },\n                dir: function(elem, dir) {\n                    var matched = [], cur = elem[dir];\n                    while (((cur && ((cur != JSBNG__document))))) {\n                        if (((cur.nodeType == 1))) {\n                            matched.push(cur);\n                        }\n                    ;\n                    ;\n                        cur = cur[dir];\n                    };\n                ;\n                    return matched;\n                },\n                nth: function(cur, result, dir, elem) {\n                    result = ((result || 1));\n                    var num = 0;\n                    for (; cur; cur = cur[dir]) {\n                        if (((((cur.nodeType == 1)) && ((++num == result))))) {\n                            break;\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    return cur;\n                },\n                sibling: function(n, elem) {\n                    var r = [];\n                    for (; n; n = n.nextSibling) {\n                        if (((((n.nodeType == 1)) && ((n != elem))))) {\n                            r.push(n);\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    return r;\n                }\n            });\n            jQuery.JSBNG__event = {\n                add: function(elem, types, handler, data) {\n                    if (((((elem.nodeType == 3)) || ((elem.nodeType == 8))))) {\n                        return;\n                    }\n                ;\n                ;\n                    if (((jQuery.browser.msie && elem.JSBNG__setInterval))) {\n                        elem = window;\n                    }\n                ;\n                ;\n                    if (!handler.guid) {\n                        handler.guid = this.guid++;\n                    }\n                ;\n                ;\n                    if (((data != undefined))) {\n                        var fn = handler;\n                        handler = this.proxy(fn, function() {\n                            return fn.apply(this, arguments);\n                        });\n                        handler.data = data;\n                    }\n                ;\n                ;\n                    var events = ((jQuery.data(elem, \"events\") || jQuery.data(elem, \"events\", {\n                    }))), handle = ((jQuery.data(elem, \"handle\") || jQuery.data(elem, \"handle\", function() {\n                        if (((((typeof jQuery != \"undefined\")) && !jQuery.JSBNG__event.triggered))) {\n                            return jQuery.JSBNG__event.handle.apply(arguments.callee.elem, arguments);\n                        }\n                    ;\n                    ;\n                    })));\n                    handle.elem = elem;\n                    jQuery.each(types.split(/\\s+/), function(index, type) {\n                        var parts = type.split(\".\");\n                        type = parts[0];\n                        handler.type = parts[1];\n                        var handlers = events[type];\n                        if (!handlers) {\n                            handlers = events[type] = {\n                            };\n                            if (((!jQuery.JSBNG__event.special[type] || ((jQuery.JSBNG__event.special[type].setup.call(elem) === false))))) {\n                                if (elem.JSBNG__addEventListener) {\n                                    elem.JSBNG__addEventListener(type, handle, false);\n                                }\n                                 else {\n                                    if (elem.JSBNG__attachEvent) {\n                                        elem.JSBNG__attachEvent(((\"JSBNG__on\" + type)), handle);\n                                    }\n                                ;\n                                ;\n                                }\n                            ;\n                            ;\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                        handlers[handler.guid] = handler;\n                        jQuery.JSBNG__event.global[type] = true;\n                    });\n                    elem = null;\n                },\n                guid: 1,\n                global: {\n                },\n                remove: function(elem, types, handler) {\n                    if (((((elem.nodeType == 3)) || ((elem.nodeType == 8))))) {\n                        return;\n                    }\n                ;\n                ;\n                    var events = jQuery.data(elem, \"events\"), ret, index;\n                    if (events) {\n                        if (((((types == undefined)) || ((((typeof types == \"string\")) && ((types.charAt(0) == \".\"))))))) {\n                            {\n                                var fin17keys = ((window.top.JSBNG_Replay.forInKeys)((events))), fin17i = (0);\n                                var type;\n                                for (; (fin17i < fin17keys.length); (fin17i++)) {\n                                    ((type) = (fin17keys[fin17i]));\n                                    {\n                                        this.remove(elem, ((type + ((types || \"\")))));\n                                    };\n                                };\n                            };\n                        ;\n                        }\n                         else {\n                            if (types.type) {\n                                handler = types.handler;\n                                types = types.type;\n                            }\n                        ;\n                        ;\n                            jQuery.each(types.split(/\\s+/), function(index, type) {\n                                var parts = type.split(\".\");\n                                type = parts[0];\n                                if (events[type]) {\n                                    if (handler) {\n                                        delete events[type][handler.guid];\n                                    }\n                                     else {\n                                        {\n                                            var fin18keys = ((window.top.JSBNG_Replay.forInKeys)((events[type]))), fin18i = (0);\n                                            (0);\n                                            for (; (fin18i < fin18keys.length); (fin18i++)) {\n                                                ((handler) = (fin18keys[fin18i]));\n                                                {\n                                                    if (((!parts[1] || ((events[type][handler].type == parts[1]))))) {\n                                                        delete events[type][handler];\n                                                    }\n                                                ;\n                                                ;\n                                                };\n                                            };\n                                        };\n                                    ;\n                                    }\n                                ;\n                                ;\n                                    {\n                                        var fin19keys = ((window.top.JSBNG_Replay.forInKeys)((events[type]))), fin19i = (0);\n                                        (0);\n                                        for (; (fin19i < fin19keys.length); (fin19i++)) {\n                                            ((ret) = (fin19keys[fin19i]));\n                                            {\n                                                break;\n                                            };\n                                        };\n                                    };\n                                ;\n                                    if (!ret) {\n                                        if (((!jQuery.JSBNG__event.special[type] || ((jQuery.JSBNG__event.special[type].teardown.call(elem) === false))))) {\n                                            if (elem.JSBNG__removeEventListener) {\n                                                elem.JSBNG__removeEventListener(type, jQuery.data(elem, \"handle\"), false);\n                                            }\n                                             else {\n                                                if (elem.JSBNG__detachEvent) {\n                                                    elem.JSBNG__detachEvent(((\"JSBNG__on\" + type)), jQuery.data(elem, \"handle\"));\n                                                }\n                                            ;\n                                            ;\n                                            }\n                                        ;\n                                        ;\n                                        }\n                                    ;\n                                    ;\n                                        ret = null;\n                                        delete events[type];\n                                    }\n                                ;\n                                ;\n                                }\n                            ;\n                            ;\n                            });\n                        }\n                    ;\n                    ;\n                        {\n                            var fin20keys = ((window.top.JSBNG_Replay.forInKeys)((events))), fin20i = (0);\n                            (0);\n                            for (; (fin20i < fin20keys.length); (fin20i++)) {\n                                ((ret) = (fin20keys[fin20i]));\n                                {\n                                    break;\n                                };\n                            };\n                        };\n                    ;\n                        if (!ret) {\n                            var handle = jQuery.data(elem, \"handle\");\n                            if (handle) {\n                                handle.elem = null;\n                            }\n                        ;\n                        ;\n                            jQuery.removeData(elem, \"events\");\n                            jQuery.removeData(elem, \"handle\");\n                        }\n                    ;\n                    ;\n                    }\n                ;\n                ;\n                },\n                trigger: function(type, data, elem, donative, extra) {\n                    data = jQuery.makeArray(data);\n                    if (((type.indexOf(\"!\") >= 0))) {\n                        type = type.slice(0, -1);\n                        var exclusive = true;\n                    }\n                ;\n                ;\n                    if (!elem) {\n                        if (this.global[type]) {\n                            jQuery(\"*\").add([window,JSBNG__document,]).trigger(type, data);\n                        }\n                    ;\n                    ;\n                    }\n                     else {\n                        if (((((elem.nodeType == 3)) || ((elem.nodeType == 8))))) {\n                            return undefined;\n                        }\n                    ;\n                    ;\n                        var val, ret, fn = jQuery.isFunction(((elem[type] || null))), JSBNG__event = ((!data[0] || !data[0].preventDefault));\n                        if (JSBNG__event) {\n                            data.unshift({\n                                type: type,\n                                target: elem,\n                                preventDefault: function() {\n                                \n                                },\n                                stopPropagation: function() {\n                                \n                                },\n                                timeStamp: now()\n                            });\n                            data[0][expando] = true;\n                        }\n                    ;\n                    ;\n                        data[0].type = type;\n                        if (exclusive) {\n                            data[0].exclusive = true;\n                        }\n                    ;\n                    ;\n                        var handle = jQuery.data(elem, \"handle\");\n                        if (handle) {\n                            val = handle.apply(elem, data);\n                        }\n                    ;\n                    ;\n                        if (((((((!fn || ((jQuery.nodeName(elem, \"a\") && ((type == \"click\")))))) && elem[((\"JSBNG__on\" + type))])) && ((elem[((\"JSBNG__on\" + type))].apply(elem, data) === false))))) {\n                            val = false;\n                        }\n                    ;\n                    ;\n                        if (JSBNG__event) {\n                            data.shift();\n                        }\n                    ;\n                    ;\n                        if (((extra && jQuery.isFunction(extra)))) {\n                            ret = extra.apply(elem, ((((val == null)) ? data : data.concat(val))));\n                            if (((ret !== undefined))) {\n                                val = ret;\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                        if (((((((fn && ((donative !== false)))) && ((val !== false)))) && !((jQuery.nodeName(elem, \"a\") && ((type == \"click\"))))))) {\n                            this.triggered = true;\n                            try {\n                                elem[type]();\n                            } catch (e) {\n                            \n                            };\n                        ;\n                        }\n                    ;\n                    ;\n                        this.triggered = false;\n                    }\n                ;\n                ;\n                    return val;\n                },\n                handle: function(JSBNG__event) {\n                    var val, ret, namespace, all, handlers;\n                    JSBNG__event = arguments[0] = jQuery.JSBNG__event.fix(((JSBNG__event || window.JSBNG__event)));\n                    namespace = JSBNG__event.type.split(\".\");\n                    JSBNG__event.type = namespace[0];\n                    namespace = namespace[1];\n                    all = ((!namespace && !JSBNG__event.exclusive));\n                    handlers = ((jQuery.data(this, \"events\") || {\n                    }))[JSBNG__event.type];\n                    {\n                        var fin21keys = ((window.top.JSBNG_Replay.forInKeys)((handlers))), fin21i = (0);\n                        var j;\n                        for (; (fin21i < fin21keys.length); (fin21i++)) {\n                            ((j) = (fin21keys[fin21i]));\n                            {\n                                var handler = handlers[j];\n                                if (((all || ((handler.type == namespace))))) {\n                                    JSBNG__event.handler = handler;\n                                    JSBNG__event.data = handler.data;\n                                    ret = handler.apply(this, arguments);\n                                    if (((val !== false))) {\n                                        val = ret;\n                                    }\n                                ;\n                                ;\n                                    if (((ret === false))) {\n                                        JSBNG__event.preventDefault();\n                                        JSBNG__event.stopPropagation();\n                                    }\n                                ;\n                                ;\n                                }\n                            ;\n                            ;\n                            };\n                        };\n                    };\n                ;\n                    return val;\n                },\n                fix: function(JSBNG__event) {\n                    if (((JSBNG__event[expando] == true))) {\n                        return JSBNG__event;\n                    }\n                ;\n                ;\n                    var originalEvent = JSBNG__event;\n                    JSBNG__event = {\n                        originalEvent: originalEvent\n                    };\n                    var props = \"altKey attrChange attrName bubbles button cancelable charCode clientX clientY ctrlKey currentTarget data detail eventPhase fromElement handler keyCode metaKey newValue originalTarget pageX pageY prevValue relatedNode relatedTarget screenX screenY shiftKey srcElement target timeStamp toElement type view wheelDelta which\".split(\" \");\n                    for (var i = props.length; i; i--) {\n                        JSBNG__event[props[i]] = originalEvent[props[i]];\n                    };\n                ;\n                    JSBNG__event[expando] = true;\n                    JSBNG__event.preventDefault = function() {\n                        if (originalEvent.preventDefault) {\n                            originalEvent.preventDefault();\n                        }\n                    ;\n                    ;\n                        originalEvent.returnValue = false;\n                    };\n                    JSBNG__event.stopPropagation = function() {\n                        if (originalEvent.stopPropagation) {\n                            originalEvent.stopPropagation();\n                        }\n                    ;\n                    ;\n                        originalEvent.cancelBubble = true;\n                    };\n                    JSBNG__event.timeStamp = ((JSBNG__event.timeStamp || now()));\n                    if (!JSBNG__event.target) {\n                        JSBNG__event.target = ((JSBNG__event.srcElement || JSBNG__document));\n                    }\n                ;\n                ;\n                    if (((JSBNG__event.target.nodeType == 3))) {\n                        JSBNG__event.target = JSBNG__event.target.parentNode;\n                    }\n                ;\n                ;\n                    if (((!JSBNG__event.relatedTarget && JSBNG__event.fromElement))) {\n                        JSBNG__event.relatedTarget = ((((JSBNG__event.fromElement == JSBNG__event.target)) ? JSBNG__event.toElement : JSBNG__event.fromElement));\n                    }\n                ;\n                ;\n                    if (((((JSBNG__event.pageX == null)) && ((JSBNG__event.clientX != null))))) {\n                        var doc = JSBNG__document.documentElement, body = JSBNG__document.body;\n                        JSBNG__event.pageX = ((((JSBNG__event.clientX + ((((((doc && doc.scrollLeft)) || ((body && body.scrollLeft)))) || 0)))) - ((doc.clientLeft || 0))));\n                        JSBNG__event.pageY = ((((JSBNG__event.clientY + ((((((doc && doc.scrollTop)) || ((body && body.scrollTop)))) || 0)))) - ((doc.clientTop || 0))));\n                    }\n                ;\n                ;\n                    if (((!JSBNG__event.which && ((((JSBNG__event.charCode || ((JSBNG__event.charCode === 0)))) ? JSBNG__event.charCode : JSBNG__event.keyCode))))) {\n                        JSBNG__event.which = ((JSBNG__event.charCode || JSBNG__event.keyCode));\n                    }\n                ;\n                ;\n                    if (((!JSBNG__event.metaKey && JSBNG__event.ctrlKey))) {\n                        JSBNG__event.metaKey = JSBNG__event.ctrlKey;\n                    }\n                ;\n                ;\n                    if (((!JSBNG__event.which && JSBNG__event.button))) {\n                        JSBNG__event.which = ((((JSBNG__event.button & 1)) ? 1 : ((((JSBNG__event.button & 2)) ? 3 : ((((JSBNG__event.button & 4)) ? 2 : 0))))));\n                    }\n                ;\n                ;\n                    return JSBNG__event;\n                },\n                proxy: function(fn, proxy) {\n                    proxy.guid = fn.guid = ((((fn.guid || proxy.guid)) || this.guid++));\n                    return proxy;\n                },\n                special: {\n                    ready: {\n                        setup: function() {\n                            bindReady();\n                            return;\n                        },\n                        teardown: function() {\n                            return;\n                        }\n                    },\n                    mouseenter: {\n                        setup: function() {\n                            if (jQuery.browser.msie) {\n                                return false;\n                            }\n                        ;\n                        ;\n                            jQuery(this).bind(\"mouseover\", jQuery.JSBNG__event.special.mouseenter.handler);\n                            return true;\n                        },\n                        teardown: function() {\n                            if (jQuery.browser.msie) {\n                                return false;\n                            }\n                        ;\n                        ;\n                            jQuery(this).unbind(\"mouseover\", jQuery.JSBNG__event.special.mouseenter.handler);\n                            return true;\n                        },\n                        handler: function(JSBNG__event) {\n                            if (withinElement(JSBNG__event, this)) {\n                                return true;\n                            }\n                        ;\n                        ;\n                            JSBNG__event.type = \"mouseenter\";\n                            return jQuery.JSBNG__event.handle.apply(this, arguments);\n                        }\n                    },\n                    mouseleave: {\n                        setup: function() {\n                            if (jQuery.browser.msie) {\n                                return false;\n                            }\n                        ;\n                        ;\n                            jQuery(this).bind(\"mouseout\", jQuery.JSBNG__event.special.mouseleave.handler);\n                            return true;\n                        },\n                        teardown: function() {\n                            if (jQuery.browser.msie) {\n                                return false;\n                            }\n                        ;\n                        ;\n                            jQuery(this).unbind(\"mouseout\", jQuery.JSBNG__event.special.mouseleave.handler);\n                            return true;\n                        },\n                        handler: function(JSBNG__event) {\n                            if (withinElement(JSBNG__event, this)) {\n                                return true;\n                            }\n                        ;\n                        ;\n                            JSBNG__event.type = \"mouseleave\";\n                            return jQuery.JSBNG__event.handle.apply(this, arguments);\n                        }\n                    }\n                }\n            };\n            jQuery.fn.extend({\n                bind: function(type, data, fn) {\n                    return ((((type == \"unload\")) ? this.one(type, data, fn) : this.each(function() {\n                        jQuery.JSBNG__event.add(this, type, ((fn || data)), ((fn && data)));\n                    })));\n                },\n                one: function(type, data, fn) {\n                    var one = jQuery.JSBNG__event.proxy(((fn || data)), function(JSBNG__event) {\n                        jQuery(this).unbind(JSBNG__event, one);\n                        return ((fn || data)).apply(this, arguments);\n                    });\n                    return this.each(function() {\n                        jQuery.JSBNG__event.add(this, type, one, ((fn && data)));\n                    });\n                },\n                unbind: function(type, fn) {\n                    return this.each(function() {\n                        jQuery.JSBNG__event.remove(this, type, fn);\n                    });\n                },\n                trigger: function(type, data, fn) {\n                    return this.each(function() {\n                        jQuery.JSBNG__event.trigger(type, data, this, true, fn);\n                    });\n                },\n                triggerHandler: function(type, data, fn) {\n                    return ((this[0] && jQuery.JSBNG__event.trigger(type, data, this[0], false, fn)));\n                },\n                toggle: function(fn) {\n                    var args = arguments, i = 1;\n                    while (((i < args.length))) {\n                        jQuery.JSBNG__event.proxy(fn, args[i++]);\n                    };\n                ;\n                    return this.click(jQuery.JSBNG__event.proxy(fn, function(JSBNG__event) {\n                        this.lastToggle = ((((this.lastToggle || 0)) % i));\n                        JSBNG__event.preventDefault();\n                        return ((args[this.lastToggle++].apply(this, arguments) || false));\n                    }));\n                },\n                hover: function(fnOver, fnOut) {\n                    return this.bind(\"mouseenter\", fnOver).bind(\"mouseleave\", fnOut);\n                },\n                ready: function(fn) {\n                    bindReady();\n                    if (jQuery.isReady) {\n                        fn.call(JSBNG__document, jQuery);\n                    }\n                     else {\n                        jQuery.readyList.push(function() {\n                            return fn.call(this, jQuery);\n                        });\n                    }\n                ;\n                ;\n                    return this;\n                }\n            });\n            jQuery.extend({\n                isReady: false,\n                readyList: [],\n                ready: function() {\n                    if (!jQuery.isReady) {\n                        jQuery.isReady = true;\n                        if (jQuery.readyList) {\n                            jQuery.each(jQuery.readyList, function() {\n                                this.call(JSBNG__document);\n                            });\n                            jQuery.readyList = null;\n                        }\n                    ;\n                    ;\n                        jQuery(JSBNG__document).triggerHandler(\"ready\");\n                    }\n                ;\n                ;\n                }\n            });\n            var readyBound = false;\n            function bindReady() {\n                if (readyBound) {\n                    return;\n                }\n            ;\n            ;\n                readyBound = true;\n                if (((JSBNG__document.JSBNG__addEventListener && !jQuery.browser.JSBNG__opera))) {\n                    JSBNG__document.JSBNG__addEventListener(\"DOMContentLoaded\", jQuery.ready, false);\n                }\n            ;\n            ;\n                if (((jQuery.browser.msie && ((window == JSBNG__top))))) {\n                    (function() {\n                        if (jQuery.isReady) {\n                            return;\n                        }\n                    ;\n                    ;\n                        try {\n                            JSBNG__document.documentElement.doScroll(\"left\");\n                        } catch (error) {\n                            JSBNG__setTimeout(arguments.callee, jQuery126PatchDelay);\n                            return;\n                        };\n                    ;\n                        jQuery.ready();\n                    })();\n                }\n            ;\n            ;\n                if (jQuery.browser.JSBNG__opera) {\n                    JSBNG__document.JSBNG__addEventListener(\"DOMContentLoaded\", function() {\n                        if (jQuery.isReady) {\n                            return;\n                        }\n                    ;\n                    ;\n                        for (var i = 0; ((i < JSBNG__document.styleSheets.length)); i++) {\n                            if (JSBNG__document.styleSheets[i].disabled) {\n                                JSBNG__setTimeout(arguments.callee, jQuery126PatchDelay);\n                                return;\n                            }\n                        ;\n                        ;\n                        };\n                    ;\n                        jQuery.ready();\n                    }, false);\n                }\n            ;\n            ;\n                if (jQuery.browser.safari) {\n                    var numStyles;\n                    (function() {\n                        if (jQuery.isReady) {\n                            return;\n                        }\n                    ;\n                    ;\n                        if (((((JSBNG__document.readyState != \"loaded\")) && ((JSBNG__document.readyState != \"complete\"))))) {\n                            JSBNG__setTimeout(arguments.callee, jQuery126PatchDelay);\n                            return;\n                        }\n                    ;\n                    ;\n                        if (((numStyles === undefined))) {\n                            numStyles = jQuery(\"style, link[rel=stylesheet]\").length;\n                        }\n                    ;\n                    ;\n                        if (((JSBNG__document.styleSheets.length != numStyles))) {\n                            JSBNG__setTimeout(arguments.callee, jQuery126PatchDelay);\n                            return;\n                        }\n                    ;\n                    ;\n                        jQuery.ready();\n                    })();\n                }\n            ;\n            ;\n                jQuery.JSBNG__event.add(window, \"load\", jQuery.ready);\n            };\n        ;\n            jQuery.each(((((\"blur,focus,load,resize,scroll,unload,click,dblclick,\" + \"mousedown,mouseup,mousemove,mouseover,mouseout,change,select,\")) + \"submit,keydown,keypress,keyup,error\")).split(\",\"), function(i, JSBNG__name) {\n                jQuery.fn[JSBNG__name] = function(fn) {\n                    return ((fn ? this.bind(JSBNG__name, fn) : this.trigger(JSBNG__name)));\n                };\n            });\n            var withinElement = function(JSBNG__event, elem) {\n                var parent = JSBNG__event.relatedTarget;\n                while (((parent && ((parent != elem))))) {\n                    try {\n                        parent = parent.parentNode;\n                    } catch (error) {\n                        parent = elem;\n                    };\n                ;\n                };\n            ;\n                return ((parent == elem));\n            };\n            jQuery(window).bind(\"unload\", function() {\n                jQuery(\"*\").add(JSBNG__document).unbind();\n            });\n            jQuery.fn.extend({\n                _load: jQuery.fn.load,\n                load: function(url, params, callback) {\n                    if (((typeof url != \"string\"))) {\n                        return this._load(url);\n                    }\n                ;\n                ;\n                    var off = url.indexOf(\" \");\n                    if (((off >= 0))) {\n                        var selector = url.slice(off, url.length);\n                        url = url.slice(0, off);\n                    }\n                ;\n                ;\n                    callback = ((callback || function() {\n                    \n                    }));\n                    var type = \"GET\";\n                    if (params) {\n                        if (jQuery.isFunction(params)) {\n                            callback = params;\n                            params = null;\n                        }\n                         else {\n                            params = jQuery.param(params);\n                            type = \"POST\";\n                        }\n                    ;\n                    ;\n                    }\n                ;\n                ;\n                    var JSBNG__self = this;\n                    jQuery.ajax({\n                        url: url,\n                        type: type,\n                        dataType: \"html\",\n                        data: params,\n                        complete: function(res, JSBNG__status) {\n                            if (((((JSBNG__status == \"success\")) || ((JSBNG__status == \"notmodified\"))))) {\n                                JSBNG__self.html(((selector ? jQuery(\"\\u003Cdiv/\\u003E\").append(res.responseText.replace(/<script(.|\\s)*?\\/script>/g, \"\")).JSBNG__find(selector) : res.responseText)));\n                            }\n                        ;\n                        ;\n                            JSBNG__self.each(callback, [res.responseText,JSBNG__status,res,]);\n                        }\n                    });\n                    return this;\n                },\n                serialize: function() {\n                    return jQuery.param(this.serializeArray());\n                },\n                serializeArray: function() {\n                    return this.map(function() {\n                        return ((jQuery.nodeName(this, \"form\") ? jQuery.makeArray(this.elements) : this));\n                    }).filter(function() {\n                        return ((((this.JSBNG__name && !this.disabled)) && ((((this.checked || /select|textarea/i.test(this.nodeName))) || /text|hidden|password/i.test(this.type)))));\n                    }).map(function(i, elem) {\n                        var val = jQuery(this).val();\n                        return ((((val == null)) ? null : ((((val.constructor == Array)) ? jQuery.map(val, function(val, i) {\n                            return {\n                                JSBNG__name: elem.JSBNG__name,\n                                value: val\n                            };\n                        }) : {\n                            JSBNG__name: elem.JSBNG__name,\n                            value: val\n                        }))));\n                    }).get();\n                }\n            });\n            jQuery.each(\"ajaxStart,ajaxStop,ajaxComplete,ajaxError,ajaxSuccess,ajaxSend\".split(\",\"), function(i, o) {\n                jQuery.fn[o] = function(f) {\n                    return this.bind(o, f);\n                };\n            });\n            var jsc = now();\n            jQuery.extend({\n                get: function(url, data, callback, type) {\n                    if (jQuery.isFunction(data)) {\n                        callback = data;\n                        data = null;\n                    }\n                ;\n                ;\n                    return jQuery.ajax({\n                        type: \"GET\",\n                        url: url,\n                        data: data,\n                        success: callback,\n                        dataType: type\n                    });\n                },\n                getScript: function(url, callback) {\n                    return jQuery.get(url, null, callback, \"script\");\n                },\n                getJSON: function(url, data, callback) {\n                    return jQuery.get(url, data, callback, \"json\");\n                },\n                post: function(url, data, callback, type) {\n                    if (jQuery.isFunction(data)) {\n                        callback = data;\n                        data = {\n                        };\n                    }\n                ;\n                ;\n                    return jQuery.ajax({\n                        type: \"POST\",\n                        url: url,\n                        data: data,\n                        success: callback,\n                        dataType: type\n                    });\n                },\n                ajaxSetup: function(settings) {\n                    jQuery.extend(jQuery.ajaxSettings, settings);\n                },\n                ajaxSettings: {\n                    url: JSBNG__location.href,\n                    global: true,\n                    type: \"GET\",\n                    timeout: 0,\n                    contentType: \"application/x-www-form-urlencoded\",\n                    processData: true,\n                    async: true,\n                    data: null,\n                    username: null,\n                    password: null,\n                    accepts: {\n                        xml: \"application/xml, text/xml\",\n                        html: \"text/html\",\n                        script: \"text/javascript, application/javascript\",\n                        json: \"application/json, text/javascript\",\n                        text: \"text/plain\",\n                        _default: \"*/*\"\n                    }\n                },\n                lastModified: {\n                },\n                ajax: function(s) {\n                    s = jQuery.extend(true, s, jQuery.extend(true, {\n                    }, jQuery.ajaxSettings, s));\n                    var jsonp, jsre = /=\\?(&|$)/g, JSBNG__status, data, type = s.type.toUpperCase();\n                    if (((((s.data && s.processData)) && ((typeof s.data != \"string\"))))) {\n                        s.data = jQuery.param(s.data);\n                    }\n                ;\n                ;\n                    if (((s.dataType == \"jsonp\"))) {\n                        if (((type == \"GET\"))) {\n                            if (!s.url.match(jsre)) {\n                                s.url += ((((((s.url.match(/\\?/) ? \"&\" : \"?\")) + ((s.jsonp || \"callback\")))) + \"=?\"));\n                            }\n                        ;\n                        ;\n                        }\n                         else {\n                            if (((!s.data || !s.data.match(jsre)))) {\n                                s.data = ((((((s.data ? ((s.data + \"&\")) : \"\")) + ((s.jsonp || \"callback\")))) + \"=?\"));\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                        s.dataType = \"json\";\n                    }\n                ;\n                ;\n                    if (((((s.dataType == \"json\")) && ((((s.data && s.data.match(jsre))) || s.url.match(jsre)))))) {\n                        jsonp = ((\"jsonp\" + jsc++));\n                        if (s.data) {\n                            s.data = ((s.data + \"\")).replace(jsre, ((((\"=\" + jsonp)) + \"$1\")));\n                        }\n                    ;\n                    ;\n                        s.url = s.url.replace(jsre, ((((\"=\" + jsonp)) + \"$1\")));\n                        s.dataType = \"script\";\n                        window[jsonp] = function(tmp) {\n                            data = tmp;\n                            success();\n                            complete();\n                            window[jsonp] = undefined;\n                            try {\n                                delete window[jsonp];\n                            } catch (e) {\n                            \n                            };\n                        ;\n                            if (head) {\n                                head.removeChild(script);\n                            }\n                        ;\n                        ;\n                        };\n                    }\n                ;\n                ;\n                    if (((((s.dataType == \"script\")) && ((s.cache == null))))) {\n                        s.cache = false;\n                    }\n                ;\n                ;\n                    if (((((s.cache === false)) && ((type == \"GET\"))))) {\n                        var ts = now();\n                        var ret = s.url.replace(/(\\?|&)_=.*?(&|$)/, ((((\"$1_=\" + ts)) + \"$2\")));\n                        s.url = ((ret + ((((ret == s.url)) ? ((((((s.url.match(/\\?/) ? \"&\" : \"?\")) + \"_=\")) + ts)) : \"\"))));\n                    }\n                ;\n                ;\n                    if (((s.data && ((type == \"GET\"))))) {\n                        s.url += ((((s.url.match(/\\?/) ? \"&\" : \"?\")) + s.data));\n                        s.data = null;\n                    }\n                ;\n                ;\n                    if (((s.global && !jQuery.active++))) {\n                        jQuery.JSBNG__event.trigger(\"ajaxStart\");\n                    }\n                ;\n                ;\n                    var remote = /^(?:\\w+:)?\\/\\/([^\\/?#]+)/;\n                    if (((((((((s.dataType == \"script\")) && ((type == \"GET\")))) && remote.test(s.url))) && ((remote.exec(s.url)[1] != JSBNG__location.host))))) {\n                        var head = JSBNG__document.getElementsByTagName(\"head\")[0];\n                        var script = JSBNG__document.createElement(\"script\");\n                        script.src = s.url;\n                        if (s.scriptCharset) {\n                            script.charset = s.scriptCharset;\n                        }\n                    ;\n                    ;\n                        if (!jsonp) {\n                            var done = false;\n                            script.JSBNG__onload = script.JSBNG__onreadystatechange = function() {\n                                if (((!done && ((((!this.readyState || ((this.readyState == \"loaded\")))) || ((this.readyState == \"complete\"))))))) {\n                                    done = true;\n                                    success();\n                                    complete();\n                                    head.removeChild(script);\n                                }\n                            ;\n                            ;\n                            };\n                        }\n                    ;\n                    ;\n                        head.appendChild(script);\n                        return undefined;\n                    }\n                ;\n                ;\n                    var requestDone = false;\n                    var xhr = ((window.ActiveXObject ? new ActiveXObject(\"Microsoft.XMLHTTP\") : new JSBNG__XMLHttpRequest()));\n                    if (s.username) {\n                        xhr.open(type, s.url, s.async, s.username, s.password);\n                    }\n                     else {\n                        xhr.open(type, s.url, s.async);\n                    }\n                ;\n                ;\n                    try {\n                        if (s.data) {\n                            xhr.setRequestHeader(\"Content-Type\", s.contentType);\n                        }\n                    ;\n                    ;\n                        if (s.ifModified) {\n                            xhr.setRequestHeader(\"If-Modified-Since\", ((jQuery.lastModified[s.url] || \"Thu, 01 Jan 1970 00:00:00 GMT\")));\n                        }\n                    ;\n                    ;\n                        xhr.setRequestHeader(\"X-Requested-With\", \"JSBNG__XMLHttpRequest\");\n                        xhr.setRequestHeader(\"Accept\", ((((s.dataType && s.accepts[s.dataType])) ? ((s.accepts[s.dataType] + \", */*\")) : s.accepts._default)));\n                    } catch (e) {\n                    \n                    };\n                ;\n                    if (((s.beforeSend && ((s.beforeSend(xhr, s) === false))))) {\n                        ((s.global && jQuery.active--));\n                        xhr.abort();\n                        return false;\n                    }\n                ;\n                ;\n                    if (s.global) {\n                        jQuery.JSBNG__event.trigger(\"ajaxSend\", [xhr,s,]);\n                    }\n                ;\n                ;\n                    var JSBNG__onreadystatechange = function(isTimeout) {\n                        if (((((!requestDone && xhr)) && ((((xhr.readyState == 4)) || ((isTimeout == \"timeout\"))))))) {\n                            requestDone = true;\n                            if (ival) {\n                                JSBNG__clearInterval(ival);\n                                ival = null;\n                            }\n                        ;\n                        ;\n                            JSBNG__status = ((((((((((isTimeout == \"timeout\")) && \"timeout\")) || ((!jQuery.httpSuccess(xhr) && \"error\")))) || ((((s.ifModified && jQuery.httpNotModified(xhr, s.url))) && \"notmodified\")))) || \"success\"));\n                            if (((JSBNG__status == \"success\"))) {\n                                try {\n                                    data = jQuery.httpData(xhr, s.dataType, s.dataFilter);\n                                } catch (e) {\n                                    JSBNG__status = \"parsererror\";\n                                };\n                            ;\n                            }\n                        ;\n                        ;\n                            if (((JSBNG__status == \"success\"))) {\n                                var modRes;\n                                try {\n                                    modRes = xhr.getResponseHeader(\"Last-Modified\");\n                                } catch (e) {\n                                \n                                };\n                            ;\n                                if (((s.ifModified && modRes))) {\n                                    jQuery.lastModified[s.url] = modRes;\n                                }\n                            ;\n                            ;\n                                if (!jsonp) {\n                                    success();\n                                }\n                            ;\n                            ;\n                            }\n                             else {\n                                jQuery.handleError(s, xhr, JSBNG__status);\n                            }\n                        ;\n                        ;\n                            complete();\n                            if (s.async) {\n                                xhr = null;\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                    };\n                    if (s.async) {\n                        var ival = JSBNG__setInterval(JSBNG__onreadystatechange, 13);\n                        if (((s.timeout > 0))) {\n                            JSBNG__setTimeout(function() {\n                                if (xhr) {\n                                    xhr.abort();\n                                    if (!requestDone) {\n                                        JSBNG__onreadystatechange(\"timeout\");\n                                    }\n                                ;\n                                ;\n                                }\n                            ;\n                            ;\n                            }, s.timeout);\n                        }\n                    ;\n                    ;\n                    }\n                ;\n                ;\n                    try {\n                        xhr.send(s.data);\n                    } catch (e) {\n                        jQuery.handleError(s, xhr, null, e);\n                    };\n                ;\n                    if (!s.async) {\n                        JSBNG__onreadystatechange();\n                    }\n                ;\n                ;\n                    function success() {\n                        if (s.success) {\n                            s.success(data, JSBNG__status);\n                        }\n                    ;\n                    ;\n                        if (s.global) {\n                            jQuery.JSBNG__event.trigger(\"ajaxSuccess\", [xhr,s,]);\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    function complete() {\n                        if (s.complete) {\n                            s.complete(xhr, JSBNG__status);\n                        }\n                    ;\n                    ;\n                        if (s.global) {\n                            jQuery.JSBNG__event.trigger(\"ajaxComplete\", [xhr,s,]);\n                        }\n                    ;\n                    ;\n                        if (((s.global && !--jQuery.active))) {\n                            jQuery.JSBNG__event.trigger(\"ajaxStop\");\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    return xhr;\n                },\n                handleError: function(s, xhr, JSBNG__status, e) {\n                    if (s.error) {\n                        s.error(xhr, JSBNG__status, e);\n                    }\n                ;\n                ;\n                    if (s.global) {\n                        jQuery.JSBNG__event.trigger(\"ajaxError\", [xhr,s,e,]);\n                    }\n                ;\n                ;\n                },\n                active: 0,\n                httpSuccess: function(xhr) {\n                    try {\n                        return ((((((((((!xhr.JSBNG__status && ((JSBNG__location.protocol == \"file:\")))) || ((((xhr.JSBNG__status >= 200)) && ((xhr.JSBNG__status < 300)))))) || ((xhr.JSBNG__status == 304)))) || ((xhr.JSBNG__status == 1223)))) || ((jQuery.browser.safari && ((xhr.JSBNG__status == undefined))))));\n                    } catch (e) {\n                    \n                    };\n                ;\n                    return false;\n                },\n                httpNotModified: function(xhr, url) {\n                    try {\n                        var xhrRes = xhr.getResponseHeader(\"Last-Modified\");\n                        return ((((((xhr.JSBNG__status == 304)) || ((xhrRes == jQuery.lastModified[url])))) || ((jQuery.browser.safari && ((xhr.JSBNG__status == undefined))))));\n                    } catch (e) {\n                    \n                    };\n                ;\n                    return false;\n                },\n                httpData: function(xhr, type, filter) {\n                    var ct = xhr.getResponseHeader(\"content-type\"), xml = ((((type == \"xml\")) || ((((!type && ct)) && ((ct.indexOf(\"xml\") >= 0)))))), data = ((xml ? xhr.responseXML : xhr.responseText));\n                    if (((xml && ((data.documentElement.tagName == \"parsererror\"))))) {\n                        throw \"parsererror\";\n                    }\n                ;\n                ;\n                    if (filter) {\n                        data = filter(data, type);\n                    }\n                ;\n                ;\n                    if (((type == \"script\"))) {\n                        jQuery.globalEval(data);\n                    }\n                ;\n                ;\n                    if (((type == \"json\"))) {\n                        data = eval(((((\"(\" + data)) + \")\")));\n                    }\n                ;\n                ;\n                    return data;\n                },\n                param: function(a) {\n                    var s = [];\n                    if (((((a.constructor == Array)) || a.jquery))) {\n                        jQuery.each(a, function() {\n                            s.push(((((encodeURIComponent(this.JSBNG__name) + \"=\")) + encodeURIComponent(this.value))));\n                        });\n                    }\n                     else {\n                        {\n                            var fin22keys = ((window.top.JSBNG_Replay.forInKeys)((a))), fin22i = (0);\n                            var j;\n                            for (; (fin22i < fin22keys.length); (fin22i++)) {\n                                ((j) = (fin22keys[fin22i]));\n                                {\n                                    if (((a[j] && ((a[j].constructor == Array))))) {\n                                        jQuery.each(a[j], function() {\n                                            s.push(((((encodeURIComponent(j) + \"=\")) + encodeURIComponent(this))));\n                                        });\n                                    }\n                                     else {\n                                        s.push(((((encodeURIComponent(j) + \"=\")) + encodeURIComponent(((jQuery.isFunction(a[j]) ? a[j]() : a[j]))))));\n                                    }\n                                ;\n                                ;\n                                };\n                            };\n                        };\n                    ;\n                    }\n                ;\n                ;\n                    return s.join(\"&\").replace(/%20/g, \"+\");\n                }\n            });\n            jQuery.fn.extend({\n                show: function(speed, callback) {\n                    return ((speed ? this.animate({\n                        height: \"show\",\n                        width: \"show\",\n                        opacity: \"show\"\n                    }, speed, callback) : this.filter(\":hidden\").each(function() {\n                        this.style.display = ((this.oldblock || \"\"));\n                        if (((jQuery.css(this, \"display\") == \"none\"))) {\n                            var elem = jQuery(((((\"\\u003C\" + this.tagName)) + \" /\\u003E\"))).appendTo(\"body\");\n                            this.style.display = elem.css(\"display\");\n                            if (((this.style.display == \"none\"))) {\n                                this.style.display = \"block\";\n                            }\n                        ;\n                        ;\n                            elem.remove();\n                        }\n                    ;\n                    ;\n                    }).end()));\n                },\n                hide: function(speed, callback) {\n                    return ((speed ? this.animate({\n                        height: \"hide\",\n                        width: \"hide\",\n                        opacity: \"hide\"\n                    }, speed, callback) : this.filter(\":visible\").each(function() {\n                        this.oldblock = ((this.oldblock || jQuery.css(this, \"display\")));\n                        this.style.display = \"none\";\n                    }).end()));\n                },\n                _toggle: jQuery.fn.toggle,\n                toggle: function(fn, fn2) {\n                    return ((((jQuery.isFunction(fn) && jQuery.isFunction(fn2))) ? this._toggle.apply(this, arguments) : ((fn ? this.animate({\n                        height: \"toggle\",\n                        width: \"toggle\",\n                        opacity: \"toggle\"\n                    }, fn, fn2) : this.each(function() {\n                        jQuery(this)[((jQuery(this).is(\":hidden\") ? \"show\" : \"hide\"))]();\n                    })))));\n                },\n                slideDown: function(speed, callback) {\n                    return this.animate({\n                        height: \"show\"\n                    }, speed, callback);\n                },\n                slideUp: function(speed, callback) {\n                    return this.animate({\n                        height: \"hide\"\n                    }, speed, callback);\n                },\n                slideToggle: function(speed, callback) {\n                    return this.animate({\n                        height: \"toggle\"\n                    }, speed, callback);\n                },\n                fadeIn: function(speed, callback) {\n                    return this.animate({\n                        opacity: \"show\"\n                    }, speed, callback);\n                },\n                fadeOut: function(speed, callback) {\n                    return this.animate({\n                        opacity: \"hide\"\n                    }, speed, callback);\n                },\n                fadeTo: function(speed, to, callback) {\n                    return this.animate({\n                        opacity: to\n                    }, speed, callback);\n                },\n                animate: function(prop, speed, easing, callback) {\n                    var optall = jQuery.speed(speed, easing, callback);\n                    return this[((((optall.queue === false)) ? \"each\" : \"queue\"))](function() {\n                        if (((this.nodeType != 1))) {\n                            return false;\n                        }\n                    ;\n                    ;\n                        var opt = jQuery.extend({\n                        }, optall), p, hidden = jQuery(this).is(\":hidden\"), JSBNG__self = this;\n                        {\n                            var fin23keys = ((window.top.JSBNG_Replay.forInKeys)((prop))), fin23i = (0);\n                            (0);\n                            for (; (fin23i < fin23keys.length); (fin23i++)) {\n                                ((p) = (fin23keys[fin23i]));\n                                {\n                                    if (((((((prop[p] == \"hide\")) && hidden)) || ((((prop[p] == \"show\")) && !hidden))))) {\n                                        return opt.complete.call(this);\n                                    }\n                                ;\n                                ;\n                                    if (((((p == \"height\")) || ((p == \"width\"))))) {\n                                        opt.display = jQuery.css(this, \"display\");\n                                        opt.overflow = this.style.overflow;\n                                    }\n                                ;\n                                ;\n                                };\n                            };\n                        };\n                    ;\n                        if (((opt.overflow != null))) {\n                            this.style.overflow = \"hidden\";\n                        }\n                    ;\n                    ;\n                        opt.curAnim = jQuery.extend({\n                        }, prop);\n                        jQuery.each(prop, function(JSBNG__name, val) {\n                            var e = new jQuery.fx(JSBNG__self, opt, JSBNG__name);\n                            if (/toggle|show|hide/.test(val)) {\n                                e[((((val == \"toggle\")) ? ((hidden ? \"show\" : \"hide\")) : val))](prop);\n                            }\n                             else {\n                                var parts = val.toString().match(/^([+-]=)?([\\d+-.]+)(.*)$/), start = ((e.cur(true) || 0));\n                                if (parts) {\n                                    var end = parseFloat(parts[2]), unit = ((parts[3] || \"px\"));\n                                    if (((unit != \"px\"))) {\n                                        JSBNG__self.style[JSBNG__name] = ((((end || 1)) + unit));\n                                        start = ((((((end || 1)) / e.cur(true))) * start));\n                                        JSBNG__self.style[JSBNG__name] = ((start + unit));\n                                    }\n                                ;\n                                ;\n                                    if (parts[1]) {\n                                        end = ((((((((parts[1] == \"-=\")) ? -1 : 1)) * end)) + start));\n                                    }\n                                ;\n                                ;\n                                    e.custom(start, end, unit);\n                                }\n                                 else {\n                                    e.custom(start, val, \"\");\n                                }\n                            ;\n                            ;\n                            }\n                        ;\n                        ;\n                        });\n                        return true;\n                    });\n                },\n                queue: function(type, fn) {\n                    if (((jQuery.isFunction(type) || ((type && ((type.constructor == Array))))))) {\n                        fn = type;\n                        type = \"fx\";\n                    }\n                ;\n                ;\n                    if (((!type || ((((typeof type == \"string\")) && !fn))))) {\n                        return queue(this[0], type);\n                    }\n                ;\n                ;\n                    return this.each(function() {\n                        if (((fn.constructor == Array))) {\n                            queue(this, type, fn);\n                        }\n                         else {\n                            queue(this, type).push(fn);\n                            if (((queue(this, type).length == 1))) {\n                                fn.call(this);\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                    });\n                },\n                JSBNG__stop: function(clearQueue, gotoEnd) {\n                    var timers = jQuery.timers;\n                    if (clearQueue) {\n                        this.queue([]);\n                    }\n                ;\n                ;\n                    this.each(function() {\n                        for (var i = ((timers.length - 1)); ((i >= 0)); i--) {\n                            if (((timers[i].elem == this))) {\n                                if (gotoEnd) {\n                                    timers[i](true);\n                                }\n                            ;\n                            ;\n                                timers.splice(i, 1);\n                            }\n                        ;\n                        ;\n                        };\n                    ;\n                    });\n                    if (!gotoEnd) {\n                        this.dequeue();\n                    }\n                ;\n                ;\n                    return this;\n                }\n            });\n            var queue = function(elem, type, array) {\n                if (elem) {\n                    type = ((type || \"fx\"));\n                    var q = jQuery.data(elem, ((type + \"queue\")));\n                    if (((!q || array))) {\n                        q = jQuery.data(elem, ((type + \"queue\")), jQuery.makeArray(array));\n                    }\n                ;\n                ;\n                }\n            ;\n            ;\n                return q;\n            };\n            jQuery.fn.dequeue = function(type) {\n                type = ((type || \"fx\"));\n                return this.each(function() {\n                    var q = queue(this, type);\n                    q.shift();\n                    if (q.length) {\n                        q[0].call(this);\n                    }\n                ;\n                ;\n                });\n            };\n            jQuery.extend({\n                speed: function(speed, easing, fn) {\n                    var opt = ((((speed && ((speed.constructor == Object)))) ? speed : {\n                        complete: ((((fn || ((!fn && easing)))) || ((jQuery.isFunction(speed) && speed)))),\n                        duration: speed,\n                        easing: ((((fn && easing)) || ((((easing && ((easing.constructor != Function)))) && easing))))\n                    }));\n                    opt.duration = ((((((opt.duration && ((opt.duration.constructor == Number)))) ? opt.duration : jQuery.fx.speeds[opt.duration])) || jQuery.fx.speeds.def));\n                    opt.old = opt.complete;\n                    opt.complete = function() {\n                        if (((opt.queue !== false))) {\n                            jQuery(this).dequeue();\n                        }\n                    ;\n                    ;\n                        if (jQuery.isFunction(opt.old)) {\n                            opt.old.call(this);\n                        }\n                    ;\n                    ;\n                    };\n                    return opt;\n                },\n                easing: {\n                    linear: function(p, n, firstNum, diff) {\n                        return ((firstNum + ((diff * p))));\n                    },\n                    swing: function(p, n, firstNum, diff) {\n                        return ((((((((-Math.cos(((p * Math.PI))) / 2)) + 51337)) * diff)) + firstNum));\n                    }\n                },\n                timers: [],\n                timerId: null,\n                fx: function(elem, options, prop) {\n                    this.options = options;\n                    this.elem = elem;\n                    this.prop = prop;\n                    if (!options.orig) {\n                        options.orig = {\n                        };\n                    }\n                ;\n                ;\n                }\n            });\n            jQuery.fx.prototype = {\n                update: function() {\n                    if (this.options.step) {\n                        this.options.step.call(this.elem, this.now, this);\n                    }\n                ;\n                ;\n                    ((jQuery.fx.step[this.prop] || jQuery.fx.step._default))(this);\n                    if (((((this.prop == \"height\")) || ((this.prop == \"width\"))))) {\n                        this.elem.style.display = \"block\";\n                    }\n                ;\n                ;\n                },\n                cur: function(force) {\n                    if (((((this.elem[this.prop] != null)) && ((this.elem.style[this.prop] == null))))) {\n                        return this.elem[this.prop];\n                    }\n                ;\n                ;\n                    var r = parseFloat(jQuery.css(this.elem, this.prop, force));\n                    return ((((r && ((r > -10000)))) ? r : ((parseFloat(jQuery.curCSS(this.elem, this.prop)) || 0))));\n                },\n                custom: function(from, to, unit) {\n                    this.startTime = now();\n                    this.start = from;\n                    this.end = to;\n                    this.unit = ((((unit || this.unit)) || \"px\"));\n                    this.now = this.start;\n                    this.pos = this.state = 0;\n                    this.update();\n                    var JSBNG__self = this;\n                    function t(gotoEnd) {\n                        return JSBNG__self.step(gotoEnd);\n                    };\n                ;\n                    t.elem = this.elem;\n                    jQuery.timers.push(t);\n                    if (((jQuery.timerId == null))) {\n                        jQuery.timerId = JSBNG__setInterval(function() {\n                            var timers = jQuery.timers;\n                            for (var i = 0; ((i < timers.length)); i++) {\n                                if (!timers[i]()) {\n                                    timers.splice(i--, 1);\n                                }\n                            ;\n                            ;\n                            };\n                        ;\n                            if (!timers.length) {\n                                JSBNG__clearInterval(jQuery.timerId);\n                                jQuery.timerId = null;\n                            }\n                        ;\n                        ;\n                        }, 13);\n                    }\n                ;\n                ;\n                },\n                show: function() {\n                    this.options.orig[this.prop] = jQuery.attr(this.elem.style, this.prop);\n                    this.options.show = true;\n                    this.custom(0, this.cur());\n                    if (((((this.prop == \"width\")) || ((this.prop == \"height\"))))) {\n                        this.elem.style[this.prop] = \"1px\";\n                    }\n                ;\n                ;\n                    jQuery(this.elem).show();\n                },\n                hide: function() {\n                    this.options.orig[this.prop] = jQuery.attr(this.elem.style, this.prop);\n                    this.options.hide = true;\n                    this.custom(this.cur(), 0);\n                },\n                step: function(gotoEnd) {\n                    var t = now();\n                    if (((gotoEnd || ((t > ((this.options.duration + this.startTime))))))) {\n                        this.now = this.end;\n                        this.pos = this.state = 1;\n                        this.update();\n                        this.options.curAnim[this.prop] = true;\n                        var done = true;\n                        {\n                            var fin24keys = ((window.top.JSBNG_Replay.forInKeys)((this.options.curAnim))), fin24i = (0);\n                            var i;\n                            for (; (fin24i < fin24keys.length); (fin24i++)) {\n                                ((i) = (fin24keys[fin24i]));\n                                {\n                                    if (((this.options.curAnim[i] !== true))) {\n                                        done = false;\n                                    }\n                                ;\n                                ;\n                                };\n                            };\n                        };\n                    ;\n                        if (done) {\n                            if (((this.options.display != null))) {\n                                this.elem.style.overflow = this.options.overflow;\n                                this.elem.style.display = this.options.display;\n                                if (((jQuery.css(this.elem, \"display\") == \"none\"))) {\n                                    this.elem.style.display = \"block\";\n                                }\n                            ;\n                            ;\n                            }\n                        ;\n                        ;\n                            if (this.options.hide) {\n                                this.elem.style.display = \"none\";\n                            }\n                        ;\n                        ;\n                            if (((this.options.hide || this.options.show))) {\n                                {\n                                    var fin25keys = ((window.top.JSBNG_Replay.forInKeys)((this.options.curAnim))), fin25i = (0);\n                                    var p;\n                                    for (; (fin25i < fin25keys.length); (fin25i++)) {\n                                        ((p) = (fin25keys[fin25i]));\n                                        {\n                                            jQuery.attr(this.elem.style, p, this.options.orig[p]);\n                                        };\n                                    };\n                                };\n                            ;\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                        if (done) {\n                            this.options.complete.call(this.elem);\n                        }\n                    ;\n                    ;\n                        return false;\n                    }\n                     else {\n                        var n = ((t - this.startTime));\n                        this.state = ((n / this.options.duration));\n                        this.pos = jQuery.easing[((this.options.easing || ((jQuery.easing.swing ? \"swing\" : \"linear\"))))](this.state, n, 0, 1, this.options.duration);\n                        this.now = ((this.start + ((((this.end - this.start)) * this.pos))));\n                        this.update();\n                    }\n                ;\n                ;\n                    return true;\n                }\n            };\n            jQuery.extend(jQuery.fx, {\n                speeds: {\n                    slow: 600,\n                    fast: 200,\n                    def: 400\n                },\n                step: {\n                    scrollLeft: function(fx) {\n                        fx.elem.scrollLeft = fx.now;\n                    },\n                    scrollTop: function(fx) {\n                        fx.elem.scrollTop = fx.now;\n                    },\n                    opacity: function(fx) {\n                        jQuery.attr(fx.elem.style, \"opacity\", fx.now);\n                    },\n                    _default: function(fx) {\n                        fx.elem.style[fx.prop] = ((fx.now + fx.unit));\n                    }\n                }\n            });\n            jQuery.fn.offset = function() {\n                var left = 0, JSBNG__top = 0, elem = this[0], results;\n                if (elem) {\n                    with (jQuery.browser) {\n                        var parent = elem.parentNode, offsetChild = elem, offsetParent = elem.offsetParent, doc = elem.ownerDocument, safari2 = ((((safari && ((parseInt(version) < 522)))) && !/adobeair/i.test(userAgent))), css = jQuery.curCSS, fixed = ((css(elem, \"position\") == \"fixed\"));\n                        if (elem.getBoundingClientRect) {\n                            var box = elem.getBoundingClientRect();\n                            add(((box.left + Math.max(doc.documentElement.scrollLeft, doc.body.scrollLeft))), ((box.JSBNG__top + Math.max(doc.documentElement.scrollTop, doc.body.scrollTop))));\n                            add(-doc.documentElement.clientLeft, -doc.documentElement.clientTop);\n                        }\n                         else {\n                            add(elem.offsetLeft, elem.offsetTop);\n                            while (offsetParent) {\n                                add(offsetParent.offsetLeft, offsetParent.offsetTop);\n                                if (((((mozilla && !/^t(able|d|h)$/i.test(offsetParent.tagName))) || ((safari && !safari2))))) {\n                                    border(offsetParent);\n                                }\n                            ;\n                            ;\n                                if (((!fixed && ((css(offsetParent, \"position\") == \"fixed\"))))) {\n                                    fixed = true;\n                                }\n                            ;\n                            ;\n                                offsetChild = ((/^body$/i.test(offsetParent.tagName) ? offsetChild : offsetParent));\n                                offsetParent = offsetParent.offsetParent;\n                            };\n                        ;\n                            while (((((parent && parent.tagName)) && !/^body|html$/i.test(parent.tagName)))) {\n                                if (!/^inline|table.*$/i.test(css(parent, \"display\"))) {\n                                    add(-parent.scrollLeft, -parent.scrollTop);\n                                }\n                            ;\n                            ;\n                                if (((mozilla && ((css(parent, \"overflow\") != \"visible\"))))) {\n                                    border(parent);\n                                }\n                            ;\n                            ;\n                                parent = parent.parentNode;\n                            };\n                        ;\n                            if (((((safari2 && ((fixed || ((css(offsetChild, \"position\") == \"absolute\")))))) || ((mozilla && ((css(offsetChild, \"position\") != \"absolute\"))))))) {\n                                add(-doc.body.offsetLeft, -doc.body.offsetTop);\n                            }\n                        ;\n                        ;\n                            if (fixed) {\n                                add(Math.max(doc.documentElement.scrollLeft, doc.body.scrollLeft), Math.max(doc.documentElement.scrollTop, doc.body.scrollTop));\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                        results = {\n                            JSBNG__top: JSBNG__top,\n                            left: left\n                        };\n                    };\n                ;\n                }\n            ;\n            ;\n                function border(elem) {\n                    add(jQuery.curCSS(elem, \"borderLeftWidth\", true), jQuery.curCSS(elem, \"borderTopWidth\", true));\n                };\n            ;\n                function add(l, t) {\n                    left += ((parseInt(l, 10) || 0));\n                    JSBNG__top += ((parseInt(t, 10) || 0));\n                };\n            ;\n                return results;\n            };\n            jQuery.fn.extend({\n                position: function() {\n                    var left = 0, JSBNG__top = 0, results;\n                    if (this[0]) {\n                        var offsetParent = this.offsetParent(), offset = this.offset(), parentOffset = ((/^body|html$/i.test(offsetParent[0].tagName) ? {\n                            JSBNG__top: 0,\n                            left: 0\n                        } : offsetParent.offset()));\n                        offset.JSBNG__top -= num(this, \"marginTop\");\n                        offset.left -= num(this, \"marginLeft\");\n                        parentOffset.JSBNG__top += num(offsetParent, \"borderTopWidth\");\n                        parentOffset.left += num(offsetParent, \"borderLeftWidth\");\n                        results = {\n                            JSBNG__top: ((offset.JSBNG__top - parentOffset.JSBNG__top)),\n                            left: ((offset.left - parentOffset.left))\n                        };\n                    }\n                ;\n                ;\n                    return results;\n                },\n                offsetParent: function() {\n                    var offsetParent = this[0].offsetParent;\n                    while (((offsetParent && ((!/^body|html$/i.test(offsetParent.tagName) && ((jQuery.css(offsetParent, \"position\") == \"static\"))))))) {\n                        offsetParent = offsetParent.offsetParent;\n                    };\n                ;\n                    return jQuery(offsetParent);\n                }\n            });\n            jQuery.each([\"Left\",\"Top\",], function(i, JSBNG__name) {\n                var method = ((\"JSBNG__scroll\" + JSBNG__name));\n                jQuery.fn[method] = function(val) {\n                    if (!this[0]) {\n                        return;\n                    }\n                ;\n                ;\n                    return ((((val != undefined)) ? this.each(function() {\n                        ((((((this == window)) || ((this == JSBNG__document)))) ? window.JSBNG__scrollTo(((!i ? val : jQuery(window).scrollLeft())), ((i ? val : jQuery(window).scrollTop()))) : this[method] = val));\n                    }) : ((((((this[0] == window)) || ((this[0] == JSBNG__document)))) ? ((((JSBNG__self[((i ? \"JSBNG__pageYOffset\" : \"JSBNG__pageXOffset\"))] || ((jQuery.boxModel && JSBNG__document.documentElement[method])))) || JSBNG__document.body[method])) : this[0][method]))));\n                };\n            });\n            jQuery.each([\"Height\",\"Width\",], function(i, JSBNG__name) {\n                var tl = ((i ? \"Left\" : \"Top\")), br = ((i ? \"Right\" : \"Bottom\"));\n                jQuery.fn[((\"JSBNG__inner\" + JSBNG__name))] = function() {\n                    return ((((this[JSBNG__name.toLowerCase()]() + num(this, ((\"padding\" + tl))))) + num(this, ((\"padding\" + br)))));\n                };\n                jQuery.fn[((\"JSBNG__outer\" + JSBNG__name))] = function(margin) {\n                    return ((((((this[((\"JSBNG__inner\" + JSBNG__name))]() + num(this, ((((\"border\" + tl)) + \"Width\"))))) + num(this, ((((\"border\" + br)) + \"Width\"))))) + ((margin ? ((num(this, ((\"margin\" + tl))) + num(this, ((\"margin\" + br))))) : 0))));\n                };\n            });\n        };\n        if (window.amznJQ) {\n            amznJQ.initJQuery = initJQuery;\n        }\n         else {\n            initJQuery();\n        }\n    ;\n    ;\n    })();\n    (function() {\n        var patchJQuery = function(jQuery) {\n            var $ = jQuery;\n            if (!jQuery) {\n                return;\n            }\n        ;\n        ;\n            jQuery.fn.offset126 = jQuery.fn.offset;\n            if (JSBNG__document.documentElement[\"getBoundingClientRect\"]) {\n                jQuery.fn.offset = function() {\n                    if (((!this[0] || !this[0].ownerDocument))) {\n                        return {\n                            JSBNG__top: 0,\n                            left: 0\n                        };\n                    }\n                ;\n                ;\n                    if (((this[0] === this[0].ownerDocument.body))) {\n                        return jQuery.offset.bodyOffset(this[0]);\n                    }\n                ;\n                ;\n                    var box = this[0].getBoundingClientRect(), doc = this[0].ownerDocument, body = doc.body, docElem = doc.documentElement, ieTouch = ((JSBNG__navigator.msMaxTouchPoints > 0)), clientTop = ((((docElem.clientTop || body.clientTop)) || 0)), clientLeft = ((((docElem.clientLeft || body.clientLeft)) || 0)), JSBNG__top = ((((box.JSBNG__top + ((((((!ieTouch && JSBNG__self.JSBNG__pageYOffset)) || ((jQuery.boxModel && docElem.scrollTop)))) || body.scrollTop)))) - clientTop)), left = ((((box.left + ((((((!ieTouch && JSBNG__self.JSBNG__pageXOffset)) || ((jQuery.boxModel && docElem.scrollLeft)))) || body.scrollLeft)))) - clientLeft));\n                    return {\n                        JSBNG__top: JSBNG__top,\n                        left: left\n                    };\n                };\n            }\n             else {\n                jQuery.fn.offset = function() {\n                    if (((!this[0] || !this[0].ownerDocument))) {\n                        return {\n                            JSBNG__top: 0,\n                            left: 0\n                        };\n                    }\n                ;\n                ;\n                    if (((this[0] === this[0].ownerDocument.body))) {\n                        return jQuery.offset.bodyOffset(this[0]);\n                    }\n                ;\n                ;\n                    ((jQuery.offset.initialized || jQuery.offset.initialize()));\n                    var elem = this[0], offsetParent = elem.offsetParent, prevOffsetParent = elem, doc = elem.ownerDocument, computedStyle, docElem = doc.documentElement, body = doc.body, defaultView = doc.defaultView, prevComputedStyle = defaultView.JSBNG__getComputedStyle(elem, null), JSBNG__top = elem.offsetTop, left = elem.offsetLeft;\n                    while ((((((elem = elem.parentNode) && ((elem !== body)))) && ((elem !== docElem))))) {\n                        computedStyle = defaultView.JSBNG__getComputedStyle(elem, null);\n                        JSBNG__top -= elem.scrollTop, left -= elem.scrollLeft;\n                        if (((elem === offsetParent))) {\n                            JSBNG__top += elem.offsetTop, left += elem.offsetLeft;\n                            if (((jQuery.offset.doesNotAddBorder && !((jQuery.offset.doesAddBorderForTableAndCells && /^t(able|d|h)$/i.test(elem.tagName)))))) {\n                                JSBNG__top += ((parseInt(computedStyle.borderTopWidth, 10) || 0)), left += ((parseInt(computedStyle.borderLeftWidth, 10) || 0));\n                            }\n                        ;\n                        ;\n                            prevOffsetParent = offsetParent, offsetParent = elem.offsetParent;\n                        }\n                    ;\n                    ;\n                        if (((jQuery.offset.subtractsBorderForOverflowNotVisible && ((computedStyle.overflow !== \"visible\"))))) {\n                            JSBNG__top += ((parseInt(computedStyle.borderTopWidth, 10) || 0)), left += ((parseInt(computedStyle.borderLeftWidth, 10) || 0));\n                        }\n                    ;\n                    ;\n                        prevComputedStyle = computedStyle;\n                    };\n                ;\n                    if (((((prevComputedStyle.position === \"relative\")) || ((prevComputedStyle.position === \"static\"))))) {\n                        JSBNG__top += body.offsetTop, left += body.offsetLeft;\n                    }\n                ;\n                ;\n                    if (((prevComputedStyle.position === \"fixed\"))) {\n                        JSBNG__top += Math.max(docElem.scrollTop, body.scrollTop), left += Math.max(docElem.scrollLeft, body.scrollLeft);\n                    }\n                ;\n                ;\n                    return {\n                        JSBNG__top: JSBNG__top,\n                        left: left\n                    };\n                };\n            }\n        ;\n        ;\n            jQuery.offset = {\n                initialize: function() {\n                    if (this.initialized) {\n                        return;\n                    }\n                ;\n                ;\n                    var body = JSBNG__document.body, container = JSBNG__document.createElement(\"div\"), innerDiv, checkDiv, table, rules, prop, bodyMarginTop = body.style.marginTop, html = \"\\u003Cdiv style=\\\"position:absolute;top:0;left:0;margin:0;border:5px solid #000;padding:0;width:1px;height:1px;\\\"\\u003E\\u003Cdiv\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003Ctable style=\\\"position:absolute;top:0;left:0;margin:0;border:5px solid #000;padding:0;width:1px;height:1px;\\\"cellpadding=\\\"0\\\"cellspacing=\\\"0\\\"\\u003E\\u003Ctr\\u003E\\u003Ctd\\u003E\\u003C/td\\u003E\\u003C/tr\\u003E\\u003C/table\\u003E\";\n                    rules = {\n                        position: \"absolute\",\n                        JSBNG__top: 0,\n                        left: 0,\n                        margin: 0,\n                        border: 0,\n                        width: \"1px\",\n                        height: \"1px\",\n                        visibility: \"hidden\"\n                    };\n                    {\n                        var fin26keys = ((window.top.JSBNG_Replay.forInKeys)((rules))), fin26i = (0);\n                        (0);\n                        for (; (fin26i < fin26keys.length); (fin26i++)) {\n                            ((prop) = (fin26keys[fin26i]));\n                            {\n                                container.style[prop] = rules[prop];\n                            };\n                        };\n                    };\n                ;\n                    container.innerHTML = html;\n                    body.insertBefore(container, body.firstChild);\n                    innerDiv = container.firstChild, checkDiv = innerDiv.firstChild, td = innerDiv.nextSibling.firstChild.firstChild;\n                    this.doesNotAddBorder = ((checkDiv.offsetTop !== 5));\n                    this.doesAddBorderForTableAndCells = ((td.offsetTop === 5));\n                    innerDiv.style.overflow = \"hidden\", innerDiv.style.position = \"relative\";\n                    this.subtractsBorderForOverflowNotVisible = ((checkDiv.offsetTop === -5));\n                    body.style.marginTop = \"1px\";\n                    this.doesNotIncludeMarginInBodyOffset = ((body.offsetTop === 0));\n                    body.style.marginTop = bodyMarginTop;\n                    body.removeChild(container);\n                    this.initialized = true;\n                },\n                bodyOffset: function(body) {\n                    ((jQuery.offset.initialized || jQuery.offset.initialize()));\n                    var JSBNG__top = body.offsetTop, left = body.offsetLeft;\n                    if (jQuery.offset.doesNotIncludeMarginInBodyOffset) {\n                        JSBNG__top += ((parseInt(jQuery.curCSS(body, \"marginTop\", true), 10) || 0)), left += ((parseInt(jQuery.curCSS(body, \"marginLeft\", true), 10) || 0));\n                    }\n                ;\n                ;\n                    return {\n                        JSBNG__top: JSBNG__top,\n                        left: left\n                    };\n                }\n            };\n            if (((jQuery.browser.msie && ((JSBNG__document.compatMode == \"BackCompat\"))))) {\n                var fixOriginal = jQuery.JSBNG__event.fix;\n                jQuery.JSBNG__event.fix = function(JSBNG__event) {\n                    var e = fixOriginal(JSBNG__event);\n                    e.pageX -= 2;\n                    e.pageY -= 2;\n                    return e;\n                };\n            }\n        ;\n        ;\n            jQuery.fn.offsetNoIPadFix = jQuery.fn.offset;\n            jQuery.fn.offsetIPadFix = jQuery.fn.offset;\n            if (((((/webkit.*mobile/i.test(JSBNG__navigator.userAgent) && ((parseFloat($.browser.version) < 532.9)))) && ((\"getBoundingClientRect\" in JSBNG__document.documentElement))))) {\n                jQuery.fn.offsetIPadFix = function() {\n                    var result = this.offsetNoIPadFix();\n                    result.JSBNG__top -= window.JSBNG__scrollY;\n                    result.left -= window.JSBNG__scrollX;\n                    return result;\n                };\n                if (((((typeof window.jQueryPatchIPadOffset != \"undefined\")) && window.jQueryPatchIPadOffset))) {\n                    jQuery.fn.offset = jQuery.fn.offsetIPadFix;\n                }\n            ;\n            ;\n            }\n        ;\n        ;\n        };\n        if (((window.amznJQ && amznJQ.initJQuery))) {\n            var initJQuery = amznJQ.initJQuery;\n            amznJQ.initJQuery = function() {\n                initJQuery();\n                patchJQuery(jQuery);\n            };\n        }\n         else {\n            patchJQuery(jQuery);\n        }\n    ;\n    ;\n    })();\n    (function() {\n        var timesliceJS, initJQuery;\n        if (window.amznJQ) {\n            timesliceJS = amznJQ._timesliceJS;\n            initJQuery = amznJQ.initJQuery;\n            delete amznJQ._timesliceJS;\n            delete amznJQ.initJQuery;\n        }\n    ;\n    ;\n        var isRunning = false, cbsWaiting = [];\n        var doDeferred = function() {\n        ;\n            isRunning = true;\n            var stopTime = (((new JSBNG__Date()).getTime() + 40));\n            var callingCB;\n            try {\n                while (((cbsWaiting.length && (((new JSBNG__Date()).getTime() <= stopTime))))) {\n                    var cb = cbsWaiting.shift();\n                    callingCB = true;\n                    cb();\n                    callingCB = false;\n                };\n            ;\n            } finally {\n                if (callingCB) {\n                ;\n                }\n            ;\n            ;\n                if (cbsWaiting.length) {\n                ;\n                    JSBNG__setTimeout(doDeferred, 0);\n                }\n                 else {\n                ;\n                    isRunning = false;\n                }\n            ;\n            ;\n            };\n        ;\n        };\n        var callInTimeslice = function(cbOrArray) {\n            if (((typeof cbOrArray === \"function\"))) {\n                cbsWaiting.push(cbOrArray);\n            }\n             else {\n                cbsWaiting = cbsWaiting.concat(cbOrArray);\n            }\n        ;\n        ;\n            if (!isRunning) {\n                isRunning = true;\n                JSBNG__setTimeout(doDeferred, 0);\n            }\n        ;\n        ;\n        };\n        var initAmznJQ = function() {\n            var $ = window.jQuery, jQuery = $;\n            if (!jQuery) {\n                return;\n            }\n        ;\n        ;\n            var bootstrapAmznJQ = window.amznJQ;\n            if (!window.goN2Debug) {\n                window.goN2Debug = new function() {\n                    this.info = function() {\n                    \n                    };\n                    return this;\n                };\n            }\n        ;\n        ;\n            window.amznJQ = new function() {\n            ;\n                var me = this;\n                me.jQuery = jQuery;\n                jQuery.noConflict(true);\n                if (window.jQuery) {\n                ;\n                }\n                 else {\n                    window.jQuery = jQuery;\n                }\n            ;\n            ;\n                var _logicalToPhysical = {\n                    JQuery: {\n                        functionality: \"JQuery\",\n                        urls: null\n                    },\n                    popover: {\n                        functionality: \"popover\",\n                        urls: null\n                    }\n                };\n                var _func_loaded = {\n                };\n                var _url_loaded = {\n                };\n                var _loading = {\n                };\n                function _loadFunctionality(functionality) {\n                    var urls = _logicalToPhysical[functionality].urls;\n                    if (urls) {\n                    ;\n                        $.each(urls, function() {\n                            if (!_url_loaded[this]) {\n                                _loadURL(this, functionality);\n                            }\n                        ;\n                        ;\n                        });\n                    }\n                     else {\n                    ;\n                    }\n                ;\n                ;\n                };\n            ;\n                function _loadURL(url, functionality) {\n                ;\n                    $.ajax({\n                        type: \"GET\",\n                        url: url,\n                        success: _onUrlLoadedFcn(url, functionality),\n                        dataType: \"script\",\n                        cache: true\n                    });\n                };\n            ;\n                function _onUrlLoadedFcn(url, functionality) {\n                    return function() {\n                    ;\n                        _url_loaded[url] = true;\n                        var all_loaded = true;\n                        $.each(_logicalToPhysical[functionality].urls, function() {\n                            all_loaded = ((all_loaded && !!_url_loaded[this]));\n                        });\n                        if (all_loaded) {\n                        \n                        }\n                    ;\n                    ;\n                    };\n                };\n            ;\n                me.addLogical = function(functionality, urls) {\n                    var ul = ((urls ? urls.length : \"no\"));\n                ;\n                    _logicalToPhysical[functionality] = {\n                        functionality: functionality,\n                        urls: urls\n                    };\n                    if (!urls) {\n                        me.declareAvailable(functionality);\n                        return;\n                    }\n                ;\n                ;\n                    if (_loading[functionality]) {\n                        _loadFunctionality(functionality);\n                    }\n                ;\n                ;\n                };\n                me.declareAvailable = function(functionality) {\n                ;\n                    if (((typeof _logicalToPhysical[functionality] == \"undefined\"))) {\n                        _logicalToPhysical[functionality] = {\n                            functionality: functionality,\n                            urls: null\n                        };\n                    }\n                ;\n                ;\n                    _func_loaded[functionality] = true;\n                    triggerEventCallbacks(((functionality + \".loaded\")));\n                };\n                me.addStyle = function(css_url) {\n                    var dcss = JSBNG__document.styleSheets[0];\n                    if (((dcss && dcss.addImport))) {\n                        while (((dcss.imports.length >= 31))) {\n                            dcss = dcss.imports[0];\n                        };\n                    ;\n                        dcss.addImport(css_url);\n                    }\n                     else {\n                        $(\"style[type='text/css']:first\").append(((((\"@import url(\\\"\" + css_url)) + \"\\\");\")));\n                    }\n                ;\n                ;\n                };\n                me.addStyles = function(args) {\n                    var urls = ((args.urls || []));\n                    var styles = ((args.styles || []));\n                    var dcss = JSBNG__document.styleSheets;\n                    if (((((dcss && !dcss.length)) && JSBNG__document.createStyleSheet))) {\n                        JSBNG__document.createStyleSheet();\n                    }\n                ;\n                ;\n                    dcss = dcss[0];\n                    if (((dcss && dcss.addImport))) {\n                        $.each(urls, function() {\n                            while (((dcss.imports.length >= 31))) {\n                                dcss = dcss.imports[0];\n                            };\n                        ;\n                            dcss.addImport(this);\n                        });\n                    }\n                     else {\n                        $.each(urls, function() {\n                            var attrs = {\n                                type: \"text/css\",\n                                rel: \"stylesheet\",\n                                href: this\n                            };\n                            $(\"head\").append($(\"\\u003Clink/\\u003E\").attr(attrs));\n                        });\n                    }\n                ;\n                ;\n                    var css = \"\";\n                    $.each(styles, function() {\n                        css += this;\n                    });\n                    if (css) {\n                        if (JSBNG__document.createStyleSheet) {\n                            try {\n                                var sheet = JSBNG__document.createStyleSheet();\n                                sheet.cssText = css;\n                            } catch (e) {\n                            \n                            };\n                        ;\n                        }\n                         else {\n                            $(\"head\").append($(\"\\u003Cstyle/\\u003E\").attr({\n                                type: \"text/css\"\n                            }).append(css));\n                        }\n                    ;\n                    ;\n                    }\n                ;\n                ;\n                };\n                var eventCBQueue = {\n                };\n                var enqueueEventCallback = function(eventName, cb) {\n                    if (!timesliceJS) {\n                        $(JSBNG__document).one(eventName, cb);\n                        return;\n                    }\n                ;\n                ;\n                    var queue = ((eventCBQueue[eventName] || []));\n                    queue.push(function() {\n                        cb(jQuery.JSBNG__event.fix({\n                            type: eventName\n                        }));\n                    });\n                    eventCBQueue[eventName] = queue;\n                };\n                var triggerEventCallbacks = function(eventName) {\n                    if (!timesliceJS) {\n                        $(JSBNG__document).trigger(eventName);\n                        return;\n                    }\n                ;\n                ;\n                    var queue = eventCBQueue[eventName];\n                    if (queue) {\n                        callInTimeslice(queue);\n                        delete eventCBQueue[eventName];\n                    }\n                ;\n                ;\n                };\n                var doEventCallbackNow = function(eventName, cb) {\n                    if (!timesliceJS) {\n                        $(JSBNG__document).one(eventName, cb);\n                        $(JSBNG__document).trigger(eventName);\n                    }\n                     else {\n                        if (eventCBQueue[eventName]) {\n                            enqueueEventCallback(eventName, cb);\n                            triggerEventCallbacks(eventName);\n                        }\n                         else {\n                            callInTimeslice(function() {\n                                cb(jQuery.JSBNG__event.fix({\n                                    type: eventName\n                                }));\n                            });\n                        }\n                    ;\n                    ;\n                    }\n                ;\n                ;\n                };\n                me.available = function(functionality, eventCallbackFunction) {\n                    if (_func_loaded[functionality]) {\n                    ;\n                        doEventCallbackNow(((functionality + \".loaded\")), eventCallbackFunction);\n                    }\n                     else {\n                        if (_loading[functionality]) {\n                        ;\n                            enqueueEventCallback(((functionality + \".loaded\")), eventCallbackFunction);\n                        }\n                         else {\n                            if (_logicalToPhysical[functionality]) {\n                            ;\n                                _loading[functionality] = true;\n                                enqueueEventCallback(((functionality + \".loaded\")), eventCallbackFunction);\n                                _loadFunctionality(functionality);\n                            }\n                             else {\n                            ;\n                                _loading[functionality] = true;\n                                enqueueEventCallback(((functionality + \".loaded\")), eventCallbackFunction);\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                    }\n                ;\n                ;\n                };\n                me.onReady = function(functionality, eventCallbackFunction) {\n                    var ajq = this;\n                    $(function() {\n                        ajq.available(functionality, eventCallbackFunction);\n                    });\n                };\n                var _stage_completed = {\n                };\n                var _fail_safe_stages = [\"amznJQ.theFold\",\"amznJQ.criticalFeature\",];\n                me.onCompletion = function(stage, callbackFn) {\n                    if (_stage_completed[stage]) {\n                    ;\n                        doEventCallbackNow(stage, callbackFn);\n                    }\n                     else {\n                    ;\n                        enqueueEventCallback(stage, callbackFn);\n                    }\n                ;\n                ;\n                };\n                me.completedStage = function(stage) {\n                    if (!_stage_completed[stage]) {\n                    ;\n                        _stage_completed[stage] = true;\n                        triggerEventCallbacks(stage);\n                    }\n                ;\n                ;\n                };\n                me.windowOnLoad = function() {\n                ;\n                    $.each(_fail_safe_stages, function() {\n                        if (!_stage_completed[this]) {\n                        ;\n                            _stage_completed[this] = true;\n                            triggerEventCallbacks(this);\n                        }\n                    ;\n                    ;\n                    });\n                };\n                (function() {\n                    var plUrls = [], lowPriUrls = [], hiPriUrls = [], isLowPriEligibleYet = false, ST = JSBNG__setTimeout, doc = JSBNG__document, docElem = doc.documentElement, styleObj = docElem.style, nav = JSBNG__navigator, isGecko = ((\"MozAppearance\" in styleObj)), isWebkit = ((!isGecko && ((\"webkitAppearance\" in styleObj)))), isSafari = ((isWebkit && ((nav.vendor.indexOf(\"Apple\") === 0)))), isIE = ((((!isGecko && !isWebkit)) && ((nav.appName.indexOf(\"Microsoft\") === 0)))), isMobile = ((nav.userAgent.indexOf(\"Mobile\") != -1)), allowedLoaders = ((((window.plCount !== undefined)) ? window.plCount() : ((((((!isMobile && ((isWebkit || isGecko)))) || ((isIE && ((typeof XDomainRequest === \"object\")))))) ? 5 : 2)))), currentLoaders = 0, timeout = 2500;\n                    function setLoadState() {\n                        if (((hiPriUrls.length > 0))) {\n                            plUrls = hiPriUrls;\n                        }\n                         else {\n                            plUrls = lowPriUrls;\n                            if (((((plUrls.length === 0)) || !isLowPriEligibleYet))) {\n                                return false;\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                        if (((currentLoaders >= allowedLoaders))) {\n                            return false;\n                        }\n                    ;\n                    ;\n                        currentLoaders++;\n                        return true;\n                    };\n                ;\n                    function loaderDone(loader, timer) {\n                        JSBNG__clearTimeout(timer);\n                        currentLoaders = ((((currentLoaders < 1)) ? 0 : ((currentLoaders - 1))));\n                        destroyLoader(loader);\n                        if (!isIE) {\n                            load();\n                        }\n                         else {\n                            ST(load, 0);\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    function destroyElement(el) {\n                        if (el) {\n                            var p = el.parentElement;\n                            if (p) {\n                                p.removeChild(el);\n                            }\n                        ;\n                        ;\n                            el = null;\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    var destroyLoader = function(loader) {\n                        if (isGecko) {\n                            JSBNG__setTimeout(function() {\n                                destroyElement(loader);\n                            }, 5);\n                        }\n                         else {\n                            destroyElement(loader);\n                        }\n                    ;\n                    ;\n                    };\n                    var load = ((!((((isIE || isGecko)) || isWebkit)) ? function() {\n                    ;\n                    } : function() {\n                        if (!setLoadState()) {\n                            return;\n                        }\n                    ;\n                    ;\n                        var url = plUrls.pop(), loader, hL = ((((plUrls === hiPriUrls)) ? \"H\" : \"L\")), timer;\n                    ;\n                        if (isGecko) {\n                            loader = doc.createElement(\"object\");\n                        }\n                         else {\n                            if (isSafari) {\n                                var end = url.indexOf(\"?\");\n                                end = ((((end > 0)) ? end : url.length));\n                                var posDot = url.lastIndexOf(\".\", end);\n                                if (posDot) {\n                                    switch (url.substring(((posDot + 1)), end).toLowerCase()) {\n                                      case \"js\":\n                                        loader = doc.createElement(\"script\");\n                                        loader.type = \"f\";\n                                        break;\n                                      case \"png\":\n                                    \n                                      case \"jpg\":\n                                    \n                                      case \"jpeg\":\n                                    \n                                      case \"gif\":\n                                        loader = new JSBNG__Image();\n                                        break;\n                                    };\n                                ;\n                                }\n                            ;\n                            ;\n                                if (!loader) {\n                                ;\n                                    loaderDone(url);\n                                    return;\n                                }\n                            ;\n                            ;\n                            }\n                             else {\n                                loader = new JSBNG__Image();\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                        loader.JSBNG__onerror = function() {\n                        ;\n                            loaderDone(loader, timer);\n                        };\n                        loader.JSBNG__onload = function() {\n                        ;\n                            loaderDone(loader, timer);\n                        };\n                        if (((isGecko || ((isSafari && ((loader.tagName == \"SCRIPT\"))))))) {\n                            timer = ST(function() {\n                            ;\n                                loaderDone(loader, timer);\n                            }, ((timeout + ((Math.JSBNG__random() * 100)))));\n                        }\n                    ;\n                    ;\n                        if (isGecko) {\n                            loader.data = url;\n                        }\n                         else {\n                            loader.src = url;\n                        }\n                    ;\n                    ;\n                        if (!isIE) {\n                            loader.width = loader.height = 0;\n                            loader.style.display = \"none\";\n                            docElem.appendChild(loader);\n                        }\n                    ;\n                    ;\n                        if (((currentLoaders < allowedLoaders))) {\n                            load();\n                        }\n                    ;\n                    ;\n                    }));\n                    function processUrlList(urlList, target) {\n                        if (((typeof (urlList) === \"string\"))) {\n                            urlList = [urlList,];\n                        }\n                         else {\n                            if (((((typeof (urlList) !== \"object\")) || ((urlList === null))))) {\n                                return;\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                        var i, u;\n                        for (i = 0; ((i < urlList.length)); i++) {\n                            u = urlList[i];\n                            if (((u && ((typeof (u) !== \"string\"))))) {\n                                processUrlList(u, target);\n                            }\n                             else {\n                                if (((u && !((u[0] == \" \"))))) {\n                                    target.splice(Math.round(((Math.JSBNG__random() * target.length))), 0, u);\n                                }\n                            ;\n                            ;\n                            }\n                        ;\n                        ;\n                        };\n                    ;\n                    };\n                ;\n                    me._getPLStat = function() {\n                        return {\n                            H: hiPriUrls.length,\n                            L: lowPriUrls.length,\n                            P: plUrls.length,\n                            CL: currentLoaders,\n                            AL: allowedLoaders\n                        };\n                    };\n                    me.addPL = function(urlList) {\n                        processUrlList(urlList, lowPriUrls);\n                        load();\n                    };\n                    me.PLNow = function(urlList) {\n                        processUrlList(urlList, hiPriUrls);\n                        load();\n                    };\n                    function triggerPagePreloads() {\n                        isLowPriEligibleYet = true;\n                        load();\n                    };\n                ;\n                    if (((typeof bootstrapAmznJQ.PLTriggerName !== \"undefined\"))) {\n                        amznJQ.available(bootstrapAmznJQ.PLTriggerName, triggerPagePreloads);\n                    }\n                     else {\n                        $(window).load(function() {\n                            ST(triggerPagePreloads, 1000);\n                        });\n                    }\n                ;\n                ;\n                }());\n                me.strings = {\n                };\n                me.chars = {\n                };\n                if (bootstrapAmznJQ) {\n                    $.extend(this.strings, bootstrapAmznJQ.strings);\n                    $.extend(this.chars, bootstrapAmznJQ.chars);\n                }\n            ;\n            ;\n            }();\n            $(window).load(function() {\n                amznJQ.windowOnLoad();\n            });\n            if (((((((window.ue && bootstrapAmznJQ)) && window.ues)) && window.uex))) {\n                ues(\"wb\", \"jQueryActive\", 1);\n                uex(\"ld\", \"jQueryActive\");\n            }\n        ;\n        ;\n            amznJQ.declareAvailable(\"JQuery\");\n            amznJQ.declareAvailable(\"jQuery\");\n            if (bootstrapAmznJQ) {\n            ;\n                $.each(bootstrapAmznJQ._l, function() {\n                    amznJQ.addLogical(this[0], this[1]);\n                });\n                $.each(bootstrapAmznJQ._s, function() {\n                    amznJQ.addStyle(this[0]);\n                });\n                $.each(bootstrapAmznJQ._d, function() {\n                    amznJQ.declareAvailable(this[0], this[1]);\n                });\n                $.each(bootstrapAmznJQ._a, function() {\n                    amznJQ.available(this[0], this[1]);\n                });\n                $.each(((bootstrapAmznJQ._t || [])), function() {\n                    callInTimeslice(this[0]);\n                });\n                $.each(bootstrapAmznJQ._o, function() {\n                    amznJQ.onReady(this[0], this[1]);\n                });\n                $.each(bootstrapAmznJQ._c, function() {\n                    amznJQ.onCompletion(this[0], this[1]);\n                });\n                $.each(bootstrapAmznJQ._cs, function() {\n                    amznJQ.completedStage(this[0], this[1]);\n                });\n                amznJQ.addPL(bootstrapAmznJQ._pl);\n            }\n        ;\n        ;\n        };\n        if (!initJQuery) {\n            initAmznJQ();\n        }\n         else {\n            if (!timesliceJS) {\n                initJQuery();\n                initAmznJQ();\n            }\n             else {\n                callInTimeslice(initJQuery);\n                callInTimeslice(initAmznJQ);\n            }\n        ;\n        ;\n        }\n    ;\n    ;\n    })();\n    (function() {\n        if (window.amznJQ) {\n            window.amznJQ.available(\"jQuery\", function() {\n                initAmazonPopover(((window.amznJQ.jQuery || window.jQuery)));\n                window.amznJQ.declareAvailable(\"popover\");\n            });\n        }\n    ;\n    ;\n        if (((((typeof window.P === \"object\")) && ((typeof window.P.when === \"function\"))))) {\n            window.P.when(\"jQuery\").register(\"legacy-popover\", function($) {\n                initAmazonPopover($);\n                return null;\n            });\n        }\n    ;\n    ;\n        function initAmazonPopover($) {\n            if (((!$ || $.AmazonPopover))) {\n                return;\n            }\n        ;\n        ;\n            var rootElement = function() {\n                var container = $(\"#ap_container\");\n                return ((((container.length && container)) || $(\"body\")));\n            };\n            var viewport = {\n                width: function() {\n                    return Math.min($(window).width(), $(JSBNG__document).width());\n                },\n                height: function() {\n                    return $(window).height();\n                }\n            };\n            var mouseTracker = function() {\n                var regions = [], n = 3, cursor = [{\n                    x: 0,\n                    y: 0\n                },], c = 0, JSBNG__scroll = [0,0,], listening = false;\n                var callbackArgs = function() {\n                    var pCursors = [];\n                    for (var i = 1; ((i < n)); i++) {\n                        pCursors.push(cursor[((((((c - i)) + n)) % n))]);\n                    };\n                ;\n                    return $.extend(true, {\n                    }, {\n                        cursor: cursor[c],\n                        priorCursors: pCursors\n                    });\n                };\n                var check = function(immediately) {\n                    for (var i = 0; ((i < regions.length)); i++) {\n                        var r = regions[i];\n                        var inside = (($.grep(r.rects, function(n) {\n                            return ((((((((cursor[c].x >= n[0])) && ((cursor[c].y >= n[1])))) && ((cursor[c].x < ((n[0] + n[2])))))) && ((cursor[c].y < ((n[1] + n[3]))))));\n                        }).length > 0));\n                        if (((((((((r.inside !== null)) && inside)) && !r.inside)) && r.mouseEnter))) {\n                            r.inside = r.mouseEnter(callbackArgs());\n                        }\n                         else {\n                            if (((((((((r.inside !== null)) && !inside)) && r.inside)) && r.mouseLeave))) {\n                                r.inside = !r.mouseLeave(immediately, callbackArgs());\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                };\n                var startListening = function() {\n                    JSBNG__scroll = [$(window).scrollLeft(),$(window).scrollTop(),];\n                    $(JSBNG__document).mousemove(function(e) {\n                        if (((typeof e.pageY !== \"undefined\"))) {\n                            c = ((((c + 1)) % n));\n                            cursor[c] = {\n                                x: e.pageX,\n                                y: e.pageY\n                            };\n                        }\n                    ;\n                    ;\n                        check();\n                    });\n                    if (!isMobileAgent(true)) {\n                        $(JSBNG__document).JSBNG__scroll(function(e) {\n                            cursor[c].x += (($(window).scrollLeft() - JSBNG__scroll[0]));\n                            cursor[c].y += (($(window).scrollTop() - JSBNG__scroll[1]));\n                            JSBNG__scroll = [$(window).scrollLeft(),$(window).scrollTop(),];\n                            check();\n                        });\n                    }\n                ;\n                ;\n                    listening = true;\n                };\n                return {\n                    add: function(rectsArray, options) {\n                        if (!listening) {\n                            startListening();\n                        }\n                    ;\n                    ;\n                        var r = $.extend({\n                            rects: rectsArray\n                        }, options);\n                        regions.push(r);\n                        return r;\n                    },\n                    remove: function(region) {\n                        for (var i = 0; ((i < regions.length)); i++) {\n                            if (((regions[i] === region))) {\n                                regions.splice(i, 1);\n                                return;\n                            }\n                        ;\n                        ;\n                        };\n                    ;\n                    },\n                    checkNow: function() {\n                        check(true);\n                    },\n                    getCallbackArgs: function() {\n                        return callbackArgs();\n                    }\n                };\n            }();\n            var iframePool = function() {\n                var ie6 = (($.browser.msie && ((parseInt($.browser.version, 10) <= 6))));\n                var src = ((ie6 ? window.AmazonPopoverImages.pixel : \"javascript:void(false)\"));\n                var HTML = ((((\"\\u003Ciframe frameborder=\\\"0\\\" tabindex=\\\"-1\\\" src=\\\"\" + src)) + \"\\\" style=\\\"display:none;position:absolute;z-index:0;filter:Alpha(Opacity='0');opacity:0;\\\" /\\u003E\"));\n                var pool = [];\n                var addToLib = function(n) {\n                    for (var i = 0; ((i < n)); i++) {\n                        pool.push($(HTML).prependTo(rootElement()));\n                    };\n                ;\n                };\n                $(JSBNG__document).ready(function() {\n                    addToLib(3);\n                });\n                return {\n                    checkout: function(jqObj) {\n                        if (!pool.length) {\n                            addToLib(1);\n                        }\n                    ;\n                    ;\n                        return pool.pop().css({\n                            display: \"block\",\n                            JSBNG__top: jqObj.offset().JSBNG__top,\n                            left: jqObj.offset().left,\n                            width: jqObj.JSBNG__outerWidth(),\n                            height: jqObj.JSBNG__outerHeight(),\n                            zIndex: ((Number(jqObj.css(\"z-index\")) - 1))\n                        });\n                    },\n                    checkin: function(iframe) {\n                        pool.push(iframe.css(\"display\", \"none\"));\n                    }\n                };\n            }();\n            var elementHidingManager = function() {\n                var hiddenElements = [];\n                var win = /Win/.test(JSBNG__navigator.platform);\n                var mac = /Mac/.test(JSBNG__navigator.platform);\n                var linux = /Linux/.test(JSBNG__navigator.platform);\n                var version = parseInt($.browser.version, 10);\n                var canOverlayWmodeWindow = false;\n                var intersectingPopovers = function(obj) {\n                    var bounds = [obj.offset().left,obj.offset().JSBNG__top,obj.JSBNG__outerWidth(),obj.JSBNG__outerHeight(),];\n                    var intersecting = [];\n                    for (var i = 0; ((i < popovers.length)); i++) {\n                        var disparate = false;\n                        if (!popovers[i].settings.modal) {\n                            var r = popovers[i].bounds;\n                            disparate = ((((((((bounds[0] > ((r[0] + r[2])))) || ((r[0] > ((bounds[0] + bounds[2])))))) || ((bounds[1] > ((r[1] + r[3])))))) || ((r[1] > ((bounds[1] + bounds[3]))))));\n                        }\n                    ;\n                    ;\n                        if (!disparate) {\n                            intersecting.push(popovers[i]);\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    return intersecting;\n                };\n                var shouldBeVisible = function(obj) {\n                    if (obj.hasClass(\"ap_never_hide\")) {\n                        return true;\n                    }\n                ;\n                ;\n                    if (intersectingPopovers(obj).length) {\n                        if (obj.is(\"object,embed\")) {\n                            var wmode = ((((((obj.attr(\"wmode\") || obj.children(\"object,embed\").attr(\"wmode\"))) || obj.parent(\"object,embed\").attr(\"wmode\"))) || \"window\"));\n                            if (((((wmode.toLowerCase() == \"window\")) && !canOverlayWmodeWindow))) {\n                                return false;\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                        if (obj.is(\"div\")) {\n                            if ($.browser.safari) {\n                                return false;\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                    }\n                ;\n                ;\n                    return true;\n                };\n                var setVisibility = function(elementQuery, shouldBecomeVisible) {\n                    if (elementQuery.is(\"iframe[id^=DA],iframe[id^=cachebust]\")) {\n                        elementQuery.css({\n                            display: ((shouldBecomeVisible ? \"block\" : \"none\"))\n                        });\n                    }\n                     else {\n                        elementQuery.css({\n                            visibility: ((shouldBecomeVisible ? \"visible\" : \"hidden\"))\n                        });\n                    }\n                ;\n                ;\n                };\n                return {\n                    update: function() {\n                        var HIDDEN = 0;\n                        var VISIBLE = 1;\n                        var stillHidden = [];\n                        for (var i = 0; ((i < hiddenElements.length)); i++) {\n                            var hiddenElement = hiddenElements[i];\n                            if (!shouldBeVisible(hiddenElement)) {\n                                stillHidden.push(hiddenElement);\n                            }\n                             else {\n                                setVisibility(hiddenElement, VISIBLE);\n                            }\n                        ;\n                        ;\n                        };\n                    ;\n                        hiddenElements = stillHidden;\n                        $(\"object:visible,embed:visible,iframe:visible\").each(function() {\n                            var obj = $(this);\n                            if (!shouldBeVisible(obj)) {\n                                hiddenElements.push(obj);\n                                setVisibility(obj, HIDDEN);\n                            }\n                        ;\n                        ;\n                        });\n                    }\n                };\n            }();\n            var applyBacking = function(popover, options) {\n                var region = null;\n                var iframe = null;\n                options = ((options || {\n                }));\n                var destroy = function() {\n                    if (region) {\n                        mouseTracker.remove(region);\n                        region = null;\n                    }\n                ;\n                ;\n                    if (iframe) {\n                        iframePool.checkin(iframe);\n                        iframe = null;\n                    }\n                ;\n                ;\n                    elementHidingManager.update();\n                };\n                var refreshBounds = function() {\n                    var newBounds = [popover.offset().left,popover.offset().JSBNG__top,popover.JSBNG__outerWidth(),popover.JSBNG__outerHeight(),];\n                    if (region) {\n                        region.rects[0] = newBounds;\n                    }\n                ;\n                ;\n                    if (iframe) {\n                        iframe.css({\n                            left: newBounds[0],\n                            JSBNG__top: newBounds[1],\n                            width: newBounds[2],\n                            height: newBounds[3]\n                        });\n                    }\n                ;\n                ;\n                    elementHidingManager.update();\n                };\n                var reposition = function(x, y) {\n                    if (iframe) {\n                        iframe.css({\n                            left: x,\n                            JSBNG__top: y\n                        });\n                    }\n                ;\n                ;\n                    if (region) {\n                        region.rects[0][0] = x;\n                        region.rects[0][1] = y;\n                    }\n                ;\n                ;\n                };\n                if (((options.useIFrame !== false))) {\n                    iframe = iframePool.checkout(popover);\n                }\n            ;\n            ;\n                var bounds = [[popover.offset().left,popover.offset().JSBNG__top,popover.JSBNG__outerWidth(),popover.JSBNG__outerHeight(),],];\n                if (options.additionalCursorRects) {\n                    for (var i = 0; ((i < options.additionalCursorRects.length)); i++) {\n                        bounds.push(options.additionalCursorRects[i]);\n                    };\n                ;\n                }\n            ;\n            ;\n                region = mouseTracker.add(bounds, options);\n                elementHidingManager.update();\n                popover.backing = {\n                    destroy: destroy,\n                    refreshBounds: refreshBounds,\n                    reposition: reposition,\n                    iframe: iframe\n                };\n            };\n            var defaultSettings = {\n                width: 500,\n                followScroll: false,\n                locationMargin: 4,\n                alignMargin: 0,\n                windowMargin: 4,\n                locationFitInWindow: true,\n                focusOnShow: true,\n                modal: false,\n                draggable: false,\n                zIndex: 200,\n                showOnHover: false,\n                hoverShowDelay: 400,\n                hoverHideDelay: 200,\n                skin: \"default\",\n                useIFrame: true,\n                clone: false,\n                ajaxSlideDuration: 400,\n                ajaxErrorContent: null,\n                paddingLeft: 17,\n                paddingRight: 17,\n                paddingBottom: 8\n            };\n            var overlay = null;\n            var popovers = [];\n            var et = {\n                MOUSE_ENTER: 1,\n                MOUSE_LEAVE: 2,\n                CLICK_TRIGGER: 4,\n                CLICK_OUTSIDE: 8,\n                fromStrings: function(s) {\n                    var flags = 0;\n                    var JSBNG__self = this;\n                    if (s) {\n                        $.each($.makeArray(s), function() {\n                            flags = ((flags | JSBNG__self[this]));\n                        });\n                    }\n                ;\n                ;\n                    return flags;\n                }\n            };\n            var ajaxCache = {\n            };\n            var preparedPopover = null;\n            var openGroupPopover = {\n            };\n            var skins = {\n                \"default\": ((((\"\\u003Cdiv class=\\\"ap_popover ap_popover_sprited\\\" surround=\\\"6,16,18,16\\\" tabindex=\\\"0\\\"\\u003E                     \\u003Cdiv class=\\\"ap_header\\\"\\u003E                         \\u003Cdiv class=\\\"ap_left\\\"/\\u003E                         \\u003Cdiv class=\\\"ap_middle\\\"/\\u003E                         \\u003Cdiv class=\\\"ap_right\\\"/\\u003E                     \\u003C/div\\u003E                     \\u003Cdiv class=\\\"ap_body\\\"\\u003E                         \\u003Cdiv class=\\\"ap_left\\\"/\\u003E                         \\u003Cdiv class=\\\"ap_content\\\"\\u003E\\u003Cimg src=\\\"\" + window.AmazonPopoverImages.snake)) + \"\\\"/\\u003E\\u003C/div\\u003E                         \\u003Cdiv class=\\\"ap_right\\\"/\\u003E                     \\u003C/div\\u003E                     \\u003Cdiv class=\\\"ap_footer\\\"\\u003E                         \\u003Cdiv class=\\\"ap_left\\\"/\\u003E                         \\u003Cdiv class=\\\"ap_middle\\\"/\\u003E                         \\u003Cdiv class=\\\"ap_right\\\"/\\u003E                     \\u003C/div\\u003E                     \\u003Cdiv class=\\\"ap_titlebar\\\"\\u003E                         \\u003Cdiv class=\\\"ap_title\\\"/\\u003E                     \\u003C/div\\u003E                     \\u003Cdiv class=\\\"ap_close\\\"\\u003E\\u003Ca href=\\\"#\\\"\\u003E\\u003Cspan class=\\\"ap_closetext\\\"/\\u003E\\u003Cspan class=\\\"ap_closebutton\\\"\\u003E\\u003Cspan\\u003E\\u003C/span\\u003E\\u003C/span\\u003E\\u003C/a\\u003E\\u003C/div\\u003E                 \\u003C/div\\u003E\")),\n                default_non_sprited: ((((((((\"\\u003Cdiv class=\\\"ap_popover ap_popover_unsprited\\\" surround=\\\"6,16,18,16\\\" tabindex=\\\"0\\\"\\u003E                     \\u003Cdiv class=\\\"ap_header\\\"\\u003E                         \\u003Cdiv class=\\\"ap_left\\\"/\\u003E                         \\u003Cdiv class=\\\"ap_middle\\\"/\\u003E                         \\u003Cdiv class=\\\"ap_right\\\"/\\u003E                     \\u003C/div\\u003E                     \\u003Cdiv class=\\\"ap_body\\\"\\u003E                         \\u003Cdiv class=\\\"ap_left\\\"/\\u003E                         \\u003Cdiv class=\\\"ap_content\\\"\\u003E\\u003Cimg src=\\\"\" + window.AmazonPopoverImages.snake)) + \"\\\"/\\u003E\\u003C/div\\u003E                         \\u003Cdiv class=\\\"ap_right\\\"/\\u003E                     \\u003C/div\\u003E                     \\u003Cdiv class=\\\"ap_footer\\\"\\u003E                         \\u003Cdiv class=\\\"ap_left\\\"/\\u003E                         \\u003Cdiv class=\\\"ap_middle\\\"/\\u003E                         \\u003Cdiv class=\\\"ap_right\\\"/\\u003E                     \\u003C/div\\u003E                     \\u003Cdiv class=\\\"ap_titlebar\\\"\\u003E                         \\u003Cdiv class=\\\"ap_title\\\"/\\u003E                     \\u003C/div\\u003E                     \\u003Cdiv class=\\\"ap_close\\\"\\u003E\\u003Ca href=\\\"#\\\"\\u003E\\u003Cspan class=\\\"ap_closetext\\\"/\\u003E\\u003Cimg border=\\\"0\\\" src=\\\"\")) + window.AmazonPopoverImages.btnClose)) + \"\\\"/\\u003E\\u003C/a\\u003E\\u003C/div\\u003E                 \\u003C/div\\u003E\")),\n                classic: ((((((((((((((((((((\"\\u003Cdiv class=\\\"ap_classic\\\"\\u003E                     \\u003Cdiv class=\\\"ap_titlebar\\\"\\u003E                         \\u003Cdiv class=\\\"ap_close\\\"\\u003E                             \\u003Cimg width=\\\"46\\\" height=\\\"16\\\" border=\\\"0\\\" alt=\\\"close\\\" onmouseup='this.src=\\\"\" + window.AmazonPopoverImages.closeTan)) + \"\\\";' onmouseout='this.src=\\\"\")) + window.AmazonPopoverImages.closeTan)) + \"\\\";' onmousedown='this.src=\\\"\")) + window.AmazonPopoverImages.closeTanDown)) + \"\\\";' src=\\\"\")) + window.AmazonPopoverImages.closeTan)) + \"\\\" /\\u003E                         \\u003C/div\\u003E                         \\u003Cspan class=\\\"ap_title\\\"\\u003E\\u003C/span\\u003E                     \\u003C/div\\u003E                     \\u003Cdiv class=\\\"ap_content\\\"\\u003E\\u003Cimg src=\\\"\")) + window.AmazonPopoverImages.loadingBar)) + \"\\\"/\\u003E\\u003C/div\\u003E                 \\u003C/div\\u003E\"))\n            };\n            var boundingRectangle = function(set) {\n                var b = {\n                    left: Infinity,\n                    JSBNG__top: Infinity,\n                    right: -Infinity,\n                    bottom: -Infinity\n                };\n                set.each(function() {\n                    try {\n                        var t = $(this);\n                        var o = t.offset();\n                        var w = t.JSBNG__outerWidth();\n                        var h = t.JSBNG__outerHeight();\n                        if (t.is(\"area\")) {\n                            var ab = boundsOfAreaElement(t);\n                            o = {\n                                left: ab[0],\n                                JSBNG__top: ab[1]\n                            };\n                            w = ((ab[2] - ab[0]));\n                            h = ((ab[3] - ab[1]));\n                        }\n                    ;\n                    ;\n                        if (((o.left < b.left))) {\n                            b.left = o.left;\n                        }\n                    ;\n                    ;\n                        if (((o.JSBNG__top < b.JSBNG__top))) {\n                            b.JSBNG__top = o.JSBNG__top;\n                        }\n                    ;\n                    ;\n                        if (((((o.left + w)) > b.right))) {\n                            b.right = ((o.left + w));\n                        }\n                    ;\n                    ;\n                        if (((((o.JSBNG__top + h)) > b.bottom))) {\n                            b.bottom = ((o.JSBNG__top + h));\n                        }\n                    ;\n                    ;\n                    } catch (e) {\n                    \n                    };\n                ;\n                });\n                return b;\n            };\n            var bringToFront = function(popover) {\n                if (((popovers.length <= 1))) {\n                    return;\n                }\n            ;\n            ;\n                var maxZ = Math.max.apply(Math, $.map(popovers, function(p) {\n                    return Number(p.css(\"z-index\"));\n                }));\n                if (((Number(popover.css(\"z-index\")) == maxZ))) {\n                    return;\n                }\n            ;\n            ;\n                popover.css(\"z-index\", ((maxZ + 2)));\n                ((popover.backing && popover.backing.iframe.css(\"z-index\", ((maxZ + 1)))));\n            };\n            $.fn.removeAmazonPopoverTrigger = function() {\n                this.unbind(\"click.amzPopover\");\n                this.unbind(\"mouseover.amzPopover\");\n                this.unbind(\"mouseout.amzPopover\");\n                return this;\n            };\n            $.fn.amazonPopoverTrigger = function(customSettings) {\n                var settings = $.extend({\n                }, defaultSettings, customSettings);\n                var triggers = this;\n                var popover = null;\n                if (((!settings.showOnHover && ((settings.skin == \"default\"))))) {\n                    this.bind(\"mouseover.amzPopover\", preparePopover);\n                }\n            ;\n            ;\n                var hoverSet;\n                if (((typeof settings.showOnHover == \"string\"))) {\n                    hoverSet = triggers.filter(settings.showOnHover);\n                }\n                 else {\n                    hoverSet = ((settings.showOnHover ? triggers : $([])));\n                }\n            ;\n            ;\n                var timerID = null;\n                hoverSet.bind(\"mouseover.amzPopover\", function(e) {\n                    if (((!popover && !timerID))) {\n                        timerID = JSBNG__setTimeout(function() {\n                            if (!popover) {\n                                var parent = triggers.parent(), length = parent.length, tagName = ((length ? ((parent.attr(\"tagName\") || parent.get(0).tagName)) : undefined));\n                                if (((length && tagName))) {\n                                    if (((!settings.triggeringEnabled || settings.triggeringEnabled.call(triggers)))) {\n                                        popover = displayPopover(settings, triggers, function() {\n                                            popover = null;\n                                        });\n                                    }\n                                ;\n                                ;\n                                }\n                            ;\n                            ;\n                            }\n                        ;\n                        ;\n                            timerID = null;\n                        }, settings.hoverShowDelay);\n                    }\n                ;\n                ;\n                    return false;\n                });\n                hoverSet.bind(\"mouseout.amzPopover\", function(e) {\n                    if (((!popover && timerID))) {\n                        JSBNG__clearTimeout(timerID);\n                        timerID = null;\n                    }\n                ;\n                ;\n                });\n                triggers.bind(\"click.amzPopover\", function(e) {\n                    var followLink = ((((settings.followLink === true)) || ((((typeof settings.followLink == \"function\")) && settings.followLink.call(triggers, popover, settings)))));\n                    if (followLink) {\n                        return true;\n                    }\n                ;\n                ;\n                    if (popover) {\n                        popover.triggerClicked();\n                    }\n                     else {\n                        if (((!settings.triggeringEnabled || settings.triggeringEnabled.call(triggers)))) {\n                            popover = displayPopover(settings, triggers, function() {\n                                popover = null;\n                            });\n                        }\n                    ;\n                    ;\n                    }\n                ;\n                ;\n                    return false;\n                });\n                this.amznPopoverHide = function() {\n                    ((popover && popover.close()));\n                };\n                this.amznPopoverVisible = function() {\n                    return !!popover;\n                };\n                return this;\n            };\n            var updateBacking = function(group) {\n                if (((group && openGroupPopover[group]))) {\n                    var popover = openGroupPopover[group];\n                    if (popover.backing) {\n                        popover.backing.refreshBounds();\n                    }\n                ;\n                ;\n                }\n            ;\n            ;\n            };\n            var displayPopover = function(settings, triggers, destroyFunction) {\n                addAliases(settings);\n                var parent = null;\n                if (triggers) {\n                    var parents = triggers.eq(0).parents().get();\n                    for (var t = 0; ((((t < parents.length)) && !parent)); t++) {\n                        for (var i = 0; ((((i < popovers.length)) && !parent)); i++) {\n                            if (((popovers[i].get(0) == parents[t]))) {\n                                parent = popovers[i];\n                            }\n                        ;\n                        ;\n                        };\n                    ;\n                    };\n                ;\n                }\n            ;\n            ;\n                var children = [];\n                children.remove = function(p) {\n                    for (var i = 0; ((i < this.length)); i++) {\n                        if (((this[i] === p))) {\n                            this.splice(i, 1);\n                            return;\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                };\n                var interactedWith = false;\n                $.each(defaultSettings, function(k, v) {\n                    if (((typeof settings[k] == \"undefined\"))) {\n                        settings[k] = v;\n                    }\n                ;\n                ;\n                });\n                if (!settings.JSBNG__location) {\n                    settings.JSBNG__location = ((((settings.modal || !triggers)) ? \"centered\" : \"auto\"));\n                }\n            ;\n            ;\n                if (((settings.showCloseButton === null))) {\n                    settings.showCloseButton = !settings.showOnHover;\n                }\n            ;\n            ;\n                $.each(popovers, function() {\n                    settings.zIndex = Math.max(settings.zIndex, ((Number(this.css(\"z-index\")) + 2)));\n                });\n                var closeEvent = ((((settings.showOnHover ? et.MOUSE_LEAVE : et.CLICK_TRIGGER)) | ((settings.modal ? et.CLICK_OUTSIDE : 0))));\n                closeEvent = ((((closeEvent | et.fromStrings(settings.closeEventInclude))) & ~et.fromStrings(settings.closeEventExclude)));\n                var clickAwayHandler;\n                var reposition = function() {\n                    position(popover, settings, triggers);\n                };\n                var close = function() {\n                    if (settings.group) {\n                        openGroupPopover[settings.group] = null;\n                    }\n                ;\n                ;\n                    if (((original && original.parents(\"body\").length))) {\n                        if (((ballMarker && ballMarker.parents(\"body\").length))) {\n                            original.hide().insertAfter(ballMarker);\n                            ballMarker.remove();\n                            ballMarker = null;\n                        }\n                         else {\n                            original.hide().appendTo(rootElement());\n                        }\n                    ;\n                    ;\n                    }\n                ;\n                ;\n                    if (((original != popover))) {\n                        popover.remove();\n                    }\n                ;\n                ;\n                    if (parent) {\n                        parent.children.remove(popover);\n                    }\n                ;\n                ;\n                    for (var i = 0; ((i < popovers.length)); i++) {\n                        if (((popovers[i] === popover))) {\n                            popovers.splice(i, 1);\n                            break;\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    if (popover.backing) {\n                        popover.backing.destroy();\n                        popover.backing = null;\n                    }\n                ;\n                ;\n                    mouseTracker.checkNow();\n                    if (destroyFunction) {\n                        destroyFunction();\n                    }\n                ;\n                ;\n                    if (settings.onHide) {\n                        settings.onHide.call(triggers, popover, settings);\n                    }\n                ;\n                ;\n                    if (((settings.modal && overlay))) {\n                        if (overlay.fitToScreen) {\n                            $(window).unbind(\"resize\", overlay.fitToScreen);\n                        }\n                    ;\n                    ;\n                        overlay.remove();\n                        overlay = null;\n                    }\n                ;\n                ;\n                    $(JSBNG__document).unbind(\"JSBNG__scroll.AmazonPopover\");\n                    $(JSBNG__document).unbind(\"click\", clickAwayHandler);\n                    for (var i = 0; ((i < children.length)); i++) {\n                        children[i].close();\n                    };\n                ;\n                    children = [];\n                    return false;\n                };\n                var fill = function(JSBNG__content, autoshow) {\n                    var container = popover.JSBNG__find(\".ap_sub_content\");\n                    if (((container.length === 0))) {\n                        container = popover.JSBNG__find(\".ap_content\");\n                    }\n                ;\n                ;\n                    if (((typeof JSBNG__content == \"string\"))) {\n                        container.html(JSBNG__content);\n                    }\n                     else {\n                        container.empty().append(JSBNG__content);\n                    }\n                ;\n                ;\n                    if (((((typeof settings.autoshow == \"boolean\")) ? settings.autoshow : autoshow))) {\n                        if ($.browser.msie) {\n                            container.children().show().hide();\n                        }\n                    ;\n                    ;\n                        container.children(\":not(style)\").show();\n                    }\n                ;\n                ;\n                    container.JSBNG__find(\".ap_custom_close\").click(close);\n                    if (settings.onFilled) {\n                        settings.onFilled.call(triggers, popover, settings);\n                    }\n                ;\n                ;\n                    return container;\n                };\n                if (((settings.modal && !overlay))) {\n                    overlay = showOverlay(close, settings.zIndex);\n                }\n            ;\n            ;\n                var popover = null;\n                var original = null;\n                var ballMarker = null;\n                if (((settings.skin == \"default\"))) {\n                    preparePopover();\n                    popover = preparedPopover;\n                    preparedPopover = null;\n                }\n                 else {\n                    var skin = (($.isFunction(settings.skin) ? settings.skin() : settings.skin));\n                    skin = ((skin || \"\\u003Cdiv\\u003E\\u003Cdiv class='ap_content' /\\u003E\\u003C/div\\u003E\"));\n                    var skinIsHtml = /^[^<]*(<(.|\\s)+>)[^>]*$/.test(skin);\n                    var skinHtml = ((skinIsHtml ? skin : skins[skin]));\n                    popover = $(skinHtml);\n                }\n            ;\n            ;\n                if ((($.browser.msie && ((parseInt($.browser.version, 10) == 6))))) {\n                    fixPngs(popover);\n                }\n            ;\n            ;\n                if (((settings.skin == \"default\"))) {\n                    popover.JSBNG__find(\".ap_content\").css({\n                        paddingLeft: settings.paddingLeft,\n                        paddingRight: settings.paddingRight,\n                        paddingBottom: settings.paddingBottom\n                    });\n                }\n            ;\n            ;\n                if (settings.localContent) {\n                    if (settings.clone) {\n                        fill($(settings.localContent).clone(true), true);\n                    }\n                     else {\n                        original = $(settings.localContent);\n                        ballMarker = $(\"\\u003Cspan style='display:none' /\\u003E\").insertBefore(original);\n                        fill(original, true);\n                    }\n                ;\n                ;\n                }\n                 else {\n                    if (settings.literalContent) {\n                        fill(settings.literalContent);\n                    }\n                ;\n                ;\n                }\n            ;\n            ;\n                if (settings.destination) {\n                    var destinationUrl = ((((typeof settings.destination == \"function\")) ? settings.destination() : settings.destination));\n                    if (((((settings.cacheable !== false)) && ajaxCache[destinationUrl]))) {\n                        fill(ajaxCache[destinationUrl]);\n                    }\n                     else {\n                        $.ajax({\n                            url: destinationUrl,\n                            timeout: settings.ajaxTimeout,\n                            success: function(data) {\n                                if (settings.onAjaxSuccess) {\n                                    settings.onAjaxSuccess.apply(settings, arguments);\n                                }\n                            ;\n                            ;\n                                var contentCacheable = ((data.match(/^(\\s|<!--[\\s\\S]*?-->)*<\\w+[^>]*\\s+cacheable=\"(.*?)\"/i) || data.match(/^(\\s|<!--[\\s\\S]*?-->)*<\\w+[^>]*\\s+cacheable='(.*?)'/i)));\n                                if (((((settings.cacheable !== false)) && ((!contentCacheable || ((contentCacheable[2] !== \"0\"))))))) {\n                                    ajaxCache[destinationUrl] = data;\n                                }\n                            ;\n                            ;\n                                var title = ((data.match(/^(\\s|<!--[\\s\\S]*?-->)*<\\w+[^>]*\\s+popoverTitle=\"(.*?)\"/i) || data.match(/^(\\s|<!--[\\s\\S]*?-->)*<\\w+[^>]*\\s+popoverTitle='(.*?)'/i)));\n                                if (title) {\n                                    settings.title = title[2];\n                                    popover.JSBNG__find(\".ap_title\").html(settings.title);\n                                }\n                            ;\n                            ;\n                                if (((((settings.ajaxSlideDuration > 0)) && !(($.browser.msie && ((JSBNG__document.compatMode == \"BackCompat\"))))))) {\n                                    popover.JSBNG__find(\".ap_content\").hide();\n                                    fill(data);\n                                    if (!settings.width) {\n                                        position(popover, settings, triggers);\n                                    }\n                                ;\n                                ;\n                                    if (settings.onAjaxShow) {\n                                        settings.onAjaxShow.call(triggers, popover, settings);\n                                    }\n                                ;\n                                ;\n                                    popover.JSBNG__find(\".ap_content\").slideDown(settings.ajaxSlideDuration, function() {\n                                        position(popover, settings, triggers);\n                                    });\n                                }\n                                 else {\n                                    fill(data);\n                                    if (settings.onAjaxShow) {\n                                        settings.onAjaxShow.call(triggers, popover, settings);\n                                    }\n                                ;\n                                ;\n                                    position(popover, settings, triggers);\n                                }\n                            ;\n                            ;\n                            },\n                            error: function() {\n                                var data = null;\n                                if (((typeof settings.ajaxErrorContent == \"function\"))) {\n                                    data = settings.ajaxErrorContent.apply(settings, arguments);\n                                }\n                                 else {\n                                    data = settings.ajaxErrorContent;\n                                }\n                            ;\n                            ;\n                                if (((data !== null))) {\n                                    var container = fill(data);\n                                    var title = container.children(\"[popoverTitle]\").attr(\"popoverTitle\");\n                                    if (title) {\n                                        popover.JSBNG__find(\".ap_title\").html(title);\n                                    }\n                                ;\n                                ;\n                                    position(popover, settings, triggers);\n                                }\n                            ;\n                            ;\n                            }\n                        });\n                    }\n                ;\n                ;\n                }\n            ;\n            ;\n                if (((((!settings.localContent && !settings.literalContent)) && !settings.destination))) {\n                    throw (\"AmazonPopover wasn't provided a source of content.\");\n                }\n            ;\n            ;\n                if (parent) {\n                    parent.children.push(popover);\n                }\n            ;\n            ;\n                settings.surround = $.map(((popover.attr(\"surround\") || \"0,0,0,0\")).split(\",\"), function(n) {\n                    return Number(n);\n                });\n                popover.css({\n                    zIndex: settings.zIndex,\n                    position: \"absolute\",\n                    left: -2000,\n                    JSBNG__top: -2000\n                });\n                popover.click(function(e) {\n                    if (!e.metaKey) {\n                        e.stopPropagation();\n                    }\n                ;\n                ;\n                    interactedWith = true;\n                });\n                clickAwayHandler = function(e) {\n                    var leftButton = ((((e.button === 0)) || ((e.which == 1))));\n                    if (((leftButton && !e.metaKey))) {\n                        close();\n                    }\n                ;\n                ;\n                };\n                if (((closeEvent & et.CLICK_OUTSIDE))) {\n                    $(JSBNG__document).click(clickAwayHandler);\n                }\n            ;\n            ;\n                popover.mousedown(function(e) {\n                    if (!children.length) {\n                        bringToFront(popover);\n                    }\n                ;\n                ;\n                });\n                var width = ((settings.width && ((((typeof settings.width == \"function\")) ? settings.width() : settings.width))));\n                if (!width) {\n                    width = ((getDynamicWidth(popover, settings) || popover.JSBNG__outerWidth()));\n                }\n            ;\n            ;\n                if (width) {\n                    popover.css(\"width\", width);\n                }\n            ;\n            ;\n                if (settings.followScroll) {\n                    $(JSBNG__document).bind(\"JSBNG__scroll.AmazonPopover\", function(e) {\n                        settings.followScroll(e);\n                    });\n                }\n            ;\n            ;\n                if (((((settings.title !== null)) && ((settings.title !== undefined))))) {\n                    var titleBar = popover.JSBNG__find(\".ap_titlebar\");\n                    if (((settings.skin == \"default\"))) {\n                        titleBar.css({\n                            width: ((width - 36))\n                        });\n                        titleBar.JSBNG__find(\".ap_title\").css(\"width\", ((width - 70)));\n                        popover.JSBNG__find(\".ap_content\").css({\n                            paddingTop: 18\n                        });\n                    }\n                ;\n                ;\n                    popover.JSBNG__find(\".ap_title\").html(settings.title);\n                    if (((settings.draggable && !settings.modal))) {\n                        enableDragAndDrop(titleBar, popover);\n                    }\n                ;\n                ;\n                    titleBar.show();\n                    if (((((settings.skin == \"default\")) && settings.wrapTitlebar))) {\n                        titleBar.addClass(\"multiline\");\n                        popover.JSBNG__find(\".ap_content\").css({\n                            paddingTop: ((titleBar.JSBNG__outerHeight() - 9))\n                        });\n                    }\n                ;\n                ;\n                }\n                 else {\n                    popover.JSBNG__find(\".ap_titlebar\").hide();\n                }\n            ;\n            ;\n                if (((settings.showCloseButton !== false))) {\n                    popover.JSBNG__find(\".ap_close\").show().click(close).mousedown(function(e) {\n                        e.preventDefault();\n                        e.stopPropagation();\n                        return false;\n                    }).css(\"cursor\", \"default\");\n                    if (!settings.title) {\n                        popover.JSBNG__find(\".ap_content\").css({\n                            paddingTop: 10\n                        });\n                    }\n                ;\n                ;\n                    popover.keydown(function(e) {\n                        if (((e.keyCode == 27))) {\n                            close();\n                        }\n                    ;\n                    ;\n                    });\n                }\n                 else {\n                    popover.JSBNG__find(\".ap_close\").css(\"display\", \"none\");\n                }\n            ;\n            ;\n                if (settings.closeText) {\n                    popover.JSBNG__find(\".ap_closetext\").text(settings.closeText).show();\n                }\n                 else {\n                    popover.JSBNG__find(\".ap_closebutton span\").text(\"Close\");\n                }\n            ;\n            ;\n                popover.appendTo(rootElement());\n                position(popover, settings, triggers);\n                $(JSBNG__document.activeElement).filter(\"input[type=text], select\").JSBNG__blur();\n                popover.close = close;\n                if (settings.group) {\n                    if (openGroupPopover[settings.group]) {\n                        openGroupPopover[settings.group].close();\n                    }\n                ;\n                ;\n                    openGroupPopover[settings.group] = popover;\n                }\n            ;\n            ;\n                popover.show();\n                if (settings.focusOnShow) {\n                    popover.get(0).hideFocus = true;\n                    popover.JSBNG__focus();\n                }\n            ;\n            ;\n                if (((overlay && overlay.snapToLeft))) {\n                    overlay.snapToLeft();\n                }\n            ;\n            ;\n                if (settings.onShow) {\n                    settings.onShow.call(triggers, popover, settings);\n                }\n            ;\n            ;\n                popover.bounds = [popover.offset().left,popover.offset().JSBNG__top,popover.JSBNG__outerWidth(),popover.JSBNG__outerHeight(),];\n                popovers.push(popover);\n                popover.reposition = reposition;\n                popover.close = close;\n                popover.settings = settings;\n                popover.triggerClicked = function() {\n                    if (((closeEvent & et.CLICK_TRIGGER))) {\n                        close();\n                    }\n                ;\n                ;\n                };\n                popover.children = children;\n                if (((closeEvent & et.MOUSE_LEAVE))) {\n                    var timerID = null;\n                    var triggerRects = [];\n                    $.each(triggers, function() {\n                        var n = $(this);\n                        if (n.is(\"area\")) {\n                            var b = boundsOfAreaElement(n);\n                            triggerRects.push([b[0],b[1],((b[2] - b[0])),((b[3] - b[1])),]);\n                        }\n                         else {\n                            triggerRects.push([n.offset().left,n.offset().JSBNG__top,n.JSBNG__outerWidth(),n.JSBNG__outerHeight(),]);\n                        }\n                    ;\n                    ;\n                    });\n                    if (settings.additionalCursorRects) {\n                        $(settings.additionalCursorRects).each(function() {\n                            var n = $(this);\n                            triggerRects.push([n.offset().left,n.offset().JSBNG__top,n.JSBNG__outerWidth(),n.JSBNG__outerHeight(),]);\n                        });\n                    }\n                ;\n                ;\n                    applyBacking(popover, {\n                        solidRectangle: settings.solidRectangle,\n                        useIFrame: settings.useIFrame,\n                        mouseEnter: function() {\n                            if (timerID) {\n                                JSBNG__clearTimeout(timerID);\n                                timerID = null;\n                            }\n                        ;\n                        ;\n                            return true;\n                        },\n                        mouseLeave: function(immediately) {\n                            if (((settings.semiStatic && interactedWith))) {\n                                return !children.length;\n                            }\n                        ;\n                        ;\n                            if (timerID) {\n                                JSBNG__clearTimeout(timerID);\n                                timerID = null;\n                            }\n                        ;\n                        ;\n                            if (((children.length === 0))) {\n                                if (immediately) {\n                                    close();\n                                }\n                                 else {\n                                    timerID = JSBNG__setTimeout(function() {\n                                        close();\n                                        timerID = null;\n                                    }, settings.hoverHideDelay);\n                                }\n                            ;\n                            ;\n                                return true;\n                            }\n                        ;\n                        ;\n                            return false;\n                        },\n                        additionalCursorRects: triggerRects,\n                        inside: true\n                    });\n                }\n                 else {\n                    applyBacking(popover, {\n                        solidRectangle: settings.solidRectangle,\n                        useIFrame: settings.useIFrame\n                    });\n                }\n            ;\n            ;\n                $(function() {\n                    for (var i = 0; ((i < popovers.length)); i++) {\n                        if (popovers[i].settings.modal) {\n                            popovers[i].backing.refreshBounds();\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                });\n                return popover;\n            };\n            var isMobileAgent = function(inclusive) {\n                var reAry = [\"iPhone\",\"iPad\",];\n                if (inclusive) {\n                    reAry.push(\"Silk/\", \"Kindle Fire\", \"Android\", \"\\\\bTouch\\\\b\");\n                }\n            ;\n            ;\n                var reStr = ((((\"(\" + reAry.join(\"|\"))) + \")\"));\n                return JSBNG__navigator.userAgent.match(new RegExp(reStr, \"i\"));\n            };\n            var getPageWidth = function() {\n                return (($.browser.msie ? $(window).width() : \"100%\"));\n            };\n            var getPageHeight = function() {\n                return (((($.browser.msie || isMobileAgent())) ? $(JSBNG__document).height() : \"100%\"));\n            };\n            var showOverlay = function(closeFunction, z) {\n                var overlay = $(\"\\u003Cdiv id=\\\"ap_overlay\\\"/\\u003E\");\n                if ($.browser.msie) {\n                    overlay.fitToScreen = function(e) {\n                        var windowHeight = $(JSBNG__document).height();\n                        var windowWidth = $(window).width();\n                        var children = overlay.children();\n                        overlay.css({\n                            width: windowWidth,\n                            height: windowHeight,\n                            backgroundColor: \"transparent\",\n                            zIndex: z\n                        });\n                        var appendElements = [];\n                        for (var i = 0; ((((i < children.size())) || ((((windowHeight - ((i * 2000)))) > 0)))); i++) {\n                            var paneHeight = Math.min(((windowHeight - ((i * 2000)))), 2000);\n                            if (((paneHeight > 0))) {\n                                if (((i < children.size()))) {\n                                    children.eq(i).css({\n                                        width: windowWidth,\n                                        height: paneHeight\n                                    });\n                                }\n                                 else {\n                                    var slice = $(\"\\u003Cdiv/\\u003E\").css({\n                                        opacity: 95441,\n                                        zIndex: z,\n                                        width: windowWidth,\n                                        height: paneHeight,\n                                        JSBNG__top: ((i * 2000))\n                                    });\n                                    appendElements.push(slice[0]);\n                                }\n                            ;\n                            ;\n                            }\n                             else {\n                                children.eq(i).remove();\n                            }\n                        ;\n                        ;\n                        };\n                    ;\n                        if (appendElements.length) {\n                            overlay.append(appendElements);\n                        }\n                    ;\n                    ;\n                    };\n                    overlay.snapToLeft = function() {\n                        overlay.css(\"left\", $(JSBNG__document).scrollLeft());\n                    };\n                    $(window).bind(\"resize load\", overlay.fitToScreen);\n                    $(window).JSBNG__scroll(overlay.snapToLeft);\n                    overlay.snapToLeft();\n                    overlay.fitToScreen();\n                }\n                 else {\n                    overlay.css({\n                        width: getPageWidth(),\n                        height: getPageHeight(),\n                        position: (((($.browser.mozilla || $.browser.safari)) ? \"fixed\" : \"\")),\n                        opacity: 95975,\n                        zIndex: z\n                    });\n                }\n            ;\n            ;\n                return overlay.appendTo(rootElement());\n            };\n            var HEADER_HEIGHT = 45;\n            var FOOTER_HEIGHT = 35;\n            var VERT_ARROW_OFFSET = 327;\n            var LEFT_ARROW_OFFSET = 0;\n            var RIGHT_ARROW_OFFSET = -51;\n            var attachedPositioning = function(popover, targetY, JSBNG__location, position, offset) {\n                if (popover.hasClass(\"ap_popover_sprited\")) {\n                    var dist = ((((targetY - JSBNG__location.JSBNG__top)) - offset[1]));\n                    if (((dist < HEADER_HEIGHT))) {\n                        dist = HEADER_HEIGHT;\n                    }\n                     else {\n                        if (((dist > ((popover.JSBNG__outerHeight() - FOOTER_HEIGHT))))) {\n                            dist = ((popover.JSBNG__outerHeight() - FOOTER_HEIGHT));\n                        }\n                    ;\n                    ;\n                    }\n                ;\n                ;\n                    var attachingSide = ((((position == \"left\")) ? \"right\" : \"left\"));\n                    var elm = popover.JSBNG__find(((\".ap_body .ap_\" + attachingSide)));\n                    if (((elm.length > 0))) {\n                        elm.removeClass(((\"ap_\" + attachingSide))).addClass(((((\"ap_\" + attachingSide)) + \"-arrow\")));\n                    }\n                     else {\n                        elm = popover.JSBNG__find(((((\".ap_body .ap_\" + attachingSide)) + \"-arrow\")));\n                    }\n                ;\n                ;\n                    var xOffset = ((((attachingSide == \"left\")) ? LEFT_ARROW_OFFSET : RIGHT_ARROW_OFFSET));\n                    elm.css(\"backgroundPosition\", ((((((xOffset + \"px \")) + ((dist - VERT_ARROW_OFFSET)))) + \"px\")));\n                }\n            ;\n            ;\n            };\n            var position = function(popover, settings, triggers) {\n                if (!settings.width) {\n                    popover.css(\"width\", getDynamicWidth(popover, settings));\n                }\n            ;\n            ;\n                var offset = ((settings.locationOffset || [0,0,]));\n                var JSBNG__location;\n                if (((typeof settings.JSBNG__location == \"function\"))) {\n                    JSBNG__location = settings.JSBNG__location.call(triggers, popover, settings);\n                }\n                 else {\n                    var names = $.map($.makeArray(settings.JSBNG__location), function(n) {\n                        return ((((n == \"auto\")) ? [\"bottom\",\"left\",\"right\",\"JSBNG__top\",] : n));\n                    });\n                    var set = ((((settings.locationElement && $(settings.locationElement))) || triggers));\n                    var b = ((set && boundingRectangle(set)));\n                    JSBNG__location = locationFunction[names[0]](b, popover, settings);\n                    var index = 0;\n                    for (var i = 1; ((((i < names.length)) && !JSBNG__location.fits)); i++) {\n                        var next = locationFunction[names[i]](b, popover, settings);\n                        if (next.fits) {\n                            JSBNG__location = next;\n                            index = i;\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    if (((settings.attached && ((((names[index] == \"left\")) || ((names[index] == \"right\"))))))) {\n                        attachedPositioning(popover, ((((b.JSBNG__top + b.bottom)) / 2)), JSBNG__location, names[index], offset);\n                    }\n                ;\n                ;\n                }\n            ;\n            ;\n                popover.css({\n                    left: ((JSBNG__location.left + offset[0])),\n                    JSBNG__top: ((JSBNG__location.JSBNG__top + offset[1])),\n                    margin: JSBNG__location.margin,\n                    right: JSBNG__location.right\n                });\n                if (popover.backing) {\n                    popover.backing.refreshBounds();\n                }\n            ;\n            ;\n            };\n            var horizPosition = function(b, popover, settings) {\n                var align = $.makeArray(((settings.align || \"left\")));\n                var x = {\n                    min: (((($(JSBNG__document).scrollLeft() + settings.windowMargin)) - settings.surround[3])),\n                    max: ((((((viewport.width() + $(JSBNG__document).scrollLeft())) - settings.windowMargin)) - popover.JSBNG__outerWidth())),\n                    left: ((((b.left - settings.surround[3])) - settings.alignMargin)),\n                    right: ((((((b.right - popover.JSBNG__outerWidth())) + settings.surround[1])) + settings.alignMargin)),\n                    center: ((((((b.left + b.right)) - popover.JSBNG__outerWidth())) / 2))\n                };\n                var align = $.grep($.makeArray(settings.align), function(n) {\n                    return x[n];\n                });\n                if (((align.length === 0))) {\n                    align.push(\"left\");\n                }\n            ;\n            ;\n                for (var i = 0; ((i < align.length)); i++) {\n                    if (((((x[align[i]] >= x.min)) && ((x[align[i]] <= x.max))))) {\n                        return x[align[i]];\n                    }\n                ;\n                ;\n                };\n            ;\n                if (settings.forceAlignment) {\n                    return x[align[0]];\n                }\n            ;\n            ;\n                if (((x.min > x.max))) {\n                    return x.min;\n                }\n            ;\n            ;\n                return ((((x[align[0]] < x.min)) ? x.min : x.max));\n            };\n            var vertPosition = function(b, popover, settings) {\n                var min = (($(JSBNG__document).scrollTop() + settings.windowMargin));\n                var max = ((((viewport.height() + $(JSBNG__document).scrollTop())) - settings.windowMargin));\n                if (settings.attached) {\n                    var midpoint = ((((b.JSBNG__top + b.bottom)) / 2));\n                    if (((((midpoint - HEADER_HEIGHT)) < min))) {\n                        min = ((((((min + HEADER_HEIGHT)) < b.bottom)) ? min : ((b.bottom - HEADER_HEIGHT))));\n                    }\n                ;\n                ;\n                    if (((((midpoint + FOOTER_HEIGHT)) > max))) {\n                        max = ((((((max - FOOTER_HEIGHT)) > b.JSBNG__top)) ? max : ((b.JSBNG__top + FOOTER_HEIGHT))));\n                    }\n                ;\n                ;\n                }\n                 else {\n                    min = Math.min(((b.JSBNG__top - settings.alignMargin)), min);\n                    max = Math.max(((b.bottom + settings.alignMargin)), max);\n                }\n            ;\n            ;\n                var y = {\n                    min: ((min - settings.surround[0])),\n                    max: ((((max - popover.JSBNG__outerHeight())) + settings.surround[2])),\n                    JSBNG__top: ((((b.JSBNG__top - settings.surround[0])) - settings.alignMargin)),\n                    bottom: ((((((b.bottom - popover.JSBNG__outerHeight())) + settings.alignMargin)) + settings.surround[2])),\n                    middle: ((((((b.JSBNG__top + b.bottom)) - popover.JSBNG__outerHeight())) / 2))\n                };\n                var align = $.grep($.makeArray(settings.align), function(n) {\n                    return y[n];\n                });\n                if (((align.length === 0))) {\n                    align.push(\"JSBNG__top\");\n                }\n            ;\n            ;\n                for (var i = 0; ((i < align.length)); i++) {\n                    if (((((y[align[i]] >= y.min)) && ((y[align[i]] <= y.max))))) {\n                        return y[align[i]];\n                    }\n                ;\n                ;\n                };\n            ;\n                if (settings.forceAlignment) {\n                    return y[align[0]];\n                }\n            ;\n            ;\n                if (((y.min > y.max))) {\n                    return y.min;\n                }\n            ;\n            ;\n                return ((((y[align[0]] < y.min)) ? y.min : y.max));\n            };\n            var locationFunction = {\n                centered: function(b, popover, settings) {\n                    var y = (($(window).scrollTop() + 100));\n                    return {\n                        left: -((popover.JSBNG__outerWidth() / 2)),\n                        right: 0,\n                        JSBNG__top: y,\n                        margin: \"0% 50%\",\n                        fits: true\n                    };\n                },\n                JSBNG__top: function(b, popover, settings) {\n                    var room = ((((b.JSBNG__top - $(JSBNG__document).scrollTop())) - ((settings.locationMargin * 2))));\n                    var triggerInView = ((((b.left >= $(JSBNG__document).scrollLeft())) && ((b.right < ((viewport.width() + $(JSBNG__document).scrollLeft()))))));\n                    return {\n                        left: horizPosition(b, popover, settings),\n                        JSBNG__top: ((((((b.JSBNG__top - popover.JSBNG__outerHeight())) - settings.locationMargin)) + settings.surround[2])),\n                        fits: ((triggerInView && ((room >= ((((popover.JSBNG__outerHeight() - settings.surround[0])) - settings.surround[2]))))))\n                    };\n                },\n                left: function(b, popover, settings) {\n                    var room = ((((b.left - $(JSBNG__document).scrollLeft())) - ((settings.locationMargin * 2))));\n                    return {\n                        left: ((((((b.left - popover.JSBNG__outerWidth())) - settings.locationMargin)) + settings.surround[1])),\n                        JSBNG__top: vertPosition(b, popover, settings),\n                        fits: ((room >= ((((popover.JSBNG__outerWidth() - settings.surround[1])) - settings.surround[3]))))\n                    };\n                },\n                bottom: function(b, popover, settings) {\n                    var room = ((((((viewport.height() + $(JSBNG__document).scrollTop())) - b.bottom)) - ((settings.locationMargin * 2))));\n                    var triggerInView = ((((b.left >= $(JSBNG__document).scrollLeft())) && ((b.right < ((viewport.width() + $(JSBNG__document).scrollLeft()))))));\n                    return {\n                        left: horizPosition(b, popover, settings),\n                        JSBNG__top: ((((b.bottom + settings.locationMargin)) - settings.surround[0])),\n                        fits: ((triggerInView && ((room >= ((((popover.JSBNG__outerHeight() - settings.surround[0])) - settings.surround[2]))))))\n                    };\n                },\n                right: function(b, popover, settings) {\n                    var room = ((((((viewport.width() + $(JSBNG__document).scrollLeft())) - b.right)) - ((settings.locationMargin * 2))));\n                    return {\n                        left: ((((b.right + settings.locationMargin)) - settings.surround[3])),\n                        JSBNG__top: vertPosition(b, popover, settings),\n                        fits: ((room >= ((((popover.JSBNG__outerWidth() - settings.surround[1])) - settings.surround[3]))))\n                    };\n                },\n                over: function(b, popover, settings) {\n                    var alignTo = popover.JSBNG__find(((settings.align || \".ap_content *\"))).offset();\n                    var corner = popover.offset();\n                    var padding = {\n                        left: ((alignTo.left - corner.left)),\n                        JSBNG__top: ((alignTo.JSBNG__top - corner.JSBNG__top))\n                    };\n                    var left = ((b.left - padding.left));\n                    var JSBNG__top = ((b.JSBNG__top - padding.JSBNG__top));\n                    var adjustedLeft = Math.min(left, ((((((viewport.width() + $(JSBNG__document).scrollLeft())) - popover.JSBNG__outerWidth())) - settings.windowMargin)));\n                    adjustedLeft = Math.max(adjustedLeft, (((($(JSBNG__document).scrollLeft() - settings.surround[3])) + settings.windowMargin)));\n                    var adjustedTop = Math.min(JSBNG__top, ((((((((viewport.height() + $(JSBNG__document).scrollTop())) - popover.JSBNG__outerHeight())) + settings.surround[2])) - settings.windowMargin)));\n                    adjustedTop = Math.max(adjustedTop, (((($(JSBNG__document).scrollTop() - settings.surround[0])) + settings.windowMargin)));\n                    return {\n                        left: ((settings.forceAlignment ? left : adjustedLeft)),\n                        JSBNG__top: ((settings.forceAlignment ? JSBNG__top : adjustedTop)),\n                        fits: ((((left == adjustedLeft)) && ((JSBNG__top == adjustedTop))))\n                    };\n                }\n            };\n            var addAliases = function(settings) {\n                settings.align = ((settings.align || settings.locationAlign));\n                settings.literalContent = ((settings.literalContent || settings.loadingContent));\n            };\n            var preparePopover = function() {\n                if (!preparedPopover) {\n                    var ie6 = (($.browser.msie && ((parseInt($.browser.version, 10) <= 6))));\n                    preparedPopover = $(skins[((ie6 ? \"default_non_sprited\" : \"default\"))]).css({\n                        left: -2000,\n                        JSBNG__top: -2000\n                    }).appendTo(rootElement());\n                }\n            ;\n            ;\n            };\n            var fixPngs = function(obj) {\n                obj.JSBNG__find(\"*\").each(function() {\n                    var match = (($(this).css(\"background-image\") || \"\")).match(/url\\(\"(.*\\.png)\"\\)/);\n                    if (match) {\n                        var png = match[1];\n                        $(this).css(\"background-image\", \"none\");\n                        $(this).get(0).runtimeStyle.filter = ((((\"progid:DXImageTransform.Microsoft.AlphaImageLoader(src='\" + png)) + \"',sizingMethod='scale')\"));\n                    }\n                ;\n                ;\n                });\n            };\n            var getDynamicWidth = function(popover, settings) {\n                var container = popover.JSBNG__find(\".ap_content\");\n                if (((((settings.skin == \"default\")) && ((container.length > 0))))) {\n                    var tempNode = $(((((\"\\u003Cdiv class=\\\"ap_temp\\\"\\u003E\" + container.html())) + \"\\u003C/div\\u003E\")));\n                    tempNode.css({\n                        display: \"inline\",\n                        position: \"absolute\",\n                        JSBNG__top: -9999,\n                        left: -9999\n                    });\n                    rootElement().append(tempNode);\n                    var marginLeft = ((parseInt(container.parent().css(\"margin-left\"), 10) || 0));\n                    var marginRight = ((parseInt(container.parent().css(\"margin-right\"), 10) || 0));\n                    var width = ((((((((((tempNode.width() + marginLeft)) + marginRight)) + settings.paddingLeft)) + settings.paddingRight)) + 2));\n                    if (((((width % 2)) !== 0))) {\n                        width++;\n                    }\n                ;\n                ;\n                    tempNode.remove();\n                    return Math.min(width, viewport.width());\n                }\n            ;\n            ;\n                return null;\n            };\n            var enableDragAndDrop = function(titlebar, popover) {\n                titlebar.css(\"cursor\", \"move\");\n                disableSelect(titlebar.get(0));\n                titlebar.mousedown(function(e) {\n                    e.preventDefault();\n                    disableSelect(JSBNG__document.body);\n                    var offset = [((e.pageX - popover.offset().left)),((e.pageY - popover.offset().JSBNG__top)),];\n                    var mousemove = function(e) {\n                        e.preventDefault();\n                        popover.css({\n                            left: ((e.pageX - offset[0])),\n                            JSBNG__top: ((e.pageY - offset[1])),\n                            margin: 0\n                        });\n                        if (popover.backing) {\n                            popover.backing.reposition(((e.pageX - offset[0])), ((e.pageY - offset[1])));\n                        }\n                    ;\n                    ;\n                    };\n                    var mouseup = function(e) {\n                        popover.JSBNG__focus();\n                        enableSelect(JSBNG__document.body);\n                        $(JSBNG__document).unbind(\"mousemove\", mousemove);\n                        $(JSBNG__document).unbind(\"mouseup\", mouseup);\n                    };\n                    $(JSBNG__document).mousemove(mousemove).mouseup(mouseup);\n                });\n            };\n            var disableSelect = function(e) {\n                if (e) {\n                    e.onselectstart = function(e) {\n                        return false;\n                    };\n                    e.style.MozUserSelect = \"none\";\n                }\n            ;\n            ;\n            };\n            var enableSelect = function(e) {\n                if (e) {\n                    e.onselectstart = function(e) {\n                        return true;\n                    };\n                    e.style.MozUserSelect = \"\";\n                }\n            ;\n            ;\n            };\n            var boundsOfAreaElement = function(area) {\n                area = $(area);\n                var coords = $.map(area.attr(\"coords\").split(\",\"), function(n) {\n                    return Number(n);\n                });\n                if (area.attr(\"shape\").match(/circle/i)) {\n                    coords = [((coords[0] - coords[2])),((coords[1] - coords[2])),((coords[0] + coords[2])),((coords[1] + coords[2])),];\n                }\n            ;\n            ;\n                var x = [], y = [];\n                for (var i = 0; ((i < coords.length)); i++) {\n                    ((((((i % 2)) === 0)) ? x : y)).push(coords[i]);\n                };\n            ;\n                var min = [Math.min.apply(Math, x),Math.min.apply(Math, y),];\n                var max = [Math.max.apply(Math, x),Math.max.apply(Math, y),];\n                var mapName = area.parents(\"map\").attr(\"JSBNG__name\");\n                var mapImg = $(((((\"img[usemap=#\" + mapName)) + \"]\")));\n                var map = mapImg.offset();\n                map.left += parseInt(mapImg.css(\"border-left-width\"), 10);\n                map.JSBNG__top += parseInt(mapImg.css(\"border-top-width\"), 10);\n                return [((map.left + min[0])),((map.JSBNG__top + min[1])),((map.left + max[0])),((map.JSBNG__top + max[1])),];\n            };\n            $.AmazonPopover = {\n                displayPopover: displayPopover,\n                mouseTracker: mouseTracker,\n                updateBacking: updateBacking,\n                support: {\n                    skinCallback: true,\n                    controlCallbacks: true\n                }\n            };\n        };\n    ;\n    })();\n    (function(a) {\n        function b(b) {\n            return [].slice.call(b);\n        };\n    ;\n        function c(b) {\n            return ((((\"function\" === typeof b)) ? b : function() {\n                return b;\n            }));\n        };\n    ;\n        function d(b) {\n            var a = 50, c = function() {\n                ((((((20000 >= a)) && !b())) && (JSBNG__setTimeout(c, a), a *= 2)));\n            };\n            return c;\n        };\n    ;\n        function f() {\n            return ((((((((\"object\" === typeof a.P)) && ((\"function\" === typeof a.P.when)))) && ((\"function\" === typeof a.P.register)))) && ((\"function\" === typeof a.P.execute))));\n        };\n    ;\n        function i() {\n            var b = [], a = !1, c, d = function() {\n                if (!a) {\n                    a = !0;\n                    c = arguments;\n                    for (var d = 0, f = b.length; ((d < f)); d++) {\n                        h(b[d].t, b[d].f, c);\n                    ;\n                    };\n                ;\n                    b = void 0;\n                }\n            ;\n            ;\n            };\n            d.watch = function(d, f) {\n                ((f || (f = d, d = [])));\n                ((a ? h(d, f, c) : b.push({\n                    t: d,\n                    f: f\n                })));\n            };\n            d.isFired = function() {\n                return a;\n            };\n            d.value = function() {\n                return ((c || []));\n            };\n            return d;\n        };\n    ;\n        function g(e) {\n            var e = ((e || {\n                bubble: !1\n            })), g, j = {\n            }, n = function(b) {\n                return ((j[b] || (j[b] = i())));\n            };\n            n.whenAvailable = function(b, c) {\n                var d = i(), e = c.length;\n                if (((0 === e))) {\n                    return d(), d.watch;\n                }\n            ;\n            ;\n                for (var f = 0, g = function() {\n                    f++;\n                    if (!((f < e))) {\n                        for (var b = [], g = 0; ((g < e)); g++) {\n                            b.push(n(c[g]).value()[0]);\n                        ;\n                        };\n                    ;\n                        d.apply(a, b);\n                    }\n                ;\n                ;\n                }, h = 0; ((h < e)); h++) {\n                    n(c[h]).watch(b, g);\n                ;\n                };\n            ;\n                return d.watch;\n            };\n            g = n;\n            var l = 0, m = {\n            }, t = {\n                declare: function(b, a) {\n                    ((m[b] || (m[b] = {\n                        done: k()\n                    })));\n                    g(b)(a);\n                },\n                build: function(b, a) {\n                    h([e.sourceName,b,], function() {\n                        t.declare(b, c(a)());\n                    });\n                },\n                getNow: function(b, a) {\n                    return ((g(b).value()[0] || a));\n                },\n                publish: function(b, c) {\n                    t.declare(b, c);\n                    var d = e.parent;\n                    ((e.prefix && (b = ((((e.prefix + \".\")) + b)))));\n                    ((((void 0 === d)) ? (((a.amznJQ && a.amznJQ.declareAvailable(b))), ((f() && a.P.register(b, function() {\n                        return c;\n                    })))) : ((((e.bubble && d.publish)) ? d.publish(b, c) : ((d.declare && d.declare(b, c)))))));\n                },\n                importEvent: function(b, c) {\n                    var g = e.parent, c = ((c || {\n                    })), h = ((c.as || b)), j = function(b) {\n                        t.declare(h, ((((((void 0 === b)) || ((null === b)))) ? c.otherwise : b)));\n                    };\n                    if (((((((g && g.when)) && g.declare)) && g.build))) {\n                        g.when(b).run(j);\n                    }\n                     else {\n                        if (((f() && a.P.when(b).execute(j))), a.amznJQ) {\n                            a.amznJQ[((e.useOnCompletion ? \"onCompletion\" : \"available\"))](((c.amznJQ || b)), d(function() {\n                                var b;\n                                if (c.global) {\n                                    b = a;\n                                    for (var d = ((c.global || \"\")).split(\".\"), e = 0, f = d.length; ((e < f)); e++) {\n                                        ((((b && d[e])) && (b = b[d[e]])));\n                                    ;\n                                    };\n                                ;\n                                }\n                                 else b = c.otherwise;\n                            ;\n                            ;\n                                if (((c.retry && ((((void 0 === b)) || ((null === b))))))) {\n                                    return !1;\n                                }\n                            ;\n                            ;\n                                t.declare(h, b);\n                                return !0;\n                            }));\n                        }\n                    ;\n                    }\n                ;\n                ;\n                },\n                stats: function(b) {\n                    var c = a.JSON.parse(a.JSON.stringify(m)), d;\n                    {\n                        var fin27keys = ((window.top.JSBNG_Replay.forInKeys)((c))), fin27i = (0);\n                        (0);\n                        for (; (fin27i < fin27keys.length); (fin27i++)) {\n                            ((d) = (fin27keys[fin27i]));\n                            {\n                                if (c.hasOwnProperty(d)) {\n                                    for (var e = c[d], f = ((e.depend || [])), h, j = 0, i = [], k = 0; ((k < f.length)); k++) {\n                                        var n = f[k];\n                                        ((g(n).isFired() ? ((((m[n].done > j)) && (j = m[n].done, h = n))) : i.push(n)));\n                                    };\n                                ;\n                                    ((((0 < i.length)) ? e.blocked = i : ((b ? delete c[d] : ((((0 < j)) && (e.longPole = h, e.afterLongPole = ((e.done - j)))))))));\n                                }\n                            ;\n                            ;\n                            };\n                        };\n                    };\n                ;\n                    return c;\n                },\n                when: function() {\n                    function a(c, f) {\n                        var h = k(), j = [e.sourceName,c,];\n                        m[c] = {\n                            depend: d,\n                            registered: h\n                        };\n                        g.whenAvailable(j, d)(j, function() {\n                            m[c].done = k();\n                            m[c].wait = ((m[c].done - h));\n                            f.apply(this, b(arguments));\n                        });\n                    };\n                ;\n                    var d = b(arguments);\n                    return {\n                        run: function(b, c) {\n                            ((c ? b = ((\"run.\" + b)) : (c = b, b = ((\"run.#\" + l++)))));\n                            a(b, c);\n                        },\n                        declare: function(b, c) {\n                            a(b, function() {\n                                t.declare(b, c);\n                            });\n                        },\n                        publish: function(b, c) {\n                            a(b, function() {\n                                t.publish(b, c);\n                            });\n                        },\n                        build: function(d, e) {\n                            a(d, function() {\n                                var a = b(arguments), a = c(e).apply(this, a);\n                                t.declare(d, a);\n                            });\n                        }\n                    };\n                }\n            };\n            return t;\n        };\n    ;\n        function e(b) {\n            var b = ((b || \"unknownSource\")), c = g({\n                sourceName: b\n            });\n            c.declare(\"instance.sourceName\", b);\n            c.importEvent(\"jQuery\", {\n                as: \"$\",\n                global: \"jQuery\"\n            });\n            c.importEvent(\"jQuery\", {\n                global: \"jQuery\"\n            });\n            c.importEvent(\"amznJQ.AboveTheFold\", {\n                as: \"page.ATF\",\n                useOnCompletion: !0\n            });\n            c.importEvent(\"amznJQ.theFold\", {\n                as: \"page.ATF\",\n                useOnCompletion: !0\n            });\n            c.importEvent(\"amznJQ.criticalFeature\", {\n                as: \"page.CF\",\n                useOnCompletion: !0\n            });\n            c.when(\"$\").run(function(b) {\n                var d = function() {\n                    c.declare(\"page.domReady\");\n                    c.declare(\"page.ATF\");\n                    c.declare(\"page.CF\");\n                    c.declare(\"page.loaded\");\n                };\n                b(function() {\n                    c.declare(\"page.domReady\");\n                });\n                b(a).load(d);\n                ((((\"complete\" === JSBNG__document.readyState)) ? d() : ((((\"interactive\" === JSBNG__document.readyState)) && c.declare(\"page.domReady\")))));\n            });\n            return c;\n        };\n    ;\n        if (((!a.$Nav || a.$Nav._replay))) {\n            var k = ((JSBNG__Date.now || function() {\n                return +new JSBNG__Date;\n            })), h, j = function() {\n                var b = 0;\n                try {\n                    for (; ((m[b] && ((50 > b)))); ) {\n                        b++, m[((b - 1))].f.apply(a, m[((b - 1))].a);\n                    ;\n                    };\n                ;\n                } catch (c) {\n                    var d = c, e = \"\";\n                    ((m[((b - 1))].t && (e = ((((\"[\" + m[((b - 1))].t.join(\":\"))) + \"] \")))));\n                    ((((d && d.message)) ? d.message = ((e + d.message)) : ((((\"object\" === typeof c)) ? d.message = e : d = ((e + d))))));\n                    if (((((a.ueLogError && a.JSBNG__console)) && a.JSBNG__console.error))) {\n                        a.ueLogError(d), a.JSBNG__console.error(d);\n                    }\n                     else {\n                        throw d;\n                    }\n                ;\n                ;\n                } finally {\n                    m = m.slice(b), ((((0 < m.length)) ? JSBNG__setTimeout(j, 1) : l = !1));\n                };\n            ;\n            }, m = [], l;\n            h = function(c, a, d) {\n                m.push({\n                    t: c,\n                    f: a,\n                    a: b(((d || [])))\n                });\n                ((l || (JSBNG__setTimeout(j, 1), l = !0)));\n            };\n            ((a.$Nav || (a.$Nav = e(\"rcx-nav\"))));\n            if (a.$Nav.make) {\n                if (a.$Nav.make._shims) {\n                    for (var r = 0, s = a.$Nav.make._shims.length; ((r < s)); r++) {\n                        var q = a.$Nav.make._shims[r], p = e(q._sourceName);\n                        if (q._replay) {\n                            for (var t = 0, A = q._replay.length; ((t < A)); t++) {\n                                for (var w = p, u = q._replay[t], v = 0, n = u.length; ((v < n)); v++) {\n                                    var x = u[v];\n                                    if (!w[x.m]) {\n                                        break;\n                                    }\n                                ;\n                                ;\n                                    w = w[x.m].apply(w, x.a);\n                                };\n                            ;\n                            };\n                        ;\n                            t = void 0;\n                            {\n                                var fin28keys = ((window.top.JSBNG_Replay.forInKeys)((p))), fin28i = (0);\n                                (0);\n                                for (; (fin28i < fin28keys.length); (fin28i++)) {\n                                    ((t) = (fin28keys[fin28i]));\n                                    {\n                                        ((p.hasOwnProperty(t) && (q[t] = p[t])));\n                                    ;\n                                    };\n                                };\n                            };\n                        ;\n                            delete q._replay;\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    a.$Nav.make = e;\n                }\n            ;\n            ;\n            }\n             else a.$Nav.make = e;\n        ;\n        ;\n            a.$Nav.declare(\"depend\", g);\n            a.$Nav.declare(\"promise\", i);\n            a.$Nav.declare(\"argArray\", b);\n            a.$Nav.declare(\"schedule\", h);\n        }\n    ;\n    ;\n    })(window);\n    (function(a, b) {\n        b.when(\"$\").run(function(c) {\n            b.importEvent(\"legacy-popover\", {\n                as: \"$popover\",\n                amznJQ: \"popover\",\n                otherwise: c\n            });\n        });\n        b.importEvent(\"iss\", {\n            amznJQ: \"search-js-autocomplete\",\n            global: \"iss\",\n            retry: !0\n        });\n        if (a.amznJQ) {\n            var c = a.amznJQ;\n            c.available(\"navbarInline\", function() {\n                b.declare(\"logEvent\", a._navbar.logEv);\n                b.declare(\"config.readyOnATF\", a._navbar.readyOnATF);\n                b.declare(\"config.browsePromos\", a._navbar.browsepromos);\n                b.declare(\"config.yourAccountPrimeURL\", a._navbar.yourAccountPrimer);\n                b.declare(\"config.sbd\", a._navbar._sbd_config);\n                b.declare(\"config.responsiveGW\", !!a._navbar.responsivegw);\n                b.declare(\"config.swmStyleData\", ((a._navbar._swmStyleData || {\n                })));\n                b.declare(\"config.dismissNotificationUrl\", a._navbar.dismissNotificationUrl);\n                b.declare(\"config.signOutText\", a._navbar.signOutText);\n                b.declare(\"config.lightningDeals\", ((a._navbar._lightningDealsData || {\n                })));\n                b.declare(\"config.enableDynamicMenus\", a._navbar.dynamicMenus);\n                b.declare(\"config.dynamicMenuArgs\", ((a._navbar.dynamicMenuArgs || {\n                })));\n                b.declare(\"config.dynamicMenuUrl\", a._navbar.dynamicMenuUrl);\n                b.declare(\"config.ajaxProximity\", a._navbar._ajaxProximity);\n                b.declare(\"config.recordEvUrl\", a._navbar.recordEvUrl);\n                b.declare(\"config.recordEvInterval\", ((a._navbar.recordEvInterval || 60000)));\n                b.declare(\"config.sessionId\", a._navbar.sid);\n                b.declare(\"config.requestId\", a._navbar.rid);\n                b.declare(\"config.autoFocus\", a._navbar.enableAutoFocus);\n            });\n            c.available(\"navbarBTF\", function() {\n                b.declare(\"config.flyoutURL\", a._navbar.flyoutURL);\n                b.declare(\"config.prefetch\", a._navbar.prefetch);\n            });\n            b.importEvent(\"navbarBTF\", {\n                as: \"btf.full\"\n            });\n            b.importEvent(\"navbarBTFLite\", {\n                as: \"btf.lite\"\n            });\n            b.importEvent(\"navbarInline\", {\n                as: \"nav.inline\"\n            });\n            b.when(\"nav.inline\", \"api.unHideSWM\", \"api.exposeSBD\", \"api.navDimensions\", \"api.onShowProceedToCheckout\", \"api.update\", \"api.setCartCount\", \"api.getLightningDealsData\", \"api.overrideCartButtonClick\", \"flyout.loadMenusConditionally\", \"flyout.shopall\", \"flyout.wishlist\", \"flyout.cart\", \"flyout.youraccount\").publish(\"navbarJSInteraction\");\n            b.when(\"navbarJSInteraction\").publish(\"navbarJS-beacon\");\n            b.when(\"navbarJSInteraction\").publish(\"navbarJS-jQuery\");\n        }\n    ;\n    ;\n    })(window, window.$Nav);\n    (function(a) {\n        a.declare(\"throttle\", function(b, c) {\n            function a() {\n                ((i ? (i = !1, JSBNG__setTimeout(a, b), c()) : f = !1));\n            };\n        ;\n            var f = !1, i = !1;\n            return function() {\n                ((f ? i = !0 : (f = !0, JSBNG__setTimeout(a, b), c())));\n            };\n        });\n        a.when(\"$\").build(\"agent\", function(b) {\n            return new function() {\n                function c() {\n                    var b = Array.prototype.slice.call(arguments, 0);\n                    return RegExp(((((\"(\" + b.join(\"|\"))) + \")\")), \"i\").test(JSBNG__navigator.userAgent);\n                };\n            ;\n                this.iPhone = c(\"iPhone\");\n                this.iPad = c(\"iPad\");\n                this.kindleFire = c(\"Kindle Fire\", \"Silk/\");\n                this.android = c(\"Android\");\n                this.webkit = c(\"WebKit\");\n                this.ie10 = c(\"MSIE 10\");\n                this.ie6 = ((b.browser.msie && ((6 >= parseInt(b.browser.version, 10)))));\n                this.touch = ((((((((((((this.iPhone || this.iPad)) || this.android)) || this.kindleFire)) || !!((\"JSBNG__ontouchstart\" in window)))) || ((0 < window.JSBNG__navigator.msMaxTouchPoints)))) || c(\"\\\\bTouch\\\\b\")));\n                this.ie10touch = ((this.ie10 && this.touch));\n                this.mac = c(\"Macintosh\");\n                this.iOS = ((this.iPhone || this.iPad));\n            };\n        });\n        a.declare(\"byID\", function(b) {\n            return JSBNG__document.getElementById(b);\n        });\n        a.build(\"dismissTooltip\", function() {\n            var b = !1;\n            return function() {\n                ((b || (a.publish(\"navDismissTooltip\"), b = !0)));\n            };\n        });\n        a.build(\"recordEv\", function() {\n            var b = [], c = {\n            };\n            a.when(\"$\", \"config.recordEvUrl\", \"config.recordEvInterval\", \"config.sessionId\", \"config.requestId\").run(function(c, a, i, g, e) {\n                function k(c) {\n                    h++;\n                    if (((0 !== b.length))) {\n                        var c = ((c || h)), d = b.join(\":\"), d = window.encodeURIComponent(d), i = ((window.ue && window.ue.sid)), i = ((i || g)), d = ((((((((((((\"trigger=\" + d)) + \"&when=\")) + c)) + \"&sid=\")) + ((i ? i : \"\")))) + \"&rid=\")), c = (((c = ((window.ue && window.ue.rid))) || e)), d = ((d + ((c ? c : \"\")))), c = ((((0 < a.indexOf(\"?\"))) ? \"&\" : \"?\"));\n                        (new JSBNG__Image).src = ((((a + c)) + d));\n                        b = [];\n                    }\n                ;\n                ;\n                };\n            ;\n                if (a) {\n                    var h = 0;\n                    window.JSBNG__setInterval(k, i);\n                    c(window).bind(\"beforeunload\", function() {\n                        k(\"beforeunload\");\n                    });\n                }\n            ;\n            ;\n            });\n            return function(a) {\n                ((((a in c)) || (b.push(a), c[a] = !0)));\n            };\n        });\n        a.declare(\"TunableCallback\", function(b) {\n            var c = 0, a = [], f = function() {\n                function f() {\n                    for (var c = 0; ((c < a.length)); c++) {\n                        if (!a[c]()) {\n                            return;\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    b();\n                };\n            ;\n                ((((0 < c)) ? JSBNG__setTimeout(f, c) : f()));\n            };\n            f.delay = function(b) {\n                c = b;\n                return f;\n            };\n            f.iff = function(b) {\n                a.push(b);\n                return f;\n            };\n            return f;\n        });\n        a.build(\"eachDescendant\", function() {\n            function b(c, a) {\n                a(c);\n                for (c = c.firstChild; c; ) {\n                    b(c, a), c = c.nextSibling;\n                ;\n                };\n            ;\n            };\n        ;\n            return b;\n        });\n        a.when(\"$\", \"promise\", \"TunableCallback\").run(\"pageReady\", function(b, c, d) {\n            function f() {\n                return ((\"complete\" != JSBNG__document.readyState));\n            };\n        ;\n            function i() {\n                return !!a.getNow(\"config.readyOnATF\");\n            };\n        ;\n            ((((\"complete\" === JSBNG__document.readyState)) ? a.declare(\"page.ready\") : (b = c(), a.when(\"page.ATF\").run(d(b).iff(f).iff(i)), a.when(\"page.CF\").run(d(b).iff(f)), a.when(\"page.domReady\").run(d(b).delay(10000).iff(f)), a.when(\"page.loaded\").run(d(b).delay(100)), b.watch([a.getNow(\"instance.sourceName\"),\"pageReadyCallback\",], function() {\n                a.declare(\"page.ready\");\n            }))));\n        });\n        a.when(\"$\", \"agent\").build(\"onOptionClick\", function(b, c) {\n            return function(a, f) {\n                var i = b(a);\n                if (((((c.mac && c.webkit)) || ((c.touch && !c.ie10))))) i.change(function() {\n                    f.apply(i);\n                });\n                 else {\n                    var g = {\n                        click: 0,\n                        change: 0\n                    }, e = function(b, c) {\n                        return function() {\n                            g[b] = (new JSBNG__Date).getTime();\n                            ((((100 >= ((g[b] - g[c])))) && f.apply(i)));\n                        };\n                    };\n                    i.click(e(\"click\", \"change\")).change(e(\"change\", \"click\"));\n                }\n            ;\n            ;\n            };\n        });\n        a.when(\"$\", \"promise\", \"api.publish\").build(\"triggerProceedToCheckout\", function(b, c, d) {\n            var f = c();\n            d(\"onShowProceedToCheckout\", function(c) {\n                f.watch([a.getNow(\"instance.sourceName\"),\"onShowProceedToCheckoutCallback\",], function() {\n                    var a = b(\"#nav_cart_flyout a[href~=proceedToCheckout]\");\n                    ((((0 < a.length)) && c(a)));\n                });\n            });\n            return f;\n        });\n        a.when(\"promise\", \"api.publish\").run(\"triggerNearFlyout\", function(b, c) {\n            var d = b();\n            c(\"onNearFlyout\", function(b) {\n                d.watch([a.getNow(\"instance.sourceName\"),\"onNearFlyoutCallback\",], b);\n            });\n            a.when(\"config.prefetchUrls\", \"JSBNG__event.prefetch\").run(\"prefetch\", function(b) {\n                ((window.amznJQ && window.amznJQ.addPL(b)));\n                d();\n            });\n        });\n        a.when(\"$\", \"byID\").build(\"$byID\", function(b, c) {\n            return function(a) {\n                return b(((c(a) || [])));\n            };\n        });\n        a.when(\"$byID\", \"config.dynamicMenuArgs\", \"btf.full\").build(\"flyout.primeAjax\", function(b, c) {\n            return ((c.hasOwnProperty(\"isPrime\") && b(\"nav-prime-menu\").hasClass(\"nav-ajax-prime-menu\")));\n        });\n        a.when(\"$\", \"agent\").build(\"areaMapper\", function(b, c) {\n            var a = function() {\n            \n            };\n            if (!c.kindleFire) {\n                return {\n                    disable: a,\n                    enable: a\n                };\n            }\n        ;\n        ;\n            var f = b([]);\n            return {\n                disable: function(c) {\n                    var a = b(\"img[usemap]\").filter(function() {\n                        return ((0 === b(this).parents(c).length));\n                    });\n                    f = f.add(a);\n                    a.each(function() {\n                        this.disabledUseMap = b(this).attr(\"usemap\");\n                        b(this).attr(\"usemap\", \"\");\n                    });\n                },\n                enable: function() {\n                    f.each(function() {\n                        b(this).attr(\"usemap\", this.disabledUseMap);\n                    });\n                    f = b([]);\n                }\n            };\n        });\n        a.when(\"$\").build(\"template\", function(b) {\n            var c = {\n            };\n            return function(a, f) {\n                ((c[a] || (c[a] = new Function(\"obj\", ((((\"var p=[],print=function(){p.push.apply(p,arguments);};with(obj){p.push('\" + b(a).html().replace(/[\\r\\t\\n]/g, \" \").replace(/'(?=[^#]*#>)/g, \"\\u0009\").split(\"'\").join(\"\\\\'\").split(\"\\u0009\").join(\"'\").replace(/<#=(.+?)#>/g, \"',$1,'\").split(\"\\u003C#\").join(\"');\").split(\"#\\u003E\").join(\"p.push('\"))) + \"');}return p.join('');\"))))));\n                try {\n                    return f.jQuery = b, c[a](f);\n                } catch (i) {\n                    return \"\";\n                };\n            ;\n            };\n        });\n        a.when(\"$\", \"config.yourAccountPrimeURL\", \"nav.inline\").run(\"yourAccountPrimer\", function(b, c) {\n            ((c && b(\"#nav_prefetch_yourorders\").mousedown(function() {\n                var b = !1;\n                return function() {\n                    ((b || (b = !0, (new JSBNG__Image).src = c)));\n                };\n            }())));\n        });\n        a.when(\"$\", \"byID\", \"agent\", \"dismissTooltip\", \"recordEv\").build(\"flyout.NavButton\", function(b, c, a, f, i) {\n            return function(g) {\n                this._jqId = ((\"#\" + g));\n                var e = this;\n                c(g).className = c(g).className.replace(\"nav-menu-inactive\", \"nav-menu-active\");\n                var k = 0, h;\n                this.onShow = function() {\n                    k = +new JSBNG__Date;\n                    f();\n                    e._toggleClass(!0, \"nav-button-outer-open\");\n                    ((h && i(h)));\n                };\n                this.onHide = function() {\n                    e._toggleClass(!1, \"nav-button-outer-open\");\n                };\n                this.registerTrigger = function(c) {\n                    var f = this._defaultTriggerParams(e);\n                    b().extend(f, ((c || {\n                    })));\n                    var g = b(e._jqId).amazonPopoverTrigger(f);\n                    ((f.localContent && (h = b(f.localContent).attr(\"data-nav-wt\"))));\n                    ((((a.touch && b.AmazonPopover.support.controlCallbacks)) && b(e._jqId).click(function() {\n                        ((((g.amznPopoverVisible() && ((400 < ((+new JSBNG__Date - k)))))) && g.amznPopoverHide()));\n                    })));\n                };\n                this.removeTrigger = function() {\n                    b(e._jqId).removeAmazonPopoverTrigger();\n                };\n                this._toggleClass = function(c, a) {\n                    ((c ? b(e._jqId).addClass(a) : b(e._jqId).removeClass(a)));\n                };\n                b(e._jqId).keypress(function(c) {\n                    ((((((13 == c.which)) && b(e._jqId).attr(\"href\"))) && (window.JSBNG__location = b(e._jqId).attr(\"href\"))));\n                });\n                this._defaultTriggerParams = function(b) {\n                    b = {\n                        width: null,\n                        JSBNG__location: \"bottom\",\n                        locationAlign: \"left\",\n                        locationMargin: 0,\n                        hoverShowDelay: ((a.touch ? 0 : 250)),\n                        hoverHideDelay: ((a.touch ? 0 : 250)),\n                        showOnHover: !0,\n                        forceAlignment: !0,\n                        focusOnShow: !1,\n                        skin: null,\n                        onShow: b.onShow,\n                        onHide: b.onHide,\n                        showCloseButton: !1,\n                        group: \"navbar\"\n                    };\n                    ((a.ie10touch && (b.hoverShowDelay = 250)));\n                    return b;\n                };\n            };\n        });\n        a.when(\"$byID\", \"agent\", \"$popover\").build(\"flyout.SKIN\", function(b, c, a) {\n            return function(f, i, g) {\n                var e = function() {\n                    var a = b(\"nav-bar-outer\").width(), a = Math.min(30, Math.max(0, ((((((a - f.offset().left)) - f.JSBNG__outerWidth())) - i)))), d = ((((30 > a)) ? ((((\" style=\\\"width: \" + ((a + 15)))) + \"px;\\\"\")) : \"\")), e = [\"nav_flyout_table\",];\n                    ((c.ie6 && e.push(\"nav_ie6\")));\n                    ((g && e.push(g)));\n                    return ((((((((((((((((((((((((\"\\u003Ctable cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" surround=\\\"0,\" + a)) + \",30,30\\\" class=\\\"\")) + e.join(\" \"))) + \"\\\"\\u003E\\u003Ctr\\u003E\\u003Ctd class=\\\"nav_pop_tl nav_pop_h\\\"\\u003E\\u003Cdiv class=\\\"nav_pop_lr_min\\\"\\u003E\\u003C/div\\u003E\\u003C/td\\u003E\\u003Ctd class=\\\"nav_pop_tc nav_pop_h\\\"\\u003E\\u003C/td\\u003E\\u003Ctd class=\\\"nav_pop_tr nav_pop_h\\\"\")) + d)) + \"\\u003E\\u003Cdiv class=\\\"nav_pop_lr_min\\\"\")) + d)) + \"\\u003E\\u003C/div\\u003E\\u003C/td\\u003E\\u003C/tr\\u003E\\u003Ctr\\u003E\\u003Ctd class=\\\"nav_pop_cl nav_pop_v\\\"\\u003E\\u003C/td\\u003E\\u003Ctd class=\\\"nav_pop_cc ap_content\\\"\\u003E\\u003C/td\\u003E\\u003Ctd class=\\\"nav_pop_cr nav_pop_v\\\"\")) + d)) + \"\\u003E\\u003C/td\\u003E\\u003C/tr\\u003E\\u003Ctr\\u003E\\u003Ctd class=\\\"nav_pop_bl nav_pop_v\\\"\\u003E\\u003C/td\\u003E\\u003Ctd class=\\\"nav_pop_bc nav_pop_h\\\"\\u003E\\u003C/td\\u003E\\u003Ctd class=\\\"nav_pop_br nav_pop_v\\\"\")) + d)) + \"\\u003E\\u003C/td\\u003E\\u003C/tr\\u003E\\u003C/table\\u003E\"));\n                };\n                return ((((a.AmazonPopover.support && a.AmazonPopover.support.skinCallback)) ? e : e()));\n            };\n        });\n        a.when(\"$\", \"byID\", \"eachDescendant\").build(\"flyout.computeFlyoutHeight\", function(b, a, d) {\n            var f = {\n            };\n            return function(i) {\n                if (((i in f))) {\n                    return f[i];\n                }\n            ;\n            ;\n                var g = a(i), e = ((0 < b(g).parents(\".nav_deep\").length)), k = ((b(g).hasClass(\"nav_pad_5\") ? 1 : 0)), h = 0;\n                ((e && (h -= 7)));\n                d(g, function(a) {\n                    ((((1 == a.nodeType)) && (a = b(a), ((e ? (h += ((a.hasClass(\"nav_pop_li\") ? ((28 - ((2 * k)))) : 0)), h += ((a.hasClass(\"nav_first\") ? ((-6 + k)) : 0)), h += ((a.hasClass(\"nav_divider_before\") ? 15 : 0))) : (h += ((a.hasClass(\"nav_pop_li\") ? 23 : 0)), h += ((a.hasClass(\"nav_divider_before\") ? 10 : 0)), h += ((a.hasClass(\"nav_first\") ? -7 : 0))))), h += ((a.hasClass(\"nav_tag\") ? 13 : 0)))));\n                });\n                return f[i] = h;\n            };\n        });\n        a.when(\"$popover\", \"$byID\", \"agent\", \"logEvent\", \"recordEv\", \"areaMapper\", \"flyout.NavButton\", \"flyout.SKIN\", \"flyout.computeFlyoutHeight\", \"flyout.initBrowsePromos\", \"config.responsiveGW\", \"config.sbd\", \"nav.inline\", \"flyout.JSBNG__content\").run(\"ShopAll\", function(b, c, d, f, i, g, e, k, h, j, m, l) {\n            if (((c(\"nav-shop-all-button\").length && c(\"nav_browse_flyout\").length))) {\n                var r = function() {\n                \n                }, s = b.AmazonPopover.mouseTracker, q = b.AmazonPopover.updateBacking, p, t, A, w = [], u, v, n, x, B, z, E, C, y = new e(\"nav-shop-all-button\"), J = c(\"nav-shop-all-button\"), K = ((m && ((!d.touch || d.ie10touch))));\n                ((d.touch && b(\"#nav_cats .nav_cat a\").each(function() {\n                    var a = b(this);\n                    a.replaceWith(a.text());\n                })));\n                var N = function() {\n                    var e = a.getNow(\"initExposeSBD\");\n                    ((e && e().deBorder(!0)));\n                    g.disable(\"#nav_browse_flyout\");\n                    j();\n                    var k = c(\"nav_browse_flyout\"), m = c(\"nav_subcats\"), e = c(\"nav_subcats_wrap\"), r = c(\"nav_cats_wrap\"), y = c(\"nav_cat_indicator\");\n                    ((p ? k.css({\n                        height: ((h(\"nav_cats_wrap\") + \"px\"))\n                    }) : (A = r.JSBNG__outerWidth(), k.css({\n                        height: ((h(\"nav_cats_wrap\") + \"px\")),\n                        width: ((A + \"px\"))\n                    }), e.css({\n                        display: \"block\"\n                    }), p = !0)));\n                    var z = function() {\n                        ((t && t()));\n                        t = null;\n                        if (d.touch) {\n                            var a = b(\"video\");\n                            a.css(\"visibility\", \"hidden\");\n                            JSBNG__setTimeout(function() {\n                                a.css(\"visibility\", \"\");\n                            }, 10);\n                        }\n                    ;\n                    ;\n                        k.css({\n                            overflow: \"visible\"\n                        });\n                    }, E = function(b, a) {\n                        var c = \"c\", e = \"c\";\n                        ((((b && a)) && (((((b.x < a.x1)) ? c = \"l\" : ((((b.x > a.x2)) && (c = \"r\"))))), ((((b.y < a.y1)) ? e = \"t\" : ((((b.y > a.y2)) && (e = \"b\"))))))));\n                        return ((e + c));\n                    }, I = function(b, a) {\n                        var c = 0, e = b.cursor, d = ((b.priorCursors[0] || {\n                        })), f = ((b.priorCursors[1] || {\n                        }));\n                        if (((((((e.x == d.x)) && ((2 > Math.abs(((e.y - d.y))))))) && ((e.x > f.x))))) c = l.minor_delay;\n                         else {\n                            d = [e,d,];\n                            switch (E(e, a)) {\n                              case \"tl\":\n                                d.push({\n                                    x: a.x1,\n                                    y: a.y2\n                                }, {\n                                    x: a.x2,\n                                    y: a.y1\n                                });\n                                break;\n                              case \"bl\":\n                                d.push({\n                                    x: a.x1,\n                                    y: a.y1\n                                }, {\n                                    x: a.x2,\n                                    y: a.y2\n                                });\n                                break;\n                              case \"cl\":\n                                d.push({\n                                    x: a.x1,\n                                    y: a.y1\n                                }, {\n                                    x: a.x1,\n                                    y: a.y2\n                                });\n                                break;\n                              default:\n                                d.push({\n                                    x: 0,\n                                    y: 0\n                                }, {\n                                    x: 0,\n                                    y: 0\n                                }), c = -1;\n                            };\n                        ;\n                            ((((0 === c)) && (c = ((((((d[2].x - d[1].x)) * ((d[3].y - d[1].y)))) - ((((d[3].x - d[1].x)) * ((d[2].y - d[1].y)))))), e = ((((((((d[3].x - d[0].x)) * ((d[1].y - d[0].y)))) - ((((d[1].x - d[0].x)) * ((d[3].y - d[0].y)))))) / c)), f = ((((((((d[1].x - d[0].x)) * ((d[2].y - d[0].y)))) - ((((d[2].x - d[0].x)) * ((d[1].y - d[0].y)))))) / c)), c = ((((((((0 < ((((((((d[2].x - d[0].x)) * ((d[3].y - d[0].y)))) - ((((d[3].x - d[0].x)) * ((d[2].y - d[0].y)))))) / c)))) && ((0 < e)))) && ((0 < f)))) ? l.major_delay : 0)))));\n                        }\n                    ;\n                    ;\n                        return c;\n                    }, M = function(e) {\n                        var g = !u, h = !1, n = c(((\"nav_subcats_\" + e))), e = c(((\"nav_cat_\" + e))), j = n.attr(\"data-nav-promo-id\"), r = n.attr(\"data-nav-wt\");\n                        ((u && (c(((\"nav_subcats_\" + u))).css({\n                            display: \"none\"\n                        }), c(((\"nav_cat_\" + u))).removeClass(\"nav_active\"))));\n                        JSBNG__clearTimeout(C);\n                        if (j) {\n                            var p = a.getNow(\"config.browsePromos\", {\n                            }), x = {\n                                t: \"sa\",\n                                id: j\n                            };\n                            ((p[j] && (x.bp = 1)));\n                            C = window.JSBNG__setTimeout(function() {\n                                f(x);\n                            }, 750);\n                        }\n                    ;\n                    ;\n                        ((r && i(r)));\n                        e.addClass(\"nav_active\");\n                        n.css({\n                            display: \"block\"\n                        });\n                        y.css(\"JSBNG__top\", ((((e.position().JSBNG__top + parseInt(e.css(\"padding-top\"), 10))) + 1)));\n                        e = n.hasClass(\"nav_super_cat\");\n                        ((((e != v)) && (((e ? k.addClass(\"nav_super\") : k.removeClass(\"nav_super\"))), h = !0, v = e)));\n                        ((g ? (t = function() {\n                            q(\"navbar\");\n                        }, k.animate({\n                            width: ((((m.JSBNG__outerWidth() + A)) + \"px\"))\n                        }, {\n                            duration: \"fast\",\n                            complete: z\n                        })) : ((h && (g = function() {\n                            k.css({\n                                width: ((((m.JSBNG__outerWidth() + A)) + \"px\"))\n                            });\n                            q(\"navbar\");\n                        }, ((t ? t = g : g())))))));\n                        ((((K && !d.ie6)) && n.parents(\".nav_exposed_skin\").removeClass(\"nav_exposed_skin\")));\n                        n.JSBNG__find(\".nav_subcat_links\").each(function() {\n                            var a = b(this);\n                            if (!a.data(\"nav-linestarts-marked\")) {\n                                a.data(\"nav-linestarts-marked\", !0);\n                                var c = 0;\n                                a.JSBNG__find(\"li\").each(function() {\n                                    var a = b(this), d = a.offset().JSBNG__top;\n                                    ((((5 < Math.abs(((d - c))))) && (a.addClass(\"nav_linestart\"), c = d)));\n                                });\n                            }\n                        ;\n                        ;\n                        });\n                        h = n.offset();\n                        g = h.left;\n                        h = ((h.JSBNG__top - l.target_slop));\n                        e = ((g + n.JSBNG__outerWidth()));\n                        n = ((((h + n.JSBNG__outerHeight())) + l.target_slop));\n                        return {\n                            x1: g,\n                            y1: h,\n                            x2: e,\n                            y2: n\n                        };\n                    };\n                    window._navbar.qaActivateCat = function(b) {\n                        b = ((b || \"0\"));\n                        M(b);\n                        u = b;\n                    };\n                    b(\"#nav_cats li.nav_cat\").each(function() {\n                        var a = /^nav_cat_(.+)/.exec(this.id), d = ((a ? a[1] : \"\")), a = b(this), e = a.offset(), a = s.add([[e.left,e.JSBNG__top,a.JSBNG__outerWidth(),a.JSBNG__outerHeight(),],], {\n                            inside: !1,\n                            mouseEnter: function(b) {\n                                JSBNG__clearTimeout(x);\n                                c(((\"nav_cat_\" + d))).addClass(\"nav_hover\");\n                                if (((u !== d))) {\n                                    var a = I(b, n);\n                                    if (((u && ((0 < a))))) {\n                                        var e = function() {\n                                            JSBNG__clearTimeout(x);\n                                            var a = s.getCallbackArgs(), c = 0;\n                                            ((((((B && ((B.x == a.cursor.x)))) && ((B.y == a.cursor.y)))) ? (c = ((((\"cc\" == E(a.cursor, n))) ? !1 : !0)), c = ((c ? 0 : -1))) : c = I(a, n)));\n                                            B = {\n                                                x: a.cursor.x,\n                                                y: a.cursor.y\n                                            };\n                                            ((((0 < c)) ? ((((u !== d)) && (x = JSBNG__setTimeout(e, c)))) : ((((-1 < c)) && (n = M(d, b), u = d)))));\n                                        };\n                                        x = JSBNG__setTimeout(e, a);\n                                    }\n                                     else n = M(d, b), u = d;\n                                ;\n                                ;\n                                }\n                            ;\n                            ;\n                                return !0;\n                            },\n                            mouseLeave: function() {\n                                c(((\"nav_cat_\" + d))).removeClass(\"nav_hover\");\n                                return !0;\n                            }\n                        });\n                        w.push(a);\n                    });\n                }, F = function() {\n                    JSBNG__clearTimeout(x);\n                    JSBNG__clearTimeout(C);\n                    JSBNG__clearTimeout(E);\n                    for (var b = 0; ((b < w.length)); b++) {\n                        s.remove(w[b]);\n                    ;\n                    };\n                ;\n                    w = [];\n                    n = null;\n                    p = !1;\n                    ((u && (c(((\"nav_subcats_\" + u))).css({\n                        display: \"none\"\n                    }), c(((\"nav_cat_\" + u))).removeClass(\"nav_active\"))));\n                    u = null;\n                    c(\"nav_cat_indicator\").css({\n                        JSBNG__top: \"\"\n                    });\n                    c(\"nav_browse_flyout\").css({\n                        height: \"\",\n                        overflow: \"\"\n                    });\n                    g.enable();\n                    (((b = a.getNow(\"initExposeSBD\")) && b().deBorder(!1)));\n                };\n                a.declare(\"initExposeSBD\", function() {\n                    if (z) {\n                        return z;\n                    }\n                ;\n                ;\n                    if (!K) {\n                        return z = {\n                            ok: function() {\n                                return !1;\n                            },\n                            deBorder: r,\n                            initDeferredShow: r,\n                            deferredShow: r\n                        };\n                    }\n                ;\n                ;\n                    var g = c(\"nav_exposed_anchor\"), h = ((d.ie6 ? \"\" : \"nav_exposed_skin\")), n = k(J, 0, h), i = b(((((\"function\" == typeof n)) ? n() : n))), n = b(\"\\u003Cdiv id=\\\"nav_exposed_skin\\\"\\u003E\\u003C/div\\u003E\").css({\n                        JSBNG__top: -8,\n                        left: ((J.offset().left - ((d.ie6 ? 27 : 30))))\n                    }).append(i).appendTo(g), j = c(\"nav_browse_flyout\"), l = b(\"\\u003Cdiv id=\\\"nav_exposed_cats\\\"\\u003E\\u003C/div\\u003E\").appendTo(b(\".ap_content\", n)), m = c(\"nav-shop-all-button\").clone().attr({\n                        href: \"javascript:void(0)\",\n                        id: \"\"\n                    }).addClass(\"nav-shop-all-button nav-button-outer-open\").appendTo(\"#nav-bar-inner\").add(n), t = c(\"navbar\").add(g), p = c(\"nav_cats_wrap\"), q = new e(\"nav_exposed_skin\"), u, x = !0, v, s, w, g = ((b.browser.msie && ((!JSBNG__document.documentMode || ((8 > JSBNG__document.documentMode))))));\n                    z = {\n                        ok: function() {\n                            return !0;\n                        },\n                        deBorder: function(b) {\n                            ((b ? i.addClass(\"nav_pop_triggered\") : i.removeClass(\"nav_pop_triggered\")));\n                        },\n                        initDeferredShow: function() {\n                            ((s || (s = r)));\n                        },\n                        deferredShow: function() {\n                            ((s && (s(), s = null)));\n                        }\n                    };\n                    var B = {\n                        localContent: \"#nav_browse_flyout\",\n                        JSBNG__location: \"JSBNG__top\",\n                        locationAlign: \"left\",\n                        locationOffset: [30,((g ? 33 : 32)),],\n                        skin: k(l, 0, h),\n                        showOnHover: !0,\n                        hoverShowDelay: 0,\n                        onShow: function() {\n                            ((w || (w = r)));\n                            q.removeTrigger();\n                            q.onShow();\n                            N();\n                            p.appendTo(j);\n                            b(JSBNG__document).mousemove();\n                        },\n                        onHide: function() {\n                            p.appendTo(l);\n                            F();\n                            q.onHide();\n                            q.registerTrigger(B);\n                            ((w && w()));\n                            w = null;\n                        }\n                    };\n                    a.when(\"protectExposeSBD\").run(\"exposeSBD\", function(a) {\n                        a(function(a) {\n                            v = a;\n                            ((((a !== u)) && ((a ? (f({\n                                t: \"sa\",\n                                id: \"res-main\"\n                            }), a = function() {\n                                ((((!1 !== v)) && (y.removeTrigger(), t.addClass(\"nav_exposed_sbd\"), ((((0 < b(\"#nav_browse_flyout.nav_deep\").length)) && t.addClass(\"nav_deep\"))), p.appendTo(l), ((x && (((b.browser.msie ? m.css(\"display\", \"block\") : m.fadeIn(600))), x = !1))), q.registerTrigger(B), u = !0)));\n                            }, ((s ? s = a : a()))) : (a = function() {\n                                ((((!0 !== v)) && (q.removeTrigger(), t.removeClass(\"nav_exposed_sbd\"), p.appendTo(j), ((x && (m.css(\"display\", \"block\"), x = !1))), y.registerTrigger(G), u = !1)));\n                            }, ((w ? w = a : a())))))));\n                        });\n                    });\n                    return z;\n                });\n                var G = {\n                    localContent: \"#nav_browse_flyout\",\n                    locationAlign: \"left\",\n                    locationOffset: [((d.ie6 ? 3 : 0)),0,],\n                    skin: k(J, 0),\n                    onShow: function() {\n                        var b = a.getNow(\"initExposeSBD\");\n                        ((b && b().initDeferredShow()));\n                        y.onShow();\n                        E = window.JSBNG__setTimeout(function() {\n                            f({\n                                t: \"sa\",\n                                id: \"main\"\n                            });\n                        }, 750);\n                        N();\n                    },\n                    onHide: function() {\n                        F();\n                        y.onHide();\n                        var b = a.getNow(\"initExposeSBD\");\n                        ((b && b().deferredShow()));\n                    }\n                };\n                ((K || y.registerTrigger(G)));\n                a.declare(\"flyout.shopall\");\n            }\n        ;\n        ;\n        });\n        a.when(\"$\", \"$byID\", \"nav.inline\", \"flyout.JSBNG__content\").build(\"flyout.notificationCount\", function(b, c) {\n            function d(a) {\n                f = a;\n                ((i && ((((0 >= f)) ? i.remove() : i.text(((((9 < f)) ? \"9+\" : f)))))));\n            };\n        ;\n            var f = parseInt(((b(\"#nav-noti-wrapper .nav-noti-content\").attr(\"data-noti-count\") || \"0\")), 10), i;\n            d.count = function() {\n                return f;\n            };\n            d.decrement = function() {\n                d(((f - 1)));\n            };\n            a.when(\"page.ready\").run(function() {\n                if (!((0 >= f))) {\n                    var a = c(\"nav-signin-text\"), e = b.trim(a.text()).match(/^(.*?)(\\.*)$/);\n                    a.html(((((e[1] + \"\\u003Cspan id=\\\"nav-noti-count-position\\\"\\u003E\\u003C/span\\u003E\")) + e[2])));\n                    var e = ((c(\"nav-noti-count-position\").position().left + 10)), k = c(\"nav-your-account\"), h = ((((k.JSBNG__outerWidth() - 5)) - e)), j = {\n                    };\n                    ((((((15 > h)) || ((15 > e)))) ? (j.right = 2, ((((((0 < h)) && ((10 >= h)))) && a.append(Array(11).join(\"&nbsp;\"))))) : j.left = ((Math.round(e) + 1))));\n                    i = b(\"\\u003Cdiv id=\\\"nav-noti-count\\\" class=\\\"nav-sprite\\\"\\u003E\");\n                    i.css(j).appendTo(k);\n                    d(f);\n                }\n            ;\n            ;\n            });\n            return d;\n        });\n        a.when(\"$\", \"$byID\", \"agent\", \"flyout.notificationCount\", \"config.dismissNotificationUrl\", \"flyout.JSBNG__content\").build(\"flyout.notifications\", function(a, c, d, f, i) {\n            function g() {\n                var d = ((e.height() - c(\"nav-noti-all\").JSBNG__outerHeight(!0)));\n                k.each(function() {\n                    var c = a(this);\n                    ((c.attr(\"data-dismissed\") || ((((((c.position().JSBNG__top + c.JSBNG__outerHeight())) > d)) ? c.addClass(\"nav-noti-overflow\") : c.removeClass(\"nav-noti-overflow\")))));\n                });\n            };\n        ;\n            var e = c(\"nav-noti-wrapper\").JSBNG__find(\".nav-noti-content\"), k = e.JSBNG__find(\".nav-noti-item\").not(\"#nav-noti-empty\");\n            return {\n                width: 180,\n                exists: function() {\n                    return ((((0 < f.count())) && ((0 < e.length))));\n                },\n                getContent: function() {\n                    var h = e.get(0);\n                    h.parentNode.removeChild(h);\n                    ((d.touch ? k.addClass(\"nav-noti-touch\") : k.hover(function() {\n                        a(this).addClass(\"nav-noti-hover\");\n                    }, function() {\n                        a(this).removeClass(\"nav-noti-hover\");\n                    })));\n                    a(\".nav-noti-x\", e).click(function(d) {\n                        d.preventDefault();\n                        d = a(this);\n                        a.ajax({\n                            url: i,\n                            type: \"POST\",\n                            data: {\n                                id: d.attr(\"data-noti-id\")\n                            },\n                            cache: !1,\n                            timeout: 500\n                        });\n                        d.css(\"visibility\", \"hidden\").parent().attr(\"data-dismissed\", \"1\").slideUp(400, function() {\n                            f.decrement();\n                            ((((0 === f.count())) && c(\"nav-noti-empty\").fadeIn(300)));\n                            g();\n                        });\n                    }).hover(function() {\n                        a(this).addClass(\"nav-noti-x-hover\");\n                    }, function() {\n                        a(this).removeClass(\"nav-noti-x-hover\");\n                    });\n                    return e;\n                },\n                onShow: g,\n                JSBNG__event: ((((0 < f.count())) ? \"noti\" : null))\n            };\n        });\n        a.when(\"$\", \"flyout.JSBNG__content\").build(\"flyout.highConfidence\", function(a) {\n            var c = a(\"#csr-hcb-wrapper .csr-hcb-content\");\n            return {\n                width: 229,\n                exists: function() {\n                    return ((0 < c.length));\n                },\n                getContent: function() {\n                    var a = c.get(0);\n                    a.parentNode.removeChild(a);\n                    return c;\n                },\n                JSBNG__event: \"hcb\"\n            };\n        });\n        a.when(\"$\", \"$byID\", \"areaMapper\", \"agent\", \"logEvent\", \"flyout.NavButton\", \"flyout.SKIN\", \"flyout.loadMenusConditionally\", \"flyout.notifications\", \"flyout.highConfidence\", \"config.signOutText\", \"nav.inline\", \"flyout.JSBNG__content\").run(\"YourAccount\", function(b, c, d, f, i, g, e, k, h, j, m) {\n            var l;\n            ((h.exists() ? l = h : ((j.exists() && (l = j)))));\n            var h = c(\"nav-your-account\"), r = c(\"nav_your_account_flyout\"), s;\n            if (((h.length && r.length))) {\n                var q = new g(\"nav-your-account\");\n                b(\"#nav-noti-wrapper, #csr-hcb-wrapper\");\n                var p, c = ((c(\"nav-wishlist\").length || c(\"nav-cart\").length)), g = 0;\n                ((l && (g = ((l.width + 19)), s = l.getContent(), r.css(\"margin-left\", g).prepend(b(\"\\u003Cdiv id=\\\"nav_ya_sidebar_wrapper\\\"\\u003E\\u003C/div\\u003E\").css({\n                    width: ((g - 15)),\n                    left: -g\n                }).append(s)))));\n                q.registerTrigger({\n                    localContent: \"#nav_your_account_flyout\",\n                    locationAlign: ((c ? \"left\" : \"right\")),\n                    locationOffset: [((g ? -g : ((f.ie6 ? ((c ? 3 : -3)) : 0)))),0,],\n                    skin: e(h, ((((c || !f.ie6)) ? 0 : 7))),\n                    onShow: function() {\n                        q.onShow();\n                        if (((l && l.onShow))) {\n                            l.onShow();\n                        }\n                    ;\n                    ;\n                        d.disable(\"#nav_your_account_flyout\");\n                        p = window.JSBNG__setTimeout(function() {\n                            var a = {\n                                t: \"ya\"\n                            };\n                            ((((l && l.JSBNG__event)) && (a[l.JSBNG__event] = 1)));\n                            i(a);\n                        }, 750);\n                        ((s && s.height(r.height())));\n                        k();\n                    },\n                    onHide: function() {\n                        JSBNG__clearTimeout(p);\n                        d.enable();\n                        q.onHide();\n                    },\n                    followLink: !f.touch\n                });\n                ((m && b(\"#nav-item-signout\").html(m)));\n                a.declare(\"flyout.youraccount\");\n            }\n        ;\n        ;\n        });\n        a.when(\"$\", \"$byID\", \"areaMapper\", \"agent\", \"logEvent\", \"triggerProceedToCheckout\", \"flyout.NavButton\", \"flyout.SKIN\", \"flyout.loadMenusConditionally\", \"recordEv\", \"nav.inline\", \"flyout.JSBNG__content\").run(\"Cart\", function(b, c, d, f, i, g, e, k, h, j) {\n            if (((c(\"nav-cart\").length && c(\"nav_cart_flyout\").length))) {\n                var m = !1, l = new e(\"nav-cart\"), c = c(\"nav-cart\"), r;\n                l.registerTrigger({\n                    localContent: \"#nav_cart_flyout\",\n                    locationAlign: \"right\",\n                    locationOffset: [((f.ie6 ? -3 : 0)),0,],\n                    skin: k(c, ((f.ie6 ? 7 : 0))),\n                    onShow: function() {\n                        l.onShow();\n                        d.disable(\"#nav_cart_flyout\");\n                        r = window.JSBNG__setTimeout(function() {\n                            i({\n                                t: \"cart\"\n                            });\n                            ((((!m && ((0 < b(\".nav_cart_item\").length)))) && (j(21381), m = !0)));\n                        }, 750);\n                        h();\n                        g();\n                    },\n                    onHide: function() {\n                        JSBNG__clearTimeout(r);\n                        d.enable();\n                        l.onHide();\n                    },\n                    followLink: !f.touch\n                });\n                a.declare(\"flyout.cart\");\n            }\n        ;\n        ;\n        });\n        a.when(\"$\", \"$byID\", \"areaMapper\", \"agent\", \"logEvent\", \"flyout.NavButton\", \"flyout.SKIN\", \"flyout.loadMenusConditionally\", \"nav.inline\", \"flyout.JSBNG__content\").run(\"WishList\", function(b, c, d, f, i, g, e, k) {\n            if (((c(\"nav-wishlist\").length && c(\"nav_wishlist_flyout\").length))) {\n                var h = new g(\"nav-wishlist\"), c = c(\"nav-wishlist\"), j;\n                h.registerTrigger({\n                    localContent: \"#nav_wishlist_flyout\",\n                    locationAlign: \"right\",\n                    locationOffset: [((f.ie6 ? -3 : 0)),0,],\n                    skin: e(c, ((f.ie6 ? 7 : 0))),\n                    onShow: function() {\n                        h.onShow();\n                        d.disable(\"#nav_wishlist_flyout\");\n                        j = window.JSBNG__setTimeout(function() {\n                            i({\n                                t: \"wishlist\"\n                            });\n                        }, 750);\n                        k();\n                        var a = b(\"#nav_wishlist_flyout\"), c = a.JSBNG__outerWidth();\n                        a.css(\"width\", c).JSBNG__find(\".nav_pop_ul\").css(\"width\", c).addClass(\"nav_pop_ul_wrap\");\n                    },\n                    onHide: function() {\n                        JSBNG__clearTimeout(j);\n                        b(\"#nav_wishlist_flyout\").css(\"width\", \"\").JSBNG__find(\".nav_pop_ul\").css(\"width\", \"\").removeClass(\"nav_pop_ul_wrap\");\n                        d.enable();\n                        h.onHide();\n                    },\n                    followLink: !f.touch\n                });\n                a.declare(\"flyout.wishlist\");\n            }\n        ;\n        ;\n        });\n        a.when(\"$\", \"$byID\", \"flyout.NavButton\", \"areaMapper\", \"logEvent\", \"agent\", \"nav.inline\", \"flyout.JSBNG__content\").run(\"PrimeTooltip\", function(a, c, d, f, i, g) {\n            if (((((!c(\"navbar\").hasClass(\"nav-prime\") && c(\"nav-prime-ttt\").length)) && c(\"nav-prime-tooltip\").length))) {\n                var e = new d(\"nav-prime-ttt\"), c = c(\"nav-prime-ttt\"), k, d = a(\"#navbar\").hasClass(\"nav-logo-large\"), a = a.browser.msie;\n                c.css(\"padding-right\", ((d ? \"21px\" : \"25px\")));\n                e.registerTrigger({\n                    localContent: \"#nav-prime-tooltip\",\n                    width: null,\n                    JSBNG__location: \"right\",\n                    locationAlign: \"JSBNG__top\",\n                    locationOffset: [((a ? -3 : 0)),((d ? -35 : -26)),],\n                    onShow: function() {\n                        e.onShow();\n                        f.disable(\"#nav-prime-tooltip\");\n                        k = window.JSBNG__setTimeout(function() {\n                            i({\n                                t: \"prime-tt\"\n                            });\n                        }, 750);\n                    },\n                    onHide: function() {\n                        JSBNG__clearTimeout(k);\n                        f.enable();\n                        e.onHide();\n                    },\n                    zIndex: 201,\n                    skin: ((((((((\"\\u003Cdiv class=\\\"nav-tt-skin\" + ((d ? \" nav-logo-large\" : \"\")))) + \"\\\"\\u003E\\u003Cdiv class=\\\"nav-tt-border\")) + ((a ? \"\" : \" nav-tt-box-shadow\")))) + \"\\\"\\u003E\\u003Cdiv class=\\\"ap_content\\\"\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"nav-tt-beak\\\"\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"nav-tt-beak-2\\\"\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\")),\n                    followLink: !g.touch\n                });\n            }\n        ;\n        ;\n        });\n        a.when(\"$byID\", \"areaMapper\", \"logEvent\", \"agent\", \"config.dynamicMenuArgs\", \"flyout.NavButton\", \"flyout.SKIN\", \"flyout.primeAjax\", \"flyout.loadMenusConditionally\", \"nav.inline\", \"flyout.JSBNG__content\").run(\"PrimeMenu\", function(b, c, d, f, i, g, e, k, h) {\n            if (((b(\"nav-your-prime\").length && b(\"nav-prime-menu\").length))) {\n                var j = new g(\"nav-your-prime\"), g = b(\"nav-your-prime\"), m;\n                ((k && b(\"nav-prime-menu\").css({\n                    width: i.primeMenuWidth\n                })));\n                j.registerTrigger({\n                    localContent: \"#nav-prime-menu\",\n                    locationAlign: \"right\",\n                    locationOffset: [((f.ie6 ? -3 : 0)),0,],\n                    skin: e(g, ((f.ie6 ? 7 : 0))),\n                    onShow: function() {\n                        j.onShow();\n                        c.disable(\"#nav-prime-menu\");\n                        m = window.JSBNG__setTimeout(function() {\n                            d({\n                                t: \"prime\"\n                            });\n                        }, 750);\n                        ((k && h()));\n                    },\n                    onHide: function() {\n                        JSBNG__clearTimeout(m);\n                        c.enable();\n                        j.onHide();\n                    },\n                    followLink: !f.touch\n                });\n                a.declare(\"flyout.prime\");\n            }\n        ;\n        ;\n        });\n        a.when(\"$\", \"$byID\", \"agent\", \"template\", \"nav.inline\").build(\"flyout.initBrowsePromos\", function(b, c, d, f) {\n            var i = !1;\n            return function() {\n                var g = a.getNow(\"config.browsePromos\");\n                ((((g && !i)) && (i = !0, b(\"#nav_browse_flyout .nav_browse_subcat\").each(function() {\n                    var a = b(this), i = a.attr(\"data-nav-promo-id\");\n                    if (i) {\n                        var h = g[i];\n                        if (h) {\n                            if (h.promoType) {\n                                ((((\"wide\" == h.promoType)) && a.addClass(\"nav_super_cat\")));\n                                var i = ((\"nav_imgmap_\" + i)), j = ((d.ie6 ? 15 : 14)), m = ((parseInt(h.vertOffset, 10) - j)), l = parseInt(h.horizOffset, 10), r = (((j = ((d.ie6 && /\\.png$/i.test(h.image)))) ? c(\"nav_trans_pixel\").attr(\"src\") : h.image)), i = b(\"\\u003Cimg\\u003E\").attr({\n                                    src: r,\n                                    alt: h.alt,\n                                    useMap: ((\"#\" + i))\n                                }).addClass(\"nav_browse_promo\").css({\n                                    bottom: m,\n                                    right: l,\n                                    width: h.width,\n                                    height: h.height\n                                });\n                                a.prepend(i);\n                                ((j && (i.get(0).style.filter = ((((\"progid:DXImageTransform.Microsoft.AlphaImageLoader(src='\" + h.image)) + \"',sizingMethod='scale')\")))));\n                            }\n                             else a.prepend(f(\"#nav-tpl-asin-promo\", h));\n                        ;\n                        }\n                    ;\n                    ;\n                    }\n                ;\n                ;\n                }))));\n            };\n        });\n        a.when(\"$\", \"agent\", \"config.flyoutURL\", \"btf.full\").run(\"FlyoutContent\", function(b, c, d) {\n            window._navbar.flyoutContent = function(c) {\n                var d = b(\"\\u003Cdiv\\u003E\").appendTo(JSBNG__document.body).hide().get(0), g = \"\", e;\n                {\n                    var fin29keys = ((window.top.JSBNG_Replay.forInKeys)((c))), fin29i = (0);\n                    (0);\n                    for (; (fin29i < fin29keys.length); (fin29i++)) {\n                        ((e) = (fin29keys[fin29i]));\n                        {\n                            ((c.hasOwnProperty(e) && (g += c[e])));\n                        ;\n                        };\n                    };\n                };\n            ;\n                d.innerHTML = g;\n                a.declare(\"flyout.JSBNG__content\");\n            };\n            ((d ? (c = JSBNG__document.createElement(\"script\"), c.setAttribute(\"type\", \"text/javascript\"), c.setAttribute(\"src\", d), ((JSBNG__document.head || JSBNG__document.getElementsByTagName(\"head\")[0])).appendChild(c)) : a.declare(\"flyout.JSBNG__content\")));\n        });\n        a.when(\"$\", \"$byID\", \"template\", \"config.enableDynamicMenus\", \"config.dynamicMenuUrl\", \"config.dynamicMenuArgs\", \"config.ajaxProximity\", \"flyout.primeAjax\", \"nav.inline\").run(\"DynamicAjaxMenu\", function(b, c, d, f, i, g, e, k) {\n            function h() {\n                JSBNG__setTimeout(function() {\n                    s = !1;\n                }, 5000);\n            };\n        ;\n            function j() {\n                a.when(\"flyout.JSBNG__content\").run(\"LoadDynamicMenu\", function() {\n                    if (((!q && !r))) {\n                        q = !0;\n                        var e = c(\"nav_wishlist_flyout\"), f = c(\"nav_cart_flyout\"), j = b(e).add(f), l = b(\".nav_dynamic\", e), m = b(\".nav_dynamic\", f);\n                        if (k) {\n                            var n = c(\"nav-prime-menu\"), j = j.add(n), p = b(\".nav_dynamic\", n);\n                        }\n                    ;\n                    ;\n                        a.getNow(\"preloadSpinner\", function() {\n                        \n                        })();\n                        j.addClass(\"nav-ajax-loading\").removeClass(\"nav-ajax-error nav-empty\");\n                        j.JSBNG__find(\".nav-ajax-success\").hide();\n                        b.AmazonPopover.updateBacking(\"navbar\");\n                        b.ajax({\n                            url: i,\n                            data: g,\n                            dataType: \"json\",\n                            cache: !1,\n                            timeout: 10000,\n                            complete: function() {\n                                j.removeClass(\"nav-ajax-loading\");\n                                b.AmazonPopover.updateBacking(\"navbar\");\n                                q = !1;\n                            },\n                            error: function() {\n                                j.addClass(\"nav-ajax-error\");\n                                h();\n                            },\n                            success: function(c) {\n                                function g(a, b, e, f, h, i) {\n                                    ((a ? (((b ? e.addClass(\"nav-empty\").removeClass(\"nav-full\") : e.addClass(\"nav-full\").removeClass(\"nav-empty\"))), i.html(((f || d(h, c)))), e.JSBNG__find(\".nav-ajax-success\").show()) : e.addClass(\"nav-ajax-error\")));\n                                };\n                            ;\n                                c = b.extend({\n                                    cartDataStatus: !1,\n                                    cartCount: 0,\n                                    cart: [],\n                                    wishlistDataStatus: !1,\n                                    wishlist: [],\n                                    primeMenu: null\n                                }, c);\n                                ((c.cartDataStatus && a.getNow(\"api.setCartCount\", function() {\n                                \n                                })(c.cartCount)));\n                                ((k && g(!!c.primeMenu, !c.primeMenu, n, c.primeMenu, null, p)));\n                                g(c.cartDataStatus, ((0 === c.cart.length)), f, null, \"#nav-tpl-cart\", m);\n                                g(c.wishlistDataStatus, ((0 === c.wishlist.length)), e, null, \"#nav-tpl-wishlist\", l);\n                                ((((c.cartDataStatus && c.wishlistDataStatus)) ? r = !0 : h()));\n                            }\n                        });\n                    }\n                ;\n                ;\n                });\n            };\n        ;\n            function m() {\n                ((s || j()));\n                s = !0;\n                ((p || (p = !0, a.declare(\"JSBNG__event.prefetch\"))));\n                return !0;\n            };\n        ;\n            function l() {\n                var a = [], c = [], d = [], f = [];\n                b(\"#nav-wishlist, #nav-cart\").each(function(e, g) {\n                    var g = b(g), h = g.offset();\n                    a.push(h.left);\n                    d.push(h.JSBNG__top);\n                    c.push(((h.left + g.width())));\n                    f.push(((h.JSBNG__top + g.height())));\n                });\n                var g = ((e || [0,0,0,0,])), h = ((Math.min.apply(Math, a) - g[3])), i = ((Math.min.apply(Math, d) - g[0])), k = ((((Math.max.apply(Math, c) + g[1])) - h)), g = ((((Math.max.apply(Math, f) + g[2])) - i));\n                b.AmazonPopover.mouseTracker.add([[h,i,k,g,],], {\n                    inside: !1,\n                    mouseEnter: m,\n                    mouseLeave: function() {\n                        return !0;\n                    }\n                });\n                b(\"#nav_wishlist_flyout, #nav_cart_flyout\").JSBNG__find(\".nav-try-again\").click(j);\n            };\n        ;\n            var r = !f, s = !f;\n            a.declare(\"unlockDynamicMenus\", function() {\n                s = r = !1;\n            });\n            var q = !1, p;\n            a.declare(\"flyout.loadMenusConditionally\", m);\n            ((i && a.when(\"page.ready\").run(l)));\n        });\n    })(window.$Nav);\n    window.$Nav.when(\"$\", \"onOptionClick\", \"throttle\", \"byID\", \"$byID\", \"btf.lite\", \"nav.inline\").run(\"SearchDropdown\", function(a, b, c, d, f) {\n        function i() {\n            var a = q.width();\n            ((((s.width() < a)) && s.width(a)));\n        };\n    ;\n        function g() {\n            if (u.isFocus) {\n                q.addClass(\"JSBNG__focus\").removeClass(\"active\");\n                var a = JSBNG__document.createElement(\"div\");\n                q.append(a);\n                JSBNG__setTimeout(function() {\n                    a.parentNode.removeChild(a);\n                }, 10);\n            }\n             else ((((((u.isHover || u.searchFocus)) || u.searchHover)) ? q.addClass(\"active\").removeClass(\"JSBNG__focus\") : q.removeClass(\"active focus\")));\n        ;\n        ;\n        };\n    ;\n        function e() {\n            var b = a(p).width();\n            return ((((((195 < b)) || ((((100 < b)) && ((400 >= A.JSBNG__outerWidth())))))) ? !0 : !1));\n        };\n    ;\n        function k() {\n            a(q).add(p).css({\n                width: \"auto\"\n            });\n            a(p).css({\n                overflow: \"visible\"\n            });\n            ((e() && a(p).css({\n                width: 100,\n                overflow: \"hidden\"\n            })));\n            JSBNG__setTimeout(function() {\n                A.css({\n                    \"padding-left\": q.width()\n                });\n                ((a.browser.msie || t.css(\"padding-right\", ((parseInt(t.css(\"padding-right\"), 10) ? 0 : 1)))));\n                i();\n            }, 1);\n        };\n    ;\n        function h() {\n            var b;\n            a:\n            {\n                var c = r.children.length;\n                for (b = 0; ((b < c)); b++) {\n                    if (r.children[b].selected) {\n                        b = a(r.children[b]);\n                        break a;\n                    }\n                ;\n                ;\n                };\n            ;\n                b = s.children(\"option:selected\");\n            };\n        ;\n            c = b.val();\n            ((((c !== v)) && (b = ((((v || ((c !== w)))) ? b.html() : p.innerHTML)), v = c, ((((p.innerHTML !== b)) && (p.innerHTML = b, k()))))));\n            g();\n        };\n    ;\n        function j() {\n            var a = window.$Nav.getNow(\"iss\");\n            ((a && (u.isFocus = !1, a.JSBNG__focus())));\n        };\n    ;\n        function m(a) {\n            ((((13 === a.which)) && j()));\n            ((((((9 !== a.which)) && ((16 !== a.which)))) && h()));\n        };\n    ;\n        function l(a, b) {\n            return function() {\n                u[a] = b;\n                g();\n            };\n        };\n    ;\n        var r = d(\"searchDropdownBox\"), s = a(r), q = f(\"nav-search-in\"), p = d(\"nav-search-in-content\"), t = f(\"twotabsearchtextbox\"), A;\n        a:\n        {\n            d = t;\n            for (f = t.parent(); d.length; ) {\n                if (d.is(\".nav-searchfield-width\")) {\n                    A = d;\n                    break a;\n                }\n            ;\n            ;\n                d = d.parent();\n            };\n        ;\n            A = f;\n        };\n    ;\n        var w = ((((p.getAttribute && p.getAttribute(\"data-value\"))) || a(p).attr(\"data-value\"))), u = {\n            isHover: !1,\n            isFocus: !1,\n            searchFocus: !1,\n            searchHover: !1\n        }, v = null;\n        if (a.browser.msie) {\n            if (((7 > parseFloat(a.browser.version)))) {\n                window.$Nav.declare(\"refreshDropDownFacade\", function() {\n                \n                });\n                return;\n            }\n        ;\n        ;\n            q.addClass(\"ie\");\n        }\n    ;\n    ;\n        window.$Nav.declare(\"refreshDropDownFacade\", h);\n        q.get(0).className += \" nav-facade-active\";\n        h();\n        s.change(h).keyup(m).JSBNG__focus(l(\"isFocus\", !0)).JSBNG__blur(l(\"isFocus\", !1)).hover(l(\"isHover\", !0), l(\"isHover\", !1));\n        window.$Nav.when(\"dismissTooltip\").run(function(a) {\n            s.JSBNG__focus(a);\n        });\n        b(s, function() {\n            j();\n            h();\n        });\n        a(window).resize(c(150, k));\n        window.$Nav.when(\"page.ready\").run(\"FixSearchDropdown\", function() {\n            ((((((4 <= ((a(p).JSBNG__outerWidth(!0) - q.JSBNG__outerWidth())))) || e())) && k()));\n            i();\n            s.css({\n                JSBNG__top: Math.max(0, ((((q.JSBNG__outerHeight() - s.JSBNG__outerHeight())) / 2)))\n            });\n        });\n        window.$Nav.when(\"iss\").run(function(a) {\n            a.keydown(function(a) {\n                JSBNG__setTimeout(function() {\n                    m(a);\n                }, 10);\n            });\n            window.$Nav.when(\"dismissTooltip\").run(function(b) {\n                a.keydown(b);\n            });\n            a.onFocus(l(\"searchFocus\", !0));\n            a.onBlur(l(\"searchFocus\", !1));\n            a.onBlur(h);\n            if (a.onSearchBoxHover) {\n                a.onSearchBoxHover(l(\"searchHover\", !0), l(\"searchHover\", !1));\n            }\n        ;\n        ;\n        });\n    });\n    window.$Nav.when(\"$\").build(\"Keycode\", function(a) {\n        function b(a) {\n            this.evt = a;\n            this.code = a.keyCode;\n        };\n    ;\n        b.prototype.isAugmented = function() {\n            return ((((this.evt.altKey || this.evt.ctrlKey)) || this.evt.metaKey));\n        };\n        b.prototype.isAugmentor = function() {\n            return ((0 <= a.inArray(this.code, [0,16,20,17,18,224,91,93,])));\n        };\n        b.prototype.isTextFieldControl = function() {\n            return ((0 <= a.inArray(this.code, [8,9,13,32,35,36,37,38,39,40,45,46,])));\n        };\n        b.prototype.isControl = function() {\n            return ((((((((46 >= this.code)) || ((((91 <= this.code)) && ((95 >= this.code)))))) || ((((112 <= this.code)) && ((145 >= this.code)))))) ? !0 : !1));\n        };\n        b.prototype.isTab = function() {\n            return ((9 === this.code));\n        };\n        b.prototype.isEnter = function() {\n            return ((13 === this.code));\n        };\n        b.prototype.isBackspace = function() {\n            return ((8 === this.code));\n        };\n        return b;\n    });\n    window.$Nav.when(\"$\", \"agent\", \"iss\", \"Keycode\", \"config.autoFocus\", \"nav.inline\").run(\"autoFocus\", function(a, b, c, d, f) {\n        function i() {\n            return ((((((a(JSBNG__document).scrollTop() <= a(\"#nav-iss-attach\").offset().JSBNG__top)) && ((1 > a(JSBNG__document.activeElement).filter(\"input,select,textarea\").size())))) && ((\"\" === ((window.JSBNG__getSelection ? window.JSBNG__getSelection().toString() : ((JSBNG__document.selection ? JSBNG__document.selection.createRange().text : \"\"))))))));\n        };\n    ;\n        if (((f && !b.touch))) {\n            var g = !1;\n            ((i() && (c.JSBNG__focus(), g = !0)));\n            c.keydown(function(a) {\n                a = new d(a);\n                if (!a.isAugmentor()) {\n                    var b = a.isControl();\n                    ((a.isAugmented() || ((g ? ((i() ? ((b && c.JSBNG__blur())) : c.JSBNG__blur())) : ((b && ((a.isTextFieldControl() ? ((((((\"\" === c.keyword())) && ((((!a.isTab() && !a.isEnter())) && !a.isBackspace())))) && c.JSBNG__blur())) : c.JSBNG__blur()))))))));\n                    g = !1;\n                }\n            ;\n            ;\n            });\n            a(JSBNG__document).keydown(function(a) {\n                a = new d(a);\n                ((i() && ((a.isControl() || ((((!a.isAugmentor() && !a.isAugmented())) && c.JSBNG__focus()))))));\n            });\n        }\n    ;\n    ;\n    });\n    window.$Nav.when(\"$\", \"byID\", \"agent\", \"api.publish\", \"config.lightningDeals\", \"nav.inline\").run(\"UpdateAPI\", function(a, b, c, d, f) {\n        function i(c) {\n            if (((c instanceof Object))) {\n                window.$Nav.getNow(\"unlockDynamicMenus\", function() {\n                \n                })();\n                var d = [], h = [];\n                if (c.catsubnav) {\n                    try {\n                        var i = a(\"#nav-subnav\");\n                        if (((0 < i.length))) {\n                            var m = ((c.catsubnav.digest || \"\"));\n                            if (((!m || ((m !== i.attr(\"data-digest\")))))) {\n                                var l = 0, r = [], s = c.catsubnav.category;\n                                if (((s && ((\"link\" == s.type))))) {\n                                    var q = a(\"li.nav-category-button:first\", i);\n                                    if (((0 === q.length))) {\n                                        throw \"category-1\";\n                                    }\n                                ;\n                                ;\n                                    var p = s.data;\n                                    if (((!p.href || !p.text))) {\n                                        throw \"category-2\";\n                                    }\n                                ;\n                                ;\n                                    var t = q.clone(), A = a(\"a:first\", t);\n                                    if (((0 === A.length))) {\n                                        throw \"category-3\";\n                                    }\n                                ;\n                                ;\n                                    A.attr(\"href\", p.href).html(p.text);\n                                    r.push(t.get(0));\n                                    l += 1;\n                                }\n                            ;\n                            ;\n                                var w = c.catsubnav.subnav;\n                                if (((w && ((\"linkSequence\" == w.type))))) {\n                                    var u = a(\"li.nav-subnav-item\", i).slice(-1);\n                                    if (((0 === u.length))) {\n                                        throw \"subnav-1\";\n                                    }\n                                ;\n                                ;\n                                    for (var v = 0; ((v < w.data.length)); v++) {\n                                        var n = w.data[v];\n                                        if (((!n.href || !n.text))) {\n                                            throw \"subnav-2\";\n                                        }\n                                    ;\n                                    ;\n                                        var x = u.clone(), B = a(\"a:first\", x);\n                                        if (((0 === B.length))) {\n                                            throw \"subnav-3\";\n                                        }\n                                    ;\n                                    ;\n                                        B.attr(\"href\", n.href).html(n.text);\n                                        r.push(x.get(0));\n                                    };\n                                ;\n                                    ((((1 < r.length)) && (l += 1)));\n                                }\n                            ;\n                            ;\n                                var z = a(\"#navbar\");\n                                if (((0 === z.length))) {\n                                    throw \"catsubnav-1\";\n                                }\n                            ;\n                            ;\n                                ((((2 == l)) ? d.push(function() {\n                                    i.empty().append(r).css(\"display\", \"\").attr(\"data-digest\", m);\n                                    z.addClass(\"nav-subnav\");\n                                }) : ((((0 === l)) && d.push(function() {\n                                    z.removeClass(\"nav-subnav\");\n                                    i.css(\"display\", \"none\").attr(\"data-digest\", \"0\");\n                                })))));\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                    } catch (E) {\n                        return g = ((\"navbar.update() error: \" + E)), !1;\n                    };\n                }\n            ;\n            ;\n                if (c.cart) {\n                    try {\n                        var C = c.cart;\n                        if (((((\"countPlusLD\" == C.type)) || ((\"count\" == C.type))))) {\n                            if (!C.data) {\n                                throw \"cart-1\";\n                            }\n                        ;\n                        ;\n                            var y = ((C.data.count + \"\"));\n                            if (!y.match(/^(|0|[1-9][0-9]*|99\\+)$/)) {\n                                throw \"cart-2\";\n                            }\n                        ;\n                        ;\n                            var J = a(\"#nav-cart-count, #nav_cart_flyout .nav-cart-count\");\n                            ((((0 < J.length)) && d.push(function() {\n                                var c = \"nav-cart-0\";\n                                ((((\"99+\" == y)) ? c = \"nav-cart-100\" : ((((99 < y)) ? (y = \"99+\", c = \"nav-cart-100\") : ((((19 < y)) ? c = \"nav-cart-20\" : ((((9 < y)) && (c = \"nav-cart-10\")))))))));\n                                J.removeClass(\"nav-cart-0 nav-cart-10 nav-cart-20 nav-cart-100\").addClass(c).html(y);\n                                ((((((0 === y)) && b(\"nav-cart-zero\"))) ? (a(\"#nav-cart-one, #nav-cart-many\").hide(), a(\"#nav-cart-zero\").show()) : ((((1 == y)) ? (a(\"#nav-cart-zero, #nav-cart-many\").hide(), a(\"#nav-cart-one\").show()) : (a(\"#nav-cart-zero, #nav-cart-one\").hide(), a(\"#nav-cart-many\").show())))));\n                            })));\n                            var K = C.data.LDData;\n                            ((K && d.push(function() {\n                                f = K;\n                            })));\n                        }\n                    ;\n                    ;\n                    } catch (N) {\n                        return g = ((\"navbar.update() error: \" + N)), !1;\n                    };\n                }\n            ;\n            ;\n                if (c.searchbar) {\n                    try {\n                        var F = c.searchbar;\n                        if (((\"searchbar\" == F.type))) {\n                            if (!F.data) {\n                                throw \"searchbar-1\";\n                            }\n                        ;\n                        ;\n                            var G = F.data.options;\n                            if (((!G || ((0 === G.length))))) {\n                                throw \"searchbar-2\";\n                            }\n                        ;\n                        ;\n                            var H = ((F.data[\"nav-metadata\"] || {\n                            })), D = a(\"#searchDropdownBox\");\n                            ((((0 === D.length)) && (D = a(\"#navSearchDropdown select:first\"))));\n                            if (((0 === D.length))) {\n                                throw \"searchbar-3\";\n                            }\n                        ;\n                        ;\n                            ((((!H.digest || ((H.digest !== D.attr(\"data-nav-digest\"))))) ? d.push(function() {\n                                D.JSBNG__blur().empty();\n                                for (var b = 0; ((b < G.length)); b++) {\n                                    var c = G[b], d = ((c._display || \"\"));\n                                    delete c._display;\n                                    a(\"\\u003Coption\\u003E\\u003C/option\\u003E\").html(d).attr(c).appendTo(D);\n                                };\n                            ;\n                                D.attr(\"data-nav-digest\", ((H.digest || \"\"))).attr(\"data-nav-selected\", ((H.selected || 0)));\n                                window.$Nav.getNow(\"refreshDropDownFacade\", function() {\n                                \n                                })();\n                            }) : ((((H.selected != D.attr(\"data-nav-selected\"))) && d.push(function() {\n                                D.attr(\"data-nav-selected\", H.selected).get(0).selectedIndex = H.selected;\n                                window.$Nav.getNow(\"refreshDropDownFacade\", function() {\n                                \n                                })();\n                            })))));\n                        }\n                    ;\n                    ;\n                    } catch (ba) {\n                        return g = ((\"navbar.update() error: \" + ba)), !1;\n                    };\n                }\n            ;\n            ;\n                if (c.primeBadge) {\n                    try {\n                        var Y = c.primeBadge.isPrime;\n                        if (((\"boolean\" == Y.type))) {\n                            z = a(\"#navbar\");\n                            if (((0 === z.length))) {\n                                throw \"primeBadge-1\";\n                            }\n                        ;\n                        ;\n                            d.push(function() {\n                                ((Y.data ? z.addClass(\"nav-prime\") : z.removeClass(\"nav-prime\")));\n                            });\n                        }\n                    ;\n                    ;\n                        var Q = c.primeBadge.homeUrl;\n                        if (((\"html\" == Q.type))) {\n                            var X = a(\"#nav-logo\");\n                            if (((0 === X.length))) {\n                                throw \"primeBadge-2\";\n                            }\n                        ;\n                        ;\n                            ((Q.data && d.push(function() {\n                                X.attr(\"href\", Q.data);\n                            })));\n                        }\n                    ;\n                    ;\n                    } catch (ca) {\n                        return g = ((\"navbar.update() error: \" + ca)), !1;\n                    };\n                }\n            ;\n            ;\n                if (c.swmSlot) {\n                    try {\n                        var I = c.swmSlot.swmContent;\n                        if (((I && ((\"html\" == I.type))))) {\n                            var M = a(\"#navSwmSlot\");\n                            if (((0 === M.length))) {\n                                throw \"swmContent-1\";\n                            }\n                        ;\n                        ;\n                            ((I.data && d.push(function() {\n                                M.html(I.data);\n                            })));\n                        }\n                    ;\n                    ;\n                        var O = c.swmSlot.height;\n                        if (((O && ((\"html\" == O.type))))) {\n                            var Z = a(\"#welcomeRowTable\");\n                            if (((0 === Z.length))) {\n                                throw \"swmSlotHeight-1\";\n                            }\n                        ;\n                        ;\n                            d.push(function() {\n                                Z.css(\"height\", ((O.data || \"\")));\n                                var b = /-(small|large)$/, c = a(\"#navbar\");\n                                a(c.attr(\"class\").split(/\\s+/)).filter(function() {\n                                    return b.test(this);\n                                }).each(function() {\n                                    var a = ((40 < parseInt(((O.data || 0)), 10))), a = this.replace(b, ((a ? \"-large\" : \"-small\")));\n                                    c.removeClass(this).addClass(a);\n                                });\n                            });\n                        }\n                    ;\n                    ;\n                        var R = c.swmSlot.style;\n                        if (((R && ((\"html\" == R.type))))) {\n                            var $ = a(\"#nav-ad-background-style\");\n                            if (((0 === $.length))) {\n                                throw \"swmSlotStyle-1\";\n                            }\n                        ;\n                        ;\n                            d.push(function() {\n                                $.attr(\"style\", ((R.data || \"\")));\n                            });\n                        }\n                    ;\n                    ;\n                    } catch (da) {\n                        return g = ((\"navbar.update() error: \" + da)), !1;\n                    };\n                }\n            ;\n            ;\n                if (c.signInText) {\n                    try {\n                        var S = c.signInText.customerName, T = c.signInText.greetingText;\n                        if (((((\"html\" == S.type)) && T.type))) {\n                            var U = a(\"#nav-signin-title\");\n                            if (((0 === U.length))) {\n                                throw \"signInText-1\";\n                            }\n                        ;\n                        ;\n                            var L = U.attr(\"data-template\");\n                            ((((L && ((T.data && S.data)))) && (L = L.replace(\"{helloText}\", T.data), L = L.replace(\"{signInText}\", S.data), d.push(function() {\n                                U.html(L);\n                            }))));\n                        }\n                    ;\n                    ;\n                    } catch (ea) {\n                        return g = ((\"navbar.update() error: \" + ea)), !1;\n                    };\n                }\n            ;\n            ;\n                if (c.yourAccountLink) {\n                    try {\n                        var V = c.yourAccountLink;\n                        if (((\"html\" == V.type))) {\n                            var aa = a(\"#nav-your-account\");\n                            if (((0 === aa.length))) {\n                                throw \"your-account-1\";\n                            }\n                        ;\n                        ;\n                            ((V.data && d.push(function() {\n                                aa.attr(\"href\", V.data);\n                            })));\n                        }\n                    ;\n                    ;\n                    } catch (fa) {\n                        return g = ((\"navbar.update() error: \" + fa)), !1;\n                    };\n                }\n            ;\n            ;\n                if (c.crossShop) {\n                    try {\n                        var P = c.crossShop;\n                        if (((\"html\" == P.type))) {\n                            var W = a(\"#nav-your-amazon\");\n                            if (((0 === W.length))) {\n                                throw \"yourAmazonText-1\";\n                            }\n                        ;\n                        ;\n                            d.push(function() {\n                                ((((P.data && ((W.text() != P.data)))) && W.html(P.data)));\n                            });\n                        }\n                    ;\n                    ;\n                        h.push(function() {\n                            a(\"#nav-cross-shop-links\").css(\"display\", \"\");\n                        });\n                    } catch (ga) {\n                        return g = ((\"navbar.update() error: \" + ga)), !1;\n                    };\n                }\n            ;\n            ;\n                if (((0 < d.length))) {\n                    try {\n                        for (v = 0; ((v < d.length)); v++) {\n                            d[v]();\n                        ;\n                        };\n                    ;\n                    } catch (ha) {\n                        return g = ((\"navbar.update() error: \" + ha)), !1;\n                    } finally {\n                        for (v = 0; ((v < h.length)); v++) {\n                            h[v]();\n                        ;\n                        };\n                    ;\n                    };\n                ;\n                    return !0;\n                }\n            ;\n            ;\n                g = ((\"navbar.update() error: \" + ((c.error || \"unknown error\"))));\n            }\n             else g = \"navbar.update() error: parameter not an Object\";\n        ;\n        ;\n            return !1;\n        };\n    ;\n        var g = \"no error\";\n        d(\"error\", function() {\n            return g;\n        });\n        d(\"update\", i);\n        d(\"setCartCount\", function(a) {\n            return i({\n                cart: {\n                    type: \"count\",\n                    data: {\n                        count: a\n                    }\n                }\n            });\n        });\n        d(\"getLightningDealsData\", function() {\n            return ((f || {\n            }));\n        });\n        d(\"overrideCartButtonClick\", function(b) {\n            ((c.touch || a(\"#nav-cart\").click(b)));\n            a(\"#nav-cart-menu-button\").click(b);\n        });\n    });\n    window.navbar = {\n    };\n    window.$Nav.when(\"depend\").build(\"api.publish\", function(a) {\n        var b = window.$Nav, c = a({\n            parent: b,\n            prefix: \"api\",\n            bubble: !1\n        });\n        window.navbar.use = function(a, b) {\n            c.when(a).run(b);\n        };\n        return function(a, f) {\n            c.publish(a, f);\n            window.navbar[a] = f;\n            b.publish(((\"nav.\" + a)), f);\n        };\n    });\n    window.$Nav.when(\"$\", \"api.publish\", \"config.swmStyleData\").run(\"ExternalAPI\", function(a, b, c) {\n        b(\"unHideSWM\", function() {\n            var b = a(\"#navHiddenSwm\");\n            if (b.length) {\n                a(\"#navbar\").removeClass(\"nav-logo-small nav-logo-large\").addClass(((\"nav-logo-\" + ((((40 < parseInt(((c.height || 0)), 10))) ? \"large\" : \"small\")))));\n                a(\"#welcomeRowTable\").css(\"height\", ((c.height || \"\")));\n                var d = a(\"#navSwmSlot\");\n                d.parent().attr(\"style\", ((c.style || \"\")));\n                d.children().css(\"display\", \"none\");\n                b.css(\"display\", \"\");\n            }\n        ;\n        ;\n        });\n        var d;\n        b(\"exposeSBD\", function(a) {\n            d = a;\n            window.$Nav.when(\"initExposeSBD\", \"protectExposeSBD\").run(function(a, b) {\n                ((a().ok() && b(d)));\n            });\n        });\n        b(\"navDimensions\", function() {\n            var b = a(\"#navbar\"), c = b.offset();\n            c.height = b.height();\n            c.bottom = ((c.JSBNG__top + c.height));\n            return c;\n        });\n        window.$Nav.when(\"api.unHideSWM\", \"api.exposeSBD\", \"api.navDimensions\").publish(\"navbarJSLoaded\");\n    });\n    if (((!window.$SearchJS && window.$Nav))) {\n        window.$SearchJS = $Nav.make();\n    }\n;\n;\n    if (window.$SearchJS) {\n        $SearchJS.importEvent(\"legacy-popover\", {\n            as: \"popover\",\n            amznJQ: \"popover\"\n        });\n        $SearchJS.when(\"jQuery\", \"popover\").run(function($) {\n            $.fn.amznFlyoutIntent = function(arg) {\n                var defaults = {\n                    getTarget: function(el) {\n                        return $(this).children(\"*[position=\\\"absolute\\\"]\").eq(0);\n                    },\n                    triggerAxis: \"y\",\n                    majorDelay: 300,\n                    minorDelay: 100,\n                    targetSlopY: 50,\n                    targetSlopX: 50,\n                    cursorSlopBase: 25,\n                    cursorSlopHeight: 50,\n                    mtRegions: []\n                }, nameSp = \"amznFlyoutIntent\", mt = $.AmazonPopover.mouseTracker, getRect = function(el, slopX, slopY) {\n                    var off = el.offset(), tl = {\n                        x: ((off.left - ((slopX || 0)))),\n                        y: ((off.JSBNG__top - ((slopY || 0))))\n                    }, br = {\n                        x: ((((tl.x + el.JSBNG__outerWidth())) + ((((slopX || 0)) * 2)))),\n                        y: ((((tl.y + el.JSBNG__outerHeight())) + ((((slopY || 0)) * 2))))\n                    };\n                    return [tl,br,];\n                }, triBC = function(tri) {\n                    var t0 = tri[0], t1 = tri[1], t2 = tri[2];\n                    return ((((((t1.x - t0.x)) * ((t2.y - t0.y)))) - ((((t2.x - t0.x)) * ((t1.y - t0.y))))));\n                }, isInTri = function(p, tri) {\n                    var b0 = ((1 / triBC(tri))), t0 = tri[0], t1 = tri[1], t2 = tri[2];\n                    return ((((((((triBC([t1,t2,p,]) * b0)) > 0)) && ((((triBC([t2,t0,p,]) * b0)) > 0)))) && ((((triBC([t0,t1,p,]) * b0)) > 0))));\n                }, clamp = function(p, r) {\n                    var r0 = r[0], r1 = r[1];\n                    return {\n                        x: ((((p.x < r0.x)) ? -1 : ((((p.x > r1.x)) ? 1 : 0)))),\n                        y: ((((p.y < r0.y)) ? -1 : ((((p.y > r1.y)) ? 1 : 0))))\n                    };\n                }, isInRect = function(p, rect) {\n                    var c = clamp(p, rect);\n                    return ((((c.x == 0)) && ((c.y == 0))));\n                }, sel = function(a, b, a0, a1, b0, b1, d) {\n                    return ((((a < 0)) ? a0 : ((((a > 0)) ? a1 : ((((b < 0)) ? b0 : ((((b > 0)) ? b1 : d))))))));\n                }, getExtremePoints = function(p, rect) {\n                    var c = clamp(p, rect), cx = c.x, cy = c.y, r0 = rect[0], r1 = rect[1], r0x = r0.x, r0y = r0.y, r1x = r1.x, r1y = r1.y;\n                    return [{\n                        x: sel(cy, cx, r0x, r1x, r0x, r1x, 0),\n                        y: sel(cx, cy, r1y, r0y, r0y, r1y, 0)\n                    },{\n                        x: sel(cy, cx, r1x, r0x, r0x, r1x, 0),\n                        y: sel(cx, cy, r0y, r1y, r0y, r1y, 0)\n                    },];\n                }, isInCone = function(cursor, p1, cfg) {\n                    var slopRect = $.extend(true, [], cfg.slopRect), sy = cfg.targetSlopY, sx = cfg.targetSlopX, c = clamp(p1, cfg.targetRect), cx = c.x, cy = c.y, sh = cfg.cursorSlopHeight, sb = cfg.cursorSlopBase, p = $.extend({\n                    }, p1), q = $.extend({\n                    }, p1), exP;\n                    if (((cy == 0))) {\n                        slopRect[((((cx < 0)) ? 0 : 1))].x -= ((sy * cx));\n                    }\n                     else {\n                        if (((cx == 0))) {\n                            slopRect[((((cy < 0)) ? 0 : 1))].y -= ((sb * cy));\n                        }\n                    ;\n                    ;\n                    }\n                ;\n                ;\n                    if (((cfg.triggerAxis === \"x\"))) {\n                        p.y = q.y -= ((sb * cy));\n                        p.x -= sh;\n                        q.x += sh;\n                    }\n                     else {\n                        q.x = p.x -= ((sb * cx));\n                        p.y -= ((sh * cx));\n                        q.y += ((sh * cx));\n                    }\n                ;\n                ;\n                    exP = getExtremePoints(p1, slopRect);\n                    return ((((isInTri(cursor, [p1,exP[0],exP[1],]) || isInTri(cursor, [p1,exP[0],p,]))) || isInTri(cursor, [p1,exP[1],q,])));\n                }, calcChangeDelay = function(c, rect, p1, p2, cfg) {\n                    var delay = 0;\n                    p1 = ((p1 || {\n                    }));\n                    p2 = ((p2 || {\n                    }));\n                    if (isInRect(c, rect)) {\n                        delay = -1;\n                    }\n                     else {\n                        if (isInCone(c, p1, cfg)) {\n                            delay = cfg.majorDelay;\n                        }\n                         else {\n                            if (((((((Math.abs(((c.x - p1.x))) < 10)) && ((Math.abs(((c.y - p1.y))) < 10)))) && isInCone(c, p2, cfg)))) {\n                                delay = cfg.minorDelay;\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                    }\n                ;\n                ;\n                    return delay;\n                }, changeTrigger = function(el, cfg) {\n                    ((((cfg.triggerEl && cfg.onMouseOut)) && cfg.onMouseOut.call(cfg.triggerEl.get(0))));\n                    cfg.onMouseOver.call(el.get(0));\n                    if (!cfg.targets) {\n                        cfg.targets = {\n                        };\n                    }\n                ;\n                ;\n                    var tgt = cfg.targets[el];\n                    if (!tgt) {\n                        cfg.targets[el] = tgt = {\n                            triggerEl: $(el)\n                        };\n                        tgt.targetEl = cfg.getTarget.call(el.get(0));\n                        tgt.targetRect = getRect(tgt.targetEl);\n                        tgt.slopRect = getRect(tgt.targetEl, cfg.targetSlopY, cfg.targetSlopX);\n                    }\n                ;\n                ;\n                    cfg.triggerEl = tgt.triggerEl;\n                    cfg.targetEl = tgt.targetEl;\n                    cfg.targetRect = tgt.targetRect;\n                    cfg.slopRect = tgt.slopRect;\n                }, m = {\n                    destroy: function() {\n                        var cfg = this.data(nameSp), i;\n                        if (cfg) {\n                            JSBNG__clearTimeout(cfg.timeoutId);\n                            for (i = 0; ((i < cfg.mtRegions.length)); i++) {\n                                mt.remove(cfg.mtRegions[i]);\n                            };\n                        ;\n                            this.removeData(nameSp);\n                        }\n                    ;\n                    ;\n                    },\n                    init: function(opts) {\n                        var cfg = this.data(nameSp);\n                        if (!cfg) {\n                            cfg = $.extend(defaults, opts);\n                            this.data(nameSp, cfg);\n                        }\n                    ;\n                    ;\n                        return this.each(function() {\n                            var $this = $(this), off = $this.offset(), mouseLeave = function(immediately, args) {\n                                ((((cfg.onMouseLeave && this.el)) && cfg.onMouseLeave.call(this.el.get(0))));\n                                return true;\n                            }, mouseEnter = function(args) {\n                                JSBNG__clearTimeout(cfg.timeoutId);\n                                var trigger, changeDelay, doDelayedChange;\n                                ((((cfg.onMouseEnter && this.el)) && cfg.onMouseEnter.call(this.el.get(0))));\n                                if (((((cfg.triggerEl && this.el)) && ((cfg.triggerEl !== this.el))))) {\n                                    trigger = this.el;\n                                    changeDelay = ((cfg.targetRect ? calcChangeDelay(args.cursor, cfg.targetRect, args.priorCursors[0], args.priorCursors[1], cfg) : -1));\n                                    if (((cfg.triggerEl && ((changeDelay > 0))))) {\n                                        doDelayedChange = function() {\n                                            var delayedArgs = mt.getCallbackArgs(), nextDelay = 0;\n                                            JSBNG__clearTimeout(cfg.timeoutId);\n                                            if (((((cfg.priorCursor && ((cfg.priorCursor.x === delayedArgs.cursor.x)))) && ((cfg.priorCursor.y === delayedArgs.cursor.y))))) {\n                                                nextDelay = ((isInRect(delayedArgs.cursor, cfg.targetRect) ? -1 : 0));\n                                            }\n                                             else {\n                                                nextDelay = calcChangeDelay(delayedArgs.cursor, cfg.targetRect, delayedArgs.priorCursors[0], delayedArgs.priorCursors[1], cfg);\n                                            }\n                                        ;\n                                        ;\n                                            cfg.priorCursor = {\n                                                x: delayedArgs.cursor.x,\n                                                y: delayedArgs.cursor.y\n                                            };\n                                            if (((((nextDelay > 0)) && ((cfg.triggerEl.get(0) !== trigger.get(0)))))) {\n                                                cfg.timeoutId = JSBNG__setTimeout(function() {\n                                                    doDelayedChange.call(trigger);\n                                                }, nextDelay);\n                                            }\n                                             else {\n                                                if (((nextDelay > -1))) {\n                                                    if (isInRect(delayedArgs.cursor, getRect(trigger))) {\n                                                        changeTrigger(trigger, cfg);\n                                                    }\n                                                     else {\n                                                        ((cfg.onMouseOut && cfg.onMouseOut.call(trigger.get(0))));\n                                                    }\n                                                ;\n                                                ;\n                                                }\n                                            ;\n                                            ;\n                                            }\n                                        ;\n                                        ;\n                                        };\n                                        cfg.timeoutId = JSBNG__setTimeout(doDelayedChange, changeDelay);\n                                    }\n                                     else {\n                                        changeTrigger(this.el, cfg);\n                                    }\n                                ;\n                                ;\n                                }\n                                 else {\n                                    changeTrigger(this.el, cfg);\n                                }\n                            ;\n                            ;\n                                return true;\n                            };\n                            cfg.mtRegions.push(mt.add([[off.left,off.JSBNG__top,$this.JSBNG__outerWidth(),$this.JSBNG__outerHeight(),],], {\n                                inside: false,\n                                mouseEnter: mouseEnter,\n                                mouseLeave: mouseLeave,\n                                el: $this\n                            }));\n                        });\n                    }\n                };\n                if (m[arg]) {\n                    return m[arg].apply(this, Array.prototype.slice.call(arguments, 1));\n                }\n            ;\n            ;\n                if (((((typeof arg === \"object\")) || !arg))) {\n                    return m.init.apply(this, arguments);\n                }\n            ;\n            ;\n                return this;\n            };\n            $SearchJS.publish(\"amznFlyoutIntent\");\n        });\n        $SearchJS.when(\"jQuery\", \"amznFlyoutIntent\").run(function($) {\n            (function(window, undefined) {\n                var merchRE = /^me=/, refre = /(ref=[-\\w]+)/, ltrimre = /^\\s+/, spaceNormRe = /\\s+/g, ddre = /_dd_/, ddaliasre = /(dd_[a-z]{3,4})(_|$)[\\w]*/, deptre = /\\{department\\}/g, slashre = /\\+/g, aliasre = /search-alias\\s*=\\s*([\\w-]+)/, nodere = /node\\s*=\\s*([\\d]+)/, merchantre = /^me=([0-9A-Z]*)/, noissre = /ref=nb_sb_noss/, dcs = \"#ddCrtSel\", sdpc = \"searchDropdown_pop_conn\", tostr = Object.prototype.toString, ddBox, metrics = {\n                    isEnabled: ((((typeof uet == \"function\")) && ((typeof uex == \"function\")))),\n                    init: \"iss-init-pc\",\n                    completionsRequest0: \"iss-c0-pc\",\n                    completionsRequestSample: \"iss-cs-pc\",\n                    sample: 2,\n                    noFocusTag: \"iss-on-time\",\n                    focusTag: \"iss-late\"\n                };\n                $.isArray = (($.isArray || function(o) {\n                    return ((tostr.call(o) === \"[object Array]\"));\n                }));\n                var SS = function(sb, pe, displayHtml, handlers) {\n                    var node, noOp = function() {\n                    \n                    }, defaults = {\n                        afterCreate: noOp,\n                        beforeShow: noOp,\n                        afterShow: noOp,\n                        beforeHide: noOp,\n                        beforeHtmlChange: noOp,\n                        afterHtmlChange: noOp,\n                        onWindowResize: noOp\n                    }, events = $.extend({\n                    }, defaults, handlers);\n                    function create() {\n                        node = $(displayHtml).appendTo(((pe || sb.parent())));\n                        events.afterCreate.call(node);\n                        $(window).resize(function(e) {\n                            events.onWindowResize.call(node, e);\n                        });\n                        return node;\n                    };\n                ;\n                    function get() {\n                        return ((node || create()));\n                    };\n                ;\n                    function setHtml(h) {\n                        events.beforeHtmlChange.call(get(), h);\n                        get().html(h);\n                        events.afterHtmlChange.call(get(), h);\n                        return this;\n                    };\n                ;\n                    this.getNode = get;\n                    this.html = setHtml;\n                    this.visible = function() {\n                        if (node) {\n                            return ((node.css(\"display\") != \"none\"));\n                        }\n                    ;\n                    ;\n                        return false;\n                    };\n                    this.hide = function() {\n                        events.beforeHide.call(get());\n                        get().hide();\n                        setHtml(\"\");\n                        return this;\n                    };\n                    this.show = function() {\n                        events.beforeShow.call(get());\n                        get().show();\n                        events.afterShow.call(get());\n                        return this;\n                    };\n                };\n                var IAC = function(sb, pe, iac, newDesign) {\n                    var sbPlaceHolder, sbPlaceHolderDiv, sbNode, sbDiv, iacNode, iacDiv, widthDiv, canShowIAC = true, iacType = 0;\n                    function get() {\n                        return ((iacNode || create()));\n                    };\n                ;\n                    function create() {\n                        var p = sb.pos(true), d = sb.size(true), sbPlaceHolderCss = {\n                            JSBNG__top: p.JSBNG__top,\n                            left: p.left,\n                            width: \"100%\",\n                            border: \"2px inset\"\n                        }, sbPlaceHolderCssOverride = {\n                            background: \"none repeat scroll 0 0 transparent\",\n                            color: \"black\",\n                            \"font-family\": \"arial,sans-serif\",\n                            \"font-size\": \"12pt\",\n                            height: \"23px\",\n                            margin: \"7px 0 0\",\n                            outline: \"0 none\",\n                            padding: 0,\n                            border: \"0 none\"\n                        }, iacNodeCss = {\n                            left: p.left,\n                            width: d.width,\n                            JSBNG__top: p.JSBNG__top,\n                            \"z-index\": 1,\n                            color: \"#999\",\n                            position: \"absolute\",\n                            \"background-color\": \"#FFF\"\n                        }, iacNodeCssOverride = {\n                            left: ((p.left + 5)),\n                            width: ((d.width - 5)),\n                            border: \"0 none\",\n                            \"font-family\": \"arial,sans-serif\",\n                            \"font-size\": \"12pt\",\n                            height: \"23px\",\n                            margin: \"7px 0 0\",\n                            outline: \"0 none\",\n                            padding: 0\n                        };\n                        sbPlaceHolder = $(\"\\u003Cinput id='sbPlaceHolder' class='searchSelect' readOnly='true'/\\u003E\").css(sbPlaceHolderCss).css(((newDesign ? sbPlaceHolderCssOverride : {\n                        }))).appendTo(((pe || sb.parent())));\n                        sbPlaceHolderDiv = sbPlaceHolder.get(0);\n                        sbNode = $(\"#twotabsearchtextbox\").css({\n                            position: \"absolute\",\n                            background: \"none repeat scroll 0 0 transparent\",\n                            \"z-index\": 5,\n                            width: d.width\n                        });\n                        sbDiv = sbNode.get(0);\n                        iacNode = $(\"\\u003Cinput id='inline_auto_complete' class='searchSelect' readOnly='true'/\\u003E\").css(iacNodeCss).css(((newDesign ? iacNodeCssOverride : {\n                        }))).appendTo(((pe || sb.parent())));\n                        iacDiv = iacNode.get(0);\n                        JSBNG__setInterval(adjust, 200);\n                        sbNode.keydown(keyDown);\n                        if (newDesign) {\n                            widthDiv = sb.parent().parent();\n                        }\n                    ;\n                    ;\n                        return iacNode;\n                    };\n                ;\n                    function adjust() {\n                        var p = sb.pos(), d = sb.size(), adjustment = 0, w = d.width;\n                        if (newDesign) {\n                            adjustment = 5;\n                            w = ((widthDiv.width() - adjustment));\n                        }\n                    ;\n                    ;\n                        sbNode.css({\n                            left: ((p.left + adjustment)),\n                            JSBNG__top: p.JSBNG__top,\n                            width: w\n                        });\n                        iacNode.css({\n                            left: ((p.left + adjustment)),\n                            JSBNG__top: p.JSBNG__top,\n                            width: w\n                        });\n                    };\n                ;\n                    function keyDown(JSBNG__event) {\n                        var value = get().val();\n                        get().val(\"\");\n                        var key = JSBNG__event.keyCode;\n                        switch (key) {\n                          case 8:\n                        \n                          case 37:\n                        \n                          case 46:\n                            if (((value && ((value.length > 0))))) {\n                                JSBNG__event.preventDefault();\n                            }\n                        ;\n                        ;\n                            iacType = 0;\n                            canShowIAC = false;\n                            break;\n                          case 32:\n                            iacType = 0;\n                            canShowIAC = false;\n                            break;\n                          case 13:\n                            if (((iac == 2))) {\n                                break;\n                            }\n                        ;\n                        ;\n                          case 39:\n                            if (((value && ((value.length > 0))))) {\n                                sb.keyword(value);\n                                iacType = ((((key == 13)) ? 1 : 2));\n                            }\n                        ;\n                        ;\n                            canShowIAC = true;\n                            break;\n                          case 16:\n                        \n                          case 17:\n                        \n                          case 18:\n                        \n                          case 20:\n                        \n                          case 229:\n                            get().val(value);\n                          default:\n                            iacType = 0;\n                            canShowIAC = true;\n                            break;\n                        };\n                    ;\n                    };\n                ;\n                    this.val = function(value) {\n                        if (((value !== undefined))) {\n                            get().val(value);\n                        }\n                    ;\n                    ;\n                        return get().val();\n                    };\n                    this.clear = function() {\n                        get().val(\"\");\n                    };\n                    this.type = function() {\n                        return iacType;\n                    };\n                    this.displayable = function(showIAC) {\n                        if (((showIAC !== undefined))) {\n                            canShowIAC = showIAC;\n                        }\n                    ;\n                    ;\n                        return canShowIAC;\n                    };\n                    this.touch = function() {\n                        get();\n                        return true;\n                    };\n                };\n                var IH = function(updateFunc) {\n                    var curIme, ku, kd, validKey, srotationFlag = 0, skeyupFlag = 0, updateKwChange = updateFunc;\n                    function clearCurIme(clearRotationFlag) {\n                        if (((clearRotationFlag && ((srotationFlag == 1))))) {\n                            srotationFlag = 0;\n                        }\n                         else {\n                            kd = ku = undefined, curIme = \"\";\n                        }\n                    ;\n                    ;\n                        if (clearRotationFlag) {\n                            validKey = false;\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    function keydown(keyCode) {\n                        validKey = false;\n                        if (((srotationFlag != skeyupFlag))) {\n                            srotationFlag = skeyupFlag = 0;\n                        }\n                    ;\n                    ;\n                        return ((keyCode ? kd = keyCode : kd));\n                    };\n                ;\n                    function update(sbCurText) {\n                        if (updateKwChange) {\n                            updateKwChange(((((sbCurText && ((sbCurText.length > 0)))) ? ((sbCurText + curIme)) : curIme)));\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    function keyup(keyCode, sbCurText) {\n                        if (((keyCode != undefined))) {\n                            ku = keyCode;\n                            if (((((curIme && ((curIme.length > 0)))) && ((((ku == 8)) || ((ku == 46))))))) {\n                                curIme = curIme.substring(0, ((curIme.length - 1)));\n                                if (((skeyupFlag == 1))) {\n                                    skeyupFlag = 0;\n                                }\n                            ;\n                            ;\n                                validKey = true;\n                                update(sbCurText);\n                            }\n                             else {\n                                if (((((ku >= 65)) && ((ku <= 90))))) {\n                                    var kchar = String.fromCharCode(ku);\n                                    curIme += kchar;\n                                    validKey = true;\n                                    if (((skeyupFlag == 1))) {\n                                        skeyupFlag = 0;\n                                    }\n                                     else {\n                                        update(sbCurText);\n                                    }\n                                ;\n                                ;\n                                }\n                            ;\n                            ;\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                        return ku;\n                    };\n                ;\n                    function shouldHandle() {\n                        return ((((kd == 229)) || ((kd == 197))));\n                    };\n                ;\n                    function isValidKey() {\n                        return validKey;\n                    };\n                ;\n                    function setFlag() {\n                        srotationFlag = 1;\n                        skeyupFlag = 1;\n                    };\n                ;\n                    this.keydown = keydown;\n                    this.keyup = keyup;\n                    this.isImeInput = shouldHandle;\n                    this.reset = clearCurIme;\n                    this.isValidKey = isValidKey;\n                    this.setFlag = setFlag;\n                };\n                var SB = function(sb, h) {\n                    var curText, curSel, latestUserInput, navIssAttach, sbPlaceHolder, imeUsed = false, ih = ((h.opt.imeEnh && new IH(function(val) {\n                        updateKwChange(val);\n                    }))), wAddIMEReftag = false;\n                    init();\n                    function init() {\n                        if (metrics.isEnabled) {\n                            ue.tag(((((sb.get(0) === JSBNG__document.activeElement)) ? metrics.focusTag : metrics.noFocusTag)));\n                        }\n                    ;\n                    ;\n                        sb.keydown(keyDown).keyup(keyUp).keypress(keyPress).select(select).JSBNG__blur(blurHandler).JSBNG__focus(focusHandler).click(clickHandler);\n                        sb.bind(\"compositionstart\", imeCompositionStart).bind(\"compositionend\", imeCompositionEnd);\n                        latestUserInput = curText = kw();\n                        ((h.newDesign && (navIssAttach = $(\"#nav-iss-attach\"))));\n                    };\n                ;\n                    function kw(k) {\n                        if (((k !== undefined))) {\n                            curText = curSel = k;\n                            sb.val(k);\n                        }\n                    ;\n                    ;\n                        return sb.val().replace(ltrimre, \"\").replace(spaceNormRe, \" \");\n                    };\n                ;\n                    function input(k) {\n                        if (((k !== undefined))) {\n                            latestUserInput = k;\n                        }\n                    ;\n                    ;\n                        return latestUserInput;\n                    };\n                ;\n                    function keyDown(e) {\n                        var key = e.keyCode, d = ((((key == 38)) ? -1 : ((((key == 40)) ? 1 : 0))));\n                        if (ih) {\n                            ih.keydown(key);\n                        }\n                    ;\n                    ;\n                        imeUsed = ((((((key == 229)) || ((key == 197)))) ? true : ((((((((key >= 48)) && ((key <= 57)))) || ((((key >= 65)) && ((key <= 90)))))) ? false : imeUsed))));\n                        if (((h.opt.twoPane === 1))) {\n                            return h.twoPaneArrowKeyHandler(e);\n                        }\n                    ;\n                    ;\n                        if (d) {\n                            h.adjust(d);\n                            if (((kw() != \"\"))) {\n                                e.preventDefault();\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                        if (h.opt.doCTW) {\n                            h.opt.doCTW(e);\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    function keyUp(e) {\n                        var key = e.keyCode;\n                        switch (key) {\n                          case 13:\n                            h.hide();\n                            break;\n                          case 27:\n                            return h.dismiss();\n                          case 37:\n                        \n                          case 38:\n                        \n                          case 39:\n                        \n                          case 40:\n                            break;\n                          default:\n                            if (((ih && ih.isImeInput()))) {\n                                ih.keyup(key, curText);\n                            }\n                             else {\n                                update(true);\n                            }\n                        ;\n                        ;\n                            break;\n                        };\n                    ;\n                    };\n                ;\n                    function keyPress(e) {\n                        var key = e.keyCode;\n                        switch (key) {\n                          case 13:\n                            return h.submitEnabled();\n                          default:\n                            h.keyPress();\n                            break;\n                        };\n                    ;\n                    };\n                ;\n                    function select(e) {\n                        if (ih) {\n                            ih.setFlag();\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    function imeCompositionStart(e) {\n                        wAddIMEReftag = true;\n                    };\n                ;\n                    function imeCompositionEnd(e) {\n                        JSBNG__setTimeout(function() {\n                            return (function() {\n                                wAddIMEReftag = false;\n                            });\n                        }(), 200);\n                    };\n                ;\n                    function updateKwChange(val) {\n                        input(val);\n                        h.change(val);\n                    };\n                ;\n                    function update(dontCheckCurSel) {\n                        var val = kw();\n                        if (((((val != curText)) && ((dontCheckCurSel || ((val != curSel))))))) {\n                            curText = val;\n                            if (ih) {\n                                ih.reset(true);\n                            }\n                        ;\n                        ;\n                            updateKwChange(val);\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    function focusHandler(e) {\n                        if (ih) {\n                            ih.reset();\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    function blurHandler(e) {\n                        h.dismiss();\n                        if (ih) {\n                            ih.reset();\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    function clickHandler(e) {\n                        h.click(kw());\n                        if (ih) {\n                            ih.reset();\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    function getSbPlaceHolder() {\n                        if (!sbPlaceHolder) {\n                            sbPlaceHolder = $(\"#sbPlaceHolder\");\n                        }\n                    ;\n                    ;\n                        return sbPlaceHolder;\n                    };\n                ;\n                    function isImeEnhUsed() {\n                        return ((((imeUsed && h.opt.imeEnh)) && ih.isValidKey()));\n                    };\n                ;\n                    this.keyword = function(k) {\n                        return kw(k);\n                    };\n                    this.userInput = function(k) {\n                        return input(k);\n                    };\n                    this.size = function(nonIAC) {\n                        var e = sb;\n                        if (h.newDesign) {\n                            e = navIssAttach;\n                        }\n                         else {\n                            if (((((!nonIAC && h.iac)) && h.checkIAC()))) {\n                                e = getSbPlaceHolder();\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                        return {\n                            width: e.JSBNG__outerWidth(),\n                            height: e.JSBNG__outerHeight()\n                        };\n                    };\n                    this.pos = function(nonIAC) {\n                        var e = sb;\n                        if (h.newDesign) {\n                            e = navIssAttach;\n                        }\n                         else {\n                            if (((((!nonIAC && h.iac)) && h.checkIAC()))) {\n                                e = getSbPlaceHolder();\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                        return e.position();\n                    };\n                    this.offset = function(nonIAC) {\n                        var e = sb;\n                        if (((((!nonIAC && h.iac)) && h.checkIAC()))) {\n                            e = getSbPlaceHolder();\n                        }\n                    ;\n                    ;\n                        return e.offset();\n                    };\n                    this.parent = function() {\n                        return sb.parent();\n                    };\n                    this.hasFocus = function() {\n                        return ((sb.get(0) === JSBNG__document.activeElement));\n                    };\n                    this.cursorPos = function() {\n                        var input = sb.get(0);\n                        if (((\"selectionStart\" in input))) {\n                            return input.selectionStart;\n                        }\n                         else {\n                            if (JSBNG__document.selection) {\n                                input.JSBNG__focus();\n                                var sel = JSBNG__document.selection.createRange();\n                                var selLen = JSBNG__document.selection.createRange().text.length;\n                                sel.moveStart(\"character\", -input.value.length);\n                                return ((sel.text.length - selLen));\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                        return -1;\n                    };\n                    this.update = update;\n                    this.isImeEnhUsed = isImeEnhUsed;\n                    this.JSBNG__blur = function() {\n                        sb.JSBNG__blur();\n                    };\n                    this.JSBNG__focus = function() {\n                        var val = sb.val();\n                        sb.JSBNG__focus().val(\"\").val(val);\n                    };\n                    this.keydown = function(h) {\n                        sb.keydown(h);\n                    };\n                    this.click = function(h) {\n                        sb.click(h);\n                    };\n                    this.onFocus = function(h) {\n                        sb.JSBNG__focus(h);\n                    };\n                    this.onBlur = function(h) {\n                        sb.JSBNG__blur(h);\n                    };\n                    this.isImeUsed = function() {\n                        return imeUsed;\n                    };\n                    this.shouldAddIMEReftag = function() {\n                        return ((((h.opt.ime && wAddIMEReftag)) || isImeEnhUsed()));\n                    };\n                };\n                var AC = function(opts) {\n                    var opt = {\n                    }, names, values, crtSel = -1, redirectFirstSuggestion = false, crtXcatSel = -1, suggestionList = [], twoPaneSuggestionsList = [], curSize = 0, hideDelayTimerId = null, timer = null, maxCategorySuggestions = 4, categorySuggestions = 0, imeSpacing = 0, suggestRequest = null, first = -1, defaultDropDownVal, insertedDropDownVal, delayedDOMUpdate = false, staticContent, searchBox, keystroke, sugHandler, inlineAutoComplete, JSBNG__searchSuggest, activityAllowed = true, promoList = [], suggType = \"sugg\", newDesign = $(\"#navbar\").hasClass(\"nav-beacon\"), defaults = {\n                        sb: \"#twotabsearchtextbox\",\n                        form: \"#navbar form[name='site-search']\",\n                        dd: \"#searchDropdownBox\",\n                        cid: \"amazon-search-ui\",\n                        action: \"\",\n                        sugPrefix: \"issDiv\",\n                        sugText: \"Search suggestions\",\n                        fb: 0,\n                        xcat: 0,\n                        twoPane: 0,\n                        dupElim: 0,\n                        imeSpacing: 0,\n                        maxSuggestions: 10\n                    }, lastKeyPressTime, timeToFirstSuggestion = 0, searchAliasFrom, defaultTimeout = 100, reqCounter = 0, imeEnhUsed = false;\n                    ((opts && init(opts)));\n                    function init(opts) {\n                        $.extend(opt, defaults, opts);\n                        newDesign = ((opt.isNavInline && newDesign));\n                        var src = opt.src, resizeToken = null;\n                        staticContent = $.isArray(src);\n                        lookup(opt, \"sb\");\n                        if (!opt.sb) {\n                            return;\n                        }\n                    ;\n                    ;\n                        searchBox = new SB(opt.sb, {\n                            adjust: move,\n                            twoPaneArrowKeyHandler: twoPaneArrowKeyHandler,\n                            hide: hideSuggestions,\n                            dismiss: dismissSuggestions,\n                            change: ((staticContent ? update : delayUpdate)),\n                            submitEnabled: submitEnabled,\n                            keyPress: keyPress,\n                            click: clickHandler,\n                            newDesign: newDesign,\n                            iac: opt.iac,\n                            checkIAC: checkIAC,\n                            opt: opt\n                        });\n                        lookup(opt, \"pe\");\n                        if (opt.iac) {\n                            inlineAutoComplete = new IAC(searchBox, opt.pe, opt.iac, newDesign);\n                        }\n                    ;\n                    ;\n                        if (((opt.twoPane == false))) {\n                            JSBNG__searchSuggest = new SS(searchBox, opt.pe, \"\\u003Cdiv id=\\\"srch_sggst\\\"/\\u003E\", {\n                                afterCreate: resizeHandler,\n                                onWindowResize: resizeHandler,\n                                beforeShow: resizeHandler\n                            });\n                        }\n                         else {\n                            JSBNG__searchSuggest = new SS(searchBox, opt.pe, \"\\u003Cdiv id=\\\"srch_sggst\\\" class=\\\"two-pane\\\" style=\\\"display:none\\\"/\\u003E\", {\n                                afterCreate: twoPaneSetPosition,\n                                beforeHtmlChange: twoPaneDestroyFlyout,\n                                beforeShow: twoPaneSetPosition,\n                                afterShow: function(h) {\n                                    twoPaneSetPosition.call(this);\n                                    twoPaneSetXcatPosition.call(this);\n                                    twoPaneBindFlyout.call(this);\n                                },\n                                onWindowResize: function() {\n                                    var $this = this, resize = function() {\n                                        twoPaneDestroyFlyout.call($this);\n                                        twoPaneBindFlyout.call($this);\n                                        resizeToken = null;\n                                    };\n                                    window.JSBNG__clearTimeout(resizeToken);\n                                    resizeToken = window.JSBNG__setTimeout(resize, 100);\n                                    twoPaneSetPosition.call($this);\n                                    twoPaneSetXcatPosition.call($this);\n                                }\n                            });\n                        }\n                    ;\n                    ;\n                        lookup(opt, \"form\");\n                        lookup(opt, \"valInput\");\n                        lookup(opt, \"dd\");\n                        lookup(opt, \"submit\");\n                        ddBox = opt.dd;\n                        opt.protocol = ((((opt.protocol || window.JSBNG__document.JSBNG__location.protocol)) || \"http:\"));\n                        if (ddBox) {\n                            defaultDropDownVal = ddBox.val();\n                        }\n                    ;\n                    ;\n                        if (staticContent) {\n                            names = src[0];\n                            values = src[1];\n                            opt.sb.removeAttr(\"style\");\n                        }\n                         else {\n                        \n                        }\n                    ;\n                    ;\n                        if (opt.submit) {\n                            disable(\"disabled\");\n                            opt.submitImgDef = opt.submit.attr(\"src\");\n                            opt.submitToggle = ((opt.submitImgDef && opt.submitImg));\n                        }\n                    ;\n                    ;\n                        if (opt.ime) {\n                            window.JSBNG__setInterval(function() {\n                                searchBox.update();\n                            }, 20);\n                        }\n                    ;\n                    ;\n                        $SearchJS.importEvent(\"navbarPromos\");\n                        $SearchJS.when(\"navbarPromos\").run(function() {\n                            promoList = window.navbar.issPromotions(3);\n                        });\n                    };\n                ;\n                    function initStatic(sb, form, valInput, submit, submitImg, names, values, noMatch, ime, multiword, dummy0) {\n                        init({\n                            form: form,\n                            ime: ime,\n                            multiword: multiword,\n                            noMatch: noMatch,\n                            sb: sb,\n                            src: [names,values,],\n                            submit: submit,\n                            submitImg: submitImg,\n                            valInput: valInput\n                        });\n                    };\n                ;\n                    function initDynamic(sb, form, dd, service, mkt, aliases, handler, deptText, sugText, sc, dummy0) {\n                        init({\n                            aliases: aliases,\n                            dd: dd,\n                            deptText: deptText,\n                            form: form,\n                            handler: handler,\n                            ime: ((((mkt == 6)) || ((mkt == 3240)))),\n                            mkt: mkt,\n                            sb: sb,\n                            sc: sc,\n                            src: service,\n                            sugText: sugText\n                        });\n                    };\n                ;\n                    function lookup(h, k, n) {\n                        if (n = h[k]) {\n                            n = $(n);\n                            if (((n && n.length))) {\n                                h[k] = n;\n                                return n;\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                        delete h[k];\n                    };\n                ;\n                    function disable(d) {\n                        if (opt.submit.prop) {\n                            opt.submit.prop(\"disabled\", d);\n                        }\n                         else {\n                            opt.submit.attr(\"disabled\", d);\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    function move(n) {\n                        if (((curSize <= 0))) {\n                            return;\n                        }\n                    ;\n                    ;\n                        try {\n                            unhighlightCurrentSuggestion();\n                            if (((((n > 0)) && ((crtSel >= ((curSize - 1))))))) {\n                                crtSel = -1;\n                            }\n                             else {\n                                if (((((n < 0)) && ((crtSel < 0))))) {\n                                    crtSel = ((curSize - 1));\n                                }\n                                 else {\n                                    crtSel += n;\n                                }\n                            ;\n                            ;\n                            }\n                        ;\n                        ;\n                            highlightCurrentSuggestion(true);\n                        } catch (e) {\n                        \n                        };\n                    ;\n                    };\n                ;\n                    function wrap(x, min, max) {\n                        return ((((x > max)) ? min : ((((x < min)) ? max : x))));\n                    };\n                ;\n                    function twoPaneArrowKeyHandler(e) {\n                        var key = e.keyCode, list = twoPaneSuggestionsList, mainLength = list.length, xcatLength = ((((list[crtSel] && list[crtSel].xcat)) ? list[crtSel].xcat.length : 0)), ssNode = JSBNG__searchSuggest.getNode(), n, crtSelId, xcatSelId, firstId = ((opt.sugPrefix + 0));\n                        if (((((e.ctrlKey || e.altKey)) || e.shiftKey))) {\n                            return;\n                        }\n                    ;\n                    ;\n                        switch (key) {\n                          case 38:\n                        \n                          case 40:\n                            n = ((((key === 38)) ? -1 : 1));\n                            if (((((crtSel > -1)) && ((crtXcatSel >= 0))))) {\n                                crtXcatSel = wrap(((crtXcatSel + n)), 0, ((xcatLength - 1)));\n                            }\n                             else {\n                                crtSel = wrap(((crtSel + n)), -1, ((mainLength - 1)));\n                            }\n                        ;\n                        ;\n                            break;\n                          case 37:\n                        \n                          case 39:\n                            if (((crtSel <= -1))) {\n                                return;\n                            }\n                        ;\n                        ;\n                            if (((((((key === 39)) && ((crtXcatSel <= -1)))) && ((xcatLength > 0))))) {\n                                crtXcatSel = 0;\n                            }\n                             else {\n                                if (((key === 37))) {\n                                    crtXcatSel = -1;\n                                }\n                            ;\n                            ;\n                            }\n                        ;\n                        ;\n                            break;\n                          default:\n                            return;\n                        };\n                    ;\n                        crtSelId = ((opt.sugPrefix + crtSel));\n                        xcatSelId = ((((((opt.sugPrefix + crtSel)) + \"-\")) + crtXcatSel));\n                        ssNode.JSBNG__find(((((\"#\" + opt.sugPrefix)) + \"0\"))).removeClass(\"xcat-arrow-hint\");\n                        ssNode.JSBNG__find(\".main-suggestion\").each(function(i, el) {\n                            var e = $(el);\n                            if (((el.id === crtSelId))) {\n                                e.addClass(\"suggest_link_over\");\n                                ssNode.JSBNG__find(((\"#xcatPanel-\" + i))).show().JSBNG__find(\".xcat-suggestion\").each(function(i, el) {\n                                    var e = $(el);\n                                    if (((el.id !== xcatSelId))) {\n                                        e.removeClass(\"suggest_link_over\");\n                                    }\n                                     else {\n                                        e.addClass(\"suggest_link_over\");\n                                    }\n                                ;\n                                ;\n                                });\n                            }\n                             else {\n                                if (((((crtSel <= -1)) && ((el.id === firstId))))) {\n                                    e.removeClass(\"suggest_link_over\");\n                                    ssNode.JSBNG__find(((((\"#\" + opt.sugPrefix)) + \"0\"))).addClass(\"xcat-arrow-hint\");\n                                    ssNode.JSBNG__find(\"#xcatPanel-0\").show().JSBNG__find(\".xcat-suggestion\").removeClass(\"suggest_link_over\");\n                                }\n                                 else {\n                                    e.removeClass(\"suggest_link_over\");\n                                    ssNode.JSBNG__find(((\"#xcatPanel-\" + i))).hide();\n                                }\n                            ;\n                            ;\n                            }\n                        ;\n                        ;\n                        });\n                        updateCrtSuggestion();\n                        e.preventDefault();\n                        return false;\n                    };\n                ;\n                    function clickHandler(kw) {\n                        if (!kw.length) {\n                            displayPromotions();\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    function hideSuggestions() {\n                        ((!opt.ime && hideSuggestionsDiv()));\n                    };\n                ;\n                    function dismissSuggestions() {\n                        if (JSBNG__searchSuggest.visible()) {\n                            hideDelayTimerId = JSBNG__setTimeout(function() {\n                                return (function() {\n                                    hideDelayTimerId = null;\n                                    hideSuggestionsDiv();\n                                });\n                            }(), 300);\n                            crtSel = -1;\n                            if (((suggType == \"sugg\"))) {\n                                updateCrtSuggestion();\n                            }\n                        ;\n                        ;\n                            return false;\n                        }\n                    ;\n                    ;\n                        return true;\n                    };\n                ;\n                    function update(kw) {\n                        suggestionList = [];\n                        twoPaneSuggestionsList = [];\n                        if (!kw.length) {\n                            displayPromotions();\n                            if (inlineAutoComplete) {\n                                inlineAutoComplete.clear();\n                            }\n                        ;\n                        ;\n                        }\n                         else {\n                            first = -1;\n                            if (opt.multiword) {\n                                findSeq();\n                            }\n                             else {\n                                findBin();\n                            }\n                        ;\n                        ;\n                            curSize = suggestionList.length;\n                            displaySuggestions(kw);\n                            checkForExactMatch();\n                            checkForManualOverride();\n                        }\n                    ;\n                    ;\n                        timer = null;\n                        crtSel = -1;\n                        crtXcatSel = -1;\n                    };\n                ;\n                    function delayUpdate(kw) {\n                        var then = now(), newImeEnhUsed = searchBox.isImeEnhUsed();\n                        if (timer) {\n                            JSBNG__clearTimeout(timer);\n                            timer = null;\n                        }\n                    ;\n                    ;\n                        var timeout = defaultTimeout, noneKeyword = ((!kw || !kw.length));\n                        if (((noneKeyword && searchBox.isImeUsed()))) {\n                            timeout = 200;\n                        }\n                    ;\n                    ;\n                        timer = JSBNG__setTimeout(function() {\n                            if (inlineAutoComplete) {\n                                inlineAutoComplete.clear();\n                            }\n                        ;\n                        ;\n                            return (function() {\n                                if (noneKeyword) {\n                                    displayPromotions();\n                                }\n                                 else {\n                                    ((opt.imeEnh ? searchJSONSuggest(kw, newImeEnhUsed) : searchJSONSuggest()));\n                                }\n                            ;\n                            ;\n                                timer = null;\n                                crtSel = -1;\n                                crtXcatSel = -1;\n                            });\n                        }(), timeout);\n                    };\n                ;\n                    function submitEnabled() {\n                        if (((((suggType == \"promo\")) && ((crtSel > -1))))) {\n                            JSBNG__document.JSBNG__location.href = promoList[crtSel].href;\n                            return false;\n                        }\n                    ;\n                    ;\n                        var s = opt.submit;\n                        if (s) {\n                            return ((s.prop ? !s.prop(\"disabled\") : !s.attr(\"disabled\")));\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    function keyPress(key) {\n                        ((keystroke && keystroke(key)));\n                    };\n                ;\n                    function bindSubmit(handler) {\n                        opt.form.submit(handler);\n                    };\n                ;\n                    function bindKeypress(handler) {\n                        keystroke = handler;\n                    };\n                ;\n                    function bindSuggest(handler) {\n                        sugHandler = handler;\n                    };\n                ;\n                    function normalize(s) {\n                        if (opt.normalize) {\n                            return opt.normalize(s);\n                        }\n                         else {\n                            return s.toLowerCase();\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    function findBin() {\n                        var low = 0, high = ((names.length - 1)), mid = -1, dataPrefix = \"\", crtPrefix = normalize(keyword()), len = crtPrefix.length;\n                        while (((low <= high))) {\n                            mid = Math.floor(((((low + high)) / 2)));\n                            dataPrefix = normalize(names[mid]).substr(0, len);\n                            if (((dataPrefix < crtPrefix))) {\n                                low = ((mid + 1));\n                            }\n                             else {\n                                high = ((mid - 1));\n                                if (((dataPrefix == crtPrefix))) {\n                                    first = mid;\n                                }\n                            ;\n                            ;\n                            }\n                        ;\n                        ;\n                        };\n                    ;\n                        if (((first != -1))) {\n                            var i = first, n;\n                            do {\n                                suggestionList.push({\n                                    keyword: names[i],\n                                    i: i\n                                });\n                                ++i;\n                            } while (((((((suggestionList.length < opt.maxSuggestions)) && (n = names[i]))) && !normalize(n).indexOf(crtPrefix))));\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    function findSeq() {\n                        var crtPrefix = normalize(keyword()), rexp = new RegExp(((\"(^|(?:\\\\s))\" + crtPrefix)), \"i\"), i = 0, len = names.length, n;\n                        for (; ((((i < len)) && ((suggestionList.length < opt.maxSuggestions)))); i++) {\n                            n = names[i];\n                            if (normalize(n).match(rexp)) {\n                                suggestionList.push({\n                                    keyword: n,\n                                    i: i\n                                });\n                                if (((first == -1))) {\n                                    first = i;\n                                }\n                            ;\n                            ;\n                            }\n                        ;\n                        ;\n                        };\n                    ;\n                    };\n                ;\n                    function checkForExactMatch() {\n                        var state = \"disabled\";\n                        if (curSize) {\n                            var sg = normalize(suggestionList[0].keyword), kw = normalize(keyword());\n                            if (((((sg.length == kw.length)) && !getPrefixPos(sg, kw)))) {\n                                updateForm(first);\n                                state = \"\";\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                        disable(state);\n                    };\n                ;\n                    function checkForManualOverride() {\n                        if (((opt.manualOverride && !curSize))) {\n                            var kw = keyword();\n                            var url = opt.manualOverride(kw);\n                            if (((url && url.length))) {\n                                updateWholeForm(url);\n                                disable(\"\");\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    function displayPromotions() {\n                        if (((((!newDesign || !promoList)) || ((promoList.length == 0))))) {\n                            hideSuggestionsDiv();\n                            hideNoMatches();\n                            return;\n                        }\n                    ;\n                    ;\n                        curSize = promoList.length;\n                        suggType = \"promo\";\n                        JSBNG__searchSuggest.html(\"\");\n                        hideNoMatches();\n                        JSBNG__searchSuggest.show();\n                        h = \"\\u003Cul class=\\\"promo_list\\\"\\u003E\";\n                        for (i = 0; ((i < curSize)); i++) {\n                            p = promoList[i];\n                            h += ((((((((((\"\\u003Cli id=\\\"\" + opt.sugPrefix)) + i)) + \"\\\" onclick=\\\"document.JSBNG__location.href='\")) + p.href)) + \"'\\\"\\u003E\"));\n                            h += ((((\"\\u003Cdiv class=\\\"promo_image\\\" style=\\\"background-image: url('\" + p.image)) + \"');\\\"\\u003E\\u003C/div\\u003E\"));\n                            h += ((((\"\\u003Cdiv class=\\\"promo_cat\\\"\\u003E\" + p.category)) + \"\\u003C/div\\u003E\"));\n                            h += ((((\"\\u003Cdiv class=\\\"promo_title\\\"\\u003E\" + p.title)) + \"\\u003C/div\\u003E\"));\n                            h += \"\\u003C/li\\u003E\";\n                        };\n                    ;\n                        h += \"\\u003C/ul\\u003E\";\n                        JSBNG__searchSuggest.html(h);\n                        window.navbar.logImpression(\"iss\");\n                        for (i = 0; ((i < curSize)); ++i) {\n                            $(((((\"#\" + opt.sugPrefix)) + i))).mouseover(suggestOver).mouseout(suggestOut);\n                        };\n                    ;\n                    };\n                ;\n                    function displaySuggestions(crtPrefix) {\n                        var sugDivId, lineText, line, sPrefix = opt.sugPrefix, prefix = ((\"#\" + sPrefix)), h = \"\", imeSpacing = ((opt.imeSpacing && searchBox.isImeUsed())), currAlias = ((searchAlias() || ((opt.deepNodeISS && opt.deepNodeISS.searchAliasAccessor())))), suggType = \"sugg\", i;\n                        JSBNG__searchSuggest.html(\"\");\n                        if (((curSize > 0))) {\n                            hideNoMatches();\n                            JSBNG__searchSuggest.show();\n                            if (((!staticContent && !newDesign))) {\n                                h += ((((\"\\u003Cdiv id=\\\"sugdivhdr\\\" align=\\\"right\\\"\\u003E \" + opt.sugText)) + \"\\u003C/div\\u003E\"));\n                            }\n                        ;\n                        ;\n                            if (((opt.iac && inlineAutoComplete.displayable()))) {\n                                var sg = normalize(suggestionList[0].keyword), originalKw = opt.sb.val(), normalizedKw = normalize(keyword());\n                                if (((((((normalizedKw.length > 0)) && ((sg != normalizedKw)))) && ((sg.indexOf(normalizedKw) == 0))))) {\n                                    inlineAutoComplete.val(((originalKw + sg.substring(normalizedKw.length))));\n                                }\n                            ;\n                            ;\n                            }\n                        ;\n                        ;\n                        }\n                         else {\n                            showNoMatches();\n                        }\n                    ;\n                    ;\n                        for (i = 0; ((i < curSize)); i++) {\n                            line = suggestionList[i];\n                            sugDivId = ((sPrefix + i));\n                            if (((((((line.alias && ((line.alias == currAlias)))) && opt.deepNodeISS)) && opt.deepNodeISS.showDeepNodeCorr))) {\n                                lineText = getFormattedCategoryLine(line, crtPrefix);\n                            }\n                             else {\n                                if (((line.alias && ((line.alias != currAlias))))) {\n                                    lineText = getFormattedCategoryLine(line, crtPrefix);\n                                }\n                                 else {\n                                    lineText = getFormattedSuggestionLine(line, crtPrefix);\n                                }\n                            ;\n                            ;\n                            }\n                        ;\n                        ;\n                            var className = \"suggest_link\";\n                            if (((((i == 0)) && imeSpacing))) {\n                                className += \" imeSpacing\";\n                            }\n                        ;\n                        ;\n                            h += ((((((((((((\"\\u003Cdiv id=\\\"\" + sugDivId)) + \"\\\" class=\\\"\")) + className)) + \"\\\"\\u003E\")) + lineText)) + \"\\u003C/div\\u003E\"));\n                            if (((((enableSeparateCategorySuggestion() && ((i == categorySuggestions)))) && ((i < ((curSize - 1))))))) {\n                                h += \"\\u003Cdiv class=\\\"sx_line_holder\\\" /\\u003E\";\n                            }\n                        ;\n                        ;\n                        };\n                    ;\n                        if (((((curSize > 0)) && !newDesign))) {\n                            h += \"\\u003Cdiv id=\\\"sugdivhdr2\\\" align=\\\"right\\\"\\u003E&nbsp;\\u003C/div\\u003E\";\n                        }\n                    ;\n                    ;\n                        ((h && JSBNG__searchSuggest.html(h)));\n                        if (((((timeToFirstSuggestion == 0)) && ((suggestionList.length > 0))))) {\n                            recordTimeToFirstSuggestion();\n                        }\n                    ;\n                    ;\n                        if (ddBox) {\n                            defaultDropDownVal = ddBox.val();\n                        }\n                    ;\n                    ;\n                        searchAliasFrom = extractSearchAlias(defaultDropDownVal);\n                        for (i = 0; ((i < curSize)); ++i) {\n                            $(((prefix + i))).mouseover(suggestOver).mouseout(suggestOut).click(setSearchByIndex);\n                        };\n                    ;\n                    };\n                ;\n                    function displayTwoPaneSuggestions(crtPrefix) {\n                        var len = crtPrefix.length, i, j, k, sg, isIe6 = (($.browser.msie && (($.browser.version == \"6.0\")))), targetOffset, sb = [], a = function() {\n                            $.each(arguments, function(i, t) {\n                                sb.push(t);\n                            });\n                        }, sgLen = twoPaneSuggestionsList.length, xcatLen, maxXcatLen = 0, imeSpacing = ((opt.imeSpacing && searchBox.isImeUsed())), ssNode;\n                        $($.JSBNG__find(\".main-suggestion:first\")).amznFlyoutIntent(\"destroy\");\n                        if (((curSize > 0))) {\n                            hideNoMatches();\n                            if (((opt.iac && inlineAutoComplete.displayable()))) {\n                                var sg = normalize(twoPaneSuggestionsList[0].keyword), originalKw = opt.sb.val(), normalizedKw = normalize(keyword());\n                                if (((((((normalizedKw.length > 0)) && ((sg != normalizedKw)))) && ((sg.indexOf(normalizedKw) == 0))))) {\n                                    inlineAutoComplete.val(((originalKw + sg.substring(normalizedKw.length))));\n                                }\n                            ;\n                            ;\n                            }\n                        ;\n                        ;\n                            a(\"\\u003Ctable id=\\\"two-pane-table\\\" class=\\\"\", ((isIe6 ? \"nav_ie6\" : \"nav_exposed_skin\")), \"\\\" cellpadding=\\\"0\\\" cellspacing=\\\"0\\\"\\u003E\", \"\\u003Ctr\\u003E\", \"\\u003Ctd class=\\\"iss_pop_tl nav_pop_h\\\"\\u003E\\u003Cdiv class=\\\"nav_pop_lr_min\\\"\\u003E\\u003C/div\\u003E\\u003C/td\\u003E\", \"\\u003Ctd style=\\\"background-color: #fff;\\\" colspan=\\\"2\\\"\\u003E\\u003C/td\\u003E\", \"\\u003Ctd class=\\\"iss_pop_tr nav_pop_h\\\"\\u003E\\u003C/td\\u003E\", \"\\u003C/tr\\u003E\", \"\\u003Ctr\\u003E\", \"\\u003Ctd class=\\\"nav_pop_cl nav_pop_v\\\"\\u003E\\u003Cdiv class=\\\"nav_pop_lr_min\\\"\\u003E\\u003C/div\\u003E\\u003C/td\\u003E\");\n                            var className = \"main-suggestions\";\n                            if (imeSpacing) {\n                                className += \" imePadding\";\n                            }\n                        ;\n                        ;\n                            a(((((\"\\u003Ctd class=\\\"\" + className)) + \"\\\" \\u003E\")));\n                            for (i = 0; ((i < sgLen)); i++) {\n                                a(\"\\u003Cdiv id=\\\"\", opt.sugPrefix, i, \"\\\" class=\\\"suggest_link main-suggestion\");\n                                if (((i === 0))) {\n                                    a(\" xcat-arrow-hint\");\n                                }\n                            ;\n                            ;\n                                a(\"\\\"\\u003E\\u003Cspan\\u003E\");\n                                sg = twoPaneSuggestionsList[i];\n                                xcatLen = sg.xcat.length;\n                                if (xcatLen) {\n                                    a(\"\\u003Cspan class=\\\"nav-sprite nav-cat-indicator xcat-arrow\\\"\\u003E\\u003C/span\\u003E\");\n                                    if (((maxXcatLen < xcatLen))) {\n                                        maxXcatLen = xcatLen;\n                                    }\n                                ;\n                                ;\n                                }\n                            ;\n                            ;\n                                a(getFormattedSuggestionLine(sg, crtPrefix), \"\\u003C/span\\u003E\\u003C/div\\u003E\");\n                            };\n                        ;\n                            for (i = 0; ((i < ((maxXcatLen - sgLen)))); i++) {\n                                a(\"\\u003Cdiv class=\\\"iss-spacer-row\\\"\\u003E&nbsp;\\u003C/div\\u003E\");\n                            };\n                        ;\n                            var className = \"xcat-suggestions\";\n                            if (imeSpacing) {\n                                className += \" imePadding\";\n                            }\n                        ;\n                        ;\n                            a(((((\"\\u003C/td\\u003E\\u003Ctd class=\\\"\" + className)) + \"\\\"\\u003E\")));\n                            for (i = 0; ((i < sgLen)); i++) {\n                                sg = twoPaneSuggestionsList[i];\n                                a(\"\\u003Cdiv id=\\\"xcatPanel-\", i, \"\\\" class=\\\"xcat-panel\\\"\");\n                                if (((i > 0))) {\n                                    a(\" style=\\\"display:none\\\"\");\n                                }\n                            ;\n                            ;\n                                a(\"\\u003E\");\n                                for (j = 0; ((j < sg.xcat.length)); j++) {\n                                    a(\"\\u003Cdiv id=\\\"\", opt.sugPrefix, i, \"-\", j, \"\\\" class=\\\"suggest_link xcat-suggestion\", ((((j === 0)) ? \" xcat-suggestion-hint\" : \"\")), \"\\\"\\u003E\", sg.xcat[j].categoryName, \"\\u003C/div\\u003E\");\n                                };\n                            ;\n                                a(\"\\u003C/div\\u003E\");\n                            };\n                        ;\n                            a(\"\\u003C/td\\u003E\", \"\\u003Ctd class=\\\"nav_pop_cr nav_pop_v\\\"\\u003E\\u003C/td\\u003E\", \"\\u003C/tr\\u003E\", \"\\u003Ctr\\u003E\", \"\\u003Ctd class=\\\"nav_pop_bl nav_pop_v\\\"\\u003E\\u003C/td\\u003E\", \"\\u003Ctd colspan=\\\"2\\\" class=\\\"nav_pop_bc nav_pop_h\\\"\\u003E\\u003C/td\\u003E\", \"\\u003Ctd class=\\\"nav_pop_br nav_pop_v\\\"\\u003E\\u003C/td\\u003E\", \"\\u003C/tr\\u003E\", \"\\u003C/table\\u003E\");\n                        }\n                         else {\n                            showNoMatches();\n                        }\n                    ;\n                    ;\n                        JSBNG__searchSuggest.html(sb.join(\"\"));\n                        JSBNG__searchSuggest.show();\n                        if (((((timeToFirstSuggestion == 0)) && ((suggestionList.length > 0))))) {\n                            recordTimeToFirstSuggestion();\n                        }\n                    ;\n                    ;\n                        if (ddBox) {\n                            defaultDropDownVal = ddBox.val();\n                        }\n                    ;\n                    ;\n                        searchAliasFrom = extractSearchAlias(defaultDropDownVal);\n                        ssNode = JSBNG__searchSuggest.getNode();\n                        ssNode.JSBNG__find(\".main-suggestion\").bind(\"click\", twoPaneSearchByIndex);\n                        ssNode.JSBNG__find(\".xcat-suggestion\").bind(\"click\", twoPaneSearchByIndex).bind(\"mouseover\", twoPaneSuggestOver).bind(\"mouseout\", twoPaneXcatSuggestOut);\n                    };\n                ;\n                    function recordTimeToFirstSuggestion() {\n                        var timeNow = now();\n                        timeToFirstSuggestion = ((((timeNow - lastKeyPressTime)) + defaultTimeout));\n                    };\n                ;\n                    function showNoMatches() {\n                        if (opt.noMatch) {\n                            var nmDiv = $(((\"#\" + opt.noMatch)));\n                            JSBNG__searchSuggest.html(\"\");\n                            JSBNG__searchSuggest.getNode().append(nmDiv.clone().attr(\"class\", \"suggest_link suggest_nm\").css({\n                                display: \"block\"\n                            }));\n                            JSBNG__searchSuggest.show();\n                            ((opt.submitToggle && opt.submit.attr(\"src\", opt.submitImg)));\n                        }\n                         else {\n                            hideSuggestionsDiv();\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    function hideNoMatches() {\n                        if (opt.noMatch) {\n                            $(((\"#\" + opt.noMatch))).hide();\n                            ((opt.submitToggle && opt.submit.attr(\"src\", opt.submitImgDef)));\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    function setSearchByIndex() {\n                        var divId = this.id;\n                        crtSel = parseInt(divId.substr(6), 10);\n                        var imeReftagPrefix = ((searchBox.shouldAddIMEReftag() ? \"ime_\" : undefined));\n                        updateCrtSuggestion(imeReftagPrefix);\n                        JSBNG__searchSuggest.hide();\n                        if (opt.iac) {\n                            inlineAutoComplete.clear();\n                        }\n                    ;\n                    ;\n                        if (!delayedDOMUpdate) {\n                            opt.form.submit();\n                        }\n                         else {\n                            window.JSBNG__setTimeout(function() {\n                                opt.form.submit();\n                            }, 10);\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    function twoPaneSearchByIndex(JSBNG__event) {\n                        var divId = this.id, prefixLen = opt.sugPrefix.length;\n                        crtSel = parseInt(divId.substr(prefixLen), 10);\n                        crtXcatSel = ((((divId.length === ((prefixLen + 1)))) ? -1 : parseInt(divId.substr(((prefixLen + 2)), 1), 10)));\n                        ((JSBNG__event && JSBNG__event.stopPropagation()));\n                        updateCrtSuggestion();\n                        $($.JSBNG__find(\".main-suggestion:first\")).amznFlyoutIntent(\"destroy\");\n                        JSBNG__searchSuggest.hide();\n                        if (opt.iac) {\n                            inlineAutoComplete.clear();\n                        }\n                    ;\n                    ;\n                        if (!delayedDOMUpdate) {\n                            opt.form.submit();\n                        }\n                         else {\n                            window.JSBNG__setTimeout(function() {\n                                opt.form.submit();\n                            }, 10);\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    function updateCrtSuggestion(reftagPrefix) {\n                        var alias, categoryName, sg;\n                        if (((crtSel >= 0))) {\n                            if (((opt.twoPane === 1))) {\n                                sg = ((((crtXcatSel >= 0)) ? twoPaneSuggestionsList[crtSel].xcat[crtXcatSel] : twoPaneSuggestionsList[crtSel]));\n                            }\n                             else {\n                                if (((redirectFirstSuggestion && ((crtSel == 0))))) {\n                                    sg = suggestionList[1];\n                                }\n                                 else {\n                                    sg = suggestionList[crtSel];\n                                }\n                            ;\n                            ;\n                            }\n                        ;\n                        ;\n                            keyword(sg.keyword);\n                            alias = sg.alias;\n                            categoryName = sg.categoryName;\n                        }\n                    ;\n                    ;\n                        if (staticContent) {\n                            if (((crtSel >= 0))) {\n                                updateForm(sg.i);\n                                disable(\"\");\n                            }\n                             else {\n                                checkForExactMatch();\n                                checkForManualOverride();\n                            }\n                        ;\n                        ;\n                        }\n                         else {\n                            updateCategoryDropDown(alias, categoryName);\n                            setDynamicSearch(sg, reftagPrefix);\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    ((opt.form && opt.form.submit(function() {\n                        var currentKeyword = normalize(keyword()), refTag = \"ref=nb_sb_noss\", i = 0;\n                        if (inlineAutoComplete) {\n                            inlineAutoComplete.clear();\n                        }\n                    ;\n                    ;\n                        var iacType = ((opt.iac ? inlineAutoComplete.type() : 0));\n                        if (iacType) {\n                            refTag = ((\"ref=nb_sb_iac_\" + iacType));\n                        }\n                         else {\n                            if (((crtSel > -1))) {\n                                return;\n                            }\n                        ;\n                        ;\n                            var sgList = ((((opt.twoPane === 1)) ? twoPaneSuggestionsList : suggestionList));\n                            if (((sgList.length > 0))) {\n                                refTag = \"ref=nb_sb_noss_2\";\n                                while (((i < sgList.length))) {\n                                    if (((normalize(sgList[i].keyword) == currentKeyword))) {\n                                        refTag = \"ref=nb_sb_noss_1\";\n                                        break;\n                                    }\n                                ;\n                                ;\n                                    i++;\n                                };\n                            ;\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                        opt.form.attr(\"action\", opt.form.attr(\"action\").replace(refre, refTag));\n                    })));\n                    function setDynamicSearch(sg, reftagPrefix) {\n                        var prefixElems = $(\"#issprefix\");\n                        if (sg) {\n                            var issMode, issModePrefix = \"ss_\", kw = searchBox.userInput();\n                            if (reftagPrefix) {\n                                issModePrefix += reftagPrefix;\n                            }\n                        ;\n                        ;\n                            if (isFallbackSuggestion(sg)) {\n                                issMode = ((issModePrefix + \"fb\"));\n                            }\n                             else {\n                                if (sg.alias) {\n                                    issMode = ((issModePrefix + \"c\"));\n                                }\n                                 else {\n                                    if (((opt.sc && isSpellCorrection(sg)))) {\n                                        issMode = ((issModePrefix + \"sc\"));\n                                    }\n                                     else {\n                                        issMode = ((issModePrefix + \"i\"));\n                                    }\n                                ;\n                                ;\n                                }\n                            ;\n                            ;\n                            }\n                        ;\n                        ;\n                            setSearchFormReftag(opt.form, null, issMode, sg, kw.length);\n                            kw = ((((((((kw + \",\")) + searchAliasFrom)) + \",\")) + timeToFirstSuggestion));\n                            if (prefixElems.length) {\n                                prefixElems.attr(\"value\", kw);\n                            }\n                             else {\n                                input(opt.form, \"issprefix\", \"sprefix\", kw);\n                            }\n                        ;\n                        ;\n                        }\n                         else {\n                            prefixElems.remove();\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    function twoPaneSuggestOver() {\n                        var len = opt.sugPrefix.length, id = this.id, crtSelId = ((((\"#\" + opt.sugPrefix)) + crtSel)), xcatSelId, nextSel = parseInt(id.substr(len, 1), 10);\n                        this.style.cursor = \"pointer\";\n                        $(\".xcat-panel\").hide();\n                        if (((nextSel !== crtSel))) {\n                            $(crtSelId).removeClass(\"suggest_link_over\");\n                        }\n                    ;\n                    ;\n                        $(((((\"#\" + opt.sugPrefix)) + \"0\"))).removeClass(\"xcat-arrow-hint\");\n                        crtSel = nextSel;\n                        crtXcatSel = ((((id.length === ((len + 1)))) ? -1 : parseInt(id.substr(((len + 2)), 1), 10)));\n                        crtSelId = ((((\"#\" + opt.sugPrefix)) + crtSel));\n                        $(crtSelId).addClass(\"suggest_link_over\");\n                        $(((\"#xcatPanel-\" + crtSel))).show();\n                        if (((crtXcatSel > -1))) {\n                            $(((((((((\"#\" + opt.sugPrefix)) + crtSel)) + \"-\")) + crtXcatSel))).addClass(\"suggest_link_over\");\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    function twoPaneSuggestOut() {\n                        $(this).removeClass(\"suggest_link_over\");\n                    };\n                ;\n                    function twoPaneXcatSuggestOut() {\n                        unhighlightSuggestion($(this));\n                    };\n                ;\n                    function resizeHandler() {\n                        var p = searchBox.pos(), d = searchBox.size();\n                        this.css({\n                            width: d.width,\n                            JSBNG__top: ((p.JSBNG__top + d.height)),\n                            left: p.left\n                        });\n                    };\n                ;\n                    function twoPaneBindFlyout() {\n                        JSBNG__searchSuggest.getNode().JSBNG__find(\".main-suggestion\").amznFlyoutIntent({\n                            onMouseOver: twoPaneSuggestOver,\n                            getTarget: function() {\n                                return $(\"#two-pane-table .xcat-suggestions:first\");\n                            }\n                        });\n                    };\n                ;\n                    function twoPaneDestroyFlyout() {\n                        var mainSgs = JSBNG__searchSuggest.getNode().JSBNG__find(\".main-suggestion\").get(0);\n                        if (mainSgs) {\n                            $(mainSgs).amznFlyoutIntent(\"destroy\");\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    function twoPaneSetPosition() {\n                        var p = searchBox.pos(), d = searchBox.size(), minWidth = 649;\n                        this.css({\n                            width: Math.max(((d.width + 72)), minWidth),\n                            JSBNG__top: ((((p.JSBNG__top + d.height)) + 1)),\n                            left: ((p.left - 40))\n                        });\n                    };\n                ;\n                    function twoPaneSetXcatPosition() {\n                        var maxH = this.JSBNG__find(\".main-suggestions:first\").height(), th = this.JSBNG__find(((((\"#\" + opt.sugPrefix)) + \"0\"))).JSBNG__outerHeight(), sgLen = twoPaneSuggestionsList.length, i, h, xb, xh, off;\n                        for (i = 1; ((i < sgLen)); i++) {\n                            h = this.JSBNG__find(((((\"#\" + opt.sugPrefix)) + i))).JSBNG__outerHeight();\n                            xb = this.JSBNG__find(((\"#xcatPanel-\" + i)));\n                            off = th;\n                            if (xb) {\n                                xb = $(xb);\n                                xh = xb.JSBNG__outerHeight();\n                                if (((((off + xh)) > maxH))) {\n                                    off = ((maxH - xh));\n                                }\n                            ;\n                            ;\n                                xb.css({\n                                    \"margin-top\": off\n                                });\n                            }\n                        ;\n                        ;\n                            th += h;\n                        };\n                    ;\n                    };\n                ;\n                    function suggestOver(JSBNG__event) {\n                        this.style.cursor = ((((newDesign == true)) ? \"pointer\" : \"default\"));\n                        unhighlightCurrentSuggestion();\n                        crtSel = parseInt(this.id.substr(opt.sugPrefix.length), 10);\n                        highlightCurrentSuggestion(false);\n                    };\n                ;\n                    function suggestOut(el, JSBNG__event) {\n                        unhighlightSuggestion($(this));\n                        crtSel = -1;\n                    };\n                ;\n                    function highlightSuggestion(suggestion) {\n                        suggestion.addClass(\"suggest_link_over\");\n                    };\n                ;\n                    function unhighlightSuggestion(suggestion) {\n                        suggestion.removeClass(\"suggest_link_over\");\n                    };\n                ;\n                    function highlightCurrentSuggestion(updateSearchBox) {\n                        if (((suggType == \"sugg\"))) {\n                            ((updateSearchBox && updateCrtSuggestion()));\n                        }\n                    ;\n                    ;\n                        highlightSuggestion($(((((\"#\" + opt.sugPrefix)) + crtSel))));\n                    };\n                ;\n                    function unhighlightCurrentSuggestion() {\n                        unhighlightSuggestion($(((((\"#\" + opt.sugPrefix)) + crtSel))));\n                    };\n                ;\n                    function updateCategoryDropDown(alias, categoryName) {\n                        var dd = ddBox, toRemove, val;\n                        if (!dd) {\n                            return;\n                        }\n                    ;\n                    ;\n                        val = ((alias ? ((\"search-alias=\" + alias)) : defaultDropDownVal));\n                        toRemove = ((((((val == insertedDropDownVal)) || ((defaultDropDownVal == insertedDropDownVal)))) ? null : insertedDropDownVal));\n                        if (alias) {\n                            var sel = findOption(dd, val);\n                            insertedDropDownVal = null;\n                            if (!sel.length) {\n                                dd.append(option(val, categoryName));\n                                insertedDropDownVal = val;\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                        try {\n                            delayedDOMUpdate = false;\n                            (($(dcs).length && changeDropdownSelection(val, categoryName, true)));\n                            dd.val(val);\n                        } catch (e) {\n                            delayedDOMUpdate = true;\n                        };\n                    ;\n                        ((toRemove && findOption(dd, toRemove).remove()));\n                    };\n                ;\n                    function getPrefixPos(str, substr) {\n                        if (opt.multiword) {\n                            return getPrefixPosMultiWord(str, substr);\n                        }\n                    ;\n                    ;\n                        return normalize(str).indexOf(normalize(substr));\n                    };\n                ;\n                    function getPrefixPosMultiWord(str, substr) {\n                        var p = normalize(str).search(new RegExp(((\"(^|(?:\\\\s))\" + normalize(substr))), \"i\"));\n                        return ((((p <= 0)) ? p : ((p + 1))));\n                    };\n                ;\n                    function getFormattedSuggestionLine(curSuggestionLine, crtPrefix) {\n                        var kw = curSuggestionLine.keyword, start = getPrefixPos(kw, crtPrefix), len;\n                        if (((start !== -1))) {\n                            len = crtPrefix.length;\n                            kw = [kw.substr(0, start),\"\\u003Cb\\u003E\",kw.substr(start, len),\"\\u003C/b\\u003E\",kw.substr(((start + len))),].join(\"\");\n                        }\n                    ;\n                    ;\n                        return kw;\n                    };\n                ;\n                    function getFormattedCategoryLine(categoryLine, crtPrefix) {\n                        var formattedCategoryLine, formattedCategoryName;\n                        if (opt.scs) {\n                            formattedCategoryLine = \"\\u003Cspan class=\\\"suggest_category_without_keyword\\\"\\u003E\";\n                            formattedCategoryName = ((((\"\\u003Cspan class=\\\"sx_category_name_highlight\\\"\\u003E\" + categoryLine.categoryName)) + \"\\u003C/span\\u003E\"));\n                        }\n                         else {\n                            formattedCategoryLine = ((getFormattedSuggestionLine(categoryLine, crtPrefix) + \" \\u003Cspan class=\\\"suggest_category\\\"\\u003E\"));\n                            formattedCategoryName = categoryLine.categoryName;\n                        }\n                    ;\n                    ;\n                        return ((opt.deptText ? ((((formattedCategoryLine + opt.deptText.replace(deptre, formattedCategoryName))) + \"\\u003C/span\\u003E\")) : categoryLine.categoryName));\n                    };\n                ;\n                    function hideSuggestionsDiv() {\n                        if (((((suggType == \"sugg\")) && suggestRequest))) {\n                            suggestRequest.cleanup();\n                            suggestRequest = null;\n                        }\n                    ;\n                    ;\n                        curSize = 0;\n                        $($.JSBNG__find(\".main-suggestion:first\")).amznFlyoutIntent(\"destroy\");\n                        JSBNG__searchSuggest.hide();\n                        crtSel = -1;\n                        crtXcatSel = -1;\n                    };\n                ;\n                    function updateWholeForm(v) {\n                        var fp = getFormParams(v);\n                        cleanForm();\n                        populateForm(fp);\n                    };\n                ;\n                    function updateForm(index) {\n                        var v = values[index];\n                        if (((opt.valInput && opt.valInput.length))) {\n                            opt.valInput.attr(\"value\", v);\n                        }\n                         else {\n                            updateWholeForm(((v || JSBNG__location.href)));\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    function getFormParams(url) {\n                        var splitUrl = url.split(\"?\"), query = ((((splitUrl.length > 1)) ? splitUrl[1] : undefined)), params = ((query ? query.split(\"&\") : [])), i = params.length, pair;\n                        while (((i-- > 0))) {\n                            pair = params[i].split(\"=\");\n                            params[i] = {\n                                JSBNG__name: pair[0],\n                                value: pair[1].replace(slashre, \" \")\n                            };\n                        };\n                    ;\n                        return {\n                            uri: splitUrl[0],\n                            formParams: params\n                        };\n                    };\n                ;\n                    function cleanForm() {\n                        opt.form.JSBNG__find(\".frmDynamic\").remove();\n                    };\n                ;\n                    function populateForm(formData) {\n                        opt.form.attr(\"action\", formData.uri);\n                        for (var i = 0; ((i < formData.formParams.length)); i++) {\n                            var param = formData.formParams[i];\n                            input(opt.form, \"frmDynamic\", param.JSBNG__name, unescape(decodeURIComponent(param.value)), 1);\n                        };\n                    ;\n                    };\n                ;\n                    function keyword(k) {\n                        return searchBox.keyword(k);\n                    };\n                ;\n                    function searchAlias(alias) {\n                        if (alias) {\n                            changeDropdownSelection(alias);\n                        }\n                         else {\n                            return extractSearchAlias(ddBox.attr(\"value\"));\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    function extractSearchAlias(alias) {\n                        var aliasName = alias.match(aliasre);\n                        return ((aliasName ? aliasName[1] : null));\n                    };\n                ;\n                    function searchNode() {\n                        var nodeName = ddBox.attr(\"value\").match(nodere);\n                        return ((nodeName ? nodeName[1] : null));\n                    };\n                ;\n                    function merchant() {\n                        var merchant = ddBox.attr(\"value\").match(merchantre);\n                        return ((merchant ? merchant[1] : null));\n                    };\n                ;\n                    function suggestions() {\n                        return suggestionList;\n                    };\n                ;\n                    function supportedSearchAlias(alias) {\n                        var a = opt.aliases;\n                        return ((a && ((arrayIndexOf(a, alias) >= 0))));\n                    };\n                ;\n                    function isSpellCorrection(sg) {\n                        return ((((sg && sg.sc)) ? true : false));\n                    };\n                ;\n                    function isFallbackSuggestion(sg) {\n                        return ((((sg && sg.source)) && ((sg.source[0] == \"fb\"))));\n                    };\n                ;\n                    function combineSuggestions(crtSuggestions, extraData) {\n                        var xcatSuggestions, m, n = crtSuggestions.length, combinedList = [], i = 0, j = 0, sg, cs, s, si = 0, deepNodeAlias = ((((((!searchAlias() && opt.deepNodeISS)) && !opt.deepNodeISS.stayInDeepNode)) && opt.deepNodeISS.searchAliasAccessor())), deepNodeCatName = ((deepNodeAlias && getDDCatName(deepNodeAlias)));\n                        categorySuggestions = 0;\n                        redirectFirstSuggestion = false;\n                        while (((((combinedList.length < opt.maxSuggestions)) && ((i < n))))) {\n                            sg = {\n                                keyword: crtSuggestions[i],\n                                sc: isSpellCorrection(extraData[i]),\n                                sgIndex: i\n                            };\n                            if (((deepNodeAlias && deepNodeCatName))) {\n                                sg.alias = deepNodeAlias;\n                                sg.categoryName = deepNodeCatName;\n                            }\n                        ;\n                        ;\n                            combinedList.push(sg);\n                            xcatSuggestions = ((((((extraData && extraData.length)) ? extraData[i].nodes : [])) || []));\n                            m = xcatSuggestions.length;\n                            if (m) {\n                                s = extraData[i].source;\n                                if (((s && s.length))) {\n                                    for (si = 0; ((si < s.length)); si++) {\n                                        if (((s[si] === \"fb\"))) {\n                                            if (((((n == 1)) && opt.scs))) {\n                                                redirectFirstSuggestion = true;\n                                            }\n                                             else {\n                                                combinedList.pop();\n                                            }\n                                        ;\n                                        ;\n                                            break;\n                                        }\n                                    ;\n                                    ;\n                                    };\n                                ;\n                                }\n                            ;\n                            ;\n                                j = 0;\n                                while (((((((j < m)) && ((j < maxCategorySuggestions)))) && ((combinedList.length < opt.maxSuggestions))))) {\n                                    cs = xcatSuggestions[j];\n                                    sg = {\n                                        keyword: crtSuggestions[i],\n                                        sc: isSpellCorrection(extraData[i]),\n                                        source: extraData[i].source,\n                                        alias: cs.alias,\n                                        categoryName: cs.JSBNG__name,\n                                        sgIndex: i,\n                                        xcatIndex: j\n                                    };\n                                    combinedList.push(sg);\n                                    ++j;\n                                    ++categorySuggestions;\n                                };\n                            ;\n                            }\n                        ;\n                        ;\n                            if (((((((i == 0)) && enableSeparateCategorySuggestion())) && !redirectFirstSuggestion))) {\n                                combinedList.push(combinedList[0]);\n                                opt.maxSuggestions += 1;\n                            }\n                        ;\n                        ;\n                            ++i;\n                        };\n                    ;\n                        curSize = combinedList.length;\n                        return combinedList;\n                    };\n                ;\n                    function enableSeparateCategorySuggestion() {\n                        return ((opt.scs && ((categorySuggestions > 0))));\n                    };\n                ;\n                    function getDDCatName(alias) {\n                        if (!alias) {\n                            return $(ddBox.children()[0]).text();\n                        }\n                    ;\n                    ;\n                        var catName = findOption(ddBox, ((\"search-alias=\" + alias)));\n                        if (((catName && catName.length))) {\n                            return catName.text();\n                        }\n                         else {\n                            return undefined;\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    function build2PaneSuggestions(crtSuggestions, extraData) {\n                        var xcatSuggestions, xcat = [], m, n = crtSuggestions.length, combinedList = [], i = 0, j = 0, sg, cs, s, si = 0, currAlias = searchAlias(), currCatName = getDDCatName(currAlias), deepNodeAlias = ((((((!currAlias && opt.deepNodeISS)) && !opt.deepNodeISS.stayInDeepNode)) && opt.deepNodeISS.searchAliasAccessor())), deepNodeCatName = getDDCatName(deepNodeAlias);\n                        while (((((combinedList.length < opt.maxSuggestions)) && ((i < n))))) {\n                            xcatSuggestions = ((((((extraData && extraData.length)) ? extraData[i].nodes : [])) || []));\n                            xcat = [];\n                            sg = {\n                                keyword: crtSuggestions[i],\n                                sc: isSpellCorrection(extraData[i]),\n                                source: ((extraData[i].source || \"c\")),\n                                conf: extraData[i].conf,\n                                sgIndex: i,\n                                xcatIndex: 0\n                            };\n                            if (deepNodeAlias) {\n                                sg.alias = deepNodeAlias;\n                                sg.categoryName = deepNodeCatName;\n                            }\n                             else {\n                                if (currAlias) {\n                                    sg.alias = currAlias;\n                                    sg.categoryName = currCatName;\n                                }\n                                 else {\n                                    sg.categoryName = deepNodeCatName;\n                                }\n                            ;\n                            ;\n                            }\n                        ;\n                        ;\n                            xcat.push(sg);\n                            m = xcatSuggestions.length;\n                            if (m) {\n                                j = 0;\n                                while (((((j < m)) && ((j < opt.maxSuggestions))))) {\n                                    cs = xcatSuggestions[j];\n                                    sg = {\n                                        keyword: crtSuggestions[i],\n                                        sc: isSpellCorrection(extraData[i]),\n                                        source: ((extraData[i].source || \"c\")),\n                                        alias: cs.alias,\n                                        categoryName: cs.JSBNG__name,\n                                        conf: extraData[i].conf,\n                                        sgIndex: i,\n                                        xcatIndex: ((j + 1))\n                                    };\n                                    xcat.push(sg);\n                                    ++j;\n                                };\n                            ;\n                            }\n                        ;\n                        ;\n                            sg = {\n                                keyword: crtSuggestions[i],\n                                sc: isSpellCorrection(extraData[i]),\n                                conf: extraData[i].conf,\n                                sgIndex: i,\n                                xcat: xcat\n                            };\n                            if (deepNodeAlias) {\n                                sg.alias = deepNodeAlias;\n                            }\n                        ;\n                        ;\n                            combinedList.push(sg);\n                            ++i;\n                        };\n                    ;\n                        curSize = combinedList.length;\n                        return combinedList;\n                    };\n                ;\n                    function searchJSONSuggest(newKw, newImeEnhUsed) {\n                        lastKeyPressTime = now();\n                        ((suggestRequest && suggestRequest.cleanup()));\n                        if (!activityAllowed) {\n                            return;\n                        }\n                    ;\n                    ;\n                        if (!searchBox.hasFocus()) {\n                            return;\n                        }\n                    ;\n                    ;\n                        var alias = ((searchAlias() || ((opt.deepNodeISS ? opt.deepNodeISS.searchAliasAccessor() : null)))), kw = ((newKw || keyword())), suggestUrl = [], a = function() {\n                            $.each(arguments, function(i, t) {\n                                suggestUrl.push(t);\n                            });\n                        }, m = ((((reqCounter === 0)) ? metrics.completionsRequest0 : ((((reqCounter === metrics.sample)) ? metrics.completionsRequestSample : null)))), cursorPos, qs;\n                        if (!supportedSearchAlias(alias)) {\n                            hideSuggestionsDiv();\n                            return;\n                        }\n                    ;\n                    ;\n                        if (opt.qs) {\n                            cursorPos = searchBox.cursorPos();\n                            if (((((cursorPos > -1)) && ((cursorPos < kw.length))))) {\n                                qs = kw.substring(cursorPos);\n                                kw = kw.substring(0, cursorPos);\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                        a(opt.protocol, \"//\", opt.src, \"?\", \"method=completion\", \"&q=\", encodeURIComponent(kw), \"&search-alias=\", alias, \"&client=\", opt.cid, \"&mkt=\", opt.mkt, \"&fb=\", opt.fb, \"&xcat=\", opt.xcat, \"&x=updateISSCompletion\");\n                        if (qs) {\n                            a(((\"&qs=\" + encodeURIComponent(qs))));\n                        }\n                    ;\n                    ;\n                        if (opt.np) {\n                            a(((\"&np=\" + opt.np)));\n                        }\n                    ;\n                    ;\n                        if (opt.sc) {\n                            a(\"&sc=1\");\n                        }\n                    ;\n                    ;\n                        if (((opt.dupElim > 0))) {\n                            a(\"&dr=\", opt.dupElim);\n                        }\n                    ;\n                    ;\n                        if (opt.custIss4Prime) {\n                            a(\"&pf=1\");\n                        }\n                    ;\n                    ;\n                        if (suggestRequest) {\n                            suggestRequest.cleanup();\n                        }\n                    ;\n                    ;\n                        suggestRequest = new A9JSONClient(kw, reqCounter++, newImeEnhUsed);\n                        suggestRequest.callSuggestionsService(suggestUrl.join(\"\"));\n                    };\n                ;\n                    function updateCompletion() {\n                        if (!suggestRequest) {\n                            return;\n                        }\n                    ;\n                    ;\n                        if (((((((((!activityAllowed || !completion.length)) || !completion[0])) || !suggestRequest.keywords)) || ((completion[0].toLowerCase() != suggestRequest.keywords.toLowerCase()))))) {\n                            return;\n                        }\n                    ;\n                    ;\n                        imeEnhUsed = suggestRequest.imeEnhUsed;\n                        var c = suggestRequest.counter, m = ((((c === 0)) ? metrics.completionsRequest0 : ((((c === metrics.sample)) ? metrics.completionsRequestSample : null))));\n                        suggestRequest.cleanup();\n                        suggestRequest = null;\n                        if (!searchBox.hasFocus()) {\n                            return;\n                        }\n                    ;\n                    ;\n                        if (((opt.twoPane === 1))) {\n                            twoPaneSuggestionsList = build2PaneSuggestions(completion[1], ((((completion.length > 2)) ? completion[2] : [])));\n                            displayTwoPaneSuggestions(completion[0]);\n                            ((sugHandler && sugHandler(completion[0], twoPaneSuggestionsList)));\n                        }\n                         else {\n                            suggestionList = combineSuggestions(completion[1], ((((completion.length > 2)) ? completion[2] : [])));\n                            displaySuggestions(completion[0]);\n                            ((sugHandler && sugHandler(completion[0], suggestionList)));\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    function JSBNG__stop() {\n                        activityAllowed = false;\n                        requestedKeyword = \"\";\n                        if (suggestRequest) {\n                            suggestRequest.cleanup();\n                            suggestRequest = null;\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    function start() {\n                        activityAllowed = true;\n                    };\n                ;\n                    function encoding() {\n                        var encInput = opt.form.JSBNG__find(\"input[name^='__mk_']\");\n                        if (encInput.length) {\n                            return [encInput.attr(\"JSBNG__name\"),encInput.val(),];\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    function JSBNG__blur() {\n                        searchBox.JSBNG__blur();\n                    };\n                ;\n                    function JSBNG__focus() {\n                        searchBox.JSBNG__focus();\n                    };\n                ;\n                    function offset() {\n                        return searchBox.pos();\n                    };\n                ;\n                    function keydown(h) {\n                        searchBox.keydown(h);\n                    };\n                ;\n                    function checkIAC() {\n                        return inlineAutoComplete.touch();\n                    };\n                ;\n                    function isImeEnhUsed() {\n                        return imeEnhUsed;\n                    };\n                ;\n                    function triggerImeEnh() {\n                        return ((((searchBox.isImeUsed() && opt.ime)) && $.browser.msie));\n                    };\n                ;\n                    return {\n                        suggest: bindSuggest,\n                        keypress: bindKeypress,\n                        submit: bindSubmit,\n                        JSBNG__blur: JSBNG__blur,\n                        keyword: keyword,\n                        merchant: merchant,\n                        searchAlias: searchAlias,\n                        searchNode: searchNode,\n                        JSBNG__stop: JSBNG__stop,\n                        start: start,\n                        encoding: encoding,\n                        JSBNG__focus: JSBNG__focus,\n                        offset: offset,\n                        keydown: keydown,\n                        isImeEnhUsed: isImeEnhUsed,\n                        triggerImeEnh: triggerImeEnh,\n                        onFocus: ((searchBox ? searchBox.onFocus : function() {\n                        \n                        })),\n                        onBlur: ((searchBox ? searchBox.onBlur : function() {\n                        \n                        })),\n                        cursorPos: ((searchBox ? searchBox.cursorPos : function() {\n                            return -1;\n                        })),\n                        initStaticSuggestions: initStatic,\n                        initDynamicSuggestions: initDynamic,\n                        updateAutoCompletion: updateCompletion,\n                        init: init\n                    };\n                };\n                function now() {\n                    return (new JSBNG__Date).getTime();\n                };\n            ;\n                function nop() {\n                \n                };\n            ;\n                function suppress() {\n                    return false;\n                };\n            ;\n                function bzero(len, val) {\n                    var a = [];\n                    while (len--) {\n                        a.push(val);\n                    };\n                ;\n                    return a;\n                };\n            ;\n                function arrayIndexOf(a, v) {\n                    for (var i = 0, len = a.length; ((i < len)); i++) {\n                        if (((a[i] == v))) {\n                            return i;\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    return -1;\n                };\n            ;\n                function input(f, i, n, v, c) {\n                    f.append($(\"\\u003Cinput type=\\\"hidden\\\"/\\u003E\").attr(((c ? \"class\" : \"id\")), i).attr(\"JSBNG__name\", n).attr(\"value\", v));\n                };\n            ;\n                function option(v, t) {\n                    return $(\"\\u003Coption/\\u003E\").attr(\"value\", v).text(t);\n                };\n            ;\n                function keyClose(w) {\n                    return ((((w == 13)) || ((w == 32))));\n                };\n            ;\n                function findOption(d, v) {\n                    return d.JSBNG__find(((((\"option[value=\\\"\" + v)) + \"\\\"]\")));\n                };\n            ;\n                function tabIndex(e, i) {\n                    return e.attr(\"tabIndex\", i).attr(\"tabindex\", i);\n                };\n            ;\n                function getShortenedIDForOption(o) {\n                    var eq;\n                    if (((((!o || !o.length)) || (((eq = o.indexOf(\"=\")) == -1))))) {\n                        return \"\";\n                    }\n                ;\n                ;\n                    var alias = o.substr(((eq + 1))), dash = ((alias.indexOf(\"-\") + 1)), shortID = alias.substr(0, 3);\n                    return ((dash ? shortID : ((shortID + alias.charAt(dash)))));\n                };\n            ;\n                function changeDropdownSelection(optionValue, selectedDisplayName, highlightOnly, option) {\n                    var dd = ddBox;\n                    if (((((optionValue == \"search-alias=aps\")) && !selectedDisplayName))) {\n                        selectedDisplayName = findOption(dd, optionValue).text();\n                    }\n                ;\n                ;\n                    $(((\"#\" + sdpc))).css(\"visibility\", \"hidden\");\n                    $(dcs).text(selectedDisplayName);\n                    dd.val(optionValue);\n                    if (!highlightOnly) {\n                        opt.sb.JSBNG__focus();\n                        setSearchFormReftag(opt.form, optionValue);\n                    }\n                ;\n                ;\n                };\n            ;\n                function setSearchFormReftag(formElement, optionValue, issMode, sg, numUserChars) {\n                    var formAction = formElement.attr(\"action\"), isstag = ((((issMode != null)) && sg)), tag = ((isstag ? ((((((((issMode + \"_\")) + sg.sgIndex)) + \"_\")) + numUserChars)) : ((\"dd_\" + getShortenedIDForOption(optionValue)))));\n                    if (((isstag || ((optionValue != null))))) {\n                        if (!refre.test(formAction)) {\n                            if (((formAction.charAt(((formAction.length - 1))) != \"/\"))) {\n                                formAction += \"/\";\n                            }\n                        ;\n                        ;\n                            formAction += tag;\n                        }\n                         else {\n                            if (((isstag && ddaliasre.test(formAction)))) {\n                                formAction = formAction.replace(ddaliasre, ((\"$1_\" + tag)));\n                            }\n                             else {\n                                formAction = formAction.replace(refre, ((\"ref=nb_sb_\" + tag)));\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                        formElement.attr(\"action\", formAction);\n                    }\n                ;\n                ;\n                };\n            ;\n                function A9JSONClient(kw, counter, imeEnhUsed) {\n                    var fullUrl, noCacheIE, headLoc, scriptId, scriptObj, scriptCounter = ((counter || 0));\n                    function callService(url) {\n                        fullUrl = url;\n                        noCacheIE = ((\"&noCacheIE=\" + now()));\n                        headLoc = JSBNG__document.getElementsByTagName(\"head\").JSBNG__item(0);\n                        scriptId = ((\"JscriptId\" + scriptCounter));\n                        buildScriptTag();\n                        addScriptTag();\n                    };\n                ;\n                    function buildScriptTag() {\n                        scriptObj = JSBNG__document.createElement(\"script\");\n                        scriptObj.setAttribute(\"type\", \"text/javascript\");\n                        scriptObj.setAttribute(\"charset\", \"utf-8\");\n                        scriptObj.setAttribute(\"src\", ((fullUrl + noCacheIE)));\n                        scriptObj.setAttribute(\"id\", scriptId);\n                    };\n                ;\n                    function removeScriptTag() {\n                        try {\n                            headLoc.removeChild(scriptObj);\n                        } catch (e) {\n                        \n                        };\n                    ;\n                    };\n                ;\n                    function addScriptTag() {\n                        headLoc.appendChild(scriptObj);\n                    };\n                ;\n                    return {\n                        callSuggestionsService: callService,\n                        cleanup: removeScriptTag,\n                        keywords: kw,\n                        counter: scriptCounter,\n                        imeEnhUsed: imeEnhUsed\n                    };\n                };\n            ;\n                window.AutoComplete = AC;\n                if (metrics.isEnabled) {\n                    uet(\"cf\", metrics.init, {\n                        wb: 1\n                    });\n                }\n            ;\n            ;\n            })(window);\n            $SearchJS.publish(\"search-js-autocomplete-lib\");\n        });\n    }\n;\n;\n} catch (JSBNG_ex) {\n\n};");
// 1121
o2 = {};
// 1122
f876774570_65.returns.push(o2);
// 1123
o1.protocol = "http:";
// undefined
o1 = null;
// 1124
f876774570_7.returns.push(undefined);
// 1120
geval("var cloudfrontImg = new JSBNG__Image();\nif (((JSBNG__location.protocol == \"http:\"))) {\n    if (window.JSBNG__addEventListener) {\n        window.JSBNG__addEventListener(\"load\", ((window.top.JSBNG_Replay.push)((window.top.JSBNG_Replay.s6642b77f01f4d49ef240b29032e6da4372359178_0), function() {\n            JSBNG__setTimeout(((window.top.JSBNG_Replay.push)((window.top.JSBNG_Replay.s6642b77f01f4d49ef240b29032e6da4372359178_1), function() {\n                cloudfrontImg.src = \"http://cloudfront-labs.amazonaws.com/x.png\";\n            })), 400);\n        })), false);\n    }\n     else if (window.JSBNG__attachEvent) {\n        window.JSBNG__attachEvent(\"JSBNG__onload\", function() {\n            JSBNG__setTimeout(function() {\n                cloudfrontImg.src = \"http://cloudfront-labs.amazonaws.com/x.png\";\n            }, 400);\n        });\n    }\n    \n;\n;\n}\n;\n;");
// 1125
geval("amznJQ.onCompletion(\"amznJQ.criticalFeature\", function() {\n    var DPCL;\n    amznJQ.available(\"DPClientLogger\", function() {\n        if (((typeof window.DPClientLogger != \"undefined\"))) {\n            DPCL = new window.DPClientLogger.ImpressionLogger(\"dpbxapps\", \"bxapps-atfMarker\", true, true);\n        }\n    ;\n    ;\n    });\n    jQuery(\".oneClickSignInLink\").click(function(e) {\n        if (DPCL) {\n            DPCL.logImpression(\"ma-books-oneClick-signIn-C\");\n        }\n    ;\n    ;\n        return true;\n    });\n});");
// 1126
geval("var ImageBlockWeblabs = {\n};\nImageBlockWeblabs[\"swipe\"] = 0;\nImageBlockWeblabs[\"consolidated\"] = 1;\nImageBlockWeblabs[\"bookLargeImage\"] = 0;\namznJQ.available(\"ImageBlockATF\", function() {\n    amznJQ.onCompletion(\"amznJQ.criticalFeature\", function() {\n        var data = {\n            indexToColor: [\"initial\",],\n            visualDimensions: [\"color_name\",],\n            productGroupID: \"book_display_on_website\",\n            newVideoMissing: 0,\n            useIV: 1,\n            useChildVideos: 1,\n            numColors: 1,\n            defaultColor: \"initial\",\n            logMetrics: 0,\n            staticStrings: {\n                playVideo: \"Click to play video\",\n                rollOverToZoom: \"Roll over image to zoom in\",\n                images: \"Images\",\n                video: \"video\",\n                touchToZoom: \"Touch the image to zoom in\",\n                videos: \"Videos\",\n                close: \"Close\",\n                pleaseSelect: \"Please select\",\n                clickToExpand: \"Click to open expanded view\",\n                allMedia: \"All Media\"\n            },\n            gIsNewTwister: 0,\n            title: \"JavaScript: The Good Parts\",\n            ivRepresentativeAsin: {\n            },\n            mainImageSizes: [[\"300\",\"300\",],[\"300\",\"300\",],],\n            isQuickview: 0,\n            ipadVideoSizes: [[300,300,],[300,300,],],\n            colorToAsin: {\n            },\n            showLITBOnClick: 1,\n            stretchyGoodnessWidth: [1280,],\n            videoSizes: [[300,300,],[300,300,],],\n            autoplayVideo: 0,\n            hoverZoomIndicator: \"\",\n            sitbReftag: \"sib_dp_pt\",\n            useHoverZoom: 0,\n            staticImages: {\n                spinner: \"http://g-ecx.images-amazon.com/images/G/01/ui/loadIndicators/loading-large_labeled._V192238949_.gif\",\n                zoomOut: \"http://g-ecx.images-amazon.com/images/G/01/detail-page/cursors/zoom-out._V184888738_.bmp\",\n                hoverZoomIcon: \"http://g-ecx.images-amazon.com/images/G/01/img11/apparel/UX/DP/icon_zoom._V138923886_.png\",\n                zoomIn: \"http://g-ecx.images-amazon.com/images/G/01/detail-page/cursors/zoom-in._V184888790_.bmp\",\n                videoSWFPath: \"http://g-ecx.images-amazon.com/images/G/01/Quarterdeck/en_US/video/20110518115040892/Video._V178668404_.swf\",\n                zoomLensBackground: \"http://g-ecx.images-amazon.com/images/G/01/apparel/rcxgs/tile._V211431200_.gif\",\n                arrow: \"http://g-ecx.images-amazon.com/images/G/01/javascripts/lib/popover/images/light/sprite-vertical-popover-arrow._V186877868_.png\",\n                videoThumbIcon: \"http://g-ecx.images-amazon.com/images/G/01/Quarterdeck/en_US/images/video._V183716339_SS30_.gif\"\n            },\n            videos: [],\n            gPreferChildVideos: 1,\n            altsOnLeft: 0,\n            ivImageSetKeys: {\n                initial: 0\n            },\n            useHoverZoomIpad: \"\",\n            isUDP: 0,\n            alwaysIncludeVideo: 1,\n            widths: 0,\n            maxAlts: 7,\n            useChromelessVideoPlayer: 0\n        };\n        data[\"customerImages\"] = eval(\"[]\");\n        var def = ((colorImages ? colorImages[data.defaultColor] : []));\n        colorImages = {\n        };\n        colorImages[data.defaultColor] = def;\n        (function() {\n            var markup = \"%0A%0A%0A%0A%0A%0A%0A%0A%0A%3Cstyle%3E%0A%0Aa.slateLink%3Alink%7B%20color%3A%20rgb(119%2C119%2C119)%3B%20text-decoration%3Anone%3B%7D%0Aa.slateLink%3Aactive%20%7B%20color%3A%20rgb(119%2C119%2C119)%3B%20text-decoration%3Anone%3B%7D%0Aa.slateLink%3Avisited%7B%20color%3A%20rgb(119%2C119%2C119)%3B%20text-decoration%3Anone%3B%7D%0Aa.slateLink%3Ahover%7B%20color%3A%20rgb(119%2C119%2C119)%3B%20text-decoration%3Anone%3B%7D%0A%0A.shuttleGradient%20%7B%0A%20%20%20%20float%3Aleft%3B%0A%20%20%20%20width%3A100%25%3B%0A%20%20%20%20text-align%3Aleft%3B%0A%20%20%20%20line-height%3A%20normal%3B%0A%20%20%20%20position%3Arelative%3B%0A%20%20%20%20height%3A43px%3B%20%0A%20%20%20%20background-color%3A%23dddddd%3B%20%0A%20%20%20%20background-image%3A%20url(http%3A%2F%2Fg-ecx.images-amazon.com%2Fimages%2FG%2F01%2Fx-locale%2Fcommunities%2Fcustomerimage%2Fshuttle-gradient._V192250138_.gif)%3B%20%0A%20%20%20%20background-position%3A%20bottom%3B%20%0A%20%20%20%20background-repeat%20%3A%20repeat-x%3B%0A%7D%0A%0A.shuttleTextTop%20%7B%0A%20%20%20%20font-size%3A18px%3B%0A%20%20%20%20font-weight%3Abold%3B%0A%20%20%20%20font-family%3Averdana%2Carial%2Chelvetica%2Csans-serif%3B%0A%20%20%20%20color%3A%20rgb(119%2C119%2C119)%3B%0A%20%20%20%20margin-left%3A10px%3B%0A%7D%0A%0A.shuttleTextBottom%20%7B%0A%20%20%20%20margin-top%3A-2px%3B%0A%20%20%20%20font-size%3A15px%3B%0A%20%20%20%20font-family%3Averdana%2Carial%2Chelvetica%2Csans-serif%3B%0A%20%20%20%20color%3A%20rgb(119%2C119%2C119)%3B%0A%20%20%20%20margin-left%3A10px%3B%0A%7D%0A.outercenterslate%7B%0A%20%20%20%20cursor%3Apointer%3B%0A%7D%0A.innercenterslate%7B%0A%20%20%20%20overflow%3A%20hidden%3B%0A%7D%0A%0A.slateoverlay%7B%0A%20%20%20%20position%3A%20absolute%3B%0A%20%20%20%20top%3A%200px%3B%0A%20%20%20%20border%3A%200px%0A%7D%0A%0A.centerslate%20%7B%0A%20%20%20%20display%3A%20table-cell%3B%0A%20%20%20%20background-color%3Ablack%3B%20%0A%20%20%20%20text-align%3A%20center%3B%0A%20%20%20%20vertical-align%3A%20middle%3B%0A%7D%0A.centerslate%20*%20%7B%0A%20%20%20%20vertical-align%3A%20middle%3B%0A%7D%0A.centerslate%20%7B%20display%2F*%5C**%2F%3A%20block%5C9%20%7D%20%0A%2F*%5C*%2F%2F*%2F%0A.centerslate%20%7B%0A%20%20%20%20display%3A%20block%3B%0A%7D%0A.centerslate%20span%20%7B%0A%20%20%20%20display%3A%20inline-block%3B%0A%20%20%20%20height%3A%20100%25%3B%0A%20%20%20%20width%3A%201px%3B%0A%7D%0A%2F**%2F%0A%3C%2Fstyle%3E%0A%3C!--%5Bif%20lt%20IE%209%5D%3E%3Cstyle%3E%0A.centerslate%20span%20%7B%0A%20%20%20%20display%3A%20inline-block%3B%0A%20%20%20%20height%3A%20100%25%3B%0A%7D%0A%3C%2Fstyle%3E%3C!%5Bendif%5D--%3E%0A%3Cstyle%3E%0A%3C%2Fstyle%3E%0A%0A%3Cscript%20type%3D%22text%2Fjavascript%22%3E%0AamznJQ.addLogical(%22swfobject-2.2%22%2C%20%5B%22http%3A%2F%2Fz-ecx.images-amazon.com%2Fimages%2FG%2F01%2Fmedia%2Fswf%2Famznjq-swfobject-2.2._V210753426_.js%22%5D)%3B%0A%0Awindow.AmznVideoPlayer%3Dfunction(mediaObject%2CtargetId%2Cwidth%2Cheight)%7B%0A%20%20AmznVideoPlayer.players%5BmediaObject.mediaObjectId%5D%3Dthis%3B%0A%20%20this.slateImageUrl%3DmediaObject.slateImageUrl%3B%0A%20%20this.id%3DmediaObject.mediaObjectId%3B%0A%20%20this.preplayWidth%3Dwidth%3B%0A%20%20this.preplayHeight%3Dheight%3B%0A%20%20this.flashDivWidth%3Dwidth%3B%0A%20%20this.flashDivHeight%3Dheight%3B%0A%20%20this.targetId%3DtargetId%3B%0A%20%20this.swfLoading%3D0%3B%0A%20%20this.swfLoaded%3D0%3B%0A%20%20this.preplayDivId%3D'preplayDiv'%2Bthis.id%3B%0A%20%20this.flashDivId%3D'flashDiv'%2Bthis.id%3B%0A%7D%0A%0AAmznVideoPlayer.players%3D%5B%5D%3B%0AAmznVideoPlayer.session%3D'181-0531756-0630505'%3B%0AAmznVideoPlayer.root%3D'http%3A%2F%2Fwww.amazon.com'%3B%0AAmznVideoPlayer.locale%3D'en_US'%3B%0AAmznVideoPlayer.swf%3D'http%3A%2F%2Fg-ecx.images-amazon.com%2Fimages%2FG%2F01%2Fam3%2F20120510035744301%2FAMPlayer._V148501545_.swf'%3B%0AAmznVideoPlayer.preplayTemplate%3D'%3Cdiv%20style%3D%22width%3A0px%3Bheight%3A0px%3B%22%20class%3D%22outercenterslate%22%3E%3Cdiv%20style%3D%22width%3A0px%3Bheight%3A-43px%3B%22%20class%3D%22centerslate%22%20%3E%3Cspan%3E%3C%2Fspan%3E%3Cimg%20border%3D%220%22%20alt%3D%22Click%20to%20watch%20this%20video%22%20src%3D%22slateImageGoesHere%22%3E%3C%2Fdiv%3E%3Cdiv%20class%3D%22shuttleGradient%22%3E%3Cdiv%20class%3D%22shuttleTextTop%22%3EAmazon%3C%2Fdiv%3E%3Cdiv%20class%3D%22shuttleTextBottom%22%3EVideo%3C%2Fdiv%3E%3Cimg%20id%3D%22mediaObjectIdpreplayImageId%22%20style%3D%22height%3A74px%3Bposition%3Aabsolute%3Bleft%3A-31px%3Btop%3A-31px%3B%22%20src%3D%22http%3A%2F%2Fg-ecx.images-amazon.com%2Fimages%2FG%2F01%2Fx-locale%2Fcommunities%2Fcustomerimage%2Fplay-shuttle-off._V192250119_.gif%22%20border%3D%220%22%2F%3E%3C%2Fdiv%3E%3C%2Fdiv%3E'%3B%0AAmznVideoPlayer.rollOn%3D'http%3A%2F%2Fg-ecx.images-amazon.com%2Fimages%2FG%2F01%2Fx-locale%2Fcommunities%2Fcustomerimage%2Fplay-shuttle-on._V192250112_.gif'%3B%0AAmznVideoPlayer.rollOff%3D'http%3A%2F%2Fg-ecx.images-amazon.com%2Fimages%2FG%2F01%2Fx-locale%2Fcommunities%2Fcustomerimage%2Fplay-shuttle-off._V192250119_.gif'%3B%0AAmznVideoPlayer.flashVersion%3D'9.0.115'%3B%0AAmznVideoPlayer.noFlashMsg%3D'To%20view%20this%20video%20download%20%3Ca%20target%3D%22_blank%22%20href%3D%22http%3A%2F%2Fget.adobe.com%2Fflashplayer%2F%22%20target%3D%22_top%22%3EFlash%20Player%3C%2Fa%3E%20(version%209.0.115%20or%20higher)'%3B%0A%0AAmznVideoPlayer.hideAll%3Dfunction()%7B%0A%20%20for(var%20i%20in%20AmznVideoPlayer.players)%7B%0A%20%20%20%20AmznVideoPlayer.players%5Bi%5D.hidePreplay()%3B%0A%20%20%20%20AmznVideoPlayer.players%5Bi%5D.hideFlash()%3B%0A%20%20%7D%0A%7D%0A%0AAmznVideoPlayer.prototype.writePreplayHtml%3Dfunction()%7B%0A%20%20if(typeof%20this.preplayobject%3D%3D'undefined')%7B%0A%20%20%20%20this.preplayobject%3DjQuery(AmznVideoPlayer.preplayTemplate.replace(%22slateImageGoesHere%22%2Cthis.slateImageUrl)%0A%20%20%20%20%20%20%20%20.replace(%22mediaObjectId%22%2Cthis.id).replace(%22-43px%22%2C(this.preplayHeight-43)%2B%22px%22).replace(%22-31px%22%2C(Math.round(this.preplayWidth%2F2)-31)%2B%22px%22))%3B%0A%20%20%20%20this.preplayobject.width(this.preplayWidth%2B%22px%22).height(this.preplayHeight%2B%22px%22)%3B%0A%20%20%20%20this.preplayobject.find(%22.innercenterslate%22).width(this.preplayWidth%2B%22px%22).height(this.preplayHeight%2B%22px%22)%3B%0A%20%20%20%20this.preplayobject.find(%22.centerslate%22).width(this.preplayWidth%2B%22px%22)%3B%0A%20%20%20%20var%20self%3Dthis%3B%0A%20%20%20%20this.preparePlaceholder()%3B%0A%20%20%20%20jQuery(%22%23%22%2Bthis.preplayDivId).click(function()%7Bself.preplayClick()%3B%7D)%3B%0A%20%20%20%20jQuery(%22%23%22%2Bthis.preplayDivId).hover(%0A%20%20%20%20%20%20%20%20function()%7BjQuery(%22%23%22%2Bself.id%2B'preplayImageId').attr('src'%2CAmznVideoPlayer.rollOn)%3B%7D%2C%0A%20%20%20%20%20%20%20%20function()%7BjQuery(%22%23%22%2Bself.id%2B'preplayImageId').attr('src'%2CAmznVideoPlayer.rollOff)%3B%7D)%3B%0A%20%20%20%20jQuery(%22%23%22%2Bthis.preplayDivId).html(this.preplayobject)%3B%0A%20%20%7D%0A%7D%0A%0AAmznVideoPlayer.prototype.writeFlashHtml%3Dfunction()%7B%0A%20%20if(!this.swfLoaded%26%26!this.swfLoading)%7B%0A%20%20%20%20this.swfLoading%3D1%3B%0A%20%20%20%20var%20params%3D%7B'allowscriptaccess'%3A'always'%2C'allowfullscreen'%3A'true'%2C'wmode'%3A'transparent'%2C'quality'%3A'high'%7D%3B%0A%20%20%20%20var%20shiftJISRegExp%20%3D%20new%20RegExp(%22%5Ehttps%3F%3A%22%2BString.fromCharCode(0x5C)%2B%22%2F%22%2BString.fromCharCode(0x5C)%2B%22%2F%22)%3B%0A%20%20%20%20var%20flashvars%3D%7B'xmlUrl'%3AAmznVideoPlayer.root%2B'%2Fgp%2Fmpd%2Fgetplaylist-v2%2F'%2Bthis.id%2B'%2F'%2BAmznVideoPlayer.session%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20'mediaObjectId'%3Athis.id%2C'locale'%3AAmznVideoPlayer.locale%2C'sessionId'%3AAmznVideoPlayer.session%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20'amazonServer'%3AAmznVideoPlayer.root.replace(shiftJISRegExp%2C'')%2C'swfEmbedTime'%3Anew%20Date().getTime()%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20'allowFullScreen'%3A'true'%2C'amazonPort'%3A'80'%2C'preset'%3A'detail'%2C'autoPlay'%3A'1'%2C'permUrl'%3A'gp%2Fmpd%2Fpermalink'%2C'scale'%3A'noscale'%7D%3B%0A%20%20%20%20var%20self%3Dthis%3B%0A%20%20%20%20swfobject.embedSWF(AmznVideoPlayer.swf%2C'so_'%2Bthis.id%2C%22100%25%22%2C%22100%25%22%2CAmznVideoPlayer.flashVersion%2Cfalse%2Cflashvars%2Cparams%2Cparams%2C%0A%20%20%20%20%20%20function(e)%7B%0A%20%20%20%20%20%20%20%20self.swfLoading%3D0%3B%0A%20%20%20%20%20%20%20%20if(e.success)%7BAmznVideoPlayer.lastPlayedId%3Dself.id%3Bself.swfLoaded%3D1%3Breturn%3B%7D%0A%20%20%20%20%20%20%20%20jQuery('%23'%2Bself.flashDivId).html('%3Cbr%2F%3E%3Cbr%2F%3E%3Cbr%2F%3E%3Cbr%2F%3E%3Cbr%2F%3E%3Cbr%2F%3E%3Cbr%2F%3E'%2BAmznVideoPlayer.noFlashMsg).css(%7B'background'%3A'%23ffffff'%7D)%3B%0A%20%20%20%20%20%20%7D%0A%20%20%20%20)%3B%0A%20%20%7D%0A%7D%0A%0AAmznVideoPlayer.prototype.showPreplay%3Dfunction()%7B%0A%20%20this.writePreplayHtml()%3B%0A%20%20this.preparePlaceholder()%3B%0A%20%20jQuery(%22%23%22%2Bthis.preplayDivId).show()%3B%0A%20%20return%20this%3B%0A%7D%0A%0AAmznVideoPlayer.prototype.hidePreplay%3Dfunction()%7B%0A%20%20this.preparePlaceholder()%3B%0A%20%20jQuery(%22%23%22%2Bthis.preplayDivId).hide()%3B%0A%20%20return%20this%3B%0A%7D%0A%0AAmznVideoPlayer.prototype.showFlash%3Dfunction()%7B%0A%20%20this.preparePlaceholder()%3B%0A%20%20if(!this.swfLoaded%26%26!this.swfLoading)%7B%0A%20%20%20%20var%20self%3Dthis%3B%0A%20%20%20%20amznJQ.available(%22swfobject-2.2%22%2Cfunction()%7Bself.writeFlashHtml()%3B%7D)%3B%0A%20%20%7D%0A%20%20jQuery(%22%23%22%2Bthis.flashDivId).width(this.flashDivWidth%2B'px').height(this.flashDivHeight%2B'px')%3B%0A%20%20AmznVideoPlayer.lastPlayedId%3Dthis.id%3B%0A%20%20return%20this%3B%0A%7D%0A%0AAmznVideoPlayer.prototype.hideFlash%3Dfunction()%7B%0A%20%20this.preparePlaceholder()%3B%0A%20%20jQuery(%22%23%22%2Bthis.flashDivId).width('0px').height('1px')%3B%0A%20%20return%20this%3B%0A%7D%0A%0AAmznVideoPlayer.prototype.preparePlaceholder%3Dfunction()%7B%0A%20%20if(!(jQuery('%23'%2Bthis.flashDivId).length)%7C%7C!(jQuery('%23'%2Bthis.preplayDivId)))%7B%0A%20%20%20%20var%20preplayDiv%3DjQuery(%22%3Cdiv%20id%3D'%22%2Bthis.preplayDivId%2B%22'%3E%3C%2Fdiv%3E%22).css(%7B'position'%3A'relative'%7D)%3B%0A%20%20%20%20var%20flashDiv%3DjQuery(%22%3Cdiv%20id%3D'%22%2Bthis.flashDivId%2B%22'%3E%3Cdiv%20id%3D'so_%22%2Bthis.id%2B%22'%2F%3E%3C%2Fdiv%3E%22).css(%7B'overflow'%3A'hidden'%2Cbackground%3A'%23000000'%7D)%3B%0A%20%20%20%20var%20wrapper%3DjQuery(%22%3Cdiv%2F%3E%22).css(%7B'position'%3A'relative'%2C'float'%3A'left'%7D).append(preplayDiv).append(flashDiv)%3B%0A%20%20%20%20jQuery('%23'%2Bthis.targetId).html(wrapper)%3B%0A%20%20%7D%0A%7D%0A%0AAmznVideoPlayer.prototype.resizeVideo%3Dfunction(width%2Cheight)%7B%0A%20%20this.flashDivWidth%3Dwidth%3B%0A%20%20this.flashDivHeight%3Dheight%3B%0A%20%20if%20(jQuery(%22%23%22%2Bthis.flashDivId)%26%26jQuery(%22%23%22%2Bthis.flashDivId).width()!%3D0)%7Bthis.showFlash()%3B%7D%0A%7D%0A%0AAmznVideoPlayer.prototype.preplayClick%3Dfunction()%7B%20%0A%20%20if(this.swfLoaded)%7Bthis.play()%3B%7D%20%0A%20%20this.showFlash()%3B%0A%20%20this.hidePreplay()%3B%0A%7D%0A%0AAmznVideoPlayer.prototype.play%3Dfunction()%7B%0A%20%20var%20so%3Dthis.getSO()%3B%0A%20%20if(typeof%20so.playVideo%3D%3D'function')%7B%0A%20%20%20%20if(this.id!%3DAmznVideoPlayer.lastPlayedId)%7B%0A%20%20%20%20%20%20AmznVideoPlayer.players%5BAmznVideoPlayer.lastPlayedId%5D.pause()%3B%0A%20%20%20%20%7D%0A%20%20%20%20AmznVideoPlayer.lastPlayedId%3Dthis.id%3Bso.playVideo()%3B%0A%20%20%7D%0A%7D%0A%0AAmznVideoPlayer.prototype.pause%3Dfunction()%7Bif(this.swfLoading%7C%7Cthis.swfLoaded)%7Bthis.autoplayCancelled%3Dtrue%3B%7Dvar%20so%3Dthis.getSO()%3Bif(so%20%26%26%20typeof%20so.pauseVideo%3D%3D'function')%7Bso.pauseVideo()%3B%7D%7D%0AAmznVideoPlayer.prototype.stop%3Dfunction()%7Bif(this.swfLoading%7C%7Cthis.swfLoaded)%7Bthis.autoplayCancelled%3Dtrue%3B%7Dvar%20so%3Dthis.getSO()%3Bif(so%20%26%26%20typeof%20so.stopVideo%3D%3D'function')%7Bso.stopVideo()%3B%7D%7D%0AAmznVideoPlayer.prototype.getSO%3Dfunction()%7Breturn%20jQuery(%22%23so_%22%2Bthis.id).get(0)%3B%7D%0A%0Afunction%20isAutoplayCancelled(showID)%20%7B%0A%20%20return%20(AmznVideoPlayer.players%5BshowID%5D%20%26%26%20AmznVideoPlayer.players%5BshowID%5D.autoplayCancelled%20%3D%3D%20true)%3B%20%0A%7D%0A%3C%2Fscript%3E%0A\";\n            jQuery(\"\\u003Cdiv\\u003E\\u003C/div\\u003E\").insertAfter(\"#main-image-widget\").html(decodeURIComponent(markup));\n        })();\n        data.cfEndTimer = new JSBNG__Date();\n        amznJQ.available(\"imageBlock\", function() {\n            jQuery.imageBlock = new ImageBlock(data);\n            ImageBlock.TwisterReArchModule = function() {\n                return jQuery.imageBlock.getTwisterReArchApis();\n            }();\n        });\n    });\n});");
// 1127
geval("if (window.amznJQ) {\n    amznJQ.onCompletion(\"amznJQ.criticalFeature\", function() {\n        var precacheDetailImages = function(imageUrls, pids) {\n            function transformUrl(imgUrl, pid) {\n                var suffix = \"._SL500_AA300_.jpg\", defaultApparel = \"._AA300_.jpg\", imgUrlSplit = imgUrl.split(\"._\");\n                if (imgUrlSplit.length) {\n                    var prefix = imgUrlSplit[0];\n                    if (((((!pid && ((storeName == \"books\")))) || ((pid == \"books_display_on_website\"))))) {\n                        if (imgUrl.match(\"PIsitb-sticker-arrow\")) {\n                            var OUID = imgUrl.substr(imgUrl.indexOf(\"_OU\"), 6);\n                            var lookInsideSticker = ((((\"._BO2,204,203,200_PIsitb-sticker-arrow-click,TopRight,35,-76_AA300_SH20\" + OUID)) + \".jpg\"));\n                            urls.push(((prefix + lookInsideSticker)));\n                        }\n                         else {\n                            urls.push(((prefix + suffix)));\n                        }\n                    ;\n                    ;\n                    }\n                     else if (((((!pid && ((storeName == \"apparel\")))) || ((pid == \"apparel_display_on_website\"))))) {\n                        urls.push(((prefix + \"._SX342_.jpg\")));\n                        urls.push(((prefix + \"._SY445_.jpg\")));\n                    }\n                     else if (((((!pid && ((storeName == \"shoes\")))) || ((pid == \"shoes_display_on_website\"))))) {\n                        urls.push(((prefix + \"._SX395_.jpg\")));\n                        urls.push(((prefix + \"._SY395_.jpg\")));\n                    }\n                     else {\n                        urls.push(((prefix + suffix)));\n                    }\n                    \n                    \n                ;\n                ;\n                }\n            ;\n            ;\n            };\n        ;\n        ;\n            var urls = [], numImgsPreload = Math.min(6, imageUrls.length), storeName = \"books\";\n            for (var i = 0; ((i < numImgsPreload)); i++) {\n                var currPid = ((((pids && pids.length)) ? pids[i] : \"\"));\n                transformUrl(imageUrls[i], currPid);\n            };\n        ;\n            for (var j = 0; ((j < urls.length)); j++) {\n                var img = new JSBNG__Image();\n                img.src = urls[j];\n            };\n        ;\n        };\n        var win = jQuery(window);\n        var feature = jQuery(\"#purchaseShvl\");\n        var shvlPresent = ((((feature.length > 0)) ? 1 : 0));\n        var lastCheck = 0;\n        var pending = 0;\n        var onScrollPrecache = function() {\n            if (pending) {\n                return;\n            }\n        ;\n        ;\n            var lastCheckDiff = ((new JSBNG__Date().getTime() - lastCheck));\n            var checkDelay = ((((lastCheckDiff < 200)) ? ((200 - lastCheckDiff)) : 10));\n            pending = 1;\n            var u = function() {\n                if (((shvlPresent && ((((win.scrollTop() + win.height())) > ((feature.offset().JSBNG__top + 200))))))) {\n                    var p = precacheDetailImages, $ = jQuery;\n                    if (p) {\n                        var selector = \"#purchaseButtonWrapper\";\n                        var imgElems = $(selector).JSBNG__find(\"a \\u003E div \\u003E img\");\n                        var pgs, imgs = [], i = imgElems.length;\n                        while (((i-- > 0))) {\n                            imgs[i] = $(imgElems[i]).attr(\"src\");\n                        };\n                    ;\n                        p(imgs, pgs);\n                    }\n                ;\n                ;\n                    $(window).unbind(\"JSBNG__scroll\", onScrollPrecache);\n                    return;\n                }\n            ;\n            ;\n                pending = 0;\n                lastCheck = new JSBNG__Date().getTime();\n            };\n            JSBNG__setTimeout(u, checkDelay);\n            return;\n        };\n        jQuery(window).bind(\"JSBNG__scroll\", onScrollPrecache);\n    });\n}\n;\n;");
// 1128
geval("amznJQ.onCompletion(\"amznJQ.criticalFeature\", function() {\n    amznJQ.available(\"search-js-jq\", function() {\n    \n    });\n    amznJQ.available(\"amazonShoveler\", function() {\n    \n    });\n    amznJQ.available(\"simsJS\", function() {\n    \n    });\n    amznJQ.available(\"cmuAnnotations\", function() {\n    \n    });\n    amznJQ.available(\"externalJS.tagging\", function() {\n    \n    });\n    amznJQ.available(\"amzn-ratings-bar\", function() {\n    \n    });\n    amznJQ.available(\"accessoriesJS\", function() {\n    \n    });\n    amznJQ.available(\"priceformatterJS\", function() {\n    \n    });\n    amznJQ.available(\"CustomerPopover\", function() {\n    \n    });\n    if (!window.DPClientLogger) {\n        window.DPClientLogger = {\n        };\n    }\n;\n;\n    window.DPClientLogger.ImpressionLogger = function(program_group, feature, forceUpload, controlledLogging) {\n        var JSBNG__self = this, data = {\n        };\n        var isBooksUdploggingDisabled = false;\n        var enableNewCSMs = false;\n        var newCSMs = [\"ma-books-image-ftb-shown\",\"ma-books-image-listen-shown\",];\n        JSBNG__self.logImpression = function(key) {\n            if (!((((isBooksUdploggingDisabled && ((controlledLogging !== undefined)))) && controlledLogging))) {\n                var isNewCSM = JSBNG__self.isKeyNewCSM(key);\n                if (((!isNewCSM || ((isNewCSM && enableNewCSMs))))) {\n                    data[key] = 1;\n                    JSBNG__setTimeout(JSBNG__self.upload, 2000);\n                }\n            ;\n            ;\n            }\n        ;\n        ;\n        };\n        JSBNG__self.isKeyNewCSM = function(key) {\n            var isNewCSM = false;\n            jQuery.each(newCSMs, function(index, csm) {\n                if (((csm == key))) {\n                    isNewCSM = true;\n                }\n            ;\n            ;\n            });\n            return isNewCSM;\n        };\n        JSBNG__self.upload = function() {\n            var t = [];\n            jQuery.each(data, function(k, v) {\n                t.push(k);\n            });\n            data = {\n            };\n            if (((t.length > 0))) {\n                var protocol = ((((JSBNG__location.protocol == \"https:\")) ? \"http://jsbngssl.\" : \"http://\")), url = ((((((((((((((((((((((((((((((protocol + ue.furl)) + \"/1/action-impressions/1/OP/\")) + program_group)) + \"/action/\")) + feature)) + \":\")) + t.join())) + \"?marketplaceId=\")) + ue.mid)) + \"&requestId=\")) + ue.rid)) + \"&session=\")) + ue.sid)) + \"&_=\")) + (new JSBNG__Date()).getTime()));\n                (new JSBNG__Image()).src = url;\n            }\n        ;\n        ;\n        };\n        if (forceUpload) {\n            jQuery(window).unload(function() {\n                JSBNG__self.upload();\n            });\n        }\n    ;\n    ;\n    };\n    amznJQ.onReady(\"jQuery\", function() {\n        amznJQ.declareAvailable(\"DPClientLogger\");\n    });\n});");
// 1129
geval("window.$Nav.declare(\"config.prefetchUrls\", [\"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/cartPerformanceJS/cartPerformanceJS-2638627971._V1_.js\",\"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/cartWithAjaxJS/cartWithAjaxJS-2993276290._V1_.js\",\"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/fruitCSS/US-combined-745644715._V1_.css\",\"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/registriesCSS/US-combined-545184966._V376148880_.css\",\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/browser-scripts/site-wide-js-1.2.6-beacon/site-wide-6717236952._V1_.js\",\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/browser-scripts/us-site-wide-css-beacon/site-wide-7538592147._V1_.css\",\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/browser-scripts/wcs-ya-homepage-beaconized/wcs-ya-homepage-beaconized-1899362992._V1_.css\",\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/browser-scripts/wcs-ya-homepage-beaconized/wcs-ya-homepage-beaconized-3515399030._V1_.js\",\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/browser-scripts/wcs-ya-order-history-beaconized/wcs-ya-order-history-beaconized-2777963369._V1_.css\",\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/gno/beacon/BeaconSprite-US-01._V397411194_.png\",\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/gno/images/general/navAmazonLogoFooter._V169459313_.gif\",\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/x-locale/common/transparent-pixel._V386942464_.gif\",\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/x-locale/communities/social/snwicons_v2._V369764580_.png\",\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/x-locale/cs/css/images/amznbtn-sprite03._V387356454_.png\",\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/x-locale/cs/help/images/spotlight/kindle-family-02b._V386370244_.jpg\",\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/x-locale/cs/orders/images/acorn._V192250692_.gif\",\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/x-locale/cs/orders/images/amazon-gc-100._V192250695_.gif\",\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/x-locale/cs/orders/images/amazon-gcs-100._V192250695_.gif\",\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/x-locale/cs/orders/images/btn-close._V192250694_.gif\",\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/x-locale/cs/projects/text-trace/texttrace_typ._V381285749_.js\",\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/x-locale/cs/ya/images/new-link._V192250664_.gif\",\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/x-locale/cs/ya/images/shipment_large_lt._V192250661_.gif\",]);\n_navbar = ((window._navbar || {\n}));\n_navbar.prefetch = function() {\n    ((window.amznJQ && amznJQ.addPL(window.$Nav.getNow(\"config.prefetchUrls\"))));\n};\n((window.$Nav && $Nav.declare(\"config.prefetch\", _navbar.prefetch)));\n((window.$Nav && $Nav.declare(\"config.flyoutURL\", null)));\n((window.$Nav && $Nav.declare(\"btf.lite\")));\n((window.amznJQ && amznJQ.declareAvailable(\"navbarBTFLite\")));\n((window.$Nav && $Nav.declare(\"btf.full\")));\n((window.amznJQ && amznJQ.declareAvailable(\"navbarBTF\")));");
// 1130
geval("function e76dabe2668f4cf49ebf793312d726a1eebe100c3(JSBNG__event) {\n    if (((typeof (SitbReader) != \"undefined\"))) {\n        SitbReader.LightboxActions.openReaderToPage(1, null, \"sib_dp_pop_fc\");\n        return false;\n    }\n;\n;\n};\n;");
// 1131
geval("function eff9229b2d4edb1f4b67407a640f4e963003eab51(JSBNG__event) {\n    if (((typeof (SitbReader) != \"undefined\"))) {\n        SitbReader.LightboxActions.openReaderToPage(8, null, \"sib_dp_pop_toc\");\n        return false;\n    }\n;\n;\n};\n;");
// 1132
geval("function e9369a0f998218e4493b73926085f4686e07ede30(JSBNG__event) {\n    if (((typeof (SitbReader) != \"undefined\"))) {\n        SitbReader.LightboxActions.openReaderToPage(16, null, \"sib_dp_pop_ex\");\n        return false;\n    }\n;\n;\n};\n;");
// 1133
geval("function e851c1b8803626b18639620cdd9b85faf9c1ebeee(JSBNG__event) {\n    if (((typeof (SitbReader) != \"undefined\"))) {\n        SitbReader.LightboxActions.openReaderToPage(162, null, \"sib_dp_pop_idx\");\n        return false;\n    }\n;\n;\n};\n;");
// 1134
geval("function e3e7d37a4e855872882efc4881beca60ba2d03b00(JSBNG__event) {\n    if (((typeof (SitbReader) != \"undefined\"))) {\n        SitbReader.LightboxActions.openReaderToPage(172, null, \"sib_dp_pop_bc\");\n        return false;\n    }\n;\n;\n};\n;");
// 1135
geval("function ec863300133aa6011cfcc1f65ef434454371a28e6(JSBNG__event) {\n    if (((typeof (SitbReader) != \"undefined\"))) {\n        SitbReader.LightboxActions.openReaderToRandomPage(\"sib_dp_pop_sup\");\n        return false;\n    }\n;\n;\n};\n;");
// 1136
geval("function e7ae6c5ab602f3d72eb1f69f8693640670979d79e(JSBNG__event) {\n    if (((typeof (SitbReader) != \"undefined\"))) {\n        SitbReader.LightboxActions.openReaderToSearchResults(jQuery(\"#sitb-pop-inputbox\").val(), \"sib_dp_srch_pop\");\n        return false;\n    }\n;\n;\n};\n;");
// 1137
geval("function sitb_doHide() {\n    return false;\n};\n;\nfunction sitb_showLayer() {\n    return false;\n};\n;\namznJQ.available(\"popover\", function() {\n    jQuery(\"div#main-image-wrapper\").amazonPopoverTrigger({\n        localContent: \"#sitb-pop\",\n        showOnHover: true,\n        showCloseButton: false,\n        hoverShowDelay: 500,\n        hoverHideDelay: 300,\n        width: 370,\n        JSBNG__location: \"left\",\n        locationOffset: [400,60,]\n    });\n});");
// 1138
geval("function edc466aa40098975636268f9a704e954c14de096b(JSBNG__event) {\n    return amz_js_PopWin(this.href, \"AmazonHelp\", \"width=450,height=450,resizable=1,scrollbars=1,toolbar=1,status=1\");\n};\n;");
// 1139
geval("function ef273fea9bd0c548ed82660486292f8f524162e6e(JSBNG__event) {\n    showSLF();\n};\n;");
// 1140
geval("amznJQ.available(\"jQuery\", function() {\n    var obj = [{\n        provider: \"g\",\n        description: \"Buy \\u003Cb\\u003EJavascript The Good Parts\\u003C/b\\u003E eBook. Interactive Books for iPad and Web.\",\n        title: \"\\u003Cb\\u003EJavascript The Good Parts\\u003C/b\\u003E\",\n        redirectUrl: \"http://rd.a9.com/srv/redirect/?info=AJBbntgaL8LB8EjK-Bgx1hC0HXw9acx2NpTqDohBGTfSA0lyU607NPLF6i9mDEGNtpT3wXpr3mdUReAX2bP2gkKiyULqGMiam2hM9l0cYJram2JqLT-C7rFGqIXERJ0sEffQSdCQb3XFq3siou9XmWfs.z9rG7E0wxkl3KFUG6U7oywS3VJufa08YZKLFQRZQjYxFym2Mdtw.L23ZhrlPTecArM7eSd.KDqYW2d-1-ctQf.3GRp1cR5YvX5sG-kM9g44a.1RUXvrnHD0xzG.PBqJpSsaoVWR1wLxJbQ1BFUfHtaQq23tJ2bdz.X67mpa5DqyHSZFu2SzBVPXwDRPqHYnrcSl9iHpj1rz40LsghP7Xxs26tyAfXzw0Wso0SMvhgmLDi1Z7W0C1XuWraguwLm2z9J2pvicFpvrICiOSAT09QUxAaeAvzDCm7BZQ3Q-d2OOzPb17JKC-x16MGZqgpmusUorQFdGBNtFwMo4Hofg9JfnRRObZh.aQLJO9tfrWjj0tNjB-ygqO10bSSK.NHRZ24dH7zY9qTv.jM.wPIVXSaTkpVMV2unDltiQkYmK3HketPS2uDJm83yJ6lCcH0riWX5YgmXNAbnG06cr3Wgu7cLW7sRcI2f8lM5ry6bjABRIgfTsvToS&awt=1&s=\",\n        visibleUrl: \"www.inkling.com/\"\n    },];\n    var adPropertiesDelimiter = \"__\";\n    var adCount = 1;\n    var slDiv = \"SlDiv\";\n    var expectedHeightWide = 34;\n    var expectedHeightMiddle = 56;\n    var reformatType = \"0\";\n    jQuery(window).load(function() {\n        amznJQ.onCompletion(\"amznJQ.criticalFeature\", function() {\n            var divWideName = ((slDiv + \"_0\"));\n            var divMiddleName = ((slDiv + \"_1\"));\n            var heightOfOneAd = ((jQuery(((\"#\" + divWideName))).height() / adCount));\n            if (((heightOfOneAd > expectedHeightWide))) {\n                reformatType = \"1\";\n                var newAdsHtml = ((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((\"\\u003Ctr\\u003E\" + \"    \\u003Ctd\\u003E\")) + \"     \\u003Cdiv class=\\\"SponsoredLinkItemTD\\\"\\u003E\")) + \"         \\u003Cspan class = \\\"SponsoredLinkYellowBlockEnclosureTop\\\"\\u003E\")) + \"             \\u003Cspan class=\\\"SponsoredLinkYellowBlockEnclosure\\\"\\u003E\")) + \"                 \\u003Cspan class=\\\"SponsoredLinkYellowBlock\\\"\\u003E&nbsp;\\u003C/span\\u003E&nbsp;\")) + \"             \\u003C/span\\u003E\")) + \"         \\u003C/span\\u003E&nbsp;&nbsp;\")) + \"     \\u003C/div\\u003E\")) + \"    \\u003C/td\\u003E\")) + \"    \\u003Ctd\\u003E\")) + \"     \\u003Cdiv class=\\\"SponsoredLinkTitle\\\"\\u003E\")) + \"         \\u003Ca target=\\\"_blank\\\" href=\\\"\")) + adPropertiesDelimiter)) + \"redirectUrl\")) + adPropertiesDelimiter)) + \"\\\" rel=\\\"nofollow\\\"\\u003E\\u003Cb\\u003E\")) + adPropertiesDelimiter)) + \"title\")) + adPropertiesDelimiter)) + \"\\u003C/b\\u003E\\u003C/a\\u003E\")) + \"         \\u003Ca target=\\\"_blank\\\" href=\\\"\")) + adPropertiesDelimiter)) + \"redirectUrl\")) + adPropertiesDelimiter)) + \"\\\" rel=\\\"nofollow\\\"\\u003E\\u003Cimg src=\\\"http://g-ecx.images-amazon.com/images/G/01/icons/icon-offsite-sl-7069-t4._V171196157_.png\\\" width=\\\"23\\\" alt=\\\"opens new browser window\\\" align=\\\"absbottom\\\" style=\\\"padding-bottom:0px; margin-bottom:0px;\\\" height=\\\"20\\\" border=\\\"0\\\" /\\u003E\\u003C/a\\u003E\")) + \"     \\u003C/div\\u003E\")) + \"    \\u003C/td\\u003E\")) + \"    \\u003Ctd style=\\\"padding-left: 20px;\\\"\\u003E\")) + \"     \\u003Cdiv class=\\\"SponsoredLinkDescriptionDIV\\\"\\u003E\")) + \"         \\u003Cspan class=\\\"SponsoredLinkDescriptionText\\\"\\u003E\")) + adPropertiesDelimiter)) + \"description\")) + adPropertiesDelimiter)) + \"\\u003C/span\\u003E\")) + \"     \\u003C/div\\u003E\")) + \"    \\u003C/td\\u003E\")) + \"\\u003C/tr\\u003E\")) + \"\\u003Ctr\\u003E\")) + \"     \\u003Ctd\\u003E\")) + \"     \\u003C/td\\u003E\")) + \"     \\u003Ctd\\u003E\")) + \"     \\u003C/td\\u003E\")) + \"    \\u003Ctd style=\\\"padding-left: 20px;\\\"\\u003E\")) + \"     \\u003Cdiv class=\\\"SponsoredLinkDescriptionDIV\\\" style=\\\"padding-top:0px; padding-bottom:10px\\\"\\u003E\")) + \"         \\u003Ca target=\\\"_blank\\\" href=\\\"\")) + adPropertiesDelimiter)) + \"redirectUrl\")) + adPropertiesDelimiter)) + \"\\\" rel=\\\"nofollow\\\" class=\\\"SponsoredLinkDescriptionUrlLink\\\"\\u003E\")) + adPropertiesDelimiter)) + \"visibleUrl\")) + adPropertiesDelimiter)) + \"\\u003C/a\\u003E\")) + \"     \\u003C/div\\u003E\")) + \"    \\u003C/td\\u003E\")) + \"\\u003C/tr\\u003E\"));\n                dumpHtml(obj, newAdsHtml, \"\\u003Cdiv id=\\\"SlDiv_1\\\"\\u003E\\u003Cdiv id=\\\"A9AdsWidgetAdsWrapper\\\"\\u003E\\u003Ctable class=\\\"SponsoredLinkColumnAds\\\"\\u003E  \\u003Ctbody\\u003E \", \"\\u003C/tbody\\u003E \\u003C/table\\u003E \\u003C/div\\u003E\\u003C/div\\u003E\", divWideName);\n                var heightOfOneAd = ((jQuery(((\"#\" + divMiddleName))).height() / adCount));\n                if (((heightOfOneAd > expectedHeightMiddle))) {\n                    reformatType = \"2\";\n                    var newAdsHtml = ((((((((((((((((((((((((((((((((((((((((((((((((\"\\u003Cdiv class=\\\"SponsoredLinkItemTD\\\"\\u003E  \\u003Cspan class=\\\"SponsoredLinkYellowBlockEnclosureTop\\\"\\u003E\\u003Cspan class=\\\"SponsoredLinkYellowBlockEnclosure\\\"\\u003E\\u003Cspan class=\\\"SponsoredLinkYellowBlock\\\"\\u003E&nbsp;\\u003C/span\\u003E&nbsp; \\u003C/span\\u003E\\u003C/span\\u003E&nbsp;&nbsp;\\u003Ca target=\\\"_blank\\\" href=\\\"\" + adPropertiesDelimiter)) + \"redirectUrl\")) + adPropertiesDelimiter)) + \"\\\" rel=\\\"nofollow\\\"\\u003E\\u003Cb\\u003E\")) + adPropertiesDelimiter)) + \"title\")) + adPropertiesDelimiter)) + \"\\u003C/b\\u003E\\u003C/a\\u003E&nbsp;\\u003Ca rel=\\\"nofollow\\\" href=\\\"\")) + adPropertiesDelimiter)) + \"redirectUrl\")) + adPropertiesDelimiter)) + \"\\\" target=\\\"_blank\\\"\\u003E\\u003Cimg src=\\\"http://g-ecx.images-amazon.com/images/G/01/icons/icon-offsite-sl-7069-t4._V171196157_.png\\\" width=\\\"23\\\" alt=\\\"opens new browser window\\\" align=\\\"absbottom\\\" style=\\\"padding-bottom:0px; margin-bottom:0px;\\\" height=\\\"20\\\" border=\\\"0\\\" /\\u003E\\u003C/a\\u003E  \\u003Cdiv class=\\\"SponsoredLinkDescription\\\"\\u003E&nbsp;&nbsp;&nbsp;&nbsp;\\u003Ca target=\\\"_blank\\\" href=\\\"\")) + adPropertiesDelimiter)) + \"redirectUrl\")) + adPropertiesDelimiter)) + \"\\\" rel=\\\"nofollow\\\" class=\\\"SponsoredLinkDescriptionUrlLink\\\"\\u003E\")) + adPropertiesDelimiter)) + \"visibleUrl\")) + adPropertiesDelimiter)) + \"\\u003C/a\\u003E  \\u003C/div\\u003E  \\u003Cdiv class=\\\"SponsoredLinkDescription\\\"\\u003E&nbsp;&nbsp;&nbsp;&nbsp;\\u003Cspan class=\\\"SponsoredLinkDescriptionText\\\"\\u003E\")) + adPropertiesDelimiter)) + \"description\")) + adPropertiesDelimiter)) + \"\\u003C/span\\u003E  \\u003C/div\\u003E \\u003C/div\\u003E\"));\n                    dumpHtml(obj, newAdsHtml, \"\\u003Cdiv id=\\\"SlDiv_2\\\"\\u003E\\u003Cdiv id=\\\"A9AdsWidgetAdsWrapper\\\"\\u003E\", \"\\u003C/div\\u003E\\u003C/div\\u003E\", divMiddleName);\n                }\n            ;\n            ;\n            }\n        ;\n        ;\n            if (((typeof A9_SL_CSM_JS != \"undefined\"))) {\n                A9_SL_CSM_JS(reformatType);\n            }\n        ;\n        ;\n        });\n    });\n    function dumpHtml(obj, newAdsHtml, topHtml, bottomHtml, divParent) {\n        var i = 0;\n        var completeAdsHtml = \"\";\n        {\n            var fin30keys = ((window.top.JSBNG_Replay.forInKeys)((obj))), fin30i = (0);\n            (0);\n            for (; (fin30i < fin30keys.length); (fin30i++)) {\n                ((x) = (fin30keys[fin30i]));\n                {\n                    var adChunks = newAdsHtml.split(adPropertiesDelimiter);\n                    for (var j = 0; ((j < adChunks.length)); j++) {\n                        if (((typeof obj[i][adChunks[j]] != \"undefined\"))) {\n                            adChunks[j] = obj[i][adChunks[j]];\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    completeAdsHtml += adChunks.join(\"\");\n                    i++;\n                };\n            };\n        };\n    ;\n        newAdsHtml = ((((topHtml + completeAdsHtml)) + bottomHtml));\n        jQuery(((\"#\" + divParent))).replaceWith(newAdsHtml);\n    };\n;\n});\nvar jsonAds = \"[{\\\"provider\\\":\\\"g\\\",\\\"description\\\":\\\"Buy \\u003Cb\\u003EJavascript The Good Parts\\u003C/b\\u003E eBook. Interactive Books for iPad and Web.\\\",\\\"title\\\":\\\"\\u003Cb\\u003EJavascript The Good Parts\\u003C/b\\u003E\\\",\\\"redirectUrl\\\":\\\"http://rd.a9.com/srv/redirect/?info=AJBbntgaL8LB8EjK-Bgx1hC0HXw9acx2NpTqDohBGTfSA0lyU607NPLF6i9mDEGNtpT3wXpr3mdUReAX2bP2gkKiyULqGMiam2hM9l0cYJram2JqLT-C7rFGqIXERJ0sEffQSdCQb3XFq3siou9XmWfs.z9rG7E0wxkl3KFUG6U7oywS3VJufa08YZKLFQRZQjYxFym2Mdtw.L23ZhrlPTecArM7eSd.KDqYW2d-1-ctQf.3GRp1cR5YvX5sG-kM9g44a.1RUXvrnHD0xzG.PBqJpSsaoVWR1wLxJbQ1BFUfHtaQq23tJ2bdz.X67mpa5DqyHSZFu2SzBVPXwDRPqHYnrcSl9iHpj1rz40LsghP7Xxs26tyAfXzw0Wso0SMvhgmLDi1Z7W0C1XuWraguwLm2z9J2pvicFpvrICiOSAT09QUxAaeAvzDCm7BZQ3Q-d2OOzPb17JKC-x16MGZqgpmusUorQFdGBNtFwMo4Hofg9JfnRRObZh.aQLJO9tfrWjj0tNjB-ygqO10bSSK.NHRZ24dH7zY9qTv.jM.wPIVXSaTkpVMV2unDltiQkYmK3HketPS2uDJm83yJ6lCcH0riWX5YgmXNAbnG06cr3Wgu7cLW7sRcI2f8lM5ry6bjABRIgfTsvToS&awt=1&s=\\\",\\\"visibleUrl\\\":\\\"www.inkling.com/\\\"}]\";\nfunction enableFeedbackLinkDiv() {\n    amznJQ.onReady(\"jQuery\", function() {\n        jQuery(\"#ShowFeedbackLinkDiv\").show();\n    });\n};\n;\nenableFeedbackLinkDiv();\nvar flag = 1;\nfunction showSLF() {\n    if (((flag == 1))) {\n        jQuery.post(\"/gp/product/handler.html\", {\n            sid: \"181-0531756-0630505\",\n            jsonAds: escape(jsonAds)\n        }, function(data) {\n            jQuery(\"#FeedbackFormDiv\").html(data);\n            jQuery(\"#FeedbackFormDiv\").show();\n            jQuery(\"#ShowFeedbackLinkDiv\").hide();\n            jQuery(\"#ResponseFeedbackLinkDiv\").hide();\n            flag = 0;\n        });\n    }\n     else {\n        jQuery(\"#reports-ads-abuse-form\").show();\n        jQuery(\"#FeedbackFormDiv\").show();\n        jQuery(\"#reports-ads-abuse\").show();\n        jQuery(\"#ShowFeedbackLinkDiv\").hide();\n        jQuery(\"#ResponseFeedbackLinkDiv\").hide();\n    }\n;\n;\n};\n;");
// 1141
geval("function e13fbcc1f568b8658ba3f967bbb8a14840005bee6(JSBNG__event) {\n    return false;\n};\n;");
// 1142
geval("function ef637c67f4b296eca5360ede702b66f24c27b1df4(JSBNG__event) {\n    return false;\n};\n;");
// 1143
geval("function edc30fe17fe8c092c8a9938e07c17773e94b5879c(JSBNG__event) {\n    return false;\n};\n;");
// 1144
geval("function e4e0d52214ee690e5ea9d0d504ebdacca9b5a22de(JSBNG__event) {\n    amznJQ.available(\"jQuery\", function() {\n        window.AMZN_LIKE_SUBMIT = true;\n    });\n    return false;\n};\n;");
// 1145
geval("amznJQ.onCompletion(\"amznJQ.criticalFeature\", function() {\n    amznJQ.available(\"amazonLike\", function() {\n        var stateCache = new AmazonLikeStateCache(\"amznLikeStateCache_18105317560630505_dp_asin_0596517742\");\n        stateCache.init();\n        stateCache.ready(function() {\n            if (((stateCache.getTimestamp() < 1374695826))) {\n                stateCache.set(\"isLiked\", ((jQuery(\"#amznLikeStateCache_18105317560630505_dp_asin_0596517742_isLiked\").text() == \"true\")));\n                stateCache.set(\"customerWhitelistStatus\", parseInt(jQuery(\"#amznLikeStateCache_18105317560630505_dp_asin_0596517742_customerWhitelistStatus\").text()));\n                stateCache.set(\"likeCount\", parseInt(jQuery(\"#amznLikeStateCache_18105317560630505_dp_asin_0596517742_likeCount\").text()));\n                stateCache.set(\"commifiedLikeCount\", jQuery(\"#amznLikeStateCache_18105317560630505_dp_asin_0596517742_commifiedLikeCount\").text());\n                stateCache.set(\"commifiedLikeCountMinusOne\", jQuery(\"#amznLikeStateCache_18105317560630505_dp_asin_0596517742_commifiedLikeCountMinusOne\").text());\n                stateCache.set(\"ts\", \"1374695826\");\n            }\n        ;\n        ;\n            if (!window.amznLikeStateCache) {\n                window.amznLikeStateCache = {\n                };\n            }\n        ;\n        ;\n            window.amznLikeStateCache[\"amznLikeStateCache_18105317560630505_dp_asin_0596517742\"] = stateCache;\n        });\n        var amznLikeDiv = jQuery(\"#amznLike_0596517742\");\n        var stateCache = window.amznLikeStateCache[\"amznLikeStateCache_18105317560630505_dp_asin_0596517742\"];\n        amznLikeDiv.remove();\n        var amznLike;\n        amznLike = amznLikeDiv.amazonLike({\n            context: \"dp\",\n            itemId: \"0596517742\",\n            itemType: \"asin\",\n            isLiked: stateCache.get(\"isLiked\"),\n            customerWhitelistStatus: stateCache.get(\"customerWhitelistStatus\"),\n            isCustomerSignedIn: false,\n            isOnHover: false,\n            isPressed: false,\n            popoverWidth: 335,\n            popoverAlign: \"right\",\n            popoverOffset: 0,\n            sessionId: \"181-0531756-0630505\",\n            likeCount: stateCache.get(\"likeCount\"),\n            commifiedLikeCount: stateCache.get(\"commifiedLikeCount\"),\n            commifiedLikeCountMinusOne: stateCache.get(\"commifiedLikeCountMinusOne\"),\n            isSignInRedirect: false,\n            shareText: \"Share this item\",\n            onBeforeAttachPopoverCallback: function() {\n                jQuery(\"#likeAndShareBar\").append(amznLikeDiv).show();\n            },\n            spriteURL: \"http://g-ecx.images-amazon.com/images/G/01/x-locale/personalization/amznlike/amznlike_sprite_02._V196113939_.gif\",\n            buttonOnClass: \"JSBNG__on\",\n            buttonOffClass: \"off\",\n            buttonPressedClass: \"pressed\",\n            popoverHTML: ((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((\"\\u003Cdiv id=\" + \"\\\"\")) + \"amazonLikePopoverWrapper_0596517742\")) + \"\\\"\")) + \" class=\")) + \"\\\"\")) + \"amazonLikePopoverWrapper amazonLikeContext_dp\")) + \"\\\"\")) + \" \\u003E\")) + String.fromCharCode(13))) + \"\\u003Cdiv class=\")) + \"\\\"\")) + \"amazonLikeBeak \")) + \"\\\"\")) + \"\\u003E&nbsp;\\u003C/div\\u003E    \\u003Cdiv class=\")) + \"\\\"\")) + \"amazonLikePopover\")) + \"\\\"\")) + \"\\u003E\")) + String.fromCharCode(13))) + \"\\u003Cdiv class=\")) + \"\\\"\")) + \"likePopoverError\")) + \"\\\"\")) + \" style=\")) + \"\\\"\")) + \"display: none;\")) + \"\\\"\")) + \"\\u003E\")) + String.fromCharCode(13))) + \"\\u003Cspan class=\")) + \"\\\"\")) + \"error\")) + \"\\\"\")) + \" style=\")) + \"\\\"\")) + \"color: #900;\")) + \"\\\"\")) + \"\\u003E\\u003Cstrong\\u003EAn error has occurred. Please try your request again.\\u003C/strong\\u003E\\u003C/span\\u003E\")) + String.fromCharCode(13))) + \"\\u003C/div\\u003E\")) + String.fromCharCode(13))) + \"\\u003Cdiv class=\")) + \"\\\"\")) + \"likeOffPopoverContent\")) + \"\\\"\")) + \" \\u003E\")) + String.fromCharCode(13))) + \"\\u003Cdiv\\u003E\")) + String.fromCharCode(13))) + \"\\u003Cdiv class=\")) + \"\\\"\")) + \"likeCountText likeCountLoadingIndicator\")) + \"\\\"\")) + \" style=\")) + \"\\\"\")) + \"display: none;\")) + \"\\\"\")) + \"\\u003E\\u003Cimg src=\")) + \"\\\"\")) + \"http://g-ecx.images-amazon.com/images/G/01/javascripts/lib/popover/images/snake._V192571611_.gif\")) + \"\\\"\")) + \" width=\")) + \"\\\"\")) + \"16\")) + \"\\\"\")) + \" alt=\")) + \"\\\"\")) + \"Loading\")) + \"\\\"\")) + \" height=\")) + \"\\\"\")) + \"16\")) + \"\\\"\")) + \" border=\")) + \"\\\"\")) + \"0\")) + \"\\\"\")) + \" /\\u003E\\u003C/div\\u003E\")) + String.fromCharCode(13))) + \"\\u003Cspan style=\")) + \"\\\"\")) + \"font-weight: bold;\")) + \"\\\"\")) + \"\\u003E\\u003Ca class=\")) + \"\\\"\")) + \"likeSignInLink\")) + \"\\\"\")) + \" href=\")) + \"\\\"\")) + \"/gp/like/sign-in/sign-in.html/ref=pd_like_unrec_signin_nojs_dp?ie=UTF8&isRedirect=1&location=%2Fgp%2Flike%2Fexternal%2Fsubmit.html%2Fref%3Dpd_like_submit_like_unrec_nojs_dp%3Fie%3DUTF8%26action%3Dlike%26context%3Ddp%26itemId%3D0596517742%26itemType%3Dasin%26redirect%3D1%26redirectPath%3D%252Fgp%252Fproduct%252F0596517742%253Fref%25255F%253Dsr%25255F1%25255F1%2526s%253Dbooks%2526qid%253D1374695818%2526sr%253D1-1%2526keywords%253Djavascript%252520the%252520good%252520parts&useRedirectOnSuccess=1\")) + \"\\\"\")) + \"\\u003ESign in to like this\\u003C/a\\u003E.\\u003C/span\\u003E\")) + String.fromCharCode(13))) + \"\\u003C/div\\u003E\")) + String.fromCharCode(13))) + \"\\u003Cdiv class=\")) + \"\\\"\")) + \"spacer\")) + \"\\\"\")) + \"\\u003ETelling us what you like can improve your shopping experience. \\u003Ca class=\")) + \"\\\"\")) + \"grayLink\")) + \"\\\"\")) + \" href=\")) + \"\\\"\")) + \"/gp/help/customer/display.html/ref=pd_like_help_dp?ie=UTF8&nodeId=13316081#like\")) + \"\\\"\")) + \"\\u003ELearn more\\u003C/a\\u003E\\u003C/div\\u003E\")) + String.fromCharCode(13))) + \"\\u003C/div\\u003E\")) + String.fromCharCode(13))) + \"\\u003C/div\\u003E\")) + String.fromCharCode(13))) + \"\\u003C/div\\u003E\")),\n            stateCache: stateCache\n        });\n        if (window.AMZN_LIKE_SUBMIT) {\n            amznLike.onLike();\n        }\n    ;\n    ;\n    });\n});");
// 1146
geval("amznJQ.onReady(\"lazyLoadLib\", function() {\n    jQuery(\"#customer_discussions_lazy_load_div\").lazyLoadContent({\n        threshold: 400,\n        url: \"/gp/rcxll/dpview/0596517742?ie=UTF8&enableDiscussionsRelatedForums=1&keywords=javascript%20the%20good%20parts&qid=1374695818&ref_=sr_1_1&s=books&sr=1-1&vi=custdiscuss\",\n        metrics: true,\n        JSBNG__name: \"customer_discussions\",\n        cache: true\n    });\n});");
// 1147
geval("amznJQ.onReady(\"lazyLoadLib\", function() {\n    jQuery(\"#dp_bottom_lazy_lazy_load_div\").lazyLoadContent({\n        threshold: 1200,\n        url: \"/gp/rcxll/dpview/0596517742?ie=UTF8&keywords=javascript%20the%20good%20parts&qid=1374695818&ref_=sr_1_1&s=books&sr=1-1&vi=zbottest\",\n        metrics: true,\n        JSBNG__name: \"dp_bottom_lazy\",\n        cache: true\n    });\n});");
// 1148
geval("amznJQ.onReady(\"popover\", function() {\n    jQuery(\"#ns_0JNNCCYK0E23P11J4NSE_130_1_hmd_pricing_feedback_trigger_hmd\").amazonPopoverTrigger({\n        title: \"Tell Us About a Lower Price\",\n        destination: \"/gp/pdp/pf/pricingFeedbackForm.html/ref=sr_1_1_pfhmd?ie=UTF8&ASIN=0596517742&PREFIX=ns_0JNNCCYK0E23P11J4NSE_130_2_&from=hmd&keywords=javascript%20the%20good%20parts&originalURI=%2Fgp%2Fproduct%2F0596517742&qid=1374695818&s=books&sr=1-1&storeID=books\",\n        showOnHover: false,\n        draggable: true\n    });\n});");
// 1149
geval("window.rhf_use_AUI = ((((0 && ((typeof (P) === \"object\")))) && ((typeof (P.when) === \"function\"))));\nvar rhfShovelerBootstrapFunction = function($) {\n    (function($) {\n        window.RECS_rhfShvlLoading = false;\n        window.RECS_rhfShvlLoaded = false;\n        window.RECS_rhfInView = false;\n        window.RECS_rhfMetrics = {\n        };\n        $(\"#rhf_container\").show();\n        var rhfShvlEventHandler = function() {\n            if (((((!window.RECS_rhfShvlLoaded && !window.RECS_rhfShvlLoading)) && (($(\"#rhf_container\").size() > 0))))) {\n                var yPosition = (($(window).scrollTop() + $(window).height()));\n                var rhfElementFound = $(\"#rhfMainHeading\").size();\n                var rhfPosition = $(\"#rhfMainHeading\").offset().JSBNG__top;\n                if (/webkit.*mobile/i.test(JSBNG__navigator.userAgent)) {\n                    rhfPosition -= $(window).scrollTop();\n                }\n            ;\n            ;\n                if (((rhfElementFound && ((((rhfPosition - yPosition)) < 400))))) {\n                    window.RECS_rhfMetrics[\"start\"] = (new JSBNG__Date()).getTime();\n                    window.RECS_rhfShvlLoading = true;\n                    var handleSuccess = function(html) {\n                        $(\"#rhf_container\").html(html);\n                        $(\"#rhf0Shvl\").trigger(\"render-shoveler\");\n                        window.RECS_rhfShvlLoaded = true;\n                        window.RECS_rhfMetrics[\"loaded\"] = (new JSBNG__Date()).getTime();\n                    };\n                    var handleError = function() {\n                        $(\"#rhf_container\").hide();\n                        $(\"#rhf_error\").show();\n                        window.RECS_rhfMetrics[\"loaded\"] = \"error\";\n                    };\n                    var ajaxURL = \"/gp/history/external/full-rhf-rec-handler.html\";\n                    var ajaxArgs = {\n                        type: \"POST\",\n                        timeout: 10000,\n                        data: {\n                            shovelerName: \"rhf0\",\n                            key: \"rhf\",\n                            numToPreload: \"8\",\n                            isGateway: 0,\n                            refTag: \"pd_rhf_dp\",\n                            parentSession: \"181-0531756-0630505\",\n                            relatedRequestId: \"0JNNCCYK0E23P11J4NSE\",\n                            excludeASIN: \"0596517742\",\n                            renderPopover: 0,\n                            forceSprites: 1,\n                            currentPageType: \"Detail\",\n                            currentSubPageType: \"Glance\",\n                            searchAlias: \"\",\n                            keywords: \"amF2YXNjcmlwdCB0aGUgZ29vZCBwYXJ0cw==\",\n                            node: \"\",\n                            ASIN: \"0596517742\",\n                            searchResults: \"\",\n                            isAUI: 0\n                        },\n                        dataType: \"json\",\n                        success: function(data, JSBNG__status) {\n                            if (((((((typeof (data) === \"object\")) && data.success)) && data.html))) {\n                                handleSuccess(data.html);\n                                if (window.rhf_use_AUI) {\n                                    P.when(\"jQuery\", \"a-carousel-framework\").execute(function(jQuery, framework) {\n                                        jQuery(\"#rhf_upsell_div .a-carousel-viewport\").addClass(\"a-carousel-slide\");\n                                        framework.createAll();\n                                    });\n                                }\n                            ;\n                            ;\n                            }\n                             else {\n                                handleError();\n                            }\n                        ;\n                        ;\n                        },\n                        error: function(xhr, JSBNG__status) {\n                            handleError();\n                        }\n                    };\n                    if (window.rhf_use_AUI) {\n                        P.when(\"A\").execute(function(A) {\n                            A.$.ajax(ajaxURL, ajaxArgs);\n                        });\n                    }\n                     else {\n                        ajaxArgs[\"url\"] = ajaxURL;\n                        $.ajax(ajaxArgs);\n                    }\n                ;\n                ;\n                }\n            ;\n            ;\n            }\n        ;\n        ;\n        };\n        var rhfInView = function() {\n            if (((!window.RECS_rhfInView && (($(\"#rhf_container\").size() > 0))))) {\n                var yPosition = (($(window).scrollTop() + $(window).height()));\n                var rhfElementFound = (($(\"#rhfMainHeading\").size() > 0));\n                var rhfPosition = $(\"#rhfMainHeading\").offset().JSBNG__top;\n                if (/webkit.*mobile/i.test(JSBNG__navigator.userAgent)) {\n                    rhfPosition -= $(window).scrollTop();\n                }\n            ;\n            ;\n                if (((rhfElementFound && ((((rhfPosition - yPosition)) < 0))))) {\n                    window.RECS_rhfInView = true;\n                    window.RECS_rhfMetrics[\"inView\"] = (new JSBNG__Date()).getTime();\n                }\n            ;\n            ;\n            }\n        ;\n        ;\n        };\n        window.rhfYBHTurnOn = function() {\n            $.ajax({\n                url: \"/gp/history/external/full-rhf-ybh-on-handler.html\",\n                type: \"POST\",\n                timeout: 2000,\n                data: {\n                    parentSession: \"181-0531756-0630505\"\n                },\n                dataType: \"text\",\n                success: function(data, JSBNG__status) {\n                    $(\"#yourBrowsingHistoryOnText\").JSBNG__find(\"p\").html(\"You don't have any recently viewed Items.\");\n                    $(\"#rhf-ybh-turn-on-link\").hide();\n                }\n            });\n        };\n        $(JSBNG__document).ready(rhfShvlEventHandler);\n        $(window).JSBNG__scroll(rhfShvlEventHandler);\n        $(JSBNG__document).ready(rhfInView);\n        $(window).JSBNG__scroll(rhfInView);\n    })($);\n};\nif (window.rhf_use_AUI) {\n    P.when(\"jQuery\", \"ready\").register(\"rhf-bootstrapper\", function($) {\n        return {\n            bootstrap: function() {\n                return rhfShovelerBootstrapFunction($);\n            }\n        };\n    });\n    P.when(\"rhf-bootstrapper\").execute(function(rhfBootstrapper) {\n        rhfBootstrapper.bootstrap();\n    });\n}\n else {\n    amznJQ.onReady(\"jQuery\", function() {\n        rhfShovelerBootstrapFunction(jQuery);\n    });\n}\n;\n;");
// 1151
ow876774570.JSBNG__attachEvent = undefined;
// 1152
f876774570_7.returns.push(undefined);
// 1150
geval("(function(a, b) {\n    ((a.JSBNG__attachEvent ? a.JSBNG__attachEvent(\"JSBNG__onload\", b) : ((a.JSBNG__addEventListener && a.JSBNG__addEventListener(\"load\", b, !1)))));\n})(window, ((window.top.JSBNG_Replay.push)((window.top.JSBNG_Replay.s62d148c5af61b0a7d54ea938e5a6a16cd1eee833_1), function() {\n    JSBNG__setTimeout(((window.top.JSBNG_Replay.push)((window.top.JSBNG_Replay.s62d148c5af61b0a7d54ea938e5a6a16cd1eee833_2), function() {\n        var el = JSBNG__document.getElementById(\"sis_pixel_r2\");\n        ((el && (el.innerHTML = \"\\u003Cdiv id=\\\"DAsis\\\" src=\\\"//s.amazon-adsystem.com/iu3?d=amazon.com&slot=navFooter&a2=010153ef443946f72efb7312482c8317a3886d5f75c7bac800f1cdf53faaa2fa18c5&old_oo=0&cb=1374695826667\\\" width=\\\"1\\\" height=\\\"1\\\" frameborder=\\\"0\\\" marginwidth=\\\"0\\\" marginheight=\\\"0\\\" scrolling=\\\"no\\\"\\u003E\\u003C/div\\u003E\")));\n    })), 300);\n})));");
// 1153
geval("amznJQ.onReady(\"jQuery\", function() {\n    var elmMH = jQuery(\"#revMHLContainer\");\n    var elmMR = jQuery(\"#revMRLContainer\");\n    if (((!elmMH || !elmMR))) {\n        return;\n    }\n;\n;\n    if (((elmMH.height() && elmMR.height()))) {\n        var pxHeightDiff = ((elmMH.height() - elmMR.height()));\n        var metricNameStr = \"dpReviewsColumnHeightDiffC\";\n        if (((pxHeightDiff < 0))) {\n            pxHeightDiff = -pxHeightDiff;\n            metricNameStr += \"Positive\";\n        }\n         else {\n            metricNameStr += \"Negative\";\n        }\n    ;\n    ;\n        var ajaxRequestData = {\n        };\n        ajaxRequestData[metricNameStr] = pxHeightDiff;\n        JSBNG__setTimeout(function() {\n            jQuery.ajax({\n                type: \"POST\",\n                dataType: \"json\",\n                ajaxTimeout: 10000,\n                url: \"/gp/customer-reviews/aj/metrics/log-values\",\n                data: ajaxRequestData\n            });\n        }, 5000);\n    }\n;\n;\n});\namznJQ.onReady(\"jQuery\", function() {\n    jQuery(\".MHRExpandLink\").click(function(JSBNG__event) {\n        JSBNG__event.preventDefault();\n        jQuery(this).hide();\n        var parent = jQuery(this).parent();\n        var fullText = ((parent.JSBNG__find(\".MHRHead\").html() + parent.JSBNG__find(\".MHRRest\").html()));\n        var pxInitialSize = parent.height();\n        parent.html(fullText);\n        var pxTargetSize = parent.height();\n        parent.height(pxInitialSize);\n        parent.animate({\n            height: ((pxTargetSize + \"px\"))\n        });\n    });\n});\namznJQ.onReady(\"jQuery\", function() {\n    var voteAjaxDefaultBeforeSendReviews = function(buttonAnchor, buttonContainer, messageContainer) {\n        messageContainer.html(\"Sending feedback...\");\n        buttonContainer.hide();\n        messageContainer.show();\n    };\n    var voteAjaxDefaultSuccessReviews = function(aData, aStatus, buttonAnchor, buttonContainer, messageContainer, isNoButton, inappUrl) {\n        if (((aData.redirect == 1))) {\n            return window.JSBNG__location.href = buttonAnchor.children[0].href;\n        }\n    ;\n    ;\n        if (((aData.error == 1))) {\n            jQuery(buttonContainer.children()[0]).html(\"Sorry, we failed to record your vote. Please try again\");\n            messageContainer.hide();\n            buttonContainer.show();\n        }\n         else {\n            messageContainer.html(\"Thank you for your feedback.\");\n            if (((isNoButton == 1))) {\n                messageContainer.append(\"\\u003Cspan class=\\\"black gl5\\\"\\u003EIf this review is inappropriate, \\u003Ca href=\\\"http://www.amazon.com/gp/voting/cast/Reviews/2115/RNX5PEPWHPSHW/Inappropriate/1/ref=cm_cr_dp_abuse_voteyn?ie=UTF8&target=&token=409B6DB523596D5F2153DA97CA708E86A718A46B&voteAnchorName=RNX5PEPWHPSHW.2115.Inappropriate.Reviews&voteSessionID=181-0531756-0630505\\\" class=\\\"noTextDecoration\\\" style=\\\"color: #039;\\\" \\u003Eplease let us know.\\u003C/a\\u003E\\u003C/span\\u003E\");\n                messageContainer.JSBNG__find(\"a\").attr(\"href\", inappUrl);\n            }\n        ;\n        ;\n            messageContainer.addClass(\"green\");\n        }\n    ;\n    ;\n    };\n    var voteAjaxDefaultErrorReviews = function(aStatus, aError, buttonAnchor, buttonContainer, messageContainer) {\n        jQuery(buttonContainer.children()[0]).html(\"Sorry, we failed to record your vote. Please try again\");\n        messageContainer.hide();\n        buttonContainer.show();\n    };\n    jQuery(\".votingButtonReviews\").each(function() {\n        jQuery(this).unbind(\"click.vote.Reviews\");\n        jQuery(this).bind(\"click.vote.Reviews\", function() {\n            var buttonAnchor = this;\n            var buttonContainer = jQuery(this).parent();\n            var messageContainer = jQuery(buttonContainer).next(\".votingMessage\");\n            var inappUrl = messageContainer.children()[0].href;\n            var isNoButton = jQuery(this).hasClass(\"noButton\");\n            jQuery.ajax({\n                type: \"GET\",\n                dataType: \"json\",\n                ajaxTimeout: 10000,\n                cache: false,\n                beforeSend: function() {\n                    voteAjaxDefaultBeforeSendReviews(buttonAnchor, buttonContainer, messageContainer);\n                },\n                success: function(data, textStatus) {\n                    voteAjaxDefaultSuccessReviews(data, textStatus, buttonAnchor, buttonContainer, messageContainer, isNoButton, inappUrl);\n                },\n                error: function(JSBNG__XMLHttpRequest, textStatus, errorThrown) {\n                    voteAjaxDefaultErrorReviews(textStatus, errorThrown, buttonAnchor, buttonContainer, messageContainer);\n                },\n                url: ((buttonAnchor.children[0].href + \"&type=json\"))\n            });\n            return false;\n        });\n    });\n});");
// 1154
geval("if (((amznJQ && amznJQ.addPL))) {\n    amznJQ.addPL(\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/x-locale/checkout/signin-banner._V192194415_.gif\");\n    amznJQ.addPL(\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/authportal/flex/reduced-nav/ap-flex-reduced-nav-2.0._V393733149_.js\");\n    amznJQ.addPL(\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/x-locale/cs/css/images/amznbtn-sprite03._V387356454_.png\");\n    amznJQ.addPL(\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/x-locale/common/transparent-pixel._V386942464_.gif\");\n    amznJQ.addPL(\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/authportal/common/images/amazon_logo_no-org_mid._V153387053_.png\");\n    amznJQ.addPL(\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/x-locale/common/login/fwcim._V369602065_.js\");\n    amznJQ.addPL(\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/javascripts/lib/jquery/jquery-1.2.6.min._V253690767_.js\");\n    amznJQ.addPL(\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/authportal/common/js/ap_global-1.1._V371300931_.js\");\n    amznJQ.addPL(\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/orderApplication/css/authPortal/sign-in._V392399058_.css\");\n    amznJQ.addPL(\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/gno/images/orangeBlue/navPackedSprites-US-22._V141013035_.png\");\n    amznJQ.addPL(\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/authportal/common/css/ap_global._V379390626_.css\");\n    amznJQ.addPL(\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/advertising/dev/js/live/adSnippet._V142890782_.js\");\n    amznJQ.addPL(\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/orderApplication/js/authPortal/sign-in._V375965495_.js\");\n    amznJQ.addPL(\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/x-locale/common/buttons/sign-in-secure._V192194766_.gif\");\n    amznJQ.addPL(\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/authportal/flex/reduced-nav/ap-flex-reduced-nav-2.1._V379390718_.css\");\n    amznJQ.addPL(\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/x-locale/common/errors-alerts/error-styles-ssl._V219086192_.css\");\n}\n;\n;");
// 1155
geval("amznJQ.available(\"jQuery\", function() {\n    jQuery(window).load(function() {\n        JSBNG__setTimeout(function() {\n            var imageAssets = new Array();\n            var jsCssAssets = new Array();\n            imageAssets.push(\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/x-locale/common/buy-buttons/review-1-click-order._V192251243_.gif\");\n            imageAssets.push(\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/x-locale/common/buttons/continue-shopping._V192193522_.gif\");\n            imageAssets.push(\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/x-locale/common/buy-buttons/thank-you-elbow._V192238786_.gif\");\n            imageAssets.push(\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/x-locale/communities/social/snwicons_v2._V369764580_.png\");\n            imageAssets.push(\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/checkout/assets/carrot._V192196173_.gif\");\n            imageAssets.push(\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/checkout/thank-you-page/assets/yellow-rounded-corner-sprite._V192238288_.gif\");\n            imageAssets.push(\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/checkout/thank-you-page/assets/white-rounded-corner-sprite._V192259929_.gif\");\n            imageAssets.push(\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/gno/beacon/BeaconSprite-US-01._V397411194_.png\");\n            imageAssets.push(\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/x-locale/common/transparent-pixel._V386942464_.gif\");\n            jsCssAssets.push(\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/nav2/gamma/share-with-friends-css-new/share-with-friends-css-new-share-17385.css._V154656367_.css\");\n            jsCssAssets.push(\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/nav2/gamma/share-with-friends-js-new/share-with-friends-js-new-share-2043.js._V157885514_.js\");\n            jsCssAssets.push(\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/nav2/gamma/websiteGridCSS/websiteGridCSS-websiteGridCSS-48346.css._V176526456_.css\");\n            imageAssets.push(\"http://jsbngssl.images-na.ssl-images-amazon.com/images/I/51gdVAEfPUL._SX35_.jpg\");\n            jsCssAssets.push(\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/browser-scripts/us-site-wide-css-beacon/site-wide-7538592147._V1_.css\");\n            jsCssAssets.push(\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/browser-scripts/site-wide-js-1.2.6-beacon/site-wide-6717236952._V1_.js\");\n            for (var i = 0; ((i < imageAssets.length)); i++) {\n                new JSBNG__Image().src = imageAssets[i];\n            };\n        ;\n            var isIE = 0;\n            var isFireFox = /Firefox/.test(JSBNG__navigator.userAgent);\n            if (isIE) {\n                for (var i = 0; ((i < jsCssAssets.length)); i++) {\n                    new JSBNG__Image().src = jsCssAssets[i];\n                };\n            ;\n            }\n             else if (isFireFox) {\n                for (var i = 0; ((i < jsCssAssets.length)); i++) {\n                    var o = JSBNG__document.createElement(\"object\");\n                    o.data = jsCssAssets[i];\n                    o.width = o.height = 0;\n                    JSBNG__document.body.appendChild(o);\n                };\n            ;\n            }\n            \n        ;\n        ;\n        }, 2000);\n    });\n});");
// 1156
geval("var ocInitTimestamp = 1374695826;\namznJQ.onCompletion(\"amznJQ.criticalFeature\", function() {\n    amznJQ.available(\"jQuery\", function() {\n        jQuery.ajax({\n            url: \"http://z-ecx.images-amazon.com/images/G/01/orderApplication/javascript/pipeline/201201041713-ocd._V394759207_.js\",\n            dataType: \"script\",\n            cache: true\n        });\n    });\n});");
// 1157
geval("if (((!window.$SearchJS && window.$Nav))) {\n    window.$SearchJS = $Nav.make();\n}\n;\n;\nif (window.$SearchJS) {\n    $SearchJS.when(\"jQuery\").run(function(jQuery) {\n        if (((jQuery.fn.jquery == \"1.2.6\"))) {\n            var windowUnloadHandlers = jQuery.data(window, \"events\").unload;\n            {\n                var fin31keys = ((window.top.JSBNG_Replay.forInKeys)((windowUnloadHandlers))), fin31i = (0);\n                var origUnloadUnbinder;\n                for (; (fin31i < fin31keys.length); (fin31i++)) {\n                    ((origUnloadUnbinder) = (fin31keys[fin31i]));\n                    {\n                        break;\n                    };\n                };\n            };\n        ;\n            jQuery(window).unbind(\"unload\", windowUnloadHandlers[origUnloadUnbinder]).unload(function() {\n                if (jQuery.browser.msie) {\n                    var elems = JSBNG__document.getElementsByTagName(\"*\"), pos = ((elems.length + 1)), dummy = {\n                    };\n                    jQuery.data(dummy);\n                    {\n                        var fin32keys = ((window.top.JSBNG_Replay.forInKeys)((dummy))), fin32i = (0);\n                        var expando;\n                        for (; (fin32i < fin32keys.length); (fin32i++)) {\n                            ((expando) = (fin32keys[fin32i]));\n                            {\n                            ;\n                            };\n                        };\n                    };\n                ;\n                    while (pos--) {\n                        var elem = ((elems[pos] || JSBNG__document)), id = elem[expando];\n                        if (((((id && jQuery.cache[id])) && jQuery.cache[id].events))) {\n                            jQuery.JSBNG__event.remove(elem);\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                }\n            ;\n            ;\n            });\n        }\n    ;\n    ;\n    });\n    $SearchJS.importEvent(\"search-sabc\", {\n        global: \"amzn.sx.sabc\"\n    });\n    $SearchJS.when(\"jQuery\", \"search-sabc\", \"page.loaded\").run(function($, sabc) {\n        var loadingSpinnerCss = ((((\"\\u003Cstyle type='text/css'\\u003E\" + \".loadingSpinner { background-image: url('http://g-ecx.images-amazon.com/images/G/01/nav2/images/gui/loading-large._V192184511_.gif '); background-repeat: no-repeat; height: 52px; width: 152px; margin-left: 50%; margin-top: 8px;}\")) + \"\\u003C/style\\u003E\"));\n        $(\"head\").append($(loadingSpinnerCss).attr({\n            type: \"text/css\"\n        }));\n        sabc.controllerInstance = new sabc.Controller(8, false, false, 5, [\"electronics-tradein\",\"moviestv-tradein\",\"textbooks-tradein\",\"videogames-tradein\",\"wireless-tradein\",\"books-tradein\",\"foreign-books-tradein\",\"music-tradein\",\"auctions\",\"local\",\"people\",\"tags\",\"ohs\",\"zshops\",\"community-reviews\",\"rp-listmania\",\"rp-sylt\",\"help\",\"digital-music\",\"digital-music-ss\",\"mp3-downloads\",\"music-dd\",\"us-digital-music-tree\",\"de-digital-music-tree\",\"fr-digital-music-tree\",\"uk-digital-music-tree\",\"digital-music-track\",\"digital-music-track-ss\",], [\"javascript the good parts\",]);\n    });\n    (function() {\n        var origPreloader = ((((((window.amznJQ && window.amznJQ.addPL)) || ((window.A && window.A.preload)))) || (function() {\n        \n        }))), preloader = origPreloader;\n        preloader([\"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/page-ajax/page-ajax-1808621310._V1_.js\",\"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/us-site-wide-css-beacon/site-wide-7538592147._V1_.css\",\"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/clickWithinSearchPageStatic/clickWithinSearchPageStatic-907040417._V1_.css\",\"http://g-ecx.images-amazon.com/images/G/01/gno/beacon/BeaconSprite-US-01._V397411194_.png\",\"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/site-wide-js-1.6.4-beacon/site-wide-10089390333._V1_.js\",\"http://g-ecx.images-amazon.com/images/G/01/x-locale/common/transparent-pixel._V386942464_.gif\",\"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/search-js-trackplayer/search-js-trackplayer-3680312603._V1_.js\",\"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/search-js-general/search-js-general-3030000497._V1_.js\",\"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/search-css/search-css-3339535292._V1_.css\",\"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/search-ajax/search-ajax-766415123._V1_.js\",\"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/forester-client/forester-client-1094892990._V1_.js\",\"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/csmCELLS/csmCELLS-2626677177._V1_.js\",\"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/jserrors/jserrors-1871966242._V1_.js\",\"http://g-ecx.images-amazon.com/images/G/01/nav2/images/gui/searchSprite._V378890307_.png\",\"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/search-csl/search-csl-2400229912._V1_.js\",]);\n    })();\n}\n;\n;");
// 1159
o1 = {};
// 1160
o0.ue_backdetect = o1;
// 1162
o4 = {};
// 1163
o1.ue_back = o4;
// undefined
o1 = null;
// 1166
o4.value = "1";
// undefined
o4 = null;
// 1167
o1 = {};
// 1168
f876774570_0.returns.push(o1);
// 1169
o1.getTime = f876774570_400;
// undefined
o1 = null;
// 1170
f876774570_400.returns.push(1374695829943);
// 1171
f876774570_7.returns.push(undefined);
// 1172
f876774570_446 = function() { return f876774570_446.returns[f876774570_446.inst++]; };
f876774570_446.returns = [];
f876774570_446.inst = 0;
// 1173
ow876774570.JSBNG__onload = f876774570_446;
// 1158
geval("try {\n    (function(a) {\n        if (((JSBNG__document.ue_backdetect && JSBNG__document.ue_backdetect.ue_back))) {\n            a.ue.bfini = JSBNG__document.ue_backdetect.ue_back.value;\n        }\n    ;\n    ;\n        if (a.uet) {\n            a.uet(\"be\");\n        }\n    ;\n    ;\n        if (a.onLdEnd) {\n            if (window.JSBNG__addEventListener) {\n                window.JSBNG__addEventListener(\"load\", a.onLdEnd, false);\n            }\n             else {\n                if (window.JSBNG__attachEvent) {\n                    window.JSBNG__attachEvent(\"JSBNG__onload\", a.onLdEnd);\n                }\n            ;\n            ;\n            }\n        ;\n        ;\n        }\n    ;\n    ;\n        if (a.ueh) {\n            a.ueh(0, window, \"load\", a.onLd, 1);\n        }\n    ;\n    ;\n        if (((a.ue_pr && ((((a.ue_pr == 3)) || ((a.ue_pr == 4))))))) {\n            a.ue._uep();\n        }\n    ;\n    ;\n    })(ue_csm);\n} catch (JSBNG_ex) {\n\n};");
// 1175
o1 = {};
// 1176
o3.navigation = o1;
// 1177
o1.type = 0;
// 1178
o4 = {};
// 1179
f876774570_0.returns.push(o4);
// undefined
o4 = null;
// 1180
o4 = {};
// 1181
f876774570_0.returns.push(o4);
// 1182
f876774570_450 = function() { return f876774570_450.returns[f876774570_450.inst++]; };
f876774570_450.returns = [];
f876774570_450.inst = 0;
// 1183
o4.toGMTString = f876774570_450;
// undefined
o4 = null;
// 1184
f876774570_450.returns.push("Invalid Date");
// 1185
o4 = {};
// 1186
f876774570_0.returns.push(o4);
// undefined
o4 = null;
// 1174
geval("try {\n    (function(a) {\n        a._uec = function(d) {\n            var h = window, b = h.JSBNG__performance, f = ((b ? b.navigation.type : 0));\n            if (((f == 0))) {\n                var e = ((\"; expires=\" + new JSBNG__Date(((+new JSBNG__Date + 604800000))).toGMTString())), c = ((+new JSBNG__Date - ue_t0));\n                if (((c > 0))) {\n                    var g = ((\"|\" + +new JSBNG__Date));\n                    JSBNG__document.cookie = ((((((((\"csm-hit=\" + ((d / c)).toFixed(2))) + g)) + e)) + \"; path=/\"));\n                }\n            ;\n            ;\n            }\n        ;\n        ;\n        };\n    })(ue_csm);\n    _uec(441858);\n} catch (JSBNG_ex) {\n\n};");
// 1188
o4 = {};
// 1189
o5 = {};
// 1190
f876774570_0.returns.push(o5);
// 1191
o5.getTime = f876774570_400;
// undefined
o5 = null;
// 1192
f876774570_400.returns.push(1374695829996);
// 1196
f876774570_6.returns.push(undefined);
// 1203
o5 = {};
// 1204
o3.timing = o5;
// undefined
o3 = null;
// 1206
o5.navigationStart = 1374695825701;
// 1210
o5.unloadEventStart = 1374695829148;
// 1211
o5.unloadEventEnd = 1374695829158;
// 1212
o5.redirectStart = 0;
// 1213
o5.redirectEnd = 0;
// 1214
o5.fetchStart = 1374695825701;
// 1215
o5.domainLookupStart = 1374695825701;
// 1216
o5.domainLookupEnd = 1374695825701;
// 1217
o5.connectStart = 1374695825701;
// 1218
o5.connectEnd = 1374695825701;
// 1219
o5.secureConnectionStart = void 0;
// 1220
o5.requestStart = 1374695825702;
// 1221
o5.responseStart = 1374695829147;
// 1222
o5.responseEnd = 1374695829173;
// 1223
o5.domLoading = 1374695829148;
// 1224
o5.domInteractive = 1374695829943;
// 1225
o5.domContentLoadedEventStart = 1374695829944;
// 1226
o5.domContentLoadedEventEnd = 1374695829944;
// 1227
o5.domComplete = 1374695829994;
// 1228
o5.loadEventStart = 1374695829994;
// 1229
o5.loadEventEnd = 0;
// undefined
o5 = null;
// 1231
o1.redirectCount = 0;
// undefined
o1 = null;
// 1233
o1 = {};
// 1234
f876774570_0.returns.push(o1);
// 1235
o1.getTime = f876774570_400;
// undefined
o1 = null;
// 1236
f876774570_400.returns.push(1374695830010);
// 1237
o1 = {};
// 1238
f876774570_65.returns.push(o1);
// 1239
// undefined
o1 = null;
// 1240
o1 = {};
// 1241
f876774570_0.returns.push(o1);
// undefined
o1 = null;
// 1242
f876774570_17.returns.push(3);
// 1243
f876774570_446.returns.push(undefined);
// 1244
f876774570_446.returns.push(undefined);
// 1245
f876774570_446.returns.push(undefined);
// 1246
f876774570_446.returns.push(undefined);
// 1247
f876774570_446.returns.push(undefined);
// 1248
f876774570_446.returns.push(undefined);
// 1249
f876774570_446.returns.push(undefined);
// 1250
f876774570_446.returns.push(undefined);
// 1251
f876774570_446.returns.push(undefined);
// 1252
f876774570_446.returns.push(undefined);
// 1253
f876774570_446.returns.push(undefined);
// 1254
f876774570_446.returns.push(undefined);
// 1255
f876774570_446.returns.push(undefined);
// 1256
f876774570_446.returns.push(undefined);
// 1257
f876774570_446.returns.push(undefined);
// 1258
f876774570_446.returns.push(undefined);
// 1259
f876774570_446.returns.push(undefined);
// 1260
f876774570_446.returns.push(undefined);
// 1261
f876774570_446.returns.push(undefined);
// 1262
f876774570_446.returns.push(undefined);
// 1263
f876774570_446.returns.push(undefined);
// 1264
f876774570_446.returns.push(undefined);
// 1265
f876774570_446.returns.push(undefined);
// 1266
f876774570_446.returns.push(undefined);
// 1267
f876774570_446.returns.push(undefined);
// 1268
f876774570_446.returns.push(undefined);
// 1269
f876774570_446.returns.push(undefined);
// 1270
f876774570_446.returns.push(undefined);
// 1271
f876774570_446.returns.push(undefined);
// 1272
f876774570_446.returns.push(undefined);
// 1273
f876774570_446.returns.push(undefined);
// 1274
f876774570_446.returns.push(undefined);
// 1275
f876774570_446.returns.push(undefined);
// 1276
f876774570_446.returns.push(undefined);
// 1277
f876774570_446.returns.push(undefined);
// 1278
f876774570_446.returns.push(undefined);
// 1279
f876774570_446.returns.push(undefined);
// 1280
f876774570_446.returns.push(undefined);
// 1281
f876774570_446.returns.push(undefined);
// 1282
f876774570_446.returns.push(undefined);
// 1283
f876774570_446.returns.push(undefined);
// 1284
f876774570_446.returns.push(undefined);
// 1285
f876774570_446.returns.push(undefined);
// 1286
f876774570_446.returns.push(undefined);
// 1287
f876774570_446.returns.push(undefined);
// 1288
f876774570_446.returns.push(undefined);
// 1289
f876774570_446.returns.push(undefined);
// 1290
f876774570_446.returns.push(undefined);
// 1291
f876774570_446.returns.push(undefined);
// 1292
f876774570_446.returns.push(undefined);
// 1293
f876774570_446.returns.push(undefined);
// 1294
f876774570_446.returns.push(undefined);
// 1295
f876774570_446.returns.push(undefined);
// 1296
f876774570_446.returns.push(undefined);
// 1297
f876774570_446.returns.push(undefined);
// 1298
f876774570_446.returns.push(undefined);
// 1299
f876774570_446.returns.push(undefined);
// 1300
f876774570_446.returns.push(undefined);
// 1301
f876774570_446.returns.push(undefined);
// 1302
f876774570_446.returns.push(undefined);
// 1303
f876774570_446.returns.push(undefined);
// 1304
f876774570_446.returns.push(undefined);
// 1305
f876774570_446.returns.push(undefined);
// 1306
f876774570_446.returns.push(undefined);
// 1307
f876774570_446.returns.push(undefined);
// 1308
f876774570_446.returns.push(undefined);
// 1309
f876774570_446.returns.push(undefined);
// 1310
f876774570_446.returns.push(undefined);
// 1311
f876774570_446.returns.push(undefined);
// 1312
f876774570_446.returns.push(undefined);
// 1313
f876774570_446.returns.push(undefined);
// 1314
f876774570_446.returns.push(undefined);
// 1315
f876774570_446.returns.push(undefined);
// 1316
f876774570_446.returns.push(undefined);
// 1317
f876774570_446.returns.push(undefined);
// 1318
f876774570_446.returns.push(undefined);
// 1319
f876774570_446.returns.push(undefined);
// 1320
f876774570_446.returns.push(undefined);
// 1321
f876774570_446.returns.push(undefined);
// 1322
f876774570_446.returns.push(undefined);
// 1323
f876774570_446.returns.push(undefined);
// 1324
f876774570_446.returns.push(undefined);
// 1325
f876774570_446.returns.push(undefined);
// 1326
f876774570_446.returns.push(undefined);
// 1327
f876774570_446.returns.push(undefined);
// 1328
f876774570_446.returns.push(undefined);
// 1329
f876774570_446.returns.push(undefined);
// 1330
f876774570_446.returns.push(undefined);
// 1331
f876774570_446.returns.push(undefined);
// 1332
f876774570_446.returns.push(undefined);
// 1333
f876774570_446.returns.push(undefined);
// 1334
f876774570_446.returns.push(undefined);
// 1335
f876774570_446.returns.push(undefined);
// 1336
f876774570_446.returns.push(undefined);
// 1337
f876774570_446.returns.push(undefined);
// 1338
f876774570_446.returns.push(undefined);
// 1339
f876774570_446.returns.push(undefined);
// 1340
f876774570_446.returns.push(undefined);
// 1341
f876774570_446.returns.push(undefined);
// 1342
f876774570_446.returns.push(undefined);
// 1343
f876774570_446.returns.push(undefined);
// 1344
f876774570_446.returns.push(undefined);
// 1345
f876774570_446.returns.push(undefined);
// 1346
f876774570_446.returns.push(undefined);
// 1347
f876774570_446.returns.push(undefined);
// 1348
f876774570_446.returns.push(undefined);
// 1349
f876774570_446.returns.push(undefined);
// 1350
f876774570_446.returns.push(undefined);
// 1351
f876774570_446.returns.push(undefined);
// 1352
f876774570_446.returns.push(undefined);
// 1353
f876774570_446.returns.push(undefined);
// 1354
f876774570_446.returns.push(undefined);
// 1355
f876774570_446.returns.push(undefined);
// 1356
f876774570_446.returns.push(undefined);
// 1357
f876774570_446.returns.push(undefined);
// 1358
f876774570_446.returns.push(undefined);
// 1359
f876774570_446.returns.push(undefined);
// 1360
f876774570_446.returns.push(undefined);
// 1361
f876774570_446.returns.push(undefined);
// 1362
f876774570_446.returns.push(undefined);
// 1363
f876774570_446.returns.push(undefined);
// 1364
f876774570_446.returns.push(undefined);
// 1365
f876774570_446.returns.push(undefined);
// 1366
f876774570_446.returns.push(undefined);
// 1367
f876774570_446.returns.push(undefined);
// 1368
f876774570_446.returns.push(undefined);
// 1369
f876774570_446.returns.push(undefined);
// 1370
f876774570_446.returns.push(undefined);
// 1371
f876774570_446.returns.push(undefined);
// 1372
f876774570_446.returns.push(undefined);
// 1373
f876774570_446.returns.push(undefined);
// 1374
f876774570_446.returns.push(undefined);
// 1375
f876774570_446.returns.push(undefined);
// 1376
f876774570_446.returns.push(undefined);
// 1377
f876774570_446.returns.push(undefined);
// 1378
f876774570_446.returns.push(undefined);
// 1379
f876774570_446.returns.push(undefined);
// 1380
f876774570_446.returns.push(undefined);
// 1381
f876774570_446.returns.push(undefined);
// 1382
f876774570_446.returns.push(undefined);
// 1383
f876774570_446.returns.push(undefined);
// 1384
f876774570_446.returns.push(undefined);
// 1385
f876774570_446.returns.push(undefined);
// 1386
f876774570_446.returns.push(undefined);
// 1387
f876774570_446.returns.push(undefined);
// 1388
f876774570_446.returns.push(undefined);
// 1389
f876774570_446.returns.push(undefined);
// 1390
f876774570_446.returns.push(undefined);
// 1391
f876774570_446.returns.push(undefined);
// 1392
f876774570_446.returns.push(undefined);
// 1393
f876774570_446.returns.push(undefined);
// 1394
f876774570_446.returns.push(undefined);
// 1395
f876774570_446.returns.push(undefined);
// 1396
f876774570_446.returns.push(undefined);
// 1397
f876774570_446.returns.push(undefined);
// 1398
f876774570_446.returns.push(undefined);
// 1399
f876774570_446.returns.push(undefined);
// 1400
f876774570_446.returns.push(undefined);
// 1401
f876774570_446.returns.push(undefined);
// 1402
f876774570_446.returns.push(undefined);
// 1403
f876774570_446.returns.push(undefined);
// 1404
f876774570_446.returns.push(undefined);
// 1405
f876774570_446.returns.push(undefined);
// 1406
f876774570_446.returns.push(undefined);
// 1407
f876774570_446.returns.push(undefined);
// 1408
f876774570_446.returns.push(undefined);
// 1409
f876774570_446.returns.push(undefined);
// 1410
f876774570_446.returns.push(undefined);
// 1411
f876774570_446.returns.push(undefined);
// 1412
f876774570_446.returns.push(undefined);
// 1413
f876774570_446.returns.push(undefined);
// 1414
f876774570_446.returns.push(undefined);
// 1415
f876774570_446.returns.push(undefined);
// 1416
f876774570_446.returns.push(undefined);
// 1417
f876774570_446.returns.push(undefined);
// 1418
f876774570_446.returns.push(undefined);
// 1419
f876774570_446.returns.push(undefined);
// 1420
f876774570_446.returns.push(undefined);
// 1421
f876774570_446.returns.push(undefined);
// 1422
f876774570_446.returns.push(undefined);
// 1423
f876774570_446.returns.push(undefined);
// 1424
f876774570_446.returns.push(undefined);
// 1425
f876774570_446.returns.push(undefined);
// 1426
f876774570_446.returns.push(undefined);
// 1427
f876774570_446.returns.push(undefined);
// 1428
f876774570_446.returns.push(undefined);
// 1429
f876774570_446.returns.push(undefined);
// 1430
f876774570_446.returns.push(undefined);
// 1431
f876774570_446.returns.push(undefined);
// 1432
f876774570_446.returns.push(undefined);
// 1433
f876774570_446.returns.push(undefined);
// 1434
f876774570_446.returns.push(undefined);
// 1435
f876774570_446.returns.push(undefined);
// 1436
f876774570_446.returns.push(undefined);
// 1437
f876774570_446.returns.push(undefined);
// 1438
f876774570_446.returns.push(undefined);
// 1439
f876774570_446.returns.push(undefined);
// 1440
f876774570_446.returns.push(undefined);
// 1441
f876774570_446.returns.push(undefined);
// 1442
f876774570_446.returns.push(undefined);
// 1443
f876774570_446.returns.push(undefined);
// 1444
f876774570_446.returns.push(undefined);
// 1445
f876774570_446.returns.push(undefined);
// 1446
f876774570_446.returns.push(undefined);
// 1447
f876774570_446.returns.push(undefined);
// 1448
f876774570_446.returns.push(undefined);
// 1449
f876774570_446.returns.push(undefined);
// 1450
// 1187
geval("amznJQ.addLogical(\"search-sabc\", [\"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/search-sabc/search-sabc-605884639._V1_.js\",]);");
// 1452
f876774570_16.returns.push(4);
// 1451
JSBNG_Replay.s6642b77f01f4d49ef240b29032e6da4372359178_0[0](o4);
// 1454
f876774570_16.returns.push(5);
// 1453
JSBNG_Replay.s62d148c5af61b0a7d54ea938e5a6a16cd1eee833_1[0](o4);
// undefined
o4 = null;
// 1457
o1 = {};
// 1458
f876774570_410.returns.push(o1);
// 1459
// undefined
o1 = null;
// 1455
JSBNG_Replay.s62d148c5af61b0a7d54ea938e5a6a16cd1eee833_2[0]();
// 1461
// undefined
o2 = null;
// 1462
o1 = {};
// 1463
f876774570_0.returns.push(o1);
// 1464
o1.getHours = f876774570_417;
// 1465
f876774570_417.returns.push(12);
// 1466
o1.getMinutes = f876774570_418;
// 1467
f876774570_418.returns.push(57);
// 1468
o1.getSeconds = f876774570_419;
// undefined
o1 = null;
// 1469
f876774570_419.returns.push(10);
// 1474
f876774570_410.returns.push(null);
// 1479
f876774570_410.returns.push(null);
// 1480
f876774570_16.returns.push(6);
// 1482
o1 = {};
// 1483
f876774570_410.returns.push(o1);
// 1484
// 1485
o2 = {};
// 1486
f876774570_0.returns.push(o2);
// 1487
o2.getHours = f876774570_417;
// 1488
f876774570_417.returns.push(12);
// 1489
o2.getMinutes = f876774570_418;
// 1490
f876774570_418.returns.push(57);
// 1491
o2.getSeconds = f876774570_419;
// undefined
o2 = null;
// 1492
f876774570_419.returns.push(12);
// 1497
f876774570_410.returns.push(null);
// 1502
f876774570_410.returns.push(null);
// 1503
f876774570_16.returns.push(7);
// 1505
f876774570_410.returns.push(o1);
// 1506
o2 = {};
// 1507
f876774570_0.returns.push(o2);
// 1508
o2.getHours = f876774570_417;
// 1509
f876774570_417.returns.push(12);
// 1510
o2.getMinutes = f876774570_418;
// 1511
f876774570_418.returns.push(57);
// 1512
o2.getSeconds = f876774570_419;
// undefined
o2 = null;
// 1513
f876774570_419.returns.push(13);
// 1518
f876774570_410.returns.push(null);
// 1523
f876774570_410.returns.push(null);
// 1524
f876774570_16.returns.push(8);
// 1526
f876774570_410.returns.push(o1);
// 1527
o2 = {};
// 1528
f876774570_0.returns.push(o2);
// 1529
o2.getHours = f876774570_417;
// 1530
f876774570_417.returns.push(12);
// 1531
o2.getMinutes = f876774570_418;
// 1532
f876774570_418.returns.push(57);
// 1533
o2.getSeconds = f876774570_419;
// undefined
o2 = null;
// 1534
f876774570_419.returns.push(14);
// 1539
f876774570_410.returns.push(null);
// 1544
f876774570_410.returns.push(null);
// 1545
f876774570_16.returns.push(9);
// 1547
f876774570_410.returns.push(o1);
// 1548
o2 = {};
// 1549
f876774570_0.returns.push(o2);
// 1550
o2.getHours = f876774570_417;
// 1551
f876774570_417.returns.push(12);
// 1552
o2.getMinutes = f876774570_418;
// 1553
f876774570_418.returns.push(57);
// 1554
o2.getSeconds = f876774570_419;
// undefined
o2 = null;
// 1555
f876774570_419.returns.push(15);
// 1560
f876774570_410.returns.push(null);
// 1565
f876774570_410.returns.push(null);
// 1566
f876774570_16.returns.push(10);
// 1568
f876774570_410.returns.push(o1);
// 1569
o2 = {};
// 1570
f876774570_0.returns.push(o2);
// 1571
o2.getHours = f876774570_417;
// 1572
f876774570_417.returns.push(12);
// 1573
o2.getMinutes = f876774570_418;
// 1574
f876774570_418.returns.push(57);
// 1575
o2.getSeconds = f876774570_419;
// undefined
o2 = null;
// 1576
f876774570_419.returns.push(16);
// 1581
f876774570_410.returns.push(null);
// 1586
f876774570_410.returns.push(null);
// 1587
f876774570_16.returns.push(11);
// 1589
f876774570_410.returns.push(o1);
// 1590
o2 = {};
// 1591
f876774570_0.returns.push(o2);
// 1592
o2.getHours = f876774570_417;
// 1593
f876774570_417.returns.push(12);
// 1594
o2.getMinutes = f876774570_418;
// 1595
f876774570_418.returns.push(57);
// 1596
o2.getSeconds = f876774570_419;
// undefined
o2 = null;
// 1597
f876774570_419.returns.push(17);
// 1602
f876774570_410.returns.push(null);
// 1607
f876774570_410.returns.push(null);
// 1608
f876774570_16.returns.push(12);
// 1610
f876774570_410.returns.push(o1);
// 1611
o2 = {};
// 1612
f876774570_0.returns.push(o2);
// 1613
o2.getHours = f876774570_417;
// 1614
f876774570_417.returns.push(12);
// 1615
o2.getMinutes = f876774570_418;
// 1616
f876774570_418.returns.push(57);
// 1617
o2.getSeconds = f876774570_419;
// undefined
o2 = null;
// 1618
f876774570_419.returns.push(18);
// 1623
f876774570_410.returns.push(null);
// 1628
f876774570_410.returns.push(null);
// 1629
f876774570_16.returns.push(13);
// 1631
f876774570_410.returns.push(o1);
// undefined
o1 = null;
// 1632
o1 = {};
// 1460
JSBNG_Replay.s6642b77f01f4d49ef240b29032e6da4372359178_1[0]();
// 1634
o1.type = "mozvisibilitychange";
// 1635
o1.originalEvent = void 0;
// 1636
o0.mozVisibilityState = "hidden";
// 1637
o2 = {};
// 1638
f876774570_0.returns.push(o2);
// undefined
o2 = null;
// 1639
// 1633
fpc.call(JSBNG_Replay.s8293f527e56b5e5ce44ad4d8d5c9f8f5b3feb86c_7[0], o0,o1);
// undefined
o0 = null;
// undefined
o1 = null;
// 1640
cb(); return null; }
finalize(); })();
