/* Replayable replacements for global functions */

/***************************************************************
 * BEGIN STABLE.JS
 **************************************************************/
//! stable.js 0.1.3, https://github.com/Two-Screen/stable
//! © 2012 Stéphan Kochen, Angry Bytes. MIT licensed.
(function() {

// A stable array sort, because `Array#sort()` is not guaranteed stable.
// This is an implementation of merge sort, without recursion.

var stable = function(arr, comp) {
    if (typeof(comp) !== 'function') {
        comp = function(a, b) {
            a = String(a);
            b = String(b);
            if (a < b) return -1;
            if (a > b) return 1;
            return 0;
        };
    }

    var len = arr.length;

    if (len <= 1) return arr;

    // Rather than dividing input, simply iterate chunks of 1, 2, 4, 8, etc.
    // Chunks are the size of the left or right hand in merge sort.
    // Stop when the left-hand covers all of the array.
    var oarr = arr;
    for (var chk = 1; chk < len; chk *= 2) {
        arr = pass(arr, comp, chk);
    }
    for (var i = 0; i < len; i++) {
        oarr[i] = arr[i];
    }
    return oarr;
};

// Run a single pass with the given chunk size. Returns a new array.
var pass = function(arr, comp, chk) {
    var len = arr.length;
    // Output, and position.
    var result = new Array(len);
    var i = 0;
    // Step size / double chunk size.
    var dbl = chk * 2;
    // Bounds of the left and right chunks.
    var l, r, e;
    // Iterators over the left and right chunk.
    var li, ri;

    // Iterate over pairs of chunks.
    for (l = 0; l < len; l += dbl) {
        r = l + chk;
        e = r + chk;
        if (r > len) r = len;
        if (e > len) e = len;

        // Iterate both chunks in parallel.
        li = l;
        ri = r;
        while (true) {
            // Compare the chunks.
            if (li < r && ri < e) {
                // This works for a regular `sort()` compatible comparator,
                // but also for a simple comparator like: `a > b`
                if (comp(arr[li], arr[ri]) <= 0) {
                    result[i++] = arr[li++];
                }
                else {
                    result[i++] = arr[ri++];
                }
            }
            // Nothing to compare, just flush what's left.
            else if (li < r) {
                result[i++] = arr[li++];
            }
            else if (ri < e) {
                result[i++] = arr[ri++];
            }
            // Both iterators are at the chunk ends.
            else {
                break;
            }
        }
    }

    return result;
};

var arrsort = function(comp) {
    return stable(this, comp);
};

if (Object.defineProperty) {
    Object.defineProperty(Array.prototype, "sort", {
        configurable: true, writable: true, enumerable: false,
        value: arrsort
    });
} else {
    Array.prototype.sort = arrsort;
}

})();
/***************************************************************
 * END STABLE.JS
 **************************************************************/

/*
 * In a generated replay, this file is partially common, boilerplate code
 * included in every replay, and partially generated replay code. The following
 * header applies to the boilerplate code. A comment indicating "Auto-generated
 * below this comment" marks the separation between these two parts.
 *
 * Copyright (C) 2011, 2012 Purdue University
 * Written by Gregor Richards
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

(function() {
    // global eval alias
    var geval = eval;

    // detect if we're in a browser or not
    var inbrowser = false;
    var inharness = false;
    var finished = false;
    if (typeof window !== "undefined" && "document" in window) {
        inbrowser = true;
        if (window.parent && "JSBNG_handleResult" in window.parent) {
            inharness = true;
        }
    } else if (typeof global !== "undefined") {
        window = global;
        window.top = window;
    } else {
        window = (function() { return this; })();
        window.top = window;
    }

    if ("console" in window) {
        window.JSBNG_Console = window.console;
    }

    var callpath = [];

    // Workaround for bound functions as events
    delete Function.prototype.bind;

    // global state
    var JSBNG_Replay = window.top.JSBNG_Replay = {
        push: function(arr, fun) {
            arr.push(fun);
            return fun;
        },

        path: function(str) {
            verifyPath(str);
        },

        forInKeys: function(of) {
            var keys = [];
            for (var k in of)
                keys.push(k);
            return keys.sort();
        }
    };

    var currentTimeInMS;
    if (inharness) {
        currentTimeInMS = window.parent.currentTimeInMS;
    } else {
        if (window.performance && window.performance.now)
            currentTimeInMS = function() { return window.performance.now() };
        else if (typeof preciseTime !== 'undefined')
            currentTimeInMS = function() { return preciseTime() * 1000; };
        else
            currentTimeInMS = function() { return Date.now(); };
    }

    // the actual replay runner
    function onload() {
        try {
            delete window.onload;
        } catch (ex) {}

        var jr = JSBNG_Replay$;
        var cb = function() {
            var end = currentTimeInMS();
            finished = true;

            var msg = "Time: " + (end - st) + "ms";
    
            if (inharness) {
                window.parent.JSBNG_handleResult({error:false, time:(end - st)});
            } else if (inbrowser) {
                var res = document.createElement("div");
    
                res.style.position = "fixed";
                res.style.left = "1em";
                res.style.top = "1em";
                res.style.width = "35em";
                res.style.height = "5em";
                res.style.padding = "1em";
                res.style.backgroundColor = "white";
                res.style.color = "black";
                res.appendChild(document.createTextNode(msg));
    
                document.body.appendChild(res);
            } else if (typeof console !== "undefined") {
                console.log(msg);
            } else if (typeof print !== "undefined") {
                // hopefully not the browser print() function :)
                print(msg);
            }
        };

        // force it to JIT
        jr(false);

        // then time it
        var st = currentTimeInMS();
        while (jr !== null) {
            jr = jr(true, cb);
        }
    }

    // add a frame at replay time
    function iframe(pageid) {
        var iw;
        if (inbrowser) {
            // represent the iframe as an iframe (of course)
            var iframe = document.createElement("iframe");
            iframe.style.display = "none";
            document.body.appendChild(iframe);
            iw = iframe.contentWindow;
            iw.document.write("<script type=\"text/javascript\">var JSBNG_Replay_geval = eval;</script>");
            iw.document.close();
        } else {
            // no general way, just lie and do horrible things
            var topwin = window;
            (function() {
                var window = {};
                window.window = window;
                window.top = topwin;
                window.JSBNG_Replay_geval = function(str) {
                    eval(str);
                }
                iw = window;
            })();
        }
        return iw;
    }

    // called at the end of the replay stuff
    function finalize() {
        if (inbrowser) {
            setTimeout(onload, 0);
        } else {
            onload();
        }
    }

    // verify this recorded value and this replayed value are close enough
    function verify(rep, rec) {
        if (rec !== rep &&
            (rep === rep || rec === rec) /* NaN test */) {
            // FIXME?
            if (typeof rec === "function" && typeof rep === "function") {
                return true;
            }
            if (typeof rec !== "object" || rec === null ||
                !(("__JSBNG_unknown_" + typeof(rep)) in rec)) {
                return false;
            }
        }
        return true;
    }

    // general message
    var firstMessage = true;
    function replayMessage(msg) {
        if (inbrowser) {
            if (firstMessage)
                document.open();
            firstMessage = false;
            document.write(msg);
        } else {
            console.log(msg);
        }
    }

    // complain when there's an error
    function verificationError(msg) {
        if (finished) return;
        if (inharness) {
            window.parent.JSBNG_handleResult({error:true, msg: msg});
        } else replayMessage(msg);
        throw new Error();
    }

    // to verify a set
    function verifySet(objstr, obj, prop, gvalstr, gval) {
        if (/^on/.test(prop)) {
            // these aren't instrumented compatibly
            return;
        }

        if (!verify(obj[prop], gval)) {
            var bval = obj[prop];
            var msg = "Verification failure! " + objstr + "." + prop + " is not " + gvalstr + ", it's " + bval + "!";
            verificationError(msg);
        }
    }

    // to verify a call or new
    function verifyCall(iscall, func, cthis, cargs) {
        var ok = true;
        var callArgs = func.callArgs[func.inst];
        iscall = iscall ? 1 : 0;
        if (cargs.length !== callArgs.length - 1) {
            ok = false;
        } else {
            if (iscall && !verify(cthis, callArgs[0])) ok = false;
            for (var i = 0; i < cargs.length; i++) {
                if (!verify(cargs[i], callArgs[i+1])) ok = false;
            }
        }
        if (!ok) {
            var msg = "Call verification failure!";
            verificationError(msg);
        }

        return func.returns[func.inst++];
    }

    // to verify the callpath
    function verifyPath(func) {
        var real = callpath.shift();
        if (real !== func) {
            var msg = "Call path verification failure! Expected " + real + ", found " + func;
            verificationError(msg);
        }
    }

    // figure out how to define getters
    var defineGetter;
    if (Object.defineProperty) {
        var odp = Object.defineProperty;
        defineGetter = function(obj, prop, getter, setter) {
            if (typeof setter === "undefined") setter = function(){};
            odp(obj, prop, {"enumerable": true, "configurable": true, "get": getter, "set": setter});
        };
    } else if (Object.prototype.__defineGetter__) {
        var opdg = Object.prototype.__defineGetter__;
        var opds = Object.prototype.__defineSetter__;
        defineGetter = function(obj, prop, getter, setter) {
            if (typeof setter === "undefined") setter = function(){};
            opdg.call(obj, prop, getter);
            opds.call(obj, prop, setter);
        };
    } else {
        defineGetter = function() {
            verificationError("This replay requires getters for correct behavior, and your JS engine appears to be incapable of defining getters. Sorry!");
        };
    }

    var defineRegetter = function(obj, prop, getter, setter) {
        defineGetter(obj, prop, function() {
            return getter.call(this, prop);
        }, function(val) {
            // once it's set by the client, it's claimed
            setter.call(this, prop, val);
            Object.defineProperty(obj, prop, {
                "enumerable": true, "configurable": true, "writable": true,
                "value": val
            });
        });
    }

    // for calling events
    var fpc = Function.prototype.call;

// resist the urge, don't put a })(); here!
/******************************************************************************
 * Auto-generated below this comment
 *****************************************************************************/
var ow881945950 = window;
var f881945950_0;
var o0;
var f881945950_7;
var f881945950_16;
var f881945950_17;
var o1;
var o2;
var o3;
var f881945950_65;
var f881945950_393;
var f881945950_395;
var f881945950_397;
var o4;
var o5;
var f881945950_406;
var o6;
var o7;
var o8;
var f881945950_413;
var f881945950_414;
var f881945950_415;
var f881945950_423;
var f881945950_427;
var f881945950_439;
var f881945950_443;
JSBNG_Replay.s6642b77f01f4d49ef240b29032e6da4372359178_0 = [];
JSBNG_Replay.sdaedc82b47673ce6de4c0b9c01978bd63c2c50e4_1 = [];
JSBNG_Replay.sdaedc82b47673ce6de4c0b9c01978bd63c2c50e4_2 = [];
JSBNG_Replay.s6642b77f01f4d49ef240b29032e6da4372359178_1 = [];
JSBNG_Replay.sd77f26a2825b7813fef421f4fc64cccaae936b24_7 = [];
// 1
// record generated by JSBench  at 2013-07-10T17:55:49.619Z
// 2
// 3
f881945950_0 = function() { return f881945950_0.returns[f881945950_0.inst++]; };
f881945950_0.returns = [];
f881945950_0.inst = 0;
// 4
ow881945950.JSBNG__Date = f881945950_0;
// 5
o0 = {};
// 6
ow881945950.JSBNG__document = o0;
// 17
f881945950_7 = function() { return f881945950_7.returns[f881945950_7.inst++]; };
f881945950_7.returns = [];
f881945950_7.inst = 0;
// 18
ow881945950.JSBNG__addEventListener = f881945950_7;
// 19
ow881945950.JSBNG__top = ow881945950;
// 28
ow881945950.JSBNG__scrollX = 0;
// 29
ow881945950.JSBNG__scrollY = 0;
// 38
f881945950_16 = function() { return f881945950_16.returns[f881945950_16.inst++]; };
f881945950_16.returns = [];
f881945950_16.inst = 0;
// 39
ow881945950.JSBNG__setTimeout = f881945950_16;
// 40
f881945950_17 = function() { return f881945950_17.returns[f881945950_17.inst++]; };
f881945950_17.returns = [];
f881945950_17.inst = 0;
// 41
ow881945950.JSBNG__setInterval = f881945950_17;
// 60
ow881945950.JSBNG__frames = ow881945950;
// 63
ow881945950.JSBNG__self = ow881945950;
// 70
ow881945950.JSBNG__content = ow881945950;
// 81
ow881945950.JSBNG__closed = false;
// 84
ow881945950.JSBNG__pkcs11 = null;
// 87
ow881945950.JSBNG__opener = null;
// 88
ow881945950.JSBNG__defaultStatus = "";
// 89
o1 = {};
// 90
ow881945950.JSBNG__location = o1;
// 91
ow881945950.JSBNG__innerWidth = 994;
// 92
ow881945950.JSBNG__innerHeight = 603;
// 93
ow881945950.JSBNG__outerWidth = 994;
// 94
ow881945950.JSBNG__outerHeight = 690;
// 95
ow881945950.JSBNG__screenX = 24;
// 96
ow881945950.JSBNG__screenY = 28;
// 97
ow881945950.JSBNG__mozInnerScreenX = 0;
// 98
ow881945950.JSBNG__mozInnerScreenY = 0;
// 99
ow881945950.JSBNG__pageXOffset = 0;
// 100
ow881945950.JSBNG__pageYOffset = 0;
// 101
ow881945950.JSBNG__scrollMaxX = 0;
// 102
ow881945950.JSBNG__scrollMaxY = 0;
// 103
ow881945950.JSBNG__fullScreen = false;
// 136
ow881945950.JSBNG__frameElement = null;
// 141
ow881945950.JSBNG__mozPaintCount = 0;
// 144
ow881945950.JSBNG__mozAnimationStartTime = 1373479177771;
// 145
o2 = {};
// 146
ow881945950.JSBNG__mozIndexedDB = o2;
// 151
o3 = {};
// 152
ow881945950.JSBNG__performance = o3;
// 155
ow881945950.JSBNG__devicePixelRatio = 1;
// 160
f881945950_65 = function() { return f881945950_65.returns[f881945950_65.inst++]; };
f881945950_65.returns = [];
f881945950_65.inst = 0;
// 161
ow881945950.JSBNG__Image = f881945950_65;
// 166
ow881945950.JSBNG__name = "uaMatch";
// 173
ow881945950.JSBNG__status = "";
// 176
ow881945950.JSBNG__Components = undefined;
// 771
ow881945950.JSBNG__indexedDB = o2;
// undefined
o2 = null;
// 804
ow881945950.JSBNG__onerror = null;
// 809
// 0
JSBNG_Replay$ = function(real, cb) { if (!real) return;
// 811
o2 = {};
// 812
f881945950_0.returns.push(o2);
// undefined
o2 = null;
// 810
geval("var ue_t0 = ((ue_t0 || +new JSBNG__Date()));");
// 814
o2 = {};
// 815
f881945950_0.returns.push(o2);
// undefined
o2 = null;
// 816
o2 = {};
// 817
f881945950_0.returns.push(o2);
// undefined
o2 = null;
// 818
o2 = {};
// 819
f881945950_0.returns.push(o2);
// undefined
o2 = null;
// 820
o2 = {};
// 821
f881945950_0.returns.push(o2);
// undefined
o2 = null;
// 822
o2 = {};
// 823
f881945950_0.returns.push(o2);
// undefined
o2 = null;
// 824
ow881945950.JSBNG__onJSBNG__stop = undefined;
// 825
f881945950_393 = function() { return f881945950_393.returns[f881945950_393.inst++]; };
f881945950_393.returns = [];
f881945950_393.inst = 0;
// 826
ow881945950.JSBNG__onbeforeunload = f881945950_393;
// 827
o0.webkitHidden = void 0;
// 828
o0.oHidden = void 0;
// 829
o0.msHidden = void 0;
// 830
o0.mozHidden = false;
// 831
o0.mozVisibilityState = "visible";
// 832
o2 = {};
// 833
f881945950_0.returns.push(o2);
// undefined
o2 = null;
// 834
f881945950_395 = function() { return f881945950_395.returns[f881945950_395.inst++]; };
f881945950_395.returns = [];
f881945950_395.inst = 0;
// 835
o0.JSBNG__addEventListener = f881945950_395;
// 836
f881945950_395.returns.push(undefined);
// 837
f881945950_7.returns.push(undefined);
// 838
o2 = {};
// 839
f881945950_0.returns.push(o2);
// 840
f881945950_397 = function() { return f881945950_397.returns[f881945950_397.inst++]; };
f881945950_397.returns = [];
f881945950_397.inst = 0;
// 841
o2.getTime = f881945950_397;
// undefined
o2 = null;
// 842
f881945950_397.returns.push(1373479177880);
// 843
o2 = {};
// 844
f881945950_0.returns.push(o2);
// undefined
o2 = null;
// 845
o2 = {};
// 846
f881945950_0.returns.push(o2);
// undefined
o2 = null;
// 847
o2 = {};
// 848
f881945950_0.returns.push(o2);
// undefined
o2 = null;
// 813
geval("var ue_csm = window;\nue_csm.ue_hob = ((ue_csm.ue_hob || +new JSBNG__Date()));\n(function(d) {\n    var a = {\n        ec: 0,\n        pec: 0,\n        ts: 0,\n        erl: [],\n        mxe: 50,\n        startTimer: function() {\n            a.ts++;\n            JSBNG__setInterval(function() {\n                ((((d.ue && ((a.pec < a.ec)))) && d.uex(\"at\")));\n                a.pec = a.ec;\n            }, 10000);\n        }\n    };\n    function c(e) {\n        if (((a.ec > a.mxe))) {\n            return;\n        }\n    ;\n    ;\n        a.ec++;\n        if (d.ue_jserrv2) {\n            e.pageURL = ((\"\" + ((window.JSBNG__location ? window.JSBNG__location.href : \"\"))));\n        }\n    ;\n    ;\n        a.erl.push(e);\n    };\n;\n    function b(h, g, e) {\n        var f = {\n            m: h,\n            f: g,\n            l: e,\n            fromOnError: 1,\n            args: arguments\n        };\n        d.ueLogError(f);\n        return false;\n    };\n;\n    b.skipTrace = 1;\n    c.skipTrace = 1;\n    d.ueLogError = c;\n    d.ue_err = a;\n    window.JSBNG__onerror = b;\n})(ue_csm);\nue_csm.ue_hoe = +new JSBNG__Date();\nvar ue_id = \"0M4YTA6K9C1VFV7TYXNC\", ue_sid = \"176-5336870-9447366\", ue_mid = \"ATVPDKIKX0DER\", ue_sn = \"www.amazon.com\", ue_url = \"/JavaScript-Good-Parts-Douglas-Crockford/dp/0596517742/ref=sr_1_1/uedata/unsticky/176-5336870-9447366/Detail/ntpoffrw\", ue_furl = \"fls-na.amazon.com\", ue_pr = 0, ue_navtiming = 1, ue_log_idx = 0, ue_log_f = 0, ue_fcsn = 1, ue_ctb0tf = 1, ue_fst = 0, ue_fna = 1, ue_swi = 1, ue_swm = 4, ue_onbful = 0, ue_jserrv2 = 3;\nif (!window.ue_csm) {\n    var ue_csm = window;\n}\n;\n;\nue_csm.ue_hob = ((ue_csm.ue_hob || +new JSBNG__Date));\nfunction ue_viz() {\n    (function(d, j, g) {\n        var b, l, e, a, c = [\"\",\"moz\",\"ms\",\"o\",\"webkit\",], k = 0, f = 20, h = \"JSBNG__addEventListener\", i = \"JSBNG__attachEvent\";\n        while ((((b = c.pop()) && !k))) {\n            l = ((((b ? ((b + \"H\")) : \"h\")) + \"idden\"));\n            if (k = ((typeof j[l] == \"boolean\"))) {\n                e = ((b + \"visibilitychange\"));\n                a = ((b + \"VisibilityState\"));\n            }\n        ;\n        ;\n        };\n    ;\n        {\n            function m(q) {\n                if (((d.ue.viz.length < f))) {\n                    var p = q.type, n = q.originalEvent;\n                    if (!((((/^focus./.test(p) && n)) && ((((n.toElement || n.fromElement)) || n.relatedTarget))))) {\n                        var r = ((j[a] || ((((((p == \"JSBNG__blur\")) || ((p == \"focusout\")))) ? \"hidden\" : \"visible\")))), o = ((+new JSBNG__Date - d.ue.t0));\n                        d.ue.viz.push(((((r + \":\")) + o)));\n                        ((((((ue.iel && ((ue.iel.length > 0)))) && ((r == \"visible\")))) && uex(\"at\")));\n                    }\n                ;\n                ;\n                }\n            ;\n            ;\n            };\n            ((window.top.JSBNG_Replay.sd77f26a2825b7813fef421f4fc64cccaae936b24_7.push)((m)));\n        };\n    ;\n        m({\n        });\n        if (k) {\n            j[h](e, m, 0);\n        }\n    ;\n    ;\n    })(ue_csm, JSBNG__document, window);\n};\n;\nue_csm.ue_hoe = +new JSBNG__Date;\nue_csm.ue_hob = ((ue_csm.ue_hob || +new JSBNG__Date()));\n(function(e, h) {\n    e.ueinit = ((((e.ueinit || 0)) + 1));\n    e.ue = {\n        t0: ((h.aPageStart || e.ue_t0)),\n        id: e.ue_id,\n        url: e.ue_url,\n        a: \"\",\n        b: \"\",\n        h: {\n        },\n        r: {\n            ld: 0,\n            oe: 0,\n            ul: 0\n        },\n        s: 1,\n        t: {\n        },\n        sc: {\n        },\n        iel: [],\n        ielf: [],\n        fc_idx: {\n        },\n        viz: [],\n        v: 30\n    };\n    e.ue.tagC = function() {\n        var j = [];\n        return function(k) {\n            if (k) {\n                j.push(k);\n            }\n        ;\n        ;\n            return j.slice(0);\n        };\n    };\n    e.ue.tag = e.ue.tagC();\n    e.ue.ifr = ((((((h.JSBNG__top !== h.JSBNG__self)) || (h.JSBNG__frameElement))) ? 1 : 0));\n    function c(l, o, q, n) {\n        if (((e.ue_log_f && e.ue.log))) {\n            e.ue.log({\n                f: \"uet\",\n                en: l,\n                s: o,\n                so: q,\n                to: n\n            }, \"csm\");\n        }\n    ;\n    ;\n        var p = ((n || (new JSBNG__Date()).getTime()));\n        var j = ((!o && ((typeof q != \"undefined\"))));\n        if (j) {\n            return;\n        }\n    ;\n    ;\n        if (l) {\n            var m = ((o ? ((d(\"t\", o) || d(\"t\", o, {\n            }))) : e.ue.t));\n            m[l] = p;\n            {\n                var fin0keys = ((window.top.JSBNG_Replay.forInKeys)((q))), fin0i = (0);\n                var k;\n                for (; (fin0i < fin0keys.length); (fin0i++)) {\n                    ((k) = (fin0keys[fin0i]));\n                    {\n                        d(k, o, q[k]);\n                    };\n                };\n            };\n        ;\n        }\n    ;\n    ;\n        return p;\n    };\n;\n    function d(k, l, m) {\n        if (((e.ue_log_f && e.ue.log))) {\n            e.ue.log({\n                f: \"ues\",\n                k: k,\n                s: l,\n                v: m\n            }, \"csm\");\n        }\n    ;\n    ;\n        var n, j;\n        if (k) {\n            n = j = e.ue;\n            if (((l && ((l != n.id))))) {\n                j = n.sc[l];\n                if (!j) {\n                    j = {\n                    };\n                    ((m ? (n.sc[l] = j) : j));\n                }\n            ;\n            ;\n            }\n        ;\n        ;\n            n = ((m ? (j[k] = m) : j[k]));\n        }\n    ;\n    ;\n        return n;\n    };\n;\n    function g(n, o, m, k, j) {\n        if (((e.ue_log_f && e.ue.log))) {\n            e.ue.log({\n                f: \"ueh\",\n                ek: n\n            }, \"csm\");\n        }\n    ;\n    ;\n        var l = ((\"JSBNG__on\" + m));\n        var p = o[l];\n        if (((typeof (p) == \"function\"))) {\n            if (n) {\n                e.ue.h[n] = p;\n            }\n        ;\n        ;\n        }\n         else {\n            p = function() {\n            \n            };\n        }\n    ;\n    ;\n        o[l] = ((j ? function(q) {\n            k(q);\n            p(q);\n        } : function(q) {\n            p(q);\n            k(q);\n        }));\n        o[l].isUeh = 1;\n    };\n;\n    function b(s, m, r) {\n        if (((e.ue_log_f && e.ue.log))) {\n            e.ue.log({\n                f: \"uex\",\n                en: s,\n                s: m,\n                so: r\n            }, \"csm\");\n        }\n    ;\n    ;\n        function l(P, N) {\n            var L = [P,], G = 0, M = {\n            };\n            if (N) {\n                L.push(\"m=1\");\n                M[N] = 1;\n            }\n             else {\n                M = e.ue.sc;\n            }\n        ;\n        ;\n            var E;\n            {\n                var fin1keys = ((window.top.JSBNG_Replay.forInKeys)((M))), fin1i = (0);\n                var F;\n                for (; (fin1i < fin1keys.length); (fin1i++)) {\n                    ((F) = (fin1keys[fin1i]));\n                    {\n                        var H = d(\"wb\", F), K = ((d(\"t\", F) || {\n                        })), J = ((d(\"t0\", F) || e.ue.t0));\n                        if (((N || ((H == 2))))) {\n                            var O = ((H ? G++ : \"\"));\n                            L.push(((((((\"sc\" + O)) + \"=\")) + F)));\n                            {\n                                var fin2keys = ((window.top.JSBNG_Replay.forInKeys)((K))), fin2i = (0);\n                                var I;\n                                for (; (fin2i < fin2keys.length); (fin2i++)) {\n                                    ((I) = (fin2keys[fin2i]));\n                                    {\n                                        if (((((I.length <= 3)) && K[I]))) {\n                                            L.push(((((((I + O)) + \"=\")) + ((K[I] - J)))));\n                                        }\n                                    ;\n                                    ;\n                                    };\n                                };\n                            };\n                        ;\n                            L.push(((((((\"t\" + O)) + \"=\")) + K[s])));\n                            if (((d(\"ctb\", F) || d(\"wb\", F)))) {\n                                E = 1;\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                    };\n                };\n            };\n        ;\n            if (((!n && E))) {\n                L.push(\"ctb=1\");\n            }\n        ;\n        ;\n            return L.join(\"&\");\n        };\n    ;\n        function v(H, F, J, E) {\n            if (!H) {\n                return;\n            }\n        ;\n        ;\n            var I = new JSBNG__Image();\n            var G = function() {\n                if (!e.ue.b) {\n                    return;\n                }\n            ;\n            ;\n                var L = e.ue.b;\n                e.ue.b = \"\";\n                v(L, F, J, 1);\n            };\n            if (((e.ue.b && !e.ue_swi))) {\n                I.JSBNG__onload = G;\n            }\n        ;\n        ;\n            var K = ((((((!E || !e.ue.log)) || !window.amznJQ)) || ((window.amznJQ && window.amznJQ.isMock))));\n            if (K) {\n                e.ue.iel.push(I);\n                I.src = H;\n            }\n        ;\n        ;\n            if (((e.ue.log && ((((J || E)) || e.ue_ctb0tf))))) {\n                e.ue.log(H, \"uedata\", {\n                    n: 1\n                });\n                e.ue.ielf.push(H);\n            }\n        ;\n        ;\n            if (((e.ue_err && !e.ue_err.ts))) {\n                e.ue_err.startTimer();\n            }\n        ;\n        ;\n            if (e.ue_swi) {\n                G();\n            }\n        ;\n        ;\n        };\n    ;\n        function B(E) {\n            if (!ue.collected) {\n                var G = E.timing;\n                if (G) {\n                    e.ue.t.na_ = G.navigationStart;\n                    e.ue.t.ul_ = G.unloadEventStart;\n                    e.ue.t._ul = G.unloadEventEnd;\n                    e.ue.t.rd_ = G.redirectStart;\n                    e.ue.t._rd = G.redirectEnd;\n                    e.ue.t.fe_ = G.fetchStart;\n                    e.ue.t.lk_ = G.domainLookupStart;\n                    e.ue.t._lk = G.domainLookupEnd;\n                    e.ue.t.co_ = G.connectStart;\n                    e.ue.t._co = G.connectEnd;\n                    e.ue.t.sc_ = G.secureConnectionStart;\n                    e.ue.t.rq_ = G.requestStart;\n                    e.ue.t.rs_ = G.responseStart;\n                    e.ue.t._rs = G.responseEnd;\n                    e.ue.t.dl_ = G.domLoading;\n                    e.ue.t.di_ = G.domInteractive;\n                    e.ue.t.de_ = G.domContentLoadedEventStart;\n                    e.ue.t._de = G.domContentLoadedEventEnd;\n                    e.ue.t._dc = G.domComplete;\n                    e.ue.t.ld_ = G.loadEventStart;\n                    e.ue.t._ld = G.loadEventEnd;\n                }\n            ;\n            ;\n                var F = E.navigation;\n                if (F) {\n                    e.ue.t.ty = ((F.type + e.ue.t0));\n                    e.ue.t.rc = ((F.redirectCount + e.ue.t0));\n                    if (e.ue.tag) {\n                        e.ue.tag(((F.redirectCount ? \"redirect\" : \"nonredirect\")));\n                    }\n                ;\n                ;\n                }\n            ;\n            ;\n                e.ue.collected = 1;\n            }\n        ;\n        ;\n        };\n    ;\n        var D = ((!m && ((typeof r != \"undefined\"))));\n        if (D) {\n            return;\n        }\n    ;\n    ;\n        {\n            var fin3keys = ((window.top.JSBNG_Replay.forInKeys)((r))), fin3i = (0);\n            var j;\n            for (; (fin3i < fin3keys.length); (fin3i++)) {\n                ((j) = (fin3keys[fin3i]));\n                {\n                    d(j, m, r[j]);\n                };\n            };\n        };\n    ;\n        c(\"pc\", m, r);\n        var x = ((d(\"id\", m) || e.ue.id));\n        var p = ((((((((((((e.ue.url + \"?\")) + s)) + \"&v=\")) + e.ue.v)) + \"&id=\")) + x));\n        var n = ((d(\"ctb\", m) || d(\"wb\", m)));\n        if (n) {\n            p += ((\"&ctb=\" + n));\n        }\n    ;\n    ;\n        if (((e.ueinit > 1))) {\n            p += ((\"&ic=\" + e.ueinit));\n        }\n    ;\n    ;\n        var A = ((h.JSBNG__performance || h.JSBNG__webkitPerformance));\n        var y = e.ue.bfini;\n        var q = ((((A && A.navigation)) && ((A.navigation.type == 2))));\n        var o = ((((m && ((m != x)))) && d(\"ctb\", m)));\n        if (!o) {\n            if (((y && ((y > 1))))) {\n                p += ((\"&bft=\" + ((y - 1))));\n                p += \"&bfform=1\";\n            }\n             else {\n                if (q) {\n                    p += \"&bft=1\";\n                }\n            ;\n            ;\n            }\n        ;\n        ;\n            if (q) {\n                p += \"&bfnt=1\";\n            }\n        ;\n        ;\n        }\n    ;\n    ;\n        if (((((e.ue._fi && ((s == \"at\")))) && ((!m || ((m == x))))))) {\n            p += e.ue._fi();\n        }\n    ;\n    ;\n        var k;\n        if (((((((s == \"ld\")) || ((s == \"ul\")))) && ((!m || ((m == x))))))) {\n            if (((s == \"ld\"))) {\n                if (((h.JSBNG__onbeforeunload && h.JSBNG__onbeforeunload.isUeh))) {\n                    h.JSBNG__onbeforeunload = null;\n                }\n            ;\n            ;\n                ue.r.ul = e.ue_onbful;\n                if (((e.ue_onbful == 3))) {\n                    ue.detach(\"beforeunload\", e.onUl);\n                }\n            ;\n            ;\n                if (((JSBNG__document.ue_backdetect && JSBNG__document.ue_backdetect.ue_back))) {\n                    JSBNG__document.ue_backdetect.ue_back.value++;\n                }\n            ;\n            ;\n                if (e._uess) {\n                    k = e._uess();\n                }\n            ;\n            ;\n            }\n        ;\n        ;\n            if (((((e.ue_navtiming && A)) && A.timing))) {\n                d(\"ctb\", x, \"1\");\n                if (((e.ue_navtiming == 1))) {\n                    e.ue.t.tc = A.timing.navigationStart;\n                }\n            ;\n            ;\n            }\n        ;\n        ;\n            if (A) {\n                B(A);\n            }\n        ;\n        ;\n            if (((e.ue_hob && e.ue_hoe))) {\n                e.ue.t.hob = e.ue_hob;\n                e.ue.t.hoe = e.ue_hoe;\n            }\n        ;\n        ;\n            if (e.ue.ifr) {\n                p += \"&ifr=1\";\n            }\n        ;\n        ;\n        }\n    ;\n    ;\n        c(s, m, r);\n        var w = ((((((s == \"ld\")) && m)) && d(\"wb\", m)));\n        if (w) {\n            d(\"wb\", m, 2);\n        }\n    ;\n    ;\n        var z = 1;\n        {\n            var fin4keys = ((window.top.JSBNG_Replay.forInKeys)((e.ue.sc))), fin4i = (0);\n            var u;\n            for (; (fin4i < fin4keys.length); (fin4i++)) {\n                ((u) = (fin4keys[fin4i]));\n                {\n                    if (((d(\"wb\", u) == 1))) {\n                        z = 0;\n                        break;\n                    }\n                ;\n                ;\n                };\n            };\n        };\n    ;\n        if (w) {\n            if (((!e.ue.s && ((e.ue_swi || ((z && !e.ue_swi))))))) {\n                p = l(p, null);\n            }\n             else {\n                return;\n            }\n        ;\n        ;\n        }\n         else {\n            if (((((z && !e.ue_swi)) || e.ue_swi))) {\n                var C = l(p, null);\n                if (((C != p))) {\n                    e.ue.b = C;\n                }\n            ;\n            ;\n            }\n        ;\n        ;\n            if (k) {\n                p += k;\n            }\n        ;\n        ;\n            p = l(p, ((m || e.ue.id)));\n        }\n    ;\n    ;\n        if (((e.ue.b || w))) {\n            {\n                var fin5keys = ((window.top.JSBNG_Replay.forInKeys)((e.ue.sc))), fin5i = (0);\n                var u;\n                for (; (fin5i < fin5keys.length); (fin5i++)) {\n                    ((u) = (fin5keys[fin5i]));\n                    {\n                        if (((d(\"wb\", u) == 2))) {\n                            delete e.ue.sc[u];\n                        }\n                    ;\n                    ;\n                    };\n                };\n            };\n        ;\n        }\n    ;\n    ;\n        var t = 0;\n        if (!w) {\n            e.ue.s = 0;\n            if (((e.ue_err && ((e.ue_err.ec > 0))))) {\n                if (((e.ue_jserrv2 == 3))) {\n                    if (((e.ue_err.pec < e.ue_err.ec))) {\n                        e.ue_err.pec = e.ue_err.ec;\n                        p += ((\"&ec=\" + e.ue_err.ec));\n                    }\n                ;\n                ;\n                }\n                 else {\n                    p += ((\"&ec=\" + e.ue_err.ec));\n                }\n            ;\n            ;\n            }\n        ;\n        ;\n            t = d(\"ctb\", m);\n            d(\"t\", m, {\n            });\n        }\n    ;\n    ;\n        if (((!window.amznJQ && e.ue.tag))) {\n            e.ue.tag(\"noAmznJQ\");\n        }\n    ;\n    ;\n        if (((((p && e.ue.tag)) && ((e.ue.tag().length > 0))))) {\n            p += ((\"&csmtags=\" + e.ue.tag().join(\"|\")));\n            e.ue.tag = e.ue.tagC();\n        }\n    ;\n    ;\n        if (((((p && e.ue.viz)) && ((e.ue.viz.length > 0))))) {\n            p += ((\"&viz=\" + e.ue.viz.join(\"|\")));\n            e.ue.viz = [];\n        }\n    ;\n    ;\n        e.ue.a = p;\n        v(p, s, t, w);\n    };\n;\n    function a(j, k, l) {\n        l = ((l || h));\n        if (l.JSBNG__addEventListener) {\n            l.JSBNG__addEventListener(j, k, false);\n        }\n         else {\n            if (l.JSBNG__attachEvent) {\n                l.JSBNG__attachEvent(((\"JSBNG__on\" + j)), k);\n            }\n        ;\n        ;\n        }\n    ;\n    ;\n    };\n;\n    ue.attach = a;\n    function i(j, k, l) {\n        l = ((l || h));\n        if (l.JSBNG__removeEventListener) {\n            l.JSBNG__removeEventListener(j, k);\n        }\n         else {\n            if (l.JSBNG__detachEvent) {\n                l.JSBNG__detachEvent(((\"JSBNG__on\" + j)), k);\n            }\n        ;\n        ;\n        }\n    ;\n    ;\n    };\n;\n    ue.detach = i;\n    function f() {\n        if (((e.ue_log_f && e.ue.log))) {\n            e.ue.log({\n                f: \"uei\"\n            }, \"csm\");\n        }\n    ;\n    ;\n        var l = e.ue.r;\n        function k(n) {\n            return function() {\n                if (!l[n]) {\n                    l[n] = 1;\n                    b(n);\n                }\n            ;\n            ;\n            };\n        };\n    ;\n        e.onLd = k(\"ld\");\n        e.onLdEnd = k(\"ld\");\n        e.onUl = k(\"ul\");\n        var j = {\n            beforeunload: e.onUl,\n            JSBNG__stop: function() {\n                b(\"os\");\n            }\n        };\n        {\n            var fin6keys = ((window.top.JSBNG_Replay.forInKeys)((j))), fin6i = (0);\n            var m;\n            for (; (fin6i < fin6keys.length); (fin6i++)) {\n                ((m) = (fin6keys[fin6i]));\n                {\n                    g(0, window, m, j[m]);\n                };\n            };\n        };\n    ;\n        ((e.ue_viz && ue_viz()));\n        ue.attach(\"load\", e.onLd);\n        if (((e.ue_onbful == 3))) {\n            ue.attach(\"beforeunload\", e.onUl);\n        }\n    ;\n    ;\n        e.ue._uep = function() {\n            new JSBNG__Image().src = ((((e.ue_md ? e.ue_md : \"http://uedata.amazon.com/uedata/?tp=\")) + (+new JSBNG__Date)));\n        };\n        if (((e.ue_pr && ((((e.ue_pr == 2)) || ((e.ue_pr == 4))))))) {\n            e.ue._uep();\n        }\n    ;\n    ;\n        c(\"ue\");\n    };\n;\n    ue.reset = function(k, j) {\n        if (!k) {\n            return;\n        }\n    ;\n    ;\n        ((e.ue_cel && e.ue_cel.reset()));\n        e.ue.t0 = +new JSBNG__Date();\n        e.ue.rid = k;\n        e.ue.id = k;\n        e.ue.fc_idx = {\n        };\n        e.ue.viz = [];\n    };\n    e.uei = f;\n    e.ueh = g;\n    e.ues = d;\n    e.uet = c;\n    e.uex = b;\n    f();\n})(ue_csm, window);\nue_csm.ue_hoe = +new JSBNG__Date();\nue_csm.ue_hob = ((ue_csm.ue_hob || +new JSBNG__Date()));\n(function(b) {\n    var a = b.ue;\n    a.rid = b.ue_id;\n    a.sid = b.ue_sid;\n    a.mid = b.ue_mid;\n    a.furl = b.ue_furl;\n    a.sn = b.ue_sn;\n    a.lr = [];\n    a.log = function(e, d, c) {\n        if (((a.lr.length == 500))) {\n            return;\n        }\n    ;\n    ;\n        a.lr.push([\"l\",e,d,c,a.d(),a.rid,]);\n    };\n    a.d = function(c) {\n        return ((+new JSBNG__Date - ((c ? 0 : a.t0))));\n    };\n})(ue_csm);\nue_csm.ue_hoe = +new JSBNG__Date();");
// 850
o2 = {};
// 851
f881945950_65.returns.push(o2);
// 852
// 853
// undefined
o2 = null;
// 849
geval("var imaget0;\n(function() {\n    var i = new JSBNG__Image;\n    i.JSBNG__onload = function() {\n        imaget0 = new JSBNG__Date().getTime();\n    };\n    i.src = \"http://ecx.images-amazon.com/images/I/51gdVAEfPUL._BO2,204,203,200_PIsitb-sticker-arrow-click,TopRight,35,-76_AA300_SH20_OU01_.jpg\";\n})();");
// 854
geval("var amznJQ, jQueryPatchIPadOffset = false;\n(function() {\n    function f(x) {\n        return function() {\n            x.push(arguments);\n        };\n    };\n;\n    function ch(y) {\n        return String.fromCharCode(y);\n    };\n;\n    var a = [], c = [], cs = [], d = [], l = [], o = [], s = [], p = [], t = [];\n    amznJQ = {\n        _timesliceJS: false,\n        _a: a,\n        _c: c,\n        _cs: cs,\n        _d: d,\n        _l: l,\n        _o: o,\n        _s: s,\n        _pl: p,\n        addLogical: f(l),\n        addStyle: f(s),\n        addPL: f(p),\n        available: f(a),\n        chars: {\n            EOL: ch(10),\n            SQUOTE: ch(39),\n            DQUOTE: ch(34),\n            BACKSLASH: ch(92),\n            YEN: ch(165)\n        },\n        completedStage: f(cs),\n        declareAvailable: f(d),\n        onCompletion: f(c),\n        onReady: f(o),\n        strings: {\n        }\n    };\n}());");
// 855
geval("function amz_js_PopWin(url, JSBNG__name, options) {\n    var ContextWindow = window.open(url, JSBNG__name, options);\n    ContextWindow.JSBNG__focus();\n    return false;\n};\n;");
// 856
geval("function showElement(id) {\n    var elm = JSBNG__document.getElementById(id);\n    if (elm) {\n        elm.style.visibility = \"visible\";\n        if (((elm.getAttribute(\"JSBNG__name\") == \"heroQuickPromoDiv\"))) {\n            elm.style.display = \"block\";\n        }\n    ;\n    ;\n    }\n;\n;\n};\n;\nfunction hideElement(id) {\n    var elm = JSBNG__document.getElementById(id);\n    if (elm) {\n        elm.style.visibility = \"hidden\";\n        if (((elm.getAttribute(\"JSBNG__name\") == \"heroQuickPromoDiv\"))) {\n            elm.style.display = \"none\";\n        }\n    ;\n    ;\n    }\n;\n;\n};\n;\nfunction showHideElement(h_id, div_id) {\n    var hiddenTag = JSBNG__document.getElementById(h_id);\n    if (hiddenTag) {\n        showElement(div_id);\n    }\n     else {\n        hideElement(div_id);\n    }\n;\n;\n};\n;\nwindow.isBowserFeatureCleanup = 1;\nvar touchDeviceDetected = false;\nvar CSMReqs = {\n    af: {\n        c: 2,\n        e: \"amznJQ.AboveTheFold\",\n        p: \"atf\"\n    },\n    cf: {\n        c: 2,\n        e: \"amznJQ.criticalFeature\",\n        p: \"cf\"\n    }\n};\nfunction setCSMReq(a) {\n    a = a.toLowerCase();\n    var b = CSMReqs[a];\n    if (((b && ((--b.c == 0))))) {\n        if (((typeof uet == \"function\"))) {\n            uet(a);\n        }\n    ;\n    ;\n    ;\n        if (b.e) {\n            amznJQ.completedStage(b.e);\n        }\n    ;\n    ;\n    ;\n        if (((typeof P != \"undefined\"))) {\n            P.register(b.p);\n        }\n    ;\n    ;\n    ;\n    }\n;\n;\n};\n;");
// 857
geval("var gbEnableTwisterJS = 0;\nvar isTwisterPage = 0;");
// 858
geval("if (window.amznJQ) {\n    amznJQ.addLogical(\"csm-base\", [\"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/csm-base/csm-base-min-2486485847._V1_.js\",]);\n    amznJQ.available(\"csm-base\", function() {\n    \n    });\n}\n;\n;");
// 859
geval("amznJQ.onCompletion(\"amznJQ.criticalFeature\", function() {\n    amznJQ.available(\"navbarJS-jQuery\", function() {\n    \n    });\n    amznJQ.available(\"finderFitsJS\", function() {\n    \n    });\n    amznJQ.available(\"twister\", function() {\n    \n    });\n    amznJQ.available(\"swfjs\", function() {\n    \n    });\n});");
// 860
geval("(function(d) {\n    var e = function(d) {\n        function b(f, c, b) {\n            f[b] = function() {\n                a._replay.push(c.concat({\n                    m: b,\n                    a: [].slice.call(arguments)\n                }));\n            };\n        };\n    ;\n        var a = {\n        };\n        a._sourceName = d;\n        a._replay = [];\n        a.getNow = function(a, b) {\n            return b;\n        };\n        a.when = function() {\n            var a = [{\n                m: \"when\",\n                a: [].slice.call(arguments)\n            },], c = {\n            };\n            b(c, a, \"run\");\n            b(c, a, \"declare\");\n            b(c, a, \"publish\");\n            b(c, a, \"build\");\n            return c;\n        };\n        b(a, [], \"declare\");\n        b(a, [], \"build\");\n        b(a, [], \"publish\");\n        b(a, [], \"importEvent\");\n        e._shims.push(a);\n        return a;\n    };\n    e._shims = [];\n    if (!d.$Nav) {\n        d.$Nav = e(\"rcx-nav\");\n    }\n;\n;\n    if (!d.$Nav.make) {\n        d.$Nav.make = e;\n    }\n;\n;\n})(window);\nwindow.$Nav.when(\"exposeSBD.enable\", \"img.horz\", \"img.vert\", \"img.spin\", \"$popover\", \"btf.full\").run(function(d, e, j, b) {\n    function a(a) {\n        switch (typeof a) {\n          case \"boolean\":\n            h = a;\n            i = !0;\n            break;\n          case \"function\":\n            g = a;\n            c++;\n            break;\n          default:\n            c++;\n        };\n    ;\n        ((((i && ((c > 2)))) && g(h)));\n    };\n;\n    function f(a, b) {\n        var c = new JSBNG__Image;\n        if (b) {\n            c.JSBNG__onload = b;\n        }\n    ;\n    ;\n        c.src = a;\n        return c;\n    };\n;\n    var c = 0, g, h, i = !1;\n    f(e, ((d && a)));\n    f(j, ((d && a)));\n    window.$Nav.declare(\"protectExposeSBD\", a);\n    window.$Nav.declare(\"preloadSpinner\", function() {\n        f(b);\n    });\n});\n((window.amznJQ && amznJQ.available(\"navbarJS-beacon\", function() {\n\n})));\nwindow._navbarSpriteUrl = \"http://g-ecx.images-amazon.com/images/G/01/gno/beacon/BeaconSprite-US-01._V397411194_.png\";\n$Nav.importEvent(\"navbarJS-beacon\");\n$Nav.importEvent(\"NavAuiJS\");\n$Nav.declare(\"exposeSBD.enable\", false);\n$Nav.declare(\"img.spin\", \"http://g-ecx.images-amazon.com/images/G/01/javascripts/lib/popover/images/snake._V192571611_.gif\");\n$Nav.when(\"$\").run(function($) {\n    var ie6 = (($.browser.msie && ((parseInt($.browser.version) <= 6))));\n    $Nav.declare(\"img.horz\", ((ie6 ? \"http://g-ecx.images-amazon.com/images/G/01/gno/beacon/nav-pop-8bit-h._V155961234_.png\" : \"http://g-ecx.images-amazon.com/images/G/01/gno/beacon/nav-pop-h-v2._V137157005_.png\")));\n    $Nav.declare(\"img.vert\", ((ie6 ? \"http://g-ecx.images-amazon.com/images/G/01/gno/beacon/nav-pop-8bit-v._V155961234_.png\" : \"http://g-ecx.images-amazon.com/images/G/01/gno/beacon/nav-pop-v-v2._V137157005_.png\")));\n});");
// 862
o2 = {};
// 863
f881945950_0.returns.push(o2);
// 864
o2.getTime = f881945950_397;
// undefined
o2 = null;
// 865
f881945950_397.returns.push(1373479178159);
// 861
geval("window.Navbar = function(options) {\n    options = ((options || {\n    }));\n    this._loadedCount = 0;\n    this._hasUedata = ((typeof uet == \"function\"));\n    this._finishLoadQuota = ((options[\"finishLoadQuota\"] || 2));\n    this._startedLoading = false;\n    this._btfFlyoutContents = [];\n    this._saFlyoutHorizOffset = -16;\n    this._saMaskHorizOffset = -17;\n    this._sbd_config = {\n        major_delay: 300,\n        minor_delay: 100,\n        target_slop: 25\n    };\n    ((window.$Nav && $Nav.declare(\"config.sbd\", this._sbd_config)));\n    this.addToBtfFlyoutContents = function(JSBNG__content, callback) {\n        this._btfFlyoutContents.push({\n            JSBNG__content: JSBNG__content,\n            callback: callback\n        });\n    };\n    this.getBtfFlyoutContents = function() {\n        return this._btfFlyoutContents;\n    };\n    this.loading = function() {\n        if (((!this._startedLoading && this._isReportingEvents()))) {\n            uet(\"ns\");\n        }\n    ;\n    ;\n        this._startedLoading = true;\n    };\n    this.componentLoaded = function() {\n        this._loadedCount++;\n        if (((((this._startedLoading && this._isReportingEvents())) && ((this._loadedCount == this._finishLoadQuota))))) {\n            uet(\"ne\");\n        }\n    ;\n    ;\n    };\n    this._isReportingEvents = function() {\n        return this._hasUedata;\n    };\n    this.browsepromos = {\n    };\n    this.issPromos = [];\n    var le = {\n    };\n    this.logEv = function(d, o) {\n    \n    };\n    ((window.$Nav && $Nav.declare(\"logEvent\", this.logEv)));\n};\nwindow._navbar = new Navbar({\n    finishLoadQuota: 1\n});\n_navbar.loading();\n((window.$Nav && $Nav.declare(\"config.lightningDeals\", ((window._navbar._lightningDealsData || {\n})))));\n((window.$Nav && $Nav.declare(\"config.swmStyleData\", ((window._navbar._swmStyleData || {\n})))));\n_navbar._ajaxProximity = [141,7,60,150,];\n((window.$Nav && $Nav.declare(\"config.ajaxProximity\", window._navbar._ajaxProximity)));");
// 867
o2 = {};
// 868
f881945950_0.returns.push(o2);
// 869
o2.getTime = f881945950_397;
// 870
f881945950_397.returns.push(1373479178221);
// 871
o4 = {};
// 872
f881945950_65.returns.push(o4);
// 873
// 874
// 866
geval("_navbar.dynamicMenuUrl = \"/gp/navigation/ajax/dynamicmenu.html\";\n((window.$Nav && $Nav.declare(\"config.dynamicMenuUrl\", _navbar.dynamicMenuUrl)));\n_navbar.dismissNotificationUrl = \"/gp/navigation/ajax/dismissnotification.html\";\n((window.$Nav && $Nav.declare(\"config.dismissNotificationUrl\", _navbar.dismissNotificationUrl)));\n_navbar.dynamicMenus = true;\n((window.$Nav && $Nav.declare(\"config.enableDynamicMenus\", true)));\n_navbar.recordEvUrl = \"/gp/navigation/ajax/recordevent.html\";\n_navbar.recordEvInterval = 60000;\n_navbar.sid = \"176-5336870-9447366\";\n_navbar.rid = \"0M4YTA6K9C1VFV7TYXNC\";\n((window.$Nav && $Nav.declare(\"config.recordEvUrl\", _navbar.recordEvUrl)));\n((window.$Nav && $Nav.declare(\"config.recordEvInterval\", 60000)));\n((window.$Nav && $Nav.declare(\"config.sessionId\", _navbar.sid)));\n((window.$Nav && $Nav.declare(\"config.requestId\", _navbar.rid)));\n_navbar.readyOnATF = false;\n((window.$Nav && $Nav.declare(\"config.readyOnATF\", _navbar.readyOnATF)));\n_navbar.dynamicMenuArgs = {\n    isPrime: 0,\n    primeMenuWidth: 310\n};\n((window.$Nav && $Nav.declare(\"config.dynamicMenuArgs\", ((_navbar.dynamicMenuArgs || {\n})))));\n((window.$Nav && $Nav.declare(\"config.signOutText\", _navbar.signOutText)));\n((window.$Nav && $Nav.declare(\"config.yourAccountPrimeURL\", _navbar.yourAccountPrimer)));\nif (((window.amznJQ && amznJQ.available))) {\n    amznJQ.available(\"jQuery\", function() {\n        if (!jQuery.isArray) {\n            jQuery.isArray = function(o) {\n                return ((Object.prototype.toString.call(o) === \"[object Array]\"));\n            };\n        }\n    ;\n    ;\n    });\n}\n;\n;\nif (((typeof uet == \"function\"))) {\n    uet(\"bb\", \"iss-init-pc\", {\n        wb: 1\n    });\n}\n;\n;\nif (((!window.$SearchJS && window.$Nav))) {\n    window.$SearchJS = $Nav.make();\n}\n;\n;\nif (window.$SearchJS) {\n    var iss, issHost = \"completion.amazon.com/search/complete\", issMktid = \"1\", issSearchAliases = [\"aps\",\"stripbooks\",\"popular\",\"apparel\",\"electronics\",\"sporting\",\"garden\",\"videogames\",\"toys-and-games\",\"jewelry\",\"digital-text\",\"digital-music\",\"watches\",\"grocery\",\"hpc\",\"instant-video\",\"baby-products\",\"office-products\",\"software\",\"magazines\",\"tools\",\"automotive\",\"misc\",\"industrial\",\"mi\",\"pet-supplies\",\"digital-music-track\",\"digital-music-album\",\"mobile\",\"mobile-apps\",\"movies-tv\",\"music-artist\",\"music-album\",\"music-song\",\"stripbooks-spanish\",\"electronics-accessories\",\"photo\",\"audio-video\",\"computers\",\"furniture\",\"kitchen\",\"audiobooks\",\"beauty\",\"shoes\",\"arts-crafts\",\"appliances\",\"gift-cards\",\"pets\",\"outdoor\",\"lawngarden\",\"collectibles\",\"financial\",\"wine\",], updateISSCompletion = function() {\n        iss.updateAutoCompletion();\n    };\n    $SearchJS.importEvent(\"search-js-autocomplete-lib\");\n    $SearchJS.when(\"search-js-autocomplete-lib\").run(function() {\n        $SearchJS.importEvent(\"search-csl\");\n        $SearchJS.when(\"search-csl\").run(function(searchCSL) {\n            if (!searchCSL) {\n                searchCSL = jQuery.searchCSL;\n            }\n        ;\n        ;\n            searchCSL.init(\"Detail\", \"0M4YTA6K9C1VFV7TYXNC\");\n            var ctw = [function() {\n                var searchSelect = jQuery(\"select.searchSelect\"), nodeRegEx = new RegExp(/node=\\d+/i);\n                return function() {\n                    var currDropdownSel = searchSelect.children();\n                    return ((((currDropdownSel.attr(\"data-root-alias\") || nodeRegEx.test(currDropdownSel.attr(\"value\")))) ? \"16458\" : undefined));\n                };\n            }(),];\n            iss = new AutoComplete({\n                src: issHost,\n                mkt: issMktid,\n                aliases: issSearchAliases,\n                fb: 1,\n                dd: \"select.searchSelect\",\n                dupElim: 0,\n                deptText: \"in {department}\",\n                sugText: \"Search suggestions\",\n                sc: 1,\n                ime: 0,\n                imeEnh: 0,\n                imeSpacing: 0,\n                isNavInline: 1,\n                iac: 0,\n                scs: 0,\n                np: 4,\n                doCTW: function(e) {\n                    for (var i = 0; ((i < ctw.length)); i++) {\n                        searchCSL.addWlt(((ctw[i].call ? ctw[i](e) : ctw[i])));\n                    };\n                ;\n                }\n            });\n            $SearchJS.publish(\"search-js-autocomplete\", iss);\n            if (((((typeof uet == \"function\")) && ((typeof uex == \"function\"))))) {\n                uet(\"be\", \"iss-init-pc\", {\n                    wb: 1\n                });\n                uex(\"ld\", \"iss-init-pc\", {\n                    wb: 1\n                });\n            }\n        ;\n        ;\n        });\n    });\n}\n;\n;\n((window.amznJQ && amznJQ.declareAvailable(\"navbarInline\")));\n((window.$Nav && $Nav.declare(\"nav.inline\")));\n((window.amznJQ && amznJQ.available(\"jQuery\", function() {\n    amznJQ.available(\"navbarJS-beacon\", function() {\n    \n    });\n})));\n_navbar._endSpriteImage = new JSBNG__Image();\n_navbar._endSpriteImage.JSBNG__onload = function() {\n    _navbar.componentLoaded();\n};\n_navbar._endSpriteImage.src = window._navbarSpriteUrl;\n((window.$Nav && $Nav.declare(\"config.autoFocus\", false)));\n((window.$Nav && $Nav.declare(\"config.responsiveGW\", !!window._navbar.responsivegw)));\n((window.$Nav && $Nav.when(\"$\", \"flyout.JSBNG__content\").run(function(jQuery) {\n    jQuery(\"#nav_amabotandroid\").parent().html(\"Get CSG-Crazy Ball\\ufffdfree today\");\n})));\n_navbar.browsepromos[\"android\"] = {\n    destination: \"/gp/product/ref=nav_sap_mas_13_07_10?ie=UTF8&ASIN=B00AVFO41K\",\n    productTitle2: \"(List Price: $0.99)\",\n    button: \"Learn more\",\n    price: \"FREE\",\n    productTitle: \"CSG-Crazy Ball - Power Match5\",\n    headline: \"Free App of the Day\",\n    image: \"http://ecx.images-amazon.com/images/I/71ws-s180zL._SS100_.png\"\n};\n_navbar.browsepromos[\"audible\"] = {\n    width: 479,\n    promoType: \"wide\",\n    vertOffset: \"0\",\n    horizOffset: \"-19\",\n    height: 470,\n    image: \"http://g-ecx.images-amazon.com/images/G/01/Audible/en_US/images/creative/amazon/beacon/ADBLECRE_2309_Beacon_Headphones_mystery_thehit._V382182717_.png\"\n};\n_navbar.browsepromos[\"automotive-industrial\"] = {\n    width: 479,\n    promoType: \"wide\",\n    vertOffset: \"0\",\n    horizOffset: \"0\",\n    height: 472,\n    image: \"http://g-ecx.images-amazon.com/images/G/01/BISS/stores/homepage/flyouts/julyGNO._V381261427_.png\"\n};\n_navbar.browsepromos[\"books\"] = {\n    width: 495,\n    promoType: \"wide\",\n    vertOffset: \"0\",\n    horizOffset: \"0\",\n    height: 472,\n    image: \"http://g-ecx.images-amazon.com/images/G/01/img13/books/flyout/books_botysf_flyout_kids-2._V380040471_.png\"\n};\n_navbar.browsepromos[\"clothing-shoes-jewelry\"] = {\n    width: 460,\n    promoType: \"wide\",\n    vertOffset: \"0\",\n    horizOffset: \"-20\",\n    height: 472,\n    image: \"http://g-ecx.images-amazon.com/images/G/01/AMAZON_FASHION/2013/GATEWAY/BTS1/FLYOUTS/FO_watch._V381438784_.png\"\n};\n_navbar.browsepromos[\"cloud-drive\"] = {\n    width: 480,\n    promoType: \"wide\",\n    vertOffset: \"0\",\n    horizOffset: \"0\",\n    height: 472,\n    image: \"http://g-ecx.images-amazon.com/images/G/01/digital/adrive/images/gno/iOs_GNO1._V385462964_.jpg\"\n};\n_navbar.browsepromos[\"digital-games-software\"] = {\n    width: 518,\n    promoType: \"wide\",\n    vertOffset: \"0\",\n    horizOffset: \"-19\",\n    height: 472,\n    image: \"http://g-ecx.images-amazon.com/images/G/01/img13/digital-video-games/flyout/0610-dvg-civ-flyout-b._V382016459_.png\"\n};\n_navbar.browsepromos[\"electronics-computers\"] = {\n    width: 498,\n    promoType: \"wide\",\n    vertOffset: \"0\",\n    horizOffset: \"0\",\n    height: 228,\n    image: \"http://g-ecx.images-amazon.com/images/G/01/img13/camera-photo/flyout/7-1_-confidential-canon_GNO._V379604226_.png\"\n};\n_navbar.browsepromos[\"grocery-health-beauty\"] = {\n    width: 496,\n    promoType: \"wide\",\n    vertOffset: \"0\",\n    horizOffset: \"0\",\n    height: 471,\n    image: \"http://g-ecx.images-amazon.com/images/G/01/img13/wine/flyout/0702_wine_international_flyout.v2._V379935612_.png\"\n};\n_navbar.browsepromos[\"home-garden-tools\"] = {\n    width: 492,\n    promoType: \"wide\",\n    vertOffset: 0,\n    horizOffset: 0,\n    height: 287,\n    image: \"http://g-ecx.images-amazon.com/images/G/01/img13/home/flyout/7-9_furniture-photo-shoot_flyout._V379916182_.png\"\n};\n_navbar.browsepromos[\"instant-video\"] = {\n    width: 500,\n    promoType: \"wide\",\n    vertOffset: \"-10\",\n    horizOffset: \"-20\",\n    height: 495,\n    image: \"http://g-ecx.images-amazon.com/images/G/01/digital/video/merch/UnderTheDome/AIV_GNO-Flyout_UTDPostLaunchV2._V381606810_.png\"\n};\n_navbar.browsepromos[\"kindle\"] = {\n    width: 440,\n    promoType: \"wide\",\n    vertOffset: \"-35\",\n    horizOffset: \"28\",\n    height: 151,\n    image: \"http://g-ecx.images-amazon.com/images/G/01/gno/beacon/merch/browse/gno-family-440x151._V389693769_.png\"\n};\n_navbar.browsepromos[\"movies-music-games\"] = {\n    width: 524,\n    promoType: \"wide\",\n    vertOffset: \"-25\",\n    horizOffset: \"-21\",\n    height: 493,\n    image: \"http://g-ecx.images-amazon.com/images/G/01/img13/movies-tv/flyout/0628b-bsf-movie-n-music-flyout._V380036698_.png\"\n};\n_navbar.browsepromos[\"mp3\"] = {\n    width: 520,\n    promoType: \"wide\",\n    vertOffset: \"-20\",\n    horizOffset: \"-21\",\n    height: 492,\n    image: \"http://g-ecx.images-amazon.com/images/G/01/digital/music/mp3/flyout/JayZ_Flyout_1._V380151426_.png\"\n};\n_navbar.browsepromos[\"sports-outdoors\"] = {\n    width: 500,\n    promoType: \"wide\",\n    vertOffset: \"0\",\n    horizOffset: \"-20\",\n    height: 487,\n    image: \"http://g-ecx.images-amazon.com/images/G/01/img13/sports-outdoors/flyout/sgfitness._V382533691_.png\"\n};\n_navbar.browsepromos[\"toys-kids-baby\"] = {\n    width: 479,\n    promoType: \"wide\",\n    vertOffset: \"0\",\n    horizOffset: \"0\",\n    height: 395,\n    image: \"http://g-ecx.images-amazon.com/images/G/01/img13/babyregistry/2013sweepstakes/flyout/baby_2013sweeps_flyout._V381448744_.jpg\"\n};\n((window.$Nav && $Nav.declare(\"config.browsePromos\", window._navbar.browsepromos)));\n((window.amznJQ && amznJQ.declareAvailable(\"navbarPromosContent\")));");
// 877
o5 = {};
// 878
f881945950_65.returns.push(o5);
// 879
// 875
geval("(function() {\n    var availableWidth = ((((window.JSBNG__innerWidth || JSBNG__document.body.offsetWidth)) - 1));\n;\n    var widths = [1280,];\n    var imageHashMain = [\"http://ecx.images-amazon.com/images/I/51gdVAEfPUL._BO2,204,203,200_PIsitb-sticker-arrow-click,TopRight,35,-76_AA300_SH20_OU01_.jpg\",\"http://ecx.images-amazon.com/images/I/51gdVAEfPUL._BO2,204,203,200_PIsitb-sticker-arrow-click,TopRight,35,-76_AA300_SH20_OU01_.jpg\",];\n    var imageObj = new JSBNG__Image();\n    var sz = 0;\n    for (; ((((sz < widths.length)) && ((availableWidth >= widths[sz])))); sz++) {\n    ;\n    };\n;\n    imageObj.src = imageHashMain[sz];\n})();");
// 880
geval("function eba5e792808f98ffad2199c25c3f252962a7697cd(JSBNG__event) {\n;\n    if (((typeof measureATFDiff == \"function\"))) {\n        measureATFDiff(new JSBNG__Date().getTime(), 0);\n    }\n;\n;\n;\n    if (((typeof setCSMReq == \"function\"))) {\n        setCSMReq(\"af\");\n        setCSMReq(\"cf\");\n    }\n     else if (((typeof uet == \"function\"))) {\n        uet(\"af\");\n        uet(\"cf\");\n        amznJQ.completedStage(\"amznJQ.AboveTheFold\");\n    }\n    \n;\n;\n};\n;");
// 881
geval("function e5209abad2ea9a8e8a3d19b988fd4501696abff96(JSBNG__event) {\n    return false;\n};\n;");
// 883
f881945950_406 = function() { return f881945950_406.returns[f881945950_406.inst++]; };
f881945950_406.returns = [];
f881945950_406.inst = 0;
// 884
o0.getElementById = f881945950_406;
// 885
o6 = {};
// 886
f881945950_406.returns.push(o6);
// 889
o7 = {};
// 890
f881945950_406.returns.push(o7);
// 891
o7.className = "size0 bottom-thumbs main-image-widget-for-dp standard";
// 892
// 893
// 894
// 895
o8 = {};
// 896
o6.style = o8;
// 897
// 882
geval("var colorImages = {\n    initial: [{\n        large: \"http://ecx.images-amazon.com/images/I/51gdVAEfPUL.jpg\",\n        landing: [\"http://ecx.images-amazon.com/images/I/51gdVAEfPUL._BO2,204,203,200_PIsitb-sticker-arrow-click,TopRight,35,-76_AA300_SH20_OU01_.jpg\",],\n        hiRes: \"http://ecx.images-amazon.com/images/I/814biaGJWaL._SL1500_.jpg\",\n        thumb: \"http://ecx.images-amazon.com/images/I/51gdVAEfPUL._SS30_.jpg\",\n        main: [\"http://ecx.images-amazon.com/images/I/51gdVAEfPUL._BO2,204,203,200_PIsitb-sticker-arrow-click,TopRight,35,-76_AA300_SH20_OU01_.jpg\",\"http://ecx.images-amazon.com/images/I/51gdVAEfPUL._BO2,204,203,200_PIsitb-sticker-arrow-click,TopRight,35,-76_AA300_SH20_OU01_.jpg\",]\n    },]\n};\n(function(doc) {\n    var mi = doc.getElementById(\"main-image\");\n    var w = ((window.JSBNG__innerWidth || doc.body.offsetWidth));\n    w--;\n    var widths = [1280,];\n    var sz = 0;\n    for (; ((((sz < 1)) && ((w >= widths[sz])))); sz++) {\n    ;\n    };\n;\n    if (((sz || 1))) {\n        var miw = doc.getElementById(\"main-image-widget\");\n        miw.className = miw.className.replace(/size[0-9]+/, ((\"size\" + sz)));\n        if (((sz && 1))) {\n            mi.width = 300;\n            mi.height = 300;\n        }\n         else if (((!sz && 1))) {\n            mi.width = 300;\n            mi.height = 300;\n        }\n        \n    ;\n    ;\n        amznJQ.onCompletion(\"amznJQ.AboveTheFold\", function() {\n            var src = colorImages.initial[0].main[sz];\n            var img = new JSBNG__Image();\n            img.JSBNG__onload = function() {\n                var clone = mi.cloneNode(true);\n                clone.src = src;\n                clone.removeAttribute(\"width\");\n                clone.removeAttribute(\"height\");\n                clone.removeAttribute(\"JSBNG__onload\");\n                mi.parentNode.replaceChild(clone, mi);\n                mi = clone;\n                amznJQ.declareAvailable(\"ImageBlockATF\");\n            };\n            img.src = src;\n        });\n    }\n     else {\n        amznJQ.declareAvailable(\"ImageBlockATF\");\n    }\n;\n;\n    mi.style.display = \"inline\";\n})(JSBNG__document);");
// 898
geval("function ea61dd9757a317a235aa0212a7a482613abe637a5(JSBNG__event) {\n    if (((typeof (SitbReader) != \"undefined\"))) {\n        SitbReader.LightboxActions.openReader(\"sib_dp_ptu\");\n        return false;\n    }\n;\n;\n};\n;");
// 899
geval("var legacyOnSelectedQuantityChange = function() {\n    if (((jQuery(\"#pricePlusShippingQty\").length > 0))) {\n        jQuery.ajax({\n            url: \"/gp/product/du/quantity-sip-update.html\",\n            data: {\n                qt: jQuery(\"#quantityDropdownDiv select\").val(),\n                a: jQuery(\"#ASIN\").val(),\n                me: jQuery(\"#merchantID\").val()\n            },\n            dataType: \"html\",\n            success: function(sipHtml) {\n                jQuery(\"#pricePlusShippingQty\").html(sipHtml);\n            }\n        });\n    }\n;\n;\n};\namznJQ.onReady(\"jQuery\", function() {\n    jQuery(\"#quantityDropdownDiv select\").change(legacyOnSelectedQuantityChange);\n    amznJQ.onCompletion(\"amznJQ.criticalFeature\", function() {\n        amznJQ.available(\"quantityDropDownJS\", function() {\n            var qdd = new jQuery.fn.quantityDropDown();\n            qdd.setPopoverContent(\"\\u003Cstrong\\u003EWe're sorry.  This item is limited to %d per customer.\\u003C/strong\\u003E\", \"\\u003Cbr /\\u003E\\u003Cbr /\\u003EWe strive to provide customers with great prices, and sometimes that means we limit quantity to ensure that the majority of customers have an opportunity to order products that have very low prices or a limited supply.\\u003Cbr /\\u003E\\u003Cbr /\\u003EWe may also adjust quantity in checkout if you have recently purchased this item.\");\n        });\n    });\n});");
// 900
geval("amznJQ.onCompletion(\"amznJQ.criticalFeature\", function() {\n    amznJQ.available(\"bbopCheckBoxJS\", function() {\n        var bbopJS = new jQuery.fn.bbopCheckBox();\n        bbopJS.initialize(1, 0, \"To get FREE Two-Day Shipping on this item, proceed to checkout using &quot;Add to Cart&quot;\");\n    });\n});");
// 901
geval("var gbSecure1Click = true;\nif (((((typeof (gbSecure1Click) != \"undefined\")) && gbSecure1Click))) {\n    amznJQ.onReady(\"jQuery\", function() {\n        jQuery(\"#oneClickBuyButton\").click(function() {\n            var hbbAction = jQuery(\"#handleBuy\").attr(\"action\").replace(\"http:\", \"https:\");\n            jQuery(\"#handleBuy\").attr(\"action\", hbbAction);\n            return true;\n        });\n    });\n}\n;\n;");
// 902
geval("if (window.gbvar) {\n    amznJQ.onReady(\"jQuery\", function() {\n        jQuery(\"#oneClickSignInLinkID\").attr(\"href\", window.gbvar);\n    });\n}\n else {\n    window.gbvar = \"http://jsbngssl.www.amazon.com/gp/product/utility/edit-one-click-pref.html?ie=UTF8&query=selectObb%3Dnew&returnPath=%2Fgp%2Fproduct%2F0596517742\";\n}\n;\n;");
// 904
o2 = {};
// 905
f881945950_0.returns.push(o2);
// 906
o2.getTime = f881945950_397;
// undefined
o2 = null;
// 907
f881945950_397.returns.push(1373479178221);
// 908
o4 = {};
// 909
f881945950_65.returns.push(o4);
// 910
// 911
// undefined
o4 = null;
// 903
geval("if (window.gbvar) {\n    amznJQ.onReady(\"jQuery\", function() {\n        jQuery(\"#oneClickSignInLinkID\").attr(\"href\", window.gbvar);\n    });\n}\n else {\n    window.gbvar = \"http://jsbngssl.www.amazon.com/gp/product/utility/edit-one-click-pref.html?ie=UTF8&query=selectObb%3Dnew&returnPath=%2Fgp%2Fproduct%2F0596517742\";\n}\n;\n;");
// 914
o5 = {};
// 915
f881945950_65.returns.push(o5);
// 916
// undefined
o5 = null;
// 912
geval("(function() {\n    var availableWidth = ((((window.JSBNG__innerWidth || JSBNG__document.body.offsetWidth)) - 1));\n;\n    var widths = [1280,];\n    var imageHashMain = [\"http://ecx.images-amazon.com/images/I/51gdVAEfPUL._BO2,204,203,200_PIsitb-sticker-arrow-click,TopRight,35,-76_AA300_SH20_OU01_.jpg\",\"http://ecx.images-amazon.com/images/I/51gdVAEfPUL._BO2,204,203,200_PIsitb-sticker-arrow-click,TopRight,35,-76_AA300_SH20_OU01_.jpg\",];\n    var imageObj = new JSBNG__Image();\n    var sz = 0;\n    for (; ((((sz < widths.length)) && ((availableWidth >= widths[sz])))); sz++) {\n    ;\n    };\n;\n    imageObj.src = imageHashMain[sz];\n})();");
// 917
geval("function eba5e792808f98ffad2199c25c3f252962a7697cd(JSBNG__event) {\n;\n    if (((typeof measureATFDiff == \"function\"))) {\n        measureATFDiff(new JSBNG__Date().getTime(), 0);\n    }\n;\n;\n;\n    if (((typeof setCSMReq == \"function\"))) {\n        setCSMReq(\"af\");\n        setCSMReq(\"cf\");\n    }\n     else if (((typeof uet == \"function\"))) {\n        uet(\"af\");\n        uet(\"cf\");\n        amznJQ.completedStage(\"amznJQ.AboveTheFold\");\n    }\n    \n;\n;\n};\n;");
// 918
geval("function e5209abad2ea9a8e8a3d19b988fd4501696abff96(JSBNG__event) {\n    return false;\n};\n;");
// 920
f881945950_406 = function() { return f881945950_406.returns[f881945950_406.inst++]; };
f881945950_406.returns = [];
f881945950_406.inst = 0;
// 922
o6 = {};
// 923
f881945950_406.returns.push(o6);
// 926
o7 = {};
// 927
f881945950_406.returns.push(o7);
// 928
o7.className = "size0 bottom-thumbs main-image-widget-for-dp standard";
// 929
// undefined
o7 = null;
// 930
// 931
// 932
o8 = {};
// 933
o6.style = o8;
// undefined
o6 = null;
// 934
// undefined
o8 = null;
// 919
geval("var colorImages = {\n    initial: [{\n        large: \"http://ecx.images-amazon.com/images/I/51gdVAEfPUL.jpg\",\n        landing: [\"http://ecx.images-amazon.com/images/I/51gdVAEfPUL._BO2,204,203,200_PIsitb-sticker-arrow-click,TopRight,35,-76_AA300_SH20_OU01_.jpg\",],\n        hiRes: \"http://ecx.images-amazon.com/images/I/814biaGJWaL._SL1500_.jpg\",\n        thumb: \"http://ecx.images-amazon.com/images/I/51gdVAEfPUL._SS30_.jpg\",\n        main: [\"http://ecx.images-amazon.com/images/I/51gdVAEfPUL._BO2,204,203,200_PIsitb-sticker-arrow-click,TopRight,35,-76_AA300_SH20_OU01_.jpg\",\"http://ecx.images-amazon.com/images/I/51gdVAEfPUL._BO2,204,203,200_PIsitb-sticker-arrow-click,TopRight,35,-76_AA300_SH20_OU01_.jpg\",]\n    },]\n};\n(function(doc) {\n    var mi = doc.getElementById(\"main-image\");\n    var w = ((window.JSBNG__innerWidth || doc.body.offsetWidth));\n    w--;\n    var widths = [1280,];\n    var sz = 0;\n    for (; ((((sz < 1)) && ((w >= widths[sz])))); sz++) {\n    ;\n    };\n;\n    if (((sz || 1))) {\n        var miw = doc.getElementById(\"main-image-widget\");\n        miw.className = miw.className.replace(/size[0-9]+/, ((\"size\" + sz)));\n        if (((sz && 1))) {\n            mi.width = 300;\n            mi.height = 300;\n        }\n         else if (((!sz && 1))) {\n            mi.width = 300;\n            mi.height = 300;\n        }\n        \n    ;\n    ;\n        amznJQ.onCompletion(\"amznJQ.AboveTheFold\", function() {\n            var src = colorImages.initial[0].main[sz];\n            var img = new JSBNG__Image();\n            img.JSBNG__onload = function() {\n                var clone = mi.cloneNode(true);\n                clone.src = src;\n                clone.removeAttribute(\"width\");\n                clone.removeAttribute(\"height\");\n                clone.removeAttribute(\"JSBNG__onload\");\n                mi.parentNode.replaceChild(clone, mi);\n                mi = clone;\n                amznJQ.declareAvailable(\"ImageBlockATF\");\n            };\n            img.src = src;\n        });\n    }\n     else {\n        amznJQ.declareAvailable(\"ImageBlockATF\");\n    }\n;\n;\n    mi.style.display = \"inline\";\n})(JSBNG__document);");
// 935
geval("function ea61dd9757a317a235aa0212a7a482613abe637a5(JSBNG__event) {\n    if (((typeof (SitbReader) != \"undefined\"))) {\n        SitbReader.LightboxActions.openReader(\"sib_dp_ptu\");\n        return false;\n    }\n;\n;\n};\n;");
// 936
geval("var legacyOnSelectedQuantityChange = function() {\n    if (((jQuery(\"#pricePlusShippingQty\").length > 0))) {\n        jQuery.ajax({\n            url: \"/gp/product/du/quantity-sip-update.html\",\n            data: {\n                qt: jQuery(\"#quantityDropdownDiv select\").val(),\n                a: jQuery(\"#ASIN\").val(),\n                me: jQuery(\"#merchantID\").val()\n            },\n            dataType: \"html\",\n            success: function(sipHtml) {\n                jQuery(\"#pricePlusShippingQty\").html(sipHtml);\n            }\n        });\n    }\n;\n;\n};\namznJQ.onReady(\"jQuery\", function() {\n    jQuery(\"#quantityDropdownDiv select\").change(legacyOnSelectedQuantityChange);\n    amznJQ.onCompletion(\"amznJQ.criticalFeature\", function() {\n        amznJQ.available(\"quantityDropDownJS\", function() {\n            var qdd = new jQuery.fn.quantityDropDown();\n            qdd.setPopoverContent(\"\\u003Cstrong\\u003EWe're sorry.  This item is limited to %d per customer.\\u003C/strong\\u003E\", \"\\u003Cbr /\\u003E\\u003Cbr /\\u003EWe strive to provide customers with great prices, and sometimes that means we limit quantity to ensure that the majority of customers have an opportunity to order products that have very low prices or a limited supply.\\u003Cbr /\\u003E\\u003Cbr /\\u003EWe may also adjust quantity in checkout if you have recently purchased this item.\");\n        });\n    });\n});");
// 937
geval("amznJQ.onCompletion(\"amznJQ.criticalFeature\", function() {\n    amznJQ.available(\"bbopCheckBoxJS\", function() {\n        var bbopJS = new jQuery.fn.bbopCheckBox();\n        bbopJS.initialize(1, 0, \"To get FREE Two-Day Shipping on this item, proceed to checkout using &quot;Add to Cart&quot;\");\n    });\n});");
// 938
geval("var gbSecure1Click = true;\nif (((((typeof (gbSecure1Click) != \"undefined\")) && gbSecure1Click))) {\n    amznJQ.onReady(\"jQuery\", function() {\n        jQuery(\"#oneClickBuyButton\").click(function() {\n            var hbbAction = jQuery(\"#handleBuy\").attr(\"action\").replace(\"http:\", \"https:\");\n            jQuery(\"#handleBuy\").attr(\"action\", hbbAction);\n            return true;\n        });\n    });\n}\n;\n;");
// 939
geval("if (window.gbvar) {\n    amznJQ.onReady(\"jQuery\", function() {\n        jQuery(\"#oneClickSignInLinkID\").attr(\"href\", window.gbvar);\n    });\n}\n else {\n    window.gbvar = \"http://jsbngssl.www.amazon.com/gp/product/utility/edit-one-click-pref.html?ie=UTF8&query=selectObb%3Dnew&returnPath=%2Fgp%2Fproduct%2F0596517742\";\n}\n;\n;");
// 941
o2 = {};
// undefined
o2 = null;
// 940
geval("if (window.gbvar) {\n    amznJQ.onReady(\"jQuery\", function() {\n        jQuery(\"#oneClickSignInLinkID\").attr(\"href\", window.gbvar);\n    });\n}\n else {\n    window.gbvar = \"http://jsbngssl.www.amazon.com/gp/product/utility/edit-one-click-pref.html?ie=UTF8&query=selectObb%3Dnew&returnPath=%2Fgp%2Fproduct%2F0596517742\";\n}\n;\n;");
// 942
geval("amznJQ.onReady(\"jQuery\", function() {\n    if (((((((typeof dpLdWidget !== \"undefined\")) && ((typeof dpLdWidget.deal !== \"undefined\")))) && ((typeof dpLdWidget.deal.asins !== \"undefined\"))))) {\n        var dealPriceText;\n        if (((((((typeof Deal !== \"undefined\")) && ((typeof Deal.Price !== \"undefined\")))) && ((typeof dpLdWidget.deal.asins[0] !== \"undefined\"))))) {\n            var dp = dpLdWidget.deal.asins[0].dealPrice;\n            if (((dp.price > 396))) {\n                dealPriceText = Deal.Price.format(dp);\n                jQuery(\"#rbb_bb_trigger .bb_price, #rentalPriceBlockGrid .buyNewOffers .rentPrice\").html(dealPriceText);\n            }\n        ;\n        ;\n        }\n    ;\n    ;\n    }\n;\n;\n    jQuery(\"#rbbContainer .rbb_section .rbb_header\").click(function(e) {\n        var target = jQuery(e.target);\n        if (!target.hasClass(\"rbb_header\")) {\n            target.parents(\".rbbHeaderLink\").attr(\"href\", \"javascript:void(0);\");\n        }\n    ;\n    ;\n        var t = jQuery(this);\n        var header = ((t.hasClass(\"rbb_header\") ? t : t.parents(\".rbb_header\")));\n        if (header.parents(\".rbb_section\").hasClass(\"selected\")) {\n            return false;\n        }\n    ;\n    ;\n        jQuery(\"#radiobuyboxDivId .bb_radio\").attr(\"checked\", false);\n        header.JSBNG__find(\".bb_radio\").attr(\"checked\", \"checked\");\n        header.parents(\".rbb_section\").removeClass(\"unselected\").addClass(\"selected\");\n        jQuery(\"#radiobuyboxDivId .abbListInput\").attr(\"checked\", false);\n        var bbClicked = jQuery(this).attr(\"id\");\n        var slideMeDown, slideMeUp;\n        jQuery(\"#radiobuyboxDivId .rbb_section\").each(function(i, bb) {\n            if (((jQuery(bb).JSBNG__find(\".rbb_header\")[0].id == bbClicked))) {\n                slideMeDown = jQuery(bb);\n            }\n             else if (jQuery(bb).hasClass(\"selected\")) {\n                slideMeUp = jQuery(bb);\n            }\n            \n        ;\n        ;\n        });\n        slideMeUp.JSBNG__find(\".rbb_content\").slideUp(500, function() {\n            slideMeUp.removeClass(\"selected\").addClass(\"unselected\");\n        });\n        slideMeDown.JSBNG__find(\".rbb_content\").slideDown(500);\n        JSBNG__location.hash = ((\"#selectedObb=\" + header.attr(\"id\")));\n        return true;\n    });\n    var locationHash = JSBNG__location.hash;\n    if (((locationHash.length != 0))) {\n        var selectObb = locationHash.substring(1).split(\"=\")[1];\n        if (((typeof (selectObb) != \"undefined\"))) {\n            var target = jQuery(((\"#\" + selectObb)));\n            if (((target.length != 0))) {\n                target.trigger(\"click\");\n            }\n        ;\n        ;\n        }\n    ;\n    ;\n    }\n;\n;\n});");
// 943
geval("function e0ad247b2845d5a62f8d680c69024109c41a3aba5(JSBNG__event) {\n    return false;\n};\n;");
// 944
geval("if (((typeof window.amznJQ != \"undefined\"))) {\n    amznJQ.onReady(\"popover\", function() {\n        jQuery(\"#tradeinBuyboxLearnMore\").amazonPopoverTrigger({\n            closeText: \"Close\",\n            width: 580,\n            group: \"tradein\",\n            destination: \"/gp/tradein/popovers/ajax-popover.html?ie=UTF8&name=howToTradeIn\",\n            title: \"How to Trade In\"\n        });\n    });\n}\n;\n;");
// 945
geval("function ef6ad9c87b00e618dc7a9b5e5140bbc8ba2edd739(JSBNG__event) {\n    window.open(this.href, \"_blank\", \"location=yes,width=700,height=400\");\n    return false;\n};\n;");
// 946
geval("function ed3bd13821903ecb97b20e31910662670d650c5cb(JSBNG__event) {\n    window.open(this.href, \"_blank\", \"location=yes,width=700,height=400\");\n    return false;\n};\n;");
// 947
geval("function ea6dbd42abc1e9b3dbebd197268ce92a9b0e0b4ad(JSBNG__event) {\n    window.open(this.href, \"_blank\", \"location=yes,width=700,height=570\");\n    return false;\n};\n;");
// 948
geval("if (((typeof window.amznJQ != \"undefined\"))) {\n    amznJQ.onCompletion(\"amznJQ.criticalFeature\", function() {\n        amznJQ.available(\"share-with-friends-js-new\", function() {\n            var popoverParams = {\n                url: \"/gp/pdp/taf/dpPop.html/ref=cm_sw_p_view_dp_geA3rb04T691F?ie=UTF8&contentID=0596517742&contentName=item&contentType=asin&contentURI=%2Fdp%2F0596517742&emailCaptionStrID=&emailCustomMsgStrID=&emailDescStrID=&emailSubjectStrID=&emailTemplate=%2Fgp%2Fpdp%2Fcommon%2Femail%2Fshare-product&forceSprites=1&id=0596517742&imageURL=&isDynamicSWF=0&isEmail=0&learnMoreButton=&merchantID=&parentASIN=0596517742&placementID=dp_geA3rb04T691F&ra=taf&referer=http%253A%252F%252Fwww.amazon.com%252Fgp%252Fproduct%252F0596517742%252Fref%253D&relatedAccounts=amazondeals%2Camazonmp3&suppressPurchaseReqLogin=&titleText=&tt=sh&viaAccount=amazon\",\n                title: \"Share this item via Email\",\n                closeText: \"Close\",\n                isCompact: false\n            };\n            amz_taf_triggers.swftext = popoverParams;\n            amz_taf_generatePopover(\"swftext\", false);\n        });\n    });\n}\n;\n;");
// 949
geval("amznJQ.onReady(\"bylinePopover\", function() {\n\n});");
// 950
geval("function acrPopoverHover(e, h) {\n    if (h) {\n        window.acrAsinHover = e;\n    }\n     else {\n        if (((window.acrAsinHover == e))) {\n            window.acrAsinHover = null;\n        }\n    ;\n    }\n;\n;\n};\n;\namznJQ.onReady(\"popover\", function() {\n    (function($) {\n        if ($.fn.acrPopover) {\n            return;\n        }\n    ;\n    ;\n        var popoverConfig = {\n            showOnHover: true,\n            showCloseButton: true,\n            width: null,\n            JSBNG__location: \"bottom\",\n            locationAlign: \"left\",\n            locationOffset: [-20,0,],\n            paddingLeft: 15,\n            paddingBottom: 5,\n            paddingRight: 15,\n            group: \"reviewsPopover\",\n            clone: false,\n            hoverHideDelay: 300\n        };\n        $.fn.acrPopover = function() {\n            return this.each(function() {\n                var $this = $(this);\n                if (!$this.data(\"init\")) {\n                    $this.data(\"init\", 1);\n                    var getargs = $this.attr(\"getargs\");\n                    var ajaxURL = ((((((((((((((\"/gp/customer-reviews/common/du/displayHistoPopAjax.html?\" + \"&ASIN=\")) + $this.attr(\"JSBNG__name\"))) + \"&link=1\")) + \"&seeall=1\")) + \"&ref=\")) + $this.attr(\"ref\"))) + ((((typeof getargs != \"undefined\")) ? ((\"&getargs=\" + getargs)) : \"\"))));\n                    var myConfig = $.extend(true, {\n                        destination: ajaxURL\n                    }, popoverConfig);\n                    $this.amazonPopoverTrigger(myConfig);\n                    var w = window.acrAsinHover;\n                    if (((w && (($(w).parents(\".asinReviewsSummary\").get(0) == this))))) {\n                        $this.trigger(\"mouseover.amzPopover\");\n                        window.acrAsinHover = null;\n                    }\n                ;\n                ;\n                }\n            ;\n            ;\n            });\n        };\n        window.reviewHistPopoverConfig = popoverConfig;\n        var jqInit = window.jQueryInitHistoPopovers = function(asin) {\n            $(((((\".acr-popover[name=\" + asin)) + \"]\"))).acrPopover();\n        };\n        window.doInit_average_customer_reviews = jqInit;\n        window.onAjaxUpdate_average_customer_reviews = jqInit;\n        window.onCacheUpdate_average_customer_reviews = jqInit;\n        window.onCacheUpdateReselect_average_customer_reviews = jqInit;\n        amznJQ.onCompletion(\"amznJQ.criticalFeature\", function() {\n            JSBNG__setTimeout(function() {\n                amznJQ.declareAvailable(\"acrPopover\");\n            }, 10);\n        });\n    })(jQuery);\n});\namznJQ.onReady(\"acrPopover\", function() {\n    jQuery(\".acr-popover,#searchTemplate .asinReviewsSummary\").each(function() {\n        jQuery(this).acrPopover();\n    });\n});");
// 951
geval("function ed2276bf20246f30c68990f23f81d89eadb38c166(JSBNG__event) {\n    return acrPopoverHover(this, 1);\n};\n;");
// 952
geval("function ecf07c0edda27bc80d526213d7c6929ffbddc8bbc(JSBNG__event) {\n    return acrPopoverHover(this, 0);\n};\n;");
// 953
geval("function efaf91b69248e7e79f131f7036cba56d101e7bfb6(JSBNG__event) {\n    return acrPopoverHover(this, 1);\n};\n;");
// 954
geval("function efb799c660c9baca416793b32167d426e04dee131(JSBNG__event) {\n    return acrPopoverHover(this, 0);\n};\n;");
// 955
geval("function e454b94055c2707a9784ef2ca3e2fe7a272f31974(JSBNG__event) {\n    return amz_js_PopWin(\"/gp/help/customer/display.html/ref=mk_sss_dp_1?ie=UTF8&nodeId=527692&pop-up=1\", \"AmazonHelp\", \"width=550,height=550,resizable=1,scrollbars=1,toolbar=0,status=0\");\n};\n;");
// 956
geval("amznJQ.declareAvailable(\"gbPriceBlockFields\");");
// 958
o2 = {};
// 959
f881945950_0.returns.push(o2);
// 960
f881945950_413 = function() { return f881945950_413.returns[f881945950_413.inst++]; };
f881945950_413.returns = [];
f881945950_413.inst = 0;
// 961
o2.getHours = f881945950_413;
// 962
f881945950_413.returns.push(13);
// 963
f881945950_414 = function() { return f881945950_414.returns[f881945950_414.inst++]; };
f881945950_414.returns = [];
f881945950_414.inst = 0;
// 964
o2.getMinutes = f881945950_414;
// 965
f881945950_414.returns.push(59);
// 966
f881945950_415 = function() { return f881945950_415.returns[f881945950_415.inst++]; };
f881945950_415.returns = [];
f881945950_415.inst = 0;
// 967
o2.getSeconds = f881945950_415;
// 968
f881945950_415.returns.push(38);
// 969
o4 = {};
// 970
f881945950_0.returns.push(o4);
// 971
o4.getHours = f881945950_413;
// 972
f881945950_413.returns.push(13);
// 973
o4.getMinutes = f881945950_414;
// 974
f881945950_414.returns.push(59);
// 975
o4.getSeconds = f881945950_415;
// 976
f881945950_415.returns.push(38);
// 977
o0.layers = void 0;
// 978
o0.all = void 0;
// 981
f881945950_406.returns.push(null);
// 986
f881945950_406.returns.push(null);
// 987
f881945950_16.returns.push(2);
// 957
geval("try {\n    var ftCountdownElementIDs = new Array();\n    var ftEntireMessageElementIDs = new Array();\n    var FT_CurrentDisplayMin = new Array();\n    var clientServerTimeDrift;\n    var firstTimeUpdate = false;\n    function ftRegisterCountdownElementID(elementID) {\n        ftCountdownElementIDs[ftCountdownElementIDs.length] = elementID;\n    };\n;\n    function ftRegisterEntireMessageElementID(elementID) {\n        ftEntireMessageElementIDs[ftEntireMessageElementIDs.length] = elementID;\n    };\n;\n    function getTimeRemainingString(hours, minutes) {\n        var hourString = ((((hours == 1)) ? \"hr\" : \"hrs\"));\n        var minuteString = ((((minutes == 1)) ? \"min\" : \"mins\"));\n        if (((hours == 0))) {\n            return ((((minutes + \" \")) + minuteString));\n        }\n    ;\n    ;\n        if (((minutes == 0))) {\n            return ((((hours + \" \")) + hourString));\n        }\n    ;\n    ;\n        return ((((((((((((hours + \" \")) + hourString)) + \" \")) + minutes)) + \" \")) + minuteString));\n        return ((((((((((((hours + \" \")) + hourString)) + \"  \")) + minutes)) + \" \")) + minuteString));\n    };\n;\n    function FT_displayCountdown(forceUpdate) {\n        if (((((!JSBNG__document.layers && !JSBNG__document.all)) && !JSBNG__document.getElementById))) {\n            return;\n        }\n    ;\n    ;\n        FT_showHtmlElement(\"ftShipString\", true, \"inline\");\n        var FT_remainSeconds = ((FT_givenSeconds - FT_actualSeconds));\n        if (((FT_remainSeconds < 1))) {\n            FT_showEntireMessageElement(false);\n        }\n    ;\n    ;\n        var FT_secondsPerDay = ((((24 * 60)) * 60));\n        var FT_daysLong = ((FT_remainSeconds / FT_secondsPerDay));\n        var FT_days = Math.floor(FT_daysLong);\n        var FT_hoursLong = ((((FT_daysLong - FT_days)) * 24));\n        var FT_hours = Math.floor(FT_hoursLong);\n        var FT_minsLong = ((((FT_hoursLong - FT_hours)) * 60));\n        var FT_mins = Math.floor(FT_minsLong);\n        var FT_secsLong = ((((FT_minsLong - FT_mins)) * 60));\n        var FT_secs = Math.floor(FT_secsLong);\n        if (((FT_days > 0))) {\n            FT_hours = ((((FT_days * 24)) + FT_hours));\n        }\n    ;\n    ;\n        window.JSBNG__setTimeout(\"FT_getTime()\", 1000);\n        var ftCountdown = getTimeRemainingString(FT_hours, FT_mins);\n        for (var i = 0; ((i < ftCountdownElementIDs.length)); i++) {\n            var countdownElement = JSBNG__document.getElementById(ftCountdownElementIDs[i]);\n            if (countdownElement) {\n                if (((((((((FT_CurrentDisplayMin[i] != FT_mins)) || forceUpdate)) || ((countdownElement.innerHTML == \"\")))) || firstTimeUpdate))) {\n                    countdownElement.innerHTML = ftCountdown;\n                    FT_CurrentDisplayMin[i] = FT_mins;\n                    firstTimeUpdate = false;\n                }\n            ;\n            ;\n            }\n        ;\n        ;\n        };\n    ;\n    };\n;\n    function FT_showEntireMessageElement(shouldShow) {\n        for (var i = 0; ((i < ftEntireMessageElementIDs.length)); i++) {\n            FT_showHtmlElement(ftEntireMessageElementIDs[i], shouldShow);\n        };\n    ;\n    };\n;\n    function FT_showHtmlElement(elementID, shouldShow, displayStyle) {\n        var element = JSBNG__document.getElementById(elementID);\n        if (element) {\n            if (shouldShow) {\n                element.style.display = ((((displayStyle != null)) ? displayStyle : \"\"));\n            }\n             else {\n                element.style.display = \"none\";\n            }\n        ;\n        ;\n        }\n    ;\n    ;\n    };\n;\n    function FT_getAndClearCutOffEpochSeconds() {\n        var ftCutOffEpochSecondsElementID = \"ftCutOffEpochSeconds\";\n        var ftServerCurrentEpochSecondsElementID = \"ftServerCurrentEpochSeconds\";\n        if (((((JSBNG__document.layers || JSBNG__document.all)) || JSBNG__document.getElementById))) {\n            if (JSBNG__document.getElementById(ftCutOffEpochSecondsElementID)) {\n                var cutOffEpochSeconds = JSBNG__document.getElementById(ftCutOffEpochSecondsElementID).innerHTML;\n                if (((cutOffEpochSeconds != \"\"))) {\n                    JSBNG__document.getElementById(ftCutOffEpochSecondsElementID).innerHTML = \"\";\n                    if (((((clientServerTimeDrift == null)) && JSBNG__document.getElementById(ftServerCurrentEpochSecondsElementID)))) {\n                        var serverCurrentEpochSeconds = ((JSBNG__document.getElementById(ftServerCurrentEpochSecondsElementID).innerHTML * 1));\n                        clientServerTimeDrift = ((((new JSBNG__Date().getTime() / 1000)) - serverCurrentEpochSeconds));\n                    }\n                ;\n                ;\n                    return ((((((clientServerTimeDrift == null)) ? 0 : clientServerTimeDrift)) + ((cutOffEpochSeconds * 1))));\n                }\n            ;\n            ;\n            }\n        ;\n        ;\n        }\n    ;\n    ;\n        return 0;\n    };\n;\n    function FT_getCountdown(secondsLeft) {\n        var FT_currentTime = new JSBNG__Date();\n        var FT_currentHours = FT_currentTime.getHours();\n        var FT_currentMins = FT_currentTime.getMinutes();\n        var FT_currentSecs = FT_currentTime.getSeconds();\n        FT_givenSeconds = ((((((FT_currentHours * 3600)) + ((FT_currentMins * 60)))) + FT_currentSecs));\n        var FT_secondsFromCat = 18026;\n        if (((secondsLeft != null))) {\n            FT_secondsFromCat = secondsLeft;\n        }\n    ;\n    ;\n        FT_givenSeconds += FT_secondsFromCat;\n        FT_getTime();\n    };\n;\n    function FT_getTime() {\n        var FT_newCurrentTime = new JSBNG__Date();\n        var FT_actualHours = FT_newCurrentTime.getHours();\n        var FT_actualMins = FT_newCurrentTime.getMinutes();\n        var FT_actualSecs = FT_newCurrentTime.getSeconds();\n        FT_actualSeconds = ((((((FT_actualHours * 3600)) + ((FT_actualMins * 60)))) + FT_actualSecs));\n        var cutOffTimeFromPageElement = FT_getAndClearCutOffEpochSeconds();\n        if (cutOffTimeFromPageElement) {\n            var countDownSeconds = ((cutOffTimeFromPageElement - ((FT_newCurrentTime.getTime() / 1000))));\n            if (((countDownSeconds >= 1))) {\n                FT_showEntireMessageElement(true);\n            }\n        ;\n        ;\n            FT_givenSeconds = ((countDownSeconds + FT_actualSeconds));\n        }\n    ;\n    ;\n        FT_displayCountdown();\n    };\n;\n    function onAjaxUpdate_fast_track(asin) {\n        var timerDiv = JSBNG__document.getElementById(\"ftMessageTimer\");\n        var cutOffElems = JSBNG__document.getElementsByName(((\"promise-cutoff-time.\" + asin)));\n        if (((((cutOffElems == null)) || ((cutOffElems.length == 0))))) {\n            return;\n        }\n    ;\n    ;\n        if (((timerDiv && timerDiv.style))) {\n            timerDiv.style.display = \"inline\";\n        }\n    ;\n    ;\n        var cutOffTimeVal = cutOffElems[0].value;\n        var cutOffTime = parseInt(cutOffTimeVal);\n        var currSecs = ((new JSBNG__Date().getTime() / 1000));\n        var secsLeft = ((cutOffTime - currSecs));\n        FT_getCountdown(secsLeft);\n    };\n;\n    FT_getCountdown();\n} catch (JSBNG_ex) {\n\n};");
// 988
geval("ftRegisterCountdownElementID(\"ftCountdown\");\nftRegisterEntireMessageElementID(\"ftMessage\");");
// 989
geval("function e75b493e6089a201530187bf51690fe2bbd897fb3(JSBNG__event) {\n    return amz_js_PopWin(\"/gp/help/customer/display.html/ref=ftinfo_dp_?ie=UTF8&nodeId=3510241&pop-up=1\", \"AmazonHelp\", \"width=550,height=600,resizable=1,scrollbars=1,toolbar=1,status=1\");\n};\n;");
// 992
o5 = {};
// 993
f881945950_406.returns.push(o5);
// 994
o6 = {};
// 995
o5.style = o6;
// 997
// 990
geval("var timerDiv = JSBNG__document.getElementById(\"ftMessageTimer\");\nif (((timerDiv && timerDiv.style))) {\n    timerDiv.style.display = \"inline\";\n}\n;\n;");
// 998
geval("if (((typeof measureATFDiff == \"function\"))) {\n    measureATFDiff(0, new JSBNG__Date().getTime());\n}\n;\n;\n;\nif (((typeof setCSMReq == \"function\"))) {\n    setCSMReq(\"af\");\n}\n else if (((typeof uet == \"function\"))) {\n    uet(\"af\");\n}\n\n;\n;");
// 999
geval("function ee976dbac42452e3152d3a48f703b0a8e017fa4d8(JSBNG__event) {\n    javascript:\n    Vellum.h();\n};\n;");
// 1000
geval("function ed771f07937fda9c8dd04b0376cf96f16a586029a(JSBNG__event) {\n    javascript:\n    Vellum.h();\n};\n;");
// 1001
geval("amznJQ.available(\"jQuery\", function() {\n    window.sitbWeblab = \"\";\n    if (((typeof (Vellum) == \"undefined\"))) {\n        Vellum = {\n            js: \"http://z-ecx.images-amazon.com/images/G/01/digital/sitb/reader/v4/201305301526/en_US/sitb-library-js._V383092699_.js\",\n            sj: \"/gp/search-inside/js?locale=en_US&version=201305301526\",\n            css: \"http://z-ecx.images-amazon.com/images/G/01/digital/sitb/reader/v4/201305301526/en_US/sitb-library-css._V383092698_.css\",\n            pl: function() {\n                Vellum.lj(Vellum.js, Vellum.sj, Vellum.css);\n            },\n            lj: function(u, u2, uc) {\n                if (window.vellumLjDone) {\n                    return;\n                }\n            ;\n            ;\n                window.vellumLjDone = true;\n                var d = JSBNG__document;\n                var s = d.createElement(\"link\");\n                s.type = \"text/css\";\n                s.rel = \"stylesheet\";\n                s.href = uc;\n                d.getElementsByTagName(\"head\")[0].appendChild(s);\n                s = d.createElement(\"script\");\n                s.type = \"text/javascript\";\n                s.src = u2;\n                d.getElementsByTagName(\"head\")[0].appendChild(s);\n            },\n            lj2: function(u) {\n                var d = JSBNG__document;\n                var s = d.createElement(\"script\");\n                s.type = \"text/javascript\";\n                s.src = u;\n                d.getElementsByTagName(\"head\")[0].appendChild(s);\n            },\n            go: function() {\n                sitbLodStart = new JSBNG__Date().getTime();\n                jQuery(\"body\").css(\"overflow\", \"hidden\");\n                var jqw = jQuery(window);\n                var h = jqw.height();\n                var w = jqw.width();\n                var st = jqw.scrollTop();\n                jQuery(\"#vellumShade\").css({\n                    JSBNG__top: st,\n                    height: h,\n                    width: w\n                }).show();\n                var vli = jQuery(\"#vellumLdgIco\");\n                var nl = ((((w / 2)) - ((vli.width() / 2))));\n                var nt = ((((st + ((h / 2)))) - ((vli.height() / 2))));\n                vli.css({\n                    left: nl,\n                    JSBNG__top: nt\n                }).show();\n                JSBNG__setTimeout(\"Vellum.x()\", 20000);\n                Vellum.pl();\n            },\n            x: function() {\n                jQuery(\"#vellumMsgTxt\").html(\"An error occurred while trying to show this book.\");\n                jQuery(\"#vellumMsgHdr\").html(\"Server Timeout\");\n                jQuery(\"#vellumMsg\").show();\n                var reftagImage = new JSBNG__Image();\n                reftagImage.src = \"/gp/search-inside/reftag/ref=rdr_bar_jsto\";\n            },\n            h: function() {\n                jQuery(\"#vellumMsg\").hide();\n                jQuery(\"#vellumShade\").hide();\n                jQuery(\"#vellumLdgIco\").hide();\n                jQuery(\"body\").css(\"overflow\", \"auto\");\n            },\n            cf: function(a) {\n                return function() {\n                    v.mt = a;\n                    v.rg = Array.prototype.slice.call(arguments);\n                    v.go();\n                };\n            },\n            c: function(a) {\n                var v = Vellum;\n                v.mt = \"c\";\n                v.rg = [a,];\n                v.pl();\n            }\n        };\n        var f = \"opqr\".split(\"\");\n        {\n            var fin7keys = ((window.top.JSBNG_Replay.forInKeys)((f))), fin7i = (0);\n            var i;\n            for (; (fin7i < fin7keys.length); (fin7i++)) {\n                ((i) = (fin7keys[fin7i]));\n                {\n                    var v = Vellum;\n                    v[f[i]] = v.cf(f[i]);\n                };\n            };\n        };\n    ;\n        sitbAsin = \"0596517742\";\n        SitbReader = {\n            LightboxActions: {\n                openReader: function(r) {\n                    Vellum.o(\"0596517742\", r);\n                    return false;\n                },\n                openReaderToRandomPage: function(r) {\n                    Vellum.r(\"0596517742\", r);\n                    return false;\n                },\n                openReaderToSearchResults: function(q, r) {\n                    Vellum.q(\"0596517742\", q, r);\n                    return false;\n                },\n                openReaderToPage: function(p, t, r) {\n                    Vellum.p(\"0596517742\", p, t, r);\n                    return false;\n                }\n            }\n        };\n    }\n;\n;\n    amznJQ.onCompletion(\"amznJQ.criticalFeature\", function() {\n        Vellum.c(\"0596517742\");\n    });\n});");
// 1003
o7 = {};
// 1004
f881945950_0.returns.push(o7);
// 1005
o2 = {};
// 1006
f881945950_0.returns.push(o2);
// 1007
f881945950_413 = function() { return f881945950_413.returns[f881945950_413.inst++]; };
f881945950_413.returns = [];
f881945950_413.inst = 0;
// 1008
o2.getHours = f881945950_413;
// 1009
f881945950_413.returns.push(13);
// 1010
f881945950_414 = function() { return f881945950_414.returns[f881945950_414.inst++]; };
f881945950_414.returns = [];
f881945950_414.inst = 0;
// 1011
o2.getMinutes = f881945950_414;
// 1012
f881945950_414.returns.push(59);
// 1013
f881945950_415 = function() { return f881945950_415.returns[f881945950_415.inst++]; };
f881945950_415.returns = [];
f881945950_415.inst = 0;
// 1014
o2.getSeconds = f881945950_415;
// 1015
f881945950_415.returns.push(38);
// 1016
o4 = {};
// 1017
f881945950_0.returns.push(o4);
// 1018
o4.getHours = f881945950_413;
// 1019
f881945950_413.returns.push(13);
// 1020
o4.getMinutes = f881945950_414;
// 1021
f881945950_414.returns.push(59);
// 1022
o4.getSeconds = f881945950_415;
// 1023
f881945950_415.returns.push(38);
// 1028
f881945950_406.returns.push(null);
// 1033
f881945950_406.returns.push(null);
// 1034
f881945950_16.returns.push(2);
// 1002
geval("if (((typeof amznJQ != \"undefined\"))) {\n    amznJQ.addLogical(\"twister-media-matrix\", [\"http://z-ecx.images-amazon.com/images/G/01/nav2/gamma/tmmJS/tmmJS-combined-core-4624._V1_.js\",]);\n    window._tmm_1 = +new JSBNG__Date();\n}\n;\n;");
// 1035
geval("ftRegisterCountdownElementID(\"ftCountdown\");\nftRegisterEntireMessageElementID(\"ftMessage\");");
// 1036
geval("function e75b493e6089a201530187bf51690fe2bbd897fb3(JSBNG__event) {\n    return amz_js_PopWin(\"/gp/help/customer/display.html/ref=ftinfo_dp_?ie=UTF8&nodeId=3510241&pop-up=1\", \"AmazonHelp\", \"width=550,height=600,resizable=1,scrollbars=1,toolbar=1,status=1\");\n};\n;");
// 1039
o5 = {};
// 1040
f881945950_406.returns.push(o5);
// 1041
o6 = {};
// 1042
o5.style = o6;
// 1044
// 1037
geval("var timerDiv = JSBNG__document.getElementById(\"ftMessageTimer\");\nif (((timerDiv && timerDiv.style))) {\n    timerDiv.style.display = \"inline\";\n}\n;\n;");
// 1045
geval("try {\n    if (((typeof measureATFDiff == \"function\"))) {\n        measureATFDiff(0, new JSBNG__Date().getTime());\n    }\n;\n;\n;\n    if (((typeof setCSMReq == \"function\"))) {\n        setCSMReq(\"af\");\n    }\n     else if (((typeof uet == \"function\"))) {\n        uet(\"af\");\n    }\n    \n;\n;\n} catch (JSBNG_ex) {\n\n};");
// 1046
geval("function ee976dbac42452e3152d3a48f703b0a8e017fa4d8(JSBNG__event) {\n    javascript:\n    Vellum.h();\n};\n;");
// 1047
geval("function ed771f07937fda9c8dd04b0376cf96f16a586029a(JSBNG__event) {\n    javascript:\n    Vellum.h();\n};\n;");
// 1048
geval("amznJQ.available(\"jQuery\", function() {\n    window.sitbWeblab = \"\";\n    if (((typeof (Vellum) == \"undefined\"))) {\n        Vellum = {\n            js: \"http://z-ecx.images-amazon.com/images/G/01/digital/sitb/reader/v4/201305301526/en_US/sitb-library-js._V383092699_.js\",\n            sj: \"/gp/search-inside/js?locale=en_US&version=201305301526\",\n            css: \"http://z-ecx.images-amazon.com/images/G/01/digital/sitb/reader/v4/201305301526/en_US/sitb-library-css._V383092698_.css\",\n            pl: function() {\n                Vellum.lj(Vellum.js, Vellum.sj, Vellum.css);\n            },\n            lj: function(u, u2, uc) {\n                if (window.vellumLjDone) {\n                    return;\n                }\n            ;\n            ;\n                window.vellumLjDone = true;\n                var d = JSBNG__document;\n                var s = d.createElement(\"link\");\n                s.type = \"text/css\";\n                s.rel = \"stylesheet\";\n                s.href = uc;\n                d.getElementsByTagName(\"head\")[0].appendChild(s);\n                s = d.createElement(\"script\");\n                s.type = \"text/javascript\";\n                s.src = u2;\n                d.getElementsByTagName(\"head\")[0].appendChild(s);\n            },\n            lj2: function(u) {\n                var d = JSBNG__document;\n                var s = d.createElement(\"script\");\n                s.type = \"text/javascript\";\n                s.src = u;\n                d.getElementsByTagName(\"head\")[0].appendChild(s);\n            },\n            go: function() {\n                sitbLodStart = new JSBNG__Date().getTime();\n                jQuery(\"body\").css(\"overflow\", \"hidden\");\n                var jqw = jQuery(window);\n                var h = jqw.height();\n                var w = jqw.width();\n                var st = jqw.scrollTop();\n                jQuery(\"#vellumShade\").css({\n                    JSBNG__top: st,\n                    height: h,\n                    width: w\n                }).show();\n                var vli = jQuery(\"#vellumLdgIco\");\n                var nl = ((((w / 2)) - ((vli.width() / 2))));\n                var nt = ((((st + ((h / 2)))) - ((vli.height() / 2))));\n                vli.css({\n                    left: nl,\n                    JSBNG__top: nt\n                }).show();\n                JSBNG__setTimeout(\"Vellum.x()\", 20000);\n                Vellum.pl();\n            },\n            x: function() {\n                jQuery(\"#vellumMsgTxt\").html(\"An error occurred while trying to show this book.\");\n                jQuery(\"#vellumMsgHdr\").html(\"Server Timeout\");\n                jQuery(\"#vellumMsg\").show();\n                var reftagImage = new JSBNG__Image();\n                reftagImage.src = \"/gp/search-inside/reftag/ref=rdr_bar_jsto\";\n            },\n            h: function() {\n                jQuery(\"#vellumMsg\").hide();\n                jQuery(\"#vellumShade\").hide();\n                jQuery(\"#vellumLdgIco\").hide();\n                jQuery(\"body\").css(\"overflow\", \"auto\");\n            },\n            cf: function(a) {\n                return function() {\n                    v.mt = a;\n                    v.rg = Array.prototype.slice.call(arguments);\n                    v.go();\n                };\n            },\n            c: function(a) {\n                var v = Vellum;\n                v.mt = \"c\";\n                v.rg = [a,];\n                v.pl();\n            }\n        };\n        var f = \"opqr\".split(\"\");\n        {\n            var fin8keys = ((window.top.JSBNG_Replay.forInKeys)((f))), fin8i = (0);\n            var i;\n            for (; (fin8i < fin8keys.length); (fin8i++)) {\n                ((i) = (fin8keys[fin8i]));\n                {\n                    var v = Vellum;\n                    v[f[i]] = v.cf(f[i]);\n                };\n            };\n        };\n    ;\n        sitbAsin = \"0596517742\";\n        SitbReader = {\n            LightboxActions: {\n                openReader: function(r) {\n                    Vellum.o(\"0596517742\", r);\n                    return false;\n                },\n                openReaderToRandomPage: function(r) {\n                    Vellum.r(\"0596517742\", r);\n                    return false;\n                },\n                openReaderToSearchResults: function(q, r) {\n                    Vellum.q(\"0596517742\", q, r);\n                    return false;\n                },\n                openReaderToPage: function(p, t, r) {\n                    Vellum.p(\"0596517742\", p, t, r);\n                    return false;\n                }\n            }\n        };\n    }\n;\n;\n    amznJQ.onCompletion(\"amznJQ.criticalFeature\", function() {\n        Vellum.c(\"0596517742\");\n    });\n});");
// 1050
o7 = {};
// 1051
f881945950_0.returns.push(o7);
// 1052
o8 = {};
// 1053
o2 = {};
// 1054
f881945950_0.returns.push(o2);
// 1055
f881945950_413 = function() { return f881945950_413.returns[f881945950_413.inst++]; };
f881945950_413.returns = [];
f881945950_413.inst = 0;
// 1056
o2.getHours = f881945950_413;
// 1057
f881945950_413.returns.push(13);
// 1058
f881945950_414 = function() { return f881945950_414.returns[f881945950_414.inst++]; };
f881945950_414.returns = [];
f881945950_414.inst = 0;
// 1059
o2.getMinutes = f881945950_414;
// 1060
f881945950_414.returns.push(59);
// 1061
f881945950_415 = function() { return f881945950_415.returns[f881945950_415.inst++]; };
f881945950_415.returns = [];
f881945950_415.inst = 0;
// 1062
o2.getSeconds = f881945950_415;
// undefined
o2 = null;
// 1063
f881945950_415.returns.push(38);
// 1064
o4 = {};
// 1065
f881945950_0.returns.push(o4);
// 1066
o4.getHours = f881945950_413;
// 1067
f881945950_413.returns.push(13);
// 1068
o4.getMinutes = f881945950_414;
// 1069
f881945950_414.returns.push(59);
// 1070
o4.getSeconds = f881945950_415;
// undefined
o4 = null;
// 1071
f881945950_415.returns.push(38);
// 1076
f881945950_406.returns.push(null);
// 1081
f881945950_406.returns.push(null);
// 1082
f881945950_16.returns.push(2);
// 1049
geval("if (((typeof amznJQ != \"undefined\"))) {\n    amznJQ.addLogical(\"twister-media-matrix\", [\"http://z-ecx.images-amazon.com/images/G/01/nav2/gamma/tmmJS/tmmJS-combined-core-4624._V1_.js\",]);\n    window._tmm_1 = +new JSBNG__Date();\n}\n;\n;");
// 1083
geval("ftRegisterCountdownElementID(\"ftCountdown\");\nftRegisterEntireMessageElementID(\"ftMessage\");");
// 1084
geval("function e75b493e6089a201530187bf51690fe2bbd897fb3(JSBNG__event) {\n    return amz_js_PopWin(\"/gp/help/customer/display.html/ref=ftinfo_dp_?ie=UTF8&nodeId=3510241&pop-up=1\", \"AmazonHelp\", \"width=550,height=600,resizable=1,scrollbars=1,toolbar=1,status=1\");\n};\n;");
// 1087
o5 = {};
// 1088
f881945950_406.returns.push(o5);
// 1089
o6 = {};
// 1090
o5.style = o6;
// undefined
o5 = null;
// 1092
// undefined
o6 = null;
// 1085
geval("var timerDiv = JSBNG__document.getElementById(\"ftMessageTimer\");\nif (((timerDiv && timerDiv.style))) {\n    timerDiv.style.display = \"inline\";\n}\n;\n;");
// 1093
geval("if (((typeof measureATFDiff == \"function\"))) {\n    measureATFDiff(0, new JSBNG__Date().getTime());\n}\n;\n;\n;\nif (((typeof setCSMReq == \"function\"))) {\n    setCSMReq(\"af\");\n}\n else if (((typeof uet == \"function\"))) {\n    uet(\"af\");\n}\n\n;\n;");
// 1094
geval("function ee976dbac42452e3152d3a48f703b0a8e017fa4d8(JSBNG__event) {\n    javascript:\n    Vellum.h();\n};\n;");
// 1095
geval("function ed771f07937fda9c8dd04b0376cf96f16a586029a(JSBNG__event) {\n    javascript:\n    Vellum.h();\n};\n;");
// 1096
geval("amznJQ.available(\"jQuery\", function() {\n    window.sitbWeblab = \"\";\n    if (((typeof (Vellum) == \"undefined\"))) {\n        Vellum = {\n            js: \"http://z-ecx.images-amazon.com/images/G/01/digital/sitb/reader/v4/201305301526/en_US/sitb-library-js._V383092699_.js\",\n            sj: \"/gp/search-inside/js?locale=en_US&version=201305301526\",\n            css: \"http://z-ecx.images-amazon.com/images/G/01/digital/sitb/reader/v4/201305301526/en_US/sitb-library-css._V383092698_.css\",\n            pl: function() {\n                Vellum.lj(Vellum.js, Vellum.sj, Vellum.css);\n            },\n            lj: function(u, u2, uc) {\n                if (window.vellumLjDone) {\n                    return;\n                }\n            ;\n            ;\n                window.vellumLjDone = true;\n                var d = JSBNG__document;\n                var s = d.createElement(\"link\");\n                s.type = \"text/css\";\n                s.rel = \"stylesheet\";\n                s.href = uc;\n                d.getElementsByTagName(\"head\")[0].appendChild(s);\n                s = d.createElement(\"script\");\n                s.type = \"text/javascript\";\n                s.src = u2;\n                d.getElementsByTagName(\"head\")[0].appendChild(s);\n            },\n            lj2: function(u) {\n                var d = JSBNG__document;\n                var s = d.createElement(\"script\");\n                s.type = \"text/javascript\";\n                s.src = u;\n                d.getElementsByTagName(\"head\")[0].appendChild(s);\n            },\n            go: function() {\n                sitbLodStart = new JSBNG__Date().getTime();\n                jQuery(\"body\").css(\"overflow\", \"hidden\");\n                var jqw = jQuery(window);\n                var h = jqw.height();\n                var w = jqw.width();\n                var st = jqw.scrollTop();\n                jQuery(\"#vellumShade\").css({\n                    JSBNG__top: st,\n                    height: h,\n                    width: w\n                }).show();\n                var vli = jQuery(\"#vellumLdgIco\");\n                var nl = ((((w / 2)) - ((vli.width() / 2))));\n                var nt = ((((st + ((h / 2)))) - ((vli.height() / 2))));\n                vli.css({\n                    left: nl,\n                    JSBNG__top: nt\n                }).show();\n                JSBNG__setTimeout(\"Vellum.x()\", 20000);\n                Vellum.pl();\n            },\n            x: function() {\n                jQuery(\"#vellumMsgTxt\").html(\"An error occurred while trying to show this book.\");\n                jQuery(\"#vellumMsgHdr\").html(\"Server Timeout\");\n                jQuery(\"#vellumMsg\").show();\n                var reftagImage = new JSBNG__Image();\n                reftagImage.src = \"/gp/search-inside/reftag/ref=rdr_bar_jsto\";\n            },\n            h: function() {\n                jQuery(\"#vellumMsg\").hide();\n                jQuery(\"#vellumShade\").hide();\n                jQuery(\"#vellumLdgIco\").hide();\n                jQuery(\"body\").css(\"overflow\", \"auto\");\n            },\n            cf: function(a) {\n                return function() {\n                    v.mt = a;\n                    v.rg = Array.prototype.slice.call(arguments);\n                    v.go();\n                };\n            },\n            c: function(a) {\n                var v = Vellum;\n                v.mt = \"c\";\n                v.rg = [a,];\n                v.pl();\n            }\n        };\n        var f = \"opqr\".split(\"\");\n        {\n            var fin9keys = ((window.top.JSBNG_Replay.forInKeys)((f))), fin9i = (0);\n            var i;\n            for (; (fin9i < fin9keys.length); (fin9i++)) {\n                ((i) = (fin9keys[fin9i]));\n                {\n                    var v = Vellum;\n                    v[f[i]] = v.cf(f[i]);\n                };\n            };\n        };\n    ;\n        sitbAsin = \"0596517742\";\n        SitbReader = {\n            LightboxActions: {\n                openReader: function(r) {\n                    Vellum.o(\"0596517742\", r);\n                    return false;\n                },\n                openReaderToRandomPage: function(r) {\n                    Vellum.r(\"0596517742\", r);\n                    return false;\n                },\n                openReaderToSearchResults: function(q, r) {\n                    Vellum.q(\"0596517742\", q, r);\n                    return false;\n                },\n                openReaderToPage: function(p, t, r) {\n                    Vellum.p(\"0596517742\", p, t, r);\n                    return false;\n                }\n            }\n        };\n    }\n;\n;\n    amznJQ.onCompletion(\"amznJQ.criticalFeature\", function() {\n        Vellum.c(\"0596517742\");\n    });\n});");
// 1098
o7 = {};
// 1099
f881945950_0.returns.push(o7);
// undefined
o7 = null;
// 1100
o8 = {};
// undefined
o8 = null;
// 1101
o2 = {};
// undefined
o2 = null;
// 1097
geval("if (((typeof amznJQ != \"undefined\"))) {\n    amznJQ.addLogical(\"twister-media-matrix\", [\"http://z-ecx.images-amazon.com/images/G/01/nav2/gamma/tmmJS/tmmJS-combined-core-4624._V1_.js\",]);\n    window._tmm_1 = +new JSBNG__Date();\n}\n;\n;");
// 1103
o2 = {};
// 1104
f881945950_0.returns.push(o2);
// undefined
o2 = null;
// 1102
geval("window._tmm_3 = +new JSBNG__Date();\nif (((typeof amznJQ != \"undefined\"))) {\n    amznJQ.onCompletion(\"amznJQ.criticalFeature\", function() {\n        amznJQ.available(\"twister-media-matrix\", function() {\n            window._tmm_2 = +new JSBNG__Date();\n            TwisterMediaMatrix.initialize({\n                kindle_meta_binding: {\n                    n: \"1\",\n                    start: \"1\"\n                },\n                paperback_meta_binding: {\n                    n: \"4\",\n                    start: \"1\"\n                },\n                other_meta_binding: {\n                    n: \"1\",\n                    start: \"1\"\n                }\n            }, \"3\", \"books\", \"0596517742\", \"B00279BLLE\", \"book_display_on_website\", \"Loading...\", \"Error. Please try again.\", \"http://g-ecx.images-amazon.com/images/G/01/x-locale/twister/tiny-snake._V192199047_.gif\", false, \"1-1\", \"1373479157\");\n        });\n    });\n}\n;\n;\nvar disableWinnerPopup;");
// 1105
geval("function e51d7970767549cda27023a52a400a94280d471f5(JSBNG__event) {\n    amz_expandPostBodyDescription(\"PS\", [\"psGradient\",\"psPlaceHolder\",]);\n    return false;\n};\n;");
// 1106
geval("function e5c5178e859fbed387086d382315ddf2817c1731d(JSBNG__event) {\n    amz_collapsePostBodyDescription(\"PS\", [\"psGradient\",\"psPlaceHolder\",]);\n    return false;\n};\n;");
// 1107
geval("function amz_expandPostBodyDescription(id, objects) {\n    amznJQ.onReady(\"jQuery\", function() {\n        for (var i = 0; ((i < objects.length)); i++) {\n            jQuery(((\"#\" + objects[i]))).hide();\n        };\n    ;\n        jQuery(((\"#outer_postBody\" + id))).animate({\n            height: jQuery(((\"#postBody\" + id))).height()\n        }, 500);\n        jQuery(((\"#expand\" + id))).hide();\n        jQuery(((\"#collapse\" + id))).show();\n        jQuery.ajax({\n            url: \"/gp/product/utility/ajax/impression-tracking.html\",\n            data: {\n                a: \"0596517742\",\n                ref: \"dp_pd_showmore_b\"\n            }\n        });\n    });\n};\n;\nfunction amz_collapsePostBodyDescription(id, objects) {\n    amznJQ.onReady(\"jQuery\", function() {\n        for (var i = 0; ((i < objects.length)); i++) {\n            jQuery(((\"#\" + objects[i]))).show();\n        };\n    ;\n        jQuery(((\"#outer_postBody\" + id))).animate({\n            height: 200\n        }, 500);\n        jQuery(((\"#collapse\" + id))).hide();\n        jQuery(((\"#expand\" + id))).show();\n        jQuery.ajax({\n            url: \"/gp/product/utility/ajax/impression-tracking.html\",\n            data: {\n                a: \"0596517742\",\n                ref: \"dp_pd_showless_b\"\n            }\n        });\n    });\n};\n;\namznJQ.onReady(\"jQuery\", function() {\n    var psTotalHeight = jQuery(\"#postBodyPS\").height();\n    if (((psTotalHeight > 200))) {\n        jQuery(\"#outer_postBodyPS\").css(\"display\", \"block\").css(\"height\", 200);\n        jQuery(\"#psPlaceHolder\").css(\"display\", \"block\");\n        jQuery(\"#expandPS\").css(\"display\", \"block\");\n        jQuery(\"#psGradient\").css(\"display\", \"block\");\n    }\n     else {\n        jQuery(\"#outer_postBodyPS\").css(\"height\", \"auto\");\n        jQuery(\"#psGradient\").hide();\n        jQuery(\"#psPlaceHolder\").hide();\n    }\n;\n;\n});");
// 1108
geval("function ef2d35c5b582d6058ac633b57d69c8b9ac542ebec(JSBNG__event) {\n    return false;\n};\n;");
// 1109
geval("function ecf51729fd790a7ea3ccc34e61cae1ad6542b3ab2(JSBNG__event) {\n    return false;\n};\n;");
// 1110
geval("function edd8e3d0178c67cf94e61d6831fdd582864ee9797(JSBNG__event) {\n    return false;\n};\n;");
// 1112
f881945950_423 = function() { return f881945950_423.returns[f881945950_423.inst++]; };
f881945950_423.returns = [];
f881945950_423.inst = 0;
// 1113
o0.createElement = f881945950_423;
// 1114
o2 = {};
// 1115
f881945950_423.returns.push(o2);
// 1116
// 1117
o4 = {};
// 1118
o0.body = o4;
// 1119
o5 = {};
// 1120
o4.childNodes = o5;
// 1121
o5.length = 2;
// 1123
f881945950_427 = function() { return f881945950_427.returns[f881945950_427.inst++]; };
f881945950_427.returns = [];
f881945950_427.inst = 0;
// 1124
o4.insertBefore = f881945950_427;
// undefined
o4 = null;
// 1127
o4 = {};
// 1128
o5["0"] = o4;
// undefined
o5 = null;
// undefined
o4 = null;
// 1129
f881945950_427.returns.push(o2);
// undefined
o2 = null;
// 1111
geval("window.AmazonPopoverImages = {\n    snake: \"http://g-ecx.images-amazon.com/images/G/01/javascripts/lib/popover/images/snake._V192571611_.gif\",\n    btnClose: \"http://g-ecx.images-amazon.com/images/G/01/javascripts/lib/popover/images/btn_close._V192188154_.gif\",\n    closeTan: \"http://g-ecx.images-amazon.com/images/G/01/nav2/images/close-tan-sm._V192185930_.gif\",\n    closeTanDown: \"http://g-ecx.images-amazon.com/images/G/01/nav2/images/close-tan-sm-dn._V192185961_.gif\",\n    loadingBar: \"http://g-ecx.images-amazon.com/images/G/01/javascripts/lib/popover/images/loading-bar-small._V192188123_.gif\",\n    pixel: \"http://g-ecx.images-amazon.com/images/G/01/icons/blank-pixel._V192192429_.gif\"\n};\nvar container = JSBNG__document.createElement(\"DIV\");\ncontainer.id = \"ap_container\";\nif (JSBNG__document.body.childNodes.length) {\n    JSBNG__document.body.insertBefore(container, JSBNG__document.body.childNodes[0]);\n}\n else {\n    JSBNG__document.body.appendChild(container);\n}\n;\n;");
// 1131
o2 = {};
// 1132
o0.head = o2;
// 1134
o4 = {};
// 1135
f881945950_423.returns.push(o4);
// 1136
// 1137
// 1138
o2.insertBefore = f881945950_427;
// 1139
o5 = {};
// 1140
o2.firstChild = o5;
// undefined
o2 = null;
// undefined
o5 = null;
// 1141
f881945950_427.returns.push(o4);
// undefined
o4 = null;
// 1130
geval("(function() {\n    var h = ((((JSBNG__document.head || JSBNG__document.getElementsByTagName(\"head\")[0])) || JSBNG__document.documentElement));\n    var s = JSBNG__document.createElement(\"script\");\n    s.async = \"async\";\n    s.src = \"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/site-wide-js-1.2.6-beacon/site-wide-11198044143._V1_.js\";\n    h.insertBefore(s, h.firstChild);\n})();");
// 1142
geval("amznJQ.addLogical(\"popover\", []);\namznJQ.addLogical(\"navbarCSSUS-beacon\", []);\namznJQ.addLogical(\"search-js-autocomplete\", []);\namznJQ.addLogical(\"navbarJS-beacon\", []);\namznJQ.addLogical(\"LBHUCCSS-US\", []);\namznJQ.addLogical(\"CustomerPopover\", [\"http://z-ecx.images-amazon.com/images/G/01/x-locale/communities/profile/customer-popover/script-13-min._V224617671_.js\",]);\namznJQ.addLogical(\"amazonShoveler\", [\"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/amazonShoveler/amazonShoveler-1466453065._V1_.js\",]);\namznJQ.addLogical(\"dpCSS\", []);\namznJQ.addLogical(\"discussionsCSS\", []);\namznJQ.addLogical(\"bxgyCSS\", []);\namznJQ.addLogical(\"simCSS\", []);\namznJQ.addLogical(\"condProbCSS\", []);\namznJQ.addLogical(\"ciuAnnotations\", []);\namznJQ.addLogical(\"cmuAnnotations\", [\"http://z-ecx.images-amazon.com/images/G/01/nav2/gamma/cmuAnnotations/cmuAnnotations-cmuAnnotations-55262._V1_.js\",]);\namznJQ.addLogical(\"dpProductImage\", [\"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/dpProductImage/dpProductImage-2900646310._V1_.js\",]);\namznJQ.addLogical(\"search-csl\", [\"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/search-csl/search-csl-2400229912._V1_.js\",]);\namznJQ.addLogical(\"AmazonHistory\", [\"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/AmazonHistory/AmazonHistory-61973207._V1_.js\",]);\namznJQ.addLogical(\"AmazonCountdown\", [\"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/AmazonCountdownMerged/AmazonCountdownMerged-27059._V1_.js\",]);\namznJQ.addLogical(\"bylinePopover\", [\"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/bylinePopover/bylinePopover-1310866238._V1_.js\",]);\namznJQ.addLogical(\"simsJS\", [\"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/simsJSMerged/simsMerged-8063003390._V1_.js\",]);\namznJQ.addLogical(\"callOnVisible\", [\"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/callOnVisible/callOnVisible-3144292562._V1_.js\",]);\namznJQ.addLogical(\"p13nlogger\", [\"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/p13nlogger/p13nlogger-1808340331._V1_.js\",]);\namznJQ.addLogical(\"lazyLoadLib\", [\"http://z-ecx.images-amazon.com/images/G/01/nav2/gamma/lazyLoadLib/lazyLoadLib-lazyLoadLib-60357._V1_.js\",]);\namznJQ.addLogical(\"immersiveView\", [\"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/immersiveView/immersiveView-990982538._V1_.js\",]);\namznJQ.addLogical(\"imageBlock\", [\"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/imageBlock/imageBlock-1812119340._V1_.js\",]);\namznJQ.addLogical(\"quantityDropDownJS\", [\"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/quantityDropDownJSMerged/quantityDropDownJSMerged-63734._V1_.js\",]);\namznJQ.addLogical(\"bbopCheckBoxJS\", [\"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/bbopCheckBoxJSMerged/bbopCheckBoxJSMerged-33025._V1_.js\",]);\namznJQ.addLogical(\"share-with-friends-js-new\", [\"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/share-with-friends-js-new/share-with-friends-js-new-4128511603._V1_.js\",]);");
// 1143
geval("function acrPopoverHover(e, h) {\n    if (h) {\n        window.acrAsinHover = e;\n    }\n     else {\n        if (((window.acrAsinHover == e))) {\n            window.acrAsinHover = null;\n        }\n    ;\n    }\n;\n;\n};\n;\namznJQ.onReady(\"popover\", function() {\n    (function($) {\n        if ($.fn.acrPopover) {\n            return;\n        }\n    ;\n    ;\n        var popoverConfig = {\n            showOnHover: true,\n            showCloseButton: true,\n            width: null,\n            JSBNG__location: \"bottom\",\n            locationAlign: \"left\",\n            locationOffset: [-20,0,],\n            paddingLeft: 15,\n            paddingBottom: 5,\n            paddingRight: 15,\n            group: \"reviewsPopover\",\n            clone: false,\n            hoverHideDelay: 300\n        };\n        $.fn.acrPopover = function() {\n            return this.each(function() {\n                var $this = $(this);\n                if (!$this.data(\"init\")) {\n                    $this.data(\"init\", 1);\n                    var getargs = $this.attr(\"getargs\");\n                    var ajaxURL = ((((((((((((((\"/gp/customer-reviews/common/du/displayHistoPopAjax.html?\" + \"&ASIN=\")) + $this.attr(\"JSBNG__name\"))) + \"&link=1\")) + \"&seeall=1\")) + \"&ref=\")) + $this.attr(\"ref\"))) + ((((typeof getargs != \"undefined\")) ? ((\"&getargs=\" + getargs)) : \"\"))));\n                    var myConfig = $.extend(true, {\n                        destination: ajaxURL\n                    }, popoverConfig);\n                    $this.amazonPopoverTrigger(myConfig);\n                    var w = window.acrAsinHover;\n                    if (((w && (($(w).parents(\".asinReviewsSummary\").get(0) == this))))) {\n                        $this.trigger(\"mouseover.amzPopover\");\n                        window.acrAsinHover = null;\n                    }\n                ;\n                ;\n                }\n            ;\n            ;\n            });\n        };\n        window.reviewHistPopoverConfig = popoverConfig;\n        var jqInit = window.jQueryInitHistoPopovers = function(asin) {\n            $(((((\".acr-popover[name=\" + asin)) + \"]\"))).acrPopover();\n        };\n        window.doInit_average_customer_reviews = jqInit;\n        window.onAjaxUpdate_average_customer_reviews = jqInit;\n        window.onCacheUpdate_average_customer_reviews = jqInit;\n        window.onCacheUpdateReselect_average_customer_reviews = jqInit;\n        amznJQ.onCompletion(\"amznJQ.criticalFeature\", function() {\n            JSBNG__setTimeout(function() {\n                amznJQ.declareAvailable(\"acrPopover\");\n            }, 10);\n        });\n    })(jQuery);\n});\namznJQ.onReady(\"acrPopover\", function() {\n    jQuery(\".acr-popover,#searchTemplate .asinReviewsSummary\").each(function() {\n        jQuery(this).acrPopover();\n    });\n});");
// 1144
geval("function e4a4bcedba65b380893f77d4dd29526130ee3b4d1(JSBNG__event) {\n    return acrPopoverHover(this, 1);\n};\n;");
// 1145
geval("function edeb92174417d8dc1c0e6f67c4ca60200f797789e(JSBNG__event) {\n    return acrPopoverHover(this, 0);\n};\n;");
// 1146
geval("function ed89eaa1f3ad51711a79f8d9d280a54d2800bbe33(JSBNG__event) {\n    return acrPopoverHover(this, 1);\n};\n;");
// 1147
geval("function e6347802676af907c8a2f7c8d51ebf8ecb4cc78ea(JSBNG__event) {\n    return acrPopoverHover(this, 0);\n};\n;");
// 1148
geval("var DEFAULT_RENDERING_TIME = 123;\namznJQ.onReady(\"popover\", function() {\n    jQuery(\"#ns_0M4YTA6K9C1VFV7TYXNC_775_1_community_feedback_trigger_product-detail\").amazonPopoverTrigger({\n        title: \"What product features are missing?\",\n        destination: \"/gp/lwcf/light-weight-form.html?asin=0596517742&root=283155\",\n        showOnHover: false,\n        draggable: true,\n        width: 650,\n        paddingBottom: 0,\n        onHide: function() {\n            logCloseWidgetEvent(DEFAULT_RENDERING_TIME);\n            cleanupSearchResults();\n        }\n    });\n});");
// 1149
geval("amznJQ.onReady(\"popover\", function() {\n    jQuery(\"#ns_0M4YTA6K9C1VFV7TYXNC_774_1_hmd_pricing_feedback_trigger_product-detail\").amazonPopoverTrigger({\n        title: \"Tell Us About a Lower Price\",\n        destination: \"/gp/pdp/pf/pricingFeedbackForm.html/ref=sr_1_1_pfdpb?ie=UTF8&ASIN=0596517742&PREFIX=ns_0M4YTA6K9C1VFV7TYXNC_774_2_&from=product-detail&keywords=javascript%20the%20good%20parts&originalURI=%2Fgp%2Fproduct%2F0596517742&qid=1373479157&s=books&sr=1-1&storeID=books\",\n        showOnHover: false,\n        draggable: true\n    });\n});");
// 1150
geval("amznJQ.onReady(\"lazyLoadLib\", function() {\n    jQuery(\"#books-entity-teaser\").lazyLoadContent({\n        url: \"/gp/product/features/entity-teaser/books-entity-teaser-ajax.html?ASIN=0596517742\",\n        metrics: true,\n        JSBNG__name: \"books-entity-teaser\",\n        cache: true\n    });\n});");
// 1151
geval("function e1e1dc54f9e2961eab4a6b364613e62cd51b69355(JSBNG__event) {\n    return amz_js_PopWin(this.href, \"AmazonHelp\", \"width=340,height=340,resizable=1,scrollbars=1,toolbar=1,status=1\");\n};\n;");
// 1152
geval("var paCusRevAllURL = \"http://product-ads-portal.amazon.com/gp/synd/?asin=0596517742&pAsin=&gl=14&sq=javascript%20the%20good%20parts&sa=&se=Amazon&noo=&pt=Detail&spt=Glance&sn=customer-reviews-top&pRID=0M4YTA6K9C1VFV7TYXNC&ts=1373479174&h=0BA9078DD844F27758A20C195D68A922B6040AC2\";");
// 1154
o2 = {};
// 1155
f881945950_0.returns.push(o2);
// 1156
o2.getTime = f881945950_397;
// 1157
f881945950_397.returns.push(1373479178512);
// 1153
geval("try {\n    (function(w, d, e, o) {\n        var i = \"DAcrt\";\n        if (w.uDA = ((((w.ues && w.uet)) && w.uex))) {\n            ues(\"wb\", i, 1);\n            uet(\"bb\", i, {\n                wb: 1\n            });\n        }\n    ;\n    ;\n        var methodToBind = \"amznJQ.onCompletion\";\n        if (((((!w.amznJQ && ((methodToBind == \"amznJQ.onCompletion\")))) && ((typeof (P) != \"undefined\"))))) {\n            P.when(\"amznJQ.criticalFeature\").execute(function() {\n                o = w.DA;\n                if (!o) {\n                    o = w.DA = [];\n                    e = d.createElement(\"script\");\n                    e.src = \"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/DA-us/DA-us-1527499158._V381226140_.js\";\n                    d.getElementsByTagName(\"head\")[0].appendChild(e);\n                }\n            ;\n            ;\n                o.push({\n                    c: 855,\n                    a: \"site=amazon.us;pt=Detail;slot=customer-reviews-top;pid=0596517742;prid=0M4YTA6K9C1VFV7TYXNC;arid=d9da736c99a54c90a1096fec27fb2394;ef=0.00\",\n                    f: 1,\n                    g: \"\",\n                    n: 1,\n                    r: 1,\n                    v: 1,\n                    y: \"na\",\n                    u: \"amzn.us.dp.books/computer_internet;sz=300x250;oe=ISO-8859-1;u=d9da736c99a54c90a1096fec27fb2394;s=i0;s=i1;s=i3;s=i4;s=i5;s=i6;s=i7;s=i8;s=i9;s=m1;s=m4;s=u4;s=u13;s=u10;s=u2;z=153;z=180;z=173;z=141;s=3072;s=32;s=3172a;s=3172;s=3;s=12;s=67;s=142;s=150;s=622;s=762;s=833;s=921;s=1009;s=1046;s=1324;s=3101;s=3102;s=3103;s=3174;s=3175;s=3176;dc_ref=http%3A%2F%2Fwww.amazon.com;tile=1;ord=0M4YTA6K9C1VFV7TYXNC\",\n                    q: \"N4215\"\n                });\n            });\n        }\n         else {\n            amznJQ.onCompletion(\"amznJQ.criticalFeature\", function() {\n                o = w.DA;\n                if (!o) {\n                    o = w.DA = [];\n                    e = d.createElement(\"script\");\n                    e.src = \"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/DA-us/DA-us-1527499158._V381226140_.js\";\n                    d.getElementsByTagName(\"head\")[0].appendChild(e);\n                }\n            ;\n            ;\n                o.push({\n                    c: 855,\n                    a: \"site=amazon.us;pt=Detail;slot=customer-reviews-top;pid=0596517742;prid=0M4YTA6K9C1VFV7TYXNC;arid=d9da736c99a54c90a1096fec27fb2394;ef=0.00\",\n                    f: 1,\n                    g: \"\",\n                    n: 1,\n                    r: 1,\n                    v: 1,\n                    y: \"na\",\n                    u: \"amzn.us.dp.books/computer_internet;sz=300x250;oe=ISO-8859-1;u=d9da736c99a54c90a1096fec27fb2394;s=i0;s=i1;s=i3;s=i4;s=i5;s=i6;s=i7;s=i8;s=i9;s=m1;s=m4;s=u4;s=u13;s=u10;s=u2;z=153;z=180;z=173;z=141;s=3072;s=32;s=3172a;s=3172;s=3;s=12;s=67;s=142;s=150;s=622;s=762;s=833;s=921;s=1009;s=1046;s=1324;s=3101;s=3102;s=3103;s=3174;s=3175;s=3176;dc_ref=http%3A%2F%2Fwww.amazon.com;tile=1;ord=0M4YTA6K9C1VFV7TYXNC\",\n                    q: \"N4215\"\n                });\n            });\n        }\n    ;\n    ;\n    })(window, JSBNG__document);\n} catch (JSBNG_ex) {\n\n};");
// 1159
o4 = {};
// 1160
f881945950_0.returns.push(o4);
// 1158
geval("if (((typeof setCSMReq == \"function\"))) {\n    setCSMReq(\"cf\");\n}\n else {\n    if (((typeof uet == \"function\"))) {\n        uet(\"cf\");\n    }\n;\n;\n    amznJQ.completedStage(\"amznJQ.criticalFeature\");\n}\n;\n;");
// 1161
geval("function acrPopoverHover(e, h) {\n    if (h) {\n        window.acrAsinHover = e;\n    }\n     else {\n        if (((window.acrAsinHover == e))) {\n            window.acrAsinHover = null;\n        }\n    ;\n    }\n;\n;\n};\n;\namznJQ.onReady(\"popover\", function() {\n    (function($) {\n        if ($.fn.acrPopover) {\n            return;\n        }\n    ;\n    ;\n        var popoverConfig = {\n            showOnHover: true,\n            showCloseButton: true,\n            width: null,\n            JSBNG__location: \"bottom\",\n            locationAlign: \"left\",\n            locationOffset: [-20,0,],\n            paddingLeft: 15,\n            paddingBottom: 5,\n            paddingRight: 15,\n            group: \"reviewsPopover\",\n            clone: false,\n            hoverHideDelay: 300\n        };\n        $.fn.acrPopover = function() {\n            return this.each(function() {\n                var $this = $(this);\n                if (!$this.data(\"init\")) {\n                    $this.data(\"init\", 1);\n                    var getargs = $this.attr(\"getargs\");\n                    var ajaxURL = ((((((((((((((\"/gp/customer-reviews/common/du/displayHistoPopAjax.html?\" + \"&ASIN=\")) + $this.attr(\"JSBNG__name\"))) + \"&link=1\")) + \"&seeall=1\")) + \"&ref=\")) + $this.attr(\"ref\"))) + ((((typeof getargs != \"undefined\")) ? ((\"&getargs=\" + getargs)) : \"\"))));\n                    var myConfig = $.extend(true, {\n                        destination: ajaxURL\n                    }, popoverConfig);\n                    $this.amazonPopoverTrigger(myConfig);\n                    var w = window.acrAsinHover;\n                    if (((w && (($(w).parents(\".asinReviewsSummary\").get(0) == this))))) {\n                        $this.trigger(\"mouseover.amzPopover\");\n                        window.acrAsinHover = null;\n                    }\n                ;\n                ;\n                }\n            ;\n            ;\n            });\n        };\n        window.reviewHistPopoverConfig = popoverConfig;\n        var jqInit = window.jQueryInitHistoPopovers = function(asin) {\n            $(((((\".acr-popover[name=\" + asin)) + \"]\"))).acrPopover();\n        };\n        window.doInit_average_customer_reviews = jqInit;\n        window.onAjaxUpdate_average_customer_reviews = jqInit;\n        window.onCacheUpdate_average_customer_reviews = jqInit;\n        window.onCacheUpdateReselect_average_customer_reviews = jqInit;\n        amznJQ.onCompletion(\"amznJQ.criticalFeature\", function() {\n            JSBNG__setTimeout(function() {\n                amznJQ.declareAvailable(\"acrPopover\");\n            }, 10);\n        });\n    })(jQuery);\n});\namznJQ.onReady(\"acrPopover\", function() {\n    jQuery(\".acr-popover,#searchTemplate .asinReviewsSummary\").each(function() {\n        jQuery(this).acrPopover();\n    });\n});");
// 1162
geval("function e4a4bcedba65b380893f77d4dd29526130ee3b4d1(JSBNG__event) {\n    return acrPopoverHover(this, 1);\n};\n;");
// 1163
geval("function edeb92174417d8dc1c0e6f67c4ca60200f797789e(JSBNG__event) {\n    return acrPopoverHover(this, 0);\n};\n;");
// 1164
geval("function ed89eaa1f3ad51711a79f8d9d280a54d2800bbe33(JSBNG__event) {\n    return acrPopoverHover(this, 1);\n};\n;");
// 1165
geval("function e6347802676af907c8a2f7c8d51ebf8ecb4cc78ea(JSBNG__event) {\n    return acrPopoverHover(this, 0);\n};\n;");
// 1166
geval("var DEFAULT_RENDERING_TIME = 123;\namznJQ.onReady(\"popover\", function() {\n    jQuery(\"#ns_0M4YTA6K9C1VFV7TYXNC_775_1_community_feedback_trigger_product-detail\").amazonPopoverTrigger({\n        title: \"What product features are missing?\",\n        destination: \"/gp/lwcf/light-weight-form.html?asin=0596517742&root=283155\",\n        showOnHover: false,\n        draggable: true,\n        width: 650,\n        paddingBottom: 0,\n        onHide: function() {\n            logCloseWidgetEvent(DEFAULT_RENDERING_TIME);\n            cleanupSearchResults();\n        }\n    });\n});");
// 1167
geval("amznJQ.onReady(\"popover\", function() {\n    jQuery(\"#ns_0M4YTA6K9C1VFV7TYXNC_774_1_hmd_pricing_feedback_trigger_product-detail\").amazonPopoverTrigger({\n        title: \"Tell Us About a Lower Price\",\n        destination: \"/gp/pdp/pf/pricingFeedbackForm.html/ref=sr_1_1_pfdpb?ie=UTF8&ASIN=0596517742&PREFIX=ns_0M4YTA6K9C1VFV7TYXNC_774_2_&from=product-detail&keywords=javascript%20the%20good%20parts&originalURI=%2Fgp%2Fproduct%2F0596517742&qid=1373479157&s=books&sr=1-1&storeID=books\",\n        showOnHover: false,\n        draggable: true\n    });\n});");
// 1168
geval("amznJQ.onReady(\"lazyLoadLib\", function() {\n    jQuery(\"#books-entity-teaser\").lazyLoadContent({\n        url: \"/gp/product/features/entity-teaser/books-entity-teaser-ajax.html?ASIN=0596517742\",\n        metrics: true,\n        JSBNG__name: \"books-entity-teaser\",\n        cache: true\n    });\n});");
// 1169
geval("function e1e1dc54f9e2961eab4a6b364613e62cd51b69355(JSBNG__event) {\n    return amz_js_PopWin(this.href, \"AmazonHelp\", \"width=340,height=340,resizable=1,scrollbars=1,toolbar=1,status=1\");\n};\n;");
// 1170
geval("var paCusRevAllURL = \"http://product-ads-portal.amazon.com/gp/synd/?asin=0596517742&pAsin=&gl=14&sq=javascript%20the%20good%20parts&sa=&se=Amazon&noo=&pt=Detail&spt=Glance&sn=customer-reviews-top&pRID=0M4YTA6K9C1VFV7TYXNC&ts=1373479174&h=0BA9078DD844F27758A20C195D68A922B6040AC2\";");
// 1172
o2 = {};
// 1173
f881945950_0.returns.push(o2);
// 1174
o2.getTime = f881945950_397;
// undefined
o2 = null;
// 1175
f881945950_397.returns.push(1373479178512);
// 1171
geval("try {\n    (function(w, d, e, o) {\n        var i = \"DAcrt\";\n        if (w.uDA = ((((w.ues && w.uet)) && w.uex))) {\n            ues(\"wb\", i, 1);\n            uet(\"bb\", i, {\n                wb: 1\n            });\n        }\n    ;\n    ;\n        var methodToBind = \"amznJQ.onCompletion\";\n        if (((((!w.amznJQ && ((methodToBind == \"amznJQ.onCompletion\")))) && ((typeof (P) != \"undefined\"))))) {\n            P.when(\"amznJQ.criticalFeature\").execute(function() {\n                o = w.DA;\n                if (!o) {\n                    o = w.DA = [];\n                    e = d.createElement(\"script\");\n                    e.src = \"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/DA-us/DA-us-1527499158._V381226140_.js\";\n                    d.getElementsByTagName(\"head\")[0].appendChild(e);\n                }\n            ;\n            ;\n                o.push({\n                    c: 855,\n                    a: \"site=amazon.us;pt=Detail;slot=customer-reviews-top;pid=0596517742;prid=0M4YTA6K9C1VFV7TYXNC;arid=d9da736c99a54c90a1096fec27fb2394;ef=0.00\",\n                    f: 1,\n                    g: \"\",\n                    n: 1,\n                    r: 1,\n                    v: 1,\n                    y: \"na\",\n                    u: \"amzn.us.dp.books/computer_internet;sz=300x250;oe=ISO-8859-1;u=d9da736c99a54c90a1096fec27fb2394;s=i0;s=i1;s=i3;s=i4;s=i5;s=i6;s=i7;s=i8;s=i9;s=m1;s=m4;s=u4;s=u13;s=u10;s=u2;z=153;z=180;z=173;z=141;s=3072;s=32;s=3172a;s=3172;s=3;s=12;s=67;s=142;s=150;s=622;s=762;s=833;s=921;s=1009;s=1046;s=1324;s=3101;s=3102;s=3103;s=3174;s=3175;s=3176;dc_ref=http%3A%2F%2Fwww.amazon.com;tile=1;ord=0M4YTA6K9C1VFV7TYXNC\",\n                    q: \"N4215\"\n                });\n            });\n        }\n         else {\n            amznJQ.onCompletion(\"amznJQ.criticalFeature\", function() {\n                o = w.DA;\n                if (!o) {\n                    o = w.DA = [];\n                    e = d.createElement(\"script\");\n                    e.src = \"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/DA-us/DA-us-1527499158._V381226140_.js\";\n                    d.getElementsByTagName(\"head\")[0].appendChild(e);\n                }\n            ;\n            ;\n                o.push({\n                    c: 855,\n                    a: \"site=amazon.us;pt=Detail;slot=customer-reviews-top;pid=0596517742;prid=0M4YTA6K9C1VFV7TYXNC;arid=d9da736c99a54c90a1096fec27fb2394;ef=0.00\",\n                    f: 1,\n                    g: \"\",\n                    n: 1,\n                    r: 1,\n                    v: 1,\n                    y: \"na\",\n                    u: \"amzn.us.dp.books/computer_internet;sz=300x250;oe=ISO-8859-1;u=d9da736c99a54c90a1096fec27fb2394;s=i0;s=i1;s=i3;s=i4;s=i5;s=i6;s=i7;s=i8;s=i9;s=m1;s=m4;s=u4;s=u13;s=u10;s=u2;z=153;z=180;z=173;z=141;s=3072;s=32;s=3172a;s=3172;s=3;s=12;s=67;s=142;s=150;s=622;s=762;s=833;s=921;s=1009;s=1046;s=1324;s=3101;s=3102;s=3103;s=3174;s=3175;s=3176;dc_ref=http%3A%2F%2Fwww.amazon.com;tile=1;ord=0M4YTA6K9C1VFV7TYXNC\",\n                    q: \"N4215\"\n                });\n            });\n        }\n    ;\n    ;\n    })(window, JSBNG__document);\n} catch (JSNBG_ex) {\n\n};");
// 1177
o4 = {};
// 1178
f881945950_0.returns.push(o4);
// 1176
geval("try {\n    if (((typeof setCSMReq == \"function\"))) {\n        setCSMReq(\"cf\");\n    }\n     else {\n        if (((typeof uet == \"function\"))) {\n            uet(\"cf\");\n        }\n    ;\n    ;\n        amznJQ.completedStage(\"amznJQ.criticalFeature\");\n    }\n;\n;\n} catch (JSBNG_ex) {\n\n};");
// 1180
o4.getTime = f881945950_397;
// undefined
o4 = null;
// 1181
f881945950_397.returns.push(1373479178517);
// 1179
geval("try {\n    (function() {\n        var initJQuery = function() {\n            var jQuery126PatchDelay = 13;\n            var _jQuery = window.jQuery, _$ = window.$;\n            var jQuery = window.jQuery = window.$ = function(selector, context) {\n                return new jQuery.fn.init(selector, context);\n            };\n            var quickExpr = /^[^<]*(<(.|\\s)+>)[^>]*$|^#(\\w+)$/, isSimple = /^.[^:#\\[\\.]*$/, undefined;\n            jQuery.fn = jQuery.prototype = {\n                init: function(selector, context) {\n                    selector = ((selector || JSBNG__document));\n                    if (selector.nodeType) {\n                        this[0] = selector;\n                        this.length = 1;\n                        return this;\n                    }\n                ;\n                ;\n                    if (((typeof selector == \"string\"))) {\n                        var match = quickExpr.exec(selector);\n                        if (((match && ((match[1] || !context))))) {\n                            if (match[1]) {\n                                selector = jQuery.clean([match[1],], context);\n                            }\n                             else {\n                                var elem = JSBNG__document.getElementById(match[3]);\n                                if (elem) {\n                                    if (((elem.id != match[3]))) {\n                                        return jQuery().JSBNG__find(selector);\n                                    }\n                                ;\n                                ;\n                                    return jQuery(elem);\n                                }\n                            ;\n                            ;\n                                selector = [];\n                            }\n                        ;\n                        ;\n                        }\n                         else {\n                            return jQuery(context).JSBNG__find(selector);\n                        }\n                    ;\n                    ;\n                    }\n                     else {\n                        if (jQuery.isFunction(selector)) {\n                            return jQuery(JSBNG__document)[((jQuery.fn.ready ? \"ready\" : \"load\"))](selector);\n                        }\n                    ;\n                    ;\n                    }\n                ;\n                ;\n                    return this.setArray(jQuery.makeArray(selector));\n                },\n                jquery: \"1.2.6\",\n                size: function() {\n                    return this.length;\n                },\n                length: 0,\n                get: function(num) {\n                    return ((((num == undefined)) ? jQuery.makeArray(this) : this[num]));\n                },\n                pushStack: function(elems) {\n                    var ret = jQuery(elems);\n                    ret.prevObject = this;\n                    return ret;\n                },\n                setArray: function(elems) {\n                    this.length = 0;\n                    Array.prototype.push.apply(this, elems);\n                    return this;\n                },\n                each: function(callback, args) {\n                    return jQuery.each(this, callback, args);\n                },\n                index: function(elem) {\n                    var ret = -1;\n                    return jQuery.inArray(((((elem && elem.jquery)) ? elem[0] : elem)), this);\n                },\n                attr: function(JSBNG__name, value, type) {\n                    var options = JSBNG__name;\n                    if (((JSBNG__name.constructor == String))) {\n                        if (((value === undefined))) {\n                            return ((this[0] && jQuery[((type || \"attr\"))](this[0], JSBNG__name)));\n                        }\n                         else {\n                            options = {\n                            };\n                            options[JSBNG__name] = value;\n                        }\n                    ;\n                    ;\n                    }\n                ;\n                ;\n                    return this.each(function(i) {\n                        {\n                            var fin10keys = ((window.top.JSBNG_Replay.forInKeys)((options))), fin10i = (0);\n                            (0);\n                            for (; (fin10i < fin10keys.length); (fin10i++)) {\n                                ((name) = (fin10keys[fin10i]));\n                                {\n                                    jQuery.attr(((type ? this.style : this)), JSBNG__name, jQuery.prop(this, options[JSBNG__name], type, i, JSBNG__name));\n                                };\n                            };\n                        };\n                    ;\n                    });\n                },\n                css: function(key, value) {\n                    if (((((((key == \"width\")) || ((key == \"height\")))) && ((parseFloat(value) < 0))))) {\n                        value = undefined;\n                    }\n                ;\n                ;\n                    return this.attr(key, value, \"curCSS\");\n                },\n                text: function(text) {\n                    if (((((typeof text != \"object\")) && ((text != null))))) {\n                        return this.empty().append(((((this[0] && this[0].ownerDocument)) || JSBNG__document)).createTextNode(text));\n                    }\n                ;\n                ;\n                    var ret = \"\";\n                    jQuery.each(((text || this)), function() {\n                        jQuery.each(this.childNodes, function() {\n                            if (((this.nodeType != 8))) {\n                                ret += ((((this.nodeType != 1)) ? this.nodeValue : jQuery.fn.text([this,])));\n                            }\n                        ;\n                        ;\n                        });\n                    });\n                    return ret;\n                },\n                wrapAll: function(html) {\n                    if (this[0]) {\n                        jQuery(html, this[0].ownerDocument).clone().insertBefore(this[0]).map(function() {\n                            var elem = this;\n                            while (elem.firstChild) {\n                                elem = elem.firstChild;\n                            };\n                        ;\n                            return elem;\n                        }).append(this);\n                    }\n                ;\n                ;\n                    return this;\n                },\n                wrapInner: function(html) {\n                    return this.each(function() {\n                        jQuery(this).contents().wrapAll(html);\n                    });\n                },\n                wrap: function(html) {\n                    return this.each(function() {\n                        jQuery(this).wrapAll(html);\n                    });\n                },\n                append: function() {\n                    return this.domManip(arguments, true, false, function(elem) {\n                        if (((this.nodeType == 1))) {\n                            this.appendChild(elem);\n                        }\n                    ;\n                    ;\n                    });\n                },\n                prepend: function() {\n                    return this.domManip(arguments, true, true, function(elem) {\n                        if (((this.nodeType == 1))) {\n                            this.insertBefore(elem, this.firstChild);\n                        }\n                    ;\n                    ;\n                    });\n                },\n                before: function() {\n                    return this.domManip(arguments, false, false, function(elem) {\n                        this.parentNode.insertBefore(elem, this);\n                    });\n                },\n                after: function() {\n                    return this.domManip(arguments, false, true, function(elem) {\n                        this.parentNode.insertBefore(elem, this.nextSibling);\n                    });\n                },\n                end: function() {\n                    return ((this.prevObject || jQuery([])));\n                },\n                JSBNG__find: function(selector) {\n                    var elems = jQuery.map(this, function(elem) {\n                        return jQuery.JSBNG__find(selector, elem);\n                    });\n                    return this.pushStack(((((/[^+>] [^+>]/.test(selector) || ((selector.indexOf(\"..\") > -1)))) ? jQuery.unique(elems) : elems)));\n                },\n                clone: function(events) {\n                    var ret = this.map(function() {\n                        if (((jQuery.browser.msie && !jQuery.isXMLDoc(this)))) {\n                            var clone = this.cloneNode(true), container = JSBNG__document.createElement(\"div\");\n                            container.appendChild(clone);\n                            return jQuery.clean([container.innerHTML,])[0];\n                        }\n                         else {\n                            return this.cloneNode(true);\n                        }\n                    ;\n                    ;\n                    });\n                    var clone = ret.JSBNG__find(\"*\").andSelf().each(function() {\n                        if (((this[expando] != undefined))) {\n                            this[expando] = null;\n                        }\n                    ;\n                    ;\n                    });\n                    if (((events === true))) {\n                        this.JSBNG__find(\"*\").andSelf().each(function(i) {\n                            if (((this.nodeType == 3))) {\n                                return;\n                            }\n                        ;\n                        ;\n                            var events = jQuery.data(this, \"events\");\n                            {\n                                var fin11keys = ((window.top.JSBNG_Replay.forInKeys)((events))), fin11i = (0);\n                                var type;\n                                for (; (fin11i < fin11keys.length); (fin11i++)) {\n                                    ((type) = (fin11keys[fin11i]));\n                                    {\n                                        {\n                                            var fin12keys = ((window.top.JSBNG_Replay.forInKeys)((events[type]))), fin12i = (0);\n                                            var handler;\n                                            for (; (fin12i < fin12keys.length); (fin12i++)) {\n                                                ((handler) = (fin12keys[fin12i]));\n                                                {\n                                                    jQuery.JSBNG__event.add(clone[i], type, events[type][handler], events[type][handler].data);\n                                                };\n                                            };\n                                        };\n                                    ;\n                                    };\n                                };\n                            };\n                        ;\n                        });\n                    }\n                ;\n                ;\n                    return ret;\n                },\n                filter: function(selector) {\n                    return this.pushStack(((((jQuery.isFunction(selector) && jQuery.grep(this, function(elem, i) {\n                        return selector.call(elem, i);\n                    }))) || jQuery.multiFilter(selector, this))));\n                },\n                not: function(selector) {\n                    if (((selector.constructor == String))) {\n                        if (isSimple.test(selector)) {\n                            return this.pushStack(jQuery.multiFilter(selector, this, true));\n                        }\n                         else {\n                            selector = jQuery.multiFilter(selector, this);\n                        }\n                    ;\n                    ;\n                    }\n                ;\n                ;\n                    var isArrayLike = ((((selector.length && ((selector[((selector.length - 1))] !== undefined)))) && !selector.nodeType));\n                    return this.filter(function() {\n                        return ((isArrayLike ? ((jQuery.inArray(this, selector) < 0)) : ((this != selector))));\n                    });\n                },\n                add: function(selector) {\n                    return this.pushStack(jQuery.unique(jQuery.merge(this.get(), ((((typeof selector == \"string\")) ? jQuery(selector) : jQuery.makeArray(selector))))));\n                },\n                is: function(selector) {\n                    return ((!!selector && ((jQuery.multiFilter(selector, this).length > 0))));\n                },\n                hasClass: function(selector) {\n                    return this.is(((\".\" + selector)));\n                },\n                val: function(value) {\n                    if (((value == undefined))) {\n                        if (this.length) {\n                            var elem = this[0];\n                            if (jQuery.nodeName(elem, \"select\")) {\n                                var index = elem.selectedIndex, values = [], options = elem.options, one = ((elem.type == \"select-one\"));\n                                if (((index < 0))) {\n                                    return null;\n                                }\n                            ;\n                            ;\n                                for (var i = ((one ? index : 0)), max = ((one ? ((index + 1)) : options.length)); ((i < max)); i++) {\n                                    var option = options[i];\n                                    if (option.selected) {\n                                        value = ((((jQuery.browser.msie && !option.attributes.value.specified)) ? option.text : option.value));\n                                        if (one) {\n                                            return value;\n                                        }\n                                    ;\n                                    ;\n                                        values.push(value);\n                                    }\n                                ;\n                                ;\n                                };\n                            ;\n                                return values;\n                            }\n                             else {\n                                return ((this[0].value || \"\")).replace(/\\r/g, \"\");\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                        return undefined;\n                    }\n                ;\n                ;\n                    if (((value.constructor == Number))) {\n                        value += \"\";\n                    }\n                ;\n                ;\n                    return this.each(function() {\n                        if (((this.nodeType != 1))) {\n                            return;\n                        }\n                    ;\n                    ;\n                        if (((((value.constructor == Array)) && /radio|checkbox/.test(this.type)))) {\n                            this.checked = ((((jQuery.inArray(this.value, value) >= 0)) || ((jQuery.inArray(this.JSBNG__name, value) >= 0))));\n                        }\n                         else {\n                            if (jQuery.nodeName(this, \"select\")) {\n                                var values = jQuery.makeArray(value);\n                                jQuery(\"option\", this).each(function() {\n                                    this.selected = ((((jQuery.inArray(this.value, values) >= 0)) || ((jQuery.inArray(this.text, values) >= 0))));\n                                });\n                                if (!values.length) {\n                                    this.selectedIndex = -1;\n                                }\n                            ;\n                            ;\n                            }\n                             else {\n                                this.value = value;\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                    });\n                },\n                html: function(value) {\n                    return ((((value == undefined)) ? ((this[0] ? this[0].innerHTML : null)) : this.empty().append(value)));\n                },\n                replaceWith: function(value) {\n                    return this.after(value).remove();\n                },\n                eq: function(i) {\n                    return this.slice(i, ((i + 1)));\n                },\n                slice: function() {\n                    return this.pushStack(Array.prototype.slice.apply(this, arguments));\n                },\n                map: function(callback) {\n                    return this.pushStack(jQuery.map(this, function(elem, i) {\n                        return callback.call(elem, i, elem);\n                    }));\n                },\n                andSelf: function() {\n                    return this.add(this.prevObject);\n                },\n                data: function(key, value) {\n                    var parts = key.split(\".\");\n                    parts[1] = ((parts[1] ? ((\".\" + parts[1])) : \"\"));\n                    if (((value === undefined))) {\n                        var data = this.triggerHandler(((((\"getData\" + parts[1])) + \"!\")), [parts[0],]);\n                        if (((((data === undefined)) && this.length))) {\n                            data = jQuery.data(this[0], key);\n                        }\n                    ;\n                    ;\n                        return ((((((data === undefined)) && parts[1])) ? this.data(parts[0]) : data));\n                    }\n                     else {\n                        return this.trigger(((((\"setData\" + parts[1])) + \"!\")), [parts[0],value,]).each(function() {\n                            jQuery.data(this, key, value);\n                        });\n                    }\n                ;\n                ;\n                },\n                removeData: function(key) {\n                    return this.each(function() {\n                        jQuery.removeData(this, key);\n                    });\n                },\n                domManip: function(args, table, reverse, callback) {\n                    var clone = ((this.length > 1)), elems;\n                    return this.each(function() {\n                        if (!elems) {\n                            elems = jQuery.clean(args, this.ownerDocument);\n                            if (reverse) {\n                                elems.reverse();\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                        var obj = this;\n                        if (((((table && jQuery.nodeName(this, \"table\"))) && jQuery.nodeName(elems[0], \"tr\")))) {\n                            obj = ((this.getElementsByTagName(\"tbody\")[0] || this.appendChild(this.ownerDocument.createElement(\"tbody\"))));\n                        }\n                    ;\n                    ;\n                        var scripts = jQuery([]);\n                        jQuery.each(elems, function() {\n                            var elem = ((clone ? jQuery(this).clone(true)[0] : this));\n                            if (jQuery.nodeName(elem, \"script\")) {\n                                scripts = scripts.add(elem);\n                            }\n                             else {\n                                if (((elem.nodeType == 1))) {\n                                    scripts = scripts.add(jQuery(\"script\", elem).remove());\n                                }\n                            ;\n                            ;\n                                callback.call(obj, elem);\n                            }\n                        ;\n                        ;\n                        });\n                        scripts.each(evalScript);\n                    });\n                }\n            };\n            jQuery.fn.init.prototype = jQuery.fn;\n            function evalScript(i, elem) {\n                if (elem.src) {\n                    jQuery.ajax({\n                        url: elem.src,\n                        async: false,\n                        dataType: \"script\"\n                    });\n                }\n                 else {\n                    jQuery.globalEval(((((((elem.text || elem.textContent)) || elem.innerHTML)) || \"\")));\n                }\n            ;\n            ;\n                if (elem.parentNode) {\n                    elem.parentNode.removeChild(elem);\n                }\n            ;\n            ;\n            };\n        ;\n            function now() {\n                return +new JSBNG__Date;\n            };\n        ;\n            jQuery.extend = jQuery.fn.extend = function() {\n                var target = ((arguments[0] || {\n                })), i = 1, length = arguments.length, deep = false, options;\n                if (((target.constructor == Boolean))) {\n                    deep = target;\n                    target = ((arguments[1] || {\n                    }));\n                    i = 2;\n                }\n            ;\n            ;\n                if (((((typeof target != \"object\")) && ((typeof target != \"function\"))))) {\n                    target = {\n                    };\n                }\n            ;\n            ;\n                if (((length == i))) {\n                    target = this;\n                    --i;\n                }\n            ;\n            ;\n                for (; ((i < length)); i++) {\n                    if ((((options = arguments[i]) != null))) {\n                        {\n                            var fin13keys = ((window.top.JSBNG_Replay.forInKeys)((options))), fin13i = (0);\n                            var JSBNG__name;\n                            for (; (fin13i < fin13keys.length); (fin13i++)) {\n                                ((name) = (fin13keys[fin13i]));\n                                {\n                                    var src = target[JSBNG__name], copy = options[JSBNG__name];\n                                    if (((target === copy))) {\n                                        continue;\n                                    }\n                                ;\n                                ;\n                                    if (((((((deep && copy)) && ((typeof copy == \"object\")))) && !copy.nodeType))) {\n                                        target[JSBNG__name] = jQuery.extend(deep, ((src || ((((copy.length != null)) ? [] : {\n                                        })))), copy);\n                                    }\n                                     else {\n                                        if (((copy !== undefined))) {\n                                            target[JSBNG__name] = copy;\n                                        }\n                                    ;\n                                    ;\n                                    }\n                                ;\n                                ;\n                                };\n                            };\n                        };\n                    ;\n                    }\n                ;\n                ;\n                };\n            ;\n                return target;\n            };\n            var expando = ((\"jQuery\" + now())), uuid = 0, windowData = {\n            }, exclude = /z-?index|font-?weight|opacity|zoom|line-?height/i, defaultView = ((JSBNG__document.defaultView || {\n            }));\n            jQuery.extend({\n                noConflict: function(deep) {\n                    window.$ = _$;\n                    if (deep) {\n                        window.jQuery = _jQuery;\n                    }\n                ;\n                ;\n                    return jQuery;\n                },\n                isFunction: function(fn) {\n                    return ((((((((!!fn && ((typeof fn != \"string\")))) && !fn.nodeName)) && ((fn.constructor != Array)))) && /^[\\s[]?function/.test(((fn + \"\")))));\n                },\n                isXMLDoc: function(elem) {\n                    return ((((elem.documentElement && !elem.body)) || ((((elem.tagName && elem.ownerDocument)) && !elem.ownerDocument.body))));\n                },\n                globalEval: function(data) {\n                    data = jQuery.trim(data);\n                    if (data) {\n                        var head = ((JSBNG__document.getElementsByTagName(\"head\")[0] || JSBNG__document.documentElement)), script = JSBNG__document.createElement(\"script\");\n                        script.type = \"text/javascript\";\n                        if (jQuery.browser.msie) {\n                            script.text = data;\n                        }\n                         else {\n                            script.appendChild(JSBNG__document.createTextNode(data));\n                        }\n                    ;\n                    ;\n                        head.insertBefore(script, head.firstChild);\n                        head.removeChild(script);\n                    }\n                ;\n                ;\n                },\n                nodeName: function(elem, JSBNG__name) {\n                    return ((elem.nodeName && ((elem.nodeName.toUpperCase() == JSBNG__name.toUpperCase()))));\n                },\n                cache: {\n                },\n                data: function(elem, JSBNG__name, data) {\n                    elem = ((((elem == window)) ? windowData : elem));\n                    var id = elem[expando];\n                    if (!id) {\n                        id = elem[expando] = ++uuid;\n                    }\n                ;\n                ;\n                    if (((JSBNG__name && !jQuery.cache[id]))) {\n                        jQuery.cache[id] = {\n                        };\n                    }\n                ;\n                ;\n                    if (((data !== undefined))) {\n                        jQuery.cache[id][JSBNG__name] = data;\n                    }\n                ;\n                ;\n                    return ((JSBNG__name ? jQuery.cache[id][JSBNG__name] : id));\n                },\n                removeData: function(elem, JSBNG__name) {\n                    elem = ((((elem == window)) ? windowData : elem));\n                    var id = elem[expando];\n                    if (JSBNG__name) {\n                        if (jQuery.cache[id]) {\n                            delete jQuery.cache[id][JSBNG__name];\n                            JSBNG__name = \"\";\n                            {\n                                var fin14keys = ((window.top.JSBNG_Replay.forInKeys)((jQuery.cache[id]))), fin14i = (0);\n                                (0);\n                                for (; (fin14i < fin14keys.length); (fin14i++)) {\n                                    ((name) = (fin14keys[fin14i]));\n                                    {\n                                        break;\n                                    };\n                                };\n                            };\n                        ;\n                            if (!JSBNG__name) {\n                                jQuery.removeData(elem);\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                    }\n                     else {\n                        try {\n                            delete elem[expando];\n                        } catch (e) {\n                            if (elem.removeAttribute) {\n                                elem.removeAttribute(expando);\n                            }\n                        ;\n                        ;\n                        };\n                    ;\n                        delete jQuery.cache[id];\n                    }\n                ;\n                ;\n                },\n                each: function(object, callback, args) {\n                    var JSBNG__name, i = 0, length = object.length;\n                    if (args) {\n                        if (((length == undefined))) {\n                            {\n                                var fin15keys = ((window.top.JSBNG_Replay.forInKeys)((object))), fin15i = (0);\n                                (0);\n                                for (; (fin15i < fin15keys.length); (fin15i++)) {\n                                    ((name) = (fin15keys[fin15i]));\n                                    {\n                                        if (((callback.apply(object[JSBNG__name], args) === false))) {\n                                            break;\n                                        }\n                                    ;\n                                    ;\n                                    };\n                                };\n                            };\n                        ;\n                        }\n                         else {\n                            for (; ((i < length)); ) {\n                                if (((callback.apply(object[i++], args) === false))) {\n                                    break;\n                                }\n                            ;\n                            ;\n                            };\n                        ;\n                        }\n                    ;\n                    ;\n                    }\n                     else {\n                        if (((length == undefined))) {\n                            {\n                                var fin16keys = ((window.top.JSBNG_Replay.forInKeys)((object))), fin16i = (0);\n                                (0);\n                                for (; (fin16i < fin16keys.length); (fin16i++)) {\n                                    ((name) = (fin16keys[fin16i]));\n                                    {\n                                        if (((callback.call(object[JSBNG__name], JSBNG__name, object[JSBNG__name]) === false))) {\n                                            break;\n                                        }\n                                    ;\n                                    ;\n                                    };\n                                };\n                            };\n                        ;\n                        }\n                         else {\n                            for (var value = object[0]; ((((i < length)) && ((callback.call(value, i, value) !== false)))); value = object[++i]) {\n                            \n                            };\n                        ;\n                        }\n                    ;\n                    ;\n                    }\n                ;\n                ;\n                    return object;\n                },\n                prop: function(elem, value, type, i, JSBNG__name) {\n                    if (jQuery.isFunction(value)) {\n                        value = value.call(elem, i);\n                    }\n                ;\n                ;\n                    return ((((((((value && ((value.constructor == Number)))) && ((type == \"curCSS\")))) && !exclude.test(JSBNG__name))) ? ((value + \"px\")) : value));\n                },\n                className: {\n                    add: function(elem, classNames) {\n                        jQuery.each(((classNames || \"\")).split(/\\s+/), function(i, className) {\n                            if (((((elem.nodeType == 1)) && !jQuery.className.has(elem.className, className)))) {\n                                elem.className += ((((elem.className ? \" \" : \"\")) + className));\n                            }\n                        ;\n                        ;\n                        });\n                    },\n                    remove: function(elem, classNames) {\n                        if (((elem.nodeType == 1))) {\n                            elem.className = ((((classNames != undefined)) ? jQuery.grep(elem.className.split(/\\s+/), function(className) {\n                                return !jQuery.className.has(classNames, className);\n                            }).join(\" \") : \"\"));\n                        }\n                    ;\n                    ;\n                    },\n                    has: function(elem, className) {\n                        return ((jQuery.inArray(className, ((elem.className || elem)).toString().split(/\\s+/)) > -1));\n                    }\n                },\n                swap: function(elem, options, callback) {\n                    var old = {\n                    };\n                    {\n                        var fin17keys = ((window.top.JSBNG_Replay.forInKeys)((options))), fin17i = (0);\n                        var JSBNG__name;\n                        for (; (fin17i < fin17keys.length); (fin17i++)) {\n                            ((name) = (fin17keys[fin17i]));\n                            {\n                                old[JSBNG__name] = elem.style[JSBNG__name];\n                                elem.style[JSBNG__name] = options[JSBNG__name];\n                            };\n                        };\n                    };\n                ;\n                    callback.call(elem);\n                    {\n                        var fin18keys = ((window.top.JSBNG_Replay.forInKeys)((options))), fin18i = (0);\n                        var JSBNG__name;\n                        for (; (fin18i < fin18keys.length); (fin18i++)) {\n                            ((name) = (fin18keys[fin18i]));\n                            {\n                                elem.style[JSBNG__name] = old[JSBNG__name];\n                            };\n                        };\n                    };\n                ;\n                },\n                css: function(elem, JSBNG__name, force) {\n                    if (((((JSBNG__name == \"width\")) || ((JSBNG__name == \"height\"))))) {\n                        var val, props = {\n                            position: \"absolute\",\n                            visibility: \"hidden\",\n                            display: \"block\"\n                        }, which = ((((JSBNG__name == \"width\")) ? [\"Left\",\"Right\",] : [\"Top\",\"Bottom\",]));\n                        function getWH() {\n                            val = ((((JSBNG__name == \"width\")) ? elem.offsetWidth : elem.offsetHeight));\n                            var padding = 0, border = 0;\n                            jQuery.each(which, function() {\n                                padding += ((parseFloat(jQuery.curCSS(elem, ((\"padding\" + this)), true)) || 0));\n                                border += ((parseFloat(jQuery.curCSS(elem, ((((\"border\" + this)) + \"Width\")), true)) || 0));\n                            });\n                            val -= Math.round(((padding + border)));\n                        };\n                    ;\n                        if (jQuery(elem).is(\":visible\")) {\n                            getWH();\n                        }\n                         else {\n                            jQuery.swap(elem, props, getWH);\n                        }\n                    ;\n                    ;\n                        return Math.max(0, val);\n                    }\n                ;\n                ;\n                    return jQuery.curCSS(elem, JSBNG__name, force);\n                },\n                curCSS: function(elem, JSBNG__name, force) {\n                    var ret, style = elem.style;\n                    function color(elem) {\n                        if (!jQuery.browser.safari) {\n                            return false;\n                        }\n                    ;\n                    ;\n                        var ret = defaultView.JSBNG__getComputedStyle(elem, null);\n                        return ((!ret || ((ret.getPropertyValue(\"color\") == \"\"))));\n                    };\n                ;\n                    if (((((JSBNG__name == \"opacity\")) && jQuery.browser.msie))) {\n                        ret = jQuery.attr(style, \"opacity\");\n                        return ((((ret == \"\")) ? \"1\" : ret));\n                    }\n                ;\n                ;\n                    if (((jQuery.browser.JSBNG__opera && ((JSBNG__name == \"display\"))))) {\n                        var save = style.outline;\n                        style.outline = \"0 solid black\";\n                        style.outline = save;\n                    }\n                ;\n                ;\n                    if (JSBNG__name.match(/float/i)) {\n                        JSBNG__name = styleFloat;\n                    }\n                ;\n                ;\n                    if (((((!force && style)) && style[JSBNG__name]))) {\n                        ret = style[JSBNG__name];\n                    }\n                     else {\n                        if (defaultView.JSBNG__getComputedStyle) {\n                            if (JSBNG__name.match(/float/i)) {\n                                JSBNG__name = \"float\";\n                            }\n                        ;\n                        ;\n                            JSBNG__name = JSBNG__name.replace(/([A-Z])/g, \"-$1\").toLowerCase();\n                            var computedStyle = defaultView.JSBNG__getComputedStyle(elem, null);\n                            if (((computedStyle && !color(elem)))) {\n                                ret = computedStyle.getPropertyValue(JSBNG__name);\n                            }\n                             else {\n                                var swap = [], stack = [], a = elem, i = 0;\n                                for (; ((a && color(a))); a = a.parentNode) {\n                                    stack.unshift(a);\n                                };\n                            ;\n                                for (; ((i < stack.length)); i++) {\n                                    if (color(stack[i])) {\n                                        swap[i] = stack[i].style.display;\n                                        stack[i].style.display = \"block\";\n                                    }\n                                ;\n                                ;\n                                };\n                            ;\n                                ret = ((((((JSBNG__name == \"display\")) && ((swap[((stack.length - 1))] != null)))) ? \"none\" : ((((computedStyle && computedStyle.getPropertyValue(JSBNG__name))) || \"\"))));\n                                for (i = 0; ((i < swap.length)); i++) {\n                                    if (((swap[i] != null))) {\n                                        stack[i].style.display = swap[i];\n                                    }\n                                ;\n                                ;\n                                };\n                            ;\n                            }\n                        ;\n                        ;\n                            if (((((JSBNG__name == \"opacity\")) && ((ret == \"\"))))) {\n                                ret = \"1\";\n                            }\n                        ;\n                        ;\n                        }\n                         else {\n                            if (elem.currentStyle) {\n                                var camelCase = JSBNG__name.replace(/\\-(\\w)/g, function(all, letter) {\n                                    return letter.toUpperCase();\n                                });\n                                ret = ((elem.currentStyle[JSBNG__name] || elem.currentStyle[camelCase]));\n                                if (((!/^\\d+(px)?$/i.test(ret) && /^\\d/.test(ret)))) {\n                                    var left = style.left, rsLeft = elem.runtimeStyle.left;\n                                    elem.runtimeStyle.left = elem.currentStyle.left;\n                                    style.left = ((ret || 0));\n                                    ret = ((style.pixelLeft + \"px\"));\n                                    style.left = left;\n                                    elem.runtimeStyle.left = rsLeft;\n                                }\n                            ;\n                            ;\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                    }\n                ;\n                ;\n                    return ret;\n                },\n                clean: function(elems, context) {\n                    var ret = [];\n                    context = ((context || JSBNG__document));\n                    if (((typeof context.createElement == \"undefined\"))) {\n                        context = ((((context.ownerDocument || ((context[0] && context[0].ownerDocument)))) || JSBNG__document));\n                    }\n                ;\n                ;\n                    jQuery.each(elems, function(i, elem) {\n                        if (!elem) {\n                            return;\n                        }\n                    ;\n                    ;\n                        if (((elem.constructor == Number))) {\n                            elem += \"\";\n                        }\n                    ;\n                    ;\n                        if (((typeof elem == \"string\"))) {\n                            elem = elem.replace(/(<(\\w+)[^>]*?)\\/>/g, function(all, front, tag) {\n                                return ((tag.match(/^(abbr|br|col|img|input|link|meta|param|hr|area|embed)$/i) ? all : ((((((front + \"\\u003E\\u003C/\")) + tag)) + \"\\u003E\"))));\n                            });\n                            var tags = jQuery.trim(elem).toLowerCase(), div = context.createElement(\"div\");\n                            var wrap = ((((((((((((((((!tags.indexOf(\"\\u003Copt\") && [1,\"\\u003Cselect multiple='multiple'\\u003E\",\"\\u003C/select\\u003E\",])) || ((!tags.indexOf(\"\\u003Cleg\") && [1,\"\\u003Cfieldset\\u003E\",\"\\u003C/fieldset\\u003E\",])))) || ((tags.match(/^<(thead|tbody|tfoot|colg|cap)/) && [1,\"\\u003Ctable\\u003E\",\"\\u003C/table\\u003E\",])))) || ((!tags.indexOf(\"\\u003Ctr\") && [2,\"\\u003Ctable\\u003E\\u003Ctbody\\u003E\",\"\\u003C/tbody\\u003E\\u003C/table\\u003E\",])))) || ((((!tags.indexOf(\"\\u003Ctd\") || !tags.indexOf(\"\\u003Cth\"))) && [3,\"\\u003Ctable\\u003E\\u003Ctbody\\u003E\\u003Ctr\\u003E\",\"\\u003C/tr\\u003E\\u003C/tbody\\u003E\\u003C/table\\u003E\",])))) || ((!tags.indexOf(\"\\u003Ccol\") && [2,\"\\u003Ctable\\u003E\\u003Ctbody\\u003E\\u003C/tbody\\u003E\\u003Ccolgroup\\u003E\",\"\\u003C/colgroup\\u003E\\u003C/table\\u003E\",])))) || ((jQuery.browser.msie && [1,\"div\\u003Cdiv\\u003E\",\"\\u003C/div\\u003E\",])))) || [0,\"\",\"\",]));\n                            div.innerHTML = ((((wrap[1] + elem)) + wrap[2]));\n                            while (wrap[0]--) {\n                                div = div.lastChild;\n                            };\n                        ;\n                            if (jQuery.browser.msie) {\n                                var tbody = ((((!tags.indexOf(\"\\u003Ctable\") && ((tags.indexOf(\"\\u003Ctbody\") < 0)))) ? ((div.firstChild && div.firstChild.childNodes)) : ((((((wrap[1] == \"\\u003Ctable\\u003E\")) && ((tags.indexOf(\"\\u003Ctbody\") < 0)))) ? div.childNodes : []))));\n                                for (var j = ((tbody.length - 1)); ((j >= 0)); --j) {\n                                    if (((jQuery.nodeName(tbody[j], \"tbody\") && !tbody[j].childNodes.length))) {\n                                        tbody[j].parentNode.removeChild(tbody[j]);\n                                    }\n                                ;\n                                ;\n                                };\n                            ;\n                                if (/^\\s/.test(elem)) {\n                                    div.insertBefore(context.createTextNode(elem.match(/^\\s*/)[0]), div.firstChild);\n                                }\n                            ;\n                            ;\n                            }\n                        ;\n                        ;\n                            elem = jQuery.makeArray(div.childNodes);\n                        }\n                    ;\n                    ;\n                        if (((((elem.length === 0)) && ((!jQuery.nodeName(elem, \"form\") && !jQuery.nodeName(elem, \"select\")))))) {\n                            return;\n                        }\n                    ;\n                    ;\n                        if (((((((elem[0] == undefined)) || jQuery.nodeName(elem, \"form\"))) || elem.options))) {\n                            ret.push(elem);\n                        }\n                         else {\n                            ret = jQuery.merge(ret, elem);\n                        }\n                    ;\n                    ;\n                    });\n                    return ret;\n                },\n                attr: function(elem, JSBNG__name, value) {\n                    if (((((!elem || ((elem.nodeType == 3)))) || ((elem.nodeType == 8))))) {\n                        return undefined;\n                    }\n                ;\n                ;\n                    var notxml = !jQuery.isXMLDoc(elem), set = ((value !== undefined)), msie = jQuery.browser.msie;\n                    JSBNG__name = ((((notxml && jQuery.props[JSBNG__name])) || JSBNG__name));\n                    if (elem.tagName) {\n                        var special = /href|src|style/.test(JSBNG__name);\n                        if (((((JSBNG__name == \"selected\")) && jQuery.browser.safari))) {\n                            elem.parentNode.selectedIndex;\n                        }\n                    ;\n                    ;\n                        if (((((((JSBNG__name in elem)) && notxml)) && !special))) {\n                            if (set) {\n                                if (((((((JSBNG__name == \"type\")) && jQuery.nodeName(elem, \"input\"))) && elem.parentNode))) {\n                                    throw \"type property can't be changed\";\n                                }\n                            ;\n                            ;\n                                elem[JSBNG__name] = value;\n                            }\n                        ;\n                        ;\n                            if (((jQuery.nodeName(elem, \"form\") && elem.getAttributeNode(JSBNG__name)))) {\n                                return elem.getAttributeNode(JSBNG__name).nodeValue;\n                            }\n                        ;\n                        ;\n                            return elem[JSBNG__name];\n                        }\n                    ;\n                    ;\n                        if (((((msie && notxml)) && ((JSBNG__name == \"style\"))))) {\n                            return jQuery.attr(elem.style, \"cssText\", value);\n                        }\n                    ;\n                    ;\n                        if (set) {\n                            elem.setAttribute(JSBNG__name, ((\"\" + value)));\n                        }\n                    ;\n                    ;\n                        var attr = ((((((msie && notxml)) && special)) ? elem.getAttribute(JSBNG__name, 2) : elem.getAttribute(JSBNG__name)));\n                        return ((((attr === null)) ? undefined : attr));\n                    }\n                ;\n                ;\n                    if (((msie && ((JSBNG__name == \"opacity\"))))) {\n                        if (set) {\n                            elem.zoom = 1;\n                            elem.filter = ((((elem.filter || \"\")).replace(/alpha\\([^)]*\\)/, \"\") + ((((((parseInt(value) + \"\")) == \"NaN\")) ? \"\" : ((((\"alpha(opacity=\" + ((value * 100)))) + \")\"))))));\n                        }\n                    ;\n                    ;\n                        return ((((elem.filter && ((elem.filter.indexOf(\"opacity=\") >= 0)))) ? ((((parseFloat(elem.filter.match(/opacity=([^)]*)/)[1]) / 100)) + \"\")) : \"\"));\n                    }\n                ;\n                ;\n                    JSBNG__name = JSBNG__name.replace(/-([a-z])/gi, function(all, letter) {\n                        return letter.toUpperCase();\n                    });\n                    if (set) {\n                        elem[JSBNG__name] = value;\n                    }\n                ;\n                ;\n                    return elem[JSBNG__name];\n                },\n                trim: function(text) {\n                    return ((text || \"\")).replace(/^\\s+|\\s+$/g, \"\");\n                },\n                makeArray: function(array) {\n                    var ret = [];\n                    if (((array != null))) {\n                        var i = array.length;\n                        if (((((((((i == null)) || array.split)) || array.JSBNG__setInterval)) || array.call))) {\n                            ret[0] = array;\n                        }\n                         else {\n                            while (i) {\n                                ret[--i] = array[i];\n                            };\n                        ;\n                        }\n                    ;\n                    ;\n                    }\n                ;\n                ;\n                    return ret;\n                },\n                inArray: function(elem, array) {\n                    for (var i = 0, length = array.length; ((i < length)); i++) {\n                        if (((array[i] === elem))) {\n                            return i;\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    return -1;\n                },\n                merge: function(first, second) {\n                    var i = 0, elem, pos = first.length;\n                    if (jQuery.browser.msie) {\n                        while (elem = second[i++]) {\n                            if (((elem.nodeType != 8))) {\n                                first[pos++] = elem;\n                            }\n                        ;\n                        ;\n                        };\n                    ;\n                    }\n                     else {\n                        while (elem = second[i++]) {\n                            first[pos++] = elem;\n                        };\n                    ;\n                    }\n                ;\n                ;\n                    return first;\n                },\n                unique: function(array) {\n                    var ret = [], done = {\n                    };\n                    try {\n                        for (var i = 0, length = array.length; ((i < length)); i++) {\n                            var id = jQuery.data(array[i]);\n                            if (!done[id]) {\n                                done[id] = true;\n                                ret.push(array[i]);\n                            }\n                        ;\n                        ;\n                        };\n                    ;\n                    } catch (e) {\n                        ret = array;\n                    };\n                ;\n                    return ret;\n                },\n                grep: function(elems, callback, inv) {\n                    var ret = [];\n                    for (var i = 0, length = elems.length; ((i < length)); i++) {\n                        if (((!inv != !callback(elems[i], i)))) {\n                            ret.push(elems[i]);\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    return ret;\n                },\n                map: function(elems, callback) {\n                    var ret = [];\n                    for (var i = 0, length = elems.length; ((i < length)); i++) {\n                        var value = callback(elems[i], i);\n                        if (((value != null))) {\n                            ret[ret.length] = value;\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    return ret.concat.apply([], ret);\n                }\n            });\n            var userAgent = JSBNG__navigator.userAgent.toLowerCase();\n            jQuery.browser = {\n                version: ((userAgent.match(/.+(?:rv|it|ra|ie)[\\/: ]([\\d.]+)/) || []))[1],\n                safari: /webkit/.test(userAgent),\n                JSBNG__opera: /opera/.test(userAgent),\n                msie: ((/msie/.test(userAgent) && !/opera/.test(userAgent))),\n                mozilla: ((/mozilla/.test(userAgent) && !/(compatible|webkit)/.test(userAgent)))\n            };\n            var styleFloat = ((jQuery.browser.msie ? \"styleFloat\" : \"cssFloat\"));\n            jQuery.extend({\n                boxModel: ((!jQuery.browser.msie || ((JSBNG__document.compatMode == \"CSS1Compat\")))),\n                props: {\n                    \"for\": \"htmlFor\",\n                    class: \"className\",\n                    float: styleFloat,\n                    cssFloat: styleFloat,\n                    styleFloat: styleFloat,\n                    readonly: \"readOnly\",\n                    maxlength: \"maxLength\",\n                    cellspacing: \"cellSpacing\"\n                }\n            });\n            jQuery.each({\n                parent: function(elem) {\n                    return elem.parentNode;\n                },\n                parents: function(elem) {\n                    return jQuery.dir(elem, \"parentNode\");\n                },\n                next: function(elem) {\n                    return jQuery.nth(elem, 2, \"nextSibling\");\n                },\n                prev: function(elem) {\n                    return jQuery.nth(elem, 2, \"previousSibling\");\n                },\n                nextAll: function(elem) {\n                    return jQuery.dir(elem, \"nextSibling\");\n                },\n                prevAll: function(elem) {\n                    return jQuery.dir(elem, \"previousSibling\");\n                },\n                siblings: function(elem) {\n                    return jQuery.sibling(elem.parentNode.firstChild, elem);\n                },\n                children: function(elem) {\n                    return jQuery.sibling(elem.firstChild);\n                },\n                contents: function(elem) {\n                    return ((jQuery.nodeName(elem, \"div\") ? ((elem.contentDocument || elem.contentWindow.JSBNG__document)) : jQuery.makeArray(elem.childNodes)));\n                }\n            }, function(JSBNG__name, fn) {\n                jQuery.fn[JSBNG__name] = function(selector) {\n                    var ret = jQuery.map(this, fn);\n                    if (((selector && ((typeof selector == \"string\"))))) {\n                        ret = jQuery.multiFilter(selector, ret);\n                    }\n                ;\n                ;\n                    return this.pushStack(jQuery.unique(ret));\n                };\n            });\n            jQuery.each({\n                appendTo: \"append\",\n                prependTo: \"prepend\",\n                insertBefore: \"before\",\n                insertAfter: \"after\",\n                replaceAll: \"replaceWith\"\n            }, function(JSBNG__name, original) {\n                jQuery.fn[JSBNG__name] = function() {\n                    var args = arguments;\n                    return this.each(function() {\n                        for (var i = 0, length = args.length; ((i < length)); i++) {\n                            jQuery(args[i])[original](this);\n                        };\n                    ;\n                    });\n                };\n            });\n            jQuery.each({\n                removeAttr: function(JSBNG__name) {\n                    jQuery.attr(this, JSBNG__name, \"\");\n                    if (((this.nodeType == 1))) {\n                        this.removeAttribute(JSBNG__name);\n                    }\n                ;\n                ;\n                },\n                addClass: function(classNames) {\n                    jQuery.className.add(this, classNames);\n                },\n                removeClass: function(classNames) {\n                    jQuery.className.remove(this, classNames);\n                },\n                toggleClass: function(classNames) {\n                    jQuery.className[((jQuery.className.has(this, classNames) ? \"remove\" : \"add\"))](this, classNames);\n                },\n                remove: function(selector) {\n                    if (((!selector || jQuery.filter(selector, [this,]).r.length))) {\n                        jQuery(\"*\", this).add(this).each(function() {\n                            jQuery.JSBNG__event.remove(this);\n                            jQuery.removeData(this);\n                        });\n                        if (this.parentNode) {\n                            this.parentNode.removeChild(this);\n                        }\n                    ;\n                    ;\n                    }\n                ;\n                ;\n                },\n                empty: function() {\n                    jQuery(\"\\u003E*\", this).remove();\n                    while (this.firstChild) {\n                        this.removeChild(this.firstChild);\n                    };\n                ;\n                }\n            }, function(JSBNG__name, fn) {\n                jQuery.fn[JSBNG__name] = function() {\n                    return this.each(fn, arguments);\n                };\n            });\n            jQuery.each([\"Height\",\"Width\",], function(i, JSBNG__name) {\n                var type = JSBNG__name.toLowerCase();\n                jQuery.fn[type] = function(size) {\n                    return ((((this[0] == window)) ? ((((((((jQuery.browser.JSBNG__opera && JSBNG__document.body[((\"client\" + JSBNG__name))])) || ((jQuery.browser.safari && window[((\"JSBNG__inner\" + JSBNG__name))])))) || ((((JSBNG__document.compatMode == \"CSS1Compat\")) && JSBNG__document.documentElement[((\"client\" + JSBNG__name))])))) || JSBNG__document.body[((\"client\" + JSBNG__name))])) : ((((this[0] == JSBNG__document)) ? Math.max(Math.max(JSBNG__document.body[((\"JSBNG__scroll\" + JSBNG__name))], JSBNG__document.documentElement[((\"JSBNG__scroll\" + JSBNG__name))]), Math.max(JSBNG__document.body[((\"offset\" + JSBNG__name))], JSBNG__document.documentElement[((\"offset\" + JSBNG__name))])) : ((((size == undefined)) ? ((this.length ? jQuery.css(this[0], type) : null)) : this.css(type, ((((size.constructor == String)) ? size : ((size + \"px\")))))))))));\n                };\n            });\n            function num(elem, prop) {\n                return ((((elem[0] && parseInt(jQuery.curCSS(elem[0], prop, true), 10))) || 0));\n            };\n        ;\n            var chars = ((((jQuery.browser.safari && ((parseInt(jQuery.browser.version) < 417)))) ? \"(?:[\\\\w*_-]|\\\\\\\\.)\" : \"(?:[\\\\w\\u0128-\\uffff*_-]|\\\\\\\\.)\")), quickChild = new RegExp(((((\"^\\u003E\\\\s*(\" + chars)) + \"+)\"))), quickID = new RegExp(((((((((\"^(\" + chars)) + \"+)(#)(\")) + chars)) + \"+)\"))), quickClass = new RegExp(((((\"^([#.]?)(\" + chars)) + \"*)\")));\n            jQuery.extend({\n                expr: {\n                    \"\": function(a, i, m) {\n                        return ((((m[2] == \"*\")) || jQuery.nodeName(a, m[2])));\n                    },\n                    \"#\": function(a, i, m) {\n                        return ((a.getAttribute(\"id\") == m[2]));\n                    },\n                    \":\": {\n                        lt: function(a, i, m) {\n                            return ((i < ((m[3] - 0))));\n                        },\n                        gt: function(a, i, m) {\n                            return ((i > ((m[3] - 0))));\n                        },\n                        nth: function(a, i, m) {\n                            return ((((m[3] - 0)) == i));\n                        },\n                        eq: function(a, i, m) {\n                            return ((((m[3] - 0)) == i));\n                        },\n                        first: function(a, i) {\n                            return ((i == 0));\n                        },\n                        last: function(a, i, m, r) {\n                            return ((i == ((r.length - 1))));\n                        },\n                        even: function(a, i) {\n                            return ((((i % 2)) == 0));\n                        },\n                        odd: function(a, i) {\n                            return ((i % 2));\n                        },\n                        \"first-child\": function(a) {\n                            return ((a.parentNode.getElementsByTagName(\"*\")[0] == a));\n                        },\n                        \"last-child\": function(a) {\n                            return ((jQuery.nth(a.parentNode.lastChild, 1, \"previousSibling\") == a));\n                        },\n                        \"only-child\": function(a) {\n                            return !jQuery.nth(a.parentNode.lastChild, 2, \"previousSibling\");\n                        },\n                        parent: function(a) {\n                            return a.firstChild;\n                        },\n                        empty: function(a) {\n                            return !a.firstChild;\n                        },\n                        contains: function(a, i, m) {\n                            return ((((((((a.textContent || a.innerText)) || jQuery(a).text())) || \"\")).indexOf(m[3]) >= 0));\n                        },\n                        visible: function(a) {\n                            return ((((((\"hidden\" != a.type)) && ((jQuery.css(a, \"display\") != \"none\")))) && ((jQuery.css(a, \"visibility\") != \"hidden\"))));\n                        },\n                        hidden: function(a) {\n                            return ((((((\"hidden\" == a.type)) || ((jQuery.css(a, \"display\") == \"none\")))) || ((jQuery.css(a, \"visibility\") == \"hidden\"))));\n                        },\n                        enabled: function(a) {\n                            return !a.disabled;\n                        },\n                        disabled: function(a) {\n                            return a.disabled;\n                        },\n                        checked: function(a) {\n                            return a.checked;\n                        },\n                        selected: function(a) {\n                            return ((a.selected || jQuery.attr(a, \"selected\")));\n                        },\n                        text: function(a) {\n                            return ((\"text\" == a.type));\n                        },\n                        radio: function(a) {\n                            return ((\"radio\" == a.type));\n                        },\n                        checkbox: function(a) {\n                            return ((\"checkbox\" == a.type));\n                        },\n                        file: function(a) {\n                            return ((\"file\" == a.type));\n                        },\n                        password: function(a) {\n                            return ((\"password\" == a.type));\n                        },\n                        submit: function(a) {\n                            return ((\"submit\" == a.type));\n                        },\n                        image: function(a) {\n                            return ((\"image\" == a.type));\n                        },\n                        reset: function(a) {\n                            return ((\"reset\" == a.type));\n                        },\n                        button: function(a) {\n                            return ((((\"button\" == a.type)) || jQuery.nodeName(a, \"button\")));\n                        },\n                        input: function(a) {\n                            return /input|select|textarea|button/i.test(a.nodeName);\n                        },\n                        has: function(a, i, m) {\n                            return jQuery.JSBNG__find(m[3], a).length;\n                        },\n                        header: function(a) {\n                            return /h\\d/i.test(a.nodeName);\n                        },\n                        animated: function(a) {\n                            return jQuery.grep(jQuery.timers, function(fn) {\n                                return ((a == fn.elem));\n                            }).length;\n                        }\n                    }\n                },\n                parse: [/^(\\[) *@?([\\w-]+) *([!*$^~=]*) *('?\"?)(.*?)\\4 *\\]/,/^(:)([\\w-]+)\\(\"?'?(.*?(\\(.*?\\))?[^(]*?)\"?'?\\)/,new RegExp(((((\"^([:.#]*)(\" + chars)) + \"+)\"))),],\n                multiFilter: function(expr, elems, not) {\n                    var old, cur = [];\n                    while (((expr && ((expr != old))))) {\n                        old = expr;\n                        var f = jQuery.filter(expr, elems, not);\n                        expr = f.t.replace(/^\\s*,\\s*/, \"\");\n                        cur = ((not ? elems = f.r : jQuery.merge(cur, f.r)));\n                    };\n                ;\n                    return cur;\n                },\n                JSBNG__find: function(t, context) {\n                    if (((typeof t != \"string\"))) {\n                        return [t,];\n                    }\n                ;\n                ;\n                    if (((((context && ((context.nodeType != 1)))) && ((context.nodeType != 9))))) {\n                        return [];\n                    }\n                ;\n                ;\n                    context = ((context || JSBNG__document));\n                    var ret = [context,], done = [], last, nodeName;\n                    while (((t && ((last != t))))) {\n                        var r = [];\n                        last = t;\n                        t = jQuery.trim(t);\n                        var foundToken = false, re = quickChild, m = re.exec(t);\n                        if (m) {\n                            nodeName = m[1].toUpperCase();\n                            for (var i = 0; ret[i]; i++) {\n                                for (var c = ret[i].firstChild; c; c = c.nextSibling) {\n                                    if (((((c.nodeType == 1)) && ((((nodeName == \"*\")) || ((c.nodeName.toUpperCase() == nodeName))))))) {\n                                        r.push(c);\n                                    }\n                                ;\n                                ;\n                                };\n                            ;\n                            };\n                        ;\n                            ret = r;\n                            t = t.replace(re, \"\");\n                            if (((t.indexOf(\" \") == 0))) {\n                                continue;\n                            }\n                        ;\n                        ;\n                            foundToken = true;\n                        }\n                         else {\n                            re = /^([>+~])\\s*(\\w*)/i;\n                            if ((((m = re.exec(t)) != null))) {\n                                r = [];\n                                var merge = {\n                                };\n                                nodeName = m[2].toUpperCase();\n                                m = m[1];\n                                for (var j = 0, rl = ret.length; ((j < rl)); j++) {\n                                    var n = ((((((m == \"~\")) || ((m == \"+\")))) ? ret[j].nextSibling : ret[j].firstChild));\n                                    for (; n; n = n.nextSibling) {\n                                        if (((n.nodeType == 1))) {\n                                            var id = jQuery.data(n);\n                                            if (((((m == \"~\")) && merge[id]))) {\n                                                break;\n                                            }\n                                        ;\n                                        ;\n                                            if (((!nodeName || ((n.nodeName.toUpperCase() == nodeName))))) {\n                                                if (((m == \"~\"))) {\n                                                    merge[id] = true;\n                                                }\n                                            ;\n                                            ;\n                                                r.push(n);\n                                            }\n                                        ;\n                                        ;\n                                            if (((m == \"+\"))) {\n                                                break;\n                                            }\n                                        ;\n                                        ;\n                                        }\n                                    ;\n                                    ;\n                                    };\n                                ;\n                                };\n                            ;\n                                ret = r;\n                                t = jQuery.trim(t.replace(re, \"\"));\n                                foundToken = true;\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                        if (((t && !foundToken))) {\n                            if (!t.indexOf(\",\")) {\n                                if (((context == ret[0]))) {\n                                    ret.shift();\n                                }\n                            ;\n                            ;\n                                done = jQuery.merge(done, ret);\n                                r = ret = [context,];\n                                t = ((\" \" + t.substr(1, t.length)));\n                            }\n                             else {\n                                var re2 = quickID;\n                                var m = re2.exec(t);\n                                if (m) {\n                                    m = [0,m[2],m[3],m[1],];\n                                }\n                                 else {\n                                    re2 = quickClass;\n                                    m = re2.exec(t);\n                                }\n                            ;\n                            ;\n                                m[2] = m[2].replace(/\\\\/g, \"\");\n                                var elem = ret[((ret.length - 1))];\n                                if (((((((((m[1] == \"#\")) && elem)) && elem.getElementById)) && !jQuery.isXMLDoc(elem)))) {\n                                    var oid = elem.getElementById(m[2]);\n                                    if (((((((((jQuery.browser.msie || jQuery.browser.JSBNG__opera)) && oid)) && ((typeof oid.id == \"string\")))) && ((oid.id != m[2]))))) {\n                                        oid = jQuery(((((\"[@id=\\\"\" + m[2])) + \"\\\"]\")), elem)[0];\n                                    }\n                                ;\n                                ;\n                                    ret = r = ((((oid && ((!m[3] || jQuery.nodeName(oid, m[3]))))) ? [oid,] : []));\n                                }\n                                 else {\n                                    for (var i = 0; ret[i]; i++) {\n                                        var tag = ((((((m[1] == \"#\")) && m[3])) ? m[3] : ((((((m[1] != \"\")) || ((m[0] == \"\")))) ? \"*\" : m[2]))));\n                                        if (((((tag == \"*\")) && ((ret[i].nodeName.toLowerCase() == \"object\"))))) {\n                                            tag = \"param\";\n                                        }\n                                    ;\n                                    ;\n                                        r = jQuery.merge(r, ret[i].getElementsByTagName(tag));\n                                    };\n                                ;\n                                    if (((m[1] == \".\"))) {\n                                        r = jQuery.classFilter(r, m[2]);\n                                    }\n                                ;\n                                ;\n                                    if (((m[1] == \"#\"))) {\n                                        var tmp = [];\n                                        for (var i = 0; r[i]; i++) {\n                                            if (((r[i].getAttribute(\"id\") == m[2]))) {\n                                                tmp = [r[i],];\n                                                break;\n                                            }\n                                        ;\n                                        ;\n                                        };\n                                    ;\n                                        r = tmp;\n                                    }\n                                ;\n                                ;\n                                    ret = r;\n                                }\n                            ;\n                            ;\n                                t = t.replace(re2, \"\");\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                        if (t) {\n                            var val = jQuery.filter(t, r);\n                            ret = r = val.r;\n                            t = jQuery.trim(val.t);\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    if (t) {\n                        ret = [];\n                    }\n                ;\n                ;\n                    if (((ret && ((context == ret[0]))))) {\n                        ret.shift();\n                    }\n                ;\n                ;\n                    done = jQuery.merge(done, ret);\n                    return done;\n                },\n                classFilter: function(r, m, not) {\n                    m = ((((\" \" + m)) + \" \"));\n                    var tmp = [];\n                    for (var i = 0; r[i]; i++) {\n                        var pass = ((((((\" \" + r[i].className)) + \" \")).indexOf(m) >= 0));\n                        if (((((!not && pass)) || ((not && !pass))))) {\n                            tmp.push(r[i]);\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    return tmp;\n                },\n                filter: function(t, r, not) {\n                    var last;\n                    while (((t && ((t != last))))) {\n                        last = t;\n                        var p = jQuery.parse, m;\n                        for (var i = 0; p[i]; i++) {\n                            m = p[i].exec(t);\n                            if (m) {\n                                t = t.substring(m[0].length);\n                                m[2] = m[2].replace(/\\\\/g, \"\");\n                                break;\n                            }\n                        ;\n                        ;\n                        };\n                    ;\n                        if (!m) {\n                            break;\n                        }\n                    ;\n                    ;\n                        if (((((m[1] == \":\")) && ((m[2] == \"not\"))))) {\n                            r = ((isSimple.test(m[3]) ? jQuery.filter(m[3], r, true).r : jQuery(r).not(m[3])));\n                        }\n                         else {\n                            if (((m[1] == \".\"))) {\n                                r = jQuery.classFilter(r, m[2], not);\n                            }\n                             else {\n                                if (((m[1] == \"[\"))) {\n                                    var tmp = [], type = m[3];\n                                    for (var i = 0, rl = r.length; ((i < rl)); i++) {\n                                        var a = r[i], z = a[((jQuery.props[m[2]] || m[2]))];\n                                        if (((((z == null)) || /href|src|selected/.test(m[2])))) {\n                                            z = ((jQuery.attr(a, m[2]) || \"\"));\n                                        }\n                                    ;\n                                    ;\n                                        if (((((((((((((((((type == \"\")) && !!z)) || ((((type == \"=\")) && ((z == m[5])))))) || ((((type == \"!=\")) && ((z != m[5])))))) || ((((((type == \"^=\")) && z)) && !z.indexOf(m[5]))))) || ((((type == \"$=\")) && ((z.substr(((z.length - m[5].length))) == m[5])))))) || ((((((type == \"*=\")) || ((type == \"~=\")))) && ((z.indexOf(m[5]) >= 0)))))) ^ not))) {\n                                            tmp.push(a);\n                                        }\n                                    ;\n                                    ;\n                                    };\n                                ;\n                                    r = tmp;\n                                }\n                                 else {\n                                    if (((((m[1] == \":\")) && ((m[2] == \"nth-child\"))))) {\n                                        var merge = {\n                                        }, tmp = [], test = /(-?)(\\d*)n((?:\\+|-)?\\d*)/.exec(((((((((((m[3] == \"even\")) && \"2n\")) || ((((m[3] == \"odd\")) && \"2n+1\")))) || ((!/\\D/.test(m[3]) && ((\"0n+\" + m[3])))))) || m[3]))), first = ((((test[1] + ((test[2] || 1)))) - 0)), last = ((test[3] - 0));\n                                        for (var i = 0, rl = r.length; ((i < rl)); i++) {\n                                            var node = r[i], parentNode = node.parentNode, id = jQuery.data(parentNode);\n                                            if (!merge[id]) {\n                                                var c = 1;\n                                                for (var n = parentNode.firstChild; n; n = n.nextSibling) {\n                                                    if (((n.nodeType == 1))) {\n                                                        n.nodeIndex = c++;\n                                                    }\n                                                ;\n                                                ;\n                                                };\n                                            ;\n                                                merge[id] = true;\n                                            }\n                                        ;\n                                        ;\n                                            var add = false;\n                                            if (((first == 0))) {\n                                                if (((node.nodeIndex == last))) {\n                                                    add = true;\n                                                }\n                                            ;\n                                            ;\n                                            }\n                                             else {\n                                                if (((((((((node.nodeIndex - last)) % first)) == 0)) && ((((((node.nodeIndex - last)) / first)) >= 0))))) {\n                                                    add = true;\n                                                }\n                                            ;\n                                            ;\n                                            }\n                                        ;\n                                        ;\n                                            if (((add ^ not))) {\n                                                tmp.push(node);\n                                            }\n                                        ;\n                                        ;\n                                        };\n                                    ;\n                                        r = tmp;\n                                    }\n                                     else {\n                                        var fn = jQuery.expr[m[1]];\n                                        if (((typeof fn == \"object\"))) {\n                                            fn = fn[m[2]];\n                                        }\n                                    ;\n                                    ;\n                                        if (((typeof fn == \"string\"))) {\n                                            fn = eval(((((\"false||function(a,i){return \" + fn)) + \";}\")));\n                                        }\n                                    ;\n                                    ;\n                                        r = jQuery.grep(r, function(elem, i) {\n                                            return fn(elem, i, m, r);\n                                        }, not);\n                                    }\n                                ;\n                                ;\n                                }\n                            ;\n                            ;\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    return {\n                        r: r,\n                        t: t\n                    };\n                },\n                dir: function(elem, dir) {\n                    var matched = [], cur = elem[dir];\n                    while (((cur && ((cur != JSBNG__document))))) {\n                        if (((cur.nodeType == 1))) {\n                            matched.push(cur);\n                        }\n                    ;\n                    ;\n                        cur = cur[dir];\n                    };\n                ;\n                    return matched;\n                },\n                nth: function(cur, result, dir, elem) {\n                    result = ((result || 1));\n                    var num = 0;\n                    for (; cur; cur = cur[dir]) {\n                        if (((((cur.nodeType == 1)) && ((++num == result))))) {\n                            break;\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    return cur;\n                },\n                sibling: function(n, elem) {\n                    var r = [];\n                    for (; n; n = n.nextSibling) {\n                        if (((((n.nodeType == 1)) && ((n != elem))))) {\n                            r.push(n);\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    return r;\n                }\n            });\n            jQuery.JSBNG__event = {\n                add: function(elem, types, handler, data) {\n                    if (((((elem.nodeType == 3)) || ((elem.nodeType == 8))))) {\n                        return;\n                    }\n                ;\n                ;\n                    if (((jQuery.browser.msie && elem.JSBNG__setInterval))) {\n                        elem = window;\n                    }\n                ;\n                ;\n                    if (!handler.guid) {\n                        handler.guid = this.guid++;\n                    }\n                ;\n                ;\n                    if (((data != undefined))) {\n                        var fn = handler;\n                        handler = this.proxy(fn, function() {\n                            return fn.apply(this, arguments);\n                        });\n                        handler.data = data;\n                    }\n                ;\n                ;\n                    var events = ((jQuery.data(elem, \"events\") || jQuery.data(elem, \"events\", {\n                    }))), handle = ((jQuery.data(elem, \"handle\") || jQuery.data(elem, \"handle\", function() {\n                        if (((((typeof jQuery != \"undefined\")) && !jQuery.JSBNG__event.triggered))) {\n                            return jQuery.JSBNG__event.handle.apply(arguments.callee.elem, arguments);\n                        }\n                    ;\n                    ;\n                    })));\n                    handle.elem = elem;\n                    jQuery.each(types.split(/\\s+/), function(index, type) {\n                        var parts = type.split(\".\");\n                        type = parts[0];\n                        handler.type = parts[1];\n                        var handlers = events[type];\n                        if (!handlers) {\n                            handlers = events[type] = {\n                            };\n                            if (((!jQuery.JSBNG__event.special[type] || ((jQuery.JSBNG__event.special[type].setup.call(elem) === false))))) {\n                                if (elem.JSBNG__addEventListener) {\n                                    elem.JSBNG__addEventListener(type, handle, false);\n                                }\n                                 else {\n                                    if (elem.JSBNG__attachEvent) {\n                                        elem.JSBNG__attachEvent(((\"JSBNG__on\" + type)), handle);\n                                    }\n                                ;\n                                ;\n                                }\n                            ;\n                            ;\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                        handlers[handler.guid] = handler;\n                        jQuery.JSBNG__event.global[type] = true;\n                    });\n                    elem = null;\n                },\n                guid: 1,\n                global: {\n                },\n                remove: function(elem, types, handler) {\n                    if (((((elem.nodeType == 3)) || ((elem.nodeType == 8))))) {\n                        return;\n                    }\n                ;\n                ;\n                    var events = jQuery.data(elem, \"events\"), ret, index;\n                    if (events) {\n                        if (((((types == undefined)) || ((((typeof types == \"string\")) && ((types.charAt(0) == \".\"))))))) {\n                            {\n                                var fin19keys = ((window.top.JSBNG_Replay.forInKeys)((events))), fin19i = (0);\n                                var type;\n                                for (; (fin19i < fin19keys.length); (fin19i++)) {\n                                    ((type) = (fin19keys[fin19i]));\n                                    {\n                                        this.remove(elem, ((type + ((types || \"\")))));\n                                    };\n                                };\n                            };\n                        ;\n                        }\n                         else {\n                            if (types.type) {\n                                handler = types.handler;\n                                types = types.type;\n                            }\n                        ;\n                        ;\n                            jQuery.each(types.split(/\\s+/), function(index, type) {\n                                var parts = type.split(\".\");\n                                type = parts[0];\n                                if (events[type]) {\n                                    if (handler) {\n                                        delete events[type][handler.guid];\n                                    }\n                                     else {\n                                        {\n                                            var fin20keys = ((window.top.JSBNG_Replay.forInKeys)((events[type]))), fin20i = (0);\n                                            (0);\n                                            for (; (fin20i < fin20keys.length); (fin20i++)) {\n                                                ((handler) = (fin20keys[fin20i]));\n                                                {\n                                                    if (((!parts[1] || ((events[type][handler].type == parts[1]))))) {\n                                                        delete events[type][handler];\n                                                    }\n                                                ;\n                                                ;\n                                                };\n                                            };\n                                        };\n                                    ;\n                                    }\n                                ;\n                                ;\n                                    {\n                                        var fin21keys = ((window.top.JSBNG_Replay.forInKeys)((events[type]))), fin21i = (0);\n                                        (0);\n                                        for (; (fin21i < fin21keys.length); (fin21i++)) {\n                                            ((ret) = (fin21keys[fin21i]));\n                                            {\n                                                break;\n                                            };\n                                        };\n                                    };\n                                ;\n                                    if (!ret) {\n                                        if (((!jQuery.JSBNG__event.special[type] || ((jQuery.JSBNG__event.special[type].teardown.call(elem) === false))))) {\n                                            if (elem.JSBNG__removeEventListener) {\n                                                elem.JSBNG__removeEventListener(type, jQuery.data(elem, \"handle\"), false);\n                                            }\n                                             else {\n                                                if (elem.JSBNG__detachEvent) {\n                                                    elem.JSBNG__detachEvent(((\"JSBNG__on\" + type)), jQuery.data(elem, \"handle\"));\n                                                }\n                                            ;\n                                            ;\n                                            }\n                                        ;\n                                        ;\n                                        }\n                                    ;\n                                    ;\n                                        ret = null;\n                                        delete events[type];\n                                    }\n                                ;\n                                ;\n                                }\n                            ;\n                            ;\n                            });\n                        }\n                    ;\n                    ;\n                        {\n                            var fin22keys = ((window.top.JSBNG_Replay.forInKeys)((events))), fin22i = (0);\n                            (0);\n                            for (; (fin22i < fin22keys.length); (fin22i++)) {\n                                ((ret) = (fin22keys[fin22i]));\n                                {\n                                    break;\n                                };\n                            };\n                        };\n                    ;\n                        if (!ret) {\n                            var handle = jQuery.data(elem, \"handle\");\n                            if (handle) {\n                                handle.elem = null;\n                            }\n                        ;\n                        ;\n                            jQuery.removeData(elem, \"events\");\n                            jQuery.removeData(elem, \"handle\");\n                        }\n                    ;\n                    ;\n                    }\n                ;\n                ;\n                },\n                trigger: function(type, data, elem, donative, extra) {\n                    data = jQuery.makeArray(data);\n                    if (((type.indexOf(\"!\") >= 0))) {\n                        type = type.slice(0, -1);\n                        var exclusive = true;\n                    }\n                ;\n                ;\n                    if (!elem) {\n                        if (this.global[type]) {\n                            jQuery(\"*\").add([window,JSBNG__document,]).trigger(type, data);\n                        }\n                    ;\n                    ;\n                    }\n                     else {\n                        if (((((elem.nodeType == 3)) || ((elem.nodeType == 8))))) {\n                            return undefined;\n                        }\n                    ;\n                    ;\n                        var val, ret, fn = jQuery.isFunction(((elem[type] || null))), JSBNG__event = ((!data[0] || !data[0].preventDefault));\n                        if (JSBNG__event) {\n                            data.unshift({\n                                type: type,\n                                target: elem,\n                                preventDefault: function() {\n                                \n                                },\n                                stopPropagation: function() {\n                                \n                                },\n                                timeStamp: now()\n                            });\n                            data[0][expando] = true;\n                        }\n                    ;\n                    ;\n                        data[0].type = type;\n                        if (exclusive) {\n                            data[0].exclusive = true;\n                        }\n                    ;\n                    ;\n                        var handle = jQuery.data(elem, \"handle\");\n                        if (handle) {\n                            val = handle.apply(elem, data);\n                        }\n                    ;\n                    ;\n                        if (((((((!fn || ((jQuery.nodeName(elem, \"a\") && ((type == \"click\")))))) && elem[((\"JSBNG__on\" + type))])) && ((elem[((\"JSBNG__on\" + type))].apply(elem, data) === false))))) {\n                            val = false;\n                        }\n                    ;\n                    ;\n                        if (JSBNG__event) {\n                            data.shift();\n                        }\n                    ;\n                    ;\n                        if (((extra && jQuery.isFunction(extra)))) {\n                            ret = extra.apply(elem, ((((val == null)) ? data : data.concat(val))));\n                            if (((ret !== undefined))) {\n                                val = ret;\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                        if (((((((fn && ((donative !== false)))) && ((val !== false)))) && !((jQuery.nodeName(elem, \"a\") && ((type == \"click\"))))))) {\n                            this.triggered = true;\n                            try {\n                                elem[type]();\n                            } catch (e) {\n                            \n                            };\n                        ;\n                        }\n                    ;\n                    ;\n                        this.triggered = false;\n                    }\n                ;\n                ;\n                    return val;\n                },\n                handle: function(JSBNG__event) {\n                    var val, ret, namespace, all, handlers;\n                    JSBNG__event = arguments[0] = jQuery.JSBNG__event.fix(((JSBNG__event || window.JSBNG__event)));\n                    namespace = JSBNG__event.type.split(\".\");\n                    JSBNG__event.type = namespace[0];\n                    namespace = namespace[1];\n                    all = ((!namespace && !JSBNG__event.exclusive));\n                    handlers = ((jQuery.data(this, \"events\") || {\n                    }))[JSBNG__event.type];\n                    {\n                        var fin23keys = ((window.top.JSBNG_Replay.forInKeys)((handlers))), fin23i = (0);\n                        var j;\n                        for (; (fin23i < fin23keys.length); (fin23i++)) {\n                            ((j) = (fin23keys[fin23i]));\n                            {\n                                var handler = handlers[j];\n                                if (((all || ((handler.type == namespace))))) {\n                                    JSBNG__event.handler = handler;\n                                    JSBNG__event.data = handler.data;\n                                    ret = handler.apply(this, arguments);\n                                    if (((val !== false))) {\n                                        val = ret;\n                                    }\n                                ;\n                                ;\n                                    if (((ret === false))) {\n                                        JSBNG__event.preventDefault();\n                                        JSBNG__event.stopPropagation();\n                                    }\n                                ;\n                                ;\n                                }\n                            ;\n                            ;\n                            };\n                        };\n                    };\n                ;\n                    return val;\n                },\n                fix: function(JSBNG__event) {\n                    if (((JSBNG__event[expando] == true))) {\n                        return JSBNG__event;\n                    }\n                ;\n                ;\n                    var originalEvent = JSBNG__event;\n                    JSBNG__event = {\n                        originalEvent: originalEvent\n                    };\n                    var props = \"altKey attrChange attrName bubbles button cancelable charCode clientX clientY ctrlKey currentTarget data detail eventPhase fromElement handler keyCode metaKey newValue originalTarget pageX pageY prevValue relatedNode relatedTarget screenX screenY shiftKey srcElement target timeStamp toElement type view wheelDelta which\".split(\" \");\n                    for (var i = props.length; i; i--) {\n                        JSBNG__event[props[i]] = originalEvent[props[i]];\n                    };\n                ;\n                    JSBNG__event[expando] = true;\n                    JSBNG__event.preventDefault = function() {\n                        if (originalEvent.preventDefault) {\n                            originalEvent.preventDefault();\n                        }\n                    ;\n                    ;\n                        originalEvent.returnValue = false;\n                    };\n                    JSBNG__event.stopPropagation = function() {\n                        if (originalEvent.stopPropagation) {\n                            originalEvent.stopPropagation();\n                        }\n                    ;\n                    ;\n                        originalEvent.cancelBubble = true;\n                    };\n                    JSBNG__event.timeStamp = ((JSBNG__event.timeStamp || now()));\n                    if (!JSBNG__event.target) {\n                        JSBNG__event.target = ((JSBNG__event.srcElement || JSBNG__document));\n                    }\n                ;\n                ;\n                    if (((JSBNG__event.target.nodeType == 3))) {\n                        JSBNG__event.target = JSBNG__event.target.parentNode;\n                    }\n                ;\n                ;\n                    if (((!JSBNG__event.relatedTarget && JSBNG__event.fromElement))) {\n                        JSBNG__event.relatedTarget = ((((JSBNG__event.fromElement == JSBNG__event.target)) ? JSBNG__event.toElement : JSBNG__event.fromElement));\n                    }\n                ;\n                ;\n                    if (((((JSBNG__event.pageX == null)) && ((JSBNG__event.clientX != null))))) {\n                        var doc = JSBNG__document.documentElement, body = JSBNG__document.body;\n                        JSBNG__event.pageX = ((((JSBNG__event.clientX + ((((((doc && doc.scrollLeft)) || ((body && body.scrollLeft)))) || 0)))) - ((doc.clientLeft || 0))));\n                        JSBNG__event.pageY = ((((JSBNG__event.clientY + ((((((doc && doc.scrollTop)) || ((body && body.scrollTop)))) || 0)))) - ((doc.clientTop || 0))));\n                    }\n                ;\n                ;\n                    if (((!JSBNG__event.which && ((((JSBNG__event.charCode || ((JSBNG__event.charCode === 0)))) ? JSBNG__event.charCode : JSBNG__event.keyCode))))) {\n                        JSBNG__event.which = ((JSBNG__event.charCode || JSBNG__event.keyCode));\n                    }\n                ;\n                ;\n                    if (((!JSBNG__event.metaKey && JSBNG__event.ctrlKey))) {\n                        JSBNG__event.metaKey = JSBNG__event.ctrlKey;\n                    }\n                ;\n                ;\n                    if (((!JSBNG__event.which && JSBNG__event.button))) {\n                        JSBNG__event.which = ((((JSBNG__event.button & 1)) ? 1 : ((((JSBNG__event.button & 2)) ? 3 : ((((JSBNG__event.button & 4)) ? 2 : 0))))));\n                    }\n                ;\n                ;\n                    return JSBNG__event;\n                },\n                proxy: function(fn, proxy) {\n                    proxy.guid = fn.guid = ((((fn.guid || proxy.guid)) || this.guid++));\n                    return proxy;\n                },\n                special: {\n                    ready: {\n                        setup: function() {\n                            bindReady();\n                            return;\n                        },\n                        teardown: function() {\n                            return;\n                        }\n                    },\n                    mouseenter: {\n                        setup: function() {\n                            if (jQuery.browser.msie) {\n                                return false;\n                            }\n                        ;\n                        ;\n                            jQuery(this).bind(\"mouseover\", jQuery.JSBNG__event.special.mouseenter.handler);\n                            return true;\n                        },\n                        teardown: function() {\n                            if (jQuery.browser.msie) {\n                                return false;\n                            }\n                        ;\n                        ;\n                            jQuery(this).unbind(\"mouseover\", jQuery.JSBNG__event.special.mouseenter.handler);\n                            return true;\n                        },\n                        handler: function(JSBNG__event) {\n                            if (withinElement(JSBNG__event, this)) {\n                                return true;\n                            }\n                        ;\n                        ;\n                            JSBNG__event.type = \"mouseenter\";\n                            return jQuery.JSBNG__event.handle.apply(this, arguments);\n                        }\n                    },\n                    mouseleave: {\n                        setup: function() {\n                            if (jQuery.browser.msie) {\n                                return false;\n                            }\n                        ;\n                        ;\n                            jQuery(this).bind(\"mouseout\", jQuery.JSBNG__event.special.mouseleave.handler);\n                            return true;\n                        },\n                        teardown: function() {\n                            if (jQuery.browser.msie) {\n                                return false;\n                            }\n                        ;\n                        ;\n                            jQuery(this).unbind(\"mouseout\", jQuery.JSBNG__event.special.mouseleave.handler);\n                            return true;\n                        },\n                        handler: function(JSBNG__event) {\n                            if (withinElement(JSBNG__event, this)) {\n                                return true;\n                            }\n                        ;\n                        ;\n                            JSBNG__event.type = \"mouseleave\";\n                            return jQuery.JSBNG__event.handle.apply(this, arguments);\n                        }\n                    }\n                }\n            };\n            jQuery.fn.extend({\n                bind: function(type, data, fn) {\n                    return ((((type == \"unload\")) ? this.one(type, data, fn) : this.each(function() {\n                        jQuery.JSBNG__event.add(this, type, ((fn || data)), ((fn && data)));\n                    })));\n                },\n                one: function(type, data, fn) {\n                    var one = jQuery.JSBNG__event.proxy(((fn || data)), function(JSBNG__event) {\n                        jQuery(this).unbind(JSBNG__event, one);\n                        return ((fn || data)).apply(this, arguments);\n                    });\n                    return this.each(function() {\n                        jQuery.JSBNG__event.add(this, type, one, ((fn && data)));\n                    });\n                },\n                unbind: function(type, fn) {\n                    return this.each(function() {\n                        jQuery.JSBNG__event.remove(this, type, fn);\n                    });\n                },\n                trigger: function(type, data, fn) {\n                    return this.each(function() {\n                        jQuery.JSBNG__event.trigger(type, data, this, true, fn);\n                    });\n                },\n                triggerHandler: function(type, data, fn) {\n                    return ((this[0] && jQuery.JSBNG__event.trigger(type, data, this[0], false, fn)));\n                },\n                toggle: function(fn) {\n                    var args = arguments, i = 1;\n                    while (((i < args.length))) {\n                        jQuery.JSBNG__event.proxy(fn, args[i++]);\n                    };\n                ;\n                    return this.click(jQuery.JSBNG__event.proxy(fn, function(JSBNG__event) {\n                        this.lastToggle = ((((this.lastToggle || 0)) % i));\n                        JSBNG__event.preventDefault();\n                        return ((args[this.lastToggle++].apply(this, arguments) || false));\n                    }));\n                },\n                hover: function(fnOver, fnOut) {\n                    return this.bind(\"mouseenter\", fnOver).bind(\"mouseleave\", fnOut);\n                },\n                ready: function(fn) {\n                    bindReady();\n                    if (jQuery.isReady) {\n                        fn.call(JSBNG__document, jQuery);\n                    }\n                     else {\n                        jQuery.readyList.push(function() {\n                            return fn.call(this, jQuery);\n                        });\n                    }\n                ;\n                ;\n                    return this;\n                }\n            });\n            jQuery.extend({\n                isReady: false,\n                readyList: [],\n                ready: function() {\n                    if (!jQuery.isReady) {\n                        jQuery.isReady = true;\n                        if (jQuery.readyList) {\n                            jQuery.each(jQuery.readyList, function() {\n                                this.call(JSBNG__document);\n                            });\n                            jQuery.readyList = null;\n                        }\n                    ;\n                    ;\n                        jQuery(JSBNG__document).triggerHandler(\"ready\");\n                    }\n                ;\n                ;\n                }\n            });\n            var readyBound = false;\n            function bindReady() {\n                if (readyBound) {\n                    return;\n                }\n            ;\n            ;\n                readyBound = true;\n                if (((JSBNG__document.JSBNG__addEventListener && !jQuery.browser.JSBNG__opera))) {\n                    JSBNG__document.JSBNG__addEventListener(\"DOMContentLoaded\", jQuery.ready, false);\n                }\n            ;\n            ;\n                if (((jQuery.browser.msie && ((window == JSBNG__top))))) {\n                    (function() {\n                        if (jQuery.isReady) {\n                            return;\n                        }\n                    ;\n                    ;\n                        try {\n                            JSBNG__document.documentElement.doScroll(\"left\");\n                        } catch (error) {\n                            JSBNG__setTimeout(arguments.callee, jQuery126PatchDelay);\n                            return;\n                        };\n                    ;\n                        jQuery.ready();\n                    })();\n                }\n            ;\n            ;\n                if (jQuery.browser.JSBNG__opera) {\n                    JSBNG__document.JSBNG__addEventListener(\"DOMContentLoaded\", function() {\n                        if (jQuery.isReady) {\n                            return;\n                        }\n                    ;\n                    ;\n                        for (var i = 0; ((i < JSBNG__document.styleSheets.length)); i++) {\n                            if (JSBNG__document.styleSheets[i].disabled) {\n                                JSBNG__setTimeout(arguments.callee, jQuery126PatchDelay);\n                                return;\n                            }\n                        ;\n                        ;\n                        };\n                    ;\n                        jQuery.ready();\n                    }, false);\n                }\n            ;\n            ;\n                if (jQuery.browser.safari) {\n                    var numStyles;\n                    (function() {\n                        if (jQuery.isReady) {\n                            return;\n                        }\n                    ;\n                    ;\n                        if (((((JSBNG__document.readyState != \"loaded\")) && ((JSBNG__document.readyState != \"complete\"))))) {\n                            JSBNG__setTimeout(arguments.callee, jQuery126PatchDelay);\n                            return;\n                        }\n                    ;\n                    ;\n                        if (((numStyles === undefined))) {\n                            numStyles = jQuery(\"style, link[rel=stylesheet]\").length;\n                        }\n                    ;\n                    ;\n                        if (((JSBNG__document.styleSheets.length != numStyles))) {\n                            JSBNG__setTimeout(arguments.callee, jQuery126PatchDelay);\n                            return;\n                        }\n                    ;\n                    ;\n                        jQuery.ready();\n                    })();\n                }\n            ;\n            ;\n                jQuery.JSBNG__event.add(window, \"load\", jQuery.ready);\n            };\n        ;\n            jQuery.each(((((\"blur,focus,load,resize,scroll,unload,click,dblclick,\" + \"mousedown,mouseup,mousemove,mouseover,mouseout,change,select,\")) + \"submit,keydown,keypress,keyup,error\")).split(\",\"), function(i, JSBNG__name) {\n                jQuery.fn[JSBNG__name] = function(fn) {\n                    return ((fn ? this.bind(JSBNG__name, fn) : this.trigger(JSBNG__name)));\n                };\n            });\n            var withinElement = function(JSBNG__event, elem) {\n                var parent = JSBNG__event.relatedTarget;\n                while (((parent && ((parent != elem))))) {\n                    try {\n                        parent = parent.parentNode;\n                    } catch (error) {\n                        parent = elem;\n                    };\n                ;\n                };\n            ;\n                return ((parent == elem));\n            };\n            jQuery(window).bind(\"unload\", function() {\n                jQuery(\"*\").add(JSBNG__document).unbind();\n            });\n            jQuery.fn.extend({\n                _load: jQuery.fn.load,\n                load: function(url, params, callback) {\n                    if (((typeof url != \"string\"))) {\n                        return this._load(url);\n                    }\n                ;\n                ;\n                    var off = url.indexOf(\" \");\n                    if (((off >= 0))) {\n                        var selector = url.slice(off, url.length);\n                        url = url.slice(0, off);\n                    }\n                ;\n                ;\n                    callback = ((callback || function() {\n                    \n                    }));\n                    var type = \"GET\";\n                    if (params) {\n                        if (jQuery.isFunction(params)) {\n                            callback = params;\n                            params = null;\n                        }\n                         else {\n                            params = jQuery.param(params);\n                            type = \"POST\";\n                        }\n                    ;\n                    ;\n                    }\n                ;\n                ;\n                    var JSBNG__self = this;\n                    jQuery.ajax({\n                        url: url,\n                        type: type,\n                        dataType: \"html\",\n                        data: params,\n                        complete: function(res, JSBNG__status) {\n                            if (((((JSBNG__status == \"success\")) || ((JSBNG__status == \"notmodified\"))))) {\n                                JSBNG__self.html(((selector ? jQuery(\"\\u003Cdiv/\\u003E\").append(res.responseText.replace(/<script(.|\\s)*?\\/script>/g, \"\")).JSBNG__find(selector) : res.responseText)));\n                            }\n                        ;\n                        ;\n                            JSBNG__self.each(callback, [res.responseText,JSBNG__status,res,]);\n                        }\n                    });\n                    return this;\n                },\n                serialize: function() {\n                    return jQuery.param(this.serializeArray());\n                },\n                serializeArray: function() {\n                    return this.map(function() {\n                        return ((jQuery.nodeName(this, \"form\") ? jQuery.makeArray(this.elements) : this));\n                    }).filter(function() {\n                        return ((((this.JSBNG__name && !this.disabled)) && ((((this.checked || /select|textarea/i.test(this.nodeName))) || /text|hidden|password/i.test(this.type)))));\n                    }).map(function(i, elem) {\n                        var val = jQuery(this).val();\n                        return ((((val == null)) ? null : ((((val.constructor == Array)) ? jQuery.map(val, function(val, i) {\n                            return {\n                                JSBNG__name: elem.JSBNG__name,\n                                value: val\n                            };\n                        }) : {\n                            JSBNG__name: elem.JSBNG__name,\n                            value: val\n                        }))));\n                    }).get();\n                }\n            });\n            jQuery.each(\"ajaxStart,ajaxStop,ajaxComplete,ajaxError,ajaxSuccess,ajaxSend\".split(\",\"), function(i, o) {\n                jQuery.fn[o] = function(f) {\n                    return this.bind(o, f);\n                };\n            });\n            var jsc = now();\n            jQuery.extend({\n                get: function(url, data, callback, type) {\n                    if (jQuery.isFunction(data)) {\n                        callback = data;\n                        data = null;\n                    }\n                ;\n                ;\n                    return jQuery.ajax({\n                        type: \"GET\",\n                        url: url,\n                        data: data,\n                        success: callback,\n                        dataType: type\n                    });\n                },\n                getScript: function(url, callback) {\n                    return jQuery.get(url, null, callback, \"script\");\n                },\n                getJSON: function(url, data, callback) {\n                    return jQuery.get(url, data, callback, \"json\");\n                },\n                post: function(url, data, callback, type) {\n                    if (jQuery.isFunction(data)) {\n                        callback = data;\n                        data = {\n                        };\n                    }\n                ;\n                ;\n                    return jQuery.ajax({\n                        type: \"POST\",\n                        url: url,\n                        data: data,\n                        success: callback,\n                        dataType: type\n                    });\n                },\n                ajaxSetup: function(settings) {\n                    jQuery.extend(jQuery.ajaxSettings, settings);\n                },\n                ajaxSettings: {\n                    url: JSBNG__location.href,\n                    global: true,\n                    type: \"GET\",\n                    timeout: 0,\n                    contentType: \"application/x-www-form-urlencoded\",\n                    processData: true,\n                    async: true,\n                    data: null,\n                    username: null,\n                    password: null,\n                    accepts: {\n                        xml: \"application/xml, text/xml\",\n                        html: \"text/html\",\n                        script: \"text/javascript, application/javascript\",\n                        json: \"application/json, text/javascript\",\n                        text: \"text/plain\",\n                        _default: \"*/*\"\n                    }\n                },\n                lastModified: {\n                },\n                ajax: function(s) {\n                    s = jQuery.extend(true, s, jQuery.extend(true, {\n                    }, jQuery.ajaxSettings, s));\n                    var jsonp, jsre = /=\\?(&|$)/g, JSBNG__status, data, type = s.type.toUpperCase();\n                    if (((((s.data && s.processData)) && ((typeof s.data != \"string\"))))) {\n                        s.data = jQuery.param(s.data);\n                    }\n                ;\n                ;\n                    if (((s.dataType == \"jsonp\"))) {\n                        if (((type == \"GET\"))) {\n                            if (!s.url.match(jsre)) {\n                                s.url += ((((((s.url.match(/\\?/) ? \"&\" : \"?\")) + ((s.jsonp || \"callback\")))) + \"=?\"));\n                            }\n                        ;\n                        ;\n                        }\n                         else {\n                            if (((!s.data || !s.data.match(jsre)))) {\n                                s.data = ((((((s.data ? ((s.data + \"&\")) : \"\")) + ((s.jsonp || \"callback\")))) + \"=?\"));\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                        s.dataType = \"json\";\n                    }\n                ;\n                ;\n                    if (((((s.dataType == \"json\")) && ((((s.data && s.data.match(jsre))) || s.url.match(jsre)))))) {\n                        jsonp = ((\"jsonp\" + jsc++));\n                        if (s.data) {\n                            s.data = ((s.data + \"\")).replace(jsre, ((((\"=\" + jsonp)) + \"$1\")));\n                        }\n                    ;\n                    ;\n                        s.url = s.url.replace(jsre, ((((\"=\" + jsonp)) + \"$1\")));\n                        s.dataType = \"script\";\n                        window[jsonp] = function(tmp) {\n                            data = tmp;\n                            success();\n                            complete();\n                            window[jsonp] = undefined;\n                            try {\n                                delete window[jsonp];\n                            } catch (e) {\n                            \n                            };\n                        ;\n                            if (head) {\n                                head.removeChild(script);\n                            }\n                        ;\n                        ;\n                        };\n                    }\n                ;\n                ;\n                    if (((((s.dataType == \"script\")) && ((s.cache == null))))) {\n                        s.cache = false;\n                    }\n                ;\n                ;\n                    if (((((s.cache === false)) && ((type == \"GET\"))))) {\n                        var ts = now();\n                        var ret = s.url.replace(/(\\?|&)_=.*?(&|$)/, ((((\"$1_=\" + ts)) + \"$2\")));\n                        s.url = ((ret + ((((ret == s.url)) ? ((((((s.url.match(/\\?/) ? \"&\" : \"?\")) + \"_=\")) + ts)) : \"\"))));\n                    }\n                ;\n                ;\n                    if (((s.data && ((type == \"GET\"))))) {\n                        s.url += ((((s.url.match(/\\?/) ? \"&\" : \"?\")) + s.data));\n                        s.data = null;\n                    }\n                ;\n                ;\n                    if (((s.global && !jQuery.active++))) {\n                        jQuery.JSBNG__event.trigger(\"ajaxStart\");\n                    }\n                ;\n                ;\n                    var remote = /^(?:\\w+:)?\\/\\/([^\\/?#]+)/;\n                    if (((((((((s.dataType == \"script\")) && ((type == \"GET\")))) && remote.test(s.url))) && ((remote.exec(s.url)[1] != JSBNG__location.host))))) {\n                        var head = JSBNG__document.getElementsByTagName(\"head\")[0];\n                        var script = JSBNG__document.createElement(\"script\");\n                        script.src = s.url;\n                        if (s.scriptCharset) {\n                            script.charset = s.scriptCharset;\n                        }\n                    ;\n                    ;\n                        if (!jsonp) {\n                            var done = false;\n                            script.JSBNG__onload = script.onreadystatechange = function() {\n                                if (((!done && ((((!this.readyState || ((this.readyState == \"loaded\")))) || ((this.readyState == \"complete\"))))))) {\n                                    done = true;\n                                    success();\n                                    complete();\n                                    head.removeChild(script);\n                                }\n                            ;\n                            ;\n                            };\n                        }\n                    ;\n                    ;\n                        head.appendChild(script);\n                        return undefined;\n                    }\n                ;\n                ;\n                    var requestDone = false;\n                    var xhr = ((window.ActiveXObject ? new ActiveXObject(\"Microsoft.XMLHTTP\") : new JSBNG__XMLHttpRequest()));\n                    if (s.username) {\n                        xhr.open(type, s.url, s.async, s.username, s.password);\n                    }\n                     else {\n                        xhr.open(type, s.url, s.async);\n                    }\n                ;\n                ;\n                    try {\n                        if (s.data) {\n                            xhr.setRequestHeader(\"Content-Type\", s.contentType);\n                        }\n                    ;\n                    ;\n                        if (s.ifModified) {\n                            xhr.setRequestHeader(\"If-Modified-Since\", ((jQuery.lastModified[s.url] || \"Thu, 01 Jan 1970 00:00:00 GMT\")));\n                        }\n                    ;\n                    ;\n                        xhr.setRequestHeader(\"X-Requested-With\", \"JSBNG__XMLHttpRequest\");\n                        xhr.setRequestHeader(\"Accept\", ((((s.dataType && s.accepts[s.dataType])) ? ((s.accepts[s.dataType] + \", */*\")) : s.accepts._default)));\n                    } catch (e) {\n                    \n                    };\n                ;\n                    if (((s.beforeSend && ((s.beforeSend(xhr, s) === false))))) {\n                        ((s.global && jQuery.active--));\n                        xhr.abort();\n                        return false;\n                    }\n                ;\n                ;\n                    if (s.global) {\n                        jQuery.JSBNG__event.trigger(\"ajaxSend\", [xhr,s,]);\n                    }\n                ;\n                ;\n                    var onreadystatechange = function(isTimeout) {\n                        if (((((!requestDone && xhr)) && ((((xhr.readyState == 4)) || ((isTimeout == \"timeout\"))))))) {\n                            requestDone = true;\n                            if (ival) {\n                                JSBNG__clearInterval(ival);\n                                ival = null;\n                            }\n                        ;\n                        ;\n                            JSBNG__status = ((((((((((isTimeout == \"timeout\")) && \"timeout\")) || ((!jQuery.httpSuccess(xhr) && \"error\")))) || ((((s.ifModified && jQuery.httpNotModified(xhr, s.url))) && \"notmodified\")))) || \"success\"));\n                            if (((JSBNG__status == \"success\"))) {\n                                try {\n                                    data = jQuery.httpData(xhr, s.dataType, s.dataFilter);\n                                } catch (e) {\n                                    JSBNG__status = \"parsererror\";\n                                };\n                            ;\n                            }\n                        ;\n                        ;\n                            if (((JSBNG__status == \"success\"))) {\n                                var modRes;\n                                try {\n                                    modRes = xhr.getResponseHeader(\"Last-Modified\");\n                                } catch (e) {\n                                \n                                };\n                            ;\n                                if (((s.ifModified && modRes))) {\n                                    jQuery.lastModified[s.url] = modRes;\n                                }\n                            ;\n                            ;\n                                if (!jsonp) {\n                                    success();\n                                }\n                            ;\n                            ;\n                            }\n                             else {\n                                jQuery.handleError(s, xhr, JSBNG__status);\n                            }\n                        ;\n                        ;\n                            complete();\n                            if (s.async) {\n                                xhr = null;\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                    };\n                    if (s.async) {\n                        var ival = JSBNG__setInterval(onreadystatechange, 13);\n                        if (((s.timeout > 0))) {\n                            JSBNG__setTimeout(function() {\n                                if (xhr) {\n                                    xhr.abort();\n                                    if (!requestDone) {\n                                        onreadystatechange(\"timeout\");\n                                    }\n                                ;\n                                ;\n                                }\n                            ;\n                            ;\n                            }, s.timeout);\n                        }\n                    ;\n                    ;\n                    }\n                ;\n                ;\n                    try {\n                        xhr.send(s.data);\n                    } catch (e) {\n                        jQuery.handleError(s, xhr, null, e);\n                    };\n                ;\n                    if (!s.async) {\n                        onreadystatechange();\n                    }\n                ;\n                ;\n                    function success() {\n                        if (s.success) {\n                            s.success(data, JSBNG__status);\n                        }\n                    ;\n                    ;\n                        if (s.global) {\n                            jQuery.JSBNG__event.trigger(\"ajaxSuccess\", [xhr,s,]);\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    function complete() {\n                        if (s.complete) {\n                            s.complete(xhr, JSBNG__status);\n                        }\n                    ;\n                    ;\n                        if (s.global) {\n                            jQuery.JSBNG__event.trigger(\"ajaxComplete\", [xhr,s,]);\n                        }\n                    ;\n                    ;\n                        if (((s.global && !--jQuery.active))) {\n                            jQuery.JSBNG__event.trigger(\"ajaxStop\");\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    return xhr;\n                },\n                handleError: function(s, xhr, JSBNG__status, e) {\n                    if (s.error) {\n                        s.error(xhr, JSBNG__status, e);\n                    }\n                ;\n                ;\n                    if (s.global) {\n                        jQuery.JSBNG__event.trigger(\"ajaxError\", [xhr,s,e,]);\n                    }\n                ;\n                ;\n                },\n                active: 0,\n                httpSuccess: function(xhr) {\n                    try {\n                        return ((((((((((!xhr.JSBNG__status && ((JSBNG__location.protocol == \"file:\")))) || ((((xhr.JSBNG__status >= 200)) && ((xhr.JSBNG__status < 300)))))) || ((xhr.JSBNG__status == 304)))) || ((xhr.JSBNG__status == 1223)))) || ((jQuery.browser.safari && ((xhr.JSBNG__status == undefined))))));\n                    } catch (e) {\n                    \n                    };\n                ;\n                    return false;\n                },\n                httpNotModified: function(xhr, url) {\n                    try {\n                        var xhrRes = xhr.getResponseHeader(\"Last-Modified\");\n                        return ((((((xhr.JSBNG__status == 304)) || ((xhrRes == jQuery.lastModified[url])))) || ((jQuery.browser.safari && ((xhr.JSBNG__status == undefined))))));\n                    } catch (e) {\n                    \n                    };\n                ;\n                    return false;\n                },\n                httpData: function(xhr, type, filter) {\n                    var ct = xhr.getResponseHeader(\"content-type\"), xml = ((((type == \"xml\")) || ((((!type && ct)) && ((ct.indexOf(\"xml\") >= 0)))))), data = ((xml ? xhr.responseXML : xhr.responseText));\n                    if (((xml && ((data.documentElement.tagName == \"parsererror\"))))) {\n                        throw \"parsererror\";\n                    }\n                ;\n                ;\n                    if (filter) {\n                        data = filter(data, type);\n                    }\n                ;\n                ;\n                    if (((type == \"script\"))) {\n                        jQuery.globalEval(data);\n                    }\n                ;\n                ;\n                    if (((type == \"json\"))) {\n                        data = eval(((((\"(\" + data)) + \")\")));\n                    }\n                ;\n                ;\n                    return data;\n                },\n                param: function(a) {\n                    var s = [];\n                    if (((((a.constructor == Array)) || a.jquery))) {\n                        jQuery.each(a, function() {\n                            s.push(((((encodeURIComponent(this.JSBNG__name) + \"=\")) + encodeURIComponent(this.value))));\n                        });\n                    }\n                     else {\n                        {\n                            var fin24keys = ((window.top.JSBNG_Replay.forInKeys)((a))), fin24i = (0);\n                            var j;\n                            for (; (fin24i < fin24keys.length); (fin24i++)) {\n                                ((j) = (fin24keys[fin24i]));\n                                {\n                                    if (((a[j] && ((a[j].constructor == Array))))) {\n                                        jQuery.each(a[j], function() {\n                                            s.push(((((encodeURIComponent(j) + \"=\")) + encodeURIComponent(this))));\n                                        });\n                                    }\n                                     else {\n                                        s.push(((((encodeURIComponent(j) + \"=\")) + encodeURIComponent(((jQuery.isFunction(a[j]) ? a[j]() : a[j]))))));\n                                    }\n                                ;\n                                ;\n                                };\n                            };\n                        };\n                    ;\n                    }\n                ;\n                ;\n                    return s.join(\"&\").replace(/%20/g, \"+\");\n                }\n            });\n            jQuery.fn.extend({\n                show: function(speed, callback) {\n                    return ((speed ? this.animate({\n                        height: \"show\",\n                        width: \"show\",\n                        opacity: \"show\"\n                    }, speed, callback) : this.filter(\":hidden\").each(function() {\n                        this.style.display = ((this.oldblock || \"\"));\n                        if (((jQuery.css(this, \"display\") == \"none\"))) {\n                            var elem = jQuery(((((\"\\u003C\" + this.tagName)) + \" /\\u003E\"))).appendTo(\"body\");\n                            this.style.display = elem.css(\"display\");\n                            if (((this.style.display == \"none\"))) {\n                                this.style.display = \"block\";\n                            }\n                        ;\n                        ;\n                            elem.remove();\n                        }\n                    ;\n                    ;\n                    }).end()));\n                },\n                hide: function(speed, callback) {\n                    return ((speed ? this.animate({\n                        height: \"hide\",\n                        width: \"hide\",\n                        opacity: \"hide\"\n                    }, speed, callback) : this.filter(\":visible\").each(function() {\n                        this.oldblock = ((this.oldblock || jQuery.css(this, \"display\")));\n                        this.style.display = \"none\";\n                    }).end()));\n                },\n                _toggle: jQuery.fn.toggle,\n                toggle: function(fn, fn2) {\n                    return ((((jQuery.isFunction(fn) && jQuery.isFunction(fn2))) ? this._toggle.apply(this, arguments) : ((fn ? this.animate({\n                        height: \"toggle\",\n                        width: \"toggle\",\n                        opacity: \"toggle\"\n                    }, fn, fn2) : this.each(function() {\n                        jQuery(this)[((jQuery(this).is(\":hidden\") ? \"show\" : \"hide\"))]();\n                    })))));\n                },\n                slideDown: function(speed, callback) {\n                    return this.animate({\n                        height: \"show\"\n                    }, speed, callback);\n                },\n                slideUp: function(speed, callback) {\n                    return this.animate({\n                        height: \"hide\"\n                    }, speed, callback);\n                },\n                slideToggle: function(speed, callback) {\n                    return this.animate({\n                        height: \"toggle\"\n                    }, speed, callback);\n                },\n                fadeIn: function(speed, callback) {\n                    return this.animate({\n                        opacity: \"show\"\n                    }, speed, callback);\n                },\n                fadeOut: function(speed, callback) {\n                    return this.animate({\n                        opacity: \"hide\"\n                    }, speed, callback);\n                },\n                fadeTo: function(speed, to, callback) {\n                    return this.animate({\n                        opacity: to\n                    }, speed, callback);\n                },\n                animate: function(prop, speed, easing, callback) {\n                    var optall = jQuery.speed(speed, easing, callback);\n                    return this[((((optall.queue === false)) ? \"each\" : \"queue\"))](function() {\n                        if (((this.nodeType != 1))) {\n                            return false;\n                        }\n                    ;\n                    ;\n                        var opt = jQuery.extend({\n                        }, optall), p, hidden = jQuery(this).is(\":hidden\"), JSBNG__self = this;\n                        {\n                            var fin25keys = ((window.top.JSBNG_Replay.forInKeys)((prop))), fin25i = (0);\n                            (0);\n                            for (; (fin25i < fin25keys.length); (fin25i++)) {\n                                ((p) = (fin25keys[fin25i]));\n                                {\n                                    if (((((((prop[p] == \"hide\")) && hidden)) || ((((prop[p] == \"show\")) && !hidden))))) {\n                                        return opt.complete.call(this);\n                                    }\n                                ;\n                                ;\n                                    if (((((p == \"height\")) || ((p == \"width\"))))) {\n                                        opt.display = jQuery.css(this, \"display\");\n                                        opt.overflow = this.style.overflow;\n                                    }\n                                ;\n                                ;\n                                };\n                            };\n                        };\n                    ;\n                        if (((opt.overflow != null))) {\n                            this.style.overflow = \"hidden\";\n                        }\n                    ;\n                    ;\n                        opt.curAnim = jQuery.extend({\n                        }, prop);\n                        jQuery.each(prop, function(JSBNG__name, val) {\n                            var e = new jQuery.fx(JSBNG__self, opt, JSBNG__name);\n                            if (/toggle|show|hide/.test(val)) {\n                                e[((((val == \"toggle\")) ? ((hidden ? \"show\" : \"hide\")) : val))](prop);\n                            }\n                             else {\n                                var parts = val.toString().match(/^([+-]=)?([\\d+-.]+)(.*)$/), start = ((e.cur(true) || 0));\n                                if (parts) {\n                                    var end = parseFloat(parts[2]), unit = ((parts[3] || \"px\"));\n                                    if (((unit != \"px\"))) {\n                                        JSBNG__self.style[JSBNG__name] = ((((end || 1)) + unit));\n                                        start = ((((((end || 1)) / e.cur(true))) * start));\n                                        JSBNG__self.style[JSBNG__name] = ((start + unit));\n                                    }\n                                ;\n                                ;\n                                    if (parts[1]) {\n                                        end = ((((((((parts[1] == \"-=\")) ? -1 : 1)) * end)) + start));\n                                    }\n                                ;\n                                ;\n                                    e.custom(start, end, unit);\n                                }\n                                 else {\n                                    e.custom(start, val, \"\");\n                                }\n                            ;\n                            ;\n                            }\n                        ;\n                        ;\n                        });\n                        return true;\n                    });\n                },\n                queue: function(type, fn) {\n                    if (((jQuery.isFunction(type) || ((type && ((type.constructor == Array))))))) {\n                        fn = type;\n                        type = \"fx\";\n                    }\n                ;\n                ;\n                    if (((!type || ((((typeof type == \"string\")) && !fn))))) {\n                        return queue(this[0], type);\n                    }\n                ;\n                ;\n                    return this.each(function() {\n                        if (((fn.constructor == Array))) {\n                            queue(this, type, fn);\n                        }\n                         else {\n                            queue(this, type).push(fn);\n                            if (((queue(this, type).length == 1))) {\n                                fn.call(this);\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                    });\n                },\n                JSBNG__stop: function(clearQueue, gotoEnd) {\n                    var timers = jQuery.timers;\n                    if (clearQueue) {\n                        this.queue([]);\n                    }\n                ;\n                ;\n                    this.each(function() {\n                        for (var i = ((timers.length - 1)); ((i >= 0)); i--) {\n                            if (((timers[i].elem == this))) {\n                                if (gotoEnd) {\n                                    timers[i](true);\n                                }\n                            ;\n                            ;\n                                timers.splice(i, 1);\n                            }\n                        ;\n                        ;\n                        };\n                    ;\n                    });\n                    if (!gotoEnd) {\n                        this.dequeue();\n                    }\n                ;\n                ;\n                    return this;\n                }\n            });\n            var queue = function(elem, type, array) {\n                if (elem) {\n                    type = ((type || \"fx\"));\n                    var q = jQuery.data(elem, ((type + \"queue\")));\n                    if (((!q || array))) {\n                        q = jQuery.data(elem, ((type + \"queue\")), jQuery.makeArray(array));\n                    }\n                ;\n                ;\n                }\n            ;\n            ;\n                return q;\n            };\n            jQuery.fn.dequeue = function(type) {\n                type = ((type || \"fx\"));\n                return this.each(function() {\n                    var q = queue(this, type);\n                    q.shift();\n                    if (q.length) {\n                        q[0].call(this);\n                    }\n                ;\n                ;\n                });\n            };\n            jQuery.extend({\n                speed: function(speed, easing, fn) {\n                    var opt = ((((speed && ((speed.constructor == Object)))) ? speed : {\n                        complete: ((((fn || ((!fn && easing)))) || ((jQuery.isFunction(speed) && speed)))),\n                        duration: speed,\n                        easing: ((((fn && easing)) || ((((easing && ((easing.constructor != Function)))) && easing))))\n                    }));\n                    opt.duration = ((((((opt.duration && ((opt.duration.constructor == Number)))) ? opt.duration : jQuery.fx.speeds[opt.duration])) || jQuery.fx.speeds.def));\n                    opt.old = opt.complete;\n                    opt.complete = function() {\n                        if (((opt.queue !== false))) {\n                            jQuery(this).dequeue();\n                        }\n                    ;\n                    ;\n                        if (jQuery.isFunction(opt.old)) {\n                            opt.old.call(this);\n                        }\n                    ;\n                    ;\n                    };\n                    return opt;\n                },\n                easing: {\n                    linear: function(p, n, firstNum, diff) {\n                        return ((firstNum + ((diff * p))));\n                    },\n                    swing: function(p, n, firstNum, diff) {\n                        return ((((((((-Math.cos(((p * Math.PI))) / 2)) + 51337)) * diff)) + firstNum));\n                    }\n                },\n                timers: [],\n                timerId: null,\n                fx: function(elem, options, prop) {\n                    this.options = options;\n                    this.elem = elem;\n                    this.prop = prop;\n                    if (!options.orig) {\n                        options.orig = {\n                        };\n                    }\n                ;\n                ;\n                }\n            });\n            jQuery.fx.prototype = {\n                update: function() {\n                    if (this.options.step) {\n                        this.options.step.call(this.elem, this.now, this);\n                    }\n                ;\n                ;\n                    ((jQuery.fx.step[this.prop] || jQuery.fx.step._default))(this);\n                    if (((((this.prop == \"height\")) || ((this.prop == \"width\"))))) {\n                        this.elem.style.display = \"block\";\n                    }\n                ;\n                ;\n                },\n                cur: function(force) {\n                    if (((((this.elem[this.prop] != null)) && ((this.elem.style[this.prop] == null))))) {\n                        return this.elem[this.prop];\n                    }\n                ;\n                ;\n                    var r = parseFloat(jQuery.css(this.elem, this.prop, force));\n                    return ((((r && ((r > -10000)))) ? r : ((parseFloat(jQuery.curCSS(this.elem, this.prop)) || 0))));\n                },\n                custom: function(from, to, unit) {\n                    this.startTime = now();\n                    this.start = from;\n                    this.end = to;\n                    this.unit = ((((unit || this.unit)) || \"px\"));\n                    this.now = this.start;\n                    this.pos = this.state = 0;\n                    this.update();\n                    var JSBNG__self = this;\n                    function t(gotoEnd) {\n                        return JSBNG__self.step(gotoEnd);\n                    };\n                ;\n                    t.elem = this.elem;\n                    jQuery.timers.push(t);\n                    if (((jQuery.timerId == null))) {\n                        jQuery.timerId = JSBNG__setInterval(function() {\n                            var timers = jQuery.timers;\n                            for (var i = 0; ((i < timers.length)); i++) {\n                                if (!timers[i]()) {\n                                    timers.splice(i--, 1);\n                                }\n                            ;\n                            ;\n                            };\n                        ;\n                            if (!timers.length) {\n                                JSBNG__clearInterval(jQuery.timerId);\n                                jQuery.timerId = null;\n                            }\n                        ;\n                        ;\n                        }, 13);\n                    }\n                ;\n                ;\n                },\n                show: function() {\n                    this.options.orig[this.prop] = jQuery.attr(this.elem.style, this.prop);\n                    this.options.show = true;\n                    this.custom(0, this.cur());\n                    if (((((this.prop == \"width\")) || ((this.prop == \"height\"))))) {\n                        this.elem.style[this.prop] = \"1px\";\n                    }\n                ;\n                ;\n                    jQuery(this.elem).show();\n                },\n                hide: function() {\n                    this.options.orig[this.prop] = jQuery.attr(this.elem.style, this.prop);\n                    this.options.hide = true;\n                    this.custom(this.cur(), 0);\n                },\n                step: function(gotoEnd) {\n                    var t = now();\n                    if (((gotoEnd || ((t > ((this.options.duration + this.startTime))))))) {\n                        this.now = this.end;\n                        this.pos = this.state = 1;\n                        this.update();\n                        this.options.curAnim[this.prop] = true;\n                        var done = true;\n                        {\n                            var fin26keys = ((window.top.JSBNG_Replay.forInKeys)((this.options.curAnim))), fin26i = (0);\n                            var i;\n                            for (; (fin26i < fin26keys.length); (fin26i++)) {\n                                ((i) = (fin26keys[fin26i]));\n                                {\n                                    if (((this.options.curAnim[i] !== true))) {\n                                        done = false;\n                                    }\n                                ;\n                                ;\n                                };\n                            };\n                        };\n                    ;\n                        if (done) {\n                            if (((this.options.display != null))) {\n                                this.elem.style.overflow = this.options.overflow;\n                                this.elem.style.display = this.options.display;\n                                if (((jQuery.css(this.elem, \"display\") == \"none\"))) {\n                                    this.elem.style.display = \"block\";\n                                }\n                            ;\n                            ;\n                            }\n                        ;\n                        ;\n                            if (this.options.hide) {\n                                this.elem.style.display = \"none\";\n                            }\n                        ;\n                        ;\n                            if (((this.options.hide || this.options.show))) {\n                                {\n                                    var fin27keys = ((window.top.JSBNG_Replay.forInKeys)((this.options.curAnim))), fin27i = (0);\n                                    var p;\n                                    for (; (fin27i < fin27keys.length); (fin27i++)) {\n                                        ((p) = (fin27keys[fin27i]));\n                                        {\n                                            jQuery.attr(this.elem.style, p, this.options.orig[p]);\n                                        };\n                                    };\n                                };\n                            ;\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                        if (done) {\n                            this.options.complete.call(this.elem);\n                        }\n                    ;\n                    ;\n                        return false;\n                    }\n                     else {\n                        var n = ((t - this.startTime));\n                        this.state = ((n / this.options.duration));\n                        this.pos = jQuery.easing[((this.options.easing || ((jQuery.easing.swing ? \"swing\" : \"linear\"))))](this.state, n, 0, 1, this.options.duration);\n                        this.now = ((this.start + ((((this.end - this.start)) * this.pos))));\n                        this.update();\n                    }\n                ;\n                ;\n                    return true;\n                }\n            };\n            jQuery.extend(jQuery.fx, {\n                speeds: {\n                    slow: 600,\n                    fast: 200,\n                    def: 400\n                },\n                step: {\n                    scrollLeft: function(fx) {\n                        fx.elem.scrollLeft = fx.now;\n                    },\n                    scrollTop: function(fx) {\n                        fx.elem.scrollTop = fx.now;\n                    },\n                    opacity: function(fx) {\n                        jQuery.attr(fx.elem.style, \"opacity\", fx.now);\n                    },\n                    _default: function(fx) {\n                        fx.elem.style[fx.prop] = ((fx.now + fx.unit));\n                    }\n                }\n            });\n            jQuery.fn.offset = function() {\n                var left = 0, JSBNG__top = 0, elem = this[0], results;\n                if (elem) {\n                    with (jQuery.browser) {\n                        var parent = elem.parentNode, offsetChild = elem, offsetParent = elem.offsetParent, doc = elem.ownerDocument, safari2 = ((((safari && ((parseInt(version) < 522)))) && !/adobeair/i.test(userAgent))), css = jQuery.curCSS, fixed = ((css(elem, \"position\") == \"fixed\"));\n                        if (elem.getBoundingClientRect) {\n                            var box = elem.getBoundingClientRect();\n                            add(((box.left + Math.max(doc.documentElement.scrollLeft, doc.body.scrollLeft))), ((box.JSBNG__top + Math.max(doc.documentElement.scrollTop, doc.body.scrollTop))));\n                            add(-doc.documentElement.clientLeft, -doc.documentElement.clientTop);\n                        }\n                         else {\n                            add(elem.offsetLeft, elem.offsetTop);\n                            while (offsetParent) {\n                                add(offsetParent.offsetLeft, offsetParent.offsetTop);\n                                if (((((mozilla && !/^t(able|d|h)$/i.test(offsetParent.tagName))) || ((safari && !safari2))))) {\n                                    border(offsetParent);\n                                }\n                            ;\n                            ;\n                                if (((!fixed && ((css(offsetParent, \"position\") == \"fixed\"))))) {\n                                    fixed = true;\n                                }\n                            ;\n                            ;\n                                offsetChild = ((/^body$/i.test(offsetParent.tagName) ? offsetChild : offsetParent));\n                                offsetParent = offsetParent.offsetParent;\n                            };\n                        ;\n                            while (((((parent && parent.tagName)) && !/^body|html$/i.test(parent.tagName)))) {\n                                if (!/^inline|table.*$/i.test(css(parent, \"display\"))) {\n                                    add(-parent.scrollLeft, -parent.scrollTop);\n                                }\n                            ;\n                            ;\n                                if (((mozilla && ((css(parent, \"overflow\") != \"visible\"))))) {\n                                    border(parent);\n                                }\n                            ;\n                            ;\n                                parent = parent.parentNode;\n                            };\n                        ;\n                            if (((((safari2 && ((fixed || ((css(offsetChild, \"position\") == \"absolute\")))))) || ((mozilla && ((css(offsetChild, \"position\") != \"absolute\"))))))) {\n                                add(-doc.body.offsetLeft, -doc.body.offsetTop);\n                            }\n                        ;\n                        ;\n                            if (fixed) {\n                                add(Math.max(doc.documentElement.scrollLeft, doc.body.scrollLeft), Math.max(doc.documentElement.scrollTop, doc.body.scrollTop));\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                        results = {\n                            JSBNG__top: JSBNG__top,\n                            left: left\n                        };\n                    };\n                ;\n                }\n            ;\n            ;\n                function border(elem) {\n                    add(jQuery.curCSS(elem, \"borderLeftWidth\", true), jQuery.curCSS(elem, \"borderTopWidth\", true));\n                };\n            ;\n                function add(l, t) {\n                    left += ((parseInt(l, 10) || 0));\n                    JSBNG__top += ((parseInt(t, 10) || 0));\n                };\n            ;\n                return results;\n            };\n            jQuery.fn.extend({\n                position: function() {\n                    var left = 0, JSBNG__top = 0, results;\n                    if (this[0]) {\n                        var offsetParent = this.offsetParent(), offset = this.offset(), parentOffset = ((/^body|html$/i.test(offsetParent[0].tagName) ? {\n                            JSBNG__top: 0,\n                            left: 0\n                        } : offsetParent.offset()));\n                        offset.JSBNG__top -= num(this, \"marginTop\");\n                        offset.left -= num(this, \"marginLeft\");\n                        parentOffset.JSBNG__top += num(offsetParent, \"borderTopWidth\");\n                        parentOffset.left += num(offsetParent, \"borderLeftWidth\");\n                        results = {\n                            JSBNG__top: ((offset.JSBNG__top - parentOffset.JSBNG__top)),\n                            left: ((offset.left - parentOffset.left))\n                        };\n                    }\n                ;\n                ;\n                    return results;\n                },\n                offsetParent: function() {\n                    var offsetParent = this[0].offsetParent;\n                    while (((offsetParent && ((!/^body|html$/i.test(offsetParent.tagName) && ((jQuery.css(offsetParent, \"position\") == \"static\"))))))) {\n                        offsetParent = offsetParent.offsetParent;\n                    };\n                ;\n                    return jQuery(offsetParent);\n                }\n            });\n            jQuery.each([\"Left\",\"Top\",], function(i, JSBNG__name) {\n                var method = ((\"JSBNG__scroll\" + JSBNG__name));\n                jQuery.fn[method] = function(val) {\n                    if (!this[0]) {\n                        return;\n                    }\n                ;\n                ;\n                    return ((((val != undefined)) ? this.each(function() {\n                        ((((((this == window)) || ((this == JSBNG__document)))) ? window.JSBNG__scrollTo(((!i ? val : jQuery(window).scrollLeft())), ((i ? val : jQuery(window).scrollTop()))) : this[method] = val));\n                    }) : ((((((this[0] == window)) || ((this[0] == JSBNG__document)))) ? ((((JSBNG__self[((i ? \"JSBNG__pageYOffset\" : \"JSBNG__pageXOffset\"))] || ((jQuery.boxModel && JSBNG__document.documentElement[method])))) || JSBNG__document.body[method])) : this[0][method]))));\n                };\n            });\n            jQuery.each([\"Height\",\"Width\",], function(i, JSBNG__name) {\n                var tl = ((i ? \"Left\" : \"Top\")), br = ((i ? \"Right\" : \"Bottom\"));\n                jQuery.fn[((\"JSBNG__inner\" + JSBNG__name))] = function() {\n                    return ((((this[JSBNG__name.toLowerCase()]() + num(this, ((\"padding\" + tl))))) + num(this, ((\"padding\" + br)))));\n                };\n                jQuery.fn[((\"JSBNG__outer\" + JSBNG__name))] = function(margin) {\n                    return ((((((this[((\"JSBNG__inner\" + JSBNG__name))]() + num(this, ((((\"border\" + tl)) + \"Width\"))))) + num(this, ((((\"border\" + br)) + \"Width\"))))) + ((margin ? ((num(this, ((\"margin\" + tl))) + num(this, ((\"margin\" + br))))) : 0))));\n                };\n            });\n        };\n        if (window.amznJQ) {\n            amznJQ.initJQuery = initJQuery;\n        }\n         else {\n            initJQuery();\n        }\n    ;\n    ;\n    })();\n    (function() {\n        var patchJQuery = function(jQuery) {\n            var $ = jQuery;\n            if (!jQuery) {\n                return;\n            }\n        ;\n        ;\n            jQuery.fn.offset126 = jQuery.fn.offset;\n            if (JSBNG__document.documentElement[\"getBoundingClientRect\"]) {\n                jQuery.fn.offset = function() {\n                    if (!this[0]) {\n                        return {\n                            JSBNG__top: 0,\n                            left: 0\n                        };\n                    }\n                ;\n                ;\n                    if (((this[0] === this[0].ownerDocument.body))) {\n                        return jQuery.offset.bodyOffset(this[0]);\n                    }\n                ;\n                ;\n                    var box = this[0].getBoundingClientRect(), doc = this[0].ownerDocument, body = doc.body, docElem = doc.documentElement, ieTouch = ((JSBNG__navigator.msMaxTouchPoints > 0)), clientTop = ((((docElem.clientTop || body.clientTop)) || 0)), clientLeft = ((((docElem.clientLeft || body.clientLeft)) || 0)), JSBNG__top = ((((box.JSBNG__top + ((((((!ieTouch && JSBNG__self.JSBNG__pageYOffset)) || ((jQuery.boxModel && docElem.scrollTop)))) || body.scrollTop)))) - clientTop)), left = ((((box.left + ((((((!ieTouch && JSBNG__self.JSBNG__pageXOffset)) || ((jQuery.boxModel && docElem.scrollLeft)))) || body.scrollLeft)))) - clientLeft));\n                    return {\n                        JSBNG__top: JSBNG__top,\n                        left: left\n                    };\n                };\n            }\n             else {\n                jQuery.fn.offset = function() {\n                    if (!this[0]) {\n                        return {\n                            JSBNG__top: 0,\n                            left: 0\n                        };\n                    }\n                ;\n                ;\n                    if (((this[0] === this[0].ownerDocument.body))) {\n                        return jQuery.offset.bodyOffset(this[0]);\n                    }\n                ;\n                ;\n                    ((jQuery.offset.initialized || jQuery.offset.initialize()));\n                    var elem = this[0], offsetParent = elem.offsetParent, prevOffsetParent = elem, doc = elem.ownerDocument, computedStyle, docElem = doc.documentElement, body = doc.body, defaultView = doc.defaultView, prevComputedStyle = defaultView.JSBNG__getComputedStyle(elem, null), JSBNG__top = elem.offsetTop, left = elem.offsetLeft;\n                    while ((((((elem = elem.parentNode) && ((elem !== body)))) && ((elem !== docElem))))) {\n                        computedStyle = defaultView.JSBNG__getComputedStyle(elem, null);\n                        JSBNG__top -= elem.scrollTop, left -= elem.scrollLeft;\n                        if (((elem === offsetParent))) {\n                            JSBNG__top += elem.offsetTop, left += elem.offsetLeft;\n                            if (((jQuery.offset.doesNotAddBorder && !((jQuery.offset.doesAddBorderForTableAndCells && /^t(able|d|h)$/i.test(elem.tagName)))))) {\n                                JSBNG__top += ((parseInt(computedStyle.borderTopWidth, 10) || 0)), left += ((parseInt(computedStyle.borderLeftWidth, 10) || 0));\n                            }\n                        ;\n                        ;\n                            prevOffsetParent = offsetParent, offsetParent = elem.offsetParent;\n                        }\n                    ;\n                    ;\n                        if (((jQuery.offset.subtractsBorderForOverflowNotVisible && ((computedStyle.overflow !== \"visible\"))))) {\n                            JSBNG__top += ((parseInt(computedStyle.borderTopWidth, 10) || 0)), left += ((parseInt(computedStyle.borderLeftWidth, 10) || 0));\n                        }\n                    ;\n                    ;\n                        prevComputedStyle = computedStyle;\n                    };\n                ;\n                    if (((((prevComputedStyle.position === \"relative\")) || ((prevComputedStyle.position === \"static\"))))) {\n                        JSBNG__top += body.offsetTop, left += body.offsetLeft;\n                    }\n                ;\n                ;\n                    if (((prevComputedStyle.position === \"fixed\"))) {\n                        JSBNG__top += Math.max(docElem.scrollTop, body.scrollTop), left += Math.max(docElem.scrollLeft, body.scrollLeft);\n                    }\n                ;\n                ;\n                    return {\n                        JSBNG__top: JSBNG__top,\n                        left: left\n                    };\n                };\n            }\n        ;\n        ;\n            jQuery.offset = {\n                initialize: function() {\n                    if (this.initialized) {\n                        return;\n                    }\n                ;\n                ;\n                    var body = JSBNG__document.body, container = JSBNG__document.createElement(\"div\"), innerDiv, checkDiv, table, rules, prop, bodyMarginTop = body.style.marginTop, html = \"\\u003Cdiv style=\\\"position:absolute;top:0;left:0;margin:0;border:5px solid #000;padding:0;width:1px;height:1px;\\\"\\u003E\\u003Cdiv\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003Ctable style=\\\"position:absolute;top:0;left:0;margin:0;border:5px solid #000;padding:0;width:1px;height:1px;\\\"cellpadding=\\\"0\\\"cellspacing=\\\"0\\\"\\u003E\\u003Ctr\\u003E\\u003Ctd\\u003E\\u003C/td\\u003E\\u003C/tr\\u003E\\u003C/table\\u003E\";\n                    rules = {\n                        position: \"absolute\",\n                        JSBNG__top: 0,\n                        left: 0,\n                        margin: 0,\n                        border: 0,\n                        width: \"1px\",\n                        height: \"1px\",\n                        visibility: \"hidden\"\n                    };\n                    {\n                        var fin28keys = ((window.top.JSBNG_Replay.forInKeys)((rules))), fin28i = (0);\n                        (0);\n                        for (; (fin28i < fin28keys.length); (fin28i++)) {\n                            ((prop) = (fin28keys[fin28i]));\n                            {\n                                container.style[prop] = rules[prop];\n                            };\n                        };\n                    };\n                ;\n                    container.innerHTML = html;\n                    body.insertBefore(container, body.firstChild);\n                    innerDiv = container.firstChild, checkDiv = innerDiv.firstChild, td = innerDiv.nextSibling.firstChild.firstChild;\n                    this.doesNotAddBorder = ((checkDiv.offsetTop !== 5));\n                    this.doesAddBorderForTableAndCells = ((td.offsetTop === 5));\n                    innerDiv.style.overflow = \"hidden\", innerDiv.style.position = \"relative\";\n                    this.subtractsBorderForOverflowNotVisible = ((checkDiv.offsetTop === -5));\n                    body.style.marginTop = \"1px\";\n                    this.doesNotIncludeMarginInBodyOffset = ((body.offsetTop === 0));\n                    body.style.marginTop = bodyMarginTop;\n                    body.removeChild(container);\n                    this.initialized = true;\n                },\n                bodyOffset: function(body) {\n                    ((jQuery.offset.initialized || jQuery.offset.initialize()));\n                    var JSBNG__top = body.offsetTop, left = body.offsetLeft;\n                    if (jQuery.offset.doesNotIncludeMarginInBodyOffset) {\n                        JSBNG__top += ((parseInt(jQuery.curCSS(body, \"marginTop\", true), 10) || 0)), left += ((parseInt(jQuery.curCSS(body, \"marginLeft\", true), 10) || 0));\n                    }\n                ;\n                ;\n                    return {\n                        JSBNG__top: JSBNG__top,\n                        left: left\n                    };\n                }\n            };\n            if (((jQuery.browser.msie && ((JSBNG__document.compatMode == \"BackCompat\"))))) {\n                var fixOriginal = jQuery.JSBNG__event.fix;\n                jQuery.JSBNG__event.fix = function(JSBNG__event) {\n                    var e = fixOriginal(JSBNG__event);\n                    e.pageX -= 2;\n                    e.pageY -= 2;\n                    return e;\n                };\n            }\n        ;\n        ;\n            jQuery.fn.offsetNoIPadFix = jQuery.fn.offset;\n            jQuery.fn.offsetIPadFix = jQuery.fn.offset;\n            if (((((/webkit.*mobile/i.test(JSBNG__navigator.userAgent) && ((parseFloat($.browser.version) < 532.9)))) && ((\"getBoundingClientRect\" in JSBNG__document.documentElement))))) {\n                jQuery.fn.offsetIPadFix = function() {\n                    var result = this.offsetNoIPadFix();\n                    result.JSBNG__top -= window.JSBNG__scrollY;\n                    result.left -= window.JSBNG__scrollX;\n                    return result;\n                };\n                if (((((typeof window.jQueryPatchIPadOffset != \"undefined\")) && window.jQueryPatchIPadOffset))) {\n                    jQuery.fn.offset = jQuery.fn.offsetIPadFix;\n                }\n            ;\n            ;\n            }\n        ;\n        ;\n        };\n        if (((window.amznJQ && amznJQ.initJQuery))) {\n            var initJQuery = amznJQ.initJQuery;\n            amznJQ.initJQuery = function() {\n                initJQuery();\n                patchJQuery(jQuery);\n            };\n        }\n         else {\n            patchJQuery(jQuery);\n        }\n    ;\n    ;\n    })();\n    (function() {\n        var timesliceJS, initJQuery;\n        if (window.amznJQ) {\n            timesliceJS = amznJQ._timesliceJS;\n            initJQuery = amznJQ.initJQuery;\n            delete amznJQ._timesliceJS;\n            delete amznJQ.initJQuery;\n        }\n    ;\n    ;\n        var isRunning = false, cbsWaiting = [];\n        var doDeferred = function() {\n        ;\n            isRunning = true;\n            var stopTime = (((new JSBNG__Date()).getTime() + 40));\n            var callingCB;\n            try {\n                while (((cbsWaiting.length && (((new JSBNG__Date()).getTime() <= stopTime))))) {\n                    var cb = cbsWaiting.shift();\n                    callingCB = true;\n                    cb();\n                    callingCB = false;\n                };\n            ;\n            } finally {\n                if (callingCB) {\n                ;\n                }\n            ;\n            ;\n                if (cbsWaiting.length) {\n                ;\n                    JSBNG__setTimeout(doDeferred, 0);\n                }\n                 else {\n                ;\n                    isRunning = false;\n                }\n            ;\n            ;\n            };\n        ;\n        };\n        var callInTimeslice = function(cbOrArray) {\n            if (((typeof cbOrArray === \"function\"))) {\n                cbsWaiting.push(cbOrArray);\n            }\n             else {\n                cbsWaiting = cbsWaiting.concat(cbOrArray);\n            }\n        ;\n        ;\n            if (!isRunning) {\n                isRunning = true;\n                JSBNG__setTimeout(doDeferred, 0);\n            }\n        ;\n        ;\n        };\n        var initAmznJQ = function() {\n            var $ = window.jQuery, jQuery = $;\n            if (!jQuery) {\n                return;\n            }\n        ;\n        ;\n            var bootstrapAmznJQ = window.amznJQ;\n            if (!window.goN2Debug) {\n                window.goN2Debug = new function() {\n                    this.info = function() {\n                    \n                    };\n                    return this;\n                };\n            }\n        ;\n        ;\n            window.amznJQ = new function() {\n            ;\n                var me = this;\n                me.jQuery = jQuery;\n                jQuery.noConflict(true);\n                if (window.jQuery) {\n                ;\n                }\n                 else {\n                    window.jQuery = jQuery;\n                }\n            ;\n            ;\n                var _logicalToPhysical = {\n                    JQuery: {\n                        functionality: \"JQuery\",\n                        urls: null\n                    },\n                    popover: {\n                        functionality: \"popover\",\n                        urls: null\n                    }\n                };\n                var _func_loaded = {\n                };\n                var _url_loaded = {\n                };\n                var _loading = {\n                };\n                function _loadFunctionality(functionality) {\n                    var urls = _logicalToPhysical[functionality].urls;\n                    if (urls) {\n                    ;\n                        $.each(urls, function() {\n                            if (!_url_loaded[this]) {\n                                _loadURL(this, functionality);\n                            }\n                        ;\n                        ;\n                        });\n                    }\n                     else {\n                    ;\n                    }\n                ;\n                ;\n                };\n            ;\n                function _loadURL(url, functionality) {\n                ;\n                    $.ajax({\n                        type: \"GET\",\n                        url: url,\n                        success: _onUrlLoadedFcn(url, functionality),\n                        dataType: \"script\",\n                        cache: true\n                    });\n                };\n            ;\n                function _onUrlLoadedFcn(url, functionality) {\n                    return function() {\n                    ;\n                        _url_loaded[url] = true;\n                        var all_loaded = true;\n                        $.each(_logicalToPhysical[functionality].urls, function() {\n                            all_loaded = ((all_loaded && !!_url_loaded[this]));\n                        });\n                        if (all_loaded) {\n                        \n                        }\n                    ;\n                    ;\n                    };\n                };\n            ;\n                me.addLogical = function(functionality, urls) {\n                    var ul = ((urls ? urls.length : \"no\"));\n                ;\n                    _logicalToPhysical[functionality] = {\n                        functionality: functionality,\n                        urls: urls\n                    };\n                    if (!urls) {\n                        me.declareAvailable(functionality);\n                        return;\n                    }\n                ;\n                ;\n                    if (_loading[functionality]) {\n                        _loadFunctionality(functionality);\n                    }\n                ;\n                ;\n                };\n                me.declareAvailable = function(functionality) {\n                ;\n                    if (((typeof _logicalToPhysical[functionality] == \"undefined\"))) {\n                        _logicalToPhysical[functionality] = {\n                            functionality: functionality,\n                            urls: null\n                        };\n                    }\n                ;\n                ;\n                    _func_loaded[functionality] = true;\n                    triggerEventCallbacks(((functionality + \".loaded\")));\n                };\n                me.addStyle = function(css_url) {\n                    var dcss = JSBNG__document.styleSheets[0];\n                    if (((dcss && dcss.addImport))) {\n                        while (((dcss.imports.length >= 31))) {\n                            dcss = dcss.imports[0];\n                        };\n                    ;\n                        dcss.addImport(css_url);\n                    }\n                     else {\n                        $(\"style[type='text/css']:first\").append(((((\"@import url(\\\"\" + css_url)) + \"\\\");\")));\n                    }\n                ;\n                ;\n                };\n                me.addStyles = function(args) {\n                    var urls = ((args.urls || []));\n                    var styles = ((args.styles || []));\n                    var dcss = JSBNG__document.styleSheets;\n                    if (((((dcss && !dcss.length)) && JSBNG__document.createStyleSheet))) {\n                        JSBNG__document.createStyleSheet();\n                    }\n                ;\n                ;\n                    dcss = dcss[0];\n                    if (((dcss && dcss.addImport))) {\n                        $.each(urls, function() {\n                            while (((dcss.imports.length >= 31))) {\n                                dcss = dcss.imports[0];\n                            };\n                        ;\n                            dcss.addImport(this);\n                        });\n                    }\n                     else {\n                        $.each(urls, function() {\n                            var attrs = {\n                                type: \"text/css\",\n                                rel: \"stylesheet\",\n                                href: this\n                            };\n                            $(\"head\").append($(\"\\u003Clink/\\u003E\").attr(attrs));\n                        });\n                    }\n                ;\n                ;\n                    var css = \"\";\n                    $.each(styles, function() {\n                        css += this;\n                    });\n                    if (css) {\n                        if (JSBNG__document.createStyleSheet) {\n                            try {\n                                var sheet = JSBNG__document.createStyleSheet();\n                                sheet.cssText = css;\n                            } catch (e) {\n                            \n                            };\n                        ;\n                        }\n                         else {\n                            $(\"head\").append($(\"\\u003Cstyle/\\u003E\").attr({\n                                type: \"text/css\"\n                            }).append(css));\n                        }\n                    ;\n                    ;\n                    }\n                ;\n                ;\n                };\n                var eventCBQueue = {\n                };\n                var enqueueEventCallback = function(eventName, cb) {\n                    if (!timesliceJS) {\n                        $(JSBNG__document).one(eventName, cb);\n                        return;\n                    }\n                ;\n                ;\n                    var queue = ((eventCBQueue[eventName] || []));\n                    queue.push(function() {\n                        cb(jQuery.JSBNG__event.fix({\n                            type: eventName\n                        }));\n                    });\n                    eventCBQueue[eventName] = queue;\n                };\n                var triggerEventCallbacks = function(eventName) {\n                    if (!timesliceJS) {\n                        $(JSBNG__document).trigger(eventName);\n                        return;\n                    }\n                ;\n                ;\n                    var queue = eventCBQueue[eventName];\n                    if (queue) {\n                        callInTimeslice(queue);\n                        delete eventCBQueue[eventName];\n                    }\n                ;\n                ;\n                };\n                var doEventCallbackNow = function(eventName, cb) {\n                    if (!timesliceJS) {\n                        $(JSBNG__document).one(eventName, cb);\n                        $(JSBNG__document).trigger(eventName);\n                    }\n                     else {\n                        if (eventCBQueue[eventName]) {\n                            enqueueEventCallback(eventName, cb);\n                            triggerEventCallbacks(eventName);\n                        }\n                         else {\n                            callInTimeslice(function() {\n                                cb(jQuery.JSBNG__event.fix({\n                                    type: eventName\n                                }));\n                            });\n                        }\n                    ;\n                    ;\n                    }\n                ;\n                ;\n                };\n                me.available = function(functionality, eventCallbackFunction) {\n                    if (_func_loaded[functionality]) {\n                    ;\n                        doEventCallbackNow(((functionality + \".loaded\")), eventCallbackFunction);\n                    }\n                     else {\n                        if (_loading[functionality]) {\n                        ;\n                            enqueueEventCallback(((functionality + \".loaded\")), eventCallbackFunction);\n                        }\n                         else {\n                            if (_logicalToPhysical[functionality]) {\n                            ;\n                                _loading[functionality] = true;\n                                enqueueEventCallback(((functionality + \".loaded\")), eventCallbackFunction);\n                                _loadFunctionality(functionality);\n                            }\n                             else {\n                            ;\n                                _loading[functionality] = true;\n                                enqueueEventCallback(((functionality + \".loaded\")), eventCallbackFunction);\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                    }\n                ;\n                ;\n                };\n                me.onReady = function(functionality, eventCallbackFunction) {\n                    var ajq = this;\n                    $(function() {\n                        ajq.available(functionality, eventCallbackFunction);\n                    });\n                };\n                var _stage_completed = {\n                };\n                var _fail_safe_stages = [\"amznJQ.theFold\",\"amznJQ.criticalFeature\",];\n                me.onCompletion = function(stage, callbackFn) {\n                    if (_stage_completed[stage]) {\n                    ;\n                        doEventCallbackNow(stage, callbackFn);\n                    }\n                     else {\n                    ;\n                        enqueueEventCallback(stage, callbackFn);\n                    }\n                ;\n                ;\n                };\n                me.completedStage = function(stage) {\n                    if (!_stage_completed[stage]) {\n                    ;\n                        _stage_completed[stage] = true;\n                        triggerEventCallbacks(stage);\n                    }\n                ;\n                ;\n                };\n                me.windowOnLoad = function() {\n                ;\n                    $.each(_fail_safe_stages, function() {\n                        if (!_stage_completed[this]) {\n                        ;\n                            _stage_completed[this] = true;\n                            triggerEventCallbacks(this);\n                        }\n                    ;\n                    ;\n                    });\n                };\n                (function() {\n                    var plUrls = [], lowPriUrls = [], hiPriUrls = [], isLowPriEligibleYet = false, ST = JSBNG__setTimeout, doc = JSBNG__document, docElem = doc.documentElement, styleObj = docElem.style, nav = JSBNG__navigator, isGecko = ((\"MozAppearance\" in styleObj)), isWebkit = ((!isGecko && ((\"webkitAppearance\" in styleObj)))), isSafari = ((isWebkit && ((nav.vendor.indexOf(\"Apple\") === 0)))), isIE = ((((!isGecko && !isWebkit)) && ((nav.appName.indexOf(\"Microsoft\") === 0)))), isMobile = ((nav.userAgent.indexOf(\"Mobile\") != -1)), allowedLoaders = ((((window.plCount !== undefined)) ? window.plCount() : ((((((!isMobile && ((isWebkit || isGecko)))) || ((isIE && ((typeof XDomainRequest === \"object\")))))) ? 5 : 2)))), currentLoaders = 0, timeout = 2500;\n                    function setLoadState() {\n                        if (((hiPriUrls.length > 0))) {\n                            plUrls = hiPriUrls;\n                        }\n                         else {\n                            plUrls = lowPriUrls;\n                            if (((((plUrls.length === 0)) || !isLowPriEligibleYet))) {\n                                return false;\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                        if (((currentLoaders >= allowedLoaders))) {\n                            return false;\n                        }\n                    ;\n                    ;\n                        currentLoaders++;\n                        return true;\n                    };\n                ;\n                    function loaderDone(loader, timer) {\n                        JSBNG__clearTimeout(timer);\n                        currentLoaders = ((((currentLoaders < 1)) ? 0 : ((currentLoaders - 1))));\n                        destroyLoader(loader);\n                        if (!isIE) {\n                            load();\n                        }\n                         else {\n                            ST(load, 0);\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    function destroyElement(el) {\n                        if (el) {\n                            var p = el.parentElement;\n                            if (p) {\n                                p.removeChild(el);\n                            }\n                        ;\n                        ;\n                            el = null;\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    var destroyLoader = function(loader) {\n                        if (isGecko) {\n                            JSBNG__setTimeout(function() {\n                                destroyElement(loader);\n                            }, 5);\n                        }\n                         else {\n                            destroyElement(loader);\n                        }\n                    ;\n                    ;\n                    };\n                    var load = ((!((((isIE || isGecko)) || isWebkit)) ? function() {\n                    ;\n                    } : function() {\n                        if (!setLoadState()) {\n                            return;\n                        }\n                    ;\n                    ;\n                        var url = plUrls.pop(), loader, hL = ((((plUrls === hiPriUrls)) ? \"H\" : \"L\")), timer;\n                    ;\n                        if (isGecko) {\n                            loader = doc.createElement(\"object\");\n                        }\n                         else {\n                            if (isSafari) {\n                                var end = url.indexOf(\"?\");\n                                end = ((((end > 0)) ? end : url.length));\n                                var posDot = url.lastIndexOf(\".\", end);\n                                if (posDot) {\n                                    switch (url.substring(((posDot + 1)), end).toLowerCase()) {\n                                      case \"js\":\n                                        loader = doc.createElement(\"script\");\n                                        loader.type = \"f\";\n                                        break;\n                                      case \"png\":\n                                    \n                                      case \"jpg\":\n                                    \n                                      case \"jpeg\":\n                                    \n                                      case \"gif\":\n                                        loader = new JSBNG__Image();\n                                        break;\n                                    };\n                                ;\n                                }\n                            ;\n                            ;\n                                if (!loader) {\n                                ;\n                                    loaderDone(url);\n                                    return;\n                                }\n                            ;\n                            ;\n                            }\n                             else {\n                                loader = new JSBNG__Image();\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                        loader.JSBNG__onerror = function() {\n                        ;\n                            loaderDone(loader, timer);\n                        };\n                        loader.JSBNG__onload = function() {\n                        ;\n                            loaderDone(loader, timer);\n                        };\n                        if (((isGecko || ((isSafari && ((loader.tagName == \"SCRIPT\"))))))) {\n                            timer = ST(function() {\n                            ;\n                                loaderDone(loader, timer);\n                            }, ((timeout + ((Math.JSBNG__random() * 100)))));\n                        }\n                    ;\n                    ;\n                        if (isGecko) {\n                            loader.data = url;\n                        }\n                         else {\n                            loader.src = url;\n                        }\n                    ;\n                    ;\n                        if (!isIE) {\n                            loader.width = loader.height = 0;\n                            loader.style.display = \"none\";\n                            docElem.appendChild(loader);\n                        }\n                    ;\n                    ;\n                        if (((currentLoaders < allowedLoaders))) {\n                            load();\n                        }\n                    ;\n                    ;\n                    }));\n                    function processUrlList(urlList, target) {\n                        if (((typeof (urlList) === \"string\"))) {\n                            urlList = [urlList,];\n                        }\n                         else {\n                            if (((((typeof (urlList) !== \"object\")) || ((urlList === null))))) {\n                                return;\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                        var i, u;\n                        for (i = 0; ((i < urlList.length)); i++) {\n                            u = urlList[i];\n                            if (((u && ((typeof (u) !== \"string\"))))) {\n                                processUrlList(u, target);\n                            }\n                             else {\n                                if (((u && !((u[0] == \" \"))))) {\n                                    target.splice(Math.round(((Math.JSBNG__random() * target.length))), 0, u);\n                                }\n                            ;\n                            ;\n                            }\n                        ;\n                        ;\n                        };\n                    ;\n                    };\n                ;\n                    me._getPLStat = function() {\n                        return {\n                            H: hiPriUrls.length,\n                            L: lowPriUrls.length,\n                            P: plUrls.length,\n                            CL: currentLoaders,\n                            AL: allowedLoaders\n                        };\n                    };\n                    me.addPL = function(urlList) {\n                        processUrlList(urlList, lowPriUrls);\n                        load();\n                    };\n                    me.PLNow = function(urlList) {\n                        processUrlList(urlList, hiPriUrls);\n                        load();\n                    };\n                    function triggerPagePreloads() {\n                        isLowPriEligibleYet = true;\n                        load();\n                    };\n                ;\n                    if (((typeof bootstrapAmznJQ.PLTriggerName !== \"undefined\"))) {\n                        amznJQ.available(bootstrapAmznJQ.PLTriggerName, triggerPagePreloads);\n                    }\n                     else {\n                        $(window).load(function() {\n                            ST(triggerPagePreloads, 1000);\n                        });\n                    }\n                ;\n                ;\n                }());\n                me.strings = {\n                };\n                me.chars = {\n                };\n                if (bootstrapAmznJQ) {\n                    $.extend(this.strings, bootstrapAmznJQ.strings);\n                    $.extend(this.chars, bootstrapAmznJQ.chars);\n                }\n            ;\n            ;\n            }();\n            $(window).load(function() {\n                amznJQ.windowOnLoad();\n            });\n            if (((((((window.ue && bootstrapAmznJQ)) && window.ues)) && window.uex))) {\n                ues(\"wb\", \"jQueryActive\", 1);\n                uex(\"ld\", \"jQueryActive\");\n            }\n        ;\n        ;\n            amznJQ.declareAvailable(\"JQuery\");\n            amznJQ.declareAvailable(\"jQuery\");\n            if (bootstrapAmznJQ) {\n            ;\n                $.each(bootstrapAmznJQ._l, function() {\n                    amznJQ.addLogical(this[0], this[1]);\n                });\n                $.each(bootstrapAmznJQ._s, function() {\n                    amznJQ.addStyle(this[0]);\n                });\n                $.each(bootstrapAmznJQ._d, function() {\n                    amznJQ.declareAvailable(this[0], this[1]);\n                });\n                $.each(bootstrapAmznJQ._a, function() {\n                    amznJQ.available(this[0], this[1]);\n                });\n                $.each(((bootstrapAmznJQ._t || [])), function() {\n                    callInTimeslice(this[0]);\n                });\n                $.each(bootstrapAmznJQ._o, function() {\n                    amznJQ.onReady(this[0], this[1]);\n                });\n                $.each(bootstrapAmznJQ._c, function() {\n                    amznJQ.onCompletion(this[0], this[1]);\n                });\n                $.each(bootstrapAmznJQ._cs, function() {\n                    amznJQ.completedStage(this[0], this[1]);\n                });\n                amznJQ.addPL(bootstrapAmznJQ._pl);\n            }\n        ;\n        ;\n        };\n        if (!initJQuery) {\n            initAmznJQ();\n        }\n         else {\n            if (!timesliceJS) {\n                initJQuery();\n                initAmznJQ();\n            }\n             else {\n                callInTimeslice(initJQuery);\n                callInTimeslice(initAmznJQ);\n            }\n        ;\n        ;\n        }\n    ;\n    ;\n    })();\n    (function() {\n        if (window.amznJQ) {\n            window.amznJQ.available(\"jQuery\", function() {\n                initAmazonPopover(((window.amznJQ.jQuery || window.jQuery)));\n                window.amznJQ.declareAvailable(\"popover\");\n            });\n        }\n    ;\n    ;\n        if (((((typeof window.P === \"object\")) && ((typeof window.P.when === \"function\"))))) {\n            window.P.when(\"jQuery\").register(\"legacy-popover\", function($) {\n                initAmazonPopover($);\n                return null;\n            });\n        }\n    ;\n    ;\n        function initAmazonPopover($) {\n            if (((!$ || $.AmazonPopover))) {\n                return;\n            }\n        ;\n        ;\n            var rootElement = function() {\n                var container = $(\"#ap_container\");\n                return ((((container.length && container)) || $(\"body\")));\n            };\n            var viewport = {\n                width: function() {\n                    return Math.min($(window).width(), $(JSBNG__document).width());\n                },\n                height: function() {\n                    return $(window).height();\n                }\n            };\n            var mouseTracker = function() {\n                var regions = [], n = 3, cursor = [{\n                    x: 0,\n                    y: 0\n                },], c = 0, JSBNG__scroll = [0,0,], listening = false;\n                var callbackArgs = function() {\n                    var pCursors = [];\n                    for (var i = 1; ((i < n)); i++) {\n                        pCursors.push(cursor[((((((c - i)) + n)) % n))]);\n                    };\n                ;\n                    return $.extend(true, {\n                    }, {\n                        cursor: cursor[c],\n                        priorCursors: pCursors\n                    });\n                };\n                var check = function(immediately) {\n                    for (var i = 0; ((i < regions.length)); i++) {\n                        var r = regions[i];\n                        var inside = (($.grep(r.rects, function(n) {\n                            return ((((((((cursor[c].x >= n[0])) && ((cursor[c].y >= n[1])))) && ((cursor[c].x < ((n[0] + n[2])))))) && ((cursor[c].y < ((n[1] + n[3]))))));\n                        }).length > 0));\n                        if (((((((((r.inside !== null)) && inside)) && !r.inside)) && r.mouseEnter))) {\n                            r.inside = r.mouseEnter(callbackArgs());\n                        }\n                         else {\n                            if (((((((((r.inside !== null)) && !inside)) && r.inside)) && r.mouseLeave))) {\n                                r.inside = !r.mouseLeave(immediately, callbackArgs());\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                };\n                var startListening = function() {\n                    JSBNG__scroll = [$(window).scrollLeft(),$(window).scrollTop(),];\n                    $(JSBNG__document).mousemove(function(e) {\n                        if (((typeof e.pageY !== \"undefined\"))) {\n                            c = ((((c + 1)) % n));\n                            cursor[c] = {\n                                x: e.pageX,\n                                y: e.pageY\n                            };\n                        }\n                    ;\n                    ;\n                        check();\n                    });\n                    if (!isMobileAgent(true)) {\n                        $(JSBNG__document).JSBNG__scroll(function(e) {\n                            cursor[c].x += (($(window).scrollLeft() - JSBNG__scroll[0]));\n                            cursor[c].y += (($(window).scrollTop() - JSBNG__scroll[1]));\n                            JSBNG__scroll = [$(window).scrollLeft(),$(window).scrollTop(),];\n                            check();\n                        });\n                    }\n                ;\n                ;\n                    listening = true;\n                };\n                return {\n                    add: function(rectsArray, options) {\n                        if (!listening) {\n                            startListening();\n                        }\n                    ;\n                    ;\n                        var r = $.extend({\n                            rects: rectsArray\n                        }, options);\n                        regions.push(r);\n                        return r;\n                    },\n                    remove: function(region) {\n                        for (var i = 0; ((i < regions.length)); i++) {\n                            if (((regions[i] === region))) {\n                                regions.splice(i, 1);\n                                return;\n                            }\n                        ;\n                        ;\n                        };\n                    ;\n                    },\n                    checkNow: function() {\n                        check(true);\n                    },\n                    getCallbackArgs: function() {\n                        return callbackArgs();\n                    }\n                };\n            }();\n            var iframePool = function() {\n                var ie6 = (($.browser.msie && ((parseInt($.browser.version) <= 6))));\n                var src = ((ie6 ? window.AmazonPopoverImages.pixel : \"javascript:void(false)\"));\n                var HTML = ((((\"\\u003Ciframe frameborder=\\\"0\\\" tabindex=\\\"-1\\\" src=\\\"\" + src)) + \"\\\" style=\\\"display:none;position:absolute;z-index:0;filter:Alpha(Opacity='0');opacity:0;\\\" /\\u003E\"));\n                var pool = [];\n                var addToLib = function(n) {\n                    for (i = 0; ((i < n)); i++) {\n                        pool.push($(HTML).prependTo(rootElement()));\n                    };\n                ;\n                };\n                $(JSBNG__document).ready(function() {\n                    addToLib(3);\n                });\n                return {\n                    checkout: function(jqObj) {\n                        if (!pool.length) {\n                            addToLib(1);\n                        }\n                    ;\n                    ;\n                        return pool.pop().css({\n                            display: \"block\",\n                            JSBNG__top: jqObj.offset().JSBNG__top,\n                            left: jqObj.offset().left,\n                            width: jqObj.JSBNG__outerWidth(),\n                            height: jqObj.JSBNG__outerHeight(),\n                            zIndex: ((Number(jqObj.css(\"z-index\")) - 1))\n                        });\n                    },\n                    checkin: function(iframe) {\n                        pool.push(iframe.css(\"display\", \"none\"));\n                    }\n                };\n            }();\n            var elementHidingManager = function() {\n                var hiddenElements = [];\n                var win = /Win/.test(JSBNG__navigator.platform);\n                var mac = /Mac/.test(JSBNG__navigator.platform);\n                var linux = /Linux/.test(JSBNG__navigator.platform);\n                var version = parseInt($.browser.version);\n                var canOverlayWmodeWindow = false;\n                var intersectingPopovers = function(obj) {\n                    var bounds = [obj.offset().left,obj.offset().JSBNG__top,obj.JSBNG__outerWidth(),obj.JSBNG__outerHeight(),];\n                    var intersecting = [];\n                    for (var i = 0; ((i < popovers.length)); i++) {\n                        var disparate = false;\n                        if (!popovers[i].settings.modal) {\n                            var r = popovers[i].bounds;\n                            disparate = ((((((((bounds[0] > ((r[0] + r[2])))) || ((r[0] > ((bounds[0] + bounds[2])))))) || ((bounds[1] > ((r[1] + r[3])))))) || ((r[1] > ((bounds[1] + bounds[3]))))));\n                        }\n                    ;\n                    ;\n                        if (!disparate) {\n                            intersecting.push(popovers[i]);\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    return intersecting;\n                };\n                var shouldBeVisible = function(obj) {\n                    if (obj.hasClass(\"ap_never_hide\")) {\n                        return true;\n                    }\n                ;\n                ;\n                    if (intersectingPopovers(obj).length) {\n                        if (obj.is(\"object,embed\")) {\n                            var wmode = ((((((obj.attr(\"wmode\") || obj.children(\"object,embed\").attr(\"wmode\"))) || obj.parent(\"object,embed\").attr(\"wmode\"))) || \"window\"));\n                            if (((((wmode.toLowerCase() == \"window\")) && !canOverlayWmodeWindow))) {\n                                return false;\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                        if (obj.is(\"div\")) {\n                            if ($.browser.safari) {\n                                return false;\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                    }\n                ;\n                ;\n                    return true;\n                };\n                var setVisibility = function(elementQuery, shouldBecomeVisible) {\n                    if (elementQuery.is(\"iframe[id^=DA],iframe[id^=cachebust]\")) {\n                        elementQuery.css({\n                            display: ((shouldBecomeVisible ? \"block\" : \"none\"))\n                        });\n                    }\n                     else {\n                        elementQuery.css({\n                            visibility: ((shouldBecomeVisible ? \"visible\" : \"hidden\"))\n                        });\n                    }\n                ;\n                ;\n                };\n                return {\n                    update: function() {\n                        var HIDDEN = 0;\n                        var VISIBLE = 1;\n                        var stillHidden = [];\n                        for (var i = 0; ((i < hiddenElements.length)); i++) {\n                            var hiddenElement = hiddenElements[i];\n                            if (!shouldBeVisible(hiddenElement)) {\n                                stillHidden.push(hiddenElement);\n                            }\n                             else {\n                                setVisibility(hiddenElement, VISIBLE);\n                            }\n                        ;\n                        ;\n                        };\n                    ;\n                        hiddenElements = stillHidden;\n                        $(\"object:visible,embed:visible,iframe:visible\").each(function() {\n                            var obj = jQuery(this);\n                            if (!shouldBeVisible(obj)) {\n                                hiddenElements.push(obj);\n                                setVisibility(obj, HIDDEN);\n                            }\n                        ;\n                        ;\n                        });\n                    }\n                };\n            }();\n            var applyBacking = function(popover, options) {\n                var region = null;\n                var iframe = null;\n                options = ((options || {\n                }));\n                var destroy = function() {\n                    if (region) {\n                        mouseTracker.remove(region);\n                        region = null;\n                    }\n                ;\n                ;\n                    if (iframe) {\n                        iframePool.checkin(iframe);\n                        iframe = null;\n                    }\n                ;\n                ;\n                    elementHidingManager.update();\n                };\n                var refreshBounds = function() {\n                    var newBounds = [popover.offset().left,popover.offset().JSBNG__top,popover.JSBNG__outerWidth(),popover.JSBNG__outerHeight(),];\n                    if (region) {\n                        region.rects[0] = newBounds;\n                    }\n                ;\n                ;\n                    if (iframe) {\n                        iframe.css({\n                            left: newBounds[0],\n                            JSBNG__top: newBounds[1],\n                            width: newBounds[2],\n                            height: newBounds[3]\n                        });\n                    }\n                ;\n                ;\n                    elementHidingManager.update();\n                };\n                var reposition = function(x, y) {\n                    if (iframe) {\n                        iframe.css({\n                            left: x,\n                            JSBNG__top: y\n                        });\n                    }\n                ;\n                ;\n                    if (region) {\n                        region.rects[0][0] = x;\n                        region.rects[0][1] = y;\n                    }\n                ;\n                ;\n                };\n                if (((options.useIFrame !== false))) {\n                    iframe = iframePool.checkout(popover);\n                }\n            ;\n            ;\n                var bounds = [[popover.offset().left,popover.offset().JSBNG__top,popover.JSBNG__outerWidth(),popover.JSBNG__outerHeight(),],];\n                if (options.additionalCursorRects) {\n                    for (var i = 0; ((i < options.additionalCursorRects.length)); i++) {\n                        bounds.push(options.additionalCursorRects[i]);\n                    };\n                ;\n                }\n            ;\n            ;\n                region = mouseTracker.add(bounds, options);\n                elementHidingManager.update();\n                popover.backing = {\n                    destroy: destroy,\n                    refreshBounds: refreshBounds,\n                    reposition: reposition,\n                    iframe: iframe\n                };\n            };\n            var defaultSettings = {\n                width: 500,\n                followScroll: false,\n                locationMargin: 4,\n                alignMargin: 0,\n                windowMargin: 4,\n                locationFitInWindow: true,\n                focusOnShow: true,\n                modal: false,\n                draggable: false,\n                zIndex: 200,\n                showOnHover: false,\n                hoverShowDelay: 400,\n                hoverHideDelay: 200,\n                skin: \"default\",\n                useIFrame: true,\n                clone: false,\n                ajaxSlideDuration: 400,\n                ajaxErrorContent: null,\n                paddingLeft: 17,\n                paddingRight: 17,\n                paddingBottom: 8\n            };\n            var overlay = null;\n            var popovers = [];\n            var et = {\n                MOUSE_ENTER: 1,\n                MOUSE_LEAVE: 2,\n                CLICK_TRIGGER: 4,\n                CLICK_OUTSIDE: 8,\n                fromStrings: function(s) {\n                    var flags = 0;\n                    var JSBNG__self = this;\n                    if (s) {\n                        $.each($.makeArray(s), function() {\n                            flags = ((flags | JSBNG__self[this]));\n                        });\n                    }\n                ;\n                ;\n                    return flags;\n                }\n            };\n            var ajaxCache = {\n            };\n            var preparedPopover = null;\n            var openGroupPopover = {\n            };\n            var skins = {\n                \"default\": ((((\"\\u003Cdiv class=\\\"ap_popover ap_popover_sprited\\\" surround=\\\"6,16,18,16\\\" tabindex=\\\"0\\\"\\u003E                     \\u003Cdiv class=\\\"ap_header\\\"\\u003E                         \\u003Cdiv class=\\\"ap_left\\\"/\\u003E                         \\u003Cdiv class=\\\"ap_middle\\\"/\\u003E                         \\u003Cdiv class=\\\"ap_right\\\"/\\u003E                     \\u003C/div\\u003E                     \\u003Cdiv class=\\\"ap_body\\\"\\u003E                         \\u003Cdiv class=\\\"ap_left\\\"/\\u003E                         \\u003Cdiv class=\\\"ap_content\\\"\\u003E\\u003Cimg src=\\\"\" + window.AmazonPopoverImages.snake)) + \"\\\"/\\u003E\\u003C/div\\u003E                         \\u003Cdiv class=\\\"ap_right\\\"/\\u003E                     \\u003C/div\\u003E                     \\u003Cdiv class=\\\"ap_footer\\\"\\u003E                         \\u003Cdiv class=\\\"ap_left\\\"/\\u003E                         \\u003Cdiv class=\\\"ap_middle\\\"/\\u003E                         \\u003Cdiv class=\\\"ap_right\\\"/\\u003E                     \\u003C/div\\u003E                     \\u003Cdiv class=\\\"ap_titlebar\\\"\\u003E                         \\u003Cdiv class=\\\"ap_title\\\"/\\u003E                     \\u003C/div\\u003E                     \\u003Cdiv class=\\\"ap_close\\\"\\u003E\\u003Ca href=\\\"#\\\"\\u003E\\u003Cspan class=\\\"ap_closetext\\\"/\\u003E\\u003Cspan class=\\\"ap_closebutton\\\"\\u003E\\u003Cspan\\u003E\\u003C/span\\u003E\\u003C/span\\u003E\\u003C/a\\u003E\\u003C/div\\u003E                 \\u003C/div\\u003E\")),\n                default_non_sprited: ((((((((\"\\u003Cdiv class=\\\"ap_popover ap_popover_unsprited\\\" surround=\\\"6,16,18,16\\\" tabindex=\\\"0\\\"\\u003E                     \\u003Cdiv class=\\\"ap_header\\\"\\u003E                         \\u003Cdiv class=\\\"ap_left\\\"/\\u003E                         \\u003Cdiv class=\\\"ap_middle\\\"/\\u003E                         \\u003Cdiv class=\\\"ap_right\\\"/\\u003E                     \\u003C/div\\u003E                     \\u003Cdiv class=\\\"ap_body\\\"\\u003E                         \\u003Cdiv class=\\\"ap_left\\\"/\\u003E                         \\u003Cdiv class=\\\"ap_content\\\"\\u003E\\u003Cimg src=\\\"\" + window.AmazonPopoverImages.snake)) + \"\\\"/\\u003E\\u003C/div\\u003E                         \\u003Cdiv class=\\\"ap_right\\\"/\\u003E                     \\u003C/div\\u003E                     \\u003Cdiv class=\\\"ap_footer\\\"\\u003E                         \\u003Cdiv class=\\\"ap_left\\\"/\\u003E                         \\u003Cdiv class=\\\"ap_middle\\\"/\\u003E                         \\u003Cdiv class=\\\"ap_right\\\"/\\u003E                     \\u003C/div\\u003E                     \\u003Cdiv class=\\\"ap_titlebar\\\"\\u003E                         \\u003Cdiv class=\\\"ap_title\\\"/\\u003E                     \\u003C/div\\u003E                     \\u003Cdiv class=\\\"ap_close\\\"\\u003E\\u003Ca href=\\\"#\\\"\\u003E\\u003Cspan class=\\\"ap_closetext\\\"/\\u003E\\u003Cimg border=\\\"0\\\" src=\\\"\")) + window.AmazonPopoverImages.btnClose)) + \"\\\"/\\u003E\\u003C/a\\u003E\\u003C/div\\u003E                 \\u003C/div\\u003E\")),\n                classic: ((((((((((((((((((((\"\\u003Cdiv class=\\\"ap_classic\\\"\\u003E                     \\u003Cdiv class=\\\"ap_titlebar\\\"\\u003E                         \\u003Cdiv class=\\\"ap_close\\\"\\u003E                             \\u003Cimg width=\\\"46\\\" height=\\\"16\\\" border=\\\"0\\\" alt=\\\"close\\\" onmouseup='this.src=\\\"\" + window.AmazonPopoverImages.closeTan)) + \"\\\";' onmouseout='this.src=\\\"\")) + window.AmazonPopoverImages.closeTan)) + \"\\\";' onmousedown='this.src=\\\"\")) + window.AmazonPopoverImages.closeTanDown)) + \"\\\";' src=\\\"\")) + window.AmazonPopoverImages.closeTan)) + \"\\\" /\\u003E                         \\u003C/div\\u003E                         \\u003Cspan class=\\\"ap_title\\\"\\u003E\\u003C/span\\u003E                     \\u003C/div\\u003E                     \\u003Cdiv class=\\\"ap_content\\\"\\u003E\\u003Cimg src=\\\"\")) + window.AmazonPopoverImages.loadingBar)) + \"\\\"/\\u003E\\u003C/div\\u003E                 \\u003C/div\\u003E\"))\n            };\n            var boundingRectangle = function(set) {\n                var b = {\n                    left: Infinity,\n                    JSBNG__top: Infinity,\n                    right: -Infinity,\n                    bottom: -Infinity\n                };\n                set.each(function() {\n                    try {\n                        var t = $(this);\n                        var o = t.offset();\n                        var w = t.JSBNG__outerWidth();\n                        var h = t.JSBNG__outerHeight();\n                        if (t.is(\"area\")) {\n                            var ab = boundsOfAreaElement(t);\n                            o = {\n                                left: ab[0],\n                                JSBNG__top: ab[1]\n                            };\n                            w = ((ab[2] - ab[0]));\n                            h = ((ab[3] - ab[1]));\n                        }\n                    ;\n                    ;\n                        if (((o.left < b.left))) {\n                            b.left = o.left;\n                        }\n                    ;\n                    ;\n                        if (((o.JSBNG__top < b.JSBNG__top))) {\n                            b.JSBNG__top = o.JSBNG__top;\n                        }\n                    ;\n                    ;\n                        if (((((o.left + w)) > b.right))) {\n                            b.right = ((o.left + w));\n                        }\n                    ;\n                    ;\n                        if (((((o.JSBNG__top + h)) > b.bottom))) {\n                            b.bottom = ((o.JSBNG__top + h));\n                        }\n                    ;\n                    ;\n                    } catch (e) {\n                    \n                    };\n                ;\n                });\n                return b;\n            };\n            var bringToFront = function(popover) {\n                if (((popovers.length <= 1))) {\n                    return;\n                }\n            ;\n            ;\n                var maxZ = Math.max.apply(Math, $.map(popovers, function(p) {\n                    return Number(p.css(\"z-index\"));\n                }));\n                if (((Number(popover.css(\"z-index\")) == maxZ))) {\n                    return;\n                }\n            ;\n            ;\n                popover.css(\"z-index\", ((maxZ + 2)));\n                ((popover.backing && popover.backing.iframe.css(\"z-index\", ((maxZ + 1)))));\n            };\n            $.fn.removeAmazonPopoverTrigger = function() {\n                this.unbind(\"click.amzPopover\");\n                this.unbind(\"mouseover.amzPopover\");\n                this.unbind(\"mouseout.amzPopover\");\n                return this;\n            };\n            $.fn.amazonPopoverTrigger = function(customSettings) {\n                var settings = $.extend({\n                }, defaultSettings, customSettings);\n                var triggers = this;\n                var popover = null;\n                if (((!settings.showOnHover && ((settings.skin == \"default\"))))) {\n                    this.bind(\"mouseover.amzPopover\", preparePopover);\n                }\n            ;\n            ;\n                if (((typeof settings.showOnHover == \"string\"))) {\n                    var hoverSet = triggers.filter(settings.showOnHover);\n                }\n                 else {\n                    var hoverSet = ((settings.showOnHover ? triggers : jQuery([])));\n                }\n            ;\n            ;\n                var timerID = null;\n                hoverSet.bind(\"mouseover.amzPopover\", function(e) {\n                    if (((!popover && !timerID))) {\n                        timerID = JSBNG__setTimeout(function() {\n                            if (!popover) {\n                                var parent = triggers.parent(), length = parent.length, tagName = ((length ? ((parent.attr(\"tagName\") || parent.get(0).tagName)) : undefined));\n                                if (((length && tagName))) {\n                                    if (((!settings.triggeringEnabled || settings.triggeringEnabled.call(triggers)))) {\n                                        popover = displayPopover(settings, triggers, function() {\n                                            popover = null;\n                                        });\n                                    }\n                                ;\n                                ;\n                                }\n                            ;\n                            ;\n                            }\n                        ;\n                        ;\n                            timerID = null;\n                        }, settings.hoverShowDelay);\n                    }\n                ;\n                ;\n                    return false;\n                });\n                hoverSet.bind(\"mouseout.amzPopover\", function(e) {\n                    if (((!popover && timerID))) {\n                        JSBNG__clearTimeout(timerID);\n                        timerID = null;\n                    }\n                ;\n                ;\n                });\n                triggers.bind(\"click.amzPopover\", function(e) {\n                    var followLink = ((((settings.followLink === true)) || ((((typeof settings.followLink == \"function\")) && settings.followLink.call(triggers, popover, settings)))));\n                    if (followLink) {\n                        return true;\n                    }\n                ;\n                ;\n                    if (popover) {\n                        popover.triggerClicked();\n                    }\n                     else {\n                        if (((!settings.triggeringEnabled || settings.triggeringEnabled.call(triggers)))) {\n                            popover = displayPopover(settings, triggers, function() {\n                                popover = null;\n                            });\n                        }\n                    ;\n                    ;\n                    }\n                ;\n                ;\n                    return false;\n                });\n                this.amznPopoverHide = function() {\n                    ((popover && popover.close()));\n                };\n                this.amznPopoverVisible = function() {\n                    return !!popover;\n                };\n                return this;\n            };\n            var updateBacking = function(group) {\n                if (((group && openGroupPopover[group]))) {\n                    var popover = openGroupPopover[group];\n                    if (popover.backing) {\n                        popover.backing.refreshBounds();\n                    }\n                ;\n                ;\n                }\n            ;\n            ;\n            };\n            var displayPopover = function(settings, triggers, destroyFunction) {\n                addAliases(settings);\n                var parent = null;\n                if (triggers) {\n                    var parents = triggers.eq(0).parents().get();\n                    for (var t = 0; ((((t < parents.length)) && !parent)); t++) {\n                        for (var i = 0; ((((i < popovers.length)) && !parent)); i++) {\n                            if (((popovers[i].get(0) == parents[t]))) {\n                                parent = popovers[i];\n                            }\n                        ;\n                        ;\n                        };\n                    ;\n                    };\n                ;\n                }\n            ;\n            ;\n                var children = [];\n                children.remove = function(p) {\n                    for (var i = 0; ((i < this.length)); i++) {\n                        if (((this[i] === p))) {\n                            this.splice(i, 1);\n                            return;\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                };\n                var interactedWith = false;\n                $.each(defaultSettings, function(k, v) {\n                    if (((typeof settings[k] == \"undefined\"))) {\n                        settings[k] = v;\n                    }\n                ;\n                ;\n                });\n                if (!settings.JSBNG__location) {\n                    settings.JSBNG__location = ((((settings.modal || !triggers)) ? \"centered\" : \"auto\"));\n                }\n            ;\n            ;\n                if (((settings.showCloseButton === null))) {\n                    settings.showCloseButton = !settings.showOnHover;\n                }\n            ;\n            ;\n                $.each(popovers, function() {\n                    settings.zIndex = Math.max(settings.zIndex, ((Number(this.css(\"z-index\")) + 2)));\n                });\n                var closeEvent = ((((settings.showOnHover ? et.MOUSE_LEAVE : et.CLICK_TRIGGER)) | ((settings.modal ? et.CLICK_OUTSIDE : 0))));\n                closeEvent = ((((closeEvent | et.fromStrings(settings.closeEventInclude))) & ~et.fromStrings(settings.closeEventExclude)));\n                var clickAwayHandler;\n                var reposition = function() {\n                    position(popover, settings, triggers);\n                };\n                var close = function() {\n                    if (settings.group) {\n                        openGroupPopover[settings.group] = null;\n                    }\n                ;\n                ;\n                    if (((original && original.parents(\"body\").length))) {\n                        if (((ballMarker && ballMarker.parents(\"body\").length))) {\n                            original.hide().insertAfter(ballMarker);\n                            ballMarker.remove();\n                            ballMarker = null;\n                        }\n                         else {\n                            original.hide().appendTo(rootElement());\n                        }\n                    ;\n                    ;\n                    }\n                ;\n                ;\n                    if (((original != popover))) {\n                        popover.remove();\n                    }\n                ;\n                ;\n                    if (parent) {\n                        parent.children.remove(popover);\n                    }\n                ;\n                ;\n                    for (var i = 0; ((i < popovers.length)); i++) {\n                        if (((popovers[i] === popover))) {\n                            popovers.splice(i, 1);\n                            break;\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    if (popover.backing) {\n                        popover.backing.destroy();\n                        popover.backing = null;\n                    }\n                ;\n                ;\n                    mouseTracker.checkNow();\n                    if (destroyFunction) {\n                        destroyFunction();\n                    }\n                ;\n                ;\n                    if (settings.onHide) {\n                        settings.onHide.call(triggers, popover, settings);\n                    }\n                ;\n                ;\n                    if (((settings.modal && overlay))) {\n                        if (overlay.fitToScreen) {\n                            $(window).unbind(\"resize\", overlay.fitToScreen);\n                        }\n                    ;\n                    ;\n                        overlay.remove();\n                        overlay = null;\n                    }\n                ;\n                ;\n                    $(JSBNG__document).unbind(\"JSBNG__scroll.AmazonPopover\");\n                    $(JSBNG__document).unbind(\"click\", clickAwayHandler);\n                    for (var i = 0; ((i < children.length)); i++) {\n                        children[i].close();\n                    };\n                ;\n                    children = [];\n                    return false;\n                };\n                var fill = function(JSBNG__content, autoshow) {\n                    var container = popover.JSBNG__find(\".ap_sub_content\");\n                    if (((container.length == 0))) {\n                        container = popover.JSBNG__find(\".ap_content\");\n                    }\n                ;\n                ;\n                    if (((typeof JSBNG__content == \"string\"))) {\n                        container.html(JSBNG__content);\n                    }\n                     else {\n                        container.empty().append(JSBNG__content);\n                    }\n                ;\n                ;\n                    if (((((typeof settings.autoshow == \"boolean\")) ? settings.autoshow : autoshow))) {\n                        if ($.browser.msie) {\n                            container.children().show().hide();\n                        }\n                    ;\n                    ;\n                        container.children(\":not(style)\").show();\n                    }\n                ;\n                ;\n                    container.JSBNG__find(\".ap_custom_close\").click(close);\n                    if (settings.onFilled) {\n                        settings.onFilled.call(triggers, popover, settings);\n                    }\n                ;\n                ;\n                    return container;\n                };\n                if (((settings.modal && !overlay))) {\n                    overlay = showOverlay(close, settings.zIndex);\n                }\n            ;\n            ;\n                var popover = null;\n                var original = null;\n                var ballMarker = null;\n                if (((settings.skin == \"default\"))) {\n                    preparePopover();\n                    popover = preparedPopover;\n                    preparedPopover = null;\n                }\n                 else {\n                    var skin = (($.isFunction(settings.skin) ? settings.skin() : settings.skin));\n                    skin = ((skin || \"\\u003Cdiv\\u003E\\u003Cdiv class='ap_content' /\\u003E\\u003C/div\\u003E\"));\n                    var skinIsHtml = /^[^<]*(<(.|\\s)+>)[^>]*$/.test(skin);\n                    var skinHtml = ((skinIsHtml ? skin : skins[skin]));\n                    popover = $(skinHtml);\n                }\n            ;\n            ;\n                if ((($.browser.msie && ((parseInt($.browser.version) == 6))))) {\n                    fixPngs(popover);\n                }\n            ;\n            ;\n                if (((settings.skin == \"default\"))) {\n                    popover.JSBNG__find(\".ap_content\").css({\n                        paddingLeft: settings.paddingLeft,\n                        paddingRight: settings.paddingRight,\n                        paddingBottom: settings.paddingBottom\n                    });\n                }\n            ;\n            ;\n                if (settings.localContent) {\n                    if (settings.clone) {\n                        fill($(settings.localContent).clone(true), true);\n                    }\n                     else {\n                        original = $(settings.localContent);\n                        ballMarker = $(\"\\u003Cspan style='display:none' /\\u003E\").insertBefore(original);\n                        fill(original, true);\n                    }\n                ;\n                ;\n                }\n                 else {\n                    if (settings.literalContent) {\n                        fill(settings.literalContent);\n                    }\n                ;\n                ;\n                }\n            ;\n            ;\n                if (settings.destination) {\n                    var destinationUrl = ((((typeof settings.destination == \"function\")) ? settings.destination() : settings.destination));\n                    if (((((settings.cacheable !== false)) && ajaxCache[destinationUrl]))) {\n                        fill(ajaxCache[destinationUrl]);\n                    }\n                     else {\n                        $.ajax({\n                            url: destinationUrl,\n                            timeout: settings.ajaxTimeout,\n                            success: function(data) {\n                                if (settings.onAjaxSuccess) {\n                                    settings.onAjaxSuccess.apply(settings, arguments);\n                                }\n                            ;\n                            ;\n                                var contentCacheable = ((data.match(/^(\\s|<!--[\\s\\S]*?-->)*<\\w+[^>]*\\s+cacheable=\"(.*?)\"/i) || data.match(/^(\\s|<!--[\\s\\S]*?-->)*<\\w+[^>]*\\s+cacheable='(.*?)'/i)));\n                                if (((((settings.cacheable !== false)) && ((!contentCacheable || ((contentCacheable[2] !== \"0\"))))))) {\n                                    ajaxCache[destinationUrl] = data;\n                                }\n                            ;\n                            ;\n                                var title = ((data.match(/^(\\s|<!--[\\s\\S]*?-->)*<\\w+[^>]*\\s+popoverTitle=\"(.*?)\"/i) || data.match(/^(\\s|<!--[\\s\\S]*?-->)*<\\w+[^>]*\\s+popoverTitle='(.*?)'/i)));\n                                if (title) {\n                                    settings.title = title[2];\n                                    popover.JSBNG__find(\".ap_title\").html(settings.title);\n                                }\n                            ;\n                            ;\n                                if (((((settings.ajaxSlideDuration > 0)) && !(($.browser.msie && ((JSBNG__document.compatMode == \"BackCompat\"))))))) {\n                                    popover.JSBNG__find(\".ap_content\").hide();\n                                    fill(data);\n                                    if (!settings.width) {\n                                        position(popover, settings, triggers);\n                                    }\n                                ;\n                                ;\n                                    if (settings.onAjaxShow) {\n                                        settings.onAjaxShow.call(triggers, popover, settings);\n                                    }\n                                ;\n                                ;\n                                    popover.JSBNG__find(\".ap_content\").slideDown(settings.ajaxSlideDuration, function() {\n                                        position(popover, settings, triggers);\n                                    });\n                                }\n                                 else {\n                                    fill(data);\n                                    if (settings.onAjaxShow) {\n                                        settings.onAjaxShow.call(triggers, popover, settings);\n                                    }\n                                ;\n                                ;\n                                    position(popover, settings, triggers);\n                                }\n                            ;\n                            ;\n                            },\n                            error: function() {\n                                var data = null;\n                                if (((typeof settings.ajaxErrorContent == \"function\"))) {\n                                    data = settings.ajaxErrorContent.apply(settings, arguments);\n                                }\n                                 else {\n                                    data = settings.ajaxErrorContent;\n                                }\n                            ;\n                            ;\n                                if (((data !== null))) {\n                                    var container = fill(data);\n                                    var title = container.children(\"[popoverTitle]\").attr(\"popoverTitle\");\n                                    if (title) {\n                                        popover.JSBNG__find(\".ap_title\").html(title);\n                                    }\n                                ;\n                                ;\n                                    position(popover, settings, triggers);\n                                }\n                            ;\n                            ;\n                            }\n                        });\n                    }\n                ;\n                ;\n                }\n            ;\n            ;\n                if (((((!settings.localContent && !settings.literalContent)) && !settings.destination))) {\n                    throw (\"AmazonPopover wasn't provided a source of content.\");\n                }\n            ;\n            ;\n                if (parent) {\n                    parent.children.push(popover);\n                }\n            ;\n            ;\n                settings.surround = jQuery.map(((popover.attr(\"surround\") || \"0,0,0,0\")).split(\",\"), function(n) {\n                    return Number(n);\n                });\n                popover.css({\n                    zIndex: settings.zIndex,\n                    position: \"absolute\",\n                    left: -2000,\n                    JSBNG__top: -2000\n                });\n                popover.click(function(e) {\n                    if (!e.metaKey) {\n                        e.stopPropagation();\n                    }\n                ;\n                ;\n                    interactedWith = true;\n                });\n                clickAwayHandler = function(e) {\n                    var leftButton = ((((e.button === 0)) || ((e.which == 1))));\n                    if (((leftButton && !e.metaKey))) {\n                        close();\n                    }\n                ;\n                ;\n                };\n                if (((closeEvent & et.CLICK_OUTSIDE))) {\n                    $(JSBNG__document).click(clickAwayHandler);\n                }\n            ;\n            ;\n                popover.mousedown(function(e) {\n                    if (!children.length) {\n                        bringToFront(popover);\n                    }\n                ;\n                ;\n                });\n                var width = ((settings.width && ((((typeof settings.width == \"function\")) ? settings.width() : settings.width))));\n                if (!width) {\n                    width = ((getDynamicWidth(popover, settings) || popover.JSBNG__outerWidth()));\n                }\n            ;\n            ;\n                if (width) {\n                    popover.css(\"width\", width);\n                }\n            ;\n            ;\n                if (settings.followScroll) {\n                    $(JSBNG__document).bind(\"JSBNG__scroll.AmazonPopover\", function(e) {\n                        followScroll(e);\n                    });\n                }\n            ;\n            ;\n                if (((((settings.title !== null)) && ((settings.title !== undefined))))) {\n                    var titleBar = popover.JSBNG__find(\".ap_titlebar\");\n                    if (((settings.skin == \"default\"))) {\n                        titleBar.css({\n                            width: ((width - 36))\n                        });\n                        titleBar.JSBNG__find(\".ap_title\").css(\"width\", ((width - 70)));\n                        popover.JSBNG__find(\".ap_content\").css({\n                            paddingTop: 18\n                        });\n                    }\n                ;\n                ;\n                    popover.JSBNG__find(\".ap_title\").html(settings.title);\n                    if (((settings.draggable && !settings.modal))) {\n                        enableDragAndDrop(titleBar, popover);\n                    }\n                ;\n                ;\n                    titleBar.show();\n                    if (((((settings.skin == \"default\")) && settings.wrapTitlebar))) {\n                        titleBar.addClass(\"multiline\");\n                        popover.JSBNG__find(\".ap_content\").css({\n                            paddingTop: ((titleBar.JSBNG__outerHeight() - 9))\n                        });\n                    }\n                ;\n                ;\n                }\n                 else {\n                    popover.JSBNG__find(\".ap_titlebar\").hide();\n                }\n            ;\n            ;\n                if (((settings.showCloseButton !== false))) {\n                    popover.JSBNG__find(\".ap_close\").show().click(close).mousedown(function(e) {\n                        e.preventDefault();\n                        e.stopPropagation();\n                        return false;\n                    }).css(\"cursor\", \"default\");\n                    if (!settings.title) {\n                        popover.JSBNG__find(\".ap_content\").css({\n                            paddingTop: 10\n                        });\n                    }\n                ;\n                ;\n                    popover.keydown(function(e) {\n                        if (((e.keyCode == 27))) {\n                            close();\n                        }\n                    ;\n                    ;\n                    });\n                }\n                 else {\n                    popover.JSBNG__find(\".ap_close\").css(\"display\", \"none\");\n                }\n            ;\n            ;\n                if (settings.closeText) {\n                    popover.JSBNG__find(\".ap_closetext\").text(settings.closeText).show();\n                }\n                 else {\n                    popover.JSBNG__find(\".ap_closebutton span\").text(\"Close\");\n                }\n            ;\n            ;\n                popover.appendTo(rootElement());\n                position(popover, settings, triggers);\n                $(JSBNG__document.activeElement).filter(\"input[type=text], select\").JSBNG__blur();\n                popover.close = close;\n                if (settings.group) {\n                    if (openGroupPopover[settings.group]) {\n                        openGroupPopover[settings.group].close();\n                    }\n                ;\n                ;\n                    openGroupPopover[settings.group] = popover;\n                }\n            ;\n            ;\n                popover.show();\n                if (settings.focusOnShow) {\n                    popover.get(0).hideFocus = true;\n                    popover.JSBNG__focus();\n                }\n            ;\n            ;\n                if (((overlay && overlay.snapToLeft))) {\n                    overlay.snapToLeft();\n                }\n            ;\n            ;\n                if (settings.onShow) {\n                    settings.onShow.call(triggers, popover, settings);\n                }\n            ;\n            ;\n                popover.bounds = [popover.offset().left,popover.offset().JSBNG__top,popover.JSBNG__outerWidth(),popover.JSBNG__outerHeight(),];\n                popovers.push(popover);\n                popover.reposition = reposition;\n                popover.close = close;\n                popover.settings = settings;\n                popover.triggerClicked = function() {\n                    if (((closeEvent & et.CLICK_TRIGGER))) {\n                        close();\n                    }\n                ;\n                ;\n                };\n                popover.children = children;\n                if (((closeEvent & et.MOUSE_LEAVE))) {\n                    var timerID = null;\n                    var triggerRects = [];\n                    $.each(triggers, function() {\n                        var n = $(this);\n                        if (n.is(\"area\")) {\n                            var b = boundsOfAreaElement(n);\n                            triggerRects.push([b[0],b[1],((b[2] - b[0])),((b[3] - b[1])),]);\n                        }\n                         else {\n                            triggerRects.push([n.offset().left,n.offset().JSBNG__top,n.JSBNG__outerWidth(),n.JSBNG__outerHeight(),]);\n                        }\n                    ;\n                    ;\n                    });\n                    if (settings.additionalCursorRects) {\n                        $(settings.additionalCursorRects).each(function() {\n                            var n = $(this);\n                            triggerRects.push([n.offset().left,n.offset().JSBNG__top,n.JSBNG__outerWidth(),n.JSBNG__outerHeight(),]);\n                        });\n                    }\n                ;\n                ;\n                    applyBacking(popover, {\n                        solidRectangle: settings.solidRectangle,\n                        useIFrame: settings.useIFrame,\n                        mouseEnter: function() {\n                            if (timerID) {\n                                JSBNG__clearTimeout(timerID);\n                                timerID = null;\n                            }\n                        ;\n                        ;\n                            return true;\n                        },\n                        mouseLeave: function(immediately) {\n                            if (((settings.semiStatic && interactedWith))) {\n                                return !children.length;\n                            }\n                        ;\n                        ;\n                            if (timerID) {\n                                JSBNG__clearTimeout(timerID);\n                                timerID = null;\n                            }\n                        ;\n                        ;\n                            if (((children.length == 0))) {\n                                if (immediately) {\n                                    close();\n                                }\n                                 else {\n                                    timerID = JSBNG__setTimeout(function() {\n                                        close();\n                                        timerID = null;\n                                    }, settings.hoverHideDelay);\n                                }\n                            ;\n                            ;\n                                return true;\n                            }\n                        ;\n                        ;\n                            return false;\n                        },\n                        additionalCursorRects: triggerRects,\n                        inside: true\n                    });\n                }\n                 else {\n                    applyBacking(popover, {\n                        solidRectangle: settings.solidRectangle,\n                        useIFrame: settings.useIFrame\n                    });\n                }\n            ;\n            ;\n                $(function() {\n                    for (var i = 0; ((i < popovers.length)); i++) {\n                        if (popovers[i].settings.modal) {\n                            popovers[i].backing.refreshBounds();\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                });\n                return popover;\n            };\n            var isMobileAgent = function(inclusive) {\n                var reAry = [\"iPhone\",\"iPad\",];\n                if (inclusive) {\n                    reAry.push(\"Silk/\", \"Kindle Fire\", \"Android\", \"\\\\bTouch\\\\b\");\n                }\n            ;\n            ;\n                var reStr = ((((\"(\" + reAry.join(\"|\"))) + \")\"));\n                return JSBNG__navigator.userAgent.match(new RegExp(reStr, \"i\"));\n            };\n            var getPageWidth = function() {\n                return (($.browser.msie ? $(window).width() : \"100%\"));\n            };\n            var getPageHeight = function() {\n                return (((($.browser.msie || isMobileAgent())) ? $(JSBNG__document).height() : \"100%\"));\n            };\n            var showOverlay = function(closeFunction, z) {\n                var overlay = $(\"\\u003Cdiv id=\\\"ap_overlay\\\"/\\u003E\");\n                if ($.browser.msie) {\n                    overlay.fitToScreen = function(e) {\n                        var windowHeight = $(JSBNG__document).height();\n                        var windowWidth = $(window).width();\n                        var children = overlay.children();\n                        overlay.css({\n                            width: windowWidth,\n                            height: windowHeight,\n                            backgroundColor: \"transparent\",\n                            zIndex: z\n                        });\n                        var appendElements = [];\n                        for (var i = 0; ((((i < children.size())) || ((((windowHeight - ((i * 2000)))) > 0)))); i++) {\n                            var paneHeight = Math.min(((windowHeight - ((i * 2000)))), 2000);\n                            if (((paneHeight > 0))) {\n                                if (((i < children.size()))) {\n                                    children.eq(i).css({\n                                        width: windowWidth,\n                                        height: paneHeight\n                                    });\n                                }\n                                 else {\n                                    var slice = $(\"\\u003Cdiv/\\u003E\").css({\n                                        opacity: 95378,\n                                        zIndex: z,\n                                        width: windowWidth,\n                                        height: paneHeight,\n                                        JSBNG__top: ((i * 2000))\n                                    });\n                                    appendElements.push(slice[0]);\n                                }\n                            ;\n                            ;\n                            }\n                             else {\n                                children.eq(i).remove();\n                            }\n                        ;\n                        ;\n                        };\n                    ;\n                        if (appendElements.length) {\n                            overlay.append(appendElements);\n                        }\n                    ;\n                    ;\n                    };\n                    overlay.snapToLeft = function() {\n                        overlay.css(\"left\", jQuery(JSBNG__document).scrollLeft());\n                    };\n                    $(window).bind(\"resize load\", overlay.fitToScreen);\n                    $(window).JSBNG__scroll(overlay.snapToLeft);\n                    overlay.snapToLeft();\n                    overlay.fitToScreen();\n                }\n                 else {\n                    overlay.css({\n                        width: getPageWidth(),\n                        height: getPageHeight(),\n                        position: (((($.browser.mozilla || $.browser.safari)) ? \"fixed\" : \"\")),\n                        opacity: 95917,\n                        zIndex: z\n                    });\n                }\n            ;\n            ;\n                return overlay.appendTo(rootElement());\n            };\n            var HEADER_HEIGHT = 45;\n            var FOOTER_HEIGHT = 35;\n            var VERT_ARROW_OFFSET = 327;\n            var LEFT_ARROW_OFFSET = 0;\n            var RIGHT_ARROW_OFFSET = -51;\n            var attachedPositioning = function(popover, targetY, JSBNG__location, position, offset) {\n                if (popover.hasClass(\"ap_popover_sprited\")) {\n                    var dist = ((((targetY - JSBNG__location.JSBNG__top)) - offset[1]));\n                    if (((dist < HEADER_HEIGHT))) {\n                        dist = HEADER_HEIGHT;\n                    }\n                     else {\n                        if (((dist > ((popover.JSBNG__outerHeight() - FOOTER_HEIGHT))))) {\n                            dist = ((popover.JSBNG__outerHeight() - FOOTER_HEIGHT));\n                        }\n                    ;\n                    ;\n                    }\n                ;\n                ;\n                    var attachingSide = ((((position == \"left\")) ? \"right\" : \"left\"));\n                    var elm = popover.JSBNG__find(((\".ap_body .ap_\" + attachingSide)));\n                    if (((elm.length > 0))) {\n                        elm.removeClass(((\"ap_\" + attachingSide))).addClass(((((\"ap_\" + attachingSide)) + \"-arrow\")));\n                    }\n                     else {\n                        elm = popover.JSBNG__find(((((\".ap_body .ap_\" + attachingSide)) + \"-arrow\")));\n                    }\n                ;\n                ;\n                    var xOffset = ((((attachingSide == \"left\")) ? LEFT_ARROW_OFFSET : RIGHT_ARROW_OFFSET));\n                    elm.css(\"backgroundPosition\", ((((((xOffset + \"px \")) + ((dist - VERT_ARROW_OFFSET)))) + \"px\")));\n                }\n            ;\n            ;\n            };\n            var position = function(popover, settings, triggers) {\n                if (!settings.width) {\n                    popover.css(\"width\", getDynamicWidth(popover, settings));\n                }\n            ;\n            ;\n                var offset = ((settings.locationOffset || [0,0,]));\n                if (((typeof settings.JSBNG__location == \"function\"))) {\n                    var JSBNG__location = settings.JSBNG__location.call(triggers, popover, settings);\n                }\n                 else {\n                    var names = $.map($.makeArray(settings.JSBNG__location), function(n) {\n                        return ((((n == \"auto\")) ? [\"bottom\",\"left\",\"right\",\"JSBNG__top\",] : n));\n                    });\n                    var set = ((((settings.locationElement && $(settings.locationElement))) || triggers));\n                    var b = ((set && boundingRectangle(set)));\n                    var JSBNG__location = locationFunction[names[0]](b, popover, settings);\n                    var index = 0;\n                    for (var i = 1; ((((i < names.length)) && !JSBNG__location.fits)); i++) {\n                        var next = locationFunction[names[i]](b, popover, settings);\n                        if (next.fits) {\n                            JSBNG__location = next;\n                            index = i;\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    if (((settings.attached && ((((names[index] == \"left\")) || ((names[index] == \"right\"))))))) {\n                        attachedPositioning(popover, ((((b.JSBNG__top + b.bottom)) / 2)), JSBNG__location, names[index], offset);\n                    }\n                ;\n                ;\n                }\n            ;\n            ;\n                popover.css({\n                    left: ((JSBNG__location.left + offset[0])),\n                    JSBNG__top: ((JSBNG__location.JSBNG__top + offset[1])),\n                    margin: JSBNG__location.margin,\n                    right: JSBNG__location.right\n                });\n                if (popover.backing) {\n                    popover.backing.refreshBounds();\n                }\n            ;\n            ;\n            };\n            var horizPosition = function(b, popover, settings) {\n                var align = $.makeArray(((settings.align || \"left\")));\n                var x = {\n                    min: (((($(JSBNG__document).scrollLeft() + settings.windowMargin)) - settings.surround[3])),\n                    max: ((((((viewport.width() + $(JSBNG__document).scrollLeft())) - settings.windowMargin)) - popover.JSBNG__outerWidth())),\n                    left: ((((b.left - settings.surround[3])) - settings.alignMargin)),\n                    right: ((((((b.right - popover.JSBNG__outerWidth())) + settings.surround[1])) + settings.alignMargin)),\n                    center: ((((((b.left + b.right)) - popover.JSBNG__outerWidth())) / 2))\n                };\n                var align = $.grep($.makeArray(settings.align), function(n) {\n                    return x[n];\n                });\n                if (((align.length == 0))) {\n                    align.push(\"left\");\n                }\n            ;\n            ;\n                for (var i = 0; ((i < align.length)); i++) {\n                    if (((((x[align[i]] >= x.min)) && ((x[align[i]] <= x.max))))) {\n                        return x[align[i]];\n                    }\n                ;\n                ;\n                };\n            ;\n                if (settings.forceAlignment) {\n                    return x[align[0]];\n                }\n            ;\n            ;\n                if (((x.min > x.max))) {\n                    return x.min;\n                }\n            ;\n            ;\n                return ((((x[align[0]] < x.min)) ? x.min : x.max));\n            };\n            var vertPosition = function(b, popover, settings) {\n                var min = (($(JSBNG__document).scrollTop() + settings.windowMargin));\n                var max = ((((viewport.height() + $(JSBNG__document).scrollTop())) - settings.windowMargin));\n                if (settings.attached) {\n                    var midpoint = ((((b.JSBNG__top + b.bottom)) / 2));\n                    if (((((midpoint - HEADER_HEIGHT)) < min))) {\n                        min = ((((((min + HEADER_HEIGHT)) < b.bottom)) ? min : ((b.bottom - HEADER_HEIGHT))));\n                    }\n                ;\n                ;\n                    if (((((midpoint + FOOTER_HEIGHT)) > max))) {\n                        max = ((((((max - FOOTER_HEIGHT)) > b.JSBNG__top)) ? max : ((b.JSBNG__top + FOOTER_HEIGHT))));\n                    }\n                ;\n                ;\n                }\n                 else {\n                    min = Math.min(((b.JSBNG__top - settings.alignMargin)), min);\n                    max = Math.max(((b.bottom + settings.alignMargin)), max);\n                }\n            ;\n            ;\n                var y = {\n                    min: ((min - settings.surround[0])),\n                    max: ((((max - popover.JSBNG__outerHeight())) + settings.surround[2])),\n                    JSBNG__top: ((((b.JSBNG__top - settings.surround[0])) - settings.alignMargin)),\n                    bottom: ((((((b.bottom - popover.JSBNG__outerHeight())) + settings.alignMargin)) + settings.surround[2])),\n                    middle: ((((((b.JSBNG__top + b.bottom)) - popover.JSBNG__outerHeight())) / 2))\n                };\n                var align = $.grep($.makeArray(settings.align), function(n) {\n                    return y[n];\n                });\n                if (((align.length == 0))) {\n                    align.push(\"JSBNG__top\");\n                }\n            ;\n            ;\n                for (var i = 0; ((i < align.length)); i++) {\n                    if (((((y[align[i]] >= y.min)) && ((y[align[i]] <= y.max))))) {\n                        return y[align[i]];\n                    }\n                ;\n                ;\n                };\n            ;\n                if (settings.forceAlignment) {\n                    return y[align[0]];\n                }\n            ;\n            ;\n                if (((y.min > y.max))) {\n                    return y.min;\n                }\n            ;\n            ;\n                return ((((y[align[0]] < y.min)) ? y.min : y.max));\n            };\n            var locationFunction = {\n                centered: function(b, popover, settings) {\n                    var y = (($(window).scrollTop() + 100));\n                    return {\n                        left: -((popover.JSBNG__outerWidth() / 2)),\n                        right: 0,\n                        JSBNG__top: y,\n                        margin: \"0% 50%\",\n                        fits: true\n                    };\n                },\n                JSBNG__top: function(b, popover, settings) {\n                    var room = ((((b.JSBNG__top - $(JSBNG__document).scrollTop())) - ((settings.locationMargin * 2))));\n                    var triggerInView = ((((b.left >= $(JSBNG__document).scrollLeft())) && ((b.right < ((viewport.width() + $(JSBNG__document).scrollLeft()))))));\n                    return {\n                        left: horizPosition(b, popover, settings),\n                        JSBNG__top: ((((((b.JSBNG__top - popover.JSBNG__outerHeight())) - settings.locationMargin)) + settings.surround[2])),\n                        fits: ((triggerInView && ((room >= ((((popover.JSBNG__outerHeight() - settings.surround[0])) - settings.surround[2]))))))\n                    };\n                },\n                left: function(b, popover, settings) {\n                    var room = ((((b.left - $(JSBNG__document).scrollLeft())) - ((settings.locationMargin * 2))));\n                    return {\n                        left: ((((((b.left - popover.JSBNG__outerWidth())) - settings.locationMargin)) + settings.surround[1])),\n                        JSBNG__top: vertPosition(b, popover, settings),\n                        fits: ((room >= ((((popover.JSBNG__outerWidth() - settings.surround[1])) - settings.surround[3]))))\n                    };\n                },\n                bottom: function(b, popover, settings) {\n                    var room = ((((((viewport.height() + $(JSBNG__document).scrollTop())) - b.bottom)) - ((settings.locationMargin * 2))));\n                    var triggerInView = ((((b.left >= $(JSBNG__document).scrollLeft())) && ((b.right < ((viewport.width() + $(JSBNG__document).scrollLeft()))))));\n                    return {\n                        left: horizPosition(b, popover, settings),\n                        JSBNG__top: ((((b.bottom + settings.locationMargin)) - settings.surround[0])),\n                        fits: ((triggerInView && ((room >= ((((popover.JSBNG__outerHeight() - settings.surround[0])) - settings.surround[2]))))))\n                    };\n                },\n                right: function(b, popover, settings) {\n                    var room = ((((((viewport.width() + $(JSBNG__document).scrollLeft())) - b.right)) - ((settings.locationMargin * 2))));\n                    return {\n                        left: ((((b.right + settings.locationMargin)) - settings.surround[3])),\n                        JSBNG__top: vertPosition(b, popover, settings),\n                        fits: ((room >= ((((popover.JSBNG__outerWidth() - settings.surround[1])) - settings.surround[3]))))\n                    };\n                },\n                over: function(b, popover, settings) {\n                    var alignTo = popover.JSBNG__find(((settings.align || \".ap_content *\"))).offset();\n                    var corner = popover.offset();\n                    var padding = {\n                        left: ((alignTo.left - corner.left)),\n                        JSBNG__top: ((alignTo.JSBNG__top - corner.JSBNG__top))\n                    };\n                    var left = ((b.left - padding.left));\n                    var JSBNG__top = ((b.JSBNG__top - padding.JSBNG__top));\n                    var adjustedLeft = Math.min(left, ((((((viewport.width() + $(JSBNG__document).scrollLeft())) - popover.JSBNG__outerWidth())) - settings.windowMargin)));\n                    adjustedLeft = Math.max(adjustedLeft, (((($(JSBNG__document).scrollLeft() - settings.surround[3])) + settings.windowMargin)));\n                    var adjustedTop = Math.min(JSBNG__top, ((((((((viewport.height() + $(JSBNG__document).scrollTop())) - popover.JSBNG__outerHeight())) + settings.surround[2])) - settings.windowMargin)));\n                    adjustedTop = Math.max(adjustedTop, (((($(JSBNG__document).scrollTop() - settings.surround[0])) + settings.windowMargin)));\n                    return {\n                        left: ((settings.forceAlignment ? left : adjustedLeft)),\n                        JSBNG__top: ((settings.forceAlignment ? JSBNG__top : adjustedTop)),\n                        fits: ((((left == adjustedLeft)) && ((JSBNG__top == adjustedTop))))\n                    };\n                }\n            };\n            var addAliases = function(settings) {\n                settings.align = ((settings.align || settings.locationAlign));\n                settings.literalContent = ((settings.literalContent || settings.loadingContent));\n            };\n            var preparePopover = function() {\n                if (!preparedPopover) {\n                    var ie6 = ((jQuery.browser.msie && ((parseInt(jQuery.browser.version) <= 6))));\n                    preparedPopover = $(skins[((ie6 ? \"default_non_sprited\" : \"default\"))]).css({\n                        left: -2000,\n                        JSBNG__top: -2000\n                    }).appendTo(rootElement());\n                }\n            ;\n            ;\n            };\n            var fixPngs = function(obj) {\n                obj.JSBNG__find(\"*\").each(function() {\n                    var match = ((jQuery(this).css(\"background-image\") || \"\")).match(/url\\(\"(.*\\.png)\"\\)/);\n                    if (match) {\n                        var png = match[1];\n                        jQuery(this).css(\"background-image\", \"none\");\n                        jQuery(this).get(0).runtimeStyle.filter = ((((\"progid:DXImageTransform.Microsoft.AlphaImageLoader(src='\" + png)) + \"',sizingMethod='scale')\"));\n                    }\n                ;\n                ;\n                });\n            };\n            var getDynamicWidth = function(popover, settings) {\n                var container = popover.JSBNG__find(\".ap_content\");\n                if (((((settings.skin == \"default\")) && ((container.length > 0))))) {\n                    var tempNode = $(((((\"\\u003Cdiv class=\\\"ap_temp\\\"\\u003E\" + container.html())) + \"\\u003C/div\\u003E\")));\n                    tempNode.css({\n                        display: \"inline\",\n                        position: \"absolute\",\n                        JSBNG__top: -9999,\n                        left: -9999\n                    });\n                    rootElement().append(tempNode);\n                    var marginLeft = ((parseInt(container.parent().css(\"margin-left\")) || 0));\n                    var marginRight = ((parseInt(container.parent().css(\"margin-right\")) || 0));\n                    var width = ((((((((((tempNode.width() + marginLeft)) + marginRight)) + settings.paddingLeft)) + settings.paddingRight)) + 2));\n                    if (((((width % 2)) != 0))) {\n                        width++;\n                    }\n                ;\n                ;\n                    tempNode.remove();\n                    return Math.min(width, viewport.width());\n                }\n            ;\n            ;\n                return null;\n            };\n            var enableDragAndDrop = function(titlebar, popover) {\n                titlebar.css(\"cursor\", \"move\");\n                disableSelect(titlebar.get(0));\n                titlebar.mousedown(function(e) {\n                    e.preventDefault();\n                    disableSelect(JSBNG__document.body);\n                    var offset = [((e.pageX - popover.offset().left)),((e.pageY - popover.offset().JSBNG__top)),];\n                    var mousemove = function(e) {\n                        e.preventDefault();\n                        popover.css({\n                            left: ((e.pageX - offset[0])),\n                            JSBNG__top: ((e.pageY - offset[1])),\n                            margin: 0\n                        });\n                        if (popover.backing) {\n                            popover.backing.reposition(((e.pageX - offset[0])), ((e.pageY - offset[1])));\n                        }\n                    ;\n                    ;\n                    };\n                    var mouseup = function(e) {\n                        popover.JSBNG__focus();\n                        enableSelect(JSBNG__document.body);\n                        $(JSBNG__document).unbind(\"mousemove\", mousemove);\n                        $(JSBNG__document).unbind(\"mouseup\", mouseup);\n                    };\n                    $(JSBNG__document).mousemove(mousemove).mouseup(mouseup);\n                });\n            };\n            var disableSelect = function(e) {\n                if (e) {\n                    e.onselectstart = function(e) {\n                        return false;\n                    };\n                    e.style.MozUserSelect = \"none\";\n                }\n            ;\n            ;\n            };\n            var enableSelect = function(e) {\n                if (e) {\n                    e.onselectstart = function(e) {\n                        return true;\n                    };\n                    e.style.MozUserSelect = \"\";\n                }\n            ;\n            ;\n            };\n            var boundsOfAreaElement = function(area) {\n                area = jQuery(area);\n                var coords = jQuery.map(area.attr(\"coords\").split(\",\"), function(n) {\n                    return Number(n);\n                });\n                if (area.attr(\"shape\").match(/circle/i)) {\n                    coords = [((coords[0] - coords[2])),((coords[1] - coords[2])),((coords[0] + coords[2])),((coords[1] + coords[2])),];\n                }\n            ;\n            ;\n                var x = [], y = [];\n                for (var i = 0; ((i < coords.length)); i++) {\n                    ((((((i % 2)) == 0)) ? x : y)).push(coords[i]);\n                };\n            ;\n                var min = [Math.min.apply(Math, x),Math.min.apply(Math, y),];\n                var max = [Math.max.apply(Math, x),Math.max.apply(Math, y),];\n                var mapName = area.parents(\"map\").attr(\"JSBNG__name\");\n                var mapImg = jQuery(((((\"img[usemap=#\" + mapName)) + \"]\")));\n                var map = mapImg.offset();\n                map.left += parseInt(mapImg.css(\"border-left-width\"));\n                map.JSBNG__top += parseInt(mapImg.css(\"border-top-width\"));\n                return [((map.left + min[0])),((map.JSBNG__top + min[1])),((map.left + max[0])),((map.JSBNG__top + max[1])),];\n            };\n            $.AmazonPopover = {\n                displayPopover: displayPopover,\n                mouseTracker: mouseTracker,\n                updateBacking: updateBacking,\n                support: {\n                    skinCallback: true,\n                    controlCallbacks: true\n                }\n            };\n        };\n    ;\n    })();\n    (function(window) {\n        if (((window.$Nav && !window.$Nav._replay))) {\n            return;\n        }\n    ;\n    ;\n        function argArray(args) {\n            return [].slice.call(args);\n        };\n    ;\n        var timestamp = ((JSBNG__Date.now || function() {\n            return +(new JSBNG__Date());\n        }));\n        var schedule = (function() {\n            var toRun = [];\n            var scheduled;\n            function execute() {\n                var i = 0;\n                try {\n                    while (((toRun[i] && ((i < 50))))) {\n                        i++;\n                        toRun[((i - 1))].f.apply(window, toRun[((i - 1))].a);\n                    };\n                ;\n                } catch (e) {\n                    var ePrefixed = e;\n                    var msg = \"\";\n                    if (toRun[((i - 1))].t) {\n                        msg = ((((\"[\" + toRun[((i - 1))].t.join(\":\"))) + \"] \"));\n                    }\n                ;\n                ;\n                    if (((ePrefixed && ePrefixed.message))) {\n                        ePrefixed.message = ((msg + ePrefixed.message));\n                    }\n                     else {\n                        if (((typeof e === \"object\"))) {\n                            ePrefixed.message = msg;\n                        }\n                         else {\n                            ePrefixed = ((msg + ePrefixed));\n                        }\n                    ;\n                    ;\n                    }\n                ;\n                ;\n                    if (((((window.ueLogError && window.JSBNG__console)) && window.JSBNG__console.error))) {\n                        window.ueLogError(ePrefixed);\n                        window.JSBNG__console.error(ePrefixed);\n                    }\n                     else {\n                        throw ePrefixed;\n                    }\n                ;\n                ;\n                } finally {\n                    toRun = toRun.slice(i);\n                    if (((toRun.length > 0))) {\n                        JSBNG__setTimeout(execute, 1);\n                    }\n                     else {\n                        scheduled = false;\n                    }\n                ;\n                ;\n                };\n            ;\n            };\n        ;\n            return function(tags, func, args) {\n                toRun.push({\n                    t: tags,\n                    f: func,\n                    a: argArray(((args || [])))\n                });\n                if (!scheduled) {\n                    JSBNG__setTimeout(execute, 1);\n                    scheduled = true;\n                }\n            ;\n            ;\n            };\n        }());\n        function ensureFunction(value) {\n            if (((typeof value === \"function\"))) {\n                return value;\n            }\n             else {\n                return function() {\n                    return value;\n                };\n            }\n        ;\n        ;\n        };\n    ;\n        function extract(base, path) {\n            var parts = ((path || \"\")).split(\".\");\n            for (var i = 0, len = parts.length; ((i < len)); i++) {\n                if (((base && parts[i]))) {\n                    base = base[parts[i]];\n                }\n            ;\n            ;\n            };\n        ;\n            return base;\n        };\n    ;\n        function withRetry(callback) {\n            var timeout = 50;\n            var execute = function() {\n                if (((((timeout <= 20000)) && !callback()))) {\n                    JSBNG__setTimeout(execute, timeout);\n                    timeout = ((timeout * 2));\n                }\n            ;\n            ;\n            };\n            return execute;\n        };\n    ;\n        function isAuiP() {\n            return ((((((((typeof window.P === \"object\")) && ((typeof window.P.when === \"function\")))) && ((typeof window.P.register === \"function\")))) && ((typeof window.P.execute === \"function\"))));\n        };\n    ;\n        function promise() {\n            var observers = [];\n            var fired = false;\n            var value;\n            var trigger = function() {\n                if (fired) {\n                    return;\n                }\n            ;\n            ;\n                fired = true;\n                value = arguments;\n                for (var i = 0, len = observers.length; ((i < len)); i++) {\n                    schedule(observers[i].t, observers[i].f, value);\n                };\n            ;\n                observers = void (0);\n            };\n            trigger.watch = function(tags, callback) {\n                if (!callback) {\n                    callback = tags;\n                    tags = [];\n                }\n            ;\n            ;\n                if (fired) {\n                    schedule(tags, callback, value);\n                }\n                 else {\n                    observers.push({\n                        t: tags,\n                        f: callback\n                    });\n                }\n            ;\n            ;\n            };\n            trigger.isFired = function() {\n                return fired;\n            };\n            trigger.value = function() {\n                return ((value || []));\n            };\n            return trigger;\n        };\n    ;\n        function promiseMap() {\n            var promises = {\n            };\n            var getPromise = function(key) {\n                return ((promises[key] || (promises[key] = promise())));\n            };\n            getPromise.whenAvailable = function(tags, dependencies) {\n                var onComplete = promise();\n                var length = dependencies.length;\n                if (((length === 0))) {\n                    onComplete();\n                    return onComplete.watch;\n                }\n            ;\n            ;\n                var fulfilled = 0;\n                var observer = function() {\n                    fulfilled++;\n                    if (((fulfilled < length))) {\n                        return;\n                    }\n                ;\n                ;\n                    var args = [];\n                    for (var i = 0; ((i < length)); i++) {\n                        args.push(getPromise(dependencies[i]).value()[0]);\n                    };\n                ;\n                    onComplete.apply(window, args);\n                };\n                for (var i = 0; ((i < length)); i++) {\n                    getPromise(dependencies[i]).watch(tags, observer);\n                };\n            ;\n                return onComplete.watch;\n            };\n            return getPromise;\n        };\n    ;\n        function depend(options) {\n            options = ((options || {\n                bubble: false\n            }));\n            var components = promiseMap();\n            var anonymousCount = 0;\n            var debug = {\n            };\n            var iface = {\n            };\n            iface.declare = function(JSBNG__name, component) {\n                if (!debug[JSBNG__name]) {\n                    debug[JSBNG__name] = {\n                        done: timestamp()\n                    };\n                }\n            ;\n            ;\n                components(JSBNG__name)(component);\n            };\n            iface.build = function(JSBNG__name, builder) {\n                schedule([options.sourceName,JSBNG__name,], function() {\n                    iface.declare(JSBNG__name, ensureFunction(builder)());\n                });\n            };\n            iface.getNow = function(JSBNG__name, otherwise) {\n                return ((components(JSBNG__name).value()[0] || otherwise));\n            };\n            iface.publish = function(JSBNG__name, component) {\n                iface.declare(JSBNG__name, component);\n                var parent = options.parent;\n                if (options.prefix) {\n                    JSBNG__name = ((((options.prefix + \".\")) + JSBNG__name));\n                }\n            ;\n            ;\n                if (((parent === (void 0)))) {\n                    if (window.amznJQ) {\n                        window.amznJQ.declareAvailable(JSBNG__name);\n                    }\n                ;\n                ;\n                    if (isAuiP()) {\n                        window.P.register(JSBNG__name, function() {\n                            return component;\n                        });\n                    }\n                ;\n                ;\n                }\n                 else {\n                    if (((options.bubble && parent.publish))) {\n                        parent.publish(JSBNG__name, component);\n                    }\n                     else {\n                        if (parent.declare) {\n                            parent.declare(JSBNG__name, component);\n                        }\n                    ;\n                    ;\n                    }\n                ;\n                ;\n                }\n            ;\n            ;\n            };\n            iface.importEvent = function(JSBNG__name, opts) {\n                var parent = options.parent;\n                opts = ((opts || {\n                }));\n                var importAs = ((opts.as || JSBNG__name));\n                var whenReady = function(value) {\n                    iface.declare(importAs, ((((((value === (void 0))) || ((value === null)))) ? opts.otherwise : value)));\n                };\n                if (((((((parent && parent.when)) && parent.declare)) && parent.build))) {\n                    parent.when(JSBNG__name).run(whenReady);\n                    return;\n                }\n            ;\n            ;\n                if (isAuiP()) {\n                    window.P.when(JSBNG__name).execute(whenReady);\n                }\n            ;\n            ;\n                if (window.amznJQ) {\n                    var meth = ((options.useOnCompletion ? \"onCompletion\" : \"available\"));\n                    window.amznJQ[meth](((opts.amznJQ || JSBNG__name)), withRetry(function() {\n                        var value = ((opts.global ? extract(window, opts.global) : opts.otherwise));\n                        var isUndef = ((((value === (void 0))) || ((value === null))));\n                        if (((opts.retry && isUndef))) {\n                            return false;\n                        }\n                    ;\n                    ;\n                        iface.declare(importAs, value);\n                        return true;\n                    }));\n                }\n            ;\n            ;\n            };\n            iface.stats = function(unresolved) {\n                var result = JSON.parse(JSON.stringify(debug));\n                {\n                    var fin29keys = ((window.top.JSBNG_Replay.forInKeys)((result))), fin29i = (0);\n                    var key;\n                    for (; (fin29i < fin29keys.length); (fin29i++)) {\n                        ((key) = (fin29keys[fin29i]));\n                        {\n                            if (result.hasOwnProperty(key)) {\n                                var current = result[key];\n                                var depend = ((current.depend || []));\n                                var longPoleName;\n                                var longPoleDone = 0;\n                                var blocked = [];\n                                for (var i = 0; ((i < depend.length)); i++) {\n                                    var dependency = depend[i];\n                                    if (!components(dependency).isFired()) {\n                                        blocked.push(dependency);\n                                    }\n                                     else {\n                                        if (((debug[dependency].done > longPoleDone))) {\n                                            longPoleDone = debug[dependency].done;\n                                            longPoleName = dependency;\n                                        }\n                                    ;\n                                    ;\n                                    }\n                                ;\n                                ;\n                                };\n                            ;\n                                if (((blocked.length > 0))) {\n                                    current.blocked = blocked;\n                                }\n                                 else {\n                                    if (unresolved) {\n                                        delete result[key];\n                                    }\n                                     else {\n                                        if (((longPoleDone > 0))) {\n                                            current.longPole = longPoleName;\n                                            current.afterLongPole = ((current.done - longPoleDone));\n                                        }\n                                    ;\n                                    ;\n                                    }\n                                ;\n                                ;\n                                }\n                            ;\n                            ;\n                            }\n                        ;\n                        ;\n                        };\n                    };\n                };\n            ;\n                return result;\n            };\n            iface.when = function() {\n                var dependencies = argArray(arguments);\n                function onResolved(JSBNG__name, callback) {\n                    var start = timestamp();\n                    var tags = [options.sourceName,JSBNG__name,];\n                    debug[JSBNG__name] = {\n                        depend: dependencies,\n                        registered: start\n                    };\n                    components.whenAvailable(tags, dependencies)(tags, function() {\n                        debug[JSBNG__name].done = timestamp();\n                        debug[JSBNG__name].wait = ((debug[JSBNG__name].done - start));\n                        callback.apply(this, argArray(arguments));\n                    });\n                };\n            ;\n                return {\n                    run: function(nameOrCallback, callbackWhenNamed) {\n                        if (callbackWhenNamed) {\n                            nameOrCallback = ((\"run.\" + nameOrCallback));\n                        }\n                         else {\n                            callbackWhenNamed = nameOrCallback;\n                            nameOrCallback = ((\"run.#\" + anonymousCount++));\n                        }\n                    ;\n                    ;\n                        onResolved(nameOrCallback, callbackWhenNamed);\n                    },\n                    declare: function(JSBNG__name, value) {\n                        onResolved(JSBNG__name, function() {\n                            iface.declare(JSBNG__name, value);\n                        });\n                    },\n                    publish: function(JSBNG__name, value) {\n                        onResolved(JSBNG__name, function() {\n                            iface.publish(JSBNG__name, value);\n                        });\n                    },\n                    build: function(JSBNG__name, builder) {\n                        onResolved(JSBNG__name, function() {\n                            var args = argArray(arguments);\n                            var value = ensureFunction(builder).apply(this, args);\n                            iface.declare(JSBNG__name, value);\n                        });\n                    }\n                };\n            };\n            return iface;\n        };\n    ;\n        function make(sourceName) {\n            sourceName = ((sourceName || \"unknownSource\"));\n            var instance = depend({\n                sourceName: sourceName\n            });\n            instance.declare(\"instance.sourceName\", sourceName);\n            instance.importEvent(\"jQuery\", {\n                as: \"$\",\n                global: \"jQuery\"\n            });\n            instance.importEvent(\"jQuery\", {\n                global: \"jQuery\"\n            });\n            instance.importEvent(\"amznJQ.AboveTheFold\", {\n                as: \"page.ATF\",\n                useOnCompletion: true\n            });\n            instance.importEvent(\"amznJQ.theFold\", {\n                as: \"page.ATF\",\n                useOnCompletion: true\n            });\n            instance.importEvent(\"amznJQ.criticalFeature\", {\n                as: \"page.CF\",\n                useOnCompletion: true\n            });\n            instance.when(\"$\").run(function($) {\n                var triggerLoaded = function() {\n                    instance.declare(\"page.domReady\");\n                    instance.declare(\"page.ATF\");\n                    instance.declare(\"page.CF\");\n                    instance.declare(\"page.loaded\");\n                };\n                $(function() {\n                    instance.declare(\"page.domReady\");\n                });\n                $(window).load(triggerLoaded);\n                if (((JSBNG__document.readyState === \"complete\"))) {\n                    triggerLoaded();\n                }\n                 else {\n                    if (((JSBNG__document.readyState === \"interactive\"))) {\n                        instance.declare(\"page.domReady\");\n                    }\n                ;\n                ;\n                }\n            ;\n            ;\n            });\n            return instance;\n        };\n    ;\n        function callChain(obj, methods) {\n            for (var i = 0, len = methods.length; ((i < len)); i++) {\n                var invoke = methods[i];\n                if (!obj[invoke.m]) {\n                    return;\n                }\n            ;\n            ;\n                obj = obj[invoke.m].apply(obj, invoke.a);\n            };\n        ;\n        };\n    ;\n        function replaceShim(shim) {\n            var replacement = make(shim._sourceName);\n            if (!shim._replay) {\n                return;\n            }\n        ;\n        ;\n            for (var i = 0, iLen = shim._replay.length; ((i < iLen)); i++) {\n                callChain(replacement, shim._replay[i]);\n            };\n        ;\n            {\n                var fin30keys = ((window.top.JSBNG_Replay.forInKeys)((replacement))), fin30i = (0);\n                var method;\n                for (; (fin30i < fin30keys.length); (fin30i++)) {\n                    ((method) = (fin30keys[fin30i]));\n                    {\n                        if (replacement.hasOwnProperty(method)) {\n                            shim[method] = replacement[method];\n                        }\n                    ;\n                    ;\n                    };\n                };\n            };\n        ;\n            delete shim._replay;\n        };\n    ;\n        function hookup() {\n            if (!window.$Nav.make) {\n                window.$Nav.make = make;\n                return;\n            }\n        ;\n        ;\n            if (!window.$Nav.make._shims) {\n                return;\n            }\n        ;\n        ;\n            for (var i = 0, len = window.$Nav.make._shims.length; ((i < len)); i++) {\n                replaceShim(window.$Nav.make._shims[i]);\n            };\n        ;\n            window.$Nav.make = make;\n        };\n    ;\n        if (!window.$Nav) {\n            window.$Nav = make(\"rcx-nav\");\n        }\n    ;\n    ;\n        hookup();\n        window.$Nav.declare(\"depend\", depend);\n        window.$Nav.declare(\"promise\", promise);\n        window.$Nav.declare(\"argArray\", argArray);\n        window.$Nav.declare(\"schedule\", schedule);\n    }(window));\n    (function(window, $Nav) {\n        $Nav.when(\"$\").run(function($) {\n            $Nav.importEvent(\"legacy-popover\", {\n                as: \"$popover\",\n                amznJQ: \"popover\",\n                otherwise: $\n            });\n        });\n        $Nav.importEvent(\"iss\", {\n            amznJQ: \"search-js-autocomplete\",\n            global: \"iss\",\n            retry: true\n        });\n        if (!window.amznJQ) {\n            return;\n        }\n    ;\n    ;\n        var amznJQ = window.amznJQ;\n        amznJQ.available(\"navbarInline\", function() {\n            $Nav.declare(\"logEvent\", window._navbar.logEv);\n            $Nav.declare(\"config.readyOnATF\", window._navbar.readyOnATF);\n            $Nav.declare(\"config.browsePromos\", window._navbar.browsepromos);\n            $Nav.declare(\"config.yourAccountPrimeURL\", window._navbar.yourAccountPrimer);\n            $Nav.declare(\"config.sbd\", window._navbar._sbd_config);\n            $Nav.declare(\"config.responsiveGW\", !!window._navbar.responsivegw);\n            $Nav.declare(\"config.swmStyleData\", ((window._navbar._swmStyleData || {\n            })));\n            $Nav.declare(\"config.dismissNotificationUrl\", window._navbar.dismissNotificationUrl);\n            $Nav.declare(\"config.signOutText\", window._navbar.signOutText);\n            $Nav.declare(\"config.lightningDeals\", ((window._navbar._lightningDealsData || {\n            })));\n            $Nav.declare(\"config.enableDynamicMenus\", window._navbar.dynamicMenus);\n            $Nav.declare(\"config.dynamicMenuArgs\", ((window._navbar.dynamicMenuArgs || {\n            })));\n            $Nav.declare(\"config.dynamicMenuUrl\", window._navbar.dynamicMenuUrl);\n            $Nav.declare(\"config.ajaxProximity\", window._navbar._ajaxProximity);\n            $Nav.declare(\"config.recordEvUrl\", window._navbar.recordEvUrl);\n            $Nav.declare(\"config.recordEvInterval\", ((window._navbar.recordEvInterval || 60000)));\n            $Nav.declare(\"config.sessionId\", window._navbar.sid);\n            $Nav.declare(\"config.requestId\", window._navbar.rid);\n            $Nav.declare(\"config.autoFocus\", window._navbar.enableAutoFocus);\n        });\n        amznJQ.available(\"navbarBTF\", function() {\n            $Nav.declare(\"config.flyoutURL\", window._navbar.flyoutURL);\n            $Nav.declare(\"config.prefetch\", window._navbar.prefetch);\n        });\n        $Nav.importEvent(\"navbarBTF\", {\n            as: \"btf.full\"\n        });\n        $Nav.importEvent(\"navbarBTFLite\", {\n            as: \"btf.lite\"\n        });\n        $Nav.importEvent(\"navbarInline\", {\n            as: \"nav.inline\"\n        });\n        $Nav.when(\"nav.inline\", \"api.unHideSWM\", \"api.exposeSBD\", \"api.navDimensions\", \"api.onShowProceedToCheckout\", \"api.update\", \"api.setCartCount\", \"api.getLightningDealsData\", \"api.overrideCartButtonClick\", \"flyout.loadMenusConditionally\", \"flyout.shopall\", \"flyout.wishlist\", \"flyout.cart\", \"flyout.youraccount\").publish(\"navbarJSInteraction\");\n        $Nav.when(\"navbarJSInteraction\").publish(\"navbarJS-beacon\");\n        $Nav.when(\"navbarJSInteraction\").publish(\"navbarJS-jQuery\");\n    }(window, window.$Nav));\n    window.navbar = {\n    };\n    window.$Nav.when(\"depend\").build(\"api.publish\", function(depend) {\n        var $Nav = window.$Nav;\n        var apiComponents = depend({\n            parent: $Nav,\n            prefix: \"api\",\n            bubble: false\n        });\n        function use(component, callback) {\n            apiComponents.when(component).run(callback);\n        };\n    ;\n        window.navbar.use = use;\n        return function(JSBNG__name, value) {\n            apiComponents.publish(JSBNG__name, value);\n            window.navbar[JSBNG__name] = value;\n            $Nav.publish(((\"nav.\" + JSBNG__name)), value);\n        };\n    });\n    (function($Nav) {\n        $Nav.declare(\"throttle\", function(wait, func) {\n            var throttling = false;\n            var called = false;\n            function afterWait() {\n                if (!called) {\n                    throttling = false;\n                    return;\n                }\n                 else {\n                    called = false;\n                    JSBNG__setTimeout(afterWait, wait);\n                    func();\n                }\n            ;\n            ;\n            };\n        ;\n            return function() {\n                if (throttling) {\n                    called = true;\n                    return;\n                }\n            ;\n            ;\n                throttling = true;\n                JSBNG__setTimeout(afterWait, wait);\n                func();\n            };\n        });\n        $Nav.when(\"$\").build(\"agent\", function($) {\n            return (new function() {\n                function contains() {\n                    var args = Array.prototype.slice.call(arguments, 0);\n                    var regex = new RegExp(((((\"(\" + args.join(\"|\"))) + \")\")), \"i\");\n                    return regex.test(JSBNG__navigator.userAgent);\n                };\n            ;\n                this.iPhone = contains(\"iPhone\");\n                this.iPad = contains(\"iPad\");\n                this.kindleFire = contains(\"Kindle Fire\", \"Silk/\");\n                this.android = contains(\"Android\");\n                this.webkit = contains(\"WebKit\");\n                this.ie10 = contains(\"MSIE 10\");\n                this.ie6 = (($.browser.msie && ((parseInt($.browser.version, 10) <= 6))));\n                this.touch = ((((((((((((this.iPhone || this.iPad)) || this.android)) || this.kindleFire)) || !!((\"JSBNG__ontouchstart\" in window)))) || ((window.JSBNG__navigator.msMaxTouchPoints > 0)))) || contains(\"\\\\bTouch\\\\b\")));\n                this.ie10touch = ((this.ie10 && this.touch));\n                this.mac = contains(\"Macintosh\");\n                this.iOS = ((this.iPhone || this.iPad));\n            });\n        });\n        $Nav.declare(\"byID\", function(elemID) {\n            return JSBNG__document.getElementById(elemID);\n        });\n        $Nav.build(\"dismissTooltip\", function() {\n            var dismissed = false;\n            return function() {\n                if (dismissed) {\n                    return;\n                }\n            ;\n            ;\n                $Nav.publish(\"navDismissTooltip\");\n                dismissed = true;\n            };\n        });\n        $Nav.build(\"recordEv\", function() {\n            var recordEvQueue = [], dups = {\n            };\n            $Nav.when(\"$\", \"config.recordEvUrl\", \"config.recordEvInterval\", \"config.sessionId\", \"config.requestId\").run(function($, recordEvUrl, interval, sessionId, requestId) {\n                if (!recordEvUrl) {\n                    return;\n                }\n            ;\n            ;\n                function getSid() {\n                    var sid = ((window.ue && window.ue.sid));\n                    sid = ((sid || sessionId));\n                    return ((sid ? sid : \"\"));\n                };\n            ;\n                function getRid() {\n                    var rid = ((window.ue && window.ue.rid));\n                    rid = ((rid || requestId));\n                    return ((rid ? rid : \"\"));\n                };\n            ;\n                var cnt = 0;\n                function send(when) {\n                    cnt++;\n                    if (((recordEvQueue.length === 0))) {\n                        return;\n                    }\n                ;\n                ;\n                    when = ((when || cnt));\n                    var msg = recordEvQueue.join(\":\");\n                    msg = window.encodeURIComponent(msg);\n                    msg = ((((((((((((((\"trigger=\" + msg)) + \"&when=\")) + when)) + \"&sid=\")) + getSid())) + \"&rid=\")) + getRid()));\n                    var sep = ((((recordEvUrl.indexOf(\"?\") > 0)) ? \"&\" : \"?\"));\n                    new JSBNG__Image().src = ((((recordEvUrl + sep)) + msg));\n                    recordEvQueue = [];\n                };\n            ;\n                window.JSBNG__setInterval(send, interval);\n                $(window).bind(\"beforeunload\", function() {\n                    send(\"beforeunload\");\n                });\n            });\n            return function(evId) {\n                if (!((evId in dups))) {\n                    recordEvQueue.push(evId);\n                    dups[evId] = true;\n                }\n            ;\n            ;\n            };\n        });\n        $Nav.declare(\"TunableCallback\", function(callback) {\n            var timeout = 0;\n            var conditions = [];\n            var wrapper = function() {\n                function execute() {\n                    for (var i = 0; ((i < conditions.length)); i++) {\n                        if (!conditions[i]()) {\n                            return;\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    callback();\n                };\n            ;\n                if (((timeout > 0))) {\n                    JSBNG__setTimeout(execute, timeout);\n                }\n                 else {\n                    execute();\n                }\n            ;\n            ;\n            };\n            wrapper.delay = function(milliseconds) {\n                timeout = milliseconds;\n                return wrapper;\n            };\n            wrapper.iff = function(predicate) {\n                conditions.push(predicate);\n                return wrapper;\n            };\n            return wrapper;\n        });\n        $Nav.build(\"eachDescendant\", function() {\n            function eachDescendant(node, func) {\n                func(node);\n                node = node.firstChild;\n                while (node) {\n                    eachDescendant(node, func);\n                    node = node.nextSibling;\n                };\n            ;\n            };\n        ;\n            return eachDescendant;\n        });\n        $Nav.when(\"$\", \"promise\", \"TunableCallback\").run(\"pageReady\", function($, promise, TunableCallback) {\n            if (((JSBNG__document.readyState === \"complete\"))) {\n                $Nav.declare(\"page.ready\");\n                return;\n            }\n        ;\n        ;\n            var pageReady = promise();\n            function windowNotLoaded() {\n                return ((JSBNG__document.readyState != \"complete\"));\n            };\n        ;\n            function atfEnabled() {\n                return !!$Nav.getNow(\"config.readyOnATF\");\n            };\n        ;\n            $Nav.when(\"page.ATF\").run(TunableCallback(pageReady).iff(windowNotLoaded).iff(atfEnabled));\n            $Nav.when(\"page.CF\").run(TunableCallback(pageReady).iff(windowNotLoaded));\n            $Nav.when(\"page.domReady\").run(TunableCallback(pageReady).delay(10000).iff(windowNotLoaded));\n            $Nav.when(\"page.loaded\").run(TunableCallback(pageReady).delay(100));\n            pageReady.watch([$Nav.getNow(\"instance.sourceName\"),\"pageReadyCallback\",], function() {\n                $Nav.declare(\"page.ready\");\n            });\n        });\n        $Nav.when(\"$\", \"agent\").build(\"onOptionClick\", function($, agent) {\n            return function(node, callback) {\n                var $node = $(node);\n                if (((((agent.mac && agent.webkit)) || ((agent.touch && !agent.ie10))))) {\n                    $node.change(function() {\n                        callback.apply($node);\n                    });\n                }\n                 else {\n                    var time = {\n                        click: 0,\n                        change: 0\n                    };\n                    var buildClickChangeHandler = function(primary, secondary) {\n                        return function() {\n                            time[primary] = new JSBNG__Date().getTime();\n                            if (((((time[primary] - time[secondary])) <= 100))) {\n                                callback.apply($node);\n                            }\n                        ;\n                        ;\n                        };\n                    };\n                    $node.click(buildClickChangeHandler(\"click\", \"change\")).change(buildClickChangeHandler(\"change\", \"click\"));\n                }\n            ;\n            ;\n            };\n        });\n        $Nav.when(\"$\", \"promise\", \"api.publish\").build(\"triggerProceedToCheckout\", function($, promise, publishAPI) {\n            var observers = promise();\n            publishAPI(\"onShowProceedToCheckout\", function(callback) {\n                observers.watch([$Nav.getNow(\"instance.sourceName\"),\"onShowProceedToCheckoutCallback\",], function() {\n                    var buttons = $(\"#nav_cart_flyout a[href~=proceedToCheckout]\");\n                    if (((buttons.length > 0))) {\n                        callback(buttons);\n                    }\n                ;\n                ;\n                });\n            });\n            return observers;\n        });\n        $Nav.when(\"promise\", \"api.publish\").run(\"triggerNearFlyout\", function(promise, publishAPI) {\n            var observers = promise();\n            publishAPI(\"onNearFlyout\", function(callback) {\n                observers.watch([$Nav.getNow(\"instance.sourceName\"),\"onNearFlyoutCallback\",], callback);\n            });\n            $Nav.when(\"config.prefetchUrls\", \"JSBNG__event.prefetch\").run(\"prefetch\", function(prefetchUrls, triggerNearFlyout) {\n                ((window.amznJQ && window.amznJQ.addPL(prefetchUrls)));\n                observers();\n            });\n        });\n        $Nav.when(\"$\", \"byID\").build(\"$byID\", function($, byID) {\n            return function(elemID) {\n                return $(((byID(elemID) || [])));\n            };\n        });\n        $Nav.when(\"$byID\", \"config.dynamicMenuArgs\", \"btf.full\").build(\"flyout.primeAjax\", function($id, dynamicMenuArgs) {\n            return ((dynamicMenuArgs.hasOwnProperty(\"isPrime\") && $id(\"nav-prime-menu\").hasClass(\"nav-ajax-prime-menu\")));\n        });\n        $Nav.when(\"$\", \"agent\").build(\"areaMapper\", function($, agent) {\n            var nullFn = function() {\n            \n            };\n            if (!agent.kindleFire) {\n                return {\n                    disable: nullFn,\n                    enable: nullFn\n                };\n            }\n        ;\n        ;\n            var disabled = $([]);\n            return {\n                disable: function(except) {\n                    var newMaps = $(\"img[usemap]\").filter(function() {\n                        return (($(this).parents(except).length === 0));\n                    });\n                    disabled = disabled.add(newMaps);\n                    newMaps.each(function() {\n                        this.disabledUseMap = $(this).attr(\"usemap\");\n                        $(this).attr(\"usemap\", \"\");\n                    });\n                },\n                enable: function() {\n                    disabled.each(function() {\n                        $(this).attr(\"usemap\", this.disabledUseMap);\n                    });\n                    disabled = $([]);\n                }\n            };\n        });\n        $Nav.when(\"$\").build(\"template\", function($) {\n            var cache = {\n            };\n            return function(id, data) {\n                if (!cache[id]) {\n                    cache[id] = new Function(\"obj\", ((((((\"var p=[],print=function(){p.push.apply(p,arguments);};\" + \"with(obj){p.push('\")) + $(id).html().replace(/[\\r\\t\\n]/g, \" \").replace(/'(?=[^#]*#>)/g, \"\\u0009\").split(\"'\").join(\"\\\\'\").split(\"\\u0009\").join(\"'\").replace(/<#=(.+?)#>/g, \"',$1,'\").split(\"\\u003C#\").join(\"');\").split(\"#\\u003E\").join(\"p.push('\"))) + \"');}return p.join('');\")));\n                }\n            ;\n            ;\n                try {\n                    return cache[id](data);\n                } catch (e) {\n                    return \"\";\n                };\n            ;\n            };\n        });\n        $Nav.when(\"$\", \"config.yourAccountPrimeURL\", \"nav.inline\").run(\"yourAccountPrimer\", function($, yourAccountPrimer) {\n            if (yourAccountPrimer) {\n                $(\"#nav_prefetch_yourorders\").mousedown((function() {\n                    var fired = false;\n                    return function() {\n                        if (fired) {\n                            return;\n                        }\n                    ;\n                    ;\n                        fired = true;\n                        (new JSBNG__Image).src = yourAccountPrimer;\n                    };\n                }()));\n            }\n        ;\n        ;\n        });\n        $Nav.when(\"$\", \"byID\", \"agent\", \"dismissTooltip\", \"recordEv\").build(\"flyout.NavButton\", function($, byID, agent, dismissTooltip, recordEv) {\n            function NavButton(id) {\n                this._jqId = ((\"#\" + id));\n                var button = this;\n                byID(id).className = byID(id).className.replace(\"nav-menu-inactive\", \"nav-menu-active\");\n                var lastShown = 0;\n                var weblabs;\n                this.onShow = function() {\n                    lastShown = +(new JSBNG__Date);\n                    dismissTooltip();\n                    button._toggleClass(true, \"nav-button-outer-open\");\n                    if (weblabs) {\n                        recordEv(weblabs);\n                    }\n                ;\n                ;\n                };\n                this.onHide = function() {\n                    button._toggleClass(false, \"nav-button-outer-open\");\n                };\n                this.registerTrigger = function(options) {\n                    var params = this._defaultTriggerParams(button);\n                    $().extend(params, ((options || {\n                    })));\n                    var popover = $(button._jqId).amazonPopoverTrigger(params);\n                    if (params.localContent) {\n                        weblabs = $(params.localContent).attr(\"data-nav-wt\");\n                    }\n                ;\n                ;\n                    if (((agent.touch && $.AmazonPopover.support.controlCallbacks))) {\n                        $(button._jqId).click(function() {\n                            if (((popover.amznPopoverVisible() && ((((+(new JSBNG__Date) - lastShown)) > 400))))) {\n                                popover.amznPopoverHide();\n                            }\n                        ;\n                        ;\n                        });\n                    }\n                ;\n                ;\n                };\n                this.removeTrigger = function() {\n                    $(button._jqId).removeAmazonPopoverTrigger();\n                };\n                this._toggleClass = function(state, className) {\n                    if (state) {\n                        $(button._jqId).addClass(className);\n                    }\n                     else {\n                        $(button._jqId).removeClass(className);\n                    }\n                ;\n                ;\n                };\n                $(button._jqId).keypress(function(e) {\n                    if (((((e.which == 13)) && $(button._jqId).attr(\"href\")))) {\n                        window.JSBNG__location = $(button._jqId).attr(\"href\");\n                    }\n                ;\n                ;\n                });\n                this._defaultTriggerParams = function(button) {\n                    var c = {\n                        width: null,\n                        JSBNG__location: \"bottom\",\n                        locationAlign: \"left\",\n                        locationMargin: 0,\n                        hoverShowDelay: ((agent.touch ? 0 : 250)),\n                        hoverHideDelay: ((agent.touch ? 0 : 250)),\n                        showOnHover: true,\n                        forceAlignment: true,\n                        focusOnShow: false,\n                        skin: null,\n                        onShow: button.onShow,\n                        onHide: button.onHide,\n                        showCloseButton: false,\n                        group: \"navbar\"\n                    };\n                    if (agent.ie10touch) {\n                        c.hoverShowDelay = 250;\n                    }\n                ;\n                ;\n                    return c;\n                };\n            };\n        ;\n            return NavButton;\n        });\n        $Nav.when(\"$byID\", \"agent\", \"$popover\").build(\"flyout.SKIN\", function($id, agent, $) {\n            return function(jqObject, xOffset, skinClass) {\n                var callback = function() {\n                    var navWidth = $id(\"nav-bar-outer\").width();\n                    var rightMargin = Math.min(30, Math.max(0, ((((((navWidth - jqObject.offset().left)) - jqObject.JSBNG__outerWidth())) - xOffset)))), style = ((((rightMargin < 30)) ? ((((\" style=\\\"width: \" + ((rightMargin + 15)))) + \"px;\\\"\")) : \"\")), classes = [\"nav_flyout_table\",];\n                    if (agent.ie6) {\n                        classes.push(\"nav_ie6\");\n                    }\n                ;\n                ;\n                    if (skinClass) {\n                        classes.push(skinClass);\n                    }\n                ;\n                ;\n                    return ((((((((((((((((((((((((((((((((\"\\u003Ctable cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" surround=\\\"0,\" + rightMargin)) + \",30,30\\\" class=\\\"\")) + classes.join(\" \"))) + \"\\\"\\u003E\")) + \"\\u003Ctr\\u003E\\u003Ctd class=\\\"nav_pop_tl nav_pop_h\\\"\\u003E\\u003Cdiv class=\\\"nav_pop_lr_min\\\"\\u003E\\u003C/div\\u003E\\u003C/td\\u003E\\u003Ctd class=\\\"nav_pop_tc nav_pop_h\\\"\\u003E\\u003C/td\\u003E\\u003Ctd class=\\\"nav_pop_tr nav_pop_h\\\"\")) + style)) + \"\\u003E\\u003Cdiv class=\\\"nav_pop_lr_min\\\"\")) + style)) + \"\\u003E\\u003C/div\\u003E\\u003C/td\\u003E\\u003C/tr\\u003E\")) + \"\\u003Ctr\\u003E\\u003Ctd class=\\\"nav_pop_cl nav_pop_v\\\"\\u003E\\u003C/td\\u003E\\u003Ctd class=\\\"nav_pop_cc ap_content\\\"\\u003E\\u003C/td\\u003E\\u003Ctd class=\\\"nav_pop_cr nav_pop_v\\\"\")) + style)) + \"\\u003E\\u003C/td\\u003E\\u003C/tr\\u003E\")) + \"\\u003Ctr\\u003E\\u003Ctd class=\\\"nav_pop_bl nav_pop_v\\\"\\u003E\\u003C/td\\u003E\\u003Ctd class=\\\"nav_pop_bc nav_pop_h\\\"\\u003E\\u003C/td\\u003E\\u003Ctd class=\\\"nav_pop_br nav_pop_v\\\"\")) + style)) + \"\\u003E\\u003C/td\\u003E\\u003C/tr\\u003E\")) + \"\\u003C/table\\u003E\"));\n                };\n                return (((($.AmazonPopover.support && $.AmazonPopover.support.skinCallback)) ? callback : callback()));\n            };\n        });\n        $Nav.when(\"$\", \"byID\", \"eachDescendant\").build(\"flyout.computeFlyoutHeight\", function($, byID, eachDescendant) {\n            var flyoutHeightTable = {\n            };\n            return function(id) {\n                if (((id in flyoutHeightTable))) {\n                    return flyoutHeightTable[id];\n                }\n            ;\n            ;\n                var elem = byID(id);\n                var isDeepShopAll = (($(elem).parents(\".nav_deep\").length > 0));\n                var isShortDeep = $(elem).is(\".nav_short\");\n                var height = 0;\n                if (isDeepShopAll) {\n                    height -= 7;\n                }\n            ;\n            ;\n                eachDescendant(elem, function(node) {\n                    var $node;\n                    if (((node.nodeType == 1))) {\n                        $node = $(node);\n                        if (!isDeepShopAll) {\n                            height += (($node.hasClass(\"nav_pop_li\") ? 23 : 0));\n                            height += (($node.hasClass(\"nav_divider_before\") ? 10 : 0));\n                            height += (($node.hasClass(\"nav_first\") ? -7 : 0));\n                            height += (($node.hasClass(\"nav_tag\") ? 13 : 0));\n                        }\n                         else {\n                            if (isShortDeep) {\n                                height += (($node.hasClass(\"nav_pop_li\") ? 28 : 0));\n                                height += (($node.hasClass(\"nav_first\") ? -8 : 0));\n                                height += (($node.hasClass(\"nav_divider_before\") ? 13 : 0));\n                                height += (($node.hasClass(\"nav_tag\") ? 13 : 0));\n                            }\n                             else {\n                                height += (($node.hasClass(\"nav_pop_li\") ? 30 : 0));\n                                height += (($node.hasClass(\"nav_first\") ? -7 : 0));\n                                height += (($node.hasClass(\"nav_divider_before\") ? 15 : 0));\n                                height += (($node.hasClass(\"nav_tag\") ? 13 : 0));\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                    }\n                ;\n                ;\n                });\n                flyoutHeightTable[id] = height;\n                return height;\n            };\n        });\n        $Nav.when(\"$popover\", \"$byID\", \"agent\", \"logEvent\", \"recordEv\", \"areaMapper\", \"flyout.NavButton\", \"flyout.SKIN\", \"flyout.computeFlyoutHeight\", \"flyout.initBrowsePromos\", \"config.responsiveGW\", \"config.sbd\", \"nav.inline\", \"flyout.JSBNG__content\").run(\"ShopAll\", function($, $id, agent, logEv, recordEv, areaMapper, NavButton, SKIN, computeFlyoutHeight, initBrowsePromos, responsiveGW, sbd_config) {\n            if (((!$id(\"nav-shop-all-button\").length || !$id(\"nav_browse_flyout\").length))) {\n                return;\n            }\n        ;\n        ;\n            var nullFn = function() {\n            \n            };\n            var mt = $.AmazonPopover.mouseTracker, ub = $.AmazonPopover.updateBacking, subcatInited, deferredResizeSubcat, catWidth, mtRegions = [], activeCat, wasSuperCat, subcatRect, delayedChange, priorCursor, exposeSBDData, delayImpression, delayCatImpression;\n            var id = \"nav-shop-all-button\", button = new NavButton(id), jQButton = $id(id), isResponsive = ((responsiveGW && ((!agent.touch || agent.ie10touch))));\n            if (agent.touch) {\n                $(\"#nav_cats .nav_cat a\").each(function() {\n                    var $this = $(this);\n                    $this.replaceWith($this.text());\n                });\n            }\n        ;\n        ;\n            var onShow = function() {\n                var initExposeSBD = $Nav.getNow(\"initExposeSBD\");\n                if (initExposeSBD) {\n                    initExposeSBD().deBorder(true);\n                }\n            ;\n            ;\n                areaMapper.disable(\"#nav_browse_flyout\");\n                initBrowsePromos();\n                var $browse_flyout = $id(\"nav_browse_flyout\"), $subcats = $id(\"nav_subcats\"), $subcats_wrap = $id(\"nav_subcats_wrap\"), $cats = $id(\"nav_cats_wrap\"), $cat_indicator = $id(\"nav_cat_indicator\");\n                if (!subcatInited) {\n                    catWidth = $cats.JSBNG__outerWidth();\n                    $browse_flyout.css({\n                        height: ((computeFlyoutHeight(\"nav_cats_wrap\") + \"px\")),\n                        width: ((catWidth + \"px\"))\n                    });\n                    $subcats_wrap.css({\n                        display: \"block\"\n                    });\n                    subcatInited = true;\n                }\n                 else {\n                    $browse_flyout.css({\n                        height: ((computeFlyoutHeight(\"nav_cats_wrap\") + \"px\"))\n                    });\n                }\n            ;\n            ;\n                var animateSubcatComplete = function() {\n                    if (deferredResizeSubcat) {\n                        deferredResizeSubcat();\n                    }\n                ;\n                ;\n                    deferredResizeSubcat = null;\n                    if (agent.touch) {\n                        var $video = $(\"video\");\n                        $video.css(\"visibility\", \"hidden\");\n                        JSBNG__setTimeout(function() {\n                            $video.css(\"visibility\", \"\");\n                        }, 10);\n                    }\n                ;\n                ;\n                    $browse_flyout.css({\n                        overflow: \"visible\"\n                    });\n                };\n                var rectRelation = function(cursor, rect) {\n                    var h = \"c\", v = \"c\";\n                    if (((cursor && rect))) {\n                        if (((cursor.x < rect.x1))) {\n                            h = \"l\";\n                        }\n                         else {\n                            if (((cursor.x > rect.x2))) {\n                                h = \"r\";\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                        if (((cursor.y < rect.y1))) {\n                            v = \"t\";\n                        }\n                         else {\n                            if (((cursor.y > rect.y2))) {\n                                v = \"b\";\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                    }\n                ;\n                ;\n                    return ((v + h));\n                };\n                var notInRect = function(cursor, rect) {\n                    if (((rectRelation(cursor, rect) == \"cc\"))) {\n                        return false;\n                    }\n                ;\n                ;\n                    return true;\n                };\n                var calcChangeDelay = function(args, rect) {\n                    var delay = 0, c = args.cursor, p1 = ((args.priorCursors[0] || {\n                    })), p2 = ((args.priorCursors[1] || {\n                    }));\n                    if (((((((c.x == p1.x)) && ((Math.abs(((c.y - p1.y))) < 2)))) && ((c.x > p2.x))))) {\n                        delay = sbd_config.minor_delay;\n                    }\n                     else {\n                        var r = rect, pts = [c,p1,];\n                        switch (rectRelation(c, r)) {\n                          case \"tl\":\n                            pts.push({\n                                x: r.x1,\n                                y: r.y2\n                            }, {\n                                x: r.x2,\n                                y: r.y1\n                            });\n                            break;\n                          case \"bl\":\n                            pts.push({\n                                x: r.x1,\n                                y: r.y1\n                            }, {\n                                x: r.x2,\n                                y: r.y2\n                            });\n                            break;\n                          case \"cl\":\n                            pts.push({\n                                x: r.x1,\n                                y: r.y1\n                            }, {\n                                x: r.x1,\n                                y: r.y2\n                            });\n                            break;\n                          default:\n                            pts.push({\n                                x: 0,\n                                y: 0\n                            }, {\n                                x: 0,\n                                y: 0\n                            });\n                            delay = -1;\n                        };\n                    ;\n                        if (((delay === 0))) {\n                            var b0 = ((((((pts[2].x - pts[1].x)) * ((pts[3].y - pts[1].y)))) - ((((pts[3].x - pts[1].x)) * ((pts[2].y - pts[1].y)))))), b1 = ((((((((pts[2].x - pts[0].x)) * ((pts[3].y - pts[0].y)))) - ((((pts[3].x - pts[0].x)) * ((pts[2].y - pts[0].y)))))) / b0)), b2 = ((((((((pts[3].x - pts[0].x)) * ((pts[1].y - pts[0].y)))) - ((((pts[1].x - pts[0].x)) * ((pts[3].y - pts[0].y)))))) / b0)), b3 = ((((((((pts[1].x - pts[0].x)) * ((pts[2].y - pts[0].y)))) - ((((pts[2].x - pts[0].x)) * ((pts[1].y - pts[0].y)))))) / b0));\n                            delay = ((((((((b1 > 0)) && ((b2 > 0)))) && ((b3 > 0)))) ? sbd_config.major_delay : 0));\n                        }\n                    ;\n                    ;\n                    }\n                ;\n                ;\n                    return delay;\n                };\n                var doCatChange = function(cat, args) {\n                    var animateSubcat = !activeCat, resizeSubcat = false, $subcat = $id(((\"nav_subcats_\" + cat))), $cat = $id(((\"nav_cat_\" + cat))), promoID = $subcat.attr(\"data-nav-promo-id\"), wtl = $subcat.attr(\"data-nav-wt\");\n                    if (activeCat) {\n                        $id(((\"nav_subcats_\" + activeCat))).css({\n                            display: \"none\"\n                        });\n                        $id(((\"nav_cat_\" + activeCat))).removeClass(\"nav_active\");\n                    }\n                ;\n                ;\n                    JSBNG__clearTimeout(delayCatImpression);\n                    if (promoID) {\n                        var browsepromos = $Nav.getNow(\"config.browsePromos\", {\n                        });\n                        var imp = {\n                            t: \"sa\",\n                            id: promoID\n                        };\n                        if (browsepromos[promoID]) {\n                            imp[\"bp\"] = 1;\n                        }\n                    ;\n                    ;\n                        delayCatImpression = window.JSBNG__setTimeout(function() {\n                            logEv(imp);\n                        }, 750);\n                    }\n                ;\n                ;\n                    if (wtl) {\n                        recordEv(wtl);\n                    }\n                ;\n                ;\n                    $cat.addClass(\"nav_active\");\n                    $subcat.css({\n                        display: \"block\"\n                    });\n                    $cat_indicator.css(\"JSBNG__top\", (((($cat.position().JSBNG__top + parseInt($cat.css(\"padding-top\"), 10))) + 1)));\n                    var isSuperCat = $subcat.hasClass(\"nav_super_cat\");\n                    if (((isSuperCat != wasSuperCat))) {\n                        if (isSuperCat) {\n                            $browse_flyout.addClass(\"nav_super\");\n                        }\n                         else {\n                            $browse_flyout.removeClass(\"nav_super\");\n                        }\n                    ;\n                    ;\n                        resizeSubcat = true;\n                        wasSuperCat = isSuperCat;\n                    }\n                ;\n                ;\n                    if (animateSubcat) {\n                        deferredResizeSubcat = function() {\n                            ub(\"navbar\");\n                        };\n                        $browse_flyout.animate({\n                            width: (((($subcats.JSBNG__outerWidth() + catWidth)) + \"px\"))\n                        }, {\n                            duration: \"fast\",\n                            complete: animateSubcatComplete\n                        });\n                    }\n                     else {\n                        if (resizeSubcat) {\n                            var resizeSubcatNow = function() {\n                                $browse_flyout.css({\n                                    width: (((($subcats.JSBNG__outerWidth() + catWidth)) + \"px\"))\n                                });\n                                ub(\"navbar\");\n                            };\n                            if (deferredResizeSubcat) {\n                                deferredResizeSubcat = resizeSubcatNow;\n                            }\n                             else {\n                                resizeSubcatNow();\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                    }\n                ;\n                ;\n                    if (((isResponsive && !agent.ie6))) {\n                        $subcat.parents(\".nav_exposed_skin\").removeClass(\"nav_exposed_skin\");\n                    }\n                ;\n                ;\n                    $subcat.JSBNG__find(\".nav_subcat_links\").each(function() {\n                        var $this = $(this);\n                        if ($this.data(\"nav-linestarts-marked\")) {\n                            return;\n                        }\n                    ;\n                    ;\n                        $this.data(\"nav-linestarts-marked\", true);\n                        var JSBNG__top = 0;\n                        $this.JSBNG__find(\"li\").each(function() {\n                            var elem = $(this);\n                            var thisTop = elem.offset().JSBNG__top;\n                            if (((Math.abs(((thisTop - JSBNG__top))) > 5))) {\n                                elem.addClass(\"nav_linestart\");\n                                JSBNG__top = thisTop;\n                            }\n                        ;\n                        ;\n                        });\n                    });\n                    var offset = $subcat.offset(), x1 = offset.left, y1 = ((offset.JSBNG__top - sbd_config.target_slop)), x2 = ((x1 + $subcat.JSBNG__outerWidth())), y2 = ((((y1 + $subcat.JSBNG__outerHeight())) + sbd_config.target_slop));\n                    return {\n                        x1: x1,\n                        y1: y1,\n                        x2: x2,\n                        y2: y2\n                    };\n                };\n                window._navbar.qaActivateCat = function(i) {\n                    i = ((i || \"0\"));\n                    doCatChange(i);\n                    activeCat = i;\n                };\n                $(\"#nav_cats li.nav_cat\").each(function() {\n                    var match = /^nav_cat_(.+)/.exec(this.id), cat = ((match ? match[1] : \"\"));\n                    var mouseEnter = function(args) {\n                        JSBNG__clearTimeout(delayedChange);\n                        $id(((\"nav_cat_\" + cat))).addClass(\"nav_hover\");\n                        if (((activeCat !== cat))) {\n                            var changeDelay = calcChangeDelay(args, subcatRect);\n                            if (((activeCat && ((changeDelay > 0))))) {\n                                var doDelayedChange = function() {\n                                    JSBNG__clearTimeout(delayedChange);\n                                    var delayedArgs = mt.getCallbackArgs(), delayedDelay = 0;\n                                    if (((((priorCursor && ((priorCursor.x == delayedArgs.cursor.x)))) && ((priorCursor.y == delayedArgs.cursor.y))))) {\n                                        if (notInRect(delayedArgs.cursor, subcatRect)) {\n                                            delayedDelay = 0;\n                                        }\n                                         else {\n                                            delayedDelay = -1;\n                                        }\n                                    ;\n                                    ;\n                                    }\n                                     else {\n                                        delayedDelay = calcChangeDelay(delayedArgs, subcatRect);\n                                    }\n                                ;\n                                ;\n                                    priorCursor = {\n                                        x: delayedArgs.cursor.x,\n                                        y: delayedArgs.cursor.y\n                                    };\n                                    if (((delayedDelay > 0))) {\n                                        if (((activeCat !== cat))) {\n                                            delayedChange = JSBNG__setTimeout(doDelayedChange, delayedDelay);\n                                        }\n                                    ;\n                                    ;\n                                    }\n                                     else {\n                                        if (((delayedDelay > -1))) {\n                                            subcatRect = doCatChange(cat, args);\n                                            activeCat = cat;\n                                        }\n                                    ;\n                                    ;\n                                    }\n                                ;\n                                ;\n                                };\n                                delayedChange = JSBNG__setTimeout(doDelayedChange, changeDelay);\n                            }\n                             else {\n                                subcatRect = doCatChange(cat, args);\n                                activeCat = cat;\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                        return true;\n                    };\n                    var mouseLeave = function(immediately, args) {\n                        $id(((\"nav_cat_\" + cat))).removeClass(\"nav_hover\");\n                        return true;\n                    };\n                    var $this = $(this), offset = $this.offset(), added = mt.add([[offset.left,offset.JSBNG__top,$this.JSBNG__outerWidth(),$this.JSBNG__outerHeight(),],], {\n                        inside: false,\n                        mouseEnter: mouseEnter,\n                        mouseLeave: mouseLeave\n                    });\n                    mtRegions.push(added);\n                });\n            };\n            var onHide = function() {\n                JSBNG__clearTimeout(delayedChange);\n                JSBNG__clearTimeout(delayCatImpression);\n                JSBNG__clearTimeout(delayImpression);\n                for (var i = 0; ((i < mtRegions.length)); i++) {\n                    mt.remove(mtRegions[i]);\n                };\n            ;\n                mtRegions = [];\n                subcatRect = null;\n                subcatInited = false;\n                if (activeCat) {\n                    $id(((\"nav_subcats_\" + activeCat))).css({\n                        display: \"none\"\n                    });\n                    $id(((\"nav_cat_\" + activeCat))).removeClass(\"nav_active\");\n                }\n            ;\n            ;\n                activeCat = null;\n                $id(\"nav_cat_indicator\").css({\n                    JSBNG__top: \"\"\n                });\n                $id(\"nav_browse_flyout\").css({\n                    height: \"\",\n                    overflow: \"\"\n                });\n                areaMapper.enable();\n                var initExposeSBD = $Nav.getNow(\"initExposeSBD\");\n                if (initExposeSBD) {\n                    initExposeSBD().deBorder(false);\n                }\n            ;\n            ;\n            };\n            $Nav.declare(\"initExposeSBD\", function() {\n                if (exposeSBDData) {\n                    return exposeSBDData;\n                }\n            ;\n            ;\n                if (!isResponsive) {\n                    exposeSBDData = {\n                        ok: function() {\n                            return false;\n                        },\n                        deBorder: nullFn,\n                        initDeferredShow: nullFn,\n                        deferredShow: nullFn\n                    };\n                    return exposeSBDData;\n                }\n            ;\n            ;\n                var $anchor = $id(\"nav_exposed_anchor\"), skinClass = ((agent.ie6 ? \"\" : \"nav_exposed_skin\")), skin = SKIN(jQButton, 0, skinClass), $skin = $(((((typeof (skin) == \"function\")) ? skin() : skin))), $wrap = $(\"\\u003Cdiv id=\\\"nav_exposed_skin\\\"\\u003E\\u003C/div\\u003E\").css({\n                    JSBNG__top: -8,\n                    left: ((jQButton.offset().left - ((agent.ie6 ? 27 : 30))))\n                }).append($skin).appendTo($anchor), $old_parent = $id(\"nav_browse_flyout\"), $parent = $(\"\\u003Cdiv id=\\\"nav_exposed_cats\\\"\\u003E\\u003C/div\\u003E\").appendTo($(\".ap_content\", $wrap)), $fade = $id(\"nav-shop-all-button\").clone().attr({\n                    href: \"javascript:void(0)\",\n                    id: \"\"\n                }).addClass(\"nav-shop-all-button nav-button-outer-open\").appendTo(\"#nav-bar-inner\").add($wrap), $roots = $id(\"navbar\").add($anchor), $cats = $id(\"nav_cats_wrap\"), exButton = new NavButton(\"nav_exposed_skin\"), isExposed, firstCall = true, lastState, deferShow, deferHide, oldIE = (($.browser.msie && ((!JSBNG__document.documentMode || ((JSBNG__document.documentMode < 8))))));\n                exposeSBDData = {\n                    ok: function() {\n                        return true;\n                    },\n                    deBorder: function(b) {\n                        if (b) {\n                            $skin.addClass(\"nav_pop_triggered\");\n                        }\n                         else {\n                            $skin.removeClass(\"nav_pop_triggered\");\n                        }\n                    ;\n                    ;\n                    },\n                    initDeferredShow: function() {\n                        if (!deferShow) {\n                            deferShow = nullFn;\n                        }\n                    ;\n                    ;\n                    },\n                    deferredShow: function() {\n                        if (deferShow) {\n                            deferShow();\n                            deferShow = null;\n                        }\n                    ;\n                    ;\n                    }\n                };\n                var exTriggerParams = {\n                    localContent: \"#nav_browse_flyout\",\n                    JSBNG__location: \"JSBNG__top\",\n                    locationAlign: \"left\",\n                    locationOffset: [30,((oldIE ? 33 : 32)),],\n                    skin: SKIN($parent, 0, skinClass),\n                    showOnHover: true,\n                    hoverShowDelay: 0,\n                    onShow: function() {\n                        if (!deferHide) {\n                            deferHide = nullFn;\n                        }\n                    ;\n                    ;\n                        exButton.removeTrigger();\n                        exButton.onShow();\n                        onShow();\n                        $cats.appendTo($old_parent);\n                        $(JSBNG__document).mousemove();\n                    },\n                    onHide: function() {\n                        $cats.appendTo($parent);\n                        onHide();\n                        exButton.onHide();\n                        exButton.registerTrigger(exTriggerParams);\n                        if (deferHide) {\n                            deferHide();\n                        }\n                    ;\n                    ;\n                        deferHide = null;\n                    }\n                };\n                $Nav.when(\"protectExposeSBD\").run(\"exposeSBD\", function(protectExposeSBD) {\n                    protectExposeSBD(function(expose) {\n                        lastState = expose;\n                        if (((expose === isExposed))) {\n                            return;\n                        }\n                    ;\n                    ;\n                        if (expose) {\n                            logEv({\n                                t: \"sa\",\n                                id: \"res-main\"\n                            });\n                            var doShow = function() {\n                                if (((lastState === false))) {\n                                    return;\n                                }\n                            ;\n                            ;\n                                button.removeTrigger();\n                                $roots.addClass(\"nav_exposed_sbd\");\n                                if ((($(\"#nav_browse_flyout.nav_deep\").length > 0))) {\n                                    $roots.addClass(\"nav_deep\");\n                                }\n                            ;\n                            ;\n                                $cats.appendTo($parent);\n                                if (firstCall) {\n                                    if ($.browser.msie) {\n                                        $fade.css(\"display\", \"block\");\n                                    }\n                                     else {\n                                        $fade.fadeIn(600);\n                                    }\n                                ;\n                                ;\n                                    firstCall = false;\n                                }\n                            ;\n                            ;\n                                exButton.registerTrigger(exTriggerParams);\n                                isExposed = true;\n                            };\n                            if (deferShow) {\n                                deferShow = doShow;\n                            }\n                             else {\n                                doShow();\n                            }\n                        ;\n                        ;\n                        }\n                         else {\n                            var doHide = function() {\n                                if (((lastState === true))) {\n                                    return;\n                                }\n                            ;\n                            ;\n                                exButton.removeTrigger();\n                                $roots.removeClass(\"nav_exposed_sbd\");\n                                $cats.appendTo($old_parent);\n                                if (firstCall) {\n                                    $fade.css(\"display\", \"block\");\n                                    firstCall = false;\n                                }\n                            ;\n                            ;\n                                button.registerTrigger(triggerParams);\n                                isExposed = false;\n                            };\n                            if (deferHide) {\n                                deferHide = doHide;\n                            }\n                             else {\n                                doHide();\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                    });\n                });\n                return exposeSBDData;\n            });\n            var triggerParams = {\n                localContent: \"#nav_browse_flyout\",\n                locationAlign: \"left\",\n                locationOffset: [((agent.ie6 ? 3 : 0)),0,],\n                skin: SKIN(jQButton, 0),\n                onShow: function() {\n                    var initExposeSBD = $Nav.getNow(\"initExposeSBD\");\n                    if (initExposeSBD) {\n                        initExposeSBD().initDeferredShow();\n                    }\n                ;\n                ;\n                    button.onShow();\n                    delayImpression = window.JSBNG__setTimeout(function() {\n                        logEv({\n                            t: \"sa\",\n                            id: \"main\"\n                        });\n                    }, 750);\n                    onShow();\n                },\n                onHide: function() {\n                    onHide();\n                    button.onHide();\n                    var initExposeSBD = $Nav.getNow(\"initExposeSBD\");\n                    if (initExposeSBD) {\n                        initExposeSBD().deferredShow();\n                    }\n                ;\n                ;\n                }\n            };\n            if (!isResponsive) {\n                button.registerTrigger(triggerParams);\n            }\n        ;\n        ;\n            $Nav.declare(\"flyout.shopall\");\n        });\n        $Nav.when(\"$\", \"$byID\", \"nav.inline\", \"flyout.JSBNG__content\").build(\"flyout.notificationCount\", function($, $id) {\n            var notiCount = parseInt((($(\"#nav-noti-wrapper .nav-noti-content\").attr(\"data-noti-count\") || \"0\")), 10);\n            var $count;\n            function notificationCount(count) {\n                notiCount = count;\n                if ($count) {\n                    if (((notiCount <= 0))) {\n                        $count.remove();\n                    }\n                     else {\n                        $count.text(((((notiCount > 9)) ? \"9+\" : notiCount)));\n                    }\n                ;\n                ;\n                }\n            ;\n            ;\n            };\n        ;\n            notificationCount.count = function() {\n                return notiCount;\n            };\n            notificationCount.decrement = function() {\n                notificationCount(((notiCount - 1)));\n            };\n            $Nav.when(\"page.ready\").run(function() {\n                if (((notiCount <= 0))) {\n                    return;\n                }\n            ;\n            ;\n                var $name = $id(\"nav-signin-text\");\n                var parts = $.trim($name.text()).match(/^(.*?)(\\.*)$/);\n                $name.html(((((parts[1] + \"\\u003Cspan id=\\\"nav-noti-count-position\\\"\\u003E\\u003C/span\\u003E\")) + parts[2])));\n                var positioner = $id(\"nav-noti-count-position\");\n                var countLeft = ((positioner.position().left + 10)), $button = $id(\"nav-your-account\"), tabWidth = (($button.JSBNG__outerWidth() - 5)), freePixels = ((tabWidth - countLeft)), cssObj = {\n                };\n                if (((((freePixels < 15)) || ((countLeft < 15))))) {\n                    cssObj.right = 2;\n                    if (((((freePixels > 0)) && ((freePixels <= 10))))) {\n                        $name.append(new Array(11).join(\"&nbsp;\"));\n                    }\n                ;\n                ;\n                }\n                 else {\n                    cssObj.left = ((Math.round(countLeft) + 1));\n                }\n            ;\n            ;\n                $count = $(\"\\u003Cdiv id=\\\"nav-noti-count\\\" class=\\\"nav-sprite\\\"\\u003E\");\n                $count.css(cssObj).appendTo($button);\n                notificationCount(notiCount);\n            });\n            return notificationCount;\n        });\n        $Nav.when(\"$\", \"$byID\", \"agent\", \"flyout.notificationCount\", \"config.dismissNotificationUrl\", \"flyout.JSBNG__content\").build(\"flyout.notifications\", function($, $byID, agent, notificationCount, dismissNotificationUrl) {\n            var $yaSidebarWrapper = $byID(\"nav-noti-wrapper\");\n            var $yaSidebar = $yaSidebarWrapper.JSBNG__find(\".nav-noti-content\");\n            var $notiItems = $yaSidebar.JSBNG__find(\".nav-noti-item\").not(\"#nav-noti-empty\");\n            function hideOverflow() {\n                var cutoff = (($yaSidebar.height() - $byID(\"nav-noti-all\").JSBNG__outerHeight(true)));\n                $notiItems.each(function() {\n                    var $this = $(this);\n                    if ($this.attr(\"data-dismissed\")) {\n                        return;\n                    }\n                ;\n                ;\n                    if ((((($this.position().JSBNG__top + $this.JSBNG__outerHeight())) > cutoff))) {\n                        $this.addClass(\"nav-noti-overflow\");\n                    }\n                     else {\n                        $this.removeClass(\"nav-noti-overflow\");\n                    }\n                ;\n                ;\n                });\n            };\n        ;\n            function hookupBehaviour() {\n                if (agent.touch) {\n                    $notiItems.addClass(\"nav-noti-touch\");\n                }\n                 else {\n                    $notiItems.hover(function() {\n                        $(this).addClass(\"nav-noti-hover\");\n                    }, function() {\n                        $(this).removeClass(\"nav-noti-hover\");\n                    });\n                }\n            ;\n            ;\n                $(\".nav-noti-x\", $yaSidebar).click(function(e) {\n                    e.preventDefault();\n                    var $this = $(this);\n                    $.ajax({\n                        url: dismissNotificationUrl,\n                        type: \"POST\",\n                        data: {\n                            id: $this.attr(\"data-noti-id\")\n                        },\n                        cache: false,\n                        timeout: 500\n                    });\n                    $this.css(\"visibility\", \"hidden\").parent().attr(\"data-dismissed\", \"1\").slideUp(400, function() {\n                        notificationCount.decrement();\n                        if (((notificationCount.count() === 0))) {\n                            $byID(\"nav-noti-empty\").fadeIn(300);\n                        }\n                    ;\n                    ;\n                        hideOverflow();\n                    });\n                }).hover(function() {\n                    $(this).addClass(\"nav-noti-x-hover\");\n                }, function() {\n                    $(this).removeClass(\"nav-noti-x-hover\");\n                });\n            };\n        ;\n            return {\n                width: 180,\n                exists: function() {\n                    return ((((notificationCount.count() > 0)) && (($yaSidebar.length > 0))));\n                },\n                getContent: function() {\n                    var node = $yaSidebar.get(0);\n                    node.parentNode.removeChild(node);\n                    hookupBehaviour();\n                    return $yaSidebar;\n                },\n                onShow: hideOverflow,\n                JSBNG__event: ((((notificationCount.count() > 0)) ? \"noti\" : null))\n            };\n        });\n        $Nav.when(\"$\", \"flyout.JSBNG__content\").build(\"flyout.highConfidence\", function($) {\n            var hcb = $(\"#csr-hcb-wrapper .csr-hcb-content\");\n            return {\n                width: 229,\n                exists: function() {\n                    return ((hcb.length > 0));\n                },\n                getContent: function() {\n                    var node = hcb.get(0);\n                    node.parentNode.removeChild(node);\n                    return hcb;\n                },\n                JSBNG__event: \"hcb\"\n            };\n        });\n        $Nav.when(\"$\", \"$byID\", \"areaMapper\", \"agent\", \"logEvent\", \"flyout.NavButton\", \"flyout.SKIN\", \"flyout.loadMenusConditionally\", \"flyout.notifications\", \"flyout.highConfidence\", \"config.signOutText\", \"nav.inline\", \"flyout.JSBNG__content\").run(\"YourAccount\", function($, $id, areaMapper, agent, logEv, NavButton, SKIN, loadDynamicMenusConditionally, notifications, highConf, signOutText) {\n            var JSBNG__sidebar;\n            if (notifications.exists()) {\n                JSBNG__sidebar = notifications;\n            }\n             else {\n                if (highConf.exists()) {\n                    JSBNG__sidebar = highConf;\n                }\n            ;\n            ;\n            }\n        ;\n        ;\n            var id = \"nav-your-account\", jQButton = $id(id), $yaFlyout = $id(\"nav_your_account_flyout\"), $yaSidebar;\n            if (((!jQButton.length || !$yaFlyout.length))) {\n                return;\n            }\n        ;\n        ;\n            var button = new NavButton(id), $yaSidebarWrapper = $(\"#nav-noti-wrapper, #csr-hcb-wrapper\"), delayImpression, leftAlignedYA = (($id(\"nav-wishlist\").length || $id(\"nav-cart\").length));\n            var onShow = function() {\n                button.onShow();\n                if (((JSBNG__sidebar && JSBNG__sidebar.onShow))) {\n                    JSBNG__sidebar.onShow();\n                }\n            ;\n            ;\n                areaMapper.disable(\"#nav_your_account_flyout\");\n                delayImpression = window.JSBNG__setTimeout(function() {\n                    var imp = {\n                        t: \"ya\"\n                    };\n                    if (((JSBNG__sidebar && JSBNG__sidebar.JSBNG__event))) {\n                        imp[JSBNG__sidebar.JSBNG__event] = 1;\n                    }\n                ;\n                ;\n                    logEv(imp);\n                }, 750);\n                if ($yaSidebar) {\n                    $yaSidebar.height($yaFlyout.height());\n                }\n            ;\n            ;\n                loadDynamicMenusConditionally();\n            };\n            var onHide = function() {\n                JSBNG__clearTimeout(delayImpression);\n                areaMapper.enable();\n                button.onHide();\n            };\n            var sidebarOffset = 0;\n            if (JSBNG__sidebar) {\n                sidebarOffset = ((JSBNG__sidebar.width + 19));\n                $yaSidebar = JSBNG__sidebar.getContent();\n                $yaFlyout.css(\"margin-left\", sidebarOffset).prepend($(\"\\u003Cdiv id=\\\"nav_ya_sidebar_wrapper\\\"\\u003E\\u003C/div\\u003E\").css({\n                    width: ((sidebarOffset - 15)),\n                    left: -sidebarOffset\n                }).append($yaSidebar));\n            }\n        ;\n        ;\n            var YALocationOffsetLeft = ((sidebarOffset ? -sidebarOffset : ((agent.ie6 ? ((leftAlignedYA ? 3 : -3)) : 0))));\n            button.registerTrigger({\n                localContent: \"#nav_your_account_flyout\",\n                locationAlign: ((leftAlignedYA ? \"left\" : \"right\")),\n                locationOffset: [YALocationOffsetLeft,0,],\n                skin: SKIN(jQButton, ((((leftAlignedYA || !agent.ie6)) ? 0 : 7))),\n                onShow: onShow,\n                onHide: onHide,\n                followLink: !agent.touch\n            });\n            if (signOutText) {\n                $(\"#nav-item-signout\").html(signOutText);\n            }\n        ;\n        ;\n            $Nav.declare(\"flyout.youraccount\");\n        });\n        $Nav.when(\"$\", \"$byID\", \"areaMapper\", \"agent\", \"logEvent\", \"triggerProceedToCheckout\", \"flyout.NavButton\", \"flyout.SKIN\", \"flyout.loadMenusConditionally\", \"nav.inline\", \"flyout.JSBNG__content\").run(\"Cart\", function($, $id, areaMapper, agent, logEv, triggerProceedToCheckout, NavButton, SKIN, loadDynamicMenusConditionally) {\n            if (((!$id(\"nav-cart\").length || !$id(\"nav_cart_flyout\").length))) {\n                return;\n            }\n        ;\n        ;\n            var id = \"nav-cart\", button = new NavButton(id), jQButton = $id(id), delayImpression;\n            var onShow = function() {\n                button.onShow();\n                areaMapper.disable(\"#nav_cart_flyout\");\n                delayImpression = window.JSBNG__setTimeout(function() {\n                    logEv({\n                        t: \"cart\"\n                    });\n                }, 750);\n                loadDynamicMenusConditionally();\n                triggerProceedToCheckout();\n            };\n            var onHide = function() {\n                JSBNG__clearTimeout(delayImpression);\n                areaMapper.enable();\n                button.onHide();\n            };\n            button.registerTrigger({\n                localContent: \"#nav_cart_flyout\",\n                locationAlign: \"right\",\n                locationOffset: [((agent.ie6 ? -3 : 0)),0,],\n                skin: SKIN(jQButton, ((agent.ie6 ? 7 : 0))),\n                onShow: onShow,\n                onHide: onHide,\n                followLink: !agent.touch\n            });\n            $Nav.declare(\"flyout.cart\");\n        });\n        $Nav.when(\"$\", \"$byID\", \"areaMapper\", \"agent\", \"logEvent\", \"flyout.NavButton\", \"flyout.SKIN\", \"flyout.loadMenusConditionally\", \"nav.inline\", \"flyout.JSBNG__content\").run(\"WishList\", function($, $id, areaMapper, agent, logEv, NavButton, SKIN, loadDynamicMenusConditionally) {\n            if (((!$id(\"nav-wishlist\").length || !$id(\"nav_wishlist_flyout\").length))) {\n                return;\n            }\n        ;\n        ;\n            var id = \"nav-wishlist\", button = new NavButton(id), jQButton = $id(id), flyout = \"#nav_wishlist_flyout\", ul = \".nav_pop_ul\", delayImpression;\n            var onShow = function() {\n                button.onShow();\n                areaMapper.disable(\"#nav_wishlist_flyout\");\n                delayImpression = window.JSBNG__setTimeout(function() {\n                    logEv({\n                        t: \"wishlist\"\n                    });\n                }, 750);\n                loadDynamicMenusConditionally();\n                var $flyout = $(flyout), width = $flyout.JSBNG__outerWidth();\n                $flyout.css(\"width\", width).JSBNG__find(ul).css(\"width\", width).addClass(\"nav_pop_ul_wrap\");\n            };\n            var onHide = function() {\n                JSBNG__clearTimeout(delayImpression);\n                $(flyout).css(\"width\", \"\").JSBNG__find(ul).css(\"width\", \"\").removeClass(\"nav_pop_ul_wrap\");\n                areaMapper.enable();\n                button.onHide();\n            };\n            button.registerTrigger({\n                localContent: \"#nav_wishlist_flyout\",\n                locationAlign: \"right\",\n                locationOffset: [((agent.ie6 ? -3 : 0)),0,],\n                skin: SKIN(jQButton, ((agent.ie6 ? 7 : 0))),\n                onShow: onShow,\n                onHide: onHide,\n                followLink: !agent.touch\n            });\n            $Nav.declare(\"flyout.wishlist\");\n        });\n        $Nav.when(\"$\", \"$byID\", \"flyout.NavButton\", \"areaMapper\", \"logEvent\", \"agent\", \"nav.inline\", \"flyout.JSBNG__content\").run(\"PrimeTooltip\", function($, $id, NavButton, areaMapper, logEv, agent) {\n            if (((!$id(\"nav-prime-ttt\").length || !$id(\"nav-prime-tooltip\").length))) {\n                return;\n            }\n        ;\n        ;\n            var id = \"nav-prime-ttt\", button = new NavButton(id), jQButton = $id(id), delayImpression, large = $(\"#navbar\").hasClass(\"nav-logo-large\"), msie = $.browser.msie;\n            var onShow = function() {\n                button.onShow();\n                areaMapper.disable(\"#nav-prime-tooltip\");\n                delayImpression = window.JSBNG__setTimeout(function() {\n                    logEv({\n                        t: \"prime-tt\"\n                    });\n                }, 750);\n            };\n            var onHide = function() {\n                JSBNG__clearTimeout(delayImpression);\n                areaMapper.enable();\n                button.onHide();\n            };\n            jQButton.css(\"padding-right\", ((large ? \"21px\" : \"25px\")));\n            button.registerTrigger({\n                localContent: \"#nav-prime-tooltip\",\n                width: null,\n                JSBNG__location: \"right\",\n                locationAlign: \"JSBNG__top\",\n                locationOffset: [((msie ? -3 : 0)),((large ? -35 : -26)),],\n                onShow: onShow,\n                onHide: onHide,\n                zIndex: 201,\n                skin: ((((((((((((((((((((\"\\u003Cdiv class=\\\"nav-tt-skin\" + ((large ? \" nav-logo-large\" : \"\")))) + \"\\\"\\u003E\")) + \"\\u003Cdiv class=\\\"nav-tt-border\")) + ((msie ? \"\" : \" nav-tt-box-shadow\")))) + \"\\\"\\u003E\")) + \"\\u003Cdiv class=\\\"ap_content\\\"\\u003E\\u003C/div\\u003E\")) + \"\\u003C/div\\u003E\")) + \"\\u003Cdiv class=\\\"nav-tt-beak\\\"\\u003E\\u003C/div\\u003E\")) + \"\\u003Cdiv class=\\\"nav-tt-beak-2\\\"\\u003E\\u003C/div\\u003E\")) + \"\\u003C/div\\u003E\")),\n                followLink: !agent.touch\n            });\n        });\n        $Nav.when(\"$byID\", \"areaMapper\", \"logEvent\", \"agent\", \"config.dynamicMenuArgs\", \"flyout.NavButton\", \"flyout.SKIN\", \"flyout.primeAjax\", \"flyout.loadMenusConditionally\", \"nav.inline\", \"flyout.JSBNG__content\").run(\"PrimeMenu\", function($id, areaMapper, logEv, agent, dynamicMenuArgs, NavButton, SKIN, primeAJAX, loadDynamicMenusConditionally) {\n            if (((!$id(\"nav-your-prime\").length || !$id(\"nav-prime-menu\").length))) {\n                return;\n            }\n        ;\n        ;\n            var id = \"nav-your-prime\", button = new NavButton(id), jQButton = $id(id), delayImpression;\n            if (primeAJAX) {\n                $id(\"nav-prime-menu\").css({\n                    width: dynamicMenuArgs.primeMenuWidth\n                });\n            }\n        ;\n        ;\n            var onShow = function() {\n                button.onShow();\n                areaMapper.disable(\"#nav-prime-menu\");\n                delayImpression = window.JSBNG__setTimeout(function() {\n                    logEv({\n                        t: \"prime\"\n                    });\n                }, 750);\n                if (primeAJAX) {\n                    loadDynamicMenusConditionally();\n                }\n            ;\n            ;\n            };\n            var onHide = function() {\n                JSBNG__clearTimeout(delayImpression);\n                areaMapper.enable();\n                button.onHide();\n            };\n            button.registerTrigger({\n                localContent: \"#nav-prime-menu\",\n                locationAlign: \"right\",\n                locationOffset: [((agent.ie6 ? -3 : 0)),0,],\n                skin: SKIN(jQButton, ((agent.ie6 ? 7 : 0))),\n                onShow: onShow,\n                onHide: onHide,\n                followLink: !agent.touch\n            });\n            $Nav.declare(\"flyout.prime\");\n        });\n        $Nav.when(\"$\", \"byID\", \"agent\", \"api.publish\", \"config.lightningDeals\", \"nav.inline\").run(\"UpdateAPI\", function($, byID, agent, publishAPI, lightningDealsData) {\n            var navbarAPIError = \"no error\";\n            publishAPI(\"error\", function() {\n                return navbarAPIError;\n            });\n            function update(navDataObject) {\n                var err = \"navbar.update() error: \";\n                if (((navDataObject instanceof Object))) {\n                    $Nav.getNow(\"unlockDynamicMenus\", function() {\n                    \n                    })();\n                    var closures = [];\n                    var cleanupClosures = [];\n                    if (navDataObject.catsubnav) {\n                        try {\n                            var navCatSubnav = $(\"#nav-subnav\");\n                            if (((navCatSubnav.length > 0))) {\n                                var svDigest = ((navDataObject.catsubnav.digest || \"\"));\n                                if (((!svDigest || ((svDigest !== navCatSubnav.attr(\"data-digest\")))))) {\n                                    var catSubnavChanges = 0;\n                                    var newCatSubnav = [];\n                                    var category = navDataObject.catsubnav.category;\n                                    if (((category && ((category.type == \"link\"))))) {\n                                        var navCatItem = $(\"li.nav-category-button:first\", navCatSubnav);\n                                        if (((navCatItem.length === 0))) {\n                                            throw \"category-1\";\n                                        }\n                                    ;\n                                    ;\n                                        var cDatum = category.data;\n                                        if (((!cDatum.href || !cDatum.text))) {\n                                            throw \"category-2\";\n                                        }\n                                    ;\n                                    ;\n                                        var newCat = navCatItem.clone();\n                                        var aCat = $(\"a:first\", newCat);\n                                        if (((aCat.length === 0))) {\n                                            throw \"category-3\";\n                                        }\n                                    ;\n                                    ;\n                                        aCat.attr(\"href\", cDatum.href).html(cDatum.text);\n                                        newCatSubnav.push(newCat.get(0));\n                                        catSubnavChanges += 1;\n                                    }\n                                ;\n                                ;\n                                    var subnav = navDataObject.catsubnav.subnav;\n                                    if (((subnav && ((subnav.type == \"linkSequence\"))))) {\n                                        var navSubItem = $(\"li.nav-subnav-item\", navCatSubnav).slice(-1);\n                                        if (((navSubItem.length === 0))) {\n                                            throw \"subnav-1\";\n                                        }\n                                    ;\n                                    ;\n                                        for (var i = 0; ((i < subnav.data.length)); i++) {\n                                            var datum = subnav.data[i];\n                                            if (((!datum.href || !datum.text))) {\n                                                throw \"subnav-2\";\n                                            }\n                                        ;\n                                        ;\n                                            var newItem = navSubItem.clone();\n                                            var aElem = $(\"a:first\", newItem);\n                                            if (((aElem.length === 0))) {\n                                                throw \"subnav-3\";\n                                            }\n                                        ;\n                                        ;\n                                            aElem.attr(\"href\", datum.href).html(datum.text);\n                                            newCatSubnav.push(newItem.get(0));\n                                        };\n                                    ;\n                                        if (((newCatSubnav.length > 1))) {\n                                            catSubnavChanges += 1;\n                                        }\n                                    ;\n                                    ;\n                                    }\n                                ;\n                                ;\n                                    var navbarDiv = $(\"#navbar\");\n                                    if (((navbarDiv.length === 0))) {\n                                        throw \"catsubnav-1\";\n                                    }\n                                ;\n                                ;\n                                    if (((catSubnavChanges == 2))) {\n                                        closures.push(function() {\n                                            navCatSubnav.empty().append(newCatSubnav).css(\"display\", \"\").attr(\"data-digest\", svDigest);\n                                            navbarDiv.addClass(\"nav-subnav\");\n                                        });\n                                    }\n                                     else {\n                                        if (((catSubnavChanges === 0))) {\n                                            closures.push(function() {\n                                                navbarDiv.removeClass(\"nav-subnav\");\n                                                navCatSubnav.css(\"display\", \"none\").attr(\"data-digest\", \"0\");\n                                            });\n                                        }\n                                    ;\n                                    ;\n                                    }\n                                ;\n                                ;\n                                }\n                            ;\n                            ;\n                            }\n                        ;\n                        ;\n                        } catch (e) {\n                            navbarAPIError = ((err + e));\n                            return false;\n                        };\n                    ;\n                    }\n                ;\n                ;\n                    if (navDataObject.cart) {\n                        try {\n                            var cart = navDataObject.cart;\n                            if (((((cart.type == \"countPlusLD\")) || ((cart.type == \"count\"))))) {\n                                if (!cart.data) {\n                                    throw \"cart-1\";\n                                }\n                            ;\n                            ;\n                                var newCount = ((cart.data.count + \"\"));\n                                if (!newCount.match(/^(|0|[1-9][0-9]*|99\\+)$/)) {\n                                    throw \"cart-2\";\n                                }\n                            ;\n                            ;\n                                var cartCounts = $(\"#nav-cart-count, #nav_cart_flyout .nav-cart-count\");\n                                if (((cartCounts.length > 0))) {\n                                    closures.push(function() {\n                                        var cartFullClass = \"nav-cart-0\";\n                                        if (((newCount == \"99+\"))) {\n                                            cartFullClass = \"nav-cart-100\";\n                                        }\n                                         else {\n                                            if (((newCount > 99))) {\n                                                newCount = \"99+\";\n                                                cartFullClass = \"nav-cart-100\";\n                                            }\n                                             else {\n                                                if (((newCount > 19))) {\n                                                    cartFullClass = \"nav-cart-20\";\n                                                }\n                                                 else {\n                                                    if (((newCount > 9))) {\n                                                        cartFullClass = \"nav-cart-10\";\n                                                    }\n                                                ;\n                                                ;\n                                                }\n                                            ;\n                                            ;\n                                            }\n                                        ;\n                                        ;\n                                        }\n                                    ;\n                                    ;\n                                        cartCounts.removeClass(\"nav-cart-0 nav-cart-10 nav-cart-20 nav-cart-100\").addClass(cartFullClass).html(newCount);\n                                        if (((((newCount === 0)) && byID(\"nav-cart-zero\")))) {\n                                            $(\"#nav-cart-one, #nav-cart-many\").hide();\n                                            $(\"#nav-cart-zero\").show();\n                                        }\n                                         else {\n                                            if (((newCount == 1))) {\n                                                $(\"#nav-cart-zero, #nav-cart-many\").hide();\n                                                $(\"#nav-cart-one\").show();\n                                            }\n                                             else {\n                                                $(\"#nav-cart-zero, #nav-cart-one\").hide();\n                                                $(\"#nav-cart-many\").show();\n                                            }\n                                        ;\n                                        ;\n                                        }\n                                    ;\n                                    ;\n                                    });\n                                }\n                            ;\n                            ;\n                                var LDData = cart.data.LDData;\n                                if (LDData) {\n                                    closures.push(function() {\n                                        lightningDealsData = LDData;\n                                    });\n                                }\n                            ;\n                            ;\n                            }\n                        ;\n                        ;\n                        } catch (e) {\n                            navbarAPIError = ((err + e));\n                            return false;\n                        };\n                    ;\n                    }\n                ;\n                ;\n                    if (navDataObject.searchbar) {\n                        try {\n                            var searchbar = navDataObject.searchbar;\n                            if (((searchbar.type == \"searchbar\"))) {\n                                if (!searchbar.data) {\n                                    throw \"searchbar-1\";\n                                }\n                            ;\n                            ;\n                                var options = searchbar.data.options;\n                                if (((!options || ((options.length === 0))))) {\n                                    throw \"searchbar-2\";\n                                }\n                            ;\n                            ;\n                                var sddMeta = ((searchbar.data[\"nav-metadata\"] || {\n                                }));\n                                var dropdown = $(\"#searchDropdownBox\");\n                                if (((dropdown.length === 0))) {\n                                    dropdown = $(\"#navSearchDropdown select:first\");\n                                }\n                            ;\n                            ;\n                                if (((dropdown.length === 0))) {\n                                    throw \"searchbar-3\";\n                                }\n                            ;\n                            ;\n                                if (((!sddMeta.digest || ((sddMeta.digest !== dropdown.attr(\"data-nav-digest\")))))) {\n                                    closures.push(function() {\n                                        dropdown.JSBNG__blur().empty();\n                                        for (var i = 0; ((i < options.length)); i++) {\n                                            var attrs = options[i];\n                                            var _display = ((attrs._display || \"\"));\n                                            delete attrs._display;\n                                            $(\"\\u003Coption\\u003E\\u003C/option\\u003E\").html(_display).attr(attrs).appendTo(dropdown);\n                                        };\n                                    ;\n                                        dropdown.attr(\"data-nav-digest\", ((sddMeta.digest || \"\"))).attr(\"data-nav-selected\", ((sddMeta.selected || 0)));\n                                        $Nav.getNow(\"refreshDropDownFacade\", function() {\n                                        \n                                        })();\n                                    });\n                                }\n                                 else {\n                                    if (((sddMeta.selected != dropdown.attr(\"data-nav-selected\")))) {\n                                        closures.push(function() {\n                                            dropdown.attr(\"data-nav-selected\", sddMeta.selected).get(0).selectedIndex = sddMeta.selected;\n                                            $Nav.getNow(\"refreshDropDownFacade\", function() {\n                                            \n                                            })();\n                                        });\n                                    }\n                                ;\n                                ;\n                                }\n                            ;\n                            ;\n                            }\n                        ;\n                        ;\n                        } catch (e) {\n                            navbarAPIError = ((err + e));\n                            return false;\n                        };\n                    ;\n                    }\n                ;\n                ;\n                    if (navDataObject.primeBadge) {\n                        try {\n                            var isPrime = navDataObject.primeBadge.isPrime;\n                            if (((isPrime.type == \"boolean\"))) {\n                                var navbarDiv = $(\"#navbar\");\n                                if (((navbarDiv.length === 0))) {\n                                    throw \"primeBadge-1\";\n                                }\n                            ;\n                            ;\n                                closures.push(function() {\n                                    if (isPrime.data) {\n                                        navbarDiv.addClass(\"nav-prime\");\n                                    }\n                                     else {\n                                        navbarDiv.removeClass(\"nav-prime\");\n                                    }\n                                ;\n                                ;\n                                });\n                            }\n                        ;\n                        ;\n                            var homeUrl = navDataObject.primeBadge.homeUrl;\n                            if (((homeUrl.type == \"html\"))) {\n                                var navLogoTag = $(\"#nav-logo\");\n                                if (((navLogoTag.length === 0))) {\n                                    throw \"primeBadge-2\";\n                                }\n                            ;\n                            ;\n                                if (homeUrl.data) {\n                                    closures.push(function() {\n                                        navLogoTag.attr(\"href\", homeUrl.data);\n                                    });\n                                }\n                            ;\n                            ;\n                            }\n                        ;\n                        ;\n                        } catch (e) {\n                            navbarAPIError = ((err + e));\n                            return false;\n                        };\n                    ;\n                    }\n                ;\n                ;\n                    if (navDataObject.swmSlot) {\n                        try {\n                            var swmContent = navDataObject.swmSlot.swmContent;\n                            if (((swmContent && ((swmContent.type == \"html\"))))) {\n                                var navSwmSlotDiv = $(\"#navSwmSlot\");\n                                if (((navSwmSlotDiv.length === 0))) {\n                                    throw \"swmContent-1\";\n                                }\n                            ;\n                            ;\n                                if (swmContent.data) {\n                                    closures.push(function() {\n                                        navSwmSlotDiv.html(swmContent.data);\n                                    });\n                                }\n                            ;\n                            ;\n                            }\n                        ;\n                        ;\n                            var swmHeight = navDataObject.swmSlot.height;\n                            if (((swmHeight && ((swmHeight.type == \"html\"))))) {\n                                var navWelcomeRowDiv = $(\"#welcomeRowTable\");\n                                if (((navWelcomeRowDiv.length === 0))) {\n                                    throw \"swmSlotHeight-1\";\n                                }\n                            ;\n                            ;\n                                closures.push(function() {\n                                    navWelcomeRowDiv.css(\"height\", ((swmHeight.data || \"\")));\n                                    var sizeRegex = /-(small|large)$/;\n                                    var navbar = $(\"#navbar\");\n                                    $(navbar.attr(\"class\").split(/\\s+/)).filter(function() {\n                                        return sizeRegex.test(this);\n                                    }).each(function() {\n                                        var isLarge = ((parseInt(((swmHeight.data || 0)), 10) > 40));\n                                        var newClass = this.replace(sizeRegex, ((isLarge ? \"-large\" : \"-small\")));\n                                        navbar.removeClass(this).addClass(newClass);\n                                    });\n                                });\n                            }\n                        ;\n                        ;\n                            var swmStyle = navDataObject.swmSlot.style;\n                            if (((swmStyle && ((swmStyle.type == \"html\"))))) {\n                                var navAdBackgroundStyleDiv = $(\"#nav-ad-background-style\");\n                                if (((navAdBackgroundStyleDiv.length === 0))) {\n                                    throw \"swmSlotStyle-1\";\n                                }\n                            ;\n                            ;\n                                closures.push(function() {\n                                    navAdBackgroundStyleDiv.attr(\"style\", ((swmStyle.data || \"\")));\n                                });\n                            }\n                        ;\n                        ;\n                        } catch (e) {\n                            navbarAPIError = ((err + e));\n                            return false;\n                        };\n                    ;\n                    }\n                ;\n                ;\n                    if (navDataObject.signInText) {\n                        try {\n                            var customerName = navDataObject.signInText.customerName;\n                            var greetingText = navDataObject.signInText.greetingText;\n                            if (((((customerName.type == \"html\")) && greetingText.type))) {\n                                var navSignInTitleSpan = $(\"#nav-signin-title\");\n                                if (((navSignInTitleSpan.length === 0))) {\n                                    throw \"signInText-1\";\n                                }\n                            ;\n                            ;\n                                var template = navSignInTitleSpan.attr(\"data-template\");\n                                if (((((template && greetingText.data)) && customerName.data))) {\n                                    template = template.replace(\"{helloText}\", greetingText.data);\n                                    template = template.replace(\"{signInText}\", customerName.data);\n                                    closures.push(function() {\n                                        navSignInTitleSpan.html(template);\n                                    });\n                                }\n                            ;\n                            ;\n                            }\n                        ;\n                        ;\n                        } catch (e) {\n                            navbarAPIError = ((err + e));\n                            return false;\n                        };\n                    ;\n                    }\n                ;\n                ;\n                    if (navDataObject.yourAccountLink) {\n                        try {\n                            var yourAccountLink = navDataObject.yourAccountLink;\n                            if (((yourAccountLink.type == \"html\"))) {\n                                var navYourAccountTag = $(\"#nav-your-account\");\n                                if (((navYourAccountTag.length === 0))) {\n                                    throw \"your-account-1\";\n                                }\n                            ;\n                            ;\n                                if (yourAccountLink.data) {\n                                    closures.push(function() {\n                                        navYourAccountTag.attr(\"href\", yourAccountLink.data);\n                                    });\n                                }\n                            ;\n                            ;\n                            }\n                        ;\n                        ;\n                        } catch (e) {\n                            navbarAPIError = ((err + e));\n                            return false;\n                        };\n                    ;\n                    }\n                ;\n                ;\n                    if (navDataObject.crossShop) {\n                        try {\n                            var yourAmazonText = navDataObject.crossShop;\n                            if (((yourAmazonText.type == \"html\"))) {\n                                var navYourAmazonTag = $(\"#nav-your-amazon\");\n                                if (((navYourAmazonTag.length === 0))) {\n                                    throw \"yourAmazonText-1\";\n                                }\n                            ;\n                            ;\n                                closures.push(function() {\n                                    if (((yourAmazonText.data && ((navYourAmazonTag.text() != yourAmazonText.data))))) {\n                                        navYourAmazonTag.html(yourAmazonText.data);\n                                    }\n                                ;\n                                ;\n                                });\n                            }\n                        ;\n                        ;\n                            cleanupClosures.push(function() {\n                                $(\"#nav-cross-shop-links\").css(\"display\", \"\");\n                            });\n                        } catch (e) {\n                            navbarAPIError = ((err + e));\n                            return false;\n                        };\n                    ;\n                    }\n                ;\n                ;\n                    if (((closures.length > 0))) {\n                        try {\n                            for (var i = 0; ((i < closures.length)); i++) {\n                                closures[i]();\n                            };\n                        ;\n                        } catch (e) {\n                            navbarAPIError = ((err + e));\n                            return false;\n                        } finally {\n                            for (var i = 0; ((i < cleanupClosures.length)); i++) {\n                                cleanupClosures[i]();\n                            };\n                        ;\n                        };\n                    ;\n                        return true;\n                    }\n                     else {\n                        navbarAPIError = ((err + ((navDataObject.error || \"unknown error\"))));\n                    }\n                ;\n                ;\n                }\n                 else {\n                    navbarAPIError = ((err + \"parameter not an Object\"));\n                }\n            ;\n            ;\n                return false;\n            };\n        ;\n            publishAPI(\"update\", update);\n            publishAPI(\"setCartCount\", function(newCartCount) {\n                return update({\n                    cart: {\n                        type: \"count\",\n                        data: {\n                            count: newCartCount\n                        }\n                    }\n                });\n            });\n            publishAPI(\"getLightningDealsData\", function() {\n                return ((lightningDealsData || {\n                }));\n            });\n            publishAPI(\"overrideCartButtonClick\", function(clickHandler) {\n                if (!agent.touch) {\n                    $(\"#nav-cart\").click(clickHandler);\n                }\n            ;\n            ;\n                $(\"#nav-cart-menu-button\").click(clickHandler);\n            });\n        });\n        $Nav.when(\"$\", \"$byID\", \"agent\", \"template\", \"nav.inline\").build(\"flyout.initBrowsePromos\", function($, $id, agent, template) {\n            var initialized = false;\n            return function() {\n                var browsepromos = $Nav.getNow(\"config.browsePromos\");\n                if (((!browsepromos || initialized))) {\n                    return;\n                }\n            ;\n            ;\n                initialized = true;\n                $(\"#nav_browse_flyout .nav_browse_subcat\").each(function() {\n                    var $this = $(this), promoID = $this.attr(\"data-nav-promo-id\");\n                    if (promoID) {\n                        var data = browsepromos[promoID];\n                        if (data) {\n                            if (data.promoType) {\n                                if (((data.promoType == \"wide\"))) {\n                                    $this.addClass(\"nav_super_cat\");\n                                }\n                            ;\n                            ;\n                                var mapID = ((\"nav_imgmap_\" + promoID)), vOffset = ((agent.ie6 ? 15 : 14)), bottom = ((parseInt(data.vertOffset, 10) - vOffset)), right = parseInt(data.horizOffset, 10), ie6Hack = ((agent.ie6 && /\\.png$/i.test(data.image))), imgSrc = ((ie6Hack ? $id(\"nav_trans_pixel\").attr(\"src\") : data.image)), $img = $(\"\\u003Cimg\\u003E\").attr({\n                                    src: imgSrc,\n                                    alt: data.alt,\n                                    useMap: ((\"#\" + mapID))\n                                }).addClass(\"nav_browse_promo\").css({\n                                    bottom: bottom,\n                                    right: right,\n                                    width: data.width,\n                                    height: data.height\n                                });\n                                $this.prepend($img);\n                                if (ie6Hack) {\n                                    $img.get(0).style.filter = ((((\"progid:DXImageTransform.Microsoft.AlphaImageLoader(src='\" + data.image)) + \"',sizingMethod='scale')\"));\n                                }\n                            ;\n                            ;\n                            }\n                             else {\n                                $this.prepend(template(\"#nav-tpl-asin-promo\", data));\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                    }\n                ;\n                ;\n                });\n            };\n        });\n        $Nav.when(\"$\", \"agent\", \"config.flyoutURL\", \"btf.full\").run(\"FlyoutContent\", function($, agent, flyoutURL) {\n            window._navbar.flyoutContent = function(flyouts) {\n                var invisibleDiv = $(\"\\u003Cdiv\\u003E\").appendTo(JSBNG__document.body).hide().get(0);\n                var html = \"\";\n                {\n                    var fin31keys = ((window.top.JSBNG_Replay.forInKeys)((flyouts))), fin31i = (0);\n                    var flyout;\n                    for (; (fin31i < fin31keys.length); (fin31i++)) {\n                        ((flyout) = (fin31keys[fin31i]));\n                        {\n                            if (flyouts.hasOwnProperty(flyout)) {\n                                html += flyouts[flyout];\n                            }\n                        ;\n                        ;\n                        };\n                    };\n                };\n            ;\n                invisibleDiv.innerHTML = html;\n                $Nav.declare(\"flyout.JSBNG__content\");\n            };\n            if (flyoutURL) {\n                var script = JSBNG__document.createElement(\"script\");\n                script.setAttribute(\"type\", \"text/javascript\");\n                script.setAttribute(\"src\", flyoutURL);\n                var head = ((JSBNG__document.head || JSBNG__document.getElementsByTagName(\"head\")[0]));\n                head.appendChild(script);\n            }\n             else {\n                $Nav.declare(\"flyout.JSBNG__content\");\n            }\n        ;\n        ;\n        });\n        $Nav.when(\"$\", \"$byID\", \"template\", \"config.enableDynamicMenus\", \"config.dynamicMenuUrl\", \"config.dynamicMenuArgs\", \"config.ajaxProximity\", \"flyout.primeAjax\", \"nav.inline\").run(\"DynamicAjaxMenu\", function($, $id, template, enableDynamicMenus, dynamicMenuUrl, dynamicMenuArgs, ajaxProximity, primeAJAX) {\n            var ajaxLoaded = !enableDynamicMenus, mouseHookTriggered = !enableDynamicMenus;\n            $Nav.declare(\"unlockDynamicMenus\", function() {\n                ajaxLoaded = false;\n                mouseHookTriggered = false;\n            });\n            var ajaxLock = false;\n            var preloadStarted;\n            function allowDynamicMenuRetry() {\n                JSBNG__setTimeout(function() {\n                    mouseHookTriggered = false;\n                }, 5000);\n            };\n        ;\n            function loadDynamicMenus() {\n                $Nav.when(\"flyout.JSBNG__content\").run(\"LoadDynamicMenu\", function() {\n                    if (((ajaxLock || ajaxLoaded))) {\n                        return;\n                    }\n                ;\n                ;\n                    ajaxLock = true;\n                    var wishlistParent = $id(\"nav_wishlist_flyout\");\n                    var cartParent = $id(\"nav_cart_flyout\");\n                    var allParents = $(wishlistParent).add(cartParent);\n                    var wishlistContent = $(\".nav_dynamic\", wishlistParent);\n                    var cartContent = $(\".nav_dynamic\", cartParent);\n                    if (primeAJAX) {\n                        var primeParent = $id(\"nav-prime-menu\");\n                        allParents = allParents.add(primeParent);\n                        var primeContent = $(\".nav_dynamic\", primeParent);\n                    }\n                ;\n                ;\n                    $Nav.getNow(\"preloadSpinner\", function() {\n                    \n                    })();\n                    allParents.addClass(\"nav-ajax-loading\").removeClass(\"nav-ajax-error nav-empty\");\n                    allParents.JSBNG__find(\".nav-ajax-success\").hide();\n                    $.AmazonPopover.updateBacking(\"navbar\");\n                    $.ajax({\n                        url: dynamicMenuUrl,\n                        data: dynamicMenuArgs,\n                        dataType: \"json\",\n                        cache: false,\n                        timeout: 10000,\n                        complete: function() {\n                            allParents.removeClass(\"nav-ajax-loading\");\n                            $.AmazonPopover.updateBacking(\"navbar\");\n                            ajaxLock = false;\n                        },\n                        error: function() {\n                            allParents.addClass(\"nav-ajax-error\");\n                            allowDynamicMenuRetry();\n                        },\n                        success: function(data) {\n                            data = $.extend({\n                                cartDataStatus: false,\n                                cartCount: 0,\n                                cart: [],\n                                wishlistDataStatus: false,\n                                wishlist: [],\n                                primeMenu: null\n                            }, data);\n                            if (data.cartDataStatus) {\n                                $Nav.getNow(\"api.setCartCount\", function() {\n                                \n                                })(data.cartCount);\n                            }\n                        ;\n                        ;\n                            function updateDynamicMenu(JSBNG__status, isEmpty, parentElem, rawHTML, templateID, contentElem) {\n                                if (JSBNG__status) {\n                                    if (isEmpty) {\n                                        parentElem.addClass(\"nav-empty\").removeClass(\"nav-full\");\n                                    }\n                                     else {\n                                        parentElem.addClass(\"nav-full\").removeClass(\"nav-empty\");\n                                    }\n                                ;\n                                ;\n                                    contentElem.html(((rawHTML || template(templateID, data))));\n                                    parentElem.JSBNG__find(\".nav-ajax-success\").show();\n                                }\n                                 else {\n                                    parentElem.addClass(\"nav-ajax-error\");\n                                }\n                            ;\n                            ;\n                            };\n                        ;\n                            if (primeAJAX) {\n                                updateDynamicMenu(!!data.primeMenu, !data.primeMenu, primeParent, data.primeMenu, null, primeContent);\n                            }\n                        ;\n                        ;\n                            updateDynamicMenu(data.cartDataStatus, ((data.cart.length === 0)), cartParent, null, \"#nav-tpl-cart\", cartContent);\n                            updateDynamicMenu(data.wishlistDataStatus, ((data.wishlist.length === 0)), wishlistParent, null, \"#nav-tpl-wishlist\", wishlistContent);\n                            if (((data.cartDataStatus && data.wishlistDataStatus))) {\n                                ajaxLoaded = true;\n                            }\n                             else {\n                                allowDynamicMenuRetry();\n                            }\n                        ;\n                        ;\n                        }\n                    });\n                });\n            };\n        ;\n            function loadDynamicMenusConditionally() {\n                if (!mouseHookTriggered) {\n                    loadDynamicMenus();\n                }\n            ;\n            ;\n                mouseHookTriggered = true;\n                if (!preloadStarted) {\n                    preloadStarted = true;\n                    $Nav.declare(\"JSBNG__event.prefetch\");\n                }\n            ;\n            ;\n                return true;\n            };\n        ;\n            $Nav.declare(\"flyout.loadMenusConditionally\", loadDynamicMenusConditionally);\n            function attachTriggers() {\n                var accumLeft = [], accumRight = [], accumTop = [], accumBottom = [];\n                $(\"#nav-wishlist, #nav-cart\").each(function(i, elem) {\n                    elem = $(elem);\n                    var pos = elem.offset();\n                    accumLeft.push(pos.left);\n                    accumTop.push(pos.JSBNG__top);\n                    accumRight.push(((pos.left + elem.width())));\n                    accumBottom.push(((pos.JSBNG__top + elem.height())));\n                });\n                var proximity = ((ajaxProximity || [0,0,0,0,]));\n                var left = ((Math.min.apply(Math, accumLeft) - proximity[3])), JSBNG__top = ((Math.min.apply(Math, accumTop) - proximity[0])), width = ((((Math.max.apply(Math, accumRight) + proximity[1])) - left)), height = ((((Math.max.apply(Math, accumBottom) + proximity[2])) - JSBNG__top));\n                $.AmazonPopover.mouseTracker.add([[left,JSBNG__top,width,height,],], {\n                    inside: false,\n                    mouseEnter: loadDynamicMenusConditionally,\n                    mouseLeave: function() {\n                        return true;\n                    }\n                });\n                $(\"#nav_wishlist_flyout, #nav_cart_flyout\").JSBNG__find(\".nav-try-again\").click(loadDynamicMenus);\n            };\n        ;\n            if (dynamicMenuUrl) {\n                $Nav.when(\"page.ready\").run(attachTriggers);\n            }\n        ;\n        ;\n        });\n        $Nav.when(\"$\", \"onOptionClick\", \"throttle\", \"byID\", \"$byID\", \"btf.lite\", \"nav.inline\").run(\"SearchDropdown\", function($, onOptionClick, throttle, byID, $id) {\n            var dropdownNode = byID(\"searchDropdownBox\"), dropdown = $(dropdownNode), facade = $id(\"nav-search-in\"), facadeContent = byID(\"nav-search-in-content\"), searchBox = $id(\"twotabsearchtextbox\"), searchBoxParent = (function(elem) {\n                if (elem.hasClass(\"nav-searchfield-width\")) {\n                    return elem;\n                }\n                 else {\n                    if (((elem.parent().size() > 0))) {\n                        return arguments.callee(elem.parent());\n                    }\n                     else {\n                        return searchBox.parent();\n                    }\n                ;\n                ;\n                }\n            ;\n            ;\n            }(searchBox)), facadePrefilled = (function() {\n                return ((((facadeContent.getAttribute && facadeContent.getAttribute(\"data-value\"))) || $(facadeContent).attr(\"data-value\")));\n            }()), state = {\n                isHover: false,\n                isFocus: false,\n                searchFocus: false,\n                searchHover: false\n            }, previousVal = null;\n            if ($.browser.msie) {\n                if (((parseFloat($.browser.version) < 7))) {\n                    $Nav.declare(\"refreshDropDownFacade\", function() {\n                    \n                    });\n                    return;\n                }\n            ;\n            ;\n                facade.addClass(\"ie\");\n            }\n        ;\n        ;\n            function tweakDropdownWidth() {\n                var facadeWidth = facade.width();\n                if (((dropdown.width() < facadeWidth))) {\n                    dropdown.width(facadeWidth);\n                }\n            ;\n            ;\n            };\n        ;\n            function updateActiveState() {\n                if (state.isFocus) {\n                    facade.addClass(\"JSBNG__focus\").removeClass(\"active\");\n                    var redraw = JSBNG__document.createElement(\"div\");\n                    facade.append(redraw);\n                    JSBNG__setTimeout(function() {\n                        redraw.parentNode.removeChild(redraw);\n                    }, 10);\n                }\n                 else {\n                    if (((((state.isHover || state.searchFocus)) || state.searchHover))) {\n                        facade.addClass(\"active\").removeClass(\"JSBNG__focus\");\n                    }\n                     else {\n                        facade.removeClass(\"active focus\");\n                    }\n                ;\n                ;\n                }\n            ;\n            ;\n            };\n        ;\n            function getSelected() {\n                var len = dropdownNode.children.length;\n                for (var i = 0; ((i < len)); i++) {\n                    if (dropdownNode.children[i].selected) {\n                        return $(dropdownNode.children[i]);\n                    }\n                ;\n                ;\n                };\n            ;\n                return dropdown.children(\"option:selected\");\n            };\n        ;\n            function redrawSearchBox() {\n                if ($.browser.msie) {\n                    return;\n                }\n            ;\n            ;\n                searchBox.css(\"padding-right\", ((parseInt(searchBox.css(\"padding-right\"), 10) ? 0 : 1)));\n            };\n        ;\n            function useAbbrDropdown() {\n                var facadeWidth = $(facadeContent).width();\n                if (((facadeWidth > 195))) {\n                    return true;\n                }\n            ;\n            ;\n                if (((((facadeWidth > 100)) && ((searchBoxParent.JSBNG__outerWidth() <= 400))))) {\n                    return true;\n                }\n            ;\n            ;\n                return false;\n            };\n        ;\n            function updateFacadeWidth() {\n                $(facade).add(facadeContent).css({\n                    width: \"auto\"\n                });\n                $(facadeContent).css({\n                    overflow: \"visible\"\n                });\n                if (useAbbrDropdown()) {\n                    $(facadeContent).css({\n                        width: 100,\n                        overflow: \"hidden\"\n                    });\n                }\n            ;\n            ;\n                JSBNG__setTimeout(function() {\n                    searchBoxParent.css({\n                        \"padding-left\": facade.width()\n                    });\n                    redrawSearchBox();\n                    tweakDropdownWidth();\n                }, 1);\n            };\n        ;\n            function updateFacade() {\n                var selected = getSelected(), selectedVal = selected.val();\n                if (((selectedVal != previousVal))) {\n                    var display = ((((previousVal || ((selectedVal != facadePrefilled)))) ? selected.html() : facadeContent.innerHTML));\n                    previousVal = selectedVal;\n                    if (((facadeContent.innerHTML != display))) {\n                        facadeContent.innerHTML = display;\n                        updateFacadeWidth();\n                    }\n                ;\n                ;\n                }\n            ;\n            ;\n                updateActiveState();\n            };\n        ;\n            function focusSearchBox() {\n                var iss = $Nav.getNow(\"iss\");\n                if (iss) {\n                    state[\"isFocus\"] = false;\n                    iss.JSBNG__focus();\n                }\n            ;\n            ;\n            };\n        ;\n            function keypressHandler(e) {\n                if (((e.which == 13))) {\n                    focusSearchBox();\n                }\n            ;\n            ;\n                if (((((e.which != 9)) && ((e.which != 16))))) {\n                    updateFacade();\n                }\n            ;\n            ;\n            };\n        ;\n            $Nav.declare(\"refreshDropDownFacade\", updateFacade);\n            function buildCallback(property, value) {\n                return function() {\n                    state[property] = value;\n                    updateActiveState();\n                };\n            };\n        ;\n            facade.get(0).className += \" nav-facade-active\";\n            updateFacade();\n            dropdown.change(updateFacade).keyup(keypressHandler).JSBNG__focus(buildCallback(\"isFocus\", true)).JSBNG__blur(buildCallback(\"isFocus\", false)).hover(buildCallback(\"isHover\", true), buildCallback(\"isHover\", false));\n            $Nav.when(\"dismissTooltip\").run(function(dismissTooltip) {\n                dropdown.JSBNG__focus(dismissTooltip);\n            });\n            onOptionClick(dropdown, function() {\n                focusSearchBox();\n                updateFacade();\n            });\n            $(window).resize(throttle(150, updateFacadeWidth));\n            $Nav.when(\"page.ready\").run(\"FixSearchDropdown\", function() {\n                if ((((((($(facadeContent).JSBNG__outerWidth(true) - facade.JSBNG__outerWidth())) >= 4)) || useAbbrDropdown()))) {\n                    updateFacadeWidth();\n                }\n            ;\n            ;\n                tweakDropdownWidth();\n                dropdown.css({\n                    JSBNG__top: Math.max(0, ((((facade.JSBNG__outerHeight() - dropdown.JSBNG__outerHeight())) / 2)))\n                });\n            });\n            $Nav.when(\"iss\").run(function(iss) {\n                iss.keydown(function(e) {\n                    JSBNG__setTimeout(function() {\n                        keypressHandler(e);\n                    }, 10);\n                });\n                $Nav.when(\"dismissTooltip\").run(function(dismissTooltip) {\n                    iss.keydown(dismissTooltip);\n                });\n                iss.onFocus(buildCallback(\"searchFocus\", true));\n                iss.onBlur(buildCallback(\"searchFocus\", false));\n                iss.onBlur(updateFacade);\n                if (iss.onSearchBoxHover) {\n                    iss.onSearchBoxHover(buildCallback(\"searchHover\", true), buildCallback(\"searchHover\", false));\n                }\n            ;\n            ;\n            });\n        });\n        $Nav.when(\"$\").build(\"Keycode\", function($) {\n            function Keycode(evt) {\n                this.evt = evt;\n                this.code = evt.keyCode;\n            };\n        ;\n            Keycode.prototype.isAugmented = function() {\n                return ((((this.evt.altKey || this.evt.ctrlKey)) || this.evt.metaKey));\n            };\n            Keycode.prototype.isAugmentor = function() {\n                return ((0 <= $.inArray(this.code, [0,16,20,17,18,224,91,93,])));\n            };\n            Keycode.prototype.isTextFieldControl = function() {\n                return ((0 <= $.inArray(this.code, [8,9,13,32,35,36,37,38,39,40,45,46,])));\n            };\n            Keycode.prototype.isControl = function() {\n                if (((this.code <= 46))) {\n                    return true;\n                }\n                 else {\n                    if (((((this.code >= 91)) && ((this.code <= 95))))) {\n                        return true;\n                    }\n                     else {\n                        if (((((this.code >= 112)) && ((this.code <= 145))))) {\n                            return true;\n                        }\n                    ;\n                    ;\n                    }\n                ;\n                ;\n                }\n            ;\n            ;\n                return false;\n            };\n            Keycode.prototype.isTab = function() {\n                return ((this.code === 9));\n            };\n            Keycode.prototype.isEnter = function() {\n                return ((this.code === 13));\n            };\n            Keycode.prototype.isBackspace = function() {\n                return ((this.code === 8));\n            };\n            return Keycode;\n        });\n        $Nav.when(\"$\", \"agent\", \"iss\", \"Keycode\", \"config.autoFocus\", \"nav.inline\").run(\"autoFocus\", function($, agent, iss, Keycode, enableAutoFocus) {\n            if (!enableAutoFocus) {\n                return;\n            }\n        ;\n        ;\n            if (agent.touch) {\n                return;\n            }\n        ;\n        ;\n            function JSBNG__getSelection() {\n                if (window.JSBNG__getSelection) {\n                    return window.JSBNG__getSelection().toString();\n                }\n                 else {\n                    if (JSBNG__document.selection) {\n                        return JSBNG__document.selection.createRange().text;\n                    }\n                     else {\n                        return \"\";\n                    }\n                ;\n                ;\n                }\n            ;\n            ;\n            };\n        ;\n            function canFocus() {\n                return (((((($(JSBNG__document).scrollTop() <= $(\"#nav-iss-attach\").offset().JSBNG__top)) && (($(JSBNG__document.activeElement).filter(\"input,select,textarea\").size() < 1)))) && ((JSBNG__getSelection() === \"\"))));\n            };\n        ;\n            var first = false;\n            if (canFocus()) {\n                iss.JSBNG__focus();\n                first = true;\n            }\n        ;\n        ;\n            iss.keydown(function(e) {\n                var key = new Keycode(e);\n                if (key.isAugmentor()) {\n                    return;\n                }\n            ;\n            ;\n                var isControl = key.isControl();\n                if (key.isAugmented()) {\n                    \"noop\";\n                }\n                 else {\n                    if (first) {\n                        if (!canFocus()) {\n                            iss.JSBNG__blur();\n                        }\n                         else {\n                            if (isControl) {\n                                iss.JSBNG__blur();\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                    }\n                     else {\n                        if (isControl) {\n                            if (!key.isTextFieldControl()) {\n                                iss.JSBNG__blur();\n                            }\n                             else {\n                                if (((((((((iss.keyword() === \"\")) && !key.isTab())) && !key.isEnter())) && !key.isBackspace()))) {\n                                    iss.JSBNG__blur();\n                                }\n                            ;\n                            ;\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                    }\n                ;\n                ;\n                }\n            ;\n            ;\n                first = false;\n            });\n            $(JSBNG__document).keydown(function(e) {\n                var key = new Keycode(e);\n                if (!canFocus()) {\n                    return;\n                }\n            ;\n            ;\n                if (key.isControl()) {\n                    return;\n                }\n            ;\n            ;\n                if (((key.isAugmentor() || key.isAugmented()))) {\n                    return;\n                }\n            ;\n            ;\n                iss.JSBNG__focus();\n            });\n        });\n        $Nav.when(\"$\", \"api.publish\", \"config.swmStyleData\").run(\"ExternalAPI\", function($, publishAPI, swmStyleData) {\n            publishAPI(\"unHideSWM\", function() {\n                var $h = $(\"#navHiddenSwm\");\n                var s = swmStyleData;\n                if ($h.length) {\n                    $(\"#navbar\").removeClass(\"nav-logo-small nav-logo-large\").addClass(((\"nav-logo-\" + ((((parseInt(((s.height || 0)), 10) > 40)) ? \"large\" : \"small\")))));\n                    $(\"#welcomeRowTable\").css(\"height\", ((s.height || \"\")));\n                    var $swm = $(\"#navSwmSlot\");\n                    $swm.parent().attr(\"style\", ((s.style || \"\")));\n                    $swm.children().css(\"display\", \"none\");\n                    $h.css(\"display\", \"\");\n                }\n            ;\n            ;\n            });\n            var exposeState;\n            publishAPI(\"exposeSBD\", function(expose) {\n                exposeState = expose;\n                $Nav.when(\"initExposeSBD\", \"protectExposeSBD\").run(function(initExposeSBD, protectExposeSBD) {\n                    if (initExposeSBD().ok()) {\n                        protectExposeSBD(exposeState);\n                    }\n                ;\n                ;\n                });\n            });\n            publishAPI(\"navDimensions\", function() {\n                var elem = $(\"#navbar\");\n                var result = elem.offset();\n                result.height = elem.height();\n                result.bottom = ((result.JSBNG__top + result.height));\n                return result;\n            });\n            $Nav.when(\"api.unHideSWM\", \"api.exposeSBD\", \"api.navDimensions\").publish(\"navbarJSLoaded\");\n        });\n    }(window.$Nav));\n    if (((!window.$SearchJS && window.$Nav))) {\n        window.$SearchJS = $Nav.make();\n    }\n;\n;\n    if (window.$SearchJS) {\n        $SearchJS.importEvent(\"legacy-popover\", {\n            as: \"popover\",\n            amznJQ: \"popover\",\n            global: \"jQuery.AmazonPopover\"\n        });\n        $SearchJS.when(\"jQuery\", \"popover\").run(function($, AmazonPopover) {\n            $.fn.amznFlyoutIntent = function(arg) {\n                var defaults = {\n                    getTarget: function(el) {\n                        return $(this).children(\"*[position=\\\"absolute\\\"]\").eq(0);\n                    },\n                    triggerAxis: \"y\",\n                    majorDelay: 300,\n                    minorDelay: 100,\n                    targetSlopY: 50,\n                    targetSlopX: 50,\n                    cursorSlopBase: 25,\n                    cursorSlopHeight: 50,\n                    mtRegions: []\n                }, nameSp = \"amznFlyoutIntent\", mt = AmazonPopover.mouseTracker, getRect = function(el, slopX, slopY) {\n                    var off = el.offset(), tl = {\n                        x: ((off.left - ((slopX || 0)))),\n                        y: ((off.JSBNG__top - ((slopY || 0))))\n                    }, br = {\n                        x: ((((tl.x + el.JSBNG__outerWidth())) + ((((slopX || 0)) * 2)))),\n                        y: ((((tl.y + el.JSBNG__outerHeight())) + ((((slopY || 0)) * 2))))\n                    };\n                    return [tl,br,];\n                }, triBC = function(tri) {\n                    var t0 = tri[0], t1 = tri[1], t2 = tri[2];\n                    return ((((((t1.x - t0.x)) * ((t2.y - t0.y)))) - ((((t2.x - t0.x)) * ((t1.y - t0.y))))));\n                }, isInTri = function(p, tri) {\n                    var b0 = ((1 / triBC(tri))), t0 = tri[0], t1 = tri[1], t2 = tri[2];\n                    return ((((((((triBC([t1,t2,p,]) * b0)) > 0)) && ((((triBC([t2,t0,p,]) * b0)) > 0)))) && ((((triBC([t0,t1,p,]) * b0)) > 0))));\n                }, clamp = function(p, r) {\n                    var r0 = r[0], r1 = r[1];\n                    return {\n                        x: ((((p.x < r0.x)) ? -1 : ((((p.x > r1.x)) ? 1 : 0)))),\n                        y: ((((p.y < r0.y)) ? -1 : ((((p.y > r1.y)) ? 1 : 0))))\n                    };\n                }, isInRect = function(p, rect) {\n                    var c = clamp(p, rect);\n                    return ((((c.x == 0)) && ((c.y == 0))));\n                }, sel = function(a, b, a0, a1, b0, b1, d) {\n                    return ((((a < 0)) ? a0 : ((((a > 0)) ? a1 : ((((b < 0)) ? b0 : ((((b > 0)) ? b1 : d))))))));\n                }, getExtremePoints = function(p, rect) {\n                    var c = clamp(p, rect), cx = c.x, cy = c.y, r0 = rect[0], r1 = rect[1], r0x = r0.x, r0y = r0.y, r1x = r1.x, r1y = r1.y;\n                    return [{\n                        x: sel(cy, cx, r0x, r1x, r0x, r1x, 0),\n                        y: sel(cx, cy, r1y, r0y, r0y, r1y, 0)\n                    },{\n                        x: sel(cy, cx, r1x, r0x, r0x, r1x, 0),\n                        y: sel(cx, cy, r0y, r1y, r0y, r1y, 0)\n                    },];\n                }, isInCone = function(cursor, p1, cfg) {\n                    var slopRect = $.extend(true, [], cfg.slopRect), sy = cfg.targetSlopY, sx = cfg.targetSlopX, c = clamp(p1, cfg.targetRect), cx = c.x, cy = c.y, sh = cfg.cursorSlopHeight, sb = cfg.cursorSlopBase, p = $.extend({\n                    }, p1), q = $.extend({\n                    }, p1), exP;\n                    if (((cy == 0))) {\n                        slopRect[((((cx < 0)) ? 0 : 1))].x -= ((sy * cx));\n                    }\n                     else {\n                        if (((cx == 0))) {\n                            slopRect[((((cy < 0)) ? 0 : 1))].y -= ((sb * cy));\n                        }\n                    ;\n                    ;\n                    }\n                ;\n                ;\n                    if (((cfg.triggerAxis === \"x\"))) {\n                        p.y = q.y -= ((sb * cy));\n                        p.x -= sh;\n                        q.x += sh;\n                    }\n                     else {\n                        q.x = p.x -= ((sb * cx));\n                        p.y -= ((sh * cx));\n                        q.y += ((sh * cx));\n                    }\n                ;\n                ;\n                    exP = getExtremePoints(p1, slopRect);\n                    return ((((isInTri(cursor, [p1,exP[0],exP[1],]) || isInTri(cursor, [p1,exP[0],p,]))) || isInTri(cursor, [p1,exP[1],q,])));\n                }, calcChangeDelay = function(c, rect, p1, p2, cfg) {\n                    var delay = 0;\n                    p1 = ((p1 || {\n                    }));\n                    p2 = ((p2 || {\n                    }));\n                    if (isInRect(c, rect)) {\n                        delay = -1;\n                    }\n                     else {\n                        if (isInCone(c, p1, cfg)) {\n                            delay = cfg.majorDelay;\n                        }\n                         else {\n                            if (((((((Math.abs(((c.x - p1.x))) < 10)) && ((Math.abs(((c.y - p1.y))) < 10)))) && isInCone(c, p2, cfg)))) {\n                                delay = cfg.minorDelay;\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                    }\n                ;\n                ;\n                    return delay;\n                }, changeTrigger = function(el, cfg) {\n                    ((((cfg.triggerEl && cfg.onMouseOut)) && cfg.onMouseOut.call(cfg.triggerEl.get(0))));\n                    cfg.onMouseOver.call(el.get(0));\n                    if (!cfg.targets) {\n                        cfg.targets = {\n                        };\n                    }\n                ;\n                ;\n                    var tgt = cfg.targets[el];\n                    if (!tgt) {\n                        cfg.targets[el] = tgt = {\n                            triggerEl: $(el)\n                        };\n                        tgt.targetEl = cfg.getTarget.call(el.get(0));\n                        tgt.targetRect = getRect(tgt.targetEl);\n                        tgt.slopRect = getRect(tgt.targetEl, cfg.targetSlopY, cfg.targetSlopX);\n                    }\n                ;\n                ;\n                    cfg.triggerEl = tgt.triggerEl;\n                    cfg.targetEl = tgt.targetEl;\n                    cfg.targetRect = tgt.targetRect;\n                    cfg.slopRect = tgt.slopRect;\n                }, m = {\n                    destroy: function() {\n                        var cfg = this.data(nameSp), i;\n                        if (cfg) {\n                            JSBNG__clearTimeout(cfg.timeoutId);\n                            for (i = 0; ((i < cfg.mtRegions.length)); i++) {\n                                mt.remove(cfg.mtRegions[i]);\n                            };\n                        ;\n                            this.removeData(nameSp);\n                        }\n                    ;\n                    ;\n                    },\n                    init: function(opts) {\n                        var cfg = this.data(nameSp);\n                        if (!cfg) {\n                            cfg = $.extend(defaults, opts);\n                            this.data(nameSp, cfg);\n                        }\n                    ;\n                    ;\n                        return this.each(function() {\n                            var $this = $(this), off = $this.offset(), mouseLeave = function(immediately, args) {\n                                ((((cfg.onMouseLeave && this.el)) && cfg.onMouseLeave.call(this.el.get(0))));\n                                return true;\n                            }, mouseEnter = function(args) {\n                                JSBNG__clearTimeout(cfg.timeoutId);\n                                var trigger, changeDelay, doDelayedChange;\n                                ((((cfg.onMouseEnter && this.el)) && cfg.onMouseEnter.call(this.el.get(0))));\n                                if (((((cfg.triggerEl && this.el)) && ((cfg.triggerEl !== this.el))))) {\n                                    trigger = this.el;\n                                    changeDelay = ((cfg.targetRect ? calcChangeDelay(args.cursor, cfg.targetRect, args.priorCursors[0], args.priorCursors[1], cfg) : -1));\n                                    if (((cfg.triggerEl && ((changeDelay > 0))))) {\n                                        doDelayedChange = function() {\n                                            var delayedArgs = mt.getCallbackArgs(), nextDelay = 0;\n                                            JSBNG__clearTimeout(cfg.timeoutId);\n                                            if (((((cfg.priorCursor && ((cfg.priorCursor.x === delayedArgs.cursor.x)))) && ((cfg.priorCursor.y === delayedArgs.cursor.y))))) {\n                                                nextDelay = ((isInRect(delayedArgs.cursor, cfg.targetRect) ? -1 : 0));\n                                            }\n                                             else {\n                                                nextDelay = calcChangeDelay(delayedArgs.cursor, cfg.targetRect, delayedArgs.priorCursors[0], delayedArgs.priorCursors[1], cfg);\n                                            }\n                                        ;\n                                        ;\n                                            cfg.priorCursor = {\n                                                x: delayedArgs.cursor.x,\n                                                y: delayedArgs.cursor.y\n                                            };\n                                            if (((((nextDelay > 0)) && ((cfg.triggerEl.get(0) !== trigger.get(0)))))) {\n                                                cfg.timeoutId = JSBNG__setTimeout(function() {\n                                                    doDelayedChange.call(trigger);\n                                                }, nextDelay);\n                                            }\n                                             else {\n                                                if (((nextDelay > -1))) {\n                                                    if (isInRect(delayedArgs.cursor, getRect(trigger))) {\n                                                        changeTrigger(trigger, cfg);\n                                                    }\n                                                     else {\n                                                        ((cfg.onMouseOut && cfg.onMouseOut.call(trigger.get(0))));\n                                                    }\n                                                ;\n                                                ;\n                                                }\n                                            ;\n                                            ;\n                                            }\n                                        ;\n                                        ;\n                                        };\n                                        cfg.timeoutId = JSBNG__setTimeout(doDelayedChange, changeDelay);\n                                    }\n                                     else {\n                                        changeTrigger(this.el, cfg);\n                                    }\n                                ;\n                                ;\n                                }\n                                 else {\n                                    changeTrigger(this.el, cfg);\n                                }\n                            ;\n                            ;\n                                return true;\n                            };\n                            cfg.mtRegions.push(mt.add([[off.left,off.JSBNG__top,$this.JSBNG__outerWidth(),$this.JSBNG__outerHeight(),],], {\n                                inside: false,\n                                mouseEnter: mouseEnter,\n                                mouseLeave: mouseLeave,\n                                el: $this\n                            }));\n                        });\n                    }\n                };\n                if (m[arg]) {\n                    return m[arg].apply(this, Array.prototype.slice.call(arguments, 1));\n                }\n            ;\n            ;\n                if (((((typeof arg === \"object\")) || !arg))) {\n                    return m.init.apply(this, arguments);\n                }\n            ;\n            ;\n                return this;\n            };\n            $SearchJS.publish(\"amznFlyoutIntent\");\n        });\n        $SearchJS.when(\"jQuery\", \"amznFlyoutIntent\").run(function($) {\n            (function(window, undefined) {\n                var merchRE = /^me=/, refre = /(ref=[-\\w]+)/, ltrimre = /^\\s+/, spaceNormRe = /\\s+/g, ddre = /_dd_/, ddaliasre = /(dd_[a-z]{3,4})(_|$)[\\w]*/, deptre = /\\{department\\}/g, slashre = /\\+/g, aliasre = /search-alias\\s*=\\s*([\\w-]+)/, nodere = /node\\s*=\\s*([\\d]+)/, merchantre = /^me=([0-9A-Z]*)/, noissre = /ref=nb_sb_noss/, dcs = \"#ddCrtSel\", sdpc = \"searchDropdown_pop_conn\", tostr = Object.prototype.toString, ddBox, metrics = {\n                    isEnabled: ((((typeof uet == \"function\")) && ((typeof uex == \"function\")))),\n                    init: \"iss-init-pc\",\n                    completionsRequest0: \"iss-c0-pc\",\n                    completionsRequestSample: \"iss-cs-pc\",\n                    sample: 2,\n                    noFocusTag: \"iss-on-time\",\n                    focusTag: \"iss-late\"\n                };\n                $.isArray = (($.isArray || function(o) {\n                    return ((tostr.call(o) === \"[object Array]\"));\n                }));\n                var SS = function(sb, pe, displayHtml, handlers) {\n                    var node, noOp = function() {\n                    \n                    }, defaults = {\n                        afterCreate: noOp,\n                        beforeShow: noOp,\n                        afterShow: noOp,\n                        beforeHide: noOp,\n                        beforeHtmlChange: noOp,\n                        afterHtmlChange: noOp,\n                        onWindowResize: noOp\n                    }, events = $.extend({\n                    }, defaults, handlers);\n                    function create() {\n                        node = $(displayHtml).appendTo(((pe || sb.parent())));\n                        events.afterCreate.call(node);\n                        $(window).resize(function(e) {\n                            events.onWindowResize.call(node, e);\n                        });\n                        return node;\n                    };\n                ;\n                    function get() {\n                        return ((node || create()));\n                    };\n                ;\n                    function setHtml(h) {\n                        events.beforeHtmlChange.call(get(), h);\n                        get().html(h);\n                        events.afterHtmlChange.call(get(), h);\n                        return this;\n                    };\n                ;\n                    this.getNode = get;\n                    this.html = setHtml;\n                    this.visible = function() {\n                        if (node) {\n                            return ((node.css(\"display\") != \"none\"));\n                        }\n                    ;\n                    ;\n                        return false;\n                    };\n                    this.hide = function() {\n                        events.beforeHide.call(get());\n                        get().hide();\n                        setHtml(\"\");\n                        return this;\n                    };\n                    this.show = function() {\n                        events.beforeShow.call(get());\n                        get().show();\n                        events.afterShow.call(get());\n                        return this;\n                    };\n                };\n                var IAC = function(sb, pe, iac, newDesign) {\n                    var sbPlaceHolder, sbPlaceHolderDiv, sbNode, sbDiv, iacNode, iacDiv, widthDiv, canShowIAC = true, iacType = 0;\n                    function get() {\n                        return ((iacNode || create()));\n                    };\n                ;\n                    function create() {\n                        var p = sb.pos(true), d = sb.size(true), sbPlaceHolderCss = {\n                            JSBNG__top: p.JSBNG__top,\n                            left: p.left,\n                            width: \"100%\",\n                            border: \"2px inset\"\n                        }, sbPlaceHolderCssOverride = {\n                            background: \"none repeat scroll 0 0 transparent\",\n                            color: \"black\",\n                            \"font-family\": \"arial,sans-serif\",\n                            \"font-size\": \"12pt\",\n                            height: \"23px\",\n                            margin: \"7px 0 0\",\n                            outline: \"0 none\",\n                            padding: 0,\n                            border: \"0 none\"\n                        }, iacNodeCss = {\n                            left: p.left,\n                            width: d.width,\n                            JSBNG__top: p.JSBNG__top,\n                            \"z-index\": 1,\n                            color: \"#999\",\n                            position: \"absolute\",\n                            \"background-color\": \"#FFF\"\n                        }, iacNodeCssOverride = {\n                            left: ((p.left + 5)),\n                            width: ((d.width - 5)),\n                            border: \"0 none\",\n                            \"font-family\": \"arial,sans-serif\",\n                            \"font-size\": \"12pt\",\n                            height: \"23px\",\n                            margin: \"7px 0 0\",\n                            outline: \"0 none\",\n                            padding: 0\n                        };\n                        sbPlaceHolder = $(\"\\u003Cinput id='sbPlaceHolder' class='searchSelect' readOnly='true'/\\u003E\").css(sbPlaceHolderCss).css(((newDesign ? sbPlaceHolderCssOverride : {\n                        }))).appendTo(((pe || sb.parent())));\n                        sbPlaceHolderDiv = sbPlaceHolder.get(0);\n                        sbNode = $(\"#twotabsearchtextbox\").css({\n                            position: \"absolute\",\n                            background: \"none repeat scroll 0 0 transparent\",\n                            \"z-index\": 5,\n                            width: d.width\n                        });\n                        sbDiv = sbNode.get(0);\n                        iacNode = $(\"\\u003Cinput id='inline_auto_complete' class='searchSelect' readOnly='true'/\\u003E\").css(iacNodeCss).css(((newDesign ? iacNodeCssOverride : {\n                        }))).appendTo(((pe || sb.parent())));\n                        iacDiv = iacNode.get(0);\n                        JSBNG__setInterval(adjust, 200);\n                        sbNode.keydown(keyDown);\n                        if (newDesign) {\n                            widthDiv = sb.parent().parent();\n                        }\n                    ;\n                    ;\n                        return iacNode;\n                    };\n                ;\n                    function adjust() {\n                        var p = sb.pos(), d = sb.size(), adjustment = 0, w = d.width;\n                        if (newDesign) {\n                            adjustment = 5;\n                            w = ((widthDiv.width() - adjustment));\n                        }\n                    ;\n                    ;\n                        sbNode.css({\n                            left: ((p.left + adjustment)),\n                            JSBNG__top: p.JSBNG__top,\n                            width: w\n                        });\n                        iacNode.css({\n                            left: ((p.left + adjustment)),\n                            JSBNG__top: p.JSBNG__top,\n                            width: w\n                        });\n                    };\n                ;\n                    function keyDown(JSBNG__event) {\n                        var value = get().val();\n                        get().val(\"\");\n                        var key = JSBNG__event.keyCode;\n                        switch (key) {\n                          case 8:\n                        \n                          case 37:\n                        \n                          case 46:\n                            if (((value && ((value.length > 0))))) {\n                                JSBNG__event.preventDefault();\n                            }\n                        ;\n                        ;\n                            iacType = 0;\n                            canShowIAC = false;\n                            break;\n                          case 32:\n                            iacType = 0;\n                            canShowIAC = false;\n                            break;\n                          case 13:\n                            if (((iac == 2))) {\n                                break;\n                            }\n                        ;\n                        ;\n                          case 39:\n                            if (((value && ((value.length > 0))))) {\n                                sb.keyword(value);\n                                iacType = ((((key == 13)) ? 1 : 2));\n                            }\n                        ;\n                        ;\n                            canShowIAC = true;\n                            break;\n                          case 16:\n                        \n                          case 17:\n                        \n                          case 18:\n                        \n                          case 20:\n                        \n                          case 229:\n                            get().val(value);\n                          default:\n                            iacType = 0;\n                            canShowIAC = true;\n                            break;\n                        };\n                    ;\n                    };\n                ;\n                    this.val = function(value) {\n                        if (((value !== undefined))) {\n                            get().val(value);\n                        }\n                    ;\n                    ;\n                        return get().val();\n                    };\n                    this.clear = function() {\n                        get().val(\"\");\n                    };\n                    this.type = function() {\n                        return iacType;\n                    };\n                    this.displayable = function(showIAC) {\n                        if (((showIAC !== undefined))) {\n                            canShowIAC = showIAC;\n                        }\n                    ;\n                    ;\n                        return canShowIAC;\n                    };\n                    this.touch = function() {\n                        get();\n                        return true;\n                    };\n                };\n                var IH = function(updateFunc) {\n                    var curIme, ku, kd, updateKwChange = updateFunc;\n                    function clearCurIme() {\n                        kd = ku = undefined, curIme = \"\";\n                    };\n                ;\n                    function keydown(keyCode) {\n                        return ((keyCode ? kd = keyCode : kd));\n                    };\n                ;\n                    function update(sbCurText) {\n                        if (updateKwChange) {\n                            updateKwChange(((((sbCurText && ((sbCurText.length > 0)))) ? ((sbCurText + curIme)) : curIme)));\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    function keyup(keyCode, sbCurText) {\n                        if (((keyCode != undefined))) {\n                            ku = keyCode;\n                            if (((((curIme && ((curIme.length > 0)))) && ((((ku == 8)) || ((ku == 46))))))) {\n                                curIme = curIme.substring(0, ((curIme.length - 1)));\n                                update(sbCurText);\n                            }\n                             else {\n                                if (((((ku >= 65)) && ((ku <= 90))))) {\n                                    var kchar = String.fromCharCode(ku);\n                                    curIme += kchar;\n                                    update(sbCurText);\n                                }\n                            ;\n                            ;\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                        return ku;\n                    };\n                ;\n                    function shouldHandle() {\n                        return ((((kd == 229)) || ((kd == 197))));\n                    };\n                ;\n                    this.keydown = keydown;\n                    this.keyup = keyup;\n                    this.isImeInput = shouldHandle;\n                    this.reset = clearCurIme;\n                };\n                var SB = function(sb, h) {\n                    var curText, curSel, latestUserInput, navIssAttach, sbPlaceHolder, imeUsed = false, ih = ((h.opt.imeEnh && new IH(function(val) {\n                        updateKwChange(val);\n                    })));\n                    init();\n                    function init() {\n                        if (metrics.isEnabled) {\n                            ue.tag(((((sb.get(0) === JSBNG__document.activeElement)) ? metrics.focusTag : metrics.noFocusTag)));\n                        }\n                    ;\n                    ;\n                        sb.keydown(keyDown).keyup(keyUp).keypress(keyPress).JSBNG__blur(blurHandler).JSBNG__focus(focusHandler).click(clickHandler);\n                        latestUserInput = curText = kw();\n                        ((h.newDesign && (navIssAttach = $(\"#nav-iss-attach\"))));\n                    };\n                ;\n                    function kw(k) {\n                        if (((k !== undefined))) {\n                            curText = curSel = k;\n                            sb.val(k);\n                        }\n                    ;\n                    ;\n                        return sb.val().replace(ltrimre, \"\").replace(spaceNormRe, \" \");\n                    };\n                ;\n                    function input(k) {\n                        if (((k !== undefined))) {\n                            latestUserInput = k;\n                        }\n                    ;\n                    ;\n                        return latestUserInput;\n                    };\n                ;\n                    function keyDown(e) {\n                        var key = e.keyCode, d = ((((key == 38)) ? -1 : ((((key == 40)) ? 1 : 0))));\n                        if (ih) {\n                            ih.keydown(key);\n                        }\n                    ;\n                    ;\n                        imeUsed = ((((((key == 229)) || ((key == 197)))) ? true : ((((((((key >= 48)) && ((key <= 57)))) || ((((key >= 65)) && ((key <= 90)))))) ? false : imeUsed))));\n                        if (((h.opt.twoPane === 1))) {\n                            return h.twoPaneArrowKeyHandler(e);\n                        }\n                    ;\n                    ;\n                        if (d) {\n                            h.adjust(d);\n                            if (((kw() != \"\"))) {\n                                e.preventDefault();\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                        if (h.opt.doCTW) {\n                            h.opt.doCTW(e);\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    function keyUp(e) {\n                        var key = e.keyCode;\n                        switch (key) {\n                          case 13:\n                            h.hide();\n                            break;\n                          case 27:\n                            return h.dismiss();\n                          case 37:\n                        \n                          case 38:\n                        \n                          case 39:\n                        \n                          case 40:\n                            break;\n                          default:\n                            if (((ih && ih.isImeInput()))) {\n                                ih.keyup(key, curText);\n                            }\n                             else {\n                                update(true);\n                            }\n                        ;\n                        ;\n                            break;\n                        };\n                    ;\n                    };\n                ;\n                    function keyPress(e) {\n                        var key = e.keyCode;\n                        switch (key) {\n                          case 13:\n                            return h.submitEnabled();\n                          default:\n                            h.keyPress();\n                            break;\n                        };\n                    ;\n                    };\n                ;\n                    function updateKwChange(val) {\n                        input(val);\n                        h.change(val);\n                    };\n                ;\n                    function update(dontCheckCurSel) {\n                        var val = kw();\n                        if (((((val != curText)) && ((dontCheckCurSel || ((val != curSel))))))) {\n                            curText = val;\n                            updateKwChange(val);\n                            if (ih) {\n                                ih.reset();\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    function focusHandler(e) {\n                        if (ih) {\n                            ih.reset();\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    function blurHandler(e) {\n                        h.dismiss();\n                        if (ih) {\n                            ih.reset();\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    function clickHandler(e) {\n                        h.click(kw());\n                        if (ih) {\n                            ih.reset();\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    function getSbPlaceHolder() {\n                        if (!sbPlaceHolder) {\n                            sbPlaceHolder = $(\"#sbPlaceHolder\");\n                        }\n                    ;\n                    ;\n                        return sbPlaceHolder;\n                    };\n                ;\n                    this.keyword = function(k) {\n                        return kw(k);\n                    };\n                    this.userInput = function(k) {\n                        return input(k);\n                    };\n                    this.size = function(nonIAC) {\n                        var e = sb;\n                        if (h.newDesign) {\n                            e = navIssAttach;\n                        }\n                         else {\n                            if (((((!nonIAC && h.iac)) && h.checkIAC()))) {\n                                e = getSbPlaceHolder();\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                        return {\n                            width: e.JSBNG__outerWidth(),\n                            height: e.JSBNG__outerHeight()\n                        };\n                    };\n                    this.pos = function(nonIAC) {\n                        var e = sb;\n                        if (h.newDesign) {\n                            e = navIssAttach;\n                        }\n                         else {\n                            if (((((!nonIAC && h.iac)) && h.checkIAC()))) {\n                                e = getSbPlaceHolder();\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                        return e.position();\n                    };\n                    this.offset = function(nonIAC) {\n                        var e = sb;\n                        if (((((!nonIAC && h.iac)) && h.checkIAC()))) {\n                            e = getSbPlaceHolder();\n                        }\n                    ;\n                    ;\n                        return e.offset();\n                    };\n                    this.parent = function() {\n                        return sb.parent();\n                    };\n                    this.hasFocus = function() {\n                        return ((sb.get(0) === JSBNG__document.activeElement));\n                    };\n                    this.cursorPos = function() {\n                        var input = sb.get(0);\n                        if (((\"selectionStart\" in input))) {\n                            return input.selectionStart;\n                        }\n                         else {\n                            if (JSBNG__document.selection) {\n                                input.JSBNG__focus();\n                                var sel = JSBNG__document.selection.createRange();\n                                var selLen = JSBNG__document.selection.createRange().text.length;\n                                sel.moveStart(\"character\", -input.value.length);\n                                return ((sel.text.length - selLen));\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                        return -1;\n                    };\n                    this.update = update;\n                    this.JSBNG__blur = function() {\n                        sb.JSBNG__blur();\n                    };\n                    this.JSBNG__focus = function() {\n                        var val = sb.val();\n                        sb.JSBNG__focus().val(\"\").val(val);\n                    };\n                    this.keydown = function(h) {\n                        sb.keydown(h);\n                    };\n                    this.click = function(h) {\n                        sb.click(h);\n                    };\n                    this.onFocus = function(h) {\n                        sb.JSBNG__focus(h);\n                    };\n                    this.onBlur = function(h) {\n                        sb.JSBNG__blur(h);\n                    };\n                    this.isImeUsed = function() {\n                        return imeUsed;\n                    };\n                };\n                var AC = function(opts) {\n                    var version = 1, opt = {\n                    }, names, values, crtSel = -1, redirectFirstSuggestion = false, crtXcatSel = -1, suggestionList = [], twoPaneSuggestionsList = [], curSize = 0, hideDelayTimerId = null, timer = null, maxCategorySuggestions = 4, categorySuggestions = 0, imeSpacing = 0, suggestRequest = null, first = -1, defaultDropDownVal, insertedDropDownVal, delayedDOMUpdate = false, staticContent, searchBox, keystroke, sugHandler, inlineAutoComplete, JSBNG__searchSuggest, activityAllowed = true, promoList = [], suggType = \"sugg\", newDesign = $(\"#navbar\").hasClass(\"nav-beacon\"), defaults = {\n                        sb: \"#twotabsearchtextbox\",\n                        form: \"#navbar form[name='site-search']\",\n                        dd: \"#searchDropdownBox\",\n                        cid: \"amazon-search-ui\",\n                        action: \"\",\n                        sugPrefix: \"issDiv\",\n                        sugText: \"Search suggestions\",\n                        fb: 0,\n                        xcat: 0,\n                        twoPane: 0,\n                        dupElim: 0,\n                        imeSpacing: 0,\n                        maxSuggestions: 10\n                    }, lastKeyPressTime, timeToFirstSuggestion = 0, searchAliasFrom, defaultTimeout = 100, reqCounter = 0;\n                    ((opts && init(opts)));\n                    function init(opts) {\n                        $.extend(opt, defaults, opts);\n                        newDesign = ((opt.isNavInline && newDesign));\n                        var src = opt.src;\n                        staticContent = $.isArray(src), resizeToken = null;\n                        lookup(opt, \"sb\");\n                        if (!opt.sb) {\n                            return;\n                        }\n                    ;\n                    ;\n                        searchBox = new SB(opt.sb, {\n                            adjust: move,\n                            twoPaneArrowKeyHandler: twoPaneArrowKeyHandler,\n                            hide: hideSuggestions,\n                            dismiss: dismissSuggestions,\n                            change: ((staticContent ? update : delayUpdate)),\n                            submitEnabled: submitEnabled,\n                            keyPress: keyPress,\n                            click: clickHandler,\n                            newDesign: newDesign,\n                            iac: opt.iac,\n                            checkIAC: checkIAC,\n                            opt: opt\n                        });\n                        lookup(opt, \"pe\");\n                        if (opt.iac) {\n                            inlineAutoComplete = new IAC(searchBox, opt.pe, opt.iac, newDesign);\n                        }\n                    ;\n                    ;\n                        if (((opt.twoPane == false))) {\n                            JSBNG__searchSuggest = new SS(searchBox, opt.pe, \"\\u003Cdiv id=\\\"srch_sggst\\\"/\\u003E\", {\n                                afterCreate: resizeHandler,\n                                onWindowResize: resizeHandler,\n                                beforeShow: resizeHandler\n                            });\n                        }\n                         else {\n                            JSBNG__searchSuggest = new SS(searchBox, opt.pe, \"\\u003Cdiv id=\\\"srch_sggst\\\" class=\\\"two-pane\\\" style=\\\"display:none\\\"/\\u003E\", {\n                                afterCreate: twoPaneSetPosition,\n                                beforeHtmlChange: twoPaneDestroyFlyout,\n                                beforeShow: twoPaneSetPosition,\n                                afterShow: function(h) {\n                                    twoPaneSetPosition.call(this);\n                                    twoPaneSetXcatPosition.call(this);\n                                    twoPaneBindFlyout.call(this);\n                                },\n                                onWindowResize: function() {\n                                    var $this = this;\n                                    resize = function() {\n                                        twoPaneDestroyFlyout.call($this);\n                                        twoPaneBindFlyout.call($this);\n                                        resizeToken = null;\n                                    };\n                                    window.JSBNG__clearTimeout(resizeToken);\n                                    resizeToken = window.JSBNG__setTimeout(resize, 100);\n                                    twoPaneSetPosition.call($this);\n                                    twoPaneSetXcatPosition.call($this);\n                                }\n                            });\n                        }\n                    ;\n                    ;\n                        lookup(opt, \"form\");\n                        lookup(opt, \"valInput\");\n                        lookup(opt, \"dd\");\n                        lookup(opt, \"submit\");\n                        ddBox = opt.dd;\n                        opt.protocol = ((((opt.protocol || window.JSBNG__document.JSBNG__location.protocol)) || \"http:\"));\n                        if (ddBox) {\n                            defaultDropDownVal = ddBox.val();\n                        }\n                    ;\n                    ;\n                        if (staticContent) {\n                            names = src[0];\n                            values = src[1];\n                            opt.sb.removeAttr(\"style\");\n                        }\n                         else {\n                        \n                        }\n                    ;\n                    ;\n                        if (opt.submit) {\n                            disable(\"disabled\");\n                            opt.submitImgDef = opt.submit.attr(\"src\");\n                            opt.submitToggle = ((opt.submitImgDef && opt.submitImg));\n                        }\n                    ;\n                    ;\n                        if (opt.ime) {\n                            window.JSBNG__setInterval(function() {\n                                searchBox.update();\n                            }, 20);\n                        }\n                    ;\n                    ;\n                        this.version = version;\n                        $SearchJS.importEvent(\"navbarPromos\");\n                        $SearchJS.when(\"navbarPromos\").run(function() {\n                            promoList = window.navbar.issPromotions(3);\n                        });\n                    };\n                ;\n                    function initStatic(sb, form, valInput, submit, submitImg, names, values, noMatch, ime, multiword, dummy0) {\n                        init({\n                            form: form,\n                            ime: ime,\n                            multiword: multiword,\n                            noMatch: noMatch,\n                            sb: sb,\n                            src: [names,values,],\n                            submit: submit,\n                            submitImg: submitImg,\n                            valInput: valInput\n                        });\n                    };\n                ;\n                    function initDynamic(sb, form, dd, service, mkt, aliases, handler, deptText, sugText, sc, dummy0) {\n                        init({\n                            aliases: aliases,\n                            dd: dd,\n                            deptText: deptText,\n                            form: form,\n                            handler: handler,\n                            ime: ((((mkt == 6)) || ((mkt == 3240)))),\n                            mkt: mkt,\n                            sb: sb,\n                            sc: sc,\n                            src: service,\n                            sugText: sugText\n                        });\n                    };\n                ;\n                    function lookup(h, k, n) {\n                        if (n = h[k]) {\n                            n = $(n);\n                            if (((n && n.length))) {\n                                h[k] = n;\n                                return n;\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                        delete h[k];\n                    };\n                ;\n                    function disable(d) {\n                        if (opt.submit.prop) {\n                            opt.submit.prop(\"disabled\", d);\n                        }\n                         else {\n                            opt.submit.attr(\"disabled\", d);\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    function move(n) {\n                        if (((curSize <= 0))) {\n                            return;\n                        }\n                    ;\n                    ;\n                        try {\n                            unhighlightCurrentSuggestion();\n                            if (((((n > 0)) && ((crtSel >= ((curSize - 1))))))) {\n                                crtSel = -1;\n                            }\n                             else {\n                                if (((((n < 0)) && ((crtSel < 0))))) {\n                                    crtSel = ((curSize - 1));\n                                }\n                                 else {\n                                    crtSel += n;\n                                }\n                            ;\n                            ;\n                            }\n                        ;\n                        ;\n                            highlightCurrentSuggestion(true);\n                        } catch (e) {\n                        \n                        };\n                    ;\n                    };\n                ;\n                    function wrap(x, min, max) {\n                        return ((((x > max)) ? min : ((((x < min)) ? max : x))));\n                    };\n                ;\n                    function twoPaneArrowKeyHandler(e) {\n                        var key = e.keyCode, list = twoPaneSuggestionsList, mainLength = list.length, xcatLength = ((((list[crtSel] && list[crtSel].xcat)) ? list[crtSel].xcat.length : 0)), ssNode = JSBNG__searchSuggest.getNode(), n, crtSelId, xcatSelId, firstId = ((opt.sugPrefix + 0));\n                        if (((((e.ctrlKey || e.altKey)) || e.shiftKey))) {\n                            return;\n                        }\n                    ;\n                    ;\n                        switch (key) {\n                          case 38:\n                        \n                          case 40:\n                            n = ((((key === 38)) ? -1 : 1));\n                            if (((((crtSel > -1)) && ((crtXcatSel >= 0))))) {\n                                crtXcatSel = wrap(((crtXcatSel + n)), 0, ((xcatLength - 1)));\n                            }\n                             else {\n                                crtSel = wrap(((crtSel + n)), -1, ((mainLength - 1)));\n                            }\n                        ;\n                        ;\n                            break;\n                          case 37:\n                        \n                          case 39:\n                            if (((crtSel <= -1))) {\n                                return;\n                            }\n                        ;\n                        ;\n                            if (((((((key === 39)) && ((crtXcatSel <= -1)))) && ((xcatLength > 0))))) {\n                                crtXcatSel = 0;\n                            }\n                             else {\n                                if (((key === 37))) {\n                                    crtXcatSel = -1;\n                                }\n                            ;\n                            ;\n                            }\n                        ;\n                        ;\n                            break;\n                          default:\n                            return;\n                        };\n                    ;\n                        crtSelId = ((opt.sugPrefix + crtSel));\n                        xcatSelId = ((((((opt.sugPrefix + crtSel)) + \"-\")) + crtXcatSel));\n                        ssNode.JSBNG__find(((((\"#\" + opt.sugPrefix)) + \"0\"))).removeClass(\"xcat-arrow-hint\");\n                        ssNode.JSBNG__find(\".main-suggestion\").each(function(i, el) {\n                            var e = $(el);\n                            if (((el.id === crtSelId))) {\n                                e.addClass(\"suggest_link_over\");\n                                ssNode.JSBNG__find(((\"#xcatPanel-\" + i))).show().JSBNG__find(\".xcat-suggestion\").each(function(i, el) {\n                                    var e = $(el);\n                                    if (((el.id !== xcatSelId))) {\n                                        e.removeClass(\"suggest_link_over\");\n                                    }\n                                     else {\n                                        e.addClass(\"suggest_link_over\");\n                                    }\n                                ;\n                                ;\n                                });\n                            }\n                             else {\n                                if (((((crtSel <= -1)) && ((el.id === firstId))))) {\n                                    e.removeClass(\"suggest_link_over\");\n                                    ssNode.JSBNG__find(((((\"#\" + opt.sugPrefix)) + \"0\"))).addClass(\"xcat-arrow-hint\");\n                                    ssNode.JSBNG__find(\"#xcatPanel-0\").show().JSBNG__find(\".xcat-suggestion\").removeClass(\"suggest_link_over\");\n                                }\n                                 else {\n                                    e.removeClass(\"suggest_link_over\");\n                                    ssNode.JSBNG__find(((\"#xcatPanel-\" + i))).hide();\n                                }\n                            ;\n                            ;\n                            }\n                        ;\n                        ;\n                        });\n                        updateCrtSuggestion();\n                        e.preventDefault();\n                        return false;\n                    };\n                ;\n                    function clickHandler(kw) {\n                        if (!kw.length) {\n                            displayPromotions();\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    function hideSuggestions() {\n                        ((!opt.ime && hideSuggestionsDiv()));\n                    };\n                ;\n                    function dismissSuggestions() {\n                        if (JSBNG__searchSuggest.visible()) {\n                            hideDelayTimerId = JSBNG__setTimeout(function() {\n                                return (function() {\n                                    hideDelayTimerId = null;\n                                    hideSuggestionsDiv();\n                                });\n                            }(), 300);\n                            crtSel = -1;\n                            if (((suggType == \"sugg\"))) {\n                                updateCrtSuggestion();\n                            }\n                        ;\n                        ;\n                            return false;\n                        }\n                    ;\n                    ;\n                        return true;\n                    };\n                ;\n                    function update(kw) {\n                        suggestionList = [];\n                        twoPaneSuggestionsList = [];\n                        if (!kw.length) {\n                            displayPromotions();\n                            if (inlineAutoComplete) {\n                                inlineAutoComplete.clear();\n                            }\n                        ;\n                        ;\n                        }\n                         else {\n                            first = -1;\n                            if (opt.multiword) {\n                                findSeq();\n                            }\n                             else {\n                                findBin();\n                            }\n                        ;\n                        ;\n                            curSize = suggestionList.length;\n                            displaySuggestions(kw);\n                            checkForExactMatch();\n                            checkForManualOverride();\n                        }\n                    ;\n                    ;\n                        timer = null;\n                        crtSel = -1;\n                        crtXcatSel = -1;\n                    };\n                ;\n                    function delayUpdate(kw) {\n                        var then = now();\n                        if (timer) {\n                            JSBNG__clearTimeout(timer);\n                            timer = null;\n                        }\n                    ;\n                    ;\n                        timer = JSBNG__setTimeout(function() {\n                            if (inlineAutoComplete) {\n                                inlineAutoComplete.clear();\n                            }\n                        ;\n                        ;\n                            return (function() {\n                                if (((!kw || !kw.length))) {\n                                    displayPromotions();\n                                }\n                                 else {\n                                    ((opt.imeEnh ? searchJSONSuggest(kw) : searchJSONSuggest()));\n                                }\n                            ;\n                            ;\n                                timer = null;\n                                crtSel = -1;\n                                crtXcatSel = -1;\n                            });\n                        }(), defaultTimeout);\n                    };\n                ;\n                    function submitEnabled() {\n                        if (((((suggType == \"promo\")) && ((crtSel > -1))))) {\n                            JSBNG__document.JSBNG__location.href = promoList[crtSel].href;\n                            return false;\n                        }\n                    ;\n                    ;\n                        var s = opt.submit;\n                        if (s) {\n                            return ((s.prop ? !s.prop(\"disabled\") : !s.attr(\"disabled\")));\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    function keyPress(key) {\n                        ((keystroke && keystroke(key)));\n                    };\n                ;\n                    function bindSubmit(handler) {\n                        opt.form.submit(handler);\n                    };\n                ;\n                    function bindKeypress(handler) {\n                        keystroke = handler;\n                    };\n                ;\n                    function bindSuggest(handler) {\n                        sugHandler = handler;\n                    };\n                ;\n                    function normalize(s) {\n                        if (opt.normalize) {\n                            return opt.normalize(s);\n                        }\n                         else {\n                            return s.toLowerCase();\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    function findBin() {\n                        var low = 0, high = ((names.length - 1)), mid = -1, dataPrefix = \"\", crtPrefix = normalize(keyword()), len = crtPrefix.length;\n                        while (((low <= high))) {\n                            mid = Math.floor(((((low + high)) / 2)));\n                            dataPrefix = normalize(names[mid]).substr(0, len);\n                            if (((dataPrefix < crtPrefix))) {\n                                low = ((mid + 1));\n                            }\n                             else {\n                                high = ((mid - 1));\n                                if (((dataPrefix == crtPrefix))) {\n                                    first = mid;\n                                }\n                            ;\n                            ;\n                            }\n                        ;\n                        ;\n                        };\n                    ;\n                        if (((first != -1))) {\n                            var i = first, n;\n                            do {\n                                suggestionList.push({\n                                    keyword: names[i],\n                                    i: i\n                                });\n                                ++i;\n                            } while (((((((suggestionList.length < opt.maxSuggestions)) && (n = names[i]))) && !normalize(n).indexOf(crtPrefix))));\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    function findSeq() {\n                        var crtPrefix = normalize(keyword()), rexp = new RegExp(((\"(^|(?:\\\\s))\" + crtPrefix)), \"i\"), i = 0, len = names.length, n;\n                        for (; ((((i < len)) && ((suggestionList.length < opt.maxSuggestions)))); i++) {\n                            n = names[i];\n                            if (normalize(n).match(rexp)) {\n                                suggestionList.push({\n                                    keyword: n,\n                                    i: i\n                                });\n                                if (((first == -1))) {\n                                    first = i;\n                                }\n                            ;\n                            ;\n                            }\n                        ;\n                        ;\n                        };\n                    ;\n                    };\n                ;\n                    function checkForExactMatch() {\n                        var state = \"disabled\";\n                        if (curSize) {\n                            var sg = normalize(suggestionList[0].keyword), kw = normalize(keyword());\n                            if (((((sg.length == kw.length)) && !getPrefixPos(sg, kw)))) {\n                                updateForm(first);\n                                state = \"\";\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                        disable(state);\n                    };\n                ;\n                    function checkForManualOverride() {\n                        if (((opt.manualOverride && !curSize))) {\n                            var kw = keyword();\n                            var url = opt.manualOverride(kw);\n                            if (((url && url.length))) {\n                                updateWholeForm(url);\n                                disable(\"\");\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    function displayPromotions() {\n                        if (((((!newDesign || !promoList)) || ((promoList.length == 0))))) {\n                            hideSuggestionsDiv();\n                            hideNoMatches();\n                            return;\n                        }\n                    ;\n                    ;\n                        curSize = promoList.length;\n                        suggType = \"promo\";\n                        JSBNG__searchSuggest.html(\"\");\n                        hideNoMatches();\n                        JSBNG__searchSuggest.show();\n                        h = \"\\u003Cul class=\\\"promo_list\\\"\\u003E\";\n                        for (i = 0; ((i < curSize)); i++) {\n                            p = promoList[i];\n                            h += ((((((((((\"\\u003Cli id=\\\"\" + opt.sugPrefix)) + i)) + \"\\\" onclick=\\\"document.JSBNG__location.href='\")) + p.href)) + \"'\\\"\\u003E\"));\n                            h += ((((\"\\u003Cdiv class=\\\"promo_image\\\" style=\\\"background-image: url('\" + p.image)) + \"');\\\"\\u003E\\u003C/div\\u003E\"));\n                            h += ((((\"\\u003Cdiv class=\\\"promo_cat\\\"\\u003E\" + p.category)) + \"\\u003C/div\\u003E\"));\n                            h += ((((\"\\u003Cdiv class=\\\"promo_title\\\"\\u003E\" + p.title)) + \"\\u003C/div\\u003E\"));\n                            h += \"\\u003C/li\\u003E\";\n                        };\n                    ;\n                        h += \"\\u003C/ul\\u003E\";\n                        JSBNG__searchSuggest.html(h);\n                        window.navbar.logImpression(\"iss\");\n                        for (i = 0; ((i < curSize)); ++i) {\n                            $(((((\"#\" + opt.sugPrefix)) + i))).mouseover(suggestOver).mouseout(suggestOut);\n                        };\n                    ;\n                    };\n                ;\n                    function displaySuggestions(crtPrefix) {\n                        var sugDivId, lineText, line, sPrefix = opt.sugPrefix, prefix = ((\"#\" + sPrefix)), h = \"\", imeSpacing = ((opt.imeSpacing && searchBox.isImeUsed())), currAlias = ((searchAlias() || ((opt.deepNodeISS && opt.deepNodeISS.searchAliasAccessor())))), suggType = \"sugg\";\n                        JSBNG__searchSuggest.html(\"\");\n                        if (((curSize > 0))) {\n                            hideNoMatches();\n                            JSBNG__searchSuggest.show();\n                            if (((!staticContent && !newDesign))) {\n                                h += ((((\"\\u003Cdiv id=\\\"sugdivhdr\\\" align=\\\"right\\\"\\u003E \" + opt.sugText)) + \"\\u003C/div\\u003E\"));\n                            }\n                        ;\n                        ;\n                            if (((opt.iac && inlineAutoComplete.displayable()))) {\n                                var sg = normalize(suggestionList[0].keyword), originalKw = opt.sb.val(), normalizedKw = normalize(keyword());\n                                if (((((((normalizedKw.length > 0)) && ((sg != normalizedKw)))) && ((sg.indexOf(normalizedKw) == 0))))) {\n                                    inlineAutoComplete.val(((originalKw + sg.substring(normalizedKw.length))));\n                                }\n                            ;\n                            ;\n                            }\n                        ;\n                        ;\n                        }\n                         else {\n                            showNoMatches();\n                        }\n                    ;\n                    ;\n                        for (i = 0; ((i < curSize)); i++) {\n                            line = suggestionList[i];\n                            sugDivId = ((sPrefix + i));\n                            if (((((((line.alias && ((line.alias == currAlias)))) && opt.deepNodeISS)) && opt.deepNodeISS.showDeepNodeCorr))) {\n                                lineText = getFormattedCategoryLine(line, crtPrefix);\n                            }\n                             else {\n                                if (((line.alias && ((line.alias != currAlias))))) {\n                                    lineText = getFormattedCategoryLine(line, crtPrefix);\n                                }\n                                 else {\n                                    lineText = getFormattedSuggestionLine(line, crtPrefix);\n                                }\n                            ;\n                            ;\n                            }\n                        ;\n                        ;\n                            var className = \"suggest_link\";\n                            if (((((i == 0)) && imeSpacing))) {\n                                className += \" imeSpacing\";\n                            }\n                        ;\n                        ;\n                            h += ((((((((((((\"\\u003Cdiv id=\\\"\" + sugDivId)) + \"\\\" class=\\\"\")) + className)) + \"\\\"\\u003E\")) + lineText)) + \"\\u003C/div\\u003E\"));\n                            if (((((enableSeparateCategorySuggestion() && ((i == categorySuggestions)))) && ((i < ((curSize - 1))))))) {\n                                h += \"\\u003Cdiv class=\\\"sx_line_holder\\\" /\\u003E\";\n                            }\n                        ;\n                        ;\n                        };\n                    ;\n                        if (((((curSize > 0)) && !newDesign))) {\n                            h += \"\\u003Cdiv id=\\\"sugdivhdr2\\\" align=\\\"right\\\"\\u003E&nbsp;\\u003C/div\\u003E\";\n                        }\n                    ;\n                    ;\n                        ((h && JSBNG__searchSuggest.html(h)));\n                        if (((((timeToFirstSuggestion == 0)) && ((suggestionList.length > 0))))) {\n                            recordTimeToFirstSuggestion();\n                        }\n                    ;\n                    ;\n                        if (ddBox) {\n                            defaultDropDownVal = ddBox.val();\n                        }\n                    ;\n                    ;\n                        searchAliasFrom = extractSearchAlias(defaultDropDownVal);\n                        for (i = 0; ((i < curSize)); ++i) {\n                            $(((prefix + i))).mouseover(suggestOver).mouseout(suggestOut).click(setSearchByIndex);\n                        };\n                    ;\n                    };\n                ;\n                    function displayTwoPaneSuggestions(crtPrefix) {\n                        var len = crtPrefix.length, i, j, k, sg, isIe6 = (($.browser.msie && (($.browser.version == \"6.0\")))), targetOffset, sb = [], a = function() {\n                            $.each(arguments, function(i, t) {\n                                sb.push(t);\n                            });\n                        }, sgLen = twoPaneSuggestionsList.length, xcatLen, maxXcatLen = 0, imeSpacing = ((opt.imeSpacing && searchBox.isImeUsed())), ssNode;\n                        $($.JSBNG__find(\".main-suggestion:first\")).amznFlyoutIntent(\"destroy\");\n                        if (((curSize > 0))) {\n                            hideNoMatches();\n                            if (((opt.iac && inlineAutoComplete.displayable()))) {\n                                var sg = normalize(twoPaneSuggestionsList[0].keyword), originalKw = opt.sb.val(), normalizedKw = normalize(keyword());\n                                if (((((((normalizedKw.length > 0)) && ((sg != normalizedKw)))) && ((sg.indexOf(normalizedKw) == 0))))) {\n                                    inlineAutoComplete.val(((originalKw + sg.substring(normalizedKw.length))));\n                                }\n                            ;\n                            ;\n                            }\n                        ;\n                        ;\n                            a(\"\\u003Ctable id=\\\"two-pane-table\\\" class=\\\"\", ((isIe6 ? \"nav_ie6\" : \"nav_exposed_skin\")), \"\\\" cellpadding=\\\"0\\\" cellspacing=\\\"0\\\"\\u003E\", \"\\u003Ctr\\u003E\", \"\\u003Ctd class=\\\"iss_pop_tl nav_pop_h\\\"\\u003E\\u003Cdiv class=\\\"nav_pop_lr_min\\\"\\u003E\\u003C/div\\u003E\\u003C/td\\u003E\", \"\\u003Ctd style=\\\"background-color: #fff;\\\" colspan=\\\"2\\\"\\u003E\\u003C/td\\u003E\", \"\\u003Ctd class=\\\"iss_pop_tr nav_pop_h\\\"\\u003E\\u003C/td\\u003E\", \"\\u003C/tr\\u003E\", \"\\u003Ctr\\u003E\", \"\\u003Ctd class=\\\"nav_pop_cl nav_pop_v\\\"\\u003E\\u003Cdiv class=\\\"nav_pop_lr_min\\\"\\u003E\\u003C/div\\u003E\\u003C/td\\u003E\");\n                            var className = \"main-suggestions\";\n                            if (imeSpacing) {\n                                className += \" imePadding\";\n                            }\n                        ;\n                        ;\n                            a(((((\"\\u003Ctd class=\\\"\" + className)) + \"\\\" \\u003E\")));\n                            for (i = 0; ((i < sgLen)); i++) {\n                                a(\"\\u003Cdiv id=\\\"\", opt.sugPrefix, i, \"\\\" class=\\\"suggest_link main-suggestion\");\n                                if (((i === 0))) {\n                                    a(\" xcat-arrow-hint\");\n                                }\n                            ;\n                            ;\n                                a(\"\\\"\\u003E\\u003Cspan\\u003E\");\n                                sg = twoPaneSuggestionsList[i];\n                                xcatLen = sg.xcat.length;\n                                if (xcatLen) {\n                                    a(\"\\u003Cspan class=\\\"nav-sprite nav-cat-indicator xcat-arrow\\\"\\u003E\\u003C/span\\u003E\");\n                                    if (((maxXcatLen < xcatLen))) {\n                                        maxXcatLen = xcatLen;\n                                    }\n                                ;\n                                ;\n                                }\n                            ;\n                            ;\n                                a(getFormattedSuggestionLine(sg, crtPrefix), \"\\u003C/span\\u003E\\u003C/div\\u003E\");\n                            };\n                        ;\n                            for (i = 0; ((i < ((maxXcatLen - sgLen)))); i++) {\n                                a(\"\\u003Cdiv class=\\\"iss-spacer-row\\\"\\u003E&nbsp;\\u003C/div\\u003E\");\n                            };\n                        ;\n                            var className = \"xcat-suggestions\";\n                            if (imeSpacing) {\n                                className += \" imePadding\";\n                            }\n                        ;\n                        ;\n                            a(((((\"\\u003C/td\\u003E\\u003Ctd class=\\\"\" + className)) + \"\\\"\\u003E\")));\n                            for (i = 0; ((i < sgLen)); i++) {\n                                sg = twoPaneSuggestionsList[i];\n                                a(\"\\u003Cdiv id=\\\"xcatPanel-\", i, \"\\\" class=\\\"xcat-panel\\\"\");\n                                if (((i > 0))) {\n                                    a(\" style=\\\"display:none\\\"\");\n                                }\n                            ;\n                            ;\n                                a(\"\\u003E\");\n                                for (j = 0; ((j < sg.xcat.length)); j++) {\n                                    a(\"\\u003Cdiv id=\\\"\", opt.sugPrefix, i, \"-\", j, \"\\\" class=\\\"suggest_link xcat-suggestion\", ((((j === 0)) ? \" xcat-suggestion-hint\" : \"\")), \"\\\"\\u003E\", sg.xcat[j].categoryName, \"\\u003C/div\\u003E\");\n                                };\n                            ;\n                                a(\"\\u003C/div\\u003E\");\n                            };\n                        ;\n                            a(\"\\u003C/td\\u003E\", \"\\u003Ctd class=\\\"nav_pop_cr nav_pop_v\\\"\\u003E\\u003C/td\\u003E\", \"\\u003C/tr\\u003E\", \"\\u003Ctr\\u003E\", \"\\u003Ctd class=\\\"nav_pop_bl nav_pop_v\\\"\\u003E\\u003C/td\\u003E\", \"\\u003Ctd colspan=\\\"2\\\" class=\\\"nav_pop_bc nav_pop_h\\\"\\u003E\\u003C/td\\u003E\", \"\\u003Ctd class=\\\"nav_pop_br nav_pop_v\\\"\\u003E\\u003C/td\\u003E\", \"\\u003C/tr\\u003E\", \"\\u003C/table\\u003E\");\n                        }\n                         else {\n                            showNoMatches();\n                        }\n                    ;\n                    ;\n                        JSBNG__searchSuggest.html(sb.join(\"\"));\n                        JSBNG__searchSuggest.show();\n                        if (((((timeToFirstSuggestion == 0)) && ((suggestionList.length > 0))))) {\n                            recordTimeToFirstSuggestion();\n                        }\n                    ;\n                    ;\n                        if (ddBox) {\n                            defaultDropDownVal = ddBox.val();\n                        }\n                    ;\n                    ;\n                        searchAliasFrom = extractSearchAlias(defaultDropDownVal);\n                        ssNode = JSBNG__searchSuggest.getNode();\n                        ssNode.JSBNG__find(\".main-suggestion\").bind(\"click\", twoPaneSearchByIndex);\n                        ssNode.JSBNG__find(\".xcat-suggestion\").bind(\"click\", twoPaneSearchByIndex).bind(\"mouseover\", twoPaneSuggestOver).bind(\"mouseout\", twoPaneXcatSuggestOut);\n                    };\n                ;\n                    function recordTimeToFirstSuggestion() {\n                        var timeNow = now();\n                        timeToFirstSuggestion = ((((timeNow - lastKeyPressTime)) + defaultTimeout));\n                    };\n                ;\n                    function showNoMatches() {\n                        if (opt.noMatch) {\n                            var nmDiv = $(((\"#\" + opt.noMatch)));\n                            JSBNG__searchSuggest.html(\"\");\n                            JSBNG__searchSuggest.getNode().append(nmDiv.clone().attr(\"class\", \"suggest_link suggest_nm\").css({\n                                display: \"block\"\n                            }));\n                            JSBNG__searchSuggest.show();\n                            ((opt.submitToggle && opt.submit.attr(\"src\", opt.submitImg)));\n                        }\n                         else {\n                            hideSuggestionsDiv();\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    function hideNoMatches() {\n                        if (opt.noMatch) {\n                            $(((\"#\" + opt.noMatch))).hide();\n                            ((opt.submitToggle && opt.submit.attr(\"src\", opt.submitImgDef)));\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    function setSearchByIndex() {\n                        var divId = this.id;\n                        crtSel = parseInt(divId.substr(6), 10);\n                        updateCrtSuggestion();\n                        JSBNG__searchSuggest.hide();\n                        if (opt.iac) {\n                            inlineAutoComplete.clear();\n                        }\n                    ;\n                    ;\n                        if (!delayedDOMUpdate) {\n                            opt.form.submit();\n                        }\n                         else {\n                            window.JSBNG__setTimeout(function() {\n                                opt.form.submit();\n                            }, 10);\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    function twoPaneSearchByIndex(JSBNG__event) {\n                        var divId = this.id, prefixLen = opt.sugPrefix.length;\n                        crtSel = parseInt(divId.substr(prefixLen), 10);\n                        crtXcatSel = ((((divId.length === ((prefixLen + 1)))) ? -1 : parseInt(divId.substr(((prefixLen + 2)), 1), 10)));\n                        ((JSBNG__event && JSBNG__event.stopPropagation()));\n                        updateCrtSuggestion();\n                        $($.JSBNG__find(\".main-suggestion:first\")).amznFlyoutIntent(\"destroy\");\n                        JSBNG__searchSuggest.hide();\n                        if (opt.iac) {\n                            inlineAutoComplete.clear();\n                        }\n                    ;\n                    ;\n                        if (!delayedDOMUpdate) {\n                            opt.form.submit();\n                        }\n                         else {\n                            window.JSBNG__setTimeout(function() {\n                                opt.form.submit();\n                            }, 10);\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    function updateCrtSuggestion() {\n                        var alias, categoryName, sg;\n                        if (((crtSel >= 0))) {\n                            if (((opt.twoPane === 1))) {\n                                sg = ((((crtXcatSel >= 0)) ? twoPaneSuggestionsList[crtSel].xcat[crtXcatSel] : twoPaneSuggestionsList[crtSel]));\n                            }\n                             else {\n                                if (((redirectFirstSuggestion && ((crtSel == 0))))) {\n                                    sg = suggestionList[1];\n                                }\n                                 else {\n                                    sg = suggestionList[crtSel];\n                                }\n                            ;\n                            ;\n                            }\n                        ;\n                        ;\n                            keyword(sg.keyword);\n                            alias = sg.alias;\n                            categoryName = sg.categoryName;\n                        }\n                    ;\n                    ;\n                        if (staticContent) {\n                            if (((crtSel >= 0))) {\n                                updateForm(sg.i);\n                                disable(\"\");\n                            }\n                             else {\n                                checkForExactMatch();\n                                checkForManualOverride();\n                            }\n                        ;\n                        ;\n                        }\n                         else {\n                            updateCategoryDropDown(alias, categoryName);\n                            setDynamicSearch(sg);\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    ((opt.form && opt.form.submit(function() {\n                        var currentKeyword = normalize(keyword()), refTag = \"ref=nb_sb_noss\", i = 0;\n                        if (inlineAutoComplete) {\n                            inlineAutoComplete.clear();\n                        }\n                    ;\n                    ;\n                        var iacType = ((opt.iac ? inlineAutoComplete.type() : 0));\n                        if (iacType) {\n                            refTag = ((\"ref=nb_sb_iac_\" + iacType));\n                        }\n                         else {\n                            if (((crtSel > -1))) {\n                                return;\n                            }\n                        ;\n                        ;\n                            var sgList = ((((opt.twoPane === 1)) ? twoPaneSuggestionsList : suggestionList));\n                            if (((sgList.length > 0))) {\n                                refTag = \"ref=nb_sb_noss_2\";\n                                while (((i < sgList.length))) {\n                                    if (((normalize(sgList[i].keyword) == currentKeyword))) {\n                                        refTag = \"ref=nb_sb_noss_1\";\n                                        break;\n                                    }\n                                ;\n                                ;\n                                    i++;\n                                };\n                            ;\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                        opt.form.attr(\"action\", opt.form.attr(\"action\").replace(refre, refTag));\n                    })));\n                    function setDynamicSearch(sg) {\n                        var prefixElems = $(\"#issprefix\");\n                        if (sg) {\n                            var issMode, kw = searchBox.userInput();\n                            if (isFallbackSuggestion(sg)) {\n                                issMode = \"ss_fb\";\n                            }\n                             else {\n                                if (sg.alias) {\n                                    issMode = \"ss_c\";\n                                }\n                                 else {\n                                    if (((opt.sc && isSpellCorrection(sg)))) {\n                                        issMode = \"ss_sc\";\n                                    }\n                                     else {\n                                        issMode = \"ss_i\";\n                                    }\n                                ;\n                                ;\n                                }\n                            ;\n                            ;\n                            }\n                        ;\n                        ;\n                            setSearchFormReftag(opt.form, null, issMode, sg, kw.length);\n                            kw = ((((((((kw + \",\")) + searchAliasFrom)) + \",\")) + timeToFirstSuggestion));\n                            if (prefixElems.length) {\n                                prefixElems.attr(\"value\", kw);\n                            }\n                             else {\n                                input(opt.form, \"issprefix\", \"sprefix\", kw);\n                            }\n                        ;\n                        ;\n                        }\n                         else {\n                            prefixElems.remove();\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    function twoPaneSuggestOver() {\n                        var len = opt.sugPrefix.length, id = this.id, crtSelId = ((((\"#\" + opt.sugPrefix)) + crtSel)), xcatSelId, nextSel = parseInt(id.substr(len, 1), 10);\n                        this.style.cursor = \"pointer\";\n                        $(\".xcat-panel\").hide();\n                        if (((nextSel !== crtSel))) {\n                            $(crtSelId).removeClass(\"suggest_link_over\");\n                        }\n                    ;\n                    ;\n                        $(((((\"#\" + opt.sugPrefix)) + \"0\"))).removeClass(\"xcat-arrow-hint\");\n                        crtSel = nextSel;\n                        crtXcatSel = ((((id.length === ((len + 1)))) ? -1 : parseInt(id.substr(((len + 2)), 1), 10)));\n                        crtSelId = ((((\"#\" + opt.sugPrefix)) + crtSel));\n                        $(crtSelId).addClass(\"suggest_link_over\");\n                        $(((\"#xcatPanel-\" + crtSel))).show();\n                        if (((crtXcatSel > -1))) {\n                            $(((((((((\"#\" + opt.sugPrefix)) + crtSel)) + \"-\")) + crtXcatSel))).addClass(\"suggest_link_over\");\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    function twoPaneSuggestOut() {\n                        $(this).removeClass(\"suggest_link_over\");\n                    };\n                ;\n                    function twoPaneXcatSuggestOut() {\n                        unhighlightSuggestion($(this));\n                    };\n                ;\n                    function resizeHandler() {\n                        var p = searchBox.pos(), d = searchBox.size();\n                        this.css({\n                            width: d.width,\n                            JSBNG__top: ((p.JSBNG__top + d.height)),\n                            left: p.left\n                        });\n                    };\n                ;\n                    function twoPaneBindFlyout() {\n                        JSBNG__searchSuggest.getNode().JSBNG__find(\".main-suggestion\").amznFlyoutIntent({\n                            onMouseOver: twoPaneSuggestOver,\n                            getTarget: function() {\n                                return $(\"#two-pane-table .xcat-suggestions:first\");\n                            }\n                        });\n                    };\n                ;\n                    function twoPaneDestroyFlyout() {\n                        var mainSgs = JSBNG__searchSuggest.getNode().JSBNG__find(\".main-suggestion\").get(0);\n                        if (mainSgs) {\n                            $(mainSgs).amznFlyoutIntent(\"destroy\");\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    function twoPaneSetPosition() {\n                        var p = searchBox.pos(), d = searchBox.size(), minWidth = 649;\n                        this.css({\n                            width: Math.max(((d.width + 72)), minWidth),\n                            JSBNG__top: ((((p.JSBNG__top + d.height)) + 1)),\n                            left: ((p.left - 40))\n                        });\n                    };\n                ;\n                    function twoPaneSetXcatPosition() {\n                        var maxH = this.JSBNG__find(\".main-suggestions:first\").height(), th = this.JSBNG__find(((((\"#\" + opt.sugPrefix)) + \"0\"))).JSBNG__outerHeight(), sgLen = twoPaneSuggestionsList.length, i, h, xb, xh, off;\n                        for (i = 1; ((i < sgLen)); i++) {\n                            h = this.JSBNG__find(((((\"#\" + opt.sugPrefix)) + i))).JSBNG__outerHeight();\n                            xb = this.JSBNG__find(((\"#xcatPanel-\" + i)));\n                            off = th;\n                            if (xb) {\n                                xb = $(xb);\n                                xh = xb.JSBNG__outerHeight();\n                                if (((((off + xh)) > maxH))) {\n                                    off = ((maxH - xh));\n                                }\n                            ;\n                            ;\n                                xb.css({\n                                    \"margin-top\": off\n                                });\n                            }\n                        ;\n                        ;\n                            th += h;\n                        };\n                    ;\n                    };\n                ;\n                    function suggestOver(JSBNG__event) {\n                        this.style.cursor = ((((newDesign == true)) ? \"pointer\" : \"default\"));\n                        unhighlightCurrentSuggestion();\n                        crtSel = parseInt(this.id.substr(opt.sugPrefix.length), 10);\n                        highlightCurrentSuggestion(false);\n                    };\n                ;\n                    function suggestOut(el, JSBNG__event) {\n                        unhighlightSuggestion($(this));\n                        crtSel = -1;\n                    };\n                ;\n                    function highlightSuggestion(suggestion) {\n                        suggestion.addClass(\"suggest_link_over\");\n                    };\n                ;\n                    function unhighlightSuggestion(suggestion) {\n                        suggestion.removeClass(\"suggest_link_over\");\n                    };\n                ;\n                    function highlightCurrentSuggestion(updateSearchBox) {\n                        if (((suggType == \"sugg\"))) {\n                            ((updateSearchBox && updateCrtSuggestion()));\n                        }\n                    ;\n                    ;\n                        highlightSuggestion($(((((\"#\" + opt.sugPrefix)) + crtSel))));\n                    };\n                ;\n                    function unhighlightCurrentSuggestion() {\n                        unhighlightSuggestion($(((((\"#\" + opt.sugPrefix)) + crtSel))));\n                    };\n                ;\n                    function updateCategoryDropDown(alias, categoryName) {\n                        var dd = ddBox, toRemove, val;\n                        if (!dd) {\n                            return;\n                        }\n                    ;\n                    ;\n                        val = ((alias ? ((\"search-alias=\" + alias)) : defaultDropDownVal));\n                        toRemove = ((((((val == insertedDropDownVal)) || ((defaultDropDownVal == insertedDropDownVal)))) ? null : insertedDropDownVal));\n                        if (alias) {\n                            var sel = findOption(dd, val);\n                            insertedDropDownVal = null;\n                            if (!sel.length) {\n                                dd.append(option(val, categoryName));\n                                insertedDropDownVal = val;\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                        try {\n                            delayedDOMUpdate = false;\n                            (($(dcs).length && changeDropdownSelection(val, categoryName, true)));\n                            dd.val(val);\n                        } catch (e) {\n                            delayedDOMUpdate = true;\n                        };\n                    ;\n                        ((toRemove && findOption(dd, toRemove).remove()));\n                    };\n                ;\n                    function getPrefixPos(str, substr) {\n                        if (opt.multiword) {\n                            return getPrefixPosMultiWord(str, substr);\n                        }\n                    ;\n                    ;\n                        return normalize(str).indexOf(normalize(substr));\n                    };\n                ;\n                    function getPrefixPosMultiWord(str, substr) {\n                        var p = normalize(str).search(new RegExp(((\"(^|(?:\\\\s))\" + normalize(substr))), \"i\"));\n                        return ((((p <= 0)) ? p : ((p + 1))));\n                    };\n                ;\n                    function getFormattedSuggestionLine(curSuggestionLine, crtPrefix) {\n                        var kw = curSuggestionLine.keyword, start = getPrefixPos(kw, crtPrefix), len;\n                        if (((start !== -1))) {\n                            len = crtPrefix.length;\n                            kw = [kw.substr(0, start),\"\\u003Cb\\u003E\",kw.substr(start, len),\"\\u003C/b\\u003E\",kw.substr(((start + len))),].join(\"\");\n                        }\n                    ;\n                    ;\n                        return kw;\n                    };\n                ;\n                    function getFormattedCategoryLine(categoryLine, crtPrefix) {\n                        var formattedCategoryLine, formattedCategoryName;\n                        if (opt.scs) {\n                            formattedCategoryLine = \"\\u003Cspan class=\\\"suggest_category_without_keyword\\\"\\u003E\";\n                            formattedCategoryName = ((((\"\\u003Cspan class=\\\"sx_category_name_highlight\\\"\\u003E\" + categoryLine.categoryName)) + \"\\u003C/span\\u003E\"));\n                        }\n                         else {\n                            formattedCategoryLine = ((getFormattedSuggestionLine(categoryLine, crtPrefix) + \" \\u003Cspan class=\\\"suggest_category\\\"\\u003E\"));\n                            formattedCategoryName = categoryLine.categoryName;\n                        }\n                    ;\n                    ;\n                        return ((opt.deptText ? ((((formattedCategoryLine + opt.deptText.replace(deptre, formattedCategoryName))) + \"\\u003C/span\\u003E\")) : categoryLine.categoryName));\n                    };\n                ;\n                    function hideSuggestionsDiv() {\n                        if (((((suggType == \"sugg\")) && suggestRequest))) {\n                            suggestRequest.cleanup();\n                            suggestRequest = null;\n                        }\n                    ;\n                    ;\n                        curSize = 0;\n                        $($.JSBNG__find(\".main-suggestion:first\")).amznFlyoutIntent(\"destroy\");\n                        JSBNG__searchSuggest.hide();\n                        crtSel = -1;\n                        crtXcatSel = -1;\n                    };\n                ;\n                    function updateWholeForm(v) {\n                        var fp = getFormParams(v);\n                        cleanForm();\n                        populateForm(fp);\n                    };\n                ;\n                    function updateForm(index) {\n                        var v = values[index];\n                        if (((opt.valInput && opt.valInput.length))) {\n                            opt.valInput.attr(\"value\", v);\n                        }\n                         else {\n                            updateWholeForm(((v || JSBNG__location.href)));\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    function getFormParams(url) {\n                        var splitUrl = url.split(\"?\"), query = ((((splitUrl.length > 1)) ? splitUrl[1] : undefined)), params = ((query ? query.split(\"&\") : [])), i = params.length, pair;\n                        while (((i-- > 0))) {\n                            pair = params[i].split(\"=\");\n                            params[i] = {\n                                JSBNG__name: pair[0],\n                                value: pair[1].replace(slashre, \" \")\n                            };\n                        };\n                    ;\n                        return {\n                            uri: splitUrl[0],\n                            formParams: params\n                        };\n                    };\n                ;\n                    function cleanForm() {\n                        opt.form.JSBNG__find(\".frmDynamic\").remove();\n                    };\n                ;\n                    function populateForm(formData) {\n                        opt.form.attr(\"action\", formData.uri);\n                        for (var i = 0; ((i < formData.formParams.length)); i++) {\n                            var param = formData.formParams[i];\n                            input(opt.form, \"frmDynamic\", param.JSBNG__name, unescape(decodeURIComponent(param.value)), 1);\n                        };\n                    ;\n                    };\n                ;\n                    function keyword(k) {\n                        return searchBox.keyword(k);\n                    };\n                ;\n                    function searchAlias(alias) {\n                        if (alias) {\n                            changeDropdownSelection(alias);\n                        }\n                         else {\n                            return extractSearchAlias(ddBox.attr(\"value\"));\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    function extractSearchAlias(alias) {\n                        var aliasName = alias.match(aliasre);\n                        return ((aliasName ? aliasName[1] : null));\n                    };\n                ;\n                    function searchNode() {\n                        var nodeName = ddBox.attr(\"value\").match(nodere);\n                        return ((nodeName ? nodeName[1] : null));\n                    };\n                ;\n                    function merchant() {\n                        var merchant = ddBox.attr(\"value\").match(merchantre);\n                        return ((merchant ? merchant[1] : null));\n                    };\n                ;\n                    function suggestions() {\n                        return suggestionList;\n                    };\n                ;\n                    function supportedSearchAlias(alias) {\n                        var a = opt.aliases;\n                        return ((a && ((arrayIndexOf(a, alias) >= 0))));\n                    };\n                ;\n                    function isSpellCorrection(sg) {\n                        return ((((sg && sg.sc)) ? true : false));\n                    };\n                ;\n                    function isFallbackSuggestion(sg) {\n                        return ((((sg && sg.source)) && ((sg.source[0] == \"fb\"))));\n                    };\n                ;\n                    function combineSuggestions(crtSuggestions, extraData) {\n                        var xcatSuggestions, m, n = crtSuggestions.length, combinedList = [], i = 0, j = 0, sg, cs, s, si = 0, deepNodeAlias = ((((((!searchAlias() && opt.deepNodeISS)) && !opt.deepNodeISS.stayInDeepNode)) && opt.deepNodeISS.searchAliasAccessor())), deepNodeCatName = ((deepNodeAlias && getDDCatName(deepNodeAlias)));\n                        categorySuggestions = 0;\n                        redirectFirstSuggestion = false;\n                        while (((((combinedList.length < opt.maxSuggestions)) && ((i < n))))) {\n                            sg = {\n                                keyword: crtSuggestions[i],\n                                sc: isSpellCorrection(extraData[i]),\n                                sgIndex: i\n                            };\n                            if (((deepNodeAlias && deepNodeCatName))) {\n                                sg.alias = deepNodeAlias;\n                                sg.categoryName = deepNodeCatName;\n                            }\n                        ;\n                        ;\n                            combinedList.push(sg);\n                            xcatSuggestions = ((((((extraData && extraData.length)) ? extraData[i].nodes : [])) || []));\n                            m = xcatSuggestions.length;\n                            if (m) {\n                                s = extraData[i].source;\n                                if (((s && s.length))) {\n                                    for (si = 0; ((si < s.length)); si++) {\n                                        if (((s[si] === \"fb\"))) {\n                                            if (((((n == 1)) && opt.scs))) {\n                                                redirectFirstSuggestion = true;\n                                            }\n                                             else {\n                                                combinedList.pop();\n                                            }\n                                        ;\n                                        ;\n                                            break;\n                                        }\n                                    ;\n                                    ;\n                                    };\n                                ;\n                                }\n                            ;\n                            ;\n                                j = 0;\n                                while (((((((j < m)) && ((j < maxCategorySuggestions)))) && ((combinedList.length < opt.maxSuggestions))))) {\n                                    cs = xcatSuggestions[j];\n                                    sg = {\n                                        keyword: crtSuggestions[i],\n                                        sc: isSpellCorrection(extraData[i]),\n                                        source: extraData[i].source,\n                                        alias: cs.alias,\n                                        categoryName: cs.JSBNG__name,\n                                        sgIndex: i,\n                                        xcatIndex: j\n                                    };\n                                    combinedList.push(sg);\n                                    ++j;\n                                    ++categorySuggestions;\n                                };\n                            ;\n                            }\n                        ;\n                        ;\n                            if (((((((i == 0)) && enableSeparateCategorySuggestion())) && !redirectFirstSuggestion))) {\n                                combinedList.push(combinedList[0]);\n                                opt.maxSuggestions += 1;\n                            }\n                        ;\n                        ;\n                            ++i;\n                        };\n                    ;\n                        curSize = combinedList.length;\n                        return combinedList;\n                    };\n                ;\n                    function enableSeparateCategorySuggestion() {\n                        return ((opt.scs && ((categorySuggestions > 0))));\n                    };\n                ;\n                    function getDDCatName(alias) {\n                        if (!alias) {\n                            return $(ddBox.children()[0]).text();\n                        }\n                    ;\n                    ;\n                        var catName = findOption(ddBox, ((\"search-alias=\" + alias)));\n                        if (((catName && catName.length))) {\n                            return catName.text();\n                        }\n                         else {\n                            return undefined;\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    function build2PaneSuggestions(crtSuggestions, extraData) {\n                        var xcatSuggestions, xcat = [], m, n = crtSuggestions.length, combinedList = [], i = 0, j = 0, sg, cs, s, si = 0, currAlias = searchAlias(), currCatName = getDDCatName(currAlias), deepNodeAlias = ((((((!currAlias && opt.deepNodeISS)) && !opt.deepNodeISS.stayInDeepNode)) && opt.deepNodeISS.searchAliasAccessor())), deepNodeCatName = getDDCatName(deepNodeAlias);\n                        while (((((combinedList.length < opt.maxSuggestions)) && ((i < n))))) {\n                            xcatSuggestions = ((((((extraData && extraData.length)) ? extraData[i].nodes : [])) || []));\n                            xcat = [];\n                            sg = {\n                                keyword: crtSuggestions[i],\n                                sc: isSpellCorrection(extraData[i]),\n                                source: ((extraData[i].source || \"c\")),\n                                conf: extraData[i].conf,\n                                sgIndex: i,\n                                xcatIndex: 0\n                            };\n                            if (deepNodeAlias) {\n                                sg.alias = deepNodeAlias;\n                                sg.categoryName = deepNodeCatName;\n                            }\n                             else {\n                                if (currAlias) {\n                                    sg.alias = currAlias;\n                                    sg.categoryName = currCatName;\n                                }\n                                 else {\n                                    sg.categoryName = deepNodeCatName;\n                                }\n                            ;\n                            ;\n                            }\n                        ;\n                        ;\n                            xcat.push(sg);\n                            m = xcatSuggestions.length;\n                            if (m) {\n                                j = 0;\n                                while (((((j < m)) && ((j < opt.maxSuggestions))))) {\n                                    cs = xcatSuggestions[j];\n                                    sg = {\n                                        keyword: crtSuggestions[i],\n                                        sc: isSpellCorrection(extraData[i]),\n                                        source: ((extraData[i].source || \"c\")),\n                                        alias: cs.alias,\n                                        categoryName: cs.JSBNG__name,\n                                        conf: extraData[i].conf,\n                                        sgIndex: i,\n                                        xcatIndex: ((j + 1))\n                                    };\n                                    xcat.push(sg);\n                                    ++j;\n                                };\n                            ;\n                            }\n                        ;\n                        ;\n                            sg = {\n                                keyword: crtSuggestions[i],\n                                sc: isSpellCorrection(extraData[i]),\n                                conf: extraData[i].conf,\n                                sgIndex: i,\n                                xcat: xcat\n                            };\n                            if (deepNodeAlias) {\n                                sg.alias = deepNodeAlias;\n                            }\n                        ;\n                        ;\n                            combinedList.push(sg);\n                            ++i;\n                        };\n                    ;\n                        curSize = combinedList.length;\n                        return combinedList;\n                    };\n                ;\n                    function searchJSONSuggest(newKw) {\n                        lastKeyPressTime = now();\n                        ((suggestRequest && suggestRequest.cleanup()));\n                        if (!activityAllowed) {\n                            return;\n                        }\n                    ;\n                    ;\n                        if (!searchBox.hasFocus()) {\n                            return;\n                        }\n                    ;\n                    ;\n                        var alias = ((searchAlias() || ((opt.deepNodeISS ? opt.deepNodeISS.searchAliasAccessor() : null)))), kw = ((newKw || keyword())), suggestUrl = [], a = function() {\n                            $.each(arguments, function(i, t) {\n                                suggestUrl.push(t);\n                            });\n                        }, m = ((((reqCounter === 0)) ? metrics.completionsRequest0 : ((((reqCounter === metrics.sample)) ? metrics.completionsRequestSample : null)))), cursorPos, qs;\n                        if (!supportedSearchAlias(alias)) {\n                            hideSuggestionsDiv();\n                            return;\n                        }\n                    ;\n                    ;\n                        if (opt.qs) {\n                            cursorPos = searchBox.cursorPos();\n                            if (((((cursorPos > -1)) && ((cursorPos < kw.length))))) {\n                                qs = kw.substring(cursorPos);\n                                kw = kw.substring(0, cursorPos);\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                        a(opt.protocol, \"//\", opt.src, \"?\", \"method=completion\", \"&q=\", encodeURIComponent(kw), \"&search-alias=\", alias, \"&client=\", opt.cid, \"&mkt=\", opt.mkt, \"&fb=\", opt.fb, \"&xcat=\", opt.xcat, \"&x=updateISSCompletion\");\n                        if (qs) {\n                            a(((\"&qs=\" + encodeURIComponent(qs))));\n                        }\n                    ;\n                    ;\n                        if (opt.np) {\n                            a(((\"&np=\" + opt.np)));\n                        }\n                    ;\n                    ;\n                        if (opt.sc) {\n                            a(\"&sc=1\");\n                        }\n                    ;\n                    ;\n                        if (((opt.dupElim > 0))) {\n                            a(\"&dr=\", opt.dupElim);\n                        }\n                    ;\n                    ;\n                        if (opt.custIss4Prime) {\n                            a(\"&pf=1\");\n                        }\n                    ;\n                    ;\n                        if (suggestRequest) {\n                            suggestRequest.cleanup();\n                        }\n                    ;\n                    ;\n                        suggestRequest = new A9JSONClient(kw, reqCounter++);\n                        suggestRequest.callSuggestionsService(suggestUrl.join(\"\"));\n                    };\n                ;\n                    function updateCompletion() {\n                        if (!suggestRequest) {\n                            return;\n                        }\n                    ;\n                    ;\n                        if (((((((((!activityAllowed || !completion.length)) || !completion[0])) || !suggestRequest.keywords)) || ((completion[0].toLowerCase() != suggestRequest.keywords.toLowerCase()))))) {\n                            return;\n                        }\n                    ;\n                    ;\n                        var c = suggestRequest.counter, m = ((((c === 0)) ? metrics.completionsRequest0 : ((((c === metrics.sample)) ? metrics.completionsRequestSample : null))));\n                        suggestRequest.cleanup();\n                        suggestRequest = null;\n                        if (!searchBox.hasFocus()) {\n                            return;\n                        }\n                    ;\n                    ;\n                        if (((opt.twoPane === 1))) {\n                            twoPaneSuggestionsList = build2PaneSuggestions(completion[1], ((((completion.length > 2)) ? completion[2] : [])));\n                            displayTwoPaneSuggestions(completion[0]);\n                            ((sugHandler && sugHandler(completion[0], twoPaneSuggestionsList)));\n                        }\n                         else {\n                            suggestionList = combineSuggestions(completion[1], ((((completion.length > 2)) ? completion[2] : [])));\n                            displaySuggestions(completion[0]);\n                            ((sugHandler && sugHandler(completion[0], suggestionList)));\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    function JSBNG__stop() {\n                        activityAllowed = false;\n                        requestedKeyword = \"\";\n                        if (suggestRequest) {\n                            suggestRequest.cleanup();\n                            suggestRequest = null;\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    function start() {\n                        activityAllowed = true;\n                    };\n                ;\n                    function encoding() {\n                        var encInput = opt.form.JSBNG__find(\"input[name^='__mk_']\");\n                        if (encInput.length) {\n                            return [encInput.attr(\"JSBNG__name\"),encInput.val(),];\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    function JSBNG__blur() {\n                        searchBox.JSBNG__blur();\n                    };\n                ;\n                    function JSBNG__focus() {\n                        searchBox.JSBNG__focus();\n                    };\n                ;\n                    function offset() {\n                        return searchBox.pos();\n                    };\n                ;\n                    function keydown(h) {\n                        searchBox.keydown(h);\n                    };\n                ;\n                    function checkIAC() {\n                        return inlineAutoComplete.touch();\n                    };\n                ;\n                    return {\n                        suggest: bindSuggest,\n                        keypress: bindKeypress,\n                        submit: bindSubmit,\n                        JSBNG__blur: JSBNG__blur,\n                        keyword: keyword,\n                        merchant: merchant,\n                        searchAlias: searchAlias,\n                        searchNode: searchNode,\n                        JSBNG__stop: JSBNG__stop,\n                        start: start,\n                        encoding: encoding,\n                        JSBNG__focus: JSBNG__focus,\n                        offset: offset,\n                        keydown: keydown,\n                        onFocus: ((searchBox ? searchBox.onFocus : function() {\n                        \n                        })),\n                        onBlur: ((searchBox ? searchBox.onBlur : function() {\n                        \n                        })),\n                        cursorPos: ((searchBox ? searchBox.cursorPos : function() {\n                            return -1;\n                        })),\n                        initStaticSuggestions: initStatic,\n                        initDynamicSuggestions: initDynamic,\n                        updateAutoCompletion: updateCompletion,\n                        init: init\n                    };\n                };\n                function now() {\n                    return (new JSBNG__Date).getTime();\n                };\n            ;\n                function nop() {\n                \n                };\n            ;\n                function suppress() {\n                    return false;\n                };\n            ;\n                function bzero(len, val) {\n                    var a = [];\n                    while (len--) {\n                        a.push(val);\n                    };\n                ;\n                    return a;\n                };\n            ;\n                function arrayIndexOf(a, v) {\n                    for (var i = 0, len = a.length; ((i < len)); i++) {\n                        if (((a[i] == v))) {\n                            return i;\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    return -1;\n                };\n            ;\n                function input(f, i, n, v, c) {\n                    f.append($(\"\\u003Cinput type=\\\"hidden\\\"/\\u003E\").attr(((c ? \"class\" : \"id\")), i).attr(\"JSBNG__name\", n).attr(\"value\", v));\n                };\n            ;\n                function option(v, t) {\n                    return $(\"\\u003Coption/\\u003E\").attr(\"value\", v).text(t);\n                };\n            ;\n                function keyClose(w) {\n                    return ((((w == 13)) || ((w == 32))));\n                };\n            ;\n                function findOption(d, v) {\n                    return d.JSBNG__find(((((\"option[value=\\\"\" + v)) + \"\\\"]\")));\n                };\n            ;\n                function tabIndex(e, i) {\n                    return e.attr(\"tabIndex\", i).attr(\"tabindex\", i);\n                };\n            ;\n                function getShortenedIDForOption(o) {\n                    var eq;\n                    if (((((!o || !o.length)) || (((eq = o.indexOf(\"=\")) == -1))))) {\n                        return \"\";\n                    }\n                ;\n                ;\n                    var alias = o.substr(((eq + 1))), dash = ((alias.indexOf(\"-\") + 1)), shortID = alias.substr(0, 3);\n                    return ((dash ? shortID : ((shortID + alias.charAt(dash)))));\n                };\n            ;\n                function changeDropdownSelection(optionValue, selectedDisplayName, highlightOnly, option) {\n                    var dd = ddBox;\n                    if (((((optionValue == \"search-alias=aps\")) && !selectedDisplayName))) {\n                        selectedDisplayName = findOption(dd, optionValue).text();\n                    }\n                ;\n                ;\n                    $(((\"#\" + sdpc))).css(\"visibility\", \"hidden\");\n                    $(dcs).text(selectedDisplayName);\n                    dd.val(optionValue);\n                    if (!highlightOnly) {\n                        opt.sb.JSBNG__focus();\n                        setSearchFormReftag(opt.form, optionValue);\n                    }\n                ;\n                ;\n                };\n            ;\n                function setSearchFormReftag(formElement, optionValue, issMode, sg, numUserChars) {\n                    var formAction = formElement.attr(\"action\"), isstag = ((((issMode != null)) && sg)), tag = ((isstag ? ((((((((issMode + \"_\")) + sg.sgIndex)) + \"_\")) + numUserChars)) : ((\"dd_\" + getShortenedIDForOption(optionValue)))));\n                    if (((isstag || ((optionValue != null))))) {\n                        if (!refre.test(formAction)) {\n                            if (((formAction.charAt(((formAction.length - 1))) != \"/\"))) {\n                                formAction += \"/\";\n                            }\n                        ;\n                        ;\n                            formAction += tag;\n                        }\n                         else {\n                            if (((isstag && ddaliasre.test(formAction)))) {\n                                formAction = formAction.replace(ddaliasre, ((\"$1_\" + tag)));\n                            }\n                             else {\n                                formAction = formAction.replace(refre, ((\"ref=nb_sb_\" + tag)));\n                            }\n                        ;\n                        ;\n                        }\n                    ;\n                    ;\n                        formElement.attr(\"action\", formAction);\n                    }\n                ;\n                ;\n                };\n            ;\n                function A9JSONClient(kw, counter) {\n                    var fullUrl, noCacheIE, headLoc, scriptId, scriptObj, scriptCounter = ((counter || 0));\n                    function callService(url) {\n                        fullUrl = url;\n                        noCacheIE = ((\"&noCacheIE=\" + now()));\n                        headLoc = JSBNG__document.getElementsByTagName(\"head\").item(0);\n                        scriptId = ((\"JscriptId\" + scriptCounter));\n                        buildScriptTag();\n                        addScriptTag();\n                    };\n                ;\n                    function buildScriptTag() {\n                        scriptObj = JSBNG__document.createElement(\"script\");\n                        scriptObj.setAttribute(\"type\", \"text/javascript\");\n                        scriptObj.setAttribute(\"charset\", \"utf-8\");\n                        scriptObj.setAttribute(\"src\", ((fullUrl + noCacheIE)));\n                        scriptObj.setAttribute(\"id\", scriptId);\n                    };\n                ;\n                    function removeScriptTag() {\n                        try {\n                            headLoc.removeChild(scriptObj);\n                        } catch (e) {\n                        \n                        };\n                    ;\n                    };\n                ;\n                    function addScriptTag() {\n                        headLoc.appendChild(scriptObj);\n                    };\n                ;\n                    return {\n                        callSuggestionsService: callService,\n                        cleanup: removeScriptTag,\n                        keywords: kw,\n                        counter: scriptCounter\n                    };\n                };\n            ;\n                window.AutoComplete = AC;\n                if (metrics.isEnabled) {\n                    uet(\"cf\", metrics.init, {\n                        wb: 1\n                    });\n                }\n            ;\n            ;\n            })(window);\n            $SearchJS.publish(\"search-js-autocomplete-lib\");\n        });\n    }\n;\n;\n} catch (JSBNG_ex) {\n\n};");
// 1183
o2 = {};
// 1184
f881945950_65.returns.push(o2);
// 1185
o1.protocol = "http:";
// undefined
o1 = null;
// 1186
f881945950_7.returns.push(undefined);
// 1182
geval("var cloudfrontImg = new JSBNG__Image();\nif (((JSBNG__location.protocol == \"http:\"))) {\n    if (window.JSBNG__addEventListener) {\n        window.JSBNG__addEventListener(\"load\", ((window.top.JSBNG_Replay.push)((window.top.JSBNG_Replay.s6642b77f01f4d49ef240b29032e6da4372359178_0), function() {\n            JSBNG__setTimeout(((window.top.JSBNG_Replay.push)((window.top.JSBNG_Replay.s6642b77f01f4d49ef240b29032e6da4372359178_1), function() {\n                cloudfrontImg.src = \"http://cloudfront-labs.amazonaws.com/x.png\";\n            })), 400);\n        })), false);\n    }\n     else if (window.JSBNG__attachEvent) {\n        window.JSBNG__attachEvent(\"JSBNG__onload\", function() {\n            JSBNG__setTimeout(function() {\n                cloudfrontImg.src = \"http://cloudfront-labs.amazonaws.com/x.png\";\n            }, 400);\n        });\n    }\n    \n;\n;\n}\n;\n;");
// 1187
geval("amznJQ.onCompletion(\"amznJQ.criticalFeature\", function() {\n    var DPCL;\n    amznJQ.available(\"DPClientLogger\", function() {\n        if (((typeof window.DPClientLogger != \"undefined\"))) {\n            DPCL = new window.DPClientLogger.ImpressionLogger(\"dpbxapps\", \"bxapps-atfMarker\", true, true);\n        }\n    ;\n    ;\n    });\n    jQuery(\".oneClickSignInLink\").click(function(e) {\n        if (DPCL) {\n            DPCL.logImpression(\"ma-books-oneClick-signIn-C\");\n        }\n    ;\n    ;\n        return true;\n    });\n});");
// 1188
geval("var ImageBlockWeblabs = {\n};\nImageBlockWeblabs[\"swipe\"] = 0;\nImageBlockWeblabs[\"consolidated\"] = 1;\nImageBlockWeblabs[\"bookLargeImage\"] = 0;\namznJQ.available(\"ImageBlockATF\", function() {\n    amznJQ.onCompletion(\"amznJQ.criticalFeature\", function() {\n        var data = {\n            indexToColor: [\"initial\",],\n            visualDimensions: [\"color_name\",],\n            productGroupID: \"book_display_on_website\",\n            newVideoMissing: 0,\n            useIV: 1,\n            useChildVideos: 1,\n            numColors: 1,\n            defaultColor: \"initial\",\n            logMetrics: 0,\n            staticStrings: {\n                playVideo: \"Click to play video\",\n                rollOverToZoom: \"Roll over image to zoom in\",\n                images: \"Images\",\n                video: \"video\",\n                touchToZoom: \"Touch the image to zoom in\",\n                videos: \"Videos\",\n                close: \"Close\",\n                pleaseSelect: \"Please select\",\n                clickToExpand: \"Click to open expanded view\",\n                allMedia: \"All Media\"\n            },\n            gIsNewTwister: 0,\n            title: \"JavaScript: The Good Parts\",\n            ivRepresentativeAsin: {\n            },\n            mainImageSizes: [[\"300\",\"300\",],[\"300\",\"300\",],],\n            isQuickview: 0,\n            ipadVideoSizes: [[300,300,],[300,300,],],\n            colorToAsin: {\n            },\n            showLITBOnClick: 1,\n            stretchyGoodnessWidth: [1280,],\n            videoSizes: [[300,300,],[300,300,],],\n            autoplayVideo: 0,\n            hoverZoomIndicator: \"\",\n            sitbReftag: \"sib_dp_pt\",\n            useHoverZoom: 0,\n            staticImages: {\n                spinner: \"http://g-ecx.images-amazon.com/images/G/01/ui/loadIndicators/loading-large_labeled._V192238949_.gif\",\n                zoomOut: \"http://g-ecx.images-amazon.com/images/G/01/detail-page/cursors/zoom-out._V184888738_.bmp\",\n                hoverZoomIcon: \"http://g-ecx.images-amazon.com/images/G/01/img11/apparel/UX/DP/icon_zoom._V138923886_.png\",\n                zoomIn: \"http://g-ecx.images-amazon.com/images/G/01/detail-page/cursors/zoom-in._V184888790_.bmp\",\n                videoSWFPath: \"http://g-ecx.images-amazon.com/images/G/01/Quarterdeck/en_US/video/20110518115040892/Video._V178668404_.swf\",\n                zoomLensBackground: \"http://g-ecx.images-amazon.com/images/G/01/apparel/rcxgs/tile._V211431200_.gif\",\n                arrow: \"http://g-ecx.images-amazon.com/images/G/01/javascripts/lib/popover/images/light/sprite-vertical-popover-arrow._V186877868_.png\",\n                videoThumbIcon: \"http://g-ecx.images-amazon.com/images/G/01/Quarterdeck/en_US/images/video._V183716339_SS30_.gif\"\n            },\n            videos: [],\n            gPreferChildVideos: 1,\n            altsOnLeft: 0,\n            ivImageSetKeys: {\n                initial: 0\n            },\n            useHoverZoomIpad: \"\",\n            isUDP: 0,\n            alwaysIncludeVideo: 1,\n            widths: 0,\n            maxAlts: 7,\n            useChromelessVideoPlayer: 0\n        };\n        data[\"customerImages\"] = eval(\"[]\");\n        var def = ((colorImages ? colorImages[data.defaultColor] : []));\n        colorImages = {\n        };\n        colorImages[data.defaultColor] = def;\n        (function() {\n            var markup = \"%0A%0A%0A%0A%0A%0A%0A%0A%0A%3Cstyle%3E%0A%0Aa.slateLink%3Alink%7B%20color%3A%20rgb(119%2C119%2C119)%3B%20text-decoration%3Anone%3B%7D%0Aa.slateLink%3Aactive%20%7B%20color%3A%20rgb(119%2C119%2C119)%3B%20text-decoration%3Anone%3B%7D%0Aa.slateLink%3Avisited%7B%20color%3A%20rgb(119%2C119%2C119)%3B%20text-decoration%3Anone%3B%7D%0Aa.slateLink%3Ahover%7B%20color%3A%20rgb(119%2C119%2C119)%3B%20text-decoration%3Anone%3B%7D%0A%0A.shuttleGradient%20%7B%0A%20%20%20%20float%3Aleft%3B%0A%20%20%20%20width%3A100%25%3B%0A%20%20%20%20text-align%3Aleft%3B%0A%20%20%20%20line-height%3A%20normal%3B%0A%20%20%20%20position%3Arelative%3B%0A%20%20%20%20height%3A43px%3B%20%0A%20%20%20%20background-color%3A%23dddddd%3B%20%0A%20%20%20%20background-image%3A%20url(http%3A%2F%2Fg-ecx.images-amazon.com%2Fimages%2FG%2F01%2Fx-locale%2Fcommunities%2Fcustomerimage%2Fshuttle-gradient._V192250138_.gif)%3B%20%0A%20%20%20%20background-position%3A%20bottom%3B%20%0A%20%20%20%20background-repeat%20%3A%20repeat-x%3B%0A%7D%0A%0A.shuttleTextTop%20%7B%0A%20%20%20%20font-size%3A18px%3B%0A%20%20%20%20font-weight%3Abold%3B%0A%20%20%20%20font-family%3Averdana%2Carial%2Chelvetica%2Csans-serif%3B%0A%20%20%20%20color%3A%20rgb(119%2C119%2C119)%3B%0A%20%20%20%20margin-left%3A10px%3B%0A%7D%0A%0A.shuttleTextBottom%20%7B%0A%20%20%20%20margin-top%3A-2px%3B%0A%20%20%20%20font-size%3A15px%3B%0A%20%20%20%20font-family%3Averdana%2Carial%2Chelvetica%2Csans-serif%3B%0A%20%20%20%20color%3A%20rgb(119%2C119%2C119)%3B%0A%20%20%20%20margin-left%3A10px%3B%0A%7D%0A.outercenterslate%7B%0A%20%20%20%20cursor%3Apointer%3B%0A%7D%0A.innercenterslate%7B%0A%20%20%20%20overflow%3A%20hidden%3B%0A%7D%0A%0A.slateoverlay%7B%0A%20%20%20%20position%3A%20absolute%3B%0A%20%20%20%20top%3A%200px%3B%0A%20%20%20%20border%3A%200px%0A%7D%0A%0A.centerslate%20%7B%0A%20%20%20%20display%3A%20table-cell%3B%0A%20%20%20%20background-color%3Ablack%3B%20%0A%20%20%20%20text-align%3A%20center%3B%0A%20%20%20%20vertical-align%3A%20middle%3B%0A%7D%0A.centerslate%20*%20%7B%0A%20%20%20%20vertical-align%3A%20middle%3B%0A%7D%0A.centerslate%20%7B%20display%2F*%5C**%2F%3A%20block%5C9%20%7D%20%0A%2F*%5C*%2F%2F*%2F%0A.centerslate%20%7B%0A%20%20%20%20display%3A%20block%3B%0A%7D%0A.centerslate%20span%20%7B%0A%20%20%20%20display%3A%20inline-block%3B%0A%20%20%20%20height%3A%20100%25%3B%0A%20%20%20%20width%3A%201px%3B%0A%7D%0A%2F**%2F%0A%3C%2Fstyle%3E%0A%3C!--%5Bif%20lt%20IE%209%5D%3E%3Cstyle%3E%0A.centerslate%20span%20%7B%0A%20%20%20%20display%3A%20inline-block%3B%0A%20%20%20%20height%3A%20100%25%3B%0A%7D%0A%3C%2Fstyle%3E%3C!%5Bendif%5D--%3E%0A%3Cstyle%3E%0A%3C%2Fstyle%3E%0A%0A%3Cscript%20type%3D%22text%2Fjavascript%22%3E%0AamznJQ.addLogical(%22swfobject-2.2%22%2C%20%5B%22http%3A%2F%2Fz-ecx.images-amazon.com%2Fimages%2FG%2F01%2Fmedia%2Fswf%2Famznjq-swfobject-2.2._V210753426_.js%22%5D)%3B%0A%0Awindow.AmznVideoPlayer%3Dfunction(mediaObject%2CtargetId%2Cwidth%2Cheight)%7B%0A%20%20AmznVideoPlayer.players%5BmediaObject.mediaObjectId%5D%3Dthis%3B%0A%20%20this.slateImageUrl%3DmediaObject.slateImageUrl%3B%0A%20%20this.id%3DmediaObject.mediaObjectId%3B%0A%20%20this.preplayWidth%3Dwidth%3B%0A%20%20this.preplayHeight%3Dheight%3B%0A%20%20this.flashDivWidth%3Dwidth%3B%0A%20%20this.flashDivHeight%3Dheight%3B%0A%20%20this.targetId%3DtargetId%3B%0A%20%20this.swfLoading%3D0%3B%0A%20%20this.swfLoaded%3D0%3B%0A%20%20this.preplayDivId%3D'preplayDiv'%2Bthis.id%3B%0A%20%20this.flashDivId%3D'flashDiv'%2Bthis.id%3B%0A%7D%0A%0AAmznVideoPlayer.players%3D%5B%5D%3B%0AAmznVideoPlayer.session%3D'176-5336870-9447366'%3B%0AAmznVideoPlayer.root%3D'http%3A%2F%2Fwww.amazon.com'%3B%0AAmznVideoPlayer.locale%3D'en_US'%3B%0AAmznVideoPlayer.swf%3D'http%3A%2F%2Fg-ecx.images-amazon.com%2Fimages%2FG%2F01%2Fam3%2F20120510035744301%2FAMPlayer._V148501545_.swf'%3B%0AAmznVideoPlayer.preplayTemplate%3D'%3Cdiv%20style%3D%22width%3A0px%3Bheight%3A0px%3B%22%20class%3D%22outercenterslate%22%3E%3Cdiv%20style%3D%22width%3A0px%3Bheight%3A-43px%3B%22%20class%3D%22centerslate%22%20%3E%3Cspan%3E%3C%2Fspan%3E%3Cimg%20border%3D%220%22%20alt%3D%22Click%20to%20watch%20this%20video%22%20src%3D%22slateImageGoesHere%22%3E%3C%2Fdiv%3E%3Cdiv%20class%3D%22shuttleGradient%22%3E%3Cdiv%20class%3D%22shuttleTextTop%22%3EAmazon%3C%2Fdiv%3E%3Cdiv%20class%3D%22shuttleTextBottom%22%3EVideo%3C%2Fdiv%3E%3Cimg%20id%3D%22mediaObjectIdpreplayImageId%22%20style%3D%22height%3A74px%3Bposition%3Aabsolute%3Bleft%3A-31px%3Btop%3A-31px%3B%22%20src%3D%22http%3A%2F%2Fg-ecx.images-amazon.com%2Fimages%2FG%2F01%2Fx-locale%2Fcommunities%2Fcustomerimage%2Fplay-shuttle-off._V192250119_.gif%22%20border%3D%220%22%2F%3E%3C%2Fdiv%3E%3C%2Fdiv%3E'%3B%0AAmznVideoPlayer.rollOn%3D'http%3A%2F%2Fg-ecx.images-amazon.com%2Fimages%2FG%2F01%2Fx-locale%2Fcommunities%2Fcustomerimage%2Fplay-shuttle-on._V192250112_.gif'%3B%0AAmznVideoPlayer.rollOff%3D'http%3A%2F%2Fg-ecx.images-amazon.com%2Fimages%2FG%2F01%2Fx-locale%2Fcommunities%2Fcustomerimage%2Fplay-shuttle-off._V192250119_.gif'%3B%0AAmznVideoPlayer.flashVersion%3D'9.0.115'%3B%0AAmznVideoPlayer.noFlashMsg%3D'To%20view%20this%20video%20download%20%3Ca%20target%3D%22_blank%22%20href%3D%22http%3A%2F%2Fget.adobe.com%2Fflashplayer%2F%22%20target%3D%22_top%22%3EFlash%20Player%3C%2Fa%3E%20(version%209.0.115%20or%20higher)'%3B%0A%0AAmznVideoPlayer.hideAll%3Dfunction()%7B%0A%20%20for(var%20i%20in%20AmznVideoPlayer.players)%7B%0A%20%20%20%20AmznVideoPlayer.players%5Bi%5D.hidePreplay()%3B%0A%20%20%20%20AmznVideoPlayer.players%5Bi%5D.hideFlash()%3B%0A%20%20%7D%0A%7D%0A%0AAmznVideoPlayer.prototype.writePreplayHtml%3Dfunction()%7B%0A%20%20if(typeof%20this.preplayobject%3D%3D'undefined')%7B%0A%20%20%20%20this.preplayobject%3DjQuery(AmznVideoPlayer.preplayTemplate.replace(%22slateImageGoesHere%22%2Cthis.slateImageUrl)%0A%20%20%20%20%20%20%20%20.replace(%22mediaObjectId%22%2Cthis.id).replace(%22-43px%22%2C(this.preplayHeight-43)%2B%22px%22).replace(%22-31px%22%2C(Math.round(this.preplayWidth%2F2)-31)%2B%22px%22))%3B%0A%20%20%20%20this.preplayobject.width(this.preplayWidth%2B%22px%22).height(this.preplayHeight%2B%22px%22)%3B%0A%20%20%20%20this.preplayobject.find(%22.innercenterslate%22).width(this.preplayWidth%2B%22px%22).height(this.preplayHeight%2B%22px%22)%3B%0A%20%20%20%20this.preplayobject.find(%22.centerslate%22).width(this.preplayWidth%2B%22px%22)%3B%0A%20%20%20%20var%20self%3Dthis%3B%0A%20%20%20%20this.preparePlaceholder()%3B%0A%20%20%20%20jQuery(%22%23%22%2Bthis.preplayDivId).click(function()%7Bself.preplayClick()%3B%7D)%3B%0A%20%20%20%20jQuery(%22%23%22%2Bthis.preplayDivId).hover(%0A%20%20%20%20%20%20%20%20function()%7BjQuery(%22%23%22%2Bself.id%2B'preplayImageId').attr('src'%2CAmznVideoPlayer.rollOn)%3B%7D%2C%0A%20%20%20%20%20%20%20%20function()%7BjQuery(%22%23%22%2Bself.id%2B'preplayImageId').attr('src'%2CAmznVideoPlayer.rollOff)%3B%7D)%3B%0A%20%20%20%20jQuery(%22%23%22%2Bthis.preplayDivId).html(this.preplayobject)%3B%0A%20%20%7D%0A%7D%0A%0AAmznVideoPlayer.prototype.writeFlashHtml%3Dfunction()%7B%0A%20%20if(!this.swfLoaded%26%26!this.swfLoading)%7B%0A%20%20%20%20this.swfLoading%3D1%3B%0A%20%20%20%20var%20params%3D%7B'allowscriptaccess'%3A'always'%2C'allowfullscreen'%3A'true'%2C'wmode'%3A'transparent'%2C'quality'%3A'high'%7D%3B%0A%20%20%20%20var%20shiftJISRegExp%20%3D%20new%20RegExp(%22%5Ehttps%3F%3A%22%2BString.fromCharCode(0x5C)%2B%22%2F%22%2BString.fromCharCode(0x5C)%2B%22%2F%22)%3B%0A%20%20%20%20var%20flashvars%3D%7B'xmlUrl'%3AAmznVideoPlayer.root%2B'%2Fgp%2Fmpd%2Fgetplaylist-v2%2F'%2Bthis.id%2B'%2F'%2BAmznVideoPlayer.session%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20'mediaObjectId'%3Athis.id%2C'locale'%3AAmznVideoPlayer.locale%2C'sessionId'%3AAmznVideoPlayer.session%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20'amazonServer'%3AAmznVideoPlayer.root.replace(shiftJISRegExp%2C'')%2C'swfEmbedTime'%3Anew%20Date().getTime()%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20'allowFullScreen'%3A'true'%2C'amazonPort'%3A'80'%2C'preset'%3A'detail'%2C'autoPlay'%3A'1'%2C'permUrl'%3A'gp%2Fmpd%2Fpermalink'%2C'scale'%3A'noscale'%7D%3B%0A%20%20%20%20var%20self%3Dthis%3B%0A%20%20%20%20swfobject.embedSWF(AmznVideoPlayer.swf%2C'so_'%2Bthis.id%2C%22100%25%22%2C%22100%25%22%2CAmznVideoPlayer.flashVersion%2Cfalse%2Cflashvars%2Cparams%2Cparams%2C%0A%20%20%20%20%20%20function(e)%7B%0A%20%20%20%20%20%20%20%20self.swfLoading%3D0%3B%0A%20%20%20%20%20%20%20%20if(e.success)%7BAmznVideoPlayer.lastPlayedId%3Dself.id%3Bself.swfLoaded%3D1%3Breturn%3B%7D%0A%20%20%20%20%20%20%20%20jQuery('%23'%2Bself.flashDivId).html('%3Cbr%2F%3E%3Cbr%2F%3E%3Cbr%2F%3E%3Cbr%2F%3E%3Cbr%2F%3E%3Cbr%2F%3E%3Cbr%2F%3E'%2BAmznVideoPlayer.noFlashMsg).css(%7B'background'%3A'%23ffffff'%7D)%3B%0A%20%20%20%20%20%20%7D%0A%20%20%20%20)%3B%0A%20%20%7D%0A%7D%0A%0AAmznVideoPlayer.prototype.showPreplay%3Dfunction()%7B%0A%20%20this.writePreplayHtml()%3B%0A%20%20this.preparePlaceholder()%3B%0A%20%20jQuery(%22%23%22%2Bthis.preplayDivId).show()%3B%0A%20%20return%20this%3B%0A%7D%0A%0AAmznVideoPlayer.prototype.hidePreplay%3Dfunction()%7B%0A%20%20this.preparePlaceholder()%3B%0A%20%20jQuery(%22%23%22%2Bthis.preplayDivId).hide()%3B%0A%20%20return%20this%3B%0A%7D%0A%0AAmznVideoPlayer.prototype.showFlash%3Dfunction()%7B%0A%20%20this.preparePlaceholder()%3B%0A%20%20if(!this.swfLoaded%26%26!this.swfLoading)%7B%0A%20%20%20%20var%20self%3Dthis%3B%0A%20%20%20%20amznJQ.available(%22swfobject-2.2%22%2Cfunction()%7Bself.writeFlashHtml()%3B%7D)%3B%0A%20%20%7D%0A%20%20jQuery(%22%23%22%2Bthis.flashDivId).width(this.flashDivWidth%2B'px').height(this.flashDivHeight%2B'px')%3B%0A%20%20AmznVideoPlayer.lastPlayedId%3Dthis.id%3B%0A%20%20return%20this%3B%0A%7D%0A%0AAmznVideoPlayer.prototype.hideFlash%3Dfunction()%7B%0A%20%20this.preparePlaceholder()%3B%0A%20%20jQuery(%22%23%22%2Bthis.flashDivId).width('0px').height('1px')%3B%0A%20%20return%20this%3B%0A%7D%0A%0AAmznVideoPlayer.prototype.preparePlaceholder%3Dfunction()%7B%0A%20%20if(!(jQuery('%23'%2Bthis.flashDivId).length)%7C%7C!(jQuery('%23'%2Bthis.preplayDivId)))%7B%0A%20%20%20%20var%20preplayDiv%3DjQuery(%22%3Cdiv%20id%3D'%22%2Bthis.preplayDivId%2B%22'%3E%3C%2Fdiv%3E%22).css(%7B'position'%3A'relative'%7D)%3B%0A%20%20%20%20var%20flashDiv%3DjQuery(%22%3Cdiv%20id%3D'%22%2Bthis.flashDivId%2B%22'%3E%3Cdiv%20id%3D'so_%22%2Bthis.id%2B%22'%2F%3E%3C%2Fdiv%3E%22).css(%7B'overflow'%3A'hidden'%2Cbackground%3A'%23000000'%7D)%3B%0A%20%20%20%20var%20wrapper%3DjQuery(%22%3Cdiv%2F%3E%22).css(%7B'position'%3A'relative'%2C'float'%3A'left'%7D).append(preplayDiv).append(flashDiv)%3B%0A%20%20%20%20jQuery('%23'%2Bthis.targetId).html(wrapper)%3B%0A%20%20%7D%0A%7D%0A%0AAmznVideoPlayer.prototype.resizeVideo%3Dfunction(width%2Cheight)%7B%0A%20%20this.flashDivWidth%3Dwidth%3B%0A%20%20this.flashDivHeight%3Dheight%3B%0A%20%20if%20(jQuery(%22%23%22%2Bthis.flashDivId)%26%26jQuery(%22%23%22%2Bthis.flashDivId).width()!%3D0)%7Bthis.showFlash()%3B%7D%0A%7D%0A%0AAmznVideoPlayer.prototype.preplayClick%3Dfunction()%7B%20%0A%20%20if(this.swfLoaded)%7Bthis.play()%3B%7D%20%0A%20%20this.showFlash()%3B%0A%20%20this.hidePreplay()%3B%0A%7D%0A%0AAmznVideoPlayer.prototype.play%3Dfunction()%7B%0A%20%20var%20so%3Dthis.getSO()%3B%0A%20%20if(typeof%20so.playVideo%3D%3D'function')%7B%0A%20%20%20%20if(this.id!%3DAmznVideoPlayer.lastPlayedId)%7B%0A%20%20%20%20%20%20AmznVideoPlayer.players%5BAmznVideoPlayer.lastPlayedId%5D.pause()%3B%0A%20%20%20%20%7D%0A%20%20%20%20AmznVideoPlayer.lastPlayedId%3Dthis.id%3Bso.playVideo()%3B%0A%20%20%7D%0A%7D%0A%0AAmznVideoPlayer.prototype.pause%3Dfunction()%7Bif(this.swfLoading%7C%7Cthis.swfLoaded)%7Bthis.autoplayCancelled%3Dtrue%3B%7Dvar%20so%3Dthis.getSO()%3Bif(so%20%26%26%20typeof%20so.pauseVideo%3D%3D'function')%7Bso.pauseVideo()%3B%7D%7D%0AAmznVideoPlayer.prototype.stop%3Dfunction()%7Bif(this.swfLoading%7C%7Cthis.swfLoaded)%7Bthis.autoplayCancelled%3Dtrue%3B%7Dvar%20so%3Dthis.getSO()%3Bif(so%20%26%26%20typeof%20so.stopVideo%3D%3D'function')%7Bso.stopVideo()%3B%7D%7D%0AAmznVideoPlayer.prototype.getSO%3Dfunction()%7Breturn%20jQuery(%22%23so_%22%2Bthis.id).get(0)%3B%7D%0A%0Afunction%20isAutoplayCancelled(showID)%20%7B%0A%20%20return%20(AmznVideoPlayer.players%5BshowID%5D%20%26%26%20AmznVideoPlayer.players%5BshowID%5D.autoplayCancelled%20%3D%3D%20true)%3B%20%0A%7D%0A%3C%2Fscript%3E%0A\";\n            jQuery(\"\\u003Cdiv\\u003E\\u003C/div\\u003E\").insertAfter(\"#main-image-widget\").html(decodeURIComponent(markup));\n        })();\n        data.cfEndTimer = new JSBNG__Date();\n        amznJQ.available(\"imageBlock\", function() {\n            jQuery.imageBlock = new ImageBlock(data);\n            ImageBlock.TwisterReArchModule = function() {\n                return jQuery.imageBlock.getTwisterReArchApis();\n            }();\n        });\n    });\n});");
// 1189
geval("if (window.amznJQ) {\n    amznJQ.onCompletion(\"amznJQ.criticalFeature\", function() {\n        var precacheDetailImages = function(imageUrls, pids) {\n            function transformUrl(imgUrl, pid) {\n                var suffix = \"._SL500_AA300_.jpg\", defaultApparel = \"._AA300_.jpg\", imgUrlSplit = imgUrl.split(\"._\");\n                if (imgUrlSplit.length) {\n                    var prefix = imgUrlSplit[0];\n                    if (((((!pid && ((storeName == \"books\")))) || ((pid == \"books_display_on_website\"))))) {\n                        if (imgUrl.match(\"PIsitb-sticker-arrow\")) {\n                            var OUID = imgUrl.substr(imgUrl.indexOf(\"_OU\"), 6);\n                            var lookInsideSticker = ((((\"._BO2,204,203,200_PIsitb-sticker-arrow-click,TopRight,35,-76_AA300_SH20\" + OUID)) + \".jpg\"));\n                            urls.push(((prefix + lookInsideSticker)));\n                        }\n                         else {\n                            urls.push(((prefix + suffix)));\n                        }\n                    ;\n                    ;\n                    }\n                     else if (((((!pid && ((storeName == \"apparel\")))) || ((pid == \"apparel_display_on_website\"))))) {\n                        urls.push(((prefix + \"._SX342_.jpg\")));\n                        urls.push(((prefix + \"._SY445_.jpg\")));\n                    }\n                     else if (((((!pid && ((storeName == \"shoes\")))) || ((pid == \"shoes_display_on_website\"))))) {\n                        urls.push(((prefix + \"._SX395_.jpg\")));\n                        urls.push(((prefix + \"._SY395_.jpg\")));\n                    }\n                     else {\n                        urls.push(((prefix + suffix)));\n                    }\n                    \n                    \n                ;\n                ;\n                }\n            ;\n            ;\n            };\n        ;\n        ;\n            var urls = [], numImgsPreload = Math.min(6, imageUrls.length), storeName = \"books\";\n            for (var i = 0; ((i < numImgsPreload)); i++) {\n                var currPid = ((((pids && pids.length)) ? pids[i] : \"\"));\n                transformUrl(imageUrls[i], currPid);\n            };\n        ;\n            for (var j = 0; ((j < urls.length)); j++) {\n                var img = new JSBNG__Image();\n                img.src = urls[j];\n            };\n        ;\n        };\n        var win = jQuery(window);\n        var feature = jQuery(\"#purchaseShvl\");\n        var shvlPresent = ((((feature.length > 0)) ? 1 : 0));\n        var lastCheck = 0;\n        var pending = 0;\n        var onScrollPrecache = function() {\n            if (pending) {\n                return;\n            }\n        ;\n        ;\n            var lastCheckDiff = ((new JSBNG__Date().getTime() - lastCheck));\n            var checkDelay = ((((lastCheckDiff < 200)) ? ((200 - lastCheckDiff)) : 10));\n            pending = 1;\n            var u = function() {\n                if (((shvlPresent && ((((win.scrollTop() + win.height())) > ((feature.offset().JSBNG__top + 200))))))) {\n                    var p = precacheDetailImages, $ = jQuery;\n                    if (p) {\n                        var selector = \"#purchaseButtonWrapper\";\n                        var imgElems = $(selector).JSBNG__find(\"a \\u003E div \\u003E img\");\n                        var pgs, imgs = [], i = imgElems.length;\n                        while (((i-- > 0))) {\n                            imgs[i] = $(imgElems[i]).attr(\"src\");\n                        };\n                    ;\n                        p(imgs, pgs);\n                    }\n                ;\n                ;\n                    $(window).unbind(\"JSBNG__scroll\", onScrollPrecache);\n                    return;\n                }\n            ;\n            ;\n                pending = 0;\n                lastCheck = new JSBNG__Date().getTime();\n            };\n            JSBNG__setTimeout(u, checkDelay);\n            return;\n        };\n        jQuery(window).bind(\"JSBNG__scroll\", onScrollPrecache);\n    });\n}\n;\n;");
// 1190
geval("amznJQ.onCompletion(\"amznJQ.criticalFeature\", function() {\n    amznJQ.available(\"search-js-jq\", function() {\n    \n    });\n    amznJQ.available(\"amazonShoveler\", function() {\n    \n    });\n    amznJQ.available(\"simsJS\", function() {\n    \n    });\n    amznJQ.available(\"cmuAnnotations\", function() {\n    \n    });\n    amznJQ.available(\"externalJS.tagging\", function() {\n    \n    });\n    amznJQ.available(\"amzn-ratings-bar\", function() {\n    \n    });\n    amznJQ.available(\"accessoriesJS\", function() {\n    \n    });\n    amznJQ.available(\"priceformatterJS\", function() {\n    \n    });\n    amznJQ.available(\"CustomerPopover\", function() {\n    \n    });\n    if (!window.DPClientLogger) {\n        window.DPClientLogger = {\n        };\n    }\n;\n;\n    window.DPClientLogger.ImpressionLogger = function(program_group, feature, forceUpload, controlledLogging) {\n        var JSBNG__self = this, data = {\n        };\n        var isBooksUdploggingDisabled = false;\n        var enableNewCSMs = false;\n        var newCSMs = [\"ma-books-image-ftb-shown\",\"ma-books-image-listen-shown\",];\n        JSBNG__self.logImpression = function(key) {\n            if (!((((isBooksUdploggingDisabled && ((controlledLogging !== undefined)))) && controlledLogging))) {\n                var isNewCSM = JSBNG__self.isKeyNewCSM(key);\n                if (((!isNewCSM || ((isNewCSM && enableNewCSMs))))) {\n                    data[key] = 1;\n                    JSBNG__setTimeout(JSBNG__self.upload, 2000);\n                }\n            ;\n            ;\n            }\n        ;\n        ;\n        };\n        JSBNG__self.isKeyNewCSM = function(key) {\n            var isNewCSM = false;\n            jQuery.each(newCSMs, function(index, csm) {\n                if (((csm == key))) {\n                    isNewCSM = true;\n                }\n            ;\n            ;\n            });\n            return isNewCSM;\n        };\n        JSBNG__self.upload = function() {\n            var t = [];\n            jQuery.each(data, function(k, v) {\n                t.push(k);\n            });\n            data = {\n            };\n            if (((t.length > 0))) {\n                var protocol = ((((JSBNG__location.protocol == \"https:\")) ? \"http://jsbngssl.\" : \"http://\")), url = ((((((((((((((((((((((((((((((protocol + ue.furl)) + \"/1/action-impressions/1/OP/\")) + program_group)) + \"/action/\")) + feature)) + \":\")) + t.join())) + \"?marketplaceId=\")) + ue.mid)) + \"&requestId=\")) + ue.rid)) + \"&session=\")) + ue.sid)) + \"&_=\")) + (new JSBNG__Date()).getTime()));\n                (new JSBNG__Image()).src = url;\n            }\n        ;\n        ;\n        };\n        if (forceUpload) {\n            jQuery(window).unload(function() {\n                JSBNG__self.upload();\n            });\n        }\n    ;\n    ;\n    };\n    amznJQ.onReady(\"jQuery\", function() {\n        amznJQ.declareAvailable(\"DPClientLogger\");\n    });\n});");
// 1191
geval("amznJQ.addLogical(\"gridReviewCSS-US\", []);\namznJQ.addLogical(\"reviewsCSS-US\", []);");
// 1192
geval("window.$Nav.declare(\"config.prefetchUrls\", [\"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/cartPerformanceJS/cartPerformanceJS-2638627971._V1_.js\",\"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/cartWithAjaxJS/cartWithAjaxJS-40220677._V1_.js\",\"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/fruitCSS/US-combined-2621868138._V1_.css\",\"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/registriesCSS/US-combined-545184966._V376148880_.css\",\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/browser-scripts/site-wide-js-1.2.6-beacon/site-wide-11198044143._V1_.js\",\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/browser-scripts/us-site-wide-css-beacon/site-wide-6804619766._V1_.css\",\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/browser-scripts/wcs-ya-homepage-beaconized/wcs-ya-homepage-beaconized-1899362992._V1_.css\",\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/browser-scripts/wcs-ya-homepage-beaconized/wcs-ya-homepage-beaconized-3515399030._V1_.js\",\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/browser-scripts/wcs-ya-order-history-beaconized/wcs-ya-order-history-beaconized-2777963369._V1_.css\",\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/gno/beacon/BeaconSprite-US-01._V397411194_.png\",\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/gno/images/general/navAmazonLogoFooter._V169459313_.gif\",\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/x-locale/common/transparent-pixel._V386942464_.gif\",\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/x-locale/communities/social/snwicons_v2._V369764580_.png\",\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/x-locale/cs/css/images/amznbtn-sprite03._V387356454_.png\",\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/x-locale/cs/help/images/spotlight/kindle-family-02b._V386370244_.jpg\",\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/x-locale/cs/orders/images/acorn._V192250692_.gif\",\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/x-locale/cs/orders/images/amazon-gc-100._V192250695_.gif\",\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/x-locale/cs/orders/images/amazon-gcs-100._V192250695_.gif\",\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/x-locale/cs/orders/images/btn-close._V192250694_.gif\",\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/x-locale/cs/projects/text-trace/texttrace_typ._V381285749_.js\",\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/x-locale/cs/ya/images/new-link._V192250664_.gif\",\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/x-locale/cs/ya/images/shipment_large_lt._V192250661_.gif\",]);\n_navbar = ((window._navbar || {\n}));\n_navbar.prefetch = function() {\n    ((window.amznJQ && amznJQ.addPL(window.$Nav.getNow(\"config.prefetchUrls\"))));\n};\n((window.$Nav && $Nav.declare(\"config.prefetch\", _navbar.prefetch)));\n((window.$Nav && $Nav.declare(\"config.flyoutURL\", null)));\n((window.$Nav && $Nav.declare(\"btf.lite\")));\n((window.amznJQ && amznJQ.declareAvailable(\"navbarBTFLite\")));\n((window.$Nav && $Nav.declare(\"btf.full\")));\n((window.amznJQ && amznJQ.declareAvailable(\"navbarBTF\")));");
// 1193
geval("function e18e5a1a37b22c0bf100b6cafb1a14c56948581e4(JSBNG__event) {\n    if (((typeof (SitbReader) != \"undefined\"))) {\n        SitbReader.LightboxActions.openReaderToPage(1, null, \"sib_dp_pop_fc\");\n        return false;\n    }\n;\n;\n};\n;");
// 1194
geval("function e531724d117311681f207a58b392d5d85fd52c65c(JSBNG__event) {\n    if (((typeof (SitbReader) != \"undefined\"))) {\n        SitbReader.LightboxActions.openReaderToPage(8, null, \"sib_dp_pop_toc\");\n        return false;\n    }\n;\n;\n};\n;");
// 1195
geval("function eeb52dc77c638865e572128eabda352097ea3d982(JSBNG__event) {\n    if (((typeof (SitbReader) != \"undefined\"))) {\n        SitbReader.LightboxActions.openReaderToPage(16, null, \"sib_dp_pop_ex\");\n        return false;\n    }\n;\n;\n};\n;");
// 1196
geval("function e60727216e5cd3c9c6a3127f0e0195d975801bf48(JSBNG__event) {\n    if (((typeof (SitbReader) != \"undefined\"))) {\n        SitbReader.LightboxActions.openReaderToPage(162, null, \"sib_dp_pop_idx\");\n        return false;\n    }\n;\n;\n};\n;");
// 1197
geval("function e6aacc2f317620b27e17d1dd93308de782d13f354(JSBNG__event) {\n    if (((typeof (SitbReader) != \"undefined\"))) {\n        SitbReader.LightboxActions.openReaderToPage(172, null, \"sib_dp_pop_bc\");\n        return false;\n    }\n;\n;\n};\n;");
// 1198
geval("function e16685ada54157bf919b65cf2146fdf9cd4fff442(JSBNG__event) {\n    if (((typeof (SitbReader) != \"undefined\"))) {\n        SitbReader.LightboxActions.openReaderToRandomPage(\"sib_dp_pop_sup\");\n        return false;\n    }\n;\n;\n};\n;");
// 1199
geval("function eb1fd61d0f2467bbf4486b7a87ff01855f467b7d8(JSBNG__event) {\n    if (((typeof (SitbReader) != \"undefined\"))) {\n        SitbReader.LightboxActions.openReaderToSearchResults(jQuery(\"#sitb-pop-inputbox\").val(), \"sib_dp_srch_pop\");\n        return false;\n    }\n;\n;\n};\n;");
// 1200
geval("function sitb_doHide() {\n    return false;\n};\n;\nfunction sitb_showLayer() {\n    return false;\n};\n;\namznJQ.available(\"popover\", function() {\n    jQuery(\"div#main-image-wrapper\").amazonPopoverTrigger({\n        localContent: \"#sitb-pop\",\n        showOnHover: true,\n        showCloseButton: false,\n        hoverShowDelay: 500,\n        hoverHideDelay: 300,\n        width: 370,\n        JSBNG__location: \"left\",\n        locationOffset: [400,60,]\n    });\n});");
// 1201
geval("function ee6f08923500069ccb60b3c5b4ffe02ee9062405e(JSBNG__event) {\n    return amz_js_PopWin(this.href, \"AmazonHelp\", \"width=450,height=450,resizable=1,scrollbars=1,toolbar=1,status=1\");\n};\n;");
// 1202
geval("function efdff100ee742fecb8b858e7fddf0cfe2386b205d(JSBNG__event) {\n    showSLF();\n};\n;");
// 1203
geval("amznJQ.available(\"jQuery\", function() {\n    var obj = [{\n        provider: \"g\",\n        description: \"Chosen by top software vendors. View live examples &amp; full docs\",\n        title: \"Real Enterprise AJAX\",\n        redirectUrl: \"http://rd.a9.com/srv/redirect/?info=AL8KkmCyH0iKVuQSIAm82YMncWvHz0gp6BxeEvaeP9L.5Wk3AAIDff.fYApbbQqksWFPSd8Hq5k.052aufVMxYsBi29wGUisxBLrH12CdnuWn3CbrcagHTHX1udiRtpz2uB4DWQob.L7QIjDEehutRGXeN3YsBZmcB2vaNF9..x3mHlfrDEudBQqC7gMRfGTkM44QaJLIrB9WhQHCSn3uAVpjDGlHe0ETwYvTWb6-7DUR99LfTS7Oyq.E.T08Q6DCQmTMYrADnq0ee54i58C-OaJJBOrU4hJ.4L5AYFGsgBnESkljPfDN.Ls4LJzVU-9eUadrRcHZsw0vt58KS2Gs-kWpSG9LGi957Dd0Vwl8pAhx8Qr5qwyDG5OBiUZn3qnCFyeoe8xmLRXGyr.nQpevzc3ehX.gLt5bGzKjJOGPmIo90ealK8K-V9Q1UKfcKmeQwNpch8NeMKmoDuSCSE8LkH.qdOySJxbsaHefDF9A3sYCCqwzmoIOjI0Fasa5Q2qgD88Sze6atJr8M.MHfQYLJH05rkHNwQKmy3yClFnFEMLz.cLIbiZdfwGUyK3Xaqz-BPFIJ-a74eQx.YS.7-23dE_&awt=1&s=\",\n        visibleUrl: \"www.smartclient.com/\"\n    },{\n        provider: \"g\",\n        description: \"Find \\u003Cb\\u003EJavascript The Good Parts\\u003C/b\\u003E; Online at Ask.com. Try It Now!\",\n        title: \"\\u003Cb\\u003EJavascript The Good Parts\\u003C/b\\u003E\",\n        redirectUrl: \"http://rd.a9.com/srv/redirect/?info=AAFV92W9cuYKqQUBJdlfz8v1v83ZSqPuZD-C7fgh8dT9vIzgoqSlOci83RY71ecn-L.-EiIEfkucep8NmaiO.uW04kVQ3sXjHRxCyydC18Z9dvVztkK9PahpmZoXzzKaVtVZI56MW6Nlz-qy5PFXObwwLgOqnO0d5bWFjyvrrxeI8bg3HU6bdrNF.p8x7mIdk52rFDTupCtgCLNkaxC3NUroN7gzQMisxr9M3xg8GRqGDg1Uz5SnPUZW3zFSo7tiDSziA-EEtYMovtAnA4FMi3hAnY0CyBeEheSiEkGGmtPJDQsOTA2vRp0vB3NLhoJZ023tW-D6M8iUs-cbiS1nk67UW51b3w5m-r8KNT8MdzriG2OEWH6cujt2exjYa9EDBQpP3Px9SR8wQwSxaM0b6MNacqe7c.kav1FQJQMgWFj0Xih8v951VJNrHxN7I7BU-9BO5BUneZsjC5amK0XmK6BerG.RqF9fodmzLgisSODw5b-u.GyFvNtNjVWGmgMxrzRePAV6IXFbPQswczl8OXZtD4CLBn6YhDTg-abNRElkq3KdehjmtodT1F9H1UtW1H-cKy91-AVPGFJmKJ33gcdzGZz44sXLx5Qu0TQAu7IhTz8UAEKwOq-kXCKNITr2NWiy7qRb0gXikeWPBz1Gwn3ieZhuZcEU4JKay4QJmH3dyIZhHndeaf3LpqtaA1tT6ccpp5qxXJWSa5TPLf-1mD5HnE2sq6DxtHyKRYGkyy.bEs43NImOA7DiUDQLYXMScjD901kaabqvm5VuapBTI1Xl.T.hK2avsqDZ3tkqd4IRuiEJWZu22GNpotmUTiqo9w__&awt=1&s=\",\n        visibleUrl: \"www.ask.com/\\u003Cb\\u003EJavascript\\u003C/b\\u003E+The+\\u003Cb\\u003EGood\\u003C/b\\u003E+\\u003Cb\\u003EParts\\u003C/b\\u003E\"\n    },];\n    var adPropertiesDelimiter = \"__\";\n    var adCount = 2;\n    var slDiv = \"SlDiv\";\n    var expectedHeightWide = 34;\n    var expectedHeightMiddle = 56;\n    var reformatType = \"0\";\n    jQuery(window).load(function() {\n        amznJQ.onCompletion(\"amznJQ.criticalFeature\", function() {\n            var divWideName = ((slDiv + \"_0\"));\n            var divMiddleName = ((slDiv + \"_1\"));\n            var heightOfOneAd = ((jQuery(((\"#\" + divWideName))).height() / adCount));\n            if (((heightOfOneAd > expectedHeightWide))) {\n                reformatType = \"1\";\n                var newAdsHtml = ((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((\"\\u003Ctr\\u003E\" + \"    \\u003Ctd\\u003E\")) + \"     \\u003Cdiv class=\\\"SponsoredLinkItemTD\\\"\\u003E\")) + \"         \\u003Cspan class = \\\"SponsoredLinkYellowBlockEnclosureTop\\\"\\u003E\")) + \"             \\u003Cspan class=\\\"SponsoredLinkYellowBlockEnclosure\\\"\\u003E\")) + \"                 \\u003Cspan class=\\\"SponsoredLinkYellowBlock\\\"\\u003E&nbsp;\\u003C/span\\u003E&nbsp;\")) + \"             \\u003C/span\\u003E\")) + \"         \\u003C/span\\u003E&nbsp;&nbsp;\")) + \"     \\u003C/div\\u003E\")) + \"    \\u003C/td\\u003E\")) + \"    \\u003Ctd\\u003E\")) + \"     \\u003Cdiv class=\\\"SponsoredLinkTitle\\\"\\u003E\")) + \"         \\u003Ca target=\\\"_blank\\\" href=\\\"\")) + adPropertiesDelimiter)) + \"redirectUrl\")) + adPropertiesDelimiter)) + \"\\\" rel=\\\"nofollow\\\"\\u003E\\u003Cb\\u003E\")) + adPropertiesDelimiter)) + \"title\")) + adPropertiesDelimiter)) + \"\\u003C/b\\u003E\\u003C/a\\u003E\")) + \"         \\u003Ca target=\\\"_blank\\\" href=\\\"\")) + adPropertiesDelimiter)) + \"redirectUrl\")) + adPropertiesDelimiter)) + \"\\\" rel=\\\"nofollow\\\"\\u003E\\u003Cimg src=\\\"http://g-ecx.images-amazon.com/images/G/01/icons/icon-offsite-sl-7069-t4._V171196157_.png\\\" width=\\\"23\\\" alt=\\\"opens new browser window\\\" align=\\\"absbottom\\\" style=\\\"padding-bottom:0px; margin-bottom:0px;\\\" height=\\\"20\\\" border=\\\"0\\\" /\\u003E\\u003C/a\\u003E\")) + \"     \\u003C/div\\u003E\")) + \"    \\u003C/td\\u003E\")) + \"    \\u003Ctd style=\\\"padding-left: 20px;\\\"\\u003E\")) + \"     \\u003Cdiv class=\\\"SponsoredLinkDescriptionDIV\\\"\\u003E\")) + \"         \\u003Cspan class=\\\"SponsoredLinkDescriptionText\\\"\\u003E\")) + adPropertiesDelimiter)) + \"description\")) + adPropertiesDelimiter)) + \"\\u003C/span\\u003E\")) + \"     \\u003C/div\\u003E\")) + \"    \\u003C/td\\u003E\")) + \"\\u003C/tr\\u003E\")) + \"\\u003Ctr\\u003E\")) + \"     \\u003Ctd\\u003E\")) + \"     \\u003C/td\\u003E\")) + \"     \\u003Ctd\\u003E\")) + \"     \\u003C/td\\u003E\")) + \"    \\u003Ctd style=\\\"padding-left: 20px;\\\"\\u003E\")) + \"     \\u003Cdiv class=\\\"SponsoredLinkDescriptionDIV\\\" style=\\\"padding-top:0px; padding-bottom:10px\\\"\\u003E\")) + \"         \\u003Ca target=\\\"_blank\\\" href=\\\"\")) + adPropertiesDelimiter)) + \"redirectUrl\")) + adPropertiesDelimiter)) + \"\\\" rel=\\\"nofollow\\\" class=\\\"SponsoredLinkDescriptionUrlLink\\\"\\u003E\")) + adPropertiesDelimiter)) + \"visibleUrl\")) + adPropertiesDelimiter)) + \"\\u003C/a\\u003E\")) + \"     \\u003C/div\\u003E\")) + \"    \\u003C/td\\u003E\")) + \"\\u003C/tr\\u003E\"));\n                dumpHtml(obj, newAdsHtml, \"\\u003Cdiv id=\\\"SlDiv_1\\\"\\u003E\\u003Cdiv id=\\\"A9AdsWidgetAdsWrapper\\\"\\u003E\\u003Ctable class=\\\"SponsoredLinkColumnAds\\\"\\u003E  \\u003Ctbody\\u003E \", \"\\u003C/tbody\\u003E \\u003C/table\\u003E \\u003C/div\\u003E\\u003C/div\\u003E\", divWideName);\n                var heightOfOneAd = ((jQuery(((\"#\" + divMiddleName))).height() / adCount));\n                if (((heightOfOneAd > expectedHeightMiddle))) {\n                    reformatType = \"2\";\n                    var newAdsHtml = ((((((((((((((((((((((((((((((((((((((((((((((((\"\\u003Cdiv class=\\\"SponsoredLinkItemTD\\\"\\u003E  \\u003Cspan class=\\\"SponsoredLinkYellowBlockEnclosureTop\\\"\\u003E\\u003Cspan class=\\\"SponsoredLinkYellowBlockEnclosure\\\"\\u003E\\u003Cspan class=\\\"SponsoredLinkYellowBlock\\\"\\u003E&nbsp;\\u003C/span\\u003E&nbsp; \\u003C/span\\u003E\\u003C/span\\u003E&nbsp;&nbsp;\\u003Ca target=\\\"_blank\\\" href=\\\"\" + adPropertiesDelimiter)) + \"redirectUrl\")) + adPropertiesDelimiter)) + \"\\\" rel=\\\"nofollow\\\"\\u003E\\u003Cb\\u003E\")) + adPropertiesDelimiter)) + \"title\")) + adPropertiesDelimiter)) + \"\\u003C/b\\u003E\\u003C/a\\u003E&nbsp;\\u003Ca rel=\\\"nofollow\\\" href=\\\"\")) + adPropertiesDelimiter)) + \"redirectUrl\")) + adPropertiesDelimiter)) + \"\\\" target=\\\"_blank\\\"\\u003E\\u003Cimg src=\\\"http://g-ecx.images-amazon.com/images/G/01/icons/icon-offsite-sl-7069-t4._V171196157_.png\\\" width=\\\"23\\\" alt=\\\"opens new browser window\\\" align=\\\"absbottom\\\" style=\\\"padding-bottom:0px; margin-bottom:0px;\\\" height=\\\"20\\\" border=\\\"0\\\" /\\u003E\\u003C/a\\u003E  \\u003Cdiv class=\\\"SponsoredLinkDescription\\\"\\u003E&nbsp;&nbsp;&nbsp;&nbsp;\\u003Ca target=\\\"_blank\\\" href=\\\"\")) + adPropertiesDelimiter)) + \"redirectUrl\")) + adPropertiesDelimiter)) + \"\\\" rel=\\\"nofollow\\\" class=\\\"SponsoredLinkDescriptionUrlLink\\\"\\u003E\")) + adPropertiesDelimiter)) + \"visibleUrl\")) + adPropertiesDelimiter)) + \"\\u003C/a\\u003E  \\u003C/div\\u003E  \\u003Cdiv class=\\\"SponsoredLinkDescription\\\"\\u003E&nbsp;&nbsp;&nbsp;&nbsp;\\u003Cspan class=\\\"SponsoredLinkDescriptionText\\\"\\u003E\")) + adPropertiesDelimiter)) + \"description\")) + adPropertiesDelimiter)) + \"\\u003C/span\\u003E  \\u003C/div\\u003E \\u003C/div\\u003E\"));\n                    dumpHtml(obj, newAdsHtml, \"\\u003Cdiv id=\\\"SlDiv_2\\\"\\u003E\\u003Cdiv id=\\\"A9AdsWidgetAdsWrapper\\\"\\u003E\", \"\\u003C/div\\u003E\\u003C/div\\u003E\", divMiddleName);\n                }\n            ;\n            ;\n            }\n        ;\n        ;\n            if (((typeof A9_SL_CSM_JS != \"undefined\"))) {\n                A9_SL_CSM_JS(reformatType);\n            }\n        ;\n        ;\n        });\n    });\n    function dumpHtml(obj, newAdsHtml, topHtml, bottomHtml, divParent) {\n        var i = 0;\n        var completeAdsHtml = \"\";\n        {\n            var fin32keys = ((window.top.JSBNG_Replay.forInKeys)((obj))), fin32i = (0);\n            (0);\n            for (; (fin32i < fin32keys.length); (fin32i++)) {\n                ((x) = (fin32keys[fin32i]));\n                {\n                    var adChunks = newAdsHtml.split(adPropertiesDelimiter);\n                    for (var j = 0; ((j < adChunks.length)); j++) {\n                        if (((typeof obj[i][adChunks[j]] != \"undefined\"))) {\n                            adChunks[j] = obj[i][adChunks[j]];\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                    completeAdsHtml += adChunks.join(\"\");\n                    i++;\n                };\n            };\n        };\n    ;\n        newAdsHtml = ((((topHtml + completeAdsHtml)) + bottomHtml));\n        jQuery(((\"#\" + divParent))).replaceWith(newAdsHtml);\n    };\n;\n});\nvar jsonAds = \"[{\\\"provider\\\":\\\"g\\\",\\\"description\\\":\\\"Chosen by top software vendors. View live examples &amp; full docs\\\",\\\"title\\\":\\\"Real Enterprise AJAX\\\",\\\"redirectUrl\\\":\\\"http://rd.a9.com/srv/redirect/?info=AL8KkmCyH0iKVuQSIAm82YMncWvHz0gp6BxeEvaeP9L.5Wk3AAIDff.fYApbbQqksWFPSd8Hq5k.052aufVMxYsBi29wGUisxBLrH12CdnuWn3CbrcagHTHX1udiRtpz2uB4DWQob.L7QIjDEehutRGXeN3YsBZmcB2vaNF9..x3mHlfrDEudBQqC7gMRfGTkM44QaJLIrB9WhQHCSn3uAVpjDGlHe0ETwYvTWb6-7DUR99LfTS7Oyq.E.T08Q6DCQmTMYrADnq0ee54i58C-OaJJBOrU4hJ.4L5AYFGsgBnESkljPfDN.Ls4LJzVU-9eUadrRcHZsw0vt58KS2Gs-kWpSG9LGi957Dd0Vwl8pAhx8Qr5qwyDG5OBiUZn3qnCFyeoe8xmLRXGyr.nQpevzc3ehX.gLt5bGzKjJOGPmIo90ealK8K-V9Q1UKfcKmeQwNpch8NeMKmoDuSCSE8LkH.qdOySJxbsaHefDF9A3sYCCqwzmoIOjI0Fasa5Q2qgD88Sze6atJr8M.MHfQYLJH05rkHNwQKmy3yClFnFEMLz.cLIbiZdfwGUyK3Xaqz-BPFIJ-a74eQx.YS.7-23dE_&awt=1&s=\\\",\\\"visibleUrl\\\":\\\"www.smartclient.com/\\\"},{\\\"provider\\\":\\\"g\\\",\\\"description\\\":\\\"Find \\u003Cb\\u003EJavascript The Good Parts\\u003C/b\\u003E; Online at Ask.com. Try It Now!\\\",\\\"title\\\":\\\"\\u003Cb\\u003EJavascript The Good Parts\\u003C/b\\u003E\\\",\\\"redirectUrl\\\":\\\"http://rd.a9.com/srv/redirect/?info=AAFV92W9cuYKqQUBJdlfz8v1v83ZSqPuZD-C7fgh8dT9vIzgoqSlOci83RY71ecn-L.-EiIEfkucep8NmaiO.uW04kVQ3sXjHRxCyydC18Z9dvVztkK9PahpmZoXzzKaVtVZI56MW6Nlz-qy5PFXObwwLgOqnO0d5bWFjyvrrxeI8bg3HU6bdrNF.p8x7mIdk52rFDTupCtgCLNkaxC3NUroN7gzQMisxr9M3xg8GRqGDg1Uz5SnPUZW3zFSo7tiDSziA-EEtYMovtAnA4FMi3hAnY0CyBeEheSiEkGGmtPJDQsOTA2vRp0vB3NLhoJZ023tW-D6M8iUs-cbiS1nk67UW51b3w5m-r8KNT8MdzriG2OEWH6cujt2exjYa9EDBQpP3Px9SR8wQwSxaM0b6MNacqe7c.kav1FQJQMgWFj0Xih8v951VJNrHxN7I7BU-9BO5BUneZsjC5amK0XmK6BerG.RqF9fodmzLgisSODw5b-u.GyFvNtNjVWGmgMxrzRePAV6IXFbPQswczl8OXZtD4CLBn6YhDTg-abNRElkq3KdehjmtodT1F9H1UtW1H-cKy91-AVPGFJmKJ33gcdzGZz44sXLx5Qu0TQAu7IhTz8UAEKwOq-kXCKNITr2NWiy7qRb0gXikeWPBz1Gwn3ieZhuZcEU4JKay4QJmH3dyIZhHndeaf3LpqtaA1tT6ccpp5qxXJWSa5TPLf-1mD5HnE2sq6DxtHyKRYGkyy.bEs43NImOA7DiUDQLYXMScjD901kaabqvm5VuapBTI1Xl.T.hK2avsqDZ3tkqd4IRuiEJWZu22GNpotmUTiqo9w__&awt=1&s=\\\",\\\"visibleUrl\\\":\\\"www.ask.com/\\u003Cb\\u003EJavascript\\u003C/b\\u003E+The+\\u003Cb\\u003EGood\\u003C/b\\u003E+\\u003Cb\\u003EParts\\u003C/b\\u003E\\\"}]\";\nfunction enableFeedbackLinkDiv() {\n    amznJQ.onReady(\"jQuery\", function() {\n        jQuery(\"#ShowFeedbackLinkDiv\").show();\n    });\n};\n;\nenableFeedbackLinkDiv();\nvar flag = 1;\nfunction showSLF() {\n    if (((flag == 1))) {\n        jQuery.post(\"/gp/product/handler.html\", {\n            sid: \"176-5336870-9447366\",\n            jsonAds: escape(jsonAds)\n        }, function(data) {\n            jQuery(\"#FeedbackFormDiv\").html(data);\n            jQuery(\"#FeedbackFormDiv\").show();\n            jQuery(\"#ShowFeedbackLinkDiv\").hide();\n            jQuery(\"#ResponseFeedbackLinkDiv\").hide();\n            flag = 0;\n        });\n    }\n     else {\n        jQuery(\"#reports-ads-abuse-form\").show();\n        jQuery(\"#FeedbackFormDiv\").show();\n        jQuery(\"#reports-ads-abuse\").show();\n        jQuery(\"#ShowFeedbackLinkDiv\").hide();\n        jQuery(\"#ResponseFeedbackLinkDiv\").hide();\n    }\n;\n;\n};\n;");
// 1204
geval("function e3bb840522a6e7e8409178efff0ea058acfb1acea(JSBNG__event) {\n    return false;\n};\n;");
// 1205
geval("function e507f26413b06f51fcaf835e5bf9a04e9d0b3d2f7(JSBNG__event) {\n    return false;\n};\n;");
// 1206
geval("function e3137a023a5ae8ea7e80054e3fedf41a5d201998f(JSBNG__event) {\n    return false;\n};\n;");
// 1207
geval("function e31000786ba1c36e79389f374509c774c9f5cbfd9(JSBNG__event) {\n    amznJQ.available(\"jQuery\", function() {\n        window.AMZN_LIKE_SUBMIT = true;\n    });\n    return false;\n};\n;");
// 1208
geval("amznJQ.onCompletion(\"amznJQ.criticalFeature\", function() {\n    amznJQ.available(\"amazonLike\", function() {\n        var stateCache = new AmazonLikeStateCache(\"amznLikeStateCache_17653368709447366_dp_asin_0596517742\");\n        stateCache.init();\n        stateCache.ready(function() {\n            if (((stateCache.getTimestamp() < 1373479175))) {\n                stateCache.set(\"isLiked\", ((jQuery(\"#amznLikeStateCache_17653368709447366_dp_asin_0596517742_isLiked\").text() == \"true\")));\n                stateCache.set(\"customerWhitelistStatus\", parseInt(jQuery(\"#amznLikeStateCache_17653368709447366_dp_asin_0596517742_customerWhitelistStatus\").text()));\n                stateCache.set(\"likeCount\", parseInt(jQuery(\"#amznLikeStateCache_17653368709447366_dp_asin_0596517742_likeCount\").text()));\n                stateCache.set(\"commifiedLikeCount\", jQuery(\"#amznLikeStateCache_17653368709447366_dp_asin_0596517742_commifiedLikeCount\").text());\n                stateCache.set(\"commifiedLikeCountMinusOne\", jQuery(\"#amznLikeStateCache_17653368709447366_dp_asin_0596517742_commifiedLikeCountMinusOne\").text());\n                stateCache.set(\"ts\", \"1373479175\");\n            }\n        ;\n        ;\n            if (!window.amznLikeStateCache) {\n                window.amznLikeStateCache = {\n                };\n            }\n        ;\n        ;\n            window.amznLikeStateCache[\"amznLikeStateCache_17653368709447366_dp_asin_0596517742\"] = stateCache;\n        });\n        var amznLikeDiv = jQuery(\"#amznLike_0596517742\");\n        var stateCache = window.amznLikeStateCache[\"amznLikeStateCache_17653368709447366_dp_asin_0596517742\"];\n        amznLikeDiv.remove();\n        var amznLike;\n        amznLike = amznLikeDiv.amazonLike({\n            context: \"dp\",\n            itemId: \"0596517742\",\n            itemType: \"asin\",\n            isLiked: stateCache.get(\"isLiked\"),\n            customerWhitelistStatus: stateCache.get(\"customerWhitelistStatus\"),\n            isCustomerSignedIn: false,\n            isOnHover: false,\n            isPressed: false,\n            popoverWidth: 335,\n            popoverAlign: \"right\",\n            popoverOffset: 0,\n            sessionId: \"176-5336870-9447366\",\n            likeCount: stateCache.get(\"likeCount\"),\n            commifiedLikeCount: stateCache.get(\"commifiedLikeCount\"),\n            commifiedLikeCountMinusOne: stateCache.get(\"commifiedLikeCountMinusOne\"),\n            isSignInRedirect: false,\n            shareText: \"Share this item\",\n            onBeforeAttachPopoverCallback: function() {\n                jQuery(\"#likeAndShareBar\").append(amznLikeDiv).show();\n            },\n            spriteURL: \"http://g-ecx.images-amazon.com/images/G/01/x-locale/personalization/amznlike/amznlike_sprite_02._V196113939_.gif\",\n            buttonOnClass: \"JSBNG__on\",\n            buttonOffClass: \"off\",\n            buttonPressedClass: \"pressed\",\n            popoverHTML: ((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((\"\\u003Cdiv id=\" + \"\\\"\")) + \"amazonLikePopoverWrapper_0596517742\")) + \"\\\"\")) + \" class=\")) + \"\\\"\")) + \"amazonLikePopoverWrapper amazonLikeContext_dp\")) + \"\\\"\")) + \" \\u003E\")) + String.fromCharCode(13))) + \"\\u003Cdiv class=\")) + \"\\\"\")) + \"amazonLikeBeak \")) + \"\\\"\")) + \"\\u003E&nbsp;\\u003C/div\\u003E    \\u003Cdiv class=\")) + \"\\\"\")) + \"amazonLikePopover\")) + \"\\\"\")) + \"\\u003E\")) + String.fromCharCode(13))) + \"\\u003Cdiv class=\")) + \"\\\"\")) + \"likePopoverError\")) + \"\\\"\")) + \" style=\")) + \"\\\"\")) + \"display: none;\")) + \"\\\"\")) + \"\\u003E\")) + String.fromCharCode(13))) + \"\\u003Cspan class=\")) + \"\\\"\")) + \"error\")) + \"\\\"\")) + \" style=\")) + \"\\\"\")) + \"color: #900;\")) + \"\\\"\")) + \"\\u003E\\u003Cstrong\\u003EAn error has occurred. Please try your request again.\\u003C/strong\\u003E\\u003C/span\\u003E\")) + String.fromCharCode(13))) + \"\\u003C/div\\u003E\")) + String.fromCharCode(13))) + \"\\u003Cdiv class=\")) + \"\\\"\")) + \"likeOffPopoverContent\")) + \"\\\"\")) + \" \\u003E\")) + String.fromCharCode(13))) + \"\\u003Cdiv\\u003E\")) + String.fromCharCode(13))) + \"\\u003Cdiv class=\")) + \"\\\"\")) + \"likeCountText likeCountLoadingIndicator\")) + \"\\\"\")) + \" style=\")) + \"\\\"\")) + \"display: none;\")) + \"\\\"\")) + \"\\u003E\\u003Cimg src=\")) + \"\\\"\")) + \"http://g-ecx.images-amazon.com/images/G/01/javascripts/lib/popover/images/snake._V192571611_.gif\")) + \"\\\"\")) + \" width=\")) + \"\\\"\")) + \"16\")) + \"\\\"\")) + \" alt=\")) + \"\\\"\")) + \"Loading\")) + \"\\\"\")) + \" height=\")) + \"\\\"\")) + \"16\")) + \"\\\"\")) + \" border=\")) + \"\\\"\")) + \"0\")) + \"\\\"\")) + \" /\\u003E\\u003C/div\\u003E\")) + String.fromCharCode(13))) + \"\\u003Cspan style=\")) + \"\\\"\")) + \"font-weight: bold;\")) + \"\\\"\")) + \"\\u003E\\u003Ca class=\")) + \"\\\"\")) + \"likeSignInLink\")) + \"\\\"\")) + \" href=\")) + \"\\\"\")) + \"/gp/like/sign-in/sign-in.html/ref=pd_like_unrec_signin_nojs_dp?ie=UTF8&isRedirect=1&location=%2Fgp%2Flike%2Fexternal%2Fsubmit.html%2Fref%3Dpd_like_submit_like_unrec_nojs_dp%3Fie%3DUTF8%26action%3Dlike%26context%3Ddp%26itemId%3D0596517742%26itemType%3Dasin%26redirect%3D1%26redirectPath%3D%252Fgp%252Fproduct%252F0596517742%253Fref%25255F%253Dsr%25255F1%25255F1%2526s%253Dbooks%2526qid%253D1373479157%2526sr%253D1-1%2526keywords%253Djavascript%252520the%252520good%252520parts&useRedirectOnSuccess=1\")) + \"\\\"\")) + \"\\u003ESign in to like this\\u003C/a\\u003E.\\u003C/span\\u003E\")) + String.fromCharCode(13))) + \"\\u003C/div\\u003E\")) + String.fromCharCode(13))) + \"\\u003Cdiv class=\")) + \"\\\"\")) + \"spacer\")) + \"\\\"\")) + \"\\u003ETelling us what you like can improve your shopping experience. \\u003Ca class=\")) + \"\\\"\")) + \"grayLink\")) + \"\\\"\")) + \" href=\")) + \"\\\"\")) + \"/gp/help/customer/display.html/ref=pd_like_help_dp?ie=UTF8&nodeId=13316081#like\")) + \"\\\"\")) + \"\\u003ELearn more\\u003C/a\\u003E\\u003C/div\\u003E\")) + String.fromCharCode(13))) + \"\\u003C/div\\u003E\")) + String.fromCharCode(13))) + \"\\u003C/div\\u003E\")) + String.fromCharCode(13))) + \"\\u003C/div\\u003E\")),\n            stateCache: stateCache\n        });\n        if (window.AMZN_LIKE_SUBMIT) {\n            amznLike.onLike();\n        }\n    ;\n    ;\n    });\n});");
// 1209
geval("amznJQ.onReady(\"lazyLoadLib\", function() {\n    jQuery(\"#customer_discussions_lazy_load_div\").lazyLoadContent({\n        threshold: 400,\n        url: \"/gp/rcxll/dpview/0596517742?ie=UTF8&enableDiscussionsRelatedForums=1&keywords=javascript%20the%20good%20parts&qid=1373479157&ref_=sr_1_1&s=books&sr=1-1&vi=custdiscuss\",\n        metrics: true,\n        JSBNG__name: \"customer_discussions\",\n        cache: true\n    });\n});");
// 1210
geval("amznJQ.onReady(\"lazyLoadLib\", function() {\n    jQuery(\"#dp_bottom_lazy_lazy_load_div\").lazyLoadContent({\n        threshold: 1200,\n        url: \"/gp/rcxll/dpview/0596517742?ie=UTF8&keywords=javascript%20the%20good%20parts&qid=1373479157&ref_=sr_1_1&s=books&sr=1-1&vi=zbottest\",\n        metrics: true,\n        JSBNG__name: \"dp_bottom_lazy\",\n        cache: true\n    });\n});");
// 1211
geval("amznJQ.onReady(\"popover\", function() {\n    jQuery(\"#ns_0M4YTA6K9C1VFV7TYXNC_714_1_hmd_pricing_feedback_trigger_hmd\").amazonPopoverTrigger({\n        title: \"Tell Us About a Lower Price\",\n        destination: \"/gp/pdp/pf/pricingFeedbackForm.html/ref=sr_1_1_pfhmd?ie=UTF8&ASIN=0596517742&PREFIX=ns_0M4YTA6K9C1VFV7TYXNC_714_2_&from=hmd&keywords=javascript%20the%20good%20parts&originalURI=%2Fgp%2Fproduct%2F0596517742&qid=1373479157&s=books&sr=1-1&storeID=books\",\n        showOnHover: false,\n        draggable: true\n    });\n});");
// 1212
geval("var auiJavaScriptPIsAvailable = ((((typeof P === \"object\")) && ((typeof P.when === \"function\"))));\nvar rhfShovelerBootstrapFunction = function($) {\n    (function($) {\n        window.RECS_rhfShvlLoading = false;\n        window.RECS_rhfShvlLoaded = false;\n        window.RECS_rhfInView = false;\n        window.RECS_rhfMetrics = {\n        };\n        $(\"#rhf_container\").show();\n        var rhfShvlEventHandler = function() {\n            if (((((!window.RECS_rhfShvlLoaded && !window.RECS_rhfShvlLoading)) && (($(\"#rhf_container\").size() > 0))))) {\n                var yPosition = (($(window).scrollTop() + $(window).height()));\n                var rhfElementFound = $(\"#rhfMainHeading\").size();\n                var rhfPosition = $(\"#rhfMainHeading\").offset().JSBNG__top;\n                if (/webkit.*mobile/i.test(JSBNG__navigator.userAgent)) {\n                    rhfPosition -= $(window).scrollTop();\n                }\n            ;\n            ;\n                if (((rhfElementFound && ((((rhfPosition - yPosition)) < 400))))) {\n                    window.RECS_rhfMetrics[\"start\"] = (new JSBNG__Date()).getTime();\n                    window.RECS_rhfShvlLoading = true;\n                    var handleSuccess = function(html) {\n                        $(\"#rhf_container\").html(html);\n                        $(\"#rhf0Shvl\").trigger(\"render-shoveler\");\n                        window.RECS_rhfShvlLoaded = true;\n                        window.RECS_rhfMetrics[\"loaded\"] = (new JSBNG__Date()).getTime();\n                    };\n                    var handleError = function() {\n                        $(\"#rhf_container\").hide();\n                        $(\"#rhf_error\").show();\n                        window.RECS_rhfMetrics[\"loaded\"] = \"error\";\n                    };\n                    var ajaxURL = \"/gp/history/external/full-rhf-rec-handler.html\";\n                    var ajaxArgs = {\n                        type: \"POST\",\n                        timeout: 10000,\n                        data: {\n                            shovelerName: \"rhf0\",\n                            key: \"rhf\",\n                            numToPreload: \"8\",\n                            isGateway: 0,\n                            refTag: \"pd_rhf_dp\",\n                            parentSession: \"176-5336870-9447366\",\n                            relatedRequestId: \"0M4YTA6K9C1VFV7TYXNC\",\n                            excludeASIN: \"0596517742\",\n                            renderPopover: 0,\n                            forceSprites: 1,\n                            currentPageType: \"Detail\",\n                            currentSubPageType: \"Glance\",\n                            searchAlias: \"\",\n                            keywords: \"amF2YXNjcmlwdCB0aGUgZ29vZCBwYXJ0cw==\",\n                            node: \"\",\n                            ASIN: \"\",\n                            searchResults: \"\",\n                            isAUI: 0\n                        },\n                        dataType: \"json\",\n                        success: function(data, JSBNG__status) {\n                            if (((((((typeof (data) === \"object\")) && data.success)) && data.html))) {\n                                handleSuccess(data.html);\n                                if (((((typeof (P) === \"object\")) && ((typeof (P.when) === \"function\"))))) {\n                                    P.when(\"jQuery\", \"a-carousel-framework\").execute(function(jQuery, framework) {\n                                        jQuery(\"#rhf_upsell_div .a-carousel-viewport\").addClass(\"a-carousel-slide\");\n                                        framework.createAll();\n                                    });\n                                }\n                            ;\n                            ;\n                            }\n                             else {\n                                handleError();\n                            }\n                        ;\n                        ;\n                        },\n                        error: function(xhr, JSBNG__status) {\n                            handleError();\n                        }\n                    };\n                    if (((((typeof (P) === \"object\")) && ((typeof (P.when) === \"function\"))))) {\n                        P.when(\"A\").execute(function(A) {\n                            A.$.ajax(ajaxURL, ajaxArgs);\n                        });\n                    }\n                     else {\n                        ajaxArgs[\"url\"] = ajaxURL;\n                        $.ajax(ajaxArgs);\n                    }\n                ;\n                ;\n                }\n            ;\n            ;\n            }\n        ;\n        ;\n        };\n        var rhfInView = function() {\n            if (((!window.RECS_rhfInView && (($(\"#rhf_container\").size() > 0))))) {\n                var yPosition = (($(window).scrollTop() + $(window).height()));\n                var rhfElementFound = (($(\"#rhfMainHeading\").size() > 0));\n                var rhfPosition = $(\"#rhfMainHeading\").offset().JSBNG__top;\n                if (/webkit.*mobile/i.test(JSBNG__navigator.userAgent)) {\n                    rhfPosition -= $(window).scrollTop();\n                }\n            ;\n            ;\n                if (((rhfElementFound && ((((rhfPosition - yPosition)) < 0))))) {\n                    window.RECS_rhfInView = true;\n                    window.RECS_rhfMetrics[\"inView\"] = (new JSBNG__Date()).getTime();\n                }\n            ;\n            ;\n            }\n        ;\n        ;\n        };\n        window.rhfYBHTurnOn = function() {\n            $.ajax({\n                url: \"/gp/history/external/full-rhf-ybh-on-handler.html\",\n                type: \"POST\",\n                timeout: 2000,\n                data: {\n                    parentSession: \"176-5336870-9447366\"\n                },\n                dataType: \"text\",\n                success: function(data, JSBNG__status) {\n                    $(\"#yourBrowsingHistoryOnText\").JSBNG__find(\"p\").html(\"You don't have any recently viewed Items.\");\n                    $(\"#rhf-ybh-turn-on-link\").hide();\n                }\n            });\n        };\n        $(JSBNG__document).ready(rhfShvlEventHandler);\n        $(window).JSBNG__scroll(rhfShvlEventHandler);\n        $(JSBNG__document).ready(rhfInView);\n        $(window).JSBNG__scroll(rhfInView);\n    })($);\n};\nif (((((typeof (P) === \"object\")) && ((typeof (P.when) === \"function\"))))) {\n    P.when(\"jQuery\", \"ready\").register(\"rhf-bootstrapper\", function($) {\n        return {\n            bootstrap: function() {\n                return rhfShovelerBootstrapFunction($);\n            }\n        };\n    });\n    P.when(\"rhf-bootstrapper\").execute(function(rhfBootstrapper) {\n        rhfBootstrapper.bootstrap();\n    });\n}\n else {\n    amznJQ.onReady(\"jQuery\", function() {\n        rhfShovelerBootstrapFunction(jQuery);\n    });\n}\n;\n;");
// 1214
ow881945950.JSBNG__attachEvent = undefined;
// 1215
f881945950_7.returns.push(undefined);
// 1213
geval("(function(a, b) {\n    ((a.JSBNG__attachEvent ? a.JSBNG__attachEvent(\"JSBNG__onload\", b) : ((a.JSBNG__addEventListener && a.JSBNG__addEventListener(\"load\", b, !1)))));\n})(window, ((window.top.JSBNG_Replay.push)((window.top.JSBNG_Replay.sdaedc82b47673ce6de4c0b9c01978bd63c2c50e4_1), function() {\n    JSBNG__setTimeout(((window.top.JSBNG_Replay.push)((window.top.JSBNG_Replay.sdaedc82b47673ce6de4c0b9c01978bd63c2c50e4_2), function() {\n        var el = JSBNG__document.getElementById(\"sis_pixel_r2\");\n        ((el && (el.innerHTML = \"\\u003Cdiv id=\\\"DAsis\\\" src=\\\"//s.amazon-adsystem.com/iu3?d=amazon.com&slot=navFooter&a2=01017d3764a0e22b99f7e0982c99277cfd1bf3789d8bed21f7702111fbed3b53824e&old_oo=0&cb=1373479175047\\\" width=\\\"1\\\" height=\\\"1\\\" frameborder=\\\"0\\\" marginwidth=\\\"0\\\" marginheight=\\\"0\\\" scrolling=\\\"no\\\"\\u003E\\u003C/div\\u003E\")));\n    })), 300);\n})));");
// 1216
geval("amznJQ.addLogical(\"amazonLike\", [\"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/amazonLike/amazonLike-682075628._V1_.js\",]);");
// 1217
geval("amznJQ.onReady(\"jQuery\", function() {\n    jQuery(\".MHRExpandLink\").click(function(JSBNG__event) {\n        JSBNG__event.preventDefault();\n        jQuery(this).hide();\n        var parent = jQuery(this).parent();\n        var fullText = ((parent.JSBNG__find(\".MHRHead\").html() + parent.JSBNG__find(\".MHRRest\").html()));\n        var pxInitialSize = parent.height();\n        parent.html(fullText);\n        var pxTargetSize = parent.height();\n        parent.height(pxInitialSize);\n        parent.animate({\n            height: ((pxTargetSize + \"px\"))\n        });\n    });\n});\namznJQ.onReady(\"jQuery\", function() {\n    var voteAjaxDefaultBeforeSendReviews = function(buttonAnchor, buttonContainer, messageContainer) {\n        messageContainer.html(\"Sending feedback...\");\n        buttonContainer.hide();\n        messageContainer.show();\n    };\n    var voteAjaxDefaultSuccessReviews = function(aData, aStatus, buttonAnchor, buttonContainer, messageContainer, isNoButton, inappUrl) {\n        if (((aData.redirect == 1))) {\n            return window.JSBNG__location.href = buttonAnchor.children[0].href;\n        }\n    ;\n    ;\n        if (((aData.error == 1))) {\n            jQuery(buttonContainer.children()[0]).html(\"Sorry, we failed to record your vote. Please try again\");\n            messageContainer.hide();\n            buttonContainer.show();\n        }\n         else {\n            messageContainer.html(\"Thank you for your feedback.\");\n            if (((isNoButton == 1))) {\n                messageContainer.append(\"\\u003Cspan class=\\\"black gl5\\\"\\u003EIf this review is inappropriate, \\u003Ca href=\\\"http://www.amazon.com/gp/voting/cast/Reviews/2115/RNX5PEPWHPSHW/Inappropriate/1/ref=cm_cr_dp_abuse_voteyn?ie=UTF8&target=&token=9D362508C757901421B9FAC8E9EAF5981B7B1B58&voteAnchorName=RNX5PEPWHPSHW.2115.Inappropriate.Reviews&voteSessionID=176-5336870-9447366\\\" class=\\\"noTextDecoration\\\" style=\\\"color: #039;\\\" \\u003Eplease let us know.\\u003C/a\\u003E\\u003C/span\\u003E\");\n                messageContainer.JSBNG__find(\"a\").attr(\"href\", inappUrl);\n            }\n        ;\n        ;\n            messageContainer.addClass(\"green\");\n        }\n    ;\n    ;\n    };\n    var voteAjaxDefaultErrorReviews = function(aStatus, aError, buttonAnchor, buttonContainer, messageContainer) {\n        jQuery(buttonContainer.children()[0]).html(\"Sorry, we failed to record your vote. Please try again\");\n        messageContainer.hide();\n        buttonContainer.show();\n    };\n    jQuery(\".votingButtonReviews\").each(function() {\n        jQuery(this).unbind(\"click.vote.Reviews\");\n        jQuery(this).bind(\"click.vote.Reviews\", function() {\n            var buttonAnchor = this;\n            var buttonContainer = jQuery(this).parent();\n            var messageContainer = jQuery(buttonContainer).next(\".votingMessage\");\n            var inappUrl = messageContainer.children()[0].href;\n            var isNoButton = jQuery(this).hasClass(\"noButton\");\n            jQuery.ajax({\n                type: \"GET\",\n                dataType: \"json\",\n                ajaxTimeout: 10000,\n                cache: false,\n                beforeSend: function() {\n                    voteAjaxDefaultBeforeSendReviews(buttonAnchor, buttonContainer, messageContainer);\n                },\n                success: function(data, textStatus) {\n                    voteAjaxDefaultSuccessReviews(data, textStatus, buttonAnchor, buttonContainer, messageContainer, isNoButton, inappUrl);\n                },\n                error: function(JSBNG__XMLHttpRequest, textStatus, errorThrown) {\n                    voteAjaxDefaultErrorReviews(textStatus, errorThrown, buttonAnchor, buttonContainer, messageContainer);\n                },\n                url: ((buttonAnchor.children[0].href + \"&type=json\"))\n            });\n            return false;\n        });\n    });\n});");
// 1218
geval("if (((amznJQ && amznJQ.addPL))) {\n    amznJQ.addPL(\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/x-locale/common/errors-alerts/error-styles-ssl._V219086192_.css\");\n    amznJQ.addPL(\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/authportal/common/css/ap_global._V379708561_.css\");\n    amznJQ.addPL(\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/x-locale/checkout/signin-banner._V192194415_.gif\");\n    amznJQ.addPL(\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/authportal/common/images/amazon_logo_no-org_mid._V153387053_.png\");\n    amznJQ.addPL(\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/authportal/flex/reduced-nav/ap-flex-reduced-nav-2.1._V382581933_.css\");\n    amznJQ.addPL(\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/authportal/common/js/ap_global-1.1._V371300931_.js\");\n    amznJQ.addPL(\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/x-locale/common/transparent-pixel._V386942464_.gif\");\n    amznJQ.addPL(\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/x-locale/common/buttons/sign-in-secure._V192194766_.gif\");\n    amznJQ.addPL(\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/javascripts/lib/jquery/jquery-1.2.6.min._V253690767_.js\");\n    amznJQ.addPL(\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/advertising/dev/js/live/adSnippet._V142890782_.js\");\n    amznJQ.addPL(\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/gno/images/orangeBlue/navPackedSprites-US-22._V141013035_.png\");\n    amznJQ.addPL(\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/orderApplication/js/authPortal/sign-in._V375965495_.js\");\n    amznJQ.addPL(\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/authportal/flex/reduced-nav/ap-flex-reduced-nav-2.0._V393733149_.js\");\n    amznJQ.addPL(\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/x-locale/cs/css/images/amznbtn-sprite03._V387356454_.png\");\n    amznJQ.addPL(\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/orderApplication/css/authPortal/sign-in._V392399058_.css\");\n    amznJQ.addPL(\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/x-locale/common/login/fwcim._V369602065_.js\");\n}\n;\n;");
// 1219
geval("if (((window.amznJQ && amznJQ.addPL))) {\n    amznJQ.addPL([\"http://z-ecx.images-amazon.com/images/G/01/AUIClients/AmazonUI.aff0ce299d8ddf2009c96f8326e68987a8ae59df.min._V1_.css\",\"http://z-ecx.images-amazon.com/images/G/01/AUIClients/AmazonUIPageJS.0dc375a02ca444aee997ad607d84d1385192713c.min._V384607259_.js\",\"http://z-ecx.images-amazon.com/images/G/01/AUIClients/AmazonUI.e8545a213b3c87a7feb5d35882c39903ed6997cb.min._V397413143_.js\",]);\n}\n;\n;");
// 1220
geval("amznJQ.available(\"jQuery\", function() {\n    jQuery(window).load(function() {\n        JSBNG__setTimeout(function() {\n            var imageAssets = new Array();\n            var jsCssAssets = new Array();\n            imageAssets.push(\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/x-locale/common/buy-buttons/review-1-click-order._V192251243_.gif\");\n            imageAssets.push(\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/x-locale/common/buttons/continue-shopping._V192193522_.gif\");\n            imageAssets.push(\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/x-locale/common/buy-buttons/thank-you-elbow._V192238786_.gif\");\n            imageAssets.push(\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/x-locale/communities/social/snwicons_v2._V369764580_.png\");\n            imageAssets.push(\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/checkout/assets/carrot._V192196173_.gif\");\n            imageAssets.push(\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/checkout/thank-you-page/assets/yellow-rounded-corner-sprite._V192238288_.gif\");\n            imageAssets.push(\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/checkout/thank-you-page/assets/white-rounded-corner-sprite._V192259929_.gif\");\n            imageAssets.push(\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/gno/beacon/BeaconSprite-US-01._V397411194_.png\");\n            imageAssets.push(\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/x-locale/common/transparent-pixel._V386942464_.gif\");\n            jsCssAssets.push(\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/nav2/gamma/share-with-friends-css-new/share-with-friends-css-new-share-17385.css._V154656367_.css\");\n            jsCssAssets.push(\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/nav2/gamma/share-with-friends-js-new/share-with-friends-js-new-share-2043.js._V157885514_.js\");\n            jsCssAssets.push(\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/nav2/gamma/websiteGridCSS/websiteGridCSS-websiteGridCSS-48346.css._V176526456_.css\");\n            imageAssets.push(\"http://jsbngssl.images-na.ssl-images-amazon.com/images/I/51gdVAEfPUL._SX35_.jpg\");\n            jsCssAssets.push(\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/browser-scripts/us-site-wide-css-beacon/site-wide-6804619766._V1_.css\");\n            jsCssAssets.push(\"http://jsbngssl.images-na.ssl-images-amazon.com/images/G/01/browser-scripts/site-wide-js-1.2.6-beacon/site-wide-11198044143._V1_.js\");\n            for (var i = 0; ((i < imageAssets.length)); i++) {\n                new JSBNG__Image().src = imageAssets[i];\n            };\n        ;\n            var isIE = 0;\n            var isFireFox = /Firefox/.test(JSBNG__navigator.userAgent);\n            if (isIE) {\n                for (var i = 0; ((i < jsCssAssets.length)); i++) {\n                    new JSBNG__Image().src = jsCssAssets[i];\n                };\n            ;\n            }\n             else if (isFireFox) {\n                for (var i = 0; ((i < jsCssAssets.length)); i++) {\n                    var o = JSBNG__document.createElement(\"object\");\n                    o.data = jsCssAssets[i];\n                    o.width = o.height = 0;\n                    JSBNG__document.body.appendChild(o);\n                };\n            ;\n            }\n            \n        ;\n        ;\n        }, 2000);\n    });\n});");
// 1221
geval("var ocInitTimestamp = 1373479175;\namznJQ.onCompletion(\"amznJQ.criticalFeature\", function() {\n    amznJQ.available(\"jQuery\", function() {\n        jQuery.ajax({\n            url: \"http://z-ecx.images-amazon.com/images/G/01/orderApplication/javascript/pipeline/201201041713-ocd._V394759207_.js\",\n            dataType: \"script\",\n            cache: true\n        });\n    });\n});");
// 1222
geval("if (((!window.$SearchJS && window.$Nav))) {\n    window.$SearchJS = $Nav.make();\n}\n;\n;\nif (window.$SearchJS) {\n    $SearchJS.when(\"jQuery\").run(function(jQuery) {\n        if (((jQuery.fn.jquery == \"1.2.6\"))) {\n            var windowUnloadHandlers = jQuery.data(window, \"events\").unload;\n            {\n                var fin33keys = ((window.top.JSBNG_Replay.forInKeys)((windowUnloadHandlers))), fin33i = (0);\n                var origUnloadUnbinder;\n                for (; (fin33i < fin33keys.length); (fin33i++)) {\n                    ((origUnloadUnbinder) = (fin33keys[fin33i]));\n                    {\n                        break;\n                    };\n                };\n            };\n        ;\n            jQuery(window).unbind(\"unload\", windowUnloadHandlers[origUnloadUnbinder]).unload(function() {\n                if (jQuery.browser.msie) {\n                    var elems = JSBNG__document.getElementsByTagName(\"*\"), pos = ((elems.length + 1)), dummy = {\n                    };\n                    jQuery.data(dummy);\n                    {\n                        var fin34keys = ((window.top.JSBNG_Replay.forInKeys)((dummy))), fin34i = (0);\n                        var expando;\n                        for (; (fin34i < fin34keys.length); (fin34i++)) {\n                            ((expando) = (fin34keys[fin34i]));\n                            {\n                            ;\n                            };\n                        };\n                    };\n                ;\n                    while (pos--) {\n                        var elem = ((elems[pos] || JSBNG__document)), id = elem[expando];\n                        if (((((id && jQuery.cache[id])) && jQuery.cache[id].events))) {\n                            jQuery.JSBNG__event.remove(elem);\n                        }\n                    ;\n                    ;\n                    };\n                ;\n                }\n            ;\n            ;\n            });\n        }\n    ;\n    ;\n    });\n    $SearchJS.importEvent(\"search-sabc\", {\n        global: \"amzn.sx.sabc\"\n    });\n    $SearchJS.when(\"jQuery\", \"search-sabc\", \"page.loaded\").run(function($, sabc) {\n        var loadingSpinnerCss = ((((\"\\u003Cstyle type='text/css'\\u003E\" + \".loadingSpinner { background-image: url('http://g-ecx.images-amazon.com/images/G/01/nav2/images/gui/loading-large._V192184511_.gif '); background-repeat: no-repeat; height: 52px; width: 152px; margin-left: 50%; margin-top: 8px;}\")) + \"\\u003C/style\\u003E\"));\n        $(\"head\").append($(loadingSpinnerCss).attr({\n            type: \"text/css\"\n        }));\n        sabc.controllerInstance = new sabc.Controller(8, false, false, 5, [\"electronics-tradein\",\"moviestv-tradein\",\"textbooks-tradein\",\"videogames-tradein\",\"wireless-tradein\",\"books-tradein\",\"foreign-books-tradein\",\"music-tradein\",\"auctions\",\"local\",\"people\",\"tags\",\"ohs\",\"zshops\",\"community-reviews\",\"rp-listmania\",\"rp-sylt\",\"help\",\"digital-music\",\"digital-music-ss\",\"mp3-downloads\",\"music-dd\",\"us-digital-music-tree\",\"de-digital-music-tree\",\"fr-digital-music-tree\",\"uk-digital-music-tree\",\"digital-music-track\",\"digital-music-track-ss\",], [\"javascript the good parts\",]);\n    });\n    (function() {\n        var origPreloader = ((((((window.amznJQ && window.amznJQ.addPL)) || ((window.A && window.A.preload)))) || (function() {\n        \n        }))), preloader = origPreloader;\n        preloader([\"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/search-css/search-css-1522082039._V1_.css\",\"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/page-ajax/page-ajax-1808621310._V1_.js\",\"http://g-ecx.images-amazon.com/images/G/01/nav2/images/gui/searchSprite._V380202855_.png\",\"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/us-site-wide-css-beacon/site-wide-6804619766._V1_.css\",\"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/clickWithinSearchPageStatic/clickWithinSearchPageStatic-907040417._V1_.css\",\"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/search-js-general/search-js-general-1348801466._V1_.js\",\"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/search-ajax/search-ajax-3419689035._V1_.js\",\"http://g-ecx.images-amazon.com/images/G/01/gno/beacon/BeaconSprite-US-01._V397411194_.png\",\"http://g-ecx.images-amazon.com/images/G/01/x-locale/common/transparent-pixel._V386942464_.gif\",\"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/site-wide-js-1.6.4-beacon/site-wide-11900254310._V1_.js\",\"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/forester-client/forester-client-1094892990._V1_.js\",\"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/csmCELLS/csmCELLS-2626677177._V1_.js\",\"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/jserrors/jserrors-1871966242._V1_.js\",]);\n    })();\n}\n;\n;");
// 1224
o1 = {};
// 1225
o0.ue_backdetect = o1;
// 1227
o4 = {};
// 1228
o1.ue_back = o4;
// undefined
o1 = null;
// 1231
o4.value = "1";
// undefined
o4 = null;
// 1232
o1 = {};
// 1233
f881945950_0.returns.push(o1);
// 1234
o1.getTime = f881945950_397;
// undefined
o1 = null;
// 1235
f881945950_397.returns.push(1373479179086);
// 1236
f881945950_7.returns.push(undefined);
// 1237
f881945950_439 = function() { return f881945950_439.returns[f881945950_439.inst++]; };
f881945950_439.returns = [];
f881945950_439.inst = 0;
// 1238
ow881945950.JSBNG__onload = f881945950_439;
// 1223
geval("try {\n    (function(a) {\n        if (((JSBNG__document.ue_backdetect && JSBNG__document.ue_backdetect.ue_back))) {\n            a.ue.bfini = JSBNG__document.ue_backdetect.ue_back.value;\n        }\n    ;\n    ;\n        if (a.uet) {\n            a.uet(\"be\");\n        }\n    ;\n    ;\n        if (a.onLdEnd) {\n            if (window.JSBNG__addEventListener) {\n                window.JSBNG__addEventListener(\"load\", a.onLdEnd, false);\n            }\n             else {\n                if (window.JSBNG__attachEvent) {\n                    window.JSBNG__attachEvent(\"JSBNG__onload\", a.onLdEnd);\n                }\n            ;\n            ;\n            }\n        ;\n        ;\n        }\n    ;\n    ;\n        if (a.ueh) {\n            a.ueh(0, window, \"load\", a.onLd, 1);\n        }\n    ;\n    ;\n        if (((a.ue_pr && ((((a.ue_pr == 3)) || ((a.ue_pr == 4))))))) {\n            a.ue._uep();\n        }\n    ;\n    ;\n    })(ue_csm);\n} catch (JSBNG_ex) {\n\n};");
// 1240
o1 = {};
// 1241
o3.navigation = o1;
// 1242
o1.type = 0;
// 1243
o4 = {};
// 1244
f881945950_0.returns.push(o4);
// undefined
o4 = null;
// 1245
o4 = {};
// 1246
f881945950_0.returns.push(o4);
// 1247
f881945950_443 = function() { return f881945950_443.returns[f881945950_443.inst++]; };
f881945950_443.returns = [];
f881945950_443.inst = 0;
// 1248
o4.toGMTString = f881945950_443;
// undefined
o4 = null;
// 1249
f881945950_443.returns.push("Invalid Date");
// 1250
o4 = {};
// 1251
f881945950_0.returns.push(o4);
// undefined
o4 = null;
// 1239
geval("try {\n    (function(a) {\n        a._uec = function(d) {\n            var h = window, b = h.JSBNG__performance, f = ((b ? b.navigation.type : 0));\n            if (((f == 0))) {\n                var e = ((\"; expires=\" + new JSBNG__Date(((+new JSBNG__Date + 604800000))).toGMTString())), c = ((+new JSBNG__Date - ue_t0));\n                if (((c > 0))) {\n                    var g = ((\"|\" + +new JSBNG__Date));\n                    JSBNG__document.cookie = ((((((((\"csm-hit=\" + ((d / c)).toFixed(2))) + g)) + e)) + \"; path=/\"));\n                }\n            ;\n            ;\n            }\n        ;\n        ;\n        };\n    })(ue_csm);\n    _uec(447518);\n} catch (JSBNG_ex) {\n\n};");
// 1253
o4 = {};
// 1254
f881945950_0.returns.push(o4);
// 1255
o4.getHours = f881945950_413;
// 1256
f881945950_413.returns.push(13);
// 1257
o4.getMinutes = f881945950_414;
// 1258
f881945950_414.returns.push(59);
// 1259
o4.getSeconds = f881945950_415;
// undefined
o4 = null;
// 1260
f881945950_415.returns.push(40);
// 1265
f881945950_406.returns.push(null);
// 1270
f881945950_406.returns.push(null);
// 1271
f881945950_16.returns.push(3);
// 1273
o4 = {};
// 1274
f881945950_406.returns.push(o4);
// 1275
// 1276
o5 = {};
// 1277
f881945950_0.returns.push(o5);
// 1278
o5.getHours = f881945950_413;
// 1279
f881945950_413.returns.push(13);
// 1280
o5.getMinutes = f881945950_414;
// 1281
f881945950_414.returns.push(59);
// 1282
o5.getSeconds = f881945950_415;
// undefined
o5 = null;
// 1283
f881945950_415.returns.push(41);
// 1288
f881945950_406.returns.push(null);
// 1293
f881945950_406.returns.push(null);
// 1294
f881945950_16.returns.push(4);
// 1296
f881945950_406.returns.push(o4);
// 1297
o5 = {};
// 1298
f881945950_0.returns.push(o5);
// 1299
o5.getHours = f881945950_413;
// 1300
f881945950_413.returns.push(13);
// 1301
o5.getMinutes = f881945950_414;
// 1302
f881945950_414.returns.push(59);
// 1303
o5.getSeconds = f881945950_415;
// undefined
o5 = null;
// 1304
f881945950_415.returns.push(42);
// 1309
f881945950_406.returns.push(null);
// 1314
f881945950_406.returns.push(null);
// 1315
f881945950_16.returns.push(5);
// 1317
f881945950_406.returns.push(o4);
// 1318
o5 = {};
// 1319
f881945950_0.returns.push(o5);
// 1320
o5.getHours = f881945950_413;
// 1321
f881945950_413.returns.push(13);
// 1322
o5.getMinutes = f881945950_414;
// 1323
f881945950_414.returns.push(59);
// 1324
o5.getSeconds = f881945950_415;
// undefined
o5 = null;
// 1325
f881945950_415.returns.push(43);
// 1330
f881945950_406.returns.push(null);
// 1335
f881945950_406.returns.push(null);
// 1336
f881945950_16.returns.push(6);
// 1338
f881945950_406.returns.push(o4);
// 1339
o5 = {};
// 1340
f881945950_0.returns.push(o5);
// 1341
o5.getHours = f881945950_413;
// 1342
f881945950_413.returns.push(13);
// 1343
o5.getMinutes = f881945950_414;
// 1344
f881945950_414.returns.push(59);
// 1345
o5.getSeconds = f881945950_415;
// undefined
o5 = null;
// 1346
f881945950_415.returns.push(44);
// 1351
f881945950_406.returns.push(null);
// 1356
f881945950_406.returns.push(null);
// 1357
f881945950_16.returns.push(7);
// 1359
f881945950_406.returns.push(o4);
// 1360
o5 = {};
// 1361
f881945950_0.returns.push(o5);
// 1362
o5.getHours = f881945950_413;
// 1363
f881945950_413.returns.push(13);
// 1364
o5.getMinutes = f881945950_414;
// 1365
f881945950_414.returns.push(59);
// 1366
o5.getSeconds = f881945950_415;
// undefined
o5 = null;
// 1367
f881945950_415.returns.push(45);
// 1372
f881945950_406.returns.push(null);
// 1377
f881945950_406.returns.push(null);
// 1378
f881945950_16.returns.push(8);
// 1380
f881945950_406.returns.push(o4);
// 1381
o5 = {};
// 1382
f881945950_0.returns.push(o5);
// 1383
o5.getHours = f881945950_413;
// 1384
f881945950_413.returns.push(13);
// 1385
o5.getMinutes = f881945950_414;
// 1386
f881945950_414.returns.push(59);
// 1387
o5.getSeconds = f881945950_415;
// undefined
o5 = null;
// 1388
f881945950_415.returns.push(46);
// 1393
f881945950_406.returns.push(null);
// 1398
f881945950_406.returns.push(null);
// 1399
f881945950_16.returns.push(9);
// 1401
f881945950_406.returns.push(o4);
// 1402
o5 = {};
// 1403
f881945950_0.returns.push(o5);
// 1404
o5.getHours = f881945950_413;
// 1405
f881945950_413.returns.push(13);
// 1406
o5.getMinutes = f881945950_414;
// 1407
f881945950_414.returns.push(59);
// 1408
o5.getSeconds = f881945950_415;
// undefined
o5 = null;
// 1409
f881945950_415.returns.push(47);
// 1414
f881945950_406.returns.push(null);
// 1419
f881945950_406.returns.push(null);
// 1420
f881945950_16.returns.push(10);
// 1422
f881945950_406.returns.push(o4);
// 1423
o5 = {};
// 1424
f881945950_0.returns.push(o5);
// 1425
o5.getHours = f881945950_413;
// 1426
f881945950_413.returns.push(13);
// 1427
o5.getMinutes = f881945950_414;
// 1428
f881945950_414.returns.push(59);
// 1429
o5.getSeconds = f881945950_415;
// undefined
o5 = null;
// 1430
f881945950_415.returns.push(48);
// 1435
f881945950_406.returns.push(null);
// 1440
f881945950_406.returns.push(null);
// 1441
f881945950_16.returns.push(11);
// 1443
f881945950_406.returns.push(o4);
// 1444
o5 = {};
// 1445
o6 = {};
// 1446
f881945950_0.returns.push(o6);
// 1447
o6.getTime = f881945950_397;
// undefined
o6 = null;
// 1448
f881945950_397.returns.push(1373479188430);
// 1458
o6 = {};
// 1459
o3.timing = o6;
// undefined
o3 = null;
// 1461
o6.navigationStart = 1373479173975;
// 1464
o6.unloadEventStart = 1373479177633;
// 1465
o6.unloadEventEnd = 1373479177645;
// 1466
o6.redirectStart = 0;
// 1467
o6.redirectEnd = 0;
// 1468
o6.fetchStart = 1373479173976;
// 1469
o6.domainLookupStart = 1373479173976;
// 1470
o6.domainLookupEnd = 1373479173976;
// 1471
o6.connectStart = 1373479173976;
// 1472
o6.connectEnd = 1373479173976;
// 1473
o6.secureConnectionStart = void 0;
// 1474
o6.requestStart = 1373479173977;
// 1475
o6.responseStart = 1373479177632;
// 1476
o6.responseEnd = 1373479177679;
// 1477
o6.domLoading = 1373479177633;
// 1478
o6.domInteractive = 1373479179088;
// 1479
o6.domContentLoadedEventStart = 1373479179096;
// 1480
o6.domContentLoadedEventEnd = 1373479179096;
// 1481
o6.domComplete = 1373479188429;
// 1482
o6.loadEventStart = 1373479188429;
// 1483
o6.loadEventEnd = 0;
// undefined
o6 = null;
// 1486
o1.redirectCount = 0;
// undefined
o1 = null;
// 1488
o1 = {};
// 1489
f881945950_0.returns.push(o1);
// 1490
o1.getTime = f881945950_397;
// undefined
o1 = null;
// 1491
f881945950_397.returns.push(1373479188476);
// 1492
o1 = {};
// 1493
f881945950_65.returns.push(o1);
// 1494
// undefined
o1 = null;
// 1495
o1 = {};
// 1496
f881945950_0.returns.push(o1);
// undefined
o1 = null;
// 1497
f881945950_17.returns.push(12);
// 1498
f881945950_439.returns.push(undefined);
// 1499
f881945950_439.returns.push(undefined);
// 1500
f881945950_439.returns.push(undefined);
// 1501
f881945950_439.returns.push(undefined);
// 1502
f881945950_439.returns.push(undefined);
// 1503
f881945950_439.returns.push(undefined);
// 1504
f881945950_439.returns.push(undefined);
// 1505
f881945950_439.returns.push(undefined);
// 1506
f881945950_439.returns.push(undefined);
// 1507
f881945950_439.returns.push(undefined);
// 1508
f881945950_439.returns.push(undefined);
// 1509
f881945950_439.returns.push(undefined);
// 1510
f881945950_439.returns.push(undefined);
// 1511
f881945950_439.returns.push(undefined);
// 1512
f881945950_439.returns.push(undefined);
// 1513
f881945950_439.returns.push(undefined);
// 1514
f881945950_439.returns.push(undefined);
// 1515
f881945950_439.returns.push(undefined);
// 1516
f881945950_439.returns.push(undefined);
// 1517
f881945950_439.returns.push(undefined);
// 1518
f881945950_439.returns.push(undefined);
// 1519
f881945950_439.returns.push(undefined);
// 1520
f881945950_439.returns.push(undefined);
// 1521
f881945950_439.returns.push(undefined);
// 1522
f881945950_439.returns.push(undefined);
// 1523
f881945950_439.returns.push(undefined);
// 1524
f881945950_439.returns.push(undefined);
// 1525
f881945950_439.returns.push(undefined);
// 1526
f881945950_439.returns.push(undefined);
// 1527
f881945950_439.returns.push(undefined);
// 1528
f881945950_439.returns.push(undefined);
// 1529
f881945950_439.returns.push(undefined);
// 1530
f881945950_439.returns.push(undefined);
// 1531
f881945950_439.returns.push(undefined);
// 1532
f881945950_439.returns.push(undefined);
// 1533
f881945950_439.returns.push(undefined);
// 1534
f881945950_439.returns.push(undefined);
// 1535
f881945950_439.returns.push(undefined);
// 1536
f881945950_439.returns.push(undefined);
// 1537
f881945950_439.returns.push(undefined);
// 1538
f881945950_439.returns.push(undefined);
// 1539
f881945950_439.returns.push(undefined);
// 1540
f881945950_439.returns.push(undefined);
// 1541
f881945950_439.returns.push(undefined);
// 1542
f881945950_439.returns.push(undefined);
// 1543
f881945950_439.returns.push(undefined);
// 1544
f881945950_439.returns.push(undefined);
// 1545
f881945950_439.returns.push(undefined);
// 1546
f881945950_439.returns.push(undefined);
// 1547
f881945950_439.returns.push(undefined);
// 1548
f881945950_439.returns.push(undefined);
// 1549
f881945950_439.returns.push(undefined);
// 1550
f881945950_439.returns.push(undefined);
// 1551
f881945950_439.returns.push(undefined);
// 1552
f881945950_439.returns.push(undefined);
// 1553
f881945950_439.returns.push(undefined);
// 1554
f881945950_439.returns.push(undefined);
// 1555
f881945950_439.returns.push(undefined);
// 1556
f881945950_439.returns.push(undefined);
// 1557
f881945950_439.returns.push(undefined);
// 1558
f881945950_439.returns.push(undefined);
// 1559
f881945950_439.returns.push(undefined);
// 1560
f881945950_439.returns.push(undefined);
// 1561
f881945950_439.returns.push(undefined);
// 1562
f881945950_439.returns.push(undefined);
// 1563
f881945950_439.returns.push(undefined);
// 1564
f881945950_439.returns.push(undefined);
// 1565
f881945950_439.returns.push(undefined);
// 1566
f881945950_439.returns.push(undefined);
// 1567
f881945950_439.returns.push(undefined);
// 1568
f881945950_439.returns.push(undefined);
// 1569
f881945950_439.returns.push(undefined);
// 1570
f881945950_439.returns.push(undefined);
// 1571
f881945950_439.returns.push(undefined);
// 1572
f881945950_439.returns.push(undefined);
// 1573
f881945950_439.returns.push(undefined);
// 1574
f881945950_439.returns.push(undefined);
// 1575
f881945950_439.returns.push(undefined);
// 1576
f881945950_439.returns.push(undefined);
// 1577
f881945950_439.returns.push(undefined);
// 1578
f881945950_439.returns.push(undefined);
// 1579
f881945950_439.returns.push(undefined);
// 1580
f881945950_439.returns.push(undefined);
// 1581
f881945950_439.returns.push(undefined);
// 1582
f881945950_439.returns.push(undefined);
// 1583
f881945950_439.returns.push(undefined);
// 1584
f881945950_439.returns.push(undefined);
// 1585
f881945950_439.returns.push(undefined);
// 1586
f881945950_439.returns.push(undefined);
// 1587
f881945950_439.returns.push(undefined);
// 1588
f881945950_439.returns.push(undefined);
// 1589
f881945950_439.returns.push(undefined);
// 1590
f881945950_439.returns.push(undefined);
// 1591
f881945950_439.returns.push(undefined);
// 1592
f881945950_439.returns.push(undefined);
// 1593
f881945950_439.returns.push(undefined);
// 1594
f881945950_439.returns.push(undefined);
// 1595
f881945950_439.returns.push(undefined);
// 1596
f881945950_439.returns.push(undefined);
// 1597
f881945950_439.returns.push(undefined);
// 1598
f881945950_439.returns.push(undefined);
// 1599
f881945950_439.returns.push(undefined);
// 1600
f881945950_439.returns.push(undefined);
// 1601
f881945950_439.returns.push(undefined);
// 1602
f881945950_439.returns.push(undefined);
// 1603
f881945950_439.returns.push(undefined);
// 1604
f881945950_439.returns.push(undefined);
// 1605
f881945950_439.returns.push(undefined);
// 1606
f881945950_439.returns.push(undefined);
// 1607
f881945950_439.returns.push(undefined);
// 1608
f881945950_439.returns.push(undefined);
// 1609
f881945950_439.returns.push(undefined);
// 1610
f881945950_439.returns.push(undefined);
// 1611
f881945950_439.returns.push(undefined);
// 1612
f881945950_439.returns.push(undefined);
// 1613
f881945950_439.returns.push(undefined);
// 1614
f881945950_439.returns.push(undefined);
// 1615
f881945950_439.returns.push(undefined);
// 1616
f881945950_439.returns.push(undefined);
// 1617
f881945950_439.returns.push(undefined);
// 1618
f881945950_439.returns.push(undefined);
// 1619
f881945950_439.returns.push(undefined);
// 1620
f881945950_439.returns.push(undefined);
// 1621
f881945950_439.returns.push(undefined);
// 1622
f881945950_439.returns.push(undefined);
// 1623
f881945950_439.returns.push(undefined);
// 1624
f881945950_439.returns.push(undefined);
// 1625
f881945950_439.returns.push(undefined);
// 1626
f881945950_439.returns.push(undefined);
// 1627
f881945950_439.returns.push(undefined);
// 1628
f881945950_439.returns.push(undefined);
// 1629
f881945950_439.returns.push(undefined);
// 1630
f881945950_439.returns.push(undefined);
// 1631
f881945950_439.returns.push(undefined);
// 1632
f881945950_439.returns.push(undefined);
// 1633
f881945950_439.returns.push(undefined);
// 1634
f881945950_439.returns.push(undefined);
// 1635
f881945950_439.returns.push(undefined);
// 1636
f881945950_439.returns.push(undefined);
// 1637
f881945950_439.returns.push(undefined);
// 1638
f881945950_439.returns.push(undefined);
// 1639
f881945950_439.returns.push(undefined);
// 1640
f881945950_439.returns.push(undefined);
// 1641
f881945950_439.returns.push(undefined);
// 1642
f881945950_439.returns.push(undefined);
// 1643
f881945950_439.returns.push(undefined);
// 1644
f881945950_439.returns.push(undefined);
// 1645
f881945950_439.returns.push(undefined);
// 1646
f881945950_439.returns.push(undefined);
// 1647
f881945950_439.returns.push(undefined);
// 1648
f881945950_439.returns.push(undefined);
// 1649
f881945950_439.returns.push(undefined);
// 1650
f881945950_439.returns.push(undefined);
// 1651
f881945950_439.returns.push(undefined);
// 1652
f881945950_439.returns.push(undefined);
// 1653
f881945950_439.returns.push(undefined);
// 1654
f881945950_439.returns.push(undefined);
// 1655
f881945950_439.returns.push(undefined);
// 1656
f881945950_439.returns.push(undefined);
// 1657
f881945950_439.returns.push(undefined);
// 1658
f881945950_439.returns.push(undefined);
// 1659
f881945950_439.returns.push(undefined);
// 1660
f881945950_439.returns.push(undefined);
// 1661
f881945950_439.returns.push(undefined);
// 1662
f881945950_439.returns.push(undefined);
// 1663
f881945950_439.returns.push(undefined);
// 1664
f881945950_439.returns.push(undefined);
// 1665
f881945950_439.returns.push(undefined);
// 1666
f881945950_439.returns.push(undefined);
// 1667
f881945950_439.returns.push(undefined);
// 1668
f881945950_439.returns.push(undefined);
// 1669
f881945950_439.returns.push(undefined);
// 1670
f881945950_439.returns.push(undefined);
// 1671
f881945950_439.returns.push(undefined);
// 1672
f881945950_439.returns.push(undefined);
// 1673
f881945950_439.returns.push(undefined);
// 1674
f881945950_439.returns.push(undefined);
// 1675
f881945950_439.returns.push(undefined);
// 1676
f881945950_439.returns.push(undefined);
// 1677
f881945950_439.returns.push(undefined);
// 1678
f881945950_439.returns.push(undefined);
// 1679
f881945950_439.returns.push(undefined);
// 1680
f881945950_439.returns.push(undefined);
// 1681
f881945950_439.returns.push(undefined);
// 1682
f881945950_439.returns.push(undefined);
// 1683
f881945950_439.returns.push(undefined);
// 1684
f881945950_439.returns.push(undefined);
// 1685
f881945950_439.returns.push(undefined);
// 1686
f881945950_439.returns.push(undefined);
// 1687
f881945950_439.returns.push(undefined);
// 1688
f881945950_439.returns.push(undefined);
// 1689
f881945950_439.returns.push(undefined);
// 1690
f881945950_439.returns.push(undefined);
// 1691
f881945950_439.returns.push(undefined);
// 1692
f881945950_439.returns.push(undefined);
// 1693
f881945950_439.returns.push(undefined);
// 1694
f881945950_439.returns.push(undefined);
// 1695
f881945950_439.returns.push(undefined);
// 1696
f881945950_439.returns.push(undefined);
// 1697
f881945950_439.returns.push(undefined);
// 1698
f881945950_439.returns.push(undefined);
// 1699
f881945950_439.returns.push(undefined);
// 1700
f881945950_439.returns.push(undefined);
// 1701
f881945950_439.returns.push(undefined);
// 1702
f881945950_439.returns.push(undefined);
// 1703
f881945950_439.returns.push(undefined);
// 1704
f881945950_439.returns.push(undefined);
// 1705
f881945950_439.returns.push(undefined);
// 1706
f881945950_439.returns.push(undefined);
// 1707
f881945950_439.returns.push(undefined);
// 1708
f881945950_439.returns.push(undefined);
// 1709
f881945950_439.returns.push(undefined);
// 1710
f881945950_439.returns.push(undefined);
// 1711
f881945950_439.returns.push(undefined);
// 1712
f881945950_439.returns.push(undefined);
// 1713
f881945950_439.returns.push(undefined);
// 1714
f881945950_439.returns.push(undefined);
// 1715
f881945950_439.returns.push(undefined);
// 1716
f881945950_439.returns.push(undefined);
// 1717
f881945950_439.returns.push(undefined);
// 1718
f881945950_439.returns.push(undefined);
// 1719
f881945950_439.returns.push(undefined);
// 1720
f881945950_439.returns.push(undefined);
// 1721
f881945950_439.returns.push(undefined);
// 1722
f881945950_439.returns.push(undefined);
// 1723
f881945950_439.returns.push(undefined);
// 1724
f881945950_439.returns.push(undefined);
// 1725
f881945950_439.returns.push(undefined);
// 1726
f881945950_439.returns.push(undefined);
// 1727
f881945950_439.returns.push(undefined);
// 1728
f881945950_439.returns.push(undefined);
// 1729
f881945950_439.returns.push(undefined);
// 1730
f881945950_439.returns.push(undefined);
// 1731
f881945950_439.returns.push(undefined);
// 1732
f881945950_439.returns.push(undefined);
// 1733
f881945950_439.returns.push(undefined);
// 1734
f881945950_439.returns.push(undefined);
// 1735
f881945950_439.returns.push(undefined);
// 1736
f881945950_439.returns.push(undefined);
// 1737
f881945950_439.returns.push(undefined);
// 1738
f881945950_439.returns.push(undefined);
// 1739
f881945950_439.returns.push(undefined);
// 1740
f881945950_439.returns.push(undefined);
// 1741
f881945950_439.returns.push(undefined);
// 1742
f881945950_439.returns.push(undefined);
// 1743
f881945950_439.returns.push(undefined);
// 1744
f881945950_439.returns.push(undefined);
// 1745
f881945950_439.returns.push(undefined);
// 1746
f881945950_439.returns.push(undefined);
// 1747
f881945950_439.returns.push(undefined);
// 1748
f881945950_439.returns.push(undefined);
// 1749
f881945950_439.returns.push(undefined);
// 1750
f881945950_439.returns.push(undefined);
// 1751
f881945950_439.returns.push(undefined);
// 1752
f881945950_439.returns.push(undefined);
// 1753
f881945950_439.returns.push(undefined);
// 1754
f881945950_439.returns.push(undefined);
// 1755
f881945950_439.returns.push(undefined);
// 1756
f881945950_439.returns.push(undefined);
// 1757
f881945950_439.returns.push(undefined);
// 1758
f881945950_439.returns.push(undefined);
// 1759
f881945950_439.returns.push(undefined);
// 1760
f881945950_439.returns.push(undefined);
// 1761
f881945950_439.returns.push(undefined);
// 1762
f881945950_439.returns.push(undefined);
// 1763
f881945950_439.returns.push(undefined);
// 1764
f881945950_439.returns.push(undefined);
// 1765
f881945950_439.returns.push(undefined);
// 1766
f881945950_439.returns.push(undefined);
// 1767
f881945950_439.returns.push(undefined);
// 1768
f881945950_439.returns.push(undefined);
// 1769
f881945950_439.returns.push(undefined);
// 1770
f881945950_439.returns.push(undefined);
// 1771
f881945950_439.returns.push(undefined);
// 1772
f881945950_439.returns.push(undefined);
// 1773
f881945950_439.returns.push(undefined);
// 1774
f881945950_439.returns.push(undefined);
// 1775
f881945950_439.returns.push(undefined);
// 1776
f881945950_439.returns.push(undefined);
// 1777
f881945950_439.returns.push(undefined);
// 1778
f881945950_439.returns.push(undefined);
// 1779
f881945950_439.returns.push(undefined);
// 1780
f881945950_439.returns.push(undefined);
// 1781
f881945950_439.returns.push(undefined);
// 1782
f881945950_439.returns.push(undefined);
// 1783
f881945950_439.returns.push(undefined);
// 1784
// 1252
geval("amznJQ.addLogical(\"search-sabc\", [\"http://z-ecx.images-amazon.com/images/G/01/browser-scripts/search-sabc/search-sabc-605884639._V1_.js\",]);");
// 1786
f881945950_16.returns.push(13);
// 1785
JSBNG_Replay.s6642b77f01f4d49ef240b29032e6da4372359178_0[0](o5);
// 1788
f881945950_16.returns.push(14);
// 1787
JSBNG_Replay.sdaedc82b47673ce6de4c0b9c01978bd63c2c50e4_1[0](o5);
// undefined
o5 = null;
// 1791
o1 = {};
// 1792
f881945950_406.returns.push(o1);
// 1793
// undefined
o1 = null;
// 1789
JSBNG_Replay.sdaedc82b47673ce6de4c0b9c01978bd63c2c50e4_2[0]();
// 1795
// undefined
o2 = null;
// 1796
o1 = {};
// 1797
f881945950_0.returns.push(o1);
// 1798
o1.getHours = f881945950_413;
// 1799
f881945950_413.returns.push(13);
// 1800
o1.getMinutes = f881945950_414;
// 1801
f881945950_414.returns.push(59);
// 1802
o1.getSeconds = f881945950_415;
// undefined
o1 = null;
// 1803
f881945950_415.returns.push(49);
// 1808
f881945950_406.returns.push(null);
// 1813
f881945950_406.returns.push(null);
// 1814
f881945950_16.returns.push(15);
// 1816
f881945950_406.returns.push(o4);
// 1817
o1 = {};
// 1818
f881945950_0.returns.push(o1);
// 1819
o1.getHours = f881945950_413;
// 1820
f881945950_413.returns.push(13);
// 1821
o1.getMinutes = f881945950_414;
// 1822
f881945950_414.returns.push(59);
// 1823
o1.getSeconds = f881945950_415;
// undefined
o1 = null;
// 1824
f881945950_415.returns.push(50);
// 1829
f881945950_406.returns.push(null);
// 1834
f881945950_406.returns.push(null);
// 1835
f881945950_16.returns.push(16);
// 1837
f881945950_406.returns.push(o4);
// 1838
o1 = {};
// 1839
f881945950_0.returns.push(o1);
// 1840
o1.getHours = f881945950_413;
// 1841
f881945950_413.returns.push(13);
// 1842
o1.getMinutes = f881945950_414;
// 1843
f881945950_414.returns.push(59);
// 1844
o1.getSeconds = f881945950_415;
// undefined
o1 = null;
// 1845
f881945950_415.returns.push(51);
// 1850
f881945950_406.returns.push(null);
// 1855
f881945950_406.returns.push(null);
// 1856
f881945950_16.returns.push(17);
// 1858
f881945950_406.returns.push(o4);
// 1859
o1 = {};
// 1860
f881945950_0.returns.push(o1);
// 1861
o1.getHours = f881945950_413;
// 1862
f881945950_413.returns.push(13);
// 1863
o1.getMinutes = f881945950_414;
// 1864
f881945950_414.returns.push(59);
// 1865
o1.getSeconds = f881945950_415;
// undefined
o1 = null;
// 1866
f881945950_415.returns.push(52);
// 1871
f881945950_406.returns.push(null);
// 1876
f881945950_406.returns.push(null);
// 1877
f881945950_16.returns.push(18);
// 1879
f881945950_406.returns.push(o4);
// 1880
o1 = {};
// 1881
f881945950_0.returns.push(o1);
// 1882
o1.getHours = f881945950_413;
// 1883
f881945950_413.returns.push(13);
// 1884
o1.getMinutes = f881945950_414;
// 1885
f881945950_414.returns.push(59);
// 1886
o1.getSeconds = f881945950_415;
// undefined
o1 = null;
// 1887
f881945950_415.returns.push(53);
// 1892
f881945950_406.returns.push(null);
// 1897
f881945950_406.returns.push(null);
// 1898
f881945950_16.returns.push(19);
// 1900
f881945950_406.returns.push(o4);
// 1901
o1 = {};
// 1902
f881945950_0.returns.push(o1);
// 1903
o1.getHours = f881945950_413;
// 1904
f881945950_413.returns.push(13);
// 1905
o1.getMinutes = f881945950_414;
// 1906
f881945950_414.returns.push(59);
// 1907
o1.getSeconds = f881945950_415;
// undefined
o1 = null;
// 1908
f881945950_415.returns.push(54);
// 1913
f881945950_406.returns.push(null);
// 1918
f881945950_406.returns.push(null);
// 1919
f881945950_16.returns.push(20);
// 1921
f881945950_406.returns.push(o4);
// 1922
o1 = {};
// 1923
f881945950_0.returns.push(o1);
// 1924
o1.getHours = f881945950_413;
// 1925
f881945950_413.returns.push(13);
// 1926
o1.getMinutes = f881945950_414;
// 1927
f881945950_414.returns.push(59);
// 1928
o1.getSeconds = f881945950_415;
// undefined
o1 = null;
// 1929
f881945950_415.returns.push(55);
// 1934
f881945950_406.returns.push(null);
// 1939
f881945950_406.returns.push(null);
// 1940
f881945950_16.returns.push(21);
// 1942
f881945950_406.returns.push(o4);
// 1943
o1 = {};
// 1944
f881945950_0.returns.push(o1);
// 1945
o1.getHours = f881945950_413;
// 1946
f881945950_413.returns.push(13);
// 1947
o1.getMinutes = f881945950_414;
// 1948
f881945950_414.returns.push(59);
// 1949
o1.getSeconds = f881945950_415;
// undefined
o1 = null;
// 1950
f881945950_415.returns.push(56);
// 1955
f881945950_406.returns.push(null);
// 1960
f881945950_406.returns.push(null);
// 1961
f881945950_16.returns.push(22);
// 1963
f881945950_406.returns.push(o4);
// 1964
o1 = {};
// 1965
f881945950_0.returns.push(o1);
// 1966
o1.getHours = f881945950_413;
// 1967
f881945950_413.returns.push(13);
// 1968
o1.getMinutes = f881945950_414;
// 1969
f881945950_414.returns.push(59);
// 1970
o1.getSeconds = f881945950_415;
// undefined
o1 = null;
// 1971
f881945950_415.returns.push(57);
// 1976
f881945950_406.returns.push(null);
// 1981
f881945950_406.returns.push(null);
// 1982
f881945950_16.returns.push(23);
// 1984
f881945950_406.returns.push(o4);
// 1985
o1 = {};
// 1986
f881945950_0.returns.push(o1);
// 1987
o1.getHours = f881945950_413;
// 1988
f881945950_413.returns.push(13);
// 1989
o1.getMinutes = f881945950_414;
// 1990
f881945950_414.returns.push(59);
// 1991
o1.getSeconds = f881945950_415;
// undefined
o1 = null;
// 1992
f881945950_415.returns.push(58);
// 1997
f881945950_406.returns.push(null);
// 2002
f881945950_406.returns.push(null);
// 2003
f881945950_16.returns.push(24);
// 2005
f881945950_406.returns.push(o4);
// 2006
o1 = {};
// 2007
f881945950_0.returns.push(o1);
// 2008
o1.getHours = f881945950_413;
// 2009
f881945950_413.returns.push(13);
// 2010
o1.getMinutes = f881945950_414;
// 2011
f881945950_414.returns.push(59);
// 2012
o1.getSeconds = f881945950_415;
// undefined
o1 = null;
// 2013
f881945950_415.returns.push(59);
// 2018
f881945950_406.returns.push(null);
// 2023
f881945950_406.returns.push(null);
// 2024
f881945950_16.returns.push(25);
// 2026
f881945950_406.returns.push(o4);
// 2027
o1 = {};
// 2028
f881945950_0.returns.push(o1);
// 2029
o1.getHours = f881945950_413;
// 2030
f881945950_413.returns.push(14);
// 2031
o1.getMinutes = f881945950_414;
// 2032
f881945950_414.returns.push(0);
// 2033
o1.getSeconds = f881945950_415;
// undefined
o1 = null;
// 2034
f881945950_415.returns.push(0);
// 2039
f881945950_406.returns.push(null);
// 2044
f881945950_406.returns.push(null);
// 2045
f881945950_16.returns.push(26);
// 2047
f881945950_406.returns.push(o4);
// 2048
o1 = {};
// 2049
f881945950_0.returns.push(o1);
// 2050
o1.getHours = f881945950_413;
// 2051
f881945950_413.returns.push(14);
// 2052
o1.getMinutes = f881945950_414;
// 2053
f881945950_414.returns.push(0);
// 2054
o1.getSeconds = f881945950_415;
// undefined
o1 = null;
// 2055
f881945950_415.returns.push(1);
// 2060
f881945950_406.returns.push(null);
// 2065
f881945950_406.returns.push(null);
// 2066
f881945950_16.returns.push(27);
// 2068
f881945950_406.returns.push(o4);
// 2069
o1 = {};
// 2070
f881945950_0.returns.push(o1);
// 2071
o1.getHours = f881945950_413;
// 2072
f881945950_413.returns.push(14);
// 2073
o1.getMinutes = f881945950_414;
// 2074
f881945950_414.returns.push(0);
// 2075
o1.getSeconds = f881945950_415;
// undefined
o1 = null;
// 2076
f881945950_415.returns.push(2);
// 2081
f881945950_406.returns.push(null);
// 2086
f881945950_406.returns.push(null);
// 2087
f881945950_16.returns.push(28);
// 2089
f881945950_406.returns.push(o4);
// 2090
o1 = {};
// 2091
f881945950_0.returns.push(o1);
// 2092
o1.getHours = f881945950_413;
// 2093
f881945950_413.returns.push(14);
// 2094
o1.getMinutes = f881945950_414;
// 2095
f881945950_414.returns.push(0);
// 2096
o1.getSeconds = f881945950_415;
// undefined
o1 = null;
// 2097
f881945950_415.returns.push(3);
// 2102
f881945950_406.returns.push(null);
// 2107
f881945950_406.returns.push(null);
// 2108
f881945950_16.returns.push(29);
// 2110
f881945950_406.returns.push(o4);
// 2111
o1 = {};
// 2112
f881945950_0.returns.push(o1);
// 2113
o1.getHours = f881945950_413;
// 2114
f881945950_413.returns.push(14);
// 2115
o1.getMinutes = f881945950_414;
// 2116
f881945950_414.returns.push(0);
// 2117
o1.getSeconds = f881945950_415;
// undefined
o1 = null;
// 2118
f881945950_415.returns.push(4);
// 2123
f881945950_406.returns.push(null);
// 2128
f881945950_406.returns.push(null);
// 2129
f881945950_16.returns.push(30);
// 2131
f881945950_406.returns.push(o4);
// 2132
o1 = {};
// 2133
f881945950_0.returns.push(o1);
// 2134
o1.getHours = f881945950_413;
// 2135
f881945950_413.returns.push(14);
// 2136
o1.getMinutes = f881945950_414;
// 2137
f881945950_414.returns.push(0);
// 2138
o1.getSeconds = f881945950_415;
// undefined
o1 = null;
// 2139
f881945950_415.returns.push(5);
// 2144
f881945950_406.returns.push(null);
// 2149
f881945950_406.returns.push(null);
// 2150
f881945950_16.returns.push(31);
// 2152
f881945950_406.returns.push(o4);
// 2153
// 2154
o1 = {};
// 2155
f881945950_0.returns.push(o1);
// 2156
o1.getHours = f881945950_413;
// 2157
f881945950_413.returns.push(14);
// 2158
o1.getMinutes = f881945950_414;
// 2159
f881945950_414.returns.push(0);
// 2160
o1.getSeconds = f881945950_415;
// undefined
o1 = null;
// 2161
f881945950_415.returns.push(6);
// 2166
f881945950_406.returns.push(null);
// 2171
f881945950_406.returns.push(null);
// 2172
f881945950_16.returns.push(32);
// 2174
f881945950_406.returns.push(o4);
// undefined
o4 = null;
// 2175
o1 = {};
// 1794
JSBNG_Replay.s6642b77f01f4d49ef240b29032e6da4372359178_1[0]();
// 2177
o1.type = "mozvisibilitychange";
// 2178
o1.originalEvent = void 0;
// 2179
o0.mozVisibilityState = "hidden";
// 2180
o2 = {};
// 2181
f881945950_0.returns.push(o2);
// undefined
o2 = null;
// 2182
// 2176
fpc.call(JSBNG_Replay.sd77f26a2825b7813fef421f4fc64cccaae936b24_7[0], o0,o1);
// undefined
o0 = null;
// undefined
o1 = null;
// 2183
cb(); return null; }
finalize(); })();
