/*
 * Copyright (C) 2003, 2004, 2005 Filip Pizlo. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY FILIP PIZLO ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL FILIP PIZLO OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */

#ifndef FP_TSF_UTIL_H
#define FP_TSF_UTIL_H

#include "tsf.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>

#define CHECKTSF(exp) do {                                      \
        if (!(exp)) {                                           \
            fprintf(stderr,"TSF Error at %s:%d: %s\n",          \
                    __FILE__,__LINE__,tsf_get_error());         \
            exit(1);                                            \
        }                                                       \
    } while (0)

#define CHECKSYS(exp) do {                                  \
        if ((exp)<0) {                                      \
            fprintf(stderr,"System Error at %s:%d: %s\n",   \
                    __FILE__,__LINE__,strerror(errno));     \
            exit(1);                                        \
        }                                                   \
    } while (0)

#define CHECKSYSZ(exp) do {                                 \
        if (!(exp)) {                                       \
            fprintf(stderr,"System Error at %s:%d: %s\n",   \
                    __FILE__,__LINE__,strerror(errno));    \
            exit(1);                                        \
        }                                                   \
    } while (0)

#endif

