/*
 * Copyright (C) 2017 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */
"use strict";


let expectedFlightPlans = [
    new ExpectedFlightPlan("Rally Practice 1", "C83|" + keywords.get("Start") + " " + keywords.get("Taxi") + "|6:00 " + keywords.get("Runup") + "|0:30 " + keywords.get("Taxi") + "|1:00 " + keywords.get("Takeoff") + " " + keywords.get("Climb") + "|5500|5:00 CA67 0CN1 28CA 126kts I5.165 PT.ALPHA|" + keywords.get("Timing") + " KLSN " + keywords.get("Pattern") + "|0:45 " + keywords.get("Taxi") + "|2:00", "C83|Start Taxi|6:00 Runup|0:30 Taxi|1:00 Takeoff Climb|5500|5:00 CA67 0CN1 28CA 126kts I5.165 PT.ALPHA|Timing KLSN Pattern|0:45 Taxi|2:00", new Time("52:05"), new Time("44:35")),
    new ExpectedFlightPlan("Rally Practice 2", "C83|" + keywords.get("Start") + " " + keywords.get("Taxi") + "|6:00 " + keywords.get("Runup") + "|0:30 " + keywords.get("Taxi") + "|1:00 " + keywords.get("Takeoff") + " " + keywords.get("Climb") + "|5500|5:00 ECA 343@4 5CL3 67CA 314@12 126kts I5.165 126kts PT.ALPHA|" + keywords.get("Timing") + "  126kts KLSN " + keywords.get("Pattern") + "|0:45 " + keywords.get("Taxi") + "|2:00", "C83|Start Taxi|6:00 Runup|0:30 Taxi|1:00 Takeoff Climb|5500|5:00 ECA 343@4 5CL3 67CA 314@12 126kts I5.165 126kts PT.ALPHA|Timing 126kts KLSN Pattern|0:45 Taxi|2:00", new Time("1:03:44"), new Time("56:14")),
    new ExpectedFlightPlan("Rally Practice 3", "KTCY|" + keywords.get("Start") + " " + keywords.get("Taxi") + "|6:00 " + keywords.get("Runup") + "|0:30 " + keywords.get("Taxi") + "|1:00 " + keywords.get("Takeoff") + " " + keywords.get("Climb") + "|3500|5:00 O27 67CA OILCAMP I5.WESTSHIELDS I5.165 I5.VOLTA PT.ALPHA|" + keywords.get("Timing") + " KLSN " + keywords.get("Pattern") + "|0:45 " + keywords.get("Taxi") + "|2:00", "KTCY|Start Taxi|6:00 Runup|0:30 Taxi|1:00 Takeoff Climb|3500|5:00 O27 67CA Oilcamp I5.Westshields I5.165 I5.VOLTA PT.ALPHA|Timing KLSN Pattern|0:45 Taxi|2:00", new Time("1:06:20"), new Time("58:50")),
    new ExpectedFlightPlan("Rally Practice 4", "C83|" + keywords.get("Start") + " " + keywords.get("Taxi") + "|6:00 " + keywords.get("Runup") + "|0:30 " + keywords.get("Taxi") + "|1:00 " + keywords.get("Takeoff") + " " + keywords.get("Climb") + "|5500|5:00 62@3 9CL0 342@9 CL84 28CA 315@10 126kts I5.165 126kts PT.ALPHA|" + keywords.get("Timing") + "  126kts KLSN " + keywords.get("Pattern") + "|0:45 " + keywords.get("Taxi") + "|2:00", "C83|Start Taxi|6:00 Runup|0:30 Taxi|1:00 Takeoff Climb|5500|5:00 62@3 9CL0 342@9 CL84 28CA 315@10 126kts I5.165 126kts PT.ALPHA|Timing 126kts KLSN Pattern|0:45 Taxi|2:00", new Time("54:32"), new Time("47:02")),
    new ExpectedFlightPlan("Rally Practice 5", "C83|" + keywords.get("Start") + " " + keywords.get("Taxi") + "|6:00 " + keywords.get("Runup") + "|0:30 " + keywords.get("Taxi") + "|1:00 " + keywords.get("Takeoff") + " " + keywords.get("Climb") + "|5500|7:00 O27 9CL0 CL01 I5.165 PT.ALPHA KLSN " + keywords.get("Pattern") + "|0:45 " + keywords.get("Taxi") + "|2:00", "C83|Start Taxi|6:00 Runup|0:30 Taxi|1:00 Takeoff Climb|5500|7:00 O27 9CL0 CL01 I5.165 PT.ALPHA KLSN Pattern|0:45 Taxi|2:00", new Time("1:01:43"), new Time("54:13")),
    new ExpectedFlightPlan("2014 HWD Rally Leg 1", "KHWD|" + keywords.get("Start") + " " + keywords.get("Taxi") + "|6:00 " + keywords.get("Runup") + "|0:30 " + keywords.get("Taxi") + "|1:00 " + keywords.get("Takeoff") + " " + keywords.get("Climb") + "|5500|4:35 VPDUB " + keywords.get("Climb") + "|8500|6:25 2CL9 " + keywords.get("Left") + "|+1 09CL " + keywords.get("Left") + "|+1 O02 " + keywords.get("Left") + "|+1 77NV " + keywords.get("Left") + " 126kts HALE|" + keywords.get("Timing") + " KSPZ " + keywords.get("Pattern") + "|0:45 " + keywords.get("Taxi") + "|2:00", "KHWD|Start Taxi|6:00 Runup|0:30 Taxi|1:00 Takeoff Climb|5500|4:35 VPDUB Climb|8500|6:25 2CL9 Left|+1 09CL Left|+1 O02 Left|+1 77NV Left 126kts HALE|Timing KSPZ Pattern|0:45 Taxi|2:00", new Time("1:52:28"), new Time("1:44:58")),
    new ExpectedFlightPlan("2014 HWD Rally Leg 2", "KSPZ|" + keywords.get("Start") + " " + keywords.get("Taxi") + "|4:00 " + keywords.get("Runup") + "|0:30 " + keywords.get("Taxi") + "|1:00 " + keywords.get("Takeoff") + " " + keywords.get("Climb") + "|7500|9:00 NV30 " + keywords.get("Left") + " MicrowaveSt " + keywords.get("Left") + " DOBYS " + keywords.get("Left") + " RanchTower " + keywords.get("Left") + " 126kts Winnie|" + keywords.get("Timing") + " KENV " + keywords.get("Pattern") + "|0:45 " + keywords.get("Taxi") + "|2:00", "KSPZ|Start Taxi|4:00 Runup|0:30 Taxi|1:00 Takeoff Climb|7500|9:00 NV30 Left MicrowaveSt Left DOBYS Left RanchTower Left 126kts WINNIE|Timing KENV Pattern|0:45 Taxi|2:00", new Time("2:03:43"), new Time("1:58:13")),
    new ExpectedFlightPlan("2014 HWD Rally Leg 3", "KENV|" + keywords.get("Start") + " " + keywords.get("Taxi") + "|5:00 " + keywords.get("Runup") + "|0:30 " + keywords.get("Taxi") + "|1:00 " + keywords.get("Takeoff") + " " + keywords.get("Climb") + "|7500|8:30 FremontIsland " + keywords.get("Left") + "|+1 Tremonton " + keywords.get("Left") + "|+1 RandomPoint " + keywords.get("Left") + "|+1 Farson " + keywords.get("Left") + " 126kts WindRiver|" + keywords.get("Timing") + " KLND " + keywords.get("Pattern") + "|0:45 " + keywords.get("Taxi") + "|2:00", "KENV|Start Taxi|5:00 Runup|0:30 Taxi|1:00 Takeoff Climb|7500|8:30 FremontIsland Left|+1 Tremonton Left|+1 RandomPoint Left|+1 Farson Left 126kts WINDRIVER|Timing KLND Pattern|0:45 Taxi|2:00", new Time("2:25:05"), new Time("2:18:35")),
    new ExpectedFlightPlan("2014 HWD Rally Leg 4", "KLND|" + keywords.get("Start") + " " + keywords.get("Taxi") + "|6:00 " + keywords.get("Runup") + "|0:30 " + keywords.get("Taxi") + "|1:00 " + keywords.get("Takeoff") + " " + keywords.get("Climb") + "|7500|10:00 Midwest " + keywords.get("Left") + " Bill " + keywords.get("Right") + "|+1 WY09 " + keywords.get("Left") + " KCUT " + keywords.get("Left") + " 126kts BUFF|" + keywords.get("Timing") + " KRAP " + keywords.get("Pattern") + "|0:45 " + keywords.get("Taxi") + "|2:00", "KLND|Start Taxi|6:00 Runup|0:30 Taxi|1:00 Takeoff Climb|7500|10:00 Midwest Left Bill Right|+1 WY09 Left KCUT Left 126kts BUFF|Timing KRAP Pattern|0:45 Taxi|2:00", new Time("2:32:10"), new Time("2:24:40")),
    new ExpectedFlightPlan("2014 HWD Rally Leg 5", "KRAP|" + keywords.get("Start") + " " + keywords.get("Taxi") + "|5:00 " + keywords.get("Runup") + "|0:30 " + keywords.get("Taxi") + "|3:00 " + keywords.get("Takeoff") + " " + keywords.get("Climb") + "|7500|9:00 MMNHS " + keywords.get("Left") + "|+1 Tracks " + keywords.get("Left") + "|+1 8D7 " + keywords.get("Left") + " 5H3 " + keywords.get("Left") + " 126kts Omega KMVE " + keywords.get("Pattern") + "|0:45 " + keywords.get("Taxi") + "|2:00", "KRAP|Start Taxi|5:00 Runup|0:30 Taxi|3:00 Takeoff Climb|7500|9:00 MMNHS Left|+1 Tracks Left|+1 8D7 Left 5H3 Left 126kts Omega KMVE Pattern|0:45 Taxi|2:00", new Time("2:50:12"), new Time("2:41:42")),
    new ExpectedFlightPlan("2014 HWD Rally Leg 6", "KMVE|" + keywords.get("Start") + " " + keywords.get("Taxi") + "|6:00 " + keywords.get("Runup") + "|0:30 " + keywords.get("Taxi") + "|2:00 " + keywords.get("Takeoff") + " " + keywords.get("Climb") + "|5500|6:00 1D6 " + keywords.get("Left") + " 68Y " + keywords.get("Right") + "|+1 Towers " + keywords.get("Left") + " KCHU " + keywords.get("Left") + " 126kts Paul|" + keywords.get("Timing") + " KMSN " + keywords.get("Pattern") + "|0:45 " + keywords.get("Taxi") + "|2:00", "KMVE|Start Taxi|6:00 Runup|0:30 Taxi|2:00 Takeoff Climb|5500|6:00 1D6 Left 68Y Right|+1 Towers Left KCHU Left 126kts PAUL|Timing KMSN Pattern|0:45 Taxi|2:00", new Time("2:26:56"), new Time("2:18:26")),
    new ExpectedFlightPlan("2015 HWD Rally Leg 1", "KHWD|" + keywords.get("Start") + " " + keywords.get("Taxi") + "|6:00 " + keywords.get("Runup") + "|0:30 " + keywords.get("Taxi") + "|1:00 " + keywords.get("Takeoff") + " " + keywords.get("Climb") + "|5500|4:35 VPDUB " + keywords.get("Climb") + "|5500|3:25 IsletonBridge Mystery15 " + keywords.get("Left") + "|+1 71CL " + keywords.get("Left") + "|+1 Paskenta " + keywords.get("Left") + "|+1 O37 " + keywords.get("Left") + "|+1 JELLYSFERRY HOWIE|" + keywords.get("Timing") + " KRDD " + keywords.get("Pattern") + "|0:45 " + keywords.get("Taxi") + "|2:00", "KHWD|Start Taxi|6:00 Runup|0:30 Taxi|1:00 Takeoff Climb|5500|4:35 VPDUB Climb|5500|3:25 IsletonBridge Mystery15 Left|+1 71CL Left|+1 Paskenta Left|+1 O37 Left|+1 Jellysferry HOWIE|Timing KRDD Pattern|0:45 Taxi|2:00", new Time("2:04:00"), new Time("1:56:30")),
    new ExpectedFlightPlan("2015 HWD Rally Leg 2", "KRDD|" + keywords.get("Start") + " " + keywords.get("Taxi") + "|6:00 " + keywords.get("Runup") + "|0:30 " + keywords.get("Taxi") + "|2:00 " + keywords.get("Takeoff") + " " + keywords.get("Climb") + "|8500|1:20 REDDING.POND " + keywords.get("Climb") + "|8500|7:40 A26 O81 " + keywords.get("Left") + " 340@6 Bonanza " + keywords.get("Left") + "|+1 Silverlake " + keywords.get("Left") + "|+1 Millican 126kts Goering|" + keywords.get("Timing") + " KBDN " + keywords.get("pattern") + "|30 " + keywords.get("taxi") + "|2:00", "KRDD|Start Taxi|6:00 Runup|0:30 Taxi|2:00 Takeoff Climb|8500|1:20 Redding.Pond Climb|8500|7:40 A26 O81 Left 340@6 Bonanza Left|+1 Silverlake Left|+1 Millican 126kts GOERING|Timing KBDN Pattern|0:30 Taxi|2:00", new Time("2:27:39"), new Time("2:19:09")),
    new ExpectedFlightPlan("2016 HWD Rally Leg 1", "KHWD|" + keywords.get("Start") + " " + keywords.get("Taxi") + "|6:00 " + keywords.get("Runup") + "|0:30 " + keywords.get("Taxi") + "|1:00 " + keywords.get("Takeoff") + " " + keywords.get("Climb") + "|5500|4:35 VPDUB " + keywords.get("Climb") + "|5500|3:25 65CN 3CN7 57CN " + keywords.get("Left") + "|+1 2CL1 " + keywords.get("Left") + "|+1 O37 " + keywords.get("Left") + "|+1 JELLYSFERRY HOWIE|" + keywords.get("Timing") + " KRDD " + keywords.get("Pattern") + "|0:45 " + keywords.get("Taxi") + "|2:00", "KHWD|Start Taxi|6:00 Runup|0:30 Taxi|1:00 Takeoff Climb|5500|4:35 VPDUB Climb|5500|3:25 65CN 3CN7 57CN Left|+1 2CL1 Left|+1 O37 Left|+1 Jellysferry HOWIE|Timing KRDD Pattern|0:45 Taxi|2:00", new Time("1:50:15"), new Time("1:42:45")),
    new ExpectedFlightPlan("2016 HWD Rally Leg 2", "KRDD|" + keywords.get("Start") + " " + keywords.get("Taxi") + "|6:00 " + keywords.get("Runup") + "|0:30 " + keywords.get("Taxi") + "|2:00 " + keywords.get("Takeoff") + " " + keywords.get("Climb") + "|8500|1:20 REDDING.POND " + keywords.get("Climb") + "|8500|7:40 O89 KAAT " + keywords.get("Left") + " 1Q2 KSVE " + keywords.get("Left") + " H37 " + keywords.get("Left") + " CONSTANTIA2 HALLELUJAH2|" + keywords.get("Timing") + " KRTS " + keywords.get("pattern") + "|30 " + keywords.get("taxi") + "|2:00", "KRDD|Start Taxi|6:00 Runup|0:30 Taxi|2:00 Takeoff Climb|8500|1:20 Redding.Pond Climb|8500|7:40 O89 KAAT Left 1Q2 KSVE Left H37 Left Constantia2 HALLELUJAH2|Timing KRTS Pattern|0:30 Taxi|2:00", new Time("2:06:06"), new Time("1:57:36")),
    new ExpectedFlightPlan("2017 HWD Rally Leg 1", "KHWD|" + keywords.get("Start") + " " + keywords.get("Taxi") + "|6:00 " + keywords.get("Runup") + "|0:30 " + keywords.get("Taxi") + "|1:00 " + keywords.get("Takeoff") + " " + keywords.get("Climb") + "|4500|8:00 10@6 9CL9 63CL THUNDERHILL 60@10 90CL 0O4 350@10 126kts JELLYSFERRY 126kts HOWIE|" + keywords.get("Timing") + " KRDD " + keywords.get("Pattern") + "|0:45 " + keywords.get("Taxi") + "|4:00", "KHWD|Start Taxi|6:00 Runup|0:30 Taxi|1:00 Takeoff Climb|4500|8:00 10@6 9CL9 63CL Thunderhill 60@10 90CL 0O4 350@10 126kts Jellysferry 126kts HOWIE|Timing KRDD Pattern|0:45 Taxi|4:00", new Time("1:41:46"), new Time("1:34:16")),
    new ExpectedFlightPlan("2017 HWD Rally Leg 2", "KRDD|" + keywords.get("Start") + " " + keywords.get("Taxi") + "|6:00 " + keywords.get("Runup") + "|0:30 " + keywords.get("Taxi") + "|2:00 " + keywords.get("Takeoff") + " " + keywords.get("Climb") + "|8500|6:40 CASCADEHIGHWAY " + keywords.get("Climb") + "|8500|8:20 KLKV 210@2 EAGLEVILLE DUCKLAKEPASS 210@5 O39 209@8 AHC 148@6 126kts CONSTANTIA2 126kts Hallelujah2|" + keywords.get("Timing") + " KRTS " + keywords.get("Pattern") + "|0:30 " + keywords.get("Taxi") + "|2:00", "KRDD|Start Taxi|6:00 Runup|0:30 Taxi|2:00 Takeoff Climb|8500|6:40 CascadeHighway Climb|8500|8:20 KLKV 210@2 Eagleville DuckLakePass 210@5 O39 209@8 AHC 148@6 126kts Constantia2 126kts HALLELUJAH2|Timing KRTS Pattern|0:30 Taxi|2:00", new Time("2:14:36"), new Time("2:06:06")),
    new ExpectedFlightPlan("San Jose to San Diego", "KSJC LICKE SNS V25 REDIN KMYF", "KSJC LICKE SNS CASRA HAGRO WIGGL LUCAB PRB KIKII POZOE WYNNR RZS ZIQOR DEANO VTU EXERT MERMA LAX HERMO WILMA FERMY ALBAS MINOE PACIF REDIN KMYF", new Time("2:40:16"), undefined),
    new ExpectedFlightPlan("San Diego to San Jose", "KMYF JOPDO CARIF V23 LAX V299 VTU V25 PRB SARDO RANCK V485 LICKE KSJC", "KMYF JOPDO CARIF HURSI OCN KELPS DANAH KRAUZ BALBO MIDDS SLI POPPR HERMO LAX SADDE VTU DEANO ZIQOR RZS WYNNR POZOE KIKII PRB SARDO RANCK PANOS ULENY HENCE GILRO LICKE KSJC", new Time("2:38:48"), undefined),
    new ExpectedFlightPlan("San Jose to Renton", "KSJC SUNOL RBL V23 SEA KRNT", "KSJC SUNOL RBL BEIRA TAYTO SHATA FOLDS FJS ZUNAS LEANN TALEM LIPWO OED UZEHE BROKN MOURN CURTI SAGIN EUG ALFOR SHEDD MAGOT TURNO EMADE GNNET RAWER CANBY OSWEG BTG ROARK COUGA MALAY ONALS MCKEN SEA KRNT", new Time("4:23:52"), undefined),
    new ExpectedFlightPlan("Renton to Willows", "KRNT SEA V495 BTG V23 RBL KWLW", "KRNT SEA CIDUG ALDER TOUTL OKARE BTG OSWEG CANBY RAWER GNNET EMADE TURNO MAGOT SHEDD ALFOR EUG SAGIN CURTI MOURN BROKN UZEHE OED LIPWO TALEM LEANN ZUNAS FJS FOLDS SHATA TAYTO BEIRA RBL KWLW", new Time("3:27:06"), undefined),
    new ExpectedFlightPlan("SJC to SEA #1", "ksjc sunol 135kts 300@12 rdd 0kts pdx ksea", "KSJC SUNOL 300@12 135kts RDD PDX KSEA", new Time("4:33:24"), undefined),
    new ExpectedFlightPlan("SJC to SEA #2", "KSJC SJC V334 SAC V23 BTG V495 SEA KSEA", "KSJC SJC SUNOL ALTAM OAKEY VISTO SAC CAPTO EYPOF GRIME YUBBA GRIDD TALUM JINGO GONGS RBL BEIRA TAYTO SHATA FOLDS FJS ZUNAS LEANN TALEM LIPWO OED UZEHE BROKN MOURN CURTI SAGIN EUG ALFOR SHEDD MAGOT TURNO EMADE GNNET RAWER CANBY OSWEG BTG OKARE TOUTL ALDER CIDUG SEA KSEA", new Time("4:23:27"), undefined),
    new ExpectedFlightPlan("SJC to SEA #3", "KSJC SJC V334 SAC V23 FJS V495 SEA KSEA", "KSJC SJC SUNOL ALTAM OAKEY VISTO SAC CAPTO EYPOF GRIME YUBBA GRIDD TALUM JINGO GONGS RBL BEIRA TAYTO SHATA FOLDS FJS BAYTS PAPLE MERLI KOLER RBG VAUGN NOTTI HORTE CVO ADLOW BREAF UBG ENDZZ BTG OKARE TOUTL ALDER CIDUG SEA KSEA", new Time("4:26:18"), undefined),
    new ExpectedFlightPlan("Roseburg to San Jose", "KRBG RBG KOLER V495 FJS V23 RBL SUNOL KSJC", "KRBG RBG KOLER MERLI PAPLE BAYTS FJS FOLDS SHATA TAYTO BEIRA RBL SUNOL KSJC", new Time("2:33:19"), undefined),
    new ExpectedFlightPlan("SAN to DEN", "KSAN HAILE V514 LYNSY V8 JNC V134 BINBE KDEN", "KSAN HAILE RYAHH BARET CANNO JLI WARNE TRM CONES CLOWD TNP JOTNU ZELMA GFS SHUSS LYNSY WINDS ACLAM MEADS MMM PHYLI JITKA JEZOB MATZO POBME CEXAT ETYIR BCE MOJVI UJACI HVE KIDNE EDLES ARCHH ZUKSO JNC PACES EDUKY HUGSI RIYNO SLOLM GLENO LINDZ DBL HERLS LAWSN DAVVY FUNDS BREWS BINBE KDEN", new Time("5:35:24"), undefined),
    new ExpectedFlightPlan("Denver to Minneapolis", "KDEN DVV V8 AKO V80 FSD V148 RWF V412 FCM KMSP", "KDEN DVV HOYTT AKO CITMU NACIK HOLYO UYOGI LBF OGEZO ECYUS BOKKI JIKNU ONL CURIR TYNDA PUKIC DOLTS FSD SECTO POEMS POGSE ZERAD PILIY RWF DRAIL FCM KMSP", new Time("4:14:33"), undefined),
    new ExpectedFlightPlan("Reno to Chicago", "KRNO FMG V6 LLC V32 CEVAR V200 STACO V32 FBR V6 MBW V100 RFD V171 SIMMN V172 DPA KORD", "KRNO FMG WADDS LLC ZUSRU FESKO WIKLO BAM OLGAA BQU SPATS UHEPI BVL ZONSU BAGGI CEVAR STACO WEGET SALTA TCH COOLI EXILE FBR WEGEM PUDVY OCS TOGUY ARUTE CKW EDIFY CEXIT MBW ZIKRU BFF HAPOP JUNUM AIA EVENN EFFEX MARSS ANW GIYED ONL CUGUX BEWIG ATLES SUX CUSHO NEMAH MONKS BABYA FOD SEKDE ALOCK ARTYS ALO DEWAR INDET DBQ LENAS RFD NOAHE SIMMN NUELG DPA KORD", new Time("10:22:34"), undefined),
    new ExpectedFlightPlan("Denver to Oklahoma City", "KDEN AVNEW V366 HGO V263 LAA V304 LBL V507 MMB V17 IRW KOKC", "KDEN AVNEW JEFEL QUAIL CONAL HGO ZANON WEYYI LAA UPIRE YUNUP LBL ZALIK MMB TISSY CAMAR PANIY OLVAE ODINS ZELNU CAMET IRW KOKC", new Time("3:05:36"), undefined),
    new ExpectedFlightPlan("Stockton to Hawthorne 1", "KSCK MOD V113 PXN V107 AVE V137 GMN V23 LAX KHHR", "KSCK MOD PATYY PXN CITIE AVE TAFTO GMN CASTA TWINE CHATY LAX KHHR", new Time("2:02:15"), undefined),
    new ExpectedFlightPlan("Stockton to Hawthorne 2", "ksck patyy v113 rom v485  exert v25 lax khhr", "KSCK PATYY ROM EXERT LAX KHHR", new Time("2:05:38"), undefined),
    new ExpectedFlightPlan("Long View to Corpus Christi", "KGGG PIPES V289 LFK V13 WORRY KCRP", "KGGG PIPES ARMOR AFRUH LFK WELRO LEGGE CLEEP IAH ROSEN COSDI PUKME PSX TANNA IVOLY BLOKS AUSTS WORRY KCRP", new Time("2:19:06"), undefined),
    new ExpectedFlightPlan("Austin Exec to Beaumont 1", "KEDC HOOKK V306 TNV V574 IAH V222 SHINA KBPT", "KEDC HOOKK ILEXY JAYJO BLUBL COUTH TNV IAH COSBI TRIOS BDDRO FALSE SHINA KBPT", new Time("1:20:01"), undefined),
    new ExpectedFlightPlan("Austin Exec to Beaumont 2", "KEDC HOOKK V306 DAS KBPT", "KEDC HOOKK ILEXY JAYJO BLUBL COUTH TNV GOMER ZMSKL CLEEP DAS KBPT", new Time("1:19:37"), undefined),
    new ExpectedFlightPlan("Austin Exec to Beaumont 3", "KEDC HOOKK V306 TNV DAS KBPT", "KEDC HOOKK ILEXY JAYJO BLUBL COUTH TNV DAS KBPT", new Time("1:19:13"), undefined),
    new ExpectedFlightPlan("Savannah to Daytona Beach", "KSAV KELER V437 COKES KDAB", "KSAV KELER CATHY STARY HOTAR SUBER JETSO COBOK COKES KDAB", new Time("1:14:55"), undefined),
    new ExpectedFlightPlan("Philly to Hartford 1", "KPNE ARD V276 DIXIE V16 JFK V229 SNIVL KHFD", "KPNE ARD RBV CASVI DIXIE MOVFA JFK KEEPM TRANZ PUGGS BDR MILUM BAYYS DWAIN SEALL SNIVL KHFD", new Time("1:12:28"), undefined),
    new ExpectedFlightPlan("Philly to Hartford 2", "KPNE ARD V276 MANTA V139 RICED MAD KHFD", "KPNE ARD RBV CASVI DIXIE ZIGGI GAMBY MANTA PLUME SHERL DUNEE KOPPY SARDI RICED MAD KHFD", new Time("1:25:52"), undefined),
    new ExpectedFlightPlan("Philly to Hartford 3", "KPNE DITCH V312 DRIFT V139 SARDI V308 ORW KHFD", "KPNE DITCH CYN JIMEE FALON WINKK DRIFT MANTA PLUME SHERL DUNEE KOPPY SARDI RICED BEDYA SHLEP BEADS HTO BOROS GON ORW KHFD", new Time("1:38:35"), undefined),
    new ExpectedFlightPlan("Philly to Hartford 4", "KPNE ZIDET V479 ARD V433 LGA V99 YALER KHFD", "KPNE ZIDET ARD MERSR METRO PLEXS BONIE KILMA GRITY TICKL PROUD DIALS LGA OUTTE VAGUS ANNEI TRUDE MERIT SORRY YALER KHFD", new Time("1:04:01"), undefined),
    new ExpectedFlightPlan("West Georgie Regional to Frankfort, KY 1", "kctj noone nello v5 gqo kfft", "KCTJ NOONE NELLO GQO KFFT", new Time("2:08:18"), undefined),
    new ExpectedFlightPlan("West Georgie Regional to Frankfort, KY 2", "kctj felto v243 gqo v333 hyk v512 clegg kfft", "KCTJ FELTO GQO HYK CLEGG KFFT", new Time("2:02:52"), undefined),
    new ExpectedFlightPlan("West Georgie Regional to Frankfort, KY 3", "kctj rmg v333 hyk v512 clegg kfft", "KCTJ RMG HYK CLEGG KFFT", new Time("2:01:15"), undefined),
    new ExpectedFlightPlan("West Georgie Regional to Frankfort, KY 4", "kctj rmg v333 hch v51 lvt v493 hyk kfft", "KCTJ RMG HCH LVT HYK KFFT", new Time("2:03:24"), undefined),
    new ExpectedFlightPlan("Raleigh / Durham to Baltimore Martin State 1", "KRDU aimhi  KMTN", "KRDU AIMHI KMTN", new Time("1:39:49"), undefined),
    new ExpectedFlightPlan("Raleigh / Durham to Baltimore Martin State 2", "KRDU rdu v155 lvl ric ott KMTN", "KRDU RDU LVL RIC OTT KMTN", new Time("1:40:45"), undefined),
    new ExpectedFlightPlan("Raleigh / Durham to Baltimore Martin State 3", "KRDU rdu v155 mange v157 colin v33 ott v433 paleo KMTN", "KRDU RDU MANGE COLIN OTT PALEO KMTN", new Time("1:45:10"), undefined),
    new ExpectedFlightPlan("Raleigh / Durham to Baltimore Martin State 4", "KRDU rdu v155 LVL V157 RIC V16 PXT V93 GRACO KMTN", "KRDU RDU WIPER BEXGO LVL MANGE DALTO MATOX RIC SVILL TAPPA DUPEY COLIN PXT LOUIE GRACO KMTN", new Time("1:45:57"), undefined),
    new ExpectedFlightPlan("Roswell, NM to Longview, TX", "KROW " + keywords.get("Climb") + "|9500|6:00 070@14 HOB V68 PIZON 050@16 V16 ABI V62 JEN V94 OTTIF KGGG", "KROW Climb|9500|6:00 70@14 HOB ZUSDA GECKE ANEEL PIZON 50@16 ABI FLECK GEENI CADES ZOSKU SICUM JEN CELTC ACUFF CQY SWANI SNOWE CAPTI OTTIF KGGG", new Time("3:58:24"), undefined),
    new ExpectedFlightPlan("Lubbock to Longview 1", "KLBB JEN CQY KGGG", "KLBB JEN CQY KGGG", new Time("2:40:35"), undefined),
    new ExpectedFlightPlan("Lubbock to Longview 2", "KLBB ralls v102 gth v278 byp v114 awlar KGGG", "KLBB RALLS GTH BYP AWLAR KGGG", new Time("2:42:00"), undefined),
    new ExpectedFlightPlan("Lubbock to Longview 3", "KLBB hydro v62 jen v94 ottif KGGG", "KLBB HYDRO JEN OTTIF KGGG", new Time("2:40:32"), undefined),
    new ExpectedFlightPlan("Stockton, CA to North Las Vegas 1", "KSCK ECA V244 OAL V105 LUCKY KVGT", "KSCK ECA WRAPS HABXU DUCKE NIKOL JABIM OAL ZOTUX TEZUM LIDAT BTY HIDEN LUCKY KVGT", new Time("2:29:10"), undefined),
    new ExpectedFlightPlan("Stockton, CA to North Las Vegas 2", "KSCK ehf v197 pmd v12 basal v394 oasys KVGT", "KSCK EHF PMD BASAL OASYS KVGT", new Time("3:01:42"), undefined),
    new ExpectedFlightPlan("Bakersfield to Santa Rosa 1", "KBFL EHF V248 AVE OAK SAU KSTS", "KBFL EHF SCRAP COREZ AVE OAK SAU KSTS", new Time("1:54:22"), undefined),
    new ExpectedFlightPlan("Bakersfield to Santa Rosa 2", "KBFL EHF V248 AVE PXN V301 SUNOL KSTS", "KBFL EHF SCRAP COREZ AVE PXN KARNN BORED BUSHY SUNOL KSTS", new Time("1:53:02"), undefined),
    new ExpectedFlightPlan("Bakersfield to Santa Rosa 3", "KBFL SCRAP V248 AVE V107 OAK V195 CROIT V108 STS KSTS", "KBFL SCRAP COREZ AVE CITIE PXN CATHE VINCO MABRY MISON IMPLY DECOT OAK BERKS SABLO CROIT SGD HABAP STS KSTS", new Time("1:55:37"), undefined),
    new ExpectedFlightPlan("Bakersfield to Santa Rosa 4", "KBFL EHF V23 SAC V494 SNUPY KSTS", "KBFL EHF DELNO PONDD PIXEY LATON FRAME CZQ OXVEV BEREN LAPOW UYOKA EBTUW TURLO NEBBY AWALI HONEZ WRAPS LIN GALTS SAC PIVSE RAGGS POPES SNUPY KSTS", new Time("1:57:59"), undefined),
    new ExpectedFlightPlan("Bakersfield to Santa Rosa 5", "KBFL EHF V248 AVE V137 SNS V230 SHOEY V27 PYE KSTS", "KBFL EHF SCRAP COREZ AVE NEFDE OKEEF ROM ZURET CANRI SNS JEJZE ISIFU SHOEY EUGEN TAILS HADLY SEEMS STINS PYE KSTS", new Time("2:01:34"), undefined),
    new ExpectedFlightPlan("Bakersfield to Santa Rosa 6", "KBFL EHF V23 CZQ MOD OAKEY KSTS", "KBFL EHF DELNO PONDD PIXEY LATON FRAME CZQ MOD OAKEY KSTS", new Time("1:53:12"), undefined),
    new ExpectedFlightPlan("Bakersfield to Santa Rosa 7", "KBFL EHF V23 LIN CCR CROIT SGD KSTS", "KBFL EHF DELNO PONDD PIXEY LATON FRAME CZQ OXVEV BEREN LAPOW UYOKA EBTUW TURLO NEBBY AWALI HONEZ WRAPS LIN CCR CROIT SGD KSTS", new Time("1:59:11"), undefined),
    new ExpectedFlightPlan("Bakersfield to Santa Rosa 8", "KBFL EHF V248 AVE V107 PXN SGD KSTS", "KBFL EHF SCRAP COREZ AVE CITIE PXN SGD KSTS", new Time("1:53:04"), undefined),
    new ExpectedFlightPlan("Great Falls to Boeing King Field 1", "KGTF GTF V120 MLP V2 GEG V120 NORMY KBFI", "KGTF GTF SHIMY CHARL HANIM EDOBE MLP HILIE HIPRR ROPES GEG EPAFY OWOSE WIPES EPH OZALI EAT CASHS CUNUR WINIM FITGA NORMY KBFI", new Time("3:08:44"), undefined),
    new ExpectedFlightPlan("Great Falls to Boeing King Field 2", "KGTF GTF V120 MLP J70 SEA KBFI", "KGTF GTF SHIMY CHARL HANIM EDOBE MLP EPH BLUIT NORMY SEA KBFI", new Time("3:10:35"), undefined),
    new ExpectedFlightPlan("Great Falls to Boeing King Field 3", "KGTF GTF V187 ELN V2 SEA KBFI", "KGTF GTF TUCKB GUGYI ROSOE OCEDA SQIDS MSO WAANE LOLLO DAIRE RIVAL JIROS OFINO CEPER PETEZ MQG POTOR SEVER RENGO BUTOC DATES BACUN OYREX PSC EXODE NIALS FEBUS ELN BEEZR BANDR VAMPS SEA KBFI", new Time("3:26:13"), undefined),
    new ExpectedFlightPlan("Great Falls to Boeing King Field 4", "KGTF KEETA Q144 ZIRAN KBFI", "KGTF KEETA BLOWS ZOOMR ZIRAN KBFI", new Time("3:08:13"), undefined),
    new ExpectedFlightPlan("Boise to Centenial 1", "KBOI BOI V4 LAR RAMMS NIWOT KAPA", "KBOI BOI CANEK ALKAL YUWFE GOODE JEROT HAZZL BYI MEDEA MLD TINRE FILOB HODNI GEGME GRIPS OCS TOGUY ARUTE CKW ZOLGA TRUMA KLASH NATTI LYMPS LAR RAMMS NIWOT KAPA", new Time("4:18:57"), undefined),
    new ExpectedFlightPlan("Boise to Centenial 2", "KBOI ROARR PIH J20 OCS J154 AVVVS KAPA", "KBOI ROARR PIH OCS ALPOE AUTIM RAMMS AVVVS KAPA", new Time("4:09:34"), undefined),
    new ExpectedFlightPlan("Boise to Centenial 3", "KBOI CANEK V4 OCS V328 DOBEE V356 ELORE KAPA", "KBOI CANEK ALKAL YUWFE GOODE JEROT HAZZL BYI MEDEA MLD TINRE FILOB HODNI GEGME GRIPS OCS CEBAL SNAKY CELIA MEKWY HUPEG CHE EGFAX HABRO SBURG TILLI GUVYU RLG DOBEE ELORE KAPA", new Time("4:07:58"), undefined),
    new ExpectedFlightPlan("Boise to Centenial 4", "KBOI BOI J54 PIH J20 OCS J52 FQF KAPA", "KBOI BOI PIH OCS FQF KAPA", new Time("4:06:43"), undefined),
    new ExpectedFlightPlan("St. Louis to Birmingham 1", "KSTL SPUDZ V125 DUEAS V540 CNG V67 SYI V321 BOAZE V115 COLIG KBHM", "KSTL SPUDZ BURCK NIKEL DUEAS ALING PAMPI TAMMS CNG KABLE NUBEE LANKY GHM TUNGY SYI KUXYI ATWUS JEKBA VOYUD HATAS RQZ OWENT ALBER BOAZE ARBEE SNEAR WILED COLIG KBHM", new Time("2:57:41"), undefined),
    new ExpectedFlightPlan("St. Louis to Birmingham 2", "KSTL ODUJY FAM CGI JKS MSL VUZ KBHM", "KSTL ODUJY FAM CGI JKS MSL VUZ KBHM", new Time("2:35:27"), undefined),
    new ExpectedFlightPlan("Chattanoga to Augusta 1", "KCHA ODF AHN V417 MSTRS KAGS", "KCHA ODF AHN OCENU DANBI TIGNA MSTRS KAGS", new Time("1:32:34"), undefined),
    new ExpectedFlightPlan("Chattanoga to Augusta 2", "KCHA GQO NELLO CCATT T292 JACET KAGS", "KCHA GQO NELLO CCATT REELL TRREE JACET KAGS", new Time("1:21:13"), undefined),
    new ExpectedFlightPlan("Chattanoga to Augusta 3", "KCHA GQO ATL ANNAN KAGS", "KCHA GQO ATL ANNAN KAGS", new Time("1:31:50"), undefined),
    new ExpectedFlightPlan("Chattanoga to Augusta 4", "KCHA HOCHE V5 AHN V417 IRQ KAGS", "KCHA HOCHE ETONE NELLO AWSON CORCE IRMOS AHN OCENU DANBI TIGNA MSTRS KANDY IRQ KAGS", new Time("1:28:00"), undefined),
    new ExpectedFlightPlan("Concord, NC to Richmond, VA 1", "KJQF SBV V20 RIC KRIC", "KJQF SBV LELLI YUDUG NUTTS MELIA RIC KRIC", new Time("1:27:57"), undefined),
    new ExpectedFlightPlan("Concord, NC to Richmond, VA 2", "KJQF GIZMO V143 GSO V266 SBV V20 RIC KRIC", "KJQF GIZMO AZELL GSO REIDE YANCE SBV LELLI YUDUG NUTTS MELIA RIC KRIC", new Time("1:28:38"), undefined),
    new ExpectedFlightPlan("Concord, NC to Richmond, VA 3", "KJQF GSO SBV V20 RIC KRIC", "KJQF GSO SBV LELLI YUDUG NUTTS MELIA RIC KRIC", new Time("1:28:04"), undefined),
    new ExpectedFlightPlan("Concord, NC to Richmond, VA 4", "KJQF GIZMO V454 LVL V157 RIC KRIC", "KJQF GIZMO KEWPI LIB STASE BILLA WUMVA OXFRD NOKIY LVL MANGE DALTO MATOX RIC KRIC", new Time("1:31:04"), undefined),
    new ExpectedFlightPlan("Buffalo, NY to Portland, ME 1", "KBUF BUF V2 UCA V496 NEETS V39 LIMER KPWM", "KBUF BUF CLUNG MONCK ROC LORTH MAGEN KONDO WIFFY SYR FAYET STODA VASTS UCA MALLO WAREN GFL KERST EBERT LEB BILLS ANIER GRUMP NEETS LIMER KPWM", new Time("2:41:10"), undefined),
    new ExpectedFlightPlan("Buffalo, NY to Portland, ME 2", "KBUF HANKK AUDIL PUPPY GFL KPWM", "KBUF HANKK AUDIL PUPPY GFL KPWM", new Time("2:37:35"), undefined),
    new ExpectedFlightPlan("Buffalo, NY to Portland, ME 3", "KBUF BUF V14 GGT V428 UCA V496 ENE KPWM", "KBUF BUF GEE UMAGY BEEPS SCIPO BOCKS VESPE GGT EATEN UCA MALLO WAREN GFL KERST EBERT LEB BILLS ANIER GRUMP NEETS ENE KPWM", new Time("2:42:53"), undefined),
    new ExpectedFlightPlan("Buffalo, NY to Portland, ME 4", "KBUF JOSSY Q935 PONCT ARIME CDOGG ENE KPWM", "KBUF JOSSY AUDIL FABEN PONCT ARIME CDOGG ENE KPWM", new Time("2:41:59"), undefined),
    new ExpectedFlightPlan("Moline, IL to Battle Creek, MI 1", "KMLI GENSO V8 NOMES V156 AZO KBTL", "KMLI GENSO WYNET TRIDE URRBS AHMED BENKY JOT CGT HALIE INKEN NOMES GIJ JJANN AZO KBTL", new Time("1:48:41"), undefined),
    new ExpectedFlightPlan("Moline, IL to Battle Creek, MI 2", "KMLI OBK J547 PMM KBTL", "KMLI OBK KUBBS PMM KBTL", new Time("1:43:50"), undefined),
    new ExpectedFlightPlan("Moline, IL to Battle Creek, MI 3", "KMLI PLL OBK ELX KBTL", "KMLI PLL OBK ELX KBTL", new Time("1:44:25"), undefined),
    new ExpectedFlightPlan("Moline, IL to Battle Creek, MI 4", "KMLI PLL RFD V100 ELX AZO KBTL", "KMLI PLL RFD GRIFT SMULA KRENA FARMM UMUZI OBK DEERE BRAIK MINCE MUSKY YOLUR ELX AZO KBTL", new Time("1:47:49"), undefined),
    new ExpectedFlightPlan("Green Bay, WI to Indianapolis, IN 1", "KGRB OKK V305 WELDO KIND", "KGRB OKK WELDO KIND", new Time("2:09:02"), undefined),
    new ExpectedFlightPlan("Green Bay, WI to Indianapolis, IN 2", "KGRB GRB J101 BAE J89 OBK EON V24 VHP KIND", "KGRB GRB BAE OBK EON KENLA YIXCI BOSSY BOSWL VAGES ATTIL POTES JAKKS JELLS ADVAY VHP KIND", new Time("2:16:10"), undefined),
    new ExpectedFlightPlan("Green Bay, WI to Indianapolis, IN 3", "KGRB WAFLE V7 BVT V399 ADVAY KIND", "KGRB WAFLE CLINS MURRI FAH CYNDI WOKNO PROOT HOGMI PETTY TALOR PAPPI DEERE THORR LAIRD BEBEE NILES CGT COKED LUCIT ZORRO OXFAT BVT JAKKS JELLS ADVAY KIND", new Time("2:09:16"), undefined),
    new ExpectedFlightPlan("Green Bay, WI to Indianapolis, IN 4", "KGRB WAFLE V7 BVT VHP KIND", "KGRB WAFLE CLINS MURRI FAH CYNDI WOKNO PROOT HOGMI PETTY TALOR PAPPI DEERE THORR LAIRD BEBEE NILES CGT COKED LUCIT ZORRO OXFAT BVT VHP KIND", new Time("2:08:40"), undefined),
    new ExpectedFlightPlan("Anoka County, MN to Springfield, IL 1", "KANE KANAC V97 ODI V129 GROWL KSPI", "KANE KANAC PRESS MANIE TROLL PEGGS ODI PKRNA DOURS QUEST FARON SWAGG DBQ LOTTE CVA NOWSO GENSO JPAUL PIA EVERY LOTTO GROWL KSPI", new Time("2:34:30"), undefined),
    new ExpectedFlightPlan("Anoka County, MN to Springfield, IL 2", "KANE GEP PRIOR FGT V411 RST V67 ULAXY KSPI", "KANE GEP PRIOR FGT AHMIT PEPPR DELZY EGUPE RST YESUR FOYDE ALO LYERS VINTY CID IOW WAPEL UTXIH BRL HAKAV BADER ATTIC ULAXY KSPI", new Time("2:44:02"), undefined),
    new ExpectedFlightPlan("Anoka County, MN to Springfield, IL 3", "KANE GEP PRIOR FGT V411 RST V503 CID V67 ULAXY KSPI", "KANE GEP PRIOR FGT AHMIT PEPPR DELZY EGUPE RST TALNE FARVI CID IOW WAPEL UTXIH BRL HAKAV BADER ATTIC ULAXY KSPI", new Time("2:42:35"), undefined),
    new ExpectedFlightPlan("Anoka County, MN to Springfield, IL 4", "KANE WAGNR V510 ODI V129 SPI KSPI", "KANE WAGNR ANDDE BITLR ODI PKRNA DOURS QUEST FARON SWAGG DBQ LOTTE CVA NOWSO GENSO JPAUL PIA EVERY LOTTO GROWL SPI KSPI", new Time("2:36:35"), undefined),
    new ExpectedFlightPlan("Little Rock to Souix City 1", "KLIT MCI J41 OVR KSUX", "KLIT MCI AGENT OVR KSUX", new Time("3:31:26"), undefined),
    new ExpectedFlightPlan("Little Rock to Souix City 2", "KLIT ROLAN V534 HAAWK V71 SGF V159 SUX KSUX", "KLIT ROLAN BIBBS HAAWK JASPE HRO RASON REEDS ENDRS SPOKE SGF OLIVA OLLII TRALE AUGIE HODEN ANX LYMES EXCEL LASSO HANOT STJ TRAIG VIKKI OVR ZISIX CANIO AANDY BECOM SUX KSUX", new Time("3:42:22"), undefined),
    new ExpectedFlightPlan("Little Rock to Souix City 3 ", "KLIT ROLAN V534 SCRAN V527 RZC V13 BUM V71 PANNY KSUX", "KLIT ROLAN BIBBS HAAWK SCRAN CASKS WESTY YUGUN RZC PINNE HEXER EOS DROOP WADET NASHE YUGTU DIZZI ZOSKI BUM CUNON DODSN TOP PWE PANNY KSUX", new Time("3:48:48"), undefined),
    new ExpectedFlightPlan("Little Rock to Souix City 4", "KLIT ROLAN V534 SCRAN V527 RZC V13 EOS V307 CNU V131 TOP PWE SUX KSUX", "KLIT ROLAN BIBBS HAAWK SCRAN CASKS WESTY YUGUN RZC PINNE HEXER EOS NERNE OSW KUBKY CNU KACED HOCJO TOP PWE SUX KSUX", new Time("3:51:21"), undefined),
];
