/***************************************************************************
 *     (c)2007-2013 Broadcom Corporation
 *
 *  This program is the proprietary software of Broadcom Corporation and/or its licensors,
 *  and may only be used, duplicated, modified or distributed pursuant to the terms and
 *  conditions of a separate, written license agreement executed between you and Broadcom
 *  (an "Authorized License").  Except as set forth in an Authorized License, Broadcom grants
 *  no license (express or implied), right to use, or waiver of any kind with respect to the
 *  Software, and Broadcom expressly reserves all rights in and to the Software and all
 *  intellectual property rights therein.  IF YOU HAVE NO AUTHORIZED LICENSE, THEN YOU
 *  HAVE NO RIGHT TO USE THIS SOFTWARE IN ANY WAY, AND SHOULD IMMEDIATELY
 *  NOTIFY BROADCOM AND DISCONTINUE ALL USE OF THE SOFTWARE.
 *
 *  Except as expressly set forth in the Authorized License,
 *
 *  1.     This program, including its structure, sequence and organization, constitutes the valuable trade
 *  secrets of Broadcom, and you shall use all reasonable efforts to protect the confidentiality thereof,
 *  and to use this information only in connection with your use of Broadcom integrated circuit products.
 *
 *  2.     TO THE MAXIMUM EXTENT PERMITTED BY LAW, THE SOFTWARE IS PROVIDED "AS IS"
 *  AND WITH ALL FAULTS AND BROADCOM MAKES NO PROMISES, REPRESENTATIONS OR
 *  WARRANTIES, EITHER EXPRESS, IMPLIED, STATUTORY, OR OTHERWISE, WITH RESPECT TO
 *  THE SOFTWARE.  BROADCOM SPECIFICALLY DISCLAIMS ANY AND ALL IMPLIED WARRANTIES
 *  OF TITLE, MERCHANTABILITY, NONINFRINGEMENT, FITNESS FOR A PARTICULAR PURPOSE,
 *  LACK OF VIRUSES, ACCURACY OR COMPLETENESS, QUIET ENJOYMENT, QUIET POSSESSION
 *  OR CORRESPONDENCE TO DESCRIPTION. YOU ASSUME THE ENTIRE RISK ARISING OUT OF
 *  USE OR PERFORMANCE OF THE SOFTWARE.
 *
 *  3.     TO THE MAXIMUM EXTENT PERMITTED BY LAW, IN NO EVENT SHALL BROADCOM OR ITS
 *  LICENSORS BE LIABLE FOR (i) CONSEQUENTIAL, INCIDENTAL, SPECIAL, INDIRECT, OR
 *  EXEMPLARY DAMAGES WHATSOEVER ARISING OUT OF OR IN ANY WAY RELATING TO YOUR
 *  USE OF OR INABILITY TO USE THE SOFTWARE EVEN IF BROADCOM HAS BEEN ADVISED OF
 *  THE POSSIBILITY OF SUCH DAMAGES; OR (ii) ANY AMOUNT IN EXCESS OF THE AMOUNT
 *  ACTUALLY PAID FOR THE SOFTWARE ITSELF OR U.S. $1, WHICHEVER IS GREATER. THESE
 *  LIMITATIONS SHALL APPLY NOTWITHSTANDING ANY FAILURE OF ESSENTIAL PURPOSE OF
 *  ANY LIMITED REMEDY.
 *
 ***************************************************************************/

#ifndef __CORE__BCMNEXUS__LAYER_H__
#define __CORE__BCMNEXUS__LAYER_H__

#include "dfb_types.h"
#include "directfb_version.h"
#include "core/layers.h"
#include "gfx/util.h"

/******************************************************************************/

typedef struct {
     CoreLayerRegionConfig          config;             /* Current Region Configuration */
     bool                           vscale;             /* Set to true when a vertical scale using blitter is required */
     CoreSurfaceBufferLock          leftBufferLock;     /* Remember the last surface buffer lock */
     CoreSurfaceBufferLock          rightBufferLock;    /* Remember the last surface buffer lock */
     DFBRectangle                   left_update;        /* Partial update region */
     DFBRectangle                   right_update;       /* Partial update region */
     bool                           updated;            /* Has got a Flip or Update call since SetRegion? */
} bcmRegionData;

typedef struct {
     bcmRegionData                 *regionData;         /* Pointer to region data */
     DFBDisplayLayerID              layerId;            /* Graphics layer ID */
     DFBScreenID                    displayId;          /* Primary or secondary display/screen */
     DFBDisplayLayerSourceID        sourceId;           /* Graphics source Id */
     bool                           layerEnabled;       /* true if this layer is enabled */
     int                            level;              /* z-order of this layer (default is 0 for primary, +ve means above and -ve means below) */
     CoreSurface                   *frameBuffer;        /* Used when there is no vertical scaler in the GFD */
     pthread_cond_t                 frameBufferSem;     /* Framebuffer callback semaphore */
     pthread_mutex_t                frameBufferSemLock; /* Framebuffer callback protective mutex */
     DFBRectangle                   srcRectangle;       /* Source rectangle for the display/screen */
     DFBRectangle                   destRectangle;      /* Destination rectangle for the display/screen */
     DFB_PlatformBlendFactor        srcBlendFunc;       /* Source blend function */
     DFB_PlatformBlendFactor        destBlendFunc;      /* Destination blend function */
     int                            alpha;              /* FF = fully opaque, 00 = fully transparent */
     int                            constantAlpha;      /* FF = fully opaque, 00 = fully transparent */
     bool                           srcColorKeyOn;      /* true if source color keying is enabled */
     bool                           hasVscaler;         /* Set to true if graphics feeder has vertical scaler */
     bool                           ibuffer;            /* Set if intermediate buffer is defined in direcfbrc for scaling*/
     int                            updateSkipCnt;      /* Set > 0, mean how many times we can skip updating this layer */
     pthread_mutex_t                lock;               /* Lock access to this structure */
     void                         (*layerCallback)(void *context, int param);
#if BCM_DFB_USE_NOTIFY_DISPLAY_THREAD
     DirectThread                  *notifyDisplayThread;  /* NotifyDisplay thread */
     pthread_mutex_t                notifyDisplayThreadLock;
     pthread_cond_t                 notifyDisplayThreadSem;
     bool                           notifyDisplayThreadQuit;
     CoreSurface                   *notifyDisplayFrameBuffer;
     CoreSurfaceBuffer             *notifyDisplayFlipPendingLeft;
     CoreSurfaceBuffer             *notifyDisplayFlipPendingRight;
#endif
#if BCM_DFB_USE_TASK_MANAGER
    DFB_DisplayTask                *taskLeft;
    DFB_DisplayTask                *taskRight;
    DFB_DisplayTask                *oldTaskLeft;
    DFB_DisplayTask                *oldTaskRight;
#endif
     bool                           follow_video;       /* Stereo offset comes from video metadata. */
     int                            z;                  /* Stereo depth. */
     CoreSurfaceBuffer             *flipPendingLeft;
     CoreSurfaceBuffer             *flipPendingRight;
} bcmLayerData;

typedef struct {
    DFBDisplayLayerID   layerId;
    NEXUS_SurfaceHandle hLeftSurface;
    NEXUS_SurfaceHandle hRightSurface;
} bcmLayerCallSetGfxFrameBuffer;

typedef struct {
    DFBDisplayLayerID      layerId;
    NEXUS_GraphicsSettings gfxSettings;
} bcmLayerCallSetGfxSettings;

/**********************************************************************************************************************/

/* Layers */

extern DFBResult bcmSetLayerState(DFBBCMNEXUS *dfb_bcmnexus, DFBDisplayLayerID layerId, bool enable);
extern DFBResult bcmSetLayerDestRectangle(DFBBCMNEXUS *dfb_bcmnexus, DFBDisplayLayerID layerId, DFBRectangle *destRectangle);
extern DisplayLayerFuncs bcmnexusPrimaryGfxLayerFuncs;
extern DisplayLayerFuncs bcmnexusSecondaryGfxLayerFuncs;
extern DisplayLayerFuncs bcmnexusBackgroundGfxLayerFuncs;

bcmLayerData *bcmGetLayerData(DFBDisplayLayerID layerId);

/* Helper function to convert between old and new stereosopic APIs*/
void
bcm_gfx_stretch_stereo( CoreSurface         *source,
                        DFBSurfaceStereoEye  source_eye,
                        CoreSurface         *destination,
                        DFBSurfaceStereoEye  destination_eye,
                        const DFBRectangle  *srect,
                        const DFBRectangle  *drect,
                        bool                 flipping );

CoreSurfaceBuffer *
bcm_surface_get_buffer2( CoreSurface           *surface,
                         CoreSurfaceBufferRole  role,
                         DFBSurfaceStereoEye    eye );

#endif
