#!/bin/sh

. `readlink -f $0 | xargs dirname`/setenv.sh

if [[ $1 == "gdb" ]]; then
    shift
    DEBUG_CMD_PREFIX="gdb --args"
elif [[ $1 == "gdbserver" ]]; then
    shift
    DEBUG_CMD_PREFIX="gdbserver :2345"
elif [[ $1 == "gst-mem-live" ]]; then
    shift
    export GST_TRACE=mem-live
elif [[ $1 == "perf" ]]; then
    shift
    DEBUG_CMD_PREFIX="perf record -g"
elif [[ $1 == "valgrind" ]]; then
    shift
    DEBUG_CMD_PREFIX="./valgrind.sh"
elif [[ $1 == "rr" ]]; then
    shift
    DEBUG_CMD_PREFIX="rr record"
elif [[ $1 == "cpuprof" ]]; then
    shift
    export CPU_PROFILE_PREFIX=./cpu_profile
    export TCMALLOC_STACKTRACE_METHOD=libunwind
    rm ${CPU_PROFILE_PREFIX}*
elif [[ $1 == "pprof" ]]; then
    shift
    export HEAP_PROFILE_PREFIX=./heap_profile
    export TCMALLOC_STACKTRACE_METHOD=libunwind
    export HEAP_PROFILE_ALLOCATION_INTERVAL=5368709120
    export HEAP_PROFILE_INUSE_INTERVAL=5368709120
    export HEAP_PROFILE_TIME_INTERVAL=3600
    export G_SLICE=always-malloc
    export HEAP_PROFILE_MMAP=true
    rm ${HEAP_PROFILE_PREFIX}*
fi

# export JSC_useJIT=false
# export JSC_useDFGJIT=false
# export JSC_useRegExpJIT=false
# export JSC_showObjectStatistics=true
# export GST_DEBUG=playsink:6,basesink:6
# export GST_DEBUG_DUMP_DOT_DIR=`pwd`

# export QT_WEBKIT_LOG=Media
# export GST_DEBUG=*web*:5,2
# export MSE_DUMP=/tmp/
# export G_DEBUG=fatal_warnings
# export MSE_MAX_BUF_SIZE=30
# export http_proxy=http://proxy.dt.ccp.cable.comcast.com:3128
# export http_proxy=http://edge.proxy.xcr.comcast.net:8080
# export USER_AGENT="Mozilla/5.0 (X11; U: Linux i686; en-US) AppleWebKit/533.4 (KHTML, like Gecko) Chrome/5.0.375.127 Large Screen Safari/533.4 GoogleTV/b39389"

ulimit -c unlimited

${DEBUG_CMD_PREFIX} qtbrowser "$@" \
                    -ua "$USER_AGENT"
