/*
* ============================================================================
* RDK MANAGEMENT, LLC CONFIDENTIAL AND PROPRIETARY
* ============================================================================
* This file (and its contents) are the intellectual property of RDK Management, LLC.
* It may not be used, copied, distributed or otherwise  disclosed in whole or in
* part without the express written permission of RDK Management, LLC.
* ============================================================================
* Copyright (C) 2017 Broadcom. The term "Broadcom" refers to Broadcom Limited and/or its subsidiaries.
* Copyright (c) 2017 RDK Management, LLC. All rights reserved.
* ============================================================================
*/

#ifndef MEDIA_PLAYER_SINK_H
#define MEDIA_PLAYER_SINK_H

#include "rmfbase.h"
#include <string>

/**
 * X1 video player sink.
 */
class MediaPlayerSink: virtual public RMFMediaSinkBase
{
public:
    RMFResult setVideoRectangle(unsigned x, unsigned y, unsigned w, unsigned h, bool apply_now = false);

    // from RMFMediaSinkBase
    /*virtual*/ void onSpeedChange(float new_speed);
    /*virtual*/ void* createElement();

    typedef void (*callback_t)(void* data);

    void setMuted(bool muted);
    bool getMuted();
    void setVolume(float volume);
    float getVolume();
    RMFResult getMediaTime(double& t);

protected:
    void setHaveVideoCallback(callback_t cb, void* data);
    void setHaveAudioCallback(callback_t cb, void* data);
    void setVolumeChangedCallback(callback_t cb, void* data);
    void setMuteChangedCallback(callback_t cb, void* data);

    void* getVideoRenderer() const;
    long getVideoDecoderHandle() const;
    void setAudioLanguage (const char* pAudioLang);
    // from RMFMediaSinkBase
    /*virtual*/ RMFMediaSinkPrivate* createPrivateSinkImpl();
};

#endif // MEDIA_PLAYER_SINK_H
