//
// pace_mfr_nvram_api.h
//

#ifndef _PACE_MFR_NVRAM_API_H__
#define _PACE_MFR_NVRAM_API_H__


#ifdef __cplusplus
extern "C" {
#endif

// Initialise the nvram interface of the manufacturer API 
VL_MFR_API_RESULT pace_mfr_nvram_init( void );

// De-Initialise the nvram interface of the manufacturer API 
VL_MFR_API_RESULT pace_mfr_nvram_shutdown( void );

/*
   pace_mfr_read_normal_nvram ()
   This function reads the specified NVRAM data. 
   The caller owns / allocates the pNvRamData structure. 
   The pNvRamData->pData buffer is allocated by the called function and freed by the caller.
*/
VL_MFR_API_RESULT pace_mfr_read_normal_nvram (VL_NORMAL_NVRAM_DATA_TYPE eType, VL_NVRAM_DATA * pNvRamData);


/*
   pace_mfr_write_normal_nvram ()
   This function writes the specified NVRAM data. 
   The caller owns / allocates the pNvRamData structure. 
   The pNvRamData->pData buffer is also owned / allocated by the caller and freed by the caller.
*/
VL_MFR_API_RESULT pace_mfr_write_normal_nvram(VL_NORMAL_NVRAM_DATA_TYPE eType, const VL_NVRAM_DATA * pNvRamData);


/*
   pace_mfr_read_secure_nvram ()
   This function is used to read the specified NVRAM data.
   The caller owns / allocates the pNvRamData structure. 
   The pNvRamData->pData buffer is allocated by the called function and freed by the caller.
*/
VL_MFR_API_RESULT pace_mfr_read_secure_nvram (VL_SECURE_NVRAM_DATA_TYPE eType, VL_NVRAM_DATA * pNvRamData);


/*
   pace_mfr_write_secure_nvram ()
   This function is used to write the specified NVRAM data.
   The caller owns / allocates the pNvRamData structure. 
   The pNvRamData->pData buffer is also owned / allocated by the caller and freed by the caller.
*/
VL_MFR_API_RESULT pace_mfr_write_secure_nvram(VL_SECURE_NVRAM_DATA_TYPE eType, const VL_NVRAM_DATA * pNvRamData);


#ifdef __cplusplus
}
#endif

#endif /* _PACE_MFR_NVRAM_API_H__ */


