/******************************************************************************
* Copyright (c) 2011 SeaChange International (SeaChange) and its Licensors. 
* All rights reserved.
*
* This software is the confidential and proprietary information of SeaChange
* ("Confidential Information"). You shall not disclose this source code or 
* such Confidential Information and shall use it only in accordance with the 
* terms of the license agreement you entered into.
*  
* SEACHANGE INERNATIONAL  MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE 
* SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT 
* LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A 
* PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SEACHANGE SHALL NOT BE LIABLE FOR 
* ANY DAMAGES SUFFERED BY LICENSEE NOR SHALL THEY BE RESPONSIBLE AS A RESULT 
* OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
*******************************************************************************/


#ifndef PDT_HAL_H
#define PDT_HAL_H

#ifdef __cplusplus
extern "C" {
#endif

/*===================================================================
   INCLUDES AND PUBLIC DATA DECLARATIONS
===================================================================*/
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

/*-------------------------------------------------------------------
   Defines/Macros
-------------------------------------------------------------------*/


/*-------------------------------------------------------------------
   Types/Structs
-------------------------------------------------------------------*/

#define PDT_HandleCreate(eDeviceType, uInstanceNum) ((eDeviceType << 16) | (uInstanceNum & 0xffff))
#define PDT_HandleParseDevice(hHandle)              (hHandle >> 16)
#define PDT_HandleParseInstance(hHandle)            (hHandle & 0xffff)


/*-------------------------------------------------------------------
   Global Data Declarations
-------------------------------------------------------------------*/

/*===================================================================
   FUNCTION PROTOTYPES
===================================================================*/

/* Prototypes for HAL test function entry points */
#if (defined MR05_P1 | defined MR06_P0)
int vbi_analog_cc_test(void);
int vbi_tv_guide_cc_test(void);
#if (defined MR05_P1 | defined MR06_P0)
void pio_Tvp5160Menu(void);
#endif
#endif
int cc_test(int argc, char *argv[]);
int disp_test(int argc, char *argv[]);
int crypto_test(int argc, char *argv[]);
/*int flash_test(int argc, char *argv[]);*/
int fpd_test(int argc, char *argv[]);
int pod_test(int argc, char *argv[]);
int gfx_test(int argc, char *argv[]);
#if 0 /* for now disable IRB*/
int irb_test(int argc, char *argv[]);
#endif
int hid_test(int argc, char *argv[]);
int mpaud_test(int argc, char *argv[]);
int mpvid_test(int argc, char *argv[]);
int eeprom_test(int argc, char *argv[]);
int sectflt_test(int argc, char *argv[]);
int sys_test(int argc, char *argv[]);
int tuner_test(int argc, char *argv[]);
int transport_test(int argc, char *argv[]);
int utils_test(int argc, char *argv[]);
int usage_test(int argc, char *argv[]);
int anaaud_test(int argc, char *argv[]);
int anavid_test(int argc, char *argv[]);
int extdev_test(int argc, char *argv[]);

/*-------------------------------------------------------------------
   Include Files from the individual modules, eg. halsys/sys_api.h
-------------------------------------------------------------------*/

#include "hal_api.h"
/*
#include "sys_api.h"
#include "sectflt_interface.h"
#include "trnspt_interface.h"
#include "eeprom_interface.h"
#include "mppcr_interface.h"
#include "tsmgr_interface.h"
#include "mpaud_interface.h"
#include "mpvid_interface.h"
#include "tuner_interface.h"
#include "crypto_interface.h"
#include "disp_interface.h"
#include "gfx_interface.h"
#include "irb_interface.h"
#include "hid_interface.h"
#include "fpd_interface.h"
#include "anaaud_interface.h"
#include "anavid_interface.h"
#include "vbi_interface.h"
#include "pod_interface.h"
#include "ip_utils.h"
#include "sys_error_string.h"
#include "hal_mutex.h"
*/
/* TODO: commented out to allow test suite development using utilities
#include "hal_utils.h"
*/

#ifdef __cplusplus
}
#endif

#endif /* PDT_HAL_H */
