 /******************************************************************************
* Copyright (c) 2011 SeaChange International (SeaChange) and its Licensors. 
* All rights reserved.
*
* This software is the confidential and proprietary information of SeaChange
* ("Confidential Information"). You shall not disclose this source code or 
* such Confidential Information and shall use it only in accordance with the 
* terms of the license agreement you entered into.
*  
* SEACHANGE INERNATIONAL  MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE 
* SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT 
* LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A 
* PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SEACHANGE SHALL NOT BE LIABLE FOR 
* ANY DAMAGES SUFFERED BY LICENSEE NOR SHALL THEY BE RESPONSIBLE AS A RESULT 
* OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
*******************************************************************************/



#include "cablecarddriver.h"
#include "rmf_osal_sync.h"
#include "rmf_osal_event.h"

#ifndef __HALPOD_DRVPLGIN_H__
#define __HALPOD_DRVPLGIN_H__
/*-------------------------------------------------------------------
   Defines/Macros
-------------------------------------------------------------------*/
#define EXTDEV_AUDIOBB_MAX_DEVICES  2
#define EXTDEV_VIDEOBB_MAX_DEVICES  1
#define EXTDEV_POD_MAX_DEVICES      2
#define EXTDEV_IEEE1394_MAX_DEVICES 2
#define HAL_POD_MAX_PODS   (1) 	   /*  number of cablecards */
#define MAX_CABLECARD_DEVICES   (1)



typedef unsigned long DEVICE_HANDLE_t;
typedef unsigned char  UINT8;
typedef unsigned char  BOOLEAN;


class CHALPod : public cableCardDriver
{
public:

	CHALPod();
	~CHALPod();
  // Methods
	char* plugin_title()
	{
		return ("halpod");
	}
	void 		initialize();
	int  		get_device_count();
	int		open_device(int device_instance);
	int		close_device(int device_instance);
	int 		register_callback(eCallbackType type, void *func_ptr, int device_instance);
	int 		send_data(void *ptr,  CHANNEL_TYPE_T  type, int device_instance);
	DEVICE_HANDLE_t GetHandleFromInstance(int device_instance);
	void		ConnectSourceToPOD(unsigned long tuner_in_handle);
	void		DisconnectSourceFromPOD(unsigned long tuner_in_handle);
    int    oob_control(int device_instance, unsigned long eCommand, void * pData);
    int    if_control(int device_instance, unsigned long eCommand, void * pData);
int  configPodCipher(unsigned char ltsid,unsigned short PrgNum,unsigned long *decodePid,unsigned long numpids,unsigned long DesKeyAHi,unsigned long DesKeyALo,unsigned long DesKeyBHi,unsigned long DesKeyBLo,void *pStrPtr);
int  stopconfigPodCipher(unsigned char ltsid,unsigned short PrgNum,unsigned long *decodePid,unsigned long numpids);

private: // Variables

};

#endif // __HALPOD_DRVPLGIN_H__

