/******************************************************************************
* Copyright (c) 2011 SeaChange International (SeaChange) and its Licensors. 
* All rights reserved.
*
* This software is the confidential and proprietary information of SeaChange
* ("Confidential Information"). You shall not disclose this source code or 
* such Confidential Information and shall use it only in accordance with the 
* terms of the license agreement you entered into.
*  
* SEACHANGE INERNATIONAL  MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE 
* SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT 
* LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A 
* PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SEACHANGE SHALL NOT BE LIABLE FOR 
* ANY DAMAGES SUFFERED BY LICENSEE NOR SHALL THEY BE RESPONSIBLE AS A RESULT 
* OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
*******************************************************************************/
#ifdef USE_POD

#include <stdio.h>
#include <sys/times.h>
//#include "vlHalApi.h"
#include "hal_module.h"
#include "hal_error.h"
#include "pod_low_api.h"


#include "link.h"
#include "pod_api.h"
#include "pod_api.h"
#include "pod_priv.h"
#include "pod_module.h"

#include "mpod.h"
//#include "pod_os.h"
#include "errno.h"
#include <asm/ioctl.h>
#include <sys/ioctl.h>
//#define POD_thread_exit pthread_exit(0)
#include "mpod_ioctls.h"
#include "rdk_debug.h"
#include "rmf_osal_event.h"
#include "rmf_osal_thread.h"
#include "rmf_osal_mem.h"
#include "rmf_osal_sync.h"
#include "rfcapi.h"

#ifdef MPOD_SUPPORT

#define FALSE false
#define TRUE  true
#define BOOL  bool

#define VL_POD_NUM_EIO_ERRORS 2

//#define VL_MPOD_PCMCIA_RESET	1

#ifdef __cplusplus
extern "C" {
#endif 

void vlCardManager_PodMemFree(UCHAR * pU);
UCHAR *vlCardManager_PodMemAllocate(USHORT size);

//static UCHAR acStoreLPDU [MAX_LINK_BUF_SIZE];
UCHAR acStoreOOBData [MAX_MPEG_SIZE];
//static USHORT packetSizeCount = 0;  // we need to save this across function calls because a OOB LPDU
                                    // can span multiple calls to link_ReadExtended()
//static USHORT accumulatedPacketSize = 0;				    
//static UCHAR	e_bNbTC = 1; //for now - later get it from middleware  Hannah
//static UCHAR   transId = 1;	//for now - later get it from middleware  Hannah	
extern int ulPodPollResponseTime;
extern rmf_osal_eventqueue_handle_t    recvMsgQ;

#define TRANS_MAXSIZE_TPDU          512                     //Hannah	
#define TRANS_NBMAX_TC              5                      //Hannah

#define POD_LINK_DATA_LF_MASK 0x03
#define POD_LINK_DATA_FIRST 0x01
#define POD_LINK_DATA_LAST 0x02

//T_TC  e_pstTC [TRANS_NBMAX_TC]; /* Transport Connection information */   //Hannah	    

BOOL link_ProcessExtendedToHost (UCHAR *pHeader, UCHAR *pData, USHORT wSize);
MPOD_RET_CODE VL_MPOD_Start_Reset();
MPOD_RET_CODE VL_MPOD_Start_PCMCIA_Reset();

/* Enable or disable the debug printing of LPDU processing time */
//#undef DEBUG_PDU_TIMING 
//#define DEBUG_PDU_TIMING

/* The high order bit of the second byte in the LAPD indicates if this LPDU is one of
** a sequence or not. */
#define MORE_DATA_BIT       BIT7
/*****************  OOB Definitions  ******************/
#define HEADER_SIZE 4

#define FIRSTLAST_LPDU_STATE    1
#define FIRST_LPDU_STATE        2
#define FRAGMENT_LPDU_STATE     3
#define IGNORE_STATE            4

#define VL_MPOD_FRAGMENT_SIZE  2048

//#include "vlOcapDebug.h"
//DECLARE_LOG_APPTYPE (LOG_APPTYPE_OCAP_HAL_DRIVERS_TRANSPORT)

typedef struct _VL_MPOD_DATA_ACCUMULATOR
{
    int flow_id      ;
    unsigned char * pData;
    int nBufCapacity ;
    int nCurLength   ;
    int bStartedAccumulation;
    
}VL_MPOD_DATA_ACCUMULATOR;

//Added for SNMP purpose.
unsigned long vlg_ExtChnTotalBytesRead = 0;

static VL_MPOD_DATA_ACCUMULATOR vlg_DataAccumulator        = {0, NULL, 0, 0, 0};
static VL_MPOD_DATA_ACCUMULATOR vlg_ExtChnlDataAccumulator = {0, NULL, 0, 0, 0};

#define ENABLE_REBOOT_ON_INVALID_OPEN_SESSION "Device.DeviceInfo.X_RDKCENTRAL-COM_RFC.Feature.RebootOnInvalidCASession.Enable"
static bool     isRebootOnInvalidSessionOpen = false;
static uint32_t req_card_reset_count = 0;
static uint32_t res_card_reset_count = 0;

static void processSessionOpenReqRes(unsigned char *buf, bool req_resp);
static void marRebooted();
static void clearRebootFlag();

/****************************************************************************************
Name:           link_GetSystemElapsedTime
type:           function
Description:    Get system time

In:             none

Out:            Nothing

Return value:   System time in milliseconds

*****************************************************************************************/

#ifdef DEBUG_PDU_TIMING
 ULONG link_GetSystemTime (void)
{
    ULONG ulTime;
    
    struct tms stTimesBuffer;
    
    /* 'times' returns time in system 'ticks'.  1 tick is 
    ** (currently) 10 milliseconds so adjust time for mills. */
    ulTime = times (&stTimesBuffer) * 10;
    
    return (ulTime);
}
#endif

#define DUMP_BUFFER_CHARS       16
#define DUMP_BUFFER_CHAR(ch)    ((((ch)>=32) && ((ch)<=126) && ('%' != ch))?(ch):'.')
#define MIN_OF(a, b)   (((a)<(b))?(a):(b))
void dumpBuffer(rdk_LogLevel lvl, const char *mod, const void * pBuffer, int nBufSize)
{
    int nPrinted = 0;
    if(!rdk_dbg_enabled(mod, lvl)) return;
    RDK_LOG(lvl, mod, "==================================dumpBuffer starts===================================\n");

    while(nPrinted < nBufSize)
    {
        int i = 0; int iLoc = 0;
        const unsigned char * buf = ((const unsigned char*)pBuffer) + nPrinted;
        char szFormat[DUMP_BUFFER_CHARS * 10 + 10];
        int nToPrint = MIN_OF(DUMP_BUFFER_CHARS, nBufSize - nPrinted);

        iLoc = 0;
        snprintf(szFormat+iLoc, sizeof(szFormat)-iLoc, "Buf: 0x%04x :", nPrinted);

        for(i = 0; i < nToPrint; i++)
        {
            iLoc = 13+i*3;
            snprintf(szFormat+iLoc, sizeof(szFormat)-iLoc, " %02x", buf[i]);
        }

        for(i = 0; i < DUMP_BUFFER_CHARS-nToPrint; i++)
        {
            iLoc = 13+(nToPrint+i)*3;
            snprintf(szFormat+iLoc, sizeof(szFormat)-iLoc, "   ");
        }
        iLoc = 13+(DUMP_BUFFER_CHARS)*3;
        snprintf(szFormat+iLoc, sizeof(szFormat)-iLoc, "  ");

        for(i = 0; i < nToPrint; i++)
        {
            iLoc = 13+(DUMP_BUFFER_CHARS)*3+2+i;
            snprintf(szFormat+iLoc, sizeof(szFormat)-iLoc,  "%c", DUMP_BUFFER_CHAR(buf[i]));
        }

        iLoc = 13+(DUMP_BUFFER_CHARS)*3+2+nToPrint;
        snprintf(szFormat+iLoc, sizeof(szFormat)-iLoc, "\n");
		
		RDK_LOG(lvl, mod, szFormat);
		nPrinted += DUMP_BUFFER_CHARS;
	}
	RDK_LOG(lvl, mod, "==================================dumpBuffer ends===================================\n");
}
static void markRebooted()
{
	FILE *fp = fopen("/opt/ca_support_failed", "r+w");
	if (NULL != fp) {
		RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "Reboot initiated due to invalid CA support\n");
		fclose(fp);
	} else {
		RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "Reboot flag for invalid CA support is failed\n");
	}
}

static void clearRebootFlag()
{
	if (0 == remove("/opt/ca_support_failed"))
	{
		RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "Reboot initiated due to invalid CA support flag cleared\n");
	} else {
		RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "Reboot initiated due to invalid CA support flag is clearing failed\n");
	}
}



static void processSessionOpenReqRes(unsigned char *buf, bool req_resp)
{
	uint32_t res_identifier = 0;
	uint16_t res_class      = 0;
	uint8_t  res_type       = 0;
	uint8_t  res_version    = 0;

	res_identifier  = (uint32_t)(buf[0] << 24);
	res_identifier |= (uint32_t)(buf[1] << 16);
	res_identifier |= (uint32_t)(buf[2] << 8);
	res_identifier |= (uint32_t)(buf[3]);

	res_class       = (uint16_t)((res_identifier & 0xffff0000) >> 16);
	res_type        = (uint8_t)((res_identifier & 0x0000ffc0) >> 6);
	res_version     = (uint8_t)(res_identifier & 0x0000003f);
	RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "Open session request res_id 0x%x res_class %d res_type %d res_version %d\n",
			res_identifier, res_class, res_type, res_version);
	if (res_class == 0x3)
	{
		if (res_type != 0x02 || res_version != 0x01)
		{
			RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "Open session received invalid CA Support\n");
			(req_resp == true) ? req_card_reset_count++ : res_card_reset_count++;
			if (req_card_reset_count == 3 || res_card_reset_count == 3)
			{
				markRebooted();
				system("sh /rebootNow.sh -s runpod -o 'Invalid CA session open'");
			}
			cwt_POD_signal_reset(ePOD_RESET_FULL);
		}
		else
		{
			clearRebootFlag();
		}
	}
	else
	{
		RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "Open session CA Support is good\n");
	}
}


void initializeRFC()
{
	RFC_ParamData_t rfcParam;
	char* key = ENABLE_REBOOT_ON_INVALID_OPEN_SESSION;

	if (WDMP_SUCCESS == getRFCParameter("PwrMgr", key, &rfcParam))
	{
		isRebootOnInvalidSessionOpen = (strncasecmp(rfcParam.value, "true", 4) == 0);
	}
	RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "Reboot enabled on invalid CA session %s\n",
		isRebootOnInvalidSessionOpen ? "true" : "false");
}

void VL_MPOD_Send_FullData_To_CardManager(int bExtChnlData, VL_MPOD_DATA_ACCUMULATOR * pAccumulator)
{
    if(bExtChnlData)
    {
        // extended channel data
        if(NULL != stHalPODBase.astPOD[0].extCh_data_available_cb)
        {
            long lFlowId = 0;
            
            lFlowId  = ((pAccumulator->pData[1]<<16)&0x00ff0000);
            lFlowId |= ((pAccumulator->pData[2]<<8 )&0x00ff00  );
            lFlowId |= ((pAccumulator->pData[3]<<0 )&0x00ff    );

            //Added by Prasad (04/04/2009) - For counting the total number of bytes read on extended channel. For SNMP purpose.
            vlg_ExtChnTotalBytesRead += (pAccumulator->nCurLength - 4);

            // send extended channel data
            //RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "VL_MPOD_Send_FullData_To_CardManager: lFlowId = %d\n", lFlowId);
            stHalPODBase.astPOD[0].extCh_data_available_cb((int)NULL, lFlowId, (pAccumulator->pData+4), (pAccumulator->nCurLength-4));


        }
    }
    else
    {
        // regular data
        if(NULL != stHalPODBase.astPOD[0].data_available_cb)
        {
            T_TC  tcData;
            tcData.lSize = pAccumulator->nCurLength;
            tcData.pData = pAccumulator->pData;

            {
                char timestr[100];
                time_t t;
                struct tm *tmp;
            
                t = time(NULL);
                tmp = localtime(&t);
                
                RDK_LOG(RDK_LOG_TRACE1, "LOG.RDK.POD", "----------------------------------------------------------------------\n");
				//RDK_LOG(RDK_LOG_DEBUG,"LOG.RDK.POD","%s():----------------------------------------------------------------------\n", __FUNCTION__);

                memset(timestr, 0, sizeof(timestr));
                if (strftime(timestr, sizeof(timestr), "%s", tmp) == 0) {
                    fprintf(stderr, "VL_MPOD_Send_FullData_To_CardManager: strftime returned 0");
                }
                RDK_LOG(RDK_LOG_TRACE1, "LOG.RDK.POD", "VL_MPOD_Send_FullData_To_CardManager: length = %d, time = %s\n", pAccumulator->nCurLength, timestr);
		//RDK_LOG(RDK_LOG_DEBUG,"LOG.RDK.POD","%s(): length = %d, time = %s\n", __FUNCTION__,pAccumulator->nCurLength, timestr);
		if(pAccumulator->nCurLength > 7)
		{
			if((( pAccumulator->pData[4] == 0x9F ) &&
				( pAccumulator->pData[5] == 0x90 ) &&
				( pAccumulator->pData[6] == 0x02 ) )
				||
				(( pAccumulator->pData[4] == 0x9F ) &&
				 ( pAccumulator->pData[5] == 0x80 ) &&
				 ( pAccumulator->pData[6] == 0x33 ) ))
			{
				RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.POD", "Data to cardmanager:starts \n");
				dumpBuffer(RDK_LOG_DEBUG, "LOG.RDK.POD", pAccumulator->pData, pAccumulator->nCurLength);
				RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.POD", "Data to cardmanager:ends \n");
			}
		}
		if (pAccumulator->pData[0] == 0x91 || pAccumulator->pData[0] == 0x92)
		{
			RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "Open session data to cardmanager starts.... \n");
			dumpBuffer(RDK_LOG_INFO, "LOG.RDK.POD", pAccumulator->pData, pAccumulator->nCurLength);
			if (isRebootOnInvalidSessionOpen == true)
			{
				processSessionOpenReqRes(&pAccumulator->pData[2], true);
			}
			RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "Open session data to cardmanager ends.... \n");
		}
            }

            if(pAccumulator->nCurLength < 0x400)
            {
                //vlMpeosDumpBuffer(RDK_LOG_TRACE1, "LOG.RDK.POD", pAccumulator->pData, pAccumulator->nCurLength);
            }

            // send regular data
            stHalPODBase.astPOD[0].data_available_cb((int)NULL, &tcData, NULL);
        }
    }
}

static int VL_MPOD_Send_Data_Fragment(VL_MPOD_DATA_ACCUMULATOR * pAccumulator, MPOD_LINK_DRV_RCV_CTRL data_rcv)
{
    if ((data_rcv.last_first&POD_LINK_DATA_FIRST) == POD_LINK_DATA_FIRST)
    {
        // reset accumulator
        pAccumulator->nCurLength = 0;
        pAccumulator->bStartedAccumulation = 1;
    }
    
    if(0 == pAccumulator->bStartedAccumulation)
    {
        // free pod buffer
        //POD_free(data_rcv.data);
        vlCardManager_PodMemFree(data_rcv.data);
        //rmf_osal_memFreeP(RMF_OSAL_MEM_POD, data_rcv.data);
        return 0;   
    }

    // do we have enough capacity ?
    while((pAccumulator->nCurLength + data_rcv.len) > (unsigned int)(pAccumulator->nBufCapacity))
    {
        // allocate more capacity
        unsigned char * pNewData = NULL;

        rmf_osal_memAllocP(RMF_OSAL_MEM_POD, pAccumulator->nBufCapacity+VL_MPOD_FRAGMENT_SIZE, (void**)&pNewData);

        // check for NULL
        if((NULL != pNewData) && (NULL != pAccumulator->pData))
        {
            // copy data accumulated so far
            rmf_osal_memcpy(pNewData, pAccumulator->pData, pAccumulator->nCurLength,
            					pAccumulator->nBufCapacity+VL_MPOD_FRAGMENT_SIZE, pAccumulator->nCurLength);
            // free old buffer
            rmf_osal_memFreeP(RMF_OSAL_MEM_POD, pAccumulator->pData);
        }
        else if(NULL == pNewData)
        {
            pAccumulator->nCurLength = 0;
            return -1;
        }
        
        // switch to new buffer
        pAccumulator->pData = pNewData;
        // register new capacity
        pAccumulator->nBufCapacity += VL_MPOD_FRAGMENT_SIZE;
    }

    // null check
    if(NULL != pAccumulator->pData)
    {
        // null check
        if((NULL != data_rcv.data) && (data_rcv.len > 0))
        {
            // accumulate fragment data
            rmf_osal_memcpy(pAccumulator->pData + pAccumulator->nCurLength, data_rcv.data, data_rcv.len,
            		  	(pAccumulator->nBufCapacity - pAccumulator->nCurLength), data_rcv.len );
            // accumulate fragment length
            pAccumulator->nCurLength   += data_rcv.len;
            // free pod buffer
			vlCardManager_PodMemFree(data_rcv.data);
			//rmf_osal_memFreeP(RMF_OSAL_MEM_POD, data_rcv.data);
            data_rcv.data = NULL;
        }

        // check if last fragment
        if ((data_rcv.last_first&POD_LINK_DATA_LAST) == POD_LINK_DATA_LAST)
        {
            // send accumulated data to stack
            VL_MPOD_Send_FullData_To_CardManager(data_rcv.ec, pAccumulator);
            // reset accumulator
            pAccumulator->nCurLength = 0;
            pAccumulator->bStartedAccumulation = 0;
        }
    }
    
    return 1;
}

void POD_Link_Data_Rcv_Thread (void *arg)
{
    int err;
    MPOD_LINK_DRV_RCV_CTRL data_rcv;
    extern int errno;
    static int nTimes = 0;
    
    while (1)
    {
        //RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "VL_MPOD_Link_Data_Rcv_Thread: Before LEN Ioctl\n");
        /* first get the length of the data to be received. 
        should block on this till there is data. */
        data_rcv.data = NULL;
        RDK_LOG(RDK_LOG_TRACE9, "LOG.RDK.POD", "%s: calling IOCTL_MPOD_DATA_RCV_LEN\n", __FUNCTION__);
        err = ioctl(stHalPODBase.podDrvHandle,IOCTL_MPOD_DATA_RCV_LEN, (unsigned long)(&(data_rcv.len)));
        RDK_LOG(RDK_LOG_TRACE9, "LOG.RDK.POD", "%s: returning from IOCTL_MPOD_DATA_RCV_LEN\n", __FUNCTION__);
        if (err<0)
        {
            //RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "IOCTL_MPOD_DATA_RCV_LEN failed.\n");
            /* what do we want to do? */
            /* if we get RE reset POD. */
            if (errno == EIO)
            {
                RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "RE detected start reset process errno %d EIO %d.\n", errno, EIO);
				RDK_LOG(RDK_LOG_DEBUG,"LOG.RDK.POD","%s():RE detected start reset process errno %d EIO %d.\n", __FUNCTION__,errno, EIO);

                nTimes++;
                if (nTimes > VL_POD_NUM_EIO_ERRORS)
                {
                    cwt_POD_signal_reset(ePOD_RESET_FULL); // VL_MPOD_Start_Reset();
                    nTimes = 0;
                }
                else
                {
                    cwt_POD_signal_reset(ePOD_RESET_PCMCIA);
                }
                RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "%s()%d: ERROR RCV_LEN, Pod Reset errno %d EIO %d, nTimes = %d\n", __FUNCTION__, __LINE__, errno, EIO, nTimes);
                rmf_osal_threadSleep(100,0);
            }
            continue;
        }
        else nTimes = 0; // Success resets the error times.

        // Workaround for BPV-924.  According to stacktrace, size is 742230808
        if (data_rcv.len > 5000)
        {
            RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD", "%s: receive data length > 5000, actual size %u\n", __FUNCTION__, data_rcv.len);
            continue;
        }

        //data_rcv.data = (unsigned char *)POD_alloc(data_rcv.len);
        data_rcv.data = vlCardManager_PodMemAllocate(data_rcv.len);
        //rmf_osal_memAllocP(RMF_OSAL_MEM_POD, data_rcv.len, (void**)&data_rcv.data);

        //RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "VL_MPOD_Link_Data_Rcv_Thread: Before DATA Ioctl\n");
        /* now get the data. */
        RDK_LOG(RDK_LOG_TRACE9, "LOG.RDK.POD", "%s: calling IOCTL_MPOD_DATA_RCV for data\n", __FUNCTION__);
        err = ioctl(stHalPODBase.podDrvHandle,IOCTL_MPOD_DATA_RCV, (unsigned long)(&data_rcv));
        RDK_LOG(RDK_LOG_TRACE9, "LOG.RDK.POD", "%s: returning from IOCTL_MPOD_DATA_RCV\n", __FUNCTION__);
        if (err<0)
        {
            RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "IOCTL_MPOD_DATA_RCV failed.\n");
           /* what do we want to do? may be reset? */
            if (data_rcv.data)
				vlCardManager_PodMemFree(data_rcv.data);
                //rmf_osal_memFreeP(RMF_OSAL_MEM_POD, data_rcv.data);
            nTimes++;
            /* coverity[dead_error_condition]    CID - 18912 */
            if (nTimes > VL_POD_NUM_EIO_ERRORS)
            {
                cwt_POD_signal_reset(ePOD_RESET_FULL); // VL_MPOD_Start_Reset();
                nTimes = 0;
            }
            else
            {
                cwt_POD_signal_reset(ePOD_RESET_PCMCIA);
            }
            RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "%s()%d: ERROR RCV_LEN, Pod Reset errno %d EIO %d, nTimes = %d\n", __FUNCTION__, __LINE__, errno, EIO, nTimes);
            rmf_osal_threadSleep(100,0);
            continue;
        }
        else nTimes = 0; // Success resets the error times.
        
        /* send the data to rcv queue. */
        if(data_rcv.ec)
        {
            //RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "VL_MPOD_Link_Data_Rcv_Thread: Received Ext Channel Data\n");
            VL_MPOD_Send_Data_Fragment(&vlg_ExtChnlDataAccumulator, data_rcv);
        }
        else
        {
            VL_MPOD_Send_Data_Fragment(&vlg_DataAccumulator, data_rcv);
        }

        //rmf_osal_threadSleep(100);   /* delay before checking for remove. */
    }

#if 0    
    //RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "Rx link thread done!\n");
	RDK_LOG(RDK_LOG_DEBUG,"LOG.RDK.POD","%s():Rx link thread done!\n", __FUNCTION__);

    /* if we get RE reset POD. */
    {
        static int nTimes = 0;
        nTimes++;
        if (errno == EIO)
        {
            if(nTimes > VL_POD_NUM_EIO_ERRORS)
            {
                RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "%s: Calling  VL_MPOD_Start_PCMCIA_Reset After %d failures()\n",__FUNCTION__, nTimes);
#ifdef VL_MPOD_PCMCIA_RESET
                                VL_MPOD_Start_PCMCIA_Reset();
#else
				RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "\n ==> calling VL_MPOD_Start_Reset \n");
                                VL_MPOD_Start_Reset();
#endif
                nTimes = 0;
                rmf_osal_threadSleep(1000,0);
            }
        }
        else
        {
            nTimes = 0;
        }
    }
    //pthread_exit(0);
#endif

    //RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "##### recv thread exit\n");
	RDK_LOG(RDK_LOG_DEBUG,"LOG.RDK.POD","%s():##### recv thread exit\n", __FUNCTION__);
    //POD_thread_exit;
}

int VL_MPOD_Link_Send_Data_To_Card(int bExtChnlData, sCIMessage_t sCIMsg)
{
    int err = 0;
    
    if (sCIMsg.u.sPodPkt.pData)
    {
        // Jun-04-2012: Re-added patch from Aug-31-2009: for REQ3199.1
        //static long lock = 0;
        static rmf_osal_Mutex lock;
        if(0 == lock)
        {
            //lock = cMutexCreate();
            err = rmf_osal_mutexNew(&lock);
            if (err != RMF_SUCCESS)
            {
                RDK_LOG(RDK_LOG_WARN, "LOG.RDK.SI",
                   "<%s() Mutex creation failed, returning -1\n", __FUNCTION__);
                return -1;
            }

        }
        //cMutexBegin(lock);
        rmf_osal_mutexAcquire(lock);
        {
            unsigned char *pData = sCIMsg.u.sPodPkt.pData;
    //        int iPosition = 0;
            int nRemainderLength = sCIMsg.u.sPodPkt.lSize;
            int nCurLength = 0;
            int nFlags = 0;
            int iFragment = 0;
            MPOD_LINK_DRV_SEND_CTRL data_send;
            
            // fill up ioctl params
            data_send.ec = bExtChnlData;
            data_send.flowId = 0;
            if (data_send.ec)
            {
                data_send.flowId = sCIMsg.u.sPodPkt.FlowID;
            }

            // while there is data to be sent
            while(nRemainderLength > 0)
            {
                // is this the first fragment
                if(nRemainderLength == sCIMsg.u.sPodPkt.lSize)
                {
                    // indicate first
                    nFlags |= POD_LINK_DATA_FIRST;
                }

                // is this the second or later fragment
                if(iFragment > 0)
                {
                    // reset first fragment indication
                    nFlags = 0;
                }

                // does the data need to be fragemented ?
                if(nRemainderLength > VL_MPOD_FRAGMENT_SIZE)
                {
                    // fragment it
                    nCurLength = VL_MPOD_FRAGMENT_SIZE;
                }
                else
                {
                    // indicate last fragment
                    nFlags |= POD_LINK_DATA_LAST;
                    // use the remainder length
                    nCurLength = nRemainderLength;
                }

                // fill up ioctl data struct
                data_send.last_first = nFlags;
                data_send.len = (USHORT)nCurLength;
                data_send.data = pData;

                if (nCurLength == 9 && pData[0] == 0x92 && pData[1]==0x07)
                {
                        RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", ">>>>>> OPEN SESION RESP:  <<<<#Id:0x%02X%02X%02X%02X, status %X\n",
                                pData[3], pData[4], pData[5], pData[6],  pData[2]);
                }

		if(sCIMsg.u.sPodPkt.lSize > 7)
		{
			if((( sCIMsg.u.sPodPkt.pData[4] == 0x9F ) &&
				 ( sCIMsg.u.sPodPkt.pData[5] == 0x90 ) &&
				 ( sCIMsg.u.sPodPkt.pData[6] == 0x03 ) )
				||
				(( sCIMsg.u.sPodPkt.pData[4] == 0x9F ) &&
				 ( sCIMsg.u.sPodPkt.pData[5] == 0x80 ) &&
				 ( sCIMsg.u.sPodPkt.pData[6] == 0x32 ) ))
			{
				RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.POD", "Data from HOST:starts \n");
				dumpBuffer(RDK_LOG_DEBUG, "LOG.RDK.POD", sCIMsg.u.sPodPkt.pData, sCIMsg.u.sPodPkt.lSize);
				RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.POD", "Data from HOST:ends \n");
			}
		}
		if (sCIMsg.u.sPodPkt.pData[0] == 0x91 || sCIMsg.u.sPodPkt.pData[0] == 0x92)
		{
			/*
			uint32_t res_identifier = 0;
			uint16_t res_class      = 0;
			uint8_t  res_type       = 0;
			uint8_t  res_version    = 0;
			RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "Open session data from Host to card starts.... \n"); */
			dumpBuffer(RDK_LOG_INFO, "LOG.RDK.POD", sCIMsg.u.sPodPkt.pData, sCIMsg.u.sPodPkt.lSize);
			/*
			res_identifier  = (uint32_t)(sCIMsg.u.sPodPkt.pData[3] << 24);
			res_identifier |= (uint32_t)(sCIMsg.u.sPodPkt.pData[4] << 16);
			res_identifier |= (uint32_t)(sCIMsg.u.sPodPkt.pData[5] << 8);
			res_identifier |= (uint32_t)(sCIMsg.u.sPodPkt.pData[6]);
			res_class       = (uint16_t)((res_identifier & 0xffff0000) >> 16);
			res_type        = (uint8_t)((res_identifier & 0x0000ffc0) >> 6);
			res_version     = (uint8_t)(res_identifier & 0x0000003f);
			RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "Open session response res_id 0x%x res_class %d res_type %d res_version %d\n",
				       res_identifier, res_class, res_type, res_version);
			if ((res_class == 0x3) && (res_type != 0x02 || res_version != 0x01))
			{
				RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "Open session response invalid CA Support\n");
			}
			else
			{
				RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "Open session CA Support is good\n");
			}
			*/
			if (isRebootOnInvalidSessionOpen == true)
			{
				processSessionOpenReqRes(&sCIMsg.u.sPodPkt.pData[3], false);
			}
			RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "Open session data from Host to card ends.... \n");
		}

                // perform IOCTL
                RDK_LOG(RDK_LOG_TRACE9, "LOG.RDK.POD", "%s: calling IOCTL_MPOD_DATA_SEND\n", __FUNCTION__);
                err = ioctl(stHalPODBase.podDrvHandle,IOCTL_MPOD_DATA_SEND, (unsigned long)(&data_send));
                RDK_LOG(RDK_LOG_TRACE9, "LOG.RDK.POD", "%s: returning from IOCTL_MPOD_DATA_SEND\n", __FUNCTION__);
                if (err<0)
                {
                    RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "%s: IOCTL_MPOD_DATA_SEND failed.\n",  __FUNCTION__);
                    //POD_free(data_send.data);
				    vlCardManager_PodMemFree(sCIMsg.u.sPodPkt.pData);
                    sCIMsg.u.sPodPkt.pData = NULL;
                    RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "\n%s:##### Send thread exit\n",  __FUNCTION__);
                    //cMutexEnd(lock);// Jun-04-2012: Re-added patch from Aug-31-2009: for REQ3199.1
                    rmf_osal_mutexRelease(lock);
                    return -1;
                }

                // update position, counters etc.
                iFragment        += 1;
                pData            += nCurLength;
                nRemainderLength -= nCurLength;
            }
            
            // free the data buffer
            //POD_free(data_send.data);
            vlCardManager_PodMemFree(sCIMsg.u.sPodPkt.pData);
            sCIMsg.u.sPodPkt.pData = NULL;
        }
        //cMutexEnd(lock);// Jun-04-2012: Re-added patch from Aug-31-2009: for REQ3199.1
        rmf_osal_mutexRelease(lock);
    }
    else
    {
        /* MUST be the tx_stop set. */
        RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "%s: No Data to send!!! Stop the send thread.\n", __FUNCTION__);
		RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD","%s():No Data to send!!! Stop the send thread.\n", __FUNCTION__);
        return -2;
    }

    // return success
    return 0;
}
void VL_MPOD_Link_Poll_Snd_Data()
{

	 extern int errno;
        sCIMessage_t sCIMsg;
	char Data[8] = {0x90,0x02,0x00,0x01,0x9F,0x80,0x10,0x00};
	int count = 5;
   
	while(count--)
	{
		sCIMsg.u.sPodPkt.pData = (unsigned char *)vlCardManager_PodMemAllocate(8);
		memcpy(sCIMsg.u.sPodPkt.pData,Data,8);
		sCIMsg.u.sPodPkt.lSize = 4;
		RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", ">>>>> calling VL_MPOD_Link_Send_Data_To_Card \n");
		if(VL_MPOD_Link_Send_Data_To_Card(FALSE, sCIMsg)<0)
    	{
        	 RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", ">>>>> %s: VL_MPOD_Link_Send_Data_To_Card returned error \n",__FUNCTION__);
             if (errno == EIO)
             {
                   RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", ">>>>>> %s: Calling  VL_MPOD_Start_PCMCIA_Reset \n",__FUNCTION__);
#ifdef VL_MPOD_PCMCIA_RESET
                                VL_MPOD_Start_PCMCIA_Reset();
#else
				RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "\n ==> calling VL_MPOD_Start_Reset \n");
                                VL_MPOD_Start_Reset();
#endif
					break;
			 }
    	}
		rmf_osal_threadSleep(10,0);
	}
}
void POD_Link_Data_Snd_Thread(void *arg)
{
//    int err;
    extern int errno;
    sCIMessage_t *sCIMsg;
    rmf_osal_event_handle_t event_handle_rcv;
    rmf_osal_event_params_t event_params_rcv; 
    rmf_osal_event_category_t event_category;
    uint32_t event_type;
    rmf_Error err;
    static int nTimes = 0;    


    //RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "VL_MPOD_Link_Data_Snd_Thread, 0x%08x\n", sendMsgQ);
	RDK_LOG(RDK_LOG_DEBUG,"LOG.RDK.POD","%s():VL_MPOD_Link_Data_Snd_Thread, 0x%08lx\n", __FUNCTION__,sendMsgQ);
    
    while (1)
    {
        //RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "VL_MPOD_Link_Data_Snd_Thread, 0x%08x\n", sendMsgQ);
        //rmf_osal_threadSleep(100);   /* delay before checking for remove. */
        //if (cMsgQRead(sendMsgQ, (char*)&sCIMsg, sizeof(sCIMessage_t), -1) > 0)
        err = rmf_osal_eventqueue_get_next_event( sendMsgQ,
                &event_handle_rcv, &event_category, &event_type, &event_params_rcv);
        if(RMF_SUCCESS != err)                          
//        if (vlFAILURE == cMsgQRead(stHalPODBase.podMsgQ,(char *)&message,sizeof(CARDMsg),C_SYS_WAIT_INFINITE))
        {
            RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD", " PODMsgHandlerTask:cMsgQRead Failed \n");
            continue;
        }
        else
        {
            sCIMsg = (sCIMessage_t*)event_params_rcv.data;
            switch (sCIMsg->eMsgId)
            {
                case MSG_CI_SEND_TPDU:
                {
                    //rmf_osal_threadSleep(100);
                    if(VL_MPOD_Link_Send_Data_To_Card(FALSE, *sCIMsg)<0)
                    {
                        RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "%s: VL_MPOD_Link_Send_Data_To_Card returned error \n",__FUNCTION__);
                        nTimes++;
                        if(nTimes > VL_POD_NUM_EIO_ERRORS)
                        {
                            cwt_POD_signal_reset(ePOD_RESET_FULL); // VL_MPOD_Start_Reset();
                            nTimes = 0;
                        }
                        else
                        {
                            cwt_POD_signal_reset(ePOD_RESET_PCMCIA);
                        }
                        RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "%s()%d: ERROR RCV_LEN, Pod Reset errno %d EIO %d, nTimes = %d\n", __FUNCTION__, __LINE__, errno, EIO, nTimes);
                        rmf_osal_threadSleep(1000,0);
                    }
                    else nTimes = 0; // Success resets the error times.
                }
                break;
		case MSG_CI_READ_TPDU:
		case MSG_CI_EXTENDED_READ:
		case MSG_CI_EXTENDED_WRITE:
		case MSG_CI_RESET_PCMCIA:
		case MSG_CI_RESET_POD_INTERFACE:
		case MSG_CI_TRANS_BYPASS_CTRL:
		case MSG_CI_DEBUG_FLAG_POD_CHECK:
		case MSG_CI_DEBUG_CIMAX_DUMP:
		case MSG_CI_DEBUG_CIMAX_READ:
		case MSG_CI_DEBUG_CIMAX_WRITE:
		case MSG_CI_MAX_MSGS:
		case MSG_CI_POLL:
                {
			RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "\n %s ERROR, some thing wrong, might be an error check it out \n",__FUNCTION__);
		}
                break;
            } /* End switch */
		rmf_osal_memFreeP(RMF_OSAL_MEM_POD, sCIMsg);
            rmf_osal_event_delete(event_handle_rcv);
        }
    }

    //RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "Link_Data_Send_Thread done!\n");
	RDK_LOG(RDK_LOG_DEBUG,"LOG.RDK.POD","%s():Link_Data_Send_Thread done!\n", __FUNCTION__);
    //RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "\n##### send thread exit\n");
	RDK_LOG(RDK_LOG_DEBUG,"LOG.RDK.POD","%s():##### send thread exit\n", __FUNCTION__);
    //POD_thread_exit;
}

void POD_Link_ExtChnl_Snd_Thread(void *arg)
{
    static int nTimes = 0;
    rmf_osal_event_handle_t event_handle_rcv;
    rmf_osal_event_params_t event_params_rcv; 
    rmf_osal_event_category_t event_category;
    uint32_t event_type;
    rmf_Error err;
//    int err;
    extern int errno;
    sCIMessage_t *sCIMsg;
    //RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "VL_MPOD_Link_ExtChnl_Snd_Thread, 0x%08x\n", sendMsgQ);
	RDK_LOG(RDK_LOG_DEBUG,"LOG.RDK.POD","%s():0x%08lx\n", __FUNCTION__,sendMsgQ);
    
    while (1)
    {
        //RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "VL_MPOD_Link_ExtChnl_Snd_Thread, 0x%08x\n", sendMsgQ);
        //rmf_osal_threadSleep(100,0);   /* delay before checking for remove. */
        //if (cMsgQRead(ext_channel_Queue, (char*)&sCIMsg, sizeof(sCIMessage_t), -1) > 0)
        err = rmf_osal_eventqueue_get_next_event( ext_channel_Queue,
                &event_handle_rcv, &event_category, &event_type, &event_params_rcv);
        if(RMF_SUCCESS != err)                          
//        if (vlFAILURE == cMsgQRead(stHalPODBase.podMsgQ,(char *)&message,sizeof(CARDMsg),C_SYS_WAIT_INFINITE))
        {
            RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD", " PODMsgHandlerTask:cMsgQRead Failed \n");
            continue;
        }
        else
        {
            sCIMsg = (sCIMessage_t*)event_params_rcv.data;
            switch (sCIMsg->eMsgId)
            {
                case MSG_CI_EXTENDED_WRITE:
                {
                    if(VL_MPOD_Link_Send_Data_To_Card(TRUE, *sCIMsg)<0)
                    {
                        if (errno == EIO)
                        {
                            nTimes++;
                            if(nTimes > VL_POD_NUM_EIO_ERRORS)
                            {
                                cwt_POD_signal_reset(ePOD_RESET_FULL); // VL_MPOD_Start_Reset();
                                nTimes = 0;
                            }
                            else
                            {
                                cwt_POD_signal_reset(ePOD_RESET_PCMCIA);
                            }
                            RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "%s()%d: ERROR RCV_LEN, Pod Reset errno %d EIO %d, nTimes = %d\n", __FUNCTION__, __LINE__, errno, EIO, nTimes);
                            rmf_osal_threadSleep(1000, 0);
                        }
                    }
                    else nTimes = 0; // Success resets the error times.
                }
                break;
		case MSG_CI_READ_TPDU:
		case MSG_CI_EXTENDED_READ:
		case MSG_CI_SEND_TPDU:
		case MSG_CI_RESET_PCMCIA:
		case MSG_CI_RESET_POD_INTERFACE:
		case MSG_CI_TRANS_BYPASS_CTRL:
		case MSG_CI_DEBUG_FLAG_POD_CHECK:
		case MSG_CI_DEBUG_CIMAX_DUMP:
		case MSG_CI_DEBUG_CIMAX_READ:
		case MSG_CI_DEBUG_CIMAX_WRITE:
		case MSG_CI_MAX_MSGS:
		case MSG_CI_POLL:
                {
			RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "\n %s ERROR, some thing wrong, might be an error check it out \n",__FUNCTION__);
		}
                break;
            } /* End switch */
		rmf_osal_memFreeP(RMF_OSAL_MEM_POD, sCIMsg);
            rmf_osal_event_delete(event_handle_rcv);
        }
    }

    //RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "VL_MPOD_Link_ExtChnl_Snd_Thread done!\n");
	RDK_LOG(RDK_LOG_DEBUG,"LOG.RDK.POD","%s():VL_MPOD_Link_ExtChnl_Snd_Thread done!\n", __FUNCTION__);

    //RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "\n##### send thread exit\n");
	RDK_LOG(RDK_LOG_DEBUG,"LOG.RDK.POD","%s():##### send thread exit\n", __FUNCTION__);
    //POD_thread_exit;
}

UINT16 POD_Module_GetDataBufferSize(){
    return VL_MPOD_FRAGMENT_SIZE;
}

UINT16 POD_Module_GetExtChBufferSize(){
    return VL_MPOD_FRAGMENT_SIZE;
}

STATUS_T POD_ModuleResetPodInterface ()
{
	RDK_LOG(RDK_LOG_DEBUG,"LOG.RDK.POD","%s():entry and exit\n", __FUNCTION__);
	return STAT_COMPLETE;
}

#ifdef __cplusplus
}
#endif 

#endif // MPOD_SUPPORT
#endif // USE_POD
