/******************************************************************************
* Copyright (C) 2017 Broadcom. The term "Broadcom" refers to Broadcom Limited and/or its subsidiaries.
* Copyright (c) 2011 SeaChange International (SeaChange) and its Licensors. 
* All rights reserved.
*
* This software is the confidential and proprietary information of SeaChange
* ("Confidential Information"). You shall not disclose this source code or 
* such Confidential Information and shall use it only in accordance with the 
* terms of the license agreement you entered into.
*  
* SEACHANGE INERNATIONAL  MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE 
* SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT 
* LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A 
* PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SEACHANGE SHALL NOT BE LIABLE FOR 
* ANY DAMAGES SUFFERED BY LICENSEE NOR SHALL THEY BE RESPONSIBLE AS A RESULT 
* OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
*******************************************************************************/



#ifdef USE_POD
/*-------------------------------------------------------------------
   Include Files
-------------------------------------------------------------------*/
#ifdef USE_NEW_MSPOD_DRIVER
#define DEPRECATED_INTERFACE_SUPPORT
#endif

#include <unistd.h>
#include <string.h>

#include "pod_interface.h"
#include "pod_low_api.h"
#include "link.h"
#include "pod_api.h"

#include "pod_priv.h"
#include "pod_module.h"
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <net/if.h>
#include <net/if_arp.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include "ip_types.h"
#include "utilityMacros.h"
#include "netUtils.h"
#include "rmf_osal_mem.h"
#include "rmf_osal_event.h"
#include "coreUtilityApi.h"
#include "sys_init.h"
#include "hutils_sys.h"
#include "rmf_osal_sync.h"
#include "vlpluginapp_halpodapi.h"
#include "hal_error.h"
#include "hal_module.h"
#include "vlEnv.h"
#include "rmf_osal_util.h"
#if (NEXUS_PLATFORM == 97425) || (NEXUS_PLATFORM == 97435) || (NEXUS_PLATFORM == 97439)
/* MOT7425-7248: 6 Tuner support. */
#include "nexus_pid_channel.h"
#include "nexus_message.h"
#include "nexus_memory.h"
#include "nexus_platform_client.h"
#include "nexus_parser_band.h"
#if (NEXUS_PLATFORM == 97425)
/* For software rate-smoothing. */
#include "nexus_playpump.h"
int bSWRateSmooth = false;
#endif
#endif

extern POD_BASE_t stHalPODBase;
#undef TRUE
#undef FALSE
#define TRUE true
#define FALSE false
#define VL_HAL_POD_OOB_IF_NAME   "podnet0"

#if (NEXUS_PLATFORM == 97425) || (NEXUS_PLATFORM == 97435) || (NEXUS_PLATFORM == 97439)
#define MAX_LTSID 32

static int IpDirectMode = 0;
static uint16_t icnpid;
static unsigned char Ltsid = 40; /* Number greater than MAX_LTSID */
static NEXUS_PidChannelHandle icnPidChannels[MAX_LTSID + 1] = {0};
static NEXUS_MessageHandle icnPidDataSink[MAX_LTSID + 1] = {0};
static void *icnmessageBuffers[MAX_LTSID + 1] = {0};
static INT32 HAL_Setup_Icn_Pid_Filter (unsigned char ltsid);
#endif /* #if (NEXUS_PLATFORM == 97425) || (NEXUS_PLATFORM == 97435) || (NEXUS_PLATFORM == 97439) */

#ifdef MPOD_SUPPORT
void POD_Api_StartInsertTask();
int VL_MPOD_LinkConnSetIpUFlowID(unsigned long flow_id);
int VL_MPOD_LinkConnClearIpUFlowID(unsigned long flow_id);
//int VL_MPOD_Start_Reset();
int VL_MPOD_Start_PCMCIA_Reset();
extern "C" void vlCardManager_PodMemFree(UCHAR * pU);
extern "C" UCHAR *vlCardManager_PodMemAllocate(USHORT size);

#endif // MPOD_SUPPORT

VL_IP_IF_PARAMS vlg_ip_if_params;

INT32 HAL_POD_GetAttributes   (DEVICE_HANDLE_t hTunerHandle, POD_ATTRIBUTES_t *pstPODAttributes);

extern POD_t * POD_GetPODFromHandle (UINT32 hPODHandle);
extern int vlPodErrorDetected();



/*===================================================================
FUNCTION: HAL_TUNER_GetCapabilities

DESCRIPTION:
    Returns the tuner capabilities in the TUNER_CAPABILITIES_t structure.
RETURN VALUE:
   0 - Success;  Negative values - Failure
SIDE EFFECTS:
   None.
===================================================================*/
INT32 HAL_POD_GetCapabilities (POD_CAPABILITIES_t *pstCapabilities)
{
    RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_POD,"%s(): Entry\n", __FUNCTION__);
    //RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_POD, "....................HAL_POD_GetCapabilities() called....................\n");

    // Check whether tuner is initialized
    if (!stHalPODBase.bIsInitialized)
    {
        RDK_LOG(RDK_LOG_ERROR,HAL_MODULE_POD,"%s(): %s: HAL POD not initialized \n",
                 __FUNCTION__,SYS_Error_String(ERROR_HAL_NOT_INITIALIZED));
        return(ERROR_HAL_NOT_INITIALIZED);
    }

    // Check for null parameters
    if (pstCapabilities == NULL)
    {
        RDK_LOG(RDK_LOG_ERROR,HAL_MODULE_POD,"%s(): %s: Null Parameter \n",
                 __FUNCTION__,SYS_Error_String(ERROR_HAL_NULL_PARAMETER));
        return(ERROR_HAL_NULL_PARAMETER);
    }

       memcpy((void *)pstCapabilities, &stHalPODBase.stCapabilities, sizeof(POD_CAPABILITIES_t));

    RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_TUNER,"%s(): Exit\n", __FUNCTION__);
    return(HAL_SUCCESS);
}



/*===================================================================
FUNCTION: HAL_POD_Request

DESCRIPTION:

RETURN VALUE:
   0 - Success;  Negative values - Failure
SIDE EFFECTS:
   None.
===================================================================*/
INT32 HAL_POD_Request( DEVICE_HANDLE_t hPODHandle)
{
    POD_t *pstPOD;

    RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_POD,"%s(): Entry\n", __FUNCTION__);

    RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_POD,"%s(): Requested POD handle %lX\n", __FUNCTION__, hPODHandle);

    // Check for invalid handle and Get the tuner from the handle
    if ((pstPOD = POD_GetPODFromHandle(hPODHandle)) == NULL)
    {
        RDK_LOG(RDK_LOG_ERROR,HAL_MODULE_POD,"%s(): %s: Invalid POD Handle \n",
                 __FUNCTION__,SYS_Error_String(ERROR_HAL_INVALID_HANDLE));
        return(ERROR_HAL_INVALID_HANDLE);
    }

    // Check the state of POD
    if (!pstPOD->bFree)
    {
        RDK_LOG(RDK_LOG_ERROR,HAL_MODULE_POD,"%s(): %s: POD device not available \n",
                 __FUNCTION__,SYS_Error_String(ERROR_HAL_DEVICE_NOT_AVAILABLE));
        return(ERROR_HAL_DEVICE_NOT_AVAILABLE );
    }



    // Mark this POD as not free
    pstPOD->bFree = false;

    RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_POD,"%s(): Exit\n", __FUNCTION__);
    return(HAL_SUCCESS);
}




/*===================================================================
FUNCTION: HAL_MODULE_POD_Release

DESCRIPTION:
    Releases the POD specified by POD handle parameter.
RETURN VALUE:
   0 - Success;  Negative values - Failure
SIDE EFFECTS:
   None.
===================================================================*/
INT32 HAL_POD_Release (DEVICE_HANDLE_t hPODHandle)
{
    POD_t *pstPOD;

    RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_POD,"%s(): Entry\n", __FUNCTION__);

    LOGINFO(HAL_MODULE_POD,"%s(): POD handle to be released %lX\n", __FUNCTION__, hPODHandle);

    // Check for invalid handle and Get the tuner from the handle
    if ((pstPOD = POD_GetPODFromHandle(hPODHandle)) == NULL)
    {
        RDK_LOG(RDK_LOG_ERROR,HAL_MODULE_POD,"%s(): %s: Invalid Tuner Handle \n",
                 __FUNCTION__,SYS_Error_String(ERROR_HAL_INVALID_HANDLE));
        return(ERROR_HAL_INVALID_HANDLE);
    }

    // Check for POD not requested
    if (pstPOD->bFree)
    {
        RDK_LOG(RDK_LOG_ERROR,HAL_MODULE_POD,"%s(): %s: POD is not requested \n",
                 __FUNCTION__,SYS_Error_String(ERROR_HAL_NOT_REQUESTED));
        return(ERROR_HAL_NOT_REQUESTED);
    }



    // Mark this POD as free
    pstPOD->bFree = true;


    RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_POD,"%s(): Exit\n", __FUNCTION__);
    return(HAL_SUCCESS);
}



INT32 HAL_POD_GetInfo( DEVICE_HANDLE_t hPODHandle, POD_INFO_t *pstInfo)
{

    POD_t *pstPOD;

    RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_POD,"%s(): Entry \n", __FUNCTION__);

    // Check for invalid handle and Get the POD from the handle
    if ((pstPOD = POD_GetPODFromHandle(hPODHandle)) == NULL)
    {
        RDK_LOG(RDK_LOG_ERROR,HAL_MODULE_POD,"%s(): %s: Invalid POD Handle \n",
                 __FUNCTION__,SYS_Error_String(ERROR_HAL_INVALID_HANDLE));
        return(ERROR_HAL_INVALID_HANDLE);
    }

        // Check for null parameters
    if (pstInfo == NULL)
    {
        RDK_LOG(RDK_LOG_ERROR,HAL_MODULE_POD,"%s(): %s: Null Parameter \n",
                 __FUNCTION__,SYS_Error_String(ERROR_HAL_NULL_PARAMETER));
        return(ERROR_HAL_NULL_PARAMETER);
    }


    pstInfo->cardMode = pstPOD->cardType;


    RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_POD,"%s(): Exit\n", __FUNCTION__);
    return(HAL_SUCCESS);



}
/****************************************************************
   FUNCTION: HAL_MPVID_SetNotify

   DESCRIPTION:
      Sets the Notify function
   RETURN VALUE:
      0 - Success;  Negative values - Failure
****************************************************************/
INT32 HAL_POD_SetNotify( DEVICE_HANDLE_t hPODHandle, void * pfnNotifyFunc, POD_NOTIFY_TYPE_t val, void* pulData)
//DEVICE_HANDLE_t hMpVidHandle, DEVICE_LOCK_FUNC_t	fnChangeLockStatus, void *puldata )
{
	RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_POD,"%s(): hPODHandle %lu pulData %p\n", __FUNCTION__, hPODHandle, pulData);
	POD_t	*pstPOD;

    	RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_POD,"%s(): Entry \n", __FUNCTION__);

	// Check for invalid handle and Get the POD from the handle
	if ((pstPOD = POD_GetPODFromHandle(hPODHandle)) == NULL)
	{
		RDK_LOG(RDK_LOG_ERROR,HAL_MODULE_POD,"%s(): %s: Invalid POD Handle \n",
			__FUNCTION__,SYS_Error_String(ERROR_HAL_INVALID_HANDLE));
		return(ERROR_HAL_INVALID_HANDLE);
	}
	if ( val == POD_NOTIFY_CARD_DETECT )
	{
		pstPOD->card_detection_cb =  (POD_NOTIFY_FUNC1_t *) pfnNotifyFunc;
		return HAL_SUCCESS;
	}else if ( val == POD_NOTIFY_DATA_AVAILABLE )
	{

		pstPOD->data_available_cb =  (POD_NOTIFY_FUNC3_t *) pfnNotifyFunc;

		return HAL_SUCCESS;

	}else if ( val == POD_NOTIFY_EXTCH_DATA_AVAILABLE )
	{

		pstPOD->extCh_data_available_cb =  (POD_NOTIFY_FUNC4_t *) pfnNotifyFunc;

		return HAL_SUCCESS;

	}else if ( val == POD_NOTIFY_ERROR_CONDITION )
	{

		pstPOD->error_handler_cb = (POD_NOTIFY_FUNC1_t *)pfnNotifyFunc;

		return HAL_SUCCESS;

	}else if ( val == POD_NOTIFY_SEND_POD_POLL )
	{

		pstPOD->send_pod_poll_cb = (POD_NOTIFY_FUNC2_t *)pfnNotifyFunc;

		return HAL_SUCCESS;

	}
	else
	{
		return  ERROR_HAL_INVALID_HANDLE;
	}
}

INT32 HAL_POD_SetAttributes (DEVICE_HANDLE_t hPODHandle, POD_ATTRIBUTES_t *pstPODAttributes)
{

	RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_POD,"%s(): Entry \n", __FUNCTION__);

	// Check for invalid handle and Get the POD from the handle
	if (POD_GetPODFromHandle(hPODHandle) == NULL)
	{
		RDK_LOG(RDK_LOG_ERROR,HAL_MODULE_POD,"%s(): %s: Invalid POD Handle \n",
			__FUNCTION__,SYS_Error_String(ERROR_HAL_INVALID_HANDLE));
		return(ERROR_HAL_INVALID_HANDLE);
	}
	stHalPODBase.hostMode = pstPODAttributes->hostMode;
	return HAL_SUCCESS;

}


INT32 HAL_POD_INTERFACE_RESET(DEVICE_HANDLE_t hPODHandle, UINT32  *pData)
{
#if defined(SPOD_SUPPORT)

	POD_t   *pstPOD;

	RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_POD,"%s(): Entry \n", __FUNCTION__);

	// Check for invalid handle and Get the POD from the handle
	if ((pstPOD = POD_GetPODFromHandle(hPODHandle)) == NULL)
	{
		RDK_LOG(RDK_LOG_ERROR,HAL_MODULE_POD,"%s(): %s: Invalid POD Handle \n",
			__FUNCTION__,SYS_Error_String(ERROR_HAL_INVALID_HANDLE));
		return(ERROR_HAL_INVALID_HANDLE);
	}

	if( POD_ModuleResetPodInterface(pstPOD->hCimax) == vlPOD_FAIL)
                return ERROR_HAL_OPERATION_FAILED;
        else{

                POD_UpdateCardInfo(pstPOD);
                return HAL_SUCCESS;

        }
#endif // SPOD_SUPPORT
       return HAL_SUCCESS;
}

INT32 HAL_POD_RESET_PCMCIA(DEVICE_HANDLE_t hPODHandle, UINT32  *pData)
{
#if defined(SPOD_SUPPORT)
	POD_t   *pstPOD;
	RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_POD,"%s(): Entry \n", __FUNCTION__);

	// Check for invalid handle and Get the POD from the handle
	if ((pstPOD = POD_GetPODFromHandle(hPODHandle)) == NULL)
	{
		RDK_LOG(RDK_LOG_ERROR,HAL_MODULE_POD,"%s(): %s: Invalid POD Handle \n",
			__FUNCTION__,SYS_Error_String(ERROR_HAL_INVALID_HANDLE));
		return(ERROR_HAL_INVALID_HANDLE);
	}

	if( POD_PCMCIA_Reset(&pstPOD->hCimax) == vlPOD_FAIL)
                return ERROR_HAL_OPERATION_FAILED;
        else
                return HAL_SUCCESS;
#endif // SPOD_SUPPORT
       return HAL_SUCCESS;
}


INT32 HAL_POD_TS_Control(DEVICE_HANDLE_t hPODHandle, UINT32  *pData,  BOOLEAN ts_control, UCHAR tuner_id)
{
       sCIMessage_t* psCIMsg = NULL; 
       rmf_osal_event_params_t event_params = {0};
       rmf_osal_event_handle_t eventHandle;
       rmf_Error retOsal = RMF_SUCCESS;

        RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.POD","%s(): hPODHandle %lu *pData %lu\n", __FUNCTION__, hPODHandle, *pData);

        //sCIMessage_t* psCIMsg = (sCIMessage_t*)PODMemAllocate (sizeof(sCIMessage_t));
        rmf_osal_memAllocP(RMF_OSAL_MEM_POD, sizeof(sCIMessage_t), (void**)&psCIMsg);

        if(NULL != psCIMsg)
        {
	    psCIMsg->eMsgId = MSG_CI_TRANS_BYPASS_CTRL;

            psCIMsg->u.sControlMsg.u.bEnableTSBypass = ts_control;
            psCIMsg->u.sControlMsg.tuner_id = tuner_id;


	    event_params.priority = 0xFF;
	    event_params.data = psCIMsg;
	    event_params.data_extension = 0;

	    retOsal = rmf_osal_event_create(RMF_OSAL_EVENT_CATEGORY_POD, psCIMsg->eMsgId, &event_params, &eventHandle);
	    if(retOsal != RMF_SUCCESS)
	    {
		    RDK_LOG(
				    RDK_LOG_DEBUG,
				    "LOG.RDK.JNI",
				    "<%s> Could not create event handle: %x\n",
				    __FUNCTION__, retOsal);
                    rmf_osal_memFreeP(RMF_OSAL_MEM_POD, psCIMsg);
		    return ERROR_HAL_OPERATION_FAILED;
	    }

	    retOsal = rmf_osal_eventqueue_add(sendMsgQ, eventHandle);
	    if(retOsal != RMF_SUCCESS)
	    {
		    RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.FILTER","%s: Cannot create RMF OSAL Event (0x%x) to Queue (0x%x)\n", __FUNCTION__, eventHandle, sendMsgQ);
		    rmf_osal_event_delete(eventHandle);
                    rmf_osal_memFreeP(RMF_OSAL_MEM_POD, psCIMsg);
		    return ERROR_HAL_OPERATION_FAILED;
	    }

//      QueueAddTail (&TheDriverQueue, &sCIMsg);

            //cMsgQWrite(sendMsgQ, (char*)psCIMsg, sizeof(sCIMessage_t), 0, 0);
        }

#if 0
	RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_POD,"%s(): hPODHandle %lu *pData %lu\n", __FUNCTION__, hPODHandle, *pData);

	sCIMessage_t* psCIMsg = (sCIMessage_t*)PODMemAllocate (sizeof(sCIMessage_t));
#if 0
POD_t	*pstPOD;
	RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_POD,"%s(): Entry \n", __FUNCTION__);

	// Check for invalid handle and Get the POD from the handle
	if ((pstPOD = POD_GetPODFromHandle(hPODHandle)) == NULL)
	{
		RDK_LOG(RDK_LOG_ERROR,HAL_MODULE_POD,"%s(): %s: Invalid POD Handle \n",
			__FUNCTION__,SYS_Error_String(ERROR_HAL_INVALID_HANDLE));
		return(ERROR_HAL_INVALID_HANDLE);
	}
	POD_ModuleTSBypassModule(pstPOD->hCimax,ts_control);
#endif
	psCIMsg->eMsgId = MSG_CI_TRANS_BYPASS_CTRL;

	psCIMsg->u.sControlMsg.u.bEnableTSBypass = ts_control;
	psCIMsg->u.sControlMsg.tuner_id = tuner_id;
//	QueueAddTail (&TheDriverQueue, &sCIMsg);

	cMsgQWrite(sendMsgQ, (char*)psCIMsg, sizeof(sCIMessage_t), 0, 0);
#endif
	return HAL_SUCCESS;


/*

	sCIMessage_t sCIMsg;
#if 0
POD_t	*pstPOD;
	RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_POD,"%s(): Entry \n", __FUNCTION__);

	// Check for invalid handle and Get the POD from the handle
	if ((pstPOD = POD_GetPODFromHandle(hPODHandle)) == NULL)
	{
		RDK_LOG(RDK_LOG_ERROR,HAL_MODULE_POD,"%s(): %s: Invalid POD Handle \n",
			__FUNCTION__,SYS_Error_String(ERROR_HAL_INVALID_HANDLE));
		return(ERROR_HAL_INVALID_HANDLE);
	}
	POD_ModuleTSBypassModule(pstPOD->hCimax,ts_control);
#endif
	sCIMsg.eMsgId = MSG_CI_TRANS_BYPASS_CTRL;

	sCIMsg.u.sControlMsg.u.bEnableTSBypass = ts_control;
	sCIMsg.u.sControlMsg.tuner_id = tuner_id;
	QueueAddTail (&TheDriverQueue, &sCIMsg);

	return HAL_SUCCESS;
*/
}

INT32 HAL_POD_OOB_Control (DEVICE_HANDLE_t hPODHandle, UINT32 *pData, UINT32 OOB_State)
{
#if 1
	RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_POD,"%s(): hPODHandle %lu *pData %lu\n", __FUNCTION__, hPODHandle, *pData);

    switch(OOB_State)
    {
        case VL_OOB_COMMAND_OOB_OFF:
        {
          //  PODControl (PODDRV_OOB_OFF);
        }
        break;

        case VL_OOB_COMMAND_OOB_ON:
        {
           // PODControl (PODDRV_OOB_ON);
        }
        break;

        case VL_OOB_COMMAND_INIT_IF:
        {
            VL_IP_IF_PARAMS * pIpParams = (VL_IP_IF_PARAMS*)pData;
            if(pIpParams->socket)
            {
                // check mac address
                if((0 == VL_VALUE_6_FROM_ARRAY(pIpParams->macAddress)))
                {
                    return VL_XCHAN_FLOW_RESULT_DENIED_BAD_MAC_ADDR;
                }

                // bring down i/f
                vlNetRemoveFlags  (pIpParams->socket, VL_HAL_POD_OOB_IF_NAME, (IFF_UP | IFF_RUNNING));
                // set mac address
                vlNetSetMacAddress(pIpParams->socket, VL_HAL_POD_OOB_IF_NAME, pIpParams->macAddress);
                // set ip address
                vlNetSetIpAddress (pIpParams->socket, VL_HAL_POD_OOB_IF_NAME, pIpParams->ipAddress);
#ifdef MPOD_SUPPORT
                //RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_POD, "Assigned flow Id 0x%06X\n", pIpParams->flowid);
                //RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_POD,"%s():Assigned IP addr %s\n", __FUNCTION__,host);
                //    VL_MPOD_LinkConnSetIpUFlowID(pIpParams->flowid);
                //mspod_set_flow_id((uint32_t )pIpParams->flowid);
#endif
                // check subnet mask
                if(0 != VL_VALUE_4_FROM_ARRAY(pIpParams->subnetMask))
                {
                    // set subnet mask
                    vlNetSetSubnetMask (pIpParams->socket, VL_HAL_POD_OOB_IF_NAME, pIpParams->subnetMask);
                }

                // bring up i/f
                vlNetAddFlags  (pIpParams->socket, VL_HAL_POD_OOB_IF_NAME, (IFF_UP | IFF_RUNNING | IFF_NOARP));

                // Jul-29-2009: Moved generic impl. to pfc.


                return VL_XCHAN_FLOW_RESULT_GRANTED;
            }
            else
            {
                return VL_XCHAN_FLOW_RESULT_DENIED_PORT_IN_USE;
            }
        }
        break;

        case VL_OOB_COMMAND_STOP_IF:
        {
            VL_IP_IF_PARAMS * pIpParams = (VL_IP_IF_PARAMS*)pData;
            // bring down i/f
            int sock = socket(AF_INET, SOCK_DGRAM, 0);
            vlNetRemoveFlags(sock, VL_HAL_POD_OOB_IF_NAME, (IFF_UP | IFF_RUNNING));
            //if(sock > 0) close(sock);
            //Coverity fix for DELIA-4567.Close sockets for FD >= 0            
            if(sock >= 0) close(sock);
#ifdef MPOD_SUPPORT
            //VL_MPOD_LinkConnClearIpUFlowID(pIpParams->flowid);
            //mspod_set_flow_id(0);
#endif
            return 0;
        }
        break;

        case VL_OOB_COMMAND_READ_DATA:
        {
            VL_OOB_IP_DATA * pIpData = (VL_OOB_IP_DATA*)pData;
//            struct sockaddr from;
//            socklen_t fromlen;
            if(pIpData->socket)
            {
                /*pIpData->nLength = recvfrom(pIpData->socket, pIpData->pData, pIpData->nCapacity,
                                            0, //MSG_OOB,
                                            &from, &fromlen);*/
                return pIpData->nLength;
            }
            else
            {
                return -1;
            }
        }
        break;

        case VL_OOB_COMMAND_WRITE_DATA:
        {
            VL_OOB_IP_DATA * pIpData = (VL_OOB_IP_DATA*)pData;
            struct sockaddr_in addr;

            /* set up destination address */
            memset(&addr,0,sizeof(addr));
            addr.sin_family=AF_INET;
            addr.sin_addr.s_addr=inet_addr(pIpData->szIpAddress);
            addr.sin_port=htons(pIpData->nPort);
            if(pIpData->socket)
            {
                /*pIpData->nLength = sendto(pIpData->socket, pIpData->pData, pIpData->nCapacity,
                                          0, //MSG_OOB,
                                          &addr, sizeof(addr));*/
                return pIpData->nLength;
            }
            else
            {
                return -1;
            }
        }
        break;

        case VL_OOB_COMMAND_GET_IP_INFO:
        {
            VL_HOST_IP_INFO * pIpInfo = (VL_HOST_IP_INFO*)pData;
            if(NULL != pIpInfo)
            {
		memset(&(*pIpInfo),0,sizeof(*pIpInfo));
               	strcpy(pIpInfo->szIfName, VL_HAL_POD_OOB_IF_NAME);
            }
            // Aug-25-2008: Moved generic implementation to PFC
        }
        break;
    }
#endif
    return HAL_SUCCESS;
}

INT32 HAL_POD_IF_Control (DEVICE_HANDLE_t hPODHandle, UINT32 *pData, UINT32 eCommand)
{

    switch(eCommand)
    {
        case VL_POD_IF_COMMAND_INIT_POD:
        {
            LOGINFO(HAL_MODULE_POD, "%s: Calling MPOD Start Insert...\n",__FUNCTION__);
            POD_Api_StartInsertTask();
        }
        break;
        
        case VL_POD_IF_COMMAND_RESET_PCMCIA:
        {
		    LOGINFO(HAL_MODULE_POD, "%s: Calling cwt_POD_signal_reset(ePOD_RESET_PCMCIA) \n", __FUNCTION__);
            cwt_POD_signal_reset(ePOD_RESET_PCMCIA); // VL_MPOD_Start_Reset();
        }
        break;
        
        case VL_POD_IF_COMMAND_RESET_INTERFACE:
        {
		    LOGINFO(HAL_MODULE_POD, "%s: Calling cwt_POD_signal_reset(ePOD_RESET_FULL) \n", __FUNCTION__);
            cwt_POD_signal_reset(ePOD_RESET_FULL); // VL_MPOD_Start_Reset();
        }
        break;

        default:
          break;
    }
	return HAL_SUCCESS;
}

INT32 HAL_POD_INIT(void)
{
    RDK_LOG(RDK_LOG_INFO,"LOG.RDK.POD", "%s: Calling POD_Init\n",__FUNCTION__);
    
#if (NEXUS_PLATFORM == 97425)
    bSWRateSmooth = vl_env_get_bool(false, "FEATURE.SW_RATE_SMOOTH");
#endif

    return POD_Init();
}

int    CHALPod_init()
{
    RDK_LOG(RDK_LOG_INFO,"LOG.RDK.POD", "%s: Calling HAL_POD_INIT\n",__FUNCTION__);
//SunilS - Moved to runPod main function so as to do SOC-specific initialization at the beginning
//    soc_init_(-1, "Podmanager", 0);
    return HAL_POD_INIT();
}

extern rmf_osal_Mutex vlg_podSendMutex;

extern void vlConfigureCipher(unsigned char ltsid,unsigned short PrgNum,UINT32 *decodePid,UINT32 numpids,UINT32 DesKeyAHi,UINT32 DesKeyALo,UINT32 DesKeyBHi,UINT32 DesKeyBLo,void *ptr);
extern int vlStopConfigureCipher(unsigned char ltsid,unsigned short PrgNum,UINT32 *decodePid,UINT32 numpids);
extern int vlCipherConfigCardStartDecrypt(unsigned char ltsid,unsigned short PrgNum,UINT32 *decodePid,UINT32 numpids,UINT32 DesKeyAHi,UINT32 DesKeyALo,UINT32 DesKeyBHi,UINT32 DesKeyBLo,void *ptr);
INT32  HAL_POD_CONFIG_CIPHER(UCHAR ltsid,USHORT PrgNum,UINT32 *decodePid,UINT32 numpids,UINT32 DesKeyAHi,UINT32 DesKeyALo,UINT32 DesKeyBHi,UINT32 DesKeyBLo,void *pStrPtr)
{
  //  vlConfigureCipher(ltsid,PrgNum,decodePid,numpids,DesKeyAHi,DesKeyALo,DesKeyBHi,DesKeyBLo,pStrPtr);
  
  RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.POD", "%s(): Entered !!! \n",__FUNCTION__);
  if(!vl_env_get_bool(false, "FEATURE.CIPHER.SYNC"))  {
  
    RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.POD", "%s(): Cipher Sync Not supported \n",__FUNCTION__);
    vlConfigureCipher(ltsid,PrgNum,decodePid,numpids,DesKeyAHi,DesKeyALo,DesKeyBHi,DesKeyBLo,pStrPtr);
  }
  else
  {
    RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.POD", "%s(): Cipher Sync supported \n",__FUNCTION__);
    vlCipherConfigCardStartDecrypt(ltsid,PrgNum,decodePid,numpids,DesKeyAHi,DesKeyALo,DesKeyBHi,DesKeyBLo,pStrPtr);
  }
    //int vlCipherConfigCardStartDecrypt(unsigned char ltsid,unsigned short PrgNum,UINT32 *decodePid,UINT32 numpids,UINT32 DesKeyAHi,UINT32 DesKeyALo,UINT32 DesKeyBHi,UINT32 DesKeyBLo,void *ptr)
    return 0;
}
INT32  HAL_POD_STOP_CONFIG_CIPHER(UCHAR ltsid,USHORT PrgNum,UINT32 *decodePid,UINT32 numpids)
{
    RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.POD", "HAL_POD_STOP_CONFIG_CIPHER: calling vlStopConfigureCipher\n");
    vlStopConfigureCipher(ltsid,PrgNum,decodePid,numpids);
    return 0;
}

#if (NEXUS_PLATFORM == 97425) || (NEXUS_PLATFORM == 97435) || (NEXUS_PLATFORM == 97439)
#define OK_DESCRAMBLE 1
#define OK_MMI 2
#define QUERY 3
#define MESSAGE_BUFFER_SIZE 4096
static int allPass = 0;
static NEXUS_PidChannelHandle ecmPidChannels[MAX_LTSID + 1] = {0};
static NEXUS_MessageHandle ecmPidDataSink[MAX_LTSID + 1] = {0};
static void *messageBuffers[MAX_LTSID + 1] = {0};


INT32 HAL_POD_Send_Data (DEVICE_HANDLE_t hPODHandle, POD_BUFFER * stBufferHandle,  POD_CHANNEL_TYPE_T value, UINT8 *pData)
{
    unsigned char *buffptr = (unsigned char *) stBufferHandle->pOrigin;
	RDK_LOG(RDK_LOG_TRACE9, "LOG.RDK.POD", "%s(): hPODHandle %lu pData 0x%08X\n", __FUNCTION__, hPODHandle, pData);

	sCIMessage_t *psCIMsg;
	rmf_osal_event_params_t event_params = {0,};
	rmf_osal_event_handle_t eventHandle;
	rmf_Error retOsal = RMF_SUCCESS;

	rmf_osal_memAllocP(RMF_OSAL_MEM_POD, sizeof(sCIMessage_t), (void**)&psCIMsg);

        if(psCIMsg == NULL)
	{
		RDK_LOG(
				RDK_LOG_ERROR,
				"LOG.RDK.POD",
				"<%s> Could not allocate memory for psCIMsg\n",
				__FUNCTION__);
		return FALSE;
	}

	memset(psCIMsg, 0,sizeof(sCIMessage_t));
	stBufferHandle->pData = stBufferHandle->pOrigin;
	psCIMsg->u.sPodPkt = *stBufferHandle;

    /* In order to support more than 5 tuners, we must start filtering the stream data rather than sending everything to the card. */
    /* here we add the ecmpid to the pid filter so that the card can derive the keys */

    buffptr += 4; /* start of APDU tag */
    bool foundCaPMT = ((buffptr[0] == 0x9F) && (buffptr[1] == 0x80) && (buffptr[2] == 0x32)); /* CA_PMT tag is 9f8032 */
    bool foundIbTuneCnf = ((buffptr[0] == 0x9F) && (buffptr[1] == 0x84) && (buffptr[2] == 0x09)); /* foundIbTuneCnf tag is 9f8409 */
    
    if(foundCaPMT)
    {
        unsigned short progInfoLen, esInfoLen;
        unsigned char ltsid;          
        int followingLen;

        /* handle variable length 'length' field encoding */
        if(buffptr[3] == 0x82)
        {
            followingLen = (((unsigned int)buffptr[4]) << 8) + buffptr[5];
            buffptr += 6;
        }
        else if (buffptr[3] == 0x81)
        {
            followingLen = buffptr[4];    
            buffptr += 5;
        }
        else 
        {
            followingLen = buffptr[3] & 0x7f;    
            buffptr += 4;
        }

        ltsid = buffptr[2];  
        if(ltsid < MAX_LTSID)
        {
            progInfoLen = (((unsigned short)buffptr[8] & 0xf) << 8) | (unsigned short)buffptr[9];

            RDK_LOG(RDK_LOG_ERROR,"LOG.RDK.POD", "%s():Found CA_PMT, length = %d\n", __FUNCTION__, followingLen);
            
            if(ecmPidDataSink[ltsid])
            {
                RDK_LOG(RDK_LOG_DEBUG,"LOG.RDK.POD", "%s():Close Message filter\n", __FUNCTION__);
                NEXUS_Message_Stop(ecmPidDataSink[ltsid]);
                NEXUS_Message_Close(ecmPidDataSink[ltsid]);
                ecmPidDataSink[ltsid] = NULL;
            }
                    
            if(ecmPidChannels[ltsid])
            {
                RDK_LOG(RDK_LOG_DEBUG,"LOG.RDK.POD", "%s():Close pid channel\n", __FUNCTION__);
#if (NEXUS_PLATFORM == 97425)
/* MOT7425-7248: 6 Tuner support. Add software rate-smoothing. Loop back Tuner 0 through Recpump + Playpump */
                if((bSWRateSmooth) && (SW_RS_LOOPBACK_PLAYPUMP_LTSID == ltsid))
                {
                    /* loopback uses playpump, Playpump is opened in qamtunersrc */
            		NEXUS_Playpump_ClosePidChannel(NEXUS_Playpump_RetrieveHandle(SW_RS_LOOPBACK_PLAYPUMP_INDEX), ecmPidChannels[ltsid]);
                }
                else
                {
#endif
                NEXUS_PidChannel_Close(ecmPidChannels[ltsid]);
#if (NEXUS_PLATFORM == 97425)
                }
#endif
                ecmPidChannels[ltsid] = NULL;
            }

            if((buffptr[7] == OK_DESCRAMBLE) || (buffptr[7] == OK_MMI) || (buffptr[7] == QUERY))
            {
                unsigned short ecmpid = 0;
                if(progInfoLen) /* contains a CA descriptor and therefore an ECM PID */
                {
                    ecmpid = (((unsigned short)buffptr[14] & 0x1f) << 8) | (unsigned short)buffptr[15];
                    RDK_LOG(RDK_LOG_DEBUG,"LOG.RDK.POD", "%s():Found OK_DESCRAMBLE/OK_MMI/QUERY Program level ecmpid is 0x%04x ltsid is %d prog info len is %d\n", __FUNCTION__, ecmpid, ltsid, progInfoLen);
                }
                else
                {
                    /* search for ECM PID at the ES level */
                    
                    buffptr += 10; /* advance to ES section */
                    followingLen -= 10;

                    while (followingLen >= (5 + 7)) /* offset to es_info + ca_pmt_cmd_id + offset to ecm_pid in ca_descriptor */
                    {
                        esInfoLen = (((unsigned short)buffptr[3] & 0xf) << 8) | (unsigned short)buffptr[4];
                        if(esInfoLen > 1) /* means there is at least 1 CA Descriptor */
                        {
                            /* only need the ecmpid from the first descriptor */
                            ecmpid = (((unsigned short)buffptr[10] & 0x1f) << 8) | (unsigned short)buffptr[11];
                            RDK_LOG(RDK_LOG_DEBUG,"LOG.RDK.POD", "%s():Found OK_DESCRAMBLE/OK_MMI/QUERY ES level ecmpid is 0x%04x ltsid is %d prog info len is %d\n", __FUNCTION__, ecmpid, ltsid, progInfoLen);
                            break;
                        }

                        buffptr += (5 + esInfoLen);
                        followingLen -= (5 + esInfoLen);
                    }
                }
                    
                    if(ecmpid)
                    {
                    	NEXUS_ParserBand parserBand;
                        NEXUS_MessageSettings settings;
                        NEXUS_MessageStartSettings startSettings;

                        RDK_LOG(RDK_LOG_DEBUG,"LOG.RDK.POD", "%s():Open Message filter and pid channel\n", __FUNCTION__);
                        parserBand = (NEXUS_ParserBand) (NEXUS_ParserBand_e0 + ltsid); /* fixed mapping on 74xx chips */

#if (NEXUS_PLATFORM == 97425)
/* MOT7425-7248: 6 Tuner support. Add software rate-smoothing. Loop back Tuner 0 through Recpump + Playpump */
                    if((bSWRateSmooth) && (SW_RS_LOOPBACK_PLAYPUMP_LTSID == ltsid))
                    {
                        NEXUS_PlaypumpOpenPidChannelSettings playpumpPidChanSettings;
                        NEXUS_Playpump_GetDefaultOpenPidChannelSettings(&playpumpPidChanSettings);		
                        playpumpPidChanSettings.pidType = NEXUS_PidType_eOther;
                        /* loopback uses playpump */
                        ecmPidChannels[ltsid] = NEXUS_Playpump_OpenPidChannel(NEXUS_Playpump_RetrieveHandle(SW_RS_LOOPBACK_PLAYPUMP_INDEX), ecmpid, &playpumpPidChanSettings);
                    }
                    else
                    {
#endif    
                        ecmPidChannels[ltsid] = NEXUS_PidChannel_Open(parserBand, ecmpid, NULL);
#if (NEXUS_PLATFORM == 97425)
                    }
#endif
                        if(ecmPidChannels[ltsid])
                        {
                            if(!messageBuffers[ltsid])
                            {
                                NEXUS_MemoryAllocationSettings defaultAllocationSettings;

                                NEXUS_ClientConfiguration platformConfig;
                                NEXUS_Platform_GetClientConfiguration(&platformConfig);
                                NEXUS_Memory_GetDefaultAllocationSettings(&defaultAllocationSettings);
                                /* MOT7425-3404 - Use heap 1 for message buffers */
                                defaultAllocationSettings.heap = platformConfig.heap[1];
                                defaultAllocationSettings.alignment = 1024; 
                                if(NEXUS_Memory_Allocate(MESSAGE_BUFFER_SIZE, &defaultAllocationSettings, &messageBuffers[ltsid]))
                                {
                                    RDK_LOG(RDK_LOG_ERROR,"LOG.RDK.POD", "%s():NEXUS_Memory_Allocate failed\n", __FUNCTION__);
                                }    
                            }

                            if(messageBuffers[ltsid])
                            {
                                NEXUS_Message_GetDefaultSettings(&settings);
                                settings.bufferSize = 0; /* allocate our own buffers to avoid fragmentation */
                                ecmPidDataSink[ltsid] = NEXUS_Message_Open(&settings);
                                if(ecmPidDataSink[ltsid])
                                {
                                    NEXUS_Message_GetDefaultStartSettings(ecmPidDataSink[ltsid], &startSettings);
                                    startSettings.pidChannel = ecmPidChannels[ltsid];
                                    startSettings.format = NEXUS_MessageFormat_ePsi;
                                    startSettings.bufferSize =  MESSAGE_BUFFER_SIZE;
                                    startSettings.buffer = messageBuffers[ltsid];
                                    if(NEXUS_Message_Start(ecmPidDataSink[ltsid], &startSettings))
                                    {
                                        RDK_LOG(RDK_LOG_ERROR,"LOG.RDK.POD", "%s():NEXUS_Message_Start failed\n", __FUNCTION__);
                                    }
                                }
                                else
                                {
                                    RDK_LOG(RDK_LOG_ERROR,"LOG.RDK.POD", "%s():NEXUS_Message_Open failed\n", __FUNCTION__);
                                }
                            }
                        }
                        else
                        {
                            RDK_LOG(RDK_LOG_ERROR,"LOG.RDK.POD", "%s():NEXUS_PidChannel_Open failed\n", __FUNCTION__);
                        }
                    }
                else
                {
                    RDK_LOG(RDK_LOG_ERROR,"LOG.RDK.POD", "%s():Unable to find ecmpid\n", __FUNCTION__);
		    const char *ptr = rmf_osal_envGet("PARSER.BANDSETTING.ALLPASS");
		    RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "%s(): ptr is %s\n", __FUNCTION__,ptr);
	
		    if (NULL != ptr)
		    {
			allPass = (strcasecmp(ptr, "TRUE") == 0);
			RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "%s(): allPass is %d\n", __FUNCTION__,allPass);
		    }
		    
		    if(allPass)
		    {
		       if(ltsid <= MAX_LTSID)
		       {
			  NEXUS_ParserBand parserBand = (NEXUS_ParserBand) (NEXUS_ParserBand_e0 + ltsid); /* fixed mapping on 74xx chips */
			  NEXUS_ParserBandSettings parserBandSettings;

			  RDK_LOG(RDK_LOG_ERROR,"LOG.RDK.POD", "%s(): WARNING Enabling allpass on parser band %d for card firmware download\n", __FUNCTION__, ltsid);

			  NEXUS_ParserBand_GetSettings(parserBand, &parserBandSettings);
			  parserBandSettings.allPass = true;
			  NEXUS_ParserBand_SetSettings(parserBand, &parserBandSettings);
		      }
		    }
                }
            }
	    const char *ipduptr = rmf_osal_envGet("USE_IPDIRECT_UNICAST");
 	    RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "%s(): ipduptr is %s\n", __FUNCTION__,ipduptr);

            if (NULL != ipduptr)
 	    {
	         IpDirectMode = (strcasecmp(ipduptr, "TRUE") == 0);
	         RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "%s(): IpDirectMode is %d\n", __FUNCTION__,IpDirectMode);
	    }
            if (access( "/opt/persistent/ipduEnable", F_OK ) != -1 )
            {
                IpDirectMode = TRUE;
	        RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "%s(): IpDirectMode is %d via ipduEnable file\n", __FUNCTION__,IpDirectMode);
            }
 	    if (IpDirectMode)
	    {
                 RDK_LOG(RDK_LOG_ERROR,"LOG.RDK.POD", "%s():Calling HAL_Setup_Icn_Pid_Filter\n", __FUNCTION__);
	         Ltsid = ltsid;
	         HAL_Setup_Icn_Pid_Filter(Ltsid);
            }
        }
        else
        {
            RDK_LOG(RDK_LOG_ERROR,"LOG.RDK.POD", "%s():LTSID exceeds MAX_LTSID\n", __FUNCTION__);
        }
    } 
    else if(foundIbTuneCnf)
    {
        /* Assume the IB tune is for firmware download from the card. We need to switch the associated parser band to all pass
           otherwise the CableCARD will not receive the PID that is carrying the new firmware. */
        unsigned char ltsid = buffptr[4];

#if (NEXUS_PLATFORM == 97425)
        /* MOT7425-7248: 6 Tuner support. Add software rate-smoothing. Loop back Tuner 0 through Recpump + Playpump */
        if((!bSWRateSmooth) || (SW_RS_LOOPBACK_PLAYPUMP_LTSID != ltsid))
        {
#endif
        if(ltsid <= MAX_LTSID)
        {
            NEXUS_ParserBand parserBand = (NEXUS_ParserBand) (NEXUS_ParserBand_e0 + ltsid); /* fixed mapping on 74xx chips */
            NEXUS_ParserBandSettings parserBandSettings;

            RDK_LOG(RDK_LOG_ERROR,"LOG.RDK.POD", "%s(): WARNING Enabling allpass on parser band %d for card firmware download\n", __FUNCTION__, ltsid);

            NEXUS_ParserBand_GetSettings(parserBand, &parserBandSettings);
            parserBandSettings.allPass = true;
            NEXUS_ParserBand_SetSettings(parserBand, &parserBandSettings);
        }
#if (NEXUS_PLATFORM == 97425)
        }
#endif
    }

	if(value == POD_DATA_CHANNEL_DATA)
	{
		int i;
		//            int dataLength;
		char timestr[100];
		time_t t;
		struct tm *tmp;

		t = time(NULL);
		tmp = localtime(&t);

		RDK_LOG(RDK_LOG_TRACE1, "LOG.RDK.POD", "----------------------------------------------------------------------\n");
		//LOGDEBUG(HAL_MODULE_POD,"%s():----------------------------------------------------------------------\n", __FUNCTION__);

		memset(timestr, 0, sizeof(timestr));
		if (strftime(timestr, sizeof(timestr), "%s", tmp) == 0) {
			fprintf(stderr, "HAL_POD_Send_Data_to_CARD: strftime returned 0");
		}
		RDK_LOG(RDK_LOG_TRACE1, "LOG.RDK.POD", "HAL_POD_Send_Data_to_CARD: dataLength = %d, time = %s\n", psCIMsg->u.sPodPkt.lSize, timestr);
		//LOGDEBUG(HAL_MODULE_POD,"%s():HAL_POD_Send_Data_to_CARD: dataLength = %d, time = %s\n", __FUNCTION__,sCIMsg.u.sPodPkt.lSize, timestr);

		if(psCIMsg->u.sPodPkt.lSize < 0x400) // limit super large dumps
		{
			//vlMpeosDumpBuffer(MPE_LOG_TRACE1, "LOG.RDK.POD", sCIMsg.u.sPodPkt.pData,sCIMsg.u.sPodPkt.lSize);
			//LOGDEBUG(HAL_MODULE_POD,"%s():\n", __FUNCTION__);
		}
		RDK_LOG(RDK_LOG_TRACE1, "LOG.RDK.POD", "----------------------------------------------------------------------\n");
		//LOGDEBUG(HAL_MODULE_POD,"%s():----------------------------------------------------------------------\n", __FUNCTION__);

		psCIMsg->eMsgId = MSG_CI_SEND_TPDU;

		event_params.priority = 0xFF;
		event_params.data = psCIMsg;
		event_params.data_extension = 0;

		// Nov-12-2008: Update: Changed wait time for writing to command queue
		//cMsgQWrite(sendMsgQ, (char*)&sCIMsg, sizeof(sCIMessage_t), 100, 0);
		retOsal = rmf_osal_event_create(RMF_OSAL_EVENT_CATEGORY_POD, psCIMsg->eMsgId, &event_params, &eventHandle);
		if(retOsal != RMF_SUCCESS)
		{
			RDK_LOG(
					RDK_LOG_ERROR,
					"LOG.RDK.POD",
					"<%s> Could not create event handle: %x\n",
					__FUNCTION__, retOsal);
			rmf_osal_memFreeP(RMF_OSAL_MEM_POD, psCIMsg);
			return FALSE;
		}

		retOsal = rmf_osal_eventqueue_addTimed(sendMsgQ, eventHandle, 200000);
		if(retOsal != RMF_SUCCESS)
		{
			RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD","%s: Cannot create RMF OSAL Event (0x%x) to Queue (0x%x)\n", __FUNCTION__, eventHandle, sendMsgQ);
			vlCardManager_PodMemFree(psCIMsg->u.sPodPkt.pData);
			rmf_osal_event_delete(eventHandle);
			rmf_osal_memFreeP(RMF_OSAL_MEM_POD, psCIMsg);
			return FALSE;
		}
	}
	else if(value == POD_EXT_CHANNEL_DATA)
	{
		event_params.priority = 0xFF;
		event_params.data = psCIMsg;
		event_params.data_extension = 0;

		psCIMsg->eMsgId = MSG_CI_EXTENDED_WRITE;
		//cMsgQWrite(ext_channel_Queue, (char*)&sCIMsg, sizeof(sCIMessage_t), 0, 0);
		retOsal = rmf_osal_event_create(RMF_OSAL_EVENT_CATEGORY_POD, psCIMsg->eMsgId, &event_params, &eventHandle);
		if(retOsal != RMF_SUCCESS)
		{
			RDK_LOG(
					RDK_LOG_ERROR,
					"LOG.RDK.POD",
					"<%s> Could not create event handle: %x\n",
					__FUNCTION__, retOsal);
			rmf_osal_memFreeP(RMF_OSAL_MEM_POD, psCIMsg);
			return FALSE;
		}

		retOsal = rmf_osal_eventqueue_addTimed(ext_channel_Queue, eventHandle, 100000);

		if(retOsal != RMF_SUCCESS)
		{
			RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD","%s: Cannot create RMF OSAL Event (0x%x) to Queue (0x%x)\n", __FUNCTION__, eventHandle, sendMsgQ);
			vlCardManager_PodMemFree(psCIMsg->u.sPodPkt.pData);
			rmf_osal_event_delete(eventHandle);
			rmf_osal_memFreeP(RMF_OSAL_MEM_POD, psCIMsg);
			return FALSE;
		}
	}

	return TRUE;
}

#else

INT32 HAL_POD_Send_Data (DEVICE_HANDLE_t hPODHandle, POD_BUFFER * stBufferHandle,  POD_CHANNEL_TYPE_T value, UINT8 *pData)
{
	RDK_LOG(RDK_LOG_TRACE9, "LOG.RDK.POD", "%s(): hPODHandle %lu pData 0x%08X\n", __FUNCTION__, hPODHandle, pData);

	sCIMessage_t *psCIMsg;
	rmf_osal_event_params_t event_params = {0,};
	rmf_osal_event_handle_t eventHandle;
	rmf_Error retOsal = RMF_SUCCESS;

	rmf_osal_memAllocP(RMF_OSAL_MEM_POD, sizeof(sCIMessage_t), (void**)&psCIMsg);

        if(psCIMsg == NULL)
	{
		RDK_LOG(
				RDK_LOG_ERROR,
				"LOG.RDK.POD",
				"<%s> Could not allocate memory for psCIMsg\n",
				__FUNCTION__);
		return FALSE;
	}

	memset(psCIMsg, 0,sizeof(sCIMessage_t));
	stBufferHandle->pData = stBufferHandle->pOrigin;
	psCIMsg->u.sPodPkt = *stBufferHandle;

	if(value == POD_DATA_CHANNEL_DATA)
	{
		int i;
		//            int dataLength;
		char timestr[100];
		time_t t;
		struct tm *tmp;

		t = time(NULL);
		tmp = localtime(&t);

		RDK_LOG(RDK_LOG_TRACE1, "LOG.RDK.POD", "----------------------------------------------------------------------\n");
		//LOGDEBUG(HAL_MODULE_POD,"%s():----------------------------------------------------------------------\n", __FUNCTION__);

		memset(timestr, 0, sizeof(timestr));
		if (strftime(timestr, sizeof(timestr), "%s", tmp) == 0) {
			fprintf(stderr, "HAL_POD_Send_Data_to_CARD: strftime returned 0");
		}
		RDK_LOG(RDK_LOG_TRACE1, "LOG.RDK.POD", "HAL_POD_Send_Data_to_CARD: dataLength = %d, time = %s\n", psCIMsg->u.sPodPkt.lSize, timestr);
		//LOGDEBUG(HAL_MODULE_POD,"%s():HAL_POD_Send_Data_to_CARD: dataLength = %d, time = %s\n", __FUNCTION__,sCIMsg.u.sPodPkt.lSize, timestr);

		if(psCIMsg->u.sPodPkt.lSize < 0x400) // limit super large dumps
		{
			//vlMpeosDumpBuffer(MPE_LOG_TRACE1, "LOG.RDK.POD", sCIMsg.u.sPodPkt.pData,sCIMsg.u.sPodPkt.lSize);
			//LOGDEBUG(HAL_MODULE_POD,"%s():\n", __FUNCTION__);
		}
		RDK_LOG(RDK_LOG_TRACE1, "LOG.RDK.POD", "----------------------------------------------------------------------\n");
		//LOGDEBUG(HAL_MODULE_POD,"%s():----------------------------------------------------------------------\n", __FUNCTION__);

		psCIMsg->eMsgId = MSG_CI_SEND_TPDU;

		event_params.priority = 0xFF;
		event_params.data = psCIMsg;
		event_params.data_extension = 0;

		// Nov-12-2008: Update: Changed wait time for writing to command queue
		//cMsgQWrite(sendMsgQ, (char*)&sCIMsg, sizeof(sCIMessage_t), 100, 0);
		retOsal = rmf_osal_event_create(RMF_OSAL_EVENT_CATEGORY_POD, psCIMsg->eMsgId, &event_params, &eventHandle);
		if(retOsal != RMF_SUCCESS)
		{
			RDK_LOG(
					RDK_LOG_ERROR,
					"LOG.RDK.POD",
					"<%s> Could not create event handle: %x\n",
					__FUNCTION__, retOsal);
			rmf_osal_memFreeP(RMF_OSAL_MEM_POD, psCIMsg);
			return FALSE;
		}

		retOsal = rmf_osal_eventqueue_addTimed(sendMsgQ, eventHandle, 200000);
		if(retOsal != RMF_SUCCESS)
		{
			RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD","%s: Cannot create RMF OSAL Event (0x%x) to Queue (0x%x)\n", __FUNCTION__, eventHandle, sendMsgQ);
			vlCardManager_PodMemFree(psCIMsg->u.sPodPkt.pData);
			rmf_osal_event_delete(eventHandle);
			rmf_osal_memFreeP(RMF_OSAL_MEM_POD, psCIMsg);
			return FALSE;
		}
	}
	else if(value == POD_EXT_CHANNEL_DATA)
	{
		event_params.priority = 0xFF;
		event_params.data = psCIMsg;
		event_params.data_extension = 0;

		psCIMsg->eMsgId = MSG_CI_EXTENDED_WRITE;
		//cMsgQWrite(ext_channel_Queue, (char*)&sCIMsg, sizeof(sCIMessage_t), 0, 0);
		retOsal = rmf_osal_event_create(RMF_OSAL_EVENT_CATEGORY_POD, psCIMsg->eMsgId, &event_params, &eventHandle);
		if(retOsal != RMF_SUCCESS)
		{
			RDK_LOG(
					RDK_LOG_ERROR,
					"LOG.RDK.POD",
					"<%s> Could not create event handle: %x\n",
					__FUNCTION__, retOsal);
			rmf_osal_memFreeP(RMF_OSAL_MEM_POD, psCIMsg);
			return FALSE;
		}

		retOsal = rmf_osal_eventqueue_addTimed(ext_channel_Queue, eventHandle, 100000);

		if(retOsal != RMF_SUCCESS)
		{
			RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD","%s: Cannot create RMF OSAL Event (0x%x) to Queue (0x%x)\n", __FUNCTION__, eventHandle, sendMsgQ);
			vlCardManager_PodMemFree(psCIMsg->u.sPodPkt.pData);
			rmf_osal_event_delete(eventHandle);
			rmf_osal_memFreeP(RMF_OSAL_MEM_POD, psCIMsg);
			return FALSE;
		}
	}

	return TRUE;
}

#endif

INT32 HAL_POD_DecodeFromPOD(DEVICE_HANDLE_t hPODHandle,unsigned long videoPid, UINT8 *pData)
{
	RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_POD,"%s(): hPODHandle %lu videoPid %lu *pData %u\n", __FUNCTION__, hPODHandle, videoPid, *pData);
	return TRUE;
}


#endif // USE_POD

POD_t * POD_GetPODFromHandle (UINT32 hPODHandle)
{
    return &stHalPODBase.astPOD[0];
}

#if (NEXUS_PLATFORM == 97425) || (NEXUS_PLATFORM == 97435) || (NEXUS_PLATFORM == 97439)
INT32 HAL_Save_Icn_Pid (UINT16 *IcnPid)
{
    icnpid = *IcnPid;
    RDK_LOG(RDK_LOG_DEBUG,"LOG.RDK.POD", "%s(): ICN PID = %d\n", __FUNCTION__, icnpid);
    if (Ltsid != 40) /* If already tuned to a valid channel, re-set the ICN PID filter */
    {
        RDK_LOG(RDK_LOG_ERROR,"LOG.RDK.POD", "%s():Calling HAL_Setup_Icn_Pid_Filter for Ltsid = %d\n", __FUNCTION__, Ltsid);
	HAL_Setup_Icn_Pid_Filter(Ltsid);
    }
    return TRUE;
}

INT32 HAL_Setup_Icn_Pid_Filter (unsigned char ltsid)
{
    RDK_LOG(RDK_LOG_ERROR,"LOG.RDK.POD", "%s() ltsid = %d\n", __FUNCTION__, ltsid);
    if(icnPidDataSink[ltsid])
    {
        RDK_LOG(RDK_LOG_DEBUG,"LOG.RDK.POD", "%s():Close Message filter\n", __FUNCTION__);
        NEXUS_Message_Stop(icnPidDataSink[ltsid]);
        NEXUS_Message_Close(icnPidDataSink[ltsid]);
        icnPidDataSink[ltsid] = NULL;
    }

    if(icnPidChannels[ltsid])
    {
        RDK_LOG(RDK_LOG_DEBUG,"LOG.RDK.POD", "%s():Close pid channel\n", __FUNCTION__);
#if (NEXUS_PLATFORM == 97425)
/* MOT7425-7248: 6 Tuner support. Add software rate-smoothing. Loop back Tuner 0 through Recpump + Playpump */
        if((bSWRateSmooth) && (SW_RS_LOOPBACK_PLAYPUMP_LTSID == ltsid))
        {
            /* loopback uses playpump, Playpump is opened in qamtunersrc */
            NEXUS_Playpump_ClosePidChannel(NEXUS_Playpump_RetrieveHandle(SW_RS_LOOPBACK_PLAYPUMP_INDEX), icnPidChannels[ltsid]);
        }
        else
        {
#endif
            NEXUS_PidChannel_Close(icnPidChannels[ltsid]);
#if (NEXUS_PLATFORM == 97425)
        }
#endif
            icnPidChannels[ltsid] = NULL;
    }
    if(icnpid)
    {
	NEXUS_ParserBand icnparserBand;
        NEXUS_MessageSettings icnsettings;
        NEXUS_MessageStartSettings icnstartSettings;

        RDK_LOG(RDK_LOG_DEBUG,"LOG.RDK.POD", "%s():Open Message filter and pid channel for ICN PID\n", __FUNCTION__);
        icnparserBand = (NEXUS_ParserBand) (NEXUS_ParserBand_e0 + ltsid); /* fixed mapping on 74xx chips */

#if (NEXUS_PLATFORM == 97425)
/* MOT7425-7248: 6 Tuner support. Add software rate-smoothing. Loop back Tuner 0 through Recpump + Playpump */
        if((bSWRateSmooth) && (SW_RS_LOOPBACK_PLAYPUMP_LTSID == ltsid))
        {
            NEXUS_PlaypumpOpenPidChannelSettings icnplaypumpPidChanSettings;
            NEXUS_Playpump_GetDefaultOpenPidChannelSettings(&icnplaypumpPidChanSettings);		
            icnplaypumpPidChanSettings.pidType = NEXUS_PidType_eOther;
            /* loopback uses playpump */
            icnPidChannels[ltsid] = NEXUS_Playpump_OpenPidChannel(NEXUS_Playpump_RetrieveHandle(SW_RS_LOOPBACK_PLAYPUMP_INDEX), icnpid, &icnplaypumpPidChanSettings);
        }
        else
        {
#endif
	    icnPidChannels[ltsid] = NEXUS_PidChannel_Open(icnparserBand, icnpid, NULL);
#if (NEXUS_PLATFORM == 97425)
        }
#endif
        if(icnPidChannels[ltsid])
        {
            if(!icnmessageBuffers[ltsid])
            {
                NEXUS_MemoryAllocationSettings icndefaultAllocationSettings;
                NEXUS_ClientConfiguration icnplatformConfig;
                NEXUS_Platform_GetClientConfiguration(&icnplatformConfig);
                NEXUS_Memory_GetDefaultAllocationSettings(&icndefaultAllocationSettings);
                /* MOT7425-3404 - Use heap 1 for message buffers */
                icndefaultAllocationSettings.heap = icnplatformConfig.heap[1];
                icndefaultAllocationSettings.alignment = 1024;
                if(NEXUS_Memory_Allocate(MESSAGE_BUFFER_SIZE, &icndefaultAllocationSettings, &icnmessageBuffers[ltsid]))
                {
                    RDK_LOG(RDK_LOG_ERROR,"LOG.RDK.POD", "%s():NEXUS_Memory_Allocate failed for ICN PID\n", __FUNCTION__);
                    return FALSE;
                }
            }

            if(icnmessageBuffers[ltsid])
            {
                NEXUS_Message_GetDefaultSettings(&icnsettings);
                icnsettings.bufferSize = 0; /* allocate our own buffers to avoid fragmentation */
                icnPidDataSink[ltsid] = NEXUS_Message_Open(&icnsettings);
                if(icnPidDataSink[ltsid])
                {
                    NEXUS_Message_GetDefaultStartSettings(icnPidDataSink[ltsid], &icnstartSettings);
                    icnstartSettings.pidChannel = icnPidChannels[ltsid];
                    icnstartSettings.format = NEXUS_MessageFormat_ePsi;
                    icnstartSettings.bufferSize =  MESSAGE_BUFFER_SIZE;
                    icnstartSettings.buffer = icnmessageBuffers[ltsid];
                    if(NEXUS_Message_Start(icnPidDataSink[ltsid], &icnstartSettings))
                    {
                        RDK_LOG(RDK_LOG_ERROR,"LOG.RDK.POD", "%s():NEXUS_Message_Start failed for ICN PID\n", __FUNCTION__);
                        return FALSE;
                    }
                }
                else
                {
                    RDK_LOG(RDK_LOG_ERROR,"LOG.RDK.POD", "%s():NEXUS_Message_Open failed for ICN PID\n", __FUNCTION__);
                    return FALSE;
                }
            }
        }
        else
        {
            RDK_LOG(RDK_LOG_ERROR,"LOG.RDK.POD", "%s():NEXUS_PidChannel_Open failedfor ICN PID\n", __FUNCTION__);
            return FALSE;
        }
    }
    return TRUE;
}
#else
INT32 HAL_Save_Icn_Pid (UINT16 *IcnPid)
{
    RDK_LOG(RDK_LOG_ERROR,"LOG.RDK.POD", "%s():NOT SUPPORTED\n", __FUNCTION__);
    return FALSE;
}
#endif /* #if (NEXUS_PLATFORM == 97425) || (NEXUS_PLATFORM == 97435) || (NEXUS_PLATFORM == 97439)*/
