/******************************************************************************
* Copyright (c) 2011 SeaChange International (SeaChange) and its Licensors. 
* All rights reserved.
*
* This software is the confidential and proprietary information of SeaChange
* ("Confidential Information"). You shall not disclose this source code or 
* such Confidential Information and shall use it only in accordance with the 
* terms of the license agreement you entered into.
*  
* SEACHANGE INERNATIONAL  MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE 
* SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT 
* LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A 
* PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SEACHANGE SHALL NOT BE LIABLE FOR 
* ANY DAMAGES SUFFERED BY LICENSEE NOR SHALL THEY BE RESPONSIBLE AS A RESULT 
* OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
*******************************************************************************/


#ifndef __HAL_PRIO_H__
#define __HAL_PRIO_H__

#include "hal_thread.h"


#if (defined MR05_P1 | defined MR06_P0)

/* tuner_init.c:TUNER_Init */
#define TUNER_QAM_ACQUIRE_NAME                "tuner_qam_qcquire"
#define TUNER_QAM_ACQUIRE_POLICY            SCHED_FIFO
#define TUNER_QAM_ACQUIRE_PRIO                89
#define TUNER_QAM_ACQUIRE_STACK             HAL_THREAD_DEFAULT_STACKSIZE
#define TUNER_QAM_ACQUIRE_DETACH            HAL_THREAD_DEFAULT_DETACHSTATE

/* hid_init.c:HID_Init */
#define HID_ACTIVITY_NAME                   "hid_activity"
#define HID_ACTIVITY_POLICY                 HAL_THREAD_DEFAULT_POLICY
#define HID_ACTIVITY_PRIO                   HAL_THREAD_DEFAULT_PRIORITY
#define HID_ACTIVITY_STACK                  HAL_THREAD_DEFAULT_STACKSIZE
#define HID_ACTIVITY_DETACH                 HAL_THREAD_DEFAULT_DETACHSTATE

/* mpaud_api.c:HAL_MPAUD_Start */
#define MPAUD_DECODE_LOCK_DETECT_NAME       "mpaud_lock_detect"
#define MPAUD_DECODE_LOCK_DETECT_POLICY     SCHED_FIFO
#define MPAUD_DECODE_LOCK_DETECT_PRIO       88
#define MPAUD_DECODE_LOCK_DETECT_STACK      HAL_THREAD_DEFAULT_STACKSIZE
#define MPAUD_DECODE_LOCK_DETECT_DETACH     HAL_THREAD_DEFAULT_DETACHSTATE

/* mpaud_interrupt.c:MPAUD_LaunchIntThread */
#define MPAUD_ISR_NAME                      "mpaud_isr"
#define MPAUD_ISR_POLICY                    SCHED_FIFO
#define MPAUD_ISR_PRIO                      90
#define MPAUD_ISR_STACK                     HAL_THREAD_DEFAULT_STACKSIZE
#define MPAUD_ISR_DETACH                    HAL_THREAD_DEFAULT_DETACHSTATE

/* fpd_init.c:FPD_Init */
#define FPD_TIME_DISP_NAME                  "fpd_timedisplay"
#define FPD_TIME_DISP_POLICY                HAL_THREAD_DEFAULT_POLICY
#define FPD_TIME_DISP_PRIO                  HAL_THREAD_DEFAULT_PRIORITY
#define FPD_TIME_DISP_STACK                 HAL_THREAD_DEFAULT_STACKSIZE
#define FPD_TIME_DISP_DETACH                HAL_THREAD_DEFAULT_DETACHSTATE

/* mpvid_cc_api.c:MPVID_CCInit */
#define MPVID_CC_NOTIFY_NAME               "mpvid_ccnotify"
#define MPVID_CC_NOTIFY_POLICY              HAL_THREAD_DEFAULT_POLICY
#define MPVID_CC_NOTIFY_PRIO                HAL_THREAD_DEFAULT_PRIORITY
#define MPVID_CC_NOTIFY_STACK               HAL_THREAD_DEFAULT_STACKSIZE
#define MPVID_CC_NOTIFY_DETACH              HAL_THREAD_DEFAULT_DETACHSTATE

/* mpvid_interrupt.c:mpvid_start_thread */
#define MPVID_DECODE_STATUS_NAME            "mpvid_decoder_status"
#define MPVID_DECODE_STATUS_POLICY          SCHED_FIFO
#define MPVID_DECODE_STATUS_PRIO            87
#define MPVID_DECODE_STATUS_STACK           HAL_THREAD_DEFAULT_STACKSIZE
#define MPVID_DECODE_STATUS_DETACH          HAL_THREAD_DEFAULT_DETACHSTATE

/* VBI_HW.c.c:VBI_HW_open */
#define VBI_SLICER_NAME                        "vbi_slicer"
#define VBI_SLICER_POLICY                    SCHED_FIFO
#define VBI_SLICER_PRIO                        98
#define VBI_SLICER_STACK                    HAL_THREAD_DEFAULT_STACKSIZE
#define VBI_SLICER_DETACH                   HAL_THREAD_DEFAULT_DETACHSTATE

/* irb_init.c:IRB_Init */
#define IRB_ACTIVITY_NAME                  "irb_activity"
#define IRB_ACTIVITY_POLICY                SCHED_RR
#define IRB_ACTIVITY_PRIO                  91
#define IRB_ACTIVITY_STACK                 HAL_THREAD_DEFAULT_STACKSIZE
#define IRB_ACTIVITY_DETACH                HAL_THREAD_DEFAULT_DETACHSTATE

/* disp_init.c:DISP_Init */
#define DISP_PASSTHRU_NAME               "disp_passthru"
#define DISP_PASSTHRU_POLICY              HAL_THREAD_DEFAULT_POLICY
#define DISP_PASSTHRU_PRIO                HAL_THREAD_DEFAULT_PRIORITY
#define DISP_PASSTHRU_STACK               HAL_THREAD_DEFAULT_STACKSIZE
#define DISP_PASSTHRU_DETACH              HAL_THREAD_DEFAULT_DETACHSTATE


/*__________________________________________________________________________*/
#else   /* default values */
/*__________________________________________________________________________*/

/* tuner_init.c:TUNER_Init */
#define TUNER_QAM_ACQUIRE_NAME          "tuner_qam_qcquire"
#define TUNER_QAM_ACQUIRE_POLICY      HAL_THREAD_DEFAULT_POLICY
#define TUNER_QAM_ACQUIRE_PRIO          HAL_THREAD_DEFAULT_PRIORITY
#define TUNER_QAM_ACQUIRE_STACK        HAL_THREAD_DEFAULT_STACKSIZE
#define TUNER_QAM_ACQUIRE_DETACH    HAL_THREAD_DEFAULT_DETACHSTATE

/* hid_init.c:HID_Init */
#define HID_ACTIVITY_NAME            "hid_activity"
#define HID_ACTIVITY_POLICY        HAL_THREAD_DEFAULT_POLICY
#define HID_ACTIVITY_PRIO            HAL_THREAD_DEFAULT_PRIORITY
#define HID_ACTIVITY_STACK        HAL_THREAD_DEFAULT_STACKSIZE
#define HID_ACTIVITY_DETACH     HAL_THREAD_DEFAULT_DETACHSTATE

/* mpaud_api.c:HAL_MPAUD_Start */
#define MPAUD_DECODE_LOCK_DETECT_NAME          "mpaud_lck_detect"
#define MPAUD_DECODE_LOCK_DETECT_POLICY      HAL_THREAD_DEFAULT_POLICY
#define MPAUD_DECODE_LOCK_DETECT_PRIO          HAL_THREAD_DEFAULT_PRIORITY
#define MPAUD_DECODE_LOCK_DETECT_STACK      HAL_THREAD_DEFAULT_STACKSIZE
#define MPAUD_DECODE_LOCK_DETECT_DETACH   HAL_THREAD_DEFAULT_DETACHSTATE

/* mpaud_interrupt.c:MPAUD_LaunchIntThread */
#define MPAUD_ISR_NAME          "mpaud_isr"
#define MPAUD_ISR_POLICY      HAL_THREAD_DEFAULT_POLICY
#define MPAUD_ISR_PRIO          HAL_THREAD_DEFAULT_PRIORITY
#define MPAUD_ISR_STACK        HAL_THREAD_DEFAULT_STACKSIZE
#define MPAUD_ISR_DETACH    HAL_THREAD_DEFAULT_DETACHSTATE

/* fpd_init.c:FPD_Init */
#define FPD_TIME_DISP_NAME          "fpd_timedisplay"
#define FPD_TIME_DISP_POLICY      HAL_THREAD_DEFAULT_POLICY
#define FPD_TIME_DISP_PRIO          HAL_THREAD_DEFAULT_PRIORITY
#define FPD_TIME_DISP_STACK        HAL_THREAD_DEFAULT_STACKSIZE
#define FPD_TIME_DISP_DETACH    HAL_THREAD_DEFAULT_DETACHSTATE

/* mpvid_cc_api.c:MPVID_CCInit */
#define MPVID_CC_NOTIFY_NAME          "mpvid_ccnotify"
#define MPVID_CC_NOTIFY_POLICY      HAL_THREAD_DEFAULT_POLICY
#define MPVID_CC_NOTIFY_PRIO          HAL_THREAD_DEFAULT_PRIORITY
#define MPVID_CC_NOTIFY_STACK        HAL_THREAD_DEFAULT_STACKSIZE
#define MPVID_CC_NOTIFY_DETACH    HAL_THREAD_DEFAULT_DETACHSTATE

/* mpvid_interrupt.c:mpvid_start_thread */
#define MPVID_DECODE_STATUS_NAME          "mpvid_decodestatus"
#define MPVID_DECODE_STATUS_POLICY      HAL_THREAD_DEFAULT_POLICY
#define MPVID_DECODE_STATUS_PRIO          HAL_THREAD_DEFAULT_PRIORITY
#define MPVID_DECODE_STATUS_STACK        HAL_THREAD_DEFAULT_STACKSIZE
#define MPVID_DECODE_STATUS_DETACH    HAL_THREAD_DEFAULT_DETACHSTATE


/* VBI_HW.c.c:VBI_HW_open */
#define VBI_SLICER_NAME            "vbi_slicer"
#define VBI_SLICER_POLICY        HAL_THREAD_DEFAULT_POLICY
#define VBI_SLICER_PRIO            HAL_THREAD_DEFAULT_PRIORITY
#define VBI_SLICER_STACK        HAL_THREAD_DEFAULT_STACKSIZE
#define VBI_SLICER_DETACH     HAL_THREAD_DEFAULT_DETACHSTATE

/* irb_init.c:IRB_Init */
#define IRB_ACTIVITY_NAME                  "irb_activity"
#define IRB_ACTIVITY_POLICY                HAL_THREAD_DEFAULT_POLICY
#define IRB_ACTIVITY_PRIO                  HAL_THREAD_DEFAULT_PRIORITY
#define IRB_ACTIVITY_STACK                 HAL_THREAD_DEFAULT_STACKSIZE
#define IRB_ACTIVITY_DETACH                HAL_THREAD_DEFAULT_DETACHSTATE

/* disp_init.c:DISP_Init */
#define DISP_PASSTHRU_NAME               "disp_passthru"
#define DISP_PASSTHRU_POLICY              HAL_THREAD_DEFAULT_POLICY
#define DISP_PASSTHRU_PRIO                HAL_THREAD_DEFAULT_PRIORITY
#define DISP_PASSTHRU_STACK               HAL_THREAD_DEFAULT_STACKSIZE
#define DISP_PASSTHRU_DETACH              HAL_THREAD_DEFAULT_DETACHSTATE


#endif  /* platform */

#endif /* __HAL_PRIO_H__ */
