/*-----------------------------------------------------------------*/
/******************************************************************************
* Copyright (c) 2011 SeaChange International (SeaChange) and its Licensors. 
* All rights reserved.
*
* This software is the confidential and proprietary information of SeaChange
* ("Confidential Information"). You shall not disclose this source code or 
* such Confidential Information and shall use it only in accordance with the 
* terms of the license agreement you entered into.
*  
* SEACHANGE INERNATIONAL  MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE 
* SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT 
* LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A 
* PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SEACHANGE SHALL NOT BE LIABLE FOR 
* ANY DAMAGES SUFFERED BY LICENSEE NOR SHALL THEY BE RESPONSIBLE AS A RESULT 
* OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
*******************************************************************************/


/*-----------------------------------------------------------------*/
#ifndef __VL_CDL_API_H__
#define __VL_CDL_API_H__
/*-----------------------------------------------------------------*/
/*-------------------------------------------------------------------
   Include Files
-------------------------------------------------------------------*/
#include "vl_cdl_types.h"
#include "hal_api.h"
#ifdef __cplusplus
extern "C" {
#endif
/*-------------------------------------------------------------------
   Defines/Macros
-------------------------------------------------------------------*/



/*-------------------------------------------------------------------
   Types/Structs
-------------------------------------------------------------------*/

/*===================================================================
   FUNCTION PROTOTYPES
===================================================================*/

/**
 * Returns CDL capabilities (number of available CDL capable eCMs, etc.) if any.
 * @param pstCapabilities detail of the CDL capabilities.
 *
 * @return 0 for success.
 */
INT32 HAL_CDL_GetCapabilities(VL_CDL_CAPABILITIES_t *pstCapabilities);

/**
 * Request to acquires ownership of a CDL capability.
 * @param hCDLHandle handle of the CDL capability.
 *
 * @return 0 for success.
 */
INT32 HAL_CDL_Request(VL_CDL_DEVICE_HANDLE_t hCDLHandle);

/**
 * Request to release ownership of a CDL capability.
 * @param hCDLHandle handle of the CDL capability.
 *
 * @return 0 for success.
 */
INT32 HAL_CDL_Release(VL_CDL_DEVICE_HANDLE_t hCDLHandle);

/**
 * Registers a callback function with the CDL capability.
 * @param hCDLHandle handle of the CDL capability.
 * @param pfnNotifyFunc the callback function.
 * @param notifyType the type of callback function being registered.
 * @param pulData other data (ignored).
 *
 * @return 0 for success.
 */
INT32 HAL_CDL_SetNotify( VL_CDL_DEVICE_HANDLE_t hCDLHandle, VL_CDL_NOTIFY_TYPE_t notifyType, VL_CDL_VOID_CBFUNC_t pfnNotifyFunc, void* pulData);
int HAL_CDL_notify_mgr_event  ( VL_CDL_DEVICE_HANDLE_t hCDLHandle, VL_CDL_MANAGER_EVENT_TYPE eEvent, unsigned long nEventData);
int HAL_CDL_notify_driver_event(VL_CDL_DRIVER_EVENT_TYPE eEvent, unsigned long nEventData);    
/*-----------------------------------------------------------------*/
#ifdef __cplusplus
}
#endif
/*-----------------------------------------------------------------*/
#endif //__VL_CDL_API_H__
/*-----------------------------------------------------------------*/
