/*
* ============================================================================
* RDK MANAGEMENT, LLC CONFIDENTIAL AND PROPRIETARY
* ============================================================================
* This file (and its contents) are the intellectual property of RDK Management, LLC.
* It may not be used, copied, distributed or otherwise  disclosed in whole or in
* part without the express written permission of RDK Management, LLC.
* ============================================================================
* Copyright (C) 2017 Broadcom. The term "Broadcom" refers to Broadcom Limited and/or its subsidiaries.
* Copyright (c) 2017 RDK Management, LLC. All rights reserved.
* ============================================================================
*/

#ifndef _RMF_OSALMEMMAP_H_
#define _RMF_OSALMEMMAP_H_

// NOTE-1: Re-build ALL when changiing this flag due to unchaged callers' files
// undef #define VL_OSAL_MEMMAP_DEBUG	// compile flag to enable/disable the function

// NOTE-2: The flag is to log number of MAP/UNMAP only in every xx seconds that is specified in the vlResourceRegistrar.cpp file.
// NOTE-3: Re-build ALL when changiing this flag due to unchaged callers' files
#define RMF_OSAL_MEMMAP_RACK_TEST	// compile flag to enable/disable the function

#ifdef __cplusplus
extern "C"
{
#endif
	void rmf_osal_memmap_init();

#ifdef RMF_OSAL_MEMMAP_DEBUG
	#undef OS_MAP_IO_TO_MEM_CACHE
	#undef OS_MAP_IO_TO_MEM_NOCACHE
	#undef OS_MAP_IO_TO_LARGE_MEM_NOCACHE
	#undef OS_UNMAP_IO_FROM_MEM

	#define OS_MAP_IO_TO_MEM_CACHE(base_address, size)			rmf_OsMapIoToMemCache((unsigned long)base_address, size,__FILE__,__FUNCTION__,__LINE__)
	#define OS_MAP_IO_TO_MEM_NOCACHE(base_address, size)		rmf_OsMapIoToMemNocache((unsigned long)base_address, size,__FILE__,__FUNCTION__,__LINE__)
	#define OS_MAP_IO_TO_LARGE_MEM_NOCACHE(base_address, size)	rmf_OsMapIoToLargeMemNocache((unsigned long)base_address, size,__FILE__,__FUNCTION__,__LINE__)
	#define OS_UNMAP_IO_FROM_MEM(virt_address, size)			rmf_OsUnmapIoFromMem((void *)virt_address, size,__FILE__,__FUNCTION__,__LINE__)

	void * rmf_OsMapIoToMemCache (unsigned long base_address, size_t size, char * file, char * function, int line);
	void * rmf_OsMapIoToMemNocache (unsigned long base_address, size_t size, char * file, char * function, int line);
	void * rmf_OsMapIoToLargeMemNocache (unsigned long base_address, size_t size, char * file, char * function, int line);
	  void rmf_OsUnmapIoFromMem (void * virt_address, size_t size, char * file, char * function, int line);
#endif // VL_OSAL_MEMMAP_DEBUG

#ifndef RMF_OSAL_MEMMAP_DEBUG // <-- if NOT defined
	#ifdef RMF_OSAL_MEMMAP_RACK_TEST
		#undef OS_MAP_IO_TO_MEM_CACHE
		#undef OS_MAP_IO_TO_MEM_NOCACHE
		#undef OS_MAP_IO_TO_LARGE_MEM_NOCACHE
		#undef OS_UNMAP_IO_FROM_MEM

		#define OS_MAP_IO_TO_MEM_CACHE(base_address, size)			rmf_OsMapIoToMemCacheRackTest((unsigned long)base_address, size)
		#define OS_MAP_IO_TO_MEM_NOCACHE(base_address, size)		rmf_OsMapIoToMemNocacheRackTest((unsigned long)base_address, size)
		#define OS_MAP_IO_TO_LARGE_MEM_NOCACHE(base_address, size)	rmf_OsMapIoToLargeMemNocacheRackTest((unsigned long)base_address, size)
		#define OS_UNMAP_IO_FROM_MEM(virt_address, size)			rmf_OsUnmapIoFromMemRackTest((void *)virt_address, size)

		void * rmf_OsMapIoToMemCacheRackTest (unsigned long base_address, size_t size);
		void * rmf_OsMapIoToMemNocacheRackTest (unsigned long base_address, size_t size);
		void * rmf_OsMapIoToLargeMemNocacheRackTest (unsigned long base_address, size_t size);
		  void rmf_OsUnmapIoFromMemRackTest (void * virt_address, size_t size);
	#endif // RMF_OSAL_MEMMAP_RACK_TEST
#endif // RMF_OSAL_MEMMAP_DEBUG // <-- if NOT defined

#ifdef __cplusplus
}
#endif

#endif // _RMF_OSALMEMMAP_H_
