/***************************************************************************
 *     (c)2007-2013 Broadcom Corporation
 *
 *  This program is the proprietary software of Broadcom Corporation and/or its licensors,
 *  and may only be used, duplicated, modified or distributed pursuant to the terms and
 *  conditions of a separate, written license agreement executed between you and Broadcom
 *  (an "Authorized License").  Except as set forth in an Authorized License, Broadcom grants
 *  no license (express or implied), right to use, or waiver of any kind with respect to the
 *  Software, and Broadcom expressly reserves all rights in and to the Software and all
 *  intellectual property rights therein.  IF YOU HAVE NO AUTHORIZED LICENSE, THEN YOU
 *  HAVE NO RIGHT TO USE THIS SOFTWARE IN ANY WAY, AND SHOULD IMMEDIATELY
 *  NOTIFY BROADCOM AND DISCONTINUE ALL USE OF THE SOFTWARE.
 *
 *  Except as expressly set forth in the Authorized License,
 *
 *  1.     This program, including its structure, sequence and organization, constitutes the valuable trade
 *  secrets of Broadcom, and you shall use all reasonable efforts to protect the confidentiality thereof,
 *  and to use this information only in connection with your use of Broadcom integrated circuit products.
 *
 *  2.     TO THE MAXIMUM EXTENT PERMITTED BY LAW, THE SOFTWARE IS PROVIDED "AS IS"
 *  AND WITH ALL FAULTS AND BROADCOM MAKES NO PROMISES, REPRESENTATIONS OR
 *  WARRANTIES, EITHER EXPRESS, IMPLIED, STATUTORY, OR OTHERWISE, WITH RESPECT TO
 *  THE SOFTWARE.  BROADCOM SPECIFICALLY DISCLAIMS ANY AND ALL IMPLIED WARRANTIES
 *  OF TITLE, MERCHANTABILITY, NONINFRINGEMENT, FITNESS FOR A PARTICULAR PURPOSE,
 *  LACK OF VIRUSES, ACCURACY OR COMPLETENESS, QUIET ENJOYMENT, QUIET POSSESSION
 *  OR CORRESPONDENCE TO DESCRIPTION. YOU ASSUME THE ENTIRE RISK ARISING OUT OF
 *  USE OR PERFORMANCE OF THE SOFTWARE.
 *
 *  3.     TO THE MAXIMUM EXTENT PERMITTED BY LAW, IN NO EVENT SHALL BROADCOM OR ITS
 *  LICENSORS BE LIABLE FOR (i) CONSEQUENTIAL, INCIDENTAL, SPECIAL, INDIRECT, OR
 *  EXEMPLARY DAMAGES WHATSOEVER ARISING OUT OF OR IN ANY WAY RELATING TO YOUR
 *  USE OF OR INABILITY TO USE THE SOFTWARE EVEN IF BROADCOM HAS BEEN ADVISED OF
 *  THE POSSIBILITY OF SUCH DAMAGES; OR (ii) ANY AMOUNT IN EXCESS OF THE AMOUNT
 *  ACTUALLY PAID FOR THE SOFTWARE ITSELF OR U.S. $1, WHICHEVER IS GREATER. THESE
 *  LIMITATIONS SHALL APPLY NOTWITHSTANDING ANY FAILURE OF ESSENTIAL PURPOSE OF
 *  ANY LIMITED REMEDY.
 *
 ***************************************************************************/
#ifndef __bcmnexus_ir_keycodes_remotea_H__
#define __bcmnexus_ir_keycodes_remotea_H__

#include "bcmnexus_ir_keycodes.h"

/*
** IR receiver key code maps.
**
** The "hwEventCode"s  in the following table are the values generated by the "One For All" remote.
** Note: events were only generated in "home threater" and "cable" modes.
**
** The  "DIKS_xxx" constants are for the basic keyboard mapping (defined in "Directfb_keyboard.h").
** The  "DIKI_xxx" constants are for the advanced keyboard mapping.
*/

static const KeyMapElement IrBasicCodeMap [] =
{
    { DIKI_0,       0x0000 },   /* should these be the DIKI_KP_xxx constants? */
    { DIKI_1,       0xF001 },
    { DIKI_2,       0xE002 },
    { DIKI_3,       0xD003 },
    { DIKI_4,       0xC004 },
    { DIKI_5,       0xB005 },
    { DIKI_6,       0xA006 },
    { DIKI_7,       0x9007 },
    { DIKI_8,       0x8008 },
    { DIKI_9,       0x7009 },
    { DIKI_LEFT,    0x7036 },
    { DIKI_RIGHT,   0x6037 },
    { DIKI_DOWN,    0x8035 },
    { DIKI_UP,      0x9034 },
    { DIKI_ENTER,   0xE011 },        /* the select key on the remote */
    { DIKI_ESCAPE,  0xD012 }         /* the exit key on the remote */
};

static const KeyMapElement IrAdvanCodeMap [] =
{
    { DIKS_0,               0x0000 },
    { DIKS_1,               0xF001 },
    { DIKS_2,               0xE002 },
    { DIKS_3,               0xD003 },
    { DIKS_4,               0xC004 },
    { DIKS_5,               0xB005 },
    { DIKS_6,               0xA006 },
    { DIKS_7,               0x9007 },
    { DIKS_8,               0x8008 },
    { DIKS_9,               0x7009 },
    { DIKS_CURSOR_LEFT,     0x7036 },
    { DIKS_CURSOR_RIGHT,    0x6037 },
    { DIKS_CURSOR_DOWN,     0x8035 },
    { DIKS_CURSOR_UP,       0x9034 },
    { DIKS_CHANNEL_UP,      0x500B },
    { DIKS_CHANNEL_DOWN,    0x400C },
    { DIKS_SELECT,          0xE011 },
    { DIKS_EXIT,            0xD012 },

    /*
        ** The codes below this point were only generated when the remote was in "cable" mode.
        ** Functional key codes
        */
        { DIKS_MENU,            0x6019 }, /* Menu  */
        { DIKS_EPG,         0xD030 }, /* Guide */
        { DIKS_POWER,           0x600A }, /* Power */
        { DIKS_INFO,            0xA033 }, /* Info  */
        { DIKS_MUTE,            0x100F }, /* Mute  */
        { DIKS_REWIND,          0x101E }, /*  <<   */
        { DIKS_PLAY,            0x5038 }, /*  >    */
        { DIKS_FORWARD,         0x201D }, /*  >>   */
        { DIKS_RECORD,          0xC031 }, /*  o    */
        { DIKS_PAUSE,           0x001F }, /*  ||   */
        { DIKS_PREVIOUS,        0x303A }, /* |<<   */
    { DIKS_NEXT,            0x203B }, /*  >>|  */
        { DIKS_STOP,            0x4039 }, /*  []   */
    { DIKS_LAST,            0xC013 }, /* LAST  */
    { DIKS_MODE,            0xB014 }, /* INPUT-TV/VID */

        { DIKS_CUSTOM0,                 0x8026 }, /*  A    */
        { DIKS_CUSTOM1,                 0x9025 }, /*  B    */
        { DIKS_CUSTOM2,                 0xB023 }, /*  C    */
        { DIKS_FAVORITES,               0xA015 }, /*  FAV  */

    { DIKS_VOLUME_UP,       0x300D },
    { DIKS_VOLUME_DOWN,     0x200E },

    { DIKS_ASTERISK,        0x9016 }, /*  *    */
    { DIKS_NUMBER_SIGN,     0xF010 }, /*  #    */
    { DIKS_PIP,             0x8017 }, /*  PIP  */
    { DIKS_SWAP,            0x6028 }, /*  Swap */
    { DIKS_MOVE,            0x7027 }, /*  Move */

    /*
    ** Rectangular silver remote. (URC-8820B00)
    */
    { DIKS_NEXT,            0xE03F }, /* >>| */
    { DIKS_PREVIOUS,        0x103C }, /* |<< */
    { DIKS_ZOOM,            0xF03E }, /* Format */
    { DIKS_SUBTITLE,        0x003D }  /* CC */
};

#endif
