/******************************************************************************
 *    (c)2010-2013 Broadcom Corporation
 *
 * This program is the proprietary software of Broadcom Corporation and/or its licensors,
 * and may only be used, duplicated, modified or distributed pursuant to the terms and
 * conditions of a separate, written license agreement executed between you and Broadcom
 * (an "Authorized License").  Except as set forth in an Authorized License, Broadcom grants
 * no license (express or implied), right to use, or waiver of any kind with respect to the
 * Software, and Broadcom expressly reserves all rights in and to the Software and all
 * intellectual property rights therein.  IF YOU HAVE NO AUTHORIZED LICENSE, THEN YOU
 * HAVE NO RIGHT TO USE THIS SOFTWARE IN ANY WAY, AND SHOULD IMMEDIATELY
 * NOTIFY BROADCOM AND DISCONTINUE ALL USE OF THE SOFTWARE.
 *
 * Except as expressly set forth in the Authorized License,
 *
 * 1.     This program, including its structure, sequence and organization, constitutes the valuable trade
 * secrets of Broadcom, and you shall use all reasonable efforts to protect the confidentiality thereof,
 * and to use this information only in connection with your use of Broadcom integrated circuit products.
 *
 * 2.     TO THE MAXIMUM EXTENT PERMITTED BY LAW, THE SOFTWARE IS PROVIDED "AS IS"
 * AND WITH ALL FAULTS AND BROADCOM MAKES NO PROMISES, REPRESENTATIONS OR
 * WARRANTIES, EITHER EXPRESS, IMPLIED, STATUTORY, OR OTHERWISE, WITH RESPECT TO
 * THE SOFTWARE.  BROADCOM SPECIFICALLY DISCLAIMS ANY AND ALL IMPLIED WARRANTIES
 * OF TITLE, MERCHANTABILITY, NONINFRINGEMENT, FITNESS FOR A PARTICULAR PURPOSE,
 * LACK OF VIRUSES, ACCURACY OR COMPLETENESS, QUIET ENJOYMENT, QUIET POSSESSION
 * OR CORRESPONDENCE TO DESCRIPTION. YOU ASSUME THE ENTIRE RISK ARISING OUT OF
 * USE OR PERFORMANCE OF THE SOFTWARE.
 *
 * 3.     TO THE MAXIMUM EXTENT PERMITTED BY LAW, IN NO EVENT SHALL BROADCOM OR ITS
 * LICENSORS BE LIABLE FOR (i) CONSEQUENTIAL, INCIDENTAL, SPECIAL, INDIRECT, OR
 * EXEMPLARY DAMAGES WHATSOEVER ARISING OUT OF OR IN ANY WAY RELATING TO YOUR
 * USE OF OR INABILITY TO USE THE SOFTWARE EVEN IF BROADCOM HAS BEEN ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGES; OR (ii) ANY AMOUNT IN EXCESS OF THE AMOUNT
 * ACTUALLY PAID FOR THE SOFTWARE ITSELF OR U.S. $1, WHICHEVER IS GREATER. THESE
 * LIMITATIONS SHALL APPLY NOTWITHSTANDING ANY FAILURE OF ESSENTIAL PURPOSE OF
 * ANY LIMITED REMEDY.
 *
 *****************************************************************************/
#ifndef MEDIA_PLAYER_PRIV_H__
#define MEDIA_PLAYER_PRIV_H__

#include "nexus_types.h"
#include "nexus_playback.h"

#ifdef __cplusplus
extern "C" {
#endif

/**
NOTE: This API is only example code. It is subject to change and 
is not supported as a standard reference software deliverable.
**/

/**
Summary:
settings for media_player_create
**/
typedef struct media_player_create_settings
{
    bool decodeVideo;    /* if false, video is ignored */
    unsigned videoId;    /* simple decoder ID */
    bool decodeAudio;    /* if false, audio is ignored */
    unsigned audioId;    /* simple decoder ID */
    unsigned maxWidth, maxHeight;
} media_player_create_settings;

/**
Summary:
settings for media_player_start
**/
typedef struct media_player_start_settings
{
    const char *stream_url; /* required for dvr. if NULL, then live */
    const char *index_url; /* optional */
    unsigned program;
    
    bool loop;
    unsigned int start_position; /* In milliseconds */
    void (*eof)(void *context);
    void *context; /* context for any callbacks */
} media_player_start_settings;

/**
Summary:
Status for media_player
**/
typedef struct media_player_status
{
    bool valid;
    bool has_video;
    bool has_audio;
    unsigned width;
    unsigned height;
} media_player_status;

typedef struct media_player *media_player_t;

/**
Summary:
**/
void media_player_get_default_create_settings_priv( 
    media_player_create_settings *psettings 
    );

/**
Summary:
**/
media_player_t media_player_create_priv( 
    const media_player_create_settings *psettings /* optional */
    );

/**
Summary:
**/
void media_player_get_default_start_settings_priv(
    media_player_start_settings *psettings
    );

/**
Set up playback: performs the probe
**/
int media_player_start_setup_priv(
    media_player_t handle,
    const media_player_start_settings *psettings
    );

/**
Start playback (must have called start_setup first)
**/
int media_player_start_priv(
    media_player_t handle
    );

/**
Summary:
Perform trick mode
**/
int media_player_trick_priv(
    media_player_t handle, 
    int rate /* units are NEXUS_NORMAL_DECODE_RATE. for example:
                0 = pause
                NEXUS_NORMAL_DECODE_RATE = normal play
                2*NEXUS_NORMAL_DECODE_RATE = 2x fast forward
                -3*NEXUS_NORMAL_DECODE_RATE = 3x rewind
                */
    );

/**
Summary:
Seek to new location
**/
int media_player_seek_priv(
    media_player_t handle, 
    unsigned int milliseconds
    );

/**
Summary:
**/
int media_player_get_playback_status_priv( media_player_t handle, NEXUS_PlaybackStatus *pstatus );

/**
Summary:
**/
int media_player_get_status_priv( media_player_t handle, media_player_status *pstatus );

/**
Summary:
**/
void media_player_stop_priv( media_player_t handle );

/**
Summary:
**/
void media_player_destroy_priv( media_player_t handle );

/**
Summary:
**/
NEXUS_SimpleVideoDecoderHandle media_player_get_video_decoder_priv(media_player_t player);

/**
*Get Nexus stream info.
**/
extern NEXUS_Error media_player_get_streaminfo_priv(media_player_t player, NEXUS_VideoDecoderStreamInformation *stream_info);

/**
Summary:
simple standalone probe
**/
#define MAX_PIDS 10
struct probe_results
{
    struct {
        unsigned pid;
        NEXUS_AudioCodec codec;
    } audio[MAX_PIDS];
    unsigned num_audio;
    struct {
        unsigned pid;
        NEXUS_VideoCodec codec;
    } video[MAX_PIDS];
    unsigned num_video;
    NEXUS_TransportType transportType;
    NEXUS_TransportTimestampType timestampType;
};

int probe_media_priv(const char *streamname, const char *indexname, struct probe_results *results);

#ifdef __cplusplus
}
#endif

#endif /* MEDIA_PLAYER_PRIV_H__ */
